(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     48375,       1078]*)
(*NotebookOutlinePosition[     49097,       1103]*)
(*  CellTagsIndexPosition[     49053,       1099]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["MathXLS 2.0.0 Installer", "Subtitle"],

Cell[TextData[{
  StyleBox["Rolf Mertig\nMertig Consulting\nBerlin, Germany\n09-July-2003",
    FontSlant->"Plain"],
  "\n",
  StyleBox[ButtonBox["http://www.mathxls.com",
    ButtonData:>{
      URL[ "http://www.mathxls.com"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Plain"]
}], "Subsubtitle"],

Cell[TextData[{
  "For ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0, 4.1, 4.2 or 5.0"
}], "Text"],

Cell[CellGroupData[{

Cell["Installation Instructions", "Section",
  Editable->False],

Cell[TextData[{
  "This installer should be run as the user who is going to use MathXLS. An \
internet connection should be active.If you do have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 or 4.1 you have to install JLink first, see \
http://www.wolfram.com/solutions/mathlink/jlink for how to do this. If you \
are connected to the Internet through a Proxy Server, set the variables \
$proxyhost and $proxyport before installation.\nThe installer will prompt for \
a password. If you did not purchase a password already, hit the OK button and \
accept the trial passoword. If the trial period is over, go to \
http://www.mathxls.com to get a new version of this installer.",
  "\n",
  "Click below to install MathXLS."
}], "Text",
  Editable->False],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox[\(Install\ MathXLS\),
              "Section",
              ShowStringCharacters->True],
            ButtonFunction:>CompoundExpression[ 
                CompoundExpression[ 
                  Set[ $trialpassword, "Trial2003Q3"], Null], 
                CompoundExpression[ 
                  If[ 
                    ValueQ[ $installdir], 
                    Set[ $mathxlsinstalldir, $installdir], 
                    If[ 
                      Greater[ $VersionNumber, 4.0999999999999996], 
                      Set[ $mathxlsinstalldir, 
                        
                        StringJoin[ $UserAddOnsDirectory, $PathnameSeparator, 
                          "Applications"]], 
                      Set[ $mathxlsinstalldir, 
                        
                        StringJoin[ $TopDirectory, $PathnameSeparator, 
                          "AddOns", $PathnameSeparator, "Applications"]]]], 
                  Null], 
                If[ 
                  Not[ 
                    ValueQ[ MathXLS`$MathXLSPassword]], 
                  If[ 
                    UnsameQ[ 
                      Set[ checkifm, 
                        FileNames[ "MathXLS.m", $Path, 2]], {}], 
                    CompoundExpression[ 
                      Set[ MathXLS`$MathXLSPassword, 
                        ReplaceAll[ 
                          ReadList[ 
                            ToFileName[ {
                              DirectoryName[ 
                                Part[ checkifm, 1]], "Licensing"}, 
                              "mathxlspass"], String], {
                          BlankNullSequence[ ], 
                          Pattern[ last, 
                            Blank[ String]]} :> last]], 
                      If[ 
                        Not[ 
                          StringQ[ MathXLS`$MathXLSPassword]], 
                        Set[ MathXLS`$MathXLSPassword, $trialpassword]]]]], 
                If[ 
                  Not[ 
                    ValueQ[ MathXLS`$MathXLSPassword]], 
                  Set[ MathXLS`$MathXLSPassword, $trialpassword]], 
                CompoundExpression[ 
                  Set[ $installnotes, 
                    NotebookPut[ 
                      Notebook[ {
                        Cell[ 
                          TextData[ "Installation logbook"], "Subtitle"]}, 
                        WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, 
                        StyleDefinitions -> "DemoText.nb"]]], Null], 
                CompoundExpression[ 
                  Set[ thisdir, 
                    Directory[ ]], Null], 
                CompoundExpression[ 
                  If[ 
                    SameQ[ $UserName, "rolf"], 
                    
                    Set[ $source, 
                      "http://192.168.2.100/mathxls/mathxls.zip"]], Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      StringQ[ $source]], 
                    
                    Set[ $source, 
                      "http://www.mathxls.com/download/mathxls.zip"]], Null], 
                
                CompoundExpression[ 
                  SetAttributes[ InstallPrint, HoldAll], Null], 
                CompoundExpression[ 
                  SetDelayed[ InstallQuit, 
                    Condition[ 
                      Quit[ ], 
                      UnsameQ[ $InstallDebug, True]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    InstallPrint[ 
                      Pattern[ a, 
                        BlankSequence[ ]]], 
                    Module[ {}, 
                      CompoundExpression[ 
                        SetSelectedNotebook[ $installnotes], 
                        SelectionMove[ $installnotes, After, Notebook], 
                        NotebookWrite[ $installnotes, 
                          Cell[ 
                            TextData[ {a}], "Text"]]]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    InstallPrint[ 
                      Pattern[ a, 
                        Blank[ Cell]]], 
                    CompoundExpression[ 
                      SetSelectedNotebook[ $installnotes], 
                      SelectionMove[ $installnotes, After, Notebook], 
                      NotebookWrite[ $installnotes, a]]], Null], 
                CompoundExpression[ 
                  If[ 
                    And[ 
                      SameQ[ $MachineID, "7118-06955-91122"], 
                      SameQ[ $UserName, "rolf"]], InstallQuit], Null], 
                CompoundExpression[ 
                  InstallPrint[ 
                    StringJoin[ "installing on : {\"", $MachineID, "\","], 
                    StringJoin[ " \"", $SystemID, "\"}"]], Null], 
                CompoundExpression[ 
                  Needs[ "JLink`"], Null], 
                CompoundExpression[ 
                  Off[ 
                    MessageName[ General, "spell1"]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    jC[ 
                      Pattern[ s, 
                        Blank[ String]]], 
                    ToExpression[ 
                      StringJoin[ "JLink`", s]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    iS[ 
                      Pattern[ s, 
                        Blank[ String]]], 
                    ToExpression[ 
                      StringJoin[ "MathXLS`Installation`", s]]], Null], 
                CompoundExpression[ 
                  Set[ instjava, 
                    jC[ "InstallJava"][ ]], Null], 
                CompoundExpression[ 
                  Set[ checkinstalljava, 
                    jC[ "JavaObjectQ"][ 
                      jC[ "JavaNew"][ "javax.swing.JPanel"]]], Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      TrueQ[ checkinstalljava]], 
                    CompoundExpression[ 
                      InstallPrint[ 
                      "Your JLink installation is not correct. Please check \
that <<JLink`; InstallJava[] does work. Aborting installation."], 
                      Pause[ 1], InstallQuit]], Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      LessEqual[ 4.0, $VersionNumber]], 
                    CompoundExpression[ 
                      InstallPrint[ 
                      "This version of MathXLS does only work on Mathematica \
4.0, 4.1, 4.2 and 5.0. Your version is, however, ", 
                        ToString[ $VersionNumber]], 
                      Pause[ 1], InstallQuit]], Null], 
                CompoundExpression[ 
                  Set[ 
                    Options[ OKBox], RGBColor -> {{0.15294099999999999, 
                    0.79607799999999995, 0.84705900000000001}, {1, 1, 1}}], 
                  Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    OKBox[ 
                      Pattern[ text, 
                        Blank[ String]], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    OKBox[ text, ""]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    OKBox[ 
                      Pattern[ text, 
                        Blank[ String]], 
                      Pattern[ text2, 
                        Blank[ String]], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    ToExpression[ "JLink`JavaBlock"][ 
                      
                      Module[ {frm, buttton, cancelbuttton, col, j, textField,
                         windowListener, butttonListener, okbuttton, panel, 
                        s1, s2, s3, s4, textLabel, textLabel2, wasOKButton}, 
                        CompoundExpression[ 
                          Set[ {s1, s2, s3, s4}, {200, 200, 700, 200}], 
                          Set[ j, ToExpression[ 
                              StringJoin[ "JLink`", #]]&], 
                          Set[ frm, 
                            j[ "JavaNew"][ "com.wolfram.jlink.MathJFrame"]], 
                          Set[ col, 
                            N[ 
                              ReplaceAll[ 
                                ReplaceAll[ RGBColor, {opts}], 
                                Options[ OKBox]]]], 
                          Set[ panel, 
                            j[ "JavaNew"][ "javax.swing.JPanel"]], 
                          panel[ 
                            setLayout[ Null]], 
                          Set[ textLabel, 
                            j[ "JavaNew"][ "javax.swing.JLabel", text]], 
                          Set[ textLabel2, 
                            j[ "JavaNew"][ "javax.swing.JLabel", text2]], 
                          textLabel[ 
                            setBounds[ 15, 15, 
                              Plus[ s3, -50], 50]], 
                          textLabel2[ 
                            setBounds[ 15, 40, 
                              Plus[ s3, -50], 50]], 
                          Set[ okbuttton, 
                            j[ "JavaNew"][ "javax.swing.JButton", "OK"]], 
                          okbuttton[ 
                            setBounds[ 25, 
                              Plus[ s2, -90], 60, 40]], 
                          Set[ cancelbuttton, 
                            j[ "JavaNew"][ "javax.swing.JButton", "Cancel"]], 
                          
                          cancelbuttton[ 
                            setBounds[ 
                              Plus[ s3, -120], 
                              Plus[ s2, -90], 80, 40]], 
                          panel[ 
                            add[ okbuttton]], 
                          panel[ 
                            add[ cancelbuttton]], 
                          panel[ 
                            add[ textLabel]], 
                          panel[ 
                            add[ textLabel2]], 
                          okbuttton[ 
                            addActionListener[ 
                              j[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; True)&"]]], 
                          cancelbuttton[ 
                            addActionListener[ 
                              j[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; False)&"]]], 
                          frm[ 
                            getContentPane[ ][ 
                              add[ panel]]], 
                          frm[ 
                            setSize[ s3, s4]], 
                          okbuttton[ 
                            setBackground[ 
                              j[ "JavaNew"][ "java.awt.Color", 
                                Apply[ Sequence, 
                                  Part[ col, 1]]]]], 
                          cancelbuttton[ 
                            setBackground[ 
                              j[ "JavaNew"][ "java.awt.Color", 
                                Apply[ Sequence, 
                                  Part[ col, 2]]]]], 
                          okbuttton[ 
                            setSelected[ True]], 
                          j[ "JavaShow"][ frm], 
                          Set[ wasOKButton, 
                            j[ "DoModal"][ ]], 
                          frm[ 
                            dispose[ ]], 
                          If[ 
                            TrueQ[ wasOKButton], True, False]]]]], Null], 
                CompoundExpression[ 
                  Set[ 
                    Options[ Unzip], {CharacterEncoding :> $CharacterEncoding,
                     iS[ "Verbose"] -> True}], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    Unzip[ 
                      Pattern[ zipfile, 
                        Blank[ String]], 
                      Optional[ 
                        Pattern[ dir, 
                          Blank[ ]], 
                        Directory[ ]], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    jC[ "JavaBlock"][ 
                      Module[ {enum, 
                        Set[ exdir, dir], saveEntry, startdir, zf, buf}, 
                        CompoundExpression[ 
                          Set[ buf, 
                            jC[ "JavaNew"][ "[B", 10000]], 
                          Set[ startdir, 
                            Directory[ ]], 
                          SetDelayed[ 
                            createdirs[ 
                              Pattern[ di, 
                                Blank[ String]]], 
                            Condition[ 
                              jC[ "JavaBlock"][ 
                                CompoundExpression[ 
                                  jC[ "JavaNew"][ "java.io.File", di][ 
                                    mkdirs[ ]], Null]], 
                              SameQ[ 
                                FileNames[ di], {}]]], 
                          If[ 
                            UnsameQ[ startdir, dir], 
                            CompoundExpression[ 
                              If[ 
                                SameQ[ 
                                  FileNames[ dir], {}], 
                                createdirs[ dir]], 
                              Set[ exdir, 
                                SetDirectory[ dir]]]], 
                          SetDelayed[ 
                            saveEntry[ 
                              Pattern[ zipfi, 
                                Blank[ ]], 
                              Pattern[ zipentry, 
                                Blank[ ]], 
                              Optional[ 
                                Pattern[ characterencoding, 
                                  Blank[ ]], $CharacterEncoding]], 
                            jC[ "JavaBlock"][ 
                              Block[ {bos, 
                                Set[ exdir, extractdir], fi, fos, numRead, 
                                stream, outStream, comments, fromcharcode}, 
                                CompoundExpression[ 
                                  Set[ fi, 
                                    zipentry[ 
                                      getName[ ]]], 
                                  If[ 
                                    zipentry[ 
                                      isDirectory[ ]], 
                                    createdirs[ 
                                      StringJoin[ 
                                      dir, $PathnameSeparator, fi]], 
                                    CompoundExpression[ 
                                      Set[ stream, 
                                        jC[ "JavaNew"][ 
                                        "java.io.BufferedInputStream", 
                                        zipfi[ 
                                        getInputStream[ zipentry]]]], 
                                      Set[ outStream, 
                                        jC[ "JavaNew"][ 
                                        "java.io.BufferedOutputStream", 
                                        jC[ "JavaNew"][ 
                                        "java.io.FileOutputStream", 
                                        StringJoin[ dir, "/", fi]]]], 
                                      While[ 
                                        Greater[ 
                                        Set[ numRead, 
                                        stream[ 
                                        read[ buf]]], 0], 
                                        outStream[ 
                                        write[ buf, 0, numRead]]], 
                                      stream[ 
                                        close[ ]], 
                                      outStream[ 
                                        close[ ]], Null]]]]]], 
                          Set[ zf, 
                            jC[ "JavaNew"][ 
                            "java.util.zip.ZipFile", zipfile]], 
                          Set[ enum, 
                            zf[ 
                              entries[ ]]], 
                          Set[ comments, 
                            ReplaceAll[ 
                              ReplaceAll[ 
                                iS[ "Verbose"], {opts}], 
                              Options[ Unzip]]], 
                          While[ 
                            enum[ 
                              hasMoreElements[ ]], 
                            CompoundExpression[ 
                              Set[ target, 
                                enum[ 
                                  nextElement[ ]]], 
                              If[ comments, 
                                InstallPrint[ 
                                  StringJoin[ 
                                  "extracting: ", exdir, $PathnameSeparator, 
                                    StringReplace[ 
                                      target[ 
                                        getName[ ]], 
                                      "/" -> $PathnameSeparator]]]], 
                              saveEntry[ zf, target]]], 
                          If[ 
                            UnsameQ[ startdir, dir], 
                            SetDirectory[ startdir]], dir]]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    iS[ "CopyRemote"][ 
                      Condition[ 
                        Pattern[ url, 
                          Blank[ String]], 
                        StringMatchQ[ url, "http://*.*", IgnoreCase -> True]],
                       
                      Optional[ 
                        Pattern[ localfile, 
                          Blank[ ]], Automatic], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    jC[ "JavaBlock"][ 
                      
                      Module[ {u, stream, numRead, outFile, buf, prxyHost, 
                        prxyPort}, 
                        CompoundExpression[ 
                          Set[ {prxyHost, prxyPort}, 
                            ReplaceAll[ 
                              ReplaceAll[ {
                                iS[ "ProxyHost"], 
                                iS[ "ProxyPort"]}, 
                                Flatten[ {opts}]], 
                              Options[ 
                                iS[ "CopyRemote"]]]], 
                          jC[ "InstallJava"][ ], 
                          If[ 
                            StringQ[ prxyHost], 
                            jC[ "SetInternetProxy"][ prxyHost, prxyPort]], 
                          Set[ u, 
                            jC[ "JavaNew"][ "java.net.URL", url]], 
                          Set[ stream, 
                            u[ 
                              openStream[ ]]], 
                          If[ 
                            SameQ[ stream, $Failed], 
                            Return[ $Failed]], 
                          Set[ buf, 
                            jC[ "JavaNew"][ "[B", 5000]], 
                          If[ 
                            StringQ[ localfile], 
                            Set[ outFile, 
                              OpenWrite[ localfile, DOSTextFormat -> False]], 
                            
                            CompoundExpression[ 
                              Set[ outFile, 
                                OpenTemporary[ DOSTextFormat -> False]], 
                              Null]], 
                          While[ 
                            Greater[ 
                              Set[ numRead, 
                                stream[ 
                                  read[ buf]]], 0], 
                            WriteString[ outFile, 
                              FromCharacterCode[ 
                                Map[ If[ 
                                    Less[ #, 0], 
                                    Plus[ #, 256], #]&, 
                                  Take[ 
                                    jC[ "Val"][ buf], numRead]]]]], 
                          stream[ 
                            close[ ]], 
                          Close[ outFile]]]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    JavaInput[ 
                      Pattern[ title, 
                        Blank[ String]], 
                      Pattern[ pwd, 
                        Blank[ String]]], 
                    jC[ "JavaBlock"][ 
                      
                      Module[ {frm, buton, textField, butonListener, okbuton, 
                        cancelbuton, w, h, t}, 
                        CompoundExpression[ 
                          Set[ frm, 
                            jC[ "JavaNew"][ "com.wolfram.jlink.MathJFrame"]], 
                          
                          Set[ w, 350], 
                          Set[ h, 
                            Round[ 
                              N[ 
                                Times[ w, 
                                  Power[ GoldenRatio, -1]]]]], 
                          Set[ t, 150], 
                          Set[ cornerleft, 50], 
                          Set[ {okx, oky, cancelx}, {60, 40, 80}], 
                          Set[ panel, 
                            jC[ "JavaNew"][ "javax.swing.JPanel"]], 
                          panel[ 
                            setLayout[ Null]], 
                          Set[ titleLabel, 
                            jC[ "JavaNew"][ "javax.swing.JLabel", title]], 
                          titleLabel[ 
                            setBounds[ 85, 20, 
                              Times[ 2, t], 25]], 
                          Set[ okbuton, 
                            jC[ "JavaNew"][ "javax.swing.JButton", "OK"]], 
                          okbuton[ 
                            setBounds[ cornerleft, 
                              Plus[ h, 
                                Times[ -1, 
                                  Plus[ cornerleft, okx]]], okx, oky]], 
                          Set[ cancelbuton, 
                            jC[ "JavaNew"][ "javax.swing.JButton", "Cancel"]],
                           
                          cancelbuton[ 
                            setBounds[ 
                              Plus[ w, 
                                Times[ -1, cornerleft], 
                                Times[ -1, cancelx]], 
                              Plus[ h, 
                                Times[ -1, 
                                  Plus[ cornerleft, okx]]], cancelx, oky]], 
                          Set[ textField, 
                            jC[ "JavaNew"][ 
                            "javax.swing.JTextField", pwd, 20]], 
                          textField[ 
                            setBounds[ 
                              Round[ 
                                Plus[ 
                                  Times[ w, 
                                    Power[ 2, -1]], 
                                  Times[ -1, t, 
                                    Power[ 2, -1]]]], 50, 
                              Round[ 
                                Times[ 0.80000000000000004, t]], 25]], 
                          panel[ 
                            add[ textField]], 
                          panel[ 
                            add[ okbuton]], 
                          panel[ 
                            add[ cancelbuton]], 
                          panel[ 
                            add[ titleLabel]], 
                          okbuton[ 
                            addActionListener[ 
                              jC[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; True)&"]]], 
                          cancelbuton[ 
                            addActionListener[ 
                              jC[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; False)&"]]], 
                          frm[ 
                            getContentPane[ ][ 
                              add[ panel]]], 
                          frm[ 
                            setSize[ w, h]], 
                          jC[ "JavaShow"][ frm], 
                          frm[ 
                            setModal[ ]], 
                          Set[ wasOKButton, 
                            jC[ "DoModal"][ ]], 
                          frm[ 
                            dispose[ ]], 
                          If[ 
                            TrueQ[ wasOKButton], 
                            Set[ passwd, 
                              textField[ 
                                getText[ ]]], 
                            Set[ passwd, $Failed]]]]]], Null], 
                CompoundExpression[ 
                  Set[ MathXLS`$MathXLSPassword, 
                    JavaInput[ 
                    "Enter the MathXLS password:", MathXLS`$MathXLSPassword]],
                   Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      StringQ[ MathXLS`$MathXLSPassword]], 
                    CompoundExpression[ 
                      InstallPrint[ "Aborting, start again."], InstallQuit]], 
                  Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      StringQ[ $proxyhost]], 
                    Set[ $proxyhost, None]], Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      IntegerQ[ $proxyport]], 
                    Set[ $proxyport, None]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    myEnterPassword[ 
                      Pattern[ pwd, 
                        Blank[ ]]], 
                    Catch[ 
                      Block[ {
                        Set[ thisdir, 
                          Directory[ ]], lic, $licdir}, 
                        CompoundExpression[ 
                          SetDirectory[ 
                            Set[ $licdir, 
                              
                              ToFileName[ {$mathxlsinstalldir, "MathXLS", 
                                "Licensing"}]]], 
                          Set[ lic, 
                            ToExpression[ pwd]], 
                          PutAppend[ lic, 
                            ToFileName[ $licdir, "mathxlspass"]], 
                          If[ 
                            UnsameQ[ 
                              Last[ 
                                ReadList[ 
                                  ToFileName[ $licdir, "mathxlspass"], 
                                  String]], 
                              ToString[ lic]], 
                            Throw[ $Failed], 
                            CompoundExpression[ 
                              InstallPrint[ 
                              "Password successfully installed!"], Null]], 
                          SetDirectory[ thisdir], lic]]]], Null], 
                CompoundExpression[ 
                  Set[ checkifinstall, True], Null], 
                CompoundExpression[ 
                  If[ 
                    UnsameQ[ checkifinstall, True], 
                    CompoundExpression[ 
                      Set[ newinstalldir, 
                        JavaInput[ "Enter your installation directory:", ""]],
                       
                      If[ 
                        StringQ[ newinstalldir], 
                        If[ 
                          SameQ[ 
                            FileNames[ newinstalldir], {}], 
                          CompoundExpression[ 
                            Set[ checkdir, 
                              OKBox[ 
                                StringJoin[ 
                                newinstalldir, 
                                  " does not exist. Create it?"]]], 
                            Set[ crdir, 
                              CreateDirectory[ checkdir]], 
                            If[ 
                              SameQ[ crdir, $Failed], 
                              CompoundExpression[ 
                                OKBox[ 
                                "directory could not be created. Quit and \
retry."], InstallQuit]], 
                            Set[ $mathxlsinstalldir, crdir]]]]]], Null], 
                CompoundExpression[ 
                  If[ 
                    SameQ[ 
                      FileNames[ $mathxlsinstalldir], {}], 
                    CompoundExpression[ 
                      Set[ newinstalldir, 
                        JavaInput[ "Enter your installation directory:", ""]],
                       
                      If[ 
                        StringQ[ newinstalldir], 
                        If[ 
                          SameQ[ 
                            FileNames[ newinstalldir], {}], 
                          CompoundExpression[ 
                            Set[ checkdir, 
                              OKBox[ 
                                StringJoin[ 
                                newinstalldir, 
                                  " does not exist. Create it?"]]], 
                            Set[ crdir, 
                              CreateDirectory[ checkdir]], 
                            If[ 
                              SameQ[ crdir, $Failed], 
                              CompoundExpression[ 
                                OKBox[ 
                                "directory could not be created. Quit and \
retry."], InstallQuit]], 
                            Set[ $mathxlsinstalldir, crdir]]]]]], Null], 
                CompoundExpression[ 
                  If[ 
                    SameQ[ 
                      FileNames[ $mathxlsinstalldir], {}], 
                    CompoundExpression[ 
                      OKBox[ "there is something wrong here. quit."], 
                      InstallQuit]], Null], 
                CompoundExpression[ 
                  SetDirectory[ $mathxlsinstalldir], Null], 
                CompoundExpression[ 
                  InstallPrint[ 
                  "Installing MathLXLS to ", $mathxlsinstalldir], Null], 
                CompoundExpression[ 
                  InstallPrint[ 
                    StringJoin[ 
                    "Downloading a few Megabytes from ", $source, 
                      ". Please be patient and do not interrupt."]], Null], 
                CompoundExpression[ 
                  If[ 
                    SameQ[ 
                      FileNames[ "MathXLS"], {}], 
                    CreateDirectory[ "MathXLS"]], Null], 
                CompoundExpression[ 
                  SetDirectory[ "MathXLS"], Null], 
                CompoundExpression[ 
                  Set[ 
                    iS[ "mdirs"], {"Kernel", "Licensing", "Examples", 
                    "Documentation", "FrontEnd", "Installation"}], Null], 
                CompoundExpression[ 
                  Do[ 
                    If[ 
                      SameQ[ 
                        FileNames[ 
                          Part[ 
                            iS[ "mdirs"], i]], {}], 
                      CreateDirectory[ 
                        Part[ 
                          iS[ "mdirs"], i]]], {i, 
                    Length[ 
                      iS[ "mdirs"]]}], Null], 
                CompoundExpression[ 
                  SetDirectory[ "FrontEnd"], Null], 
                CompoundExpression[ 
                  If[ 
                    SameQ[ 
                      FileNames[ "Palettes"], {}], 
                    CreateDirectory[ "Palettes"]], Null], 
                CompoundExpression[ 
                  Set[ 
                    Options[ 
                      iS[ "CopyRemote"]], {iS[ "ProxyHost"] -> ToExpression[ 
                    "Global`$proxyhost"], iS[ "ProxyPort"] -> ToExpression[ 
                    "Global`$proxyport"]}], Null], 
                CompoundExpression[ 
                  Set[ checkit, 
                    Unzip[ 
                      iS[ "CopyRemote"][ $source], $mathxlsinstalldir]], 
                  Null], 
                CompoundExpression[ 
                  SetDirectory[ thisdir], Null], 
                CompoundExpression[ 
                  If[ 
                    Not[ 
                      MatchQ[ checkit, 
                        Blank[ String]]], 
                    InstallPrint[ 
                    "Installation failed. Please contact \
http://www.mathxls.com for support."], 
                    CompoundExpression[ 
                      InstallPrint[ 
                      " (* ***************************************************\
**** *)"], 
                      InstallPrint[ "Installation of MathXLS finished.\n"], 
                      Set[ pwcheck, 
                        myEnterPassword[ 
                          ToExpression[ "MathXLS`$MathXLSPassword"]]], 
                      If[ 
                        SameQ[ pwcheck, $Failed], 
                        myEnterPassword[ 
                          ToExpression[ "MathXLS`$MathXLSPassword"]]], 
                      If[ 
                        StringMatchQ[ 
                          ToExpression[ "MathXLS`$MathXLSPassword"], 
                          "Trial*"], 
                        CompoundExpression[ 
                          InstallPrint[ 
                          "Until you purchase a license key from"], 
                          InstallPrint[ 
                          "http://www.mathxls.com or http://www.mertig.com"], 
                          
                          InstallPrint[ 
                          "this software will run in trial mode (time \
restrictions apply).\n"], 
                          InstallPrint[ 
                          "You can start MathXLS and open the \
MathXLSUserGuide notebook by evaluating the next input cell:"], Null]], 
                      Off[ 
                        MessageName[ Remove, "rmnsm"]], 
                      InstallPrint[ 
                        Cell[ 
                        "Needs[\"MathXLS`\"];         MathXLS`Help         ", 
                          "Input"]], 
                      SelectionMove[ $installnotes, After, Notebook], 
                      SelectionMove[ $installnotes, Previous, Cell]]], Null], 
                
                CompoundExpression[ InstallQuit, Null]],
            ButtonEvaluator->Automatic,
            Background->RGBColor[0.152941, 0.796078, 0.847059]], 
          ButtonBox[
            StyleBox[\(Uninstall\ MathXLS\),
              "Section",
              ShowStringCharacters->True],
            ButtonFunction:>CompoundExpression[ 
                CompoundExpression[ 
                  Needs[ "JLink`"], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    jC[ 
                      Pattern[ s, 
                        Blank[ String]]], 
                    ToExpression[ 
                      StringJoin[ "JLink`", s]]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    iS[ 
                      Pattern[ s, 
                        Blank[ String]]], 
                    ToExpression[ 
                      StringJoin[ "MathXLS`Installation`", s]]], Null], 
                CompoundExpression[ 
                  jC[ "InstallJava"][ ], Null], 
                CompoundExpression[ 
                  Set[ 
                    Options[ OKBox], RGBColor -> {{0.15294099999999999, 
                    0.79607799999999995, 0.84705900000000001}, {1, 1, 1}}], 
                  Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    OKBox[ 
                      Pattern[ text, 
                        Blank[ String]], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    OKBox[ text, ""]], Null], 
                CompoundExpression[ 
                  SetDelayed[ 
                    OKBox[ 
                      Pattern[ text, 
                        Blank[ String]], 
                      Pattern[ text2, 
                        Blank[ String]], 
                      PatternTest[ 
                        Pattern[ opts, 
                          BlankNullSequence[ ]], OptionQ]], 
                    ToExpression[ "JLink`JavaBlock"][ 
                      
                      Module[ {frm, buttton, cancelbuttton, col, j, textField,
                         windowListener, butttonListener, okbuttton, panel, 
                        s1, s2, s3, s4, textLabel, textLabel2, wasOKButton}, 
                        CompoundExpression[ 
                          Set[ {s1, s2, s3, s4}, {200, 200, 700, 200}], 
                          Set[ j, ToExpression[ 
                              StringJoin[ "JLink`", #]]&], 
                          Set[ frm, 
                            j[ "JavaNew"][ "com.wolfram.jlink.MathJFrame"]], 
                          Set[ col, 
                            N[ 
                              ReplaceAll[ 
                                ReplaceAll[ RGBColor, {opts}], 
                                Options[ OKBox]]]], 
                          Set[ panel, 
                            j[ "JavaNew"][ "javax.swing.JPanel"]], 
                          panel[ 
                            setLayout[ Null]], 
                          Set[ textLabel, 
                            j[ "JavaNew"][ "javax.swing.JLabel", text]], 
                          Set[ textLabel2, 
                            j[ "JavaNew"][ "javax.swing.JLabel", text2]], 
                          textLabel[ 
                            setBounds[ 15, 15, 
                              Plus[ s3, -50], 50]], 
                          textLabel2[ 
                            setBounds[ 15, 40, 
                              Plus[ s3, -50], 50]], 
                          Set[ okbuttton, 
                            j[ "JavaNew"][ "javax.swing.JButton", "OK"]], 
                          okbuttton[ 
                            setBounds[ 25, 
                              Plus[ s2, -90], 60, 40]], 
                          Set[ cancelbuttton, 
                            j[ "JavaNew"][ "javax.swing.JButton", "Cancel"]], 
                          
                          cancelbuttton[ 
                            setBounds[ 
                              Plus[ s3, -120], 
                              Plus[ s2, -90], 80, 40]], 
                          panel[ 
                            add[ okbuttton]], 
                          panel[ 
                            add[ cancelbuttton]], 
                          panel[ 
                            add[ textLabel]], 
                          panel[ 
                            add[ textLabel2]], 
                          okbuttton[ 
                            addActionListener[ 
                              j[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; True)&"]]], 
                          cancelbuttton[ 
                            addActionListener[ 
                              j[ "JavaNew"][ 
                              "com.wolfram.jlink.MathActionListener", 
                                "(EndModal[]; False)&"]]], 
                          frm[ 
                            getContentPane[ ][ 
                              add[ panel]]], 
                          frm[ 
                            setSize[ s3, s4]], 
                          okbuttton[ 
                            setBackground[ 
                              j[ "JavaNew"][ "java.awt.Color", 
                                Apply[ Sequence, 
                                  Part[ col, 1]]]]], 
                          cancelbuttton[ 
                            setBackground[ 
                              j[ "JavaNew"][ "java.awt.Color", 
                                Apply[ Sequence, 
                                  Part[ col, 2]]]]], 
                          okbuttton[ 
                            setSelected[ True]], 
                          j[ "JavaShow"][ frm], 
                          Set[ wasOKButton, 
                            j[ "DoModal"][ ]], 
                          frm[ 
                            dispose[ ]], 
                          If[ 
                            TrueQ[ wasOKButton], True, False]]]]], Null], 
                CompoundExpression[ 
                  If[ 
                    Greater[ $VersionNumber, 4.0999999999999996], 
                    Set[ $mathxlsinstalldir, 
                      
                      StringJoin[ $UserAddOnsDirectory, $PathnameSeparator, 
                        "Applications"]], 
                    Set[ $mathxlsinstalldir, 
                      
                      StringJoin[ $TopDirectory, $PathnameSeparator, 
                        "AddOns", $PathnameSeparator, "Applications"]]], 
                  Null], 
                CompoundExpression[ 
                  Set[ notinstalledflag, False], Null], 
                CompoundExpression[ 
                  If[ 
                    Greater[ $VersionNumber, 4.0999999999999996], 
                    Set[ $mathxlsinstalldir, 
                      
                      StringJoin[ $UserAddOnsDirectory, $PathnameSeparator, 
                        "Applications"]], 
                    Set[ $mathxlsinstalldir, 
                      
                      StringJoin[ $TopDirectory, $PathnameSeparator, 
                        "AddOns", $PathnameSeparator, "Applications"]]], 
                  Null], 
                CompoundExpression[ 
                  SetDelayed[ InstallQuit, 
                    Condition[ 
                      Quit[ ], 
                      UnsameQ[ $InstallDebug, True]]], Null], 
                CompoundExpression[ 
                  If[ 
                    UnsameQ[ 
                      FileNames[ 
                        
                        ToFileName[ {$mathxlsinstalldir, "MathXLS"}, 
                          "MathXLS.m"]], {}], 
                    CompoundExpression[ 
                      Set[ reallyreally, 
                        OKBox[ "Are you sure to remove", 
                          StringJoin[ "   ", 
                            ToFileName[ {$mathxlsinstalldir, "MathXLS"}], 
                            " ?"]]], 
                      If[ 
                        TrueQ[ reallyreally], 
                        DeleteDirectory[ 
                          ToFileName[ {$mathxlsinstalldir, "MathXLS"}], 
                          DeleteContents -> True]]], Null, 
                    If[ 
                      Set[ checkall, 
                        UnsameQ[ 
                          FileNames[ "MathXLS.m", $Path, 2], {}]], 
                      CompoundExpression[ 
                        Set[ checkdirs, 
                          Map[ DirectoryName, checkall]], 
                        If[ 
                          StringMatchQ[ checkall, 
                            StringJoin[ "*MathXLS", $PathnameSeparator]], 
                          Times[ OKBox[ "Are you sure to remove", #]&, 
                            Power[ checkdirs, -1]]]], 
                      CompoundExpression[ 
                        Set[ notinstalledflag, True], 
                        OKBox[ "MathXLS is not installed on your computer."], 
                        Null]]], Null], 
                CompoundExpression[ 
                  If[ 
                    UnsameQ[ notinstalledflag, True], 
                    If[ 
                      SameQ[ 
                        FileNames[ 
                          
                          ToFileName[ {$mathxlsinstalldir, "MathXLS"}, 
                            "MathXLS.m"]], {}], 
                      CompoundExpression[ 
                        OKBox[ "MathXLS has been successfully uninstalled."], 
                        InstallQuit]]], Null]],
            ButtonEvaluator->Automatic,
            Background->RGBColor[0.152941, 0.796078, 0.847059]]}
        },
      RowSpacings->0]], NotebookDefault,
  Active->True,
  GridBoxOptions->{ColumnSpacings->9.2,
  ColumnWidths->16}]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
WindowSize->{838, 630},
WindowMargins->{{375, Automatic}, {133, Automatic}},
StyleDefinitions -> "DemoText.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 43, 0, 41, "Subtitle"],
Cell[1800, 53, 308, 9, 130, "Subsubtitle"],
Cell[2111, 64, 115, 5, 28, "Text"],

Cell[CellGroupData[{
Cell[2251, 73, 63, 1, 54, "Section"],
Cell[2317, 76, 770, 15, 142, "Text"],
Cell[3090, 93, 45269, 982, 37, NotebookDefault]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

