(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    317116,       9753]*)
(*NotebookOutlinePosition[    318269,       9792]*)
(*  CellTagsIndexPosition[    318108,       9784]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Yield curve data", "Section"],

Cell[BoxData[
    \(<< "\<MathXLS`\>"\)], "Input"],

Cell[TextData[ButtonBox["http://www.bankofengland.co.uk/statistics/yieldcurve/\
ukreal0002.xls",
  ButtonData:>{
    URL[ "http://www.bankofengland.co.uk/statistics/yieldcurve/ukreal0002.\
xls"], None},
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileByteCount[
      ToFileName[{$MathXLSDir, "\<Examples\>"}, "\<ukreal0002.xls\>"]]\)], \
"Input"],

Cell[BoxData[
    \(2348544\)], "Output"]
}, Open  ]],

Cell["\<\
The xls file is around 2 MBytes. Reading it in takes around 16 \
seconds on a 1 GHz Linux computer):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TotalTiming[
        r = ImportXLS["\<ukreal0002.xls\>"]; ]\)[\([\)\(1\)\(]\)]\)], "Input"],

Cell[BoxData[
    \("22 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[r]\)], "Input"],

Cell[BoxData[
    \(5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(List @@ \(Head /@ r\)\)], "Input"],

Cell[BoxData[
    \({Sheet[1, "info"], Sheet[2, "1. real fwds, short end"], 
      Sheet[3, "2.  real fwd curve"], Sheet[4, "3. real spot, short end"], 
      Sheet[5, "4.  real spot curve"]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[r\[LeftDoubleBracket]1\[RightDoubleBracket], 
      StringCutOff \[Rule] 111]\)], "Input"],

Cell[BoxData[GridBox[{
        {"#1", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"Bank of England UK yield curve data\"\>"},
        {
          StyleBox["2",
            FontWeight->"Bold"], "\<\"\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"For documentation and descriptions, see the \
statistics/yield curve area of the\"\>"},
        {
          StyleBox["4",
            
            FontWeight->
              "Bold"], "\<\"Bank of England website at \
www.bankofengland.co.uk.\"\>"},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"Every effort has been made to ensure this \
information is correct but we can not \"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"in any way guarantee its accuracy and you use it \
entirely at your own risk.\"\>"}
        },
      ColumnAlignments->{Center, Left},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"info"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<ToList\>", LongForm \[Rule] False]\)], "Input"],

Cell[BoxData[
    \("ToList[Workbook[][Sheet[][...]]] returns a list of matrices. ToList is \
also an option to ImportXLS."\)], "Print",
  CellTags->"Info3266764216-5494681"]
}, Open  ]],

Cell[BoxData[
    \(yielddata = Rest[ToList[r]]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sheetdims = Dimensions /@ yielddata\)], "Input"],

Cell[BoxData[
    \({{787, 37}, {787, 47}, {787, 37}, {787, 47}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(emptycells = Count[yielddata, Null, \(-1\)]\)], "Input"],

Cell[BoxData[
    \(17388\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(numberofcells = Apply[Times, sheetdims, {1}]\)], "Input"],

Cell[BoxData[
    \({29119, 36989, 29119, 36989}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(allcells = Plus @@ numberofcells\)], "Input"],

Cell[BoxData[
    \(132216\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShortXLS[r\[LeftDoubleBracket]2\[RightDoubleBracket]]\)], "Input"],

Cell[BoxData[GridBox[{
        {"#2", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["X",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Y",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Z",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AA",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AB",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AC",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AD",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AE",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AF",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AG",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AH",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AI",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AJ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AK",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"UK instantaneous real forward curve, \
short end\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\
\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"Maturity\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"months:\"\>", 
          StyleBox["25",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["26",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["27",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["28",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["34",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["35",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["39",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["41",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["43",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["44",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["45",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["47",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["48",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["50",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["51",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["56",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["57",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["58",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["60",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"years:\"\>", 
          StyleBox["2.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.167",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.25",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.417",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.583",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.667",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.833",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.083",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.167",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.25",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.417",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.583",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.667",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.833",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.083",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.167",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.25",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.417",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.583",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.67",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.83",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"03-Jan-2000\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"04-Jan-2000\"\>", 
          StyleBox["2.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.81",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.64",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.56",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.42",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.26",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.18",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"05-Jan-2000\"\>", 
          StyleBox["2.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.89",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.62",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.54",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.47",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.41",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.35",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.25",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"06-Jan-2000\"\>", 
          StyleBox["2.18",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.88",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.78",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.61",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.54",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.47",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.34",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"07-Jan-2000\"\>", 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.94",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.74",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.57",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.42",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.04",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>"},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"18-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"19-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"20-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"23-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"24-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"25-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"26-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"27-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"30-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"31-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"1. real fwds, short end"]
}, Open  ]],

Cell[BoxData[
    \(dates = 
      SubVector[
        r\[LeftDoubleBracket]2\[RightDoubleBracket], "\<a7:a\[Infinity]\>"]; \
\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      SubVector[
        r\[LeftDoubleBracket]2\[RightDoubleBracket], {{7, 1}, {9, 
            1}}]]\)], "Input"],

Cell["\<\
{DateList[{2000, 1, 4, 0, 0, 0.}], DateList[{2000, 1, 5, 0, 0, \
0.}], DateList[{2000, 1, 6, 0, 0, 0.}]}\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[
      SubVector[
        r\[LeftDoubleBracket]2\[RightDoubleBracket], {{7, 1}, {10\^3, 
            1}}]]\)], "Input"],

Cell[BoxData[
    \(781\)], "Output"]
}, Open  ]],

Cell["\<\
Construct a function maturitymonth[i] where maturitymonth[25] \
extracts column B, maturitymonth[26] column C, etc. .\
\>", "Text"],

Cell[BoxData[
    \(maturitymonth[i_] := 
      SubVector[
          r\[LeftDoubleBracket]2\[RightDoubleBracket], {{7, i - 23}, {10\^3, 
              i - 23}}] /. \[InvisibleSpace]Null \[Rule] 0; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[XLSListPlot]\)], "Input"],

Cell[BoxData[
    \({HorizontalTickStart \[Rule] 0.15`, NumberOfHorizontalTicks \[Rule] 4, 
      Replace \[Rule] {DateList[
              C_List] \[RuleDelayed] \(DateToString["DD-MMM-YY", "English"]\)[
              C]}, TickStringFunction \[Rule] Identity}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[
      ToMatrix[r\[LeftDoubleBracket]2\[RightDoubleBracket]]]\)], "Input"],

Cell[BoxData[
    \({787, 37}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XLSListPlot[Thread[{dates, maturitymonth[25]}], 
      NumberOfHorizontalTicks \[Rule] 3, ImageSize \[Rule] 300]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 300 185.41 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.00121944 0.0147151 0.197518 [
[.16648 .00222 -34.3438 -11.375 ]
[.16648 .00222 34.3438 0 ]
[.48354 .00222 -34.3438 -11.375 ]
[.48354 .00222 34.3438 0 ]
[.80059 .00222 -34.3438 -11.375 ]
[.80059 .00222 34.3438 0 ]
[.01131 .11347 -21.6 -5.4 ]
[.01131 .11347 0 5.4 ]
[.01131 .21223 -7.2 -5.4 ]
[.01131 .21223 0 5.4 ]
[.01131 .31099 -21.6 -5.4 ]
[.01131 .31099 0 5.4 ]
[.01131 .40975 -7.2 -5.4 ]
[.01131 .40975 0 5.4 ]
[.01131 .50851 -21.6 -5.4 ]
[.01131 .50851 0 5.4 ]
[.01131 .60727 -7.2 -5.4 ]
[.01131 .60727 0 5.4 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16648 .01472 m
.16648 .02097 L
s
gsave
.16648 .00222 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(00) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.48354 .01472 m
.48354 .02097 L
s
gsave
.48354 .00222 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(13) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.80059 .01472 m
.80059 .02097 L
s
gsave
.80059 .00222 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(02) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
1 .01472 L
s
.02381 .11347 m
.03006 .11347 L
s
[(0.5)] .01131 .11347 1 0 Mshowa
.02381 .21223 m
.03006 .21223 L
s
[(1)] .01131 .21223 1 0 Mshowa
.02381 .31099 m
.03006 .31099 L
s
[(1.5)] .01131 .31099 1 0 Mshowa
.02381 .40975 m
.03006 .40975 L
s
[(2)] .01131 .40975 1 0 Mshowa
.02381 .50851 m
.03006 .50851 L
s
[(2.5)] .01131 .50851 1 0 Mshowa
.02381 .60727 m
.03006 .60727 L
s
[(3)] .01131 .60727 1 0 Mshowa
.125 Mabswid
.02381 .03447 m
.02756 .03447 L
s
.02381 .05422 m
.02756 .05422 L
s
.02381 .07397 m
.02756 .07397 L
s
.02381 .09372 m
.02756 .09372 L
s
.02381 .13323 m
.02756 .13323 L
s
.02381 .15298 m
.02756 .15298 L
s
.02381 .17273 m
.02756 .17273 L
s
.02381 .19248 m
.02756 .19248 L
s
.02381 .23198 m
.02756 .23198 L
s
.02381 .25174 m
.02756 .25174 L
s
.02381 .27149 m
.02756 .27149 L
s
.02381 .29124 m
.02756 .29124 L
s
.02381 .33074 m
.02756 .33074 L
s
.02381 .3505 m
.02756 .3505 L
s
.02381 .37025 m
.02756 .37025 L
s
.02381 .39 m
.02756 .39 L
s
.02381 .4295 m
.02756 .4295 L
s
.02381 .44925 m
.02756 .44925 L
s
.02381 .46901 m
.02756 .46901 L
s
.02381 .48876 m
.02756 .48876 L
s
.02381 .52826 m
.02756 .52826 L
s
.02381 .54801 m
.02756 .54801 L
s
.02381 .56777 m
.02756 .56777 L
s
.02381 .58752 m
.02756 .58752 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02503 .45321 Mdot
.02625 .44925 Mdot
.02747 .4453 Mdot
.02869 .43938 Mdot
.02991 .43543 Mdot
.03113 .4295 Mdot
.03235 .43345 Mdot
.03357 .44135 Mdot
.03478 .4453 Mdot
.036 .44925 Mdot
.03722 .46506 Mdot
.03844 .48678 Mdot
.03966 .49863 Mdot
.04088 .50456 Mdot
.0421 .51049 Mdot
.04332 .51839 Mdot
.04454 .51641 Mdot
.04576 .53419 Mdot
.04698 .54406 Mdot
.0482 .54801 Mdot
.04942 .54011 Mdot
.05064 .54011 Mdot
.05186 .54406 Mdot
.05308 .54406 Mdot
.0543 .54406 Mdot
.05551 .54406 Mdot
.05673 .54011 Mdot
.05795 .53419 Mdot
.05917 .53221 Mdot
.06039 .53221 Mdot
.06161 .54406 Mdot
.06283 .55196 Mdot
.06405 .54604 Mdot
.06527 .55196 Mdot
.06649 .55591 Mdot
.06771 .55591 Mdot
.06893 .55789 Mdot
.07015 .56184 Mdot
.07137 .56184 Mdot
.07259 .56382 Mdot
.07381 .56382 Mdot
.07503 .55591 Mdot
.07625 .54406 Mdot
.07746 .53814 Mdot
.07868 .53814 Mdot
.0799 .54011 Mdot
.08112 .53814 Mdot
.08234 .54406 Mdot
.08356 .54406 Mdot
.08478 .54406 Mdot
.086 .54801 Mdot
.08722 .53814 Mdot
.08844 .53616 Mdot
.08966 .53221 Mdot
.09088 .53221 Mdot
.0921 .52826 Mdot
.09332 .55789 Mdot
.09454 .56579 Mdot
.09576 .56777 Mdot
.09698 .57369 Mdot
.0982 .57567 Mdot
.09941 .58357 Mdot
.10063 .59147 Mdot
.10185 .59739 Mdot
.10307 .59147 Mdot
.10429 .59937 Mdot
.10551 .59542 Mdot
.10673 .59344 Mdot
.10795 .58554 Mdot
.10917 .57764 Mdot
.11039 .57172 Mdot
.11161 .56974 Mdot
.11283 .56579 Mdot
.11405 .55986 Mdot
.11527 .55591 Mdot
.11649 .54999 Mdot
.11771 .55196 Mdot
.11893 .55196 Mdot
.12015 .01472 Mdot
.12136 .01472 Mdot
.12258 .55394 Mdot
.1238 .01472 Mdot
.12502 .01472 Mdot
.12624 .01472 Mdot
.12746 .01472 Mdot
.12868 .01472 Mdot
.1299 .01472 Mdot
.13112 .01472 Mdot
.13234 .01472 Mdot
.13356 .01472 Mdot
.13478 .01472 Mdot
.136 .01472 Mdot
.13722 .01472 Mdot
.13844 .01472 Mdot
.13966 .01472 Mdot
.14088 .01472 Mdot
.14209 .01472 Mdot
.14331 .01472 Mdot
.14453 .01472 Mdot
.14575 .01472 Mdot
.14697 .01472 Mdot
.14819 .01472 Mdot
.14941 .01472 Mdot
.15063 .01472 Mdot
.15185 .01472 Mdot
.15307 .01472 Mdot
.15429 .01472 Mdot
.15551 .01472 Mdot
.15673 .01472 Mdot
.15795 .01472 Mdot
.15917 .01472 Mdot
.16039 .01472 Mdot
.16161 .01472 Mdot
.16283 .01472 Mdot
.16404 .01472 Mdot
.16526 .01472 Mdot
.16648 .01472 Mdot
.1677 .01472 Mdot
.16892 .01472 Mdot
.17014 .01472 Mdot
.17136 .01472 Mdot
.17258 .01472 Mdot
.1738 .01472 Mdot
.17502 .01472 Mdot
.17624 .01472 Mdot
.17746 .01472 Mdot
.17868 .01472 Mdot
.1799 .01472 Mdot
.18112 .01472 Mdot
.18234 .01472 Mdot
.18356 .01472 Mdot
.18478 .01472 Mdot
.18599 .01472 Mdot
.18721 .01472 Mdot
.18843 .01472 Mdot
.18965 .01472 Mdot
.19087 .01472 Mdot
.19209 .01472 Mdot
.19331 .01472 Mdot
.19453 .01472 Mdot
.19575 .01472 Mdot
.19697 .01472 Mdot
.19819 .01472 Mdot
.19941 .01472 Mdot
.20063 .01472 Mdot
.20185 .01472 Mdot
.20307 .01472 Mdot
.20429 .01472 Mdot
.20551 .01472 Mdot
.20673 .01472 Mdot
.20794 .01472 Mdot
.20916 .01472 Mdot
.21038 .01472 Mdot
.2116 .01472 Mdot
.21282 .01472 Mdot
.21404 .01472 Mdot
.21526 .01472 Mdot
.21648 .01472 Mdot
.2177 .01472 Mdot
.21892 .01472 Mdot
.22014 .01472 Mdot
.22136 .01472 Mdot
.22258 .01472 Mdot
.2238 .01472 Mdot
.22502 .01472 Mdot
.22624 .01472 Mdot
.22746 .01472 Mdot
.22868 .51641 Mdot
.22989 .51641 Mdot
.23111 .01472 Mdot
.23233 .52234 Mdot
.23355 .52234 Mdot
.23477 .52431 Mdot
.23599 .52629 Mdot
.23721 .52431 Mdot
.23843 .52629 Mdot
.23965 .52826 Mdot
.24087 .53221 Mdot
.24209 .53419 Mdot
.24331 .53419 Mdot
.24453 .52826 Mdot
.24575 .53419 Mdot
.24697 .53024 Mdot
.24819 .53221 Mdot
.24941 .53419 Mdot
.25062 .53814 Mdot
.25184 .53814 Mdot
.25306 .53616 Mdot
.25428 .53221 Mdot
.2555 .53419 Mdot
.25672 .53221 Mdot
.25794 .53221 Mdot
.25916 .53221 Mdot
.26038 .53221 Mdot
.2616 .53419 Mdot
.26282 .53616 Mdot
.26404 .54011 Mdot
.26526 .53814 Mdot
.26648 .53814 Mdot
.2677 .53616 Mdot
.26892 .53419 Mdot
.27014 .52826 Mdot
.27136 .52629 Mdot
.27257 .51839 Mdot
.27379 .51839 Mdot
.27501 .52826 Mdot
.27623 .53024 Mdot
.27745 .53024 Mdot
.27867 .53419 Mdot
.27989 .54011 Mdot
.28111 .54406 Mdot
.28233 .54011 Mdot
.28355 .53814 Mdot
.28477 .53814 Mdot
.28599 .53616 Mdot
.28721 .53814 Mdot
.28843 .53616 Mdot
.28965 .53024 Mdot
.29087 .53221 Mdot
.29209 .52431 Mdot
.29331 .52234 Mdot
.29452 .52234 Mdot
.29574 .53024 Mdot
.29696 .53024 Mdot
.29818 .53024 Mdot
.2994 .52826 Mdot
.30062 .52234 Mdot
.30184 .50654 Mdot
.30306 .50654 Mdot
.30428 .52234 Mdot
.3055 .52234 Mdot
.30672 .51641 Mdot
.30794 .51246 Mdot
.30916 .50851 Mdot
.31038 .50654 Mdot
.3116 .50258 Mdot
.31282 .49666 Mdot
.31404 .49666 Mdot
.31526 .49468 Mdot
.31647 .49468 Mdot
.31769 .49468 Mdot
.31891 .49073 Mdot
.32013 .48678 Mdot
.32135 .48678 Mdot
.32257 .48678 Mdot
.32379 .48678 Mdot
.32501 .48678 Mdot
.32623 .49073 Mdot
.32745 .48086 Mdot
.32867 .48283 Mdot
.32989 .48283 Mdot
.33111 .47493 Mdot
.33233 .47493 Mdot
.33355 .47691 Mdot
.33477 .01472 Mdot
.33599 .01472 Mdot
.33721 .47493 Mdot
.33842 .47493 Mdot
.33964 .47296 Mdot
.34086 .01472 Mdot
.34208 .47296 Mdot
.3433 .47493 Mdot
.34452 .47691 Mdot
.34574 .47691 Mdot
.34696 .48086 Mdot
.34818 .47888 Mdot
.3494 .46506 Mdot
.35062 .46506 Mdot
.35184 .46308 Mdot
.35306 .46308 Mdot
.35428 .46506 Mdot
.3555 .46506 Mdot
.35672 .46506 Mdot
.35794 .46506 Mdot
.35915 .46506 Mdot
.36037 .46703 Mdot
.36159 .46901 Mdot
.36281 .46703 Mdot
.36403 .46901 Mdot
.36525 .46703 Mdot
.36647 .46506 Mdot
.36769 .46506 Mdot
.36891 .47098 Mdot
.37013 .47493 Mdot
.37135 .47493 Mdot
.37257 .47493 Mdot
.37379 .47493 Mdot
.37501 .47691 Mdot
.37623 .47493 Mdot
.37745 .47296 Mdot
.37867 .47098 Mdot
.37989 .47296 Mdot
.3811 .47888 Mdot
.38232 .48086 Mdot
.38354 .48283 Mdot
.38476 .48678 Mdot
.38598 .48876 Mdot
.3872 .49271 Mdot
.38842 .49073 Mdot
.38964 .49863 Mdot
.39086 .50061 Mdot
.39208 .51839 Mdot
.3933 .52036 Mdot
.39452 .52234 Mdot
.39574 .52629 Mdot
.39696 .52826 Mdot
.39818 .53419 Mdot
.3994 .53419 Mdot
.40062 .53616 Mdot
.40184 .53419 Mdot
.40305 .53024 Mdot
.40427 .53024 Mdot
.40549 .54999 Mdot
.40671 .54209 Mdot
.40793 .54406 Mdot
.40915 .54406 Mdot
.41037 .54209 Mdot
.41159 .53616 Mdot
.41281 .53221 Mdot
.41403 .53419 Mdot
.41525 .53814 Mdot
.41647 .55591 Mdot
.41769 .57764 Mdot
.41891 .58554 Mdot
.42013 .58554 Mdot
.42135 .59147 Mdot
.42257 .58752 Mdot
.42379 .58159 Mdot
.425 .57567 Mdot
.42622 .57369 Mdot
.42744 .57962 Mdot
.42866 .58949 Mdot
.42988 .59344 Mdot
.4311 .01472 Mdot
.43232 .01472 Mdot
.43354 .59739 Mdot
.43476 .59937 Mdot
.43598 .59344 Mdot
.4372 .58949 Mdot
.43842 .58357 Mdot
.43964 .58357 Mdot
.44086 .58554 Mdot
.44208 .59542 Mdot
.4433 .59739 Mdot
.44452 .60332 Mdot
.44574 .59542 Mdot
.44695 .59147 Mdot
.44817 .58752 Mdot
.44939 .57764 Mdot
.45061 .01472 Mdot
.45183 .57962 Mdot
.45305 .57369 Mdot
.45427 .57567 Mdot
.45549 .56974 Mdot
.45671 .56974 Mdot
.45793 .57567 Mdot
.45915 .57172 Mdot
.46037 .57369 Mdot
.46159 .58159 Mdot
.46281 .58159 Mdot
.46403 .57962 Mdot
.46525 .57764 Mdot
.46647 .58357 Mdot
.46768 .59344 Mdot
.4689 .01472 Mdot
.47012 .59937 Mdot
.47134 .60332 Mdot
.47256 .60134 Mdot
.47378 .59542 Mdot
.475 .59147 Mdot
.47622 .59147 Mdot
.47744 .58357 Mdot
.47866 .57962 Mdot
.47988 .57962 Mdot
.4811 .58159 Mdot
.48232 .59344 Mdot
.48354 .59147 Mdot
.48476 .59147 Mdot
.48598 .59147 Mdot
.4872 .58752 Mdot
.48842 .58554 Mdot
.48963 .57962 Mdot
.49085 .58554 Mdot
.49207 .57962 Mdot
.49329 .57764 Mdot
.49451 .57369 Mdot
.49573 .57567 Mdot
.49695 .58949 Mdot
.49817 .59344 Mdot
.49939 .59344 Mdot
.50061 .59147 Mdot
.50183 .58949 Mdot
.50305 .58357 Mdot
.50427 .57962 Mdot
.50549 .57764 Mdot
.50671 .57567 Mdot
.50793 .57567 Mdot
.50915 .57962 Mdot
.51037 .58159 Mdot
.51158 .58357 Mdot
.5128 .58357 Mdot
.51402 .56382 Mdot
.51524 .57369 Mdot
.51646 .57567 Mdot
.51768 .57567 Mdot
.5189 .58357 Mdot
.52012 .59147 Mdot
.52134 .59147 Mdot
.52256 .58949 Mdot
.52378 .58357 Mdot
.525 .56974 Mdot
.52622 .56777 Mdot
.52744 .55394 Mdot
.52866 .53616 Mdot
.52988 .53221 Mdot
.5311 .53221 Mdot
.53232 .53024 Mdot
.53353 .51444 Mdot
.53475 .51641 Mdot
.53597 .51444 Mdot
.53719 .51839 Mdot
.53841 .52826 Mdot
.53963 .52826 Mdot
.54085 .52036 Mdot
.54207 .52234 Mdot
.54329 .52431 Mdot
.54451 .52629 Mdot
.54573 .52431 Mdot
.54695 .52629 Mdot
.54817 .01472 Mdot
.54939 .52629 Mdot
.55061 .52431 Mdot
.55183 .52234 Mdot
.55305 .51839 Mdot
.55426 .51246 Mdot
.55548 .52826 Mdot
.5567 .53814 Mdot
.55792 .53419 Mdot
.55914 .52629 Mdot
.56036 .52826 Mdot
.56158 .52234 Mdot
.5628 .52036 Mdot
.56402 .53221 Mdot
.56524 .53616 Mdot
.56646 .53814 Mdot
.56768 .54209 Mdot
.5689 .54209 Mdot
.57012 .53616 Mdot
.57134 .52431 Mdot
.57256 .50851 Mdot
.57378 .50851 Mdot
.575 .51641 Mdot
.57621 .53221 Mdot
.57743 .53419 Mdot
.57865 .53814 Mdot
.57987 .54604 Mdot
.58109 .53419 Mdot
.58231 .53616 Mdot
.58353 .53616 Mdot
.58475 .53419 Mdot
.58597 .54209 Mdot
.58719 .54209 Mdot
.58841 .54406 Mdot
.58963 .53616 Mdot
.59085 .53024 Mdot
.59207 .52431 Mdot
.59329 .51839 Mdot
.59451 .52234 Mdot
.59573 .52431 Mdot
.59695 .52431 Mdot
.59816 .52629 Mdot
.59938 .50061 Mdot
.6006 .48876 Mdot
.60182 .49863 Mdot
.60304 .49666 Mdot
.60426 .48678 Mdot
.60548 .47493 Mdot
.6067 .46901 Mdot
.60792 .47098 Mdot
.60914 .46111 Mdot
.61036 .45716 Mdot
.61158 .4453 Mdot
.6128 .43345 Mdot
.61402 .42753 Mdot
.61524 .42358 Mdot
.61646 .4295 Mdot
.61768 .44728 Mdot
.6189 .47493 Mdot
.62011 .47691 Mdot
.62133 .47888 Mdot
.62255 .48481 Mdot
.62377 .49468 Mdot
.62499 .49073 Mdot
.62621 .49073 Mdot
.62743 .49468 Mdot
.62865 .51839 Mdot
.62987 .51049 Mdot
.63109 .50851 Mdot
.63231 .50061 Mdot
.63353 .49073 Mdot
.63475 .48876 Mdot
.63597 .50258 Mdot
.63719 .51641 Mdot
.63841 .52431 Mdot
.63963 .52036 Mdot
.64085 .51839 Mdot
.64206 .50851 Mdot
.64328 .51049 Mdot
.6445 .50258 Mdot
.64572 .49863 Mdot
.64694 .49468 Mdot
.64816 .48876 Mdot
.64938 .48678 Mdot
.6506 .49073 Mdot
.65182 .01472 Mdot
.65304 .01472 Mdot
.65426 .01472 Mdot
.65548 .01472 Mdot
.6567 .01472 Mdot
.65792 .01472 Mdot
.65914 .01472 Mdot
.66036 .01472 Mdot
.66158 .01472 Mdot
.66279 .01472 Mdot
.66401 .01472 Mdot
.66523 .01472 Mdot
.66645 .01472 Mdot
.66767 .01472 Mdot
.66889 .01472 Mdot
.67011 .01472 Mdot
.67133 .01472 Mdot
.67255 .01472 Mdot
.67377 .01472 Mdot
.67499 .01472 Mdot
.67621 .01472 Mdot
.67743 .01472 Mdot
.67865 .01472 Mdot
.67987 .01472 Mdot
.68109 .01472 Mdot
.68231 .01472 Mdot
.68353 .55196 Mdot
.68474 .54999 Mdot
.68596 .54604 Mdot
.68718 .54801 Mdot
.6884 .53814 Mdot
.68962 .53419 Mdot
.69084 .53221 Mdot
.69206 .53616 Mdot
.69328 .54011 Mdot
.6945 .54011 Mdot
.69572 .54604 Mdot
.69694 .54999 Mdot
.69816 .54801 Mdot
.69938 .54406 Mdot
.7006 .54209 Mdot
.70182 .53616 Mdot
.70304 .54209 Mdot
.70426 .54209 Mdot
.70548 .53616 Mdot
.70669 .54011 Mdot
.70791 .54011 Mdot
.70913 .53616 Mdot
.71035 .52826 Mdot
.71157 .53616 Mdot
.71279 .53616 Mdot
.71401 .54011 Mdot
.71523 .54209 Mdot
.71645 .54999 Mdot
.71767 .54209 Mdot
.71889 .54604 Mdot
.72011 .54801 Mdot
.72133 .54406 Mdot
.72255 .54406 Mdot
.72377 .54999 Mdot
.72499 .54801 Mdot
.72621 .55394 Mdot
.72743 .55789 Mdot
.72864 .55986 Mdot
.72986 .56382 Mdot
.73108 .56579 Mdot
.7323 .55986 Mdot
.73352 .55394 Mdot
.73474 .54999 Mdot
.73596 .01472 Mdot
.73718 .01472 Mdot
.7384 .54209 Mdot
.73962 .53419 Mdot
.74084 .52826 Mdot
.74206 .53221 Mdot
.74328 .53024 Mdot
.7445 .53024 Mdot
.74572 .52826 Mdot
.74694 .52036 Mdot
.74816 .52234 Mdot
.74938 .52036 Mdot
.75059 .52826 Mdot
.75181 .52826 Mdot
.75303 .52629 Mdot
.75425 .52431 Mdot
.75547 .52234 Mdot
.75669 .53024 Mdot
.75791 .54011 Mdot
.75913 .53814 Mdot
.76035 .53616 Mdot
.76157 .53616 Mdot
.76279 .53616 Mdot
.76401 .53616 Mdot
.76523 .53616 Mdot
.76645 .53419 Mdot
.76767 .01472 Mdot
.76889 .53221 Mdot
.77011 .52629 Mdot
.77132 .53024 Mdot
.77254 .52826 Mdot
.77376 .52826 Mdot
.77498 .53024 Mdot
.7762 .52826 Mdot
.77742 .52036 Mdot
.77864 .52826 Mdot
.77986 .52036 Mdot
.78108 .50654 Mdot
.7823 .51444 Mdot
.78352 .51444 Mdot
.78474 .50851 Mdot
.78596 .50851 Mdot
.78718 .50851 Mdot
.7884 .50851 Mdot
.78962 .51246 Mdot
.79084 .51246 Mdot
.79206 .01472 Mdot
.79327 .01472 Mdot
.79449 .51049 Mdot
.79571 .50654 Mdot
.79693 .50851 Mdot
.79815 .50258 Mdot
.79937 .50456 Mdot
.80059 .50851 Mdot
.80181 .49468 Mdot
.80303 .48086 Mdot
.80425 .48678 Mdot
.80547 .48678 Mdot
.80669 .48876 Mdot
.80791 .48678 Mdot
.80913 .48876 Mdot
.81035 .48283 Mdot
.81157 .49468 Mdot
.81279 .48481 Mdot
.81401 .48678 Mdot
.81522 .48876 Mdot
.81644 .49073 Mdot
.81766 .49073 Mdot
.81888 .49073 Mdot
.8201 .49073 Mdot
.82132 .50061 Mdot
.82254 .50456 Mdot
.82376 .50258 Mdot
.82498 .52431 Mdot
.8262 .51049 Mdot
.82742 .50456 Mdot
.82864 .50258 Mdot
.82986 .50851 Mdot
.83108 .51444 Mdot
.8323 .52629 Mdot
.83352 .52826 Mdot
.83474 .52629 Mdot
.83596 .51444 Mdot
.83717 .50456 Mdot
.83839 .51246 Mdot
.83961 .51049 Mdot
.84083 .53616 Mdot
.84205 .53221 Mdot
.84327 .52629 Mdot
.84449 .51444 Mdot
.84571 .51444 Mdot
.84693 .49863 Mdot
.84815 .51049 Mdot
.84937 .51049 Mdot
.85059 .51246 Mdot
.85181 .51641 Mdot
.85303 .50258 Mdot
.85425 .49271 Mdot
.85547 .48283 Mdot
.85669 .49073 Mdot
.85791 .48283 Mdot
.85912 .48086 Mdot
.86034 .47493 Mdot
.86156 .47691 Mdot
.86278 .47493 Mdot
.864 .47888 Mdot
.86522 .01472 Mdot
.86644 .48086 Mdot
.86766 .47691 Mdot
.86888 .47493 Mdot
.8701 .47098 Mdot
.87132 .46308 Mdot
.87254 .45518 Mdot
.87376 .45321 Mdot
.87498 .45321 Mdot
.8762 .45321 Mdot
.87742 .45913 Mdot
.87864 .46703 Mdot
.87985 .47493 Mdot
.88107 .47296 Mdot
.88229 .47493 Mdot
.88351 .47296 Mdot
.88473 .47493 Mdot
.88595 .46901 Mdot
.88717 .44925 Mdot
.88839 .01472 Mdot
.88961 .01472 Mdot
.89083 .01472 Mdot
.89205 .01472 Mdot
.89327 .01472 Mdot
.89449 .01472 Mdot
.89571 .01472 Mdot
.89693 .01472 Mdot
.89815 .01472 Mdot
.89937 .01472 Mdot
.90059 .01472 Mdot
.9018 .01472 Mdot
.90302 .01472 Mdot
.90424 .01472 Mdot
.90546 .01472 Mdot
.90668 .01472 Mdot
.9079 .01472 Mdot
.90912 .01472 Mdot
.91034 .01472 Mdot
.91156 .01472 Mdot
.91278 .01472 Mdot
.914 .01472 Mdot
.91522 .01472 Mdot
.91644 .01472 Mdot
.91766 .01472 Mdot
.91888 .01472 Mdot
.9201 .01472 Mdot
.92132 .01472 Mdot
.92254 .01472 Mdot
.92375 .01472 Mdot
.92497 .01472 Mdot
.92619 .01472 Mdot
.92741 .01472 Mdot
.92863 .01472 Mdot
.92985 .01472 Mdot
.93107 .01472 Mdot
.93229 .01472 Mdot
.93351 .01472 Mdot
.93473 .01472 Mdot
.93595 .01472 Mdot
.93717 .01472 Mdot
.93839 .01472 Mdot
.93961 .01472 Mdot
.94083 .01472 Mdot
.94205 .01472 Mdot
.94327 .01472 Mdot
.94449 .01472 Mdot
.9457 .01472 Mdot
.94692 .01472 Mdot
.94814 .01472 Mdot
.94936 .01472 Mdot
.95058 .01472 Mdot
.9518 .01472 Mdot
.95302 .01472 Mdot
.95424 .01472 Mdot
.95546 .01472 Mdot
.95668 .01472 Mdot
.9579 .01472 Mdot
.95912 .01472 Mdot
.96034 .01472 Mdot
.96156 .01472 Mdot
.96278 .01472 Mdot
.964 .01472 Mdot
.96522 .01472 Mdot
.96643 .01472 Mdot
.96765 .01472 Mdot
.96887 .01472 Mdot
.97009 .01472 Mdot
.97131 .01472 Mdot
.97253 .01472 Mdot
.97375 .01472 Mdot
.97497 .01472 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 185.375},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000^B000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`008`3oool5000000@0oooo0`00
000:0?ooo`8000001@3oool3000000030?ooo`0000000000008000000P3oool2000000X0oooo0`00
00040?ooo`<000006P3oool5000000<0oooo0`00000<0?ooo`8000001@3oool3000000030?ooo`00
00000000008000000P3oool2000000X0oooo0`0000030?ooo`D000006@3oool500000080oooo1@00
000;0?ooo`8000001@3oool3000000030?ooo`0000000000008000000P3oool2000000T0oooo0`00
00030?ooo`D00000703oool002D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`08
0?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo0000000K0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
000:0?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002P3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000703oool002D0oooo00@000000?ooo`3oool0oooo1P0000020?ooo`D000000P3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo1@0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000001/0oooo00<000000?ooo`3oool01P3oool010000000oooo0?oo
o`3oool500000080oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`D000000`3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo1@0000020?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool500000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo01d0oooo000U0?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000006`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo
00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool01`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0703oool0
02D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00000=0?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0203o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000K0?ooo`03
0000003oool0oooo00@0oooo0P00000>0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00`0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo008000000P3o
ool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`0K0?ooo`009@3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000d0oooo00<0
00000?ooo`3oool00P0000020?ooo`80000000<0oooo0000003oool00`00000;0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000001/0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo008000000P3oool200000003
0?ooo`000000oooo00<000002`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000003@3oool0
0`000000oooo0?ooo`0200000080oooo0P0000000`3oool000000?ooo`03000000X0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000703oool002D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0000000=0?ooo`030000003oool0oooo01L0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000006`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool05`3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`0F0?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000001`0oooo000J0?ooo`030000003o
ool0oooo00H0oooo0`0000060?ooo`8000002`3oool4000001P0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000006@3oool3000000@0oooo00D000000?ooo`3o
ool0oooo0000000;0?ooo`@00000603oool01@000000oooo0?ooo`3oool000000080oooo0`00000K
0?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000/0oooo1000000G0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000001`0oooo000J0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`<00000
103oool3000001`0oooo00<000000?ooo`3oool00`3oool3000002T0oooo0`0000050?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool3000002P0oooo0`0000040?ooo`<00000
7@3oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o
0?oooa00oooo000D0?ooool000005`0000020?ooo`006P3oool00`000000oooo0?ooo`0H0?ooob00
0000703oool00`000000oooo0000000H0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000140oooo00<000000?ooo`3oool06P3oool90000
00h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`8000004P3oool00`00
0000oooo0?ooo`030?oooaX00000203oool001X0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`1E0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0>03oool001X0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J
0?ooo`800000o`3ooolA0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`03
0000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3o
ool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool0
01X0oooo0P00003o0?oooa40oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo0P00003o0?oooa40oooo000J0?ooo`03
0000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3o
ool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool0
01X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool200000?l0oooo4@3oool001X0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo0004
0?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`@000001@3oool00`000000oooo0?ooo`3o
0?oooa00oooo00030?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0o`3oool@0?ooo`000`3oool01@00
0000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool00P3oool300000?l0oooo403oool0
00<0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0o`3oool@0?ooo`000`3oool01@000000oooo0?ooo`3oool0000000T0oooo10000005
0?ooo`030000003oool0oooo0?l0oooo403oool000<0oooo00D000000?ooo`3oool0oooo00000009
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3oool@0?ooo`000`3oool01@00
0000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o
0?oooa00oooo00030?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0?l0oooo403oool000@0oooo0`00000:0?ooo`D00000103oool20000
0?l0oooo4@3oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo
0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo00<00000
0?ooo`3oool0o`3oool@0?ooo`006P3oool200000?l0oooo4@3oool001X0oooo00<000000?ooo`3o
ool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003o
ool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`00
0000oooo0?ooo`3o0?oooa00oooo000J0?ooo`800000o`3ooolA0?ooo`006P3oool00`000000oooo
0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo00<00000
0?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`80
0000o`3ooolA0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003o
ool0oooo0?l0oooo403oool00140oooo1@0000040?ooo`030000003oool0oooo0?l0oooo403oool0
01<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooa00oooo000C0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool@0?ooo`004`3oool00`000000oooo
0?ooo`040?ooo`<00000o`3oool@0?ooo`004`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0?l0oooo403oool001<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o
0?oooa00oooo000C0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`004@3oool3000000H0oooo00<000000?ooo`3oool0o`3oool@0?ooo`004`3oool00`000000oooo
0?ooo`040?ooo`800000o`3ooolA0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo
403oool001X0oooo0P00003o0?oooa40oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool0
01X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00
oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo0P00003o0?oooa40oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo
403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool200000?l0oooo4@3oool0
01X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00
oooo00030?ooo`D000000`3oool00`000000oooo0?ooo`030?ooo`@000001@3oool00`000000oooo
0?ooo`3o0?oooa00oooo00050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo403oool000D0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`<00000o`3oool@0?ooo`001@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0o`3oool@0?oo
o`001@3oool00`000000oooo0?ooo`090?ooo`@000001@3oool00`000000oooo0?ooo`3o0?oooa00
oooo00050?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`3o0?oooa00oooo00050?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`3o0?oooa00oooo00030?ooo`<000002`3oool00`000000oooo0?ooo`06
0?ooo`800000o`3ooolA0?ooo`001@3oool00`000000oooo0?ooo`090?ooo`D00000103oool00`00
0000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo0P00003o0?oooa40oooo000J0?ooo`03
0000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3o
ool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool0
01X0oooo0P00003o0?oooa40oooo000J0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J
0?ooo`030000003oool0oooo0?l0oooo403oool001X0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`006P3oool200000?l0oooo4@3oool001X0oooo00<000000?ooo`3oool0o`3oool@0?ooo`006P3o
ool00`000000oooo0?ooo`3o0?oooa00oooo000A0?ooo`D00000103oool00`000000oooo0?ooo`3o
0?oooa00oooo000A0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`3o
0?oooa00oooo000B0?ooo`030000003oool0oooo00D0oooo0`00003o0?oooa00oooo000C0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool@0?ooo`00503oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0?l0oooo403oool00140oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo0?l0oooo403oool00140oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo0:40oooo0P00001/0?ooo`004@3oool01@000000oooo0?oo
o`3oool0000000@0oooo00@000000?ooo`0000000000W`3oool3000006`0oooo000B0?ooo`<00000
1@3oool2000000030?ooo`000000oooo09l0oooo0P00001/0?ooo`006P3oool4000009l0oooo0P00
001]0?ooo`006P3oool400000:00oooo00<000000?ooo`3oool0J`3oool001X0oooo00@000000?oo
o`0000000000o`3oool?0?ooo`006P3oool5000009h0oooo0`00001/0?ooo`006P3oool5000009l0
oooo0P0000190?ooo`8000008@3oool001X0oooo0P0000020?ooo`030000003oool0oooo0>@0oooo
0`0000020?ooo`030000003oool0oooo01l0oooo000J0?ooo`800000X03oool2000004L0oooo0`00
000T0?ooo`006P3oool00`000000oooo0?ooo`2O0?ooo`800000B03oool2000002@0oooo000J0?oo
o`030000003oool0oooo00800000E@3oool700000480oooo00<000000?ooo`3oool0A@3oool30000
02@0oooo000J0?ooo`050000003oool0oooo0?ooo`000000EP3oool600000400oooo0P0000190?oo
o`D000008@3oool001X0oooo0P00001E0?ooo`<00000103oool3000000030?ooo`000000000003h0
oooo0P0000160?ooo`80000000<0oooo0000000000000P00000Q0?ooo`006P3oool00`000000oooo
0?ooo`1B0?ooo`D000001P3oool4000003d0oooo0`0000000`3oool00000000000100?ooo`D00000
00@0oooo00000000000000008P3oool001X0oooo00<000000?ooo`3oool0D`3oool6000000D0oooo
1000000m0?ooo`030000003oool0oooo00800000@@3oool400000080oooo0P00000R0?ooo`006P3o
ool00`000000oooo0?ooo`1A0?ooo`@0000000@0oooo00000000000000001P3oool300000440oooo
00<000000?ooo`3oool0;`3oool4000000X0oooo1P00000V0?ooo`006P3oool010000000oooo0?oo
o`3oool2000004`0oooo1@0000030?ooo`030000003oool0oooo00L0oooo0P00000k0?ooo`800000
0`3oool2000000D0oooo0P00000Y0?ooo`D000002P3oool2000000030?ooo`000000oooo02H0oooo
000J0?ooo`8000000`3oool00`000000oooo0?ooo`1:0?ooo`@000003P3oool3000003T0oooo0`00
00030?ooo`D000000P3oool2000002X0oooo1@0000080?ooo`800000:P3oool001X0oooo00<00000
0?ooo`3oool0CP3oool3000000030?ooo`000000oooo00d0oooo0`00000j0?ooo`030000003oool0
oooo0080oooo0`0000000`3oool000000?ooo`03000002P0oooo0P0000000`3oool0000000000002
000000P0oooo0P00000Z0?ooo`006P3oool00`000000oooo0?ooo`1=0?ooo`<000004P3oool00`00
0000oooo0?ooo`0h0?ooo`8000001@3oool2000000@0oooo00<000000?ooo`3oool0:03oool01000
0000oooo0?ooo`00000;0?ooo`030000003oool0oooo02P0oooo00030?ooo`D000000`3oool00`00
0000oooo0?ooo`030?ooo`@000001@3oool010000000oooo0?ooo`3oool2000004/0oooo00<00000
0?ooo`3oool04@3oool2000003P0oooo0`0000060?ooo`8000000P3oool2000002l0oooo0P000005
0?ooo`800000;03oool000<0oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool2000004T0oooo0P00
000E0?ooo`030000003oool0oooo03L0oooo0P0000070?ooo`80000000<0oooo000000000000:03o
ool3000000@0oooo1P0000020?ooo`800000:`3oool000@0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0A@3oool4
000004L0oooo0P00000>0?ooo`H00000903oool7000000D0oooo0`0000000`3oool000000?ooo`02
0?ooo`030000003oool0oooo02T0oooo00050?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool00P3oool300000080oooo0P0000170?ooo`<00000@P3oool2000000@0oooo00<000000?oo
o`3oool0303oool2000000030?ooo`000000000002H0oooo1P0000050?ooo`T00000:`3oool000H0
oooo00<000000?ooo`3oool0203oool4000000D0oooo00<000000?ooo`3oool00`3oool200000340
oooo0P00000C0?ooo`800000?@3oool3000000@0oooo00@000000?ooo`3oool0oooo0P00000?0?oo
o`@000009@3oool2000000030?ooo`000000000000P0oooo2000000[0?ooo`000`3oool01@000000
oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?oo
o`<00000<P3oool00`000000oooo0?ooo`080?ooo`800000203oool00`000000oooo0?ooo`0D0?oo
o`8000009P3oool200000080oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000070?oo
o`8000000P3oool2000002H0oooo00<000000?ooo`3oool02P3oool01`000000oooo0000003oool0
00000?ooo`000000:`3oool000<0oooo00D000000?ooo`3oool0oooo000000090?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0a0?ooo`8000002P3o
ool010000000oooo0?ooo`3oool6000001H0oooo0P00000W0?ooo`80000000@0oooo000000000000
oooo0P0000070?ooo`800000203oool00`000000oooo00000002000001/0oooo100000050?ooo`80
0000?`3oool000<0oooo00D000000?ooo`3oool0oooo000000090?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0=`3oool3000000L0oooo0P0000040?ooo`H000005`3oool2000002L0
oooo2@0000040?ooo`@000002@3oool2000001d0oooo0`0000020?ooo`8000000P3oool00`000000
oooo0?ooo`090?ooo`@0000000<0oooo000000000000;@3oool000@0oooo0`00000:0?ooo`D00000
103oool200000140oooo0P00000V0?ooo`D00000103oool4000000030?ooo`000000000000<00000
6@3oool400000280oooo2@0000020?ooo`030000003oool0oooo0080oooo1000000:0?ooo`030000
003oool0oooo0100oooo0P0000060?ooo`L000000P3oool4000000`0oooo0`0000020?ooo`030000
003oool0oooo02/0oooo000J0?ooo`030000003oool0oooo00<0oooo0P000000103oool000000000
000000060?ooo`<000009`3oool<00000080oooo1000000I0?ooo`@0000000<0oooo000000000000
7P3oool5000000<0oooo0`0000020?ooo`@0000000<0oooo0000003oool0603oool3000000@0oooo
00<000000?ooo`3oool0103oool5000000030?ooo`000000000000D000003P3oool3000002h0oooo
000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P0000060?ooo`800000:@3o
ool9000000030?ooo`000000000000<00000703oool2000000040?ooo`0000000000000001h0oooo
0P0000070?ooo`@0000000<0oooo0000000000000`00000J0?ooo`80000000<0oooo000000000000
0`0000060?ooo`8000000`3oool400000180oooo0P00000^0?ooo`006P3oool00`000000oooo0?oo
o`040?ooo`@00000103oool5000002/0oooo0P000000103oool000000000000000020?ooo`@00000
7P3oool00`000000oooo0?ooo`02000001l0oooo00<000000?ooo`3oool00`3oool2000000030?oo
o`000000000000D0000000<0oooo0000003oool0603oool4000000030?ooo`000000000000800000
2P3oool4000001@0oooo00<000000?ooo`3oool0;03oool001X0oooo00<000000?ooo`3oool00`3o
ool600000080oooo1@00000]0?ooo`030000003oool0oooo008000000P3oool4000001l0oooo1000
000V0?ooo`030000003oool000000080000000<0oooo0000000000000P00000K0?ooo`X000000`3o
ool2000000@0oooo00<000000?ooo`3oool0@`3oool001X0oooo00<000000?ooo`3oool0103oool6
00000080oooo00@000000?ooo`0000000000=@3oool00`000000oooo0?ooo`0P0?ooo`800000:P3o
ool2000000030?ooo`0000000000008000006@3oool700000080oooo100000030?ooo`030000003o
ool0oooo04P0oooo000J0?ooo`8000001P3oool00`000000oooo0?ooo`02000000D0oooo00<00000
0?ooo`3oool0103oool3000004d0oooo0P00000`0?ooo`030000003oool0oooo01T0oooo1P000003
0?ooo`@0000000<0oooo000000000000B`3oool001X0oooo00<000000?ooo`3oool02@3oool40000
00T0oooo1000001=0?ooo`030000003oool0oooo00800000703oool2000002/0oooo00@000000?oo
o`3oool000001@3oool6000004/0oooo000J0?ooo`030000003oool0oooo00T0oooo0P0000000`3o
ool000000?ooo`020?ooo`8000001@3oool00`000000oooo0000001A0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool0=03oool3000004`0oooo000J0?ooo`030000003oool0oooo00X0
oooo0P0000050?ooo`030000003oool0oooo0080oooo0P00002X0?ooo`<00000C03oool001X0oooo
00<000000?ooo`3oool02P3oool3000000<0oooo0P0000030?ooo`<00000K@3oool2000003T0oooo
0`00001<0?ooo`006P3oool2000000`0oooo0P0000040?ooo`8000000P3oool2000005d0oooo0`00
000?0?ooo`040000003oool00000000003L0oooo0P00001<0?ooo`006P3oool00`000000oooo0?oo
o`0A0?ooo`8000000P3oool2000005D0oooo0P0000060?ooo`@000001`3oool2000000@0oooo0P00
00020?ooo`030000003oool0oooo08<0oooo000J0?ooo`030000003oool0oooo0140oooo0P000000
103oool0000000000000001C0?ooo`@000001@3oool6000000H0oooo0P0000000`3oool000000000
0004000008L0oooo000J0?ooo`030000003oool0oooo0180oooo00@000000?ooo`3oool00000E@3o
ool010000000oooo0000000000040?ooo`H000000P3oool2000000050?ooo`00000000000000003o
ool00`0000000`3oool00000000000270?ooo`006P3oool00`000000oooo0?ooo`0B0?ooo`800000
F03oool3000000030?ooo`00000000000080oooo00<000000?ooo`0000000P000000103oool00000
0000000000020?ooo`030000003oool0oooo00L00000QP3oool001X0oooo00<000000?ooo`3oool0
4`3oool3000005@0oooo100000020?ooo`@000000`3oool200000080oooo1@0000030?ooo`040000
003oool000000?ooo`800000QP3oool001X0oooo0P00000C0?ooo`@00000E@3oool9000000H0oooo
2@0000030?ooo`<00000QP3oool001X0oooo00<000000?ooo`3oool04`3oool3000005H0oooo2000
00040?ooo`L0000000@0oooo0000000000000000103oool2000008H0oooo000J0?ooo`030000003o
ool0oooo0180oooo1000001H0?ooo`H00000103oool300000080oooo00@000000?ooo`3oool0oooo
0P00002<0?ooo`004P3oool3000000D0oooo00<000000?ooo`3oool04`3oool2000005X0oooo0P00
00000`3oool000000?ooo`050?ooo`800000U03oool00140oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo0740oooo0P0000060?ooo`800000U03oool001D0oooo00<00000
0?ooo`3oool00P3oool300000780oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2B
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo403oool001<0
oooo0P0000050?ooo`030000003oool0oooo0?l0oooo403oool001D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`3o0?oooa00oooo000E0?ooo`030000003oool0oooo0?l0oooo5@3o
ool00140oooo00D000000?ooo`3oool0oooo0000003o0?oooaL0oooo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {184.375, 0}} -> {-79.4272, -0.271182, \
2.96047, 0.0182774}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Max[Table[Max[maturitymonth[j]], {j, 25, 25 + 35}]]\)], "Input"],

Cell[BoxData[
    \(2.98`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[
        Partition[
          Block[{$DisplayFunction = Identity}, 
            Table[XLSListPlot[Thread[{dates, maturitymonth[j]}], 
                PlotLabel \[Rule] "\<maturity month \>"\  <> \ ToString[j], 
                PlotRange \[Rule] {Automatic, {0, 3}}, 
                NumberOfHorizontalTicks \[Rule] 4], {j, 26, 30}]], 2]], 
      ImageSize \[Rule] 800]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 800 494.427 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.00121944 0 0.206011 [
[.16648 -0.0125 -34.3438 -11.375 ]
[.16648 -0.0125 34.3438 0 ]
[.40427 -0.0125 -34.3438 -11.375 ]
[.40427 -0.0125 34.3438 0 ]
[.64206 -0.0125 -34.3438 -11.375 ]
[.64206 -0.0125 34.3438 0 ]
[.87985 -0.0125 -34.3438 -11.375 ]
[.87985 -0.0125 34.3438 0 ]
[.01131 .10301 -21.6 -5.4 ]
[.01131 .10301 0 5.4 ]
[.01131 .20601 -7.2 -5.4 ]
[.01131 .20601 0 5.4 ]
[.01131 .30902 -21.6 -5.4 ]
[.01131 .30902 0 5.4 ]
[.01131 .41202 -7.2 -5.4 ]
[.01131 .41202 0 5.4 ]
[.01131 .51503 -21.6 -5.4 ]
[.01131 .51503 0 5.4 ]
[.01131 .61803 -7.2 -5.4 ]
[.01131 .61803 0 5.4 ]
[.5 .63053 -63.0938 0 ]
[.5 .63053 63.0938 11.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16648 0 m
.16648 .00625 L
s
gsave
.16648 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(00) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40427 0 m
.40427 .00625 L
s
gsave
.40427 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mar) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.64206 0 m
.64206 .00625 L
s
gsave
.64206 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Dec) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.87985 0 m
.87985 .00625 L
s
gsave
.87985 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sep) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(02) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -124.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(maturity) show
127.688 12.875 moveto
(month) show
170.812 12.875 moveto
(28) show
185.188 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02503 .39348 Mdot
.02625 .38936 Mdot
.02747 .3873 Mdot
.02869 .37906 Mdot
.02991 .37494 Mdot
.03113 .36876 Mdot
.03235 .37288 Mdot
.03357 .38112 Mdot
.03478 .38524 Mdot
.036 .38936 Mdot
.03722 .40996 Mdot
.03844 .43262 Mdot
.03966 .44498 Mdot
.04088 .4491 Mdot
.0421 .45529 Mdot
.04332 .46147 Mdot
.04454 .46353 Mdot
.04576 .48207 Mdot
.04698 .49237 Mdot
.0482 .49443 Mdot
.04942 .48413 Mdot
.05064 .48619 Mdot
.05186 .48825 Mdot
.05308 .48825 Mdot
.0543 .49031 Mdot
.05551 .49031 Mdot
.05673 .48413 Mdot
.05795 .48001 Mdot
.05917 .47795 Mdot
.06039 .47589 Mdot
.06161 .48825 Mdot
.06283 .49649 Mdot
.06405 .49237 Mdot
.06527 .49855 Mdot
.06649 .50061 Mdot
.06771 .50061 Mdot
.06893 .50061 Mdot
.07015 .50267 Mdot
.07137 .50267 Mdot
.07259 .50679 Mdot
.07381 .50473 Mdot
.07503 .49649 Mdot
.07625 .48619 Mdot
.07746 .47795 Mdot
.07868 .47795 Mdot
.0799 .48001 Mdot
.08112 .47795 Mdot
.08234 .48413 Mdot
.08356 .48413 Mdot
.08478 .48207 Mdot
.086 .48619 Mdot
.08722 .47795 Mdot
.08844 .47589 Mdot
.08966 .46971 Mdot
.09088 .46971 Mdot
.0921 .46559 Mdot
.09332 .49649 Mdot
.09454 .50679 Mdot
.09576 .50885 Mdot
.09698 .51297 Mdot
.0982 .51503 Mdot
.09941 .52327 Mdot
.10063 .53151 Mdot
.10185 .53563 Mdot
.10307 .52945 Mdot
.10429 .53563 Mdot
.10551 .53151 Mdot
.10673 .53151 Mdot
.10795 .52739 Mdot
.10917 .51709 Mdot
.11039 .51091 Mdot
.11161 .50885 Mdot
.11283 .50473 Mdot
.11405 .49855 Mdot
.11527 .49649 Mdot
.11649 .49237 Mdot
.11771 .49649 Mdot
.11893 .49649 Mdot
.12015 0 Mdot
.12136 0 Mdot
.12258 .49855 Mdot
.1238 0 Mdot
.12502 0 Mdot
.12624 0 Mdot
.12746 0 Mdot
.12868 0 Mdot
.1299 0 Mdot
.13112 0 Mdot
.13234 0 Mdot
.13356 0 Mdot
.13478 0 Mdot
.136 0 Mdot
.13722 0 Mdot
.13844 0 Mdot
.13966 0 Mdot
.14088 0 Mdot
.14209 0 Mdot
.14331 0 Mdot
.14453 0 Mdot
.14575 0 Mdot
.14697 0 Mdot
.14819 .43468 Mdot
.14941 .43674 Mdot
.15063 .4388 Mdot
.15185 0 Mdot
.15307 .43674 Mdot
.15429 .44086 Mdot
.15551 .4388 Mdot
.15673 .42644 Mdot
.15795 .42644 Mdot
.15917 .4285 Mdot
.16039 .43056 Mdot
.16161 .43056 Mdot
.16283 .43262 Mdot
.16404 .43262 Mdot
.16526 .43674 Mdot
.16648 .43674 Mdot
.1677 .43468 Mdot
.16892 .4285 Mdot
.17014 .42644 Mdot
.17136 .42438 Mdot
.17258 .42232 Mdot
.1738 .42644 Mdot
.17502 .4285 Mdot
.17624 .4285 Mdot
.17746 .42438 Mdot
.17868 .42026 Mdot
.1799 .41408 Mdot
.18112 .41202 Mdot
.18234 .40996 Mdot
.18356 .41202 Mdot
.18478 .4182 Mdot
.18599 .4182 Mdot
.18721 .42026 Mdot
.18843 .4285 Mdot
.18965 .4285 Mdot
.19087 .42644 Mdot
.19209 .4285 Mdot
.19331 .4285 Mdot
.19453 .43262 Mdot
.19575 .4388 Mdot
.19697 .44086 Mdot
.19819 .44498 Mdot
.19941 .4491 Mdot
.20063 .45322 Mdot
.20185 .45116 Mdot
.20307 .47177 Mdot
.20429 .46765 Mdot
.20551 .46971 Mdot
.20673 .47383 Mdot
.20794 .47383 Mdot
.20916 .47383 Mdot
.21038 .46971 Mdot
.2116 .47177 Mdot
.21282 .46971 Mdot
.21404 .47383 Mdot
.21526 .47383 Mdot
.21648 .47383 Mdot
.2177 .48001 Mdot
.21892 .48413 Mdot
.22014 .47383 Mdot
.22136 .48001 Mdot
.22258 .48619 Mdot
.2238 .48619 Mdot
.22502 .48619 Mdot
.22624 .49237 Mdot
.22746 .49443 Mdot
.22868 .49443 Mdot
.22989 .49649 Mdot
.23111 0 Mdot
.23233 .50061 Mdot
.23355 .50061 Mdot
.23477 .50267 Mdot
.23599 .50473 Mdot
.23721 .50267 Mdot
.23843 .50473 Mdot
.23965 .50885 Mdot
.24087 .51091 Mdot
.24209 .51503 Mdot
.24331 .51503 Mdot
.24453 .51091 Mdot
.24575 .51709 Mdot
.24697 .51297 Mdot
.24819 .51503 Mdot
.24941 .51709 Mdot
.25062 .51915 Mdot
.25184 .52121 Mdot
.25306 .51915 Mdot
.25428 .51503 Mdot
.2555 .51709 Mdot
.25672 .51503 Mdot
.25794 .51503 Mdot
.25916 .51709 Mdot
.26038 .51503 Mdot
.2616 .51709 Mdot
.26282 .51915 Mdot
.26404 .52327 Mdot
.26526 .52121 Mdot
.26648 .52121 Mdot
.2677 .51915 Mdot
.26892 .51915 Mdot
.27014 .51297 Mdot
.27136 .51091 Mdot
.27257 .50267 Mdot
.27379 .50267 Mdot
.27501 .50885 Mdot
.27623 .51297 Mdot
.27745 .51297 Mdot
.27867 .51709 Mdot
.27989 .52327 Mdot
.28111 .52739 Mdot
.28233 .52327 Mdot
.28355 .52121 Mdot
.28477 .52121 Mdot
.28599 .52121 Mdot
.28721 .52327 Mdot
.28843 .52121 Mdot
.28965 .51709 Mdot
.29087 .51915 Mdot
.29209 .51297 Mdot
.29331 .51297 Mdot
.29452 .51091 Mdot
.29574 .52121 Mdot
.29696 .51915 Mdot
.29818 .51915 Mdot
.2994 .51709 Mdot
.30062 .51091 Mdot
.30184 .49649 Mdot
.30306 .49649 Mdot
.30428 .51091 Mdot
.3055 .51091 Mdot
.30672 .50473 Mdot
.30794 .50061 Mdot
.30916 .49855 Mdot
.31038 .49443 Mdot
.3116 .49237 Mdot
.31282 .48413 Mdot
.31404 .48413 Mdot
.31526 .48413 Mdot
.31647 .48207 Mdot
.31769 .48207 Mdot
.31891 .48001 Mdot
.32013 .47383 Mdot
.32135 .47589 Mdot
.32257 .47589 Mdot
.32379 .47589 Mdot
.32501 .47589 Mdot
.32623 .48001 Mdot
.32745 .47383 Mdot
.32867 .47383 Mdot
.32989 .47383 Mdot
.33111 .46559 Mdot
.33233 .46559 Mdot
.33355 .46765 Mdot
.33477 0 Mdot
.33599 0 Mdot
.33721 .46765 Mdot
.33842 .46559 Mdot
.33964 .46559 Mdot
.34086 0 Mdot
.34208 .46353 Mdot
.3433 .46559 Mdot
.34452 .46971 Mdot
.34574 .46971 Mdot
.34696 .47177 Mdot
.34818 .47177 Mdot
.3494 .45735 Mdot
.35062 .45735 Mdot
.35184 .45529 Mdot
.35306 .45529 Mdot
.35428 .45735 Mdot
.3555 .45735 Mdot
.35672 .45735 Mdot
.35794 .45735 Mdot
.35915 .45735 Mdot
.36037 .45941 Mdot
.36159 .46147 Mdot
.36281 .46147 Mdot
.36403 .46147 Mdot
.36525 .45941 Mdot
.36647 .45735 Mdot
.36769 .45735 Mdot
.36891 .46353 Mdot
.37013 .46765 Mdot
.37135 .46765 Mdot
.37257 .46765 Mdot
.37379 .46765 Mdot
.37501 .46971 Mdot
.37623 .46765 Mdot
.37745 .46559 Mdot
.37867 .46353 Mdot
.37989 .46765 Mdot
.3811 .47383 Mdot
.38232 .47383 Mdot
.38354 .47383 Mdot
.38476 .47795 Mdot
.38598 .47795 Mdot
.3872 .48207 Mdot
.38842 .48619 Mdot
.38964 .49031 Mdot
.39086 .49237 Mdot
.39208 .50885 Mdot
.3933 .51091 Mdot
.39452 .51503 Mdot
.39574 .51709 Mdot
.39696 .52121 Mdot
.39818 .52533 Mdot
.3994 .52533 Mdot
.40062 .52739 Mdot
.40184 .52533 Mdot
.40305 .52327 Mdot
.40427 .52121 Mdot
.40549 .54181 Mdot
.40671 .53357 Mdot
.40793 .53769 Mdot
.40915 .54181 Mdot
.41037 .53769 Mdot
.41159 .53357 Mdot
.41281 .52945 Mdot
.41403 .53151 Mdot
.41525 .53563 Mdot
.41647 .55623 Mdot
.41769 .57683 Mdot
.41891 .58713 Mdot
.42013 .58507 Mdot
.42135 .59331 Mdot
.42257 .58713 Mdot
.42379 .58301 Mdot
.425 .57477 Mdot
.42622 .57477 Mdot
.42744 .58095 Mdot
.42866 .59331 Mdot
.42988 .59537 Mdot
.4311 0 Mdot
.43232 0 Mdot
.43354 .59949 Mdot
.43476 .60361 Mdot
.43598 .59743 Mdot
.4372 .59331 Mdot
.43842 .58713 Mdot
.43964 .58713 Mdot
.44086 .59125 Mdot
.44208 .60155 Mdot
.4433 .60155 Mdot
.44452 .60979 Mdot
.44574 .59949 Mdot
.44695 .59537 Mdot
.44817 .59125 Mdot
.44939 .58095 Mdot
.45061 0 Mdot
.45183 .58095 Mdot
.45305 .57683 Mdot
.45427 .57683 Mdot
.45549 .57271 Mdot
.45671 .57271 Mdot
.45793 .57889 Mdot
.45915 .57477 Mdot
.46037 .57683 Mdot
.46159 .58301 Mdot
.46281 .58507 Mdot
.46403 .58301 Mdot
.46525 .58095 Mdot
.46647 .58507 Mdot
.46768 .59743 Mdot
.4689 0 Mdot
.47012 .60361 Mdot
.47134 .60773 Mdot
.47256 .60773 Mdot
.47378 .59949 Mdot
.475 .59537 Mdot
.47622 .59537 Mdot
.47744 .58713 Mdot
.47866 .58095 Mdot
.47988 .58301 Mdot
.4811 .58301 Mdot
.48232 .59537 Mdot
.48354 .59537 Mdot
.48476 .59331 Mdot
.48598 .59537 Mdot
.4872 .59125 Mdot
.48842 .58919 Mdot
.48963 .58301 Mdot
.49085 .58919 Mdot
.49207 .58301 Mdot
.49329 .58095 Mdot
.49451 .57683 Mdot
.49573 .57889 Mdot
.49695 .59331 Mdot
.49817 .59743 Mdot
.49939 .59743 Mdot
.50061 .59537 Mdot
.50183 .59331 Mdot
.50305 .58713 Mdot
.50427 .58301 Mdot
.50549 .58301 Mdot
.50671 .58095 Mdot
.50793 .57889 Mdot
.50915 .58507 Mdot
.51037 .58713 Mdot
.51158 .58713 Mdot
.5128 .58507 Mdot
.51402 .56653 Mdot
.51524 .57683 Mdot
.51646 .57683 Mdot
.51768 .57683 Mdot
.5189 .58507 Mdot
.52012 .59331 Mdot
.52134 .59331 Mdot
.52256 .59125 Mdot
.52378 .58507 Mdot
.525 .57271 Mdot
.52622 .56859 Mdot
.52744 .55623 Mdot
.52866 .53769 Mdot
.52988 .53563 Mdot
.5311 .53563 Mdot
.53232 .53357 Mdot
.53353 .51709 Mdot
.53475 .51915 Mdot
.53597 .51709 Mdot
.53719 .52121 Mdot
.53841 .53151 Mdot
.53963 .53151 Mdot
.54085 .52327 Mdot
.54207 .52533 Mdot
.54329 .52739 Mdot
.54451 .52945 Mdot
.54573 .52739 Mdot
.54695 .53151 Mdot
.54817 0 Mdot
.54939 .52945 Mdot
.55061 .52739 Mdot
.55183 .52533 Mdot
.55305 .52327 Mdot
.55426 .51709 Mdot
.55548 .53151 Mdot
.5567 .54387 Mdot
.55792 .53769 Mdot
.55914 .53151 Mdot
.56036 .53357 Mdot
.56158 .52945 Mdot
.5628 .52739 Mdot
.56402 .54181 Mdot
.56524 .54799 Mdot
.56646 .55005 Mdot
.56768 .55829 Mdot
.5689 .55829 Mdot
.57012 .55417 Mdot
.57134 .54181 Mdot
.57256 .52739 Mdot
.57378 .52739 Mdot
.575 .53769 Mdot
.57621 .55211 Mdot
.57743 .55417 Mdot
.57865 .55829 Mdot
.57987 .56653 Mdot
.58109 .55623 Mdot
.58231 .55829 Mdot
.58353 .55417 Mdot
.58475 .55417 Mdot
.58597 .56241 Mdot
.58719 .56241 Mdot
.58841 .56241 Mdot
.58963 .55623 Mdot
.59085 .55005 Mdot
.59207 .54387 Mdot
.59329 .53769 Mdot
.59451 .54181 Mdot
.59573 .54387 Mdot
.59695 .54387 Mdot
.59816 .54593 Mdot
.59938 .52121 Mdot
.6006 .50885 Mdot
.60182 .51915 Mdot
.60304 .51709 Mdot
.60426 .50885 Mdot
.60548 .49649 Mdot
.6067 .49031 Mdot
.60792 .49237 Mdot
.60914 .48207 Mdot
.61036 .48001 Mdot
.61158 .46971 Mdot
.6128 .45941 Mdot
.61402 .45322 Mdot
.61524 .4491 Mdot
.61646 .45529 Mdot
.61768 .47177 Mdot
.6189 .49855 Mdot
.62011 .49855 Mdot
.62133 .50061 Mdot
.62255 .50679 Mdot
.62377 .51709 Mdot
.62499 .51297 Mdot
.62621 .51297 Mdot
.62743 .51709 Mdot
.62865 .53975 Mdot
.62987 .53151 Mdot
.63109 .52945 Mdot
.63231 .52121 Mdot
.63353 .51091 Mdot
.63475 .50885 Mdot
.63597 .52121 Mdot
.63719 .53769 Mdot
.63841 .54593 Mdot
.63963 .54181 Mdot
.64085 .53769 Mdot
.64206 .52739 Mdot
.64328 .52533 Mdot
.6445 .51915 Mdot
.64572 .51709 Mdot
.64694 .51297 Mdot
.64816 .50679 Mdot
.64938 .50679 Mdot
.6506 .50885 Mdot
.65182 .56035 Mdot
.65304 0 Mdot
.65426 0 Mdot
.65548 .57065 Mdot
.6567 .57271 Mdot
.65792 .57065 Mdot
.65914 0 Mdot
.66036 .56859 Mdot
.66158 .56653 Mdot
.66279 .57065 Mdot
.66401 .57065 Mdot
.66523 .56859 Mdot
.66645 .57271 Mdot
.66767 .56859 Mdot
.66889 .56859 Mdot
.67011 .56241 Mdot
.67133 .55005 Mdot
.67255 .54181 Mdot
.67377 .53563 Mdot
.67499 .53769 Mdot
.67621 .53357 Mdot
.67743 .53563 Mdot
.67865 .52945 Mdot
.67987 .55005 Mdot
.68109 .55829 Mdot
.68231 .55829 Mdot
.68353 .56241 Mdot
.68474 .56035 Mdot
.68596 .55623 Mdot
.68718 .55829 Mdot
.6884 .54799 Mdot
.68962 .54387 Mdot
.69084 .54181 Mdot
.69206 .54799 Mdot
.69328 .55005 Mdot
.6945 .55005 Mdot
.69572 .55829 Mdot
.69694 .56241 Mdot
.69816 .56241 Mdot
.69938 .55829 Mdot
.7006 .55623 Mdot
.70182 .55005 Mdot
.70304 .55623 Mdot
.70426 .55623 Mdot
.70548 .55005 Mdot
.70669 .55417 Mdot
.70791 .55417 Mdot
.70913 .55211 Mdot
.71035 .54387 Mdot
.71157 .55211 Mdot
.71279 .55211 Mdot
.71401 .55623 Mdot
.71523 .55829 Mdot
.71645 .56653 Mdot
.71767 .55829 Mdot
.71889 .56447 Mdot
.72011 .56447 Mdot
.72133 .56241 Mdot
.72255 .56241 Mdot
.72377 .56653 Mdot
.72499 .56653 Mdot
.72621 .57271 Mdot
.72743 .57271 Mdot
.72864 .57683 Mdot
.72986 .58095 Mdot
.73108 .58301 Mdot
.7323 .57683 Mdot
.73352 .57065 Mdot
.73474 .56653 Mdot
.73596 0 Mdot
.73718 0 Mdot
.7384 .55829 Mdot
.73962 .55005 Mdot
.74084 .54387 Mdot
.74206 .55005 Mdot
.74328 .54593 Mdot
.7445 .54799 Mdot
.74572 .54593 Mdot
.74694 .53769 Mdot
.74816 .53769 Mdot
.74938 .53769 Mdot
.75059 .54181 Mdot
.75181 .54387 Mdot
.75303 .53975 Mdot
.75425 .53769 Mdot
.75547 .53769 Mdot
.75669 .54593 Mdot
.75791 .55623 Mdot
.75913 .55211 Mdot
.76035 .55211 Mdot
.76157 .55211 Mdot
.76279 .55211 Mdot
.76401 .55211 Mdot
.76523 .55211 Mdot
.76645 .55005 Mdot
.76767 0 Mdot
.76889 .54799 Mdot
.77011 .54181 Mdot
.77132 .54593 Mdot
.77254 .54387 Mdot
.77376 .54387 Mdot
.77498 .54799 Mdot
.7762 .54387 Mdot
.77742 .53769 Mdot
.77864 .54387 Mdot
.77986 .53769 Mdot
.78108 .52327 Mdot
.7823 .52945 Mdot
.78352 .52739 Mdot
.78474 .52121 Mdot
.78596 .52121 Mdot
.78718 .52121 Mdot
.7884 .52121 Mdot
.78962 .52533 Mdot
.79084 .52533 Mdot
.79206 0 Mdot
.79327 0 Mdot
.79449 .52533 Mdot
.79571 .52121 Mdot
.79693 .52327 Mdot
.79815 .51709 Mdot
.79937 .51915 Mdot
.80059 .52327 Mdot
.80181 .50885 Mdot
.80303 .49443 Mdot
.80425 .50061 Mdot
.80547 .50061 Mdot
.80669 .50061 Mdot
.80791 .49855 Mdot
.80913 .50061 Mdot
.81035 .49443 Mdot
.81157 .50885 Mdot
.81279 .49855 Mdot
.81401 .50061 Mdot
.81522 .50267 Mdot
.81644 .50473 Mdot
.81766 .50473 Mdot
.81888 .50473 Mdot
.8201 .50473 Mdot
.82132 .51503 Mdot
.82254 .51915 Mdot
.82376 .51709 Mdot
.82498 .53975 Mdot
.8262 .52533 Mdot
.82742 .51709 Mdot
.82864 .51709 Mdot
.82986 .52327 Mdot
.83108 .52945 Mdot
.8323 .54181 Mdot
.83352 .54181 Mdot
.83474 .54181 Mdot
.83596 .52945 Mdot
.83717 .51915 Mdot
.83839 .52739 Mdot
.83961 .52533 Mdot
.84083 .55005 Mdot
.84205 .54799 Mdot
.84327 .53975 Mdot
.84449 .52945 Mdot
.84571 .52945 Mdot
.84693 .51297 Mdot
.84815 .52327 Mdot
.84937 .52327 Mdot
.85059 .52533 Mdot
.85181 .52945 Mdot
.85303 .51503 Mdot
.85425 .50679 Mdot
.85547 .49649 Mdot
.85669 .50267 Mdot
.85791 .49649 Mdot
.85912 .49443 Mdot
.86034 .48825 Mdot
.86156 .49031 Mdot
.86278 .49031 Mdot
.864 .49237 Mdot
.86522 0 Mdot
.86644 .49237 Mdot
.86766 .49031 Mdot
.86888 .48619 Mdot
.8701 .48207 Mdot
.87132 .47383 Mdot
.87254 .46559 Mdot
.87376 .46353 Mdot
.87498 .46353 Mdot
.8762 .46353 Mdot
.87742 .46971 Mdot
.87864 .47795 Mdot
.87985 .48619 Mdot
.88107 .48413 Mdot
.88229 .48413 Mdot
.88351 .48413 Mdot
.88473 .48619 Mdot
.88595 .47795 Mdot
.88717 .45941 Mdot
.88839 0 Mdot
.88961 0 Mdot
.89083 0 Mdot
.89205 0 Mdot
.89327 0 Mdot
.89449 0 Mdot
.89571 0 Mdot
.89693 0 Mdot
.89815 0 Mdot
.89937 0 Mdot
.90059 0 Mdot
.9018 0 Mdot
.90302 0 Mdot
.90424 0 Mdot
.90546 0 Mdot
.90668 0 Mdot
.9079 0 Mdot
.90912 0 Mdot
.91034 0 Mdot
.91156 0 Mdot
.91278 0 Mdot
.914 0 Mdot
.91522 0 Mdot
.91644 0 Mdot
.91766 0 Mdot
.91888 0 Mdot
.9201 0 Mdot
.92132 0 Mdot
.92254 0 Mdot
.92375 0 Mdot
.92497 0 Mdot
.92619 0 Mdot
.92741 0 Mdot
.92863 0 Mdot
.92985 0 Mdot
.93107 0 Mdot
.93229 0 Mdot
.93351 0 Mdot
.93473 0 Mdot
.93595 0 Mdot
.93717 0 Mdot
.93839 0 Mdot
.93961 0 Mdot
.94083 0 Mdot
.94205 0 Mdot
.94327 0 Mdot
.94449 0 Mdot
.9457 0 Mdot
.94692 0 Mdot
.94814 0 Mdot
.94936 0 Mdot
.95058 0 Mdot
.9518 0 Mdot
.95302 0 Mdot
.95424 0 Mdot
.95546 0 Mdot
.95668 0 Mdot
.9579 0 Mdot
.95912 0 Mdot
.96034 0 Mdot
.96156 0 Mdot
.96278 0 Mdot
.964 0 Mdot
.96522 0 Mdot
.96643 0 Mdot
.96765 0 Mdot
.96887 0 Mdot
.97009 0 Mdot
.97131 0 Mdot
.97253 0 Mdot
.97375 0 Mdot
.97497 0 Mdot
.97619 0 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.00121944 0 0.206011 [
[.16648 -0.0125 -34.3438 -11.375 ]
[.16648 -0.0125 34.3438 0 ]
[.40427 -0.0125 -34.3438 -11.375 ]
[.40427 -0.0125 34.3438 0 ]
[.64206 -0.0125 -34.3438 -11.375 ]
[.64206 -0.0125 34.3438 0 ]
[.87985 -0.0125 -34.3438 -11.375 ]
[.87985 -0.0125 34.3438 0 ]
[.01131 .10301 -21.6 -5.4 ]
[.01131 .10301 0 5.4 ]
[.01131 .20601 -7.2 -5.4 ]
[.01131 .20601 0 5.4 ]
[.01131 .30902 -21.6 -5.4 ]
[.01131 .30902 0 5.4 ]
[.01131 .41202 -7.2 -5.4 ]
[.01131 .41202 0 5.4 ]
[.01131 .51503 -21.6 -5.4 ]
[.01131 .51503 0 5.4 ]
[.01131 .61803 -7.2 -5.4 ]
[.01131 .61803 0 5.4 ]
[.5 .63053 -63.0938 0 ]
[.5 .63053 63.0938 11.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16648 0 m
.16648 .00625 L
s
gsave
.16648 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(00) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40427 0 m
.40427 .00625 L
s
gsave
.40427 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mar) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.64206 0 m
.64206 .00625 L
s
gsave
.64206 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Dec) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.87985 0 m
.87985 .00625 L
s
gsave
.87985 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sep) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(02) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -124.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(maturity) show
127.688 12.875 moveto
(month) show
170.812 12.875 moveto
(29) show
185.188 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02503 .37288 Mdot
.02625 .36876 Mdot
.02747 .3667 Mdot
.02869 .35846 Mdot
.02991 .35434 Mdot
.03113 .35022 Mdot
.03235 .35434 Mdot
.03357 .36258 Mdot
.03478 .3667 Mdot
.036 .37082 Mdot
.03722 .39142 Mdot
.03844 .41614 Mdot
.03966 .4285 Mdot
.04088 .43262 Mdot
.0421 .43674 Mdot
.04332 .44292 Mdot
.04454 .44498 Mdot
.04576 .46353 Mdot
.04698 .47383 Mdot
.0482 .47383 Mdot
.04942 .46559 Mdot
.05064 .46765 Mdot
.05186 .46765 Mdot
.05308 .46971 Mdot
.0543 .46971 Mdot
.05551 .46971 Mdot
.05673 .46559 Mdot
.05795 .45941 Mdot
.05917 .45735 Mdot
.06039 .45735 Mdot
.06161 .46971 Mdot
.06283 .47795 Mdot
.06405 .47383 Mdot
.06527 .47795 Mdot
.06649 .48207 Mdot
.06771 .48001 Mdot
.06893 .48001 Mdot
.07015 .48207 Mdot
.07137 .48207 Mdot
.07259 .48619 Mdot
.07381 .48413 Mdot
.07503 .47589 Mdot
.07625 .46559 Mdot
.07746 .45735 Mdot
.07868 .45735 Mdot
.0799 .45941 Mdot
.08112 .45735 Mdot
.08234 .46147 Mdot
.08356 .46353 Mdot
.08478 .46147 Mdot
.086 .46559 Mdot
.08722 .45735 Mdot
.08844 .45529 Mdot
.08966 .44704 Mdot
.09088 .44704 Mdot
.0921 .44292 Mdot
.09332 .47589 Mdot
.09454 .48413 Mdot
.09576 .48619 Mdot
.09698 .49237 Mdot
.0982 .49443 Mdot
.09941 .50267 Mdot
.10063 .50885 Mdot
.10185 .51297 Mdot
.10307 .50679 Mdot
.10429 .51297 Mdot
.10551 .50885 Mdot
.10673 .50885 Mdot
.10795 .50473 Mdot
.10917 .49649 Mdot
.11039 .49031 Mdot
.11161 .48825 Mdot
.11283 .48413 Mdot
.11405 .47795 Mdot
.11527 .47383 Mdot
.11649 .47383 Mdot
.11771 .47589 Mdot
.11893 .47589 Mdot
.12015 0 Mdot
.12136 0 Mdot
.12258 .48001 Mdot
.1238 0 Mdot
.12502 0 Mdot
.12624 0 Mdot
.12746 0 Mdot
.12868 0 Mdot
.1299 .36876 Mdot
.13112 .37494 Mdot
.13234 .37906 Mdot
.13356 .39142 Mdot
.13478 .39554 Mdot
.136 .39554 Mdot
.13722 .39554 Mdot
.13844 .39966 Mdot
.13966 .39554 Mdot
.14088 .40996 Mdot
.14209 .40996 Mdot
.14331 .41202 Mdot
.14453 .41614 Mdot
.14575 .4182 Mdot
.14697 .42232 Mdot
.14819 .42644 Mdot
.14941 .42644 Mdot
.15063 .4285 Mdot
.15185 0 Mdot
.15307 .4285 Mdot
.15429 .43056 Mdot
.15551 .4285 Mdot
.15673 .41614 Mdot
.15795 .41614 Mdot
.15917 .4182 Mdot
.16039 .42026 Mdot
.16161 .42026 Mdot
.16283 .42232 Mdot
.16404 .42232 Mdot
.16526 .42644 Mdot
.16648 .42644 Mdot
.1677 .42438 Mdot
.16892 .4182 Mdot
.17014 .41614 Mdot
.17136 .41408 Mdot
.17258 .41202 Mdot
.1738 .41614 Mdot
.17502 .4182 Mdot
.17624 .42026 Mdot
.17746 .41408 Mdot
.17868 .40996 Mdot
.1799 .40378 Mdot
.18112 .40378 Mdot
.18234 .40172 Mdot
.18356 .40172 Mdot
.18478 .4079 Mdot
.18599 .40996 Mdot
.18721 .40996 Mdot
.18843 .4182 Mdot
.18965 .4182 Mdot
.19087 .41614 Mdot
.19209 .42026 Mdot
.19331 .42026 Mdot
.19453 .42232 Mdot
.19575 .4285 Mdot
.19697 .43262 Mdot
.19819 .43674 Mdot
.19941 .44086 Mdot
.20063 .44292 Mdot
.20185 .44292 Mdot
.20307 .46147 Mdot
.20429 .45735 Mdot
.20551 .46147 Mdot
.20673 .46353 Mdot
.20794 .46353 Mdot
.20916 .46353 Mdot
.21038 .46147 Mdot
.2116 .46147 Mdot
.21282 .46147 Mdot
.21404 .46559 Mdot
.21526 .46353 Mdot
.21648 .46353 Mdot
.2177 .46971 Mdot
.21892 .47383 Mdot
.22014 .46559 Mdot
.22136 .47177 Mdot
.22258 .47795 Mdot
.2238 .47795 Mdot
.22502 .47795 Mdot
.22624 .48413 Mdot
.22746 .48619 Mdot
.22868 .48619 Mdot
.22989 .48825 Mdot
.23111 0 Mdot
.23233 .49237 Mdot
.23355 .49237 Mdot
.23477 .49443 Mdot
.23599 .49443 Mdot
.23721 .49443 Mdot
.23843 .49649 Mdot
.23965 .50061 Mdot
.24087 .50267 Mdot
.24209 .50679 Mdot
.24331 .50679 Mdot
.24453 .50267 Mdot
.24575 .50885 Mdot
.24697 .50473 Mdot
.24819 .50679 Mdot
.24941 .51091 Mdot
.25062 .51297 Mdot
.25184 .51297 Mdot
.25306 .51091 Mdot
.25428 .50679 Mdot
.2555 .50885 Mdot
.25672 .50679 Mdot
.25794 .50885 Mdot
.25916 .50885 Mdot
.26038 .50885 Mdot
.2616 .50885 Mdot
.26282 .51297 Mdot
.26404 .51503 Mdot
.26526 .51503 Mdot
.26648 .51503 Mdot
.2677 .51091 Mdot
.26892 .51091 Mdot
.27014 .50473 Mdot
.27136 .50473 Mdot
.27257 .49443 Mdot
.27379 .49649 Mdot
.27501 .50267 Mdot
.27623 .50473 Mdot
.27745 .50473 Mdot
.27867 .50885 Mdot
.27989 .51503 Mdot
.28111 .51915 Mdot
.28233 .51709 Mdot
.28355 .51503 Mdot
.28477 .51503 Mdot
.28599 .51503 Mdot
.28721 .51709 Mdot
.28843 .51503 Mdot
.28965 .51091 Mdot
.29087 .51503 Mdot
.29209 .50885 Mdot
.29331 .50679 Mdot
.29452 .50679 Mdot
.29574 .51709 Mdot
.29696 .51503 Mdot
.29818 .51503 Mdot
.2994 .51297 Mdot
.30062 .50679 Mdot
.30184 .49237 Mdot
.30306 .49237 Mdot
.30428 .50679 Mdot
.3055 .50679 Mdot
.30672 .50061 Mdot
.30794 .49443 Mdot
.30916 .49237 Mdot
.31038 .49031 Mdot
.3116 .48619 Mdot
.31282 .48001 Mdot
.31404 .48001 Mdot
.31526 .47795 Mdot
.31647 .47795 Mdot
.31769 .47795 Mdot
.31891 .47589 Mdot
.32013 .46971 Mdot
.32135 .47177 Mdot
.32257 .47177 Mdot
.32379 .47177 Mdot
.32501 .47177 Mdot
.32623 .47589 Mdot
.32745 .46971 Mdot
.32867 .46971 Mdot
.32989 .46971 Mdot
.33111 .46353 Mdot
.33233 .46147 Mdot
.33355 .46559 Mdot
.33477 0 Mdot
.33599 0 Mdot
.33721 .46353 Mdot
.33842 .46147 Mdot
.33964 .46147 Mdot
.34086 0 Mdot
.34208 .46147 Mdot
.3433 .46353 Mdot
.34452 .46559 Mdot
.34574 .46765 Mdot
.34696 .46971 Mdot
.34818 .46765 Mdot
.3494 .45529 Mdot
.35062 .45529 Mdot
.35184 .45322 Mdot
.35306 .45322 Mdot
.35428 .45322 Mdot
.3555 .45322 Mdot
.35672 .45322 Mdot
.35794 .45322 Mdot
.35915 .45322 Mdot
.36037 .45529 Mdot
.36159 .45941 Mdot
.36281 .45735 Mdot
.36403 .45941 Mdot
.36525 .45735 Mdot
.36647 .45529 Mdot
.36769 .45529 Mdot
.36891 .45941 Mdot
.37013 .46559 Mdot
.37135 .46559 Mdot
.37257 .46353 Mdot
.37379 .46559 Mdot
.37501 .46559 Mdot
.37623 .46353 Mdot
.37745 .46353 Mdot
.37867 .46147 Mdot
.37989 .46353 Mdot
.3811 .46971 Mdot
.38232 .47177 Mdot
.38354 .47177 Mdot
.38476 .47383 Mdot
.38598 .47589 Mdot
.3872 .47795 Mdot
.38842 .48207 Mdot
.38964 .48619 Mdot
.39086 .48825 Mdot
.39208 .50473 Mdot
.3933 .50679 Mdot
.39452 .51091 Mdot
.39574 .51297 Mdot
.39696 .51503 Mdot
.39818 .52121 Mdot
.3994 .52121 Mdot
.40062 .52121 Mdot
.40184 .52121 Mdot
.40305 .51709 Mdot
.40427 .51709 Mdot
.40549 .53769 Mdot
.40671 .52945 Mdot
.40793 .53151 Mdot
.40915 .53769 Mdot
.41037 .53563 Mdot
.41159 .52945 Mdot
.41281 .52533 Mdot
.41403 .52945 Mdot
.41525 .53357 Mdot
.41647 .55417 Mdot
.41769 .57477 Mdot
.41891 .58301 Mdot
.42013 .58301 Mdot
.42135 .58919 Mdot
.42257 .58507 Mdot
.42379 .58095 Mdot
.425 .57271 Mdot
.42622 .57271 Mdot
.42744 .57889 Mdot
.42866 .58919 Mdot
.42988 .59331 Mdot
.4311 0 Mdot
.43232 0 Mdot
.43354 .59743 Mdot
.43476 .60155 Mdot
.43598 .59537 Mdot
.4372 .59125 Mdot
.43842 .58507 Mdot
.43964 .58507 Mdot
.44086 .58919 Mdot
.44208 .59949 Mdot
.4433 .59949 Mdot
.44452 .60773 Mdot
.44574 .59743 Mdot
.44695 .59331 Mdot
.44817 .58919 Mdot
.44939 .57889 Mdot
.45061 0 Mdot
.45183 .57889 Mdot
.45305 .57271 Mdot
.45427 .57477 Mdot
.45549 .57065 Mdot
.45671 .57065 Mdot
.45793 .57683 Mdot
.45915 .57271 Mdot
.46037 .57683 Mdot
.46159 .58095 Mdot
.46281 .58301 Mdot
.46403 .58095 Mdot
.46525 .58095 Mdot
.46647 .58301 Mdot
.46768 .59537 Mdot
.4689 0 Mdot
.47012 .60155 Mdot
.47134 .60567 Mdot
.47256 .60567 Mdot
.47378 .59743 Mdot
.475 .59331 Mdot
.47622 .59331 Mdot
.47744 .58507 Mdot
.47866 .57889 Mdot
.47988 .58095 Mdot
.4811 .58095 Mdot
.48232 .59125 Mdot
.48354 .59125 Mdot
.48476 .59125 Mdot
.48598 .59125 Mdot
.4872 .58713 Mdot
.48842 .58713 Mdot
.48963 .58095 Mdot
.49085 .58507 Mdot
.49207 .58095 Mdot
.49329 .57889 Mdot
.49451 .57477 Mdot
.49573 .57683 Mdot
.49695 .59125 Mdot
.49817 .59537 Mdot
.49939 .59537 Mdot
.50061 .59331 Mdot
.50183 .59125 Mdot
.50305 .58507 Mdot
.50427 .58095 Mdot
.50549 .58095 Mdot
.50671 .57889 Mdot
.50793 .57683 Mdot
.50915 .58301 Mdot
.51037 .58507 Mdot
.51158 .58507 Mdot
.5128 .58301 Mdot
.51402 .56447 Mdot
.51524 .57477 Mdot
.51646 .57477 Mdot
.51768 .57477 Mdot
.5189 .58095 Mdot
.52012 .59125 Mdot
.52134 .59125 Mdot
.52256 .58919 Mdot
.52378 .58301 Mdot
.525 .57065 Mdot
.52622 .56653 Mdot
.52744 .55417 Mdot
.52866 .53563 Mdot
.52988 .53357 Mdot
.5311 .53563 Mdot
.53232 .53151 Mdot
.53353 .51503 Mdot
.53475 .51709 Mdot
.53597 .51503 Mdot
.53719 .51915 Mdot
.53841 .52945 Mdot
.53963 .53151 Mdot
.54085 .52327 Mdot
.54207 .52327 Mdot
.54329 .52739 Mdot
.54451 .52739 Mdot
.54573 .52739 Mdot
.54695 .52945 Mdot
.54817 0 Mdot
.54939 .52945 Mdot
.55061 .52739 Mdot
.55183 .52533 Mdot
.55305 .52121 Mdot
.55426 .51709 Mdot
.55548 .53151 Mdot
.5567 .54387 Mdot
.55792 .53769 Mdot
.55914 .53151 Mdot
.56036 .53151 Mdot
.56158 .52739 Mdot
.5628 .52739 Mdot
.56402 .54181 Mdot
.56524 .55005 Mdot
.56646 .55211 Mdot
.56768 .56035 Mdot
.5689 .56035 Mdot
.57012 .55623 Mdot
.57134 .54593 Mdot
.57256 .53151 Mdot
.57378 .53151 Mdot
.575 .54181 Mdot
.57621 .55623 Mdot
.57743 .55829 Mdot
.57865 .56241 Mdot
.57987 .57065 Mdot
.58109 .55829 Mdot
.58231 .56035 Mdot
.58353 .55829 Mdot
.58475 .55623 Mdot
.58597 .56653 Mdot
.58719 .56653 Mdot
.58841 .56653 Mdot
.58963 .55829 Mdot
.59085 .55417 Mdot
.59207 .54799 Mdot
.59329 .54181 Mdot
.59451 .54593 Mdot
.59573 .54799 Mdot
.59695 .54799 Mdot
.59816 .55005 Mdot
.59938 .52533 Mdot
.6006 .51297 Mdot
.60182 .52327 Mdot
.60304 .52121 Mdot
.60426 .51297 Mdot
.60548 .50061 Mdot
.6067 .49443 Mdot
.60792 .49855 Mdot
.60914 .48825 Mdot
.61036 .48413 Mdot
.61158 .47589 Mdot
.6128 .46353 Mdot
.61402 .45941 Mdot
.61524 .45529 Mdot
.61646 .46147 Mdot
.61768 .47795 Mdot
.6189 .50267 Mdot
.62011 .50473 Mdot
.62133 .50679 Mdot
.62255 .51091 Mdot
.62377 .52121 Mdot
.62499 .51709 Mdot
.62621 .51915 Mdot
.62743 .52121 Mdot
.62865 .54387 Mdot
.62987 .53563 Mdot
.63109 .53357 Mdot
.63231 .52533 Mdot
.63353 .51503 Mdot
.63475 .51297 Mdot
.63597 .52533 Mdot
.63719 .54181 Mdot
.63841 .55005 Mdot
.63963 .54593 Mdot
.64085 .54181 Mdot
.64206 .53151 Mdot
.64328 .52739 Mdot
.6445 .52327 Mdot
.64572 .52121 Mdot
.64694 .51709 Mdot
.64816 .51091 Mdot
.64938 .50885 Mdot
.6506 .51297 Mdot
.65182 .56035 Mdot
.65304 0 Mdot
.65426 0 Mdot
.65548 .57065 Mdot
.6567 .57271 Mdot
.65792 .57065 Mdot
.65914 0 Mdot
.66036 .56859 Mdot
.66158 .56447 Mdot
.66279 .56859 Mdot
.66401 .56859 Mdot
.66523 .56653 Mdot
.66645 .57271 Mdot
.66767 .56653 Mdot
.66889 .56653 Mdot
.67011 .56241 Mdot
.67133 .55005 Mdot
.67255 .54181 Mdot
.67377 .53769 Mdot
.67499 .53975 Mdot
.67621 .53357 Mdot
.67743 .53563 Mdot
.67865 .52945 Mdot
.67987 .55005 Mdot
.68109 .55829 Mdot
.68231 .55829 Mdot
.68353 .56241 Mdot
.68474 .56035 Mdot
.68596 .55829 Mdot
.68718 .55829 Mdot
.6884 .54799 Mdot
.68962 .54387 Mdot
.69084 .54181 Mdot
.69206 .54799 Mdot
.69328 .55005 Mdot
.6945 .55211 Mdot
.69572 .56035 Mdot
.69694 .56447 Mdot
.69816 .56241 Mdot
.69938 .56035 Mdot
.7006 .55829 Mdot
.70182 .55211 Mdot
.70304 .55829 Mdot
.70426 .55829 Mdot
.70548 .55211 Mdot
.70669 .55623 Mdot
.70791 .55623 Mdot
.70913 .55417 Mdot
.71035 .54593 Mdot
.71157 .55417 Mdot
.71279 .55417 Mdot
.71401 .55829 Mdot
.71523 .56241 Mdot
.71645 .56859 Mdot
.71767 .56035 Mdot
.71889 .56653 Mdot
.72011 .56653 Mdot
.72133 .56447 Mdot
.72255 .56447 Mdot
.72377 .57065 Mdot
.72499 .56859 Mdot
.72621 .57477 Mdot
.72743 .57477 Mdot
.72864 .57889 Mdot
.72986 .58301 Mdot
.73108 .58507 Mdot
.7323 .57889 Mdot
.73352 .57271 Mdot
.73474 .56859 Mdot
.73596 0 Mdot
.73718 0 Mdot
.7384 .56035 Mdot
.73962 .55211 Mdot
.74084 .54593 Mdot
.74206 .55211 Mdot
.74328 .54799 Mdot
.7445 .55005 Mdot
.74572 .54799 Mdot
.74694 .53975 Mdot
.74816 .53975 Mdot
.74938 .53975 Mdot
.75059 .54387 Mdot
.75181 .54593 Mdot
.75303 .54181 Mdot
.75425 .53975 Mdot
.75547 .53769 Mdot
.75669 .54799 Mdot
.75791 .55829 Mdot
.75913 .55417 Mdot
.76035 .55417 Mdot
.76157 .55417 Mdot
.76279 .55417 Mdot
.76401 .55417 Mdot
.76523 .55417 Mdot
.76645 .55211 Mdot
.76767 0 Mdot
.76889 .54799 Mdot
.77011 .54387 Mdot
.77132 .54799 Mdot
.77254 .54593 Mdot
.77376 .54593 Mdot
.77498 .55005 Mdot
.7762 .54593 Mdot
.77742 .53975 Mdot
.77864 .54799 Mdot
.77986 .53975 Mdot
.78108 .52533 Mdot
.7823 .52945 Mdot
.78352 .52945 Mdot
.78474 .52327 Mdot
.78596 .52327 Mdot
.78718 .52327 Mdot
.7884 .52327 Mdot
.78962 .52739 Mdot
.79084 .52739 Mdot
.79206 0 Mdot
.79327 0 Mdot
.79449 .52533 Mdot
.79571 .52327 Mdot
.79693 .52533 Mdot
.79815 .51915 Mdot
.79937 .52121 Mdot
.80059 .52533 Mdot
.80181 .51091 Mdot
.80303 .49649 Mdot
.80425 .50267 Mdot
.80547 .50267 Mdot
.80669 .50267 Mdot
.80791 .50061 Mdot
.80913 .50473 Mdot
.81035 .49649 Mdot
.81157 .51091 Mdot
.81279 .50061 Mdot
.81401 .50267 Mdot
.81522 .50679 Mdot
.81644 .50679 Mdot
.81766 .50679 Mdot
.81888 .50679 Mdot
.8201 .50679 Mdot
.82132 .51709 Mdot
.82254 .52121 Mdot
.82376 .51915 Mdot
.82498 .54181 Mdot
.8262 .52739 Mdot
.82742 .52121 Mdot
.82864 .51915 Mdot
.82986 .52533 Mdot
.83108 .53151 Mdot
.8323 .54387 Mdot
.83352 .54387 Mdot
.83474 .54387 Mdot
.83596 .53151 Mdot
.83717 .52121 Mdot
.83839 .52945 Mdot
.83961 .52739 Mdot
.84083 .55417 Mdot
.84205 .55005 Mdot
.84327 .54387 Mdot
.84449 .53151 Mdot
.84571 .53151 Mdot
.84693 .51503 Mdot
.84815 .52533 Mdot
.84937 .52533 Mdot
.85059 .52739 Mdot
.85181 .53151 Mdot
.85303 .51709 Mdot
.85425 .50885 Mdot
.85547 .49855 Mdot
.85669 .50473 Mdot
.85791 .49855 Mdot
.85912 .49649 Mdot
.86034 .49031 Mdot
.86156 .49237 Mdot
.86278 .49237 Mdot
.864 .49443 Mdot
.86522 0 Mdot
.86644 .49443 Mdot
.86766 .49031 Mdot
.86888 .48825 Mdot
.8701 .48413 Mdot
.87132 .47589 Mdot
.87254 .46765 Mdot
.87376 .46559 Mdot
.87498 .46353 Mdot
.8762 .46559 Mdot
.87742 .47177 Mdot
.87864 .47795 Mdot
.87985 .48825 Mdot
.88107 .48619 Mdot
.88229 .48619 Mdot
.88351 .48413 Mdot
.88473 .48825 Mdot
.88595 .48001 Mdot
.88717 .45941 Mdot
.88839 0 Mdot
.88961 0 Mdot
.89083 0 Mdot
.89205 0 Mdot
.89327 0 Mdot
.89449 0 Mdot
.89571 0 Mdot
.89693 0 Mdot
.89815 0 Mdot
.89937 0 Mdot
.90059 0 Mdot
.9018 0 Mdot
.90302 0 Mdot
.90424 0 Mdot
.90546 0 Mdot
.90668 0 Mdot
.9079 0 Mdot
.90912 0 Mdot
.91034 0 Mdot
.91156 0 Mdot
.91278 0 Mdot
.914 0 Mdot
.91522 0 Mdot
.91644 0 Mdot
.91766 0 Mdot
.91888 0 Mdot
.9201 0 Mdot
.92132 0 Mdot
.92254 0 Mdot
.92375 0 Mdot
.92497 0 Mdot
.92619 0 Mdot
.92741 0 Mdot
.92863 0 Mdot
.92985 0 Mdot
.93107 0 Mdot
.93229 0 Mdot
.93351 0 Mdot
.93473 0 Mdot
.93595 0 Mdot
.93717 0 Mdot
.93839 0 Mdot
.93961 0 Mdot
.94083 0 Mdot
.94205 0 Mdot
.94327 0 Mdot
.94449 0 Mdot
.9457 0 Mdot
.94692 0 Mdot
.94814 0 Mdot
.94936 0 Mdot
.95058 0 Mdot
.9518 0 Mdot
.95302 0 Mdot
.95424 0 Mdot
.95546 0 Mdot
.95668 0 Mdot
.9579 0 Mdot
.95912 0 Mdot
.96034 0 Mdot
.96156 0 Mdot
.96278 0 Mdot
.964 0 Mdot
.96522 0 Mdot
.96643 0 Mdot
.96765 0 Mdot
.96887 0 Mdot
.97009 0 Mdot
.97131 0 Mdot
.97253 0 Mdot
.97375 0 Mdot
.97497 0 Mdot
.97619 0 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.00121944 0 0.206011 [
[.16648 -0.0125 -34.3438 -11.375 ]
[.16648 -0.0125 34.3438 0 ]
[.40427 -0.0125 -34.3438 -11.375 ]
[.40427 -0.0125 34.3438 0 ]
[.64206 -0.0125 -34.3438 -11.375 ]
[.64206 -0.0125 34.3438 0 ]
[.87985 -0.0125 -34.3438 -11.375 ]
[.87985 -0.0125 34.3438 0 ]
[.01131 .10301 -21.6 -5.4 ]
[.01131 .10301 0 5.4 ]
[.01131 .20601 -7.2 -5.4 ]
[.01131 .20601 0 5.4 ]
[.01131 .30902 -21.6 -5.4 ]
[.01131 .30902 0 5.4 ]
[.01131 .41202 -7.2 -5.4 ]
[.01131 .41202 0 5.4 ]
[.01131 .51503 -21.6 -5.4 ]
[.01131 .51503 0 5.4 ]
[.01131 .61803 -7.2 -5.4 ]
[.01131 .61803 0 5.4 ]
[.5 .63053 -63.0938 0 ]
[.5 .63053 63.0938 11.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16648 0 m
.16648 .00625 L
s
gsave
.16648 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(00) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40427 0 m
.40427 .00625 L
s
gsave
.40427 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mar) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.64206 0 m
.64206 .00625 L
s
gsave
.64206 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Dec) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.87985 0 m
.87985 .00625 L
s
gsave
.87985 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sep) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(02) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -124.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(maturity) show
127.688 12.875 moveto
(month) show
170.812 12.875 moveto
(26) show
185.188 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02503 .43468 Mdot
.02625 .43056 Mdot
.02747 .4285 Mdot
.02869 .42026 Mdot
.02991 .41614 Mdot
.03113 .40996 Mdot
.03235 .41408 Mdot
.03357 .42232 Mdot
.03478 .42644 Mdot
.036 .43056 Mdot
.03722 .4491 Mdot
.03844 .47177 Mdot
.03966 .48413 Mdot
.04088 .48825 Mdot
.0421 .49443 Mdot
.04332 .50267 Mdot
.04454 .50267 Mdot
.04576 .51915 Mdot
.04698 .53151 Mdot
.0482 .53357 Mdot
.04942 .52533 Mdot
.05064 .52739 Mdot
.05186 .52945 Mdot
.05308 .52945 Mdot
.0543 .53151 Mdot
.05551 .53151 Mdot
.05673 .52533 Mdot
.05795 .52121 Mdot
.05917 .51915 Mdot
.06039 .51709 Mdot
.06161 .52945 Mdot
.06283 .53769 Mdot
.06405 .53357 Mdot
.06527 .53975 Mdot
.06649 .54387 Mdot
.06771 .54387 Mdot
.06893 .54387 Mdot
.07015 .54799 Mdot
.07137 .54799 Mdot
.07259 .55005 Mdot
.07381 .54799 Mdot
.07503 .54181 Mdot
.07625 .52945 Mdot
.07746 .52327 Mdot
.07868 .52327 Mdot
.0799 .52533 Mdot
.08112 .52327 Mdot
.08234 .52739 Mdot
.08356 .52945 Mdot
.08478 .52739 Mdot
.086 .53357 Mdot
.08722 .52327 Mdot
.08844 .52121 Mdot
.08966 .51503 Mdot
.09088 .51503 Mdot
.0921 .51091 Mdot
.09332 .54181 Mdot
.09454 .55211 Mdot
.09576 .55211 Mdot
.09698 .55829 Mdot
.0982 .56035 Mdot
.09941 .57065 Mdot
.10063 .57683 Mdot
.10185 .58301 Mdot
.10307 .57683 Mdot
.10429 .58507 Mdot
.10551 .58095 Mdot
.10673 .57889 Mdot
.10795 .57271 Mdot
.10917 .56241 Mdot
.11039 .55623 Mdot
.11161 .55417 Mdot
.11283 .55005 Mdot
.11405 .54593 Mdot
.11527 .53975 Mdot
.11649 .53563 Mdot
.11771 .53769 Mdot
.11893 .53769 Mdot
.12015 0 Mdot
.12136 0 Mdot
.12258 .54181 Mdot
.1238 0 Mdot
.12502 0 Mdot
.12624 0 Mdot
.12746 0 Mdot
.12868 0 Mdot
.1299 0 Mdot
.13112 0 Mdot
.13234 0 Mdot
.13356 0 Mdot
.13478 0 Mdot
.136 0 Mdot
.13722 0 Mdot
.13844 0 Mdot
.13966 0 Mdot
.14088 0 Mdot
.14209 0 Mdot
.14331 0 Mdot
.14453 0 Mdot
.14575 0 Mdot
.14697 0 Mdot
.14819 0 Mdot
.14941 0 Mdot
.15063 0 Mdot
.15185 0 Mdot
.15307 0 Mdot
.15429 0 Mdot
.15551 0 Mdot
.15673 0 Mdot
.15795 0 Mdot
.15917 0 Mdot
.16039 0 Mdot
.16161 0 Mdot
.16283 0 Mdot
.16404 0 Mdot
.16526 0 Mdot
.16648 0 Mdot
.1677 0 Mdot
.16892 0 Mdot
.17014 0 Mdot
.17136 0 Mdot
.17258 0 Mdot
.1738 0 Mdot
.17502 0 Mdot
.17624 0 Mdot
.17746 0 Mdot
.17868 0 Mdot
.1799 0 Mdot
.18112 0 Mdot
.18234 0 Mdot
.18356 0 Mdot
.18478 0 Mdot
.18599 0 Mdot
.18721 0 Mdot
.18843 0 Mdot
.18965 0 Mdot
.19087 0 Mdot
.19209 0 Mdot
.19331 0 Mdot
.19453 0 Mdot
.19575 0 Mdot
.19697 0 Mdot
.19819 0 Mdot
.19941 0 Mdot
.20063 .47177 Mdot
.20185 .47177 Mdot
.20307 .49031 Mdot
.20429 .48825 Mdot
.20551 .49031 Mdot
.20673 .49443 Mdot
.20794 .49443 Mdot
.20916 .49443 Mdot
.21038 .49031 Mdot
.2116 .49031 Mdot
.21282 .49031 Mdot
.21404 .49443 Mdot
.21526 .49443 Mdot
.21648 .49443 Mdot
.2177 .50061 Mdot
.21892 .50473 Mdot
.22014 .49237 Mdot
.22136 .49855 Mdot
.22258 .50473 Mdot
.2238 .50473 Mdot
.22502 .50473 Mdot
.22624 .51091 Mdot
.22746 .51297 Mdot
.22868 .51297 Mdot
.22989 .51503 Mdot
.23111 0 Mdot
.23233 .51915 Mdot
.23355 .51915 Mdot
.23477 .52121 Mdot
.23599 .52327 Mdot
.23721 .52121 Mdot
.23843 .52327 Mdot
.23965 .52533 Mdot
.24087 .52945 Mdot
.24209 .53151 Mdot
.24331 .53357 Mdot
.24453 .52739 Mdot
.24575 .53357 Mdot
.24697 .52945 Mdot
.24819 .52945 Mdot
.24941 .53357 Mdot
.25062 .53563 Mdot
.25184 .53769 Mdot
.25306 .53563 Mdot
.25428 .53151 Mdot
.2555 .53151 Mdot
.25672 .53151 Mdot
.25794 .53151 Mdot
.25916 .53151 Mdot
.26038 .53151 Mdot
.2616 .53357 Mdot
.26282 .53563 Mdot
.26404 .53769 Mdot
.26526 .53769 Mdot
.26648 .53769 Mdot
.2677 .53563 Mdot
.26892 .53357 Mdot
.27014 .52739 Mdot
.27136 .52533 Mdot
.27257 .51709 Mdot
.27379 .51709 Mdot
.27501 .52533 Mdot
.27623 .52945 Mdot
.27745 .52945 Mdot
.27867 .53151 Mdot
.27989 .53769 Mdot
.28111 .54181 Mdot
.28233 .53975 Mdot
.28355 .53769 Mdot
.28477 .53769 Mdot
.28599 .53563 Mdot
.28721 .53769 Mdot
.28843 .53563 Mdot
.28965 .52945 Mdot
.29087 .53151 Mdot
.29209 .52327 Mdot
.29331 .52327 Mdot
.29452 .52327 Mdot
.29574 .53151 Mdot
.29696 .53151 Mdot
.29818 .53151 Mdot
.2994 .52945 Mdot
.30062 .52327 Mdot
.30184 .50679 Mdot
.30306 .50679 Mdot
.30428 .52327 Mdot
.3055 .52327 Mdot
.30672 .51709 Mdot
.30794 .51091 Mdot
.30916 .50885 Mdot
.31038 .50679 Mdot
.3116 .50267 Mdot
.31282 .49649 Mdot
.31404 .49443 Mdot
.31526 .49443 Mdot
.31647 .49443 Mdot
.31769 .49443 Mdot
.31891 .49031 Mdot
.32013 .48619 Mdot
.32135 .48619 Mdot
.32257 .48619 Mdot
.32379 .48619 Mdot
.32501 .48619 Mdot
.32623 .49031 Mdot
.32745 .48207 Mdot
.32867 .48207 Mdot
.32989 .48207 Mdot
.33111 .47589 Mdot
.33233 .47383 Mdot
.33355 .47795 Mdot
.33477 0 Mdot
.33599 0 Mdot
.33721 .47589 Mdot
.33842 .47383 Mdot
.33964 .47383 Mdot
.34086 0 Mdot
.34208 .47383 Mdot
.3433 .47383 Mdot
.34452 .47589 Mdot
.34574 .47795 Mdot
.34696 .48001 Mdot
.34818 .48001 Mdot
.3494 .46559 Mdot
.35062 .46559 Mdot
.35184 .46353 Mdot
.35306 .46353 Mdot
.35428 .46353 Mdot
.3555 .46559 Mdot
.35672 .46353 Mdot
.35794 .46559 Mdot
.35915 .46353 Mdot
.36037 .46559 Mdot
.36159 .46971 Mdot
.36281 .46765 Mdot
.36403 .46765 Mdot
.36525 .46765 Mdot
.36647 .46559 Mdot
.36769 .46559 Mdot
.36891 .46971 Mdot
.37013 .47589 Mdot
.37135 .47589 Mdot
.37257 .47383 Mdot
.37379 .47589 Mdot
.37501 .47589 Mdot
.37623 .47589 Mdot
.37745 .47383 Mdot
.37867 .47177 Mdot
.37989 .47383 Mdot
.3811 .48001 Mdot
.38232 .48207 Mdot
.38354 .48413 Mdot
.38476 .48619 Mdot
.38598 .48825 Mdot
.3872 .49237 Mdot
.38842 .49237 Mdot
.38964 .49855 Mdot
.39086 .50061 Mdot
.39208 .51915 Mdot
.3933 .52121 Mdot
.39452 .52533 Mdot
.39574 .52739 Mdot
.39696 .52945 Mdot
.39818 .53563 Mdot
.3994 .53563 Mdot
.40062 .53769 Mdot
.40184 .53563 Mdot
.40305 .53357 Mdot
.40427 .53151 Mdot
.40549 .55417 Mdot
.40671 .54387 Mdot
.40793 .54799 Mdot
.40915 .54799 Mdot
.41037 .54593 Mdot
.41159 .53975 Mdot
.41281 .53563 Mdot
.41403 .53769 Mdot
.41525 .54181 Mdot
.41647 .56241 Mdot
.41769 .58301 Mdot
.41891 .59125 Mdot
.42013 .59125 Mdot
.42135 .59949 Mdot
.42257 .59331 Mdot
.42379 .58919 Mdot
.425 .58095 Mdot
.42622 .58095 Mdot
.42744 .58507 Mdot
.42866 .59743 Mdot
.42988 .60155 Mdot
.4311 0 Mdot
.43232 0 Mdot
.43354 .60567 Mdot
.43476 .60773 Mdot
.43598 .60155 Mdot
.4372 .59743 Mdot
.43842 .59125 Mdot
.43964 .59125 Mdot
.44086 .59331 Mdot
.44208 .60361 Mdot
.4433 .60567 Mdot
.44452 .61185 Mdot
.44574 .60361 Mdot
.44695 .59949 Mdot
.44817 .59537 Mdot
.44939 .58507 Mdot
.45061 0 Mdot
.45183 .58507 Mdot
.45305 .58095 Mdot
.45427 .58095 Mdot
.45549 .57683 Mdot
.45671 .57683 Mdot
.45793 .58301 Mdot
.45915 .57889 Mdot
.46037 .58095 Mdot
.46159 .58713 Mdot
.46281 .58919 Mdot
.46403 .58713 Mdot
.46525 .58507 Mdot
.46647 .58919 Mdot
.46768 .60155 Mdot
.4689 0 Mdot
.47012 .60773 Mdot
.47134 .61185 Mdot
.47256 .60979 Mdot
.47378 .60361 Mdot
.475 .59949 Mdot
.47622 .59949 Mdot
.47744 .59125 Mdot
.47866 .58713 Mdot
.47988 .58713 Mdot
.4811 .58919 Mdot
.48232 .59949 Mdot
.48354 .59949 Mdot
.48476 .59949 Mdot
.48598 .59949 Mdot
.4872 .59537 Mdot
.48842 .59331 Mdot
.48963 .58713 Mdot
.49085 .59331 Mdot
.49207 .58713 Mdot
.49329 .58507 Mdot
.49451 .58095 Mdot
.49573 .58301 Mdot
.49695 .59949 Mdot
.49817 .60155 Mdot
.49939 .60155 Mdot
.50061 .59949 Mdot
.50183 .59743 Mdot
.50305 .59125 Mdot
.50427 .58713 Mdot
.50549 .58507 Mdot
.50671 .58301 Mdot
.50793 .58301 Mdot
.50915 .58713 Mdot
.51037 .58919 Mdot
.51158 .59125 Mdot
.5128 .59125 Mdot
.51402 .57065 Mdot
.51524 .58095 Mdot
.51646 .58301 Mdot
.51768 .58301 Mdot
.5189 .58919 Mdot
.52012 .59743 Mdot
.52134 .59949 Mdot
.52256 .59743 Mdot
.52378 .59125 Mdot
.525 .57683 Mdot
.52622 .57477 Mdot
.52744 .56035 Mdot
.52866 .54181 Mdot
.52988 .53769 Mdot
.5311 .53975 Mdot
.53232 .53563 Mdot
.53353 .51915 Mdot
.53475 .52121 Mdot
.53597 .51915 Mdot
.53719 .52327 Mdot
.53841 .53357 Mdot
.53963 .53357 Mdot
.54085 .52739 Mdot
.54207 .52739 Mdot
.54329 .52945 Mdot
.54451 .53151 Mdot
.54573 .53151 Mdot
.54695 .53357 Mdot
.54817 0 Mdot
.54939 .53357 Mdot
.55061 .52945 Mdot
.55183 .52739 Mdot
.55305 .52533 Mdot
.55426 .51915 Mdot
.55548 .53357 Mdot
.5567 .54593 Mdot
.55792 .53975 Mdot
.55914 .53357 Mdot
.56036 .53357 Mdot
.56158 .52945 Mdot
.5628 .52739 Mdot
.56402 .53975 Mdot
.56524 .54593 Mdot
.56646 .54799 Mdot
.56768 .55211 Mdot
.5689 .55211 Mdot
.57012 .54799 Mdot
.57134 .53563 Mdot
.57256 .51915 Mdot
.57378 .51915 Mdot
.575 .52945 Mdot
.57621 .54387 Mdot
.57743 .54593 Mdot
.57865 .55005 Mdot
.57987 .55829 Mdot
.58109 .54799 Mdot
.58231 .54799 Mdot
.58353 .54799 Mdot
.58475 .54593 Mdot
.58597 .55417 Mdot
.58719 .55623 Mdot
.58841 .55623 Mdot
.58963 .54799 Mdot
.59085 .54181 Mdot
.59207 .53563 Mdot
.59329 .52945 Mdot
.59451 .53357 Mdot
.59573 .53563 Mdot
.59695 .53563 Mdot
.59816 .53769 Mdot
.59938 .51091 Mdot
.6006 .49855 Mdot
.60182 .51091 Mdot
.60304 .50679 Mdot
.60426 .49855 Mdot
.60548 .48619 Mdot
.6067 .48001 Mdot
.60792 .48207 Mdot
.60914 .47177 Mdot
.61036 .46765 Mdot
.61158 .45735 Mdot
.6128 .44498 Mdot
.61402 .4388 Mdot
.61524 .43468 Mdot
.61646 .44086 Mdot
.61768 .45941 Mdot
.6189 .48619 Mdot
.62011 .48825 Mdot
.62133 .49031 Mdot
.62255 .49649 Mdot
.62377 .50679 Mdot
.62499 .50267 Mdot
.62621 .50267 Mdot
.62743 .50679 Mdot
.62865 .52945 Mdot
.62987 .52121 Mdot
.63109 .51915 Mdot
.63231 .51297 Mdot
.63353 .50267 Mdot
.63475 .50061 Mdot
.63597 .51297 Mdot
.63719 .52739 Mdot
.63841 .53563 Mdot
.63963 .53151 Mdot
.64085 .52945 Mdot
.64206 .51915 Mdot
.64328 .51915 Mdot
.6445 .51297 Mdot
.64572 .50885 Mdot
.64694 .50679 Mdot
.64816 .50061 Mdot
.64938 .49855 Mdot
.6506 .50061 Mdot
.65182 0 Mdot
.65304 0 Mdot
.65426 0 Mdot
.65548 0 Mdot
.6567 .57477 Mdot
.65792 .57271 Mdot
.65914 0 Mdot
.66036 .57065 Mdot
.66158 .56859 Mdot
.66279 .57065 Mdot
.66401 .57271 Mdot
.66523 .57065 Mdot
.66645 .57477 Mdot
.66767 .57065 Mdot
.66889 .57065 Mdot
.67011 .56653 Mdot
.67133 .54799 Mdot
.67255 .54181 Mdot
.67377 .53563 Mdot
.67499 .53769 Mdot
.67621 .53151 Mdot
.67743 .53357 Mdot
.67865 .52739 Mdot
.67987 .54799 Mdot
.68109 .55623 Mdot
.68231 .55829 Mdot
.68353 .56035 Mdot
.68474 .55829 Mdot
.68596 .55623 Mdot
.68718 .55623 Mdot
.6884 .54593 Mdot
.68962 .54181 Mdot
.69084 .54181 Mdot
.69206 .54593 Mdot
.69328 .54799 Mdot
.6945 .54799 Mdot
.69572 .55623 Mdot
.69694 .56035 Mdot
.69816 .55829 Mdot
.69938 .55417 Mdot
.7006 .55417 Mdot
.70182 .54593 Mdot
.70304 .55211 Mdot
.70426 .55211 Mdot
.70548 .54593 Mdot
.70669 .55005 Mdot
.70791 .55005 Mdot
.70913 .54799 Mdot
.71035 .53769 Mdot
.71157 .54593 Mdot
.71279 .54799 Mdot
.71401 .55005 Mdot
.71523 .55417 Mdot
.71645 .56241 Mdot
.71767 .55211 Mdot
.71889 .55829 Mdot
.72011 .56035 Mdot
.72133 .55623 Mdot
.72255 .55623 Mdot
.72377 .56241 Mdot
.72499 .56035 Mdot
.72621 .56653 Mdot
.72743 .56859 Mdot
.72864 .57065 Mdot
.72986 .57683 Mdot
.73108 .57683 Mdot
.7323 .57271 Mdot
.73352 .56653 Mdot
.73474 .56035 Mdot
.73596 0 Mdot
.73718 0 Mdot
.7384 .55417 Mdot
.73962 .54387 Mdot
.74084 .53975 Mdot
.74206 .54387 Mdot
.74328 .53975 Mdot
.7445 .54181 Mdot
.74572 .53975 Mdot
.74694 .53151 Mdot
.74816 .53151 Mdot
.74938 .53151 Mdot
.75059 .53769 Mdot
.75181 .53975 Mdot
.75303 .53563 Mdot
.75425 .53357 Mdot
.75547 .53151 Mdot
.75669 .53975 Mdot
.75791 .55211 Mdot
.75913 .54799 Mdot
.76035 .54799 Mdot
.76157 .54593 Mdot
.76279 .54799 Mdot
.76401 .54799 Mdot
.76523 .54799 Mdot
.76645 .54387 Mdot
.76767 0 Mdot
.76889 .54181 Mdot
.77011 .53769 Mdot
.77132 .53975 Mdot
.77254 .53769 Mdot
.77376 .53975 Mdot
.77498 .54181 Mdot
.7762 .53769 Mdot
.77742 .53151 Mdot
.77864 .53769 Mdot
.77986 .53151 Mdot
.78108 .51709 Mdot
.7823 .52533 Mdot
.78352 .52327 Mdot
.78474 .51709 Mdot
.78596 .51709 Mdot
.78718 .51709 Mdot
.7884 .51709 Mdot
.78962 .52121 Mdot
.79084 .52121 Mdot
.79206 0 Mdot
.79327 0 Mdot
.79449 .51915 Mdot
.79571 .51503 Mdot
.79693 .51915 Mdot
.79815 .51297 Mdot
.79937 .51297 Mdot
.80059 .51709 Mdot
.80181 .50267 Mdot
.80303 .49031 Mdot
.80425 .49443 Mdot
.80547 .49649 Mdot
.80669 .49649 Mdot
.80791 .49443 Mdot
.80913 .49649 Mdot
.81035 .49031 Mdot
.81157 .50267 Mdot
.81279 .49443 Mdot
.81401 .49443 Mdot
.81522 .49855 Mdot
.81644 .49855 Mdot
.81766 .50061 Mdot
.81888 .49855 Mdot
.8201 .50061 Mdot
.82132 .50885 Mdot
.82254 .51503 Mdot
.82376 .51091 Mdot
.82498 .53357 Mdot
.8262 .51915 Mdot
.82742 .51297 Mdot
.82864 .51091 Mdot
.82986 .51709 Mdot
.83108 .52327 Mdot
.8323 .53769 Mdot
.83352 .53769 Mdot
.83474 .53769 Mdot
.83596 .52533 Mdot
.83717 .51297 Mdot
.83839 .52121 Mdot
.83961 .52121 Mdot
.84083 .54593 Mdot
.84205 .54181 Mdot
.84327 .53563 Mdot
.84449 .52533 Mdot
.84571 .52327 Mdot
.84693 .50885 Mdot
.84815 .51915 Mdot
.84937 .51915 Mdot
.85059 .52121 Mdot
.85181 .52533 Mdot
.85303 .51091 Mdot
.85425 .50267 Mdot
.85547 .49237 Mdot
.85669 .49855 Mdot
.85791 .49237 Mdot
.85912 .49031 Mdot
.86034 .48207 Mdot
.86156 .48413 Mdot
.86278 .48413 Mdot
.864 .48825 Mdot
.86522 0 Mdot
.86644 .48825 Mdot
.86766 .48413 Mdot
.86888 .48207 Mdot
.8701 .47795 Mdot
.87132 .46971 Mdot
.87254 .46147 Mdot
.87376 .45941 Mdot
.87498 .45941 Mdot
.8762 .45941 Mdot
.87742 .46559 Mdot
.87864 .47383 Mdot
.87985 .48207 Mdot
.88107 .48001 Mdot
.88229 .48207 Mdot
.88351 .48001 Mdot
.88473 .48207 Mdot
.88595 .47589 Mdot
.88717 .45529 Mdot
.88839 0 Mdot
.88961 0 Mdot
.89083 0 Mdot
.89205 0 Mdot
.89327 0 Mdot
.89449 0 Mdot
.89571 0 Mdot
.89693 0 Mdot
.89815 0 Mdot
.89937 0 Mdot
.90059 0 Mdot
.9018 0 Mdot
.90302 0 Mdot
.90424 0 Mdot
.90546 0 Mdot
.90668 0 Mdot
.9079 0 Mdot
.90912 0 Mdot
.91034 0 Mdot
.91156 0 Mdot
.91278 0 Mdot
.914 0 Mdot
.91522 0 Mdot
.91644 0 Mdot
.91766 0 Mdot
.91888 0 Mdot
.9201 0 Mdot
.92132 0 Mdot
.92254 0 Mdot
.92375 0 Mdot
.92497 0 Mdot
.92619 0 Mdot
.92741 0 Mdot
.92863 0 Mdot
.92985 0 Mdot
.93107 0 Mdot
.93229 0 Mdot
.93351 0 Mdot
.93473 0 Mdot
.93595 0 Mdot
.93717 0 Mdot
.93839 0 Mdot
.93961 0 Mdot
.94083 0 Mdot
.94205 0 Mdot
.94327 0 Mdot
.94449 0 Mdot
.9457 0 Mdot
.94692 0 Mdot
.94814 0 Mdot
.94936 0 Mdot
.95058 0 Mdot
.9518 0 Mdot
.95302 0 Mdot
.95424 0 Mdot
.95546 0 Mdot
.95668 0 Mdot
.9579 0 Mdot
.95912 0 Mdot
.96034 0 Mdot
.96156 0 Mdot
.96278 0 Mdot
.964 0 Mdot
.96522 0 Mdot
.96643 0 Mdot
.96765 0 Mdot
.96887 0 Mdot
.97009 0 Mdot
.97131 0 Mdot
.97253 0 Mdot
.97375 0 Mdot
.97497 0 Mdot
.97619 0 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
0.0238095 0.00121944 0 0.206011 [
[.16648 -0.0125 -34.3438 -11.375 ]
[.16648 -0.0125 34.3438 0 ]
[.40427 -0.0125 -34.3438 -11.375 ]
[.40427 -0.0125 34.3438 0 ]
[.64206 -0.0125 -34.3438 -11.375 ]
[.64206 -0.0125 34.3438 0 ]
[.87985 -0.0125 -34.3438 -11.375 ]
[.87985 -0.0125 34.3438 0 ]
[.01131 .10301 -21.6 -5.4 ]
[.01131 .10301 0 5.4 ]
[.01131 .20601 -7.2 -5.4 ]
[.01131 .20601 0 5.4 ]
[.01131 .30902 -21.6 -5.4 ]
[.01131 .30902 0 5.4 ]
[.01131 .41202 -7.2 -5.4 ]
[.01131 .41202 0 5.4 ]
[.01131 .51503 -21.6 -5.4 ]
[.01131 .51503 0 5.4 ]
[.01131 .61803 -7.2 -5.4 ]
[.01131 .61803 0 5.4 ]
[.5 .63053 -63.0938 0 ]
[.5 .63053 63.0938 11.75 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16648 0 m
.16648 .00625 L
s
gsave
.16648 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Jun) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(00) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40427 0 m
.40427 .00625 L
s
gsave
.40427 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mar) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.64206 0 m
.64206 .00625 L
s
gsave
.64206 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Dec) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(01) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.87985 0 m
.87985 .00625 L
s
gsave
.87985 -0.0125 -95.3438 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
77.375 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
84.562 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sep) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
113.312 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(02) show
127.688 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.5)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(1)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(2)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(2.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(3)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -124.094 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(maturity) show
127.688 12.875 moveto
(month) show
170.812 12.875 moveto
(27) show
185.188 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02503 .41202 Mdot
.02625 .4079 Mdot
.02747 .40584 Mdot
.02869 .39966 Mdot
.02991 .39348 Mdot
.03113 .38936 Mdot
.03235 .39348 Mdot
.03357 .40172 Mdot
.03478 .40584 Mdot
.036 .40996 Mdot
.03722 .4285 Mdot
.03844 .45322 Mdot
.03966 .46559 Mdot
.04088 .46971 Mdot
.0421 .47589 Mdot
.04332 .48207 Mdot
.04454 .48207 Mdot
.04576 .50061 Mdot
.04698 .51091 Mdot
.0482 .51297 Mdot
.04942 .50473 Mdot
.05064 .50473 Mdot
.05186 .50885 Mdot
.05308 .50885 Mdot
.0543 .50885 Mdot
.05551 .51091 Mdot
.05673 .50473 Mdot
.05795 .49855 Mdot
.05917 .49855 Mdot
.06039 .49649 Mdot
.06161 .50885 Mdot
.06283 .51709 Mdot
.06405 .51297 Mdot
.06527 .51915 Mdot
.06649 .52121 Mdot
.06771 .52121 Mdot
.06893 .52327 Mdot
.07015 .52533 Mdot
.07137 .52533 Mdot
.07259 .52739 Mdot
.07381 .52739 Mdot
.07503 .51915 Mdot
.07625 .50679 Mdot
.07746 .50061 Mdot
.07868 .50061 Mdot
.0799 .50061 Mdot
.08112 .50061 Mdot
.08234 .50473 Mdot
.08356 .50679 Mdot
.08478 .50473 Mdot
.086 .50885 Mdot
.08722 .50061 Mdot
.08844 .49855 Mdot
.08966 .49237 Mdot
.09088 .49237 Mdot
.0921 .48619 Mdot
.09332 .51915 Mdot
.09454 .52739 Mdot
.09576 .52945 Mdot
.09698 .53563 Mdot
.0982 .53769 Mdot
.09941 .54593 Mdot
.10063 .55417 Mdot
.10185 .55829 Mdot
.10307 .55211 Mdot
.10429 .56035 Mdot
.10551 .55623 Mdot
.10673 .55417 Mdot
.10795 .54799 Mdot
.10917 .53975 Mdot
.11039 .53357 Mdot
.11161 .53151 Mdot
.11283 .52739 Mdot
.11405 .52121 Mdot
.11527 .51709 Mdot
.11649 .51503 Mdot
.11771 .51709 Mdot
.11893 .51709 Mdot
.12015 0 Mdot
.12136 0 Mdot
.12258 .51915 Mdot
.1238 0 Mdot
.12502 0 Mdot
.12624 0 Mdot
.12746 0 Mdot
.12868 0 Mdot
.1299 0 Mdot
.13112 0 Mdot
.13234 0 Mdot
.13356 0 Mdot
.13478 0 Mdot
.136 0 Mdot
.13722 0 Mdot
.13844 0 Mdot
.13966 0 Mdot
.14088 0 Mdot
.14209 0 Mdot
.14331 0 Mdot
.14453 0 Mdot
.14575 0 Mdot
.14697 0 Mdot
.14819 0 Mdot
.14941 0 Mdot
.15063 0 Mdot
.15185 0 Mdot
.15307 0 Mdot
.15429 0 Mdot
.15551 0 Mdot
.15673 0 Mdot
.15795 0 Mdot
.15917 0 Mdot
.16039 0 Mdot
.16161 0 Mdot
.16283 0 Mdot
.16404 0 Mdot
.16526 0 Mdot
.16648 0 Mdot
.1677 0 Mdot
.16892 0 Mdot
.17014 0 Mdot
.17136 0 Mdot
.17258 0 Mdot
.1738 0 Mdot
.17502 .4388 Mdot
.17624 .44086 Mdot
.17746 .43468 Mdot
.17868 .43056 Mdot
.1799 .42438 Mdot
.18112 .42232 Mdot
.18234 .42026 Mdot
.18356 .42232 Mdot
.18478 .4285 Mdot
.18599 .4285 Mdot
.18721 .43056 Mdot
.18843 .4388 Mdot
.18965 .4388 Mdot
.19087 .43674 Mdot
.19209 .4388 Mdot
.19331 .4388 Mdot
.19453 .44086 Mdot
.19575 .44704 Mdot
.19697 .45116 Mdot
.19819 .45529 Mdot
.19941 .45735 Mdot
.20063 .46147 Mdot
.20185 .46147 Mdot
.20307 .48001 Mdot
.20429 .47795 Mdot
.20551 .48001 Mdot
.20673 .48413 Mdot
.20794 .48413 Mdot
.20916 .48207 Mdot
.21038 .48001 Mdot
.2116 .48001 Mdot
.21282 .48001 Mdot
.21404 .48413 Mdot
.21526 .48413 Mdot
.21648 .48413 Mdot
.2177 .49031 Mdot
.21892 .49443 Mdot
.22014 .48207 Mdot
.22136 .48825 Mdot
.22258 .49443 Mdot
.2238 .49649 Mdot
.22502 .49649 Mdot
.22624 .50267 Mdot
.22746 .50267 Mdot
.22868 .50267 Mdot
.22989 .50473 Mdot
.23111 0 Mdot
.23233 .50885 Mdot
.23355 .51091 Mdot
.23477 .51091 Mdot
.23599 .51297 Mdot
.23721 .51297 Mdot
.23843 .51503 Mdot
.23965 .51709 Mdot
.24087 .52121 Mdot
.24209 .52327 Mdot
.24331 .52327 Mdot
.24453 .51915 Mdot
.24575 .52533 Mdot
.24697 .52121 Mdot
.24819 .52121 Mdot
.24941 .52533 Mdot
.25062 .52739 Mdot
.25184 .52945 Mdot
.25306 .52739 Mdot
.25428 .52327 Mdot
.2555 .52327 Mdot
.25672 .52327 Mdot
.25794 .52327 Mdot
.25916 .52327 Mdot
.26038 .52327 Mdot
.2616 .52533 Mdot
.26282 .52739 Mdot
.26404 .52945 Mdot
.26526 .52945 Mdot
.26648 .52945 Mdot
.2677 .52739 Mdot
.26892 .52533 Mdot
.27014 .51915 Mdot
.27136 .51915 Mdot
.27257 .50885 Mdot
.27379 .51091 Mdot
.27501 .51709 Mdot
.27623 .52121 Mdot
.27745 .52121 Mdot
.27867 .52327 Mdot
.27989 .52945 Mdot
.28111 .53563 Mdot
.28233 .53151 Mdot
.28355 .52945 Mdot
.28477 .52945 Mdot
.28599 .52945 Mdot
.28721 .52945 Mdot
.28843 .52945 Mdot
.28965 .52327 Mdot
.29087 .52533 Mdot
.29209 .51915 Mdot
.29331 .51709 Mdot
.29452 .51709 Mdot
.29574 .52739 Mdot
.29696 .52533 Mdot
.29818 .52533 Mdot
.2994 .52327 Mdot
.30062 .51709 Mdot
.30184 .50267 Mdot
.30306 .50267 Mdot
.30428 .51709 Mdot
.3055 .51709 Mdot
.30672 .51091 Mdot
.30794 .50473 Mdot
.30916 .50267 Mdot
.31038 .50061 Mdot
.3116 .49649 Mdot
.31282 .49031 Mdot
.31404 .48825 Mdot
.31526 .48825 Mdot
.31647 .48825 Mdot
.31769 .48825 Mdot
.31891 .48413 Mdot
.32013 .48001 Mdot
.32135 .48001 Mdot
.32257 .48001 Mdot
.32379 .48001 Mdot
.32501 .48207 Mdot
.32623 .48413 Mdot
.32745 .47795 Mdot
.32867 .47795 Mdot
.32989 .47795 Mdot
.33111 .46971 Mdot
.33233 .46971 Mdot
.33355 .47177 Mdot
.33477 0 Mdot
.33599 0 Mdot
.33721 .47177 Mdot
.33842 .46971 Mdot
.33964 .46971 Mdot
.34086 0 Mdot
.34208 .46765 Mdot
.3433 .46971 Mdot
.34452 .47177 Mdot
.34574 .47383 Mdot
.34696 .47589 Mdot
.34818 .47589 Mdot
.3494 .46147 Mdot
.35062 .46147 Mdot
.35184 .45941 Mdot
.35306 .45941 Mdot
.35428 .45941 Mdot
.3555 .46147 Mdot
.35672 .45941 Mdot
.35794 .45941 Mdot
.35915 .45941 Mdot
.36037 .46147 Mdot
.36159 .46559 Mdot
.36281 .46353 Mdot
.36403 .46559 Mdot
.36525 .46353 Mdot
.36647 .46147 Mdot
.36769 .46147 Mdot
.36891 .46559 Mdot
.37013 .47177 Mdot
.37135 .47177 Mdot
.37257 .46971 Mdot
.37379 .47177 Mdot
.37501 .47177 Mdot
.37623 .47177 Mdot
.37745 .46971 Mdot
.37867 .46765 Mdot
.37989 .46971 Mdot
.3811 .47589 Mdot
.38232 .47795 Mdot
.38354 .47795 Mdot
.38476 .48207 Mdot
.38598 .48413 Mdot
.3872 .48619 Mdot
.38842 .48825 Mdot
.38964 .49443 Mdot
.39086 .49649 Mdot
.39208 .51503 Mdot
.3933 .51709 Mdot
.39452 .51915 Mdot
.39574 .52327 Mdot
.39696 .52533 Mdot
.39818 .53151 Mdot
.3994 .53151 Mdot
.40062 .53151 Mdot
.40184 .53151 Mdot
.40305 .52739 Mdot
.40427 .52739 Mdot
.40549 .54799 Mdot
.40671 .53769 Mdot
.40793 .54181 Mdot
.40915 .54387 Mdot
.41037 .54181 Mdot
.41159 .53563 Mdot
.41281 .53151 Mdot
.41403 .53563 Mdot
.41525 .53975 Mdot
.41647 .55829 Mdot
.41769 .58095 Mdot
.41891 .58919 Mdot
.42013 .58919 Mdot
.42135 .59537 Mdot
.42257 .59125 Mdot
.42379 .58507 Mdot
.425 .57889 Mdot
.42622 .57889 Mdot
.42744 .58301 Mdot
.42866 .59537 Mdot
.42988 .59949 Mdot
.4311 0 Mdot
.43232 0 Mdot
.43354 .60361 Mdot
.43476 .60567 Mdot
.43598 .59949 Mdot
.4372 .59537 Mdot
.43842 .58919 Mdot
.43964 .58919 Mdot
.44086 .59331 Mdot
.44208 .60155 Mdot
.4433 .60361 Mdot
.44452 .60979 Mdot
.44574 .60155 Mdot
.44695 .59743 Mdot
.44817 .59331 Mdot
.44939 .58301 Mdot
.45061 0 Mdot
.45183 .58301 Mdot
.45305 .57889 Mdot
.45427 .57889 Mdot
.45549 .57477 Mdot
.45671 .57477 Mdot
.45793 .58095 Mdot
.45915 .57683 Mdot
.46037 .57889 Mdot
.46159 .58507 Mdot
.46281 .58713 Mdot
.46403 .58507 Mdot
.46525 .58301 Mdot
.46647 .58713 Mdot
.46768 .59949 Mdot
.4689 0 Mdot
.47012 .60567 Mdot
.47134 .60979 Mdot
.47256 .60979 Mdot
.47378 .60155 Mdot
.475 .59743 Mdot
.47622 .59743 Mdot
.47744 .58919 Mdot
.47866 .58301 Mdot
.47988 .58507 Mdot
.4811 .58507 Mdot
.48232 .59743 Mdot
.48354 .59743 Mdot
.48476 .59743 Mdot
.48598 .59743 Mdot
.4872 .59331 Mdot
.48842 .59125 Mdot
.48963 .58507 Mdot
.49085 .59125 Mdot
.49207 .58507 Mdot
.49329 .58301 Mdot
.49451 .57889 Mdot
.49573 .58095 Mdot
.49695 .59743 Mdot
.49817 .59949 Mdot
.49939 .59949 Mdot
.50061 .59743 Mdot
.50183 .59537 Mdot
.50305 .58919 Mdot
.50427 .58507 Mdot
.50549 .58301 Mdot
.50671 .58301 Mdot
.50793 .58095 Mdot
.50915 .58713 Mdot
.51037 .58713 Mdot
.51158 .58919 Mdot
.5128 .58713 Mdot
.51402 .56859 Mdot
.51524 .57889 Mdot
.51646 .57889 Mdot
.51768 .58095 Mdot
.5189 .58713 Mdot
.52012 .59537 Mdot
.52134 .59537 Mdot
.52256 .59331 Mdot
.52378 .58713 Mdot
.525 .57477 Mdot
.52622 .57065 Mdot
.52744 .55829 Mdot
.52866 .53975 Mdot
.52988 .53769 Mdot
.5311 .53769 Mdot
.53232 .53357 Mdot
.53353 .51709 Mdot
.53475 .51915 Mdot
.53597 .51709 Mdot
.53719 .52121 Mdot
.53841 .53357 Mdot
.53963 .53357 Mdot
.54085 .52533 Mdot
.54207 .52533 Mdot
.54329 .52945 Mdot
.54451 .53151 Mdot
.54573 .52945 Mdot
.54695 .53151 Mdot
.54817 0 Mdot
.54939 .53151 Mdot
.55061 .52945 Mdot
.55183 .52739 Mdot
.55305 .52327 Mdot
.55426 .51709 Mdot
.55548 .53357 Mdot
.5567 .54387 Mdot
.55792 .53975 Mdot
.55914 .53151 Mdot
.56036 .53357 Mdot
.56158 .52945 Mdot
.5628 .52739 Mdot
.56402 .53975 Mdot
.56524 .54799 Mdot
.56646 .54799 Mdot
.56768 .55623 Mdot
.5689 .55623 Mdot
.57012 .55005 Mdot
.57134 .53975 Mdot
.57256 .52327 Mdot
.57378 .52327 Mdot
.575 .53357 Mdot
.57621 .54799 Mdot
.57743 .55005 Mdot
.57865 .55417 Mdot
.57987 .56241 Mdot
.58109 .55211 Mdot
.58231 .55417 Mdot
.58353 .55211 Mdot
.58475 .55005 Mdot
.58597 .55829 Mdot
.58719 .56035 Mdot
.58841 .55829 Mdot
.58963 .55211 Mdot
.59085 .54593 Mdot
.59207 .53975 Mdot
.59329 .53357 Mdot
.59451 .53769 Mdot
.59573 .53975 Mdot
.59695 .53975 Mdot
.59816 .54181 Mdot
.59938 .51709 Mdot
.6006 .50473 Mdot
.60182 .51503 Mdot
.60304 .51297 Mdot
.60426 .50267 Mdot
.60548 .49237 Mdot
.6067 .48413 Mdot
.60792 .48825 Mdot
.60914 .47795 Mdot
.61036 .47383 Mdot
.61158 .46353 Mdot
.6128 .45116 Mdot
.61402 .44704 Mdot
.61524 .44292 Mdot
.61646 .44704 Mdot
.61768 .46559 Mdot
.6189 .49237 Mdot
.62011 .49443 Mdot
.62133 .49649 Mdot
.62255 .50061 Mdot
.62377 .51297 Mdot
.62499 .50679 Mdot
.62621 .50885 Mdot
.62743 .51091 Mdot
.62865 .53563 Mdot
.62987 .52739 Mdot
.63109 .52533 Mdot
.63231 .51709 Mdot
.63353 .50679 Mdot
.63475 .50473 Mdot
.63597 .51709 Mdot
.63719 .53357 Mdot
.63841 .54181 Mdot
.63963 .53769 Mdot
.64085 .53357 Mdot
.64206 .52327 Mdot
.64328 .52327 Mdot
.6445 .51709 Mdot
.64572 .51297 Mdot
.64694 .50885 Mdot
.64816 .50473 Mdot
.64938 .50267 Mdot
.6506 .50473 Mdot
.65182 .56241 Mdot
.65304 0 Mdot
.65426 0 Mdot
.65548 .57271 Mdot
.6567 .57271 Mdot
.65792 .57065 Mdot
.65914 0 Mdot
.66036 .56859 Mdot
.66158 .56653 Mdot
.66279 .57065 Mdot
.66401 .57065 Mdot
.66523 .56859 Mdot
.66645 .57477 Mdot
.66767 .56859 Mdot
.66889 .56859 Mdot
.67011 .56447 Mdot
.67133 .54799 Mdot
.67255 .54181 Mdot
.67377 .53563 Mdot
.67499 .53769 Mdot
.67621 .53357 Mdot
.67743 .53563 Mdot
.67865 .52945 Mdot
.67987 .55005 Mdot
.68109 .55829 Mdot
.68231 .55829 Mdot
.68353 .56035 Mdot
.68474 .56035 Mdot
.68596 .55623 Mdot
.68718 .55623 Mdot
.6884 .54593 Mdot
.68962 .54181 Mdot
.69084 .54181 Mdot
.69206 .54593 Mdot
.69328 .54799 Mdot
.6945 .55005 Mdot
.69572 .55623 Mdot
.69694 .56035 Mdot
.69816 .56035 Mdot
.69938 .55623 Mdot
.7006 .55417 Mdot
.70182 .54799 Mdot
.70304 .55417 Mdot
.70426 .55417 Mdot
.70548 .54799 Mdot
.70669 .55211 Mdot
.70791 .55211 Mdot
.70913 .55005 Mdot
.71035 .53975 Mdot
.71157 .54799 Mdot
.71279 .55005 Mdot
.71401 .55417 Mdot
.71523 .55623 Mdot
.71645 .56447 Mdot
.71767 .55623 Mdot
.71889 .56035 Mdot
.72011 .56241 Mdot
.72133 .55829 Mdot
.72255 .55829 Mdot
.72377 .56447 Mdot
.72499 .56241 Mdot
.72621 .56859 Mdot
.72743 .57065 Mdot
.72864 .57477 Mdot
.72986 .57889 Mdot
.73108 .58095 Mdot
.7323 .57477 Mdot
.73352 .56859 Mdot
.73474 .56447 Mdot
.73596 0 Mdot
.73718 0 Mdot
.7384 .55623 Mdot
.73962 .54799 Mdot
.74084 .54181 Mdot
.74206 .54593 Mdot
.74328 .54387 Mdot
.7445 .54387 Mdot
.74572 .54181 Mdot
.74694 .53357 Mdot
.74816 .53563 Mdot
.74938 .53357 Mdot
.75059 .53975 Mdot
.75181 .54181 Mdot
.75303 .53769 Mdot
.75425 .53563 Mdot
.75547 .53357 Mdot
.75669 .54387 Mdot
.75791 .55417 Mdot
.75913 .55005 Mdot
.76035 .55005 Mdot
.76157 .55005 Mdot
.76279 .55005 Mdot
.76401 .55005 Mdot
.76523 .55005 Mdot
.76645 .54799 Mdot
.76767 0 Mdot
.76889 .54387 Mdot
.77011 .53975 Mdot
.77132 .54387 Mdot
.77254 .54181 Mdot
.77376 .54181 Mdot
.77498 .54593 Mdot
.7762 .54181 Mdot
.77742 .53563 Mdot
.77864 .54181 Mdot
.77986 .53357 Mdot
.78108 .52121 Mdot
.7823 .52739 Mdot
.78352 .52533 Mdot
.78474 .51915 Mdot
.78596 .51915 Mdot
.78718 .51915 Mdot
.7884 .51915 Mdot
.78962 .52327 Mdot
.79084 .52327 Mdot
.79206 0 Mdot
.79327 0 Mdot
.79449 .52121 Mdot
.79571 .51915 Mdot
.79693 .52121 Mdot
.79815 .51503 Mdot
.79937 .51709 Mdot
.80059 .52121 Mdot
.80181 .50473 Mdot
.80303 .49237 Mdot
.80425 .49649 Mdot
.80547 .49855 Mdot
.80669 .49855 Mdot
.80791 .49649 Mdot
.80913 .49855 Mdot
.81035 .49237 Mdot
.81157 .50473 Mdot
.81279 .49649 Mdot
.81401 .49649 Mdot
.81522 .50061 Mdot
.81644 .50267 Mdot
.81766 .50267 Mdot
.81888 .50061 Mdot
.8201 .50267 Mdot
.82132 .51297 Mdot
.82254 .51709 Mdot
.82376 .51503 Mdot
.82498 .53769 Mdot
.8262 .52121 Mdot
.82742 .51503 Mdot
.82864 .51503 Mdot
.82986 .52121 Mdot
.83108 .52533 Mdot
.8323 .53975 Mdot
.83352 .53975 Mdot
.83474 .53975 Mdot
.83596 .52739 Mdot
.83717 .51503 Mdot
.83839 .52533 Mdot
.83961 .52327 Mdot
.84083 .54799 Mdot
.84205 .54593 Mdot
.84327 .53769 Mdot
.84449 .52739 Mdot
.84571 .52739 Mdot
.84693 .51091 Mdot
.84815 .52121 Mdot
.84937 .52327 Mdot
.85059 .52327 Mdot
.85181 .52739 Mdot
.85303 .51297 Mdot
.85425 .50473 Mdot
.85547 .49443 Mdot
.85669 .50061 Mdot
.85791 .49443 Mdot
.85912 .49237 Mdot
.86034 .48619 Mdot
.86156 .48825 Mdot
.86278 .48619 Mdot
.864 .49031 Mdot
.86522 0 Mdot
.86644 .49031 Mdot
.86766 .48619 Mdot
.86888 .48413 Mdot
.8701 .48001 Mdot
.87132 .47177 Mdot
.87254 .46353 Mdot
.87376 .46147 Mdot
.87498 .46147 Mdot
.8762 .46147 Mdot
.87742 .46765 Mdot
.87864 .47589 Mdot
.87985 .48413 Mdot
.88107 .48207 Mdot
.88229 .48413 Mdot
.88351 .48207 Mdot
.88473 .48413 Mdot
.88595 .47795 Mdot
.88717 .45735 Mdot
.88839 0 Mdot
.88961 0 Mdot
.89083 0 Mdot
.89205 0 Mdot
.89327 0 Mdot
.89449 0 Mdot
.89571 0 Mdot
.89693 0 Mdot
.89815 0 Mdot
.89937 0 Mdot
.90059 0 Mdot
.9018 0 Mdot
.90302 0 Mdot
.90424 0 Mdot
.90546 0 Mdot
.90668 0 Mdot
.9079 0 Mdot
.90912 0 Mdot
.91034 0 Mdot
.91156 0 Mdot
.91278 0 Mdot
.914 0 Mdot
.91522 0 Mdot
.91644 0 Mdot
.91766 0 Mdot
.91888 0 Mdot
.9201 0 Mdot
.92132 0 Mdot
.92254 0 Mdot
.92375 0 Mdot
.92497 0 Mdot
.92619 0 Mdot
.92741 0 Mdot
.92863 0 Mdot
.92985 0 Mdot
.93107 0 Mdot
.93229 0 Mdot
.93351 0 Mdot
.93473 0 Mdot
.93595 0 Mdot
.93717 0 Mdot
.93839 0 Mdot
.93961 0 Mdot
.94083 0 Mdot
.94205 0 Mdot
.94327 0 Mdot
.94449 0 Mdot
.9457 0 Mdot
.94692 0 Mdot
.94814 0 Mdot
.94936 0 Mdot
.95058 0 Mdot
.9518 0 Mdot
.95302 0 Mdot
.95424 0 Mdot
.95546 0 Mdot
.95668 0 Mdot
.9579 0 Mdot
.95912 0 Mdot
.96034 0 Mdot
.96156 0 Mdot
.96278 0 Mdot
.964 0 Mdot
.96522 0 Mdot
.96643 0 Mdot
.96765 0 Mdot
.96887 0 Mdot
.97009 0 Mdot
.97131 0 Mdot
.97253 0 Mdot
.97375 0 Mdot
.97497 0 Mdot
.97619 0 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{800, 494.375},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000<P0001kR000`400?l00000o`00003oo`3ooooo
0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00
o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS
0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0oooo
o`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?oo
ool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooC03oool300000?l0oooo
S03oool3000004@0oooo003o0?ooodd0oooo00<000000?ooo`3oool0o`3ooon<0?ooo`030000003o
ool0oooo04<0oooo003o0?ooodd0oooo00<000000?ooo`3oool0o`3ooon<0?ooo`030000003oool0
oooo04<0oooo00190?ooo`D00000103oool3000000/0oooo0P0000050?ooo`<0000000<0oooo0000
000000000P0000020?ooo`8000002P3oool3000000@0oooo0`00000=0?ooo`D00000103oool30000
00P0oooo0`000000103oool000000000000000020?ooo`<0000000<0oooo0000003oool01000000<
0?ooo`<000000`3oool5000000`0oooo1@0000020?ooo`D00000203oool5000000@0oooo0`000004
0?ooo`<00000303oool3000000<0oooo1@00000<0?ooo`D000000P3oool5000000X0oooo10000004
0?ooo`<000000`3oool4000000/0oooo0`0000030?ooo`D00000LP3oool5000000@0oooo0`00000:
0?ooo`8000001@3oool3000000030?ooo`0000000000008000000P3oool2000000X0oooo0`000004
0?ooo`<000003@3oool5000000@0oooo0`0000080?ooo`<0000000@0oooo00000000000000000P3o
ool3000000030?ooo`000000oooo00@00000303oool3000000<0oooo1@00000<0?ooo`D000000P3o
ool5000000T0oooo1@0000040?ooo`<00000103oool3000000/0oooo0`0000030?ooo`D00000303o
ool500000080oooo1@00000:0?ooo`@00000103oool3000000<0oooo1000000<0?ooo`<000000`3o
ool5000002/0oooo001;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool0
10000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000X0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000003P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`0;0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
0000000:0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000002@3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000001d0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`0000030?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0;0?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo0000000[0?ooo`00B`3oool010000000oooo0?ooo`3o
ool6000000<0oooo1@0000020?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool500000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000003P3oool010000000oooo0?oo
o`3oool600000080oooo1@0000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0103oool500000080oooo00D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`D000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`D000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo1@0000070?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`3oool0M@3oool010000000oooo0?ooo`3oool600000080oooo1@0000020?ooo`040000003o
ool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool500000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000003P3oool010000000oooo0?ooo`3oool600000080oooo1@0000020?ooo`050000
003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0103oool500000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`D000000`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo1@0000060?ooo`040000
003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo000000020?ooo`D000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0;03oool004/0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00`0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0203oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000>0?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`080?ooo`050000003oool000000?ooo`0000000`3o
ool4000000<0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo
00D000000?ooo`3oool0oooo000000020?ooo`D000000P3oool00`000000oooo0?ooo`0<0?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0303oool300000080oooo1@0000020?ooo`050000003oool0oooo
0?ooo`0000002@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0M03o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool02`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`080?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000
oooo000000030?ooo`@000000`3oool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02P3oool01@000000oooo0?ooo`3oool000000080oooo1@0000020?ooo`030000003oool0
oooo00/0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`<000000P3oool500000080oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`0[0?ooo`00B`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000h0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo008000000P3oool00`00
0000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000h0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00000:0?ooo`050000
003oool000000?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000d0oooo00D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02P3oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000002@3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
L`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000d0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`080?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`00000:0?ooo`050000003oool000000?ooo`00
00001P3oool01@000000oooo0?ooo`3oool0000000d0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`09
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool30000
00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000002P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0:P3oool004/0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0000000>0?ooo`030000003oool0oooo008000000P3o
ool2000000030?ooo`000000oooo00<000002`3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
00002P3oool2000000030?ooo`00000000000080oooo100000030?ooo`030000003oool000000080
00002P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002@3oool01@000000oooo0?ooo`3o
ool0000000<0oooo0`0000040?ooo`<000002`3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01@3oool300000080oooo00<000000?ooo`0000000P00000:0?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000007@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0000000=0?ooo`030000003oool0oooo008000000P3oool20000
00030?ooo`000000oooo00<000002`3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000002P3o
ool2000000030?ooo`00000000000080oooo100000030?ooo`030000003oool00000008000002P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool00000
00<0oooo0`0000040?ooo`<000002P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool01@3oool300000080oooo00<000000?ooo`0000000P00000;0?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000002/0oooo001;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`0000003P3oool00`000000oooo0?ooo`0G0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0000000:0?ooo`80000000<0oooo000000000000603oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000002@3oool01@000000oooo0?ooo`3oool0000001P0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000005`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000001d0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`0000003@3oool00`000000oooo0?ooo`0G0?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0000000:0?ooo`80000000<0oooo000000000000603oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool0000001L0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`000000603oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000[0?ooo`00B@3oool3000000H0
oooo0P00000<0?ooo`@00000603oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo0000000<0?ooo`<000001P3oool2000000T0oooo0P0000030?ooo`8000005`3oool0
1@000000oooo0?ooo`3oool000000080oooo0`00000>0?ooo`<00000103oool01@000000oooo0?oo
o`3oool0000000P0oooo1@00000I0?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000h0
oooo0`0000040?ooo`<000003@3oool4000001L0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000LP3oool3000000H0oooo0P00000;0?ooo`@00000603oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000<0?ooo`<00000
1P3oool2000000T0oooo0P0000030?ooo`8000005`3oool01@000000oooo0?ooo`3oool000000080
oooo0`00000>0?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000T0oooo1@00000H0?oo
o`050000003oool0oooo0?ooo`0000000P3oool3000000h0oooo0`0000040?ooo`<000003@3oool4
000001P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
:`3oool004/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0W0?ooo`<00000103o
ool3000000l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`<000001@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo0`00000X0?ooo`<000001@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool09`3o
ool3000000@0oooo0`00001e0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09P3o
ool3000000@0oooo0`00000?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09P3o
ool3000000D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`<00000:03o
ool3000000D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02P0oooo0`0000040?ooo`<00000;03oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?oo
ool0ooooo`3ooolS0?ooo`00=@3ooooo000003X00000E@3ooooo000003X00000903oool003`0oooo
00<000000?ooo`3oool0703oool9000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool000000180oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0J0?ooo`070000003oool0oooo0?ooo`000000oooo0000000G0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool2000001D0oooo00D000000?oo
o`3oool0oooo000000020?oooad00000I03oool00`000000oooo0?ooo`0K0?ooo`@000001P3oool0
1@000000oooo0?ooo`3oool0000001@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0000
000B0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool06P3oool010000000oooo0?oo
o`3oool3000001L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0L000002/0oooo
000l0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`170?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04L0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool0
0`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000
oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?oo
o`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool2
00000?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo
0?l0ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0
ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0
ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0oooo
S@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03o
ool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool0
0`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009@3oool3000000@0
oooo00<000000?ooo`3oool00`3oool4000000H0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`<0
0000103oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000oooo0?ooo`3o0?oooe<0
oooo000T0?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooome0?ooo`050000003oool0oooo0?oo
o`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooomC0?ooo`00903oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?oo
o`3oool00`3oool300000?l0ooooM@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<00000
0?ooo`3oool00`3oool300000?l0ooooD`3oool002@0oooo00D000000?ooo`3oool0oooo0000000=
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooome0?ooo`050000003oool0
oooo0?ooo`0000003@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0ooooD`3o
ool002@0oooo00D000000?ooo`3oool0oooo000000090?ooo`@000001P3oool00`000000oooo0?oo
o`3o0?ooogD0oooo00D000000?ooo`3oool0oooo000000090?ooo`@000001P3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000T0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0?l0ooooM@3oool01@000000oooo0?ooo`3oool0000000T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000T0?ooo`050000
003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0
ooooM@3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000T0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooM@3oool01@000000oooo0?ooo`3oool0
000000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000U0?oo
o`<000002P3oool5000000D0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`<000002P3oool50000
00D0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool200000?l0
ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0
oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo
0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?oo
o`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000
oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?oo
o`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o
0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool20000
0?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0
ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool00380oooo1@0000050?ooo`030000003oool0oooo0?l0ooooP`3oool5000000D0oooo00<00000
0?ooo`3oool0o`3ooomC0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0?l0ooooQ@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool003@0
oooo00<000000?ooo`3oool01@3oool300000?l0ooooQ@3oool00`000000oooo0?ooo`050?ooo`<0
0000o`3ooomC0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo
Q@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool003@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooohD0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000d0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0o`3ooon50?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooomC
0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooQ@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool00380oooo0`0000070?ooo`03
0000003oool0oooo0?l0ooooP`3oool3000000L0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00
=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooQ@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo0P00003o0?ooohh0oooo0P00
003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o
0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0
oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo
000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l
0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool00`000000oooo0?ooo`3o0?oo
ohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0
oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo
00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<0
00000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<00000
0?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?oo
o`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool200000?l0ooooE03oool003`0oooo
00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<0
00000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<00000
0?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<000000?oo
o`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<000000?ooo`3o
ool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo0P00003o0?ooohh0oooo
0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?oo
o`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o
0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo000T0?ooo`D000000`3oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000
oooo0?ooo`3o0?ooogD0oooo1@0000030?ooo`030000003oool0oooo00<0oooo100000060?ooo`03
0000003oool0oooo0?l0ooooD`3oool002H0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0?l0ooooD`3oool002H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0?l0ooooM`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00<0oooo0`00003o0?ooogL0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`030?ooo`<00000o`3ooomC0?ooo`009P3oool00`000000oooo0?ooo`090?oo
o`@000001P3oool00`000000oooo0?ooo`3o0?ooogL0oooo00<000000?ooo`3oool02@3oool40000
00H0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000V0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooogL0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0oooo
D`3oool002@0oooo0`00000;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3o
oome0?ooo`<000002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooD`3o
ool002H0oooo00<000000?ooo`3oool02@3oool5000000D0oooo00<000000?ooo`3oool0o`3ooomg
0?ooo`030000003oool0oooo00T0oooo1@0000050?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0
ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0oooo
S@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`<00000o`3ooomC0?ooo`00
?03oool00`000000oooo0?ooo`3o0?ooohd0oooo1000003o0?oooe80oooo000l0?ooo`030000003o
ool0oooo0?l0ooooS@3oool010000000oooo00000000003o0?oooe80oooo000l0?ooo`030000003o
ool0oooo0?l0ooooS@3oool200000?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=
0?ooo`@00000o`3ooomB0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo1000003o0?oo
oe80oooo000l0?ooo`040000003oool0000000000?l0ooooS03oool2000000030?ooo`000000oooo
01/0oooo0P00003o0?oooc@0oooo000l0?ooo`@00000o`3ooon;0?ooo`<0000000<0oooo00000000
0000703oool00`000000oooo0?ooo`3o0?oooc80oooo000l0?ooo`040000003oool0000000000?l0
ooooS03oool01@000000oooo0?ooo`3oool0000001/0oooo0P00003o0?oooc@0oooo000l0?ooo`@0
0000o`3ooon<0?ooo`030000003oool0oooo01h0oooo0P00003o0?oooc<0oooo000l0?ooo`030000
003oool0000000800000o`3ooon;0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0
o`3ooola0?ooo`00?03oool00`000000oooo0?ooo`0200000?l0ooooR`3oool00`000000oooo0?oo
o`3o0?oooe<0oooo000l0?ooo`D00000o`3ooon;0?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo0`0000000`3oool000000?ooo`3o0?ooohX0oooo0P0000000`3oool000000000000L0?oo
o`800000o`3ooolc0?ooo`00?03oool200000?l0ooooSP3oool01@000000oooo0?ooo`3oool00000
01`0oooo1000003o0?oooc40oooo000l0?ooo`800000o`3ooon>0?ooo`030000003oool0oooo01l0
oooo0`00003o0?oooc40oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo
0?ooo`0P0?ooo`8000002`3oool300000?l0oooo8`3oool00380oooo1@0000050?ooo`030000003o
ool0oooo0?l0ooooP`3oool5000000D0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?oo
o`090?ooo`<00000o`3ooolS0?ooo`00<P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0o`3ooon30?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`0^0?ooo`800000o`3ooolS0?ooo`00<`3oool00`000000oooo0?ooo`060?ooo`040000003o
ool0oooo0?ooo`800000:`3oool200000?l0ooooE03oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0200oooo0`0000070?ooo`L00000o`3ooolR0?ooo`00=03oool00`000000oooo0?oo
o`050?ooo`<000000P3oool00`000000oooo0?ooo`0X0?ooo`<00000o`3ooomE0?ooo`030000003o
ool0oooo00D0oooo0`00000Q0?ooo`8000001`3oool4000000030?ooo`00000000000?l0oooo8P3o
ool003D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0^0?ooo`<00000o`3ooomE
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P00000P0?ooo`80000000D0oooo
00000000000000000?ooo`05000000040?ooo`000000000000000?l0oooo8@3oool00380oooo00D0
00000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo02d0oooo0P0000000`3oool00000
0000003o0?oooe40oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0oooo0?oo
o`0000008@3oool00`000000oooo0?ooo`03000000040?ooo`0000000000000000<0oooo0`00003o
0?ooob00oooo000b0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0[
0?ooo`@000000P3oool00`000000oooo0?ooo`3o0?ooodl0oooo00D000000?ooo`3oool0oooo0000
00050?ooo`030000003oool0oooo0280oooo0P0000030?ooo`@0000000<0oooo0000003oool00`3o
ool200000?l0oooo803oool00380oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003o
ool0oooo02H0oooo0P0000020?ooo`<0000000@0oooo0000003oool0oooo0P00003o0?oooe00oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo02<0oooo0P0000030?ooo`<0
00001`3oool00`000000oooo0?ooo`3o0?oooah0oooo000c0?ooo`<000001P3oool00`000000oooo
0?ooo`0W0?ooo`L000000P3oool400000?l0ooooD03oool3000000H0oooo00@000000?ooo`3oool0
oooo0P00000P0?ooo`@000000P3oool00`000000oooo0?ooo`060?ooo`800000o`3ooolO0?ooo`00
?03oool200000080oooo0P00000P0?ooo`8000000`3oool4000000030?ooo`000000oooo0080oooo
0`00003o0?oooeT0oooo0P0000020?ooo`8000008@3oool3000000/0oooo0P00003o0?oooal0oooo
000l0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07`3oool300000080oooo0`00
00070?ooo`030000003oool0oooo0?l0ooooE`3oool00`000000oooo0?ooo`020?ooo`800000;P3o
ool200000?l0oooo7`3oool003`0oooo00<000000?ooo`3oool0903oool400000080oooo00<00000
0?ooo`3oool01@3oool300000?l0ooooF03oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02d0oooo0P00003o0?oooah0oooo000l0?ooo`030000003oool0oooo02D0oooo0`00000;0?oo
o`800000o`3ooomH0?ooo`030000003oool0oooo0080oooo0P00000=0?ooo`800000803oool20000
0?l0oooo7P3oool003`0oooo00<000000?ooo`3oool00P3oool2000002l0oooo0P00003o0?oooeP0
oooo00<000000?ooo`3oool00P3oool2000000`0oooo0`00000Q0?ooo`030000003oool0oooo0?l0
oooo703oool003`0oooo00<000000?ooo`3oool00P3oool2000002l0oooo0P0000200?ooo`800000
e@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo0P00003o0?oood00oooo
000l0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0;P3oool2000007l0oooo0P00
003E0?ooo`030000003oool0oooo0680oooo1000003/0?ooo`00?03oool2000000<0oooo0P00000a
0?ooo`030000003oool0oooo02/0oooo0P00001A0?ooo`800000e03oool200000140oooo0P00001?
0?ooo`P00000B`3oool2000009`0oooo000l0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0G03oool8000004X0oooo0P0000000`3oool000000?ooo`1A0?ooo`800000P03oool00`00
0000oooo0?ooo`070?ooo`800000103oool500000280oooo0P00000/0?ooo`80000000<0oooo0000
000000000`00001:0?ooo`800000D`3oool2000004L0oooo000l0?ooo`030000003oool0oooo00<0
oooo0P00001K0?ooo`80000000<0oooo0000000000001@0000000`3oool00000000000180?ooo`03
0000003oool0oooo04h0oooo0`0000020?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3o
ool00`3oool2000000<0oooo00<000000?ooo`3oool00`3oool400000280oooo1P00000R0?ooo`H0
0000103oool2000000030?ooo`000000000000800000A`3oool3000004h0oooo0P0000030?ooo`03
0000003oool0oooo04D0oooo000l0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2`3oool2000004T0oooo1@0000050?ooo`<0000000<0oooo000000000000V03oool4000008<0oooo
00<000000?ooo`3oool0103oool4000000@0oooo0P0000000`3oool000000000000T0?ooo`H00000
8P3oool5000000H0oooo1@0000180?ooo`800000CP3oool3000004X0oooo000l0?ooo`030000003o
ool0oooo0140oooo0`00000Q0?ooo`D000008`3oool6000000H0oooo1@0000160?ooo`800000D03o
ool3000008<0oooo00<000000?ooo`3oool0103oool6000000<0oooo00@000000?ooo`3oool00000
9`3oool3000001d0oooo0P0000001P3oool000000000003oool000000?ooo`<000001P3oool40000
09P0oooo0`00001:0?ooo`00?03oool00`000000oooo0?ooo`0B0?ooo`8000008@3oool5000002@0
oooo0P000000103oool000000000000000060?ooo`@00000A`3oool300000500oooo00<000000?oo
o`3oool0P@3oool00`000000oooo0?ooo`050?ooo`<0000000<0oooo0000003oool0;P3oool30000
01d0oooo100000040?ooo`8000002@3oool2000009P0oooo0P00001:0?ooo`00?03oool2000000T0
oooo0P0000070?ooo`8000008`3oool6000001d0oooo1@0000040?ooo`800000203oool3000004P0
oooo00<000000?ooo`3oool0B`3oool2000008D0oooo0P0000040?ooo`8000000`3oool200000080
oooo0P0000040?ooo`800000103oool4000001d0oooo0`00000L0?ooo`@00000403oool3000004@0
oooo0P00001?0?ooo`80000000<0oooo0000003oool0B@3oool003`0oooo00<000000?ooo`3oool0
203oool2000000<0oooo1P00000T0?ooo`030000003oool00000008000007P3oool4000000l0oooo
0`00002F0?ooo`<0000000<0oooo000000000000P03oool00`000000oooo0?ooo`040?ooo`040000
003oool0oooo0?ooo`<000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo1000000N0?ooo`<000006P3oool3000000030?ooo`000000oooo0100oooo0P0000150?ooo`<0
0000CP3oool010000000oooo0000000000190?ooo`00?03oool00`000000oooo0?ooo`030?ooo`80
00000P3oool3000000@0oooo1000000W0?ooo`<00000703oool500000140oooo0P0000130?ooo`<0
0000C`3oool2000000050?ooo`000000oooo0?ooo`000000P03oool00`000000oooo0?ooo`090?oo
o`@00000303oool010000000oooo00000000000N0?ooo`8000006@3oool4000001@0oooo0P000016
0?ooo`030000003oool0oooo04l0oooo0`0000170?ooo`00?03oool00`000000oooo0?ooo`040?oo
o`D000001P3oool3000002L0oooo0`00000K0?ooo`@0000000<0oooo0000003oool04@3oool00`00
0000oooo0?ooo`120?ooo`800000D03oool00`000000oooo0000000200000840oooo00<000000?oo
o`3oool02P3oool3000000D0oooo0P0000040?ooo`8000000P3oool00`000000oooo0?ooo`0L0?oo
o`8000006P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0440oooo0P00001?0?oo
o`8000000P3oool3000004L0oooo000l0?ooo`030000003oool0oooo00D0oooo1@0000030?ooo`80
000000<0oooo000000000000:03oool3000001/0oooo0P00000D0?ooo`800000TP3oool400000080
oooo0`0000210?ooo`030000003oool0oooo00/0oooo0P0000050?ooo`8000000`3oool300000240
oooo0`00000H0?ooo`8000005P3oool200000480oooo0`00001?0?ooo`80000000@0oooo00000000
00000000B03oool003`0oooo00<000000?ooo`3oool0103oool7000000<0oooo00@000000?ooo`3o
ool00000203oool200000200oooo0P00000H0?ooo`8000005`3oool200000440oooo0`00001=0?oo
o`@000000`3oool200000840oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?oo
o`8000000P3oool2000002<0oooo0`00000D0?ooo`D000005`3oool00`000000oooo0?ooo`110?oo
o`030000003oool0oooo04/0oooo1@0000020?ooo`800000B03oool003`0oooo0P0000050?ooo`80
000000D0oooo000000000000oooo0000000@0?ooo`030000003oool0oooo01h0oooo0`00000G0?oo
o`800000603oool00`000000oooo0?ooo`100?ooo`800000>`3oool4000000d0oooo1@0000260?oo
o`800000503oool2000000<0oooo00<000000?ooo`3oool08`3oool2000000T0oooo0P0000090?oo
o`<00000F`3oool2000004h0oooo0`00001=0?ooo`00?03oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo0?ooo`<0000000<0oooo0000000000000`3oool2000000D0oooo1000000P0?oo
o`800000503oool5000005X0oooo0P0000020?ooo`<00000>03oool4000000/0oooo0`0000290?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P00000V0?ooo`8000002@3oool20000
00X0oooo00<000000?ooo`3oool0F@3oool2000003/0oooo1000000<0?ooo`<0000000<0oooo0000
00000000C@3oool003`0oooo00<000000?ooo`3oool02P3oool3000000030?ooo`000000oooo00<0
oooo00<000000?ooo`3oool0103oool300000240oooo0P00000D0?ooo`@00000F`3oool010000000
oooo0?ooo`3oool2000003L0oooo1@00000<0?ooo`800000R@3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo02@0oooo0P00000:0?ooo`030000003oool0oooo00H0oooo0P00001K0?oo
o`<00000?03oool4000000`0oooo0P00001@0?ooo`00?03oool00`000000oooo0?ooo`0;0?ooo`<0
00002P3oool2000002@0oooo100000080?ooo`<00000203oool200000640oooo00<000000?ooo`3o
ool0=P3oool6000000T0oooo0P00002:0?ooo`030000003oool0oooo01<0oooo0P0000000`3oool0
00000000000X0?ooo`<000001P3oool4000000P0oooo00<000000?ooo`3oool05`3oool200000440
oooo00@000000?ooo`3oool0oooo0P00000g0?ooo`D00000303oool200000500oooo000T0?ooo`D0
00000`3oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000oooo0?ooo`0<0?ooo`80
00001@3oool2000000@0oooo00<000000?ooo`3oool08`3oool3000000T0oooo0P0000090?ooo`03
0000003oool0oooo05h0oooo0P0000060?ooo`<00000<`3oool2000000T0oooo0P00001b0?ooo`D0
00000`3oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000oooo0?ooo`0D0?ooo`@0
0000:03oool7000000<0oooo0`0000030?ooo`H000006@3oool2000004D0oooo0P00000h0?ooo`H0
00002`3oool00`000000oooo0?ooo`1>0?ooo`00903oool01@000000oooo0?ooo`3oool0000000P0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool00`3oool2000000<0oooo0P00000V0?ooo`<000001`3oool3000000@0
oooo1P00000I0?ooo`800000?`3oool3000000@0oooo00<000000?ooo`3oool00P0000030?ooo`80
0000;@3oool2000000030?ooo`000000000000d0oooo00<000000?ooo`3oool0L03oool01@000000
oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01@0oooo1000000Y0?ooo`T0000000<0oooo0000000000000P3oool30000
00040?ooo`0000000000000001X0oooo0P0000150?ooo`8000001P3oool2000002h0oooo0P000000
0`3oool0000000000002000000T0oooo0P00001A0?ooo`009@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool2000000@0oooo00<000000?oo
o`3oool09@3oool3000000D0oooo1@0000020?ooo`<0000000@0oooo00000000000000006P3oool0
0`000000oooo0?ooo`0n0?ooo`800000103oool3000000040?ooo`000000oooo0?ooo`<00000;P3o
ool010000000oooo0?ooo`0000090?ooo`800000MP3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0503oool4000002X0oooo1P0000001@3oool00000
0?ooo`3oool0000000<0oooo1000000L0?ooo`800000?P3oool3000000D0oooo00@000000?ooo`00
000000000`3oool2000002l0oooo00@000000?ooo`3oool00000303oool00`000000oooo0?ooo`1?
0?ooo`009P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo0`00000D0?oo
o`80000000<0oooo000000000000:03oool8000000030?ooo`000000oooo008000000P3oool50000
01/0oooo0`00000Y0?ooo`800000103oool2000000d0oooo0P0000050?ooo`<00000103oool20000
02d0oooo0P0000050?ooo`D00000103oool3000007D0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`030?ooo`<000005@3oool2000002d0oooo00<000000?ooo`3oool00`0000020?oo
o`P00000703oool5000002H0oooo0`0000030?ooo`8000003P3oool2000000@0oooo0P0000000`3o
ool00000000000020?ooo`<00000=03oool2000000H0oooo1000001A0?ooo`009`3oool00`000000
oooo0?ooo`080?ooo`@000001P3oool00`000000oooo0?ooo`0E0?ooo`040000003oool0oooo0000
02T0oooo2@0000020?ooo`P00000703oool4000002L0oooo0`0000040?ooo`030000003oool0oooo
00X0oooo0`0000060?ooo`P00000:@3oool7000000D0oooo1P0000040?ooo`030000003oool0oooo
07@0oooo00<000000?ooo`3oool0203oool4000000H0oooo00<000000?ooo`3oool0B03oool20000
0080oooo1@0000000`3oool000000?ooo`0M0?ooo`@000009`3oool2000000<0oooo0P00000>0?oo
o`800000103oool3000000040?ooo`000000oooo0?ooo`800000;@3oool3000000D0oooo10000000
0`3oool00000000000020?ooo`030000003oool000000540oooo000T0?ooo`050000003oool0oooo
0?ooo`0000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo0P00000^
0?ooo`8000000P3oool300000080oooo1`00000N0?ooo`<00000:03oool300000080oooo0P00000=
0?ooo`800000203oool01@000000oooo0000003oool0000002T0oooo10000000103oool000000000
000000060?ooo`<0000000@0oooo0000003oool0oooo0P00001d0?ooo`050000003oool0oooo0?oo
o`0000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04d0oooo00<000000?oo
o`3oool08P3oool2000002T0oooo0`0000020?ooo`030000003oool0oooo00/0oooo0`0000050?oo
o`800000103oool2000002T0oooo0`000000103oool000000000000000060?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool0E03oool002@0oooo00D000000?ooo`3oool0oooo00000009
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05@3oool010000000oooo00000000
000`0?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000003oool07`3oool4000002T0oooo
1P000000103oool000000000003oool2000001@0oooo0P00000Z0?ooo`L000001P3oool300000003
0?ooo`00000000000080oooo0P00001c0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo07D0oooo0P00000W0?ooo`D0000000<0oooo0000
000000002@3oool3000000P0oooo1P00000X0?ooo`P000001P3oool3000000040?ooo`0000000000
0?ooo`<00000DP3oool002@0oooo00D000000?ooo`3oool0oooo000000090?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool05@3oool2000000030?ooo`000000oooo03@0oooo00<00000
0?ooo`3oool08@3oool3000000030?ooo`000000000002L0oooo10000000103oool0000000000000
00020?ooo`030000003oool0oooo00h0oooo0P0000030?ooo`030000003oool0oooo00L0oooo0P00
000N0?ooo`<0000000<0oooo0000000000002@3oool9000007<0oooo00D000000?ooo`3oool0oooo
000000090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0L`3oool5000002@0oooo
0P0000000`3oool000000000000200000080oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`080?ooo`80000000<0oooo0000003oool0203oool2000001l0oooo0P0000000`3oool00000
00000002000000L0oooo0P0000000`3oool00000000000020?ooo`800000DP3oool002D0oooo0`00
000:0?ooo`D000001@3oool00`000000oooo0?ooo`0E0?ooo`<00000G03oool4000002<0oooo2`00
000D0?ooo`800000303oool3000001l0oooo00<000000?ooo`3oool0303oool00`000000oooo0000
00020?ooo`030000003oool0000007@0oooo0`00000:0?ooo`D000001@3oool00`000000oooo0?oo
o`1d0?ooo`@000008P3oool5000000030?ooo`000000000000<000000P3oool200000100oooo0P00
00020?ooo`800000203oool300000200oooo00<000000?ooo`3oool02`3oool800000580oooo000l
0?ooo`8000005P3oool3000005d0oooo00@000000?ooo`00000000008P3oool2000000050?ooo`00
000000000?ooo`0000000P3oool2000001D0oooo00<000000?ooo`3oool02@3oool400000<40oooo
0P00001e0?ooo`80000000<0oooo0000003oool0803oool4000000030?ooo`000000oooo00<0oooo
0P0000030?ooo`030000003oool0oooo00h0oooo0P0000030?ooo`030000003oool0oooo00L0oooo
0P00000_0?ooo`8000000P3oool00`000000oooo0000001B0?ooo`00?03oool00`000000oooo0?oo
o`0F0?ooo`800000G03oool3000000030?ooo`000000oooo0200oooo0`0000060?ooo`800000103o
ool2000000<0oooo0P0000090?ooo`80000000@0oooo00000000000000002@3oool3000001<0oooo
1@0000050?ooo`<00000303oool2000000<0oooo0P00002>0?ooo`030000003oool0oooo07<0oooo
0`00000T0?ooo`8000001`3oool2000001D0oooo00<000000?ooo`3oool02P3oool3000001<0oooo
1@0000050?ooo`<00000J03oool003`0oooo00<000000?ooo`3oool0M03oool3000002@0oooo00<0
00000?ooo`3oool01P3oool5000000030?ooo`000000oooo00<0oooo0P0000090?ooo`030000003o
ool0oooo00800000203oool3000000<0oooo0P00000@0?ooo`@000000P3oool200000080oooo0P00
000=0?ooo`@0000000<0oooo0000003oool0S@3oool00`000000oooo0?ooo`1d0?ooo`800000;P3o
ool200000080oooo0P0000040?ooo`8000002`3oool3000000P0oooo0`0000030?ooo`800000403o
ool4000000H0oooo0P00000<0?ooo`800000FP3oool003`0oooo00<000000?ooo`3oool0M@3oool2
000002`0oooo0P000000103oool000000?ooo`0000050?ooo`@000002P3oool3000000T0oooo00@0
00000?ooo`3oool0oooo0`0000040?ooo`8000001`3oool7000000<0oooo1000000@0?ooo`800000
T03oool00`000000oooo0?ooo`2R0?ooo`80000000<0oooo0000003oool00`0000040?ooo`800000
2@3oool2000000030?ooo`000000000000T0oooo00<000000?ooo`3oool00P3oool2000000@0oooo
0P0000080?ooo`80000000<0oooo000000000000103oool4000000h0oooo100000000`3oool00000
0000001D0?ooo`00?03oool00`000000oooo0?ooo`2T0?ooo`040000003oool00000000000H0oooo
1000000;0?ooo`030000003oool0oooo00L0oooo100000000`3oool0000000000005000000030?oo
o`000000oooo00H0oooo10000000103oool000000000003oool600000180oooo0P00002>0?ooo`03
0000003oool0oooo0:<0oooo00H000000?ooo`00000000000?ooo`0000040?ooo`@000002@3oool0
10000000oooo0000000000080?ooo`80000000<0oooo000000000000100000040?ooo`030000003o
ool0oooo00H0oooo0`0000001@3oool00000000000000000oooo00D00000403oool5000005@0oooo
000l0?ooo`030000003oool0oooo0:L0oooo00@000000?ooo`0000000000103oool00`000000oooo
0?ooo`0F0?ooo`030000003oool000000080oooo0`0000000`3oool0000000000003000000L0oooo
0P0000030?ooo`D0000000<0oooo0000003oool04`3oool00`000000oooo0?ooo`2<0?ooo`030000
003oool0oooo0:D0oooo0P0000070?ooo`<00000303oool00`000000oooo0?ooo`070?ooo`050000
003oool0oooo0000003oool01`0000080?ooo`@000000`3oool00`000000oooo00000004000001<0
oooo00<000000?ooo`3oool0D`3oool003`0oooo00<000000?ooo`3oool0M`3oool200000240oooo
0P00000;0?ooo`P00000703oool2000000<0oooo1P00000<0?ooo`@00000YP3oool00`000000oooo
0?ooo`1f0?ooo`8000008@3oool2000000/0oooo100000000`3oool0000000000002000001l0oooo
00<000000?ooo`000000100000070?ooo`8000000`3oool5000001D0oooo0P00001E0?ooo`00?03o
ool2000007T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`080?ooo`<0000000<0
oooo0000000000000`00000K0?ooo`d000001@3oool2000000D0oooo00<000000?ooo`3oool0YP3o
ool2000007P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0000000D000006P3oool400000080oooo1P00000<0?ooo`@000005`3oool00`000000oooo0?oo
o`1C0?ooo`00?03oool00`000000oooo0?ooo`2W0?ooo`8000000P3oool400000180oooo0P000003
0?ooo`8000000P3oool4000000030?ooo`000000000000@0oooo100000040?ooo`030000003oool0
oooo0:`0oooo00<000000?ooo`3oool0YP3oool2000000030?ooo`000000000000<000004P3oool2
000000@0oooo0P0000020?ooo`<0000000<0oooo0000000000000P0000020?ooo`8000001@3oool2
000000D0oooo00<000000?ooo`3oool0K@3oool003`0oooo00<000000?ooo`3oool0[@3oool20000
01<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool2000000<0oooo00<00000
0?ooo`3oool00P3oool400000;<0oooo00<000000?ooo`3oool0U@3oool200000100oooo00<00000
0?ooo`3oool00P00000E0?ooo`040000003oool0000000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`<00000103oool3000000@0oooo00<000000?ooo`3oool0L`3oool003`0oooo00<0
00000?ooo`3oool0UP3oool2000000030?ooo`000000000000l0oooo0P00000G0?ooo`D000003@3o
ool4000000030?ooo`00000000000;00oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?oo
o`0200000100oooo0`00000D0?ooo`D00000203oool00`000000oooo0?ooo`020?ooo`D0000000<0
oooo000000000000MP3oool003`0oooo00<000000?ooo`3oool0U`3oool010000000oooo0?ooo`00
000@0?ooo`030000003oool0oooo01@0oooo1P00000>0?ooo`040000003oool000000?ooo`800000
/03oool00`000000oooo0?ooo`230?ooo`8000004`3oool3000000h0oooo0P0000000`3oool00000
0000000C0?ooo`H000003P3oool400000080oooo00<000000?ooo`3oool0M03oool003`0oooo00<0
00000?ooo`3oool0NP3oool2000000L0oooo0`00000C0?ooo`8000009`3oool2000000030?ooo`00
000000000140oooo0P0000000`3oool000000?ooo`2_0?ooo`030000003oool0oooo07L0oooo1000
00070?ooo`@000002@3oool2000000@0oooo0`0000000`3oool000000?ooo`0?0?ooo`030000003o
ool0oooo01@0oooo1@00000A0?ooo`@00000M`3oool003`0oooo0P00001i0?ooo`80000000<0oooo
0000003oool01P3oool4000000P0oooo0`0000020?ooo`D0000000<0oooo0000003oool09`3oool0
10000000oooo0?ooo`00000B0?ooo`<00000/03oool2000007T0oooo00@000000?ooo`0000000000
1@3oool5000000@0oooo0P0000020?ooo`<000000P3oool2000000030?ooo`000000000002X0oooo
00@000000?ooo`3oool000004P3oool3000007L0oooo000l0?ooo`030000003oool0oooo07T0oooo
00@000000?ooo`0000000000103oool7000000<0oooo0P0000020?ooo`<0000000D0oooo00000000
000000000?ooo`0200000400oooo0`00002`0?ooo`030000003oool0oooo07T0oooo0`0000060?oo
o`030000003oool0000000<000000P3oool7000000050?ooo`00000000000000003oool00P000011
0?ooo`800000M`3oool003`0oooo00<000000?ooo`3oool0N03oool3000000030?ooo`000000oooo
00@0oooo0P0000000`3oool000000000000200000080oooo0P000000103oool00000000000000002
0?ooo`P00000?P3oool200000;40oooo00<000000?ooo`3oool0M`3oool400000080oooo0`000005
0?ooo`<0000000<0oooo0000000000000P000000103oool000000000003oool5000000040?ooo`00
00000000000003h0oooo0`00001g0?ooo`00?03oool00`000000oooo0?ooo`1h0?ooo`<000000`3o
ool2000000H0oooo0`000000103oool000000000000000020?ooo`80000000<0oooo000000000000
0`000000103oool000000?ooo`00000o0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3o
ool0N03oool2000000@0oooo0P0000060?ooo`8000000P3oool00`000000oooo0000000300000080
oooo00@000000?ooo`00000000000`3oool00`000000oooo0?ooo`0m0?ooo`800000M`3oool003`0
oooo00<000000?ooo`3oool0N@3oool2000000@0oooo100000080?ooo`030000003oool000000080
00000`3oool01@000000oooo000000000000oooo00800000lP3oool00`000000oooo0?ooo`1h0?oo
o`@0000000<0oooo0000000000000`0000090?ooo`P00000103oool200000;T0oooo000l0?ooo`03
0000003oool0oooo07T0oooo100000001P3oool00000000000000000oooo000000T0oooo20000003
0?ooo`<00000lP3oool00`000000oooo0?ooo`1i0?ooo`050000003oool000000000003oool01000
00070?ooo`80000000<0oooo0000000000000P3oool3000000D0oooo00<000000?ooo`3oool0]`3o
ool003`0oooo00<000000?ooo`3oool0NP3oool6000000030?ooo`000000000000@0oooo20000002
0?ooo`<00000103oool200000?80oooo00<000000?ooo`3oool0O03oool200000080oooo0P000004
0?ooo`D000001@3oool300000;l0oooo000l0?ooo`800000O@3oool3000000040?ooo`0000000000
000000D0oooo100000000`3oool00000000000030?ooo`030000003oool0oooo0?L0oooo0P00001n
0?ooo`D000001@3oool00`000000oooo000000070?ooo`030000003oool0oooo0;h0oooo000l0?oo
o`030000003oool0oooo07d0oooo1@0000060?ooo`<00000o`3oool20?ooo`030000003oool0oooo
07`0oooo0P0000000`3oool00000000000060?ooo`800000b@3oool003`0oooo00<000000?ooo`3o
ool0OP3oool010000000oooo0000000000060?ooo`<00000o`3oool20?ooo`030000003oool0oooo
07d0oooo00@000000?ooo`00000000001`3oool200000<P0oooo000c0?ooo`<000001P3oool00`00
0000oooo0?ooo`200?ooo`8000001`3oool200000?P0oooo0`0000060?ooo`030000003oool0oooo
0800oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`360?ooo`00<P3oool01@000000
oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`3n0?oo
o`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000f0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooon70?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00=P3oool00`000000oooo0?ooo`030?ooo`<0
0000o`3ooon70?ooo`030000003oool0oooo00<0oooo0`00003o0?oooe<0oooo000d0?ooo`800000
o`3ooon>0?ooo`800000o`3ooomL0?ooo`00=P3oool00`000000oooo0?ooo`3o0?ooohd0oooo00<0
00000?ooo`3oool0o`3ooomI0?ooo`00=P3oool00`000000oooo0?ooo`3o0?ooohd0oooo00<00000
0?ooo`3oool0o`3ooomI0?ooo`00<P3oool01@000000oooo0?ooo`3oool000000?l0ooooR`3oool0
1@000000oooo0?ooo`3oool000000?l0ooooF`3oool003<0oooo0`00002@0?ooo`800000nP3oool3
000008l0oooo0P00003:0?ooo`00b03oool00`000000oooo0?ooo`3o0?oooh`0oooo00<000000?oo
o`3oool0a`3oool00<P0oooo00<000000?ooo`3oool0o`3ooon<0?ooo`030000003oool0oooo0<L0
oooo002D0?ooo`80000000<0oooo0000003oool00P0000020?ooo`<0000000<0oooo0000003oool0
0P3oool3000000<0oooo0`0000000`3oool000000?ooo`04000000<0oooo1@0000040?ooo`<00000
103oool00`000000oooo0?ooo`090?ooo`80000000<0oooo0000003oool00P0000020?ooo`<00000
0P3oool300000080oooo0P0000030?ooo`<0000000D0oooo00000000000000000?ooo`03000000X0
oooo1@0000030?ooo`<00000o`3ooolG0?ooo`80000000<0oooo0000003oool00P0000020?ooo`<0
000000<0oooo0000003oool00P3oool3000000<0oooo0`0000000`3oool000000?ooo`04000000<0
oooo1@0000040?ooo`<00000103oool00`000000oooo0?ooo`0:0?ooo`80000000<0oooo0000003o
ool00P0000020?ooo`<000000P3oool300000080oooo0P0000030?ooo`<0000000D0oooo00000000
000000000?ooo`03000000T0oooo1@0000020?ooo`<00000Q`3oool009D0oooo00D000000?ooo`00
0000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo0`00000;0?ooo`050000003oool00000
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo
00T0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000o`3o
oolG0?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00070?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`<00000
303oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
0`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000
oooo0?ooo`240?ooo`00U@3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000/0oooo00D000000?ooo`000000oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000?l0oooo5`3oool01@000000oooo0000003oool000000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0000000`0oooo00D000000?ooo`000000oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`230?ooo`00U@3oool01@000000oooo0000003oool0000000<0oooo
100000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000002P3oool01@000000oooo0000003oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000o`3ooolG0?ooo`050000003oool000000?ooo`0000000`3oool4
000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo0000000;0?ooo`050000003oool000000?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00<0oooo1000
00250?ooo`00U@3oool01@000000oooo0000003oool0000000H0oooo00D000000?ooo`3oool0oooo
000000050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool00000
00X0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool200000080oooo00D000000?ooo`3oool0oooo000000050?ooo`8000000P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0080oooo0`00003o0?oooaP0oooo00D000000?ooo`000000
oooo000000060?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`050000003oool000000?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000003oool0oooo0?oo
o`0000001@3oool200000080oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool0P`3oool009@0oooo0`0000000`3oool000000?ooo`020?oo
o`@000000`3oool5000000030?ooo`00000000000080oooo0P0000020?ooo`030000003oool00000
008000000P3oool3000000@0oooo1@0000001@3oool00000000000000000oooo00<00000203oool3
000000030?ooo`000000oooo00<0oooo0`0000020?ooo`030000003oool00000008000000`3oool5
00000080oooo00@000000?ooo`0000000000303oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo0000003o0?oooaH0oooo0`0000000`3oool000000?ooo`020?ooo`@0
00000`3oool5000000030?ooo`00000000000080oooo0P0000020?ooo`030000003oool000000080
00000P3oool3000000@0oooo1@0000001@3oool00000000000000000oooo00<000002@3oool30000
00030?ooo`000000oooo00<0oooo0`0000020?ooo`030000003oool00000008000000`3oool50000
0080oooo00@000000?ooo`00000000002`3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000250?ooo`00Y03oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0oooo9P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0<0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000008D0oooo002T0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000o`3ooolV0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000Q@3oool00;X0oooo
00<000000?ooo`3oool0<`3oool200000100oooo0`0000040?ooo`<00000o`3ooolm0?ooo`030000
003oool0oooo03@0oooo0P00000?0?ooo`<00000103oool3000008H0oooo003o0?ooool0ooooo`3o
oolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0
ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o
0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo0?ooob<0
oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3ooooo
0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0oooo
o`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool0
0?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo
8`3oool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooom<0?oo
o`<00000o`3ooon<0?ooo`<00000A03oool00?l0ooooC@3oool00`000000oooo0?ooo`3o0?oooh`0
oooo00<000000?ooo`3oool0@`3oool00?l0ooooC@3oool00`000000oooo0?ooo`3o0?oooh`0oooo
00<000000?ooo`3oool0@`3oool004T0oooo1@0000040?ooo`<000002`3oool2000000D0oooo0`00
00000`3oool000000000000200000080oooo0P00000:0?ooo`<00000103oool3000000d0oooo1@00
00040?ooo`<00000203oool3000000040?ooo`000000000000000080oooo0`0000000`3oool00000
0?ooo`04000000`0oooo0`0000030?ooo`D00000303oool500000080oooo1@0000080?ooo`D00000
103oool3000000@0oooo0`00000<0?ooo`<000000`3oool5000000`0oooo1@0000020?ooo`D00000
2P3oool4000000@0oooo0`0000030?ooo`@000002`3oool3000000<0oooo1@00001b0?ooo`D00000
103oool3000000X0oooo0P0000050?ooo`<0000000<0oooo0000000000000P0000020?ooo`800000
2P3oool3000000@0oooo0`00000=0?ooo`D00000103oool3000000P0oooo0`000000103oool00000
0000000000020?ooo`<0000000<0oooo0000003oool01000000<0?ooo`<000000`3oool5000000`0
oooo1@0000020?ooo`D000002@3oool5000000@0oooo0`0000040?ooo`<000002`3oool3000000<0
oooo1@00000<0?ooo`D000000P3oool5000000X0oooo100000040?ooo`<000000`3oool4000000`0
oooo0`0000030?ooo`D00000:`3oool004/0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000002P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000T0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000X0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000007@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`040000003oool0
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00002P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000>
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00/0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000T0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000002/0oooo001;0?ooo`040000
003oool0oooo0?ooo`H000000`3oool500000080oooo00@000000?ooo`3oool000000`3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`D000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000>0?ooo`04
0000003oool0oooo0?ooo`H000000P3oool500000080oooo00D000000?ooo`000000oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`D000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo1@0000020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P3oool5000000L0oooo00@000000?ooo`3oool000001P3oool0
1@000000oooo0?ooo`3oool000000080oooo1@0000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`1e0?ooo`040000003oool0oooo0?ooo`H000000P3oool500000080
oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`D000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo0000000>0?ooo`040000003oool0oooo0?ooo`H000000P3oool50000
0080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`040?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo
1@0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo1@0000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool50000
00H0oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?ooo`3oool000000080oooo1@00
00030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0/0?ooo`00B`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0303oool01@000000oooo
0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`080?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000
oooo000000030?ooo`@000000`3oool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool000000080oooo1@0000020?ooo`030000003oool0
oooo00`0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`<000000P3oool500000080oooo00D0
00000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`1d0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0;0?oo
o`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00003P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0203oool01@00
0000oooo0000003oool0000000<0oooo100000030?ooo`030000003oool0oooo00/0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000000P3oool500000080oooo
00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo0`0000020?ooo`D0
00000P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo02/0oooo001;0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000003P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
00X0oooo00D000000?ooo`000000oooo000000060?ooo`050000003oool0oooo0?ooo`0000003@3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000X0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0:0?ooo`<00000103oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`1c0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000003@3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P0000020?ooo`030000003o
ool0oooo00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00003P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000X0oooo00D000000?oo
o`000000oooo000000060?ooo`050000003oool0oooo0?ooo`0000003@3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000T0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0:0?ooo`<00000103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0Z0?oo
o`00B`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000h0oooo00<000000?ooo`3o
ool00P0000020?ooo`80000000<0oooo0000003oool00`00000;0?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0000000:0?ooo`80000000<0oooo0000000000000P3oool4000000<0oooo00<00000
0?ooo`0000000P00000:0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000090?ooo`050000
003oool0oooo0?ooo`0000000`3oool3000000@0oooo0`00000;0?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`050?ooo`<000000P3oool00`000000oooo000000020000
00X0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000M03o
ool00`000000oooo0?ooo`030?ooo`030000003oool0000000d0oooo00<000000?ooo`3oool00P00
00020?ooo`80000000<0oooo0000003oool00`00000;0?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0000000:0?ooo`80000000<0oooo0000000000000P3oool4000000<0oooo00<000000?ooo`00
00000P00000:0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0
oooo0?ooo`0000000`3oool3000000@0oooo0`00000:0?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`050?ooo`<000000P3oool00`000000oooo00000002000000/0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000:`3oool004/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000>0?ooo`030000003oool0oooo01L0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000003P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0000000X0oooo0P0000000`3oool000000000000H
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`00
0000603oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo0000000G
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000007@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0000000=0?ooo`030000003oool0oooo01L0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000003P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000X0oooo0P0000000`3oool000000000000H0?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`000000
5`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo0000000H0?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000002/0oooo0019
0?ooo`<000001P3oool2000000`0oooo1000000H0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000`0oooo0`0000060?ooo`8000002@3oool2000000<0oooo
0P00000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000h0oooo0`0000040?ooo`05
0000003oool0oooo0?ooo`000000203oool5000001T0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`<000003P3oool3000000@0oooo0`00000=0?ooo`@000005`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000001b0?ooo`<000001P3oool2000000/0oooo
1000000H0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00`0oooo0`0000060?ooo`8000002@3oool2000000<0oooo0P00000G0?ooo`050000003oool0oooo
0?ooo`0000000P3oool3000000h0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000002@3o
ool5000001P0oooo00D000000?ooo`3oool0oooo000000020?ooo`<000003P3oool3000000@0oooo
0`00000=0?ooo`@00000603oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo0000000[0?ooo`00B`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02L0
oooo0`0000040?ooo`<000003`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02H0
oooo0`0000050?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool3000002P0
oooo0`0000050?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0W0?ooo`<00000103oool3000007D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0V0?ooo`<00000103oool3000000l0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0V0?ooo`<000001@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0
oooo0`00000X0?ooo`<000001@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0:03oool3000000@0oooo0`00000/0?ooo`00o`3ooooo0?ooool0oooo
8`3oool00?l0ooooo`3ooooo0?ooob<0oooo000e0?ooool00000>P00001E0?ooool00000>P00000T
0?ooo`00?03oool00`000000oooo0?ooo`0L0?oooaT000002@3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool000000180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0J0?oo
o`040000003oool0oooo0?ooo`<000005`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00@0oooo0P00000E0?ooo`050000003oool0oooo0?ooo`0000000P3ooolM000006@0oooo00<0
00000?ooo`3oool06`3ooolB00000140oooo00<000000?ooo`3oool07@3oool00`000000oooo0000
000B0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool06P3oool010000000oooo0?oo
o`3oool3000001L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0L000002/0oooo
000l0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`170?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04L0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool0
0`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000
oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?oo
o`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool2
00000?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo
0?l0ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0
ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0
oooo0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0oooo
S@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03o
ool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool0
0`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009@3oool3000000@0
oooo00<000000?ooo`3oool00`3oool4000000H0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`<0
0000103oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000oooo0?ooo`3o0?oooe<0
oooo000T0?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooome0?ooo`050000003oool0oooo0?oo
o`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooomC0?ooo`00903oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?oo
o`3oool00`3oool300000?l0ooooM@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<00000
0?ooo`3oool00`3oool200000?l0ooooE03oool002@0oooo00D000000?ooo`3oool0oooo0000000=
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooome0?ooo`050000003oool0
oooo0?ooo`0000003@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0ooooD`3o
ool002@0oooo00D000000?ooo`3oool0oooo000000090?ooo`@000001P3oool00`000000oooo0?oo
o`3o0?ooogD0oooo00D000000?ooo`3oool0oooo000000090?ooo`@000001P3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000T0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0?l0ooooM@3oool01@000000oooo0?ooo`3oool0000000T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000T0?ooo`050000
003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0
ooooM@3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000T0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooM@3oool01@000000oooo0?ooo`3oool0
000000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000U0?oo
o`<000002P3oool5000000D0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`<000002P3oool50000
00D0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool200000?l0
ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0
oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo
0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?oo
o`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000
oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?oo
o`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o
0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool20000
0?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0
ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3o
ool00380oooo1@0000050?ooo`030000003oool0oooo0?l0ooooP`3oool5000000D0oooo00<00000
0?ooo`3oool0o`3ooomC0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0?l0ooooQ@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool003@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooohD0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000d0?ooo`030000003oool0oooo00D0oooo
0`00003o0?ooohD0oooo00<000000?ooo`3oool01@3oool200000?l0ooooE03oool003@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooohD0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000d0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0o`3ooon50?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooomC
0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooQ@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool00380oooo0`0000070?ooo`03
0000003oool0oooo0?l0ooooP`3oool3000000L0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00
=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooQ@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo0P00003o0?ooohh0oooo0P00
003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o
0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0
oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo
000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l
0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03oool00`000000oooo0?ooo`3o0?oo
ohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0
oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo
00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<0
00000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<00000
0?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?oo
o`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3oool200000?l0ooooE03oool003`0oooo
00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<0
00000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<00000
0?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<000000?oo
o`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo00<000000?ooo`3o
ool0o`3ooon=0?ooo`030000003oool0oooo0?l0ooooD`3oool003`0oooo0P00003o0?ooohh0oooo
0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?oo
o`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o
0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo000T0?ooo`D000000`3oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000
oooo0?ooo`3o0?ooogD0oooo1@0000030?ooo`030000003oool0oooo00<0oooo100000060?ooo`03
0000003oool0oooo0?l0ooooD`3oool002H0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0?l0ooooD`3oool002H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0?l0ooooM`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00<0oooo0`00003o0?ooogL0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`030?ooo`800000o`3ooomD0?ooo`009P3oool00`000000oooo0?ooo`090?oo
o`@000001P3oool00`000000oooo0?ooo`3o0?ooogL0oooo00<000000?ooo`3oool02@3oool40000
00H0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`009P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000V0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooogL0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0oooo
D`3oool002@0oooo0`00000;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3o
oome0?ooo`<000002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooD`3o
ool002H0oooo00<000000?ooo`3oool02@3oool5000000D0oooo00<000000?ooo`3oool0o`3ooomg
0?ooo`030000003oool0oooo00T0oooo1@0000050?ooo`030000003oool0oooo0?l0ooooD`3oool0
03`0oooo0P00003o0?ooohh0oooo0P00003o0?oooe@0oooo000l0?ooo`030000003oool0oooo0?l0
ooooS@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0oooo
S@3oool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool0
0`000000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000l0?ooo`030000003oool0oooo0?l0ooooS@3oool00`000000
oooo0?ooo`3o0?oooe<0oooo000l0?ooo`800000o`3ooon>0?ooo`800000o`3ooomD0?ooo`00?03o
ool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool0
0`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000
oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00?03oool200000?l0ooooSP3o
ool200000?l0ooooE03oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0
oooo0?l0ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo
0?l0ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0
ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo0?l0oooo
D`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?ooo`<00000o`3ooomC0?ooo`00?03oool2
00000?l0ooooSP3oool300000?l0ooooD`3oool003`0oooo00<000000?ooo`3oool0o`3ooon=0?oo
o`<00000o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`00
0000o`3ooomC0?ooo`00?03oool00`000000oooo0?ooo`3o0?ooohd0oooo1000003o0?oooe80oooo
000b0?ooo`D000001@3oool00`000000oooo0?ooo`3o0?oooh<0oooo1@0000050?ooo`80000000<0
oooo0000003oool0o`3ooomA0?ooo`00<P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0o`3ooon30?ooo`050000003oool0oooo0?ooo`0000001@3oool400000?l0oooo
DP3oool003<0oooo00<000000?ooo`3oool01P3oool010000000oooo00000000003o0?oooh<0oooo
00<000000?ooo`3oool01P3oool2000000030?ooo`00000000000?l0ooooD@3oool003@0oooo00<0
00000?ooo`3oool01@3oool400000?l0ooooQ03oool00`000000oooo0?ooo`040?ooo`<000000P3o
ool00`000000oooo0?ooo`3o0?ooodl0oooo000e0?ooo`030000003oool0oooo00@0oooo1000003o
0?ooohD0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooe<0oooo000b0?oo
o`050000003oool0oooo0?ooo`0000001@3oool300000?l0ooooP`3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`3oool0;@3oool200000?l0oooo903oool00380oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0000000800000o`3ooon10?ooo`050000003o
ool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0]0?ooo`<00000o`3ooolS0?ooo`00<P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P00003o0?oooh40oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo02h0oooo0P00003o0?ooob<0
oooo000c0?ooo`<000001P3oool500000?l0ooooPP3oool3000000H0oooo00<000000?ooo`3oool0
0P00000Z0?ooo`D00000o`3ooolR0?ooo`00?03oool3000000030?ooo`000000oooo0?l0ooooRP3o
ool200000080oooo00<000000?ooo`3oool0:@3oool010000000oooo00000000003o0?ooob80oooo
000l0?ooo`800000]P3oool200000=D0oooo00<000000?ooo`3oool0;03oool200000080oooo0P00
003o0?ooob40oooo000l0?ooo`800000]P3oool200000=D0oooo00<000000?ooo`3oool0:`3oool3
000000030?ooo`000000000000800000o`3ooolP0?ooo`00?03oool00`000000oooo0?ooo`2f0?oo
o`800000e03oool00`000000oooo0?ooo`0[0?ooo`8000000`3oool300000840oooo0P00002L0?oo
o`00?03oool00`000000oooo0?ooo`2d0?ooo`80000000<0oooo0000003oool0d`3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo0080oooo0P0000210?ooo`<00000V`3oool003`0oooo
00@000000?ooo`3oool0oooo0P00002b0?ooo`030000003oool0oooo0=@0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`200?ooo`800000V`3oool003`0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`3o0?ooohP0oooo00<000000?ooo`3oool00P00000`0?ooo`800000
P03oool2000009`0oooo000l0?ooo`800000o`3oool<0?ooo`800000P03oool200000080oooo00<0
00000?ooo`3oool0;P3oool200000840oooo00<000000?ooo`3oool0VP3oool003`0oooo00<00000
0?ooo`3oool0]03oool4000004h0oooo0`0000020?ooo`030000003oool0oooo07h0oooo00<00000
0?ooo`3oool0<`3oool2000002d0oooo1000002S0?ooo`800000A`3oool003`0oooo00<000000?oo
o`3oool0]@3oool00`000000oooo0000001=0?ooo`@00000P`3oool00`000000oooo0?ooo`0c0?oo
o`800000;03oool8000009`0oooo0`0000020?ooo`030000003oool0oooo04D0oooo000l0?ooo`03
0000003oool0oooo0680oooo2000002L0?ooo`<00000P`3oool010000000oooo0?ooo`3oool20000
0340oooo00<000000?ooo`3oool0:`3oool8000004T0oooo1000001>0?ooo`<00000BP3oool003`0
oooo00<000000?ooo`3oool0H`3oool7000004X0oooo0P00001B0?ooo`030000003oool0oooo0840
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1J0?ooo`8000001@3oool200000003
0?ooo`000000oooo00800000A`3oool00`000000oooo0000001?0?ooo`800000BP3oool003`0oooo
00@000000?ooo`3oool0oooo0P00000a0?ooo`800000<03oool4000000030?ooo`000000000004H0
oooo0`00001?0?ooo`800000Q@3oool010000000oooo0?ooo`3oool2000005T0oooo1P0000060?oo
o`D00000U`3oool2000000030?ooo`000000oooo04T0oooo000l0?ooo`8000000`3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo02@0oooo1`0000040?ooo`030000003oool0000000@0
0000AP3oool00`000000oooo0?ooo`1?0?ooo`<0000000<0oooo000000000000P03oool2000000<0
oooo0P00001I0?ooo`030000003oool0000000<000001P3oool4000004H0oooo0P00001@0?ooo`04
0000003oool00000000004T0oooo000l0?ooo`030000003oool0oooo05d0oooo1P0000070?ooo`@0
0000U`3oool2000000050?ooo`000000oooo0?ooo`000000P03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo0P00000U0?ooo`800000103oool2000000T0oooo0P0000150?oo
o`800000D`3oool3000004L0oooo000l0?ooo`030000003oool0oooo05/0oooo100000020?ooo`<0
0000203oool2000004@0oooo0`00001=0?ooo`D0000000@0oooo0000000000000000P@3oool00`00
0000oooo0?ooo`020?ooo`800000<03oool7000001d0oooo1@00000?0?ooo`800000AP3oool00`00
0000oooo0?ooo`1=0?ooo`80000000<0oooo0000000000000P0000170?ooo`00?03oool00`000000
oooo0?ooo`020?ooo`800000F03oool2000000@0oooo0P0000090?ooo`800000A03oool2000004d0
oooo100000030?ooo`800000P@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02l0
oooo1P00000M0?ooo`@000004@3oool2000004<0oooo0P00001@0?ooo`80000000<0oooo00000000
00000P0000170?ooo`00?03oool00`000000oooo0?ooo`020?ooo`800000<@3oool200000280oooo
1000000@0?ooo`<00000@P3oool200000080oooo0`00001:0?ooo`<00000QP3oool00`000000oooo
0?ooo`0A0?ooo`8000008`3oool00`000000oooo00000002000001/0oooo100000000`3oool00000
0?ooo`0@0?ooo`<00000@P3oool2000004d0oooo1@0000020?ooo`<00000A`3oool003`0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0_0?ooo`D000007`3oool400000140oooo0P00
00130?ooo`040000003oool0oooo0?ooo`800000=`3oool4000000d0oooo0P0000000`3oool00000
000000260?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool08`3oool3000001/0oooo
1000000D0?ooo`800000@`3oool00`000000oooo0?ooo`1<0?ooo`<00000C@3oool003`0oooo00<0
00000?ooo`3oool00P3oool200000380oooo1P00000K0?ooo`@0000000<0oooo0000003oool0403o
ool2000004P0oooo00<000000?ooo`3oool0=@3oool5000000/0oooo0`0000290?ooo`030000003o
ool0oooo0100oooo0`00000V0?ooo`<000006`3oool00`000000oooo0?ooo`0D0?ooo`800000@@3o
ool2000000<0oooo0P00000g0?ooo`@00000303oool6000004d0oooo000l0?ooo`800000103oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool00000008000006`3oool3000001D0oooo00<00000
0?ooo`3oool0A@3oool2000003P0oooo1000000<0?ooo`800000R@3oool2000000P0oooo0P000008
0?ooo`8000009`3oool3000001T0oooo0P00000F0?ooo`800000@P3oool010000000oooo0?ooo`3o
ool2000003L0oooo1@00000<0?ooo`<00000C`3oool003`0oooo00<000000?ooo`3oool0>@3oool3
000001`0oooo00<000000?ooo`3oool0503oool200000400oooo0`0000040?ooo`030000003oool0
oooo008000000P3oool300000300oooo1@00000:0?ooo`800000R@3oool00`000000oooo0?ooo`03
0?ooo`80000000@0oooo0000000000000000103oool5000002T0oooo0P00000H0?ooo`<000005`3o
ool00`000000oooo0?ooo`150?ooo`800000=`3oool6000000X0oooo0P00001@0?ooo`00?03oool0
0`000000oooo0?ooo`030?ooo`800000=03oool4000001T0oooo0P00000H0?ooo`030000003oool0
oooo03l0oooo0P0000040?ooo`D000000`3oool2000002d0oooo0P000000103oool000000000003o
ool2000000T0oooo0`0000290?ooo`030000003oool0oooo00@0oooo1@0000050?ooo`@00000:@3o
ool3000001D0oooo1000001I0?ooo`<000001@3oool010000000oooo0000000000030?ooo`800000
;P3oool7000000T0oooo0`00001@0?ooo`00?03oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`0000005P3oool5000005T0oooo0P0000050?ooo`<0000000@0
oooo0000003oool0oooo0P00000_0?ooo`040000003oool0oooo000000d0oooo00<000000?ooo`3o
ool0R03oool00`000000oooo0?ooo`050?ooo`030000003oool0000000@0oooo1@00000[0?ooo`80
00005P3oool00`000000oooo0000001J0?ooo`800000103oool2000000030?ooo`000000000000@0
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`03000000X0oooo00<000000?ooo`3o
ool0C`3oool002@0oooo1@0000030?ooo`030000003oool0oooo00<0oooo100000060?ooo`030000
003oool0oooo0180oooo0P00000X0?ooo`8000005P3oool4000005P0oooo0`0000060?ooo`800000
103oool2000003@0oooo1@0000030?ooo`@00000L`3oool5000000<0oooo00<000000?ooo`3oool0
0`3oool4000000H0oooo00<000000?ooo`3oool00`3oool7000000<0oooo00@000000?ooo`000000
0000;03oool3000000T0oooo0`0000080?ooo`800000HP3oool2000000040?ooo`000000oooo0?oo
o`800000?@3oool2000005<0oooo000T0?ooo`050000003oool0oooo0?ooo`000000203oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0V0?ooo`<000005`3oool2000005T0oooo0P0000070?ooo`L00000;@3oool30000
00D0oooo1P0000020?ooo`030000003oool0000007<0oooo00D000000?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`80000000<0oooo0000000000000P0000060?ooo`030000003oool0oooo02/0oooo0P00000:
0?ooo`8000002@3oool00`000000oooo0?ooo`1I0?ooo`800000103oool3000000@0oooo0P00000e
0?ooo`8000001`3oool300000540oooo000U0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool00`3oool3000000P0oooo0P0000070?ooo`<00000:@3oool2000000/0oooo0`0000080?oo
o`800000I03oool01@000000oooo0000003oool0000002T0oooo200000050?ooo`@0000000<0oooo
0000003oool0N03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`040000003oool0oooo0?ooo`8000003P3oool4000002<0oooo0P0000090?ooo`800000103o
ool6000001T0oooo0P00000Z0?ooo`<000000`3oool2000000`0oooo100000050?ooo`030000003o
ool000000080000000<0oooo000000000000;@3oool3000000D0oooo100000000`3oool000000000
00040?ooo`030000003oool0oooo04l0oooo000V0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`8000000`3oool2000000P0oooo0P00000Z
0?ooo`8000002`3oool2000000T0oooo00<000000?ooo`3oool05`3oool2000002X0oooo0P000004
0?ooo`800000103oool200000100oooo0P0000020?ooo`800000:P3oool7000000H0oooo0`000004
0?ooo`800000MP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool02@3oool2000000030?ooo`000000000000@0oooo0P0000050?ooo`@000008`3oool3
000000H0oooo0`0000040?ooo`80000000@0oooo00000000000000006P3oool2000002T0oooo0`00
00040?ooo`030000003oool0oooo00/0oooo0P0000090?ooo`8000000P3oool00`000000oooo0?oo
o`0W0?ooo`<0000000@0oooo00000000000000001P3oool00`000000oooo000000020?ooo`030000
003oool0oooo05@0oooo000W0?ooo`030000003oool0oooo00P0oooo100000060?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`0000030?ooo`H00000:`3oool4000000h0oooo1P00
000J0?ooo`800000:P3oool3000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0>0?ooo`8000000`3oool00`000000oooo0?ooo`0X0?ooo`H00000203oool9000007H0oooo00<0
00000?ooo`3oool0203oool4000000H0oooo00<000000?ooo`3oool02@3oool3000000030?ooo`00
0000oooo00@0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool08@3o
ool800000080oooo0`0000020?ooo`D00000703oool2000002X0oooo0P0000030?ooo`800000103o
ool2000001@0oooo0P00000Y0?ooo`P000001P3oool3000000040?ooo`00000000000?ooo`<00000
DP3oool002@0oooo00D000000?ooo`3oool0oooo000000090?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01@3oool4000000D0oooo0P0000000`3oool000000000000/0?ooo`<00000
203oool3000000@0oooo0P0000000`3oool000000000000J0?ooo`800000:`3oool2000000<0oooo
0P00000G0?ooo`030000003oool0oooo02/0oooo0`0000000`3oool000000?ooo`0;0?ooo`L00000
L`3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0:0?ooo`<00000303oool00`000000oooo0?ooo`0U0?ooo`<0000000<0oooo00000000
00000`0000020?ooo`030000003oool0oooo00D00000703oool2000002/0oooo0`0000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool2000000<0oooo00<000000?ooo`3o
ool0:03oool2000000030?ooo`0000000000008000001`3oool500000080oooo0P00001B0?ooo`00
903oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`050?ooo`D000000`3oool5000002h0oooo1@0000040?ooo`D000000P3oool200000003
0?ooo`000000000001`0oooo0P00000[0?ooo`T000000P3oool2000000<0oooo0P0000090?ooo`80
000000@0oooo00000000000000002P3oool2000001l0oooo00<000000?ooo`3oool03P3oool01P00
0000oooo0?ooo`000000oooo000007<0oooo00D000000?ooo`3oool0oooo000000090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool2000000D0oooo0P0000040?ooo`800000
:03oool3000000030?ooo`0000000000008000000P3oool7000001h0oooo1000000Y0?ooo`D00000
00<0oooo0000000000004`3oool2000000d0oooo0P00000O0?ooo`8000003P3oool700000580oooo
000T0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00@0oooo100000000`3oool00000000000030?ooo`040000003oool00000000002l0
oooo2P0000000`3oool00000000000020?ooo`D000007@3oool3000002P0oooo2P0000030?ooo`03
0000003oool0oooo0080oooo0P0000090?ooo`030000003oool0oooo008000002@3oool3000001<0
oooo1@0000050?ooo`<00000303oool2000007/0oooo00D000000?ooo`3oool0oooo000000090?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?oo
o`040000003oool0oooo0?ooo`<00000:P3oool00`000000oooo0?ooo`03000000<0oooo0`000002
0?ooo`030000003oool0oooo01`0oooo1P00000T0?ooo`/000000P3oool2000000@0oooo0P00000:
0?ooo`@000002@3oool3000001@0oooo100000060?ooo`<000003`3oool01P000000oooo0?ooo`00
0000oooo00000580oooo000U0?ooo`<000002P3oool5000000D0oooo0P0000060?ooo`030000003o
ool000000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`8000009P3o
ool900000080oooo1`00000M0?ooo`@0000000<0oooo0000000000008`3oool2000000030?ooo`00
0000000000<0000000@0oooo000000000000oooo0P0000050?ooo`<000002`3oool3000000P0oooo
1000000D0?ooo`@000001P3oool2000000d0oooo00@000000?ooo`3oool0oooo0P00001g0?ooo`<0
00002P3oool5000000D0oooo0P00000D0?ooo`8000000`3oool00`000000oooo0?ooo`0a0?ooo`<0
00008`3oool2000000040?ooo`0000000000000002@0oooo1P0000000`3oool00000000000040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool2000000030?ooo`0000000000
00T0oooo0`00000D0?ooo`@000001@3oool3000006P0oooo000l0?ooo`030000003oool0oooo00T0
oooo0`00000=0?ooo`<00000:03oool200000080oooo0`0000000`3oool000000000000300000240
oooo0`0000000`3oool000000000000S0?ooo`8000001P3oool4000000030?ooo`000000oooo00D0
oooo0`00000;0?ooo`030000003oool0oooo00P0oooo0P0000090?ooo`8000001`3oool700000080
oooo1@00000?0?ooo`<0000000<0oooo0000003oool0S@3oool00`000000oooo0?ooo`0C0?ooo`80
000000<0oooo000000000000=@3oool00`000000oooo0?ooo`0S0?ooo`80000000<0oooo00000000
00008@3oool3000000L0oooo0`0000000`3oool00000000000040?ooo`@000002@3oool010000000
oooo0000000000090?ooo`<00000203oool2000000/0oooo0`0000030?ooo`80000000<0oooo0000
003oool0303oool5000000030?ooo`000000000005@0oooo000l0?ooo`030000003oool0oooo00X0
oooo0P0000000`3oool00000000000030?ooo`8000001P3oool3000002P0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`@000008P3oool010000000oooo0?ooo`3oool200000240oooo0`000007
0?ooo`030000003oool0000000L0oooo0P0000000`3oool000000?ooo`0D0?ooo`<000000P3oool3
000000D0oooo00<000000?ooo`3oool01P3oool600000080oooo1@00000@0?ooo`@00000SP3oool0
0`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000005`0oooo0P0000000`3oool000000?oo
o`0Q0?ooo`800000203oool200000080oooo00<000000?ooo`3oool00`3oool3000000/0oooo0P00
00080?ooo`<000000`3oool2000000D0oooo00<000000?ooo`3oool01P3oool5000000D0oooo0`00
000>0?ooo`040000003oool0000000000080oooo00<000000?ooo`3oool0DP3oool003`0oooo00<0
00000?ooo`3oool02P3oool3000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool00`3o
ool2000000030?ooo`000000oooo0300oooo00<000000?ooo`3oool08`3oool3000000030?ooo`00
0000oooo0240oooo00<000000?ooo`3oool01@3oool2000000040?ooo`00000000000?ooo`800000
00D0oooo000000000000oooo0000000H0?ooo`040000003oool0oooo0?ooo`<0000000<0oooo0000
000000000`0000070?ooo`@000000`3oool4000000030?ooo`000000oooo0180oooo0P00002>0?oo
o`030000003oool0oooo01<0oooo0P00001O0?ooo`800000;03oool2000000T0oooo0P0000000`3o
ool000000?ooo`0;0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0oooo0`00000>
0?ooo`<0000000D0oooo00000000000000000?ooo`0500000180oooo0P00001E0?ooo`00?03oool0
0`000000oooo0?ooo`0;0?ooo`<00000303oool00`000000oooo0?ooo`1G0?ooo`<00000;@3oool0
0`000000oooo00000002000000030?ooo`000000000000<00000603oool400000080oooo0`000000
0`3oool0000000000003000000L0oooo0P0000030?ooo`@000005`3oool00`000000oooo0?ooo`2<
0?ooo`030000003oool0oooo01@0oooo00@000000?ooo`0000000000F`3oool3000002d0oooo00D0
00000?ooo`00000000000?ooo`02000000@0oooo00<000000?ooo`3oool05@3oool2000000@0oooo
200000070?ooo`@000000`3oool00`000000oooo00000003000001<0oooo0P00001E0?ooo`00?03o
ool00`000000oooo0?ooo`0<0?ooo`8000001@3oool2000000<0oooo0P00001K0?ooo`800000;`3o
ool3000000060?ooo`00000000000000003oool000006@3oool00`000000oooo000000040?ooo`03
0000003oool0000000D000002`3oool400000:H0oooo00<000000?ooo`3oool05@3oool3000005`0
oooo00<000000?ooo`3oool0;`3oool2000000030?ooo`000000000000<000006@3oool010000000
oooo0000000000020?ooo`80000000<0oooo0000000000000`0000070?ooo`030000003oool0oooo
0080oooo1@00000F0?ooo`030000003oool0oooo05<0oooo000l0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`3oool2000005X0oooo0P00000a0?oo
o`8000000P3oool300000240oooo200000050?ooo`8000001@3oool00`000000oooo0?ooo`2V0?oo
o`030000003oool0oooo01@0oooo1000002?0?ooo`030000003oool0000000@00000703oool01000
0000oooo0?ooo`3oool7000000`0oooo1000001]0?ooo`00?03oool2000001@0oooo0P0000030?oo
o`800000F`3oool00`000000oooo0?ooo`0b0?ooo`D000006`3oool8000000<0oooo100000040?oo
o`030000003oool0oooo0:`0oooo0P00000E0?ooo`@00000GP3oool200000240oooo0P00000;0?oo
o`8000000P3oool4000001/0oooo100000000`3oool000000000000200000080oooo100000030?oo
o`8000001@3oool00`000000oooo0?ooo`1]0?ooo`00?03oool00`000000oooo0?ooo`0D0?ooo`80
000000@0oooo0000000000000000G@3oool200000240oooo0P00000?0?ooo`040000003oool00000
000001/0oooo100000000`3oool00000000000040?ooo`@0000000<0oooo000000000000/03oool0
0`000000oooo0?ooo`0E0?ooo`800000H03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo00X0oooo00D000000?ooo`00000000000?ooo`0200000180oooo0P0000080?ooo`<0000000@0
oooo0000000000000000103oool4000000<0oooo00<000000?ooo`3oool0L`3oool003`0oooo00<0
00000?ooo`3oool05@3oool010000000oooo0?ooo`00001O0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
0`0000020?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`2A0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool00P3oool2000000<0
oooo00D000000?ooo`3oool0oooo000000040?ooo`D0000000<0oooo000000000000MP3oool003`0
oooo00<000000?ooo`3oool0a03oool400000100oooo1000002`0?ooo`030000003oool0oooo09D0
oooo0P00000[0?ooo`H000003@3oool00`000000oooo00000004000007H0oooo000l0?ooo`030000
003oool0oooo01@0oooo0P0000200?ooo`800000:`3oool500000140oooo0`00002`0?ooo`030000
003oool0oooo09H0oooo00<000000?ooo`3oool00P00000W0?ooo`D00000403oool2000000030?oo
o`000000oooo07H0oooo000l0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`0000000000
OP3oool010000000oooo00000000000W0?ooo`H000004P3oool200000;00oooo00<000000?ooo`3o
ool0P`3oool2000001<0oooo0`00000V0?ooo`D000004P3oool3000007L0oooo000l0?ooo`800000
5P3oool2000000030?ooo`000000oooo06T0oooo0`00000C0?ooo`800000:03oool010000000oooo
00000000000B0?ooo`<00000/03oool2000008D0oooo0P00000C0?ooo`030000003oool0oooo02H0
oooo00@000000?ooo`3oool000004`3oool2000007L0oooo000l0?ooo`030000003oool0oooo01H0
oooo0P00001R0?ooo`8000001`3oool4000000P0oooo0P0000050?ooo`8000000P3oool00`000000
oooo0?ooo`0m0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0M`3oool4000000L0
oooo100000090?ooo`8000000P3oool500000400oooo0`00001g0?ooo`00?03oool00`000000oooo
0?ooo`0E0?ooo`<00000H03oool2000000030?ooo`000000oooo00L0oooo0`0000090?ooo`800000
00<0oooo0000000000001000003c0?ooo`030000003oool0oooo07P0oooo00@000000?ooo`000000
00001@3oool700000080oooo0P0000020?ooo`<0000000D0oooo00000000000000000?ooo`020000
0440oooo0P00001g0?ooo`00?03oool00`000000oooo0?ooo`0F0?ooo`800000H@3oool010000000
oooo0000000000040?ooo`<0000000@0oooo00000000000000000`3oool2000000030?ooo`000000
00000080000000D0oooo00000000000000000?ooo`0200000?<0oooo00<000000?ooo`3oool0N@3o
ool3000000H0oooo00<000000?ooo`0000000`0000020?ooo`H000000P3oool800000;P0oooo000l
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0GP3oool3000000030?ooo`000000
oooo008000000P3oool200000080oooo0`000000103oool000000000000000020?ooo`80000000<0
oooo0000000000001`00003a0?ooo`030000003oool0oooo07L0oooo100000020?ooo`<000001@3o
ool3000000030?ooo`000000000000D0000000<0oooo0000000000000`000000103oool000000?oo
o`00002h0?ooo`00?03oool00`000000oooo0?ooo`1i0?ooo`800000103oool2000000H0oooo0P00
00020?ooo`80000000<0oooo0000000000000`3oool020000000oooo000000000000oooo0000003o
ool00000l@3oool00`000000oooo0?ooo`1h0?ooo`800000103oool4000000P0oooo00<000000?oo
o`0000000`0000020?ooo`050000003oool0oooo0000003oool00P00002i0?ooo`00?03oool00`00
0000oooo0?ooo`1j0?ooo`<0000000<0oooo0000000000000`00000:0?ooo`<000000P3oool20000
00<0oooo0`00003b0?ooo`030000003oool0oooo07P0oooo100000000`3oool00000000000030000
00L0oooo1@0000000`3oool0000000000002000000@0oooo0P00002i0?ooo`00?03oool2000007X0
oooo0P0000001P3oool000000?ooo`3oool000000?ooo`8000001P3oool6000000030?ooo`000000
000000800000103oool200000?80oooo0P00001j0?ooo`030000003oool0000000<000000P3oool0
0`000000oooo0?ooo`020?ooo`8000000P3oool010000000oooo0000000000020?ooo`<000001@3o
ool00`000000oooo0?ooo`2g0?ooo`00?03oool00`000000oooo0?ooo`1j0?ooo`T00000103oool5
000000030?ooo`00000000000080oooo0P0000060?ooo`030000003oool0oooo0?00oooo00<00000
0?ooo`3oool0O03oool6000000D0oooo0`0000070?ooo`030000003oool0oooo0;h0oooo000l0?oo
o`030000003oool0oooo07`0oooo1P0000060?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool0m`3oool00`000000oooo0?ooo`1l0?ooo`80000000@0oooo00000000000000001@3oool3
00000<P0oooo000l0?ooo`030000003oool0oooo07d0oooo0P0000000`3oool000000?ooo`060?oo
o`<00000o`3oool20?ooo`030000003oool0oooo07d0oooo00@000000?ooo`00000000001P3oool3
00000<P0oooo000c0?ooo`<000001P3oool00`000000oooo0?ooo`1n0?ooo`040000003oool00000
000000H0oooo0`00003h0?ooo`<000001P3oool00`000000oooo0?ooo`200?ooo`030000003oool0
oooo00D0oooo0P0000380?ooo`00<P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<00000
0?ooo`3oool0P@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?H0oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0?l0ooooD`3oool003H0oooo00<00000
0?ooo`3oool00`3oool300000?l0ooooQ`3oool00`000000oooo0?ooo`030?ooo`800000o`3ooomD
0?ooo`00=P3oool00`000000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0o`3ooomI0?oo
o`00=03oool200000?l0ooooSP3oool200000?l0ooooG03oool003H0oooo00<000000?ooo`3oool0
o`3ooon=0?ooo`030000003oool0oooo0?l0ooooF@3oool003H0oooo00<000000?ooo`3oool0o`3o
oon=0?ooo`030000003oool0oooo0?l0ooooF@3oool00380oooo00D000000?ooo`3oool0oooo0000
002?0?ooo`800000n@3oool01@000000oooo0?ooo`3oool0000008h0oooo0P00003:0?ooo`00<`3o
ool300000980oooo00<000000?ooo`3oool0m`3oool300000940oooo00<000000?ooo`3oool0a`3o
ool00<P0oooo00<000000?ooo`3oool0o`3ooon<0?ooo`030000003oool0oooo0<L0oooo002D0?oo
o`80000000<0oooo0000003oool00P0000020?ooo`<0000000<0oooo0000003oool00P3oool30000
00<0oooo0`0000000`3oool000000?ooo`04000000<0oooo1@0000040?ooo`<00000103oool00`00
0000oooo0?ooo`090?ooo`80000000<0oooo0000003oool00P0000020?ooo`<000000P3oool30000
0080oooo0P0000030?ooo`<0000000D0oooo00000000000000000?ooo`03000000X0oooo1@000003
0?ooo`<00000o`3ooolG0?ooo`80000000<0oooo0000003oool00P0000020?ooo`<0000000<0oooo
0000003oool00P3oool3000000<0oooo0`0000000`3oool000000?ooo`04000000<0oooo1@000004
0?ooo`<00000103oool00`000000oooo0?ooo`0:0?ooo`80000000<0oooo0000003oool00P000002
0?ooo`<000000P3oool300000080oooo0P0000030?ooo`<0000000D0oooo00000000000000000?oo
o`03000000T0oooo1@0000040?ooo`030000003oool0oooo08D0oooo002E0?ooo`050000003oool0
00000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`<000002`3oool01@000000oooo0000
003oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0
oooo5`3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`00
00001`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool30000
00`0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool0Q@3oool009D0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0000000;0?ooo`050000003oool000000?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo0000003o0?oooaL0oooo00D000000?ooo`000000oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0000000<0?ooo`050000003oool000000?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0Q@3oool009D0oooo00D000000?ooo`000000oooo000000030?oo
o`@000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool0
1@000000oooo0?ooo`3oool0000000X0oooo00D000000?ooo`000000oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00`3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000?l0oooo5`3oool01@000000oooo0000003oool0000000<0oooo
100000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000002`3oool01@000000oooo0000003oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo08@0oooo002E0?ooo`050000003oool000000?ooo`0000001P3oool01@000000
oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000002P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P0000020?oo
o`030000003oool0oooo00`0oooo00@000000?ooo`3oool0oooo1000003o0?oooaP0oooo00D00000
0?ooo`000000oooo000000060?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`050000003oool00000
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000003o
ool0oooo0?ooo`0000001@3oool200000080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo08@0oooo002D0?ooo`<0000000<0oooo0000003oool00P3o
ool4000000<0oooo1@0000000`3oool00000000000020?ooo`8000000P3oool00`000000oooo0000
000200000080oooo0`0000040?ooo`D0000000D0oooo00000000000000000?ooo`03000000P0oooo
0`0000000`3oool000000?ooo`030?ooo`<000000P3oool00`000000oooo00000002000000<0oooo
1@0000020?ooo`040000003oool00000000000`0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0?l0oooo603oool3000000030?ooo`000000oooo0080oooo100000030?oo
o`D0000000<0oooo0000000000000P3oool200000080oooo00<000000?ooo`0000000P0000020?oo
o`<00000103oool5000000050?ooo`00000000000000003oool00`0000090?ooo`<0000000<0oooo
0000003oool00`3oool300000080oooo00<000000?ooo`0000000P0000030?ooo`D000000P3oool0
10000000oooo00000000000;0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`240?ooo`00Y03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`3o0?ooobP0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0Q03oool00:@0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
3@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0o`3ooolW0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00`0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000Q@3oool00;X0oooo00<000000?ooo`3oool0<`3oool200000100oooo0`0000050?oo
o`<00000o`3oooll0?ooo`030000003oool0oooo03@0oooo0P00000?0?ooo`<000000`3oool50000
08D0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0ooooo`3o
oooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3oool00?l0
ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0oooo8`3o
ool00?l0ooooo`3ooooo0?ooob<0oooo003o0?ooool0ooooo`3ooolS0?ooo`00o`3ooooo0?ooool0
oooo8`3oool00001\
\>"],
  ImageRangeCache->{{{0, 799}, {493.375, 0}} -> {-0.0509172, -0.0309017, \
0.00263058, 0.00263058}, {{19.3125, 381.375}, {481.625, 257.875}} -> \
{-159.832, -0.420476, 2.62839, 0.0155582}, {{417.562, 779.625}, {481.625, \
257.875}} -> {-1206.59, -0.420476, 2.62839, 0.0155582}, {{19.3125, 381.375}, \
{235.5, 11.6875}} -> {-159.659, -4.24844, 2.62757, 0.0155534}, {{417.562, \
779.625}, {235.5, 11.6875}} -> {-1206.09, -4.24844, 2.62757, 0.0155534}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
WindowSize->{1533, 1005},
WindowMargins->{{Automatic, 0}, {1, Automatic}},
CellLabelAutoDelete->True,
Magnification->1,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "info"->{
    Cell[3198, 117, 7045, 207, 162, "Output",
      CellTags->"info"]},
  "Info3266764216-5494681"->{
    Cell[10365, 332, 174, 3, 23, "Print",
      CellTags->"Info3266764216-5494681"]},
  "1. real fwds, short end"->{
    Cell[11395, 382, 45218, 1237, 446, "Output",
      CellTags->"1. real fwds, short end"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"info", 317770, 9771},
  {"Info3266764216-5494681", 317872, 9774},
  {"1. real fwds, short end", 317989, 9777}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 75, "Section"],
Cell[1814, 55, 50, 1, 27, "Input"],
Cell[1867, 58, 240, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[2132, 67, 120, 3, 27, "Input"],
Cell[2255, 72, 41, 1, 27, "Output"]
}, Open  ]],
Cell[2311, 76, 124, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[2460, 83, 113, 2, 27, "Input"],
Cell[2576, 87, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2659, 93, 42, 1, 27, "Input"],
Cell[2704, 96, 35, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2776, 102, 54, 1, 27, "Input"],
Cell[2833, 105, 205, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3075, 113, 120, 2, 27, "Input"],
Cell[3198, 117, 7045, 207, 162, "Output",
  CellTags->"info"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10280, 329, 82, 1, 27, "Input"],
Cell[10365, 332, 174, 3, 23, "Print",
  CellTags->"Info3266764216-5494681"]
}, Open  ]],
Cell[10554, 338, 62, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[10641, 343, 68, 1, 27, "Input"],
Cell[10712, 346, 78, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10827, 352, 76, 1, 27, "Input"],
Cell[10906, 355, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10982, 361, 77, 1, 27, "Input"],
Cell[11062, 364, 62, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11161, 370, 65, 1, 27, "Input"],
Cell[11229, 373, 40, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11306, 379, 86, 1, 27, "Input"],
Cell[11395, 382, 45218, 1237, 446, "Output",
  CellTags->"1. real fwds, short end"]
}, Open  ]],
Cell[56628, 1622, 138, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[56791, 1630, 145, 4, 27, "Input"],
Cell[56939, 1636, 130, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57106, 1644, 146, 4, 31, "Input"],
Cell[57255, 1650, 37, 1, 27, "Output"]
}, Open  ]],
Cell[57307, 1654, 141, 3, 32, "Text"],
Cell[57451, 1659, 210, 4, 31, "Input"],

Cell[CellGroupData[{
Cell[57686, 1667, 53, 1, 27, "Input"],
Cell[57742, 1670, 273, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58052, 1679, 105, 2, 27, "Input"],
Cell[58160, 1683, 43, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58240, 1689, 147, 2, 27, "Input"],
Cell[58390, 1693, 43734, 1433, 194, 23575, 1181, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102161, 3131, 84, 1, 27, "Input"],
Cell[102248, 3134, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102324, 3140, 429, 9, 91, "Input"],
Cell[102756, 3151, 214332, 6598, 503, 105975, 5257, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

