(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    276624,       7873]*)
(*NotebookOutlinePosition[    277582,       7906]*)
(*  CellTagsIndexPosition[    277458,       7899]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["LHC-optics-web", "Section"],

Cell[BoxData[
    \(Needs["\<MathXLS`\>"]\)], "Input"],

Cell[TextData[{
  "The original Excel file can be found at: ",
  ButtonBox["http://proj-lhc-optics-web.web.cern.ch/proj-lhc-optics-web/V6.4/\
Injection/LHCB1IR3.xls",
    ButtonData:>{
      URL[ 
      "http://proj-lhc-optics-web.web.cern.ch/proj-lhc-optics-web/V6.4/\
Injection/LHCB1IR3.xls"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell["\<\
Since these are (calculated) numbers we are interested in the real \
saved (and not the displayed) values and use GetXLS:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TotalTiming[\(g = 
            GetXLS["\<LHCB1IR3.xls\>"];\)]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \("2 seconds"\)], "Output"]
}, Open  ]],

Cell["\<\
ShortXLS only displays part of the sheets of a workbook. Here 450 \
rows, indicated by <<450>>, are omitted in the first and only sheet.\
\>", \
"Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ShortXLS[g];\)\)], "Input"],

Cell[BoxData[GridBox[{
        {"#1", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"MADMACS processed file at:\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"06/12/02\"\>", "\<\"04:59:56\"\>", "\<\"\"\>", "\
\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            FontWeight->
              "Bold"], "\<\"Right-Click/HyperLink/Open in New Window for help \
with this file\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"ALFA\"\>", 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"BCURRENT\"\>", 
          StyleBox["0.000198189590018",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"BETXMAX\"\>", 
          StyleBox["398.455977141",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["6",
            FontWeight->"Bold"], "\<\"BETYMAX\"\>", 
          StyleBox["414.997521462",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"Brho\"\>", 
          StyleBox["1501.03597876315",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"CHARGE\"\>", 
          StyleBox["1.",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            
            FontWeight->
              "Bold"], "\<\"DATE\"\>", "\<\"12/06/2002\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"DQ1\"\>", 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", \
"\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\
\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", \
"\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\
\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", \
"\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>", "\<\"<<450>>\"\>"},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_237\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.567",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1088.944548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.0138079",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.79060105",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.000894695",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.19555995\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4803109497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.30013948",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.975072246",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02538538599",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQT.13R3.B1\"\>", \
"\<\"RQT13.R3B1\"\>", 
          StyleBox["0.32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.001441094769\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1089.264548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["175.5030828",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.47144536",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.009480018",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.459139498\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5168972733",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.300430934",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.976586532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02827493996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_185\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.298",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1089.562548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["176.9722959",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.16673658",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01790595",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.471105757\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.505615404",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.300700051",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.97801002",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02827493996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQ.13R3.B1\"\>", \
"\<\"RQF.A34B1\"\>", 
          StyleBox["3.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02782233029",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1092.662548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["176.9722959",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.16673658",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01790595",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.471105758",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5056154039\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.30344818",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.993123241",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_54\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.1605",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1092.823048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["176.1801054",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.33001437",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.013367822",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.464660843",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5116917127\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.303592846",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.993891536",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MS.13R3.B1\"\>", \
"\<\"RSF2.A34B1\"\>", 
          StyleBox["0.369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02414923917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1093.192048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.3666532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.71279773",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.002934369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.449843562",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5256615442\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.303927917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99564356",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_49\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.0835",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1093.275548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["173.9578093",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.80084716",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.000573412",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.4464906",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5288227391\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.304004222",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.996037242",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"HKICKER\"\>", "\<\"MCBH.13R3.B1\"\>", \
"\<\"RCBH13.R3B1\"\>", 
          StyleBox["0.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1093.925548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["170.7943371",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["34.50431199",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.982194701",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.420389699",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5534308432\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.304604394",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99906666",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_56\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.422",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1094.347548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["168.7586792",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["34.97814964",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.970262676",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.403444191",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5694071816\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.305",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"MARKER\"\>", "\<\"E.DS.R3.B1\"\>", "\<\"OMK\"\>", 
          
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1094.347548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["168.7586792",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["34.97814964",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.970262676",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.403444191",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5694071816\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.305",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02827493994\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]}
        },
      ColumnAlignments->{Center, Left, Right, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"LHCB1IR3.csv"]
}, Open  ]],

Cell["\<\
It is also possible to read the data in as formatted, here with \
ImportXLS.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TotalTiming[\(i = 
            ImportXLS["\<LHCB1IR3.xls\>", 
              ToMatrix \[Rule] 
                True];\)]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], \
"Input"],

Cell[BoxData[
    \("4 seconds"\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "It is not possible to represent Excel merged cells in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The option ",
  StyleBox["StringCutOff", "Program"],
  " controls the number \nof characters displayed. The shortened text is \
grayed out and acts as a button which, when clicked on, pastes the contents \
into a new notebook."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ExcelForm[Take[i, 100], StringCutOff \[Rule] 12];\)\)], "Input"],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["M",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["N",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["O",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["U",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["V",
            ZeroWidthTimes->True,
            FontWeight->"Bold"]},
        {
          StyleBox["1",
            FontWeight->"Bold"], 
          InterpretationBox[
            ButtonBox[Cell["MADMACS proc", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"MADMACS processed file at:\""}], 
                      "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"MADMACS processed file at:\""],
            
            "\"MADMACS processed file at:\""], "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"06-Dec-2002\"\>", "\<\"31-Dec-1899\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            FontWeight->"Bold"], 
          InterpretationBox[
            ButtonBox[Cell["Right-Click/", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      
                      TextData[ {
                        "\"Right-Click/HyperLink/Open in New Window for help \
with this file\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              
              ButtonNote->
                "\"Right-Click/HyperLink/Open in New Window for help with \
this file\""],
            
            "\"Right-Click/HyperLink/Open in New Window for help with this \
file\""], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"ALFA\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"BCURRENT\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"BETXMAX\"\>", 
          StyleBox["398.456",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["6",
            FontWeight->"Bold"], "\<\"BETYMAX\"\>", 
          StyleBox["414.998",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"Brho\"\>", 
          StyleBox["1501.036",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"CHARGE\"\>", 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            
            FontWeight->
              "Bold"], "\<\"DATE\"\>", "\<\"12-Jun-2002\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"DQ1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            FontWeight->"Bold"], "\<\"DQ2\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["12",
            FontWeight->"Bold"], "\<\"DXMAX\"\>", 
          StyleBox["2.86",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["13",
            FontWeight->"Bold"], "\<\"DXRMS\"\>", 
          StyleBox["1.576",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["14",
            FontWeight->"Bold"], "\<\"DYMAX\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["15",
            FontWeight->"Bold"], "\<\"DYRMS\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["16",
            FontWeight->"Bold"], "\<\"ENERGY\"\>", 
          StyleBox["450",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["17",
            FontWeight->"Bold"], "\<\"ET\"\>", 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["18",
            FontWeight->"Bold"], "\<\"EX\"\>", 
          StyleBox["7.82*^-9",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["19",
            FontWeight->"Bold"], "\<\"EY\"\>", 
          StyleBox["7.82*^-9",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["20",
            FontWeight->"Bold"], "\<\"GAMMA\"\>", 
          StyleBox["479.605",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["21",
            FontWeight->"Bold"], "\<\"GAMMATR\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["22",
            FontWeight->"Bold"], "\<\"KBUNCH\"\>", 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["23",
            FontWeight->"Bold"], "\<\"LENGTH\"\>", 
          StyleBox[\(-5023.199\),
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["24",
            FontWeight->"Bold"], "\<\"MASS\"\>", 
          StyleBox["0.938",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["25",
            FontWeight->"Bold"], "\<\"NPART\"\>", 
          StyleBox["110000000000",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["26",
            FontWeight->"Bold"], "\<\"OpticsSource\"\>", 
          InterpretationBox[
            ButtonBox[Cell["/afs/cern.ch", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"/afs/cern.ch/eng/lhc/optics/V6.4/\""}], 
                      "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"/afs/cern.ch/eng/lhc/optics/V6.4/\""],
            
            "\"/afs/cern.ch/eng/lhc/optics/V6.4/\""], "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"ORIGIN\"\>", 
          InterpretationBox[
            ButtonBox[Cell["MAD-X 1.07 L", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"MAD-X 1.07 Linux\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"MAD-X 1.07 Linux\""],
            
            "\"MAD-X 1.07 Linux\""], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["28",
            
            FontWeight->
              "Bold"], "\<\"PARTICLE\"\>", "\<\"PROTON\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["29",
            FontWeight->"Bold"], "\<\"PC\"\>", 
          StyleBox["449.999",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["30",
            FontWeight->"Bold"], "\<\"PTC\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["31",
            FontWeight->"Bold"], "\<\"Q1\"\>", 
          StyleBox["2.305",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["32",
            FontWeight->"Bold"], "\<\"Q2\"\>", 
          StyleBox["2.001",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>",
           "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["33",
            
            FontWeight->
              "Bold"], "\<\"SEQUENCE\"\>", "\<\"LHCB1\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["34",
            FontWeight->"Bold"], "\<\"SequenceFile\"\>", 
          InterpretationBox[
            ButtonBox[Cell["InputForm[V6", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"InputForm[\\\"V6.4.seq\\\"]\""}], 
                      "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"InputForm[\\\"V6.4.seq\\\"]\""],
            
            "\"InputForm[\\\"V6.4.seq\\\"]\""], "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["35",
            FontWeight->"Bold"], "\<\"SIGE\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["36",
            FontWeight->"Bold"], "\<\"SIGT\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["37",
            
            FontWeight->
              "Bold"], "\<\"TIME\"\>", "\<\"11.45.27\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["38",
            FontWeight->"Bold"], "\<\"TITLE\"\>", 
          InterpretationBox[
            ButtonBox[Cell["LHC V6.4 Bea", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      
                      TextData[ {
                        "\"LHC V6.4 Beam1 IR3 450GeV Injection Crossing \
Bumps(IP1=IP5=100% IP2=100% IP8=100%)\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              
              ButtonNote->
                "\"LHC V6.4 Beam1 IR3 450GeV Injection Crossing \
Bumps(IP1=IP5=100% IP2=100% IP8=100%)\""],
            
            "\"LHC V6.4 Beam1 IR3 450GeV Injection Crossing \
Bumps(IP1=IP5=100% IP2=100% IP8=100%)\""], "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["39",
            
            FontWeight->
              "Bold"], "\<\"TYPE\"\>", "\<\"TWISS\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["40",
            FontWeight->"Bold"], "\<\"XCMAX\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["41",
            FontWeight->"Bold"], "\<\"XCRMS\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["42",
            FontWeight->"Bold"], "\<\"YCMAX\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["43",
            FontWeight->"Bold"], "\<\"YCRMS\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["44",
            
            FontWeight->
              
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["45",
            
            FontWeight->
              "Bold"], "\<\"KEYWORD\"\>", "\<\"NAME\"\>", "\<\"PARENT\"\>", "\
\<\"L\"\>", "\<\"K0L\"\>", "\<\"K1L\"\>", "\<\"K2L\"\>", "\<\"K3L\"\>", \
"\<\"S\"\>", "\<\"BETX\"\>", "\<\"BETY\"\>", "\<\"DX\"\>", "\<\"DY\"\>", \
"\<\"XC\"\>", "\<\"YC\"\>", "\<\"ALFX\"\>", "\<\"ALFY\"\>", "\<\"MUX\"\>", \
"\<\"MUY\"\>", "\<\"DPX\"\>", "\<\"PXC\"\>", "\<\"PYC\"\>"},
        {
          StyleBox["46",
            
            FontWeight->
              "Bold"], "\<\"MARKER\"\>", "\<\"S.DS.L3.B1\"\>", "\<\"OMK\"\>", 
          
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.031",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.517",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.348\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["47",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_61\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.367\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.003",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["48",
            
            FontWeight->
              "Bold"], "\<\"MONITOR\"\>", "\<\"BPM.13L3.B1\"\>", \
"\<\"BPM\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.367\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.003",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["49",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_150\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.567",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.067",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["177.085",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.987",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.474",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.388\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["50",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQT.13L3.B1\"\>", \
"\<\"RQT13.L3B1\"\>", 
          StyleBox["0.32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.387",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.181",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.677",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.493",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.589\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.007",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.014\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["51",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_151\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.298",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.685",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.89",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.224",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.979",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.481",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.602\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.009",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.002",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.014\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["52",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQ.13L3.B1\"\>", \
"\<\"RQD.A23B1\"\>", 
          StyleBox["3.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.027\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.691",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["181.374",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.975",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.415\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.241",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.026",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["53",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_240\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.946",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.826",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.656",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.977",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.421\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.236",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.026",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["54",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MS.13L3.B1\"\>", \
"\<\"RSD1.A23B1\"\>", 
          StyleBox["0.369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.039\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.314",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.142",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["179.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.982",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.436\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.224",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.028",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["55",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_49\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.084",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.398",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.215",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.639",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.439\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.221",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.029",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["56",
            
            FontWeight->
              "Bold"], "\<\"VKICKER\"\>", "\<\"MCBV.13L3.B1\"\>", \
"\<\"RCBV13.L3B1\"\>", 
          StyleBox["0.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.802",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["175.766",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.991",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.465\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.199",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.032",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["57",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_57\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.763",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.495\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.036",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["58",
            FontWeight->"Bold"], "\<\"MULTIPOLE\"\>", 
          InterpretationBox[
            ButtonBox[Cell["MCDO.B13L3.B", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"MCDO.B13L3.B1\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"MCDO.B13L3.B1\""],
            "\"MCDO.B13L3.B1\""], "\<\"RCDO13.L3B1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.495\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.036",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["59",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_314\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.339",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["170.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.508\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.163",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.038",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["60",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.C13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.45",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.484",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.898",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.073\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.688",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.094",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["61",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_339\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.669",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.955",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.162",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.214",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.081\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.681",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.094",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["62",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.C13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.779",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.193",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["114.792",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.216",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.086\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.677",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.095",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["63",
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_148\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["1.031",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.809",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["57.473",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["111.371",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.233",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.126\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.643",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.097",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.024",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["64",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.B13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.109",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["97.759",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.181",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.512",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.691\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.168",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["65",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_99\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.328",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.672",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.517",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.699\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.161",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.051",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["66",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.B13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.438",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.417",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.704\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.157",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.051",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["67",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_51\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.252",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.832",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.731\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.052",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["68",
            FontWeight->"Bold"], "\<\"MULTIPOLE\"\>", 
          InterpretationBox[
            ButtonBox[Cell["MCDO.A13L3.B", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"MCDO.A13L3.B1\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"MCDO.A13L3.B1\""],
            "\"MCDO.A13L3.B1\""], "\<\"RCDO13.L3B1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.252",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.832",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.731\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.052",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["69",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_141\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.339",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.469",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["102.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.067",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.542",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.744\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.123",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.053",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["70",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.A13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52.769",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["160.386",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.895",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.309\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.648",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.148",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.096",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["71",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_342\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52.988",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["161.398",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.468",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.901",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.317\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.641",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.148",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.097",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["72",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.A13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53.098",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["161.909",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.328",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.904",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.322\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.637",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.148",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.097",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["73",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_104\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.851",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53.949",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["165.888",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["41.268",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.927",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.355\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.609",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.149",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["74",
            
            FontWeight->
              "Bold"], "\<\"MONITOR\"\>", "\<\"BPM.12L3.B1\"\>", \
"\<\"BPM\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53.949",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["165.888",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["41.268",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.927",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.355\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.609",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.149",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["75",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_150\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.567",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.516",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["168.572",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40.589",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.942",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.377\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.103",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["76",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQT.12L3.B1\"\>", \
"\<\"RQT12.L3B1\"\>", 
          StyleBox["0.32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.002",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.836",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["170.009",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40.236",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.95",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.112\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.513",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.104",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.024",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["77",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_185\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.298",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["171.271",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["39.932",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.958",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.122\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.504",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.105",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.024",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["78",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQ.12L3.B1\"\>", \
"\<\"RQF.A23B1\"\>", 
          StyleBox["3.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.028",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["58.234",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["169.632",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40.479",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.947",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.635",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.685\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.153",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.118",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["79",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_210\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["58.394",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["168.787",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.942",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.628",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.691\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.153",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.118",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["80",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MS.12L3.B1\"\>", \
"\<\"RSF1.A23B1\"\>", 
          StyleBox["0.369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.024",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["58.763",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["166.854",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["41.215",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.931",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.611",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.705\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.154",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["81",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_341\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.084",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["58.847",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["166.418",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["41.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.928",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.607",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.708\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.154",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["82",
            
            FontWeight->
              "Bold"], "\<\"HKICKER\"\>", "\<\"MCBH.12L3.B1\"\>", \
"\<\"RCBH12.L3B1\"\>", 
          StyleBox["0.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["59.497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["163.049",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.268",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.908",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.576",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.731\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.154",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.122",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["83",
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_145\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["1.102",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["60.598",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["157.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["43.924",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.874",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.525",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.771\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.155",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.126",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.031\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["84",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.C12L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.898",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["94.798",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.409",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.472",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.855",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.291\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.167",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["85",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_342\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.117",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["93.989",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.976",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.466",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.845",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.299\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.167",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["86",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.C12L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.227",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["93.583",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.262",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.463",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.303\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.175",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.168",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["87",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_51\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.919",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["91.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.082",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.446",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.807",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.328\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.176",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.169",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["88",
            
            FontWeight->
              "Bold"], "\<\"MULTIPOLE\"\>", "\<\"MCDO.12L3.B1\"\>", \
"\<\"RCDO12.L3B1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.919",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["91.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.082",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.446",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.807",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.328\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.176",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.169",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["89",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_141\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.339",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.258",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["89.841",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.986",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.437",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.791",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.34\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.176",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.026\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["90",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.B12L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["90.558",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["48.187",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["122.734",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.107",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.121",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.859\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.211",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.193",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.021\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["91",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_99\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["90.777",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["47.698",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["123.549",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.103",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.111",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.867\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.212",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.194",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.021\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["92",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.B12L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["90.887",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["47.454",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["123.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.106",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.871\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.212",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.194",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.021\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["93",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_148\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["1.031",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["91.917",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["45.224",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["127.856",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.079",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.058",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.909\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.216",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.195",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.021\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["94",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.A12L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["106.217",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.551",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["189.867",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.822",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.388",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.428\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.286",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["95",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_339\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["106.436",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.384",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["190.931",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.819",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.378",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.436\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.288",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["96",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.A12L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["106.546",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.301",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["191.467",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.817",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.372",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.44\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.289",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["97",
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_250\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.351",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["106.897",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.046",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["193.184",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.812",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.356",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.453\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.291",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["98",
            
            FontWeight->
              "Bold"], "\<\"MARKER\"\>", "\<\"E.ARC.23.B1\"\>", "\<\"OMK\"\>",
           
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["106.897",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.046",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["193.184",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.812",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.356",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.453\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.291",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["99",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_61\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["107.397",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.702",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["195.646",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.804",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.471\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.294",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.211",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["100",
            
            FontWeight->
              "Bold"], "\<\"MONITOR\"\>", "\<\"BPM.11L3.B1\"\>", \
"\<\"BPM\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["107.397",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.702",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["195.646",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.804",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.333",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.471\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.294",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.211",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.015\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]}
        },
      ColumnAlignments->{Center, Left, Right, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[i]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[i, "\<KEYWORD\>"]\)], "Input"],

Cell[BoxData[
    \({{45, 1}}\)], "Output"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001100003b000`400?l0
0000o`00003o@@3oool00440oooo00060?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00050?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool000D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`<000000P3o
ool4000000@0oooo00<000000?ooo`3oool01`3oool5000000@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`001@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00@00000
0?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000000/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool6000000H0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool000D0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`001@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000`3oool400000100oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0005
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo000000030?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00060?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool2000000<0oooo00<000000?ooo`3o
ool03`3oool3000000D0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`050?ooo`00503oool010000000oooo0?ooo`3oool5000000l0
oooo00<000000?ooo`3oool04P3oool00440oooo00110?ooo`00\
\>"], "Output",
  Evaluatable->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{65, 15},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[Take[i, {45, 70}]]\)], "Input"],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["M",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["N",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["O",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["U",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["V",
            ZeroWidthTimes->True,
            FontWeight->"Bold"]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"KEYWORD\"\>", "\<\"NAME\"\>", "\<\"PARENT\"\>", "\
\<\"L\"\>", "\<\"K0L\"\>", "\<\"K1L\"\>", "\<\"K2L\"\>", "\<\"K3L\"\>", \
"\<\"S\"\>", "\<\"BETX\"\>", "\<\"BETY\"\>", "\<\"DX\"\>", "\<\"DY\"\>", \
"\<\"XC\"\>", "\<\"YC\"\>", "\<\"ALFX\"\>", "\<\"ALFY\"\>", "\<\"MUX\"\>", \
"\<\"MUY\"\>", "\<\"DPX\"\>", "\<\"PXC\"\>", "\<\"PYC\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"MARKER\"\>", "\<\"S.DS.L3.B1\"\>", "\<\"OMK\"\>", 
          
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.031",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.517",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.348\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_61\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.367\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.003",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["4",
            
            FontWeight->
              "Bold"], "\<\"MONITOR\"\>", "\<\"BPM.13L3.B1\"\>", \
"\<\"BPM\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.367\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.003",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_150\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.567",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.067",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["177.085",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.987",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.474",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.388\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.013\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQT.13L3.B1\"\>", \
"\<\"RQT13.L3B1\"\>", 
          StyleBox["0.32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.387",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.181",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.677",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.493",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.589\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.007",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.014\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_151\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.298",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.685",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.89",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.224",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.979",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.481",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.602\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.009",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.002",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.014\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["8",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQ.13L3.B1\"\>", \
"\<\"RQD.A23B1\"\>", 
          StyleBox["3.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.027\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.691",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["181.374",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.975",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.415\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.241",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.026",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_240\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.946",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.826",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.656",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.977",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.421\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.236",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.026",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MS.13L3.B1\"\>", \
"\<\"RSD1.A23B1\"\>", 
          StyleBox["0.369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.039\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.314",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.142",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["179.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.982",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.436\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.224",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.028",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_49\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.084",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.398",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.215",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.639",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.439\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.221",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.029",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"VKICKER\"\>", "\<\"MCBV.13L3.B1\"\>", \
"\<\"RCBV13.L3B1\"\>", 
          StyleBox["0.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.802",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["175.766",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.991",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.465\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.199",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.032",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_57\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.763",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.495\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.036",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"MULTIPOLE\"\>", "\<\"MCDO.B13L3.B1\"\>", \
"\<\"RCDO13.L3B1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.495\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.174",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.036",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_314\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.339",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["170.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.004",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.508\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.163",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.038",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.012",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.C13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.45",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.484",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.898",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.073\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.688",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.094",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_339\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.669",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.955",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.162",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.214",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.081\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.681",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.094",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.C13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.779",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.193",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["114.792",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.216",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.086\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.677",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.095",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.023",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_148\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["1.031",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.809",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["57.473",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["111.371",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.233",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.126\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.643",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.097",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.024",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.017",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.B13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.109",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["97.759",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.181",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.512",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.691\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.168",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_99\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.219",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.328",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.672",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.517",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.699\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.161",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.051",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["22",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.B13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.438",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.417",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.704\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.157",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.128",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.051",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_51\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.252",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.832",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.731\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.052",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["24",
            
            FontWeight->
              "Bold"], "\<\"MULTIPOLE\"\>", "\<\"MCDO.A13L3.B1\"\>", \
"\<\"RCDO13.L3B1\"\>", 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.252",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.832",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.731\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.052",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["25",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_141\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.339",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.469",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["102.429",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.067",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.542",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.744\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.123",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.053",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.022",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.A13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52.769",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["160.386",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.895",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.309\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.648",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.148",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.096",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.027",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0",
            FontColor->RGBColor[0, 0, 1]]}
        },
      ColumnAlignments->{Center, Left, Left, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[BoxData[
    \(\(m = ToMatrix[g];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[Take[m, {45, 70}]]\)], "Input"],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["M",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["N",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["O",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox["U",
            ZeroWidthTimes->True,
            FontWeight->"Bold"], 
          StyleBox["V",
            ZeroWidthTimes->True,
            FontWeight->"Bold"]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"KEYWORD\"\>", "\<\"NAME\"\>", "\<\"PARENT\"\>", "\
\<\"L\"\>", "\<\"K0L\"\>", "\<\"K1L\"\>", "\<\"K2L\"\>", "\<\"K3L\"\>", \
"\<\"S\"\>", "\<\"BETX\"\>", "\<\"BETY\"\>", "\<\"DX\"\>", "\<\"DY\"\>", \
"\<\"XC\"\>", "\<\"YC\"\>", "\<\"ALFX\"\>", "\<\"ALFY\"\>", "\<\"MUX\"\>", \
"\<\"MUY\"\>", "\<\"DPX\"\>", "\<\"PXC\"\>", "\<\"PYC\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"MARKER\"\>", "\<\"S.DS.L3.B1\"\>", "\<\"OMK\"\>", 
          
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.5478102",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.0312157",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.001130624",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5170226633",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.347949048\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01298271637\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_61\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.04083033",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.3886294",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9946392654",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4969370785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.366878359\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.002543064303",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.0004594391797",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01298271637\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["4",
            
            FontWeight->
              "Bold"], "\<\"MONITOR\"\>", "\<\"BPM.13L3.B1\"\>", \
"\<\"BPM\"\>", 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.04083033",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["174.3886294",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9946392654",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4969370785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.366878359\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.002543064303",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.0004594391797",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01298271637\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_150\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.567",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.067",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.49021828",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["177.0848406",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9872780653",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4741600253",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.388344198\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005476528884",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.000972955404",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01298271637\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQT.13L3.B1\"\>", \
"\<\"RQT13.L3B1\"\>", 
          StyleBox["0.32",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001055441132",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.387",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.1806406",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.6774178",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9829571123",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4931612797",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.589019861\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.007155368557",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001259286994",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01402247926\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_151\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.298",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.685",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.89037452",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.2243021",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9787784135",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.4808859936",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.601867042\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.008734483038",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.001523585729",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.01402247926\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["8",
            
            FontWeight->
              "Bold"], "\<\"QUADRUPOLE\"\>", "\<\"MQ.13L3.B1\"\>", \
"\<\"RQD.A23B1\"\>", 
          StyleBox["3.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.02669812969\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.69138844",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["181.3742852",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9754906544",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4149357799\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.241195793",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02555673284",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004215124911",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_240\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.1605",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9455",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.8255998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["180.6557168",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9773984754",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4212720803\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.235866014",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02641512833",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004356242619",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MS.13L3.B1\"\>", \
"\<\"RSD1.A23B1\"\>", 
          StyleBox["0.369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.03928500931\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3145",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.14187403",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["179.0101692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9817846806",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4358396496\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.223612503",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02837387262",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004682816988",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_49\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.0835",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.398",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.21493451",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["178.6390575",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.982777223",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.439136105\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.22083969",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02881423601",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.004757132515",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"VKICKER\"\>", "\<\"MCBV.13L3.B1\"\>", \
"\<\"RCBV13.L3B1\"\>", 
          StyleBox["0.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.80249111",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["175.765996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9905036007",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4647971348\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.199254915",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.03220550785",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.00534095232",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_57\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.763",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.5347547",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.4292652",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9995731795",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4949192361\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.173917711",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.03610223871",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006038498784",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"MULTIPOLE\"\>", "\<\"MCDO.B13L3.B1\"\>", \
"\<\"RCDO13.L3B1\"\>", 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.811",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.5347547",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["172.4292652",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9995731795",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.4949192361\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.173917711",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.03610223871",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006038498784",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_314\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.3387526506",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.149752651",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.8745954",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["170.9602351",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.003599842",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-0.5082926851\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.162668634",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.03780280682",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.006352513552",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01188673498",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.C13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005099988074",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.44975265",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.48357508",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.8984823",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.210031279",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.072741137\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.687803591",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.09354909945",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02254895497",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01698473203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_339\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.2187526506",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.6685053",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.95479404",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["115.1616483",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.213746734",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.081376537\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.680539397",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.0941853659",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02285031171",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01698473203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.C13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.7785053",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.19317453",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["114.7923315",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.215615055",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.085718856\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.676886588",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.09450324913",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02300257756",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01698473203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_148\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["1.030752651",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.80925795",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["57.47333063",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["111.3707021",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.233122112",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.126408468\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.642658029",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.09741613165",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.0244534816",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.01698473203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.B13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005099988074",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.10925795",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["97.75886131",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.18125256",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.512451606",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.690737084\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.167792986",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1279662782",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05012626144",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_99\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.2187526506",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.3280106",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.50045652",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.671926",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.517282155",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.699371363\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.160528791",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1283210725",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05061713299",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["22",
            
            FontWeight->
              "Bold"], "\<\"SEXTUPOLE\"\>", "\<\"MCS.B13L3.B1\"\>", \
"\<\"RCS.A23B1\"\>", 
          StyleBox["0.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["37.4380106",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["98.87479581",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.41701147",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.519711202",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.703713118\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.156875983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1284984714",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05086530382",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_51\"\>", "\<\"DRIFT\"\>", 
          StyleBox["0.692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.1300106",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.2516358",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.83179691",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.534992116",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.73102671\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1338965",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1295992142",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05244728033",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["24",
            
            FontWeight->
              "Bold"], "\<\"MULTIPOLE\"\>", "\<\"MCDO.A13L3.B1\"\>", \
"\<\"RCDO13.L3B1\"\>", 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.1300106",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["101.2516358",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.83179691",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.534992116",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.73102671\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1338965",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1295992142",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05244728033",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["25",
            
            FontWeight->
              "Bold"], "\<\"DRIFT\"\>", "\<\"DRIFT_141\"\>", "\<\"DRIFT\"\>", 
          
          StyleBox["0.3387526506",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["38.46876325",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["102.4289449",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.06738668",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.542472535",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-1.744397449\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.122647424",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1301286231",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.05323494345",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02208224532",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            
            FontWeight->
              "Bold"], "\<\"SBEND\"\>", "\<\"MB.A13L3.B1\"\>", \
"\<\"RB.A23B1\"\>", 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.005099988074",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52.76876325",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["160.3864369",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.75024048",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.89469213",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(-2.308538878\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.6477823806",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.1479222398",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.09593616886",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.02717912964",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.",
            FontColor->RGBColor[0, 0, 1]]}
        },
      ColumnAlignments->{Center, Left, Left, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[i\[LeftDoubleBracket]53, 4\[RightDoubleBracket]]\)], "Input"],

Cell["0.16", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[m\[LeftDoubleBracket]53, 4\[RightDoubleBracket]]\)], "Input"],

Cell["0.1605", "Output"]
}, Open  ]],

Cell["\<\
It is also possible to extract more information or get various \
combinations of informartion.\
\>", "Text"],

Cell[TextData[{
  "The default is to import numbers as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " numbers, as reals or integers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[ImportXLS, NumberCellMethod]\)], "Input"],

Cell[BoxData[
    \({NumberCellMethod \[Rule] 4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?NumberCellMethod\)\)], "Input"],

Cell[BoxData[
    \("NumberCellMethod is an option of ImportXLS. If set to 0: return the \
Excel formatted value as string.  If set to 1: return also the formatting \
information. If set to 2: return the number as saved by Excel internally. If \
set to 4: return the Excel formatted value directly as string (this might not \
always work, depending on the number format, however, it is rather fast in \
normal situations)."\)], "Print",
  CellTags->"Info3266768345-1784432"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>"]]]\)], "Input"],

Cell["{{7.82*^-9}}", "Output"]
}, Open  ]],

Cell[TextData[{
  "Setting the option ",
  StyleBox["NumberCellMethod", "MR"],
  "\[Rule]0 gives a string."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 0]]]\)], "Input"],

Cell["{{\"7.82*^-09\"}}", "Output"]
}, Open  ]],

Cell[TextData[{
  "Setting the option ",
  StyleBox["NumberCellMethod", "MR"],
  "\[Rule]1 gives a list of a string and the underlying number as saved by \
Excel."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 1, XLSToData \[Rule] False]]]\)], "Input"],

Cell["\<\
{{XLSCell[\"NUMBER\", \"0.00E+00\", {\"7.82*^-09\", \
7.818933301*^-9}]}}\
\>", "Output"]
}, Open  ]],

Cell[TextData[{
  "Setting the option ",
  StyleBox["NumberCellMethod", "MR"],
  "\[Rule]2 gives only the underlying number as saved by Excel."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 2, XLSToData \[Rule] False]]]\)], "Input"],

Cell["{{7.818933301*^-9}}", "Output"]
}, Open  ]],

Cell[TextData[{
  "Setting the option ",
  StyleBox["NumberCellMethod", "MR"],
  "\[Rule]3 gives only the underlying number as saved by Excel."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 3, XLSToData \[Rule] False]]]\)], "Input"],

Cell["{{XLSCell[\"NUMBER\", \"0.00E+00\", \"7.82*^-09\"]}}", "Output"]
}, Open  ]],

Cell[TextData[{
  "The default is the setting ",
  StyleBox["NumberCellMethod", "MR"],
  "\[Rule]4 which gives the number directly from the Java .xls conversion \
Program JexcelApi with the modification that scientific notation is changed \
to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"*^\" convention. This is the quickest option but for exotic number \
formats it might be advisable to use different ",
  StyleBox["NumberCellMethod", "MR"],
  " options."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 4, XLSToData \[Rule] False]]]\)], "Input"],

Cell["{{7.82*^-9}}", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b18:b18\>", 
          NumberCellMethod \[Rule] 1, XLSToData \[Rule] False, 
          XLSFormat \[Rule] True]]]\)], "Input"],

Cell["\<\
{{XLSCell[\"NUMBER\", \"0.00E+00\", {\"7.82*^-09\", \
7.818933301*^-9}, XLSColor -> \"blue\", XLSBold -> \"True\"]}}\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<b38:b38\>", 
          NumberCellMethod \[Rule] 1, XLSToData \[Rule] False, 
          XLSFormat \[Rule] True]]]\)], "Input"],

Cell["\<\
{{XLSCell[\"GENERAL\", \"\", \"LHC V6.4 Beam1 IR3 450GeV Injection \
Crossing Bumps(IP1=IP5=100% IP2=100% IP8=100%)\", XLSBackgroundColor -> \
{\"yellow\", 13}, XLSColor -> \"blue\", XLSBold -> \"True\"]}}\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ToMatrix[ImportXLS["\<LHCB1IR3.xls\>", "\<f88:f88\>", 
          NumberCellMethod \[Rule] 1, XLSToData \[Rule] False, 
          XLSFormat \[Rule] True]]]\)], "Input"],

Cell["{{XLSCell[\"NUMBER\", \"\", {\"0\", 0.}]}}", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[ImportXLS]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"BlankCellSubstitution", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$EmptyCell",
                  HoldForm]},
              {"Conversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"DateCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "1"},
              {"DateConversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "ToDateList"},
              {"DiscardEmptyColumns", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Right}\)},
              {"DiscardEmptyRows", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Bottom}\)},
              {"DiscardEmptySheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"GeneralCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "1"},
              {"GeneralToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"IncludeHiddenSheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"NormalizeWhiteSpace", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"NumberCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "4"},
              {"Path", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\(Prepend[$Path, $MathXLSDir <> "\<Examples\>"]\),
                  HoldForm]},
              {"PercentToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"Replacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({XLSCell[_, _, 
                      K_ /; MatchQ[
                          K, "\<\>" | "\< \>" | "\<  \>" | "\<   \>"], ___] \
\[RuleDelayed] $EmptyCell}\)},
              {"StringReplacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"ToList", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToMatrix", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToVector", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSFormat", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSToData", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
WindowSize->{1442, 865},
WindowMargins->{{Automatic, 0}, {Automatic, 80}},
CellLabelAutoDelete->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "LHCB1IR3.csv"->{
    Cell[2830, 96, 40822, 1136, 446, "Output",
      CellTags->"LHCB1IR3.csv"]},
  "Info3266768345-1784432"->{
    Cell[266704, 7581, 474, 7, 55, "Print",
      CellTags->"Info3266768345-1784432"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"LHCB1IR3.csv", 277234, 7889},
  {"Info3266768345-1784432", 277345, 7892}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 33, 0, 61, "Section"],
Cell[1812, 55, 54, 1, 27, "Input"],
Cell[1869, 58, 344, 9, 32, "Text"],
Cell[2216, 69, 145, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[2386, 76, 142, 3, 27, "Input"],
Cell[2531, 81, 45, 1, 27, "Output"]
}, Open  ]],
Cell[2591, 85, 162, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[2778, 93, 49, 1, 27, "Input"],
Cell[2830, 96, 40822, 1136, 446, "Output",
  CellTags->"LHCB1IR3.csv"]
}, Open  ]],
Cell[43667, 1235, 100, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[43792, 1242, 200, 5, 27, "Input"],
Cell[43995, 1249, 45, 1, 27, "Output"]
}, Open  ]],
Cell[44055, 1253, 372, 9, 50, "Text"],

Cell[CellGroupData[{
Cell[44452, 1266, 86, 1, 27, "Input"],
Cell[44541, 1269, 115657, 3225, 1979, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160235, 4499, 43, 1, 27, "Input"],
Cell[160281, 4502, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160356, 4508, 59, 1, 27, "Input"],
Cell[160418, 4511, 43, 1, 27, "Output"],
Cell[160464, 4514, 2218, 40, 27, 2054, 34, "GraphicsData", "Bitmap", "Output",
  
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[162719, 4559, 61, 1, 27, "Input"],
Cell[162783, 4562, 47269, 1387, 529, "Output"]
}, Open  ]],
Cell[210067, 5952, 53, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[210145, 5957, 61, 1, 27, "Input"],
Cell[210209, 5960, 55641, 1576, 529, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[265887, 7541, 91, 1, 27, "Input"],
Cell[265981, 7544, 22, 0, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[266040, 7549, 91, 1, 27, "Input"],
Cell[266134, 7552, 24, 0, 40, "Output"]
}, Open  ]],
Cell[266173, 7555, 118, 3, 32, "Text"],
Cell[266294, 7560, 157, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[266476, 7569, 69, 1, 27, "Input"],
Cell[266548, 7572, 62, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[266647, 7578, 54, 1, 27, "Input"],
Cell[266704, 7581, 474, 7, 55, "Print",
  CellTags->"Info3266768345-1784432"]
}, Open  ]],

Cell[CellGroupData[{
Cell[267215, 7593, 105, 2, 27, "Input"],
Cell[267323, 7597, 30, 0, 40, "Output"]
}, Open  ]],
Cell[267368, 7600, 119, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[267512, 7608, 144, 3, 27, "Input"],
Cell[267659, 7613, 35, 0, 40, "Output"]
}, Open  ]],
Cell[267709, 7616, 175, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[267909, 7625, 169, 3, 27, "Input"],
Cell[268081, 7630, 99, 3, 40, "Output"]
}, Open  ]],
Cell[268195, 7636, 155, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[268375, 7644, 169, 3, 27, "Input"],
Cell[268547, 7649, 37, 0, 40, "Output"]
}, Open  ]],
Cell[268599, 7652, 155, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[268779, 7660, 169, 3, 27, "Input"],
Cell[268951, 7665, 70, 0, 40, "Output"]
}, Open  ]],
Cell[269036, 7668, 491, 12, 50, "Text"],

Cell[CellGroupData[{
Cell[269552, 7684, 169, 3, 27, "Input"],
Cell[269724, 7689, 30, 0, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[269791, 7694, 204, 4, 27, "Input"],
Cell[269998, 7700, 142, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[270177, 7708, 204, 4, 27, "Input"],
Cell[270384, 7714, 231, 4, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[270652, 7723, 204, 4, 27, "Input"],
Cell[270859, 7729, 60, 0, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[270956, 7734, 58, 1, 27, "Input"],
Cell[271017, 7737, 5579, 132, 428, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

