(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    245203,       5052]*)
(*NotebookOutlinePosition[    246115,       5086]*)
(*  CellTagsIndexPosition[    246042,       5080]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Road accidents in the UK from 1979 to 1999", "Section"],

Cell[BoxData[
    \(\(\(Needs["\<MathXLS`\>"]\)\(;\)\(\ \ \ \)\(timingstart = 
      AbsoluteTime[]\)\(;\)\(\ \)\( (*\ 
      for\ measuring\ the\ time\ needed\ for\ this\ notebook\ *) \)\)\)], \
"Input"],

Cell[TextData[{
  "D4477.xls is located in the Examples directory. An alternative possibility \
to import the data directly from the Internet is:\n\tdata = ",
  StyleBox["ImportXLS",
    FontWeight->"Bold"],
  "[\"",
  StyleBox["http://www.statistics.gov.uk/statbase/Expodata/Spreadsheets/D4477.\
xls\"]", "MR"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(wb = ImportXLS["\<D4477.xls\>"]\)], "Input"],

Cell[BoxData[
    \(\(Workbook[
        "/home/rolf/.Mathematica/Applications/MathXLS/Examples/D4477.xls"]\)[\
\(Sheet[1, "data "]\)[{"6.17 Death rates from road accidents: by gender", 
          Null, Null}, {Null, Null, Null}, {"Great Britain", Null, 
          "Rates per 100,000 population"}, {Null, Null, Null}, {Null, "Men", 
          "Women"}, {1979, 22.9`, 7.9`}, {1980, 20.8`, 7.8`}, {1981, 20.5`, 
          7.5`}, {1982, 20.4`, 7.8`}, {1983, 18.7`, 7.`}, {1984, 19.1`, 
          7.1`}, {1985, 17.3`, 6.7`}, {1986, 17.9`, 6.9`}, {1987, 17.1`, 
          6.5`}, {1988, 16.8`, 6.3`}, {1989, 17.8`, 6.7`}, {1990, 17.1`, 
          6.6`}, {1991, 14.9`, 5.8`}, {1992, 13.7`, 5.4`}, {1993, 12.2`, 
          5.`}, {1994, 11.7`, 4.7`}, {1995, 11.6`, 4.6`}, {1996, 11.8`, 
          4.3`}, {1997, 11.8`, 4.2`}, {1998, 10.9`, 4.2`}, {1999, 11.1`, 
          3.9`}, {Null, Null, 
          Null}, {"Source: Department of the Environment, Transport and the \
Regions", Null, Null}]]\)], "Output"]
}, Open  ]],

Cell["By default, automatic type conversion is performed.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[wb]\)], "Input"],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{\"6.17 Death rates from road accidents: by gender\", \
Null, Null}, 
  {Null, Null, Null}, {\"Great Britain\", Null, \"Rates per 100,000 \
population\"}, 
  {Null, Null, Null}, {Null, \"Men\", \"Women\"}, {1979, 22.9, 7.9}, {1980, \
20.8, 7.8}, 
  {1981, 20.5, 7.5}, {1982, 20.4, 7.8}, {1983, 18.7, 7.}, {1984, 19.1, 7.1}, 
  {1985, 17.3, 6.7}, {1986, 17.9, 6.9}, {1987, 17.1, 6.5}, {1988, 16.8, 6.3}, \

  {1989, 17.8, 6.7}, {1990, 17.1, 6.6}, {1991, 14.9, 5.8}, {1992, 13.7, 5.4}, \

  {1993, 12.2, 5.}, {1994, 11.7, 4.7}, {1995, 11.6, 4.6}, {1996, 11.8, 4.3}, 
  {1997, 11.8, 4.2}, {1998, 10.9, 4.2}, {1999, 11.1, 3.9}, {Null, Null, \
Null}, 
  {\"Source: Department of the Environment, Transport and the Regions\", \
Null, Null}]]\
\>", "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExcelForm",
    FontWeight->"Bold"],
  " is a bit more fancy, displaying row and column headings in an Excel-like \
way. Cell elements converted to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " numbers are shown in blue."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[wb]; \)], "Input"],

Cell[BoxData[GridBox[{
        {"#1", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"6.17 Death rates from road accidents: by gender\"\
\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Great Britain\"\>", "\<\"\"\>", "\<\"Rates per \
100,000 population\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"Men\"\>", "\<\"Women\"\>"},
        {
          StyleBox["6",
            FontWeight->"Bold"], 
          StyleBox["1979",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            FontWeight->"Bold"], 
          StyleBox["1980",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["8",
            FontWeight->"Bold"], 
          StyleBox["1981",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            FontWeight->"Bold"], 
          StyleBox["1982",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            FontWeight->"Bold"], 
          StyleBox["1983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            FontWeight->"Bold"], 
          StyleBox["1984",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["12",
            FontWeight->"Bold"], 
          StyleBox["1985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            FontWeight->"Bold"], 
          StyleBox["1986",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            FontWeight->"Bold"], 
          StyleBox["1987",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            FontWeight->"Bold"], 
          StyleBox["1988",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            FontWeight->"Bold"], 
          StyleBox["1989",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            FontWeight->"Bold"], 
          StyleBox["1990",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            FontWeight->"Bold"], 
          StyleBox["1991",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            FontWeight->"Bold"], 
          StyleBox["1992",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            FontWeight->"Bold"], 
          StyleBox["1993",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            FontWeight->"Bold"], 
          StyleBox["1994",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["22",
            FontWeight->"Bold"], 
          StyleBox["1995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            FontWeight->"Bold"], 
          StyleBox["1996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["24",
            FontWeight->"Bold"], 
          StyleBox["1997",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["25",
            FontWeight->"Bold"], 
          StyleBox["1998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            FontWeight->"Bold"], 
          StyleBox["1999",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["28",
            
            FontWeight->
              "Bold"], "\<\"Source: Department of the Environment, Transport \
and the Regions\"\>", "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"data "]
}, Open  ]],

Cell[TextData[{
  StyleBox["SubVector",
    FontWeight->"Bold"],
  ", ",
  StyleBox["SubMatrix",
    FontWeight->"Bold"],
  " and ",
  StyleBox["SubElement",
    FontWeight->"Bold"],
  " can be used to extract sub-ranges of a matrix. ",
  StyleBox["SubVector",
    FontWeight->"Bold"],
  " returns a list, ",
  StyleBox["SubMatrix",
    FontWeight->"Bold"],
  " a matrix and ",
  StyleBox["SubElement",
    FontWeight->"Bold"],
  " an element of a matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(men = SubVector[wb, "\<b6:b26\>"]\)], "Input"],

Cell[BoxData[
    \({22.9`, 20.8`, 20.5`, 20.4`, 18.7`, 19.1`, 17.3`, 17.9`, 17.1`, 16.8`, 
      17.8`, 17.1`, 14.9`, 13.7`, 12.2`, 11.7`, 11.6`, 11.8`, 11.8`, 10.9`, 
      11.1`}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Alternatively it is also possible to just read a part of the original \
workbook into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ImportXLS["\<D4477.xls\>", "\<b6:b26\>", 
        ToVector \[Rule] True]]\)], "Input"],

Cell["\<\
{22.9, 20.8, 20.5, 20.4, 18.7, 19.1, 17.3, 17.9, 17.1, 16.8, 17.8, \
17.1, 14.9, 13.7, 
 12.2, 11.7, 11.6, 11.8, 11.8, 10.9, 11.1}\
\>", "Output"]
}, Open  ]],

Cell["\<\
Instead of the Excel range convection also normal matrix notation \
can be used, i.e., to get the vector of the first column from row 6 to 26 \
use:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[
      ImportXLS["\<D4477.xls\>", {1, {{6, 1}, {26, 1}}}, 
        ToVector \[Rule] True, Conversion \[Rule] False]]\)], "Input"],

Cell["\<\
{\"1979\", \"1980\", \"1981\", \"1982\", \"1983\", \"1984\", \"1985\
\", \"1986\", \"1987\", \"1988\", 
 \"1989\", \"1990\", \"1991\", \"1992\", \"1993\", \"1994\", \"1995\", \"1996\
\", \"1997\", \"1998\", 
 \"1999\"}\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(women = SubVector[wb, "\<c6:c26\>"]\)], "Input"],

Cell[BoxData[
    \({7.9`, 7.8`, 7.5`, 7.8`, 7.`, 7.1`, 6.7`, 6.9`, 6.5`, 6.3`, 6.7`, 6.6`, 
      5.8`, 5.4`, 5.`, 4.7`, 4.6`, 4.3`, 4.2`, 4.2`, 3.9`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[\ years = SubVector[wb, "\<a6:a26\>"]\ ]\)], "Input"],

Cell["\<\
{1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, \
1990, 1991, 1992, 
 1993, 1994, 1995, 1996, 1997, 1998, 1999}\
\>", "Output"]
}, Open  ]],

Cell["This extracts some text elements for later use.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({text1, text2, text3} = 
      SubElement[wb, "\<a1\>", "\<c3\>", "\<a3\>"]\)], "Input"],

Cell[BoxData[
    \({"6.17 Death rates from road accidents: by gender", 
      "Rates per 100,000 population", "Great Britain"}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This uses the standard ",
  StyleBox["MultipleListPlot",
    FontWeight->"Bold"],
  " unction:"
}], "Text"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000;H0000o2000`400?l0
0000o`00003oo`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0
ooooo`3ooooJ0?ooo`008`3oool500000380oooo1@00001<0?ooo`800000
9@3oool500000200oooo1000000@0?ooo`@00000<`3oool5000000<0oooo
1000000B0?ooo`@000002P3oool00`000000oooo0?ooo`0@0?ooo`@00000
0`3oool4000000D0oooo00<000000?ooo`3oool09@3oool500000200oooo
1000000U0?ooo`@000004P3oool00`000000oooo0?ooo`090?ooo`@00000
103oool2000000@0oooo100000030?ooo`@00000UP3oool002D0oooo0P00
000d0?ooo`800000C@3oool2000002P0oooo0P00000Q0?ooo`8000005@3o
ool2000003@0oooo0P0000070?ooo`8000004@3oool2000000`0oooo0P00
000C0?ooo`8000001@3oool2000000D0oooo0P00000X0?ooo`8000008@3o
ool2000002X0oooo0P00000A0?ooo`800000303oool2000000D0oooo0P00
00050?ooo`8000001@3oool2000000D0oooo00<000000?ooo`3oool0SP3o
ool001`0oooo1@0000040?ooo`8000000P3oool3000000030?ooo`000000
oooo00@0000000<0oooo0000000000000`3oool400000080oooo1P000000
0`3oool000000000000300000080oooo0`0000001@3oool0000000000000
0000oooo00P0000000<0oooo0000000000000`3oool4000003<0oooo0P00
000>0?ooo`8000000P3oool4000000050?ooo`00000000000000003oool0
2@0000020?ooo`80000000<0oooo0000000000000P0000020?ooo`D00000
103oool200000080oooo0`0000000`3oool000000?ooo`04000000030?oo
o`000000000000<0oooo100000020?ooo`H000000`3oool200000080oooo
100000020?ooo`80000000<0oooo0000000000000P0000030?ooo`800000
00<0oooo0000000000000`3oool;00000080oooo2`0000020?ooo`@00000
103oool400000080oooo1P0000030?ooo`800000103oool2000000030?oo
o`00000000000080oooo100000020?ooo`<0000000@0oooo000000000000
00000P3oool2000000D0oooo0`0000050?ooo`030000003oool0oooo00X0
oooo0`0000040?ooo`8000001@3oool2000000H0oooo00@000000?ooo`3o
ool0oooo100000030?ooo`H000000P3oool4000000@0oooo0`0000020?oo
o`D00000103oool200000080oooo0`0000000`3oool000000?ooo`040000
00030?ooo`000000000000<0oooo100000020?ooo`H000000`3oool20000
00@0oooo100000020?ooo`D000000P3oool600000080oooo2@0000001@3o
ool00000000000000000oooo0080000000@0oooo000000000000oooo1P00
00020?ooo`@000001@3oool00`000000oooo0?ooo`030?ooo`<00000103o
ool2000000D0oooo0P0000050?ooo`8000001@3oool2000000D0oooo00<0
00000?ooo`3oool0SP3oool001`0oooo00@000000?ooo`3oool0oooo0P00
00030?ooo`<000000P3oool2000000030?ooo`000000oooo00D0000000@0
oooo000000000000oooo0P0000020?ooo`8000000`3oool2000000<0oooo
00@000000?ooo`3oool0oooo0P0000020?ooo`80000000@0oooo00000000
0000oooo0P0000020?ooo`80000000D0oooo00000000000000000?ooo`02
000000030?ooo`000000000000<0oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0?ooo`0;0?ooo`8000000`3oool2000000<0oooo00@00000
0?ooo`00000000000P3oool200000080oooo0P000000103oool000000000
003oool2000000<0oooo00<000000?ooo`0000000`3oool2000000<0oooo
0`0000020?ooo`80000000<0oooo0000003oool01@000000103oool00000
0000003oool200000080oooo0P0000030?ooo`8000001@3oool2000000<0
oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool01@000000
oooo000000000000oooo00<000000P3oool2000000030?ooo`0000000000
00<0oooo0P0000030?ooo`8000000P3oool200000080oooo0P0000050?oo
o`800000103oool200000080oooo0P0000030?ooo`8000001@3oool30000
0080oooo0P0000001@3oool00000000000000000oooo008000000P3oool2
00000080oooo0P0000000`3oool00000000000030?ooo`800000103oool0
0`000000oooo0?ooo`02000000@0oooo0P00000:0?ooo`80000000<0oooo
0000000000000`3oool2000000D0oooo0P0000060?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`8000000P3oool200000080oooo0P000002
0?ooo`030000003oool0000000<0oooo0P0000030?ooo`<000000P3oool2
000000030?ooo`000000oooo00D0000000@0oooo000000000000oooo0P00
00020?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`800000103o
ool2000000H0oooo0P0000030?ooo`8000000P3oool200000080oooo0P00
0000103oool000000000003oool2000000040?ooo`0000000000000000<0
oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000050?ooo`80
00001@3oool2000000D0oooo0P0000050?ooo`800000S`3oool00200oooo
0P0000030?ooo`<000000P3oool2000000030?ooo`000000oooo00@00000
0P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
1`3oool200000080oooo0P000000103oool000000000003oool200000080
oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo00000000
0000>@3oool2000000X0oooo0P0000040?ooo`80000000D0oooo0000003o
ool000000?ooo`0200000080oooo0P0000020?ooo`@000000P3oool20000
00T0oooo0P0000030?ooo`<000000P3oool2000000030?ooo`000000oooo
00@000000P3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`8000001@3oool2000000<0oooo0P0000000`3oool00000000000020?oo
o`8000001@3oool200000080oooo0P0000020?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000020?ooo`8000000P3oool20000
00D0oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000050?oo
o`<000000P3oool200000080oooo0P0000000`3oool00000000000020?oo
o`8000000P3oool2000000030?ooo`000000000000<0oooo0P0000070?oo
o`800000403oool2000000030?ooo`000000000000<0oooo0P0000050?oo
o`8000002`3oool2000000H0oooo0P0000030?ooo`8000000P3oool20000
0080oooo0P0000080?ooo`8000000`3oool300000080oooo0P0000000`3o
ool000000?ooo`0400000080oooo0P0000000`3oool00000000000020?oo
o`8000000`3oool2000000D0oooo0P0000050?ooo`800000103oool20000
00H0oooo0P0000030?ooo`8000000P3oool200000080oooo0P000000103o
ool000000000003oool200000080oooo0P0000030?ooo`8000000`3oool2
000000d0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2
000000@0oooo0P0000050?ooo`800000UP3oool001h0oooo0`0000030?oo
o`80000000@0oooo000000000000oooo0P0000000`3oool000000?ooo`04
00000080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2
000000D0oooo0`0000030?ooo`80000000<0oooo0000000000000P3oool5
000000030?ooo`00000000000080oooo0P0000000`3oool0000000000004
000002`0oooo1@0000060?ooo`8000002@3oool2000000<0oooo0P000000
103oool000000?ooo`0000020?ooo`D000000P3oool3000000<0oooo1P00
00030?ooo`<000000`3oool2000000040?ooo`00000000000?ooo`800000
00<0oooo0000003oool0100000020?ooo`80000000<0oooo000000000000
0P3oool2000000<0oooo0P0000050?ooo`8000000`3oool500000080oooo
1P0000000`3oool00000000000020?ooo`8000000P3oool2000000030?oo
o`000000000000<0oooo0P0000040?ooo`D000000P3oool2000000D0oooo
100000020?ooo`8000000P3oool2000000<0oooo0P0000040?ooo`800000
00@0oooo000000000000oooo0P0000020?ooo`80000000<0oooo00000000
00000P3oool200000080oooo0P0000000`3oool00000000000030?ooo`80
00001`3oool200000100oooo0P0000000`3oool00000000000030?ooo`80
00001@3oool2000000/0oooo100000040?ooo`8000000`3oool200000080
oooo0P0000020?ooo`8000001P3oool3000000<0oooo0P000000103oool0
00000000003oool2000000030?ooo`000000oooo00@000000P3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`8000001@3oool20000
00D0oooo0P0000040?ooo`8000001P3oool2000000@0oooo1@0000020?oo
o`80000000@0oooo000000000000oooo0P0000020?ooo`8000000`3oool2
000000<0oooo1P0000090?ooo`80000000<0oooo0000000000000`3oool2
000000D0oooo0P0000050?ooo`8000001@3oool2000009H0oooo000M0?oo
o`<00000103oool2000000040?ooo`00000000000?ooo`80000000<0oooo
0000003oool01@000000103oool000000000003oool200000080oooo0P00
00030?ooo`800000103oool3000000@0oooo0P0000000`3oool000000000
00050?ooo`80000000D0oooo00000000000000000?ooo`02000000030?oo
o`00000000000080oooo0P00000e0?ooo`8000002`3oool2000000<0oooo
0`0000000`3oool00000000000050?ooo`8000000P3oool400000080oooo
0P0000020?ooo`8000000P3oool3000000@0oooo0P000000103oool00000
0000003oool2000000030?ooo`000000oooo00D0000000@0oooo00000000
0000oooo0P0000020?ooo`8000000`3oool2000000D0oooo0P0000030?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P000000103o
ool000000000003oool300000080oooo0P0000000`3oool0000000000003
0?ooo`8000001`3oool200000080oooo0`000000103oool000000?ooo`3o
ool2000000040?ooo`00000000000?ooo`8000000P3oool2000000<0oooo
0P0000040?ooo`80000000@0oooo000000000000oooo0P0000001@3oool0
0000000000000000oooo008000000P3oool200000080oooo0P0000000`3o
ool00000000000030?ooo`800000103oool00`000000oooo0?ooo`020000
0140oooo0`0000040?ooo`8000001@3oool2000000/0oooo0P0000000`3o
ool00000000000030?ooo`8000000`3oool200000080oooo0P0000020?oo
o`8000001@3oool3000000@0oooo0P000000103oool000000000003oool2
000000030?ooo`000000oooo00D0000000@0oooo000000000000oooo0P00
00020?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`800000103o
ool3000000030?ooo`000000oooo0080oooo0P0000070?ooo`8000000P3o
ool2000000040?ooo`00000000000?ooo`80000000@0oooo000000000000
00000`3oool2000000<0oooo0P0000020?ooo`8000002P3oool3000000@0
oooo0P0000050?ooo`8000001@3oool2000000D0oooo0P0000050?ooo`80
0000S`3oool001`0oooo0P0000050?ooo`<0000000<0oooo000000000000
1`000000103oool000000000003oool2000000<0oooo100000040?ooo`80
00000`3oool2000000H0oooo100000030?ooo`@0000000D0oooo00000000
000000000?ooo`02000000<0oooo1000000e0?ooo`030000003oool0oooo
00/0oooo0P0000030?ooo`<0000000<0oooo0000000000000P3oool40000
00<0oooo0P0000000`3oool00000000000020?ooo`@000000P3oool20000
00D0oooo0`0000000`3oool0000000000007000000040?ooo`0000000000
0?ooo`8000000`3oool4000000@0oooo0P0000050?ooo`8000000`3oool2
00000080oooo0P0000020?ooo`@000000`3oool2000000030?ooo`000000
000000@0000000<0oooo0000000000000`3oool2000000@0oooo10000002
0?ooo`<0000000<0oooo0000000000000P3oool2000000030?ooo`000000
00000080oooo100000040?ooo`8000000`3oool3000000050?ooo`000000
00000000003oool00P0000001@3oool00000000000000000oooo00@00000
0P3oool5000000@0oooo0P0000040?ooo`@000004@3oool2000000030?oo
o`000000000000<0oooo0P0000050?ooo`8000002`3oool2000000030?oo
o`000000000000<0oooo0P0000040?ooo`@000000P3oool500000080oooo
0P0000050?ooo`<0000000<0oooo0000000000001`000000103oool00000
0000003oool2000000<0oooo100000040?ooo`8000001@3oool2000000<0
oooo00L000000?ooo`00000000000?ooo`000000oooo00<0000000@0oooo
000000000000oooo100000040?ooo`@000000P3oool5000000<0oooo0P00
0000103oool000000000000000020?ooo`800000103oool4000000X0oooo
0P0000000`3oool00000000000030?ooo`8000001@3oool2000000D0oooo
0P0000050?ooo`8000001@3oool2000008l0oooo000L0?ooo`8000000`3o
ool00`000000oooo0?ooo`0=0?ooo`8000003P3oool2000000<0oooo0P00
00030?ooo`030000003oool0oooo00800000BP3oool2000000h0oooo0P00
00030?ooo`<0000000<0oooo0000000000002@3oool2000000/0oooo0P00
00030?ooo`030000003oool0oooo00d0oooo0P00000>0?ooo`8000001@3o
ool2000000<0oooo0P0000020?ooo`800000603oool200000180oooo0P00
00000`3oool000000000000:0?ooo`8000008@3oool2000000@0oooo0P00
000C0?ooo`80000000<0oooo0000000000000`3oool2000000D0oooo0P00
000;0?ooo`80000000<0oooo0000000000000`3oool2000000/0oooo0P00
00040?ooo`8000000`3oool00`000000oooo0?ooo`0=0?ooo`8000003P3o
ool2000000D0oooo0P0000030?ooo`060000003oool000000000003oool0
00009P3oool200000180oooo0P0000000`3oool00000000000030?ooo`80
00001@3oool2000000D0oooo0P0000050?ooo`800000UP3oool001d0oooo
1@00000>0?ooo`<00000303oool4000000@0oooo1@000000103oool00000
00000000001K0?ooo`80000000@0oooo00000000000000000`3oool20000
00L0oooo0`00000<0?ooo`D000003P3oool3000000`0oooo100000050?oo
o`X000005`3oool400000140oooo1@0000090?ooo`@000008@3oool40000
0080oooo1@00000A0?ooo`<000000P3oool4000000<0oooo1000000:0?oo
o`D000000P3oool4000000/0oooo0P0000050?ooo`D000003P3oool30000
00`0oooo100000050?ooo`@0000000<0oooo0000000000001000000:0?oo
o`800000603oool4000001<0oooo0`0000020?ooo`@00000103oool20000
00@0oooo100000030?ooo`@00000UP3oool00?l0ooooo`3ooooJ0?ooo`00
o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ
0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0oooo
o`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003=0?ooo`030000003oool0
oooo0?l0ooooo`3oool:0?ooo`00c@3oool200000?l0ooooo`3oool;0?oo
o`006`3oool400000080oooo0P0000000`3oool0000000000002000000@0
oooo0`0000030?ooo`H000000P3oool3000000<0oooo100000000`3oool0
00000000000500000080oooo200000000`3oool00000000000030?ooo`@0
00000P3oool600000380oooo0P00000;0?ooo`D00000103oool<00000003
0?ooo`000000000000<000000`3oool4000000D0oooo00<000000?ooo`3o
ool0o`3ooooo0?ooo`T0oooo000L0?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000020?ooo`8000000P3oool010000000oooo
0000000000020?ooo`8000000P3oool200000080oooo00@000000?ooo`00
000000000`3oool010000000oooo0000000000030?ooo`040000003oool0
000000000080oooo0P0000001@3oool00000000000000000oooo00800000
00<0oooo0000000000000`3oool010000000oooo0?ooo`3oool2000003H0
oooo00<000000?ooo`3oool02@3oool2000000D0oooo0P0000020?ooo`80
00000`3oool2000000<0oooo0P0000020?ooo`80000000<0oooo00000000
00000`3oool00`000000oooo0?ooo`020?ooo`800000o`3ooooo0?ooo`X0
oooo000L0?ooo`80000000<0oooo0000000000000P3oool200000080oooo
0P0000020?ooo`800000103oool200000080oooo0P0000020?ooo`800000
103oool2000000D0oooo0P0000030?ooo`040000003oool0000000000080
oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo00000000
00001`3oool2000003L0oooo0P0000090?ooo`8000001@3oool200000080
oooo0P0000030?ooo`8000001@3oool4000000030?ooo`00000000000?l0
ooooo`3ooolD0?ooo`00703oool500000080oooo0P0000020?ooo`800000
0P3oool2000000D0oooo1@0000020?ooo`800000103oool6000000030?oo
o`000000000000H0oooo1@0000000`3oool00000000000020?ooo`800000
00<0oooo000000000000100000030?ooo`800000;P3oool5000000H0oooo
0P0000070?ooo`80000000<0oooo0000003oool00`3oool5000000<0oooo
0P0000030?ooo`@000000`3oool600000?l0ooooo`3oool@0?ooo`00703o
ool200000080oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000P0oooo0P0000020?ooo`800000103oool200000080oooo0P00
00000`3oool00000000000090?ooo`80000000D0oooo0000000000000000
0?ooo`02000000030?ooo`00000000000080oooo0P0000030?ooo`800000
=`3oool2000000T0oooo100000070?ooo`8000000`3oool2000000<0oooo
0P0000020?ooo`80000000<0oooo0000000000000P3oool200000?l0oooo
o`3oool@0?ooo`00703oool200000080oooo0P0000020?ooo`@000000P3o
ool5000000<0oooo100000020?ooo`D000000`3oool400000080oooo0P00
00060?ooo`@000000P3oool2000000030?ooo`000000000000<0oooo1000
00040?ooo`800000=P3oool00`000000oooo0?ooo`090?ooo`80000000@0
oooo0000003oool000000P3oool4000000@0oooo0P0000040?ooo`D00000
0P3oool400000?l0ooooo`3ooolA0?ooo`00703oool200000080oooo0P00
00090?ooo`800000303oool2000000/0oooo0P00000<0?ooo`8000003P3o
ool2000003@0oooo0P00000<0?ooo`8000000`3oool00`000000oooo0?oo
o`080?ooo`800000o`3ooooo0?ooob00oooo000K0?ooo`H000002P3oool2
000000`0oooo0P00000:0?ooo`@000002P3oool3000000`0oooo10000011
0?ooo`L00000203oool400000?l0ooooo`3ooolP0?ooo`00o`3ooooo0?oo
omX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3o
oooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?oo
o`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00;H0oooo1@00
000^0?ooo`@00000E`3oool00`000000oooo0?ooo`180?ooo`@000001@3o
ool00`000000oooo0?ooo`3o0?oooch0oooo002h0?ooo`800000;`3oool2
000004H0oooo0P00000A0?ooo`800000B`3oool2000000D0oooo0P00003o
0?ooocl0oooo000L0?ooo`@000000`3oool600000080oooo100000040?oo
o`<0000000<0oooo0000000000001@0000020?ooo`P0000000<0oooo0000
000000000`3oool400000080oooo1P0000100?ooo`800000303oool50000
00@0oooo0`0000040?ooo`8000000`3oool600000080oooo100000000`3o
ool0000000000003000000@0oooo100000020?ooo`D0000000L0oooo0000
0000000000000?ooo`000000oooo00<0000000<0oooo0000000000001@3o
ool305EEE@<0oooo101EEED20?ooo`<0EEEE00@0oooo05EEE@1EEED0EEEE
0P3oool305EEE@@0oooo0`1EEED>0?ooo`@00000403oool2000000050?oo
o`00000000000000003oool00`00000:0?ooo`030000003oool0oooo00P0
oooo1@0000040?ooo`L0000000<0oooo000000000000103oool300000080
oooo1P0000030?ooo`<000000P3oool600000080oooo1000000;0?ooo`80
00001P3oool00`000000oooo0?ooo`3o0?ooocd0oooo000M0?ooo`800000
1P3oool2000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo
00@000000?ooo`00000000000`3oool010000000oooo0000000000020?oo
o`80000000D0oooo00000000000000000?ooo`02000000030?ooo`000000
000000<0oooo00@000000?ooo`3oool0oooo0P0000140?ooo`030000003o
ool0oooo00T0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`800000
0P3oool010000000oooo0?ooo`3oool3000000@0oooo0P0000030?ooo`80
00000`3oool010000000oooo0000000000050?ooo`8000000P3oool20000
0080oooo0P0000040?ooo`80000000<0oooo0000003oool00P0000020?oo
o`800000103oool205EEE@80oooo00@0EEEE0?ooo`1EEED0EEEE0`3oool0
0`1EEED0oooo0?ooo`0205EEE@030?ooo`1EEED0EEEE0080oooo0P1EEED2
0?ooo`0405EEE@3oool0oooo05EEE@80oooo0P1EEED<0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0303oool2000000<0oooo0P00
00000`3oool000000000000;0?ooo`8000002@3oool010000000oooo0?oo
o`3oool200000080oooo0P000000103oool000000000003oool300000003
0?ooo`00000000000080oooo0P0000020?ooo`040000003oool0oooo0?oo
o`800000103oool200000080oooo00@000000?ooo`3oool0oooo0P000003
0?ooo`8000000`3oool00`000000oooo0?ooo`080?ooo`8000001P3oool2
00000?l0oooo?P3oool001d0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000020?ooo`800000103oool2000000<0oooo00@000000?oo
o`00000000000P3oool2000000030?ooo`00000000000080oooo0P000000
0`3oool00000000000070?ooo`800000A@3oool2000000d0oooo0P000002
0?ooo`8000001P3oool3000000@0oooo0P0000030?ooo`8000001@3oool2
000000D0oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P000000
0`3oool000000?ooo`0200000080oooo0P0000040?ooo`80EEEE103oool2
05EEE@L0oooo0`1EEED30?ooo`80EEEE203oool205EEE@X0oooo0P000006
0?ooo`800000303oool2000000<0oooo0P0000000`3oool000000000000J
0?ooo`8000000P3oool2000000040?ooo`00000000000?ooo`8000000P3o
ool200000080oooo0P0000060?ooo`800000103oool2000000H0oooo0P00
00030?ooo`8000003P3oool200000?l0ooooAP3oool001d0oooo10000004
0?ooo`8000000`3oool200000080oooo0P0000020?ooo`800000103oool2
000000H0oooo1@0000000`3oool00000000000020?ooo`80000000<0oooo
000000000000100000030?ooo`800000?03oool5000000H0oooo0P000009
0?ooo`<000000`3oool2000000D0oooo0P0000000`3oool0000000000003
0?ooo`8000000`3oool6000000050?ooo`00000000000?ooo`0000000`3o
ool200000080oooo0P0000020?ooo`800000103oool2000000030?ooo`00
0000oooo008000000P3oool2000000@0oooo0P1EEED40?ooo`H0EEEE0`3o
ool305EEE@<0oooo0P1EEED80?ooo`80EEEE203oool2000000X0oooo0P00
00090?ooo`<000000`3oool2000000030?ooo`000000000001P0oooo0`00
00030?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`800000
0P3oool2000000H0oooo0P0000040?ooo`8000001P3oool2000000<0oooo
1P00000:0?ooo`800000o`3ooom60?ooo`007@3oool2000000030?ooo`00
0000000000<0oooo0P0000030?ooo`8000000P3oool200000080oooo0P00
00040?ooo`8000002@3oool2000000050?ooo`00000000000000003oool0
0P0000000`3oool00000000000020?ooo`8000000`3oool2000004D0oooo
0P00000:0?ooo`<00000103oool2000000D0oooo0P0000000`3oool00000
000000030?ooo`8000000`3oool200000080oooo0P0000000`3oool00000
00000002000000<0oooo0P0000020?ooo`8000000P3oool3000000030?oo
o`000000oooo0080000000<0oooo0000003oool00P0000020?ooo`800000
103oool205EEE@@0oooo0P1EEED20?ooo`80EEEE0P3oool205EEE@030?oo
o`1EEED0EEEE0080oooo0P1EEED60?ooo`<0EEEE2`3oool2000000H0oooo
0P0000030?ooo`030000003oool0000000D0oooo0P0000040?ooo`800000
00<0oooo0000000000000P3oool00`000000oooo0000000;0?ooo`030000
003oool0000000@0oooo0`0000040?ooo`80000000@0oooo000000000000
oooo0`0000000`3oool00000000000020?ooo`8000001P3oool2000000@0
oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000020?ooo`03
0000003oool0000000D0oooo0P00003o0?ooodH0oooo000M0?ooo`800000
00<0oooo0000000000000`3oool2000000@0oooo100000020?ooo`D00000
0P3oool2000000H0oooo100000020?ooo`80000000<0oooo000000000000
0`3oool4000000@0oooo0P0000140?ooo`030000003oool0oooo00T0oooo
0P0000050?ooo`D000000P3oool3000000040?ooo`000000000000000080
oooo0P0000040?ooo`@000000P3oool2000000040?ooo`000000oooo0000
0080oooo100000020?ooo`<0000000<0oooo0000000000001`0000030?oo
o`8000000`3oool505EEE@<0oooo101EEED20?ooo`<0EEEE00<0oooo05EE
E@1EEED01P1EEED60?ooo`80EEEE303oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool20000
00<0oooo1@0000030?ooo`030000003oool0000000/0oooo00<000000?oo
o`0000000`3oool2000000D0oooo0`000000103oool000000000003oool2
000000030?ooo`00000000000080oooo1@0000020?ooo`@000000`3oool5
000000@0oooo0P0000040?ooo`@000000`3oool00`000000oooo00000005
0?ooo`800000o`3ooom60?ooo`007@3oool2000000030?ooo`0000000000
00<0oooo0P00000;0?ooo`800000103oool2000000`0oooo0P00000>0?oo
o`800000@P3oool2000000`0oooo0P0000030?ooo`030000003oool0oooo
008000003@3oool2000000X0oooo0P0000030?ooo`030000003oool0oooo
01H0oooo0P0000040?ooo`80EEEE4`3oool205EEE@D0oooo00<0EEEE0?oo
o`3oool00P1EEED=0?ooo`@000001P3oool00`000000oooo000000040?oo
o`800000303oool00`000000oooo0000000;0?ooo`030000003oool00000
00<0oooo0P0000030?ooo`030000003oool0oooo00H0oooo0P0000060?oo
o`800000303oool2000000H0oooo0P00000;0?ooo`030000003oool00000
00D0oooo0P00003o0?ooodH0oooo000L0?ooo`D000000P3oool4000000/0
oooo0P0000030?ooo`@000002P3oool3000000`0oooo1000001A0?ooo`D0
00000P3oool2000000/0oooo100000090?ooo`L00000603oool400000080
oooo0P1EEEDC0?ooo`80EEEE1P3oool305EEEAP0oooo00<000000?ooo`00
0000103oool2000000`0oooo00<000000?ooo`0000002`3oool00`000000
oooo000000040?ooo`D000001`3oool3000000H0oooo0P0000060?ooo`80
0000103oool2000000@0oooo1000000;0?ooo`030000003oool0000000<0
oooo1000003o0?ooodH0oooo003o0?ooool0oooofP3oool00?l0ooooo`3o
oooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0
ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3o
ool00?l0ooooo`3ooooJ0?ooo`00AP3oool500000600oooo0P0000050?oo
o`800000@`3oool4000001d0oooo100000050?ooo`030000003oool0oooo
03`0oooo1000000:0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02@3oool4000000@0oooo0P0000060?ooo`030000003oool0oooo
00D0oooo0P00001:0?ooo`@000007@3oool4000000D0oooo00<000000?oo
o`3oool0?03oool4000000X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`090?ooo`@00000103oool2000000D0oooo0P0000060?oo
o`030000003oool0oooo0440oooo00180?ooo`800000H03oool2000000D0
oooo0P0000140?ooo`8000008@3oool2000000D0oooo0P00000m0?ooo`80
0000303oool2000000`0oooo0P00000<0?ooo`8000001@3oool2000000D0
oooo0P0000050?ooo`800000B`3oool200000240oooo0P0000050?ooo`80
0000?@3oool2000000`0oooo0P00000<0?ooo`800000303oool2000000D0
oooo0P0000050?ooo`8000001@3oool200000480oooo000L0?ooo`@00000
0`3oool600000080oooo100000040?ooo`<000000P3oool5000000@0oooo
0`0000040?ooo`8000000`3oool600000080oooo100000110?ooo`800000
3P3oool2000000D0oooo0P0000040?ooo`@000000P3oool3000000030?oo
o`000000000000L000000P3oool400000080oooo0`0000020?ooo`D00000
00D0oooo00000000000000000?ooo`0400000080oooo1@0000020?ooo`D0
0000103oool2000000D0oooo0P0000050?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`8000001P3oool00`000000oooo0?ooo`0400000080
oooo0P0000000`3oool0000000000002000000030?ooo`000000000000@0
0000103oool3000000<0oooo100000020?ooo`H000000P3oool400000080
oooo1@0000040?ooo`800000103oool6000000<0oooo00<000000?ooo`3o
ool00`3oool3000000D0oooo00<000000?ooo`3oool00`3oool3000000@0
oooo0P0000050?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`80
00002`3oool400000080oooo0`0000000`3oool000000000000700000080
oooo100000020?ooo`<000000P3oool5000000050?ooo`00000000000000
003oool0100000020?ooo`D000000P3oool5000000@0oooo0P0000050?oo
o`8000001@3oool3000000@0oooo0`0000040?ooo`<00000103oool20000
00H0oooo00<000000?ooo`3oool0100000020?ooo`80000000<0oooo0000
000000000P0000000`3oool0000000000004000000@0oooo0`0000030?oo
o`@000000P3oool600000080oooo100000020?ooo`D00000103oool20000
00D0oooo0`0000050?ooo`030000003oool0oooo0080oooo1P0000030?oo
o`030000003oool0oooo00<0oooo0`0000040?ooo`8000001@3oool20000
00D0oooo0P0000060?ooo`030000003oool0oooo0400oooo000M0?ooo`80
00001P3oool2000000<0oooo0P0000020?ooo`8000000P3oool200000080
oooo00<000000?ooo`0000000`3oool200000080oooo0P0000020?ooo`04
0000003oool0oooo0?ooo`<00000103oool2000000<0oooo0P0000030?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool02`3oool20000
00D0oooo0P0000050?ooo`800000103oool2000000030?ooo`0000000000
00<0oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`020000
00030?ooo`00000000000080oooo0P000000103oool000000000003oool2
000000<0oooo00@000000?ooo`00000000000P3oool2000000030?ooo`00
000000000080oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P00
00000`3oool00000000000020?ooo`80000000<0oooo0000000000000P3o
ool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000P3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`80000000<0
oooo0000000000000P3oool200000080oooo0P0000020?ooo`040000003o
ool0000000000080oooo0P0000030?ooo`8000000`3oool200000080oooo
0P0000020?ooo`8000001P3oool2000000H0oooo0P0000050?ooo`800000
0`3oool2000000030?ooo`000000000000@0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000D0oooo0P0000060?ooo`800000
103oool2000000`0oooo0P0000040?ooo`80000000<0oooo000000000000
0`3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00800000
00<0oooo0000000000000P3oool2000000040?ooo`00000000000?ooo`80
00000`3oool010000000oooo0000000000020?ooo`80000000<0oooo0000
000000000P3oool2000000<0oooo0P0000050?ooo`800000103oool20000
00030?ooo`00000000000080oooo0P0000000`3oool00000000000020?oo
o`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000000`3o
ool00000000000020?ooo`8000000P3oool200000080oooo00@000000?oo
o`00000000000P3oool2000000<0oooo0P0000030?ooo`8000000P3oool2
00000080oooo0P0000060?ooo`800000103oool2000000030?ooo`000000
000000@0oooo0P0000050?ooo`8000001@3oool2000000<0oooo0P000000
0`3oool00000000000030?ooo`8000001@3oool2000000D0oooo0P000006
0?ooo`800000@@3oool001d0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000020?ooo`800000203oool200000080oooo0P0000060?oo
o`<00000103oool2000000<0oooo0P0000170?ooo`8000002P3oool20000
00D0oooo0P0000060?ooo`800000103oool2000000030?ooo`0000000000
00<0oooo0P0000030?ooo`8000001P3oool4000000<0oooo0P000000103o
ool000000000003oool2000000L0oooo100000030?ooo`@000000`3oool2
000000/0oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo
0000000000000P3oool2000000030?ooo`000000000000<0oooo0P00000:
0?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P000000
0`3oool00000000000020?ooo`80000000<0oooo0000000000001@3oool2
00000080oooo0P0000030?ooo`8000000`3oool200000080oooo0P000002
0?ooo`8000001P3oool2000000H0oooo0P00000:0?ooo`80000000<0oooo
0000000000002@3oool2000000030?ooo`000000000000<0oooo0P000006
0?ooo`8000002P3oool2000000d0oooo0P0000040?ooo`80000000<0oooo
0000000000000`3oool2000000<0oooo0P0000060?ooo`@000000`3oool2
000000040?ooo`00000000000?ooo`8000001`3oool4000000<0oooo1000
00030?ooo`8000002`3oool2000000030?ooo`00000000000080oooo0P00
00000`3oool00000000000020?ooo`80000000<0oooo0000000000000`3o
ool2000000X0oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000030?ooo`00000000000080oooo0P0000000`3oool000000000
00050?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`8000000P3o
ool200000080oooo0P0000060?ooo`800000103oool2000000030?ooo`00
0000000000/0oooo0P00000:0?ooo`80000000<0oooo0000000000000`3o
ool2000000H0oooo0P0000050?ooo`800000B03oool001d0oooo10000004
0?ooo`8000000`3oool200000080oooo0P0000020?ooo`8000001P3oool3
000000<0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2
000000<0oooo1P00000j0?ooo`D000001P3oool2000000T0oooo0P000005
0?ooo`8000001@3oool2000000@0oooo0P0000000`3oool0000000000003
0?ooo`8000000`3oool2000000H0oooo0`0000040?ooo`80000000@0oooo
000000000000oooo1P0000000`3oool0000000000002000000<0oooo1000
00050?ooo`8000002`3oool2000000030?ooo`00000000000080oooo0P00
00000`3oool00000000000020?ooo`80000000<0oooo0000000000000`3o
ool2000000X0oooo1@0000020?ooo`80000000<0oooo0000000000001000
00020?ooo`80000000<0oooo0000000000001@3oool200000080oooo0P00
00030?ooo`8000000`3oool200000080oooo0P0000020?ooo`8000001P3o
ool2000000H0oooo0P00000:0?ooo`80000000<0oooo0000000000002@3o
ool2000000030?ooo`000000000000<0oooo0P0000050?ooo`800000303o
ool2000000`0oooo0P0000040?ooo`80000000<0oooo0000000000000`3o
ool2000000<0oooo0P0000060?ooo`<00000103oool2000000040?ooo`00
000000000?ooo`H0000000<0oooo0000000000000P0000030?ooo`@00000
1@3oool2000000/0oooo0P0000000`3oool00000000000020?ooo`800000
00<0oooo0000000000000P3oool2000000030?ooo`000000000000<0oooo
0P00000:0?ooo`D000000P3oool2000000030?ooo`000000000000@00000
0P3oool2000000030?ooo`000000000000D0oooo0P0000020?ooo`800000
0`3oool2000000<0oooo0P0000020?ooo`8000000P3oool2000000H0oooo
0P0000040?ooo`80000000<0oooo0000000000002`3oool2000000X0oooo
0P0000000`3oool00000000000030?ooo`8000001@3oool2000000D0oooo
0P0000190?ooo`007@3oool2000000030?ooo`000000000000<0oooo0P00
00030?ooo`8000000P3oool200000080oooo0P0000050?ooo`<00000103o
ool2000000D0oooo0P0000000`3oool00000000000030?ooo`8000000`3o
ool200000080oooo0P0000130?ooo`8000002`3oool2000000D0oooo0P00
00050?ooo`800000103oool2000000030?ooo`000000000000<0oooo0P00
00030?ooo`8000000`3oool00`000000oooo0?ooo`04000000<0oooo0P00
0000103oool000000000003oool200000080oooo0P0000000`3oool00000
000000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo
0P00000;0?ooo`80000000<0oooo0000000000000P3oool2000000030?oo
o`000000000000<0oooo0`0000040?ooo`8000002P3oool200000080oooo
0P0000000`3oool00000000000050?ooo`D000000P3oool2000000D0oooo
0P0000020?ooo`8000000`3oool2000000<0oooo0P0000020?ooo`800000
0P3oool3000000030?ooo`000000oooo0080oooo0P0000060?ooo`800000
2P3oool2000000030?ooo`000000000000T0oooo0P0000000`3oool00000
000000030?ooo`8000001@3oool2000000`0oooo0P00000<0?ooo`800000
103oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`800000
0`3oool00`000000oooo0?ooo`04000000<0oooo0P000000103oool00000
0000003oool200000080oooo0P0000000`3oool00000000000020?ooo`80
000000<0oooo0000000000000P3oool2000000<0oooo0P00000;0?ooo`80
000000<0oooo0000000000000P3oool2000000030?ooo`000000000000<0
oooo0`0000040?ooo`8000002P3oool200000080oooo0P0000000`3oool0
0000000000050?ooo`D000000P3oool2000000D0oooo0P0000020?ooo`80
00000`3oool2000000<0oooo0P0000020?ooo`8000000P3oool300000003
0?ooo`000000oooo0080oooo0P0000040?ooo`80000000<0oooo00000000
00002`3oool2000000X0oooo0P0000000`3oool00000000000030?ooo`80
00001@3oool2000000D0oooo0P0000190?ooo`007@3oool2000000030?oo
o`000000000000<0oooo0P0000040?ooo`@000000P3oool500000080oooo
0P0000050?ooo`D000000P3oool3000000040?ooo`000000000000000080
oooo0P0000040?ooo`@00000@`3oool00`000000oooo0?ooo`0;0?ooo`80
00001@3oool2000000<0oooo00H000000?ooo`00000000000?ooo`000002
0?ooo`@000000P3oool4000000@0oooo1@0000020?ooo`80000000@0oooo
000000000000oooo1@0000030?ooo`@000000`3oool500000080oooo1@00
00030?ooo`8000002`3oool2000000030?ooo`00000000000080oooo0P00
00000`3oool00000000000020?ooo`80000000<0oooo0000000000000`3o
ool2000000X0oooo0P0000020?ooo`80000000<0oooo0000000000001@3o
ool200000080oooo0P0000000`3oool00000000000030?ooo`030000003o
ool0oooo00@00000103oool2000000@0oooo100000020?ooo`<0000000<0
oooo0000000000000`3oool2000000H0oooo0P00000:0?ooo`80000000<0
oooo0000000000002@3oool2000000030?ooo`000000000000<0oooo0P00
00050?ooo`800000303oool2000000X0oooo00H000000?ooo`0000000000
0?ooo`0000020?ooo`@000000P3oool4000000@0oooo1@0000020?ooo`80
000000@0oooo000000000000oooo1@0000030?ooo`@000000`3oool50000
0080oooo1@0000030?ooo`8000002`3oool2000000030?ooo`0000000000
0080oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000
000000000`3oool2000000X0oooo0P0000020?ooo`80000000<0oooo0000
000000001@3oool200000080oooo0P0000000`3oool00000000000030?oo
o`030000003oool0oooo00@00000103oool2000000@0oooo100000020?oo
o`<0000000<0oooo0000000000000`3oool2000000@0oooo0P0000000`3o
ool000000000000;0?ooo`8000002P3oool2000000030?ooo`0000000000
00<0oooo0P0000050?ooo`8000001@3oool2000004T0oooo000M0?ooo`80
000000<0oooo0000000000000`3oool2000000/0oooo0P0000040?ooo`80
00000`3oool00`000000oooo0?ooo`02000000d0oooo0P0000190?ooo`80
00003P3oool2000000D0oooo0P0000030?ooo`060000003oool000000000
003oool000000P3oool2000001<0oooo0P00000R0?ooo`8000002`3oool2
000000030?ooo`00000000000080oooo0P0000000`3oool0000000000002
0?ooo`80000000<0oooo0000000000000`3oool2000000X0oooo0P000002
0?ooo`80000000<0oooo0000000000000`3oool010000000oooo00000000
00020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool0203o
ool2000001<0oooo0P0000040?ooo`@000002P3oool2000000030?ooo`00
0000000000T0oooo0P0000000`3oool00000000000030?ooo`8000001@3o
ool2000000`0oooo0P00000:0?ooo`060000003oool000000000003oool0
00000P3oool2000001<0oooo0P00000R0?ooo`8000002`3oool200000003
0?ooo`00000000000080oooo0P0000000`3oool00000000000020?ooo`80
000000<0oooo0000000000000`3oool2000000X0oooo0P0000020?ooo`80
000000<0oooo0000000000000`3oool010000000oooo0000000000020?oo
o`8000000P3oool200000080oooo00<000000?ooo`3oool0203oool20000
01<0oooo0P0000040?ooo`80000000<0oooo0000000000002@3oool40000
00X0oooo0P0000000`3oool00000000000030?ooo`8000001@3oool20000
00D0oooo0P0000190?ooo`00703oool500000080oooo1000000;0?ooo`80
00001@3oool500000080oooo0P00000;0?ooo`@00000FP3oool2000000D0
oooo0P0000020?ooo`H0000000@0oooo00000000000000001P3oool20000
00X0oooo0`00000R0?ooo`@000002P3oool3000000@0oooo0`0000040?oo
o`<000000P3oool4000000T0oooo1P0000030?ooo`/00000103oool40000
00P0oooo1000000C0?ooo`@00000103oool2000000/0oooo0`00000;0?oo
o`<000000P3oool4000000@0oooo0P00000>0?ooo`8000002@3oool60000
00040?ooo`0000000000000000H0oooo0P00000:0?ooo`<000008P3oool4
000000X0oooo0`0000040?ooo`<00000103oool300000080oooo10000009
0?ooo`H000000`3oool;000000@0oooo100000080?ooo`@000004`3oool4
000000<0oooo0`00000<0?ooo`8000002`3oool300000080oooo10000004
0?ooo`8000001@3oool2000004X0oooo003o0?ooool0oooofP3oool00?l0
ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3o
ool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0
oooofP3oool00?l0ooooo`3ooooJ0?ooo`00aP3oool00`000000oooo0?oo
o`3o0?ooool0oooo4@3oool00<H0oooo0P00003o0?ooool0oooo4P3oool0
01`0oooo100000030?ooo`H000000P3oool4000000@0oooo0`0000020?oo
o`D000000`3oool400000080oooo1P0000001@3oool00000000000000000
oooo00<0000000<0oooo0000000000000P0000030?ooo`80000000@0oooo
0000000000000000>03oool2000000d0oooo100000020?ooo`D00000103o
ool5000000030?ooo`0000000000008000001@3oool00`000000oooo0?oo
o`3o0?ooool0oooo403oool001d0oooo0P0000060?ooo`8000000`3oool2
00000080oooo0P0000020?ooo`8000000P3oool010000000oooo00000000
00020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P00
00040?ooo`80000000@0oooo000000000000oooo0P0000030?ooo`050000
003oool000000000003oool00`00000k0?ooo`030000003oool0oooo00/0
oooo0P0000040?ooo`8000001@3oool2000000040?ooo`00000000000?oo
o`8000000`3oool00`000000oooo0?ooo`020?ooo`800000o`3ooooo0?oo
oa40oooo000M0?ooo`8000001P3oool2000000<0oooo0P0000020?ooo`80
00000P3oool2000000@0oooo0P0000020?ooo`80000000<0oooo00000000
00000P3oool2000000<0oooo0P0000040?ooo`80000000@0oooo00000000
0000oooo0P0000050?ooo`8000000P3oool2000003`0oooo0P00000;0?oo
o`800000103oool2000000D0oooo0P000000103oool000000000003oool2
00000?l0ooooo`3ooolK0?ooo`007@3oool4000000@0oooo0P0000030?oo
o`8000000P3oool200000080oooo0P0000040?ooo`8000000P3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`800000103oool20000
00040?ooo`00000000000?ooo`H0000000<0oooo0000000000000P3oool2
000003<0oooo1@0000060?ooo`8000002@3oool2000000@0oooo0P000005
0?ooo`80000000@0oooo000000000000oooo1P00003o0?ooool0oooo5`3o
ool001d0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2
00000080oooo0P0000020?ooo`800000203oool2000000030?ooo`000000
00000080oooo0P0000030?ooo`800000103oool2000000040?ooo`000000
00000?ooo`8000000P3oool2000000040?ooo`00000000000?ooo`<00000
?03oool2000000/0oooo0P0000040?ooo`<0000000@0oooo0000003oool0
oooo0P000000103oool000000000003oool200000080oooo0P00003o0?oo
ool0oooo5`3oool001d0oooo0P0000000`3oool00000000000030?ooo`80
0000103oool400000080oooo1@0000060?ooo`8000000P3oool400000080
oooo100000030?ooo`D000000`3oool4000000<0oooo0P0000000`3oool0
00000000000k0?ooo`030000003oool0oooo00T0oooo00L000000?ooo`00
000000000?ooo`000000oooo00<0000000@0oooo000000000000oooo0`00
00000`3oool00000000000020?ooo`@00000o`3ooooo0?oooaP0oooo000M
0?ooo`80000000<0oooo0000000000000`3oool2000000/0oooo0P000008
0?ooo`8000008@3oool2000003T0oooo0P00000<0?ooo`060000003oool0
00000000003oool00000o`3ooooo0?ooob`0oooo000L0?ooo`D000000P3o
ool4000000/0oooo0P0000060?ooo`D000002@3oool2000001@0oooo0`00
00170?ooo`H00000o`3ooooo0?ooob`0oooo003o0?ooool0oooofP3oool0
0?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooo
fP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?oo
ool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00A`3oool400000600oooo
0P00000W0?ooo`030000003oool0oooo03/0oooo0P0000060?ooo`030000
003oool0oooo0?l0oooo_03oool004X0oooo0P00001N0?ooo`800000:03o
ool2000003d0oooo0P0000050?ooo`800000o`3ooonm0?ooo`00703oool4
000000<0oooo1P0000020?ooo`@00000103oool3000000030?ooo`000000
000000D000000P3oool4000000<0oooo0P0000000`3oool0000000000002
0?ooo`@000000P3oool3000000050?ooo`00000000000000003oool00P00
0000103oool0000000000000000h0?ooo`8000003P3oool2000000T0oooo
100000001@3oool00000000000000000oooo00@000000P3oool300000004
0?ooo`0000000000000000X0oooo00<000000?ooo`3oool0403oool20000
00030?ooo`00000000000080oooo100000001`3oool00000000000000000
oooo0000003oool01`0000020?ooo`<0000000@0oooo0000000000000000
2@3oool2000000H0oooo00<000000?ooo`3oool0o`3ooonk0?ooo`007@3o
ool2000000H0oooo0P0000030?ooo`8000000P3oool200000080oooo0P00
00020?ooo`040000003oool00000000000<0oooo00@000000?ooo`000000
00000`3oool01@000000oooo000000000000oooo00<0000000<0oooo0000
000000000`3oool00`000000oooo0?ooo`02000000040?ooo`0000000000
0?ooo`80000000@0oooo0000000000000000>`3oool00`000000oooo0?oo
o`0;0?ooo`8000002P3oool2000000<0oooo00@000000?ooo`0000000000
0`3oool00`000000oooo0?ooo`02000000030?ooo`000000000000/0oooo
0P00000A0?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`80
000000H0oooo000000000000oooo0000003oool4000000<0oooo00<00000
0?ooo`3oool00P0000000`3oool000000000000:0?ooo`8000001P3oool2
00000?l0oooo_03oool001d0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000020?ooo`800000103oool2000000<0oooo00@000000?oo
o`00000000001@3oool200000080oooo0P0000000`3oool0000000000006
0?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`800000?03o
ool2000000X0oooo0P00000;0?ooo`80000000D0oooo0000003oool00000
0?ooo`02000000H0oooo0P0000000`3oool000000000000N0?ooo`800000
00@0oooo000000000000oooo0P0000020?ooo`80000000H0oooo00000000
0000oooo0000003oool4000000H0oooo0P0000000`3oool000000000000;
0?ooo`800000o`3oooo30?ooo`007@3oool4000000@0oooo0P0000030?oo
o`8000000P3oool200000080oooo0P0000040?ooo`8000001@3oool60000
00030?ooo`00000000000080oooo0P0000000`3oool00000000000040000
0080oooo0P000000103oool000000000003oool200000080oooo0P00000c
0?ooo`D000001P3oool2000000T0oooo0P00000:0?ooo`80000000D0oooo
0000003oool000000?ooo`0600000080oooo0P0000000`3oool000000000
000N0?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`800000
00H0oooo000000000000oooo0000003oool800000080oooo0P0000000`3o
ool000000000000:0?ooo`800000o`3oooo40?ooo`007@3oool200000003
0?ooo`000000000000<0oooo0P0000030?ooo`8000000P3oool200000080
oooo0P0000040?ooo`8000001@3oool200000080oooo0P000000103oool0
00000000003oool3000000030?ooo`00000000000080oooo0P0000020?oo
o`80000000@0oooo000000000000oooo0P000000103oool0000000000000
000l0?ooo`8000002`3oool2000000@0oooo00<000000?ooo`0000000`3o
ool3000000040?ooo`00000000000?ooo`8000000P3oool200000080oooo
0P0000000`3oool00000000000020?ooo`030000003oool000000180oooo
00<000000?ooo`000000103oool01P000000oooo0000003oool000000?oo
o`8000000P3oool2000000060?ooo`00000000000?ooo`000000oooo1000
00020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo00<0
00000?ooo`0000001@3oool200000?l0ooooa03oool001d0oooo0P000000
0`3oool00000000000030?ooo`800000103oool400000080oooo1@000002
0?ooo`8000001P3oool4000000<0oooo0P0000001@3oool0000000000000
0000oooo00@000000P3oool5000000<0oooo0P0000000`3oool000000000
000k0?ooo`030000003oool0oooo00/0oooo0P0000040?ooo`030000003o
ool0000000<0oooo0`0000000`3oool00000000000020?ooo`@000000P3o
ool5000000<0oooo00<000000?ooo`0000004P3oool00`000000oooo0000
00030?ooo`80000000<0oooo0000003oool00P0000000`3oool000000000
0002000000030?ooo`000000000000D000000P3oool400000080oooo1@00
00030?ooo`030000003oool0000000D0oooo0P00003o0?oool@0oooo000M
0?ooo`80000000<0oooo0000000000000`3oool2000000/0oooo0P000004
0?ooo`8000009@3oool2000003T0oooo0P00000>0?ooo`800000103oool0
0`000000oooo000000030?ooo`<0000000<0oooo000000000000403oool0
0`000000oooo0000000B0?ooo`030000003oool0000000<0oooo0P000003
0?ooo`8000007@3oool00`000000oooo000000050?ooo`800000o`3oooo4
0?ooo`00703oool500000080oooo1000000;0?ooo`8000000`3oool40000
02<0oooo0`00001:0?ooo`8000000`3oool00`000000oooo000000020?oo
o`<000000`3oool2000000l0oooo00<000000?ooo`0000004P3oool00`00
0000oooo000000020?ooo`@0000000<0oooo0000000000000P00000L0?oo
o`030000003oool0000000@0oooo0P00003o0?ooolD0oooo003o0?ooool0
oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o
0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0
oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00:`3oool4
000007`0oooo0P00000I0?ooo`030000003oool0oooo02H0oooo0P000006
0?ooo`030000003oool0oooo0?l0oooog`3oool002h0oooo0P00001j0?oo
o`8000006P3oool2000002P0oooo0P0000050?ooo`800000o`3ooooP0?oo
o`006`3oool700000080oooo100000030?ooo`80000000<0oooo00000000
00000P3oool400000080oooo0`0000001@3oool00000000000000000oooo
0080000000<0oooo0000000000001P0000020?ooo`<0000000D0oooo0000
0000000000000?ooo`06000000040?ooo`00000000000?ooo`<0000000<0
oooo0000000000000P0000030?ooo`80000000<0oooo000000000000:`3o
ool2000000h0oooo0P0000050?ooo`8000001@3oool3000000D0oooo0P00
00050?ooo`030000003oool0oooo0140oooo0P0000050?ooo`<00000103o
ool3000000@0oooo0P0000060?ooo`030000003oool0oooo0?l0oooogP3o
ool001`0oooo0P0000030?ooo`040000003oool00000000000<0oooo00D0
00000?ooo`00000000000?ooo`03000000030?ooo`000000000000<0oooo
00<000000?ooo`3oool00P000000103oool000000000003oool200000006
0?ooo`00000000000000003oool000000`3oool200000080oooo0P000000
103oool000000000003oool200000080oooo0P000000103oool000000000
003oool3000000030?ooo`00000000000080oooo0P0000020?ooo`800000
00<0oooo000000000000;@3oool00`000000oooo0?ooo`0;0?ooo`800000
1@3oool2000000@0oooo0P0000000`3oool00000000000040?ooo`800000
1@3oool200000180oooo0P0000040?ooo`80000000<0oooo000000000000
0P3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`800000
o`3ooooO0?ooo`00703oool2000000<0oooo00@000000?ooo`0000000000
1@3oool200000080oooo0P0000000`3oool00000000000060?ooo`800000
00@0oooo000000000000oooo0P0000020?ooo`8000001@3oool200000080
oooo0P000000103oool000000000003oool200000080oooo0P0000000`3o
ool00000000000020?ooo`80000000<0oooo0000000000000P3oool20000
0080oooo0P0000000`3oool000000000000^0?ooo`8000002P3oool20000
00`0oooo0P0000000`3oool00000000000040?ooo`8000007`3oool20000
00030?ooo`00000000000080oooo0P0000000`3oool00000000000040?oo
o`800000o`3ooooV0?ooo`00703oool2000000D0oooo1P0000000`3oool0
0000000000020?ooo`80000000<0oooo000000000000100000020?ooo`80
000000@0oooo000000000000oooo0P0000020?ooo`8000000`3oool30000
00<0oooo0P0000000`3oool00000000000020?ooo`D0000000<0oooo0000
000000000P3oool2000000030?ooo`00000000000080oooo0P0000001P3o
ool000000000003oool000000?ooo`800000903oool5000000H0oooo0P00
00090?ooo`8000002`3oool2000000030?ooo`000000000000@0oooo0P00
000A0?ooo`D000002@3oool2000000030?ooo`00000000000080oooo0P00
00000`3oool00000000000030?ooo`800000o`3ooooW0?ooo`00703oool2
000000D0oooo0P0000020?ooo`80000000@0oooo000000000000oooo0`00
00000`3oool00000000000020?ooo`8000000P3oool2000000040?ooo`00
000000000?ooo`80000000@0oooo00000000000000000P3oool3000000@0
oooo0P0000000`3oool00000000000050?ooo`80000000@0oooo00000000
0000oooo0`0000000`3oool00000000000020?ooo`80000000H0oooo0000
00000000oooo0000003oool2000002d0oooo0P00000;0?ooo`8000002`3o
ool2000000030?ooo`000000000000D0oooo0P00000N0?ooo`80000000<0
oooo0000000000000`3oool3000000@0oooo0P00003o0?ooonL0oooo000L
0?ooo`8000001P3oool4000000<0oooo0P0000001@3oool0000000000000
0000oooo00@000000P3oool5000000<0oooo0P000000103oool000000000
003oool2000000H0oooo100000030?ooo`@000000`3oool2000000030?oo
o`00000000000080oooo100000000`3oool0000000000002000000030?oo
o`000000000000800000:`3oool00`000000oooo0?ooo`0;0?ooo`800000
2`3oool2000000030?ooo`000000000000D0oooo0P00000N0?ooo`800000
00<0oooo0000000000000P3oool2000000030?ooo`000000000000<0oooo
0P00003o0?ooonL0oooo000L0?ooo`8000009@3oool2000000030?ooo`00
0000000000<0oooo00<000000?ooo`3oool00P00000?0?ooo`800000>@3o
ool2000000h0oooo0P00000;0?ooo`80000000<0oooo0000000000000P3o
ool00`000000oooo0?ooo`02000001h0oooo0P0000000`3oool000000000
00020?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooi`3o
ool001/0oooo1000000S0?ooo`<000000P3oool5000000040?ooo`000000
0000000000h0oooo0`00001:0?ooo`8000002`3oool3000000<0oooo1@00
000O0?ooo`<00000103oool3000000<0oooo0P00003o0?ooonP0oooo003o
0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0
oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo
0?ooomX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00
:`3oool4000003@0oooo1000001F0?ooo`D000009`3oool4000000l0oooo
100000050?ooo`030000003oool0oooo0?l0ooood@3oool002h0oooo0P00
000f0?ooo`800000E`3oool2000002P0oooo0P00000C0?ooo`8000001@3o
ool200000?l0oooodP3oool001/0oooo1`0000020?ooo`@000000`3oool2
000000030?ooo`00000000000080oooo100000020?ooo`<0000000D0oooo
00000000000000000?ooo`02000000030?ooo`000000000000H000000`3o
ool6000000030?ooo`0000000000008000000P3oool300000080oooo0P00
0000103oool000000000003oool2000000030?ooo`000000000000<00000
0`3oool4000000@0oooo200000001@3oool00000000000000000oooo0080
000000@0oooo00000000000000003P3oool2000000d0oooo100000020?oo
o`D000000`3oool600000080oooo0P0000020?ooo`L000000P3oool40000
00@0oooo0`0000030?ooo`@000000P3oool6000000<0oooo0P0000050?oo
o`8000001@3oool3000000@0oooo0P0000060?ooo`030000003oool0oooo
0?l0ooood03oool001`0oooo0P0000030?ooo`040000003oool000000000
00<0oooo00D000000?ooo`00000000000?ooo`03000000030?ooo`000000
000000<0oooo00<000000?ooo`3oool00P000000103oool000000000003o
ool2000000050?ooo`00000000000000003oool00P0000020?ooo`800000
00<0oooo0000000000000P3oool2000000030?ooo`000000000000<0oooo
00<000000?ooo`3oool00P000000103oool000000000003oool200000004
0?ooo`000000000000000080oooo0P0000040?ooo`8000000P3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`80000000@0oooo0000
00000000oooo0P000000103oool0000000000000000A0?ooo`030000003o
ool0oooo00T0oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P00
00020?ooo`8000000`3oool300000080oooo0P0000030?ooo`040000003o
ool00000000000<0oooo00@000000?ooo`3oool0oooo0`0000020?ooo`80
00000`3oool010000000oooo0?ooo`3oool2000000D0oooo0P0000050?oo
o`800000103oool2000000030?ooo`000000000000<0oooo0P0000060?oo
o`800000o`3ooooA0?ooo`00703oool2000000<0oooo00@000000?ooo`00
000000001@3oool200000080oooo0P0000000`3oool00000000000060?oo
o`80000000@0oooo000000000000oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool2000000030?ooo`00000000000080oooo0P000000
0`3oool00000000000060?ooo`@000000P3oool200000080oooo0P000002
0?ooo`800000103oool200000080oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool2000000040?ooo`00000000000?ooo`8000000P3o
ool200000180oooo0P0000090?ooo`8000000P3oool200000080oooo0P00
00040?ooo`8000000P3oool2000000<0oooo0`0000020?ooo`8000000`3o
ool010000000oooo0000000000070?ooo`030000003oool000000080oooo
0P0000070?ooo`8000001@3oool2000000/0oooo0P0000000`3oool00000
000000030?ooo`800000o`3ooooI0?ooo`00703oool2000000D0oooo1P00
00000`3oool00000000000020?ooo`80000000<0oooo0000000000001000
00020?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool200000080oooo1@0000000`3oool00000
000000060?ooo`<000000`3oool200000080oooo0P0000020?ooo`800000
103oool200000080oooo0P0000020?ooo`80000000<0oooo000000000000
0P3oool2000000040?ooo`00000000000?ooo`8000000P3oool2000000T0
oooo1@0000060?ooo`8000001`3oool2000000030?ooo`00000000000080
000000<0oooo0000000000001@3oool500000080oooo0P000000103oool0
00000000003oool2000000D0oooo1P0000020?ooo`80000000@0oooo0000
00000000oooo1P0000030?ooo`8000001@3oool2000000/0oooo0P000000
0`3oool00000000000030?ooo`800000o`3ooooI0?ooo`00703oool20000
00D0oooo0P0000020?ooo`80000000@0oooo000000000000oooo0`000000
0`3oool00000000000020?ooo`8000000P3oool2000000040?ooo`000000
00000?ooo`80000000D0oooo00000000000000000?ooo`05000000H0oooo
0P0000000`3oool00000000000030?ooo`030000003oool0oooo00@00000
0P3oool2000000040?ooo`000000000000000080oooo0`0000000`3oool0
00000?ooo`0200000080oooo0P0000020?ooo`80000000<0oooo00000000
00000P3oool2000000040?ooo`00000000000?ooo`80000000@0oooo0000
0000000000004P3oool2000000T0oooo0P0000060?ooo`<0000000<0oooo
0000003oool0103oool200000080oooo0P000000103oool000000000003o
ool2000000D0oooo0P0000020?ooo`8000000P3oool2000000040?ooo`00
000000000?ooo`8000000P3oool2000000<0oooo0P0000050?ooo`800000
303oool3000000@0oooo0P00003o0?ooomT0oooo000L0?ooo`8000001P3o
ool4000000<0oooo0P0000001@3oool00000000000000000oooo00@00000
0P3oool5000000<0oooo0P000000103oool000000000003oool200000080
oooo0P0000020?ooo`@000000`3oool500000080oooo0P0000000`3oool0
0000000000020?ooo`80000000<0oooo000000000000100000000`3oool0
0000000000020?ooo`@000000P3oool3000000040?ooo`00000000000?oo
o`D000000`3oool2000000030?ooo`00000000000140oooo00<000000?oo
o`3oool02@3oool2000000D0oooo0`0000000`3oool00000000000020?oo
o`@000000P3oool3000000030?ooo`000000000000<000001P3oool40000
0080oooo0`0000001@3oool00000000000000000oooo00@00000103oool2
000000D0oooo0P00000;0?ooo`80000000<0oooo0000000000000`3oool2
00000?l0oooof@3oool001`0oooo0P00000U0?ooo`80000000<0oooo0000
000000000P3oool200000100oooo0P00000[0?ooo`8000003`3oool20000
00`0oooo0P0000030?ooo`030000003oool0oooo01@0oooo0P00000L0?oo
o`8000001@3oool2000000/0oooo0P0000000`3oool00000000000030?oo
o`800000o`3ooooI0?ooo`006`3oool4000002<0oooo2@00000@0?ooo`<0
0000:P3oool3000001h0oooo1@00000E0?ooo`@000006@3oool4000000D0
oooo1000000:0?ooo`<000000P3oool400000?l0oooof@3oool00?l0oooo
o`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool0
0?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooo
fP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo002[0?oo
o`8000009`3oool4000000@0oooo0P00000;0?ooo`030000003oool0oooo
00T0oooo1@00000P0?ooo`@000000`3oool4000000P0oooo100000030?oo
o`@00000103oool2000000H0oooo00<000000?ooo`3oool0303oool20000
00/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0O0?oo
o`@000004P3oool4000000030?ooo`000000000000<000007P3oool40000
00D0oooo00<000000?ooo`3oool04@3oool2000000@0oooo100000050?oo
o`030000003oool0oooo04X0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`190?ooo`8000001P3oool00`000000oooo0?ooo`090?oo
o`00ZP3oool2000002P0oooo0P0000050?ooo`800000303oool2000000`0
oooo0P00000Q0?ooo`8000001@3oool2000000`0oooo0P0000050?ooo`80
00001@3oool2000000D0oooo0P00000<0?ooo`800000303oool2000001<0
oooo0P00000S0?ooo`8000004@3oool2000000D0oooo0P00000Q0?ooo`80
00001@3oool2000001<0oooo0P0000050?ooo`8000001@3oool2000004/0
oooo0P00000X0?ooo`800000B`3oool2000000D0oooo0P00000:0?ooo`00
6`3oool5000000<0oooo1@0000030?ooo`P0000000<0oooo0000003oool0
1`0000030?ooo`@000000P3oool600000080oooo100000020?ooo`<00000
0P3oool7000003X0oooo0P00000>0?ooo`800000103oool4000000<0oooo
200000000`3oool00000000000020?ooo`H000000P3oool4000000@0oooo
0P0000050?ooo`8000000`3oool6000000@0oooo00<000000?ooo`3oool0
2P3oool2000000@0oooo100000030?ooo`/000000P3oool5000000@0oooo
0P0000050?ooo`8000000`3oool6000000<0oooo0P0000050?ooo`800000
1@3oool2000000H0oooo00<000000?ooo`3oool02P3oool2000000<0oooo
1P0000040?ooo`030000003oool0oooo00T0oooo1P0000030?ooo`030000
003oool0oooo00L0oooo1`0000020?ooo`@000000P3oool3000000050?oo
o`00000000000000003oool00P0000000`3oool00000000000030?ooo`<0
00000P3oool3000000040?ooo`000000000000000080oooo0P0000050?oo
o`800000103oool4000000<0oooo2`0000020?ooo`D00000103oool20000
00H0oooo00<000000?ooo`3oool02@3oool5000000<0oooo0P0000050?oo
o`8000001P3oool00`000000oooo0?ooo`080?ooo`<0000000@0oooo0000
0000000000000P3oool500000080oooo0`0000030?ooo`@0000000L0oooo
00000000000000000?ooo`000000oooo00T000000P3oool300000080oooo
1P0000020?ooo`@000001@3oool00`000000oooo0?ooo`070?ooo`@00000
00<0oooo0000000000000P3oool400000080oooo0`0000001@3oool00000
000000000000oooo00@000001@3oool00`000000oooo0?ooo`080?ooo`<0
000000@0oooo00000000000000000P3oool500000080oooo0`0000030?oo
o`@0000000L0oooo00000000000000000?ooo`000000oooo00T000000P3o
ool300000080oooo1P0000020?ooo`@00000103oool2000000H0oooo00<0
00000?ooo`3oool0203oool001`0oooo0P0000060?ooo`800000103oool2
00000080oooo0P0000001P3oool000000000003oool000000?ooo`@00000
0`3oool010000000oooo0?ooo`3oool2000000D0oooo0P0000030?ooo`80
00000`3oool00`000000oooo0?ooo`02000000040?ooo`00000000000?oo
o`8000000P3oool2000003/0oooo00<000000?ooo`3oool02`3oool20000
00D0oooo0P0000030?ooo`8000000P3oool2000000050?ooo`0000000000
0000003oool00P0000030?ooo`8000000`3oool2000000<0oooo00@00000
0?ooo`3oool0oooo0P0000050?ooo`8000001@3oool2000000H0oooo0P00
000;0?ooo`<000000P3oool2000000<0oooo00@000000?ooo`0000000000
0P3oool200000080oooo0P0000040?ooo`8000000P3oool2000000<0oooo
0P0000050?ooo`8000001@3oool2000000D0oooo0P0000050?ooo`800000
1@3oool2000000H0oooo0P00000;0?ooo`8000001@3oool2000000H0oooo
0P00000<0?ooo`8000001@3oool2000000T0oooo0P0000030?ooo`040000
003oool00000000000<0oooo00<000000?ooo`3oool00P000000103oool0
00000000003oool2000000040?ooo`000000000000000080oooo0P000002
0?ooo`030000003oool0oooo0080000000<0oooo0000000000000`3oool2
000000D0oooo0`0000020?ooo`8000000`3oool010000000oooo00000000
00020?ooo`8000000P3oool2000000@0oooo0P0000020?ooo`8000000`3o
ool2000000H0oooo0P00000:0?ooo`8000001P3oool2000000D0oooo0P00
00060?ooo`8000002P3oool2000000030?ooo`00000000000080oooo0P00
00000`3oool00000000000020?ooo`8000000P3oool010000000oooo0000
000000020?ooo`80000000H0oooo000000000000oooo0000003oool40000
0080oooo0P0000020?ooo`8000000P3oool010000000oooo0?ooo`3oool2
000000<0oooo0P0000030?ooo`030000003oool0oooo0080oooo0P000009
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P000002
0?ooo`80000000@0oooo000000000000oooo0P0000030?ooo`030000003o
ool0oooo0080oooo0P00000:0?ooo`80000000<0oooo0000000000000P3o
ool2000000030?ooo`00000000000080oooo0P0000020?ooo`040000003o
ool0000000000080oooo0P0000001P3oool000000000003oool000000?oo
o`@000000P3oool200000080oooo0P0000020?ooo`040000003oool0oooo
0?ooo`8000000`3oool2000000<0oooo00@000000?ooo`3oool0oooo0P00
00060?ooo`8000002@3oool001`0oooo0P0000060?ooo`800000103oool2
00000080oooo0P0000001P3oool000000000003oool000000?ooo`@00000
1`3oool2000000D0oooo0P0000030?ooo`8000001P3oool4000000@0oooo
1000000l0?ooo`8000002P3oool2000000H0oooo0P0000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
0`3oool2000000L0oooo0P0000040?ooo`8000001P3oool2000001<0oooo
0`0000020?ooo`8000001@3oool200000080oooo0P0000020?ooo`800000
1P3oool4000000<0oooo0P0000050?ooo`8000001@3oool2000000D0oooo
0P0000050?ooo`8000001P3oool200000140oooo0P0000060?ooo`800000
503oool200000100oooo0P0000030?ooo`040000003oool00000000000H0
oooo0P000000103oool000000000003oool200000080oooo0P0000020?oo
o`8000001@3oool2000000030?ooo`000000000000<0oooo0P0000050?oo
o`<000000P3oool2000000D0oooo0P0000020?ooo`8000000P3oool20000
00H0oooo100000030?ooo`8000004`3oool2000000H0oooo0P0000040?oo
o`8000004P3oool500000080oooo0P0000000`3oool00000000000020?oo
o`800000103oool200000080oooo0P0000001P3oool000000000003oool0
00000?ooo`@000000P3oool200000080oooo0P0000060?ooo`8000000`3o
ool2000001<0oooo0P0000001@3oool00000000000000000oooo00800000
0P3oool200000080oooo0P000000103oool000000000003oool2000001@0
oooo1@0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000020?ooo`80000000H0oooo000000000000oooo0000003oool4
00000080oooo0P0000020?ooo`8000001P3oool2000000<0oooo0P000008
0?ooo`800000403oool001`0oooo0P0000000`3oool000000?ooo`030?oo
o`8000001@3oool5000000060?ooo`00000000000?ooo`000000oooo2000
00030?ooo`8000001@3oool2000000<0oooo0P0000060?ooo`<000000`3o
ool4000003D0oooo1@0000060?ooo`8000002@3oool2000000D0oooo0P00
00040?ooo`D0000000<0oooo0000000000000P3oool2000000<0oooo0P00
00030?ooo`H000000`3oool2000000D0oooo0P0000050?ooo`8000004P3o
ool2000000040?ooo`00000000000?ooo`H000000P3oool500000080oooo
0P0000040?ooo`@000001@3oool2000000D0oooo0P0000050?ooo`800000
1@3oool2000000D0oooo0P0000050?ooo`8000004`3oool2000000D0oooo
0P00000D0?ooo`800000403oool2000000D0oooo1P0000020?ooo`800000
00@0oooo000000000000oooo0P0000020?ooo`8000000P3oool2000000D0
oooo0P0000000`3oool00000000000030?ooo`800000103oool200000004
0?ooo`00000000000?ooo`H000000P3oool500000080oooo0P0000040?oo
o`@000001@3oool2000001@0oooo0P0000040?ooo`8000001@3oool20000
0180oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000
000000000P3oool2000000@0oooo0P0000020?ooo`80000000H0oooo0000
00000000oooo0000003oool2000000030?ooo`000000000000<000000P3o
ool2000000H0oooo0P0000030?ooo`8000004`3oool2000000050?ooo`00
000000000000003oool00P0000020?ooo`8000000P3oool2000000040?oo
o`00000000000?ooo`H00000403oool2000000030?ooo`00000000000080
oooo0P0000000`3oool00000000000020?ooo`800000103oool200000080
oooo0P0000001P3oool000000000003oool000000?ooo`80000000<0oooo
0000000000000`0000020?ooo`8000001P3oool2000000<0oooo0P000007
0?ooo`8000004@3oool001`0oooo100000040?ooo`<0000000<0oooo0000
003oool0103oool2000000060?ooo`00000000000?ooo`000000oooo1000
00020?ooo`8000000`3oool2000000D0oooo0P0000030?ooo`8000000`3o
ool00`000000oooo0?ooo`0400000080oooo0P0000020?ooo`800000?03o
ool2000000/0oooo0P0000050?ooo`8000001`3oool2000000050?ooo`00
000000000000003oool00P0000030?ooo`8000000`3oool200000080oooo
0P0000030?ooo`8000001@3oool2000000D0oooo0P00000B0?ooo`800000
00@0oooo000000000000oooo0P0000020?ooo`8000001@3oool200000080
oooo0`0000000`3oool000000?ooo`0200000080oooo0P0000030?ooo`80
00001@3oool2000000D0oooo0P0000050?ooo`8000001@3oool2000000D0
oooo0P00000C0?ooo`8000001@3oool2000001@0oooo0P00000@0?ooo`80
00001@3oool200000080oooo0P0000020?ooo`80000000@0oooo00000000
0000oooo0P000000103oool000000000000000020?ooo`8000001@3oool2
000000030?ooo`000000000000<0oooo0P0000040?ooo`80000000@0oooo
000000000000oooo0P0000020?ooo`8000001@3oool200000080oooo0`00
00000`3oool000000?ooo`0200000080oooo0P0000030?ooo`8000005@3o
ool2000000<0oooo0P0000050?ooo`8000004P3oool2000000030?ooo`00
000000000080oooo0P0000000`3oool00000000000020?ooo`800000103o
ool200000080oooo0P0000001P3oool000000000003oool000000?ooo`80
0000103oool200000080oooo0P0000060?ooo`8000000`3oool2000000<0
oooo00<000000?ooo`3oool03@3oool3000000040?ooo`00000000000?oo
o`8000000P3oool200000080oooo0P000000103oool000000000003oool2
00000080oooo0P00000@0?ooo`80000000<0oooo0000000000000P3oool2
000000030?ooo`00000000000080oooo0P0000040?ooo`8000000P3oool2
000000060?ooo`00000000000?ooo`000000oooo0P0000040?ooo`800000
0P3oool2000000H0oooo0P0000030?ooo`8000000`3oool010000000oooo
0?ooo`3oool200000140oooo000L0?ooo`80000000D0oooo0000003oool0
00000?ooo`03000000030?ooo`00000000000080oooo100000000`3oool0
00000000000500000080oooo100000020?ooo`070000003oool000000000
003oool000000?ooo`04000000@0oooo1@0000020?ooo`80000000<0oooo
0000000000000P3oool5000003/0oooo00<000000?ooo`3oool02`3oool2
000000<0oooo00H000000?ooo`00000000000?ooo`0000020?ooo`@00000
0P3oool2000000030?ooo`000000000000@0oooo0P0000040?ooo`@00000
103oool2000000D0oooo0P0000030?ooo`@000004@3oool3000000050?oo
o`00000000000000003oool0100000030?ooo`@000000P3oool300000003
0?ooo`00000000000080oooo1@0000030?ooo`8000001@3oool2000000<0
oooo100000050?ooo`8000001@3oool2000000D0oooo0P00000C0?ooo`80
00000`3oool4000001@0oooo0P00000@0?ooo`8000001P3oool400000080
oooo1@0000030?ooo`80000000<0oooo0000000000001P0000030?ooo`@0
0000103oool2000000<0oooo0`0000001@3oool00000000000000000oooo
00@000000`3oool400000080oooo0`0000000`3oool00000000000020?oo
o`D000000`3oool200000180oooo0P0000000`3oool00000000000030?oo
o`8000001@3oool2000001<0oooo00<000000?ooo`0000000P3oool30000
00040?ooo`00000000000?ooo`D000000`3oool4000000030?ooo`000000
000000D000000P3oool400000080oooo1@0000020?ooo`@00000103oool5
000000l0oooo0`0000000`3oool00000000000020?ooo`@000000P3oool5
000000<0oooo1000000B0?ooo`030000003oool000000080oooo0`000000
103oool000000000003oool5000000<0oooo100000000`3oool000000000
000500000080oooo100000020?ooo`D000000P3oool4000000@0oooo1@00
00030?ooo`8000004@3oool001`0oooo0P0000030?ooo`030000003oool0
oooo01/0oooo00H000000?ooo`00000000000?ooo`00000@0?ooo`800000
@`3oool2000000h0oooo0P0000030?ooo`060000003oool000000000003o
ool00000203oool2000000L0oooo0P00000<0?ooo`8000001@3oool20000
03d0oooo0P0000050?ooo`800000303oool2000000D0oooo0P0000050?oo
o`8000004`3oool2000001T0oooo1000000@0?ooo`8000006`3oool20000
00D0oooo0P0000060?ooo`800000:03oool200000180oooo0P0000000`3o
ool00000000000030?ooo`8000001@3oool2000001<0oooo0`00000:0?oo
o`8000006P3oool200000200oooo0P0000020?ooo`8000009P3oool30000
00X0oooo0P00000J0?ooo`800000503oool200000140oooo000K0?ooo`L0
00007@3oool6000000<0oooo0P00000:0?ooo`<00000E03oool200000080
oooo1P0000070?ooo`<000001@3oool4000000`0oooo100000040?ooo`80
0000103oool2000003H0oooo100000030?ooo`@000000`3oool2000000<0
oooo100000030?ooo`@00000103oool2000001D0oooo0P0000040?ooo`80
0000503oool2000000l0oooo1000000J0?ooo`800000103oool3000000H0
oooo1000000T0?ooo`@000004`3oool3000000<0oooo0P0000040?ooo`@0
00004@3oool5000000X0oooo0P00000J0?ooo`8000001P3oool2000001L0
oooo0`0000000`3oool0000000000002000002<0oooo1@00000:0?ooo`80
00006P3oool2000000H0oooo0P00000;0?ooo`8000004P3oool00?l0oooo
o`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool0
0?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooo
fP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo002[0?oo
o`8000002@3oool500000200oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo02H0oooo0P0000060?oo
o`030000003oool0oooo0?l0ooooJ03oool00:X0oooo0P00000<0?ooo`80
00008@3oool2000002l0oooo0P00000_0?ooo`800000:03oool2000000D0
oooo0P00003o0?ooofT0oooo000K0?ooo`D000000`3oool5000000<0oooo
200000000`3oool000000?ooo`07000000030?ooo`000000000000D00000
0P3oool8000000030?ooo`000000000000<0oooo100000020?ooo`H00000
>@3oool2000000h0oooo0P00000<0?ooo`800000103oool4000000<0oooo
2`00000<0?ooo`030000003oool0oooo00X0oooo0`1EEED30?ooo`@0EEEE
0P3oool305EEE@040?ooo`1EEED0EEEE05EEE@80oooo0`1EEED30?ooo`D0
EEEE103oool00`000000oooo0?ooo`0:0?ooo`<0P8200`3oool40820P080
oooo0`20P800103oool0P8200820P020P8020?ooo`<0P8200`3oool60820
P0<0oooo00<000000?ooo`3oool01`3oool4000000030?ooo`0000000000
0080oooo100000020?ooo`<0000000D0oooo00000000000000000?ooo`04
000000@0oooo0P0000060?ooo`030000003oool0oooo0?l0ooooI`3oool0
01`0oooo0P0000060?ooo`800000103oool200000080oooo0P0000001P3o
ool000000000003oool000000?ooo`@000000`3oool010000000oooo0000
000000030?ooo`040000003oool0000000000080oooo0P0000001@3oool0
0000000000000000oooo0080000000<0oooo0000000000000`3oool01000
0000oooo0?ooo`3oool2000003d0oooo00<000000?ooo`3oool02`3oool2
000000`0oooo0`0000020?ooo`8000000`3oool010000000oooo00000000
00020?ooo`8000000P3oool2000000h0oooo0P00000:0?ooo`80EEEE0P3o
ool0101EEED0oooo05EEE@1EEED30?ooo`0305EEE@3oool0oooo0080EEEE
00<0oooo05EEE@1EEED00P3oool205EEE@80oooo00<0EEEE0?ooo`3oool0
0P1EEED70?ooo`8000002P3oool20820P080oooo00@0P8200?ooo`20P800
P8200`3oool00`20P800oooo0?ooo`020820P0030?ooo`20P800P8200080
oooo0P20P8020?ooo`030820P03oool0oooo0080oooo0P20P8050?ooo`80
00002@3oool200000080oooo0P0000000`3oool00000000000020?ooo`80
00000P3oool2000000040?ooo`00000000000?ooo`8000000`3oool01000
0000oooo0?ooo`3oool2000000H0oooo0P00003o0?ooofP0oooo000L0?oo
o`8000001P3oool2000000@0oooo0P0000020?ooo`80000000H0oooo0000
00000000oooo0000003oool4000000D0oooo0P0000030?ooo`040000003o
ool0000000000080oooo0P0000000`3oool00000000000020?ooo`800000
00<0oooo0000000000001`3oool2000003h0oooo0P00000:0?ooo`800000
3@3oool300000080oooo0P0000050?ooo`8000000P3oool200000080oooo
0P00000J0?ooo`80EEEE103oool205EEE@L0oooo0`1EEED30?ooo`80EEEE
1P3oool205EEEA80oooo0P20P8040?ooo`80P8201`3oool30820P0<0oooo
0P20P8070?ooo`80P820403oool2000000050?ooo`00000000000000003o
ool00P0000020?ooo`8000000P3oool2000000040?ooo`00000000000?oo
o`800000203oool200000?l0ooooK`3oool001`0oooo0P0000000`3oool0
00000?ooo`030?ooo`8000001@3oool5000000060?ooo`00000000000?oo
o`000000oooo200000000`3oool00000000000060?ooo`D0000000<0oooo
0000000000000P3oool2000000030?ooo`000000000000@000000`3oool2
000003D0oooo1@0000060?ooo`8000002@3oool2000000/0oooo0P000000
103oool000000000003oool600000080oooo1@0000020?ooo`8000006P3o
ool205EEE@@0oooo1P1EEED30?ooo`<0EEEE0`3oool205EEE@L0oooo0P1E
EEDA0?ooo`80P820103oool60820P0<0oooo0`20P8030?ooo`80P8201`3o
ool20820P100oooo0P0000001@3oool00000000000000000oooo00800000
0P3oool200000080oooo0P000000103oool000000000003oool6000000<0
oooo0P00003o0?ooog00oooo000L0?ooo`@00000103oool3000000030?oo
o`000000oooo00@0oooo0P0000001P3oool000000000003oool000000?oo
o`@000000P3oool2000000030?ooo`000000000000T0oooo0P0000001@3o
ool00000000000000000oooo0080000000<0oooo0000000000000P3oool2
000000<0oooo0P00000n0?ooo`8000002`3oool2000000@0oooo00<00000
0?ooo`000000103oool2000000040?ooo`00000000000?ooo`8000000P3o
ool2000000D0oooo0P0000020?ooo`<0000000L0oooo0000003oool0oooo
0000003oool000000180oooo0P1EEED40?ooo`80EEEE0P3oool205EEE@80
oooo0P1EEED00`3oool0EEEE05EEE@020?ooo`80EEEE203oool205EEEA00
oooo0P20P8040?ooo`80P8200P3oool20820P080oooo0P20P8000`3oool0
P8200820P0020?ooo`80P8201`3oool20820P100oooo0`000000103oool0
00000000003oool200000080oooo0P0000020?ooo`80000000@0oooo0000
00000000oooo0P0000020?ooo`8000000`3oool200000?l0ooooL03oool0
01`0oooo0P0000001@3oool000000?ooo`000000oooo00<0000000<0oooo
0000000000000P3oool4000000030?ooo`000000000000D000000P3oool4
00000080oooo0P0000060?ooo`@000000P3oool2000000030?ooo`000000
000000<0oooo100000040?ooo`800000?@3oool00`000000oooo0?ooo`0;
0?ooo`800000103oool00`000000oooo000000030?ooo`<0000000D0oooo
00000000000000000?ooo`04000000<0oooo100000020?ooo`<0000000<0
oooo0000000000000P3oool00`000000oooo0000000A0?ooo`D0EEEE0`3o
ool405EEE@80oooo0`1EEED00`3oool0EEEE05EEE@0605EEE@<0oooo0P1E
EED00`3oool0EEEE05EEE@0?0?ooo`D0P8200`3oool40820P080oooo0`20
P8000`3oool0P8200820P0060820P0D0oooo0P20P80@0?ooo`<0000000<0
oooo0000000000000P3oool400000080oooo1@0000030?ooo`@00000103o
ool200000?l0ooooL03oool001`0oooo0P0000030?ooo`030000003oool0
oooo01/0oooo0P00000<0?ooo`8000003P3oool2000003/0oooo0P00000>
0?ooo`800000103oool00`000000oooo0000000P0?ooo`030000003oool0
00000180oooo0P1EEEDC0?ooo`80EEEE1@3oool205EEE@030?ooo`1EEED0
EEEE0100oooo0P20P80C0?ooo`80P8201@3oool40820P100oooo0P000002
0?ooo`800000603oool200000?l0ooooL03oool001/0oooo1`00000L0?oo
o`@000002P3oool3000000`0oooo1000001<0?ooo`8000000`3oool00`00
0000oooo0000000P0?ooo`030000003oool000000180oooo0P1EEEDC0?oo
o`80EEEE1P3oool305EEEA40oooo0P20P80C0?ooo`80P8201`3oool20820
P0l0oooo0`0000000`3oool0000000000002000001H0oooo0P00003o0?oo
og40oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3o
oooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?oo
o`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool00?l0ooooo`3o
oooJ0?ooo`00aP3oool00`000000oooo0?ooo`3o0?ooool0oooo4@3oool0
0<H0oooo0P00003o0?ooool0oooo4P3oool001/0oooo1@0000030?ooo`D0
00000`3oool8000000030?ooo`000000oooo00L00000G@3oool2000000d0
oooo100000020?ooo`D00000103oool5000000030?ooo`00000000000080
00001@3oool00`000000oooo0?ooo`3o0?ooool0oooo403oool001`0oooo
0P0000060?ooo`800000103oool200000080oooo0P0000001P3oool00000
0000003oool000000?ooo`@000000`3oool00`000000oooo0?ooo`1L0?oo
o`030000003oool0oooo00/0oooo0P0000040?ooo`8000001@3oool20000
00040?ooo`00000000000?ooo`8000000`3oool00`000000oooo0?ooo`02
0?ooo`800000o`3ooooo0?oooa40oooo000L0?ooo`8000001P3oool20000
00@0oooo0P0000020?ooo`80000000H0oooo000000000000oooo0000003o
ool4000006<0oooo0P00000;0?ooo`800000103oool2000000D0oooo0P00
0000103oool000000000003oool200000?l0ooooo`3ooolK0?ooo`00703o
ool2000000030?ooo`000000oooo00<0oooo0P0000050?ooo`D0000000H0
oooo000000000000oooo0000003oool8000005H0oooo1@0000060?ooo`80
00002@3oool2000000@0oooo0P0000050?ooo`80000000@0oooo00000000
0000oooo1P00003o0?ooool0oooo5`3oool001`0oooo100000040?ooo`<0
000000<0oooo0000003oool0103oool2000000060?ooo`00000000000?oo
o`000000oooo100000020?ooo`800000G`3oool2000000/0oooo0P000004
0?ooo`<0000000@0oooo0000003oool0oooo0P000000103oool000000000
003oool200000080oooo0P00003o0?ooool0oooo5`3oool001`0oooo0P00
00001@3oool000000?ooo`000000oooo00<0000000<0oooo000000000000
0P3oool4000000030?ooo`000000000000D000000P3oool4000005l0oooo
00<000000?ooo`3oool02@3oool01`000000oooo000000000000oooo0000
003oool00`000000103oool000000000003oool3000000030?ooo`000000
00000080oooo1000003o0?ooool0oooo603oool001`0oooo0P0000030?oo
o`030000003oool0oooo07H0oooo0P00000<0?ooo`060000003oool00000
0000003oool00000o`3ooooo0?ooob`0oooo000K0?ooo`L00000QP3oool6
00000?l0ooooo`3oool/0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0
oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o
0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0
oooo003o0?ooool0oooofP3oool00380oooo1000001e0?ooo`800000803o
ool00`000000oooo0?ooo`190?ooo`8000001P3oool00`000000oooo0?oo
o`3o0?oookD0oooo000e0?ooo`800000L`3oool200000240oooo0P00001;
0?ooo`8000001@3oool200000?l0oooo]P3oool001`0oooo2@0000000`3o
ool000000?ooo`09000000040?ooo`00000000000?ooo`8000000P3oool4
00000080oooo1@0000020?ooo`H000000P3oool500000080oooo10000011
0?ooo`8000003P3oool2000000@0oooo1P0000000`3oool0000000000004
00000080oooo0`0000040?ooo`<000001@3oool00`000000oooo0?ooo`08
0?ooo`<0000000@0oooo00000000000000000P3oool500000080oooo0`00
00030?ooo`@0000000L0oooo00000000000000000?ooo`000000oooo00T0
00000P3oool300000080oooo1P0000020?ooo`@00000103oool2000000H0
oooo00<000000?ooo`3oool0o`3ooond0?ooo`007P3oool2000000<0oooo
0P0000000`3oool000000?ooo`0400000080oooo0P000000103oool00000
0000003oool3000000030?ooo`000000000000<0oooo00<000000?ooo`00
00000`3oool2000000<0oooo0P0000040?ooo`8000000P3oool010000000
oooo0000000000030?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool02`3oool2000000H0oooo0P0000050?ooo`8000000`3oool20000
00030?ooo`00000000000080oooo0P0000000`3oool00000000000040?oo
o`8000002P3oool2000000030?ooo`00000000000080oooo0P0000000`3o
ool00000000000020?ooo`8000000P3oool010000000oooo000000000002
0?ooo`80000000H0oooo000000000000oooo0000003oool400000080oooo
0P0000020?ooo`8000000P3oool010000000oooo0?ooo`3oool2000000<0
oooo0P0000030?ooo`040000003oool0oooo0?ooo`8000001P3oool20000
0?l0oooo]@3oool001h0oooo0P0000030?ooo`80000000<0oooo0000003o
ool0100000020?ooo`80000000<0oooo0000000000000P3oool200000003
0?ooo`000000000000T0oooo0P0000030?ooo`8000001@3oool2000000<0
oooo0P0000170?ooo`8000002P3oool2000000L0oooo0P0000050?ooo`80
00000`3oool2000000030?ooo`00000000000080oooo0P0000000`3oool0
00000000000@0?ooo`D000000P3oool2000000030?ooo`00000000000080
oooo0P0000040?ooo`8000000P3oool2000000060?ooo`00000000000?oo
o`000000oooo100000020?ooo`8000000P3oool2000000H0oooo0P000003
0?ooo`800000203oool200000?l0oooo_03oool001h0oooo0P0000030?oo
o`80000000<0oooo0000003oool00P0000000`3oool00000000000030000
00030?ooo`00000000000080oooo0P0000000`3oool00000000000040000
00<0oooo0`0000040?ooo`8000001P3oool200000080oooo1P00000j0?oo
o`D000001P3oool2000000T0oooo0P0000060?ooo`8000001@3oool20000
00<0oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000
00000000403oool2000000030?ooo`00000000000080oooo0P0000000`3o
ool00000000000020?ooo`800000103oool200000080oooo0P0000001P3o
ool000000000003oool000000?ooo`80000000<0oooo0000000000000`00
00020?ooo`8000001P3oool2000000<0oooo0P0000070?ooo`800000o`3o
oonm0?ooo`007P3oool2000000<0oooo0P0000000`3oool000000?ooo`02
000000@0oooo0P000000103oool000000000003oool3000000030?ooo`00
000000000080oooo0P0000020?ooo`<000001@3oool2000000@0oooo00<0
00000?ooo`3oool00P0000000`3oool00000000000020?ooo`800000@`3o
ool2000000/0oooo0P0000060?ooo`8000001@3oool2000000<0oooo0P00
00000`3oool00000000000020?ooo`80000000<0oooo000000000000403o
ool2000000030?ooo`00000000000080oooo0P0000000`3oool000000000
00020?ooo`800000103oool200000080oooo0P0000001P3oool000000000
003oool000000?ooo`800000103oool200000080oooo0P0000060?ooo`80
00000`3oool2000000<0oooo00@000000?ooo`3oool0oooo0P00003o0?oo
okd0oooo000N0?ooo`8000000P3oool700000080oooo100000030?ooo`80
000000D0oooo00000000000000000?ooo`0400000080oooo0P0000050?oo
o`@00000103oool500000080oooo100000130?ooo`030000003oool0oooo
00/0oooo0P0000060?ooo`8000001@3oool2000000<0oooo0P0000000`3o
ool00000000000020?ooo`80000000<0oooo0000000000004@3oool00`00
0000oooo000000020?ooo`<0000000@0oooo000000000000oooo1@000003
0?ooo`@0000000<0oooo0000000000001@0000020?ooo`@000000P3oool5
00000080oooo100000040?ooo`D000000`3oool200000?l0oooo_@3oool0
01h0oooo0P00000O0?ooo`8000000`3oool00`000000oooo0?ooo`1C0?oo
o`8000003P3oool2000000@0oooo100000030?ooo`@000000`3oool20000
00030?ooo`00000000000080oooo0P0000000`3oool000000000000A0?oo
o`<000002P3oool2000001X0oooo0P00000D0?ooo`800000o`3ooonm0?oo
o`00703oool6000001h0oooo1@0000030?ooo`800000H@3oool2000000D0
oooo0P0000050?ooo`800000103oool3000000@0oooo0`00000@0?ooo`D0
00002P3oool2000001X0oooo0P0000060?ooo`8000002`3oool200000?l0
oooo_P3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o
0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0
oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo
0?ooomX0oooo000n0?ooo`D00000B`3oool4000001P0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`3o0?oooo/0oooo000o0?ooo`80
0000C@3oool2000001X0oooo0P00000_0?ooo`800000o`3ooool0?ooo`00
6`3oool4000000040?ooo`000000000000000080oooo2`0000030?ooo`<0
00000P3oool6000000040?ooo`00000000000?ooo`8000000P3oool60000
0080oooo100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000000`0000040?ooo`<000000P3oool40000
00<0oooo1P0000020?ooo`@00000103oool3000000@0oooo0P0000020?oo
o`<0P02000<0oooo0800P03oool01`2008020?ooo`<0P02000@0oooo0800
P0200800P0200`3oool00`000000oooo0?ooo`090?ooo`80P02000<0oooo
0800P02008000P3oool40800P0070?ooo`200800P0200800P03oool0P020
0?ooo`070800P080oooo0`200800103oool0P0200800P02008030?ooo`03
0000003oool0oooo0?l0oooonP3oool001`0oooo0P0000030?ooo`030000
003oool0oooo0080000000<0oooo0000000000000`3oool2000000@0oooo
0P0000020?ooo`040000003oool0oooo0?ooo`8000000`3oool300000003
0?ooo`000000000000<0oooo0P0000030?ooo`8000000`3oool010000000
oooo0000000000030?ooo`040000003oool0oooo0?ooo`8000000`3oool2
00000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`02
000000H0oooo0P0000030?ooo`8000000P3oool200000080oooo0P000002
0?ooo`040000003oool0oooo0?ooo`8000000`3oool20800P0030?ooo`20
0800oooo00@0P0200`3oool00`200800oooo0?ooo`020800P0030?ooo`20
0800P02000@0oooo0P00000:0?ooo`80P02000@0oooo0800P0200800oooo
0P2008020?ooo`80P02000H0oooo0800P0200800oooo0800P03oool40800
P0<0oooo00<0P0200?ooo`3oool00P2008000`3oool0P0200800P0040?oo
o`800000o`3ooook0?ooo`00703oool2000000040?ooo`000000oooo0000
0080oooo0P0000000`3oool00000000000030?ooo`800000103oool20000
00H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000030?oo
o`8000001@3oool2000000<0oooo00@000000?ooo`3oool0oooo0P000005
0?ooo`@000000P3oool2000000D0oooo0P0000060?ooo`8000000`3oool2
00000080oooo0P0000020?ooo`8000001P3oool2000000<0oooo0P200800
0`3oool0P0200?ooo`040800P0H0oooo0P2008000`3oool0P0200800P00@
0?ooo`80P02000@0oooo0800P0200800oooo0P2008020?ooo`80P02000H0
oooo0800P0200800oooo0800P03oool40800P0H0oooo0P2008000`3oool0
P0200800P03o0?ooool0oooo0P3oool001`0oooo0P000000103oool00000
0?ooo`0000020?ooo`80000000<0oooo0000000000000`3oool2000000@0
oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`80
00000`3oool6000000030?ooo`000000000000L0oooo0P0000030?ooo`@0
0000103oool2000000D0oooo100000040?ooo`8000000`3oool200000080
oooo0P0000020?ooo`8000001P3oool2000000<0oooo0P2008000`3oool0
P0200?ooo`080800P080oooo0P2008000`3oool0P0200800P00?0?ooo`80
P02000<0oooo0800P03oool0102008020?ooo`80P02000H0oooo0800P020
0800oooo0800P03oool80800P080oooo0P2008000`3oool0P0200800P03o
0?ooool0oooo0P3oool001`0oooo0`0000000`3oool00000000000020?oo
o`80000000<0oooo0000000000000`3oool2000000@0oooo0P0000060?oo
o`8000000`3oool3000000030?ooo`000000000000<0oooo0P0000030?oo
o`8000000P3oool2000000030?ooo`000000000000L0oooo0P0000030?oo
o`8000000P3oool200000080oooo0P0000050?ooo`80000000<0oooo0000
000000000`3oool2000000<0oooo0P0000020?ooo`8000000P3oool20000
00H0oooo0P0000030?ooo`80P02000<0oooo0800P03oool0102008020?oo
o`80P0200P3oool20800P0030?ooo`200800P02000l0oooo0P2008000`3o
ool0P0200?ooo`040800P080oooo0P2008001P3oool0P0200800P03oool0
P0200?ooo`@0P0200P3oool20800P080oooo0P2008000`3oool0P0200800
P03o0?ooool0oooo0P3oool001`0oooo0`000000103oool000000000003o
ool3000000030?ooo`000000000000<0oooo0P0000030?ooo`D000000P3o
ool400000080oooo0`0000000`3oool00000000000040?ooo`800000103o
ool400000080oooo0P0000050?ooo`@00000103oool5000000030?ooo`00
0000000000<000000`3oool2000000030?ooo`000000000000<0oooo0P00
00040?ooo`@000000P3oool5000000@0oooo0P0000020?ooo`L0P0200P3o
ool40800P080oooo1@20080?0?ooo`@0P02000<0oooo0800P02008001P20
08000`3oool0P0200800P0050800P080oooo102008020?ooo`D0P020o`3o
oooo0?ooo`<0oooo000L0?ooo`<0000000<0oooo0000000000002P3oool2
000000@0oooo0P00000D0?ooo`8000002P3oool2000001@0oooo0P000005
0?ooo`80000000<0oooo0000000000000`3oool2000000/0oooo0P000006
0?ooo`800000o`3ooooo0?ooodX0oooo000K0?ooo`<000000`3oool20000
00L0oooo100000040?ooo`8000001P3oool2000000X0oooo100000090?oo
o`@000001P3oool2000000/0oooo0P0000040?ooo`D000000P3oool40000
00/0oooo0P0000060?ooo`@00000o`3ooooo0?ooodP0oooo003o0?ooool0
oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o
0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`00o`3ooooo0?ooomX0
oooo003o0?ooool0oooofP3oool00?l0ooooo`3ooooJ0?ooo`009@3oool4
000000@0oooo0P0000050?ooo`030000003oool0oooo06H0oooo0P00001A
0?ooo`030000003oool0oooo01P0oooo0P0000050?ooo`8000001P3oool0
0`000000oooo0?ooo`3o0?oook`0oooo000U0?ooo`8000001@3oool20000
00H0oooo00<000000?ooo`3oool0I@3oool200000580oooo0P00000J0?oo
o`8000001@3oool2000000D0oooo0P00003o0?oookd0oooo000500000080
oooo1P0000020?ooo`@000000`3oool400000080oooo0`0000020?ooo`80
00000P3oool2000000D0oooo0P0000040?ooo`@0000000<0oooo00000000
00000`0000040?ooo`@000000`3oool500000080oooo1P0000020?ooo`/0
00000`3oool3000000030?ooo`000000000000<00000103oool400000080
oooo0`000000103oool000000000000000020?ooo`<000006@3oool20000
00T0oooo0`0000020?ooo`<0000000<0oooo0000000000000P0000020?oo
o`H000000`3oool3000000<0oooo100000040?ooo`<000000P3oool60000
0080oooo100000030?ooo`H000002P3oool00`000000oooo0?ooo`090?oo
o`H000000P3oool4000000<0oooo0P0000050?ooo`8000001P3oool00`00
0000oooo0?ooo`3o0?oook/0oooo000200000080oooo0P0000030?ooo`80
00000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`03
0000003oool0oooo0080000000<0oooo0000000000000`3oool2000000D0
oooo0P0000040?ooo`030000003oool0oooo0080000000@0oooo00000000
0000oooo0P0000020?ooo`8000000`3oool010000000oooo0?ooo`3oool2
000000<0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`000000
000000<0oooo0P0000040?ooo`8000000P3oool010000000oooo00000000
00050?ooo`8000000P3oool200000080oooo0P0000000`3oool000000000
00020?ooo`8000000P3oool00`000000oooo0?ooo`0F0?ooo`8000002P3o
ool200000080oooo0P0000000`3oool00000000000030?ooo`040000003o
ool0oooo0?ooo`8000001@3oool300000080oooo0P0000030?ooo`030000
003oool0oooo008000000P3oool010000000oooo0?ooo`3oool2000000<0
oooo0P0000030?ooo`040000003oool0000000000080oooo0P00000;0?oo
o`800000303oool2000000D0oooo0P0000040?ooo`8000001@3oool20000
00H0oooo0P00003o0?oook`0oooo000200000080oooo0P0000030?ooo`80
00000`3oool200000080oooo0P0000000`3oool00000000000060?ooo`@0
0000103oool2000000@0oooo0P0000080?ooo`80000000<0oooo00000000
00000P3oool2000000030?ooo`000000000000L0oooo0P0000030?ooo`80
00000P3oool200000080oooo0P0000000`3oool00000000000030?ooo`80
0000103oool2000000@0oooo0P0000050?ooo`8000000P3oool200000080
oooo0P0000000`3oool00000000000020?ooo`8000002`3oool7000000P0
oooo0P00000;0?ooo`8000000P3oool2000000030?ooo`000000000000L0
oooo0P0000050?ooo`030000003oool000000080oooo0P0000060?ooo`80
00001P3oool2000000<0oooo0P0000050?ooo`8000000P3oool2000001T0
oooo0P0000020?ooo`H00000103oool2000000D0oooo0P00003o0?oool<0
oooo000200000080oooo0P0000030?ooo`8000000`3oool200000080oooo
0P0000000`3oool00000000000060?ooo`<000001@3oool2000000D0oooo
0P0000060?ooo`<0000000<0oooo0000000000000P3oool2000000030?oo
o`000000000000@000000`3oool2000000@0oooo1@0000020?ooo`800000
00<0oooo0000000000000`3oool2000000@0oooo0P0000040?ooo`800000
00<0oooo0000003oool00P3oool200000080oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool2000001/0oooo0P00000:0?ooo`800000
0P3oool2000000030?ooo`000000000000@000000`3oool2000000@0oooo
0P000000103oool000000000003oool600000080oooo0P0000060?ooo`80
00000`3oool2000000H0oooo1@00000I0?ooo`8000000P3oool00`000000
oooo0?ooo`02000000@0oooo0P0000050?ooo`800000o`3oooo40?ooo`00
1@0000040?ooo`8000000`3oool200000080oooo0P0000000`3oool00000
000000030?ooo`030000003oool0oooo00@00000103oool2000000D0oooo
0P0000040?ooo`@000000P3oool200000080oooo0P0000000`3oool00000
000000020?ooo`8000000`3oool2000000L0oooo0P0000020?ooo`800000
00<0oooo0000000000000`3oool2000000@0oooo0P0000040?ooo`@00000
0`3oool200000080oooo0P0000020?ooo`80000000<0oooo000000000000
0P3oool2000000/0oooo1`0000090?ooo`800000103oool00`000000oooo
000000030?ooo`H0000000<0oooo0000000000000P3oool2000000<0oooo
0P0000040?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`80
00000P3oool2000000H0oooo0P0000030?ooo`8000000`3oool00`000000
oooo0?ooo`030?ooo`8000000P3oool00`000000oooo0000000D0?ooo`80
00000`3oool010000000oooo0000000000040?ooo`8000001@3oool20000
0?l0ooooa03oool0008000000P3oool2000000<0oooo0P0000040?ooo`@0
00000`3oool500000080oooo0P0000000`3oool00000000000030?ooo`80
00001@3oool2000000@0oooo0P0000040?ooo`8000000P3oool200000080
oooo100000030?ooo`D000000P3oool400000080oooo0`0000000`3oool0
0000000000030?ooo`8000000`3oool500000080oooo0P000000103oool0
00000?ooo`0000020?ooo`@000000P3oool500000080oooo1@00000I0?oo
o`800000103oool00`000000oooo000000030?ooo`8000000P3oool20000
0080oooo100000040?ooo`8000000`3oool3000000050?ooo`0000000000
0000003oool0100000020?ooo`D000000P3oool4000000@0oooo1@000002
0?ooo`@000000`3oool00`000000oooo0000000D0?ooo`8000000`3oool0
10000000oooo0000000000040?ooo`8000001@3oool200000?l0ooooa03o
ool0008000000P3oool2000000<0oooo0P00000B0?ooo`8000001P3oool2
000000D0oooo0P0000040?ooo`8000000P3oool01@000000oooo00000000
0000oooo008000002`3oool2000001<0oooo0P0000040?ooo`800000103o
ool2000000<0oooo00<000000?ooo`3oool03P3oool2000001/0oooo0P00
00040?ooo`030000003oool0000000<0oooo0P0000020?ooo`8000002P3o
ool200000180oooo0P00000J0?ooo`030000003oool000000180oooo1000
00040?ooo`<00000103oool2000000D0oooo0P00003o0?oool@0oooo0005
00000080oooo1000000A0?ooo`<000001P3oool4000000@0oooo0P000004
0?ooo`T000003@3oool3000000l0oooo100000040?ooo`8000000`3oool7
00000100oooo0P00000L0?ooo`8000000`3oool00`000000oooo00000002
0?ooo`<000000P3oool3000000L0oooo1000000B0?ooo`8000001P3oool2
00000180oooo00<000000?ooo`000000503oool2000000D0oooo0P000003
0?ooo`8000001@3oool200000?l0ooooa@3oool003@0oooo00<000000?oo
o`3oool0o`3ooooo0?oooj<0oooo003o0?ooool0oooofP3oool00?l0oooo
o`3ooooJ0?ooo`00o`3ooooo0?ooomX0oooo003o0?ooool0oooofP3oool0
0001\
\>"], "Input",
  Evaluatable->False,
  ImageSize->{728, 252},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41618 
%%ImageSize: 1100 457.803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14  scalefont  setfont
% Scaling calculations
0.344477 0.320667 0.208092 0.320667 [
[ 0 0 0 0 ]
[ 1 .41618 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00990915 0.665143 0.406275 MathSubStart
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14  scalefont  setfont
% Scaling calculations
0.0238095 0.0453515 -0.106104 0.0309791 [
[.06916 -0.0125 -17.5 -14.875 ]
[.06916 -0.0125 17.5 0 ]
[.15986 -0.0125 -17.5 -14.875 ]
[.15986 -0.0125 17.5 0 ]
[.25057 -0.0125 -17.5 -14.875 ]
[.25057 -0.0125 17.5 0 ]
[.34127 -0.0125 -17.5 -14.875 ]
[.34127 -0.0125 17.5 0 ]
[.43197 -0.0125 -17.5 -14.875 ]
[.43197 -0.0125 17.5 0 ]
[.52268 -0.0125 -17.5 -14.875 ]
[.52268 -0.0125 17.5 0 ]
[.61338 -0.0125 -17.5 -14.875 ]
[.61338 -0.0125 17.5 0 ]
[.70408 -0.0125 -17.5 -14.875 ]
[.70408 -0.0125 17.5 0 ]
[.79478 -0.0125 -17.5 -14.875 ]
[.79478 -0.0125 17.5 0 ]
[.88549 -0.0125 -17.5 -14.875 ]
[.88549 -0.0125 17.5 0 ]
[.97619 -0.0125 -17.5 -14.875 ]
[.97619 -0.0125 17.5 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -15.5625 -29.8125 ]
[.5 -0.0125 15.5625 -14.875 ]
[-0.0125 .04879 -11.75 -7.4375 ]
[-0.0125 .04879 0 7.4375 ]
[-0.0125 .12624 -23.375 -7.4375 ]
[-0.0125 .12624 0 7.4375 ]
[-0.0125 .20369 -19.5 -7.4375 ]
[-0.0125 .20369 0 7.4375 ]
[-0.0125 .28114 -31.125 -7.4375 ]
[-0.0125 .28114 0 7.4375 ]
[-0.0125 .35858 -19.5 -7.4375 ]
[-0.0125 .35858 0 7.4375 ]
[-0.0125 .43603 -31.125 -7.4375 ]
[-0.0125 .43603 0 7.4375 ]
[-0.0125 .51348 -19.5 -7.4375 ]
[-0.0125 .51348 0 7.4375 ]
[-0.0125 .59093 -31.125 -7.4375 ]
[-0.0125 .59093 0 7.4375 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -217.938 -7.4375 ]
[-0.01875 .30902 -31.125 7.4375 ]
[ 0 .61803 .125 0 ]
[.5 .63053 -151.562 0 ]
[.5 .63053 151.562 15.25 ]
[ 1 0 .125 0 ]
[.5 .63053 -52.375 15.25 ]
[.5 .63053 52.375 49.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.06916 0 m
.06916 .00625 L
s
gsave
.06916 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1979) show
1.000 setlinewidth
grestore
.15986 0 m
.15986 .00625 L
s
gsave
.15986 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1981) show
1.000 setlinewidth
grestore
.25057 0 m
.25057 .00625 L
s
gsave
.25057 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1983) show
1.000 setlinewidth
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
1.000 setlinewidth
grestore
.43197 0 m
.43197 .00625 L
s
gsave
.43197 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1987) show
1.000 setlinewidth
grestore
.52268 0 m
.52268 .00625 L
s
gsave
.52268 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1989) show
1.000 setlinewidth
grestore
.61338 0 m
.61338 .00625 L
s
gsave
.61338 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1991) show
1.000 setlinewidth
grestore
.70408 0 m
.70408 .00625 L
s
gsave
.70408 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1993) show
1.000 setlinewidth
grestore
.79478 0 m
.79478 .00625 L
s
gsave
.79478 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
1.000 setlinewidth
grestore
.88549 0 m
.88549 .00625 L
s
gsave
.88549 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -78.5 -18.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
gsave
.5 -0.0125 -76.5625 -33.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(year) show
90.125 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .04879 m
.00625 .04879 L
s
gsave
-0.0125 .04879 -72.75 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
0 .12624 m
.00625 .12624 L
s
gsave
-0.0125 .12624 -84.375 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7.5) show
1.000 setlinewidth
grestore
0 .20369 m
.00625 .20369 L
s
gsave
-0.0125 .20369 -80.5 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
0 .28114 m
.00625 .28114 L
s
gsave
-0.0125 .28114 -92.125 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12.5) show
1.000 setlinewidth
grestore
0 .35858 m
.00625 .35858 L
s
gsave
-0.0125 .35858 -80.5 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
1.000 setlinewidth
grestore
0 .43603 m
.00625 .43603 L
s
gsave
-0.0125 .43603 -92.125 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(17.5) show
1.000 setlinewidth
grestore
0 .51348 m
.00625 .51348 L
s
gsave
-0.0125 .51348 -80.5 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
0 .59093 m
.00625 .59093 L
s
gsave
-0.0125 .59093 -92.125 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(22.5) show
1.000 setlinewidth
grestore
.125 Mabswid
0 .06428 m
.00375 .06428 L
s
0 .07977 m
.00375 .07977 L
s
0 .09526 m
.00375 .09526 L
s
0 .11075 m
.00375 .11075 L
s
0 .14173 m
.00375 .14173 L
s
0 .15722 m
.00375 .15722 L
s
0 .17271 m
.00375 .17271 L
s
0 .1882 m
.00375 .1882 L
s
0 .21918 m
.00375 .21918 L
s
0 .23467 m
.00375 .23467 L
s
0 .25016 m
.00375 .25016 L
s
0 .26565 m
.00375 .26565 L
s
0 .29663 m
.00375 .29663 L
s
0 .31211 m
.00375 .31211 L
s
0 .3276 m
.00375 .3276 L
s
0 .34309 m
.00375 .34309 L
s
0 .37407 m
.00375 .37407 L
s
0 .38956 m
.00375 .38956 L
s
0 .40505 m
.00375 .40505 L
s
0 .42054 m
.00375 .42054 L
s
0 .45152 m
.00375 .45152 L
s
0 .46701 m
.00375 .46701 L
s
0 .4825 m
.00375 .4825 L
s
0 .49799 m
.00375 .49799 L
s
0 .52897 m
.00375 .52897 L
s
0 .54446 m
.00375 .54446 L
s
0 .55995 m
.00375 .55995 L
s
0 .57544 m
.00375 .57544 L
s
0 .0333 m
.00375 .0333 L
s
0 .01781 m
.00375 .01781 L
s
0 .00232 m
.00375 .00232 L
s
0 .60642 m
.00375 .60642 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -278.938 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rates) show
103.312 15.000 moveto
(per) show
127.312 15.000 moveto
(100) show
150.562 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
154.438 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(000) show
181.562 15.000 moveto
(population) show
245.812 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .61803 m
1 .61803 L
s
gsave
.5 .63053 -212.562 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6.17) show
94.000 15.188 moveto
(Death) show
135.062 15.188 moveto
(rates) show
169.938 15.188 moveto
(from) show
201.688 15.188 moveto
(road) show
233.438 15.188 moveto
(accidents) show
292.375 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(:) show
300.125 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(by) show
318.750 15.188 moveto
(gender) show
362.125 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .04879 m
1 .04879 L
s
.99375 .12624 m
1 .12624 L
s
.99375 .20369 m
1 .20369 L
s
.99375 .28114 m
1 .28114 L
s
.99375 .35858 m
1 .35858 L
s
.99375 .43603 m
1 .43603 L
s
.99375 .51348 m
1 .51348 L
s
.99375 .59093 m
1 .59093 L
s
.125 Mabswid
.99625 .06428 m
1 .06428 L
s
.99625 .07977 m
1 .07977 L
s
.99625 .09526 m
1 .09526 L
s
.99625 .11075 m
1 .11075 L
s
.99625 .14173 m
1 .14173 L
s
.99625 .15722 m
1 .15722 L
s
.99625 .17271 m
1 .17271 L
s
.99625 .1882 m
1 .1882 L
s
.99625 .21918 m
1 .21918 L
s
.99625 .23467 m
1 .23467 L
s
.99625 .25016 m
1 .25016 L
s
.99625 .26565 m
1 .26565 L
s
.99625 .29663 m
1 .29663 L
s
.99625 .31211 m
1 .31211 L
s
.99625 .3276 m
1 .3276 L
s
.99625 .34309 m
1 .34309 L
s
.99625 .37407 m
1 .37407 L
s
.99625 .38956 m
1 .38956 L
s
.99625 .40505 m
1 .40505 L
s
.99625 .42054 m
1 .42054 L
s
.99625 .45152 m
1 .45152 L
s
.99625 .46701 m
1 .46701 L
s
.99625 .4825 m
1 .4825 L
s
.99625 .49799 m
1 .49799 L
s
.99625 .52897 m
1 .52897 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .55995 m
1 .55995 L
s
.99625 .57544 m
1 .57544 L
s
.99625 .0333 m
1 .0333 L
s
.99625 .01781 m
1 .01781 L
s
.99625 .00232 m
1 .00232 L
s
.99625 .60642 m
1 .60642 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -113.375 11.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 42.625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 18.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Great) show
112.938 18.250 moveto
(Britain) show
63.000 34.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.06916 .60332 m
.11451 .53826 L
.15986 .52897 L
.20522 .52587 L
.25057 .47321 L
.29592 .4856 L
.34127 .42984 L
.38662 .44842 L
.43197 .42364 L
.47732 .41435 L
.52268 .44533 L
.56803 .42364 L
.61338 .35549 L
.65873 .31831 L
.70408 .27184 L
.74943 .25635 L
.79478 .25325 L
.84014 .25945 L
.88549 .25945 L
.93084 .23157 L
.97619 .23776 L
s
0 g
.0001 w
.06916 .60332 0 8 Mabsadd m
.06916 .60332 -7.60845 2.47214 Mabsadd L
.06916 .60332 -4.70228 -6.47214 Mabsadd L
.06916 .60332 4.70228 -6.47214 Mabsadd L
.06916 .60332 7.60845 2.47214 Mabsadd L
.06916 .60332 0 8 Mabsadd L s
.11451 .53826 0 8 Mabsadd m
.11451 .53826 -7.60845 2.47214 Mabsadd L
.11451 .53826 -4.70228 -6.47214 Mabsadd L
.11451 .53826 4.70228 -6.47214 Mabsadd L
.11451 .53826 7.60845 2.47214 Mabsadd L
.11451 .53826 0 8 Mabsadd L s
.15986 .52897 0 8 Mabsadd m
.15986 .52897 -7.60845 2.47214 Mabsadd L
.15986 .52897 -4.70228 -6.47214 Mabsadd L
.15986 .52897 4.70228 -6.47214 Mabsadd L
.15986 .52897 7.60845 2.47214 Mabsadd L
.15986 .52897 0 8 Mabsadd L s
.20522 .52587 0 8 Mabsadd m
.20522 .52587 -7.60845 2.47214 Mabsadd L
.20522 .52587 -4.70228 -6.47214 Mabsadd L
.20522 .52587 4.70228 -6.47214 Mabsadd L
.20522 .52587 7.60845 2.47214 Mabsadd L
.20522 .52587 0 8 Mabsadd L s
.25057 .47321 0 8 Mabsadd m
.25057 .47321 -7.60845 2.47214 Mabsadd L
.25057 .47321 -4.70228 -6.47214 Mabsadd L
.25057 .47321 4.70228 -6.47214 Mabsadd L
.25057 .47321 7.60845 2.47214 Mabsadd L
.25057 .47321 0 8 Mabsadd L s
.29592 .4856 0 8 Mabsadd m
.29592 .4856 -7.60845 2.47214 Mabsadd L
.29592 .4856 -4.70228 -6.47214 Mabsadd L
.29592 .4856 4.70228 -6.47214 Mabsadd L
.29592 .4856 7.60845 2.47214 Mabsadd L
.29592 .4856 0 8 Mabsadd L s
.34127 .42984 0 8 Mabsadd m
.34127 .42984 -7.60845 2.47214 Mabsadd L
.34127 .42984 -4.70228 -6.47214 Mabsadd L
.34127 .42984 4.70228 -6.47214 Mabsadd L
.34127 .42984 7.60845 2.47214 Mabsadd L
.34127 .42984 0 8 Mabsadd L s
.38662 .44842 0 8 Mabsadd m
.38662 .44842 -7.60845 2.47214 Mabsadd L
.38662 .44842 -4.70228 -6.47214 Mabsadd L
.38662 .44842 4.70228 -6.47214 Mabsadd L
.38662 .44842 7.60845 2.47214 Mabsadd L
.38662 .44842 0 8 Mabsadd L s
.43197 .42364 0 8 Mabsadd m
.43197 .42364 -7.60845 2.47214 Mabsadd L
.43197 .42364 -4.70228 -6.47214 Mabsadd L
.43197 .42364 4.70228 -6.47214 Mabsadd L
.43197 .42364 7.60845 2.47214 Mabsadd L
.43197 .42364 0 8 Mabsadd L s
.47732 .41435 0 8 Mabsadd m
.47732 .41435 -7.60845 2.47214 Mabsadd L
.47732 .41435 -4.70228 -6.47214 Mabsadd L
.47732 .41435 4.70228 -6.47214 Mabsadd L
.47732 .41435 7.60845 2.47214 Mabsadd L
.47732 .41435 0 8 Mabsadd L s
.52268 .44533 0 8 Mabsadd m
.52268 .44533 -7.60845 2.47214 Mabsadd L
.52268 .44533 -4.70228 -6.47214 Mabsadd L
.52268 .44533 4.70228 -6.47214 Mabsadd L
.52268 .44533 7.60845 2.47214 Mabsadd L
.52268 .44533 0 8 Mabsadd L s
.56803 .42364 0 8 Mabsadd m
.56803 .42364 -7.60845 2.47214 Mabsadd L
.56803 .42364 -4.70228 -6.47214 Mabsadd L
.56803 .42364 4.70228 -6.47214 Mabsadd L
.56803 .42364 7.60845 2.47214 Mabsadd L
.56803 .42364 0 8 Mabsadd L s
.61338 .35549 0 8 Mabsadd m
.61338 .35549 -7.60845 2.47214 Mabsadd L
.61338 .35549 -4.70228 -6.47214 Mabsadd L
.61338 .35549 4.70228 -6.47214 Mabsadd L
.61338 .35549 7.60845 2.47214 Mabsadd L
.61338 .35549 0 8 Mabsadd L s
.65873 .31831 0 8 Mabsadd m
.65873 .31831 -7.60845 2.47214 Mabsadd L
.65873 .31831 -4.70228 -6.47214 Mabsadd L
.65873 .31831 4.70228 -6.47214 Mabsadd L
.65873 .31831 7.60845 2.47214 Mabsadd L
.65873 .31831 0 8 Mabsadd L s
.70408 .27184 0 8 Mabsadd m
.70408 .27184 -7.60845 2.47214 Mabsadd L
.70408 .27184 -4.70228 -6.47214 Mabsadd L
.70408 .27184 4.70228 -6.47214 Mabsadd L
.70408 .27184 7.60845 2.47214 Mabsadd L
.70408 .27184 0 8 Mabsadd L s
.74943 .25635 0 8 Mabsadd m
.74943 .25635 -7.60845 2.47214 Mabsadd L
.74943 .25635 -4.70228 -6.47214 Mabsadd L
.74943 .25635 4.70228 -6.47214 Mabsadd L
.74943 .25635 7.60845 2.47214 Mabsadd L
.74943 .25635 0 8 Mabsadd L s
.79478 .25325 0 8 Mabsadd m
.79478 .25325 -7.60845 2.47214 Mabsadd L
.79478 .25325 -4.70228 -6.47214 Mabsadd L
.79478 .25325 4.70228 -6.47214 Mabsadd L
.79478 .25325 7.60845 2.47214 Mabsadd L
.79478 .25325 0 8 Mabsadd L s
.84014 .25945 0 8 Mabsadd m
.84014 .25945 -7.60845 2.47214 Mabsadd L
.84014 .25945 -4.70228 -6.47214 Mabsadd L
.84014 .25945 4.70228 -6.47214 Mabsadd L
.84014 .25945 7.60845 2.47214 Mabsadd L
.84014 .25945 0 8 Mabsadd L s
.88549 .25945 0 8 Mabsadd m
.88549 .25945 -7.60845 2.47214 Mabsadd L
.88549 .25945 -4.70228 -6.47214 Mabsadd L
.88549 .25945 4.70228 -6.47214 Mabsadd L
.88549 .25945 7.60845 2.47214 Mabsadd L
.88549 .25945 0 8 Mabsadd L s
.93084 .23157 0 8 Mabsadd m
.93084 .23157 -7.60845 2.47214 Mabsadd L
.93084 .23157 -4.70228 -6.47214 Mabsadd L
.93084 .23157 4.70228 -6.47214 Mabsadd L
.93084 .23157 7.60845 2.47214 Mabsadd L
.93084 .23157 0 8 Mabsadd L s
.97619 .23776 0 8 Mabsadd m
.97619 .23776 -7.60845 2.47214 Mabsadd L
.97619 .23776 -4.70228 -6.47214 Mabsadd L
.97619 .23776 4.70228 -6.47214 Mabsadd L
.97619 .23776 7.60845 2.47214 Mabsadd L
.97619 .23776 0 8 Mabsadd L s
0 1 0 r
.008 w
.06916 .13863 m
.11451 .13553 L
.15986 .12624 L
.20522 .13553 L
.25057 .11075 L
.29592 .11385 L
.34127 .10146 L
.38662 .10765 L
.43197 .09526 L
.47732 .08907 L
.52268 .10146 L
.56803 .09836 L
.61338 .07358 L
.65873 .06118 L
.70408 .04879 L
.74943 .0395 L
.79478 .0364 L
.84014 .02711 L
.88549 .02401 L
.93084 .02401 L
.97619 .01472 L
s
0 g
.0001 w
.06916 .13863 0 8 Mabsadd m
.06916 .13863 -6.928 -4 Mabsadd L
.06916 .13863 6.928 -4 Mabsadd L
.06916 .13863 0 8 Mabsadd L closepath F
.11451 .13553 0 8 Mabsadd m
.11451 .13553 -6.928 -4 Mabsadd L
.11451 .13553 6.928 -4 Mabsadd L
.11451 .13553 0 8 Mabsadd L closepath F
.15986 .12624 0 8 Mabsadd m
.15986 .12624 -6.928 -4 Mabsadd L
.15986 .12624 6.928 -4 Mabsadd L
.15986 .12624 0 8 Mabsadd L closepath F
.20522 .13553 0 8 Mabsadd m
.20522 .13553 -6.928 -4 Mabsadd L
.20522 .13553 6.928 -4 Mabsadd L
.20522 .13553 0 8 Mabsadd L closepath F
.25057 .11075 0 8 Mabsadd m
.25057 .11075 -6.928 -4 Mabsadd L
.25057 .11075 6.928 -4 Mabsadd L
.25057 .11075 0 8 Mabsadd L closepath F
.29592 .11385 0 8 Mabsadd m
.29592 .11385 -6.928 -4 Mabsadd L
.29592 .11385 6.928 -4 Mabsadd L
.29592 .11385 0 8 Mabsadd L closepath F
.34127 .10146 0 8 Mabsadd m
.34127 .10146 -6.928 -4 Mabsadd L
.34127 .10146 6.928 -4 Mabsadd L
.34127 .10146 0 8 Mabsadd L closepath F
.38662 .10765 0 8 Mabsadd m
.38662 .10765 -6.928 -4 Mabsadd L
.38662 .10765 6.928 -4 Mabsadd L
.38662 .10765 0 8 Mabsadd L closepath F
.43197 .09526 0 8 Mabsadd m
.43197 .09526 -6.928 -4 Mabsadd L
.43197 .09526 6.928 -4 Mabsadd L
.43197 .09526 0 8 Mabsadd L closepath F
.47732 .08907 0 8 Mabsadd m
.47732 .08907 -6.928 -4 Mabsadd L
.47732 .08907 6.928 -4 Mabsadd L
.47732 .08907 0 8 Mabsadd L closepath F
.52268 .10146 0 8 Mabsadd m
.52268 .10146 -6.928 -4 Mabsadd L
.52268 .10146 6.928 -4 Mabsadd L
.52268 .10146 0 8 Mabsadd L closepath F
.56803 .09836 0 8 Mabsadd m
.56803 .09836 -6.928 -4 Mabsadd L
.56803 .09836 6.928 -4 Mabsadd L
.56803 .09836 0 8 Mabsadd L closepath F
.61338 .07358 0 8 Mabsadd m
.61338 .07358 -6.928 -4 Mabsadd L
.61338 .07358 6.928 -4 Mabsadd L
.61338 .07358 0 8 Mabsadd L closepath F
.65873 .06118 0 8 Mabsadd m
.65873 .06118 -6.928 -4 Mabsadd L
.65873 .06118 6.928 -4 Mabsadd L
.65873 .06118 0 8 Mabsadd L closepath F
.70408 .04879 0 8 Mabsadd m
.70408 .04879 -6.928 -4 Mabsadd L
.70408 .04879 6.928 -4 Mabsadd L
.70408 .04879 0 8 Mabsadd L closepath F
.74943 .0395 0 8 Mabsadd m
.74943 .0395 -6.928 -4 Mabsadd L
.74943 .0395 6.928 -4 Mabsadd L
.74943 .0395 0 8 Mabsadd L closepath F
.79478 .0364 0 8 Mabsadd m
.79478 .0364 -6.928 -4 Mabsadd L
.79478 .0364 6.928 -4 Mabsadd L
.79478 .0364 0 8 Mabsadd L closepath F
.84014 .02711 0 8 Mabsadd m
.84014 .02711 -6.928 -4 Mabsadd L
.84014 .02711 6.928 -4 Mabsadd L
.84014 .02711 0 8 Mabsadd L closepath F
.88549 .02401 0 8 Mabsadd m
.88549 .02401 -6.928 -4 Mabsadd L
.88549 .02401 6.928 -4 Mabsadd L
.88549 .02401 0 8 Mabsadd L closepath F
.93084 .02401 0 8 Mabsadd m
.93084 .02401 -6.928 -4 Mabsadd L
.93084 .02401 6.928 -4 Mabsadd L
.93084 .02401 0 8 Mabsadd L closepath F
.97619 .01472 0 8 Mabsadd m
.97619 .01472 -6.928 -4 Mabsadd L
.97619 .01472 6.928 -4 Mabsadd L
.97619 .01472 0 8 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71966 .05417 m
.71966 .24657 L
.97619 .24657 L
.97619 .05417 L
F
.8 g
.69721 .07983 m
.69721 .27223 L
.95374 .27223 L
.95374 .07983 L
F
0 g
.001 w
[ ] 0 setdash
.69721 .07983 m
.95374 .07983 L
.95374 .27223 L
.69721 .27223 L
.69721 .07983 L
s
% Start of sub-graphic
p
0.69721 0.0798255 0.953744 0.272226 MathSubStart
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0535714 0.0535714 0.35119 0.35119 MathSubStart
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 0 r
.0374 w
[ ] 0 setdash
0 .5 m
1 .5 L
s
0 g
.00047 w
.5 .5 0 8 Mabsadd m
.5 .5 -6.928 -4 Mabsadd L
.5 .5 6.928 -4 Mabsadd L
.5 .5 0 8 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .20238 -61 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Women) show
111.062 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.0535714 0.39881 0.35119 0.696429 MathSubStart
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.0374 w
[ ] 0 setdash
0 .5 m
1 .5 L
s
0 g
.00047 w
.5 .5 0 8 Mabsadd m
.5 .5 -7.60845 2.47214 Mabsadd L
.5 .5 -4.70228 -6.47214 Mabsadd L
.5 .5 4.70228 -6.47214 Mabsadd L
.5 .5 7.60845 2.47214 Mabsadd L
.5 .5 0 8 Mabsadd L s
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .54762 -61 -11.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Men) show
90.125 15.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41618 L
0 .41618 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{1100, 457.75},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000A<0001bB000`400?l00000o`00003oo`3ooooo
0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0
ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3o
oom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?oo
o`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3o
oooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?oo
ool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0oooo
o`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@
0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00
o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo
0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0
ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3o
oom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?oo
o`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3o
oooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?oo
ool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0oooo
o`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@
0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00
o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooM0?ooo`800000o`3ooooo0?ooog00oooo003o
0?ooomh0oooo0P00003o0?ooool0ooooK`3oool00?l0oooog`3oool00`000000oooo0?ooo`3o0?oo
ool0ooooK@3oool00?l0oooog`3oool00`000000oooo0?ooo`030?ooo`@00000103oool300000005
0?ooo`00000000000?ooo`000000o`3ooooo0?oooeX0oooo003o0?oooml0oooo0P0000030?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`3o0?ooool0
ooooF03oool00?l0oooogP3oool00`000000oooo000000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00003o0?ooool0ooooFP3oool00?l0oooo
gP3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`04
0000003oool0oooo00000?l0ooooo`3ooomJ0?ooo`00o`3ooooM0?ooo`050000003oool0oooo0?oo
o`0000000P3oool6000000<0oooo1@0000020?ooo`030000003oool0oooo0?l0ooooo`3ooomH0?oo
o`00o`3ooooM0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000o`3ooooo0?oooeX0oooo003o0?oo
om`0oooo00<000000?ooo`3oool00`3oool010000000oooo0000000000020?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`800000o`3ooooo0?oooeT0oooo003o0?ooom`0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`04000000@0oooo100000030?ooo`040000003oool00000
00000?l0ooooo`3ooomG0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0
ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3o
oom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooooo0?ooool0ooooo`3ooom@0?oo
o`00o`3ooooo0?ooool0ooooo`3ooom@0?ooo`00o`3ooolC0?ooo`030000003oool0oooo00<0oooo
100000040?ooo`030000003oool0oooo00D0oooo1000000A0?ooo`030000003oool0oooo00<0oooo
100000040?ooo`@000001P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo
100000040?ooo`@00000103oool400000100oooo00<000000?ooo`3oool00`3oool4000000@0oooo
100000040?ooo`@000004@3oool00`000000oooo0?ooo`030?ooo`@00000103oool4000000@0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`030?ooo`@00000103oool4000000@0oooo
1000000@0?ooo`030000003oool0oooo00<0oooo100000040?ooo`@000001P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00<0oooo100000040?ooo`@00000103oool400000140oooo
00<000000?ooo`3oool00`3oool4000000@0oooo100000040?ooo`@00000403oool00`000000oooo
0?ooo`030?ooo`@00000103oool4000000@0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`030?ooo`@00000103oool4000000@0oooo1000003o0?ooogH0oooo003o0?oooa<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
1P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool00000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0
oooo00D000000?ooo`3oool0oooo0000000D0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000001@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
00@0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?ooog<0oooo003o0?oo
oa<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
00040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`3o0?ooog<0oooo003o0?oooa<0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0l0?ooool000006`00000L0?oo
o`00o`3ooolC0?ooo`030000003oool0oooo00<0oooo1@0000050?ooo`030000003oool0oooo00<0
oooo1@00000@0?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0
oooo1@0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0
oooo1@0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool0oooo1@00000?0?ooo`030000003oool0oooo00<0oooo1@0000030?oo
o`D000001@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo1@0000030?oo
o`D000001`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo1@0000030?oo
o`D000001`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo1@0000030?oo
o`D000001@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo1@0000030?oo
o`D000000`3oool5000003h0ooooo`00000K000001`0oooo003o0?oooa<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`@000001P3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`3oool4000000D0oooo0`00000@0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`3oool4000000<0oooo1@00000A0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool4000000H0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool0oooo100000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P3oool300000140oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01@00000@0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo03`0ooooo`00000K000001`0oooo003o0?oooa<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
103oool010000000oooo0?ooo`00000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00000D0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo03`0ooooo`00000K000001`0oooo003o0?oooa<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
103oool010000000oooo0?ooo`00000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00000D0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo03`0ooooo`00000K000001`0oooo003o0?oooa40oooo0`0000040?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo00`0oooo0`0000040?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000103oool010000000oooo0?ooo`3oool300000100oooo0`0000040?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo00/0oooo0`0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool00000103oool010000000oooo0?ooo`00000C0?ooo`<00000103oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0<0?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0;0?ooo`<00000103oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool0oooo0`00000@
0?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`0<0?ooo`<00000103oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000004P3oool30000
00@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0303oool3000000@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
?03ooooo000001/00000703oool00?l0oooo4`3oool00`000000oooo0?ooo`030?ooo`@000000`3o
ool6000000<0oooo1000000A0?ooo`030000003oool0oooo00<0oooo100000040?ooo`@000001P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo100000040?ooo`@00000103o
ool400000100oooo00<000000?ooo`3oool00`3oool4000000@0oooo100000030?ooo`H00000403o
ool00`000000oooo0?ooo`030?ooo`@00000103oool4000000<0oooo1P00000@0?ooo`030000003o
ool0oooo00<0oooo100000040?ooo`@00000103oool400000100oooo00<000000?ooo`3oool00`3o
ool4000000@0oooo100000060?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00`3o
ool4000000@0oooo100000040?ooo`@000004@3oool00`000000oooo0?ooo`030?ooo`@00000103o
ool4000000<0oooo1P00000?0?ooo`030000003oool0oooo00<0oooo100000040?ooo`@000000`3o
ool600000100oooo00<000000?ooo`3oool00`3oool4000000@0oooo100000040?ooo`@00000?`3o
oooo000001/00000703oool00?l0ooooo`3ooooo0?oooaT0ooooo`00000K000001`0oooo003o0?oo
ool0ooooo`3ooolI0?ooool000006`00000L0?ooo`00o`3ooooo0?ooool0oooo6@3ooooo000001/0
0000703oool00?l0ooooo`3ooooo0?oooaT0ooooo`00000K000001`0oooo003o0?ooool0ooooo`3o
oolI0?ooool000006`00000L0?ooo`00o`3ooooo0?ooool0oooo6@3ooooo000001/00000703oool0
0?d0ooooo`00003I00000440ooooo`00000K000001`0oooo003m0?ooo`<000007P3oool00`000000
oooo0?ooo`0W0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0W0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo00H0oooo0`0000110?ooool000006`00000L0?ooo`00
o@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0o0?ooool000006`00000L0?ooo`00o@3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0o0?ooool000006`00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oool@0oooo3@000004
0?ooo`030000003oool0oooo03l0ooooo`00000K000001`0oooo003m0?ooo`030000003oool0oooo
0?l0ooooa@3oool;000000D0oooo00<000000?ooo`3oool0?`3ooooo000001/00000703oool00?d0
oooo00<000000?ooo`3oool0o`3oooo50?ooo`/000001@3oool00`000000oooo0?ooo`0o0?ooool0
00006`00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oool80oooo1000o`09000000H0oooo
00<000000?ooo`3oool0?`3ooooo000001/00000703oool00?d0oooo0`00003o0?oooiT0oooo3@00
00080?ooo`d000000P3oool9003o00T00000103oool300000440ooooo`00000K000001`0oooo003m
0?ooo`030000003oool0oooo0?l0ooooQ03oool=000000T0oooo2`00000:0?ooo`/000003@00o`07
000000L0oooo00<000000?ooo`3oool0?`3ooooo000001/00000703oool00?d0oooo00<000000?oo
o`3oool0o`3ooon50?ooo`/000001@3oool5003o00/000002P00o`0;000000P00?l01P3oool50000
00P0oooo00<000000?ooo`3oool0?`3ooooo000001/00000703oool00?d0oooo00<000000?ooo`3o
ool0o`3ooon50?ooo`/000002`00o`09000000`00?l02@000004003o00/0oooo1@0000080?ooo`03
0000003oool0oooo03l0ooooo`00000K000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo
Q03oool2003o00T000003000o`09000000`00?l02@00000@0?ooo`<000002@3oool00`000000oooo
0?ooo`0o0?ooool000006`00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooogl0oooo1`00
o`09000000H00?l01`3oool7000000h0oooo1`00000A0?ooo`<000002@3oool00`000000oooo0?oo
o`0o0?ooool000006`00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooofh0oooo3@00000<
003o00L000003`3oool500000100oooo1@00000C0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool09P3ooooo000003@00000703oool00?d0oooo0`00003o0?oooeT0oooo3@0000090?oo
o`/000002P00o`040?ooo`D00000403oool500000100oooo1@00000L0?ooo`<00000:03oool00`00
0000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oooeX0
oooo2`0000050?ooo`D00?l02`000006003o00P0oooo1@00000A0?ooo`<000004P3oool3000001l0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00
o@3oool00`000000oooo0?ooo`3o0?oooeX0oooo2`00000;003o00T000000P00o`0>0?ooo`<00000
4P3oool300000180oooo0`00000O0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0
o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooomI0?ooo`800?l02@00
000<003o00T00000403oool3000001<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703o
ool00?d0oooo00<000000?ooo`3oool0o`3ooomE0?ooo`H00?l02@000006003o00L0oooo1`00000B
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o
0<c<c1P0c<c<6@00000L0?ooo`00l03oool4000000T0oooo00<000000?ooo`3oool0o`3ooom40?oo
o`d000002`00o`07000000l0oooo1@00001N0?ooo`030000003oool0oooo02H0oooo00<000000<c<
c03<c<`0o`3<c<`H0<c<c1T00000703oool00>l0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0?l0ooooA@3oool;000000T00?l0103oool500000100
oooo1@00001N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T0
0000703oool00>l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0?l0ooooA@3oool;000000D00?l0203oool500000140oooo0`00001O0?ooo`030000
003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?@0oooo00<0
00000?ooo`3oool01P3oool400000?l0oooo@`3oool2003o00T000000P00o`0=0?ooo`<000004P3o
ool3000005`0oooo1000000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003d
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooolo0?ooo`L00?l02@00000?
0?ooo`<000004`3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo02H0oooo00<00000
0<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00>l0oooo1@0000090?ooo`030000003oool0oooo
0?l0oooo;P3oool=000000`00?l01`00000A0?ooo`030000003oool0oooo07<0oooo00<000000?oo
o`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00k`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo;`3oool;000000X00?l0103oool5000008P0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00
k`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo;`3oool;000000H00?l0
203oool5000008P0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<
6@00000L0?ooo`00k`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo;`3o
ool00`00o`00000000000007000000800?l03P3oool3000008T0oooo00<000000?ooo`3oool09P3o
ool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00k`3oool6000000P0oooo00<00000
0?ooo`3oool0o`3oool/0?ooo`@00?l02@00000@0?ooo`<00000R@3oool00`000000oooo0?ooo`0V
0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`<00000o`3ooolX0?oo
o`T00?l01`00000B0?ooo`030000003oool0oooo08H0oooo0`00000X0?ooo`030000003<c<`0c<c<
0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo6@3oool=000000T0
0?l00`3oool5000009h0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0
c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oooaX0oooo2`000007003o00H0oooo
1@00002N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo00<000000?ooo`3oool0o`3ooolJ0?ooo`/000000`00o`0;0?ooo`<00000W`3o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m
0?ooo`030000003oool0oooo0?l0oooo6`3oool900000003003o003oool0oooo00`0oooo0`00002O
0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool0
0?d0oooo00<000000?ooo`3oool0o`3ooolK0?ooo`T00000403oool00`000000oooo0?ooo`2N0?oo
o`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0
oooo00<000000?ooo`3oool0o`3ooolI0?ooo`<00?l01`00002b0?ooo`030000003oool0oooo02H0
oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo0`00003o0?oooaL0oooo
1P00o`0500000;40oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo
003m0?ooo`030000003oool0oooo0?l0oooo5@3oool7003o00030?ooo`000000000000<00000/`3o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m
0?ooo`030000003oool0oooo0=P0oooo3@00000^0?ooo`H00?l0103oool300000;@0oooo00<00000
0?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`00
0000oooo0?ooo`3I0?ooo`/00000;@3oool6003o00H0oooo0`00002d0?ooo`030000003oool0oooo
02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3o
ool0``3oool<000000X0oooo2`00000[0?ooo`H00?l02@3oool00`000000oooo0?ooo`2c0?ooo`03
0000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo
00<000000?ooo`3oool0``3oool;000000`00?l02@000002003o02P0oooo1`00o`300?ooo`030000
003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<0
00000?ooo`3oool0a03oool:000000`00?l02@000006003o01X0oooo30000003003o0<80oooo00<0
00000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool3
000009P0oooo3@00000N0?ooo`03003o00000000000000L000003000o`020?ooo`L000002`00o`0=
000000X0oooo2P000002003o0<80oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I
000001`0oooo003m0?ooo`030000003oool0oooo09T0oooo2`00000L0?ooo`D00?l0200000000`00
o`00oooo0?ooo`0<0?ooo`D00000103oool9003o00/000001@3oool6003o00X00000aP3oool00`00
0000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`03
0000003oool0oooo09T0oooo2`00000H0?ooo`T00?l01`00000@0?ooo`D00000203oool5003o00/0
00003000o`0800000<L0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0
c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`2I0?ooo`03003o00000000000000L00000
1P00o`040?ooo`d000002@00o`030?ooo`D000004P3oool3000000d0oooo0P00o`09000000d00?l0
200000370?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo00<000000?ooo`3oool0U@3oool5003o00T000002`00o`0;000000L00?l01P3o
ool500000180oooo0`00000?0?ooo`T000001`00o`070?ooo`H00000b03oool00`000000oooo0?oo
o`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0
oooo06d0oooo3@00000G0?ooo`X00?l01`00000<003o00/000000`00o`0;0?ooo`<00000503oool0
0`000000oooo0?ooo`0?0?ooo`L00000403oool500000<P0oooo00<000000?ooo`3oool09P3oool0
0`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`1^0?oo
o`/000002P3oool<000000X00?l00`3oool5000000P0oooo1P00o`0900000003003o003oool0oooo
00`0oooo0`00000W0?ooo`D000004@3oool400000<T0oooo00<000000?ooo`3oool09P3oool00`00
0000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`1^0?ooo`/0
00001@00o`050?ooo`/000002000o`060?ooo`D000003P3oool900000100oooo00<000000?ooo`3o
ool09P3oool500000180oooo0`0000390?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<
c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo0`00001_0?ooo`T000003000o`0:000000@00?l0
2`3oool300000100oooo1`00000k0?ooo`<000004`3oool200000<P0oooo0`00000X0?ooo`030000
003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo06h0oooo00<0
0?l00000000000001`00000<003o00T0000000<00?l00?ooo`3oool03@3oool300000140oooo1@00
000l0?ooo`<00000503oool00`000000oooo0?ooo`380?ooo`030000003oool0oooo02H0oooo00<0
00000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0K03oool4
003o00L000001`3oool7003o00P000004@3oool00`000000oooo0?ooo`0@0?ooo`D00000?@3oool0
0`000000oooo0?ooo`3N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H
0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0J`3oool6003o00D000003`3oool70000
02H0oooo0`00003o0?ooob00oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<
c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`120?ooo`d000006P3oool6003o0080
oooo1@00000@0?ooo`D000009`3oool300000?l0oooo803oool00`000000oooo0?ooo`0V0?ooo`03
0000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003T0?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`3oool0oooo1000000:0?ooo`030000003oool0oooo04<0oooo2`00000I0?ooo`H0
0?l01@3oool300000140oooo1@00000X0?ooo`030000003oool0oooo0?l0oooo7`3oool00`000000
oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003T0?ooo`030000
003oool0oooo00@0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo04<0oooo2`00000G0?ooo`H00?l01`3oool300000180oooo0`00003o0?oood/0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00
i@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1`3oool4000003l0oooo1000o`09000000@00?l04P3oool6003o00X0oooo00<000000?ooo`3oool0
4@3oool300000?l0ooooB03oool4000002P0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00>D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo02d0oooo3@0000000`3oool00?l0003o0007003o00T000002@00o`020?ooo`d000000P00
o`0Q0?ooo`030000003oool0oooo0?l0ooooBP3oool00`000000oooo0?ooo`0V0?ooo`030000003<
c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003V0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0^0?ooo`/000003000o`07000000d00?l02`000002
003o0?l0ooooK`3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I
000001`0oooo003V0?ooo`030000003oool0oooo00D0oooo1@00000:0?ooo`030000003oool0oooo
01P0oooo3@0000090?ooo`/000002000o`050?ooo`D000001P3oool8003o00/00000o`3oooma0?oo
o`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00>L0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01T0
oooo2`00000;003o00T000001000o`0:0?ooo`D000002`3oool4003o00T00000o`3ooomb0?ooo`03
0000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00>L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01T0oooo
2`00000;003o00T000003`3oool300000100oooo2@00003o0?ooog80oooo00<000000?ooo`3oool0
9P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00j03oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06P3oool9000000/00?l00P3o
ool700000100oooo0`00000A0?ooo`L00000o`3ooomc0?ooo`030000003oool0oooo02H0oooo00<0
00000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00><0oooo1P0000050?ooo`H000002@3oool3
000001X0oooo2@0000000`00o`00oooo0?ooo`0;0?ooo`D000004P3oool00`000000oooo0?ooo`0A
0?ooo`D00000o`3ooomb0?ooo`<00000:03oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L
0?ooo`00o@3oool00`000000oooo0?ooo`0K0?ooo`L000003`3oool5000002H0oooo1@00003o0?oo
og@0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?oo
o`00o@3oool00`000000oooo0?ooo`0L0?ooo`D000004@3oool3000002P0oooo0`00003o0?ooogD0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c00`0<c<c0d00000fP3<c<`I000001`0
oooo003m0?ooo`030000003oool0oooo01`0oooo1@00000A0?ooo`<00000:03oool300000?l0oooo
M@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0340c<c<2`00000e0<c<c0030000
003<c<`0c<c<00<0c<c<00<000000<c<c03<c<`0103<c<`4000000<0c<c<00D000000<c<c03<c<`0
c<c<000000030<c<c0040000003<c<`0c<c<0<c<c0@000000`3<c<`00`000000c<c<0<c<c0020<c<
c0030000003<c<`0c<c<07L0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`0M0?ooo`<0
00004`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0?l0ooooM03oool00`000000
oooo0?ooo`0V0?ooo`030000003<c<`0c<c<00/0c<c<9P00o`0;000002H00?l03`3<c<`00`000000
c<c<0<c<c0030<c<c0030000003<c<`0c<c<00<0c<c<0P0000020<c<c08000000P3<c<`01@000000
c<c<0<c<c03<c<`0000000<0c<c<00<000000<c<c03<c<`00P0000020<c<c08000000P3<c<`00`00
0000c<c<0<c<c0020<c<c0030000003<c<`0c<c<07L0c<c<6@00000L0?ooo`00o@3oool00`000000
oooo0?ooo`0M0?ooo`<00000o`3ooone0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<
c<`02`3<c<`W003o00T000009`00o`0>0<c<c0030000003<c<`0000000<0c<c<00<000000<c<c000
0000103<c<`00`000000c<c<0<c<c0020<c<c0040000003<c<`0c<c<000000<0c<c<00D000000<c<
c03<c<`0c<c<000000020<c<c0030000003<c<`0c<c<00D0c<c<00<000000<c<c03<c<`00P3<c<`0
0`000000c<c<0<c<c01g0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`3o0?oook@0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c00;0<c<
c2L00?l02@00000W003o00h0c<c<00<000000<c<c00000000`3<c<`00`000000c<c<000000040<c<
c0030000003<c<`0c<c<0080c<c<00@000000<c<c03<c<`000000`3<c<`01@000000c<c<0<c<c03<
c<`000000080c<c<00<000000<c<c03<c<`01@3<c<`00`000000c<c<0<c<c0020<c<c0030000003<
c<`0c<c<07L0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooomD0oooo00<00000
0?ooo`3oool09P3oool00`000000c<c<0<c<c00c0<c<c0L00000=P3<c<`00`000000c<c<00000003
0<c<c0030000003<c<`0000000@0c<c<00<000000<c<c03<c<`00P3<c<`010000000c<c<0<c<c000
00030<c<c0050000003<c<`0c<c<0<c<c00000000P3<c<`600000080c<c<00<000000<c<c03<c<`0
0P3<c<`00`000000c<c<0<c<c01g0<c<c1T00000703oool00?d0oooo0`00003o0?ooom<0oooo0`00
000X0?ooo`030000003<c<`0c<c<03@0c<c<1@00000f0<c<c0070000003<c<`0c<c<0<c<c0000000
c<c<000000030<c<c0050000003<c<`0c<c<0<c<c0000000103<c<`010000000c<c<0<c<c0000003
0<c<c0050000003<c<`0c<c<0<c<c00000000P3<c<`00`000000c<c<0<c<c0020<c<c0040000003<
c<`0c<c<000000@0c<c<00<000000<c<c03<c<`0M`3<c<`I000001`0oooo003m0?ooo`030000003o
ool0oooo0?l0ooooe@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<03@0c<c<1@00
000f0<c<c0070000003<c<`0c<c<0<c<c0000000c<c<000000030<c<c0040000003<c<`0c<c<0<c<
c08000000P3<c<`200000080c<c<0P0000020<c<c08000000P3<c<`00`000000c<c<0<c<c0020000
0080c<c<0P0000020<c<c08000000P3<c<`2000007T0c<c<6@00000L0?ooo`00o@3oool00`000000
oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c00e0<c<c0<0
0000=`3<c<`01`000000c<c<0<c<c03<c<`000000<c<c00000000`3<c<`00`000000c<c<0<c<c002
0<c<c0@000000`3<c<`010000000c<c<0000000000020<c<c0800000103<c<`4000000<0c<c<00<0
00000<c<c00000000P00001j0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooooE
0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0=@3<c<`3000003H0c<c<00<00000
0<c<c03<c<`00P3<c<`00`000000c<c<000000040<c<c0030000003<c<`0c<c<09X0c<c<6@00000L
0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`00
0000c<c<0<c<c00f0<c<c0030000003<c<`0c<c<03D0c<c<00<000000<c<c03<c<`00`3<c<`00`00
0000c<c<0<c<c0030<c<c0030000003<c<`0c<c<09X0c<c<6@00000L0?ooo`00o@3oool00`000000
oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c01^0<c<c003
0000003<c<`0c<c<00<0c<c<00<000000<c<c03<c<`00`3<c<`00`000000c<c<0<c<c02J0<c<c1T0
0000703oool00?d0oooo00<000000?ooo`3oool0o`3ooooE0?ooo`030000003oool0oooo02H0oooo
00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo0`00003o0?ooom<0oooo0`00
000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0
oooo0?l0ooooe@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I
000001`0oooo003m0?ooo`030000003oool0oooo0?l0ooooe@3oool00`000000oooo0?ooo`0V0?oo
o`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0
ooooe@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0
oooo003m0?ooo`030000003oool0oooo0?l0ooooe@3oool00`000000oooo0?ooo`0V0?ooo`030000
003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0ooooe@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m
0?ooo`030000003oool0oooo0?l0ooooe@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0
c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`<00000o`3ooooC0?ooo`<00000:03oool00`00
0000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooomD0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00
o@3oool00`000000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<
0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooomD0oooo00<0
00000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool0
0`000000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o
0<c<c1P0c<c<6@00000L0?ooo`00jP3oool00`000000oooo0?ooo`030?ooo`@000002@3oool00`00
0000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<
c1P0c<c<6@00000L0?ooo`00jP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3o
ool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00jP3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<
6@00000L0?ooo`00jP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01P3oool400000?l0ooood@3oool4000002P0oooo00<000000<c<c03<c<`0o`3<
c<`H0<c<c1T00000703oool00>X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooooE0?ooo`030000003oool0
oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00>X0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0o`3ooooE0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<
c1T00000703oool00>X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooooE0?ooo`030000003oool0oooo02H0
oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00>X0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
o`3ooooE0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00>P0oooo0`0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`3o0?ooomD0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<
c03o0<c<c1P0c<c<6@00000L0?ooo`00jP3oool00`000000oooo0?ooo`030?ooo`@000002@3oool0
0`000000oooo0?ooo`3o0?oook00oooo2P00000K0?ooo`030000003oool0oooo02H0oooo00<00000
0<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo0`00003o0?oook00oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`<00000:03oool00`000000c<c<0<c<c03o0<c<
c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooojl0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<
c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooon_0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0203oool:000000H0oooo00<000000?ooo`3oool0
9P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?oo
o`3o0?ooojl0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0V0?ooo`030000003<
c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo[P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H
0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooon^0?ooo`030000003oool0oooo
0080oooo1@3o00030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<
c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooon^0?ooo`040000003oool0oooo0?oo
o`T0o`0000<000000?l0003o00000P3o00040?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I0000
01`0oooo003m0?ooo`<00000o`3ooon]0?ooo`030000003oool0oooo00`0o`0000<000000?l0003o
0000103o000010000000o`000?l0003o00090?ooo`030000003oool0oooo00<00000:03oool00`00
0000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooojd0
oooo00<000000?l0003o0000103o00040?ooo`@0o`0000<000000?l0003o0000103o00000`000000
o`000?l000060?l000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo
L03oool:000003<0oooo00<0o`000000003o00000`3o00070?ooo`8000000`3oool40?l000030000
003o0000o`0000H0o`00103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo
00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;`3oool40?l000030000003o
0000oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`D0o`001@3o
ool01@000000oooo0?ooo`3oool0000002P0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo00<000000?ooo`3oool0o`3ooomJ0?ooo`/000002P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo02d0oooo1@3o00000`3oool00000000000060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0303oool01@000000oooo0?ooo`3oool0000002P0oooo
00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3o
oomJ0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo2P00000;0?ooo`/000000`3oool60?l000@0oooo00@0
00000?ooo`3oool0oooo0P00000;0?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<0
00000?ooo`3oool0o`3ooomI0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o00001@3o
00070?ooo`030000003oool0000000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703o
ool00?d0oooo0`00003o0?oooeT0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l00002
0?l000X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`800000103oool3
000002P0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?oo
o`3oool0o`3ooomI0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool40?l0
00030000003o0000o`0000L0o`000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`80o`0000@000000?l0
003o0000o`007P3oool2000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0V
0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo
0?l0ooooF03oool00`000000oooo0?ooo`030?ooo`P0o`0000<000000?l0003o00001@3o00000`00
0000o`000?l0000:0?l000030000003o0000o`000080o`00103oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool40?l000030000003o0000oooo
0240oooo00<000000?ooo`0000002@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<
0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0ooooF03oool00`000000
oooo0?ooo`0;0?l000030000003o0000o`0000@0o`0000<000000?l0003o0000303o00000`000000
o`000?l000040?l000040000003o0000o`000?l000T0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`050?ooo`H0o`0000<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0
oooo00<000000?ooo`3oool0o`3ooom50?ooo`X000002@3oool00`000000o`000?l0000;0?l00004
0000003o0000o`000?l000<0oooo00<000000?ooo`3oool0203oool40?l000030000003o0000o`00
00@0o`0000<000000?l0003o00002P3o00000`000000o`000?l000050?l000030000003o0000o`00
00T0o`000P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02H0oooo00<000000<c<
c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooom50?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`3o000000000?l000050?l000T0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`8000000`3oool40?l00003
0000003o0000o`0000X0o`0000<000000?l0003o00001@3o00000`000000o`000?l000070?l000@0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0
c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0ooooA03oool00`000000oooo
0?ooo`080?ooo`040000003oool0oooo0?ooo`@0o`0000<000000?l0003o00000P3o000;0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0080oooo2P3o00000`000000o`000?l000030?l000030000003o0000o`0000L0
o`001P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<
c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooom40?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3o00001P3o0002000000/0oooo0P0000090?ooo`800000
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
9P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool300000?l0ooooA03o
ool00`000000oooo0?ooo`070?ooo`030?l000000000o`0000H0o`000`3oool2000000L0oooo0P00
000=0?ooo`040000003oool0oooo0?ooo`8000002`3oool2000000/0oooo00<000000?ooo`3oool0
1@3oool2000000/0oooo0P00000/0?ooo`<00000:03oool00`000000c<c<0<c<c03o0<c<c1P0c<c<
6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool01P3o
ool40?l000040000003o0000o`000?l000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0000000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0;P3oool00`000000oooo
0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003o
ool0oooo0?l0oooo@`3oool00`000000oooo0?ooo`030?ooo`L0o`0000<000000?ooo`3oool02P3o
ool2000000030?ooo`00000000000180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`040?ooo`800000303oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02l0oooo00<0
00000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool0
0`000000oooo0?ooo`3o0?oood<0oooo00<000000?ooo`3oool00P3oool70?l000030?ooo`000000
oooo00d0oooo00<000000?ooo`3oool09@3oool2000000<0oooo00<000000?ooo`3oool03@3oool2
000000<0oooo0P00000b0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H
0<c<c1T00000703oool00=h0oooo00<000000?ooo`3oool00P3oool600000080oooo00@000000?oo
o`3oool0oooo1000000:0?ooo`030000003oool0oooo0?l0oooo@P3oool00`000000oooo0?ooo`02
0?ooo`D0o`001@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool000000180oooo00<00000
0?ooo`000000=03oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I
000001`0oooo003N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3ooom2
0?ooo`040000003oool0oooo0?ooo`D0o`001P3oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0V0?ooo`030000003<
c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003N0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0o`3ooom30?ooo`8000001@3o00060?ooo`030000003oool0oooo0880oooo00<00000
0?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00gP3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool40000
0?l0oooo@`3oool0103o000000000?l0003o00070?ooo`030000003oool0oooo0800oooo1000000X
0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003N0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0?l0oooo@`3oool30?l000030000003oool0oooo00@0oooo0P0000260?ooo`030000003oool0oooo
02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00=h0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`D000002P3oool00`000000oooo0?ooo`3o0?oood80
oooo103o00000`3oool00000000000030?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3o
ool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00gP3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`3o0?oood40oooo103o00040?ooo`030000003oool0000008T0oooo00<000000?ooo`3oool0
9P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00gP3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo0?l0oooo@03oool40?l000H0oooo00<000000?ooo`3oool0R03o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003L
0?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`3o0?ooocl0oooo103o002B0?ooo`030000003oool0
oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00=h0oooo00<000000?oo
o`3oool00`3oool4000000H0oooo1P0000090?ooo`030000003oool0oooo0?l0oooo?P3oool40?l0
09<0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?oo
o`00o@3oool300000?l0oooo?@3oool40?l00980oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0
c<c<603<c<`I000001`0oooo00160?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0?l0oooo?03oool40?l009D0oooo
00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00AP3o
ool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0?l0oooo>`3oool40?l009H0oooo00<0
00000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00AP3oool0
0`000000oooo0?ooo`0/0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0?l0oooo>P3oool40?l009L0oooo00<00000
0?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`007@3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`<0000000<0oooo0000000000000P3oool2
00000080oooo100000040?ooo`@000001`3oool00`000000oooo00000002000000@0oooo10000003
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool4000000@0oooo10000002
0?ooo`030000003oool0oooo0080oooo100000040?ooo`@00000103oool4000000H0oooo00<00000
0?ooo`0000000P0000040?ooo`@000000`3oool00`000000oooo00000002000000@0oooo0`000000
1@3oool000000?ooo`3oool0000000<0oooo0`0000000`3oool00000000000020?ooo`80000000<0
oooo0000003oool00P3oool4000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0W0?ooo`030000003oool0oooo0?l0oooo<03oool:000000<0o`00V03oool00`000000oooo0?oo
o`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo000M0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool010000000oooo0?ooo`3o
ool200000080oooo0P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103o
ool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
103oool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo0P0000020?oo
o`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?oo
o`8000000P3oool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool200000080oooo0P0000020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`3o0?oooc00oooo00<000000?ooo`3oool01@3oool0
103o000000000?l0003o002I0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<
c<`H0<c<c1T00000703oool001d0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool0
0000103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0?l0
oooo;`3oool00`000000oooo0?ooo`050?ooo`<0o`0000<000000?ooo`3oool0V03oool00`000000
oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo000M0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P0000030?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool02@3oool2000000H0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00@00000
0?ooo`3oool000000P3oool2000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo
0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`3o0?ooobl0oooo00<000000?ooo`3oool00`3oool50?l000030000003oool0oooo
09P0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?oo
o`007@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo1@0000020?ooo`04
0000003oool0oooo0?ooo`H000000`3oool4000000L0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0600000080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000103oool0
10000000oooo0?ooo`0000030?ooo`D000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02L0
oooo0`00003o0?ooobl0oooo00<000000?ooo`3oool00P3oool50?l000030?ooo`000000oooo09L0
oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo000M0?ooo`D00000
2@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000002`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@00000
0?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0
oooo000000@0oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000070?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0o`3oool^0?ooo`030000003o
ool0oooo0080oooo1@3o00030?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool09P3o
ool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`007@3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo0?ooo`8000000P3oool200000080oooo00@000000?ooo`3oool0oooo
0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000002@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000020?ooo`8000000P3oool200000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000:@3oool00`000000oooo
0?ooo`3o0?ooobh0oooo00@000000?ooo`3oool0oooo1@3o00040?ooo`030000003oool0oooo09L0
oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00
7@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`@000000P3oool400000080
oooo100000040?ooo`@000001`3oool00`000000oooo00000002000000@0oooo100000030?ooo`04
0000003oool00000000000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`030?ooo`030000003oool0000000800000103oool4000000<0oooo00<000000?ooo`000000
0P0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool400000080
oooo100000000`3oool000000?ooo`020?ooo`@000000`3oool00`000000oooo00000002000002X0
oooo00<000000?ooo`3oool0o`3oool^0?ooo`030000003oool0oooo00D0o`001@3oool00`000000
oooo0?ooo`2G0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T0
0000703oool001d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo02h0oooo0`0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool00000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0?l0oooo;@3oool0
0`000000oooo0?ooo`040?l000P0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`0V
0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo000M0?ooo`030000003oool0oooo
0080oooo0P00000:0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool00`3oool40000
00@0oooo100000070?ooo`@00000103oool4000000@0oooo1000000V0?ooo`030000003oool0oooo
00P0oooo00D000000?ooo`3oool0oooo0000000i0?ooo`030000003oool0oooo0?l0oooo;@3oool0
0`000000oooo0?l000030?l000T0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`0V
0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo000M0?ooo`H00000T@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0o`3oool^0?oo
o`8000000P3o00080?ooo`800000V@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<
0?l0c<c<603<c<`I000001`0oooo003m0?ooo`<00000o`3oool/0?ooo`@0o`0000<000000?ooo`3o
ool01@3oool2000009T0oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0
oooo003m0?ooo`030000003oool0oooo0?l0oooo:`3oool50?l000030?ooo`000000oooo00@0oooo
00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<
603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo:P3oool50?l000<0oooo0P00
00000`3oool000000000002N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<
c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooolY0?ooo`@0o`001`3oool0
0`000000oooo0?ooo`2N0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H
0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooolX0?ooo`@0o`00Z@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`03
0000003oool0oooo0?l0oooo9`3oool40?l00:X0oooo00<000000?ooo`3oool09P3oool00`000000
c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?ooobD0oooo
1@3o002[0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo0`00003o0?oooaX0oooo2`0000040?l00:X0oooo0`00000X0?ooo`030000003<
c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo6P3oool0
0`000000oooo0?ooo`060?ooo`030?l000000000o`000080o`00[@3oool00`000000oooo0?ooo`0V
0?ooo`030000003<c<`0c<c<0380c<c<2P00003K0<c<c1T00000703oool00?d0oooo00<000000?oo
o`3oool0o`3ooolI0?ooo`030000003oool0oooo00H0oooo0`3o00000`000000oooo0?ooo`2]0?oo
o`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0<P3<c<`00`000000c<c<0<c<c0060<c<
c0030000003<c<`0c<c<0=T0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oooaT0
oooo00<000000?ooo`3oool01@3oool40?l000030000003oool0oooo0:d0oooo00<000000?ooo`3o
ool09P3oool00`000000c<c<0<c<c00a0<c<c0030000003<c<`0c<c<00P0c<c<00<000000<c<c03<
c<`0f03<c<`I000001`0oooo003m0?ooo`030000003oool0oooo0?l0oooo6@3oool00`000000oooo
0?ooo`040?ooo`@0o`0000<0oooo0000003oool0[P3oool00`000000oooo0?ooo`0V0?ooo`030000
003<c<`0c<c<0340c<c<00<000000<c<c03<c<`0203<c<`00`000000c<c<0<c<c03H0<c<c1T00000
703oool00>X0oooo00<000000?ooo`3oool00`3oool4000000T0oooo00<000000?ooo`3oool0o`3o
oolH0?ooo`030000003oool0oooo00<0oooo1@3o00030?ooo`030000003oool0oooo0:`0oooo00<0
00000?ooo`3oool09P3oool00`000000c<c<0<c<c00a0<c<c0030000003<c<`0c<c<00P0c<c<00<0
00000<c<c03<c<`0;`3<c<`00`000000c<c<0<c<c0020<c<c0030000003<c<`0c<c<0080c<c<00@0
00000<c<c03<c<`0c<c<100000030<c<c0030000003<c<`0c<c<0080c<c<00<000000<c<c03<c<`0
S03<c<`I000001`0oooo003Z0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo603oool00`000000oooo0?oo
o`030?ooo`@0o`00103oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo02H0oooo00<0
00000<c<c03<c<`0<03<c<`00`000000c<c<0<c<c00:0<c<c0030000003<c<`0c<c<02h0c<c<00<0
00000<c<c03<c<`00P3<c<`00`000000c<c<0<c<c0020<c<c0030000003<c<`0c<c<008000000P3<
c<`200000080c<c<00<000000<c<c03<c<`00P3<c<`00`000000c<c<0<c<c02<0<c<c1T00000703o
ool00>X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00H0oooo1000003o0?oooaH0oooo00<000000?ooo`3oool00`3oool40?l000H0oooo00<00000
0?ooo`3oool0Z03oool4000002P0oooo00<000000<c<c03<c<`02`3<c<`U0?l000030000003o0000
o`0000X0o`0000<000000?l0003o00008P3o000<0<c<c0070000003<c<`0c<c<0<c<c0000000c<c<
000000030<c<c0040000003<c<`0c<c<000000L0c<c<00<000000<c<c03<c<`00P3<c<`00`000000
c<c<0<c<c02<0<c<c1T00000703oool00>X0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0?l0oooo5`3oool00`000000oooo0?ooo`020?ooo`@0o`00
1`3oool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0
2`3<c<`U0?l000030000003o0000o`0000X0o`0000<000000?l0003o00008P3o000<0<c<c0070000
003<c<`0c<c<0<c<c0000000c<c<000000030<c<c0040000003<c<`0c<c<000000L0c<c<00<00000
0<c<c03<c<`00P3<c<`00`000000c<c<0<c<c02<0<c<c1T00000703oool00>X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo603oool20000
0080oooo0`3o00060?ooo`800000[P3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<
00/0c<c<903o00000`000000o`000?l0000<0?l000030000003o0000o`000240o`00303<c<`01000
0000c<c<0<c<c00000030<c<c0040000003<c<`0c<c<00000080c<c<1P0000020<c<c0030000003<
c<`0c<c<0080c<c<00<000000<c<c03<c<`0S03<c<`I000001`0oooo003Z0?ooo`030000003oool0
oooo0080oooo1@0000090?ooo`030000003oool0oooo0?l0oooo6P3oool00`000000o`000?l00002
0?l000D0oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0
c<c<02l0c<c<00<000000<c<c03<c<`0303<c<`00`000000c<c<0<c<c00]0<c<c0040000003<c<`0
c<c<000000<0c<c<00@000000<c<c03<c<`000000P3<c<`00`000000c<c<0<c<c0020<c<c0040000
003<c<`0c<c<000000@0c<c<00<000000<c<c03<c<`0S03<c<`I000001`0oooo003Z0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?oooaX0oooo
00@0o`000000003o0000o`001@3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo02H0
oooo00<000000<c<c03<c<`0<03<c<`00`000000c<c<0<c<c0090<c<c0800000<03<c<`00`000000
c<c<000000050<c<c0030000003<c<`000000080c<c<0P0000020<c<c08000000P3<c<`200000080
c<c<0P00002>0<c<c1T00000703oool00>X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo6P3oool20?l0008000000`3oool200000;80oooo
00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c00a0<c<c0030000003<c<`0c<c<00L0c<c<
00<000000<c<c03<c<`0<03<c<`00`000000c<c<000000050<c<c0030000003<c<`0000000<0c<c<
100000030<c<c0030000003<c<`0000000800000S`3<c<`I000001`0oooo003X0?ooo`<00000103o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo6@3oool40?l000040?ooo`00
0000oooo00000;@0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c00b0<c<c0800000
1P3<c<`00`000000c<c<0<c<c00a0<c<c08000001`3<c<`2000009h0c<c<6@00000L0?ooo`00jP3o
ool00`000000oooo0?ooo`020?ooo`H00000203oool00`000000oooo0?ooo`3o0?oooaP0oooo103o
00030?ooo`030000003oool0oooo0;<0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<
c00d0<c<c0040000003<c<`0c<c<0<c<c0800000=03<c<`00`000000c<c<0<c<c0070<c<c0030000
003<c<`0c<c<09`0c<c<6@00000L0?ooo`00o@3oool300000?l0oooo603oool30?l00;P0oooo0`00
000X0?ooo`030000003<c<`0c<c<03D0c<c<00<000000<c<c0000000=P3<c<`00`000000c<c<0<c<
c0070<c<c0030000003<c<`0c<c<09`0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o
0?oooaL0oooo103o002j0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0=P3<c<`0
0`000000c<c<0<c<c03N0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooolF0?oo
o`@0o`00^`3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I0000
01`0oooo003m0?ooo`030000003oool0oooo0?l0oooo5P3oool30?l00;`0oooo00<000000?ooo`3o
ool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo
0?ooo`3o0?oooaD0oooo103o002l0?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0
o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0o`3ooolE0?ooo`<0o`00_@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m
0?ooo`030000003oool0oooo0?l0oooo503oool30?l00;h0oooo00<000000?ooo`3oool09P3oool0
0`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool300000?l0oooo4`3oool40?l0
0;`0oooo0`00000X0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`03
0000003oool0oooo0?l0oooo4`3oool30?l00;l0oooo00<000000?ooo`3oool09P3oool00`000000
c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3o0?oooa80oooo
0`3o00300?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`@0o`00`03oool00`000000oooo0?oo
o`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m0?ooo`030000003oool0
oooo0?l0oooo4@3oool30?l00<40oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o
0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo0?ooo`3I0?ooo`/00000:`3oool40?l0
0<40oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?oo
o`00o@3oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0:03oool40?l00<80oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0
c<c<6@00000L0?ooo`00o@3oool300000=P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0X0?ooo`<0o`00`@3oool3000002P0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c1T00000
703oool00?d0oooo00<000000?ooo`3oool0f03oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo02H0oooo103o00330?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<
c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0f03oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo02D0oooo103o00340?ooo`030000003oool0oooo02H0oooo00<00000
0<c<c03<c<`0o`3<c<`H0<c<c1T00000703oool00?d0oooo00<000000?ooo`3oool0a03oool:0000
00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0M0?ooo`X0000000<0o`000?oo
o`3oool0``3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I0000
01`0oooo003m0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0080oooo103o00040?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool0103oool20?l000030000003o0000oooo0<@0oooo00<000000?ooo`3o
ool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<6@00000L0?ooo`00o@3oool00`000000oooo
0?ooo`330?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`3o00000000
0?l000080?l000@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`@0o`00
00<000000?ooo`3oool0``3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<
603<c<`I000001`0oooo003m0?ooo`030000003oool0oooo09T0oooo2P00000P0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3o00000`000000o`000?l0000:0?l00080oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`<0o`0000<0oooo0000003oool0a03o
ool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`I000001`0oooo003m
0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo00D0oooo0`3o00000`000000o`000?l000050?l000030000003o0000
o`0000<0o`000`3oool50?l000030?ooo`000000oooo01`0oooo00<000000?ooo`3oool00`3oool4
0?l000030?ooo`000000oooo0<@0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o
0<c<c1P0c<c<6@00000L0?ooo`00o@3oool3000009P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo0080oooo203o00000`000000o`000?l000040?l0
00030?ooo`000000000000L0oooo103o00000`000000o`000?ooo`0K0?ooo`030000003oool0oooo
00<0oooo103o00030?ooo`030000003oool0oooo0<00oooo0`00000X0?ooo`030000003<c<`0c<c<
0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00o@3oool00`000000oooo0?ooo`2H0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0:0?l00003
0000003o0000oooo00L0oooo00<000000?ooo`3oool01P3oool00`3o000000000?l000020?l001/0
oooo00@000000?ooo`3oool0oooo1@3o00040?ooo`030000003oool0oooo0<80oooo00<000000?oo
o`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00?d0
oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3o00001P3o00040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0103oool2000000H0o`006@3oool00`000000oooo0?l000060?l000@0oooo00<000000?ooo`3o
ool0`P3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`00`000000
oooo0?ooo`0b0?ooo`00o@3oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo00<0oooo
0`3o00040?ooo`030000003oool0oooo01X0oooo00<000000?l0003o0000103o00080?ooo`030000
003oool0oooo00P0oooo0P0000030?ooo`030000003oool0oooo0080oooo1@3o000G0?ooo`030000
003o0000o`0000D0o`001`3oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo02H0oooo
00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003oool0oooo0380oooo003N0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`3oool4000000X0oooo
00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`030?ooo`D0o`000P3oool00`000000oooo
0?ooo`0I0?ooo`030?l000000000o`0000<0o`002P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0000000H0oooo1P3o000C0?ooo`80o`0000<000000?l0003o00000`3o00090?ooo`030000
003oool0oooo0<40oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<
00<000000?ooo`3oool0<P3oool00=h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`2F0?ooo`030000003oool0oooo00<0oooo2@3o00000`000000oooo0?ooo`0F0?ooo`@0o`00
0P0000000`3o0000oooo0?ooo`070?ooo`8000003P3oool00`000000oooo0?ooo`070?ooo`D0o`00
00<0oooo0000000000002@0000040?ooo`D0o`000P00000:0?ooo`800000a03oool00`000000oooo
0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00gP3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool00P3o
ool:0?l000030000003o0000oooo00H0oooo2`0000040?ooo`H0o`0000<0oooo0000003oool01P3o
ool2000001/0oooo1@3o00000`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0o`000P3o
ool2000000L0oooo00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`0V0?ooo`030000003<
c<`0c<c<0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00gP3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool4000009H0oooo0P000000
0`3oool0o`000?l000020?l000@0oooo0P3o00000`000000o`000?l000020?l000D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?l000@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0M0?ooo`<0o`0000<000000?l0003oool0203oool00`000000o`000?l00004
0?l000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`320?ooo`@00000:03oool0
0`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00=h0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0V@3oool010000000o`000?l0003o00060?ooo`030000003o0000o`0000H0o`000P3oool0
0`000000oooo0?ooo`080?ooo`030000003o0000o`0000<0o`001`3oool2000000030?ooo`000000
00000240oooo00<0o`000000003o00000`3o00040?ooo`<0o`0000<000000?l0003o00000P3o0009
0?ooo`80000000<0oooo000000000000b03oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0
c<c<0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00gP3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo1@00000:0?ooo`030000003oool0oooo09P0oooo0P3o00000`00
0000o`000?ooo`040?ooo`8000000`3oool70?l000030000003oool0oooo00L0oooo0P3o00000`00
0000o`000?l000020?l000X0oooo00<000000?ooo`3oool08P3oool00`000000o`000?l000030?l0
00030?ooo`3o0000o`0000<0o`0000<000000?l0003o00003@3oool00`000000oooo0?ooo`380?oo
o`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003oool0oooo
0380oooo003N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo09L0oooo103o0002000000<0oooo00<000000?ooo`3o
ool01P3oool40?l000030000003o0000o`0000H0oooo0`3o00000`000000o`000?l0000a0?ooo`03
0000003oool0o`0000T0o`0000<0oooo0000003oool0f03oool00`000000oooo0?ooo`0V0?ooo`03
0000003<c<`0c<c<0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00gP3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`2G0?ooo`@0o`000P3oool00`000000oooo0000000;0?ooo`80o`0000<000000?l0003o0000
0`3o00000`3oool0o`000?l000040?l000030000003oool0oooo0300oooo00@000000?ooo`3oool0
oooo1P3o00030?ooo`030000003oool0oooo0=L0oooo00<000000?ooo`3oool09P3oool00`000000
c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00=`0oooo0`0000090?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2F0?ooo`@0o`00
103oool00`000000oooo0?ooo`0<0?ooo`030000003o0000o`0000P0o`000P3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo0=L0oooo
00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0
<P3oool00=h0oooo00<000000?ooo`3oool00P3oool6000000D0oooo1P0000090?ooo`030000003o
ool0oooo09D0oooo103o000C0?ooo`040000003oool0oooo0?ooo`L0o`000`3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0eP3oool00`000000oooo
0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00o@3o
ool3000009@0oooo103o000D0?ooo`030000003oool0oooo00<0oooo0`3o00060?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`3D0?ooo`<00000:03o
ool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00?d0oooo00<00000
0?ooo`3oool0T`3oool40?l001D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0_
0?ooo`8000002P3oool200000=T0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o
0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00?d0oooo00<000000?ooo`3oool0TP3oool40?l0
01L0oooo00<000000?ooo`3oool02@3oool2000003@0oooo00<000000?ooo`3oool01@3oool20000
0=/0oooo00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?oo
o`3oool0<P3oool00?d0oooo00<000000?ooo`3oool0TP3oool30?l001T0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0f`3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`00`000000
oooo0?ooo`0b0?ooo`00o@3oool00`000000oooo0?ooo`1^0?ooo`/00000603oool40?l001X0oooo
0P0000060?ooo`030000003oool0oooo03L0oooo0P0000000`3oool000000000003N0?ooo`030000
003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003oool0oooo0380oooo
003m0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0E0?ooo`@0o`007@3oool010000000oooo0?ooo`3oool2000003`0oooo00<000000?ooo`3oool0
gP3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0c<c<603<c<`00`000000oooo
0?ooo`0b0?ooo`00o@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool04`3oool40?l001l0oooo00<000000?ooo`000000o`3ooolP0?ooo`030000003o
ool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003oool0oooo0380oooo003m
0?ooo`<00000K@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0180oooo103o000Q
0?ooo`030000003oool0oooo0?l0oooo7@3oool3000002P0oooo00<000000<c<c03<c<`0o`3<c<`H
0<c<c0030000003oool0oooo0380oooo003m0?ooo`030000003oool0oooo06d0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`@0o`00o`3ooom40?ooo`030000003oool0oooo
02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003oool0oooo0380oooo003m0?ooo`03
0000003oool0oooo06`0oooo00<000000?ooo`3oool00`3oool30?l000D0oooo00<000000?ooo`3o
ool03`3oool40?l00?l0ooooA@3oool00`000000oooo0?ooo`0V0?ooo`030000003<c<`0c<c<0?l0
c<c<603<c<`00`000000oooo0?ooo`0b0?ooo`00o@3oool00`000000oooo0?ooo`1/0?ooo`030000
003oool0oooo00<0oooo1`3o00000`3oool000000?ooo`080?ooo`X000000P3o003o0?ooodD0oooo
00<000000?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0
<P3oool00?d0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`020?ooo`T0o`0000<0
00000?l0003oool01`3oool00`000000oooo0?ooo`040?ooo`80o`0000<000000?l0003oool0o`3o
oom50?ooo`030000003oool0oooo02H0oooo00<000000<c<c03<c<`0o`3<c<`H0<c<c0030000003o
ool0oooo0380oooo003m0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool00P3oool4
0?l000030?ooo`3o0000o`0000@0o`0000<000000?l0003o00000P3o00030?ooo`030000003oool0
oooo00@0oooo103o00000`000000oooo0?ooo`3o0?oood@0oooo00<000000?ooo`3oool09P3oool0
0`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool00?d0oooo00<000000?oo
o`3oool0J`3oool010000000oooo0?ooo`3oool40?l000H0oooo0P3o00000`000000o`000?l00005
0?l000030000003oool0oooo00<0oooo103o00000`3oool000000?ooo`3o0?ooodD0oooo00<00000
0?ooo`3oool09P3oool00`000000c<c<0<c<c03o0<c<c1P0c<c<00<000000?ooo`3oool0<P3oool0
0?d0oooo00<000000?ooo`3oool0K03oool2000000@0o`001`3oool2000000030?ooo`3o0000o`00
00D0o`0000D000000?l0003o0000o`000?ooo`040?l00080oooo00<000000?ooo`3oool0o`3ooom4
0?ooo`030000003oool0oooo02H0ooooo`00000L000003@0oooo003m0?ooo`<00000K@3oool0103o
000000000000003o00060?ooo`8000001`3oool20?l000030000003o0000o`0000H0o`00103oool0
0`000000oooo0?ooo`3o0?oood40oooo0`00003o0?ooogP0oooo003m0?ooo`030000003oool0oooo
06d0oooo0`3o00000`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo00<000000?l0
003o00001@3o00050?ooo`030000003oool0oooo0?l0oooo@`3oool00`000000oooo0?ooo`3o0?oo
ogH0oooo003m0?ooo`030000003oool0oooo06`0oooo103o0000103oool000000000003oool20000
00`0oooo00<000000?ooo`3oool00P3oool30?l000D0oooo00<000000?ooo`3oool0o`3ooom30?oo
o`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0J`3oool40?l000@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0?l0
oooo@P3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`030000003oool0oooo06X0oooo
103o000C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0o`3ooom20?ooo`030000
003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0J@3oool40?l001D0oooo0P00
000:0?ooo`800000o`3ooom50?ooo`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<00000
0?ooo`3oool0J03oool40?l001P0oooo00<000000?ooo`3oool01@3oool200000?l0ooooA`3oool0
0`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`<00000I`3oool40?l001X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3o0?ooodD0oooo0`00003o0?ooogP0oooo003m0?ooo`03
0000003oool0oooo06L0oooo103o000K0?ooo`80000000<0oooo000000000000o`3ooom:0?ooo`03
0000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0IP3oool40?l001h0oooo
00<000000?ooo`3oool0o`3ooom:0?ooo`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<0
00000?ooo`3oool0I@3oool40?l00?l0ooooK03oool00`000000oooo0?ooo`3o0?ooogH0oooo003m
0?ooo`030000003oool0oooo06@0oooo103o003o0?ooofd0oooo00<000000?ooo`3oool0o`3ooomf
0?ooo`00i`3oool6000000<0oooo100000090?ooo`030000003oool0oooo06<0oooo103o003o0?oo
ofh0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00i`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1R0?ooo`@0
o`00o`3ooom_0?ooo`030000003oool0oooo0?l0ooooMP3oool00>L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo1000001H0?ooo`X00000
0P3o003o0?ooofd0oooo1000003o0?ooogP0oooo003X0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04@0oooo2P00
000;0?ooo`030000003oool0oooo00D0oooo00@0o`000000003o0000o`00o`3ooom`0?ooo`030000
003oool0oooo0?l0ooooMP3oool00>T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool30?l000030000003o
ool0oooo0?l0ooooK`3oool00`000000oooo0?ooo`3o0?ooogH0oooo003Z0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00@0oooo103o00000`000000oooo0?ooo`3o0?ooofl0oooo00<000000?ooo`3oool0o`3ooomf
0?ooo`00j`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`030?ooo`@0o`0000<0oooo0000003oool0o`3ooom`0?ooo`030000003oool0
oooo0?l0ooooMP3oool00>L0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o00001`3o00030?ooo`030000003oool0
oooo0?l0ooooKP3oool00`000000oooo0?ooo`3o0?ooogH0oooo003W0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo02h0oooo2`0000090?ooo`030000003oool0oooo00T0oooo00<0o`000000003o00001P3o0000
0`000000o`000?l000060?l000@0oooo00<000000?ooo`3oool0o`3ooom^0?ooo`030000003oool0
oooo0?l0ooooMP3oool00>P0oooo100000040?ooo`@000002@3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`3oool9
0?l000030000003o0000o`0000D0o`0000<000000?l0003o00001P3o00040?ooo`030000003oool0
oooo0?l0ooooKP3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`<00000;@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo0P3o00000`000000o`000?l0000:0?l0
00030000003o0000o`0000@0o`0000<000000?l0003o0000303oool00`000000oooo0?ooo`3o0?oo
of/0oooo0`00003o0?ooogP0oooo003m0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?l000050?l000030000003o0000o`0000X0o`000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0o`3ooom]0?ooo`03
0000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`060?ooo`<0o`0000<000000?l0003o00001@3o00000`000000o`000?l000020?l000X0oooo
00<000000?ooo`3oool0103oool2000000X0oooo0P00003o0?ooog00oooo00<000000?ooo`3oool0
o`3ooomf0?ooo`00o@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00<0oooo203o
00000`000000o`000?l000040?l000030?ooo`000000oooo00X0oooo0P0000090?ooo`8000001`3o
ool00`000000oooo0?ooo`3o0?ooog00oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00o@3oool0
0`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00<0oooo203o00000`000000o`000?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0?l0ooooL@3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?oo
o`030000003oool0oooo02`0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<000000?oo
o`3oool01`3oool2000000H0oooo00<000000?ooo`3oool03@3oool2000000030?ooo`0000000000
0?l0ooooM03oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool00P3oool40?l000L0oooo00<000000?ooo`3oool0203oool010000000
oooo0?ooo`3oool200000180oooo00<000000?ooo`3oool0o`3ooomd0?ooo`030000003oool0oooo
0?l0ooooMP3oool00?d0oooo0`00000[0?ooo`030000003oool0oooo0080oooo0`3o00080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`000000o`3ooon90?ooo`<00000o`3ooomh0?ooo`00
o@3oool00`000000oooo0?ooo`0/0?ooo`80000000<0oooo0?l0003o00000P3o00060?ooo`800000
3@3oool00`000000oooo0?ooo`3o0?ooohX0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00o@3o
ool00`000000oooo0?ooo`0^0?ooo`8000000P3o00050?ooo`800000o`3ooonL0?ooo`030000003o
ool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0;P3oool20?l000030000003oool0
oooo00<0oooo00<000000?ooo`3oool0o`3ooonL0?ooo`030000003oool0oooo0?l0ooooMP3oool0
0?d0oooo00<000000?ooo`3oool0;@3oool40?l00080000000<0oooo000000000000o`3ooonO0?oo
o`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool0;03oool40?l000<0
oooo00<000000?ooo`3oool0o`3ooonO0?ooo`030000003oool0oooo0?l0ooooMP3oool00?d0oooo
00<000000?ooo`3oool0;03oool30?l00?l0ooooYP3oool00`000000oooo0?ooo`3o0?ooogH0oooo
003m0?ooo`<00000:`3oool40?l00?l0ooooY03oool300000?l0ooooN03oool00?d0oooo00<00000
0?ooo`3oool0:P3oool40?l00?l0ooooY`3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?oo
o`030000003oool0oooo02X0oooo0`3o003o0?ooojP0oooo00<000000?ooo`3oool0o`3ooomf0?oo
o`00o@3oool00`000000oooo0?ooo`0Y0?ooo`@0o`00o`3ooonX0?ooo`030000003oool0oooo0?l0
ooooMP3oool00?d0oooo00<000000?ooo`3oool0:03oool40?l00?l0ooooZ@3oool00`000000oooo
0?ooo`3o0?ooogH0oooo003m0?ooo`030000003oool0oooo02P0oooo0`3o003o0?ooojX0oooo00<0
00000?ooo`3oool0o`3ooomf0?ooo`00o@3oool00`000000oooo0?ooo`0W0?ooo`<0o`00o`3ooon[
0?ooo`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool09P3oool40?l0
0?l0ooooZ`3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`<000009@3oool40?l00?l0
ooooZP3oool300000?l0ooooN03oool00?d0oooo00<000000?ooo`3oool09@3oool30?l00?l0oooo
[@3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`030000003oool0oooo02@0oooo103o
003o0?ooojd0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00o@3oool00`000000oooo0?ooo`0S
0?ooo`@0o`00o`3ooon^0?ooo`030000003oool0oooo0?l0ooooMP3oool00=/0oooo1P0000020?oo
o`H000000P3oool010000000oooo0?ooo`3oool4000000X0oooo00<000000?ooo`3oool08`3oool3
0?l00?l0oooo[`3oool00`000000oooo0?ooo`3o0?ooogH0oooo003K0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool08P3oool40?l00?l0oooo[`3oool00`000000oooo0?ooo`3o
0?ooogH0oooo003K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool:0000
0080o`00o`3ooon`0?ooo`030000003oool0oooo0?l0ooooMP3oool00=`0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo1000000H0?ooo`03
0000003oool0oooo00D0oooo00<0o`000000003o0000o`3ooon^0?ooo`@00000o`3ooomh0?ooo`00
g@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00D0oooo0`3o00000`000000oooo
0?ooo`3o0?ooojl0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00gP3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo1@00000:0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0103oool40?l000030000003oool0oooo0?l0oooo[`3oool00`000000oooo0?oo
o`3o0?ooogH0oooo003O0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool3
0?l000030?ooo`000000oooo0?l0oooo/03oool00`000000oooo0?ooo`3o0?ooogH0oooo003K0?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`04
0?ooo`@0o`000P3oool00`000000oooo0?ooo`3o0?ooojh0oooo00<000000?ooo`3oool0o`3ooomf
0?ooo`00f`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool00`3oool40?l000<0oooo00<000000?ooo`3oool0o`3ooon^0?ooo`030000003oool0
oooo0?l0ooooMP3oool00=`0oooo100000040?ooo`@000001P3oool6000000T0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`030?ooo`<0o`00103oool00`000000oooo0?ooo`3o0?oo
ojh0oooo00<000000?ooo`3oool0o`3ooomf0?ooo`00o@3oool3000001H0oooo00<000000?ooo`3o
ool0103oool30?l000D0oooo00<000000?ooo`3oool0o`3ooon[0?ooo`<00000o`3ooomh0?ooo`00
o@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
o`3ooon]0?ooo`030000003oool0oooo0?l0ooooMP3oool00?d0oooo00<000000?ooo`3oool05`3o
ool2000000/0oooo00<000000?ooo`3oool0o`3ooon^0?ooo`030000003oool0oooo0?l0ooooMP3o
ool00?d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0?l0oooo[`3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0103oool200000?l0oooo/P3oool00`000000oooo0?ooo`3o0?oo
ogH0oooo003m0?ooo`030000003oool0oooo01/0oooo0P0000030?ooo`030000003oool0oooo0?l0
oooo/P3oool00`000000oooo0?ooo`3o0?ooogH0oooo003m0?ooool00000f@00003o0?ooogP0oooo
003o0?oooal0oooo00<000000?ooo`3oool0o`3ooooo0?ooool0oooo;P3oool00?l0ooooo`3ooooo
0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0
ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03o
ool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooom;0?ooo`8000002P3oool40000
0?l0oooom03oool00?l0ooooo`3ooom<0?ooo`800000203oool200000080oooo0P00003o0?oooo<0
oooo003o0?ooool0ooooC@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo
l@3oool00?l0ooooEP3oool4000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00P0oooo1@0000060?ooo`@00000103oool3000000030?ooo`00
000000000080oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool3000000030?ooo`00000000000080oooo0P0000020?ooo`@00000103o
ool4000000D0oooo00@000000?ooo`3oool000001@3oool4000000<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool4000000@0
oooo0`0000000`3oool00000000000020?ooo`<0000000<0oooo0000003oool0103oool300000003
0?ooo`00000000000080oooo100000040?ooo`@000000`3oool010000000oooo0?ooo`3oool30000
00030?ooo`000000oooo0080oooo100000030?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool0oooo0P0000020?ooo`@000001`3oool00`000000oooo00000002000000D0oooo00<00000
0?ooo`3oool01`3oool3000000030?ooo`000000oooo0080oooo100000030?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool0oooo0`0000000`3oool000000?ooo`020?ooo`@000000`3o
ool00`000000oooo0?ooo`3o0?ooolh0oooo003o0?oooeD0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`020?ooo`8000000`3oool200000080oooo0P0000020?ooo`8000000P3o
ool200000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00P3oool200000080oooo0P0000020?ooo`040000003oool0oooo0?ooo`80
00000P3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000@0oooo0P0000020?ooo`8000000P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`030000003oool0
oooo008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0oooo0P0000060?ooo`800000
0P3oool2000000@0oooo0P0000070?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000000P3oool200000080oooo
0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`3o0?ooolh0oooo003o0?oooeD0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
1`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00L000000?ooo`3oool0oooo0000003oool0000000L0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo0?l0oooocP3oool00?l0
ooooE@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3o
ool000001`3oool2000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool2000000<0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`090?ooo`800000103oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool01@000000
oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo008000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo0P0000030?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3oool01@3o
ool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000070?ooo`8000001P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo000000@0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`3o0?ooolh0
oooo003o0?oooeD0oooo0P0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1P0000030?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`D000000P3oool010000000oooo0?ooo`3oool60000
00<0oooo100000050?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo1@0000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool500000080oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool01P0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool4
000000L0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0600000080oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00H00000
0P3oool00`000000oooo0?ooo`3o0?ooolh0oooo003o0?oooeD0oooo00<000000?ooo`0000000P00
00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01@3oool010000000oooo
0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000090?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000001`3oool0
0`000000oooo0?ooo`050?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000
103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@0
00000?ooo`3oool00000103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0000
00@0oooo00@000000?ooo`3oool00000o`3oooo@0?ooo`00o`3ooomE0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool200000080oooo0P0000020?oo
o`040000003oool0oooo0?ooo`8000000P3oool2000000D0oooo0P0000030?ooo`8000000P3oool2
00000080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`8000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000030?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`050?ooo`8000000`3o
ool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3o
ool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000060?ooo`800000
0P3oool2000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool00`3oool200000080oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oooll0oooo003o0?oooeD0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`3oool4000000@0oooo100000020?ooo`@00000
00<0oooo0000003oool00`0000060?ooo`040000003oool0000000000080oooo100000020?ooo`@0
00000P3oool4000000@0oooo100000040?ooo`<0000000<0oooo0000003oool00P0000020?ooo`@0
00000`3oool010000000oooo0000000000020?ooo`800000203oool010000000oooo000000000002
0?ooo`@00000103oool4000000@0oooo0`0000000`3oool000000?ooo`040?ooo`@00000103oool4
000000@0oooo100000030?ooo`040000003oool0oooo0?ooo`<0000000<0oooo0000003oool00P3o
ool4000000<0oooo00<000000?ooo`0000000P0000020?ooo`@000000P3oool4000000L0oooo00<0
00000?ooo`0000000P0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103o
ool3000000030?ooo`000000oooo0080oooo100000030?ooo`030000003oool0000000800000103o
ool3000000030?ooo`000000oooo0080oooo100000030?ooo`040000003oool0000000000?l0oooo
c@3oool00?l0ooooE@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0`00
00090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0A0?ooo`050000003oool0oooo0?ooo`0000005`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo03L0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`3o0?ooomT0oooo
003o0?oooeH0oooo100000090?ooo`030000003oool0oooo0080oooo1P0000060?ooo`030000003o
ool0oooo0080oooo0P00000C0?ooo`050000003oool0oooo0?ooo`0000005`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo0?l0oooof@3oool00?l0ooooM03oool5000001T0oooo00<0
00000?ooo`3oool0;03oool2000003L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?oo
o`3o0?ooomT0oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oo
oe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo
003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?oo
ool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0oooo
o`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo
0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00
oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o
0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0
ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3ooooo0?oooe00oooo003o0?ooool0ooooo`3o
oooo0?oooe00oooo003o0?oook`0oooo1@0000000`3oool00000000000020?ooo`8000001P3oool4
000000D0oooo0`0000000`3oool00000000000040?ooo`8000001`3oool9000000@0oooo0P000004
0?ooo`800000103oool2000000<0oooo0`0000000`3oool00000000000020?ooo`8000000P3oool2
000000@0oooo0P00003o0?ooool0oooo<`3oool00?l0oooo^P3oool:00000080oooo0P0000050?oo
o`L000000P3oool3000000040?ooo`0000000000000000<0oooo0`0000070?ooo`X000000`3oool2
000000@0oooo0P0000030?ooo`<000000P3oool3000000040?ooo`000000000000000080oooo0P00
00020?ooo`800000103oool200000?l0ooooo`3ooolc0?ooo`00o`3oooni0?ooo`<000001@3oool3
00000080oooo0P0000040?ooo`<000000`3oool200000080oooo0P0000030?ooo`8000000`3oool2
000000P0oooo0P0000060?ooo`<000000P3oool2000000@0oooo0P0000030?ooo`8000000`3oool2
000000<0oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P00003o0?ooool0oooo<`3oool0
0?l0oooo^@3oool2000000L0oooo0P0000020?ooo`800000103oool2000000P0oooo0P0000030?oo
o`8000000`3oool2000000P0oooo0P0000070?ooo`8000000P3oool2000000@0oooo0P0000030?oo
o`8000000`3oool2000000<0oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P00003o0?oo
ool0oooo<`3oool00?l0oooo^03oool3000000L0oooo0P0000020?ooo`800000103oool2000000P0
oooo0`0000020?ooo`8000000`3oool2000000P0oooo0P0000070?ooo`8000000P3oool2000000@0
oooo0P0000030?ooo`8000000`3oool300000080oooo0P0000020?ooo`8000000P3oool2000000@0
oooo0P00003o0?ooool0oooo<`3oool00?l0oooo^03oool2000000D0oooo1@0000020?ooo`800000
103oool8000000<0oooo1P0000030?ooo`800000203oool2000000H0oooo0`0000020?ooo`800000
103oool2000000<0oooo0P0000040?ooo`H000000P3oool200000080oooo0P0000040?ooo`800000
o`3ooooo0?oooc<0oooo003o0?oookP0oooo0P0000050?ooo`D000000P3oool2000000@0oooo0P00
00040?ooo`8000001P3oool3000000<0oooo0P0000080?ooo`X000000`3oool2000000@0oooo0P00
00030?ooo`8000001`3oool300000080oooo0P0000020?ooo`800000103oool200000?l0ooooo`3o
oolc0?ooo`00o`3ooonh0?ooo`800000303oool3000000<0oooo0P0000040?ooo`8000000P3oool2
000000<0oooo0P0000030?ooo`800000203oool9000000@0oooo0`0000030?ooo`8000000`3oool2
000000<0oooo0P0000030?ooo`8000000P3oool200000080oooo0`0000030?ooo`800000o`3ooooo
0?oooc<0oooo003o0?oookP0oooo0P00000<0?ooo`80000000<0oooo0000000000000P3oool60000
00<0oooo0`0000001@3oool00000000000000000oooo00H000001P3oool2000000D0oooo0P000004
0?ooo`80000000@0oooo000000000000oooo0P0000000`3oool0000000000004000000050?ooo`00
000000000000003oool00`0000020?ooo`8000000P3oool2000000030?ooo`000000000000<00000
o`3ooooo0?oooc<0oooo003o0?oookP0oooo0`0000070?ooo`8000000P3oool2000000030?ooo`00
0000000000<0oooo100000050?ooo`D000000P3oool6000000H0oooo0P0000060?ooo`8000000`3o
ool2000000040?ooo`00000000000?ooo`80000000<0oooo000000000000100000020?ooo`D00000
0`3oool200000080oooo0P0000020?ooo`<00000o`3ooooo0?oooc@0oooo003o0?oookT0oooo0P00
00070?ooo`800000703oool2000000P0oooo0P0000060?ooo`8000003P3oool200000?l0ooooo`3o
oom;0?ooo`00o`3oooni0?ooo`<000001@3oool3000001`0oooo0P0000080?ooo`8000001@3oool3
000000h0oooo0P00003o0?ooool0ooooB`3oool00?l0oooo^P3oool9000001d0oooo0P0000080?oo
o`T000002P3oool2000000<0oooo0P00000<0?ooo`800000o`3ooooo0?ooocd0oooo003o0?oook`0
oooo1@00000Y0?ooo`P000002`3oool200000140oooo0P00003o0?ooool0oooo?@3oool00?l0oooo
o`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo
0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0
ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03o
ool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0
ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3o
oooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?oo
ool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0oooo
D03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool0
0?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0oooo
o`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo
0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0
ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03o
ool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0
ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3o
oooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?oo
ool0ooooD03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00?l0ooooo`3ooooo0?ooool0oooo
D03oool00?l0ooooo`3ooooo0?ooool0ooooD03oool00001\
\>"],
  ImageRangeCache->{{{0, 1099}, {456.75, 0}} -> {-1.07641, -0.648935, \
0.0028415, 0.0028415}, {{26.875, 730.688}, {445.875, 10.8125}} -> {-12.4056, \
-1.57418, 0.0468399, 0.0685708}, {{765.875, 1047.44}, {369.125, 157.938}} -> \
{-9.23961, -1.14578, 0.0119335, 0.0119335}, {{780.938, 864.75}, {354, \
270.188}} -> {-19.6355, -3.45194, 0.023863, 0.023863}, {{780.938, 864.75}, \
{256.812, 173}} -> {-19.6355, -5.77112, 0.023863, 0.023863}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Round[AbsoluteTime[] - timingstart]\)], "Input"],

Cell[BoxData[
    \(11\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->"EditBar",
WindowSize->{724, 751},
WindowMargins->{{70, Automatic}, {Automatic, 55}},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification->1,
StyleDefinitions -> "DemoText.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "data "->{
    Cell[4843, 138, 14399, 436, 601, "Output",
      CellTags->"data "]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"data ", 245943, 5073}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 61, 0, 54, "Section"],
Cell[1840, 55, 204, 4, 53, "Input"],
Cell[2047, 61, 323, 8, 76, "Text"],

Cell[CellGroupData[{
Cell[2395, 73, 64, 1, 37, "Input"],
Cell[2462, 76, 997, 15, 191, "Output"]
}, Open  ]],
Cell[3474, 94, 67, 0, 28, "Text"],

Cell[CellGroupData[{
Cell[3566, 98, 46, 1, 37, "Input"],
Cell[3615, 101, 863, 19, 196, "Output"]
}, Open  ]],
Cell[4493, 123, 274, 8, 46, "Text"],

Cell[CellGroupData[{
Cell[4792, 135, 48, 1, 37, "Input"],
Cell[4843, 138, 14399, 436, 601, "Output",
  CellTags->"data "]
}, Open  ]],
Cell[19257, 577, 468, 19, 46, "Text"],

Cell[CellGroupData[{
Cell[19750, 600, 66, 1, 37, "Input"],
Cell[19819, 603, 195, 3, 63, "Output"]
}, Open  ]],
Cell[20029, 609, 177, 6, 28, "Text"],

Cell[CellGroupData[{
Cell[20231, 619, 123, 3, 37, "Input"],
Cell[20357, 624, 156, 4, 91, "Output"]
}, Open  ]],
Cell[20528, 631, 172, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[20725, 639, 159, 3, 53, "Input"],
Cell[20887, 644, 244, 6, 91, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21168, 655, 68, 1, 37, "Input"],
Cell[21239, 658, 165, 2, 63, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21441, 665, 83, 1, 37, "Input"],
Cell[21527, 668, 156, 4, 91, "Output"]
}, Open  ]],
Cell[21698, 675, 63, 0, 28, "Text"],

Cell[CellGroupData[{
Cell[21786, 679, 108, 2, 37, "Input"],
Cell[21897, 683, 141, 2, 63, "Output"]
}, Open  ]],
Cell[22053, 688, 126, 5, 28, "Text"],

Cell[CellGroupData[{
Cell[22204, 697, 80382, 1321, 274, 80268, 1317, "GraphicsData", "Bitmap", \
"Input",
  Evaluatable->False],
Cell[102589, 2020, 142442, 3019, 474, 42001, 1776, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[245068, 5044, 68, 1, 37, "Input"],
Cell[245139, 5047, 36, 1, 47, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

