(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2236492,      43167]*)
(*NotebookOutlinePosition[   2237484,      43201]*)
(*  CellTagsIndexPosition[   2237362,      43194]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Life expectancy (OECD data)", "Subtitle"],

Cell[BoxData[
    \(Needs["\<MathXLS`\>"]\)], "Input",
  CellLabel->"In[103]:="],

Cell["\<\
The life expectancies refer to females and males at birth; however, \
for brevity those strings are shortened.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(r = 
        ImportXLS["\<M00031357.xls\>", 
          StringReplacements \[Rule] {"\<Females at birth\>"\  \[Rule] \ \
"\<Females\>", "\<Males at birth\>" -> "\<Males\>"}]; \) // 
      TotalTiming\)], "Input",
  CellLabel->"In[104]:="],

Cell[BoxData[
    \({"2 seconds", Null}\)], "Output",
  CellLabel->"Out[104]="]
}, Open  ]],

Cell[TextData[{
  "Alternative input, if connected to the internet:    r=",
  StyleBox["ImportXLS", "DisplayMath"],
  "[\"http://www.oecd.org/xls/M00031000/M00031357.xls\"];"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[r]\)], "Input",
  CellLabel->"In[105]:="],

Cell[BoxData[GridBox[{
        {"#1", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"Life expectancy\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"in Years\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"\"\>", 
          StyleBox["1960",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1960",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1970",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1970",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1980",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1980",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1990",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1990",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1997",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1997",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1999",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1999",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2000",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2000",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["4",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>"},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"Australia\"\>", 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["6",
            FontWeight->"Bold"], "\<\"Austria\"\>", 
          StyleBox["71.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"Belgium\"\>", 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.4",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            
            FontWeight->
              "Bold"], "\<\"Canada\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", 
          StyleBox["78.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"Czech Republic\"\>", 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"Denmark\"\>", 
          StyleBox["74.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.2",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            FontWeight->"Bold"], "\<\"Finland\"\>", 
          StyleBox["72.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["12",
            FontWeight->"Bold"], "\<\"France\"\>", 
          StyleBox["73.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["13",
            FontWeight->"Bold"], "\<\"Germany\"\>", 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["14",
            FontWeight->"Bold"], "\<\"Greece\"\>", 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.5",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["15",
            FontWeight->"Bold"], "\<\"Hungary\"\>", 
          StyleBox["70.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            FontWeight->"Bold"], "\<\"Iceland\"\>", 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            FontWeight->"Bold"], "\<\"Ireland\"\>", 
          StyleBox["71.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"Italy\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\
\<\"\"\>", 
          StyleBox["77.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.3",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["19",
            FontWeight->"Bold"], "\<\"Japan\"\>", 
          StyleBox["70.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["83.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["83.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["84.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            FontWeight->"Bold"], "\<\"Korea\"\>", 
          StyleBox["53.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["51.1",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", 
          StyleBox["72.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["64.5",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["77.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.6",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["78.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.6",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["79.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["21",
            FontWeight->"Bold"], "\<\"Luxembourg\"\>", 
          StyleBox["72.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["22",
            FontWeight->"Bold"], "\<\"Mexico\"\>", 
          StyleBox["59.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["56.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["63.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["59.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["64",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            FontWeight->"Bold"], "\<\"Netherlands\"\>", 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["24",
            FontWeight->"Bold"], "\<\"New Zealand\"\>", 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.7",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["25",
            FontWeight->"Bold"], "\<\"Norway\"\>", 
          StyleBox["75.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            FontWeight->"Bold"], "\<\"Poland\"\>", 
          StyleBox["70.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["64.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"Portugal\"\>", 
          StyleBox["66.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["61.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["64.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["28",
            FontWeight->"Bold"], "\<\"Slovak Republic\"\>", 
          StyleBox["72.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["29",
            FontWeight->"Bold"], "\<\"Spain\"\>", 
          StyleBox["72.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.9",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["30",
            FontWeight->"Bold"], "\<\"Sweden\"\>", 
          StyleBox["74.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["31",
            FontWeight->"Bold"], "\<\"Switzerland\"\>", 
          StyleBox["74.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["80.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["81.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["82.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.8",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["32",
            FontWeight->"Bold"], "\<\"Turkey\"\>", 
          StyleBox["50.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["46.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["56.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["60.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["64.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["59.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["63.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["69.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["65.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["33",
            FontWeight->"Bold"], "\<\"United Kingdom\"\>", 
          StyleBox["73.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["68.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["76.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["75",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["34",
            FontWeight->"Bold"], "\<\"United States\"\>", 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["66.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["74.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["67.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["77.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["70",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["71.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["78.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["72.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["79.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["73.9",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["35",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["36",
            
            FontWeight->
              "Bold"], "\<\"Copyright OECD HEALTH DATA 2002 4th ed.\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"TABLE1"]
}, Open  ]],

Cell[BoxData[
    \(m = SubMatrix[r, "\<a3:w34\>"]; \)], "Input",
  CellLabel->"In[106]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings@ExcelForm\)], "Input",
  CellLabel->"In[107]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"ButtonBackground", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(GrayLevel[0.9`]\)},
              {"CellMargins", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({{Inherited, Inherited}, {Inherited, 
                    Inherited}}\)},
              {"ColumnLetterHeading", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"CornerFill", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"ExcelFormRules", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({DateList[
                      C_List] \[RuleDelayed] \
\(DateToString["\<DD-MMM-YYYY\>", "\<English\>"]\)[C]}\)},
              {"HideColumns", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"HideRows", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"NullReplacement", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(Null \[RuleDelayed] "\<\>"\)},
              {"NumberColor", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> False]&)], \(RGBColor[
                  0, 0, 1]\)},
              {"ShowSheetName", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"StringCutOff", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "66"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[107]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[m, CornerFill \[Rule] "\<OECD\>", 
      NumberColor \[Rule] Automatic]\)], "Input",
  CellLabel->"In[108]:="],

Cell[BoxData[GridBox[{
        {"OECD", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            FontWeight->"Bold"], "\<\"\"\>", 
          StyleBox["1960",
            FontColor->GrayLevel[0]], 
          StyleBox["1960",
            FontColor->GrayLevel[0]], 
          StyleBox["1970",
            FontColor->GrayLevel[0]], 
          StyleBox["1970",
            FontColor->GrayLevel[0]], 
          StyleBox["1980",
            FontColor->GrayLevel[0]], 
          StyleBox["1980",
            FontColor->GrayLevel[0]], 
          StyleBox["1985",
            FontColor->GrayLevel[0]], 
          StyleBox["1985",
            FontColor->GrayLevel[0]], 
          StyleBox["1990",
            FontColor->GrayLevel[0]], 
          StyleBox["1990",
            FontColor->GrayLevel[0]], 
          StyleBox["1995",
            FontColor->GrayLevel[0]], 
          StyleBox["1995",
            FontColor->GrayLevel[0]], 
          StyleBox["1996",
            FontColor->GrayLevel[0]], 
          StyleBox["1996",
            FontColor->GrayLevel[0]], 
          StyleBox["1997",
            FontColor->GrayLevel[0]], 
          StyleBox["1997",
            FontColor->GrayLevel[0]], 
          StyleBox["1998",
            FontColor->GrayLevel[0]], 
          StyleBox["1998",
            FontColor->GrayLevel[0]], 
          StyleBox["1999",
            FontColor->GrayLevel[0]], 
          StyleBox["1999",
            FontColor->GrayLevel[0]], 
          StyleBox["2000",
            FontColor->GrayLevel[0]], 
          StyleBox["2000",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>", \
"\<\"Females\"\>", "\<\"Males\"\>", "\<\"Females\"\>", "\<\"Males\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"Australia\"\>", 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["67.9",
            FontColor->GrayLevel[0]], 
          StyleBox["74.2",
            FontColor->GrayLevel[0]], 
          StyleBox["67.4",
            FontColor->GrayLevel[0]], 
          StyleBox["78.1",
            FontColor->GrayLevel[0]], 
          StyleBox["71",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["81.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.6",
            FontColor->GrayLevel[0]], 
          StyleBox["81.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["81.8",
            FontColor->GrayLevel[0]], 
          StyleBox["76.2",
            FontColor->GrayLevel[0]], 
          StyleBox["82",
            FontColor->GrayLevel[0]], 
          StyleBox["76.6",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"Austria\"\>", 
          StyleBox["71.9",
            FontColor->GrayLevel[0]], 
          StyleBox["65.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["66.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76.1",
            FontColor->GrayLevel[0]], 
          StyleBox["69",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["70.4",
            FontColor->GrayLevel[0]], 
          StyleBox["78.9",
            FontColor->GrayLevel[0]], 
          StyleBox["72.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["80.2",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.9",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.9",
            FontColor->GrayLevel[0]], 
          StyleBox["75.1",
            FontColor->GrayLevel[0]], 
          StyleBox["81.2",
            FontColor->GrayLevel[0]], 
          StyleBox["75.4",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"Belgium\"\>", 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["67.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.2",
            FontColor->GrayLevel[0]], 
          StyleBox["67.8",
            FontColor->GrayLevel[0]], 
          StyleBox["76.8",
            FontColor->GrayLevel[0]], 
          StyleBox["70",
            FontColor->GrayLevel[0]], 
          StyleBox["78",
            FontColor->GrayLevel[0]], 
          StyleBox["71.1",
            FontColor->GrayLevel[0]], 
          StyleBox["79.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.2",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.4",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"Canada\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", 
          StyleBox["78.9",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]], 
          StyleBox["79.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.4",
            FontColor->GrayLevel[0]], 
          StyleBox["81.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.1",
            FontColor->GrayLevel[0]], 
          StyleBox["81.2",
            FontColor->GrayLevel[0]], 
          StyleBox["75.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.8",
            FontColor->GrayLevel[0]], 
          StyleBox["81.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76",
            FontColor->GrayLevel[0]], 
          StyleBox["81.7",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"Czech Republic\"\>", 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73",
            FontColor->GrayLevel[0]], 
          StyleBox["66.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["66.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["67.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67.6",
            FontColor->GrayLevel[0]], 
          StyleBox["76.6",
            FontColor->GrayLevel[0]], 
          StyleBox["69.7",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["70.4",
            FontColor->GrayLevel[0]], 
          StyleBox["77.5",
            FontColor->GrayLevel[0]], 
          StyleBox["70.5",
            FontColor->GrayLevel[0]], 
          StyleBox["78.1",
            FontColor->GrayLevel[0]], 
          StyleBox["71.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.1",
            FontColor->GrayLevel[0]], 
          StyleBox["71.4",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"Denmark\"\>", 
          StyleBox["74.4",
            FontColor->GrayLevel[0]], 
          StyleBox["70.4",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["70.7",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["71.2",
            FontColor->GrayLevel[0]], 
          StyleBox["77.5",
            FontColor->GrayLevel[0]], 
          StyleBox["71.5",
            FontColor->GrayLevel[0]], 
          StyleBox["77.7",
            FontColor->GrayLevel[0]], 
          StyleBox["72",
            FontColor->GrayLevel[0]], 
          StyleBox["77.8",
            FontColor->GrayLevel[0]], 
          StyleBox["72.7",
            FontColor->GrayLevel[0]], 
          StyleBox["78.2",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.6",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["79",
            FontColor->GrayLevel[0]], 
          StyleBox["74.2",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"Finland\"\>", 
          StyleBox["72.5",
            FontColor->GrayLevel[0]], 
          StyleBox["65.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["66.5",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]], 
          StyleBox["69.2",
            FontColor->GrayLevel[0]], 
          StyleBox["78.7",
            FontColor->GrayLevel[0]], 
          StyleBox["70.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.9",
            FontColor->GrayLevel[0]], 
          StyleBox["70.9",
            FontColor->GrayLevel[0]], 
          StyleBox["80.2",
            FontColor->GrayLevel[0]], 
          StyleBox["72.8",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"France\"\>", 
          StyleBox["73.6",
            FontColor->GrayLevel[0]], 
          StyleBox["67",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["68.4",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["70.2",
            FontColor->GrayLevel[0]], 
          StyleBox["79.4",
            FontColor->GrayLevel[0]], 
          StyleBox["71.3",
            FontColor->GrayLevel[0]], 
          StyleBox["81",
            FontColor->GrayLevel[0]], 
          StyleBox["72.7",
            FontColor->GrayLevel[0]], 
          StyleBox["81.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["82.1",
            FontColor->GrayLevel[0]], 
          StyleBox["74.1",
            FontColor->GrayLevel[0]], 
          StyleBox["82.3",
            FontColor->GrayLevel[0]], 
          StyleBox["74.6",
            FontColor->GrayLevel[0]], 
          StyleBox["82.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["82.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            FontWeight->"Bold"], "\<\"Germany\"\>", 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["66.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.6",
            FontColor->GrayLevel[0]], 
          StyleBox["67.2",
            FontColor->GrayLevel[0]], 
          StyleBox["76.1",
            FontColor->GrayLevel[0]], 
          StyleBox["69.6",
            FontColor->GrayLevel[0]], 
          StyleBox["78.1",
            FontColor->GrayLevel[0]], 
          StyleBox["71.5",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72",
            FontColor->GrayLevel[0]], 
          StyleBox["79.7",
            FontColor->GrayLevel[0]], 
          StyleBox["73.3",
            FontColor->GrayLevel[0]], 
          StyleBox["79.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.6",
            FontColor->GrayLevel[0]], 
          StyleBox["80.3",
            FontColor->GrayLevel[0]], 
          StyleBox["74",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.5",
            FontColor->GrayLevel[0]], 
          StyleBox["80.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["12",
            FontWeight->"Bold"], "\<\"Greece\"\>", 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67.3",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], 
          StyleBox["70.1",
            FontColor->GrayLevel[0]], 
          StyleBox["76.8",
            FontColor->GrayLevel[0]], 
          StyleBox["72.2",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["79.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.6",
            FontColor->GrayLevel[0]], 
          StyleBox["80.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["75.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75.6",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["75.5",
            FontColor->GrayLevel[
            0]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["13",
            FontWeight->"Bold"], "\<\"Hungary\"\>", 
          StyleBox["70.1",
            FontColor->GrayLevel[0]], 
          StyleBox["65.9",
            FontColor->GrayLevel[0]], 
          StyleBox["72.1",
            FontColor->GrayLevel[0]], 
          StyleBox["66.3",
            FontColor->GrayLevel[0]], 
          StyleBox["72.7",
            FontColor->GrayLevel[0]], 
          StyleBox["65.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["65.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.7",
            FontColor->GrayLevel[0]], 
          StyleBox["65.1",
            FontColor->GrayLevel[0]], 
          StyleBox["74.5",
            FontColor->GrayLevel[0]], 
          StyleBox["65.3",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["66.6",
            FontColor->GrayLevel[0]], 
          StyleBox["75.1",
            FontColor->GrayLevel[0]], 
          StyleBox["66.4",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["66.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.1",
            FontColor->GrayLevel[0]], 
          StyleBox["66.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.6",
            FontColor->GrayLevel[0]], 
          StyleBox["67.1",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["14",
            FontWeight->"Bold"], "\<\"Iceland\"\>", 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["70.7",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["71.2",
            FontColor->GrayLevel[0]], 
          StyleBox["79.7",
            FontColor->GrayLevel[0]], 
          StyleBox["73.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.2",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["76.5",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["76.2",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["76.4",
            FontColor->GrayLevel[0]], 
          StyleBox["81.5",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["81.4",
            FontColor->GrayLevel[0]], 
          StyleBox["77.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81.4",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["15",
            FontWeight->"Bold"], "\<\"Ireland\"\>", 
          StyleBox["71.9",
            FontColor->GrayLevel[0]], 
          StyleBox["68.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["68.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75.6",
            FontColor->GrayLevel[0]], 
          StyleBox["70.1",
            FontColor->GrayLevel[0]], 
          StyleBox["76.7",
            FontColor->GrayLevel[0]], 
          StyleBox["71",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]], 
          StyleBox["72.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72.9",
            FontColor->GrayLevel[0]], 
          StyleBox["78.6",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.6",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["79.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["79.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"Italy\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\
\<\"\"\>", 
          StyleBox["77.4",
            FontColor->GrayLevel[0]], 
          StyleBox["70.6",
            FontColor->GrayLevel[0]], 
          StyleBox["78.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72",
            FontColor->GrayLevel[0]], 
          StyleBox["80",
            FontColor->GrayLevel[0]], 
          StyleBox["73.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81",
            FontColor->GrayLevel[0]], 
          StyleBox["74.6",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["81.6",
            FontColor->GrayLevel[0]], 
          StyleBox["75.3",
            FontColor->GrayLevel[
            0]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["17",
            FontWeight->"Bold"], "\<\"Japan\"\>", 
          StyleBox["70.2",
            FontColor->GrayLevel[0]], 
          StyleBox["65.3",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["69.3",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["81.9",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["82.9",
            FontColor->GrayLevel[0]], 
          StyleBox["76.4",
            FontColor->GrayLevel[0]], 
          StyleBox["83.6",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["83.8",
            FontColor->GrayLevel[0]], 
          StyleBox["77.2",
            FontColor->GrayLevel[0]], 
          StyleBox["84",
            FontColor->GrayLevel[0]], 
          StyleBox["77.2",
            FontColor->GrayLevel[0]], 
          StyleBox["84",
            FontColor->GrayLevel[0]], 
          StyleBox["77.1",
            FontColor->GrayLevel[0]], 
          StyleBox["84.6",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["18",
            FontWeight->"Bold"], "\<\"Korea\"\>", 
          StyleBox["53.7",
            FontColor->GrayLevel[0]], 
          StyleBox["51.1",
            FontColor->GrayLevel[
            0]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", 
          StyleBox["72.8",
            FontColor->GrayLevel[0]], 
          StyleBox["64.5",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["77.4",
            FontColor->GrayLevel[0]], 
          StyleBox["69.6",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["78.1",
            FontColor->GrayLevel[0]], 
          StyleBox["70.6",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["79.2",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["19",
            FontWeight->"Bold"], "\<\"Luxembourg\"\>", 
          StyleBox["72.2",
            FontColor->GrayLevel[0]], 
          StyleBox["66.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["69.1",
            FontColor->GrayLevel[0]], 
          StyleBox["77.9",
            FontColor->GrayLevel[0]], 
          StyleBox["70.6",
            FontColor->GrayLevel[0]], 
          StyleBox["78.5",
            FontColor->GrayLevel[0]], 
          StyleBox["72.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.2",
            FontColor->GrayLevel[0]], 
          StyleBox["73",
            FontColor->GrayLevel[0]], 
          StyleBox["79.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.3",
            FontColor->GrayLevel[0]], 
          StyleBox["79.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.7",
            FontColor->GrayLevel[0]], 
          StyleBox["81.2",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["20",
            FontWeight->"Bold"], "\<\"Mexico\"\>", 
          StyleBox["59.5",
            FontColor->GrayLevel[0]], 
          StyleBox["56.2",
            FontColor->GrayLevel[0]], 
          StyleBox["63.6",
            FontColor->GrayLevel[0]], 
          StyleBox["59.7",
            FontColor->GrayLevel[0]], 
          StyleBox["70",
            FontColor->GrayLevel[0]], 
          StyleBox["64",
            FontColor->GrayLevel[0]], 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67",
            FontColor->GrayLevel[0]], 
          StyleBox["74",
            FontColor->GrayLevel[0]], 
          StyleBox["68.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["71.3",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]], 
          StyleBox["76.6",
            FontColor->GrayLevel[0]], 
          StyleBox["72",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["72.8",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["21",
            FontWeight->"Bold"], "\<\"Netherlands\"\>", 
          StyleBox["75.4",
            FontColor->GrayLevel[0]], 
          StyleBox["71.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76.5",
            FontColor->GrayLevel[0]], 
          StyleBox["70.8",
            FontColor->GrayLevel[0]], 
          StyleBox["79.2",
            FontColor->GrayLevel[0]], 
          StyleBox["72.5",
            FontColor->GrayLevel[0]], 
          StyleBox["79.7",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.6",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["80.7",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["80.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.6",
            FontColor->GrayLevel[0]], 
          StyleBox["75.5",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["22",
            FontWeight->"Bold"], "\<\"New Zealand\"\>", 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], 
          StyleBox["68.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.6",
            FontColor->GrayLevel[0]], 
          StyleBox["68.3",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], 
          StyleBox["70",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["71",
            FontColor->GrayLevel[0]], 
          StyleBox["78.3",
            FontColor->GrayLevel[0]], 
          StyleBox["72.4",
            FontColor->GrayLevel[0]], 
          StyleBox["79.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.2",
            FontColor->GrayLevel[0]], 
          StyleBox["79.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["80.1",
            FontColor->GrayLevel[0]], 
          StyleBox["74.9",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75.7",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["23",
            FontWeight->"Bold"], "\<\"Norway\"\>", 
          StyleBox["75.8",
            FontColor->GrayLevel[0]], 
          StyleBox["71.3",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["71",
            FontColor->GrayLevel[0]], 
          StyleBox["79.2",
            FontColor->GrayLevel[0]], 
          StyleBox["72.3",
            FontColor->GrayLevel[0]], 
          StyleBox["79.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72.6",
            FontColor->GrayLevel[0]], 
          StyleBox["79.8",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["81.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.4",
            FontColor->GrayLevel[0]], 
          StyleBox["81",
            FontColor->GrayLevel[0]], 
          StyleBox["75.4",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81.1",
            FontColor->GrayLevel[0]], 
          StyleBox["75.6",
            FontColor->GrayLevel[0]], 
          StyleBox["81.4",
            FontColor->GrayLevel[0]], 
          StyleBox["76",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["24",
            FontWeight->"Bold"], "\<\"Poland\"\>", 
          StyleBox["70.6",
            FontColor->GrayLevel[0]], 
          StyleBox["64.9",
            FontColor->GrayLevel[0]], 
          StyleBox["73.3",
            FontColor->GrayLevel[0]], 
          StyleBox["66.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.4",
            FontColor->GrayLevel[0]], 
          StyleBox["66",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["66.5",
            FontColor->GrayLevel[0]], 
          StyleBox["75.5",
            FontColor->GrayLevel[0]], 
          StyleBox["66.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76.4",
            FontColor->GrayLevel[0]], 
          StyleBox["67.6",
            FontColor->GrayLevel[0]], 
          StyleBox["76.6",
            FontColor->GrayLevel[0]], 
          StyleBox["68.1",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["68.5",
            FontColor->GrayLevel[0]], 
          StyleBox["77.3",
            FontColor->GrayLevel[0]], 
          StyleBox["68.9",
            FontColor->GrayLevel[0]], 
          StyleBox["77.5",
            FontColor->GrayLevel[0]], 
          StyleBox["68.8",
            FontColor->GrayLevel[0]], 
          StyleBox["78",
            FontColor->GrayLevel[0]], 
          StyleBox["69.7",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["25",
            FontWeight->"Bold"], "\<\"Portugal\"\>", 
          StyleBox["66.8",
            FontColor->GrayLevel[0]], 
          StyleBox["61.2",
            FontColor->GrayLevel[0]], 
          StyleBox["70.8",
            FontColor->GrayLevel[0]], 
          StyleBox["64.2",
            FontColor->GrayLevel[0]], 
          StyleBox["75.2",
            FontColor->GrayLevel[0]], 
          StyleBox["67.7",
            FontColor->GrayLevel[0]], 
          StyleBox["76.4",
            FontColor->GrayLevel[0]], 
          StyleBox["69.4",
            FontColor->GrayLevel[0]], 
          StyleBox["77.4",
            FontColor->GrayLevel[0]], 
          StyleBox["70.4",
            FontColor->GrayLevel[0]], 
          StyleBox["78.6",
            FontColor->GrayLevel[0]], 
          StyleBox["71.2",
            FontColor->GrayLevel[0]], 
          StyleBox["78.6",
            FontColor->GrayLevel[0]], 
          StyleBox["71.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["71.6",
            FontColor->GrayLevel[0]], 
          StyleBox["78.9",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]], 
          StyleBox["79.1",
            FontColor->GrayLevel[0]], 
          StyleBox["72",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["26",
            FontWeight->"Bold"], "\<\"Slovak Republic\"\>", 
          StyleBox["72.7",
            FontColor->GrayLevel[0]], 
          StyleBox["68.4",
            FontColor->GrayLevel[0]], 
          StyleBox["72.9",
            FontColor->GrayLevel[0]], 
          StyleBox["66.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["66.8",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["66.9",
            FontColor->GrayLevel[0]], 
          StyleBox["75.4",
            FontColor->GrayLevel[0]], 
          StyleBox["66.6",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], 
          StyleBox["68.4",
            FontColor->GrayLevel[0]], 
          StyleBox["76.8",
            FontColor->GrayLevel[0]], 
          StyleBox["68.9",
            FontColor->GrayLevel[0]], 
          StyleBox["76.7",
            FontColor->GrayLevel[0]], 
          StyleBox["68.9",
            FontColor->GrayLevel[0]], 
          StyleBox["76.7",
            FontColor->GrayLevel[0]], 
          StyleBox["68.6",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["69",
            FontColor->GrayLevel[0]], 
          StyleBox["77.2",
            FontColor->GrayLevel[0]], 
          StyleBox["69.1",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"Spain\"\>", 
          StyleBox["72.2",
            FontColor->GrayLevel[0]], 
          StyleBox["67.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["69.2",
            FontColor->GrayLevel[0]], 
          StyleBox["78.6",
            FontColor->GrayLevel[0]], 
          StyleBox["72.5",
            FontColor->GrayLevel[0]], 
          StyleBox["79.6",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.3",
            FontColor->GrayLevel[0]], 
          StyleBox["81.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["81.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.4",
            FontColor->GrayLevel[0]], 
          StyleBox["81.9",
            FontColor->GrayLevel[0]], 
          StyleBox["74.9",
            FontColor->GrayLevel[0]], 
          StyleBox["82.2",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["82.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.9",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["28",
            FontWeight->"Bold"], "\<\"Sweden\"\>", 
          StyleBox["74.9",
            FontColor->GrayLevel[0]], 
          StyleBox["71.2",
            FontColor->GrayLevel[0]], 
          StyleBox["77.1",
            FontColor->GrayLevel[0]], 
          StyleBox["72.2",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["72.8",
            FontColor->GrayLevel[0]], 
          StyleBox["79.7",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], 
          StyleBox["80.4",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["81.3",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["81.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76.5",
            FontColor->GrayLevel[0]], 
          StyleBox["81.8",
            FontColor->GrayLevel[0]], 
          StyleBox["76.7",
            FontColor->GrayLevel[0]], 
          StyleBox["81.9",
            FontColor->GrayLevel[0]], 
          StyleBox["76.9",
            FontColor->GrayLevel[0]], 
          StyleBox["81.9",
            FontColor->GrayLevel[0]], 
          StyleBox["77",
            FontColor->GrayLevel[0]], 
          StyleBox["82",
            FontColor->GrayLevel[0]], 
          StyleBox["77.4",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["29",
            FontWeight->"Bold"], "\<\"Switzerland\"\>", 
          StyleBox["74.5",
            FontColor->GrayLevel[0]], 
          StyleBox["68.7",
            FontColor->GrayLevel[0]], 
          StyleBox["76.9",
            FontColor->GrayLevel[0]], 
          StyleBox["70.7",
            FontColor->GrayLevel[0]], 
          StyleBox["79.6",
            FontColor->GrayLevel[0]], 
          StyleBox["72.8",
            FontColor->GrayLevel[0]], 
          StyleBox["80.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.4",
            FontColor->GrayLevel[0]], 
          StyleBox["80.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74",
            FontColor->GrayLevel[0]], 
          StyleBox["81.7",
            FontColor->GrayLevel[0]], 
          StyleBox["75.3",
            FontColor->GrayLevel[0]], 
          StyleBox["82",
            FontColor->GrayLevel[0]], 
          StyleBox["75.9",
            FontColor->GrayLevel[0]], 
          StyleBox["82.1",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], 
          StyleBox["82.4",
            FontColor->GrayLevel[0]], 
          StyleBox["76.3",
            FontColor->GrayLevel[0]], 
          StyleBox["82.5",
            FontColor->GrayLevel[0]], 
          StyleBox["76.8",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["30",
            FontWeight->"Bold"], "\<\"Turkey\"\>", 
          StyleBox["50.3",
            FontColor->GrayLevel[0]], 
          StyleBox["46.3",
            FontColor->GrayLevel[0]], 
          StyleBox["56.3",
            FontColor->GrayLevel[0]], 
          StyleBox["52",
            FontColor->GrayLevel[0]], 
          StyleBox["60.3",
            FontColor->GrayLevel[0]], 
          StyleBox["55.8",
            FontColor->GrayLevel[0]], 
          StyleBox["64.3",
            FontColor->GrayLevel[0]], 
          StyleBox["59.8",
            FontColor->GrayLevel[0]], 
          StyleBox["68.3",
            FontColor->GrayLevel[0]], 
          StyleBox["63.8",
            FontColor->GrayLevel[0]], 
          StyleBox["69.8",
            FontColor->GrayLevel[0]], 
          StyleBox["65.2",
            FontColor->GrayLevel[0]], 
          StyleBox["70",
            FontColor->GrayLevel[0]], 
          StyleBox["65.5",
            FontColor->GrayLevel[0]], 
          StyleBox["70.3",
            FontColor->GrayLevel[0]], 
          StyleBox["65.7",
            FontColor->GrayLevel[0]], 
          StyleBox["70.5",
            FontColor->GrayLevel[0]], 
          StyleBox["65.9",
            FontColor->GrayLevel[0]], 
          StyleBox["70.7",
            FontColor->GrayLevel[0]], 
          StyleBox["66.1",
            FontColor->GrayLevel[0]], 
          StyleBox["70.9",
            FontColor->GrayLevel[0]], 
          StyleBox["66.2",
            FontColor->GrayLevel[0]]},
        {
          StyleBox["31",
            FontWeight->"Bold"], "\<\"United Kingdom\"\>", 
          StyleBox["73.7",
            FontColor->GrayLevel[0]], 
          StyleBox["67.9",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], 
          StyleBox["68.7",
            FontColor->GrayLevel[0]], 
          StyleBox["76.2",
            FontColor->GrayLevel[0]], 
          StyleBox["70.2",
            FontColor->GrayLevel[0]], 
          StyleBox["77.6",
            FontColor->GrayLevel[0]], 
          StyleBox["71.7",
            FontColor->GrayLevel[0]], 
          StyleBox["78.5",
            FontColor->GrayLevel[0]], 
          StyleBox["72.9",
            FontColor->GrayLevel[0]], 
          StyleBox["79.2",
            FontColor->GrayLevel[0]], 
          StyleBox["74",
            FontColor->GrayLevel[0]], 
          StyleBox["79.5",
            FontColor->GrayLevel[0]], 
          StyleBox["74.3",
            FontColor->GrayLevel[0]], 
          StyleBox["79.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["79.7",
            FontColor->GrayLevel[0]], 
          StyleBox["74.8",
            FontColor->GrayLevel[0]], 
          StyleBox["79.8",
            FontColor->GrayLevel[0]], 
          StyleBox["75",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["32",
            FontWeight->"Bold"], "\<\"United States\"\>", 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["66.6",
            FontColor->GrayLevel[0]], 
          StyleBox["74.7",
            FontColor->GrayLevel[0]], 
          StyleBox["67.1",
            FontColor->GrayLevel[0]], 
          StyleBox["77.4",
            FontColor->GrayLevel[0]], 
          StyleBox["70",
            FontColor->GrayLevel[0]], 
          StyleBox["78.2",
            FontColor->GrayLevel[0]], 
          StyleBox["71.1",
            FontColor->GrayLevel[0]], 
          StyleBox["78.8",
            FontColor->GrayLevel[0]], 
          StyleBox["71.8",
            FontColor->GrayLevel[0]], 
          StyleBox["78.9",
            FontColor->GrayLevel[0]], 
          StyleBox["72.5",
            FontColor->GrayLevel[0]], 
          StyleBox["79.1",
            FontColor->GrayLevel[0]], 
          StyleBox["73.1",
            FontColor->GrayLevel[0]], 
          StyleBox["79.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.6",
            FontColor->GrayLevel[0]], 
          StyleBox["79.5",
            FontColor->GrayLevel[0]], 
          StyleBox["73.8",
            FontColor->GrayLevel[0]], 
          StyleBox["79.4",
            FontColor->GrayLevel[0]], 
          StyleBox["73.9",
            FontColor->GrayLevel[0]], "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m[\([\)\(All, 1\)\(]\)]\)], "Input",
  CellLabel->"In[109]:="],

Cell[BoxData[
    \({Null, Null, "Australia", "Austria", "Belgium", "Canada", 
      "Czech Republic", "Denmark", "Finland", "France", "Germany", "Greece", 
      "Hungary", "Iceland", "Ireland", "Italy", "Japan", "Korea", 
      "Luxembourg", "Mexico", "Netherlands", "New Zealand", "Norway", 
      "Poland", "Portugal", "Slovak Republic", "Spain", "Sweden", 
      "Switzerland", "Turkey", "United Kingdom", "United States"}\)], "Output",\

  CellLabel->"Out[109]="]
}, Open  ]],

Cell[BoxData[{
    \(males\  = 
      Drop[Transpose[
          Table[m[\([\)\(All, i\)\(]\)], {i, 1, Length[m[\([\)\(1\)\(]\)]], 
              2}]], {2, 2}]; \), "\n", 
    \(males = 
      ReplacePart[males, 
        SubElement[r, "\<a1\>"] <> "\<  \>"\  <> \ 
          SubElement[r, "\<c4\>"], {1, 1}]; \), "\n", 
    \(\(males = Prepend[SortXLS@Rest[males], First[males]];\)\)}], "Input",
  CellLabel->"In[188]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SortXLS\)\)], "Input",
  CellLabel->"In[191]:="],

Cell[BoxData[
    \("SortXLS[matrix, function] sorts the rows of matrix according to the \
value of applying function to each row. SortXLS[matrix] is equivalent to \
SortXLS[matrix, Mean[Select[#, NumberQ]]&]. \nSortXLS[matrix, 1] sorts with \
respect to the first column in ascending order. SortXLS[matrix, -1] sorts \
with respect to the first column in descending order, where order is defined \
as OrderedQ[{ ... , ...}]."\)], "Print",
  CellTags->"Info3266768837-1441476"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BarSheet3D@males\)], "Input",
  CellLabel->"In[192]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0852 
%%ImageSize: 900 976.677 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
-0.131077 1.1846 -7.60026e-17 1.1846 [
[.5 1.0977 -77.5 0 ]
[.5 1.0977 77.5 15.0625 ]
[.2582 -0.00684 -15.607 -11.375 ]
[.2582 -0.00684 17.143 0 ]
[.32392 .00887 -15.8575 -11.375 ]
[.32392 .00887 16.8925 0 ]
[.38861 .02434 -16.1023 -11.375 ]
[.38861 .02434 16.6477 0 ]
[.45228 .03957 -16.3415 -11.375 ]
[.45228 .03957 16.4085 0 ]
[.51497 .05456 -16.5755 -11.375 ]
[.51497 .05456 16.1745 0 ]
[.5767 .06933 -16.8043 -11.375 ]
[.5767 .06933 15.9457 0 ]
[.63748 .08387 -17.0281 -11.375 ]
[.63748 .08387 15.7219 0 ]
[.69735 .0982 -17.247 -11.375 ]
[.69735 .0982 15.503 0 ]
[.75631 .11231 -17.4613 -11.375 ]
[.75631 .11231 15.2887 0 ]
[.8144 .12622 -17.6711 -11.375 ]
[.8144 .12622 15.0789 0 ]
[.87163 .13992 -17.8765 -11.375 ]
[.87163 .13992 14.8735 0 ]
[.20718 .00253 -54.3125 -7.03876 ]
[.20718 .00253 0 4.33624 ]
[.19996 .01939 -47.125 -7.02612 ]
[.19996 .01939 0 4.34888 ]
[.19286 .03596 -61.5 -7.01373 ]
[.19286 .03596 0 4.36127 ]
[.18588 .05225 -54.3125 -7.00156 ]
[.18588 .05225 0 4.37344 ]
[.17902 .06827 -119 -7.22004 ]
[.17902 .06827 0 4.52996 ]
[.17227 .08403 -54.3125 -7.20792 ]
[.17227 .08403 0 4.54208 ]
[.16563 .09953 -68.6875 -6.96635 ]
[.16563 .09953 0 4.40865 ]
[.1591 .11479 -111.812 -7.18432 ]
[.1591 .11479 0 4.56568 ]
[.15267 .12979 -61.5 -7.17283 ]
[.15267 .12979 0 4.57717 ]
[.14634 .14456 -104.625 -7.16155 ]
[.14634 .14456 0 4.58845 ]
[.14012 .1591 -83.0625 -6.92225 ]
[.14012 .1591 0 4.45275 ]
[.13399 .17341 -61.5 -6.91169 ]
[.13399 .17341 0 4.46331 ]
[.12796 .1875 -61.5 -6.90131 ]
[.12796 .1875 0 4.47369 ]
[.12202 .20136 -61.5 -7.11829 ]
[.12202 .20136 0 4.63171 ]
[.11617 .21502 -61.5 -7.10793 ]
[.11617 .21502 0 4.64207 ]
[.11041 .22847 -54.3125 -6.87121 ]
[.11041 .22847 0 4.50379 ]
[.10473 .24172 -61.5 -6.86151 ]
[.10473 .24172 0 4.51349 ]
[.09915 .25477 -111.812 -7.07785 ]
[.09915 .25477 0 4.67215 ]
[.09364 .26762 -90.25 -6.84257 ]
[.09364 .26762 0 4.53243 ]
[.08822 .28029 -47.125 -7.0586 ]
[.08822 .28029 0 4.6914 ]
[.08287 .29277 -54.3125 -6.82423 ]
[.08287 .29277 0 4.55077 ]
[.0776 .30507 -75.875 -7.03996 ]
[.0776 .30507 0 4.71004 ]
[.07241 .31719 -47.125 -6.80647 ]
[.07241 .31719 0 4.56853 ]
[.06729 .32914 -90.25 -6.79779 ]
[.06729 .32914 0 4.57721 ]
[.06225 .34092 -54.3125 -6.78925 ]
[.06225 .34092 0 4.58575 ]
[.05728 .35254 -90.25 -7.00438 ]
[.05728 .35254 0 4.74562 ]
[.05237 .36399 -47.125 -6.77256 ]
[.05237 .36399 0 4.60244 ]
[.04754 .37528 -54.3125 -6.7644 ]
[.04754 .37528 0 4.6106 ]
[.04277 .38641 -54.3125 -6.75636 ]
[.04277 .38641 0 4.61864 ]
[.03807 .39739 -61.5 -6.74844 ]
[.03807 .39739 0 4.62656 ]
[.20973 -0.00343 -7.2 -6.6872 ]
[.20973 -0.00343 0 4.1128 ]
[.20146 .14697 -14.4 -6.58877 ]
[.20146 .14697 0 4.21123 ]
[.19261 .30816 -14.4 -6.4835 ]
[.19261 .30816 0 4.3165 ]
[.1831 .48135 -14.4 -6.37063 ]
[.1831 .48135 0 4.42937 ]
[.17286 .66793 -14.4 -6.24933 ]
[.17286 .66793 0 4.55067 ]
[ 0 0 0 0 ]
[ 1 1.0852 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.0977 -138.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.0625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Life) show
91.625 15.125 moveto
(expectancy) show
175.250 15.125 moveto
(Males) show
214.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.22414 0 m
.92954 .16815 L
s
.2577 .00381 m
.25731 .0121 L
s
gsave
.2582 -0.00684 -76.607 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1960) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.32359 .01953 m
.32332 .02782 L
s
gsave
.32392 .00887 -76.8575 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1970) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.38843 .035 m
.38829 .04329 L
s
gsave
.38861 .02434 -77.1023 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1980) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.45226 .05023 m
.45225 .05852 L
s
gsave
.45228 .03957 -77.3415 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5151 .06522 m
.51521 .07352 L
s
gsave
.51497 .05456 -77.5755 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1990) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.57698 .07999 m
.5772 .08828 L
s
gsave
.5767 .06933 -77.8043 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63791 .09453 m
.63824 .10281 L
s
gsave
.63748 .08387 -78.0281 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1996) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.69792 .10885 m
.69836 .11713 L
s
gsave
.69735 .0982 -78.247 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75702 .12295 m
.75757 .13123 L
s
gsave
.75631 .11231 -78.4613 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1998) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.81524 .13685 m
.8159 .14511 L
s
gsave
.8144 .12622 -78.6711 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.8726 .15054 m
.87336 .15879 L
s
gsave
.87163 .13992 -78.8765 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2000) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.05262 .40011 L
s
.21755 .005 m
.22562 .00691 L
s
gsave
.20718 .00253 -115.312 -11.0388 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Turkey) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.060 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.21034 .02183 m
.21841 .02373 L
s
gsave
.19996 .01939 -108.125 -11.0261 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Korea) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.258 0.000 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.20324 .03838 m
.21132 .04026 L
s
gsave
.19286 .03596 -122.5 -11.0137 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hungary) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.456 0.000 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.19627 .05465 m
.20435 .05652 L
s
gsave
.18588 .05225 -115.312 -11.0016 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poland) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.654 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18941 .07065 m
.1975 .0725 L
s
gsave
.17902 .06827 -180 -11.22 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Slovak) show
113.312 12.875 moveto
(Republic) show
170.812 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.852 0.000 setrgbcolor
(\\346) show
178.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18267 .08639 m
.19075 .08822 L
s
gsave
.17227 .08403 -115.312 -11.2079 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mexico) show
106.125 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.950 1.000 0.000 setrgbcolor
(\\346) show
113.312 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.17603 .10187 m
.18412 .10369 L
s
gsave
.16563 .09953 -129.688 -10.9664 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Portugal) show
120.500 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.752 1.000 0.000 setrgbcolor
(\\346) show
127.688 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1695 .11711 m
.1776 .11891 L
s
gsave
.1591 .11479 -172.812 -11.1843 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Czech) show
106.125 12.875 moveto
(Republic) show
163.625 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.554 1.000 0.000 setrgbcolor
(\\346) show
170.812 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.16308 .13209 m
.17118 .13388 L
s
gsave
.15267 .12979 -122.5 -11.1728 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Finland) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.356 1.000 0.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15676 .14684 m
.16486 .14862 L
s
gsave
.14634 .14456 -165.625 -11.1616 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(United) show
113.312 12.875 moveto
(States) show
156.438 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.158 1.000 0.000 setrgbcolor
(\\346) show
163.625 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15054 .16136 m
.15864 .16312 L
s
gsave
.14012 .1591 -144.062 -10.9223 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Luxembourg) show
134.875 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.040 setrgbcolor
(\\346) show
142.062 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.14441 .17565 m
.15252 .1774 L
s
gsave
.13399 .17341 -122.5 -10.9117 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ireland) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.238 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13838 .18972 m
.14649 .19145 L
s
gsave
.12796 .1875 -122.5 -10.9013 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Germany) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.436 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13245 .20357 m
.14056 .20529 L
s
gsave
.12202 .20136 -122.5 -11.1183 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Austria) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.634 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1266 .21721 m
.13472 .21891 L
s
gsave
.11617 .21502 -122.5 -11.1079 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Belgium) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.832 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.12085 .23064 m
.12896 .23233 L
s
gsave
.11041 .22847 -115.312 -10.8712 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(France) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.970 1.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.11518 .24387 m
.1233 .24555 L
s
gsave
.10473 .24172 -122.5 -10.8615 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Denmark) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.772 1.000 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10959 .25691 m
.11771 .25857 L
s
gsave
.09915 .25477 -172.812 -11.0778 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(United) show
113.312 12.875 moveto
(Kingdom) show
163.625 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.574 1.000 setrgbcolor
(\\346) show
170.812 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10409 .26975 m
.11221 .2714 L
s
gsave
.09364 .26762 -151.25 -10.8426 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(New) show
91.750 12.500 moveto
(Zealand) show
142.062 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.376 1.000 setrgbcolor
(\\346) show
149.250 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.09867 .2824 m
.1068 .28403 L
s
gsave
.08822 .28029 -108.125 -11.0586 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Spain) show
98.938 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.178 1.000 setrgbcolor
(\\346) show
106.125 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.09333 .29486 m
.10146 .29649 L
s
gsave
.08287 .29277 -115.312 -10.8242 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Greece) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.020 0.000 1.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08806 .30714 m
.0962 .30876 L
s
gsave
.0776 .30507 -136.875 -11.04 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Australia) show
127.688 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.218 0.000 1.000 setrgbcolor
(\\346) show
134.875 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08287 .31925 m
.09101 .32085 L
s
gsave
.07241 .31719 -108.125 -10.8065 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Italy) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.416 0.000 1.000 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07776 .33119 m
.0859 .33277 L
s
gsave
.06729 .32914 -151.25 -10.7978 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Netherlands) show
142.062 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.614 0.000 1.000 setrgbcolor
(\\346) show
149.250 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07272 .34295 m
.08086 .34453 L
s
gsave
.06225 .34092 -115.312 -10.7892 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Norway) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.812 0.000 1.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.06775 .35455 m
.07589 .35611 L
s
gsave
.05728 .35254 -151.25 -11.0044 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Switzerland) show
142.062 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.990 setrgbcolor
(\\346) show
149.250 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.06285 .36598 m
.07099 .36754 L
s
gsave
.05237 .36399 -108.125 -10.7726 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Japan) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.792 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.05801 .37726 m
.06616 .3788 L
s
gsave
.04754 .37528 -115.312 -10.7644 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Canada) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.594 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.05325 .38838 m
.0614 .38991 L
s
gsave
.04277 .38641 -115.312 -10.7564 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sweden) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.396 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04855 .39935 m
.0567 .40087 L
s
gsave
.03807 .39739 -122.5 -10.7484 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Iceland) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.198 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.18462 .72262 L
s
.22414 0 m
.23134 .00172 L
s
[(0)] .20973 -0.00343 1 .23837 Mshowa
.21593 .15015 m
.22316 .15174 L
s
[(20)] .20146 .14697 1 .22014 Mshowa
.20713 .31107 m
.21439 .31253 L
s
[(40)] .19261 .30816 1 .20065 Mshowa
.19767 .48397 m
.20496 .48528 L
s
[(60)] .1831 .48135 1 .17975 Mshowa
.18749 .67023 m
.1948 .67138 L
s
[(80)] .17286 .66793 1 .15728 Mshowa
.125 Mabswid
.22214 .03659 m
.22646 .0376 L
s
.2201 .0738 m
.22443 .07479 L
s
.21803 .11165 m
.22237 .11262 L
s
.21378 .18933 m
.21813 .19026 L
s
.2116 .22919 m
.21595 .23011 L
s
.20939 .26977 m
.21374 .27066 L
s
.20483 .35312 m
.20919 .35398 L
s
.20249 .39594 m
.20685 .39677 L
s
.2001 .43955 m
.20447 .44036 L
s
.1952 .52922 m
.19957 .52999 L
s
.19268 .57534 m
.19706 .57607 L
s
.19011 .62233 m
.19449 .62304 L
s
.18482 .71907 m
.18921 .71973 L
s
.4 g
.25 Mabswid
.22092 .05884 m
.04821 .4513 L
s
.21761 .11929 m
.04369 .5036 L
s
.21422 .18144 m
.03908 .55706 L
s
.21072 .24534 m
.03437 .61172 L
s
.20713 .31107 m
.02954 .66761 L
s
.20343 .37872 m
.02461 .72478 L
s
.19962 .44837 m
.01956 .78327 L
s
.1957 .52011 m
.0144 .84313 L
s
.19165 .59403 m
.00911 .9044 L
s
.05262 .40011 m
0 1.01003 L
s
.04821 .4513 m
.63933 .55795 L
s
.04369 .5036 m
.64114 .60767 L
s
.03908 .55706 m
.64299 .65842 L
s
.03437 .61172 m
.64487 .71021 L
s
.02954 .66761 m
.6468 .76309 L
s
.02461 .72478 m
.64876 .81709 L
s
.01956 .78327 m
.65077 .87224 L
s
.0144 .84313 m
.65282 .92859 L
s
.00911 .9044 m
.65492 .98617 L
s
0 0 m
1 0 L
1 1.0852 L
0 1.0852 L
closepath
clip
newpath
.58991 .50033 m .60703 .49967 L .60426 .50301 L .954 0 .189 r
F
.61155 .74964 m .60703 .49967 L .60426 .50301 L .789 0 .156 r
F
.5755 .49765 m .57822 .49428 L .58991 .50033 L .954 0 .189 r
F
.58991 .50033 m .57822 .49428 L .60703 .49967 L F
.61963 1.02277 m .60703 .49967 L .61155 .74964 L .789 0 .156 r
F
.61963 1.02277 m .62274 1.02036 L .60703 .49967 L F
.57822 .49428 m .62274 1.02036 L .60703 .49967 L .977 0 .193 r
F
.58135 .74494 m .57822 .49428 L .5755 .49765 L .779 0 .154 r
F
.58605 .48459 m .60942 .4968 L .58056 .49139 L .954 0 .378 r
F
.58605 .48459 m .61503 .49005 L .60942 .4968 L F
.58056 .49139 m .62537 1.01681 L .60942 .4968 L .977 0 .387 r
F
.61503 .49005 m .60942 .4968 L .62537 1.01681 L .789 0 .312 r
F
.57822 .49428 m .59087 1.01648 L .62274 1.02036 L .977 0 .193 r
F
.58782 1.01891 m .57822 .49428 L .58135 .74494 L .779 0 .154 r
F
.58782 1.01891 m .59087 1.01648 L .57822 .49428 L F
.54168 .49134 m .55889 .49067 L .55621 .49405 L .954 0 .189 r
F
.56107 .74145 m .55889 .49067 L .55621 .49405 L .772 0 .153 r
F
.58056 .49139 m .59345 1.0129 L .62537 1.01681 L .977 0 .387 r
F
.58605 .48459 m .58056 .49139 L .59345 1.0129 L .779 0 .308 r
F
.5271 .48862 m .52972 .48521 L .54168 .49134 L .954 0 .189 r
F
.54168 .49134 m .52972 .48521 L .55889 .49067 L F
.56646 1.01557 m .55889 .49067 L .56107 .74145 L .772 0 .153 r
F
.56646 1.01557 m .56946 1.01313 L .55889 .49067 L F
.52972 .48521 m .56946 1.01313 L .55889 .49067 L .977 0 .193 r
F
.61503 .49005 m .62537 1.01681 L .63166 1.01193 L .789 0 .312 r
F
.58605 .48459 m .63166 1.01193 L .61503 .49005 L .977 0 .387 r
F
.53048 .73669 m .52972 .48521 L .5271 .48862 L .761 0 .151 r
F
.53728 .4754 m .5612 .48776 L .53198 .48228 L .954 0 .378 r
F
.53728 .4754 m .56661 .48092 L .5612 .48776 L F
.53198 .48228 m .57196 1.00729 L .5612 .48776 L .977 0 .387 r
F
.56661 .48092 m .5612 .48776 L .57196 1.00729 L .772 0 .306 r
F
.59398 .47476 m .61744 .48713 L .58842 .48165 L .954 0 .567 r
F
.59398 .47476 m .62312 .48029 L .61744 .48713 L F
.59398 .47476 m .61744 .48713 L .58842 .48165 L F
.59398 .47476 m .62312 .48029 L .61744 .48713 L F
.52972 .48521 m .53716 1.00919 L .56946 1.01313 L .977 0 .193 r
F
.53424 1.01165 m .52972 .48521 L .53048 .73669 L .761 0 .151 r
F
.53424 1.01165 m .53716 1.00919 L .52972 .48521 L F
.49286 .48223 m .51016 .48155 L .50757 .48497 L .954 0 .189 r
F
.50994 .73181 m .51016 .48155 L .50757 .48497 L .754 0 .149 r
F
.58605 .48459 m .5996 1.00799 L .63166 1.01193 L .977 0 .387 r
F
.58605 .48459 m .59345 1.0129 L .5996 1.00799 L .779 0 .308 r
F
.53198 .48228 m .53963 1.00333 L .57196 1.00729 L .977 0 .387 r
F
.53728 .4754 m .53198 .48228 L .53963 1.00333 L .761 0 .302 r
F
.4781 .47948 m .48063 .47603 L .49286 .48223 L .954 0 .189 r
F
.49286 .48223 m .48063 .47603 L .51016 .48155 L F
.51257 1.00528 m .51016 .48155 L .50994 .73181 L .754 0 .149 r
F
.51257 1.00528 m .51545 1.0028 L .51016 .48155 L F
.48063 .47603 m .51545 1.0028 L .51016 .48155 L .977 0 .193 r
F
.56661 .48092 m .57196 1.00729 L .57802 1.00234 L .772 0 .306 r
F
.53728 .4754 m .57802 1.00234 L .56661 .48092 L .977 0 .387 r
F
.47897 .72698 m .48063 .47603 L .4781 .47948 L .742 0 .147 r
F
.48792 .46609 m .51238 .47861 L .48281 .47306 L .954 0 .378 r
F
.48792 .46609 m .51761 .47169 L .51238 .47861 L F
.48281 .47306 m .51792 .99991 L .51238 .47861 L .977 0 .387 r
F
.51761 .47169 m .51238 .47861 L .51792 .99991 L .754 0 .298 r
F
.54495 .46545 m .56895 .47798 L .53957 .47243 L .954 0 .567 r
F
.54495 .46545 m .57444 .47105 L .56895 .47798 L F
.53957 .47243 m .58052 .99495 L .56895 .47798 L .977 0 .58 r
F
.57444 .47105 m .56895 .47798 L .58052 .99495 L .772 0 .459 r
F
.60202 .46481 m .62557 .47734 L .59638 .47179 L .954 0 .756 r
F
.60202 .46481 m .63132 .47041 L .62557 .47734 L F
.59638 .47179 m .64356 1.00426 L .62557 .47734 L .976 0 .773 r
F
.63132 .47041 m .62557 .47734 L .64356 1.00426 L .789 0 .625 r
F
.48063 .47603 m .48274 .9988 L .51545 1.0028 L .977 0 .193 r
F
.47993 1.00129 m .48063 .47603 L .47897 .72698 L .742 0 .147 r
F
.47993 1.00129 m .48274 .9988 L .48063 .47603 L F
.44345 .47301 m .46082 .47233 L .45834 .47579 L .954 0 .189 r
F
.45819 .7217 m .46082 .47233 L .45834 .47579 L .733 0 .145 r
F
.53728 .4754 m .54555 .99834 L .57802 1.00234 L .977 0 .387 r
F
.53728 .4754 m .53963 1.00333 L .54555 .99834 L .761 0 .302 r
F
.48281 .47306 m .48515 .99589 L .51792 .99991 L .977 0 .387 r
F
.48792 .46609 m .48281 .47306 L .48515 .99589 L .742 0 .294 r
F
.42851 .47023 m .43094 .46674 L .44345 .47301 L .954 0 .189 r
F
.44345 .47301 m .43094 .46674 L .46082 .47233 L F
.53957 .47243 m .54802 .99091 L .58052 .99495 L .977 0 .58 r
F
.54495 .46545 m .53957 .47243 L .54802 .99091 L .761 0 .452 r
F
.45802 .99411 m .46082 .47233 L .45819 .7217 L .733 0 .145 r
F
.45802 .99411 m .46078 .99159 L .46082 .47233 L F
.43094 .46674 m .46078 .99159 L .46082 .47233 L .977 0 .193 r
F
.59638 .47179 m .61124 1.00025 L .64356 1.00426 L .976 0 .773 r
F
.60202 .46481 m .59638 .47179 L .61124 1.00025 L .779 0 .617 r
F
.51761 .47169 m .51792 .99991 L .52375 .99489 L .754 0 .298 r
F
.48792 .46609 m .52375 .99489 L .51761 .47169 L .977 0 .387 r
F
.57444 .47105 m .58052 .99495 L .58666 .98991 L .772 0 .459 r
F
.54495 .46545 m .58666 .98991 L .57444 .47105 L .976 0 .58 r
F
.63132 .47041 m .64356 1.00426 L .65004 .99926 L .789 0 .625 r
F
.60202 .46481 m .65004 .99926 L .63132 .47041 L .976 0 .773 r
F
.42683 .71681 m .43094 .46674 L .42851 .47023 L .719 0 .142 r
F
.43794 .45668 m .46297 .46935 L .43303 .46373 L .954 0 .378 r
F
.43794 .45668 m .468 .46234 L .46297 .46935 L F
.43303 .46373 m .46316 .99168 L .46297 .46935 L .977 0 .387 r
F
.468 .46234 m .46297 .46935 L .46316 .99168 L .733 0 .29 r
F
.4953 .45603 m .51986 .46871 L .49012 .46309 L .954 0 .567 r
F
.4953 .45603 m .52516 .4617 L .51986 .46871 L F
.49012 .46309 m .52618 .98593 L .51986 .46871 L .977 0 .58 r
F
.52516 .4617 m .51986 .46871 L .52618 .98593 L .754 0 .448 r
F
.55271 .45538 m .57681 .46807 L .54726 .46244 L .954 0 .756 r
F
.55271 .45538 m .58237 .46105 L .57681 .46807 L F
.54726 .46244 m .58946 .99377 L .57681 .46807 L .976 0 .773 r
F
.58237 .46105 m .57681 .46807 L .58946 .99377 L .772 0 .612 r
F
.61017 .45473 m .6338 .46742 L .60446 .4618 L .954 0 .945 r
F
.61017 .45473 m .63963 .4604 L .6338 .46742 L F
.61017 .45473 m .6338 .46742 L .60446 .4618 L F
.61017 .45473 m .63963 .4604 L .6338 .46742 L F
.43094 .46674 m .42765 .98751 L .46078 .99159 L .977 0 .193 r
F
.42497 .99006 m .43094 .46674 L .42683 .71681 L .719 0 .142 r
F
.42497 .99006 m .42765 .98751 L .43094 .46674 L F
.39343 .46368 m .41089 .46299 L .4085 .46649 L .954 0 .189 r
F
.40579 .71284 m .41089 .46299 L .4085 .46649 L .71 0 .14 r
F
.48792 .46609 m .49083 .99083 L .52375 .99489 L .977 0 .387 r
F
.48792 .46609 m .48515 .99589 L .49083 .99083 L .742 0 .294 r
F
.54495 .46545 m .55402 .98582 L .58666 .98991 L .976 0 .58 r
F
.54495 .46545 m .54802 .99091 L .55402 .98582 L .761 0 .452 r
F
.60202 .46481 m .61758 .9952 L .65004 .99926 L .976 0 .773 r
F
.60202 .46481 m .61124 1.00025 L .61758 .9952 L .779 0 .617 r
F
.43303 .46373 m .42995 .9876 L .46316 .99168 L .977 0 .387 r
F
.43794 .45668 m .43303 .46373 L .42995 .9876 L .719 0 .285 r
F
.3783 .46086 m .38063 .45733 L .39343 .46368 L .954 0 .189 r
F
.39343 .46368 m .38063 .45733 L .41089 .46299 L F
.49012 .46309 m .49325 .98183 L .52618 .98593 L .977 0 .58 r
F
.4953 .45603 m .49012 .46309 L .49325 .98183 L .742 0 .441 r
F
.4028 .98583 m .41089 .46299 L .40579 .71284 L .71 0 .14 r
F
.4028 .98583 m .40543 .98327 L .41089 .46299 L F
.38063 .45733 m .40543 .98327 L .41089 .46299 L .977 0 .193 r
F
.55402 .98582 m .58052 .99495 L .54802 .99091 L .872 0 .518 r
F
.55402 .98582 m .58666 .98991 L .58052 .99495 L F
.54726 .46244 m .55672 .98969 L .58946 .99377 L .976 0 .773 r
F
.55271 .45538 m .54726 .46244 L .55672 .98969 L .761 0 .603 r
F
.468 .46234 m .46316 .99168 L .46874 .98658 L .733 0 .29 r
F
.43794 .45668 m .46874 .98658 L .468 .46234 L .977 0 .387 r
F
.52516 .4617 m .52618 .98593 L .53208 .98081 L .754 0 .448 r
F
.4953 .45603 m .53208 .98081 L .52516 .4617 L .976 0 .58 r
F
.58237 .46105 m .58946 .99377 L .5957 .98868 L .772 0 .612 r
F
.55271 .45538 m .5957 .98868 L .58237 .46105 L .976 0 .773 r
F
.37403 .70788 m .38063 .45733 L .3783 .46086 L .694 0 .137 r
F
.38734 .44714 m .41294 .45997 L .38263 .45429 L .954 0 .378 r
F
.38734 .44714 m .41777 .45288 L .41294 .45997 L F
.38263 .45429 m .40767 .98334 L .41294 .45997 L .977 0 .387 r
F
.41777 .45288 m .41294 .45997 L .40767 .98334 L .71 0 .281 r
F
.44504 .44649 m .47017 .45932 L .44006 .45363 L .954 0 .567 r
F
.44504 .44649 m .47527 .45223 L .47017 .45932 L F
.44006 .45363 m .47114 .97756 L .47017 .45932 L .977 0 .58 r
F
.47527 .45223 m .47017 .45932 L .47114 .97756 L .733 0 .435 r
F
.50278 .44583 m .52745 .45867 L .49753 .45298 L .954 0 .756 r
F
.50278 .44583 m .53281 .45157 L .52745 .45867 L F
.49753 .45298 m .53475 .98771 L .52745 .45867 L .976 0 .773 r
F
.53281 .45157 m .52745 .45867 L .53475 .98771 L .754 0 .597 r
F
.56058 .44517 m .58477 .45802 L .55506 .45233 L .954 0 .945 r
F
.56058 .44517 m .59041 .45092 L .58477 .45802 L F
.55506 .45233 m .59833 .9842 L .58477 .45802 L .976 0 .966 r
F
.59041 .45092 m .58477 .45802 L .59833 .9842 L .772 0 .764 r
F
.61842 .44451 m .64214 .45738 L .61263 .45167 L .775 0 .954 r
F
.61842 .44451 m .64805 .45026 L .64214 .45738 L F
.61263 .45167 m .66178 .97765 L .64214 .45738 L .792 0 .976 r
F
.64805 .45026 m .64214 .45738 L .66178 .97765 L .64 0 .789 r
F
.38063 .45733 m .37185 .97913 L .40543 .98327 L .977 0 .193 r
F
.36929 .98171 m .38063 .45733 L .37403 .70788 L .694 0 .137 r
F
.36929 .98171 m .37185 .97913 L .38063 .45733 L F
.34278 .45424 m .36033 .45353 L .35804 .45708 L .954 0 .189 r
F
.35269 .70557 m .36033 .45353 L .35804 .45708 L .683 0 .135 r
F
.43794 .45668 m .43538 .98246 L .46874 .98658 L .977 0 .387 r
F
.43794 .45668 m .42995 .9876 L .43538 .98246 L .719 0 .285 r
F
.4953 .45603 m .499 .97666 L .53208 .98081 L .976 0 .58 r
F
.4953 .45603 m .49325 .98183 L .499 .97666 L .742 0 .441 r
F
.55271 .45538 m .56281 .98456 L .5957 .98868 L .976 0 .773 r
F
.55271 .45538 m .55672 .98969 L .56281 .98456 L .761 0 .603 r
F
.38263 .45429 m .37402 .97919 L .40767 .98334 L .977 0 .387 r
F
.38734 .44714 m .38263 .45429 L .37402 .97919 L .694 0 .275 r
F
.32747 .45138 m .32969 .4478 L .34278 .45424 L .954 0 .189 r
F
.34278 .45424 m .32969 .4478 L .36033 .45353 L F
.44006 .45363 m .43776 .97339 L .47114 .97756 L .977 0 .58 r
F
.44504 .44649 m .44006 .45363 L .43776 .97339 L .719 0 .427 r
F
.34676 .98123 m .36033 .45353 L .35269 .70557 L .683 0 .135 r
F
.34676 .98123 m .34927 .97864 L .36033 .45353 L F
.32969 .4478 m .34927 .97864 L .36033 .45353 L .977 0 .193 r
F
.499 .97666 m .52618 .98593 L .49325 .98183 L .873 0 .518 r
F
.499 .97666 m .53208 .98081 L .52618 .98593 L F
.49753 .45298 m .50156 .98358 L .53475 .98771 L .976 0 .773 r
F
.50278 .44583 m .49753 .45298 L .50156 .98358 L .742 0 .587 r
F
.41777 .45288 m .40767 .98334 L .41301 .97817 L .71 0 .281 r
F
.38734 .44714 m .41301 .97817 L .41777 .45288 L .977 0 .387 r
F
.55506 .45233 m .5654 .98005 L .59833 .9842 L .976 0 .966 r
F
.56058 .44517 m .55506 .45233 L .5654 .98005 L .761 0 .754 r
F
.47527 .45223 m .47114 .97756 L .4768 .97236 L .733 0 .435 r
F
.44504 .44649 m .4768 .97236 L .47527 .45223 L .976 0 .58 r
F
.61263 .45167 m .62914 .97348 L .66178 .97765 L .792 0 .976 r
F
.61842 .44451 m .61263 .45167 L .62914 .97348 L .632 0 .779 r
F
.53281 .45157 m .53475 .98771 L .54075 .98256 L .754 0 .597 r
F
.50278 .44583 m .54075 .98256 L .53281 .45157 L .976 0 .773 r
F
.32051 .70054 m .32969 .4478 L .32747 .45138 L .665 0 .132 r
F
.59041 .45092 m .59833 .9842 L .60466 .97902 L .772 0 .764 r
F
.56058 .44517 m .60466 .97902 L .59041 .45092 L .976 0 .966 r
F
.3361 .43749 m .3623 .45048 L .33161 .44472 L .954 0 .378 r
F
.3361 .43749 m .36692 .4433 L .3623 .45048 L F
.33161 .44472 m .35152 .97184 L .3623 .45048 L .977 0 .387 r
F
.36692 .4433 m .3623 .45048 L .35152 .97184 L .683 0 .27 r
F
.64805 .45026 m .66178 .97765 L .66843 .97244 L .64 0 .789 r
F
.61842 .44451 m .66843 .97244 L .64805 .45026 L .792 0 .975 r
F
.39414 .43682 m .41986 .44982 L .38937 .44406 L .954 0 .567 r
F
.39414 .43682 m .42475 .44264 L .41986 .44982 L F
.38937 .44406 m .41538 .96831 L .41986 .44982 L .977 0 .58 r
F
.42475 .44264 m .41986 .44982 L .41538 .96831 L .71 0 .421 r
F
.45223 .43616 m .47747 .44916 L .44718 .4434 L .954 0 .756 r
F
.45223 .43616 m .48264 .44197 L .47747 .44916 L F
.44718 .4434 m .47927 .98081 L .47747 .44916 L .976 0 .773 r
F
.48264 .44197 m .47747 .44916 L .47927 .98081 L .733 0 .581 r
F
.51036 .43549 m .53513 .44851 L .50505 .44274 L .954 0 .945 r
F
.51036 .43549 m .54057 .44131 L .53513 .44851 L F
.50505 .44274 m .54324 .97345 L .53513 .44851 L .976 0 .966 r
F
.54057 .44131 m .53513 .44851 L .54324 .97345 L .754 0 .746 r
F
.56855 .43482 m .59284 .44785 L .56296 .44208 L .775 0 .954 r
F
.56855 .43482 m .59855 .44065 L .59284 .44785 L F
.56296 .44208 m .60714 .96763 L .59284 .44785 L .792 0 .976 r
F
.59855 .44065 m .59284 .44785 L .60714 .96763 L .627 0 .772 r
F
.32969 .4478 m .31521 .97446 L .34927 .97864 L .977 0 .193 r
F
.31278 .97707 m .32969 .4478 L .32051 .70054 L .665 0 .132 r
F
.31278 .97707 m .31521 .97446 L .32969 .4478 L F
.29151 .44467 m .30914 .44396 L .30696 .44755 L .954 0 .189 r
F
.299 .69443 m .30914 .44396 L .30696 .44755 L .653 0 .129 r
F
.62679 .43415 m .6506 .44719 L .62092 .44141 L .586 0 .954 r
F
.62679 .43415 m .65658 .43998 L .6506 .44719 L F
.62092 .44141 m .67115 .96638 L .6506 .44719 L .599 0 .975 r
F
.65658 .43998 m .6506 .44719 L .67115 .96638 L .484 0 .789 r
F
.38734 .44714 m .3792 .97398 L .41301 .97817 L .977 0 .387 r
F
.38734 .44714 m .37402 .97919 L .3792 .97398 L .694 0 .275 r
F
.44504 .44649 m .44327 .96815 L .4768 .97236 L .976 0 .58 r
F
.44504 .44649 m .43776 .97339 L .44327 .96815 L .719 0 .427 r
F
.50278 .44583 m .50741 .97838 L .54075 .98256 L .976 0 .773 r
F
.50278 .44583 m .50156 .98358 L .50741 .97838 L .742 0 .587 r
F
.56058 .44517 m .57159 .97483 L .60466 .97902 L .976 0 .966 r
F
.56058 .44517 m .5654 .98005 L .57159 .97483 L .761 0 .754 r
F
.33161 .44472 m .31743 .96762 L .35152 .97184 L .977 0 .387 r
F
.3361 .43749 m .33161 .44472 L .31743 .96762 L .665 0 .263 r
F
.276 .44178 m .27812 .43816 L .29151 .44467 L .954 0 .189 r
F
.29151 .44467 m .27812 .43816 L .30914 .44396 L F
.61842 .44451 m .63565 .96823 L .66843 .97244 L .792 0 .975 r
F
.61842 .44451 m .62914 .97348 L .63565 .96823 L .632 0 .779 r
F
.38937 .44406 m .38155 .96408 L .41538 .96831 L .977 0 .58 r
F
.39414 .43682 m .38937 .44406 L .38155 .96408 L .694 0 .412 r
F
.29017 .96817 m .30914 .44396 L .299 .69443 L .653 0 .129 r
F
.29017 .96817 m .29254 .96553 L .30914 .44396 L F
.27812 .43816 m .29254 .96553 L .30914 .44396 L .977 0 .193 r
F
.44327 .96815 m .47114 .97756 L .43776 .97339 L .873 0 .519 r
F
.44327 .96815 m .4768 .97236 L .47114 .97756 L F
.44718 .4434 m .44562 .97661 L .47927 .98081 L .976 0 .773 r
F
.45223 .43616 m .44718 .4434 L .44562 .97661 L .719 0 .57 r
F
.36692 .4433 m .35152 .97184 L .3566 .96658 L .683 0 .27 r
F
.3361 .43749 m .3566 .96658 L .36692 .4433 L .977 0 .387 r
F
.50505 .44274 m .50987 .96923 L .54324 .97345 L .976 0 .966 r
F
.51036 .43549 m .50505 .44274 L .50987 .96923 L .742 0 .734 r
F
.42475 .44264 m .41538 .96831 L .42078 .96303 L .71 0 .421 r
F
.39414 .43682 m .42078 .96303 L .42475 .44264 L .976 0 .58 r
F
.56296 .44208 m .57406 .96339 L .60714 .96763 L .792 0 .976 r
F
.56855 .43482 m .56296 .44208 L .57406 .96339 L .618 0 .761 r
F
.48264 .44197 m .47927 .98081 L .48503 .97557 L .733 0 .581 r
F
.45223 .43616 m .48503 .97557 L .48264 .44197 L .976 0 .773 r
F
.2664 .68933 m .27812 .43816 L .276 .44178 L .633 0 .125 r
F
.62092 .44141 m .63833 .96213 L .67115 .96638 L .599 0 .975 r
F
.62679 .43415 m .62092 .44141 L .63833 .96213 L .478 0 .779 r
F
.54057 .44131 m .54324 .97345 L .54932 .96818 L .754 0 .746 r
F
.51036 .43549 m .54932 .96818 L .54057 .44131 L .976 0 .966 r
F
.28422 .42771 m .31102 .44086 L .27994 .43504 L .954 0 .378 r
F
.28422 .42771 m .31543 .43359 L .31102 .44086 L F
.27994 .43504 m .29481 .95638 L .31102 .44086 L .977 0 .387 r
F
.31543 .43359 m .31102 .44086 L .29481 .95638 L .653 0 .258 r
F
.59855 .44065 m .60714 .96763 L .61355 .96233 L .627 0 .772 r
F
.56855 .43482 m .61355 .96233 L .59855 .44065 L .792 0 .975 r
F
.3426 .42704 m .36892 .4402 L .33805 .43437 L .954 0 .567 r
F
.3426 .42704 m .3736 .43292 L .36892 .4402 L F
.33805 .43437 m .35891 .95818 L .36892 .4402 L .977 0 .58 r
F
.3736 .43292 m .36892 .4402 L .35891 .95818 L .683 0 .406 r
F
.65658 .43998 m .67115 .96638 L .6779 .96108 L .484 0 .789 r
F
.62679 .43415 m .6779 .96108 L .65658 .43998 L .599 0 .975 r
F
.40104 .42636 m .42687 .43954 L .3962 .4337 L .954 0 .756 r
F
.40104 .42636 m .43183 .43225 L .42687 .43954 L F
.3962 .4337 m .42303 .97226 L .42687 .43954 L .976 0 .773 r
F
.43183 .43225 m .42687 .43954 L .42303 .97226 L .71 0 .562 r
F
.45952 .42569 m .48487 .43887 L .4544 .43303 L .954 0 .945 r
F
.45952 .42569 m .4901 .43158 L .48487 .43887 L F
.4544 .43303 m .48748 .9664 L .48487 .43887 L .976 0 .966 r
F
.4901 .43158 m .48487 .43887 L .48748 .9664 L .733 0 .726 r
F
.51805 .42501 m .54291 .4382 L .51266 .43236 L .775 0 .954 r
F
.51805 .42501 m .54843 .43091 L .54291 .4382 L F
.51266 .43236 m .55184 .95977 L .54291 .4382 L .792 0 .976 r
F
.54843 .43091 m .54291 .4382 L .55184 .95977 L .612 0 .754 r
F
.27812 .43816 m .25805 .96127 L .29254 .96553 L .977 0 .193 r
F
.25576 .96393 m .27812 .43816 L .2664 .68933 L .633 0 .125 r
F
.25576 .96393 m .25805 .96127 L .27812 .43816 L F
.23959 .43499 m .25731 .43426 L .25523 .4379 L .954 0 .189 r
F
.24468 .68246 m .25731 .43426 L .25523 .4379 L .618 0 .122 r
F
.57663 .42433 m .60101 .43754 L .57096 .43169 L .586 0 .954 r
F
.57663 .42433 m .6068 .43024 L .60101 .43754 L F
.57096 .43169 m .61625 .95775 L .60101 .43754 L .599 0 .975 r
F
.6068 .43024 m .60101 .43754 L .61625 .95775 L .474 0 .772 r
F
.3361 .43749 m .32235 .96232 L .3566 .96658 L .977 0 .387 r
F
.3361 .43749 m .31743 .96762 L .32235 .96232 L .665 0 .263 r
F
.63527 .42365 m .65916 .43687 L .62932 .43102 L .397 0 .954 r
F
.63527 .42365 m .66523 .42957 L .65916 .43687 L F
.63527 .42365 m .65916 .43687 L .62932 .43102 L F
.63527 .42365 m .66523 .42957 L .65916 .43687 L F
.39414 .43682 m .38681 .95876 L .42078 .96303 L .976 0 .58 r
F
.39414 .43682 m .38155 .96408 L .38681 .95876 L .694 0 .412 r
F
.45223 .43616 m .45122 .97134 L .48503 .97557 L .976 0 .773 r
F
.45223 .43616 m .44562 .97661 L .45122 .97134 L .719 0 .57 r
F
.51036 .43549 m .51581 .96392 L .54932 .96818 L .976 0 .966 r
F
.51036 .43549 m .50987 .96923 L .51581 .96392 L .742 0 .734 r
F
.27994 .43504 m .26029 .95207 L .29481 .95638 L .977 0 .387 r
F
.28422 .42771 m .27994 .43504 L .26029 .95207 L .633 0 .251 r
F
.22389 .43206 m .22589 .42839 L .23959 .43499 L .954 0 .189 r
F
.23959 .43499 m .22589 .42839 L .25731 .43426 L F
.56855 .43482 m .58032 .95805 L .61355 .96233 L .792 0 .975 r
F
.56855 .43482 m .57406 .96339 L .58032 .95805 L .618 0 .761 r
F
.33805 .43437 m .32463 .95388 L .35891 .95818 L .977 0 .58 r
F
.3426 .42704 m .33805 .43437 L .32463 .95388 L .665 0 .395 r
F
.23299 .95343 m .25731 .43426 L .24468 .68246 L .618 0 .122 r
F
.23299 .95343 m .23523 .95074 L .25731 .43426 L F
.22589 .42839 m .23523 .95074 L .25731 .43426 L .977 0 .193 r
F
.62679 .43415 m .64493 .95679 L .6779 .96108 L .599 0 .975 r
F
.62679 .43415 m .63833 .96213 L .64493 .95679 L .478 0 .779 r
F
.38681 .95876 m .41538 .96831 L .38155 .96408 L .874 0 .519 r
F
.38681 .95876 m .42078 .96303 L .41538 .96831 L F
.3962 .4337 m .38892 .96801 L .42303 .97226 L .976 0 .773 r
F
.40104 .42636 m .3962 .4337 L .38892 .96801 L .694 0 .55 r
F
.31543 .43359 m .29481 .95638 L .29961 .95101 L .653 0 .258 r
F
.28422 .42771 m .29961 .95101 L .31543 .43359 L .977 0 .387 r
F
.4544 .43303 m .45365 .96212 L .48748 .9664 L .976 0 .966 r
F
.45952 .42569 m .4544 .43303 L .45365 .96212 L .719 0 .712 r
F
.3736 .43292 m .35891 .95818 L .36405 .95281 L .683 0 .406 r
F
.3426 .42704 m .36405 .95281 L .3736 .43292 L .976 0 .58 r
F
.51266 .43236 m .5183 .95547 L .55184 .95977 L .792 0 .976 r
F
.51805 .42501 m .51266 .43236 L .5183 .95547 L .602 0 .742 r
F
.43183 .43225 m .42303 .97226 L .42853 .96695 L .71 0 .562 r
F
.40104 .42636 m .42853 .96695 L .43183 .43225 L .976 0 .773 r
F
.21168 .67728 m .22589 .42839 L .22389 .43206 L .596 0 .118 r
F
.57096 .43169 m .58297 .95344 L .61625 .95775 L .599 0 .975 r
F
.57663 .42433 m .57096 .43169 L .58297 .95344 L .467 0 .761 r
F
.4901 .43158 m .48748 .9664 L .49331 .96106 L .733 0 .726 r
F
.45952 .42569 m .49331 .96106 L .4901 .43158 L .976 0 .966 r
F
.23168 .41781 m .25909 .43113 L .22762 .42523 L .954 0 .378 r
F
.23168 .41781 m .26329 .42377 L .25909 .43113 L F
.22762 .42523 m .23745 .94152 L .25909 .43113 L .977 0 .387 r
F
.26329 .42377 m .25909 .43113 L .23745 .94152 L .618 0 .245 r
F
.54843 .43091 m .55184 .95977 L .558 .9544 L .612 0 .754 r
F
.51805 .42501 m .558 .9544 L .54843 .43091 L .792 0 .975 r
F
.29041 .41713 m .31733 .43046 L .28607 .42455 L .954 0 .567 r
F
.29041 .41713 m .32181 .42309 L .31733 .43046 L F
.28607 .42455 m .30178 .94562 L .31733 .43046 L .977 0 .58 r
F
.32181 .42309 m .31733 .43046 L .30178 .94562 L .653 0 .388 r
F
.6068 .43024 m .61625 .95775 L .62275 .95237 L .474 0 .772 r
F
.57663 .42433 m .62275 .95237 L .6068 .43024 L .599 0 .975 r
F
.34919 .41645 m .37563 .42979 L .34457 .42388 L .954 0 .756 r
F
.34919 .41645 m .38038 .42241 L .37563 .42979 L F
.34457 .42388 m .36609 .96051 L .37563 .42979 L .976 0 .773 r
F
.38038 .42241 m .37563 .42979 L .36609 .96051 L .683 0 .541 r
F
.40802 .41576 m .43397 .42911 L .40312 .4232 L .954 0 .945 r
F
.40802 .41576 m .439 .42173 L .43397 .42911 L F
.40312 .4232 m .43095 .95616 L .43397 .42911 L .976 0 .966 r
F
.439 .42173 m .43397 .42911 L .43095 .95616 L .71 0 .702 r
F
.46691 .41508 m .49236 .42844 L .46172 .42252 L .775 0 .954 r
F
.46691 .41508 m .49767 .42105 L .49236 .42844 L F
.46172 .42252 m .49578 .95181 L .49236 .42844 L .792 0 .976 r
F
.49767 .42105 m .49236 .42844 L .49578 .95181 L .595 0 .733 r
F
.22589 .42839 m .20031 .94639 L .23523 .95074 L .977 0 .193 r
F
.19815 .9491 m .22589 .42839 L .21168 .67728 L .596 0 .118 r
F
.19815 .9491 m .20031 .94639 L .22589 .42839 L F
.18701 .42518 m .20482 .42445 L .20286 .42813 L .954 0 .189 r
F
.18972 .67035 m .20482 .42445 L .20286 .42813 L .579 0 .115 r
F
.52584 .41439 m .55081 .42776 L .52038 .42184 L .586 0 .954 r
F
.52584 .41439 m .55639 .42037 L .55081 .42776 L F
.52038 .42184 m .56062 .94977 L .55081 .42776 L .599 0 .975 r
F
.55639 .42037 m .55081 .42776 L .56062 .94977 L .463 0 .754 r
F
.28422 .42771 m .26494 .94666 L .29961 .95101 L .977 0 .387 r
F
.28422 .42771 m .26029 .95207 L .26494 .94666 L .633 0 .251 r
F
.58482 .4137 m .6093 .42709 L .57908 .42116 L .397 0 .954 r
F
.58482 .4137 m .61517 .41969 L .6093 .42709 L F
.58482 .4137 m .6093 .42709 L .57908 .42116 L F
.58482 .4137 m .61517 .41969 L .6093 .42709 L F
.3426 .42704 m .32962 .94847 L .36405 .95281 L .976 0 .58 r
F
.3426 .42704 m .32463 .95388 L .32962 .94847 L .665 0 .395 r
F
.64386 .41302 m .66784 .42641 L .63783 .42048 L .208 0 .954 r
F
.64386 .41302 m .67399 .41901 L .66784 .42641 L F
.63783 .42048 m .69098 .95959 L .66784 .42641 L .212 0 .975 r
F
.67399 .41901 m .66784 .42641 L .69098 .95959 L .172 0 .789 r
F
.40104 .42636 m .39426 .96265 L .42853 .96695 L .976 0 .773 r
F
.40104 .42636 m .38892 .96801 L .39426 .96265 L .694 0 .55 r
F
.45952 .42569 m .45933 .95674 L .49331 .96106 L .976 0 .966 r
F
.45952 .42569 m .45365 .96212 L .45933 .95674 L .719 0 .712 r
F
.22762 .42523 m .20251 .93713 L .23745 .94152 L .977 0 .387 r
F
.23168 .41781 m .22762 .42523 L .20251 .93713 L .596 0 .236 r
F
.17111 .42221 m .17301 .4185 L .18701 .42518 L .954 0 .189 r
F
.18701 .42518 m .17301 .4185 L .20482 .42445 L F
.51805 .42501 m .52432 .95006 L .558 .9544 L .792 0 .975 r
F
.51805 .42501 m .5183 .95547 L .52432 .95006 L .602 0 .742 r
F
.28607 .42455 m .26706 .94124 L .30178 .94562 L .977 0 .58 r
F
.29041 .41713 m .28607 .42455 L .26706 .94124 L .633 0 .376 r
F
.17517 .93852 m .20482 .42445 L .18972 .67035 L .579 0 .115 r
F
.17517 .93852 m .17728 .93577 L .20482 .42445 L F
.17301 .4185 m .17728 .93577 L .20482 .42445 L .977 0 .193 r
F
.57663 .42433 m .58933 .94801 L .62275 .95237 L .599 0 .975 r
F
.57663 .42433 m .58297 .95344 L .58933 .94801 L .467 0 .761 r
F
.32962 .94847 m .35891 .95818 L .32463 .95388 L .875 0 .52 r
F
.32962 .94847 m .36405 .95281 L .35891 .95818 L F
.34457 .42388 m .33153 .95618 L .36609 .96051 L .976 0 .773 r
F
.34919 .41645 m .34457 .42388 L .33153 .95618 L .665 0 .527 r
F
.26329 .42377 m .23745 .94152 L .24198 .93604 L .618 0 .245 r
F
.23168 .41781 m .24198 .93604 L .26329 .42377 L .977 0 .387 r
F
.40312 .4232 m .39667 .95181 L .43095 .95616 L .976 0 .966 r
F
.40802 .41576 m .40312 .4232 L .39667 .95181 L .694 0 .687 r
F
.32181 .42309 m .30178 .94562 L .30666 .94015 L .653 0 .388 r
F
.29041 .41713 m .30666 .94015 L .32181 .42309 L .976 0 .58 r
F
.46172 .42252 m .46178 .94745 L .49578 .95181 L .792 0 .976 r
F
.46691 .41508 m .46172 .42252 L .46178 .94745 L .584 0 .719 r
F
.38038 .42241 m .36609 .96051 L .37133 .95511 L .683 0 .541 r
F
.34919 .41645 m .37133 .95511 L .38038 .42241 L .976 0 .773 r
F
.1563 .66509 m .17301 .4185 L .17111 .42221 L .554 0 .11 r
F
.52038 .42184 m .52688 .9454 L .56062 .94977 L .599 0 .975 r
F
.52584 .41439 m .52038 .42184 L .52688 .9454 L .455 0 .742 r
F
.439 .42173 m .43095 .95616 L .43653 .95073 L .71 0 .702 r
F
.40802 .41576 m .43653 .95073 L .439 .42173 L .976 0 .966 r
F
.17847 .40779 m .20651 .42127 L .17464 .4153 L .954 0 .378 r
F
.17847 .40779 m .21048 .41382 L .20651 .42127 L F
.17464 .4153 m .17946 .92649 L .20651 .42127 L .977 0 .387 r
F
.21048 .41382 m .20651 .42127 L .17946 .92649 L .579 0 .229 r
F
.49767 .42105 m .49578 .95181 L .50169 .94636 L .595 0 .733 r
F
.46691 .41508 m .50169 .94636 L .49767 .42105 L .792 0 .975 r
F
.23755 .4071 m .2651 .42059 L .23344 .41461 L .954 0 .567 r
F
.23755 .4071 m .26935 .41313 L .2651 .42059 L F
.23344 .41461 m .24416 .92829 L .2651 .42059 L .977 0 .58 r
F
.26935 .41313 m .2651 .42059 L .24416 .92829 L .618 0 .367 r
F
.63783 .42048 m .65769 .95524 L .69098 .95959 L .212 0 .975 r
F
.64386 .41302 m .63783 .42048 L .65769 .95524 L .17 0 .779 r
F
.55639 .42037 m .56062 .94977 L .56688 .94431 L .463 0 .754 r
F
.52584 .41439 m .56688 .94431 L .55639 .42037 L .599 0 .975 r
F
.29669 .4064 m .32374 .41991 L .29229 .41393 L .954 0 .756 r
F
.29669 .4064 m .32827 .41244 L .32374 .41991 L F
.29229 .41393 m .30843 .9494 L .32374 .41991 L .976 0 .773 r
F
.32827 .41244 m .32374 .41991 L .30843 .9494 L .653 0 .517 r
F
.35587 .40571 m .38243 .41923 L .35119 .41324 L .954 0 .945 r
F
.35587 .40571 m .38724 .41176 L .38243 .41923 L F
.35119 .41324 m .37373 .94424 L .38243 .41923 L .976 0 .966 r
F
.38724 .41176 m .38243 .41923 L .37373 .94424 L .683 0 .676 r
F
.67399 .41901 m .69098 .95959 L .69794 .95416 L .172 0 .789 r
F
.64386 .41302 m .69794 .95416 L .67399 .41901 L .212 0 .974 r
F
.41511 .40501 m .44117 .41855 L .41014 .41255 L .775 0 .954 r
F
.41511 .40501 m .44626 .41107 L .44117 .41855 L F
.41014 .41255 m .43895 .94452 L .44117 .41855 L .792 0 .976 r
F
.44626 .41107 m .44117 .41855 L .43895 .94452 L .576 0 .71 r
F
.17301 .4185 m .14192 .93134 L .17728 .93577 L .977 0 .193 r
F
.1399 .93411 m .17301 .4185 L .1563 .66509 L .554 0 .11 r
F
.1399 .93411 m .14192 .93134 L .17301 .4185 L F
.13377 .41525 m .15166 .41451 L .14981 .41824 L .954 0 .189 r
F
.13444 .65291 m .15166 .41451 L .14981 .41824 L .535 0 .106 r
F
.47439 .40432 m .49996 .41786 L .46914 .41186 L .586 0 .954 r
F
.47439 .40432 m .50534 .41038 L .49996 .41786 L F
.46914 .41186 m .50423 .94246 L .49996 .41786 L .599 0 .975 r
F
.50534 .41038 m .49996 .41786 L .50423 .94246 L .45 0 .733 r
F
.23168 .41781 m .20687 .9316 L .24198 .93604 L .977 0 .387 r
F
.23168 .41781 m .20251 .93713 L .20687 .9316 L .596 0 .236 r
F
.53373 .40362 m .5588 .41718 L .5282 .41118 L .397 0 .954 r
F
.53373 .40362 m .56447 .40969 L .5588 .41718 L F
.53373 .40362 m .5588 .41718 L .5282 .41118 L F
.53373 .40362 m .56447 .40969 L .5588 .41718 L F
.29041 .41713 m .27177 .93573 L .30666 .94015 L .976 0 .58 r
F
.29041 .41713 m .26706 .94124 L .27177 .93573 L .633 0 .376 r
F
.59313 .40293 m .6177 .4165 L .5873 .41049 L .208 0 .954 r
F
.59313 .40293 m .62364 .409 L .6177 .4165 L F
.5873 .41049 m .63524 .94921 L .6177 .4165 L .212 0 .975 r
F
.62364 .409 m .6177 .4165 L .63524 .94921 L .168 0 .772 r
F
.34919 .41645 m .3366 .95073 L .37133 .95511 L .976 0 .773 r
F
.34919 .41645 m .33153 .95618 L .3366 .95073 L .665 0 .527 r
F
.65257 .40223 m .67664 .41581 L .64646 .4098 L .019 0 .954 r
F
.65257 .40223 m .68287 .4083 L .67664 .41581 L F
.65257 .40223 m .67664 .41581 L .64646 .4098 L F
.65257 .40223 m .68287 .4083 L .67664 .41581 L F
.40802 .41576 m .40208 .94634 L .43653 .95073 L .976 0 .966 r
F
.40802 .41576 m .39667 .95181 L .40208 .94634 L .694 0 .687 r
F
.17464 .4153 m .14407 .92201 L .17946 .92649 L .977 0 .387 r
F
.17847 .40779 m .17464 .4153 L .14407 .92201 L .554 0 .219 r
F
.11766 .41224 m .11944 .40848 L .13377 .41525 L .954 0 .189 r
F
.13377 .41525 m .11944 .40848 L .15166 .41451 L F
.46691 .41508 m .46754 .94195 L .50169 .94636 L .792 0 .975 r
F
.46691 .41508 m .46178 .94745 L .46754 .94195 L .584 0 .719 r
F
.23344 .41461 m .20902 .92381 L .24416 .92829 L .977 0 .58 r
F
.23755 .4071 m .23344 .41461 L .20902 .92381 L .596 0 .354 r
F
.11747 .91194 m .15166 .41451 L .13444 .65291 L .535 0 .106 r
F
.11747 .91194 m .11943 .90912 L .15166 .41451 L F
.11944 .40848 m .11943 .90912 L .15166 .41451 L .977 0 .193 r
F
.52584 .41439 m .53299 .93989 L .56688 .94431 L .599 0 .975 r
F
.52584 .41439 m .52688 .9454 L .53299 .93989 L .455 0 .742 r
F
.27177 .93573 m .30178 .94562 L .26706 .94124 L .876 0 .52 r
F
.27177 .93573 m .30666 .94015 L .30178 .94562 L F
.29229 .41393 m .2734 .94499 L .30843 .9494 L .976 0 .773 r
F
.29669 .4064 m .29229 .41393 L .2734 .94499 L .633 0 .501 r
F
.21048 .41382 m .17946 .92649 L .18371 .9209 L .579 0 .229 r
F
.17847 .40779 m .18371 .9209 L .21048 .41382 L .977 0 .387 r
F
.35119 .41324 m .33898 .93982 L .37373 .94424 L .976 0 .966 r
F
.35587 .40571 m .35119 .41324 L .33898 .93982 L .665 0 .659 r
F
.26935 .41313 m .24416 .92829 L .24876 .9227 L .618 0 .367 r
F
.23755 .4071 m .24876 .9227 L .26935 .41313 L .976 0 .58 r
F
.64386 .41302 m .6645 .94977 L .69794 .95416 L .212 0 .974 r
F
.64386 .41302 m .65769 .95524 L .6645 .94977 L .17 0 .779 r
F
.41014 .41255 m .40446 .94009 L .43895 .94452 L .792 0 .976 r
F
.41511 .40501 m .41014 .41255 L .40446 .94009 L .564 0 .694 r
F
.32827 .41244 m .30843 .9494 L .31339 .9439 L .653 0 .517 r
F
.29669 .4064 m .31339 .9439 L .32827 .41244 L .976 0 .773 r
F
.10064 .64755 m .11944 .40848 L .11766 .41224 L .506 0 .1 r
F
.46914 .41186 m .47002 .93802 L .50423 .94246 L .599 0 .975 r
F
.47439 .40432 m .46914 .41186 L .47002 .93802 L .442 0 .719 r
F
.38724 .41176 m .37373 .94424 L .37903 .93872 L .683 0 .676 r
F
.35587 .40571 m .37903 .93872 L .38724 .41176 L .976 0 .966 r
F
.12458 .39763 m .15326 .41129 L .12098 .40524 L .954 0 .378 r
F
.12458 .39763 m .157 .40374 L .15326 .41129 L F
.12098 .40524 m .12062 .91438 L .15326 .41129 L .977 0 .387 r
F
.157 .40374 m .15326 .41129 L .12062 .91438 L .535 0 .212 r
F
.44626 .41107 m .43895 .94452 L .4446 .93899 L .576 0 .71 r
F
.41511 .40501 m .4446 .93899 L .44626 .41107 L .792 0 .975 r
F
.18402 .39693 m .21219 .4106 L .18013 .40455 L .954 0 .567 r
F
.18402 .39693 m .21622 .40305 L .21219 .4106 L F
.18013 .40455 m .18599 .91001 L .21219 .4106 L .977 0 .58 r
F
.21622 .40305 m .21219 .4106 L .18599 .91001 L .579 0 .344 r
F
.5873 .41049 m .6015 .94479 L .63524 .94921 L .212 0 .975 r
F
.59313 .40293 m .5873 .41049 L .6015 .94479 L .166 0 .761 r
F
.50534 .41038 m .50423 .94246 L .51023 .93692 L .45 0 .733 r
F
.47439 .40432 m .51023 .93692 L .50534 .41038 L .599 0 .975 r
F
.2435 .39623 m .27118 .40991 L .23933 .40385 L .954 0 .756 r
F
.2435 .39623 m .2755 .40235 L .27118 .40991 L F
.23933 .40385 m .25022 .93347 L .27118 .40991 L .976 0 .773 r
F
.2755 .40235 m .27118 .40991 L .25022 .93347 L .618 0 .49 r
F
.30305 .39553 m .33023 .40922 L .29858 .40316 L .954 0 .945 r
F
.30305 .39553 m .33482 .40165 L .33023 .40922 L F
.29858 .40316 m .31594 .92674 L .33023 .40922 L .976 0 .966 r
F
.33482 .40165 m .33023 .40922 L .31594 .92674 L .653 0 .646 r
F
.62364 .409 m .63524 .94921 L .64195 .9437 L .168 0 .772 r
F
.59313 .40293 m .64195 .9437 L .62364 .409 L .212 0 .974 r
F
.36264 .39482 m .38932 .40853 L .35789 .40246 L .775 0 .954 r
F
.36264 .39482 m .3942 .40095 L .38932 .40853 L F
.35789 .40246 m .38138 .93244 L .38932 .40853 L .792 0 .976 r
F
.3942 .40095 m .38932 .40853 L .38138 .93244 L .555 0 .683 r
F
.11944 .40848 m .08371 .90455 L .11943 .90912 L .977 0 .193 r
F
.08184 .9074 m .11944 .40848 L .10064 .64755 L .506 0 .1 r
F
.08184 .9074 m .08371 .90455 L .11944 .40848 L F
.07985 .40519 m .09783 .40444 L .09609 .40822 L .954 0 .189 r
F
.07808 .64222 m .09783 .40444 L .09609 .40822 L .485 0 .096 r
F
.42229 .39412 m .44846 .40784 L .41725 .40176 L .586 0 .954 r
F
.42229 .39412 m .45363 .40026 L .44846 .40784 L F
.41725 .40176 m .44706 .93115 L .44846 .40784 L .599 0 .975 r
F
.45363 .40026 m .44846 .40784 L .44706 .93115 L .436 0 .71 r
F
.17847 .40779 m .14816 .91638 L .18371 .9209 L .977 0 .387 r
F
.17847 .40779 m .14407 .92201 L .14816 .91638 L .554 0 .219 r
F
.48199 .39342 m .50766 .40715 L .47666 .40106 L .397 0 .954 r
F
.48199 .39342 m .51312 .39956 L .50766 .40715 L F
.47666 .40106 m .51283 .93531 L .50766 .40715 L .406 0 .975 r
F
.51312 .39956 m .50766 .40715 L .51283 .93531 L .305 0 .733 r
F
.23755 .4071 m .21345 .91818 L .24876 .9227 L .976 0 .58 r
F
.23755 .4071 m .20902 .92381 L .21345 .91818 L .596 0 .354 r
F
.54174 .39271 m .56691 .40645 L .53612 .40037 L .208 0 .954 r
F
.54174 .39271 m .57265 .39886 L .56691 .40645 L F
.53612 .40037 m .57879 .93948 L .56691 .40645 L .212 0 .975 r
F
.57265 .39886 m .56691 .40645 L .57879 .93948 L .164 0 .754 r
F
.29669 .4064 m .27819 .93944 L .31339 .9439 L .976 0 .773 r
F
.29669 .4064 m .2734 .94499 L .27819 .93944 L .633 0 .501 r
F
.60154 .392 m .62621 .40576 L .59564 .39967 L .019 0 .954 r
F
.60154 .392 m .63224 .39816 L .62621 .40576 L F
.60154 .392 m .62621 .40576 L .59564 .39967 L F
.60154 .392 m .63224 .39816 L .62621 .40576 L F
.35587 .40571 m .34413 .93425 L .37903 .93872 L .976 0 .966 r
F
.35587 .40571 m .33898 .93982 L .34413 .93425 L .665 0 .659 r
F
.09969 .90968 m .11943 .90912 L .11747 .91194 L .882 0 .175 r
F
.08184 .9074 m .08371 .90455 L .09969 .90968 L F
.09969 .90968 m .08371 .90455 L .11943 .90912 L F
.12098 .40524 m .08477 .90982 L .12062 .91438 L .977 0 .387 r
F
.12458 .39763 m .12098 .40524 L .08477 .90982 L .506 0 .2 r
F
.06353 .40214 m .06519 .39833 L .07985 .40519 L .954 0 .189 r
F
.07985 .40519 m .06519 .39833 L .09783 .40444 L F
.6614 .3913 m .68556 .40507 L .65521 .39897 L 0 .17 .954 r
F
.6614 .3913 m .69188 .39746 L .68556 .40507 L F
.6614 .3913 m .68556 .40507 L .65521 .39897 L F
.6614 .3913 m .69188 .39746 L .68556 .40507 L F
.41511 .40501 m .40996 .93451 L .4446 .93899 L .792 0 .975 r
F
.41511 .40501 m .40446 .94009 L .40996 .93451 L .564 0 .694 r
F
.18013 .40455 m .15043 .90543 L .18599 .91001 L .977 0 .58 r
F
.18402 .39693 m .18013 .40455 L .15043 .90543 L .554 0 .329 r
F
.0582 .90051 m .09783 .40444 L .07808 .64222 L .485 0 .096 r
F
.0582 .90051 m .06002 .89764 L .09783 .40444 L F
.06519 .39833 m .06002 .89764 L .09783 .40444 L .977 0 .193 r
F
.47439 .40432 m .47586 .93244 L .51023 .93692 L .599 0 .975 r
F
.47439 .40432 m .47002 .93802 L .47586 .93244 L .442 0 .719 r
F
.21345 .91818 m .24416 .92829 L .20902 .92381 L .878 0 .522 r
F
.21345 .91818 m .24876 .9227 L .24416 .92829 L F
.23933 .40385 m .21475 .92897 L .25022 .93347 L .976 0 .773 r
F
.2435 .39623 m .23933 .40385 L .21475 .92897 L .596 0 .472 r
F
.157 .40374 m .12062 .91438 L .12459 .90869 L .535 0 .212 r
F
.12458 .39763 m .12459 .90869 L .157 .40374 L .977 0 .387 r
F
.29858 .40316 m .28077 .92222 L .31594 .92674 L .976 0 .966 r
F
.30305 .39553 m .29858 .40316 L .28077 .92222 L .633 0 .626 r
F
.21622 .40305 m .18599 .91001 L .1903 .9043 L .579 0 .344 r
F
.18402 .39693 m .1903 .9043 L .21622 .40305 L .976 0 .58 r
F
.59313 .40293 m .60806 .93923 L .64195 .9437 L .212 0 .974 r
F
.59313 .40293 m .6015 .94479 L .60806 .93923 L .166 0 .761 r
F
.35789 .40246 m .34643 .92794 L .38138 .93244 L .792 0 .976 r
F
.36264 .39482 m .35789 .40246 L .34643 .92794 L .54 0 .665 r
F
.2755 .40235 m .25022 .93347 L .2549 .92786 L .618 0 .49 r
F
.2435 .39623 m .2549 .92786 L .2755 .40235 L .976 0 .773 r
F
.04384 .63679 m .06519 .39833 L .06353 .40214 L .452 0 .089 r
F
.41725 .40176 m .41238 .92664 L .44706 .93115 L .599 0 .975 r
F
.42229 .39412 m .41725 .40176 L .41238 .92664 L .426 0 .694 r
F
.33482 .40165 m .31594 .92674 L .32096 .9211 L .653 0 .646 r
F
.30305 .39553 m .32096 .9211 L .33482 .40165 L .976 0 .966 r
F
.06999 .38735 m .09932 .40118 L .06662 .39505 L .954 0 .378 r
F
.06999 .38735 m .10283 .39353 L .09932 .40118 L F
.06662 .39505 m .06128 .89902 L .09932 .40118 L .977 0 .387 r
F
.10283 .39353 m .09932 .40118 L .06128 .89902 L .485 0 .192 r
F
.47666 .40106 m .47839 .93081 L .51283 .93531 L .406 0 .975 r
F
.48199 .39342 m .47666 .40106 L .47839 .93081 L .299 0 .719 r
F
.3942 .40095 m .38138 .93244 L .38676 .92682 L .555 0 .683 r
F
.36264 .39482 m .38676 .92682 L .3942 .40095 L .792 0 .975 r
F
.12978 .38664 m .15861 .40048 L .12613 .39435 L .954 0 .567 r
F
.12978 .38664 m .16241 .39283 L .15861 .40048 L F
.12978 .38664 m .15861 .40048 L .12613 .39435 L F
.12978 .38664 m .16241 .39283 L .15861 .40048 L F
.53612 .40037 m .54458 .93499 L .57879 .93948 L .212 0 .975 r
F
.54174 .39271 m .53612 .40037 L .54458 .93499 L .162 0 .742 r
F
.45363 .40026 m .44706 .93115 L .45279 .92552 L .436 0 .71 r
F
.42229 .39412 m .45279 .92552 L .45363 .40026 L .599 0 .975 r
F
.18963 .38593 m .21796 .39979 L .18569 .39365 L .954 0 .756 r
F
.18963 .38593 m .22204 .39212 L .21796 .39979 L F
.18569 .39365 m .19149 .91503 L .21796 .39979 L .976 0 .773 r
F
.22204 .39212 m .21796 .39979 L .19149 .91503 L .579 0 .459 r
F
.51312 .39956 m .51283 .93531 L .51892 .92969 L .305 0 .733 r
F
.48199 .39342 m .51892 .92969 L .51312 .39956 L .406 0 .975 r
F
.24954 .38521 m .27736 .39909 L .24531 .39294 L .954 0 .945 r
F
.24954 .38521 m .28173 .39142 L .27736 .39909 L F
.24531 .39294 m .25734 .91451 L .27736 .39909 L .976 0 .966 r
F
.28173 .39142 m .27736 .39909 L .25734 .91451 L .618 0 .612 r
F
.57265 .39886 m .57879 .93948 L .58524 .93388 L .164 0 .754 r
F
.54174 .39271 m .58524 .93388 L .57265 .39886 L .212 0 .974 r
F
.30949 .3845 m .3368 .39839 L .30497 .39224 L .775 0 .954 r
F
.30949 .3845 m .34146 .39071 L .3368 .39839 L F
.30497 .39224 m .32325 .91398 L .3368 .39839 L .792 0 .976 r
F
.34146 .39071 m .3368 .39839 L .32325 .91398 L .53 0 .653 r
F
.06519 .39833 m .02381 .893 L .06002 .89764 L .977 0 .193 r
F
.02209 .89589 m .06519 .39833 L .04384 .63679 L .452 0 .089 r
F
.02209 .89589 m .02381 .893 L .06519 .39833 L F
.3695 .38379 m .39631 .39768 L .36469 .39153 L .586 0 .954 r
F
.3695 .38379 m .40126 .39 L .39631 .39768 L F
.36469 .39153 m .3891 .92283 L .39631 .39768 L .599 0 .975 r
F
.40126 .39 m .39631 .39768 L .3891 .92283 L .419 0 .683 r
F
.12458 .39763 m .08856 .90409 L .12459 .90869 L .977 0 .387 r
F
.12458 .39763 m .08477 .90982 L .08856 .90409 L .506 0 .2 r
F
.42957 .38307 m .45586 .39698 L .42446 .39082 L .397 0 .954 r
F
.42957 .38307 m .4611 .38929 L .45586 .39698 L F
.42446 .39082 m .45526 .92544 L .45586 .39698 L .406 0 .975 r
F
.4611 .38929 m .45586 .39698 L .45526 .92544 L .295 0 .71 r
F
.18402 .39693 m .15457 .89968 L .1903 .9043 L .976 0 .58 r
F
.18402 .39693 m .15043 .90543 L .15457 .89968 L .554 0 .329 r
F
.48968 .38236 m .51547 .39628 L .48428 .39011 L .208 0 .954 r
F
.48968 .38236 m .521 .38859 L .51547 .39628 L F
.48428 .39011 m .52158 .92962 L .51547 .39628 L .212 0 .975 r
F
.521 .38859 m .51547 .39628 L .52158 .92962 L .16 0 .733 r
F
.2435 .39623 m .21925 .92331 L .2549 .92786 L .976 0 .773 r
F
.2435 .39623 m .21475 .92897 L .21925 .92331 L .596 0 .472 r
F
.54986 .38164 m .57513 .39558 L .54416 .38941 L .019 0 .954 r
F
.54986 .38164 m .58095 .38788 L .57513 .39558 L F
.54416 .38941 m .58795 .92832 L .57513 .39558 L .019 0 .974 r
F
.58095 .38788 m .57513 .39558 L .58795 .92832 L .015 0 .754 r
F
.30305 .39553 m .28563 .91653 L .32096 .9211 L .976 0 .966 r
F
.30305 .39553 m .28077 .92222 L .28563 .91653 L .633 0 .626 r
F
.04018 .89821 m .06002 .89764 L .0582 .90051 L .883 0 .175 r
F
.02209 .89589 m .02381 .893 L .04018 .89821 L F
.04018 .89821 m .02381 .893 L .06002 .89764 L F
.06662 .39505 m .02498 .89438 L .06128 .89902 L .977 0 .387 r
F
.06999 .38735 m .06662 .39505 L .02498 .89438 L .452 0 .179 r
F
.61008 .38093 m .63484 .39488 L .60409 .3887 L 0 .17 .954 r
F
.61008 .38093 m .64095 .38717 L .63484 .39488 L F
.60409 .3887 m .65423 .92309 L .63484 .39488 L 0 .173 .974 r
F
.64095 .38717 m .63484 .39488 L .65423 .92309 L 0 .137 .772 r
F
.36264 .39482 m .35165 .92227 L .38676 .92682 L .792 0 .975 r
F
.36264 .39482 m .34643 .92794 L .35165 .92227 L .54 0 .665 r
F
.67036 .38021 m .69461 .39417 L .66408 .38799 L 0 .359 .954 r
F
.67036 .38021 m .70101 .38646 L .69461 .39417 L F
.67036 .38021 m .69461 .39417 L .66408 .38799 L F
.67036 .38021 m .70101 .38646 L .69461 .39417 L F
.42229 .39412 m .41795 .92096 L .45279 .92552 L .599 0 .975 r
F
.42229 .39412 m .41238 .92664 L .41795 .92096 L .426 0 .694 r
F
.15457 .89968 m .18599 .91001 L .15043 .90543 L .881 0 .523 r
F
.15457 .89968 m .1903 .9043 L .18599 .91001 L F
.18569 .39365 m .15558 .91043 L .19149 .91503 L .976 0 .773 r
F
.18963 .38593 m .18569 .39365 L .15558 .91043 L .554 0 .438 r
F
.10283 .39353 m .06128 .89902 L .06496 .89322 L .485 0 .192 r
F
.06999 .38735 m .06496 .89322 L .10283 .39353 L .977 0 .387 r
F
.48199 .39342 m .48432 .92514 L .51892 .92969 L .406 0 .975 r
F
.48199 .39342 m .47839 .93081 L .48432 .92514 L .299 0 .719 r
F
.24531 .39294 m .2217 .9099 L .25734 .91451 L .976 0 .966 r
F
.24954 .38521 m .24531 .39294 L .2217 .9099 L .596 0 .59 r
F
.54174 .39271 m .55088 .92934 L .58524 .93388 L .212 0 .974 r
F
.54174 .39271 m .54458 .93499 L .55088 .92934 L .162 0 .742 r
F
.30497 .39224 m .28788 .90938 L .32325 .91398 L .792 0 .976 r
F
.30949 .3845 m .30497 .39224 L .28788 .90938 L .514 0 .633 r
F
.22204 .39212 m .19149 .91503 L .19588 .90929 L .579 0 .459 r
F
.18963 .38593 m .19588 .90929 L .22204 .39212 L .976 0 .773 r
F
.36469 .39153 m .35393 .91825 L .3891 .92283 L .599 0 .975 r
F
.3695 .38379 m .36469 .39153 L .35393 .91825 L .409 0 .665 r
F
.28173 .39142 m .25734 .91451 L .26208 .90876 L .618 0 .612 r
F
.24954 .38521 m .26208 .90876 L .28173 .39142 L .976 0 .966 r
F
.42446 .39082 m .42034 .92086 L .45526 .92544 L .406 0 .975 r
F
.42957 .38307 m .42446 .39082 L .42034 .92086 L .289 0 .694 r
F
.34146 .39071 m .32325 .91398 L .32835 .90823 L .53 0 .653 r
F
.30949 .3845 m .32835 .90823 L .34146 .39071 L .792 0 .975 r
F
.07484 .37621 m .10434 .39023 L .07144 .38402 L .954 0 .567 r
F
.07484 .37621 m .10789 .38248 L .10434 .39023 L F
.07484 .37621 m .10434 .39023 L .07144 .38402 L F
.07484 .37621 m .10789 .38248 L .10434 .39023 L F
.48428 .39011 m .4869 .92506 L .52158 .92962 L .212 0 .975 r
F
.48968 .38236 m .48428 .39011 L .4869 .92506 L .157 0 .719 r
F
.40126 .39 m .3891 .92283 L .39457 .91711 L .419 0 .683 r
F
.3695 .38379 m .39457 .91711 L .40126 .39 L .599 0 .975 r
F
.13506 .37549 m .16404 .38953 L .13136 .38331 L .954 0 .756 r
F
.13506 .37549 m .16789 .38177 L .16404 .38953 L F
.13136 .38331 m .13348 .87545 L .16404 .38953 L .976 0 .773 r
F
.16789 .38177 m .16404 .38953 L .13348 .87545 L .535 0 .424 r
F
.54416 .38941 m .55354 .92375 L .58795 .92832 L .019 0 .974 r
F
.54986 .38164 m .54416 .38941 L .55354 .92375 L .015 0 .742 r
F
.4611 .38929 m .45526 .92544 L .46109 .91973 L .295 0 .71 r
F
.42957 .38307 m .46109 .91973 L .4611 .38929 L .406 0 .975 r
F
.19533 .37476 m .2238 .38882 L .19133 .38259 L .954 0 .945 r
F
.19533 .37476 m .22794 .38105 L .2238 .38882 L F
.19133 .38259 m .19801 .90212 L .2238 .38882 L .976 0 .966 r
F
.22794 .38105 m .2238 .38882 L .19801 .90212 L .579 0 .574 r
F
.60409 .3887 m .62011 .9185 L .65423 .92309 L 0 .173 .974 r
F
.61008 .38093 m .60409 .3887 L .62011 .9185 L 0 .136 .761 r
F
.521 .38859 m .52158 .92962 L .52777 .92393 L .16 0 .733 r
F
.48968 .38236 m .52777 .92393 L .521 .38859 L .212 0 .974 r
F
.25565 .37404 m .28361 .38811 L .25136 .38188 L .775 0 .954 r
F
.25565 .37404 m .28804 .38033 L .28361 .38811 L F
.25136 .38188 m .26436 .90002 L .28361 .38811 L .792 0 .976 r
F
.28804 .38033 m .28361 .38811 L .26436 .90002 L .502 0 .618 r
F
.58095 .38788 m .58795 .92832 L .5945 .92261 L .015 0 .754 r
F
.54986 .38164 m .5945 .92261 L .58095 .38788 L .019 0 .974 r
F
.31603 .37332 m .34347 .3874 L .31145 .38116 L .586 0 .954 r
F
.31603 .37332 m .3482 .37962 L .34347 .3874 L F
.31145 .38116 m .33047 .90888 L .34347 .3874 L .599 0 .975 r
F
.3482 .37962 m .34347 .3874 L .33047 .90888 L .401 0 .653 r
F
.06999 .38735 m .02847 .88852 L .06496 .89322 L .977 0 .387 r
F
.06999 .38735 m .02498 .89438 L .02847 .88852 L .452 0 .179 r
F
.64095 .38717 m .65423 .92309 L .66113 .91736 L 0 .137 .772 r
F
.61008 .38093 m .66113 .91736 L .64095 .38717 L 0 .173 .974 r
F
.37646 .3726 m .40339 .38669 L .37158 .38045 L .397 0 .954 r
F
.37646 .3726 m .40841 .3789 L .40339 .38669 L F
.37158 .38045 m .39693 .91464 L .40339 .38669 L .406 0 .975 r
F
.40841 .3789 m .40339 .38669 L .39693 .91464 L .284 0 .683 r
F
.43695 .37187 m .46336 .38598 L .43177 .37973 L .208 0 .954 r
F
.43695 .37187 m .46867 .37818 L .46336 .38598 L F
.43177 .37973 m .4636 .91884 L .46336 .38598 L .212 0 .975 r
F
.46867 .37818 m .46336 .38598 L .4636 .91884 L .155 0 .71 r
F
.18963 .38593 m .1598 .90464 L .19588 .90929 L .976 0 .773 r
F
.18963 .38593 m .15558 .91043 L .1598 .90464 L .554 0 .438 r
F
.49749 .37115 m .52338 .38527 L .49201 .37901 L .019 0 .954 r
F
.49749 .37115 m .52899 .37746 L .52338 .38527 L F
.49201 .37901 m .53044 .92147 L .52338 .38527 L .019 0 .974 r
F
.52899 .37746 m .52338 .38527 L .53044 .92147 L .015 0 .733 r
F
.24954 .38521 m .22627 .90411 L .26208 .90876 L .976 0 .966 r
F
.24954 .38521 m .2217 .9099 L .22627 .90411 L .596 0 .59 r
F
.55808 .37042 m .58346 .38455 L .55231 .37829 L 0 .17 .954 r
F
.55808 .37042 m .58936 .37674 L .58346 .38455 L F
.55231 .37829 m .59719 .91462 L .58346 .38455 L 0 .173 .974 r
F
.58936 .37674 m .58346 .38455 L .59719 .91462 L 0 .134 .754 r
F
.30949 .3845 m .29281 .90357 L .32835 .90823 L .792 0 .975 r
F
.30949 .3845 m .28788 .90938 L .29281 .90357 L .514 0 .633 r
F
.61873 .3697 m .64359 .38384 L .61266 .37758 L 0 .359 .954 r
F
.61873 .3697 m .64979 .37602 L .64359 .38384 L F
.61266 .37758 m .66436 .9212 L .64359 .38384 L 0 .366 .974 r
F
.64979 .37602 m .64359 .38384 L .66436 .9212 L 0 .29 .772 r
F
.3695 .38379 m .35923 .91248 L .39457 .91711 L .599 0 .975 r
F
.3695 .38379 m .35393 .91825 L .35923 .91248 L .409 0 .665 r
F
.13136 .38331 m .09729 .87067 L .13348 .87545 L .976 0 .773 r
F
.13506 .37549 m .13136 .38331 L .09729 .87067 L .506 0 .401 r
F
.67944 .36897 m .70377 .38313 L .67307 .37686 L 0 .548 .954 r
F
.67944 .36897 m .71027 .3753 L .70377 .38313 L F
.67944 .36897 m .70377 .38313 L .67307 .37686 L F
.67944 .36897 m .71027 .3753 L .70377 .38313 L F
.42957 .38307 m .426 .9151 L .46109 .91973 L .406 0 .975 r
F
.42957 .38307 m .42034 .92086 L .426 .9151 L .289 0 .694 r
F
.19133 .38259 m .16189 .89743 L .19801 .90212 L .976 0 .966 r
F
.19533 .37476 m .19133 .38259 L .16189 .89743 L .554 0 .548 r
F
.48968 .38236 m .49292 .91931 L .52777 .92393 L .212 0 .974 r
F
.48968 .38236 m .4869 .92506 L .49292 .91931 L .157 0 .719 r
F
.25136 .38188 m .22852 .89532 L .26436 .90002 L .792 0 .976 r
F
.25565 .37404 m .25136 .38188 L .22852 .89532 L .484 0 .596 r
F
.16789 .38177 m .13348 .87545 L .13756 .86949 L .535 0 .424 r
F
.13506 .37549 m .13756 .86949 L .16789 .38177 L .976 0 .773 r
F
.54986 .38164 m .55993 .91799 L .5945 .92261 L .019 0 .974 r
F
.54986 .38164 m .55354 .92375 L .55993 .91799 L .015 0 .742 r
F
.29281 .90357 m .32835 .90823 L .32325 .91398 L .713 0 .878 r
F
.31145 .38116 m .29484 .90422 L .33047 .90888 L .599 0 .975 r
F
.31603 .37332 m .31145 .38116 L .29484 .90422 L .388 0 .633 r
F
.22794 .38105 m .19801 .90212 L .20246 .89627 L .579 0 .574 r
F
.19533 .37476 m .20246 .89627 L .22794 .38105 L .976 0 .966 r
F
.61008 .38093 m .62686 .91272 L .66113 .91736 L 0 .173 .974 r
F
.61008 .38093 m .62011 .9185 L .62686 .91272 L 0 .136 .761 r
F
.37158 .38045 m .36152 .90999 L .39693 .91464 L .406 0 .975 r
F
.37646 .3726 m .37158 .38045 L .36152 .90999 L .277 0 .665 r
F
.28804 .38033 m .26436 .90002 L .26917 .89416 L .502 0 .618 r
F
.25565 .37404 m .26917 .89416 L .28804 .38033 L .792 0 .975 r
F
.43177 .37973 m .42843 .9142 L .4636 .91884 L .212 0 .975 r
F
.43695 .37187 m .43177 .37973 L .42843 .9142 L .151 0 .694 r
F
.3482 .37962 m .33047 .90888 L .33565 .90306 L .401 0 .653 r
F
.31603 .37332 m .33565 .90306 L .3482 .37962 L .599 0 .975 r
F
.07977 .36491 m .10943 .37913 L .07631 .37283 L .954 0 .756 r
F
.07977 .36491 m .11303 .37127 L .10943 .37913 L F
.07631 .37283 m .0753 .83654 L .10943 .37913 L .976 0 .773 r
F
.11303 .37127 m .10943 .37913 L .0753 .83654 L .485 0 .384 r
F
.49201 .37901 m .49553 .91683 L .53044 .92147 L .019 0 .974 r
F
.49749 .37115 m .49201 .37901 L .49553 .91683 L .014 0 .719 r
F
.40841 .3789 m .39693 .91464 L .40247 .90883 L .284 0 .683 r
F
.37646 .3726 m .40247 .90883 L .40841 .3789 L .406 0 .975 r
F
.14041 .36418 m .16955 .37842 L .13666 .37211 L .954 0 .945 r
F
.14041 .36418 m .17345 .37055 L .16955 .37842 L F
.13666 .37211 m .13865 .87783 L .16955 .37842 L .976 0 .966 r
F
.17345 .37055 m .16955 .37842 L .13865 .87783 L .535 0 .53 r
F
.55231 .37829 m .56259 .90996 L .59719 .91462 L 0 .173 .974 r
F
.55808 .37042 m .55231 .37829 L .56259 .90996 L 0 .132 .742 r
F
.46867 .37818 m .4636 .91884 L .46952 .91305 L .155 0 .71 r
F
.43695 .37187 m .46952 .91305 L .46867 .37818 L .212 0 .974 r
F
.20111 .36345 m .22972 .3777 L .19705 .37139 L .775 0 .954 r
F
.20111 .36345 m .23392 .36982 L .22972 .3777 L F
.19705 .37139 m .20457 .88981 L .22972 .3777 L .792 0 .976 r
F
.23392 .36982 m .22972 .3777 L .20457 .88981 L .471 0 .579 r
F
.62686 .91272 m .65423 .92309 L .62011 .9185 L 0 .156 .875 r
F
.62686 .91272 m .66113 .91736 L .65423 .92309 L F
.61266 .37758 m .62998 .91656 L .66436 .9212 L 0 .366 .974 r
F
.61873 .3697 m .61266 .37758 L .62998 .91656 L 0 .286 .761 r
F
.52899 .37746 m .53044 .92147 L .53673 .91568 L .015 0 .733 r
F
.49749 .37115 m .53673 .91568 L .52899 .37746 L .019 0 .974 r
F
.26186 .36272 m .28995 .37698 L .25751 .37066 L .586 0 .954 r
F
.26186 .36272 m .29445 .3691 L .28995 .37698 L F
.25751 .37066 m .27111 .89556 L .28995 .37698 L .599 0 .975 r
F
.29445 .3691 m .28995 .37698 L .27111 .89556 L .38 0 .618 r
F
.58936 .37674 m .59719 .91462 L .60383 .90881 L 0 .134 .754 r
F
.55808 .37042 m .60383 .90881 L .58936 .37674 L 0 .173 .974 r
F
.32266 .36198 m .35024 .37626 L .31801 .36994 L .397 0 .954 r
F
.32266 .36198 m .35503 .36837 L .35024 .37626 L F
.31801 .36994 m .33794 .89817 L .35024 .37626 L .406 0 .975 r
F
.35503 .36837 m .35024 .37626 L .33794 .89817 L .272 0 .653 r
F
.64979 .37602 m .66436 .9212 L .67137 .91541 L 0 .29 .772 r
F
.61873 .3697 m .67137 .91541 L .64979 .37602 L 0 .366 .973 r
F
.38352 .36125 m .41057 .37554 L .37857 .36921 L .208 0 .954 r
F
.38352 .36125 m .41566 .36764 L .41057 .37554 L F
.37857 .36921 m .40483 .90949 L .41057 .37554 L .212 0 .975 r
F
.41566 .36764 m .41057 .37554 L .40483 .90949 L .149 0 .683 r
F
.13506 .37549 m .10119 .86466 L .13756 .86949 L .976 0 .773 r
F
.13506 .37549 m .09729 .87067 L .10119 .86466 L .506 0 .401 r
F
.44444 .36052 m .47097 .37482 L .43918 .36848 L .019 0 .954 r
F
.44444 .36052 m .47635 .36691 L .47097 .37482 L F
.43918 .36848 m .47207 .90975 L .47097 .37482 L .019 0 .974 r
F
.47635 .36691 m .47097 .37482 L .47207 .90975 L .014 0 .71 r
F
.19533 .37476 m .16616 .89153 L .20246 .89627 L .976 0 .966 r
F
.19533 .37476 m .16189 .89743 L .16616 .89153 L .554 0 .548 r
F
.5054 .35978 m .53141 .3741 L .49985 .36776 L 0 .17 .954 r
F
.5054 .35978 m .5371 .36618 L .53141 .3741 L F
.49985 .36776 m .53936 .90763 L .53141 .3741 L 0 .173 .974 r
F
.5371 .36618 m .53141 .3741 L .53936 .90763 L 0 .13 .733 r
F
.25565 .37404 m .23316 .88941 L .26917 .89416 L .792 0 .975 r
F
.25565 .37404 m .22852 .89532 L .23316 .88941 L .484 0 .596 r
F
.56643 .35905 m .59191 .37337 L .56058 .36703 L 0 .359 .954 r
F
.56643 .35905 m .59789 .36545 L .59191 .37337 L F
.56058 .36703 m .60679 .90947 L .59191 .37337 L 0 .366 .974 r
F
.59789 .36545 m .59191 .37337 L .60679 .90947 L 0 .283 .754 r
F
.31603 .37332 m .29984 .89834 L .33565 .90306 L .599 0 .975 r
F
.31603 .37332 m .29484 .90422 L .29984 .89834 L .388 0 .633 r
F
.07631 .37283 m .03881 .8316 L .0753 .83654 L .976 0 .773 r
F
.07977 .36491 m .07631 .37283 L .03881 .8316 L .452 0 .358 r
F
.62751 .35831 m .65246 .37265 L .62135 .3663 L 0 .548 .954 r
F
.62751 .35831 m .65875 .36472 L .65246 .37265 L F
.62135 .3663 m .67418 .90734 L .65246 .37265 L 0 .559 .973 r
F
.65875 .36472 m .65246 .37265 L .67418 .90734 L 0 .443 .772 r
F
.37646 .3726 m .36689 .90413 L .40247 .90883 L .406 0 .975 r
F
.37646 .3726 m .36152 .90999 L .36689 .90413 L .277 0 .665 r
F
.10119 .86466 m .13348 .87545 L .09729 .87067 L .885 0 .701 r
F
.10119 .86466 m .13756 .86949 L .13348 .87545 L F
.13666 .37211 m .10212 .87302 L .13865 .87783 L .976 0 .966 r
F
.14041 .36418 m .13666 .37211 L .10212 .87302 L .506 0 .501 r
F
.68864 .35757 m .71307 .37193 L .68219 .36557 L 0 .737 .954 r
F
.68864 .35757 m .71966 .36399 L .71307 .37193 L F
.68864 .35757 m .71307 .37193 L .68219 .36557 L F
.68864 .35757 m .71966 .36399 L .71307 .37193 L F
.43695 .37187 m .43418 .90835 L .46952 .91305 L .212 0 .974 r
F
.43695 .37187 m .42843 .9142 L .43418 .90835 L .151 0 .694 r
F
.19705 .37139 m .16823 .88504 L .20457 .88981 L .792 0 .976 r
F
.20111 .36345 m .19705 .37139 L .16823 .88504 L .45 0 .554 r
F
.11303 .37127 m .0753 .83654 L .07907 .83037 L .485 0 .384 r
F
.07977 .36491 m .07907 .83037 L .11303 .37127 L .976 0 .773 r
F
.49749 .37115 m .50165 .911 L .53673 .91568 L .019 0 .974 r
F
.49749 .37115 m .49553 .91683 L .50165 .911 L .014 0 .719 r
F
.23316 .88941 m .26436 .90002 L .22852 .89532 L .714 0 .879 r
F
.23316 .88941 m .26917 .89416 L .26436 .90002 L F
.25751 .37066 m .23499 .89081 L .27111 .89556 L .599 0 .975 r
F
.26186 .36272 m .25751 .37066 L .23499 .89081 L .366 0 .596 r
F
.17345 .37055 m .13865 .87783 L .1428 .87182 L .535 0 .53 r
F
.14041 .36418 m .1428 .87182 L .17345 .37055 L .976 0 .966 r
F
.55808 .37042 m .56907 .9041 L .60383 .90881 L 0 .173 .974 r
F
.55808 .37042 m .56259 .90996 L .56907 .9041 L 0 .132 .742 r
F
.31801 .36994 m .30208 .89342 L .33794 .89817 L .406 0 .975 r
F
.32266 .36198 m .31801 .36994 L .30208 .89342 L .263 0 .633 r
F
.23392 .36982 m .20457 .88981 L .20909 .88386 L .471 0 .579 r
F
.20111 .36345 m .20909 .88386 L .23392 .36982 L .792 0 .975 r
F
.61873 .3697 m .63684 .91072 L .67137 .91541 L 0 .366 .973 r
F
.61873 .3697 m .62998 .91656 L .63684 .91072 L 0 .286 .761 r
F
.36689 .90413 m .40247 .90883 L .39693 .91464 L .364 0 .876 r
F
.37857 .36921 m .36916 .90478 L .40483 .90949 L .212 0 .975 r
F
.38352 .36125 m .37857 .36921 L .36916 .90478 L .145 0 .665 r
F
.29445 .3691 m .27111 .89556 L .27599 .88963 L .38 0 .618 r
F
.26186 .36272 m .27599 .88963 L .29445 .3691 L .599 0 .975 r
F
.43918 .36848 m .43667 .90504 L .47207 .90975 L .019 0 .974 r
F
.44444 .36052 m .43918 .36848 L .43667 .90504 L .014 0 .694 r
F
.35503 .36837 m .33794 .89817 L .3432 .89225 L .272 0 .653 r
F
.32266 .36198 m .3432 .89225 L .35503 .36837 L .406 0 .975 r
F
.08477 .35345 m .11459 .36788 L .08126 .36149 L .954 0 .945 r
F
.08477 .35345 m .11824 .35991 L .11459 .36788 L F
.07977 .36491 m .0424 .82537 L .07907 .83037 L .976 0 .773 r
F
.0424 .82537 m .07907 .83037 L .0753 .83654 L .892 0 .706 r
F
.08126 .36149 m .07875 .85412 L .11459 .36788 L .976 0 .966 r
F
.11824 .35991 m .11459 .36788 L .07875 .85412 L .485 0 .48 r
F
.49985 .36776 m .50425 .9029 L .53936 .90763 L 0 .173 .974 r
F
.5054 .35978 m .49985 .36776 L .50425 .9029 L 0 .128 .719 r
F
.41566 .36764 m .40483 .90949 L .41047 .90361 L .149 0 .683 r
F
.38352 .36125 m .41047 .90361 L .41566 .36764 L .212 0 .974 r
F
.14584 .35271 m .17513 .36715 L .14203 .36076 L .775 0 .954 r
F
.14584 .35271 m .17909 .35917 L .17513 .36715 L F
.14203 .36076 m .14445 .87159 L .17513 .36715 L .792 0 .976 r
F
.17909 .35917 m .17513 .36715 L .14445 .87159 L .435 0 .535 r
F
.56907 .9041 m .60383 .90881 L .59719 .91462 L 0 .156 .875 r
F
.56058 .36703 m .57194 .90475 L .60679 .90947 L 0 .366 .974 r
F
.56643 .35905 m .56058 .36703 L .57194 .90475 L 0 .279 .742 r
F
.47635 .36691 m .47207 .90975 L .47808 .90387 L .014 0 .71 r
F
.44444 .36052 m .47808 .90387 L .47635 .36691 L .019 0 .974 r
F
.20696 .35197 m .23573 .36642 L .20286 .36002 L .586 0 .954 r
F
.20696 .35197 m .23999 .35843 L .23573 .36642 L F
.20286 .36002 m .21097 .88286 L .23573 .36642 L .599 0 .975 r
F
.23999 .35843 m .23573 .36642 L .21097 .88286 L .356 0 .579 r
F
.62135 .3663 m .63962 .90261 L .67418 .90734 L 0 .559 .973 r
F
.62751 .35831 m .62135 .3663 L .63962 .90261 L 0 .437 .761 r
F
.5371 .36618 m .53936 .90763 L .54574 .90173 L 0 .13 .733 r
F
.5054 .35978 m .54574 .90173 L .5371 .36618 L 0 .173 .974 r
F
.26815 .35123 m .29639 .36569 L .26373 .35929 L .397 0 .954 r
F
.26815 .35123 m .30094 .3577 L .29639 .36569 L F
.26373 .35929 m .27841 .87836 L .29639 .36569 L .406 0 .975 r
F
.30094 .3577 m .29639 .36569 L .27841 .87836 L .257 0 .618 r
F
.59789 .36545 m .60679 .90947 L .61354 .90358 L 0 .283 .754 r
F
.56643 .35905 m .61354 .90358 L .59789 .36545 L 0 .366 .973 r
F
.32938 .35049 m .35709 .36496 L .32467 .35855 L .208 0 .954 r
F
.32938 .35049 m .36195 .35696 L .35709 .36496 L F
.32467 .35855 m .3454 .89286 L .35709 .36496 L .212 0 .975 r
F
.36195 .35696 m .35709 .36496 L .3454 .89286 L .142 0 .653 r
F
.07977 .36491 m .03881 .8316 L .0424 .82537 L .452 0 .358 r
F
.65875 .36472 m .67418 .90734 L .6813 .90144 L 0 .443 .772 r
F
.62751 .35831 m .6813 .90144 L .65875 .36472 L 0 .559 .973 r
F
.39068 .34974 m .41786 .36423 L .38566 .35781 L .019 0 .954 r
F
.39068 .34974 m .42302 .35622 L .41786 .36423 L F
.38566 .35781 m .4129 .90107 L .41786 .36423 L .019 0 .974 r
F
.42302 .35622 m .41786 .36423 L .4129 .90107 L .014 0 .683 r
F
.14041 .36418 m .10609 .86696 L .1428 .87182 L .976 0 .966 r
F
.14041 .36418 m .10212 .87302 L .10609 .86696 L .506 0 .501 r
F
.45203 .349 m .47868 .3635 L .4467 .35708 L 0 .17 .954 r
F
.45203 .349 m .48414 .35548 L .47868 .3635 L F
.4467 .35708 m .48065 .89574 L .47868 .3635 L 0 .173 .974 r
F
.48414 .35548 m .47868 .3635 L .48065 .89574 L 0 .126 .71 r
F
.20111 .36345 m .17257 .87903 L .20909 .88386 L .792 0 .975 r
F
.20111 .36345 m .16823 .88504 L .17257 .87903 L .45 0 .554 r
F
.51343 .34825 m .53955 .36277 L .5078 .35634 L 0 .359 .954 r
F
.51343 .34825 m .54531 .35475 L .53955 .36277 L F
.5078 .35634 m .54849 .89918 L .53955 .36277 L 0 .366 .974 r
F
.54531 .35475 m .53955 .36277 L .54849 .89918 L 0 .276 .733 r
F
.26186 .36272 m .2397 .88482 L .27599 .88963 L .599 0 .975 r
F
.26186 .36272 m .23499 .89081 L .2397 .88482 L .366 0 .596 r
F
.57489 .34751 m .60048 .36204 L .56896 .3556 L 0 .548 .954 r
F
.57489 .34751 m .60655 .35401 L .60048 .36204 L F
.56896 .3556 m .61636 .89784 L .60048 .36204 L 0 .559 .973 r
F
.60655 .35401 m .60048 .36204 L .61636 .89784 L 0 .433 .754 r
F
.32266 .36198 m .30716 .88744 L .3432 .89225 L .406 0 .975 r
F
.32266 .36198 m .30208 .89342 L .30716 .88744 L .263 0 .633 r
F
.0424 .82537 m .0753 .83654 L .03881 .8316 L .892 0 .706 r
F
.08126 .36149 m .04181 .84918 L .07875 .85412 L .976 0 .966 r
F
.08477 .35345 m .08126 .36149 L .04181 .84918 L .452 0 .447 r
F
.63641 .34676 m .66146 .3613 L .63017 .35486 L 0 .737 .954 r
F
.63641 .34676 m .66783 .35327 L .66146 .3613 L F
.63017 .35486 m .68411 .8925 L .66146 .3613 L 0 .751 .973 r
F
.66783 .35327 m .66146 .3613 L .68411 .8925 L 0 .596 .772 r
F
.38352 .36125 m .37463 .89885 L .41047 .90361 L .212 0 .974 r
F
.38352 .36125 m .36916 .90478 L .37463 .89885 L .145 0 .665 r
F
.14203 .36076 m .10764 .86671 L .14445 .87159 L .792 0 .976 r
F
.14584 .35271 m .14203 .36076 L .10764 .86671 L .411 0 .506 r
F
.69798 .34601 m .7225 .36057 L .69143 .35412 L 0 .925 .954 r
F
.69798 .34601 m .72918 .35252 L .7225 .36057 L F
.69798 .34601 m .7225 .36057 L .69143 .35412 L F
.69798 .34601 m .72918 .35252 L .7225 .36057 L F
.44444 .36052 m .44251 .8991 L .47808 .90387 L .019 0 .974 r
F
.44444 .36052 m .43667 .90504 L .44251 .8991 L .014 0 .694 r
F
.20286 .36002 m .17435 .87802 L .21097 .88286 L .599 0 .975 r
F
.20696 .35197 m .20286 .36002 L .17435 .87802 L .34 0 .554 r
F
.11824 .35991 m .07875 .85412 L .08259 .84796 L .485 0 .48 r
F
.08477 .35345 m .08259 .84796 L .11824 .35991 L .976 0 .966 r
F
.5054 .35978 m .51046 .89695 L .54574 .90173 L 0 .173 .974 r
F
.5054 .35978 m .50425 .9029 L .51046 .89695 L 0 .128 .719 r
F
.26373 .35929 m .2421 .8735 L .27841 .87836 L .406 0 .975 r
F
.26815 .35123 m .26373 .35929 L .2421 .8735 L .248 0 .596 r
F
.17909 .35917 m .14445 .87159 L .14866 .8655 L .435 0 .535 r
F
.14584 .35271 m .14866 .8655 L .17909 .35917 L .792 0 .975 r
F
.56643 .35905 m .57852 .8988 L .61354 .90358 L 0 .366 .973 r
F
.56643 .35905 m .57194 .90475 L .57852 .8988 L 0 .279 .742 r
F
.30716 .88744 m .3432 .89225 L .33794 .89817 L .365 0 .878 r
F
.32467 .35855 m .30927 .88805 L .3454 .89286 L .212 0 .975 r
F
.32938 .35049 m .32467 .35855 L .30927 .88805 L .138 0 .633 r
F
.23999 .35843 m .21097 .88286 L .21555 .87682 L .356 0 .579 r
F
.20696 .35197 m .21555 .87682 L .23999 .35843 L .599 0 .975 r
F
.62751 .35831 m .64658 .89665 L .6813 .90144 L 0 .559 .973 r
F
.62751 .35831 m .63962 .90261 L .64658 .89665 L 0 .437 .761 r
F
.38566 .35781 m .37699 .89628 L .4129 .90107 L .019 0 .974 r
F
.39068 .34974 m .38566 .35781 L .37699 .89628 L .013 0 .665 r
F
.30094 .3577 m .27841 .87836 L .28337 .8723 L .257 0 .618 r
F
.26815 .35123 m .28337 .8723 L .30094 .3577 L .406 0 .975 r
F
.4467 .35708 m .44505 .89093 L .48065 .89574 L 0 .173 .974 r
F
.45203 .349 m .4467 .35708 L .44505 .89093 L 0 .124 .694 r
F
.36195 .35696 m .3454 .89286 L .35074 .88685 L .142 0 .653 r
F
.32938 .35049 m .35074 .88685 L .36195 .35696 L .212 0 .974 r
F
.08983 .34183 m .11982 .35646 L .08628 .34999 L .775 0 .954 r
F
.08983 .34183 m .12353 .34838 L .11982 .35646 L F
.08628 .34999 m .08276 .86581 L .11982 .35646 L .792 0 .976 r
F
.12353 .34838 m .11982 .35646 L .08276 .86581 L .394 0 .485 r
F
.5078 .35634 m .51314 .89438 L .54849 .89918 L 0 .366 .974 r
F
.51343 .34825 m .5078 .35634 L .51314 .89438 L 0 .27 .719 r
F
.42302 .35622 m .4129 .90107 L .41863 .8951 L .014 0 .683 r
F
.39068 .34974 m .41863 .8951 L .42302 .35622 L .019 0 .974 r
F
.15134 .34108 m .18079 .35573 L .14748 .34924 L .586 0 .954 r
F
.15134 .34108 m .1848 .34763 L .18079 .35573 L F
.14748 .34924 m .15057 .86129 L .18079 .35573 L .599 0 .975 r
F
.1848 .34763 m .18079 .35573 L .15057 .86129 L .329 0 .535 r
F
.56896 .3556 m .5813 .89303 L .61636 .89784 L 0 .559 .973 r
F
.57489 .34751 m .56896 .3556 L .5813 .89303 L 0 .426 .742 r
F
.48414 .35548 m .48065 .89574 L .48675 .88974 L 0 .126 .71 r
F
.45203 .349 m .48675 .88974 L .48414 .35548 L 0 .173 .974 r
F
.21291 .34033 m .24182 .35499 L .20874 .3485 L .397 0 .954 r
F
.21291 .34033 m .24614 .34689 L .24182 .35499 L F
.20874 .3485 m .21824 .85914 L .24182 .35499 L .406 0 .975 r
F
.24614 .34689 m .24182 .35499 L .21824 .85914 L .241 0 .579 r
F
.63017 .35486 m .64936 .88767 L .68411 .8925 L 0 .751 .973 r
F
.63641 .34676 m .63017 .35486 L .64936 .88767 L 0 .588 .761 r
F
.54531 .35475 m .54849 .89918 L .55497 .89319 L 0 .276 .733 r
F
.51343 .34825 m .55497 .89319 L .54531 .35475 L 0 .366 .973 r
F
.27453 .33958 m .30291 .35425 L .27005 .34775 L .208 0 .954 r
F
.27453 .33958 m .30753 .34614 L .30291 .35425 L F
.27005 .34775 m .2854 .87285 L .30291 .35425 L .212 0 .975 r
F
.30753 .34614 m .30291 .35425 L .2854 .87285 L .135 0 .618 r
F
.60655 .35401 m .61636 .89784 L .62321 .89184 L 0 .433 .754 r
F
.57489 .34751 m .62321 .89184 L .60655 .35401 L 0 .559 .973 r
F
.3362 .33882 m .36405 .35351 L .33142 .347 L .019 0 .954 r
F
.3362 .33882 m .36898 .34539 L .36405 .35351 L F
.33142 .347 m .35293 .88986 L .36405 .35351 L .019 0 .974 r
F
.36898 .34539 m .36405 .35351 L .35293 .88986 L .013 0 .653 r
F
.08477 .35345 m .04547 .84297 L .08259 .84796 L .976 0 .966 r
F
.08477 .35345 m .04181 .84918 L .04547 .84297 L .452 0 .447 r
F
.66783 .35327 m .68411 .8925 L .69133 .88648 L 0 .596 .772 r
F
.63641 .34676 m .69133 .88648 L .66783 .35327 L 0 .751 .973 r
F
.39794 .33807 m .42524 .35277 L .39285 .34626 L 0 .17 .954 r
F
.39794 .33807 m .43048 .34464 L .42524 .35277 L F
.39285 .34626 m .42115 .8869 L .42524 .35277 L 0 .173 .974 r
F
.43048 .34464 m .42524 .35277 L .42115 .8869 L 0 .122 .683 r
F
.14584 .35271 m .11168 .86057 L .14866 .8655 L .792 0 .975 r
F
.14584 .35271 m .10764 .86671 L .11168 .86057 L .411 0 .506 r
F
.45973 .33731 m .4865 .35202 L .45433 .34551 L 0 .359 .954 r
F
.45973 .33731 m .49204 .34389 L .4865 .35202 L F
.45433 .34551 m .48938 .88635 L .4865 .35202 L 0 .366 .974 r
F
.49204 .34389 m .4865 .35202 L .48938 .88635 L 0 .267 .71 r
F
.20696 .35197 m .17876 .87193 L .21555 .87682 L .599 0 .975 r
F
.20696 .35197 m .17435 .87802 L .17876 .87193 L .34 0 .554 r
F
.52157 .33656 m .5478 .35128 L .51586 .34476 L 0 .548 .954 r
F
.52157 .33656 m .55365 .34314 L .5478 .35128 L F
.51586 .34476 m .55774 .889 L .5478 .35128 L 0 .559 .973 r
F
.55365 .34314 m .5478 .35128 L .55774 .889 L 0 .421 .733 r
F
.26815 .35123 m .24688 .86738 L .28337 .8723 L .406 0 .975 r
F
.26815 .35123 m .2421 .8735 L .24688 .86738 L .248 0 .596 r
F
.58348 .3358 m .60917 .35054 L .57746 .34401 L 0 .737 .954 r
F
.58348 .3358 m .61532 .34239 L .60917 .35054 L F
.57746 .34401 m .62594 .88203 L .60917 .35054 L 0 .751 .973 r
F
.61532 .34239 m .60917 .35054 L .62594 .88203 L 0 .582 .754 r
F
.32938 .35049 m .31443 .88199 L .35074 .88685 L .212 0 .974 r
F
.32938 .35049 m .30927 .88805 L .31443 .88199 L .138 0 .633 r
F
.04547 .84297 m .07875 .85412 L .04181 .84918 L .886 0 .877 r
F
.04547 .84297 m .08259 .84796 L .07875 .85412 L F
.08628 .34999 m .0454 .86087 L .08276 .86581 L .792 0 .976 r
F
.08983 .34183 m .08628 .34999 L .0454 .86087 L .367 0 .452 r
F
.64544 .33505 m .67058 .3498 L .6391 .34326 L 0 .925 .954 r
F
.64544 .33505 m .67705 .34164 L .67058 .3498 L F
.6391 .34326 m .69473 .8903 L .67058 .3498 L 0 .943 .973 r
F
.67705 .34164 m .67058 .3498 L .69473 .8903 L 0 .749 .772 r
F
.39068 .34974 m .38254 .89025 L .41863 .8951 L .019 0 .974 r
F
.39068 .34974 m .37699 .89628 L .38254 .89025 L .013 0 .665 r
F
.14748 .34924 m .11352 .85633 L .15057 .86129 L .599 0 .975 r
F
.15134 .34108 m .14748 .34924 L .11352 .85633 L .311 0 .506 r
F
.70745 .33429 m .73206 .34905 L .70081 .34251 L 0 .954 .794 r
F
.70745 .33429 m .73883 .34089 L .73206 .34905 L F
.70745 .33429 m .73206 .34905 L .70081 .34251 L F
.70745 .33429 m .73883 .34089 L .73206 .34905 L F
.45203 .349 m .45098 .88488 L .48675 .88974 L 0 .173 .974 r
F
.45203 .349 m .44505 .89093 L .45098 .88488 L 0 .124 .694 r
F
.20874 .3485 m .18148 .85417 L .21824 .85914 L .406 0 .975 r
F
.21291 .34033 m .20874 .3485 L .18148 .85417 L .23 0 .554 r
F
.12353 .34838 m .08276 .86581 L .08667 .85964 L .394 0 .485 r
F
.08983 .34183 m .08667 .85964 L .12353 .34838 L .792 0 .975 r
F
.51343 .34825 m .51945 .88834 L .55497 .89319 L 0 .366 .973 r
F
.51343 .34825 m .51314 .89438 L .51945 .88834 L 0 .27 .719 r
F
.24688 .86738 m .28337 .8723 L .27841 .87836 L .366 0 .88 r
F
.27005 .34775 m .24882 .86793 L .2854 .87285 L .212 0 .975 r
F
.27453 .33958 m .27005 .34775 L .24882 .86793 L .13 0 .596 r
F
.1848 .34763 m .15057 .86129 L .15485 .8551 L .329 0 .535 r
F
.15134 .34108 m .15485 .8551 L .1848 .34763 L .599 0 .975 r
F
.57489 .34751 m .58799 .88698 L .62321 .89184 L 0 .559 .973 r
F
.57489 .34751 m .5813 .89303 L .58799 .88698 L 0 .426 .742 r
F
.31443 .88199 m .3454 .89286 L .30927 .88805 L .191 0 .877 r
F
.31443 .88199 m .35074 .88685 L .3454 .89286 L F
.33142 .347 m .31651 .88499 L .35293 .88986 L .019 0 .974 r
F
.3362 .33882 m .33142 .347 L .31651 .88499 L .013 0 .633 r
F
.24614 .34689 m .21824 .85914 L .22289 .85294 L .241 0 .579 r
F
.21291 .34033 m .22289 .85294 L .24614 .34689 L .406 0 .975 r
F
.63641 .34676 m .65642 .88159 L .69133 .88648 L 0 .751 .973 r
F
.63641 .34676 m .64936 .88767 L .65642 .88159 L 0 .588 .761 r
F
.39285 .34626 m .38502 .88202 L .42115 .8869 L 0 .173 .974 r
F
.39794 .33807 m .39285 .34626 L .38502 .88202 L 0 .118 .665 r
F
.30753 .34614 m .2854 .87285 L .29044 .86671 L .135 0 .618 r
F
.27453 .33958 m .29044 .86671 L .30753 .34614 L .212 0 .974 r
F
.45433 .34551 m .45354 .88146 L .48938 .88635 L 0 .366 .974 r
F
.45973 .33731 m .45433 .34551 L .45354 .88146 L 0 .261 .694 r
F
.36898 .34539 m .35293 .88986 L .35837 .88378 L .013 0 .653 r
F
.3362 .33882 m .35837 .88378 L .36898 .34539 L .019 0 .974 r
F
.09497 .33005 m .12513 .34489 L .09137 .33832 L .586 0 .954 r
F
.09497 .33005 m .12888 .33669 L .12513 .34489 L F
.09137 .33832 m .08824 .85857 L .12513 .34489 L .599 0 .975 r
F
.12888 .33669 m .12513 .34489 L .08824 .85857 L .298 0 .485 r
F
.51586 .34476 m .52216 .88412 L .55774 .889 L 0 .559 .973 r
F
.52157 .33656 m .51586 .34476 L .52216 .88412 L 0 .413 .719 r
F
.43048 .34464 m .42115 .8869 L .42696 .88081 L 0 .122 .683 r
F
.39794 .33807 m .42696 .88081 L .43048 .34464 L 0 .173 .974 r
F
.15692 .32929 m .18654 .34414 L .15301 .33756 L .397 0 .954 r
F
.15692 .32929 m .1906 .33593 L .18654 .34414 L F
.15692 .32929 m .18654 .34414 L .15301 .33756 L F
.15692 .32929 m .1906 .33593 L .18654 .34414 L F
.57746 .34401 m .5907 .87712 L .62594 .88203 L 0 .751 .973 r
F
.58348 .3358 m .57746 .34401 L .5907 .87712 L 0 .573 .742 r
F
.49204 .34389 m .48938 .88635 L .49557 .88025 L 0 .267 .71 r
F
.45973 .33731 m .49557 .88025 L .49204 .34389 L 0 .366 .973 r
F
.60376 1.02084 m .62274 1.02036 L .61963 1.02277 L .87 0 .172 r
F
.21893 .32852 m .248 .34339 L .21471 .33681 L .208 0 .954 r
F
.21893 .32852 m .25238 .33517 L .248 .34339 L F
.21471 .33681 m .22476 .85344 L .248 .34339 L .212 0 .975 r
F
.25238 .33517 m .248 .34339 L .22476 .85344 L .126 0 .579 r
F
.65642 .88159 m .68411 .8925 L .64936 .88767 L 0 .677 .876 r
F
.65642 .88159 m .69133 .88648 L .68411 .8925 L F
.6391 .34326 m .65972 .88541 L .69473 .8903 L 0 .943 .973 r
F
.64544 .33505 m .6391 .34326 L .65972 .88541 L 0 .739 .761 r
F
.55365 .34314 m .55774 .889 L .56431 .8829 L 0 .421 .733 r
F
.52157 .33656 m .56431 .8829 L .55365 .34314 L 0 .559 .973 r
F
.281 .32776 m .30952 .34264 L .27646 .33605 L .019 0 .954 r
F
.281 .32776 m .31421 .33442 L .30952 .34264 L F
.27646 .33605 m .29233 .87287 L .30952 .34264 L .019 0 .974 r
F
.31421 .33442 m .30952 .34264 L .29233 .87287 L .012 0 .618 r
F
.61532 .34239 m .62594 .88203 L .63289 .8759 L 0 .582 .754 r
F
.58348 .3358 m .63289 .8759 L .61532 .34239 L 0 .751 .973 r
F
.34312 .327 m .3711 .34189 L .33827 .33529 L 0 .17 .954 r
F
.34312 .327 m .3761 .33366 L .3711 .34189 L F
.33827 .33529 m .36091 .8707 L .3711 .34189 L 0 .173 .974 r
F
.3761 .33366 m .3711 .34189 L .36091 .8707 L 0 .116 .653 r
F
.08983 .34183 m .04912 .85465 L .08667 .85964 L .792 0 .975 r
F
.08983 .34183 m .0454 .86087 L .04912 .85465 L .367 0 .452 r
F
.67705 .34164 m .69473 .8903 L .70208 .8842 L 0 .749 .772 r
F
.64544 .33505 m .70208 .8842 L .67705 .34164 L 0 .943 .972 r
F
.4053 .32623 m .43274 .34114 L .40014 .33454 L 0 .359 .954 r
F
.4053 .32623 m .43804 .3329 L .43274 .34114 L F
.40014 .33454 m .42947 .87737 L .43274 .34114 L 0 .366 .974 r
F
.43804 .3329 m .43274 .34114 L .42947 .87737 L 0 .257 .683 r
F
.15134 .34108 m .11762 .85008 L .15485 .8551 L .599 0 .975 r
F
.15134 .34108 m .11352 .85633 L .11762 .85008 L .311 0 .506 r
F
.46754 .32546 m .49443 .34039 L .46206 .33378 L 0 .548 .954 r
F
.46754 .32546 m .50005 .33214 L .49443 .34039 L F
.46206 .33378 m .49824 .87761 L .49443 .34039 L 0 .559 .973 r
F
.50005 .33214 m .49443 .34039 L .49824 .87761 L 0 .407 .71 r
F
.21291 .34033 m .18595 .84791 L .22289 .85294 L .406 0 .975 r
F
.21291 .34033 m .18148 .85417 L .18595 .84791 L .23 0 .554 r
F
.58782 1.01891 m .59087 1.01648 L .60376 1.02084 L .87 0 .172 r
F
.60376 1.02084 m .59087 1.01648 L .62274 1.02036 L F
.52983 .3247 m .55617 .33963 L .52404 .33302 L 0 .737 .954 r
F
.52983 .3247 m .56211 .33138 L .55617 .33963 L F
.52404 .33302 m .56697 .87141 L .55617 .33963 L 0 .751 .973 r
F
.56211 .33138 m .55617 .33963 L .56697 .87141 L 0 .566 .733 r
F
.27453 .33958 m .25368 .86173 L .29044 .86671 L .212 0 .974 r
F
.27453 .33958 m .24882 .86793 L .25368 .86173 L .13 0 .596 r
F
.59218 .32393 m .61798 .33888 L .58608 .33226 L 0 .925 .954 r
F
.59218 .32393 m .62422 .33062 L .61798 .33888 L F
.58608 .33226 m .63614 .88052 L .61798 .33888 L 0 .943 .973 r
F
.62422 .33062 m .61798 .33888 L .63614 .88052 L 0 .731 .754 r
F
.3362 .33882 m .32176 .87886 L .35837 .88378 L .019 0 .974 r
F
.3362 .33882 m .31651 .88499 L .32176 .87886 L .013 0 .633 r
F
.09137 .33832 m .0506 .85356 L .08824 .85857 L .599 0 .975 r
F
.09497 .33005 m .09137 .33832 L .0506 .85356 L .278 0 .452 r
F
.65459 .32316 m .67984 .33812 L .64817 .3315 L 0 .954 .794 r
F
.65459 .32316 m .6864 .32985 L .67984 .33812 L F
.64817 .3315 m .70503 .87672 L .67984 .33812 L 0 .972 .809 r
F
.6864 .32985 m .67984 .33812 L .70503 .87672 L 0 .772 .642 r
F
.39794 .33807 m .39066 .87587 L .42696 .88081 L 0 .173 .974 r
F
.39794 .33807 m .38502 .88202 L .39066 .87587 L 0 .118 .665 r
F
.71706 .32239 m .74176 .33737 L .71032 .33074 L 0 .954 .605 r
F
.71706 .32239 m .74863 .32909 L .74176 .33737 L F
.71032 .33074 m .77458 .88424 L .74176 .33737 L 0 .972 .616 r
F
.74863 .32909 m .74176 .33737 L .77458 .88424 L 0 .789 .5 r
F
.45973 .33731 m .45956 .8753 L .49557 .88025 L 0 .366 .973 r
F
.45973 .33731 m .45354 .88146 L .45956 .8753 L 0 .261 .694 r
F
.18595 .84791 m .22289 .85294 L .21824 .85914 L .367 0 .883 r
F
.21471 .33681 m .18771 .8484 L .22476 .85344 L .212 0 .975 r
F
.21893 .32852 m .21471 .33681 L .18771 .8484 L .121 0 .554 r
F
.12888 .33669 m .08824 .85857 L .09221 .85231 L .298 0 .485 r
F
.09497 .33005 m .09221 .85231 L .12888 .33669 L .599 0 .975 r
F
.52157 .33656 m .52857 .87797 L .56431 .8829 L 0 .559 .973 r
F
.52157 .33656 m .52216 .88412 L .52857 .87797 L 0 .413 .719 r
F
.5996 1.00799 m .62537 1.01681 L .59345 1.0129 L .87 0 .345 r
F
.5996 1.00799 m .63166 1.01193 L .62537 1.01681 L F
.25368 .86173 m .2854 .87285 L .24882 .86793 L .192 0 .88 r
F
.25368 .86173 m .29044 .86671 L .2854 .87285 L F
.27646 .33605 m .25542 .8679 L .29233 .87287 L .019 0 .974 r
F
.281 .32776 m .27646 .33605 L .25542 .8679 L .012 0 .596 r
F
.58348 .3358 m .59748 .87094 L .63289 .8759 L 0 .751 .973 r
F
.58348 .3358 m .5907 .87712 L .59748 .87094 L 0 .573 .742 r
F
.33827 .33529 m .32431 .86571 L .36091 .8707 L 0 .173 .974 r
F
.34312 .327 m .33827 .33529 L .32431 .86571 L 0 .113 .633 r
F
.25238 .33517 m .22476 .85344 L .22949 .84715 L .126 0 .579 r
F
.21893 .32852 m .22949 .84715 L .25238 .33517 L .212 0 .974 r
F
.64544 .33505 m .6669 .87926 L .70208 .8842 L 0 .943 .972 r
F
.64544 .33505 m .65972 .88541 L .6669 .87926 L 0 .739 .761 r
F
.40014 .33454 m .3931 .87241 L .42947 .87737 L 0 .366 .974 r
F
.4053 .32623 m .40014 .33454 L .3931 .87241 L 0 .25 .665 r
F
.31421 .33442 m .29233 .87287 L .29746 .86666 L .012 0 .618 r
F
.281 .32776 m .29746 .86666 L .31421 .33442 L .019 0 .974 r
F
.46206 .33378 m .46216 .87264 L .49824 .87761 L 0 .559 .973 r
F
.46754 .32546 m .46206 .33378 L .46216 .87264 L 0 .398 .694 r
F
.3761 .33366 m .36091 .8707 L .36642 .86448 L 0 .116 .653 r
F
.34312 .327 m .36642 .86448 L .3761 .33366 L 0 .173 .974 r
F
.10019 .31809 m .13051 .33315 L .09653 .32648 L .397 0 .954 r
F
.10019 .31809 m .13432 .32483 L .13051 .33315 L F
.10019 .31809 m .13051 .33315 L .09653 .32648 L F
.10019 .31809 m .13432 .32483 L .13051 .33315 L F
.52404 .33302 m .53122 .86641 L .56697 .87141 L 0 .751 .973 r
F
.52983 .3247 m .52404 .33302 L .53122 .86641 L 0 .555 .719 r
F
.43804 .3329 m .42947 .87737 L .43537 .87117 L 0 .257 .683 r
F
.4053 .32623 m .43537 .87117 L .43804 .3329 L 0 .366 .973 r
F
.55038 1.01361 m .56946 1.01313 L .56646 1.01557 L .87 0 .172 r
F
.16259 .31732 m .19236 .33239 L .15862 .32571 L .208 0 .954 r
F
.16259 .31732 m .19649 .32406 L .19236 .33239 L F
.15862 .32571 m .16449 .81633 L .19236 .33239 L .212 0 .975 r
F
.19649 .32406 m .19236 .33239 L .16449 .81633 L .117 0 .535 r
F
.59748 .87094 m .62594 .88203 L .5907 .87712 L 0 .677 .877 r
F
.59748 .87094 m .63289 .8759 L .62594 .88203 L F
.58608 .33226 m .60061 .87555 L .63614 .88052 L 0 .943 .973 r
F
.59218 .32393 m .58608 .33226 L .60061 .87555 L 0 .719 .742 r
F
.50005 .33214 m .49824 .87761 L .50453 .87141 L 0 .407 .71 r
F
.46754 .32546 m .50453 .87141 L .50005 .33214 L 0 .559 .973 r
F
.22505 .31655 m .25427 .33163 L .22076 .32495 L .019 0 .954 r
F
.22505 .31655 m .25871 .32329 L .25427 .33163 L F
.22076 .32495 m .2311 .85408 L .25427 .33163 L .019 0 .974 r
F
.25871 .32329 m .25427 .33163 L .2311 .85408 L .012 0 .579 r
F
.64817 .3315 m .66981 .87174 L .70503 .87672 L 0 .972 .809 r
F
.65459 .32316 m .64817 .3315 L .66981 .87174 L 0 .761 .633 r
F
.56211 .33138 m .56697 .87141 L .57364 .86518 L 0 .566 .733 r
F
.52983 .3247 m .57364 .86518 L .56211 .33138 L 0 .751 .973 r
F
.28756 .31577 m .31623 .33087 L .28296 .32418 L 0 .17 .954 r
F
.28756 .31577 m .32099 .32252 L .31623 .33087 L F
.28296 .32418 m .29977 .86075 L .31623 .33087 L 0 .173 .974 r
F
.32099 .32252 m .31623 .33087 L .29977 .86075 L 0 .11 .618 r
F
.71032 .33074 m .7396 .87929 L .77458 .88424 L 0 .972 .616 r
F
.71706 .32239 m .71032 .33074 L .7396 .87929 L 0 .779 .494 r
F
.62422 .33062 m .63614 .88052 L .64321 .87432 L 0 .731 .754 r
F
.59218 .32393 m .64321 .87432 L .62422 .33062 L 0 .943 .972 r
F
.35014 .315 m .37826 .3301 L .34522 .32341 L 0 .359 .954 r
F
.35014 .315 m .38333 .32175 L .37826 .3301 L F
.34522 .32341 m .36893 .85453 L .37826 .3301 L 0 .366 .974 r
F
.38333 .32175 m .37826 .3301 L .36893 .85453 L 0 .245 .653 r
F
.09497 .33005 m .05438 .84724 L .09221 .85231 L .599 0 .975 r
F
.09497 .33005 m .0506 .85356 L .05438 .84724 L .278 0 .452 r
F
.6864 .32985 m .70503 .87672 L .71249 .8705 L 0 .772 .642 r
F
.65459 .32316 m .71249 .8705 L .6864 .32985 L 0 .972 .809 r
F
.53424 1.01165 m .53716 1.00919 L .55038 1.01361 L .87 0 .172 r
F
.55038 1.01361 m .53716 1.00919 L .56946 1.01313 L F
.41277 .31422 m .44034 .32934 L .40753 .32264 L 0 .548 .954 r
F
.41277 .31422 m .44572 .32098 L .44034 .32934 L F
.40753 .32264 m .43793 .86688 L .44034 .32934 L 0 .559 .973 r
F
.44572 .32098 m .44034 .32934 L .43793 .86688 L 0 .392 .683 r
F
.74863 .32909 m .77458 .88424 L .78245 .87806 L 0 .789 .5 r
F
.71706 .32239 m .78245 .87806 L .74863 .32909 L 0 .971 .616 r
F
.47546 .31344 m .50247 .32858 L .4699 .32188 L 0 .737 .954 r
F
.47546 .31344 m .50817 .32021 L .50247 .32858 L F
.4699 .32188 m .50716 .85902 L .50247 .32858 L 0 .751 .973 r
F
.50817 .32021 m .50247 .32858 L .50716 .85902 L 0 .548 .71 r
F
.21893 .32852 m .19226 .84206 L .22949 .84715 L .212 0 .974 r
F
.21893 .32852 m .18771 .8484 L .19226 .84206 L .121 0 .554 r
F
.53821 .31266 m .56467 .32782 L .53233 .32111 L 0 .925 .954 r
F
.53821 .31266 m .57068 .31944 L .56467 .32782 L F
.53233 .32111 m .57671 .8706 L .56467 .32782 L 0 .943 .973 r
F
.57068 .31944 m .56467 .32782 L .57671 .8706 L 0 .711 .733 r
F
.281 .32776 m .26037 .86163 L .29746 .86666 L .019 0 .974 r
F
.281 .32776 m .25542 .8679 L .26037 .86163 L .012 0 .596 r
F
.60102 .31189 m .62692 .32705 L .59482 .32033 L 0 .954 .794 r
F
.60102 .31189 m .63325 .31867 L .62692 .32705 L F
.59482 .32033 m .64612 .86758 L .62692 .32705 L 0 .972 .809 r
F
.63325 .31867 m .62692 .32705 L .64612 .86758 L 0 .754 .627 r
F
.34312 .327 m .32963 .85944 L .36642 .86448 L 0 .173 .974 r
F
.34312 .327 m .32431 .86571 L .32963 .85944 L 0 .113 .633 r
F
.66388 .31111 m .68923 .32629 L .65737 .31956 L 0 .954 .605 r
F
.66388 .31111 m .69588 .3179 L .68923 .32629 L F
.65737 .31956 m .71599 .87351 L .68923 .32629 L 0 .972 .616 r
F
.69588 .3179 m .68923 .32629 L .71599 .87351 L 0 .772 .49 r
F
.54555 .99834 m .57196 1.00729 L .53963 1.00333 L .871 0 .345 r
F
.54555 .99834 m .57802 1.00234 L .57196 1.00729 L F
.4053 .32623 m .39882 .86615 L .43537 .87117 L 0 .366 .973 r
F
.4053 .32623 m .3931 .87241 L .39882 .86615 L 0 .25 .665 r
F
.15862 .32571 m .1271 .81112 L .16449 .81633 L .212 0 .975 r
F
.16259 .31732 m .15862 .32571 L .1271 .81112 L .11 0 .506 r
F
.72681 .31033 m .75159 .32552 L .71997 .31879 L 0 .954 .416 r
F
.72681 .31033 m .75856 .31712 L .75159 .32552 L F
.72681 .31033 m .75159 .32552 L .71997 .31879 L F
.72681 .31033 m .75856 .31712 L .75159 .32552 L F
.46754 .32546 m .46827 .86639 L .50453 .87141 L 0 .559 .973 r
F
.46754 .32546 m .46216 .87264 L .46827 .86639 L 0 .398 .694 r
F
.19226 .84206 m .22476 .85344 L .18771 .8484 L .192 0 .882 r
F
.19226 .84206 m .22949 .84715 L .22476 .85344 L F
.22076 .32495 m .19372 .84899 L .2311 .85408 L .019 0 .974 r
F
.22505 .31655 m .22076 .32495 L .19372 .84899 L .011 0 .554 r
F
.52983 .3247 m .53772 .86013 L .57364 .86518 L 0 .751 .973 r
F
.52983 .3247 m .53122 .86641 L .53772 .86013 L 0 .555 .719 r
F
.28296 .32418 m .26263 .85569 L .29977 .86075 L 0 .173 .974 r
F
.28756 .31577 m .28296 .32418 L .26263 .85569 L 0 .106 .596 r
F
.19649 .32406 m .16449 .81633 L .16889 .80983 L .117 0 .535 r
F
.16259 .31732 m .16889 .80983 L .19649 .32406 L .212 0 .974 r
F
.59218 .32393 m .60751 .8693 L .64321 .87432 L 0 .943 .972 r
F
.59218 .32393 m .60061 .87555 L .60751 .8693 L 0 .719 .742 r
F
.34522 .32341 m .33212 .84944 L .36893 .85453 L 0 .366 .974 r
F
.35014 .315 m .34522 .32341 L .33212 .84944 L 0 .238 .633 r
F
.25871 .32329 m .2311 .85408 L .23591 .84773 L .012 0 .579 r
F
.22505 .31655 m .23591 .84773 L .25871 .32329 L .019 0 .974 r
F
.65459 .32316 m .6771 .86547 L .71249 .8705 L 0 .972 .809 r
F
.65459 .32316 m .66981 .87174 L .6771 .86547 L 0 .761 .633 r
F
.49628 1.00329 m .51545 1.0028 L .51257 1.00528 L .871 0 .172 r
F
.40753 .32264 m .40132 .86183 L .43793 .86688 L 0 .559 .973 r
F
.41277 .31422 m .40753 .32264 L .40132 .86183 L 0 .382 .665 r
F
.32099 .32252 m .29977 .86075 L .30497 .85443 L 0 .11 .618 r
F
.28756 .31577 m .30497 .85443 L .32099 .32252 L 0 .173 .974 r
F
.71706 .32239 m .74731 .87305 L .78245 .87806 L 0 .971 .616 r
F
.71706 .32239 m .7396 .87929 L .74731 .87305 L 0 .779 .494 r
F
.4699 .32188 m .47089 .85394 L .50716 .85902 L 0 .751 .973 r
F
.47546 .31344 m .4699 .32188 L .47089 .85394 L 0 .536 .694 r
F
.38333 .32175 m .36893 .85453 L .37452 .84817 L 0 .245 .653 r
F
.35014 .315 m .37452 .84817 L .38333 .32175 L 0 .366 .973 r
F
.10548 .30596 m .13597 .32124 L .10177 .31447 L .208 0 .954 r
F
.10548 .30596 m .13984 .3128 L .13597 .32124 L F
.10177 .31447 m .10172 .81161 L .13597 .32124 L .212 0 .975 r
F
.13984 .3128 m .13597 .32124 L .10172 .81161 L .106 0 .485 r
F
.53772 .86013 m .56697 .87141 L .53122 .86641 L 0 .677 .877 r
F
.53772 .86013 m .57364 .86518 L .56697 .87141 L F
.53233 .32111 m .54065 .86555 L .57671 .8706 L 0 .943 .973 r
F
.53821 .31266 m .53233 .32111 L .54065 .86555 L 0 .698 .719 r
F
.44572 .32098 m .43793 .86688 L .44392 .86057 L 0 .392 .683 r
F
.41277 .31422 m .44392 .86057 L .44572 .32098 L 0 .559 .973 r
F
.16833 .30518 m .19827 .32047 L .1643 .3137 L .019 0 .954 r
F
.16833 .30518 m .20245 .31202 L .19827 .32047 L F
.1643 .3137 m .16957 .82863 L .19827 .32047 L .019 0 .974 r
F
.20245 .31202 m .19827 .32047 L .16957 .82863 L .011 0 .535 r
F
.59482 .32033 m .61038 .86253 L .64612 .86758 L 0 .972 .809 r
F
.60102 .31189 m .59482 .32033 L .61038 .86253 L 0 .742 .617 r
F
.50817 .32021 m .50716 .85902 L .51354 .85268 L 0 .548 .71 r
F
.47546 .31344 m .51354 .85268 L .50817 .32021 L 0 .751 .973 r
F
.23125 .30439 m .26062 .31969 L .2269 .31292 L 0 .17 .954 r
F
.23125 .30439 m .26513 .31124 L .26062 .31969 L F
.2269 .31292 m .23789 .84742 L .26062 .31969 L 0 .173 .974 r
F
.26513 .31124 m .26062 .31969 L .23789 .84742 L 0 .103 .579 r
F
.6771 .86547 m .70503 .87672 L .66981 .87174 L 0 .876 .729 r
F
.6771 .86547 m .71249 .8705 L .70503 .87672 L F
.65737 .31956 m .68049 .86847 L .71599 .87351 L 0 .972 .616 r
F
.66388 .31111 m .65737 .31956 L .68049 .86847 L 0 .761 .483 r
F
.47993 1.00129 m .48274 .9988 L .49628 1.00329 L .871 0 .172 r
F
.49628 1.00329 m .48274 .9988 L .51545 1.0028 L F
.57068 .31944 m .57671 .8706 L .58349 .8643 L 0 .711 .733 r
F
.53821 .31266 m .58349 .8643 L .57068 .31944 L 0 .943 .972 r
F
.29422 .30361 m .32304 .31892 L .28955 .31214 L 0 .359 .954 r
F
.29422 .30361 m .32786 .31046 L .32304 .31892 L F
.28955 .31214 m .30773 .8347 L .32304 .31892 L 0 .366 .974 r
F
.32786 .31046 m .32304 .31892 L .30773 .8347 L 0 .233 .618 r
F
.63325 .31867 m .64612 .86758 L .65331 .86127 L 0 .754 .627 r
F
.60102 .31189 m .65331 .86127 L .63325 .31867 L 0 .972 .809 r
F
.35726 .30282 m .38551 .31815 L .35226 .31136 L 0 .548 .954 r
F
.35726 .30282 m .39066 .30968 L .38551 .31815 L F
.35226 .31136 m .37687 .84949 L .38551 .31815 L 0 .559 .973 r
F
.39066 .30968 m .38551 .31815 L .37687 .84949 L 0 .375 .653 r
F
.69588 .3179 m .71599 .87351 L .72358 .86722 L 0 .772 .49 r
F
.66388 .31111 m .72358 .86722 L .69588 .3179 L 0 .971 .616 r
F
.42035 .30203 m .44804 .31738 L .41503 .31058 L 0 .737 .954 r
F
.42035 .30203 m .45351 .3089 L .44804 .31738 L F
.41503 .31058 m .44654 .84728 L .44804 .31738 L 0 .751 .973 r
F
.45351 .3089 m .44804 .31738 L .44654 .84728 L 0 .527 .683 r
F
.16259 .31732 m .13132 .80456 L .16889 .80983 L .212 0 .974 r
F
.16259 .31732 m .1271 .81112 L .13132 .80456 L .11 0 .506 r
F
.4835 .30124 m .51063 .3166 L .47786 .3098 L 0 .925 .954 r
F
.4835 .30124 m .51642 .30811 L .51063 .3166 L F
.47786 .3098 m .51638 .85808 L .51063 .3166 L 0 .943 .973 r
F
.51642 .30811 m .51063 .3166 L .51638 .85808 L 0 .688 .71 r
F
.22505 .31655 m .19834 .84259 L .23591 .84773 L .019 0 .974 r
F
.22505 .31655 m .19372 .84899 L .19834 .84259 L .011 0 .554 r
F
.54671 .30046 m .57328 .31583 L .54075 .30902 L 0 .954 .794 r
F
.54671 .30046 m .57938 .30733 L .57328 .31583 L F
.54075 .30902 m .58633 .8575 L .57328 .31583 L 0 .972 .809 r
F
.57938 .30733 m .57328 .31583 L .58633 .8575 L 0 .733 .61 r
F
.28756 .31577 m .26764 .84931 L .30497 .85443 L 0 .173 .974 r
F
.28756 .31577 m .26263 .85569 L .26764 .84931 L 0 .106 .596 r
F
.49083 .99083 m .51792 .99991 L .48515 .99589 L .871 0 .345 r
F
.49083 .99083 m .52375 .99489 L .51792 .99991 L F
.60998 .29967 m .63599 .31505 L .60369 .30824 L 0 .954 .605 r
F
.60998 .29967 m .64241 .30655 L .63599 .31505 L F
.60369 .30824 m .65653 .86182 L .63599 .31505 L 0 .972 .616 r
F
.64241 .30655 m .63599 .31505 L .65653 .86182 L 0 .754 .478 r
F
.35014 .315 m .33753 .84303 L .37452 .84817 L 0 .366 .973 r
F
.35014 .315 m .33212 .84944 L .33753 .84303 L 0 .238 .633 r
F
.10177 .31447 m .06375 .80633 L .10172 .81161 L .212 0 .975 r
F
.10548 .30596 m .10177 .31447 L .06375 .80633 L .099 0 .452 r
F
.67331 .29887 m .69875 .31428 L .6667 .30746 L 0 .954 .416 r
F
.67331 .29887 m .7055 .30576 L .69875 .31428 L F
.6667 .30746 m .72669 .86123 L .69875 .31428 L 0 .971 .424 r
F
.7055 .30576 m .69875 .31428 L .72669 .86123 L 0 .772 .337 r
F
.41277 .31422 m .40713 .85547 L .44392 .86057 L 0 .559 .973 r
F
.41277 .31422 m .40132 .86183 L .40713 .85547 L 0 .382 .665 r
F
.13132 .80456 m .16449 .81633 L .1271 .81112 L .194 0 .889 r
F
.13132 .80456 m .16889 .80983 L .16449 .81633 L F
.1643 .3137 m .13175 .82341 L .16957 .82863 L .019 0 .974 r
F
.16833 .30518 m .1643 .3137 L .13175 .82341 L .01 0 .506 r
F
.7367 .29808 m .76157 .3135 L .72976 .30667 L 0 .954 .227 r
F
.7367 .29808 m .76864 .30498 L .76157 .3135 L F
.7367 .29808 m .76157 .3135 L .72976 .30667 L F
.7367 .29808 m .76864 .30498 L .76157 .3135 L F
.47546 .31344 m .4771 .84754 L .51354 .85268 L 0 .751 .973 r
F
.47546 .31344 m .47089 .85394 L .4771 .84754 L 0 .536 .694 r
F
.44153 .99209 m .46078 .99159 L .45802 .99411 L .872 0 .173 r
F
.2269 .31292 m .20022 .84226 L .23789 .84742 L 0 .173 .974 r
F
.23125 .30439 m .2269 .31292 L .20022 .84226 L 0 .099 .554 r
F
.13984 .3128 m .10172 .81161 L .10581 .80502 L .106 0 .485 r
F
.10548 .30596 m .10581 .80502 L .13984 .3128 L .212 0 .974 r
F
.53821 .31266 m .54726 .8592 L .58349 .8643 L 0 .943 .972 r
F
.53821 .31266 m .54065 .86555 L .54726 .8592 L 0 .698 .719 r
F
.28955 .31214 m .27044 .82949 L .30773 .8347 L 0 .366 .974 r
F
.29422 .30361 m .28955 .31214 L .27044 .82949 L 0 .224 .596 r
F
.61758 .9952 m .64356 1.00426 L .61124 1.00025 L .87 0 .689 r
F
.61758 .9952 m .65004 .99926 L .64356 1.00426 L F
.20245 .31202 m .16957 .82863 L .17405 .82212 L .011 0 .535 r
F
.16833 .30518 m .17405 .82212 L .20245 .31202 L .019 0 .974 r
F
.60102 .31189 m .61739 .85616 L .65331 .86127 L 0 .972 .809 r
F
.60102 .31189 m .61038 .86253 L .61739 .85616 L 0 .742 .617 r
F
.33753 .84303 m .36893 .85453 L .33212 .84944 L 0 .331 .88 r
F
.33753 .84303 m .37452 .84817 L .36893 .85453 L F
.35226 .31136 m .33977 .84433 L .37687 .84949 L 0 .559 .973 r
F
.35726 .30282 m .35226 .31136 L .33977 .84433 L 0 .363 .633 r
F
.26513 .31124 m .23789 .84742 L .24278 .84098 L 0 .103 .579 r
F
.23125 .30439 m .24278 .84098 L .26513 .31124 L 0 .173 .974 r
F
.66388 .31111 m .68792 .86213 L .72358 .86722 L 0 .971 .616 r
F
.66388 .31111 m .68049 .86847 L .68792 .86213 L 0 .761 .483 r
F
.41503 .31058 m .40975 .84211 L .44654 .84728 L 0 .751 .973 r
F
.42035 .30203 m .41503 .31058 L .40975 .84211 L 0 .514 .665 r
F
.32786 .31046 m .30773 .8347 L .313 .8282 L 0 .233 .618 r
F
.29422 .30361 m .313 .8282 L .32786 .31046 L 0 .366 .973 r
F
.4771 .84754 m .50716 .85902 L .47089 .85394 L 0 .678 .878 r
F
.4771 .84754 m .51354 .85268 L .50716 .85902 L F
.47786 .3098 m .47981 .85295 L .51638 .85808 L 0 .943 .973 r
F
.4835 .30124 m .47786 .3098 L .47981 .85295 L 0 .673 .694 r
F
.39066 .30968 m .37687 .84949 L .38255 .84305 L 0 .375 .653 r
F
.35726 .30282 m .38255 .84305 L .39066 .30968 L 0 .559 .973 r
F
.42497 .99006 m .42765 .98751 L .44153 .99209 L .872 0 .173 r
F
.44153 .99209 m .42765 .98751 L .46078 .99159 L F
.11084 .29366 m .14151 .30915 L .10708 .30229 L .019 0 .954 r
F
.11084 .29366 m .14543 .30059 L .14151 .30915 L F
.10708 .30229 m .1079 .79736 L .14151 .30915 L .019 0 .974 r
F
.14543 .30059 m .14151 .30915 L .1079 .79736 L .01 0 .485 r
F
.54075 .30902 m .55005 .85236 L .58633 .8575 L 0 .972 .809 r
F
.54671 .30046 m .54075 .30902 L .55005 .85236 L 0 .719 .598 r
F
.45351 .3089 m .44654 .84728 L .45262 .84082 L 0 .527 .683 r
F
.42035 .30203 m .45262 .84082 L .45351 .3089 L 0 .751 .973 r
F
.17416 .29286 m .20426 .30837 L .17007 .3015 L 0 .17 .954 r
F
.17416 .29286 m .20851 .2998 L .20426 .30837 L F
.17007 .3015 m .17639 .81203 L .20426 .30837 L 0 .173 .974 r
F
.20851 .2998 m .20426 .30837 L .17639 .81203 L 0 .095 .535 r
F
.61739 .85616 m .65331 .86127 L .64612 .86758 L 0 .876 .729 r
F
.60369 .30824 m .62052 .85669 L .65653 .86182 L 0 .972 .616 r
F
.60998 .29967 m .60369 .30824 L .62052 .85669 L 0 .742 .47 r
F
.51642 .30811 m .51638 .85808 L .52288 .85167 L 0 .688 .71 r
F
.4835 .30124 m .52288 .85167 L .51642 .30811 L 0 .943 .972 r
F
.23754 .29206 m .26707 .30759 L .23313 .30071 L 0 .359 .954 r
F
.23754 .29206 m .27164 .29901 L .26707 .30759 L F
.23313 .30071 m .24574 .81789 L .26707 .30759 L 0 .366 .974 r
F
.27164 .29901 m .26707 .30759 L .24574 .81789 L 0 .218 .579 r
F
.6667 .30746 m .69098 .8561 L .72669 .86123 L 0 .971 .424 r
F
.67331 .29887 m .6667 .30746 L .69098 .8561 L 0 .761 .332 r
F
.57938 .30733 m .58633 .8575 L .59322 .85108 L 0 .733 .61 r
F
.54671 .30046 m .59322 .85108 L .57938 .30733 L 0 .972 .809 r
F
.30098 .29127 m .32995 .3068 L .29624 .29992 L 0 .548 .954 r
F
.30098 .29127 m .33484 .29822 L .32995 .3068 L F
.29624 .29992 m .31512 .83108 L .32995 .3068 L 0 .559 .973 r
F
.33484 .29822 m .32995 .3068 L .31512 .83108 L 0 .355 .618 r
F
.64241 .30655 m .65653 .86182 L .66383 .85542 L 0 .754 .478 r
F
.60998 .29967 m .66383 .85542 L .64241 .30655 L 0 .971 .616 r
F
.36448 .29047 m .39288 .30602 L .35941 .29913 L 0 .737 .954 r
F
.36448 .29047 m .39809 .29743 L .39288 .30602 L F
.35941 .29913 m .38512 .83292 L .39288 .30602 L 0 .751 .973 r
F
.39809 .29743 m .39288 .30602 L .38512 .83292 L 0 .504 .653 r
F
.10548 .30596 m .06764 .79968 L .10581 .80502 L .212 0 .974 r
F
.10548 .30596 m .06375 .80633 L .06764 .79968 L .099 0 .452 r
F
.7055 .30576 m .72669 .86123 L .73439 .85483 L 0 .772 .337 r
F
.67331 .29887 m .73439 .85483 L .7055 .30576 L 0 .971 .423 r
F
.42804 .28967 m .45587 .30524 L .42265 .29834 L 0 .925 .954 r
F
.42804 .28967 m .46141 .29663 L .45587 .30524 L F
.42265 .29834 m .45524 .84786 L .45587 .30524 L 0 .943 .973 r
F
.46141 .29663 m .45587 .30524 L .45524 .84786 L 0 .662 .683 r
F
.16833 .30518 m .13604 .81684 L .17405 .82212 L .019 0 .974 r
F
.16833 .30518 m .13175 .82341 L .13604 .81684 L .01 0 .506 r
F
.49166 .28887 m .51891 .30445 L .48594 .29755 L 0 .954 .794 r
F
.49166 .28887 m .52478 .29584 L .51891 .30445 L F
.48594 .29755 m .52565 .84644 L .51891 .30445 L 0 .972 .809 r
F
.52478 .29584 m .51891 .30445 L .52565 .84644 L 0 .71 .59 r
F
.23125 .30439 m .20491 .83576 L .24278 .84098 L 0 .173 .974 r
F
.23125 .30439 m .20022 .84226 L .20491 .83576 L 0 .099 .554 r
F
.43538 .98246 m .46316 .99168 L .42995 .9876 L .871 0 .345 r
F
.43538 .98246 m .46874 .98658 L .46316 .99168 L F
.55534 .28807 m .58202 .30366 L .54929 .29676 L 0 .954 .605 r
F
.55534 .28807 m .58821 .29504 L .58202 .30366 L F
.54929 .29676 m .59624 .84996 L .58202 .30366 L 0 .972 .616 r
F
.58821 .29504 m .58202 .30366 L .59624 .84996 L 0 .733 .465 r
F
.29422 .30361 m .27553 .82293 L .313 .8282 L 0 .366 .973 r
F
.29422 .30361 m .27044 .82949 L .27553 .82293 L 0 .224 .596 r
F
.61908 .28727 m .64519 .30288 L .6127 .29596 L 0 .954 .416 r
F
.61908 .28727 m .65171 .29425 L .64519 .30288 L F
.6127 .29596 m .66692 .85101 L .64519 .30288 L 0 .971 .424 r
F
.65171 .29425 m .64519 .30288 L .66692 .85101 L 0 .754 .329 r
F
.35726 .30282 m .34527 .83783 L .38255 .84305 L 0 .559 .973 r
F
.35726 .30282 m .33977 .84433 L .34527 .83783 L 0 .363 .633 r
F
.10708 .30229 m .06969 .79198 L .1079 .79736 L .019 0 .974 r
F
.11084 .29366 m .10708 .30229 L .06969 .79198 L .009 0 .452 r
F
.68287 .28646 m .70841 .30209 L .67616 .29517 L 0 .954 .227 r
F
.68287 .28646 m .71526 .29345 L .70841 .30209 L F
.67616 .29517 m .73737 .84548 L .70841 .30209 L 0 .971 .231 r
F
.71526 .29345 m .70841 .30209 L .73737 .84548 L 0 .772 .184 r
F
.38608 .98377 m .40543 .98327 L .4028 .98583 L .872 0 .173 r
F
.42035 .30203 m .41565 .8356 L .45262 .84082 L 0 .751 .973 r
F
.42035 .30203 m .40975 .84211 L .41565 .8356 L 0 .514 .665 r
F
.56281 .98456 m .58946 .99377 L .55672 .98969 L .871 0 .69 r
F
.56281 .98456 m .5957 .98868 L .58946 .99377 L F
.17007 .3015 m .13836 .8067 L .17639 .81203 L 0 .173 .974 r
F
.17416 .29286 m .17007 .3015 L .13836 .8067 L 0 .09 .506 r
F
.74673 .28566 m .77169 .3013 L .73969 .29438 L 0 .954 .038 r
F
.74673 .28566 m .77887 .29266 L .77169 .3013 L F
.74673 .28566 m .77169 .3013 L .73969 .29438 L F
.74673 .28566 m .77887 .29266 L .77169 .3013 L F
.4835 .30124 m .48612 .84648 L .52288 .85167 L 0 .943 .972 r
F
.4835 .30124 m .47981 .85295 L .48612 .84648 L 0 .673 .694 r
F
.23313 .30071 m .20795 .81257 L .24574 .81789 L 0 .366 .974 r
F
.23754 .29206 m .23313 .30071 L .20795 .81257 L 0 .208 .554 r
F
.14543 .30059 m .1079 .79736 L .11205 .79065 L .01 0 .485 r
F
.11084 .29366 m .11205 .79065 L .14543 .30059 L .019 0 .974 r
F
.54671 .30046 m .55677 .84589 L .59322 .85108 L 0 .972 .809 r
F
.54671 .30046 m .55005 .85236 L .55677 .84589 L 0 .719 .598 r
F
.27553 .82293 m .30773 .8347 L .27044 .82949 L 0 .332 .882 r
F
.27553 .82293 m .313 .8282 L .30773 .8347 L F
.29624 .29992 m .27753 .82581 L .31512 .83108 L 0 .559 .973 r
F
.30098 .29127 m .29624 .29992 L .27753 .82581 L 0 .342 .596 r
F
.20851 .2998 m .17639 .81203 L .18095 .80538 L 0 .095 .535 r
F
.17416 .29286 m .18095 .80538 L .20851 .2998 L 0 .173 .974 r
F
.60998 .29967 m .62765 .85023 L .66383 .85542 L 0 .971 .616 r
F
.60998 .29967 m .62052 .85669 L .62765 .85023 L 0 .742 .47 r
F
.35941 .29913 m .3478 .82766 L .38512 .83292 L 0 .751 .973 r
F
.36448 .29047 m .35941 .29913 L .3478 .82766 L 0 .488 .633 r
F
.27164 .29901 m .24574 .81789 L .25069 .81126 L 0 .218 .579 r
F
.23754 .29206 m .25069 .81126 L .27164 .29901 L 0 .366 .973 r
F
.67331 .29887 m .69851 .84963 L .73439 .85483 L 0 .971 .423 r
F
.67331 .29887 m .69098 .8561 L .69851 .84963 L 0 .761 .332 r
F
.36929 .98171 m .37185 .97913 L .38608 .98377 L .872 0 .173 r
F
.38608 .98377 m .37185 .97913 L .40543 .98327 L F
.41565 .8356 m .44654 .84728 L .40975 .84211 L 0 .679 .879 r
F
.41565 .8356 m .45262 .84082 L .44654 .84728 L F
.42265 .29834 m .41811 .84264 L .45524 .84786 L 0 .943 .973 r
F
.42804 .28967 m .42265 .29834 L .41811 .84264 L 0 .645 .665 r
F
.33484 .29822 m .31512 .83108 L .32049 .8245 L 0 .355 .618 r
F
.30098 .29127 m .32049 .8245 L .33484 .29822 L 0 .559 .973 r
F
.48594 .29755 m .48884 .84122 L .52565 .84644 L 0 .972 .809 r
F
.49166 .28887 m .48594 .29755 L .48884 .84122 L 0 .694 .577 r
F
.39809 .29743 m .38512 .83292 L .39089 .82635 L 0 .504 .653 r
F
.36448 .29047 m .39089 .82635 L .39809 .29743 L 0 .751 .973 r
F
.11629 .28117 m .14713 .29689 L .11247 .28993 L 0 .17 .954 r
F
.11629 .28117 m .15111 .2882 L .14713 .29689 L F
.11247 .28993 m .11379 .78855 L .14713 .29689 L 0 .173 .974 r
F
.15111 .2882 m .14713 .29689 L .11379 .78855 L 0 .086 .485 r
F
.54929 .29676 m .5597 .84474 L .59624 .84996 L 0 .972 .616 r
F
.55534 .28807 m .54929 .29676 L .5597 .84474 L 0 .719 .456 r
F
.46141 .29663 m .45524 .84786 L .46143 .84135 L 0 .662 .683 r
F
.42804 .28967 m .46143 .84135 L .46141 .29663 L 0 .943 .972 r
F
.18008 .28036 m .21034 .2961 L .17593 .28913 L 0 .359 .954 r
F
.18008 .28036 m .21465 .2874 L .21034 .2961 L F
.17593 .28913 m .18331 .79521 L .21034 .2961 L 0 .366 .974 r
F
.21465 .2874 m .21034 .2961 L .18331 .79521 L 0 .201 .535 r
F
.6127 .29596 m .63068 .84579 L .66692 .85101 L 0 .971 .424 r
F
.61908 .28727 m .6127 .29596 L .63068 .84579 L 0 .742 .323 r
F
.52478 .29584 m .52565 .84644 L .53225 .83992 L 0 .71 .59 r
F
.49166 .28887 m .53225 .83992 L .52478 .29584 L 0 .972 .809 r
F
.24393 .27955 m .27362 .29531 L .23945 .28833 L 0 .548 .954 r
F
.24393 .27955 m .27826 .2866 L .27362 .29531 L F
.23945 .28833 m .25277 .81002 L .27362 .29531 L 0 .559 .973 r
F
.27826 .2866 m .27362 .29531 L .25277 .81002 L 0 .333 .579 r
F
.67616 .29517 m .70146 .84024 L .73737 .84548 L 0 .971 .231 r
F
.68287 .28646 m .67616 .29517 L .70146 .84024 L 0 .761 .181 r
F
.58821 .29504 m .59624 .84996 L .60325 .84344 L 0 .733 .465 r
F
.55534 .28807 m .60325 .84344 L .58821 .29504 L 0 .971 .616 r
F
.30784 .27874 m .33695 .29451 L .30303 .28753 L 0 .737 .954 r
F
.30784 .27874 m .34192 .2858 L .33695 .29451 L F
.30303 .28753 m .32285 .82002 L .33695 .29451 L 0 .751 .973 r
F
.34192 .2858 m .33695 .29451 L .32285 .82002 L 0 .477 .618 r
F
.65171 .29425 m .66692 .85101 L .67434 .84449 L 0 .754 .329 r
F
.61908 .28727 m .67434 .84449 L .65171 .29425 L 0 .971 .423 r
F
.37181 .27793 m .40035 .29371 L .36667 .28673 L 0 .925 .954 r
F
.37181 .27793 m .40564 .28499 L .40035 .29371 L F
.36667 .28673 m .3933 .82925 L .40035 .29371 L 0 .943 .973 r
F
.40564 .28499 m .40035 .29371 L .3933 .82925 L 0 .633 .653 r
F
.11084 .29366 m .07364 .78521 L .11205 .79065 L .019 0 .974 r
F
.11084 .29366 m .06969 .79198 L .07364 .78521 L .009 0 .452 r
F
.71526 .29345 m .73737 .84548 L .74519 .83894 L 0 .772 .184 r
F
.68287 .28646 m .74519 .83894 L .71526 .29345 L 0 .971 .231 r
F
.3792 .97398 m .40767 .98334 L .37402 .97919 L .872 0 .345 r
F
.3792 .97398 m .41301 .97817 L .40767 .98334 L F
.43584 .27712 m .4638 .29292 L .43037 .28592 L 0 .954 .794 r
F
.43584 .27712 m .46942 .28419 L .4638 .29292 L F
.43037 .28592 m .4641 .83441 L .4638 .29292 L 0 .972 .809 r
F
.46942 .28419 m .4638 .29292 L .4641 .83441 L 0 .683 .568 r
F
.17416 .29286 m .14271 .79998 L .18095 .80538 L 0 .173 .974 r
F
.17416 .29286 m .13836 .8067 L .14271 .79998 L 0 .09 .506 r
F
.49994 .27631 m .52731 .29212 L .49413 .28512 L 0 .954 .605 r
F
.49994 .27631 m .53327 .28338 L .52731 .29212 L F
.49413 .28512 m .53511 .83793 L .52731 .29212 L 0 .972 .616 r
F
.53327 .28338 m .52731 .29212 L .53511 .83793 L 0 .71 .45 r
F
.23754 .29206 m .21271 .80588 L .25069 .81126 L 0 .366 .973 r
F
.23754 .29206 m .20795 .81257 L .21271 .80588 L 0 .208 .554 r
F
.56409 .2755 m .59089 .29132 L .55795 .28432 L 0 .954 .416 r
F
.56409 .2755 m .59717 .28258 L .59089 .29132 L F
.55795 .28432 m .60621 .83815 L .59089 .29132 L 0 .971 .424 r
F
.59717 .28258 m .59089 .29132 L .60621 .83815 L 0 .733 .32 r
F
.63565 .96823 m .66178 .97765 L .62914 .97348 L .709 0 .873 r
F
.63565 .96823 m .66843 .97244 L .66178 .97765 L F
.30098 .29127 m .2827 .81917 L .32049 .8245 L 0 .559 .973 r
F
.30098 .29127 m .27753 .82581 L .2827 .81917 L 0 .342 .596 r
F
.6283 .27468 m .65452 .29053 L .62183 .28351 L 0 .954 .227 r
F
.6283 .27468 m .66114 .28177 L .65452 .29053 L F
.62183 .28351 m .6772 .83341 L .65452 .29053 L 0 .971 .231 r
F
.66114 .28177 m .65452 .29053 L .6772 .83341 L 0 .754 .179 r
F
.36448 .29047 m .35339 .82102 L .39089 .82635 L 0 .751 .973 r
F
.36448 .29047 m .3478 .82766 L .35339 .82102 L 0 .488 .633 r
F
.57159 .97483 m .59833 .9842 L .5654 .98005 L .871 0 .863 r
F
.57159 .97483 m .60466 .97902 L .59833 .9842 L F
.50741 .97838 m .53475 .98771 L .50156 .98358 L .87 0 .689 r
F
.50741 .97838 m .54075 .98256 L .53475 .98771 L F
.11247 .28993 m .07529 .78309 L .11379 .78855 L 0 .173 .974 r
F
.11629 .28117 m .11247 .28993 L .07529 .78309 L 0 .08 .452 r
F
.3298 .97916 m .34927 .97864 L .34676 .98123 L .872 0 .173 r
F
.69258 .27387 m .71821 .28973 L .68577 .2827 L 0 .954 .038 r
F
.69258 .27387 m .72516 .28096 L .71821 .28973 L F
.68577 .2827 m .74894 .84273 L .71821 .28973 L 0 .97 .039 r
F
.72516 .28096 m .71821 .28973 L .74894 .84273 L 0 .772 .031 r
F
.42804 .28967 m .42412 .83607 L .46143 .84135 L 0 .943 .972 r
F
.42804 .28967 m .41811 .84264 L .42412 .83607 L 0 .645 .665 r
F
.17593 .28913 m .14505 .78976 L .18331 .79521 L 0 .366 .974 r
F
.18008 .28036 m .17593 .28913 L .14505 .78976 L 0 .19 .506 r
F
.75692 .27305 m .78197 .28893 L .74977 .2819 L .151 .954 0 r
F
.75692 .27305 m .78925 .28015 L .78197 .28893 L F
.75692 .27305 m .78197 .28893 L .74977 .2819 L F
.75692 .27305 m .78925 .28015 L .78197 .28893 L F
.49166 .28887 m .49525 .83463 L .53225 .83992 L 0 .972 .809 r
F
.49166 .28887 m .48884 .84122 L .49525 .83463 L 0 .694 .577 r
F
.23945 .28833 m .21469 .80462 L .25277 .81002 L 0 .559 .973 r
F
.24393 .27955 m .23945 .28833 L .21469 .80462 L 0 .318 .554 r
F
.15111 .2882 m .11379 .78855 L .11801 .78173 L 0 .086 .485 r
F
.11629 .28117 m .11801 .78173 L .15111 .2882 L 0 .173 .974 r
F
.55534 .28807 m .56653 .83817 L .60325 .84344 L 0 .971 .616 r
F
.55534 .28807 m .5597 .84474 L .56653 .83817 L 0 .719 .456 r
F
.30303 .28753 m .28499 .81466 L .32285 .82002 L 0 .751 .973 r
F
.30784 .27874 m .30303 .28753 L .28499 .81466 L 0 .46 .596 r
F
.21465 .2874 m .18331 .79521 L .18793 .78841 L 0 .201 .535 r
F
.18008 .28036 m .18793 .78841 L .21465 .2874 L 0 .366 .973 r
F
.61908 .28727 m .63792 .83922 L .67434 .84449 L 0 .971 .423 r
F
.61908 .28727 m .63068 .84579 L .63792 .83922 L 0 .742 .323 r
F
.35339 .82102 m .38512 .83292 L .3478 .82766 L 0 .68 .88 r
F
.35339 .82102 m .39089 .82635 L .38512 .83292 L F
.36667 .28673 m .35568 .82392 L .3933 .82925 L 0 .943 .973 r
F
.37181 .27793 m .36667 .28673 L .35568 .82392 L 0 .614 .633 r
F
.27826 .2866 m .25277 .81002 L .2578 .80328 L 0 .333 .579 r
F
.24393 .27955 m .2578 .80328 L .27826 .2866 L 0 .559 .973 r
F
.68287 .28646 m .70911 .83364 L .74519 .83894 L 0 .971 .231 r
F
.68287 .28646 m .70146 .84024 L .70911 .83364 L 0 .761 .181 r
F
.31278 .97707 m .31521 .97446 L .3298 .97916 L .872 0 .173 r
F
.3298 .97916 m .31521 .97446 L .34927 .97864 L F
.43037 .28592 m .42674 .82909 L .4641 .83441 L 0 .972 .809 r
F
.43584 .27712 m .43037 .28592 L .42674 .82909 L 0 .665 .554 r
F
.34192 .2858 m .32285 .82002 L .3283 .81333 L 0 .477 .618 r
F
.30784 .27874 m .3283 .81333 L .34192 .2858 L 0 .751 .973 r
F
.49413 .28512 m .49803 .83262 L .53511 .83793 L 0 .972 .616 r
F
.49994 .27631 m .49413 .28512 L .49803 .83262 L 0 .694 .44 r
F
.40564 .28499 m .3933 .82925 L .39917 .8226 L 0 .633 .653 r
F
.37181 .27793 m .39917 .8226 L .40564 .28499 L 0 .943 .972 r
F
.12182 .26849 m .15283 .28445 L .11794 .27739 L 0 .359 .954 r
F
.12182 .26849 m .15687 .27563 L .15283 .28445 L F
.11794 .27739 m .11913 .78936 L .15283 .28445 L 0 .366 .974 r
F
.15687 .27563 m .15283 .28445 L .11913 .78936 L 0 .182 .485 r
F
.55795 .28432 m .56943 .83284 L .60621 .83815 L 0 .971 .424 r
F
.56409 .2755 m .55795 .28432 L .56943 .83284 L 0 .719 .314 r
F
.46942 .28419 m .4641 .83441 L .47039 .82777 L 0 .683 .568 r
F
.43584 .27712 m .47039 .82777 L .46942 .28419 L 0 .972 .809 r
F
.18608 .26767 m .21651 .28365 L .18187 .27657 L 0 .548 .954 r
F
.18608 .26767 m .22089 .27482 L .21651 .28365 L F
.18187 .27657 m .18976 .78874 L .21651 .28365 L 0 .559 .973 r
F
.22089 .27482 m .21651 .28365 L .18976 .78874 L 0 .307 .535 r
F
.62183 .28351 m .64076 .82808 L .6772 .83341 L 0 .971 .231 r
F
.6283 .27468 m .62183 .28351 L .64076 .82808 L 0 .742 .177 r
F
.53327 .28338 m .53511 .83793 L .54181 .8313 L 0 .71 .45 r
F
.49994 .27631 m .54181 .8313 L .53327 .28338 L 0 .971 .616 r
F
.32235 .96232 m .35152 .97184 L .31743 .96762 L .873 0 .346 r
F
.32235 .96232 m .3566 .96658 L .35152 .97184 L F
.25041 .26685 m .28026 .28284 L .24586 .27576 L 0 .737 .954 r
F
.25041 .26685 m .28496 .27401 L .28026 .28284 L F
.24586 .27576 m .25966 .80859 L .28026 .28284 L 0 .751 .973 r
F
.28496 .27401 m .28026 .28284 L .25966 .80859 L 0 .447 .579 r
F
.70911 .83364 m .73737 .84548 L .70146 .84024 L 0 .877 .209 r
F
.70911 .83364 m .74519 .83894 L .73737 .84548 L F
.68577 .2827 m .71274 .83743 L .74894 .84273 L 0 .97 .039 r
F
.69258 .27387 m .68577 .2827 L .71274 .83743 L 0 .761 .03 r
F
.59717 .28258 m .60621 .83815 L .61333 .83152 L 0 .733 .32 r
F
.56409 .2755 m .61333 .83152 L .59717 .28258 L 0 .971 .423 r
F
.3148 .26603 m .34406 .28203 L .30992 .27495 L 0 .925 .954 r
F
.3148 .26603 m .3491 .27319 L .34406 .28203 L F
.30992 .27495 m .3307 .80879 L .34406 .28203 L 0 .943 .973 r
F
.3491 .27319 m .34406 .28203 L .3307 .80879 L 0 .6 .618 r
F
.66114 .28177 m .6772 .83341 L .68473 .82676 L 0 .754 .179 r
F
.6283 .27468 m .68473 .82676 L .66114 .28177 L 0 .971 .231 r
F
.37925 .26521 m .40793 .28123 L .37403 .27413 L 0 .954 .794 r
F
.37925 .26521 m .4133 .27238 L .40793 .28123 L F
.37403 .27413 m .40171 .81972 L .40793 .28123 L 0 .972 .809 r
F
.4133 .27238 m .40793 .28123 L .40171 .81972 L 0 .653 .543 r
F
.11629 .28117 m .07931 .77621 L .11801 .78173 L 0 .173 .974 r
F
.11629 .28117 m .07529 .78309 L .07931 .77621 L 0 .08 .452 r
F
.72516 .28096 m .74894 .84273 L .7569 .83611 L 0 .772 .031 r
F
.69258 .27387 m .7569 .83611 L .72516 .28096 L 0 .97 .039 r
F
.58032 .95805 m .60714 .96763 L .57406 .96339 L .709 0 .874 r
F
.58032 .95805 m .61355 .96233 L .60714 .96763 L F
.44376 .26439 m .47185 .28042 L .43821 .27332 L 0 .954 .605 r
F
.44376 .26439 m .47756 .27156 L .47185 .28042 L F
.43821 .27332 m .47311 .82573 L .47185 .28042 L 0 .972 .616 r
F
.47756 .27156 m .47185 .28042 L .47311 .82573 L 0 .683 .433 r
F
.18008 .28036 m .14947 .7829 L .18793 .78841 L 0 .366 .973 r
F
.18008 .28036 m .14505 .78976 L .14947 .7829 L 0 .19 .506 r
F
.64493 .95679 m .67115 .96638 L .63833 .96213 L .537 0 .874 r
F
.64493 .95679 m .6779 .96108 L .67115 .96638 L F
.273 .96606 m .29254 .96553 L .29017 .96817 L .873 0 .173 r
F
.51581 .96392 m .54324 .97345 L .50987 .96923 L .872 0 .864 r
F
.51581 .96392 m .54932 .96818 L .54324 .97345 L F
.50834 .26356 m .53584 .27961 L .50244 .2725 L 0 .954 .416 r
F
.50834 .26356 m .54188 .27074 L .53584 .27961 L F
.50244 .2725 m .54467 .82594 L .53584 .27961 L 0 .971 .424 r
F
.54188 .27074 m .53584 .27961 L .54467 .82594 L 0 .71 .309 r
F
.24393 .27955 m .21953 .79783 L .2578 .80328 L 0 .559 .973 r
F
.24393 .27955 m .21469 .80462 L .21953 .79783 L 0 .318 .554 r
F
.57297 .26274 m .59989 .2788 L .56674 .27169 L 0 .954 .227 r
F
.57297 .26274 m .60626 .26992 L .59989 .2788 L F
.56674 .27169 m .61626 .82367 L .59989 .2788 L 0 .971 .231 r
F
.60626 .26992 m .59989 .2788 L .61626 .82367 L 0 .733 .174 r
F
.30784 .27874 m .29025 .8079 L .3283 .81333 L 0 .751 .973 r
F
.30784 .27874 m .28499 .81466 L .29025 .8079 L 0 .46 .596 r
F
.45122 .97134 m .47927 .98081 L .44562 .97661 L .87 0 .689 r
F
.45122 .97134 m .48503 .97557 L .47927 .98081 L F
.63767 .26191 m .66399 .27799 L .6311 .27087 L 0 .954 .038 r
F
.63767 .26191 m .67071 .26911 L .66399 .27799 L F
.6311 .27087 m .68806 .82554 L .66399 .27799 L 0 .97 .039 r
F
.67071 .26911 m .66399 .27799 L .68806 .82554 L 0 .754 .03 r
F
.37181 .27793 m .36136 .8172 L .39917 .8226 L 0 .943 .972 r
F
.37181 .27793 m .35568 .82392 L .36136 .8172 L 0 .614 .633 r
F
.07931 .77621 m .11379 .78855 L .07529 .78309 L 0 .158 .889 r
F
.07931 .77621 m .11801 .78173 L .11379 .78855 L F
.11794 .27739 m .08025 .78385 L .11913 .78936 L 0 .366 .974 r
F
.12182 .26849 m .11794 .27739 L .08025 .78385 L 0 .17 .452 r
F
.70243 .26108 m .72816 .27718 L .69552 .27005 L .151 .954 0 r
F
.70243 .26108 m .73521 .26829 L .72816 .27718 L F
.69552 .27005 m .75995 .82659 L .72816 .27718 L .153 .97 0 r
F
.73521 .26829 m .72816 .27718 L .75995 .82659 L .122 .772 0 r
F
.43584 .27712 m .43284 .82239 L .47039 .82777 L 0 .972 .809 r
F
.43584 .27712 m .42674 .82909 L .43284 .82239 L 0 .665 .554 r
F
.14947 .7829 m .18793 .78841 L .18331 .79521 L 0 .334 .887 r
F
.18187 .27657 m .15119 .78321 L .18976 .78874 L 0 .559 .973 r
F
.18608 .26767 m .18187 .27657 L .15119 .78321 L 0 .29 .506 r
F
.25576 .96393 m .25805 .96127 L .273 .96606 L .873 0 .173 r
F
.273 .96606 m .25805 .96127 L .29254 .96553 L F
.76725 .26026 m .79239 .27637 L .76 .26923 L .34 .954 0 r
F
.76725 .26026 m .79978 .26747 L .79239 .27637 L F
.76725 .26026 m .79239 .27637 L .76 .26923 L F
.76725 .26026 m .79978 .26747 L .79239 .27637 L F
.49994 .27631 m .50455 .82593 L .54181 .8313 L 0 .971 .616 r
F
.49994 .27631 m .49803 .83262 L .50455 .82593 L 0 .694 .44 r
F
.21953 .79783 m .25277 .81002 L .21469 .80462 L 0 .507 .884 r
F
.21953 .79783 m .2578 .80328 L .25277 .81002 L F
.24586 .27576 m .22124 .80313 L .25966 .80859 L 0 .751 .973 r
F
.25041 .26685 m .24586 .27576 L .22124 .80313 L 0 .427 .554 r
F
.15687 .27563 m .11913 .78936 L .12342 .78248 L 0 .182 .485 r
F
.12182 .26849 m .12342 .78248 L .15687 .27563 L 0 .366 .973 r
F
.56409 .2755 m .57637 .82614 L .61333 .83152 L 0 .971 .423 r
F
.56409 .2755 m .56943 .83284 L .57637 .82614 L 0 .719 .314 r
F
.30992 .27495 m .29258 .80333 L .3307 .80879 L 0 .943 .973 r
F
.3148 .26603 m .30992 .27495 L .29258 .80333 L 0 .578 .596 r
F
.22089 .27482 m .18976 .78874 L .19446 .78184 L 0 .307 .535 r
F
.18608 .26767 m .19446 .78184 L .22089 .27482 L 0 .559 .973 r
F
.6283 .27468 m .64812 .82136 L .68473 .82676 L 0 .971 .231 r
F
.6283 .27468 m .64076 .82808 L .64812 .82136 L 0 .742 .177 r
F
.37403 .27413 m .36382 .8143 L .40171 .81972 L 0 .972 .809 r
F
.37925 .26521 m .37403 .27413 L .36382 .8143 L 0 .633 .526 r
F
.28496 .27401 m .25966 .80859 L .26478 .80178 L 0 .447 .579 r
F
.25041 .26685 m .26478 .80178 L .28496 .27401 L 0 .751 .973 r
F
.26494 .94666 m .29481 .95638 L .26029 .95207 L .875 0 .347 r
F
.26494 .94666 m .29961 .95101 L .29481 .95638 L F
.69258 .27387 m .72053 .83075 L .7569 .83611 L 0 .97 .039 r
F
.69258 .27387 m .71274 .83743 L .72053 .83075 L 0 .761 .03 r
F
.43821 .27332 m .43548 .82033 L .47311 .82573 L 0 .972 .616 r
F
.44376 .26439 m .43821 .27332 L .43548 .82033 L 0 .665 .422 r
F
.3491 .27319 m .3307 .80879 L .33624 .80198 L 0 .6 .618 r
F
.3148 .26603 m .33624 .80198 L .3491 .27319 L 0 .943 .972 r
F
.50244 .2725 m .50735 .82054 L .54467 .82594 L 0 .971 .424 r
F
.50834 .26356 m .50244 .2725 L .50735 .82054 L 0 .694 .303 r
F
.4133 .27238 m .40171 .81972 L .40768 .81295 L 0 .653 .543 r
F
.37925 .26521 m .40768 .81295 L .4133 .27238 L 0 .972 .809 r
F
.12743 .25563 m .15862 .27183 L .12349 .26466 L 0 .548 .954 r
F
.12743 .25563 m .16272 .26288 L .15862 .27183 L F
.12349 .26466 m .12571 .77295 L .15862 .27183 L 0 .559 .973 r
F
.16272 .26288 m .15862 .27183 L .12571 .77295 L 0 .278 .485 r
F
.56674 .27169 m .57926 .81825 L .61626 .82367 L 0 .971 .231 r
F
.57297 .26274 m .56674 .27169 L .57926 .81825 L 0 .719 .171 r
F
.47756 .27156 m .47311 .82573 L .4795 .81898 L 0 .683 .433 r
F
.44376 .26439 m .4795 .81898 L .47756 .27156 L 0 .971 .616 r
F
.19218 .2548 m .22278 .27101 L .1879 .26383 L 0 .737 .954 r
F
.19218 .2548 m .22722 .26205 L .22278 .27101 L F
.1879 .26383 m .19564 .79533 L .22278 .27101 L 0 .751 .973 r
F
.22722 .26205 m .22278 .27101 L .19564 .79533 L 0 .413 .535 r
F
.6311 .27087 m .65135 .82013 L .68806 .82554 L 0 .97 .039 r
F
.63767 .26191 m .6311 .27087 L .65135 .82013 L 0 .742 .03 r
F
.54188 .27074 m .54467 .82594 L .55149 .8192 L 0 .71 .309 r
F
.50834 .26356 m .55149 .8192 L .54188 .27074 L 0 .971 .423 r
F
.2156 .95127 m .23523 .95074 L .23299 .95343 L .875 0 .173 r
F
.25699 .25396 m .287 .27019 L .25237 .26301 L 0 .925 .954 r
F
.25699 .25396 m .29177 .26123 L .287 .27019 L F
.25237 .26301 m .26731 .79057 L .287 .27019 L 0 .943 .973 r
F
.29177 .26123 m .287 .27019 L .26731 .79057 L 0 .562 .579 r
F
.69552 .27005 m .72356 .82117 L .75995 .82659 L .153 .97 0 r
F
.70243 .26108 m .69552 .27005 L .72356 .82117 L .12 .761 0 r
F
.60626 .26992 m .61626 .82367 L .62349 .8169 L 0 .733 .174 r
F
.57297 .26274 m .62349 .8169 L .60626 .26992 L 0 .971 .231 r
F
.32187 .25313 m .35128 .26937 L .31691 .26218 L 0 .954 .794 r
F
.32187 .25313 m .35639 .2604 L .35128 .26937 L F
.31691 .26218 m .33867 .79738 L .35128 .26937 L 0 .972 .809 r
F
.35639 .2604 m .35128 .26937 L .33867 .79738 L 0 .618 .515 r
F
.67071 .26911 m .68806 .82554 L .69571 .81878 L 0 .754 .03 r
F
.63767 .26191 m .69571 .81878 L .67071 .26911 L 0 .97 .039 r
F
.52432 .95006 m .55184 .95977 L .5183 .95547 L .71 0 .874 r
F
.52432 .95006 m .558 .9544 L .55184 .95977 L F
.58933 .94801 m .61625 .95775 L .58297 .95344 L .537 0 .874 r
F
.58933 .94801 m .62275 .95237 L .61625 .95775 L F
.3868 .2523 m .41562 .26855 L .3815 .26136 L 0 .954 .605 r
F
.3868 .2523 m .42107 .25957 L .41562 .26855 L F
.3815 .26136 m .41029 .8067 L .41562 .26855 L 0 .972 .616 r
F
.42107 .25957 m .41562 .26855 L .41029 .8067 L 0 .653 .414 r
F
.12182 .26849 m .08434 .7769 L .12342 .78248 L 0 .366 .973 r
F
.12182 .26849 m .08025 .78385 L .08434 .7769 L 0 .17 .452 r
F
.73521 .26829 m .75995 .82659 L .76804 .81983 L .122 .772 0 r
F
.70243 .26108 m .76804 .81983 L .73521 .26829 L .153 .97 0 r
F
.45933 .95674 m .48748 .9664 L .45365 .96212 L .872 0 .864 r
F
.45933 .95674 m .49331 .96106 L .48748 .9664 L F
.4518 .25146 m .48003 .26773 L .44616 .26053 L 0 .954 .416 r
F
.4518 .25146 m .48582 .25874 L .48003 .26773 L F
.44616 .26053 m .48226 .8144 L .48003 .26773 L 0 .971 .424 r
F
.48582 .25874 m .48003 .26773 L .48226 .8144 L 0 .683 .298 r
F
.18608 .26767 m .15569 .77626 L .19446 .78184 L 0 .559 .973 r
F
.18608 .26767 m .15119 .78321 L .15569 .77626 L 0 .29 .506 r
F
.19815 .9491 m .20031 .94639 L .2156 .95127 L .875 0 .173 r
F
.2156 .95127 m .20031 .94639 L .23523 .95074 L F
.51687 .25062 m .54449 .26691 L .51088 .2597 L 0 .954 .227 r
F
.51687 .25062 m .55062 .25791 L .54449 .26691 L F
.51088 .2597 m .55435 .8121 L .54449 .26691 L 0 .971 .231 r
F
.55062 .25791 m .54449 .26691 L .55435 .8121 L 0 .71 .169 r
F
.39426 .96265 m .42303 .97226 L .38892 .96801 L .871 0 .69 r
F
.39426 .96265 m .42853 .96695 L .42303 .97226 L F
.25041 .26685 m .22616 .79626 L .26478 .80178 L 0 .751 .973 r
F
.25041 .26685 m .22124 .80313 L .22616 .79626 L 0 .427 .554 r
F
.58199 .24979 m .60902 .26609 L .57566 .25887 L 0 .954 .038 r
F
.58199 .24979 m .61549 .25708 L .60902 .26609 L F
.57566 .25887 m .6268 .81984 L .60902 .26609 L 0 .97 .039 r
F
.61549 .25708 m .60902 .26609 L .6268 .81984 L 0 .733 .029 r
F
.3148 .26603 m .29792 .79645 L .33624 .80198 L 0 .943 .972 r
F
.3148 .26603 m .29258 .80333 L .29792 .79645 L 0 .578 .596 r
F
.64718 .24895 m .67361 .26527 L .64051 .25804 L .151 .954 0 r
F
.64718 .24895 m .68042 .25625 L .67361 .26527 L F
.64051 .25804 m .69906 .8167 L .67361 .26527 L .153 .97 0 r
F
.68042 .25625 m .67361 .26527 L .69906 .8167 L .119 .754 0 r
F
.37925 .26521 m .36959 .80747 L .40768 .81295 L 0 .972 .809 r
F
.37925 .26521 m .36382 .8143 L .36959 .80747 L 0 .633 .526 r
F
.12349 .26466 m .08659 .76732 L .12571 .77295 L 0 .559 .973 r
F
.12743 .25563 m .12349 .26466 L .08659 .76732 L 0 .259 .452 r
F
.20687 .9316 m .23745 .94152 L .20251 .93713 L .877 0 .347 r
F
.20687 .9316 m .24198 .93604 L .23745 .94152 L F
.71243 .24811 m .73826 .26445 L .70541 .25721 L .34 .954 0 r
F
.71243 .24811 m .74542 .25542 L .73826 .26445 L F
.70541 .25721 m .77148 .81607 L .73826 .26445 L .345 .97 0 r
F
.74542 .25542 m .73826 .26445 L .77148 .81607 L .275 .772 0 r
F
.44376 .26439 m .44168 .81352 L .4795 .81898 L 0 .971 .616 r
F
.44376 .26439 m .43548 .82033 L .44168 .81352 L 0 .665 .422 r
F
.14947 .7829 m .18331 .79521 L .14505 .78976 L 0 .334 .887 r
F
.15569 .77626 m .18976 .78874 L .15119 .78321 L 0 .509 .886 r
F
.15569 .77626 m .19446 .78184 L .18976 .78874 L F
.1879 .26383 m .15665 .78978 L .19564 .79533 L 0 .751 .973 r
F
.19218 .2548 m .1879 .26383 L .15665 .78978 L 0 .391 .506 r
F
.77774 .24727 m .80297 .26362 L .77038 .25638 L .529 .954 0 r
F
.77774 .24727 m .81047 .25459 L .80297 .26362 L F
.77038 .25638 m .84267 .79792 L .80297 .26362 L .537 .969 0 r
F
.81047 .25459 m .80297 .26362 L .84267 .79792 L .437 .789 0 r
F
.50834 .26356 m .51397 .81373 L .55149 .8192 L 0 .971 .423 r
F
.50834 .26356 m .50735 .82054 L .51397 .81373 L 0 .694 .303 r
F
.25237 .26301 m .22867 .785 L .26731 .79057 L 0 .943 .973 r
F
.25699 .25396 m .25237 .26301 L .22867 .785 L 0 .537 .554 r
F
.16272 .26288 m .12571 .77295 L .13007 .76592 L 0 .278 .485 r
F
.12743 .25563 m .13007 .76592 L .16272 .26288 L 0 .559 .973 r
F
.57297 .26274 m .58631 .81142 L .62349 .8169 L 0 .971 .231 r
F
.57297 .26274 m .57926 .81825 L .58631 .81142 L 0 .719 .171 r
F
.31691 .26218 m .30029 .79182 L .33867 .79738 L 0 .972 .809 r
F
.32187 .25313 m .31691 .26218 L .30029 .79182 L 0 .596 .496 r
F
.22722 .26205 m .19564 .79533 L .20043 .7884 L 0 .413 .535 r
F
.19218 .2548 m .20043 .7884 L .22722 .26205 L 0 .751 .973 r
F
.63767 .26191 m .65883 .8133 L .69571 .81878 L 0 .97 .039 r
F
.63767 .26191 m .65135 .82013 L .65883 .8133 L 0 .742 .03 r
F
.3815 .26136 m .37214 .80117 L .41029 .8067 L 0 .972 .616 r
F
.3868 .2523 m .3815 .26136 L .37214 .80117 L 0 .633 .401 r
F
.29177 .26123 m .26731 .79057 L .27252 .78361 L 0 .562 .579 r
F
.25699 .25396 m .27252 .78361 L .29177 .26123 L 0 .943 .972 r
F
.15757 .93632 m .17728 .93577 L .17517 .93852 L .877 0 .174 r
F
.70243 .26108 m .73146 .81435 L .76804 .81983 L .153 .97 0 r
F
.70243 .26108 m .72356 .82117 L .73146 .81435 L .12 .761 0 r
F
.44616 .26053 m .44437 .8089 L .48226 .8144 L 0 .971 .424 r
F
.4518 .25146 m .44616 .26053 L .44437 .8089 L 0 .665 .29 r
F
.35639 .2604 m .33867 .79738 L .3443 .79044 L 0 .618 .515 r
F
.32187 .25313 m .3443 .79044 L .35639 .2604 L 0 .972 .809 r
F
.51088 .2597 m .51679 .80659 L .55435 .8121 L 0 .971 .231 r
F
.51687 .25062 m .51088 .2597 L .51679 .80659 L 0 .694 .165 r
F
.42107 .25957 m .41029 .8067 L .41635 .7998 L 0 .653 .414 r
F
.3868 .2523 m .41635 .7998 L .42107 .25957 L 0 .971 .616 r
F
.13312 .24257 m .16449 .25901 L .12913 .25173 L 0 .737 .954 r
F
.13312 .24257 m .16866 .24993 L .16449 .25901 L F
.12913 .25173 m .13062 .78355 L .16449 .25901 L 0 .751 .973 r
F
.16866 .24993 m .16449 .25901 L .13062 .78355 L 0 .374 .485 r
F
.58631 .81142 m .61626 .82367 L .57926 .81825 L 0 .878 .209 r
F
.58631 .81142 m .62349 .8169 L .61626 .82367 L F
.57566 .25887 m .5895 .81435 L .6268 .81984 L 0 .97 .039 r
F
.58199 .24979 m .57566 .25887 L .5895 .81435 L 0 .719 .029 r
F
.48582 .25874 m .48226 .8144 L .48876 .80753 L 0 .683 .298 r
F
.4518 .25146 m .48876 .80753 L .48582 .25874 L 0 .971 .423 r
F
.19836 .24173 m .22913 .25818 L .19402 .2509 L 0 .925 .954 r
F
.19836 .24173 m .23364 .24909 L .22913 .25818 L F
.19402 .2509 m .20346 .76635 L .22913 .25818 L 0 .943 .973 r
F
.23364 .24909 m .22913 .25818 L .20346 .76635 L 0 .519 .535 r
F
.64051 .25804 m .6621 .8112 L .69906 .8167 L .153 .97 0 r
F
.64718 .24895 m .64051 .25804 L .6621 .8112 L .117 .742 0 r
F
.55062 .25791 m .55435 .8121 L .56128 .80522 L 0 .71 .169 r
F
.51687 .25062 m .56128 .80522 L .55062 .25791 L 0 .971 .231 r
F
.1399 .93411 m .14192 .93134 L .15757 .93632 L .877 0 .174 r
F
.15757 .93632 m .14192 .93134 L .17728 .93577 L F
.26367 .24088 m .29384 .25735 L .25898 .25006 L 0 .954 .794 r
F
.26367 .24088 m .29868 .24825 L .29384 .25735 L F
.25898 .25006 m .27483 .77894 L .29384 .25735 L 0 .972 .809 r
F
.29868 .24825 m .29384 .25735 L .27483 .77894 L 0 .579 .482 r
F
.70541 .25721 m .73483 .81056 L .77148 .81607 L .345 .97 0 r
F
.71243 .24811 m .70541 .25721 L .73483 .81056 L .271 .761 0 r
F
.46754 .94195 m .49578 .95181 L .46178 .94745 L .71 0 .874 r
F
.46754 .94195 m .50169 .94636 L .49578 .95181 L F
.61549 .25708 m .6268 .81984 L .63416 .81298 L 0 .733 .029 r
F
.58199 .24979 m .63416 .81298 L .61549 .25708 L 0 .97 .039 r
F
.53299 .93989 m .56062 .94977 L .52688 .9454 L .537 0 .874 r
F
.53299 .93989 m .56688 .94431 L .56062 .94977 L F
.40208 .94634 m .43095 .95616 L .39667 .95181 L .873 0 .864 r
F
.40208 .94634 m .43653 .95073 L .43095 .95616 L F
.32904 .24004 m .3586 .25652 L .32401 .24922 L 0 .954 .605 r
F
.32904 .24004 m .36379 .24741 L .3586 .25652 L F
.32401 .24922 m .34687 .78162 L .3586 .25652 L 0 .972 .616 r
F
.36379 .24741 m .3586 .25652 L .34687 .78162 L 0 .618 .392 r
F
.77038 .25638 m .80647 .79234 L .84267 .79792 L .537 .969 0 r
F
.77774 .24727 m .77038 .25638 L .80647 .79234 L .432 .779 0 r
F
.3366 .95073 m .36609 .96051 L .33153 .95618 L .872 0 .691 r
F
.3366 .95073 m .37133 .95511 L .36609 .96051 L F
.68042 .25625 m .69906 .8167 L .70685 .80983 L .119 .754 0 r
F
.64718 .24895 m .70685 .80983 L .68042 .25625 L .153 .97 0 r
F
.39447 .23919 m .42343 .25569 L .38909 .24838 L 0 .954 .416 r
F
.39447 .23919 m .42897 .24657 L .42343 .25569 L F
.38909 .24838 m .419 .79431 L .42343 .25569 L 0 .971 .424 r
F
.42897 .24657 m .42343 .25569 L .419 .79431 L 0 .653 .285 r
F
.12743 .25563 m .09074 .76022 L .13007 .76592 L 0 .559 .973 r
F
.12743 .25563 m .08659 .76732 L .09074 .76022 L 0 .259 .452 r
F
.74542 .25542 m .77148 .81607 L .77969 .8092 L .275 .772 0 r
F
.71243 .24811 m .77969 .8092 L .74542 .25542 L .345 .969 0 r
F
.14816 .91638 m .17946 .92649 L .14407 .92201 L .879 0 .348 r
F
.14816 .91638 m .18371 .9209 L .17946 .92649 L F
.45996 .23834 m .48832 .25486 L .45424 .24754 L 0 .954 .227 r
F
.45996 .23834 m .4942 .24573 L .48832 .25486 L F
.45424 .24754 m .49154 .80121 L .48832 .25486 L 0 .971 .231 r
F
.4942 .24573 m .48832 .25486 L .49154 .80121 L 0 .683 .163 r
F
.19218 .2548 m .16123 .78278 L .20043 .7884 L 0 .751 .973 r
F
.19218 .2548 m .15665 .78978 L .16123 .78278 L 0 .391 .506 r
F
.81047 .25459 m .84267 .79792 L .85128 .79096 L .437 .789 0 r
F
.77774 .24727 m .85128 .79096 L .81047 .25459 L .537 .969 0 r
F
.52552 .23749 m .55327 .25403 L .51945 .2467 L 0 .954 .038 r
F
.52552 .23749 m .5595 .24489 L .55327 .25403 L F
.51945 .2467 m .5643 .80393 L .55327 .25403 L 0 .97 .039 r
F
.5595 .24489 m .55327 .25403 L .5643 .80393 L 0 .71 .028 r
F
.25699 .25396 m .23367 .77797 L .27252 .78361 L 0 .943 .972 r
F
.25699 .25396 m .22867 .785 L .23367 .77797 L 0 .537 .554 r
F
.59114 .23664 m .61829 .25319 L .58472 .24586 L .151 .954 0 r
F
.59114 .23664 m .62486 .24405 L .61829 .25319 L F
.58472 .24586 m .6372 .80581 L .61829 .25319 L .153 .97 0 r
F
.62486 .24405 m .61829 .25319 L .6372 .80581 L .116 .733 0 r
F
.32187 .25313 m .30572 .78482 L .3443 .79044 L 0 .972 .809 r
F
.32187 .25313 m .30029 .79182 L .30572 .78482 L 0 .596 .496 r
F
.65683 .23579 m .68337 .25236 L .65006 .24502 L .34 .954 0 r
F
.65683 .23579 m .69028 .2432 L .68337 .25236 L F
.65006 .24502 m .71009 .80434 L .68337 .25236 L .345 .97 0 r
F
.69028 .2432 m .68337 .25236 L .71009 .80434 L .268 .754 0 r
F
.3868 .2523 m .37801 .79421 L .41635 .7998 L 0 .971 .616 r
F
.3868 .2523 m .37214 .80117 L .37801 .79421 L 0 .633 .401 r
F
.08434 .7769 m .12342 .78248 L .11913 .78936 L 0 .333 .886 r
F
.09074 .76022 m .12571 .77295 L .08659 .76732 L 0 .51 .888 r
F
.09074 .76022 m .13007 .76592 L .12571 .77295 L F
.12913 .25173 m .09104 .7779 L .13062 .78355 L 0 .751 .973 r
F
.13312 .24257 m .12913 .25173 L .09104 .7779 L 0 .349 .452 r
F
.6645 .94977 m .69098 .95959 L .65769 .95524 L .19 0 .872 r
F
.6645 .94977 m .69794 .95416 L .69098 .95959 L F
.72258 .23494 m .74851 .25152 L .71546 .24418 L .529 .954 0 r
F
.72258 .23494 m .75577 .24236 L .74851 .25152 L F
.71546 .24418 m .78198 .78608 L .74851 .25152 L .537 .969 0 r
F
.75577 .24236 m .74851 .25152 L .78198 .78608 L .428 .772 0 r
F
.4518 .25146 m .45067 .80197 L .48876 .80753 L 0 .971 .423 r
F
.4518 .25146 m .44437 .8089 L .45067 .80197 L 0 .665 .29 r
F
.19402 .2509 m .16433 .76064 L .20346 .76635 L 0 .943 .973 r
F
.19836 .24173 m .19402 .2509 L .16433 .76064 L 0 .491 .506 r
F
.78839 .23408 m .81371 .25068 L .78092 .24334 L .717 .954 0 r
F
.78839 .23408 m .82132 .24151 L .81371 .25068 L F
.78839 .23408 m .81371 .25068 L .78092 .24334 L F
.78839 .23408 m .82132 .24151 L .81371 .25068 L F
.51687 .25062 m .52353 .79965 L .56128 .80522 L 0 .971 .231 r
F
.51687 .25062 m .51679 .80659 L .52353 .79965 L 0 .694 .165 r
F
.25898 .25006 m .23591 .77327 L .27483 .77894 L 0 .972 .809 r
F
.26367 .24088 m .25898 .25006 L .23591 .77327 L 0 .554 .461 r
F
.16866 .24993 m .13062 .78355 L .13506 .7765 L 0 .374 .485 r
F
.13312 .24257 m .13506 .7765 L .16866 .24993 L 0 .751 .973 r
F
.58199 .24979 m .59668 .80743 L .63416 .81298 L 0 .97 .039 r
F
.58199 .24979 m .5895 .81435 L .59668 .80743 L 0 .719 .029 r
F
.32401 .24922 m .30824 .77595 L .34687 .78162 L 0 .972 .616 r
F
.32904 .24004 m .32401 .24922 L .30824 .77595 L 0 .596 .378 r
F
.23364 .24909 m .20346 .76635 L .20832 .75922 L 0 .519 .535 r
F
.19836 .24173 m .20832 .75922 L .23364 .24909 L 0 .943 .972 r
F
.64718 .24895 m .6697 .80426 L .70685 .80983 L .153 .97 0 r
F
.64718 .24895 m .6621 .8112 L .6697 .80426 L .117 .742 0 r
F
.38909 .24838 m .38059 .78869 L .419 .79431 L 0 .971 .424 r
F
.39447 .23919 m .38909 .24838 L .38059 .78869 L 0 .633 .276 r
F
.29868 .24825 m .27483 .77894 L .28012 .77186 L 0 .579 .482 r
F
.26367 .24088 m .28012 .77186 L .29868 .24825 L 0 .972 .809 r
F
.71243 .24811 m .74287 .80362 L .77969 .8092 L .345 .969 0 r
F
.71243 .24811 m .73483 .81056 L .74287 .80362 L .271 .761 0 r
F
.45424 .24754 m .4534 .7956 L .49154 .80121 L 0 .971 .231 r
F
.45996 .23834 m .45424 .24754 L .4534 .7956 L 0 .665 .158 r
F
.36379 .24741 m .34687 .78162 L .35259 .77454 L 0 .618 .392 r
F
.32904 .24004 m .35259 .77454 L .36379 .24741 L 0 .971 .616 r
F
.77774 .24727 m .8149 .78531 L .85128 .79096 L .537 .969 0 r
F
.77774 .24727 m .80647 .79234 L .8149 .78531 L .432 .779 0 r
F
.51945 .2467 m .52646 .79833 L .5643 .80393 L 0 .97 .039 r
F
.52552 .23749 m .51945 .2467 L .52646 .79833 L 0 .694 .028 r
F
.42897 .24657 m .419 .79431 L .42516 .78729 L 0 .653 .285 r
F
.39447 .23919 m .42516 .78729 L .42897 .24657 L 0 .971 .423 r
F
.34413 .93425 m .37373 .94424 L .33898 .93982 L .874 0 .865 r
F
.34413 .93425 m .37903 .93872 L .37373 .94424 L F
.1389 .22932 m .17045 .24601 L .13485 .23862 L 0 .925 .954 r
F
.1389 .22932 m .17468 .23678 L .17045 .24601 L F
.13485 .23862 m .13877 .7452 L .17045 .24601 L 0 .943 .973 r
F
.17468 .23678 m .17045 .24601 L .13877 .7452 L 0 .471 .485 r
F
.58472 .24586 m .59966 .80022 L .6372 .80581 L .153 .97 0 r
F
.59114 .23664 m .58472 .24586 L .59966 .80022 L .114 .719 0 r
F
.4942 .24573 m .49154 .80121 L .49815 .79421 L 0 .683 .163 r
F
.45996 .23834 m .49815 .79421 L .4942 .24573 L 0 .971 .231 r
F
.27819 .93944 m .30843 .9494 L .2734 .94499 L .873 0 .691 r
F
.27819 .93944 m .31339 .9439 L .30843 .9494 L F
.20464 .22846 m .23558 .24516 L .20024 .23777 L 0 .954 .794 r
F
.20464 .22846 m .24016 .23593 L .23558 .24516 L F
.20024 .23777 m .21066 .75116 L .23558 .24516 L 0 .972 .809 r
F
.24016 .23593 m .23558 .24516 L .21066 .75116 L 0 .535 .445 r
F
.65006 .24502 m .67288 .79873 L .71009 .80434 L .345 .97 0 r
F
.65683 .23579 m .65006 .24502 L .67288 .79873 L .264 .742 0 r
F
.40996 .93451 m .43895 .94452 L .40446 .94009 L .71 0 .874 r
F
.40996 .93451 m .4446 .93899 L .43895 .94452 L F
.5595 .24489 m .5643 .80393 L .57134 .79694 L 0 .71 .028 r
F
.52552 .23749 m .57134 .79694 L .5595 .24489 L 0 .97 .039 r
F
.47586 .93244 m .50423 .94246 L .47002 .93802 L .537 0 .874 r
F
.47586 .93244 m .51023 .93692 L .50423 .94246 L F
.27045 .2276 m .30078 .24432 L .26569 .23692 L 0 .954 .605 r
F
.27045 .2276 m .3057 .23508 L .30078 .24432 L F
.26569 .23692 m .2827 .76046 L .30078 .24432 L 0 .972 .616 r
F
.3057 .23508 m .30078 .24432 L .2827 .76046 L 0 .579 .367 r
F
.08856 .90409 m .12062 .91438 L .08477 .90982 L .88 0 .349 r
F
.08856 .90409 m .12459 .90869 L .12062 .91438 L F
.71546 .24418 m .74523 .78041 L .78198 .78608 L .537 .969 0 r
F
.72258 .23494 m .71546 .24418 L .74523 .78041 L .422 .761 0 r
F
.62486 .24405 m .6372 .80581 L .64468 .79883 L .116 .733 0 r
F
.59114 .23664 m .64468 .79883 L .62486 .24405 L .153 .97 0 r
F
.33632 .22674 m .36604 .24348 L .33121 .23607 L 0 .954 .416 r
F
.33632 .22674 m .37131 .23423 L .36604 .24348 L F
.33121 .23607 m .35487 .7807 L .36604 .24348 L 0 .971 .424 r
F
.37131 .23423 m .36604 .24348 L .35487 .7807 L 0 .618 .27 r
F
.69028 .2432 m .71009 .80434 L .718 .79734 L .268 .754 0 r
F
.65683 .23579 m .718 .79734 L .69028 .2432 L .345 .969 0 r
F
.40225 .22588 m .43136 .24263 L .39679 .23522 L 0 .954 .227 r
F
.40225 .22588 m .43698 .23338 L .43136 .24263 L F
.39679 .23522 m .42782 .7851 L .43136 .24263 L 0 .971 .231 r
F
.43698 .23338 m .43136 .24263 L .42782 .7851 L 0 .653 .155 r
F
.13312 .24257 m .09527 .77078 L .13506 .7765 L 0 .751 .973 r
F
.13312 .24257 m .09104 .7779 L .09527 .77078 L 0 .349 .452 r
F
.75577 .24236 m .78198 .78608 L .7903 .779 L .428 .772 0 r
F
.72258 .23494 m .7903 .779 L .75577 .24236 L .537 .969 0 r
F
.46825 .22502 m .49674 .24179 L .46244 .23436 L 0 .954 .038 r
F
.46825 .22502 m .50271 .23252 L .49674 .24179 L F
.46244 .23436 m .50101 .79203 L .49674 .24179 L 0 .97 .039 r
F
.50271 .23252 m .49674 .24179 L .50101 .79203 L 0 .683 .027 r
F
.19836 .24173 m .16898 .75344 L .20832 .75922 L 0 .943 .972 r
F
.19836 .24173 m .16433 .76064 L .16898 .75344 L 0 .491 .506 r
F
.53431 .22416 m .56219 .24094 L .52814 .23351 L .151 .954 0 r
F
.53431 .22416 m .56851 .23167 L .56219 .24094 L F
.52814 .23351 m .57435 .79223 L .56219 .24094 L .153 .97 0 r
F
.56851 .23167 m .56219 .24094 L .57435 .79223 L .112 .71 0 r
F
.26367 .24088 m .241 .76612 L .28012 .77186 L 0 .972 .809 r
F
.26367 .24088 m .23591 .77327 L .241 .76612 L 0 .554 .461 r
F
.60806 .93923 m .63524 .94921 L .6015 .94479 L .19 0 .872 r
F
.60806 .93923 m .64195 .9437 L .63524 .94921 L F
.60044 .22329 m .6277 .2401 L .59392 .23266 L .34 .954 0 r
F
.60044 .22329 m .63437 .23081 L .6277 .2401 L F
.59392 .23266 m .64785 .79412 L .6277 .2401 L .345 .97 0 r
F
.63437 .23081 m .6277 .2401 L .64785 .79412 L .261 .733 0 r
F
.32904 .24004 m .31376 .76881 L .35259 .77454 L 0 .971 .616 r
F
.32904 .24004 m .30824 .77595 L .31376 .76881 L 0 .596 .378 r
F
.66663 .22243 m .69327 .23925 L .65975 .2318 L .529 .954 0 r
F
.66663 .22243 m .70029 .22996 L .69327 .23925 L F
.65975 .2318 m .7204 .77407 L .69327 .23925 L .537 .969 0 r
F
.70029 .22996 m .69327 .23925 L .7204 .77407 L .418 .754 0 r
F
.39447 .23919 m .38655 .7816 L .42516 .78729 L 0 .971 .423 r
F
.39447 .23919 m .38059 .78869 L .38655 .7816 L 0 .633 .276 r
F
.13485 .23862 m .09912 .73936 L .13877 .7452 L 0 .943 .973 r
F
.1389 .22932 m .13485 .23862 L .09912 .73936 L 0 .438 .452 r
F
.73289 .22156 m .75891 .2384 L .72566 .23095 L .717 .954 0 r
F
.73289 .22156 m .76629 .2291 L .75891 .2384 L F
.72566 .23095 m .79422 .78099 L .75891 .2384 L .728 .968 0 r
F
.76629 .2291 m .75891 .2384 L .79422 .78099 L .581 .772 0 r
F
.45996 .23834 m .45981 .78854 L .49815 .79421 L 0 .971 .231 r
F
.45996 .23834 m .4534 .7956 L .45981 .78854 L 0 .665 .158 r
F
.20024 .23777 m .17127 .74533 L .21066 .75116 L 0 .972 .809 r
F
.20464 .22846 m .20024 .23777 L .17127 .74533 L 0 .506 .421 r
F
.79921 .2207 m .82461 .23755 L .79162 .23009 L .906 .954 0 r
F
.79921 .2207 m .83234 .22824 L .82461 .23755 L F
.79162 .23009 m .86848 .78963 L .82461 .23755 L .92 .968 0 r
F
.83234 .22824 m .82461 .23755 L .86848 .78963 L .749 .789 0 r
F
.52552 .23749 m .53331 .79127 L .57134 .79694 L 0 .97 .039 r
F
.52552 .23749 m .52646 .79833 L .53331 .79127 L 0 .694 .028 r
F
.28563 .91653 m .31594 .92674 L .28077 .92222 L .877 0 .868 r
F
.28563 .91653 m .32096 .9211 L .31594 .92674 L F
.26569 .23692 m .24355 .75466 L .2827 .76046 L 0 .972 .616 r
F
.27045 .2276 m .26569 .23692 L .24355 .75466 L 0 .554 .351 r
F
.17468 .23678 m .13877 .7452 L .14328 .7379 L 0 .471 .485 r
F
.1389 .22932 m .14328 .7379 L .17468 .23678 L 0 .943 .972 r
F
.59114 .23664 m .60696 .79317 L .64468 .79883 L .153 .97 0 r
F
.59114 .23664 m .59966 .80022 L .60696 .79317 L .114 .719 0 r
F
.31376 .76881 m .34687 .78162 L .30824 .77595 L 0 .883 .56 r
F
.31376 .76881 m .35259 .77454 L .34687 .78162 L F
.33121 .23607 m .31588 .77497 L .35487 .7807 L 0 .971 .424 r
F
.33632 .22674 m .33121 .23607 L .31588 .77497 L 0 .596 .26 r
F
.24016 .23593 m .21066 .75116 L .2156 .74388 L 0 .535 .445 r
F
.20464 .22846 m .2156 .74388 L .24016 .23593 L 0 .972 .809 r
F
.21925 .92331 m .25022 .93347 L .21475 .92897 L .875 0 .693 r
F
.21925 .92331 m .2549 .92786 L .25022 .93347 L F
.65683 .23579 m .68061 .79167 L .718 .79734 L .345 .969 0 r
F
.65683 .23579 m .67288 .79873 L .68061 .79167 L .264 .742 0 r
F
.39679 .23522 m .38912 .77938 L .42782 .7851 L 0 .971 .231 r
F
.40225 .22588 m .39679 .23522 L .38912 .77938 L 0 .633 .151 r
F
.3057 .23508 m .2827 .76046 L .28807 .75322 L 0 .579 .367 r
F
.27045 .2276 m .28807 .75322 L .3057 .23508 L 0 .971 .616 r
F
.72258 .23494 m .75336 .77325 L .7903 .779 L .537 .969 0 r
F
.72258 .23494 m .74523 .78041 L .75336 .77325 L .422 .761 0 r
F
.02847 .88852 m .06128 .89902 L .02498 .89438 L .882 0 .349 r
F
.02847 .88852 m .06496 .89322 L .06128 .89902 L F
.46244 .23436 m .46258 .78633 L .50101 .79203 L 0 .97 .039 r
F
.46825 .22502 m .46244 .23436 L .46258 .78633 L 0 .665 .027 r
F
.37131 .23423 m .35487 .7807 L .36069 .77355 L 0 .618 .27 r
F
.33632 .22674 m .36069 .77355 L .37131 .23423 L 0 .971 .423 r
F
.35165 .92227 m .38138 .93244 L .34643 .92794 L .711 0 .875 r
F
.35165 .92227 m .38676 .92682 L .38138 .93244 L F
.41795 .92096 m .44706 .93115 L .41238 .92664 L .537 0 .875 r
F
.41795 .92096 m .45279 .92552 L .44706 .93115 L F
.52814 .23351 m .53624 .78653 L .57435 .79223 L .153 .97 0 r
F
.53431 .22416 m .52814 .23351 L .53624 .78653 L .11 .694 0 r
F
.43698 .23338 m .42782 .7851 L .43409 .77796 L 0 .653 .155 r
F
.40225 .22588 m .43409 .77796 L .43698 .23338 L 0 .971 .231 r
F
.14477 .21586 m .17651 .2328 L .14065 .2253 L 0 .954 .794 r
F
.14477 .21586 m .1808 .22344 L .17651 .2328 L F
.14065 .2253 m .14486 .74058 L .17651 .2328 L 0 .972 .809 r
F
.1808 .22344 m .17651 .2328 L .14486 .74058 L 0 .485 .404 r
F
.59392 .23266 m .61006 .78842 L .64785 .79412 L .345 .97 0 r
F
.60044 .22329 m .59392 .23266 L .61006 .78842 L .256 .719 0 r
F
.50271 .23252 m .50101 .79203 L .50773 .78492 L 0 .683 .027 r
F
.46825 .22502 m .50773 .78492 L .50271 .23252 L 0 .97 .039 r
F
.21102 .21499 m .24213 .23195 L .20655 .22444 L 0 .954 .605 r
F
.21102 .21499 m .24678 .22258 L .24213 .23195 L F
.20655 .22444 m .21825 .72992 L .24213 .23195 L 0 .972 .616 r
F
.24678 .22258 m .24213 .23195 L .21825 .72992 L 0 .535 .339 r
F
.65975 .2318 m .68307 .7683 L .7204 .77407 L .537 .969 0 r
F
.66663 .22243 m .65975 .2318 L .68307 .7683 L .411 .742 0 r
F
.56851 .23167 m .57435 .79223 L .58151 .78511 L .112 .71 0 r
F
.53431 .22416 m .58151 .78511 L .56851 .23167 L .153 .97 0 r
F
.48432 .92514 m .51283 .93531 L .47839 .93081 L .364 0 .874 r
F
.48432 .92514 m .51892 .92969 L .51283 .93531 L F
.27733 .21411 m .30783 .23109 L .2725 .22358 L 0 .954 .416 r
F
.27733 .21411 m .31282 .22171 L .30783 .23109 L F
.2725 .22358 m .29022 .75512 L .30783 .23109 L 0 .971 .424 r
F
.31282 .22171 m .30783 .23109 L .29022 .75512 L 0 .579 .253 r
F
.75336 .77325 m .78198 .78608 L .74523 .78041 L .488 .882 0 r
F
.75336 .77325 m .7903 .779 L .78198 .78608 L F
.72566 .23095 m .75717 .77524 L .79422 .78099 L .728 .968 0 r
F
.73289 .22156 m .72566 .23095 L .75717 .77524 L .573 .761 0 r
F
.63437 .23081 m .64785 .79412 L .65546 .787 L .261 .733 0 r
F
.60044 .22329 m .65546 .787 L .63437 .23081 L .345 .969 0 r
F
.34371 .21324 m .37358 .23024 L .33852 .22271 L 0 .954 .227 r
F
.34371 .21324 m .37893 .22085 L .37358 .23024 L F
.33852 .22271 m .36329 .76624 L .37358 .23024 L 0 .971 .231 r
F
.37893 .22085 m .37358 .23024 L .36329 .76624 L 0 .618 .147 r
F
.79162 .23009 m .8317 .7839 L .86848 .78963 L .92 .968 0 r
F
.79921 .2207 m .79162 .23009 L .8317 .7839 L .74 .779 0 r
F
.70029 .22996 m .7204 .77407 L .72841 .76686 L .418 .754 0 r
F
.66663 .22243 m .72841 .76686 L .70029 .22996 L .537 .969 0 r
F
.41015 .21237 m .4394 .22938 L .40461 .22185 L 0 .954 .038 r
F
.41015 .21237 m .44511 .21998 L .4394 .22938 L F
.40461 .22185 m .43679 .77657 L .4394 .22938 L 0 .97 .039 r
F
.44511 .21998 m .4394 .22938 L .43679 .77657 L 0 .653 .026 r
F
.1389 .22932 m .10341 .73199 L .14328 .7379 L 0 .943 .972 r
F
.1389 .22932 m .09912 .73936 L .10341 .73199 L 0 .438 .452 r
F
.76629 .2291 m .79422 .78099 L .80269 .77381 L .581 .772 0 r
F
.73289 .22156 m .80269 .77381 L .76629 .2291 L .728 .968 0 r
F
.55088 .92934 m .57879 .93948 L .54458 .93499 L .19 0 .873 r
F
.55088 .92934 m .58524 .93388 L .57879 .93948 L F
.47666 .21149 m .50529 .22852 L .47076 .22098 L .151 .954 0 r
F
.47666 .21149 m .51135 .21911 L .50529 .22852 L F
.47076 .22098 m .51059 .7776 L .50529 .22852 L .153 .97 0 r
F
.51135 .21911 m .50529 .22852 L .51059 .7776 L .108 .683 0 r
F
.20464 .22846 m .176 .73798 L .2156 .74388 L 0 .972 .809 r
F
.20464 .22846 m .17127 .74533 L .176 .73798 L 0 .506 .421 r
F
.83234 .22824 m .86848 .78963 L .87741 .78248 L .749 .789 0 r
F
.79921 .2207 m .87741 .78248 L .83234 .22824 L .919 .968 0 r
F
.54323 .21062 m .57124 .22766 L .53697 .22012 L .34 .954 0 r
F
.54323 .21062 m .57765 .21824 L .57124 .22766 L F
.53697 .22012 m .58458 .78119 L .57124 .22766 L .345 .97 0 r
F
.57765 .21824 m .57124 .22766 L .58458 .78119 L .253 .71 0 r
F
.27045 .2276 m .24872 .74735 L .28807 .75322 L 0 .971 .616 r
F
.27045 .2276 m .24355 .75466 L .24872 .74735 L 0 .554 .351 r
F
.1598 .90464 m .19149 .91503 L .15558 .91043 L .878 0 .695 r
F
.1598 .90464 m .19588 .90929 L .19149 .91503 L F
.60987 .20974 m .63725 .2268 L .60325 .21925 L .529 .954 0 r
F
.60987 .20974 m .64402 .21738 L .63725 .2268 L F
.60325 .21925 m .6578 .75935 L .63725 .2268 L .537 .969 0 r
F
.64402 .21738 m .63725 .2268 L .6578 .75935 L .406 .733 0 r
F
.33632 .22674 m .32151 .76775 L .36069 .77355 L 0 .971 .423 r
F
.33632 .22674 m .31588 .77497 L .32151 .76775 L 0 .596 .26 r
F
.22627 .90411 m .25734 .91451 L .2217 .9099 L .878 0 .869 r
F
.22627 .90411 m .26208 .90876 L .25734 .91451 L F
.67658 .20886 m .70333 .22594 L .6696 .21838 L .717 .954 0 r
F
.67658 .20886 m .71046 .21651 L .70333 .22594 L F
.6696 .21838 m .73214 .76883 L .70333 .22594 L .728 .968 0 r
F
.71046 .21651 m .70333 .22594 L .73214 .76883 L .567 .754 0 r
F
.40225 .22588 m .39519 .77217 L .43409 .77796 L 0 .971 .231 r
F
.40225 .22588 m .38912 .77938 L .39519 .77217 L 0 .633 .151 r
F
.29281 .90357 m .32325 .91398 L .28788 .90938 L .713 0 .878 r
F
.10341 .73199 m .13877 .7452 L .09912 .73936 L 0 .863 .889 r
F
.10341 .73199 m .14328 .7379 L .13877 .7452 L F
.14065 .2253 m .10486 .73465 L .14486 .74058 L 0 .972 .809 r
F
.14477 .21586 m .14065 .2253 L .10486 .73465 L 0 .452 .376 r
F
.74335 .20799 m .76947 .22508 L .73601 .21751 L .906 .954 0 r
F
.74335 .20799 m .77696 .21564 L .76947 .22508 L F
.73601 .21751 m .80681 .7775 L .76947 .22508 L .92 .968 0 r
F
.77696 .21564 m .76947 .22508 L .80681 .7775 L .734 .772 0 r
F
.46825 .22502 m .4691 .77915 L .50773 .78492 L 0 .97 .039 r
F
.46825 .22502 m .46258 .78633 L .4691 .77915 L 0 .665 .027 r
F
.20655 .22444 m .17865 .72395 L .21825 .72992 L 0 .972 .616 r
F
.21102 .21499 m .20655 .22444 L .17865 .72395 L 0 .506 .321 r
F
.81019 .20711 m .83568 .22422 L .80248 .21664 L .954 .813 0 r
F
.81019 .20711 m .84353 .21476 L .83568 .22422 L F
.80248 .21664 m .87849 .74554 L .83568 .22422 L .967 .824 0 r
F
.84353 .21476 m .83568 .22422 L .87849 .74554 L .789 .672 0 r
F
.53431 .22416 m .54321 .77934 L .58151 .78511 L .153 .97 0 r
F
.53431 .22416 m .53624 .78653 L .54321 .77934 L .11 .694 0 r
F
.24872 .74735 m .2827 .76046 L .24355 .75466 L 0 .886 .562 r
F
.24872 .74735 m .28807 .75322 L .2827 .76046 L F
.2725 .22358 m .25074 .74924 L .29022 .75512 L 0 .971 .424 r
F
.27733 .21411 m .2725 .22358 L .25074 .74924 L 0 .554 .241 r
F
.1808 .22344 m .14486 .74058 L .14944 .73318 L 0 .485 .404 r
F
.14477 .21586 m .14944 .73318 L .1808 .22344 L 0 .972 .809 r
F
.60044 .22329 m .61747 .78124 L .65546 .787 L .345 .969 0 r
F
.60044 .22329 m .61006 .78842 L .61747 .78124 L .256 .719 0 r
F
.33852 .22271 m .32405 .76039 L .36329 .76624 L 0 .971 .231 r
F
.34371 .21324 m .33852 .22271 L .32405 .76039 L 0 .596 .142 r
F
.24678 .22258 m .21825 .72992 L .22326 .72247 L 0 .535 .339 r
F
.21102 .21499 m .22326 .72247 L .24678 .22258 L 0 .971 .616 r
F
.66663 .22243 m .6909 .76102 L .72841 .76686 L .537 .969 0 r
F
.66663 .22243 m .68307 .7683 L .6909 .76102 L .411 .742 0 r
F
.40461 .22185 m .39779 .77075 L .43679 .77657 L 0 .97 .039 r
F
.41015 .21237 m .40461 .22185 L .39779 .77075 L 0 .633 .025 r
F
.31282 .22171 m .29022 .75512 L .29569 .74778 L 0 .579 .253 r
F
.27733 .21411 m .29569 .74778 L .31282 .22171 L 0 .971 .423 r
F
.73289 .22156 m .76546 .76798 L .80269 .77381 L .728 .968 0 r
F
.73289 .22156 m .75717 .77524 L .76546 .76798 L .573 .761 0 r
F
.35923 .91248 m .3891 .92283 L .35393 .91825 L .538 0 .876 r
F
.35923 .91248 m .39457 .91711 L .3891 .92283 L F
.47076 .22098 m .47191 .77179 L .51059 .7776 L .153 .97 0 r
F
.47666 .21149 m .47076 .22098 L .47191 .77179 L .105 .665 0 r
F
.37893 .22085 m .36329 .76624 L .36922 .75894 L 0 .618 .147 r
F
.34371 .21324 m .36922 .75894 L .37893 .22085 L 0 .971 .231 r
F
.79921 .2207 m .84045 .77668 L .87741 .78248 L .919 .968 0 r
F
.79921 .2207 m .8317 .7839 L .84045 .77668 L .74 .779 0 r
F
.53697 .22012 m .5462 .77538 L .58458 .78119 L .345 .97 0 r
F
.54323 .21062 m .53697 .22012 L .5462 .77538 L .247 .694 0 r
F
.44511 .21998 m .43679 .77657 L .44317 .76931 L 0 .653 .026 r
F
.41015 .21237 m .44317 .76931 L .44511 .21998 L 0 .97 .039 r
F
.426 .9151 m .45526 .92544 L .42034 .92086 L .364 0 .875 r
F
.426 .9151 m .46109 .91973 L .45526 .92544 L F
.15073 .20219 m .18265 .2194 L .14655 .21178 L 0 .954 .605 r
F
.15073 .20219 m .18701 .20989 L .18265 .2194 L F
.14655 .21178 m .1526 .71077 L .18265 .2194 L 0 .972 .616 r
F
.18701 .20989 m .18265 .2194 L .1526 .71077 L 0 .485 .308 r
F
.60325 .21925 m .61991 .75346 L .6578 .75935 L .537 .969 0 r
F
.60987 .20974 m .60325 .21925 L .61991 .75346 L .398 .719 0 r
F
.51135 .21911 m .51059 .7776 L .51741 .77035 L .108 .683 0 r
F
.47666 .21149 m .51741 .77035 L .51135 .21911 L .153 .97 0 r
F
.21749 .20131 m .24878 .21853 L .21295 .2109 L 0 .954 .416 r
F
.21749 .20131 m .2535 .20901 L .24878 .21853 L F
.21295 .2109 m .22515 .72511 L .24878 .21853 L 0 .971 .424 r
F
.2535 .20901 m .24878 .21853 L .22515 .72511 L 0 .535 .233 r
F
.6909 .76102 m .7204 .77407 L .68307 .7683 L .489 .882 0 r
F
.6909 .76102 m .72841 .76686 L .7204 .77407 L F
.6696 .21838 m .69451 .76297 L .73214 .76883 L .728 .968 0 r
F
.67658 .20886 m .6696 .21838 L .69451 .76297 L .558 .742 0 r
F
.57765 .21824 m .58458 .78119 L .59186 .77394 L .253 .71 0 r
F
.54323 .21062 m .59186 .77394 L .57765 .21824 L .345 .969 0 r
F
.28432 .20042 m .31498 .21766 L .27942 .21003 L 0 .954 .227 r
F
.28432 .20042 m .32006 .20813 L .31498 .21766 L F
.27942 .21003 m .29792 .74884 L .31498 .21766 L 0 .971 .231 r
F
.32006 .20813 m .31498 .21766 L .29792 .74884 L 0 .579 .138 r
F
.76546 .76798 m .79422 .78099 L .75717 .77524 L .662 .88 0 r
F
.76546 .76798 m .80269 .77381 L .79422 .78099 L F
.73601 .21751 m .76945 .77167 L .80681 .7775 L .92 .968 0 r
F
.74335 .20799 m .73601 .21751 L .76945 .77167 L .723 .761 0 r
F
.64402 .21738 m .6578 .75935 L .66549 .752 L .406 .733 0 r
F
.60987 .20974 m .66549 .752 L .64402 .21738 L .537 .969 0 r
F
.49292 .91931 m .52158 .92962 L .4869 .92506 L .19 0 .874 r
F
.49292 .91931 m .52777 .92393 L .52158 .92962 L F
.35121 .19953 m .38124 .21679 L .34595 .20915 L 0 .954 .038 r
F
.35121 .19953 m .38668 .20726 L .38124 .21679 L F
.34595 .20915 m .37184 .75239 L .38124 .21679 L 0 .97 .039 r
F
.38668 .20726 m .38124 .21679 L .37184 .75239 L 0 .618 .025 r
F
.80248 .21664 m .84168 .73959 L .87849 .74554 L .967 .824 0 r
F
.81019 .20711 m .80248 .21664 L .84168 .73959 L .779 .664 0 r
F
.71046 .21651 m .73214 .76883 L .7403 .76152 L .567 .754 0 r
F
.67658 .20886 m .7403 .76152 L .71046 .21651 L .728 .968 0 r
F
.55993 .91799 m .58795 .92832 L .55354 .92375 L .017 0 .874 r
F
.55993 .91799 m .5945 .92261 L .58795 .92832 L F
.41817 .19865 m .44757 .21592 L .41255 .20827 L .151 .954 0 r
F
.41817 .19865 m .45337 .20638 L .44757 .21592 L F
.41255 .20827 m .44594 .76191 L .44757 .21592 L .153 .97 0 r
F
.45337 .20638 m .44757 .21592 L .44594 .76191 L .103 .653 0 r
F
.14477 .21586 m .10922 .72718 L .14944 .73318 L 0 .972 .809 r
F
.14477 .21586 m .10486 .73465 L .10922 .72718 L 0 .452 .376 r
F
.77696 .21564 m .80681 .7775 L .81543 .77023 L .734 .772 0 r
F
.74335 .20799 m .81543 .77023 L .77696 .21564 L .919 .968 0 r
F
.16616 .89153 m .19801 .90212 L .16189 .89743 L .879 0 .87 r
F
.16616 .89153 m .20246 .89627 L .19801 .90212 L F
.4852 .19776 m .51397 .21505 L .47921 .20739 L .34 .954 0 r
F
.4852 .19776 m .52012 .2055 L .51397 .21505 L F
.47921 .20739 m .5204 .76977 L .51397 .21505 L .345 .97 0 r
F
.52012 .2055 m .51397 .21505 L .5204 .76977 L .243 .683 0 r
F
.21102 .21499 m .18345 .71643 L .22326 .72247 L 0 .971 .616 r
F
.21102 .21499 m .17865 .72395 L .18345 .71643 L 0 .506 .321 r
F
.84353 .21476 m .87849 .74554 L .88749 .73811 L .789 .672 0 r
F
.81019 .20711 m .88749 .73811 L .84353 .21476 L .967 .824 0 r
F
.55229 .19687 m .58042 .21418 L .54594 .20652 L .529 .954 0 r
F
.55229 .19687 m .58694 .20461 L .58042 .21418 L F
.54594 .20652 m .59443 .74866 L .58042 .21418 L .537 .969 0 r
F
.58694 .20461 m .58042 .21418 L .59443 .74866 L .393 .71 0 r
F
.27733 .21411 m .256 .74183 L .29569 .74778 L 0 .971 .423 r
F
.27733 .21411 m .25074 .74924 L .256 .74183 L 0 .554 .241 r
F
.61945 .19598 m .64695 .2133 L .61273 .20563 L .717 .954 0 r
F
.61945 .19598 m .65383 .20373 L .64695 .2133 L F
.61273 .20563 m .66919 .75818 L .64695 .2133 L .728 .968 0 r
F
.65383 .20373 m .64695 .2133 L .66919 .75818 L .551 .733 0 r
F
.34371 .21324 m .32976 .75302 L .36922 .75894 L 0 .971 .231 r
F
.34371 .21324 m .32405 .76039 L .32976 .75302 L 0 .596 .142 r
F
.68668 .19509 m .71354 .21243 L .67959 .20475 L .906 .954 0 r
F
.68668 .19509 m .72078 .20285 L .71354 .21243 L F
.67959 .20475 m .74416 .76433 L .71354 .21243 L .92 .968 0 r
F
.72078 .20285 m .71354 .21243 L .74416 .76433 L .716 .754 0 r
F
.41015 .21237 m .40396 .76343 L .44317 .76931 L 0 .97 .039 r
F
.41015 .21237 m .39779 .77075 L .40396 .76343 L 0 .633 .025 r
F
.14655 .21178 m .11244 .70467 L .1526 .71077 L 0 .972 .616 r
F
.15073 .20219 m .14655 .21178 L .11244 .70467 L 0 .452 .287 r
F
.75397 .1942 m .78019 .21156 L .74652 .20387 L .954 .813 0 r
F
.75397 .1942 m .7878 .20197 L .78019 .21156 L F
.74652 .20387 m .81689 .73475 L .78019 .21156 L .967 .824 0 r
F
.7878 .20197 m .78019 .21156 L .81689 .73475 L .772 .658 0 r
F
.47666 .21149 m .47854 .76446 L .51741 .77035 L .153 .97 0 r
F
.47666 .21149 m .47191 .77179 L .47854 .76446 L .105 .665 0 r
F
.18345 .71643 m .21825 .72992 L .17865 .72395 L 0 .89 .564 r
F
.18345 .71643 m .22326 .72247 L .21825 .72992 L F
.21295 .2109 m .1852 .71906 L .22515 .72511 L 0 .971 .424 r
F
.21749 .20131 m .21295 .2109 L .1852 .71906 L 0 .506 .221 r
F
.29984 .89834 m .33047 .90888 L .29484 .90422 L .539 0 .877 r
F
.29984 .89834 m .33565 .90306 L .33047 .90888 L F
.82134 .1933 m .84691 .21068 L .81351 .20299 L .954 .624 0 r
F
.82134 .1933 m .85488 .20108 L .84691 .21068 L F
.81351 .20299 m .89182 .73999 L .84691 .21068 L .967 .632 0 r
F
.85488 .20108 m .84691 .21068 L .89182 .73999 L .789 .516 0 r
F
.54323 .21062 m .55329 .76807 L .59186 .77394 L .345 .969 0 r
F
.54323 .21062 m .5462 .77538 L .55329 .76807 L .247 .694 0 r
F
.256 .74183 m .29022 .75512 L .25074 .74924 L 0 .885 .386 r
F
.256 .74183 m .29569 .74778 L .29022 .75512 L F
.27942 .21003 m .25811 .74287 L .29792 .74884 L 0 .971 .231 r
F
.28432 .20042 m .27942 .21003 L .25811 .74287 L 0 .554 .132 r
F
.18701 .20989 m .1526 .71077 L .15725 .70316 L 0 .485 .308 r
F
.15073 .20219 m .15725 .70316 L .18701 .20989 L 0 .971 .616 r
F
.60987 .20974 m .62741 .74604 L .66549 .752 L .537 .969 0 r
F
.60987 .20974 m .61991 .75346 L .62741 .74604 L .398 .719 0 r
F
.34595 .20915 m .33232 .74643 L .37184 .75239 L 0 .97 .039 r
F
.35121 .19953 m .34595 .20915 L .33232 .74643 L 0 .596 .024 r
F
.2535 .20901 m .22515 .72511 L .23026 .71755 L 0 .535 .233 r
F
.21749 .20131 m .23026 .71755 L .2535 .20901 L 0 .971 .423 r
F
.67658 .20886 m .70249 .75559 L .7403 .76152 L .728 .968 0 r
F
.67658 .20886 m .69451 .76297 L .70249 .75559 L .558 .742 0 r
F
.41255 .20827 m .40668 .75599 L .44594 .76191 L .153 .97 0 r
F
.41817 .19865 m .41255 .20827 L .40668 .75599 L .1 .633 0 r
F
.32006 .20813 m .29792 .74884 L .30349 .74139 L 0 .579 .138 r
F
.28432 .20042 m .30349 .74139 L .32006 .20813 L 0 .971 .231 r
F
.74335 .20799 m .77789 .76433 L .81543 .77023 L .919 .968 0 r
F
.74335 .20799 m .76945 .77167 L .77789 .76433 L .723 .761 0 r
F
.10609 .86696 m .13865 .87783 L .10212 .87302 L .883 0 .874 r
F
.10609 .86696 m .1428 .87182 L .13865 .87783 L F
.36689 .90413 m .39693 .91464 L .36152 .90999 L .364 0 .876 r
F
.47921 .20739 m .48141 .76387 L .5204 .76977 L .345 .97 0 r
F
.4852 .19776 m .47921 .20739 L .48141 .76387 L .237 .665 0 r
F
.38668 .20726 m .37184 .75239 L .37786 .74496 L 0 .618 .025 r
F
.35121 .19953 m .37786 .74496 L .38668 .20726 L 0 .97 .039 r
F
.81019 .20711 m .85051 .73209 L .88749 .73811 L .967 .824 0 r
F
.81019 .20711 m .84168 .73959 L .85051 .73209 L .779 .664 0 r
F
.54594 .20652 m .55594 .74267 L .59443 .74866 L .537 .969 0 r
F
.55229 .19687 m .54594 .20652 L .55594 .74267 L .384 .694 0 r
F
.45337 .20638 m .44594 .76191 L .45242 .75452 L .103 .653 0 r
F
.41817 .19865 m .45242 .75452 L .45337 .20638 L .153 .97 0 r
F
.15679 .18831 m .18889 .20578 L .15254 .19805 L 0 .954 .416 r
F
.15679 .18831 m .19332 .19613 L .18889 .20578 L F
.15254 .19805 m .15851 .71246 L .18889 .20578 L 0 .971 .424 r
F
.19332 .19613 m .18889 .20578 L .15851 .71246 L 0 .485 .211 r
F
.62741 .74604 m .6578 .75935 L .61991 .75346 L .489 .883 0 r
F
.62741 .74604 m .66549 .752 L .6578 .75935 L F
.61273 .20563 m .63097 .75223 L .66919 .75818 L .728 .968 0 r
F
.61945 .19598 m .61273 .20563 L .63097 .75223 L .541 .719 0 r
F
.52012 .2055 m .5204 .76977 L .52734 .76241 L .243 .683 0 r
F
.4852 .19776 m .52734 .76241 L .52012 .2055 L .345 .969 0 r
F
.43418 .90835 m .4636 .91884 L .42843 .9142 L .191 0 .874 r
F
.43418 .90835 m .46952 .91305 L .4636 .91884 L F
.22407 .18741 m .25554 .2049 L .21946 .19716 L 0 .954 .227 r
F
.22407 .18741 m .26033 .19524 L .25554 .2049 L F
.21946 .19716 m .23185 .72782 L .25554 .2049 L 0 .971 .231 r
F
.26033 .19524 m .25554 .2049 L .23185 .72782 L 0 .535 .127 r
F
.70249 .75559 m .73214 .76883 L .69451 .76297 L .663 .881 0 r
F
.70249 .75559 m .7403 .76152 L .73214 .76883 L F
.67959 .20475 m .70622 .7584 L .74416 .76433 L .92 .968 0 r
F
.68668 .19509 m .67959 .20475 L .70622 .7584 L .705 .742 0 r
F
.58694 .20461 m .59443 .74866 L .6018 .74119 L .393 .71 0 r
F
.55229 .19687 m .6018 .74119 L .58694 .20461 L .537 .969 0 r
F
.56907 .9041 m .59719 .91462 L .56259 .90996 L 0 .156 .875 r
F
.29142 .18651 m .32225 .20402 L .28644 .19627 L 0 .954 .038 r
F
.29142 .18651 m .3274 .19435 L .32225 .20402 L F
.28644 .19627 m .30616 .72967 L .32225 .20402 L 0 .97 .039 r
F
.3274 .19435 m .32225 .20402 L .30616 .72967 L 0 .579 .023 r
F
.74652 .20387 m .7795 .7287 L .81689 .73475 L .967 .824 0 r
F
.75397 .1942 m .74652 .20387 L .7795 .7287 L .761 .649 0 r
F
.65383 .20373 m .66919 .75818 L .67704 .75075 L .551 .733 0 r
F
.61945 .19598 m .67704 .75075 L .65383 .20373 L .728 .968 0 r
F
.50165 .911 m .53044 .92147 L .49553 .91683 L .017 0 .874 r
F
.50165 .911 m .53673 .91568 L .53044 .92147 L F
.35884 .18561 m .38903 .20314 L .35349 .19538 L .151 .954 0 r
F
.35884 .18561 m .39454 .19346 L .38903 .20314 L F
.35349 .19538 m .38039 .74601 L .38903 .20314 L .153 .97 0 r
F
.39454 .19346 m .38903 .20314 L .38039 .74601 L .098 .618 0 r
F
.85051 .73209 m .88749 .73811 L .87849 .74554 L .886 .755 0 r
F
.81351 .20299 m .85473 .73395 L .89182 .73999 L .967 .632 0 r
F
.82134 .1933 m .81351 .20299 L .85473 .73395 L .779 .509 0 r
F
.72078 .20285 m .74416 .76433 L .75247 .75693 L .716 .754 0 r
F
.68668 .19509 m .75247 .75693 L .72078 .20285 L .919 .968 0 r
F
.17257 .87903 m .20457 .88981 L .16823 .88504 L .714 0 .88 r
F
.17257 .87903 m .20909 .88386 L .20457 .88981 L F
.42632 .18471 m .45587 .20225 L .42061 .19449 L .34 .954 0 r
F
.42632 .18471 m .46175 .19256 L .45587 .20225 L F
.42061 .19449 m .45523 .74361 L .45587 .20225 L .345 .97 0 r
F
.46175 .19256 m .45587 .20225 L .45523 .74361 L .232 .653 0 r
F
.15073 .20219 m .11688 .69699 L .15725 .70316 L 0 .971 .616 r
F
.15073 .20219 m .11244 .70467 L .11688 .69699 L 0 .452 .287 r
F
.7878 .20197 m .81689 .73475 L .8256 .7272 L .772 .658 0 r
F
.75397 .1942 m .8256 .7272 L .7878 .20197 L .967 .824 0 r
F
.49388 .18381 m .52278 .20137 L .48779 .1936 L .529 .954 0 r
F
.49388 .18381 m .52903 .19167 L .52278 .20137 L F
.48779 .1936 m .52999 .73268 L .52278 .20137 L .537 .969 0 r
F
.52903 .19167 m .52278 .20137 L .52999 .73268 L .378 .683 0 r
F
.21749 .20131 m .19009 .71143 L .23026 .71755 L 0 .971 .423 r
F
.21749 .20131 m .1852 .71906 L .19009 .71143 L 0 .506 .221 r
F
.63684 .91072 m .66436 .9212 L .62998 .91656 L 0 .328 .873 r
F
.63684 .91072 m .67137 .91541 L .66436 .9212 L F
.85488 .20108 m .89182 .73999 L .90099 .73246 L .789 .516 0 r
F
.82134 .1933 m .90099 .73246 L .85488 .20108 L .966 .632 0 r
F
.5615 .18291 m .58976 .20048 L .55504 .1927 L .717 .954 0 r
F
.5615 .18291 m .59637 .19077 L .58976 .20048 L F
.55504 .1927 m .60515 .74394 L .58976 .20048 L .728 .968 0 r
F
.59637 .19077 m .58976 .20048 L .60515 .74394 L .534 .71 0 r
F
.28432 .20042 m .26346 .73535 L .30349 .74139 L 0 .971 .231 r
F
.28432 .20042 m .25811 .74287 L .26346 .73535 L 0 .554 .132 r
F
.2397 .88482 m .27111 .89556 L .23499 .89081 L .539 0 .878 r
F
.2397 .88482 m .27599 .88963 L .27111 .89556 L F
.62919 .182 m .6568 .1996 L .62236 .19181 L .906 .954 0 r
F
.62919 .182 m .66378 .18988 L .6568 .1996 L F
.62236 .19181 m .68057 .75097 L .6568 .1996 L .92 .968 0 r
F
.66378 .18988 m .6568 .1996 L .68057 .75097 L .696 .733 0 r
F
.35121 .19953 m .33813 .73893 L .37786 .74496 L 0 .97 .039 r
F
.35121 .19953 m .33232 .74643 L .33813 .73893 L 0 .596 .024 r
F
.69694 .1811 m .72391 .19871 L .68974 .19091 L .954 .813 0 r
F
.69694 .1811 m .73126 .18898 L .72391 .19871 L F
.68974 .19091 m .75418 .72124 L .72391 .19871 L .967 .824 0 r
F
.73126 .18898 m .72391 .19871 L .75418 .72124 L .754 .642 0 r
F
.41817 .19865 m .41295 .74852 L .45242 .75452 L .153 .97 0 r
F
.41817 .19865 m .40668 .75599 L .41295 .74852 L .1 .633 0 r
F
.11688 .69699 m .1526 .71077 L .11244 .70467 L 0 .892 .565 r
F
.11688 .69699 m .15725 .70316 L .1526 .71077 L F
.15254 .19805 m .11793 .70631 L .15851 .71246 L 0 .971 .424 r
F
.15679 .18831 m .15254 .19805 L .11793 .70631 L 0 .452 .197 r
F
.30716 .88744 m .33794 .89817 L .30208 .89342 L .365 0 .878 r
F
.76477 .18019 m .79108 .19782 L .75719 .19002 L .954 .624 0 r
F
.76477 .18019 m .79881 .18808 L .79108 .19782 L F
.75719 .19002 m .82924 .72223 L .79108 .19782 L .967 .632 0 r
F
.79881 .18808 m .79108 .19782 L .82924 .72223 L .772 .505 0 r
F
.4852 .19776 m .48816 .75643 L .52734 .76241 L .345 .969 0 r
F
.4852 .19776 m .48141 .76387 L .48816 .75643 L .237 .665 0 r
F
.19009 .71143 m .22515 .72511 L .1852 .71906 L 0 .889 .388 r
F
.19009 .71143 m .23026 .71755 L .22515 .72511 L F
.21946 .19716 m .19148 .72171 L .23185 .72782 L 0 .971 .231 r
F
.22407 .18741 m .21946 .19716 L .19148 .72171 L 0 .506 .12 r
F
.83266 .17929 m .85833 .19693 L .82471 .18912 L .954 .435 0 r
F
.83266 .17929 m .86642 .18718 L .85833 .19693 L F
.82471 .18912 m .90302 .70711 L .85833 .19693 L .966 .441 0 r
F
.86642 .18718 m .85833 .19693 L .90302 .70711 L .789 .36 0 r
F
.55229 .19687 m .56311 .73513 L .6018 .74119 L .537 .969 0 r
F
.55229 .19687 m .55594 .74267 L .56311 .73513 L .384 .694 0 r
F
.28644 .19627 m .2661 .72356 L .30616 .72967 L 0 .97 .039 r
F
.29142 .18651 m .28644 .19627 L .2661 .72356 L 0 .554 .022 r
F
.19332 .19613 m .15851 .71246 L .16325 .70478 L 0 .485 .211 r
F
.15679 .18831 m .16325 .70478 L .19332 .19613 L 0 .971 .423 r
F
.61945 .19598 m .63861 .74472 L .67704 .75075 L .728 .968 0 r
F
.61945 .19598 m .63097 .75223 L .63861 .74472 L .541 .719 0 r
F
.33813 .73893 m .37184 .75239 L .33232 .74643 L 0 .883 .035 r
F
.33813 .73893 m .37786 .74496 L .37184 .75239 L F
.35349 .19538 m .34054 .73997 L .38039 .74601 L .153 .97 0 r
F
.35884 .18561 m .35349 .19538 L .34054 .73997 L .094 .596 0 r
F
.26033 .19524 m .23185 .72782 L .23705 .7202 L 0 .535 .127 r
F
.22407 .18741 m .23705 .7202 L .26033 .19524 L 0 .971 .231 r
F
.68668 .19509 m .71434 .75092 L .75247 .75693 L .919 .968 0 r
F
.68668 .19509 m .70622 .7584 L .71434 .75092 L .705 .742 0 r
F
.42061 .19449 m .41574 .73755 L .45523 .74361 L .345 .97 0 r
F
.42632 .18471 m .42061 .19449 L .41574 .73755 L .225 .633 0 r
F
.3274 .19435 m .30616 .72967 L .31181 .72205 L 0 .579 .023 r
F
.29142 .18651 m .31181 .72205 L .3274 .19435 L 0 .97 .039 r
F
.75397 .1942 m .78802 .72108 L .8256 .7272 L .967 .824 0 r
F
.75397 .1942 m .7795 .7287 L .78802 .72108 L .761 .649 0 r
F
.48779 .1936 m .49092 .72658 L .52999 .73268 L .537 .969 0 r
F
.49388 .18381 m .48779 .1936 L .49092 .72658 L .369 .665 0 r
F
.39454 .19346 m .38039 .74601 L .38652 .73846 L .098 .618 0 r
F
.35884 .18561 m .38652 .73846 L .39454 .19346 L .153 .97 0 r
F
.11168 .86057 m .14445 .87159 L .10764 .86671 L .716 0 .882 r
F
.11168 .86057 m .14866 .8655 L .14445 .87159 L F
.82134 .1933 m .86372 .72635 L .90099 .73246 L .966 .632 0 r
F
.82134 .1933 m .85473 .73395 L .86372 .72635 L .779 .509 0 r
F
.37463 .89885 m .40483 .90949 L .36916 .90478 L .191 0 .875 r
F
.37463 .89885 m .41047 .90361 L .40483 .90949 L F
.56311 .73513 m .59443 .74866 L .55594 .74267 L .489 .883 0 r
F
.56311 .73513 m .6018 .74119 L .59443 .74866 L F
.55504 .1927 m .56633 .73788 L .60515 .74394 L .728 .968 0 r
F
.5615 .18291 m .55504 .1927 L .56633 .73788 L .522 .694 0 r
F
.46175 .19256 m .45523 .74361 L .46182 .73605 L .232 .653 0 r
F
.42632 .18471 m .46182 .73605 L .46175 .19256 L .345 .969 0 r
F
.16293 .17421 m .19523 .19196 L .15862 .1841 L 0 .954 .227 r
F
.16293 .17421 m .19972 .18216 L .19523 .19196 L F
.15862 .1841 m .1647 .71165 L .19523 .19196 L 0 .971 .231 r
F
.19972 .18216 m .19523 .19196 L .1647 .71165 L 0 .485 .115 r
F
.62236 .19181 m .64204 .74493 L .68057 .75097 L .92 .968 0 r
F
.62919 .182 m .62236 .19181 L .64204 .74493 L .683 .719 0 r
F
.44251 .8991 m .47207 .90975 L .43667 .90504 L .017 0 .875 r
F
.44251 .8991 m .47808 .90387 L .47207 .90975 L F
.52903 .19167 m .52999 .73268 L .53702 .72507 L .378 .683 0 r
F
.49388 .18381 m .53702 .72507 L .52903 .19167 L .537 .969 0 r
F
.51046 .89695 m .53936 .90763 L .50425 .9029 L 0 .156 .875 r
F
.51046 .89695 m .54574 .90173 L .53936 .90763 L F
.23075 .1733 m .26239 .19107 L .22606 .1832 L 0 .954 .038 r
F
.23075 .1733 m .26726 .18125 L .26239 .19107 L F
.22606 .1832 m .23993 .70244 L .26239 .19107 L 0 .97 .039 r
F
.26726 .18125 m .26239 .19107 L .23993 .70244 L 0 .535 .021 r
F
.68974 .19091 m .7162 .71508 L .75418 .72124 L .967 .824 0 r
F
.69694 .1811 m .68974 .19091 L .7162 .71508 L .742 .632 0 r
F
.59637 .19077 m .60515 .74394 L .61266 .73637 L .534 .71 0 r
F
.5615 .18291 m .61266 .73637 L .59637 .19077 L .728 .968 0 r
F
.29863 .17239 m .32963 .19017 L .29357 .1823 L .151 .954 0 r
F
.29863 .17239 m .33486 .18035 L .32963 .19017 L F
.29357 .1823 m .31403 .72646 L .32963 .19017 L .153 .97 0 r
F
.33486 .18035 m .32963 .19017 L .31403 .72646 L .092 .579 0 r
F
.75719 .19002 m .7916 .71608 L .82924 .72223 L .967 .632 0 r
F
.76477 .18019 m .75719 .19002 L .7916 .71608 L .761 .498 0 r
F
.66378 .18988 m .68057 .75097 L .68856 .74343 L .696 .733 0 r
F
.62919 .182 m .68856 .74343 L .66378 .18988 L .919 .968 0 r
F
.57852 .8988 m .60679 .90947 L .57194 .90475 L 0 .329 .874 r
F
.57852 .8988 m .61354 .90358 L .60679 .90947 L F
.64658 .89665 m .67418 .90734 L .63962 .90261 L 0 .502 .875 r
F
.64658 .89665 m .6813 .90144 L .67418 .90734 L F
.36658 .17147 m .39693 .18927 L .36115 .18139 L .34 .954 0 r
F
.36658 .17147 m .40253 .17944 L .39693 .18927 L F
.36115 .18139 m .38929 .72661 L .39693 .18927 L .345 .97 0 r
F
.40253 .17944 m .39693 .18927 L .38929 .72661 L .22 .618 0 r
F
.82471 .18912 m .86583 .70089 L .90302 .70711 L .966 .441 0 r
F
.83266 .17929 m .82471 .18912 L .86583 .70089 L .779 .355 0 r
F
.73126 .18898 m .75418 .72124 L .76257 .71355 L .754 .642 0 r
F
.69694 .1811 m .76257 .71355 L .73126 .18898 L .967 .824 0 r
F
.24688 .86738 m .27841 .87836 L .2421 .8735 L .366 0 .88 r
F
.17876 .87193 m .21097 .88286 L .17435 .87802 L .54 0 .88 r
F
.17876 .87193 m .21555 .87682 L .21097 .88286 L F
.4346 .17056 m .46429 .18838 L .42879 .18049 L .529 .954 0 r
F
.4346 .17056 m .47027 .17853 L .46429 .18838 L F
.42879 .18049 m .46464 .70455 L .46429 .18838 L .537 .969 0 r
F
.47027 .17853 m .46429 .18838 L .46464 .70455 L .362 .653 0 r
F
.15679 .18831 m .12245 .69855 L .16325 .70478 L 0 .971 .423 r
F
.15679 .18831 m .11793 .70631 L .12245 .69855 L 0 .452 .197 r
F
.79881 .18808 m .82924 .72223 L .83809 .71455 L .772 .505 0 r
F
.76477 .18019 m .83809 .71455 L .79881 .18808 L .966 .632 0 r
F
.50269 .16964 m .53173 .18748 L .49651 .17958 L .717 .954 0 r
F
.50269 .16964 m .53808 .17762 L .53173 .18748 L F
.49651 .17958 m .54026 .73466 L .53173 .18748 L .728 .968 0 r
F
.53808 .17762 m .53173 .18748 L .54026 .73466 L .514 .683 0 r
F
.22407 .18741 m .19646 .71402 L .23705 .7202 L 0 .971 .231 r
F
.22407 .18741 m .19148 .72171 L .19646 .71402 L 0 .506 .12 r
F
.86642 .18718 m .90302 .70711 L .9123 .69935 L .789 .36 0 r
F
.83266 .17929 m .9123 .69935 L .86642 .18718 L .966 .44 0 r
F
.57084 .16872 m .59923 .18658 L .56429 .17868 L .906 .954 0 r
F
.57084 .16872 m .60595 .17671 L .59923 .18658 L F
.56429 .17868 m .61607 .73827 L .59923 .18658 L .92 .968 0 r
F
.60595 .17671 m .59923 .18658 L .61607 .73827 L .674 .71 0 r
F
.29142 .18651 m .27154 .71587 L .31181 .72205 L 0 .97 .039 r
F
.29142 .18651 m .2661 .72356 L .27154 .71587 L 0 .554 .022 r
F
.63907 .16781 m .6668 .18568 L .63213 .17777 L .954 .813 0 r
F
.63907 .16781 m .6739 .1758 L .6668 .18568 L F
.63213 .17777 m .6908 .7135 L .6668 .18568 L .967 .824 0 r
F
.6739 .1758 m .6668 .18568 L .6908 .7135 L .733 .625 0 r
F
.35884 .18561 m .34646 .73234 L .38652 .73846 L .153 .97 0 r
F
.35884 .18561 m .34054 .73997 L .34646 .73234 L .094 .596 0 r
F
.70736 .16689 m .73444 .18478 L .70005 .17686 L .954 .624 0 r
F
.70736 .16689 m .74191 .17489 L .73444 .18478 L F
.70005 .17686 m .76635 .71279 L .73444 .18478 L .967 .632 0 r
F
.74191 .17489 m .73444 .18478 L .76635 .71279 L .754 .493 0 r
F
.42632 .18471 m .42211 .72992 L .46182 .73605 L .345 .969 0 r
F
.42632 .18471 m .41574 .73755 L .42211 .72992 L .225 .633 0 r
F
.12245 .69855 m .15851 .71246 L .11793 .70631 L 0 .889 .388 r
F
.12245 .69855 m .16325 .70478 L .15851 .71246 L F
.15862 .1841 m .12372 .70542 L .1647 .71165 L 0 .971 .231 r
F
.16293 .17421 m .15862 .1841 L .12372 .70542 L 0 .452 .108 r
F
.77573 .16597 m .80214 .18388 L .76804 .17595 L .954 .435 0 r
F
.77573 .16597 m .80999 .17398 L .80214 .18388 L F
.76804 .17595 m .84031 .68992 L .80214 .18388 L .966 .441 0 r
F
.80999 .17398 m .80214 .18388 L .84031 .68992 L .772 .352 0 r
F
.49388 .18381 m .49774 .71889 L .53702 .72507 L .537 .969 0 r
F
.49388 .18381 m .49092 .72658 L .49774 .71889 L .369 .665 0 r
F
.22606 .1832 m .19937 .69618 L .23993 .70244 L 0 .97 .039 r
F
.23075 .1733 m .22606 .1832 L .19937 .69618 L 0 .506 .02 r
F
.84416 .16505 m .86991 .18297 L .83609 .17504 L .954 .246 0 r
F
.84416 .16505 m .87814 .17307 L .86991 .18297 L F
.84416 .16505 m .86991 .18297 L .83609 .17504 L F
.84416 .16505 m .87814 .17307 L .86991 .18297 L F
.5615 .18291 m .57364 .73023 L .61266 .73637 L .728 .968 0 r
F
.5615 .18291 m .56633 .73788 L .57364 .73023 L .522 .694 0 r
F
.27154 .71587 m .30616 .72967 L .2661 .72356 L 0 .886 .035 r
F
.27154 .71587 m .31181 .72205 L .30616 .72967 L F
.29357 .1823 m .27361 .72028 L .31403 .72646 L .153 .97 0 r
F
.29863 .17239 m .29357 .1823 L .27361 .72028 L .087 .554 0 r
F
.19972 .18216 m .1647 .71165 L .16952 .70388 L 0 .485 .115 r
F
.16293 .17421 m .16952 .70388 L .19972 .18216 L 0 .971 .231 r
F
.62919 .182 m .64983 .73731 L .68856 .74343 L .919 .968 0 r
F
.62919 .182 m .64204 .74493 L .64983 .73731 L .683 .719 0 r
F
.36115 .18139 m .34921 .72043 L .38929 .72661 L .345 .97 0 r
F
.36658 .17147 m .36115 .18139 L .34921 .72043 L .212 .596 0 r
F
.26726 .18125 m .23993 .70244 L .24521 .69462 L 0 .535 .021 r
F
.23075 .1733 m .24521 .69462 L .26726 .18125 L 0 .97 .039 r
F
.69694 .1811 m .7244 .70732 L .76257 .71355 L .967 .824 0 r
F
.69694 .1811 m .7162 .71508 L .7244 .70732 L .742 .632 0 r
F
.42879 .18049 m .42507 .69828 L .46464 .70455 L .537 .969 0 r
F
.4346 .17056 m .42879 .18049 L .42507 .69828 L .351 .633 0 r
F
.33486 .18035 m .31403 .72646 L .3198 .71874 L .092 .579 0 r
F
.29863 .17239 m .3198 .71874 L .33486 .18035 L .153 .97 0 r
F
.76477 .18019 m .80026 .70831 L .83809 .71455 L .966 .632 0 r
F
.76477 .18019 m .7916 .71608 L .80026 .70831 L .761 .498 0 r
F
.11762 .85008 m .15057 .86129 L .11352 .85633 L .542 0 .883 r
F
.11762 .85008 m .15485 .8551 L .15057 .86129 L F
.45098 .88488 m .48065 .89574 L .44505 .89093 L 0 .156 .876 r
F
.45098 .88488 m .48675 .88974 L .48065 .89574 L F
.49774 .71889 m .52999 .73268 L .49092 .72658 L .49 .885 0 r
F
.49774 .71889 m .53702 .72507 L .52999 .73268 L F
.49651 .17958 m .50079 .7285 L .54026 .73466 L .728 .968 0 r
F
.50269 .16964 m .49651 .17958 L .50079 .7285 L .5 .665 0 r
F
.18595 .84791 m .21824 .85914 L .18148 .85417 L .367 0 .883 r
F
.04912 .85465 m .08276 .86581 L .0454 .86087 L .716 0 .882 r
F
.04912 .85465 m .08667 .85964 L .08276 .86581 L F
.40253 .17944 m .38929 .72661 L .39552 .71889 L .22 .618 0 r
F
.36658 .17147 m .39552 .71889 L .40253 .17944 L .345 .969 0 r
F
.83266 .17929 m .87492 .69306 L .9123 .69935 L .966 .44 0 r
F
.83266 .17929 m .86583 .70089 L .87492 .69306 L .779 .355 0 r
F
.38254 .89025 m .4129 .90107 L .37699 .89628 L .017 0 .875 r
F
.38254 .89025 m .41863 .8951 L .4129 .90107 L F
.57364 .73023 m .60515 .74394 L .56633 .73788 L .663 .882 0 r
F
.57364 .73023 m .61266 .73637 L .60515 .74394 L F
.56429 .17868 m .57692 .73212 L .61607 .73827 L .92 .968 0 r
F
.57084 .16872 m .56429 .17868 L .57692 .73212 L .659 .694 0 r
F
.47027 .17853 m .46464 .70455 L .47131 .69673 L .362 .653 0 r
F
.4346 .17056 m .47131 .69673 L .47027 .17853 L .537 .969 0 r
F
.16918 .15989 m .20166 .17792 L .1648 .16994 L 0 .954 .038 r
F
.16918 .15989 m .20623 .16796 L .20166 .17792 L F
.1648 .16994 m .1724 .68685 L .20166 .17792 L 0 .97 .039 r
F
.20623 .16796 m .20166 .17792 L .1724 .68685 L 0 .485 .019 r
F
.63213 .17777 m .65218 .70725 L .6908 .7135 L .967 .824 0 r
F
.63907 .16781 m .63213 .17777 L .65218 .70725 L .719 .613 0 r
F
.53808 .17762 m .54026 .73466 L .54743 .72697 L .514 .683 0 r
F
.50269 .16964 m .54743 .72697 L .53808 .17762 L .728 .968 0 r
F
.51945 .88834 m .54849 .89918 L .51314 .89438 L 0 .329 .875 r
F
.51945 .88834 m .55497 .89319 L .54849 .89918 L F
.23753 .15897 m .26936 .17701 L .23277 .16902 L .151 .954 0 r
F
.23753 .15897 m .2743 .16704 L .26936 .17701 L F
.23277 .16902 m .24749 .69124 L .26936 .17701 L .153 .97 0 r
F
.2743 .16704 m .26936 .17701 L .24749 .69124 L .085 .535 0 r
F
.70005 .17686 m .72808 .70654 L .76635 .71279 L .967 .632 0 r
F
.70736 .16689 m .70005 .17686 L .72808 .70654 L .742 .485 0 r
F
.60595 .17671 m .61607 .73827 L .62372 .73059 L .674 .71 0 r
F
.57084 .16872 m .62372 .73059 L .60595 .17671 L .919 .968 0 r
F
.58799 .88698 m .61636 .89784 L .5813 .89303 L 0 .502 .875 r
F
.58799 .88698 m .62321 .89184 L .61636 .89784 L F
.30595 .15804 m .33712 .1761 L .30082 .16811 L .34 .954 0 r
F
.30595 .15804 m .34244 .16612 L .33712 .1761 L F
.30082 .16811 m .32248 .70852 L .33712 .1761 L .345 .97 0 r
F
.34244 .16612 m .33712 .1761 L .32248 .70852 L .206 .579 0 r
F
.76804 .17595 m .80256 .68357 L .84031 .68992 L .966 .441 0 r
F
.77573 .16597 m .76804 .17595 L .80256 .68357 L .761 .347 0 r
F
.6739 .1758 m .6908 .7135 L .69887 .7057 L .733 .625 0 r
F
.63907 .16781 m .69887 .7057 L .6739 .1758 L .967 .824 0 r
F
.37445 .15711 m .40495 .17519 L .36893 .16719 L .529 .954 0 r
F
.37445 .15711 m .41064 .1652 L .40495 .17519 L F
.36893 .16719 m .39849 .69321 L .40495 .17519 L .537 .969 0 r
F
.41064 .1652 m .40495 .17519 L .39849 .69321 L .343 .618 0 r
F
.74191 .17489 m .76635 .71279 L .77489 .70498 L .754 .493 0 r
F
.70736 .16689 m .77489 .70498 L .74191 .17489 L .966 .632 0 r
F
.44301 .15618 m .47285 .17428 L .43711 .16627 L .717 .954 0 r
F
.44301 .15618 m .47892 .16428 L .47285 .17428 L F
.43711 .16627 m .47425 .71743 L .47285 .17428 L .728 .968 0 r
F
.47892 .16428 m .47285 .17428 L .47425 .71743 L .491 .653 0 r
F
.16293 .17421 m .12832 .69757 L .16952 .70388 L 0 .971 .231 r
F
.16293 .17421 m .12372 .70542 L .12832 .69757 L 0 .452 .108 r
F
.80999 .17398 m .84031 .68992 L .84927 .682 L .772 .352 0 r
F
.77573 .16597 m .84927 .682 L .80999 .17398 L .966 .44 0 r
F
.51164 .15525 m .54082 .17337 L .50536 .16535 L .906 .954 0 r
F
.51164 .15525 m .54727 .16336 L .54082 .17337 L F
.50536 .16535 m .55055 .72451 L .54082 .17337 L .92 .968 0 r
F
.54727 .16336 m .54082 .17337 L .55055 .72451 L .649 .683 0 r
F
.23075 .1733 m .20442 .68828 L .24521 .69462 L 0 .97 .039 r
F
.23075 .1733 m .19937 .69618 L .20442 .68828 L 0 .506 .02 r
F
.58034 .15432 m .60885 .17245 L .57368 .16443 L .954 .813 0 r
F
.58034 .15432 m .61568 .16243 L .60885 .17245 L F
.57368 .16443 m .62623 .70305 L .60885 .17245 L .967 .824 0 r
F
.61568 .16243 m .60885 .17245 L .62623 .70305 L .71 .605 0 r
F
.29863 .17239 m .27915 .71249 L .3198 .71874 L .153 .97 0 r
F
.29863 .17239 m .27361 .72028 L .27915 .71249 L .087 .554 0 r
F
.64911 .15338 m .67696 .17154 L .64207 .1635 L .954 .624 0 r
F
.64911 .15338 m .68417 .16151 L .67696 .17154 L F
.64207 .1635 m .7022 .69889 L .67696 .17154 L .967 .632 0 r
F
.68417 .16151 m .67696 .17154 L .7022 .69889 L .733 .479 0 r
F
.36658 .17147 m .35522 .71263 L .39552 .71889 L .345 .969 0 r
F
.36658 .17147 m .34921 .72043 L .35522 .71263 L .212 .596 0 r
F
.71795 .15245 m .74513 .17062 L .71052 .16258 L .954 .435 0 r
F
.71795 .15245 m .75272 .16058 L .74513 .17062 L F
.71052 .16258 m .77707 .6776 L .74513 .17062 L .966 .441 0 r
F
.75272 .16058 m .74513 .17062 L .77707 .6776 L .754 .344 0 r
F
.4346 .17056 m .43153 .69038 L .47131 .69673 L .537 .969 0 r
F
.4346 .17056 m .42507 .69828 L .43153 .69038 L .351 .633 0 r
F
.1648 .16994 m .13121 .68047 L .1724 .68685 L 0 .97 .039 r
F
.16918 .15989 m .1648 .16994 L .13121 .68047 L 0 .452 .018 r
F
.78686 .15152 m .81338 .16971 L .77905 .16166 L .954 .246 0 r
F
.78686 .15152 m .82134 .15966 L .81338 .16971 L F
.77905 .16166 m .85679 .72513 L .81338 .16971 L .966 .249 0 r
F
.82134 .15966 m .81338 .16971 L .85679 .72513 L .772 .199 0 r
F
.50269 .16964 m .50776 .72073 L .54743 .72697 L .728 .968 0 r
F
.50269 .16964 m .50079 .7285 L .50776 .72073 L .5 .665 0 r
F
.23277 .16902 m .20661 .68487 L .24749 .69124 L .153 .97 0 r
F
.23753 .15897 m .23277 .16902 L .20661 .68487 L .08 .506 0 r
F
.85585 .15058 m .88169 .16879 L .84765 .16073 L .954 .057 0 r
F
.85585 .15058 m .89004 .15873 L .88169 .16879 L F
.84765 .16073 m .92912 .67698 L .88169 .16879 L .965 .058 0 r
F
.89004 .15873 m .88169 .16879 L .92912 .67698 L .789 .047 0 r
F
.57084 .16872 m .58437 .72436 L .62372 .73059 L .919 .968 0 r
F
.57084 .16872 m .57692 .73212 L .58437 .72436 L .659 .694 0 r
F
.30082 .16811 m .28179 .7022 L .32248 .70852 L .345 .97 0 r
F
.30595 .15804 m .30082 .16811 L .28179 .7022 L .197 .554 0 r
F
.20623 .16796 m .1724 .68685 L .1773 .67888 L 0 .485 .019 r
F
.16918 .15989 m .1773 .67888 L .20623 .16796 L 0 .97 .039 r
F
.63907 .16781 m .66006 .69938 L .69887 .7057 L .967 .824 0 r
F
.63907 .16781 m .65218 .70725 L .66006 .69938 L .719 .613 0 r
F
.36893 .16719 m .35828 .68684 L .39849 .69321 L .537 .969 0 r
F
.37445 .15711 m .36893 .16719 L .35828 .68684 L .33 .596 0 r
F
.2743 .16704 m .24749 .69124 L .25287 .68329 L .085 .535 0 r
F
.23753 .15897 m .25287 .68329 L .2743 .16704 L .153 .97 0 r
F
.70736 .16689 m .73643 .69865 L .77489 .70498 L .966 .632 0 r
F
.70736 .16689 m .72808 .70654 L .73643 .69865 L .742 .485 0 r
F
.32176 .87886 m .35293 .88986 L .31651 .88499 L .018 0 .876 r
F
.32176 .87886 m .35837 .88378 L .35293 .88986 L F
.39066 .87587 m .42115 .8869 L .38502 .88202 L 0 .156 .876 r
F
.39066 .87587 m .42696 .88081 L .42115 .8869 L F
.43153 .69038 m .46464 .70455 L .42507 .69828 L .492 .888 0 r
F
.43153 .69038 m .47131 .69673 L .46464 .70455 L F
.43711 .16627 m .43419 .71114 L .47425 .71743 L .728 .968 0 r
F
.44301 .15618 m .43711 .16627 L .43419 .71114 L .476 .633 0 r
F
.34244 .16612 m .32248 .70852 L .32833 .70064 L .206 .579 0 r
F
.30595 .15804 m .32833 .70064 L .34244 .16612 L .345 .969 0 r
F
.77573 .16597 m .81133 .67558 L .84927 .682 L .966 .44 0 r
F
.77573 .16597 m .80256 .68357 L .81133 .67558 L .761 .347 0 r
F
.45956 .8753 m .48938 .88635 L .45354 .88146 L 0 .329 .876 r
F
.45956 .8753 m .49557 .88025 L .48938 .88635 L F
.50536 .16535 m .51078 .71824 L .55055 .72451 L .92 .968 0 r
F
.51164 .15525 m .50536 .16535 L .51078 .71824 L .632 .665 0 r
F
.41064 .1652 m .39849 .69321 L .4048 .68525 L .343 .618 0 r
F
.37445 .15711 m .4048 .68525 L .41064 .1652 L .537 .969 0 r
F
.05438 .84724 m .08824 .85857 L .0506 .85356 L .541 0 .881 r
F
.05438 .84724 m .09221 .85231 L .08824 .85857 L F
.57368 .16443 m .58698 .6967 L .62623 .70305 L .967 .824 0 r
F
.58034 .15432 m .57368 .16443 L .58698 .6967 L .694 .591 0 r
F
.47892 .16428 m .47425 .71743 L .48107 .70958 L .491 .653 0 r
F
.44301 .15618 m .48107 .70958 L .47892 .16428 L .728 .968 0 r
F
.17552 .14535 m .2082 .16366 L .17107 .15555 L .151 .954 0 r
F
.17552 .14535 m .21284 .15354 L .2082 .16366 L F
.17107 .15555 m .17937 .6763 L .2082 .16366 L .153 .97 0 r
F
.21284 .15354 m .2082 .16366 L .17937 .6763 L .077 .485 0 r
F
.52857 .87797 m .55774 .889 L .52216 .88412 L 0 .502 .875 r
F
.52857 .87797 m .56431 .8829 L .55774 .889 L F
.64207 .1635 m .66333 .69252 L .7022 .69889 L .967 .632 0 r
F
.64911 .15338 m .64207 .1635 L .66333 .69252 L .719 .47 0 r
F
.54727 .16336 m .55055 .72451 L .55785 .71669 L .649 .683 0 r
F
.51164 .15525 m .55785 .71669 L .54727 .16336 L .919 .968 0 r
F
.24442 .1444 m .27643 .16274 L .23959 .15462 L .34 .954 0 r
F
.24442 .1444 m .28145 .15261 L .27643 .16274 L F
.23959 .15462 m .2554 .6747 L .27643 .16274 L .345 .97 0 r
F
.28145 .15261 m .27643 .16274 L .2554 .6747 L .191 .535 0 r
F
.71052 .16258 m .73871 .67115 L .77707 .6776 L .966 .441 0 r
F
.71795 .15245 m .71052 .16258 L .73871 .67115 L .742 .338 0 r
F
.61568 .16243 m .62623 .70305 L .63397 .69512 L .71 .605 0 r
F
.58034 .15432 m .63397 .69512 L .61568 .16243 L .967 .824 0 r
F
.31339 .14346 m .34473 .16181 L .30817 .15369 L .529 .954 0 r
F
.31339 .14346 m .35013 .15168 L .34473 .16181 L F
.30817 .15369 m .3314 .67653 L .34473 .16181 L .537 .969 0 r
F
.35013 .15168 m .34473 .16181 L .3314 .67653 L .321 .579 0 r
F
.80026 .70831 m .82924 .72223 L .7916 .71608 L .886 .58 0 r
F
.80026 .70831 m .83809 .71455 L .82924 .72223 L F
.81133 .67558 m .84031 .68992 L .80256 .68357 L .89 .406 0 r
F
.81133 .67558 m .84927 .682 L .84031 .68992 L F
.77905 .16166 m .81843 .71884 L .85679 .72513 L .966 .249 0 r
F
.78686 .15152 m .77905 .16166 L .81843 .71884 L .761 .196 0 r
F
.68417 .16151 m .7022 .69889 L .71041 .69093 L .733 .479 0 r
F
.64911 .15338 m .71041 .69093 L .68417 .16151 L .966 .632 0 r
F
.6669 .87926 m .69473 .8903 L .65972 .88541 L 0 .849 .875 r
F
.6669 .87926 m .70208 .8842 L .69473 .8903 L F
.38244 .14252 m .4131 .16089 L .37683 .15276 L .717 .954 0 r
F
.38244 .14252 m .41889 .15074 L .4131 .16089 L F
.37683 .15276 m .40735 .69823 L .4131 .16089 L .728 .968 0 r
F
.41889 .15074 m .4131 .16089 L .40735 .69823 L .465 .618 0 r
F
.84765 .16073 m .89146 .67052 L .92912 .67698 L .965 .058 0 r
F
.85585 .15058 m .84765 .16073 L .89146 .67052 L .779 .047 0 r
F
.75272 .16058 m .77707 .6776 L .78572 .66954 L .754 .344 0 r
F
.71795 .15245 m .78572 .66954 L .75272 .16058 L .966 .44 0 r
F
.45155 .14157 m .48154 .15996 L .44556 .15182 L .906 .954 0 r
F
.45155 .14157 m .48771 .1498 L .48154 .15996 L F
.44556 .15182 m .48395 .6923 L .48154 .15996 L .92 .968 0 r
F
.48771 .1498 m .48154 .15996 L .48395 .6923 L .62 .653 0 r
F
.16918 .15989 m .13588 .67242 L .1773 .67888 L 0 .97 .039 r
F
.16918 .15989 m .13121 .68047 L .13588 .67242 L 0 .452 .018 r
F
.82134 .15966 m .85679 .72513 L .86601 .71728 L .772 .199 0 r
F
.78686 .15152 m .86601 .71728 L .82134 .15966 L .965 .249 0 r
F
.52073 .14063 m .55005 .15903 L .51435 .15089 L .954 .813 0 r
F
.52073 .14063 m .5566 .14887 L .55005 .15903 L F
.51435 .15089 m .56051 .6881 L .55005 .15903 L .967 .824 0 r
F
.5566 .14887 m .55005 .15903 L .56051 .6881 L .683 .582 0 r
F
.23753 .15897 m .21176 .67684 L .25287 .68329 L .153 .97 0 r
F
.23753 .15897 m .20661 .68487 L .21176 .67684 L .08 .506 0 r
F
.89004 .15873 m .92912 .67698 L .93871 .66891 L .789 .047 0 r
F
.85585 .15058 m .93871 .66891 L .89004 .15873 L .964 .058 0 r
F
.58999 .13968 m .61863 .15811 L .58322 .14995 L .954 .624 0 r
F
.58999 .13968 m .62557 .14793 L .61863 .15811 L F
.58322 .14995 m .63708 .68477 L .61863 .15811 L .967 .632 0 r
F
.62557 .14793 m .61863 .15811 L .63708 .68477 L .71 .464 0 r
F
.30595 .15804 m .28743 .69424 L .32833 .70064 L .345 .969 0 r
F
.30595 .15804 m .28179 .7022 L .28743 .69424 L .197 .554 0 r
F
.65931 .13873 m .68728 .15718 L .65215 .14901 L .954 .435 0 r
F
.65931 .13873 m .6946 .14699 L .68728 .15718 L F
.65215 .14901 m .71305 .66938 L .68728 .15718 L .966 .441 0 r
F
.6946 .14699 m .68728 .15718 L .71305 .66938 L .733 .334 0 r
F
.37445 .15711 m .36437 .6788 L .4048 .68525 L .537 .969 0 r
F
.37445 .15711 m .35828 .68684 L .36437 .6788 L .33 .596 0 r
F
.26037 .86163 m .29233 .87287 L .25542 .8679 L .018 0 .878 r
F
.26037 .86163 m .29746 .86666 L .29233 .87287 L F
.72871 .13778 m .756 .15625 L .72116 .14808 L .954 .246 0 r
F
.72871 .13778 m .76371 .14605 L .756 .15625 L F
.72871 .13778 m .756 .15625 L .72116 .14808 L F
.72871 .13778 m .76371 .14605 L .756 .15625 L F
.44301 .15618 m .44079 .70321 L .48107 .70958 L .728 .968 0 r
F
.44301 .15618 m .43419 .71114 L .44079 .70321 L .476 .633 0 r
F
.32963 .85944 m .36091 .8707 L .32431 .86571 L 0 .156 .878 r
F
.32963 .85944 m .36642 .86448 L .36091 .8707 L F
.17107 .15555 m .13785 .6698 L .17937 .6763 L .153 .97 0 r
F
.17552 .14535 m .17107 .15555 L .13785 .6698 L .071 .452 0 r
F
.79818 .13683 m .82479 .15532 L .79024 .14714 L .954 .057 0 r
F
.79818 .13683 m .83288 .14511 L .82479 .15532 L F
.79024 .14714 m .86607 .66531 L .82479 .15532 L .965 .058 0 r
F
.83288 .14511 m .82479 .15532 L .86607 .66531 L .772 .046 0 r
F
.51164 .15525 m .51787 .71034 L .55785 .71669 L .919 .968 0 r
F
.51164 .15525 m .51078 .71824 L .51787 .71034 L .632 .665 0 r
F
.23959 .15462 m .21424 .66819 L .2554 .6747 L .345 .97 0 r
F
.24442 .1444 m .23959 .15462 L .21424 .66819 L .18 .506 0 r
F
.58034 .15432 m .59452 .68869 L .63397 .69512 L .967 .824 0 r
F
.58034 .15432 m .58698 .6967 L .59452 .68869 L .694 .591 0 r
F
.30817 .15369 m .29057 .67003 L .3314 .67653 L .537 .969 0 r
F
.31339 .14346 m .30817 .15369 L .29057 .67003 L .307 .554 0 r
F
.21284 .15354 m .17937 .6763 L .18436 .66819 L .077 .485 0 r
F
.17552 .14535 m .18436 .66819 L .21284 .15354 L .153 .97 0 r
F
.64911 .15338 m .67134 .68448 L .71041 .69093 L .966 .632 0 r
F
.64911 .15338 m .66333 .69252 L .67134 .68448 L .719 .47 0 r
F
.36437 .6788 m .39849 .69321 L .35828 .68684 L .492 .888 0 r
F
.36437 .6788 m .4048 .68525 L .39849 .69321 L F
.37683 .15276 m .36669 .6918 L .40735 .69823 L .728 .968 0 r
F
.38244 .14252 m .37683 .15276 L .36669 .6918 L .448 .596 0 r
F
.28145 .15261 m .2554 .6747 L .26087 .66658 L .191 .535 0 r
F
.24442 .1444 m .26087 .66658 L .28145 .15261 L .345 .969 0 r
F
.71795 .15245 m .74716 .66301 L .78572 .66954 L .966 .44 0 r
F
.71795 .15245 m .73871 .67115 L .74716 .66301 L .742 .338 0 r
F
.39882 .86615 m .42947 .87737 L .3931 .87241 L 0 .33 .876 r
F
.39882 .86615 m .43537 .87117 L .42947 .87737 L F
.44556 .15182 m .44369 .68585 L .48395 .6923 L .92 .968 0 r
F
.45155 .14157 m .44556 .15182 L .44369 .68585 L .601 .633 0 r
F
.35013 .15168 m .3314 .67653 L .33734 .66842 L .321 .579 0 r
F
.31339 .14346 m .33734 .66842 L .35013 .15168 L .537 .969 0 r
F
.78686 .15152 m .82746 .71092 L .86601 .71728 L .965 .249 0 r
F
.78686 .15152 m .81843 .71884 L .82746 .71092 L .761 .196 0 r
F
.46827 .86639 m .49824 .87761 L .46216 .87264 L 0 .503 .876 r
F
.46827 .86639 m .50453 .87141 L .49824 .87761 L F
.51435 .15089 m .52064 .68163 L .56051 .6881 L .967 .824 0 r
F
.52073 .14063 m .51435 .15089 L .52064 .68163 L .665 .567 0 r
F
.41889 .15074 m .40735 .69823 L .4138 .69021 L .465 .618 0 r
F
.38244 .14252 m .4138 .69021 L .41889 .15074 L .728 .968 0 r
F
.85585 .15058 m .90086 .66237 L .93871 .66891 L .964 .058 0 r
F
.85585 .15058 m .89146 .67052 L .90086 .66237 L .779 .047 0 r
F
.58322 .14995 m .59759 .67828 L .63708 .68477 L .967 .632 0 r
F
.58999 .13968 m .58322 .14995 L .59759 .67828 L .694 .454 0 r
F
.48771 .1498 m .48395 .6923 L .49087 .68424 L .62 .653 0 r
F
.45155 .14157 m .49087 .68424 L .48771 .1498 L .919 .968 0 r
F
.18197 .13057 m .21484 .14917 L .17745 .14094 L .34 .954 0 r
F
.18197 .13057 m .21955 .13889 L .21484 .14917 L F
.17745 .14094 m .18704 .65521 L .21484 .14917 L .345 .97 0 r
F
.21955 .13889 m .21484 .14917 L .18704 .65521 L .173 .485 0 r
F
.65215 .14901 m .67403 .66283 L .71305 .66938 L .966 .441 0 r
F
.65931 .13873 m .65215 .14901 L .67403 .66283 L .719 .328 0 r
F
.5566 .14887 m .56051 .6881 L .5679 .68002 L .683 .582 0 r
F
.52073 .14063 m .5679 .68002 L .5566 .14887 L .967 .824 0 r
F
.25143 .12961 m .28362 .14823 L .24651 .13999 L .529 .954 0 r
F
.25143 .12961 m .28872 .13795 L .28362 .14823 L F
.24651 .13999 m .26336 .65962 L .28362 .14823 L .537 .969 0 r
F
.28872 .13795 m .28362 .14823 L .26336 .65962 L .297 .535 0 r
F
.62557 .14793 m .63708 .68477 L .64495 .67667 L .71 .464 0 r
F
.58999 .13968 m .64495 .67667 L .62557 .14793 L .966 .632 0 r
F
.60751 .8693 m .63614 .88052 L .60061 .87555 L 0 .849 .875 r
F
.60751 .8693 m .64321 .87432 L .63614 .88052 L F
.32096 .12865 m .35247 .1473 L .31565 .13904 L .717 .954 0 r
F
.32096 .12865 m .35795 .137 L .35247 .1473 L F
.31565 .13904 m .33972 .6727 L .35247 .1473 L .728 .968 0 r
F
.35795 .137 m .35247 .1473 L .33972 .6727 L .436 .579 0 r
F
.79024 .14714 m .82779 .65874 L .86607 .66531 L .965 .058 0 r
F
.79818 .13683 m .79024 .14714 L .82779 .65874 L .761 .046 0 r
F
.6946 .14699 m .71305 .66938 L .72137 .6612 L .733 .334 0 r
F
.65931 .13873 m .72137 .6612 L .6946 .14699 L .966 .44 0 r
F
.39056 .12769 m .42139 .14636 L .38486 .13809 L .906 .954 0 r
F
.39056 .12769 m .42726 .13605 L .42139 .14636 L F
.38486 .13809 m .41677 .66588 L .42139 .14636 L .92 .968 0 r
F
.42726 .13605 m .42139 .14636 L .41677 .66588 L .588 .618 0 r
F
.19834 .84259 m .2311 .85408 L .19372 .84899 L .018 0 .88 r
F
.19834 .84259 m .23591 .84773 L .2311 .85408 L F
.06764 .79968 m .10172 .81161 L .06375 .80633 L .194 0 .888 r
F
.06764 .79968 m .10581 .80502 L .10172 .81161 L F
.46023 .12673 m .49037 .14542 L .45414 .13715 L .954 .813 0 r
F
.46023 .12673 m .49664 .13509 L .49037 .14542 L F
.45414 .13715 m .49373 .66167 L .49037 .14542 L .967 .824 0 r
F
.49664 .13509 m .49037 .14542 L .49373 .66167 L .653 .556 0 r
F
.17552 .14535 m .14261 .66161 L .18436 .66819 L .153 .97 0 r
F
.17552 .14535 m .13785 .6698 L .14261 .66161 L .071 .452 0 r
F
.83288 .14511 m .86607 .66531 L .87535 .6571 L .772 .046 0 r
F
.79818 .13683 m .87535 .6571 L .83288 .14511 L .964 .058 0 r
F
.52997 .12577 m .55943 .14447 L .52349 .1362 L .954 .624 0 r
F
.52997 .12577 m .56609 .13414 L .55943 .14447 L F
.52349 .1362 m .57094 .66958 L .55943 .14447 L .967 .632 0 r
F
.56609 .13414 m .55943 .14447 L .57094 .66958 L .683 .447 0 r
F
.24442 .1444 m .21947 .65999 L .26087 .66658 L .345 .969 0 r
F
.24442 .1444 m .21424 .66819 L .21947 .65999 L .18 .506 0 r
F
.74731 .87305 m .77458 .88424 L .7396 .87929 L 0 .874 .554 r
F
.74731 .87305 m .78245 .87806 L .77458 .88424 L F
.59979 .12481 m .62856 .14353 L .59291 .13524 L .954 .435 0 r
F
.59979 .12481 m .63561 .13319 L .62856 .14353 L F
.59291 .13524 m .64786 .66016 L .62856 .14353 L .966 .441 0 r
F
.63561 .13319 m .62856 .14353 L .64786 .66016 L .71 .324 0 r
F
.31339 .14346 m .29629 .66183 L .33734 .66842 L .537 .969 0 r
F
.31339 .14346 m .29057 .67003 L .29629 .66183 L .307 .554 0 r
F
.26764 .84931 m .29977 .86075 L .26263 .85569 L 0 .156 .878 r
F
.26764 .84931 m .30497 .85443 L .29977 .86075 L F
.66968 .12384 m .69776 .14259 L .66241 .13429 L .954 .246 0 r
F
.66968 .12384 m .7052 .13223 L .69776 .14259 L F
.66241 .13429 m .7269 .69426 L .69776 .14259 L .966 .249 0 r
F
.7052 .13223 m .69776 .14259 L .7269 .69426 L .733 .189 0 r
F
.38244 .14252 m .37292 .6837 L .4138 .69021 L .728 .968 0 r
F
.38244 .14252 m .36669 .6918 L .37292 .6837 L .448 .596 0 r
F
.73964 .12288 m .76704 .14164 L .73197 .13334 L .954 .057 0 r
F
.73964 .12288 m .77487 .13128 L .76704 .14164 L F
.73197 .13334 m .80193 .65259 L .76704 .14164 L .965 .058 0 r
F
.77487 .13128 m .76704 .14164 L .80193 .65259 L .754 .045 0 r
F
.45155 .14157 m .45039 .67771 L .49087 .68424 L .919 .968 0 r
F
.45155 .14157 m .44369 .68585 L .45039 .67771 L .601 .633 0 r
F
.17745 .14094 m .14527 .64856 L .18704 .65521 L .345 .97 0 r
F
.18197 .13057 m .17745 .14094 L .14527 .64856 L .161 .452 0 r
F
.52073 .14063 m .52782 .67347 L .5679 .68002 L .967 .824 0 r
F
.52073 .14063 m .52064 .68163 L .52782 .67347 L .665 .567 0 r
F
.24651 .13999 m .2219 .65298 L .26336 .65962 L .537 .969 0 r
F
.25143 .12961 m .24651 .13999 L .2219 .65298 L .28 .506 0 r
F
.58999 .13968 m .60525 .6701 L .64495 .67667 L .966 .632 0 r
F
.58999 .13968 m .59759 .67828 L .60525 .6701 L .694 .454 0 r
F
.29629 .66183 m .3314 .67653 L .29057 .67003 L .493 .89 0 r
F
.29629 .66183 m .33734 .66842 L .3314 .67653 L F
.31565 .13904 m .2985 .66611 L .33972 .6727 L .728 .968 0 r
F
.32096 .12865 m .31565 .13904 L .2985 .66611 L .416 .554 0 r
F
.21955 .13889 m .18704 .65521 L .19212 .64691 L .173 .485 0 r
F
.18197 .13057 m .19212 .64691 L .21955 .13889 L .345 .969 0 r
F
.65931 .13873 m .68215 .65457 L .72137 .6612 L .966 .44 0 r
F
.65931 .13873 m .67403 .66283 L .68215 .65457 L .719 .328 0 r
F
.13604 .81684 m .16957 .82863 L .13175 .82341 L .018 0 .884 r
F
.13604 .81684 m .17405 .82212 L .16957 .82863 L F
.40713 .85547 m .43793 .86688 L .40132 .86183 L 0 .503 .877 r
F
.40713 .85547 m .44392 .86057 L .43793 .86688 L F
.38486 .13809 m .37596 .65926 L .41677 .66588 L .92 .968 0 r
F
.39056 .12769 m .38486 .13809 L .37596 .65926 L .566 .596 0 r
F
.28872 .13795 m .26336 .65962 L .26892 .65134 L .297 .535 0 r
F
.25143 .12961 m .26892 .65134 L .28872 .13795 L .537 .969 0 r
F
.45414 .13715 m .45332 .65503 L .49373 .66167 L .967 .824 0 r
F
.46023 .12673 m .45414 .13715 L .45332 .65503 L .633 .539 0 r
F
.35795 .137 m .33972 .6727 L .34578 .66447 L .436 .579 0 r
F
.32096 .12865 m .34578 .66447 L .35795 .137 L .728 .968 0 r
F
.79818 .13683 m .83687 .65044 L .87535 .6571 L .964 .058 0 r
F
.79818 .13683 m .82779 .65874 L .83687 .65044 L .761 .046 0 r
F
.52349 .1362 m .53082 .66296 L .57094 .66958 L .967 .632 0 r
F
.52997 .12577 m .52349 .1362 L .53082 .66296 L .665 .435 0 r
F
.42726 .13605 m .41677 .66588 L .4233 .65762 L .588 .618 0 r
F
.39056 .12769 m .4233 .65762 L .42726 .13605 L .919 .968 0 r
F
.59291 .13524 m .60818 .6535 L .64786 .66016 L .966 .441 0 r
F
.59979 .12481 m .59291 .13524 L .60818 .6535 L .694 .316 0 r
F
.49664 .13509 m .49373 .66167 L .50075 .65338 L .653 .556 0 r
F
.46023 .12673 m .50075 .65338 L .49664 .13509 L .967 .824 0 r
F
.54726 .8592 m .57671 .8706 L .54065 .86555 L 0 .849 .876 r
F
.54726 .8592 m .58349 .8643 L .57671 .8706 L F
.61739 .85616 m .64612 .86758 L .61038 .86253 L 0 .876 .729 r
F
.18852 .11555 m .22159 .13445 L .18392 .12608 L .529 .954 0 r
F
.18852 .11555 m .22638 .12401 L .22159 .13445 L F
.18392 .12608 m .19319 .66418 L .22159 .13445 L .537 .969 0 r
F
.22638 .12401 m .22159 .13445 L .19319 .66418 L .269 .485 0 r
F
.67134 .68448 m .71041 .69093 L .7022 .69889 L .887 .58 0 r
F
.68215 .65457 m .71305 .66938 L .67403 .66283 L .89 .406 0 r
F
.68215 .65457 m .72137 .6612 L .71305 .66938 L F
.66241 .13429 m .68731 .68773 L .7269 .69426 L .966 .249 0 r
F
.66968 .12384 m .66241 .13429 L .68731 .68773 L .719 .186 0 r
F
.56609 .13414 m .57094 .66958 L .57846 .66132 L .683 .447 0 r
F
.52997 .12577 m .57846 .66132 L .56609 .13414 L .966 .632 0 r
F
.25854 .11457 m .29092 .1335 L .25355 .12512 L .717 .954 0 r
F
.25854 .11457 m .2961 .12304 L .29092 .1335 L F
.25355 .12512 m .27195 .63133 L .29092 .1335 L .728 .968 0 r
F
.2961 .12304 m .29092 .1335 L .27195 .63133 L .402 .535 0 r
F
.73197 .13334 m .76302 .64589 L .80193 .65259 L .965 .058 0 r
F
.73964 .12288 m .73197 .13334 L .76302 .64589 L .742 .044 0 r
F
.63561 .13319 m .64786 .66016 L .65585 .65185 L .71 .324 0 r
F
.59979 .12481 m .65585 .65185 L .63561 .13319 L .966 .44 0 r
F
.07364 .78521 m .1079 .79736 L .06969 .79198 L .018 0 .889 r
F
.07364 .78521 m .11205 .79065 L .1079 .79736 L F
.32864 .1136 m .36032 .13255 L .32325 .12416 L .906 .954 0 r
F
.32864 .1136 m .3659 .12208 L .36032 .13255 L F
.32325 .12416 m .34912 .62883 L .36032 .13255 L .92 .968 0 r
F
.3659 .12208 m .36032 .13255 L .34912 .62883 L .551 .579 0 r
F
.7052 .13223 m .7269 .69426 L .73545 .68611 L .733 .189 0 r
F
.66968 .12384 m .73545 .68611 L .7052 .13223 L .965 .249 0 r
F
.39881 .11262 m .4298 .13159 L .39302 .1232 L .954 .813 0 r
F
.39881 .11262 m .43577 .12111 L .4298 .13159 L F
.39302 .1232 m .42613 .65317 L .4298 .13159 L .967 .824 0 r
F
.43577 .12111 m .4298 .13159 L .42613 .65317 L .618 .527 0 r
F
.68792 .86213 m .71599 .87351 L .68049 .86847 L 0 .875 .554 r
F
.68792 .86213 m .72358 .86722 L .71599 .87351 L F
.77487 .13128 m .80193 .65259 L .81088 .64423 L .754 .045 0 r
F
.73964 .12288 m .81088 .64423 L .77487 .13128 L .964 .058 0 r
F
.20491 .83576 m .23789 .84742 L .20022 .84226 L 0 .157 .88 r
F
.20491 .83576 m .24278 .84098 L .23789 .84742 L F
.46905 .11165 m .49935 .13063 L .46286 .12223 L .954 .624 0 r
F
.46905 .11165 m .50571 .12015 L .49935 .13063 L F
.46286 .12223 m .50377 .64893 L .49935 .13063 L .967 .632 0 r
F
.50571 .12015 m .49935 .13063 L .50377 .64893 L .653 .427 0 r
F
.18197 .13057 m .1501 .64019 L .19212 .64691 L .345 .969 0 r
F
.18197 .13057 m .14527 .64856 L .1501 .64019 L .161 .452 0 r
F
.53936 .11067 m .56897 .12968 L .53277 .12127 L .954 .435 0 r
F
.53936 .11067 m .57573 .11918 L .56897 .12968 L F
.53277 .12127 m .58122 .63773 L .56897 .12968 L .966 .441 0 r
F
.57573 .11918 m .56897 .12968 L .58122 .63773 L .683 .311 0 r
F
.25143 .12961 m .22723 .64462 L .26892 .65134 L .537 .969 0 r
F
.25143 .12961 m .2219 .65298 L .22723 .64462 L .28 .506 0 r
F
.60975 .10969 m .63866 .12872 L .60276 .1203 L .954 .246 0 r
F
.60975 .10969 m .64582 .11821 L .63866 .12872 L F
.60975 .10969 m .63866 .12872 L .60276 .1203 L F
.60975 .10969 m .64582 .11821 L .63866 .12872 L F
.32096 .12865 m .30433 .6578 L .34578 .66447 L .728 .968 0 r
F
.32096 .12865 m .2985 .66611 L .30433 .6578 L .416 .554 0 r
F
.68021 .10872 m .70842 .12776 L .67282 .11933 L .954 .057 0 r
F
.68021 .10872 m .71598 .11724 L .70842 .12776 L F
.67282 .11933 m .73677 .63966 L .70842 .12776 L .965 .058 0 r
F
.71598 .11724 m .70842 .12776 L .73677 .63966 L .733 .044 0 r
F
.39056 .12769 m .38227 .65092 L .4233 .65762 L .919 .968 0 r
F
.39056 .12769 m .37596 .65926 L .38227 .65092 L .566 .596 0 r
F
.34527 .83783 m .37687 .84949 L .33977 .84433 L 0 .504 .879 r
F
.34527 .83783 m .38255 .84305 L .37687 .84949 L F
.46023 .12673 m .46011 .64666 L .50075 .65338 L .967 .824 0 r
F
.46023 .12673 m .45332 .65503 L .46011 .64666 L .633 .539 0 r
F
.14271 .79998 m .17639 .81203 L .13836 .8067 L 0 .158 .885 r
F
.14271 .79998 m .18095 .80538 L .17639 .81203 L F
.1501 .64019 m .18704 .65521 L .14527 .64856 L .317 .892 0 r
F
.1501 .64019 m .19212 .64691 L .18704 .65521 L F
.18392 .12608 m .1509 .6575 L .19319 .66418 L .537 .969 0 r
F
.18852 .11555 m .18392 .12608 L .1509 .6575 L .25 .452 0 r
F
.52997 .12577 m .53812 .65462 L .57846 .66132 L .966 .632 0 r
F
.52997 .12577 m .53082 .66296 L .53812 .65462 L .665 .435 0 r
F
.25355 .12512 m .2303 .62452 L .27195 .63133 L .728 .968 0 r
F
.25854 .11457 m .25355 .12512 L .2303 .62452 L .38 .506 0 r
F
.59979 .12481 m .61595 .64511 L .65585 .65185 L .966 .44 0 r
F
.59979 .12481 m .60818 .6535 L .61595 .64511 L .694 .316 0 r
F
.32325 .12416 m .30784 .622 L .34912 .62883 L .92 .968 0 r
F
.32864 .1136 m .32325 .12416 L .30784 .622 L .526 .554 0 r
F
.22638 .12401 m .19319 .66418 L .19837 .65584 L .269 .485 0 r
F
.18852 .11555 m .19837 .65584 L .22638 .12401 L .537 .969 0 r
F
.66968 .12384 m .69565 .67949 L .73545 .68611 L .965 .249 0 r
F
.66968 .12384 m .68731 .68773 L .69565 .67949 L .719 .186 0 r
F
.39302 .1232 m .38501 .64643 L .42613 .65317 L .967 .824 0 r
F
.39881 .11262 m .39302 .1232 L .38501 .64643 L .596 .508 0 r
F
.2961 .12304 m .27195 .63133 L .27759 .62282 L .402 .535 0 r
F
.25854 .11457 m .27759 .62282 L .2961 .12304 L .728 .968 0 r
F
.21271 .80588 m .24574 .81789 L .20795 .81257 L 0 .332 .884 r
F
.21271 .80588 m .25069 .81126 L .24574 .81789 L F
.73964 .12288 m .77177 .63745 L .81088 .64423 L .964 .058 0 r
F
.73964 .12288 m .76302 .64589 L .77177 .63745 L .742 .044 0 r
F
.46286 .12223 m .46305 .64216 L .50377 .64893 L .967 .632 0 r
F
.46905 .11165 m .46286 .12223 L .46305 .64216 L .633 .414 0 r
F
.48612 .84648 m .51638 .85808 L .47981 .85295 L 0 .85 .877 r
F
.48612 .84648 m .52288 .85167 L .51638 .85808 L F
.3659 .12208 m .34912 .62883 L .35525 .62031 L .551 .579 0 r
F
.32864 .1136 m .35525 .62031 L .3659 .12208 L .919 .968 0 r
F
.53277 .12127 m .54096 .63093 L .58122 .63773 L .966 .441 0 r
F
.53936 .11067 m .53277 .12127 L .54096 .63093 L .665 .303 0 r
F
.55677 .84589 m .58633 .8575 L .55005 .85236 L 0 .877 .729 r
F
.55677 .84589 m .59322 .85108 L .58633 .8575 L F
.43577 .12111 m .42613 .65317 L .43278 .64476 L .618 .527 0 r
F
.39881 .11262 m .43278 .64476 L .43577 .12111 L .967 .824 0 r
F
.50571 .12015 m .50377 .64893 L .51091 .64048 L .653 .427 0 r
F
.46905 .11165 m .51091 .64048 L .50571 .12015 L .966 .632 0 r
F
.19518 .10028 m .22845 .1195 L .1905 .11099 L .717 .954 0 r
F
.19518 .10028 m .23331 .10888 L .22845 .1195 L F
.1905 .11099 m .20365 .59406 L .22845 .1195 L .728 .968 0 r
F
.23331 .10888 m .22845 .1195 L .20365 .59406 L .365 .485 0 r
F
.67282 .11933 m .69721 .63284 L .73677 .63966 L .965 .058 0 r
F
.68021 .10872 m .67282 .11933 L .69721 .63284 L .719 .043 0 r
F
.57573 .11918 m .58122 .63773 L .58884 .62923 L .683 .311 0 r
F
.53936 .11067 m .58884 .62923 L .57573 .11918 L .966 .44 0 r
F
.26577 .09929 m .29834 .11853 L .2607 .11001 L .906 .954 0 r
F
.26577 .09929 m .30361 .1079 L .29834 .11853 L F
.2607 .11001 m .28145 .58042 L .29834 .11853 L .92 .968 0 r
F
.30361 .1079 m .29834 .11853 L .28145 .58042 L .508 .535 0 r
F
.62765 .85023 m .65653 .86182 L .62052 .85669 L 0 .875 .555 r
F
.62765 .85023 m .66383 .85542 L .65653 .86182 L F
.33645 .0983 m .36831 .11756 L .33097 .10904 L .954 .813 0 r
F
.33645 .0983 m .37398 .10692 L .36831 .11756 L F
.33097 .10904 m .35739 .64102 L .36831 .11756 L .967 .824 0 r
F
.37398 .10692 m .36831 .11756 L .35739 .64102 L .579 .494 0 r
F
.69851 .84963 m .72669 .86123 L .69098 .8561 L 0 .875 .382 r
F
.69851 .84963 m .73439 .85483 L .72669 .86123 L F
.71598 .11724 m .73677 .63966 L .74538 .63115 L .733 .044 0 r
F
.68021 .10872 m .74538 .63115 L .71598 .11724 L .964 .058 0 r
F
.2827 .81917 m .31512 .83108 L .27753 .82581 L 0 .506 .881 r
F
.2827 .81917 m .32049 .8245 L .31512 .83108 L F
.40719 .09731 m .43835 .11659 L .40131 .10806 L .954 .624 0 r
F
.40719 .09731 m .44442 .10594 L .43835 .11659 L F
.40131 .10806 m .43567 .63761 L .43835 .11659 L .967 .632 0 r
F
.44442 .10594 m .43835 .11659 L .43567 .63761 L .618 .404 0 r
F
.47801 .09632 m .50846 .11562 L .47172 .10708 L .954 .435 0 r
F
.47801 .09632 m .51494 .10496 L .50846 .11562 L F
.47172 .10708 m .51387 .6246 L .50846 .11562 L .966 .441 0 r
F
.51494 .10496 m .50846 .11562 L .51387 .6246 L .653 .298 0 r
F
.18852 .11555 m .15583 .64906 L .19837 .65584 L .537 .969 0 r
F
.18852 .11555 m .1509 .6575 L .15583 .64906 L .25 .452 0 r
F
.54891 .09533 m .57865 .11464 L .54221 .10609 L .954 .246 0 r
F
.54891 .09533 m .58552 .10397 L .57865 .11464 L F
.54221 .10609 m .59313 .66335 L .57865 .11464 L .966 .249 0 r
F
.58552 .10397 m .57865 .11464 L .59313 .66335 L .683 .176 0 r
F
.25854 .11457 m .23571 .61592 L .27759 .62282 L .728 .968 0 r
F
.25854 .11457 m .2303 .62452 L .23571 .61592 L .38 .506 0 r
F
.61988 .09433 m .64891 .11367 L .61277 .10511 L .954 .057 0 r
F
.61988 .09433 m .65619 .10299 L .64891 .11367 L F
.61277 .10511 m .67054 .62652 L .64891 .11367 L .965 .058 0 r
F
.65619 .10299 m .64891 .11367 L .67054 .62652 L .71 .043 0 r
F
.32864 .1136 m .31374 .61339 L .35525 .62031 L .919 .968 0 r
F
.32864 .1136 m .30784 .622 L .31374 .61339 L .526 .554 0 r
F
.39881 .11262 m .39144 .63793 L .43278 .64476 L .967 .824 0 r
F
.39881 .11262 m .38501 .64643 L .39144 .63793 L .596 .508 0 r
F
.46905 .11165 m .46997 .63363 L .51091 .64048 L .966 .632 0 r
F
.46905 .11165 m .46305 .64216 L .46997 .63363 L .633 .414 0 r
F
.1905 .11099 m .16152 .58704 L .20365 .59406 L .728 .968 0 r
F
.19518 .10028 m .1905 .11099 L .16152 .58704 L .34 .452 0 r
F
.53936 .11067 m .54836 .62234 L .58884 .62923 L .966 .44 0 r
F
.53936 .11067 m .54096 .63093 L .54836 .62234 L .665 .303 0 r
F
.2607 .11001 m .2398 .57334 L .28145 .58042 L .92 .968 0 r
F
.26577 .09929 m .2607 .11001 L .2398 .57334 L .481 .506 0 r
F
.31374 .61339 m .34912 .62883 L .30784 .622 L .849 .894 0 r
F
.31374 .61339 m .35525 .62031 L .34912 .62883 L F
.33097 .10904 m .31558 .63416 L .35739 .64102 L .967 .824 0 r
F
.33645 .0983 m .33097 .10904 L .31558 .63416 L .554 .472 0 r
F
.23331 .10888 m .20365 .59406 L .20888 .58529 L .365 .485 0 r
F
.19518 .10028 m .20888 .58529 L .23331 .10888 L .728 .968 0 r
F
.68021 .10872 m .70561 .62425 L .74538 .63115 L .964 .058 0 r
F
.68021 .10872 m .69721 .63284 L .70561 .62425 L .719 .043 0 r
F
.42412 .83607 m .45524 .84786 L .41811 .84264 L 0 .851 .877 r
F
.42412 .83607 m .46143 .84135 L .45524 .84786 L F
.40131 .10806 m .39426 .63074 L .43567 .63761 L .967 .632 0 r
F
.40719 .09731 m .40131 .10806 L .39426 .63074 L .596 .39 0 r
F
.30361 .1079 m .28145 .58042 L .28716 .57158 L .508 .535 0 r
F
.26577 .09929 m .28716 .57158 L .30361 .1079 L .919 .968 0 r
F
.49525 .83463 m .52565 .84644 L .48884 .84122 L 0 .877 .73 r
F
.49525 .83463 m .53225 .83992 L .52565 .84644 L F
.47172 .10708 m .47293 .61767 L .51387 .6246 L .966 .441 0 r
F
.47801 .09632 m .47172 .10708 L .47293 .61767 L .633 .289 0 r
F
.37398 .10692 m .35739 .64102 L .36366 .63246 L .579 .494 0 r
F
.33645 .0983 m .36366 .63246 L .37398 .10692 L .967 .824 0 r
F
.54836 .62234 m .58122 .63773 L .54096 .63093 L .892 .407 0 r
F
.54836 .62234 m .58884 .62923 L .58122 .63773 L F
.54221 .10609 m .55225 .65656 L .59313 .66335 L .966 .249 0 r
F
.54891 .09533 m .54221 .10609 L .55225 .65656 L .665 .172 0 r
F
.44442 .10594 m .43567 .63761 L .44244 .62903 L .618 .404 0 r
F
.40719 .09731 m .44244 .62903 L .44442 .10594 L .966 .632 0 r
F
.56653 .83817 m .59624 .84996 L .5597 .84474 L 0 .876 .555 r
F
.56653 .83817 m .60325 .84344 L .59624 .84996 L F
.61277 .10511 m .63033 .61958 L .67054 .62652 L .965 .058 0 r
F
.61988 .09433 m .61277 .10511 L .63033 .61958 L .694 .042 0 r
F
.51494 .10496 m .51387 .6246 L .52112 .61595 L .653 .298 0 r
F
.47801 .09632 m .52112 .61595 L .51494 .10496 L .966 .44 0 r
F
.20194 .08476 m .23541 .1043 L .19719 .09565 L .906 .954 0 r
F
.20194 .08476 m .24036 .09351 L .23541 .1043 L F
.19719 .09565 m .21332 .5387 L .23541 .1043 L .92 .968 0 r
F
.24036 .09351 m .23541 .1043 L .21332 .5387 L .461 .485 0 r
F
.58552 .10397 m .59313 .66335 L .60095 .65487 L .683 .176 0 r
F
.54891 .09533 m .60095 .65487 L .58552 .10397 L .965 .249 0 r
F
.63792 .83922 m .66692 .85101 L .63068 .84579 L 0 .876 .382 r
F
.63792 .83922 m .67434 .84449 L .66692 .85101 L F
.27313 .08376 m .30588 .10331 L .26797 .09466 L .954 .813 0 r
F
.27313 .08376 m .31123 .09251 L .30588 .10331 L F
.26577 .09929 m .24528 .56442 L .28716 .57158 L .919 .968 0 r
F
.24528 .56442 m .28716 .57158 L .28145 .58042 L .856 .901 0 r
F
.26797 .09466 m .2875 .62867 L .30588 .10331 L .967 .824 0 r
F
.31123 .09251 m .30588 .10331 L .2875 .62867 L .535 .456 0 r
F
.65619 .10299 m .67054 .62652 L .6788 .61786 L .71 .043 0 r
F
.61988 .09433 m .6788 .61786 L .65619 .10299 L .964 .058 0 r
F
.29025 .8079 m .32285 .82002 L .28499 .81466 L 0 .68 .881 r
F
.29025 .8079 m .3283 .81333 L .32285 .82002 L F
.34438 .08275 m .37642 .10233 L .33881 .09366 L .954 .624 0 r
F
.34438 .08275 m .38218 .09151 L .37642 .10233 L F
.33881 .09366 m .3665 .62171 L .37642 .10233 L .967 .632 0 r
F
.38218 .09151 m .37642 .10233 L .3665 .62171 L .579 .379 0 r
F
.41572 .08175 m .44704 .10134 L .40973 .09267 L .954 .435 0 r
F
.41572 .08175 m .45321 .09052 L .44704 .10134 L F
.40973 .09267 m .4454 .61301 L .44704 .10134 L .966 .441 0 r
F
.45321 .09052 m .44704 .10134 L .4454 .61301 L .618 .282 0 r
F
.48712 .08074 m .51773 .10035 L .48073 .09167 L .954 .246 0 r
F
.48712 .08074 m .52431 .08952 L .51773 .10035 L F
.48712 .08074 m .51773 .10035 L .48073 .09167 L F
.48712 .08074 m .52431 .08952 L .51773 .10035 L F
.19518 .10028 m .16651 .57818 L .20888 .58529 L .728 .968 0 r
F
.19518 .10028 m .16152 .58704 L .16651 .57818 L .34 .452 0 r
F
.55861 .07973 m .58849 .09936 L .5518 .09067 L .954 .057 0 r
F
.55861 .07973 m .59548 .08852 L .58849 .09936 L F
.5518 .09067 m .60321 .61228 L .58849 .09936 L .965 .058 0 r
F
.59548 .08852 m .58849 .09936 L .60321 .61228 L .683 .041 0 r
F
.26577 .09929 m .2398 .57334 L .24528 .56442 L .481 .506 0 r
F
.08434 .7769 m .11913 .78936 L .08025 .78385 L 0 .333 .886 r
F
.33645 .0983 m .32161 .62551 L .36366 .63246 L .967 .824 0 r
F
.33645 .0983 m .31558 .63416 L .32161 .62551 L .554 .472 0 r
F
.36136 .8172 m .3933 .82925 L .35568 .82392 L 0 .853 .879 r
F
.36136 .8172 m .39917 .8226 L .3933 .82925 L F
.40719 .09731 m .4008 .62206 L .44244 .62903 L .966 .632 0 r
F
.40719 .09731 m .39426 .63074 L .4008 .62206 L .596 .39 0 r
F
.47801 .09632 m .47995 .60893 L .52112 .61595 L .966 .44 0 r
F
.47801 .09632 m .47293 .61767 L .47995 .60893 L .633 .289 0 r
F
.19719 .09565 m .17123 .5314 L .21332 .5387 L .92 .968 0 r
F
.20194 .08476 m .19719 .09565 L .17123 .5314 L .429 .452 0 r
F
.54891 .09533 m .55984 .64799 L .60095 .65487 L .965 .249 0 r
F
.54891 .09533 m .55225 .65656 L .55984 .64799 L .665 .172 0 r
F
.43284 .82239 m .4641 .83441 L .42674 .82909 L 0 .878 .73 r
F
.43284 .82239 m .47039 .82777 L .4641 .83441 L F
.23571 .61592 m .27195 .63133 L .2303 .62452 L .672 .894 0 r
F
.23571 .61592 m .27759 .62282 L .27195 .63133 L F
.24528 .56442 m .28145 .58042 L .2398 .57334 L .856 .901 0 r
F
.26797 .09466 m .24498 .62168 L .2875 .62867 L .967 .824 0 r
F
.27313 .08376 m .26797 .09466 L .24498 .62168 L .506 .431 0 r
F
.61988 .09433 m .63837 .61083 L .6788 .61786 L .964 .058 0 r
F
.61988 .09433 m .63033 .61958 L .63837 .61083 L .694 .042 0 r
F
.33881 .09366 m .32441 .6147 L .3665 .62171 L .967 .632 0 r
F
.34438 .08275 m .33881 .09366 L .32441 .6147 L .554 .362 0 r
F
.24036 .09351 m .21332 .5387 L .21861 .52958 L .461 .485 0 r
F
.20194 .08476 m .21861 .52958 L .24036 .09351 L .919 .968 0 r
F
.40973 .09267 m .40377 .60596 L .4454 .61301 L .966 .441 0 r
F
.41572 .08175 m .40973 .09267 L .40377 .60596 L .596 .272 0 r
F
.31123 .09251 m .2875 .62867 L .29337 .61995 L .535 .456 0 r
F
.27313 .08376 m .29337 .61995 L .31123 .09251 L .967 .824 0 r
F
.50455 .82593 m .53511 .83793 L .49803 .83262 L 0 .877 .556 r
F
.50455 .82593 m .54181 .8313 L .53511 .83793 L F
.38218 .09151 m .3665 .62171 L .37287 .61296 L .579 .379 0 r
F
.34438 .08275 m .37287 .61296 L .38218 .09151 L .966 .632 0 r
F
.64812 .82136 m .6772 .83341 L .64076 .82808 L 0 .878 .209 r
F
.64812 .82136 m .68473 .82676 L .6772 .83341 L F
.57637 .82614 m .60621 .83815 L .56943 .83284 L 0 .877 .382 r
F
.57637 .82614 m .61333 .83152 L .60621 .83815 L F
.5518 .09067 m .56233 .60522 L .60321 .61228 L .965 .058 0 r
F
.55861 .07973 m .5518 .09067 L .56233 .60522 L .665 .04 0 r
F
.45321 .09052 m .4454 .61301 L .45228 .60421 L .618 .282 0 r
F
.41572 .08175 m .45228 .60421 L .45321 .09052 L .966 .44 0 r
F
.20882 .06899 m .2425 .08885 L .20399 .08006 L .954 .813 0 r
F
.20882 .06899 m .24752 .07788 L .2425 .08885 L F
.20194 .08476 m .17629 .52219 L .21861 .52958 L .919 .968 0 r
F
.17629 .52219 m .21861 .52958 L .21332 .5387 L .86 .906 0 r
F
.20399 .08006 m .21564 .6321 L .2425 .08885 L .967 .824 0 r
F
.24752 .07788 m .2425 .08885 L .21564 .6321 L .485 .413 0 r
F
.22616 .79626 m .25966 .80859 L .22124 .80313 L 0 .681 .882 r
F
.22616 .79626 m .26478 .80178 L .25966 .80859 L F
.59548 .08852 m .60321 .61228 L .61111 .60346 L .683 .041 0 r
F
.55861 .07973 m .61111 .60346 L .59548 .08852 L .964 .058 0 r
F
.2806 .06797 m .31355 .08784 L .27535 .07905 L .954 .624 0 r
F
.2806 .06797 m .31899 .07687 L .31355 .08784 L F
.27535 .07905 m .29594 .6153 L .31355 .08784 L .967 .632 0 r
F
.31899 .07687 m .31355 .08784 L .29594 .6153 L .535 .35 0 r
F
.29792 .79645 m .3307 .80879 L .29258 .80333 L 0 .855 .882 r
F
.29792 .79645 m .33624 .80198 L .3307 .80879 L F
.35245 .06695 m .38467 .08684 L .34679 .07804 L .954 .435 0 r
F
.35245 .06695 m .39053 .07585 L .38467 .08684 L F
.34679 .07804 m .37571 .60475 L .38467 .08684 L .966 .441 0 r
F
.39053 .07585 m .38467 .08684 L .37571 .60475 L .579 .264 0 r
F
.72053 .83075 m .74894 .84273 L .71274 .83743 L 0 .875 .035 r
F
.72053 .83075 m .7569 .83611 L .74894 .84273 L F
.42438 .06592 m .45587 .08584 L .4183 .07703 L .954 .246 0 r
F
.42438 .06592 m .46214 .07484 L .45587 .08584 L F
.4183 .07703 m .45526 .59511 L .45587 .08584 L .966 .249 0 r
F
.46214 .07484 m .45587 .08584 L .45526 .59511 L .618 .16 0 r
F
.49639 .0649 m .52715 .08484 L .48989 .07601 L .954 .057 0 r
F
.49639 .0649 m .53384 .07382 L .52715 .08484 L F
.48989 .07601 m .53466 .58814 L .52715 .08484 L .965 .058 0 r
F
.53384 .07382 m .52715 .08484 L .53466 .58814 L .653 .039 0 r
F
.20194 .08476 m .17123 .5314 L .17629 .52219 L .429 .452 0 r
F
.27313 .08376 m .25061 .61288 L .29337 .61995 L .967 .824 0 r
F
.27313 .08376 m .24498 .62168 L .25061 .61288 L .506 .431 0 r
F
.34438 .08275 m .33055 .60585 L .37287 .61296 L .966 .632 0 r
F
.34438 .08275 m .32441 .6147 L .33055 .60585 L .554 .362 0 r
F
.36959 .80747 m .40171 .81972 L .36382 .8143 L 0 .879 .731 r
F
.36959 .80747 m .40768 .81295 L .40171 .81972 L F
.41572 .08175 m .41041 .59707 L .45228 .60421 L .966 .44 0 r
F
.41572 .08175 m .40377 .60596 L .41041 .59707 L .596 .272 0 r
F
.16651 .57818 m .20365 .59406 L .16152 .58704 L .676 .898 0 r
F
.16651 .57818 m .20888 .58529 L .20365 .59406 L F
.17629 .52219 m .21332 .5387 L .17123 .5314 L .86 .906 0 r
F
.20399 .08006 m .17225 .62506 L .21564 .6321 L .967 .824 0 r
F
.20882 .06899 m .20399 .08006 L .17225 .62506 L .452 .385 0 r
F
.55861 .07973 m .57 .59631 L .61111 .60346 L .964 .058 0 r
F
.55861 .07973 m .56233 .60522 L .57 .59631 L .665 .04 0 r
F
.27535 .07905 m .25308 .60818 L .29594 .6153 L .967 .632 0 r
F
.2806 .06797 m .27535 .07905 L .25308 .60818 L .506 .331 0 r
F
.44168 .81352 m .47311 .82573 L .43548 .82033 L 0 .878 .556 r
F
.44168 .81352 m .4795 .81898 L .47311 .82573 L F
.34679 .07804 m .33332 .59759 L .37571 .60475 L .966 .441 0 r
F
.35245 .06695 m .34679 .07804 L .33332 .59759 L .554 .252 0 r
F
.24752 .07788 m .21564 .6321 L .22111 .62331 L .485 .413 0 r
F
.20882 .06899 m .22111 .62331 L .24752 .07788 L .967 .824 0 r
F
.51397 .81373 m .54467 .82594 L .50735 .82054 L 0 .877 .383 r
F
.51397 .81373 m .55149 .8192 L .54467 .82594 L F
.4183 .07703 m .41333 .58791 L .45526 .59511 L .966 .249 0 r
F
.42438 .06592 m .4183 .07703 L .41333 .58791 L .596 .154 0 r
F
.31899 .07687 m .29594 .6153 L .30192 .60641 L .535 .35 0 r
F
.2806 .06797 m .30192 .60641 L .31899 .07687 L .966 .632 0 r
F
.23367 .77797 m .26731 .79057 L .22867 .785 L 0 .857 .884 r
F
.23367 .77797 m .27252 .78361 L .26731 .79057 L F
.48989 .07601 m .49317 .5809 L .53466 .58814 L .965 .058 0 r
F
.49639 .0649 m .48989 .07601 L .49317 .5809 L .633 .038 0 r
F
.39053 .07585 m .37571 .60475 L .38219 .59581 L .579 .264 0 r
F
.35245 .06695 m .38219 .59581 L .39053 .07585 L .966 .44 0 r
F
.16123 .78278 m .19564 .79533 L .15665 .78978 L 0 .682 .883 r
F
.16123 .78278 m .20043 .7884 L .19564 .79533 L F
.65883 .8133 m .68806 .82554 L .65135 .82013 L 0 .877 .035 r
F
.65883 .8133 m .69571 .81878 L .68806 .82554 L F
.46214 .07484 m .45526 .59511 L .46225 .58613 L .618 .16 0 r
F
.42438 .06592 m .46225 .58613 L .46214 .07484 L .965 .249 0 r
F
.53384 .07382 m .53466 .58814 L .54216 .57911 L .653 .039 0 r
F
.49639 .0649 m .54216 .57911 L .53384 .07382 L .964 .058 0 r
F
.73146 .81435 m .75995 .82659 L .72356 .82117 L .139 .877 0 r
F
.73146 .81435 m .76804 .81983 L .75995 .82659 L F
.21582 .05295 m .2497 .07314 L .21091 .06421 L .954 .624 0 r
F
.21582 .05295 m .25481 .06199 L .2497 .07314 L F
.21091 .06421 m .22498 .58828 L .2497 .07314 L .967 .632 0 r
F
.25481 .06199 m .2497 .07314 L .22498 .58828 L .485 .317 0 r
F
.30572 .78482 m .33867 .79738 L .30029 .79182 L 0 .882 .734 r
F
.30572 .78482 m .3443 .79044 L .33867 .79738 L F
.2882 .05191 m .32134 .07212 L .28286 .06318 L .954 .435 0 r
F
.2882 .05191 m .32687 .06096 L .32134 .07212 L F
.28286 .06318 m .30459 .5999 L .32134 .07212 L .966 .441 0 r
F
.32687 .06096 m .32134 .07212 L .30459 .5999 L .535 .244 0 r
F
.36065 .05087 m .39306 .0711 L .3549 .06215 L .954 .246 0 r
F
.36065 .05087 m .39901 .05993 L .39306 .0711 L F
.36065 .05087 m .39306 .0711 L .3549 .06215 L F
.36065 .05087 m .39901 .05993 L .39306 .0711 L F
.43319 .04983 m .46485 .07008 L .42701 .06112 L .954 .057 0 r
F
.43319 .04983 m .47123 .0589 L .46485 .07008 L F
.42701 .06112 m .46524 .54093 L .46485 .07008 L .965 .058 0 r
F
.47123 .0589 m .46485 .07008 L .46524 .54093 L .618 .037 0 r
F
.20882 .06899 m .17747 .61617 L .22111 .62331 L .967 .824 0 r
F
.20882 .06899 m .17225 .62506 L .17747 .61617 L .452 .385 0 r
F
.2806 .06797 m .25881 .59921 L .30192 .60641 L .966 .632 0 r
F
.2806 .06797 m .25308 .60818 L .25881 .59921 L .506 .331 0 r
F
.37801 .79421 m .41029 .8067 L .37214 .80117 L 0 .88 .558 r
F
.37801 .79421 m .41635 .7998 L .41029 .8067 L F
.35245 .06695 m .33956 .58856 L .38219 .59581 L .966 .44 0 r
F
.35245 .06695 m .33332 .59759 L .33956 .58856 L .554 .252 0 r
F
.16898 .75344 m .20346 .76635 L .16433 .76064 L 0 .86 .887 r
F
.16898 .75344 m .20832 .75922 L .20346 .76635 L F
.42438 .06592 m .42009 .57883 L .46225 .58613 L .965 .249 0 r
F
.42438 .06592 m .41333 .58791 L .42009 .57883 L .596 .154 0 r
F
.49639 .0649 m .50044 .57178 L .54216 .57911 L .964 .058 0 r
F
.49639 .0649 m .49317 .5809 L .50044 .57178 L .633 .038 0 r
F
.21091 .06421 m .18151 .58098 L .22498 .58828 L .967 .632 0 r
F
.21582 .05295 m .21091 .06421 L .18151 .58098 L .452 .296 0 r
F
.45067 .80197 m .48226 .8144 L .44437 .8089 L 0 .878 .383 r
F
.45067 .80197 m .48876 .80753 L .48226 .8144 L F
.8149 .78531 m .84267 .79792 L .80647 .79234 L .488 .881 0 r
F
.8149 .78531 m .85128 .79096 L .84267 .79792 L F
.28286 .06318 m .2614 .59264 L .30459 .5999 L .966 .441 0 r
F
.2882 .05191 m .28286 .06318 L .2614 .59264 L .506 .231 0 r
F
.52353 .79965 m .55435 .8121 L .51679 .80659 L 0 .878 .209 r
F
.52353 .79965 m .56128 .80522 L .55435 .8121 L F
.25481 .06199 m .22498 .58828 L .23053 .57917 L .485 .317 0 r
F
.21582 .05295 m .23053 .57917 L .25481 .06199 L .966 .632 0 r
F
.09527 .77078 m .13062 .78355 L .09104 .7779 L 0 .682 .883 r
F
.09527 .77078 m .13506 .7765 L .13062 .78355 L F
.42701 .06112 m .42333 .53344 L .46524 .54093 L .965 .058 0 r
F
.43319 .04983 m .42701 .06112 L .42333 .53344 L .596 .036 0 r
F
.32687 .06096 m .30459 .5999 L .31068 .59084 L .535 .244 0 r
F
.2882 .05191 m .31068 .59084 L .32687 .06096 L .966 .44 0 r
F
.241 .76612 m .27483 .77894 L .23591 .77327 L 0 .884 .736 r
F
.241 .76612 m .28012 .77186 L .27483 .77894 L F
.59668 .80743 m .6268 .81984 L .5895 .81435 L 0 .877 .035 r
F
.59668 .80743 m .63416 .81298 L .6268 .81984 L F
.47123 .0589 m .46524 .54093 L .4723 .53158 L .618 .037 0 r
F
.43319 .04983 m .4723 .53158 L .47123 .0589 L .964 .058 0 r
F
.6697 .80426 m .69906 .8167 L .6621 .8112 L .139 .877 0 r
F
.6697 .80426 m .70685 .80983 L .69906 .8167 L F
.74287 .80362 m .77148 .81607 L .73483 .81056 L .312 .877 0 r
F
.74287 .80362 m .77969 .8092 L .77148 .81607 L F
.22293 .03664 m .25701 .05717 L .21794 .04809 L .954 .435 0 r
F
.22293 .03664 m .26221 .04583 L .25701 .05717 L F
.21794 .04809 m .23252 .58417 L .25701 .05717 L .966 .441 0 r
F
.26221 .04583 m .25701 .05717 L .23252 .58417 L .485 .221 0 r
F
.29592 .03559 m .32926 .05614 L .2905 .04704 L .954 .246 0 r
F
.29592 .03559 m .33488 .04479 L .32926 .05614 L F
.29592 .03559 m .32926 .05614 L .2905 .04704 L F
.29592 .03559 m .33488 .04479 L .32926 .05614 L F
.369 .03453 m .40158 .0551 L .36314 .046 L .954 .057 0 r
F
.369 .03453 m .40763 .04374 L .40158 .0551 L F
.36314 .046 m .39563 .49359 L .40158 .0551 L .965 .058 0 r
F
.40763 .04374 m .40158 .0551 L .39563 .49359 L .579 .035 0 r
F
.21582 .05295 m .1868 .57178 L .23053 .57917 L .966 .632 0 r
F
.21582 .05295 m .18151 .58098 L .1868 .57178 L .452 .296 0 r
F
.176 .73798 m .21066 .75116 L .17127 .74533 L 0 .888 .739 r
F
.176 .73798 m .2156 .74388 L .21066 .75116 L F
.38655 .7816 m .419 .79431 L .38059 .78869 L 0 .88 .384 r
F
.38655 .7816 m .42516 .78729 L .419 .79431 L F
.2882 .05191 m .26723 .58348 L .31068 .59084 L .966 .44 0 r
F
.2882 .05191 m .2614 .59264 L .26723 .58348 L .506 .231 0 r
F
.43319 .04983 m .43016 .524 L .4723 .53158 L .964 .058 0 r
F
.43319 .04983 m .42333 .53344 L .43016 .524 L .596 .036 0 r
F
.45981 .78854 m .49154 .80121 L .4534 .7956 L 0 .879 .209 r
F
.45981 .78854 m .49815 .79421 L .49154 .80121 L F
.1868 .57178 m .22498 .58828 L .18151 .58098 L .893 .584 0 r
F
.1868 .57178 m .23053 .57917 L .22498 .58828 L F
.21794 .04809 m .1886 .57677 L .23252 .58417 L .966 .441 0 r
F
.22293 .03664 m .21794 .04809 L .1886 .57677 L .452 .206 0 r
F
.53331 .79127 m .5643 .80393 L .52646 .79833 L 0 .878 .035 r
F
.53331 .79127 m .57134 .79694 L .5643 .80393 L F
.36314 .046 m .3533 .48584 L .39563 .49359 L .965 .058 0 r
F
.369 .03453 m .36314 .046 L .3533 .48584 L .554 .033 0 r
F
.26221 .04583 m .23252 .58417 L .23818 .57494 L .485 .221 0 r
F
.22293 .03664 m .23818 .57494 L .26221 .04583 L .966 .44 0 r
F
.60696 .79317 m .6372 .80581 L .59966 .80022 L .139 .877 0 r
F
.60696 .79317 m .64468 .79883 L .6372 .80581 L F
.40763 .04374 m .39563 .49359 L .40225 .48392 L .579 .035 0 r
F
.369 .03453 m .40225 .48392 L .40763 .04374 L .964 .058 0 r
F
.68061 .79167 m .71009 .80434 L .67288 .79873 L .312 .878 0 r
F
.68061 .79167 m .718 .79734 L .71009 .80434 L F
.23016 .02006 m .26446 .04094 L .22508 .0317 L .954 .246 0 r
F
.23016 .02006 m .26974 .02941 L .26446 .04094 L F
.22508 .0317 m .24647 .44103 L .26446 .04094 L .966 .249 0 r
F
.26974 .02941 m .26446 .04094 L .24647 .44103 L .485 .125 0 r
F
.30378 .01898 m .33731 .03988 L .29827 .03064 L .954 .057 0 r
F
.30378 .01898 m .34303 .02834 L .33731 .03988 L F
.29827 .03064 m .32576 .44782 L .33731 .03988 L .965 .058 0 r
F
.34303 .02834 m .33731 .03988 L .32576 .44782 L .535 .032 0 r
F
.32151 .76775 m .35487 .7807 L .31588 .77497 L 0 .881 .384 r
F
.32151 .76775 m .36069 .77355 L .35487 .7807 L F
.10922 .72718 m .14486 .74058 L .10486 .73465 L 0 .888 .739 r
F
.10922 .72718 m .14944 .73318 L .14486 .74058 L F
.22293 .03664 m .194 .56744 L .23818 .57494 L .966 .44 0 r
F
.22293 .03664 m .1886 .57677 L .194 .56744 L .452 .206 0 r
F
.39519 .77217 m .42782 .7851 L .38912 .77938 L 0 .88 .21 r
F
.39519 .77217 m .43409 .77796 L .42782 .7851 L F
.369 .03453 m .35968 .47608 L .40225 .48392 L .964 .058 0 r
F
.369 .03453 m .3533 .48584 L .35968 .47608 L .554 .033 0 r
F
.4691 .77915 m .50101 .79203 L .46258 .78633 L 0 .879 .035 r
F
.4691 .77915 m .50773 .78492 L .50101 .79203 L F
.22508 .0317 m .20339 .43302 L .24647 .44103 L .966 .249 0 r
F
.23016 .02006 m .22508 .0317 L .20339 .43302 L .452 .117 0 r
F
.29827 .03064 m .28299 .43983 L .32576 .44782 L .965 .058 0 r
F
.30378 .01898 m .29827 .03064 L .28299 .43983 L .506 .03 0 r
F
.54321 .77934 m .57435 .79223 L .53624 .78653 L .139 .878 0 r
F
.54321 .77934 m .58151 .78511 L .57435 .79223 L F
.26974 .02941 m .24647 .44103 L .25213 .43103 L .485 .125 0 r
F
.23016 .02006 m .25213 .43103 L .26974 .02941 L .965 .249 0 r
F
.61747 .78124 m .64785 .79412 L .61006 .78842 L .313 .878 0 r
F
.61747 .78124 m .65546 .787 L .64785 .79412 L F
.34303 .02834 m .32576 .44782 L .33194 .43784 L .535 .032 0 r
F
.30378 .01898 m .33194 .43784 L .34303 .02834 L .964 .058 0 r
F
.84045 .77668 m .86848 .78963 L .8317 .7839 L .835 .878 0 r
F
.84045 .77668 m .87741 .78248 L .86848 .78963 L F
.23752 .00319 m .27203 .02442 L .23235 .01503 L .954 .057 0 r
F
.23752 .00319 m .2774 .0127 L .27203 .02442 L F
.23235 .01503 m .25635 .38578 L .27203 .02442 L .965 .058 0 r
F
.2774 .0127 m .27203 .02442 L .25635 .38578 L .485 .029 0 r
F
.32976 .75302 m .36329 .76624 L .32405 .76039 L 0 .882 .21 r
F
.32976 .75302 m .36922 .75894 L .36329 .76624 L F
.85051 .73209 m .87849 .74554 L .84168 .73959 L .886 .755 0 r
F
.23016 .02006 m .20879 .42291 L .25213 .43103 L .965 .249 0 r
F
.23016 .02006 m .20339 .43302 L .20879 .42291 L .452 .117 0 r
F
.30378 .01898 m .28893 .42974 L .33194 .43784 L .964 .058 0 r
F
.30378 .01898 m .28299 .43983 L .28893 .42974 L .506 .03 0 r
F
.40396 .76343 m .43679 .77657 L .39779 .77075 L 0 .88 .035 r
F
.40396 .76343 m .44317 .76931 L .43679 .77657 L F
.47854 .76446 m .51059 .7776 L .47191 .77179 L .139 .88 0 r
F
.47854 .76446 m .51741 .77035 L .51059 .7776 L F
.23235 .01503 m .21329 .37748 L .25635 .38578 L .965 .058 0 r
F
.23752 .00319 m .23235 .01503 L .21329 .37748 L .452 .027 0 r
F
.55329 .76807 m .58458 .78119 L .5462 .77538 L .313 .879 0 r
F
.55329 .76807 m .59186 .77394 L .58458 .78119 L F
.2774 .0127 m .25635 .38578 L .26207 .37542 L .485 .029 0 r
F
.23752 .00319 m .26207 .37542 L .2774 .0127 L .964 .058 0 r
F
.77789 .76433 m .80681 .7775 L .76945 .77167 L .835 .879 0 r
F
.77789 .76433 m .81543 .77023 L .80681 .7775 L F
.26346 .73535 m .29792 .74884 L .25811 .74287 L 0 .884 .21 r
F
.26346 .73535 m .30349 .74139 L .29792 .74884 L F
.78802 .72108 m .81689 .73475 L .7795 .7287 L .886 .755 0 r
F
.78802 .72108 m .8256 .7272 L .81689 .73475 L F
.86372 .72635 m .89182 .73999 L .85473 .73395 L .885 .579 0 r
F
.86372 .72635 m .90099 .73246 L .89182 .73999 L F
.41295 .74852 m .44594 .76191 L .40668 .75599 L .139 .881 0 r
F
.41295 .74852 m .45242 .75452 L .44594 .76191 L F
.23752 .00319 m .21876 .36701 L .26207 .37542 L .964 .058 0 r
F
.23752 .00319 m .21329 .37748 L .21876 .36701 L .452 .027 0 r
F
.63861 .74472 m .66919 .75818 L .63097 .75223 L .663 .881 0 r
F
.63861 .74472 m .67704 .75075 L .66919 .75818 L F
.19646 .71402 m .23185 .72782 L .19148 .72171 L 0 .886 .211 r
F
.19646 .71402 m .23705 .7202 L .23185 .72782 L F
.48816 .75643 m .5204 .76977 L .48141 .76387 L .313 .879 0 r
F
.48816 .75643 m .52734 .76241 L .5204 .76977 L F
.71434 .75092 m .74416 .76433 L .70622 .7584 L .836 .88 0 r
F
.71434 .75092 m .75247 .75693 L .74416 .76433 L F
.87492 .69306 m .90302 .70711 L .86583 .70089 L .889 .405 0 r
F
.87492 .69306 m .9123 .69935 L .90302 .70711 L F
.7244 .70732 m .75418 .72124 L .7162 .71508 L .887 .755 0 r
F
.7244 .70732 m .76257 .71355 L .75418 .72124 L F
.34646 .73234 m .38039 .74601 L .34054 .73997 L .139 .882 0 r
F
.34646 .73234 m .38652 .73846 L .38039 .74601 L F
.42211 .72992 m .45523 .74361 L .41574 .73755 L .314 .882 0 r
F
.42211 .72992 m .46182 .73605 L .45523 .74361 L F
.20442 .68828 m .23993 .70244 L .19937 .69618 L 0 .889 .036 r
F
.20442 .68828 m .24521 .69462 L .23993 .70244 L F
.12832 .69757 m .1647 .71165 L .12372 .70542 L 0 .887 .211 r
F
.12832 .69757 m .16952 .70388 L .1647 .71165 L F
.64983 .73731 m .68057 .75097 L .64204 .74493 L .836 .88 0 r
F
.64983 .73731 m .68856 .74343 L .68057 .75097 L F
.27915 .71249 m .31403 .72646 L .27361 .72028 L .14 .884 0 r
F
.27915 .71249 m .3198 .71874 L .31403 .72646 L F
.35522 .71263 m .38929 .72661 L .34921 .72043 L .315 .884 0 r
F
.35522 .71263 m .39552 .71889 L .38929 .72661 L F
.66006 .69938 m .6908 .7135 L .65218 .70725 L .886 .755 0 r
F
.66006 .69938 m .69887 .7057 L .6908 .7135 L F
.73643 .69865 m .76635 .71279 L .72808 .70654 L .886 .579 0 r
F
.73643 .69865 m .77489 .70498 L .76635 .71279 L F
.13588 .67242 m .1724 .68685 L .13121 .68047 L 0 .89 .036 r
F
.13588 .67242 m .1773 .67888 L .1724 .68685 L F
.21176 .67684 m .24749 .69124 L .20661 .68487 L .14 .889 0 r
F
.21176 .67684 m .25287 .68329 L .24749 .69124 L F
.50776 .72073 m .54026 .73466 L .50079 .7285 L .663 .882 0 r
F
.50776 .72073 m .54743 .72697 L .54026 .73466 L F
.58437 .72436 m .61607 .73827 L .57692 .73212 L .837 .881 0 r
F
.58437 .72436 m .62372 .73059 L .61607 .73827 L F
.74716 .66301 m .77707 .6776 L .73871 .67115 L .891 .406 0 r
F
.74716 .66301 m .78572 .66954 L .77707 .6776 L F
.90086 .66237 m .92912 .67698 L .89146 .67052 L .891 .053 0 r
F
.90086 .66237 m .93871 .66891 L .92912 .67698 L F
.28743 .69424 m .32248 .70852 L .28179 .7022 L .315 .885 0 r
F
.28743 .69424 m .32833 .70064 L .32248 .70852 L F
.67134 .68448 m .7022 .69889 L .66333 .69252 L .887 .58 0 r
F
.59452 .68869 m .62623 .70305 L .58698 .6967 L .886 .755 0 r
F
.59452 .68869 m .63397 .69512 L .62623 .70305 L F
.44079 .70321 m .47425 .71743 L .43419 .71114 L .664 .883 0 r
F
.44079 .70321 m .48107 .70958 L .47425 .71743 L F
.14261 .66161 m .17937 .6763 L .13785 .6698 L .141 .89 0 r
F
.14261 .66161 m .18436 .66819 L .17937 .6763 L F
.21947 .65999 m .2554 .6747 L .21424 .66819 L .317 .89 0 r
F
.21947 .65999 m .26087 .66658 L .2554 .6747 L F
.51787 .71034 m .55055 .72451 L .51078 .71824 L .838 .882 0 r
F
.51787 .71034 m .55785 .71669 L .55055 .72451 L F
.83687 .65044 m .86607 .66531 L .82779 .65874 L .891 .053 0 r
F
.83687 .65044 m .87535 .6571 L .86607 .66531 L F
.82746 .71092 m .85679 .72513 L .81843 .71884 L .881 .227 0 r
F
.82746 .71092 m .86601 .71728 L .85679 .72513 L F
.52782 .67347 m .56051 .6881 L .52064 .68163 L .887 .756 0 r
F
.52782 .67347 m .5679 .68002 L .56051 .6881 L F
.60525 .6701 m .63708 .68477 L .59759 .67828 L .887 .58 0 r
F
.60525 .6701 m .64495 .67667 L .63708 .68477 L F
.45039 .67771 m .48395 .6923 L .44369 .68585 L .842 .886 0 r
F
.45039 .67771 m .49087 .68424 L .48395 .6923 L F
.37292 .6837 m .40735 .69823 L .36669 .6918 L .666 .885 0 r
F
.37292 .6837 m .4138 .69021 L .40735 .69823 L F
.22723 .64462 m .26336 .65962 L .2219 .65298 L .493 .891 0 r
F
.22723 .64462 m .26892 .65134 L .26336 .65962 L F
.46011 .64666 m .49373 .66167 L .45332 .65503 L .89 .758 0 r
F
.46011 .64666 m .50075 .65338 L .49373 .66167 L F
.38227 .65092 m .41677 .66588 L .37596 .65926 L .845 .889 0 r
F
.38227 .65092 m .4233 .65762 L .41677 .66588 L F
.30433 .6578 m .33972 .6727 L .2985 .66611 L .668 .888 0 r
F
.30433 .6578 m .34578 .66447 L .33972 .6727 L F
.77177 .63745 m .80193 .65259 L .76302 .64589 L .891 .053 0 r
F
.77177 .63745 m .81088 .64423 L .80193 .65259 L F
.61595 .64511 m .64786 .66016 L .60818 .6535 L .89 .406 0 r
F
.61595 .64511 m .65585 .65185 L .64786 .66016 L F
.53812 .65462 m .57094 .66958 L .53082 .66296 L .888 .581 0 r
F
.53812 .65462 m .57846 .66132 L .57094 .66958 L F
.69565 .67949 m .7269 .69426 L .68731 .68773 L .883 .228 0 r
F
.69565 .67949 m .73545 .68611 L .7269 .69426 L F
.46997 .63363 m .50377 .64893 L .46305 .64216 L .89 .582 0 r
F
.46997 .63363 m .51091 .64048 L .50377 .64893 L F
.39144 .63793 m .42613 .65317 L .38501 .64643 L .889 .758 0 r
F
.39144 .63793 m .43278 .64476 L .42613 .65317 L F
.15583 .64906 m .19319 .66418 L .1509 .6575 L .492 .888 0 r
F
.15583 .64906 m .19837 .65584 L .19319 .66418 L F
.70561 .62425 m .73677 .63966 L .69721 .63284 L .891 .053 0 r
F
.70561 .62425 m .74538 .63115 L .73677 .63966 L F
.47995 .60893 m .51387 .6246 L .47293 .61767 L .892 .407 0 r
F
.47995 .60893 m .52112 .61595 L .51387 .6246 L F
.32161 .62551 m .35739 .64102 L .31558 .63416 L .89 .758 0 r
F
.32161 .62551 m .36366 .63246 L .35739 .64102 L F
.63837 .61083 m .67054 .62652 L .63033 .61958 L .892 .054 0 r
F
.63837 .61083 m .6788 .61786 L .67054 .62652 L F
.4008 .62206 m .43567 .63761 L .39426 .63074 L .89 .582 0 r
F
.4008 .62206 m .44244 .62903 L .43567 .63761 L F
.41041 .59707 m .4454 .61301 L .40377 .60596 L .892 .407 0 r
F
.41041 .59707 m .45228 .60421 L .4454 .61301 L F
.55984 .64799 m .59313 .66335 L .55225 .65656 L .885 .228 0 r
F
.55984 .64799 m .60095 .65487 L .59313 .66335 L F
.33055 .60585 m .3665 .62171 L .32441 .6147 L .891 .583 0 r
F
.33055 .60585 m .37287 .61296 L .3665 .62171 L F
.57 .59631 m .60321 .61228 L .56233 .60522 L .892 .054 0 r
F
.57 .59631 m .61111 .60346 L .60321 .61228 L F
.25061 .61288 m .2875 .62867 L .24498 .62168 L .89 .758 0 r
F
.25061 .61288 m .29337 .61995 L .2875 .62867 L F
.50044 .57178 m .53466 .58814 L .49317 .5809 L .894 .054 0 r
F
.50044 .57178 m .54216 .57911 L .53466 .58814 L F
.42009 .57883 m .45526 .59511 L .41333 .58791 L .893 .23 0 r
F
.42009 .57883 m .46225 .58613 L .45526 .59511 L F
.43016 .524 m .46524 .54093 L .42333 .53344 L .9 .054 0 r
F
.43016 .524 m .4723 .53158 L .46524 .54093 L F
.33956 .58856 m .37571 .60475 L .33332 .59759 L .892 .407 0 r
F
.33956 .58856 m .38219 .59581 L .37571 .60475 L F
.20879 .42291 m .24647 .44103 L .20339 .43302 L .912 .235 0 r
F
.20879 .42291 m .25213 .43103 L .24647 .44103 L F
.35968 .47608 m .39563 .49359 L .3533 .48584 L .906 .054 0 r
F
.35968 .47608 m .40225 .48392 L .39563 .49359 L F
.21876 .36701 m .25635 .38578 L .21329 .37748 L .918 .055 0 r
F
.21876 .36701 m .26207 .37542 L .25635 .38578 L F
.25881 .59921 m .29594 .6153 L .25308 .60818 L .89 .582 0 r
F
.25881 .59921 m .30192 .60641 L .29594 .6153 L F
.28893 .42974 m .32576 .44782 L .28299 .43983 L .911 .055 0 r
F
.28893 .42974 m .33194 .43784 L .32576 .44782 L F
.17747 .61617 m .21564 .6321 L .17225 .62506 L .887 .756 0 r
F
.17747 .61617 m .22111 .62331 L .21564 .6321 L F
.26723 .58348 m .30459 .5999 L .2614 .59264 L .89 .406 0 r
F
.26723 .58348 m .31068 .59084 L .30459 .5999 L F
.194 .56744 m .23252 .58417 L .1886 .57677 L .891 .406 0 r
F
.194 .56744 m .23818 .57494 L .23252 .58417 L F
.4 g
.22092 .05884 m
.04821 .4513 L
s
.21761 .11929 m
.04369 .5036 L
s
.21422 .18144 m
.03908 .55706 L
s
.21072 .24534 m
.03437 .61172 L
s
.20713 .31107 m
.02954 .66761 L
s
.20343 .37872 m
.02461 .72478 L
s
.19962 .44837 m
.01956 .78327 L
s
.1957 .52011 m
.0144 .84313 L
s
.19165 .59403 m
.00911 .9044 L
s
.05262 .40011 m
0 1.01003 L
s
0 g
.22414 0 m
.92954 .16815 L
s
.2577 .00381 m
.25731 .0121 L
s
gsave
.2582 -0.00684 -76.607 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1960) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.32359 .01953 m
.32332 .02782 L
s
gsave
.32392 .00887 -76.8575 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1970) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.38843 .035 m
.38829 .04329 L
s
gsave
.38861 .02434 -77.1023 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1980) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.45226 .05023 m
.45225 .05852 L
s
gsave
.45228 .03957 -77.3415 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5151 .06522 m
.51521 .07352 L
s
gsave
.51497 .05456 -77.5755 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1990) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.57698 .07999 m
.5772 .08828 L
s
gsave
.5767 .06933 -77.8043 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63791 .09453 m
.63824 .10281 L
s
gsave
.63748 .08387 -78.0281 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1996) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.69792 .10885 m
.69836 .11713 L
s
gsave
.69735 .0982 -78.247 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75702 .12295 m
.75757 .13123 L
s
gsave
.75631 .11231 -78.4613 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1998) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.81524 .13685 m
.8159 .14511 L
s
gsave
.8144 .12622 -78.6711 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.8726 .15054 m
.87336 .15879 L
s
gsave
.87163 .13992 -78.8765 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2000) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.18462 .72262 L
s
.22414 0 m
.23134 .00172 L
s
[(0)] .20973 -0.00343 1 .23837 Mshowa
.21593 .15015 m
.22316 .15174 L
s
[(20)] .20146 .14697 1 .22014 Mshowa
.20713 .31107 m
.21439 .31253 L
s
[(40)] .19261 .30816 1 .20065 Mshowa
.19767 .48397 m
.20496 .48528 L
s
[(60)] .1831 .48135 1 .17975 Mshowa
.18749 .67023 m
.1948 .67138 L
s
[(80)] .17286 .66793 1 .15728 Mshowa
.125 Mabswid
.22214 .03659 m
.22646 .0376 L
s
.2201 .0738 m
.22443 .07479 L
s
.21803 .11165 m
.22237 .11262 L
s
.21378 .18933 m
.21813 .19026 L
s
.2116 .22919 m
.21595 .23011 L
s
.20939 .26977 m
.21374 .27066 L
s
.20483 .35312 m
.20919 .35398 L
s
.20249 .39594 m
.20685 .39677 L
s
.2001 .43955 m
.20447 .44036 L
s
.1952 .52922 m
.19957 .52999 L
s
.19268 .57534 m
.19706 .57607 L
s
.19011 .62233 m
.19449 .62304 L
s
.18482 .71907 m
.18921 .71973 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[192]:=",
  ImageSize->{900, 976.625},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000>40003d2000`400?l00000o`00003oo`3ooooo
0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00
o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003j0?ooo`D000000P3oool3
000000D0oooo0`0000040?ooo`<00000o`3ooooo0?ooog<0oooo003l0?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0o`3ooooo0?ooog00oooo003l0?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0?l0oooo
o`3ooom`0?ooo`00o03oool00`000000oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooool0ooooLP3oool00?`0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo100000030?ooo`05
0000003oool0oooo0?ooo`000000o`3ooooo0?ooog80oooo003l0?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?oo
o`3oool0oooo0000003o0?ooool0ooooLP3oool00=P0oooo0`00000Q0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo0000003o0?ooool0ooooLP3oool00=L0oooo00D000000?ooo`3oool0oooo0000
000N0?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool000000?l0ooooo`3ooomb0?ooo`00e`3oool01@000000oooo
0?ooo`3oool000000200oooo00<000000?ooo`3oool00`3oool3000000D0oooo0`0000030?ooo`<0
0000o`3ooooo0?ooog<0oooo003:0?ooo`8000002`3oool01@000000oooo0?ooo`3oool000000?l0
ooooo`3ooonZ0?ooo`00c03oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`00
0000o`3ooooo0?ooojX0oooo003<0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0
oooo0000003o0?ooool0ooooZP3oool00:L0oooo1@0000030?ooo`<0000000<0oooo0000003oool0
100000020?ooo`8000000`3oool200000080oooo0`0000050?ooo`030000003oool0oooo00@0oooo
0`3o3`000`3oool000000?ooo`020?ooo`030000003oool0oooo0?l0ooooo`3ooonX0?ooo`00Z@3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`<00000103oool50?l?00050000003oool0oooo0?ooo`0000003@3oool4000004D0oooo1@000002
0?ooo`<000001P3oool00`000000oooo0?ooo`030?ooo`<00000o`3ooooo0?oooc/0oooo002Y0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`050?ooo`030000003oool0
000000<0oooo1`3o3`03000000h0oooo00<000000?ooo`3oool0100000140?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`000000o`3ooooo0?ooocX0oooo002Y0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`D000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo1`3o3`0@0?ooo`8000001P3oool400000400oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo0000003o0?ooool0oooo>P3oool00:T0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo1`3o3`0@0?ooo`8000002P3oool4000000h0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`030?ooo`@000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool0o`3ooooo0?ooocP0oooo002V0?ooo`040000003oool0oooo00000080oooo0`00
00020?ooo`8000000P3oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool00P00
00030?ooo`<000000P3oool3000000040?ooo`000000000000000080oooo1@3o3`0<0?ooo`800000
0P3oool00`000000oooo0000000:0?ooo`@0mPh01000000:0?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo0?l0ooooo`3ooolh0?ooo`00YP3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0503oool30?l?
00l0oooo1@00000:0?ooo`P0mPh01@0000050?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo0?l0ooooo`3ooolh0?ooo`00YP3oool7000000l0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`02000000P0oooo00<0L`H00?H>003f3P002`3f3P04
000000030?ooo`000000oooo02`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0?l0oooo
o`3ooolh0?ooo`00^`3oool2000002T0oooo00@000000?ooo`3oool000002@3oool00`1c1P00mPh0
0?H>000?0?H>00@00000:@3oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0ooooo`3ooolj
0?ooo`00iP3oool010000000oooo0?ooo`0000080?ooo`80L`H04@3f3P0010000000mPh00?H>003f
3P04000002L0oooo00<000000?ooo`3oool00`3oool3000000<0oooo1@0000030?ooo`<00000o`3o
oooo0?oooc/0oooo003U0?ooo`050000003oool0oooo0?ooo`000000203oool207<60140mPh000<0
00000?H>003f3P001@3f3P0400000?l0ooooo`3ooome0?ooo`00i@3oool010000000oooo0?ooo`00
00090?ooo`80L`H04@3f3P000`000000mPh00?H>00090?H>00D00000o`3ooooo0?ooog00oooo003T
0?ooo`050000003oool0oooo0?ooo`000000203oool307<60280mPh01000003o0?ooool0ooooK03o
ool00>@0oooo00D000000?ooo`3oool0oooo000000080?ooo`<0L`H08`3f3P030?ooo`@00000o`3o
oooo0?ooofP0oooo002W0?ooo`<000000P3oool200000080oooo0`0000030?ooo`@00000103oool3
000000@0oooo0`0000000`3oool000000?ooo`020?ooo`<0od804`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00D0oooo101c1P0S0?H>00L0oooo100000170?ooo`D000000P3oool3
000000D0oooo0`0000040?ooo`<00000o`3ooooo0?ooo`@0oooo002X0?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`D0
od804P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo101c1P0S0?H>00/0
oooo100000150?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000030?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0o`3ooooo0?ooo`40oooo002X0?oo
o`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo
1`3o@P0A0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool407<602<0mPh0
3`3oool500000400oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool0o`3ooooo0?ooo`40oooo002X0?ooo`<0
0000103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool50000
00<0oooo100000020?ooo`L0od80403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00D0oooo101c1P0S0?H>01@0oooo1000000l0?ooo`030000003oool0oooo00<0oooo100000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0ooooo`3o
ool30?ooo`00Z03oool2000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00L0od80
403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo101c1P0S0?H>01H0oooo
0P3f3P04000000/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000`3oool3000000<0oooo00D000000?ooo`3oool0oooo0000003o0?oo
ool0oooo0`3oool00:P0oooo00<000000?ooo`0000001@3oool3000000<0oooo00<000000?ooo`00
00000P0000030?ooo`<000000`3oool4000000@0oooo1@3o@P0@0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool20?Lo00@0L`H08`3f3P0E0?ooo`030847003f3P00mPh000@0
mPh0100000070?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000o`3ooooo0?ooo`<0oooo002X0?ooo`040000003oool0oooo00000240oooo0`3o
@P0=0?ooo`D000001P3oool00`000000oooo0?ooo`030?ooo`80mcl0101c1P0S0?H>01D0oooo00<0
P@L00?H>003f3P00203f3P04000000<0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo0000003o0?ooool0oooo0`3oool00:L0oooo0`0000000`3oool0
00000000000c0?ooo`D000000`3oool00`000000oooo0?ooo`020?ooo`0307<M003g?`00mcl000@0
L`H08`3f3P0D0?ooo`80P@L03P3f3P05000002T0oooo0`0000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
003o0?ooool0oooo0`3oool00>00oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
0?ooo`0307<M003g?`00mcl000@0L`H08`3f3P0D0?ooo`80P@L04@3f3P000`000000mPh000000003
000002L0oooo00<000000?ooo`3oool00`3oool3000000@0oooo0`0000040?ooo`<00000o`3ooooo
0?ooo`@0oooo003P0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P1c7@02
0?Lo00@0L`H08`3f3P0C0?ooo`<0P@L04@3f3P000`000000mPh00?H>00030?H>00@00000o`3ooooo
0?oooch0oooo003O0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo0P1c7@02
0?Lo00<0L`H0903f3P0C0?ooo`<0P@L04@3f3P000`000000mPh00?H>00070?H>00@00000o`3ooooo
0?ooocX0oooo003O0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo0P1c7@02
0?Lo00<0L`H0903f3P0B0?ooo`@0P@L04@3f3P000`000000mPh00?H>000;0?H>00@00000o`3ooooo
0?ooocH0oooo002Z0?ooo`<000004@3oool2000001h0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0307<M0080mcl00`1c1P0T0?H>0180oooo10211`0R0?H>00030?ooo`0000000000
00<00000o`3ooooo0?oooc40oooo002]0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0Lad00P3g?`0307<602@0
mPh04@3oool508470280mPh01P3oool4000004H0oooo1@0000020?ooo`<000001@3oool3000000<0
oooo1000003o0?ooold0oooo002]0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`080?ooo`030000003oool0Lad000<0Lad00P3g?`0307<602@0mPh0
4@3oool508470280mPh02P3oool4000004@0oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`3o0?ooolX0
oooo002C0?ooo`<0000000@0oooo00000000000000000P3oool3000000030?ooo`00000000000080
00000P3oool200000080oooo100000030?ooo`<0000000<0oooo0000003oool0100000050?ooo`03
0000003oool0oooo00@0oooo0`3oM00C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0101c7@020?Lo00<0L`H0903f3P0A0?ooo`D0P@L08P3f3P0>0?ooo`@00000@03oool00`000000
oooo0?ooo`060?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`3o0?ooolX0oooo002D0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool0103oool3000000@0oooo1@3oM00B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0101c7@020?Lo00<0L`H0903f3P0A0?ooo`D0P@L08P3f3P0B0?ooo`@00000?03oool00`000000
oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`3oool0o`3oooo:0?ooo`00U03oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`0000000`3oool70?md0100oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0407<M0080mcl00`1c1P0T0?H>0140oooo1@211`0R0?H>01H0oooo1@00000<0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00<0oooo0`0000030?ooo`@00000o`3oooo=0?ooo`00U03oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo100000030?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`L0og@0403oool00`000000oooo0?ooo`080?ooo`<0
0000101c7@020?Lo00<0L`H0903f3P0?0?ooo`80m3h01@211`0R0?H>01H0oooo1@3f3P04000000P0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0o`3oooo>
0?ooo`00U03oool500000080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool70?md00l0oooo00<000000?ooo`3o
ool02@3oool00`000000mg000?M`000200000080Lad00P3g?`0307<602@0mPh03`3oool20?@n00D0
P@L08P3f3P0E0?ooo`0308d8003f3P00mPh000L0mPh0100000040?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0?l0oooocP3oool009@0oooo00H000000?oo
o`3oool0oooo0000003oool200000080oooo0P0000000`3oool000000?ooo`03000000@0oooo0`00
00000`3oool000000?ooo`04000000<0oooo00<000000?ooo`0000000P0000001@3oool000000000
00000000oooo00<000000P3oool50?md00`0oooo1@00000;0?ooo`030000003gL000mg0000@0Lad0
00<0mcl007<6001c1P000P1c1P0T0?H>00h0oooo0`3d?P0508470280mPh05@3oool00`2=2000mPh0
0?H>000;0?H>00D00000:03oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooolh0oooo002D0?ooo`05
0000003oool0oooo0?ooo`000000;P3oool30?md0100oooo1@0000080?ooo`030000003gL000mg00
00@0Lad000<0mcl007<6001c1P000P1c1P0S0?H>00l0oooo0`3d?P0508470280mPh0503oool208d8
0140mPh01000000W0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<000000`3oool50000
0?l0ooooc03oool009<0oooo0`000000103oool000000000000000100?ooo`030000003oool0oooo
00X0oooo00<000000?M`003gL000101c7@000`3g?`00L`H007<6000207<602<0mPh03P3oool40?@n
00D0P@L08P3f3P0D0?ooo`80S@P04@3f3P0010000000mPh00?H>003f3P0500000?l0ooooo`3oool7
0?ooo`00fP3oool00`000000oooo0?ooo`090?ooo`0407<d00000000mg000?M`00@0Lad000<0mcl0
07<6001c1P000P1c1P0S0?H>00h0oooo103d?P0508470280mPh04`3oool308d80140mPh000<00000
0?H>003f3P001P3f3P0400000?l0ooooo`3oool30?ooo`00f@3oool00`000000oooo0?ooo`0:0?oo
o`0407<d00000000mg000?M`00<0Lad00P3g?`0407<602<0mPh03P3oool40?@n00D0P@L08P3f3P0C
0?ooo`<0S@P04@3f3P000`000000mPh00?H>000:0?H>00@00000o`3oooon0?ooo`00f@3oool00`00
0000oooo0?ooo`0:0?ooo`0407<d00000000mg000?M`00<0Lad00P3g?`0407<602<0mPh03@3oool5
0?@n00D0P@L08P3f3P0B0?ooo`@0S@P08@3f3P000`3oool000000000000200000?l0oooonP3oool0
0=P0oooo00<000000?ooo`3oool02P3oool207<d00030000003gL000mg0000<0Lad00P3g?`0407<6
02<0mPh03@3oool50?@n00D0P@L08P3f3P0A0?ooo`D0S@P08@3f3P050?ooo`@00000AP3oool50000
0080oooo0`0000040?ooo`<000001@3oool300000?l0ooooU`3oool00=P0oooo00<000000?ooo`3o
ool02P3oool207<d00030000003gL000mg0000<0Lad00P3g?`0407<602<0mPh0303oool60?@n00D0
P@L08P3f3P0A0?ooo`D0S@P08@3f3P090?ooo`D00000@`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
0?l0ooooU03oool00=L0oooo00<000000?ooo`3oool02P3oool307<d00030000003gL000mg0000<0
Lad00P3g?`0407<602<0mPh04@3oool00`3d?P00P@L00847000308470280mPh04@3oool508d80240
mPh03P3oool4000003l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool0o`3ooonD0?ooo`00U03oool4000000D0
oooo0`0000030?ooo`H000000P3oool3000000030?ooo`0000000000008000000P3oool200000080
oooo0`0000000`3oool000000?ooo`020?ooo`<0ojL04`3oool00`000000oooo0?ooo`0:0?ooo`<0
Lc@000<000000?M`003gL0000`1c7@020?Lo00<0L`H0903f3P0B0?ooo`D0P@L08P3f3P0A0?ooo`D0
S@P08@3f3P0B0?ooo`@00000>`3oool00`000000oooo0?ooo`030?ooo`@000000`3oool400000080
oooo00D000000?ooo`3oool0oooo0000003o0?oooiH0oooo002E0?ooo`030000003oool0oooo00@0
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo1@3oY`0B0?ooo`030000003oool0oooo00X0oooo0`1c=0000`000000mg00
0?M`000307<M0080mcl00`1c1P0T0?H>0180oooo1@211`0R0?H>0140oooo1@2=200Q0?H>01H0oooo
1000000=0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000o`3ooonF0?ooo`00U@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L0
ojL0403oool00`000000oooo0?ooo`0;0?ooo`<0Lc@000<000000?M`003gL0000`1c7@020?Lo00<0
L`H0903f3P0B0?ooo`@0P@L08`3f3P0A0?ooo`D0S@P08@3f3P0F0?ooo`@0mPh0100000090?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000o`3o
oonF0?ooo`00U@3oool4000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo1`3oY`0@0?ooo`030000003oool0oooo00/0oooo0`1c=0000`000000
mg000?M`000307<M0080mcl00`1c1P0T0?H>00X0oooo1@3gL0030?ooo`@0P@L08`3f3P0?0?ooo`80
m3h01@2=200Q0?H>01D0oooo00<0V0T00?H>003f3P001P3f3P05000000@0oooo00<000000?ooo`3o
ool09`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?oooiH0oooo002E
0?ooo`030000003oool0oooo008000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0200000080oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`070?nW00l0oooo00<000000?ooo`3oool02P3oool20?NQ0080Lc@0
00<0000007<d003gL000101c7@020?Lo00<0L`H0903f3P090?ooo`03084k003gL000mg0000H0mg00
10211`0S0?H>00h0oooo0`3d?P0508d80240mPh05@3oool00`2H2@00mPh00?H>000;0?H>00D00000
9`3oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000?l0ooooUP3oool009D0oooo00D000000?oo
o`3oool0oooo000000030?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`@000000P3oool0
0`000000oooo00000002000000@0oooo100000030?ooo`D0ojL0303oool5000000`0oooo0P3gX@02
07<d00030000001c=000mg0000@0Lad00P3g?`0307<602@0mPh02@3oool00`21>`00mg000?M`0006
0?M`00@0P@L08`3f3P0>0?ooo`<0m3h01@2=200Q0?H>01@0oooo0P2H2@0A0?H>00@000009P3oool0
0`000000oooo0?ooo`030?ooo`<00000103oool3000000@0oooo0`00003o0?oooiL0oooo002E0?oo
o`030000003oool0oooo008000002`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0080oooo0`3oY`0@0?ooo`D00000203oool00`1cB`00mj400?NQ000207<d00030000001c=000mg00
00@0Lad00P3g?`0307<602@0mPh0203oool2084k00P0mg0010211`0S0?H>00d0oooo103d?P0508d8
0240mPh0503oool209P90140mPh000@000000?H>003f3P00mPh01000003o0?ooom00oooo002D0?oo
o`D00000303oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool02P3oool00`1cB`00mj400?NQ000207<d00030000001c=000mg0000@0Lad00P3g?`0307<6
02@0mPh0203oool2084k00P0mg0010211`0S0?H>00d0oooo103d?P0508d80240mPh04`3oool309P9
0140mPh000<000000?H>003f3P001@3f3P0400000?l0ooooc03oool00:<0oooo0`00000E0?ooo`80
00005`3oool00`000000oooo0?ooo`090?ooo`80Ld/00P3gX@0207<d00030000003gL000mg0000@0
Lad00P3g?`0307<602@0mPh01`3oool3084k00P0mg0010211`0S0?H>00`0oooo1@3d?P0508d80240
mPh04`3oool309P90140mPh000<000000?H>003f3P002@3f3P0500000?l0ooooa`3oool00=<0oooo
00<000000?ooo`3oool02P3oool207=;0080mj400P1c=0000`000000mg000?M`000407<M0080mcl0
0`1c1P0T0?H>00L0oooo0`21>`080?M`00@0P@L08`3f3P0<0?ooo`D0m3h01@2=200Q0?H>0180oooo
102H2@0R0?H>00@00000o`3oooo30?ooo`00SP3oool300000480oooo00<000000?ooo`3oool02P3o
ool207=;0080mj4000<0Lc@006IVIP0000000P3gL00407<M00030?Lo001c1P00L`H00080L`H0903f
3P060?ooo`@0PC/0203gL004084702<0mPh02`3oool60?@n00D0S@P08@3f3P0A0?ooo`D0V0T08P3f
3P040?ooo`@00000A03oool500000080oooo0`0000040?ooo`<00000103oool400000?l0ooooHP3o
ool008l0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0:0?ooo`<0Ld/00P3gX@00
0`1c=000IVIV000000020?M`00@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>00H0oooo1021>`07
0?M`00D0P@L08`3f3P0:0?ooo`L0m3h01@2=200Q0?H>0140oooo1@2H2@0R0?H>00P0oooo10000012
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0?l0ooooG`3oool008l0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`0:0?ooo`<0Ld/00P3gX@000`1VIVH0Lc@0000000020?M`00@0Lad000<0mcl0
07<6001c1P000P1c1P0T0?H>00D0oooo1@21>`070?M`00D0P@L08`3f3P0?0?ooo`80m3h01@2=200Q
0?H>0140oooo1@2H2@0R0?H>00`0oooo1000000n0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooG`3oool0
04h0oooo100000030?ooo`H000000P3oool3000000D0oooo00<000000?ooo`3oool00`3oool30000
00040?ooo`0000000000000000<0oooo0P0000090?ooo`<000000P3oool200000080oooo0`000003
0?ooo`@00000103oool3000000040?ooo`00000000000?ooo`<000000`3oool6000000030?ooo`00
0000000000<000000`3oool3000000D0oooo0`3ofP0C0?ooo`030000003oool0oooo00X0oooo101c
B`020?NQ000306IVIP1c=00000000080mg00101c7@000`3g?`00L`H007<6000207<602@0mPh01@3o
ool5084k00L0mg001@211`0S0?H>0140oooo1@2=200Q0?H>0140oooo1@2H2@0R0?H>0100oooo1@00
000i0?ooo`030000003oool0oooo00<0oooo100000030?ooo`@000001P3oool00`000000oooo0?oo
o`3o0?oooel0oooo001>0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000`3oool3000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo000000`0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`D0omX04P3oool00`000000oooo0?ooo`0:0?ooo`@0Ld/000D0mj4006IVIP1c=000Lc@00000
00020?M`00<0Lad00P3g?`0407<602<0mPh01P3oool5084k00L0mg001@211`0S0?H>0140oooo1@2=
200Q0?H>0140oooo1@2H2@0R0?H>01D0oooo1000000<0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`@00000o`3ooomR0?ooo`00DP3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000d0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0
oooo1`3ofP0A0?ooo`030000003oool0oooo00X0oooo101cB`001@3gX@00IVIV07<d001c=0000000
0080mg000`1c7@020?Lo00@0L`H08`3f3P060?ooo`D0PC/01`3gL005084702<0mPh04@3oool508d8
0240mPh03`3oool20?Lo00D0V0T08P3f3P0D0?ooo`030:89003f3P00mPh00080mPh0100000080?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0?l0ooooH`3o
ool00500oooo0`0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000`3oool400000080oooo0P00000>0?ooo`040000
003oool0oooo000000<0oooo1@0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`L0omX0403o
ool00`000000oooo0?ooo`0;0?ooo`@0Ld/000D0IVIV0?NQ001c=000Lc@0000000020?M`00<0Lad0
0P3g?`0407<602<0mPh01P3oool5084k00L0mg001@211`0S0?H>00P0oooo1@3gL0040?ooo`D0S@P0
8@3f3P0>0?ooo`0309PW003g?`00mcl000D0V0T08P3f3P0C0?ooo`80XPT0203f3P04000000@0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0o`3ooomS0?oo
o`00CP3oool3000000H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000060?ooo`060000003oool0oooo0000003oool00000
3@3oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo1`3ofP0@0?ooo`030000003oool0oooo00/0oooo101cB`001@1VIVH0Lc@0
07<d001c=00000000080mg000`1c7@020?Lo00@0L`H08`3f3P040?ooo`80mj401@21>`070?M`00D0
P@L08`3f3P070?ooo`0308e0003gL000mg0000L0mg001@2=200Q0?H>00h0oooo00<0V2L00?Lo003g
?`001@2H2@0R0?H>01<0oooo0P2R2@0<0?H>00D000009P3oool3000000@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o
0?ooof<0oooo001>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool30000
0080oooo0`0000001@3oool00000000000000000oooo00@000000`3oool00`000000oooo0?ooo`02
000000/0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000P3oool00`000000oooo0000
000200000080oooo0P0000020?ooo`8000000P3oool4000000D0oooo00<000000?ooo`3oool00P3o
ool3000000D0oooo0`0000040?ooo`D0omX0403oool00`000000oooo0?ooo`0:0?ooo`80mm80101c
B`001@1VIVH0Lc@007<d001c=00000000080mg000`1c7@020?Lo00@0L`H08`3f3P040?ooo`80mj40
1@21>`070?M`00D0P@L08P3f3P080?ooo`0308e0003gL000mg0000L0mg001@2=200Q0?H>00d0oooo
0P2H9`020?Lo00D0V0T08P3f3P0B0?ooo`<0XPT0403f3P05000002@0oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo0`0000030?ooo`D00000o`3ooomQ0?ooo`00CP3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`050000
003oool0oooo0?ooo`0000005`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180
oooo0`3ofP0=0?ooo`D00000303oool20?OB00<0Ld/000<0IVIV0?NQ001c=0000P1c=0000`000000
mg000?M`000307<M0080mcl0101c1P0S0?H>00<0oooo00<0PE@00?NQ003gX@001@21>`070?M`00D0
P@L08P3f3P070?ooo`80SD002@3gL00508d80240mPh0303oool309PW0080mcl01@2H2@0R0?H>0180
oooo0`2R2@0@0?H>00030000003f3P00mPh00080mPh01000003o0?oooiT0oooo001?0?ooo`@00000
103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00`0oooo1@00000H0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool09@3oool5000000P0oooo00<0Lf800?OB003gdP00
0`1cB`000`1VIVH0mj4007<d000207<d00030000003gL000mg0000<0Lad00P3g?`0307<602@0mPh0
0`3oool00`21E000mj400?NQ0005084k00L0mg001@211`0R0?H>00L0oooo0P2=@0090?M`00D0S@P0
8@3f3P0<0?ooo`<0V2L00P3g?`0509P90280mPh04@3oool40:890100mPh000<000000?H>003f3P00
1P3f3P0400000?l0ooooU@3oool005D0oooo0`00000H0?ooo`800000:P3oool2000000H0oooo0`00
00060?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`1cHP00mm800?OB
000207=;000306IVIP3gX@00mj400080Lc@00`000000103gL000Lad007<M001c7@020?Lo00<0L`H0
903f3P020?ooo`80PE@00P3gX@05084k00L0mg001@211`0R0?H>00H0oooo0`2=@0090?M`00D0S@P0
8@3f3P0;0?ooo`@0V2L00P3g?`0509P90280mPh04@3oool40:890100mPh000<000000?H>003f3P00
2P3f3P0400000?l0ooooT@3oool00<h0oooo00<000000?ooo`3oool02@3oool207=R0080mm800P1c
B`000`1VIVH0mj400?NQ000207<d00030000001c=000mg00008000000P1c7@020?Lo00<0L`H0903f
3P020?ooo`80PE@00P3gX@05084k00L0mg001@211`0R0?H>00H0oooo0`2=@0090?M`00D0S@P08@3f
3P0;0?ooo`@0V2L00P3g?`0509P90280mPh0403oool50:890240mPh0100000150?ooo`D000000P3o
ool3000000@0oooo0`0000050?ooo`<00000o`3oool_0?ooo`00c@3oool00`000000oooo0?ooo`0:
0?ooo`80Lf800P3gdP000`1cB`00IVIV07=;00020?NQ0080Lc@000<0000007<d003gL000101c7@02
0?Lo00<0L`H0903f3P020?ooo`80PE@00P3gX@05084k00L0mg001@211`0R0?H>00D0oooo102=@009
0?M`00D0S@P08@3f3P0:0?ooo`D0V2L00P3g?`0509P90280mPh03`3oool60:890240mPh0103oool5
00000480oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3o0?ooob`0oooo003=0?ooo`030000003oool0
oooo00X0oooo0P1cHP020?OB000307=;001VIVH0Ld/00080mj400P1c=0000`000000Lc@00?M`0004
07<M0080mcl00`1c1P0T0?H>00040?ooo`21E000PE@0085D0080mj401@21>`070?M`00D0P@L08P3f
3P050?ooo`@0SD002@3gL00508d80240mPh02@3oool609PW0080mcl01@2H2@0R0?H>0100oooo1@2R
2@0Q0?H>00T0oooo1000000n0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0?l0oooo;03oool00<`0oooo00<0
00000?ooo`3oool02P3oool307=R0080mm8000<0Ld/006IVIP1cB`000P3gX@0207<d00030000001c
=000mg0000@0Lad00P3g?`0307<602@0mPh000@0oooo085D0021E000PE@00P3gX@05084k00L0mg00
1@211`0R0?H>00@0oooo1@2=@0090?M`00D0S@P08@3f3P090?ooo`H0V2L00P3g?`0509P90280mPh0
403oool50:890240mPh03@3oool4000003X0oooo00<000000?ooo`3oool00`3oool4000000<0oooo
100000020?ooo`050000003oool0oooo0?ooo`000000o`3oool^0?ooo`00c03oool00`000000oooo
0?ooo`0:0?ooo`<0Lf800P3gdP000`1VIVH0Ld/007=;00020?NQ0080Lc@000<000000?M`003gL000
101c7@020?Lo00<0L`H0903f3P04085D0080mj401@21>`070?M`00D0P@L08P3f3P040?ooo`D0SD00
2@3gL00508d80240mPh02@3oool609PW0080mcl01@2H2@0R0?H>0100oooo1@2R2@0Q0?H>0140oooo
1000000f0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool400000?l0oooo;`3oool008P0oooo0`000000103oool0
00000000000000020?ooo`<000000P3oool2000000<0oooo0P0000000`3oool00000000000030000
00<0oooo0`0000040?ooo`<000001@3oool30??o01<0oooo00<000000?ooo`3oool02P3oool407=R
0080mm8000<0IVIV07=;001cB`000P3gX@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<6
02@0mPh01021E0020?NQ00D0PC/01`3gL00508470280mPh0103oool508e000T0mg001@2=200Q0?H>
00T0oooo1P2H9`020?Lo00D0V0T08P3f3P0@0?ooo`D0XPT08@3f3P0D0?ooo`030:X:000000000000
008000002`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`3o0?oooc00oooo00290?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool5
0??o0180oooo00<000000?ooo`3oool02P3oool407=R00030?OB001VIVH0Ld/00080Ld/00P3gX@02
07<d00030000003gL000mg0000@0Lad00P3g?`0307<602@0mPh01021E0020?NQ00@0PC/0203gL005
08470280mPh0103oool508e000T0mg001@2=200Q0?H>00T0oooo1P2H9`020?Lo00D0V0T08P3f3P0=
0?ooo`<0m3h01@2R2@0Q0?H>01<0oooo0P2Z2P040?H>00D000001P3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?oooc00oooo00290?ooo`050000003o
ool000000?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00000P3oool70??o0140oooo00<000000?ooo`3oool02P3oool407=R00030?OB001VIVH0Ld/00080
Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<602@0mPh01021E0020?NQ00@0
PC/0203gL004084702<0mPh0103oool508e000T0mg001@2=200Q0?H>00L0oooo0P3gL00609PW0080
mcl01@2H2@0R0?H>00`0oooo103d?P050:890240mPh04`3oool20:X:00T0mPh0100000020?ooo`03
0000003oool0oooo0280oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0o`3oool_0?ooo`00R@3oool01@00
0000oooo0000003oool000000080oooo1@0000040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3o
ool70??o0100oooo00<000000?ooo`3oool02`3oool407=R000306IVIP3gdP00Ld/00080Ld/00P3g
X@0207<d00030000003gL000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>00@0PE@00P3g
X@04084k00P0mg0010211`0S0?H>0080oooo0P3gX@0508e000T0mg001@2=200Q0?H>00H0oooo00<0
V4D00?M`003gL0001P2H9`020?Lo00D0V0T08P3f3P0<0?ooo`@0m3h01@2R2@0Q0?H>0180oooo0`2Z
2P0=0?H>00@000009@3oool00`000000oooo0?ooo`030?ooo`<00000103oool3000000D0oooo0`00
003o0?ooobh0oooo00290?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo1`3co`0@0?oo
o`030000003oool0oooo00/0oooo101cHP000`1VIVH0Ld/007=;000207=;0080mj400P1c=0000`00
0000mg000?M`000407<M00030?Lo001c1P00L`H00080L`H0903f3P04085D0080mj401021>`080?M`
00@0P@L08`3f3P00103oool0SE`00?NQ003gX@0508e000T0mg001@2=200Q0?H>00H0oooo00<0V4D0
0?M`003gL0001P2H9`020?Lo00D0V0T08P3f3P0;0?ooo`D0m3h01@2R2@0Q0?H>0140oooo102Z2P0?
0?H>00030000003f3P00000000<00000o`3ooomW0?ooo`00R@3oool2000000030?ooo`0000000000
00<0oooo0`0000020?ooo`<0000000D0oooo00000000000000000?ooo`03000000D0oooo0`000004
0?ooo`<00000103oool50??o00`0oooo0P0000020?ooo`030000003oool0oooo00X0oooo0P3[m`03
07=R000306IVIP3gdP00Ld/000<0Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad000<0mcl0
07<6001c1P000P1c1P0T0?H>00@0PE@00P3gX@04084k00P0mg0010211`0S0?H>00040?ooo`2=G000
mj400?NQ00D0SD002@3gL00508d80240mPh01@3oool209Q50080mg001P2H9`020?Lo00D0V0T08P3f
3P0:0?ooo`H0m3h01@2R2@0Q0?H>0140oooo102Z2P0?0?H>00030000003f3P00mPh000<0mPh01@00
003o0?ooof80oooo00290?ooo`80000000<0oooo0000000000009`3oool30??o00l0oooo1000000;
0?ooo`80joL00`1cHP000`1VIVH0mm8007=;000307=;0080mj400P1c=0000`000000mg000?M`0003
07<M0080mcl0101c1P0T0?H>00@0PE@00P3gX@04084k00P0mg0010211`0S0?H>0080SE`00P3gX@05
08e000T0mg001@2=200Q0?H>00D0oooo0P2HA@020?M`00H0V2L00P3g?`0509P90280mPh02P3oool6
0?@n00D0XPT08@3f3P0@0?ooo`D0ZPX03`3f3P000`000000mPh00?H>00080?H>00@00000o`3ooomN
0?ooo`00R03oool2000000<0oooo0P00000i0?ooo`030000003oool0oooo00800000203oool00`1]
L`00joL00>_g000307=R000306IVIP3gdP00Ld/000<0Ld/000D0mj4007<d001c=000Lc@000000002
0?M`00<0Lad00P3g?`0407<602@0mPh01021E0020?NQ00@0PC/0203gL004084702<0mPh00P2=G002
0?NQ00D0SD002@3gL00508d80240mPh0103oool309Q50080mg001P2H9`020?Lo00D0V0T08P3f3P09
0?ooo`L0m3h01@2R2@0Q0?H>0100oooo1@2Z2P0?0?H>00030000003f3P00mPh000`0mPh01000003o
0?oooeX0oooo002P0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool02P3oool00`1]
L`00joL00>_g000207=R000306IVIP3gdP00mm8000@0Ld/000D0mj4007<d001c=000Lc@000000002
0?M`00<0Lad00P3g?`0407<602@0mPh01021E0020?NQ00@0PC/0203gL004084702<0mPh00P2=G002
0?NQ00D0SD002@3gL00508d80240mPh0103oool309Q50080mg001P2H9`020?Lo00D0V0T08P3f3P09
0?ooo`L0m3h01@2R2@0Q0?H>00l0oooo1P2Z2P0O0?H>00<0oooo100000120?ooo`D000000P3oool3
000000@0oooo0`0000060?ooo`030000003oool0oooo0?T0oooo00380?ooo`030000003oool0oooo
00T0oooo0P1]L`020>_g0080Lf8000<0IVIV0?OB003gdP00101cB`001@3gX@00Lc@007<d001c=000
00000080mg000`1c7@020?Lo00@0L`H08`3f3P000`3gdP00PE@0085D0002085D0080mj401021>`08
0?M`00@0P@L08`3f3P0208eL0080mj401@2=@0090?M`00@0S@P08P3f3P030?ooo`@0V4D00P3gL006
09PW0080mcl01@2H2@0R0?H>00P0oooo203d?P050:890240mPh03P3oool70:X:01l0mPh01`3oool4
00000400oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0n@3oool009T0oooo0`00000[0?ooo`030000003oool0oooo
00X0oooo0P1]L`020>_g000307=R001VIVH0Lf800080mm80101cB`001@3gX@00Lc@007<d001c=000
00000080mg000`1c7@020?Lo00@0L`H08`3f3P000`3gdP00PE@0085D0002085D0080mj401021>`08
0?M`00@0P@L08`3f3P0208eL0080mj401@2=@0090?M`00@0S@P08P3f3P020?ooo`D0V4D00P3gL006
09PW0080mcl01@2H2@0R0?H>00L0oooo2@3d?P050:890240mPh03`3oool60:X:01l0mPh02`3oool5
000003/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0n@3oool009`0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`090?ooo`<0KG<00P3[m`000`1cHP00IVIV07=R00020?OB00@0Ld/000D0mj4007<d
001c=000Lc@0000000020?M`00<0Lad00P3g?`0407<602<0mPh000<0mm80085D0021E0000P21E000
0`3gX@00PC/0084k0003084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0mg00102=200R
0?H>0080oooo1@2HA@020?M`00H0V2L00P3g?`0509P90280mPh0303oool40?@n00D0XPT08@3f3P0?
0?ooo`H0ZPX07`3f3P0@0?ooo`@00000=`3oool00`000000oooo0?ooo`030?ooo`@000000`3oool4
000000D0oooo00<000000?ooo`3oool0n03oool009`0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`0:0?ooo`<0KG<00P3[m`000`1VIVH0Lf8007=R00020?OB00<0Ld/00P3gX@0307<d
00030000003gL000mg0000<0Lad00P3g?`0307<602@0mPh000<0mm80085D0021E0000P21E0000`3g
X@00PC/0084k0003084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0mg00102=200R0?H>
0080oooo1@2HA@020?M`00H0V2L00P3g?`0509P90280mPh0403oool50:890240mPh03`3oool60:X:
01l0mPh0503oool4000000`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0n03oool007@0oooo100000050?ooo`<000000`3oool4000000D0oooo0`000003
0?ooo`<0000000@0oooo0000003oool0oooo100000030?ooo`<0000000<0oooo0000003oool01P00
00040?ooo`<0`?l04`3oool00`000000oooo0?ooo`090?ooo`@0KG<00P3[m`000`1VIVH0Lf8007=R
00020?OB00<0Ld/00P3gX@0307<d00030000003gL000Lad000<0Lad00P3g?`0307<602@0mPh000<0
mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00L0mg001@211`0S0?H>0080SE`00P3g
X@0508e000T0mg00102=200R0?H>0080oooo1@2HA@020?M`00H0V2L00P3g?`0509P90280mPh0403o
ool50:890240mPh03`3oool60:X:01l0mPh0503oool0102a2P00mPh00?H>003f3P04000000P0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0n03oool007D0
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0103oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`D0`?l04@3oool00`000000oooo0?ooo`0:0?ooo`@0KG<00P3[m`000`1VIVH0
Lf8007=R00020?OB00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0307<602@0
mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00L0mg001@211`0S0?H>0080
SE`00P3gX@0508e000T0mg00102=200R0?H>0080oooo1@2HA@020?M`00H0V2L00P3g?`0509P90280
mPh0403oool50:890240mPh0303oool00`2Z;000mcl00?Lo00060:X:01l0mPh04`3oool20;4:00L0
mPh0100000040?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0
oooo0?P0oooo001e0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`L0`?l0403oool00`000000oooo0?ooo`0:0?ooo`@0
KG<000<0joL006IVIP1cHP000P1cHP020?OB00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0
Lad00P3g?`0307<602@0mPh000@0mm80085D0021E000PE@00P3gX@05084k00L0mg001@211`0S0?H>
0080SE`00P3gX@0508e000T0mg00102=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P9
0280mPh01@3oool00`2RB@00mg000?M`00020?M`00H0oooo1@2R2@0Q0?H>00/0oooo0P2Z;0020?Lo
00H0ZPX07`3f3P0B0?ooo`<0/@X02`3f3P05000002@0oooo0`0000040?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
0000003i0?ooo`00M@3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000030?ooo`@00000103oool00`000000oooo0?ooo`030?oo
o`L0`?l0403oool00`000000oooo0?ooo`0:0?ooo`@0KG<000<0joL006IVIP1cHP000P1cHP020?OB
00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0307<602@0mPh000@0mm80085D
0021E000PE@00P3gX@05084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0mg00102=200R
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh0103oool20:9900P0mg000P3oool5
0:890240mPh02P3oool30:X/0080mcl01P2Z2P0O0?H>0180oooo0`2a2P0?0?H>00D000008P3oool0
0`000000oooo0?ooo`030?ooo`<00000103oool3000000<0oooo1@00003i0?ooo`00M@3oool00`00
0000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool70<3o00l0oooo00<000000?ooo`3oool02`3oool406ec000306IVIP1cHP00Lf800080Lf80
0P3gdP0307=;0080mj400P1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0T0?H>00040?OB
0021E000PE@0085D0080mj401@21>`070?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00@0
S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00<0oooo0`2RB@0:0?M`00D0
XPT08@3f3P0:0?ooo`<0ZR`00P3g?`060:X:01l0mPh04@3oool40;4:00l0mPh000<000000?H>003f
3P000P3f3P0400000?l0oooo<03oool007D0oooo00D000000?ooo`3oool0oooo000000030?ooo`<0
00000`3oool00`000000oooo0000000200000080oooo1@0000000`3oool00000000000020?ooo`80
00000`3oool3000000030?ooo`000000oooo00@000001@3oool00`000000oooo0?ooo`040?ooo`D0
`?l0303oool200000080oooo00<000000?ooo`3oool02@3oool20;[g00@0KG<000<0IVIV07=R001c
HP000P1cHP020?OB00<0Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<602@0
mPh000@0mm80085D0021E000PE@00P3gX@05084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e0
00P0mg001@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh00`3oool30:99
00X0mg001@2R2@0Q0?H>00T0oooo102Z;0020?Lo00H0ZPX07`3f3P0@0?ooo`D0/@X03`3f3P000`00
0000mPh00?H>00060?H>00@00000o`3oool/0?ooo`00M@3oool00`000000oooo0?ooo`0200000140
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`<0`?l03`3oool4000000X0
oooo0P2jm`0306ec000306IVIP3[m`00Lf8000<0Lf800P3gdP0307=;0080mj400P1c=0000`000000
mg000?M`000407<M0080mcl00`1c1P0T0?H>00040?OB0021E000PE@0085D0080mj401@21>`070?M`
00D0P@L08`3f3P0208eL0080mj401@2=@0080?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW
0080mcl01@2H2@0R0?H>0080oooo102RB@0:0?M`00D0XPT08@3f3P080?ooo`D0ZR`00P3g?`060:X:
01l0mPh0403oool50;4:00l0mPh000<000000?H>003f3P002P3f3P0400000?l0oooo:03oool007@0
oooo1@00000B0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`02000000L0oooo00<0Eg<00;[g002jm`000`1]L`000`1VIVH0joL007=R000307=R0080
mm800`1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H0903f3P00103gdP00
PE@0085D0021E0020?NQ00D0PC/01`3gL005084702<0mPh00P2=G0020?NQ00D0SD00203gL00508d8
0280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P000`3oool0XTT00:9900030:99
00X0mg001@2R2@0Q0?H>00P0oooo1@2Z;0020?Lo00H0ZPX07`3f3P0?0?ooo`H0/@X0803f3P050000
0440oooo1@0000020?ooo`<00000103oool3000000D0oooo0`0000380?ooo`00YP3oool3000001T0
oooo00<000000?ooo`3oool02P3oool00`1GL`00^_L00;[g000206ec000306IVIP1]L`00joL000@0
Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00<0
L`H0903f3P00103gdP00PE@0085D0021E0020?NQ00D0PC/01`3gL005084702<0mPh00P2=G0020?NQ
00D0SD00203gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P000`3o
ool0XTT00:9900030:9900X0mg001@2R2@0Q0?H>00L0oooo1P2Z;0020?Lo00H0ZPX07`3f3P0>0?oo
o`L0/@X0803f3P050?ooo`@00000?`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0<D0oooo00320?oo
o`030000003oool0oooo00T0oooo0P1GL`020;[g0080KG<000<0IVIV0>_g003[m`00101cHP000`3g
dP00Ld/007=;000207=;0080mj400P1c=0000`000000mg000?M`000407<M00030?Lo001c1P00L`H0
0080L`H0903f3P00103gdP00PE@0085D0021E0020?NQ00D0PC/01`3gL005084702<0mPh00P2=G002
0?NQ00D0SD00203gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P06
0:9900X0mg001@2R2@0Q0?H>00H0oooo1`2Z;0020?Lo00H0ZPX07`3f3P0?0?ooo`H0/@X0803f3P09
0?ooo`@00000>`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`350?ooo`00O03oool3000004<0oooo00<00000
0?ooo`3oool02@3oool205Mc0080^_L00P1]L`000`1VIVH0joL00>_g000407=R00030?OB001cB`00
Ld/00080Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0T
0?H>00@0PE@00P3gX@05084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000P0mg001@2=200R
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08@3f3P07
0?ooo`H0ZR`00P3g?`060:X:01l0mPh03`3oool60;4:0200mPh03@3oool4000003L0oooo00<00000
0?ooo`3oool00`3oool4000000<0oooo100000020?ooo`050000003oool0oooo0?ooo`000000a`3o
ool007d0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`090?ooo`<0Eg<00P2jm`00
0`1]L`00IVIV06ec00020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<00000
0?M`003gL000101c7@000`3g?`00L`H007<6000207<602@0mPh01021E0020?NQ00D0PC/01`3gL005
084702<0mPh00P2=G0020?NQ00D0SD00203gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`02
0?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00L0oooo1P2Z;0020?Lo00H0ZPX07`3f3P0?
0?ooo`H0/@X0803f3P0A0?ooo`@000003@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool300000<P0oooo001m0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02@3o
ool305Mc0080^_L000<0KG<006IVIP1]L`000P3[m`0307=R0080mm80101cB`001@3gX@00Lc@007<d
001c=00000000080mg000`1c7@020?Lo00@0L`H0903f3P04085D0080mj401@21>`070?M`00D0P@L0
8`3f3P0208eL0080mj401@2=@0080?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl0
1@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh01`3oool60:X/0080mcl01P2Z2P0O0?H>00l0oooo
1P2a2P0P0?H>01<0oooo00<0^0/00?H>00000000100000080?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000a`3oool004D0oooo0`0000030?oo
o`D000000`3oool3000000@0oooo0`0000020?ooo`<0000000@0oooo0000000000000000203oool3
00000080oooo0P0000020?ooo`<000000`3oool4000000@0oooo0`000000103oool000000000003o
ool3000000<0oooo1P0000000`3oool0000000000003000000<0oooo0`0000060?ooo`<0SOl04`3o
ool00`000000oooo0?ooo`090?ooo`@0Eg<00P2jm`000`1VIVH0KG<006ec00020>_g00<0Lf800P3g
dP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00307<M0080mcl0101c1P0T0?H>00@0PE@0
0P3gX@04084k00P0mg001@211`0R0?H>00<0SE`00P3gX@0508e000P0mg001@2=200R0?H>0080mj40
1@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08@3f3P070?ooo`H0ZR`0
0P3g?`060:X:01l0mPh0303oool30?@n00H0/@X0803f3P0B0?ooo`80^0/01P3f3P04000000@0oooo
00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000037
0?ooo`00A03oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool5
08go0180oooo00<000000?ooo`3oool02@3oool405Mc0080^_L000<0IVIV06ec001]L`000P3[m`03
07=R0080mm80101cB`00103gX@00Lc@007<d001c=002000000040?M`001c7@00Lad007<M0080mcl0
101c1P0T0?H>00@0PE@00P3gX@04084k00P0mg001@211`0R0?H>00<0SE`00P3gX@0508e000P0mg00
1@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT0
8@3f3P030?ooo`040:Y=003gL000mg000?M`00H0ZR`00P3g?`060:X:01l0mPh02`3oool40?@n00H0
/@X0803f3P0A0?ooo`<0^0/02P3f3P05000002<0oooo0`0000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00370?ooo`00A03oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
0000000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`050?ooo`L0SOl0403oool00`000000oooo0?ooo`0:0?ooo`@0Eg<000<0
^_L006IVIP1]L`000P1]L`020>_g00<0Lf800P3gdP0407=;00060?NQ001c=000Lc@007<d00000000
mg000P00000207<M0080mcl0101c1P0T0?H>00@0PE@00P3gX@04084k00P0mg001@211`0R0?H>00<0
SE`00P3gX@0508e000P0mg001@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280
mPh01P2RB@0:0?M`00D0XPT08@3f3P020?ooo`80ZTd00`3gL0060:X/0080mcl01P2Z2P0O0?H>00X0
oooo1@3d?P060;4:0200mPh04@3oool30;P;00h0mPh01000000R0?ooo`030000003oool0oooo00<0
oooo0`0000040?ooo`<00000103oool300000<P0oooo00140?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool500000080oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool0000000X0oooo00@000000?ooo`3oool000000`3oool500000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00D0oooo1`2=o`0@0?ooo`030000003oool0oooo00X0oooo101GL`000`2jm`00IVIV
06ec000206ec0080joL00`1cHP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00<0
Lad00P3g?`0407<602@0mPh01021E0020?NQ00@0PC/0203gL004084702<0mPh00`2=G0020?NQ00@0
SD002@3gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0
mg001@2R2@0Q0?H>0080oooo0P2ZC@030?M`00H0ZR`00P3g?`060:X:01l0mPh02P3oool50?@n00H0
/@X0803f3P0@0?ooo`@0^0/03`3f3P000`000000mPh00?H>000400000?d0oooo00140?ooo`030000
003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool00`000000oooo0?ooo`08
0?ooo`@000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool708go0100oooo00<000000?ooo`3oool02P3oool405Mc000306IVIP1]L`00
KG<00080KG<00P3[m`0307=R0080mm800`1cB`020?NQ00<0Lc@000<000000?M`003gL0000`1c7@02
0?Lo00@0L`H0903f3P04085D0080mj401021>`080?M`00@0P@L08`3f3P0308eL0080mj40102=@009
0?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL005
0:890240mPh000@0oooo0:Y=002ZC@00ZTd00`3gL0060:X/0080mcl01P2Z2P0O0?H>00T0oooo1P3d
?P060;4:0200mPh03`3oool50;P;00l0mPh000<000000?H>003f3P00103f3P0500000?P0oooo0014
0?ooo`050000003oool0oooo0?ooo`0000000P3oool5000000<0oooo0`0000040?ooo`<000000`3o
ool010000000oooo00000000000;0?ooo`050000003oool0oooo0?ooo`0000000`3oool300000080
oooo00<000000?ooo`0000000P0000020?ooo`8000000P3oool200000080oooo100000050?ooo`03
0000003oool0oooo0080oooo0`0000050?ooo`<000001@3oool508go00`0oooo0P0000020?ooo`03
0000003oool0oooo00T0oooo0P29n00405Mc000306IVIP1]L`00KG<00080KG<00P3[m`0307=R0080
mm800`1cB`020?NQ00<0Lc@000<000000?M`001c7@000`1c7@020?Lo00@0L`H08`3f3P000`3gdP00
PE@0085D0002085D0080mj401021>`080?M`00@0P@L08`3f3P0308eL0080mj40102=@0090?M`00D0
S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240
mPh000@0oooo0:Y=002ZC@00ZTd00`3gL0060:X/0080mcl01P2Z2P0O0?H>00P0oooo1`3d?P060;4:
0200mPh03`3oool50;P;00l0mPh000<000000?H>003f3P002@3f3P0400000?@0oooo00140?ooo`05
0000003oool0oooo0?ooo`0000005`3oool00`000000oooo0?ooo`0<0?ooo`050000003oool0oooo
0?ooo`0000005`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo0`2=o`0?
0?ooo`@000002P3oool208Wh00@0Eg<000<0IVIV06ec001]L`000P1]L`020>_g00<0Lf800P3gdP03
07=;0080mj400P1c=0000`000000Lc@00?M`000407<M0080mcl00`1c1P0T0?H>00030?OB0021E000
PE@00080PE@00P3gX@04084k00P0mg0010211`0S0?H>00<0SE`00P3gX@0408e000T0mg001@2=200R
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08@3f3P04
0:Y=00<0mg001P2Z;0020?Lo00H0ZPX07`3f3P080?ooo`L0m3h01P2a2P0P0?H>00h0oooo1P2h2`0N
0?H>00030?ooo`000000000000800000@@3oool500000080oooo0`0000040?ooo`<00000103oool3
000009L0oooo00150?ooo`<00000603oool00`000000oooo0?ooo`0;0?ooo`D00000603oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool00P0000070?oo
o`0303mc0029n000ROP000<0Eg<000<0IVIV0;[g001]L`000`1]L`020>_g00<0Lf800P3gdP0307=;
0080mj400P1c=0000`000000Lc@00?M`000407<M0080mcl00`1c1P0T0?H>00030?OB0021E000PE@0
0080PE@00P3gX@04084k00P0mg0010211`0S0?H>00<0SE`00P3gX@0408e000T0mg001@2=200R0?H>
0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08@3f3P040:Y=
00<0mg001P2Z;0020?Lo00H0ZPX07`3f3P070?ooo`P0m3h01P2a2P0P0?H>00d0oooo1`2h2`0O0?H>
00@0oooo1000000o0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo09@0oooo001O0?ooo`800000:@3oool2000000H0
oooo0`0000060?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool00`0oL`00
ROP008Wh000305Mc000306IVIP2jm`00KG<000<0KG<000<0joL007=R001cHP000P1cHP020?OB00<0
Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0307<602@0mPh000<0mm80085D0021
E0000P21E0020?NQ00@0PC/0203gL004084702<0mPh00`2=G0020?NQ00@0SD002@3gL00508d80280
mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0
ZTd00`3gL0060:X/0080mcl01P2Z2P0O0?H>00H0oooo2@3d?P060;4:0200mPh03P3oool60;P;01l0
mPh0203oool4000003/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0T`3oool00;`0oooo00<000000?ooo`3oool0
2@3oool203mc0080ROP00P1GL`000`1VIVH0^_L00;[g000406ec00030>_g001cHP00Lf800080Lf80
0P3gdP0307=;0080mj4000<0Lc@006IVIP0000000P3gL00407<M0080mcl00`1c1P0T0?H>00030?OB
0021E000PE@00080PE@00P3gX@04084k00P0mg0010211`0S0?H>00<0SE`00P3gX@0408e000T0mg00
1@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT0
8@3f3P040:Y=00<0mg001P2Z;0020?Lo00H0ZPX07`3f3P0;0?ooo`@0m3h01P2a2P0P0?H>00h0oooo
1P2h2`0O0?H>00`0oooo1@00000f0?ooo`030000003oool0oooo00<0oooo100000030?ooo`@00000
0`3oool4000009D0oooo002l0?ooo`030000003oool0oooo00T0oooo0P0oL`0208Wh0080Eg<000<0
IVIV0;[g002jm`00101]L`000`3[m`00Lf8007=R000207=R0080mm800`1cB`020?NQ000307<d001V
IVH000000080mg00101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D00030?NQ0021
>`00PC/000<0PC/0203gL004084702<0mPh00`2=G0020?NQ00@0SD002@3gL00508d80280mPh00P3g
X@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3g
L0060:X/0080mcl01P2Z2P0O0?H>00l0oooo1P2a2P0P0?H>00h0oooo1P2h2`0O0?H>0140oooo1000
000=0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`000000U@3oool00;`0oooo00<000000?ooo`3oool0203oool303mc0080ROP000<0Eg<006IVIP1G
L`000P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0307=;0080mj4000<0IVIV07<d0000
00000P3gL00407<M0080mcl00`1c1P0T0?H>00030?OB0021E000PE@00080PE@000<0mj40084k0021
>`000`21>`080?M`00@0P@L08`3f3P0308eL0080mj40102=@0090?M`00D0S@P08P3f3P020?NQ00D0
V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0102ZC@030?M`00H0
ZR`00P3g?`060:X:01l0mPh03`3oool60;4:0200mPh03P3oool60;P;01l0mPh04`3oool00`2m2`00
mPh000000003000000T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo0000002E0?ooo`00^`3oool00`000000oooo0?ooo`090?ooo`<0?g<00P29n000
0`1GL`00IVIV05Mc00020;[g00@0KG<000<0joL007=R001cHP000P1cHP000`3gdP00Ld/007=;0002
07=;0080mj4000<0IVIV07<d000000000P3gL00407<M0080mcl00`1c1P0T0?H>00030?OB0021E000
PE@00080PE@000<0mj40084k0021>`000`21>`070?M`00D0P@L08`3f3P0308eL0080mj40102=@009
0?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL005
0:890240mPh0102ZC@030?M`00H0ZR`00P3g?`060:X:01l0mPh03`3oool60;4:0200mPh02P3oool0
102h;`00mcl00?Lo003g?`060;P;01l0mPh04P3oool20;d;00D0mPh0100000050?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000U@3oool00700
oooo100000040?ooo`D0000000@0oooo00000000000000000P3oool2000000030?ooo`0000000000
00@000000P3oool3000000030?ooo`0000000000008000000P3oool200000080oooo0`0000000`3o
ool000000?ooo`020?ooo`<0Fol0503oool00`000000oooo0?ooo`080?ooo`@0?g<00P29n0000`1G
L`00IVIV05Mc00020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/000D0mj4006IV
IP1c=000Lc@0000000020?M`00@0Lad00P3g?`0307<602@0mPh000<0mm80085D0021E0000P21E000
0`3gX@00PC/0084k0003084k00L0mg001@211`0S0?H>00<0SE`000<0mj4008e0002=@0000`2=@009
0?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL005
0:890240mPh0102ZC@030?M`00H0ZR`00P3g?`060:X:0200mPh00P3oool00`2aD000mg000?M`0002
0?M`00L0oooo1P2a2P0P0?H>00T0oooo0P2h;`030?Lo00H0^0/07`3f3P0A0?ooo`<0_@/02@3f3P04
000000030?ooo`000000oooo0240oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000002E0?ooo`00
L@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo1@1K
o`0B0?ooo`030000003oool0oooo00T0oooo100oL`0208Wh000306IVIP1GL`00Eg<00080^_L00`1]
L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`001@3gX@00IVIV07<d001c=00000000080mg00
101c7@020?Lo00<0L`H0903f3P00103gdP00PE@0085D0021E0020?NQ00D0PC/01`3gL005084702<0
mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0
V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl01P2Z2P0P0?H>0003
0?ooo`2aD000/E0000P0mg000`3oool70;4:01l0mPh0203oool30;P_00<0mcl01P2h2`0O0?H>0140
oooo0`2m2`0=0?H>00D000008@3oool00`000000oooo0?ooo`030?ooo`<00000103oool3000000@0
oooo0`00002F0?ooo`00L@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo1`1Ko`0A0?ooo`030000003oool0oooo00T0oooo100oL`0208Wh000306IVIP1G
L`00Eg<00080^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`001@1VIVH0mj4007<d
001c=00000000080mg00101c7@020?Lo00<0L`H0903f3P00103gdP00PE@0085D0021E0020?NQ00D0
PC/01`3gL005084702<0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00P3gX@0509Q50080
mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080
mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:01l0mPh0203oool30;P_00<0mcl01P2h2`0O0?H>0100
oooo102m2`0?0?H>00030000003f3P00mPh000@00000bP3oool00740oooo00<000000?ooo`000000
1P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`L0Fol0403oool00`000000oooo0?ooo`0:0?ooo`@0?g<000<0ROP0
06IVIP1GL`000P1GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/000D0IVIV
07<d001c=000Lc@0000000020?M`00@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>00040?OB0021
E000PE@0085D0080mj401@21>`070?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0S@P0
8P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0
102ZC@030?M`00H0ZR`00P3g?`060:X:0200mPh00`2aD00;0?M`00L0/@X07`3f3P070?ooo`@0^2l0
0`3g?`060;P;01l0mPh03`3oool50;d;00l0mPh000<000000?H>003f3P00103f3P0400000<H0oooo
001a0?ooo`<000001P3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P0000020?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool01`1Ko`0@0?ooo`030000003oool0oooo00X0oooo
100oL`000`29n000IVIV05Mc000205Mc0080^_L00`1]L`020>_g00<0Lf800P3gdP0307=;000306IV
IP3gX@00Lc@00080Lc@000<000000?M`003gL000101c7@000`3g?`00L`H007<6000207<602@0mPh0
00@0mm80085D0021E000PE@00P3gX@05084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0
mg001@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0
XPT08@3f3P040:Y=00<0mg001P2Z;0020?Lo00H0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00D0
oooo1@2h;`030?Lo00H0^0/07`3f3P0?0?ooo`D0_@/03`3f3P000`000000mPh00?H>00080?H>00@0
0000@`3oool5000000<0oooo0`0000040?ooo`<00000103oool3000006H0oooo001a0?ooo`050000
003oool000000?ooo`0000000P3oool3000000<0oooo00<000000?ooo`0000000P0000050?ooo`03
0000003oool0oooo0080oooo100000020?ooo`030000003oool0000000800000103oool4000000<0
oooo1@1Ko`0=0?ooo`8000000P3oool00`000000oooo0?ooo`090?ooo`0305Sh000oL`00?g<00080
?g<000<0IVIV05Mc001GL`000P1GL`020;[g00<0KG<00P3[m`0307=R0080mm800`1cB`000`1VIVH0
mj4007<d000207<d00030000003gL000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>0004
0?OB0021E000PE@0085D0080mj401@21>`070?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`
00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:89
0240mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00;0?M`00L0/@X0803f3P050?oo
o`D0^2l00`3g?`060;P;01l0mPh03P3oool60;d;00l0mPh000<000000?H>003f3P002`3f3P000`3o
ool0000000000002000003l0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo0000001U0?ooo`00L@3oool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`020?ooo`<0Fol0403oool3000000/0oooo00<0F?P003mc000o
L`000P0oL`000`1VIVH0Eg<005Mc000205Mc0080^_L00`1]L`020>_g00<0Lf800P3gdP0307=;0003
06IVIP3gX@00Lc@00080Lc@000<000000?M`003gL0000`1c7@020?Lo00@0L`H0903f3P00103gdP00
PE@0085D0021E0020?NQ00D0PC/01`3gL005084702<0mPh00P2=G0020?NQ00D0SD002@3gL00508d8
0280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>
00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0O0?H>00<0/E002`3gL0070;4:0200mPh0103oool60;P_
00<0mcl01`2h2`0N0?H>00d0oooo1`2m2`0N0?H>00@0oooo1@00000k0?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000006D0oooo001`0?ooo`H000004P3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`0000000000203oool00`0YL`00F?P0
03mc000203mc000306IVIP29n000Eg<000<0Eg<00P2jm`0306ec0080joL00`1cHP020?OB0080Ld/0
00<0IVIV07=;003gX@000`1c=0000`000000mg000?M`000307<M0080mcl0101c1P0T0?H>00040?OB
0021E000PE@0085D0080mj401@21>`070?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0
S@P08P3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240
mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00;0?M`00L0/@X0803f3P030?ooo`L0
^2l00`3g?`070;P;01h0mPh03P3oool60;d;01h0mPh02@3oool4000003P0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000I@3oool007X0oooo00<000000?ooo`3oool02@3oool3
000001D0oooo0P00000G0?ooo`030000003oool0oooo00X0oooo00<0:G<005Sh000oL`000P0oL`00
0`1VIVH0ROP005Mc000305Mc00030;[g001]L`00KG<00080KG<00P3[m`0307=R0080mm800P1cB`00
0`1VIVH0Ld/00?NQ000307<d00030000003gL000mg0000<0Lad00P3g?`0407<602@0mPh01021E002
0?NQ00D0PC/01`3gL005084702<0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00P3gX@05
09Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3gL006
0:X/0080mcl01`2Z2P0O0?H>00<0/E002`3gL0070;4:0200mPh0103oool60;P_00<0mcl01`2h2`0N
0?H>00h0oooo1P2m2`0N0?H>00d0oooo1000000e0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool0H`3oool00;L0oooo00<000000?ooo`3oool02@3oool202Uc000605Sh000oL`00?g<003mc001V
IVH0ROP0101GL`000`2jm`00KG<006ec000206ec0080joL00`1cHP020?OB000307=;001VIVH0Ld/0
0080mj400`1c=0000`000000mg000?M`000307<M0080mcl0101c1P0T0?H>00@0PE@00P3gX@05084k
00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0mg001@2=200R0?H>0080mj401@2HA@020?M`
00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08@3f3P040:Y=00<0mg001P2Z;0020?Lo
00L0ZPX07`3f3P030;5@00/0mg001`2a2P0P0?H>00@0oooo1P2h;`030?Lo00L0^0/07P3f3P0>0?oo
o`H0_@/07P3f3P0A0?ooo`@000003@3oool00`000000oooo0?ooo`0N0?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`000000I@3oool00;H0oooo00<000000?ooo`3oool0
2P3oool202Uc000405Sh000oL`00?g<006IVIP80ROP0101GL`000`2jm`00KG<006ec000206ec0080
joL00`1cHP020?OB000307=;001VIVH0Ld/00080mj400`1c=0000`000000mg0007<M000307<M0080
mcl0101c1P0T0?H>00@0PE@00P3gX@05084k00L0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0
mg001@2=200R0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0
XPT08@3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX07`3f3P030;5@00/0mg001`2a2P0P0?H>00@0
oooo1P2h;`030?Lo00L0^0/07P3f3P0>0?ooo`H0_@/07P3f3P0C0?ooo`030<8;003f3P00000000<0
00002@3oool00`000000oooo0?ooo`0N0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`000000I@3oool00;H0oooo00<000000?ooo`3oool02@3oool302Uc000405Sh000o
L`00?g<006IVIP80ROP00`1GL`020;[g00@0KG<00P3[m`0307=R0080mm8000<0IVIV07=;001cB`00
0P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602@0mPh01021E0020?NQ00D0PC/0
1`3gL005084702<0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00P3gX@0509Q50080mg00
1P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl0
1`2Z2P0O0?H>00<0/E002`3gL0070;4:0200mPh0103oool60;P_00<0mcl01`2h2`0O0?H>00T0oooo
103d?P060;d;01h0mPh04P3oool20<8;00D0mPh01@0000040?ooo`030000003oool0oooo01h0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000001U0?ooo`00]P3oool0
0`000000oooo0?ooo`090?ooo`<0:G<000@0F?P003mc001VIVH0?g<00P29n00305Mc0080^_L0101]
L`000`3[m`00Lf8007=R000207=R0080mm8000<0IVIV07=;001cB`000P3gX@0207<d00030000001c
=000mg0000@0Lad00P3g?`0307<602D0mPh01021E0020?NQ00@0PC/0203gL005084702<0mPh00P2=
G0020?NQ00D0SD002@3gL00508d80280mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f
3P060:9900X0mg001@2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0O0?H>00<0/E00303g
L0060;4:0200mPh000@0^5<00?M`003gL000mg001P2h;`030?Lo00L0^0/07`3f3P080?ooo`D0m3h0
1P2m2`0N0?H>0140oooo0`322`0:0?H>00D000008@3oool3000000@0oooo0`0000040?ooo`<00000
103oool3000006H0oooo00120?ooo`<000000P3oool300000080oooo0P0000000`3oool000000000
0003000000@0oooo0`0000030?ooo`<00000103oool3000000030?ooo`000000oooo00P0oooo1000
00050?ooo`<000000`3oool3000000030?ooo`000000oooo0080oooo0`0000030?ooo`<00000103o
ool3000000D0oooo0`0Xo`0C0?ooo`030000003oool0oooo00T0oooo100YL`00101Hn000?g<006IV
IP0oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf8000<0mm8006IVIP1cB`00
0P1cB`020?NQ0080Lc@000<0000007<d003gL000101c7@020?Lo00<0L`H09@3f3P04085D0080mj40
1021>`080?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0S@P08P3f3P020?NQ00D0V4D0
0P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0102ZC@030?M`00H0ZR`0
0P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00<0
mcl01`2h2`0O0?H>00L0oooo1P3d?P070;d;01d0mPh04@3oool30<8;00h0mPh01000002L0?ooo`00
@@3oool2000000030?ooo`00000000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`000000
0`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`040000003o
ool0oooo0?ooo`D0:?l04P3oool00`000000oooo0?ooo`090?ooo`@0:G<000<0F?P006IVIP0oL`00
1@0000000`1GL`00^_L00;[g00030000000306ec003[m`00Lf8000<0Lf8000<0mm8006IVIP1cB`00
0P1cB`020?NQ0080Lc@000<0000007<d003gL000101c7@020?Lo00<0L`H09@3f3P04085D0080mj40
1021>`080?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0S@P08P3f3P020?NQ00D0V4D0
0P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0102ZC@030?M`00H0ZR`0
0P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00<0
mcl01`2h2`0O0?H>00H0oooo1`3d?P070;d;01d0mPh0403oool40<8;00l0mPh000<000000?H>003f
3P001000002H0?ooo`00@@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000003P3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0702So0100oooo00<000000?ooo`3oool0
2P3oool402Uc000405Sh001VIVH0?g<000000080ROP000D0Eg<00000001GL`00^_L00000000306ec
00030000003[m`00Lf8000<0Lf8000<0mm8006IVIP1cB`000P1cB`020?NQ0080Lc@000<000000?M`
003gL000101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`
00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0S@P08P3f3P020?NQ00D0V4D00P3gL00609PW
0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:
01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00<0mcl01`2h2`0O
0?H>00H0oooo1`3d?P070;d;01d0mPh03`3oool50<8;00l0mPh000<000000?H>003f3P00103f3P04
000009@0oooo00110?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`D000000P3o
ool01@000000oooo0?ooo`3oool0000000`0oooo0`0000030?ooo`030000003oool0oooo00@0oooo
100000030?ooo`030000003oool0oooo00<0oooo1@0000030?ooo`<000000`3oool702So0100oooo
00<000000?ooo`3oool02P3oool402Uc000605Sh001VIVH0?g<003mc00000000ROP00`1GL`000`2j
m`00000006ec000206ec00030000003[m`00Lf8000<0Lf8000<0IVIV07=;001cB`000P1cB`020?NQ
0080Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D
0080mj401021>`080?M`00D0P@L08`3f3P0208eL0080mj401@2=@0090?M`00D0S@P08P3f3P020?NQ
00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0102ZC@030?M`
00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`003gL006
0;P_00@0mcl01P2h2`0O0?H>00D0oooo203d?P070;d;01d0mPh03`3oool50<8;00l0mPh000<00000
0?H>003f3P00203f3P05000008l0oooo00110?ooo`050000003oool0oooo0?ooo`0000000P3oool2
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
2P3oool3000000D0oooo00<000000?ooo`3oool01`3oool01@000000oooo0?ooo`3oool0000000D0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool7
02So00l0oooo00<000000?ooo`3oool02`3oool402Uc000606IVIP0oL`00?g<003mc0029n0000000
0`1GL`000`2jm`00000006ec000206ec00030000003[m`00Lf8000<0Lf8000<0IVIV07=;001cB`00
0P1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0
085D0002085D0080mj401021>`080?M`00@0P@L0903f3P0208eL0080mj401@2=@0090?M`00@0S@P0
8`3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890240mPh0
102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg00
0?M`003gL0060;P_00@0mcl01P2h2`0O0?H>00@0oooo2@3d?P070;d;01d0mPh03P3oool60<8;01h0
mPh000<0oooo0000000000000P00002;0?ooo`00@@3oool020000000oooo0?ooo`3oool000000?oo
o`000000oooo0`0000030?ooo`<00000103oool5000000<0oooo0`0000040?ooo`@000002P3oool0
0`000000oooo0?ooo`040?ooo`D000000P3oool4000000<0oooo1@0000030?ooo`<00000103oool3
000000@0oooo1@0Xo`0<0?ooo`D000002`3oool202Oh00@0:G<000@0IVIV03mc000oL`00?g<00P29
n0001@000000Eg<005Mc002jm`00000000<0KG<000<000000>_g001cHP000P1cHP000`1VIVH0mm80
07=;000307=;0080mj400P1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0T0?H>00030?OB
0021E000PE@00080PE@00P3gX@04084k00P0mg0010211`0T0?H>0080SE`00P3gX@0508e000T0mg00
102=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT0
8P3f3P030:Y=00<0mg001P2Z;0020?Lo00L0ZPX07`3f3P030;5@00`0mg001P2a2P0P0?H>00040;QC
003gL000mg000?M`00H0^2l0103g?`060;P;01l0mPh00`3oool:0?@n00L0_@/07@3f3P0=0?ooo`L0
`P/07P3f3P050?ooo`@00000Q`3oool00440oooo00D000000?ooo`3oool0oooo0000000A0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`<0:?l04@3oool40000
00L0oooo00<04W<002Oh000Wn0000`0YL`001@1VIVH0?g<003mc000oL`0000000080ROP000D0Eg<0
0000001GL`00^_L00000000306ec00030000003[m`00Lf800080Lf8000<0IVIV0?OB001cB`000`1c
B`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D
0002085D0080mj401021>`080?M`00@0P@L0903f3P0208eL0080mj401@2=@0090?M`00@0S@P08`3f
3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh00`2Z
C@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`
003gL0060;P_00@0mcl01P2h2`0O0?H>0080oooo2`3d?P070;d;01d0mPh03P3oool60<8;01h0mPh0
2@3oool4000008<0oooo00100?ooo`<0000000@0oooo0000000000000000403oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00T0oooo100000030?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`090?ooo`03019c000Wn0009oP000<0:G<0
00H0IVIV03mc000oL`00?g<000000029n00205Mc00040000001GL`00^_L0000000<0KG<000L00000
0>_g001cHP00Lf8006IVIP1cHP00mm8000@0Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad0
0P3g?`0307<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL004084702@0mPh0
0P2=G0020?NQ00D0SD002@3gL00408d802<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00D0V0T0
8P3f3P060:9900X0mg001@2R2@0R0?H>00<0ZTd00`3gL0060:X/00<0mcl01P2Z2P0O0?H>00<0/E00
303gL0060;4:0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00H0^0/07`3f3P070?ooo`H0
m3h01`2m2`0N0?H>00d0oooo1P322`0N0?H>00d0oooo1000001o0?ooo`00D@3oool00`000000oooo
0?ooo`0C0?ooo`800000B@3oool00`000000oooo0?ooo`080?ooo`804W<00P0Wn00202Uc000306IV
IP1Hn000?g<00080?g<000P0000008Wh001GL`00Eg<00000001GL`00^_L0000000<0KG<000D00000
0>_g001cHP00Lf8006IVIP020?OB00@0Ld/000@0mj4007<d001c=000Lc@01000000307<M0080mcl0
0`1c1P0T0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg0010211`0T0?H>0080SE`0
0P3gX@0508e000T0mg00102=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh0
1P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0mg001P2Z;0030?Lo00H0ZPX07`3f3P030;5@00`0mg00
1P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`060;P;01l0mPh02`3oool20?@n00L0
_@/07P3f3P0=0?ooo`H0`P/07P3f3P0A0?ooo`D000002`3oool00`000000oooo0?ooo`1/0?ooo`00
T@3oool3000001d0oooo00<000000?ooo`3oool02@3oool2019c00809oP00P0YL`000`1VIVH0F?P0
03mc000303mc00<000000P1GL`020;[g00<000000P3[m`000`1cHP00IVIV07=R00020?OB00@0Ld/0
00D0mj4007<d001c=000Lc@0000000020?M`000507<M0000000000000000003g?`00101c1P0T0?H>
00030?OB0021E000PE@00080PE@000<0mj40084k0021>`000`21>`080?M`00@0P@L08`3f3P0308eL
0080mj401@2=@0090?M`00@0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>
00H0XTT02P3gL0050:890280mPh00`2ZC@030?M`00H0ZR`00`3g?`060:X:01l0mPh00`2aD00<0?M`
00H0/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01P2h2`0O0?H>00d0oooo1`2m2`0N
0?H>00d0oooo1`322`0M0?H>01<0oooo00<0a``00?H>003f3P00100000070?ooo`030000003oool0
oooo06`0oooo002D0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0203oool3019c
00809oP000@0:G<006IVIP0YL`00F?P0100oL`000`29n000Eg<005Mc000205Mc0080^_L00`1]L`02
0>_g000307=R001VIVH0Lf800080mm80101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c
7@000`3g?`00L`H007<6000207<602@0mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k
0003084k00P0mg0010211`0S0?H>00<0SE`00P3gX@0508e000T0mg00102=200S0?H>0080mj401@2H
A@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0mg001P2Z
;0030?Lo00H0ZPX07`3f3P030;5@00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l0
0`3g?`060;P;01l0mPh03P3oool60;d;01h0mPh02@3oool01032<P00mcl00?Lo003g?`070<8;01d0
mPh04P3oool20<L<00H0mPh0100000030?ooo`030000003oool0oooo06`0oooo002D0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool02@3oool3019c00809oP000@0:G<006IVIP0YL`00
F?P00`0oL`0208Wh00@0Eg<00P2jm`0306ec0080joL000<0IVIV07=R001cHP000P3gdP0407=;0005
0?NQ001c=000Lc@007<d000000000P3gL00407<M00030?Lo001c1P00L`H00080L`H0903f3P000`3g
dP00PE@0085D0002085D00030?NQ0021>`00PC/000<0PC/0203gL004084702<0mPh00`2=G0020?NQ
00D0SD002@3gL00408d80280mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P9
0280mPh01P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0mg001P2Z;0030?Lo00H0ZPX07`3f3P030;5@
00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`060;P;01l0mPh000<0_EH0
0?M`003gL0000P3gL0090?ooo`H0_@/07P3f3P080?ooo`80`S800`3g?`070<8;01d0mPh04@3oool3
0<L<00X0mPh01000001^0?ooo`00D03oool6000000<0oooo0`000000103oool00000000000000003
0?ooo`8000000P3oool300000080oooo0P0000000`3oool000000?ooo`03000000040?ooo`000000
0000000000@0oooo0`0000040?ooo`<0000000<0oooo0000003oool0100000040?ooo`@000001@3o
ool3003o2Q<0oooo00<000000?ooo`3oool0203oool4019c00809oP000@0:G<006IVIP0YL`00F?P0
0`0oL`0208Wh00@0Eg<000<0^_L006ec001]L`000P1]L`020>_g000306IVIP1cHP00Lf800080mm80
101cB`001@3gX@00Lc@007<d001c=00000000080mg000`1c7@020?Lo00@0L`H0903f3P000`3gdP00
PE@0085D0002085D00030?NQ0021>`00PC/000<0PC/0203gL004084702<0mPh00`2=G0020?NQ00D0
SD002@3gL00408d80280mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P90280
mPh01P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0mg001P2Z;0030?Lo00H0ZPX07`3f3P030;5@00`0
mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`060;P;01l0mPh000<0_EH00?M`
003gL0001P3gL0050?ooo`H0_@/07P3f3P070?ooo`<0`S800`3g?`070<8;01d0mPh0403oool40<L<
00h0mPh01000001Z0?ooo`00D@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`D00?l:
4P3oool00`000000oooo0?ooo`080?ooo`@04W<00P0Wn000101VIVH0:G<002Uc001Hn00303mc0080
ROP0101GL`000`2jm`00KG<006ec000206ec0080joL000<0IVIV07=R001cHP000P3gdP0307=;0080
mj400`1c=0000`000000mg000?M`000307<M0080mcl0101c1P0T0?H>00040?OB0021E000PE@0085D
0080mj401@21>`070?M`00D0P@L08`3f3P0308eL0080mj401@2=@0080?M`00D0S@P08P3f3P000`2H
H`00mj400?NQ000509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>
00<0ZTd00`3gL0060:X/00<0mcl01P2Z2P0O0?H>00<0/E00303gL0060;4:0200mPh000@0^5<00?M`
003gL000mg001`2h;`030?Lo00L0^0/07P3f3P000`2mEP00mg000?M`000:0?M`00030?ooo`2m2`00
_@/000@0_@/07P3f3P060?ooo`@0`S800`3g?`070<8;01d0mPh0403oool40<L<00h0mPh000@00000
0?H>003f3P00mPh01@00001U0?ooo`00D@3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
103oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo1`00o`X@0?ooo`030000
003oool0oooo00T0oooo100BL`0202Oh000406IVIP0YL`00:G<005Sh00<0?g<00P29n00405Mc0003
0;[g001]L`00KG<00080KG<000<0joL006IVIP1cHP000P1cHP020?OB00<0Ld/00P3gX@0307<d0003
0000003gL000mg0000<0Lad00P3g?`0407<602@0mPh000@0mm80085D0021E000PE@00P3gX@05084k
00L0mg001@211`0S0?H>00<0SE`00P3gX@0508e000P0mg001@2=200R0?H>000309QS003gX@00mj40
00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh00`2ZC@030?M`
00L0ZR`00P3g?`060:X:01l0mPh00`2aD00<0?M`00H0/@X08@3f3P030?M`00L0^2l00`3g?`070;P;
01h0mPh000<0_EH00?M`003gL0002`3gL0060;d;01h0mPh01P3oool40<8b00<0mcl01`322`0M0?H>
00l0oooo1@37300>0?H>00030000003f3P00mPh000H0mPh01000001Q0?ooo`00D@3oool00`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?oo
o`D000000P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo1`00o`X@0?oo
o`030000003oool0oooo00T0oooo100BL`000`0Wn000IVIV02Uc000202Uc000405Sh000oL`00?g<0
03mc0080ROP00`1GL`020;[g00@0KG<000<0joL006IVIP1cHP000P1cHP020?OB00<0Ld/00P3gX@03
07<d00030000003gL000Lad000<0Lad00P3g?`0407<602@0mPh000@0mm80085D0021E000PE@00P3g
X@05084k00L0mg001@211`0S0?H>00<0SE`00P3gX@0508e000P0mg001@2=200R0?H>000309QS003g
X@00mj4000D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh00`2Z
C@030?M`00L0ZR`00P3g?`060:X:01l0mPh00`2aD00<0?M`00H0/@X08@3f3P030?M`00L0^2l00`3g
?`070;P;01h0mPh000<0_EH00?M`003gL0002`3gL0060;d;01h0mPh01@3oool50<8b00<0mcl01`32
2`0N0?H>00d0oooo1P37300>0?H>00030000003f3P00mPh000X0mPh01000001M0?ooo`00D@3oool0
0`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0000
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000003oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool0000000<0oooo1`00o`X?0?ooo`030000003oool0oooo00X0oooo100BL`000`0Wn000IVIV
02Uc000202Uc000405Sh000oL`00?g<003mc0080ROP00`1GL`020;[g00@0KG<000<0IVIV07=R001c
HP000P1cHP020?OB00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602@0
mPh000@0mm80085D0021E000PE@00P3gX@05084k00L0mg001@211`0S0?H>00<0SE`00P3gX@0508e0
00P0mg001@2=200R0?H>000309QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>
00H0XTT02P3gL0050:890280mPh00`2ZC@030?M`00L0ZR`00P3g?`060:X:01l0mPh00`2aD00<0?M`
00L0/@X0803f3P030?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01d0mPh0103oool60<8b
00<0mcl01`322`0N0?H>00`0oooo1`37300M0?H>0080oooo1000001I0?ooo`00D@3oool00`000000
oooo0?ooo`030?ooo`8000000P3oool2000000050?ooo`00000000000000003oool00`0000020?oo
o`<000000P3oool3000000030?ooo`000000oooo0080oooo100000040?ooo`<000000P3oool20000
0080oooo0P0000020?ooo`030000003oool00000008000000`3oool3000000030?ooo`000000oooo
0080oooo1@00o`X<0?ooo`8000000P3oool00`000000oooo0?ooo`090?ooo`03003h2@0BL`004W<0
00804W<000<0IVIV02Uc000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00<0Eg<00P2jm`04
06ec000306IVIP1cHP00Lf800080Lf800P3gdP0307=;0080mj400P1c=0000`000000Lc@00?M`0004
07<M0080mcl0101c1P0T0?H>00040?OB0021E000PE@0085D0080mj401@21>`070?M`00D0P@L08`3f
3P0308eL0080mj401@2=@0080?M`00D0S@P08P3f3P000`2HH`00mj400?NQ000509Q50080mg001P2H
9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00<0ZTd00`3gL0070:X/0080mcl01P2Z
2P0O0?H>00<0/E00303gL0070;4:0200mPh0103gL0060;P_00<0mcl01`2h2`0O0?H>00d0mg001`2m
2`0M0?H>00<0oooo1`32<P030?Lo00L0`P/07P3f3P0;0?ooo`P0a``07@3f3P060?ooo`@00000E@3o
ool00540oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0S0?ooo`<00?l:3`3oool4
000000X0oooo00<00?P9019c000BL`000P0BL`000`1VIVH0:G<002Uc000202Uc000405Sh000oL`00
?g<003mc0080ROP00`1GL`020;[g00<0KG<000<0IVIV0>_g001cHP000`1cHP020?OB00<0Ld/00P3g
X@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602@0mPh000@0mm80085D0021E000PE@0
0P3gX@05084k00L0mg001@211`0S0?H>00<0SE`00P3gX@0408e000T0mg001@2=200R0?H>000309QS
003gX@00mj4000D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh0
0`2ZC@030?M`00L0ZR`00P3g?`060:X:01l0mPh0102aD00;0?M`00L0/@X0803f3P040?M`00H0^2l0
0`3g?`070;P;01l0mPh03@3gL0070;d;01d0mPh00P3oool80<8b00<0mcl01`322`0N0?H>00`0oooo
1`37300M0?H>00X0oooo1@00001@0?ooo`00D03oool300000240oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`02000000L0oooo00<007<4003h2@0BL`000P0BL`000`1VIVH09oP002Uc
000302Uc000405Sh000oL`00?g<003mc0080ROP00`1GL`020;[g00<0KG<000<0IVIV0>_g001cHP00
0`1cHP020?OB00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0307<602D0mPh0
1021E0020?NQ00D0PC/01`3gL005084702<0mPh00`2=G0020?NQ00@0SD002@3gL00508d80280mPh0
00<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT0
8P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00@0mg00
1P2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/07@3f3P030?ooo`L0`S80103g?`060<8;01h0mPh0
303oool70<L<01d0mPh03`3oool4000004`0oooo001c0?ooo`800000>03oool00`000000oooo0?oo
o`090?ooo`03001c1000n0T04W<000804W<000<0IVIV02Oh000YL`000`0YL`0403mc0080ROP00`1G
L`020;[g0080KG<000<0IVIV06ec003[m`00101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c
=0000`000000mg000?M`000407<M0080mcl00`1c1P0U0?H>00@0PE@00P3gX@05084k00L0mg001@21
1`0S0?H>00<0SE`00P3gX@0408e000T0mg001@2=200R0?H>000309QS003gX@00mj4000D0V4D00P3g
L00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh00`2ZC@030?M`00L0ZR`00P3g
?`060:X:0200mPh00`2aD00;0?M`00L0/@X0803f3P040?M`00H0^2l00`3g?`070;P;01l0mPh03@3g
L0070;d;01d0mPh00`3oool70<8b00@0mcl01P322`0N0?H>00`0oooo2037300L0?H>01<0oooo1000
00180?ooo`00[03oool00`000000oooo0?ooo`090?ooo`8007<400H00?P9019c000BL`004W<006IV
IP0Wn00402Uc00@0?g<00P29n00305Mc0080^_L00P1]L`000`1VIVH0joL00>_g000407=R00030?OB
001cB`00Ld/00080Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh0
1021E0020?NQ00D0PC/01`3gL005084702<0mPh00`2=G0020?NQ00@0SD002@3gL00508d80280mPh0
00<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT0
8P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00040;QC
003gL000mg000?M`00H0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3oool70<8b00@0
mcl01P322`0N0?H>00`0oooo2037300L0?H>01L0oooo100000140?ooo`00[03oool00`000000oooo
0?ooo`090?ooo`8007<400@00?P9019c000BL`00IVIV0P0Wn00402Uc00@0?g<00P29n00305Mc0080
^_L000<0KG<006IVIP1]L`000P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@0207<d0003
0000003gL000mg0000@0Lad00P3g?`0307<602D0mPh01021E0020?NQ00D0PC/01`3gL005084702<0
mPh00`2=G0020?NQ00@0SD002@3gL00508d80280mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0
V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0
ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00H0^2l00`3g?`070;P;
01l0mPh03@3gL0070;d;01h0mPh00P3gL0070<8b00@0mcl01`322`0M0?H>00P0oooo103d?P080<L<
01`0mPh06`3oool400000400oooo002[0?ooo`030000003oool0oooo00T0oooo0`00L`@01000n0T0
4W<0019c001VIVH202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00P2jm`000`1]
L`00IVIV06ec00020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<000000?M`
003gL000101c7@020?Lo00<0L`H09@3f3P04085D0080mj401@21>`070?M`00D0P@L08`3f3P0308eL
0080mj40102=@0090?M`00D0S@P08P3f3P000`2HH`00mj400?NQ000509Q50080mg001P2H9`020?Lo
00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00<0ZTd00`3gL0070:X/0080mcl01P2Z2P0P0?H>
00<0/E002`3gL0070;4:0200mPh000@0^5<00?M`003gL000mg001P2h;`030?Lo00L0^0/07`3f3P0=
0?M`00L0_@/07P3f3P020?M`00L0`S80103g?`070<8;01d0mPh01`3oool50?@n00P0a``0703f3P0O
0?ooo`<00000?@3oool00:/0oooo00<000000?ooo`3oool02@3oool3001c1004003h2@0BL`00IVIV
019c00809oP00`0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`00
0`1]L`00IVIV06ec00020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<00000
0?M`003gL000101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj401@21>`07
0?M`00D0P@L08`3f3P0308eL0080mj40102=@0090?M`00D0S@P08P3f3P000`2HH`00mj400?NQ0005
09Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00<0ZTd00`3gL007
0:X/0080mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:0200mPh000@0^5<00?M`003gL000mg001P2h
;`040?Lo00H0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;01d0mPh01P3o
ool60?@n00P0a``0703f3P1O0?ooo`00H@3oool500000080oooo100000040?ooo`<000000`3oool6
00000080oooo0`0000000`3oool000000000000200000080oooo0P0000020?ooo`<0000000<0oooo
0000003oool00P3oool3003o?1<0oooo00<000000?ooo`3oool02@3oool4001c1004003h2@0BL`00
IVIV019c00809oP00`0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2j
m`000`1VIVH0KG<006ec00020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`001@3gX@00Lc@007<d
001c=00000000080mg00101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj40
1021>`080?M`00D0P@L08`3f3P0208eL00<0mj40102=@0090?M`00D0S@P08P3f3P000`2HH`00mj40
0?NQ000509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00<0ZTd0
0`3gL0070:X/0080mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:0200mPh000@0^5<00?M`003gL000
mg001P2h;`040?Lo00H0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;01d0
mPh01@3oool70?@n00P0a``0703f3P1O0?ooo`00H`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo1@00oc`B0?ooo`030000003oool0oooo00T0oooo1000
L`@01000n0T0IVIV019c000BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<0
05Mc000205Mc0080^_L000<0IVIV06ec001]L`000P3[m`0307=R0080mm80101cB`001@3gX@00Lc@0
07<d001c=00000000080mg00101c7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D0080
mj401021>`080?M`00D0P@L08`3f3P0208eL00<0mj40102=@0090?M`00D0S@P08P3f3P000`2HH`00
mj400?NQ000509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00<0
ZTd00`3gL0070:X/0080mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:0200mPh000@0^5<00?M`003g
L000mg001P2h;`040?Lo00H0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;
01d0mPh0103oool80?@n00P0a``07@3f3P1N0?ooo`00H`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`L00?ll4@3oool00`000000oooo0?ooo`090?ooo`@007<400@0
0?P906IVIP0BL`004W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<000<0ROP005Mc001GL`00
0P1GL`000`2jm`00IVIV06ec000206ec0080joL00`1cHP020?OB00@0Ld/000D0mj4007<d001c=000
Lc@0000000020?M`00@0Lad00P3g?`0307<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0
PC/0203gL005084702<0mPh00P2=G0030?NQ00@0SD002@3gL00508d80280mPh000<0V6<00?NQ003g
X@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P030:Y=00<0
mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`
00H0^2l0103g?`060;P;01l0mPh03P3gL0060;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>
0080oooo2@3d?P080<L<01d0mPh0GP3oool006<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`D00000103oool00`000000oooo0?ooo`030?ooo`@000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L00?ll403oool0
0`000000oooo0?ooo`0:0?ooo`@007<400@04W<006IVIP0BL`004W<00P0Wn00302Uc000405Sh000o
L`00?g<003mc0080ROP0101GL`000`2jm`00IVIV06ec000206ec0080joL00`1cHP020?OB00@0Ld/0
00D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0307<602@0mPh000<0mm80085D0021
E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280
mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0
XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>0004
0;QC003gL000mg000?M`00H0^2l0103g?`060;P;01l0mPh000<0_EH00?M`003gL0002`3gL0060;d;
01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00030?ooo`3d?P00m3h000P0m3h02037300M0?H>
05h0oooo001S0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020000
0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`07003o?100oooo00<00000
0?ooo`3oool0203oool2003h>`@007<400@0IVIV019c000BL`004W<00P0Wn00302Uc000405Sh000o
L`00?g<003mc0080ROP0101GL`000`1VIVH0KG<006ec000206ec0080joL00`1cHP020?OB00@0Ld/0
00D0mj4007<d001c=000Lc@0000000020?M`00@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>0003
0?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0S0?H>0080SE`00P3gX@0508e000T0
mg001@2=200R0?H>000309QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0
XTT02P3gL0050:890280mPh0102ZC@020?M`00L0ZR`00P3g?`060:X:0200mPh00`2aD00<0?M`00H0
/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01P2h2`0O0?H>00030;eF003gL000mg00
00/0mg001P2m2`0N0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?@n00L0a``07@3f3P1N0?oo
o`00H`3oool00`000000oooo0?ooo`020?ooo`030000003oool00000008000000`3oool3000000D0
oooo00<000000?ooo`3oool00P3oool400000080oooo00<000000?ooo`0000000P0000040?ooo`@0
00000`3oool5003o?0d0oooo1000000;0?ooo`800?Pk1000L`@0101VIVH04W<0019c000BL`0202Oh
00<0:G<000@0F?P003mc000oL`00?g<00P29n00405Mc000306IVIP1]L`00KG<00080KG<00P3[m`03
07=R0080mm80101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@000`3g?`00L`H007<6
000207<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00P2=
G0020?NQ00D0SD002@3gL00508d80280mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g
?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0020?Lo00H0ZPX0803f
3P030;5@00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`060;P;01l0mPh0
00<0_EH00?M`003gL0002`3gL0060;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00D0oooo
1`3d?P070<L<01d0mPh0GP3oool006<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo0080oooo0`00oc`A0?ooo`@000001`3oool00`00La/00?Pk003h
>`03001c100306IVIP0BL`004W<000804W<00P0Wn00302Uc000405Sh000oL`00?g<003mc0080ROP0
0`1GL`000`1VIVH0^_L006ec000306ec0080joL00`1cHP020?OB00<0Ld/00P3gX@0307<d00030000
003gL000mg0000<0Lad00P3g?`0407<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0
203gL004084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh000<0V6<00?NQ003gX@00
1@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=00<0mg00
1P2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0
^2l00`3g?`060;P;01l0mPh000<0_EH00?M`003gL0002`3gL0060;d;01h0mPh00P3gL0080<8b00<0
mcl01`322`0N0?H>00T0oooo0`3d?P070<L<01d0mPh0GP3oool00640oooo1@00000B0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`090?ooo`03001c
6`00n3/00?Pk00<007<400<0IVIV019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh
000oL`00?g<003mc0080ROP00`1GL`000`1VIVH0^_L006ec000306ec00030>_g001cHP00Lf800080
Lf800P3gdP0307=;0080mj400`1c=0000`000000mg000?M`000307<M0080mcl0101c1P0T0?H>0003
0?OB0021E000PE@00080PE@00P3gX@04084k00P0mg0010211`0T0?H>0080SE`00P3gX@0508e000T0
mg001@2=200R0?H>000309QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0
XTT02P3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g?`060:X:0200mPh00`2aD00<0?M`00H0
/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01P2h2`0O0?H>00030;eF003gL000mg00
00/0mg001`2m2`0M0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?ooo`P0a``0703f3P1N0?oo
o`00MP3oool3000001D0oooo0P00000G0?ooo`030000003oool0oooo00T0oooo00<007<K003h>`00
n3/00P00L`@00`1VIVH00?P9019c0003019c000302Oh000YL`00:G<00080:G<000@0F?P003mc000o
L`00?g<00P29n00305Mc000306IVIP2jm`00KG<000<0KG<000<0joL007=R001cHP000P1cHP020?OB
00<0Ld/00P3gX@0307<d00030000003gL000Lad000<0Lad00P3g?`0407<602@0mPh000<0mm80085D
0021E0000P21E0020?NQ00@0PC/0203gL004084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d8
0280mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`
00D0XPT08P3f3P040:Y=00<0mg001P2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>
00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01d0mPh00`3gL007
0<8b00@0mcl01P322`0N0?H>00`0oooo2037300L0?H>05h0oooo00260?ooo`8000007`3oool00`00
0000oooo0?ooo`080?ooo`8007<K0P00n3/2001c100306IVIP00n0T04W<000<04W<000<09oP002Uc
000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh0080Eg<000<0IVIV0;[g002jm`00101]L`00
0`3[m`00Lf8007=R000207=R0080mm800`1cB`020?NQ00<0Lc@000<000000?M`001c7@000`1c7@02
0?Lo00@0L`H0903f3P000`3gdP00PE@0085D0002085D00030?NQ0021>`00PC/000<0PC/0203gL004
084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh000<0V6<00?NQ003gX@001@2HA@02
0?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;002
0?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g
?`070;P;01l0mPh03@3gL0070;d;01d0mPh00`3gL0070<8b00@0mcl01P322`0N0?H>0080mg002P3o
ool80<L<01`0mPh0GP3oool008P0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`09
0?ooo`8007<K0P00n3/01000L`@0IVIV001c1000n0T4019c000302Oh000YL`00:G<00080:G<000@0
F?P003mc000oL`00?g<00P29n00205Mc000306IVIP2jm`00^_L000@0KG<000<0joL007=R001cHP00
0P1cHP020?OB00<0Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602@0mPh0
00<0mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00P0mg0010211`0T0?H>0080SE`0
0P3gX@0508e000T0mg001@2=200R0?H>000309QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl0
1@2H2@0R0?H>00H0XTT02P3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g?`060:X:0200mPh0
0`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0O0?H>00d0
mg001`2m2`0N0?H>0080mg001`32<P040?Lo00L0`P/07@3f3P060?M`00H0oooo2037300L0?H>05h0
oooo00280?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool02@3oool2001c6`800?Pk
00@007<406IVIP00L`@00?P90`0BL`0202Oh00@0:G<0100oL`0208Wh000305Mc001VIVH0Eg<00080
^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm800`1cB`020?NQ0080Lc@000<0000007<d003g
L000101c7@020?Lo00@0L`H0903f3P000`3gdP00PE@0085D0002085D00030?NQ0021>`00PC/000<0
PC/0203gL004084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh000<0V6<00?NQ003g
X@001@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=00<0
mg001P2Z;0020?Lo00L0ZPX07`3f3P030;5@00`0mg001P2a2P0P0?H>00040;QC003gL000mg000?M`
00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3gL0070<8b00@0mcl01`322`0M0?H>
00X0mg000P3oool80<L<01d0mPh0G@3oool005d0oooo0`0000040?ooo`<000000`3oool400000080
oooo0P0000000`3oool000000?ooo`0200000080oooo0`0000000`3oool000000000000200000080
oooo0P0000030?ooo`030000003oool0oooo00@0oooo0`00oflC0?ooo`030000003oool0oooo00T0
oooo0`00La/2003h>`04001c101VIVH007<4003h2@<04W<00P0Wn00402Uc00@0?g<00P29n0000`1G
L`00IVIV05Mc00020;[g00@0KG<000<0joL007=R001cHP000P1cHP000`3gdP00Ld/007=;000207=;
0080mj4000D0Lc@006IVIP000000Lc@00?M`000407<M0080mcl0101c1P0T0?H>00030?OB0021E000
PE@00080PE@000<0mj40084k0021>`000`21>`080?M`00@0P@L0903f3P0208eL0080mj401@2=@009
0?M`00D0S@P08P3f3P000`2HH`00mj400?NQ000509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P06
0:9900X0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0O0?H>00<0/E00303gL006
0;4:0240mPh00`3gL0070;P_00<0mcl01`2h2`0O0?H>00d0mg001`2m2`0N0?H>0080mg001`32<P04
0?Lo00L0`P/07@3f3P0<0?M`00P0a``07@3f3P1M0?ooo`00G03oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo0`0000040?ooo`D00?m_4P3oool00`000000oooo0?ooo`090?oo
o`<007<K0P00n3/0101VIVH007<4001c1000n0T3019c00809oP00`0YL`000`1Hn000?g<003mc0002
03mc0080ROP000<0IVIV05Mc001GL`000P2jm`0306ec0080joL0101cHP000`3gdP00Ld/007=;0002
07=;0080mj4000<0Lc@006IVIP0000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000
PE@00080PE@000<0mj40084k0021>`000`21>`080?M`00@0P@L0903f3P0208eL0080mj401@2=@009
0?M`00D0S@P08P3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R0?H>00H0XTT02P3gL005
0:890280mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00H0/@X08@3f3P03
0?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0M
0?H>00`0mg002037300M0?H>05d0oooo001L0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`0000000`3oool7003oKa00oooo00<000000?ooo`3oool02P3oool3001c6`80
0?Pk00@0IVIV001c1000L`@00?P90`0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh
000306IVIP1GL`00Eg<00080^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ
000306IVIP1c=00000000080mg00101c7@020?Lo00<0L`H09@3f3P00103gdP00PE@0085D0021E002
0?NQ00D0PC/0203gL004084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00`3gX@05
09Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00@0ZTd00`3gL006
0:X/0080mcl01`2Z2P0O0?H>00<0/E00303gL0060;4:0240mPh00`3gL0070;P_00<0mcl01`2h2`0O
0?H>00d0mg001`2m2`0N0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0;0?M`00P0a``07@3f3P1M
0?ooo`00G03oool00`000000oooo0?ooo`0200000080oooo1@0000030?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`000000oooo000000030?ooo`@000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L00?m_403oool00`000000oooo
0?ooo`0:0?ooo`<007<K00<00?Pk06IVIP00L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0
:G<000<0F?P003mc000oL`000P0oL`000`29n000IVIV05Mc000205Mc0080^_L00`1]L`020>_g00@0
Lf8000<0mm8007=;001cB`000P1cB`020?NQ000306IVIP1c=00000000080mg00101c7@020?Lo00<0
L`H09@3f3P00103gdP00PE@0085D0021E0020?NQ00D0PC/01`3gL005084702@0mPh00P2=G0020?NQ
00D0SD002@3gL00508d80280mPh00`3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08P3f3P060:99
00X0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0O0?H>00<0/E00303gL0060;4:
0240mPh0103gL0060;P_00<0mcl01`2h2`0O0?H>00d0mg001`2m2`0N0?H>0080mg002032<P030?Lo
00L0`P/07P3f3P0;0?M`00P0a``07@3f3P1M0?ooo`00G03oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool00000
0?ooo`0000001P3oool00`000000oooo0?ooo`0200000080oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`07003oKa00oooo00<000000?ooo`3oool0203oool2003hK0<007<K00<0
0?Pk06IVIP00L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0:G<000<0F?P003mc000oL`00
0P0oL`000`29n000IVIV05Mc000205Mc0080^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`00
0P1cB`00103gX@00IVIV07<d001c=003000000@0Lad00P3g?`0307<602D0mPh000@0mm80085D0021
E000PE@00P3gX@05084k00L0mg001@211`0T0?H>0080SE`00P3gX@0508e000T0mg001@2=200R0?H>
00<0mj401@2HA@020?M`00H0V2L00P3g?`0509P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=
00<0mg001P2Z;0020?Lo00L0ZPX07`3f3P030;5@00`0mg001P2a2P0Q0?H>00@0mg001P2h;`030?Lo
00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL0070<L<
01d0mPh0G@3oool005`0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool00`00
0000oooo00000002000000060?ooo`00000000000000003oool000000`3oool400000080oooo00<0
00000?ooo`0000000P0000020?ooo`<0000000@0oooo00000000000000000P3oool5003oK``0oooo
1@00000;0?ooo`800?Q/0`00La/00`1VIVH007<4001c1002001c1004003h2@0BL`004W<0019c0080
9oP00`0YL`000`1Hn000?g<003mc000203mc000306IVIP1GL`00Eg<00080Eg<00P2jm`0306ec0080
joL0101cHP000`3gdP00Ld/007=;000207=;00050?NQ001VIVH0Lc@007<d000000000P3gL0020000
0080Lad00P3g?`0307<602D0mPh000@0mm80085D0021E000PE@00P3gX@05084k00L0mg001@211`0T
0?H>0080SE`00P3gX@0508e000T0mg001@2=200R0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`05
09P90280mPh01P2RB@0:0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX07`3f3P03
0;5@00`0mg001P2a2P0Q0?H>00@0mg001P2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0070<L<01d0mPh0G@3oool005`0oooo00D000000?oo
o`3oool0oooo0000000^0?ooo`<00?m_4@3oool4000000L0oooo00<007<b003hK000n6`00`00La/0
0`1VIVH007<4001c1002001c1004003h2@0BL`004W<0019c00809oP00`0YL`000`1Hn000?g<003mc
000203mc000306IVIP1GL`00Eg<00080Eg<00P2jm`0306ec0080joL00`1cHP020?OB00@0Ld/000D0
IVIV07<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0307<602D0mPh01021E0020?NQ00D0PC/0
1`3gL005084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d80280mPh00`3gX@0509Q50080mg00
1P2H9`020?Lo00D0V0T08P3f3P060:9900X0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl0
1`2Z2P0O0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001P2h;`030?Lo00L0
^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01`0
mPh0G@3oool005d0oooo0`0000120?ooo`030000003oool0oooo00T0oooo00<007<b003hK000n6`0
0P00La/00`1VIVH00?Pk001c1003001c10@04W<00P0Wn00302Uc000605Sh000oL`00?g<003mc0029
n000IVIV101GL`020;[g00<0KG<00P3[m`0307=R0080mm80101cB`001@1VIVH0Lc@007<d001c=000
00000080mg00101c7@020?Lo00<0L`H09@3f3P04085D0080mj401@21>`070?M`00D0P@L08`3f3P03
08eL0080mj401@2=@0090?M`00D0S@P08P3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0R
0?H>00H0XTT02P3gL0060:890240mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<
0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00<0mcl01`2h2`0O0?H>00h0mg001P2m
2`0N0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?M`00P0a``0703f3P1M0?ooo`00XP3oool0
0`000000oooo0?ooo`080?ooo`8007<b0P00n6`2001c6`0306IVIP00n3/007<400<007<4100BL`02
02Oh00<0:G<000H0F?P003mc000oL`00?g<006IVIP29n00405Mc0080^_L00`1]L`020>_g00<0Lf80
0P3gdP0307=;000306IVIP3gX@00Lc@00080Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H0
9@3f3P04085D0080mj401@21>`070?M`00D0P@L08`3f3P0308eL0080mj401@2=@0090?M`00D0S@P0
8P3f3P030?NQ00D0V4D00P3gL00509PW00<0mcl01@2H2@0R0?H>00H0XTT02P3gL0060:890240mPh0
102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00mg00
0?M`003gL0060;P_00@0mcl01P2h2`0O0?H>00h0mg001P2m2`0N0?H>0080mg002032<P030?Lo00L0
`P/07P3f3P0<0?M`00P0a``0703f3P1M0?ooo`00X@3oool00`000000oooo0?ooo`090?ooo`8007<b
0P00n6`2001c6`0306IVIP00n3/007<400<007<4100BL`0202Oh00<0:G<000H0F?P003mc000oL`00
?g<006IVIP29n00405Mc00030;[g001]L`00KG<00080KG<00P3[m`0307=R0080mm800`1cB`000`1V
IVH0mj4007<d000207<d00030000003gL000mg0000@0Lad00P3g?`0307<602@0mPh000<0mm80085D
0021E0000P21E0020?NQ00D0PC/01`3gL005084702<0mPh00`2=G0020?NQ00D0SD002@3gL00508d8
0280mPh00`3gX@0509Q50080mg001@2H9`030?Lo00D0V0T08P3f3P060:9900X0mg001P2R2@0Q0?H>
00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0O0?H>00<0/E00303gL0070;4:0200mPh000@0^5<00?M`
003gL000mg001P2h;`040?Lo00H0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00H0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01`0mPh0G@3oool00:40oooo00<000000?oo
o`3oool0203oool3001c<P800?Q/00@007<K06IVIP00n3/00?Pk0`00L`@00`00n0T04W<0019c0002
019c000302Oh000YL`00:G<00080:G<000@0F?P003mc000oL`00IVIV0P29n00305Mc0080^_L0101]
L`020>_g00<0Lf800P3gdP0207=;000306IVIP1cB`00mj4000<0Lc@000<000000?M`003gL000101c
7@020?Lo00<0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L08`3f
3P0308eL0080mj401@2=@0090?M`00D0S@P08P3f3P020?NQ00H0V4D00P3gL00509PW00<0mcl01@2H
2@0R0?H>00H0XTT02P3gL0060:890240mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2a
D00<0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0O0?H>00030;eF
003gL000mg0000/0mg001P2m2`0N0?H>00<0mg001`32<P040?Lo00H0`P/07P3f3P0<0?M`00P0a``0
7@3f3P1L0?ooo`00EP3oool3000000040?ooo`000000000000000080oooo0`000000103oool00000
0?ooo`3oool3000000D0oooo0`0000020?ooo`@000000`3oool5000000<0oooo0`0000000`3oool0
00000?ooo`020?ooo`<00?nR503oool00`000000oooo0?ooo`080?ooo`<007<b0P00n6`01000La/0
IVIV003h>`00n3/3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`00101H
n000?g<003mc001VIVH208Wh00<0Eg<00P2jm`0406ec0080joL00`1cHP020?OB0080Ld/000<0IVIV
07=;003gX@000`1c=0000`000000mg000?M`000407<M00030?Lo001c1P00L`H00080L`H0903f3P00
0`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L08`3f3P0308eL0080mj401@2=@009
0?M`00D0S@P08P3f3P020?NQ00H0V4D00P3gL00509PW00<0mcl01@2H2@0R0?H>00H0XTT02P3gL006
0:890240mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:01l0mPh00`2aD00<0?M`00L0/@X0803f3P00
102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m
2`0M0?H>00<0mg001`32<P040?Lo00L0`P/07@3f3P0<0?M`00P0a``07@3f3P1L0?ooo`00E`3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool5
003oXQ80oooo00<000000?ooo`3oool0203oool4001c<P800?Q/00@0IVIV001c6`00n3/00?Pk0`00
L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000@0F?P003mc001VIVH0?g<0
0P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm8000<0Ld/006IVIP1cB`00
0P3gX@0307<d00030000003gL000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0T0?H>00030?OB
0021E000PE@00080PE@00P3gX@05084k00L0mg001@211`0S0?H>00<0SE`00P3gX@0508e000T0mg00
1@2=200R0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`0509P90280mPh01P2RB@0:0?M`00H0XPT0
8@3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX07`3f3P030;5@00`0mg001`2a2P0P0?H>00040;QC
003gL000mg000?M`00H0^2l0103g?`060;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0
mPh00P3gL0070<8b00@0mcl01`322`0M0?H>00`0mg002037300M0?H>05`0oooo001G0?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?oo
o`3oool0oooo000000060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo1`00oj8A0?ooo`030000003oool0oooo00P0oooo1000
Lc82003hK00406IVIP00La/00?Pk003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<0
02Uc000202Uc000405Sh000oL`00IVIV03mc0080ROP00`1GL`020;[g00@0KG<000<0joL007=R001c
HP000P1cHP020?OB000307=;001VIVH0Ld/00080mj400`1c=0000`000000mg000?M`000307<M0080
mcl0101c1P0T0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0S0?H>00<0
SE`00P3gX@0508e000T0mg001@2=200R0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`0509P90280
mPh01P2RB@0:0?M`00H0XPT08@3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX0803f3P030;5@00/0
mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`060;P;01l0mPh000<0_EH00?M`
003gL0002`3gL0070;d;01h0mPh00P3gL0070<8b00@0mcl01`322`0M0?H>00`0mg002037300M0?H>
05`0oooo001G0?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo0`0000040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oo
o`@000000P3oool7003oXQ00oooo00<000000?ooo`3oool02@3oool4001c<P04003hK01VIVH007<K
001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000@0F?P0
06IVIP0oL`00?g<00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm8000<0
Ld/006IVIP1cB`000P3gX@0307<d00030000003gL000Lad000<0Lad00P3g?`0407<602@0mPh000<0
mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00`2=G0020?NQ00D0SD002@3g
L00408d802<0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00D0V0T08P3f3P060:9900X0mg001P2R
2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E002`3gL0070;4:0200mPh000@0
^5<00?M`003gL000mg001`2h;`030?Lo00H0^0/0803f3P0=0?M`00L0_@/07P3f3P020?M`00L0`S80
103g?`070<8;01h0mPh02`3gL0080<L<01d0mPh0G03oool005P0oooo00<000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L00?nR403oool00`000000oooo0?ooo`090?ooo`@007<b00@00?Q/06IVIP00
La/007<K0P00n3/3001c1004003h2@0BL`004W<0019c00809oP0100YL`00101Hn000IVIV03mc000o
L`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP000`1VIVH0Ld/007=;
00020?NQ00<0Lc@000<000000?M`001c7@000`1c7@020?Lo00@0L`H0903f3P000`3gdP00PE@0085D
0002085D0080mj401021>`080?M`00D0P@L08`3f3P0308eL0080mj401@2=@0090?M`00@0S@P08`3f
3P020?NQ00H0V4D00P3gL00509PW00<0mcl01@2H2@0R0?H>00H0XTT02P3gL0060:890240mPh0102Z
C@030?M`00H0ZR`00P3g?`070:X:0200mPh00`2aD00;0?M`00L0/@X0803f3P00102hD`00mg000?M`
003gL0070;P_00<0mcl01P2h2`0P0?H>00d0mg001`2m2`0N0?H>0080mg002032<P030?Lo00L0`P/0
7P3f3P0;0?M`00P0a``07@3f3P1L0?ooo`00F03oool00`000000oooo000000020?ooo`8000000P3o
ool2000000<0oooo0`0000030?ooo`D000000P3oool00`000000oooo0000000200000080oooo0`00
00040?ooo`@00000103oool5003oXQ00oooo00<000000?ooo`3oool02@3oool00`00n9d007<b001c
<P02001c<P04003hK01VIVH007<K001c6`800?Pk0`00L`@01000n0T04W<0019c000BL`0202Oh00@0
:G<000@0IVIV03mc000oL`00?g<00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R
0080mm8000<0IVIV07=;001cB`000P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<6
02@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00`2=G0020?NQ
00D0SD002@3gL00408d802<0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00D0V0T08P3f3P060:99
00X0mg001P2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E002`3gL0070;4:
0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0070<L<01d0mPh0G03oool005T0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0J0?ooo`<00?nR3@3oool5000000/0oooo00<00?RM001c
<P00Lc800P00Lc80101VIVH007<K001c6`00La/2003h>`<007<400@00?P9019c000BL`004W<00P0W
n00302Uc000305Sh001VIVH0?g<00080?g<00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R
000207=R00030?OB001VIVH0Ld/00080Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g
?`0407<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00`2=
G0020?NQ00D0SD002@3gL00408d802<0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00D0V0T08P3f
3P060:9900X0mg001P2R2@0Q0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E002`3g
L0070;4:0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/0
7P3f3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL0070<L<01d0mPh0G03oool005L0oooo0`00
000C0?ooo`030000003oool0oooo02h0oooo100000070?ooo`03001cB@00n9d007<b00<007<b00@0
IVIV001c6`00La/007<K0P00n3/3001c1004003h2@0BL`004W<0019c00809oP00`0YL`000`1Hn000
IVIV03mc000203mc0080ROP00`1GL`020;[g00<0KG<00P3[m`0407=R00030?OB001VIVH0Ld/00080
Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602@0mPh000<0mm80085D0021
E0000P21E0020?NQ00@0PC/0203gL005084702<0mPh00`2=G0020?NQ00D0SD002@3gL00408d802<0
mPh00P3gX@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`0509P90280mPh01P2RB@0:0?M`00H0
XPT08@3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>0004
0;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3gL0080<8b
00<0mcl01`322`0N0?H>00`0mg002037300L0?H>05`0oooo001l0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool02@3oool00`00LdT00?RM001c<P02001c<P0306IVIP00n6`007<K0080
07<K00<00?Pk001c1000L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0:G<000<0IVIV03mc
000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L00`1]L`020>_g00@0Lf8000<0IVIV07=;
001cB`000P1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00@0L`H0903f3P000`3g
dP00PE@0085D0002085D0080mj401021>`080?M`00D0P@L08`3f3P0308eL0080mj401@2=@0090?M`
00@0S@P08`3f3P020?NQ00H0V4D000<0mg0009PW002H9`00102H9`030?Lo00D0V0T08P3f3P060:99
00X0mg001P2R2@0Q0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:
0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01`0mPh0G03oool006P0oooo0`00000b0?oo
o`030000003oool0oooo00P0oooo0P00LdT01P00n9d007<b001c<P00Lc80IVIV003hK0<007<K00<0
0?Pk001c1000L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0:G<000<0IVIV03mc000oL`00
0P0oL`000`29n000Eg<005Mc000205Mc0080^_L00`1]L`020>_g00@0Lf8000<0IVIV07=;001cB`00
0P1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00@0L`H0903f3P000`3gdP00PE@0
085D0002085D0080mj401021>`080?M`00D0P@L08`3f3P0308eL0080mj401@2=@0090?M`00@0S@P0
8`3f3P020?NQ00H0V4D000<0mg0009PW002H9`00102H9`030?Lo00D0V0T08P3f3P060:9900X0mg00
1P2R2@0Q0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0P0?H>00<0/E002`3gL0070;4:0200mPh0
00@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0
`S800`3g?`070<8;01h0mPh0303gL0080<L<01d0mPh0F`3oool006/0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`090?ooo`8007=900@00?RM001c<P00Lc80IVIV0P00n6`3001c6`03
003h>`00L`@007<4008007<400@00?P9019c000BL`004W<00P0Wn00202Uc000306IVIP1Hn000?g<0
00<0?g<000<0ROP005Mc001GL`000P1GL`020;[g00<0KG<00P3[m`0307=R000306IVIP3gdP00Ld/0
00<0Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh000<0mm80085D
0021E0000P21E0020?NQ00@0PC/0203gL004084702@0mPh00`2=G0020?NQ00D0SD002@3gL00408d8
02<0mPh00P3gX@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`0509P90280mPh01P2RB@0:0?M`
00H0XPT08@3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>
00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3gL008
0<8b00<0mcl01`322`0N0?H>00`0mg002037300M0?H>05/0oooo001[0?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool0203oool3001cB@04003hW@00Lc8007<b06IVIP800?Q/0P00La/2
003h>`@007<400@00?P9019c000BL`004W<00P0Wn00202Uc000306IVIP1Hn000?g<000<0?g<000<0
ROP005Mc001GL`000P1GL`020;[g00<0KG<00P3[m`0307=R000306IVIP3gdP00Ld/000<0Ld/00P3g
X@0207<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh000<0mm80085D0021E0000P21
E0020?NQ00@0PC/0203gL004084702@0mPh00`2=G0020?NQ00@0SD002P3gL00408d802<0mPh00P3g
X@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`0509P90280mPh01P2RB@0:0?M`00H0XPT08@3f
3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0P0?H>00040;QC003g
L000mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl0
1`322`0N0?H>00`0mg002037300M0?H>05/0oooo001A0?ooo`D00000103oool3000000<0oooo1P00
00020?ooo`@000000P3oool5000000<0oooo0`0000001`3oool00000000000000000oooo0000003o
ool00P0000030?ooo`<00?oD4`3oool00`000000oooo0?ooo`090?ooo`<007=900@00?RM001c<P1V
IVH007<b0P00n6`2001c6`800?Pk1000L`@4019c00809oP000@0:G<006IVIP0YL`00F?P00`0oL`02
08Wh00@0Eg<00P2jm`0306ec0080joL00P1cHP000`1VIVH0mm800?OB000407=;00050?NQ001c=000
Lc@007<d000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@000<0
mj40084k0021>`000`21>`080?M`00@0P@L0903f3P0308eL0080mj40102=@0090?M`00D0S@P08`3f
3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0R0?H>00H0XTT02P3gL0060:890240mPh0102Z
C@030?M`00H0ZR`00`3g?`060:X:0200mPh00`2aD00<0?M`00H0/@X0803f3P00102hD`00mg000?M`
003gL0070;P_00<0mcl01`2h2`0O0?H>00d0mg001`2m2`0N0?H>0080mg002032<P040?Lo00H0`P/0
7P3f3P0<0?M`00P0a``07@3f3P1K0?ooo`00DP3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool000000?ooo`0000000`3oool5003oe180oooo00<000000?ooo`3oool0203o
ool4001cB@04003hW@00Lc80IVIV001c<P800?Q/0P00La/2003h>`@007<4100BL`0202Oh000402Uc
001VIVH0:G<005Sh00<0?g<00P29n00405Mc0080^_L00`1]L`020>_g0080Lf8000<0IVIV0?OB003g
dP00101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@020?Lo00<0L`H09@3f3P000`3g
dP00PE@0085D0002085D00030?NQ0021>`00PC/000<0PC/0203gL004084702@0mPh00`2=G0020?NQ
00@0SD002@3gL00508d802<0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T08P3f3P060:99
00X0mg001P2R2@0Q0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0P0?H>00<0/E00303gL0060;4:
0240mPh00`3gL0070;P_00<0mcl01`2h2`0O0?H>00h0mg001P2m2`0N0?H>00<0mg001`32<P040?Lo
00L0`P/07@3f3P0<0?M`00P0a``07@3f3P1K0?ooo`00DP3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0000003oool000000080oooo1`00om@A0?ooo`030000003oool0oooo00P0oooo
1000LdT01000n9d007<b06IVIP00Lc82003hK08007<K0P00n3/3001c1003003h2@0BL`004W<00080
4W<00P0Wn000101VIVH0:G<002Uc001Hn00303mc0080ROP0101GL`020;[g00<0KG<00P3[m`000`1c
HP00IVIV07=R00020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`03
07<602D0mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00P0mg0010211`0T
0?H>00<0SE`00P3gX@0408e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`05
09P90280mPh01P2RB@0:0?M`00H0XPT08@3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P03
0;5@00`0mg001P2a2P0Q0?H>00@0mg001P2h;`030?Lo00L0^0/07`3f3P0>0?M`00H0_@/07P3f3P03
0?M`00L0`S80103g?`070<8;01d0mPh0303gL0080<L<01d0mPh0F`3oool00580oooo00D000000?oo
o`3oool0oooo000000020?ooo`D00000103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0000003oool000000080oooo1`00om@@0?ooo`030000003oool0oooo00T0
oooo1000LdT01000n9d0IVIV001c<P00Lc82003hK08007<K0P00n3/3001c1003003h2@0BL`004W<0
00804W<000<09oP002Uc001VIVH00P0YL`00101Hn000?g<003mc000oL`0208Wh00@0Eg<000<0^_L0
06ec001]L`000P1]L`020>_g000307=R001VIVH0Lf800080mm80101cB`001@3gX@00Lc@007<d001c
=00000000080mg00101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D00030?NQ0021
>`00PC/000<0PC/0203gL004084702@0mPh00P2=G0030?NQ00@0SD002@3gL00508d802<0mPh00P3g
X@0509Q50080mg001P2H9`030?Lo00D0V0T08P3f3P060:9900X0mg001P2R2@0Q0?H>00@0ZTd00`3g
L0060:X/00<0mcl01P2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh0103gL0060;P_00<0mcl01`2h
2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0N0?H>0080mg001`32<P040?Lo00L0`P/07P3f
3P0;0?M`00P0a``07@3f3P1K0?ooo`00DP3oool4000000<0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool000000?oo
o`0000000P3oool7003oe100oooo00<000000?ooo`3oool02@3oool4001cB@04003hW@1VIVH007<b
001c<P800?Q/0P00La/2003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<006IVIP02
02Uc000405Sh000oL`00?g<003mc0080ROP00`1GL`020;[g00@0KG<00P3[m`000`1VIVH0Lf8007=R
00020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0307<602D0mPh0
00@0mm80085D0021E000PE@00P3gX@05084k00P0mg0010211`0T0?H>0080SE`00`3gX@0408e000T0
mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`0509P90280mPh01P2RB@0:0?M`00H0
XPT08@3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>00@0
mg001P2h;`030?Lo00L0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00L0_@/07P3f3P020?M`00L0
`S80103g?`070<8;01h0mPh02`3gL0080<L<01d0mPh0F`3oool00580oooo00D000000?ooo`3oool0
oooo000000030?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo0000003o
ool00`0000030?ooo`8000000P3oool2000000060?ooo`00000000000000003oool00000103oool5
003oe0`0oooo0P0000020?ooo`030000003oool0oooo00T0oooo00<00?S?001cB@00LdT00P00LdT0
101VIVH007<b001c<P00Lc82003hK08007<K0P00n3/3001c1003003h2@0BL`004W<000804W<000<0
9oP006IVIP0YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g
001cHP00IVIV0080Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080
mcl00`1c1P0U0?H>00040?OB0021E000PE@0085D0080mj401@21>`080?M`00@0P@L0903f3P0208eL
00<0mj40102=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0R0?H>
00H0XTT02P3gL0060:890240mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0200mPh00`2aD00<0?M`
00H0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_00<0mcl01`2h2`0O0?H>00030;eF003gL000
mg0000/0mg001`2m2`0N0?H>0080mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00L0a``07@3f3P1K
0?ooo`00DP3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0803oool3
003oe0l0oooo100000090?ooo`03001cH000n<l007=900<007=900@0IVIV001c<P00Lc8007<b0P00
n6`2001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c000302Oh001VIVH0:G<00080:G<000@0
F?P003mc000oL`00?g<00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8006IVIP0207=R0080mm80
101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@020?Lo00<0L`H09@3f3P00103gdP00
PE@0085D0021E0020?NQ00D0PC/0203gL004084702@0mPh00P2=G0030?NQ00@0SD002@3gL00508d8
02<0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T08P3f3P060:9900X0mg001P2R2@0Q0?H>
00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`
003gL000mg001P2h;`040?Lo00H0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00L0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01`0mPh0F`3oool00540oooo1@00000<0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P0000070?ooo`03001cH000n<l007=9
008007=900<0IVIV001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<400<00?P9
019c000BL`000P0BL`000`1VIVH0:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP00`1G
L`020;[g00@0KG<000<0joL006IVIP1cHP000P1cHP020?OB00<0Ld/00P3gX@0307<d00030000003g
L000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0U0?H>00@0PE@00P3gX@05084k00L0mg001@21
1`0T0?H>0080SE`00`3gX@0408e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g
?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f
3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`060;P;01l0mPh0
00<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg00
2037300L0?H>05/0oooo001P0?ooo`<000003@3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo00P0oooo0P00Lf001@00n<l007=9001cB@00LdT0IVIV00@007<b00@00?Q/001c6`00La/0
07<K0P00n3/3001c1006003h2@0BL`004W<0019c000Wn000IVIV100YL`00101Hn000?g<003mc000o
L`0208Wh00<0Eg<00P2jm`0406ec00030>_g001VIVH0Lf800080Lf800P3gdP0307=;0080mj400`1c
=0000`000000mg000?M`000407<M00030?Lo001c1P00L`H00080L`H0903f3P000`3gdP00PE@0085D
0002085D0080mj401@21>`070?M`00D0P@L0903f3P0208eL0080mj401@2=@0090?M`00D0S@P08`3f
3P020?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT02P3gL0060:890280mPh00`2Z
C@030?M`00L0ZR`00P3g?`060:X:0200mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`
003gL0060;P_00@0mcl01P2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0N0?H>0080mg00
2032<P030?Lo00L0`P/07P3f3P0<0?M`00P0a``07@3f3P1J0?ooo`00V03oool00`000000oooo0?oo
o`080?ooo`8007=P00D00?S?001cB@00LdT007=906IVIP04001c<P04003hK000La/007<K001c6`80
0?Pk0`00L`@01P00n0T04W<0019c000BL`00IVIV02Oh00@0:G<0100oL`0208Wh00<0Eg<00P2jm`04
06ec000306IVIP1cHP00Lf800080Lf800P3gdP0307=;0080mj400`1c=0000`000000mg0007<M0003
07<M0080mcl0101c1P0T0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00L0mg001@211`0T
0?H>0080SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`06
09P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P03
0;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`060;P;0200mPh03@3g
L0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg002037300M0?H>05X0oooo002G
0?ooo`030000003oool0oooo00P0oooo0`00Lf001@00n<l007=9001cB@1VIVH00?RM00@007<b00@0
0?Q/001c6`00La/007<K0P00n3/3001c1006003h2@0BL`004W<0019c001VIVH09oP00`0YL`000`1H
n000?g<003mc000203mc0080ROP00`1GL`020;[g00@0KG<000<0IVIV07=R001cHP000P1cHP020?OB
00<0Ld/00P3gX@0307<d00030000003gL000Lad000<0Lad00P3g?`0407<602@0mPh000<0mm80085D
0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d8
02<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900X0mg001P2R2@0R0?H>
00<0ZTd00`3gL0070:X/0080mcl01P2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`
003gL000mg001P2h;`040?Lo00H0^0/0803f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`07
0<8;01h0mPh0303gL0080<L<01d0mPh0FP3oool009L0oooo00<000000?ooo`3oool0203oool3001c
H005003hc`00LdT007=906IVIP00n9d00`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@0
1000n0T04W<0019c001VIVH202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00P2j
m`0306ec000306IVIP3[m`00Lf8000<0Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<0
000007<d003gL000101c7@020?Lo00@0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj401@21
>`070?M`00D0P@L0903f3P0208eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3g
L00609PW0080mcl01P2H2@0R0?H>00H0XTT02P3gL0060:890280mPh00`2ZC@030?M`00L0ZR`00P3g
?`060:X:0200mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0060;P_00@0mcl0
1P2h2`0P0?H>00d0mg001`2m2`0N0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?M`00P0a``0
7@3f3P1J0?ooo`00D`3oool4000000@0oooo100000040?ooo`<0000000<0oooo0000000000000P00
00020?ooo`8000000P3oool3000000@0oooo0`0000050?ooo`<00?So4`3oool00`000000oooo0?oo
o`080?ooo`@007=P00D00?S?001cB@1VIVH007=9003hW@03001c<P800?Q/0`00La/00`00n3/007<4
001c1002001c1004003h2@0BL`004W<006IVIP809oP00`0YL`000`1Hn000?g<003mc000203mc0080
ROP00`1GL`020;[g00<0KG<000<0IVIV0>_g001cHP000`1cHP000`3gdP00Ld/007=;000207=;0080
mj400P1c=0000`000000Lc@00?M`000407<M0080mcl0101c1P0T0?H>00030?OB0021E000PE@00080
PE@00P3gX@05084k00L0mg001@211`0T0?H>0080SE`00P3gX@0508e000T0mg001@2=200S0?H>0080
mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0
mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`
00L0^2l00`3g?`060;P;0200mPh03@3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>
00`0mg002037300M0?H>05X0oooo001D0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
1@00n?lB0?ooo`030000003oool0oooo00P0oooo1000Lf001@00n<l007=906IVIP00LdT00?RM00<0
07<b0P00n6`3001c6`03003h>`00L`@007<4008007<400@00?P9019c001VIVH04W<00P0Wn00302Uc
000305Sh000oL`00?g<00080?g<000<0ROP005Mc001GL`000P1GL`020;[g0080KG<000<0IVIV0>_g
003[m`00101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`000000Lc@00?M`000407<M
0080mcl0101c1P0T0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00L0mg001@211`0T0?H>
0080SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P9
0280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@
00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL007
0;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg002037300M0?H>05X0oooo001D0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool7003hoa00oooo00<000000?ooo`3oool02@3oool4001cH005003hc`1V
IVH007=9001cB@00n9d00`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@01000n0T04W<0
06IVIP0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080
^_L00P1]L`000`1VIVH0joL00>_g000407=R00030?OB001cB`00Ld/00080Ld/00P3gX@0207<d0003
0000001c=000mg0000@0Lad00P3g?`0407<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00D0
PC/01`3gL005084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d802<0mPh00P3gX@0509Q50080
mg001P2H9`020?Lo00H0V0T08P3f3P060:9900X0mg001P2R2@0R0?H>00<0ZTd00`3gL0070:X/0080
mcl01P2Z2P0P0?H>00<0/E00303gL0070;4:0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo
00L0^0/07`3f3P0=0?M`00L0_@/07P3f3P020?M`00P0`S80103g?`070<8;01d0mPh0303gL0080<L<
01d0mPh0FP3oool005@0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`@0
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool50000
0080oooo1`00n?l@0?ooo`030000003oool0oooo00T0oooo1000Lf001@00n<l0IVIV001cB@00LdT0
0?RM00<007<b0P00n6`2001c6`800?Pk1000L`@01000n0T04W<006IVIP0BL`0202Oh00<0:G<000<0
F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L000<0KG<006IVIP1]L`000P3[
m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@0207<d00030000003gL000mg0000@0Lad00P3g
?`0407<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00P2=
G0020?NQ00D0SD002@3gL00508d802<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f
3P060:9900X0mg001P2R2@0R0?H>00<0ZTd00`3gL0070:X/0080mcl01P2Z2P0P0?H>00<0/E00303g
L0070;4:0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0=0?M`00L0_@/0
7P3f3P030?M`00L0`S80103g?`070<8;01h0mPh02`3gL0080<L<01d0mPh0FP3oool005@0oooo0`00
00050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P0000020?ooo`040000003o
ool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`07003hoa00
oooo00<000000?ooo`3oool02@3oool4001cH00506IVIP00LdT007=9001cB@00n9d00`00Lc82003h
K08007<K0P00n3/4001c1004019c001VIVH04W<0019c00809oP00`0YL`000`1Hn000?g<003mc0002
03mc000308Wh001GL`00Eg<00080Eg<00P2jm`000`1]L`00IVIV06ec00020>_g00@0Lf8000<0mm80
07=;001cB`000P1cB`020?NQ0080Lc@01@00000207<M0080mcl0101c1P0T0?H>00030?OB0021E000
PE@00080PE@00P3gX@04084k00P0mg001@211`0T0?H>0080SE`00P3gX@0508e000T0mg001@2=200S
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P03
0:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;01l0mPh03@3gL0070;d;01h0mPh00`3gL0070<8b00@0mcl01`32
2`0N0?H>00/0mg002037300M0?H>05X0oooo001D0?ooo`050000003oool000000?ooo`0000000P3o
ool00`000000oooo0000000200000080oooo100000020?ooo`030000003oool0000000800000103o
ool3000000@0oooo0`0000040?ooo`D00?So303oool5000000/0oooo00<00?7h001cH000Lf000P00
Lf001@1VIVH007=9001cB@00LdT00?RM00<007<b0P00n6`2001c6`800?Pk0`00L`@00`00n0T04W<0
06IVIP02019c00809oP00`0YL`00101Hn000?g<003mc000oL`0208Wh00@0Eg<00P2jm`000`1VIVH0
KG<006ec00020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ0080Lc@000<000000?M`003g
L000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`00D0
P@L0903f3P0208eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW0080
mcl01P2H2@0R0?H>00H0XTT02P3gL0060:890280mPh00`2ZC@030?M`00L0ZR`00P3g?`060:X:0200
mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0O0?H>
00d0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00L0a``07@3f3P1J0?oo
o`00E03oool01@000000oooo0?ooo`3oool0000002L0oooo0`00n?lA0?ooo`@000001`3oool00`00
L7<00?7h001cH003001cH00506IVIP00LdT007=9001cB@00n9d00`00Lc82003hK08007<K0P00n3/3
001c1003003h2@1VIVH04W<000804W<000<09oP002Uc000YL`000P0YL`00101Hn000?g<003mc000o
L`0208Wh00@0Eg<00P2jm`000`1VIVH0KG<006ec00020>_g00<0Lf800P3gdP0407=;00050?NQ001c
=000Lc@007<d000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@0
0P3gX@04084k00P0mg001@211`0T0?H>0080SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj40
1@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg00
1`2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0
^2l00`3g?`070;P;01l0mPh03P3gL0060;d;01l0mPh00P3gL0070<8b00@0mcl01`322`0N0?H>00`0
mg002037300M0?H>05T0oooo001C0?ooo`H00000>P3oool00`000000oooo0?ooo`090?ooo`03001`
L`00lOP007=P008007=P00<0IVIV001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK080
07<K0P00n3/3001c1003003h2@1VIVH04W<000804W<000<09oP002Uc000YL`000P0YL`00101Hn000
?g<003mc000oL`0208Wh00@0Eg<00P2jm`000`1VIVH0KG<006ec00020>_g00<0Lf800P3gdP0407=;
00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000
PE@00080PE@00P3gX@04084k00P0mg001@211`0S0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P03
0:Y=00<0mg001`2Z;0020?Lo00H0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;01l0mPh03P3gL0070;d;01h0mPh00P3gL0070<8b00@0mcl01`32
2`0N0?H>00`0mg002037300M0?H>05T0oooo002C0?ooo`030000003oool0oooo00P0oooo0P00L7<0
1@00lOP007=P001cH000Lf00IVIV00@007=91000Lc82003hK08007<K0P00n3/3001c100306IVIP0B
L`004W<000804W<000<09oP002Uc000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00<0Eg<0
0P2jm`00101VIVH0KG<006ec001]L`020>_g00<0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d
000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k
00P0mg001@211`0S0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`
00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo
00L0ZPX07`3f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`07
0;P;01l0mPh03P3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg002037300M
0?H>05T0oooo002B0?ooo`030000003oool0oooo00T0oooo0P00L7<01@00lOP007=P001cH01VIVH0
0?S?00@007=91000Lc82003hK08007<K0P00n3/3001c100306IVIP0BL`004W<000804W<000<09oP0
02Uc000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00<0Eg<00P2jm`00101VIVH0KG<006ec
001]L`020>_g00<0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080
mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0S0?H>00<0
SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280
mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00L0ZPX07`3f3P030;5@00`0
mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh000<0_EH00?M`
003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg002037300M0?H>
05T0oooo002B0?ooo`030000003oool0oooo00P0oooo0`00L7<01@00lOP007=P001cH01VIVH00?S?
00<007=900<00?RM001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`8007<400<0IVIV
003h2@0BL`000`0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP00`1G
L`000`2jm`00IVIV06ec000306ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c
=000Lc@007<d000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@0
0P3gX@04084k00P0mg001@211`0S0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj40
1@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P030:Y=00<0mg00
1`2Z;0020?Lo00L0ZPX0803f3P030;5@00/0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0
^2l00`3g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b00<0
mcl01`322`0N0?H>00`0mg002037300M0?H>05T0oooo00170?ooo`D00000103oool300000080oooo
0`0000020?ooo`@0000000<0oooo0000003oool00P0000020?ooo`<0000000<0oooo0000003oool0
100000020?ooo`8000000`3oool2000000<0oooo0`00aOlD0?ooo`030000003oool0oooo00P0oooo
0`00L7<01@00lOP007=P06IVIP00Lf000?S?00<007=900<00?RM001c<P00Lc800P00Lc801000n6`0
07<K001c6`00La/2003h>`8007<400<0IVIV003h2@0BL`000`0BL`000`0Wn000:G<002Uc000202Uc
000405Sh000oL`00?g<003mc0080ROP00`1GL`000`2jm`00IVIV06ec000306ec00030>_g001cHP00
Lf800080Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080mcl00`1c
1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0S0?H>00<0SE`00P3g
X@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2R
B@0:0?M`00H0XPT08P3f3P030:Y=00<0mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@00/0mg001`2a
2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0mPh000<0_EH00?M`003gL000
2`3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg002037300M0?H>05T0oooo
00180?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000040?ooo`D00<Go4P3oool00`000000oooo0?ooo`080?ooo`@0071c00D00?7h001cH01VIVH0
07=P003hc`03001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/01000
L`@0IVIV001c1000n0T3019c00809oP0100YL`00101Hn000?g<003mc000oL`0208Wh00<0Eg<000<0
IVIV0;[g001]L`000`1]L`000`3[m`00Lf8007=R000207=R0080mm80101cB`001@3gX@00Lc@007<d
001c=00000000080mg00101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj40
1021>`080?M`00D0P@L08`3f3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D0
0P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT02P3gL0060:890280mPh0102ZC@020?M`00L0ZR`0
0P3g?`070:X:0200mPh00`2aD00;0?M`00L0/@X08@3f3P030?M`00L0^2l00`3g?`070;P;01l0mPh0
00<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`322`0N0?H>00`0mg00
2037300M0?H>05T0oooo00180?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000003oool00000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`000000103oool70035oa40oooo00<000000?ooo`3oool0203oool4001`L`05003an01VIVH0
07=P001cH000n<l00`00LdT00`00n9d007<b001c<P02001c<P04003hK000La/007<K001c6`800?Pk
00@007<406IVIP00L`@00?P90`0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0
Eg<000<0IVIV0;[g001]L`000`1]L`000`3[m`00Lf8007=R000207=R0080mm800`1cB`020?NQ00<0
Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0003
0?NQ0021>`00PC/000<0PC/0203gL005084702<0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0
mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900X0mg001P2R2@0R0?H>00@0
ZTd00P3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E002`3gL0070;4:0240mPh0103gL0060;P_00<0
mcl01`2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0N0?H>0080mg002032<P030?Lo00L0
`P/07P3f3P0<0?M`00P0a``07@3f3P1I0?ooo`00B03oool01@000000oooo0?ooo`3oool000000080
oooo1@0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000003oool0
000000<0oooo100000030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`L00<Go403oool0
0`000000oooo0?ooo`090?ooo`@0071c00D00?7h06IVIP00Lf0007=P003hc`03001cB@04003hW@00
Lc8007<b001c<P800?Q/0`00La/01P00n3/007<4001c101VIVH007<4003h2@<04W<00P0Wn00302Uc
000305Sh000oL`00?g<00080?g<00P29n00205Mc000306IVIP2jm`00^_L000@0KG<000<0joL007=R
001cHP000P1cHP020?OB00<0Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<6
02D0mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00P0mg0010211`0T0?H>
00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P9
0280mPh01P2RB@0:0?M`00H0XPT08P3f3P040:Y=0080mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@
00/0mg001`2a2P0Q0?H>00@0mg001P2h;`030?Lo00L0^0/0803f3P0=0?M`00L0_@/07P3f3P020?M`
00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01d0mPh0F@3oool004P0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00P00000
0?ooo`3oool000000?ooo`000000oooo000000H0oooo00D000000?ooo`3oool0oooo000000050?oo
o`030000003oool0000000@0oooo1`00aOl@0?ooo`030000003oool0oooo00T0oooo1000L7<01@00
Lf00IVIV001cH000Lf000?S?00<007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00
L`@0IVIV008007<400@00?P9019c000BL`004W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<0
0P29n00205Mc000306IVIP2jm`00^_L000@0KG<000<0joL007=R001cHP000P1cHP020?OB00<0Ld/0
0P3gX@0307<d00030000003gL000mg0000@0Lad000<0mcl007<6001c1P000P1c1P0U0?H>00030?OB
0021E000PE@00080PE@000<0mj40084k0021>`000`21>`080?M`00@0P@L0903f3P0308eL0080mj40
1@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT0
2P3gL0060:890280mPh0102ZC@020?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00H0/@X0
8@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0P0?H>00d0mg001`2m2`0N0?H>0080
mg002032<P030?Lo00P0`P/07P3f3P0;0?M`00P0a``07@3f3P1I0?ooo`00B03oool01@000000oooo
0?ooo`3oool0000000<0oooo0`0000020?ooo`030000003oool00000008000000P3oool300000003
0?ooo`000000oooo0080oooo100000030?ooo`030000003oool00000008000000P3oool00`000000
oooo0?ooo`02000000<0oooo1@00aOl<0?ooo`8000000P3oool00`000000oooo0?ooo`090?ooo`03
0030n@00L7<0071c0080071c00D0IVIV001cH000Lf0007=P003hc`03001cB@04003hW@00Lc8007<b
001c<P800?Q/0`00La/00`00n3/007<406IVIP02001c1004003h2@0BL`004W<0019c00809oP00`0Y
L`000`1Hn000?g<003mc000203mc0080ROP000<0Eg<006IVIP1GL`000P2jm`0406ec00030>_g001c
HP00Lf800080Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`001c7@00101c
7@000`3g?`00L`H007<6000207<602D0mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k
0003084k00P0mg0010211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2H
A@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0:0?M`00H0XPT08P3f3P040:Y=0080mg001`2Z
;0020?Lo00L0ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0
103g?`060;P;0200mPh03@3gL0070;d;01h0mPh00P3gL0080<8b00@0mcl01`322`0N0?H>00`0mg00
1`37300M0?H>05T0oooo00180?ooo`050000003oool0oooo0?ooo`0000009@3oool00`000000oooo
0?ooo`060?ooo`<00<Go3`3oool4000000T0oooo00<005Uc0030n@00L7<00`00L7<01@1VIVH007=P
001cH000Lf000?S?00<007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`1VIVH007<4
008007<400@00?P9019c000BL`004W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<000D0ROP0
05Mc001GL`00IVIV05Mc00020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3g
X@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602D0mPh000@0mm80085D0021E000PE@0
0P3gX@05084k00P0mg0010211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj40
1@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg00
1P2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00H0
^2l0103g?`060;P;0200mPh03@3gL0070;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0N0?H>00`0
mg002037300M0?H>05P0oooo00170?ooo`D000009P3oool00`000000oooo0?ooo`0J0?ooo`040000
003oool00000000000L0oooo00<005Uc0030n@00L7<00P00L7<00`1VIVH007=P001cH002001cH005
003hc`00LdT007=9001cB@00n9d00`00Lc82003hK08007<K0P00n3/01@1VIVH007<4001c1000L`@0
0?P900<04W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<000<0ROP005Mc001VIVH00P1GL`02
0;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@0207<d00030000001c=000
mg0000@0Lad00P3g?`0407<602@0mPh00P3gdP03085D0080mj401@21>`080?M`00@0P@L0903f3P03
08eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R
0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:0200mPh00`2aD00<
0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0P0?H>00d0mg001`2m
2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00P0a``07@3f3P1H0?ooo`00F@3oool3
000001D0oooo0P00000K0?ooo`030000003oool0oooo00P0oooo0P00FG<01@00`?T0071c001`L`00
L7<0IVIV00@007=P1000LdT01000n9d007<b001c<P00Lc82003hK08007<K00<00?Pk06IVIP00L`@0
0`00L`@4019c00809oP00`0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00IVIV0080Eg<0
0P2jm`0306ec0080joL0101cHP000`3gdP00Ld/007=;000207=;0080mj4000D0Lc@006IVIP000000
Lc@00?M`000407<M0080mcl0101c1P0T0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00P0
mg0010211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>0080mj401@2HA@020?M`00H0
V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0020?Lo00L0
ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`060;P;
0200mPh03@3gL0070;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0N0?H>00`0mg002037300M0?H>
05P0oooo001L0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0203oool2001IL`05
0030n@00L7<0071c06IVIP00lOP01000Lf04001cB@04003hW@00Lc8007<b001c<P800?Q/0P00La/0
0`00n3/0IVIV001c1002001c1003003h2@0BL`004W<000804W<00P0Wn00302Uc000305Sh000oL`00
?g<00080?g<000<0ROP006IVIP1GL`000P1GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00
Ld/00080Ld/00P3gX@001@1c=000IVIV0000001c=000mg0000@0Lad00P3g?`0407<602@0mPh000<0
mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004084702@0mPh00`2=G0020?NQ00D0SD002@3g
L00508d802<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R
2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh000@0
^5<00?M`003gL000mg001P2h;`040?Lo00H0^0/0803f3P0=0?M`00L0_@/07`3f3P020?M`00L0`S80
103g?`070<8;01h0mPh0303gL0080<L<01d0mPh0F03oool005`0oooo00<000000?ooo`3oool0;P3o
ool00`000000oooo0?ooo`080?ooo`<005Uc00D00<3i001`L`00L7<0IVIV003an003001cH003003h
c`00LdT007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`2001c6`0306IVIP00n3/007<40080
07<400<00?P9019c000BL`000P0BL`0202Oh00<0:G<000@0F?P003mc000oL`00?g<00P29n000101V
IVH0Eg<005Mc001GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@00
0`1VIVH0Lc@0000000020?M`00@0Lad00P3g?`0407<602@0mPh000<0mm80085D0021E0000P21E002
0?NQ00D0PC/0203gL004084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0mPh00P3gX@05
09Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL006
0:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001P2h
;`040?Lo00L0^0/07`3f3P0=0?M`00L0_@/07`3f3P020?M`00L0`S80103g?`070<8;01h0mPh0303g
L0080<L<01d0mPh0F03oool00180oooo0`0000020?ooo`<000000P3oool2000000030?ooo`000000
000000<00000103oool3000000<0oooo0`0000040?ooo`<0000000<0oooo0000003oool01`3oool3
00000080oooo0P0000000`3oool0000000000003000000040?ooo`000000000000000080oooo0P00
00020?ooo`@000000`3oool3000000040?ooo`000000oooo0?ooo`<000000P3oool2000000030?oo
o`000000oooo00800000103oool3002Boa<0oooo00<000000?ooo`3oool0203oool3001IL`050030
n@00L7<0071c06IVIP00lOP00`00Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b001c
<P800?Q/0P00La/00`1VIVH00?Pk001c1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh000406IVIP1GL`00Eg<005Mc0080^_L00`1]
L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ000306IVIP1c=00000000080mg00101c
7@020?Lo00@0L`H0903f3P000`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L0903f
3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00D0V4D00P3gL00609PW0080mcl01P2H
2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:0200mPh00`2a
D00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0O0?H>00d0mg00
1`2m2`0O0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?M`00P0a``07@3f3P1H0?ooo`004@3o
ool2000000030?ooo`00000000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0000003oool0000000@0oooo1@00T_lA0?ooo`030000003o
ool0oooo00P0oooo1000FG<01@00`?T0071c06IVIP00L7<00?7h00<007=P00<00?S?001cB@00LdT0
0P00LdT4001c<P800?Q/0P00La/00`1VIVH00?Pk001c1002001c1003003h2@0BL`004W<000804W<0
00<09oP002Uc000YL`000P0YL`001P1Hn000?g<003mc000oL`00ROP006IVIP@0Eg<00P2jm`0306ec
0080joL00`1cHP020?OB00@0Ld/000D0mj4006IVIP1c=000Lc@0000000020?M`00@0Lad00P3g?`04
07<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00`2=G002
0?NQ00D0SD002@3gL00508d802<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P06
0:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL006
0;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0>0?M`00L0_@/07P3f
3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01d0mPh0F03oool00140oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool0000000X0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0000003oool0000000<0oooo1`00T_l@0?ooo`030000003oool0oooo00P0oooo1000FG<01@00
`?T0071c06IVIP00L7<00?7h00<007=P00D00?S?001cB@00LdT007=9003hW@04001c<P800?Q/00@0
07<K06IVIP00n3/00?Pk0`00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<0
00H0F?P003mc000oL`00?g<008Wh001VIVH405Mc0080^_L00`1]L`020>_g00<0Lf800P3gdP0407=;
00050?NQ001VIVH0Lc@007<d000000000P3gL00407<M0080mcl0101c1P0T0?H>00030?OB0021E000
PE@00080PE@00P3gX@05084k00L0mg001@211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S
0?H>0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P04
0:Y=00<0mg001P2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;01l0mPh03P3gL0070;d;01h0mPh00P3gL0080<8b00<0mcl01`32
2`0N0?H>00`0mg002037300M0?H>05P0oooo000A0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000X0oooo0`0000060?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool000000?ooo`0000000`3oool7002Boa00oooo00<000000?ooo`3o
ool0203oool4001IL`050030n@1VIVH0071c001`L`00lOP00`00Lf001@00n<l007=9001cB@00LdT0
0?RM00@007<b00@00?Q/001c6`00La/0IVIV0P00n3/3001c1003003h2@0BL`004W<000804W<000<0
9oP002Uc000YL`000P0YL`001P1Hn000?g<003mc000oL`00IVIV08Wh00<0Eg<00P2jm`0406ec0080
joL00`1cHP020?OB00@0Ld/000D0IVIV07<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0307<6
02D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00`2=G0020?NQ
00D0SD002@3gL00508d802<0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:99
00/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0060;4:
0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P0>0?M`00L0_@/07P3f3P02
0?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01d0mPh0F03oool00140oooo00D000000?oo
o`3oool0oooo000000020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`8000001`3oool00`000000oooo0?ooo`020?ooo`800000
0P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?oo
o`3oool000000`3oool020000000oooo0?ooo`000000oooo0000003oool000000`3oool7002Bo`l0
oooo00<000000?ooo`3oool02@3oool4001IL`050030n@1VIVH0071c001`L`00lOP00`00Lf001@00
n<l007=9001cB@00LdT00?RM00@007<b00@00?Q/001c6`1VIVH007<K0P00n3/3001c1003003h2@0B
L`004W<000804W<000<09oP002Uc000YL`000P0YL`001P1Hn000?g<003mc000oL`00IVIV08Wh00<0
Eg<00P2jm`0406ec0080joL00`1cHP020?OB00@0Ld/000D0IVIV07<d001c=000Lc@0000000020?M`
00@0Lad00P3g?`0307<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL0050847
02@0mPh00`2=G0020?NQ00D0SD002@3gL00408d802@0mPh00P3gX@0509Q50080mg001P2H9`020?Lo
00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>
00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P00
0`2mEP00mg000?M`000;0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL008
0<L<01d0mPh0F03oool00140oooo00P000000?ooo`3oool0oooo0000003oool000000?ooo`<00000
0`3oool3000000@0oooo1@0000030?ooo`<00000103oool4000000X0oooo00<000000?ooo`000000
103oool3000000<0oooo00<000000?ooo`0000000P0000040?ooo`<0000000@0oooo0000003oool0
oooo100000030?ooo`<000000P3oool3000000030?ooo`000000oooo00@0oooo1@00T_l<0?ooo`80
00000P3oool00`000000oooo0?ooo`080?ooo`03002?n@00FG<005Uc008005Uc00D0IVIV001`L`00
L7<0071c003an003001cH005003hc`00LdT007=9001cB@00n9d01000Lc801000n6`007<K06IVIP00
La/2003h>`<007<400@00?P9019c000BL`004W<00P0Wn00402Uc000405Sh000oL`00?g<006IVIP80
ROP00`1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB00<0Ld/000<0IVIV0?NQ001c
=0000P1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080
PE@00P3gX@05084k00L0mg001@211`0T0?H>00<0SE`00P3gX@0408e000X0mg00102=200T0?H>0080
mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0
mg001P2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`
00L0^2l00`3g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b
00<0mcl01`322`0O0?H>00/0mg002037300N0?H>05L0oooo000A0?ooo`050000003oool0oooo0?oo
o`0000004@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo00@000000?oo
o`3oool00000703oool00`000000oooo0?ooo`0A0?ooo`<009;o3`3oool4000000T0oooo00<008oi
001IL`00FG<00P00FG<01@1VIVH0071c001`L`00L7<00?7h00<007=P00D00?S?001cB@00LdT007=9
003hW@04001c<P04003hK01VIVH007<K001c6`800?Pk0`00L`@01000n0T04W<0019c000BL`0202Oh
00@0:G<000@0F?P003mc000oL`00IVIV0P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R0002
07=R0080mm800`1cB`000`1VIVH0mj4007<d000207<d00030000003gL000mg0000@0Lad00P3g?`03
07<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00P2=G003
0?NQ00@0SD002P3gL00408d802@0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P06
0:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL007
0;4:0200mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P000`2mEP00mg000?M`
000;0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`080<8;01h0mPh0303gL0070<L<01h0mPh0E`3o
ool00100oooo0`000000103oool0000000000000000@0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool01`3oool3000000030?ooo`000000000001/0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`02000000H0oooo00<0049c002?n@00FG<00P00FG<00`1VIVH0071c001`
L`02001`L`05003an000Lf0007=P001cH000n<l00`00LdT01000n9d007<b001c<P00Lc82003hK004
06IVIP00La/007<K003h>`@007<400@00?P9019c000BL`004W<00P0Wn00302Uc000505Sh000oL`00
?g<006IVIP0oL`000P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm800P1c
B`000`1VIVH0Ld/00?NQ000307<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh000<0
mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00P2=G0030?NQ00@0SD002P3g
L00408d802@0mPh00P3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R
2@0R0?H>00@0ZTd00`3gL0060:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0070;4:0200mPh000@0
^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00L0_@/0
7P3f3P020?M`00P0`S800`3g?`080<8;01h0mPh0303gL0080<L<01d0mPh0E`3oool00240oooo00<0
00000?ooo`3oool04`3oool2000001<0oooo00<000000?ooo`3oool04`3oool2000002D0oooo00<0
00000?ooo`3oool02@3oool00`00@W<008oi001IL`02001IL`0306IVIP00L7<0071c0080071c1000
Lf001@00n<l007=9001cB@00LdT00?RM00<007<b00<00?Q/06IVIP00La/00P00La/00`00n3/007<4
001c1002001c1004003h2@0BL`004W<0019c00809oP00`0YL`001@1Hn000?g<003mc001VIVH0?g<0
0080ROP00`1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB0080Ld/000<0IVIV0?NQ
003gX@000`1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@0
0080PE@00P3gX@04084k00P0mg001@211`0T0?H>0080SE`00`3gX@0408e000X0mg00102=200T0?H>
0080mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=
00<0mg001P2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg00
0?M`00L0^2l00`3g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL008
0<8b00@0mcl01`322`0N0?H>00`0mg002037300M0?H>05L0oooo00290?ooo`030000003oool0oooo
00T0oooo00<0049c002?n@00FG<00P00FG<00`1VIVH0071c001`L`02001`L`@007=P00D00?S?001c
B@00LdT007=9003hW@03001c<P03003hK01VIVH007<K008007<K00<00?Pk001c1000L`@00P00L`@0
1000n0T04W<0019c000BL`0202Oh00<0:G<000<0F?P003mc001VIVH00P0oL`0208Wh00<0Eg<00P2j
m`0406ec00030>_g001cHP00Lf800080Lf800P3gdP000`1cB`00IVIV07=;00020?NQ00<0Lc@000<0
00000?M`003gL000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401021
>`080?M`00D0P@L0903f3P0208eL00<0mj40102=@00:0?M`00@0S@P0903f3P020?NQ00D0V4D00P3g
L00609PW0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g
?`070:X:0200mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/0
7P3f3P0<0?M`00P0a``07@3f3P1G0?ooo`00R@3oool00`000000oooo0?ooo`080?ooo`80049c00D0
08oi001IL`00FG<0IVIV0030n@03001`L`03003an000Lf0007=P008007=P00D00?S?001cB@00LdT0
07=9003hW@03001c<P0306IVIP00n6`007<K008007<K00<00?Pk001c1000L`@00P00L`@01000n0T0
4W<0019c000BL`0202Oh00<0:G<000<0F?P003mc001VIVH00P0oL`0208Wh00<0Eg<00P2jm`0406ec
00030>_g001cHP00Lf800080Lf800P3gdP000`1cB`00IVIV07=;00020?NQ00<0Lc@000<000000?M`
003gL000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`
00D0P@L0903f3P0208eL00<0mj40102=@00:0?M`00@0S@P0903f3P020?NQ00D0V4D00P3gL00609PW
0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00P3g?`070:X:
0200mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P
0?H>00d0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00P0a``07@3f3P1G
0?ooo`00R03oool00`000000oooo0?ooo`090?ooo`80049c00D008oi001IL`00FG<0IVIV0030n@03
001`L`03003an000Lf0007=P008007=P1000LdT01P00n9d007<b001c<P00Lc80IVIV003hK0<007<K
00<00?Pk001c1000L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0:G<000<0F?P006IVIP0o
L`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0003
0?OB001cB`00IVIV0080Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0
mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00P2=G0030?NQ00@0
SD002P3gL00408d802<0mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0609P90280
mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0
mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3gL0070;d;
01h0mPh00`3gL0070<8b00@0mcl01`322`0N0?H>00`0mg002037300M0?H>05L0oooo000Q0?ooo`<0
00000P3oool010000000oooo0?ooo`3oool3000000@0oooo00<000000?ooo`0000002`3oool50000
00<0oooo0`0000040?ooo`<0000000<0oooo0000003oool01P0000020?ooo`<0000000<0oooo0000
000000000P0000020?ooo`8000000P3oool3000000030?ooo`000000oooo0080oooo0`00H?lC0?oo
o`030000003oool0oooo00P0oooo0`00@W<01@00SoT005Uc06IVIP00FG<00<3i00<0071c00<00?7h
001cH000Lf000P00Lf04001cB@06003hW@00Lc8007<b001c<P1VIVH00?Q/0P00La/2003h>`@007<4
00@00?P9019c000BL`004W<00P0Wn00302Uc000305Sh001VIVH0?g<00080?g<000<0ROP005Mc001G
L`000P1GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00IVIV0080Ld/00P3gX@0307<d0003
0000003gL000Lad000@0Lad000<0mcl007<6001c1P000P1c1P0U0?H>00030?OB0021E000PE@00080
PE@00P3gX@04084k00P0mg001@211`0T0?H>0080SE`00`3gX@0408e000X0mg00102=200S0?H>0003
09QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280
mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0200mPh00`2aD00<0?M`00L0/@X0803f3P00102hD`00
mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg001`32<P040?Lo
00L0`P/07P3f3P0<0?M`00P0a``07@3f3P1G0?ooo`008P3oool00`000000oooo0?ooo`0200000080
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000/0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool5
001Poa40oooo00<000000?ooo`3oool02@3oool30012L`05002?n@00FG<0IVIV001IL`00`?T00`00
L7<01@00lOP007=P001cH000Lf000?S?00@007=900@00?RM001c<P00Lc80IVIV0P00n6`2001c6`80
0?Pk1000L`@4019c00809oP00`0YL`000`1VIVH0?g<003mc000203mc000308Wh001GL`00Eg<00080
Eg<00P2jm`0306ec0080joL0101cHP000`3gdP00IVIV07=;000207=;0080mj400P1c=0000`000000
Lc@00?M`000507<M00030?Lo001c1P00L`H00080L`H09@3f3P000`3gdP00PE@0085D0002085D0080
mj401021>`080?M`00D0P@L0903f3P0208eL00<0mj40102=@0090?M`00D0S@P08`3f3P000`2HH`00
mj400?NQ000509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0
ZTd00`3gL0060:X/00<0mcl01P2Z2P0P0?H>00<0/E00303gL0070;4:0240mPh00`3gL0070;P_00<0
mcl01`2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00P0
a``07@3f3P1G0?ooo`008P3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0
103oool01@000000oooo0000003oool0000000/0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`L0063o403oool00`000000oooo0?ooo`090?ooo`<0
049c00D008oi06IVIP00FG<005Uc0030n@03001`L`05003an000Lf0007=P001cH000n<l01000LdT0
1000n9d007<b001c<P1VIVH2003hK08007<K0P00n3/3001c1003003h2@0BL`004W<000804W<00P0W
n00302Uc000306IVIP0oL`00?g<00080?g<000<0ROP005Mc001GL`000P1GL`020;[g00<0KG<00P3[
m`0407=R00030?OB001VIVH0Ld/00080Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g
?`0407<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00P2=
G0030?NQ00@0SD002@3gL00508d802<0mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g
?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f
3P030;5@00`0mg001`2a2P0Q0?H>00@0mg001P2h;`040?Lo00H0^0/0803f3P0=0?M`00L0_@/07`3f
3P020?M`00P0`S800`3g?`070<8;01h0mPh0303gL0080<L<01d0mPh0E`3oool00280oooo00D00000
0?ooo`000000oooo000000020?ooo`D000000P3oool01@000000oooo0000003oool0000000`0oooo
00<000000?ooo`3oool00P3oool5000000<0oooo100000040?ooo`030000003oool0oooo00<0oooo
100000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo1`00H?l?0?ooo`030000003oool0oooo00X0oooo0`00@W<01@00SoT0IVIV001IL`00FG<0
0<3i00<0071c00D00?7h001cH000Lf0007=P003hc`04001cB@04003hW@00Lc80IVIV001c<P800?Q/
0P00La/2003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000406IV
IP0oL`00?g<003mc0080ROP0101GL`020;[g00<0KG<00P3[m`0407=R000306IVIP1cB`00Ld/00080
Ld/00P3gX@0207<d00030000001c=000mg0000@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021
E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00P2=G0020?NQ00D0SD002@3gL00508d802<0
mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0
XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0mg001`2a2P0Q0?H>0004
0;QC003gL000mg000?M`00H0^2l0103g?`060;P;0200mPh03@3gL0070;d;01l0mPh00P3gL0080<8b
00<0mcl01`322`0N0?H>00`0mg002037300N0?H>05H0oooo000R0?ooo`050000003oool000000?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
000<0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0200000080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`07001Po`/0oooo0P0000020?ooo`03
0000003oool0oooo00P0oooo0P00GOT30012L`05001IL`1VIVH005Uc001IL`00`?T00`00L7<01@00
lOP007=P001cH000Lf000?S?00@007=90P00Lc80101VIVH007<b003hK000n6`2001c6`800?Pk0`00
L`@00`00n0T04W<0019c0002019c000602Oh000YL`00:G<002Uc001VIVH0F?P00`0oL`0208Wh00@0
Eg<00P2jm`0306ec0080joL0101cHP000`1VIVH0Ld/007=;000207=;0080mj400P1c=003000000@0
Lad00P3g?`0407<602D0mPh000<0mm80085D0021E0000P21E0000`3gX@00PC/0084k0003084k00P0
mg001@211`0T0?H>0080SE`00P3gX@0508e000T0mg001@2=200S0?H>000309QS003gX@00mj4000D0
V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0
ZR`00`3g?`060:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_
00@0mcl01P2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg002032<P030?Lo00L0`P/07P3f3P0<0?M`
00P0a``07P3f3P1F0?ooo`008P3oool200000080oooo00@000000?ooo`3oool0oooo0`0000020?oo
o`<0000000@0oooo00000000000000002@3oool010000000oooo0?ooo`0000040?ooo`<000000`3o
ool4000000D0oooo00<000000?ooo`3oool00P3oool400000080oooo00<000000?ooo`0000000P00
00040?ooo`@000000`3oool5001Po`h0oooo100000090?ooo`8005gi0`00@W<01@1VIVH005Uc001I
L`00FG<00<3i00<0071c00D00?7h001cH000Lf0007=P003hc`03001cB@03003hW@00Lc80IVIV0080
07<b0P00n6`2001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c000602Oh000YL`00:G<002Uc
001VIVH0F?P00`0oL`0208Wh00@0Eg<00P2jm`0306ec0080joL00`1cHP000`1VIVH0mm8007=;0003
07=;0080mj400P1c=0000`000000mg000?M`000200000080Lad00P3g?`0407<602D0mPh000<0mm80
085D0021E0000P21E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T0?H>0080SE`00P3gX@05
08e000T0mg001@2=200S0?H>000309QS003gX@00mj4000D0V4D00P3gL00609PW0080mcl01P2H2@0R
0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0200mPh00`2aD00<
0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0P0?H>00d0mg00202m
2`0N0?H>0080mg002032<P030?Lo00L0`P/07`3f3P0;0?M`00P0a``07P3f3P1F0?ooo`008P3oool2
00000080oooo00<000000?ooo`3oool05P3oool01@000000oooo0?ooo`3oool000000180oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`020?ooo`<0063o403oool00`000000oooo0?oo
o`02000000H0oooo00<002]c001Mn@00GOT00P00@W<00`00SoT0IVIV001IL`02001IL`050030n@00
L7<0071c001`L`00lOP00`00Lf001`00n<l007=9001cB@00LdT00?RM001c<P1VIVH00P00Lc801000
n6`007<K001c6`00La/2003h>`<007<400<00?P9019c000BL`000P0BL`001P0Wn000:G<002Uc001V
IVH0:G<005Sh00<0?g<00P29n00405Mc0080^_L00`1]L`020>_g00<0Lf8000<0IVIV0?OB001cB`00
0`1cB`020?NQ0080Lc@000<000000?M`003gL000101c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0
085D0002085D00030?NQ0021>`00PC/000<0PC/0203gL005084702@0mPh00P2=G0020?NQ00D0SD00
2@3gL00508d802<0mPh000<0V6<00?NQ003gX@001@2HA@020?M`00H0V2L00P3g?`0609P90280mPh0
1P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0803f3P030;5@00`0mg00
1`2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`060;P;0200mPh03P3gL0070;d;01h0
mPh00P3gL0080<8b00<0mcl01`322`0O0?H>00`0mg002037300M0?H>05H0oooo000Q0?ooo`800000
0P3oool3000001L0oooo1@00000:0?ooo`<000001@3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0203oool00`00:g<005gi001Mn@020012L`0306IV
IP00FG<005Uc008005Uc1000L7<01@00lOP007=P001cH000Lf000?S?00<007=900<00?RM06IVIP00
Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<400<00?P9019c000BL`000P0BL`001P0W
n000:G<002Uc001VIVH0:G<005Sh00<0?g<00P29n00305Mc00<0^_L00`1]L`020>_g0080Lf8000<0
IVIV0?OB003gdP00101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@020?Lo00@0L`H0
903f3P020?OB00@0PE@000<0mj40084k0021>`000`21>`080?M`00@0P@L09@3f3P0208eL0080mj40
1@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT0
2`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0240mPh00P2aD00<0?M`00L0/@X0
8@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01`2h2`0O0?H>00h0mg001`2m2`0N0?H>0080
mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07@3f3P1F0?ooo`00C`3oool00`000000oooo
0?ooo`020?ooo`<000005@3oool2000001H0oooo00<000000?ooo`3oool02@3oool00`00:g<005gi
001Mn@020012L`0306IVIP00FG<005Uc008005Uc1000L7<01@00lOP007=P001cH000Lf000?S?00<0
07=900<00?RM06IVIP00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<400<00?P9019c
000BL`000P0BL`000`0Wn000:G<006IVIP0202Uc000405Sh000oL`00?g<003mc0080ROP00`1GL`02
0;[g00@0KG<00P3[m`0207=R000306IVIP3gdP00mm8000@0Ld/000D0mj4007<d001c=000Lc@00000
00020?M`00@0Lad00P3g?`0407<602@0mPh00P3gdP04085D00030?NQ0021>`00PC/000<0PC/0203g
L004084702D0mPh00P2=G0020?NQ00D0SD002@3gL00508d802<0mPh00`3gX@0509Q50080mg001P2H
9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z
2P0Q0?H>00<0/E002`3gL0070;4:0240mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo00L0^0/0
7`3f3P0>0?M`00L0_@/07P3f3P020?M`00P0`S800`3g?`080<8;01h0mPh0303gL0080<L<01d0mPh0
EP3oool004l0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`080?ooo`8002]c0P00
GOT00`00@W<0IVIV002?n@03001IL`030030n@00L7<0071c0080071c00D00?7h001cH000Lf0007=P
003hc`03001cB@0306IVIP00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1004
003h2@0BL`004W<0019c00809oP000D0:G<006IVIP0YL`00:G<005Sh000303mc0080ROP00`1GL`02
0;[g00@0KG<000D0joL007=R001cHP00Lf8006IVIP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0
000000020?M`00@0Lad00P3g?`0407<602@0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0
203gL004084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0mPh00`3gX@0509Q50080mg00
1P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/00<0mcl0
1P2Z2P0Q0?H>00<0/E002`3gL0070;4:0240mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo00L0
^0/07`3f3P0>0?M`00L0_@/07P3f3P020?M`00P0`S80103g?`070<8;01h0mPh0303gL0080<L<01d0
mPh0EP3oool004P0oooo100000030?ooo`@00000103oool3000000030?ooo`000000oooo00D00000
00@0oooo00000000000000000P3oool2000000<0oooo0`00;OlC0?ooo`030000003oool0oooo00T0
oooo0P00:g<2001Mn@030012L`1VIVH008oi00<005Uc00<00<3i001`L`00L7<00P00L7<4001cH005
003hc`00LdT007=9001cB@1VIVH00`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@01000
n0T04W<0019c000BL`0202Oh000306IVIP0YL`00:G<00080F?P00`0oL`0208Wh00<0Eg<00P2jm`04
06ec00050>_g001cHP00Lf8006IVIP1cHP000P3gdP0407=;00050?NQ001c=000Lc@007<d00000000
0P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00P0mg00
10211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>00<0mj401@2HA@020?M`00H0V2L0
0P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX0
8@3f3P030;5@00/0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;01l0
mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00P3gL0080<8b00@0mcl01`322`0N0?H>00`0
mg002037300M0?H>05H0oooo00180?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`D002go4P3oool00`000000oooo0?oo
o`080?ooo`<002]c0P00GOT00`1VIVH0049c002?n@03001IL`030030n@00L7<0071c0080071c1000
Lf001@00n<l007=9001cB@00LdT0IVIV00<007<b0P00n6`3001c6`03003h>`00L`@007<4008007<4
00@00?P9019c000BL`004W<00P0Wn0000`1VIVH0:G<002Uc000205Sh00<0?g<00P29n00305Mc0080
^_L0101]L`001@3[m`00Lf8007=R001VIVH0Lf800080mm80101cB`001@3gX@00Lc@007<d001c=000
00000080mg00101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401@21>`08
0?M`00@0P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL006
09PW0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00H0ZR`00`3g?`06
0:X:0240mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h
2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f
3P0<0?M`00P0a``07@3f3P1F0?ooo`00C03oool010000000oooo0?ooo`0000030?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool7000]oa40oooo00<000000?ooo`3oool0203oool3000[L`80
05gi00<0IVIV0012L`00SoT00`00FG<01@00`?T0071c001`L`00L7<00?7h00@007=P00D00?S?001c
B@00LdT0IVIV003hW@03001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1006003h2@0BL`00
4W<0019c000Wn000IVIV0`0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`020;[g00@0KG<0
00<0joL007=R001VIVH00P1cHP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0
Lad00P3g?`0307<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004084702@0
mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0mPh00`3gX@0509Q50080mg001P2H9`020?Lo00H0
V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0Q0?H>00<0
/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f3P000`2m
EP00mg000?M`000;0?M`00L0_@/07P3f3P030?M`00L0`S80103g?`070<8;01h0mPh0303gL0080<L<
01d0mPh0EP3oool004X0oooo0`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool40000
00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo1`00;Ol@
0?ooo`030000003oool0oooo00T0oooo0`00:g<2001Mn@0306IVIP00@W<008oi00<005Uc00D00<3i
001`L`00L7<0071c003an004001cH005003hc`00LdT007=906IVIP00n9d00`00Lc82003hK0<007<K
00<00?Pk001c1000L`@00P00L`@01P00n0T04W<0019c000BL`009oP006IVIP<0:G<000<0F?P003mc
000oL`000P0oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00IVIV0080Lf800P3gdP0407=;
00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080mcl00`1c1P0U0?H>00030?OB0021E000
PE@00080PE@00P3gX@05084k00P0mg0010211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S
0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`0609P90280mPh01P2RB@0;0?M`00D0XPT08P3f3P04
0:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01h0mPh00`3g
L0070<8b00@0mcl01`322`0N0?H>00`0mg002037300M0?H>05H0oooo00180?ooo`<00000103oool0
1@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`8000000P3oool00`000000oooo0?ooo`07000]oa00oooo00<000000?ooo`3oool02@3o
ool3000[L`05001Mn@1VIVH0049c0012L`00SoT00`00FG<01@00`?T0071c001`L`00L7<00?7h00@0
07=P0P00LdT00`1VIVH007=9003hW@03001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1006
003h2@0BL`004W<0019c001VIVH09oP00`0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`02
0;[g00@0KG<000<0joL006IVIP1cHP000P1cHP020?OB00<0Ld/00P3gX@0307<d00030000003gL000
mg0000@0Lad00P3g?`0307<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004
084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0mPh00`3gX@0509Q50080mg001P2H9`02
0?Lo00H0V0T08P3f3P060:9900/0mg001@2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01P2Z2P0Q
0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/07`3f
3P000`2mEP00mg000?M`000;0?M`00L0_@/07`3f3P020?M`00L0`S80103g?`070<8;01h0mPh0303g
L0080<L<01h0mPh0E@3oool004P0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000002
000000<0oooo100000030?ooo`<000000`3oool00`000000oooo00000002000000@0oooo1@00;Ol<
0?ooo`8000000P3oool00`000000oooo0?ooo`080?ooo`8002ci0`00:g<01@00GOT0IVIV0012L`00
@W<008oi00<005Uc00D00<3i001`L`00L7<0071c003an003001cH006003hc`00LdT007=906IVIP00
LdT00?RM0`00Lc82003hK08007<K0P00n3/4001c1006003h2@0BL`004W<0019c001VIVH09oP00`0Y
L`000`1Hn000?g<003mc000203mc0080ROP00`1GL`020;[g00@0KG<000<0joL006IVIP1cHP000P1c
HP020?OB00<0Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh000<0
mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00`2=G0020?NQ00D0SD002@3g
L00508d802<0mPh00`3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08P3f3P060:9900/0mg001@2R
2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01P2Z2P0Q0?H>00<0/E00303gL0060;4:0240mPh000@0
^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0=0?M`00L0_@/07`3f3P020?M`00L0`S80
103g?`070<8;01h0mPh0303gL0080<L<01h0mPh0E@3oool004P0oooo00D000000?ooo`3oool0oooo
0000000P0?ooo`<002go3`3oool4000000T0oooo0P00;?T3000[L`0506IVIP00@W<0049c0012L`00
SoT00`00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P00<00?S?001cB@1VIVH00P00LdT01000
n9d007<b001c<P00Lc82003hK08007<K0P00n3/4001c1004003h2@0BL`004W<006IVIP809oP00`0Y
L`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec000306IVIP1c
HP00Lf800080Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL000101c
7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L0903f
3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H
2@0R0?H>00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00L0ZR`00P3g?`060:X:0240mPh00`2a
D00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg00
1`2m2`0O0?H>0080mg002032<P030?Lo00L0`P/07`3f3P0;0?M`00P0a``07P3f3P1E0?ooo`00B@3o
ool4000003<0oooo00<000000?ooo`3oool00P0000060?ooo`03000DL`00;?T002ci008002]c00<0
05gi06IVIP00@W<00P00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c00L00?7h001cH000Lf00
07=P003hc`00LdT0IVIV008007=900@00?RM001c<P00Lc8007<b0P00n6`2001c6`800?Pk0`00L`@0
1@00n0T04W<0019c000BL`00IVIV00809oP00`0YL`000`1Hn000?g<003mc000203mc000308Wh001G
L`00Eg<00080Eg<00P2jm`0306ec00030>_g001VIVH0Lf8000<0Lf8000<0mm8007=;001cB`000P1c
B`020?NQ00<0Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D
0002085D0080mj401@21>`070?M`00D0P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f
3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>00H0XTT02`3gL0050:890280mPh0102Z
C@030?M`00L0ZR`00P3g?`060:X:0240mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`
003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg002032<P030?Lo00L0`P/0
7`3f3P0;0?M`00P0a``07P3f3P1E0?ooo`00G`3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo00P0oooo00<001Ac000/n@00;?T00P00:g<00`1VIVH005gi0012L`020012L`@005Uc00D0
0<3i001`L`00L7<0071c003an003001cH003003hc`1VIVH007=9008007=900@00?RM001c<P00Lc80
07<b0P00n6`2001c6`800?Pk0`00L`@01@00n0T04W<0019c000BL`00IVIV00809oP00`0YL`000`1H
n000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0306ec000306IVIP3[m`00Lf80
00<0Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`001c7@00101c7@020?Lo
00<0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L0903f3P0308eL
0080mj401@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0R0?H>
00H0XTT02`3gL0050:890280mPh0102ZC@030?M`00L0ZR`00P3g?`060:X:0240mPh00`2aD00<0?M`
00H0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg001`2m2`0O
0?H>0080mg002032<P030?Lo00L0`P/07`3f3P0<0?M`00P0a``07@3f3P1E0?ooo`00P03oool00`00
0000oooo0?ooo`080?ooo`03000DL`00;?T002ci008002]c00<0IVIV001Mn@00@W<00P00@W<4001I
L`050030n@00L7<0071c001`L`00lOP00`00Lf000`00n<l0IVIV001cB@02001cB@@007<b0P00n6`2
001c6`800?Pk0`00L`@01P00n0T04W<0019c001VIVH04W<002Oh00@0:G<000<0F?P003mc000oL`00
0P0oL`000`29n000Eg<005Mc000205Mc0080^_L00`1]L`000`1VIVH0joL007=R000307=R00030?OB
001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000Lad000@0Lad00P3g?`0307<602D0mPh0
00<0mm80085D0021E0000P21E0020?NQ00D0PC/01`3gL005084702@0mPh00`2=G0020?NQ00D0SD00
2@3gL00508d802<0mPh00`3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg00
1@2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0060;4:0240mPh0
00@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0=0?M`00L0_@/07`3f3P020?M`00P0
`S800`3g?`070<8;01l0mPh0303gL0080<L<01d0mPh0E@3oool007l0oooo00<000000?ooo`3oool0
203oool2000DL`8002ci00@002]c06IVIP00GOT005gi0P00@W<00`00SoT005Uc001IL`02001IL`05
0030n@00L7<0071c001`L`00lOP00`00Lf001@00n<l0IVIV001cB@00LdT00?RM00@007<b0P00n6`2
001c6`800?Pk0`00L`@01P00n0T04W<0019c001VIVH04W<002Oh00@0:G<000@0F?P003mc000oL`00
?g<00P29n00405Mc0080^_L00P1]L`000`1VIVH0joL00>_g000407=R00030?OB001cB`00Ld/00080
Ld/00P3gX@0207<d00030000001c=000mg0000D0Lad000<0mcl007<6001c1P000P1c1P0U0?H>0003
0?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000T0
mg001@2=200S0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`0509P902<0mPh01P2RB@0;0?M`00D0
XPT08P3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001P2a2P0Q0?H>0004
0;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3gL0070;d;01l0mPh00P3gL0080<8b
00<0mcl020322`0N0?H>00`0mg002037300M0?H>05D0oooo000m0?ooo`<000000`3oool4000000@0
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000060?ooo`<01@3o4`3oool00`000000
oooo0?ooo`080?ooo`8001Ac0P00;?T01000:g<0IVIV001Mn@00GOT20012L`03002?n@00FG<005Uc
008005Uc1000L7<01@00lOP007=P001cH000Lf00IVIV00<007=900<00?RM001c<P00Lc800P00Lc80
1000n6`007<K001c6`00La/2003h>`<007<400<00?P9019c001VIVH00P0BL`000`0Wn000:G<002Uc
000202Uc000405Sh000oL`00?g<003mc0080ROP0101GL`020;[g0080KG<000<0IVIV0>_g003[m`00
101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`000000Lc@00?M`000407<M0080mcl0
101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0T0?H>00<0SE`0
0P3gX@0508e000T0mg001@2=200S0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`0509P902<0mPh0
1P2RB@0;0?M`00D0XPT08P3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg00
1`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3gL0080;d;01h0
mPh00P3gL0080<8b00<0mcl020322`0N0?H>00`0mg002037300M0?H>05D0oooo000l0?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`000000103oool500D0oa40oooo00<000000?ooo`3oool0
203oool3000DL`8002ci00@002]c06IVIP00GOT005gi0P00@W<00`00SoT005Uc001IL`02001IL`@0
071c00D00?7h001cH000Lf0007=P06IVIP03001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c
6`00La/007<K0P00n3/3001c1003003h2@0BL`00IVIV00804W<000<09oP002Uc000YL`000P0YL`00
101Hn000?g<003mc000oL`0208Wh00@0Eg<00P2jm`000`1]L`00IVIV06ec00020>_g00@0Lf8000<0
mm8007=;001cB`000P1cB`020?NQ0080Lc@000<0000007<d003gL000101c7@020?Lo00@0L`H09@3f
3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`00D0P@L0903f3P0308eL0080mj401@2=
@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3g
L0050:890280mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X0803f
3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg00202m2`0N0?H>0080mg00
2032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07@3f3P1E0?ooo`00?03oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`L01@3o
403oool00`000000oooo0?ooo`080?ooo`<001Ac0P00;?T0101VIVH002]c001Mn@00GOT20012L`05
002?n@00FG<005Uc001IL`00`?T01000L7<01@00lOP007=P001cH01VIVH00?S?00<007=900<00?RM
001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<400<00?P906IVIP0BL`000P0B
L`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP00`1GL`030;[g000306ec
001VIVH0KG<00080joL0101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`000000mg00
0?M`000407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg00
1@211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>00<0mj401@2HA@020?M`00H0V2L0
0P3g?`0509P902<0mPh01P2RB@0;0?M`00D0XPT08`3f3P030:Y=00<0mg001`2Z;0020?Lo00L0ZPX0
803f3P030;5@00`0mg001`2a2P0P0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`060;P;0200
mPh03P3gL0070;d;01h0mPh00P3gL0080<8b00@0mcl01`322`0N0?H>00`0mg002037300M0?H>05D0
oooo000l0?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`030?ooo`D00000
0P3oool500000080oooo00<000000?ooo`3oool0103oool5000000<0oooo1`050?l?0?ooo`030000
003oool0oooo00T0oooo0`0057<2000/n@0406IVIP00:g<005gi001Mn@80049c00D008oi001IL`00
FG<005Uc0030n@04001`L`05003an000Lf0007=P06IVIP00n<l00`00LdT00`00n9d007<b001c<P02
001c<P04003hK000La/007<K001c6`800?Pk0`00L`@00`00n0T0IVIV019c0002019c000302Oh000Y
L`00:G<00080:G<000@0F?P003mc000oL`00?g<00P29n00305Mc00<0^_L000<0IVIV06ec001]L`00
0P3[m`0307=R0080mm80101cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@020?Lo00@0
L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`00D0P@L0903f3P0308eL0080
mj401@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0
XTT02`3gL0050:8902<0mPh00`2ZC@030?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0
/@X08@3f3P040?M`00H0^2l0103g?`060;P;0200mPh03P3gL0070;d;01h0mPh00P3gL0080<8b00@0
mcl01`322`0N0?H>00`0mg002037300N0?H>05@0oooo000l0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo1`050?l?0?ooo`030000003oool0oooo00T0oooo0`0057<01000;?T0IVIV000[
L`00:g<2001Mn@80049c00D008oi001IL`00FG<005Uc0030n@04001`L`8007=P00<0IVIV001cH000
n<l00`00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@0101V
IVH04W<0019c000BL`0202Oh00@0:G<000@0F?P003mc000oL`00?g<00P29n00305Mc0080^_L000@0
KG<006IVIP1]L`00KG<00P3[m`0307=R0080mm80101cB`001@3gX@00Lc@007<d001c=00000000080
mg00101c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401021>`080?M`00D0
P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P030?NQ00D0V4D00P3gL00609PW0080
mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh00`2ZC@030?M`00L0ZR`00P3g?`070:X:0200
mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01P2h2`0P0?H>
00h0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f3P0<0?M`00P0a``07P3f3P1D0?oo
o`00?03oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P0000030?oo
o`<00000103oool3000000@0oooo0`0000040?ooo`<000001@3oool500D0o``0oooo1@00000:0?oo
o`0600@0n@0057<001Ac000DL`00;?T0IVIV0P00:g<2001Mn@80049c00D008oi001IL`00FG<005Uc
0030n@03001`L`06003an000Lf0007=P06IVIP00Lf000?S?0`00LdT01000n9d007<b001c<P00Lc82
003hK0<007<K00<00?Pk001c1000L`@00P00L`@0101VIVH04W<0019c000BL`0202Oh00<0:G<00P1H
n00303mc0080ROP00`1GL`020;[g000506IVIP1]L`00KG<006ec003[m`00101cHP020?OB00@0Ld/0
00D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021
E0000P21E0020?NQ00@0PC/0203gL005084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0
mPh00`3gX@0509Q50080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg001@2R2@0S0?H>00<0
ZTd00`3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003g
L000mg001P2h;`040?Lo00H0^0/0803f3P0>0?M`00L0_@/07P3f3P030?M`00L0`S80103g?`070<8;
01h0mPh0303gL0080<L<01h0mPh0E03oool003`0oooo00D000000?ooo`3oool0oooo0000000X0?oo
o`<01@3o403oool5000000H0oooo00<00P1c00@0n@0057<00P0057<01@1VIVH002]c000[L`00:g<0
05gi00<0049c00D008oi001IL`00FG<005Uc0030n@03001`L`03003an000Lf00IVIV008007=P00D0
0?S?001cB@00LdT007=9003hW@03001c<P800?Q/0`00La/01P00n3/007<4001c1000L`@0IVIV003h
2@<04W<00P0Wn00302Uc0080F?P00`0oL`0208Wh00<0Eg<00P2jm`001@1VIVH0KG<006ec001]L`00
joL000@0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080mcl0101c
1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0T0?H>00<0SE`00P3g
X@0508e000T0mg001@2=200S0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`0509P902<0mPh01P2R
B@0;0?M`00D0XPT08`3f3P030:Y=00<0mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001`2a
2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`070;P;01l0mPh000<0_EH00?M`003gL000
2`3gL0070;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0N0?H>00`0mg002037300N0?H>05@0oooo
000m0?ooo`<00000?03oool00`000000oooo0?ooo`080?ooo`060080L`040?T001Ac000DL`00;?T0
IVIV0`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc00L00<3i001`L`00L7<0071c003an000
Lf00IVIV008007=P1000LdT01000n9d007<b001c<P00Lc82003hK0<007<K00H00?Pk001c1000L`@0
07<406IVIP00n0T3019c00809oP00`0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`000`2j
m`00IVIV06ec000306ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c=000Lc@0
07<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@04
084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200S0?H>00<0mj401@2HA@02
0?M`00H0V2L00P3g?`0509P902<0mPh01P2RB@0;0?M`00D0XPT08`3f3P030:Y=00<0mg001`2Z;002
0?Lo00L0ZPX0803f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g
?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01l0mPh00P3gL0070<8b00@0mcl01`32
2`0O0?H>00/0mg002037300N0?H>05@0oooo001k0?ooo`030000003oool0oooo00P0oooo0P0207<0
1@040?T001Ac000DL`00;?T0IVIV00<002]c00D005gi0012L`00@W<0049c002?n@03001IL`060030
n@00L7<0071c001`L`00lOP0IVIV0P00Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b
001c<P800?Q/0`00La/01P00n3/007<4001c101VIVH007<4003h2@<04W<00P0Wn00302Uc000305Sh
000oL`00?g<00080?g<00P29n00305Mc00030;[g001VIVH0KG<000<0KG<000<0joL007=R001cHP00
0P1cHP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0407<602@0
mPh00P3gdP04085D00030?NQ0021>`00PC/000<0PC/0203gL005084702@0mPh00`2=G0020?NQ00D0
SD002@3gL00508d802<0mPh00P3gX@0609Q50080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0
mg001@2R2@0S0?H>00<0ZTd00`3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0070;4:0240
mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo00L0^0/07`3f3P000`2mEP00mg000?M`000;0?M`
00L0_@/07`3f3P020?M`00L0`S80103g?`070<8;01l0mPh02`3gL0080<L<01h0mPh0E03oool007/0
oooo00<000000?ooo`3oool0203oool20080L`0500@0n@0057<001Ac06IVIP00;?T00`00:g<01@00
GOT0049c0012L`00@W<008oi00<005Uc00H00<3i001`L`00L7<0071c003an01VIVH2001cH003003h
c`00LdT007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`06003h>`00L`@007<406IV
IP00L`@00?P90`0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<000<0IVIV
0;[g001]L`000`1]L`000`3[m`00Lf8007=R000207=R0080mm80101cB`001@3gX@00Lc@007<d001c
=00000000080mg00101c7@020?Lo00<0L`H09@3f3P020?OB00@0PE@000<0mj40084k0021>`000`21
>`080?M`00D0P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P08`3f3P020?NQ00H0V4D00P3g
L00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh00`2ZC@030?M`00L0ZR`00P3g
?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl0
1`2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080mg001`32<P040?Lo00L0`P/0
7`3f3P0<0?M`00P0a``07@3f3P1D0?ooo`008@3oool3000000040?ooo`000000000000000080oooo
0`000000103oool000000?ooo`3oool3000000D0oooo0`0000020?ooo`@00000103oool300000003
0?ooo`000000oooo00H0000000<0oooo0000000000000`0000030?ooo`<0000000<0oooo0000003o
ool00`3oool303L0oa<0oooo00<000000?ooo`3oool0203oool30080L`0500@0n@0057<001Ac06IV
IP00;?T00P00:g<2001Mn@<0049c00D008oi001IL`00FG<005Uc0030n@03001`L`05003an01VIVH0
07=P001cH000n<l01000LdT01000n9d007<b001c<P00Lc82003hK08007<K0P00n3/01@00L`@0IVIV
001c1000L`@00?P900<04W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<00P29n00305Mc0003
06IVIP2jm`00KG<000<0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/000D0mj4007<d001c
=000Lc@0000000020?M`00@0Lad00P3g?`0307<602D0mPh00P3gdP04085D00030?NQ0021>`00PC/0
00<0PC/0203gL005084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802<0mPh00P3gX@0609Q5
0080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg001@2R2@0S0?H>00<0ZTd00`3gL0070:X/
0080mcl01`2Z2P0P0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`03
0?Lo00L0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00L0_@/07`3f3P020?M`00P0`S800`3g?`07
0<8;01l0mPh0303gL0080<L<01d0mPh0E03oool00280oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo1@0g0?lB0?ooo`030000003oool0oooo00L0oooo100207<0
0`040?T001Ac06IVIP02000/n@8002]c0P00GOT30012L`@005Uc00D00<3i001`L`00L7<0071c06IV
IP03001cH003003hc`00LdT007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`2001c6`800?Pk
00<007<406IVIP00L`@00P00n0T3019c00809oP00`0YL`000`1Hn000?g<003mc000203mc000308Wh
001GL`00Eg<00080Eg<000<0IVIV0;[g001]L`000`1]L`000`3[m`00Lf8007=R000207=R0080mm80
0`1cB`020?NQ00<0Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09@3f3P020?OB00@0PE@0
00<0mj40084k0021>`000`21>`080?M`00D0P@L0903f3P0208eL00<0mj401@2=@0090?M`00D0S@P0
8`3f3P020?NQ00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0
0`2ZC@030?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg00
0?M`003gL0070;P_00<0mcl01`2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080
mg002032<P030?Lo00L0`P/07`3f3P0<0?M`00P0a``07@3f3P1D0?ooo`008P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo
0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`L0=`3o4@3oool00`000000oooo0?ooo`070?ooo`@00P1c00<0103i000DL`1VIVH0
0P00;?T2000[L`8005gi0P00@W<00`00SoT005Uc001IL`02001IL`050030n@00L7<0071c001`L`1V
IVH00`00Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b001c<P800?Q/0P00La/2003h
>`04001c101VIVH007<4003h2@@04W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<000D0ROP0
05Mc001GL`00Eg<006IVIP020;[g00@0KG<000<0joL007=R001cHP000P1cHP000`3gdP00Ld/007=;
000207=;0080mj400`1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0U0?H>00030?OB0021
E000PE@000<0PE@000<0mj40084k0021>`000`21>`080?M`00D0P@L0903f3P0208eL00<0mj401@2=
@0090?M`00D0S@P08`3f3P020?NQ00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3g
L0050:8902<0mPh0102ZC@020?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f
3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg00
2032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07@3f3P1D0?ooo`008P3oool500000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`<00000103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo100000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0`3oool4000000<0oooo1`0g0?l@0?ooo`030000003oool0oooo00P0oooo100207<00`040?T0IVIV
000DL`02000/n@8002]c0P00GOT20012L`03002?n@00FG<005Uc008005Uc00D00<3i001`L`00L7<0
IVIV003an003001cH005003hc`00LdT007=9001cB@00n9d01000Lc82003hK08007<K0P00n3/0101V
IVH007<4001c1000n0T4019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`00
0`29n000Eg<00000000200000080^_L000D0KG<000000000000000000>_g000407=R00030?OB001c
B`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh000<0
mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004084702D0mPh00P2=G0030?NQ00@0SD002P3g
L00508d802<0mPh00P3gX@0609Q50080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg001@2R
2@0S0?H>00@0ZTd00P3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E00303gL0070;4:0240mPh000@0
^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0=0?M`00L0_@/07`3f3P020?M`00P0`S80
0`3g?`080<8;01h0mPh0303gL0080<L<01d0mPh0E03oool002<0oooo00<000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`3oool703L0
oa00oooo00<000000?ooo`3oool0203oool40080L`0300@0n@1VIVH001Ac008002ci0P00:g<2001M
n@80049c00<008oi001IL`00FG<00P00FG<01@00`?T0071c001`L`1VIVH00?7h00<007=P00D00?S?
001cB@00LdT007=9003hW@04001c<P800?Q/0P00La/2003h>`0406IVIP00L`@007<4003h2@@04W<0
00<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc000508Wh001GL`00Eg<00000001G
L`000P2jm`001@000000KG<006ec003[m`00000000@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ
00<0Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002085D
0080mj401@21>`080?M`00@0P@L09@3f3P0208eL00<0mj40102=@00:0?M`00D0S@P08`3f3P020?NQ
00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0102ZC@020?M`
00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL007
0;P_00<0mcl01`2h2`0P0?H>00d0mg001`2m2`0O0?H>0080mg002032<P030?Lo00P0`P/07P3f3P0<
0?M`00P0a``07P3f3P1C0?ooo`008`3oool00`000000oooo000000020?ooo`8000000P3oool20000
00<0oooo0`0000030?ooo`D000000P3oool00`000000oooo0000000200000080oooo100000050?oo
o`030000003oool0oooo0080oooo0`0000040?ooo`@000001@3oool503L0o``0oooo0P0000020?oo
o`030000003oool0oooo00P0oooo00<0=P3i0080L`0207<00P0207<00`1VIVH001Ac000DL`02000/
n@8002]c0P00GOT20012L`05002?n@00FG<005Uc001IL`00`?T00P00L7<00`1VIVH0071c003an003
001cH005003hc`00LdT007=9001cB@00n9d01000Lc801P00n6`007<K001c6`00La/00?Pk06IVIP<0
07<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc
00H000000P2jm`001@000000KG<006ec003[m`00000000@0Lf8000<0mm8007=;001cB`000P1cB`02
0?NQ00<0Lc@000<000000?M`001c7@00101c7@020?Lo00<0L`H09@3f3P000`3gdP00PE@0085D0002
085D0080mj401@21>`080?M`00@0P@L09@3f3P0208eL00<0mj40102=@00:0?M`00D0S@P08`3f3P02
0?NQ00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0102ZC@02
0?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003g
L0070;P_00<0mcl01`2h2`0P0?H>00d0mg00202m2`0N0?H>0080mg002032<P030?Lo00P0`P/07P3f
3P0<0?M`00P0a``07P3f3P1C0?ooo`00903oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool04`3oool303L0o`l0oooo100000090?ooo`0303H0n@0207<0
0P1c00800P1c00<0IVIV000DL`0057<00P00;?T2000[L`8005gi0P00@W<01@00SoT005Uc001IL`00
FG<00<3i0080071c00<0IVIV001`L`00lOP00`00Lf001@00n<l007=9001cB@00LdT00?RM00@007<b
00H00?Q/001c6`00La/007<K003h>`1VIVH3001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`002P1Hn000?g<003mc000oL`00000008Wh001GL`00IVIV0000001GL`020;[g0005
0000001]L`00KG<00>_g00000000101cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`00
0000mg0007<M000407<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k
00P0mg0010211`0U0?H>0080SE`00`3gX@0408e000X0mg001@2=200S0?H>0080mj401P2HA@020?M`
00H0V2L00P3g?`0509P902<0mPh01P2RB@0;0?M`00D0XPT08`3f3P040:Y=0080mg001`2Z;0020?Lo
00L0ZPX0803f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`07
0;P;0200mPh03@3gL0080;d;01h0mPh00P3gL0080<8b00@0mcl01`322`0N0?H>00`0mg002037300N
0?H>05<0oooo000R0?ooo`<000004`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool00P0000060?ooo`0301T0L`0f0?T00P1c00<00P1c00@0IVIV000D
L`0057<002ci0`00:g<2001Mn@80049c00L008oi001IL`00FG<005Uc0030n@00L7<0IVIV0080071c
00D00?7h001cH000Lf0007=P003hc`03001cB@03003hW@00Lc8007<b008007<b00H00?Q/001c6`00
La/007<K06IVIP00n3/3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`00
2P1Hn000?g<003mc000oL`00ROP00000001GL`00IVIV0000001GL`020;[g00050000001]L`00KG<0
0>_g00000000101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`000000Lc@00?M`0005
07<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00P0mg0010211`0U
0?H>0080SE`00`3gX@0408e000X0mg001@2=200S0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`05
09P902<0mPh01P2RB@0;0?M`00D0XPT08`3f3P040:Y=0080mg001`2Z;0020?Lo00L0ZPX0803f3P03
0;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3g
L0080;d;01h0mPh00P3gL0080<8b00@0mcl01`322`0N0?H>00`0mg002037300N0?H>05<0oooo001<
0?ooo`<000001P3oool010000000oooo00000000000N0?ooo`030000003oool0oooo00P0oooo00<0
6@1c03H0n@0207<00P0207<01@1VIVH001Ac000DL`0057<002ci00<002]c0P00GOT20012L`07002?
n@00FG<005Uc001IL`00`?T0071c06IVIP02001`L`@007=P00D00?S?001cB@00LdT007=9003hW@04
001c<P06003hK000La/007<K001c6`1VIVH00?Pk0`00L`@00`00n0T04W<0019c0002019c000302Oh
000YL`00:G<00080:G<000@0F?P003mc000oL`00?g<00P29n00010000000Eg<00000001GL`020;[g
00050000001]L`00KG<00>_g00000000101cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=000
0`000000Lc@00?M`000507<M00030?Lo001c1P00L`H00080L`H09@3f3P000`3gdP00PE@0085D0002
085D0080mj401@21>`080?M`00@0P@L09@3f3P0208eL00<0mj40102=@00:0?M`00D0S@P08`3f3P02
0?NQ00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0102ZC@02
0?M`00L0ZR`00P3g?`070:X:0240mPh00P2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003g
L0070;P_00<0mcl01`2h2`0P0?H>00d0mg00202m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07P3f
3P0<0?M`00P0a``07P3f3P1C0?ooo`00F@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00P0oooo00<06@1c03H0n@0207<00P0207<01@1VIVH001Ac000DL`0057<002ci00<002]c0P00
GOT20012L`09002?n@00FG<005Uc001IL`00`?T0071c06IVIP00L7<00?7h00@007=P00D00?S?001c
B@00LdT007=9003hW@03001c<P800?Q/0P00La/00`1VIVH00?Pk001c1003001c1003003h2@0BL`00
4W<000804W<000<09oP002Uc000YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00030000001G
L`00000000<0^_L000D0000006ec001]L`00joL00000000407=R00030?OB001cB`00Ld/00080Ld/0
0P3gX@0207<d00@000000`1c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj40
1@21>`080?M`00@0P@L09@3f3P0208eL00<0mj40102=@00:0?M`00@0S@P0903f3P020?NQ00H0V4D0
0P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0102ZC@020?M`00L0ZR`0
0P3g?`070:X:0240mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0
mcl01`2h2`0P0?H>00h0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07`3f3P0;0?M`00P0
a``07P3f3P1C0?ooo`00F@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00P0oooo
0P0I07<01@0f0?T00P1c0080L`1VIVH0103i00<001Ac00D002ci000[L`00:g<002]c001Mn@030012
L`06002?n@00FG<005Uc001IL`00`?T0IVIV0P00L7<00`00lOP007=P001cH002001cH005003hc`00
LdT007=9001cB@00n9d00`00Lc82003hK08007<K00<0IVIV003h>`00L`@00`00L`@01000n0T04W<0
019c000BL`0202Oh00@0:G<000L0F?P003mc000oL`00?g<008Wh001VIVH0Eg<0008000000`2jm`00
1@000000KG<006ec003[m`00000000<0Lf800P3gdP0407=;00080?NQ001c=000Lc@007<d00000000
Lc@00?M`001c7@04000000030?Lo001c1P00L`H00080L`H09@3f3P000`3gdP00PE@0085D0002085D
0080mj401@21>`080?M`00@0P@L09@3f3P0208eL00<0mj40102=@00:0?M`00@0S@P0903f3P020?NQ
00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0102ZC@020?M`
00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg000?M`003gL007
0;P_00<0mcl01`2h2`0P0?H>00h0mg001`2m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07`3f3P0<
0?M`00P0a``07@3f3P1C0?ooo`00>`3oool5000000@0oooo0`0000030?ooo`<0000000<0oooo0000
003oool01P0000030?ooo`030000003oool0oooo00@0oooo0`1Z0?lC0?ooo`030000003oool0oooo
00P0oooo0P0I07<01@0f0?T00P1c0080L`1VIVH0103i008001Ac0P00;?T3000[L`05001Mn@00@W<0
049c0012L`00SoT00`00FG<01@00`?T0IVIV001`L`00L7<00?7h00@007=P00D00?S?001cB@00LdT0
07=9003hW@03001c<P800?Q/00@007<K06IVIP00La/00?Pk1000L`@01000n0T04W<0019c000BL`02
02Oh00<0:G<00P1Hn00303mc000508Wh001VIVH0Eg<005Mc000000000P2jm`0206ec00<0000000@0
joL007=R001cHP00Lf800P3gdP0407=;00050?NQ001c=000Lc@006IVIP0000000P3gL00407<M0080
mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00L0mg001@211`0U0?H>0080
SE`00`3gX@0408e000X0mg00102=200T0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0509P902<0
mPh01P2RB@0;0?M`00D0XPT08`3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0
mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03P3gL0070;d;
01h0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300M0?H>05<0oooo000m0?ooo`03
0000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`<00000103oool506X0oa40oooo00<00000
0?ooo`3oool0203oool301T0L`0503H0n@0207<0IVIV0080L`040?T00P0057<2000/n@<002]c00D0
05gi0012L`00@W<0049c002?n@03001IL`0506IVIP00L7<0071c001`L`00lOP00`00Lf000`00n<l0
07=9001cB@02001cB@04003hW@00Lc8007<b001c<P800?Q/00@007<K06IVIP00La/00?Pk1000L`@0
1000n0T04W<0019c000BL`0202Oh00<0:G<00P1Hn00303mc000306IVIP29n000Eg<00080Eg<00P2j
m`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c=000Lc@006IVIP000000
0P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00L0mg00
1@211`0U0?H>0080SE`00P3gX@0508e000X0mg00102=200T0?H>0080mj401P2HA@020?M`00H0V2L0
0P3g?`0509P902<0mPh01P2RB@0;0?M`00D0XPT08`3f3P040:Y=00<0mg001P2Z;0020?Lo00L0ZPX0
8@3f3P030;5@00`0mg001P2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200
mPh03P3gL0070;d;01l0mPh00P3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300M0?H>05<0
oooo000m0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`L0
JP3o403oool00`000000oooo0?ooo`080?ooo`<06@1c00D0=P3i0080L`1VIVH00P1c00@0n@02000D
L`8002ci0P00:g<2001Mn@<0049c00D008oi001IL`00FG<005Uc06IVIP03001`L`05003an000Lf00
07=P001cH000n<l01000LdT01000n9d007<b001c<P00Lc82003hK00406IVIP00La/007<K003h>`@0
07<400@00?P9019c000BL`004W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<000<0IVIV08Wh
001GL`000P1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/000D0mj4007<d
001VIVH0Lc@0000000020?M`00@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021E0000P21E002
0?NQ00D0PC/01`3gL005084702@0mPh00`2=G0020?NQ00D0SD002P3gL00408d802@0mPh00P3gX@06
09Q50080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg001@2R2@0S0?H>00@0ZTd00`3gL006
0:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001`2h
;`040?Lo00H0^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00L0`S80103g?`070<8;01l0mPh0303g
L0080<L<01d0mPh0D`3oool003d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool706X0o`l0oooo00<000000?ooo`3oool02@3oool301T0L`0503H0n@0207<0IVIV0080L`040?T0
0P0057<2000/n@8002]c0P00GOT30012L`05002?n@00FG<005Uc06IVIP00`?T00`00L7<01@00lOP0
07=P001cH000Lf000?S?00@007=900@00?RM001c<P00Lc8007<b0P00n6`0101VIVH007<K001c6`00
n3/4001c1004003h2@0BL`004W<0019c00809oP00`0YL`001@1Hn000?g<003mc000oL`00IVIV0080
ROP00`1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/000D0mj4007<d001V
IVH0Lc@0000000020?M`00@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021E0000P21E0020?NQ
00@0PC/0203gL005084702@0mPh00`2=G0020?NQ00D0SD002P3gL00408d802@0mPh00P3gX@0609Q5
0080mg001P2H9`020?Lo00D0V0T08`3f3P060:9900/0mg001@2R2@0S0?H>00@0ZTd00`3gL0060:X/
0080mcl01`2Z2P0Q0?H>00<0/E00303gL0060;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`04
0?Lo00H0^0/0803f3P000`2mEP00mg000?M`000;0?M`00L0_@/07`3f3P020?M`00P0`S800`3g?`07
0<8;01l0mPh0303gL0080<L<01h0mPh0DP3oool003d0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo1`1Z0?l?0?ooo`030000003oool0oooo00T0oooo0`0I07<0
1@0207<0IVIV0080L`0207<0103i008001Ac0P00;?T2000[L`8005gi0`00@W<3001IL`0306IVIP00
`?T0071c0080071c00D00?7h001cH000Lf0007=P003hc`04001cB@06003hW@00Lc8007<b001c<P00
n6`0IVIV0P00La/2003h>`@007<400@00?P9019c000BL`004W<00P0Wn00302Uc000505Sh000oL`00
?g<003mc001VIVH00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm80101c
B`001@3gX@00IVIV07<d001c=00000000080mg00101c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0
085D0002085D0080mj401021>`080?M`00D0P@L0903f3P0308eL0080mj401@2=@00:0?M`00@0S@P0
903f3P020?NQ00H0V4D00P3gL00609PW0080mcl01@2H2@0S0?H>00H0XTT02`3gL0050:8902<0mPh0
102ZC@030?M`00H0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00H0/@X08@3f3P00102hD`00mg00
0?M`003gL0070;P_00@0mcl01P2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080
mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07P3f3P1B0?ooo`00?@3oool00`000000oooo
0?ooo`020?ooo`D000000P3oool4000000D0oooo00@000000?ooo`3oool0oooo0`000000103oool0
00000000000000020?ooo`D0JP3o303oool5000000X0oooo00H0I@3d01T0L`0I07<06@1c0080L`1V
IVH20080L`0300@0n@0057<001Ac008002ci0P00:g<2001Mn@80049c00H008oi001IL`00FG<0IVIV
001IL`00`?T3001`L`05003an000Lf0007=P001cH000n<l01000LdT01P00n9d007<b001c<P00Lc80
0?Q/06IVIP8007<K0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<000D0F?P003mc000oL`00IVIV
03mc000208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ
001VIVH0Lc@007<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080
PE@00P3gX@04084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000X0mg00102=200T0?H>0080
mj401P2HA@020?M`00H0V2L00P3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0
mg001P2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001P2a2P0Q0?H>0080^5<00`3gL0060;P_00@0
mcl01`2h2`0O0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080mg002032<P030?Lo00P0
`P/07P3f3P0<0?M`00P0a``07P3f3P1B0?ooo`00?@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool306X0oa00oooo1@0000060?ooo`80I@3d
0`0I07<01@1VIVH00P1c0080L`0207<0103i008001Ac0P00;?T2000[L`8005gi0P00@W<01P00SoT0
05Uc001IL`1VIVH005Uc0030n@<0071c00D00?7h001cH000Lf0007=P003hc`04001cB@06003hW@00
Lc8007<b001c<P00n6`0IVIV0P00La/2003h>`<007<40P00n0T3019c00809oP00`0YL`001P1Hn000
?g<003mc001VIVH0?g<008Wh00@0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP04
07=;000506IVIP1c=000Lc@007<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021
E000PE@00080PE@00P3gX@04084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000X0mg00102=
200T0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f
3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003g
L000mg000?M`00H0^2l0103g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01l0mPh0
0P3gL0080<8b00<0mcl020322`0N0?H>00`0mg002037300N0?H>0580oooo000k0?ooo`D000000`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0203o
ool206D0m0806@1c00<0=P3i06IVIP0207<00P0207<3000DL`8002ci0P00:g<2001Mn@80049c00<0
08oi001IL`1VIVH00P00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P00D00?S?001cB@00LdT0
07=9003hW@04001c<P0406IVIP00n6`007<K001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c
00809oP00`0YL`000`1Hn000?g<006IVIP0203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec
00030>_g001cHP00Lf800080Lf800P3gdP0407=;000506IVIP1c=000Lc@007<d000000000P3gL004
07<M0080mcl00`1c1P0V0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k00P0mg001@211`0T
0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`05
09P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P03
0;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`070;P;01l0mPh000<0
_EH00?M`003gL0002`3gL0070;d;01l0mPh00P3gL0080<8b00<0mcl020322`0N0?H>00`0mg002037
300N0?H>0580oooo001@0?ooo`<000007`3oool00`000000oooo0?ooo`080?ooo`<0I@3d0P0I07<0
0`1VIVH00P1c0080L`020080L`<001Ac0P00;?T2000[L`8005gi0P00@W<01@00SoT005Uc06IVIP00
FG<00<3i00@0071c00D00?7h001cH000Lf0007=P003hc`03001cB@03003hW@00Lc8007<b008007<b
00@0IVIV003hK000La/007<K0P00n3/3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000Y
L`000P0YL`000`1Hn000?g<006IVIP0203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec0003
0>_g001cHP00Lf800080Lf8000<0mm8007=;001cB`000P1cB`000`1VIVH0mj4007<d000207<d0003
0000003gL000mg0000@0Lad00P3g?`0307<602H0mPh000<0mm80085D0021E0000P21E0020?NQ00@0
PC/0203gL005084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802@0mPh00P3gX@0609Q50080
mg001@2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0060:X/00<0
mcl01P2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo
00L0^0/07`3f3P000`2mEP00mg000?M`000;0?M`00L0_@/07`3f3P020?M`00P0`S80103g?`070<8;
01h0mPh0303gL0080<L<01h0mPh0DP3oool00780oooo00<000000?ooo`3oool0203oool306D0m080
6@1c00<0IVIV0080L`0207<00P0207<3000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<01@00
SoT005Uc06IVIP00FG<00<3i00@0071c00D00?7h001cH000Lf0007=P003hc`03001cB@06003hW@00
Lc8007<b001c<P1VIVH00?Q/0`00La/2003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000
:G<002Uc000202Uc000305Sh001VIVH0?g<00080?g<000<0ROP005Mc001GL`000P1GL`020;[g00<0
KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/000<0IVIV0?NQ001c=0000P1c=0000`000000
mg000?M`000407<M0080mcl00`1c1P0U0?H>0080mm801021E0020?NQ00@0PC/0203gL005084702@0
mPh00`2=G0020?NQ00D0SD002@3gL00508d802@0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00D0
V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0Q0?H>00<0
/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo00L0^0/0803f3P0=0?M`
00L0_@/07`3f3P020?M`00P0`S80103g?`070<8;01h0mPh0303gL0080<L<01h0mPh0DP3oool000X0
oooo0`0000020?ooo`040000003oool0oooo0?ooo`<000001@3oool3000000050?ooo`0000000000
0000003oool00`0000020?ooo`<000000`3oool4000000<0oooo1P0000020?ooo`<0000000<0oooo
0000000000000P0000020?ooo`8000000P3oool3000000040?ooo`000000oooo0?ooo`<000001P3o
ool309d0oa<0oooo00<000000?ooo`3oool0203oool406D0m00301T0L`1VIVH0=P3i00<00P1c00D0
103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<01@00SoT0IVIV001IL`00FG<00<3i00@0
071c00D00?7h001cH000Lf0007=P003hc`03001cB@06003hW@00Lc8007<b001c<P1VIVH00?Q/0`00
La/2003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh001V
IVH0?g<003mc0080ROP0101GL`020;[g00<0KG<00P3[m`0407=R00050?OB001cB`00Ld/007=;001V
IVH00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<602D0mPh00P3gdP04085D0080
mj401021>`080?M`00D0P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P020?NQ00H0
V4D00P3gL00509PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00H0
ZR`00`3g?`060:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0060;P_
00@0mcl01`2h2`0P0?H>00d0mg00202m2`0N0?H>0080mg002032<P040?Lo00L0`P/07`3f3P0;0?M`
00P0a``07P3f3P1B0?ooo`002`3oool00`000000oooo0?ooo`0200000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`040000003o
ool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`D0W@3o
4P3oool00`000000oooo0?ooo`070?ooo`D0I@3d00<06@1c06IVIP0f0?T00`0207<01@040?T001Ac
000DL`0057<002ci00<002]c0P00GOT20012L`05002?n@1VIVH005Uc001IL`00`?T01000L7<01@00
lOP007=P001cH000Lf000?S?00<007=900H00?RM001c<P00Lc80IVIV001c<P00n6`3001c6`800?Pk
0`00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000@0IVIV03mc000oL`00
?g<00P29n00405Mc0080^_L00`1]L`020>_g00@0Lf8000D0mm8007=;001cB`00Ld/006IVIP020?NQ
00<0Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09@3f3P020?OB00@0PE@00P3gX@04084k
00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401P2HA@020?M`
00D0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo
00H0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`07
0;P;0200mPh03@3gL0080;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300M
0?H>0580oooo000;0?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000060?ooo`040000003oool0oooo0?ooo`L0W@3o4@3oool00`000000oooo0?ooo`0<0?oo
o`0301T0L`1VIVH0=P3i00<00P1c00D0103i000DL`0057<001Ac000/n@03000[L`05001Mn@00@W<0
049c0012L`1VIVH00`00FG<01@00`?T0071c001`L`00L7<00?7h00@007=P00D00?S?001cB@00LdT0
07=9003hW@02001c<P0306IVIP00Lc800?Q/00<007<K0P00n3/3001c1003003h2@0BL`004W<00080
4W<000<09oP002Uc000YL`000P0YL`00101VIVH0?g<003mc000oL`0208Wh00@0Eg<00P2jm`0306ec
0080joL0101cHP001@3gdP00Ld/007=;001VIVH0Ld/00080mj400`1c=0000`000000mg0007<M0004
07<M0080mcl00`1c1P0U0?H>0080mm801021E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T
0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`05
09P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P03
0;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3g
L0080;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300M0?H>0580oooo000;
0?ooo`050000003oool000000?ooo`0000000P3oool5000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo1@0000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool3000000@0oooo1`2M0?l@0?ooo`030000003oool0oooo
00d0oooo00<0IVIV01T0L`0f0?T00`0207<01@040?T001Ac000DL`0057<002ci00<002]c00D005gi
0012L`00@W<0049c06IVIP03001IL`050030n@00L7<0071c001`L`00lOP01000Lf002000n<l007=9
001cB@00LdT00?RM001c<P1VIVH007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400<00?P9
019c000BL`000P0BL`001P0Wn000:G<002Uc000YL`00IVIV05Sh00<0?g<00P29n00405Mc0080^_L0
0`1]L`020>_g00@0Lf8000D0mm8007=;001cB`00IVIV07=;00020?NQ00<0Lc@000<000000?M`001c
7@00101c7@020?Lo00<0L`H09@3f3P020?OB00@0PE@000<0mj40084k0021>`000`21>`080?M`00D0
P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P020?NQ00H0V4D00P3gL00509PW00<0
mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0240
mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>
00d0mg00202m2`0N0?H>00<0mg001`32<P040?Lo00L0`P/07`3f3P0<0?M`00P0a``07@3f3P1B0?oo
o`002`3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`040000003oool0oooo000000<0oooo00D0
00000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
0P0000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`3oool709d0oa00oooo00<000000?ooo`3oool0303oool0100I07<0IVIV01T0L`0f
0?T30080L`0300@0n@0057<001Ac008002ci0`00:g<01@00GOT0049c0012L`1VIVH008oi00<005Uc
00D00<3i001`L`00L7<0071c003an004001cH008003hc`00LdT007=9001cB@00n9d007<b06IVIP00
Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000602Oh000Y
L`00:G<002Uc001VIVH0F?P00`0oL`0208Wh00<0Eg<00`2jm`0306ec0080joL0101cHP000`3gdP00
Ld/006IVIP0207=;0080mj400P1c=0000`000000Lc@00?M`000507<M0080mcl00`1c1P0U0?H>0080
mm801021E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000T0
mg001@2=200T0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0
XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>0004
0;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03@3gL0080;d;01h0mPh00`3gL0070<8b
00@0mcl01`322`0O0?H>00`0mg002037300N0?H>0540oooo000;0?ooo`8000000P3oool010000000
oooo0?ooo`3oool3000000<0oooo1@0000020?ooo`040000003oool00000000000@0oooo0`000003
0?ooo`030000003oool0000000800000103oool00`000000oooo0?ooo`020?ooo`@000000P3oool0
0`000000oooo00000002000000@0oooo100000030?ooo`<000001@3oool509d0o``0oooo1@00000:
0?ooo`D0V@3i00@0IVIV01T0L`0I07<0=P3i0`0207<00`040?T001Ac000DL`02000/n@<002]c00D0
05gi0012L`00@W<0IVIV002?n@03001IL`050030n@00L7<0071c001`L`00lOP01000Lf04001cB@04
003hW@1VIVH007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1004003h2@0BL`004W<0
019c00809oP00`0YL`000`1VIVH0F?P003mc000203mc0080ROP00`1GL`030;[g00<0KG<00P3[m`04
07=R00030?OB001cB`00IVIV0080Ld/00P3gX@0207<d00030000001c=000mg0000D0Lad00P3g?`03
07<602D0mPh000<0mm80085D0021E0000`21E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T
0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`05
09P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f3P03
0;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh03P3g
L0070;d;01l0mPh00P3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300N0?H>0540oooo000;
0?ooo`8000000P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0`2M0?lA
0?ooo`@000001`3oool509T0n@0406IVIP0I07<06@1c03H0n@<00P1c00<0103i000DL`0057<00P00
;?T2000[L`8005gi00@0049c06IVIP00@W<008oi0`00FG<01@00`?T0071c001`L`00L7<00?7h00<0
07=P00<00?S?001cB@00LdT00P00LdT01000n9d0IVIV001c<P00Lc82003hK0<007<K00<00?Pk001c
1000L`@00P00L`@01000n0T04W<0019c000BL`0202Oh0080:G<000<0IVIV05Sh001Hn0000`0oL`02
08Wh00<0Eg<00`2jm`0306ec0080joL0101cHP000`3gdP00IVIV07=;000207=;0080mj400P1c=000
0`000000Lc@00?M`000507<M0080mcl00`1c1P0U0?H>00030?OB0021E000PE@000<0PE@000<0mj40
084k0021>`000`21>`080?M`00D0P@L0903f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P02
0?NQ00H0V4D000<0mg0009PW002H9`00102H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R
0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<0
0?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00L0`S80103g
?`070<8;01l0mPh0303gL0080<L<01h0mPh0D@3oool000X0oooo0P0000020?ooo`<000002@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0503oool2
000001h0oooo00<000000?ooo`3oool0203oool00`1707<0V@3i09T0n@0209T0n@0406IVIP0I07<0
6@1c01T0L`@00P1c00<0103i000DL`0057<00P00;?T2000[L`8005gi00@0049c06IVIP00@W<008oi
0`00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P00<00?S?001cB@00LdT00P00LdT0101VIVH0
07<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@01000n0T04W<0019c000BL`02
02Oh0080:G<000<0IVIV05Sh001Hn0000`0oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00
Lf800080Lf800P3gdP001@1VIVH0Ld/007=;001cB`00mj4000<0Lc@000<0000007<d003gL0001@1c
7@000`3g?`00L`H007<6000207<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203g
L005084702@0mPh00`2=G0020?NQ00D0SD002@3gL00508d802@0mPh00P3gX@0609Q500030?M`002H
9`00V2L000@0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z
;0030?Lo00H0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l0
0`3g?`070;P;0200mPh03P3gL0070;d;01l0mPh00P3gL0080<8b00<0mcl020322`0N0?H>00`0mg00
2037300N0?H>0540oooo000O0?ooo`800000503oool3000001D0oooo0P0000000`3oool000000?oo
o`0L0?ooo`030000003oool0oooo00P0oooo00<0A`1c09T0n@2I0?T00P2I0?T0101VIVH06@1c01T0
L`0I07<40080L`0300@0n@0057<001Ac008002ci0P00:g<2001Mn@0306IVIP00@W<008oi00@005Uc
00D00<3i001`L`00L7<0071c003an003001cH003003hc`00LdT007=9008007=900@0IVIV001c<P00
Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400@00?P9019c000BL`004W<00P0Wn000
0`0YL`00IVIV02Uc000205Sh00<0?g<00P29n00305Mc0080^_L0101]L`000`3[m`00Lf8007=R0002
07=R00030?OB001VIVH0Ld/000<0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g
?`0407<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203gL005084702@0mPh00`2=
G0020?NQ00D0SD002@3gL00508d802@0mPh00P3gX@0609Q500030?M`002H9`00V2L000@0V2L00`3g
?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001P2Z;0030?Lo00H0ZPX08@3f
3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh0
3P3gL0070;d;01l0mPh00P3gL0080<8b00<0mcl020322`0N0?H>00`0mg002037300N0?H>0540oooo
001@0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool01`3oool204L0L`<0V@3i00<0
IVIV09T0n@0I07<00P0I07<40080L`0300@0n@0057<001Ac008002ci0P00:g<2001Mn@0306IVIP00
@W<008oi00@005Uc00D00<3i001`L`00L7<0071c003an003001cH003003hc`00LdT007=9008007=9
00@0IVIV001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400@00?P9019c000B
L`004W<00P0Wn000100YL`00IVIV02Uc001Hn00403mc0080ROP00`1GL`020;[g00@0KG<000<0joL0
07=R001cHP000P1cHP000`3gdP00IVIV07=;000307=;00050?NQ001c=000Lc@007<d000000000P3g
L00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00P0mg001021
1`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401P2HA@000`3gL000V2L009PW
000409PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00H0ZR`00`3g
?`060:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0P0?H>00h0mg001`2m2`0O0?H>0080mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``0
7P3f3P1A0?ooo`00:P3oool300000080oooo00@000000?ooo`3oool0oooo0`0000030?ooo`@00000
103oool00`000000oooo000000040?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`040?ooo`<0c`3o4`3oool00`000000oooo0?ooo`080?ooo`80A`1c0`2I0?T01@1VIVH0V@3i
01T0L`0I07<0=P3i00@00P1c0`0057<2000/n@8002]c0P00GOT00`1VIVH0049c002?n@04001IL`05
0030n@00L7<0071c001`L`00lOP00`00Lf001P00n<l007=9001cB@00LdT0IVIV003hW@<007<b0P00
n6`2001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn000101VIVH0:G<002Uc001Hn00403mc0080ROP0
0`1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP000`1VIVH0mm8007=;000307=;00050?NQ
001c=000Lc@007<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080
PE@00P3gX@05084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080
mj401P2HA@000`3gL000V2L009PW000409PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280
mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00
mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>
0080mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07P3f3P1A0?ooo`00:`3oool00`000000
oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo0`000004
0?ooo`D0c`3o4P3oool00`000000oooo0?ooo`070?ooo`<0A`1c0`2I0?T01@1VIVH0V@3i01T0L`0I
07<0=P3i00@00P1c0`0057<2000/n@8002]c00D005gi06IVIP00@W<0049c002?n@04001IL`050030
n@00L7<0071c001`L`00lOP00`00Lf001P00n<l007=9001cB@00LdT0IVIV003hW@<007<b0P00n6`2
001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn000101VIVH0:G<002Uc001Hn00403mc0080ROP00`1G
L`020;[g00@0KG<000<0joL007=R001cHP000P1cHP000`1VIVH0mm8007=;000307=;00050?NQ001c
=000Lc@007<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@0
0P3gX@05084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj40
1P2HA@000`3gL000V2L009PW000409PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0
102ZC@030?M`00H0ZR`00`3g?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg00
0?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080
mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07P3f3P1A0?ooo`00:`3oool00`000000oooo
0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo000000030?ooo`L0c`3o403oool00`000000oooo0?ooo`080?ooo`<0A`1c0P2I0?T0
0`1VIVH0V@3i09T0n@0201T0L`0303H0n@0207<00P1c00800P1c0`0057<01P00;?T002]c000[L`00
:g<005gi06IVIP80049c00D008oi001IL`00FG<005Uc0030n@04001`L`05003an000Lf0007=P001c
H000n<l00P00LdT00`1VIVH00?RM001c<P03001c<P800?Q/0P00La/2003h>`<007<400<00?P9019c
000BL`000P0BL`000`0Wn000IVIV02Uc000202Uc000305Sh000oL`00?g<00080?g<00P29n00305Mc
0080^_L0101]L`001@3[m`00Lf8007=R001cHP00IVIV0080mm80101cB`001@3gX@00Lc@007<d001c
=00000000080mg00101c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401@21
>`080?M`00@0P@L09@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P020?NQ00D0V4D00P3g
L00609PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00H0ZR`00`3g
?`070:X:0200mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>0080mg002032<P040?Lo00L0`P/0
7`3f3P0;0?M`00T0a``07@3f3P1A0?ooo`00:`3oool01@000000oooo0000003oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`00
0000oooo000000030?ooo`@000000P3oool01@000000oooo0?ooo`3oool000000080oooo1`3?0?l@
0?ooo`030000003oool0oooo00P0oooo0`1707<209T0n@0306IVIP2I0?T0V@3i00806@1c00D0=P3i
0080L`0207<00P1c00@0n@03000DL`06000/n@00:g<002]c000[L`1VIVH005gi0P00@W<01@00SoT0
05Uc001IL`00FG<00<3i00@0071c00D00?7h001cH000Lf0007=P003hc`02001cB@0306IVIP00n9d0
07<b00<007<b0P00n6`2001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c000302Oh001VIVH0
:G<00080:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`00
1@3[m`00Lf8007=R001cHP00IVIV0080mm80101cB`001@3gX@00Lc@007<d001c=00000000080mg00
101c7@020?Lo00@0L`H09@3f3P000`3gdP00PE@0085D0002085D0080mj401@21>`080?M`00@0P@L0
9@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P020?NQ00D0V4D00P3gL00609PW00<0mcl0
1@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00H0ZR`00`3g?`070:X:0200mPh0
0`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01P2h2`0P0?H>0003
0;eF003gL000mg0000/0mg001`2m2`0O0?H>0080mg002032<P040?Lo00L0`P/07`3f3P0<0?M`00P0
a``07@3f3P1A0?ooo`00:`3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000006
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01`3?0?l?0?ooo`030000003o
ool0oooo00T0oooo0`1707<00`2I0?T0IVIV09T0n@0209T0n@806@1c00D0=P3i0080L`0207<00P1c
00@0n@03000DL`06000/n@00:g<002]c000[L`1VIVH005gi0P00@W<01@00SoT005Uc001IL`00FG<0
0<3i00@0071c00T00?7h001cH000Lf0007=P003hc`00LdT0IVIV001cB@00n9d01000Lc801000n6`0
07<K001c6`00La/2003h>`<007<400<00?P9019c000BL`000P0BL`000`1VIVH0:G<002Uc000202Uc
000305Sh000oL`00?g<00080?g<000<0ROP005Mc001GL`000P1GL`020;[g00@0KG<000D0joL007=R
001cHP00IVIV07=R00020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g
?`0407<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004084702D0mPh00`2=
G0020?NQ00D0SD002@3gL00508d802@0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T08`3f
3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0P0?H>00<0/E00303g
L0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00H0^0/0803f3P000`2mEP00mg00
0?M`000;0?M`00L0_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0mPh0303gL0080<L<01h0mPh0
D03oool002/0oooo0P0000020?ooo`040000003oool0oooo0?ooo`<000000`3oool00`000000oooo
00000002000000050?ooo`00000000000000003oool00`0000000`3oool000000000000200000080
oooo0`000000103oool000000000000000020?ooo`D0c`3o303oool5000000X0oooo00H0bP3i04L0
L`1707<0A`1c09T0n@1VIVH309T0n@806@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/
n@00:g<002]c06IVIP8005gi0P00@W<01@00SoT005Uc001IL`00FG<00<3i00@0071c00T00?7h001c
H000Lf0007=P003hc`00LdT0IVIV001cB@00n9d01000Lc801000n6`007<K001c6`00La/2003h>`<0
07<400<00?P9019c000BL`000P0BL`000`1VIVH0:G<002Uc000202Uc000305Sh000oL`00?g<00080
?g<000<0ROP005Mc001GL`000P1GL`020;[g00@0KG<000H0joL007=R001cHP00IVIV07=R003gdP05
07=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M0080mcl0101c1P0U0?H>00030?OB0021
E000PE@00080PE@00P3gX@05084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=
200T0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f
3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX0803f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003g
L000mg000?M`00L0^2l0103g?`070;P;01l0mPh000<0_EH00?M`003gL0002`3gL0070;d;01l0mPh0
0`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037300N0?H>0500oooo000[0?ooo`8000000P3o
ool00`000000oooo0?ooo`0U0?ooo`<0c`3o4@3oool4000000L0oooo00D0bP3i04L0L`1707<0A`1c
06IVIP0409T0n@806@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`05000/n@00:g<002]c06IV
IP00GOT00`00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c00<00?7h001cH000Lf000P00Lf00
1@00n<l0IVIV001cB@00LdT00?RM00@007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1006003h
2@0BL`004W<0019c001VIVH09oP0100YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<0
0080Eg<00P2jm`0306ec0080joL000D0Lf8006IVIP1cHP00Lf800?OB000407=;0080mj400`1c=000
0`000000mg000?M`000407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05
084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>0080mj401@2HA@02
0?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001`2Z;002
0?Lo00L0ZPX0803f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l0103g
?`070;P;0200mPh03@3gL0080;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037
300N0?H>0500oooo000Z0?ooo`8000000P3oool3000003T0oooo00<000000?ooo`3oool0203oool0
1P1M07<0bP3i04L0L`1707<0V@3i06IVIP<0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i0080
01Ac0P00;?T01000:g<0IVIV000[L`00GOT30012L`05002?n@00FG<005Uc001IL`00`?T00`00L7<0
0`00lOP007=P001cH002001cH005003hc`1VIVH007=9001cB@00n9d01000Lc801000n6`007<K001c
6`00La/2003h>`<007<400H00?P9019c000BL`004W<006IVIP0Wn00402Uc000405Sh000oL`00?g<0
03mc0080ROP0101GL`020;[g00<0KG<00P3[m`001@1cHP00IVIV07=R001cHP00mm8000@0Ld/00P3g
X@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<602H0mPh000<0mm80085D0021E0000P21
E0020?NQ00D0PC/01`3gL005084702D0mPh00P2=G0030?NQ00D0SD002@3gL00508d802@0mPh00P3g
X@0509Q50080mg001P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3g
L0070:X/0080mcl01`2Z2P0P0?H>00<0/E003@3gL0060;4:0240mPh00P2hD`030?M`00H0^2l0103g
?`070;P;0200mPh03@3gL0080;d;01h0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037
300N0?H>0500oooo001Z0?ooo`030000003oool0oooo00P0oooo00H0G@1c0<X0n@1707<0A`1c09T0
n@1VIVH309T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@02000DL`8002ci00@002]c06IVIP00
:g<005gi0`00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c00<00?7h001cH000Lf000P00Lf00
1@1VIVH007=9001cB@00LdT00?RM00<007<b0P00n6`3001c6`800?Pk0`00L`@01P00n0T04W<0019c
001VIVH04W<002Oh00@0:G<000@0F?P003mc000oL`00?g<00P29n00405Mc0080^_L00`1]L`020>_g
000506IVIP1cHP00Lf8007=R003gdP00101cB`020?NQ00<0Lc@000<000000?M`003gL000101c7@02
0?Lo00<0L`H09P3f3P000`3gdP00PE@0085D0002085D0080mj401@21>`070?M`00D0P@L09@3f3P02
08eL00<0mj401@2=@0090?M`00D0S@P0903f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0S
0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0200mPh00`2aD00=
0?M`00H0/@X08@3f3P020;QC00<0mg001P2h;`040?Lo00L0^0/0803f3P0=0?M`00P0_@/07P3f3P03
0?M`00L0`S80103g?`070<8;01l0mPh0303gL0080<L<01h0mPh0D03oool006T0oooo00<000000?oo
o`3oool0203oool205d0L`040<X0n@1707<0A`1c06IVIP@0V@3i0`0I07<01@0f0?T00P1c0080L`02
07<0103i008001Ac0P00;?T01000:g<0IVIV000[L`00GOT30012L`05002?n@00FG<005Uc001IL`00
`?T00`00L7<00`00lOP007=P001cH002001cH00506IVIP00LdT007=9001cB@00n9d00`00Lc82003h
K0<007<K00<00?Pk001c1000L`@00P00L`@01P00n0T04W<0019c001VIVH04W<002Oh00@0:G<000@0
F?P003mc000oL`00?g<00P29n00405Mc0080^_L00`1]L`020>_g000506IVIP1cHP00Lf8007=R003g
dP00101cB`020?NQ00<0Lc@000<000000?M`003gL000101c7@020?Lo00<0L`H09P3f3P000`3gdP00
PE@0085D0002085D0080mj401021>`080?M`00D0P@L09@3f3P0208eL00<0mj401@2=@0090?M`00D0
S@P0903f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280
mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0240mPh00P2aD00=0?M`00H0/@X08P3f3P00102hD`00
mg000?M`003gL0060;P_00@0mcl01`2h2`0P0?H>00d0mg00202m2`0O0?H>0080mg001`32<P040?Lo
00L0`P/07`3f3P0<0?M`00P0a``07P3f3P1@0?ooo`000`3oool4000000@0oooo00<000000?ooo`00
00000`3oool5000000@0oooo0`0000020?ooo`D000000`3oool3000000<0oooo100000030?ooo`H0
00000P3oool3000000030?ooo`0000000000008000000P3oool200000080oooo0`0000000`3oool0
00000?ooo`030?ooo`<0o`3m4`3oool00`000000oooo0?ooo`080?ooo`80G@1c00@0bP3i04L0L`17
07<0IVIV102I0?T301T0L`@00P1c00<0103i000DL`0057<00P00;?T0101VIVH002]c001Mn@00GOT3
0012L`05002?n@00FG<005Uc001IL`00`?T00`00L7<01@00lOP007=P001cH000Lf00IVIV00@007=9
00@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400<00?P9019c001V
IVH00P0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP0101GL`020;[g
00<0KG<000<0joL006IVIP1cHP000`1cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`00
0000mg0007<M000407<M0080mcl00`1c1P0V0?H>00030?OB0021E000PE@00080PE@00P3gX@04084k
00P0mg001@211`0U0?H>0080SE`00`3gX@0508e000T0mg001@2=200T0?H>0080mj401@2HA@020?M`
00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001`2Z;0020?Lo
00L0ZPX08@3f3P030;5@00`0mg001P2a2P0R0?H>00040;QC003gL000mg000?M`00H0^2l0103g?`07
0;P;0200mPh03@3gL0080;d;01l0mPh00P3gL0070<8b00@0mcl020322`0N0?H>00`0mg002037300N
0?H>0500oooo00030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo00000005
0?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`000000103oool50?l0oA40oooo00<000000?ooo`3oool0
203oool305d0L`030<X0n@1707<0IVIV00D0V@3i0`0I07<40080L`0300@0n@0057<001Ac008002ci
00@0IVIV000[L`00GOT005gi0`00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c00D00?7h001c
H000Lf0007=P06IVIP04001cB@04003hW@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c
1002001c1004003h2@0BL`00IVIV019c00809oP00`0YL`0205Sh00<0?g<00P29n00305Mc00<0^_L0
0`1]L`000`3[m`00IVIV07=R000307=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000
003gL000Lad000@0Lad00P3g?`0307<602D0mPh00P3gdP04085D0080mj401021>`080?M`00D0P@L0
9@3f3P0208eL00<0mj401@2=@0090?M`00D0S@P0903f3P020?NQ00D0V4D00P3gL00609PW00<0mcl0
1@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0240mPh0
0`2aD00<0?M`00H0/@X08P3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01`2h2`0P0?H>00d0
mg00202m2`0O0?H>0080mg002032<P030?Lo00P0`P/07P3f3P0<0?M`00P0a``07P3f3P1@0?ooo`00
1`3oool020000000oooo0?ooo`000000oooo0000003oool00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool70?l0oA00oooo00<000000?ooo`3oool0203oool305d0L`030<X0n@1707<0IVIV00D0
V@3i0`0I07<40080L`0500@0n@0057<001Ac000/n@1VIVH00P00:g<2001Mn@80049c00<008oi001I
L`00FG<00P00FG<01@00`?T0071c001`L`00L7<00?7h008007=P00<0IVIV003hc`00LdT00`00LdT0
1000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@01000n0T0IVIV019c
000BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`030;[g00<0KG<000<0IVIV0>_g001cHP00
0`1cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`000000Lc@00?M`000507<M0080mcl0
0`1c1P0U0?H>0080mm801021E0020?NQ00@0PC/0203gL005084702D0mPh00P2=G0030?NQ00D0SD00
2@3gL00508d802@0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg00
1P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0060;4:0280mPh0
00@0^5<00?M`003gL000mg001P2h;`040?Lo00L0^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00P0
`S800`3g?`080<8;01h0mPh0303gL0080<L<01h0mPh0D03oool000D0oooo0`0000020?ooo`050000
003oool000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00P3oool5000000<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`L0o`3m403oool00`000000oooo0?ooo`080?ooo`<0G@1c00<0bP3i
06IVIP1707<01@2I0?T201T0L`0303H0n@0207<00P1c00800P1c0`0057<01000;?T0IVIV000[L`00
:g<2001Mn@80049c00<008oi001IL`00FG<00P00FG<01@00`?T0071c001`L`00L7<00?7h008007=P
00<0IVIV003hc`00LdT00`00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000
L`@00P00L`@01000n0T0IVIV019c000BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`030;[g
00<0KG<000<0IVIV0>_g001cHP000`1cHP000`3gdP00Ld/007=;000207=;0080mj400P1c=0000`00
0000Lc@00?M`000507<M0080mcl00`1c1P0U0?H>0080mm801021E0020?NQ00@0PC/0203gL0050847
02D0mPh00P2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0509Q50080mg001P2H9`030?Lo
00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0Q0?H>
00<0/E00303gL0060;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0>
0?M`00L0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01h0mPh0303gL0080<L<01h0mPh0D03oool0
00<0oooo0`0000040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo008000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0?oo
o`L0o`3m3`3oool00`000000oooo0?ooo`090?ooo`<0G@1c00<0A`1c06IVIP1707<01@2I0?T201T0
L`0303H0n@0207<00P1c00800P1c0`0057<0101VIVH002ci000[L`00:g<2001Mn@80049c00<008oi
001IL`00FG<00P00FG<01@00`?T0071c001`L`00L7<00?7h008007=P00<0IVIV003hc`00LdT00`00
LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@0101VIVH04W<0
019c000BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`020;[g00<0KG<000<0IVIV0>_g001c
HP000`1cHP020?OB00@0Ld/000@0mj4007<d001c=000Lc@00`00000507<M0080mcl00`1c1P0U0?H>
0080mm801021E0020?NQ00@0PC/0203gL005084702D0mPh00P2=G0030?NQ00@0SD002P3gL00508d8
02@0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>
00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`
003gL000mg001`2h;`030?Lo00L0^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00P0`S800`3g?`08
0<8;01l0mPh02`3gL0090<L<01h0mPh0C`3oool000<0oooo00<000000?ooo`3oool00`3oool30000
00050?ooo`00000000000000003oool00`0000040?ooo`D000000P3oool5000000<0oooo0`000003
0?ooo`030000003oool0000000800000103oool00`000000oooo0?ooo`020?ooo`@000000P3oool0
0`000000oooo00000002000000@0oooo100000040?ooo`D0o`3m303oool5000000T0oooo0P3i0?L3
05d0L`0306IVIP1707<0A`1c00D0V@3i0P0I07<00`0f0?T00P1c0080L`020080L`<001Ac00@0IVIV
000[L`00:g<002]c0P00GOT20012L`03002?n@00FG<005Uc008005Uc00T00<3i001`L`00L7<0071c
003an000Lf00IVIV001cH000n<l01000LdT01000n9d007<b001c<P00Lc82003hK08007<K0P00n3/3
001c1003003h2@1VIVH04W<000804W<00P0Wn00302Uc000305Sh000oL`00?g<00080?g<00P29n003
05Mc0080^_L00`1]L`000`1VIVH0joL007=R000307=R0080mm80101cB`001`3gX@00Lc@007<d001c
=000000007<d003gL0000P00000307<M0080mcl00`1c1P0U0?H>0080mm801021E0020?NQ00@0PC/0
203gL005084702D0mPh00P2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0509Q50080mg00
1P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl0
1`2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0
^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303gL0080<L<01h0
mPh0C`3oool000<0oooo00D000000?ooo`3oool0oooo0000000A0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`030?ooo`<0o`3m403oool5000000H0
oooo0P3i0?L305d0L`0306IVIP1707<0A`1c00D0V@3i0P0I07<01@0f0?T00P1c0080L`0207<0103i
008001Ac00<0IVIV000/n@00:g<00P00:g<2001Mn@80049c00@008oi001IL`00FG<005Uc0P00`?T3
001`L`05003an000Lf00IVIV001cH000n<l00`00LdT2003hW@<007<b0P00n6`2001c6`800?Pk0`00
L`@00`1VIVH00?P9019c0002019c00809oP00`0YL`000`1Hn000?g<003mc000203mc0080ROP00`1G
L`020;[g0080KG<000<0IVIV06ec003[m`00101cHP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0
000000020?M`00D0Lad000<0mcl007<6001c1P000P1c1P0U0?H>0080mm801021E0020?NQ00@0PC/0
203gL005084702D0mPh00P2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0509Q50080mg00
1P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl0
1`2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0
^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0mPh0303gL0080<L<01h0
mPh0C`3oool000@0oooo1000000A0?ooo`030000003oool0oooo01X0oooo0`00000D0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool01`3oool00`1c0780n@3g0?T0m`0205d0L`040<X0
n@1VIVH0A`1c04L0L`D0V@3i0P0I07<01@0f0?T00P1c0080L`0207<0103i008001Ac00<0IVIV000/
n@00:g<00P00:g<2001Mn@80049c00D008oi001IL`00FG<005Uc0030n@04001`L`05003an01VIVH0
07=P001cH000n<l00`00LdT00`00n9d007<b001c<P02001c<P800?Q/0P00La/2003h>`<007<400<0
IVIV003h2@0BL`000P0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00P2j
m`0206ec000306IVIP1]L`00joL000@0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d00000000
0P3gL00407<M0080mcl0101c1P0U0?H>0080mm801021E0020?NQ00@0PC/0203gL005084702@0mPh0
0`2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T0
8`3f3P060:9900/0mg001P2R2@0R0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00
303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/0803f3P0>0?M`00L0
_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0mPh0303gL0080<L<01h0mPh0C`3oool001<0oooo
00<000000?ooo`3oool07P3oool4000001@0oooo0P00000G0?ooo`030000003oool0oooo00P0oooo
00<0L`1b0?T0m`3i0?L00P1M07<0101VIVH0A`1c04L0L`1707<509T0n@806@1c00T0=P3i0080L`02
07<00P1c00@0n@0057<0IVIV000DL`00;?T00`00:g<2001Mn@80049c00D008oi001IL`00FG<005Uc
0030n@04001`L`05003an01VIVH007=P001cH000n<l00`00LdT00`00n9d007<b001c<P02001c<P04
003hK000La/007<K001c6`800?Pk0`00L`@00`1VIVH04W<0019c0002019c00809oP00`0YL`000`1H
n000?g<003mc000203mc0080ROP00`1GL`020;[g000506ec001VIVH0KG<006ec003[m`00101cHP02
0?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`0407<602D0mPh000<0
mm80085D0021E0000`21E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T0?H>00<0SE`00`3g
X@0408e000X0mg001@2=200T0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`0509P902<0mPh01P2R
B@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a
2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh000<0_EH00?M`003gL000
2`3gL0070;d;01l0mPh00P3gL0080<8b00@0mcl01`322`0O0?H>00`0mg002037300N0?H>04l0oooo
000g0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool01`3oool207<0LP80n@3g0P1M
07<0101VIVH0A`1c04L0L`1707<509T0n@806@1c00T0=P3i0080L`0207<00P1c00@0n@0057<0IVIV
000DL`00;?T00`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc00<00<3i001`L`00L7<00P00
L7<01@1VIVH007=P001cH000Lf000?S?00<007=900<00?RM001c<P00Lc800P00Lc801000n6`007<K
001c6`00La/2003h>`8007<400<0IVIV003h2@0BL`000`0BL`000`0Wn000:G<002Uc000202Uc0003
05Sh000oL`00?g<00080?g<000<0ROP005Mc001GL`000P1GL`020;[g000506ec001VIVH0KG<006ec
003[m`00101cHP020?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00@0Lad00P3g?`04
07<602D0mPh000<0mm80085D0021E0000`21E0000`3gX@00PC/0084k0003084k00P0mg001@211`0T
0?H>00<0SE`00`3gX@0408e000X0mg001@2=200T0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`05
09P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P03
0;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0200mPh000<0
_EH00?M`003gL0002`3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002037
300N0?H>04l0oooo000Z0?ooo`8000001@3oool3000000030?ooo`000000oooo00@00000103oool3
000000030?ooo`0000000000008000000P3oool2000000<0oooo0`3o0<XD0?ooo`030000003oool0
oooo00L0oooo0P1c07820?T0m`0305d0L`1VIVH0bP3i0080A`1c1@2I0?T301T0L`0903H0n@0207<0
0P1c0080L`040?T001Ac06IVIP0057<002ci00<002]c00D005gi0012L`00@W<0049c002?n@03001I
L`060030n@00L7<0071c001`L`00lOP0IVIV0`00Lf001@00n<l007=9001cB@00LdT00?RM00@007<b
00@00?Q/001c6`00La/007<K0P00n3/2001c100306IVIP00n0T04W<000<04W<000<09oP002Uc000Y
L`000P0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`001@1VIVH0
KG<006ec001]L`00joL000@0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL004
07<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@000<0PE@000<0mj40084k0021>`000`21>`08
0?M`00D0P@L0903f3P0308eL00<0mj40102=@00:0?M`00D0S@P0903f3P020?NQ00D0V4D00P3gL006
09PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00L0ZR`00P3g?`07
0:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h
2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00L0`P/07`3f
3P0<0?M`00P0a``07P3f3P1?0?ooo`00:@3oool010000000oooo0?ooo`0000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool50?l0bQ80oooo00<00000
0?ooo`3oool01`3oool307<0LP80n@3g00<0G@1c06IVIP3:0?T00P1707<509T0n@<06@1c00L0=P3i
0080L`0207<00P1c00@0n@1VIVH001Ac008002ci0`00:g<01@00GOT0049c0012L`00@W<008oi00<0
05Uc00D00<3i001`L`00L7<0071c06IVIP04001cH005003hc`00LdT007=9001cB@00n9d01000Lc80
1000n6`007<K001c6`00La/2003h>`04001c101VIVH007<4003h2@@04W<000<09oP002Uc000YL`00
0P0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`001@1VIVH0KG<0
06ec001]L`00joL000@0Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3gL00407<M
0080mcl0101c1P0U0?H>00030?OB0021E000PE@000<0PE@000<0mj40084k0021>`000`21>`080?M`
00D0P@L0903f3P0308eL00<0mj40102=@00:0?M`00D0S@P0903f3P020?NQ00D0V4D00P3gL00609PW
00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:890280mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:
0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P
0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00L0`P/07`3f3P0<
0?M`00P0a``07P3f3P1?0?ooo`00:@3oool010000000oooo0?ooo`0000030?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0bQ40oooo00<000000?oo
o`3oool01`3oool307<0LP80n@3g00<0IVIV05d0L`3:0?T00P1707<509T0n@<06@1c00L0=P3i0080
L`0207<00P1c00@0n@1VIVH001Ac008002ci0`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc
00D00<3i001`L`00L7<0071c06IVIP04001cH005003hc`00LdT007=9001cB@00n9d01000Lc801000
n6`007<K001c6`00La/2003h>`04001c101VIVH007<4003h2@@04W<000<09oP002Uc000YL`000P0Y
L`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<000<0^_L006IVIP1]L`000`1]
L`000`3[m`00Lf8007=R000207=R00030?OB001cB`00Ld/000<0Ld/000D0mj4007<d001c=000Lc@0
000000020?M`00@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021E0000`21E0000`3gX@00PC/0
084k0003084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>0080mj40
1@2HA@020?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08P3f3P040:Y=00<0mg00
1`2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0
^2l00`3g?`070;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01h0mPh00`3gL0070<8b00@0
mcl01`322`0O0?H>00`0mg002037300N0?H>04l0oooo000/0?ooo`030000003oool0oooo0080oooo
100000020?ooo`050000003oool0oooo0?ooo`0000000`3oool400000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`L0o`3:403oool00`000000oooo0?ooo`080?ooo`<0L`1b0P3i0?L00`1V
IVH0G@1c0<X0n@0204L0L`D0V@3i0`0I07<40080L`0306IVIP0057<001Ac008002ci0P00:g<2001M
n@<0049c00D008oi001IL`00FG<005Uc0030n@02001`L`0306IVIP00lOP007=P00<007=P00D00?S?
001cB@00LdT007=9003hW@04001c<P04003hK000La/007<K001c6`800?Pk00@0IVIV001c1000L`@0
0?P9100BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP0101GL`000`2j
m`00IVIV06ec000206ec0080joL0101cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`00
0000mg000?M`000407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k
00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>0080mj401@2HA@020?M`
00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P030:Y=00<0mg001`2Z;0020?Lo
00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`07
0;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh00P3gL0070<8b00@0mcl020322`0N
0?H>00`0mg002037300N0?H>04l0oooo000/0?ooo`030000003oool0oooo00D0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo008000000P3oool0
0`000000oooo0?ooo`070?l0bQ00oooo00<000000?ooo`3oool0203oool307<0LP050?T0m`1VIVH0
G@1c05d0L`3:0?T00P1707<509T0n@<06@1c100207<00`1VIVH001Ac000DL`02000/n@8002]c0P00
GOT30012L`05002?n@00FG<005Uc001IL`00`?T00P00L7<00`1VIVH00?7h001cH002001cH003003h
c`00LdT007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@0IVIV0080
07<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc
0080ROP0101GL`000`1VIVH0^_L006ec000206ec0080joL0101cHP000`3gdP00Ld/007=;000207=;
0080mj400`1c=0000`000000mg000?M`000407<M0080mcl0101c1P0U0?H>00030?OB0021E000PE@0
0080PE@00P3gX@05084k00P0mg001@211`0T0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>
0080mj401@2HA@020?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P030:Y=
00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg00
0?M`00L0^2l0103g?`060;P;0240mPh03@3gL0080;d;01l0mPh00P3gL0070<8b00@0mcl020322`0N
0?H>00`0mg002037300N0?H>04l0oooo000/0?ooo`040000003oool0oooo0?ooo`@000000P3oool0
0`000000oooo00000002000000<0oooo100000020?ooo`030000003oool0000000800000103oool5
0?l0bPd0oooo1000000:0?ooo`060?T0a@1c0780L`1b07<0LP3i0?L0IVIV0P1M07<00`3:0?T0A`1c
04L0L`0509T0n@<06@1c0`0207<0101VIVH0103i000DL`0057<2000/n@8002]c0P00GOT20012L`80
08oi0`00FG<01@00`?T0071c06IVIP00L7<00?7h00<007=P00<00?S?001cB@00LdT00P00LdT01000
n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk06IVIP00L`@00P00L`@00`00n0T04W<0019c0002
019c000302Oh000YL`00:G<00080:G<000@0F?P003mc000oL`00?g<00P29n00405Mc000306IVIP2j
m`00KG<00080KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003g
L000mg0000@0Lad00P3g?`0407<602D0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203g
L005084702@0mPh00`2=G0020?NQ00D0SD002P3gL00408d802D0mPh00P3gX@0509Q50080mg001P2H
9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00<0ZTd00`3gL0070:X/0080mcl01`2Z
2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00H0^0/0
8@3f3P0=0?M`00P0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01h0mPh0303gL0090<L<01h0mPh0
CP3oool002`0oooo00<000000?ooo`3oool07`3oool30?l0bQ40oooo1@0000060?ooo`060?T0a@1c
0780L`1b07<0LP3i0?L0IVIV0P1M07<00`3:0?T0A`1c04L0L`0509T0n@806@1c00H0=P3i0080L`02
07<00P1c06IVIP040?T2000DL`8002ci0P00:g<2001Mn@80049c00<008oi001IL`00FG<00P00FG<0
1@00`?T0071c06IVIP00L7<00?7h00<007=P00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c
<P00Lc82003hK0<007<K00<00?Pk06IVIP00L`@00P00L`@01000n0T04W<0019c000BL`0202Oh00<0
:G<00P1Hn00303mc0080ROP00`1GL`000`1VIVH0^_L00;[g000306ec0080joL0101cHP000`3gdP00
Ld/007=;000207=;0080mj400`1c=0000`000000mg000?M`000407<M0080mcl00`1c1P0V0?H>0003
0?OB0021E000PE@00080PE@00P3gX@05084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000X0
mg00102=200U0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0
XPT08`3f3P040:Y=0080mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>0004
0;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh03@3gL0080;d;01l0mPh00P3gL0080<8b
00<0mcl020322`0O0?H>00/0mg002@37300N0?H>04h0oooo000Z0?ooo`@00000=03oool00`000000
oooo0?ooo`070?ooo`0607<0F`3i0<D0L`1b07<0LP3i0?L0IVIV0`1M07<304L0L`D0V@3i0P0I07<0
1@0f0?T00P1c0080L`1VIVH00P1c00<001Ac0P00;?T2000[L`8005gi0P00@W<00`00SoT005Uc001I
L`02001IL`050030n@1VIVH0071c001`L`00lOP00`00Lf000`00n<l007=9001cB@02001cB@04003h
W@00Lc8007<b001c<P800?Q/0`00La/00`1VIVH007<4001c1002001c1004003h2@0BL`004W<0019c
00809oP00`0YL`0205Sh00<0?g<00P29n00305Mc000306IVIP2jm`00^_L000<0KG<00P3[m`0407=R
00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad00P3g?`0307<6
00H0j`h0803f3P000`3gdP00PE@0085D0002085D0080mj401@21>`080?M`00@0P@L09@3f3P0308eL
0080mj401@2=@00:0?M`00@0S@P09@3f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0S0?H>
00H0XTT02`3gL0060:8902<0mPh0102ZC@020?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`
00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0P0?H>00d0mg00202m2`0O
0?H>0080mg002032<P030?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1>0?ooo`00H@3oool00`00
0000oooo0?ooo`080?ooo`0607<0F`3i0<D0L`1b07<0LP3i0?L0IVIV0`1M07<304L0L`D0V@3i0P0I
07<01@0f0?T00P1c0080L`1VIVH00P1c00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`03
002?n@00FG<005Uc008005Uc00D00<3i06IVIP00L7<0071c003an003001cH003003hc`00LdT007=9
008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`0306IVIP00L`@007<4008007<400@00?P9
019c000BL`004W<00P0Wn00302Uc0080F?P00`0oL`0208Wh0080Eg<000@0IVIV0;[g002jm`00^_L0
0`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`001c7@00
101c7@020?Lo00<0L`H02`3[3P0K0?H>00030?OB0021E000PE@00080PE@00P3gX@05084k00P0mg00
10211`0U0?H>00<0SE`00P3gX@0508e000X0mg00102=200U0?H>0080mj401@2HA@020?M`00H0V2L0
0`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=0080mg001`2Z;0020?Lo00L0ZPX0
8@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200
mPh03@3gL0080;d;01l0mPh00P3gL0080<8b00<0mcl020322`0O0?H>00`0mg002037300N0?H>04h0
oooo001Q0?ooo`030000003oool0oooo00L0oooo0P1c05/01@3i0<D0L`1b07<0LP1VIVH0n@3g00<0
G@1c0`1707<509T0n@806@1c00D0=P3i0080L`1VIVH00P1c00@0n@03000DL`04000/n@00:g<002]c
000[L`8005gi0P00@W<01000SoT005Uc001IL`00FG<20030n@0406IVIP00L7<0071c003an0<007=P
00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK08007<K00<0IVIV003h>`00
L`@00`00L`@01000n0T04W<0019c000BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00P1GL`00101V
IVH0^_L00;[g002jm`0306ec0080joL0101cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=000
0`000000mg0007<M000407<M0080mcl00P1c1P0A0>/>01H0mPh000<0mm80085D0021E0000P21E002
0?NQ00D0PC/0203gL004084702D0mPh00`2=G0020?NQ00D0SD002P3gL00408d802D0mPh00P3gX@05
09Q50080mg001P2H9`030?Lo00D0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00P3gL007
0:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh00P2hD`020?M`00L0^2l0103g?`07
0;P;0200mPh03P3gL0070;d;01l0mPh00P3gL0080<8b00<0mcl020322`0O0?H>00`0mg002037300N
0?H>04h0oooo000O0?ooo`<00000103oool3000000030?ooo`0000000000008000000P3oool20000
0080oooo0`000000103oool000000?ooo`3oool3000000040?ooo`000000oooo0?ooo`<0000000<0
oooo0000003oool00P3oool30?l0V1<0oooo00<000000?ooo`3oool0203oool207<0F`050?T0a@1c
0780L`1b06IVIP3i0?L00P1M07<0103:0?T0A`1c04L0L`1707<509T0n@806@1c00D0=P3i0080L`1V
IVH00P1c00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<01P00SoT005Uc001IL`00
FG<00<3i06IVIP<0071c00D00?7h001cH000Lf0007=P003hc`04001cB@04003hW@00Lc8007<b001c
<P800?Q/0P00La/00`1VIVH00?Pk001c1003001c1004003h2@0BL`004W<0019c00809oP00`0YL`02
05Sh00<0?g<00P29n0000`1GL`00IVIV05Mc00030;[g00<0KG<00P3[m`0407=R00030?OB001cB`00
Ld/00080Ld/00P3gX@0307<d00030000003gL000Lad000@0Lad00P3g?`0207<601L0j`h0403f3P00
0`3gdP00PE@0085D0002085D0080mj401@21>`080?M`00@0P@L09@3f3P0308eL0080mj401@2=@00:
0?M`00@0S@P09@3f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01@2H2@0S0?H>00H0XTT02`3gL006
0:8902<0mPh0102ZC@020?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P02
0;QC00<0mg001P2h;`040?Lo00L0^0/0803f3P0>0?M`00L0_@/07`3f3P020?M`00P0`S80103g?`07
0<8;01l0mPh0303gL0080<L<01h0mPh0CP3oool001h0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo1@3o09PB0?ooo`030000003oool0oooo00L0oooo0`1c05/0
0`3i0<D0L`1b06IVIP020?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T201T0L`0503H0n@02
07<0IVIV0080L`040?T00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c00H008oi001IL`00
FG<005Uc0030n@1VIVH3001`L`05003an000Lf0007=P001cH000n<l00`00LdT2003hW@<007<b0P00
n6`01000La/0IVIV003h>`00n3/3001c10800?P90`0BL`0202Oh00<0:G<000<0F?P003mc000oL`00
0P0oL`0208Wh000305Mc001VIVH0Eg<00080^_L0101]L`000`3[m`00Lf8007=R000307=R00030?OB
001cB`00Ld/00080Ld/00P3gX@0207<d00030000001c=000mg0000D0Lad00P3g?`000`1c1P00j`h0
0>/>000K0>/>00/0mPh000<0mm80085D0021E0000P21E0020?NQ00D0PC/0203gL004084702D0mPh0
0`2=G0020?NQ00D0SD002P3gL00408d802D0mPh00P3gX@0509Q50080mg001P2H9`030?Lo00D0V0T0
8`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00P3gL0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00
303gL0070;4:0240mPh00P2hD`030?M`00H0^2l0103g?`070;P;0200mPh03P3gL0070;d;01l0mPh0
0P3gL0080<8b00@0mcl01`322`0O0?H>00`0mg002037300N0?H>04h0oooo000N0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L0o`2H403oool00`000000oooo
0?ooo`080?ooo`<0L`1K00<0n@3507<0LP1VIVH00P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0
V@3i0P0I07<01@0f0?T0IVIV0080L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT2
0012L`05002?n@00FG<005Uc001IL`1VIVH01000L7<01@00lOP007=P001cH000Lf000?S?00<007=9
00<00?RM001c<P00Lc800P00Lc82003hK004001c6`1VIVH00?Pk003h>`<007<40P00n0T3019c0080
9oP00`0YL`000`1Hn000?g<003mc000203mc0080ROP000<0IVIV05Mc001GL`000P2jm`0406ec0003
0>_g001cHP00Lf800080Lf800P3gdP0407=;00070?NQ001c=000Lc@007<d00000000Lc@00?M`0005
07<M0080mcl000<0L`H00>/>003[3P00803[3P060?H>00030?OB0021E000PE@00080PE@00P3gX@05
084k00P0mg0010211`0U0?H>00<0SE`00P3gX@0508e000X0mg00102=200T0?H>00<0mj401@2HA@02
0?M`00H0V2L00`3g?`0509P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=0080mg001`2Z;002
0?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00H0^2l0103g
?`070;P;0200mPh03P3gL0070;d;01l0mPh00P3gL0080<8b00@0mcl01`322`0O0?H>00`0mg002037
300N0?H>04h0oooo000N0?ooo`030000003oool0oooo00D0oooo100000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool400000080oooo00D000000?ooo`3oool0oooo000000030?ooo`@00000
0P3oool70?l0V100oooo00<000000?ooo`3oool0203oool307<0F`030?T0a@1c0780IVIV0080n@3g
0P1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c00D0=P3i06IVIP0207<00P1c00@0n@03000DL`05
000/n@00:g<002]c000[L`00GOT00`00@W<01@00SoT005Uc001IL`00FG<0IVIV00@0071c00D00?7h
001cH000Lf0007=P003hc`03001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c6`1VIVH007<K
0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh000306IV
IP1GL`00Eg<00080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm80101cB`001`3gX@00Lc@0
07<d001c=000000007<d003gL0001@1c7@020?Lo02P0j`h00P3gdP04085D0080mj401@21>`080?M`
00@0P@L09@3f3P0308eL0080mj401@2=@00:0?M`00@0S@P0903f3P030?NQ00D0V4D00P3gL00609PW
00<0mcl01@2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@020?M`00L0ZR`00P3g?`070:X:
0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0060;P_00@0mcl01`2h2`0P
0?H>00h0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00L0`P/07`3f3P0<0?M`00P0a``07P3f3P1>
0?ooo`007P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo008000000P3oool00`00
0000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`070?l0V100oooo00<000000?ooo`3oool0203oool307<0F`0307<0LP1VIVH0
L`1b0080n@3g0P1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c00D0IVIV0080L`0207<00P1c00@0
n@03000DL`05000/n@00:g<002]c000[L`00GOT00`00@W<01@00SoT005Uc001IL`1VIVH00<3i00<0
071c0P00lOP3001cH005003hc`00LdT007=9001cB@00n9d01000Lc801000n6`007<K06IVIP00La/2
003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000305Sh000oL`00
?g<00080?g<000<0ROP006IVIP1GL`000P1GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP02
0?OB00@0Ld/000D0mj4007<d001c=000Lc@0000000020?M`00D0Lad00P3g?`0X0>/>0080mm801021
E0020?NQ00@0PC/0203gL005084702D0mPh00`2=G0020?NQ00D0SD002@3gL00508d802@0mPh00`3g
X@0509Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00P3g
L0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg00
1`2h;`030?Lo00L0^0/0803f3P0>0?M`00L0_@/07`3f3P030?M`00L0`S80103g?`070<8;01l0mPh0
303gL0080<L<01h0mPh0CP3oool001h0oooo00D000000?ooo`3oool0oooo000000020?ooo`@00000
0P3oool00`000000oooo00000002000000<0oooo100000040?ooo`@000000P3oool4000000@0oooo
1@3o09P<0?ooo`D000002P3oool01`3d0940L`1K07<0F`1c05/0L`1b06IVIP1c07800P3i0?L205d0
L`030<X0n@1707<0A`1c00D0V@3i0`0I07<01@1VIVH00P1c0080L`0207<0103i008001Ac0P00;?T3
000[L`05001Mn@00@W<0049c0012L`00SoT00P00FG<00`1VIVH00<3i001`L`02001`L`800?7h0`00
Lf001@00n<l007=9001cB@00LdT00?RM00@007<b00@00?Q/06IVIP00La/007<K0P00n3/3001c1003
003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0003
08Wh001VIVH0Eg<00080Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;0005
0?NQ001c=000Lc@007<d000000000P3gL00507<M00030?Lo003[3P00j`h002L0j`h00P3gdP04085D
0080mj401021>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ
00D0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@020?M`
00L0ZR`00`3g?`060:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL007
0;P_00<0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0O0?H>00<0mg001`32<P04
0?Lo00L0`P/07`3f3P0<0?M`00P0a``07`3f3P1=0?ooo`007P3oool01@000000oooo0?ooo`3oool0
000001/0oooo00<000000?ooo`3oool02@3oool30?l0V140oooo100000060?ooo`80m02A0`1c05/0
0`1VIVH0L`1b07<0LP020?T0m`80G@1c00<0bP3i04L0L`1707<01@2I0?T201T0L`0306IVIP0207<0
0P1c00800P1c00<0103i000DL`0057<00P00;?T3000[L`09001Mn@00@W<0049c0012L`00SoT005Uc
06IVIP00FG<00<3i00<0071c00<00?7h001cH000Lf000P00Lf001@00n<l007=9001cB@00LdT00?RM
00@007<b00@00?Q/06IVIP00La/007<K0P00n3/3001c1003003h2@0BL`004W<000804W<000<09oP0
02Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc000306IVIP1GL`00Eg<00080Eg<00P2jm`04
06ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d000000000P3g
L00407<M00P0mcl08P3[3P000`21KP00mm800?OB0004085D0080mj401021>`080?M`00D0P@L09@3f
3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H
2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@020?M`00L0ZR`00`3g?`060:X:0240mPh00`2a
D00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00030;eF
003gL000mg0000/0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07P3f3P0<0?M`00P0a``0
7`3f3P1=0?ooo`007`3oool3000001`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`080?ooo`80m02A0P1c05/01@3i0<D0IVIV07<0LP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<0
1@2I0?T201T0L`0306IVIP0207<00P1c00800P1c00<0103i000DL`0057<00P00;?T2000[L`8005gi
0`00@W<01@00SoT005Uc06IVIP00FG<00<3i00<0071c00<00?7h001cH000Lf000P00Lf001@00n<l0
07=9001cB@00LdT00?RM00@007<b00@0IVIV001c6`00La/007<K0P00n3/3001c1003003h2@0BL`00
4W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc000306IVIP1GL`00
Eg<00080Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c=000
Lc@006IVIP0000000P3gL00407<M00d0mcl07@3[3P000`21KP00mm800?OB0004085D0080mj401021
>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3g
L00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@020?M`00L0ZR`00`3g
?`060:X:0240mPh00`2aD00=0?M`00H0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0P0?H>00030;eF003gL000mg0000/0mg001`2m2`0P0?H>0080mg001`32<P040?Lo00P0`P/0
7P3f3P0<0?M`00T0a``07P3f3P1=0?ooo`00?@3oool2000001h0oooo00<000000?ooo`3oool01`3o
ool30?@0T@80L`1K00D0IVIV07<0LP1c0780L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c00D0V@3i
00<06@1c06IVIP0I07<0100207<00`040?T001Ac000DL`02000/n@8002]c0P00GOT30012L`05002?
n@1VIVH005Uc001IL`00`?T00`00L7<01000lOP007=P001cH000Lf02003hc`<007=900<00?RM001c
<P00Lc800P00Lc80101VIVH007<K001c6`00La/2003h>`<007<400<00?P9019c000BL`000P0BL`00
0`0Wn000:G<002Uc000202Uc000605Sh000oL`00?g<003mc001VIVH0ROP0101GL`020;[g00@0KG<0
00<0joL007=R001cHP000P1cHP020?OB00@0Ld/000D0mj4007<d001c=000IVIV000000020?M`00@0
Lad04P3g?`0G0>/>0080PFh00P3gdP04085D0080mj401021>`080?M`00D0P@L09@3f3P0308eL0080
mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0
XTT02`3gL0060:8902<0mPh0102ZC@020?M`00L0ZR`00`3g?`060:X:0240mPh00`2aD00=0?M`00H0
/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00030;eF003gL000mg00
00/0mg00202m2`0O0?H>0080mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1=0?oo
o`00G03oool00`000000oooo0?ooo`080?ooo`<0m02A0P1c05/01@1VIVH0L`1b07<0LP1c0780n@3g
00<0G@1c0`1707<509T0n@0301T0L`1VIVH06@1c00@00P1c00<0103i000DL`0057<00P00;?T2000[
L`8005gi0P00@W<2002?n@0406IVIP00FG<005Uc0030n@<0071c00D00?7h001cH000Lf0007=P003h
c`04001cB@06003hW@00Lc8007<b001c<P1VIVH00?Q/0`00La/00`00n3/007<4001c1002001c1003
003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`001P1Hn000?g<003mc000oL`00IVIV
08Wh00@0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf8000<0mm8007=;001cB`000`1cB`00
1@3gX@00Lc@006IVIP1c=00000000080mg00101c7@0H0?Lo0140j`h00P21KP020?OB00@0PE@00P3g
X@04084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000T0mg001@2=200T0?H>00<0mj401@2H
A@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=00<0mg001P2Z
;0030?Lo00H0ZPX08@3f3P030;5@00d0mg001P2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0
0`3g?`070;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh00P3gL0080<8b00<0mcl0
20322`0O0?H>00`0mg002037300N0?H>04d0oooo000J0?ooo`@00000103oool00`000000oooo0000
00040?ooo`<00000103oool3000000040?ooo`000000oooo0?ooo`<000000P3oool300000080oooo
0P0000030?ooo`<0o`1U4`3oool00`000000oooo0?ooo`070?ooo`@0m02A00<0L`1K06IVIP3i0<D0
0P1c07820?T0m`<0G@1c0`1707<509T0n@0301T0L`1VIVH0=P3i00@00P1c0`0057<2000/n@8002]c
0P00GOT20012L`03002?n@1VIVH005Uc008005Uc00D00<3i001`L`00L7<0071c003an003001cH003
003hc`00LdT007=9008007=900H00?RM001c<P00Lc8007<b06IVIP00n6`3001c6`03003h>`00L`@0
07<4008007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00
?g<006IVIP80ROP0101GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/000<0Ld/000D0
mj4007<d001VIVH0Lc@0000000020?M`00@0Lad07@3g?`0;0>/>00<0PFh00P3gdP04085D0080mj40
1021>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D0
0P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`0
0`3g?`060:X:0280mPh00P2aD00=0?M`00H0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0
mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0O0?H>0080mg002032<P030?Lo00P0
`P/07`3f3P0<0?M`00P0a``07P3f3P1=0?ooo`006P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo1@3o06DB0?ooo`030000003oool0oooo00/0oooo00<0L`1K06IVIP3i0<D0
0P1c07820?T0m`<0G@1c0`1707<509T0n@0306IVIP0I07<0=P3i00@00P1c0`0057<2000/n@8002]c
0P00GOT20012L`03002?n@1VIVH005Uc008005Uc00D00<3i001`L`00L7<0071c003an003001cH003
003hc`00LdT007=9008007=900@00?RM001c<P00Lc80IVIV0P00n6`3001c6`03003h>`00L`@007<4
008007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<0
06IVIP80ROP0101GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/00P3gX@00
101VIVH0Lc@007<d000000020?M`00@0Lad08P3g?`060>/>00<0PFh00P3gdP04085D0080mj401021
>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3g
L00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g
?`060:X:0280mPh00P2aD00=0?M`00H0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0Q0?H>00d0mg00202m2`0O0?H>0080mg002032<P030?Lo00P0`P/07`3f3P0<0?M`00P0a``0
7P3f3P1=0?ooo`007P3oool020000000oooo0?ooo`000000oooo0000003oool000000P3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0IA00oooo00<000000?ooo`3oool0303o
ool00`1c05/0IVIV0?T0a@0207<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@0306IV
IP0I07<0=P3i00@00P1c0`0057<01000;?T002]c000[L`00:g<2001Mn@80049c00<0IVIV001IL`00
FG<00P00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P00<00?S?001cB@00LdT00P00LdT01000
n9d007<b001c<P1VIVH2003hK0<007<K00<00?Pk001c1000L`@00P00L`@01000n0T04W<0019c000B
L`0202Oh00<0:G<00P1Hn0000`0oL`00IVIV03mc000208Wh00@0Eg<00P2jm`0306ec0080joL0101c
HP000`3gdP00Ld/007=;000207=;0080mj4000@0IVIV07<d001c=00000000P3gL00407<M02D0mcl0
00<0joL0085^0021KP000`21KP000`3gdP00PE@0085D0003085D0080mj401021>`080?M`00D0P@L0
9@3f3P0308eL0080mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3gL00609PW0080mcl0
1P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0280mPh0
0`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0Q0?H>00d0
mg00202m2`0O0?H>0080mg002032<P030?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1=0?ooo`00
703oool300000080oooo00D000000?ooo`000000oooo000000020?ooo`D000000P3oool01@000000
oooo0?ooo`3oool000000080oooo1@0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool7
0?l0IA00oooo00<000000?ooo`3oool0303oool00`1VIVH0L`1K0?T0a@0207<0LP80n@3g0P1M07<0
103:0?T0A`1c04L0L`1707<409T0n@0406IVIP0I07<06@1c03H0n@<00P1c00D0103i000DL`0057<0
01Ac000/n@03000[L`8005gi0P00@W<0101VIVH005Uc001IL`00FG<20030n@<0071c00D00?7h001c
H000Lf0007=P003hc`04001cB@04003hW@00Lc8007<b06IVIP800?Q/0`00La/00`00n3/007<4001c
1002001c1004003h2@0BL`004W<0019c00809oP00`0YL`0205Sh000303mc001VIVH0?g<00080ROP0
0`1GL`030;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/00080Ld/000<0mj4006IVIP1c=000
0P1c=0000`000000mg000?M`000407<M02D0mcl000<0joL0085^0021KP000`21KP000`3gdP00PE@0
085D0003085D00030?NQ0021>`00PC/000<0PC/0203gL005084702D0mPh00`2=G0020?NQ00D0SD00
2@3gL00508d802@0mPh00`3gX@0509Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900/0mg00
1P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0mcl01P2Z2P0R0?H>00<0/E00303gL0070;4:0240mPh0
00@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/08@3f3P0=0?M`00P0_@/07`3f3P020?M`00P0
`S80103g?`070<8;01l0mPh0303gL0080<L<01h0mPh0C@3oool001X0oooo0`0000040?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00<0
00000?ooo`3oool01`3o06D;0?ooo`D000002P3oool40?X0H`0407<0F`1VIVH0L`1K0?T0a@80L`1b
0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`@0V@3i00@0IVIV01T0L`0I07<0=P3i0`0207<01@04
0?T001Ac000DL`0057<002ci00<002]c0P00GOT20012L`0406IVIP00FG<005Uc001IL`800<3i0`00
L7<01@00lOP007=P001cH000Lf000?S?00@007=900@00?RM001c<P1VIVH007<b0P00n6`3001c6`03
003h>`00L`@007<4008007<400@00?P9019c000BL`004W<00P0Wn00302Uc0080F?P000<0IVIV03mc
000oL`000P29n00305Mc00<0^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`000`3g
X@00IVIV07<d000207<d00030000003gL000mg0000@0Lad09@3g?`000`3[m`00PFh0085^0003085^
00030?OB0021E000PE@000<0PE@000<0mj40084k0021>`000`21>`080?M`00D0P@L09@3f3P0208eL
00<0mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>
00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g?`060:X:0280mPh00`2aD00<0?M`
00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0Q0?H>00d0mg00202m2`0O
0?H>0080mg002032<P040?Lo00L0`P/07`3f3P0<0?M`00P0a``07P3f3P1=0?ooo`006P3oool00`00
0000oooo0?ooo`030?ooo`<0000000@0oooo00000000000000000P3oool3000000@0oooo10000003
0?ooo`<000000P3oool00`000000oooo00000002000000@0oooo1@3o06D@0?ooo`@000001`3oool4
0?X0H`0406IVIP1c05/0L`1K0?T0a@80L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00@0V@3i00D0
IVIV01T0L`0I07<06@1c03H0n@030080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@03
0012L`1VIVH008oi00<005Uc00<00<3i001`L`00L7<00P00L7<01@00lOP007=P001cH000Lf000?S?
00@007=900@00?RM001c<P1VIVH007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400@00?P9
019c000BL`004W<00P0Wn00302Uc0080F?P000<0IVIV03mc000oL`000P29n00305Mc00<0^_L00`1]
L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`000`1VIVH0mj4007<d000207<d00030000003g
L000mg0000@0Lad09@3g?`000`3[m`00PFh0085^0003085^00030?OB0021E000PE@000<0PE@000<0
mj40084k0021>`000`21>`080?M`00D0P@L09@3f3P0208eL00<0mj401@2=@0090?M`00D0S@P0903f
3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102Z
C@030?M`00H0ZR`00`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`
003gL0070;P_00@0mcl01P2h2`0Q0?H>00d0mg00202m2`0O0?H>0080mg002032<P040?Lo00L0`P/0
7`3f3P0<0?M`00P0a``07P3f3P1=0?ooo`006P3oool01@000000oooo0?ooo`3oool0000001@0oooo
00<000000?ooo`3oool0403oool30?l0IA00oooo00<000000?ooo`3oool0203oool00`1c02d0nP1S
0?X0H`020?X0H`0306IVIP1c05/0L`1K00<0L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00@0V@3i
00D0IVIV01T0L`0I07<06@1c03H0n@030080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<01@00
GOT0049c0012L`1VIVH008oi00<005Uc00<00<3i001`L`00L7<00P00L7<01@00lOP007=P001cH000
Lf000?S?00<007=90P00n9d00`1VIVH007<b001c<P02003hK08007<K0P00n3/3001c10800?P90`0B
L`0202Oh00<0:G<000<0F?P006IVIP0oL`000P0oL`0208Wh00<0Eg<00`2jm`0306ec0080joL0101c
HP000`3gdP00Ld/007=;000207=;000306IVIP3gX@00Lc@00080Lc@000<000000?M`001c7@00101c
7@0U0?Lo00030>_g0021KP00PFh00080PFh00P3gdP05085D00030?NQ0021>`00PC/000<0PC/0203g
L005084702D0mPh00P2=G0030?NQ00D0SD002@3gL00508d802@0mPh00`3gX@0509Q50080mg001P2H
9`020?Lo00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0mcl01`2Z
2P0Q0?H>00<0/E00303gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/0
803f3P0>0?M`00L0_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0mPh0303gL0080<L<01l0mPh0
C03oool001/0oooo1000000D0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0203o
ool01@1c02d0nP1S0?X0H`3j06<0IVIV00<0L`1K0`1c07820?T0m`80G@1c00<0bP3i04L0L`1707<0
0`2I0?T00`1VIVH0V@3i01T0L`0201T0L`0503H0n@0207<00P1c0080L`040?T00`0057<02@00;?T0
02]c000[L`00:g<005gi0012L`1VIVH0049c002?n@03001IL`030030n@00L7<0071c0080071c00D0
0?7h001cH000Lf0007=P003hc`03001cB@03003hW@00Lc80IVIV008007<b0P00n6`2001c6`800?Pk
0`00L`@2003h2@<04W<00P0Wn00302Uc000305Sh001VIVH0?g<00080?g<00P29n00305Mc00<0^_L0
0`1]L`000`3[m`00Lf8007=R000307=R00050?OB001cB`00Ld/007=;001VIVH00P3gX@0307<d0003
0000003gL000Lad000@0Lad09@3g?`000`3[m`00PFh0085^0002085^0080mm801@21E0000`3gX@00
PC/0084k0003084k00P0mg001@211`0U0?H>0080SE`00`3gX@0508e000T0mg001@2=200T0?H>00<0
mj401@2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=00<0
mg001P2Z;0030?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`
00L0^2l0103g?`070;P;0200mPh03P3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>
00`0mg002037300O0?H>04`0oooo000b0?ooo`8000009@3oool00`000000oooo0?ooo`070?ooo`80
L`0]0`3j06<0101VIVH0L`1K07<0F`1c05/307<0LP80n@3g0P1M07<00`3:0?T0A`1c04L0L`0309T0
n@0306IVIP2I0?T06@1c00806@1c00D0=P3i0080L`0207<00P1c00@0n@02000DL`8002ci0`00:g<0
1@00GOT0049c06IVIP00@W<008oi00<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH006003h
c`00LdT007=9001cB@00n9d0IVIV0`00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3
019c00809oP00`0YL`000`1VIVH0?g<003mc000203mc0080ROP00`1GL`020;[g00@0KG<000<0joL0
07=R001cHP000`1cHP001@3gdP00Ld/007=;001cB`00IVIV0080mj400`1c=0000`000000mg0007<M
000407<M02D0mcl000<0joL0085^0021KP000P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@21
1`0U0?H>0080SE`00`3gX@0508e000T0mg001@2=200T0?H>00<0mj401@2HA@020?M`00H0V2L00P3g
?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08@3f
3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh0
3P3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl01`322`0O0?H>00`0mg002@37300N0?H>04`0oooo
000?0?ooo`D000000`3oool3000000@0oooo0`0000030?ooo`H000000P3oool3000000030?ooo`00
00000000008000000P3oool200000080oooo0`0000000`3oool000000?ooo`020?ooo`<0o`0b4`3o
ool00`000000oooo0?ooo`080?ooo`80L`0]0`3j06<0101VIVH0L`1K07<0F`3i0<D307<0LP050?T0
m`1M07<0G@1c05d0L`3:0?T00P1707<209T0n@0306IVIP2I0?T0V@3i00<06@1c100207<00`040?T0
01Ac000DL`02000/n@<002]c00D005gi06IVIP00@W<0049c002?n@03001IL`040030n@00L7<0071c
001`L`800?7h0`00Lf001P00n<l007=9001cB@00LdT00?RM06IVIP<007<b00@00?Q/001c6`00La/0
07<K0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<000<0IVIV03mc000oL`000P0oL`0208Wh00<0
Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0207=;000306IVIP1cB`00mj4000<0
Lc@000<0000007<d003gL0001@1c7@0U0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080
mj401@21>`080?M`00D0P@L09@3f3P0208eL00<0mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0
V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0
ZR`00`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_
00@0mcl01`2h2`0P0?H>00h0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07P3f3P0<0?M`
00T0a``07P3f3P1<0?ooo`004@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000`3oool50?l0<Q80oooo00<000000?ooo`3oool01`3oool307<0;@80
nP1S00D0IVIV0?X0H`1c05/0L`1K0?T0a@0307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<2
09T0n@0306IVIP2I0?T0V@3i00<06@1c100207<00`040?T001Ac000DL`02000/n@8002]c0P00GOT0
101VIVH0049c0012L`00SoT3001IL`050030n@00L7<0071c001`L`00lOP01000Lf001@00n<l007=9
001cB@00LdT0IVIV00@007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1003003h2@0BL`004W<0
00804W<000H09oP002Uc000YL`00:G<006IVIP1Hn00403mc0080ROP00`1GL`020;[g00@0KG<000<0
joL007=R001cHP000P1cHP020?OB0080Ld/000<0IVIV07=;003gX@000`1c=0000`000000Lc@00?M`
000507<M02D0mcl000<0joL0085^0021KP000P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@21
1`0U0?H>0080SE`00`3gX@0508e000T0mg001@2=200T0?H>00<0mj401@2HA@020?M`00H0V2L00P3g
?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08@3f
3P030;5@00`0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh0
3P3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037300N0?H>04`0oooo
000A0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo1`3o038@0?oo
o`030000003oool0oooo00P0oooo0`1c02d20?X0H`0506IVIP3j06<0L`1K07<0F`3i0<D00`1c0780
1@3i0?L0G@1c05d0L`1M07<0bP3i0080A`1c0P2I0?T00`1VIVH0V@3i09T0n@0301T0L`@00P1c00<0
103i000DL`0057<00P00;?T2000[L`03001Mn@1VIVH0049c0080049c00D008oi001IL`00FG<005Uc
0030n@03001`L`03003an000Lf0007=P008007=P00D00?S?001cB@00LdT007=906IVIP04001c<P04
003hK000La/007<K001c6`800?Pk0`00L`@00`00n0T04W<0019c0002019c000602Oh000YL`00:G<0
02Uc001VIVH0F?P0100oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3g
dP001@1cB`00IVIV07=;001cB`00mj4000<0Lc@01@00000307<M02D0mcl000<0joL0085^0021KP00
0P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@211`0U0?H>0080SE`00`3gX@0508e000T0mg00
1@2=200T0?H>00<0mj401@2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0;0?M`00H0XPT0
8`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0Q0?H>00040;QC
003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh03P3gL0070;d;01l0mPh00`3gL0070<8b00@0
mcl020322`0O0?H>00`0mg002037300N0?H>04`0oooo000A0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0103oool5000000@0oooo00<000000?ooo`3oool00`3oool400000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0
<Q00oooo00<000000?ooo`3oool0203oool307<0;@040?X0H`1VIVH0nP1S0?X0H`80L`1K00D0n@35
07<0LP1c0780L`1b0?T0m`0305d0L`<0A`1c00<0V@3i06IVIP2I0?T00P2I0?T301T0L`@00P1c00<0
103i000DL`0057<00P00;?T2000[L`04001Mn@1VIVH0049c0012L`8008oi0`00FG<01@00`?T0071c
001`L`00L7<00?7h00<007=P0P00n<l2001cB@0306IVIP00n9d007<b00<007<b00@00?Q/001c6`00
La/007<K0P00n3/3001c1003003h2@0BL`004W<000804W<000H09oP002Uc000YL`00IVIV02Uc001H
n00403mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3g
dP001@1cB`00IVIV07=;001cB`00mj4000<0Lc@000<0000007<d003gL0001@1c7@0U0?Lo00030>_g
0021KP00PFh00080PFh00P3gdP04085D0080mj401@21>`080?M`00D0P@L0903f3P0308eL00<0mj40
1@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0
2`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X0
8@3f3P020;QC0080mg001`2h;`040?Lo00L0^0/0803f3P0>0?M`00L0_@/0803f3P020?M`00L0`S80
103g?`080<8;01l0mPh0303gL0080<L<01h0mPh0C03oool00140oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool01`3o038?0?ooo`030000003oool0oooo00T0oooo0`1c02d0103j
06<0IVIV0?X0H`3j06<207<0F`030?T0a@1c0780L`1b0080n@3g0`1M07<304L0L`0309T0n@1VIVH0
V@3i0080V@3i0P0I07<00`0f0?T00P1c0080L`020080L`<001Ac0P00;?T2000[L`0406IVIP00GOT0
049c0012L`8008oi0`00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P0P00n<l2001cB@0306IV
IP00n9d007<b00<007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1003003h2@0BL`004W<00080
4W<000H09oP002Uc000YL`00IVIV02Uc001Hn00403mc000308Wh001GL`00Eg<00080Eg<00P2jm`04
06ec00030>_g001cHP00Lf800080Lf800P3gdP001@1VIVH0Ld/007=;001cB`00mj4000<0Lc@000<0
00000?M`003gL0001@1c7@0U0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080mj401@21
>`080?M`00@0P@L09@3f3P0308eL00<0mj401@2=@0090?M`00D0S@P0903f3P030?NQ00D0V4D00P3g
L00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g
?`070:X:0240mPh00`2aD00<0?M`00L0/@X08@3f3P020;QC00<0mg001P2h;`040?Lo00L0^0/0803f
3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303g
L0080<L<01h0mPh0C03oool00140oooo00<000000?ooo`3oool00`3oool3000000@0oooo0`000005
0?ooo`030000003oool0oooo0080oooo100000020?ooo`030000003oool0000000800000103oool4
000000<0oooo1@3o038<0?ooo`@0000000<0IVIV0?ooo`3oool0203oool01@3j0340L`0]07<0;@1c
02d0IVIV00<0nP1S0P1c05/00`3i0<D0L`1b07<0LP020?T0m`<0G@1c0`1707<00`1VIVH0V@3i09T0
n@0209T0n@806@1c00<0=P3i0080L`0207<00P0207<3000DL`8002ci0P00:g<01@1VIVH005gi0012
L`00@W<008oi00@005Uc00D00<3i001`L`00L7<0071c003an003001cH006003hc`00LdT007=906IV
IP00LdT00?RM0`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002
019c000302Oh000YL`00IVIV0080:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc0002
05Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm8000D0IVIV07=;001cB`00Ld/00?NQ
000307<d00030000003gL000mg0000D0Lad09@3g?`000`3[m`00PFh0085^0002085^0080mm801021
E0020?NQ00D0PC/0203gL004084702D0mPh00`2=G0030?NQ00@0SD002P3gL00508d802@0mPh00`3g
X@0509Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00`3g
L0060:X/00<0mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0240mPh00P2hD`030?M`00H0^2l0103g
?`070;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh00P3gL0080<8b00<0mcl02032
2`0O0?H>00`0mg002037300N0?H>04`0oooo000A0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`020?ooo`<0o`0b4@3oool0101VIVH0000000000000
00060?ooo`0607<05P3j0340L`0]07<0;@3j06<0IVIV0`3j06<207<0F`030?T0a@1c0780L`1b0080
n@3g0P1M07<01@3:0?T0A`1c04L0L`1707<0IVIV00@0V@3i0P0I07<00`0f0?T00P1c0080L`020080
L`<001Ac00@002ci000[L`00:g<0IVIV0P00GOT20012L`03002?n@00FG<005Uc008005Uc00D00<3i
001`L`00L7<0071c003an003001cH006003hc`00LdT007=906IVIP00LdT00?RM0`00Lc82003hK0<0
07<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00IVIV0080
:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00
Lf8007=R000207=R00030?OB001VIVH0Ld/000<0Ld/000D0mj4007<d001c=000Lc@0000000020?M`
00@0Lad09P3g?`000`3[m`00PFh0085^0002085^0080mm801021E0020?NQ00D0PC/0203gL0040847
02D0mPh00`2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0609Q50080mg001P2H9`020?Lo
00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0mcl01`2Z2P0Q0?H>
00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001P2h;`040?Lo00L0^0/0803f3P00
0`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303gL008
0<L<01h0mPh0C03oool000l0oooo1@00000B0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool05P3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00@0nP0a07<0;@1c02d0IVIV0`3j06<3
07<0F`030?T0a@1c0780L`1b0080n@3g0P1M07<0103:0?T0A`1c04L0L`1VIVH509T0n@806@1c00D0
=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c06IVIP8005gi0P00@W<00`00SoT0
05Uc001IL`02001IL`050030n@00L7<0071c001`L`00lOP00`00Lf000`00n<l007=906IVIP02001c
B@04003hW@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`00
4W<000804W<000<09oP006IVIP0YL`000P0YL`00101Hn000?g<003mc000oL`0208Wh00@0Eg<00P2j
m`0406ec00030>_g001cHP00Lf800080Lf8000<0mm8006IVIP1cB`000`1cB`001@3gX@00Lc@007<d
001c=00000000080mg00101c7@0V0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080mj40
1@21>`080?M`00@0P@L09@3f3P0308eL00<0mj40102=@00:0?M`00D0S@P0903f3P020?NQ00H0V4D0
0P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00H0ZR`0
0`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0
mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0O0?H>0080mg002032<P030?Lo00P0
`P/07`3f3P0<0?M`00P0a``07`3f3P1;0?ooo`00903oool3000001D0oooo0P00000H0?ooo`0306IV
IP3oool0oooo00H0oooo0P1c01H0103j0340L`0]07<0;@1VIVH30?X0H`<0L`1K00<0n@3507<0LP1c
07800P3i0?L205d0L`040<X0n@1707<0A`1c06IVIPD0V@3i0P0I07<01@0f0?T00P1c0080L`0207<0
103i00<001Ac00@002ci000[L`1VIVH002]c0P00GOT20012L`04002?n@00FG<005Uc001IL`800<3i
0`00L7<01`00lOP007=P001cH000Lf000?S?001cB@1VIVH00P00LdT01000n9d007<b001c<P00Lc82
003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000302Oh001VIVH0
:G<00080:G<000@0F?P003mc000oL`00?g<00P29n00405Mc0080^_L00`1]L`020>_g00@0Lf8000<0
IVIV07=;001cB`000`1cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@0V0?Lo00030>_g
0021KP00PFh00080PFh00P3gdP04085D0080mj401@21>`080?M`00@0P@L09@3f3P0308eL00<0mj40
102=@00:0?M`00D0S@P0903f3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0
2`3gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X0
8P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0
mg00202m2`0O0?H>0080mg002032<P040?Lo00L0`P/07`3f3P0<0?M`00P0a``07`3f3P1;0?ooo`00
EP3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00@0nP0a07<0;@1c02d0IVIV0`3j06<307<0F`<0
L`1b0P3i0?L205d0L`030<X0n@1707<0IVIV00D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i
00<001Ac00@002ci000[L`1VIVH002]c0P00GOT20012L`04002?n@00FG<005Uc001IL`800<3i0`00
L7<01P00lOP007=P001cH000Lf000?S?06IVIP<007=900@00?RM001c<P00Lc8007<b0P00n6`3001c
6`03003h>`00L`@007<4008007<400H00?P9019c000BL`004W<002Oh001VIVH302Uc0080F?P00`0o
L`0208Wh00@0Eg<00P2jm`0306ec0080joL0101cHP000`1VIVH0Ld/007=;000307=;00050?NQ001c
=000Lc@007<d000000000P3gL00407<M02D0mcl00P3[m`04085^0080mm801021E0020?NQ00D0PC/0
203gL004084702D0mPh00`2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3gX@0609Q50080mg00
1P2H9`020?Lo00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00`3gL0070:X/0080mcl0
1`2Z2P0Q0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0
^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0
mPh0303gL0080<L<01l0mPh0B`3oool005H0oooo00<0IVIV0?ooo`3oool01P3oool207<05P030?X0
<@1c02d0IVIV00@0nP1S0`1c05/307<0LP80n@3g0P1M07<00`3:0?T0A`1c06IVIP0509T0n@<06@1c
00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<0IVIV000[L`8005gi0P00@W<01@00
SoT005Uc001IL`00FG<00<3i00@0071c00H00?7h001cH000Lf0007=P003hc`1VIVH3001cB@04003h
W@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1006003h2@0BL`004W<0019c
000Wn000IVIV0`0YL`0205Sh00<0?g<00P29n00405Mc0080^_L00`1]L`020>_g00<0Lf8000<0IVIV
0?OB001cB`000`1cB`020?NQ00<0Lc@000<000000?M`003gL000101c7@0U0?Lo0080joL01021KP02
0?OB00@0PE@00P3gX@04084k00T0mg0010211`0U0?H>00<0SE`00`3gX@0408e000X0mg001@2=200T
0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P04
0:Y=00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;0240mPh03@3gL0080;d;01l0mPh00P3gL0080<8b00@0mcl01`32
2`0O0?H>00`0mg002037300O0?H>04/0oooo001E0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H0
0`3j0340L`0]06IVIP040?X0H`<0L`1K0`1c07820?T0m`80G@1c00<0bP3i06IVIP1707<01@2I0?T3
01T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01@00;?T0IVIV000[L`00:g<005gi00<0049c
00D008oi001IL`00FG<005Uc0030n@04001`L`05003an000Lf0007=P001cH01VIVH00`00LdT2003h
W@<007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400H00?P9019c000BL`004W<006IVIP0W
n00302Uc0080F?P00`0oL`0208Wh00<0Eg<00`2jm`0306ec0080joL00`1cHP000`1VIVH0mm8007=;
000307=;0080mj400`1c=0000`000000mg000?M`000407<M02D0mcl00P3[m`04085^0080mm801021
E0020?NQ00@0PC/02@3gL004084702D0mPh00`2=G0030?NQ00@0SD002P3gL00508d802@0mPh00P3g
X@0609Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900/0mg001P2R2@0S0?H>00@0ZTd00`3g
L0070:X/0080mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg00
1`2h;`030?Lo00L0^0/08@3f3P0=0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`070<8;01l0mPh0
303gL0090<L<01h0mPh0B`3oool005D0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1V
IVH0L`0]00@0nP1S0`1c05/307<0LP80n@3g0P1M07<00`3:0?T0IVIV04L0L`0509T0n@<06@1c00D0
=P3i0080L`0207<00P1c00@0n@03000DL`05000/n@1VIVH002]c000[L`00GOT00`00@W<01@00SoT0
05Uc001IL`00FG<00<3i00<0071c0P00lOP3001cH00406IVIP00LdT007=9001cB@800?RM0`00Lc82
003hK0<007<K00@00?Pk001c1000L`@007<40P00n0T3019c000306IVIP0Wn000:G<00080:G<00P1H
n00303mc0080ROP00`1GL`030;[g00<0KG<00P3[m`0207=R000306IVIP1cHP00mm8000@0Ld/00P3g
X@0307<d00030000003gL000mg0000@0Lad09@3g?`020>_g00@0PFh00P3gdP04085D0080mj401021
>`080?M`00D0P@L09@3f3P0308eL00<0mj40102=@00:0?M`00D0S@P0903f3P020?NQ00H0V4D00P3g
L00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g
?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0
1`2h2`0Q0?H>00d0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00L0`P/0803f3P0;0?M`00T0a``0
7P3f3P1;0?ooo`00E@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0L`0]06IVIP1c02d0103j
06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0IVIV04L0L`0509T0n@<06@1c
100207<01@040?T001Ac000DL`00;?T0IVIV00<002]c00D005gi0012L`00@W<0049c002?n@03001I
L`040030n@00L7<0071c001`L`800?7h0P00Lf000`1VIVH00?S?001cB@02001cB@03003hW@00Lc80
07<b008007<b0P00n6`2001c6`800?Pk0`00L`@2003h2@804W<000<0IVIV02Oh000Wn0000`0YL`02
05Sh00<0?g<00P29n00305Mc00<0^_L00`1]L`020>_g0080Lf8000<0IVIV07=R003gdP00101cB`02
0?NQ00<0Lc@000<000000?M`003gL000101c7@0U0?Lo0080joL01021KP020?OB00@0PE@00P3gX@04
084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>0080mj401P2HA@02
0?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0;0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;002
0?Lo00L0ZPX08@3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l00`3g
?`070;P;0240mPh03P3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037
300N0?H>04/0oooo001E0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H00`1VIVH0L`0]07<0;@04
0?X0H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`0306IVIP1707<0A`1c00D0V@3i0`0I
07<40080L`0500@0n@0057<001Ac000/n@1VIVH00`00:g<01@00GOT0049c0012L`00@W<008oi00<0
05Uc00@00<3i001`L`00L7<0071c0P00lOP2001cH00306IVIP00n<l007=9008007=900<00?RM001c
<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T2019c000306IVIP0Wn000
9oP000<0:G<00P1Hn00303mc0080ROP00`1GL`030;[g00<0KG<00P3[m`001@1cHP00IVIV07=R001c
HP00mm8000@0Ld/00P3gX@0307<d00030000003gL000mg0000@0Lad09@3g?`020>_g00@0PFh00P3g
dP04085D0080mj401021>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@00:0?M`00D0S@P0903f
3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102Z
C@030?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`
003gL0070;P_00<0mcl01`2h2`0Q0?H>00h0mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/0
7`3f3P0<0?M`00P0a``07P3f3P1;0?ooo`00E@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0
IVIV07<0;@1c02d0103j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`1VIVH0A`1c
04L0L`0509T0n@<06@1c100207<01@040?T001Ac000DL`1VIVH002ci008002]c0P00GOT30012L`05
002?n@00FG<005Uc001IL`00`?T00`00L7<2003an004001cH01VIVH007=P003hc`<007=900<00?RM
001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T00`0BL`00IVIV019c
000202Oh00<0:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00`2jm`0306ec00040>_g001c
HP00Lf8006IVIP80Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`001c7@00
101c7@0U0?Lo00030>_g0021KP00PFh000<0PFh00P3gdP04085D0080mj401021>`080?M`00D0P@L0
9@3f3P0308eL0080mj401@2=@00:0?M`00D0S@P0903f3P020?NQ00H0V4D00P3gL00609PW0080mcl0
1P2H2@0S0?H>00H0XTT02`3gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0240mPh0
0`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl01`2h2`0Q0?H>00h0
mg001`2m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1;0?ooo`00
E@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0L`0]0080L`0]103j06<207<0F`030?T0
a@1c0780L`1b0080n@3g0P1M07<0101VIVH0A`1c04L0L`1707<509T0n@<06@1c100207<01@040?T0
01Ac000DL`1VIVH002ci008002]c0P00GOT30012L`05002?n@00FG<005Uc001IL`00`?T00`00L7<0
1P00lOP007=P001cH01VIVH007=P003hc`<007=900<00?RM001c<P00Lc800P00Lc801000n6`007<K
001c6`00La/2003h>`<007<400D00?P9019c000BL`00IVIV019c000202Oh00<0:G<000<0F?P003mc
000oL`000P0oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001cHP00IVIV00<0Lf8000<0mm8007=;
001cB`000P1cB`020?NQ00<0Lc@000<000000?M`001c7@00101c7@0U0?Lo00030>_g0021KP00PFh0
00<0PFh00P3gdP04085D0080mj401021>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@00:0?M`
00D0S@P0903f3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0050:89
02<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102h
D`00mg000?M`003gL0070;P_00<0mcl01`2h2`0Q0?H>00h0mg001`2m2`0O0?H>00<0mg001`32<P04
0?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1;0?ooo`00E@3oool00`1VIVH0oooo0?ooo`070?oo
o`0307<05P1VIVH0L`0]0080L`0]103j06<207<0F`030?T0a@1c0780L`1b0080n@3g0P1M07<0101V
IVH0A`1c04L0L`1707<509T0n@806@1c00<0=P3i0080L`0207<00P0207<2000DL`0306IVIP00;?T0
02ci008002]c0P00GOT20012L`8008oi0`00FG<02000`?T0071c001`L`00L7<00?7h001cH01VIVH0
07=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c
1003003h2@0BL`00IVIV00804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc
0080ROP00`1GL`020;[g00@0KG<000<0joL007=R001VIVH00P1cHP020?OB00@0Ld/00P3gX@0307<d
00030000003gL000Lad000@0Lad09@3g?`000`3[m`00PFh0085^0003085^00030?OB0021E000PE@0
00<0PE@00P3gX@04084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>
0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT08`3f3P040:Y=
00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00d0mg001P2a2P0R0?H>00040;QC003gL000mg00
0?M`00L0^2l0103g?`070;P;0200mPh03P3gL0070;d;0200mPh00P3gL0070<8b00@0mcl020322`0O
0?H>00`0mg002037300N0?H>04/0oooo001E0?ooo`0306IVIP3oool0oooo00L0oooo00@0L`0F06IV
IP1c02d0L`0]1@3j06<207<0F`030?T0a@1c0780L`1b0080n@3g00<0G@1c06IVIP3:0?T00`1707<5
09T0n@806@1c00<0=P3i0080L`0207<00P0207<2000DL`0306IVIP00;?T002ci008002]c0P00GOT2
0012L`8008oi0`00FG<02000`?T0071c001`L`00L7<00?7h001cH01VIVH007=P0P00n<l3001cB@03
003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1003003h2@0BL`00IVIV
00804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`020;[g
00@0KG<000<0joL006IVIP1cHP000P1cHP020?OB00@0Ld/000L0mj4007<d001c=000Lc@00000001c
=000mg0000D0Lad09@3g?`000`3[m`00PFh0085^0003085^00030?OB0021E000PE@000<0PE@00P3g
X@04084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000X0mg001@2=200T0?H>0080mj401P2H
A@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT08`3f3P040:Y=00<0mg001`2Z
;0020?Lo00L0ZPX08@3f3P030;5@00d0mg001P2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0
103g?`070;P;0200mPh03P3gL0070;d;0200mPh00P3gL0080<8b00<0mcl020322`0O0?H>00`0mg00
2037300O0?H>04X0oooo001E0?ooo`0306IVIP3oool0oooo00H0oooo00<0L`0F06IVIP3j03400P1c
02d40?X0H`<0L`1K00<0n@3507<0LP1c07800P3i0?L00`1M07<0IVIV0<X0n@0304L0L`D0V@3i0P0I
07<00`0f0?T00P1c0080L`020080L`04000DL`1VIVH001Ac000/n@<002]c0P00GOT20012L`03002?
n@00FG<005Uc008005Uc00T00<3i001`L`00L7<0071c003an000Lf00IVIV001cH000n<l01000LdT0
0`00n9d007<b001c<P02001c<P04003hK000La/007<K001c6`800?Pk0`00L`@00`00n0T0IVIV019c
0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc
000205Mc0080^_L0101]L`000`3[m`00IVIV07=R000207=R0080mm80101cB`001`3gX@00Lc@007<d
001c=000000007<d003gL0001@1c7@0U0?Lo00030>_g0021KP00PFh000<0PFh000<0mm80085D0021
E0000`21E0000`3gX@00PC/0084k0003084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000X0
mg001@2=200T0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0
XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08@3f3P030;5@00d0mg001P2a2P0R0?H>0004
0;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh03P3gL0070;d;0200mPh00P3gL0080<8b
00<0mcl020322`0O0?H>00`0mg002037300O0?H>04X0oooo001E0?ooo`0306IVIP3oool0oooo00H0
oooo00<0L`0F06IVIP3j03400P1c02d40?X0H`<0L`1K00<0n@3507<0LP1c07800P3i0?L00`1VIVH0
G@1c0<X0n@0304L0L`D0V@3i0P0I07<02@0f0?T00P1c0080L`0207<0103i000DL`1VIVH001Ac000/
n@03000[L`8005gi0P00@W<00`00SoT005Uc001IL`02001IL`060030n@00L7<0071c001`L`00lOP0
IVIV0P00Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b001c<P800?Q/0`00La/00`00
n3/007<4001c1002001c1003003h2@1VIVH04W<000804W<000<09oP002Uc000YL`000P0YL`000`1H
n000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec000306IVIP1cHP00Lf80
0080Lf800P3gdP0407=;00070?NQ001c=000Lc@007<d00000000Lc@00?M`000507<M02D0mcl000<0
joL0085^0021KP000`21KP000`3gdP00PE@0085D0003085D00030?NQ0021>`00PC/000<0PC/0203g
L005084702D0mPh00`2=G0020?NQ00D0SD002P3gL00508d802@0mPh00P3gX@0609Q50080mg001P2H
9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0S0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z
2P0Q0?H>00<0/E003@3gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/0
803f3P0>0?M`00P0_@/07`3f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303gL0080<L<01l0mPh0
BP3oool005D0oooo00<0IVIV0?ooo`3oool01P3oool00`1VIVH0L`0F0?X0<@0207<0;@@0nP1S0`1c
05/00`3i0<D0L`1b07<0LP020?T0m`0306IVIP1M07<0bP3i00<0A`1c1@2I0?T201T0L`0603H0n@02
07<00P1c0080L`040?T0IVIV0P0057<01000;?T002]c000[L`00:g<2001Mn@80049c00@008oi001I
L`00FG<005Uc0P00`?T3001`L`05003an01VIVH007=P001cH000n<l01000LdT01000n9d007<b001c
<P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`1VIVH04W<0019c0002019c000302Oh
000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L0
0`1]L`000`1VIVH0joL007=R000307=R0080mm80101cB`001`3gX@00Lc@007<d001c=000000007<d
003gL0001@1c7@0U0?Lo00030>_g0021KP00PFh00080PFh00P3gdP05085D00030?NQ0021>`00PC/0
00<0PC/0203gL005084702D0mPh00`2=G0020?NQ00D0SD002P3gL00508d802@0mPh00P3gX@0609Q5
0080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0S0?H>00@0ZTd00`3gL0070:X/
0080mcl01`2Z2P0Q0?H>00<0/E003@3gL0070;4:0240mPh000@0^5<00?M`003gL000mg001`2h;`04
0?Lo00L0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S800`3g?`08
0<8;01l0mPh0303gL0080<L<01l0mPh0BP3oool005D0oooo00<0IVIV0?ooo`3oool01P3oool00`1V
IVH0L`0F0?X0<@0207<0;@@0nP1S0`1c05/307<0LP80n@3g00<0IVIV05d0L`3:0?T00P1707<509T0
n@<06@1c00H0=P3i0080L`0207<00P1c00@0n@1VIVH2000DL`04000/n@00:g<002]c000[L`8005gi
0P00@W<01000SoT005Uc001IL`00FG<20030n@<0071c00D0IVIV001cH000Lf0007=P003hc`04001c
B@04003hW@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c100306IVIP0BL`00
4W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00
Eg<00080Eg<00P2jm`0306ec000306IVIP3[m`00Lf8000<0Lf800P3gdP0407=;00050?NQ001c=000
Lc@007<d000000000P3gL00507<M02D0mcl000<0joL0085^0021KP000P21KP020?OB00D0PE@000<0
mj40084k0021>`000`21>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@00:0?M`00D0S@P0903f
3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0050:8902<0mPh0102Z
C@030?M`00L0ZR`00P3g?`070:X:0240mPh00`2aD00=0?M`00L0/@X08@3f3P00102hD`00mg000?M`
003gL0070;P_00@0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0O0?H>0080mg00
2032<P040?Lo00L0`P/07`3f3P0<0?M`00P0a``07`3f3P1:0?ooo`00E03oool00`1VIVH0oooo0?oo
o`060?ooo`0406IVIP1c01H0L`0F0?X0<@80L`0]103j06<307<0F`<0L`1b00D0n@3g06IVIP1M07<0
G@1c0<X0n@0204L0L`D0V@3i0`0I07<01P0f0?T00P1c0080L`0207<0103i06IVIP8001Ac00@002ci
000[L`00:g<002]c0P00GOT20012L`04002?n@00FG<005Uc001IL`800<3i0`00L7<01@1VIVH007=P
001cH000Lf000?S?00@007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`06003h>`00L`@007<4
001c101VIVH00?P9100BL`000`0Wn000:G<002Uc000202Uc000405Sh000oL`00?g<003mc0080ROP0
101GL`020;[g0080KG<000<0IVIV06ec003[m`00101cHP020?OB00@0Ld/000D0mj4007<d001c=000
Lc@0000000020?M`00D0Lad09@3g?`000`3[m`00PFh0085^0002085^0080mm801@21E0000`3gX@00
PC/0084k0003084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e000X0mg00102=200U0?H>0080
mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT08`3f3P040:Y=00<0
mg001`2Z;0020?Lo00L0ZPX08P3f3P020;5@00d0mg001`2a2P0Q0?H>00040;QC003gL000mg000?M`
00L0^2l0103g?`070;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh00P3gL0080<8b
00@0mcl01`322`0O0?H>00`0mg002@37300N0?H>04X0oooo001D0?ooo`0306IVIP3oool0oooo00H0
oooo00@0IVIV07<05P1c01H0nP0a0P1c02d40?X0H`<0L`1K0`1c07801@3i0?L0IVIV05d0L`1M07<0
bP3i0080A`1c1@2I0?T301T0L`0503H0n@0207<00P1c0080L`1VIVH00`0057<01@00;?T002]c000[
L`00:g<005gi00<0049c00@008oi001IL`00FG<005Uc0P00`?T2001`L`0306IVIP00lOP007=P0080
07=P00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00H00?Pk001c
1000L`@007<406IVIP00n0T4019c000402Oh000YL`00:G<002Uc0080F?P00`0oL`0208Wh00@0Eg<0
0P2jm`0206ec000306IVIP1]L`00joL000@0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@0
07<d001c=00000000080mg001@1c7@0U0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080
mj401@21>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@00:0?M`00@0S@P09@3f3P020?NQ00H0
V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0050:8902<0mPh0102ZC@030?M`00L0
ZR`00P3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08@3f3P00102hD`00mg000?M`003gL0070;P_
00@0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0O0?H>0080mg002032<P040?Lo
00L0`P/0803f3P0;0?M`00T0a``07P3f3P1:0?ooo`00E03oool00`1VIVH0oooo0?ooo`060?ooo`03
06IVIP1c01H0L`0F00<0L`0]103j06<207<0F`050?T0a@1c0780L`1b07<0LP1VIVH00`1M07<00`3:
0?T0A`1c04L0L`0509T0n@<06@1c00D0=P3i0080L`0207<00P1c06IVIP03000DL`05000/n@00:g<0
02]c000[L`00GOT00`00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c00<0IVIV003an000Lf00
0P00Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b001c<P800?Q/0`00La/01P00n3/0
07<4001c101VIVH007<4003h2@<04W<00P0Wn00302Uc0080F?P00`0oL`0208Wh00@0Eg<00P2jm`00
0`1]L`00IVIV06ec00020>_g00@0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d001c
=00000000080mg00101c7@0V0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080mj401@21
>`080?M`00D0P@L09@3f3P0308eL0080mj401@2=@00:0?M`00@0S@P09@3f3P020?NQ00H0V4D00P3g
L00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0050:8902<0mPh0102ZC@030?M`00L0ZR`00P3g
?`070:X:0280mPh00`2aD00<0?M`00L0/@X08@3f3P020;QC0080mg001`2h;`040?Lo00L0^0/0803f
3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`070<8;0200mPh0303g
L0080<L<01h0mPh0BP3oool005@0oooo00<0IVIV0?ooo`3oool01@3oool0101VIVH0oooo07<05P1c
01H307<0;@@0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780IVIV00<0G@1c00<0bP3i04L0L`1707<0
1@2I0?T301T0L`<00P1c00<0IVIV00@0n@0057<00P0057<01@00;?T002]c000[L`00:g<005gi00<0
049c00D008oi001IL`00FG<005Uc0030n@02001`L`0306IVIP00lOP00?7h00<007=P00@00?S?001c
B@00LdT007=90P00n9d3001c<P800?Q/0`00La/01P00n3/007<4001c101VIVH007<4003h2@<04W<0
0P0Wn00302Uc0080F?P00`0oL`0208Wh00@0Eg<00P2jm`000`1]L`00IVIV06ec00020>_g00@0Lf80
00<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d001c=00000000080mg00101c7@060>Tl0200
mcl000<0joL0085^0021KP000P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@211`0U0?H>00<0
SE`00P3gX@0508e000X0mg00102=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0
mPh01P2RB@0<0?M`00D0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0
mg001`2a2P0Q0?H>0080^5<00`3gL0060;P_00@0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0
mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07P3f3P1:0?ooo`00
E03oool00`1VIVH0oooo0?ooo`050?ooo`0406IVIP3oool0L`0F07<05P<0L`0]103j06<207<0F`05
0?T0a@1c0780L`1b06IVIP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c0`0207<0101V
IVH0103i000DL`0057<2000/n@<002]c00D005gi0012L`00@W<0049c002?n@03001IL`040030n@00
L7<0071c06IVIP800?7h0`00Lf001000n<l007=9001cB@00LdT2003hW@<007<b0P00n6`3001c6`04
003h>`00L`@0IVIV001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`030;[g
000306IVIP1]L`00KG<00080joL0101cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@0
07<d000000000P3gL00307<M00`0jC`06`3g?`000`3[m`00PFh0085^0002085^0080mm801021E002
0?NQ00D0PC/0203gL005084702D0mPh00`2=G0020?NQ00D0SD002P3gL00408d802D0mPh00P3gX@06
09Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0S0?H>00@0ZTd00`3gL007
0:X/0080mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:0240mPh00P2hD`030?M`00H0^2l0103g?`07
0;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O
0?H>00`0mg002037300N0?H>04X0oooo001D0?ooo`0306IVIP3oool0oooo00@0oooo00D0IVIV0?oo
o`3oool0L`0F0?X0<@0307<0;@@0nP1S0P1c05/01@3i0<D0L`1b07<0LP1VIVH0n@3g00<0G@1c0`17
07<509T0n@<06@1c0P0207<00`1VIVH00P1c00@0n@02000DL`8002ci0`00:g<01@00GOT0049c0012
L`00@W<008oi00<005Uc00@00<3i001`L`1VIVH0071c0P00lOP3001cH005003hc`00LdT007=9001c
B@00n9d01000Lc82003hK08007<K0P00n3/00`00L`@0IVIV001c1002003h2@<04W<00P0Wn00302Uc
0080F?P00`0oL`0208Wh00<0Eg<00`2jm`000`1VIVH0KG<006ec00020>_g00@0Lf8000<0mm8007=;
001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL0000`1c7@0A0>Tl01H0mcl000<0joL0085^
0021KP000P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@211`0U0?H>00<0SE`00P3gX@0508e0
00X0mg00102=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`
00D0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0Q0?H>
0080^5<00`3gL0060;P_00@0mcl01`2h2`0Q0?H>00d0mg00202m2`0O0?H>00<0mg001`32<P040?Lo
00P0`P/07`3f3P0<0?M`00P0a``07`3f3P190?ooo`00E03oool00`1VIVH0oooo0?ooo`040?ooo`05
06IVIP3oool0oooo07<05P3j03400`1c02d40?X0H`80L`1K00<0n@3507<0LP1VIVH00P3i0?L305d0
L`<0A`1c1@2I0?T301T0L`800P1c00<0IVIV0080L`040?T00P0057<2000/n@8002]c0P00GOT30012
L`08002?n@00FG<005Uc001IL`00`?T0071c06IVIP00L7<2003an0<007=P00D00?S?001cB@00LdT0
07=9003hW@04001c<P04003hK000La/007<K001c6`800?Pk00<0IVIV001c1000L`@00P00n0T3019c
00809oP00`0YL`0205Sh00<0?g<00P29n00305Mc0080^_L000@0IVIV06ec001]L`00KG<00P3[m`04
07=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg000080Lad0603Y?00@
0?Lo00030>_g0021KP00PFh00080PFh00P3gdP04085D0080mj401@21>`080?M`00D0P@L09@3f3P03
08eL0080mj401@2=@00:0?M`00@0S@P09@3f3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S
0?H>00H0XTT0303gL0050:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00<
0?M`00L0/@X08@3f3P020;QC00<0mg001`2h;`030?Lo00L0^0/08@3f3P0=0?M`00P0_@/07`3f3P03
0?M`00L0`S80103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0B@3oool005@0oooo00<0IVIV0?oo
o`3oool00`3oool01P1VIVH0oooo0?ooo`3oool0L`0F0?X0<@80L`0]1@3j06<207<0F`030?T0a@1c
0780IVIV0080n@3g0`1M07<304L0L`D0V@3i0P0I07<00`0f0?T00P1c06IVIP020080L`<001Ac0P00
;?T2000[L`8005gi0P00@W<2002?n@<005Uc00D00<3i06IVIP00L7<0071c003an004001cH005003h
c`00LdT007=9001cB@00n9d01000Lc801000n6`007<K001c6`00La/2003h>`0306IVIP00L`@007<4
00800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`020;[g000406IVIP1]L`00KG<0
06ec0080joL0101cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=00010000000mg000?M`001c
7@0N0>Tl00/0mcl000<0joL0085^0021KP000P21KP020?OB00@0PE@00P3gX@05084k00P0mg001@21
1`0U0?H>00<0SE`00P3gX@0508e000X0mg00102=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g
?`0609P902<0mPh01P2RB@0<0?M`00D0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f
3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh0
3P3gL0070;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037300O0?H>04T0oooo
001D0?ooo`0306IVIP3oool0oooo00<0oooo00<0IVIV0?ooo`3oool00P1c01H00`3j0340L`0]07<0
;@050?X0H`80L`1K00<0n@3506IVIP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i
0P0I07<00`0f0?T00P1c06IVIP020080L`<001Ac0P00;?T2000[L`8005gi0P00@W<2002?n@<005Uc
00D00<3i06IVIP00L7<0071c003an004001cH005003hc`00LdT007=9001cB@00n9d01000Lc801P00
n6`007<K001c6`00La/00?Pk06IVIP<007<40P00n0T3019c00809oP00`0YL`000`1Hn000?g<003mc
000203mc0080ROP00`1GL`000`2jm`00IVIV0;[g000306ec0080joL0101cHP000`3gdP00Ld/007=;
000207=;0080mj400`1c=00010000000mg000?M`001c7@0S0>Tl00H0mcl000<0joL0085^0021KP00
0P21KP020?OB00@0PE@00P3gX@05084k00P0mg0010211`0V0?H>00<0SE`00P3gX@0508e000X0mg00
102=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT0
8`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC
003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL0070<8b00@0
mcl020322`0O0?H>00`0mg002037300O0?H>04T0oooo001D0?ooo`0306IVIP3oool0oooo0080oooo
00@0IVIV0?ooo`3oool0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`<0L`1K00<0n@3506IVIP1c
07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0P0I07<00`0f0?T0IVIV0080L`020080
L`<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01@1VIVH0071c001`L`00
L7<00?7h00<007=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b00H00?Q/001c6`00La/007<K
003h>`1VIVH3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000
?g<003mc000203mc0080ROP00`1GL`000`2jm`00IVIV0;[g000306ec00030>_g001cHP00Lf8000<0
Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL000:@3Y?0020>_g00@0
PFh00P3gdP04085D0080mj401@21>`080?M`00@0P@L01P3Y3P0P0?H>00<0SE`00P3gX@0508e000T0
mg001@2=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0
XPT08`3f3P050:Y=0080mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>0004
0;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL0070<8b
00@0mcl020322`0O0?H>00`0mg002037300O0?H>04T0oooo001D0?ooo`0306IVIP3oool0oooo0080
oooo00@0IVIV0?ooo`3oool0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`<0L`1K00<0n@3506IV
IP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0P0I07<01@0f0?T0IVIV0080L`02
07<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01@1VIVH0071c
001`L`00L7<00?7h00<007=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b00H00?Q/001c6`00
La/007<K06IVIP00n3/3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`00
0`1Hn000?g<003mc000203mc0080ROP00`1GL`000`1VIVH0^_L006ec000306ec00030>_g001cHP00
Lf8000<0Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003Y?000:@3Y?002
0>_g00@0PFh00P3gdP04085D0080mj401@21>`080?M`00<0P@L0303Y3P0K0?H>0080SE`00`3gX@05
08e000T0mg001@2=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<
0?M`00D0XPT08`3f3P050:Y=0080mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R
0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3g
L0080<8b00<0mcl020322`0O0?H>00`0mg002037300O0?H>04T0oooo001D0?ooo`0306IVIP3oool0
oooo0080oooo00@0IVIV0?ooo`3oool0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`<0L`1K00<0
IVIV07<0LP1c07800P3i0?L205d0L`030<X0n@1707<0A`1c00H0V@3i0P0I07<01@1VIVH00P1c0080
L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`06002?n@00FG<005Uc001I
L`1VIVH00<3i0`00L7<01@00lOP007=P001cH000Lf000?S?00@007=900<00?RM001c<P00Lc800P00
Lc801P00n6`007<K001c6`00La/0IVIV003h>`<007<400<00?P9019c000BL`000P0BL`000`0Wn000
:G<002Uc000202Uc000305Sh000oL`00?g<00080?g<00P29n00305Mc000306IVIP2jm`00KG<000<0
KG<000<0joL007=R001cHP000`1cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`000000
mg000?M`00050?M`02<0jC`000<0Nh400>_g003[m`001021KP020?OB00@0PE@00P3gX@05084k00P0
mg000`211`0A0>T>01H0mPh00P2=G0030?NQ00D0SD002@3gL00508d802D0mPh00P3gX@0609Q50080
mg001P2H9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0S0?H>00D0ZTd00P3gL0070:X/0080
mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo
00L0^0/08@3f3P0>0?M`00L0_@/0803f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303gL0090<L<
01h0mPh0B@3oool005<0oooo00<0IVIV0?ooo`3oool00P3oool00`1VIVH0oooo0?ooo`020?ooo`80
L`0F00<0nP0a07<0;@1c02d0103j06<307<0F`0306IVIP1c0780L`1b0080n@3g0P1M07<00`3:0?T0
A`1c04L0L`0509T0n@<06@1c00D0IVIV0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c
000[L`8005gi0P00@W<01P00SoT005Uc001IL`00FG<0IVIV0030n@<0071c00D00?7h001cH000Lf00
07=P003hc`04001cB@04003hW@00Lc8007<b001c<P800?Q/0P00La/00`1VIVH00?Pk001c1003001c
1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc
0080ROP00P1GL`000`1VIVH0^_L00;[g000406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;
00030?NQ001c=000Lc@00080Lc@000<000000?M`003gL0002P3gL00N0>Tl000307^1003[m`00joL0
00@0PFh00P3gdP04085D0080mj401@21>`080?M`0080P@L0603Y3P0@0?H>0080SE`00`3gX@0508e0
00T0mg001@2=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`
00D0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo00H0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>
00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL008
0<8b00@0mcl01`322`0O0?H>00`0mg002@37300N0?H>04T0oooo001C0?ooo`0306IVIP3oool0oooo
0080oooo00<0IVIV0?ooo`3oool00P3oool207<05P030?X0<@1c02d0L`0]00@0nP1S0P1c05/0101V
IVH0L`1b07<0LP1c07820?T0m`80G@1c00<0bP3i04L0L`1707<01@2I0?T201T0L`0306IVIP0f0?T0
0P1c00800P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<01000SoT005Uc001I
L`1VIVH20030n@<0071c00D00?7h001cH000Lf0007=P003hc`04001cB@04003hW@00Lc8007<b001c
<P800?Q/0P00La/00`1VIVH00?Pk001c1003001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`000`1Hn000?g<003mc000203mc000508Wh001GL`00Eg<005Mc001VIVH00P2jm`04
06ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00060?NQ001c=000Lc@007<d00000000Lc@0
4@3gL00H0>Tl000407^1003[m`00joL00>_g00@0PFh00P3gdP04085D0080mj401021>`090?M`0003
0847003Y3P00j@h001`0j@h02`3f3P0208eL00<0mj401@2=@0090?M`00D0S@P09@3f3P020?NQ00H0
V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0050:8902@0mPh0102ZC@020?M`00L0
ZR`00`3g?`060:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_
00<0mcl01`2h2`0Q0?H>00h0mg00202m2`0O0?H>0080mg002032<P040?Lo00L0`P/0803f3P0;0?M`
00T0a``07P3f3P190?ooo`00D`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00D0oooo0P1c01H307<0
;@@0nP1S0P1c05/0101VIVH0L`1b07<0LP1c07820?T0m`80G@1c00<0bP3i04L0L`1707<01@2I0?T2
01T0L`0306IVIP0f0?T00P1c00800P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0P00
@W<01000SoT005Uc001IL`1VIVH20030n@<0071c00D00?7h001cH000Lf0007=P003hc`04001cB@04
003hW@00Lc8007<b001c<P800?Q/00@007<K06IVIP00La/00?Pk1000L`@00`00n0T04W<0019c0002
019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`001@29n000Eg<005Mc001V
IVH0Eg<00080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm80101cB`001P3gX@00Lc@007<d
001c=000000007<d01L0mg004@3Y?00207^10080joL01@21KP020?OB00@0PE@00P3gX@04084k00T0
mg0000<0P@L00>T>003Y3P008@3Y3P060?H>0080SE`00`3gX@0508e000T0mg001@2=200U0?H>0080
mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT0903f3P040:Y=0080
mg001`2Z;0030?Lo00H0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`
00L0^2l00`3g?`080;P;0200mPh03P3gL0080;d;01l0mPh00P3gL0080<8b00@0mcl01`322`0P0?H>
00`0mg002037300N0?H>04T0oooo001C0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH01@3oool207<0
5P<0L`0]103j06<00`1c05/0IVIV0?T0a@0307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<5
09T0n@806@1c00<0IVIV03H0n@0207<00P0207<01@040?T001Ac000DL`0057<002ci00<002]c00P0
05gi0012L`00@W<0049c002?n@00FG<0IVIV001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf00
0?S?00@007=900@00?RM001c<P00Lc8007<b0P00n6`01000La/0IVIV001c6`00n3/4001c1003003h
2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc000508Wh
001GL`00Eg<006IVIP1GL`000P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;0006
0?NQ001c=000Lc@007<d00000000Lc@0703gL00<0>Tl0080Nh400P3[m`05085^0080mm801021E002
0?NQ00@0PC/02@3gL00Y0>T>00<0SE`00`3gX@0508e000T0mg001@2=200U0?H>0080mj401P2HA@02
0?M`00H0V2L00P3g?`0609P902<0mPh01P2RB@0<0?M`00D0XPT0903f3P040:Y=0080mg001`2Z;003
0?Lo00H0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g
?`070;P;0200mPh03P3gL0080;d;01l0mPh00P3gL0080<8b00@0mcl01`322`0P0?H>00`0mg002037
300O0?H>04P0oooo001C0?ooo`0406IVIP3oool0oooo06IVIPH0oooo0P1c01H307<0;@@0nP1S00<0
L`1K06IVIP3i0<D00`1c07801@3i0?L0G@1c05d0L`1M07<0bP3i0080A`1c1@2I0?T0100I07<0IVIV
01T0L`0f0?T30080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<02@00GOT0049c0012L`00@W<0
08oi001IL`1VIVH005Uc0030n@04001`L`05003an000Lf0007=P001cH000n<l01000LdT01000n9d0
07<b001c<P00Lc82003hK00406IVIP00La/007<K003h>`@007<400<00?P9019c000BL`000P0BL`00
0`0Wn000:G<002Uc000202Uc000305Sh000oL`00?g<00080?g<000<0ROP005Mc001VIVH00P1GL`02
0;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/000@0mj4007<d001c=000Lc@00`00
000P0?M`00H0jC`00`1kP@020>_g00D0PFh00P3gdP04085D0080mj401021>`080?M`02X0j@h00`2=
G0030?NQ00D0SD002@3gL00508d802D0mPh00P3gX@0609Q50080mg001P2H9`020?Lo00H0V0T08`3f
3P060:9900`0mg001@2R2@0T0?H>00@0ZTd00P3gL0070:X/00<0mcl01P2Z2P0R0?H>00<0/E00303g
L0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/0803f3P000`2mEP00mg00
0?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0
B03oool005<0oooo00@0IVIV0?ooo`3oool0IVIV1P3oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S
00<0IVIV07<0F`3i0<D00`1c07801@3i0?L0G@1c05d0L`1M07<0bP3i0080A`1c1@2I0?T00`0I07<0
IVIV01T0L`040080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<01P00GOT0049c0012L`00@W<0
08oi06IVIP8005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH003003hc`00LdT007=9008007=9
00@00?RM001c<P00Lc8007<b0P00n6`0101VIVH007<K001c6`00n3/4001c1003003h2@0BL`004W<0
00804W<000@09oP002Uc000YL`00:G<00P1Hn00303mc0080ROP000@0Eg<006IVIP1GL`00Eg<00P2j
m`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00050?NQ001c=000Lc@007<d00000000
0P3gL00200000280mg0000<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj40
1021>`0>0?M`02<0j@h0102=G0030?NQ00D0SD002@3gL00508d802D0mPh00P3gX@0609Q50080mg00
1P2H9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0T0?H>00@0ZTd00P3gL0070:X/00<0mcl0
1P2Z2P0R0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0
^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`080<8;01l0
mPh0303gL0080<L<01l0mPh0B03oool005<0oooo00@0IVIV0?ooo`3oool0IVIV1P3oool00`1c01H0
nP0a07<0;@0207<0;@@0nP1S00<0IVIV07<0F`3i0<D00`1c0780103i0?L0G@1c05d0L`1M07<304L0
L`D0V@3i00<0IVIV01T0L`0I07<0100207<00`040?T001Ac000DL`02000/n@<002]c00H005gi0012
L`00@W<0049c002?n@1VIVH2001IL`040030n@00L7<0071c001`L`800?7h0`00Lf001000n<l007=9
001cB@00LdT2003hW@<007<b00<00?Q/06IVIP00La/00P00La/00`00n3/007<4001c1002001c1004
003h2@0BL`004W<0019c00809oP00`0YL`0205Sh00<0?g<00P29n000101VIVH0Eg<005Mc001GL`02
0;[g00@0KG<000<0joL007=R001cHP000P1cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000
Lc@007<d000000009P3gL0000`2jm`00Nh4007^1000207^10080joL01@21KP000`3gdP00PE@0085D
0003085D0080mj401021>`0C0?M`01h0j@h0102=G0030?NQ00D0SD002@3gL00508d802D0mPh00P3g
X@0609Q50080mg001P2H9`020?Lo00H0V0T08`3f3P060:9900`0mg001@2R2@0T0?H>00@0ZTd00P3g
L0070:X/00<0mcl01`2Z2P0Q0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg00
1`2h;`040?Lo00L0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/07`3f3P030?M`00L0`S80
103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0B03oool005<0oooo00<0IVIV0?ooo`1VIVH01`3o
ool0101c01H0nP0a07<0;@1c02d40?X0H`0406IVIP1c05/0L`1K0?T0a@80L`1b0P3i0?L305d0L`<0
A`1c1@2I0?T00`1VIVH06@1c01T0L`040080L`0300@0n@0057<001Ac008002ci0P00:g<2001Mn@<0
049c00D008oi06IVIP00FG<005Uc0030n@03001`L`800?7h0`00Lf001000n<l007=9001cB@00LdT2
003hW@<007<b00<00?Q/06IVIP00La/00P00La/01000n3/007<4001c1000L`@2003h2@<04W<00P0W
n00302Uc0080F?P00`0oL`0208Wh000406IVIP1GL`00Eg<005Mc0080^_L00`1]L`020>_g00@0Lf80
00<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d001c=000000002H0mg0000<0^_L007^1001k
P@000P1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/0603gL00H0>T>00D0
SE`00`3gX@0508e000T0mg001@2=200U0?H>0080mj401P2HA@020?M`00H0V2L00P3g?`0609P902<0
mPh01P2RB@0<0?M`00D0XPT0903f3P040:Y=0080mg001`2Z;0030?Lo00L0ZPX08@3f3P030;5@00`0
mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh000<0_EH00?M`
003gL0002`3gL0080;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037300O0?H>
04P0oooo001C0?ooo`0306IVIP3oool0IVIV00H0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`04
06IVIP1c05/0L`1K0?T0a@80L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`@0V@3i00@0IVIV
01T0L`0I07<06@1c100207<00`040?T001Ac000DL`02000/n@8002]c0P00GOT30012L`0506IVIP00
FG<005Uc001IL`00`?T00`00L7<2003an0<007=P00D00?S?001cB@00LdT007=9003hW@04001c<P03
06IVIP00n6`007<K008007<K00@00?Pk001c1000L`@007<40P00n0T3019c00809oP00`0YL`0205Sh
00<0?g<000<0ROP006IVIP1GL`000`1GL`020;[g00<0KG<00P3[m`0407=R00030?OB001cB`00Ld/0
00<0Ld/000D0mj4007<d001c=000Lc@00000000V0?M`00030;[g001kP@00Nh400080Nh400P3[m`05
085^00030?OB0021E000PE@000<0PE@00P3gX@04084k01h0mg004@3Y3P000`3gdP00SE`008eL0003
08eL00<0mj401@2=@0090?M`00D0S@P09@3f3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S
0?H>00H0XTT0303gL0050:8902@0mPh0102ZC@020?M`00L0ZR`00`3g?`070:X:0240mPh00`2aD00<
0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0P0?H>00030;eF003g
L000mg0000/0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07`3f
3P180?ooo`00D`3oool206IVIPL0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`0406IVIP1c05/0
L`1K0?T0a@80L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`@0V@3i00@0IVIV01T0L`0I07<0
=P3i100207<3000DL`8002ci0P00:g<2001Mn@80049c00<008oi06IVIP00FG<00P00FG<01000`?T0
071c001`L`00L7<2003an0<007=P00D00?S?001cB@00LdT007=9003hW@04001c<P0406IVIP00La/0
07<K001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn00302Uc0080F?P00`0oL`000`29n000IVIV05Mc
000205Mc00<0^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d
001c=000000002H0mg001@1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0000`3gX@00PC/0
084k0003084k02<0mg00303Y3P000`3gdP00SE`008eL000308eL00<0mj401@2=@0090?M`00D0S@P0
9@3f3P020?NQ00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0
102ZC@020?M`00L0ZR`00`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg00
0?M`003gL0070;P_00@0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0O0?H>00<0
mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07`3f3P180?ooo`00D`3oool206IVIPL0oooo
0P1c01H00`3j0340L`0]07<0;@030?X0H`0506IVIP1c05/0L`1K07<0F`3i0<D00P1c07820?T0m`80
G@1c00@0bP3i04L0L`1707<0A`1c0`2I0?T01@1VIVH0V@3i01T0L`0I07<0=P3i00@00P1c0`0057<0
1000;?T002]c000[L`00:g<2001Mn@80049c00<0IVIV002?n@00FG<00P00FG<01@00`?T0071c001`
L`00L7<00?7h00@007=P00D00?S?001cB@00LdT007=9003hW@03001c<P0306IVIP00n6`007<K0080
07<K0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc000306IVIP29n000Eg<00080
Eg<00`2jm`0306ec0080joL0101cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@007<d
000000009P3gL00507^10080joL01021KP020?OB00D0PE@000<0mj40084k0021>`000`21>`0T0?M`
00@0QXd01P3Y3P000`2=N000mm8008eL000408eL00<0mj40102=@00:0?M`00D0S@P09@3f3P020?NQ
00H0V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@020?M`
00L0ZR`00`3g?`070:X:0240mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL007
0;P_00@0mcl01`2h2`0Q0?H>00d0mg00202m2`0P0?H>0080mg001`32<P040?Lo00P0`P/07`3f3P0<
0?M`00P0a``07`3f3P180?ooo`00DP3oool206IVIPP0oooo0P1c01H00`3j0340L`0]07<0;@030?X0
H`0406IVIP1c05/0L`1K07<0F`<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`<0V@3i00D0
IVIV09T0n@0I07<06@1c03H0n@030080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@80
049c00<0IVIV002?n@00FG<00P00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P0P00n<l3001c
B@06003hW@00Lc8007<b001c<P1VIVH00?Q/0`00La/2003h>`<007<40P00n0T3019c00809oP00`0Y
L`0205Sh00<0?g<000<0IVIV08Wh001GL`000P1GL`030;[g00<0KG<00P3[m`0407=R00030?OB001c
B`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0002@0mg001@1kP@020>_g00@0PFh00P3g
dP05085D00030?NQ0021>`00PC/000<0PC/0903gL00408J=00030>_g002=N000SGP000@0SGP000<0
mm8008eL002=G0000`2=G0030?NQ00@0SD002P3gL00508d802D0mPh00P3gX@0609Q50080mg001P2H
9`020?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00P3gL0070:X/00<0mcl01`2Z
2P0Q0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/0
8@3f3P0=0?M`00P0_@/0803f3P020?M`00L0`S80103g?`080<8;01l0mPh0303gL0090<L<01h0mPh0
B03oool00580oooo0P1VIVH80?ooo`80L`0F00<0nP0a07<0;@1c02d00P3j06<00`1VIVH0nP1S07<0
F`0207<0F`<0L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00<0V@3i00<0IVIV09T0n@2I0?T00P0I
07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT01000@W<0
IVIV002?n@00SoT3001IL`050030n@00L7<0071c001`L`00lOP00`00Lf02003hc`<007=900H00?RM
001c<P00Lc80IVIV001c<P00n6`3001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn00302Uc000505Sh
000oL`00?g<003mc001VIVH00P29n00305Mc00<0^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001c
B`000P1cB`020?NQ00<0Lc@000<000000?M`003gL0008`3gL0000`2jm`00Nh4007^1000307^10080
joL01021KP020?OB00D0PE@000<0mj40084k0021>`000`21>`0T0?M`00@0QXd000<0joL008eh002=
N000102=N0000`3gdP00SE`008eL000308eL00<0mj40102=@00:0?M`00D0S@P09@3f3P020?NQ00H0
V4D00P3gL00609PW0080mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@020?M`00L0
ZR`00`3g?`070:X:0240mPh00`2aD00=0?M`00H0/@X08P3f3P020;QC0080mg001`2h;`040?Lo00L0
^0/08@3f3P0>0?M`00L0_@/0803f3P020?M`00P0`S800`3g?`080<8;01l0mPh0303gL0090<L<01h0
mPh0B03oool00580oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]0080nP1S
00<0IVIV0?X0H`1c05/00P1c05/307<0LP80n@3g0P1M07<00`3:0?T0A`1c04L0L`0309T0n@0306IV
IP2I0?T06@1c00806@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c000[
L`8005gi00<0049c06IVIP00SoT01000FG<01@00`?T0071c001`L`00L7<00?7h00<007=P00<00?S?
001cB@00LdT00P00LdT01P00n9d007<b001c<P1VIVH007<b003hK0<007<K0P00n3/3001c1003003h
2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`001@1Hn000?g<003mc000oL`00IVIV0080
ROP00`1GL`030;[g00<0KG<000<0joL007=R001cHP000`1cHP000`3gdP00Ld/007=;000207=;0080
mj400P1c=0000`1VIVH000000?M`000T0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`04085^0080
mm801@21E0000`3gX@00PC/0084k0003084k02@0mg001026S@000`3[m`00SGP008eh000308eh0080
mm801@2=G0030?NQ00@0SD002P3gL00508d802D0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00H0
V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00P3gL0070:X/00<0mcl01`2Z2P0Q0?H>00<0
/E003@3gL0070;4:0240mPh00P2hD`020?M`00L0^2l0103g?`070;P;0240mPh03P3gL0070;d;0200
mPh00P3gL0080<8b00<0mcl020322`0P0?H>00/0mg002@37300N0?H>04P0oooo001B0?ooo`<0IVIV
1`3oool207<05P<0L`0]00@0nP1S06IVIP3j06<0nP1S0`1c05/307<0LP80n@3g0P1M07<00`3:0?T0
A`1c04L0L`0209T0n@0306IVIP2I0?T0V@3i00<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000D
L`04000/n@00:g<002]c000[L`8005gi00<0IVIV0012L`00SoT00`00FG<20030n@<0071c00D00?7h
001cH000Lf0007=P003hc`04001cB@03003hW@00Lc80IVIV008007<b00@00?Q/001c6`00La/007<K
0P00n3/3001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`001@1Hn000?g<0
03mc001VIVH0?g<00080ROP00`1GL`030;[g00<0KG<000<0joL007=R001cHP000`1cHP000`3gdP00
Ld/007=;000207=;0080mj400P1c=0000`1VIVH000000?M`000T0?M`00030;[g001kP@00Nh4000<0
Nh400P3[m`04085^0080mm801@21E0000`3gX@00PC/0084k0003084k02@0mg001026S@000`3[m`00
SGP008eh000308eh0080mm801@2=G0030?NQ00@0SD002P3gL00508d802D0mPh00P3gX@0609Q50080
mg001@2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0
mcl01`2Z2P0Q0?H>00<0/E003@3gL0070;4:0240mPh00P2hD`030?M`00H0^2l0103g?`070;P;0240
mPh03P3gL0070;d;0200mPh00P3gL0080<8b00@0mcl01`322`0P0?H>00`0mg002037300O0?H>04L0
oooo001B0?ooo`0306IVIP3oool0oooo00H0IVIV00<0oooo07<05P1c01H00`1c02d0103j06<0IVIV
0?X0H`3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0209T0
n@0306IVIP2I0?T0V@3i00<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<0
02]c000[L`8005gi00<0IVIV0012L`00SoT00`00FG<20030n@<0071c00D00?7h001cH000Lf0007=P
003hc`04001cB@04003hW@00Lc80IVIV001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003
003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`001@1Hn000?g<003mc001VIVH0?g<0
0080ROP00`1GL`020;[g00@0KG<000<0joL007=R001cHP000`1cHP000`3gdP00Ld/007=;000207=;
0080mj4000@0Lc@006IVIP1c=00000009@3gL0000`2jm`00Nh4007^1000307^10080joL01021KP02
0?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh000308eh0080mm801@2=G003
0?NQ00@0SD002P3gL00508d802D0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00H0V0T08`3f3P06
0:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0mcl01`2Z2P0Q0?H>00<0/E003@3gL007
0;4:0240mPh00P2hD`030?M`00L0^2l00`3g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL008
0<8b00@0mcl01`322`0P0?H>00`0mg002037300O0?H>04L0oooo001B0?ooo`0306IVIP3oool0oooo
00H0oooo00<0IVIV07<05P1c01H00`1c02d0101VIVH0nP1S0?X0H`3j06<207<0F`050?T0a@1c0780
L`1b07<0LP3i0?L00`1M07<01@3:0?T0A`1c04L0L`2I0?T0IVIV00<0V@3i0`0I07<01@0f0?T00P1c
0080L`0207<0103i00<001Ac00H002ci000[L`00:g<002]c001Mn@1VIVH20012L`04002?n@00FG<0
05Uc001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf000?S?00@007=900@00?RM06IVIP00Lc80
07<b0P00n6`3001c6`03003h>`00L`@007<4008007<400<00?P9019c000BL`000P0BL`000`0Wn000
:G<002Uc000202Uc000305Sh000oL`00IVIV0080?g<00P29n00305Mc0080^_L0101]L`000`3[m`00
Lf8007=R000307=R00030?OB001cB`00Ld/00080Ld/00P3gX@00101c=000IVIV07<d0000000U0?M`
00030;[g001kP@00Nh4000<0Nh400P3[m`04085^0080mm801021E0020?NQ00D0PC/0903gL00408J=
00030>_g002=N000SGP000<0SGP00P3gdP0508eL00<0mj40102=@00:0?M`00D0S@P09@3f3P020?NQ
00H0V4D00P3gL00509PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`
00H0ZR`00`3g?`070:X:0240mPh00`2aD00=0?M`00L0/@X08@3f3P020;QC00<0mg001`2h;`030?Lo
00L0^0/08@3f3P0>0?M`00L0_@/0803f3P020?M`00P0`S80103g?`070<8;0200mPh0303gL0080<L<
01l0mPh0A`3oool00580oooo00<0IVIV0?ooo`3oool01`3oool00`1c01H0nP0a07<0;@0207<0;@04
06IVIP3j06<0nP1S0?X0H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`050<X0n@1707<0
A`1c09T0n@1VIVH00`2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01P00;?T002]c
000[L`00:g<005gi06IVIP80049c00@008oi001IL`00FG<005Uc0P00`?T3001`L`05003an000Lf00
07=P001cH000n<l01000LdT01000n9d0IVIV001c<P00Lc82003hK0<007<K00<00?Pk001c1000L`@0
0P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc001VIVH0
0P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm80
101cB`020?NQ000406IVIP1c=000Lc@0000002D0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0
PFh00P3gdP04085D0080mj401@21>`0T0?M`00@0QXd000<0joL008eh002=N0000`2=N0020?OB00D0
SE`00`3gX@0408e000X0mg001@2=200U0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`0609P902<0
mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08@3f3P030;5@00d0
mg001`2a2P0Q0?H>0080^5<00`3gL0070;P_00<0mcl01`2h2`0Q0?H>00h0mg00202m2`0O0?H>0080
mg002032<P040?Lo00P0`P/07`3f3P0<0?M`00P0a``07`3f3P170?ooo`00DP3oool00`1VIVH0oooo
0?ooo`070?ooo`0307<05P3j0340L`0]0080L`0]00@0IVIV0?X0H`3j06<0nP1S0P1c05/01@3i0<D0
L`1b07<0LP1c0780n@3g00<0G@1c00D0bP3i04L0L`1707<0V@3i06IVIP0309T0n@<06@1c100207<0
1@040?T001Ac000DL`0057<002ci00<002]c00D0IVIV0012L`00@W<0049c002?n@03001IL`030030
n@00L7<0071c0080071c00D00?7h001cH000Lf0007=P003hc`04001cB@0406IVIP00Lc8007<b001c
<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`000`1Hn000IVIV03mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec
00030>_g001cHP00Lf800080Lf800P3gdP0407=;00030?NQ001c=000IVIV0080Lc@000<000000?M`
003gL0008`3gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00@0PE@00P3gX@05084k
02@0mg001026S@000`3[m`00SGP008eh000308eh0080mm801@2=G0030?NQ00@0SD002P3gL00508d8
02D0mPh00P3gX@0609Q50080mg001@2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>
00@0ZTd00`3gL0060:X/00<0mcl01`2Z2P0Q0?H>00<0/E003@3gL0070;4:0280mPh000@0^5<00?M`
003gL000mg001`2h;`030?Lo00L0^0/08@3f3P0>0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`08
0<8;01l0mPh0303gL0080<L<01l0mPh0A`3oool00580oooo00<0IVIV0?ooo`3oool01`3oool01@1c
01H0nP0a07<0;@1c02d0IVIV00@0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c0`17
07<00`1VIVH0V@3i09T0n@0209T0n@<06@1c100207<00`040?T001Ac000DL`02000/n@<002]c00D0
IVIV0012L`00@W<0049c002?n@03001IL`040030n@00L7<0071c001`L`800?7h0`00Lf000`00n<l0
07=9001cB@02001cB@0406IVIP00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c
1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1VIVH0?g<003mc000203mc
000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;
00030?NQ001VIVH0Lc@00080Lc@000<000000?M`003gL0008`3gL0000`2jm`00Nh4007^1000307^1
0080joL01021KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh000308eh
0080mm801@2=G0020?NQ00D0SD002P3gL00508d802D0mPh00P3gX@0609Q50080mg001@2H9`030?Lo
00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0060:X/00<0mcl01`2Z2P0R0?H>
0080/E003@3gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`030?Lo00L0^0/08@3f3P0>
0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0A`3oool0
0580oooo00<0IVIV0?ooo`3oool01P3oool207<05P040?X0<@1c02d0L`0]06IVIP@0nP1S0P1c05/0
0`3i0<D0L`1b07<0LP020?T0m`<0G@1c0`1707<00`1VIVH0V@3i09T0n@0209T0n@<06@1c100207<0
0`040?T001Ac000DL`02000/n@8002]c00<0IVIV001Mn@00@W<00P00@W<01@00SoT005Uc001IL`00
FG<00<3i00<0071c0P00lOP3001cH006003hc`00LdT007=9001cB@1VIVH00?RM0`00Lc82003hK0<0
07<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000602Oh000YL`00:G<002Uc
001Hn000IVIV100oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R0002
07=R0080mm80101cB`001P3gX@00IVIV07<d001c=000000007<d02D0mg0000<0^_L007^1001kP@00
0`1kP@020>_g00@0PFh00P3gdP04085D0080mj401@21>`0T0?M`00@0QXd000<0joL008eh002=N000
0`2=N0020?OB00D0SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj401P2HA@020?M`00D0V2L0
0`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX0
8P3f3P020;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240
mPh03P3gL0080;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037300O0?H>04L0
oooo001B0?ooo`0306IVIP3oool0oooo00H0oooo0P1c01H00`3j0340L`0]06IVIP040?X0H`<0L`1K
00<0n@3507<0LP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c06IVIPD0V@3i0`0I07<40080L`03
00@0n@0057<001Ac008002ci0P00:g<00`1VIVH005gi0012L`020012L`05002?n@00FG<005Uc001I
L`00`?T00`00L7<2003an0<007=P00H00?S?001cB@00LdT007=906IVIP00n9d3001c<P800?Q/0`00
La/00`00n3/007<4001c1002001c1004003h2@0BL`004W<0019c00809oP00`0YL`000`1VIVH0F?P0
03mc000203mc0080ROP0101GL`020;[g00@0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/0
00H0IVIV07<d001c=000Lc@00000001c=00U0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`04085^
0080mm801021E0020?NQ00D0PC/0903gL00308J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e0
00X0mg001@2=200U0?H>0080mj401P2HA@020?M`00D0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`
00H0XPT08`3f3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>
00040;QC003gL000mg000?M`00L0^2l00`3g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL008
0;d;01l0mPh00`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002037300O0?H>04L0oooo001B0?oo
o`0306IVIP3oool0oooo00H0oooo0P1c01H00`3j0340L`0]06IVIP040?X0H`<0L`1K00<0n@3507<0
LP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c06IVIPD0V@3i0P0I07<00`0f0?T00P1c0080L`02
0080L`<001Ac0P00;?T01000:g<0IVIV001Mn@00GOT20012L`8008oi0`00FG<01000`?T0071c001`
L`00L7<2003an0<007=P00@00?S?001cB@00LdT0IVIV0P00n9d3001c<P800?Q/0`00La/01000n3/0
07<4001c1000L`@2003h2@<04W<00P0Wn00302Uc000306IVIP1Hn000?g<00080?g<00P29n00405Mc
0080^_L0101]L`000`3[m`00Lf8007=R000207=R0080mm80101cB`001P1VIVH0Lc@007<d001c=000
000007<d02D0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP04085D0080mj401@21
>`0T0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD002P3gL00508d802D0mPh00P3g
X@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f
3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003g
L000mg000?M`00L0^2l00`3g?`080;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;01l0mPh0
0`3gL0070<8b00@0mcl020322`0O0?H>00`0mg002@37300N0?H>04L0oooo001A0?ooo`0306IVIP3o
ool0oooo00L0oooo0P1c01H00`3j0340IVIV07<0;@040?X0H`<0L`1K00<0n@3507<0LP1c07800P3i
0?L205d0L`040<X0n@1707<0IVIV04L0L`D0V@3i0P0I07<00`0f0?T00P1c0080L`020080L`<001Ac
00@002ci000[L`00:g<0IVIV0P00GOT20012L`8008oi0`00FG<01000`?T0071c001`L`00L7<2003a
n0<007=P00D00?S?001cB@00LdT0IVIV003hW@04001c<P800?Q/0`00La/01000n3/007<4001c1000
L`@2003h2@<04W<00P0Wn00202Uc000306IVIP1Hn000F?P000<0?g<00P29n00405Mc0080^_L0101]
L`000`3[m`00Lf8007=R000207=R00030?OB001cB`00Ld/00080Ld/000<0IVIV0?NQ001c=0000P1c
=0000`000000mg000?M`000T0?M`00030;[g001kP@00Nh400080Nh400`3[m`04085^0080mm801021
E0020?NQ00D0PC/0903gL00308J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e000X0mg001@2=
200U0?H>0080mj401P2HA@000`3gL000V2L009PW000409PW00<0mcl01P2H2@0S0?H>00H0XTT0303g
L0060:8902<0mPh0102ZC@030?M`00H0ZR`00`3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f
3P00102hD`00mg000?M`003gL0070;P_00<0mcl0202h2`0P0?H>00030;eF003gL000mg0000/0mg00
202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07P3f3P170?ooo`00D@3o
ool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0nP0a06IVIP1c02d0103j06<307<0F`<0L`1b0P3i
0?L205d0L`040<X0n@1707<0IVIV04L0L`D0V@3i0P0I07<00`0f0?T00P1c0080L`020080L`<001Ac
00@002ci000[L`1VIVH002]c0P00GOT20012L`8008oi0`00FG<01@00`?T0071c001`L`00L7<00?7h
00@007=P00D00?S?001cB@1VIVH007=9003hW@04001c<P04003hK000La/007<K001c6`800?Pk0`00
L`@2003h2@<04W<00P0Wn00202Uc000306IVIP1Hn000F?P000<0?g<00P29n00405Mc0080^_L00`1]
L`020>_g00@0Lf8000<0mm8007=;001cB`000P1cB`000`1VIVH0mj4007<d000207<d00030000003g
L000mg0002@0mg0000<0^_L007^1001kP@000P1kP@030>_g00@0PFh00P3gdP04085D0080mj401@21
>`0T0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD002P3gL00508d802D0mPh00P3g
X@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f
3P040:Y=00<0mg001P2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003g
L000mg000?M`00L0^2l0103g?`070;P;0200mPh000<0_EH00?M`003gL0002`3gL0080;d;0200mPh0
0P3gL0070<8b00@0mcl020322`0O0?H>00`0mg002@37300O0?H>04H0oooo001A0?ooo`0306IVIP3o
ool0oooo00L0oooo0P1c01H00`1VIVH0L`0]07<0;@040?X0H`<0L`1K0`1c07820?T0m`80G@1c00<0
bP3i06IVIP1707<01@2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01000;?T002]c
06IVIP00:g<2001Mn@80049c0P00SoT3001IL`050030n@00L7<0071c001`L`00lOP00`00Lf02003h
c`04001cB@1VIVH007=9003hW@@007<b00@00?Q/001c6`00La/007<K0P00n3/3001c10800?P90`0B
L`0202Oh000302Uc001VIVH0:G<00080F?P00`0oL`0208Wh00<0Eg<00`2jm`0306ec0080joL0101c
HP001`3gdP00Ld/007=;001cB`00IVIV07=;003gX@000`1c=0000`000000mg000?M`000T0?M`0003
0;[g001kP@00Nh400080Nh400P3[m`05085^0080mm801021E0020?NQ00D0PC/0903gL00308J=0080
joL01@2=N0020?OB00D0SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj401P2HA@000`3gL000
V2L009PW000409PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00H0
ZR`00`3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_
00@0mcl01`2h2`0P0?H>00030;eF003gL000mg0000/0mg00202m2`0P0?H>0080mg001`32<P040?Lo
00P0`P/0803f3P0<0?M`00P0a``07`3f3P160?ooo`00D@3oool00`1VIVH0oooo0?ooo`070?ooo`80
L`0F00<0IVIV07<0;@1c02d0103j06<307<0F`<0L`1b0P3i0?L205d0L`030<X0n@1VIVH0A`1c00D0
V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci06IVIP00:g<002]c0P00GOT2
0012L`8008oi0`00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P0P00n<l0101VIVH007=9001c
B@00n9d4001c<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn0000`0YL`00
IVIV02Uc000205Sh00<0?g<00P29n00305Mc00<0^_L00`1]L`020>_g00@0Lf8000@0mm8007=;001c
B`00IVIV0P1cB`001@3gX@00Lc@007<d001c=000000002H0mg0000<0^_L007^1001kP@000P1kP@02
0>_g00D0PFh00P3gdP04085D0080mj401021>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G002
0?NQ00D0SD002P3gL00508d802D0mPh00P3gX@0609Q500030?M`002H9`00V2L000@0V2L00`3g?`06
09P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P03
0;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0200mPh000<0
_EH00?M`003gL0002`3gL0080;d;0200mPh00P3gL0080<8b00<0mcl020322`0P0?H>00`0mg002037
300O0?H>04H0oooo001A0?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F06IVIP1c02d00P1c02d4
0?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`0306IVIP1707<0A`1c00D0V@3i0`0I
07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci06IVIP00:g<002]c0P00GOT20012L`03
002?n@00FG<005Uc008005Uc00D00<3i001`L`00L7<0071c003an003001cH0800?S?00@0IVIV001c
B@00LdT00?RM1000Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c00809oP000<0
IVIV02Uc000YL`000P1Hn00303mc0080ROP00`1GL`030;[g00<0KG<00P3[m`0407=R00040?OB001c
B`00Ld/006IVIP80Ld/000D0mj4007<d001c=000Lc@00000000V0?M`00030;[g001kP@00Nh400080
Nh400P3[m`05085^0080mm801021E0020?NQ00@0PC/09@3gL00308J=0080joL01@2=N0020?OB00D0
SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj401P2HA@000`3gL000V2L009PW000409PW00<0
mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280
mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0P0?H>
00030;eF003gL000mg0000/0mg00202m2`0P0?H>0080mg002032<P030?Lo00P0`P/0803f3P0<0?M`
00P0a``07`3f3P160?ooo`00D@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0L`0]0080
L`0]103j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`1VIVH0A`1c04L0L`0509T0
n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`0406IVIP00:g<002]c000[L`8005gi0P00
@W<01000SoT005Uc001IL`00FG<20030n@<0071c00H00?7h001cH000Lf0007=P003hc`1VIVH3001c
B@03003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c10800?P90`0BL`00
0`0Wn000:G<006IVIP0202Uc0080F?P00`0oL`0208Wh00<0Eg<00`2jm`0306ec0080joL0101cHP00
0`3gdP00Ld/006IVIP0207=;0080mj400`1c=0000`000000mg000?M`000T0?M`00030;[g001kP@00
Nh400080Nh400P3[m`05085^0080mm801021E0020?NQ00@0PC/09@3gL00308J=0080joL01@2=N002
0?OB00D0SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj401P2HA@000`3gL000V2L009PW0004
09PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`07
0:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h
2`0Q0?H>00d0mg00202m2`0P0?H>0080mg002032<P040?Lo00L0`P/0803f3P0<0?M`00P0a``07`3f
3P160?ooo`00D@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0L`0]0080L`0]103j06<2
07<0F`050?T0a@1c0780L`1b07<0LP3i0?L00P1M07<0101VIVH0bP3i04L0L`1707<509T0n@<06@1c
00D0=P3i0080L`0207<00P1c00@0n@03000DL`0406IVIP00:g<002]c000[L`8005gi0P00@W<01000
SoT005Uc001IL`00FG<20030n@<0071c00H00?7h001cH000Lf0007=P003hc`1VIVH3001cB@03003h
W@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1003003h2@0BL`004W<00080
4W<000<09oP006IVIP0YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`030;[g00<0
KG<00P3[m`0407=R00030?OB001cB`00IVIV0080Ld/00P3gX@0307<d00030000003gL000mg0002@0
mg0000<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401021>`0U0?M`00<0
QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD002P3gL00508d802D0mPh00P3gX@0509Q50080
mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0070:X/0080
mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo
00L0^0/08@3f3P0>0?M`00L0_@/0803f3P020?M`00P0`S80103g?`070<8;0200mPh0303gL0080<L<
01l0mPh0AP3oool00540oooo00<0IVIV0?ooo`3oool01`3oool00`1VIVH0nP0a07<0;@0207<0;@@0
nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g0080G@1c00@0IVIV0<X0n@1707<0A`1c1@2I0?T3
01T0L`0503H0n@0207<00P1c0080L`040?T00P0057<00`1VIVH002ci000[L`02000[L`05001Mn@00
@W<0049c0012L`00SoT00`00FG<20030n@<0071c00D00?7h001cH000Lf0007=P06IVIP04001cB@04
003hW@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<0
00804W<000<09oP006IVIP0YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`030;[g
00<0KG<000<0joL007=R001cHP000`1cHP000`3gdP00IVIV07=;000207=;0080mj400`1c=0000`00
0000mg000?M`000T0?M`00030;[g001kP@00Nh400080Nh400P3[m`05085^00030?OB0021E000PE@0
00<0PE@00P3gX@04084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL0080mj401@2=@00:0?M`
00D0S@P09@3f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:89
02<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P00102h
D`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>00h0mg001`2m2`0P0?H>0080mg002032<P04
0?Lo00P0`P/07`3f3P0<0?M`00P0a``07`3f3P160?ooo`00D@3oool00`1VIVH0oooo0?ooo`070?oo
o`0406IVIP3j0340L`0]07<0;@D0nP1S0P1c05/0203i0<D0L`1b07<0LP1c0780n@3g05d0L`1VIVH0
G@1c0`1707<509T0n@<06@1c100207<01@040?T001Ac000DL`1VIVH002ci00<002]c00D005gi0012
L`00@W<0049c002?n@03001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf00IVIV00@007=900@0
0?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400<00?P9019c000BL`00
0P0BL`000`1VIVH0:G<002Uc000202Uc000305Sh000oL`00?g<00080?g<00P29n00305Mc00<0^_L0
0`1]L`000`3[m`00Lf8007=R000307=R00030?OB001VIVH0Ld/00080Ld/00P3gX@0307<d00030000
003gL000mg0002@0mg001@1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/0
9@3gL00308J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj40
1@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg00
1`2Z;0020?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0
^2l0103g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL0080<8b00@0mcl020322`0O0?H>00`0
mg002037300O0?H>04H0oooo001A0?ooo`0306IVIP3oool0oooo00H0oooo00<0IVIV07<05P3j0340
0P1c02d50?X0H`80L`1K00<0n@3507<0LP1c07800P3i0?L00`1M07<0IVIV05d0L`0304L0L`D0V@3i
0`0I07<40080L`0500@0n@0057<001Ac06IVIP00;?T00`00:g<01@00GOT0049c0012L`00@W<008oi
00<005Uc0P00`?T3001`L`05003an000Lf0007=P06IVIP00n<l01000LdT01000n9d007<b001c<P00
Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000306IVIP0Y
L`00:G<00080:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00P2jm`0406ec00030>_g001c
HP00Lf8000<0Lf8000<0IVIV07=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL000903g
L00507^10080joL01@21KP000`3gdP00PE@0085D0003085D0080mj401021>`0U0?M`00<0QXd00P3[
m`0508eh0080mm801@2=G0020?NQ00D0SD002P3gL00508d802D0mPh00P3gX@0509Q50080mg001P2H
9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z
2P0R0?H>00<0/E00303gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/0
8@3f3P0>0?M`00P0_@/07`3f3P020?M`00P0`S80103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0
AP3oool00540oooo00<0IVIV0?ooo`3oool01P3oool00`1VIVH0L`0F0?X0<@0207<0;@@0nP1S0`1c
05/00`3i0<D0L`1b07<0LP020?T0m`0305d0L`1VIVH0G@1c00<0A`1c1@2I0?T301T0L`@00P1c00<0
103i000DL`1VIVH00P00;?T3000[L`05001Mn@00@W<0049c0012L`00SoT00`00FG<01000`?T0071c
001`L`00L7<2003an08007=P00<0IVIV003hc`00LdT00`00LdT01000n9d007<b001c<P00Lc82003h
K0<007<K00<00?Pk001c1000L`@00P00L`@01P00n0T04W<0019c000BL`00IVIV02Oh00@0:G<000<0
F?P003mc000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R
000307=R000306IVIP1cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0002@0mg001@1k
P@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/09@3gL00308J=0080joL01@2=
N0020?OB00D0SE`00P3gX@0508e000X0mg001@2=200U0?H>0080mj401@2HA@020?M`00H0V2L00`3g
?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f
3P030;5@00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh0
3P3gL0080;d;01l0mPh00P3gL0080<8b00@0mcl020322`0O0?H>00`0mg002037300O0?H>04H0oooo
001@0?ooo`0306IVIP3oool0oooo00H0oooo00@0IVIV07<05P1c01H0nP0a0P1c02d40?X0H`<0L`1K
00<0n@3507<0LP1c07800P3i0?L00`1VIVH0G@1c0<X0n@0304L0L`D0V@3i0`0I07<40080L`0300@0
n@0057<0IVIV008002ci0`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc00@00<3i001`L`00
L7<0071c0P00lOP01000Lf00IVIV001cH000n<l4001cB@04003hW@00Lc8007<b001c<P800?Q/0`00
La/00`00n3/007<4001c1002001c1006003h2@0BL`004W<0019c001VIVH09oP0100YL`000`1Hn000
?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`0406ec00030>_g001cHP00Lf800080
Lf8000<0IVIV0?OB001cB`000`1cB`020?NQ00<0Lc@000<000000?M`003gL0008`3gL0000`2jm`00
Nh4007^1000307^10080joL01021KP020?OB00D0PE@00P3gX@04084k02D0mg000`26S@020>_g00D0
SGP00P3gdP0508eL0080mj401@2=@00:0?M`00D0S@P09@3f3P020?NQ00D0V4D00P3gL00609PW00<0
mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280
mPh00`2aD00<0?M`00L0/@X08P3f3P020;QC0080mg001`2h;`040?Lo00L0^0/08@3f3P0>0?M`00P0
_@/07`3f3P030?M`00L0`S80103g?`080<8;01l0mPh0303gL0090<L<01h0mPh0AP3oool00500oooo
00<0IVIV0?ooo`3oool01P3oool0101VIVH0L`0F07<05P3j034207<0;@@0nP1S0`1c05/00`3i0<D0
L`1b07<0LP020?T0m`0306IVIP1M07<0bP3i00<0A`1c1@2I0?T201T0L`0303H0n@0207<00P1c0080
0P1c00<001Ac06IVIP0057<00P00;?T2000[L`8005gi0`00@W<01@00SoT005Uc001IL`00FG<00<3i
00<0071c0P00lOP01000Lf00IVIV001cH000n<l3001cB@800?RM0`00Lc82003hK0<007<K00<00?Pk
001c1000L`@00P00L`@01P00n0T04W<0019c001VIVH04W<002Oh00@0:G<000<0F?P003mc000oL`00
0P0oL`000`29n000Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R000207=R000306IV
IP3gdP00Ld/000<0Ld/000<0mj4007<d001c=0000P1c=0000`000000mg000?M`000S0?M`00030;[g
001kP@00Nh4000<0Nh400P3[m`04085^0080mm801@21E0000`3gX@00PC/0084k0003084k02D0mg00
0`26S@020>_g00D0SGP00P3gdP0408eL00<0mj401@2=@00:0?M`00@0S@P09P3f3P020?NQ00D0V4D0
0P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`0
0P3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P020;QC0080mg001`2h;`040?Lo00L0^0/0
8@3f3P0>0?M`00P0_@/07`3f3P030?M`00L0`S80103g?`080<8;01l0mPh0303gL0090<L<01l0mPh0
A@3oool00500oooo00<0IVIV0?ooo`3oool01@3oool01@1VIVH0oooo07<05P1c01H0nP0a0080L`0]
103j06<307<0F`<0L`1b00D0n@3g06IVIP1M07<0G@1c0<X0n@0304L0L`D0V@3i0P0I07<00`0f0?T0
0P1c0080L`020080L`04000DL`1VIVH001Ac000/n@<002]c0P00GOT20012L`8008oi0`00FG<01000
`?T0071c001`L`00L7<2003an00406IVIP00Lf0007=P003hc`<007=90P00n9d3001c<P800?Q/0`00
La/00`00n3/007<4001c1002001c1006003h2@0BL`004W<006IVIP0BL`009oP00`0YL`0205Sh00@0
?g<000<0ROP005Mc000000000P0000020;[g0080KG<00`00000307=R000306IVIP3gdP00mm8000@0
Ld/000<0mj4007<d001c=0000P1c=0000`000000mg000?M`000S0?M`00030;[g001kP@00Nh4000<0
Nh400P3[m`04085^0080mm801@21E0000`3gX@00PC/0084k0003084k02D0mg000`26S@020>_g00D0
SGP00P3gdP0408eL00<0mj401@2=@00:0?M`00@0S@P01P3W3@0P0?H>0080mj401@2HA@020?M`00H0
V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0
ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>0080^5<00P3gL0070;P_00@0mcl01`2h2`0Q0?H>00h0
mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07`3f3P150?ooo`00
D03oool00`1VIVH0oooo0?ooo`050?ooo`0506IVIP3oool0L`0F07<05P3j03400P1c02d40?X0H`<0
L`1K0`1c07801@3i0?L0IVIV05d0L`1M07<0bP3i0080A`1c1P2I0?T201T0L`0303H0n@0207<00P1c
00800P1c00@0IVIV000DL`0057<002ci0`00:g<2001Mn@80049c0P00SoT3001IL`040030n@00L7<0
071c001`L`800?7h00@0IVIV001cH000Lf000?S?0`00LdT2003hW@<007<b0P00n6`3001c6`03003h
>`00L`@007<4008007<400@00?P9019c001VIVH04W<00P0Wn00302Uc0080F?P00`0oL`0208Wh0008
0000001GL`00Eg<005Mc00000000^_L006ec0000000206ec00050>_g00000000Lf8006IVIP1cHP00
0P3gdP0407=;00030?NQ001c=000Lc@00080Lc@000<000000?M`003gL0008`3gL0000`2jm`00Nh40
07^1000307^10080joL01021KP020?OB00D0PE@000<0mj40084k0021>`000`21>`0T0?M`00@0QXd0
0P3[m`0508eh0080mm80102=G0030?NQ00D0SD002P3gL00308d800`0i`d06`3f3P020?NQ00D0V4D0
0P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`0
0P3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo00L0^0/0
8@3f3P0>0?M`00P0_@/07`3f3P030?M`00L0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0
A@3oool00500oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0oooo0?ooo`0207<05P<0L`0]103j
06<307<0F`<0L`1b00D0IVIV0?T0m`1M07<0G@1c0<X0n@0204L0L`D0V@3i0`0I07<01P0f0?T00P1c
0080L`0207<0103i06IVIP8001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<0
1P00`?T0071c001`L`00L7<00?7h06IVIP<007=P00D00?S?001cB@00LdT007=9003hW@04001c<P80
0?Q/0`00La/01000n3/007<4001c1000L`@2003h2@03019c001VIVH04W<000809oP00`0YL`0205Sh
00<0?g<00P29n00020000000Eg<005Mc001GL`0000000;[g001]L`0000000P1]L`001@3[m`000000
07=R001VIVH0Lf800080mm80101cB`001P3gX@00Lc@007<d001c=000000007<d02D0mg0000<0^_L0
07^1001kP@000`1kP@020>_g00@0PFh00P3gdP05085D00030?NQ0021>`00PC/000<0PC/0903gL004
08J=0080joL01@2=N0020?OB00@0SE`00`3gX@0508e000X0mg000`2=200A0>L=01H0mPh00P3gX@05
09Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL007
0:X/0080mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:0280mPh00P2hD`030?M`00L0^2l00`3g?`07
0;P;0240mPh03P3gL0080;d;01l0mPh00`3gL0070<8b00@0mcl020322`0P0?H>00`0mg002037300O
0?H>04D0oooo001@0?ooo`0306IVIP3oool0oooo00@0oooo00<0IVIV0?ooo`3oool00P1c01H307<0
;@@0nP1S0P1c05/01P3i0<D0L`1b07<0LP1c0780IVIV0?T0m`80G@1c00<0bP3i04L0L`1707<01@2I
0?T301T0L`0503H0n@0207<00P1c0080L`1VIVH00`0057<01000;?T002]c000[L`00:g<2001Mn@80
049c0P00SoT3001IL`060030n@00L7<0071c001`L`00lOP0IVIV0P00Lf02003hc`<007=900<00?RM
001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@007<4001c10800?P900<0
IVIV019c000BL`000P0Wn00302Uc0080F?P00`0oL`0208Wh00080000001GL`00Eg<005Mc00000000
^_L006ec0000000206ec00030>_g00000000IVIV0080Lf800P3gdP0407=;00060?NQ001c=000Lc@0
07<d00000000Lc@09@3gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@000<0
mj40084k0021>`000`21>`0T0?M`00@0QXd00P3[m`0508eh0080mm80102=G0030?NQ00D0SD002P3g
L00208d801P0i`d0403f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303g
L0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f
3P020;QC00<0mg001`2h;`030?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f
3P020?M`00L0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0A@3oool00500oooo00<0IVIV
0?ooo`3oool0103oool01@1VIVH0oooo0?ooo`1c01H0nP0a00<0L`0]103j06<207<0F`050?T0a@1c
0780L`1b06IVIP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c00D0=P3i0080L`0207<0
0P1c06IVIP03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<2002?n@<005Uc00D00<3i001`
L`00L7<0071c06IVIP03001cH0800?S?0`00LdT00`00n9d007<b001c<P02001c<P04003hK000La/0
07<K001c6`800?Pk0`00L`@2003h2@0306IVIP0BL`004W<000809oP00`0YL`0205Sh00<0?g<00P29
n00400000080^_L000L0KG<00000001]L`00KG<00>_g00000000IVIV0080Lf8000<0mm8007=;001c
B`000`1cB`001P3gX@00Lc@007<d001c=000000007<d02D0mg0000<0^_L007^1001kP@000`1kP@02
0>_g00@0PFh00P3gdP04085D0080mj401@21>`0T0?M`00@0QXd00P3[m`0508eh0080mm80102=G003
0?NQ00D0SD002P3gL00208d801d0i`d02`3f3P020?NQ00D0V4D00P3gL00609PW00<0mcl01P2H2@0S
0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00<
0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;
0?M`00P0_@/0803f3P020?M`00P0`S800`3g?`080<8;0200mPh0303gL0080<L<01l0mPh0A@3oool0
0500oooo00<0IVIV0?ooo`3oool00`3oool01P1VIVH0oooo0?ooo`3oool0L`0F0?X0<@<0L`0]103j
06<207<0F`050?T0a@1c0780L`1b06IVIP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c
00D0=P3i0080L`0207<0IVIV00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<01000
SoT005Uc001IL`00FG<20030n@<0071c00@0IVIV001cH000Lf0007=P0P00n<l3001cB@03003hW@00
Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c1003003h2@1VIVH04W<000804W<0
0P0Wn00302Uc0080F?P00`0oL`0208Wh00030000001GL`00Eg<000<0^_L000<0KG<00000001]L`00
0P3[m`001@000000Lf8007=R001cHP00mm8000D0Ld/000H0mj4007<d001c=000Lc@00000001c=00U
0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`04085^0080mm801021E0020?NQ00D0PC/0903gL004
08J=0080joL01@2=N0020?OB00@0SE`00`3gX@0508e000X0mg0000<0S@P00>L=003W3@008@3W3@06
0?H>0080mj401@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P04
0:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>00040;QC003gL000
mg000?M`00L0^2l00`3g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL0080;d;0200mPh00P3g
L0080<8b00<0mcl020322`0P0?H>00`0mg002037300O0?H>04D0oooo001@0?ooo`0306IVIP3oool0
oooo00<0oooo00H0IVIV0?ooo`3oool0oooo07<05P3j034307<0;@@0nP1S0P1c05/01@3i0<D0L`1b
06IVIP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T301T0L`0503H0n@0207<00P1c06IV
IP040?T00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c00@008oi001IL`00FG<005Uc0P00
`?T2001`L`0306IVIP00lOP007=P008007=P00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c
<P02001c<P04003hK000La/007<K001c6`800?Pk0`00L`@00`00n0T0IVIV019c0002019c00809oP0
0`0YL`0205Sh00<0?g<00P29n0000`000000Eg<005Mc00030;[g000306ec00000000KG<00080joL0
00D0000007=R001cHP00Lf800?OB000507=;00040?NQ001c=000Lc@007<d00@000008`3gL0000`2j
m`00Nh4007^1000307^10080joL01021KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@020>_g
00D0SGP00P3gdP0408eL00<0mj401@2=@00:0?M`000308d8003W3@00i`d002H0i`d00`3gX@0509Q5
0080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3gL0070:X/
0080mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`03
0?Lo00P0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P020?M`00P0`S80103g?`07
0<8;0200mPh0303gL0080<L<01l0mPh0A@3oool00500oooo00<0IVIV0?ooo`3oool00P3oool0101V
IVH0oooo0?ooo`3oool207<05P030?X0<@1c02d0L`0]00D0nP1S0P1c05/01@3i0<D0L`1b06IVIP1c
0780n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T301T0L`0503H0n@0207<0IVIV0080L`040?T0
0`0057<01@00;?T002]c000[L`00:g<005gi00<0049c00@008oi001IL`00FG<005Uc0P00`?T2001`
L`0306IVIP00lOP007=P008007=P00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c
<P04003hK000La/007<K001c6`800?Pk0`00L`@00`1VIVH00?P9019c0002019c00809oP00`0YL`02
05Sh00<0?g<00P29n0000`1GL`00000005Mc00030;[g000606ec00000000KG<00>_g001VIVH00000
0`1cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@007<d000000000`3gL00300000200
mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP04085D0080mj401@21>`0T0?M`00@0
QXd000<0joL008eh002=N000102=N0000`3gdP00SE`008eL000308eL00<0mj401@2=@00:0?M`02T0
i`d00`3gX@0509Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0
ZTd00`3gL0070:X/0080mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh000@0^5<00?M`003g
L000mg001`2h;`030?Lo00P0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P020?M`
00P0`S80103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0A@3oool00500oooo00<0IVIV0?ooo`3o
ool00P3oool0101VIVH0oooo0?ooo`3oool207<05P030?X0<@1c02d0L`0]00D0nP1S0P1c05/01@3i
0<D0IVIV07<0LP1c0780n@3g00<0G@1c0`1707<509T0n@<06@1c0P0207<00`1VIVH00P1c00@0n@03
000DL`05000/n@00:g<002]c000[L`00GOT00`00@W<01000SoT005Uc001IL`00FG<20030n@04001`
L`1VIVH0071c003an0<007=P00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c<P04
003hK000La/007<K001c6`800?Pk0`00L`@00`1VIVH00?P9019c0002019c000302Oh000YL`00:G<0
0080:G<00P1Hn00303mc0080ROP00P1GL`03000000030;[g001]L`00KG<000<00000101cHP000`3g
dP00Ld/007=;000307=;00050?NQ001c=000Lc@007<d000000009P3gL0000`2jm`00Nh4007^10003
07^10080joL01021KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh0004
08eh00030?OB002=G000SE`000<0SE`00`3gX@0508e000T0mg00:@3W3@00102HH`00mj400?NQ003g
X@0509Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0S0?H>00@0ZTd00`3g
L0070:X/0080mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh000@0^5<00?M`003gL000mg00
1`2h;`030?Lo00P0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P020?M`00P0`S80
103g?`080<8;01l0mPh0303gL0080<L<01l0mPh0A@3oool00500oooo00D0IVIV0?ooo`3oool0oooo
06IVIP040?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<207<0F`030?T0a@1VIVH0L`1b0080n@3g
0`1M07<304L0L`D0V@3i0`0I07<01@0207<0IVIV0080L`0207<0103i00<001Ac00D002ci000[L`00
:g<002]c001Mn@030012L`04002?n@00FG<005Uc001IL`800<3i00@0071c06IVIP00L7<00?7h0`00
Lf000`00n<l007=9001cB@02001cB@04003hW@00Lc8007<b001c<P800?Q/0`00La/01P00n3/007<4
001c1000L`@0IVIV003h2@@04W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc
0080ROP00`1GL`030;[g00<0KG<000<0IVIV0>_g001cHP000`1cHP000`3gdP00Ld/007=;000307=;
00050?NQ001c=000Lc@007<d000000009P3gL0000`2jm`00Nh4007^1000207^100<0joL01021KP02
0?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh000408eh00030?OB002=G000
SE`000<0SE`00`3gX@0508e000l0mg008P3W3@0209QS00<0mj401@2HA@020?M`00H0V2L00`3g?`06
09P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P03
0;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03@3g
L0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0O0?H>00`0mg002@37300O0?H>04@0oooo001?
0?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?ooo`3oool00P3oool207<05P030?X0<@1c02d0
L`0]00@0nP1S0`1c05/00`1VIVH0L`1b07<0LP020?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I
0?T301T0L`050080L`1VIVH00P1c0080L`040?T00`0057<01@00;?T002]c000[L`00:g<005gi00<0
049c00@008oi001IL`00FG<005Uc0P00`?T0101VIVH0071c001`L`00lOP3001cH003003hc`00LdT0
07=9008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`06003h>`00L`@007<4001c101VIVH0
0?P9100BL`000`0Wn000:G<002Uc000202Uc000305Sh000oL`00?g<00080?g<00P29n00305Mc00<0
^_L00`1]L`000`1VIVH0joL007=R000307=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d0003
0000003gL000mg0002@0mg0000<0^_L007^1001kP@000P1kP@030>_g00@0PFh00P3gdP04085D0080
mj401@21>`0T0?M`00@0QXd000<0joL008eh002=N000102=N0000`3gdP00SE`008eL000308eL00<0
mj401@2=@00E0?M`01/0i`d00`2HH`030?NQ00D0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0
XTT0303gL0060:8902<0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00=0?M`00L0
/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>00h0mg001`2m2`0P0?H>
0080mg002032<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07`3f3P140?ooo`00C`3oool01@1VIVH0
oooo0?ooo`3oool0IVIV00D0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`<0L`1K00<0IVIV07<0
LP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<01@1VIVH00P1c0080L`02
07<0103i008001Ac0P00;?T3000[L`05001Mn@00@W<0049c0012L`00SoT00`00FG<01000`?T0071c
06IVIP00L7<2003an0<007=P00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003h
K0<007<K00H00?Pk001c1000L`@0IVIV001c1000n0T4019c000302Oh000YL`00:G<00080:G<000<0
F?P003mc000oL`000P0oL`0208Wh00<0Eg<00`2jm`0206ec000306IVIP3[m`00Lf8000@0Lf8000<0
mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1
000207^10080joL01@21KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh
000408eh00030?OB002=G000SE`000<0SE`00`3gX@0508e001/0mg005@3W3@0309QS00<0mj401@2H
A@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z
;0020?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0
103g?`070;P;0240mPh03P3gL0070;d;0200mPh00P3gL0080<8b00@0mcl020322`0O0?H>00`0mg00
2@37300O0?H>04@0oooo001?0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH01@3oool207<05P030?X0
<@1c02d0L`0]00@0nP1S0`1c05/00`1VIVH0L`1b07<0LP020?T0m`80G@1c00@0bP3i04L0L`1707<0
A`1c1@2I0?T201T0L`0303H0n@1VIVH00P1c00800P1c0`0057<2000/n@8002]c0P00GOT30012L`08
002?n@00FG<005Uc001IL`00`?T0071c06IVIP00L7<2003an0<007=P00<00?S?001cB@00LdT00P00
LdT01000n9d007<b001c<P00Lc82003hK0<007<K00H00?Pk001c1000L`@0IVIV001c1000n0T4019c
000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00`2jm`0206ec
000306IVIP3[m`00Lf8000@0Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<000000?M`
003gL000903gL0000`2jm`00Nh4007^1000207^10080joL01@21KP020?OB00@0PE@00P3gX@05084k
02@0mg001026S@000`3[m`00SGP008eh000408eh00030?OB002=G000SE`000<0SE`00`3gX@0508e0
0240mg003P3W3@0409QS00<0mj401@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`
00H0XPT08`3f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>
00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;01l0mPh00`3gL007
0<8b00@0mcl020322`0O0?H>00`0mg002@37300O0?H>04@0oooo001?0?ooo`0506IVIP3oool0oooo
0?ooo`1VIVH01@3oool207<05P030?X0<@1c02d0L`0]00@0nP1S0P1c05/0101VIVH0L`1b07<0LP1c
07820?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T201T0L`0306IVIP0207<00P1c00800P1c
0`0057<2000/n@8002]c0P00GOT20012L`8008oi0`00FG<01000`?T0IVIV001`L`00L7<2003an0<0
07=P00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c
101VIVH00P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc
000oL`000P0oL`0208Wh00<0Eg<00P2jm`0206ec000306IVIP1]L`00joL000D0Lf8000<0mm8007=;
001cB`000P1cB`020?NQ00<0Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000207^1
0080joL01@21KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh000408eh
00030?OB002=G000SE`000<0SE`00`3gX@0508e002<0mg000P2@V0020>_g00L0i`d01@2HH`030?NQ
00D0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902<0mPh0102ZC@030?M`
00L0ZR`00`3g?`060:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL007
0;P_00@0mcl01`2h2`0Q0?H>00h0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<
0?M`00P0a``07`3f3P140?ooo`00C`3oool0101VIVH0oooo0?ooo`1VIVH60?ooo`80L`0F0`1c02d4
0?X0H`80L`1K00@0IVIV07<0LP1c0780L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00H0V@3i0P0I
07<00`1VIVH00P1c0080L`020080L`<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi
0`00FG<01000`?T0IVIV001`L`00L7<2003an0<007=P00@00?S?001cB@00LdT007=90P00n9d3001c
<P800?Q/0`00La/00`00n3/007<406IVIP02001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`000`1Hn000?g<003mc000203mc000308Wh001GL`00Eg<00080Eg<00P2jm`001@1]
L`00IVIV06ec001]L`00joL000D0Lf8000<0mm8007=;001cB`000P1cB`020?NQ00<0Lc@000<00000
0?M`003gL000903gL0000`2jm`00Nh4007^1000207^10080joL01@21KP020?OB00@0PE@00P3gX@05
084k02@0mg001026S@000`3[m`00SGP008eh000408eh00030?OB002=G000SE`000<0SE`00`3gX@05
08e002<0mg000P2@V0020>_g00@0V8800`3gdP0509QS00<0mj401@2HA@020?M`00H0V2L00`3g?`06
09P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P040:Y=00<0mg001`2Z;0030?Lo00L0ZPX08@3f3P03
0;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3g
L0080;d;01l0mPh00`3gL0070<8b00@0mcl020322`0P0?H>00`0mg002037300O0?H>04@0oooo001?
0?ooo`0406IVIP3oool0oooo06IVIPH0oooo0P1c01H307<0;@@0nP1S00<0L`1K06IVIP1c05/00`1c
07820?T0m`80G@1c00<0bP3i04L0L`1707<01@2I0?T201T0L`0306IVIP0f0?T00P1c00800P1c00D0
103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<2002?n@<005Uc00@0IVIV001`L`00L7<0
071c0P00lOP3001cH004003hc`00LdT007=9001cB@800?RM0`00Lc82003hK0<007<K00<00?Pk06IV
IP00L`@00P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc
000oL`000P0oL`000`29n000Eg<005Mc000205Mc0080^_L000D0KG<006IVIP1]L`00KG<00>_g0005
07=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L0
07^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401021>`0U0?M`00@0QXd000<0joL0
08eh002=N0000`2=N0020?OB00D0SE`00`3gX@0408e002@0mg000P2@V0020>_g00@0V8800`3gdP05
09QS00<0mj401@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P04
0:Y=00<0mg001`2Z;0030?Lo00L0ZPX08P3f3P020;5@00d0mg001`2a2P0R0?H>00040;QC003gL000
mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;01l0mPh00`3gL0070<8b00@0mcl02032
2`0P0?H>00`0mg002037300O0?H>04@0oooo001?0?ooo`0306IVIP3oool0IVIV00L0oooo00<0L`0F
0?X0<@1c02d00P1c02d40?X0H`0307<0F`1VIVH0n@3500<0L`1b0P3i0?L205d0L`030<X0n@1707<0
A`1c00D0V@3i0P0I07<00`1VIVH0=P3i0080L`020080L`0500@0n@0057<001Ac000DL`00;?T00`00
:g<2001Mn@80049c0P00SoT3001IL`0406IVIP00L7<0071c001`L`800?7h0`00Lf001000n<l007=9
001cB@00LdT2003hW@<007<b0P00n6`3001c6`0306IVIP00L`@007<4008007<400<00?P9019c000B
L`000P0BL`00100Wn000:G<002Uc000YL`0205Sh00@0?g<000<0ROP005Mc001GL`000P1GL`020;[g
000506IVIP1]L`00KG<006ec003[m`00101cHP020?OB00@0Ld/00P3gX@0307<d00030000003gL000
mg0002@0mg0000<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401021>`0U
0?M`00@0QXd000<0joL008eh002=N0000`2=N0020?OB00D0SE`00`3gX@0408e002@0mg000P2@V002
0>_g00@0V8800`3gdP0509QS00<0mj401@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<
0?M`00H0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P020;5@00d0mg001`2a2P0R
0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;01l0mPh00`3g
L0070<8b00@0mcl020322`0P0?H>00`0mg002037300O0?H>04@0oooo001?0?ooo`0306IVIP3oool0
IVIV00L0oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0H`0306IVIP1c05/0n@3500<0L`1b00D0n@3g
05d0L`1M07<0G@1c0<X0n@0204L0L`D0V@3i00@06@1c06IVIP0I07<0=P3i0`0207<01@040?T001Ac
000DL`0057<002ci00<002]c0P00GOT20012L`8008oi0P00FG<00`1VIVH00<3i001`L`02001`L`80
0?7h0P00Lf02003hc`<007=900<00?RM001c<P00Lc800P00Lc82003hK0<007<K00@0IVIV001c1000
L`@007<40P00n0T3019c00809oP00`0YL`0205Sh00@0?g<000<0ROP005Mc001GL`000P1GL`020;[g
000506IVIP1]L`00KG<006ec003[m`00101cHP020?OB00@0Ld/000<0mj4007<d001c=0000P1c=000
0`000000mg000?M`000T0?M`00D0Nh400P3[m`05085^0080mm801021E0020?NQ00@0PC/09@3gL004
08J=00030>_g002=N000SGP000<0SGP00P3gdP0508eL00<0mj40102=@00T0?M`0080T9P000<0joL0
09R2002HPP000`2HPP030?OB00D0V6<00`3gX@0509Q50080mg001P2H9`030?Lo00H0V0T08`3f3P06
0:9900`0mg001P2R2@0S0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303gL007
0;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P0>0?M`00P0_@/0803f
3P020?M`00L0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0A03oool004l0oooo0P1VIVH8
0?ooo`0307<05P3j0340L`0]0080L`0]103j06<00`1VIVH0L`1K0?T0a@0307<0LP050?T0m`1M07<0
G@1c05d0L`3:0?T00P1707<509T0n@0401T0L`1VIVH06@1c03H0n@<00P1c00D0103i000DL`0057<0
01Ac000/n@03000[L`8005gi0P00@W<2002?n@8005Uc00<0IVIV0030n@00L7<00P00L7<01000lOP0
07=P001cH000Lf02003hc`<007=900<00?RM001c<P00Lc800P00Lc801P00n6`007<K001c6`00La/0
IVIV003h>`<007<40P00n0T3019c00809oP00`0YL`0205Sh00<0?g<00P29n00405Mc00030;[g001V
IVH0KG<000<0KG<000<0joL007=R001cHP000P1cHP020?OB00@0Ld/000<0mj4007<d001c=0000P1c
=0000`000000mg000?M`000T0?M`00D0Nh400P3[m`05085^00030?OB0021E000PE@000<0PE@00P3g
X@04084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj40102=@00T0?M`0080T9P000<0
joL009R2002HPP000`2HPP030?OB00D0V6<00`3gX@0509Q50080mg001P2H9`030?Lo00H0V0T08`3f
3P060:9900`0mg001P2R2@0S0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303g
L0070;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P0>0?M`00P0_@/0
803f3P020?M`00P0`S800`3g?`080<8;0200mPh0303gL0080<L<01l0mPh0A03oool004l0oooo0P1V
IVH70?ooo`80L`0F00<0nP0a07<0;@1c02d0103j06<0101VIVH0L`1K07<0F`3i0<D307<0LP050?T0
m`1M07<0G@1c05d0L`3:0?T00P1707<509T0n@0406IVIP0I07<06@1c03H0n@<00P1c00D0103i000D
L`0057<001Ac000/n@03000[L`8005gi0P00@W<01000SoT005Uc001IL`1VIVH20030n@<0071c00@0
0?7h001cH000Lf0007=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b00H00?Q/001c6`00La/0
07<K06IVIP00n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc0080ROP0101GL`000`2j
m`00IVIV06ec000306ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00030?NQ001c=000Lc@0
0080Lc@000<000000?M`003gL000903gL00507^10080joL01@21KP000`3gdP00PE@0085D0003085D
0080mj401021>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00903gL002092H
00030>_g002HPP00V88000<0V8800`3gdP0509QS00<0mj401@2HA@020?M`00H0V2L00`3g?`0609P9
02<0mPh01P2RB@0<0?M`00H0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@
00`0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL008
0;d;0200mPh00P3gL0080<8b00@0mcl01`322`0P0?H>00`0mg002037300O0?H>04@0oooo001?0?oo
o`0306IVIP3oool0oooo00H0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`0406IVIP1c05/0L`1K
0?T0a@<0L`1b00@0n@3g05d0L`1M07<0G@1c0`1707<509T0n@0406IVIP0I07<06@1c03H0n@<00P1c
00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<01000SoT005Uc001IL`1VIVH20030
n@<0071c00@00?7h001cH000Lf0007=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b00@00?Q/
001c6`00La/0IVIV0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc0080ROP0101G
L`000`1VIVH0^_L006ec000306ec00030>_g001cHP00Lf800080Lf800P3gdP0407=;00060?NQ001c
=000Lc@007<d00000000Lc@09@3gL0000`2jm`00Nh4007^1000307^10080joL01@21KP000`3gdP00
PE@0085D0003085D0080mj401021>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00@0
SD00903gL002092H00030>_g002HPP00V88000<0V8800`3gdP0509QS00<0mj401@2HA@020?M`00H0
V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo00L0
ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>0080^5<00P3gL0070;P_00@0mcl01`2h2`0Q0?H>0003
0;eF003gL000mg0000/0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/07`3f3P0<0?M`00P0
a``0803f3P130?ooo`00C`3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00<0nP0a07<0;@1c02d0
0`3j06<01@1VIVH0nP1S07<0F`1c05/0n@3500<0L`1b00@0n@3g05d0L`1M07<0G@1c0`1707<509T0
n@0306IVIP0I07<06@1c00@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`08001Mn@00@W<0
049c0012L`00SoT005Uc06IVIP00FG<20030n@<0071c00D00?7h001cH000Lf0007=P003hc`04001c
B@03003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/0IVIV0P00n3/3001c10800?P90`0BL`02
02Oh00<0:G<00P1Hn00303mc0080ROP0101GL`000`1VIVH0^_L006ec000306ec00030>_g001cHP00
Lf800080Lf8000<0mm8007=;001cB`000`1cB`001P3gX@00Lc@007<d001c=000000007<d02D0mg00
00<0^_L007^1001kP@000`1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/0
9@3gL00308J=0080joL01@2=N0020?OB00D0SE`00`3gX@0408e002@0mg0000<0T9P00>_g003[m`00
1@2HPP030?OB00D0V6<00`3gX@0509Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg00
1P2R2@0S0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:0280mPh0
0P2hD`020?M`00L0^2l0103g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL0080;d;0200mPh0
0P3gL0080<8b00@0mcl020322`0O0?H>00`0mg002@37300O0?H>04<0oooo001>0?ooo`0306IVIP3o
ool0oooo00L0oooo0P1c01H00`3j0340L`0]07<0;@030?X0H`0506IVIP1c05/0L`1K07<0F`3i0<D0
0P1c07820?T0m`<0G@1c0`1707<409T0n@0406IVIP0I07<06@1c01T0L`@00P1c00D0103i000DL`00
57<001Ac000/n@03000[L`08001Mn@00@W<0049c0012L`00SoT005Uc06IVIP00FG<20030n@<0071c
00D00?7h001cH000Lf0007=P003hc`04001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c6`1V
IVH007<K0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00303mc0080ROP00`1GL`000`1V
IVH0^_L00;[g000306ec0080joL0101cHP000`3gdP00Ld/007=;000307=;00060?NQ001c=000Lc@0
07<d00000000Lc@09@3gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@00P3g
X@04084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj40102=@00T0?M`0003092H003[
m`00joL000D0V8800`3gdP0509QS00<0mj401@2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2R
B@0<0?M`00H0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg001`2a
2P0R0?H>0080^5<00P3gL0070;P_00@0mcl01`2h2`0Q0?H>00030;eF003gL000mg0000/0mg00202m
2`0P0?H>0080mg002032<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07`3f3P130?ooo`00CP3oool3
06IVIPL0oooo0P1c01H00`3j0340L`0]07<0;@020?X0H`0306IVIP3j06<0L`1K0080L`1K00<0n@35
07<0LP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`@0V@3i00@0IVIV01T0L`0I07<06@1c
100207<01@040?T001Ac000DL`0057<002ci00<002]c00H005gi0012L`00@W<0049c002?n@1VIVH2
001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf000?S?00@007=900<00?RM001c<P00Lc800P00
Lc801000n6`007<K06IVIP00La/2003h>`<007<40P00n0T3019c000302Oh000YL`00:G<00080:G<0
0P1Hn00303mc0080ROP00`1GL`000`1VIVH0^_L00;[g000306ec0080joL0101cHP000`3gdP00Ld/0
07=;000307=;00060?NQ001c=000Lc@007<d00000000Lc@09@3gL0000`2jm`00Nh4007^1000307^1
0080joL01021KP020?OB00D0PE@00P3gX@04084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL
0080mj401@2=@00T0?M`0003092H003[m`00joL000D0V8800`3gdP0509QS0080mj401P2HA@020?M`
00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT08`3f3P050:Y=0080mg001`2Z;0030?Lo
00L0ZPX08P3f3P030;5@00`0mg001`2a2P0R0?H>0080^5<00`3gL0070;P_00<0mcl01`2h2`0Q0?H>
00030;eF003gL000mg0000/0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/07`3f3P0<0?M`
00T0a``07`3f3P130?ooo`00CP3oool00`1VIVH0oooo0?ooo`0606IVIP040?ooo`1c01H0L`0F0?X0
<@80L`0]0P3j06<00`1VIVH0nP1S07<0F`0207<0F`<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c
04L0L`<0V@3i00<0IVIV09T0n@0I07<00P0I07<40080L`0300@0n@0057<001Ac008002ci0`00:g<0
1P00GOT0049c0012L`00@W<008oi06IVIP8005Uc0P00`?T3001`L`05003an000Lf0007=P001cH000
n<l01000LdT01000n9d007<b001c<P00Lc82003hK00406IVIP00La/007<K003h>`@007<400<00?P9
019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc0080F?P00`0oL`0208Wh0080Eg<000@0IVIV
0;[g002jm`00^_L00`1]L`020>_g00@0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d
001c=000000002H0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP05085D00030?NQ
0021>`00PC/000<0PC/09@3gL00308J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e002@0mg00
00<0T9P00>_g003[m`001@2HPP030?OB00D0V6<00P3gX@0609Q50080mg001P2H9`030?Lo00H0V0T0
8`3f3P060:9900`0mg001P2R2@0S0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00
303gL0070;4:0280mPh00P2hD`030?M`00L0^2l00`3g?`070;P;0240mPh000<0_EH00?M`003gL000
2`3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0O0?H>00`0mg002@37300O0?H>04<0oooo
001>0?ooo`0306IVIP3oool0oooo00H0oooo00@0IVIV07<05P1c01H0nP0a0P1c02d0103j06<0IVIV
0?X0H`3j06<307<0F`<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`<0V@3i00<0IVIV09T0
n@0I07<00P0I07<40080L`0300@0n@0057<001Ac008002ci0`00:g<01@00GOT0049c0012L`00@W<0
IVIV00<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH003003hc`00LdT007=9008007=900@0
0?RM001c<P00Lc8007<b0P00n6`0101VIVH007<K001c6`00n3/4001c1003003h2@0BL`004W<00080
4W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00P1GL`00101VIVH0
^_L00;[g002jm`0306ec0080joL0101cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@0
07<d000000009P3gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@000<0mj40
084k0021>`000`21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD00903gL000
0`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0mcl01P2H2@0S
0?H>00H0XTT0303gL0060:8902<0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00<
0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;
0?M`00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0@`3oool0
04h0oooo00<0IVIV0?ooo`3oool01`3oool207<05P<0L`0]00@0nP1S06IVIP3j06<0nP1S0`1c05/3
07<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<209T0n@0306IVIP2I0?T0V@3i00806@1c00<0
=P3i0080L`0207<00P0207<3000DL`8002ci0P00:g<2001Mn@<0049c00D0IVIV001IL`00FG<005Uc
0030n@03001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@06003hW@00Lc8007<b001c<P00
n6`0IVIV0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP000<0Eg<006IVIP1GL`000`2jm`0306ec
0080joL0101cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@007<d000000009P3gL000
0`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@000<0mj40084k0021>`000`21>`0U
0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD00903gL0000`2@V000joL00>_g0005
09R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL006
0:8902<0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08P3f3P02
0;QC00<0mg001`2h;`030?Lo00P0^0/0803f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P03
0?M`00L0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0@`3oool004h0oooo00<0IVIV0?oo
o`3oool01`3oool207<05P<0L`0]00@0nP1S06IVIP3j06<0nP1S0`1c05/307<0LP80n@3g0P1M07<0
0`3:0?T0A`1c04L0L`0309T0n@0306IVIP2I0?T0V@3i00806@1c00<0=P3i0080L`0207<00P0207<3
000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<00`1VIVH008oi001IL`02001IL`040030n@00
L7<0071c001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@06003hW@00Lc8007<b001c<P00
n6`0IVIV0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc
000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP000<0IVIV05Mc001GL`000`2jm`0306ec
00030>_g001cHP00Lf8000<0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@007<d001c=000
000002H0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP05085D00030?NQ0021>`00
PC/000<0PC/09@3gL00308J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e002@0mg0000<0T9P0
0>_g003[m`001@2HPP030?OB00D0V6<00P3gX@0609Q50080mg001P2H9`030?Lo00H0V0T08`3f3P06
0:9900`0mg001P2R2@0T0?H>00@0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303gL007
0;4:0280mPh00P2hD`030?M`00L0^2l00`3g?`080;P;0240mPh03P3gL0070;d;0200mPh00`3gL007
0<8b00@0mcl020322`0P0?H>00`0mg002037300O0?H>04<0oooo001>0?ooo`0306IVIP3oool0oooo
00L0oooo00<0L`0F0?X0<@1c02d00P1c02d0101VIVH0nP1S0?X0H`3j06<207<0F`040?T0a@1c0780
L`1b07<0LP80n@3g0P1M07<00`3:0?T0A`1c04L0L`0209T0n@0306IVIP2I0?T0V@3i00<06@1c00D0
=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<00`1VIVH0
08oi001IL`02001IL`040030n@00L7<0071c001`L`800?7h0`00Lf001000n<l007=9001cB@00LdT2
003hW@<007<b00<0IVIV003hK000La/00P00La/00`00n3/007<4001c1002001c1003003h2@0BL`00
4W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP000<0IVIV
05Mc001GL`000`2jm`0306ec00030>_g001cHP00Lf8000<0Lf8000<0mm8007=;001cB`000P1cB`02
0?NQ00<0Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080joL01021KP02
0?OB00D0PE@000<0mj40084k0021>`000`21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G002
0?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3gL006
09PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902@0mPh0102ZC@020?M`00L0ZR`00`3g?`07
0:X:0280mPh00`2aD00<0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00<0mcl0202h
2`0Q0?H>00h0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00P0a``07`3f
3P130?ooo`00CP3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P3j0340L`0]0080L`0]00@0IVIV
0?X0H`3j06<0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<0
0P2I0?T00`1VIVH0V@3i09T0n@0301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01000;?T0
02]c000[L`00:g<2001Mn@040012L`1VIVH008oi002?n@<005Uc00@00<3i001`L`00L7<0071c0P00
lOP3001cH004003hc`00LdT007=9001cB@800?RM0`00Lc800`1VIVH00?Q/001c6`02001c6`03003h
>`00L`@007<4008007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc000202Uc000305Sh
000oL`00?g<00080?g<000<0ROP006IVIP1GL`000P1GL`030;[g00<0KG<000<0joL007=R001cHP00
0`1cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`000000mg000?M`000T0?M`00030;[g
001kP@00Nh4000<0Nh400P3[m`04085^0080mm801021E0020?NQ00D0PC/09@3gL00308J=0080joL0
1@2=N0020?OB00D0SE`00P3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0V6<0
0P3gX@0609Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0T0?H>00@0ZTd0
0P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<00?M`003gL000
mg001`2h;`030?Lo00P0^0/08@3f3P0>0?M`00P0_@/07`3f3P030?M`00L0`S80103g?`080<8;0200
mPh0303gL0080<L<01l0mPh0@`3oool004h0oooo00<0IVIV0?ooo`3oool01`3oool01@1c01H0nP0a
07<0;@1c02d0IVIV00@0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00D0bP3i04L0
L`1707<0V@3i06IVIP0309T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00
:g<002]c000[L`8005gi00@0049c06IVIP00SoT008oi0`00FG<01000`?T0071c001`L`00L7<2003a
n0<007=P00@00?S?001cB@00LdT007=90P00n9d2001c<P0306IVIP00n6`00?Q/00<007<K00<00?Pk
001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P0
03mc000oL`000P0oL`000`29n000IVIV05Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R0003
07=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L0
07^1001kP@000`1kP@020>_g00@0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`05
08eh0080mm801@2=G0020?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`02
0?NQ00H0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902@0mPh0102ZC@02
0?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00<0?M`00L0/@X08`3f3P00102hD`00mg000?M`003g
L0070;P_00@0mcl01`2h2`0Q0?H>00h0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/0803f
3P0<0?M`00P0a``0803f3P120?ooo`00CP3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00@0nP0a
07<0;@1c02d0IVIV103j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<01@3:0?T0A`1c
04L0L`2I0?T0IVIV00<0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci000[
L`00:g<002]c0P00GOT0101VIVH0049c002?n@00SoT3001IL`040030n@00L7<0071c001`L`800?7h
0P00Lf02003hc`<007=90P00n9d2001c<P0306IVIP00n6`00?Q/00<007<K00<00?Pk001c1000L`@0
0P00L`@00`00n0T04W<0019c0002019c000402Oh000YL`00:G<002Uc0080F?P0100oL`000`1VIVH0
Eg<005Mc000205Mc0080^_L0101]L`000`3[m`00Lf8007=R000307=R00030?OB001cB`00Ld/00080
Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L007^1001kP@000P1kP@030>_g00@0
PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0
SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0
mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902@0mPh0102ZC@020?M`00L0ZR`00`3g?`070:X:0280
mPh00`2aD00<0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>
00h0mg00202m2`0P0?H>0080mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00P0a``0803f3P120?oo
o`00CP3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00<0nP0a07<0;@1VIVH01@3j06<207<0F`05
0?T0a@1c0780L`1b07<0LP3i0?L00`1M07<0103:0?T0A`1c04L0L`1VIVH409T0n@<06@1c00D0=P3i
0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi00@0IVIV0012L`00SoT0
08oi0`00FG<01@00`?T0071c001`L`00L7<00?7h00<007=P0P00n<l3001cB@05003hW@00Lc8007<b
06IVIP00Lc800P00n6`3001c6`04003h>`00L`@007<4001c10800?P9100BL`00100Wn000:G<002Uc
000YL`0205Sh00@0?g<000<0IVIV05Mc001GL`000P1GL`020;[g00@0KG<000<0joL007=R001cHP00
0`1cHP000`3gdP00Ld/007=;000207=;0080mj400`1c=0000`000000mg000?M`000T0?M`00030;[g
001kP@00Nh400080Nh400`3[m`04085^0080mm801021E0020?NQ00D0PC/09@3gL00308J=0080joL0
1@2=N0020?OB00D0SE`00P3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0V6<0
0P3gX@0609Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0T0?H>00@0ZTd0
0P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E00303gL0080;4:0280mPh000@0^5<00?M`003gL000
mg001`2h;`040?Lo00L0^0/08@3f3P0>0?M`00P0_@/0803f3P020?M`00P0`S800`3g?`080<8;0200
mPh0303gL0090<L<01l0mPh0@P3oool004d0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0
<@1c02d0IVIV00D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c0`1707<00`1VIVH0
V@3i09T0n@0209T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`06000/n@00:g<002]c
000[L`00GOT0IVIV0P00@W<01000SoT005Uc001IL`00FG<20030n@<0071c00@00?7h001cH000Lf00
07=P0P00n<l3001cB@06003hW@00Lc8007<b06IVIP00Lc800?Q/1000La/01000n3/007<4001c1000
L`@2003h2@<04W<00P0Wn00302Uc0080F?P00`0oL`000`1VIVH0ROP005Mc000305Mc0080^_L0101]
L`000`3[m`00Lf8007=R000207=R0080mm80101cB`020?NQ00<0Lc@000<000000?M`003gL000903g
L0000`2jm`00Nh4007^1000207^100<0joL01021KP020?OB00@0PE@00P3gX@05084k02@0mg001026
S@020>_g00D0SGP00P3gdP0508eL0080mj401@2=@00T0?M`0003092H003[m`00joL000D0V8800`3g
dP0509QS0080mj401P2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT0903f
3P040:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg00202a2P0R0?H>00040;QC003g
L000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl0
20322`0O0?H>00`0mg002@37300O0?H>0480oooo001=0?ooo`0306IVIP3oool0oooo00L0oooo0P1c
01H00`3j0340IVIV07<0;@040?X0H`<0L`1K00<0n@3507<0LP1c07800P3i0?L305d0L`80A`1c00<0
IVIV09T0n@2I0?T00`2I0?T301T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`05001M
n@1VIVH0049c0012L`00SoT00`00FG<20030n@<0071c00@00?7h001cH000Lf0007=P0P00n<l3001c
B@03003hW@00Lc80IVIV008007<b00<00?Q/001c6`00La/00P00La/01000n3/007<4001c1000L`@2
003h2@<04W<00P0Wn00302Uc0080F?P00`0oL`000`1VIVH0ROP005Mc000305Mc0080^_L0101]L`00
0`3[m`00Lf8007=R000207=R0080mm80101cB`000`3gX@00Lc@007<d000207<d00030000003gL000
mg0002@0mg0000<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0T
0?M`00@0QXd00P3[m`0508eh0080mm801@2=G0020?NQ00D0SD00903gL0000`2@V000joL00>_g0005
09R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL006
0:8902@0mPh0102ZC@020?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P00
102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>00h0mg00202m2`0P0?H>0080mg002032
<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07`3f3P120?ooo`00C@3oool00`1VIVH0oooo0?ooo`07
0?ooo`80L`0F00<0nP0a06IVIP1c02d0103j06<307<0F`030?T0a@1c0780L`1b0080n@3g0P1M07<0
103:0?T0A`1c04L0L`1VIVH509T0n@<06@1c100207<01@040?T001Ac000DL`0057<002ci00<002]c
00D0IVIV0012L`00@W<0049c002?n@03001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf000?S?
00@007=900<00?RM001c<P1VIVH00P00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3
019c00809oP00`0YL`0205Sh0080?g<000<0IVIV08Wh0029n000101GL`020;[g00@0KG<000<0joL0
07=R001cHP000P1cHP020?OB00@0Ld/000<0mj4007<d001c=0000P1c=0000`000000mg000?M`000T
0?M`00030;[g001kP@00Nh400080Nh400P3[m`05085^0080mm801021E0020?NQ00D0PC/0903gL004
08J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP03
0?OB00D0V6<00P3gX@0609Q50080mg001P2H9`030?Lo00H0V0T08`3f3P060:9900`0mg001P2R2@0T
0?H>00@0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh000@0^5<0
0?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P0>0?M`00P0_@/0803f3P020?M`00P0`S80103g
?`080<8;01l0mPh0303gL0090<L<01l0mPh0@P3oool004d0oooo00<0IVIV0?ooo`3oool01`3oool2
07<05P0306IVIP1c02d0L`0]00@0nP1S0`1c05/00`3i0<D0L`1b07<0LP020?T0m`80G@1c00@0bP3i
04L0L`1VIVH0A`1c1@2I0?T301T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`0506IV
IP00@W<0049c0012L`00SoT00`00FG<20030n@<0071c00D00?7h001cH000Lf0007=P003hc`04001c
B@03003hW@1VIVH007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/3001c10800?P90`0BL`02
02Oh00<0:G<00P1Hn00203mc000306IVIP29n000ROP000@0Eg<00P2jm`0406ec00030>_g001cHP00
Lf800080Lf800P3gdP0407=;00030?NQ001c=000Lc@00080Lc@000<000000?M`003gL000903gL000
0`2jm`00Nh4007^1000207^10080joL01@21KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@02
0>_g00D0SGP00P3gdP0508eL0080mj401@2=@00T0?M`0003092H003[m`00joL000D0V8800`3gdP05
09QS0080mj401P2HA@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT0903f3P04
0:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>00040;QC003gL000
mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl02032
2`0O0?H>00`0mg002@37300O0?H>0480oooo001=0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H0
0`1VIVH0L`0]07<0;@040?X0H`<0L`1K0`1c07820?T0m`80G@1c00@0bP3i04L0L`1VIVH0A`1c1@2I
0?T301T0L`@00P1c00D0103i000DL`0057<001Ac000/n@02000[L`0306IVIP00GOT0049c0080049c
00@008oi001IL`00FG<005Uc0P00`?T3001`L`05003an000Lf0007=P001cH000n<l01000LdT00`00
n9d0IVIV001c<P02001c<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h2@<04W<00P0Wn003
02Uc0080F?P000<0?g<006IVIP0oL`000P29n00405Mc0080^_L0101]L`000`3[m`00Lf8007=R0002
07=R0080mm80101cB`000`3gX@00Lc@007<d000207<d00030000003gL000mg0002@0mg0000<0^_L0
07^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0T0?M`00@0QXd00P3[m`05
08eh0080mm80102=G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`02
0?NQ00H0V4D00P3gL00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902@0mPh0102ZC@03
0?M`00H0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P00102hD`00mg000?M`003g
L0070;P_00@0mcl01`2h2`0Q0?H>00h0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0803f
3P0<0?M`00P0a``07`3f3P120?ooo`00C@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0
L`0]0080L`0]103j06<307<0F`<0L`1b0P3i0?L205d0L`040<X0n@1VIVH0A`1c04L0L`D0V@3i0`0I
07<40080L`0300@0n@0057<001Ac008002ci0P00:g<00`1VIVH005gi0012L`020012L`04002?n@00
FG<005Uc001IL`800<3i0`00L7<01@00lOP007=P001cH000Lf000?S?00@007=900<0IVIV001c<P00
Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c00809oP00`0YL`0205Sh
000303mc001VIVH0?g<00080ROP00`1GL`030;[g00@0KG<000<0joL007=R001cHP000P1cHP000`3g
dP00Ld/007=;000307=;00060?NQ001c=000Lc@007<d00000000Lc@09P3gL0000`2jm`00Nh4007^1
000207^10080joL01@21KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@020>_g00D0SGP00P3g
dP0408eL00<0mj401@2=@00T0?M`0003092H003[m`00joL000D0V8800`3gdP0509QS0080mj401P2H
A@020?M`00H0V2L00`3g?`0609P902<0mPh01P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001P2Z
;0030?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0
103g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL0080;d;0200mPh00P3gL0080<8b00@0mcl0
20322`0P0?H>00`0mg002037300O0?H>0480oooo001=0?ooo`0306IVIP3oool0oooo00L0oooo00<0
L`0F06IVIP1c02d00P1c02d40?X0H`<0L`1K0`1c07820?T0m`80G@1c00<0bP3i06IVIP1707<01P2I
0?T201T0L`0303H0n@0207<00P1c00800P1c0`0057<2000/n@04000[L`1VIVH005gi001Mn@<0049c
00@008oi001IL`00FG<005Uc0P00`?T2001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@04
06IVIP00Lc8007<b001c<P800?Q/0`00La/2003h>`<007<40P00n0T3019c000302Oh000YL`00:G<0
0080:G<00P1Hn0000`1VIVH0?g<003mc000208Wh00<0Eg<00`2jm`0306ec0080joL0101cHP000`3g
dP00Ld/007=;000307=;00060?NQ001c=000Lc@007<d00000000Lc@09P3gL00507^10080joL01@21
KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00SGP008eh000408eh0080mm80102=
G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3g
L00609PW00<0mcl01P2H2@0S0?H>00H0XTT0303gL0060:8902@0mPh0102ZC@030?M`00H0ZR`00`3g
?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl0
1`2h2`0Q0?H>00030;eF003gL000mg0000/0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0
803f3P0<0?M`00P0a``07`3f3P120?ooo`00C@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1V
IVH0L`0]0080L`0]103j06<207<0F`040?T0a@1c0780L`1b07<0LP80n@3g0P1M07<00`1VIVH0A`1c
04L0L`0609T0n@806@1c00<0=P3i0080L`0207<00P0207<3000DL`04000/n@00:g<002]c06IVIP80
05gi0`00@W<01@00SoT005Uc001IL`00FG<00<3i00<0071c0P00lOP3001cH006003hc`00LdT007=9
001cB@1VIVH00?RM0`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c
0002019c000302Oh000YL`00:G<00080:G<000<0F?P006IVIP0oL`000P0oL`0208Wh00<0Eg<00`2j
m`0306ec0080g>L0101cHP000`3gdP00Ld/007=;000307=;00060?NQ001c=000Lc@006IVIP000000
Lc@09P3gL00507^10080joL01@21KP020?OB00@0PE@00P3gX@05084k02@0mg001026S@000`3[m`00
SGP008eh000408eh0080mm80102=G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0
mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0mcl01@2H2@0T0?H>00H0XTT0303gL0060:8902@0
mPh0102ZC@030?M`00H0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P00102hD`00
mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>00030;eF003gL000mg0000/0mg00202m2`0P0?H>
00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00P0a``0803f3P110?ooo`00C@3oool00`1VIVH0
oooo0?ooo`070?ooo`0306IVIP3j0340L`0]0080L`0]103j06<207<0F`040?T0a@1c0780L`1b07<0
LP80n@3g0P1M07<00`1VIVH0A`1c04L0L`0509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03
000DL`04000/n@00:g<0IVIV000[L`8005gi0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c
0P00lOP3001cH006003hc`00LdT007=9001cB@1VIVH00?RM0`00Lc82003hK0<007<K00<00?Pk001c
1000L`@00P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P006IV
IP0oL`000P0oL`0208Wh00<0Eg<00`2jm`0206ec00<0g>L0101cHP000`3gdP00Ld/007=;000307=;
00060?NQ001c=000Lc@006IVIP000000Lc@09@3gL0000`2jm`00Nh4007^1000307^10080joL01@21
KP020?OB00@0PE@00P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh0080mm80102=
G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3g
L00609PW00<0mcl01@2H2@060>H=01h0mPh01P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001P2Z
;0030?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0
103g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL0080;d;0200mPh00`3gL0070<8b00@0mcl0
20322`0P0?H>00`0mg002037300P0?H>0440oooo001=0?ooo`0306IVIP3oool0oooo00L0oooo00<0
IVIV0?X0<@1c02d00P1c02d40?X0H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0205d0L`0406IV
IP3:0?T0A`1c04L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci000[
L`1VIVH002]c0P00GOT20012L`8008oi0`00FG<01000`?T0071c001`L`00L7<2003an0<007=P00H0
0?S?001cB@00LdT0IVIV001cB@00n9d3001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003
003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1VIVH0?g<003mc000203mc0080
ROP00`1GL`030;[g0080KG<00`3Li`0407=R00030?OB001cB`00Ld/000<0Ld/000D0mj4007<d001V
IVH0Lc@00000000V0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`05085^00030?OB0021E000PE@0
00<0PE@00P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh0080mm80102=G0030?NQ
00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW
00<0mcl0102H2@0<0>H=01T0mPh01P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0020?Lo
00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>0080^5<00P3gL0070;P_00@0mcl01`2h2`0Q0?H>
00030;eF003gL000mg0000/0mg00202m2`0P0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`
00P0a``0803f3P110?ooo`00C@3oool00`1VIVH0oooo0?ooo`060?ooo`0306IVIP1c01H0nP0a0080
L`0]1@3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00P1M07<0101VIVH0bP3i04L0L`1707<5
09T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@1VIVH002]c000[L`8005gi
0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH004003hc`00LdT007=906IV
IP800?RM0`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c
000302Oh000YL`00:G<00080:G<000<0IVIV03mc000oL`000P0oL`0208Wh00<0Eg<00`2jm`000`1]
L`00g>L00=cW00020=cW00@0Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00Lc@006IVIP1c=000
000002H0mg0000<0^_L007^1001kP@000`1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E002
0?NQ00@0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP00P3gdP0408eL00<0mj401@2=@00T
0?M`0003092H003[m`00joL000D0V8800`3gdP0509QS0080mj401P2HA@020?M`00H0V2L00`3g?`03
09P90180iPd0503f3P060:9900`0mg001P2R2@0T0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0R
0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`020?M`00L0^2l0103g?`070;P;0240mPh000<0_EH0
0?M`003gL0002`3gL0080;d;0200mPh00`3gL0070<8b00@0mcl020322`0P0?H>00`0mg002037300P
0?H>0440oooo001=0?ooo`0306IVIP3oool0oooo00H0oooo00<0IVIV07<05P3j03400P1c02d50?X0
H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0205d0L`0406IVIP3:0?T0A`1c04L0L`D0V@3i0`0I
07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci06IVIP00:g<002]c0P00GOT20012L`80
08oi0`00FG<01000`?T0071c001`L`00L7<2003an0<007=P00@00?S?001cB@1VIVH007=90P00n9d3
001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<000H09oP0
02Uc000YL`00:G<006IVIP1Hn00403mc0080ROP00`1GL`030;[g000406ec003Li`00g>L00=cW00D0
Lf8000<0mm8007=;001cB`000`1cB`001@3gX@00IVIV07<d001c=000000002H0mg0000<0^_L007^1
001kP@000`1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/09@3gL00408J=
00030>_g002=N000SGP000@0SGP000<0mm8008eL002=G0000`2=G0030?NQ00D0SD00903gL0000`2@
V000joL00>_g000509R200<0mm801@2HH`020?NQ00H0V4D00P3gL00609PW00<0mcl00`2H2@0G0>H=
00l0mPh01P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08P3f3P030;5@
00d0mg001`2a2P0R0?H>0080^5<00P3gL0080;P_00<0mcl01`2h2`0Q0?H>00030;eF003gL000mg00
00`0mg00202m2`0O0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00T0a``07`3f3P110?oo
o`00C03oool00`1VIVH0oooo0?ooo`060?ooo`0406IVIP1c01H0L`0F0?X0<@80L`0]1@3j06<207<0
F`090?T0a@1c0780L`1b07<0LP3i0?L0G@1c06IVIP1M07<0bP3i0080A`1c1@2I0?T301T0L`0503H0
n@0207<00P1c0080L`040?T00`0057<0101VIVH002]c000[L`00:g<2001Mn@80049c0P00SoT3001I
L`040030n@00L7<0071c001`L`800?7h0`00Lf001000n<l007=906IVIP00LdT2003hW@<007<b0P00
n6`3001c6`03003h>`00L`@007<4008007<400<00?P9019c000BL`000P0BL`001P0Wn000:G<002Uc
000YL`00IVIV05Sh00@0?g<00P29n00305Mc00<0^_L0103Li`0507=R00030?OB001cB`00Ld/000<0
Ld/000@0IVIV07<d001c=000Lc@00`00000T0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`05085^
00030?OB0021E000PE@000<0PE@00P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh
00030?OB002=G000SE`000<0SE`00`3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP030?OB
00D0V6<00P3gX@0609Q50080mg001P2H9`030?Lo0080V0T07@3V3@0:0?H>00H0XTT0303gL0060:89
02@0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P020;QC
0080mg00202h;`030?Lo00L0^0/08P3f3P0>0?M`00P0_@/0803f3P020?M`00L0`S80103g?`080<8;
0200mPh0303gL0090<L<01l0mPh0@@3oool004`0oooo00<0IVIV0?ooo`3oool01P3oool0101VIVH0
L`0F07<05P3j034207<0;@D0nP1S0P1c05/0203i0<D0L`1b07<0LP1c0780n@3g05d0L`1VIVH0G@1c
0`1707<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`0406IVIP00:g<002]c000[
L`8005gi0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP2001cH0800?S?00<0IVIV
001cB@00LdT00P00n9d3001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`00
4W<000804W<000H09oP002Uc000YL`00IVIV02Uc001Hn00403mc000308Wh001GL`00Eg<00080Eg<0
0`2jm`040=cW00D0Lf8000<0mm8007=;001cB`000P1cB`000`3gX@00IVIV07<d000207<d00030000
003gL000mg00008000008P3gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@0
0P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh00030?OB002=G000SE`000<0SE`0
0`3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0V6<00P3gX@0609Q50080mg00
1P2H9`030?Lo000309P9003V3@00iPd00240iPd01@3f3P060:9900`0mg001P2R2@0T0?H>00@0ZTd0
0`3gL0070:X/0080mcl01`2Z2P0S0?H>0080/E003@3gL0070;4:0280mPh00P2hD`030?M`00L0^2l0
0`3g?`080;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00<0mcl02@322`0O0?H>00`0mg00
2@37300O0?H>0440oooo001<0?ooo`0306IVIP3oool0oooo00D0oooo00D0IVIV0?ooo`1c01H0L`0F
0?X0<@0207<0;@@0nP1S0`1c05/00`3i0<D0L`1b07<0LP020?T0m`0306IVIP1M07<0G@1c00<0A`1c
1@2I0?T301T0L`@00P1c00D0103i000DL`0057<0IVIV000/n@03000[L`05001Mn@00@W<0049c0012
L`00SoT00`00FG<20030n@<0071c00@00?7h001cH000Lf0007=P0P00n<l0101VIVH007=9001cB@00
n9d4001c<P03003hK000La/007<K008007<K00@00?Pk001c1000L`@007<40P00n0T4019c000402Oh
000YL`00:G<006IVIP80F?P0100oL`000`29n000Eg<005Mc000205Mc0080^_L01@3Li`0507=R0003
0?OB001cB`00Ld/00080Ld/000<0IVIV0?NQ001c=0000P1c=0000`000000mg000?M`000T0?M`0003
0;[g001kP@00Nh4000<0Nh400P3[m`04085^0080mm801@21E0020?NQ00@0PC/09@3gL00408J=0003
0>_g002=N000SGP000@0SGP000<0mm8008eL002=G0000`2=G0030?NQ00D0SD008`3gL002092H0080
joL01@2HPP030?OB00D0V6<00P3gX@0609Q50080mg001P2H9`030?Lo000309P9003V3@00iPd002H0
iPd01P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08`3f3P020;5@00d0
mg001`2a2P0R0?H>0080^5<00`3gL0070;P_00<0mcl0202h2`0Q0?H>00h0mg00202m2`0P0?H>0080
mg002032<P040?Lo00P0`P/07`3f3P0<0?M`00T0a``07`3f3P110?ooo`00C03oool00`1VIVH0oooo
0?ooo`050?ooo`0506IVIP3oool0L`0F07<05P3j03400P1c02d40?X0H`<0L`1K00<0n@3507<0LP1c
07800P3i0?L00`1VIVH0G@1c0<X0n@0304L0L`D0V@3i0`0I07<40080L`0500@0n@0057<001Ac06IV
IP00;?T00`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc0P00`?T3001`L`06003an000Lf00
07=P001cH000n<l0IVIV0`00LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K008007<K
00@00?Pk001c1000L`@007<40P00n0T4019c000402Oh000YL`00IVIV02Uc0080F?P0100oL`000`29
n000Eg<005Mc000205Mc00L0^_L01@1cHP000`3gdP00Ld/007=;000207=;000306IVIP3gX@00Lc@0
0080Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB
00D0PE@00P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh00030?OB002=G000SE`0
00<0SE`00`3gX@0508e002<0mg000P2@V0020>_g00D0V8800`3gdP0509QS0080mj401P2HA@020?M`
00H0V2L00`3g?`0Y0>H=00H0XTT0303gL0060:8902@0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:
02<0mPh00P2aD00=0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo00P0^0/08@3f3P0>0?M`
00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0@@3oool004`0
oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0oooo0?ooo`0207<05P<0L`0]103j06<307<0F`<0
L`1b00D0n@3g06IVIP1M07<0G@1c0<X0n@0304L0L`D0V@3i0`0I07<40080L`0500@0n@0057<0IVIV
000DL`00;?T00`00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc0P00`?T3001`L`06003an000
Lf0007=P001cH01VIVH00?S?0`00LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K0080
07<K00@00?Pk001c1000L`@007<40P00n0T3019c00809oP000<0:G<006IVIP0YL`000P1Hn00403mc
000308Wh001GL`00Eg<00080Eg<01`2jm`0507=R00050?OB001cB`00Ld/007=;001VIVH00P3gX@03
07<d00030000003gL000mg0002@0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP05
085D00030?NQ0021>`00PC/000<0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP000<0mm80
08eL002=G0000`2=G0030?NQ00D0SD008`3gL002092H0080joL01@2HPP030?OB00D0V6<00P3gX@06
09Q50080mg001P2H9`020?Lo02T0iPd000<0mj400:99002RB@00102RB@0<0?M`00H0XPT0903f3P04
0:Y=00<0mg001`2Z;0020?Lo00L0ZPX08`3f3P030;5@00`0mg001`2a2P0R0?H>0080^5<00`3gL007
0;P_00<0mcl0202h2`0Q0?H>00h0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<
0?M`00P0a``07`3f3P110?ooo`00C03oool00`1VIVH0oooo0?ooo`040?ooo`0306IVIP3oool0oooo
0080L`0F0`1c02d40?X0H`<0L`1K0`1c07801@3i0?L0IVIV05d0L`1M07<0bP3i00<0A`1c1@2I0?T3
01T0L`@00P1c00D0103i000DL`1VIVH001Ac000/n@03000[L`05001Mn@00@W<0049c0012L`00SoT0
0`00FG<20030n@<0071c00D00?7h001cH000Lf0007=P06IVIP04001cB@03003hW@00Lc8007<b0080
07<b00@00?Q/001c6`00La/007<K0P00n3/3001c10800?P90`0BL`0202Oh000306IVIP0YL`00:G<0
0080F?P00`0oL`0208Wh00@0Eg<01`2jm`0507=R00050?OB001cB`00Ld/007=;001VIVH00P3gX@03
07<d00030000003gL000mg0002@0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP05
085D00030?NQ0021>`00PC/000<0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP000<0mm80
08eL002=G0000`2=G0030?NQ00D0SD008`3gL002092H0080joL01@2HPP030?OB00@0V6<00`3gX@06
09Q50080mg001P2H9`080?Lo0280iPd00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd00`3gL007
0:X/0080mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:0280mPh00P2hD`030?M`00L0^2l00`3g?`08
0;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002037300O
0?H>0440oooo001<0?ooo`0306IVIP3oool0oooo00<0oooo00H0IVIV0?ooo`3oool0oooo07<05P3j
034307<0;@@0nP1S0`1c05/307<0LP0506IVIP3i0?L0G@1c05d0L`3:0?T00`1707<509T0n@<06@1c
100207<01@040?T0IVIV000DL`0057<002ci00<002]c00D005gi0012L`00@W<0049c002?n@03001I
L`800<3i0`00L7<01@00lOP007=P001cH01VIVH00?S?00@007=900<00?RM001c<P00Lc800P00Lc80
1000n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c000302Oh001VIVH0:G<00080:G<00P1H
n00303mc0080ROP0101GL`070;[g00@0Lf800P3gdP0207=;000406IVIP1cB`00mj400?NQ00<0Lc@0
00<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0PE@0
00<0mj40084k0021>`000`21>`0U0?M`00<0QXd00P3[m`0608eh00030?OB002=G000SE`000<0SE`0
0`3gX@0508e002<0mg000P2@V0020>_g00D0V8800`3gdP0409QS00<0mj401P2HA@020?M`00H0V2L0
3P3g?`0K0>H=00030:9Y003gX@00mj4000H0XTT0303gL0060:8902@0mPh0102ZC@030?M`00L0ZR`0
0P3g?`070:X:02<0mPh00`2aD00<0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`040?Lo00L0^0/0
8@3f3P0>0?M`00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<0200mPh0
@03oool004`0oooo00<0IVIV0?ooo`3oool00`3oool01P1VIVH0oooo0?ooo`3oool0L`0F0?X0<@<0
L`0]103j06<307<0F`<0L`1b00D0IVIV0?T0m`1M07<0G@1c0<X0n@0204L0L`H0V@3i0P0I07<00`0f
0?T00P1c0080L`020080L`03000DL`1VIVH001Ac008002ci0`00:g<01@00GOT0049c0012L`00@W<0
08oi00<005Uc0P00`?T3001`L`05003an000Lf0007=P06IVIP00n<l01000LdT00`00n9d007<b001c
<P02001c<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h2@<04W<000<09oP006IVIP0YL`00
0P0YL`0205Sh00<0?g<00P29n00405Mc00L0^_L0101cHP020?OB0080Ld/000<0IVIV07=;003gX@00
101c=0000`000000mg000?M`000T0?M`00030;[g001kP@00Nh4000<0Nh400P3[m`04085^0080mm80
1@21E0000`3gX@00PC/0084k0003084k02D0mg000`26S@020>_g00H0SGP000<0mm8008eL002=G000
0`2=G0030?NQ00D0SD008`3gL002092H0080joL01@2HPP030?OB00@0V6<00`3gX@0609Q50080mg00
1P2H9`0D0?Lo01D0iPd000<0XVT00?NQ003gX@001P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg00
1`2Z;0020?Lo00L0ZPX08`3f3P030;5@00`0mg001`2a2P0S0?H>00040;QC003gL000mg000?M`00L0
^2l0103g?`070;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0
mg002037300P0?H>0400oooo001<0?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?ooo`3oool0
0P3oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S0P1c05/0103i0<D0L`1b07<0LP1VIVH20?T0m`80
G@1c00<0bP3i04L0L`1707<01@2I0?T301T0L`0303H0n@0207<00P1c00800P1c00@0IVIV000DL`00
57<002ci0`00:g<2001Mn@<0049c00@008oi001IL`00FG<005Uc0P00`?T2001`L`800?7h00@007=P
06IVIP00Lf000?S?1000LdT00`00n9d007<b001c<P02001c<P04003hK000La/007<K001c6`800?Pk
0`00L`@2003h2@<04W<000<0IVIV02Oh000YL`000P0YL`0205Sh00<0?g<00P29n00405Mc00L0^_L0
101cHP020?OB000507=;001VIVH0Ld/007=;003gX@00101c=0000`000000mg000?M`000T0?M`0003
0;[g001kP@00Nh400080Nh400`3[m`04085^0080mm801@21E0000`3gX@00PC/0084k0003084k02D0
mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj401@2=@00S0?M`0080T9P00P3[m`0509R200<0
mm80102HH`030?NQ00H0V4D00P3gL00609PW01X0mcl03P3V3@020:9Y0080mj401P2RB@0<0?M`00H0
XPT0903f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08`3f3P030;5@00`0mg001`2a2P0S0?H>0004
0;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b
00@0mcl020322`0P0?H>00`0mg002037300P0?H>0400oooo001<0?ooo`0306IVIP3oool0oooo0080
oooo00<0IVIV0?ooo`3oool00P3oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S0P1c05/01@3i0<D0
L`1b07<0LP1VIVH0n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T301T0L`0603H0n@0207<00P1c
0080L`040?T0IVIV0P0057<01000;?T002]c000[L`00:g<2001Mn@80049c0P00SoT3001IL`040030
n@00L7<0071c001`L`800?7h00@007=P06IVIP00Lf000?S?1000LdT00`00n9d007<b001c<P02001c
<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h2@<04W<000<0IVIV02Uc000YL`000P0YL`02
05Sh00<0?g<00P29n00405Mc00L0^_L0101cHP020?OB000506IVIP1cB`00Ld/007=;003gX@00101c
=0000`000000mg000?M`000T0?M`00030;[g001kP@00Nh400080Nh400`3[m`04085^0080mm801@21
E0000`3gX@00PC/0084k0003084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj401@2=
@00S0?M`0080T9P00P3[m`0509R200<0mm80102HH`030?NQ00H0V4D00P3gL00609PW0200mcl01`3V
3@030:9Y0080mj401P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0020?Lo00L0ZPX08`3f
3P030;5@00`0mg001`2a2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh0
3P3gL0080;d;0200mPh00`3gL0070<8b00@0mcl020322`0P0?H>00`0mg002037300P0?H>0400oooo
001<0?ooo`0306IVIP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0oooo0P1c01H00`3j0340L`0]
07<0;@050?X0H`80L`1K00D0n@3507<0LP1VIVH0L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c00D0
V@3i0`0I07<01@0f0?T00P1c0080L`0207<0IVIV00<001Ac00@002ci000[L`00:g<002]c0P00GOT2
0012L`8008oi0`00FG<01000`?T0071c001`L`00L7<2003an00406IVIP00Lf0007=P003hc`@007=9
00@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<40P00n0T2019c0003
06IVIP0Wn000:G<000<0:G<00P1Hn00303mc0080ROP00`1GL`080;[g00@0Lf8000<0mm8007=;001V
IVH00`1cB`000`3gX@00Lc@007<d000207<d00030000003gL000mg0002@0mg0000<0^_L007^1001k
P@000P1kP@030>_g00@0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080
mm801@2=G0030?NQ00D0SD008`3gL002092H0080joL01@2HPP030?OB00@0V6<00`3gX@0609Q50080
mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0
ZTd00`3gL0070:X/0080mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<00?M`003g
L000mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P030?M`
00L0`S80103g?`080<8;0200mPh0303gL0080<L<0200mPh0@03oool004`0oooo00D0IVIV0?ooo`3o
ool0oooo06IVIP040?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<207<0F`050?T0a@1c0780IVIV
07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c00D0=P3i0080L`0207<00P1c06IV
IP03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0
071c0P00lOP0101VIVH007=P001cH000n<l4001cB@04003hW@00Lc8007<b001c<P800?Q/0`00La/0
0`00n3/007<4001c1002001c1006003h2@0BL`004W<0019c001VIVH09oP0100YL`0205Sh00<0?g<0
0P29n00305Mc00P0^_L0101cHP000`3gdP00IVIV07=;000307=;00030?NQ001c=000Lc@00080Lc@0
00<000000?M`003gL000903gL0000`2jm`00Nh4007^1000207^100<0joL01021KP020?OB00@0PE@0
0P3gX@05084k02D0mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj40102=@00T0?M`0080T9P0
0P3[m`0509R200<0mm80102HH`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002RJ@00
102RJ@020?NQ00H0XTT0303gL0060:8902@0mPh0102ZC@030?M`00L0ZR`00P3g?`070:X:02<0mPh0
0`2aD00<0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>0003
0;eF003gL000mg0000/0mg00202m2`0P0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00T0
a``07`3f3P100?ooo`00B`3oool00`1VIVH0oooo0?ooo`020?ooo`0306IVIP3oool0oooo0080oooo
0P1c01H00`3j0340L`0]07<0;@050?X0H`80L`1K00D0n@3506IVIP1c0780L`1b0?T0m`0305d0L`03
0<X0n@1707<0A`1c00D0V@3i0`0I07<01@0f0?T00P1c0080L`1VIVH0103i00<001Ac00@002ci000[
L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01P00`?T0071c001`L`00L7<00?7h06IVIP<007=P
00<00?S?001cB@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c1000
L`@00P00L`@01P00n0T04W<0019c001VIVH04W<002Oh00@0:G<00P1Hn00303mc0080ROP00`1GL`08
0;[g00@0Lf8000<0mm8006IVIP1cB`000`1cB`001P3gX@00Lc@007<d001c=000000007<d02H0mg00
00<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd0
0P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00903gL002092H0080joL01@2HPP030?OB00@0V6<0
0`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg00
1P2R2@0T0?H>00@0ZTd00`3gL0070:X/0080mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:02<0mPh0
00@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00P0
_@/0803f3P030?M`00L0`S80103g?`080<8;0200mPh0303gL0090<L<01l0mPh0@03oool004/0oooo
00D0IVIV0?ooo`3oool0oooo06IVIP050?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<207<0F`05
0?T0a@1VIVH0L`1b07<0LP3i0?L00`1M07<304L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`1VIVH0
103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01P00`?T0071c001`
L`00L7<00?7h06IVIP<007=P00@00?S?001cB@00LdT007=90P00n9d3001c<P800?Q/0`00La/00`00
n3/007<4001c1002001c1006003h2@0BL`004W<006IVIP0BL`009oP0100YL`000`1Hn000?g<003mc
000203mc0080ROP00`1GL`080;[g00@0Lf8000<0IVIV07=;001cB`000`1cB`001P3gX@00Lc@007<d
001c=000000007<d02H0mg0000<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080
mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00903gL002092H0080
joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0
XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd00`3gL0070:X/0080mcl0202Z2P0R0?H>00<0
/E00303gL0070;4:02<0mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P000`2m
EP00mg000?M`000;0?M`00P0_@/0803f3P030?M`00L0`S80103g?`080<8;0200mPh0303gL0090<L<
01l0mPh0@03oool004/0oooo00D0IVIV0?ooo`3oool0oooo06IVIP050?ooo`80L`0F00<0nP0a07<0
;@1c02d0103j06<307<0F`0506IVIP1c0780L`1b07<0LP3i0?L00`1M07<304L0L`D0V@3i0`0I07<0
1@0f0?T00P1c06IVIP0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi
0`00FG<01P00`?T0071c001`L`00L7<0IVIV003an0<007=P00@00?S?001cB@00LdT007=90P00n9d3
001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`00IVIV00804W<000<09oP0
02Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00`1GL`080;[g00@0Lf8000<0IVIV
07=;001cB`000`1cB`001P3gX@00Lc@007<d001c=000000007<d02H0mg0000<0^_L007^1001kP@00
0P1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080mm80
1@2=G0030?NQ00@0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080mg00
1P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd0
0`3gL0070:X/0080mcl0202Z2P0R0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<00?M`003gL000
mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00P0_@/08@3f3P020?M`00L0
`S80103g?`090<8;01l0mPh0303gL0090<L<01l0mPh0@03oool004/0oooo00@0IVIV0?ooo`3oool0
IVIV1P3oool207<05P030?X0<@1c02d0L`0]00@0nP1S0`1c05/00`1VIVH0L`1b07<0LP020?T0m`80
G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T301T0L`800P1c00<0IVIV0080L`040?T00`0057<01000
;?T002]c000[L`00:g<2001Mn@80049c0P00SoT2001IL`800<3i0`00L7<0101VIVH00?7h001cH000
Lf02003hc`<007=90P00n9d3001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0B
L`00IVIV00804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc000203mc0080ROP00`1G
L`080;[g00<0Lf8000<0IVIV0?OB001cB`00101cB`001@3gX@00Lc@007<d001c=000000002L0mg00
00<0^_L007^1001kP@000P1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd0
0P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<0
0`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg00
1P2R2@0T0?H>00@0ZTd00`3gL0070:X/0080mcl0202Z2P0R0?H>00<0/E00303gL0080;4:0280mPh0
00@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00T0
_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<01l0mPh0@03oool004/0oooo
00@0IVIV0?ooo`3oool0IVIV1P3oool207<05P<0L`0]103j06<207<0F`0406IVIP1c0780L`1b07<0
LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c00D00P1c06IVIP0207<00P1c00@0
n@03000DL`05000/n@00:g<002]c000[L`00GOT00`00@W<01000SoT005Uc001IL`00FG<20030n@80
071c00<0IVIV003an000Lf000P00Lf02003hc`<007=90P00n9d3001c<P800?Q/0`00La/00`00n3/0
07<4001c1002001c1003003h2@1VIVH04W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000
?g<003mc000203mc0080ROP00`1GL`070;[g00<0Lf8000<0IVIV07=R003gdP001@1cB`001@3gX@00
Lc@007<d001c=000000002L0mg001@1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`
00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00903gL002092H0080joL01@2HPP020?OB
00D0V6<00`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:99
00`0mg001P2R2@0T0?H>00@0ZTd00`3gL0070:X/0080mcl0202Z2P0R0?H>00<0/E00303gL0080;4:
0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000<
0?M`00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<0200mPh0?`3oool0
04/0oooo00<0IVIV0?ooo`1VIVH01`3oool207<05P<0L`0]103j06<207<0F`0406IVIP1c0780L`1b
07<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c00D00P1c06IVIP0207<00P1c
00@0n@03000DL`05000/n@00:g<002]c000[L`00GOT00`00@W<01000SoT005Uc001IL`00FG<20030
n@80071c00<0IVIV003an000Lf000P00Lf02003hc`<007=900<00?RM001c<P00Lc800P00Lc800`00
n6`007<K001c6`02001c6`04003h>`00L`@007<4001c10800?P900D0IVIV019c000BL`004W<002Oh
000302Uc0080F?P0100oL`0208Wh00<0Eg<01`2jm`0307=R000306IVIP1cHP00mm8000D0Ld/000D0
mj4007<d001c=000Lc@00000000W0?M`00D0Nh400P3[m`05085^0080mm801021E0020?NQ00D0PC/0
9@3gL00308J=0080joL01@2=N0020?OB00D0SE`00`3gX@0408e002@0mg000P2@V0020>_g00D0V880
0P3gdP0509QS00<0mj401P2HA@020?M`00H0V2L08`3g?`000`3gdP00XVT00:9Y00040:9Y0080mj40
1P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00`0mg00
202a2P0R0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0280mPh03P3gL0080;d;0200
mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002037300P0?H>03l0oooo001;0?ooo`0306IV
IP3oool0IVIV00L0oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0H`0307<0F`1VIVH0L`1K00<0L`1b
0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<01@1VIVH00P1c0080L`0207<0103i
00<001Ac00D002ci000[L`00:g<002]c001Mn@030012L`04002?n@00FG<005Uc001IL`800<3i00@0
071c06IVIP00L7<00?7h0`00Lf02003hc`<007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K
001c6`02001c6`06003h>`00L`@007<4001c1000n0T0IVIV100BL`00100Wn000:G<002Uc000YL`02
05Sh00@0?g<000<0ROP005Mc001GL`000P1GL`070;[g0080Lf8000@0IVIV07=R001cHP00mm801@1c
B`001@3gX@00Lc@007<d001c=000000002H0mg0000<0^_L007^1001kP@000`1kP@020>_g00D0PFh0
0P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00@0SD00
903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB
002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd00`3gL0070:X/00<0mcl0
1`2Z2P0R0?H>00<0/E00303gL0080;4:0280mPh000@0^5<00?M`003gL000mg001`2h;`040?Lo00L0
^0/08P3f3P0>0?M`00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0080<L<0200
mPh0?`3oool004/0oooo0P1VIVH80?ooo`0307<05P3j0340L`0]0080L`0]103j06<00`1c05/0IVIV
07<0F`0307<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c00D0IVIV0080L`02
07<00P1c00@0n@03000DL`05000/n@00:g<002]c000[L`00GOT00`00@W<01000SoT005Uc001IL`00
FG<20030n@04001`L`1VIVH0071c003an0<007=P0P00n<l3001cB@03003hW@00Lc8007<b008007<b
00<00?Q/001c6`00La/00P00La/01P00n3/007<4001c1000L`@0IVIV003h2@@04W<000@09oP002Uc
000YL`00:G<00P1Hn00403mc000308Wh001GL`00Eg<00080Eg<01`2jm`0207=R000406IVIP1cHP00
Lf800?OB00@0Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L007^1001kP@000`1k
P@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0508eh0080mm801@2=
G0020?NQ00D0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080mg001P2H
9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd00`3g
L0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`020?M`00L0^2l0103g
?`070;P;0280mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002037
300P0?H>03l0oooo001;0?ooo`80IVIV203oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S00<0IVIV
07<0F`3i0<D00`1c07820?T0m`80G@1c00<0bP3i04L0L`1707<01P2I0?T201T0L`0306IVIP0207<0
0P1c00800P1c100057<01@00;?T002]c000[L`00:g<005gi00<0049c00@008oi001IL`00FG<005Uc
0P00`?T0101VIVH0071c001`L`00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00
Lc800P00Lc800`00n6`007<K001c6`02001c6`06003h>`00L`@007<4001c101VIVH00?P90`0BL`02
02Oh00<0:G<00P1Hn00403mc000308Wh001GL`00Eg<00080Eg<01`2jm`000`1cHP00IVIV07=R0002
07=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L0
07^1001kP@000`1kP@020>_g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`05
08eh0080mm801@2=G0020?NQ00D0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@06
09Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T
0?H>00@0ZTd00`3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`02
0?M`00L0^2l0103g?`070;P;0280mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0P
0?H>00`0mg002037300P0?H>03l0oooo001;0?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F0?X0
<@1c02d00P1c02d40?X0H`0306IVIP1c05/0n@3500<0L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c
00D0V@3i0`0I07<00`1VIVH00P1c0080L`020080L`<001Ac00<002ci000[L`00:g<00P00:g<01@00
GOT0049c0012L`00@W<008oi00<005Uc0P00`?T0101VIVH0071c001`L`00lOP3001cH003003hc`00
LdT007=9008007=900<00?RM001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`8007<4
00<0IVIV003h2@00n0T00`0BL`0202Oh00<0:G<00P1Hn00403mc000308Wh001GL`00Eg<00080Eg<0
1`2jm`000`1cHP00IVIV07=R000207=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000
003gL000mg0002@0mg0000<0^_L007^1001kP@000`1kP@020>_g00D0PFh000<0mm80085D0021E000
0`21E0020?NQ00@0PC/09@3gL00408J=0080joL01@2=N0020?OB00D0SE`00P3gX@0508e002@0mg00
0P2@V0020>_g00D0V8800P3gdP0509QS00<0mj401P2HA@020?M`00H0V2L08`3g?`000`3gdP00XVT0
0:9Y00040:9Y0080mj401P2RB@0<0?M`00H0XPT0903f3P040:Y=00<0mg001`2Z;0030?Lo00L0ZPX0
8P3f3P030;5@00d0mg001`2a2P0R0?H>0080^5<00P3gL0080;P_00<0mcl0202h2`0Q0?H>00h0mg00
202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<0?M`00P0a``0803f3P0o0?ooo`00B`3o
ool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00<0nP0a07<0;@1c02d0103j06<0101VIVH0L`1K07<0
F`3i0<D307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<509T0n@806@1c00<0IVIV03H0n@02
07<00`0207<3000DL`04000/n@00:g<002]c000[L`8005gi0`00@W<01P00SoT005Uc001IL`00FG<0
0<3i06IVIP80071c0P00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00
Lc801000n6`007<K001c6`00La/2003h>`8007<400<0IVIV003h2@00n0T00`0BL`0202Oh00<0:G<0
0P1Hn00303mc0080ROP0101GL`070;[g000306IVIP1cHP00Lf800080Lf8000<0mm8007=;001cB`00
0P1cB`020?NQ00<0Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080joL0
1@21KP000`3gdP00PE@0085D0003085D0080mj401021>`0U0?M`00@0QXd00P3[m`0508eh0080mm80
1@2=G0020?NQ00D0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080mg00
1P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00@0ZTd0
0`3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`020?M`00P0^2l0
0`3g?`080;P;0240mPh03P3gL0080;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg00
2@37300O0?H>03l0oooo001:0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H00`3j0340L`0]07<0
;@040?X0H`0406IVIP1c05/0L`1K0?T0a@<0L`1b00D0n@3g05d0L`1M07<0G@1c0<X0n@0204L0L`D0
V@3i0P0I07<00`1VIVH0=P3i0080L`020080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001M
n@80049c0P00SoT3001IL`040030n@1VIVH0071c001`L`800?7h0`00Lf000`00n<l007=9001cB@02
001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c6`00La/007<K0P00n3/00`00L`@0IVIV001c
1002003h2@<04W<00P0Wn00302Uc0080F?P00`0oL`0208Wh00@0Eg<01`2jm`00101VIVH0Lf8007=R
001cHP020?OB00@0Ld/00P3gX@0307<d00030000003gL000mg0002@0mg0000<0^_L007^1001kP@00
0`1kP@020>_g00D0PFh000<0mm80085D0021E0000`21E0020?NQ00@0PC/09@3gL00408J=0080joL0
1@2=N0020?OB00D0SE`00P3gX@0508e002@0mg000P2@V0020>_g00D0V8800P3gdP0509QS00<0mj40
1P2HA@020?M`00H0V2L08`3g?`000`3gdP00XVT00:9Y00040:9Y0080mj401P2RB@0<0?M`00H0XPT0
903f3P040:Y=00<0mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00d0mg001`2a2P0R0?H>0080^5<0
0`3gL0070;P_00<0mcl0202h2`0Q0?H>00h0mg00202m2`0P0?H>00<0mg001`32<P040?Lo00P0`P/0
803f3P0<0?M`00T0a``07`3f3P0o0?ooo`00BP3oool306IVIPL0oooo0P1c01H00`3j0340L`0]07<0
;@040?X0H`0406IVIP1c05/0L`1K0?T0a@<0L`1b00D0n@3g05d0L`1M07<0G@1c0<X0n@0204L0L`D0
V@3i00@06@1c06IVIP0I07<0=P3i0`0207<01@040?T001Ac000DL`0057<002ci00<002]c0P00GOT2
0012L`8008oi0`00FG<0101VIVH0071c001`L`00L7<2003an0<007=P00<00?S?001cB@00LdT00P00
LdT00`00n9d007<b001c<P02001c<P04003hK000La/007<K001c6`800?Pk00<007<406IVIP00L`@0
0P00n0T3019c00809oP00`0YL`0205Sh00<0?g<00P29n00405Mc00H0^_L000<0IVIV07=R001cHP00
0P1cHP020?OB00@0Ld/000<0mj4007<d001c=0000P1c=0000`000000mg000?M`000T0?M`00030;[g
001kP@00Nh4000<0Nh400P3[m`05085^00030?OB0021E000PE@000<0PE@00P3gX@04084k02D0mg00
1026S@020>_g00D0SGP00P3gdP0508eL0080mj401@2=@00T0?M`0080T9P00P3[m`0509R20080mm80
1@2HH`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0
303gL0060:8902@0mPh0102ZC@030?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X0
8P3f3P020;QC00<0mg001`2h;`030?Lo00P0^0/08@3f3P0>0?M`00P0_@/0803f3P030?M`00L0`S80
103g?`080<8;0200mPh0303gL0090<L<01l0mPh0?`3oool004X0oooo00<0IVIV0?ooo`3oool01P1V
IVH0103oool0L`0F07<05P3j034207<0;@<0nP1S00D0IVIV0?X0H`1c05/0L`1K0?T0a@0307<0LP05
0?T0m`1M07<0G@1c05d0L`3:0?T00P1707<509T0n@0401T0L`1VIVH06@1c03H0n@<00P1c00D0103i
000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<2002?n@<005Uc00@0IVIV001`L`00L7<0071c
0P00lOP3001cH003003hc`00LdT007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03
003h>`00L`@0IVIV008007<40P00n0T3019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc0080
ROP0101GL`050;[g000306IVIP2jm`00Lf8000<0Lf800P3gdP0407=;00030?NQ001c=000Lc@00080
Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080joL01021KP020?OB00D0
PE@00P3gX@04084k02D0mg001026S@020>_g00D0SGP00P3gdP0508eL0080mj401@2=@00T0?M`0080
T9P00P3[m`0509R20080mm801@2HH`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002R
J@00102RJ@020?NQ00H0XTT0303gL0060:8902@0mPh0102ZC@030?M`00L0ZR`00`3g?`070:X:0280
mPh00`2aD00=0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo00P0^0/08@3f3P0>0?M`00P0
_@/0803f3P030?M`00L0`S80103g?`080<8;0200mPh0303gL0090<L<01l0mPh0?`3oool004X0oooo
00<0IVIV0?ooo`3oool01P3oool0101VIVH0L`0F07<05P3j034207<0;@<0nP1S00D0IVIV07<0F`1c
05/0L`1K0?T0a@0307<0LP040?T0m`1M07<0G@1c05d0L`<0A`1c1@2I0?T0101VIVH06@1c01T0L`0f
0?T30080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@80049c0P00SoT2001IL`0306IV
IP00`?T0071c0080071c0P00lOP3001cH003003hc`00LdT007=9008007=900@00?RM001c<P00Lc80
07<b0P00n6`3001c6`03003h>`00L`@0IVIV008007<40P00n0T3019c000302Oh000YL`00:G<00080
:G<00P1Hn00303mc0080ROP00`1GL`060;[g000306IVIP2jm`00Lf8000<0Lf800P3gdP0407=;0003
0?NQ001c=000Lc@00080Lc@000<000000?M`003gL000903gL0000`2jm`00Nh4007^1000307^10080
joL01021KP020?OB00D0PE@00P3gX@04084k02D0mg001026S@000`3[m`00SGP008eh000408eh0080
mm801@2=G0020?NQ00D0SD00903gL002092H0080joL01@2HPP020?OB00D0V6<00`3gX@0609Q50080
mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00D0
ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`030?M`00L0
^2l00`3g?`080;P;0240mPh03P3gL0080;d;0200mPh00`3gL0070<8b00@0mcl020322`0P0?H>00`0
mg002@37300O0?H>03l0oooo001:0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H00`3j0340L`0]
07<0;@020?X0H`0306IVIP3j06<0L`1K0080L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`<0
A`1c1@2I0?T0101VIVH06@1c01T0L`0f0?T30080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2
001Mn@80049c0P00SoT2001IL`0306IVIP00`?T0071c0080071c0P00lOP3001cH004003hc`00LdT0
07=9001cB@800?RM0`00Lc82003hK0<007<K00<00?Pk06IVIP00L`@00P00L`@00`00n0T04W<0019c
0002019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc0080ROP00`1GL`050;[g000306IVIP2j
m`00^_L000@0Lf8000<0mm8007=;001cB`000`1cB`000`3gX@00Lc@007<d000207<d00030000003g
L000mg0002@0mg0000<0^_L007^1001kP@000`1kP@020>_g00@0PFh00P3gdP05085D0080mj401021
>`0U0?M`00@0QXd000<0joL008eh002=N000102=N0020?OB00D0SE`00P3gX@0508e002@0mg000P2@
V0020>_g00D0V8800P3gdP0509QS00<0mj401P2HA@020?M`00H0V2L08`3g?`000`3gdP00XVT00:9Y
00040:9Y0080mj401P2RB@0<0?M`00H0XPT0903f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f
3P030;5@00d0mg001`2a2P0R0?H>0080^5<00`3gL0070;P_00@0mcl01`2h2`0Q0?H>00h0mg00202m
2`0P0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0n0?ooo`00BP3oool0
0`1VIVH0oooo0?ooo`070?ooo`80L`0F0`1c02d20?X0H`0306IVIP3j06<0L`1K0080L`1K00<0n@35
07<0LP1c07800P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`@0V@3i00D0IVIV01T0L`0I07<06@1c
03H0n@030080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@80049c0P00SoT01000FG<0
IVIV001IL`00`?T3001`L`800?7h0`00Lf001000n<l007=9001cB@00LdT2003hW@<007<b0P00n6`3
001c6`03003h>`1VIVH007<4008007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc0002
02Uc0080F?P00`0oL`0208Wh00<0Eg<01@2jm`000`1VIVH0^_L00;[g000407=R00030?OB001cB`00
Ld/000<0Ld/000<0mj4007<d001c=0000P1c=0000`000000mg000?M`000T0?M`00030;[g001kP@00
Nh4000<0Nh400P3[m`04085^0080mm801@21E0020?NQ00@0PC/09@3gL00408J=00030>_g002=N000
SGP000@0SGP00P3gdP0508eL0080mj401@2=@00T0?M`0080T9P00P3[m`0509R20080mm801@2HH`03
0?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0303gL006
0:8902@0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08P3f3P02
0;QC00<0mg001`2h;`040?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00P0_@/0803f3P03
0?M`00L0`S80103g?`090<8;0200mPh0303gL0080<L<0200mPh0?P3oool004X0oooo00<0IVIV0?oo
o`3oool01`3oool207<05P<0L`0]00@0nP1S06IVIP3j06<0nP1S0`1c05/307<0LP80n@3g0P1M07<0
103:0?T0A`1c04L0L`1707<409T0n@0406IVIP0I07<06@1c01T0L`@00P1c00D0103i000DL`0057<0
01Ac000/n@03000[L`04001Mn@00@W<0049c0012L`8008oi00@005Uc06IVIP00`?T00<3i0`00L7<2
003an08007=P0P00n<l3001cB@800?RM0`00Lc82003hK0<007<K00<0IVIV001c1000L`@00P00L`@0
0`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`02
08Wh00<0Eg<0102jm`00101VIVH0^_L00;[g002jm`0407=R00030?OB001cB`00Ld/000<0Ld/000<0
mj4007<d001c=0000P1c=0000`000000mg000?M`000T0?M`00030;[g001kP@00Nh4000<0Nh400P3[
m`04085^0080mm801@21E0000`3gX@00PC/0084k0003084k02D0mg001026S@000`3[m`00SGP008eh
000408eh0080mm80102=G0030?NQ00D0SD00903gL002092H0080joL0102HPP030?OB00D0V6<00`3g
X@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R
2@0T0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:0280mPh00P2h
D`030?M`00L0^2l0103g?`070;P;0240mPh000<0_EH00?M`003gL0002`3gL0080;d;0240mPh00P3g
L0080<8b00@0mcl020322`0P0?H>00`0mg002037300P0?H>03h0oooo001:0?ooo`0306IVIP3oool0
oooo00L0oooo00<0L`0F0?X0<@1c02d00P1c02d0103j06<0IVIV0?X0H`3j06<307<0F`<0L`1b0P3i
0?L205d0L`040<X0n@1707<0A`1c04L0L`<0V@3i00<0IVIV09T0n@0I07<00P0I07<40080L`0500@0
n@0057<001Ac000DL`00;?T00`00:g<02000GOT0049c0012L`00@W<008oi001IL`1VIVH005Uc0P00
`?T3001`L`800?7h0P00Lf02003hc`<007=90P00n9d3001c<P800?Q/0`00La/00`1VIVH007<4001c
1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`000`1Hn000?g<003mc
000203mc0080ROP00`1GL`040;[g000406IVIP2jm`00^_L00;[g00@0Lf8000<0mm8007=;001cB`00
0`1cB`001P3gX@00Lc@007<d001c=000000007<d02H0mg0000<0^_L007^1001kP@000P1kP@030>_g
00@0PFh00P3gdP05085D00030?NQ0021>`00PC/000<0PC/09@3gL00408J=00030>_g002=N000SGP0
00@0SGP00P3gdP0408eL00<0mj401@2=@00T0?M`0080T9P00P3[m`0409R200<0mm801@2HH`030?NQ
00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0303gL0060:89
02@0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:0280mPh00`2aD00=0?M`00L0/@X08`3f3P00102h
D`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q0?H>00030;eF003gL000mg0000/0mg002@2m2`0P
0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<0?M`00P0a``0803f3P0n0?ooo`00BP3oool00`1V
IVH0oooo0?ooo`070?ooo`0307<05P3j0340L`0]0080L`0]00@0IVIV0?X0H`3j06<0nP1S0`1c05/3
07<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<309T0n@0306IVIP2I0?T06@1c00806@1c1002
07<01@040?T001Ac000DL`0057<002ci00<002]c00P005gi0012L`00@W<0049c002?n@00FG<0IVIV
001IL`800<3i0`00L7<01000lOP007=P001cH000Lf02003hc`<007=90P00n9d3001c<P800?Q/0P00
La/00`1VIVH00?Pk001c1003001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0Y
L`000`1Hn000?g<003mc000203mc0080ROP00`1GL`030;[g000306IVIP2jm`00^_L00080^_L0101c
HP000`3gdP00Ld/007=;000307=;00060?NQ001c=000Lc@007<d00000000Lc@09P3gL0000`2jm`00
Nh4007^1000207^100<0fnH01021KP020?OB00D0PE@000<0mj40084k0021>`000`21>`0U0?M`00@0
QXd000<0joL008eh002=N000102=N0020?OB00@0SE`00`3gX@0508e002@0mg000P2@V0020>_g00@0
V8800`3gdP0509QS00<0mj401P2HA@020?M`00H0V2L08`3g?`000`3gdP00XVT00:9Y00040:9Y0080
mj401P2RB@0<0?M`00H0XPT0903f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08P3f3P030;5@00d0
mg001`2a2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0240mPh000<0_EH00?M`
003gL0002`3gL0090;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002037300P0?H>
03h0oooo001:0?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F0?X0<@1c02d00P1c02d0101VIVH0
nP1S0?X0H`3j06<207<0F`040?T0a@1c0780L`1b07<0LP80n@3g0P1M07<00`3:0?T0A`1c04L0L`03
09T0n@0306IVIP2I0?T0V@3i00<06@1c100207<01@040?T001Ac000DL`0057<002ci00<002]c00H0
05gi0012L`00@W<0049c002?n@1VIVH2001IL`800<3i0`00L7<01000lOP007=P001cH000Lf02003h
c`<007=900<00?RM001c<P00Lc800P00Lc801P00n6`007<K001c6`1VIVH007<K003h>`<007<40P00
n0T4019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`0208Wh00<0Eg<00P2j
m`000`1VIVH0^_L00;[g00020;[g00D0Lf8000<0mm8007=;001cB`000`1cB`001P3gX@00Lc@007<d
001c=000000007<d02H0mg0000@0^_L007^1001kP@00Nh40103KiP04085^0080mm801@21E0000`3g
X@00PC/0084k0003084k02D0mg001026S@000`3[m`00SGP008eh000408eh0080mm80102=G0030?NQ
00D0SD00903gL002092H0080joL0102HPP030?OB00D0V6<00`3gX@0609Q50080mg001P2H9`0S0?Lo
00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00D0ZTd00P3gL0070:X/
00<0mcl01`2Z2P0R0?H>00<0/E003@3gL0070;4:02<0mPh000@0^5<00?M`003gL000mg001`2h;`04
0?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00T0_@/0803f3P020?M`00P0`S80103g?`08
0<8;0200mPh0303gL0080<L<0200mPh0?P3oool004X0oooo00<0IVIV0?ooo`3oool01P3oool207<0
5P040?X0<@1c02d0L`0]06IVIP@0nP1S0P1c05/0103i0<D0L`1b07<0LP1c07820?T0m`80G@1c00<0
bP3i04L0L`1707<00`2I0?T00`1VIVH0V@3i09T0n@0301T0L`@00P1c100057<01@00;?T002]c000[
L`00:g<005gi00<0049c00@008oi06IVIP00FG<005Uc0P00`?T3001`L`04003an000Lf0007=P001c
H0800?S?0`00LdT00`00n9d007<b001c<P02001c<P06003hK000La/007<K06IVIP00La/00?Pk0`00
L`@2003h2@@04W<000@09oP002Uc000YL`00:G<00P1Hn00403mc0080ROP00`1GL`020;[g000306IV
IP2jm`00^_L00080^_L01@1cHP000`3gdP00Ld/007=;000307=;00050?NQ001c=000Lc@007<d0000
00009`3gL000102jm`00Nh4007^1001kP@040=_V00@0PFh00P3gdP05085D00030?NQ0021>`00PC/0
00<0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP00P3gdP0408eL00<0mj401@2=@00T0?M`
0080T9P00P3[m`0409R200<0mm801@2HH`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y
002RJ@00102RJ@020?NQ00H0XTT0303gL0060:8902@0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:
02<0mPh00P2aD00=0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0Q
0?H>00030;eF003gL000mg0000`0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<
0?M`00P0a``0803f3P0n0?ooo`00BP3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00@0nP0a07<0
;@1c02d0IVIV103j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0
L`0209T0n@0306IVIP2I0?T0V@3i00<06@1c00<0=P3i0080L`0207<00P0207<3000DL`03000/n@00
:g<002]c008002]c00D005gi0012L`00@W<0049c06IVIP03001IL`800<3i0`00L7<01@00lOP007=P
001cH000Lf000?S?00@007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K06IVIP02001c6`04
003h>`00L`@007<4001c10800?P9100BL`00100Wn000:G<002Uc000YL`0205Sh00@0?g<000<0ROP0
05Mc001GL`000P1GL`000`2jm`00IVIV0;[g00040;[g00D0Lf8000<0mm8007=;001cB`000`1cB`00
1@3gX@00Lc@007<d001c=000000000L0i6L0803gL0000`2jm`00Nh4007^100040=_V00D0PFh00P3g
dP05085D00030?NQ0021>`00PC/000<0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP00P3g
dP0408eL00<0mj401@2=@00T0?M`0080T9P00P3[m`0409R200<0mm801@2HH`030?NQ00H0V4D00P3g
L00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0303gL0060:8902@0mPh01@2Z
C@020?M`00L0ZR`00`3g?`070:X:02<0mPh00P2aD00=0?M`00L0/@X08`3f3P00102hD`00mg000?M`
003gL0070;P_00@0mcl01`2h2`0Q0?H>00030;eF003gL000mg0000`0mg00202m2`0P0?H>0080mg00
2032<P040?Lo00P0`P/0803f3P0<0?M`00T0a``07`3f3P0n0?ooo`00B@3oool00`1VIVH0oooo0?oo
o`070?ooo`80L`0F00<0nP0a07<0;@1VIVH01@3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L0
0`1M07<00`3:0?T0A`1c04L0L`0209T0n@0306IVIP2I0?T0V@3i00<06@1c00<0=P3i0080L`0207<0
0P0207<3000DL`04000/n@00:g<002]c000[L`8005gi0`00@W<0101VIVH005Uc001IL`00FG<20030
n@80071c0P00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00Lc800`00
n6`007<K06IVIP02001c6`04003h>`00L`@007<4001c10800?P90`0BL`0202Oh00<0:G<00P1Hn004
03mc000308Wh001GL`00Eg<00080Eg<000<0^_L006IVIP2jm`00102jm`0507=R00030?OB001cB`00
Ld/000<0Ld/000D0mj4007<d001c=000Lc@00000000=0>AW01X0mg0000<0^_L007^1003KiP00103K
iP05085^0080mm801021E0020?NQ00D0PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP00P3g
dP0408eL00<0mj401@2=@00T0?M`0080T9P00P3[m`0409R200<0mm801@2HH`030?NQ00H0V4D00P3g
L00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0303gL0060:8902@0mPh01@2Z
C@020?M`00L0ZR`00`3g?`070:X:02<0mPh00P2aD00=0?M`00L0/@X08`3f3P00102hD`00mg000?M`
003gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P0?H>0080mg002032<P040?Lo00P0`P/0
803f3P0<0?M`00T0a``07`3f3P0n0?ooo`00B@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0
nP0a07<0;@1VIVH01@3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<01@3:0?T0A`1c
04L0L`2I0?T0IVIV00<0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci000[
L`00:g<002]c0P00GOT20012L`0306IVIP00SoT005Uc008005Uc0P00`?T2001`L`800?7h0`00Lf00
0`00n<l007=9001cB@02001cB@03003hW@00Lc8007<b008007<b00@00?Q/06IVIP00La/007<K0P00
n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn00403mc000308Wh001GL`00Eg<00080Eg<000<0
IVIV0;[g002jm`00102jm`0507=R00030?OB001cB`00Ld/00080Ld/00P3gX@0307<d00030000003T
I`00i6L00140i6L0503gL0000`2jm`00Nh400=_V00040=_V00D0PFh00P3gdP04085D0080mj401@21
>`0U0?M`00@0QXd000<0joL008eh002=N000102=N0000`3gdP00SE`008eL000308eL00<0mj401@2=
@00T0?M`0080T9P000<0joL009R2002HPP000`2HPP030?OB00D0V6<00`3gX@0609Q50080mg001P2H
9`0S0?Lo00030?OB002RJ@00XVT000@0XVT00P3gX@060:9900`0mg001P2R2@0T0?H>00D0ZTd00P3g
L0070:X/00<0mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<00?M`003gL000mg00
1`2h;`040?Lo00L0^0/08P3f3P0>0?M`00P0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0
303gL0090<L<01l0mPh0?P3oool004T0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1V
IVH0L`0]00D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00D0bP3i04L0L`1707<0
V@3i06IVIP0309T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<002]c
000[L`8005gi00@0049c06IVIP00SoT008oi0`00FG<01000`?T0071c001`L`00L7<2003an0<007=P
00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c<P04003hK01VIVH007<K001c6`80
0?Pk0`00L`@2003h2@<04W<00P0Wn00302Uc0080F?P0100oL`000`29n000Eg<005Mc000205Mc0003
06IVIP2jm`00^_L000@0^_L01@1cHP000`3gdP00Ld/007=;000207=;0080i9D00P1c=0000`3TI`00
00000>AW000I0>AW00d0mg0000<0^_L00=_V003KiP00103KiP05085^0080mm801021E0020?NQ00D0
PC/09@3gL00408J=00030>_g002=N000SGP000@0SGP000<0mm8008eL002=G0000`2=G0030?NQ00D0
SD00903gL002092H00030>_g002HPP00V88000<0V8800`3gdP0509QS00<0mj401P2HA@020?M`00H0
V2L08`3g?`000`3gdP00XVT00:9Y00040:9Y0080mj401P2RB@0<0?M`00H0XPT01P3T3@0N0?H>00D0
ZTd00P3gL0070:X/00<0mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<00?M`003g
L000mg001`2h;`040?Lo00L0^0/08P3f3P0>0?M`00P0_@/0803f3P030?M`00L0`S80103g?`080<8;
0200mPh0303gL0090<L<0200mPh0?@3oool004T0oooo00<0IVIV0?ooo`3oool01`3oool207<05P03
0?X0<@1VIVH0L`0]00@0nP1S0`1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00@0bP3i04L0
L`1707<0IVIV102I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01000;?T002]c000[
L`00:g<2001Mn@040012L`1VIVH008oi002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001c
H003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00Lc80101VIVH007<K001c6`00La/2
003h>`<007<40P00n0T3019c00809oP00`0YL`0205Sh00<0?g<00P29n00305Mc000306IVIP2jm`00
^_L000D0^_L01@1cHP00103gdP00Ld/007=;001cB`030>BE000407<d003TI`00i6L000000200i6L0
1`3gL0070=_V00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00@0QXd000<0joL008eh002=N000
102=N0000`3gdP00SE`008eL000308eL00<0mj401@2=@00T0?M`0080T9P000<0joL009R2002HPP00
0`2HPP030?OB00D0V6<00`3gX@0609Q50080mg001P2H9`0S0?Lo00030?OB002RJ@00XVT000@0XVT0
0P3gX@060:9900`0mg001@2R2@0<0>@=01T0mPh01@2ZC@020?M`00L0ZR`00`3g?`070:X:02<0mPh0
0`2aD00<0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>00h0
mg00202m2`0P0?H>00<0mg001`32<P040?Lo00P0`P/0803f3P0<0?M`00T0a``0803f3P0m0?ooo`00
B@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0IVIV07<0;@1c02d0103j06<307<0F`050?T0
a@1c0780L`1b07<0LP3i0?L00`1M07<304L0L`0306IVIP2I0?T0V@3i0080V@3i0`0I07<01@0f0?T0
0P1c0080L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT0101VIVH0049c002?n@00
SoT3001IL`040030n@00L7<0071c001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@03003h
W@00Lc8007<b008007<b00@0IVIV001c6`00La/007<K0P00n3/3001c10800?P90`0BL`0202Oh00<0
:G<00P1Hn00303mc0080ROP00`1GL`000`1VIVH0^_L00;[g00050;[g00D0Lf8000@0mm8007=;001c
B`00Ld/00`3TU@00101c=000i6L00>AW0000000V0>AW00L0^_L000<0fnH0085^0021KP000`21KP02
0?OB00@0PE@00P3gX@05084k02D0mg000`26S@020>_g00H0SGP000<0mm8008eL002=G0000`2=G003
0?NQ00D0SD00903gL002092H00030>_g002HPP00V88000<0V8800`3gdP0509QS00<0mj401P2HA@02
0?M`00H0V2L08`3g?`000`3gdP00XVT00:9Y00040:9Y0080mj401P2RB@0<0?M`00@0XPT04P3T3@0D
0?H>00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0S0?H>00<0/E00303gL0070;4:02<0mPh000@0^5<0
0?M`003gL000mg001`2h;`040?Lo00L0^0/08P3f3P0>0?M`00P0_@/0803f3P030?M`00L0`S80103g
?`080<8;0240mPh0303gL0080<L<0200mPh0?@3oool004T0oooo00<0IVIV0?ooo`3oool01`3oool2
07<05P0306IVIP1c02d0L`0]00@0nP1S0`1c05/00`3i0<D0L`1b07<0LP020?T0m`<0G@1c0P1707<0
0`1VIVH0V@3i09T0n@0309T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00
:g<002]c000[L`8005gi00@0IVIV0012L`00SoT008oi0`00FG<01000`?T0071c001`L`00L7<2003a
n0<007=P00<00?S?001cB@00LdT00P00LdT01P00n9d007<b001c<P00Lc80IVIV003hK0<007<K00<0
0?Pk001c1000L`@00P00L`@2003h2@<04W<000<09oP002Uc000YL`000P0YL`0205Sh00<0?g<00P29
n00205Mc000306IVIP1GL`00^_L000H0^_L01@1cHP000`3gdP00Ld/007=;00040>BE00<0i6L01@00
000R0>AW00P0^_L01@21KP020?OB00@0PE@00P3gX@05084k02D0mg000`26S@020>_g00H0SGP000<0
mm8008eL002=G0000`2=G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2H
H`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0303g
L0030:8901P0i0d03`3f3P050:Y=0080mg001`2Z;0030?Lo00L0ZPX08`3f3P030;5@00`0mg001`2a
2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0280mPh03P3gL0080;d;0200mPh0
0`3gL0070<8b00@0mcl02@322`0P0?H>00`0mg002037300P0?H>03d0oooo00190?ooo`0306IVIP3o
ool0oooo00L0oooo00<0L`0F06IVIP1c02d00P1c02d40?X0H`<0L`1K0`1c07820?T0m`80G@1c00@0
bP3i04L0L`1707<0IVIV1@2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01P00;?T0
02]c000[L`00:g<005gi06IVIP80049c0P00SoT3001IL`040030n@00L7<0071c001`L`800?7h0`00
Lf000`00n<l007=9001cB@02001cB@06003hW@00Lc8007<b001c<P1VIVH00?Q/0`00La/00`00n3/0
07<4001c1002001c10800?P90`0BL`000`0Wn000:G<002Uc000202Uc0080F?P00`0oL`0208Wh0004
05Mc001VIVH0Eg<005Mc00L0^_L0101cHP020?OB000307=;003TU@00i9D00080i9D0103TI`000`00
0000i6L00>AW000S0>AW00030661002jm`00^_L000H0^_L01@21KP020?OB00@0PE@00P3gX@05084k
02D0mg000`26S@020>_g00H0SGP000<0mm8008eL002=G0000`2=G0030?NQ00D0SD00903gL0000`2@
V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0V4D00P3gL00609PW02<0mcl000<0mm800:9Y
002RJ@00102RJ@020?NQ00H0XTT0303gL0030:8901d0i0d02P3f3P050:Y=0080mg001`2Z;0030?Lo
00L0ZPX08`3f3P030;5@00`0mg001`2a2P0S0?H>0080^5<00P3gL0070;P_00@0mcl0202h2`0Q0?H>
00h0mg00202m2`0P0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0m0?oo
o`00B@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0L`0]0080L`0]103j06<307<0F`<0
L`1b0P3i0?L205d0L`040<X0n@1707<0IVIV04L0L`D0V@3i0`0I07<40080L`0500@0n@0057<001Ac
000DL`00;?T00`00:g<01000GOT0IVIV0012L`00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c
0P00lOP3001cH004003hc`00LdT007=9001cB@800?RM0P00Lc800`1VIVH00?Q/003hK003001c6`03
003h>`00L`@007<4008007<40P00n0T3019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc0080
ROP000<0Eg<006IVIP1GL`00202jm`0407=R0080mm8000<0Ld/00>BE003TU@001P3TU@000`000000
i9D00>BE000S0>AW00030661002jm`00^_L000H0^_L01@21KP020?OB00@0PE@00P3gX@05084k02D0
mg000`26S@020>_g00H0SGP000<0mm8008eL002=G0000`2=G0030?NQ00D0SD00903gL0000`2@V000
joL00>_g000509R200<0mm801@2HH`030?NQ00H0V4D00P3gL00509PW02@0mcl000<0mm800:9Y002R
J@00102RJ@020?NQ00H0XTT0303gL0020:8902<0i0d01@3f3P050:Y=0080mg001`2Z;0030?Lo00L0
ZPX08`3f3P030;5@00`0mg001`2a2P0S0?H>0080^5<00P3gL0070;P_00@0mcl0202h2`0Q0?H>00h0
mg00202m2`0P0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0m0?ooo`00
B@3oool00`1VIVH0oooo0?ooo`070?ooo`0306IVIP3j0340L`0]0080L`0]103j06<307<0F`<0L`1b
0P3i0?L205d0L`040<X0n@1707<0IVIV04L0L`D0V@3i0`0I07<40080L`0500@0n@0057<001Ac000D
L`00;?T00`00:g<0101VIVH0049c0012L`00@W<2002?n@8005Uc0P00`?T3001`L`800?7h0P00Lf02
003hc`<007=90P00n9d2001c<P0306IVIP00n6`00?Q/00<007<K00<00?Pk001c1000L`@00P00L`@0
0`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc0080ROP000<0IVIV
05Mc001GL`001`2]i@000`2jm`00Lf8007=R000207=R0080mm802@3TU@000`000000i9D00>BE0006
0>BE01`0i6L00P1QP@080;[g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`06
08eh00030?OB002=G000SE`000<0SE`00`3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP03
0?OB00D0V6<00`3gX@0609Q50080mg001@2H9`060>@j01h0mcl000<0mm800:9Y002RJ@00102RJ@02
0?NQ00H0XTT0303gL0000`2R2@00i0d00>@=000W0>@=00D0ZTd00P3gL0070:X/00<0mcl01`2Z2P0S
0?H>00<0/E00303gL0080;4:0280mPh00P2hD`020?M`00P0^2l00`3g?`080;P;0240mPh03P3gL008
0;d;0240mPh00P3gL0070<8b00D0mcl020322`0P0?H>00`0mg002037300P0?H>03d0oooo00190?oo
o`0306IVIP3oool0oooo00L0oooo00<0IVIV0?X0<@1c02d00P1c02d40?X0H`<0L`1K0`1c07820?T0
m`80G@1c00@0bP3i06IVIP1707<0A`1c1@2I0?T301T0L`@00P1c00D0103i000DL`0057<001Ac000/
n@03000[L`0506IVIP00@W<0049c0012L`00SoT00`00FG<20030n@<0071c0P00lOP2001cH0800?S?
0`00LdT2003hW@03001c<P1VIVH007<b00800?Q/0`00La/00`00n3/007<4001c1002001c1003003h
2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`0205Sh00<0?g<00P29n0000`1VIVH0Eg<0
0:gU00080:gU00@0Lf8000<0mm800>BE003TU@00203TU@000`000000i9D00>BE000<0>BE01D0i6L0
0`1QP@080;[g00D0PFh00P3gdP04085D0080mj401@21>`0U0?M`00<0QXd00P3[m`0608eh00030?OB
002=G000SE`000<0SE`00`3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0V6<0
0`3gX@0609Q50080mg00102H9`0<0>@j01T0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0
303gL00Y0>@=00H0ZTd00P3gL0070:X/00<0mcl01`2Z2P0S0?H>00<0/E00303gL0080;4:0280mPh0
0P2hD`020?M`00P0^2l00`3g?`080;P;0240mPh03P3gL0080;d;0240mPh00P3gL0080<8b00@0mcl0
20322`0P0?H>00`0mg002037300P0?H>03d0oooo00190?ooo`0306IVIP3oool0oooo00H0oooo00<0
IVIV07<05P3j03400`1c02d40?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`030<X0
n@1VIVH0A`1c00H0V@3i0`0I07<40080L`0500@0n@0057<001Ac000DL`00;?T00P00:g<00`1VIVH0
05gi0012L`020012L`04002?n@00FG<005Uc001IL`800<3i0`00L7<01000lOP007=P001cH000Lf02
003hc`<007=90P00n9d00`1VIVH007<b001c<P02003hK0<007<K00<00?Pk001c1000L`@00P00L`@0
0`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`00
1029n000IVIV05Mc001GL`090:gU00@0Lf801`3gdP040>BE00030000003TU@00i9D001<0i9D03P3T
I`03066100P0^_L01@21KP000`3gdP00PE@0085D0003085D0080mj401@21>`0U0?M`00<0QXd00P3[
m`0608eh00030?OB002=G000SE`000<0SE`00`3gX@0508e002@0mg0000<0T9P00>_g003[m`001@2H
PP030?OB00D0V6<00`3gX@0609Q50080mg000`2H9`0B0>@j01@0mcl000<0mm800:9Y002RJ@00102R
J@020?NQ00H0XTT04P3gL00R0>@=00030?NQ002ZC@00ZTd000@0ZTd00P3gL0070:X/00<0mcl01`2Z
2P0S0?H>00<0/E00303gL0080;4:0280mPh00P2hD`020?M`00P0^2l00`3g?`080;P;0240mPh000<0
_EH00?M`003gL0002`3gL0080;d;0240mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002@37
300O0?H>03d0oooo00180?ooo`0306IVIP3oool0oooo00L0oooo00<0IVIV07<05P3j03400P1c02d5
0?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`0306IVIP1707<0A`1c00H0V@3i0`0I
07<40080L`0500@0n@0057<001Ac000DL`00;?T00P00:g<00`1VIVH005gi0012L`020012L`04002?
n@00FG<005Uc001IL`800<3i0`00L7<01000lOP007=P001cH000Lf02003hc`<007=90P00n9d00`1V
IVH007<b001c<P02003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c
000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`000P0oL`000`29n000IVIV05Mc000:0:gU
00@0Lf802`3gdP000`000000i9D00>BE000I0>BE00L0i6L0101QP@080;[g00D0PFh000<0mm80085D
0021E0000`21E0020?NQ00@0PC/09P3gL00308J=0080joL01@2=N0020?OB00D0SE`00`3gX@0508e0
02@0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0V6<00`3gX@0609Q50080mg000P2H9`0H0>@j
00l0mcl000<0mm800:9Y002RJ@00102RJ@020?NQ00H0XTT0603gL00K0>@=0080mj401P2ZC@020?M`
00L0ZR`00`3g?`070:X:02<0mPh00`2aD00<0?M`00P0/@X08P3f3P020;QC00<0mg001`2h;`030?Lo
00P0^0/08@3f3P000`2mEP00mg000?M`000;0?M`00T0_@/0803f3P020?M`00P0`S80103g?`080<8;
0200mPh0303gL0090<L<01l0mPh0?@3oool004P0oooo00<0IVIV0?ooo`3oool01`3oool00`1VIVH0
L`0F0?X0<@0207<0;@D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0IVIV04L0
L`1707<01@2I0?T301T0L`0303H0n@0207<00P1c00800P1c100057<01@00;?T002]c06IVIP00:g<0
05gi00<0049c00@008oi001IL`00FG<005Uc0P00`?T3001`L`04003an000Lf0007=P001cH0800?S?
0`00LdT00`00n9d0IVIV001c<P02001c<P03003hK000La/007<K008007<K00<00?Pk001c1000L`@0
0P00L`@00`00n0T04W<0019c0002019c000302Oh000YL`00:G<00080:G<000<0F?P003mc000oL`00
0P0oL`000`1VIVH0ROP005Mc000:0:gU00@0Lf802`3gdP000`000000mm800?OB00040?OB01L0i9D0
0`17P@000`29n000HH4006610003066100P0^_L01@21KP000`3gdP00PE@0085D0003085D0080mj40
1021>`060>=W0200mg000`26S@020>_g00D0SGP00P3gdP0508eL00<0mj401@2=@00T0?M`0003092H
003[m`00joL000D0V8800`3gdP0509QS00<0mj401P2HA@020?M`0080V2L07@3T>P0:0?Lo00030?OB
002RJ@00XVT000@0XVT00P3gX@060:9901h0mg00503T3@030?NQ00H0ZTd00P3gL0070:X/00<0mcl0
1`2Z2P0S0?H>00<0/E00303gL0080;4:0280mPh00P2hD`030?M`00L0^2l00`3g?`080;P;0240mPh0
00<0_EH00?M`003gL0002`3gL0090;d;0200mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg00
2@37300O0?H>03d0oooo00180?ooo`0306IVIP3oool0oooo00H0oooo00@0IVIV07<05P1c01H0nP0a
0P1c02d50?X0H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0205d0L`0406IVIP3:0?T0A`1c04L0
L`D0V@3i0`0I07<00`0f0?T00P1c0080L`020080L`<001Ac00H002ci000[L`00:g<0IVIV000[L`00
GOT30012L`04002?n@00FG<005Uc001IL`800<3i0`00L7<01000lOP007=P001cH000Lf02003hc`<0
07=900<00?RM06IVIP00Lc800P00Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@007<4001c
10800?P9100BL`000`0Wn000:G<002Uc000202Uc000505Sh000oL`00?g<003mc001VIVH00P29n00;
0:gU00@0Lf802P3gdP000`000000mm800?OB000:0?OB0180i9D00`17P@000`29n000HH4006610003
066100P0^_L01@21KP000`3gdP00PE@0085D0003085D0080mj400`21>`0<0>=W01/0mg000`26S@02
0>_g00D0SGP00P3gdP0508eL00<0mj401@2=@00T0?M`0003092H003[m`00joL000D0V8800`3gdP05
09QS00<0mj401P2HA@020?M`000309PW003T>P00i3X00240i3X01@3g?`000`3gdP00XVT00:9Y0004
0:9Y0080mj401P2RB@0T0?M`00d0i0d000@0ZVl00?NQ003gX@00mj401P2ZC@020?M`00L0ZR`00`3g
?`070:X:02<0mPh00`2aD00=0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`040?Lo00L0^0/08@3f
3P000`2mEP00mg000?M`000;0?M`00T0_@/0803f3P020?M`00P0`S80103g?`080<8;0200mPh0303g
L0090<L<0200mPh0?03oool004P0oooo00<0IVIV0?ooo`3oool01P3oool0101VIVH0L`0F07<05P3j
034207<0;@D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g0080G@1c00@0IVIV0<X0n@1707<0
A`1c1@2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01000;?T002]c06IVIP00:g<2
001Mn@<0049c00@008oi001IL`00FG<005Uc0P00`?T2001`L`800?7h0`00Lf000`00n<l007=9001c
B@02001cB@0306IVIP00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/01000n3/007<4001c
1000L`@2003h2@@04W<000@09oP002Uc000YL`00:G<00P1Hn00303mc000306IVIP29n000ROP000X0
[ND01@1cHP0:0?OB00030000003gdP00mm800100mm802`3TU@0404N1000308Wh001QP@00HH4000<0
HH40202jm`04085^0080mm801@21E0020?NQ00<0PC/04@3SI`0F0?M`00<0QXd00P3[m`0508eh0080
mm801@2=G0030?NQ00D0SD00903gL0000`2@V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0
V4D00P3gL00Y0>@j00030?OB002RJ@00XVT000@0XVT00P3gX@060:9902@0mg001@2ZT@000`3gdP00
i0d00>@=00040>@=0080ZVl00`3gX@060:Y=0080mg001`2Z;0030?Lo00L0ZPX08`3f3P030;5@00d0
mg001`2a2P0R0?H>0080^5<00`3gL0070;P_00@0mcl01`2h2`0Q0?H>00030;eF003gL000mg0000/0
mg002@2m2`0P0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<0?M`00T0a``0803f3P0l0?ooo`00
B03oool00`1VIVH0oooo0?ooo`050?ooo`0506IVIP3oool0L`0F07<05P3j03400P1c02d50?X0H`80
L`1K00T0n@3507<0LP1c0780L`1b0?T0m`1M07<0IVIV05d0L`3:0?T00P1707<509T0n@<06@1c00D0
=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<0IVIV000[L`8005gi0P00@W<2002?n@<0
05Uc0P00`?T2001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@0306IVIP00Lc8007<b0080
07<b00<00?Q/001c6`00La/00P00La/01000n3/007<4001c1000L`@2003h2@@04W<000@09oP002Uc
000YL`00:G<00P1Hn00203mc000306IVIP0oL`00ROP000/0[ND01@1cHP0:0?OB00030000003gdP00
mm8001D0mm801P3TU@0404N1000308Wh001QP@00HH4000<0HH40202jm`04085^0080mm801@21E002
0?NQ0080PC/0603SI`0@0?M`00<0QXd00P3[m`0508eh0080mm801@2=G0030?NQ00D0SD00903gL000
0`2@V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0V4D000<0mg000>@j003T>P00:03T>P00
0`3gdP00XVT00:9Y00040:9Y0080mj401P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0mj401P2ZC@02
0?M`00P0ZR`00P3g?`070:X:02<0mPh00`2aD00=0?M`00L0/@X08P3f3P020;QC00<0mg001`2h;`04
0?Lo00L0^0/08@3f3P000`2mEP00mg000?M`000<0?M`00P0_@/0803f3P020?M`00P0`S80103g?`08
0<8;0200mPh0303gL0090<L<0200mPh0?03oool004P0oooo00<0IVIV0?ooo`3oool01@3oool01@1V
IVH0oooo07<05P1c01H0nP0a0080L`0]103j06<307<0F`080?T0a@1c0780L`1b07<0LP3i0?L0G@1c
06IVIP1M07<304L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci06IV
IP00:g<002]c0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP3001cH006003hc`00LdT0
07=9001cB@1VIVH00?RM1000Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@007<4001c1080
0?P90`0BL`0202Oh00<0:G<00P1Hn00203mc000306IVIP0oL`00ROP000H0ROP01@2]i@0507=R00X0
mm8000<000000?OB003gdP00603gdP0205Sh00D0Ah4000<0ROP00661001QP@000`1QP@080;[g00@0
PFh00P3gdP05085D0080mj4000<0PC/00>=W003SI`00703SI`0;0?M`00<0QXd00P3[m`0508eh0080
mm801@2=G0030?NQ00@0SD009@3gL0000`2@V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0
V4D01`3gL00S0>@j0080mm801P2RJ@020?NQ00H0XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0
ZTd00`3gL0070:X/0080mcl01`2Z2P0S0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`030?M`00L0
^2l0103g?`070;P;0240mPh000<0_EH00?M`003gL000303gL0080;d;0200mPh00`3gL0070<8b00@0
mcl020322`0Q0?H>00`0mg002037300P0?H>03`0oooo00180?ooo`0306IVIP3oool0oooo00@0oooo
00<0IVIV0?ooo`3oool00P1c01H307<0;@@0nP1S0`1c05/01P3i0<D0L`1b07<0LP1c0780n@3g06IV
IP80G@1c0`1707<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@1VIVH0
02]c000[L`8005gi0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH006003h
c`00LdT007=9001cB@1VIVH00?RM1000Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3
019c00809oP00`0YL`0205Sh000403mc001VIVH0?g<003mc00`0ROP01@1cHP0:0?OB00030000003g
dP00mm8001P0mm800P1Hn00504N1000308Wh001QP@00HH400080HH402@2jm`04085^0080mm801@21
E0020?NQ0003084k003SI`00hfL00240hfL01P3gL00308J=0080joL01@2=N0020?OB00D0SE`00`3g
X@0408e000H0i6P07`3gL0000`2@V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0V4D03@3g
L00L0>@j00<0mm801P2RJ@020?NQ00H0XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3g
L0070:X/0080mcl01`2Z2P0S0?H>00<0/E003@3gL0070;4:0280mPh00P2hD`030?M`00L0^2l0103g
?`070;P;0280mPh03P3gL0080;d;0200mPh00`3gL0070<8b00@0mcl020322`0Q0?H>00`0mg002037
300P0?H>03`0oooo00180?ooo`0306IVIP3oool0oooo00@0oooo00D0IVIV0?ooo`3oool0L`0F0?X0
<@0307<0;@@0nP1S0`1c05/307<0LP80n@3g00<0IVIV05d0L`3:0?T00`1707<509T0n@<06@1c00D0
=P3i0080L`0207<00P1c00@0n@03000DL`0406IVIP00:g<002]c000[L`8005gi0P00@W<2002?n@<0
05Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH006003hc`00LdT007=906IVIP00LdT00?RM1000
Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c00809oP00`0YL`0205Sh000403mc
001VIVH0?g<003mc00`0ROP01@1cHP0:0?OB00030000003gdP00mm8001P0mm800P1Hn00504N10003
08Wh001QP@00HH400080HH402@2jm`04085^0080mm801@21E0020?NQ02T0hfL01026S@020>_g00D0
SGP00P3gdP0508eL00<0mj400`2=@00=0>AX01T0mg0000<0T9P00>_g003[m`001@2HPP030?OB00D0
V6<00`3gX@0609Q501<0mg005@3T>P00102RR@00mm800?OB003gdP060:9Y0080mj401P2RB@0T0?M`
00D0ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`00P3g?`070:X:02<0mPh00`2aD00=0?M`
00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P
0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0l0?ooo`00B03oool00`1V
IVH0oooo0?ooo`030?ooo`0606IVIP3oool0oooo0?ooo`1c01H0nP0a0`1c02d40?X0H`<0L`1K0`1c
07801@3i0?L0IVIV05d0L`1M07<0bP3i00<0A`1c1@2I0?T301T0L`0503H0n@0207<00P1c0080L`04
0?T00`0057<0101VIVH002]c000[L`00:g<2001Mn@80049c0P00SoT3001IL`040030n@00L7<0071c
001`L`800?7h0`00Lf001P00n<l007=9001cB@1VIVH007=9003hW@@007<b00@00?Q/001c6`00La/0
07<K0P00n3/3001c10800?P90`0BL`0202Oh00<0:G<00P1Hn0000`1VIVH0?g<003mc000=08Wh00D0
Lf802P3gdP000`000000mm800?OB000H0?OB0080F?P01@17P@000`29n000HH4006610002066100T0
^_L01021KP020?OB00D0PE@000<0mj400>=W003SI`00:03SI`0408J=0080joL01@2=N0020?OB00D0
SE`00`3gX@0308e001<0i6P04`3gL0000`2@V000joL00>_g000509R200<0mm801@2HH`030?NQ00H0
V4D06@3gL00>0>@j0080XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0
mj401P2ZC@030?M`00L0ZR`00P3g?`070:X:02<0mPh00`2aD00=0?M`00L0/@X08`3f3P00102hD`00
mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P0?H>00<0mg001`32<P040?Lo
00T0`P/0803f3P0<0?M`00P0a``0803f3P0l0?ooo`00B03oool00`1VIVH0oooo0?ooo`030?ooo`06
06IVIP3oool0oooo0?ooo`1c01H0nP0a0`1c02d40?X0H`<0L`1K0`1c07801@3i0?L0IVIV05d0L`1M
07<0bP3i00<0A`1c1@2I0?T301T0L`@00P1c00D0103i000DL`0057<0IVIV000/n@03000[L`8005gi
0P00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH003003hc`00LdT0IVIV0080
07=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03003h>`00L`@007<4008007<40P00n0T3019c
00809oP00`0YL`0205Sh000306IVIP0oL`00?g<000d0ROP01@1cHP0:0?OB00030000003gdP00mm80
01P0mm800P1Hn00404N10080ROP0101QP@090;[g00@0PFh00P3gdP05085D00L0mj408`3SI`0508J=
0080joL01@2=N0020?OB00D0SE`00`3gX@0208e001X0i6P03@3gL0000`2@V000joL00>_g000509R2
00<0mm801@2HH`030?NQ00H0V4D07`3gL0070>@j00<0XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`
00D0ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`00P3g?`070:X:02<0mPh00`2aD00=0?M`
00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P
0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0l0?ooo`00B03oool00`1V
IVH0oooo0?ooo`020?ooo`0306IVIP3oool0oooo0080oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0
H`<0L`1K0`1c07801@1VIVH0n@3g05d0L`1M07<0bP3i00<0A`1c1@2I0?T301T0L`@00P1c00D0103i
000DL`0057<0IVIV000/n@03000[L`04001Mn@00@W<0049c0012L`8008oi0P00FG<20030n@<0071c
0P00lOP3001cH003003hc`1VIVH007=9008007=900@00?RM001c<P00Lc8007<b0P00n6`3001c6`03
003h>`00L`@007<4008007<40P00n0T3019c000302Oh000YL`00:G<00080:G<000<0F?P006IVIP0o
L`000P0oL`0=08Wh00D0Lf802P3gdP000`000000mm800?OB000H0?OB0080F?P01017P@0208Wh00@0
HH402@2jm`04085^0080mm801@21E00<0?NQ01h0hfL01@26S@020>_g00D0SGP00P3gdP0508eL00<0
mj4000<0SD000>AX003TJ0007`3TJ0070?M`0003092H003[m`00joL000D0V8800`3gdP0509QS00<0
mj401P2HA@0S0?M`00030>_g002RR@00XXT000<0XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`00D0
ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`00P3g?`070:X:02<0mPh00`2aD00=0?M`00L0
/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P0?H>
00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0l0?ooo`00B03oool00`1VIVH0
oooo0?ooo`020?ooo`0406IVIP3oool0oooo0?ooo`80L`0F00@0nP0a07<0;@1c02d0L`0]103j06<2
07<0F`060?T0a@1c0780L`1b07<0LP1VIVH0n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<0
6@1c100207<01@040?T001Ac06IVIP0057<002ci00<002]c00@005gi0012L`00@W<0049c0P00SoT2
001IL`800<3i0`00L7<2003an08007=P0P00n<l00`1VIVH007=9001cB@02003hW@<007<b0P00n6`3
001c6`03003h>`00L`@007<4008007<40P00n0T3019c000302Oh000YL`00:G<00080:G<000<0IVIV
05Sh000oL`000P0oL`0=08Wh00D0Lf802@3gdP000`1VIVH000000?OB000I0?OB0080F?P01017P@02
08Wh00@0HH40202jm`05085^0080mm801@21E00A0?NQ01P0hfL000<0^_L008J=0026S@000`26S@02
0>_g00D0SGP00P3gdP0508eL00<0mj4000<0SD000>AX003TJ0009@3TJ002092H0080joL01@2HPP03
0?OB00D0V6<00`3gX@0609Q502<0mg0000<0joL00::9002RR@000`2RR@030?OB00H0XVT00P3gX@06
0:9902@0mg001@2ZT@030?OB00H0ZVl00`3gX@060:Y=00<0mg001`2Z;0020?Lo00L0ZPX08`3f3P03
0;5@00d0mg001`2a2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0280mPh03P3g
L0080;d;0240mPh00P3gL0070<8b00D0mcl020322`0P0?H>00`0mg002@37300O0?H>03`0oooo0017
0?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?ooo`3oool00P3oool207<05P030?X0<@1c02d0
L`0]00D0nP1S0P1c05/0103i0<D0L`1b07<0LP1VIVH20?T0m`80G@1c00<0bP3i04L0L`1707<01P2I
0?T301T0L`@00P1c00D0103i000DL`1VIVH001Ac000/n@03000[L`05001Mn@00@W<0049c0012L`00
SoT00`00FG<20030n@<0071c0P00lOP2001cH003003hc`1VIVH007=9008007=90P00n9d3001c<P80
0?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<000<09oP002Uc000Y
L`000P0YL`000`1VIVH0F?P003mc000203mc00d0ROP0101cHP0:0?OB000306IVIP000000mm8001T0
mm800P1Hn00404N10080ROP0101QP@080;[g00D0PFh00P3gdP05085D01L0mj404@3SI`020;[g00D0
QXd000<0joL008eh002=N000102=N0020?OB00D0SE`00`3gX@0X0>AX0080T9P00P3[m`0509R200<0
mm801@2HH`030?NQ00D0V4D0903gL0000`3[m`00XXT00::900030::900<0mm801P2RJ@020?NQ00H0
XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/0080mcl01`2Z2P050>@=01h0
mPh00`2aD00=0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL0070;P_00@0mcl01`2h2`0R0?H>
00h0mg00202m2`0Q0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<0?M`00T0a``0803f3P0k0?oo
o`00A`3oool00`1VIVH0oooo0?ooo`020?ooo`0306IVIP3oool0oooo0080oooo0P1c01H00`3j0340
L`0]07<0;@050?X0H`80L`1K00D0n@3507<0LP1c0780IVIV0?T0m`0305d0L`030<X0n@1707<0A`1c
00D0V@3i100I07<40080L`0500@0n@1VIVH001Ac000DL`00;?T00`00:g<01@00GOT0049c0012L`00
@W<008oi00<005Uc0P00`?T3001`L`800?7h0P00Lf000`00n<l0IVIV001cB@02001cB@800?RM0`00
Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c000502Oh000Y
L`00:G<002Uc001VIVH00P1Hn00303mc00d0ROP0101cHP090?OB000306IVIP3gdP00000001X0mm80
0P1Hn00404N10080ROP0101QP@080;[g00D0PFh00P3gdP05085D01`0mj40303SI`020;[g00D0QXd0
00<0joL008eh002=N000102=N0020?OB00D0SE`00P3gX@0X0>AX00<0T9P00P3[m`0509R200<0mm80
1@2HH`030?NQ00D0V4D01P3TJ00N0?M`00030>_g002RR@00XXT000<0XXT00`3gdP060:9Y0080mj40
1P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`00P3g?`060:X:00/0i0d0
6@3f3P030;5@00d0mg001`2a2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`070;P;0280
mPh03P3gL0080;d;0240mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002@37300P0?H>03/0
oooo00170?ooo`0506IVIP3oool0oooo0?ooo`1VIVH01@3oool207<05P030?X0<@1c02d0L`0]00D0
nP1S0P1c05/01@3i0<D0L`1b06IVIP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T301T0
L`0303H0n@0207<00P1c00800P1c00D001Ac06IVIP0057<001Ac000/n@03000[L`05001Mn@00@W<0
049c0012L`00SoT00`00FG<20030n@<0071c00H00?7h001cH000Lf0007=P06IVIP00n<l3001cB@80
0?RM0`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c0005
02Oh000YL`00:G<002Uc001VIVH00P1Hn00303mc00d0ROP0101cHP090?OB000306IVIP3gdP000000
01X0mm800P1Hn00404N10080ROP0101QP@080;[g00D0PFh00P3gdP04085D0280mj401P3SI`000`1Z
S@00^_L00;[g000508J=00030>_g002=N000SGP000@0SGP00P3gdP0508eL00P0mj408P3TJ003092H
0080joL01@2HPP030?OB00D0V6<00`3gX@0409Q500d0i6P0603gL0000`3[m`00XXT00::900030::9
00<0mm801P2RJ@020?NQ00H0XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/
0080mcl01@2Z2P0A0>@=01@0mPh00`2aD00=0?M`00L0/@X08`3f3P00102hD`00mg000?M`003gL007
0;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0Q0?H>0080mg002032<P040?Lo00P0`P/0803f3P0<
0?M`00T0a``0803f3P0k0?ooo`00A`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00D0oooo0P1c01H0
0`3j0340L`0]07<0;@050?X0H`80L`1K00D0n@3507<0LP1VIVH0L`1b0?T0m`0305d0L`030<X0n@17
07<0A`1c00D0V@3i0`0I07<00`0f0?T00P1c0080L`020080L`0406IVIP0057<001Ac000DL`@002]c
00D005gi0012L`00@W<0049c002?n@03001IL`800<3i0`00L7<01P00lOP007=P001cH000Lf00IVIV
003hc`<007=90P00n9d3001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`00
4W<000804W<000D09oP002Uc000YL`00IVIV02Uc000205Sh00<0?g<03@29n00407=R00P0mm8000@0
IVIV0?OB003gdP0000006@3gdP000`0^P@00F?P005Sh000404N1000308Wh001QP@00HH4000<0HH40
202jm`05085^0080mm801021E0070>>D01l0mj400`1ZS@020;[g00D0QXd000<0joL008eh002=N000
102=N0020?OB00D0SE`03P3gX@0K0>AX00@0T9P00P3[m`0509R200<0mm801@2HH`030?NQ00<0V4D0
503TJ00B0?M`00030>_g002RR@00XXT000<0XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`00D0ZY40
0`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`00P3g?`040:X:01L0i0d03`3f3P030;5@00d0mg00
1`2a2P0S0?H>00040;QC003gL000mg000?M`00L0^2l0103g?`080;P;0240mPh03P3gL0080;d;0240
mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002@37300P0?H>03/0oooo00170?ooo`0406IV
IP3oool0oooo06IVIPH0oooo0P1c01H00`3j0340L`0]07<0;@050?X0H`80L`1K00D0n@3506IVIP1c
0780L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c00D0V@3i0`0I07<01P0f0?T00P1c0080L`0207<0
103i06IVIP8001Ac00<002ci000[L`00:g<00P00:g<01@00GOT0049c0012L`00@W<008oi00<005Uc
0P00`?T3001`L`04003an000Lf0007=P06IVIP800?S?0`00LdT00`00n9d007<b001c<P02001c<P03
003hK000La/007<K008007<K00<00?Pk001c1000L`@00P00L`@00`00n0T04W<0019c0002019c0006
02Oh000YL`00:G<006IVIP0YL`00F?P0100oL`0=08Wh00@0Lf801`3gdP001@1VIVH0mm800?OB003g
dP00000001T0mm8000<0;X4005Sh001Hn0001017P@000`29n000HH4006610003066100P0^_L01@21
KP020?OB00<0PE@03P3SU00I0?NQ00<0JXd00P2jm`0508J=00030>_g002=N000SGP000@0SGP00P3g
dP0508eL01@0mj40503TJ005092H0080joL01@2HPP030?OB00D0V6<00`3gX@0209Q501/0i6P0303g
L0000`3[m`00XXT00::900030::900<0mm801P2RJ@020?NQ00H0XTT0903gL0050:ZA00<0mm801P2Z
K`030?NQ00H0ZTd00`3gL0070:X/0080mcl00`2Z2P0M0>@=00X0mPh00`2aD00=0?M`00L0/@X08`3f
3P00102hD`00mg000?M`003gL0070;P_00@0mcl0202h2`0Q0?H>00h0mg002@2m2`0P0?H>0080mg00
2032<P040?Lo00P0`P/0803f3P0=0?M`00P0a``0803f3P0k0?ooo`00A`3oool0101VIVH0oooo0?oo
o`1VIVH60?ooo`80L`0F00<0nP0a07<0;@1c02d0103j06<307<0F`050?T0a@1VIVH0L`1b07<0LP3i
0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@<06@1c00D0=P3i0080L`0207<00P1c06IVIP03000D
L`04000/n@00:g<002]c000[L`8005gi0P00@W<2002?n@<005Uc0P00`?T2001`L`800?7h0P00Lf00
0`1VIVH00?S?001cB@03001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/0
1000n3/007<4001c1000L`@2003h2@@04W<000<09oP002Uc001VIVH00P0YL`000`1Hn000?g<003mc
000203mc00d0ROP0101cHP070?OB000506IVIP3gdP00mm800?OB000000006@3gdP000`0^P@00F?P0
05Sh000404N1000308Wh001QP@00HH4000<0HH40202jm`05085^0080mm800`21E00D0>>D01<0mj40
0`1ZS@020;[g00D0QXd000<0joL008eh002=N000102=N0020?OB00D0SE`06P3gX@0>0>AX00D0T9P0
0P3[m`0509R200<0mm801@2HH`030?NQ0080V4D08@3TJ0060?M`00030>_g002RR@00XXT000<0XXT0
0`3gdP060:9Y0080mj401P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`0
0P3g?`020:X:02<0i0d01@3f3P030;5@00d0mg001`2a2P0S0?H>0080^5<00P3gL0070;P_00@0mcl0
202h2`0Q0?H>00030;eF003gL000mg0000/0mg002@2m2`0P0?H>0080mg002032<P040?Lo00P0`P/0
8@3f3P0<0?M`00P0a``0803f3P0k0?ooo`00A`3oool00`1VIVH0oooo06IVIP070?ooo`80L`0F0`1c
02d40?X0H`<0L`1K00D0IVIV07<0LP1c0780L`1b0?T0m`0305d0L`<0A`1c1@2I0?T301T0L`0503H0
n@0207<00P1c0080L`1VIVH00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c0P00SoT3001I
L`800<3i0P00L7<2003an004001cH01VIVH007=P003hc`@007=900<00?RM001c<P00Lc800P00Lc80
0`00n6`007<K001c6`02001c6`04003h>`00L`@007<4001c10800?P9100BL`00100Wn000IVIV02Uc
000YL`0205Sh00@0?g<03@29n00407=R00H0mm8000<0IVIV0?OB003gdP000P3gdP000`000000mm80
0?OB000G0?OB000302j1001Hn000F?P000@0Ah4000<0ROP00661001QP@000`1QP@080;[g00D0PFh0
0P3gdP02085D01/0hi@03@3gX@0306Z=0080^_L01@26S@000`3[m`00SGP008eh000408eh0080mm80
1@2=G00P0?NQ00L0i6P01P2@V0020>_g00D0V8800`3gdP0509QS00<0mj4000<0V4D00>AX003TJ000
9P3TJ0000`3[m`00XXT00::900030::900<0mm801P2RJ@020?NQ00H0XTT0903gL0050:ZA00<0mm80
1P2ZK`030?NQ00H0ZTd00`3gL0070:X/0080mcl000<0ZPX00>@=003T3@009`3T3@030;5@00d0mg00
1`2a2P0S0?H>0080^5<00P3gL0080;P_00<0mcl0202h2`0Q0?H>00030;eF003gL000mg0000/0mg00
2@2m2`0P0?H>0080mg002032<P040?Lo00P0`P/08@3f3P0<0?M`00P0a``0803f3P0k0?ooo`00A`3o
ool00`1VIVH0oooo06IVIP070?ooo`0307<05P3j0340L`0]0080L`0]103j06<307<0F`0506IVIP1c
0780L`1b07<0LP3i0?L00`1M07<304L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`1VIVH0103i00<0
01Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP01000
Lf00IVIV001cH000n<l4001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/0
1000n3/007<4001c1000L`@2003h2@@04W<000@09oP006IVIP0YL`00:G<00P1Hn00403mc00d0ROP0
101cHP060?OB000306IVIP3gdP00mm800080mm8000<000000?OB003gdP005`3gdP000`0^P@00F?P0
04N1000404N1000308Wh001QP@00HH4000<0HH40202jm`05085^0080mm8000<0PE@00>>D003SU000
803SU0070?NQ00<0JXd00P2jm`0508J=00030>_g002=N000SGP000@0SGP00P3gdP0508eL02@0mj40
0P1bV0000`2jm`00T9P0092H0004092H0080joL01@2HPP030?OB00D0V6<00`3gX@0Y0>AX00030>_g
002RR@00XXT000<0XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0mj40
1P2ZC@030?M`00L0ZR`00P3g?`0Y0>@=00@0/E003@3gL0070;4:02<0mPh00P2hD`020?M`00P0^2l0
0`3g?`080;P;0240mPh000<0_EH00?M`003gL0002`3gL0090;d;0200mPh00`3gL0070<8b00@0mcl0
20322`0Q0?H>00`0mg002037300P0?H>03/0oooo00170?ooo`80IVIV203oool00`1c01H0nP0a07<0
;@0207<0;@@0nP1S0P1c05/0101VIVH0L`1b07<0LP1c07820?T0m`80G@1c00@0bP3i04L0L`1707<0
A`1c1@2I0?T301T0L`0503H0n@0207<00P1c06IVIP040?T00`0057<01000;?T002]c000[L`00:g<2
001Mn@80049c0P00SoT3001IL`040030n@00L7<0071c001`L`800?7h00@0IVIV001cH000Lf000?S?
1000LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K008007<K00@00?Pk001c1000L`@0
07<40P00n0T4019c000406IVIP0YL`00:G<002Uc0080F?P0100oL`0<08Wh00D0Lf801@3gdP000`1V
IVH0mm800?OB00020?OB00030000003gdP00mm8001P0mm8000<0;X4005Sh0017P@001017P@000`29
n000HH4006610003066100P0^_L01@21KP020?OB0003085D003SU000hi@002H0hi@0101ZS@020;[g
00D0QXd000<0joL008eh002=N000102=N0020?OB00@0SE`09@3gX@0207:H00030;[g002@V000T9P0
00@0T9P00P3[m`0509R200<0mm801@2HH`020?NQ02T0i6P00P3[m`050::900<0mm801P2RJ@020?NQ
00H0XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/00P0mcl08P3T3@050;5@
00d0mg001`2a2P0S0?H>0080^5<00P3gL0080;P_00<0mcl0202h2`0Q0?H>00030;eF003gL000mg00
00/0mg002@2m2`0P0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00P0a``0803f3P0k0?oo
o`00A`3oool206IVIPP0oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0H`80L`1K00@0IVIV07<0LP1c
0780L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<01@0f0?T00P1c06IVIP02
07<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01000`?T0071c
001`L`00L7<2003an00406IVIP00Lf0007=P003hc`@007=900<00?RM001c<P00Lc800P00Lc801000
n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c000302Oh001VIVH0:G<00080:G<00P1Hn004
03mc00`0ROP01@1cHP050?OB000306IVIP3gdP00mm800080mm8000<000000?OB003gdP00603gdP00
0`0^P@00F?P004N1000404N1000308Wh001QP@00HH4000<0HH40202jm`05085^0080mm80:@3SU004
06Z=0080^_L01@26S@000`3[m`00SGP008eh000408eh0080mm80102=G0060>BE01l0mj400P1bV000
0`2jm`00T9P0092H0004092H0080joL01@2HPP030?OB00D0V6<0203gX@0R0>AX000309VR003[m`00
joL000D0XXT00`3gdP060:9Y0080mj401P2RB@0T0?M`00D0ZY400`3gdP060:Y_00<0mj401P2ZC@03
0?M`00L0ZR`03P3g?`0K0>@=00H0/E003@3gL0070;4:02<0mPh00P2hD`020?M`00P0^2l00`3g?`08
0;P;0240mPh000<0_EH00?M`003gL000303gL0080;d;0200mPh00`3gL0070<8b00@0mcl02@322`0P
0?H>00`0mg002037300P0?H>03/0oooo00170?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F0?X0
<@1c02d00P1c02d40?X0H`0307<0F`1VIVH0L`1K00<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c
04L0L`D0V@3i0`0I07<20080L`0306IVIP0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00
GOT20012L`8008oi0`00FG<01P00`?T0071c001`L`00L7<00?7h06IVIP<007=P00<00?S?001cB@00
LdT00P00LdT00`00n9d007<b001c<P02001c<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h
2@<04W<000<0IVIV02Oh000YL`000P0YL`0205Sh00@0?g<03029n00507=R00@0mm8000<0IVIV0?OB
003gdP000`3gdP000`000000mm800?OB000H0?OB000302j1001Hn000Ah4000@0Ah4000<0ROP00661
001QP@000`1QP@080;[g00D0PFh000<0mm800>>D003SU0009`3SU00506Z=0080^_L01@26S@000`3[
m`00SGP008eh000408eh0080mm800`2=G00=0>BE01T0mj400P1bV0000`2jm`00T9P0092H0004092H
0080joL01@2HPP030?OB00D0V6<03P3gX@0K0>AX0080VJ800P3[m`050::900<0mm801P2RJ@020?NQ
00H0XTT0903gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/01@0mcl0503T3@080;5@
00`0mg001`2a2P0S0?H>0080^5<00P3gL0080;P_00<0mcl0202h2`0Q0?H>00030;eF003gL000mg00
00`0mg00202m2`0P0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00T0a``0803f3P0j0?oo
o`00A`3oool00`1VIVH0oooo0?ooo`060?ooo`80L`0F00@0nP0a07<0;@1c02d0L`0]103j06<00`1c
05/0IVIV0?T0a@0307<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c00D00P1c
06IVIP0207<00P1c00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<2002?n@<005Uc
00H00<3i001`L`00L7<0071c06IVIP00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c
<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`<007<40P00n0T3019c000306IVIP0Wn000
:G<00080:G<00P1Hn00403mc00`0ROP01@1cHP030?OB000306IVIP3gdP00mm8000@0mm8000<00000
0?OB003gdP00603gdP000`0^P@00F?P004N1000404N1000308Wh001QP@00HH4000<0HH40202jm`05
085^00L0mm808P3SU0000`29n000JXd006Z=000306Z=0080^_L01@26S@000`3[m`00SGP008eh0004
08eh0080mm800P2=G00D0>BE01<0mj400P1bV0000`2jm`00T9P0092H0004092H0080joL01@2HPP03
0?OB00D0V6<0503gX@0E0>AX0080VJ800P3[m`050::900<0mm801P2RJ@020?NQ00H0XTT01P3TJ00N
0?M`00D0ZY400`3gdP060:Y_00<0mj401P2ZC@030?M`00L0ZR`06P3g?`0=0>@=00030?NQ002aD000
/E0000H0/E00303gL0070;4:02<0mPh00P2hD`030?M`00L0^2l0103g?`070;P;0240mPh000<0_EH0
0?M`003gL000303gL0080;d;0200mPh00`3gL0070<8b00@0mcl02@322`0P0?H>00`0mg002@37300P
0?H>03X0oooo00160?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H00`3j0340L`0]07<0;@050?X0
H`0306IVIP1c05/0n@3500<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<0
1@1VIVH00P1c0080L`0207<0103i00<001Ac00D002ci000[L`00:g<002]c001Mn@030012L`8008oi
0P00FG<20030n@<0071c00<0IVIV003an000Lf000P00Lf000`00n<l007=9001cB@02001cB@04003h
W@00Lc8007<b001c<P800?Q/0`00La/00`00n3/007<4001c1002001c10800?P90P0BL`000`1VIVH0
9oP002Oh000302Uc0080F?P0100oL`0<08Wh00D0Lf800`3gdP000`1VIVH0mm800?OB00040?OB0003
0000003gdP00mm8001P0mm800P1Hn00504N1000308Wh001QP@00HH4000<0HH40202jm`05085^00d0
mm806`3SU00208Wh00D0JXd00P2jm`0508J=00030>_g002=N000SGP000@0SGP00P3gdP0208eL01X0
i9D03@3gX@0207:H00030;[g002@V000T9P000@0T9P00P3[m`0509R200<0mm801@2HH`0J0?NQ00h0
i6P00`2IXP020>_g00D0XXT00`3gdP060:9Y0080mj401@2RB@0=0>AX01P0mg001@2ZT@030?OB00H0
ZVl00`3gX@060:Y=00<0mg001`2Z;00P0?Lo00H0i0d00P3gX@080;5@00`0mg001`2a2P0S0?H>0080
^5<00`3gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0P0?H>00<0mg001`32<P050?Lo00P0
`P/0803f3P0<0?M`00T0a``0803f3P0j0?ooo`00AP3oool406IVIPH0oooo0P1c01H00`3j0340L`0]
07<0;@050?X0H`0306IVIP1c05/0n@3500<0L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00H0V@3i
0`0I07<01@1VIVH00P1c0080L`0207<0103i00<001Ac00D002ci000[L`00:g<002]c001Mn@030012
L`8008oi0P00FG<20030n@80071c00<0IVIV003an000lOP00P00Lf02003hc`<007=90P00n9d3001c
<P800?Q/0`00La/00`00n3/007<4001c1002001c10800?P90P0BL`000`1VIVH09oP002Uc000302Uc
0080F?P00`0oL`0=08Wh00D0Lf800P3gdP000`1VIVH0mm800?OB00050?OB00030000003gdP00mm80
01P0mm800P1Hn00504N1000308Wh001QP@00HH4000<0HH40202jm`05085^01<0mm805@3SU00208Wh
00D0JXd00P2jm`0508J=00030>_g002=N000SGP000@0SGP00P3gdP000`2=G000i9D00>BE000O0>BE
00L0mj400P1bV0000`2jm`00T9P0092H0004092H0080joL01@2HPP030?OB00D0V6<0803gX@070>AX
00@0VJ800P3[m`050::900<0mm801P2RJ@020?NQ00@0XTT0503TJ00B0?M`00D0ZY400`3gdP060:Y_
00<0mj401P2ZC@030?M`00L0ZR`08P3g?`040;5d0080mj40202aD00<0?M`00H0/@X01`3T3@0M0?H>
0080^5<00`3gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0Q0?H>0080mg001`32<P050?Lo
00P0`P/0803f3P0<0?M`00T0a``0803f3P0j0?ooo`00AP3oool0101VIVH0oooo0?ooo`3oool606IV
IP80L`0F00<0nP0a07<0;@1c02d0103j06<0101VIVH0L`1K07<0F`3i0<D307<0LP050?T0m`1M07<0
G@1c05d0L`3:0?T00P1707<509T0n@<06@1c00<0IVIV0080L`0207<00P0207<01@040?T001Ac000D
L`0057<002ci00<002]c00@005gi0012L`00@W<0049c0P00SoT2001IL`800<3i0P00L7<00`1VIVH0
0?7h003an002001cH0800?S?0`00LdT2003hW@<007<b0P00n6`3001c6`03003h>`00L`@007<40080
07<40P00n0T0100BL`00IVIV019c000Wn00402Uc0080F?P00`0oL`0=08Wh00D0Lf800P3gdP000`1V
IVH0mm800?OB00050?OB00030000003gdP00mm8001P0mm800P1Hn00504N1000308Wh001QP@00HH40
00<0HH40202jm`04085^01X0mm803P3SU0000`1>S@00ROP008Wh000506Z=0080^_L01026S@020>_g
00H0SGP00P3gdP0X0>BE00<0LYP000<0^_L0092H002@V000102@V0020>_g00D0V8800`3gdP0509QS
02@0mj4000<0^_L009VR002IXP00102IXP020>_g00D0XXT00`3gdP060:9Y0080mj400`2RB@0K0>AX
00`0mg001@2ZT@030?OB00H0ZVl00`3gX@060:Y=00<0mg001`2Z;00S0?Lo00<0/G@00P3gX@080;5@
00`0mg001@2a2P0>0>@=01L0mPh00P2hD`030?M`00L0^2l0103g?`070;P;0280mPh03P3gL0080;d;
0240mPh00P3gL0080<8b00@0mcl020322`0P0?H>00`0mg002@37300P0?H>03X0oooo00160?ooo`03
06IVIP3oool0oooo00L0oooo0P1c01H00`3j0340L`0]07<0;@040?X0H`0406IVIP1c05/0L`1K0?T0
a@<0L`1b00D0n@3g05d0L`1M07<0G@1c0<X0n@0204L0L`D0V@3i0`0I07<00`1VIVH00P1c0080L`02
0080L`@001Ac00D002ci000[L`00:g<002]c001Mn@030012L`04002?n@00FG<005Uc001IL`800<3i
00<0071c06IVIP00L7<00P00lOP2001cH0800?S?0`00LdT2003hW@<007<b0P00n6`3001c6`03003h
>`00L`@007<4008007<40P00n0T0101VIVH04W<0019c000Wn00402Uc0080F?P00`0oL`0=08Wh00D0
Lf8000<0mm8006IVIP3gdP001`3gdP000`000000mm800?OB000H0?OB0080F?P01@17P@000`29n000
HH4006610003066100P0^_L01021KP060>?201X0mm801`3SU00204j=0080ROP01@1ZS@020;[g00@0
QXd00P3Ii00608eh00030?OB003TU@00i9D002L0i9D00`1bV0000`2jm`00T9P0092H0004092H0080
joL01@2HPP030?OB00D0V6<0903gX@000`2jm`00VJ8009VR000409VR0080joL01@2RR@030?OB00H0
XVT00P3gX@030:990240i6P01P3gL0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/02<0
mcl00`2aM0030?NQ00L0/E00303gL0040;4:01D0i0d04@3f3P020;QC00<0mg001`2h;`040?Lo00L0
^0/08P3f3P0>0?M`00P0_@/08@3f3P020?M`00P0`S80103g?`080<8;0200mPh0303gL0090<L<0200
mPh0>P3oool004H0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]00<0nP1S
00D0IVIV0?X0H`1c05/0L`1K0?T0a@0307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<509T0
n@806@1c00<0IVIV03H0n@0207<00`0207<4000DL`@002]c00D005gi0012L`00@W<0049c002?n@03
001IL`800<3i00<0071c06IVIP00L7<00P00lOP2001cH0800?S?0`00LdT2003hW@<007<b0P00n6`3
001c6`03003h>`00L`@007<4008007<400<00?P9019c001VIVH00P0BL`000`0Wn000:G<002Uc0002
02Uc0080F?P00`0oL`0=08Wh00D0Lf8000<0IVIV0?OB003gdP001`3gdP000`000000mm800?OB000H
0?OB0080F?P01@17P@000`29n000HH4006610002066100T0^_L00`21KP0=0>?201T0mm80101>S@02
08Wh00D0JXd00P2jm`0308J=00<0fN@01P2=N0070?OB0280i9D00`1bV0020;[g00H0T9P00P3[m`05
09R200<0mm801@2HH`0T0?NQ00030;[g002IXP00VJ8000@0VJ800P3[m`050::900<0mm801P2RJ@02
0?NQ0080XTT0:03TJ0050:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/02<0mcl00`2aM003
0?NQ00L0/E00303gL0030;4:01`0i0d02`3f3P020;QC00<0mg001`2h;`040?Lo00L0^0/08P3f3P0>
0?M`00P0_@/08@3f3P020?M`00P0`S80103g?`080<8;0200mPh03@3gL0080<L<0200mPh0>P3oool0
04H0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]00<0nP1S00D0IVIV07<0
F`1c05/0L`1K0?T0a@0307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<509T0n@806@1c00<0
IVIV03H0n@0207<00P0207<01@040?T001Ac000DL`0057<002ci00@002]c00D005gi0012L`00@W<0
049c002?n@03001IL`800<3i00@0IVIV001`L`00L7<00?7h0`00Lf02003hc`<007=90P00n9d3001c
<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@1VIVH04W<000804W<000<09oP002Uc
000YL`000P0YL`0205Sh00<0?g<03@29n00407=R00030?OB001VIVH0mm8000P0mm8000<000000?OB
003gdP00603gdP0205Sh00D0Ah4000<0ROP00661001QP@000P1QP@060:cT00<0^_L00P21KP0D0>?2
01<0mm80101>S@0208Wh00D0JXd00P2jm`0308J=00<0fN@01P2=N00=0?OB01/0i9D0101bV0020;[g
00H0T9P00P3[m`0509R200<0mm801@2HH`0T0?NQ00030;[g002IXP00VJ8000@0VJ800P3[m`050::9
00<0mm801P2RJ@020?NQ00030:99003TJ000i6P002L0i6P01@2ZT@030?OB00H0ZVl00`3gX@060:Y=
00<0mg001`2Z;00S0?Lo00<0/G@00`3gX@070;5@00`0mg000P2a2P0S0>@=00D0mPh00P2hD`030?M`
00L0^2l0103g?`070;P;0280mPh03P3gL0080;d;0240mPh00P3gL0080<8b00@0mcl020322`0Q0?H>
00`0mg002037300P0?H>03X0oooo00160?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H307<0;@80
nP1S00<0IVIV0?X0H`1c05/00P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c0`1707<509T0
n@0401T0L`1VIVH06@1c03H0n@<00P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0`00
@W<01000SoT005Uc001IL`00FG<20030n@0406IVIP00L7<0071c003an0<007=P0P00n<l3001cB@80
0?RM0`00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@00`00n0T0IVIV019c0002019c0003
02Oh000YL`00:G<00080:G<00P1Hn00303mc00d0ROP0101cHP000`1VIVH0hl400>?100040>?100@0
mm8000<000000?OB003gdP00603gdP0205Sh00D0Ah4000@0ROP00661001QP@00HH402P2/i002085^
01X0hl803@3gdP0404j=0080ROP01@1ZS@020;[g0080QXd0103Ii00608eh01<0mm805@3TU@0407:H
0080^_L01P2@V0020>_g00D0V8800`3gdP0509QS02@0mj4000<0^_L009VR002IXP00102IXP020>_g
00D0XXT00`3gdP060:9Y0080mj40:@3TJ0060:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/
02<0mcl00`2aM0030?NQ00L0/E00303gL0000`2a2P00i0d00>@=000W0>@=0080^5<00`3gL0070;P_
00@0mcl01`2h2`0R0?H>00h0mg00202m2`0Q0?H>0080mg002032<P040?Lo00P0`P/08@3f3P0<0?M`
00P0a``0803f3P0j0?ooo`00AP3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P3j0340L`0]0080
L`0]0P3j06<00`1VIVH0nP1S07<0F`0207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<304L0
L`D0V@3i00@06@1c06IVIP0I07<0=P3i0`0207<01@040?T001Ac000DL`0057<002ci00<002]c0P00
GOT20012L`8008oi0`00FG<01000`?T0IVIV001`L`00L7<2003an0<007=P0P00n<l3001cB@03003h
W@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/00`00n3/007<4001c1002001c100306IV
IP0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`0205Sh00<0?g<03@29n00307=R00030>?1
001VIVH0hl4000T0hl4000<000000>?1003gdP00603gdP0205Sh00@0Ah400P29n003066100X0[>@0
00<0PFh00>?2003S`P007`3S`P070?OB00@0CXd00P29n00506Z=0080^_L000<0QXd00=WT003Ii000
0`3Ii00608eh01T0mm803P3TU@0507:H0080^_L01P2@V0020>_g00D0V8800`3gdP0509QS02@0mj40
00<0^_L009VR002IXP00102IXP020>_g00D0XXT00`3gdP060:9Y00P0mj408P3TJ0000`3[m`00ZY40
0:ZA00040:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/02<0mcl00`2aM0030?NQ00L0/E00
303gL00Y0>@=00<0^5<00`3gL0070;P_00@0mcl01`2h2`0R0?H>00h0mg00202m2`0Q0?H>0080mg00
2032<P040?Lo00P0`P/08@3f3P0<0?M`00P0a``0803f3P0j0?ooo`00AP3oool00`1VIVH0oooo0?oo
o`070?ooo`0307<05P3j0340L`0]0080L`0]00@0nP1S06IVIP3j06<0nP1S0`1c05/407<0LP040?T0
m`1M07<0G@1c0<X0n@<0A`1c1@2I0?T0101VIVH06@1c01T0L`0f0?T30080L`0500@0n@0057<001Ac
000DL`00;?T00`00:g<2001Mn@80049c0P00SoT3001IL`040030n@1VIVH0071c001`L`800?7h0`00
Lf000`00n<l007=9001cB@02001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00
La/01P00n3/007<4001c1000L`@00?P906IVIP@04W<000<09oP002Uc000YL`000P0YL`000`1Hn000
?g<003mc000203mc00d0ROP00P1cHP000`3S`@00IVIV0>?1000:0>?100030000003S`@00hl4000D0
hl404`3gdP0205Sh00@0Ah400P29n002066100/0[>@0:03S`P0504j=0080ROP0101ZS@030;[g0003
08J=003Ii000fN@000<0fN@01P2=N00O0?OB00L0i9D000<0ROP007:H001bV0000`1bV0020;[g00H0
T9P00P3[m`0509R200<0mm801@2HH`0T0?NQ00030;[g002IXP00VJ8000@0VJ800P3[m`050::900<0
mm801P2RJ@0>0?NQ01/0i6P00P3[m`060:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3gL0070:X/02<0
mcl00`2aM0030?NQ00L0/E004P3gL00R0>@=00@0^5<00`3gL0070;P_00@0mcl01`2h2`0R0?H>00h0
mg002@2m2`0P0?H>0080mg002032<P040?Lo00P0`P/08@3f3P0<0?M`00P0a``0803f3P0j0?ooo`00
AP3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P3j0340L`0]0080L`0]00@0nP1S06IVIP3j06<0
nP1S0`1c05/307<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@0406IVIP0I07<06@1c
03H0n@<00P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<2002?n@<005Uc00@0
IVIV0030n@00L7<0071c0P00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00Lc80
0P00Lc800`00n6`007<K001c6`02001c6`06003h>`00L`@007<4001c101VIVH00?P9100BL`000`0W
n000:G<002Uc000202Uc000305Sh000oL`00?g<00080?g<03@29n00207=R000306IVIP3S`@00hl40
00X0hl4000<000000>?1003S`@002`3S`@0=0?OB0080F?P01017P@0208Wh00030661002/i000[>@0
00T0[>@0:@3S`P0504j=0080ROP0101ZS@030;[g00H0fN@01P2=N00T0?OB00<0ROP01@1bV0020;[g
00H0T9P00P3[m`0509R200<0mm801@2HH`0T0?NQ00030;[g002IXP00VJ8000@0VJ800P3[m`050::9
00<0mm801P2RJ@0D0?NQ01@0i6P000<0XJX00>_g003[m`001P2ZT@030?OB00H0ZVl00`3gX@060:Y=
00<0mg001`2Z;00S0?Lo00<0/G@00`3gX@070;5@01P0mg006`3T3@050;QC00<0mg001`2h;`040?Lo
00L0^0/08P3f3P0>0?M`00T0_@/0803f3P030?M`00L0`S80103g?`090<8;0200mPh0303gL0080<L<
0240mPh0>@3oool004H0oooo00<0IVIV0?ooo`3oool01`3oool00`1c01H0nP0a07<0;@0207<0;@04
06IVIP3j06<0nP1S0?X0H`<0L`1K0`1c07820?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c102I0?T0
1@1VIVH06@1c01T0L`0I07<0=P3i00<00P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi
0P00@W<2002?n@<005Uc00@0IVIV001`L`00L7<0071c0P00lOP3001cH003003hc`00LdT007=90080
07=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@007<406IV
IP800?P9100BL`00100Wn000:G<002Uc000YL`0205Sh00@0?g<03@29n0000`1cHP00hl4006IVIP0<
0>?100@00000403S`@070?OB0080F?P01017P@0208Wh00030661002/i000[>@000l0[>@08P3S`P00
0`1Hn000CXd004j=000304j=0080ROP0101ZS@020;[g00L0fN@01P2=N00T0?OB00<0ROP01@1bV002
0;[g00H0T9P00P3[m`0509R200<0mm80102HH`0U0?NQ00030;[g002IXP00VJ8000@0VJ800P3[m`05
0::900<0mm801P2RJ@0J0?NQ00d0i6P00P2QZP020>_g00H0ZY400`3gdP060:Y_00<0mj401P2ZC@03
0?M`00L0ZR`08`3g?`030;5d00<0mj401`2aD00N0?M`01@0i0d01P2hD`030?M`00L0^2l0103g?`07
0;P;0280mPh000<0_EH00?M`003gL0002`3gL0090;d;0200mPh00`3gL0070<8b00@0mcl02@322`0P
0?H>00`0mg002@37300P0?H>03T0oooo00150?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H01@3j
0340L`0]07<0;@1c02d0IVIV00<0nP1S0`1c05/307<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`17
07<409T0n@0406IVIP0I07<06@1c01T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`80
05gi0P00@W<2002?n@8005Uc00<0IVIV0030n@00L7<00P00L7<2003an0<007=P00<00?S?001cB@00
LdT00P00LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K008007<K00@00?Pk001c1000
L`@0IVIV0P00n0T4019c000402Oh000YL`00:G<002Uc0080F?P0100oL`0=08Wh00030>?1001VIVH0
hl4000`0hl4000<000000>?1003S`@005`3S`@000`0^P@00F?P005Sh000404N10080ROP0602/i00K
0>?20080F?P01@1>S@0208Wh00@0JXd02@2jm`0608eh02@0mm800`29n00507:H0080^_L01P2@V002
0>_g00D0V8800`3gdP0409QS00H0hi@07`3gX@000`2jm`00VJ8009VR000409VR0080joL01@2RR@03
0?OB00H0XVT0803gX@060>AX00<0XJX00P3[m`060:ZA00<0mm801P2ZK`030?NQ00H0ZTd00`3TJ007
0:X/02<0mcl00`2aM0030?NQ00L0/E008P3gL0020;RL00d0i0d01`2hD`030?M`00L0^2l0103g?`07
0;P;0280mPh000<0_EH00?M`003gL0002`3gL0090;d;0200mPh00`3gL0070<8b00@0mcl02@322`0P
0?H>00`0mg002@37300P0?H>03T0oooo00150?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H0103j
0340L`0]07<0;@1VIVH40?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`040<X0n@17
07<0A`1c04L0L`<0V@3i00<0IVIV09T0n@0I07<00P0I07<40080L`0500@0n@0057<001Ac000DL`00
;?T00`00:g<2001Mn@80049c0P00SoT01000FG<0IVIV001IL`00`?T3001`L`800?7h0`00Lf000`00
n<l007=9001cB@02001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/01000
n3/007<406IVIP00L`@2003h2@@04W<000@09oP002Uc000YL`00:G<00P1Hn00403mc00`0ROP00P3S
`@000`1VIVH0hl400>?1000;0>?100030000003S`@00hl4001L0hl4000<0;X4005Sh001Hn0001017
P@000`29n000[>@00:cT000M0:cT01D0hl800P1Hn00504j=0080ROP0101ZS@090;[g00H0SGP0903g
dP0308Wh00D0LYP00P2jm`06092H0080joL01@2HPP030?OB00<0V6<03@3SU00I0?NQ00030;[g002I
XP00VJ8000@0VJ800P3[m`050::900<0mm801P2RJ@0S0?NQ00H0XJX00P3[m`060:ZA00<0mm801P2Z
K`030?NQ00D0ZTd0103TJ0070:X/02<0mcl00`2aM0030?NQ00L0/E008P3gL0020;RL00<0mm800`2h
N0060>@=00030?NQ002hD`00^5<000D0^5<00`3gL0070;P_00@0mcl01`2h2`060>@=01`0mPh000<0
_EH00?M`003gL0002`3gL0090;d;0200mPh00`3gL0070<8b00@0mcl02@322`0P0?H>00`0mg002@37
300P0?H>03T0oooo00150?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H0103j0340L`0]07<0;@1V
IVH40?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`030<X0n@1707<0A`1c00@0V@3i
00<0IVIV09T0n@0I07<00P0I07<40080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<01000GOT0
049c0012L`00@W<2002?n@04001IL`1VIVH005Uc0030n@<0071c0P00lOP3001cH003003hc`00LdT0
07=9008007=900<00?RM001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`03001c101V
IVH007<400800?P90`0BL`0202Oh00<0:G<00P1Hn00403mc00d0ROP000<0IVIV08Wh0029n0000`29
n0090>?100030000003S`@00hl4001H0hl400P0^P@0205Sh00@0Ah401`29n00O0:cT00h0hl8000<0
<Xd005Sh001Hn000101>S@0308Wh00@0JXd02@2jm`0508eh02D0mm800`29n00507:H0080^_L01P2@
V0020>_g00D0V8800`3gdP0209QS01@0hi@04`3gX@000`2jm`00VJ8009VR000409VR0080joL01@2R
R@030?OB00H0XVT08`3gX@060:6Z0080joL01P2ZT@030?OB00H0ZVl00`3gX@040:Y=00D0i6P01`2Z
;00S0?Lo00<0/G@00`3gX@070;5@0280mg000P2hW0030?OB00L0^7P00`3gX@070;QC00<0mg001`2h
;`040?Lo00H0^0/03@3T3@0F0?H>00030;eF003gL000mg0000/0mg002@2m2`0P0?H>00<0mg001`32
<P040?Lo00T0`P/0803f3P0<0?M`00T0a``0803f3P0i0?ooo`00A@3oool00`1VIVH0oooo0?ooo`07
0?ooo`80L`0F00<0nP0a07<0;@1VIVH01@3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M
07<00`3:0?T0A`1c04L0L`0309T0n@0306IVIP2I0?T0V@3i00<06@1c100207<01@040?T001Ac000D
L`0057<002ci00<002]c00@005gi0012L`00@W<0049c0P00SoT0101VIVH005Uc0030n@00`?T3001`
L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@03003hW@00Lc8007<b008007<b00@00?Q/001c
6`00La/007<K0P00n3/00`1VIVH007<4001c1002003h2@<04W<00P0Wn00302Uc0080F?P0100oL`0<
08Wh000306IVIP29n000ROP000X0ROP00P3S`@000`000000hl400>?1000G0>?10080;X400P1Hn004
04N100d0ROP06`2/i0001000n0T05Xd001J=000FS@070>?20080<Xd00P1Hn00404j=00<0ROP0101Z
S@090;[g00D0SGP01P3S`P0O0?OB00<0ROP01@1bV0020;[g00H0T9P00P3[m`0509R200<0mm800P2H
H`0J0>>D00d0mj4000<0^_L009VR002IXP00102IXP020>_g00D0XXT00`3gdP060:9Y02<0mj401P2Q
ZP020>_g00H0ZY400`3gdP060:Y_00<0mj400`2ZC@060>AX00L0ZR`08`3g?`030;5d00<0mj401`2a
D00R0?M`0080^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0^2l0103g?`050;P;01<0i0d04@3f
3P000`2mEP00mg000?M`000<0?M`00P0_@/0803f3P030?M`00L0`S801@3g?`080<8;0200mPh0303g
L0090<L<0200mPh0>@3oool004D0oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0
IVIV00D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<00`2I
0?T00`1VIVH0V@3i01T0L`0301T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`04001M
n@00@W<0049c0012L`8008oi00@0IVIV001IL`00`?T00<3i0`00L7<2003an0<007=P00<00?S?001c
B@00LdT00P00LdT01000n9d007<b001c<P00Lc82003hK0<007<K00<00?Pk001c101VIVH00P00L`@2
003h2@<04W<00P0Wn00302Uc0080F?P0100oL`0<08Wh000306IVIP29n000ROP000`0ROP000@00000
08Wh0029n000ROP05@3S`@0302j10080F?P01017P@0C08Wh01@0[>@000<008d5003h2@0FS@00100F
S@0202Oh00@0<Xd00`1Hn00404j=0080ROP01@1ZS@090;[g00@0SGP03@3S`P0I0?OB00<0ROP01@1b
V0020;[g00H0T9P00P3[m`0509R200<0mm8000<0V6<00>>D003SU0007`3SU0070?NQ00030;[g002I
XP00VJ8000@0VJ800P3[m`050::900<0mm801P2RJ@0S0?NQ00H0XJX00P3[m`060:ZA00<0mm801P2Z
K`030?NQ0080ZTd01`3TJ0070:X/02<0mcl00`2aM0030?NQ00L0/E008P3gL0020;RL00<0mm801`2h
N0030?NQ00P0^5<00P3gL0070;P_00@0mcl0102h2`0J0>@=00/0mPh000<0_EH00?M`003gL000303g
L0080;d;0240mPh00P3gL0070<8b00D0mcl020322`0P0?H>00`0mg002@37300P0?H>03T0oooo0015
0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H00`3j0340IVIV07<0;@050?X0H`80L`1K00D0n@35
07<0LP1c0780L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c0080V@3i00<0IVIV09T0n@2I0?T0100I
07<40080L`@001Ac00D002ci000[L`00:g<002]c001Mn@030012L`04002?n@1VIVH005Uc001IL`80
0<3i0`00L7<2003an08007=P0P00n<l3001cB@800?RM0`00Lc82003hK0<007<K00<00?Pk06IVIP00
L`@00P00L`@2003h2@<04W<00P0Wn00302Uc0080F?P0100oL`0;08Wh000306IVIP29n000ROP000d0
ROP000<0000008Wh0029n0001`29n0000`00n3/0hl400>?1000<0>?100<0;X4000<0F?P004N10017
P@000`17P@0I08Wh00h0[>@000<008d5003h2@0FS@00100FS@0202Oh00@0<Xd00`1Hn00404j=0080
ROP01@1ZS@090;[g00<0SGP0503S`P0C0?OB00<0ROP01@1bV0020;[g00H0T9P00P3[m`0509R200<0
mm80:03SU0020;[g00H0VJ800P3[m`050::900<0mm801P2RJ@0S0?NQ00H0XJX00P3[m`060:ZA00<0
mm801P2ZK`030?NQ00030:Y=003TJ000i6P000H0i6P01`2Z;00S0?Lo00<0/G@00`3gX@070;5@0280
mg000P2hW0030?OB00L0^7P00`3gX@080;QC0080mg00202h;`030?Lo00<0^0/08@3T3@050?H>0003
0;eF003gL000mg0000`0mg00202m2`0Q0?H>0080mg002032<P040?Lo00P0`P/0803f3P0=0?M`00P0
a``0803f3P0i0?ooo`00A@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00<0nP0a06IVIP1c02d0
1@3j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0209T0n@03
06IVIP2I0?T0V@3i00<06@1c00<0=P3i0080L`0207<00P0207<4000DL`@002]c00H005gi0012L`00
@W<0049c002?n@1VIVH2001IL`800<3i0`00L7<2003an08007=P0P00n<l3001cB@800?RM0`00Lc82
003hK0<007<K00<0IVIV001c1000L`@00P00L`@2003h2@<04W<000<09oP002Uc000YL`000P0YL`02
05Sh00<0?g<03029n0000`1VIVH0ROP008Wh000=08Wh000300000029n000ROP000L0ROP00P00n3/4
00211@03003h2@3S`@00hl4000D0hl40100^P@000`1Hn000Ah4004N1000304N101l0ROP01`2/i002
002=1@03003h2@0FS@005Xd000<05Xd00P0Wn00403:=00<0F?P0101>S@0208Wh00D0JXd02@2jm`02
08eh01/0hl803@3gdP0308Wh00D0LYP00P2jm`06092H0080joL01@2HPP020?OB02T0hi@00P2jm`06
09VR0080joL01@2RR@030?OB00H0XVT08`3gX@060:6Z0080joL01P2ZT@030?OB00H0ZVl00`3gX@09
0>AX00L0ZR`08`3g?`040;5d0080mj401`2aD00R0?M`0080^9`00`3gdP070;Qh00<0mj40202hD`02
0?M`00P0^2l00`3g?`020;P;02L0i0d000<0_EH00?M`003gL000303gL0080;d;0240mPh00P3gL008
0<8b00@0mcl020322`0Q0?H>00`0mg002037300P0?H>03T0oooo00150?ooo`0306IVIP3oool0oooo
00L0oooo0P1c01H00`1VIVH0L`0]07<0;@040?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0m`03
05d0L`050<X0n@1707<0A`1c09T0n@1VIVH00`2I0?T301T0L`0303H0n@0207<00P1c00800P1c1000
57<4000[L`05001Mn@00@W<0049c0012L`1VIVH00`00FG<20030n@<0071c0P00lOP2001cH0800?S?
0`00LdT2003hW@<007<b0P00n6`3001c6`0306IVIP00L`@007<4008007<40P00n0T3019c000302Oh
000YL`00:G<00080:G<00P1Hn00303mc00/0ROP000<0IVIV08Wh0029n0003P29n0000`000000ROP0
08Wh000708Wh00800?Pk1000P@D2003h2@<058400P0Wn00502j1000305Sh0017P@00Ah4000<0Ah40
8`29n005002=1@03003h2@0FS@005Xd000<05Xd00P0Wn00403:=00<0F?P0101>S@0208Wh00D0JXd0
2@2jm`000`2=N000hl800>?2000P0>?200L0mm800P29n00607:H0080^_L01P2@V0020>_g00D0V880
203gdP0R0>>D000307VR002jm`00^_L000H0VJ800P3[m`050::900<0mm801P2RJ@0S0?NQ00H0XJX0
0P3[m`060:ZA00<0mm801P2ZK`090?NQ00<0i6P01`2Z;00S0?Lo00@0/G@00P3gX@070;5@0280mg00
0P2hW0030?OB00P0^7P00P3gX@080;QC0080mg00202h;`030?Lo00030;P;003T3@00i0d002H0i0d0
00<0_EH00?M`003gL000303gL0080;d;0240mPh00P3gL0080<8b00@0mcl020322`0Q0?H>00`0mg00
2037300P0?H>03T0oooo00150?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F0?X0<@1VIVH00P1c
02d40?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`<0A`1c00<0V@3i06IVIP2I0?T0
0P2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<00`00;?T002]c000[L`02000[L`05
001Mn@00@W<0049c0012L`1VIVH00`00FG<20030n@<0071c00@00?7h001cH000Lf0007=P0P00n<l3
001cB@800?RM0`00Lc82003hK08007<K00<0IVIV003h>`00L`@00`00L`@2003h2@<04W<000<09oP0
02Uc000YL`000P0YL`0205Sh00<0?g<02`29n0000`1VIVH0ROP008Wh000>08Wh000300000029n000
ROP000L0ROP00P00n3/400211@800?P90`0DP@0202Oh00D0;X4000<0F?P004N10017P@000`17P@0S
08Wh00D008d500<00?P901J=000FS@000`0FS@0202Oh00@0<Xd00`1Hn00404j=0080ROP01@1ZS@09
0;[g02T0hl8000<0E9P008Wh0029n0001P1bV0020;[g00H0T9P00P3[m`0509R200h0mm806`3SU002
07VR0080^_L01P2IXP020>_g00D0XXT00`3gdP060:9Y02<0mj401P2QZP020>_g00H0ZY400`3gdP06
0:Y_00`0mj401`2Z;00S0?Lo00@0/G@00P3gX@070;5@0280mg000P2hW0030?OB00P0^7P00P3gX@08
0;QC0080mg00202h;`030?Lo02P0i0d00P2mEP0>0?M`00P0_@/08@3f3P020?M`00P0`S80103g?`08
0<8;0240mPh0303gL0080<L<0240mPh0>03oool004D0oooo00<0IVIV0?ooo`3oool01`3oool00`1c
01H0IVIV07<0;@0207<0;@@0nP1S0`1c05/407<0LP040?T0m`1M07<0G@1c05d0L`<0A`1c00<0IVIV
09T0n@2I0?T00P2I0?T301T0L`0503H0n@0207<00P1c0080L`040?T00`0057<01000;?T002]c000[
L`00:g<2001Mn@80049c00<0IVIV002?n@00FG<00P00FG<20030n@<0071c00@00?7h001cH000Lf00
07=P0P00n<l3001cB@800?RM0`00Lc82003hK08007<K00<0IVIV003h>`00L`@00`00L`@00`00n0T0
4W<0019c0002019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc00X0ROP000<0IVIV08Wh0029
n0003`29n0000`000000ROP008Wh000608Wh000300217P00n3/00?Pk00@008450P00n0T301B10080
9oP01@0^P@000`1Hn000Ah4004N1000304N102<0ROP01@00S@D00`00n0T05Xd001J=000301J=0080
9oP0100bS@0305Sh00@0CXd00P29n00506Z=00P0^_L0:P3S`P000`1DV000ROP008Wh000607:H0080
^_L01P2@V0020>_g00D0V880503gdP0D0>>D00<0NJ800P2jm`0609VR0080joL01@2RR@030?OB00H0
XVT08`3gX@060:6Z0080joL01P2ZT@030?OB00H0ZVl0303gX@070:X/02<0mcl0102aM0020?NQ00L0
/E008P3gL0020;RL00<0mm80202hN0020?NQ00P0^5<00P3gL0080;P_00T0mcl08@3T3@030;eF00h0
mg00202m2`0Q0?H>0080mg002032<P040?Lo00P0`P/08@3f3P0<0?M`00P0a``08@3f3P0h0?ooo`00
A@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0L`0]0080L`0]103j06<307<0F`<0L`1b
0P3i0?L205d0L`050<X0n@1707<0A`1c04L0L`1VIVH0102I0?T301T0L`0503H0n@0207<00P1c0080
L`040?T00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c00<0IVIV002?n@00FG<00P00FG<2
0030n@80071c0P00lOP3001cH0800?S?0`00LdT2003hW@<007<b0P00n6`01000La/0IVIV001c6`00
n3/4001c1003003h2@0BL`004W<000804W<000<09oP002Uc000YL`000P0YL`0205Sh00<0?g<02@29
n0000`1VIVH0ROP008Wh000@08Wh000300000029n000ROP000H0ROP000<0084N003h>`00n3/01000
P@D2003h2@<058400P0Wn00402j10080F?P01@17P@0S08Wh00D008d500<00?P901J=000FS@000`0F
S@0202Oh00@0<Xd00`1Hn00404j=0080ROP01@1ZS@0>0;[g02<0hl800P1DV00208Wh00H0LYP00P2j
m`06092H0080joL01@2HPP0J0?OB00d0hi@0101iXP020;[g00H0VJ800P3[m`050::900<0mm801P2R
J@070>>D01`0mj401P2QZP020>_g00H0ZY400`3gdP060:Y_00`0mj401`2Z;00S0?Lo00@0/G@00P3g
X@070;5@0280mg000P2hW0030?OB00P0^7P00P3gX@080;QC00<0mg001`2h;`0?0?Lo01X0i0d0102m
EP0>0?M`00P0_@/08@3f3P020?M`00P0`S80103g?`080<8;0240mPh0303gL0090<L<0200mPh0>03o
ool004D0oooo00<0IVIV0?ooo`3oool01P3oool00`1c01H0IVIV0?X0<@0307<0;@@0nP1S0`1c05/3
07<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1VIVH509T0n@<06@1c00D0=P3i0080L`0207<00P1c
00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi00@0049c06IVIP00SoT008oi0`00FG<20030
n@80071c0P00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00Lc801P00
n6`007<K001c6`1VIVH007<K003h>`@007<400<00?P9019c000BL`000P0BL`000`0Wn000:G<002Uc
000202Uc0080F?P00`0oL`0908Wh000306IVIP29n000ROP00100ROP000<0000008Wh0029n0001P29
n0000`00PAh00?Pk003h>`0400211@800?P90`0DP@0202Oh00@0;X400P1Hn00504N102<0ROP01@00
S@D00`00n0T05Xd001J=000301J=00809oP0100bS@0205Sh00D0CXd00P29n00506Z=01@0^_L0703S
`P0305BH0080ROP01P1bV0020;[g00H0T9P00P3[m`0509R20200mm801P3SU00507VR0080^_L01P2I
XP020>_g00D0XXT00`3gdP050:9Y00l0hi@05@3gX@060:6Z0080joL01P2ZT@030?OB00H0ZVl0303g
X@070:X/02<0mcl0102aM0020?NQ00L0/E008P3gL0020;RL00<0mm80202hN0030?NQ00L0^5<00`3g
L0070;P_01@0mcl0503T3@050;eF00h0mg00202m2`0Q0?H>0080mg002032<P040?Lo00T0`P/0803f
3P0<0?M`00T0a``0803f3P0h0?ooo`00A03oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0
nP0a0080L`0]1@3j06<307<0F`<0L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c06IVIPD0V@3i0`0I
07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT01000@W<0
IVIV002?n@00SoT3001IL`800<3i0P00L7<2003an0<007=P00<00?S?001cB@00LdT00P00LdT00`00
n9d007<b001c<P02001c<P03003hK000La/0IVIV008007<K00@00?Pk001c1000L`@007<40P00n0T4
019c000302Oh000YL`00:G<00080:G<00P1Hn00303mc00P0ROP000<0IVIV08Wh0029n0004@29n000
0`000000ROP008Wh000608Wh000300217P00n3/00?Pk00@0084500<00?P901B1000DP@000P0DP@02
02Oh00@0;X400P1Hn00504N102<0ROP01@00S@D00`00n0T05Xd001J=000301J=00809oP0100bS@02
05Sh00D0CXd00P29n00506Z=01X0^_L05@3S`P0405BH0080ROP01P1bV0020;[g00H0T9P00P3[m`04
09R202D0mm8000<0ROP007VR001iXP00101iXP020;[g00H0VJ800P3[m`050::900<0mm80102RJ@0G
0>>D00h0mj401P2QZP020>_g00H0ZY400`3gdP060:Y_00`0mj401`2Z;00S0?Lo00@0/G@00P3gX@07
0;5@0280mg000P2hW0040?OB00L0^7P00`3gX@070;QC00<0mg001`2h;`0J0?Lo00d0i0d01P2mEP0>
0?M`00P0_@/08@3f3P030?M`00L0`S80103g?`090<8;0200mPh0303gL0090<L<0200mPh0>03oool0
04@0oooo00<0IVIV0?ooo`3oool01`3oool00`1VIVH0L`0F0?X0<@0207<0;@D0nP1S0P1c05/0103i
0<D0L`1b07<0LP1c07820?T0m`80G@1c00@0bP3i04L0L`1VIVH0A`1c1@2I0?T301T0L`@00P1c00D0
103i000DL`0057<001Ac000/n@03000[L`8005gi00@0IVIV0012L`00SoT008oi0`00FG<20030n@80
071c0P00lOP3001cH003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00Lc800`00n6`0
07<K06IVIP02001c6`04003h>`00L`@007<4001c10800?P9100BL`000`0Wn000:G<002Uc000202Uc
000305Sh000oL`00?g<00080?g<02029n0000`1VIVH0ROP008Wh000A08Wh000300000029n000ROP0
00H0ROP000<0084N003h>`00n3/01000P@D00`00n0T0584001B1000201B100809oP0100^P@0205Sh
00D0Ah408`29n005002=1@03003h2@0FS@005Xd000<05Xd00P0Wn00403:=0080F?P01@1>S@0208Wh
00D0JXd0802jm`0>0>?200D0E9P00P29n00607:H0080^_L01P2@V0020>_g00@0V8801P3S`P0O0?OB
000308Wh001iXP00NJ8000@0NJ800P2jm`0609VR0080joL01@2RR@030?OB00<0XVT07`3SU0070?NQ
00H0XJX00P3[m`060:ZA00<0mm801P2ZK`0<0?NQ00L0ZR`08`3g?`040;5d0080mj401`2aD00R0?M`
0080^9`0103gdP070;Qh00<0mj401`2hD`030?M`00L0^2l0803g?`060>@=00L0_EH03P3gL0070;d;
00L0i0d06`3f3P030?M`00L0`S80103g?`090<8;0200mPh0303gL0090<L<0200mPh0>03oool004@0
oooo00<0IVIV0?ooo`3oool01`3oool00`1VIVH0L`0F0?X0<@0207<0;@D0nP1S0P1c05/0103i0<D0
L`1b07<0LP1c07820?T0m`80G@1c00@0bP3i04L0L`1VIVH0A`1c1@2I0?T301T0L`@00P1c00D0103i
000DL`0057<001Ac000/n@03000[L`04001Mn@1VIVH0049c0012L`8008oi0`00FG<01000`?T0071c
001`L`00L7<2003an0<007=P00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c<P03
003hK01VIVH007<K008007<K00@00?Pk001c1000L`@007<40P00n0T4019c000402Oh000YL`00:G<0
02Uc0080F?P0100oL`0708Wh000306IVIP29n000ROP00180ROP000<0000008Wh0029n0001P29n000
0`00PAh00?Pk003h>`0400211@03003h2@0DP@005840008058400P0Wn00402j10080F?P01@17P@0S
08Wh00D008d500<00?P901J=000FS@000`0FS@000`0Wn000<Xd003:=000303:=0080F?P01@1>S@02
08Wh00D0JXd08`2jm`0201RH000302Oh003S`P00hl8000D0hl8000<0F?P005BH001DV0000`1DV002
08Wh00H0LYP00P2jm`06092H0080joL00`2HPP0=0>?201T0mm8000<0ROP007VR001iXP00101iXP02
0;[g00H0VJ800P3[m`050::900<0mm800P2RJ@0W0>>D00H0XJX00P3[m`060:ZA00<0mm801P2ZK`0<
0?NQ00L0ZR`08`3g?`040;5d0080mj401`2aD00R0?M`0080^9`0103gdP070;Qh00<0mj401`2hD`03
0?M`00L0^2l08P3g?`030?NQ00P0_EH03P3gL0060;d;00d0i0d05P3f3P030?M`00L0`S80103g?`09
0<8;0200mPh0303gL0090<L<0200mPh0>03oool004@0oooo00<0IVIV0?ooo`3oool01P3oool0101V
IVH0L`0F07<05P3j034207<0;@D0nP1S0P1c05/0103i0<D0L`1b07<0LP1c07820?T0m`80G@1c00<0
bP3i06IVIP1707<01P2I0?T301T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`04001M
n@1VIVH0049c0012L`8008oi0`00FG<01000`?T0071c001`L`00L7<2003an0<007=P00<00?S?001c
B@00LdT00P00LdT00`00n9d007<b001c<P02001c<P0306IVIP00La/007<K008007<K00@00?Pk001c
1000L`@007<40P00n0T4019c000402Oh000YL`00:G<002Uc0080DN@0100oL`0608Wh000306IVIP29
n000ROP001<0ROP000<0000008Wh0029n0001P29n0000`00PAh00?Pk003h>`0400211@03003h2@0D
P@005840008058400P0Wn00402j10080F?P01@17P@0S08Wh00D008d500<00?P901J=000FS@000`0F
S@000`0Wn000<Xd003:=000303:=0080F?P01@1>S@0208Wh00D0JXd08`2jm`0201RH00809oP01@0f
V00205Sh00D0E9P00P29n00607:H0080^_L01P2@V0020>_g0080V880503S`P0C0?OB000308Wh001i
XP00NJ8000@0NJ800P2jm`0609VR0080joL01@2RR@030?OB00030:9Y003SU000hi@002H0hi@01P2Q
ZP020>_g00H0ZY400`3gdP060:Y_00`0mj401`2Z;00S0?Lo00@0/G@00P3gX@070;5@0280mg000`2h
W0030?OB00L0^7P00`3gX@070;QC00<0mg001`2h;`0R0?Lo00<0mj40202mEP0>0?M`00D0_@/0503T
3@0@0?H>00<0mg001`32<P040?Lo00T0`P/0803f3P0<0?M`00T0a``0803f3P0h0?ooo`00A03oool0
0`1VIVH0oooo0?ooo`060?ooo`0406IVIP1c01H0L`0F0?X0<@80L`0]1@3j06<207<0F`050?T0a@1c
0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0IVIV04L0L`0609T0n@<06@1c100207<01@040?T001Ac
000DL`0057<002ci00<002]c00@0IVIV0012L`00@W<0049c0P00SoT3001IL`040030n@00L7<0071c
001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@03003hW@00Lc8007<b008007<b00<0IVIV
001c6`00La/00P00La/01000n3/007<4001c1000L`@2003h2@@04W<000<09oP002Uc000YL`000`1A
i00403mc00H0ROP000<0IVIV08Wh0029n0004`29n0000`000000ROP008Wh000608Wh000300217P00
n3/00?Pk00@0084500<00?P901B1000DP@000P0DP@0202Oh00@0;X400P1Hn00504N102<0ROP01@00
S@D00`00n0T05Xd001J=000301J=000302Oh000bS@00<Xd000<0<Xd00P1Hn00504j=0080ROP01@1Z
S@0S0;[g008069P00P0Wn00503JH0080F?P01@1DV00208Wh00H0LYP00P2jm`06092H0080joL00P2H
PP0J0>?200d0mm8000<0ROP007VR001iXP00101iXP020;[g00H0VJ800P3[m`050::900<0mm80:03S
U0000`2jm`00XJX00:6Z00040:6Z0080joL01P2ZT@030?OB00H0ZVl0303gX@070:X/02<0mcl0102a
M0020?NQ00L0/E008P3gL0030;RL00<0mm801`2hN0030?NQ00L0^5<00`3gL0070;P_0280mcl00`3g
X@080;eF00h0mg00102m2`0J0>@=00/0mPh00`3gL0070<8b00@0mcl02@322`0P0?H>00`0mg002@37
300P0?H>03P0oooo00140?ooo`0306IVIP3oool0oooo00D0oooo00D0IVIV0?ooo`1c01H0L`0F0?X0
<@0207<0;@D0nP1S0P1c05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0IVIV04L0L`1707<0
1@2I0?T401T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`0406IVIP00@W<0049c0012
L`8008oi0P00FG<20030n@<0071c0P00lOP3001cH003003hc`00LdT007=9008007=900H00?RM001c
<P00Lc8007<b06IVIP00n6`3001c6`800?Pk0`00L`@2003h2@@04W<000<09oP002Uc000YL`000`1A
i00403mc00D0ROP000<0IVIV08Wh0029n0005029n0000`000000ROP008Wh000608Wh000300217P00
n3/00?Pk00<008450P00n0T401B100809oP0100^P@0205Sh00D0Ah408`29n005002=1@03003h2@0F
S@005Xd000<05Xd000<09oP003:=000bS@000`0bS@0205Sh00D0CXd00P29n00506Z=02<0^_L00P0H
V00202Oh00D0=YP00P1Hn00505BH0080ROP01P1bV0020;[g00H0T9P00P3[m`000`2HPP00hl800>?2
000O0>?200L0mm8000<0ROP007VR001iXP00101iXP020;[g00H0VJ800P3[m`050::900T0mm808@3S
U0020;[g00H0XJX00P3[m`060:ZA00<0mm801P2ZK`0<0?NQ00L0ZR`08`3g?`040;5d0080mj401`2a
D00R0?M`00<0^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0^2l08P3g?`030?NQ00T0_EH03@3g
L0030;d;0240i0d01@3f3P030?M`00L0`S801@3g?`080<8;0200mPh03@3gL0080<L<0200mPh0>03o
ool004@0oooo00<0IVIV0?ooo`3oool01@3oool0101VIVH0oooo07<05P1c01H307<0;@D0nP1S0P1c
05/01@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0IVIV04L0L`1707<01@2I0?T401T0L`@00P1c
00D0103i000DL`0057<001Ac000/n@02000[L`0306IVIP00GOT0049c0080049c0P00SoT2001IL`80
0<3i0`00L7<2003an0<007=P00<00?S?001cB@00LdT00P00LdT01P00n9d007<b001c<P00Lc80IVIV
003hK0<007<K0P00n3/3001c10800?P90`0BL`0202Oh000302Uc001Ai000DN@00080DN@0100oL`05
08Wh000306IVIP29n000ROP001@0ROP000<0000008Wh0029n0001P29n0000`00PAh00?Pk003h>`03
00211@800?P9100DP@000`0Wn000;X4002j1000302j10080F?P01017P@0T08Wh00D008d500<00?P9
01J=000FS@000`0FS@000`0Wn000<Xd003:=000303:=0080F?P01@1>S@0208Wh00D0JXd08`2jm`02
01RH00809oP01@0fV00205Sh00D0E9P00P29n00607:H0080^_L01P2@V0020>_g02P0hl800P29n006
07VR0080^_L01P2IXP020>_g00D0XXT03`3gdP0J0>>D00<0^_L01P2QZP020>_g00H0ZY400`3gdP06
0:Y_00`0mj401`2Z;00S0?Lo00@0/G@00P3gX@070;5@0280mg000`2hW0030?OB00L0^7P00`3gX@07
0;QC00<0mg001`2h;`0S0?Lo0080mj402@2mEP0=0?M`0080_@/09`3T3@030?M`00L0`S801@3g?`08
0<8;0240mPh0303gL0080<L<0200mPh0>03oool004@0oooo00<0IVIV0?ooo`3oool0103oool01@1V
IVH0oooo0?ooo`1c01H0nP0a00<0L`0]103j06<307<0F`050?T0a@1c0780L`1b07<0LP3i0?L00P1M
07<0101VIVH0bP3i04L0L`1707<509T0n@<06@1c00<0=P3i0080L`0207<00P0207<4000DL`<002]c
00<0IVIV001Mn@00@W<00P00@W<2002?n@8005Uc0P00`?T3001`L`800?7h0P00Lf02003hc`@007=9
00@00?RM001c<P00Lc80IVIV0P00n6`3001c6`03003h>`00L`@007<4008007<40P00n0T3019c0080
9oP000<0:G<0057T001Ai0000P1Ai00403mc00@0ROP000<0IVIV08Wh0029n0005@29n0000`000000
ROP008Wh000608Wh000300217P00n3/00?Pk00<008450P00n0T401B1000302Oh000^P@00;X4000<0
;X400P1Hn00404N100H0O^@07P29n005002=1@03003h2@0FS@005Xd000<05Xd000<09oP003:=000b
S@000`0bS@0205Sh00D0CXd00P29n00506Z=02<0^_L00P0HV00202Oh00D0=YP00P1Hn00505BH0080
ROP01P1bV0020;[g00H0T9P000<0joL00>?2003S`P009`3S`P0208Wh00H0NJ800P2jm`0609VR0080
joL01@2RR@0E0?OB01@0hi@00`2jm`060:6Z0080joL01P2ZT@030?OB00H0ZVl0303gX@070:X/02<0
mcl0102aM0020?NQ00L0/E001P3SI`0L0?M`00<0^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0
^2l08`3g?`020?NQ00T0_EH03@3gL00X0>@=00040<9H003gL000mg000?M`00P0`S80103g?`080<8;
0240mPh0303gL0080<L<0240mPh0=`3oool004@0oooo00<0IVIV0?ooo`3oool0103oool01@1VIVH0
oooo0?ooo`1c01H0nP0a00<0L`0]103j06<307<0F`050?T0a@1c0780L`1b07<0LP3i0?L00P1M07<0
101VIVH0bP3i04L0L`1707<509T0n@<06@1c00<0=P3i0080L`0207<00P0207<4000DL`8002]c00<0
IVIV000[L`00GOT00`00@W<01000SoT005Uc001IL`00FG<20030n@<0071c0P00lOP2001cH0800?S?
0`00LdT2003hW@8007<b00<0IVIV003hK000n6`00`00La/00`00n3/007<4001c1002001c10800?P9
0`0BL`0202Oh00D0DN@0100oL`0308Wh000306IVIP29n000ROP001H0ROP000<0000008Wh0029n000
1P29n0000`00PAh00?Pk003h>`0300211@800?P9100DP@000`0Wn000;X4002j1000302j10080F?P0
0`17P@0=07kT01P0ROP01@00S@D00`00n0T05Xd001J=000301J=000302Oh000bS@00<Xd000<0<Xd0
0P1Hn00504j=0080ROP01@1ZS@0S0;[g008069P00P0Wn00503JH0080F?P01@1DV00208Wh00H0LYP0
0P2jm`06092H00L0joL08P3S`P000`1IXP00ROP008Wh000607VR0080^_L01P2IXP020>_g00D0XXT0
6`3gdP0=0>>D000407nZ002jm`00^_L00;[g00H0XJX00P3[m`060:ZA00<0mm801P2ZK`0<0?NQ00L0
ZR`08`3g?`040;5d0080mj401P2aD00=0>=W01H0mg000`2hW0030?OB00L0^7P00`3gX@070;QC00<0
mg001`2h;`0S0?Lo0080mj402@2mEP0C0?M`0240i0d00P32F0030?M`00P0`S80103g?`080<8;0240
mPh0303gL0080<L<0240mPh0=`3oool004@0oooo00<0IVIV0?ooo`3oool00`3oool01P1VIVH0oooo
0?ooo`3oool0L`0F0?X0<@<0L`0]103j06<307<0F`@0L`1b00@0n@3g05d0L`1VIVH0G@1c0`1707<5
09T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@04000DL`8002]c00<0IVIV000[L`00GOT00`00
@W<01000SoT005Uc001IL`00FG<20030n@<0071c0P00lOP2001cH0800?S?0`00LdT2003hW@03001c
<P1VIVH007<b00800?Q/0`00La/00`00n3/007<4001c1002001c10800?P90`0BL`000`0Wn000DN@0
057T0004057T00@0?g<00`29n0000`1VIVH0ROP008Wh000F08Wh000300000029n000ROP000H0ROP0
0`00n3/300211@800?P9100DP@000`0Wn000;X4002j1000302j10080F?P00P17P@0D07kT0180ROP0
1@00S@D00`00n0T05Xd001J=000301J=000302Oh000bS@00<Xd000<0<Xd00P1Hn00504j=0080ROP0
1@1ZS@0S0;[g008069P00P0Wn00503JH0080F?P01@1DV00208Wh00H0LYP00P2jm`06092H00d0joL0
6`3S`P0205VR0080ROP01P1iXP020;[g00H0VJ800P3[m`050::900L0hl806P3gdP060>>D0080OjX0
0`2jm`060:6Z0080joL01P2ZT@030?OB00H0ZVl0303gX@070:X/02<0mcl0102aM0020?NQ00D0/E00
4`3SI`0A0?M`00<0^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0^2l08`3g?`020?NQ00T0_EH0
6@3gL00J0>@=00<0`UP00`3gL0080<8b00@0mcl020322`0Q0?H>00`0mg002037300Q0?H>03L0oooo
00140?ooo`0306IVIP3oool0oooo00<0oooo00H0IVIV0?ooo`3oool0oooo07<05P3j034307<0;@@0
nP1S0`1c05/407<0LP040?T0m`1VIVH0G@1c0<X0n@<0A`1c1@2I0?T301T0L`0503H0n@0207<00P1c
0080L`040?T00`0057<01000;?T002]c06IVIP00:g<2001Mn@<0049c00@008oi001IL`00FG<005Uc
0P00`?T3001`L`800?7h0P00Lf02003hc`<007=90P00n9d00`1VIVH007<b001c<P02003hK0<007<K
00<00?Pk001c1000L`@00P00L`@2003h2@<04W<01`0Wn00303mc00<0ROP000<0IVIV08Wh0029n000
5P29n0000`000000ROP008Wh000708Wh00<00?Pk0`00P@D2003h2@@0584000<09oP002j1000^P@00
0`0^P@0205Sh0080Ah406P1ni00<08Wh00D008d500<00?P901J=000FS@000P0FS@0202Oh00D0<Xd0
0P1Hn00504j=0080ROP01@1ZS@0S0;[g008069P00P0Wn00503JH0080F?P01@1DV00208Wh00H0LYP0
0P2jm`06092H01<0joL0503S`P0305VR0080ROP01P1iXP020;[g00H0VJ800P3[m`040::900l0hl80
5@3gdP0607nZ00<0^_L01P2QZP020>_g00H0ZY400`3gdP060:Y_00`0mj401P2Z;0070>8j01d0mcl0
102aM0020?NQ00@0/E006P3SI`0;0?M`00<0^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0^2l0
8`3g?`020?NQ00T0_EH07P3gL00D0>@=00@0`UP00`3gL0080<8b00@0mcl020322`0Q0?H>00`0mg00
2@37300P0?H>03L0oooo00140?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?ooo`3oool00P3o
ool00`1c01H0nP0a07<0;@0207<0;@@0nP1S0`1c05/307<0LP80n@3g00<0IVIV05d0L`3:0?T00`17
07<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<0IVIV000[L`80
05gi0P00@W<2002?n@<005Uc0P00`?T3001`L`04003an000Lf0007=P001cH0800?S?0`00LdT2003h
W@0306IVIP00Lc8007<b00800?Q/0`00La/00`00n3/007<4001c1002001c10800?P90`0BL`0702Oh
00<0?g<00`1mh`00101VIVH0ON<007gS001mh`0E08Wh000300000029n000ROP000L0ROP00`00n3/3
00211@800?P9100DP@000`0Wn000;X4002j1000302j10080F?P000<0Ah4007kT001ni0007`1ni006
08Wh00D008d500<00?P901J=000FS@000P0FS@0202Oh00D0<Xd00P1Hn00504j=0080ROP01@1ZS@0S
0;[g008069P00P0Wn00503JH0080F?P01@1DV00208Wh00H0LYP00P2jm`05092H01X0joL03@3S`P04
05VR0080ROP01P1iXP020;[g00H0VJ800P3[m`030::901L0hl803P3gdP0607nZ00<0^_L01P2QZP02
0>_g00H0ZY400`3gdP060:Y_00`0mj401@2Z;00>0>8j01L0mcl0102aM0020?NQ00<0/E008@3SI`05
0?M`00<0^9`00`3gdP070;Qh00<0mj401`2hD`030?M`00L0^2l08`3g?`030?NQ00P0_EH0803gL003
0?OB00030<9o003T3@00i0d000/0i0d01@32F0030?M`00P0`S80103g?`080<8;0240mPh0303gL009
0<L<0200mPh0=`3oool004<0oooo00<0IVIV0?ooo`3oool00`3oool0101VIVH0oooo0?ooo`3oool2
07<05P030?X0<@1c02d0L`0]00D0nP1S0`1c05/307<0LP050?T0m`1VIVH0G@1c05d0L`3:0?T00`17
07<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@1VIVH002]c000[L`80
05gi0P00@W<2002?n@<005Uc0P00`?T2001`L`800?7h0`00Lf02003hc`<007=900<00?RM06IVIP00
Lc800P00Lc82003hK0<007<K00<00?Pk001c1000L`@00P00L`@2003h2@<04W<01`0Wn00203mc00<0
ON<000<0IVIV07gS001mh`00201mh`0?08Wh000300000029n000ROP000L0ROP00P00n3/400211@80
0?P9100DP@000`0Wn000;X4002j1000302j10080F?P09`1ni0000`00n3/008d5002=1@03002=1@03
003h2@0FS@005Xd000805Xd00P0Wn00503:=0080F?P01@1>S@0208Wh00D0JXd08`2jm`0201RH0080
9oP01@0fV00205Sh00D0E9P00P29n00607:H0080^_L01@2@V0060=SS01X0joL01P3S`P0505VR0080
ROP01P1iXP020;[g00H0VJ800P3[m`030::901h0hl801`3gdP0607nZ00<0^_L01P2QZP020>_g00H0
ZY400`3gdP060:Y_00`0mj40102Z;00E0>8j0140mcl0102aM0020?NQ0080/E009`3SI`030;RL00<0
mm801`2hN0030?NQ00L0^5<00`3gL0070;P_02<0mcl00`3gX@080;eF0240mg000P3gdP070<9o00H0
i0d01P32F0030?M`00P0`S80103g?`070<8;00L0i0d06`3f3P0<0?M`00T0a``0803f3P0g0?ooo`00
@`3oool00`1VIVH0oooo0?ooo`020?ooo`0306IVIP3oool0oooo0080oooo0P1c01H00`3j0340L`0]
07<0;@050?X0H`80L`1K00H0n@3507<0LP1c0780L`1b0?T0m`1VIVH205d0L`040<X0n@1707<0A`1c
04L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@0IVIV000[L`00:g<002]c
0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP3001cH0800?S?0`00LdT00`00n9d0IVIV
001c<P02001c<P800?Q/0`00La/00`00n3/007<4001c1002001c1003003h2@0BL`004W<000804W<0
1`0Wn00203mc0080ON<000<0IVIV07gS001mh`003`1mh`0908Wh000300000029n000ROP000L0ROP0
0P00n3/400211@800?P9100DP@000`0Wn000;X4002j1000302j1000305Sh001ni000O^@002H0O^@0
00<00?Pk002=1@00S@D00`00S@D00`00n0T05Xd001J=000201J=00809oP01@0bS@0205Sh00D0CXd0
0P29n00506Z=02<0^_L00P0HV00202Oh00D0=YP00P1Hn00505BH0080ROP01P1bV0020;[g00@0T9P0
3@3Hh`0H0>_g000305Sh001IXP00FJ8000@0FJ800P29n00607VR0080^_L01P2IXP020>_g0080XXT0
9P3S`P0607nZ00<0^_L01P2QZP020>_g00H0ZY400`3gdP060:Y_00`0mj400`2Z;00L0>8j00/0mcl0
102aM0020?NQ00030;5@003SI`00hfL002D0hfL0102hW0030?OB00L0^7P00`3gX@070;QC00<0mg00
1`2h;`0S0?Lo00<0mj40202mEP0Q0?M`0080mm801`32O`040?NQ00P0`UP00`3gL0080<8b00@0mcl0
1P322`0=0>@=01H0mPh0303gL0090<L<0200mPh0=`3oool004<0oooo00<0IVIV0?ooo`3oool00P3o
ool00`1VIVH0oooo0?ooo`020?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<207<0F`060?T0a@1c
0780L`1b07<0LP1VIVH0n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c100207<01@04
0?T001Ac000DL`0057<0IVIV00<002]c0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP3
001cH003003hc`00LdT007=9008007=900<0IVIV001c<P00Lc800P00Lc800`00n6`007<K001c6`02
001c6`03003h>`00L`@007<4008007<400<00?P9019c000BL`000P0BL`0702Oh000503mc001mh`00
ON<007gS001VIVH05`1mh`0308Wh000300000029n000ROP000L0ROP00P00n3/400211@800?P90`0D
P@0202Oh00D0;X401`1Hn00Q07kT00800?Pk1000S@D2003h2@@05Xd00P0Wn00503:=0080F?P01@1>
S@0208Wh00D0JXd08`2jm`0201RH00809oP01@0fV00205Sh00D0E9P00P29n00607:H0080^_L00`2@
V00D0=SS0180joL000<0F?P005VR001IXP00101IXP0208Wh00H0NJ800P2jm`0609VR0080joL000<0
XXT00>?2003S`P009@3S`P0607nZ00<0^_L01P2QZP020>_g00H0ZY400`3gdP060:Y_00`0mj400P2Z
;00S0>8j00D0mcl0102aM0020?NQ02L0hfL01@2hW0030?OB00L0^7P00`3gX@070;QC00<0mg001`2h
;`0S0?Lo00<0mj40202mEP0Q0?M`0080mm801`32O`040?NQ00P0`UP0103gL0070<8b00@0mcl01@32
2`0D0>@=0100mPh0303gL0090<L<0200mPh0=`3oool004<0oooo00D0IVIV0?ooo`3oool0oooo06IV
IP050?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<207<0F`060?T0a@1c0780L`1b07<0LP1VIVH0
n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0n@<06@1c100207<01@040?T001Ac000DL`1VIVH0
02ci00<002]c0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP3001cH003003hc`00LdT0
07=9008007=900<0IVIV001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@0
07<4001c10800?P9100BL`0702Oh000403mc001mh`00ON<006IVIQ/0ON<000<0000007gS001mh`00
1`29n002003h>`@008450P00n0T301B100809oP01@0^P@0=05Sh01/0O^@00P00n3/4002=1@800?P9
100FS@0202Oh00D0<Xd00P1Hn00504j=0080ROP01@1ZS@0S0;[g008069P00P0Wn00503JH0080F?P0
1@1DV00208Wh00H0LYP00P2jm`02092H01/0f><0303[m`000`1Hn000FJ8005VR000405VR0080ROP0
1P1iXP020;[g00H0VJ800P3[m`0W0>?2000308Wh001oZP00OjX000@0OjX00`2jm`060:6Z0080joL0
1P2ZT@030?OB00H0ZVl0303gX@000`2Z;000hSX00>8j000W0>8j00@0/G@02@3gX@0O0>=W00H0^9`0
0`3gdP070;Qh00<0mj401`2hD`030>=W00P0^2l08P3g?`030?NQ00P0_EH08@3gL0020?OB00L0`Wl0
103gX@080<9H00@0mg001`32<P040?Lo00@0`P/06P3T3@0;0?H>00`0mg002@37300P0?H>03L0oooo
00130?ooo`0506IVIP3oool0oooo0?ooo`1VIVH01@3oool207<05P030?X0<@1c02d0L`0]00D0nP1S
0P1c05/01@3i0<D0L`1b07<0LP1VIVH0n@3g00<0G@1c00<0bP3i04L0L`1707<01P2I0?T301T0L`@0
0P1c00D0103i000DL`0057<0IVIV000/n@03000[L`8005gi0P00@W<2002?n@<005Uc00@00<3i001`
L`00L7<0071c0P00lOP3001cH006003hc`00LdT007=9001cB@1VIVH00?RM1000Lc800`00n6`007<K
001c6`02001c6`04003h>`00L`@007<4001c10800?P9100BL`0702Oh00<0ON<000<0IVIV07gS001m
h`006@1mh`000`000000ON<007gS000607gS000300217P00n3/00?Pk00@008450P00n0T301B10080
9oP01@0^P@0C05Sh01@0O^@000<008dQ003h>`00n3/01000S@D2003h2@@05Xd00P0Wn00503:=0080
F?P01@1>S@0208Wh00D0JXd08`2jm`0201RH00809oP01@0fV00205Sh00D0E9P00P29n00607:H0080
^_L000<0T9P00=SS003Hh`00803Hh`060>_g000305Sh001IXP00FJ8000@0FJ800P29n00607VR0080
^_L01P2IXP080>_g0200hl800P29n00607nZ00<0^_L01P2QZP020>_g00H0ZY400`3gdP060:Y_00L0
hi@01@3gX@0Y0>8j00D0/G@0403gX@0G0>=W00L0^9`00`3gdP070;Qh00<0mj401P2hD`040>=W00P0
^2l08P3g?`030?NQ00P0_EH08@3gL0020?OB00P0`Wl00`3gX@080<9H00@0mg001`32<P040?Lo00<0
`P/08@3T3@050?H>00`0mg002@37300P0?H>03L0oooo00130?ooo`0406IVIP3oool0oooo06IVIPH0
oooo0P1c01H00`3j0340L`0]07<0;@050?X0H`80L`1K00D0n@3507<0LP1c0780IVIV0?T0m`0305d0
L`030<X0n@1707<0A`1c00H0V@3i0`0I07<40080L`0500@0n@0057<0IVIV000DL`00;?T00`00:g<0
1000GOT0049c0012L`00@W<2002?n@<005Uc00@00<3i001`L`00L7<0071c0P00lOP3001cH006003h
c`00LdT007=9001cB@1VIVH00?RM1000Lc800`00n6`007<K001c6`02001c6`04003h>`00L`@007<4
001c10800?P9100BL`0602Oh00<0ON<000<0IVIV07gS001mh`006P1mh`000`000000ON<007gS0006
07gS000300217P00n3/00?Pk00@008450P00n0T301B100809oP01@0^P@0I05Sh00h0O^@000<008dQ
003h>`00n3/01000S@D00`00n0T05Xd001J=000301J=00809oP01@0bS@0205Sh00D0CXd00P29n004
06Z=02@0^_L00P0HV00202Oh00D0=YP00P1Hn00505BH0080ROP01P1bV0020;[g02P0f><00P1Hn006
05VR0080ROP01P1iXP020;[g00H0VJ803P3[m`0I0>?2000305jZ0029n000ROP000H0OjX00`2jm`06
0:6Z0080joL01P2ZT@030?OB00D0ZVl03`3SU0040?NQ0280hSX01P2aM00G0?NQ00l0hfL000<0joL0
0;RL002hW0001@2hW0030?OB00L0^7P00`3gX@050;QC00D0hfL0202h;`0R0?Lo00<0mj40202mEP0Q
0?M`0080mm802032O`030?NQ00P0`UP0103gL0070<8b00@0mcl00P322`0W0>@=00d0mg002037300Q
0?H>03H0oooo00130?ooo`0406IVIP3oool0oooo06IVIPH0oooo0P1c01H307<0;@D0nP1S0P1c05/0
1@3i0<D0L`1b06IVIP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T401T0L`@00P1c00D0
103i000DL`1VIVH001Ac000/n@03000[L`04001Mn@00@W<0049c0012L`8008oi0P00FG<20030n@<0
071c0P00lOP3001cH006003hc`00LdT007=906IVIP00LdT00?RM1000Lc800`00n6`007<K001c6`02
001c6`04003h>`00L`@007<4001c10800?P9100BL`0902Oh000306IVIP0Wn0009oP001X0ON<000<0
000007gS001mh`001@1mh`0200217P800?Pk1000P@D2003h2@<058400P0Wn00502j101l0F?P01`1n
i002002=8@800?Pk1000S@D00`00n0T05Xd001J=000301J=00809oP01@0bS@0205Sh00D0CXd00P29
n00406Z=00H0Zn<07P2jm`0201RH00809oP0100fV00305Sh00D0E9P00P29n00607:H00030;[g003H
h`00f><002L0f><00P1Hn00605VR0080ROP01P1iXP020;[g00H0VJ804`3[m`0D0>?2000305jZ0029
n000ROP000H0OjX00`2jm`060:6Z0080joL01P2ZT@030?OB00@0ZVl05`3SU0030?NQ01/0hSX01`2a
M00N0?NQ00L0hfL00P3[m`070;RL00<0mm80202hN0020?NQ00@0^5<01P3SI`080;P_0280mcl00`3g
X@080;eF0240mg000P3gdP080<9o00<0mj402@32F0030?M`00L0`S80103g?`0X0>@=00h0mg002037
300Q0?H>03H0oooo00130?ooo`0306IVIP3oool0IVIV00L0oooo00<0L`0F0?X0<@1c02d00P1c02d4
0?X0H`<0L`1K00D0n@3507<0LP1VIVH0L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c00D0V@3i100I
07<40080L`0500@0n@1VIVH001Ac000DL`00;?T00`00:g<01000GOT0049c0012L`00@W<2002?n@80
05Uc0P00`?T3001`L`800?7h0`00Lf000`00n<l007=906IVIP02001cB@03003hW@00Lc8007<b0080
07<b00<00?Q/001c6`00La/00P00La/01000n3/007<4001c1000L`@2003h2@@04W<0200Wn0000`1V
IVH09oP002Oh000702Oh01@0ON<000<0000007gS001mh`00101mh`0300217P800?Pk1000P@D2003h
2@<058400P0Wn00402j102@0F?P01@00SB42003h>`@008d500<00?P901J=000FS@000`0FS@0202Oh
00D0<Xd00P1Hn00504j=0080ROP00`1ZS@0=0:_S01P0^_L00P0HV00202Oh00@0=YP00`1Hn00505BH
0080ROP01P1bV0070;[g0280f><000<0>J8005Sh001Hn0001P1IXP0208Wh00H0NJ800P2jm`0609VR
01T0joL03@3S`P0205jZ0080ROP01P1oZP030;[g00H0XJX00P3[m`060:ZA00<0mm800`2ZK`0O0>>D
0080mj40503R>P000`3gdP00/G@00;5d00050;5d0280mj400P2^^0030>_g00L0^9`00`3gdP080;Qh
0080mj400`2hD`070>=W00P0^2l08P3g?`030?NQ00P0_EH08@3gL0020?OB00P0`Wl00`3gX@090<9H
00<0mg001`32<P0:0?Lo0240i0d03`3gL0080<L<0240mPh0=P3oool004<0oooo00<0IVIV0?ooo`1V
IVH01`3oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S0`1c05/01@3i0<D0IVIV07<0LP1c0780n@3g
00<0G@1c00<0bP3i04L0L`1707<01@2I0?T301T0L`0303H0n@0207<00P1c00800P1c00@001Ac06IV
IP0057<001Ac1000:g<01000GOT0049c0012L`00@W<2002?n@8005Uc0P00`?T3001`L`800?7h0`00
Lf000`00n<l007=906IVIP02001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00
La/01000n3/007<4001c1000L`@2003h2@@04W<01`0Wn0000`1VIVH09oP002Oh000>02Oh00h0ON<0
00<0000007gS001mh`00101mh`0300217P800?Pk1000P@D00`00n0T0584001B1000201B100809oP0
100^P@06057S01h0F?P01@00SB42003h>`@008d500<00?P901J=000FS@000`0FS@0202Oh00D0<Xd0
0P1Hn00504j=0080ROP00P1ZS@0D0:_S0180^_L00P0HV00202Oh00@0=YP00`1Hn00505BH0080ROP0
1P1bV00=0;[g01/0f><00P0iXP0205Sh00H0FJ800P29n00607VR0080^_L01P2IXP0O0>_g00H0hl80
0`1NZP0208Wh00H0OjX00`2jm`060:6Z0080joL01P2ZT@030?OB0080ZVl09`3SU0000`2X/@00hSX0
0>8j000;0>8j0080mm801`2aM00R0?NQ0080[[P00`3[m`070;RL00<0mm80202hN0020?NQ0080^5<0
203SI`080;P_0280mcl00`3gX@080;eF0240mg000P3gdP080<9o00<0mj402@32F0030?M`00L0`S80
3`3g?`0K0>@=0100mg002037300Q0?H>03H0oooo00130?ooo`80IVIV203oool00`1c01H0nP0a07<0
;@0207<0;@@0nP1S0`1c05/01@3i0<D0IVIV07<0LP1c0780n@3g00<0G@1c0`1707<509T0n@<06@1c
00<0=P3i0080L`0207<00P0207<0101VIVH001Ac000DL`0057<4000[L`04001Mn@00@W<0049c0012
L`8008oi0P00FG<20030n@<0071c0P00lOP2001cH0800?S?00D0IVIV001cB@00LdT007=9003hW@04
001c<P04003hK000La/007<K001c6`800?Pk0`00L`@2003h2@<04W<0200Wn0000`1VIVH09oP002Oh
000D02Oh00P0ON<000<0000007gS001mh`000`1mh`0400217P800?Pk1000P@D00`00n0T0584001B1
000201B100809oP00`0^P@0=057S01P0F?P01@00SB400`00n3/008d5002=1@03002=1@03003h2@0F
S@005Xd000<05Xd00P0Wn00403:=00<0F?P0101>S@0308Wh0080JXd06P2[h`0<0;[g008069P00P0W
n00403JH00<0F?P01@1DV00208Wh00H0LYP04`2jm`0D0=SS00<0>J800P1Hn00605VR0080ROP01P1i
XP020;[g00H0VJ808P3[m`0605jZ0080ROP01P1oZP030;[g00H0XJX00P3[m`060:ZA00<0mm8000<0
ZVl00>>D003SU0009@3SU0050:Ra00<0joL01P3R>P000`2aU`00mm800?OB00070;5d0280mj400P2^
^0030>_g00L0^9`00`3gdP080;Qh0080mj4000<0^5<00>=W003SI`00203SI`070;P_0280mcl00`3g
X@080;eF0240mg000P3gdP080<9o00<0mj402@32F0030?M`00P0`S80503g?`0D0>@=00030<MJ003g
L000mg0000h0mg002037300Q0?H>03H0oooo00130?ooo`80IVIV203oool00`1c01H0nP0a07<0;@02
07<0;@@0nP1S0`1c05/01@1VIVH0L`1b07<0LP1c0780n@3g00<0G@1c0`1707<509T0n@<06@1c00H0
=P3i0080L`0207<00P1c00@0n@1VIVH3000DL`@002]c00D005gi0012L`00@W<0049c002?n@03001I
L`800<3i0`00L7<2003an08007=P0P00n<l00`1VIVH007=9001cB@02003hW@<007<b0P00n6`3001c
6`03003h>`00L`@007<4008007<40P00n0T3019c00L09><000<0IVIV02Oh000Wn000100Wn0030000
00@09oP00`00000=02Oh0080ON<000<0000007gS001mh`000P1mh`000`00n6`0084N00217P020021
7P800?Pk1000P@D00`00n0T0584001B1000201B100809oP00P0^P@0D057S0180F?P01@00SB400`00
n3/008d5002=1@03002=1@03003h2@0FS@005Xd000<05Xd00P0Wn00403:=00<0F?P0101>S@0307kS
000306Z=002[h`00Zn<001l0Zn<01P2jm`0201RH00809oP0100fV00305Sh00D0E9P00P29n00607:H
01T0^_L03@3Hh`0403VR0080F?P01P1IXP0208Wh00H0NJ800P2jm`0609VR0280joL01P1NZP0208Wh
00H0OjX00`2jm`060:6Z0080joL01P2ZT@030?OB02L0hi@01P2X/@030>_g00L0/IL00P3gdP070;5d
0280mj400P2^^0030>_g00L0^9`00`3gdP080;Qh0080mj402`3SI`070;P_0280mcl00`3gX@080;eF
0240mg000`3gdP070<9o00<0mj402@32F0030?M`00P0`S806@3g?`0>0>@=0080aeX0403gL0070<L<
00L0i0d06`3f3P0f0?ooo`00@P3oool206IVIPT0oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0H`<0
L`1K00D0IVIV07<0LP1c0780L`1b0?T0m`0205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<0
1@0f0?T00P1c0080L`0207<0IVIV00@001Ac1000:g<01@00GOT0049c0012L`00@W<008oi00<005Uc
0P00`?T3001`L`800?7h0P00Lf000`00n<l0IVIV001cB@02001cB@800?RM0`00Lc82003hK0<007<K
00<00?Pk001c1000L`@00P00L`@2003h2@804W<0200Th`000`1VIVH09><002CS000302CS00050000
000Th`009oP002Oh000000000P0Wn0001@0000009oP002Oh000Wn000000000`09oP000<0085B003h
W@0000001000PCP00`00n6`0084N00217P0200217P800?Pk1000P@D00`00n0T0584001B1000201B1
00809oP00P0^P@0J057S00`0F?P01@00SB400`00n3/008d5002=1@03002=1@03003h2@0FS@005Xd0
00<05Xd00P0Wn00403:=00<0F?P00`1>S@0407kS02L0Zn<00`0HV00202Oh00@0=YP00`1Hn00505BH
0080ROP01P1bV00O0;[g00H0f><01@0iXP0205Sh00H0FJ800P29n00607VR0080^_L01P2IXP0R0>_g
00H0GZX00P29n00607nZ00<0^_L01P2QZP020>_g00H0ZY402P3gdP0O0>>D00030;[g002X/@00Z;40
00@0Z;400`3[m`070;6G0080mm801`2aM00R0?NQ0080[[P00`3[m`070;RL00<0mm80202hN0090?NQ
00@0hfL01`2h;`0R0?Lo00<0mj401`2mEP080>AW01X0mg000`3gdP070<9o00<0mj402@32F0030?M`
00P0`S807`3g?`070>@=00@0aeX03`3gL0060<L<00d0i0d05P3f3P0f0?ooo`00@P3oool206IVIPP0
oooo0P1c01H00`3j0340L`0]07<0;@050?X0H`80L`1K00@0IVIV07<0LP1c0780L`1b0P3i0?L205d0
L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0IVIV00<001Ac00@0
02ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<20030n@<0071c0P00lOP2001cH003003h
c`1VIVH007=9008007=90P00n9d3001c<P800?Q/0`00La/00`00n3/007<4001c1002001c10800?P9
0P0BL`0702CS000306IVIP0Th`009><000@09><000D0000002CS000Th`009><00000000202CS0005
0000000Th`009oP002Oh00000000300Wn0000`00PE800?RM000000040021>003003hK000PAh0084N
0080084N0P00n3/300211@800?P9100DP@0202Oh000302j1001Ah`00DN<001l0DN<01P1Hn005002=
8@03003h>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0202Oh00@0<Xd00`1Hn00204j=
00@0O^<0:02[h`0301RH00809oP0100fV00305Sh00D0E9P00P29n00607:H02<0^_L000<09oP003VR
000iXP00100iXP0205Sh00H0FJ800P29n00607VR0080^_L01P2IXP0R0>_g00H0GZX00P29n00607nZ
00<0^_L01P2QZP020>_g00H0ZY404@3gdP0G0>>D0080^_L01P2X/@030>_g00L0/IL00P3gdP070;5d
0280mj400P2^^0030>_g00L0^9`0103gdP070;Qh00d0mj401`2h;`0S0?Lo0080mj401P2mEP0@0>AW
01<0mg000`3gdP070<9o00<0mj402@32F0030?M`00P0`S808@3g?`090<MJ00l0mg001@37300D0>@=
0100mPh0=P3oool00480oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]00D0
nP1S0P1c05/0101VIVH0L`1b07<0LP1c07820?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T3
01T0L`0503H0n@0207<00P1c06IVIP040?T00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c
0P00SoT3001IL`800<3i0`00L7<01P00lOP007=P001cH000Lf00IVIV003hc`<007=90P00n9d3001c
<P800?Q/0`00La/00`00n3/007<4001c1002001c10800?P900<04W<002CS000Th`001@0Th`000`1V
IVH09><002CS000502CS00050000000Th`009><002CS000000000P0Th`001@0000009><002CS000T
h`00000000@09><0200Wn0000`00PE800?RM000000030021>0800?Q/1000PAh2003h>`<008450P00
n0T401B100809oP09`1Ah`000`00n6`008dQ002=8@03002=8@03003h>`00S@D008d500<008d500<0
0?P901J=000FS@000`0FS@0202Oh00@0<Xd00`1Hn00204j=00X0O^<08@2[h`0401RH000302Oh000f
V000=YP000<0=YP00`1Hn00505BH0080ROP01P1bV00S0;[g000302Oh000iXP00>J8000@0>J800P1H
n00605VR0080ROP01P1iXP020;[g00H0VJ808P3[m`0605jZ0080ROP01P1oZP030;[g00H0XJX00P3[
m`060:ZA01P0mm803`3SU0030;[g00H0Z;400`3[m`070;6G0080mm801`2aM00R0?NQ0080[[P00`3[
m`070;RL00@0mm801`2hN00=0?NQ00L0^2l08`3g?`020?NQ00D0_EH05`3TI`0=0?M`00<0mm801`32
O`040?NQ00P0`UP00`3gL0080<8b0240mcl02@37FP0?0?M`00@0a``06P3T3@0;0?H>03H0oooo0012
0?ooo`@0IVIV1P3oool207<05P030?X0<@1c02d0L`0]00D0nP1S00<0L`1K06IVIP3i0<D00`1c0782
0?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T301T0L`0503H0n@0207<0IVIV0080L`040?T0
0`0057<01000;?T002]c000[L`00:g<2001Mn@80049c0P00SoT3001IL`800<3i0P00L7<2003an080
07=P00<0IVIV003hc`00n<l00`00LdT2003hW@<007<b0P00n6`3001c6`03003h>`00L`@007<40080
07<40P00n0T00`0BL`009><002CS000502CS000306IVIP0Th`009><000H09><00`00000302CS0005
0000000Th`009><002CS000000002`0Th`020021DP03003hW@000000084h0080084h0P00n6`40021
7P800?Pk0`00P@D2003h2@@0584000<09oP0057S001Ah`009P1Ah`000`00n6`008dQ002=8@03002=
8@03003h>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0202Oh00@0<Xd00`1Hn0000`1>
S@00O^<007kS000?07kS01X0Zn<01@0HV0000`0Wn000=YP003JH000303JH00<0F?P01@1DV00208Wh
00H0LYP08`2jm`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh00H0NJ800P2jm`0609VR
0280joL01P1NZP0208Wh00H0OjX00`2jm`060:6Z0080joL01P2ZT@0O0?OB00L0hi@000@0QK400;[g
002jm`00^_L01P2X/@030>_g00L0/IL00P3gdP070;5d0280mj400P2^^0030>_g00L0^9`0103gdP07
0;Qh00d0mj401`2h;`0S0?Lo0080mj40102mEP0O0>AW00H0mg000`3gdP070<9o00@0mj402032F003
0?M`00P0`S808@3g?`090<MJ00l0mg000`37300Q0>@=00D0mPh0=P3oool00480oooo00@0IVIV0?oo
o`3oool0oooo1P1VIVH207<05P030?X0<@1c02d0L`0]00D0nP1S00<0L`1K06IVIP3i0<D00`1c0782
0?T0m`80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T301T0L`800P1c00<0IVIV0080L`040?T00`00
57<01000;?T002]c000[L`00:g<2001Mn@80049c0P00SoT3001IL`800<3i0P00L7<2003an08007=P
00<0IVIV003hc`00n<l00`00LdT2003hW@<007<b0P00n6`3001c6`03003h>`00L`@007<4008007<4
0P00n0T702CS000306IVIP0Th`009><000H09><000D0000002CS000Th`009><00000000202CS0005
0000000Th`009><002CS000000002`0Th`020021DP03003hW@000000084h0080084h0P00n6`40021
7P800?Pk0`00P@D2003h2@@058401`0Wn00Q057S00800?Q/1@00SB400`00n3/008d5002=1@03002=
1@03003h2@0FS@005Xd000<05Xd00P0Wn00403:=00<0F?P0601nh`0D0:_S00D069P000<09oP003JH
000fV0000`0fV00305Sh00D0E9P00P29n00607:H02<0^_L000<09oP003VR000iXP00100iXP0205Sh
00H0FJ800P29n00607VR0080^_L01P2IXP0R0>_g00H0GZX00P29n00607nZ00<0^_L01P2QZP020>_g
00H0ZY408`3gdP0408Fa00<0^_L01P2X/@030>_g00L0/IL00P3gdP070;5d0280mj400P2^^0030>_g
00L0^9`0103gdP070;Qh00d0mj401`2h;`0S0?Lo0080mj400`2mEP0V0>AW00<0mm801`32O`040?NQ
00P0`UP00`3gL0080<8b0240mcl02@37FP0?0?M`0080a``09`3T3@0f0?ooo`00@P3oool00`1VIVH0
oooo0?ooo`070?ooo`80L`0F00<0nP0a07<0;@1c02d01@3j06<00`1VIVH0L`1K0?T0a@0307<0LP80
n@3g0P1M07<00`3:0?T0A`1c04L0L`0609T0n@<06@1c00D00P1c06IVIP0207<00P1c00@0n@03000D
L`04000/n@00:g<002]c000[L`8005gi0P00@W<2002?n@<005Uc0P00`?T2001`L`800?7h00@007=P
06IVIP00Lf000?S?1000LdT2003hW@<007<b0P00n6`3001c6`03003h>`00L`@007<4008007<400<0
0?P902CS000Th`001P0Th`000`1VIVH09><002CS000602CS00050000000Th`009><002CS00000000
0P0Th`001@0000009><002CS000Th`00000000X09><00`00PE84000000030021>000n6`00?Q/00<0
084N0`00n3/300211@800?P9100DP@0=02Oh01/0DN<00P00n6`5002=8@03003h>`00S@D008d500<0
08d500<00?P901J=000FS@000`0FS@0202Oh00@0<Xd00P1Hn00O07kS00d0Zn<000<00?P901RH000H
V0000`0HV0000`0Wn000=YP003JH000303JH00<0F?P01@1DV00208Wh00H0LYP08`2jm`000`0Wn000
>J8003VR000403VR0080F?P01P1IXP0208Wh00H0NJ800P2jm`0609VR0280joL01P1NZP0208Wh00H0
OjX00`2jm`060:6Z0080joL01P2ZT@0S0?OB00@0QK400`2jm`060:Ra00<0joL01`2aU`020?OB00L0
/G@08P3gX@020:jh00<0joL0202hW0030?OB00L0^7P03@3gX@070;P_02<0mcl00P3gX@020;eF02H0
i6L000@0`ZH00?OB003gdP00mm801`32O`040?NQ00P0`UP0103gL0070<8b0240mcl02@37FP0?0?M`
02P0i0d0=`3oool00480oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]00D0
nP1S00<0IVIV07<0F`3i0<D00`1c07801@3i0?L0G@1c05d0L`1M07<0bP3i0080A`1c1P2I0?T301T0
L`050080L`1VIVH00P1c0080L`040?T00`0057<01000;?T002]c000[L`00:g<2001Mn@80049c0P00
SoT3001IL`800<3i0P00L7<2003an004001cH01VIVH007=P003hc`@007=900<00?RM001c<P00Lc80
0P00Lc800`00n6`007<K001c6`02001c6`03003h>`00L`@007<4008007<42000n0T00`1VIVH09><0
02CS000702CS00050000000Th`009><002CS000000000P0Th`001@0000009><002CS000Th`000000
00T09><01000PE8010000000084h0021>000PCP400000080084N0`00n3/300211@800?P9100DP@0C
02Oh01@0DN<000<008dm003hK000n6`01@00SB400`00n3/008d5002=1@03002=1@03003h2@0FS@00
5Xd000<05Xd000<09oP003:=000bS@000`0bS@0905Sh01h0O^<01P2[h`02003h2@D069P000<09oP0
03JH000fV0000`0fV00305Sh00D0E9P00P29n00607:H02<0^_L000<09oP003VR000iXP00100iXP02
05Sh00H0FJ800P29n00607VR0080^_L01P2IXP0R0>_g00H0GZX00P29n00607nZ00<0^_L01P2QZP02
0>_g00H0ZY408`3gdP0408Fa00<0^_L01P2X/@030>_g00L0/IL00P3gdP060;5d00P0hi@06`3gX@02
0:jh00<0joL0202hW0030?OB00L0^7P03@3gX@070;P_02<0mcl00P3gX@0W0>AW0080`ZH00`3gdP07
0<9o00@0mj402032F0040?M`00L0`S808@3g?`000`3gX@00aeX00<MJ00060<MJ01D0mg008@3T3@0h
0?ooo`00@P3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F0`1c02d40?X0H`0406IVIP1c05/0L`1K
0?T0a@<0L`1b00D0n@3g05d0L`1M07<0G@1c0<X0n@0204L0L`D0V@3i100I07<01@1VIVH00P1c0080
L`0207<0103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`8008oi0`00FG<01000`?T0
071c001`L`00L7<2003an00406IVIP00Lf0007=P003hc`@007=900<00?RM001c<P00Lc800P00Lc80
0`00n6`007<K001c6`02001c6`04003h>`00L`@007<4001c10P00?P900<0IVIV003h2@00n0T01@00
n0T402CS00<00000100Th`03000000X09><01000PE800`000000084h0021>0020021>0800?Q/0`00
PAh3003h>`<008450P00n0T401B101T09oP03P1Ah`000`00SCd00?Q/003hK005002=8@03003h>`00
S@D008d500<008d500<00?P901J=000FS@000`0FS@000`0Wn000<Xd003:=000303:=0100F?P0601n
h`05002H1P800?P91@0HV0000`0Wn000=YP003JH000303JH00<0F?P01@1DV00208Wh00H0LYP08`2j
m`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh00H0NJ800P2jm`0609VR0280joL01P1N
ZP0208Wh00H0OjX00`2jm`060:6Z0080joL01P2ZT@0S0?OB00@0QK400`2jm`060:Ra00<0joL01`2a
U`020?OB00D0/G@0403SU00D0?NQ0080[[P00`3[m`080;RL00<0mm801`2hN00=0?NQ00L0^2l08`3g
?`090?NQ01l0i6L00`32YP030?OB00L0`Wl0103gX@080<9H00@0mg001`32<P0Q0?Lo00030?NQ0037
FP00aeX000H0aeX06P3gL00K0>@=03T0oooo00120?ooo`0306IVIP3oool0oooo00L0oooo00<0L`0F
0?X0<@1c02d00P1c02d40?X0H`0406IVIP1c05/0L`1K0?T0a@<0L`1b00D0n@3g05d0L`1M07<0G@1c
0<X0n@0204L0L`D0V@3i100I07<01@1VIVH00P1c0080L`0207<0103i00<001Ac00D002ci000[L`00
:g<002]c001Mn@030012L`8008oi0`00FG<01000`?T0071c001`L`00L7<2003an00406IVIP00Lf00
07=P003hc`@007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`04003h>`00
L`@007<4001c10P00><900<0IVIV003h2@00n0T03000n0T@02CS0003003hc`00PE80085B0080085B
00<000000021>000PCP00P00PCP2003hK0<0084N0P00n3/400211@800?P9100DP@0O02Oh00L0DN<0
0P00SCd2003hK0D008dQ00<00?Pk002=1@00S@D00`00S@D00`00n0T05Xd001J=000301J=000302Oh
000bS@00<Xd000<0<Xd05`1Hn00@07kS0003003h>`00V0H009P600<009P60P00n0T501RH000302Oh
000fV000=YP000<0=YP00`1Hn00505BH0080ROP01P1bV00S0;[g000302Oh000iXP00>J8000@0>J80
0P1Hn00605VR0080ROP01P1iXP020;[g00H0VJ808P3[m`0605jZ0080ROP01P1oZP030;[g00H0XJX0
0P3[m`060:ZA02<0mm801025/@030;[g00H0Z;400`3[m`070;6G0080mm80102aM00H0>>D00d0mj40
0P2^^0030>_g00P0^9`00`3gdP070;Qh00d0mj401`2h;`0S0?Lo0100mj405`3TI`040<:V00<0mm80
2032O`030?NQ00P0`UP0103gL0070<8b0240mcl000<0mj400<MJ0037FP001P37FP0P0?M`01@0i0d0
>P3oool00480oooo00<0IVIV0?ooo`3oool01`3oool00`1c01H0nP0a07<0;@0207<0;@<0nP1S00D0
IVIV07<0F`1c05/0L`1K0?T0a@0307<0LP050?T0m`1M07<0G@1c05d0L`3:0?T00P1707<509T0n@<0
6@1c00<0IVIV0080L`0207<00P0207<01@040?T001Ac000DL`0057<002ci00<002]c00@005gi0012
L`00@W<0049c0P00SoT2001IL`800<3i0`00L7<00`00lOP0IVIV001cH002001cH003003hc`00LdT0
07=9008007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`03003h>`00L`@0
07<400P00><900<0IVIV003S2@00h`T01@00h`T?003h2@P09><00P00n<l40021DP0300000000PCP0
084h0080084h0P00n6`300217P800?Pk1000P@D2003h2@@05840900Wn004002=?@800?Q/1@00SB40
0`00n3/008d5002=1@03002=1@03003h2@0FS@005Xd000<05Xd000<09oP003:=000bS@000`0bS@0N
05Sh00P0O^<00P00n3/5002H1P800?P91@0HV0000`0Wn000=YP003JH000303JH00<0F?P01@1DV002
08Wh00H0LYP08`2jm`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh00H0NJ800P2jm`06
09VR0280joL01P1NZP0208Wh00H0OjX00`2jm`060:6Z0080joL01P2ZT@070>?101`0mm801025/@03
0;[g00H0Z;400`3[m`070;6G0080mm800`2aM00P0>>D00H0mj400P2^^0030>_g00P0^9`00`3gdP07
0;Qh00d0mj401`2h;`0S0?Lo01H0mj40403TI`050<:V00<0mm802032O`030?NQ00P0`UP0103gL007
0<8b0280mcl02037FP0P0?M`00D0oooo3P3T3@0k0?ooo`00@P3oool00`1VIVH0oooo0?ooo`070?oo
o`0307<05P3j0340L`0]0080L`0]0`3j06<01@1VIVH0L`1K07<0F`1c05/0n@3500<0L`1b00D0n@3g
05d0L`1M07<0G@1c0<X0n@0204L0L`D0V@3i0`0I07<00`1VIVH00P1c0080L`020080L`@001Ac1000
:g<01000GOT0049c0012L`00@W<2002?n@8005Uc0P00`?T3001`L`03003an01VIVH007=P008007=P
00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K008007<K
00<00?Pk001c1000L`@02000h`T00`1VIVH00><9003S2@0<003S2@l00?P900<0085[003hc`00n<l0
0`00PE800`00n9d000000021>0030021>0800?Q/0`00PAh2003h>`@008450P00n0T401B102@09oP0
1000SCd2003hK0@008dQ0P00n3/5002=1@03003h2@0FS@005Xd000<05Xd000<09oP003:=000bS@00
0`0bS@0S05Sh00<009PT0P00n3/5002H1P800?P91@0HV0000`0Wn000=YP003JH000303JH00<0F?P0
1@1DV00208Wh00H0LYP08`2jm`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh00H0NJ80
0P2jm`0609VR0280joL01P1NZP0208Wh00H0OjX00`2jm`060:6Z0080joL01@2ZT@0?0>?101D0mm80
1025/@030;[g00H0Z;400`3[m`070;6G0080mm800P2aM00W0>>D00<0[[P00P3[m`080;RL00<0mm80
1`2hN00=0?NQ00L0^2l08`3g?`0M0?NQ00P0i6L01P32YP030?OB00P0`Wl00`3gX@070<9H00D0hfL0
1`32<P0R0?Lo00P0aeX0803gL00;0?ooo`L0i0d0?03oool00480oooo00<0IVIV0?ooo`3oool01`3o
ool00`1c01H0nP0a07<0;@0207<0;@80nP1S00<0IVIV0?X0H`1c05/00P1c05/407<0LP040?T0m`1M
07<0G@1c05d0L`<0A`1c1@2I0?T201T0L`0306IVIP0f0?T00P1c00<00P1c100057<4000[L`04001M
n@00@W<0049c0012L`8008oi0P00FG<20030n@<0071c00<0IVIV003an000Lf000P00Lf000`00n<l0
07=9001cB@02001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c6`00La/00P00La/00`00n3/0
07<4003S2@07003S2@0306IVIP00h`T00><901@00><92000n0T00`00PF/00?S?003hc`030021DP03
003hW@000000084h00<0084h0P00n6`300217P800?Pk1000P@D2003h2@<058409@0Wn004002=?@80
0?Q/1000SB42003h>`D008d500<00?P901J=000FS@000`0FS@000`0Wn000<Xd003:=000303:=02<0
F?P00`00V2@2003h>`D009P60P00n0T501RH000302Oh000fV000=YP000<0=YP00`1Hn00505BH0080
ROP01P1bV00S0;[g000302Oh000iXP00>J8000@0>J800P1Hn00605VR0080ROP01P1iXP020;[g00D0
VJ808`3[m`0605jZ0080ROP01P1oZP030;[g00H0XJX00P3[m`040:ZA01L0hl403P3gdP0408Fa00<0
^_L01P2X/@030>_g00L0/IL00P3gdP000`2aM000hi@00>>D000U0>>D00@0[[P00`3[m`070;RL00<0
mm801`2hN00=0?NQ00L0^2l08`3g?`0P0?NQ00<0joL02032YP030?OB00P0`Wl00`3gX@060<9H00H0
hfL01`32<P0R0?Lo00P0aeX0803gL01>0?ooo`00@@3oool00`1VIVH0oooo0?ooo`080?ooo`0307<0
5P3j0340L`0]0080L`0]0P3j06<00`1VIVH0nP1S07<0F`0207<0F`@0L`1b00@0n@3g05d0L`1M07<0
G@1c0`1707<509T0n@806@1c00<0IVIV03H0n@0207<00P0207<00`040?T001Ac000DL`02000DL`@0
02]c00@005gi0012L`00@W<0049c0P00SoT2001IL`800<3i0P00L7<00`1VIVH00?7h003an002001c
H0800?S?1000LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K008007<K00<00?Pk001c
1000h`T01`00h`T00`1VIVH00><9003S2@0K003S2@80085[0P00n<l30021DP03003hW@000000084h
00<0084h00<00?Q/00217P00PAh00P00PAh2003h>`@008450P00n0T301B100P08n<07@0Wn004002=
?@800?Q/1000SB42003h>`D008d500<00?P901J=000FS@000`0FS@000`0Wn000<Xd003:=000303:=
02<0F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0fV00305Sh00@0E9P00`29n00607:H
02<0^_L000<09oP003VR000iXP00100iXP0205Sh00H0FJ800P29n00607VR0080^_L01@2IXP060=OR
01d0joL01P1NZP0208Wh00H0OjX00`2jm`060:6Z0080joL00`2ZT@0O0>?100L0mm801025/@030;[g
00L0Z;400P3[m`070;6G0080mm809`3SU0050:jh00<0joL01`2hW0030?OB00L0^7P03@3gX@070;P_
02<0mcl0803gX@030>_g00P0`ZH00`3gdP080<9o00<0mj401@32F0070>=W00P0`S808@3g?`090<MJ
01l0mg00CP3oool00440oooo00<0IVIV0?ooo`3oool01`3oool207<05P030?X0<@1c02d0L`0]0080
nP1S00<0IVIV0?X0H`3j06<00`1c05/307<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<509T0
n@0401T0L`1VIVH06@1c03H0n@<00P1c00<0103i000DL`0057<00P0057<4000[L`05001Mn@00@W<0
049c0012L`00SoT00`00FG<20030n@80071c00<0IVIV003an000lOP00P00Lf02003hc`@007=900<0
0?RM001c<P00Lc800P00Lc801000n6`007<K001c6`00La/2003h>`P00><900<0IVIV003S2@00h`T0
7000h`T20021J`800?S?0`00PE800`00n9d000000021>0030021>003003hK000PAh0084N0080084N
0P00n3/400211@800?P90P0DP@0@02?S01H09oP01000SCd2003hK0@008dQ0P00n3/5002=1@03003h
2@0FS@005Xd000<05Xd000<09oP003:=000bS@000`0bS@0S05Sh00<009PT0P00n3/5002H1P800?P9
100HV00202Oh00D0=YP00`1Hn00405BH00<0ON<01P1bV00S0;[g000302Oh000iXP00>J8000@0>J80
0P1Hn00605VR0080ROP01P1iXP020;[g00@0VJ803@3GhP0G0>_g00H0GZX00P29n00607nZ00<0^_L0
1P2QZP020>_g0080ZY409`3S`@0408Fa00<0^_L01`2X/@020>_g00L0/IL02@3gdP0O0>>D00H0[[P0
0`3[m`070;RL00<0mm801`2hN00=0?NQ00L0^2l08`3g?`0P0?NQ00<0joL02032YP030?OB00P0`Wl0
0`3gX@040<9H00P0hfL02032<P0Q0?Lo00T0aeX07`3gL01>0?ooo`00@@3oool00`1VIVH0oooo0?oo
o`070?ooo`80L`0F00<0nP0a07<0;@1c02d00P3j06<00`1VIVH0nP1S0?X0H`0307<0F`<0L`1b0P3i
0?L205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i00@06@1c06IVIP0I07<0=P3i0`0207<01@040?T0
01Ac000DL`0057<002ci00@002]c00D005gi0012L`00@W<0049c002?n@03001IL`800<3i00<0071c
06IVIP00L7<00P00lOP2001cH0800?S?0`00LdT2003hW@<007<b0P00n6`3001c6`03003h>`00h`T0
0><900H00><900<0IVIV003S2@00h`T07000h`T30021J`800?S?0`00PE800`00n9d000000021>003
0021>003003hK000PAh0084N0080084N0P00n3/400211@800?P900<0584002?S000Sh`005P0Sh`0?
02Oh00@008dm0P00n6`4002=8@800?Pk1@00S@D00`00n0T05Xd001J=000201J=00809oP01@0bS@0S
05Sh00<009PT0P00n3/5002H1P800?P9100HV00202Oh00D0=YP00`1Hn00305BH00@0ON<01P1bV00S
0;[g000302Oh000iXP00>J8000@0>J800P1Hn00605VR0080ROP01P1iXP020;[g00<0VJ80503GhP0A
0>_g00H0GZX00P29n00607nZ00<0^_L01P2QZP020>_g00030:ZA003S`@00hl4002D0hl401P25/@02
0;[g00L0Z;400P3[m`070;6G0100mm805`3SU0070:jh00<0joL01`2hW0030?OB00L0^7P03@3gX@06
0;P_00L0hSX07@3g?`0P0?NQ00<0joL02032YP040?OB00L0`Wl00`3gX@030<9H00T0hfL02032<P0Q
0?Lo00T0aeX07`3gL01>0?ooo`00@@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00D0nP0a07<0
;@1c02d0nP1S06IVIP030?X0H`80L`1K00@0n@3507<0LP1c0780L`1b0P3i0?L205d0L`040<X0n@17
07<0A`1c04L0L`D0V@3i00@0IVIV01T0L`0I07<0=P3i0`0207<01@040?T001Ac000DL`0057<002ci
00<002]c0P00GOT20012L`8008oi0`00FG<20030n@03001`L`1VIVH0071c00800?7h0P00Lf02003h
c`<007=90P00n9d3001c<P800?Q/0`00La/9003h>`0306IVIP00h`T00><901`00><90`00PF/2003h
c`<0085B00<00?RM00000000PCP00`00PCP00`00n6`0084N00217P0200217P800?Pk1000P@D2003h
2@0301B1000Sh`008n<001d08n<0200Wn004002=?@800?Q/1000SB42003h>`D008d500<00?P901J=
000FS@000P0FS@0202Oh00D0<Xd08`1Hn003002H90800?Pk1@00V0H2003h2@@069P00P0Wn00503JH
00<0F?P00P1DV00507gS00H0LYP08`2jm`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh
00H0NJ800P2jm`0209VR01/0en802`3[m`0605jZ0080ROP01P1oZP030;[g00H0XJX00P3[m`0W0>?1
00L0QK400`2jm`060:Ra0080joL01`2aU`0G0?OB00l0hi@000<0^_L00:jh002^^0001@2^^0030>_g
00L0^9`00`3gdP070;Qh00d0mj401@2h;`0>0>8j01L0mcl0803gX@030>_g00P0`ZH0103gdP070<9o
00<0mj400P32F00:0>=W00P0`S808@3g?`090<MJ01l0mg00CP3oool00440oooo00<0IVIV0?ooo`3o
ool01`3oool207<05P050?X0<@1c02d0L`0]0?X0H`1VIVH00`3j06<207<0F`040?T0a@1c0780L`1b
07<0LP80n@3g0P1M07<0103:0?T0A`1c04L0L`1707<409T0n@0506IVIP0I07<06@1c01T0L`0f0?T0
0`0207<01@040?T001Ac000DL`0057<002ci00<002]c0P00GOT20012L`8008oi0`00FG<20030n@03
06IVIP00L7<0071c00800?7h0P00Lf02003hc`<007=90P00n9d3001c<P800?Q/0`00La/8003h>`03
06IVIP00n3/00?Pk00D00?Pk5`00h`T40021J`03003hc`00PE80085B0080085B00<00?RM00000000
PCP00`00PCP00`00n6`0084N00217P0200217P800?Pk1000P@D2003h2BL08n<000<00?RM002=?@00
SCd00P00SCd2003hK0@008dQ0P00n3/5002=1@03003h2@0FS@005Xd000805Xd00P0Wn00503:=02<0
F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0fV00305Sh0080E9P01@1mh`0507:H02@0
^_L000<09oP003VR000iXP00100iXP0205Sh00H0FJ800P29n00607VR0080^_L000<0VJ800=OR003G
hP00803GhP050>_g00H0GZX00P29n00607nZ00<0^_L01P2QZP090>_g01l0hl4000<0ROP008Fa0025
/@001@25/@030;[g00H0Z;400P3[m`070;6G01h0mm801`3SU0020;[g00L0[[P00`3[m`070;RL00<0
mm801`2hN00=0?NQ00@0^2l05@3R>P0A0?Lo0200mj400`3[m`080<:V00@0mm801`32O`030?NQ00`0
hfL02032<P0Q0?Lo00T0aeX07`3gL01>0?ooo`00@@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F
00@0nP0a07<0;@1c02d0IVIV103j06<207<0F`040?T0a@1c0780L`1b07<0LP80n@3g0P1M07<0103:
0?T0A`1c04L0L`1707<409T0n@0506IVIP0I07<06@1c01T0L`0f0?T00`0207<01@040?T001Ac000D
L`0057<002ci00<002]c0P00GOT20012L`8008oi0`00FG<20030n@0406IVIP00L7<00?7h003an0<0
07=P0P00n<l3001cB@800?RM0`00Lc82003hK0<007<K2000n3/00`1VIVH00?Pk003h>`0<003h>a00
0><91000PF/00`00n<l0085B0021DP020021DP03003hW@000000084h00<0084h00<00?Q/00217P00
PAh00P00PAh2003h>`@0084500<00?P902?S000Sh`009P0Sh`000`00n9d008dm002=?@02002=?@03
003hK000SB4008dQ00<008dQ0P00n3/5002=1@03003h2@0FS@005Xd000805Xd00P0Wn00503:=02<0
F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0fV00305Sh000305BH001mh`00ON<000@0
ON<01@1bV0060:[R01h0^_L000<09oP003VR000iXP00100iXP0205Sh00H0FJ800P29n00607VR0080
^_L0:03GhP0605jZ0080ROP01P1oZP030;[g00H0XJX0403[m`0G0>?10080ROP01`25/@030;[g00H0
Z;400P3[m`070;6G0240mm800`2:^0030;[g00L0[[P00`3[m`070;RL00<0mm801`2hN00=0?NQ00<0
^2l0703R>P0;0?Lo0200mj400`3[m`080<:V00@0mm801`32O`090?NQ00H0hfL02032<P0Q0?Lo00T0
aeX07`3gL01>0?ooo`00@@3oool00`1VIVH0oooo0?ooo`070?ooo`80L`0F00@0nP0a07<0;@1c02d0
IVIV103j06<207<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0409T0
n@0306IVIP2I0?T06@1c00806@1c100207<01@040?T001Ac000DL`0057<002ci00<002]c0P00GOT2
0012L`8008oi0`00FG<01000`?T0IVIV001`L`00L7<2003an0<007=P0P00n<l3001cB@800?RM0`00
Lc82003hK0<007<K1`00n3/00`1VIVH00?Pk003h>`0D003h>`P00><900<00?7h0021J`00PF/00P00
PF/00`00n<l0085B0021DP020021DP03003hW@000000084h00<0084h00<00?Q/00217P00PAh00P00
PAh2003h>`@008451`00n0TQ02?S00800?RM1000SCd00`00n6`008dQ002=8@03002=8@800?Pk1000
S@D2003h2@@05Xd00P0Wn00503:=02<0F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0f
V00305Sh00L0ON<0101bV00=0:[R01P0^_L000<09oP003VR000iXP00100iXP0205Sh00H0FJ800P29
n00607VR00030;[g003GhP00en8002L0en801P1NZP0208Wh00H0OjX00`2jm`060:6Z01L0joL03`3S
`@000`1R/@00ROP008Wh000708Fa00<0^_L01P2X/@020>_g00L0/IL08@3gdP0308Zh00<0^_L01`2^
^0030>_g00L0^9`00`3gdP060;Qh00L0hi@01`3gX@020;P_02<0hSX01@3g?`0P0?NQ00<0joL02032
YP040?OB00L0`Wl03P3gX@000`3SI`00`S800<8b00060<8b0240mcl02@37FP0O0?M`04h0oooo0011
0?ooo`0306IVIP3oool0oooo00L0oooo0P1c01H207<0;@0306IVIP3j06<0nP1S00<0nP1S0P1c05/0
1@3i0<D0L`1b07<0LP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<0102I0?T00`1VIVH0V@3i01T0
L`0201T0L`@00P1c00D0103i000DL`0057<001Ac000/n@03000[L`8005gi0P00@W<2002?n@<005Uc
00@0IVIV0030n@00L7<0071c0P00lOP3001cH0800?S?0`00LdT2003hW@<007<b0P00n6`3001c6`H0
0?Pk00<0IVIV003h>`00n3/06P00n3/3001mP@03003an000PF/0085[0080085[00<00?S?0021DP00
PE800P00PE800`00n9d000000021>0030021>003003hK000PAh0084N0080084N0P00n3/400211@d0
0?P96P0Sh`000`00SET00?RM003hW@03002=?@800?Q/1@00SB42003h>`@008d50P00n0T401J=0080
9oP01@0bS@0S05Sh00<009PT0P00n3/5002H1P800?P9100HV00202Oh00D0=YP00P1Hn00807gS00<0
LYP0502ZhP0B0;[g000302Oh000iXP00>J8000@0>J800P1Hn00605VR0080ROP01P1iXP070;[g0280
en8000<0F?P005jZ001NZP00101NZP0208Wh00H0OjX00`2jm`060:6Z01h0joL01`3S`@0206:a0080
ROP01`25/@030;[g00H0Z;400P3[m`070;6G0240mm800`2:^0030;[g00L0[[P00`3[m`070;RL00<0
mm801@2hN00=0>>D0080mj4000<0^2l00>8j003R>P009`3R>P0Q0?NQ0080joL02@32YP030?OB00L0
`Wl0403gX@070<8b0240mcl000<0mj400<MJ0037FP001P37FP0P0?M`04d0oooo00110?ooo`0306IV
IP3oool0oooo00L0oooo00D0L`0F0?X0<@1c02d0IVIV07<0;@050?X0H`80L`1K00D0n@3507<0LP1c
0780L`1b0?T0m`0305d0L`030<X0n@1707<0A`1c00<0V@3i00<0IVIV09T0n@0I07<00`0I07<40080
L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@80049c0P00SoT3001IL`0406IVIP00`?T0
071c001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@800?RM0`00Lc82003hK0<007<K1P00
n3/00`1VIVH00?Pk003h>`0J003h>`<007f100<00?7h0021J`00PF/00P00PF/00`00n<l0085B0021
DP020021DP03003hW@000000084h00<0084h00<00?Q/00217P00PAh00P00PAh2003h>`<008455000
n0TD02?S0003002=F@00n9d00?RM00<008dm0P00n6`5002=8@800?Pk1000S@D2003h2@@05Xd00P0W
n00503:=02<0F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0fV00805Sh0080ON<00P1b
V00K0:[R00`0^_L000<09oP003VR000iXP00100iXP0205Sh00H0FJ800P29n00607VR00d0^_L06`3G
hP0205Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g00D0H[400P29n00708Fa00<0^_L01P2X
/@020>_g00L0/IL08@3gdP0308Zh00<0^_L01`2^^0030>_g00L0^9`00`3gdP040;Qh0100hi@0:@3R
>P000`2mO000mj400?NQ000O0?NQ0080joL02@32YP030?OB00L0`Wl0403gX@070<8b0240mcl000<0
mj400<MJ0037FP001P37FP0P0?M`04d0oooo00110?ooo`0306IVIP3oool0oooo00L0oooo00D0L`0F
0?X0<@1c02d0IVIV07<0;@040?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`030<X0
n@1707<0A`1c00<0V@3i00<0IVIV09T0n@0I07<00`0I07<40080L`0500@0n@0057<001Ac000DL`00
;?T00`00:g<01000GOT0049c0012L`00@W<2002?n@8005Uc00<0IVIV0030n@00`?T00P00L7<2003a
n0<007=P00<00?S?001cB@00LdT00P00LdT00`00n9d007<b001c<P02001c<P03003hK000La/007<K
008007<K1@00n3/00`1VIVH00?Pk003h>`0K003h>`<007f100<00?7h0021J`00PF/00P00PF/00`00
n<l0085B0021DP020021DP03003hW@000000084h0080084h0P00n6`400217P800?Pk0`00P@D6003S
2A@00?P93@0Sh`02002=F@800?RM0`00SCd2003hK0D008dQ0P00n3/4002=1@03003h2@0FS@005Xd0
00<05Xd00P0Wn00503:=02<0F?P00`00V2@2003h>`D009P60P00n0T401RH00809oP01@0fV00:05Sh
000307:H002ZhP00Z^800200Z^801P2jm`000`0Wn000>J8003VR000403VR0080F?P01P1IXP0208Wh
00H0NJ804`2jm`0D0=OR00<0F?P01P1NZP0208Wh00H0OjX00`2jm`060:6Z0280joL01@1R/@0208Wh
00L0QK400`2jm`060:Ra0080joL01`2aU`0Q0?OB00<0R[P00`2jm`070:jh00<0joL01`2hW0030?OB
00<0^7P05`3SU00R0>8j0080_G`08@3gX@020>_g00T0`ZH00`3gdP070<9o0100mj401`32<P0R0?Lo
00P0aeX0803gL01=0?ooo`00@@3oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P3j0340IVIV0080
L`0]103j06<307<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0209T0
n@0306IVIP2I0?T0V@3i00@06@1c100207<01@040?T001Ac000DL`0057<002ci00<002]c00@005gi
0012L`00@W<0049c0P00SoT2001IL`0306IVIP00`?T0071c0080071c0P00lOP3001cH003003hc`00
LdT007=9008007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`D00?Pk00<0
IVIV003h>`00n3/06`00n3/3001mP@03003an000PF/0085[0080085[00<00?S?0021DP00PE800P00
PE800`00n9d000000021>0020021>0800?Q/1000PAh2003h>`8008453@00h`TD003h2@H08n<00`00
SET2003hW@<008dm0P00n6`5002=8@800?Pk1000S@D00`00n0T05Xd001J=000301J=00809oP01@0b
S@0S05Sh00<009PT0P00n3/4002H1P<00?P9100HV00202Oh00D0=YP02P1Hn00X0:[R00809oP01P0i
XP0205Sh00D0FJ800`29n00607VR01T0^_L03@3GhP00100lZP00F?P005Sh001Hn00605jZ0080ROP0
1P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@030;[g00H0Z;400P3[m`060;6G00P0h/40
6P3gdP0308Zh00<0^_L01`2^^0030>_g00L0^9`00`3gdP020;Qh01h0hi@06`3R>P030;el0240mj40
0P3[m`090<:V00<0mm801`32O`0@0?NQ00L0`S808P3g?`080<MJ0200mg00C@3oool00400oooo00<0
IVIV0?ooo`3oool0203oool00`1c01H0nP0a06IVIP0207<0;@@0nP1S0`1c05/407<0LP050?T0m`1M
07<0G@1c05d0L`3:0?T00P1707<209T0n@0306IVIP2I0?T0V@3i00@06@1c100207<4000DL`05000/
n@00:g<002]c000[L`00GOT00`00@W<2002?n@04001IL`1VIVH00<3i0030n@<0071c0P00lOP3001c
H003003hc`00LdT007=9008007=900<00?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c
6`@00?Pk00<0IVIV003h>`00n3/07000n3/3001mP@03003an000PF/0085[0080085[00<00?S?0021
DP00PE800P00PE800`000000084h0021>0020021>0800?Q/1000PAh2003h>`8008454`00h`TB003h
2@03003hc`00SET008eI008008eI00<00?RM002=?@00SCd00P00SCd2003hK0D008dQ0P00n3/4002=
1@03003h2@0FS@005Xd000<05Xd00P0Wn00503:=02<0F?P00`00V2@2003h>`@009P60P00n0T501RH
00809oP01@0fV00905Sh02T0Z^800P0Wn00603VR0080F?P01@1IXP0307gS00H0NJ807`2jm`060=OR
0080?:X00`1Hn00605jZ0080ROP01P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@030;[g
00H0Z;400P3[m`050;6G0100h/404`3gdP0308Zh00<0^_L01`2^^0030>_g00L0^9`00`3gdP000`2h
N000hi@00>>D000R0>>D01D0hSX0102mO00Q0?NQ00<0joL02032YP030?OB00P0`Wl03`3gX@070<8b
0280mcl02037FP0P0?M`04d0oooo00100?ooo`0306IVIP3oool0oooo00P0oooo00<0L`0F06IVIP1c
02d00P1c02d40?X0H`<0L`1K101c0780103i0?L0G@1c05d0L`1M07<304L0L`0309T0n@1VIVH0V@3i
0080V@3i0`0I07<00`0f0?T00P1c0080L`020080L`@001Ac1000:g<01000GOT0049c0012L`00@W<2
002?n@04001IL`1VIVH00<3i0030n@<0071c0P00lOP3001cH003003hc`00LdT007=9008007=900<0
0?RM001c<P00Lc800P00Lc800`00n6`007<K001c6`02001c6`<00?Pk00<0IVIV003h>`00n3/07@00
n3/2001mP@800?7h1000PF/00`00n<l0085B0021DP020021DP0300000000PCP0084h0080084h0P00
n6`300217P<00?Pk00<00845003S2@00h`T06000h`T<003h2@03003hc`00SET008eI008008eI00<0
0?RM002=?@00SCd00P00SCd2003hK0D008dQ0P00n3/4002=1@03003h2@0FS@005Xd000<05Xd00P0W
n00503:=02<0F?P00`00V2@2003h>`@009P60P00n0T501RH00809oP01@0fV00?05Sh0280Z^8000<0
6J8002Oh000Wn0001P0iXP0205Sh00@0FJ80101mh`0607VR0240^_L000<09oP003bZ000lZP000`0l
ZP0305Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g00D0H[400P29n00708Fa00<0^_L01P2X
/@020>_g00@0/IL05`3R`@0=0?OB00<0R[P00`2jm`070:jh00<0joL01`2hW0030?OB02L0hi@00P2d
_@020>_g00h0hSX01@2mO00Q0?NQ00<0joL02032YP030?OB00P0`Wl03`3gX@070<8b0280mcl02037
FP0P0?M`04d0oooo00100?ooo`0306IVIP3oool0oooo00P0oooo00@0L`0F06IVIP1c02d0L`0]1@3j
06<307<0F`@0L`1b00@0n@3g05d0L`1M07<0bP3i0`1707<00`2I0?T0IVIV09T0n@0209T0n@<06@1c
00D0=P3i0080L`0207<00P1c00@0n@04000DL`@002]c00@005gi0012L`00@W<0049c0P00SoT0101V
IVH005Uc0030n@00`?T3001`L`800?7h0`00Lf000`00n<l007=9001cB@02001cB@03003hW@00Lc80
07<b008007<b00<00?Q/001c6`00La/00P00La/3003h>`0306IVIP00n3/00?Pk01d00?Pk0P00OH42
003an0@0085[00<00?S?0021DP00PE800P00PE800`000000084h0021>0020021>0800?Q/0`00PAh3
003h>`0300211@00h`T00><901h00><91P00n0T01000n<l008eI002=F@00SET2003hW@@008dm0P00
n6`5002=8@03003h>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0202Oh00D0<Xd08`1H
n003002H90800?Pk1000V0H2003h2@D069P00P0Wn00503JH01D0F?P06`2ZhP0201VR00809oP01P0i
XP0205Sh00<0FJ801@1mh`0607VR0240^_L000<09oP003bZ000lZP000`0lZP0305Sh00H0GZX00P29
n00607nZ00<0^_L01P2QZP0R0>_g00D0H[400P29n00708Fa00<0^_L01P2X/@020>_g00<0/IL07`3R
`@060?OB00<0R[P00`2jm`070:jh00<0joL01`2hW00:0?OB01l0hi@00`2d_@040>_g00@0_J401`3R
>P060;el0240mj400`3[m`080<:V00<0mm802032O`0?0?NQ00L0`S808P3g?`070<MJ00L0hfL06P3g
L01=0?ooo`00@03oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0nP0a0080L`0]1@3j06<3
07<0F`<0L`1b0P3i0?L205d0L`050<X0n@1707<0A`1c04L0L`1VIVH0102I0?T301T0L`0503H0n@02
07<00P1c0080L`040?T0100057<4000[L`04001Mn@00@W<0049c0012L`8008oi00@0IVIV001IL`00
`?T00<3i0`00L7<2003an08007=P0P00n<l4001cB@03003hW@00Lc8007<b008007<b00<00?Q/001c
6`00La/00P00La/2003h>`0306IVIP00n3/00?Pk01h00?Pk0P00OH42003an0@0085[00<00?S?0021
DP00PE800P00PE800`000000084h0021>0020021>0800?Q/0`00PAh3003h>bH00><90P00n<l3002=
F@800?RM1000SCd2003hK0D008dQ00<00?Pk002=1@00S@D00`00S@D00`00n0T05Xd001J=000301J=
00809oP0100bS@0T05Sh00<009PT0P00n3/4002H1P800?P91@0HV00202Oh00D0=YP06`1Hn00D0:[R
00<06J800P0Wn00603VR0080F?P00P1IXP0607gS00H0NJ808@2jm`000`0Wn000?:X003bZ000303bZ
00<0F?P01P1NZP0208Wh00H0OjX00`2jm`060:6Z0280joL01@1R/@0208Wh00L0QK400`2jm`060:Ra
0080joL00P2aU`0V0>;100<0R[P00`2jm`070:jh00<0joL01`2hW00A0?OB01L0hi@0102d_@040>_g
00L0_J400`3gdP070;el0240mj400`3[m`080<:V00<0mm802032O`0?0?NQ00P0`S808@3g?`060<MJ
00d0hfL05@3gL01=0?ooo`00@03oool00`1VIVH0oooo0?ooo`070?ooo`0307<05P1VIVH0nP0a0080
L`0]1@3j06<207<0F`040?T0a@1c0780L`1b07<0LP80n@3g0P1M07<01@3:0?T0A`1c04L0L`1707<0
IVIV00@0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00@001Ac1000:g<01P00GOT0049c0012
L`00@W<008oi06IVIP8005Uc0P00`?T3001`L`800?7h0P00Lf02003hc`@007=900<00?RM001c<P00
Lc800P00Lc800`00n6`007<K001c6`02001c6`800?Pk00<0IVIV003h>`00n3/07P00n3/2001mP@80
0?7h0`00PF/2003hc`@0085B00<000000021>000PCP00P00PCP2003hK0<0084N0P00n3/W003S2@80
0?S?0`00SET2003hW@@008dm0P00n6`5002=8@03003h>`00S@D008d500<008d500<00?P901J=000F
S@000`0FS@0202Oh00@0<Xd01`1@hP0M05Sh00<009PT0P00n3/4002H1P800?P91@0HV00202Oh00D0
=YP08@1Hn00=0:[R00@06J800P0Wn00603VR0080F?P000<0FJ8007gS001mh`001@1mh`0607VR0240
^_L000<09oP003bZ000lZP000`0lZP0305Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g00D0
H[400P29n00708Fa00<0^_L01P2X/@020>_g00030;6G003R`@00h/4002D0h/400`2:^0030;[g00L0
[[P00`3[m`070;RL01L0mm80403SU0050;Bm00@0joL01`2mX@030?OB00L0_G`08@3gX@030>_g00P0
`ZH00`3gdP080<9o00l0mj402032<P0Q0?Lo00D0aeX04`3SI`0@0?M`04d0oooo00100?ooo`0306IV
IP3oool0oooo00L0oooo00<0IVIV07<05P3j03400P1c02d50?X0H`80L`1K00@0n@3507<0LP1c0780
L`1b0P3i0?L205d0L`040<X0n@1707<0A`1c06IVIPD0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0
103i00<001Ac00@002ci000[L`00:g<002]c0P00GOT20012L`03002?n@1VIVH005Uc008005Uc0P00
`?T3001`L`800?7h0P00Lf02003hc`<007=90P00n9d4001c<P04003hK000La/007<K001c6`800?Pk
00<0IVIV003h>`00n3/07`00n3/2001mP@800?7h0`00PF/2003hc`<0085B00<00?RM00000000PCP0
0`00PCP2003hK0<0084N2000n3/P003S2@<00?S?0`00SET2003hW@@008dm0P00n6`5002=8@03003h
>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0202Oh00<0<Xd03`1@hP0F05Sh00<009PT
0P00n3/4002H1P800?P91@0HV00202Oh00D0=YP08`1Hn002003h>`800:861P2ZhP0501VR00809oP0
1P0iXP0205Sh00P0ON<01P1iXP0Q0;[g000302Oh000lZP00?:X000<0?:X00`1Hn00605jZ0080ROP0
1P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@030;[g00H0Z;400P3[m`0W0>;100@0R[P0
0`2jm`070:jh00<0joL01`2hW00N0?OB00P0hi@01P2d_@040>_g00L0_J400`3gdP070;el0240mj40
0`3[m`080<:V00<0mm802032O`0?0?NQ00P0`S808@3g?`040<MJ01X0hfL02P3gL01=0?ooo`00@03o
ool00`1VIVH0oooo0?ooo`070?ooo`0306IVIP1c01H0nP0a0080L`0]1@3j06<207<0F`040?T0a@1c
0780L`1b07<0LP80n@3g0P1M07<0103:0?T0A`1c06IVIP1707<509T0n@<06@1c00D0=P3i0080L`02
07<00P1c00@0n@03000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<00`00SoT0IVIV001IL`02
001IL`800<3i0`00L7<2003an08007=P0P00n<l3001cB@800>B@0`00Lc82003hK0<007<K00<00><f
06IVIP00hcH00`00hcHN003h>`8007f10P00lOP30021J`800?S?0`00PE800`00n9d000000021>003
0021>0800?Q/0`00PAh>003h>aT00><900@008ef003hc`00n<l00?S?0`00SET2003hW@@008dm0P00
n6`5002=8@03003h>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0202Oh0080<Xd05`1@
hP0?05Sh00<009PT00<00?Pk002H1P00V0H00`00V0H2003h2@D069P00P0Wn00503JH02<0F?P00P00
n3/5002R1P800?P91P0IXP0202Oh00H0>J8000<0F?P007gS001mh`001`1mh`0607VR0240^_L000<0
9oP003bZ000lZP000`0lZP0305Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g00D0H[400P29
n00708Fa00<0^_L01P2X/@090>_g01l0h/401@2:^0030;[g00L0[[P00`3[m`070;RL0240mm8000@0
S[d00;[g002jm`00^_L01`2d_@040>_g00L0_J400`3gdP070;el0240mj400`3[m`080<:V00@0mm80
1`32O`0?0?NQ00P0`S808@3g?`030<MJ0200hfL01@3gL01=0?ooo`00@03oool00`1VIVH0oooo0?oo
o`060?ooo`0406IVIP1c01H0L`0F0?X0<@80L`0]1@3j06<207<0F`040?T0a@1c0780L`1b07<0LP80
n@3g0P1M07<0103:0?T0A`1c06IVIP1707<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03
000DL`04000/n@00:g<002]c000[L`8005gi0P00@W<00`1VIVH008oi001IL`02001IL`800<3i0`00
L7<2003an08007=P0P00n<l2001cB@<00>B@0`00Lc82003SH`8007<K0P00hcH00`1VIVH00><f003S
=P08003S=QP00?Pk0P00OH42003an0<0085[0P00n<l30021DP03003hW@000000084h00<0084h0P00
n6`300217Q<00?Pk5000h`T01000SGH00?S?003hc`00n<l3002=F@800?RM1000SCd2003hK0D008dQ
00<00?Pk002=1@00S@D00`00S@D00`00n0T05Xd001J=000301J=00809oP000<0<Xd0053R001@hP00
7@1@hP0805Sh00<009PT00<00?Pk002H1P00V0H00`00V0H2003h2@D069P00P0Wn00503JH02<0F?P0
0P00n3/5002R1P800?P91P0IXP0202Oh00H0>J80201Hn00207gS00H0NJ808@2jm`000`0Wn000?:X0
03bZ000303bZ00<0F?P01P1NZP0208Wh00H0OjX00`2jm`060:6Z0280joL01@1R/@0208Wh00L0QK40
0`2jm`060:Ra0100joL05`3R`@0608Zh00<0^_L01`2^^0030>_g00L0^9`08@3gdP00102>_@00^_L0
0;[g002jm`070;Bm00@0joL01`2mX@030?OB00H0_G`01`3RU00K0?NQ00<0joL02032YP040?OB00L0
`Wl03`3gX@080<8b0240mcl00P37FP0V0>=W04d0oooo00100?ooo`0306IVIP3oool0oooo00H0oooo
00<0IVIV07<05P1c01H00`1c02d50?X0H`80L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`03
0<X0n@1VIVH0A`1c00H0V@3i0`0I07<40080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001M
n@80049c00<0IVIV002?n@00FG<00P00FG<20030n@80071c0P00lOP3001cH0800?S?00<007=9003T
T000i9000P00i902001c<P<00>=S0P00La/00`00hcH0IVIV003S=P0@003S=Q800?Pk0P00OH42003a
n0<0085[0P00n<l30021DP03003hW@000000084h00<0084h00<00?Q/00217P00PAh00P00PAhI003h
>`d00><90P00SGH2003hc`@008eI0P00n9d4002=?@800?Q/1@00SB400`00n3/008d5002=1@03002=
1@03003h2@0FS@005Xd000<05Xd00P0Wn00W053R00@009PT00<00?Pk002H1P00V0H00`00V0H2003h
2@D069P00P0Wn00503JH02<0F?P00P00n3/5002R1P800?P91P0IXP0202Oh00H0>J802P1Hn00607VR
0240^_L000<09oP003bZ000lZP000`0lZP0305Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g
00D0H[400P29n00708Fa00<0^_L01P2X/@0G0>_g00l0h/4000<0ROP008Zh002:^000102:^0030;[g
00L0[[P00`3[m`060;RL00P0h/406P3gdP00102>_@00^_L00;[g002jm`070;Bm00@0joL01`2mX@03
0?OB00D0_G`03@3RU00F0?NQ00<0joL02032YP040?OB00L0`Wl03`3gX@080<8b0240mcl09`3SI`1>
0?ooo`00@03oool00`1VIVH0oooo0?ooo`050?ooo`0406IVIP3oool0L`0F0?X0<@<0L`0]1@3j06<2
07<0F`050?T0a@1c0780L`1b07<0LP3i0?L00`1M07<00`3:0?T0IVIV04L0L`0609T0n@<06@1c1002
07<01@040?T001Ac000DL`0057<002ci00<002]c0P00GOT01000@W<0IVIV002?n@00SoT3001IL`80
0<3i0P00L7<2003an0<007=P0P00n<l00`00LdT00>B@003TT002003TT08007<b0`00hf<01000La/0
0><f003S=P1VIVHG003S=P`00?Pk0P00OH42003an0<0085[0P00n<l30021DP03003hW@000000084h
00<0084h00<00?Q/00217P00PAh00P00PAhO003h>`H00><90`00SGH2003hc`@008eI0P00n9d4002=
?@800?Q/1@00SB400`00n3/008d5002=1@03002=1@03003h2@0FS@005Xd000<05Xd000<09oP0053R
001@hP009P1@hP04002H9003003h>`00V0H009P600<009P60P00n0T501RH00809oP01@0fV00S05Sh
00800?Pk1@00XPH2003h2@H06J800P0Wn00603VR00X0F?P01P1iXP0Q0;[g000302Oh000lZP00?:X0
00<0?:X00`1Hn00605jZ0080ROP01P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@030;[g
00H0Z;407P3[m`070>;10080ROP01P2:^0030;[g00L0[[P00`3[m`050;RL0100h/404`3gdP00102>
_@00^_L00;[g002jm`070;Bm00@0joL01`2mX@030?OB00@0_G`0503RU00@0?NQ00<0joL02032YP04
0?OB00L0`Wl03`3gX@080<8b0240mcl01P3gX@0P0>=W04l0oooo00100?ooo`0306IVIP3oool0oooo
00D0oooo00@0IVIV0?ooo`1c01H0nP0a0`1c02d40?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0
m`0305d0L`0306IVIP1707<0A`1c00D0V@3i100I07<40080L`0500@0n@0057<001Ac000DL`00;?T0
0`00:g<2001Mn@040012L`1VIVH008oi002?n@<005Uc0P00`?T2001`L`800?7h0`00Lf02003hc`D0
0>B@00<007<b003SH`00hf<00P00hf<00`00La/00><f06IVIP0N003S=PH00?Pk0P00OH400`00lOP0
085[0021J`020021J`800?S?0`00PE800`00n9d000000021>0030021>003003hK000PAh0084N0080
084N8`00n3/00`00lOP008ef002=MP02002=MP800?S?1000SET2003hW@@008dm0P00n6`5002=8@03
003h>`00S@D008d500<008d500<00?P901J=000FS@000`0FS@0702Oh0240D>801@00V2@00`00n3/0
09P6002H1P03002H1P800?P91@0HV00202Oh00D0=YP08`1Hn002003h>`D00:860P00n0T601VR0080
9oP01P0iXP0:05Sh00D0NJ808P2jm`000`0Wn000?:X003bZ000303bZ00<0F?P01P1NZP0208Wh00H0
OjX00`2jm`060:6Z0280joL01@1R/@0208Wh00L0QK400`2jm`060:Ra0280joL00P1U^00308Wh00H0
R[P00`2jm`070:jh00<0joL0102hW00G0>;100d0mm8000@0S[d00;[g002jm`00^_L0202d_@030>_g
00L0_J400`3gdP030;el01X0hY@02`3gX@030>_g00P0`ZH0103gdP070<9o0100mj401`32<P0R0?Lo
00X0mj406P3SI`1@0?ooo`00@03oool00`1VIVH0oooo0?ooo`040?ooo`0506IVIP3oool0oooo07<0
5P3j03400`1c02d40?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0305d0L`0306IVIP1707<0
A`1c00D0V@3i100I07<40080L`0500@0n@0057<001Ac000DL`00;?T00`00:g<2001Mn@0406IVIP00
@W<008oi002?n@<005Uc0P00`?T2001`L`800?7h0`00Lf000`00n<l00>B@003TT004003TT003001c
<P00hf<00>=S00800>=S0P00hcH00`1VIVH00><f003S=P0Q003S=P<007f100<00?7h0021J`00PF/0
0P00PF/00`00n<l0085B0021DP020021DP03003hW@000000084h00<0084h00<00?Q/00217P00PAh0
0P00PAhS003h>`03003an000SGH008ef008008ef0P00n<l4002=F@800?RM1000SCd2003hK0D008dQ
00<00?Pk002=1@00S@D00`00S@D00`00n0T05Xd001J=000301J=00d09oP06P1@hP000`00n6`009PT
002H9002002H90800?Pk1@00V0H2003h2@D069P00P0Wn00503JH02<0F?P00P00n3/5002R1P800?P9
1P0IXP0202Oh00H0>J802P1Hn00507VR00H0ZN80702jm`000`0Wn000?:X003bZ000303bZ00<0F?P0
1P1NZP0208Wh00H0OjX00`2jm`060:6Z0280joL01@1R/@0208Wh00L0QK400`2jm`060:Ra0280joL0
0P1U^00308Wh00H0R[P00`2jm`070:jh00<0joL00`2hW00O0>;100H0mm8000@0S[d00;[g002jm`00
^_L0202d_@030>_g00L0_J400`3gdP020;el0240hY@01@3gX@030>_g00T0`ZH00`3gdP070<9o0100
mj401`32<P0R0?Lo00l0mj40503SI`1A0?ooo`00?`3oool00`1VIVH0oooo0?ooo`050?ooo`0506IV
IP3oool0oooo07<05P3j03400`1c02d40?X0H`<0L`1K00D0n@3507<0LP1c0780L`1b0?T0m`0205d0
L`0406IVIP3:0?T0A`1c04L0L`D0V@3i100I07<40080L`0500@0n@0057<001Ac000DL`00;?T00`00
:g<01000GOT0IVIV0012L`00@W<2002?n@<005Uc0P00`?T2001`L`800?7h0`00Lf07003hc`@00>=S
0P00hcH00`1VIVH00><f003S=P0R003S=P<007f100<00?7h0021J`00PF/00P00PF/00`00n<l0085B
0021DP020021DP03003hW@000000084h00<0084h00<00?Q/00217P00PAh00P00PAhS003h>`03003a
n000SGH008ef008008ef0P00n<l4002=F@800?RM1000SCd2003hK0D008dQ00<00?Pk002=1@00S@D0
0`00S@D00`00n0T05Xd001J=000301J=01<09oP0501@hP000`00n6`009PT002H9002002H90800?Pk
1@00V0H2003h2@D069P00P0Wn00503JH02<0F?P00P00n3/5002R1P800?P91P0IXP0202Oh00H0>J80
2P1Hn00407VR00d0ZN805P2jm`000`0Wn000?:X003bZ000303bZ00<0F?P01P1NZP0208Wh00H0OjX0
0`2jm`060:6Z0280joL01@1R/@0208Wh00L0QK400`2jm`060:Ra0280joL00P1U^00308Wh00H0R[P0
0`2jm`070:jh00<0joL00P2hW00V0>;1000408jm002jm`00^_L00;[g00P0];d00`3[m`070;fQ00<0
mm8000<0_G`00>:D003RU0009@3RU0030>_g00T0`ZH00`3gdP070<9o0100mj401`32<P0R0?Lo01D0
mj403@3SI`1B0?ooo`00?`3oool00`1VIVH0oooo0?ooo`040?ooo`0606IVIP3oool0oooo0?ooo`1c
01H0nP0a0`1c02d40?X0H`<0L`1K101c0780103i0?L0G@1c05d0L`1VIVH304L0L`D0V@3i100I07<4
0080L`@001Ac00H002ci000[L`00:g<002]c001Mn@1VIVH20012L`8008oi0`00FG<01000`?T0071c
001`L`00L7<2003an0<007=P1P00n<l6003SH`0306IVIP00hf<00>=S00<00>=S7`00hcH4001mP@03
003an000PF/0085[0080085[00<00?S?0021DP00PE800P00PE800`00n9d000000021>0030021>003
003hK000PAh0084N0080084N8`00n3/00`00lOP008ef002=MP02002=MP800?S?1000SET2003hW@@0
08dm0P00n6`4002=8@800?Pk1@00S@D00`00n0T05Xd001J=000301J=01T09oP03@1@hP02003hK0@0
09PT0P00n3/5002H1P800?P91@0HV00202Oh00D0=YP08`1Hn002003h>`D00:860P00n0T601VR0080
9oP01P0iXP0:05Sh00<0NJ804`2YhP0A0;[g000302Oh000lZP00?:X000<0?:X00`1Hn00605jZ0080
ROP01P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@030;[g00H0Z;408P3[m`0206Fh00<0
ROP01P2:^0030;[g00P0[[P00P3[m`000`2hW000h/400>;1000T0>;100<0S[d00P2jm`080;Bm00<0
joL01`2mX@030?OB02L0hY@000@0^L800>_g003[m`00joL02@32YP030?OB00L0`Wl0403gX@070<8b
0280mcl06P3gX@070>=W05<0oooo000o0?ooo`0306IVIP3oool0oooo00@0oooo00H0IVIV0?ooo`3o
ool0oooo07<05P3j034207<0;@D0nP1S0`1c05/407<0LP040?T0m`1M07<0IVIV05d0L`<0A`1c1@2I
0?T301T0L`0303H0n@0207<00P1c00800P1c100057<4000[L`0406IVIP00@W<0049c0012L`8008oi
0P00FG<20030n@<0071c0P00lOP3001cH0`00?S?00<0IVIV003SH`00hf<02P00hf<G003S=P030030
n@00OH4007f1008007f100<00?7h0021J`00PF/00P00PF/00`00n<l0085B0021DP020021DP03003h
W@000000084h00<0084h00<00?Q/00217P00PAh00P00PAhS003h>`03003an000SGH008ef008008ef
0P00n<l4002=F@800?RM1000SCd2003hK0@008dQ0P00n3/5002=1@03003h2@0FS@005Xd000<05Xd0
7`0Wn006053R00<00?Q/1000V2@2003h>`D009P60P00n0T501RH00809oP01@0fV00S05Sh00800?Pk
1@00XPH2003h2@H06J800P0Wn00603VR00X0F?P00P1iXP0J0:WR00/0^_L000<09oP003bZ000lZP00
0`0lZP0305Sh00H0GZX00P29n00607nZ00<0^_L01P2QZP0R0>_g00D0H[400P29n00708Fa00<0^_L0
1P2X/@0R0>_g0080IKP00`29n00608Zh00<0^_L0202^^0020>_g02H0h/40102>_@020;[g00P0];d0
0`3[m`070;fQ00X0mm807`3RU0020;W200<0joL02@32YP030?OB00L0`Wl0403gX@070<8b0280mcl0
7@3gX@1G0?ooo`00?`3oool00`1VIVH0oooo0?ooo`030?ooo`0406IVIP3oool0oooo0?ooo`80L`0F
00<0nP0a07<0;@1c02d01@3j06<307<0F`@0L`1b00@0n@3g05d0L`1VIVH0bP3i0`1707<509T0n@<0
6@1c00<0=P3i0080L`0207<00P0207<4000DL`@002]c00@0IVIV0012L`00@W<0049c0P00SoT2001I
L`800<3i0`00L7<2003an0<007=P2`00n<l00`1VIVH00?S?003hc`06003hc``00>=S4000hcH00`00
`?T007f1001mP@02001mP@03003an000PF/0085[0080085[00<00?S?0021DP00PE800P00PE800`00
n9d000000021>0030021>003003hK000PAh0084N0080084N8`00n3/00`00lOP008ef002=MP02002=
MP800?S?1000SET2003hW@@008dm0P00n6`4002=8@800?Pk1@00S@D00`00n0T05Xd001J=000301J=
02<09oP00P00V483003hK0@009PT0P00n3/5002H1P800?P91@0HV00202Oh00D0=YP08`1Hn002003h
>`D00:860P00n0T601VR00809oP01P0iXP0:05Sh000307VR002YhP00ZN8001l0ZN801@2jm`000`0W
n000?:X003bZ000303bZ00<0F?P01P1NZP0208Wh00H0OjX00`2jm`060:6Z0280joL01@1R/@0208Wh
00L0QK400`2jm`060:Ra0280joL00P1U^00308Wh00H0R[P00`2jm`080:jh00T0joL07P3R`@0508jm
00<0^_L01`2d_@030>_g00H0_J40203S`@0:0?OB01L0hY@00`2i`P030>_g00T0`ZH00`3gdP070<9o
0100mj401`32<P0R0?Lo01d0mj40E`3oool003l0oooo00<0IVIV0?ooo`3oool00`3oool0101VIVH0
oooo0?ooo`3oool207<05P030?X0<@1c02d0L`0]00D0nP1S0`1c05/307<0LP80n@3g00<0IVIV05d0
L`3:0?T00`1707<509T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@04000DL`<002]c00<0IVIV
001Mn@00@W<00P00@W<2002?n@8005Uc0P00`?T3001`L`800?7h0`00Lf0;003hc`0306IVIP00n<l0
0?S?00d00?S?3000hf<8003S=P800<3i1000OH400`00lOP0085[0021J`020021J`03003hc`00PE80
085B0080085B00<00?RM00000000PCP00`00PCP00`00n6`0084N00217P0200217R<00?Pk00<00?7h
002=MP00SGH00P00SGH2003hc`@008eI0P00n9d4002=?@800?Q/1000SB42003h>`D008d500<00?P9
01J=000FS@000`0FS@0S02Oh008009Q20`00n6`4002H90800?Pk1@00V0H2003h2@D069P00P0Wn005
03JH02<0F?P00P00n3/5002R1P800?P91P0IXP0202Oh00H0>J802P1Hn00W0:WR000302Oh000lZP00
?:X000<0?:X00`1Hn00605jZ0080ROP01P1oZP030;[g00H0XJX08P3[m`0506:a0080ROP01`25/@03
0;[g00H0Z;408P3[m`0206Fh00<0ROP01P2:^0030;[g00P0[[P0403[m`0F0>;100H0S[d00`2jm`07
0;Bm00<0joL01@2mX@0@0>?100T0mm80403RU0050;W200<0joL02032YP030?OB00H0`Wl0203RU009
0?NQ00L0`S808P3g?`0M0?NQ05L0oooo000o0?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?oo
o`3oool00P3oool207<05P030?X0<@1c02d0L`0]00D0nP1S0P1c05/01P3i0<D0L`1b07<0LP1c0780
n@3g06IVIP80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T301T0L`0503H0n@0207<00P1c0080L`04
0?T0100057<3000[L`0306IVIP00GOT0049c0080049c0P00SoT2001IL`800<3i0`00L7<2003an080
07=P2`00n<l00`1VIVH00?S?003hc`0E003hc`P00>=S0P00SoT3001TP@800<3i1000OH400`00lOP0
085[0021J`020021J`03003hc`00PE80085B0080085B00<00?RM00000000PCP00P00PCP2003hK0@0
084N8`00n3/00`00lOP008ef002=MP02002=MP800?S?1000SET2003hW@@008dm0P00n6`4002=8@80
0?Pk1@00S@D00`00n0T05Xd001J=000301J=02<09oP00P00V483003hK0@009PT0P00n3/5002H1P80
0?P91@0HV00202Oh00D0=YP08`1Hn002003h>`D00:860P00n0T601VR00809oP01P0iXP0905Sh02L0
ZN800P0Wn00503bZ00<0F?P01P1NZP0208Wh00H0OjX00`2jm`060:6Z00H0e^40703[m`0506:a0080
ROP01`25/@030;[g00H0Z;408P3[m`0306Fh0080ROP01`2:^0030;[g00L0[[P05P3[m`0?0>;100L0
S[d00`2jm`070;Bm00<0joL0102mX@0G0>?100X0mm80203RU0060;W200<0joL02032YP030?OB00D0
`Wl0403RU0020?NQ00L0`S808P3g?`0M0?NQ05L0oooo000o0?ooo`0306IVIP3oool0oooo0080oooo
00<0IVIV0?ooo`3oool00P3oool207<05P030?X0<@1c02d0L`0]00D0nP1S0P1c05/01P3i0<D0L`1b
07<0LP1c0780n@3g06IVIP80G@1c00@0bP3i04L0L`1707<0A`1c1@2I0?T301T0L`0503H0n@0207<0
0P1c0080L`040?T0100057<2000[L`0306IVIP00:g<005gi00<0049c00@008oi001IL`00FG<005Uc
0P00`?T3001`L`800?7h0P00Lf0:003hc`0306IVIP00n<l00?S?01L00?S?0P00<8400`00GOT004Z1
001:P@02001:P@03002?n@00I84006B1008006B10P00`?T3001mP@800?7h1000PF/00`00n<l0085B
0021DP020021DP0300000000PCP0084h0080084h0P00hf<400217R<00?Pk00<00?7h002=MP00SGH0
0P00SGH2003hc`@008eI0P00n9d4002=?@800?Q/1000SB42003h>`D008d500<00?P901J=000FS@00
0P0FS@0T02Oh008009Q20`00n6`4002H90800?Pk1@00V0H2003h2@D069P00P0Wn00403JH02@0F?P0
0P00n3/5002R1P800?P91P0IXP0202Oh00H0>J80401Hn00O0:WR00<09oP01@0lZP0305Sh00H0GZX0
0P29n00607nZ00<0^_L01@2QZP0=0=KQ01H0joL01@1R/@0208Wh00L0QK400`2jm`060:Ra0280joL0
0`1U^00208Wh00L0R[P00`2jm`070:jh01d0joL01`3R`@000`29n000S[d008jm000508jm00<0^_L0
1`2d_@030>_g00<0_J407`3S`@060?OB00<0^_L0202i`P030>_g00P0`ZH00`3gdP040<9o01<0hY@0
1P32<P080>4j01/0mcl07@3gX@1G0?ooo`00?`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00D0oooo
0P1c01H00`3j0340L`0]07<0;@050?X0H`80L`1K00H0n@3507<0LP1c0780L`1b06IVIP3i0?L205d0
L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<01@0f0?T00P1c0080L`0207<0103i00<001Ac00@0
02ci000[L`00:g<0IVIV0P00GOT20012L`8008oi0`00FG<20030n@<0071c0P00lOP2001cH0X00?S?
00<0IVIV003hc`00n<l05`00n<l2000`P@03001Mn@00BX4004Z1008004Z100<008oi001TP@00I840
0P00I8420030n@<007f10P00lOP40021J`03003hc`00PE80085B0080085B00@000000021>000PCP0
084h0`00hf<300217R@00?Pk00@00?7h002=MP00SGH008ef0`00n<l4002=F@800?RM1000SCd00`00
n6`008dQ002=8@03002=8@800?Pk1@00S@D00`00n0T05Xd001J=000201J=00H08n807P0Wn002002H
@P<00?Q/1000V2@2003h>`D009P60P00n0T501RH00809oP0100fV006053R01h0F?P00P00n3/5002R
1P800?P91P0IXP0202Oh00H0>J805`1Hn00G0:WR000401ZZ000Wn0009oP002Oh00D0?:X00`1Hn006
05jZ0080ROP01P1oZP030;[g00@0XJX04`3Fh@0A0>_g00D0H[400P29n00708Fa00<0^_L01P2X/@0R
0>_g00<0IKP00P29n00708Zh00<0^_L01`2^^00P0>_g0080JKd00`29n00708jm00<0^_L01`2d_@03
0>_g0080_J409P3S`@030;[g00P0^L800`3[m`080<:V00<0mm800`32O`0D0>:D00D0`S80403Q>P0D
0?Lo01d0mj40E`3oool003l0oooo00D0IVIV0?ooo`3oool0oooo06IVIP050?ooo`0307<05P3j0340
L`0]0080L`0]1@3j06<207<0F`050?T0a@1c0780L`1b07<0LP1VIVH00`1M07<00`3:0?T0A`1c04L0
L`0609T0n@<06@1c00D0=P3i0080L`0207<00P1c00@0n@03000DL`04000/n@00:g<0IVIV000[L`80
05gi0P00@W<2002?n@<005Uc0P00`?T3001`L`800?7h0P00Lf09003hc`0306IVIP00n<l00?S?01L0
0?S?0`00<8400`00GOT004Z1001:P@02001:P@03002?n@00I84006B1008006B10P00`?T3001mP@80
0?7h1000PF/00`00n<l0085B0021DP020021DP0300000000PCP0084h00@00>=S0`00PAh6003R=Qh0
0?Pk00@00?7h002=MP00SGH008ef0`00n<l4002=F@800?RM0`00SCd2003hK0D008dQ0P00n3/5002=
1@04003h2@0FS@005Xd001J=00d08n80600Wn002002H@P<00?Q/1000V2@2003h>`D009P60P00n0T5
01RH00809oP00`0fV00=053R01P0F?P00P00n3/5002R1P800?P91P0IXP0202Oh00H0>J807P1Hn00?
0:WR00806ZX00`0Wn00503bZ00<0F?P01P1NZP0208Wh00H0OjX00`2jm`030:6Z01X0e^402`3[m`05
06:a0080ROP01`25/@030;[g00H0Z;408P3[m`0306Fh0080ROP01`2:^0030;[g00L0[[P0803[m`02
06Vm00<0ROP01`2>_@030;[g00L0];d00`3[m`0W0>?1000309;2002jm`00^_L00080^_L01`2i`P03
0>_g00P0`ZH00`3gdP020<9o01D0hY@01032<P0H0>4j00d0mcl07@3gX@1G0?ooo`00?`3oool0101V
IVH0oooo0?ooo`1VIVH60?ooo`0307<05P3j0340L`0]0080L`0]1@3j06<207<0F`050?T0a@1c0780
L`1b06IVIP3i0?L00`1M07<00`3:0?T0A`1c04L0L`0609T0n@<06@1c100207<01P040?T001Ac000D
L`0057<002ci06IVIP8002]c0P00GOT20012L`8008oi0`00FG<20030n@<0071c0P00lOP2001cH0T0
0?S?00<0IVIV003hc`00n<l05`00n<l3000`P@03001Mn@00BX4004Z1008004Z100<008oi001TP@00
I8400P00I8420030n@<007f10P00lOP40021J`03003hc`00PE80085B0080085B00<000000021>000
PCP01000hf<200217Pd00>8f6000n3/01000lOP008ef002=MP00SGH3003hc`@008eI0P00n9d3002=
?@800?Q/1@00SB42003h>`@008d50P00n0T201J=01@08n804P0Wn002002H@P800?Q/1@00V2@2003h
>`D009P60P00n0T501RH00809oP00P0fV00D053R0180F?P00P00n3/5002R1P800?P91P0IXP0202Oh
00H0>J808@1Hn004002Z1PL0ZN800`0JZP0302Oh00D0?:X00`1Hn00605jZ0080ROP01P1oZP030;[g
0080XJX08@3Fh@050>_g00D0H[400P29n00708Fa00<0^_L01P2X/@0R0>_g00<0IKP00P29n00708Zh
00<0^_L01`2^^00P0>_g0080JKd00`29n00708jm00<0^_L01`2d_@090>_g0200hl400P2B`P040;[g
00L0^L800`3[m`080<:V00<0mm805`3RU0030<8b0200hCX01P3g?`0M0?NQ05L0oooo000o0?ooo`04
06IVIP3oool0oooo06IVIPH0oooo00<0L`0F0?X0<@1c02d00P1c02d40?X0H`<0L`1K00D0n@3507<0
LP1c0780IVIV0?T0m`0305d0L`030<X0n@1707<0A`1c00H0V@3i0`0I07<40080L`0600@0n@0057<0
01Ac000DL`00;?T0IVIV0P00:g<2001Mn@80049c0P00SoT3001IL`800<3i0P00L7<3003an08007=P
2000n<l00`1VIVH00?S?003hc`0H003hc`<0032100<005gi001:P@00BX400P00BX400`00SoT006B1
001TP@02001TP@800<3i0`00OH42003an0<0085[0P00n<l30021DP03003hW@000000084h00D00>=S
0P00PAhC003R=Q800?Pk00@00?7h002=MP00SGH008ef0`00n<l4002=F@800?RM0`00SCd2003hK0D0
08dQ0P00n3/4002=1@800>880P0FS@0J02?R00`09oP00P00V482003hK0D009PT0P00n3/5002H1P80
0?P91@0HV00202Oh0080=YP06P1@hP0<05Sh00800?Pk1@00XPH2003h2@H06J800P0Wn00603VR0240
F?P01P00ZPH2003h2@H06ZX00`0Wn00503bZ00<0F?P01P1NZP0208Wh00H0OjX00`2jm`000`2QZP00
e^400=KQ000U0=KQ00D0H[400P29n00708Fa00<0^_L01P2X/@0R0>_g00<0IKP00P29n00708Zh00<0
^_L01`2^^00P0>_g0080JKd00`29n00708jm00<0^_L01`2d_@0>0>_g01X0hl400`2B`P040;[g00L0
^L800`3[m`080<:V00T0mm804@3RU0020<8b02L0hCX07@3gX@1G0?ooo`00?`3oool00`1VIVH0oooo
06IVIP070?ooo`0307<05P3j0340L`0]0080L`0]103j06<307<0F`050?T0a@1c0780IVIV07<0LP3i
0?L00`1M07<00`3:0?T0A`1c04L0L`0509T0n@@06@1c100207<01@040?T001Ac000DL`0057<0IVIV
00<002]c0P00GOT20012L`8008oi0`00FG<20030n@80071c0P00lOP3001cH0L00?S?00<0IVIV003h
c`00n<l06@00n<l3000`P@04001Mn@00BX4004Z1001:P@8008oi1000I8420030n@<007f10P00lOP3
0021J`800?S?0`00PE800`00hi000000003SH`05003SH`0300217P00hSH00>8f01P00>8f3000n3/0
1000lOP008ef002=MP00SGH3003hc`@008eI0P00n9d3002=?@800?Q/1@00SB42003h>`<008d50`00
hPP00`0FS@008n8002?R000O02?R00H09oP00P00V482003hK0D009PT0P00n3/5002H1P800?P91@0H
V00202Oh000303JH001@hP00D>8001l0D>801P1Hn002003h>`D00:860P00n0T601VR00809oP01P0i
XP0Q05Sh00H00:X60P00n0T601ZZ00<09oP01@0lZP0305Sh00H0GZX00P29n00607nZ00<0^_L09`3F
h@0606:a0080ROP01`25/@030;[g00H0Z;408P3[m`0306Fh00<0ROP01P2:^0030;[g00L0[[P08@3[
m`00101Y_@00ROP008Wh0029n00708jm00<0^_L01`2d_@0D0>_g01<0hl40102B`P040;[g00L0^L80
0`3[m`080<:V00h0mm80303RU0000`32<P00hCX00>4j000U0>4j01h0mj40E`3oool003h0oooo00@0
IVIV0?ooo`3oool0IVIV1`3oool00`1c01H0nP0a07<0;@0207<0;@@0nP1S0`1c05/01@3i0<D0L`1b
06IVIP1c0780n@3g00<0G@1c00<0bP3i04L0L`1707<01@2I0?T401T0L`@00P1c00D0103i000DL`00
57<001Ac06IVIP03000[L`8005gi0P00@W<2002?n@<005Uc0P00`?T2001`L`800?7h0`00Lf07003h
c`0306IVIP00n<l00?S?01T00?S?0`00<8401000GOT004Z1001:P@00BX42002?n@@006B10P00`?T3
001mP@800?7h0`00PF/2003hc`80085B0P00hi05000000800>=S00<0084N003R=P00hSH07P00hSH6
003h>`04003an000SGH008ef002=MP<00?S?1000SET2003hW@<008dm0P00n6`5002=8@800?Pk0P00
S@D4003R22L08n800`00V482003hK0D009PT0P00n3/5002H1P800?P91@0HV00202Oh02L0D>8000<0
0:8V003h>`00n3/01@00XPH2003h2@H06J800P0Wn00603VR0240F?P01P00ZPH2003h2@H06ZX00`0W
n00503bZ00<0F?P01P1NZP0208Wh00H0OjX02P2jm`0O0=KQ000305Sh001R/@00H[4000@0H[400P29
n00708Fa00<0^_L01P2X/@0R0>_g00<0IKP00`29n00608Zh00<0^_L01`2^^00Q0>_g000406Vm0029
n000ROP008Wh00L0S[d00`2jm`070;Bm01T0joL03@3S`@0509;200@0^_L01`2i`P030>_g00P0`ZH0
4`3gdP070>:D02L0hCX0803gX@1F0?ooo`00?P3oool00`1VIVH0oooo06IVIP080?ooo`0307<05P3j
0340L`0]0080L`0]103j06<307<0F`0507<0LP1VIVH0L`1b07<0LP3i0?L00`1M07<00`3:0?T0A`1c
04L0L`0509T0n@@06@1c100207<01@040?T001Ac000DL`1VIVH002ci00<002]c00@005gi0012L`00
@W<0049c0P00SoT3001IL`800<3i0P00L7<2003an0<007=P1P00n<l00`1VIVH00?S?003hc`0J003h
c`<0032100@005gi001:P@00BX4004Z10P00SoT4001TP@030030n@00OH4007f1008007f10P00lOP3
0021J`800?S?00D0085B003ST000hi000>>@00000006003ST2H00>8f0P00lOP3002=MP<00?S?0`00
SET2003hW@@008dm0P00n6`5002=8@800?Pk0P00S@D3003R22P08n800`00V482003hK0D009PT0P00
n3/5002H1P800?P91@0HV0000`0Wn000D>80053R000V053R0003002R9P00n3/00?Pk00D00:860P00
n0T601VR00809oP01P0iXP0Q05Sh00H00:X60P00n0T601ZZ00<09oP01@0lZP0305Sh00D0GZX00`1m
hP0607nZ0140^_L05`3Fh@0205Sh00H0H[400P29n00708Fa00<0^_L01P2X/@0R0>_g00<0IKP00`29
n00608Zh00<0^_L01`2^^00Q0>_g000406Vm0029n000ROP008Wh00L0S[d00`2jm`070;Bm01l0joL0
1P3S`@0609;200@0^_L01`2i`P030>_g00P0`ZH06@3gdP080>:D01l0hCX000<0ah800?NQ003gX@00
7P3gX@1F0?ooo`00?P3oool00`1VIVH0oooo06IVIP080?ooo`0407<05P3j0340L`0]07<0;@D0nP1S
0`1c05/01@1c0780IVIV07<0LP1c0780n@3g00<0G@1c0`1707<509T0n@@06@1c100207<01@040?T0
01Ac000DL`1VIVH002ci00<002]c00@005gi0012L`00@W<0049c0P00SoT3001IL`800<3i0P00L7<2
003an0<007=P1P00n<l00`1VIVH00?S?003hc`0J003hc`<0032100@005gi001:P@00BX4004Z10P00
SoT3001TP@800<3i1000OH42003an0<0085[0P00n<l01@00PE800>>@003ST000hi00000000D00>>@
9`00hSH00`00lOP008ef002=MP02002=MP<00?S?0`00SET2003hW@@008dm0P00n6`5002=8@800?Pk
00<008d5003R2000hPP02@00hPPP02?R00@009Q20P00n6`5002H90800?Pk1@00V0H2003h2@D069P0
200Wn00P053R00800:8V0P00n3/5002R1P800?P91P0IXP0202Oh00H0>J808@1Hn006002Z1P800?P9
1P0JZP0302Oh00D0?:X00`1Hn00405jZ00@0ON801P1oZP060:WQ0180^_L03`3Fh@0305Sh00H0H[40
0P29n00708Fa00<0^_L01P2X/@0R0>_g00<0IKP00`29n00608Zh00<0^_L01`2^^00Q0>_g000406Vm
0029n000ROP008Wh00L0S[d00`2jm`070;Bm0240joL00`29n00709;200@0^_L01`2i`P030>_g00P0
`ZH07P3gdP070>:D00<0_LL05`3Q>P020<N20200mj40EP3oool003h0oooo0P1VIVH80?ooo`80L`0F
00<0nP0a07<0;@1c02d01@3j06<307<0F`0506IVIP1c0780L`1b07<0LP3i0?L00P1M07<0103:0?T0
A`1c04L0L`1707<509T0n@<06@1c00<0=P3i0080L`0207<00P0207<2000DL`0306IVIP0057<002]c
00<002]c00@005gi0012L`00@W<0049c0P00SoT2001IL`800<3i0`00L7<2003an0<007=P1@00n<l0
0`1VIVH00?S?003hc`0K003hc`<0032100@005gi001:P@00BX4004Z10P00SoT3001TP@800<3i1000
OH42003an0<0085[0P00n<l4003ST00300000000hi000>>@00X00>>@7`00hSH00`00RHd00?7h002=
MP03002=MP<00?S?0`00SET2003hW@@008dm0P00n6`5002=8@800?Pk4`00hPPH02?R0003003hW@00
V48009Q2008009Q20P00n6`5002H90800?Pk1@00V0H2003h2@D069P03`0Wn00H053R00<00:8V0P00
n3/5002R1P800?P91P0IXP0202Oh00H0>J808@1Hn006002Z1P800?P91P0JZP0302Oh00D0?:X00`1H
n00305jZ00D0ON801@1oZP0=0:WQ01<0^_L01`3Fh@00100o/@00F?P005Sh001Hn00606:a0080ROP0
1`25/@030;[g00H0Z;408P3[m`0306Fh00<0ROP01P2:^0030;[g00L0[[P08@3[m`00101Y_@00ROP0
08Wh0029n00708jm00<0^_L01`2d_@0Q0>_g00<0ROP01`2B`P040;[g00L0^L800`3[m`070<:V00P0
h/406@3gdP0208Wh00P0_LL00`3[m`000`37Z@00hCX00>4j000>0>4j00<0ah80803gX@1F0?ooo`00
?P3oool206IVIPP0oooo0P1c01H00`3j0340L`0]07<0;@050?X0H`<0L`1K00D0IVIV07<0LP1c0780
L`1b0?T0m`0205d0L`040<X0n@1707<0A`1c04L0L`D0V@3i0`0I07<00`0f0?T00P1c0080L`020080
L`04000DL`1VIVH001Ac000DL`@002]c00@005gi0012L`00@W<0049c0P00SoT2001IL`800<3i0`00
L7<2003an0<007=P1000n<l00`1VIVH00?S?003hc`0L003hc`<0032100@005gi001:P@00BX4004Z1
0P00SoT3001TP@800<3i1000OH400`00lOP0085[0021J`020021J`03003hc`00hi000>>@01L00>>@
5`00hSH20029S@03003an000SGH008ef008008ef0`00n<l3002=F@800?RM1000SCd2003hK0D008dQ
00<00?Pk003R2000hPP06@00hPP@02?R00800?RM1000V482003hK0D009PT0P00n3/5002H1P800?P9
1@0HV00F02Oh0100D>801000XRH2003h>`D00:860P00n0T601VR00809oP01P0iXP0Q05Sh00H00:X6
0P00n0T601ZZ00<09oP01@0lZP0305Sh0080GZX01P1mhP0407nZ01<0ZN404@2jm`0503na00<0F?P0
1P1R/@0208Wh00L