(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1600662,      35138]*)
(*NotebookOutlinePosition[   1601814,      35175]*)
(*  CellTagsIndexPosition[   1601770,      35171]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Infant mortality in OECD states", "Subtitle"],

Cell["\<\
The original Excel file is located at the website of the \
OECD:\
\>", "Text"],

Cell[TextData[ButtonBox["http://www.oecd.org/xls/M00031000/M00031359.xls",
  ButtonData:>{
    URL[ "http://www.oecd.org/xls/M00031000/M00031359.xls"], None},
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[BoxData[
    \(\(\(\(\(<< MathXLS`\)\(\ \)\) \)\(;\)\(\ \)\(\(timestart = 
        AbsoluteTime[]\) \)\(;\)\(\ \)\)\)], "Input",
  CellLabel->"In[117]:="],

Cell["\<\
This extract the information about the names of the workbook.\
\>", \
"Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(XLSInfo["\<M00031359.xls\>"]\)], "Input",
  CellLabel->"In[118]:="],

Cell[BoxData[
    \({"TABLE2"}\)], "Output",
  CellLabel->"Out[118]="]
}, Open  ]],

Cell["\<\
This imports the workbook (which has only one sheet) as a matrix:\
\
\>", "Text"],

Cell[BoxData[
    \(\(r = 
        ImportXLS["\<M00031359.xls\>", ToMatrix \[Rule] True];\)\)], "Input",
  CellLabel->"In[119]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[r]\)], "Input",
  CellLabel->"In[120]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[120]="]
}, Open  ]],

Cell["\<\
Alternatively, importing directly from the Internet:        \
r=ImportXLS[\"http://www.oecd.org/xls/M00031000/M00031359.xls\"];\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm@r\)], "Input",
  CellLabel->"In[121]:="],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"Infant mortality - Deaths per 1 000 live births\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            FontWeight->"Bold"], "\<\"\"\>", 
          StyleBox["1960",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1970",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1980",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1990",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1991",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1992",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1993",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1994",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1997",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1999",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2000",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"Australia\"\>", 
          StyleBox["20.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"Austria\"\>", 
          StyleBox["37.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["6",
            FontWeight->"Bold"], "\<\"Belgium\"\>", 
          StyleBox["31.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"Canada\"\>", 
          StyleBox["27.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"Czech Republic\"\>", 
          StyleBox["20",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"Denmark\"\>", 
          StyleBox["21.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"Finland\"\>", 
          StyleBox["21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            FontWeight->"Bold"], "\<\"France\"\>", 
          StyleBox["27.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["12",
            FontWeight->"Bold"], "\<\"Germany\"\>", 
          StyleBox["35",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            FontWeight->"Bold"], "\<\"Greece\"\>", 
          StyleBox["40.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            FontWeight->"Bold"], "\<\"Hungary\"\>", 
          StyleBox["47.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["35.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            FontWeight->"Bold"], "\<\"Iceland\"\>", 
          StyleBox["13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            FontWeight->"Bold"], "\<\"Ireland\"\>", 
          StyleBox["29.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            FontWeight->"Bold"], "\<\"Italy\"\>", 
          StyleBox["43.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            FontWeight->"Bold"], "\<\"Japan\"\>", 
          StyleBox["30.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            FontWeight->"Bold"], "\<\"Korea\"\>", "\<\"\"\>", 
          StyleBox["45",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", 
          StyleBox["13",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", 
          StyleBox["10",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", 
          StyleBox["9.9",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>", 
          StyleBox["7.7",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["20",
            FontWeight->"Bold"], "\<\"Luxembourg\"\>", 
          StyleBox["31.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            FontWeight->"Bold"], "\<\"Mexico\"\>", "\<\"\"\>", 
          StyleBox["79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["39.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["36.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["34.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["33.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["32.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["31.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["30.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["29.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["28.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["26.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["22",
            FontWeight->"Bold"], "\<\"Netherlands\"\>", 
          StyleBox["17.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            FontWeight->"Bold"], "\<\"New Zealand\"\>", 
          StyleBox["22.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["24",
            FontWeight->"Bold"], "\<\"Norway\"\>", 
          StyleBox["18.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["25",
            FontWeight->"Bold"], "\<\"Poland\"\>", 
          StyleBox["54.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["36.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            FontWeight->"Bold"], "\<\"Portugal\"\>", 
          StyleBox["77.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["55.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"Slovak Republic\"\>", 
          StyleBox["28.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["28",
            FontWeight->"Bold"], "\<\"Spain\"\>", 
          StyleBox["43.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["28.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["29",
            FontWeight->"Bold"], "\<\"Sweden\"\>", 
          StyleBox["16.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["30",
            FontWeight->"Bold"], "\<\"Switzerland\"\>", 
          StyleBox["21.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["31",
            FontWeight->"Bold"], "\<\"Turkey\"\>", 
          StyleBox["189.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["145",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["117.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["88",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["57.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["54.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["51.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["53",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["47.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["45.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["44",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["42.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["40.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["39.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["32",
            FontWeight->"Bold"], "\<\"United Kingdom\"\>", 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["33",
            FontWeight->"Bold"], "\<\"United States\"\>", 
          StyleBox["26",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>"},
        {
          StyleBox["34",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["35",
            
            FontWeight->
              "Bold"], "\<\"Copyright OECD HEALTH DATA 2002 4th ed.\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(XLSBar3D@r\ ;\)\)], "Input",
  CellLabel->"In[122]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0852 
%%ImageSize: 900 976.677 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
-0.131077 1.1846 2.22261e-17 1.1846 [
[.5 1.0977 -151.125 0 ]
[.5 1.0977 151.125 15.0625 ]
[.24964 -0.00888 -15.5743 -11.375 ]
[.24964 -0.00888 17.1757 0 ]
[.29861 .00282 -15.7612 -11.375 ]
[.29861 .00282 16.9888 0 ]
[.34699 .01439 -15.945 -11.375 ]
[.34699 .01439 16.805 0 ]
[.39481 .02582 -16.1257 -11.375 ]
[.39481 .02582 16.6243 0 ]
[.44208 .03713 -16.3033 -11.375 ]
[.44208 .03713 16.4467 0 ]
[.4888 .0483 -16.478 -11.375 ]
[.4888 .0483 16.272 0 ]
[.53499 .05935 -16.6498 -11.375 ]
[.53499 .05935 16.1002 0 ]
[.58065 .07028 -16.8188 -11.375 ]
[.58065 .07028 15.9312 0 ]
[.62579 .08108 -16.9851 -11.375 ]
[.62579 .08108 15.7649 0 ]
[.67043 .09176 -17.1487 -11.375 ]
[.67043 .09176 15.6013 0 ]
[.71456 .10232 -17.3097 -11.375 ]
[.71456 .10232 15.4403 0 ]
[.7582 .11277 -17.4682 -11.375 ]
[.7582 .11277 15.2818 0 ]
[.80136 .1231 -17.6241 -11.375 ]
[.80136 .1231 15.1259 0 ]
[.84404 .13332 -17.7777 -11.375 ]
[.84404 .13332 14.9723 0 ]
[.88626 .14342 -17.9289 -11.375 ]
[.88626 .14342 14.8211 0 ]
[.20718 .00253 -61.5 -7.03876 ]
[.20718 .00253 0 4.33624 ]
[.19996 .01939 -54.3125 -7.02612 ]
[.19996 .01939 0 4.34888 ]
[.19286 .03596 -61.5 -7.24495 ]
[.19286 .03596 0 4.50505 ]
[.18588 .05225 -47.125 -7.00156 ]
[.18588 .05225 0 4.37344 ]
[.17902 .06827 -54.3125 -6.98961 ]
[.17902 .06827 0 4.38539 ]
[.17227 .08403 -90.25 -6.97788 ]
[.17227 .08403 0 4.39712 ]
[.16563 .09953 -90.25 -7.19601 ]
[.16563 .09953 0 4.55399 ]
[.1591 .11479 -61.5 -6.95503 ]
[.1591 .11479 0 4.41997 ]
[.15267 .12979 -54.3125 -6.94391 ]
[.15267 .12979 0 4.43109 ]
[.14634 .14456 -75.875 -7.16155 ]
[.14634 .14456 0 4.58845 ]
[.14012 .1591 -111.812 -7.15045 ]
[.14012 .1591 0 4.59955 ]
[.13399 .17341 -54.3125 -6.91169 ]
[.13399 .17341 0 4.46331 ]
[.12796 .1875 -61.5 -6.90131 ]
[.12796 .1875 0 4.47369 ]
[.12202 .20136 -61.5 -6.89111 ]
[.12202 .20136 0 4.48389 ]
[.11617 .21502 -83.0625 -6.88108 ]
[.11617 .21502 0 4.49392 ]
[.11041 .22847 -90.25 -6.87121 ]
[.11041 .22847 0 4.50379 ]
[.10473 .24172 -61.5 -7.08771 ]
[.10473 .24172 0 4.66229 ]
[.09915 .25477 -111.812 -7.07785 ]
[.09915 .25477 0 4.67215 ]
[.09364 .26762 -61.5 -7.06815 ]
[.09364 .26762 0 4.68185 ]
[.08822 .28029 -47.125 -7.0586 ]
[.08822 .28029 0 4.6914 ]
[.08287 .29277 -104.625 -7.04921 ]
[.08287 .29277 0 4.70079 ]
[.0776 .30507 -47.125 -6.81528 ]
[.0776 .30507 0 4.55972 ]
[.07241 .31719 -54.3125 -6.80647 ]
[.07241 .31719 0 4.56853 ]
[.06729 .32914 -119 -7.0219 ]
[.06729 .32914 0 4.7281 ]
[.06225 .34092 -61.5 -6.78925 ]
[.06225 .34092 0 4.58575 ]
[.05728 .35254 -47.125 -6.78084 ]
[.05728 .35254 0 4.59416 ]
[.05237 .36399 -68.6875 -6.77256 ]
[.05237 .36399 0 4.60244 ]
[.04754 .37528 -54.3125 -6.7644 ]
[.04754 .37528 0 4.6106 ]
[.04277 .38641 -54.3125 -6.9791 ]
[.04277 .38641 0 4.7709 ]
[.03807 .39739 -54.3125 -6.74844 ]
[.03807 .39739 0 4.62656 ]
[.20973 -0.00343 -7.2 -6.6872 ]
[.20973 -0.00343 0 4.1128 ]
[.20126 .15066 -14.4 -6.58635 ]
[.20126 .15066 0 4.21365 ]
[.19217 .3161 -21.6 -6.47831 ]
[.19217 .3161 0 4.32169 ]
[.18239 .49418 -21.6 -6.36228 ]
[.18239 .49418 0 4.43772 ]
[.17185 .68641 -21.6 -6.23733 ]
[.17185 .68641 0 4.56267 ]
[ 0 0 0 0 ]
[ 1 1.0852 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.0977 -212.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.0625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Infant) show
104.750 15.125 moveto
(mortality) show
167.500 15.125 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
180.812 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Deaths) show
231.125 15.125 moveto
(per) show
256.688 15.125 moveto
(1) show
268.312 15.125 moveto
(000) show
295.438 15.125 moveto
(live) show
322.562 15.125 moveto
(births) show
361.250 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.22414 0 m
.92954 .16815 L
s
.24912 .00177 m
.24872 .01005 L
s
gsave
.24964 -0.00888 -76.5743 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1960) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.29821 .01348 m
.2979 .02176 L
s
gsave
.29861 .00282 -76.7612 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1970) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34671 .02505 m
.34649 .03334 L
s
gsave
.34699 .01439 -76.945 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1980) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.39465 .03649 m
.39453 .04478 L
s
gsave
.39481 .02582 -77.1257 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.44203 .04779 m
.442 .05608 L
s
gsave
.44208 .03713 -77.3033 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1990) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.48887 .05896 m
.48892 .06726 L
s
gsave
.4888 .0483 -77.478 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1991) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53517 .07001 m
.53531 .0783 L
s
gsave
.53499 .05935 -77.6498 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1992) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58094 .08093 m
.58116 .08922 L
s
gsave
.58065 .07028 -77.8188 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1993) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.62619 .09173 m
.6265 .10002 L
s
gsave
.62579 .08108 -77.9851 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1994) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.67093 .10241 m
.67132 .11069 L
s
gsave
.67043 .09176 -78.1487 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.71517 .11296 m
.71564 .12124 L
s
gsave
.71456 .10232 -78.3097 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1996) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75891 .1234 m
.75946 .13168 L
s
gsave
.7582 .11277 -78.4682 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.80217 .13373 m
.8028 .142 L
s
gsave
.80136 .1231 -78.6241 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1998) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84495 .14394 m
.84566 .1522 L
s
gsave
.84404 .13332 -78.7777 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88727 .15404 m
.88805 .16229 L
s
gsave
.88626 .14342 -78.9288 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2000) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.05262 .40011 L
s
.21755 .005 m
.22562 .00691 L
s
gsave
.20718 .00253 -122.5 -11.0388 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Iceland) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.060 0.000 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.21034 .02183 m
.21841 .02373 L
s
gsave
.19996 .01939 -115.312 -11.0261 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sweden) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.258 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.20324 .03838 m
.21132 .04026 L
s
gsave
.19286 .03596 -122.5 -11.2449 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Finland) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.456 0.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.19627 .05465 m
.20435 .05652 L
s
gsave
.18588 .05225 -108.125 -11.0016 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Japan) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.654 0.000 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18941 .07065 m
.1975 .0725 L
s
gsave
.17902 .06827 -115.312 -10.9896 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Norway) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.852 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18267 .08639 m
.19075 .08822 L
s
gsave
.17227 .08403 -151.25 -10.9779 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Netherlands) show
142.062 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.950 1.000 0.000 setrgbcolor
(\\346) show
149.250 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.17603 .10187 m
.18412 .10369 L
s
gsave
.16563 .09953 -151.25 -11.196 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Switzerland) show
142.062 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.752 1.000 0.000 setrgbcolor
(\\346) show
149.250 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1695 .11711 m
.1776 .11891 L
s
gsave
.1591 .11479 -122.5 -10.955 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Denmark) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.554 1.000 0.000 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.16308 .13209 m
.17118 .13388 L
s
gsave
.15267 .12979 -115.312 -10.9439 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(France) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.356 1.000 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15676 .14684 m
.16486 .14862 L
s
gsave
.14634 .14456 -136.875 -11.1616 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Australia) show
127.688 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.158 1.000 0.000 setrgbcolor
(\\346) show
134.875 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15054 .16136 m
.15864 .16312 L
s
gsave
.14012 .1591 -172.812 -11.1504 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(United) show
113.312 12.875 moveto
(Kingdom) show
163.625 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.040 setrgbcolor
(\\346) show
170.812 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.14441 .17565 m
.15252 .1774 L
s
gsave
.13399 .17341 -115.312 -10.9117 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Canada) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.238 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13838 .18972 m
.14649 .19145 L
s
gsave
.12796 .1875 -122.5 -10.9013 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ireland) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.436 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13245 .20357 m
.14056 .20529 L
s
gsave
.12202 .20136 -122.5 -10.8911 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Germany) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.634 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1266 .21721 m
.13472 .21891 L
s
gsave
.11617 .21502 -144.062 -10.8811 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Luxembourg) show
134.875 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.832 setrgbcolor
(\\346) show
142.062 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.12085 .23064 m
.12896 .23233 L
s
gsave
.11041 .22847 -151.25 -10.8712 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(New) show
91.750 12.500 moveto
(Zealand) show
142.062 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.970 1.000 setrgbcolor
(\\346) show
149.250 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.11518 .24387 m
.1233 .24555 L
s
gsave
.10473 .24172 -122.5 -11.0877 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Belgium) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.772 1.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10959 .25691 m
.11771 .25857 L
s
gsave
.09915 .25477 -172.812 -11.0778 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Czech) show
106.125 12.875 moveto
(Republic) show
163.625 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.574 1.000 setrgbcolor
(\\346) show
170.812 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10409 .26975 m
.11221 .2714 L
s
gsave
.09364 .26762 -122.5 -11.0681 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Austria) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.376 1.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.09867 .2824 m
.1068 .28403 L
s
gsave
.08822 .28029 -108.125 -11.0586 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Spain) show
98.938 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.178 1.000 setrgbcolor
(\\346) show
106.125 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.09333 .29486 m
.10146 .29649 L
s
gsave
.08287 .29277 -165.625 -11.0492 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(United) show
113.312 12.875 moveto
(States) show
156.438 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.020 0.000 1.000 setrgbcolor
(\\346) show
163.625 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08806 .30714 m
.0962 .30876 L
s
gsave
.0776 .30507 -108.125 -10.8153 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Italy) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.218 0.000 1.000 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08287 .31925 m
.09101 .32085 L
s
gsave
.07241 .31719 -115.312 -10.8065 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Greece) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.416 0.000 1.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07776 .33119 m
.0859 .33277 L
s
gsave
.06729 .32914 -180 -11.0219 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Slovak) show
113.312 12.875 moveto
(Republic) show
170.812 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.614 0.000 1.000 setrgbcolor
(\\346) show
178.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07272 .34295 m
.08086 .34453 L
s
gsave
.06225 .34092 -122.5 -10.7892 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hungary) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.812 0.000 1.000 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.06775 .35455 m
.07589 .35611 L
s
gsave
.05728 .35254 -108.125 -10.7808 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Korea) show
98.938 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.990 setrgbcolor
(\\346) show
106.125 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.06285 .36598 m
.07099 .36754 L
s
gsave
.05237 .36399 -129.688 -10.7726 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Portugal) show
120.500 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.792 setrgbcolor
(\\346) show
127.688 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.05801 .37726 m
.06616 .3788 L
s
gsave
.04754 .37528 -115.312 -10.7644 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poland) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.594 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.05325 .38838 m
.0614 .38991 L
s
gsave
.04277 .38641 -115.312 -10.9791 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mexico) show
106.125 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.396 setrgbcolor
(\\346) show
113.312 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04855 .39935 m
.0567 .40087 L
s
gsave
.03807 .39739 -115.312 -10.7484 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Turkey) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.198 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.18462 .72262 L
s
.22414 0 m
.23134 .00172 L
s
[(0)] .20973 -0.00343 1 .23837 Mshowa
.21572 .15384 m
.22296 .15543 L
s
[(50)] .20126 .15066 1 .2197 Mshowa
.20669 .319 m
.21395 .32045 L
s
[(100)] .19217 .3161 1 .19969 Mshowa
.19697 .49678 m
.20426 .49808 L
s
[(150)] .18239 .49418 1 .1782 Mshowa
.18648 .68868 m
.19379 .68981 L
s
[(200)] .17185 .68641 1 .15506 Mshowa
.125 Mabswid
.2225 .02992 m
.22683 .03093 L
s
.22084 .06025 m
.22517 .06125 L
s
.21916 .09101 m
.22349 .092 L
s
.21745 .12221 m
.22179 .12318 L
s
.21397 .18593 m
.21831 .18687 L
s
.21219 .21848 m
.21654 .2194 L
s
.21038 .2515 m
.21473 .25241 L
s
.20855 .28501 m
.2129 .28589 L
s
.20481 .3535 m
.20917 .35436 L
s
.20289 .38852 m
.20725 .38936 L
s
.20095 .42406 m
.20531 .42488 L
s
.19897 .46015 m
.20334 .46094 L
s
.19494 .53398 m
.19931 .53474 L
s
.19287 .57175 m
.19725 .57249 L
s
.19077 .61012 m
.19516 .61084 L
s
.18864 .64909 m
.19303 .64979 L
s
.4 g
.25 Mabswid
.22084 .06025 m
.0481 .45253 L
s
.21745 .12221 m
.04348 .50612 L
s
.21397 .18593 m
.03875 .56092 L
s
.21038 .2515 m
.03391 .61698 L
s
.20669 .319 m
.02896 .67433 L
s
.20289 .38852 m
.0239 .73303 L
s
.19897 .46015 m
.01871 .79312 L
s
.19494 .53398 m
.01341 .85466 L
s
.19077 .61012 m
.00797 .91769 L
s
.05262 .40011 m
0 1.01003 L
s
.0481 .45253 m
.63937 .55912 L
s
.04348 .50612 m
.64123 .61006 L
s
.03875 .56092 m
.64312 .66207 L
s
.03391 .61698 m
.64505 .71518 L
s
.02896 .67433 m
.64703 .76944 L
s
.0239 .73303 m
.64905 .82487 L
s
.01871 .79312 m
.65111 .88153 L
s
.01341 .85466 m
.65322 .93944 L
s
.00797 .91769 m
.65537 .99864 L
s
0 0 m
1 0 L
1 1.0852 L
0 1.0852 L
closepath
clip
newpath
.60226 .50264 m .61567 .50129 L .61288 .50462 L .954 0 .189 r
F
.61444 .55425 m .61567 .50129 L .61288 .50462 L .791 0 .157 r
F
.59161 .50065 m .59436 .4973 L .60226 .50264 L .954 0 .189 r
F
.60226 .50264 m .59436 .4973 L .61567 .50129 L F
.61602 .60491 m .61567 .50129 L .61444 .55425 L .791 0 .157 r
F
.61602 .60491 m .61888 .60174 L .61567 .50129 L F
.59436 .4973 m .61888 .60174 L .61567 .50129 L .977 0 .193 r
F
.59295 .55037 m .59436 .4973 L .59161 .50065 L .784 0 .155 r
F
.60228 .48764 m .61807 .49842 L .59672 .49442 L .954 0 .378 r
F
.60228 .48764 m .62371 .49168 L .61807 .49842 L F
.59672 .49442 m .6201 .56102 L .61807 .49842 L .977 0 .387 r
F
.62371 .49168 m .61807 .49842 L .6201 .56102 L .791 0 .313 r
F
.56664 .49599 m .58008 .49463 L .57736 .49799 L .954 0 .189 r
F
.57858 .54854 m .58008 .49463 L .57736 .49799 L .78 0 .154 r
F
.59436 .4973 m .59713 .59794 L .61888 .60174 L .977 0 .193 r
F
.59432 .60113 m .59436 .4973 L .59295 .55037 L .784 0 .155 r
F
.59432 .60113 m .59713 .59794 L .59436 .4973 L F
.5559 .49399 m .55858 .49061 L .56664 .49599 L .954 0 .189 r
F
.56664 .49599 m .55858 .49061 L .58008 .49463 L F
.57982 .60015 m .58008 .49463 L .57858 .54854 L .78 0 .154 r
F
.57982 .60015 m .5826 .59696 L .58008 .49463 L F
.55858 .49061 m .5826 .59696 L .58008 .49463 L .977 0 .193 r
F
.59672 .49442 m .59848 .55714 L .6201 .56102 L .977 0 .387 r
F
.60228 .48764 m .59672 .49442 L .59848 .55714 L .784 0 .311 r
F
.55689 .54463 m .55858 .49061 L .5559 .49399 L .772 0 .153 r
F
.5663 .48086 m .58242 .49174 L .56088 .4877 L .954 0 .378 r
F
.5663 .48086 m .58792 .48494 L .58242 .49174 L F
.56088 .4877 m .58407 .55709 L .58242 .49174 L .977 0 .387 r
F
.58792 .48494 m .58242 .49174 L .58407 .55709 L .78 0 .309 r
F
.62371 .49168 m .6201 .56102 L .62582 .55448 L .791 0 .313 r
F
.60228 .48764 m .62582 .55448 L .62371 .49168 L .977 0 .387 r
F
.53071 .48929 m .54417 .48791 L .54152 .49131 L .954 0 .189 r
F
.54242 .54507 m .54417 .48791 L .54152 .49131 L .767 0 .152 r
F
.55858 .49061 m .56064 .59313 L .5826 .59696 L .977 0 .193 r
F
.5579 .59635 m .55858 .49061 L .55689 .54463 L .772 0 .153 r
F
.5579 .59635 m .56064 .59313 L .55858 .49061 L F
.51986 .48727 m .52247 .48386 L .53071 .48929 L .954 0 .189 r
F
.53071 .48929 m .52247 .48386 L .54417 .48791 L F
.6103 .47786 m .62614 .48878 L .60467 .48472 L .954 0 .567 r
F
.6103 .47786 m .63185 .48195 L .62614 .48878 L F
.60467 .48472 m .62683 .50905 L .62614 .48878 L .977 0 .58 r
F
.63185 .48195 m .62614 .48878 L .62683 .50905 L .791 0 .47 r
F
.54333 .60004 m .54417 .48791 L .54242 .54507 L .767 0 .152 r
F
.54333 .60004 m .54605 .59682 L .54417 .48791 L F
.52247 .48386 m .54605 .59682 L .54417 .48791 L .977 0 .193 r
F
.56088 .4877 m .56224 .55318 L .58407 .55709 L .977 0 .387 r
F
.5663 .48086 m .56088 .4877 L .56224 .55318 L .772 0 .306 r
F
.60228 .48764 m .60412 .55056 L .62582 .55448 L .977 0 .387 r
F
.60228 .48764 m .59848 .55714 L .60412 .55056 L .784 0 .311 r
F
.52052 .54113 m .52247 .48386 L .51986 .48727 L .759 0 .15 r
F
.53 .47402 m .54646 .48499 L .52472 .48092 L .954 0 .378 r
F
.53 .47402 m .55182 .47814 L .54646 .48499 L F
.52472 .48092 m .54766 .55313 L .54646 .48499 L .977 0 .387 r
F
.55182 .47814 m .54646 .48499 L .54766 .55313 L .767 0 .304 r
F
.58792 .48494 m .58407 .55709 L .58965 .5505 L .78 0 .309 r
F
.5663 .48086 m .58965 .5505 L .58792 .48494 L .977 0 .387 r
F
.60467 .48472 m .60528 .50504 L .62683 .50905 L .977 0 .58 r
F
.6103 .47786 m .60467 .48472 L .60528 .50504 L .784 0 .466 r
F
.49445 .48253 m .50794 .48114 L .50536 .48456 L .954 0 .189 r
F
.50585 .53811 m .50794 .48114 L .50536 .48456 L .753 0 .149 r
F
.52247 .48386 m .52386 .59297 L .54605 .59682 L .977 0 .193 r
F
.52119 .5962 m .52247 .48386 L .52052 .54113 L .759 0 .15 r
F
.52119 .5962 m .52386 .59297 L .52247 .48386 L F
.4835 .48049 m .48604 .47704 L .49445 .48253 L .954 0 .189 r
F
.49445 .48253 m .48604 .47704 L .50794 .48114 L F
.61093 .49824 m .62683 .50905 L .60528 .50504 L .952 0 .566 r
F
.63185 .48195 m .62683 .50905 L .63257 .50229 L .791 0 .47 r
F
.61093 .49824 m .63257 .50229 L .62683 .50905 L .952 0 .566 r
F
.57412 .47099 m .5903 .48201 L .56864 .47792 L .954 0 .567 r
F
.57412 .47099 m .59587 .47512 L .5903 .48201 L F
.56864 .47792 m .5909 .50437 L .5903 .48201 L .977 0 .58 r
F
.59587 .47512 m .5903 .48201 L .5909 .50437 L .78 0 .463 r
F
.6103 .47786 m .63257 .50229 L .63185 .48195 L .976 0 .58 r
F
.50635 .59286 m .50794 .48114 L .50585 .53811 L .753 0 .149 r
F
.50635 .59286 m .50899 .58961 L .50794 .48114 L F
.48604 .47704 m .50899 .58961 L .50794 .48114 L .977 0 .193 r
F
.52472 .48092 m .52562 .54918 L .54766 .55313 L .977 0 .387 r
F
.53 .47402 m .52472 .48092 L .52562 .54918 L .759 0 .3 r
F
.5663 .48086 m .56773 .54655 L .58965 .5505 L .977 0 .387 r
F
.5663 .48086 m .56224 .55318 L .56773 .54655 L .772 0 .306 r
F
.48375 .53413 m .48604 .47704 L .4835 .48049 L .744 0 .147 r
F
.60412 .55056 m .6201 .56102 L .59848 .55714 L .948 0 .376 r
F
.60412 .55056 m .62582 .55448 L .6201 .56102 L F
.61843 .46795 m .63431 .47901 L .61273 .4749 L .954 0 .756 r
F
.61843 .46795 m .6401 .47209 L .63431 .47901 L F
.61273 .4749 m .63481 .49282 L .63431 .47901 L .976 0 .773 r
F
.6401 .47209 m .63431 .47901 L .63481 .49282 L .791 0 .627 r
F
.6103 .47786 m .60528 .50504 L .61093 .49824 L .784 0 .466 r
F
.49336 .46712 m .51016 .47819 L .48823 .47408 L .954 0 .378 r
F
.49336 .46712 m .51538 .47127 L .51016 .47819 L F
.48823 .47408 m .51089 .54963 L .51016 .47819 L .977 0 .387 r
F
.51538 .47127 m .51016 .47819 L .51089 .54963 L .753 0 .298 r
F
.55182 .47814 m .54766 .55313 L .5531 .54649 L .767 0 .304 r
F
.53 .47402 m .5531 .54649 L .55182 .47814 L .977 0 .387 r
F
.56864 .47792 m .56914 .50032 L .5909 .50437 L .977 0 .58 r
F
.57412 .47099 m .56864 .47792 L .56914 .50032 L .772 0 .459 r
F
.6103 .47786 m .61093 .49824 L .63257 .50229 L .976 0 .58 r
F
.45786 .4757 m .47138 .4743 L .46887 .47776 L .954 0 .189 r
F
.46896 .53352 m .47138 .4743 L .46887 .47776 L .738 0 .146 r
F
.48604 .47704 m .4866 .58572 L .50899 .58961 L .977 0 .193 r
F
.48401 .58899 m .48604 .47704 L .48375 .53413 L .744 0 .147 r
F
.48401 .58899 m .4866 .58572 L .48604 .47704 L F
.44681 .47364 m .44928 .47017 L .45786 .4757 L .954 0 .189 r
F
.45786 .4757 m .44928 .47017 L .47138 .4743 L F
.53762 .46406 m .55413 .47518 L .53227 .47105 L .954 0 .567 r
F
.53762 .46406 m .55956 .46823 L .55413 .47518 L F
.53227 .47105 m .55459 .49913 L .55413 .47518 L .977 0 .58 r
F
.55956 .46823 m .55413 .47518 L .55459 .49913 L .767 0 .455 r
F
.59587 .47512 m .5909 .50437 L .5965 .49755 L .78 0 .463 r
F
.57412 .47099 m .5965 .49755 L .59587 .47512 L .976 0 .58 r
F
.57465 .49347 m .5909 .50437 L .56914 .50032 L .952 0 .566 r
F
.57465 .49347 m .5965 .49755 L .5909 .50437 L F
.61273 .4749 m .61316 .48874 L .63481 .49282 L .976 0 .773 r
F
.61843 .46795 m .61273 .4749 L .61316 .48874 L .784 0 .621 r
F
.61889 .48183 m .63481 .49282 L .61316 .48874 L .953 0 .755 r
F
.6401 .47209 m .63481 .49282 L .64061 .48595 L .791 0 .627 r
F
.61889 .48183 m .64061 .48595 L .63481 .49282 L .953 0 .755 r
F
.46905 .59059 m .47138 .4743 L .46896 .53352 L .738 0 .146 r
F
.46905 .59059 m .47162 .58732 L .47138 .4743 L F
.44928 .47017 m .47162 .58732 L .47138 .4743 L .977 0 .193 r
F
.48823 .47408 m .48863 .54566 L .51089 .54963 L .977 0 .387 r
F
.49336 .46712 m .48823 .47408 L .48863 .54566 L .744 0 .295 r
F
.53 .47402 m .53097 .5425 L .5531 .54649 L .977 0 .387 r
F
.53 .47402 m .52562 .54918 L .53097 .5425 L .759 0 .3 r
F
.60518 .60302 m .61888 .60174 L .61602 .60491 L .944 0 .187 r
F
.44665 .52951 m .44928 .47017 L .44681 .47364 L .728 0 .144 r
F
.58205 .46099 m .59827 .47215 L .57649 .46801 L .954 0 .756 r
F
.58205 .46099 m .60392 .46517 L .59827 .47215 L F
.57649 .46801 m .59868 .48626 L .59827 .47215 L .976 0 .773 r
F
.60392 .46517 m .59827 .47215 L .59868 .48626 L .78 0 .617 r
F
.61843 .46795 m .64061 .48595 L .6401 .47209 L .976 0 .773 r
F
.59432 .60113 m .59713 .59794 L .60518 .60302 L .944 0 .187 r
F
.60518 .60302 m .59713 .59794 L .61888 .60174 L F
.56773 .54655 m .58407 .55709 L .56224 .55318 L .948 0 .375 r
F
.56773 .54655 m .58965 .5505 L .58407 .55709 L F
.45639 .46015 m .47354 .47133 L .4514 .46718 L .954 0 .378 r
F
.45639 .46015 m .47861 .46434 L .47354 .47133 L F
.4514 .46718 m .47373 .5461 L .47354 .47133 L .977 0 .387 r
F
.47861 .46434 m .47354 .47133 L .47373 .5461 L .738 0 .292 r
F
.51538 .47127 m .51089 .54963 L .51619 .54294 L .753 0 .298 r
F
.49336 .46712 m .51619 .54294 L .51538 .47127 L .977 0 .387 r
F
.53227 .47105 m .53263 .49504 L .55459 .49913 L .977 0 .58 r
F
.53762 .46406 m .53227 .47105 L .53263 .49504 L .759 0 .451 r
F
.57412 .47099 m .57465 .49347 L .5965 .49755 L .976 0 .58 r
F
.57412 .47099 m .56914 .50032 L .57465 .49347 L .772 0 .459 r
F
.42093 .46881 m .43448 .4674 L .43205 .47089 L .954 0 .189 r
F
.43169 .52889 m .43448 .4674 L .43205 .47089 L .721 0 .143 r
F
.61843 .46795 m .61316 .48874 L .61889 .48183 L .784 0 .621 r
F
.44928 .47017 m .449 .58341 L .47162 .58732 L .977 0 .193 r
F
.44648 .5867 m .44928 .47017 L .44665 .52951 L .728 0 .144 r
F
.44648 .5867 m .449 .58341 L .44928 .47017 L F
.62667 .45791 m .64259 .46911 L .62089 .46495 L .954 0 .945 r
F
.62667 .45791 m .64846 .46211 L .64259 .46911 L F
.62667 .45791 m .64259 .46911 L .62089 .46495 L F
.62667 .45791 m .64846 .46211 L .64259 .46911 L F
.40979 .46674 m .41218 .46323 L .42093 .46881 L .954 0 .189 r
F
.42093 .46881 m .41218 .46323 L .43448 .4674 L F
.50078 .45707 m .51763 .46828 L .49557 .46412 L .954 0 .567 r
F
.50078 .45707 m .52292 .46127 L .51763 .46828 L F
.49557 .46412 m .51794 .49409 L .51763 .46828 L .977 0 .58 r
F
.52292 .46127 m .51763 .46828 L .51794 .49409 L .753 0 .447 r
F
.55956 .46823 m .55459 .49913 L .56005 .49225 L .767 0 .455 r
F
.53762 .46406 m .56005 .49225 L .55956 .46823 L .976 0 .58 r
F
.57649 .46801 m .57683 .48214 L .59868 .48626 L .976 0 .773 r
F
.58205 .46099 m .57649 .46801 L .57683 .48214 L .772 0 .611 r
F
.61843 .46795 m .61889 .48183 L .64061 .48595 L .976 0 .773 r
F
.58241 .47517 m .59868 .48626 L .57683 .48214 L .953 0 .755 r
F
.60392 .46517 m .59868 .48626 L .60434 .47933 L .78 0 .617 r
F
.58241 .47517 m .60434 .47933 L .59868 .48626 L .953 0 .755 r
F
.538 .48813 m .55459 .49913 L .53263 .49504 L .952 0 .565 r
F
.538 .48813 m .56005 .49225 L .55459 .49913 L F
.43133 .5883 m .43448 .4674 L .43169 .52889 L .721 0 .143 r
F
.43133 .5883 m .43383 .58501 L .43448 .4674 L F
.41218 .46323 m .43383 .58501 L .43448 .4674 L .977 0 .193 r
F
.4514 .46718 m .45125 .5421 L .47373 .5461 L .977 0 .387 r
F
.45639 .46015 m .4514 .46718 L .45125 .5421 L .728 0 .288 r
F
.49336 .46712 m .49384 .53893 L .51619 .54294 L .977 0 .387 r
F
.49336 .46712 m .48863 .54566 L .49384 .53893 L .744 0 .295 r
F
.40917 .52485 m .41218 .46323 L .40979 .46674 L .71 0 .141 r
F
.56887 .59825 m .5826 .59696 L .57982 .60015 L .944 0 .187 r
F
.54534 .45397 m .5619 .46523 L .53992 .46105 L .954 0 .756 r
F
.54534 .45397 m .56741 .45819 L .5619 .46523 L F
.53992 .46105 m .56222 .4804 L .5619 .46523 L .976 0 .773 r
F
.56741 .45819 m .5619 .46523 L .56222 .4804 L .767 0 .607 r
F
.58205 .46099 m .60434 .47933 L .60392 .46517 L .976 0 .773 r
F
.5579 .59635 m .56064 .59313 L .56887 .59825 L .944 0 .187 r
F
.56887 .59825 m .56064 .59313 L .5826 .59696 L F
.41908 .45312 m .43658 .4644 L .41424 .46021 L .954 0 .378 r
F
.41908 .45312 m .44151 .45735 L .43658 .4644 L F
.41424 .46021 m .43618 .54254 L .43658 .4644 L .977 0 .387 r
F
.44151 .45735 m .43658 .4644 L .43618 .54254 L .721 0 .286 r
F
.47861 .46434 m .47373 .5461 L .47888 .53936 L .738 0 .292 r
F
.45639 .46015 m .47888 .53936 L .47861 .46434 L .977 0 .387 r
F
.49557 .46412 m .49576 .48997 L .51794 .49409 L .977 0 .58 r
F
.50078 .45707 m .49557 .46412 L .49576 .48997 L .744 0 .442 r
F
.53762 .46406 m .538 .48813 L .56005 .49225 L .976 0 .58 r
F
.53762 .46406 m .53263 .49504 L .538 .48813 L .759 0 .451 r
F
.38367 .46186 m .39725 .46044 L .39489 .46395 L .954 0 .189 r
F
.39405 .52434 m .39725 .46044 L .39489 .46395 L .703 0 .139 r
F
.53097 .5425 m .54766 .55313 L .52562 .54918 L .948 0 .375 r
F
.53097 .5425 m .5531 .54649 L .54766 .55313 L F
.58205 .46099 m .57683 .48214 L .58241 .47517 L .772 0 .611 r
F
.41218 .46323 m .41098 .58107 L .43383 .58501 L .977 0 .193 r
F
.40853 .58438 m .41218 .46323 L .40917 .52485 L .71 0 .141 r
F
.40853 .58438 m .41098 .58107 L .41218 .46323 L F
.59009 .45085 m .60636 .46216 L .58445 .45796 L .954 0 .945 r
F
.59009 .45085 m .61208 .45509 L .60636 .46216 L F
.59009 .45085 m .60636 .46216 L .58445 .45796 L F
.59009 .45085 m .61208 .45509 L .60636 .46216 L F
.37243 .45977 m .37474 .45623 L .38367 .46186 L .954 0 .189 r
F
.38367 .46186 m .37474 .45623 L .39725 .46044 L F
.46359 .45001 m .4808 .46133 L .45854 .45712 L .954 0 .567 r
F
.46359 .45001 m .48594 .45425 L .4808 .46133 L F
.45854 .45712 m .48093 .49233 L .4808 .46133 L .977 0 .58 r
F
.48594 .45425 m .4808 .46133 L .48093 .49233 L .738 0 .438 r
F
.52292 .46127 m .51794 .49409 L .52325 .48716 L .753 0 .447 r
F
.50078 .45707 m .52325 .48716 L .52292 .46127 L .976 0 .58 r
F
.53992 .46105 m .54017 .47624 L .56222 .4804 L .976 0 .773 r
F
.54534 .45397 m .53992 .46105 L .54017 .47624 L .759 0 .601 r
F
.58205 .46099 m .58241 .47517 L .60434 .47933 L .976 0 .773 r
F
.3932 .58626 m .39725 .46044 L .39405 .52434 L .703 0 .139 r
F
.3932 .58626 m .39561 .58294 L .39725 .46044 L F
.37474 .45623 m .39561 .58294 L .39725 .46044 L .977 0 .193 r
F
.54561 .46921 m .56222 .4804 L .54017 .47624 L .953 0 .755 r
F
.56741 .45819 m .56222 .4804 L .56775 .4734 L .767 0 .607 r
F
.54561 .46921 m .56775 .4734 L .56222 .4804 L .953 0 .755 r
F
.41424 .46021 m .41348 .5385 L .43618 .54254 L .977 0 .387 r
F
.41908 .45312 m .41424 .46021 L .41348 .5385 L .71 0 .281 r
F
.45639 .46015 m .45631 .53532 L .47888 .53936 L .977 0 .387 r
F
.45639 .46015 m .45125 .5421 L .45631 .53532 L .728 0 .288 r
F
.50099 .483 m .51794 .49409 L .49576 .48997 L .952 0 .565 r
F
.50099 .483 m .52325 .48716 L .51794 .49409 L F
.37131 .52026 m .37474 .45623 L .37243 .45977 L .691 0 .137 r
F
.63502 .44773 m .65099 .45908 L .62916 .45487 L .775 0 .954 r
F
.63502 .44773 m .65692 .45199 L .65099 .45908 L F
.62916 .45487 m .65191 .48244 L .65099 .45908 L .792 0 .976 r
F
.65692 .45199 m .65099 .45908 L .65191 .48244 L .643 0 .791 r
F
.50829 .44688 m .5252 .45825 L .50302 .45403 L .954 0 .756 r
F
.50829 .44688 m .53056 .45114 L .5252 .45825 L F
.50302 .45403 m .52542 .47448 L .5252 .45825 L .976 0 .773 r
F
.53056 .45114 m .5252 .45825 L .52542 .47448 L .753 0 .596 r
F
.54534 .45397 m .56775 .4734 L .56741 .45819 L .976 0 .773 r
F
.53227 .59812 m .54605 .59682 L .54333 .60004 L .943 0 .187 r
F
.38142 .44603 m .39928 .45741 L .37674 .45318 L .954 0 .378 r
F
.38142 .44603 m .40406 .45029 L .39928 .45741 L F
.37674 .45318 m .39824 .53815 L .39928 .45741 L .977 0 .387 r
F
.40406 .45029 m .39928 .45741 L .39824 .53815 L .703 0 .278 r
F
.44151 .45735 m .43618 .54254 L .44118 .53574 L .721 0 .286 r
F
.41908 .45312 m .44118 .53574 L .44151 .45735 L .977 0 .387 r
F
.45854 .45712 m .45852 .48818 L .48093 .49233 L .977 0 .58 r
F
.46359 .45001 m .45854 .45712 L .45852 .48818 L .728 0 .432 r
F
.50078 .45707 m .50099 .483 L .52325 .48716 L .976 0 .58 r
F
.50078 .45707 m .49576 .48997 L .50099 .483 L .744 0 .442 r
F
.34607 .45485 m .35967 .45341 L .35739 .45696 L .954 0 .189 r
F
.35591 .52494 m .35967 .45341 L .35739 .45696 L .683 0 .135 r
F
.37474 .45623 m .37253 .57897 L .39561 .58294 L .977 0 .193 r
F
.37016 .5823 m .37474 .45623 L .37131 .52026 L .691 0 .137 r
F
.37016 .5823 m .37253 .57897 L .37474 .45623 L F
.54534 .45397 m .54017 .47624 L .54561 .46921 L .759 0 .601 r
F
.49384 .53893 m .51089 .54963 L .48863 .54566 L .947 0 .375 r
F
.49384 .53893 m .51619 .54294 L .51089 .54963 L F
.52119 .5962 m .52386 .59297 L .53227 .59812 L .943 0 .187 r
F
.53227 .59812 m .52386 .59297 L .54605 .59682 L F
.55317 .44374 m .56978 .45515 L .54768 .45091 L .954 0 .945 r
F
.55317 .44374 m .57536 .44802 L .56978 .45515 L F
.55317 .44374 m .56978 .45515 L .54768 .45091 L F
.55317 .44374 m .57536 .44802 L .56978 .45515 L F
.62916 .45487 m .62998 .47827 L .65191 .48244 L .792 0 .976 r
F
.63502 .44773 m .62916 .45487 L .62998 .47827 L .637 0 .784 r
F
.33472 .45273 m .33696 .44916 L .34607 .45485 L .954 0 .189 r
F
.34607 .45485 m .33696 .44916 L .35967 .45341 L F
.42607 .44288 m .44363 .45431 L .42116 .45007 L .954 0 .567 r
F
.42607 .44288 m .44862 .44717 L .44363 .45431 L F
.42116 .45007 m .4435 .489 L .44363 .45431 L .977 0 .58 r
F
.44862 .44717 m .44363 .45431 L .4435 .489 L .721 0 .428 r
F
.48594 .45425 m .48093 .49233 L .4861 .48535 L .738 0 .438 r
F
.46359 .45001 m .4861 .48535 L .48594 .45425 L .976 0 .58 r
F
.50302 .45403 m .50316 .47029 L .52542 .47448 L .976 0 .773 r
F
.50829 .44688 m .50302 .45403 L .50316 .47029 L .744 0 .589 r
F
.54534 .45397 m .54561 .46921 L .56775 .4734 L .976 0 .773 r
F
.3544 .59487 m .35967 .45341 L .35591 .52494 L .683 0 .135 r
F
.3544 .59487 m .35674 .59155 L .35967 .45341 L F
.33696 .44916 m .35674 .59155 L .35967 .45341 L .977 0 .193 r
F
.37674 .45318 m .37531 .53408 L .39824 .53815 L .977 0 .387 r
F
.38142 .44603 m .37674 .45318 L .37531 .53408 L .691 0 .274 r
F
.41908 .45312 m .41839 .53167 L .44118 .53574 L .977 0 .387 r
F
.41908 .45312 m .41348 .5385 L .41839 .53167 L .71 0 .281 r
F
.50845 .46319 m .52542 .47448 L .50316 .47029 L .953 0 .755 r
F
.53056 .45114 m .52542 .47448 L .5308 .46742 L .753 0 .596 r
F
.50845 .46319 m .5308 .46742 L .52542 .47448 L .953 0 .755 r
F
.33292 .52084 m .33696 .44916 L .33472 .45273 L .67 0 .133 r
F
.59823 .44058 m .61454 .45204 L .59252 .44779 L .775 0 .954 r
F
.59823 .44058 m .62034 .44488 L .61454 .45204 L F
.59252 .44779 m .61523 .47343 L .61454 .45204 L .792 0 .976 r
F
.62034 .44488 m .61454 .45204 L .61523 .47343 L .633 0 .78 r
F
.65692 .45199 m .65191 .48244 L .65788 .47542 L .643 0 .791 r
F
.63502 .44773 m .65788 .47542 L .65692 .45199 L .792 0 .975 r
F
.63587 .47121 m .65191 .48244 L .62998 .47827 L .773 0 .952 r
F
.63587 .47121 m .65788 .47542 L .65191 .48244 L F
.46361 .48116 m .48093 .49233 L .45852 .48818 L .951 0 .565 r
F
.46361 .48116 m .4861 .48535 L .48093 .49233 L F
.47089 .43973 m .48816 .4512 L .46577 .44694 L .954 0 .756 r
F
.47089 .43973 m .49337 .44403 L .48816 .4512 L F
.46577 .44694 m .48826 .46876 L .48816 .4512 L .976 0 .773 r
F
.49337 .44403 m .48816 .4512 L .48826 .46876 L .738 0 .584 r
F
.50829 .44688 m .5308 .46742 L .53056 .45114 L .976 0 .773 r
F
.49519 .59092 m .50899 .58961 L .50635 .59286 L .944 0 .187 r
F
.34342 .43887 m .36164 .45035 L .33889 .44609 L .954 0 .378 r
F
.34342 .43887 m .36626 .44317 L .36164 .45035 L F
.33889 .44609 m .35991 .53371 L .36164 .45035 L .977 0 .387 r
F
.36626 .44317 m .36164 .45035 L .35991 .53371 L .683 0 .27 r
F
.40406 .45029 m .39824 .53815 L .40309 .5313 L .703 0 .278 r
F
.38142 .44603 m .40309 .5313 L .40406 .45029 L .977 0 .387 r
F
.42116 .45007 m .42087 .48482 L .4435 .489 L .977 0 .58 r
F
.42607 .44288 m .42116 .45007 L .42087 .48482 L .71 0 .422 r
F
.46359 .45001 m .46361 .48116 L .4861 .48535 L .976 0 .58 r
F
.46359 .45001 m .45852 .48818 L .46361 .48116 L .728 0 .432 r
F
.30812 .44777 m .32175 .44632 L .31954 .4499 L .954 0 .189 r
F
.31756 .51666 m .32175 .44632 L .31954 .4499 L .661 0 .131 r
F
.33696 .44916 m .33337 .58757 L .35674 .59155 L .977 0 .193 r
F
.33107 .59091 m .33696 .44916 L .33292 .52084 L .67 0 .133 r
F
.33107 .59091 m .33337 .58757 L .33696 .44916 L F
.64347 .43742 m .65949 .44892 L .63754 .44465 L .586 0 .954 r
F
.64347 .43742 m .66551 .44173 L .65949 .44892 L F
.63754 .44465 m .6604 .47085 L .65949 .44892 L .599 0 .975 r
F
.66551 .44173 m .65949 .44892 L .6604 .47085 L .486 0 .791 r
F
.50829 .44688 m .50316 .47029 L .50845 .46319 L .744 0 .589 r
F
.48401 .58899 m .4866 .58572 L .49519 .59092 L .944 0 .187 r
F
.49519 .59092 m .4866 .58572 L .50899 .58961 L F
.5159 .43656 m .53287 .44807 L .51056 .4438 L .954 0 .945 r
F
.5159 .43656 m .5383 .44087 L .53287 .44807 L F
.5159 .43656 m .53287 .44807 L .51056 .4438 L F
.5159 .43656 m .5383 .44087 L .53287 .44807 L F
.59252 .44779 m .59311 .46922 L .61523 .47343 L .792 0 .976 r
F
.59823 .44058 m .59252 .44779 L .59311 .46922 L .627 0 .772 r
F
.29666 .44563 m .29882 .44203 L .30812 .44777 L .954 0 .189 r
F
.30812 .44777 m .29882 .44203 L .32175 .44632 L F
.45631 .53532 m .47373 .5461 L .45125 .5421 L .947 0 .375 r
F
.45631 .53532 m .47888 .53936 L .47373 .5461 L F
.63502 .44773 m .63587 .47121 L .65788 .47542 L .792 0 .975 r
F
.63502 .44773 m .62998 .47827 L .63587 .47121 L .637 0 .784 r
F
.38819 .43569 m .40612 .44722 L .38344 .44294 L .954 0 .567 r
F
.38819 .43569 m .41096 .44002 L .40612 .44722 L F
.38344 .44294 m .40567 .48589 L .40612 .44722 L .977 0 .58 r
F
.41096 .44002 m .40612 .44722 L .40567 .48589 L .703 0 .417 r
F
.44862 .44717 m .4435 .489 L .44853 .48197 L .721 0 .428 r
F
.42607 .44288 m .44853 .48197 L .44862 .44717 L .976 0 .58 r
F
.46577 .44694 m .46579 .46453 L .48826 .46876 L .976 0 .773 r
F
.47089 .43973 m .46577 .44694 L .46579 .46453 L .728 0 .576 r
F
.50829 .44688 m .50845 .46319 L .5308 .46742 L .976 0 .773 r
F
.31553 .58531 m .32175 .44632 L .31756 .51666 L .661 0 .131 r
F
.31553 .58531 m .31779 .58195 L .32175 .44632 L F
.29882 .44203 m .31779 .58195 L .32175 .44632 L .977 0 .193 r
F
.33889 .44609 m .33675 .52961 L .35991 .53371 L .977 0 .387 r
F
.34342 .43887 m .33889 .44609 L .33675 .52961 L .67 0 .265 r
F
.38142 .44603 m .38007 .52719 L .40309 .5313 L .977 0 .387 r
F
.38142 .44603 m .37531 .53408 L .38007 .52719 L .691 0 .274 r
F
.29436 .51252 m .29882 .44203 L .29666 .44563 L .646 0 .128 r
F
.47093 .45738 m .48826 .46876 L .46579 .46453 L .953 0 .754 r
F
.49337 .44403 m .48826 .46876 L .49349 .46164 L .738 0 .584 r
F
.47093 .45738 m .49349 .46164 L .48826 .46876 L .953 0 .754 r
F
.59884 .46208 m .61523 .47343 L .59311 .46922 L .773 0 .952 r
F
.62034 .44488 m .61523 .47343 L .62106 .46633 L .633 0 .78 r
F
.59884 .46208 m .62106 .46633 L .61523 .47343 L .773 0 .952 r
F
.5611 .43337 m .57777 .44494 L .55553 .44064 L .775 0 .954 r
F
.5611 .43337 m .58342 .43771 L .57777 .44494 L F
.55553 .44064 m .57837 .46973 L .57777 .44494 L .792 0 .976 r
F
.58342 .43771 m .57777 .44494 L .57837 .46973 L .623 0 .767 r
F
.59823 .44058 m .62106 .46633 L .62034 .44488 L .792 0 .975 r
F
.63754 .44465 m .63835 .46662 L .6604 .47085 L .599 0 .975 r
F
.64347 .43742 m .63754 .44465 L .63835 .46662 L .482 0 .784 r
F
.43315 .43251 m .45078 .44408 L .42818 .43979 L .954 0 .756 r
F
.43315 .43251 m .45584 .43685 L .45078 .44408 L F
.42818 .43979 m .45074 .46324 L .45078 .44408 L .976 0 .773 r
F
.45584 .43685 m .45078 .44408 L .45074 .46324 L .721 0 .571 r
F
.47089 .43973 m .49349 .46164 L .49337 .44403 L .976 0 .773 r
F
.30505 .43164 m .32365 .44323 L .30068 .43893 L .954 0 .378 r
F
.30505 .43164 m .32811 .43598 L .32365 .44323 L F
.30068 .43893 m .32117 .52923 L .32365 .44323 L .977 0 .387 r
F
.32811 .43598 m .32365 .44323 L .32117 .52923 L .661 0 .262 r
F
.42581 .47775 m .4435 .489 L .42087 .48482 L .951 0 .565 r
F
.42581 .47775 m .44853 .48197 L .4435 .489 L F
.36626 .44317 m .35991 .53371 L .3646 .52681 L .683 0 .27 r
F
.34342 .43887 m .3646 .52681 L .36626 .44317 L .977 0 .387 r
F
.38344 .44294 m .38281 .48168 L .40567 .48589 L .977 0 .58 r
F
.38819 .43569 m .38344 .44294 L .38281 .48168 L .691 0 .41 r
F
.42607 .44288 m .42581 .47775 L .44853 .48197 L .976 0 .58 r
F
.42607 .44288 m .42087 .48482 L .42581 .47775 L .71 0 .422 r
F
.26981 .44062 m .28347 .43916 L .28134 .44277 L .954 0 .189 r
F
.27869 .51328 m .28347 .43916 L .28134 .44277 L .636 0 .126 r
F
.45778 .58865 m .47162 .58732 L .46905 .59059 L .943 0 .187 r
F
.29882 .44203 m .29421 .57793 L .31779 .58195 L .977 0 .193 r
F
.29199 .58131 m .29882 .44203 L .29436 .51252 L .646 0 .128 r
F
.29199 .58131 m .29421 .57793 L .29882 .44203 L F
.64432 .45946 m .6604 .47085 L .63835 .46662 L .585 0 .952 r
F
.66551 .44173 m .6604 .47085 L .66645 .46373 L .486 0 .791 r
F
.64432 .45946 m .66645 .46373 L .6604 .47085 L .585 0 .952 r
F
.60648 .43017 m .62284 .44179 L .60069 .43748 L .586 0 .954 r
F
.60648 .43017 m .62872 .43453 L .62284 .44179 L F
.60069 .43748 m .62356 .46302 L .62284 .44179 L .599 0 .975 r
F
.62872 .43453 m .62284 .44179 L .62356 .46302 L .479 0 .78 r
F
.64347 .43742 m .66645 .46373 L .66551 .44173 L .599 0 .975 r
F
.47089 .43973 m .46579 .46453 L .47093 .45738 L .728 0 .576 r
F
.47829 .42931 m .49562 .44093 L .4731 .43661 L .954 0 .945 r
F
.47829 .42931 m .5009 .43366 L .49562 .44093 L F
.4731 .43661 m .49576 .46063 L .49562 .44093 L .976 0 .966 r
F
.5009 .43366 m .49562 .44093 L .49576 .46063 L .738 0 .73 r
F
.59823 .44058 m .59311 .46922 L .59884 .46208 L .627 0 .772 r
F
.55553 .44064 m .55603 .46548 L .57837 .46973 L .792 0 .976 r
F
.5611 .43337 m .55553 .44064 L .55603 .46548 L .616 0 .759 r
F
.25825 .43847 m .26033 .43483 L .26981 .44062 L .954 0 .189 r
F
.26981 .44062 m .26033 .43483 L .28347 .43916 L F
.59823 .44058 m .59884 .46208 L .62106 .46633 L .792 0 .975 r
F
.44648 .5867 m .449 .58341 L .45778 .58865 L .943 0 .187 r
F
.45778 .58865 m .449 .58341 L .47162 .58732 L F
.34996 .42844 m .36826 .44007 L .34537 .43575 L .954 0 .567 r
F
.34996 .42844 m .37294 .4328 L .36826 .44007 L F
.34537 .43575 m .36745 .48146 L .36826 .44007 L .977 0 .58 r
F
.37294 .4328 m .36826 .44007 L .36745 .48146 L .683 0 .405 r
F
.41096 .44002 m .40567 .48589 L .41055 .47881 L .703 0 .417 r
F
.38819 .43569 m .41055 .47881 L .41096 .44002 L .976 0 .58 r
F
.42818 .43979 m .42805 .45898 L .45074 .46324 L .976 0 .773 r
F
.43315 .43251 m .42818 .43979 L .42805 .45898 L .71 0 .562 r
F
.47089 .43973 m .47093 .45738 L .49349 .46164 L .976 0 .773 r
F
.41839 .53167 m .43618 .54254 L .41348 .5385 L .947 0 .375 r
F
.41839 .53167 m .44118 .53574 L .43618 .54254 L F
.27595 .5859 m .28347 .43916 L .27869 .51328 L .636 0 .126 r
F
.27595 .5859 m .27813 .58252 L .28347 .43916 L F
.26033 .43483 m .27813 .58252 L .28347 .43916 L .977 0 .193 r
F
.30068 .43893 m .29779 .5251 L .32117 .52923 L .977 0 .387 r
F
.30505 .43164 m .30068 .43893 L .29779 .5251 L .646 0 .256 r
F
.34342 .43887 m .34135 .52266 L .3646 .52681 L .977 0 .387 r
F
.34342 .43887 m .33675 .52961 L .34135 .52266 L .67 0 .265 r
F
.65205 .42696 m .6681 .43863 L .64603 .4343 L .397 0 .954 r
F
.65205 .42696 m .6742 .43134 L .6681 .43863 L F
.64603 .4343 m .66878 .45423 L .6681 .43863 L .406 0 .975 r
F
.6742 .43134 m .6681 .43863 L .66878 .45423 L .329 0 .791 r
F
.25525 .50911 m .26033 .43483 L .25825 .43847 L .621 0 .123 r
F
.43303 .45176 m .45074 .46324 L .42805 .45898 L .952 0 .754 r
F
.45584 .43685 m .45074 .46324 L .45581 .45606 L .721 0 .571 r
F
.43303 .45176 m .45581 .45606 L .45074 .46324 L .952 0 .754 r
F
.52362 .42609 m .54065 .43777 L .51821 .43343 L .775 0 .954 r
F
.52362 .42609 m .54615 .43047 L .54065 .43777 L F
.51821 .43343 m .54107 .46315 L .54065 .43777 L .792 0 .976 r
F
.54615 .43047 m .54065 .43777 L .54107 .46315 L .611 0 .753 r
F
.58342 .43771 m .57837 .46973 L .58405 .46258 L .623 0 .767 r
F
.5611 .43337 m .58405 .46258 L .58342 .43771 L .792 0 .975 r
F
.64347 .43742 m .63835 .46662 L .64432 .45946 L .482 0 .784 r
F
.60069 .43748 m .60131 .45874 L .62356 .46302 L .599 0 .975 r
F
.60648 .43017 m .60069 .43748 L .60131 .45874 L .474 0 .772 r
F
.64347 .43742 m .64432 .45946 L .66645 .46373 L .599 0 .975 r
F
.56162 .45829 m .57837 .46973 L .55603 .46548 L .773 0 .952 r
F
.56162 .45829 m .58405 .46258 L .57837 .46973 L F
.39505 .42522 m .41305 .43691 L .39024 .43257 L .954 0 .756 r
F
.39505 .42522 m .41795 .4296 L .41305 .43691 L F
.39024 .43257 m .41284 .45766 L .41305 .43691 L .976 0 .773 r
F
.41795 .4296 m .41305 .43691 L .41284 .45766 L .703 0 .557 r
F
.43315 .43251 m .45581 .45606 L .45584 .43685 L .976 0 .773 r
F
.4731 .43661 m .47315 .45635 L .49576 .46063 L .976 0 .966 r
F
.47829 .42931 m .4731 .43661 L .47315 .45635 L .728 0 .721 r
F
.26633 .42434 m .2853 .43604 L .26213 .4317 L .954 0 .378 r
F
.26633 .42434 m .28961 .42873 L .2853 .43604 L F
.26213 .4317 m .28204 .52471 L .2853 .43604 L .977 0 .387 r
F
.28961 .42873 m .2853 .43604 L .28204 .52471 L .636 0 .252 r
F
.32811 .43598 m .32117 .52923 L .32571 .52227 L .661 0 .262 r
F
.30505 .43164 m .32571 .52227 L .32811 .43598 L .977 0 .387 r
F
.34537 .43575 m .34436 .47721 L .36745 .48146 L .977 0 .58 r
F
.34996 .42844 m .34537 .43575 L .34436 .47721 L .67 0 .398 r
F
.38819 .43569 m .38759 .47456 L .41055 .47881 L .976 0 .58 r
F
.38819 .43569 m .38281 .48168 L .38759 .47456 L .691 0 .41 r
F
.23115 .43341 m .24484 .43193 L .24279 .43558 L .954 0 .189 r
F
.23937 .51027 m .24484 .43193 L .24279 .43558 L .61 0 .121 r
F
.60713 .45151 m .62356 .46302 L .60131 .45874 L .585 0 .952 r
F
.62872 .43453 m .62356 .46302 L .62946 .45582 L .479 0 .78 r
F
.60713 .45151 m .62946 .45582 L .62356 .46302 L .585 0 .952 r
F
.26033 .43483 m .25429 .57848 L .27813 .58252 L .977 0 .193 r
F
.25216 .58188 m .26033 .43483 L .25525 .50911 L .621 0 .123 r
F
.25216 .58188 m .25429 .57848 L .26033 .43483 L F
.38759 .47456 m .40567 .48589 L .38281 .48168 L .951 0 .565 r
F
.38759 .47456 m .41055 .47881 L .40567 .48589 L F
.56914 .42287 m .58586 .43459 L .5635 .43023 L .586 0 .954 r
F
.56914 .42287 m .59158 .42726 L .58586 .43459 L F
.5635 .43023 m .58645 .45717 L .58586 .43459 L .599 0 .975 r
F
.59158 .42726 m .58586 .43459 L .58645 .45717 L .471 0 .767 r
F
.47836 .4491 m .49576 .46063 L .47315 .45635 L .952 0 .943 r
F
.5009 .43366 m .49576 .46063 L .50106 .45342 L .738 0 .73 r
F
.47836 .4491 m .50106 .45342 L .49576 .46063 L .952 0 .943 r
F
.60648 .43017 m .62946 .45582 L .62872 .43453 L .599 0 .975 r
F
.64603 .4343 m .64664 .44993 L .66878 .45423 L .406 0 .975 r
F
.65205 .42696 m .64603 .4343 L .64664 .44993 L .326 0 .784 r
F
.41995 .58635 m .43383 .58501 L .43133 .5883 L .943 0 .187 r
F
.44032 .42199 m .45802 .43372 L .43529 .42937 L .954 0 .945 r
F
.44032 .42199 m .46315 .42639 L .45802 .43372 L F
.44032 .42199 m .45802 .43372 L .43529 .42937 L F
.44032 .42199 m .46315 .42639 L .45802 .43372 L F
.47829 .42931 m .50106 .45342 L .5009 .43366 L .976 0 .966 r
F
.43315 .43251 m .42805 .45898 L .43303 .45176 L .71 0 .562 r
F
.65268 .44265 m .66878 .45423 L .64664 .44993 L .396 0 .953 r
F
.6742 .43134 m .66878 .45423 L .6749 .44699 L .329 0 .791 r
F
.65268 .44265 m .6749 .44699 L .66878 .45423 L .396 0 .953 r
F
.51821 .43343 m .51851 .45887 L .54107 .46315 L .792 0 .976 r
F
.52362 .42609 m .51821 .43343 L .51851 .45887 L .604 0 .744 r
F
.21948 .43124 m .22148 .42756 L .23115 .43341 L .954 0 .189 r
F
.23115 .43341 m .22148 .42756 L .24484 .43193 L F
.5611 .43337 m .56162 .45829 L .58405 .46258 L .792 0 .975 r
F
.5611 .43337 m .55603 .46548 L .56162 .45829 L .616 0 .759 r
F
.31137 .42111 m .33004 .43286 L .30694 .4285 L .954 0 .567 r
F
.31137 .42111 m .33457 .42551 L .33004 .43286 L F
.30694 .4285 m .32881 .47749 L .33004 .43286 L .977 0 .58 r
F
.33457 .42551 m .33004 .43286 L .32881 .47749 L .661 0 .392 r
F
.37294 .4328 m .36745 .48146 L .37217 .47431 L .683 0 .405 r
F
.34996 .42844 m .37217 .47431 L .37294 .4328 L .976 0 .58 r
F
.39024 .43257 m .38993 .45336 L .41284 .45766 L .976 0 .773 r
F
.39505 .42522 m .39024 .43257 L .38993 .45336 L .691 0 .547 r
F
.43315 .43251 m .43303 .45176 L .45581 .45606 L .976 0 .773 r
F
.23584 .58732 m .24484 .43193 L .23937 .51027 L .61 0 .121 r
F
.23584 .58732 m .23794 .58392 L .24484 .43193 L F
.22148 .42756 m .23794 .58392 L .24484 .43193 L .977 0 .193 r
F
.26213 .4317 m .25842 .52053 L .28204 .52471 L .977 0 .387 r
F
.26633 .42434 m .26213 .4317 L .25842 .52053 L .621 0 .246 r
F
.40853 .58438 m .41098 .58107 L .41995 .58635 L .943 0 .187 r
F
.41995 .58635 m .41098 .58107 L .43383 .58501 L F
.30505 .43164 m .30222 .51809 L .32571 .52227 L .977 0 .387 r
F
.30505 .43164 m .29779 .5251 L .30222 .51809 L .646 0 .256 r
F
.38007 .52719 m .39824 .53815 L .37531 .53408 L .947 0 .375 r
F
.38007 .52719 m .40309 .5313 L .39824 .53815 L F
.61484 .41962 m .63125 .4314 L .60898 .42702 L .397 0 .954 r
F
.61484 .41962 m .63721 .42404 L .63125 .4314 L F
.60898 .42702 m .63182 .44731 L .63125 .4314 L .406 0 .975 r
F
.63721 .42404 m .63125 .4314 L .63182 .44731 L .324 0 .78 r
F
.65205 .42696 m .6749 .44699 L .6742 .43134 L .406 0 .975 r
F
.21569 .50606 m .22148 .42756 L .21948 .43124 L .592 0 .117 r
F
.60648 .43017 m .60131 .45874 L .60713 .45151 L .474 0 .772 r
F
.48579 .41874 m .50318 .43053 L .48053 .42615 L .775 0 .954 r
F
.48579 .41874 m .50853 .42316 L .50318 .43053 L F
.47829 .42931 m .47836 .4491 L .50106 .45342 L .976 0 .966 r
F
.48053 .42615 m .50342 .45858 L .50318 .43053 L .792 0 .976 r
F
.50853 .42316 m .50318 .43053 L .50342 .45858 L .599 0 .738 r
F
.54615 .43047 m .54107 .46315 L .5466 .45594 L .611 0 .753 r
F
.52362 .42609 m .5466 .45594 L .54615 .43047 L .792 0 .975 r
F
.5635 .43023 m .56398 .45286 L .58645 .45717 L .599 0 .975 r
F
.56914 .42287 m .5635 .43023 L .56398 .45286 L .466 0 .759 r
F
.47829 .42931 m .47315 .45635 L .47836 .4491 L .728 0 .721 r
F
.60648 .43017 m .60713 .45151 L .62946 .45582 L .599 0 .975 r
F
.39476 .44608 m .41284 .45766 L .38993 .45336 L .952 0 .754 r
F
.41795 .4296 m .41284 .45766 L .41776 .45042 L .703 0 .557 r
F
.39476 .44608 m .41776 .45042 L .41284 .45766 L .952 0 .754 r
F
.35659 .41786 m .37496 .42966 L .35194 .42528 L .954 0 .756 r
F
.35659 .41786 m .37971 .42228 L .37496 .42966 L F
.35194 .42528 m .37456 .45203 L .37496 .42966 L .976 0 .773 r
F
.37971 .42228 m .37496 .42966 L .37456 .45203 L .683 0 .541 r
F
.39505 .42522 m .41776 .45042 L .41795 .4296 L .976 0 .773 r
F
.52395 .45161 m .54107 .46315 L .51851 .45887 L .773 0 .952 r
F
.52395 .45161 m .5466 .45594 L .54107 .46315 L F
.65205 .42696 m .64664 .44993 L .65268 .44265 L .326 0 .784 r
F
.22725 .41698 m .2466 .42879 L .2232 .4244 L .954 0 .378 r
F
.22725 .41698 m .25074 .42141 L .2466 .42879 L F
.2232 .4244 m .24229 .52439 L .2466 .42879 L .977 0 .387 r
F
.25074 .42141 m .2466 .42879 L .24229 .52439 L .61 0 .241 r
F
.28961 .42873 m .28204 .52471 L .28641 .51768 L .636 0 .252 r
F
.26633 .42434 m .28641 .51768 L .28961 .42873 L .977 0 .387 r
F
.30694 .4285 m .30549 .47322 L .32881 .47749 L .977 0 .58 r
F
.31137 .42111 m .30694 .4285 L .30549 .47322 L .646 0 .384 r
F
.34996 .42844 m .34899 .47003 L .37217 .47431 L .976 0 .58 r
F
.34996 .42844 m .34436 .47721 L .34899 .47003 L .67 0 .398 r
F
.19213 .42613 m .20584 .42464 L .20388 .42832 L .954 0 .189 r
F
.19764 .54375 m .20584 .42464 L .20388 .42832 L .58 0 .115 r
F
.66074 .41637 m .67684 .42819 L .65464 .4238 L .208 0 .954 r
F
.66074 .41637 m .68302 .4208 L .67684 .42819 L F
.65464 .4238 m .67743 .44129 L .67684 .42819 L .212 0 .975 r
F
.68302 .4208 m .67684 .42819 L .67743 .44129 L .173 0 .791 r
F
.22148 .42756 m .21382 .57986 L .23794 .58392 L .977 0 .193 r
F
.21177 .58328 m .22148 .42756 L .21569 .50606 L .592 0 .117 r
F
.21177 .58328 m .21382 .57986 L .22148 .42756 L F
.53144 .41549 m .54852 .42732 L .52595 .42293 L .586 0 .954 r
F
.53144 .41549 m .5541 .41992 L .54852 .42732 L F
.52595 .42293 m .54893 .44972 L .54852 .42732 L .599 0 .975 r
F
.5541 .41992 m .54852 .42732 L .54893 .44972 L .462 0 .753 r
F
.59158 .42726 m .58645 .45717 L .5922 .44992 L .471 0 .767 r
F
.56914 .42287 m .5922 .44992 L .59158 .42726 L .599 0 .975 r
F
.56965 .44556 m .58645 .45717 L .56398 .45286 L .585 0 .952 r
F
.56965 .44556 m .5922 .44992 L .58645 .45717 L F
.60898 .42702 m .60947 .44297 L .63182 .44731 L .406 0 .975 r
F
.61484 .41962 m .60898 .42702 L .60947 .44297 L .321 0 .772 r
F
.65205 .42696 m .65268 .44265 L .6749 .44699 L .406 0 .975 r
F
.34899 .47003 m .36745 .48146 L .34436 .47721 L .95 0 .565 r
F
.34899 .47003 m .37217 .47431 L .36745 .48146 L F
.402 .4146 m .42007 .42645 L .39712 .42205 L .954 0 .945 r
F
.402 .4146 m .42504 .41904 L .42007 .42645 L F
.402 .4146 m .42007 .42645 L .39712 .42205 L F
.402 .4146 m .42504 .41904 L .42007 .42645 L F
.61536 .43562 m .63182 .44731 L .60947 .44297 L .396 0 .953 r
F
.63721 .42404 m .63182 .44731 L .6378 .44 L .324 0 .78 r
F
.61536 .43562 m .6378 .44 L .63182 .44731 L .396 0 .953 r
F
.48053 .42615 m .48064 .45426 L .50342 .45858 L .792 0 .976 r
F
.48579 .41874 m .48053 .42615 L .48064 .45426 L .591 0 .728 r
F
.18035 .42394 m .18227 .42023 L .19213 .42613 L .954 0 .189 r
F
.19213 .42613 m .18227 .42023 L .20584 .42464 L F
.52362 .42609 m .52395 .45161 L .5466 .45594 L .792 0 .975 r
F
.52362 .42609 m .51851 .45887 L .52395 .45161 L .604 0 .744 r
F
.39505 .42522 m .38993 .45336 L .39476 .44608 L .691 0 .547 r
F
.27241 .41371 m .29147 .42557 L .26815 .42117 L .954 0 .567 r
F
.27241 .41371 m .29583 .41816 L .29147 .42557 L F
.26815 .42117 m .28979 .4727 L .29147 .42557 L .977 0 .58 r
F
.29583 .41816 m .29147 .42557 L .28979 .4727 L .636 0 .378 r
F
.33457 .42551 m .32881 .47749 L .33337 .47029 L .661 0 .392 r
F
.31137 .42111 m .33337 .47029 L .33457 .42551 L .976 0 .58 r
F
.35194 .42528 m .35142 .4477 L .37456 .45203 L .976 0 .773 r
F
.35659 .41786 m .35194 .42528 L .35142 .4477 L .67 0 .53 r
F
.39505 .42522 m .39476 .44608 L .41776 .45042 L .976 0 .773 r
F
.38169 .58428 m .39561 .58294 L .3932 .58626 L .942 0 .187 r
F
.1911 .6649 m .20584 .42464 L .19764 .54375 L .58 0 .115 r
F
.1911 .6649 m .19313 .66162 L .20584 .42464 L F
.18227 .42023 m .19313 .66162 L .20584 .42464 L .977 0 .193 r
F
.2232 .4244 m .21842 .52019 L .24229 .52439 L .977 0 .387 r
F
.22725 .41698 m .2232 .4244 L .21842 .52019 L .592 0 .235 r
F
.26633 .42434 m .26268 .51347 L .28641 .51768 L .977 0 .387 r
F
.26633 .42434 m .25842 .52053 L .26268 .51347 L .621 0 .246 r
F
.57728 .41222 m .59405 .4241 L .57157 .41969 L .397 0 .954 r
F
.57728 .41222 m .59986 .41667 L .59405 .4241 L F
.57157 .41969 m .59454 .44135 L .59405 .4241 L .406 0 .975 r
F
.59986 .41667 m .59405 .4241 L .59454 .44135 L .319 0 .767 r
F
.61484 .41962 m .6378 .44 L .63721 .42404 L .406 0 .975 r
F
.17353 .53959 m .18227 .42023 L .18035 .42394 L .561 0 .111 r
F
.65464 .4238 m .65517 .43693 L .67743 .44129 L .212 0 .975 r
F
.66129 .42954 m .67743 .44129 L .65517 .43693 L .208 0 .953 r
F
.68302 .4208 m .67743 .44129 L .68363 .43394 L .173 0 .791 r
F
.66129 .42954 m .68363 .43394 L .67743 .44129 L .208 0 .953 r
F
.66074 .41637 m .65464 .4238 L .65517 .43693 L .171 0 .784 r
F
.34135 .52266 m .35991 .53371 L .33675 .52961 L .946 0 .375 r
F
.34135 .52266 m .3646 .52681 L .35991 .53371 L F
.4476 .41133 m .46536 .42322 L .4425 .4188 L .775 0 .954 r
F
.4476 .41133 m .47056 .41579 L .46536 .42322 L F
.4425 .4188 m .46538 .45085 L .46536 .42322 L .792 0 .976 r
F
.47056 .41579 m .46536 .42322 L .46538 .45085 L .585 0 .721 r
F
.50853 .42316 m .50342 .45858 L .50881 .45131 L .599 0 .738 r
F
.48579 .41874 m .50881 .45131 L .50853 .42316 L .792 0 .975 r
F
.37016 .5823 m .37253 .57897 L .38169 .58428 L .942 0 .187 r
F
.38169 .58428 m .37253 .57897 L .39561 .58294 L F
.52595 .42293 m .52626 .44537 L .54893 .44972 L .599 0 .975 r
F
.53144 .41549 m .52595 .42293 L .52626 .44537 L .457 0 .744 r
F
.56914 .42287 m .56965 .44556 L .5922 .44992 L .599 0 .975 r
F
.56914 .42287 m .56398 .45286 L .56965 .44556 L .466 0 .759 r
F
.3561 .44035 m .37456 .45203 L .35142 .4477 L .952 0 .754 r
F
.37971 .42228 m .37456 .45203 L .37932 .44473 L .683 0 .541 r
F
.3561 .44035 m .37932 .44473 L .37456 .45203 L .952 0 .754 r
F
.31777 .41044 m .33652 .42234 L .31328 .41792 L .954 0 .756 r
F
.31777 .41044 m .34111 .4149 L .33652 .42234 L F
.31328 .41792 m .33589 .44635 L .33652 .42234 L .976 0 .773 r
F
.34111 .4149 m .33652 .42234 L .33589 .44635 L .661 0 .523 r
F
.35659 .41786 m .37932 .44473 L .37971 .42228 L .976 0 .773 r
F
.61484 .41962 m .60947 .44297 L .61536 .43562 L .321 0 .772 r
F
.18779 .40954 m .20753 .42147 L .18392 .41704 L .954 0 .378 r
F
.18779 .40954 m .21151 .41401 L .20753 .42147 L F
.18392 .41704 m .20196 .52595 L .20753 .42147 L .977 0 .387 r
F
.21151 .41401 m .20753 .42147 L .20196 .52595 L .58 0 .23 r
F
.25074 .42141 m .24229 .52439 L .2465 .51732 L .61 0 .241 r
F
.22725 .41698 m .2465 .51732 L .25074 .42141 L .977 0 .387 r
F
.48593 .44694 m .50342 .45858 L .48064 .45426 L .773 0 .952 r
F
.48593 .44694 m .50881 .45131 L .50342 .45858 L F
.26815 .42117 m .26623 .46839 L .28979 .4727 L .977 0 .58 r
F
.27241 .41371 m .26815 .42117 L .26623 .46839 L .621 0 .369 r
F
.31137 .42111 m .30996 .46598 L .33337 .47029 L .976 0 .58 r
F
.31137 .42111 m .30549 .47322 L .30996 .46598 L .646 0 .384 r
F
.15274 .41879 m .16648 .41728 L .1646 .421 L .954 0 .189 r
F
.15487 .57689 m .16648 .41728 L .1646 .421 L .548 0 .109 r
F
.62332 .40893 m .63978 .42086 L .61737 .41643 L .208 0 .954 r
F
.62332 .40893 m .64581 .4134 L .63978 .42086 L F
.61737 .41643 m .64027 .434 L .63978 .42086 L .212 0 .975 r
F
.64581 .4134 m .63978 .42086 L .64027 .434 L .17 0 .78 r
F
.66074 .41637 m .68363 .43394 L .68302 .4208 L .212 0 .974 r
F
.18227 .42023 m .16834 .6577 L .19313 .66162 L .977 0 .193 r
F
.16636 .661 m .18227 .42023 L .17353 .53959 L .561 0 .111 r
F
.16636 .661 m .16834 .6577 L .18227 .42023 L F
.53177 .438 m .54893 .44972 L .52626 .44537 L .585 0 .952 r
F
.5541 .41992 m .54893 .44972 L .55454 .44239 L .462 0 .753 r
F
.53177 .438 m .55454 .44239 L .54893 .44972 L .585 0 .952 r
F
.49339 .40804 m .51084 .41998 L .48806 .41555 L .586 0 .954 r
F
.49339 .40804 m .51626 .41252 L .51084 .41998 L F
.48806 .41555 m .51111 .44635 L .51084 .41998 L .599 0 .975 r
F
.51626 .41252 m .51084 .41998 L .51111 .44635 L .453 0 .738 r
F
.53144 .41549 m .55454 .44239 L .5541 .41992 L .599 0 .975 r
F
.57157 .41969 m .57197 .43697 L .59454 .44135 L .406 0 .975 r
F
.57728 .41222 m .57157 .41969 L .57197 .43697 L .316 0 .759 r
F
.61484 .41962 m .61536 .43562 L .6378 .44 L .406 0 .975 r
F
.66074 .41637 m .65517 .43693 L .66129 .42954 L .171 0 .784 r
F
.36331 .40714 m .38176 .4191 L .3586 .41466 L .954 0 .945 r
F
.36331 .40714 m .38657 .41163 L .38176 .4191 L F
.3586 .41466 m .38133 .4447 L .38176 .4191 L .976 0 .966 r
F
.38657 .41163 m .38176 .4191 L .38133 .4447 L .683 0 .676 r
F
.4425 .4188 m .44239 .44648 L .46538 .45085 L .792 0 .976 r
F
.4476 .41133 m .4425 .4188 L .44239 .44648 L .577 0 .71 r
F
.14085 .41657 m .14268 .41283 L .15274 .41879 L .954 0 .189 r
F
.15274 .41879 m .14268 .41283 L .16648 .41728 L F
.48579 .41874 m .48593 .44694 L .50881 .45131 L .792 0 .975 r
F
.48579 .41874 m .48064 .45426 L .48593 .44694 L .591 0 .728 r
F
.57771 .42956 m .59454 .44135 L .57197 .43697 L .396 0 .953 r
F
.59986 .41667 m .59454 .44135 L .60037 .43398 L .319 0 .767 r
F
.57771 .42956 m .60037 .43398 L .59454 .44135 L .396 0 .953 r
F
.30996 .46598 m .32881 .47749 L .30549 .47322 L .95 0 .564 r
F
.30996 .46598 m .33337 .47029 L .32881 .47749 L F
.23309 .40625 m .25253 .41822 L .22899 .41378 L .954 0 .567 r
F
.23309 .40625 m .25673 .41074 L .25253 .41822 L F
.22899 .41378 m .25033 .46839 L .25253 .41822 L .977 0 .58 r
F
.25673 .41074 m .25253 .41822 L .25033 .46839 L .61 0 .362 r
F
.29583 .41816 m .28979 .4727 L .29419 .46544 L .636 0 .378 r
F
.27241 .41371 m .29419 .46544 L .29583 .41816 L .976 0 .58 r
F
.35659 .41786 m .35142 .4477 L .3561 .44035 L .67 0 .53 r
F
.31328 .41792 m .31253 .44197 L .33589 .44635 L .976 0 .773 r
F
.31777 .41044 m .31328 .41792 L .31253 .44197 L .646 0 .512 r
F
.35659 .41786 m .3561 .44035 L .37932 .44473 L .976 0 .773 r
F
.66954 .40563 m .68569 .41761 L .66337 .41317 L .019 0 .954 r
F
.66954 .40563 m .69195 .41012 L .68569 .41761 L F
.66954 .40563 m .68569 .41761 L .66337 .41317 L F
.66954 .40563 m .69195 .41012 L .68569 .41761 L F
.14449 .74335 m .16648 .41728 L .15487 .57689 L .548 0 .109 r
F
.14449 .74335 m .14645 .74019 L .16648 .41728 L F
.14268 .41283 m .14645 .74019 L .16648 .41728 L .977 0 .193 r
F
.18392 .41704 m .17781 .52173 L .20196 .52595 L .977 0 .387 r
F
.18779 .40954 m .18392 .41704 L .17781 .52173 L .561 0 .222 r
F
.22725 .41698 m .22252 .51308 L .2465 .51732 L .977 0 .387 r
F
.22725 .41698 m .21842 .52019 L .22252 .51308 L .592 0 .235 r
F
.53937 .40474 m .55651 .41673 L .53381 .41228 L .397 0 .954 r
F
.53937 .40474 m .56216 .40923 L .55651 .41673 L F
.53381 .41228 m .55684 .43326 L .55651 .41673 L .406 0 .975 r
F
.56216 .40923 m .55651 .41673 L .55684 .43326 L .313 0 .753 r
F
.57728 .41222 m .60037 .43398 L .59986 .41667 L .406 0 .975 r
F
.13032 .57277 m .14268 .41283 L .14085 .41657 L .527 0 .104 r
F
.61737 .41643 m .6178 .4296 L .64027 .434 L .212 0 .975 r
F
.62377 .42214 m .64027 .434 L .6178 .4296 L .208 0 .953 r
F
.64581 .4134 m .64027 .434 L .64632 .42659 L .17 0 .78 r
F
.62377 .42214 m .64632 .42659 L .64027 .434 L .208 0 .953 r
F
.66074 .41637 m .66129 .42954 L .68363 .43394 L .212 0 .974 r
F
.62332 .40893 m .61737 .41643 L .6178 .4296 L .168 0 .772 r
F
.40905 .40384 m .42718 .41585 L .4041 .41139 L .775 0 .954 r
F
.40905 .40384 m .43222 .40834 L .42718 .41585 L F
.4041 .41139 m .42697 .44564 L .42718 .41585 L .792 0 .976 r
F
.43222 .40834 m .42718 .41585 L .42697 .44564 L .571 0 .703 r
F
.47056 .41579 m .46538 .45085 L .47061 .4435 L .585 0 .721 r
F
.4476 .41133 m .47061 .4435 L .47056 .41579 L .792 0 .975 r
F
.53144 .41549 m .52626 .44537 L .53177 .438 L .457 0 .744 r
F
.48806 .41555 m .48821 .44196 L .51111 .44635 L .599 0 .975 r
F
.49339 .40804 m .48806 .41555 L .48821 .44196 L .447 0 .728 r
F
.53144 .41549 m .53177 .438 L .55454 .44239 L .599 0 .975 r
F
.30222 .51809 m .32117 .52923 L .29779 .5251 L .946 0 .375 r
F
.30222 .51809 m .32571 .52227 L .32117 .52923 L F
.27858 .40294 m .29771 .41496 L .27425 .4105 L .954 0 .756 r
F
.27858 .40294 m .30214 .40745 L .29771 .41496 L F
.27425 .4105 m .29675 .44294 L .29771 .41496 L .976 0 .773 r
F
.30214 .40745 m .29771 .41496 L .29675 .44294 L .636 0 .504 r
F
.34111 .4149 m .33589 .44635 L .3405 .43898 L .661 0 .523 r
F
.31777 .41044 m .3405 .43898 L .34111 .4149 L .976 0 .773 r
F
.3586 .41466 m .35804 .4403 L .38133 .4447 L .976 0 .966 r
F
.36331 .40714 m .3586 .41466 L .35804 .4403 L .67 0 .663 r
F
.31704 .43456 m .33589 .44635 L .31253 .44197 L .952 0 .754 r
F
.31704 .43456 m .3405 .43898 L .33589 .44635 L F
.44752 .43909 m .46538 .45085 L .44239 .44648 L .773 0 .952 r
F
.44752 .43909 m .47061 .4435 L .46538 .45085 L F
.14796 .40204 m .1681 .41407 L .14426 .40961 L .954 0 .378 r
F
.14796 .40204 m .1719 .40655 L .1681 .41407 L F
.14426 .40961 m .15942 .55469 L .1681 .41407 L .977 0 .387 r
F
.1719 .40655 m .1681 .41407 L .15942 .55469 L .548 0 .217 r
F
.21151 .41401 m .20196 .52595 L .206 .51884 L .58 0 .23 r
F
.18779 .40954 m .206 .51884 L .21151 .41401 L .977 0 .387 r
F
.57728 .41222 m .57197 .43697 L .57771 .42956 L .316 0 .759 r
F
.22899 .41378 m .22653 .46404 L .25033 .46839 L .977 0 .58 r
F
.23309 .40625 m .22899 .41378 L .22653 .46404 L .592 0 .352 r
F
.27241 .41371 m .27053 .46109 L .29419 .46544 L .976 0 .58 r
F
.27241 .41371 m .26623 .46839 L .27053 .46109 L .621 0 .369 r
F
.11298 .41137 m .12674 .40985 L .12495 .4136 L .954 0 .189 r
F
.11117 .60812 m .12674 .40985 L .12495 .4136 L .513 0 .102 r
F
.58554 .40142 m .60237 .41346 L .57975 .40899 L .208 0 .954 r
F
.58554 .40142 m .60825 .40594 L .60237 .41346 L F
.57975 .40899 m .60278 .42742 L .60237 .41346 L .212 0 .975 r
F
.60825 .40594 m .60237 .41346 L .60278 .42742 L .167 0 .767 r
F
.62332 .40893 m .64632 .42659 L .64581 .4134 L .212 0 .974 r
F
.34275 .59289 m .35674 .59155 L .3544 .59487 L .94 0 .186 r
F
.14268 .41283 m .12097 .73642 L .14645 .74019 L .977 0 .193 r
F
.11907 .73959 m .14268 .41283 L .13032 .57277 L .527 0 .104 r
F
.11907 .73959 m .12097 .73642 L .14268 .41283 L F
.45497 .40052 m .4728 .41258 L .4498 .4081 L .586 0 .954 r
F
.45497 .40052 m .47807 .40504 L .4728 .41258 L F
.4498 .4081 m .47287 .44111 L .4728 .41258 L .599 0 .975 r
F
.47807 .40504 m .4728 .41258 L .47287 .44111 L .443 0 .721 r
F
.51626 .41252 m .51111 .44635 L .51657 .43896 L .453 0 .738 r
F
.49339 .40804 m .51657 .43896 L .51626 .41252 L .599 0 .975 r
F
.53381 .41228 m .53406 .42884 L .55684 .43326 L .406 0 .975 r
F
.53937 .40474 m .53381 .41228 L .53406 .42884 L .309 0 .744 r
F
.57728 .41222 m .57771 .42956 L .60037 .43398 L .406 0 .975 r
F
.62332 .40893 m .6178 .4296 L .62377 .42214 L .168 0 .772 r
F
.32426 .39962 m .34309 .41169 L .31971 .40721 L .954 0 .945 r
F
.32426 .39962 m .34774 .40414 L .34309 .41169 L F
.32426 .39962 m .34309 .41169 L .31971 .40721 L F
.32426 .39962 m .34774 .40414 L .34309 .41169 L F
.38657 .41163 m .38133 .4447 L .38617 .4373 L .683 0 .676 r
F
.36331 .40714 m .38617 .4373 L .38657 .41163 L .976 0 .966 r
F
.4041 .41139 m .40375 .44124 L .42697 .44564 L .792 0 .976 r
F
.40905 .40384 m .4041 .41139 L .40375 .44124 L .561 0 .691 r
F
.10098 .40913 m .10272 .40535 L .11298 .41137 L .954 0 .189 r
F
.11298 .41137 m .10272 .40535 L .12674 .40985 L F
.4476 .41133 m .44752 .43909 L .47061 .4435 L .792 0 .975 r
F
.4476 .41133 m .44239 .44648 L .44752 .43909 L .577 0 .71 r
F
.49357 .43454 m .51111 .44635 L .48821 .44196 L .584 0 .952 r
F
.49357 .43454 m .51657 .43896 L .51111 .44635 L F
.53964 .42135 m .55684 .43326 L .53406 .42884 L .396 0 .953 r
F
.56216 .40923 m .55684 .43326 L .56251 .42582 L .313 0 .753 r
F
.53964 .42135 m .56251 .42582 L .55684 .43326 L .396 0 .953 r
F
.19339 .39871 m .21323 .4108 L .18946 .40631 L .954 0 .567 r
F
.19339 .39871 m .21726 .40324 L .21323 .4108 L F
.18946 .40631 m .21022 .46826 L .21323 .4108 L .977 0 .58 r
F
.21726 .40324 m .21323 .4108 L .21022 .46826 L .58 0 .345 r
F
.25673 .41074 m .25033 .46839 L .25456 .46107 L .61 0 .362 r
F
.23309 .40625 m .25456 .46107 L .25673 .41074 L .976 0 .58 r
F
.33107 .59091 m .33337 .58757 L .34275 .59289 L .94 0 .186 r
F
.34275 .59289 m .33337 .58757 L .35674 .59155 L F
.36278 .43287 m .38133 .4447 L .35804 .4403 L .952 0 .942 r
F
.36278 .43287 m .38617 .4373 L .38133 .4447 L F
.27425 .4105 m .27315 .43853 L .29675 .44294 L .976 0 .773 r
F
.27858 .40294 m .27425 .4105 L .27315 .43853 L .621 0 .492 r
F
.31777 .41044 m .31704 .43456 L .3405 .43898 L .976 0 .773 r
F
.31777 .41044 m .31253 .44197 L .31704 .43456 L .646 0 .512 r
F
.63191 .39809 m .64842 .41019 L .62588 .40569 L .019 0 .954 r
F
.63191 .39809 m .65453 .40262 L .64842 .41019 L F
.62588 .40569 m .64914 .42858 L .64842 .41019 L .019 0 .974 r
F
.65453 .40262 m .64842 .41019 L .64914 .42858 L .016 0 .78 r
F
.27053 .46109 m .28979 .4727 L .26623 .46839 L .95 0 .564 r
F
.27053 .46109 m .29419 .46544 L .28979 .4727 L F
.09622 .81925 m .12674 .40985 L .11117 .60812 L .513 0 .102 r
F
.09622 .81925 m .0981 .81622 L .12674 .40985 L F
.10272 .40535 m .0981 .81622 L .12674 .40985 L .977 0 .193 r
F
.14426 .40961 m .13485 .5505 L .15942 .55469 L .977 0 .387 r
F
.14796 .40204 m .14426 .40961 L .13485 .5505 L .527 0 .209 r
F
.18779 .40954 m .18174 .51458 L .206 .51884 L .977 0 .387 r
F
.18779 .40954 m .17781 .52173 L .18174 .51458 L .561 0 .222 r
F
.50109 .39718 m .5186 .40929 L .49569 .4048 L .397 0 .954 r
F
.50109 .39718 m .5241 .40172 L .5186 .40929 L F
.49569 .4048 m .51883 .42796 L .5186 .40929 L .406 0 .975 r
F
.5241 .40172 m .5186 .40929 L .51883 .42796 L .307 0 .738 r
F
.53937 .40474 m .56251 .42582 L .56216 .40923 L .406 0 .975 r
F
.08618 .60404 m .10272 .40535 L .10098 .40913 L .49 0 .097 r
F
.62332 .40893 m .62377 .42214 L .64632 .42659 L .212 0 .974 r
F
.57975 .40899 m .5801 .42298 L .60278 .42742 L .212 0 .975 r
F
.58554 .40142 m .57975 .40899 L .5801 .42298 L .165 0 .759 r
F
.58591 .41545 m .60278 .42742 L .5801 .42298 L .208 0 .953 r
F
.60825 .40594 m .60278 .42742 L .60869 .41994 L .167 0 .767 r
F
.58591 .41545 m .60869 .41994 L .60278 .42742 L .208 0 .953 r
F
.37013 .39628 m .38865 .4084 L .36535 .4039 L .775 0 .954 r
F
.37013 .39628 m .39352 .40082 L .38865 .4084 L F
.36331 .40714 m .36278 .43287 L .38617 .4373 L .976 0 .966 r
F
.36535 .4039 m .38815 .44091 L .38865 .4084 L .792 0 .976 r
F
.39352 .40082 m .38865 .4084 L .38815 .44091 L .554 0 .683 r
F
.43222 .40834 m .42697 .44564 L .43204 .43823 L .571 0 .703 r
F
.40905 .40384 m .43204 .43823 L .43222 .40834 L .792 0 .975 r
F
.4498 .4081 m .44973 .43669 L .47287 .44111 L .599 0 .975 r
F
.45497 .40052 m .4498 .4081 L .44973 .43669 L .436 0 .71 r
F
.49339 .40804 m .49357 .43454 L .51657 .43896 L .599 0 .975 r
F
.49339 .40804 m .48821 .44196 L .49357 .43454 L .447 0 .728 r
F
.23901 .39537 m .25854 .40751 L .23486 .403 L .954 0 .756 r
F
.23901 .39537 m .2628 .39992 L .25854 .40751 L F
.23486 .403 m .25732 .4361 L .25854 .40751 L .976 0 .773 r
F
.2628 .39992 m .25854 .40751 L .25732 .4361 L .61 0 .483 r
F
.30214 .40745 m .29675 .44294 L .3012 .43552 L .636 0 .504 r
F
.27858 .40294 m .3012 .43552 L .30214 .40745 L .976 0 .773 r
F
.26268 .51347 m .28204 .52471 L .25842 .52053 L .946 0 .375 r
F
.26268 .51347 m .28641 .51768 L .28204 .52471 L F
.36331 .40714 m .35804 .4403 L .36278 .43287 L .67 0 .663 r
F
.67847 .39475 m .69466 .40689 L .67221 .40238 L 0 .17 .954 r
F
.67847 .39475 m .70101 .3993 L .69466 .40689 L F
.67221 .40238 m .69524 .41881 L .69466 .40689 L 0 .173 .974 r
F
.70101 .3993 m .69466 .40689 L .69524 .41881 L 0 .141 .791 r
F
.53937 .40474 m .53406 .42884 L .53964 .42135 L .309 0 .744 r
F
.10775 .39446 m .12829 .40661 L .10422 .4021 L .954 0 .378 r
F
.10775 .39446 m .13192 .39902 L .12829 .40661 L F
.10422 .4021 m .11331 .62002 L .12829 .40661 L .977 0 .387 r
F
.13192 .39902 m .12829 .40661 L .11331 .62002 L .513 0 .203 r
F
.1719 .40655 m .15942 .55469 L .1633 .54764 L .548 0 .217 r
F
.14796 .40204 m .1633 .54764 L .1719 .40655 L .977 0 .387 r
F
.30378 .58331 m .31779 .58195 L .31553 .58531 L .941 0 .186 r
F
.18946 .40631 m .18616 .46388 L .21022 .46826 L .977 0 .58 r
F
.19339 .39871 m .18946 .40631 L .18616 .46388 L .561 0 .333 r
F
.23309 .40625 m .23066 .45668 L .25456 .46107 L .976 0 .58 r
F
.23309 .40625 m .22653 .46404 L .23066 .45668 L .592 0 .352 r
F
.07284 .40388 m .08663 .40234 L .08492 .40613 L .954 0 .189 r
F
.06442 .66446 m .08663 .40234 L .08492 .40613 L .474 0 .094 r
F
.54741 .39384 m .5646 .406 L .54177 .40148 L .208 0 .954 r
F
.54741 .39384 m .57033 .3984 L .5646 .406 L F
.54177 .40148 m .56492 .42052 L .5646 .406 L .212 0 .975 r
F
.57033 .3984 m .5646 .406 L .56492 .42052 L .164 0 .753 r
F
.40872 .43379 m .42697 .44564 L .40375 .44124 L .773 0 .951 r
F
.40872 .43379 m .43204 .43823 L .42697 .44564 L F
.58554 .40142 m .60869 .41994 L .60825 .40594 L .212 0 .974 r
F
.27749 .43107 m .29675 .44294 L .27315 .43853 L .952 0 .754 r
F
.27749 .43107 m .3012 .43552 L .29675 .44294 L F
.62588 .40569 m .62652 .42413 L .64914 .42858 L .019 0 .974 r
F
.63191 .39809 m .62588 .40569 L .62652 .42413 L .015 0 .772 r
F
.10272 .40535 m .07192 .8126 L .0981 .81622 L .977 0 .193 r
F
.07011 .81564 m .10272 .40535 L .08618 .60404 L .49 0 .097 r
F
.07011 .81564 m .07192 .8126 L .10272 .40535 L F
.41619 .39293 m .4344 .4051 L .41118 .40058 L .586 0 .954 r
F
.41619 .39293 m .43951 .39749 L .4344 .4051 L F
.41118 .40058 m .43423 .43425 L .4344 .4051 L .599 0 .975 r
F
.43951 .39749 m .4344 .4051 L .43423 .43425 L .431 0 .703 r
F
.47807 .40504 m .47287 .44111 L .47817 .43367 L .443 0 .721 r
F
.45497 .40052 m .47817 .43367 L .47807 .40504 L .599 0 .975 r
F
.49569 .4048 m .49583 .4235 L .51883 .42796 L .406 0 .975 r
F
.50109 .39718 m .49569 .4048 L .49583 .4235 L .303 0 .728 r
F
.53937 .40474 m .53964 .42135 L .56251 .42582 L .406 0 .975 r
F
.58554 .40142 m .5801 .42298 L .58591 .41545 L .165 0 .759 r
F
.28483 .39202 m .30405 .4042 L .28044 .39968 L .954 0 .945 r
F
.28483 .39202 m .30853 .39658 L .30405 .4042 L F
.28044 .39968 m .30318 .43022 L .30405 .4042 L .976 0 .966 r
F
.30853 .39658 m .30405 .4042 L .30318 .43022 L .636 0 .63 r
F
.29199 .58131 m .29421 .57793 L .30378 .58331 L .941 0 .186 r
F
.30378 .58331 m .29421 .57793 L .31779 .58195 L F
.63258 .41658 m .64914 .42858 L .62652 .42413 L .019 0 .953 r
F
.65453 .40262 m .64914 .42858 L .65529 .42108 L .016 0 .78 r
F
.63258 .41658 m .65529 .42108 L .64914 .42858 L .019 0 .953 r
F
.36535 .4039 m .36469 .43647 L .38815 .44091 L .792 0 .976 r
F
.37013 .39628 m .36535 .4039 L .36469 .43647 L .544 0 .67 r
F
.06072 .40162 m .06238 .39781 L .07284 .40388 L .954 0 .189 r
F
.07284 .40388 m .06238 .39781 L .08663 .40234 L F
.40905 .40384 m .40872 .43379 L .43204 .43823 L .792 0 .975 r
F
.40905 .40384 m .40375 .44124 L .40872 .43379 L .561 0 .691 r
F
.15331 .3911 m .17355 .4033 L .14956 .39877 L .954 0 .567 r
F
.15331 .3911 m .1774 .39568 L .17355 .4033 L F
.14956 .39877 m .16948 .47025 L .17355 .4033 L .977 0 .58 r
F
.1774 .39568 m .17355 .4033 L .16948 .47025 L .548 0 .326 r
F
.21726 .40324 m .21022 .46826 L .21429 .46089 L .58 0 .345 r
F
.19339 .39871 m .21429 .46089 L .21726 .40324 L .976 0 .58 r
F
.45494 .4292 m .47287 .44111 L .44973 .43669 L .584 0 .952 r
F
.45494 .4292 m .47817 .43367 L .47287 .44111 L F
.50125 .41595 m .51883 .42796 L .49583 .4235 L .396 0 .952 r
F
.5241 .40172 m .51883 .42796 L .52435 .42045 L .307 0 .738 r
F
.50125 .41595 m .52435 .42045 L .51883 .42796 L .396 0 .952 r
F
.23486 .403 m .23349 .43165 L .25732 .4361 L .976 0 .773 r
F
.23901 .39537 m .23486 .403 L .23349 .43165 L .592 0 .469 r
F
.27858 .40294 m .27749 .43107 L .3012 .43552 L .976 0 .773 r
F
.27858 .40294 m .27315 .43853 L .27749 .43107 L .621 0 .492 r
F
.67221 .40238 m .67274 .41432 L .69524 .41881 L 0 .173 .974 r
F
.67902 .40673 m .69524 .41881 L .67274 .41432 L 0 .17 .953 r
F
.70101 .3993 m .69524 .41881 L .70162 .41126 L 0 .141 .791 r
F
.67902 .40673 m .70162 .41126 L .69524 .41881 L 0 .17 .953 r
F
.59392 .39048 m .61079 .40269 L .58804 .39815 L .019 0 .954 r
F
.59392 .39048 m .61676 .39505 L .61079 .40269 L F
.58804 .39815 m .61138 .4214 L .61079 .40269 L .019 0 .974 r
F
.61676 .39505 m .61079 .40269 L .61138 .4214 L .015 0 .767 r
F
.63191 .39809 m .65529 .42108 L .65453 .40262 L .019 0 .974 r
F
.67847 .39475 m .67221 .40238 L .67274 .41432 L 0 .14 .784 r
F
.04156 .95256 m .08663 .40234 L .06442 .66446 L .474 0 .094 r
F
.04156 .95256 m .04335 .9498 L .08663 .40234 L F
.06238 .39781 m .04335 .9498 L .08663 .40234 L .977 0 .193 r
F
.10422 .4021 m .08811 .61594 L .11331 .62002 L .977 0 .387 r
F
.10775 .39446 m .10422 .4021 L .08811 .61594 L .49 0 .194 r
F
.14796 .40204 m .13861 .54341 L .1633 .54764 L .977 0 .387 r
F
.14796 .40204 m .13485 .5505 L .13861 .54341 L .527 0 .209 r
F
.46245 .38956 m .48034 .40179 L .45721 .39725 L .397 0 .954 r
F
.46245 .38956 m .48568 .39414 L .48034 .40179 L F
.45721 .39725 m .48043 .42286 L .48034 .40179 L .406 0 .975 r
F
.48568 .39414 m .48034 .40179 L .48043 .42286 L .3 0 .721 r
F
.50109 .39718 m .52435 .42045 L .5241 .40172 L .406 0 .975 r
F
.23066 .45668 m .25033 .46839 L .22653 .46404 L .95 0 .564 r
F
.23066 .45668 m .25456 .46107 L .25033 .46839 L F
.03884 .66048 m .06238 .39781 L .06072 .40162 L .449 0 .089 r
F
.54177 .40148 m .54202 .41603 L .56492 .42052 L .212 0 .975 r
F
.54741 .39384 m .54177 .40148 L .54202 .41603 L .162 0 .744 r
F
.58554 .40142 m .58591 .41545 L .60869 .41994 L .212 0 .974 r
F
.54767 .40844 m .56492 .42052 L .54202 .41603 L .208 0 .953 r
F
.57033 .3984 m .56492 .42052 L .57067 .41297 L .164 0 .753 r
F
.54767 .40844 m .57067 .41297 L .56492 .42052 L .208 0 .953 r
F
.33083 .38865 m .34974 .40088 L .32622 .39634 L .775 0 .954 r
F
.33083 .38865 m .35446 .39323 L .34974 .40088 L F
.32622 .39634 m .34888 .43771 L .34974 .40088 L .792 0 .976 r
F
.35446 .39323 m .34974 .40088 L .34888 .43771 L .536 0 .661 r
F
.39352 .40082 m .38815 .44091 L .39306 .43344 L .554 0 .683 r
F
.37013 .39628 m .39306 .43344 L .39352 .40082 L .792 0 .975 r
F
.41118 .40058 m .41087 .42979 L .43423 .43425 L .599 0 .975 r
F
.41619 .39293 m .41118 .40058 L .41087 .42979 L .424 0 .691 r
F
.45497 .40052 m .45494 .4292 L .47817 .43367 L .599 0 .975 r
F
.45497 .40052 m .44973 .43669 L .45494 .4292 L .436 0 .71 r
F
.19907 .38773 m .21899 .39998 L .19509 .39543 L .954 0 .756 r
F
.19907 .38773 m .22308 .39232 L .21899 .39998 L F
.19509 .39543 m .21661 .44658 L .21899 .39998 L .976 0 .773 r
F
.22308 .39232 m .21899 .39998 L .21661 .44658 L .58 0 .46 r
F
.2628 .39992 m .25732 .4361 L .2616 .42861 L .61 0 .483 r
F
.23901 .39537 m .2616 .42861 L .2628 .39992 L .976 0 .773 r
F
.28044 .39968 m .27945 .42575 L .30318 .43022 L .976 0 .966 r
F
.28483 .39202 m .28044 .39968 L .27945 .42575 L .621 0 .614 r
F
.63191 .39809 m .62652 .42413 L .63258 .41658 L .015 0 .772 r
F
.64062 .3871 m .65717 .39936 L .63451 .39481 L 0 .17 .954 r
F
.64062 .3871 m .66338 .3917 L .65717 .39936 L F
.63451 .39481 m .65766 .41106 L .65717 .39936 L 0 .173 .974 r
F
.66338 .3917 m .65717 .39936 L .65766 .41106 L 0 .139 .78 r
F
.67847 .39475 m .70162 .41126 L .70101 .3993 L 0 .173 .974 r
F
.06715 .38681 m .0881 .39908 L .0638 .39452 L .954 0 .378 r
F
.06715 .38681 m .09155 .39141 L .0881 .39908 L F
.06715 .38681 m .0881 .39908 L .0638 .39452 L F
.06715 .38681 m .09155 .39141 L .0881 .39908 L F
.13192 .39902 m .11331 .62002 L .11703 .61316 L .513 0 .203 r
F
.10775 .39446 m .11703 .61316 L .13192 .39902 L .977 0 .387 r
F
.14956 .39877 m .14514 .46585 L .16948 .47025 L .977 0 .58 r
F
.15331 .3911 m .14956 .39877 L .14514 .46585 L .527 0 .313 r
F
.19339 .39871 m .19012 .45647 L .21429 .46089 L .976 0 .58 r
F
.19339 .39871 m .18616 .46388 L .19012 .45647 L .561 0 .333 r
F
.50109 .39718 m .49583 .4235 L .50125 .41595 L .303 0 .728 r
F
.50891 .38618 m .52648 .39846 L .50343 .3939 L .208 0 .954 r
F
.50891 .38618 m .53205 .39078 L .52648 .39846 L F
.50343 .3939 m .5267 .41459 L .52648 .39846 L .212 0 .975 r
F
.53205 .39078 m .52648 .39846 L .5267 .41459 L .161 0 .738 r
F
.54741 .39384 m .57067 .41297 L .57033 .3984 L .212 0 .974 r
F
.67847 .39475 m .67274 .41432 L .67902 .40673 L 0 .14 .784 r
F
.58804 .39815 m .58855 .41691 L .61138 .4214 L .019 0 .974 r
F
.59392 .39048 m .58804 .39815 L .58855 .41691 L .015 0 .759 r
F
.63191 .39809 m .63258 .41658 L .65529 .42108 L .019 0 .974 r
F
.23766 .42411 m .25732 .4361 L .23349 .43165 L .952 0 .754 r
F
.23766 .42411 m .2616 .42861 L .25732 .4361 L F
.06238 .39781 m .01614 .94648 L .04335 .9498 L .977 0 .193 r
F
.01442 .94927 m .06238 .39781 L .03884 .66048 L .449 0 .089 r
F
.01442 .94927 m .01614 .94648 L .06238 .39781 L F
.3695 .42896 m .38815 .44091 L .36469 .43647 L .772 0 .951 r
F
.3695 .42896 m .39306 .43344 L .38815 .44091 L F
.37704 .38526 m .39563 .39755 L .37219 .39299 L .586 0 .954 r
F
.37704 .38526 m .40058 .38987 L .39563 .39755 L F
.37219 .39299 m .39525 .42522 L .39563 .39755 L .599 0 .975 r
F
.40058 .38987 m .39563 .39755 L .39525 .42522 L .419 0 .683 r
F
.22252 .51308 m .24229 .52439 L .21842 .52019 L .945 0 .374 r
F
.22252 .51308 m .2465 .51732 L .24229 .52439 L F
.43951 .39749 m .43423 .43425 L .43937 .42673 L .431 0 .703 r
F
.41619 .39293 m .43937 .42673 L .43951 .39749 L .599 0 .975 r
F
.45721 .39725 m .45719 .41836 L .48043 .42286 L .406 0 .975 r
F
.46245 .38956 m .45721 .39725 L .45719 .41836 L .295 0 .71 r
F
.50109 .39718 m .50125 .41595 L .52435 .42045 L .406 0 .975 r
F
.24502 .38434 m .26463 .39665 L .24081 .39208 L .954 0 .945 r
F
.24502 .38434 m .26895 .38896 L .26463 .39665 L F
.24502 .38434 m .26463 .39665 L .24081 .39208 L F
.24502 .38434 m .26895 .38896 L .26463 .39665 L F
.54741 .39384 m .54202 .41603 L .54767 .40844 L .162 0 .744 r
F
.30853 .39658 m .30318 .43022 L .30769 .42269 L .636 0 .63 r
F
.28483 .39202 m .30769 .42269 L .30853 .39658 L .976 0 .966 r
F
.26407 .58389 m .27813 .58252 L .27595 .5859 L .94 0 .186 r
F
.59445 .40929 m .61138 .4214 L .58855 .41691 L .019 0 .952 r
F
.61676 .39505 m .61138 .4214 L .61737 .41383 L .015 0 .767 r
F
.59445 .40929 m .61737 .41383 L .61138 .4214 L .019 0 .952 r
F
.32622 .39634 m .32517 .43323 L .34888 .43771 L .792 0 .976 r
F
.33083 .38865 m .32622 .39634 L .32517 .43323 L .525 0 .646 r
F
.37013 .39628 m .3695 .42896 L .39306 .43344 L .792 0 .975 r
F
.37013 .39628 m .36469 .43647 L .3695 .42896 L .544 0 .67 r
F
.68753 .38371 m .70375 .39602 L .68118 .39145 L 0 .359 .954 r
F
.68753 .38371 m .71019 .38833 L .70375 .39602 L F
.68118 .39145 m .70439 .40852 L .70375 .39602 L 0 .366 .974 r
F
.71019 .38833 m .70375 .39602 L .70439 .40852 L 0 .298 .791 r
F
.11285 .38342 m .13349 .39574 L .10927 .39117 L .954 0 .567 r
F
.11285 .38342 m .13717 .38804 L .13349 .39574 L F
.10927 .39117 m .12675 .493 L .13349 .39574 L .977 0 .58 r
F
.13717 .38804 m .13349 .39574 L .12675 .493 L .513 0 .305 r
F
.1774 .39568 m .16948 .47025 L .17338 .46284 L .548 0 .326 r
F
.15331 .3911 m .17338 .46284 L .1774 .39568 L .976 0 .58 r
F
.28385 .41817 m .30318 .43022 L .27945 .42575 L .952 0 .942 r
F
.28385 .41817 m .30769 .42269 L .30318 .43022 L F
.63451 .39481 m .63494 .40653 L .65766 .41106 L 0 .173 .974 r
F
.64107 .39886 m .65766 .41106 L .63494 .40653 L 0 .17 .953 r
F
.66338 .3917 m .65766 .41106 L .66388 .40343 L 0 .139 .78 r
F
.64107 .39886 m .66388 .40343 L .65766 .41106 L 0 .17 .953 r
F
.19509 .39543 m .19246 .44212 L .21661 .44658 L .976 0 .773 r
F
.19907 .38773 m .19509 .39543 L .19246 .44212 L .561 0 .445 r
F
.41591 .42223 m .43423 .43425 L .41087 .42979 L .584 0 .952 r
F
.41591 .42223 m .43937 .42673 L .43423 .43425 L F
.23901 .39537 m .23766 .42411 L .2616 .42861 L .976 0 .773 r
F
.23901 .39537 m .23349 .43165 L .23766 .42411 L .592 0 .469 r
F
.67847 .39475 m .67902 .40673 L .70162 .41126 L 0 .173 .974 r
F
.55556 .38279 m .57281 .39512 L .54984 .39054 L .019 0 .954 r
F
.55556 .38279 m .57862 .38741 L .57281 .39512 L F
.54984 .39054 m .57325 .41389 L .57281 .39512 L .019 0 .974 r
F
.57862 .38741 m .57281 .39512 L .57325 .41389 L .015 0 .753 r
F
.59392 .39048 m .61737 .41383 L .61676 .39505 L .019 0 .974 r
F
.64062 .3871 m .63451 .39481 L .63494 .40653 L 0 .137 .772 r
F
.46246 .41074 m .48043 .42286 L .45719 .41836 L .396 0 .952 r
F
.48568 .39414 m .48043 .42286 L .48579 .41529 L .3 0 .721 r
F
.46246 .41074 m .48579 .41529 L .48043 .42286 L .396 0 .952 r
F
.10775 .39446 m .09171 .60904 L .11703 .61316 L .977 0 .387 r
F
.10775 .39446 m .08811 .61594 L .09171 .60904 L .49 0 .194 r
F
.25216 .58188 m .25429 .57848 L .26407 .58389 L .94 0 .186 r
F
.26407 .58389 m .25429 .57848 L .27813 .58252 L F
.42344 .38186 m .44171 .39421 L .41835 .38962 L .397 0 .954 r
F
.42344 .38186 m .44689 .38649 L .44171 .39421 L F
.41835 .38962 m .44163 .41482 L .44171 .39421 L .406 0 .975 r
F
.44689 .38649 m .44171 .39421 L .44163 .41482 L .292 0 .703 r
F
.46245 .38956 m .48579 .41529 L .48568 .39414 L .406 0 .975 r
F
.50343 .3939 m .50357 .41007 L .5267 .41459 L .212 0 .975 r
F
.50891 .38618 m .50343 .3939 L .50357 .41007 L .159 0 .728 r
F
.54741 .39384 m .54767 .40844 L .57067 .41297 L .212 0 .974 r
F
.29116 .38094 m .31047 .3933 L .28672 .38871 L .775 0 .954 r
F
.29116 .38094 m .31501 .38557 L .31047 .3933 L F
.28483 .39202 m .28385 .41817 L .30769 .42269 L .976 0 .966 r
F
.28672 .38871 m .30916 .4342 L .31047 .3933 L .792 0 .976 r
F
.31501 .38557 m .31047 .3933 L .30916 .4342 L .517 0 .636 r
F
.35446 .39323 m .34888 .43771 L .35362 .43017 L .536 0 .661 r
F
.33083 .38865 m .35362 .43017 L .35446 .39323 L .792 0 .975 r
F
.50907 .4024 m .5267 .41459 L .50357 .41007 L .208 0 .953 r
F
.53205 .39078 m .5267 .41459 L .53229 .40697 L .161 0 .738 r
F
.50907 .4024 m .53229 .40697 L .5267 .41459 L .208 0 .953 r
F
.37219 .39299 m .37167 .42071 L .39525 .42522 L .599 0 .975 r
F
.37704 .38526 m .37219 .39299 L .37167 .42071 L .411 0 .67 r
F
.41619 .39293 m .41591 .42223 L .43937 .42673 L .599 0 .975 r
F
.41619 .39293 m .41087 .42979 L .41591 .42223 L .424 0 .691 r
F
.15874 .38002 m .17907 .39239 L .15493 .38779 L .954 0 .756 r
F
.15874 .38002 m .18298 .38465 L .17907 .39239 L F
.15493 .38779 m .17525 .45643 L .17907 .39239 L .976 0 .773 r
F
.18298 .38465 m .17907 .39239 L .17525 .45643 L .548 0 .434 r
F
.22308 .39232 m .21661 .44658 L .22073 .43907 L .58 0 .46 r
F
.19907 .38773 m .22073 .43907 L .22308 .39232 L .976 0 .773 r
F
.28483 .39202 m .27945 .42575 L .28385 .41817 L .621 0 .614 r
F
.59392 .39048 m .58855 .41691 L .59445 .40929 L .015 0 .759 r
F
.68118 .39145 m .68176 .40397 L .70439 .40852 L 0 .366 .974 r
F
.68813 .39627 m .70439 .40852 L .68176 .40397 L 0 .358 .953 r
F
.71019 .38833 m .70439 .40852 L .71085 .40086 L 0 .298 .791 r
F
.68813 .39627 m .71085 .40086 L .70439 .40852 L 0 .358 .953 r
F
.60241 .37938 m .61933 .39176 L .59645 .38716 L 0 .17 .954 r
F
.60241 .37938 m .62538 .38402 L .61933 .39176 L F
.59645 .38716 m .61976 .40454 L .61933 .39176 L 0 .173 .974 r
F
.62538 .38402 m .61933 .39176 L .61976 .40454 L 0 .136 .767 r
F
.19012 .45647 m .21022 .46826 L .18616 .46388 L .949 0 .564 r
F
.19012 .45647 m .21429 .46089 L .21022 .46826 L F
.64062 .3871 m .66388 .40343 L .66338 .3917 L 0 .173 .974 r
F
.68753 .38371 m .68118 .39145 L .68176 .40397 L 0 .295 .784 r
F
.10927 .39117 m .10201 .48862 L .12675 .493 L .977 0 .58 r
F
.11285 .38342 m .10927 .39117 L .10201 .48862 L .49 0 .291 r
F
.15331 .3911 m .14893 .4584 L .17338 .46284 L .976 0 .58 r
F
.15331 .3911 m .14514 .46585 L .14893 .4584 L .527 0 .313 r
F
.64062 .3871 m .63494 .40653 L .64107 .39886 L 0 .137 .772 r
F
.47003 .37845 m .48799 .39085 L .46471 .38624 L .208 0 .954 r
F
.47003 .37845 m .4934 .3831 L .48799 .39085 L F
.46471 .38624 m .48808 .40704 L .48799 .39085 L .212 0 .975 r
F
.4934 .3831 m .48799 .39085 L .48808 .40704 L .157 0 .721 r
F
.50891 .38618 m .53229 .40697 L .53205 .39078 L .212 0 .974 r
F
.54984 .39054 m .55019 .40935 L .57325 .41389 L .019 0 .974 r
F
.55556 .38279 m .54984 .39054 L .55019 .40935 L .015 0 .744 r
F
.59392 .39048 m .59445 .40929 L .61737 .41383 L .019 0 .974 r
F
.46245 .38956 m .45719 .41836 L .46246 .41074 L .295 0 .71 r
F
.3375 .37752 m .35649 .38993 L .33283 .38533 L .586 0 .954 r
F
.3375 .37752 m .36127 .38218 L .35649 .38993 L F
.33283 .38533 m .35576 .42296 L .35649 .38993 L .599 0 .975 r
F
.36127 .38218 m .35649 .38993 L .35576 .42296 L .406 0 .661 r
F
.40058 .38987 m .39525 .42522 L .40022 .41763 L .419 0 .683 r
F
.37704 .38526 m .40022 .41763 L .40058 .38987 L .599 0 .975 r
F
.41835 .38962 m .41817 .41028 L .44163 .41482 L .406 0 .975 r
F
.42344 .38186 m .41835 .38962 L .41817 .41028 L .287 0 .691 r
F
.46245 .38956 m .46246 .41074 L .48579 .41529 L .406 0 .975 r
F
.20482 .37659 m .22484 .38902 L .20079 .38441 L .954 0 .945 r
F
.20482 .37659 m .22899 .38125 L .22484 .38902 L F
.20079 .38441 m .22314 .42312 L .22484 .38902 L .976 0 .966 r
F
.22899 .38125 m .22484 .38902 L .22314 .42312 L .58 0 .574 r
F
.55593 .40166 m .57325 .41389 L .55019 .40935 L .019 0 .952 r
F
.57862 .38741 m .57325 .41389 L .57909 .40625 L .015 0 .753 r
F
.55593 .40166 m .57909 .40625 L .57325 .41389 L .019 0 .952 r
F
.28672 .38871 m .2852 .42969 L .30916 .4342 L .792 0 .976 r
F
.29116 .38094 m .28672 .38871 L .2852 .42969 L .504 0 .621 r
F
.33083 .38865 m .32981 .42566 L .35362 .43017 L .792 0 .975 r
F
.33083 .38865 m .32517 .43323 L .32981 .42566 L .525 0 .646 r
F
.32981 .42566 m .34888 .43771 L .32517 .43323 L .772 0 .951 r
F
.32981 .42566 m .35362 .43017 L .34888 .43771 L F
.50891 .38618 m .50357 .41007 L .50907 .4024 L .159 0 .728 r
F
.64946 .37596 m .66605 .38839 L .64326 .38377 L 0 .359 .954 r
F
.64946 .37596 m .67234 .38062 L .66605 .38839 L F
.64326 .38377 m .66655 .39988 L .66605 .38839 L 0 .366 .974 r
F
.67234 .38062 m .66605 .38839 L .66655 .39988 L 0 .293 .78 r
F
.68753 .38371 m .71085 .40086 L .71019 .38833 L 0 .366 .973 r
F
.37654 .41307 m .39525 .42522 L .37167 .42071 L .584 0 .952 r
F
.37654 .41307 m .40022 .41763 L .39525 .42522 L F
.07199 .37566 m .09305 .3881 L .06859 .38348 L .954 0 .567 r
F
.07199 .37566 m .09655 .38033 L .09305 .3881 L F
.06859 .38348 m .08157 .53531 L .09305 .3881 L .977 0 .58 r
F
.09655 .38033 m .09305 .3881 L .08157 .53531 L .474 0 .282 r
F
.13717 .38804 m .12675 .493 L .13048 .48562 L .513 0 .305 r
F
.11285 .38342 m .13048 .48562 L .13717 .38804 L .976 0 .58 r
F
.15493 .38779 m .15077 .45197 L .17525 .45643 L .976 0 .773 r
F
.15874 .38002 m .15493 .38779 L .15077 .45197 L .527 0 .418 r
F
.64062 .3871 m .64107 .39886 L .66388 .40343 L 0 .173 .974 r
F
.19907 .38773 m .19647 .43457 L .22073 .43907 L .976 0 .773 r
F
.19907 .38773 m .19246 .44212 L .19647 .43457 L .561 0 .445 r
F
.51683 .37502 m .53446 .38747 L .51127 .38285 L .019 0 .954 r
F
.51683 .37502 m .54011 .37969 L .53446 .38747 L F
.51127 .38285 m .53475 .40657 L .53446 .38747 L .019 0 .974 r
F
.54011 .37969 m .53446 .38747 L .53475 .40657 L .015 0 .738 r
F
.59645 .38716 m .59682 .39997 L .61976 .40454 L 0 .173 .974 r
F
.60279 .39222 m .61976 .40454 L .59682 .39997 L 0 .17 .953 r
F
.62538 .38402 m .61976 .40454 L .62583 .39684 L 0 .136 .767 r
F
.60279 .39222 m .62583 .39684 L .61976 .40454 L 0 .17 .953 r
F
.55556 .38279 m .57909 .40625 L .57862 .38741 L .019 0 .974 r
F
.42327 .40259 m .44163 .41482 L .41817 .41028 L .396 0 .952 r
F
.44689 .38649 m .44163 .41482 L .44683 .40718 L .292 0 .703 r
F
.42327 .40259 m .44683 .40718 L .44163 .41482 L .396 0 .952 r
F
.68753 .38371 m .68176 .40397 L .68813 .39627 L 0 .295 .784 r
F
.60241 .37938 m .59645 .38716 L .59682 .39997 L 0 .135 .759 r
F
.18174 .51458 m .20196 .52595 L .17781 .52173 L .944 0 .374 r
F
.18174 .51458 m .206 .51884 L .20196 .52595 L F
.38404 .37409 m .40271 .38655 L .37913 .38193 L .397 0 .954 r
F
.38404 .37409 m .40772 .37876 L .40271 .38655 L F
.37913 .38193 m .40243 .40882 L .40271 .38655 L .406 0 .975 r
F
.40772 .37876 m .40271 .38655 L .40243 .40882 L .284 0 .683 r
F
.42344 .38186 m .44683 .40718 L .44689 .38649 L .406 0 .975 r
F
.46471 .38624 m .46473 .40246 L .48808 .40704 L .212 0 .975 r
F
.47003 .37845 m .46471 .38624 L .46473 .40246 L .155 0 .71 r
F
.22383 .5853 m .23794 .58392 L .23584 .58732 L .939 0 .186 r
F
.50891 .38618 m .50907 .4024 L .53229 .40697 L .212 0 .974 r
F
.25111 .37316 m .27081 .38564 L .24684 .381 L .775 0 .954 r
F
.25111 .37316 m .27519 .37784 L .27081 .38564 L F
.24684 .381 m .26924 .42455 L .27081 .38564 L .792 0 .976 r
F
.27519 .37784 m .27081 .38564 L .26924 .42455 L .495 0 .61 r
F
.31501 .38557 m .30916 .4342 L .31374 .42661 L .517 0 .636 r
F
.29116 .38094 m .31374 .42661 L .31501 .38557 L .792 0 .975 r
F
.47006 .39472 m .48808 .40704 L .46473 .40246 L .208 0 .953 r
F
.4934 .3831 m .48808 .40704 L .49351 .39934 L .157 0 .721 r
F
.47006 .39472 m .49351 .39934 L .48808 .40704 L .208 0 .953 r
F
.33283 .38533 m .33193 .41842 L .35576 .42296 L .599 0 .975 r
F
.3375 .37752 m .33283 .38533 L .33193 .41842 L .397 0 .646 r
F
.37704 .38526 m .37654 .41307 L .40022 .41763 L .599 0 .975 r
F
.37704 .38526 m .37167 .42071 L .37654 .41307 L .411 0 .67 r
F
.69671 .37252 m .71297 .385 L .69027 .38037 L 0 .548 .954 r
F
.69671 .37252 m .7195 .3772 L .71297 .385 L F
.69027 .38037 m .71354 .39572 L .71297 .385 L 0 .559 .973 r
F
.7195 .3772 m .71297 .385 L .71354 .39572 L 0 .454 .791 r
F
.11802 .37223 m .13876 .38472 L .11439 .38008 L .954 0 .756 r
F
.11802 .37223 m .1425 .37691 L .13876 .38472 L F
.11285 .38342 m .10563 .4812 L .13048 .48562 L .976 0 .58 r
F
.10563 .4812 m .12675 .493 L .10201 .48862 L .945 0 .561 r
F
.10563 .4812 m .13048 .48562 L .12675 .493 L F
.11439 .38008 m .12856 .53408 L .13876 .38472 L .976 0 .773 r
F
.1425 .37691 m .13876 .38472 L .12856 .53408 L .513 0 .406 r
F
.18298 .38465 m .17525 .45643 L .17919 .44891 L .548 0 .434 r
F
.15874 .38002 m .17919 .44891 L .18298 .38465 L .976 0 .773 r
F
.64326 .38377 m .6437 .39528 L .66655 .39988 L 0 .366 .974 r
F
.64992 .3875 m .66655 .39988 L .6437 .39528 L 0 .358 .953 r
F
.67234 .38062 m .66655 .39988 L .67286 .39214 L 0 .293 .78 r
F
.64992 .3875 m .67286 .39214 L .66655 .39988 L 0 .358 .953 r
F
.20079 .38441 m .1989 .41857 L .22314 .42312 L .976 0 .966 r
F
.20482 .37659 m .20079 .38441 L .1989 .41857 L .561 0 .556 r
F
.19647 .43457 m .21661 .44658 L .19246 .44212 L .95 0 .752 r
F
.19647 .43457 m .22073 .43907 L .21661 .44658 L F
.55556 .38279 m .55019 .40935 L .55593 .40166 L .015 0 .744 r
F
.56382 .37158 m .58112 .38408 L .55802 .37944 L 0 .17 .954 r
F
.56382 .37158 m .58702 .37627 L .58112 .38408 L F
.55802 .37944 m .58146 .39717 L .58112 .38408 L 0 .173 .974 r
F
.58702 .37627 m .58112 .38408 L .58146 .39717 L 0 .134 .753 r
F
.68753 .38371 m .68813 .39627 L .71085 .40086 L 0 .366 .973 r
F
.60241 .37938 m .62583 .39684 L .62538 .38402 L 0 .173 .974 r
F
.21177 .58328 m .21382 .57986 L .22383 .5853 L .939 0 .186 r
F
.22383 .5853 m .21382 .57986 L .23794 .58392 L F
.64946 .37596 m .64326 .38377 L .6437 .39528 L 0 .29 .772 r
F
.06859 .38348 m .05632 .53099 L .08157 .53531 L .977 0 .58 r
F
.07199 .37566 m .06859 .38348 L .05632 .53099 L .449 0 .267 r
F
.11285 .38342 m .10201 .48862 L .10563 .4812 L .49 0 .291 r
F
.43078 .37065 m .44913 .38316 L .42563 .37852 L .208 0 .954 r
F
.43078 .37065 m .45438 .37534 L .44913 .38316 L F
.42563 .37852 m .44908 .40045 L .44913 .38316 L .212 0 .975 r
F
.45438 .37534 m .44913 .38316 L .44908 .40045 L .153 0 .703 r
F
.47003 .37845 m .49351 .39934 L .4934 .3831 L .212 0 .974 r
F
.51127 .38285 m .51147 .40199 L .53475 .40657 L .019 0 .974 r
F
.51683 .37502 m .51127 .38285 L .51147 .40199 L .015 0 .728 r
F
.60241 .37938 m .59682 .39997 L .60279 .39222 L 0 .135 .759 r
F
.55556 .38279 m .55593 .40166 L .57909 .40625 L .019 0 .974 r
F
.42344 .38186 m .41817 .41028 L .42327 .40259 L .287 0 .691 r
F
.29759 .36971 m .31697 .38224 L .29308 .37759 L .586 0 .954 r
F
.29759 .36971 m .32158 .37441 L .31697 .38224 L F
.29308 .37759 m .31591 .41696 L .31697 .38224 L .599 0 .975 r
F
.32158 .37441 m .31697 .38224 L .31591 .41696 L .391 0 .636 r
F
.36127 .38218 m .35576 .42296 L .36057 .41531 L .406 0 .661 r
F
.3375 .37752 m .36057 .41531 L .36127 .38218 L .599 0 .975 r
F
.37913 .38193 m .37874 .40423 L .40243 .40882 L .406 0 .975 r
F
.38404 .37409 m .37913 .38193 L .37874 .40423 L .279 0 .67 r
F
.42344 .38186 m .42327 .40259 L .44683 .40718 L .406 0 .975 r
F
.69027 .38037 m .69079 .39111 L .71354 .39572 L 0 .559 .973 r
F
.69724 .38329 m .71354 .39572 L .69079 .39111 L 0 .547 .953 r
F
.7195 .3772 m .71354 .39572 L .72009 .38795 L 0 .454 .791 r
F
.69724 .38329 m .72009 .38795 L .71354 .39572 L 0 .547 .953 r
F
.16424 .36877 m .18467 .38132 L .16038 .37666 L .954 0 .945 r
F
.16424 .36877 m .18864 .37347 L .18467 .38132 L F
.16424 .36877 m .18467 .38132 L .16038 .37666 L F
.16424 .36877 m .18864 .37347 L .18467 .38132 L F
.22899 .38125 m .22314 .42312 L .2273 .41546 L .58 0 .574 r
F
.20482 .37659 m .2273 .41546 L .22899 .38125 L .976 0 .966 r
F
.24684 .381 m .24506 .41999 L .26924 .42455 L .792 0 .976 r
F
.25111 .37316 m .24684 .381 L .24506 .41999 L .481 0 .592 r
F
.51705 .39422 m .53475 .40657 L .51147 .40199 L .019 0 .952 r
F
.54011 .37969 m .53475 .40657 L .54043 .39885 L .015 0 .738 r
F
.51705 .39422 m .54043 .39885 L .53475 .40657 L .019 0 .952 r
F
.29116 .38094 m .28968 .42206 L .31374 .42661 L .792 0 .975 r
F
.29116 .38094 m .2852 .42969 L .28968 .42206 L .504 0 .621 r
F
.14893 .4584 m .16948 .47025 L .14514 .46585 L .948 0 .563 r
F
.14893 .4584 m .17338 .46284 L .16948 .47025 L F
.47003 .37845 m .46473 .40246 L .47006 .39472 L .155 0 .71 r
F
.61102 .36813 m .62799 .38068 L .60498 .37602 L 0 .359 .954 r
F
.61102 .36813 m .63412 .37283 L .62799 .38068 L F
.60498 .37602 m .62844 .39352 L .62799 .38068 L 0 .366 .974 r
F
.63412 .37283 m .62799 .38068 L .62844 .39352 L 0 .288 .767 r
F
.64946 .37596 m .67286 .39214 L .67234 .38062 L 0 .366 .973 r
F
.69671 .37252 m .69027 .38037 L .69079 .39111 L 0 .45 .784 r
F
.09655 .38033 m .08157 .53531 L .08513 .52803 L .474 0 .282 r
F
.07199 .37566 m .08513 .52803 L .09655 .38033 L .976 0 .58 r
F
.11439 .38008 m .10338 .52975 L .12856 .53408 L .976 0 .773 r
F
.11802 .37223 m .11439 .38008 L .10338 .52975 L .49 0 .388 r
F
.15874 .38002 m .15461 .4444 L .17919 .44891 L .976 0 .773 r
F
.15874 .38002 m .15077 .45197 L .15461 .4444 L .527 0 .418 r
F
.64946 .37596 m .6437 .39528 L .64992 .3875 L 0 .29 .772 r
F
.47772 .36719 m .49574 .37975 L .47233 .37509 L .019 0 .954 r
F
.47772 .36719 m .50123 .3719 L .49574 .37975 L F
.47233 .37509 m .49588 .39971 L .49574 .37975 L .019 0 .974 r
F
.50123 .3719 m .49574 .37975 L .49588 .39971 L .014 0 .721 r
F
.51683 .37502 m .54043 .39885 L .54011 .37969 L .019 0 .974 r
F
.60241 .37938 m .60279 .39222 L .62583 .39684 L 0 .173 .974 r
F
.55802 .37944 m .55829 .39255 L .58146 .39717 L F
.56411 .38473 m .58146 .39717 L .55829 .39255 L 0 .17 .953 r
F
.58702 .37627 m .58146 .39717 L .58737 .3894 L 0 .134 .753 r
F
.56411 .38473 m .58737 .3894 L .58146 .39717 L 0 .17 .953 r
F
.28968 .42206 m .30916 .4342 L .2852 .42969 L .772 0 .951 r
F
.28968 .42206 m .31374 .42661 L .30916 .4342 L F
.56382 .37158 m .55802 .37944 L .55829 .39255 L 0 .132 .744 r
F
.38368 .39647 m .40243 .40882 L .37874 .40423 L .396 0 .952 r
F
.40772 .37876 m .40243 .40882 L .40747 .4011 L .284 0 .683 r
F
.38368 .39647 m .40747 .4011 L .40243 .40882 L .396 0 .952 r
F
.34427 .36625 m .36333 .37883 L .33952 .37416 L .397 0 .954 r
F
.34427 .36625 m .36818 .37096 L .36333 .37883 L F
.33952 .37416 m .36287 .4009 L .36333 .37883 L .406 0 .975 r
F
.36818 .37096 m .36333 .37883 L .36287 .4009 L .275 0 .661 r
F
.33663 .41072 m .35576 .42296 L .33193 .41842 L .584 0 .951 r
F
.33663 .41072 m .36057 .41531 L .35576 .42296 L F
.38404 .37409 m .40747 .4011 L .40772 .37876 L .406 0 .975 r
F
.42563 .37852 m .4255 .39584 L .44908 .40045 L .212 0 .975 r
F
.43078 .37065 m .42563 .37852 L .4255 .39584 L .151 0 .691 r
F
.47003 .37845 m .47006 .39472 L .49351 .39934 L .212 0 .974 r
F
.21066 .3653 m .23077 .3779 L .20657 .37322 L .775 0 .954 r
F
.21066 .3653 m .23497 .37003 L .23077 .3779 L F
.20296 .41087 m .2273 .41546 L .22314 .42312 L .951 0 .942 r
F
.20482 .37659 m .20296 .41087 L .2273 .41546 L .976 0 .966 r
F
.20657 .37322 m .22814 .43188 L .23077 .3779 L .792 0 .976 r
F
.23497 .37003 m .23077 .3779 L .22814 .43188 L .471 0 .58 r
F
.27519 .37784 m .26924 .42455 L .27365 .41688 L .495 0 .61 r
F
.25111 .37316 m .27365 .41688 L .27519 .37784 L .792 0 .975 r
F
.29308 .37759 m .29184 .41238 L .31591 .41696 L .599 0 .975 r
F
.29759 .36971 m .29308 .37759 L .29184 .41238 L .381 0 .621 r
F
.3375 .37752 m .33663 .41072 L .36057 .41531 L .599 0 .975 r
F
.3375 .37752 m .33193 .41842 L .33663 .41072 L .397 0 .646 r
F
.20296 .41087 m .22314 .42312 L .1989 .41857 L .951 0 .942 r
F
.43067 .38803 m .44908 .40045 L .4255 .39584 L .208 0 .953 r
F
.45438 .37534 m .44908 .40045 L .45435 .39269 L .153 0 .703 r
F
.43067 .38803 m .45435 .39269 L .44908 .40045 L .208 0 .953 r
F
.65841 .36466 m .67506 .37726 L .65213 .37258 L 0 .548 .954 r
F
.65841 .36466 m .68143 .36938 L .67506 .37726 L F
.65213 .37258 m .6756 .38933 L .67506 .37726 L 0 .559 .973 r
F
.68143 .36938 m .67506 .37726 L .6756 .38933 L 0 .447 .78 r
F
.69671 .37252 m .72009 .38795 L .7195 .3772 L 0 .559 .973 r
F
.0769 .36436 m .09806 .37697 L .07345 .37229 L .954 0 .756 r
F
.0769 .36436 m .10162 .36909 L .09806 .37697 L F
.07199 .37566 m .05976 .52366 L .08513 .52803 L .976 0 .58 r
F
.05976 .52366 m .08157 .53531 L .05632 .53099 L .94 0 .558 r
F
.05976 .52366 m .08513 .52803 L .08157 .53531 L F
.07345 .37229 m .08173 .58892 L .09806 .37697 L .976 0 .773 r
F
.10162 .36909 m .09806 .37697 L .08173 .58892 L .474 0 .375 r
F
.1425 .37691 m .12856 .53408 L .13236 .52678 L .513 0 .406 r
F
.11802 .37223 m .13236 .52678 L .1425 .37691 L .976 0 .773 r
F
.69671 .37252 m .69079 .39111 L .69724 .38329 L 0 .45 .784 r
F
.64946 .37596 m .64992 .3875 L .67286 .39214 L 0 .366 .973 r
F
.20482 .37659 m .1989 .41857 L .20296 .41087 L .561 0 .556 r
F
.51683 .37502 m .51147 .40199 L .51705 .39422 L .015 0 .728 r
F
.52486 .36371 m .54255 .37633 L .51922 .37165 L 0 .17 .954 r
F
.52486 .36371 m .54828 .36844 L .54255 .37633 L F
.51922 .37165 m .5428 .39078 L .54255 .37633 L 0 .173 .974 r
F
.54828 .36844 m .54255 .37633 L .5428 .39078 L 0 .131 .738 r
F
.60498 .37602 m .60537 .38888 L .62844 .39352 L 0 .366 .974 r
F
.61143 .38103 m .62844 .39352 L .60537 .38888 L 0 .358 .953 r
F
.63412 .37283 m .62844 .39352 L .6346 .38571 L 0 .288 .767 r
F
.61143 .38103 m .6346 .38571 L .62844 .39352 L 0 .358 .953 r
F
.56382 .37158 m .58737 .3894 L .58702 .37627 L 0 .173 .974 r
F
.61102 .36813 m .60498 .37602 L .60537 .38888 L 0 .285 .759 r
F
.07199 .37566 m .05632 .53099 L .05976 .52366 L .449 0 .267 r
F
.39115 .36277 m .40989 .3754 L .38616 .37071 L .208 0 .954 r
F
.39115 .36277 m .41497 .3675 L .40989 .3754 L F
.38616 .37071 m .40969 .39407 L .40989 .3754 L .212 0 .975 r
F
.41497 .3675 m .40989 .3754 L .40969 .39407 L .149 0 .683 r
F
.43078 .37065 m .45435 .39269 L .45438 .37534 L .212 0 .974 r
F
.47233 .37509 m .47237 .39508 L .49588 .39971 L .019 0 .974 r
F
.47772 .36719 m .47233 .37509 L .47237 .39508 L .014 0 .71 r
F
.51683 .37502 m .51705 .39422 L .54043 .39885 L .019 0 .974 r
F
.56382 .37158 m .55829 .39255 L .56411 .38473 L 0 .132 .744 r
F
.25728 .36182 m .27707 .37447 L .25295 .36977 L .586 0 .954 r
F
.25728 .36182 m .28151 .36656 L .27707 .37447 L F
.25295 .36977 m .27584 .40612 L .27707 .37447 L .599 0 .975 r
F
.28151 .36656 m .27707 .37447 L .27584 .40612 L .374 0 .61 r
F
.32158 .37441 m .31591 .41696 L .32055 .40924 L .391 0 .636 r
F
.29759 .36971 m .32055 .40924 L .32158 .37441 L .599 0 .975 r
F
.38404 .37409 m .37874 .40423 L .38368 .39647 L .279 0 .67 r
F
.33952 .37416 m .33895 .39627 L .36287 .4009 L .406 0 .975 r
F
.34427 .36625 m .33952 .37416 L .33895 .39627 L .269 0 .646 r
F
.38404 .37409 m .38368 .39647 L .40747 .4011 L .406 0 .975 r
F
.70601 .36117 m .72232 .37383 L .69948 .36913 L 0 .737 .954 r
F
.70601 .36117 m .72895 .36592 L .72232 .37383 L F
.69948 .36913 m .72308 .3875 L .72232 .37383 L 0 .751 .973 r
F
.72895 .36592 m .72232 .37383 L .72308 .3875 L 0 .611 .791 r
F
.12326 .36087 m .14411 .37354 L .11958 .36884 L .954 0 .945 r
F
.12326 .36087 m .14789 .36562 L .14411 .37354 L F
.11958 .36884 m .13596 .4945 L .14411 .37354 L .976 0 .966 r
F
.14789 .36562 m .14411 .37354 L .13596 .4945 L .513 0 .508 r
F
.69671 .37252 m .69724 .38329 L .72009 .38795 L 0 .559 .973 r
F
.20657 .37322 m .20364 .42731 L .22814 .43188 L .792 0 .976 r
F
.21066 .3653 m .20657 .37322 L .20364 .42731 L .456 0 .561 r
F
.25111 .37316 m .24936 .41228 L .27365 .41688 L .792 0 .975 r
F
.25111 .37316 m .24506 .41999 L .24936 .41228 L .481 0 .592 r
F
.65213 .37258 m .65262 .38467 L .6756 .38933 L 0 .559 .973 r
F
.65892 .37679 m .6756 .38933 L .65262 .38467 L 0 .547 .953 r
F
.68143 .36938 m .6756 .38933 L .682 .38149 L 0 .447 .78 r
F
.65892 .37679 m .682 .38149 L .6756 .38933 L 0 .547 .953 r
F
.47779 .38724 m .49588 .39971 L .47237 .39508 L .019 0 .952 r
F
.50123 .3719 m .49588 .39971 L .5014 .39191 L .014 0 .721 r
F
.47779 .38724 m .5014 .39191 L .49588 .39971 L .019 0 .952 r
F
.5722 .36022 m .58956 .3729 L .56632 .36819 L 0 .359 .954 r
F
.5722 .36022 m .59553 .36497 L .58956 .3729 L F
.56632 .36819 m .5899 .38525 L .58956 .3729 L 0 .366 .974 r
F
.59553 .36497 m .58956 .3729 L .5899 .38525 L 0 .283 .753 r
F
.61102 .36813 m .6346 .38571 L .63412 .37283 L 0 .366 .973 r
F
.43078 .37065 m .4255 .39584 L .43067 .38803 L .151 0 .691 r
F
.65841 .36466 m .65213 .37258 L .65262 .38467 L 0 .443 .772 r
F
.24936 .41228 m .26924 .42455 L .24506 .41999 L .772 0 .951 r
F
.24936 .41228 m .27365 .41688 L .26924 .42455 L F
.07345 .37229 m .05596 .58467 L .08173 .58892 L .976 0 .773 r
F
.0769 .36436 m .07345 .37229 L .05596 .58467 L .449 0 .356 r
F
.11802 .37223 m .10707 .5224 L .13236 .52678 L .976 0 .773 r
F
.11802 .37223 m .10338 .52975 L .10707 .5224 L .49 0 .388 r
F
.43823 .35927 m .45664 .37196 L .433 .36725 L .019 0 .954 r
F
.43823 .35927 m .46197 .36403 L .45664 .37196 L F
.433 .36725 m .45662 .39304 L .45664 .37196 L .019 0 .974 r
F
.46197 .36403 m .45664 .37196 L .45662 .39304 L .014 0 .703 r
F
.47772 .36719 m .5014 .39191 L .50123 .3719 L .019 0 .974 r
F
.56382 .37158 m .56411 .38473 L .58737 .3894 L 0 .173 .974 r
F
.51922 .37165 m .5194 .38612 L .5428 .39078 L F
.52486 .36371 m .51922 .37165 L .5194 .38612 L 0 .13 .728 r
F
.61102 .36813 m .60537 .38888 L .61143 .38103 L 0 .285 .759 r
F
.52505 .37823 m .5428 .39078 L .5194 .38612 L 0 .17 .953 r
F
.54828 .36844 m .5428 .39078 L .54855 .38293 L 0 .131 .738 r
F
.52505 .37823 m .54855 .38293 L .5428 .39078 L 0 .17 .953 r
F
.34371 .38843 m .36287 .4009 L .33895 .39627 L .396 0 .952 r
F
.36818 .37096 m .36287 .4009 L .36774 .3931 L .275 0 .661 r
F
.34371 .38843 m .36774 .3931 L .36287 .4009 L .396 0 .952 r
F
.3041 .35832 m .32357 .37103 L .29953 .36631 L .397 0 .954 r
F
.3041 .35832 m .32825 .36309 L .32357 .37103 L F
.29953 .36631 m .32288 .39476 L .32357 .37103 L .406 0 .975 r
F
.32825 .36309 m .32357 .37103 L .32288 .39476 L .265 0 .636 r
F
.34427 .36625 m .36774 .3931 L .36818 .37096 L .406 0 .975 r
F
.15461 .4444 m .17525 .45643 L .15077 .45197 L .948 0 .751 r
F
.15461 .4444 m .17919 .44891 L .17525 .45643 L F
.38616 .37071 m .38587 .38941 L .40969 .39407 L .212 0 .975 r
F
.39115 .36277 m .38616 .37071 L .38587 .38941 L .146 0 .67 r
F
.43078 .37065 m .43067 .38803 L .45435 .39269 L .212 0 .974 r
F
.29637 .40461 m .31591 .41696 L .29184 .41238 L .584 0 .951 r
F
.29637 .40461 m .32055 .40924 L .31591 .41696 L F
.16982 .35737 m .19035 .37009 L .1659 .36537 L .775 0 .954 r
F
.16982 .35737 m .19437 .36214 L .19035 .37009 L F
.1659 .36537 m .1868 .43178 L .19035 .37009 L .792 0 .976 r
F
.19437 .36214 m .19035 .37009 L .1868 .43178 L .445 0 .548 r
F
.23497 .37003 m .22814 .43188 L .23237 .42418 L .471 0 .58 r
F
.21066 .3653 m .23237 .42418 L .23497 .37003 L .792 0 .975 r
F
.25295 .36977 m .25155 .40148 L .27584 .40612 L .599 0 .975 r
F
.25728 .36182 m .25295 .36977 L .25155 .40148 L .364 0 .592 r
F
.29759 .36971 m .29637 .40461 L .32055 .40924 L .599 0 .975 r
F
.29759 .36971 m .29184 .41238 L .29637 .40461 L .381 0 .621 r
F
.61975 .35672 m .63677 .36945 L .61362 .36472 L 0 .548 .954 r
F
.61975 .35672 m .64299 .36149 L .63677 .36945 L F
.61362 .36472 m .63728 .38314 L .63677 .36945 L 0 .559 .973 r
F
.64299 .36149 m .63677 .36945 L .63728 .38314 L 0 .44 .767 r
F
.65841 .36466 m .682 .38149 L .68143 .36938 L 0 .559 .973 r
F
.69948 .36913 m .70018 .38282 L .72308 .3875 L 0 .751 .973 r
F
.70673 .37491 m .72308 .3875 L .70018 .38282 L 0 .736 .953 r
F
.72895 .36592 m .72308 .3875 L .72973 .37963 L 0 .611 .791 r
F
.70673 .37491 m .72973 .37963 L .72308 .3875 L 0 .736 .953 r
F
.70601 .36117 m .69948 .36913 L .70018 .38282 L 0 .606 .784 r
F
.10162 .36909 m .08173 .58892 L .08536 .58176 L .474 0 .375 r
F
.0769 .36436 m .08536 .58176 L .10162 .36909 L .976 0 .773 r
F
.39087 .38153 m .40969 .39407 L .38587 .38941 L .208 0 .953 r
F
.41497 .3675 m .40969 .39407 L .41479 .38623 L .149 0 .683 r
F
.39087 .38153 m .41479 .38623 L .40969 .39407 L .208 0 .953 r
F
.11958 .36884 m .11078 .49004 L .13596 .4945 L .976 0 .966 r
F
.12326 .36087 m .11958 .36884 L .11078 .49004 L .49 0 .485 r
F
.56632 .36819 m .5666 .38057 L .5899 .38525 L 0 .366 .974 r
F
.57249 .37264 m .5899 .38525 L .5666 .38057 L 0 .358 .953 r
F
.59553 .36497 m .5899 .38525 L .59589 .37737 L 0 .283 .753 r
F
.57249 .37264 m .59589 .37737 L .5899 .38525 L 0 .358 .953 r
F
.48551 .35576 m .5036 .36851 L .48005 .36378 L 0 .17 .954 r
F
.48551 .35576 m .50917 .36054 L .5036 .36851 L F
.48005 .36378 m .50373 .383 L .5036 .36851 L 0 .173 .974 r
F
.50917 .36054 m .5036 .36851 L .50373 .383 L 0 .128 .721 r
F
.52486 .36371 m .54855 .38293 L .54828 .36844 L 0 .173 .974 r
F
.65841 .36466 m .65262 .38467 L .65892 .37679 L 0 .443 .772 r
F
.61102 .36813 m .61143 .38103 L .6346 .38571 L 0 .366 .973 r
F
.47772 .36719 m .47237 .39508 L .47779 .38724 L .014 0 .71 r
F
.5722 .36022 m .56632 .36819 L .5666 .38057 L 0 .28 .744 r
F
.35112 .35481 m .37027 .36757 L .34631 .36283 L .208 0 .954 r
F
.35112 .35481 m .37519 .35959 L .37027 .36757 L F
.34631 .36283 m .36987 .38841 L .37027 .36757 L .212 0 .975 r
F
.37519 .35959 m .37027 .36757 L .36987 .38841 L .144 0 .661 r
F
.39115 .36277 m .41479 .38623 L .41497 .3675 L .212 0 .974 r
F
.13861 .54341 m .15942 .55469 L .13485 .5505 L .94 0 .372 r
F
.13861 .54341 m .1633 .54764 L .15942 .55469 L F
.433 .36725 m .43288 .38837 L .45662 .39304 L .019 0 .974 r
F
.43823 .35927 m .433 .36725 L .43288 .38837 L .014 0 .691 r
F
.47772 .36719 m .47779 .38724 L .5014 .39191 L .019 0 .974 r
F
.52486 .36371 m .5194 .38612 L .52505 .37823 L 0 .13 .728 r
F
.21658 .35385 m .23679 .36663 L .21243 .36189 L .586 0 .954 r
F
.21658 .35385 m .24105 .35864 L .23679 .36663 L F
.21243 .36189 m .23472 .40986 L .23679 .36663 L .599 0 .975 r
F
.24105 .35864 m .23679 .36663 L .23472 .40986 L .356 0 .58 r
F
.34427 .36625 m .33895 .39627 L .34371 .38843 L .269 0 .646 r
F
.28151 .36656 m .27584 .40612 L .2803 .39831 L .374 0 .61 r
F
.25728 .36182 m .2803 .39831 L .28151 .36656 L .599 0 .975 r
F
.29953 .36631 m .29871 .39009 L .32288 .39476 L .406 0 .975 r
F
.3041 .35832 m .29953 .36631 L .29871 .39009 L .258 0 .621 r
F
.34427 .36625 m .34371 .38843 L .36774 .3931 L .406 0 .975 r
F
.6675 .3532 m .68419 .36598 L .66112 .36123 L 0 .737 .954 r
F
.6675 .3532 m .69065 .35799 L .68419 .36598 L F
.66112 .36123 m .6848 .3789 L .68419 .36598 L 0 .751 .973 r
F
.69065 .35799 m .68419 .36598 L .6848 .3789 L 0 .602 .78 r
F
.70601 .36117 m .72973 .37963 L .72895 .36592 L 0 .751 .973 r
F
.08187 .3529 m .10315 .36569 L .07838 .36094 L .954 0 .945 r
F
.08187 .3529 m .10675 .35769 L .10315 .36569 L F
.08187 .3529 m .10315 .36569 L .07838 .36094 L F
.08187 .3529 m .10675 .35769 L .10315 .36569 L F
.14789 .36562 m .13596 .4945 L .13981 .48699 L .513 0 .508 r
F
.12326 .36087 m .13981 .48699 L .14789 .36562 L .976 0 .966 r
F
.1659 .36537 m .16202 .42717 L .1868 .43178 L .792 0 .976 r
F
.16982 .35737 m .1659 .36537 L .16202 .42717 L .428 0 .527 r
F
.21066 .3653 m .20777 .41956 L .23237 .42418 L .792 0 .975 r
F
.21066 .3653 m .20364 .42731 L .20777 .41956 L .456 0 .561 r
F
.65841 .36466 m .65892 .37679 L .682 .38149 L 0 .559 .973 r
F
.533 .35224 m .55075 .36504 L .52729 .36029 L 0 .359 .954 r
F
.533 .35224 m .55657 .35704 L .55075 .36504 L F
.52729 .36029 m .55101 .37849 L .55075 .36504 L 0 .366 .974 r
F
.55657 .35704 m .55075 .36504 L .55101 .37849 L 0 .277 .738 r
F
.5722 .36022 m .59589 .37737 L .59553 .36497 L 0 .366 .973 r
F
.61362 .36472 m .61407 .37844 L .63728 .38314 L 0 .559 .973 r
F
.62021 .37048 m .63728 .38314 L .61407 .37844 L 0 .547 .953 r
F
.64299 .36149 m .63728 .38314 L .64352 .37522 L 0 .44 .767 r
F
.62021 .37048 m .64352 .37522 L .63728 .38314 L 0 .547 .953 r
F
.43813 .38045 m .45662 .39304 L .43288 .38837 L .019 0 .952 r
F
.46197 .36403 m .45662 .39304 L .46197 .38517 L .014 0 .703 r
F
.43813 .38045 m .46197 .38517 L .45662 .39304 L .019 0 .952 r
F
.61975 .35672 m .61362 .36472 L .61407 .37844 L 0 .435 .759 r
F
.70601 .36117 m .70018 .38282 L .70673 .37491 L 0 .606 .784 r
F
.0769 .36436 m .05947 .57747 L .08536 .58176 L .976 0 .773 r
F
.0769 .36436 m .05596 .58467 L .05947 .57747 L .449 0 .356 r
F
.39115 .36277 m .38587 .38941 L .39087 .38153 L .146 0 .67 r
F
.39835 .35128 m .41717 .36409 L .3933 .35934 L .019 0 .954 r
F
.39835 .35128 m .42232 .35608 L .41717 .36409 L F
.3933 .35934 m .41696 .3863 L .41717 .36409 L .019 0 .974 r
F
.42232 .35608 m .41717 .36409 L .41696 .3863 L .014 0 .683 r
F
.43823 .35927 m .46197 .38517 L .46197 .36403 L .019 0 .974 r
F
.5722 .36022 m .5666 .38057 L .57249 .37264 L 0 .28 .744 r
F
.48005 .36378 m .4801 .37829 L .50373 .383 L 0 .173 .974 r
F
.48551 .35576 m .48005 .36378 L .4801 .37829 L 0 .126 .71 r
F
.52486 .36371 m .52505 .37823 L .54855 .38293 L 0 .173 .974 r
F
.2559 .39363 m .27584 .40612 L .25155 .40148 L .584 0 .951 r
F
.2559 .39363 m .2803 .39831 L .27584 .40612 L F
.48559 .37033 m .50373 .383 L .4801 .37829 L 0 .17 .953 r
F
.50917 .36054 m .50373 .383 L .50931 .37508 L 0 .128 .721 r
F
.48559 .37033 m .50931 .37508 L .50373 .383 L 0 .17 .953 r
F
.26354 .35032 m .28343 .36315 L .25915 .35839 L .397 0 .954 r
F
.26354 .35032 m .28793 .35513 L .28343 .36315 L F
.25915 .35839 m .28245 .38882 L .28343 .36315 L .406 0 .975 r
F
.28793 .35513 m .28343 .36315 L .28245 .38882 L .254 0 .61 r
F
.32825 .36309 m .32288 .39476 L .32757 .38689 L .265 0 .636 r
F
.3041 .35832 m .32757 .38689 L .32825 .36309 L .406 0 .975 r
F
.3033 .38217 m .32288 .39476 L .29871 .39009 L .396 0 .952 r
F
.3033 .38217 m .32757 .38689 L .32288 .39476 L F
.34631 .36283 m .3458 .38372 L .36987 .38841 L .212 0 .975 r
F
.35112 .35481 m .34631 .36283 L .3458 .38372 L .141 0 .646 r
F
.39115 .36277 m .39087 .38153 L .41479 .38623 L .212 0 .974 r
F
.71545 .34966 m .7318 .3625 L .70883 .35773 L 0 .925 .954 r
F
.71545 .34966 m .73852 .35447 L .7318 .3625 L F
.71545 .34966 m .7318 .3625 L .70883 .35773 L F
.71545 .34966 m .73852 .35447 L .7318 .3625 L F
.12857 .34936 m .14953 .3622 L .12484 .35744 L .775 0 .954 r
F
.12857 .34936 m .15337 .35418 L .14953 .3622 L F
.12484 .35744 m .14313 .45866 L .14953 .3622 L .792 0 .976 r
F
.15337 .35418 m .14953 .3622 L .14313 .45866 L .416 0 .513 r
F
.19437 .36214 m .1868 .43178 L .19086 .42403 L .445 0 .548 r
F
.16982 .35737 m .19086 .42403 L .19437 .36214 L .792 0 .975 r
F
.21243 .36189 m .21013 .4052 L .23472 .40986 L .599 0 .975 r
F
.21658 .35385 m .21243 .36189 L .21013 .4052 L .345 0 .561 r
F
.25728 .36182 m .2559 .39363 L .2803 .39831 L .599 0 .975 r
F
.25728 .36182 m .25155 .40148 L .2559 .39363 L .364 0 .592 r
F
.5807 .3487 m .59811 .36155 L .57474 .35678 L 0 .548 .954 r
F
.5807 .3487 m .60417 .35352 L .59811 .36155 L F
.57474 .35678 m .59857 .37714 L .59811 .36155 L 0 .559 .973 r
F
.60417 .35352 m .59811 .36155 L .59857 .37714 L 0 .432 .753 r
F
.66112 .36123 m .66168 .37418 L .6848 .3789 L 0 .751 .973 r
F
.66807 .36618 m .6848 .3789 L .66168 .37418 L 0 .736 .953 r
F
.69065 .35799 m .6848 .3789 L .69129 .37095 L 0 .602 .78 r
F
.66807 .36618 m .69129 .37095 L .6848 .3789 L 0 .736 .953 r
F
.61975 .35672 m .64352 .37522 L .64299 .36149 L 0 .559 .973 r
F
.6675 .3532 m .66112 .36123 L .66168 .37418 L 0 .596 .772 r
F
.70601 .36117 m .70673 .37491 L .72973 .37963 L 0 .751 .973 r
F
.12326 .36087 m .11451 .48248 L .13981 .48699 L .976 0 .966 r
F
.12326 .36087 m .11078 .49004 L .11451 .48248 L .49 0 .485 r
F
.5722 .36022 m .57249 .37264 L .59589 .37737 L 0 .366 .973 r
F
.44578 .34774 m .46427 .36061 L .44048 .35583 L 0 .17 .954 r
F
.44578 .34774 m .46967 .35256 L .46427 .36061 L F
.44048 .35583 m .46428 .37647 L .46427 .36061 L 0 .173 .974 r
F
.46967 .35256 m .46427 .36061 L .46428 .37647 L 0 .125 .703 r
F
.48551 .35576 m .50931 .37508 L .50917 .36054 L 0 .173 .974 r
F
.52729 .36029 m .52748 .37376 L .55101 .37849 L 0 .366 .974 r
F
.53321 .36576 m .55101 .37849 L .52748 .37376 L 0 .358 .953 r
F
.55657 .35704 m .55101 .37849 L .55684 .37053 L 0 .277 .738 r
F
.53321 .36576 m .55684 .37053 L .55101 .37849 L 0 .358 .953 r
F
.35063 .37576 m .36987 .38841 L .3458 .38372 L .208 0 .952 r
F
.37519 .35959 m .36987 .38841 L .3748 .38051 L .144 0 .661 r
F
.35063 .37576 m .3748 .38051 L .36987 .38841 L .208 0 .952 r
F
.533 .35224 m .52729 .36029 L .52748 .37376 L 0 .274 .728 r
F
.61975 .35672 m .61407 .37844 L .62021 .37048 L 0 .435 .759 r
F
.43823 .35927 m .43288 .38837 L .43813 .38045 L .014 0 .691 r
F
.31071 .34677 m .33027 .35966 L .30607 .35487 L .208 0 .954 r
F
.31071 .34677 m .33501 .3516 L .33027 .35966 L F
.30607 .35487 m .32967 .3811 L .33027 .35966 L .212 0 .975 r
F
.33501 .3516 m .33027 .35966 L .32967 .3811 L .139 0 .636 r
F
.35112 .35481 m .3748 .38051 L .37519 .35959 L .212 0 .974 r
F
.20777 .41956 m .22814 .43188 L .20364 .42731 L .771 0 .949 r
F
.20777 .41956 m .23237 .42418 L .22814 .43188 L F
.3933 .35934 m .39298 .38158 L .41696 .3863 L .019 0 .974 r
F
.39835 .35128 m .3933 .35934 L .39298 .38158 L .013 0 .67 r
F
.43823 .35927 m .43813 .38045 L .46197 .38517 L .019 0 .974 r
F
.48551 .35576 m .4801 .37829 L .48559 .37033 L 0 .126 .71 r
F
.17548 .34581 m .19611 .35871 L .17151 .35392 L .586 0 .954 r
F
.17548 .34581 m .20019 .35064 L .19611 .35871 L F
.17151 .35392 m .19296 .41447 L .19611 .35871 L .599 0 .975 r
F
.20019 .35064 m .19611 .35871 L .19296 .41447 L .337 0 .548 r
F
.24105 .35864 m .23472 .40986 L .23901 .40202 L .356 0 .58 r
F
.21658 .35385 m .23901 .40202 L .24105 .35864 L .599 0 .975 r
F
.25915 .35839 m .25804 .3841 L .28245 .38882 L .406 0 .975 r
F
.26354 .35032 m .25915 .35839 L .25804 .3841 L .246 0 .592 r
F
.3041 .35832 m .3033 .38217 L .32757 .38689 L .406 0 .975 r
F
.3041 .35832 m .29871 .39009 L .3033 .38217 L .258 0 .621 r
F
.6286 .34514 m .64568 .35805 L .62239 .35326 L 0 .737 .954 r
F
.6286 .34514 m .65198 .34998 L .64568 .35805 L F
.62239 .35326 m .64626 .37287 L .64568 .35805 L 0 .751 .973 r
F
.65198 .34998 m .64568 .35805 L .64626 .37287 L 0 .592 .767 r
F
.6675 .3532 m .69129 .37095 L .69065 .35799 L 0 .751 .973 r
F
.12484 .35744 m .11792 .45408 L .14313 .45866 L .792 0 .976 r
F
.12857 .34936 m .12484 .35744 L .11792 .45408 L .398 0 .49 r
F
.16982 .35737 m .16597 .41938 L .19086 .42403 L .792 0 .975 r
F
.16982 .35737 m .16202 .42717 L .16597 .41938 L .428 0 .527 r
F
.49342 .34418 m .51157 .3571 L .48787 .3523 L 0 .359 .954 r
F
.49342 .34418 m .51722 .34902 L .51157 .3571 L F
.48787 .3523 m .51172 .37139 L .51157 .3571 L 0 .366 .974 r
F
.51722 .34902 m .51157 .3571 L .51172 .37139 L 0 .271 .721 r
F
.533 .35224 m .55684 .37053 L .55657 .35704 L 0 .366 .973 r
F
.57474 .35678 m .57511 .3724 L .59857 .37714 L 0 .559 .973 r
F
.5807 .3487 m .57474 .35678 L .57511 .3724 L 0 .427 .744 r
F
.6675 .3532 m .66168 .37418 L .66807 .36618 L 0 .596 .772 r
F
.61975 .35672 m .62021 .37048 L .64352 .37522 L 0 .559 .973 r
F
.39805 .3736 m .41696 .3863 L .39298 .38158 L .019 0 .952 r
F
.42232 .35608 m .41696 .3863 L .42214 .37836 L .014 0 .683 r
F
.39805 .3736 m .42214 .37836 L .41696 .3863 L .019 0 .952 r
F
.5811 .36437 m .59857 .37714 L .57511 .3724 L 0 .547 .953 r
F
.60417 .35352 m .59857 .37714 L .60465 .36916 L 0 .432 .753 r
F
.5811 .36437 m .60465 .36916 L .59857 .37714 L 0 .547 .953 r
F
.35808 .34321 m .37731 .35615 L .3532 .35135 L .019 0 .954 r
F
.35808 .34321 m .38229 .34806 L .37731 .35615 L F
.3532 .35135 m .3769 .37869 L .37731 .35615 L .019 0 .974 r
F
.38229 .34806 m .37731 .35615 L .3769 .37869 L .013 0 .661 r
F
.39835 .35128 m .42214 .37836 L .42232 .35608 L .019 0 .974 r
F
.44048 .35583 m .44041 .37172 L .46428 .37647 L 0 .173 .974 r
F
.44578 .34774 m .44048 .35583 L .44041 .37172 L 0 .123 .691 r
F
.48551 .35576 m .48559 .37033 L .50931 .37508 L 0 .173 .974 r
F
.533 .35224 m .52748 .37376 L .53321 .36576 L 0 .274 .728 r
F
.35112 .35481 m .3458 .38372 L .35063 .37576 L .141 0 .646 r
F
.22258 .34224 m .24289 .3552 L .21837 .35039 L .397 0 .954 r
F
.22258 .34224 m .24721 .3471 L .24289 .3552 L F
.21837 .35039 m .24114 .39272 L .24289 .3552 L .406 0 .975 r
F
.24721 .3471 m .24289 .3552 L .24114 .39272 L .241 0 .58 r
F
.28793 .35513 m .28245 .38882 L .28697 .38088 L .254 0 .61 r
F
.26354 .35032 m .28697 .38088 L .28793 .35513 L .406 0 .975 r
F
.44573 .36368 m .46428 .37647 L .44041 .37172 L 0 .17 .953 r
F
.46967 .35256 m .46428 .37647 L .4697 .36847 L 0 .125 .703 r
F
.44573 .36368 m .4697 .36847 L .46428 .37647 L 0 .17 .953 r
F
.30607 .35487 m .30536 .37636 L .32967 .3811 L .212 0 .975 r
F
.31071 .34677 m .30607 .35487 L .30536 .37636 L .135 0 .621 r
F
.35112 .35481 m .35063 .37576 L .3748 .38051 L .212 0 .974 r
F
.67671 .34157 m .69344 .35454 L .67025 .34973 L 0 .925 .954 r
F
.67671 .34157 m .7 .34643 L .69344 .35454 L F
.67671 .34157 m .69344 .35454 L .67025 .34973 L F
.67671 .34157 m .7 .34643 L .69344 .35454 L F
.26245 .37612 m .28245 .38882 L .25804 .3841 L .396 0 .952 r
F
.26245 .37612 m .28697 .38088 L .28245 .38882 L F
.08692 .34127 m .10831 .35424 L .08338 .34943 L .775 0 .954 r
F
.08692 .34127 m .11196 .34613 L .10831 .35424 L F
.08338 .34943 m .09859 .48343 L .10831 .35424 L .792 0 .976 r
F
.11196 .34613 m .10831 .35424 L .09859 .48343 L .385 0 .474 r
F
.15337 .35418 m .14313 .45866 L .14702 .45095 L .416 0 .513 r
F
.12857 .34936 m .14702 .45095 L .15337 .35418 L .792 0 .975 r
F
.17151 .35392 m .16806 .40978 L .19296 .41447 L .599 0 .975 r
F
.17548 .34581 m .17151 .35392 L .16806 .40978 L .324 0 .527 r
F
.21658 .35385 m .21431 .39731 L .23901 .40202 L .599 0 .975 r
F
.21658 .35385 m .21013 .4052 L .21431 .39731 L .345 0 .561 r
F
.54126 .3406 m .55908 .35358 L .53547 .34876 L 0 .548 .954 r
F
.54126 .3406 m .56497 .34547 L .55908 .35358 L F
.53547 .34876 m .55941 .36949 L .55908 .35358 L 0 .559 .973 r
F
.56497 .34547 m .55908 .35358 L .55941 .36949 L 0 .423 .738 r
F
.5807 .3487 m .60465 .36916 L .60417 .35352 L 0 .559 .973 r
F
.6675 .3532 m .66807 .36618 L .69129 .37095 L 0 .751 .973 r
F
.62239 .35326 m .6229 .3681 L .64626 .37287 L F
.6286 .34514 m .62239 .35326 L .6229 .3681 L 0 .586 .759 r
F
.62913 .36003 m .64626 .37287 L .6229 .3681 L 0 .736 .953 r
F
.65198 .34998 m .64626 .37287 L .65259 .36485 L 0 .592 .767 r
F
.62913 .36003 m .65259 .36485 L .64626 .37287 L 0 .736 .953 r
F
.40566 .33963 m .42455 .35263 L .40053 .3478 L 0 .17 .954 r
F
.40566 .33963 m .42978 .3445 L .42455 .35263 L F
.40053 .3478 m .42441 .3704 L .42455 .35263 L 0 .173 .974 r
F
.42978 .3445 m .42455 .35263 L .42441 .3704 L 0 .122 .683 r
F
.44578 .34774 m .4697 .36847 L .46967 .35256 L 0 .173 .974 r
F
.533 .35224 m .53321 .36576 L .55684 .37053 L 0 .366 .973 r
F
.48787 .3523 m .48796 .36662 L .51172 .37139 L 0 .366 .974 r
F
.49342 .34418 m .48787 .3523 L .48796 .36662 L 0 .267 .71 r
F
.31002 .36833 m .32967 .3811 L .30536 .37636 L .208 0 .952 r
F
.33501 .3516 m .32967 .3811 L .33443 .37312 L .139 0 .636 r
F
.31002 .36833 m .33443 .37312 L .32967 .3811 L .208 0 .952 r
F
.49352 .35854 m .51172 .37139 L .48796 .36662 L 0 .358 .953 r
F
.51722 .34902 m .51172 .37139 L .51739 .36336 L 0 .271 .721 r
F
.49352 .35854 m .51739 .36336 L .51172 .37139 L 0 .358 .953 r
F
.21431 .39731 m .23472 .40986 L .21013 .4052 L .584 0 .95 r
F
.21431 .39731 m .23901 .40202 L .23472 .40986 L F
.26989 .33866 m .28987 .35167 L .26544 .34684 L .208 0 .954 r
F
.26989 .33866 m .29443 .34354 L .28987 .35167 L F
.26544 .34684 m .28907 .37345 L .28987 .35167 L .212 0 .975 r
F
.29443 .34354 m .28987 .35167 L .28907 .37345 L .133 0 .61 r
F
.39835 .35128 m .39298 .38158 L .39805 .3736 L .013 0 .67 r
F
.31071 .34677 m .33443 .37312 L .33501 .3516 L .212 0 .974 r
F
.5807 .3487 m .57511 .3724 L .5811 .36437 L 0 .427 .744 r
F
.3532 .35135 m .35268 .37393 L .3769 .37869 L .019 0 .974 r
F
.35808 .34321 m .3532 .35135 L .35268 .37393 L .013 0 .646 r
F
.39835 .35128 m .39805 .3736 L .42214 .37836 L .019 0 .974 r
F
.72503 .33799 m .74142 .35101 L .71831 .34618 L 0 .954 .794 r
F
.72503 .33799 m .74823 .34287 L .74142 .35101 L F
.71831 .34618 m .74223 .36454 L .74142 .35101 L 0 .972 .809 r
F
.74823 .34287 m .74142 .35101 L .74223 .36454 L 0 .791 .658 r
F
.17875 .66295 m .19313 .66162 L .1911 .6649 L .928 0 .184 r
F
.13397 .33768 m .15503 .35071 L .13018 .34587 L .586 0 .954 r
F
.13397 .33768 m .15892 .34257 L .15503 .35071 L F
.13018 .34587 m .15052 .41969 L .15503 .35071 L .599 0 .975 r
F
.15892 .34257 m .15503 .35071 L .15052 .41969 L .315 0 .513 r
F
.20019 .35064 m .19296 .41447 L .19707 .40658 L .337 0 .548 r
F
.17548 .34581 m .19707 .40658 L .20019 .35064 L .599 0 .975 r
F
.21837 .35039 m .21642 .38798 L .24114 .39272 L .406 0 .975 r
F
.22258 .34224 m .21837 .35039 L .21642 .38798 L .234 0 .561 r
F
.26354 .35032 m .26245 .37612 L .28697 .38088 L .406 0 .975 r
F
.26354 .35032 m .25804 .3841 L .26245 .37612 L .246 0 .592 r
F
.44578 .34774 m .44041 .37172 L .44573 .36368 L 0 .123 .691 r
F
.58932 .33701 m .60679 .35005 L .58327 .34521 L 0 .737 .954 r
F
.58932 .33701 m .61293 .3419 L .60679 .35005 L F
.58327 .34521 m .60729 .36624 L .60679 .35005 L 0 .751 .973 r
F
.61293 .3419 m .60679 .35005 L .60729 .36624 L 0 .581 .753 r
F
.6286 .34514 m .65259 .36485 L .65198 .34998 L 0 .751 .973 r
F
.08338 .34943 m .07294 .47887 L .09859 .48343 L .792 0 .976 r
F
.08692 .34127 m .08338 .34943 L .07294 .47887 L .365 0 .449 r
F
.12857 .34936 m .12169 .44633 L .14702 .45095 L .792 0 .975 r
F
.12857 .34936 m .11792 .45408 L .12169 .44633 L .398 0 .49 r
F
.45344 .33603 m .472 .34909 L .44807 .34424 L 0 .359 .954 r
F
.45344 .33603 m .47748 .34093 L .472 .34909 L F
.44807 .34424 m .47204 .36582 L .472 .34909 L 0 .366 .974 r
F
.47748 .34093 m .472 .34909 L .47204 .36582 L 0 .264 .703 r
F
.49342 .34418 m .51739 .36336 L .51722 .34902 L 0 .366 .973 r
F
.16597 .41938 m .1868 .43178 L .16202 .42717 L .77 0 .949 r
F
.16597 .41938 m .19086 .42403 L .1868 .43178 L F
.53547 .34876 m .53572 .3647 L .55941 .36949 L 0 .559 .973 r
F
.54126 .3406 m .53547 .34876 L .53572 .3647 L 0 .418 .728 r
F
.5807 .3487 m .5811 .36437 L .60465 .36916 L 0 .559 .973 r
F
.16636 .661 m .16834 .6577 L .17875 .66295 L .928 0 .184 r
F
.17875 .66295 m .16834 .6577 L .19313 .66162 L F
.35758 .36587 m .3769 .37869 L .35268 .37393 L .019 0 .952 r
F
.38229 .34806 m .3769 .37869 L .38191 .37068 L .013 0 .661 r
F
.35758 .36587 m .38191 .37068 L .3769 .37869 L .019 0 .952 r
F
.31741 .33506 m .33705 .34813 L .31271 .34328 L .019 0 .954 r
F
.31741 .33506 m .34186 .33996 L .33705 .34813 L F
.31271 .34328 m .33642 .37181 L .33705 .34813 L .019 0 .974 r
F
.34186 .33996 m .33705 .34813 L .33642 .37181 L .013 0 .636 r
F
.6286 .34514 m .6229 .3681 L .62913 .36003 L 0 .586 .759 r
F
.35808 .34321 m .38191 .37068 L .38229 .34806 L .019 0 .974 r
F
.54154 .35659 m .55941 .36949 L .53572 .3647 L 0 .547 .953 r
F
.56497 .34547 m .55941 .36949 L .56532 .36143 L 0 .423 .738 r
F
.54154 .35659 m .56532 .36143 L .55941 .36949 L 0 .547 .953 r
F
.40053 .3478 m .4003 .36561 L .42441 .3704 L 0 .173 .974 r
F
.40566 .33963 m .40053 .3478 L .4003 .36561 L 0 .119 .67 r
F
.44578 .34774 m .44573 .36368 L .4697 .36847 L 0 .173 .974 r
F
.31071 .34677 m .30536 .37636 L .31002 .36833 L .135 0 .621 r
F
.49342 .34418 m .48796 .36662 L .49352 .35854 L 0 .267 .71 r
F
.18122 .33408 m .20195 .34716 L .17719 .34231 L .397 0 .954 r
F
.18122 .33408 m .20608 .33898 L .20195 .34716 L F
.17719 .34231 m .19929 .39506 L .20195 .34716 L .406 0 .975 r
F
.20608 .33898 m .20195 .34716 L .19929 .39506 L .228 0 .548 r
F
.24721 .3471 m .24114 .39272 L .24549 .38474 L .241 0 .58 r
F
.22258 .34224 m .24549 .38474 L .24721 .3471 L .406 0 .975 r
F
.26544 .34684 m .26453 .36866 L .28907 .37345 L .212 0 .975 r
F
.26989 .33866 m .26544 .34684 L .26453 .36866 L .129 0 .592 r
F
.31071 .34677 m .31002 .36833 L .33443 .37312 L .212 0 .974 r
F
.63758 .33341 m .65471 .3465 L .63128 .34164 L 0 .925 .954 r
F
.63758 .33341 m .6611 .33832 L .65471 .3465 L F
.63128 .34164 m .6553 .36085 L .65471 .3465 L 0 .943 .973 r
F
.6611 .33832 m .65471 .3465 L .6553 .36085 L 0 .744 .767 r
F
.40545 .3575 m .42441 .3704 L .4003 .36561 L 0 .17 .953 r
F
.42978 .3445 m .42441 .3704 L .42966 .36234 L 0 .122 .683 r
F
.40545 .3575 m .42966 .36234 L .42441 .3704 L 0 .17 .953 r
F
.71831 .34618 m .71906 .35973 L .74223 .36454 L 0 .972 .809 r
F
.7258 .35158 m .74223 .36454 L .71906 .35973 L 0 .953 .793 r
F
.74823 .34287 m .74223 .36454 L .74906 .35644 L 0 .791 .658 r
F
.7258 .35158 m .74906 .35644 L .74223 .36454 L 0 .953 .793 r
F
.72503 .33799 m .71831 .34618 L .71906 .35973 L 0 .784 .653 r
F
.11196 .34613 m .09859 .48343 L .10229 .47575 L .385 0 .474 r
F
.08692 .34127 m .10229 .47575 L .11196 .34613 L .792 0 .975 r
F
.13018 .34587 m .1253 .41498 L .15052 .41969 L .599 0 .975 r
F
.13397 .33768 m .13018 .34587 L .1253 .41498 L .301 0 .49 r
F
.17548 .34581 m .17205 .40186 L .19707 .40658 L .599 0 .975 r
F
.17548 .34581 m .16806 .40978 L .17205 .40186 L .324 0 .527 r
F
.50144 .33242 m .51965 .34554 L .49581 .34067 L 0 .548 .954 r
F
.50144 .33242 m .52538 .33734 L .51965 .34554 L F
.49342 .34418 m .49352 .35854 L .51739 .36336 L 0 .366 .973 r
F
.49581 .34067 m .51991 .36603 L .51965 .34554 L 0 .559 .973 r
F
.52538 .33734 m .51965 .34554 L .51991 .36603 L 0 .414 .721 r
F
.54126 .3406 m .56532 .36143 L .56497 .34547 L 0 .559 .973 r
F
.58327 .34521 m .58369 .36144 L .60729 .36624 L 0 .751 .973 r
F
.58932 .33701 m .58327 .34521 L .58369 .36144 L 0 .574 .744 r
F
.6286 .34514 m .62913 .36003 L .65259 .36485 L 0 .751 .973 r
F
.36514 .33144 m .38444 .34457 L .36019 .3397 L 0 .17 .954 r
F
.36514 .33144 m .3895 .33636 L .38444 .34457 L F
.36019 .3397 m .38413 .36347 L .38444 .34457 L 0 .173 .974 r
F
.3895 .33636 m .38444 .34457 L .38413 .36347 L 0 .118 .661 r
F
.40566 .33963 m .42966 .36234 L .42978 .3445 L 0 .173 .974 r
F
.58976 .35329 m .60729 .36624 L .58369 .36144 L 0 .736 .953 r
F
.61293 .3419 m .60729 .36624 L .61346 .35815 L 0 .581 .753 r
F
.58976 .35329 m .61346 .35815 L .60729 .36624 L 0 .736 .953 r
F
.44807 .34424 m .44802 .36101 L .47204 .36582 L 0 .366 .974 r
F
.45344 .33603 m .44807 .34424 L .44802 .36101 L 0 .26 .691 r
F
.269 .36055 m .28907 .37345 L .26453 .36866 L .208 0 .952 r
F
.29443 .34354 m .28907 .37345 L .29365 .36539 L .133 0 .61 r
F
.269 .36055 m .29365 .36539 L .28907 .37345 L .208 0 .952 r
F
.22867 .33046 m .24907 .3436 L .2244 .33872 L .208 0 .954 r
F
.22867 .33046 m .25345 .33539 L .24907 .3436 L F
.2244 .33872 m .2478 .37162 L .24907 .3436 L .212 0 .975 r
F
.25345 .33539 m .24907 .3436 L .2478 .37162 L .127 0 .58 r
F
.26989 .33866 m .29365 .36539 L .29443 .34354 L .212 0 .974 r
F
.35808 .34321 m .35268 .37393 L .35758 .36587 L .013 0 .646 r
F
.31271 .34328 m .31196 .367 L .33642 .37181 L .019 0 .974 r
F
.31741 .33506 m .31271 .34328 L .31196 .367 L .012 0 .621 r
F
.45342 .35286 m .47204 .36582 L .44802 .36101 L 0 .358 .953 r
F
.47748 .34093 m .47204 .36582 L .47754 .35772 L 0 .264 .703 r
F
.45342 .35286 m .47754 .35772 L .47204 .36582 L 0 .358 .953 r
F
.35808 .34321 m .35758 .36587 L .38191 .37068 L .019 0 .974 r
F
.54126 .3406 m .53572 .3647 L .54154 .35659 L 0 .418 .728 r
F
.68605 .32978 m .70283 .34294 L .6795 .33805 L 0 .954 .794 r
F
.68605 .32978 m .70949 .33471 L .70283 .34294 L F
.6795 .33805 m .70347 .35517 L .70283 .34294 L 0 .972 .809 r
F
.70949 .33471 m .70283 .34294 L .70347 .35517 L 0 .78 .649 r
F
.72503 .33799 m .74906 .35644 L .74823 .34287 L 0 .972 .809 r
F
.09204 .32948 m .11354 .34263 L .08845 .33775 L .586 0 .954 r
F
.09204 .32948 m .11725 .33441 L .11354 .34263 L F
.08845 .33775 m .10781 .41977 L .11354 .34263 L .599 0 .975 r
F
.11725 .33441 m .11354 .34263 L .10781 .41977 L .291 0 .474 r
F
.15892 .34257 m .15052 .41969 L .15445 .41177 L .315 0 .513 r
F
.13397 .33768 m .15445 .41177 L .15892 .34257 L .599 0 .975 r
F
.17719 .34231 m .17428 .3903 L .19929 .39506 L .406 0 .975 r
F
.18122 .33408 m .17719 .34231 L .17428 .3903 L .219 0 .527 r
F
.22258 .34224 m .22066 .37996 L .24549 .38474 L .406 0 .975 r
F
.22258 .34224 m .21642 .38798 L .22066 .37996 L .234 0 .561 r
F
.22066 .37996 m .24114 .39272 L .21642 .38798 L .396 0 .951 r
F
.22066 .37996 m .24549 .38474 L .24114 .39272 L F
.54964 .3288 m .56752 .34197 L .54377 .33708 L 0 .737 .954 r
F
.54964 .3288 m .5735 .33374 L .56752 .34197 L F
.54377 .33708 m .56785 .35688 L .56752 .34197 L 0 .751 .973 r
F
.5735 .33374 m .56752 .34197 L .56785 .35688 L 0 .569 .738 r
F
.58932 .33701 m .61346 .35815 L .61293 .3419 L 0 .751 .973 r
F
.63128 .34164 m .6318 .35602 L .6553 .36085 L 0 .943 .973 r
F
.63758 .33341 m .63128 .34164 L .6318 .35602 L 0 .736 .759 r
F
.40566 .33963 m .4003 .36561 L .40545 .3575 L 0 .119 .67 r
F
.63813 .34783 m .6553 .36085 L .6318 .35602 L 0 .924 .953 r
F
.6611 .33832 m .6553 .36085 L .66172 .35271 L 0 .744 .767 r
F
.63813 .34783 m .66172 .35271 L .6553 .36085 L 0 .924 .953 r
F
.72503 .33799 m .71906 .35973 L .7258 .35158 L 0 .784 .653 r
F
.08692 .34127 m .07653 .47115 L .10229 .47575 L .792 0 .975 r
F
.08692 .34127 m .07294 .47887 L .07653 .47115 L .365 0 .449 r
F
.41307 .32781 m .43204 .341 L .40787 .3361 L 0 .359 .954 r
F
.41307 .32781 m .43734 .33276 L .43204 .341 L F
.40787 .3361 m .43193 .35832 L .43204 .341 L 0 .366 .974 r
F
.43734 .33276 m .43204 .341 L .43193 .35832 L 0 .257 .683 r
F
.45344 .33603 m .47754 .35772 L .47748 .34093 L 0 .366 .973 r
F
.49581 .34067 m .49597 .36121 L .51991 .36603 L 0 .559 .973 r
F
.50144 .33242 m .49581 .34067 L .49597 .36121 L 0 .408 .71 r
F
.54126 .3406 m .54154 .35659 L .56532 .36143 L 0 .559 .973 r
F
.27633 .32682 m .2964 .34002 L .27182 .33512 L .019 0 .954 r
F
.27633 .32682 m .30103 .33177 L .2964 .34002 L F
.27182 .33512 m .29553 .36459 L .2964 .34002 L .019 0 .974 r
F
.30103 .33177 m .2964 .34002 L .29553 .36459 L .012 0 .61 r
F
.34186 .33996 m .33642 .37181 L .34125 .36372 L .013 0 .636 r
F
.31741 .33506 m .34125 .36372 L .34186 .33996 L .019 0 .974 r
F
.31668 .35886 m .33642 .37181 L .31196 .367 L .019 0 .952 r
F
.31668 .35886 m .34125 .36372 L .33642 .37181 L F
.36019 .3397 m .35978 .35863 L .38413 .36347 L 0 .173 .974 r
F
.36514 .33144 m .36019 .3397 L .35978 .35863 L 0 .115 .646 r
F
.40566 .33963 m .40545 .3575 L .42966 .36234 L 0 .173 .974 r
F
.58932 .33701 m .58369 .36144 L .58976 .35329 L 0 .574 .744 r
F
.17205 .40186 m .19296 .41447 L .16806 .40978 L .583 0 .949 r
F
.17205 .40186 m .19707 .40658 L .19296 .41447 L F
.73474 .32615 m .75117 .33936 L .72793 .33445 L 0 .954 .605 r
F
.73474 .32615 m .75808 .3311 L .75117 .33936 L F
.72793 .33445 m .7519 .35108 L .75117 .33936 L 0 .972 .616 r
F
.75808 .3311 m .75117 .33936 L .7519 .35108 L 0 .791 .502 r
F
.26989 .33866 m .26453 .36866 L .269 .36055 L .129 0 .592 r
F
.13944 .32584 m .1606 .33905 L .1356 .33415 L .397 0 .954 r
F
.13944 .32584 m .16455 .33079 L .1606 .33905 L F
.13397 .33768 m .12911 .40702 L .15445 .41177 L .599 0 .975 r
F
.12911 .40702 m .15445 .41177 L .15052 .41969 L .582 0 .948 r
F
.1356 .33415 m .15546 .41905 L .1606 .33905 L .406 0 .975 r
F
.16455 .33079 m .1606 .33905 L .15546 .41905 L .213 0 .513 r
F
.20608 .33898 m .19929 .39506 L .20346 .38704 L .228 0 .548 r
F
.18122 .33408 m .20346 .38704 L .20608 .33898 L .406 0 .975 r
F
.2244 .33872 m .22298 .36679 L .2478 .37162 L .212 0 .975 r
F
.22867 .33046 m .2244 .33872 L .22298 .36679 L .122 0 .561 r
F
.26989 .33866 m .269 .36055 L .29365 .36539 L .212 0 .974 r
F
.6795 .33805 m .68007 .35031 L .70347 .35517 L 0 .972 .809 r
F
.68665 .34208 m .70347 .35517 L .68007 .35031 L 0 .953 .793 r
F
.70949 .33471 m .70347 .35517 L .71014 .34699 L 0 .78 .649 r
F
.68665 .34208 m .71014 .34699 L .70347 .35517 L 0 .953 .793 r
F
.59806 .32516 m .61559 .33838 L .59193 .33347 L 0 .925 .954 r
F
.59806 .32516 m .62182 .33012 L .61559 .33838 L F
.59193 .33347 m .61619 .35653 L .61559 .33838 L 0 .943 .973 r
F
.62182 .33012 m .61559 .33838 L .61619 .35653 L 0 .73 .753 r
F
.45344 .33603 m .44802 .36101 L .45342 .35286 L 0 .26 .691 r
F
.50162 .35303 m .51991 .36603 L .49597 .36121 L 0 .547 .952 r
F
.52538 .33734 m .51991 .36603 L .52566 .3579 L 0 .414 .721 r
F
.50162 .35303 m .52566 .3579 L .51991 .36603 L 0 .547 .952 r
F
.63758 .33341 m .66172 .35271 L .6611 .33832 L 0 .943 .972 r
F
.72503 .33799 m .7258 .35158 L .74906 .35644 L 0 .972 .809 r
F
.68605 .32978 m .6795 .33805 L .68007 .35031 L 0 .772 .642 r
F
.36474 .35044 m .38413 .36347 L .35978 .35863 L 0 .17 .953 r
F
.3895 .33636 m .38413 .36347 L .38921 .35533 L 0 .118 .661 r
F
.36474 .35044 m .38921 .35533 L .38413 .36347 L 0 .17 .953 r
F
.08845 .33775 m .08229 .41504 L .10781 .41977 L .599 0 .975 r
F
.09204 .32948 m .08845 .33775 L .08229 .41504 L .276 0 .449 r
F
.13397 .33768 m .1253 .41498 L .12911 .40702 L .301 0 .49 r
F
.46122 .32417 m .47984 .33741 L .45576 .33249 L 0 .548 .954 r
F
.46122 .32417 m .4854 .32913 L .47984 .33741 L F
.45576 .33249 m .47993 .35851 L .47984 .33741 L 0 .559 .973 r
F
.4854 .32913 m .47984 .33741 L .47993 .35851 L 0 .403 .703 r
F
.50144 .33242 m .52566 .3579 L .52538 .33734 L 0 .559 .973 r
F
.54377 .33708 m .54403 .35202 L .56785 .35688 L 0 .751 .973 r
F
.54964 .3288 m .54377 .33708 L .54403 .35202 L 0 .562 .728 r
F
.58932 .33701 m .58976 .35329 L .61346 .35815 L 0 .751 .973 r
F
.54993 .34379 m .56785 .35688 L .54403 .35202 L 0 .736 .953 r
F
.5735 .33374 m .56785 .35688 L .57385 .34869 L 0 .569 .738 r
F
.54993 .34379 m .57385 .34869 L .56785 .35688 L 0 .736 .953 r
F
.63758 .33341 m .6318 .35602 L .63813 .34783 L 0 .736 .759 r
F
.32421 .32317 m .34394 .33643 L .31944 .33151 L 0 .17 .954 r
F
.32421 .32317 m .34881 .32815 L .34394 .33643 L F
.31944 .33151 m .34345 .35566 L .34394 .33643 L 0 .173 .974 r
F
.34881 .32815 m .34394 .33643 L .34345 .35566 L 0 .113 .636 r
F
.36514 .33144 m .38921 .35533 L .3895 .33636 L 0 .173 .974 r
F
.40787 .3361 m .40767 .35346 L .43193 .35832 L 0 .366 .974 r
F
.41307 .32781 m .40787 .3361 L .40767 .35346 L 0 .252 .67 r
F
.45344 .33603 m .45342 .35286 L .47754 .35772 L 0 .366 .973 r
F
.09171 .60904 m .11331 .62002 L .08811 .61594 L .932 0 .369 r
F
.09171 .60904 m .11703 .61316 L .11331 .62002 L F
.18704 .32218 m .20787 .33545 L .18295 .33053 L .208 0 .954 r
F
.18704 .32218 m .21207 .32716 L .20787 .33545 L F
.18295 .33053 m .20575 .37463 L .20787 .33545 L .212 0 .975 r
F
.21207 .32716 m .20787 .33545 L .20575 .37463 L .119 0 .548 r
F
.25345 .33539 m .2478 .37162 L .2522 .3635 L .127 0 .58 r
F
.22867 .33046 m .2522 .3635 L .25345 .33539 L .212 0 .974 r
F
.72793 .33445 m .7286 .34619 L .7519 .35108 L 0 .972 .616 r
F
.73543 .33793 m .7519 .35108 L .7286 .34619 L 0 .953 .604 r
F
.75808 .3311 m .7519 .35108 L .75883 .34286 L 0 .791 .502 r
F
.73543 .33793 m .75883 .34286 L .7519 .35108 L 0 .953 .604 r
F
.27182 .33512 m .27082 .35974 L .29553 .36459 L .019 0 .974 r
F
.27633 .32682 m .27182 .33512 L .27082 .35974 L .012 0 .592 r
F
.31741 .33506 m .31668 .35886 L .34125 .36372 L .019 0 .974 r
F
.31741 .33506 m .31196 .367 L .31668 .35886 L .012 0 .621 r
F
.41289 .34522 m .43193 .35832 L .40767 .35346 L 0 .358 .953 r
F
.43734 .33276 m .43193 .35832 L .43725 .35013 L 0 .257 .683 r
F
.41289 .34522 m .43725 .35013 L .43193 .35832 L 0 .358 .953 r
F
.64669 .3215 m .66387 .33478 L .6403 .32985 L 0 .954 .794 r
F
.64669 .3215 m .67036 .32648 L .66387 .33478 L F
.6403 .32985 m .66445 .34813 L .66387 .33478 L 0 .972 .809 r
F
.67036 .32648 m .66387 .33478 L .66445 .34813 L 0 .767 .638 r
F
.68605 .32978 m .71014 .34699 L .70949 .33471 L 0 .972 .809 r
F
.73474 .32615 m .72793 .33445 L .7286 .34619 L 0 .784 .497 r
F
.11725 .33441 m .10781 .41977 L .11155 .4118 L .291 0 .474 r
F
.09204 .32948 m .11155 .4118 L .11725 .33441 L .599 0 .975 r
F
.12911 .40702 m .15052 .41969 L .1253 .41498 L .582 0 .948 r
F
.1356 .33415 m .13001 .4143 L .15546 .41905 L .406 0 .975 r
F
.13944 .32584 m .1356 .33415 L .13001 .4143 L .204 0 .49 r
F
.18122 .33408 m .17833 .38223 L .20346 .38704 L .406 0 .975 r
F
.18122 .33408 m .17428 .3903 L .17833 .38223 L .219 0 .527 r
F
.10707 .5224 m .12856 .53408 L .10338 .52975 L .94 0 .744 r
F
.10707 .5224 m .13236 .52678 L .12856 .53408 L F
.50957 .3205 m .52785 .3338 L .50387 .32887 L 0 .737 .954 r
F
.50957 .3205 m .53366 .32549 L .52785 .3338 L F
.50387 .32887 m .52809 .3501 L .52785 .3338 L 0 .751 .973 r
F
.53366 .32549 m .52785 .3338 L .52809 .3501 L 0 .557 .721 r
F
.22727 .35862 m .2478 .37162 L .22298 .36679 L .207 0 .952 r
F
.22727 .35862 m .2522 .3635 L .2478 .37162 L F
.54964 .3288 m .57385 .34869 L .5735 .33374 L 0 .751 .973 r
F
.68605 .32978 m .68007 .35031 L .68665 .34208 L 0 .772 .642 r
F
.59193 .33347 m .59244 .35165 L .61619 .35653 L 0 .943 .973 r
F
.59806 .32516 m .59193 .33347 L .59244 .35165 L 0 .722 .744 r
F
.50144 .33242 m .49597 .36121 L .50162 .35303 L 0 .408 .71 r
F
.63758 .33341 m .63813 .34783 L .66172 .35271 L 0 .943 .972 r
F
.36514 .33144 m .35978 .35863 L .36474 .35044 L 0 .115 .646 r
F
.37229 .31951 m .39168 .33282 L .36727 .32788 L 0 .359 .954 r
F
.37229 .31951 m .39681 .3245 L .39168 .33282 L F
.36727 .32788 m .39138 .35289 L .39168 .33282 L 0 .366 .974 r
F
.39681 .3245 m .39168 .33282 L .39138 .35289 L 0 .248 .661 r
F
.41307 .32781 m .43725 .35013 L .43734 .33276 L 0 .366 .973 r
F
.45576 .33249 m .45574 .35363 L .47993 .35851 L 0 .559 .973 r
F
.46122 .32417 m .45576 .33249 L .45574 .35363 L 0 .397 .691 r
F
.50144 .33242 m .50162 .35303 L .52566 .3579 L 0 .559 .973 r
F
.11451 .48248 m .13596 .4945 L .11078 .49004 L .943 0 .933 r
F
.11451 .48248 m .13981 .48699 L .13596 .4945 L F
.5986 .34339 m .61619 .35653 L .59244 .35165 L 0 .924 .953 r
F
.62182 .33012 m .61619 .35653 L .62245 .34832 L 0 .73 .753 r
F
.5986 .34339 m .62245 .34832 L .61619 .35653 L 0 .924 .953 r
F
.23485 .31851 m .25534 .33184 L .23051 .32689 L .019 0 .954 r
F
.23485 .31851 m .25979 .32351 L .25534 .33184 L F
.23051 .32689 m .25409 .36026 L .25534 .33184 L .019 0 .974 r
F
.25979 .32351 m .25534 .33184 L .25409 .36026 L .012 0 .58 r
F
.54964 .3288 m .54403 .35202 L .54993 .34379 L 0 .562 .728 r
F
.30103 .33177 m .29553 .36459 L .30018 .35642 L .012 0 .61 r
F
.27633 .32682 m .30018 .35642 L .30103 .33177 L .019 0 .974 r
F
.31944 .33151 m .31885 .35078 L .34345 .35566 L 0 .173 .974 r
F
.32421 .32317 m .31944 .33151 L .31885 .35078 L 0 .11 .621 r
F
.36514 .33144 m .36474 .35044 L .38921 .35533 L 0 .173 .974 r
F
.27536 .35152 m .29553 .36459 L .27082 .35974 L .019 0 .952 r
F
.27536 .35152 m .30018 .35642 L .29553 .36459 L F
.69553 .31782 m .71236 .33117 L .68888 .32621 L 0 .954 .605 r
F
.69553 .31782 m .71911 .32283 L .71236 .33117 L F
.68888 .32621 m .713 .34319 L .71236 .33117 L 0 .972 .616 r
F
.71911 .32283 m .71236 .33117 L .713 .34319 L 0 .78 .494 r
F
.73474 .32615 m .75883 .34286 L .75808 .3311 L 0 .971 .616 r
F
.09724 .31751 m .11885 .33086 L .09359 .3259 L .397 0 .954 r
F
.09724 .31751 m .12261 .32252 L .11885 .33086 L F
.09204 .32948 m .08591 .40702 L .11155 .4118 L .599 0 .975 r
F
.08591 .40702 m .10781 .41977 L .08229 .41504 L .582 0 .947 r
F
.08591 .40702 m .11155 .4118 L .10781 .41977 L F
.09359 .3259 m .11082 .44026 L .11885 .33086 L .406 0 .975 r
F
.12261 .32252 m .11885 .33086 L .11082 .44026 L .197 0 .474 r
F
.16455 .33079 m .15546 .41905 L .15945 .41105 L .213 0 .513 r
F
.13944 .32584 m .15945 .41105 L .16455 .33079 L .406 0 .975 r
F
.18295 .33053 m .18061 .36978 L .20575 .37463 L .212 0 .975 r
F
.18704 .32218 m .18295 .33053 L .18061 .36978 L .115 0 .527 r
F
.22867 .33046 m .22727 .35862 L .2522 .3635 L .212 0 .974 r
F
.22867 .33046 m .22298 .36679 L .22727 .35862 L .122 0 .561 r
F
.17833 .38223 m .19929 .39506 L .17428 .3903 L .395 0 .95 r
F
.17833 .38223 m .20346 .38704 L .19929 .39506 L F
.68605 .32978 m .68665 .34208 L .71014 .34699 L 0 .972 .809 r
F
.73474 .32615 m .7286 .34619 L .73543 .33793 L 0 .784 .497 r
F
.55814 .31682 m .57608 .33018 L .55218 .32522 L 0 .925 .954 r
F
.55814 .31682 m .58214 .32183 L .57608 .33018 L F
.55218 .32522 m .57656 .34973 L .57608 .33018 L 0 .943 .973 r
F
.58214 .32183 m .57608 .33018 L .57656 .34973 L 0 .716 .738 r
F
.59806 .32516 m .62245 .34832 L .62182 .33012 L 0 .943 .972 r
F
.6403 .32985 m .64081 .34322 L .66445 .34813 L 0 .972 .809 r
F
.64722 .33491 m .66445 .34813 L .64081 .34322 L 0 .953 .793 r
F
.67036 .32648 m .66445 .34813 L .67096 .33987 L 0 .767 .638 r
F
.64722 .33491 m .67096 .33987 L .66445 .34813 L 0 .953 .793 r
F
.41307 .32781 m .40767 .35346 L .41289 .34522 L 0 .252 .67 r
F
.46122 .34538 m .47993 .35851 L .45574 .35363 L 0 .547 .952 r
F
.4854 .32913 m .47993 .35851 L .48551 .3503 L 0 .403 .703 r
F
.46122 .34538 m .48551 .3503 L .47993 .35851 L 0 .547 .952 r
F
.64669 .3215 m .6403 .32985 L .64081 .34322 L 0 .759 .631 r
F
.32364 .3425 m .34345 .35566 L .31885 .35078 L 0 .17 .952 r
F
.34881 .32815 m .34345 .35566 L .34835 .34744 L 0 .113 .636 r
F
.32364 .3425 m .34835 .34744 L .34345 .35566 L 0 .17 .952 r
F
.09204 .32948 m .08229 .41504 L .08591 .40702 L .276 0 .449 r
F
.42059 .31582 m .43963 .3292 L .41531 .32423 L 0 .548 .954 r
F
.42059 .31582 m .44501 .32084 L .43963 .3292 L F
.41531 .32423 m .43953 .35198 L .43963 .3292 L 0 .559 .973 r
F
.44501 .32084 m .43963 .3292 L .43953 .35198 L 0 .392 .683 r
F
.46122 .32417 m .48551 .3503 L .4854 .32913 L 0 .559 .973 r
F
.50387 .32887 m .50402 .3452 L .52809 .3501 L 0 .751 .973 r
F
.50957 .3205 m .50387 .32887 L .50402 .3452 L 0 .548 .71 r
F
.12169 .44633 m .14313 .45866 L .11792 .45408 L .768 0 .945 r
F
.12169 .44633 m .14702 .45095 L .14313 .45866 L F
.54964 .3288 m .54993 .34379 L .57385 .34869 L 0 .751 .973 r
F
.28287 .31482 m .30303 .32821 L .27829 .32324 L 0 .17 .954 r
F
.28287 .31482 m .30772 .31984 L .30303 .32821 L F
.27829 .32324 m .30234 .34858 L .30303 .32821 L 0 .173 .974 r
F
.30772 .31984 m .30303 .32821 L .30234 .34858 L 0 .109 .61 r
F
.32421 .32317 m .34835 .34744 L .34881 .32815 L 0 .173 .974 r
F
.50974 .33689 m .52809 .3501 L .50402 .3452 L 0 .736 .953 r
F
.53366 .32549 m .52809 .3501 L .53392 .34184 L 0 .557 .721 r
F
.50974 .33689 m .53392 .34184 L .52809 .3501 L 0 .736 .953 r
F
.36727 .32788 m .36687 .34798 L .39138 .35289 L 0 .366 .974 r
F
.37229 .31951 m .36727 .32788 L .36687 .34798 L 0 .243 .646 r
F
.41307 .32781 m .41289 .34522 L .43725 .35013 L 0 .366 .973 r
F
.74459 .31413 m .76106 .32753 L .73768 .32256 L 0 .954 .416 r
F
.74459 .31413 m .76807 .31916 L .76106 .32753 L F
.73768 .32256 m .76208 .34334 L .76106 .32753 L 0 .971 .424 r
F
.76807 .31916 m .76106 .32753 L .76208 .34334 L 0 .791 .345 r
F
.14498 .31382 m .16626 .32723 L .14109 .32225 L .208 0 .954 r
F
.14498 .31382 m .17027 .31885 L .16626 .32723 L F
.14109 .32225 m .16117 .4076 L .16626 .32723 L .212 0 .975 r
F
.17027 .31885 m .16626 .32723 L .16117 .4076 L .112 0 .513 r
F
.21207 .32716 m .20575 .37463 L .20997 .36646 L .119 0 .548 r
F
.18704 .32218 m .20997 .36646 L .21207 .32716 L .212 0 .974 r
F
.59806 .32516 m .59244 .35165 L .5986 .34339 L 0 .722 .744 r
F
.73474 .32615 m .73543 .33793 L .75883 .34286 L 0 .971 .616 r
F
.68888 .32621 m .68947 .33826 L .713 .34319 L 0 .972 .616 r
F
.69614 .32991 m .713 .34319 L .68947 .33826 L 0 .953 .604 r
F
.71911 .32283 m .713 .34319 L .71977 .33489 L 0 .78 .494 r
F
.69614 .32991 m .71977 .33489 L .713 .34319 L 0 .953 .604 r
F
.23051 .32689 m .22911 .35537 L .25409 .36026 L .019 0 .974 r
F
.23485 .31851 m .23051 .32689 L .22911 .35537 L .011 0 .561 r
F
.27633 .32682 m .27536 .35152 L .30018 .35642 L .019 0 .974 r
F
.27633 .32682 m .27082 .35974 L .27536 .35152 L .012 0 .592 r
F
.60693 .31313 m .62451 .32655 L .60071 .32157 L 0 .954 .794 r
F
.60693 .31313 m .63083 .31816 L .62451 .32655 L F
.60071 .32157 m .6249 .33779 L .62451 .32655 L 0 .972 .809 r
F
.63083 .31816 m .62451 .32655 L .6249 .33779 L 0 .753 .626 r
F
.64669 .3215 m .67096 .33987 L .67036 .32648 L 0 .972 .809 r
F
.69553 .31782 m .68888 .32621 L .68947 .33826 L 0 .772 .489 r
F
.09359 .3259 m .08495 .43552 L .11082 .44026 L .406 0 .975 r
F
.09724 .31751 m .09359 .3259 L .08495 .43552 L .187 0 .449 r
F
.13944 .32584 m .13388 .40626 L .15945 .41105 L .406 0 .975 r
F
.13944 .32584 m .13001 .4143 L .13388 .40626 L .204 0 .49 r
F
.37191 .33967 m .39138 .35289 L .36687 .34798 L 0 .358 .952 r
F
.39681 .3245 m .39138 .35289 L .39653 .34463 L 0 .248 .661 r
F
.37191 .33967 m .39653 .34463 L .39138 .35289 L 0 .358 .952 r
F
.4691 .31212 m .4878 .32556 L .46357 .32057 L 0 .737 .954 r
F
.4691 .31212 m .49343 .31716 L .4878 .32556 L F
.46357 .32057 m .48791 .34595 L .4878 .32556 L 0 .751 .973 r
F
.49343 .31716 m .4878 .32556 L .48791 .34595 L 0 .542 .703 r
F
.50957 .3205 m .53392 .34184 L .53366 .32549 L 0 .751 .973 r
F
.55218 .32522 m .55256 .34481 L .57656 .34973 L 0 .943 .973 r
F
.55814 .31682 m .55218 .32522 L .55256 .34481 L 0 .706 .728 r
F
.59806 .32516 m .5986 .34339 L .62245 .34832 L 0 .943 .972 r
F
.64669 .3215 m .64081 .34322 L .64722 .33491 L 0 .759 .631 r
F
.46122 .32417 m .45574 .35363 L .46122 .34538 L 0 .397 .691 r
F
.32421 .32317 m .31885 .35078 L .32364 .3425 L 0 .11 .621 r
F
.3311 .31112 m .35092 .32457 L .32627 .31958 L 0 .359 .954 r
F
.3311 .31112 m .35587 .31616 L .35092 .32457 L F
.32627 .31958 m .35044 .3447 L .35092 .32457 L 0 .366 .974 r
F
.35587 .31616 m .35092 .32457 L .35044 .3447 L 0 .239 .636 r
F
.37229 .31951 m .39653 .34463 L .39681 .3245 L 0 .366 .973 r
F
.41531 .32423 m .41509 .34706 L .43953 .35198 L 0 .559 .973 r
F
.42059 .31582 m .41531 .32423 L .41509 .34706 L 0 .384 .67 r
F
.46122 .32417 m .46122 .34538 L .48551 .3503 L 0 .559 .973 r
F
.19294 .31011 m .21388 .32358 L .1888 .31858 L .019 0 .954 r
F
.19294 .31011 m .21814 .31516 L .21388 .32358 L F
.1888 .31858 m .21208 .3575 L .21388 .32358 L .019 0 .974 r
F
.21814 .31516 m .21388 .32358 L .21208 .3575 L .011 0 .548 r
F
.25979 .32351 m .25409 .36026 L .25856 .35202 L .012 0 .58 r
F
.23485 .31851 m .25856 .35202 L .25979 .32351 L .019 0 .974 r
F
.27829 .32324 m .27748 .34365 L .30234 .34858 L 0 .173 .974 r
F
.28287 .31482 m .27829 .32324 L .27748 .34365 L 0 .105 .592 r
F
.55855 .33647 m .57656 .34973 L .55256 .34481 L 0 .924 .952 r
F
.58214 .32183 m .57656 .34973 L .58265 .34144 L 0 .716 .738 r
F
.55855 .33647 m .58265 .34144 L .57656 .34973 L 0 .924 .952 r
F
.32421 .32317 m .32364 .3425 L .34835 .34744 L 0 .173 .974 r
F
.50957 .3205 m .50402 .3452 L .50974 .33689 L 0 .548 .71 r
F
.65593 .30942 m .67316 .3229 L .64945 .31789 L 0 .954 .605 r
F
.65593 .30942 m .67974 .31447 L .67316 .3229 L F
.64945 .31789 m .67373 .3355 L .67316 .3229 L 0 .972 .616 r
F
.67974 .31447 m .67316 .3229 L .67373 .3355 L 0 .767 .486 r
F
.69553 .31782 m .71977 .33489 L .71911 .32283 L 0 .971 .616 r
F
.73768 .32256 m .73862 .33839 L .76208 .34334 L 0 .971 .424 r
F
.74459 .31413 m .73768 .32256 L .73862 .33839 L 0 .784 .342 r
F
.60071 .32157 m .60105 .33283 L .6249 .33779 L 0 .972 .809 r
F
.60728 .32443 m .6249 .33779 L .60105 .33283 L 0 .953 .793 r
F
.63083 .31816 m .6249 .33779 L .63125 .32944 L 0 .753 .626 r
F
.60728 .32443 m .63125 .32944 L .6249 .33779 L 0 .953 .793 r
F
.12261 .32252 m .11082 .44026 L .11463 .43228 L .197 0 .474 r
F
.09724 .31751 m .11463 .43228 L .12261 .32252 L .406 0 .975 r
F
.14109 .32225 m .13556 .40279 L .16117 .4076 L .212 0 .975 r
F
.14498 .31382 m .14109 .32225 L .13556 .40279 L .107 0 .49 r
F
.18704 .32218 m .18472 .36156 L .20997 .36646 L .212 0 .974 r
F
.18704 .32218 m .18061 .36978 L .18472 .36156 L .115 0 .527 r
F
.69553 .31782 m .68947 .33826 L .69614 .32991 L 0 .772 .489 r
F
.74556 .33002 m .76208 .34334 L .73862 .33839 L 0 .953 .415 r
F
.76807 .31916 m .76208 .34334 L .76912 .33501 L 0 .791 .345 r
F
.74556 .33002 m .76912 .33501 L .76208 .34334 L 0 .953 .415 r
F
.51783 .30841 m .53617 .3219 L .51204 .31689 L 0 .925 .954 r
F
.51783 .30841 m .54207 .31347 L .53617 .3219 L F
.51204 .31689 m .53646 .33989 L .53617 .3219 L 0 .943 .973 r
F
.54207 .31347 m .53617 .3219 L .53646 .33989 L 0 .699 .721 r
F
.55814 .31682 m .58265 .34144 L .58214 .32183 L 0 .943 .972 r
F
.23346 .34708 m .25409 .36026 L .22911 .35537 L .019 0 .952 r
F
.23346 .34708 m .25856 .35202 L .25409 .36026 L F
.64669 .3215 m .64722 .33491 L .67096 .33987 L 0 .972 .809 r
F
.18472 .36156 m .20575 .37463 L .18061 .36978 L .207 0 .951 r
F
.18472 .36156 m .20997 .36646 L .20575 .37463 L F
.60693 .31313 m .60071 .32157 L .60105 .33283 L 0 .744 .619 r
F
.42039 .33873 m .43953 .35198 L .41509 .34706 L 0 .547 .952 r
F
.44501 .32084 m .43953 .35198 L .44493 .3437 L 0 .392 .683 r
F
.42039 .33873 m .44493 .3437 L .43953 .35198 L 0 .547 .952 r
F
.28208 .3353 m .30234 .34858 L .27748 .34365 L 0 .17 .952 r
F
.30772 .31984 m .30234 .34858 L .30705 .34028 L 0 .109 .61 r
F
.28208 .3353 m .30705 .34028 L .30234 .34858 L 0 .17 .952 r
F
.37955 .3074 m .39902 .32091 L .37446 .31589 L 0 .548 .954 r
F
.37955 .3074 m .40422 .31246 L .39902 .32091 L F
.37229 .31951 m .37191 .33967 L .39653 .34463 L 0 .366 .973 r
F
.37446 .31589 m .39867 .34755 L .39902 .32091 L 0 .559 .973 r
F
.40422 .31246 m .39902 .32091 L .39867 .34755 L 0 .379 .661 r
F
.42059 .31582 m .44493 .3437 L .44501 .32084 L 0 .559 .973 r
F
.37229 .31951 m .36687 .34798 L .37191 .33967 L 0 .243 .646 r
F
.46357 .32057 m .46358 .341 L .48791 .34595 L 0 .751 .973 r
F
.4691 .31212 m .46357 .32057 L .46358 .341 L 0 .533 .691 r
F
.50957 .3205 m .50974 .33689 L .53392 .34184 L 0 .751 .973 r
F
.24111 .30639 m .26171 .31991 L .23672 .31489 L 0 .17 .954 r
F
.24111 .30639 m .26622 .31146 L .26171 .31991 L F
.23672 .31489 m .26068 .34386 L .26171 .31991 L 0 .173 .974 r
F
.26622 .31146 m .26171 .31991 L .26068 .34386 L 0 .103 .58 r
F
.28287 .31482 m .30705 .34028 L .30772 .31984 L 0 .173 .974 r
F
.32627 .31958 m .32568 .33974 L .35044 .3447 L 0 .366 .974 r
F
.3311 .31112 m .32627 .31958 L .32568 .33974 L 0 .233 .621 r
F
.70515 .30569 m .72202 .31923 L .69841 .3142 L 0 .954 .416 r
F
.70515 .30569 m .72887 .31077 L .72202 .31923 L F
.69841 .3142 m .72285 .334 L .72202 .31923 L 0 .971 .424 r
F
.72887 .31077 m .72202 .31923 L .72285 .334 L 0 .78 .34 r
F
.74459 .31413 m .76912 .33501 L .76807 .31916 L 0 .971 .423 r
F
.10251 .30537 m .12423 .31892 L .09881 .31389 L .208 0 .954 r
F
.10251 .30537 m .12805 .31045 L .12423 .31892 L F
.09724 .31751 m .08863 .4275 L .11463 .43228 L .406 0 .975 r
F
.08863 .4275 m .11463 .43228 L .11082 .44026 L .393 0 .944 r
F
.09881 .31389 m .1155 .43953 L .12423 .31892 L .212 0 .975 r
F
.12805 .31045 m .12423 .31892 L .1155 .43953 L .103 0 .474 r
F
.17027 .31885 m .16117 .4076 L .16523 .39949 L .112 0 .513 r
F
.14498 .31382 m .16523 .39949 L .17027 .31885 L .212 0 .974 r
F
.1888 .31858 m .18681 .35257 L .21208 .3575 L .019 0 .974 r
F
.19294 .31011 m .1888 .31858 L .18681 .35257 L .011 0 .527 r
F
.69553 .31782 m .69614 .32991 L .71977 .33489 L 0 .971 .616 r
F
.23485 .31851 m .23346 .34708 L .25856 .35202 L .019 0 .974 r
F
.23485 .31851 m .22911 .35537 L .23346 .34708 L .011 0 .561 r
F
.64945 .31789 m .64996 .33052 L .67373 .3355 L 0 .972 .616 r
F
.65646 .32209 m .67373 .3355 L .64996 .33052 L 0 .953 .604 r
F
.67974 .31447 m .67373 .3355 L .68034 .32711 L 0 .767 .486 r
F
.65646 .32209 m .68034 .32711 L .67373 .3355 L 0 .953 .604 r
F
.46913 .33262 m .48791 .34595 L .46358 .341 L 0 .735 .952 r
F
.49343 .31716 m .48791 .34595 L .49357 .33762 L 0 .542 .703 r
F
.46913 .33262 m .49357 .33762 L .48791 .34595 L 0 .735 .952 r
F
.55814 .31682 m .55256 .34481 L .55855 .33647 L 0 .706 .728 r
F
.56677 .30468 m .58476 .31823 L .56072 .3132 L 0 .954 .794 r
F
.56677 .30468 m .59091 .30976 L .58476 .31823 L F
.56072 .3132 m .58511 .33139 L .58476 .31823 L 0 .972 .809 r
F
.59091 .30976 m .58476 .31823 L .58511 .33139 L 0 .738 .614 r
F
.60693 .31313 m .63125 .32944 L .63083 .31816 L 0 .972 .809 r
F
.65593 .30942 m .64945 .31789 L .64996 .33052 L 0 .759 .481 r
F
.60693 .31313 m .60105 .33283 L .60728 .32443 L 0 .744 .619 r
F
.09724 .31751 m .08495 .43552 L .08863 .4275 L .187 0 .449 r
F
.33054 .33135 m .35044 .3447 L .32568 .33974 L 0 .358 .952 r
F
.35587 .31616 m .35044 .3447 L .35541 .33636 L 0 .239 .636 r
F
.33054 .33135 m .35541 .33636 L .35044 .3447 L 0 .358 .952 r
F
.42822 .30366 m .44734 .31723 L .42287 .31219 L 0 .737 .954 r
F
.42822 .30366 m .4528 .30875 L .44734 .31723 L F
.42287 .31219 m .44727 .33877 L .44734 .31723 L 0 .751 .973 r
F
.4528 .30875 m .44734 .31723 L .44727 .33877 L 0 .527 .683 r
F
.4691 .31212 m .49357 .33762 L .49343 .31716 L 0 .751 .973 r
F
.74459 .31413 m .73862 .33839 L .74556 .33002 L 0 .784 .342 r
F
.51204 .31689 m .51223 .33492 L .53646 .33989 L 0 .943 .973 r
F
.51783 .30841 m .51204 .31689 L .51223 .33492 L 0 .689 .71 r
F
.55814 .31682 m .55855 .33647 L .58265 .34144 L 0 .943 .972 r
F
.2895 .30265 m .30975 .31623 L .28485 .31119 L 0 .359 .954 r
F
.2895 .30265 m .31451 .30774 L .30975 .31623 L F
.28485 .31119 m .30907 .33724 L .30975 .31623 L 0 .366 .974 r
F
.31451 .30774 m .30975 .31623 L .30907 .33724 L 0 .229 .61 r
F
.3311 .31112 m .35541 .33636 L .35587 .31616 L 0 .366 .973 r
F
.42059 .31582 m .41509 .34706 L .42039 .33873 L 0 .384 .67 r
F
.28287 .31482 m .27748 .34365 L .28208 .3353 L 0 .105 .592 r
F
.37446 .31589 m .37396 .34259 L .39867 .34755 L 0 .559 .973 r
F
.37955 .3074 m .37446 .31589 L .37396 .34259 L 0 .371 .646 r
F
.42059 .31582 m .42039 .33873 L .44493 .3437 L 0 .559 .973 r
F
.75459 .30195 m .7711 .31554 L .74758 .3105 L 0 .954 .227 r
F
.75459 .30195 m .77821 .30704 L .7711 .31554 L F
.75459 .30195 m .7711 .31554 L .74758 .3105 L F
.75459 .30195 m .77821 .30704 L .7711 .31554 L F
.51805 .32649 m .53646 .33989 L .51223 .33492 L 0 .924 .953 r
F
.54207 .31347 m .53646 .33989 L .54238 .33152 L 0 .699 .721 r
F
.51805 .32649 m .54238 .33152 L .53646 .33989 L 0 .924 .953 r
F
.15061 .30163 m .172 .31523 L .14667 .31018 L .019 0 .954 r
F
.15061 .30163 m .17606 .30673 L .172 .31523 L F
.14667 .31018 m .16862 .36949 L .172 .31523 L .019 0 .974 r
F
.17606 .30673 m .172 .31523 L .16862 .36949 L .01 0 .513 r
F
.21814 .31516 m .21208 .3575 L .21636 .3492 L .011 0 .548 r
F
.19294 .31011 m .21636 .3492 L .21814 .31516 L .019 0 .974 r
F
.23672 .31489 m .23556 .33889 L .26068 .34386 L 0 .173 .974 r
F
.24111 .30639 m .23672 .31489 L .23556 .33889 L 0 .1 .561 r
F
.1318 .74147 m .14645 .74019 L .14449 .74335 L .916 0 .181 r
F
.28287 .31482 m .28208 .3353 L .30705 .34028 L 0 .173 .974 r
F
.61593 .30093 m .63356 .31454 L .60962 .30949 L 0 .954 .605 r
F
.61593 .30093 m .63998 .30603 L .63356 .31454 L F
.60962 .30949 m .63405 .32772 L .63356 .31454 L 0 .972 .616 r
F
.63998 .30603 m .63356 .31454 L .63405 .32772 L 0 .753 .477 r
F
.65593 .30942 m .68034 .32711 L .67974 .31447 L 0 .971 .616 r
F
.69841 .3142 m .69916 .329 L .72285 .334 L 0 .971 .424 r
F
.70515 .30569 m .69841 .3142 L .69916 .329 L 0 .772 .337 r
F
.74459 .31413 m .74556 .33002 L .76912 .33501 L 0 .971 .423 r
F
.60693 .31313 m .60728 .32443 L .63125 .32944 L 0 .972 .809 r
F
.70593 .32054 m .72285 .334 L .69916 .329 L 0 .953 .415 r
F
.72887 .31077 m .72285 .334 L .72972 .32559 L 0 .78 .34 r
F
.70593 .32054 m .72972 .32559 L .72285 .334 L 0 .953 .415 r
F
.08863 .4275 m .11082 .44026 L .08495 .43552 L .393 0 .944 r
F
.09881 .31389 m .08939 .43474 L .1155 .43953 L .212 0 .975 r
F
.10251 .30537 m .09881 .31389 L .08939 .43474 L .098 0 .449 r
F
.14498 .31382 m .13949 .39462 L .16523 .39949 L .212 0 .974 r
F
.14498 .31382 m .13556 .40279 L .13949 .39462 L .107 0 .49 r
F
.4771 .29991 m .49587 .31354 L .47149 .30848 L 0 .925 .954 r
F
.4771 .29991 m .50158 .30502 L .49587 .31354 L F
.47149 .30848 m .49601 .33294 L .49587 .31354 L 0 .943 .973 r
F
.50158 .30502 m .49587 .31354 L .49601 .33294 L 0 .682 .703 r
F
.56072 .3132 m .561 .32639 L .58511 .33139 L 0 .972 .809 r
F
.56707 .31791 m .58511 .33139 L .561 .32639 L 0 .953 .793 r
F
.59091 .30976 m .58511 .33139 L .59128 .32296 L 0 .738 .614 r
F
.56707 .31791 m .59128 .32296 L .58511 .33139 L 0 .953 .793 r
F
.51783 .30841 m .54238 .33152 L .54207 .31347 L 0 .943 .972 r
F
.65593 .30942 m .64996 .33052 L .65646 .32209 L 0 .759 .481 r
F
.4691 .31212 m .46358 .341 L .46913 .33262 L 0 .533 .691 r
F
.56677 .30468 m .56072 .3132 L .561 .32639 L 0 .728 .606 r
F
.3381 .29889 m .358 .31253 L .33319 .30747 L 0 .548 .954 r
F
.3381 .29889 m .36302 .304 L .358 .31253 L F
.3311 .31112 m .33054 .33135 L .35541 .33636 L 0 .366 .973 r
F
.33319 .30747 m .35738 .34062 L .358 .31253 L 0 .559 .973 r
F
.36302 .304 m .358 .31253 L .35738 .34062 L 0 .365 .636 r
F
.40422 .31246 m .39867 .34755 L .4039 .33919 L 0 .379 .661 r
F
.37955 .3074 m .4039 .33919 L .40422 .31246 L 0 .559 .973 r
F
.3311 .31112 m .32568 .33974 L .33054 .33135 L 0 .233 .621 r
F
.11907 .73959 m .12097 .73642 L .1318 .74147 L .916 0 .181 r
F
.1318 .74147 m .12097 .73642 L .14645 .74019 L F
.42287 .31219 m .42269 .33377 L .44727 .33877 L 0 .751 .973 r
F
.42822 .30366 m .42287 .31219 L .42269 .33377 L 0 .517 .67 r
F
.4691 .31212 m .46913 .33262 L .49357 .33762 L 0 .751 .973 r
F
.19894 .29787 m .21997 .31153 L .19473 .30646 L 0 .17 .954 r
F
.19894 .29787 m .22429 .30299 L .21997 .31153 L F
.19473 .30646 m .21825 .3448 L .21997 .31153 L 0 .173 .974 r
F
.22429 .30299 m .21997 .31153 L .21825 .3448 L 0 .098 .548 r
F
.19097 .34422 m .21208 .3575 L .18681 .35257 L .019 0 .951 r
F
.19097 .34422 m .21636 .3492 L .21208 .3575 L F
.26622 .31146 m .26068 .34386 L .26521 .33548 L 0 .103 .58 r
F
.24111 .30639 m .26521 .33548 L .26622 .31146 L 0 .173 .974 r
F
.37908 .33418 m .39867 .34755 L .37396 .34259 L 0 .546 .952 r
F
.37908 .33418 m .4039 .33919 L .39867 .34755 L F
.23997 .33046 m .26068 .34386 L .23556 .33889 L 0 .169 .952 r
F
.23997 .33046 m .26521 .33548 L .26068 .34386 L F
.28485 .31119 m .28405 .33223 L .30907 .33724 L 0 .366 .974 r
F
.2895 .30265 m .28485 .31119 L .28405 .33223 L 0 .223 .592 r
F
.13388 .40626 m .15546 .41905 L .13001 .4143 L .394 0 .947 r
F
.13388 .40626 m .15945 .41105 L .15546 .41905 L F
.66531 .29716 m .68258 .31084 L .65873 .30576 L 0 .954 .416 r
F
.66531 .29716 m .68926 .30229 L .68258 .31084 L F
.65873 .30576 m .68338 .32755 L .68258 .31084 L 0 .971 .424 r
F
.68926 .30229 m .68258 .31084 L .68338 .32755 L 0 .767 .334 r
F
.70515 .30569 m .72972 .32559 L .72887 .31077 L 0 .971 .423 r
F
.12805 .31045 m .1155 .43953 L .11937 .43147 L .103 0 .474 r
F
.10251 .30537 m .11937 .43147 L .12805 .31045 L .212 0 .974 r
F
.51783 .30841 m .51223 .33492 L .51805 .32649 L 0 .689 .71 r
F
.14667 .31018 m .14298 .36455 L .16862 .36949 L .019 0 .974 r
F
.15061 .30163 m .14667 .31018 L .14298 .36455 L .01 0 .49 r
F
.19294 .31011 m .19097 .34422 L .21636 .3492 L .019 0 .974 r
F
.19294 .31011 m .18681 .35257 L .19097 .34422 L .011 0 .527 r
F
.65593 .30942 m .65646 .32209 L .68034 .32711 L 0 .971 .616 r
F
.5262 .29614 m .54461 .30983 L .52033 .30475 L 0 .954 .794 r
F
.5262 .29614 m .55059 .30127 L .54461 .30983 L F
.52033 .30475 m .54488 .32466 L .54461 .30983 L 0 .972 .809 r
F
.55059 .30127 m .54461 .30983 L .54488 .32466 L 0 .721 .6 r
F
.60962 .30949 m .61004 .32269 L .63405 .32772 L 0 .972 .616 r
F
.61637 .31418 m .63405 .32772 L .61004 .32269 L 0 .953 .604 r
F
.63998 .30603 m .63405 .32772 L .64049 .31926 L 0 .753 .477 r
F
.61637 .31418 m .64049 .31926 L .63405 .32772 L 0 .953 .604 r
F
.56677 .30468 m .59128 .32296 L .59091 .30976 L 0 .972 .809 r
F
.42806 .32531 m .44727 .33877 L .42269 .33377 L 0 .735 .952 r
F
.4528 .30875 m .44727 .33877 L .45276 .33036 L 0 .527 .683 r
F
.42806 .32531 m .45276 .33036 L .44727 .33877 L 0 .735 .952 r
F
.61593 .30093 m .60962 .30949 L .61004 .32269 L 0 .744 .472 r
F
.07653 .47115 m .09859 .48343 L .07294 .47887 L .765 0 .942 r
F
.07653 .47115 m .10229 .47575 L .09859 .48343 L F
.70515 .30569 m .69916 .329 L .70593 .32054 L 0 .772 .337 r
F
.38692 .29511 m .40647 .30882 L .38175 .30373 L 0 .737 .954 r
F
.38692 .29511 m .41175 .30025 L .40647 .30882 L F
.38175 .30373 m .40616 .33477 L .40647 .30882 L 0 .751 .973 r
F
.41175 .30025 m .40647 .30882 L .40616 .33477 L 0 .51 .661 r
F
.42822 .30366 m .45276 .33036 L .4528 .30875 L 0 .751 .973 r
F
.28872 .32376 m .30907 .33724 L .28405 .33223 L 0 .358 .952 r
F
.31451 .30774 m .30907 .33724 L .31385 .32881 L 0 .229 .61 r
F
.28872 .32376 m .31385 .32881 L .30907 .33724 L 0 .358 .952 r
F
.47149 .30848 m .47153 .32792 L .49601 .33294 L 0 .943 .973 r
F
.4771 .29991 m .47149 .30848 L .47153 .32792 L 0 .67 .691 r
F
.56677 .30468 m .561 .32639 L .56707 .31791 L 0 .728 .606 r
F
.51783 .30841 m .51805 .32649 L .54238 .33152 L 0 .943 .972 r
F
.24747 .29409 m .26816 .30781 L .24301 .30272 L 0 .359 .954 r
F
.24747 .29409 m .27274 .29923 L .26816 .30781 L F
.24111 .30639 m .23997 .33046 L .26521 .33548 L 0 .173 .974 r
F
.24301 .30272 m .2669 .33813 L .26816 .30781 L 0 .366 .974 r
F
.27274 .29923 m .26816 .30781 L .2669 .33813 L 0 .218 .58 r
F
.2895 .30265 m .31385 .32881 L .31451 .30774 L 0 .366 .973 r
F
.33319 .30747 m .33242 .33561 L .35738 .34062 L 0 .559 .973 r
F
.3381 .29889 m .33319 .30747 L .33242 .33561 L 0 .356 .621 r
F
.37955 .3074 m .37908 .33418 L .4039 .33919 L 0 .559 .973 r
F
.37955 .3074 m .37396 .34259 L .37908 .33418 L 0 .371 .646 r
F
.71491 .29338 m .73182 .30711 L .70806 .30202 L 0 .954 .227 r
F
.71491 .29338 m .73877 .29853 L .73182 .30711 L F
.70806 .30202 m .73265 .32142 L .73182 .30711 L 0 .971 .231 r
F
.73877 .29853 m .73182 .30711 L .73265 .32142 L 0 .78 .186 r
F
.10786 .29306 m .12969 .3068 L .1041 .3017 L .019 0 .954 r
F
.10786 .29306 m .13356 .29821 L .12969 .3068 L F
.1041 .3017 m .12462 .37782 L .12969 .3068 L .019 0 .974 r
F
.13356 .29821 m .12969 .3068 L .12462 .37782 L .009 0 .474 r
F
.17606 .30673 m .16862 .36949 L .17272 .36117 L .01 0 .513 r
F
.15061 .30163 m .17272 .36117 L .17606 .30673 L .019 0 .974 r
F
.47717 .31941 m .49601 .33294 L .47153 .32792 L 0 .924 .952 r
F
.50158 .30502 m .49601 .33294 L .50175 .32448 L 0 .682 .703 r
F
.47717 .31941 m .50175 .32448 L .49601 .33294 L 0 .924 .952 r
F
.19473 .30646 m .19282 .33979 L .21825 .3448 L 0 .173 .974 r
F
.19894 .29787 m .19473 .30646 L .19282 .33979 L 0 .094 .527 r
F
.24111 .30639 m .23556 .33889 L .23997 .33046 L 0 .1 .561 r
F
.57552 .29235 m .59357 .3061 L .56938 .301 L 0 .954 .605 r
F
.57552 .29235 m .59981 .29751 L .59357 .3061 L F
.56938 .301 m .59396 .3196 L .59357 .3061 L 0 .972 .616 r
F
.59981 .29751 m .59357 .3061 L .59396 .3196 L 0 .738 .468 r
F
.61593 .30093 m .64049 .31926 L .63998 .30603 L 0 .971 .616 r
F
.65873 .30576 m .65944 .32251 L .68338 .32755 L 0 .971 .424 r
F
.66531 .29716 m .65873 .30576 L .65944 .32251 L 0 .759 .331 r
F
.70515 .30569 m .70593 .32054 L .72972 .32559 L 0 .971 .423 r
F
.10251 .30537 m .09314 .42664 L .11937 .43147 L .212 0 .974 r
F
.10251 .30537 m .08939 .43474 L .09314 .42664 L .098 0 .449 r
F
.43596 .29132 m .45515 .30509 L .43053 .29998 L 0 .925 .954 r
F
.43596 .29132 m .46069 .29648 L .45515 .30509 L F
.43053 .29998 m .45513 .32483 L .45515 .30509 L 0 .943 .973 r
F
.46069 .29648 m .45515 .30509 L .45513 .32483 L 0 .662 .683 r
F
.4771 .29991 m .50175 .32448 L .50158 .30502 L 0 .943 .972 r
F
.56677 .30468 m .56707 .31791 L .59128 .32296 L 0 .972 .809 r
F
.66605 .31396 m .68338 .32755 L .65944 .32251 L 0 .953 .415 r
F
.68926 .30229 m .68338 .32755 L .69009 .31906 L 0 .767 .334 r
F
.66605 .31396 m .69009 .31906 L .68338 .32755 L 0 .953 .415 r
F
.52033 .30475 m .52051 .3196 L .54488 .32466 L 0 .972 .809 r
F
.5262 .29614 m .52033 .30475 L .52051 .3196 L 0 .71 .591 r
F
.61593 .30093 m .61004 .32269 L .61637 .31418 L 0 .744 .472 r
F
.05947 .57747 m .08173 .58892 L .05596 .58467 L .932 0 .738 r
F
.05947 .57747 m .08536 .58176 L .08173 .58892 L F
.52641 .31104 m .54488 .32466 L .52051 .3196 L 0 .953 .793 r
F
.55059 .30127 m .54488 .32466 L .55088 .31615 L 0 .721 .6 r
F
.52641 .31104 m .55088 .31615 L .54488 .32466 L 0 .953 .793 r
F
.42822 .30366 m .42269 .33377 L .42806 .32531 L 0 .517 .67 r
F
.29623 .29029 m .31657 .30407 L .29151 .29896 L 0 .548 .954 r
F
.29623 .29029 m .3214 .29546 L .31657 .30407 L F
.2895 .30265 m .28872 .32376 L .31385 .32881 L 0 .366 .973 r
F
.29151 .29896 m .31566 .33334 L .31657 .30407 L 0 .559 .973 r
F
.3214 .29546 m .31657 .30407 L .31566 .33334 L 0 .35 .61 r
F
.36302 .304 m .35738 .34062 L .36243 .33218 L 0 .365 .636 r
F
.3381 .29889 m .36243 .33218 L .36302 .304 L 0 .559 .973 r
F
.38175 .30373 m .38131 .32973 L .40616 .33477 L 0 .751 .973 r
F
.38692 .29511 m .38175 .30373 L .38131 .32973 L 0 .499 .646 r
F
.42822 .30366 m .42806 .32531 L .45276 .33036 L 0 .751 .973 r
F
.2895 .30265 m .28405 .33223 L .28872 .32376 L 0 .223 .592 r
F
.76473 .28958 m .78128 .30338 L .75762 .29826 L 0 .954 .038 r
F
.76473 .28958 m .78849 .29475 L .78128 .30338 L F
.75762 .29826 m .78232 .31851 L .78128 .30338 L 0 .97 .039 r
F
.78849 .29475 m .78128 .30338 L .78232 .31851 L 0 .791 .032 r
F
.15633 .28926 m .17782 .30306 L .15232 .29794 L 0 .17 .954 r
F
.15633 .28926 m .18194 .29443 L .17782 .30306 L F
.15061 .30163 m .14696 .35618 L .17272 .36117 L .019 0 .974 r
F
.14696 .35618 m .17272 .36117 L .16862 .36949 L .019 0 .949 r
F
.15232 .29794 m .17312 .38002 L .17782 .30306 L 0 .173 .974 r
F
.18194 .29443 m .17782 .30306 L .17312 .38002 L 0 .091 .513 r
F
.22429 .30299 m .21825 .3448 L .22259 .33637 L 0 .098 .548 r
F
.19894 .29787 m .22259 .33637 L .22429 .30299 L 0 .173 .974 r
F
.24301 .30272 m .24158 .33309 L .2669 .33813 L 0 .366 .974 r
F
.24747 .29409 m .24301 .30272 L .24158 .33309 L 0 .211 .561 r
F
.33735 .32712 m .35738 .34062 L .33242 .33561 L 0 .546 .952 r
F
.33735 .32712 m .36243 .33218 L .35738 .34062 L F
.62506 .28855 m .64275 .30236 L .61865 .29723 L 0 .954 .416 r
F
.62506 .28855 m .64926 .29373 L .64275 .30236 L F
.61865 .29723 m .64339 .31886 L .64275 .30236 L 0 .971 .424 r
F
.64926 .29373 m .64275 .30236 L .64339 .31886 L 0 .753 .328 r
F
.66531 .29716 m .69009 .31906 L .68926 .30229 L 0 .971 .423 r
F
.70806 .30202 m .70883 .31635 L .73265 .32142 L 0 .971 .231 r
F
.71491 .29338 m .70806 .30202 L .70883 .31635 L 0 .772 .184 r
F
.7157 .30776 m .73265 .32142 L .70883 .31635 L 0 .953 .227 r
F
.73877 .29853 m .73265 .32142 L .73963 .31288 L 0 .78 .186 r
F
.7157 .30776 m .73963 .31288 L .73265 .32142 L 0 .953 .227 r
F
.1041 .3017 m .09862 .37286 L .12462 .37782 L .019 0 .974 r
F
.10786 .29306 m .1041 .3017 L .09862 .37286 L .009 0 .449 r
F
.15061 .30163 m .14298 .36455 L .14696 .35618 L .01 0 .49 r
F
.4771 .29991 m .47153 .32792 L .47717 .31941 L 0 .67 .691 r
F
.48522 .28751 m .50405 .30134 L .47952 .29621 L 0 .954 .794 r
F
.48522 .28751 m .50986 .2927 L .50405 .30134 L F
.47952 .29621 m .50419 .31567 L .50405 .30134 L 0 .972 .809 r
F
.50986 .2927 m .50405 .30134 L .50419 .31567 L 0 .703 .585 r
F
.5262 .29614 m .55088 .31615 L .55059 .30127 L 0 .972 .809 r
F
.61593 .30093 m .61637 .31418 L .64049 .31926 L 0 .971 .616 r
F
.56938 .301 m .5697 .31452 L .59396 .3196 L 0 .972 .616 r
F
.57585 .30592 m .59396 .3196 L .5697 .31452 L 0 .953 .604 r
F
.59981 .29751 m .59396 .3196 L .60022 .31105 L 0 .738 .468 r
F
.57585 .30592 m .60022 .31105 L .59396 .3196 L 0 .953 .604 r
F
.57552 .29235 m .56938 .301 L .5697 .31452 L 0 .728 .461 r
F
.3452 .28648 m .36519 .30032 L .34022 .29518 L 0 .737 .954 r
F
.3452 .28648 m .37028 .29167 L .36519 .30032 L F
.34022 .29518 m .36472 .32309 L .36519 .30032 L 0 .751 .973 r
F
.37028 .29167 m .36519 .30032 L .36472 .32309 L 0 .491 .636 r
F
.41175 .30025 m .40616 .33477 L .41147 .32629 L 0 .51 .661 r
F
.38692 .29511 m .41147 .32629 L .41175 .30025 L 0 .751 .973 r
F
.43053 .29998 m .4304 .31975 L .45513 .32483 L 0 .943 .973 r
F
.43596 .29132 m .43053 .29998 L .4304 .31975 L 0 .65 .67 r
F
.4771 .29991 m .47717 .31941 L .50175 .32448 L 0 .943 .972 r
F
.66531 .29716 m .65944 .32251 L .66605 .31396 L 0 .759 .331 r
F
.19704 .33131 m .21825 .3448 L .19282 .33979 L 0 .169 .951 r
F
.19704 .33131 m .22259 .33637 L .21825 .3448 L F
.3865 .3212 m .40616 .33477 L .38131 .32973 L 0 .735 .952 r
F
.3865 .3212 m .41147 .32629 L .40616 .33477 L F
.5262 .29614 m .52051 .3196 L .52641 .31104 L 0 .71 .591 r
F
.20502 .28544 m .22616 .2993 L .20075 .29416 L 0 .359 .954 r
F
.20502 .28544 m .23054 .29064 L .22616 .2993 L F
.20075 .29416 m .22419 .33821 L .22616 .2993 L 0 .366 .974 r
F
.23054 .29064 m .22616 .2993 L .22419 .33821 L 0 .206 .548 r
F
.27274 .29923 m .2669 .33813 L .2715 .32965 L 0 .218 .58 r
F
.24747 .29409 m .2715 .32965 L .27274 .29923 L 0 .366 .973 r
F
.29151 .29896 m .29043 .32829 L .31566 .33334 L 0 .559 .973 r
F
.29623 .29029 m .29151 .29896 L .29043 .32829 L 0 .34 .592 r
F
.3381 .29889 m .33735 .32712 L .36243 .33218 L 0 .559 .973 r
F
.3381 .29889 m .33242 .33561 L .33735 .32712 L 0 .356 .621 r
F
.13949 .39462 m .16117 .4076 L .13556 .40279 L .206 0 .947 r
F
.13949 .39462 m .16523 .39949 L .16117 .4076 L F
.67482 .28473 m .69215 .2986 L .66815 .29345 L 0 .954 .227 r
F
.67482 .28473 m .69893 .28993 L .69215 .2986 L F
.66815 .29345 m .69286 .31295 L .69215 .2986 L 0 .971 .231 r
F
.69893 .28993 m .69215 .2986 L .69286 .31295 L 0 .767 .183 r
F
.71491 .29338 m .73963 .31288 L .73877 .29853 L 0 .971 .231 r
F
.75762 .29826 m .75859 .31342 L .78232 .31851 L 0 .97 .039 r
F
.76473 .28958 m .75762 .29826 L .75859 .31342 L 0 .784 .031 r
F
.13356 .29821 m .12462 .37782 L .12852 .36947 L .009 0 .474 r
F
.10786 .29306 m .12852 .36947 L .13356 .29821 L .019 0 .974 r
F
.14696 .35618 m .16862 .36949 L .14298 .36455 L .019 0 .949 r
F
.15232 .29794 m .14718 .37505 L .17312 .38002 L 0 .173 .974 r
F
.15633 .28926 m .15232 .29794 L .14718 .37505 L 0 .087 .49 r
F
.43585 .31116 m .45513 .32483 L .4304 .31975 L 0 .924 .952 r
F
.46069 .29648 m .45513 .32483 L .46069 .31628 L 0 .662 .683 r
F
.43585 .31116 m .46069 .31628 L .45513 .32483 L 0 .924 .952 r
F
.76573 .30479 m .78232 .31851 L .75859 .31342 L 0 .953 .038 r
F
.78849 .29475 m .78232 .31851 L .78957 .30994 L 0 .791 .032 r
F
.76573 .30479 m .78957 .30994 L .78232 .31851 L 0 .953 .038 r
F
.19894 .29787 m .19704 .33131 L .22259 .33637 L 0 .173 .974 r
F
.19894 .29787 m .19282 .33979 L .19704 .33131 L 0 .094 .527 r
F
.5347 .28369 m .55317 .29758 L .52874 .29242 L 0 .954 .605 r
F
.5347 .28369 m .55924 .2889 L .55317 .29758 L F
.52874 .29242 m .55346 .31193 L .55317 .29758 L 0 .972 .616 r
F
.55924 .2889 m .55317 .29758 L .55346 .31193 L 0 .721 .457 r
F
.57552 .29235 m .60022 .31105 L .59981 .29751 L 0 .971 .616 r
F
.61865 .29723 m .61922 .31376 L .64339 .31886 L 0 .971 .424 r
F
.62506 .28855 m .61865 .29723 L .61922 .31376 L 0 .744 .324 r
F
.66531 .29716 m .66605 .31396 L .69009 .31906 L 0 .971 .423 r
F
.24607 .32456 m .2669 .33813 L .24158 .33309 L 0 .358 .952 r
F
.24607 .32456 m .2715 .32965 L .2669 .33813 L F
.71491 .29338 m .70883 .31635 L .7157 .30776 L 0 .772 .184 r
F
.3944 .28265 m .41403 .29655 L .38915 .29139 L 0 .925 .954 r
F
.3944 .28265 m .41938 .28786 L .41403 .29655 L F
.38915 .29139 m .41383 .31635 L .41403 .29655 L 0 .943 .973 r
F
.41938 .28786 m .41403 .29655 L .41383 .31635 L 0 .641 .661 r
F
.43596 .29132 m .46069 .31628 L .46069 .29648 L 0 .943 .972 r
F
.62565 .30513 m .64339 .31886 L .61922 .31376 L 0 .953 .415 r
F
.64926 .29373 m .64339 .31886 L .64993 .31028 L 0 .753 .328 r
F
.62565 .30513 m .64993 .31028 L .64339 .31886 L 0 .953 .415 r
F
.47952 .29621 m .47958 .31057 L .50419 .31567 L 0 .972 .809 r
F
.48522 .28751 m .47952 .29621 L .47958 .31057 L 0 .691 .575 r
F
.5262 .29614 m .52641 .31104 L .55088 .31615 L 0 .972 .809 r
F
.48529 .30192 m .50419 .31567 L .47958 .31057 L 0 .953 .793 r
F
.50986 .2927 m .50419 .31567 L .51001 .30708 L 0 .703 .585 r
F
.48529 .30192 m .51001 .30708 L .50419 .31567 L 0 .953 .793 r
F
.57552 .29235 m .5697 .31452 L .57585 .30592 L 0 .728 .461 r
F
.25392 .2816 m .27472 .29553 L .2494 .29036 L 0 .548 .954 r
F
.25392 .2816 m .27936 .28683 L .27472 .29553 L F
.2494 .29036 m .27335 .32955 L .27472 .29553 L 0 .559 .973 r
F
.27936 .28683 m .27472 .29553 L .27335 .32955 L 0 .333 .58 r
F
.3214 .29546 m .31566 .33334 L .32052 .32483 L 0 .35 .61 r
F
.29623 .29029 m .32052 .32483 L .3214 .29546 L 0 .559 .973 r
F
.34022 .29518 m .33962 .31799 L .36472 .32309 L 0 .751 .973 r
F
.3452 .28648 m .34022 .29518 L .33962 .31799 L 0 .479 .621 r
F
.38692 .29511 m .3865 .3212 L .41147 .32629 L 0 .751 .973 r
F
.38692 .29511 m .38131 .32973 L .3865 .3212 L 0 .499 .646 r
F
.72481 .28089 m .74177 .29482 L .71787 .28965 L 0 .954 .038 r
F
.72481 .28089 m .74881 .28611 L .74177 .29482 L F
.71787 .28965 m .74272 .31055 L .74177 .29482 L 0 .97 .039 r
F
.74881 .28611 m .74177 .29482 L .74272 .31055 L 0 .78 .031 r
F
.76473 .28958 m .78957 .30994 L .78849 .29475 L 0 .97 .039 r
F
.11328 .28056 m .13523 .2945 L .10948 .28933 L 0 .17 .954 r
F
.11328 .28056 m .13916 .28579 L .13523 .2945 L F
.10786 .29306 m .1024 .36446 L .12852 .36947 L .019 0 .974 r
F
.1024 .36446 m .12462 .37782 L .09862 .37286 L .019 0 .948 r
F
.1024 .36446 m .12852 .36947 L .12462 .37782 L F
.10948 .28933 m .1267 .41571 L .13523 .2945 L 0 .173 .974 r
F
.13916 .28579 m .13523 .2945 L .1267 .41571 L 0 .084 .474 r
F
.18194 .29443 m .17312 .38002 L .17729 .37165 L 0 .091 .513 r
F
.15633 .28926 m .17729 .37165 L .18194 .29443 L 0 .173 .974 r
F
.20075 .29416 m .19856 .33314 L .22419 .33821 L 0 .366 .974 r
F
.20502 .28544 m .20075 .29416 L .19856 .33314 L 0 .198 .527 r
F
.24747 .29409 m .24607 .32456 L .2715 .32965 L 0 .366 .973 r
F
.24747 .29409 m .24158 .33309 L .24607 .32456 L 0 .211 .561 r
F
.5844 .27984 m .60251 .2938 L .57817 .28862 L 0 .954 .416 r
F
.5844 .27984 m .60885 .28508 L .60251 .2938 L F
.57817 .28862 m .60301 .31008 L .60251 .2938 L 0 .971 .424 r
F
.60885 .28508 m .60251 .2938 L .60301 .31008 L 0 .738 .322 r
F
.62506 .28855 m .64993 .31028 L .64926 .29373 L 0 .971 .423 r
F
.29518 .31971 m .31566 .33334 L .29043 .32829 L 0 .546 .952 r
F
.29518 .31971 m .32052 .32483 L .31566 .33334 L F
.66815 .29345 m .66879 .30783 L .69286 .31295 L 0 .971 .231 r
F
.67482 .28473 m .66815 .29345 L .66879 .30783 L 0 .759 .181 r
F
.71491 .29338 m .7157 .30776 L .73963 .31288 L 0 .971 .231 r
F
.67549 .29915 m .69286 .31295 L .66879 .30783 L 0 .953 .227 r
F
.69893 .28993 m .69286 .31295 L .69966 .30432 L 0 .767 .183 r
F
.67549 .29915 m .69966 .30432 L .69286 .31295 L 0 .953 .227 r
F
.10786 .29306 m .09862 .37286 L .1024 .36446 L .009 0 .449 r
F
.43596 .29132 m .4304 .31975 L .43585 .31116 L 0 .65 .67 r
F
.44381 .2788 m .46308 .29277 L .4383 .28758 L 0 .954 .794 r
F
.44381 .2788 m .46871 .28404 L .46308 .29277 L F
.4383 .28758 m .46309 .30905 L .46308 .29277 L 0 .972 .809 r
F
.46871 .28404 m .46308 .29277 L .46309 .30905 L 0 .683 .568 r
F
.76473 .28958 m .75859 .31342 L .76573 .30479 L 0 .784 .031 r
F
.48522 .28751 m .51001 .30708 L .50986 .2927 L 0 .972 .809 r
F
.57552 .29235 m .57585 .30592 L .60022 .31105 L 0 .971 .616 r
F
.52874 .29242 m .52894 .3068 L .55346 .31193 L 0 .972 .616 r
F
.5347 .28369 m .52874 .29242 L .52894 .3068 L 0 .71 .45 r
F
.53493 .29811 m .55346 .31193 L .52894 .3068 L 0 .953 .604 r
F
.55924 .2889 m .55346 .31193 L .55954 .3033 L 0 .721 .457 r
F
.53493 .29811 m .55954 .3033 L .55346 .31193 L 0 .953 .604 r
F
.34463 .30936 m .36472 .32309 L .33962 .31799 L 0 .735 .952 r
F
.37028 .29167 m .36472 .32309 L .36983 .31451 L 0 .491 .636 r
F
.34463 .30936 m .36983 .31451 L .36472 .32309 L 0 .735 .952 r
F
.30305 .27775 m .32349 .29174 L .29827 .28655 L 0 .737 .954 r
F
.30305 .27775 m .32839 .283 L .32349 .29174 L F
.29827 .28655 m .32284 .31349 L .32349 .29174 L 0 .751 .973 r
F
.32839 .283 m .32349 .29174 L .32284 .31349 L 0 .471 .61 r
F
.3452 .28648 m .36983 .31451 L .37028 .29167 L 0 .751 .973 r
F
.38915 .29139 m .38884 .31123 L .41383 .31635 L 0 .943 .973 r
F
.3944 .28265 m .38915 .29139 L .38884 .31123 L 0 .627 .646 r
F
.43596 .29132 m .43585 .31116 L .46069 .31628 L 0 .943 .972 r
F
.62506 .28855 m .61922 .31376 L .62565 .30513 L 0 .744 .324 r
F
.77503 .27703 m .79161 .29103 L .76781 .28583 L .151 .954 0 r
F
.77503 .27703 m .79893 .28228 L .79161 .29103 L F
.76781 .28583 m .79262 .30515 L .79161 .29103 L .153 .97 0 r
F
.79893 .28228 m .79161 .29103 L .79262 .30515 L .125 .791 0 r
F
.48522 .28751 m .47958 .31057 L .48529 .30192 L 0 .691 .575 r
F
.16212 .2767 m .18373 .29071 L .15806 .28551 L 0 .359 .954 r
F
.16212 .2767 m .18791 .28196 L .18373 .29071 L F
.15806 .28551 m .17946 .36189 L .18373 .29071 L 0 .366 .974 r
F
.18791 .28196 m .18373 .29071 L .17946 .36189 L 0 .193 .513 r
F
.23054 .29064 m .22419 .33821 L .2286 .32967 L 0 .206 .548 r
F
.20502 .28544 m .2286 .32967 L .23054 .29064 L 0 .366 .973 r
F
.2494 .29036 m .24784 .32445 L .27335 .32955 L 0 .559 .973 r
F
.25392 .2816 m .2494 .29036 L .24784 .32445 L 0 .322 .561 r
F
.29623 .29029 m .29518 .31971 L .32052 .32483 L 0 .559 .973 r
F
.29623 .29029 m .29043 .32829 L .29518 .31971 L 0 .34 .592 r
F
.63433 .27598 m .65207 .29 L .62783 .2848 L 0 .954 .227 r
F
.63433 .27598 m .65868 .28124 L .65207 .29 L F
.62783 .2848 m .65269 .30494 L .65207 .29 L 0 .971 .231 r
F
.65868 .28124 m .65207 .29 L .65269 .30494 L 0 .753 .179 r
F
.67482 .28473 m .69966 .30432 L .69893 .28993 L 0 .971 .231 r
F
.71787 .28965 m .71874 .30541 L .74272 .31055 L 0 .97 .039 r
F
.72481 .28089 m .71787 .28965 L .71874 .30541 L 0 .772 .031 r
F
.76473 .28958 m .76573 .30479 L .78957 .30994 L 0 .97 .039 r
F
.10948 .28933 m .10024 .41078 L .1267 .41571 L 0 .173 .974 r
F
.11328 .28056 m .10948 .28933 L .10024 .41078 L 0 .08 .449 r
F
.39411 .30255 m .41383 .31635 L .38884 .31123 L 0 .924 .952 r
F
.41938 .28786 m .41383 .31635 L .4192 .30773 L 0 .641 .661 r
F
.39411 .30255 m .4192 .30773 L .41383 .31635 L 0 .924 .952 r
F
.15633 .28926 m .15123 .36663 L .17729 .37165 L 0 .173 .974 r
F
.15633 .28926 m .14718 .37505 L .15123 .36663 L 0 .087 .49 r
F
.72572 .2967 m .74272 .31055 L .71874 .30541 L 0 .953 .038 r
F
.74881 .28611 m .74272 .31055 L .7498 .30189 L 0 .78 .031 r
F
.72572 .2967 m .7498 .30189 L .74272 .31055 L 0 .953 .038 r
F
.49345 .27493 m .51236 .28897 L .48767 .28376 L 0 .954 .605 r
F
.49345 .27493 m .51825 .2802 L .51236 .28897 L F
.48767 .28376 m .51253 .30418 L .51236 .28897 L 0 .972 .616 r
F
.51825 .2802 m .51236 .28897 L .51253 .30418 L 0 .703 .445 r
F
.5347 .28369 m .55954 .3033 L .55924 .2889 L 0 .971 .616 r
F
.57817 .28862 m .57858 .30493 L .60301 .31008 L 0 .971 .424 r
F
.5844 .27984 m .57817 .28862 L .57858 .30493 L 0 .728 .317 r
F
.62506 .28855 m .62565 .30513 L .64993 .31028 L 0 .971 .423 r
F
.67482 .28473 m .66879 .30783 L .67549 .29915 L 0 .759 .181 r
F
.35241 .27388 m .37248 .28793 L .34735 .28272 L 0 .925 .954 r
F
.35241 .27388 m .37765 .27915 L .37248 .28793 L F
.34735 .28272 m .37204 .31081 L .37248 .28793 L 0 .943 .973 r
F
.37765 .27915 m .37248 .28793 L .37204 .31081 L 0 .617 .636 r
F
.3944 .28265 m .4192 .30773 L .41938 .28786 L 0 .943 .972 r
F
.58484 .29621 m .60301 .31008 L .57858 .30493 L 0 .953 .415 r
F
.60885 .28508 m .60301 .31008 L .60937 .30141 L 0 .738 .322 r
F
.58484 .29621 m .60937 .30141 L .60301 .31008 L 0 .953 .415 r
F
.4383 .28758 m .43822 .3039 L .46309 .30905 L 0 .972 .809 r
F
.44381 .2788 m .4383 .28758 L .43822 .3039 L 0 .67 .557 r
F
.48522 .28751 m .48529 .30192 L .51001 .30708 L 0 .972 .809 r
F
.5347 .28369 m .52894 .3068 L .53493 .29811 L 0 .71 .45 r
F
.21119 .27283 m .23243 .2869 L .20686 .28168 L 0 .548 .954 r
F
.21119 .27283 m .23688 .2781 L .23243 .2869 L F
.20502 .28544 m .20285 .32455 L .2286 .32967 L 0 .366 .973 r
F
.20285 .32455 m .2286 .32967 L .22419 .33821 L 0 .358 .951 r
F
.20686 .28168 m .23014 .33317 L .23243 .2869 L 0 .559 .973 r
F
.23688 .2781 m .23243 .2869 L .23014 .33317 L 0 .315 .548 r
F
.3452 .28648 m .33962 .31799 L .34463 .30936 L 0 .479 .621 r
F
.27936 .28683 m .27335 .32955 L .27802 .32096 L 0 .333 .58 r
F
.25392 .2816 m .27802 .32096 L .27936 .28683 L 0 .559 .973 r
F
.44375 .29517 m .46309 .30905 L .43822 .3039 L 0 .953 .793 r
F
.46871 .28404 m .46309 .30905 L .46873 .30038 L 0 .683 .568 r
F
.44375 .29517 m .46873 .30038 L .46309 .30905 L 0 .953 .793 r
F
.29827 .28655 m .2975 .30834 L .32284 .31349 L 0 .751 .973 r
F
.30305 .27775 m .29827 .28655 L .2975 .30834 L 0 .457 .592 r
F
.3452 .28648 m .34463 .30936 L .36983 .31451 L 0 .751 .973 r
F
.68448 .2721 m .70185 .28618 L .67771 .28096 L 0 .954 .038 r
F
.68448 .2721 m .70873 .27738 L .70185 .28618 L F
.67771 .28096 m .70266 .30169 L .70185 .28618 L 0 .97 .039 r
F
.70873 .27738 m .70185 .28618 L .70266 .30169 L 0 .767 .031 r
F
.72481 .28089 m .7498 .30189 L .74881 .28611 L 0 .97 .039 r
F
.76781 .28583 m .76874 .29998 L .79262 .30515 L .153 .97 0 r
F
.77599 .29122 m .79262 .30515 L .76874 .29998 L .151 .953 0 r
F
.79893 .28228 m .79262 .30515 L .79996 .29644 L .125 .791 0 r
F
.77599 .29122 m .79996 .29644 L .79262 .30515 L .151 .953 0 r
F
.77503 .27703 m .76781 .28583 L .76874 .29998 L .124 .784 0 r
F
.13916 .28579 m .1267 .41571 L .13069 .40741 L 0 .084 .474 r
F
.11328 .28056 m .13069 .40741 L .13916 .28579 L 0 .173 .974 r
F
.15806 .28551 m .15338 .35684 L .17946 .36189 L 0 .366 .974 r
F
.16212 .2767 m .15806 .28551 L .15338 .35684 L 0 .184 .49 r
F
.20502 .28544 m .19856 .33314 L .20285 .32455 L 0 .198 .527 r
F
.54332 .27105 m .56186 .28515 L .53727 .27991 L 0 .954 .416 r
F
.54332 .27105 m .56802 .27634 L .56186 .28515 L F
.53727 .27991 m .56223 .3023 L .56186 .28515 L 0 .971 .424 r
F
.56802 .27634 m .56186 .28515 L .56223 .3023 L 0 .721 .314 r
F
.20285 .32455 m .22419 .33821 L .19856 .33314 L 0 .358 .951 r
F
.5844 .27984 m .60937 .30141 L .60885 .28508 L 0 .971 .423 r
F
.62783 .2848 m .62837 .29977 L .65269 .30494 L 0 .971 .231 r
F
.63433 .27598 m .62783 .2848 L .62837 .29977 L 0 .744 .177 r
F
.67482 .28473 m .67549 .29915 L .69966 .30432 L 0 .971 .231 r
F
.63489 .291 m .65269 .30494 L .62837 .29977 L 0 .953 .227 r
F
.65868 .28124 m .65269 .30494 L .65932 .29623 L 0 .753 .179 r
F
.63489 .291 m .65932 .29623 L .65269 .30494 L 0 .953 .227 r
F
.3944 .28265 m .38884 .31123 L .39411 .30255 L 0 .627 .646 r
F
.40198 .26999 m .4217 .28411 L .39666 .27887 L 0 .954 .794 r
F
.40198 .26999 m .42713 .27529 L .4217 .28411 L F
.39666 .27887 m .4215 .30729 L .4217 .28411 L 0 .972 .809 r
F
.42713 .27529 m .4217 .28411 L .4215 .30729 L 0 .661 .55 r
F
.44381 .2788 m .46873 .30038 L .46871 .28404 L 0 .972 .809 r
F
.72481 .28089 m .71874 .30541 L .72572 .2967 L 0 .772 .031 r
F
.3023 .29961 m .32284 .31349 L .2975 .30834 L 0 .735 .952 r
F
.32839 .283 m .32284 .31349 L .32777 .30482 L 0 .471 .61 r
F
.3023 .29961 m .32777 .30482 L .32284 .31349 L 0 .735 .952 r
F
.48767 .28376 m .48776 .299 L .51253 .30418 L 0 .972 .616 r
F
.49345 .27493 m .48767 .28376 L .48776 .299 L 0 .691 .438 r
F
.5347 .28369 m .53493 .29811 L .55954 .3033 L 0 .971 .616 r
F
.49356 .29023 m .51253 .30418 L .48776 .299 L 0 .953 .604 r
F
.51825 .2802 m .51253 .30418 L .51844 .29546 L 0 .703 .445 r
F
.49356 .29023 m .51844 .29546 L .51253 .30418 L 0 .953 .604 r
F
.25239 .3158 m .27335 .32955 L .24784 .32445 L 0 .546 .951 r
F
.25239 .3158 m .27802 .32096 L .27335 .32955 L F
.26047 .26894 m .28136 .28307 L .25588 .27782 L 0 .737 .954 r
F
.26047 .26894 m .28607 .27424 L .28136 .28307 L F
.25588 .27782 m .28032 .30982 L .28136 .28307 L 0 .751 .973 r
F
.28607 .27424 m .28136 .28307 L .28032 .30982 L 0 .448 .58 r
F
.30305 .27775 m .32777 .30482 L .32839 .283 L 0 .751 .973 r
F
.34735 .28272 m .34679 .30564 L .37204 .31081 L 0 .943 .973 r
F
.35241 .27388 m .34735 .28272 L .34679 .30564 L 0 .602 .621 r
F
.3944 .28265 m .39411 .30255 L .4192 .30773 L 0 .943 .972 r
F
.5844 .27984 m .57858 .30493 L .58484 .29621 L 0 .728 .317 r
F
.73486 .26821 m .75186 .28235 L .72781 .2771 L .151 .954 0 r
F
.73486 .26821 m .75901 .27351 L .75186 .28235 L F
.72781 .2771 m .75284 .29788 L .75186 .28235 L .153 .97 0 r
F
.75901 .27351 m .75186 .28235 L .75284 .29788 L .123 .78 0 r
F
.77503 .27703 m .79996 .29644 L .79893 .28228 L .153 .97 0 r
F
.11879 .26788 m .14086 .28203 L .11493 .27678 L 0 .359 .954 r
F
.11879 .26788 m .14484 .27318 L .14086 .28203 L F
.11493 .27678 m .13363 .38616 L .14086 .28203 L 0 .366 .974 r
F
.14484 .27318 m .14086 .28203 L .13363 .38616 L 0 .178 .474 r
F
.18791 .28196 m .17946 .36189 L .18368 .35338 L 0 .193 .513 r
F
.16212 .2767 m .18368 .35338 L .18791 .28196 L 0 .366 .973 r
F
.20686 .28168 m .2043 .32803 L .23014 .33317 L 0 .559 .973 r
F
.21119 .27283 m .20686 .28168 L .2043 .32803 L 0 .303 .527 r
F
.25392 .2816 m .25239 .3158 L .27802 .32096 L 0 .559 .973 r
F
.25392 .2816 m .24784 .32445 L .25239 .3158 L 0 .322 .561 r
F
.44381 .2788 m .43822 .3039 L .44375 .29517 L 0 .67 .557 r
F
.59341 .26715 m .61158 .28131 L .58709 .27605 L 0 .954 .227 r
F
.59341 .26715 m .61801 .27246 L .61158 .28131 L F
.58709 .27605 m .61208 .29657 L .61158 .28131 L 0 .971 .231 r
F
.61801 .27246 m .61158 .28131 L .61208 .29657 L 0 .738 .176 r
F
.63433 .27598 m .65932 .29623 L .65868 .28124 L 0 .971 .231 r
F
.67771 .28096 m .67843 .2965 L .70266 .30169 L 0 .97 .039 r
F
.68448 .2721 m .67771 .28096 L .67843 .2965 L 0 .759 .03 r
F
.72481 .28089 m .72572 .2967 L .7498 .30189 L 0 .97 .039 r
F
.77503 .27703 m .76874 .29998 L .77599 .29122 L .124 .784 0 r
F
.11328 .28056 m .1041 .40243 L .13069 .40741 L 0 .173 .974 r
F
.11328 .28056 m .10024 .41078 L .1041 .40243 L 0 .08 .449 r
F
.68524 .28769 m .70266 .30169 L .67843 .2965 L 0 .953 .038 r
F
.70873 .27738 m .70266 .30169 L .70956 .29294 L 0 .767 .031 r
F
.68524 .28769 m .70956 .29294 L .70266 .30169 L 0 .953 .038 r
F
.45178 .26609 m .47113 .28027 L .44619 .275 L 0 .954 .605 r
F
.45178 .26609 m .47684 .27141 L .47113 .28027 L F
.44619 .275 m .47117 .29608 L .47113 .28027 L 0 .972 .616 r
F
.47684 .27141 m .47113 .28027 L .47117 .29608 L 0 .683 .433 r
F
.49345 .27493 m .51844 .29546 L .51825 .2802 L 0 .971 .616 r
F
.53727 .27991 m .53755 .2971 L .56223 .3023 L 0 .971 .424 r
F
.54332 .27105 m .53727 .27991 L .53755 .2971 L 0 .71 .31 r
F
.5844 .27984 m .58484 .29621 L .60937 .30141 L 0 .971 .423 r
F
.35186 .29687 m .37204 .31081 L .34679 .30564 L 0 .924 .952 r
F
.37765 .27915 m .37204 .31081 L .37724 .3021 L 0 .617 .636 r
F
.35186 .29687 m .37724 .3021 L .37204 .31081 L 0 .924 .952 r
F
.63433 .27598 m .62837 .29977 L .63489 .291 L 0 .744 .177 r
F
.30998 .26503 m .33051 .27922 L .30512 .27395 L 0 .925 .954 r
F
.30998 .26503 m .33549 .27035 L .33051 .27922 L F
.30512 .27395 m .32986 .30217 L .33051 .27922 L 0 .943 .973 r
F
.33549 .27035 m .33051 .27922 L .32986 .30217 L 0 .591 .61 r
F
.08319 .81745 m .0981 .81622 L .09622 .81925 L .901 0 .178 r
F
.35241 .27388 m .37724 .3021 L .37765 .27915 L 0 .943 .972 r
F
.39666 .27887 m .39634 .30209 L .4215 .30729 L 0 .972 .809 r
F
.40198 .26999 m .39666 .27887 L .39634 .30209 L 0 .646 .538 r
F
.54363 .28829 m .56223 .3023 L .53755 .2971 L 0 .953 .415 r
F
.56802 .27634 m .56223 .3023 L .56842 .29354 L 0 .721 .314 r
F
.54363 .28829 m .56842 .29354 L .56223 .3023 L 0 .953 .415 r
F
.44381 .2788 m .44375 .29517 L .46873 .30038 L 0 .972 .809 r
F
.30305 .27775 m .2975 .30834 L .3023 .29961 L 0 .457 .592 r
F
.78547 .2643 m .80209 .2785 L .77815 .27323 L .34 .954 0 r
F
.78547 .2643 m .80952 .26962 L .80209 .2785 L F
.77815 .27323 m .803 .29077 L .80209 .2785 L .345 .97 0 r
F
.80952 .26962 m .80209 .2785 L .803 .29077 L .282 .791 0 r
F
.16801 .26396 m .18972 .27818 L .16388 .2729 L 0 .548 .954 r
F
.16801 .26396 m .19397 .26929 L .18972 .27818 L F
.16388 .2729 m .18645 .33377 L .18972 .27818 L 0 .559 .973 r
F
.19397 .26929 m .18972 .27818 L .18645 .33377 L 0 .294 .513 r
F
.49345 .27493 m .48776 .299 L .49356 .29023 L 0 .691 .438 r
F
.23688 .2781 m .23014 .33317 L .23463 .32453 L 0 .315 .548 r
F
.21119 .27283 m .23463 .32453 L .23688 .2781 L 0 .559 .973 r
F
.25588 .27782 m .25469 .30463 L .28032 .30982 L 0 .751 .973 r
F
.26047 .26894 m .25588 .27782 L .25469 .30463 L 0 .433 .561 r
F
.30305 .27775 m .3023 .29961 L .32777 .30482 L 0 .751 .973 r
F
.64373 .26323 m .66153 .27746 L .63713 .27218 L 0 .954 .038 r
F
.64373 .26323 m .66823 .26857 L .66153 .27746 L F
.63713 .27218 m .66223 .29356 L .66153 .27746 L 0 .97 .039 r
F
.66823 .26857 m .66153 .27746 L .66223 .29356 L 0 .753 .03 r
F
.68448 .2721 m .70956 .29294 L .70873 .27738 L 0 .97 .039 r
F
.72781 .2771 m .72871 .29266 L .75284 .29788 L .153 .97 0 r
F
.73486 .26821 m .72781 .2771 L .72871 .29266 L .122 .772 0 r
F
.77503 .27703 m .77599 .29122 L .79996 .29644 L .153 .97 0 r
F
.11493 .27678 m .10709 .38111 L .13363 .38616 L 0 .366 .974 r
F
.11879 .26788 m .11493 .27678 L .10709 .38111 L 0 .169 .449 r
F
.16212 .2767 m .15748 .34827 L .18368 .35338 L 0 .366 .973 r
F
.16212 .2767 m .15338 .35684 L .15748 .34827 L 0 .184 .49 r
F
.73579 .28382 m .75284 .29788 L .72871 .29266 L .151 .953 0 r
F
.75901 .27351 m .75284 .29788 L .76002 .28909 L .123 .78 0 r
F
.73579 .28382 m .76002 .28909 L .75284 .29788 L .151 .953 0 r
F
.07011 .81564 m .07192 .8126 L .08319 .81745 L .901 0 .178 r
F
.08319 .81745 m .07192 .8126 L .0981 .81622 L F
.50181 .26217 m .52079 .27641 L .49595 .27112 L 0 .954 .416 r
F
.50181 .26217 m .52677 .26751 L .52079 .27641 L F
.49595 .27112 m .52099 .29197 L .52079 .27641 L 0 .971 .424 r
F
.52677 .26751 m .52079 .27641 L .52099 .29197 L 0 .703 .306 r
F
.54332 .27105 m .56842 .29354 L .56802 .27634 L 0 .971 .423 r
F
.58709 .27605 m .58751 .29135 L .61208 .29657 L 0 .971 .231 r
F
.59341 .26715 m .58709 .27605 L .58751 .29135 L 0 .728 .173 r
F
.63433 .27598 m .63489 .291 L .65932 .29623 L 0 .971 .231 r
F
.09314 .42664 m .1155 .43953 L .08939 .43474 L .206 0 .943 r
F
.09314 .42664 m .11937 .43147 L .1155 .43953 L F
.59385 .28249 m .61208 .29657 L .58751 .29135 L 0 .953 .227 r
F
.61801 .27246 m .61208 .29657 L .61853 .28777 L 0 .738 .176 r
F
.59385 .28249 m .61853 .28777 L .61208 .29657 L 0 .953 .227 r
F
.40168 .2933 m .4215 .30729 L .39634 .30209 L 0 .952 .792 r
F
.42713 .27529 m .4215 .30729 L .42696 .29854 L 0 .661 .55 r
F
.40168 .2933 m .42696 .29854 L .4215 .30729 L 0 .952 .792 r
F
.35972 .2611 m .37988 .27536 L .35459 .27007 L 0 .954 .794 r
F
.35972 .2611 m .38513 .26645 L .37988 .27536 L F
.35459 .27007 m .37944 .30054 L .37988 .27536 L 0 .972 .809 r
F
.38513 .26645 m .37988 .27536 L .37944 .30054 L 0 .636 .529 r
F
.40198 .26999 m .42696 .29854 L .42713 .27529 L 0 .972 .809 r
F
.68448 .2721 m .67843 .2965 L .68524 .28769 L 0 .759 .03 r
F
.15123 .36663 m .17312 .38002 L .14718 .37505 L 0 .169 .947 r
F
.15123 .36663 m .17729 .37165 L .17312 .38002 L F
.44619 .275 m .44614 .29085 L .47117 .29608 L 0 .972 .616 r
F
.45178 .26609 m .44619 .275 L .44614 .29085 L 0 .67 .425 r
F
.49345 .27493 m .49356 .29023 L .51844 .29546 L 0 .971 .616 r
F
.45175 .28199 m .47117 .29608 L .44614 .29085 L 0 .953 .604 r
F
.47684 .27141 m .47117 .29608 L .47689 .28727 L 0 .683 .433 r
F
.45175 .28199 m .47689 .28727 L .47117 .29608 L 0 .953 .604 r
F
.21745 .26003 m .2388 .27431 L .21306 .26901 L 0 .737 .954 r
F
.21745 .26003 m .24332 .26538 L .2388 .27431 L F
.21306 .26901 m .2372 .3075 L .2388 .27431 L 0 .751 .973 r
F
.24332 .26538 m .2388 .27431 L .2372 .3075 L 0 .423 .548 r
F
.35241 .27388 m .34679 .30564 L .35186 .29687 L 0 .602 .621 r
F
.28607 .27424 m .28032 .30982 L .28505 .30108 L 0 .448 .58 r
F
.26047 .26894 m .28505 .30108 L .28607 .27424 L 0 .751 .973 r
F
.77815 .27323 m .77899 .28552 L .803 .29077 L .345 .97 0 r
F
.78634 .27663 m .803 .29077 L .77899 .28552 L .339 .953 0 r
F
.80952 .26962 m .803 .29077 L .81045 .28193 L .282 .791 0 r
F
.78634 .27663 m .81045 .28193 L .803 .29077 L .339 .953 0 r
F
.30512 .27395 m .30434 .29695 L .32986 .30217 L 0 .943 .973 r
F
.30998 .26503 m .30512 .27395 L .30434 .29695 L 0 .575 .592 r
F
.35241 .27388 m .35186 .29687 L .37724 .3021 L 0 .943 .972 r
F
.69428 .25929 m .7117 .27359 L .68741 .26828 L .151 .954 0 r
F
.69428 .25929 m .71868 .26465 L .7117 .27359 L F
.68741 .26828 m .71244 .28725 L .7117 .27359 L .153 .97 0 r
F
.71868 .26465 m .7117 .27359 L .71244 .28725 L .121 .767 0 r
F
.54332 .27105 m .53755 .2971 L .54363 .28829 L 0 .71 .31 r
F
.73486 .26821 m .76002 .28909 L .75901 .27351 L .153 .97 0 r
F
.78547 .2643 m .77815 .27323 L .77899 .28552 L .279 .784 0 r
F
.2593 .29583 m .28032 .30982 L .25469 .30463 L 0 .735 .952 r
F
.2593 .29583 m .28505 .30108 L .28032 .30982 L F
.14484 .27318 m .13363 .38616 L .13767 .37767 L 0 .178 .474 r
F
.11879 .26788 m .13767 .37767 L .14484 .27318 L 0 .366 .973 r
F
.16388 .2729 m .16029 .3286 L .18645 .33377 L 0 .559 .973 r
F
.16801 .26396 m .16388 .2729 L .16029 .3286 L 0 .281 .49 r
F
.21119 .27283 m .20866 .31934 L .23463 .32453 L 0 .559 .973 r
F
.21119 .27283 m .2043 .32803 L .20866 .31934 L 0 .303 .527 r
F
.55207 .25822 m .57068 .27253 L .54593 .26722 L 0 .954 .227 r
F
.55207 .25822 m .57693 .26359 L .57068 .27253 L F
.54593 .26722 m .57107 .28894 L .57068 .27253 L 0 .971 .231 r
F
.57693 .26359 m .57068 .27253 L .57107 .28894 L 0 .721 .172 r
F
.59341 .26715 m .61853 .28777 L .61801 .27246 L 0 .971 .231 r
F
.63713 .27218 m .63775 .28831 L .66223 .29356 L 0 .97 .039 r
F
.64373 .26323 m .63713 .27218 L .63775 .28831 L 0 .744 .03 r
F
.68448 .2721 m .68524 .28769 L .70956 .29294 L 0 .97 .039 r
F
.64437 .27942 m .66223 .29356 L .63775 .28831 L 0 .953 .038 r
F
.66823 .26857 m .66223 .29356 L .66896 .28472 L 0 .753 .03 r
F
.64437 .27942 m .66896 .28472 L .66223 .29356 L 0 .953 .038 r
F
.40968 .25715 m .42948 .27148 L .40428 .26616 L 0 .954 .605 r
F
.40968 .25715 m .435 .26252 L .42948 .27148 L F
.40428 .26616 m .42936 .28844 L .42948 .27148 L 0 .972 .616 r
F
.435 .26252 m .42948 .27148 L .42936 .28844 L 0 .661 .419 r
F
.45178 .26609 m .47689 .28727 L .47684 .27141 L 0 .971 .616 r
F
.73486 .26821 m .72871 .29266 L .73579 .28382 L .122 .772 0 r
F
.49595 .27112 m .49607 .28672 L .52099 .29197 L 0 .971 .424 r
F
.50181 .26217 m .49595 .27112 L .49607 .28672 L 0 .691 .301 r
F
.54332 .27105 m .54363 .28829 L .56842 .29354 L 0 .971 .423 r
F
.30922 .28809 m .32986 .30217 L .30434 .29695 L 0 .924 .952 r
F
.33549 .27035 m .32986 .30217 L .33486 .29337 L 0 .591 .61 r
F
.30922 .28809 m .33486 .29337 L .32986 .30217 L 0 .924 .952 r
F
.50195 .27781 m .52099 .29197 L .49607 .28672 L 0 .953 .415 r
F
.52677 .26751 m .52099 .29197 L .52699 .28312 L 0 .703 .306 r
F
.50195 .27781 m .52699 .28312 L .52099 .29197 L 0 .953 .415 r
F
.26712 .25608 m .28811 .27042 L .26246 .2651 L 0 .925 .954 r
F
.26712 .25608 m .29289 .26146 L .28811 .27042 L F
.26246 .2651 m .28698 .30034 L .28811 .27042 L 0 .943 .973 r
F
.29289 .26146 m .28811 .27042 L .28698 .30034 L 0 .563 .58 r
F
.59341 .26715 m .58751 .29135 L .59385 .28249 L 0 .728 .173 r
F
.30998 .26503 m .33486 .29337 L .33549 .27035 L 0 .943 .972 r
F
.40198 .26999 m .39634 .30209 L .40168 .2933 L 0 .646 .538 r
F
.35459 .27007 m .354 .2953 L .37944 .30054 L 0 .972 .809 r
F
.35972 .2611 m .35459 .27007 L .354 .2953 L 0 .621 .516 r
F
.40198 .26999 m .40168 .2933 L .42696 .29854 L 0 .972 .809 r
F
.20866 .31934 m .23014 .33317 L .2043 .32803 L 0 .545 .95 r
F
.20866 .31934 m .23463 .32453 L .23014 .33317 L F
.74506 .25534 m .7621 .2697 L .73791 .26437 L .34 .954 0 r
F
.74506 .25534 m .76936 .26072 L .7621 .2697 L F
.73791 .26437 m .76287 .28146 L .7621 .2697 L .345 .97 0 r
F
.76936 .26072 m .7621 .2697 L .76287 .28146 L .278 .78 0 r
F
.78547 .2643 m .81045 .28193 L .80952 .26962 L .345 .969 0 r
F
.12438 .255 m .14656 .26937 L .12046 .26404 L 0 .548 .954 r
F
.12438 .255 m .15061 .26039 L .14656 .26937 L F
.12046 .26404 m .14279 .32458 L .14656 .26937 L 0 .559 .973 r
F
.15061 .26039 m .14656 .26937 L .14279 .32458 L 0 .272 .474 r
F
.19397 .26929 m .18645 .33377 L .19073 .32507 L 0 .294 .513 r
F
.16801 .26396 m .19073 .32507 L .19397 .26929 L 0 .559 .973 r
F
.45178 .26609 m .44614 .29085 L .45175 .28199 L 0 .67 .425 r
F
.21306 .26901 m .21126 .30226 L .2372 .3075 L 0 .751 .973 r
F
.21745 .26003 m .21306 .26901 L .21126 .30226 L 0 .407 .527 r
F
.26047 .26894 m .2593 .29583 L .28505 .30108 L 0 .751 .973 r
F
.26047 .26894 m .25469 .30463 L .2593 .29583 L 0 .433 .561 r
F
.78547 .2643 m .77899 .28552 L .78634 .27663 L .279 .784 0 r
F
.60256 .25426 m .62079 .26864 L .59614 .2633 L 0 .954 .038 r
F
.60256 .25426 m .62731 .25966 L .62079 .26864 L F
.59614 .2633 m .62137 .28535 L .62079 .26864 L 0 .97 .039 r
F
.62731 .25966 m .62079 .26864 L .62137 .28535 L 0 .738 .03 r
F
.64373 .26323 m .66896 .28472 L .66823 .26857 L 0 .97 .039 r
F
.68741 .26828 m .68808 .28197 L .71244 .28725 L .153 .97 0 r
F
.69498 .27303 m .71244 .28725 L .68808 .28197 L .151 .953 0 r
F
.71868 .26465 m .71244 .28725 L .71945 .27836 L .121 .767 0 r
F
.69498 .27303 m .71945 .27836 L .71244 .28725 L .151 .953 0 r
F
.69428 .25929 m .68741 .26828 L .68808 .28197 L .12 .759 0 r
F
.73486 .26821 m .73579 .28382 L .76002 .28909 L .153 .97 0 r
F
.11879 .26788 m .111 .37257 L .13767 .37767 L 0 .366 .973 r
F
.11879 .26788 m .10709 .38111 L .111 .37257 L 0 .169 .449 r
F
.45988 .25319 m .4793 .26758 L .4542 .26224 L 0 .954 .416 r
F
.45988 .25319 m .48509 .25859 L .4793 .26758 L F
.4542 .26224 m .47937 .28429 L .4793 .26758 L 0 .971 .424 r
F
.48509 .25859 m .4793 .26758 L .47937 .28429 L 0 .683 .298 r
F
.50181 .26217 m .52699 .28312 L .52677 .26751 L 0 .971 .423 r
F
.54593 .26722 m .54623 .28366 L .57107 .28894 L 0 .971 .231 r
F
.55207 .25822 m .54593 .26722 L .54623 .28366 L 0 .71 .169 r
F
.59341 .26715 m .59385 .28249 L .61853 .28777 L 0 .971 .231 r
F
.31702 .25211 m .33764 .26652 L .31208 .26117 L 0 .954 .794 r
F
.31702 .25211 m .34269 .25751 L .33764 .26652 L F
.31208 .26117 m .3371 .28654 L .33764 .26652 L 0 .972 .809 r
F
.34269 .25751 m .33764 .26652 L .3371 .28654 L 0 .61 .507 r
F
.38513 .26645 m .37944 .30054 L .38471 .29171 L 0 .636 .529 r
F
.35972 .2611 m .38471 .29171 L .38513 .26645 L 0 .972 .809 r
F
.5524 .27472 m .57107 .28894 L .54623 .28366 L 0 .953 .227 r
F
.57693 .26359 m .57107 .28894 L .57734 .28005 L 0 .721 .172 r
F
.5524 .27472 m .57734 .28005 L .57107 .28894 L 0 .953 .227 r
F
.64373 .26323 m .63775 .28831 L .64437 .27942 L 0 .744 .03 r
F
.40428 .26616 m .40407 .28316 L .42936 .28844 L 0 .972 .616 r
F
.40968 .25715 m .40428 .26616 L .40407 .28316 L 0 .646 .41 r
F
.45178 .26609 m .45175 .28199 L .47689 .28727 L 0 .971 .616 r
F
.35916 .28641 m .37944 .30054 L .354 .2953 L 0 .952 .792 r
F
.35916 .28641 m .38471 .29171 L .37944 .30054 L F
.79608 .25137 m .81273 .26579 L .78864 .26044 L .529 .954 0 r
F
.79608 .25137 m .82027 .25678 L .81273 .26579 L F
.78864 .26044 m .81384 .28031 L .81273 .26579 L .537 .969 0 r
F
.82027 .25678 m .81273 .26579 L .81384 .28031 L .438 .791 0 r
F
.17398 .25103 m .1958 .26546 L .16979 .2601 L 0 .737 .954 r
F
.17398 .25103 m .20012 .25644 L .1958 .26546 L F
.16979 .2601 m .19244 .32384 L .1958 .26546 L 0 .751 .973 r
F
.20012 .25644 m .1958 .26546 L .19244 .32384 L 0 .396 .513 r
F
.30998 .26503 m .30434 .29695 L .30922 .28809 L 0 .575 .592 r
F
.24332 .26538 m .2372 .3075 L .24174 .29868 L 0 .423 .548 r
F
.21745 .26003 m .24174 .29868 L .24332 .26538 L 0 .751 .973 r
F
.50181 .26217 m .49607 .28672 L .50195 .27781 L 0 .691 .301 r
F
.73791 .26437 m .73862 .27615 L .76287 .28146 L .345 .97 0 r
F
.74579 .26716 m .76287 .28146 L .73862 .27615 L .339 .953 0 r
F
.76936 .26072 m .76287 .28146 L .77015 .27252 L .278 .78 0 r
F
.74579 .26716 m .77015 .27252 L .76287 .28146 L .339 .953 0 r
F
.40949 .27421 m .42936 .28844 L .40407 .28316 L 0 .953 .604 r
F
.435 .26252 m .42936 .28844 L .4349 .27954 L 0 .661 .419 r
F
.40949 .27421 m .4349 .27954 L .42936 .28844 L 0 .953 .604 r
F
.26246 .2651 m .26116 .29508 L .28698 .30034 L 0 .943 .973 r
F
.26712 .25608 m .26246 .2651 L .26116 .29508 L 0 .544 .561 r
F
.78547 .2643 m .78634 .27663 L .81045 .28193 L .345 .969 0 r
F
.30998 .26503 m .30922 .28809 L .33486 .29337 L 0 .943 .972 r
F
.65328 .25029 m .67113 .26473 L .64658 .25937 L .151 .954 0 r
F
.65328 .25029 m .67793 .2557 L .67113 .26473 L F
.64658 .25937 m .67179 .27926 L .67113 .26473 L .153 .97 0 r
F
.67793 .2557 m .67113 .26473 L .67179 .27926 L .119 .753 0 r
F
.69428 .25929 m .71945 .27836 L .71868 .26465 L .153 .97 0 r
F
.15748 .34827 m .17946 .36189 L .15338 .35684 L 0 .356 .948 r
F
.15748 .34827 m .18368 .35338 L .17946 .36189 L F
.74506 .25534 m .73791 .26437 L .73862 .27615 L .275 .772 0 r
F
.12046 .26404 m .11636 .31936 L .14279 .32458 L 0 .559 .973 r
F
.12438 .255 m .12046 .26404 L .11636 .31936 L 0 .258 .449 r
F
.16801 .26396 m .16444 .31985 L .19073 .32507 L 0 .559 .973 r
F
.16801 .26396 m .16029 .3286 L .16444 .31985 L 0 .281 .49 r
F
.5103 .24921 m .52935 .26366 L .50435 .2583 L 0 .954 .227 r
F
.5103 .24921 m .53541 .25463 L .52935 .26366 L F
.50435 .2583 m .5296 .28095 L .52935 .26366 L 0 .971 .231 r
F
.53541 .25463 m .52935 .26366 L .5296 .28095 L 0 .703 .167 r
F
.55207 .25822 m .57734 .28005 L .57693 .26359 L 0 .971 .231 r
F
.59614 .2633 m .59663 .28004 L .62137 .28535 L 0 .97 .039 r
F
.60256 .25426 m .59614 .2633 L .59663 .28004 L 0 .728 .029 r
F
.64373 .26323 m .64437 .27942 L .66896 .28472 L 0 .97 .039 r
F
.69428 .25929 m .68808 .28197 L .69498 .27303 L .12 .759 0 r
F
.36714 .24812 m .38739 .2626 L .36193 .25723 L 0 .954 .605 r
F
.36714 .24812 m .39272 .25355 L .38739 .2626 L F
.36193 .25723 m .38709 .28155 L .38739 .2626 L 0 .972 .616 r
F
.39272 .25355 m .38739 .2626 L .38709 .28155 L 0 .636 .403 r
F
.40968 .25715 m .4349 .27954 L .435 .26252 L 0 .971 .616 r
F
.60307 .27106 m .62137 .28535 L .59663 .28004 L 0 .953 .038 r
F
.62731 .25966 m .62137 .28535 L .62792 .27642 L 0 .738 .03 r
F
.60307 .27106 m .62792 .27642 L .62137 .28535 L 0 .953 .038 r
F
.4542 .26224 m .45417 .27898 L .47937 .28429 L 0 .971 .424 r
F
.45988 .25319 m .4542 .26224 L .45417 .27898 L 0 .67 .292 r
F
.50181 .26217 m .50195 .27781 L .52699 .28312 L 0 .971 .423 r
F
.21568 .29339 m .2372 .3075 L .21126 .30226 L 0 .734 .951 r
F
.21568 .29339 m .24174 .29868 L .2372 .3075 L F
.22381 .24704 m .24527 .26153 L .21935 .25615 L 0 .925 .954 r
F
.22381 .24704 m .24985 .25247 L .24527 .26153 L F
.21935 .25615 m .24358 .29738 L .24527 .26153 L 0 .943 .973 r
F
.24985 .25247 m .24527 .26153 L .24358 .29738 L 0 .532 .548 r
F
.29289 .26146 m .28698 .30034 L .29179 .29148 L 0 .563 .58 r
F
.26712 .25608 m .29179 .29148 L .29289 .26146 L 0 .943 .972 r
F
.45987 .26999 m .47937 .28429 L .45417 .27898 L 0 .953 .415 r
F
.48509 .25859 m .47937 .28429 L .48518 .27535 L 0 .683 .298 r
F
.45987 .26999 m .48518 .27535 L .47937 .28429 L 0 .953 .415 r
F
.31208 .26117 m .31143 .28123 L .3371 .28654 L 0 .972 .809 r
F
.31702 .25211 m .31208 .26117 L .31143 .28123 L 0 .592 .493 r
F
.35972 .2611 m .35916 .28641 L .38471 .29171 L 0 .972 .809 r
F
.35972 .2611 m .354 .2953 L .35916 .28641 L 0 .621 .516 r
F
.55207 .25822 m .54623 .28366 L .5524 .27472 L 0 .71 .169 r
F
.70423 .24629 m .72169 .2608 L .69725 .25541 L .34 .954 0 r
F
.70423 .24629 m .72878 .25173 L .72169 .2608 L F
.69725 .25541 m .72241 .27342 L .72169 .2608 L .345 .97 0 r
F
.72878 .25173 m .72169 .2608 L .72241 .27342 L .273 .767 0 r
F
.74506 .25534 m .77015 .27252 L .76936 .26072 L .345 .969 0 r
F
.78864 .26044 m .78967 .27499 L .81384 .28031 L .537 .969 0 r
F
.79608 .25137 m .78864 .26044 L .78967 .27499 L .435 .784 0 r
F
.15061 .26039 m .14279 .32458 L .14687 .31579 L 0 .272 .474 r
F
.12438 .255 m .14687 .31579 L .15061 .26039 L 0 .559 .973 r
F
.79714 .26597 m .81384 .28031 L .78967 .27499 L .528 .953 0 r
F
.82027 .25678 m .81384 .28031 L .82141 .27135 L .438 .791 0 r
F
.79714 .26597 m .82141 .27135 L .81384 .28031 L .528 .953 0 r
F
.16979 .2601 m .16608 .3186 L .19244 .32384 L 0 .751 .973 r
F
.17398 .25103 m .16979 .2601 L .16608 .3186 L 0 .378 .49 r
F
.21745 .26003 m .21568 .29339 L .24174 .29868 L 0 .751 .973 r
F
.21745 .26003 m .21126 .30226 L .21568 .29339 L 0 .407 .527 r
F
.74506 .25534 m .73862 .27615 L .74579 .26716 L .275 .772 0 r
F
.40968 .25715 m .40407 .28316 L .40949 .27421 L 0 .646 .41 r
F
.56095 .24521 m .57962 .25973 L .55472 .25434 L 0 .954 .038 r
F
.56095 .24521 m .58597 .25065 L .57962 .25973 L F
.55472 .25434 m .58006 .27677 L .57962 .25973 L 0 .97 .039 r
F
.58597 .25065 m .57962 .25973 L .58006 .27677 L 0 .721 .029 r
F
.60256 .25426 m .62792 .27642 L .62731 .25966 L 0 .97 .039 r
F
.69428 .25929 m .69498 .27303 L .71945 .27836 L .153 .97 0 r
F
.64658 .25937 m .64717 .27393 L .67179 .27926 L F
.65328 .25029 m .64658 .25937 L .64717 .27393 L .118 .744 0 r
F
.65389 .26489 m .67179 .27926 L .64717 .27393 L .151 .953 0 r
F
.67793 .2557 m .67179 .27926 L .67862 .27028 L .119 .753 0 r
F
.65389 .26489 m .67862 .27028 L .67179 .27926 L .151 .953 0 r
F
.26585 .28616 m .28698 .30034 L .26116 .29508 L 0 .923 .952 r
F
.26585 .28616 m .29179 .29148 L .28698 .30034 L F
.31638 .27224 m .3371 .28654 L .31143 .28123 L 0 .952 .792 r
F
.34269 .25751 m .3371 .28654 L .34217 .2776 L 0 .61 .507 r
F
.31638 .27224 m .34217 .2776 L .3371 .28654 L 0 .952 .792 r
F
.4175 .24412 m .43738 .25866 L .41202 .25326 L 0 .954 .416 r
F
.4175 .24412 m .44298 .24957 L .43738 .25866 L F
.41202 .25326 m .43729 .27653 L .43738 .25866 L 0 .971 .424 r
F
.44298 .24957 m .43738 .25866 L .43729 .27653 L 0 .661 .288 r
F
.45988 .25319 m .48518 .27535 L .48509 .25859 L 0 .971 .423 r
F
.50435 .2583 m .50451 .27562 L .5296 .28095 L 0 .971 .231 r
F
.5103 .24921 m .50435 .2583 L .50451 .27562 L 0 .691 .164 r
F
.55207 .25822 m .5524 .27472 L .57734 .28005 L 0 .971 .231 r
F
.27386 .24303 m .29496 .25759 L .26913 .25218 L 0 .954 .794 r
F
.27386 .24303 m .29981 .24849 L .29496 .25759 L F
.26913 .25218 m .29406 .28238 L .29496 .25759 L 0 .972 .809 r
F
.29981 .24849 m .29496 .25759 L .29406 .28238 L 0 .58 .483 r
F
.16444 .31985 m .18645 .33377 L .16029 .3286 L 0 .545 .949 r
F
.16444 .31985 m .19073 .32507 L .18645 .33377 L F
.31702 .25211 m .34217 .2776 L .34269 .25751 L 0 .972 .809 r
F
.36193 .25723 m .36152 .27621 L .38709 .28155 L 0 .972 .616 r
F
.36714 .24812 m .36193 .25723 L .36152 .27621 L 0 .621 .393 r
F
.51048 .26658 m .5296 .28095 L .50451 .27562 L 0 .953 .227 r
F
.53541 .25463 m .5296 .28095 L .53569 .27197 L 0 .703 .167 r
F
.51048 .26658 m .53569 .27197 L .5296 .28095 L 0 .953 .227 r
F
.40968 .25715 m .40949 .27421 L .4349 .27954 L 0 .971 .616 r
F
.60256 .25426 m .59663 .28004 L .60307 .27106 L 0 .728 .029 r
F
.75542 .24228 m .77249 .25685 L .74815 .25144 L .529 .954 0 r
F
.75542 .24228 m .77986 .24774 L .77249 .25685 L F
.74815 .25144 m .77328 .26839 L .77249 .25685 L .537 .969 0 r
F
.77986 .24774 m .77249 .25685 L .77328 .26839 L .432 .78 0 r
F
.79608 .25137 m .82141 .27135 L .82027 .25678 L .537 .969 0 r
F
.13005 .24194 m .15236 .25652 L .12607 .2511 L 0 .737 .954 r
F
.13005 .24194 m .15646 .2474 L .15236 .25652 L F
.12438 .255 m .1203 .31052 L .14687 .31579 L 0 .559 .973 r
F
.1203 .31052 m .14279 .32458 L .11636 .31936 L 0 .545 .949 r
F
.1203 .31052 m .14687 .31579 L .14279 .32458 L F
.12607 .2511 m .1465 .34366 L .15236 .25652 L 0 .751 .973 r
F
.15646 .2474 m .15236 .25652 L .1465 .34366 L 0 .366 .474 r
F
.20012 .25644 m .19244 .32384 L .19678 .31501 L 0 .396 .513 r
F
.17398 .25103 m .19678 .31501 L .20012 .25644 L 0 .751 .973 r
F
.74506 .25534 m .74579 .26716 L .77015 .27252 L .345 .969 0 r
F
.21935 .25615 m .21745 .29207 L .24358 .29738 L 0 .943 .973 r
F
.22381 .24704 m .21935 .25615 L .21745 .29207 L 0 .511 .527 r
F
.26712 .25608 m .26585 .28616 L .29179 .29148 L 0 .943 .972 r
F
.26712 .25608 m .26116 .29508 L .26585 .28616 L 0 .544 .561 r
F
.69725 .25541 m .6979 .26806 L .72241 .27342 L .345 .97 0 r
F
.7049 .25898 m .72241 .27342 L .6979 .26806 L .339 .953 0 r
F
.72878 .25173 m .72241 .27342 L .72952 .2644 L .273 .767 0 r
F
.7049 .25898 m .72952 .2644 L .72241 .27342 L .339 .953 0 r
F
.45988 .25319 m .45417 .27898 L .45987 .26999 L 0 .67 .292 r
F
.61184 .24119 m .63013 .25578 L .60533 .25036 L .151 .954 0 r
F
.61184 .24119 m .63675 .24666 L .63013 .25578 L F
.60533 .25036 m .63072 .27173 L .63013 .25578 L .153 .97 0 r
F
.63675 .24666 m .63013 .25578 L .63072 .27173 L .117 .738 0 r
F
.65328 .25029 m .67862 .27028 L .67793 .2557 L .153 .97 0 r
F
.36675 .26717 m .38709 .28155 L .36152 .27621 L 0 .953 .604 r
F
.39272 .25355 m .38709 .28155 L .39244 .27256 L 0 .636 .403 r
F
.36675 .26717 m .39244 .27256 L .38709 .28155 L 0 .953 .604 r
F
.70423 .24629 m .69725 .25541 L .6979 .26806 L .27 .759 0 r
F
.12438 .255 m .11636 .31936 L .1203 .31052 L 0 .258 .449 r
F
.79608 .25137 m .78967 .27499 L .79714 .26597 L .435 .784 0 r
F
.46809 .24009 m .48759 .2547 L .46233 .24928 L 0 .954 .227 r
F
.46809 .24009 m .49347 .24557 L .48759 .2547 L F
.46233 .24928 m .4877 .27343 L .48759 .2547 L 0 .971 .231 r
F
.49347 .24557 m .48759 .2547 L .4877 .27343 L 0 .683 .162 r
F
.5103 .24921 m .53569 .27197 L .53541 .25463 L 0 .971 .231 r
F
.55472 .25434 m .55507 .27141 L .58006 .27677 L 0 .97 .039 r
F
.56095 .24521 m .55472 .25434 L .55507 .27141 L 0 .71 .028 r
F
.60256 .25426 m .60307 .27106 L .62792 .27642 L 0 .97 .039 r
F
.65328 .25029 m .64717 .27393 L .65389 .26489 L .118 .744 0 r
F
.31702 .25211 m .31143 .28123 L .31638 .27224 L 0 .592 .493 r
F
.32415 .239 m .34487 .25363 L .31915 .2482 L 0 .954 .605 r
F
.32415 .239 m .35 .24448 L .34487 .25363 L F
.31915 .2482 m .34438 .27291 L .34487 .25363 L 0 .972 .616 r
F
.35 .24448 m .34487 .25363 L .34438 .27291 L 0 .61 .386 r
F
.36714 .24812 m .39244 .27256 L .39272 .25355 L 0 .971 .616 r
F
.56133 .26233 m .58006 .27677 L .55507 .27141 L 0 .953 .038 r
F
.58597 .25065 m .58006 .27677 L .58643 .26775 L 0 .721 .029 r
F
.56133 .26233 m .58643 .26775 L .58006 .27677 L 0 .953 .038 r
F
.41202 .25326 m .41182 .27117 L .43729 .27653 L 0 .971 .424 r
F
.4175 .24412 m .41202 .25326 L .41182 .27117 L 0 .646 .282 r
F
.45988 .25319 m .45987 .26999 L .48518 .27535 L 0 .971 .423 r
F
.80684 .23825 m .82353 .25289 L .79929 .24745 L .717 .954 0 r
F
.80684 .23825 m .83118 .24374 L .82353 .25289 L F
.79929 .24745 m .82459 .26637 L .82353 .25289 L .728 .968 0 r
F
.83118 .24374 m .82353 .25289 L .82459 .26637 L .595 .791 0 r
F
.18004 .2379 m .20198 .25255 L .17579 .24711 L 0 .925 .954 r
F
.18004 .2379 m .20635 .2434 L .20198 .25255 L F
.17579 .24711 m .19936 .29885 L .20198 .25255 L 0 .943 .973 r
F
.20635 .2434 m .20198 .25255 L .19936 .29885 L 0 .497 .513 r
F
.74815 .25144 m .74888 .263 L .77328 .26839 L .537 .969 0 r
F
.75616 .25388 m .77328 .26839 L .74888 .263 L .528 .953 0 r
F
.77986 .24774 m .77328 .26839 L .78067 .25932 L .432 .78 0 r
F
.75616 .25388 m .78067 .25932 L .77328 .26839 L .528 .953 0 r
F
.24985 .25247 m .24358 .29738 L .24819 .28844 L 0 .532 .548 r
F
.22381 .24704 m .24819 .28844 L .24985 .25247 L 0 .943 .972 r
F
.26913 .25218 m .26809 .27702 L .29406 .28238 L 0 .972 .809 r
F
.27386 .24303 m .26913 .25218 L .26809 .27702 L 0 .561 .467 r
F
.31702 .25211 m .31638 .27224 L .34217 .2776 L 0 .972 .809 r
F
.41733 .26208 m .43729 .27653 L .41182 .27117 L 0 .953 .415 r
F
.44298 .24957 m .43729 .27653 L .44291 .2675 L 0 .661 .288 r
F
.41733 .26208 m .44291 .2675 L .43729 .27653 L 0 .953 .415 r
F
.66297 .23715 m .68087 .25181 L .65617 .24637 L .34 .954 0 r
F
.66297 .23715 m .68778 .24265 L .68087 .25181 L F
.65617 .24637 m .68149 .26475 L .68087 .25181 L .345 .97 0 r
F
.68778 .24265 m .68087 .25181 L .68149 .26475 L .268 .753 0 r
F
.5103 .24921 m .50451 .27562 L .51048 .26658 L 0 .691 .164 r
F
.70423 .24629 m .72952 .2644 L .72878 .25173 L .345 .969 0 r
F
.75542 .24228 m .74815 .25144 L .74888 .263 L .428 .772 0 r
F
.79608 .25137 m .79714 .26597 L .82141 .27135 L .537 .969 0 r
F
.12607 .2511 m .11969 .33842 L .1465 .34366 L 0 .751 .973 r
F
.13005 .24194 m .12607 .2511 L .11969 .33842 L 0 .347 .449 r
F
.17398 .25103 m .1703 .30972 L .19678 .31501 L 0 .751 .973 r
F
.17398 .25103 m .16608 .3186 L .1703 .30972 L 0 .378 .49 r
F
.51891 .23605 m .53803 .25073 L .51287 .24528 L 0 .954 .038 r
F
.51891 .23605 m .54419 .24156 L .53803 .25073 L F
.51287 .24528 m .53832 .26782 L .53803 .25073 L 0 .97 .039 r
F
.54419 .24156 m .53803 .25073 L .53832 .26782 L 0 .703 .028 r
F
.56095 .24521 m .58643 .26775 L .58597 .25065 L 0 .97 .039 r
F
.70423 .24629 m .6979 .26806 L .7049 .25898 L .27 .759 0 r
F
.60533 .25036 m .60583 .26635 L .63072 .27173 L .153 .97 0 r
F
.61184 .24119 m .60533 .25036 L .60583 .26635 L .115 .728 0 r
F
.65328 .25029 m .65389 .26489 L .67862 .27028 L .153 .97 0 r
F
.1041 .40243 m .1267 .41571 L .10024 .41078 L 0 .168 .943 r
F
.1041 .40243 m .13069 .40741 L .1267 .41571 L F
.36714 .24812 m .36152 .27621 L .36675 .26717 L 0 .621 .393 r
F
.61237 .25723 m .63072 .27173 L .60583 .26635 L .151 .953 0 r
F
.63675 .24666 m .63072 .27173 L .63737 .26267 L .117 .738 0 r
F
.61237 .25723 m .63737 .26267 L .63072 .27173 L .151 .953 0 r
F
.37468 .23495 m .39502 .24965 L .36939 .24419 L 0 .954 .416 r
F
.37468 .23495 m .40042 .24046 L .39502 .24965 L F
.36939 .24419 m .39472 .27062 L .39502 .24965 L 0 .971 .424 r
F
.40042 .24046 m .39502 .24965 L .39472 .27062 L 0 .636 .277 r
F
.4175 .24412 m .44291 .2675 L .44298 .24957 L 0 .971 .423 r
F
.46233 .24928 m .46233 .26804 L .4877 .27343 L 0 .971 .231 r
F
.46809 .24009 m .46233 .24928 L .46233 .26804 L 0 .67 .159 r
F
.5103 .24921 m .51048 .26658 L .53569 .27197 L 0 .971 .231 r
F
.23026 .23385 m .25183 .24856 L .22573 .2431 L 0 .954 .794 r
F
.23026 .23385 m .25648 .23937 L .25183 .24856 L F
.22573 .2431 m .25037 .28039 L .25183 .24856 L 0 .972 .809 r
F
.25648 .23937 m .25183 .24856 L .25037 .28039 L 0 .548 .456 r
F
.29981 .24849 m .29406 .28238 L .29893 .27336 L 0 .58 .483 r
F
.27386 .24303 m .29893 .27336 L .29981 .24849 L 0 .972 .809 r
F
.27285 .26795 m .29406 .28238 L .26809 .27702 L 0 .952 .792 r
F
.27285 .26795 m .29893 .27336 L .29406 .28238 L F
.31915 .2482 m .31855 .26752 L .34438 .27291 L 0 .972 .616 r
F
.32415 .239 m .31915 .2482 L .31855 .26752 L 0 .592 .376 r
F
.36714 .24812 m .36675 .26717 L .39244 .27256 L 0 .971 .616 r
F
.22194 .28307 m .24358 .29738 L .21745 .29207 L 0 .923 .951 r
F
.22194 .28307 m .24819 .28844 L .24358 .29738 L F
.56095 .24521 m .55507 .27141 L .56133 .26233 L 0 .71 .028 r
F
.71433 .23309 m .73184 .24782 L .70724 .24235 L .529 .954 0 r
F
.71433 .23309 m .73903 .23862 L .73184 .24782 L F
.70724 .24235 m .7326 .26078 L .73184 .24782 L .537 .969 0 r
F
.73903 .23862 m .73184 .24782 L .7326 .26078 L .425 .767 0 r
F
.79929 .24745 m .80029 .26097 L .82459 .26637 L .728 .968 0 r
F
.80786 .2518 m .82459 .26637 L .80029 .26097 L .717 .953 0 r
F
.83118 .24374 m .82459 .26637 L .83228 .25727 L .595 .791 0 r
F
.80786 .2518 m .83228 .25727 L .82459 .26637 L .717 .953 0 r
F
.75542 .24228 m .78067 .25932 L .77986 .24774 L .537 .969 0 r
F
.46812 .25892 m .4877 .27343 L .46233 .26804 L 0 .953 .227 r
F
.49347 .24557 m .4877 .27343 L .4936 .26436 L 0 .683 .162 r
F
.46812 .25892 m .4936 .26436 L .4877 .27343 L 0 .953 .227 r
F
.80684 .23825 m .79929 .24745 L .80029 .26097 L .59 .784 0 r
F
.15646 .2474 m .1465 .34366 L .15065 .33484 L 0 .366 .474 r
F
.13005 .24194 m .15065 .33484 L .15646 .2474 L 0 .751 .973 r
F
.17579 .24711 m .1729 .29351 L .19936 .29885 L 0 .943 .973 r
F
.18004 .2379 m .17579 .24711 L .1729 .29351 L 0 .475 .49 r
F
.75542 .24228 m .74888 .263 L .75616 .25388 L .428 .772 0 r
F
.22381 .24704 m .22194 .28307 L .24819 .28844 L 0 .943 .972 r
F
.22381 .24704 m .21745 .29207 L .22194 .28307 L 0 .511 .527 r
F
.70423 .24629 m .7049 .25898 L .72952 .2644 L .345 .969 0 r
F
.65617 .24637 m .65672 .25933 L .68149 .26475 L .345 .97 0 r
F
.66354 .25016 m .68149 .26475 L .65672 .25933 L .339 .953 0 r
F
.68778 .24265 m .68149 .26475 L .68842 .25563 L .268 .753 0 r
F
.66354 .25016 m .68842 .25563 L .68149 .26475 L .339 .953 0 r
F
.56997 .23199 m .58871 .24673 L .56364 .24126 L .151 .954 0 r
F
.56997 .23199 m .59515 .23752 L .58871 .24673 L F
.56364 .24126 m .58914 .26247 L .58871 .24673 L .153 .97 0 r
F
.59515 .23752 m .58871 .24673 L .58914 .26247 L .114 .721 0 r
F
.61184 .24119 m .63737 .26267 L .63675 .24666 L .153 .97 0 r
F
.4175 .24412 m .41182 .27117 L .41733 .26208 L 0 .646 .282 r
F
.66297 .23715 m .65617 .24637 L .65672 .25933 L .265 .744 0 r
F
.32357 .25839 m .34438 .27291 L .31855 .26752 L 0 .953 .604 r
F
.35 .24448 m .34438 .27291 L .34953 .26384 L 0 .61 .386 r
F
.32357 .25839 m .34953 .26384 L .34438 .27291 L 0 .953 .604 r
F
.42543 .23088 m .4454 .24565 L .41987 .24017 L 0 .954 .227 r
F
.42543 .23088 m .45108 .23642 L .4454 .24565 L F
.41987 .24017 m .44534 .26305 L .4454 .24565 L 0 .971 .231 r
F
.45108 .23642 m .4454 .24565 L .44534 .26305 L 0 .661 .157 r
F
.46809 .24009 m .4936 .26436 L .49347 .24557 L 0 .971 .231 r
F
.51287 .24528 m .51306 .26241 L .53832 .26782 L 0 .97 .039 r
F
.51891 .23605 m .51287 .24528 L .51306 .26241 L 0 .691 .028 r
F
.56095 .24521 m .56133 .26233 L .58643 .26775 L 0 .97 .039 r
F
.28071 .22978 m .30191 .24456 L .27591 .23907 L 0 .954 .605 r
F
.28071 .22978 m .30683 .23532 L .30191 .24456 L F
.27591 .23907 m .30103 .26975 L .30191 .24456 L 0 .972 .616 r
F
.30683 .23532 m .30191 .24456 L .30103 .26975 L 0 .58 .368 r
F
.32415 .239 m .34953 .26384 L .35 .24448 L 0 .971 .616 r
F
.61184 .24119 m .60583 .26635 L .61237 .25723 L .115 .728 0 r
F
.51913 .25323 m .53832 .26782 L .51306 .26241 L 0 .953 .038 r
F
.54419 .24156 m .53832 .26782 L .5445 .2587 L 0 .703 .028 r
F
.51913 .25323 m .5445 .2587 L .53832 .26782 L 0 .953 .038 r
F
.36939 .24419 m .36897 .26521 L .39472 .27062 L 0 .971 .424 r
F
.37468 .23495 m .36939 .24419 L .36897 .26521 L 0 .621 .271 r
F
.4175 .24412 m .41733 .26208 L .44291 .2675 L 0 .971 .423 r
F
.76593 .22902 m .78305 .24381 L .75855 .23832 L .717 .954 0 r
F
.76593 .22902 m .79053 .23457 L .78305 .24381 L F
.75855 .23832 m .78394 .25651 L .78305 .24381 L .728 .968 0 r
F
.79053 .23457 m .78305 .24381 L .78394 .25651 L .586 .78 0 r
F
.80684 .23825 m .83228 .25727 L .83118 .24374 L .728 .968 0 r
F
.1703 .30972 m .19244 .32384 L .16608 .3186 L 0 .733 .949 r
F
.1703 .30972 m .19678 .31501 L .19244 .32384 L F
.111 .37257 m .13363 .38616 L .10709 .38111 L 0 .355 .945 r
F
.111 .37257 m .13767 .37767 L .13363 .38616 L F
.13581 .22867 m .15824 .24347 L .13177 .23798 L 0 .925 .954 r
F
.13581 .22867 m .1624 .23422 L .15824 .24347 L F
.13177 .23798 m .15406 .30656 L .15824 .24347 L 0 .943 .973 r
F
.1624 .23422 m .15824 .24347 L .15406 .30656 L 0 .46 .474 r
F
.20635 .2434 m .19936 .29885 L .20377 .28985 L 0 .497 .513 r
F
.18004 .2379 m .20377 .28985 L .20635 .2434 L 0 .943 .972 r
F
.75542 .24228 m .75616 .25388 L .78067 .25932 L .537 .969 0 r
F
.22573 .2431 m .22409 .275 L .25037 .28039 L 0 .972 .809 r
F
.23026 .23385 m .22573 .2431 L .22409 .275 L 0 .527 .439 r
F
.27386 .24303 m .27285 .26795 L .29893 .27336 L 0 .972 .809 r
F
.27386 .24303 m .26809 .27702 L .27285 .26795 L 0 .561 .467 r
F
.70724 .24235 m .70794 .25534 L .7326 .26078 L .537 .969 0 r
F
.71505 .24612 m .7326 .26078 L .70794 .25534 L .528 .953 0 r
F
.73903 .23862 m .7326 .26078 L .73982 .25162 L .425 .767 0 r
F
.71505 .24612 m .73982 .25162 L .7326 .26078 L .528 .953 0 r
F
.62127 .22791 m .63962 .24272 L .61466 .23722 L .34 .954 0 r
F
.62127 .22791 m .64634 .23346 L .63962 .24272 L F
.61466 .23722 m .64013 .25598 L .63962 .24272 L .345 .97 0 r
F
.64634 .23346 m .63962 .24272 L .64013 .25598 L .263 .738 0 r
F
.66297 .23715 m .68842 .25563 L .68778 .24265 L .345 .969 0 r
F
.71433 .23309 m .70724 .24235 L .70794 .25534 L .42 .759 0 r
F
.80684 .23825 m .80029 .26097 L .80786 .2518 L .59 .784 0 r
F
.46809 .24009 m .46233 .26804 L .46812 .25892 L 0 .67 .159 r
F
.13005 .24194 m .12371 .32955 L .15065 .33484 L 0 .751 .973 r
F
.13005 .24194 m .11969 .33842 L .12371 .32955 L 0 .347 .449 r
F
.37428 .25604 m .39472 .27062 L .36897 .26521 L 0 .952 .415 r
F
.40042 .24046 m .39472 .27062 L .40014 .26151 L 0 .636 .277 r
F
.37428 .25604 m .40014 .26151 L .39472 .27062 L 0 .952 .415 r
F
.47643 .2268 m .49601 .24163 L .47058 .23613 L 0 .954 .038 r
F
.47643 .2268 m .50197 .23236 L .49601 .24163 L F
.47058 .23613 m .49614 .25906 L .49601 .24163 L 0 .97 .039 r
F
.50197 .23236 m .49601 .24163 L .49614 .25906 L 0 .683 .027 r
F
.51891 .23605 m .5445 .2587 L .54419 .24156 L 0 .97 .039 r
F
.66297 .23715 m .65672 .25933 L .66354 .25016 L .265 .744 0 r
F
.56364 .24126 m .564 .25702 L .58914 .26247 L .153 .97 0 r
F
.56997 .23199 m .56364 .24126 L .564 .25702 L .112 .71 0 r
F
.61184 .24119 m .61237 .25723 L .63737 .26267 L .153 .97 0 r
F
.32415 .239 m .31855 .26752 L .32357 .25839 L 0 .592 .376 r
F
.57035 .2478 m .58914 .26247 L .564 .25702 L .151 .953 0 r
F
.59515 .23752 m .58914 .26247 L .59561 .2533 L .114 .721 0 r
F
.57035 .2478 m .59561 .2533 L .58914 .26247 L .151 .953 0 r
F
.3314 .22569 m .35222 .24054 L .32632 .23503 L 0 .954 .416 r
F
.3314 .22569 m .35742 .23126 L .35222 .24054 L F
.32632 .23503 m .35167 .26325 L .35222 .24054 L 0 .971 .424 r
F
.35742 .23126 m .35222 .24054 L .35167 .26325 L 0 .61 .266 r
F
.37468 .23495 m .40014 .26151 L .40042 .24046 L 0 .971 .423 r
F
.41987 .24017 m .41971 .2576 L .44534 .26305 L 0 .971 .231 r
F
.42543 .23088 m .41987 .24017 L .41971 .2576 L 0 .646 .154 r
F
.46809 .24009 m .46812 .25892 L .4936 .26436 L 0 .971 .231 r
F
.81777 .22492 m .83449 .23979 L .8101 .23427 L .906 .954 0 r
F
.81777 .22492 m .84226 .2305 L .83449 .23979 L F
.8101 .23427 m .83564 .25389 L .83449 .23979 L .92 .968 0 r
F
.84226 .2305 m .83449 .23979 L .83564 .25389 L .752 .791 0 r
F
.18619 .22458 m .20825 .23944 L .18188 .23393 L 0 .954 .794 r
F
.18619 .22458 m .21269 .23015 L .20825 .23944 L F
.18004 .2379 m .17718 .28445 L .20377 .28985 L 0 .943 .972 r
F
.17718 .28445 m .20377 .28985 L .19936 .29885 L 0 .922 .95 r
F
.18188 .23393 m .20439 .30916 L .20825 .23944 L 0 .972 .809 r
F
.21269 .23015 m .20825 .23944 L .20439 .30916 L 0 .513 .427 r
F
.25648 .23937 m .25037 .28039 L .25505 .2713 L 0 .548 .456 r
F
.23026 .23385 m .25505 .2713 L .25648 .23937 L 0 .972 .809 r
F
.27591 .23907 m .27489 .26431 L .30103 .26975 L 0 .972 .616 r
F
.28071 .22978 m .27591 .23907 L .27489 .26431 L 0 .561 .356 r
F
.4253 .24838 m .44534 .26305 L .41971 .2576 L 0 .953 .227 r
F
.45108 .23642 m .44534 .26305 L .45104 .25388 L 0 .661 .157 r
F
.4253 .24838 m .45104 .25388 L .44534 .26305 L 0 .953 .227 r
F
.32415 .239 m .32357 .25839 L .34953 .26384 L 0 .971 .616 r
F
.75855 .23832 m .75938 .25105 L .78394 .25651 L .728 .968 0 r
F
.76678 .24179 m .78394 .25651 L .75938 .25105 L .717 .953 0 r
F
.79053 .23457 m .78394 .25651 L .79144 .24731 L .586 .78 0 r
F
.76678 .24179 m .79144 .24731 L .78394 .25651 L .717 .953 0 r
F
.51891 .23605 m .51306 .26241 L .51913 .25323 L 0 .691 .028 r
F
.6728 .22381 m .69076 .23869 L .6659 .23317 L .529 .954 0 r
F
.6728 .22381 m .69777 .22939 L .69076 .23869 L F
.6659 .23317 m .69148 .25308 L .69076 .23869 L .537 .969 0 r
F
.69777 .22939 m .69076 .23869 L .69148 .25308 L .417 .753 0 r
F
.71433 .23309 m .73982 .25162 L .73903 .23862 L .537 .969 0 r
F
.80684 .23825 m .80786 .2518 L .83228 .25727 L .728 .968 0 r
F
.76593 .22902 m .75855 .23832 L .75938 .25105 L .581 .772 0 r
F
.13177 .23798 m .12722 .3012 L .15406 .30656 L 0 .943 .973 r
F
.13581 .22867 m .13177 .23798 L .12722 .3012 L 0 .436 .449 r
F
.18004 .2379 m .1729 .29351 L .17718 .28445 L 0 .475 .49 r
F
.66297 .23715 m .66354 .25016 L .68842 .25563 L .345 .969 0 r
F
.61466 .23722 m .6151 .25051 L .64013 .25598 L .345 .97 0 r
F
.62174 .24124 m .64013 .25598 L .6151 .25051 L .339 .953 0 r
F
.64634 .23346 m .64013 .25598 L .64688 .24677 L .263 .738 0 r
F
.62174 .24124 m .64688 .24677 L .64013 .25598 L .339 .953 0 r
F
.52766 .22269 m .54685 .23759 L .52152 .23207 L .151 .954 0 r
F
.52766 .22269 m .5531 .22828 L .54685 .23759 L F
.52152 .23207 m .54715 .25393 L .54685 .23759 L .153 .97 0 r
F
.5531 .22828 m .54685 .23759 L .54715 .25393 L .111 .703 0 r
F
.56997 .23199 m .59561 .2533 L .59515 .23752 L .153 .97 0 r
F
.71433 .23309 m .70794 .25534 L .71505 .24612 L .42 .759 0 r
F
.62127 .22791 m .61466 .23722 L .6151 .25051 L .259 .728 0 r
F
.38233 .22158 m .40276 .2365 L .37696 .23096 L 0 .954 .227 r
F
.38233 .22158 m .40825 .22717 L .40276 .2365 L F
.37696 .23096 m .40253 .25423 L .40276 .2365 L 0 .971 .231 r
F
.40825 .22717 m .40276 .2365 L .40253 .25423 L 0 .636 .151 r
F
.22864 .26585 m .25037 .28039 L .22409 .275 L 0 .951 .792 r
F
.22864 .26585 m .25505 .2713 L .25037 .28039 L F
.42543 .23088 m .45104 .25388 L .45108 .23642 L 0 .971 .231 r
F
.37468 .23495 m .36897 .26521 L .37428 .25604 L 0 .621 .271 r
F
.47058 .23613 m .47061 .25359 L .49614 .25906 L 0 .97 .039 r
F
.47643 .2268 m .47058 .23613 L .47061 .25359 L 0 .67 .027 r
F
.51891 .23605 m .51913 .25323 L .5445 .2587 L 0 .97 .039 r
F
.23681 .22046 m .25849 .2354 L .23222 .22985 L 0 .954 .605 r
F
.23681 .22046 m .26321 .22606 L .25849 .2354 L F
.23222 .22985 m .25696 .2699 L .25849 .2354 L 0 .972 .616 r
F
.26321 .22606 m .25849 .2354 L .25696 .2699 L 0 .548 .347 r
F
.30683 .23532 m .30103 .26975 L .30598 .26059 L 0 .58 .368 r
F
.28071 .22978 m .30598 .26059 L .30683 .23532 L 0 .971 .616 r
F
.56997 .23199 m .564 .25702 L .57035 .2478 L .112 .71 0 r
F
.17718 .28445 m .19936 .29885 L .1729 .29351 L 0 .922 .95 r
F
.32632 .23503 m .32565 .25779 L .35167 .26325 L 0 .971 .424 r
F
.3314 .22569 m .32632 .23503 L .32565 .25779 L 0 .592 .258 r
F
.47648 .24432 m .49614 .25906 L .47061 .25359 L 0 .953 .038 r
F
.50197 .23236 m .49614 .25906 L .50213 .24985 L 0 .683 .027 r
F
.47648 .24432 m .50213 .24985 L .49614 .25906 L 0 .953 .038 r
F
.27971 .2551 m .30103 .26975 L .27489 .26431 L 0 .952 .604 r
F
.27971 .2551 m .30598 .26059 L .30103 .26975 L F
.37468 .23495 m .37428 .25604 L .40014 .26151 L 0 .971 .423 r
F
.72458 .21969 m .74214 .23464 L .71739 .22909 L .717 .954 0 r
F
.72458 .21969 m .74944 .2253 L .74214 .23464 L F
.71739 .22909 m .74296 .24794 L .74214 .23464 L .728 .968 0 r
F
.74944 .2253 m .74214 .23464 L .74296 .24794 L .577 .767 0 r
F
.76593 .22902 m .79144 .24731 L .79053 .23457 L .728 .968 0 r
F
.8101 .23427 m .81118 .2484 L .83564 .25389 L .92 .968 0 r
F
.81888 .2391 m .83564 .25389 L .81118 .2484 L .905 .953 0 r
F
.84226 .2305 m .83564 .25389 L .84344 .24465 L .752 .791 0 r
F
.81888 .2391 m .84344 .24465 L .83564 .25389 L .905 .953 0 r
F
.81777 .22492 m .8101 .23427 L .81118 .2484 L .745 .784 0 r
F
.1624 .23422 m .15406 .30656 L .15826 .29753 L 0 .46 .474 r
F
.13581 .22867 m .15826 .29753 L .1624 .23422 L 0 .943 .972 r
F
.18188 .23393 m .17761 .30378 L .20439 .30916 L 0 .972 .809 r
F
.18619 .22458 m .18188 .23393 L .17761 .30378 L 0 .49 .408 r
F
.23026 .23385 m .22864 .26585 L .25505 .2713 L 0 .972 .809 r
F
.23026 .23385 m .22409 .275 L .22864 .26585 L 0 .527 .439 r
F
.71433 .23309 m .71505 .24612 L .73982 .25162 L .537 .969 0 r
F
.57913 .21857 m .59793 .23354 L .5727 .22799 L .34 .954 0 r
F
.57913 .21857 m .60447 .22419 L .59793 .23354 L F
.5727 .22799 m .59833 .24712 L .59793 .23354 L .345 .97 0 r
F
.60447 .22419 m .59793 .23354 L .59833 .24712 L .257 .721 0 r
F
.42543 .23088 m .41971 .2576 L .4253 .24838 L 0 .646 .154 r
F
.62127 .22791 m .64688 .24677 L .64634 .23346 L .345 .969 0 r
F
.76593 .22902 m .75938 .25105 L .76678 .24179 L .581 .772 0 r
F
.6659 .23317 m .66655 .24759 L .69148 .25308 L .537 .969 0 r
F
.67348 .23827 m .69148 .25308 L .66655 .24759 L .528 .953 0 r
F
.69777 .22939 m .69148 .25308 L .69852 .24383 L .417 .753 0 r
F
.67348 .23827 m .69852 .24383 L .69148 .25308 L .528 .953 0 r
F
.6728 .22381 m .6659 .23317 L .66655 .24759 L .412 .744 0 r
F
.43349 .21745 m .45353 .23244 L .42784 .22688 L 0 .954 .038 r
F
.43349 .21745 m .45931 .22307 L .45353 .23244 L F
.42784 .22688 m .4535 .25076 L .45353 .23244 L 0 .97 .039 r
F
.45931 .22307 m .45353 .23244 L .4535 .25076 L 0 .661 .026 r
F
.47643 .2268 m .50213 .24985 L .50197 .23236 L 0 .97 .039 r
F
.62127 .22791 m .6151 .25051 L .62174 .24124 L .259 .728 0 r
F
.52152 .23207 m .52174 .24844 L .54715 .25393 L .153 .97 0 r
F
.52766 .22269 m .52152 .23207 L .52174 .24844 L .109 .691 0 r
F
.56997 .23199 m .57035 .2478 L .59561 .2533 L .153 .97 0 r
F
.33075 .24852 m .35167 .26325 L .32565 .25779 L 0 .952 .415 r
F
.35742 .23126 m .35167 .26325 L .3569 .25405 L 0 .61 .266 r
F
.33075 .24852 m .3569 .25405 L .35167 .26325 L 0 .952 .415 r
F
.5279 .23912 m .54715 .25393 L .52174 .24844 L .151 .953 0 r
F
.5531 .22828 m .54715 .25393 L .55343 .24468 L .111 .703 0 r
F
.5279 .23912 m .55343 .24468 L .54715 .25393 L .151 .953 0 r
F
.28767 .21633 m .30896 .23133 L .28279 .22576 L 0 .954 .416 r
F
.28767 .21633 m .31396 .22196 L .30896 .23133 L F
.28279 .22576 m .30814 .2558 L .30896 .23133 L 0 .971 .424 r
F
.31396 .22196 m .30896 .23133 L .30814 .2558 L 0 .58 .253 r
F
.3314 .22569 m .3569 .25405 L .35742 .23126 L 0 .971 .423 r
F
.37696 .23096 m .37663 .24873 L .40253 .25423 L 0 .971 .231 r
F
.38233 .22158 m .37696 .23096 L .37663 .24873 L 0 .621 .148 r
F
.42543 .23088 m .4253 .24838 L .45104 .25388 L 0 .971 .231 r
F
.7766 .21555 m .79376 .23057 L .76911 .225 L .906 .954 0 r
F
.7766 .21555 m .80135 .22119 L .79376 .23057 L F
.76911 .225 m .79481 .245 L .79376 .23057 L .92 .968 0 r
F
.80135 .22119 m .79376 .23057 L .79481 .245 L .741 .78 0 r
F
.81777 .22492 m .84344 .24465 L .84226 .2305 L .919 .968 0 r
F
.14166 .2152 m .1642 .23023 L .13756 .22465 L 0 .954 .794 r
F
.14166 .2152 m .16844 .22084 L .1642 .23023 L F
.13581 .22867 m .13129 .2921 L .15826 .29753 L 0 .943 .972 r
F
.13129 .2921 m .15826 .29753 L .15406 .30656 L 0 .92 .949 r
F
.13756 .22465 m .15842 .31907 L .1642 .23023 L 0 .972 .809 r
F
.16844 .22084 m .1642 .23023 L .15842 .31907 L 0 .474 .394 r
F
.21269 .23015 m .20439 .30916 L .20888 .3001 L 0 .513 .427 r
F
.18619 .22458 m .20888 .3001 L .21269 .23015 L 0 .972 .809 r
F
.23222 .22985 m .23048 .26443 L .25696 .2699 L 0 .972 .616 r
F
.23681 .22046 m .23222 .22985 L .23048 .26443 L 0 .527 .334 r
F
.28071 .22978 m .27971 .2551 L .30598 .26059 L 0 .971 .616 r
F
.28071 .22978 m .27489 .26431 L .27971 .2551 L 0 .561 .356 r
F
.38202 .23941 m .40253 .25423 L .37663 .24873 L 0 .953 .227 r
F
.40825 .22717 m .40253 .25423 L .40804 .24497 L 0 .636 .151 r
F
.38202 .23941 m .40804 .24497 L .40253 .25423 L 0 .953 .227 r
F
.76593 .22902 m .76678 .24179 L .79144 .24731 L .728 .968 0 r
F
.71739 .22909 m .71813 .24242 L .74296 .24794 L F
.72535 .23306 m .74296 .24794 L .71813 .24242 L .717 .953 0 r
F
.74944 .2253 m .74296 .24794 L .75028 .23864 L .577 .767 0 r
F
.72535 .23306 m .75028 .23864 L .74296 .24794 L .717 .953 0 r
F
.63084 .21443 m .64924 .22947 L .62412 .22389 L .529 .954 0 r
F
.63084 .21443 m .65607 .22007 L .64924 .22947 L F
.62412 .22389 m .64988 .24502 L .64924 .22947 L .537 .969 0 r
F
.65607 .22007 m .64924 .22947 L .64988 .24502 L .409 .738 0 r
F
.47643 .2268 m .47061 .25359 L .47648 .24432 L 0 .67 .027 r
F
.6728 .22381 m .69852 .24383 L .69777 .22939 L .537 .969 0 r
F
.72458 .21969 m .71739 .22909 L .71813 .24242 L .57 .759 0 r
F
.81777 .22492 m .81118 .2484 L .81888 .2391 L .745 .784 0 r
F
.13581 .22867 m .12722 .3012 L .13129 .2921 L 0 .436 .449 r
F
.48489 .2133 m .50455 .22836 L .47895 .22277 L .151 .954 0 r
F
.48489 .2133 m .51061 .21895 L .50455 .22836 L F
.47895 .22277 m .50471 .24531 L .50455 .22836 L .153 .97 0 r
F
.51061 .21895 m .50455 .22836 L .50471 .24531 L .108 .683 0 r
F
.62127 .22791 m .62174 .24124 L .64688 .24677 L .345 .969 0 r
F
.5727 .22799 m .57304 .24159 L .59833 .24712 L .345 .97 0 r
F
.57948 .23222 m .59833 .24712 L .57304 .24159 L .339 .953 0 r
F
.60447 .22419 m .59833 .24712 L .60489 .23781 L .257 .721 0 r
F
.57948 .23222 m .60489 .23781 L .59833 .24712 L .339 .953 0 r
F
.52766 .22269 m .55343 .24468 L .5531 .22828 L .153 .97 0 r
F
.57913 .21857 m .5727 .22799 L .57304 .24159 L .253 .71 0 r
F
.6728 .22381 m .66655 .24759 L .67348 .23827 L .412 .744 0 r
F
.33876 .21217 m .35967 .22725 L .3336 .22166 L 0 .954 .227 r
F
.33876 .21217 m .36496 .21783 L .35967 .22725 L F
.3336 .22166 m .35925 .24616 L .35967 .22725 L 0 .971 .231 r
F
.36496 .21783 m .35967 .22725 L .35925 .24616 L 0 .61 .145 r
F
.38233 .22158 m .40804 .24497 L .40825 .22717 L 0 .971 .231 r
F
.42784 .22688 m .4277 .24523 L .4535 .25076 L 0 .97 .039 r
F
.43349 .21745 m .42784 .22688 L .4277 .24523 L 0 .646 .026 r
F
.47643 .2268 m .47648 .24432 L .50213 .24985 L 0 .97 .039 r
F
.82886 .2114 m .84562 .22649 L .82108 .22089 L .954 .813 0 r
F
.82886 .2114 m .85351 .21706 L .84562 .22649 L F
.82108 .22089 m .84651 .23704 L .84562 .22649 L .967 .824 0 r
F
.85351 .21706 m .84562 .22649 L .84651 .23704 L .791 .674 0 r
F
.3314 .22569 m .32565 .25779 L .33075 .24852 L 0 .592 .258 r
F
.19244 .21104 m .21461 .22614 L .18806 .22054 L 0 .954 .605 r
F
.19244 .21104 m .21912 .21671 L .21461 .22614 L F
.18806 .22054 m .21119 .28934 L .21461 .22614 L 0 .972 .616 r
F
.21912 .21671 m .21461 .22614 L .21119 .28934 L 0 .513 .325 r
F
.26321 .22606 m .25696 .2699 L .26171 .26068 L 0 .548 .347 r
F
.23681 .22046 m .26171 .26068 L .26321 .22606 L 0 .971 .616 r
F
.52766 .22269 m .52174 .24844 L .5279 .23912 L .109 .691 0 r
F
.28279 .22576 m .28183 .25028 L .30814 .2558 L 0 .971 .424 r
F
.28767 .21633 m .28279 .22576 L .28183 .25028 L 0 .561 .245 r
F
.3314 .22569 m .33075 .24852 L .3569 .25405 L 0 .971 .423 r
F
.43338 .23586 m .4535 .25076 L .4277 .24523 L 0 .953 .038 r
F
.45931 .22307 m .4535 .25076 L .4593 .24145 L 0 .661 .026 r
F
.43338 .23586 m .4593 .24145 L .4535 .25076 L 0 .953 .038 r
F
.68279 .21027 m .7008 .22538 L .67578 .21977 L .717 .954 0 r
F
.68279 .21027 m .70792 .21593 L .7008 .22538 L F
.67578 .21977 m .7015 .23872 L .7008 .22538 L .728 .968 0 r
F
.70792 .21593 m .7008 .22538 L .7015 .23872 L .566 .753 0 r
F
.72458 .21969 m .75028 .23864 L .74944 .2253 L .728 .968 0 r
F
.81777 .22492 m .81888 .2391 L .84344 .24465 L .919 .968 0 r
F
.76911 .225 m .77009 .23946 L .79481 .245 L .92 .968 0 r
F
.7776 .23006 m .79481 .245 L .77009 .23946 L .905 .953 0 r
F
.80135 .22119 m .79481 .245 L .80243 .23567 L .741 .78 0 r
F
.7776 .23006 m .80243 .23567 L .79481 .245 L .905 .953 0 r
F
.7766 .21555 m .76911 .225 L .77009 .23946 L .733 .772 0 r
F
.13129 .2921 m .15406 .30656 L .12722 .3012 L 0 .92 .949 r
F
.13756 .22465 m .13124 .31368 L .15842 .31907 L 0 .972 .809 r
F
.14166 .2152 m .13756 .22465 L .13124 .31368 L 0 .449 .374 r
F
.18619 .22458 m .18197 .29466 L .20888 .3001 L 0 .972 .809 r
F
.18619 .22458 m .17761 .30378 L .18197 .29466 L 0 .49 .408 r
F
.53654 .20913 m .5558 .22426 L .53031 .21865 L .34 .954 0 r
F
.53654 .20913 m .56215 .21481 L .5558 .22426 L F
.53031 .21865 m .55614 .24068 L .5558 .22426 L .345 .97 0 r
F
.56215 .21481 m .5558 .22426 L .55614 .24068 L .25 .703 0 r
F
.57913 .21857 m .60489 .23781 L .60447 .22419 L .345 .969 0 r
F
.38233 .22158 m .37663 .24873 L .38202 .23941 L 0 .621 .148 r
F
.72458 .21969 m .71813 .24242 L .72535 .23306 L .57 .759 0 r
F
.02801 .95092 m .04335 .9498 L .04156 .95256 L .87 0 .172 r
F
.62412 .22389 m .62468 .23947 L .64988 .24502 L .537 .969 0 r
F
.63084 .21443 m .62412 .22389 L .62468 .23947 L .403 .728 0 r
F
.6728 .22381 m .67348 .23827 L .69852 .24383 L .537 .969 0 r
F
.12371 .32955 m .1465 .34366 L .11969 .33842 L 0 .731 .947 r
F
.12371 .32955 m .15065 .33484 L .1465 .34366 L F
.63142 .23006 m .64988 .24502 L .62468 .23947 L .528 .953 0 r
F
.65607 .22007 m .64988 .24502 L .65674 .23567 L .409 .738 0 r
F
.63142 .23006 m .65674 .23567 L .64988 .24502 L .528 .953 0 r
F
.39009 .208 m .41062 .22315 L .38464 .21753 L 0 .954 .038 r
F
.39009 .208 m .41619 .21368 L .41062 .22315 L F
.38464 .21753 m .41039 .24376 L .41062 .22315 L 0 .97 .039 r
F
.41619 .21368 m .41062 .22315 L .41039 .24376 L 0 .636 .025 r
F
.43349 .21745 m .4593 .24145 L .45931 .22307 L 0 .97 .039 r
F
.47895 .22277 m .47902 .23976 L .50471 .24531 L .153 .97 0 r
F
.48489 .2133 m .47895 .22277 L .47902 .23976 L .106 .67 0 r
F
.57913 .21857 m .57304 .24159 L .57948 .23222 L .253 .71 0 r
F
.52766 .22269 m .5279 .23912 L .55343 .24468 L .153 .97 0 r
F
.82108 .22089 m .82191 .23146 L .84651 .23704 L .967 .824 0 r
F
.82972 .222 m .84651 .23704 L .82191 .23146 L .953 .812 0 r
F
.85351 .21706 m .84651 .23704 L .85442 .22764 L .791 .674 0 r
F
.82972 .222 m .85442 .22764 L .84651 .23704 L .953 .812 0 r
F
.2351 .25515 m .25696 .2699 L .23048 .26443 L 0 .951 .603 r
F
.2351 .25515 m .26171 .26068 L .25696 .2699 L F
.24346 .20686 m .26525 .22203 L .2388 .2164 L 0 .954 .416 r
F
.24346 .20686 m .27004 .21255 L .26525 .22203 L F
.2388 .2164 m .26391 .25304 L .26525 .22203 L 0 .971 .424 r
F
.27004 .21255 m .26525 .22203 L .26391 .25304 L 0 .548 .239 r
F
.31396 .22196 m .30814 .2558 L .31317 .2465 L 0 .58 .253 r
F
.28767 .21633 m .31317 .2465 L .31396 .22196 L 0 .971 .423 r
F
.28673 .24092 m .30814 .2558 L .28183 .25028 L 0 .952 .415 r
F
.28673 .24092 m .31317 .2465 L .30814 .2558 L F
.48498 .23034 m .50471 .24531 L .47902 .23976 L .151 .953 0 r
F
.51061 .21895 m .50471 .24531 L .51079 .23596 L .108 .683 0 r
F
.48498 .23034 m .51079 .23596 L .50471 .24531 L .151 .953 0 r
F
.3336 .22166 m .33307 .2406 L .35925 .24616 L 0 .971 .231 r
F
.33876 .21217 m .3336 .22166 L .33307 .2406 L 0 .592 .141 r
F
.38233 .22158 m .38202 .23941 L .40804 .24497 L 0 .971 .231 r
F
.73499 .20608 m .75259 .22126 L .72769 .21563 L .906 .954 0 r
F
.73499 .20608 m .76001 .21178 L .75259 .22126 L F
.72769 .21563 m .75352 .23574 L .75259 .22126 L .92 .968 0 r
F
.76001 .21178 m .75259 .22126 L .75352 .23574 L .728 .767 0 r
F
.7766 .21555 m .80243 .23567 L .80135 .22119 L .919 .968 0 r
F
.01442 .94927 m .01614 .94648 L .02801 .95092 L .87 0 .172 r
F
.02801 .95092 m .01614 .94648 L .04335 .9498 L F
.82886 .2114 m .82108 .22089 L .82191 .23146 L .784 .668 0 r
F
.16844 .22084 m .15842 .31907 L .16271 .30998 L 0 .474 .394 r
F
.14166 .2152 m .16271 .30998 L .16844 .22084 L 0 .972 .809 r
F
.18806 .22054 m .18426 .28387 L .21119 .28934 L 0 .972 .616 r
F
.19244 .21104 m .18806 .22054 L .18426 .28387 L 0 .49 .311 r
F
.23681 .22046 m .2351 .25515 L .26171 .26068 L 0 .971 .616 r
F
.23681 .22046 m .23048 .26443 L .2351 .25515 L 0 .527 .334 r
F
.67578 .21977 m .67641 .23314 L .7015 .23872 L .728 .968 0 r
F
.68345 .22368 m .7015 .23872 L .67641 .23314 L .717 .953 0 r
F
.70792 .21593 m .7015 .23872 L .70864 .22932 L .566 .753 0 r
F
.68345 .22368 m .70864 .22932 L .7015 .23872 L .717 .953 0 r
F
.58842 .20495 m .60729 .22015 L .5819 .21451 L .529 .954 0 r
F
.58842 .20495 m .61393 .21065 L .60729 .22015 L F
.5819 .21451 m .60774 .23435 L .60729 .22015 L .537 .969 0 r
F
.61393 .21065 m .60729 .22015 L .60774 .23435 L .399 .721 0 r
F
.72458 .21969 m .72535 .23306 L .75028 .23864 L .728 .968 0 r
F
.63084 .21443 m .65674 .23567 L .65607 .22007 L .537 .969 0 r
F
.33825 .23118 m .35925 .24616 L .33307 .2406 L 0 .953 .227 r
F
.36496 .21783 m .35925 .24616 L .36455 .2368 L 0 .61 .145 r
F
.33825 .23118 m .36455 .2368 L .35925 .24616 L 0 .953 .227 r
F
.43349 .21745 m .4277 .24523 L .43338 .23586 L 0 .646 .026 r
F
.68279 .21027 m .67578 .21977 L .67641 .23314 L .559 .744 0 r
F
.7766 .21555 m .77009 .23946 L .7776 .23006 L .733 .772 0 r
F
.44167 .20381 m .4618 .21903 L .43593 .21338 L .151 .954 0 r
F
.44167 .20381 m .46766 .20952 L .4618 .21903 L F
.43593 .21338 m .4618 .23855 L .4618 .21903 L .153 .97 0 r
F
.46766 .20952 m .4618 .21903 L .4618 .23855 L .104 .661 0 r
F
.48489 .2133 m .51079 .23596 L .51061 .21895 L .153 .97 0 r
F
.57913 .21857 m .57948 .23222 L .60489 .23781 L .345 .969 0 r
F
.53031 .21865 m .53056 .2351 L .55614 .24068 L .345 .97 0 r
F
.53654 .20913 m .53031 .21865 L .53056 .2351 L .246 .691 0 r
F
.53681 .22564 m .55614 .24068 L .53056 .2351 L .339 .953 0 r
F
.56215 .21481 m .55614 .24068 L .56251 .23128 L .25 .703 0 r
F
.53681 .22564 m .56251 .23128 L .55614 .24068 L .339 .953 0 r
F
.29473 .20267 m .31612 .21791 L .28977 .21225 L 0 .954 .227 r
F
.29473 .20267 m .3212 .20838 L .31612 .21791 L F
.28977 .21225 m .31541 .24024 L .31612 .21791 L 0 .971 .231 r
F
.3212 .20838 m .31612 .21791 L .31541 .24024 L 0 .58 .138 r
F
.63084 .21443 m .62468 .23947 L .63142 .23006 L .403 .728 0 r
F
.33876 .21217 m .36455 .2368 L .36496 .21783 L 0 .971 .231 r
F
.38464 .21753 m .3843 .23818 L .41039 .24376 L 0 .97 .039 r
F
.39009 .208 m .38464 .21753 L .3843 .23818 L 0 .621 .025 r
F
.43349 .21745 m .43338 .23586 L .4593 .24145 L 0 .97 .039 r
F
.78744 .20188 m .80463 .21713 L .77983 .21147 L .954 .813 0 r
F
.78744 .20188 m .81235 .2076 L .80463 .21713 L F
.77983 .21147 m .80545 .228 L .80463 .21713 L .967 .824 0 r
F
.81235 .2076 m .80463 .21713 L .80545 .228 L .78 .664 0 r
F
.82886 .2114 m .85442 .22764 L .85351 .21706 L .967 .824 0 r
F
.82886 .2114 m .82191 .23146 L .82972 .222 L .784 .668 0 r
F
.1476 .20152 m .17026 .21678 L .14343 .21112 L 0 .954 .605 r
F
.1476 .20152 m .17456 .20725 L .17026 .21678 L F
.14166 .2152 m .13539 .30453 L .16271 .30998 L 0 .972 .809 r
F
.13539 .30453 m .16271 .30998 L .15842 .31907 L 0 .947 .788 r
F
.14343 .21112 m .16391 .31619 L .17026 .21678 L 0 .972 .616 r
F
.17456 .20725 m .17026 .21678 L .16391 .31619 L 0 .474 .3 r
F
.21912 .21671 m .21119 .28934 L .21575 .28012 L 0 .513 .325 r
F
.19244 .21104 m .21575 .28012 L .21912 .21671 L 0 .971 .616 r
F
.2388 .2164 m .23728 .24747 L .26391 .25304 L 0 .971 .424 r
F
.24346 .20686 m .2388 .2164 L .23728 .24747 L 0 .527 .23 r
F
.28767 .21633 m .28673 .24092 L .31317 .2465 L 0 .971 .423 r
F
.28767 .21633 m .28183 .25028 L .28673 .24092 L 0 .561 .245 r
F
.48489 .2133 m .47902 .23976 L .48498 .23034 L .106 .67 0 r
F
.64056 .20074 m .65902 .21601 L .63374 .21034 L .717 .954 0 r
F
.64056 .20074 m .66595 .20647 L .65902 .21601 L F
.63374 .21034 m .65959 .22912 L .65902 .21601 L .728 .968 0 r
F
.66595 .20647 m .65902 .21601 L .65959 .22912 L .555 .738 0 r
F
.68279 .21027 m .70864 .22932 L .70792 .21593 L .728 .968 0 r
F
.72769 .21563 m .72854 .23014 L .75352 .23574 L .92 .968 0 r
F
.73587 .22064 m .75352 .23574 L .72854 .23014 L .905 .953 0 r
F
.76001 .21178 m .75352 .23574 L .76096 .2263 L .728 .767 0 r
F
.73587 .22064 m .76096 .2263 L .75352 .23574 L .905 .953 0 r
F
.73499 .20608 m .72769 .21563 L .72854 .23014 L .721 .759 0 r
F
.7766 .21555 m .7776 .23006 L .80243 .23567 L .919 .968 0 r
F
.14166 .2152 m .13124 .31368 L .13539 .30453 L 0 .449 .374 r
F
.38977 .22873 m .41039 .24376 L .3843 .23818 L 0 .952 .038 r
F
.41619 .21368 m .41039 .24376 L .41598 .23437 L 0 .636 .025 r
F
.38977 .22873 m .41598 .23437 L .41039 .24376 L 0 .952 .038 r
F
.49349 .19959 m .51322 .21489 L .48746 .20921 L .34 .954 0 r
F
.49349 .19959 m .51937 .20533 L .51322 .21489 L F
.48746 .20921 m .51343 .23304 L .51322 .21489 L .345 .97 0 r
F
.51937 .20533 m .51322 .21489 L .51343 .23304 L .243 .683 0 r
F
.53654 .20913 m .56251 .23128 L .56215 .21481 L .345 .969 0 r
F
.5819 .21451 m .58228 .22874 L .60774 .23435 L .537 .969 0 r
F
.58882 .21922 m .60774 .23435 L .58228 .22874 L .528 .953 0 r
F
.61393 .21065 m .60774 .23435 L .61441 .2249 L .399 .721 0 r
F
.58882 .21922 m .61441 .2249 L .60774 .23435 L .528 .953 0 r
F
.68279 .21027 m .67641 .23314 L .68345 .22368 L .559 .744 0 r
F
.58842 .20495 m .5819 .21451 L .58228 .22874 L .393 .71 0 r
F
.63084 .21443 m .63142 .23006 L .65674 .23567 L .537 .969 0 r
F
.33876 .21217 m .33307 .2406 L .33825 .23118 L 0 .592 .141 r
F
.34623 .19845 m .36724 .21376 L .34099 .20808 L 0 .954 .038 r
F
.34623 .19845 m .37261 .20419 L .36724 .21376 L F
.34099 .20808 m .36678 .23585 L .36724 .21376 L 0 .97 .039 r
F
.37261 .20419 m .36724 .21376 L .36678 .23585 L 0 .61 .024 r
F
.39009 .208 m .41598 .23437 L .41619 .21368 L 0 .97 .039 r
F
.43593 .21338 m .43582 .23294 L .4618 .23855 L .153 .97 0 r
F
.44167 .20381 m .43593 .21338 L .43582 .23294 L .102 .646 0 r
F
.48489 .2133 m .48498 .23034 L .51079 .23596 L .153 .97 0 r
F
.84013 .19766 m .85692 .21298 L .83222 .2073 L .954 .624 0 r
F
.84013 .19766 m .86493 .20341 L .85692 .21298 L F
.83222 .2073 m .85769 .22191 L .85692 .21298 L .967 .632 0 r
F
.86493 .20341 m .85692 .21298 L .85769 .22191 L .791 .518 0 r
F
.82886 .2114 m .82972 .222 L .85442 .22764 L .967 .824 0 r
F
.77983 .21147 m .7806 .22236 L .80545 .228 L F
.78822 .2128 m .80545 .228 L .7806 .22236 L .953 .812 0 r
F
.81235 .2076 m .80545 .228 L .81319 .2185 L .78 .664 0 r
F
.78822 .2128 m .81319 .2185 L .80545 .228 L .953 .812 0 r
F
.18197 .29466 m .20439 .30916 L .17761 .30378 L 0 .948 .789 r
F
.18197 .29466 m .20888 .3001 L .20439 .30916 L F
.19879 .1973 m .22107 .21263 L .19434 .20694 L 0 .954 .416 r
F
.19879 .1973 m .22565 .20305 L .22107 .21263 L F
.19434 .20694 m .21817 .26757 L .22107 .21263 L 0 .971 .424 r
F
.22565 .20305 m .22107 .21263 L .21817 .26757 L 0 .513 .224 r
F
.27004 .21255 m .26391 .25304 L .26874 .24366 L 0 .548 .239 r
F
.24346 .20686 m .26874 .24366 L .27004 .21255 L 0 .971 .423 r
F
.53654 .20913 m .53056 .2351 L .53681 .22564 L .246 .691 0 r
F
.28977 .21225 m .28893 .23463 L .31541 .24024 L 0 .971 .231 r
F
.29473 .20267 m .28977 .21225 L .28893 .23463 L 0 .561 .134 r
F
.33876 .21217 m .33825 .23118 L .36455 .2368 L 0 .971 .231 r
F
.69294 .19651 m .71099 .21186 L .68582 .20616 L .906 .954 0 r
F
.69294 .19651 m .71822 .20227 L .71099 .21186 L F
.68582 .20616 m .71176 .22582 L .71099 .21186 L .92 .968 0 r
F
.71822 .20227 m .71099 .21186 L .71176 .22582 L .715 .753 0 r
F
.73499 .20608 m .76096 .2263 L .76001 .21178 L .919 .968 0 r
F
.78744 .20188 m .77983 .21147 L .7806 .22236 L .772 .658 0 r
F
.44159 .22344 m .4618 .23855 L .43582 .23294 L .15 .953 0 r
F
.46766 .20952 m .4618 .23855 L .46769 .22911 L .104 .661 0 r
F
.44159 .22344 m .46769 .22911 L .4618 .23855 L .15 .953 0 r
F
.13539 .30453 m .15842 .31907 L .13124 .31368 L 0 .947 .788 r
F
.14343 .21112 m .13647 .31073 L .16391 .31619 L 0 .972 .616 r
F
.1476 .20152 m .14343 .21112 L .13647 .31073 L 0 .449 .285 r
F
.19244 .21104 m .18869 .27458 L .21575 .28012 L 0 .971 .616 r
F
.19244 .21104 m .18426 .28387 L .18869 .27458 L 0 .49 .311 r
F
.63374 .21034 m .63424 .22347 L .65959 .22912 L .728 .968 0 r
F
.64108 .21391 m .65959 .22912 L .63424 .22347 L .717 .953 0 r
F
.66595 .20647 m .65959 .22912 L .66655 .21962 L .555 .738 0 r
F
.64108 .21391 m .66655 .21962 L .65959 .22912 L .717 .953 0 r
F
.54555 .19536 m .56489 .21073 L .53923 .20502 L .529 .954 0 r
F
.54555 .19536 m .57133 .20112 L .56489 .21073 L F
.53923 .20502 m .56524 .2261 L .56489 .21073 L .537 .969 0 r
F
.57133 .20112 m .56489 .21073 L .56524 .2261 L .389 .703 0 r
F
.68279 .21027 m .68345 .22368 L .70864 .22932 L .728 .968 0 r
F
.58842 .20495 m .61441 .2249 L .61393 .21065 L .537 .969 0 r
F
.64056 .20074 m .63374 .21034 L .63424 .22347 L .547 .728 0 r
F
.24197 .23804 m .26391 .25304 L .23728 .24747 L 0 .952 .415 r
F
.24197 .23804 m .26874 .24366 L .26391 .25304 L F
.73499 .20608 m .72854 .23014 L .73587 .22064 L .721 .759 0 r
F
.39798 .19421 m .41859 .20959 L .39245 .20389 L .151 .954 0 r
F
.39798 .19421 m .42425 .19998 L .41859 .20959 L F
.39245 .20389 m .41841 .22946 L .41859 .20959 L .153 .97 0 r
F
.42425 .19998 m .41859 .20959 L .41841 .22946 L .101 .636 0 r
F
.44167 .20381 m .46769 .22911 L .46766 .20952 L .153 .97 0 r
F
.83222 .2073 m .83295 .21624 L .85769 .22191 L .967 .632 0 r
F
.84088 .20663 m .85769 .22191 L .83295 .21624 L .953 .624 0 r
F
.86493 .20341 m .85769 .22191 L .86572 .21236 L .791 .518 0 r
F
.84088 .20663 m .86572 .21236 L .85769 .22191 L .953 .624 0 r
F
.39009 .208 m .3843 .23818 L .38977 .22873 L 0 .621 .025 r
F
.2939 .22512 m .31541 .24024 L .28893 .23463 L 0 .952 .227 r
F
.3212 .20838 m .31541 .24024 L .32051 .23079 L 0 .58 .138 r
F
.2939 .22512 m .32051 .23079 L .31541 .24024 L 0 .952 .227 r
F
.48746 .20921 m .48756 .2274 L .51343 .23304 L .345 .97 0 r
F
.49349 .19959 m .48746 .20921 L .48756 .2274 L .238 .67 0 r
F
.53654 .20913 m .53681 .22564 L .56251 .23128 L .345 .969 0 r
F
.58842 .20495 m .58228 .22874 L .58882 .21922 L .393 .71 0 r
F
.25022 .19306 m .27211 .20846 L .24548 .20275 L 0 .954 .227 r
F
.25022 .19306 m .27698 .19884 L .27211 .20846 L F
.24548 .20275 m .2709 .23764 L .27211 .20846 L 0 .971 .231 r
F
.27698 .19884 m .27211 .20846 L .2709 .23764 L 0 .548 .13 r
F
.29473 .20267 m .32051 .23079 L .3212 .20838 L 0 .971 .231 r
F
.34099 .20808 m .3404 .23021 L .36678 .23585 L 0 .97 .039 r
F
.34623 .19845 m .34099 .20808 L .3404 .23021 L 0 .592 .024 r
F
.39009 .208 m .38977 .22873 L .41598 .23437 L 0 .97 .039 r
F
.49362 .21784 m .51343 .23304 L .48756 .2274 L .339 .953 0 r
F
.51937 .20533 m .51343 .23304 L .51961 .22354 L .243 .683 0 r
F
.49362 .21784 m .51961 .22354 L .51343 .23304 L .339 .953 0 r
F
.74556 .19227 m .76321 .20768 L .73815 .20196 L .954 .813 0 r
F
.74556 .19227 m .77074 .19805 L .76321 .20768 L F
.73815 .20196 m .76395 .21886 L .76321 .20768 L .967 .824 0 r
F
.77074 .19805 m .76321 .20768 L .76395 .21886 L .767 .653 0 r
F
.78744 .20188 m .81319 .2185 L .81235 .2076 L .967 .824 0 r
F
.84013 .19766 m .83222 .2073 L .83295 .21624 L .784 .513 0 r
F
.17456 .20725 m .16391 .31619 L .16827 .307 L 0 .474 .3 r
F
.1476 .20152 m .16827 .307 L .17456 .20725 L 0 .971 .616 r
F
.78744 .20188 m .7806 .22236 L .78822 .2128 L .772 .658 0 r
F
.19434 .20694 m .1911 .26199 L .21817 .26757 L 0 .971 .424 r
F
.19879 .1973 m .19434 .20694 L .1911 .26199 L 0 .49 .214 r
F
.24346 .20686 m .24197 .23804 L .26874 .24366 L 0 .971 .423 r
F
.24346 .20686 m .23728 .24747 L .24197 .23804 L 0 .527 .23 r
F
.59787 .19111 m .61679 .20655 L .59124 .20082 L .717 .954 0 r
F
.59787 .19111 m .62354 .1969 L .61679 .20655 L F
.59124 .20082 m .61727 .22054 L .61679 .20655 L .728 .968 0 r
F
.62354 .1969 m .61679 .20655 L .61727 .22054 L .542 .721 0 r
F
.64056 .20074 m .66655 .21962 L .66595 .20647 L .728 .968 0 r
F
.68582 .20616 m .68651 .22015 L .71176 .22582 L .92 .968 0 r
F
.69365 .21055 m .71176 .22582 L .68651 .22015 L .905 .953 0 r
F
.71822 .20227 m .71176 .22582 L .71902 .21628 L .715 .753 0 r
F
.69365 .21055 m .71902 .21628 L .71176 .22582 L .905 .953 0 r
F
.69294 .19651 m .68582 .20616 L .68651 .22015 L .707 .744 0 r
F
.73499 .20608 m .73587 .22064 L .76096 .2263 L .919 .968 0 r
F
.44167 .20381 m .43582 .23294 L .44159 .22344 L .102 .646 0 r
F
.44998 .18995 m .47019 .20541 L .44415 .19967 L .34 .954 0 r
F
.44998 .18995 m .47614 .19575 L .47019 .20541 L F
.44415 .19967 m .47023 .22446 L .47019 .20541 L .345 .97 0 r
F
.47614 .19575 m .47019 .20541 L .47023 .22446 L .235 .661 0 r
F
.49349 .19959 m .51961 .22354 L .51937 .20533 L .345 .969 0 r
F
.64056 .20074 m .63424 .22347 L .64108 .21391 L .547 .728 0 r
F
.34567 .22065 m .36678 .23585 L .3404 .23021 L 0 .952 .038 r
F
.37261 .20419 m .36678 .23585 L .37217 .22635 L 0 .61 .024 r
F
.34567 .22065 m .37217 .22635 L .36678 .23585 L 0 .952 .038 r
F
.58842 .20495 m .58882 .21922 L .61441 .2249 L .537 .969 0 r
F
.53923 .20502 m .53949 .22043 L .56524 .2261 L F
.54555 .19536 m .53923 .20502 L .53949 .22043 L .383 .691 0 r
F
.54584 .21081 m .56524 .2261 L .53949 .22043 L .528 .953 0 r
F
.57133 .20112 m .56524 .2261 L .57171 .21655 L .389 .703 0 r
F
.54584 .21081 m .57171 .21655 L .56524 .2261 L .528 .953 0 r
F
.3019 .18879 m .3234 .20427 L .29687 .19853 L 0 .954 .038 r
F
.3019 .18879 m .32856 .1946 L .3234 .20427 L F
.29687 .19853 m .3226 .23066 L .3234 .20427 L 0 .97 .039 r
F
.32856 .1946 m .3234 .20427 L .3226 .23066 L 0 .58 .023 r
F
.34623 .19845 m .37217 .22635 L .37261 .20419 L 0 .97 .039 r
F
.39245 .20389 m .39215 .2238 L .41841 .22946 L .153 .97 0 r
F
.39798 .19421 m .39245 .20389 L .39215 .2238 L .098 .621 0 r
F
.44167 .20381 m .44159 .22344 L .46769 .22911 L .153 .97 0 r
F
.84013 .19766 m .83295 .21624 L .84088 .20663 L .784 .513 0 r
F
.29473 .20267 m .28893 .23463 L .2939 .22512 L 0 .561 .134 r
F
.79844 .188 m .81568 .20349 L .79072 .19774 L .954 .624 0 r
F
.79844 .188 m .82351 .19381 L .81568 .20349 L F
.79072 .19774 m .81642 .213 L .81568 .20349 L .967 .632 0 r
F
.82351 .19381 m .81568 .20349 L .81642 .213 L .78 .51 0 r
F
.84013 .19766 m .86572 .21236 L .86493 .20341 L .966 .632 0 r
F
.78744 .20188 m .78822 .2128 L .81319 .2185 L .967 .824 0 r
F
.73815 .20196 m .73883 .21316 L .76395 .21886 L F
.74627 .2035 m .76395 .21886 L .73883 .21316 L .953 .812 0 r
F
.77074 .19805 m .76395 .21886 L .77151 .20927 L .767 .653 0 r
F
.74627 .2035 m .77151 .20927 L .76395 .21886 L .953 .812 0 r
F
.15363 .18764 m .17642 .20313 L .1494 .19738 L 0 .954 .416 r
F
.15363 .18764 m .18078 .19345 L .17642 .20313 L F
.1494 .19738 m .17119 .28646 L .17642 .20313 L 0 .971 .424 r
F
.18078 .19345 m .17642 .20313 L .17119 .28646 L 0 .474 .207 r
F
.22565 .20305 m .21817 .26757 L .22279 .25817 L 0 .513 .224 r
F
.19879 .1973 m .22279 .25817 L .22565 .20305 L 0 .971 .423 r
F
.24548 .20275 m .24409 .23198 L .2709 .23764 L 0 .971 .231 r
F
.25022 .19306 m .24548 .20275 L .24409 .23198 L 0 .527 .125 r
F
.29473 .20267 m .2939 .22512 L .32051 .23079 L 0 .971 .231 r
F
.65043 .18684 m .66895 .20235 L .6435 .19659 L .906 .954 0 r
F
.65043 .18684 m .67599 .19265 L .66895 .20235 L F
.6435 .19659 m .66968 .21832 L .66895 .20235 L .92 .968 0 r
F
.67599 .19265 m .66895 .20235 L .66968 .21832 L .701 .738 0 r
F
.69294 .19651 m .71902 .21628 L .71822 .20227 L .919 .968 0 r
F
.49349 .19959 m .48756 .2274 L .49362 .21784 L .238 .67 0 r
F
.74556 .19227 m .73815 .20196 L .73883 .21316 L .759 .646 0 r
F
.3977 .21419 m .41841 .22946 L .39215 .2238 L .15 .953 0 r
F
.42425 .19998 m .41841 .22946 L .42409 .21992 L .101 .636 0 r
F
.3977 .21419 m .42409 .21992 L .41841 .22946 L .15 .953 0 r
F
.18869 .27458 m .21119 .28934 L .18426 .28387 L 0 .949 .602 r
F
.18869 .27458 m .21575 .28012 L .21119 .28934 L F
.1476 .20152 m .14069 .30148 L .16827 .307 L 0 .971 .616 r
F
.1476 .20152 m .13647 .31073 L .14069 .30148 L 0 .449 .285 r
F
.64056 .20074 m .64108 .21391 L .66655 .21962 L .728 .968 0 r
F
.50222 .18567 m .52203 .2012 L .49609 .19544 L .529 .954 0 r
F
.50222 .18567 m .52828 .1915 L .52203 .2012 L F
.49609 .19544 m .52223 .21634 L .52203 .2012 L .537 .969 0 r
F
.52828 .1915 m .52203 .2012 L .52223 .21634 L .378 .683 0 r
F
.54555 .19536 m .57171 .21655 L .57133 .20112 L .537 .969 0 r
F
.59124 .20082 m .59164 .21484 L .61727 .22054 L .728 .968 0 r
F
.59829 .20517 m .61727 .22054 L .59164 .21484 L .717 .953 0 r
F
.62354 .1969 m .61727 .22054 L .62404 .21094 L .542 .721 0 r
F
.59829 .20517 m .62404 .21094 L .61727 .22054 L .717 .953 0 r
F
.59787 .19111 m .59124 .20082 L .59164 .21484 L .534 .71 0 r
F
.69294 .19651 m .68651 .22015 L .69365 .21055 L .707 .744 0 r
F
.35382 .18451 m .37492 .20006 L .3485 .19429 L .151 .954 0 r
F
.35382 .18451 m .38038 .19034 L .37492 .20006 L F
.3485 .19429 m .37449 .2231 L .37492 .20006 L .153 .97 0 r
F
.38038 .19034 m .37492 .20006 L .37449 .2231 L .096 .61 0 r
F
.39798 .19421 m .42409 .21992 L .42425 .19998 L .153 .97 0 r
F
.84013 .19766 m .84088 .20663 L .86572 .21236 L .966 .632 0 r
F
.79072 .19774 m .79141 .20727 L .81642 .213 L .967 .632 0 r
F
.79915 .19756 m .81642 .213 L .79141 .20727 L .953 .623 0 r
F
.82351 .19381 m .81642 .213 L .82427 .20335 L .78 .51 0 r
F
.79915 .19756 m .82427 .20335 L .81642 .213 L .953 .623 0 r
F
.44415 .19967 m .44408 .21877 L .47023 .22446 L .345 .97 0 r
F
.44998 .18995 m .44415 .19967 L .44408 .21877 L .23 .646 0 r
F
.49349 .19959 m .49362 .21784 L .51961 .22354 L .345 .969 0 r
F
.34623 .19845 m .3404 .23021 L .34567 .22065 L 0 .592 .024 r
F
.85157 .18371 m .86839 .19927 L .84354 .1935 L .954 .435 0 r
F
.85157 .18371 m .87653 .18955 L .86839 .19927 L F
.84354 .1935 m .86934 .20992 L .86839 .19927 L .966 .441 0 r
F
.87653 .18955 m .86839 .19927 L .86934 .20992 L .791 .361 0 r
F
.54555 .19536 m .53949 .22043 L .54584 .21081 L .383 .691 0 r
F
.20523 .18335 m .22763 .19891 L .20071 .19314 L 0 .954 .227 r
F
.20523 .18335 m .23228 .18919 L .22763 .19891 L F
.20071 .19314 m .22489 .25211 L .22763 .19891 L 0 .971 .231 r
F
.23228 .18919 m .22763 .19891 L .22489 .25211 L 0 .513 .122 r
F
.27698 .19884 m .2709 .23764 L .27579 .22811 L 0 .548 .13 r
F
.25022 .19306 m .27579 .22811 L .27698 .19884 L 0 .971 .231 r
F
.29687 .19853 m .29591 .22497 L .3226 .23066 L 0 .97 .039 r
F
.3019 .18879 m .29687 .19853 L .29591 .22497 L 0 .561 .022 r
F
.34623 .19845 m .34567 .22065 L .37217 .22635 L 0 .97 .039 r
F
.70324 .18254 m .72135 .19813 L .69601 .19234 L .954 .813 0 r
F
.70324 .18254 m .72869 .18839 L .72135 .19813 L F
.69601 .19234 m .72201 .20962 L .72135 .19813 L .967 .824 0 r
F
.72869 .18839 m .72135 .19813 L .72201 .20962 L .753 .641 0 r
F
.74556 .19227 m .77151 .20927 L .77074 .19805 L .967 .824 0 r
F
.44993 .20911 m .47023 .22446 L .44408 .21877 L .339 .953 0 r
F
.47614 .19575 m .47023 .22446 L .4762 .21487 L .235 .661 0 r
F
.44993 .20911 m .4762 .21487 L .47023 .22446 L .339 .953 0 r
F
.79844 .188 m .79072 .19774 L .79141 .20727 L .772 .505 0 r
F
.74556 .19227 m .73883 .21316 L .74627 .2035 L .759 .646 0 r
F
.1494 .19738 m .14365 .28088 L .17119 .28646 L 0 .971 .424 r
F
.15363 .18764 m .1494 .19738 L .14365 .28088 L 0 .449 .196 r
F
.19879 .1973 m .19559 .25253 L .22279 .25817 L 0 .971 .423 r
F
.19879 .1973 m .1911 .26199 L .19559 .25253 L 0 .49 .214 r
F
.24885 .22239 m .2709 .23764 L .24409 .23198 L 0 .952 .227 r
F
.24885 .22239 m .27579 .22811 L .2709 .23764 L F
.55471 .18138 m .57411 .19698 L .54829 .19119 L .717 .954 0 r
F
.55471 .18138 m .58066 .18723 L .57411 .19698 L F
.54829 .19119 m .57447 .2113 L .57411 .19698 L .728 .968 0 r
F
.58066 .18723 m .57411 .19698 L .57447 .2113 L .528 .703 0 r
F
.59787 .19111 m .62404 .21094 L .62354 .1969 L .728 .968 0 r
F
.69294 .19651 m .69365 .21055 L .71902 .21628 L .919 .968 0 r
F
.6435 .19659 m .64415 .2126 L .66968 .21832 L .92 .968 0 r
F
.65043 .18684 m .6435 .19659 L .64415 .2126 L .691 .728 0 r
F
.39798 .19421 m .39215 .2238 L .3977 .21419 L .098 .621 0 r
F
.6511 .2029 m .66968 .21832 L .64415 .2126 L .905 .953 0 r
F
.67599 .19265 m .66968 .21832 L .67675 .20869 L .701 .738 0 r
F
.6511 .2029 m .67675 .20869 L .66968 .21832 L .905 .953 0 r
F
.40599 .18021 m .42669 .19583 L .40037 .19003 L .34 .954 0 r
F
.40599 .18021 m .43244 .18607 L .42669 .19583 L F
.40037 .19003 m .42654 .21636 L .42669 .19583 L .345 .97 0 r
F
.43244 .18607 m .42669 .19583 L .42654 .21636 L .227 .636 0 r
F
.44998 .18995 m .4762 .21487 L .47614 .19575 L .345 .969 0 r
F
.49609 .19544 m .49621 .21061 L .52223 .21634 L .537 .969 0 r
F
.50222 .18567 m .49609 .19544 L .49621 .21061 L .371 .67 0 r
F
.54555 .19536 m .54584 .21081 L .57171 .21655 L .537 .969 0 r
F
.59787 .19111 m .59164 .21484 L .59829 .20517 L .534 .71 0 r
F
.50236 .2009 m .52223 .21634 L .49621 .21061 L .528 .953 0 r
F
.52828 .1915 m .52223 .21634 L .5285 .20669 L .378 .683 0 r
F
.50236 .2009 m .5285 .20669 L .52223 .21634 L .528 .953 0 r
F
.84354 .1935 m .84444 .20417 L .86934 .20992 L .966 .441 0 r
F
.8525 .19442 m .86934 .20992 L .84444 .20417 L .953 .435 0 r
F
.87653 .18955 m .86934 .20992 L .87751 .20023 L .791 .361 0 r
F
.8525 .19442 m .87751 .20023 L .86934 .20992 L .953 .435 0 r
F
.25708 .17904 m .27909 .19468 L .25227 .18887 L 0 .954 .038 r
F
.25708 .17904 m .28403 .1849 L .27909 .19468 L F
.25227 .18887 m .27771 .22882 L .27909 .19468 L 0 .97 .039 r
F
.28403 .1849 m .27909 .19468 L .27771 .22882 L 0 .548 .022 r
F
.32856 .1946 m .3226 .23066 L .32778 .22108 L 0 .58 .023 r
F
.3019 .18879 m .32778 .22108 L .32856 .1946 L 0 .97 .039 r
F
.3485 .19429 m .34792 .21738 L .37449 .2231 L .153 .97 0 r
F
.35382 .18451 m .3485 .19429 L .34792 .21738 L .094 .592 0 r
F
.39798 .19421 m .3977 .21419 L .42409 .21992 L .153 .97 0 r
F
.79844 .188 m .79141 .20727 L .79915 .19756 L .772 .505 0 r
F
.30096 .21533 m .3226 .23066 L .29591 .22497 L 0 .952 .038 r
F
.30096 .21533 m .32778 .22108 L .3226 .23066 L F
.7563 .17823 m .77399 .19389 L .74877 .18808 L .954 .624 0 r
F
.7563 .17823 m .78164 .1841 L .77399 .19389 L F
.74877 .18808 m .77469 .20399 L .77399 .19389 L .967 .632 0 r
F
.78164 .1841 m .77399 .19389 L .77469 .20399 L .767 .501 0 r
F
.79844 .188 m .82427 .20335 L .82351 .19381 L .966 .632 0 r
F
.74556 .19227 m .74627 .2035 L .77151 .20927 L .967 .824 0 r
F
.69601 .19234 m .69661 .20387 L .72201 .20962 L F
.70386 .1941 m .72201 .20962 L .69661 .20387 L .953 .812 0 r
F
.72869 .18839 m .72201 .20962 L .72937 .19993 L .753 .641 0 r
F
.70386 .1941 m .72937 .19993 L .72201 .20962 L .953 .812 0 r
F
.85157 .18371 m .84354 .1935 L .84444 .20417 L .784 .358 0 r
F
.18078 .19345 m .17119 .28646 L .17561 .27706 L 0 .474 .207 r
F
.15363 .18764 m .17561 .27706 L .18078 .19345 L 0 .971 .423 r
F
.20071 .19314 m .19764 .24644 L .22489 .25211 L 0 .971 .231 r
F
.20523 .18335 m .20071 .19314 L .19764 .24644 L 0 .49 .117 r
F
.25022 .19306 m .24885 .22239 L .27579 .22811 L 0 .971 .231 r
F
.25022 .19306 m .24409 .23198 L .24885 .22239 L 0 .527 .125 r
F
.60745 .17706 m .62645 .19273 L .60073 .18692 L .906 .954 0 r
F
.60745 .17706 m .63329 .18294 L .62645 .19273 L F
.60073 .18692 m .62701 .2082 L .62645 .19273 L .92 .968 0 r
F
.63329 .18294 m .62645 .19273 L .62701 .2082 L .685 .721 0 r
F
.65043 .18684 m .67675 .20869 L .67599 .19265 L .919 .968 0 r
F
.70324 .18254 m .69601 .19234 L .69661 .20387 L .744 .634 0 r
F
.44998 .18995 m .44408 .21877 L .44993 .20911 L .23 .646 0 r
F
.45841 .17588 m .47871 .19158 L .45249 .18575 L .529 .954 0 r
F
.45841 .17588 m .48475 .18177 L .47871 .19158 L F
.45249 .18575 m .47878 .21016 L .47871 .19158 L .537 .969 0 r
F
.48475 .18177 m .47871 .19158 L .47878 .21016 L .366 .661 0 r
F
.50222 .18567 m .5285 .20669 L .52828 .1915 L .537 .969 0 r
F
.59787 .19111 m .59829 .20517 L .62404 .21094 L .728 .968 0 r
F
.54829 .19119 m .54856 .20553 L .57447 .2113 L F
.55501 .19577 m .57447 .2113 L .54856 .20553 L .717 .953 0 r
F
.58066 .18723 m .57447 .2113 L .58104 .20159 L .528 .703 0 r
F
.55501 .19577 m .58104 .20159 L .57447 .2113 L .717 .953 0 r
F
.19559 .25253 m .21817 .26757 L .1911 .26199 L 0 .95 .414 r
F
.19559 .25253 m .22279 .25817 L .21817 .26757 L F
.55471 .18138 m .54829 .19119 L .54856 .20553 L .52 .691 0 r
F
.35327 .20767 m .37449 .2231 L .34792 .21738 L .15 .952 0 r
F
.38038 .19034 m .37449 .2231 L .37996 .21346 L .096 .61 0 r
F
.35327 .20767 m .37996 .21346 L .37449 .2231 L .15 .952 0 r
F
.30918 .17471 m .33078 .19042 L .30407 .18459 L .151 .954 0 r
F
.30918 .17471 m .33602 .1806 L .33078 .19042 L F
.30407 .18459 m .32998 .21836 L .33078 .19042 L .153 .97 0 r
F
.33602 .1806 m .33078 .19042 L .32998 .21836 L .092 .58 0 r
F
.35382 .18451 m .37996 .21346 L .38038 .19034 L .153 .97 0 r
F
.65043 .18684 m .64415 .2126 L .6511 .2029 L .691 .728 0 r
F
.40037 .19003 m .4001 .2106 L .42654 .21636 L .345 .97 0 r
F
.40599 .18021 m .40037 .19003 L .4001 .2106 L .221 .621 0 r
F
.79844 .188 m .79915 .19756 L .82427 .20335 L .966 .632 0 r
F
.44998 .18995 m .44993 .20911 L .4762 .21487 L .345 .969 0 r
F
.74877 .18808 m .74941 .1982 L .77469 .20399 L .967 .632 0 r
F
.75697 .18839 m .77469 .20399 L .74941 .1982 L .953 .623 0 r
F
.78164 .1841 m .77469 .20399 L .78236 .19424 L .767 .501 0 r
F
.75697 .18839 m .78236 .19424 L .77469 .20399 L .953 .623 0 r
F
.80962 .1739 m .82689 .18963 L .80178 .18379 L .954 .435 0 r
F
.80962 .1739 m .83485 .1798 L .82689 .18963 L F
.80178 .18379 m .82773 .20003 L .82689 .18963 L .966 .441 0 r
F
.83485 .1798 m .82689 .18963 L .82773 .20003 L .78 .355 0 r
F
.85157 .18371 m .87751 .20023 L .87653 .18955 L .966 .44 0 r
F
.50222 .18567 m .49621 .21061 L .50236 .2009 L .371 .67 0 r
F
.85157 .18371 m .84444 .20417 L .8525 .19442 L .784 .358 0 r
F
.15975 .17353 m .18267 .18927 L .15546 .18343 L 0 .954 .227 r
F
.15975 .17353 m .1871 .17943 L .18267 .18927 L F
.15546 .18343 m .17787 .26718 L .18267 .18927 L 0 .971 .231 r
F
.1871 .17943 m .18267 .18927 L .17787 .26718 L 0 .474 .113 r
F
.23228 .18919 m .22489 .25211 L .22958 .24256 L 0 .513 .122 r
F
.20523 .18335 m .22958 .24256 L .23228 .18919 L 0 .971 .231 r
F
.25227 .18887 m .25069 .22309 L .27771 .22882 L 0 .97 .039 r
F
.25708 .17904 m .25227 .18887 L .25069 .22309 L 0 .527 .021 r
F
.3019 .18879 m .30096 .21533 L .32778 .22108 L 0 .97 .039 r
F
.3019 .18879 m .29591 .22497 L .30096 .21533 L 0 .561 .022 r
F
.66045 .17272 m .67903 .18847 L .65342 .18262 L .954 .813 0 r
F
.66045 .17272 m .68618 .17863 L .67903 .18847 L F
.65342 .18262 m .67958 .2 L .67903 .18847 L .967 .824 0 r
F
.68618 .17863 m .67903 .18847 L .67958 .2 L .738 .628 0 r
F
.70324 .18254 m .72937 .19993 L .72869 .18839 L .967 .824 0 r
F
.7563 .17823 m .74877 .18808 L .74941 .1982 L .759 .496 0 r
F
.70324 .18254 m .69661 .20387 L .70386 .1941 L .744 .634 0 r
F
.40574 .20084 m .42654 .21636 L .4001 .2106 L .339 .952 0 r
F
.43244 .18607 m .42654 .21636 L .43231 .20666 L .227 .636 0 r
F
.40574 .20084 m .43231 .20666 L .42654 .21636 L .339 .952 0 r
F
.15363 .18764 m .14793 .27141 L .17561 .27706 L 0 .971 .423 r
F
.15363 .18764 m .14365 .28088 L .14793 .27141 L 0 .449 .196 r
F
.51109 .17154 m .53097 .18731 L .50487 .18146 L .717 .954 0 r
F
.51109 .17154 m .53732 .17745 L .53097 .18731 L F
.50487 .18146 m .53122 .20309 L .53097 .18731 L .728 .968 0 r
F
.53732 .17745 m .53097 .18731 L .53122 .20309 L .513 .683 0 r
F
.55471 .18138 m .58104 .20159 L .58066 .18723 L .728 .968 0 r
F
.60073 .18692 m .6012 .20241 L .62701 .2082 L .92 .968 0 r
F
.60745 .17706 m .60073 .18692 L .6012 .20241 L .675 .71 0 r
F
.65043 .18684 m .6511 .2029 L .67675 .20869 L .919 .968 0 r
F
.60796 .1926 m .62701 .2082 L .6012 .20241 L .905 .953 0 r
F
.63329 .18294 m .62701 .2082 L .63388 .19846 L .685 .721 0 r
F
.60796 .1926 m .63388 .19846 L .62701 .2082 L .905 .953 0 r
F
.36153 .17035 m .38273 .18615 L .35612 .18029 L .34 .954 0 r
F
.36153 .17035 m .38827 .17628 L .38273 .18615 L F
.35612 .18029 m .38237 .20674 L .38273 .18615 L .345 .97 0 r
F
.38827 .17628 m .38273 .18615 L .38237 .20674 L .217 .61 0 r
F
.40599 .18021 m .43231 .20666 L .43244 .18607 L .345 .969 0 r
F
.45249 .18575 m .45246 .20437 L .47878 .21016 L .537 .969 0 r
F
.45841 .17588 m .45249 .18575 L .45246 .20437 L .358 .646 0 r
F
.50222 .18567 m .50236 .2009 L .5285 .20669 L .537 .969 0 r
F
.55471 .18138 m .54856 .20553 L .55501 .19577 L .52 .691 0 r
F
.80178 .18379 m .80256 .19421 L .82773 .20003 L .966 .441 0 r
F
.81043 .18435 m .82773 .20003 L .80256 .19421 L .953 .435 0 r
F
.83485 .1798 m .82773 .20003 L .83571 .19024 L .78 .355 0 r
F
.81043 .18435 m .83571 .19024 L .82773 .20003 L .953 .435 0 r
F
.86319 .16954 m .88004 .18535 L .85504 .17948 L .954 .246 0 r
F
.86319 .16954 m .88831 .17547 L .88004 .18535 L F
.85504 .17948 m .88093 .19492 L .88004 .18535 L .966 .249 0 r
F
.88831 .17547 m .88004 .18535 L .88093 .19492 L .791 .204 0 r
F
.85157 .18371 m .8525 .19442 L .87751 .20023 L .966 .44 0 r
F
.35382 .18451 m .34792 .21738 L .35327 .20767 L .094 .592 0 r
F
.21178 .16917 m .23429 .18498 L .20719 .17912 L 0 .954 .038 r
F
.21178 .16917 m .23902 .1751 L .23429 .18498 L F
.20719 .17912 m .23165 .23757 L .23429 .18498 L 0 .97 .039 r
F
.23902 .1751 m .23429 .18498 L .23165 .23757 L 0 .513 .021 r
F
.28403 .1849 m .27771 .22882 L .28269 .21916 L 0 .548 .022 r
F
.25708 .17904 m .28269 .21916 L .28403 .1849 L 0 .97 .039 r
F
.30407 .18459 m .3031 .21258 L .32998 .21836 L .153 .97 0 r
F
.30918 .17471 m .30407 .18459 L .3031 .21258 L .089 .561 0 r
F
.35382 .18451 m .35327 .20767 L .37996 .21346 L .153 .97 0 r
F
.4584 .19456 m .47878 .21016 L .45246 .20437 L .528 .953 0 r
F
.48475 .18177 m .47878 .21016 L .48485 .20041 L .366 .661 0 r
F
.4584 .19456 m .48485 .20041 L .47878 .21016 L .528 .953 0 r
F
.7137 .16836 m .73186 .18418 L .70636 .17831 L .954 .624 0 r
F
.7137 .16836 m .73932 .17429 L .73186 .18418 L F
.70636 .17831 m .73248 .19461 L .73186 .18418 L .967 .632 0 r
F
.73932 .17429 m .73186 .18418 L .73248 .19461 L .753 .492 0 r
F
.7563 .17823 m .78236 .19424 L .78164 .1841 L .966 .632 0 r
F
.7563 .17823 m .74941 .1982 L .75697 .18839 L .759 .496 0 r
F
.65342 .18262 m .65391 .19418 L .67958 .2 L .967 .824 0 r
F
.66096 .18431 m .67958 .2 L .65391 .19418 L .953 .812 0 r
F
.68618 .17863 m .67958 .2 L .68676 .1902 L .738 .628 0 r
F
.66096 .18431 m .68676 .1902 L .67958 .2 L .953 .812 0 r
F
.70324 .18254 m .70386 .1941 L .72937 .19993 L .967 .824 0 r
F
.80962 .1739 m .80178 .18379 L .80256 .19421 L .772 .352 0 r
F
.15546 .18343 m .15017 .2615 L .17787 .26718 L 0 .971 .231 r
F
.15975 .17353 m .15546 .18343 L .15017 .2615 L 0 .449 .107 r
F
.20523 .18335 m .2022 .23682 L .22958 .24256 L 0 .971 .231 r
F
.20523 .18335 m .19764 .24644 L .2022 .23682 L 0 .49 .117 r
F
.56401 .16717 m .58349 .18302 L .55749 .17714 L .906 .954 0 r
F
.56401 .16717 m .59014 .17311 L .58349 .18302 L F
.55749 .17714 m .58391 .19882 L .58349 .18302 L .92 .968 0 r
F
.59014 .17311 m .58349 .18302 L .58391 .19882 L .668 .703 0 r
F
.60745 .17706 m .63388 .19846 L .63329 .18294 L .919 .968 0 r
F
.66045 .17272 m .65342 .18262 L .65391 .19418 L .728 .62 0 r
F
.40599 .18021 m .4001 .2106 L .40574 .20084 L .221 .621 0 r
F
.41413 .16598 m .43492 .18185 L .40842 .17596 L .529 .954 0 r
F
.41413 .16598 m .44076 .17193 L .43492 .18185 L F
.40842 .17596 m .4348 .20248 L .43492 .18185 L .537 .969 0 r
F
.44076 .17193 m .43492 .18185 L .4348 .20248 L .353 .636 0 r
F
.45841 .17588 m .48485 .20041 L .48475 .18177 L .537 .969 0 r
F
.85504 .17948 m .85588 .18907 L .88093 .19492 L .966 .249 0 r
F
.86405 .17916 m .88093 .19492 L .85588 .18907 L .953 .246 0 r
F
.88831 .17547 m .88093 .19492 L .88921 .18507 L .791 .204 0 r
F
.86405 .17916 m .88921 .18507 L .88093 .19492 L .953 .246 0 r
F
.55471 .18138 m .55501 .19577 L .58104 .20159 L .728 .968 0 r
F
.50487 .18146 m .50502 .19726 L .53122 .20309 L F
.51109 .17154 m .50487 .18146 L .50502 .19726 L .504 .67 0 r
F
.25553 .21336 m .27771 .22882 L .25069 .22309 L 0 .951 .038 r
F
.25553 .21336 m .28269 .21916 L .27771 .22882 L F
.51126 .1874 m .53122 .20309 L .50502 .19726 L .717 .953 0 r
F
.53732 .17745 m .53122 .20309 L .53759 .19328 L .513 .683 0 r
F
.51126 .1874 m .53759 .19328 L .53122 .20309 L .717 .953 0 r
F
.60745 .17706 m .6012 .20241 L .60796 .1926 L .675 .71 0 r
F
.26405 .16479 m .28617 .18068 L .25916 .17479 L .151 .954 0 r
F
.26405 .16479 m .29119 .17075 L .28617 .18068 L F
.25916 .17479 m .28499 .21099 L .28617 .18068 L .153 .97 0 r
F
.29119 .17075 m .28617 .18068 L .28499 .21099 L .087 .548 0 r
F
.33602 .1806 m .32998 .21836 L .33525 .20863 L .092 .58 0 r
F
.30918 .17471 m .33525 .20863 L .33602 .1806 L .153 .97 0 r
F
.35612 .18029 m .35564 .20092 L .38237 .20674 L .345 .97 0 r
F
.36153 .17035 m .35612 .18029 L .35564 .20092 L .211 .592 0 r
F
.40599 .18021 m .40574 .20084 L .43231 .20666 L .345 .969 0 r
F
.7563 .17823 m .75697 .18839 L .78236 .19424 L .966 .632 0 r
F
.70636 .17831 m .70693 .18875 L .73248 .19461 L .967 .632 0 r
F
.71429 .17883 m .73248 .19461 L .70693 .18875 L .953 .623 0 r
F
.73932 .17429 m .73248 .19461 L .73996 .18475 L .753 .492 0 r
F
.71429 .17883 m .73996 .18475 L .73248 .19461 L .953 .623 0 r
F
.76721 .16397 m .78494 .17988 L .75956 .17398 L .954 .435 0 r
F
.76721 .16397 m .79271 .16994 L .78494 .17988 L F
.75956 .17398 m .78577 .19145 L .78494 .17988 L .966 .441 0 r
F
.79271 .16994 m .78494 .17988 L .78577 .19145 L .767 .35 0 r
F
.80962 .1739 m .83571 .19024 L .83485 .1798 L .966 .44 0 r
F
.80962 .1739 m .80256 .19421 L .81043 .18435 L .772 .352 0 r
F
.86319 .16954 m .85504 .17948 L .85588 .18907 L .784 .202 0 r
F
.1871 .17943 m .17787 .26718 L .18235 .25761 L 0 .474 .113 r
F
.15975 .17353 m .18235 .25761 L .1871 .17943 L 0 .971 .231 r
F
.30823 .20279 m .32998 .21836 L .3031 .21258 L .15 .952 0 r
F
.30823 .20279 m .33525 .20863 L .32998 .21836 L F
.20719 .17912 m .20422 .23181 L .23165 .23757 L 0 .97 .039 r
F
.21178 .16917 m .20719 .17912 L .20422 .23181 L 0 .49 .02 r
F
.25708 .17904 m .25553 .21336 L .28269 .21916 L 0 .97 .039 r
F
.25708 .17904 m .25069 .22309 L .25553 .21336 L 0 .527 .021 r
F
.6172 .16278 m .63625 .17871 L .61036 .1728 L .954 .813 0 r
F
.6172 .16278 m .64321 .16876 L .63625 .17871 L F
.61036 .1728 m .6367 .19028 L .63625 .17871 L .967 .824 0 r
F
.64321 .16876 m .63625 .17871 L .6367 .19028 L .721 .614 0 r
F
.66045 .17272 m .68676 .1902 L .68618 .17863 L .967 .824 0 r
F
.45841 .17588 m .45246 .20437 L .4584 .19456 L .358 .646 0 r
F
.7137 .16836 m .70636 .17831 L .70693 .18875 L .744 .487 0 r
F
.14069 .30148 m .16391 .31619 L .13647 .31073 L 0 .946 .6 r
F
.14069 .30148 m .16827 .307 L .16391 .31619 L F
.66045 .17272 m .65391 .19418 L .66096 .18431 L .728 .62 0 r
F
.36107 .19106 m .38237 .20674 L .35564 .20092 L .339 .952 0 r
F
.38827 .17628 m .38237 .20674 L .38793 .19694 L .217 .61 0 r
F
.36107 .19106 m .38793 .19694 L .38237 .20674 L .339 .952 0 r
F
.2022 .23682 m .22489 .25211 L .19764 .24644 L 0 .95 .226 r
F
.2022 .23682 m .22958 .24256 L .22489 .25211 L F
.46699 .16159 m .48737 .17753 L .46097 .17162 L .717 .954 0 r
F
.46699 .16159 m .4935 .16757 L .48737 .17753 L F
.46097 .17162 m .48747 .19563 L .48737 .17753 L .728 .968 0 r
F
.4935 .16757 m .48737 .17753 L .48747 .19563 L .497 .661 0 r
F
.51109 .17154 m .53759 .19328 L .53732 .17745 L .728 .968 0 r
F
.55749 .17714 m .55782 .19297 L .58391 .19882 L .92 .968 0 r
F
.56401 .16717 m .55749 .17714 L .55782 .19297 L .656 .691 0 r
F
.60745 .17706 m .60796 .1926 L .63388 .19846 L .919 .968 0 r
F
.56438 .18305 m .58391 .19882 L .55782 .19297 L .905 .953 0 r
F
.59014 .17311 m .58391 .19882 L .59059 .18897 L .668 .703 0 r
F
.56438 .18305 m .59059 .18897 L .58391 .19882 L .905 .953 0 r
F
.31658 .16039 m .33829 .17636 L .31139 .17044 L .34 .954 0 r
F
.31658 .16039 m .34361 .16638 L .33829 .17636 L F
.31139 .17044 m .33765 .19987 L .33829 .17636 L .345 .97 0 r
F
.34361 .16638 m .33829 .17636 L .33765 .19987 L .207 .58 0 r
F
.36153 .17035 m .38793 .19694 L .38827 .17628 L .345 .969 0 r
F
.40842 .17596 m .40818 .19663 L .4348 .20248 L .537 .969 0 r
F
.41413 .16598 m .40842 .17596 L .40818 .19663 L .344 .621 0 r
F
.45841 .17588 m .4584 .19456 L .48485 .20041 L .537 .969 0 r
F
.86319 .16954 m .85588 .18907 L .86405 .17916 L .784 .202 0 r
F
.80962 .1739 m .81043 .18435 L .83571 .19024 L .966 .44 0 r
F
.82097 .15957 m .83828 .17555 L .81301 .16962 L .954 .246 0 r
F
.82097 .15957 m .84636 .16557 L .83828 .17555 L F
.81301 .16962 m .83908 .18515 L .83828 .17555 L .966 .249 0 r
F
.84636 .16557 m .83828 .17555 L .83908 .18515 L .78 .201 0 r
F
.86319 .16954 m .88921 .18507 L .88831 .17547 L .965 .249 0 r
F
.75956 .17398 m .76032 .18557 L .78577 .19145 L .966 .441 0 r
F
.768 .1756 m .78577 .19145 L .76032 .18557 L .953 .435 0 r
F
.79271 .16994 m .78577 .19145 L .79356 .18155 L .767 .35 0 r
F
.768 .1756 m .79356 .18155 L .78577 .19145 L .953 .435 0 r
F
.16598 .1592 m .18901 .17518 L .16161 .16925 L 0 .954 .038 r
F
.16598 .1592 m .19352 .16519 L .18901 .17518 L F
.16161 .16925 m .18513 .23951 L .18901 .17518 L 0 .97 .039 r
F
.19352 .16519 m .18901 .17518 L .18513 .23951 L 0 .474 .019 r
F
.51109 .17154 m .50502 .19726 L .51126 .1874 L .504 .67 0 r
F
.23902 .1751 m .23165 .23757 L .23642 .22786 L 0 .513 .021 r
F
.21178 .16917 m .23642 .22786 L .23902 .1751 L 0 .97 .039 r
F
.25916 .17479 m .2578 .20516 L .28499 .21099 L .153 .97 0 r
F
.26405 .16479 m .25916 .17479 L .2578 .20516 L .083 .527 0 r
F
.30918 .17471 m .30823 .20279 L .33525 .20863 L .153 .97 0 r
F
.30918 .17471 m .3031 .21258 L .30823 .20279 L .089 .561 0 r
F
.67063 .15837 m .68927 .17437 L .66349 .16844 L .954 .624 0 r
F
.67063 .15837 m .69653 .16438 L .68927 .17437 L F
.66349 .16844 m .68981 .18511 L .68927 .17437 L .967 .632 0 r
F
.69653 .16438 m .68927 .17437 L .68981 .18511 L .738 .482 0 r
F
.7137 .16836 m .73996 .18475 L .73932 .17429 L .966 .632 0 r
F
.7137 .16836 m .70693 .18875 L .71429 .17883 L .744 .487 0 r
F
.61036 .1728 m .61074 .18439 L .6367 .19028 L .967 .824 0 r
F
.6176 .17442 m .6367 .19028 L .61074 .18439 L .953 .812 0 r
F
.64321 .16876 m .6367 .19028 L .64367 .18037 L .721 .614 0 r
F
.6176 .17442 m .64367 .18037 L .6367 .19028 L .953 .812 0 r
F
.66045 .17272 m .66096 .18431 L .68676 .1902 L .967 .824 0 r
F
.76721 .16397 m .75956 .17398 L .76032 .18557 L .759 .346 0 r
F
.41391 .18672 m .4348 .20248 L .40818 .19663 L .528 .952 0 r
F
.44076 .17193 m .4348 .20248 L .44067 .19263 L .353 .636 0 r
F
.41391 .18672 m .44067 .19263 L .4348 .20248 L .528 .952 0 r
F
.15975 .17353 m .15452 .25186 L .18235 .25761 L 0 .971 .231 r
F
.15975 .17353 m .15017 .2615 L .15452 .25186 L 0 .449 .107 r
F
.5201 .15717 m .54006 .1732 L .51378 .16725 L .906 .954 0 r
F
.5201 .15717 m .5465 .16318 L .54006 .1732 L F
.51378 .16725 m .54037 .19104 L .54006 .1732 L .92 .968 0 r
F
.5465 .16318 m .54006 .1732 L .54037 .19104 L .648 .683 0 r
F
.56401 .16717 m .59059 .18897 L .59014 .17311 L .919 .968 0 r
F
.6172 .16278 m .61036 .1728 L .61074 .18439 L .71 .605 0 r
F
.36153 .17035 m .35564 .20092 L .36107 .19106 L .211 .592 0 r
F
.36936 .15597 m .39066 .17202 L .36387 .16606 L .529 .954 0 r
F
.36936 .15597 m .39628 .16199 L .39066 .17202 L F
.36387 .16606 m .39032 .19328 L .39066 .17202 L .537 .969 0 r
F
.39628 .16199 m .39066 .17202 L .39032 .19328 L .338 .61 0 r
F
.41413 .16598 m .44067 .19263 L .44076 .17193 L .537 .969 0 r
F
.81301 .16962 m .81376 .17924 L .83908 .18515 L .966 .249 0 r
F
.82175 .16923 m .83908 .18515 L .81376 .17924 L .953 .246 0 r
F
.84636 .16557 m .83908 .18515 L .84719 .1752 L .78 .201 0 r
F
.82175 .16923 m .84719 .1752 L .83908 .18515 L .953 .246 0 r
F
.46097 .17162 m .46097 .18975 L .48747 .19563 L .728 .968 0 r
F
.46699 .16159 m .46097 .17162 L .46097 .18975 L .486 .646 0 r
F
.86319 .16954 m .86405 .17916 L .88921 .18507 L .965 .249 0 r
F
.51109 .17154 m .51126 .1874 L .53759 .19328 L .728 .968 0 r
F
.875 .15515 m .89188 .1712 L .86672 .16525 L .954 .057 0 r
F
.875 .15515 m .90027 .16117 L .89188 .1712 L F
.86672 .16525 m .89269 .17969 L .89188 .1712 L .965 .058 0 r
F
.90027 .16117 m .89188 .1712 L .89269 .17969 L .791 .047 0 r
F
.21843 .15477 m .24106 .17083 L .21376 .16487 L .151 .954 0 r
F
.21843 .15477 m .24586 .1608 L .24106 .17083 L F
.21376 .16487 m .23856 .22194 L .24106 .17083 L .153 .97 0 r
F
.24586 .1608 m .24106 .17083 L .23856 .22194 L .081 .513 0 r
F
.56401 .16717 m .55782 .19297 L .56438 .18305 L .656 .691 0 r
F
.29119 .17075 m .28499 .21099 L .29004 .20116 L .087 .548 0 r
F
.26405 .16479 m .29004 .20116 L .29119 .17075 L .153 .97 0 r
F
.31139 .17044 m .31061 .19399 L .33765 .19987 L .345 .97 0 r
F
.31658 .16039 m .31139 .17044 L .31061 .19399 L .2 .561 0 r
F
.14793 .27141 m .17119 .28646 L .14365 .28088 L 0 .947 .413 r
F
.14793 .27141 m .17561 .27706 L .17119 .28646 L F
.36153 .17035 m .36107 .19106 L .38793 .19694 L .345 .969 0 r
F
.46701 .17978 m .48747 .19563 L .46097 .18975 L .716 .953 0 r
F
.4935 .16757 m .48747 .19563 L .49363 .18573 L .497 .661 0 r
F
.46701 .17978 m .49363 .18573 L .48747 .19563 L .716 .953 0 r
F
.7137 .16836 m .71429 .17883 L .73996 .18475 L .966 .632 0 r
F
.66349 .16844 m .66397 .1792 L .68981 .18511 L .967 .632 0 r
F
.67114 .16917 m .68981 .18511 L .66397 .1792 L .953 .623 0 r
F
.69653 .16438 m .68981 .18511 L .69709 .17515 L .738 .482 0 r
F
.67114 .16917 m .69709 .17515 L .68981 .18511 L .953 .623 0 r
F
.72433 .15394 m .74254 .17002 L .71687 .16406 L .954 .435 0 r
F
.72433 .15394 m .75011 .15997 L .74254 .17002 L F
.71687 .16406 m .74323 .18106 L .74254 .17002 L .966 .441 0 r
F
.75011 .15997 m .74254 .17002 L .74323 .18106 L .753 .343 0 r
F
.76721 .16397 m .79356 .18155 L .79271 .16994 L .966 .44 0 r
F
.82097 .15957 m .81301 .16962 L .81376 .17924 L .772 .199 0 r
F
.76721 .16397 m .76032 .18557 L .768 .1756 L .759 .346 0 r
F
.16161 .16925 m .15732 .23371 L .18513 .23951 L 0 .97 .039 r
F
.16598 .1592 m .16161 .16925 L .15732 .23371 L 0 .449 .018 r
F
.21178 .16917 m .20885 .22204 L .23642 .22786 L 0 .97 .039 r
F
.21178 .16917 m .20422 .23181 L .20885 .22204 L 0 .49 .02 r
F
.57346 .15274 m .59301 .16884 L .56683 .16286 L .954 .813 0 r
F
.57346 .15274 m .59976 .15878 L .59301 .16884 L F
.56683 .16286 m .59344 .18357 L .59301 .16884 L .967 .824 0 r
F
.59976 .15878 m .59301 .16884 L .59344 .18357 L .703 .599 0 r
F
.6172 .16278 m .64367 .18037 L .64321 .16876 L .967 .824 0 r
F
.26272 .19526 m .28499 .21099 L .2578 .20516 L .15 .952 0 r
F
.26272 .19526 m .29004 .20116 L .28499 .21099 L F
.67063 .15837 m .66349 .16844 L .66397 .1792 L .728 .476 0 r
F
.6172 .16278 m .61074 .18439 L .6176 .17442 L .71 .605 0 r
F
.86672 .16525 m .86748 .17375 L .89269 .17969 L .965 .058 0 r
F
.87579 .16368 m .89269 .17969 L .86748 .17375 L .953 .057 0 r
F
.90027 .16117 m .89269 .17969 L .9011 .16968 L .791 .047 0 r
F
.87579 .16368 m .9011 .16968 L .89269 .17969 L .953 .057 0 r
F
.41413 .16598 m .40818 .19663 L .41391 .18672 L .344 .621 0 r
F
.4224 .15153 m .44328 .16765 L .4166 .16167 L .717 .954 0 r
F
.4224 .15153 m .44921 .15758 L .44328 .16765 L F
.4166 .16167 m .44321 .18524 L .44328 .16765 L .728 .968 0 r
F
.44921 .15758 m .44328 .16765 L .44321 .18524 L .478 .636 0 r
F
.46699 .16159 m .49363 .18573 L .4935 .16757 L .728 .968 0 r
F
.51378 .16725 m .51398 .18513 L .54037 .19104 L .92 .968 0 r
F
.5201 .15717 m .51378 .16725 L .51398 .18513 L .636 .67 0 r
F
.56401 .16717 m .56438 .18305 L .59059 .18897 L .919 .968 0 r
F
.31582 .18403 m .33765 .19987 L .31061 .19399 L .339 .952 0 r
F
.34361 .16638 m .33765 .19987 L .34299 .18997 L .207 .58 0 r
F
.31582 .18403 m .34299 .18997 L .33765 .19987 L .339 .952 0 r
F
.27113 .15032 m .29336 .16646 L .26616 .16048 L .34 .954 0 r
F
.27113 .15032 m .29846 .15638 L .29336 .16646 L F
.26616 .16048 m .2923 .19491 L .29336 .16646 L .345 .97 0 r
F
.29846 .15638 m .29336 .16646 L .2923 .19491 L .195 .548 0 r
F
.31658 .16039 m .34299 .18997 L .34361 .16638 L .345 .969 0 r
F
.36387 .16606 m .36341 .18737 L .39032 .19328 L .537 .969 0 r
F
.36936 .15597 m .36387 .16606 L .36341 .18737 L .328 .592 0 r
F
.52033 .17511 m .54037 .19104 L .51398 .18513 L .905 .953 0 r
F
.5465 .16318 m .54037 .19104 L .54684 .18108 L .648 .683 0 r
F
.52033 .17511 m .54684 .18108 L .54037 .19104 L .905 .953 0 r
F
.41413 .16598 m .41391 .18672 L .44067 .19263 L .537 .969 0 r
F
.82097 .15957 m .81376 .17924 L .82175 .16923 L .772 .199 0 r
F
.77829 .14949 m .79607 .16565 L .77051 .15965 L .954 .246 0 r
F
.77829 .14949 m .80396 .15555 L .79607 .16565 L F
.77051 .15965 m .7968 .17557 L .79607 .16565 L .966 .249 0 r
F
.80396 .15555 m .79607 .16565 L .7968 .17557 L .767 .198 0 r
F
.71687 .16406 m .7175 .17512 L .74323 .18106 L .966 .441 0 r
F
.72498 .16504 m .74323 .18106 L .7175 .17512 L .953 .435 0 r
F
.75011 .15997 m .74323 .18106 L .75083 .17105 L .753 .343 0 r
F
.72498 .16504 m .75083 .17105 L .74323 .18106 L .953 .435 0 r
F
.82097 .15957 m .84719 .1752 L .84636 .16557 L .965 .249 0 r
F
.76721 .16397 m .768 .1756 L .79356 .18155 L .966 .44 0 r
F
.875 .15515 m .86672 .16525 L .86748 .17375 L .784 .047 0 r
F
.19352 .16519 m .18513 .23951 L .18968 .22974 L 0 .474 .019 r
F
.16598 .1592 m .18968 .22974 L .19352 .16519 L 0 .97 .039 r
F
.21376 .16487 m .21095 .21608 L .23856 .22194 L .153 .97 0 r
F
.21843 .15477 m .21376 .16487 L .21095 .21608 L .077 .49 0 r
F
.26405 .16479 m .26272 .19526 L .29004 .20116 L .153 .97 0 r
F
.26405 .16479 m .2578 .20516 L .26272 .19526 L .083 .527 0 r
F
.62709 .14828 m .64621 .16446 L .62015 .15846 L .954 .624 0 r
F
.62709 .14828 m .65327 .15435 L .64621 .16446 L F
.62015 .15846 m .64671 .17666 L .64621 .16446 L .967 .632 0 r
F
.65327 .15435 m .64621 .16446 L .64671 .17666 L .721 .472 0 r
F
.67063 .15837 m .69709 .17515 L .69653 .16438 L .966 .632 0 r
F
.46699 .16159 m .46097 .18975 L .46701 .17978 L .486 .646 0 r
F
.67063 .15837 m .66397 .1792 L .67114 .16917 L .728 .476 0 r
F
.6172 .16278 m .6176 .17442 L .64367 .18037 L .967 .824 0 r
F
.72433 .15394 m .71687 .16406 L .7175 .17512 L .744 .339 0 r
F
.20885 .22204 m .23165 .23757 L .20422 .23181 L 0 .95 .038 r
F
.20885 .22204 m .23642 .22786 L .23165 .23757 L F
.36892 .17735 m .39032 .19328 L .36341 .18737 L .528 .952 0 r
F
.39628 .16199 m .39032 .19328 L .39597 .18333 L .338 .61 0 r
F
.36892 .17735 m .39597 .18333 L .39032 .19328 L .528 .952 0 r
F
.47569 .14707 m .49616 .16327 L .46958 .15726 L .906 .954 0 r
F
.47569 .14707 m .50239 .15315 L .49616 .16327 L F
.46958 .15726 m .4963 .18117 L .49616 .16327 L .92 .968 0 r
F
.50239 .15315 m .49616 .16327 L .4963 .18117 L .628 .661 0 r
F
.5201 .15717 m .54684 .18108 L .5465 .16318 L .919 .968 0 r
F
.56683 .16286 m .56718 .17763 L .59344 .18357 L .967 .824 0 r
F
.57383 .16755 m .59344 .18357 L .56718 .17763 L .953 .812 0 r
F
.59976 .15878 m .59344 .18357 L .60022 .17356 L .703 .599 0 r
F
.57383 .16755 m .60022 .17356 L .59344 .18357 L .953 .812 0 r
F
.57346 .15274 m .56683 .16286 L .56718 .17763 L .691 .589 0 r
F
.32409 .14585 m .34591 .16207 L .31882 .15606 L .529 .954 0 r
F
.32409 .14585 m .35131 .15194 L .34591 .16207 L F
.31882 .15606 m .34533 .18455 L .34591 .16207 L .537 .969 0 r
F
.35131 .15194 m .34591 .16207 L .34533 .18455 L .321 .58 0 r
F
.36936 .15597 m .39597 .18333 L .39628 .16199 L .537 .969 0 r
F
.875 .15515 m .86748 .17375 L .87579 .16368 L .784 .047 0 r
F
.4166 .16167 m .41642 .17929 L .44321 .18524 L .728 .968 0 r
F
.4224 .15153 m .4166 .16167 L .41642 .17929 L .467 .621 0 r
F
.82097 .15957 m .82175 .16923 L .84719 .1752 L .965 .249 0 r
F
.77051 .15965 m .7712 .16959 L .7968 .17557 L .966 .249 0 r
F
.77899 .15946 m .7968 .17557 L .7712 .16959 L .953 .246 0 r
F
.80396 .15555 m .7968 .17557 L .80472 .1655 L .767 .198 0 r
F
.77899 .15946 m .80472 .1655 L .7968 .17557 L .953 .246 0 r
F
.46699 .16159 m .46701 .17978 L .49363 .18573 L .728 .968 0 r
F
.83251 .14502 m .84985 .16125 L .82442 .15523 L .954 .057 0 r
F
.83251 .14502 m .85806 .15111 L .84985 .16125 L F
.82442 .15523 m .85044 .16806 L .84985 .16125 L .965 .058 0 r
F
.85806 .15111 m .84985 .16125 L .85044 .16806 L .78 .047 0 r
F
.875 .15515 m .9011 .16968 L .90027 .16117 L .964 .058 0 r
F
.31658 .16039 m .31061 .19399 L .31582 .18403 L .2 .561 0 r
F
.1723 .14464 m .19546 .16088 L .16786 .15485 L .151 .954 0 r
F
.1723 .14464 m .20004 .15073 L .19546 .16088 L F
.16786 .15485 m .19204 .21883 L .19546 .16088 L .153 .97 0 r
F
.20004 .15073 m .19546 .16088 L .19204 .21883 L .075 .474 0 r
F
.24586 .1608 m .23856 .22194 L .24341 .21207 L .081 .513 0 r
F
.21843 .15477 m .24341 .21207 L .24586 .1608 L .153 .97 0 r
F
.42224 .16921 m .44321 .18524 L .41642 .17929 L .716 .953 0 r
F
.44921 .15758 m .44321 .18524 L .44916 .17523 L .478 .636 0 r
F
.42224 .16921 m .44916 .17523 L .44321 .18524 L .716 .953 0 r
F
.26616 .16048 m .26493 .18898 L .2923 .19491 L .345 .97 0 r
F
.27113 .15032 m .26616 .16048 L .26493 .18898 L .188 .527 0 r
F
.31658 .16039 m .31582 .18403 L .34299 .18997 L .345 .969 0 r
F
.68098 .1438 m .69967 .16006 L .67372 .15403 L .954 .435 0 r
F
.68098 .1438 m .70705 .1499 L .69967 .16006 L F
.67372 .15403 m .70026 .17113 L .69967 .16006 L .966 .441 0 r
F
.70705 .1499 m .69967 .16006 L .70026 .17113 L .738 .336 0 r
F
.5201 .15717 m .51398 .18513 L .52033 .17511 L .636 .67 0 r
F
.67063 .15837 m .67114 .16917 L .69709 .17515 L .966 .632 0 r
F
.72433 .15394 m .75083 .17105 L .75011 .15997 L .966 .44 0 r
F
.77829 .14949 m .77051 .15965 L .7712 .16959 L .759 .196 0 r
F
.72433 .15394 m .7175 .17512 L .72498 .16504 L .744 .339 0 r
F
.62015 .15846 m .62058 .17068 L .64671 .17666 L .967 .632 0 r
F
.62754 .16054 m .64671 .17666 L .62058 .17068 L .953 .623 0 r
F
.65327 .15435 m .64671 .17666 L .6538 .16659 L .721 .472 0 r
F
.62754 .16054 m .6538 .16659 L .64671 .17666 L .953 .623 0 r
F
.16598 .1592 m .16173 .22387 L .18968 .22974 L 0 .97 .039 r
F
.16598 .1592 m .15732 .23371 L .16173 .22387 L 0 .449 .018 r
F
.52925 .14258 m .54929 .15886 L .52283 .15282 L .954 .813 0 r
F
.52925 .14258 m .55584 .14869 L .54929 .15886 L F
.52283 .15282 m .54957 .17336 L .54929 .15886 L .967 .824 0 r
F
.55584 .14869 m .54929 .15886 L .54957 .17336 L .683 .582 0 r
F
.57346 .15274 m .60022 .17356 L .59976 .15878 L .967 .824 0 r
F
.82442 .15523 m .82497 .16205 L .85044 .16806 L .965 .058 0 r
F
.83308 .15186 m .85044 .16806 L .82497 .16205 L .954 .057 0 r
F
.85806 .15111 m .85044 .16806 L .85866 .15794 L .78 .047 0 r
F
.83308 .15186 m .85866 .15794 L .85044 .16806 L .954 .057 0 r
F
.62709 .14828 m .62015 .15846 L .62058 .17068 L .71 .464 0 r
F
.15452 .25186 m .17787 .26718 L .15017 .2615 L 0 .948 .226 r
F
.15452 .25186 m .18235 .25761 L .17787 .26718 L F
.875 .15515 m .87579 .16368 L .9011 .16968 L .964 .058 0 r
F
.37732 .14136 m .39871 .15766 L .37173 .15161 L .717 .954 0 r
F
.37732 .14136 m .40442 .14748 L .39871 .15766 L F
.37173 .15161 m .39844 .17702 L .39871 .15766 L .728 .968 0 r
F
.40442 .14748 m .39871 .15766 L .39844 .17702 L .458 .61 0 r
F
.4224 .15153 m .44916 .17523 L .44921 .15758 L .728 .968 0 r
F
.36936 .15597 m .36341 .18737 L .36892 .17735 L .328 .592 0 r
F
.46958 .15726 m .46962 .17519 L .4963 .18117 L .92 .968 0 r
F
.47569 .14707 m .46958 .15726 L .46962 .17519 L .614 .646 0 r
F
.5201 .15717 m .52033 .17511 L .54684 .18108 L .919 .968 0 r
F
.57346 .15274 m .56718 .17763 L .57383 .16755 L .691 .589 0 r
F
.22518 .14014 m .24794 .15646 L .22044 .15041 L .34 .954 0 r
F
.22518 .14014 m .25281 .14626 L .24794 .15646 L F
.22044 .15041 m .24546 .20868 L .24794 .15646 L .345 .97 0 r
F
.25281 .14626 m .24794 .15646 L .24546 .20868 L .183 .513 0 r
F
.29846 .15638 m .2923 .19491 L .29743 .18492 L .195 .548 0 r
F
.27113 .15032 m .29743 .18492 L .29846 .15638 L .345 .969 0 r
F
.31882 .15606 m .31811 .17858 L .34533 .18455 L .537 .969 0 r
F
.32409 .14585 m .31882 .15606 L .31811 .17858 L .311 .561 0 r
F
.47575 .16506 m .4963 .18117 L .46962 .17519 L .905 .953 0 r
F
.50239 .15315 m .4963 .18117 L .50256 .1711 L .628 .661 0 r
F
.47575 .16506 m .50256 .1711 L .4963 .18117 L .905 .953 0 r
F
.36936 .15597 m .36892 .17735 L .39597 .18333 L .537 .969 0 r
F
.73513 .1393 m .75339 .15564 L .72755 .14957 L .954 .246 0 r
F
.73513 .1393 m .76108 .14543 L .75339 .15564 L F
.72755 .14957 m .75405 .16587 L .75339 .15564 L .966 .249 0 r
F
.76108 .14543 m .75339 .15564 L .75405 .16587 L .753 .194 0 r
F
.77829 .14949 m .7712 .16959 L .77899 .15946 L .759 .196 0 r
F
.67372 .15403 m .67425 .16512 L .70026 .17113 L .966 .441 0 r
F
.68153 .15494 m .70026 .17113 L .67425 .16512 L .953 .435 0 r
F
.70705 .1499 m .70026 .17113 L .70766 .16101 L .738 .336 0 r
F
.68153 .15494 m .70766 .16101 L .70026 .17113 L .953 .435 0 r
F
.77829 .14949 m .80472 .1655 L .80396 .15555 L .965 .249 0 r
F
.72433 .15394 m .72498 .16504 L .75083 .17105 L .966 .44 0 r
F
.83251 .14502 m .82442 .15523 L .82497 .16205 L .772 .046 0 r
F
.26992 .17892 m .2923 .19491 L .26493 .18898 L .339 .952 0 r
F
.26992 .17892 m .29743 .18492 L .2923 .19491 L F
.16786 .15485 m .16407 .21292 L .19204 .21883 L .153 .97 0 r
F
.1723 .14464 m .16786 .15485 L .16407 .21292 L .071 .449 0 r
F
.21843 .15477 m .21565 .20615 L .24341 .21207 L .153 .97 0 r
F
.21843 .15477 m .21095 .21608 L .21565 .20615 L .077 .49 0 r
F
.4224 .15153 m .41642 .17929 L .42224 .16921 L .467 .621 0 r
F
.58306 .13808 m .60268 .15443 L .57633 .14836 L .954 .624 0 r
F
.58306 .13808 m .60954 .14421 L .60268 .15443 L F
.57633 .14836 m .60305 .16638 L .60268 .15443 L .967 .632 0 r
F
.60954 .14421 m .60268 .15443 L .60305 .16638 L .703 .46 0 r
F
.62709 .14828 m .6538 .16659 L .65327 .15435 L .966 .632 0 r
F
.68098 .1438 m .67372 .15403 L .67425 .16512 L .728 .332 0 r
F
.62709 .14828 m .62058 .17068 L .62754 .16054 L .71 .464 0 r
F
.4308 .13685 m .45177 .15323 L .4249 .14715 L .906 .954 0 r
F
.4308 .13685 m .45779 .14299 L .45177 .15323 L F
.4249 .14715 m .45173 .17176 L .45177 .15323 L .92 .968 0 r
F
.45779 .14299 m .45177 .15323 L .45173 .17176 L .604 .636 0 r
F
.47569 .14707 m .50256 .1711 L .50239 .15315 L .919 .968 0 r
F
.52283 .15282 m .52303 .16735 L .54957 .17336 L .967 .824 0 r
F
.52947 .15716 m .54957 .17336 L .52303 .16735 L .953 .812 0 r
F
.55584 .14869 m .54957 .17336 L .55614 .16324 L .683 .582 0 r
F
.52947 .15716 m .55614 .16324 L .54957 .17336 L .953 .812 0 r
F
.3234 .16845 m .34533 .18455 L .31811 .17858 L .528 .952 0 r
F
.35131 .15194 m .34533 .18455 L .35076 .17449 L .321 .58 0 r
F
.3234 .16845 m .35076 .17449 L .34533 .18455 L .528 .952 0 r
F
.52925 .14258 m .52283 .15282 L .52303 .16735 L .67 .571 0 r
F
.57346 .15274 m .57383 .16755 L .60022 .17356 L .967 .824 0 r
F
.83251 .14502 m .82497 .16205 L .83308 .15186 L .772 .046 0 r
F
.27833 .13562 m .30066 .15202 L .27328 .14594 L .529 .954 0 r
F
.27833 .13562 m .30585 .14177 L .30066 .15202 L F
.27328 .14594 m .29981 .17601 L .30066 .15202 L .537 .969 0 r
F
.30585 .14177 m .30066 .15202 L .29981 .17601 L .304 .548 0 r
F
.32409 .14585 m .35076 .17449 L .35131 .15194 L .537 .969 0 r
F
.37173 .15161 m .37135 .17101 L .39844 .17702 L .728 .968 0 r
F
.37732 .14136 m .37173 .15161 L .37135 .17101 L .445 .592 0 r
F
.4224 .15153 m .42224 .16921 L .44916 .17523 L .728 .968 0 r
F
.77829 .14949 m .77899 .15946 L .80472 .1655 L .965 .249 0 r
F
.72755 .14957 m .72816 .15983 L .75405 .16587 L .966 .249 0 r
F
.73576 .14959 m .75405 .16587 L .72816 .15983 L .953 .246 0 r
F
.76108 .14543 m .75405 .16587 L .76177 .1557 L .753 .194 0 r
F
.73576 .14959 m .76177 .1557 L .75405 .16587 L .953 .246 0 r
F
.78955 .13478 m .80737 .15119 L .78165 .1451 L .954 .057 0 r
F
.78955 .13478 m .81538 .14094 L .80737 .15119 L F
.78165 .1451 m .80794 .15859 L .80737 .15119 L .965 .058 0 r
F
.81538 .14094 m .80737 .15119 L .80794 .15859 L .767 .046 0 r
F
.83251 .14502 m .85866 .15794 L .85806 .15111 L .964 .058 0 r
F
.20004 .15073 m .19204 .21883 L .19665 .20887 L .075 .474 0 r
F
.1723 .14464 m .19665 .20887 L .20004 .15073 L .153 .97 0 r
F
.22044 .15041 m .21763 .20273 L .24546 .20868 L .345 .97 0 r
F
.22518 .14014 m .22044 .15041 L .21763 .20273 L .174 .49 0 r
F
.27113 .15032 m .26992 .17892 L .29743 .18492 L .345 .969 0 r
F
.27113 .15032 m .26493 .18898 L .26992 .17892 L .188 .527 0 r
F
.21565 .20615 m .23856 .22194 L .21095 .21608 L .15 .95 0 r
F
.21565 .20615 m .24341 .21207 L .23856 .22194 L F
.63714 .13355 m .65633 .14998 L .63009 .14389 L .954 .435 0 r
F
.63714 .13355 m .6635 .13971 L .65633 .14998 L F
.63009 .14389 m .65682 .16138 L .65633 .14998 L .966 .441 0 r
F
.6635 .13971 m .65633 .14998 L .65682 .16138 L .721 .329 0 r
F
.47569 .14707 m .46962 .17519 L .47575 .16506 L .614 .646 0 r
F
.68098 .1438 m .70766 .16101 L .70705 .1499 L .966 .44 0 r
F
.37695 .16083 m .39844 .17702 L .37135 .17101 L .716 .953 0 r
F
.40442 .14748 m .39844 .17702 L .40418 .1669 L .458 .61 0 r
F
.37695 .16083 m .40418 .1669 L .39844 .17702 L .716 .953 0 r
F
.73513 .1393 m .72755 .14957 L .72816 .15983 L .744 .192 0 r
F
.57633 .14836 m .57664 .16034 L .60305 .16638 L .967 .632 0 r
F
.58339 .15009 m .60305 .16638 L .57664 .16034 L .953 .623 0 r
F
.60954 .14421 m .60305 .16638 L .60994 .1562 L .703 .46 0 r
F
.58339 .15009 m .60994 .1562 L .60305 .16638 L .953 .623 0 r
F
.68098 .1438 m .67425 .16512 L .68153 .15494 L .728 .332 0 r
F
.62709 .14828 m .62754 .16054 L .6538 .16659 L .966 .632 0 r
F
.16173 .22387 m .18513 .23951 L .15732 .23371 L 0 .949 .038 r
F
.16173 .22387 m .18968 .22974 L .18513 .23951 L F
.48454 .13231 m .50509 .14877 L .47833 .14267 L .954 .813 0 r
F
.48454 .13231 m .51142 .13849 L .50509 .14877 L F
.47833 .14267 m .50525 .16561 L .50509 .14877 L .967 .824 0 r
F
.51142 .13849 m .50509 .14877 L .50525 .16561 L .661 .563 0 r
F
.52925 .14258 m .55614 .16324 L .55584 .14869 L .967 .824 0 r
F
.58306 .13808 m .57633 .14836 L .57664 .16034 L .691 .452 0 r
F
.83251 .14502 m .83308 .15186 L .85866 .15794 L .964 .058 0 r
F
.78165 .1451 m .78218 .15252 L .80794 .15859 L .965 .058 0 r
F
.79009 .14222 m .80794 .15859 L .78218 .15252 L .954 .057 0 r
F
.81538 .14094 m .80794 .15859 L .81597 .14836 L .767 .046 0 r
F
.79009 .14222 m .81597 .14836 L .80794 .15859 L .954 .057 0 r
F
.33173 .13108 m .35365 .14756 L .32637 .14145 L .717 .954 0 r
F
.33173 .13108 m .35914 .13726 L .35365 .14756 L F
.32637 .14145 m .35318 .16727 L .35365 .14756 L .728 .968 0 r
F
.35914 .13726 m .35365 .14756 L .35318 .16727 L .436 .58 0 r
F
.37732 .14136 m .40418 .1669 L .40442 .14748 L .728 .968 0 r
F
.4249 .14715 m .42475 .16572 L .45173 .17176 L .92 .968 0 r
F
.4308 .13685 m .4249 .14715 L .42475 .16572 L .59 .621 0 r
F
.47569 .14707 m .47575 .16506 L .50256 .1711 L .919 .968 0 r
F
.52925 .14258 m .52303 .16735 L .52947 .15716 L .67 .571 0 r
F
.32409 .14585 m .31811 .17858 L .3234 .16845 L .311 .561 0 r
F
.17872 .12985 m .20201 .14635 L .17421 .14023 L .34 .954 0 r
F
.17872 .12985 m .20666 .13604 L .20201 .14635 L F
.1723 .14464 m .16854 .2029 L .19665 .20887 L .153 .97 0 r
F
.16854 .2029 m .19665 .20887 L .19204 .21883 L .15 .949 0 r
F
.17421 .14023 m .19741 .22599 L .20201 .14635 L .345 .97 0 r
F
.20666 .13604 m .20201 .14635 L .19741 .22599 L .169 .474 0 r
F
.25281 .14626 m .24546 .20868 L .25038 .19866 L .183 .513 0 r
F
.22518 .14014 m .25038 .19866 L .25281 .14626 L .345 .969 0 r
F
.27328 .14594 m .27227 .16997 L .29981 .17601 L .537 .969 0 r
F
.27833 .13562 m .27328 .14594 L .27227 .16997 L .292 .527 0 r
F
.32409 .14585 m .3234 .16845 L .35076 .17449 L .537 .969 0 r
F
.43067 .15548 m .45173 .17176 L .42475 .16572 L .905 .953 0 r
F
.45779 .14299 m .45173 .17176 L .45778 .16159 L .604 .636 0 r
F
.43067 .15548 m .45778 .16159 L .45173 .17176 L .905 .953 0 r
F
.69149 .129 m .71024 .14551 L .68411 .13938 L .954 .246 0 r
F
.69149 .129 m .71773 .13519 L .71024 .14551 L F
.68411 .13938 m .71087 .15693 L .71024 .14551 L .966 .249 0 r
F
.71773 .13519 m .71024 .14551 L .71087 .15693 L .738 .19 0 r
F
.73513 .1393 m .76177 .1557 L .76108 .14543 L .965 .249 0 r
F
.73513 .1393 m .72816 .15983 L .73576 .14959 L .744 .192 0 r
F
.68098 .1438 m .68153 .15494 L .70766 .16101 L .966 .44 0 r
F
.63009 .14389 m .63052 .15531 L .65682 .16138 L .966 .441 0 r
F
.6376 .145 m .65682 .16138 L .63052 .15531 L .953 .435 0 r
F
.6635 .13971 m .65682 .16138 L .66402 .15115 L .721 .329 0 r
F
.6376 .145 m .66402 .15115 L .65682 .16138 L .953 .435 0 r
F
.78955 .13478 m .78165 .1451 L .78218 .15252 L .759 .046 0 r
F
.1723 .14464 m .16407 .21292 L .16854 .2029 L .071 .449 0 r
F
.53855 .12776 m .55866 .1443 L .53202 .13816 L .954 .624 0 r
F
.53855 .12776 m .56532 .13396 L .55866 .1443 L F
.53202 .13816 m .55893 .15657 L .55866 .1443 L .967 .632 0 r
F
.56532 .13396 m .55866 .1443 L .55893 .15657 L .683 .446 0 r
F
.58306 .13808 m .60994 .1562 L .60954 .14421 L .966 .632 0 r
F
.63714 .13355 m .63009 .14389 L .63052 .15531 L .71 .324 0 r
F
.37732 .14136 m .37135 .17101 L .37695 .16083 L .445 .592 0 r
F
.58306 .13808 m .57664 .16034 L .58339 .15009 L .691 .452 0 r
F
.3854 .12652 m .40689 .14308 L .37973 .13693 L .906 .954 0 r
F
.3854 .12652 m .4127 .13273 L .40689 .14308 L F
.37973 .13693 m .40665 .16339 L .40689 .14308 L .92 .968 0 r
F
.4127 .13273 m .40689 .14308 L .40665 .16339 L .579 .61 0 r
F
.4308 .13685 m .45778 .16159 L .45779 .14299 L .919 .968 0 r
F
.52925 .14258 m .52947 .15716 L .55614 .16324 L .967 .824 0 r
F
.47833 .14267 m .4784 .15954 L .50525 .16561 L F
.48454 .13231 m .47833 .14267 L .4784 .15954 L .646 .551 0 r
F
.27734 .15974 m .29981 .17601 L .27227 .16997 L .528 .952 0 r
F
.30585 .14177 m .29981 .17601 L .30501 .16584 L .304 .548 0 r
F
.27734 .15974 m .30501 .16584 L .29981 .17601 L .528 .952 0 r
F
.78955 .13478 m .78218 .15252 L .79009 .14222 L .759 .046 0 r
F
.48463 .14924 m .50525 .16561 L .4784 .15954 L .953 .812 0 r
F
.51142 .13849 m .50525 .16561 L .51161 .15538 L .661 .563 0 r
F
.48463 .14924 m .51161 .15538 L .50525 .16561 L .953 .812 0 r
F
.23205 .12528 m .25492 .14186 L .22723 .13571 L .529 .954 0 r
F
.23205 .12528 m .25988 .1315 L .25492 .14186 L F
.22723 .13571 m .25304 .18269 L .25492 .14186 L .537 .969 0 r
F
.25988 .1315 m .25492 .14186 L .25304 .18269 L .284 .513 0 r
F
.27833 .13562 m .30501 .16584 L .30585 .14177 L .537 .969 0 r
F
.32637 .14145 m .32578 .1612 L .35318 .16727 L .728 .968 0 r
F
.33173 .13108 m .32637 .14145 L .32578 .1612 L .422 .561 0 r
F
.37732 .14136 m .37695 .16083 L .40418 .1669 L .728 .968 0 r
F
.73513 .1393 m .73576 .14959 L .76177 .1557 L .965 .249 0 r
F
.7461 .12442 m .76441 .14102 L .7384 .13486 L .954 .057 0 r
F
.7461 .12442 m .77223 .13065 L .76441 .14102 L F
.7384 .13486 m .76547 .15675 L .76441 .14102 L .965 .058 0 r
F
.77223 .13065 m .76441 .14102 L .76547 .15675 L .753 .045 0 r
F
.78955 .13478 m .81597 .14836 L .81538 .14094 L .964 .058 0 r
F
.68411 .13938 m .68468 .15082 L .71087 .15693 L .966 .249 0 r
F
.69208 .14047 m .71087 .15693 L .68468 .15082 L .953 .246 0 r
F
.71773 .13519 m .71087 .15693 L .71839 .14664 L .738 .19 0 r
F
.69208 .14047 m .71839 .14664 L .71087 .15693 L .953 .246 0 r
F
.16854 .2029 m .19204 .21883 L .16407 .21292 L .15 .949 0 r
F
.17421 .14023 m .1691 .22003 L .19741 .22599 L .345 .97 0 r
F
.17872 .12985 m .17421 .14023 L .1691 .22003 L .16 .449 0 r
F
.22518 .14014 m .22241 .19264 L .25038 .19866 L .345 .969 0 r
F
.22518 .14014 m .21763 .20273 L .22241 .19264 L .174 .49 0 r
F
.59282 .12318 m .6125 .1398 L .58597 .13363 L .954 .435 0 r
F
.59282 .12318 m .61947 .12941 L .6125 .1398 L F
.58597 .13363 m .61295 .15295 L .6125 .1398 L .966 .441 0 r
F
.61947 .12941 m .6125 .1398 L .61295 .15295 L .703 .32 0 r
F
.63714 .13355 m .66402 .15115 L .6635 .13971 L .966 .44 0 r
F
.4308 .13685 m .42475 .16572 L .43067 .15548 L .59 .621 0 r
F
.33116 .1509 m .35318 .16727 L .32578 .1612 L .716 .953 0 r
F
.35914 .13726 m .35318 .16727 L .35869 .15704 L .436 .58 0 r
F
.33116 .1509 m .35869 .15704 L .35318 .16727 L .716 .953 0 r
F
.69149 .129 m .68411 .13938 L .68468 .15082 L .728 .188 0 r
F
.58306 .13808 m .58339 .15009 L .60994 .1562 L .966 .632 0 r
F
.53202 .13816 m .53222 .15046 L .55893 .15657 L .967 .632 0 r
F
.53876 .1401 m .55893 .15657 L .53222 .15046 L .953 .623 0 r
F
.56532 .13396 m .55893 .15657 L .5656 .14628 L .683 .446 0 r
F
.53876 .1401 m .5656 .14628 L .55893 .15657 L .953 .623 0 r
F
.63714 .13355 m .63052 .15531 L .6376 .145 L .71 .324 0 r
F
.43933 .12193 m .4604 .13857 L .43334 .1324 L .954 .813 0 r
F
.43933 .12193 m .46652 .12818 L .4604 .13857 L F
.43334 .1324 m .46039 .1569 L .4604 .13857 L .967 .824 0 r
F
.46652 .12818 m .4604 .13857 L .46039 .1569 L .636 .542 0 r
F
.48454 .13231 m .51161 .15538 L .51142 .13849 L .967 .824 0 r
F
.53855 .12776 m .53202 .13816 L .53222 .15046 L .67 .438 0 r
F
.78955 .13478 m .79009 .14222 L .81597 .14836 L .964 .058 0 r
F
.28564 .12068 m .30809 .13735 L .28051 .13117 L .717 .954 0 r
F
.28564 .12068 m .31335 .12694 L .30809 .13735 L F
.28051 .13117 m .30719 .16347 L .30809 .13735 L .728 .968 0 r
F
.31335 .12694 m .30809 .13735 L .30719 .16347 L .412 .548 0 r
F
.33173 .13108 m .35869 .15704 L .35914 .13726 L .728 .968 0 r
F
.37973 .13693 m .37936 .15729 L .40665 .16339 L .92 .968 0 r
F
.3854 .12652 m .37973 .13693 L .37936 .15729 L .563 .592 0 r
F
.4308 .13685 m .43067 .15548 L .45778 .16159 L .919 .968 0 r
F
.27833 .13562 m .27227 .16997 L .27734 .15974 L .292 .527 0 r
F
.20666 .13604 m .19741 .22599 L .20211 .21595 L .169 .474 0 r
F
.17872 .12985 m .20211 .21595 L .20666 .13604 L .345 .969 0 r
F
.48454 .13231 m .4784 .15954 L .48463 .14924 L .646 .551 0 r
F
.22723 .13571 m .22509 .17662 L .25304 .18269 L .537 .969 0 r
F
.23205 .12528 m .22723 .13571 L .22509 .17662 L .271 .49 0 r
F
.27833 .13562 m .27734 .15974 L .30501 .16584 L .537 .969 0 r
F
.64736 .11857 m .6666 .13528 L .64019 .12908 L .954 .246 0 r
F
.64736 .11857 m .6739 .12484 L .6666 .13528 L F
.64019 .12908 m .66714 .14701 L .6666 .13528 L .966 .249 0 r
F
.6739 .12484 m .6666 .13528 L .66714 .14701 L .721 .186 0 r
F
.69149 .129 m .71839 .14664 L .71773 .13519 L .965 .249 0 r
F
.22241 .19264 m .24546 .20868 L .21763 .20273 L .338 .95 0 r
F
.22241 .19264 m .25038 .19866 L .24546 .20868 L F
.63714 .13355 m .6376 .145 L .66402 .15115 L .966 .44 0 r
F
.7384 .13486 m .73938 .15062 L .76547 .15675 L .965 .058 0 r
F
.7461 .12442 m .7384 .13486 L .73938 .15062 L .744 .045 0 r
F
.38505 .14694 m .40665 .16339 L .37936 .15729 L .905 .953 0 r
F
.4127 .13273 m .40665 .16339 L .41248 .15311 L .579 .61 0 r
F
.38505 .14694 m .41248 .15311 L .40665 .16339 L .905 .953 0 r
F
.69149 .129 m .68468 .15082 L .69208 .14047 L .728 .188 0 r
F
.74711 .14024 m .76547 .15675 L .73938 .15062 L .953 .057 0 r
F
.77223 .13065 m .76547 .15675 L .77333 .14643 L .753 .045 0 r
F
.74711 .14024 m .77333 .14643 L .76547 .15675 L .953 .057 0 r
F
.58597 .13363 m .58634 .14681 L .61295 .15295 L .966 .441 0 r
F
.59321 .1364 m .61295 .15295 L .58634 .14681 L .953 .435 0 r
F
.61947 .12941 m .61295 .15295 L .61994 .14261 L .703 .32 0 r
F
.59321 .1364 m .61994 .14261 L .61295 .15295 L .953 .435 0 r
F
.49353 .11732 m .51416 .13405 L .48722 .12784 L .954 .624 0 r
F
.49353 .11732 m .5206 .1236 L .51416 .13405 L F
.48722 .12784 m .51431 .14694 L .51416 .13405 L .967 .632 0 r
F
.5206 .1236 m .51416 .13405 L .51431 .14694 L .661 .432 0 r
F
.53855 .12776 m .5656 .14628 L .56532 .13396 L .966 .632 0 r
F
.59282 .12318 m .58597 .13363 L .58634 .14681 L .691 .315 0 r
F
.33173 .13108 m .32578 .1612 L .33116 .1509 L .422 .561 0 r
F
.53855 .12776 m .53222 .15046 L .53876 .1401 L .67 .438 0 r
F
.33949 .11607 m .36152 .13282 L .33405 .1266 L .906 .954 0 r
F
.33949 .11607 m .3671 .12235 L .36152 .13282 L F
.33405 .1266 m .361 .15579 L .36152 .13282 L .92 .968 0 r
F
.3671 .12235 m .36152 .13282 L .361 .15579 L .551 .58 0 r
F
.3854 .12652 m .41248 .15311 L .4127 .13273 L .919 .968 0 r
F
.43334 .1324 m .43323 .15077 L .46039 .1569 L .967 .824 0 r
F
.43933 .12193 m .43334 .1324 L .43323 .15077 L .621 .529 0 r
F
.48454 .13231 m .48463 .14924 L .51161 .15538 L .967 .824 0 r
F
.18525 .11481 m .20867 .13158 L .18067 .12536 L .529 .954 0 r
F
.18525 .11481 m .21339 .12111 L .20867 .13158 L F
.18067 .12536 m .20514 .19391 L .20867 .13158 L .537 .969 0 r
F
.21339 .12111 m .20867 .13158 L .20514 .19391 L .263 .474 0 r
F
.25988 .1315 m .25304 .18269 L .25803 .17247 L .284 .513 0 r
F
.23205 .12528 m .25803 .17247 L .25988 .1315 L .537 .969 0 r
F
.28051 .13117 m .27945 .15734 L .30719 .16347 L .728 .968 0 r
F
.28564 .12068 m .28051 .13117 L .27945 .15734 L .396 .527 0 r
F
.33173 .13108 m .33116 .1509 L .35869 .15704 L .728 .968 0 r
F
.43924 .14036 m .46039 .1569 L .43323 .15077 L .953 .812 0 r
F
.46652 .12818 m .46039 .1569 L .46654 .14657 L .636 .542 0 r
F
.43924 .14036 m .46654 .14657 L .46039 .1569 L .953 .812 0 r
F
.70217 .11395 m .72097 .13073 L .69468 .12451 L .954 .057 0 r
F
.70217 .11395 m .72859 .12025 L .72097 .13073 L F
.69468 .12451 m .72159 .14134 L .72097 .13073 L .965 .058 0 r
F
.72859 .12025 m .72097 .13073 L .72159 .14134 L .738 .044 0 r
F
.7461 .12442 m .77333 .14643 L .77223 .13065 L .964 .058 0 r
F
.69149 .129 m .69208 .14047 L .71839 .14664 L .965 .249 0 r
F
.64019 .12908 m .64066 .14084 L .66714 .14701 L .966 .249 0 r
F
.64785 .13038 m .66714 .14701 L .64066 .14084 L .953 .246 0 r
F
.6739 .12484 m .66714 .14701 L .67446 .13662 L .721 .186 0 r
F
.64785 .13038 m .67446 .13662 L .66714 .14701 L .953 .246 0 r
F
.17872 .12985 m .17365 .20992 L .20211 .21595 L .345 .969 0 r
F
.17872 .12985 m .1691 .22003 L .17365 .20992 L .16 .449 0 r
F
.548 .11269 m .56819 .1295 L .54137 .12326 L .954 .435 0 r
F
.548 .11269 m .57495 .119 L .56819 .1295 L F
.54137 .12326 m .56849 .14212 L .56819 .1295 L .966 .441 0 r
F
.57495 .119 m .56819 .1295 L .56849 .14212 L .683 .311 0 r
F
.59282 .12318 m .61994 .14261 L .61947 .12941 L .966 .44 0 r
F
.64736 .11857 m .64019 .12908 L .64066 .14084 L .71 .183 0 r
F
.53855 .12776 m .53876 .1401 L .5656 .14628 L .966 .632 0 r
F
.48722 .12784 m .4873 .14076 L .51431 .14694 L .967 .632 0 r
F
.49362 .13028 m .51431 .14694 L .4873 .14076 L .953 .623 0 r
F
.5206 .1236 m .51431 .14694 L .52077 .13653 L .661 .432 0 r
F
.49362 .13028 m .52077 .13653 L .51431 .14694 L .953 .623 0 r
F
.3854 .12652 m .37936 .15729 L .38505 .14694 L .563 .592 0 r
F
.7461 .12442 m .73938 .15062 L .74711 .14024 L .744 .045 0 r
F
.39361 .11143 m .41521 .12826 L .38785 .12202 L .954 .813 0 r
F
.39361 .11143 m .4211 .11775 L .41521 .12826 L F
.38785 .12202 m .415 .14838 L .41521 .12826 L .967 .824 0 r
F
.4211 .11775 m .41521 .12826 L .415 .14838 L .61 .519 0 r
F
.43933 .12193 m .46654 .14657 L .46652 .12818 L .967 .824 0 r
F
.59282 .12318 m .58634 .14681 L .59321 .1364 L .691 .315 0 r
F
.49353 .11732 m .48722 .12784 L .4873 .14076 L .646 .423 0 r
F
.23902 .11017 m .26202 .12702 L .23413 .12077 L .717 .954 0 r
F
.23902 .11017 m .26705 .11649 L .26202 .12702 L F
.23413 .12077 m .26007 .17067 L .26202 .12702 L .728 .968 0 r
F
.26705 .11649 m .26202 .12702 L .26007 .17067 L .386 .513 0 r
F
.31335 .12694 m .30719 .16347 L .31249 .15314 L .412 .548 0 r
F
.28564 .12068 m .31249 .15314 L .31335 .12694 L .728 .968 0 r
F
.33405 .1266 m .33339 .14963 L .361 .15579 L .92 .968 0 r
F
.33949 .11607 m .33405 .1266 L .33339 .14963 L .533 .561 0 r
F
.2846 .14694 m .30719 .16347 L .27945 .15734 L .716 .952 0 r
F
.2846 .14694 m .31249 .15314 L .30719 .16347 L F
.3854 .12652 m .38505 .14694 L .41248 .15311 L .919 .968 0 r
F
.69468 .12451 m .69523 .13513 L .72159 .14134 L .965 .058 0 r
F
.70275 .12461 m .72159 .14134 L .69523 .13513 L .953 .057 0 r
F
.72859 .12025 m .72159 .14134 L .72923 .13089 L .738 .044 0 r
F
.70275 .12461 m .72923 .13089 L .72159 .14134 L .953 .057 0 r
F
.18067 .12536 m .17674 .18781 L .20514 .19391 L .537 .969 0 r
F
.18525 .11481 m .18067 .12536 L .17674 .18781 L .249 .449 0 r
F
.23205 .12528 m .22994 .16633 L .25803 .17247 L .537 .969 0 r
F
.23205 .12528 m .22509 .17662 L .22994 .16633 L .271 .49 0 r
F
.22994 .16633 m .25304 .18269 L .22509 .17662 L .527 .951 0 r
F
.22994 .16633 m .25803 .17247 L .25304 .18269 L F
.60273 .10804 m .62249 .12493 L .59578 .11866 L .954 .246 0 r
F
.60273 .10804 m .62957 .11437 L .62249 .12493 L F
.59578 .11866 m .62294 .13757 L .62249 .12493 L .966 .249 0 r
F
.62957 .11437 m .62249 .12493 L .62294 .13757 L .703 .181 0 r
F
.64736 .11857 m .67446 .13662 L .6739 .12484 L .965 .249 0 r
F
.43933 .12193 m .43323 .15077 L .43924 .14036 L .621 .529 0 r
F
.70217 .11395 m .69468 .12451 L .69523 .13513 L .728 .044 0 r
F
.7461 .12442 m .74711 .14024 L .77333 .14643 L .964 .058 0 r
F
.54137 .12326 m .54159 .13591 L .56849 .14212 L .966 .441 0 r
F
.54824 .12538 m .56849 .14212 L .54159 .13591 L .953 .435 0 r
F
.57495 .119 m .56849 .14212 L .57527 .13166 L .683 .311 0 r
F
.54824 .12538 m .57527 .13166 L .56849 .14212 L .953 .435 0 r
F
.64736 .11857 m .64066 .14084 L .64785 .13038 L .71 .183 0 r
F
.59282 .12318 m .59321 .1364 L .61994 .14261 L .966 .44 0 r
F
.448 .10677 m .46916 .12368 L .44192 .11741 L .954 .624 0 r
F
.448 .10677 m .47538 .11312 L .46916 .12368 L F
.44192 .11741 m .46918 .13633 L .46916 .12368 L .967 .632 0 r
F
.47538 .11312 m .46916 .12368 L .46918 .13633 L .636 .416 0 r
F
.49353 .11732 m .52077 .13653 L .5206 .1236 L .966 .632 0 r
F
.33886 .13917 m .361 .15579 L .33339 .14963 L .905 .952 0 r
F
.3671 .12235 m .361 .15579 L .36661 .14541 L .551 .58 0 r
F
.33886 .13917 m .36661 .14541 L .361 .15579 L .905 .952 0 r
F
.548 .11269 m .54137 .12326 L .54159 .13591 L .67 .305 0 r
F
.49353 .11732 m .4873 .14076 L .49362 .13028 L .646 .423 0 r
F
.29306 .1055 m .31563 .12244 L .28785 .11616 L .906 .954 0 r
F
.29306 .1055 m .32098 .11186 L .31563 .12244 L F
.28785 .11616 m .31482 .14723 L .31563 .12244 L .92 .968 0 r
F
.32098 .11186 m .31563 .12244 L .31482 .14723 L .521 .548 0 r
F
.33949 .11607 m .36661 .14541 L .3671 .12235 L .919 .968 0 r
F
.38785 .12202 m .38752 .14218 L .415 .14838 L .967 .824 0 r
F
.39361 .11143 m .38785 .12202 L .38752 .14218 L .592 .505 0 r
F
.43933 .12193 m .43924 .14036 L .46654 .14657 L .967 .824 0 r
F
.21339 .12111 m .20514 .19391 L .20991 .18364 L .263 .474 0 r
F
.18525 .11481 m .20991 .18364 L .21339 .12111 L .537 .969 0 r
F
.23413 .12077 m .2319 .16451 L .26007 .17067 L .728 .968 0 r
F
.23902 .11017 m .23413 .12077 L .2319 .16451 L .368 .49 0 r
F
.28564 .12068 m .2846 .14694 L .31249 .15314 L .728 .968 0 r
F
.28564 .12068 m .27945 .15734 L .2846 .14694 L .396 .527 0 r
F
.65774 .10336 m .67705 .12033 L .65046 .11404 L .954 .057 0 r
F
.65774 .10336 m .68446 .10973 L .67705 .12033 L F
.65046 .11404 m .6779 .1379 L .67705 .12033 L .965 .058 0 r
F
.68446 .10973 m .67705 .12033 L .6779 .1379 L .721 .043 0 r
F
.70217 .11395 m .72923 .13089 L .72859 .12025 L .964 .058 0 r
F
.70217 .11395 m .69523 .13513 L .70275 .12461 L .728 .044 0 r
F
.64736 .11857 m .64785 .13038 L .67446 .13662 L .965 .249 0 r
F
.39331 .13166 m .415 .14838 L .38752 .14218 L .953 .812 0 r
F
.4211 .11775 m .415 .14838 L .42092 .13794 L .61 .519 0 r
F
.39331 .13166 m .42092 .13794 L .415 .14838 L .953 .812 0 r
F
.59578 .11866 m .59616 .13133 L .62294 .13757 L .966 .249 0 r
F
.60314 .12074 m .62294 .13757 L .59616 .13133 L .953 .246 0 r
F
.62957 .11437 m .62294 .13757 L .63005 .12706 L .703 .181 0 r
F
.60314 .12074 m .63005 .12706 L .62294 .13757 L .953 .246 0 r
F
.50267 .10209 m .52338 .11908 L .49625 .11278 L .954 .435 0 r
F
.50267 .10209 m .52992 .10846 L .52338 .11908 L F
.49625 .11278 m .52359 .13406 L .52338 .11908 L .966 .441 0 r
F
.52992 .10846 m .52338 .11908 L .52359 .13406 L .661 .301 0 r
F
.548 .11269 m .57527 .13166 L .57495 .119 L .966 .44 0 r
F
.60273 .10804 m .59578 .11866 L .59616 .13133 L .691 .178 0 r
F
.44192 .11741 m .44186 .13008 L .46918 .13633 L .967 .632 0 r
F
.44797 .11948 m .46918 .13633 L .44186 .13008 L .953 .623 0 r
F
.47538 .11312 m .46918 .13633 L .47542 .1258 L .636 .416 0 r
F
.44797 .11948 m .47542 .1258 L .46918 .13633 L .953 .623 0 r
F
.49353 .11732 m .49362 .13028 L .52077 .13653 L .966 .632 0 r
F
.548 .11269 m .54159 .13591 L .54824 .12538 L .67 .305 0 r
F
.34738 .10081 m .36951 .11783 L .34184 .11152 L .954 .813 0 r
F
.34738 .10081 m .37518 .1072 L .36951 .11783 L F
.34184 .11152 m .369 .14237 L .36951 .11783 L .967 .824 0 r
F
.37518 .1072 m .36951 .11783 L .369 .14237 L .58 .494 0 r
F
.39361 .11143 m .42092 .13794 L .4211 .11775 L .967 .824 0 r
F
.448 .10677 m .44192 .11741 L .44186 .13008 L .621 .406 0 r
F
.33949 .11607 m .33339 .14963 L .33886 .13917 L .533 .561 0 r
F
.19188 .09954 m .21543 .11658 L .18722 .11026 L .717 .954 0 r
F
.19188 .09954 m .22023 .10593 L .21543 .11658 L F
.18722 .11026 m .21204 .17802 L .21543 .11658 L .728 .968 0 r
F
.22023 .10593 m .21543 .11658 L .21204 .17802 L .356 .474 0 r
F
.26705 .11649 m .26007 .17067 L .26514 .16029 L .386 .513 0 r
F
.23902 .11017 m .26514 .16029 L .26705 .11649 L .728 .968 0 r
F
.28785 .11616 m .28688 .141 L .31482 .14723 L .92 .968 0 r
F
.29306 .1055 m .28785 .11616 L .28688 .141 L .501 .527 0 r
F
.33949 .11607 m .33886 .13917 L .36661 .14541 L .919 .968 0 r
F
.70217 .11395 m .70275 .12461 L .72923 .13089 L .964 .058 0 r
F
.18525 .11481 m .18136 .17747 L .20991 .18364 L .537 .969 0 r
F
.18525 .11481 m .17674 .18781 L .18136 .17747 L .249 .449 0 r
F
.5576 .09738 m .57787 .11446 L .55086 .10812 L .954 .246 0 r
F
.5576 .09738 m .58474 .10379 L .57787 .11446 L F
.55086 .10812 m .57823 .1283 L .57787 .11446 L .966 .249 0 r
F
.58474 .10379 m .57787 .11446 L .57823 .1283 L .683 .176 0 r
F
.60273 .10804 m .63005 .12706 L .62957 .11437 L .965 .249 0 r
F
.65046 .11404 m .65121 .13164 L .6779 .1379 L .965 .058 0 r
F
.65774 .10336 m .65046 .11404 L .65121 .13164 L .71 .043 0 r
F
.548 .11269 m .54824 .12538 L .57527 .13166 L .966 .44 0 r
F
.17365 .20992 m .19741 .22599 L .1691 .22003 L .337 .948 0 r
F
.17365 .20992 m .20211 .21595 L .19741 .22599 L F
.39361 .11143 m .38752 .14218 L .39331 .13166 L .592 .505 0 r
F
.60273 .10804 m .59616 .13133 L .60314 .12074 L .691 .178 0 r
F
.40196 .0961 m .42365 .1132 L .3961 .10686 L .954 .624 0 r
F
.40196 .0961 m .42965 .10252 L .42365 .1132 L F
.3961 .10686 m .42354 .12647 L .42365 .1132 L .967 .632 0 r
F
.42965 .10252 m .42365 .1132 L .42354 .12647 L .61 .399 0 r
F
.448 .10677 m .47542 .1258 L .47538 .11312 L .966 .632 0 r
F
.65853 .12102 m .6779 .1379 L .65121 .13164 L .953 .057 0 r
F
.68446 .10973 m .6779 .1379 L .68535 .12736 L .721 .043 0 r
F
.65853 .12102 m .68535 .12736 L .6779 .1379 L .953 .057 0 r
F
.49625 .11278 m .49637 .12778 L .52359 .13406 L .966 .441 0 r
F
.50281 .11714 m .52359 .13406 L .49637 .12778 L .953 .435 0 r
F
.52992 .10846 m .52359 .13406 L .53016 .12349 L .661 .301 0 r
F
.50281 .11714 m .53016 .12349 L .52359 .13406 L .953 .435 0 r
F
.50267 .10209 m .49625 .11278 L .49637 .12778 L .646 .295 0 r
F
.448 .10677 m .44186 .13008 L .44797 .11948 L .621 .406 0 r
F
.29212 .13043 m .31482 .14723 L .28688 .141 L .905 .952 0 r
F
.32098 .11186 m .31482 .14723 L .3202 .13673 L .521 .548 0 r
F
.29212 .13043 m .3202 .13673 L .31482 .14723 L .905 .952 0 r
F
.24611 .09482 m .26923 .11194 L .24114 .10559 L .906 .954 0 r
F
.24611 .09482 m .27435 .10124 L .26923 .11194 L F
.24114 .10559 m .26764 .14878 L .26923 .11194 L .92 .968 0 r
F
.27435 .10124 m .26923 .11194 L .26764 .14878 L .487 .513 0 r
F
.29306 .1055 m .3202 .13673 L .32098 .11186 L .919 .968 0 r
F
.34184 .11152 m .34118 .13611 L .369 .14237 L .967 .824 0 r
F
.34738 .10081 m .34184 .11152 L .34118 .13611 L .561 .478 0 r
F
.39361 .11143 m .39331 .13166 L .42092 .13794 L .967 .824 0 r
F
.18722 .11026 m .18343 .17182 L .21204 .17802 L .728 .968 0 r
F
.19188 .09954 m .18722 .11026 L .18343 .17182 L .338 .449 0 r
F
.23902 .11017 m .23683 .15406 L .26514 .16029 L .728 .968 0 r
F
.23902 .11017 m .2319 .16451 L .23683 .15406 L .368 .49 0 r
F
.61281 .09265 m .63263 .10981 L .60574 .10345 L .954 .057 0 r
F
.61281 .09265 m .63983 .09909 L .63263 .10981 L F
.60574 .10345 m .63301 .11962 L .63263 .10981 L .965 .058 0 r
F
.63983 .09909 m .63263 .10981 L .63301 .11962 L .703 .042 0 r
F
.65774 .10336 m .68535 .12736 L .68446 .10973 L .964 .058 0 r
F
.60273 .10804 m .60314 .12074 L .63005 .12706 L .965 .249 0 r
F
.23683 .15406 m .26007 .17067 L .2319 .16451 L .715 .951 0 r
F
.23683 .15406 m .26514 .16029 L .26007 .17067 L F
.55086 .10812 m .55114 .12199 L .57823 .1283 L .966 .249 0 r
F
.5579 .11129 m .57823 .1283 L .55114 .12199 L .953 .246 0 r
F
.58474 .10379 m .57823 .1283 L .58513 .11767 L .683 .176 0 r
F
.5579 .11129 m .58513 .11767 L .57823 .1283 L .953 .246 0 r
F
.45682 .09136 m .47807 .10855 L .45063 .10217 L .954 .435 0 r
F
.45682 .09136 m .48439 .09781 L .47807 .10855 L F
.45063 .10217 m .47813 .1256 L .47807 .10855 L .966 .441 0 r
F
.48439 .09781 m .47807 .10855 L .47813 .1256 L .636 .29 0 r
F
.50267 .10209 m .53016 .12349 L .52992 .10846 L .966 .44 0 r
F
.5576 .09738 m .55086 .10812 L .55114 .12199 L .67 .173 0 r
F
.448 .10677 m .44797 .11948 L .47542 .1258 L .966 .632 0 r
F
.3961 .10686 m .39591 .12015 L .42354 .12647 L .967 .632 0 r
F
.40178 .10943 m .42354 .12647 L .39591 .12015 L .953 .623 0 r
F
.42965 .10252 m .42354 .12647 L .42955 .11583 L .61 .399 0 r
F
.40178 .10943 m .42955 .11583 L .42354 .12647 L .953 .623 0 r
F
.34674 .12548 m .369 .14237 L .34118 .13611 L .952 .811 0 r
F
.37518 .1072 m .369 .14237 L .3747 .13182 L .58 .494 0 r
F
.34674 .12548 m .3747 .13182 L .369 .14237 L .952 .811 0 r
F
.30062 .09007 m .3233 .10729 L .29532 .1009 L .954 .813 0 r
F
.30062 .09007 m .32874 .09653 L .3233 .10729 L F
.29532 .1009 m .32257 .13074 L .3233 .10729 L .967 .824 0 r
F
.32874 .09653 m .3233 .10729 L .32257 .13074 L .548 .467 0 r
F
.34738 .10081 m .3747 .13182 L .37518 .1072 L .967 .824 0 r
F
.40196 .0961 m .3961 .10686 L .39591 .12015 L .592 .387 0 r
F
.65774 .10336 m .65121 .13164 L .65853 .12102 L .71 .043 0 r
F
.50267 .10209 m .49637 .12778 L .50281 .11714 L .646 .295 0 r
F
.22023 .10593 m .21204 .17802 L .21688 .16758 L .356 .474 0 r
F
.19188 .09954 m .21688 .16758 L .22023 .10593 L .728 .968 0 r
F
.29306 .1055 m .28688 .141 L .29212 .13043 L .501 .527 0 r
F
.18136 .17747 m .20514 .19391 L .17674 .18781 L .526 .949 0 r
F
.18136 .17747 m .20991 .18364 L .20514 .19391 L F
.60574 .10345 m .60606 .11327 L .63301 .11962 L .965 .058 0 r
F
.61315 .10251 m .63301 .11962 L .60606 .11327 L .953 .057 0 r
F
.63983 .09909 m .63301 .11962 L .64023 .10893 L .703 .042 0 r
F
.61315 .10251 m .64023 .10893 L .63301 .11962 L .953 .057 0 r
F
.24114 .10559 m .23931 .1425 L .26764 .14878 L .92 .968 0 r
F
.24611 .09482 m .24114 .10559 L .23931 .1425 L .465 .49 0 r
F
.29306 .1055 m .29212 .13043 L .3202 .13673 L .919 .968 0 r
F
.51195 .0866 m .53275 .10388 L .50543 .09747 L .954 .246 0 r
F
.51195 .0866 m .5394 .09308 L .53275 .10388 L F
.50543 .09747 m .533 .11921 L .53275 .10388 L .966 .249 0 r
F
.5394 .09308 m .53275 .10388 L .533 .11921 L .661 .17 0 r
F
.5576 .09738 m .58513 .11767 L .58474 .10379 L .965 .249 0 r
F
.61281 .09265 m .60574 .10345 L .60606 .11327 L .691 .041 0 r
F
.65774 .10336 m .65853 .12102 L .68535 .12736 L .964 .058 0 r
F
.35539 .0853 m .37763 .1026 L .34977 .09619 L .954 .624 0 r
F
.35539 .0853 m .3834 .0918 L .37763 .1026 L F
.34977 .09619 m .37733 .11853 L .37763 .1026 L .967 .632 0 r
F
.3834 .0918 m .37763 .1026 L .37733 .11853 L .58 .38 0 r
F
.40196 .0961 m .42955 .11583 L .42965 .10252 L .966 .632 0 r
F
.5576 .09738 m .55114 .12199 L .5579 .11129 L .67 .173 0 r
F
.45063 .10217 m .45059 .11926 L .47813 .1256 L .966 .441 0 r
F
.45682 .09136 m .45063 .10217 L .45059 .11926 L .621 .283 0 r
F
.50267 .10209 m .50281 .11714 L .53016 .12349 L .966 .44 0 r
F
.4568 .1085 m .47813 .1256 L .45059 .11926 L .953 .434 0 r
F
.48439 .09781 m .47813 .1256 L .48448 .11492 L .636 .29 0 r
F
.4568 .1085 m .48448 .11492 L .47813 .1256 L .953 .434 0 r
F
.19862 .08401 m .2223 .10133 L .19389 .0949 L .906 .954 0 r
F
.19862 .08401 m .22718 .09051 L .2223 .10133 L F
.19389 .0949 m .21949 .15359 L .2223 .10133 L .92 .968 0 r
F
.22718 .09051 m .2223 .10133 L .21949 .15359 L .45 .474 0 r
F
.27435 .10124 m .26764 .14878 L .27279 .1382 L .487 .513 0 r
F
.24611 .09482 m .27279 .1382 L .27435 .10124 L .919 .968 0 r
F
.40196 .0961 m .39591 .12015 L .40178 .10943 L .592 .387 0 r
F
.34738 .10081 m .34118 .13611 L .34674 .12548 L .561 .478 0 r
F
.29532 .1009 m .29444 .1244 L .32257 .13074 L .967 .824 0 r
F
.30062 .09007 m .29532 .1009 L .29444 .1244 L .527 .449 0 r
F
.34738 .10081 m .34674 .12548 L .3747 .13182 L .967 .824 0 r
F
.19188 .09954 m .18813 .16131 L .21688 .16758 L .728 .968 0 r
F
.19188 .09954 m .18343 .17182 L .18813 .16131 L .338 .449 0 r
F
.61281 .09265 m .60606 .11327 L .61315 .10251 L .691 .041 0 r
F
.56736 .08181 m .58771 .09918 L .56051 .09274 L .954 .057 0 r
F
.56736 .08181 m .59469 .08833 L .58771 .09918 L F
.56051 .09274 m .58811 .11308 L .58771 .09918 L .965 .058 0 r
F
.59469 .08833 m .58771 .09918 L .58811 .11308 L .683 .041 0 r
F
.61281 .09265 m .64023 .10893 L .63983 .09909 L .964 .058 0 r
F
.41045 .08051 m .43224 .0979 L .40449 .09145 L .954 .435 0 r
F
.41045 .08051 m .43833 .08704 L .43224 .0979 L F
.40449 .09145 m .43213 .11414 L .43224 .0979 L .966 .441 0 r
F
.43833 .08704 m .43224 .0979 L .43213 .11414 L .61 .278 0 r
F
.5576 .09738 m .5579 .11129 L .58513 .11767 L .965 .249 0 r
F
.45682 .09136 m .48448 .11492 L .48439 .09781 L .966 .44 0 r
F
.50543 .09747 m .50559 .11283 L .533 .11921 L .966 .249 0 r
F
.51195 .0866 m .50543 .09747 L .50559 .11283 L .646 .167 0 r
F
.51213 .10202 m .533 .11921 L .50559 .11283 L .953 .246 0 r
F
.5394 .09308 m .533 .11921 L .53967 .10847 L .661 .17 0 r
F
.51213 .10202 m .53967 .10847 L .533 .11921 L .953 .246 0 r
F
.29976 .11365 m .32257 .13074 L .29444 .1244 L .952 .811 0 r
F
.32874 .09653 m .32257 .13074 L .32803 .12006 L .548 .467 0 r
F
.29976 .11365 m .32803 .12006 L .32257 .13074 L .952 .811 0 r
F
.40196 .0961 m .40178 .10943 L .42955 .11583 L .966 .632 0 r
F
.25332 .07921 m .27656 .09662 L .24826 .09016 L .954 .813 0 r
F
.25332 .07921 m .28176 .08574 L .27656 .09662 L F
.24826 .09016 m .27502 .13363 L .27656 .09662 L .967 .824 0 r
F
.28176 .08574 m .27656 .09662 L .27502 .13363 L .513 .437 0 r
F
.30062 .09007 m .32803 .12006 L .32874 .09653 L .967 .824 0 r
F
.24431 .13185 m .26764 .14878 L .23931 .1425 L .904 .951 0 r
F
.24431 .13185 m .27279 .1382 L .26764 .14878 L F
.34977 .09619 m .34937 .11214 L .37733 .11853 L .967 .632 0 r
F
.35539 .0853 m .34977 .09619 L .34937 .11214 L .561 .367 0 r
F
.35501 .10131 m .37733 .11853 L .34937 .11214 L .953 .623 0 r
F
.3834 .0918 m .37733 .11853 L .38312 .10777 L .58 .38 0 r
F
.35501 .10131 m .38312 .10777 L .37733 .11853 L .953 .623 0 r
F
.45682 .09136 m .45059 .11926 L .4568 .1085 L .621 .283 0 r
F
.19389 .0949 m .19073 .14727 L .21949 .15359 L .92 .968 0 r
F
.19862 .08401 m .19389 .0949 L .19073 .14727 L .427 .449 0 r
F
.61281 .09265 m .61315 .10251 L .64023 .10893 L .964 .058 0 r
F
.24611 .09482 m .24431 .13185 L .27279 .1382 L .919 .968 0 r
F
.24611 .09482 m .23931 .1425 L .24431 .13185 L .465 .49 0 r
F
.56051 .09274 m .56082 .10667 L .58811 .11308 L .965 .058 0 r
F
.5677 .09579 m .58811 .11308 L .56082 .10667 L .953 .057 0 r
F
.59469 .08833 m .58811 .11308 L .59511 .10228 L .683 .041 0 r
F
.5677 .09579 m .59511 .10228 L .58811 .11308 L .953 .057 0 r
F
.46578 .0757 m .48712 .09317 L .45949 .08669 L .954 .246 0 r
F
.46578 .0757 m .49355 .08225 L .48712 .09317 L F
.45949 .08669 m .48723 .11118 L .48712 .09317 L .966 .249 0 r
F
.49355 .08225 m .48712 .09317 L .48723 .11118 L .636 .164 0 r
F
.51195 .0866 m .53967 .10847 L .5394 .09308 L .965 .249 0 r
F
.56736 .08181 m .56051 .09274 L .56082 .10667 L .67 .04 0 r
F
.30829 .07439 m .33109 .09188 L .3029 .08539 L .954 .624 0 r
F
.30829 .07439 m .33662 .08095 L .33109 .09188 L F
.3029 .08539 m .33045 .1137 L .33109 .09188 L .967 .632 0 r
F
.33662 .08095 m .33109 .09188 L .33045 .1137 L .548 .358 0 r
F
.35539 .0853 m .38312 .10777 L .3834 .0918 L .966 .632 0 r
F
.40449 .09145 m .40428 .10772 L .43213 .11414 L .966 .441 0 r
F
.41045 .08051 m .40449 .09145 L .40428 .10772 L .592 .27 0 r
F
.45682 .09136 m .4568 .1085 L .48448 .11492 L .966 .44 0 r
F
.41026 .09684 m .43213 .11414 L .40428 .10772 L .953 .434 0 r
F
.43833 .08704 m .43213 .11414 L .43825 .10333 L .61 .278 0 r
F
.41026 .09684 m .43825 .10333 L .43213 .11414 L .953 .434 0 r
F
.51195 .0866 m .50559 .11283 L .51213 .10202 L .646 .167 0 r
F
.30062 .09007 m .29444 .1244 L .29976 .11365 L .527 .449 0 r
F
.18813 .16131 m .21204 .17802 L .18343 .17182 L .714 .949 0 r
F
.18813 .16131 m .21688 .16758 L .21204 .17802 L F
.22718 .09051 m .21949 .15359 L .22441 .14295 L .45 .474 0 r
F
.19862 .08401 m .22441 .14295 L .22718 .09051 L .919 .968 0 r
F
.24826 .09016 m .24648 .12724 L .27502 .13363 L .967 .824 0 r
F
.25332 .07921 m .24826 .09016 L .24648 .12724 L .49 .417 0 r
F
.30062 .09007 m .29976 .11365 L .32803 .12006 L .967 .824 0 r
F
.35539 .0853 m .34937 .11214 L .35501 .10131 L .561 .367 0 r
F
.52139 .07086 m .54228 .08842 L .51477 .0819 L .954 .057 0 r
F
.52139 .07086 m .54904 .07745 L .54228 .08842 L F
.51477 .0819 m .54253 .10237 L .54228 .08842 L .965 .058 0 r
F
.54904 .07745 m .54228 .08842 L .54253 .10237 L .661 .04 0 r
F
.56736 .08181 m .59511 .10228 L .59469 .08833 L .964 .058 0 r
F
.36354 .06954 m .38589 .08713 L .35782 .0806 L .954 .435 0 r
F
.36354 .06954 m .39175 .07614 L .38589 .08713 L F
.35782 .0806 m .38558 .10546 L .38589 .08713 L .966 .441 0 r
F
.39175 .07614 m .38589 .08713 L .38558 .10546 L .58 .265 0 r
F
.41045 .08051 m .43825 .10333 L .43833 .08704 L .966 .44 0 r
F
.56736 .08181 m .56082 .10667 L .5677 .09579 L .67 .04 0 r
F
.45949 .08669 m .45948 .10473 L .48723 .11118 L .966 .249 0 r
F
.46578 .0757 m .45949 .08669 L .45948 .10473 L .621 .16 0 r
F
.51195 .0866 m .51213 .10202 L .53967 .10847 L .965 .249 0 r
F
.20548 .06822 m .22929 .08583 L .20067 .0793 L .954 .813 0 r
F
.20548 .06822 m .23425 .07483 L .22929 .08583 L F
.20067 .0793 m .22638 .14132 L .22929 .08583 L .967 .824 0 r
F
.23425 .07483 m .22929 .08583 L .22638 .14132 L .474 .404 0 r
F
.28176 .08574 m .27502 .13363 L .28025 .12287 L .513 .437 0 r
F
.25332 .07921 m .28025 .12287 L .28176 .08574 L .967 .824 0 r
F
.4658 .0938 m .48723 .11118 L .45948 .10473 L .953 .246 0 r
F
.49355 .08225 m .48723 .11118 L .49368 .10032 L .636 .164 0 r
F
.4658 .0938 m .49368 .10032 L .48723 .11118 L .953 .246 0 r
F
.3029 .08539 m .30212 .10725 L .33045 .1137 L .967 .632 0 r
F
.30829 .07439 m .3029 .08539 L .30212 .10725 L .527 .345 0 r
F
.35539 .0853 m .35501 .10131 L .38312 .10777 L .966 .632 0 r
F
.41045 .08051 m .40428 .10772 L .41026 .09684 L .592 .27 0 r
F
.19862 .08401 m .1955 .13655 L .22441 .14295 L .919 .968 0 r
F
.19862 .08401 m .19073 .14727 L .1955 .13655 L .427 .449 0 r
F
.30753 .09631 m .33045 .1137 L .30212 .10725 L .952 .623 0 r
F
.33662 .08095 m .33045 .1137 L .336 .10284 L .548 .358 0 r
F
.30753 .09631 m .336 .10284 L .33045 .1137 L .952 .623 0 r
F
.51477 .0819 m .51494 .09588 L .54253 .10237 L .965 .058 0 r
F
.52158 .08488 m .54253 .10237 L .51494 .09588 L .953 .057 0 r
F
.54904 .07745 m .54253 .10237 L .54932 .09144 L .661 .04 0 r
F
.52158 .08488 m .54932 .09144 L .54253 .10237 L .953 .057 0 r
F
.41907 .06467 m .44097 .08234 L .41302 .07579 L .954 .246 0 r
F
.41907 .06467 m .44716 .0713 L .44097 .08234 L F
.41302 .07579 m .44089 .09983 L .44097 .08234 L .966 .249 0 r
F
.44716 .0713 m .44097 .08234 L .44089 .09983 L .61 .157 0 r
F
.56736 .08181 m .5677 .09579 L .59511 .10228 L .964 .058 0 r
F
.46578 .0757 m .49368 .10032 L .49355 .08225 L .965 .249 0 r
F
.52139 .07086 m .51477 .0819 L .51494 .09588 L .646 .039 0 r
F
.26064 .06334 m .28401 .08104 L .2555 .07448 L .954 .624 0 r
F
.26064 .06334 m .2893 .06998 L .28401 .08104 L F
.2555 .07448 m .28247 .11941 L .28401 .08104 L .967 .632 0 r
F
.2893 .06998 m .28401 .08104 L .28247 .11941 L .513 .335 0 r
F
.30829 .07439 m .336 .10284 L .33662 .08095 L .966 .632 0 r
F
.25157 .11641 m .27502 .13363 L .24648 .12724 L .951 .81 0 r
F
.25157 .11641 m .28025 .12287 L .27502 .13363 L F
.35782 .0806 m .35739 .09897 L .38558 .10546 L .966 .441 0 r
F
.36354 .06954 m .35782 .0806 L .35739 .09897 L .561 .256 0 r
F
.41045 .08051 m .41026 .09684 L .43825 .10333 L .966 .44 0 r
F
.20067 .0793 m .19738 .1349 L .22638 .14132 L .967 .824 0 r
F
.20548 .06822 m .20067 .0793 L .19738 .1349 L .449 .383 0 r
F
.36313 .08797 m .38558 .10546 L .35739 .09897 L .953 .434 0 r
F
.39175 .07614 m .38558 .10546 L .39146 .09453 L .58 .265 0 r
F
.36313 .08797 m .39146 .09453 L .38558 .10546 L .953 .434 0 r
F
.25332 .07921 m .25157 .11641 L .28025 .12287 L .967 .824 0 r
F
.25332 .07921 m .24648 .12724 L .25157 .11641 L .49 .417 0 r
F
.1955 .13655 m .21949 .15359 L .19073 .14727 L .902 .95 0 r
F
.1955 .13655 m .22441 .14295 L .21949 .15359 L F
.46578 .0757 m .45948 .10473 L .4658 .0938 L .621 .16 0 r
F
.47489 .05977 m .49632 .07754 L .4685 .07095 L .954 .057 0 r
F
.47489 .05977 m .50285 .06644 L .49632 .07754 L F
.4685 .07095 m .49645 .09358 L .49632 .07754 L .965 .058 0 r
F
.50285 .06644 m .49632 .07754 L .49645 .09358 L .636 .038 0 r
F
.52139 .07086 m .54932 .09144 L .54904 .07745 L .964 .058 0 r
F
.31609 .05844 m .33901 .07623 L .31062 .06963 L .954 .435 0 r
F
.31609 .05844 m .34463 .06512 L .33901 .07623 L F
.31062 .06963 m .33839 .09844 L .33901 .07623 L .966 .441 0 r
F
.34463 .06512 m .33901 .07623 L .33839 .09844 L .548 .25 0 r
F
.36354 .06954 m .39146 .09453 L .39175 .07614 L .966 .44 0 r
F
.30829 .07439 m .30212 .10725 L .30753 .09631 L .527 .345 0 r
F
.52139 .07086 m .51494 .09588 L .52158 .08488 L .646 .039 0 r
F
.41302 .07579 m .41283 .0933 L .44089 .09983 L .966 .249 0 r
F
.41907 .06467 m .41302 .07579 L .41283 .0933 L .592 .153 0 r
F
.46578 .0757 m .4658 .0938 L .49368 .10032 L .965 .249 0 r
F
.23425 .07483 m .22638 .14132 L .23138 .1305 L .474 .404 0 r
F
.20548 .06822 m .23138 .1305 L .23425 .07483 L .967 .824 0 r
F
.41891 .08224 m .44089 .09983 L .41283 .0933 L .953 .246 0 r
F
.44716 .0713 m .44089 .09983 L .44711 .08884 L .61 .157 0 r
F
.41891 .08224 m .44711 .08884 L .44089 .09983 L .953 .246 0 r
F
.2555 .07448 m .25371 .11292 L .28247 .11941 L .967 .632 0 r
F
.26064 .06334 m .2555 .07448 L .25371 .11292 L .49 .32 0 r
F
.30829 .07439 m .30753 .09631 L .336 .10284 L .966 .632 0 r
F
.36354 .06954 m .35739 .09897 L .36313 .08797 L .561 .256 0 r
F
.37183 .05351 m .39428 .07139 L .36601 .06476 L .954 .246 0 r
F
.37183 .05351 m .40024 .06022 L .39428 .07139 L F
.36601 .06476 m .39398 .09128 L .39428 .07139 L .966 .249 0 r
F
.40024 .06022 m .39428 .07139 L .39398 .09128 L .58 .15 0 r
F
.52139 .07086 m .52158 .08488 L .54932 .09144 L .964 .058 0 r
F
.41907 .06467 m .44711 .08884 L .44716 .0713 L .965 .249 0 r
F
.4685 .07095 m .46852 .08702 L .49645 .09358 L .965 .058 0 r
F
.47489 .05977 m .4685 .07095 L .46852 .08702 L .621 .037 0 r
F
.47494 .0759 m .49645 .09358 L .46852 .08702 L .953 .057 0 r
F
.50285 .06644 m .49645 .09358 L .50301 .08254 L .636 .038 0 r
F
.47494 .0759 m .50301 .08254 L .49645 .09358 L .953 .057 0 r
F
.21244 .05217 m .23639 .07008 L .20755 .06343 L .954 .624 0 r
F
.21244 .05217 m .24143 .05889 L .23639 .07008 L F
.20548 .06822 m .20224 .124 L .23138 .1305 L .967 .824 0 r
F
.20224 .124 m .23138 .1305 L .22638 .14132 L .95 .809 0 r
F
.20755 .06343 m .23173 .16136 L .23639 .07008 L .967 .632 0 r
F
.24143 .05889 m .23639 .07008 L .23173 .16136 L .474 .31 0 r
F
.2893 .06998 m .28247 .11941 L .2878 .10848 L .513 .335 0 r
F
.26064 .06334 m .2878 .10848 L .2893 .06998 L .966 .632 0 r
F
.31062 .06963 m .30986 .09188 L .33839 .09844 L .966 .441 0 r
F
.31609 .05844 m .31062 .06963 L .30986 .09188 L .527 .24 0 r
F
.36354 .06954 m .36313 .08797 L .39146 .09453 L .966 .44 0 r
F
.20548 .06822 m .19738 .1349 L .20224 .124 L .449 .383 0 r
F
.41907 .06467 m .41283 .0933 L .41891 .08224 L .592 .153 0 r
F
.31536 .08077 m .33839 .09844 L .30986 .09188 L .952 .434 0 r
F
.34463 .06512 m .33839 .09844 L .34404 .0874 L .548 .25 0 r
F
.31536 .08077 m .34404 .0874 L .33839 .09844 L .952 .434 0 r
F
.42785 .04856 m .44984 .06653 L .42169 .05986 L .954 .057 0 r
F
.42785 .04856 m .45614 .0553 L .44984 .06653 L F
.42169 .05986 m .44979 .0838 L .44984 .06653 L .965 .058 0 r
F
.45614 .0553 m .44984 .06653 L .44979 .0838 L .61 .037 0 r
F
.47489 .05977 m .50301 .08254 L .50285 .06644 L .964 .058 0 r
F
.26809 .04721 m .29158 .06521 L .26287 .05853 L .954 .435 0 r
F
.26809 .04721 m .29696 .05396 L .29158 .06521 L F
.26287 .05853 m .29009 .10405 L .29158 .06521 L .966 .441 0 r
F
.29696 .05396 m .29158 .06521 L .29009 .10405 L .513 .234 0 r
F
.31609 .05844 m .34404 .0874 L .34463 .06512 L .966 .44 0 r
F
.36601 .06476 m .36558 .08469 L .39398 .09128 L .966 .249 0 r
F
.37183 .05351 m .36601 .06476 L .36558 .08469 L .561 .145 0 r
F
.41907 .06467 m .41891 .08224 L .44711 .08884 L .965 .249 0 r
F
.25889 .10191 m .28247 .11941 L .25371 .11292 L .951 .622 0 r
F
.25889 .10191 m .2878 .10848 L .28247 .11941 L F
.47489 .05977 m .46852 .08702 L .47494 .0759 L .621 .037 0 r
F
.20224 .124 m .22638 .14132 L .19738 .1349 L .95 .809 0 r
F
.20755 .06343 m .20228 .1549 L .23173 .16136 L .967 .632 0 r
F
.21244 .05217 m .20755 .06343 L .20228 .1549 L .449 .294 0 r
F
.26064 .06334 m .25889 .10191 L .2878 .10848 L .966 .632 0 r
F
.26064 .06334 m .25371 .11292 L .25889 .10191 L .49 .32 0 r
F
.37142 .07351 m .39398 .09128 L .36558 .08469 L .953 .246 0 r
F
.40024 .06022 m .39398 .09128 L .39996 .08018 L .58 .15 0 r
F
.37142 .07351 m .39996 .08018 L .39398 .09128 L .953 .246 0 r
F
.32403 .04222 m .34706 .06031 L .31846 .0536 L .954 .246 0 r
F
.32403 .04222 m .35277 .04901 L .34706 .06031 L F
.31846 .0536 m .34653 .08056 L .34706 .06031 L .966 .249 0 r
F
.35277 .04901 m .34706 .06031 L .34653 .08056 L .548 .141 0 r
F
.37183 .05351 m .39996 .08018 L .40024 .06022 L .965 .249 0 r
F
.31609 .05844 m .30986 .09188 L .31536 .08077 L .527 .24 0 r
F
.42169 .05986 m .42153 .07717 L .44979 .0838 L .965 .058 0 r
F
.42785 .04856 m .42169 .05986 L .42153 .07717 L .592 .036 0 r
F
.47489 .05977 m .47494 .0759 L .50301 .08254 L .964 .058 0 r
F
.42771 .06592 m .44979 .0838 L .42153 .07717 L .953 .057 0 r
F
.45614 .0553 m .44979 .0838 L .45612 .07263 L .61 .037 0 r
F
.42771 .06592 m .45612 .07263 L .44979 .0838 L .953 .057 0 r
F
.24143 .05889 m .23173 .16136 L .23685 .15048 L .474 .31 0 r
F
.21244 .05217 m .23685 .15048 L .24143 .05889 L .966 .632 0 r
F
.26287 .05853 m .26111 .09745 L .29009 .10405 L .966 .441 0 r
F
.26809 .04721 m .26287 .05853 L .26111 .09745 L .49 .223 0 r
F
.31609 .05844 m .31536 .08077 L .34404 .0874 L .966 .44 0 r
F
.37183 .05351 m .36558 .08469 L .37142 .07351 L .561 .145 0 r
F
.38025 .03721 m .40282 .05539 L .37434 .04865 L .954 .057 0 r
F
.38025 .03721 m .40887 .04404 L .40282 .05539 L F
.37434 .04865 m .40259 .07213 L .40282 .05539 L .965 .058 0 r
F
.40887 .04404 m .40282 .05539 L .40259 .07213 L .58 .035 0 r
F
.42785 .04856 m .45612 .07263 L .45614 .0553 L .964 .058 0 r
F
.21953 .03585 m .24361 .05406 L .21456 .0473 L .954 .435 0 r
F
.21953 .03585 m .24874 .04268 L .24361 .05406 L F
.21456 .0473 m .24052 .11639 L .24361 .05406 L .966 .441 0 r
F
.24874 .04268 m .24361 .05406 L .24052 .11639 L .474 .216 0 r
F
.29696 .05396 m .29009 .10405 L .2955 .09294 L .513 .234 0 r
F
.26809 .04721 m .2955 .09294 L .29696 .05396 L .966 .44 0 r
F
.31846 .0536 m .3178 .07389 L .34653 .08056 L .966 .249 0 r
F
.32403 .04222 m .31846 .0536 L .3178 .07389 L .527 .136 0 r
F
.37183 .05351 m .37142 .07351 L .39996 .08018 L .965 .249 0 r
F
.42785 .04856 m .42153 .07717 L .42771 .06592 L .592 .036 0 r
F
.21244 .05217 m .20724 .14395 L .23685 .15048 L .966 .632 0 r
F
.21244 .05217 m .20228 .1549 L .20724 .14395 L .449 .294 0 r
F
.32339 .06258 m .34653 .08056 L .3178 .07389 L .953 .246 0 r
F
.35277 .04901 m .34653 .08056 L .35227 .06933 L .548 .141 0 r
F
.32339 .06258 m .35227 .06933 L .34653 .08056 L .953 .246 0 r
F
.27567 .03081 m .29928 .04911 L .27035 .04232 L .954 .246 0 r
F
.27567 .03081 m .30475 .03767 L .29928 .04911 L F
.27035 .04232 m .29809 .08158 L .29928 .04911 L .966 .249 0 r
F
.30475 .03767 m .29928 .04911 L .29809 .08158 L .513 .132 0 r
F
.32403 .04222 m .35227 .06933 L .35277 .04901 L .965 .249 0 r
F
.37434 .04865 m .37401 .06542 L .40259 .07213 L .965 .058 0 r
F
.38025 .03721 m .37434 .04865 L .37401 .06542 L .561 .034 0 r
F
.42785 .04856 m .42771 .06592 L .45612 .07263 L .964 .058 0 r
F
.26637 .08626 m .29009 .10405 L .26111 .09745 L .951 .434 0 r
F
.26637 .08626 m .2955 .09294 L .29009 .10405 L F
.37994 .05404 m .40259 .07213 L .37401 .06542 L .953 .057 0 r
F
.40887 .04404 m .40259 .07213 L .40867 .06083 L .58 .035 0 r
F
.37994 .05404 m .40867 .06083 L .40259 .07213 L .953 .057 0 r
F
.21456 .0473 m .21104 .10976 L .24052 .11639 L .966 .441 0 r
F
.21953 .03585 m .21456 .0473 L .21104 .10976 L .449 .205 0 r
F
.26809 .04721 m .26637 .08626 L .2955 .09294 L .966 .44 0 r
F
.26809 .04721 m .26111 .09745 L .26637 .08626 L .49 .223 0 r
F
.32403 .04222 m .3178 .07389 L .32339 .06258 L .527 .136 0 r
F
.3321 .02573 m .35524 .04413 L .32644 .03731 L .954 .057 0 r
F
.3321 .02573 m .36106 .03264 L .35524 .04413 L F
.32644 .03731 m .3547 .06685 L .35524 .04413 L .965 .058 0 r
F
.36106 .03264 m .35524 .04413 L .3547 .06685 L .548 .033 0 r
F
.38025 .03721 m .40867 .06083 L .40887 .04404 L .964 .058 0 r
F
.24874 .04268 m .24052 .11639 L .2457 .10522 L .474 .216 0 r
F
.21953 .03585 m .2457 .10522 L .24874 .04268 L .966 .44 0 r
F
.27035 .04232 m .26893 .07486 L .29809 .08158 L .966 .249 0 r
F
.27567 .03081 m .27035 .04232 L .26893 .07486 L .49 .126 0 r
F
.32403 .04222 m .32339 .06258 L .35227 .06933 L .965 .249 0 r
F
.38025 .03721 m .37401 .06542 L .37994 .05404 L .561 .034 0 r
F
.22674 .01925 m .25095 .03777 L .22168 .0309 L .954 .246 0 r
F
.22674 .01925 m .25617 .0262 L .25095 .03777 L F
.22168 .0309 m .24858 .08713 L .25095 .03777 L .966 .249 0 r
F
.25617 .0262 m .25095 .03777 L .24858 .08713 L .474 .122 0 r
F
.30475 .03767 m .29809 .08158 L .30359 .07026 L .513 .132 0 r
F
.27567 .03081 m .30359 .07026 L .30475 .03767 L .965 .249 0 r
F
.32644 .03731 m .32573 .06007 L .3547 .06685 L .965 .058 0 r
F
.3321 .02573 m .32644 .03731 L .32573 .06007 L .527 .032 0 r
F
.38025 .03721 m .37994 .05404 L .40867 .06083 L .964 .058 0 r
F
.21953 .03585 m .21607 .09852 L .2457 .10522 L .966 .44 0 r
F
.21953 .03585 m .21104 .10976 L .21607 .09852 L .449 .205 0 r
F
.27428 .06346 m .29809 .08158 L .26893 .07486 L .952 .246 0 r
F
.27428 .06346 m .30359 .07026 L .29809 .08158 L F
.33142 .04857 m .3547 .06685 L .32573 .06007 L .952 .057 0 r
F
.36106 .03264 m .3547 .06685 L .36054 .05543 L .548 .033 0 r
F
.33142 .04857 m .36054 .05543 L .3547 .06685 L .952 .057 0 r
F
.28337 .01412 m .30712 .03273 L .27797 .02583 L .954 .057 0 r
F
.28337 .01412 m .31268 .02111 L .30712 .03273 L F
.27797 .02583 m .30573 .07195 L .30712 .03273 L .965 .058 0 r
F
.31268 .02111 m .30712 .03273 L .30573 .07195 L .513 .031 0 r
F
.3321 .02573 m .36054 .05543 L .36106 .03264 L .964 .058 0 r
F
.22168 .0309 m .21897 .08036 L .24858 .08713 L .966 .249 0 r
F
.22674 .01925 m .22168 .0309 L .21897 .08036 L .449 .116 0 r
F
.27567 .03081 m .27428 .06346 L .30359 .07026 L .965 .249 0 r
F
.27567 .03081 m .26893 .07486 L .27428 .06346 L .49 .126 0 r
F
.20724 .14395 m .23173 .16136 L .20228 .1549 L .947 .619 0 r
F
.20724 .14395 m .23685 .15048 L .23173 .16136 L F
.3321 .02573 m .32573 .06007 L .33142 .04857 L .527 .032 0 r
F
.21607 .09852 m .24052 .11639 L .21104 .10976 L .949 .433 0 r
F
.21607 .09852 m .2457 .10522 L .24052 .11639 L F
.25617 .0262 m .24858 .08713 L .25384 .07573 L .474 .122 0 r
F
.22674 .01925 m .25384 .07573 L .25617 .0262 L .965 .249 0 r
F
.27797 .02583 m .27632 .06512 L .30573 .07195 L .965 .058 0 r
F
.28337 .01412 m .27797 .02583 L .27632 .06512 L .49 .029 0 r
F
.3321 .02573 m .33142 .04857 L .36054 .05543 L .964 .058 0 r
F
.23407 .00237 m .25842 .0212 L .22892 .01422 L .954 .057 0 r
F
.23407 .00237 m .26372 .00944 L .25842 .0212 L F
.22892 .01422 m .25662 .05995 L .25842 .0212 L .965 .058 0 r
F
.26372 .00944 m .25842 .0212 L .25662 .05995 L .474 .028 0 r
F
.31268 .02111 m .30573 .07195 L .31134 .06045 L .513 .031 0 r
F
.28337 .01412 m .31134 .06045 L .31268 .02111 L .964 .058 0 r
F
.22674 .01925 m .22407 .06887 L .25384 .07573 L .965 .249 0 r
F
.22674 .01925 m .21897 .08036 L .22407 .06887 L .449 .116 0 r
F
.22407 .06887 m .24858 .08713 L .21897 .08036 L .95 .245 0 r
F
.22407 .06887 m .25384 .07573 L .24858 .08713 L F
.28176 .05355 m .30573 .07195 L .27632 .06512 L .951 .057 0 r
F
.28176 .05355 m .31134 .06045 L .30573 .07195 L F
.22892 .01422 m .22685 .05304 L .25662 .05995 L .965 .058 0 r
F
.23407 .00237 m .22892 .01422 L .22685 .05304 L .449 .027 0 r
F
.28337 .01412 m .28176 .05355 L .31134 .06045 L .964 .058 0 r
F
.28337 .01412 m .27632 .06512 L .28176 .05355 L .49 .029 0 r
F
.26372 .00944 m .25662 .05995 L .26195 .04831 L .474 .028 0 r
F
.23407 .00237 m .26195 .04831 L .26372 .00944 L .964 .058 0 r
F
.23203 .04132 m .25662 .05995 L .22685 .05304 L .951 .057 0 r
F
.23203 .04132 m .26195 .04831 L .25662 .05995 L F
.23407 .00237 m .23203 .04132 L .26195 .04831 L .964 .058 0 r
F
.23407 .00237 m .22685 .05304 L .23203 .04132 L .449 .027 0 r
F
.4 g
.22084 .06025 m
.0481 .45253 L
s
.21745 .12221 m
.04348 .50612 L
s
.21397 .18593 m
.03875 .56092 L
s
.21038 .2515 m
.03391 .61698 L
s
.20669 .319 m
.02896 .67433 L
s
.20289 .38852 m
.0239 .73303 L
s
.19897 .46015 m
.01871 .79312 L
s
.19494 .53398 m
.01341 .85466 L
s
.19077 .61012 m
.00797 .91769 L
s
.05262 .40011 m
0 1.01003 L
s
0 g
.22414 0 m
.92954 .16815 L
s
.24912 .00177 m
.24872 .01005 L
s
gsave
.24964 -0.00888 -76.5743 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1960) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.29821 .01348 m
.2979 .02176 L
s
gsave
.29861 .00282 -76.7612 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1970) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34671 .02505 m
.34649 .03334 L
s
gsave
.34699 .01439 -76.945 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1980) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.39465 .03649 m
.39453 .04478 L
s
gsave
.39481 .02582 -77.1257 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.44203 .04779 m
.442 .05608 L
s
gsave
.44208 .03713 -77.3033 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1990) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.48887 .05896 m
.48892 .06726 L
s
gsave
.4888 .0483 -77.478 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1991) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53517 .07001 m
.53531 .0783 L
s
gsave
.53499 .05935 -77.6498 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1992) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58094 .08093 m
.58116 .08922 L
s
gsave
.58065 .07028 -77.8188 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1993) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.62619 .09173 m
.6265 .10002 L
s
gsave
.62579 .08108 -77.9851 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1994) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.67093 .10241 m
.67132 .11069 L
s
gsave
.67043 .09176 -78.1487 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.71517 .11296 m
.71564 .12124 L
s
gsave
.71456 .10232 -78.3097 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1996) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75891 .1234 m
.75946 .13168 L
s
gsave
.7582 .11277 -78.4682 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.80217 .13373 m
.8028 .142 L
s
gsave
.80136 .1231 -78.6241 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1998) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84495 .14394 m
.84566 .1522 L
s
gsave
.84404 .13332 -78.7777 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88727 .15404 m
.88805 .16229 L
s
gsave
.88626 .14342 -78.9288 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2000) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.18462 .72262 L
s
.22414 0 m
.23134 .00172 L
s
[(0)] .20973 -0.00343 1 .23837 Mshowa
.21572 .15384 m
.22296 .15543 L
s
[(50)] .20126 .15066 1 .2197 Mshowa
.20669 .319 m
.21395 .32045 L
s
[(100)] .19217 .3161 1 .19969 Mshowa
.19697 .49678 m
.20426 .49808 L
s
[(150)] .18239 .49418 1 .1782 Mshowa
.18648 .68868 m
.19379 .68981 L
s
[(200)] .17185 .68641 1 .15506 Mshowa
.125 Mabswid
.2225 .02992 m
.22683 .03093 L
s
.22084 .06025 m
.22517 .06125 L
s
.21916 .09101 m
.22349 .092 L
s
.21745 .12221 m
.22179 .12318 L
s
.21397 .18593 m
.21831 .18687 L
s
.21219 .21848 m
.21654 .2194 L
s
.21038 .2515 m
.21473 .25241 L
s
.20855 .28501 m
.2129 .28589 L
s
.20481 .3535 m
.20917 .35436 L
s
.20289 .38852 m
.20725 .38936 L
s
.20095 .42406 m
.20531 .42488 L
s
.19897 .46015 m
.20334 .46094 L
s
.19494 .53398 m
.19931 .53474 L
s
.19287 .57175 m
.19725 .57249 L
s
.19077 .61012 m
.19516 .61084 L
s
.18864 .64909 m
.19303 .64979 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{900, 976.625},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000>40003d2000`400?l00000o`00003oo`3ooooo
0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00
o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon7
0?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0oooo
o`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?oo
ool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo
003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0oooo0`3oool50000
0080oooo0`0000050?ooo`<00000103oool300000?l0ooooo`3ooom[0?ooo`00o`3oool50?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool0o`3ooooo0?ooofP0oooo003o0?ooo`D0oooo00<000000?oo
o`3oool01P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0o`3ooooo0?ooofP0oooo003o0?ooo`D0oooo00<000000?ooo`3oool00`3oool4
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
o`3ooooo0?ooofX0oooo003o0?ooo`D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo100000030?ooo`050000003oool0oooo0?ooo`000000o`3ooooo0?ooofX0
oooo003o0?ooo`D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000?l0ooooo`3ooomZ0?oo
o`00o`3oool50?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000003o0?ooool0ooooJP3oool0
0?l0oooo0`3oool3000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000003o0?ooool0ooooJP3oool00>T0oooo0`00000H
0?ooo`030000003oool0oooo00<0oooo0`0000050?ooo`<000000`3oool300000?l0ooooo`3ooom[
0?ooo`00j03oool01@000000oooo0?ooo`3oool0000003h0oooo1@0000020?ooo`<000001P3oool0
0`000000oooo0?ooo`030?ooo`<00000o`3ooooo0?oood80oooo003X0?ooo`050000003oool0oooo
0?ooo`000000@03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000?l0ooooo`3ooom10?ooo`00j03oool0
1@000000oooo0?ooo`3oool000000400oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000003o0?ooool0oooo
@@3oool00>P0oooo00D000000?ooo`3oool0oooo000000100?ooo`030000003oool0oooo00<0oooo
100000050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3o0?ooool0
oooo?`3oool00>P0oooo00D000000?ooo`3oool0oooo000000100?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`3o0?ooool0oooo?`3oool00;40oooo1@0000030?ooo`<00000103oool30000
00<0oooo1P0000020?ooo`<0000000<0oooo0000000000000P0000020?ooo`8000000P3oool30000
00030?ooo`000000oooo0080oooo0`3o3`000`3oool000000?ooo`020?ooo`030000003oool0oooo
03h0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0?l0ooooo`3ooolo0?ooo`00/`3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool5
0?l?00050000003oool0oooo0?ooo`0000003@3oool4000002l0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0?l0ooooo`3ooolo0?ooo`00/`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`L0o`l00`00000>0?ooo`030000003oool0oooo00@000003P3oool0
0`000000oooo0?ooo`0I0?ooo`<00000103oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000o`3ooooo0?oood40
oooo002c0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool5000000@0oooo
00<000000?ooo`3oool00`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool70?l?0100oooo0P0000060?ooo`@000002P3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo0`0000030?ooo`D000000`3oool30000
0?l0ooooo`3ooom20?ooo`00/`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0200000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`070?l?0100oooo0P0000070?ooo`<0mPh0100000060?ooo`030000003oool0oooo0?l0ooooo`3o
oomd0?ooo`00/`3oool00`000000oooo0?ooo`030?ooo`<00000103oool3000000D0oooo00<00000
0?ooo`3oool00P3oool400000080oooo00<000000?ooo`0000000P0000040?ooo`@000000`3oool5
0?l?00`0oooo1@0000000`3oool000000?ooo`060?ooo`L0mPh0100000020?ooo`030000003oool0
oooo0440oooo1@0000020?ooo`<000001@3oool3000000@0oooo0`00003o0?ooool0oooo6P3oool0
0;<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0080oooo0`3o3`0A0?ooo`@000001@3oool00`1b1P00mPh00?H>00090?H>00D00000@`3oool00`00
0000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo0?l0ooooo`3ooolG0?ooo`00/@3oool500000180oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`040000003oool0oooo000000H0oooo00<0
LPH00?H>003f3P002P3f3P0010000000mPh00?H>003f3P04000003l0oooo00<000000?ooo`3oool0
1P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0o`3ooooo0?oooaL0oooo00360?ooo`<000005@3oool2000001L0oooo00@000000?ooo`3o
ool000001@3oool2078600`0mPh000<000000?H>003f3P001@3f3P04000000030?H>003oool0oooo
03P0oooo00<000000?ooo`3oool00`3oool400000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000o`3ooooo0?oooaT0oooo003g0?ooo`040000003oool0
oooo000000D0oooo0P1b1P0<0?H>00030000003f3P00mPh000T0mPh01000000g0?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool01@000000oooo
0?ooo`3oool000000?l0ooooo`3ooolI0?ooo`00mP3oool01@000000oooo0?ooo`3oool0000000@0
oooo0`1b1P0I0?H>00<0oooo1@00000b0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000?l0ooooo`3ooolI0?ooo`00mP3oool010000000oooo0?ooo`0000050?ooo`<0LPH06@3f
3P080?ooo`@00000;P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?oo
ool0oooo6@3oool00?D0oooo00D000000?ooo`3oool0oooo000000040?ooo`@0LPH06@3f3P0<0?oo
o`@000003@3oool00`000000oooo0?ooo`0H0?ooo`<00000103oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
o`3ooooo0?oooaT0oooo003e0?ooo`050000003oool0oooo0?ooo`000000103oool4078601T0mPh0
403oool4000000030?H>003oool0oooo00H0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`030?ooo`<00000103oool3000000@0oooo0`00003o0?ooool0oooo6P3oool00;80oooo1000
00040?ooo`030000003oool0000000@0oooo0`0000040?ooo`<0000000@0oooo0000003oool0oooo
0`0000020?ooo`<000000P3oool2000000<0oooo0`3o@P0C0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool4078601T0mPh0403oool40?H>00@0000000<0mPh00?ooo`3oool0
0P3oool00`000000oooo0?ooo`3o0?ooool0ooooB`3oool00;80oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`D0od804P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo101b1P0I0?H>00l0oooo00<0O@L00?H>003f3P001P3f3P0600000480oooo1@00
00020?ooo`<000001@3oool3000000<0oooo1000003o0?oooo40oooo002f0?ooo`080000003oool0
oooo0000003oool000000?ooo`0000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`L0od804@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo101b1P0I
0?H>00l0oooo00<0O@L00?H>003f3P002P3f3P0500000440oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?oo
o`3o0?ooonh0oooo002d0?ooo`<000000P3oool01@000000oooo0000003oool000000080oooo1@00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool500000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`L0od80403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo101b1P0I0?H>00h0oooo0P1m1`0<0?H>00030000003f3P00mPh00080mPh01000000m0?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0?l0ooookP3oool00;80oooo0`0000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`3oool0
1`3o@P0@0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3g?`04078601T0mPh0
3P3oool207d700`0mPh000<000000?H>003f3P001P3f3P04000003T0oooo00<000000?ooo`3oool0
0`3oool400000080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo0?l0
ooookP3oool00;80oooo00<000000?ooo`3oool00`3oool3000000040?ooo`000000000000000080
oooo0`0000040?ooo`@000000`3oool300000080oooo00<000000?ooo`0000000P0000040?ooo`D0
od80303oool5000000H0oooo00<000000?ooo`3oool00P3g?`03078601X0mPh03P3oool207d700`0
mPh000<000000?H>003f3P002P3f3P04000003D0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000<0oooo0`0000030?ooo`@00000o`3ooooa0?ooo`00/P3oool01@000000
oooo0?ooo`3oool0000001@0oooo00<000000?ooo`3oool0403oool30?m20140oooo100000030?oo
o`030000003oool0LQd00080mcl00`1b1P0J0?H>00d0oooo0`1m1`0I0?H>00@0oooo1@00000`0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?oooo80oooo002c0?ooo`@00000503oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`1b7@000P3g?`03
078601X0mPh03@3oool307d701T0mPh02@3oool4000002`0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo0?l0oooolP3oool00<X0oooo0P00000U0?ooo`030000003oool0oooo00D0oooo00<0
0000078M001b7@000P3g?`03078601X0mPh0303oool407d701T0mPh03@3oool4000000/0oooo00<0
00000?ooo`3oool0603oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?oooo80oooo003a0?ooo`030000
003oool0oooo00D0oooo00<00000078M001b7@000P3g?`03078601X0mPh0303oool407d701T0mPh0
403oool00`3f3P00000000000002000000L0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`030?ooo`<00000103oool3000000<0oooo1@00003o0?oooo00oooo003`0?ooo`030000003o
ool0oooo00H0oooo00<00000078M001b7@000P3g?`03078601X0mPh0303oool407d701T0mPh03`3o
ool00`262000mPh00?H>00030?H>00D000000P3oool00`000000oooo0?ooo`100?ooo`D000000P3o
ool3000000@0oooo0`0000050?ooo`<00000o`3oooo90?ooo`00l03oool00`000000oooo0?ooo`06
0?ooo`030000001b7@00LQd00080mcl00`1b1P0I0?H>00d0oooo101m1`0I0?H>00l0oooo00<0QPP0
0?H>003f3P00203f3P04000004<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3o0?ooolH0oooo003_
0?ooo`030000003oool0oooo00H0oooo1@000000103g?`00LPH00786001b1P0I0?H>00d0oooo101m
1`0I0?H>00h0oooo0P26200<0?H>00030000003f3P00000000<00000?`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`3o0?ooolH0oooo002T0?ooo`@00000103oool5000000040?ooo`000000000000000080oooo
0P0000000`3oool000000000000400000080oooo0`0000000`3oool000000000000200000080oooo
0P0000020?ooo`<0000000<0oooo0000003oool00P3oool30?md01@0oooo00<000000?ooo`3oool0
1P3oool0101b7@000000078M001b7@020?Lo00<0LPH06@3f3P0;0?ooo`80mcl0101m1`0I0?H>00h0
oooo0P26200<0?H>00030000003f3P00mPh000<0mPh01000000k0?ooo`030000003oool0oooo00<0
oooo100000030?ooo`@000000P3oool01@000000oooo0?ooo`3oool000000?l0oooob03oool00:D0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`D0og@0
4P3oool00`000000oooo0?ooo`070?ooo`04078M00000000LQd0078M0080mcl00`1b1P0I0?H>00X0
oooo00<0OB000?Lo003g?`00101m1`0I0?H>00d0oooo0`26200<0?H>00030000003f3P00mPh000L0
mPh01000000g0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0oooob03o
ool00:D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`L0og@04@3oool00`000000oooo0?ooo`070?ooo`050000001b7@00LQd0078M003g?`00101b1P0I
0?H>00X0oooo00<0OB000?Lo003g?`00101m1`0I0?H>00d0oooo0`26200H0?H>0080oooo1@00000b
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0oooob03oool00:D0oooo
00<000000?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`L0og@0403oool00`000000oooo0?ooo`08
0?ooo`050000001b7@00LQd0078M003g?`00101b1P0I0?H>00T0oooo0P1m80020?Lo00@0O@L06@3f
3P0<0?ooo`@0QPP0603f3P070?ooo`@00000;P3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo0000003o0?ooolP0oooo002U0?ooo`<000001P3oool00`000000oooo0?ooo`020?ooo`80
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool00P0000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01`3oM00@0?oo
o`030000003oool0oooo00P0oooo00D00000078M001b7@00LQd00?Lo0004078601T0mPh02@3oool2
07dP0080mcl0101m1`0I0?H>00`0oooo1026200H0?H>00/0oooo1000000=0?ooo`030000003oool0
oooo01P0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooolP0oooo002U0?ooo`050000
003oool000000?ooo`0000000P3oool3000000<0oooo00<000000?ooo`0000000P0000050?ooo`03
0000003oool0oooo0080oooo100000020?ooo`030000003oool0000000800000103oool4000000<0
oooo1@3oM00A0?ooo`030000003oool0oooo00H0oooo0P3gL0001@000000LQd0078M001b7@00mcl0
00@0LPH06@3f3P080?ooo`<0OB000P3g?`0407d701T0mPh02`3oool508H801P0mPh03`3oool40000
00T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`<00000103oool30000
00@0oooo0`00003o0?ooolT0oooo002U0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0`3oM00=0?ooo`D000002@3oool20?M`
00050000001b7@00LQd0078M003g?`00101b1P0I0?H>00P0oooo0`1m80020?Lo00@0O@L06@3f3P0;
0?ooo`D0QPP0603f3P0@0?ooo`<0mPh0100000050?ooo`030000003oool0oooo03l0oooo1@000002
0?ooo`<00000103oool3000000@0oooo1@00003o0?oooj40oooo002T0?ooo`H000004P3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo100000050?ooo`04078d003gL000mg00
000000<0LQd000<0mcl00786001b1P000P1b1P0I0?H>00L0oooo101m80020?Lo00@0O@L06@3f3P0;
0?ooo`D0QPP0603f3P0?0?ooo`0308l8003f3P00mPh000D0mPh01P0000130?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?l0ooooX@3oool00:h0oooo00<000000?ooo`3oool02@3oool3000001D0oooo0P00000G0?oo
o`030000003oool0oooo00L0oooo00@0LS@00?M`003gL00000000`1b7@00103g?`00LPH00786001b
1P0J0?H>00L0oooo101m80020?Lo00@0O@L06@3f3P0;0?ooo`D0QPP0603f3P0?0?ooo`0308l8003f
3P00mPh000X0mPh0100000100?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooX@3oool00>/0oooo00<00000
0?ooo`3oool01P3oool2078d0080mg0000D00000078M001b7@00LQd00?Lo0003078600D0l`h05@3f
3P060?ooo`D0OB000P3g?`0407d701T0mPh02`3oool508H801P0mPh03P3oool208l800`0mPh000@0
00000?H>003f3P00mPh01000000l0?ooo`030000003oool0oooo00<0oooo100000030?ooo`@00000
103oool00`000000oooo0?ooo`3o0?oooj40oooo003Z0?ooo`030000003oool0oooo00L0oooo0P1b
=0020?M`00050000001b7@00LQd0078M003g?`000`1b1P090?<>0140mPh01P3oool507dP0080mcl0
101m1`0I0?H>00T0oooo0P3g?`0508H801P0mPh03P3oool208l800`0mPh000<000000?H>003f3P00
1@3f3P04000003P0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0?l0ooooX@3oool00;/0
oooo0`00000/0?ooo`030000003oool0oooo00H0oooo0`1b=0020?M`00030000001b7@00LQd00080
mcl00P1b1P0>0?<>00d0mPh01P3oool507dP0080mcl0101m1`0I0?H>00T0oooo0P3g?`0508H801P0
mPh03@3oool308l800`0mPh000<000000?H>003f3P002@3f3P05000003<0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo0?l0ooooX@3oool00;`0oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`060?ooo`<0LS@00P3gL0000`000000LQd0078M00020?Lo0080LPH04P3c3P090?H>
00H0oooo1@1m80000`3g?`00O@L007d7000307d701T0mPh0203oool00`268P00mcl00?Lo000508H8
01P0mPh03@3oool308l801P0mPh01@3oool4000002l0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo0?l0ooooX@3oool00;`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`06
0?ooo`@0LS@000<0mg00078M000000000P1b7@020?Lo00030786003c3P00l`h001D0l`h01@3f3P06
0?ooo`D0OB0000<0mcl007d7001m1`000`1m1`0I0?H>00P0oooo00<0QR800?Lo003g?`001@26200H
0?H>00`0oooo102?200H0?H>00T0oooo1000000Y0?ooo`<00000103oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`<00000o`3ooonS0?ooo`00[`3o
ool2000000D0oooo0`0000000`3oool000000?ooo`04000000@0oooo0`0000000`3oool000000000
000200000080oooo0P0000020?ooo`<0ojL0503oool00`000000oooo0?ooo`060?ooo`@0LS@000<0
mg00078M000000000P1b7@020?Lo00030786003c3P00l`h001T0l`h01@3oool20?M`00D0OB0000<0
mcl007d7001m1`000`1m1`0I0?H>00L0oooo0P268P020?Lo00@0QPP06@3f3P0;0?ooo`D0S`P0603f
3P0=0?ooo`@000002`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo0`00
00040?ooo`<000001@3oool00`000000oooo0?ooo`3o0?oooj40oooo002^0?ooo`040000003oool0
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`D0ojL04P3oool00`000000oooo0?ooo`070?ooo`@0LS@000<0mg00078M000000000P1b7@02
0?Lo00030786003c3P00l`h001T0l`h01@3oool20?M`00D0OB0000<0mcl007d7001m1`000`1m1`0I
0?H>00L0oooo0P268P020?Lo00@0QPP01@3c3P0D0?H>00/0oooo1@2?200H0?H>0100oooo00<0mPh0
0000000000000P0000070?ooo`030000003oool0oooo0?l0oooodP3oool00:h0oooo00@000000?oo
o`3oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`L0ojL04@3oool00`000000oooo0?ooo`070?ooo`@0LS@000<0mg00078M000000000P1b7@02
0?Lo01`0l`h0103oool00`1m>@00mg000?M`000507dP00030?Lo001m1`00O@L000<0O@L06@3f3P06
0?ooo`<0QR800P3g?`0408H800T0l`h0403f3P0;0?ooo`D0S`P0603f3P0?0?ooo`0309L9003f3P00
mPh000<0mPh01@0000020?ooo`030000003oool0oooo03d0oooo1@0000020?ooo`<00000103oool3
000000@0oooo1@00003o0?ooog/0oooo002a0?ooo`030000003oool0oooo0080oooo100000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool400000080oooo00H000000?ooo`3oool0oooo0000
003oool70?nW0100oooo00<000000?ooo`3oool0203oool4078d00030?M`001b7@0000000080LQd0
0P3g?`0K0?<>00D0oooo00<0OCT00?M`003gL0001@1m80000`3g?`00O@L007d7000307d701T0mPh0
1P3oool308HR0080mcl00`26200>0?<>00`0mPh02`3oool508l801P0mPh03`3oool00`2G2@00mPh0
0?H>00080?H>00@00000@03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0?l0ooooN@3oool00;40oooo
00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0ojL000H0ojL0403oool00`000000
oooo0?ooo`060?ooo`80mj40101b=0000`3gL000LQd000000002078M00030?Lo003c3P00l`h001X0
l`h0103oool207di0080mg001@1m80000`3g?`00O@L007d7000207d701X0mPh01@3oool408HR0080
mcl00`26200B0?<>00P0mPh02`3oool508l801P0mPh03P3oool209L900`0mPh000<000000?H>0000
00000`00000l0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool000000?l0ooooOP3oool00;40oooo00@000000?ooo`3oool0oooo100000020?oo
o`030000003oool00000008000000`3oool400000080oooo00<000000?ooo`0000000P0000030?oo
o`D0ojL0303oool2000000<0oooo00<000000?ooo`3oool01P3oool20?NQ00@0LS@000<0mg00078M
000000000P1b7@060?Lo01H0l`h01@3oool207di0080mg001@1m80000`3g?`00O@L007d7000207d7
00D0l`h05@3f3P050?ooo`@0QR800P3g?`0208H801L0l`h0103f3P090?ooo`80mcl01@2?200H0?H>
00h0oooo0P2G2@0<0?H>00030000003f3P00mPh000<0mPh01000000h0?ooo`030000003oool0oooo
00<0oooo100000030?ooo`@00000103oool00`000000oooo0?ooo`3o0?ooog/0oooo002a0?ooo`03
0000003oool0oooo01h0oooo0`3oY`0?0?ooo`@000001`3oool00`1bB`00mj400?NQ0004078d0003
0?M`00000000LQd00080LQd02P3g?`0B0?<>00D0oooo0P1m>@020?M`00D0OB0000@0mcl007d7001m
1`00O@L02P3c3P0A0?H>00D0oooo10268P020?Lo0080QPP06`3c3P080?ooo`0308lU003g?`00mcl0
00D0S`P01@3c3P0C0?H>00d0oooo0`2G2@0<0?H>00030000003f3P00mPh000L0mPh01000000d0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000001@3oool00`000000oooo0?ooo`3o0?ooogX0oooo002_0?ooo`@00000<`3oool0
10000000oooo0000000000050?ooo`03079;003gX@00mj4000@0LS@000<0mg000000001b7@000P1b
7@0>0?Lo00h0l`h0103oool307di0080mg001@1m8000103g?`00O@L007d7001m1`0>0?<>00d0mPh0
1@3oool408HR0080mcl00P26200K0?<>00P0oooo00<0SbD00?Lo003g?`00102?200;0?<>00h0mPh0
3@3oool309L901P0mPh00P3oool5000002l0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000o`3ooomk0?ooo`00i@3oool00`000000oooo0?ooo`060?ooo`80LT/00P3gX@03078d
0080mg0000@00000078M001b7@00LQd04P3g?`090?<>00D0oooo0`1m>@020?M`00D0OB0000<0mcl0
07d7001m1`004`3c3P090?H>00D0oooo10268P020?Lo000308H8003c3P00l`h001T0l`h0203oool2
08lU0080mcl0102?200@0?<>00T0mPh0303oool409L901P0mPh01`3oool4000002/0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`000000o`3ooomk0?ooo`00i@3oool00`000000oooo
0?ooo`060?ooo`80LT/00P3gX@03078d0080mg0000@00000078M001b7@00LQd05P3g?`050?<>00@0
oooo101m>@020?M`00D0OB0000<0mcl007d7001m1`005`3c3P050?H>00<0oooo0P3gL00408HR0080
mcl000<0QPP00?<>003c3P006@3c3P080?ooo`80SbD00P3g?`0308l801H0l`h0103f3P0<0?ooo`@0
U`T0603f3P0;0?ooo`@00000303oool00`000000oooo0?ooo`0F0?ooo`<00000103oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000o`3ooomk0?ooo`00i03oool00`000000oooo0?ooo`070?ooo`80LT/00P3gX@03
078d0080mg000`0000000`1b7@00mcl00?Lo000G0?Lo00H0oooo101m>@020?M`00D0OB0000<0mcl0
07d7003c3P006`3c3P030?ooo`0308Hm003gL000mg0000@0QR800P3g?`0K0?<>00P0oooo0`2?9@02
0?Lo00<0S`P06P3c3P0;0?ooo`D0U`T0603f3P0?0?ooo`@00000203oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<00000103oool300000?l0ooooO03oool0
0<@0oooo0P00000N0?ooo`030000003oool0oooo00H0oooo0`1bB`020?NQ00<0LS@00P3gL0000`00
0000LQd0078M0002000001P0mcl01P3oool407di0080mg001@1m80000`3g?`00O@L00?<>000K0?<>
00<0oooo00<0QSd00?M`003gL00010268P070?Lo01H0l`h0203oool308lU0080mcl00P2?200K0?<>
00/0oooo1@2G2@0H0?H>00l0oooo103f3P05000000<0oooo00<000000?ooo`3oool0?03oool50000
0080oooo0`0000040?ooo`<000001@3oool300000?l0ooooEP3oool00<H0oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`060?ooo`<0LT/00P3gX@03078d00030?M`001VIVH0000000<0
LQd06@3g?`060?ooo`@0OCT00P3gL00507dP00030?Lo003c3P00l`h001X0l`h00`3oool208Hm0080
mg0010268P0<0?Lo0100l`h0203oool408lU0080mcl00P2?200J0?<>00`0oooo1@2G2@0H0?H>00h0
oooo00<0WPT00?H>003f3P001`3f3P0400000400oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo00360?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01P3oool4079;0080
mj400`1b=0000`3gL000IVIV00000003078M01T0mcl01P3oool407di0080mg00101m80020?Lo01`0
l`h00`3oool208Hm0080mg0010268P040?<n00d0mcl02`3c3P080?ooo`@0SbD00P3g?`000`2?2000
l`h00?<>000I0?<>00`0oooo1@2G2@0H0?H>00h0oooo00<0WPT00?H>003f3P002P3f3P05000003`0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooomC0?ooo`00X03oool300000080oooo00@000000?ooo`3oool0
oooo0`0000030?ooo`@00000103oool00`000000oooo000000040?ooo`<0000000<0oooo0000003o
ool00P3oool00`000000oooo0?ooo`040?ooo`<0omX04`3oool00`000000oooo0?ooo`060?ooo`@0
LT/00P3gX@03078d000306IVIP1b7@00000000<0LQd06@3g?`040?ooo`80mj40101m>@020?M`00@0
OB0000<0lch00?<>003c3P006P3c3P030?ooo`<0QSd00P3gL00308HR00T0lch03P3g?`050?<>00P0
oooo1@2?9@020?Lo01/0l`h03@3oool509L901P0mPh03@3oool209h900`0mPh000<000000?H>003f
3P000P3f3P04000003P0oooo00<000000?ooo`3oool00`3oool4000000<0oooo100000060?ooo`03
0000003oool0oooo0?l0ooooD`3oool00:40oooo00<000000?ooo`3oool00P0000020?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`<00000103oool50?oJ0140oooo00<000000?oo
o`3oool01`3oool4079;0080mj400`1b=0000`1VIVH0LQd000000003078M01T0mcl0103oool20?NQ
00@0OCT00P3gL00307dP00L0lch05`3c3P030?ooo`<0QSd00P3gL00308HR00d0lch0303g?`0;0?oo
o`D0SbD01P3g?`0G0?<>00/0oooo0P3g?`0509L901P0mPh03@3oool209h900`0mPh000<000000?H>
003f3P001P3f3P04000003@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`800000o`3ooomF0?ooo`00X@3oool0
0`000000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000030?ooo`L0omX0403oool00`000000oooo0?ooo`070?ooo`@0
LT/00P3gX@02078d000406IVIP3gL000LQd0000000<0LQd06@3g?`030?ooo`0307eA003gX@00mj40
00@0OCT00P3gL00307dP00/0lch04P3c3P030?ooo`@0QSd00P3gL00208HR0180lch0203g?`0;0?oo
o`D0SbD02P3g?`0B0?<>00/0oooo00<0UbL00?Lo003g?`001@2G2@050?<>01<0mPh0303oool309h9
00`0mPh000<000000?H>003f3P002@3f3P000`3oool0000000000003000002l0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00060?ooo`030000003oool0oooo0?l0ooooD`3oool00:40oooo00D000000?ooo`000000oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000
003oool000000?ooo`0000000`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`L0omX03`3oool00`000000oooo0?ooo`080?ooo`@0LT/000P0mj40078d001b=000LS@006IVIP3g
L000LQd000000080LQd06P3g?`030?ooo`0307eA003gX@00mj4000@0OCT00P3gL00207dP0100lch0
3P3c3P030?ooo`@0QSd00P3gL00208HR01H0lch0103g?`0;0?ooo`D0SbD03P3g?`0>0?<>00/0oooo
00<0UbL00?Lo003g?`00102G2@0;0?<>00h0mPh0303oool309h901P0mPh01P3oool4000002/0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000060?ooo`030000003oool0oooo0?l0ooooD`3oool00:40oooo00D000000?ooo`00
0000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000001P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo00L0omX03`3oool00`000000oooo0?ooo`060?ooo`80mm80101bB`00203gX@00LS@0
078d001VIVH0LS@00?M`001b7@0000000P1b7@050?<n01D0mcl00P3oool207eA0080mj40101m>@02
0?M`0080OB00503c?P090?<>00<0oooo1@26?@020?M`000308HR003c?P00lch001T0lch02`3oool5
08lU0180mcl02@3c3P0;0?ooo`80UbL00P3g?`0409L90100l`h02@3f3P0;0?ooo`@0WPT0603f3P0:
0?ooo`@000003@3oool00`000000oooo0?ooo`0E0?ooo`<00000103oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000o`3ooomE0?ooo`00X@3oool200000080oooo00@000000?ooo`3oool0oooo0`0000030?ooo`03
0000003oool000000080000000D0oooo00000000000000000?ooo`03000000030?ooo`0000000000
008000000P3oool3000000040?ooo`000000000000000080oooo1@3ofP0<0?ooo`D00000203oool2
0?OB00@0LT/000T0mj40078d001b=000IVIV078d003gL000LQd00000001b7@002P3c?P0A0?Lo0080
oooo0P1mD@020?NQ00@0OCT00P3gL0000`1m8000lch00?<n000G0?<n00D0l`h00`3oool508Hm0080
mg0000<0QR800?<n003c?P006@3c?P090?ooo`80mg001@2?9@0F0?Lo00D0l`h02`3oool209LW0080
mcl00`2G2@0F0?<>00@0mPh02P3oool509h901P0mPh03P3oool4000000T0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`030?ooo`<00000103oool3000000@0oooo0`00003o0?oooeH0
oooo002Q0?ooo`8000000P3oool00`000000oooo0?ooo`0U0?ooo`<0omX0403oool4000000D0oooo
00<0LV800?OB003gdP00101bB`002@3gX@00LS@0078d001VIVH0LS@00?M`001b7@000000078M000>
0?<n00d0mcl000@0oooo07eA001mD@00OE400P3gX@0407di0080mg0000<0OB000?<n003c?P006@3c
?P060?ooo`D0QSd00P3gL00K0?<n00T0oooo00<0Sd400?M`003gL0001@2?9@0H0?Lo00d0oooo0`2G
9`020?Lo00<0U`T06P3c3P0:0?ooo`D0WPT0603f3P0?0?ooo`<0mPh0100000050?ooo`030000003o
ool0oooo03/0oooo1@0000020?ooo`<00000103oool3000000H0oooo0`00003o0?ooobl0oooo002P
0?ooo`8000000P3oool3000003T0oooo00<000000?ooo`3oool01P3oool00`1bHP00mm800?OB0004
079;00030?NQ001b=000IVIV0080LS@000<0mg00078M000000004`3c?P090?Lo00040?ooo`1mD@00
OE4007eA0080mj40101m>@020?M`01/0lch01`3oool508Hm00030?M`003c?P00lch001X0lch02@3o
ool00`2?@@00mg000?M`000508lU01P0mcl03@3oool309LW0080mcl00P2G2@0K0?<>00X0oooo1@2N
2@0H0?H>00h0oooo00<0Y@T00?H>003f3P001@3f3P06000003l0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3o
ool^0?ooo`00g`3oool00`000000oooo0?ooo`060?ooo`80LV800P3gdP04079;00030?NQ001b=000
IVIV0080LS@000<0mg00078M000000005`3c?P050?Lo00@0OE400P3gX@0407di00030?M`003c?P00
lch001X0lch01`3oool508Hm00D0mg005`3c?P090?ooo`80Sd400P3gL00508lU00@0lch0503g?`0<
0?ooo`@0UbL00P3g?`0209L901X0l`h02`3oool509h901P0mPh03P3oool00`2U2@00mPh00?H>000:
0?H>00@00000?03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001@00003o0?ooobl0oooo003O0?ooo`030000003oool0oooo00H0oooo0P1bHP020?OB
00<0LT/00P3gX@001`1VIVH0LS@0078d001b=000mg00078M000000006`3c?P000`3oool0OE4007eA
000207eA0080mj40101m>@060?M`01H0lch01P3oool20?NQ00D0QSd02@3gL00C0?<n00T0oooo0P2?
@@020?M`00@0SbD02@3c?P0@0?Lo00/0oooo1@2G9`020?Lo000309L9003c3P00l`h001T0l`h02`3o
ool509h901P0mPh03@3oool20:D900`0mPh000@000000?H>003f3P00mPh01000000h0?ooo`030000
003oool0oooo00<0oooo100000030?ooo`@0000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`3o0?ooobh0oooo003N0?ooo`030000003oool0oooo00H0oooo0`1bHP020?OB00<0LT/00P3g
X@001`1VIVH0LS@0078d001b=000mg00078M000000006`3c?P000`3oool0OE4007eA000207eA0080
mj40101m>@0:0?M`0180lch01P3oool20?NQ00D0QSd03@3gL00>0?<n00T0oooo0`2?@@020?M`00@0
SbD03@3c?P0<0?Lo00/0oooo1@2G9`020?Lo01/0l`h02P3oool20?Lo00D0WPT0103c3P0D0?H>00d0
oooo0P2U2@0<0?H>00030000003f3P00mPh000D0mPh01000000d0?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`00003o0?oooc00oooo003N0?ooo`030000003oool0oooo00H0oooo0`1bHP02
0?OB00<0LT/000<0mj4006IVIP1b=0000P1b=0020?M`00030000003c?P00lch001T0lch00P3oool4
07eA0080mj40101m>@0>0?M`00h0lch01@3oool00`26F000mj400?NQ000508Hm0140mg002P3c?P09
0?ooo`<0Sd400P3gL00308lU0180lch0203g?`0;0?ooo`D0UbL01P3g?`0F0?<>00X0oooo00<0WRP0
0?Lo003g?`00102N2@090?<>0100mPh0303oool30:D900`0mPh000<000000?H>003f3P002@3f3P05
000002l0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool000000?l0oooo<03oool00=h0oooo00<0
00000?ooo`3oool01@3oool4079R0080mm800`1bB`000`3gX@00IVIV078d0002078d0080mg0000<0
00000?<n003c?P006@3c?P020?ooo`@0OE400P3gX@0407di0180mg002@3c?P060?ooo`0308IH003g
X@00mj4000D0QSd05@3gL0050?<n00T0oooo102?@@020?M`00<0SbD05P3c?P040?Lo00/0oooo1@2G
9`0:0?Lo0180l`h02@3oool209hX0080mcl0102N2@0=0?<>00`0mPh0303oool30:D901P0mPh01@3o
ool4000002/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000?l0oooo<03oool007H0oooo
0`0000020?ooo`040000003oool0oooo0?ooo`<000001@3oool3000000050?ooo`00000000000000
003oool00`0000020?ooo`<000000`3oool4000000<0oooo1P0000020?ooo`<0000000<0oooo0000
000000000P0000020?ooo`8000000P3oool3000000040?ooo`000000oooo0?ooo`<000001P3oool3
0??o01<0oooo00<000000?ooo`3oool01P3oool4079R0080mm800`1bB`000`1VIVH0mj40078d0002
078d00030?M`003c?P00000001X0lch000<0oooo0?OB003gdP00101mD@020?NQ00@0OCT05P3gL005
0?<n00D0oooo0P26F0020?NQ00@0QSd0603gL00;0?ooo`D0Sd400P3gL00208lU01/0lch02`3oool5
09LW00h0mcl03@3c3P0:0?ooo`80WRP00P3g?`0309h90180l`h0203f3P0;0?ooo`@0Y@T0603f3P09
0?ooo`@000003@3oool00`000000oooo0?ooo`0E0?ooo`<00000103oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`800000o`3oool`0?ooo`00M`3o
ool00`000000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`070000
003oool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00D00000
0?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`D0lol04P3oool00`000000oooo0?ooo`06
0?ooo`@0LV800P3gdP03079;000306IVIP3gX@00LS@00080LS@00P3gL00010000000mg000?M`003g
L00G0?<n00030?ooo`3gdP00mm8000@0OE400P3gX@0407di01P0mg00203oool208IH0080mj401026
?@040?=_01@0mg002`3oool508m10080mg000P2?9@0K0?<n00P0oooo0`3gL00509LW0180mcl02@3c
3P090?ooo`<0WRP00P3g?`0309h901H0l`h0103f3P0:0?ooo`D0Y@T0603f3P0=0?ooo`@000002@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<000001P3o
ool00`000000oooo0?ooo`3o0?ooobh0oooo001g0?ooo`030000003oool0oooo008000000P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000060?ooo`040000003oool0oooo0?ooo`L0lol0403oool0
0`000000oooo0?ooo`070?ooo`@0LV8000<0mm80079;001bB`000P1bB`000`1VIVH0mj40078d0002
078d0080mg0000<000000?M`003gL0001P3gL00A0?<n00040?ooo`1mJP00mm800?OB00@0OE400P3g
X@0407di01P0mg001`3oool308IH0080mj400`26?@090?=_0100mg002`3oool508m10080mg0000<0
SbD00?<n003c?P006@3c?P080?ooo`0409M5003gL000mg000?M`00D0UbL0103c?P0B0?Lo00@0l`h0
2@3oool409hX0080mcl00P2N2@0K0?<>00X0oooo1@2U2@0H0?H>00l0oooo0P3f3P04000000D0oooo
00<000000?ooo`3oool0>P3oool500000080oooo0`0000040?ooo`<00000103oool400000?l0oooo
2`3oool007L0oooo00D000000?ooo`000000oooo000000020?ooo`D000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool5000000<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<00000103oool70??o0100oooo00<00000
0?ooo`3oool01`3oool4079R00050?OB001bB`00LT/0079;001VIVH00P3gX@03078d0080mg0000<0
00000?M`003gL0002`3gL00<0?<n00040?ooo`1mJP00mm800?OB00@0OE400P3gX@0407di01P0mg00
1`3oool308IH0080mj400`26?@0=0?=_00`0mg002`3oool508m10080mg00703c?P080?ooo`0409M5
003gL000mg000?M`00@0UbL02@3c?P0?0?Lo00`0oooo102N:0020?Lo0080WPT06`3c3P0:0?ooo`D0
Y@T0603f3P0>0?ooo`030:/:003f3P00mPh000@0mPh01P00000n0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo203oool007L0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`8000000P3oool010000000oooo0?ooo`00
00030?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo008000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
00<0oooo00@000000?ooo`3oool0oooo1`3co`0?0?ooo`030000003oool0oooo00H0oooo0P3[m`04
079R00050?OB001bB`00LT/0079;001VIVH00P3gX@03078d0080mg0000<000000?M`003gL000403g
L0060?<n00030?ooo`1mJP00OFX00080mm80101mD@020?NQ00@0OCT0603gL0060?ooo`@0QUP00P3g
X@0208Hm0180lfl0203gL00;0?ooo`D0Sd401P3gL00G0?<n00P0oooo0P2GA@030?M`00@0UbL03@3c
?P0;0?Lo00/0oooo1@2N:0020?Lo000309h9003c3P00l`h001T0l`h02`3oool50:D901P0mPh03@3o
ool20:/:00/0mPh01000000k0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo203oool007L0oooo0P000002
0?ooo`040000003oool0oooo0?ooo`<000000`3oool500000080oooo00@000000?ooo`0000000000
103oool3000000<0oooo00<000000?ooo`0000000P0000040?ooo`030000003oool0oooo0080oooo
100000020?ooo`030000003oool0000000800000103oool4000000<0oooo0`0000050?ooo`D0lol0
303oool5000000P0oooo0P3[m`04079R00050?OB001bB`00LT/006IVIP1bB`000P3gX@03078d0080
mg0000<000000?M`003gL000503gL0030?ooo`80OFX00P3gdP0407eA0080mj400`1m>@0I0?M`00H0
oooo1026F0020?NQ0080QSd05P3cK`040?M`00T0oooo0P3gX@0508m100X0mg004`3c?P080?ooo`80
UdD00`3gL00309LW0180lch01`3g?`0:0?ooo`H0WRP00P3g?`0K0?<>00`0oooo1@2U2@050?<>01<0
mPh03@3oool20:/:00/0mPh000@000000?H>003f3P00mPh01000000g0?ooo`030000003oool0oooo
00<0oooo100000030?ooo`@000001P3oool00`000000oooo0?ooo`3o0?ooo`P0oooo001g0?ooo`80
00000P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0`3co`0A0?ooo`@0
0000103oool00`1]LP00joL00>_g0003079R0080mm800P1bB`00101VIVH0LT/00?NQ003gX@03078d
0080mg0000<000000?M`003gL000503gL0020?ooo`<0OFX00P3gdP0407eA0080mj400`1m>@050?=_
01@0mg001P3oool408IH0080mj4000<0QSd00?=_003cK`006@3cK`090?ooo`80mj401@2?@@0>0?M`
00h0lch0203oool309M500<0mg000P2G9`0G0?<n00<0mcl02P3oool609hX00H0mcl05`3c3P090?oo
o`030:DZ003g?`00mcl000@0Y@T02`3c3P0>0?H>00`0oooo0`2[2P0;0?H>00030000003f3P00mPh0
00D0mPh01000000c0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool400000?l0oooo2`3oool007H0oooo0P000002
0?ooo`<000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00H0oooo00<0KG80
0>_g003[m`000`1bHP020?OB0005079;001VIVH0LT/0079;003gX@00101b=0020?M`00030000003g
L000mg0001@0mg000P3oool307eZ0080mm80101mD@020?NQ00<0OCT02P3cK`0?0?M`00H0oooo1026
F0020?NQ000308Hm003cK`00lfl001T0lfl0203oool00`2?G@00mj400?NQ000508m100@0lfl03P3g
L00:0?<n00P0oooo0`2GA@030?M`0080UbL06P3c?P0:0?ooo`H0WRP02P3g?`0B0?<>00T0oooo0P2U
:P020?Lo00@0Y@T0403c3P090?H>00/0oooo102[2P0;0?H>00030000003f3P00mPh000T0mPh01000
000_0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooo``0oooo002;0?ooo`800000
503oool3000001D0oooo0P00000O0?ooo`030000003oool0oooo00D0oooo0P1]LP020>_g00<0LV80
0P3gdP001@1bB`00IVIV079;001bB`00mj4000@0LS@00P3gL0000`000000mg000?M`000D0?M`0003
0?ooo`1mJP00OFX00080OFX00P3gdP0407eA0080mj400P1m>@0@0?=_00X0mg001P3oool408IH0080
mj406`3cK`090?ooo`0308mM003gX@00mj4000@0Sd402@3cK`0>0?M`00D0lch0203oool409M500<0
mg0000<0UbL00?<n003c?P006@3c?P0:0?ooo`H0WRP03P3g?`0=0?<>00X0oooo0P2U:P020?Lo00<0
Y@T05P3c3P040?H>00/0oooo102[2P0G0?H>00@0oooo1@00000Z0?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`3o0?ooo``0oooo003I0?ooo`030000003oool0oooo00H0oooo0P1]LP020>_g
00<0LV800P3gdP001@1bB`00IVIV079;001bB`00mj4000@0LS@00P3gL002000001D0mg0000<0oooo
07eZ001mJP000P1mJP020?OB00@0OE400P3gX@0207di01D0lfl01@3gL0040?ooo`80mm801026F000
0`3gX@00lfl00?=_000J0?=_00P0oooo0P2?G@020?NQ00@0Sd403@3cK`0<0?M`00X0oooo1@2GA@03
0?M`000309LW003c?P00lch001P0lch02`3oool609hX0180mcl02@3c3P090?ooo`<0YBX00P3g?`03
0:D901X0l`h02P3oool50:/:01L0mPh02@3oool4000000d0oooo00<000000?ooo`3oool0503oool3
000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`3o0?ooo``0oooo003I0?ooo`030000003oool0oooo00D0oooo0`1]
LP020>_g00<0LV800P3gdP001@1VIVH0LT/0079;001bB`00mj4000@0LS@00P3gL00010000000mg00
00000000000C0?M`00030?ooo`1mJP00OFX00080OFX00P3gdP0407eA0080mj4000<0OCT00?=_003c
K`00603cK`040?ooo`0308Ib003gdP00mm8000@0QUP01@3gX@0G0?=_00T0oooo0P2?G@020?NQ00<0
Sd404P3cK`080?M`00X0oooo1@2GA@030?M`01/0lch02@3oool20?M`00H0WRP05P3g?`040?<>00X0
oooo0`2U:P020?Lo0080Y@T06`3c3P090?ooo`H0Z`X05`3f3P0=0?ooo`@000002@3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<000000`3oool500000?l0
oooo2P3oool00=P0oooo00<000000?ooo`3oool01P3oool306eb0080joL00`1bHP020?OB000506IV
IP1bB`00LT/0079;003gX@00101b=0020?M`00030000003gL000mg0001@0mg0000<0oooo07eZ001m
JP000P1mJP000`3gdP00OE4007eA000307eA0080mj4000<0OCT00?=_003cK`00603cK`040?ooo`03
08Ib003gdP00mm8000@0QUP02@3gX@0C0?=_00P0oooo0`2?G@020?NQ00<0Sd405P3cK`040?M`00X0
oooo1@2GA@020?M`01/0lch02@3oool00`2NB000mg000?M`000609hX01L0mcl0303oool40:DZ0080
mcl00P2U2@0J0?<>00X0oooo1P2[2P0G0?H>00l0oooo0P3f3P04000000D0oooo00<000000?ooo`3o
ool0>03oool500000080oooo0`0000040?ooo`<000001@3oool300000>H0oooo001a0?ooo`@00000
103oool00`000000oooo000000030?ooo`D00000103oool300000080oooo1@0000030?ooo`<00000
0`3oool4000000<0oooo1P0000020?ooo`<0000000<0oooo0000000000000P0000020?ooo`800000
0P3oool3000000030?ooo`000000oooo00@0oooo0`30o`0C0?ooo`030000003oool0oooo00D0oooo
101]LP020>_g00<0LV8000<0mm8006IVIP1bB`000`1bB`000`3gX@00LS@0078d0002078d0080mg00
00<000000?M`003gL000503gL0000`3oool0OFX007eZ000207eZ00030?OB001mD@00OE4000<0OE40
0P3gX@0K0?=_00<0oooo0P26LP020?OB00@0QUP03@3gX@0>0?=_00T0oooo0`2?G@020?NQ0080Sd40
6`3cK`0:0?ooo`D0UdD01`3gL00F0?<n00T0oooo00<0WTP00?M`003gL0001P2N:0050?<n0180mcl0
303oool40:DZ0080mcl000<0Y@T00?<>003c3P00603c3P0;0?ooo`H0Z`X05`3f3P0>0?ooo`030;0:
003f3P00mPh000@0mPh01P00000l0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0h`3oool00740oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?ooo`00
00030?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000050?ooo`D0`?l04P3oool00`000000oooo0?ooo`050?ooo`@0KG800P3[m`03
079R00030?OB001VIVH0LT/000<0LT/000<0mj40078d001b=0000P1b=0020?M`00030000003gL000
mg0001@0mg0000<0joL007eZ001mJP000P1mJP000`3gdP00OE4007eA000307eA0080mj406P3cK`04
0?ooo`80QW800P3gdP0308IH0180mj402P3cK`080?ooo`@0Sed00P3gX@0208m101/0lfl02P3oool5
09M500`0mg00403c?P090?ooo`80WTP00P3gL00509hX00/0lch03@3g?`0;0?ooo`D0YBX00P3g?`0K
0?<>00/0oooo1P2[2P0G0?H>00d0oooo0P2`2P0;0?H>00@00000>@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`3S0?ooo`00M@3oool020000000oooo0?ooo`000000oooo0000003oool00000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool70<3o0100oooo00<000000?ooo`3oool01P3oool406eb0080joL00`1b
HP000`1VIVH0mm80079;0003079;00030?NQ001b=000LS@00080LS@00P3gL0000`000000mg000?M`
000D0?M`00030>_g001mJP00OFX00080OFX000<0mm8007eA001mD@000`1mD@000`3gX@00lfl00?=_
000I0?=_00<0oooo0`26LP020?OB00<0QUP0103cW`0B0?NQ00D0lfl02@3oool408mM0080mj4000<0
Sd400?=_003cK`006@3cK`090?ooo`80mj401@2GA@0A0?M`00/0lch02@3oool209i80080mg00102N
:00@0?<n00T0mcl02P3oool60:DZ00L0mcl05@3c3P0<0?ooo`H0Z`X01@3c3P0B0?H>00d0oooo0P2`
2P0;0?H>00040000003f3P00mPh00?H>00@00000=@3oool00`000000oooo0?ooo`030?ooo`@00000
0`3oool400000080oooo00D000000?ooo`3oool0oooo0000003U0?ooo`00L`3oool300000080oooo
00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`020?ooo`D000000`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo1`30o`0@0?ooo`030000003oool0oooo00H0oooo101]LP00
0`3[m`00LV80079R0002079R000306IVIP3gdP00LT/00080LT/00P3gX@03078d00<0mg0000<00000
0?M`003gL000503gL0000`3[m`00OFX007eZ000207eZ00030?OB001mD@00OE4000<0OE401@3gX@0F
0?=_00@0oooo0`26LP020?OB00<0QUP0203cW`0A0?NQ00/0oooo102?G@020?NQ01`0lfl0203oool0
0`2GH`00mj400?NQ000509M500D0lfl04@3gL0050?<n00T0oooo0`2NB0020?M`00@0WRP05@3c?P04
0?Lo00X0oooo1P2U:P0<0?Lo00l0l`h02`3oool20?Lo00D0Z`X02`3c3P0=0?H>00`0oooo0`2`2P0;
0?H>00030000003f3P00mPh000D0mPh01000000a0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool400000>H0oooo
001a0?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0200000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`L0`?l03`3oool00`000000oooo0?ooo`070?ooo`@0KG8000D0joL0079R001bHP00LV8006IV
IP020?OB00<0LT/00P3gX@03078d0080lVh000<000000?9^003bKP005@3gL0000`3[m`00OFX007eZ
000207eZ00030?OB001mD@00OE4000<0OE402@3gX@0B0?=_00<0oooo1026LP020?OB0080QUP03@3c
W`0=0?NQ00/0oooo102?G@060?NQ01L0lfl02@3oool00`2GH`00mj400?NQ000409M500/0lfl03P3g
L00<0?ooo`<0WTP00P3gL00309hX01X0lch02P3oool60:DZ0100mcl02`3c3P0:0?ooo`030://003g
?`00mcl000@0Z`X0403c3P090?H>00/0oooo102`2P0;0?H>00030000003f3P00mPh000T0mPh01000
000]0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3W0?ooo`00L@3oool00`000000oooo
0?ooo`030?ooo`<0000000D0oooo00000000000000000?ooo`03000000@0oooo1@0000020?ooo`D0
00000`3oool3000000<0oooo00<000000?ooo`0000000P0000040?ooo`030000003oool0oooo0080
oooo100000020?ooo`030000003oool0000000800000103oool4000000D0oooo1@30o`0@0?ooo`03
0000003oool0oooo00H0oooo00<0^_L006eb001]LP000P1]LP001P3[m`00LV80079R001bHP00IVIV
0?OB00@0LT/00P3gX@03078d0080lVh000<000000?9^003bKP00103bKP0A0?M`00030>_g001mJP00
OFX00080OFX000<0mm8007eA001mD@000`1mD@0=0?NQ00h0lfl00P3oool508Ib0080mm800P26F00A
0?>O00T0mj402`3oool408mM00X0mj404`3cK`080?ooo`80Uf<00P3gX@0409M50100lfl02@3gL00;
0?ooo`@0WTP00P3gL00209hX01/0lch02P3oool60:DZ01D0mcl01@3c3P0:0?ooo`80Zb`00P3g?`04
0:/:01D0l`h0103f3P0;0?ooo`@0/0X05`3f3P040?ooo`D00000:03oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0i`3oool00740oooo00D000000?ooo`3oool0oooo0000000A0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`040?ooo`<0`?l0
303oool5000000T0oooo00<0^_L006eb001]LP000P1]LP001P3[m`00LV80079R001bHP00IVIV0?OB
00@0LT/00P3gX@02078d00<0lVh000<000000?9^003bKP00203bKP0=0?M`00030>_g001mJP00OFX0
0080OFX000<0mm8007eA001mD@000P1mD@0B0?NQ00T0lfl00`3oool508Ib0080mm8000<0QUP00?>O
003cW`00503cW`050?NQ00T0oooo0P3gdP0408mM00@0lil02P3gX@0>0?=_00T0oooo0P2GH`020?NQ
00<0UdD05P3cK`040?M`00X0oooo1@2NB0020?M`0080WRP06P3c?P0;0?ooo`H0YBX05`3g?`0=0?oo
o`80Zb`00P3g?`030:/:01X0l`h02P3oool50;0:01L0mPh02@3oool4000000`0oooo00<000000?oo
o`3oool04`3oool3000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3V0?ooo`00LP3oool400000140oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01L0oooo10000005
0?ooo`0305Ib002jm`00KG8000<0KG8000H0joL0079R001bHP00IVIV079R003gdP04079;0080mj40
0P1b=0030?9^00030000003bKP00lVh000`0lVh02@3gL0000`3[m`00OFX007eZ000207eZ00030?OB
001mD@00OE400080OE401@3cW`0A0?NQ00D0lfl00`3oool508Ib0080mm8000<0QUP00?>O003cW`00
603cW`090?ooo`0308mj003gdP00mm8000<0Sed02@3cW`0:0?NQ00X0lfl0203oool309MS0080mj40
0`2GA@0J0?=_00X0oooo1@2NB0020?M`000309hX003c?P00lch001T0lch02@3oool20?M`00H0YBX0
1@3c?P0B0?Lo00`0oooo0`2[;0020?Lo0080Z`X06`3c3P090?ooo`H0/0X0103c3P0C0?H>00d0oooo
100000080?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00`3oool3000000@0oooo
0`0000050?ooo`<000002`3oool500000080oooo0`0000040?ooo`<000001P3oool00`000000oooo
0?ooo`300?ooo`00P@3oool00`000000oooo0?ooo`0N0?ooo`<000005@3oool2000001P0oooo00<0
00000?ooo`3oool01`3oool00`1FLP00^_L006eb000306eb00060>_g001bHP00LV8006IVIP1bHP00
mm80101bB`020?NQ0003078d003bKP00lVh00080lVh000<000000?9^003bKP00403bKP050?M`0003
0>_g001mJP00OFX00080OFX000@0mm8007eA001mD@00OE402`3cW`0?0?NQ00D0oooo1@26LP020?OB
01/0lil02@3oool00`2?NP00mm800?OB000308mM00d0lil02P3gX@050?=_00T0oooo0`2GH`020?NQ
0080UdD06`3cK`0:0?ooo`D0WTP00P3gL00K0?<n00T0oooo00<0YD/00?M`003gL0001@2U:P0;0?<n
00d0mcl02`3oool40://0080mcl00P2[2P0J0?<>00X0oooo1@2`2P090?<>00l0mPh03P3oool00`2e
2`00mPh00?H>0004000000@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`300?oo
o`00e03oool00`000000oooo0?ooo`060?ooo`80EW8000<0^_L006eb001]LP000P1]LP00103[m`00
LV8006IVIP1bHP020?OB00@0LT/00P3gX@000`1b=000lVh00?9^00020?9^00030000003bKP00lVh0
01@0lVh00P3[m`0407eZ00040?OB001mD@00OE4007eA0100lil02P3gX@050?ooo`D0QW800P3gdP0K
0?>O00P0oooo0P2?NP020?OB0080Sed04P3cW`080?NQ00/0oooo102GH`020?NQ0080UdD06P3cK`0;
0?ooo`D0WTP01P3gL00G0?<n00P0oooo0P2UB`020?M`00@0YBX0403c?P090?Lo00/0oooo102[;002
0?Lo00030:/:003c3P00l`h001P0l`h02`3oool40;0:00h0l`h02`3f3P0=0?ooo`80]@/01P3f3P05
000003`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0`03oool00=@0oooo00<000000?ooo`3oool01P3oool205Ib
00030;[g001]LP00KG800080KG8000@0joL0079R001VIVH0LV800P3gdP04079;0080mj401@3bKP00
0`000000lVh00?9^000D0?9^0080joL0101mJP000`3gdP00OE4007eA000F0?>O00D0mj400`3oool2
0>_g00D0QW8000<0mm800?>O003cW`006@3cW`090?ooo`80SgX00P3gdP0208mM01H0lil0103gX@0:
0?ooo`D0Uf<00P3gX@000`2GA@00lfl00?=_000I0?=_00/0oooo1@2NB00:0?M`0180lch02@3oool2
0:E;0080mg00102U:P0E0?<n00@0mcl02P3oool50://0080mcl06`3c3P0;0?ooo`@0/0X04P3c3P07
0?H>00`0oooo0`2e2`0:0?H>00D00000>03oool00`000000oooo0?ooo`030?ooo`@000000`3oool4
000000D0oooo00<000000?ooo`3oool0_`3oool00=<0oooo00<000000?ooo`3oool01P3oool305Ib
00030;[g001]LP00KG800080KG8000@0joL006IVIP1bHP00LV800P3gdP04079;0080mj401@3bKP00
0`000000lVh00?9^000C0?9^000307Mm003[m`00joL000@0OFX000<0mm8007eA001mD@006P3cW`04
0?ooo`80joL01@26LP050?OB01L0lil0203oool308mj0080mm8000<0Sed00?>O003cW`006@3cW`0:
0?ooo`D0Uf<00P3gX@0K0?=_00X0oooo0P3gX@0509i800h0mg003P3c?P080?ooo`<0YD/00P3gL003
0:DZ01X0lch02@3oool60://00L0mcl05@3c3P0<0?ooo`<0/0X05`3c3P030?H>00`0oooo0`2e2`0;
0?H>00040000003f3P00mPh00?H>00@00000=03oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool0_`3oool00=<0oooo00<000000?ooo`3oool01P3oool305Ib00030;[g001]LP00KG800080KG80
00@0joL006IVIP1bHP00LV800P3gdP04079;00030?NQ003bKP00lVh000@0lVh000<000000?9^003b
KP004`3bKP000`1gO@00joL007eZ000407eZ00030?OB001mD@00lil001X0lil00`3oool00`20QP00
joL00>_g000508Ib00T0mm804P3cW`090?ooo`<0SgX00P3gdP000`2?G@00lil00?>O000I0?>O00X0
oooo1@2GH`070?NQ01H0lfl02@3oool00`2NI`00mj400?NQ000509i800@0lfl03P3gL0090?<n00P0
oooo102UB`020?M`0080YBX06`3c?P090?ooo`H0Zb`0303g?`0?0?<>00X0oooo00<0/2d00?Lo003g
?`000P2`2P0K0?<>00/0oooo102e2`0;0?H>00030000003f3P00mPh000D0mPh01000000`0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`2o0?ooo`00R03oool5000000@0oooo0`0000020?oo
o`<000000P3oool4000000030?ooo`000000oooo008000000P3oool3000000030?ooo`000000oooo
00@000000P3oool2000000<0oooo0P0000030?ooo`<0SOl04`3oool00`000000oooo0?ooo`060?oo
o`@0EW8000H0^_L006eb001]LP00KG800>_g001VIVH3079R0080mm80101bB`050?NQ0080lVh000<0
00000?9^003bKP004P3bKP0207Mm00030>_g001mJP00OFX000<0OFX000<0mm8007eA003cW`006@3c
W`040?ooo`030826003[m`00joL000D0QW803@3gdP0>0?>O00P0oooo102?NP020?OB01/0lil02`3o
ool509MS00D0lil01`3gX@0@0?=_00X0oooo00<0WVL00?NQ003gX@00102NB0090?=_00h0mg001@3c
?P080?ooo`@0YD/00P3gL0020:DZ01X0lch02P3oool60://0100mcl02`3c3P090?ooo`80/2d00P3g
?`020;0:01/0l`h02P3oool50;D;00/0mPh000<000000?H>003f3P00203f3P000`3oool000000000
0002000002`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0;l0oooo00290?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000040?ooo`D0
SOl04P3oool00`000000oooo0?ooo`060?ooo`@0EW8000H0^_L006eb001]LP00KG800>_g001VIVH3
079R0080mm80101bB`070?NQ00030000003gX@00lVh00180lVh00P1gO@000`3[m`00OFX007eZ0003
07eZ00030?OB003cW`00lil001T0lil00`3oool208260080joL01@26LP0A0?OB00T0lil0203oool5
08mj00030?OB003cW`00lil001X0lil02`3oool409MS00/0lil01`3gX@0;0?=_00T0oooo0P2NI`02
0?NQ00@0WTP03@3cK`0;0?M`00/0oooo1@2UB`020?M`00030:DZ003c?P00lch001P0lch02`3oool6
0://01D0mcl01@3c3P090?ooo`<0/2d00P3g?`000`2`2P00l`h00?<>000I0?<>00/0oooo1@2e2`0F
0?H>00D0oooo1@00000U0?ooo`<00000103oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000`03oool008T0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`L0SOl0403o
ool00`000000oooo0?ooo`070?ooo`@0EW8000H0^_L006eb001]LP00KG800>_g001VIVH3079R0080
mm80101bB`070?NQ00030000003gX@00mj4000<0mj403P3bKP0307Mm00030>_g001mJP00OFX000<0
OFX06`3cW`040?ooo`80P8H00P3[m`0508Ib01D0mm801@3cW`080?ooo`D0SgX01@3gdP0G0?>O00X0
oooo0P3gdP0409MS00l0lil0203gX@050?=_00X0oooo0P2NI`020?NQ00<0WTP04P3cK`070?M`00X0
oooo1P2UB`020?M`01/0lch02`3oool60://00D0lch04P3g?`0<0?ooo`<0/2d00P3g?`0K0?<>00/0
oooo1P2e2`0F0?H>00X0oooo1000000;0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool00`3oool3000000@0oooo0`0000030?ooo`D00000`03oool008T0oooo00D000000?ooo`3oool0
oooo000000020?ooo`D000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`000000oooo000000030?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`8000001@3oool7
08go0100oooo00<000000?ooo`3oool01`3oool405Ib00060;[g001]LP00KG8006eb001VIVH0joL0
0`1bHP020?OB00@0LT/01`3gX@000`000000mj400?NQ00070?NQ00X0lVh00`1gO@000`3[m`00OFX0
07eZ000307eZ00D0mm805P3cW`030?ooo`<0P8H00P3[m`0408Ib01P0mm802`3oool508mj00T0mm80
4`3cW`0:0?ooo`80mm800`2GH`0E0?>O00D0mj40303oool309iW0080mj400`2NB00F0?=_00<0mg00
2P3oool60:E;00L0mg005@3c?P0:0?ooo`80mg001@2[;00;0?<n00d0mcl02`3oool40;0]00H0mcl0
5`3c3P0:0?ooo`L0]@/05P3f3P0>0?ooo`@000001`3oool00`000000oooo0?ooo`0g0?ooo`D00000
0P3oool3000000@0oooo0`0000050?ooo`<00000W@3oool008T0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00P000000?ooo`3o
ool000000?ooo`000000oooo000000H0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000
003oool0000000@0oooo1`2=o`0@0?ooo`030000003oool0oooo00L0oooo101FLP001P2jm`00KG80
06eb001]LP00IVIV0>_g00<0LV800P3gdP04079;00L0mj4000<000000?NQ003gX@002`3gX@050?9^
00@0Mgd000<0joL007eZ001mJP000`1mJP0:0?OB0100lil0103oool308260080joL01026LP050???
01<0mm802`3oool508mj00d0mm803P3cW`0:0?ooo`0309N1003gdP00mm8000<0Uf<06@3cW`0=0?oo
o`<0WVL00P3gX@0209i801X0lfl02P3oool60:E;00`0mg003`3c?P0:0?ooo`030:]>003gL000mg00
00@0Zb`0403c?P090?Lo00X0oooo1@2`;@0:0?Lo0180l`h0303oool60;D;01H0mPh03P3oool0102j
2`00mPh00?H>003f3P04000000<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo09X0oooo00290?ooo`050000003oool0oooo0?ooo`0000000`3oool300000080oooo00<0
00000?ooo`0000000P0000020?ooo`<0000000<0oooo0000003oool00P3oool4000000<0oooo00<0
00000?ooo`0000000P0000020?ooo`030000003oool0oooo008000000`3oool508go0100oooo00<0
00000?ooo`3oool01P3oool208Wh00@0EW8000D0^_L006eb001]LP00IVIV0>_g0004079R0080mm80
101bB`070?NQ00030000003gX@00mj4000h0mj400P2jm`0407Mm00030>_g001mJP00OFX00080OFX0
403gdP0;0?>O00<0oooo1020QP020>_g00<0QW802`3cc`0>0?OB00/0oooo1@2?NP0A0?OB00X0lil0
2P3oool00`2GP@00mm800?OB000209MS01X0lil0303oool409iW0080mj400P2NB00J0?=_00X0oooo
1P2UB`0@0?M`00/0lch02@3oool20:]>0080mg00102[;00E0?<n00@0mcl02P3oool50;0]00h0mcl0
3@3c3P0=0?ooo`H0]@/05P3f3P0=0?ooo`80^P/01`3f3P04000003/0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool0VP3oool008T0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`030000003oool0oooo00H0
oooo0`2=o`0=0?ooo`D000001`3oool00`0oLP00ROP008Wh000405Ib00050;[g001]LP00KG8006IV
IP3[m`00101bHP020?OB00@0LT/01`3gX@000`000000mj400?NQ000>0?NQ0080^_L0101gO@000`3[
m`00OFX007eZ000207eZ00D0lll0403gdP050?>O00@0oooo1020QP020>_g00<0QW80403cc`090?OB
00T0oooo0P3[m`0508mj01D0mm801@3cW`0:0?ooo`80Uh400P3gdP0209MS01T0lil0303oool509iW
0080mj4000<0WTP00?=_003cK`00603cK`0;0?ooo`H0YD/05@3gL0050?<n00X0oooo0P2[CP020?M`
00<0Zb`06P3c?P090?ooo`H0/2d04P3g?`090?<>00d0oooo1P2e2`0F0?H>00`0oooo0`2j2`0;0?H>
00D00000=P3oool00`000000oooo0?ooo`030?ooo`@000000`3oool400000080oooo00D000000?oo
o`3oool0oooo0000002L0?ooo`00R03oool5000002H0oooo00<000000?ooo`3oool06@3oool50000
00@0oooo00<0?g8008Wh0029n000101FLP001@2jm`00KG8006IVIP1]LP00joL000@0LV8000<0mm80
079;001bB`000`1bB`070?NQ00030000003gX@00mj4000h0mj400P2jm`0407Mm00040>_g001mJP00
OFX007eZ00/0lll03`3gdP050?ooo`@0P8H00P3[m`0208Ib01H0lll0103gdP080?ooo`0308R?003[
m`00joL000D0SgX05`3gdP0=0?ooo`80Uh400P3gdP000`2GH`00lil00?>O000H0?>O00`0oooo1@2N
I`020?NQ01/0lfl02@3oool20?NQ00H0YD/01@3cK`0B0?M`00`0oooo0`2[CP020?M`0080Zb`06`3c
?P080?ooo`L0/2d05P3g?`040?<>00h0oooo1P2e2`0F0?H>00`0oooo0`2j2`0;0?H>00030000003f
3P00mPh00080mPh01000000b0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool3000009d0oooo002b0?ooo`800000
6`3oool00`000000oooo0?ooo`050?ooo`80?g800P29n00305Ib0080^_L000@0KG8006IVIP1]LP00
joL0101bHP000`3gdP00LT/0079;0003079;00L0mj4000<000000?NQ003gX@003P3gX@020;[g00@0
Mgd000@0joL007eZ001mJP00OFX0403cc`0:0?OB00D0oooo1020QP020>_g0080QW806P3cc`080?oo
o`0308R?003[m`00joL000D0SgX05`3gdP0<0?ooo`<0Uh400P3gdP0J0?>O00d0oooo1@2NI`040?>O
0080mj405P3cK`090?ooo`030:E/003gX@00mj4000D0YD/02`3cK`0=0?M`00/0oooo102[CP020?M`
0080Zb`06P3c?P0:0?ooo`H0/2d05P3g?`0?0?ooo`<0mcl01P2e2`0F0?H>00/0oooo102j2`0;0?H>
00030000003f3P00mPh000H0mPh01000000^0?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000009`0oooo003>0?ooo`030000003oool0oooo00H0oooo0P0oLP0208Wh00<0EW8000<0
^_L006eb001VIVH00P1]LP000`3[m`00LV80079R0002079R00030?OB001bB`00LT/00080LT/01`3g
X@000`000000mj400?NQ000?0?NQ0080^_L0101gO@000`3[m`00OFX007eZ000F0???00D0mm800`3o
ool20;[g00@0P8H00P3[m`000`26LP00lll00???000I0???00L0oooo0P28S`020>_g00D0SgX05`3g
dP0<0?ooo`<0Uh401`3gdP0E0?>O00d0oooo102NI`090?>O0080mj404P3cK`090?ooo`030:E/003g
X@00mj4000@0YD/0403cK`090?M`00/0oooo102[CP020?M`00030://003c?P00lch001P0lch02`3o
ool60;0]01H0mcl03P3oool0102e;P00mcl00?Lo003g?`060;D;01H0mPh02P3oool50;X;00/0mPh0
00<000000?H>003f3P00203f3P020?ooo`@00000:P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo0000002L0?ooo`00cP3oool00`000000oooo0?ooo`050?ooo`<0?g800P29n00305Ib
00030;[g001]LP00IVIV0080KG8000<0joL0079R001bHP000P1bHP000`3gdP00LT/0079;0002079;
00L0mj400`00000?0?NQ0080^_L0101gO@000`3[m`00OFX007eZ000J0???00@0oooo0P2jm`040826
0080joL000<0QW800???003cc`00603cc`080?ooo`80R8l00P3[m`0508mj01L0mm802`3oool409N1
00`0mm803`3cW`0>0?ooo`@0WVL03@3cW`020?NQ00d0lfl02@3oool20:E/0080mj400`2UB`0F0?=_
00@0mg002P3oool50:]>0080mg006`3c?P0;0?ooo`H0/2d01@3c?P0A0?Lo00d0oooo0P2e;P030?Lo
00H0]@/01@3c3P0A0?H>00X0oooo1@2j2`0F0?H>00H0oooo1000000T0?ooo`<00000103oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`000000W03oool00<h0oooo00<000000?ooo`3oool01@3oool303mb0080ROP00`1F
LP000`2jm`00KG8006IVIP0206eb00040>_g001bHP00LV80079R0080mm80101bB`070?NQ00030000
003gX@00mj40008000003@3gX@020;[g00@0Mgd000<0joL007eZ003cc`006P3cc`030?ooo`0306F6
002jm`00^_L000@0P8H00P3[m`0K0???00L0oooo0`28S`020>_g00D0SgX05`3gdP0;0?ooo`@0Uh40
403gdP0;0?>O00`0oooo0P3gdP0309iW0180lil00P3gX@090?=_00P0oooo0`2UK0020?NQ00<0YD/0
6P3cK`090?ooo`H0Zdh01`3gL00E0?<n00`0oooo1@2`;@0:0?<n00d0mcl03@3oool20;D^00<0mcl0
1@2e2`0:0?<>00d0mPh02@3oool60;X;01H0mPh02P3oool5000000X0oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`030?ooo`<00000103oool3000000@0oooo0`00002M0?ooo`00c@3o
ool00`000000oooo0?ooo`050?ooo`@0?g800P29n00305Ib00030;[g001VIVH0KG800080KG8000@0
joL0079R001bHP00LV800P3cc`04079;00H0mj4000<0IVIV0000003gX@00403gX@000`2jm`00Mgd0
07Mm000307Mm00030>_g001mJP00lll001T0lll0103oool00`1UQP00^_L00;[g0004082600030>_g
003cc`00lll001T0lll0203oool308R?0080joL01@2?NP0G0?OB00/0oooo102GP@0E0?OB00D0lil0
303oool00`2NQ`00mm800?OB000309iW01H0lil00P3gX@040?=_00T0oooo0`2UK0020?NQ0080YD/0
6`3cK`090?ooo`H0Zdh0303gL00?0?<n00X0oooo0`3gL0040;0]0100lch0203g?`0<0?ooo`<0]Bh0
0`3g?`040;D;0100l`h0203f3P080?ooo`L0^P/05P3f3P0?0?ooo`@000001P3oool00`000000oooo
0?ooo`0e0?ooo`D000000P3oool3000000@0oooo0`0000040?ooo`<00000N`3oool008X0oooo1000
00040?ooo`@00000103oool3000000030?ooo`0000000000008000000P3oool200000080oooo0`00
00040?ooo`<000001@3oool305_o01<0oooo00<000000?ooo`3oool01@3oool403mb0080ROP00`1F
LP000`2jm`00IVIV06eb000206eb00040>_g001bHP00LV80079R0080lll0101bB`060?NQ000306IV
IP000000mj400100mj4000<0^_L007Mm001gO@000`1gO@000`3[m`00lll00???000I0???00<0oooo
0P1UQP020;[g00@0P8H01P3[m`0F0???00L0oooo1028S`020>_g00@0SgX0603gdP0;0?ooo`@0Uh40
5`3gdP0?0?ooo`0309j7003gdP00mm800080WVL06P3cW`0;0?ooo`@0YF`00P3gX@000`2UB`00lfl0
0?=_000I0?=_00X0oooo1P2[CP040?=_00`0mg002`3c?P090?ooo`040;1@003gL000mg000?M`00<0
/2d05@3c?P040?Lo00/0oooo102e;P030?Lo00@0]@/0503c3P040?H>00T0oooo1P2j2`050?<>0140
mPh03P3oool00`2n2`00mPh00?H>00020?H>00@000000P3oool00`000000oooo0?ooo`0g0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo07P0oooo002;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo1@1K
o`0A0?ooo`030000003oool0oooo00H0oooo100oLP0208Wh00<0EW8000<0IVIV06eb001]LP000P1]
LP000`3[m`00LV80079R00030???00@0LT/01@3gX@000`1VIVH0mj400000000@0?NQ000305im002j
m`00Mgd000@0Mgd06`3cc`040?ooo`80IHH00P2jm`04082600/0joL0403cc`080?ooo`@0R8l00P3[
m`0408mj00D0lll04`3gdP090?ooo`80joL0102GP@0G0?OB00h0oooo0P2NQ`020?OB0080WVL06P3c
W`0:0?ooo`D0YF`00P3gX@0K0?=_00/0oooo1@2[CP090?=_00d0mg001@3c?P090?ooo`80/5000`3g
L0030;0]01T0lch02`3oool40;D^00<0mcl00`2e2`0I0?<>00T0oooo1@2j2`0:0?<>00d0mPh03@3o
ool20;h;00P0mPh01000000h0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo07L0oooo002;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool705_o0100oooo00<000000?ooo`3oool01P3oool403mb0080ROP00`1FLP000`1VIVH0KG80
06eb000206eb00030>_g001bHP00LV8000<0lll0101bB`050?NQ000306IVIP3gX@0000000100mj40
00<0GWd00;[g001gO@00101gO@050>_g01H0lll00`3oool306F60080^_L01020QP0@0>_g00/0lll0
203oool408R?0080joL00`2?NP0;0???00h0mm80203oool00`2@U`00joL00>_g000409N101L0mm80
3@3oool309j70080mm8000<0WVL00?>O003cW`00603cW`0;0?ooo`D0YF`01P3gX@0G0?=_00T0oooo
0P3gX@040:]>00d0lfl02`3gL00<0?ooo`<0/5000`3gL0020;0]01X0lch02P3oool50;D^00<0mcl0
0P2e2`0J0?<>00T0oooo102j2`0@0?<>00P0mPh0303oool30;h;00X0mPh000<000000?H>00000000
1000000c0?ooo`030000003oool0oooo00<0oooo100000030?ooo`@000000`3oool4000007T0oooo
002;0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool400000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo1@0000020?ooo`L0Fol0
3`3oool00`000000oooo0?ooo`070?ooo`@0?g800P29n00205Ib000306IVIP2jm`00KG8000<0KG80
00<0joL0079R003cc`000`3cc`04079;00@0mj4000@0IVIV0?NQ003gX@000000403gX@000`1NO@00
^_L007Mm000407Mm00X0joL0403cc`040?ooo`<0IHH00P2jm`04082601D0joL01@3cc`090?ooo`@0
R8l00P3[m`0308mj0100lll02@3gdP080?ooo`03092G003[m`00joL000@0Uh405`3gdP0=0?ooo`<0
WXL00P3gdP0K0?>O00/0oooo1@2UK00:0?NQ0180lfl02@3oool00`2[L000mj400?NQ00040:]>0140
lfl01`3gL00<0?ooo`<0/5000`3gL0000`2`;@00lch00?<n000H0?<n00X0oooo1P2e;P030?Lo0080
]@/06@3c3P070?ooo`<0mcl0102j2`0D0?<>00@0mPh02`3oool40;h;00X0mPh000<000000?H>003f
3P00103f3P04000002l0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000N@3o
ool008/0oooo0`0000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P000002
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`0705_o00l0oooo00<000000?ooo`3oool01P3oool00`1Hn000?g8003mb000203mb000608Wh
001FLP00EW8005Ib001VIVH0^_L0101]LP000`3[m`00LV800???00030???00@0LT/0103gX@00101V
IVH0mj400?NQ0000000@0?NQ000305im002jm`00Mgd000@0Mgd03`3[m`0;0???00<0oooo101UQP02
0;[g00@0P8H0603[m`0;0?ooo`@0R8l00P3[m`0208mj01H0lll0103gdP070?ooo`80T9L00P3[m`04
09N101L0mm80303oool409j700H0mm805P3cW`0<0?ooo`D0YF`03P3gX@0=0?=_00T0oooo0P2[L002
0?NQ00<0Zdh05P3cK`030?M`00/0oooo102`D0030?M`01X0lch02`3oool60;D^00<0mcl000<0]@/0
0?<>003c3P005`3c3P070?ooo`040;X`003g?`00mcl00?Lo00<0^P/06@3c3P0;0?ooo`@0_P/02P3f
3P000`000000mPh00?H>00080?H>00@00000:`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo0000001i0?ooo`00R`3oool01@000000oooo0000003oool000000080oooo00<000000?oo
o`0000000P0000020?ooo`@000000P3oool00`000000oooo00000002000000@0oooo0`0000040?oo
o`<00000103oool505_o00`0oooo0P0000020?ooo`030000003oool0oooo00H0oooo00<0F?P003mb
000oLP000P0oLP001P29n000EW8005Ib001VIVH0EW800;[g00@0KG8000<0joL00???003cc`000`3c
c`04079;00<0mj4000D0IVIV0?NQ003gX@00mj400000000@0?NQ0080^_L0101gO@0E0>_g00D0lll0
103oool406F60080^_L01020QP050>Oc01<0joL02@3oool20;[g00@0R8l00P3[m`0208mj01X0lll0
1`3oool2092G0080joL0102GP@0G0?OB00/0oooo1@2NQ`0:0?OB0180lil0303oool50:E/00D0lil0
3@3gX@090?=_00T0oooo0P2[L0020?NQ0080Zdh06P3cK`0:0?ooo`D0/5001`3gL00F0?<n00/0oooo
1P2e;P030?<n01X0l`h01P3oool20;X`00<0mcl00P2j2`0J0?<>00X0oooo1@2n2`0:0?H>00030000
003f3P00mPh000T0mPh00`3oool4000002L0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000N@3oool008/0oooo00D000000?ooo`3oool0oooo0000000W0?ooo`<0Fol03`3oool3
000000L0oooo00<0:78005Sh000oLP000`0oLP001P29n000EW8005Ib001VIVH0EW800;[g00@0KG80
00<0joL00???003cc`000`3cc`04079;00<0mj4000D0IVIV0?NQ003gX@00mj400000000@0?NQ0080
^_L0101gO@050>Oc01<0joL01P3oool406F60080^_L00`20QP0;0>Oc00h0joL0203oool00`1/S`00
^_L00;[g000408R?0080joL000<0SgX00???003cc`006@3cc`060?ooo`<0T9L00P3[m`0409N100D0
lll04P3gdP0;0?ooo`D0WXL03P3gdP0=0?>O00X0oooo00<0YHd00?OB003gdP00102UK00;0?>O00`0
mj40103cK`090?ooo`<0Zg000P3gX@020:]>01X0lfl02@3oool60;1@00/0mg004@3c?P0<0?ooo`D0
]Bh02@3c?P0D0?<>00H0oooo0`2j<0030?Lo0080^P/06@3c3P0:0?ooo`H0_P/05P3f3P070?ooo`@0
00003@3oool00`000000oooo0?ooo`0A0?ooo`<00000103oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000N@3o
ool008X0oooo1P00000j0?ooo`040000003oool00000000000D0oooo00<0:78005Sh000oLP000`0o
LP001P29n000EW8005Ib001VIVH0EW800;[g00@0KG801P3cc`04079;0080mj4000<0IVIV0?NQ003g
X@000P3gX@000`000000mj400?NQ000>0?NQ0080^_L00`1gO@0;0>Oc00h0joL01P3oool406F60080
^_L00`20QP0?0>Oc00X0joL0203oool00`1/S`00^_L00;[g000408R?0080joL000<0SgX00???003c
c`00603cc`070?ooo`<0T9L00P3[m`0309N100/0lll03@3gdP0;0?ooo`D0WXL04P3gdP090?>O00T0
oooo0P2US@020?OB00@0YF`03`3cW`090?NQ00/0oooo102[L0020?NQ00030:]>003cK`00lfl001P0
lfl02`3oool50;1@00h0mg003@3c?P0:0?ooo`<0mg00102e;P0>0?<n00l0l`h01`3oool30;X`00<0
mcl000<0^P/00?<>003c3P005`3c3P0:0?ooo`L0_P/05P3f3P0;0?ooo`D00000203oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<00000103oool3000000X0
oooo1@0000030?ooo`<00000103oool3000000@0oooo0`00001G0?ooo`00b@3oool00`000000oooo
0?ooo`060?ooo`80:78000<0F?P003mb000oLP000P0oLP000`29n000EW8006IVIP0205Ib00030;[g
001]LP00KG800080KG801@3[m`000`3cc`00LT/0079;0002079;0080mj4000<0IVIV0?NQ003gX@00
0P3gX@000`000000mj400?NQ000>0?NQ0080^_L00`1gO@0?0>Oc00X0joL01P3oool406F60080^_L0
0P20QP0E0>Oc00D0joL01`3oool206b?0080^_L01028S`020>_g01/0lll01P3oool4092G0080joL0
0`2GP@0?0???00T0mm802`3oool509j701H0mm80103cW`0:0?ooo`80YHd00P3gdP030:E/01D0lil0
103gX@0;0?ooo`@0Zg000P3gX@0K0?=_00/0oooo1@2`D00B0?M`00T0lch02@3oool0102eDP00mg00
0?M`003gL0030;D^01@0lch02P3c3P060?ooo`@0^S000`3g?`0J0?<>00/0oooo1P2n2`0F0?H>00h0
oooo0P3f3P04000000@0oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000005H0oooo00390?ooo`030000003oool0oooo00H0oooo0P0X
LP00101Hn000?g8003mb000oLP0208Wh000505Ib001VIVH0EW8005Ib002jm`000`1]LP060>_g00D0
LT/00P3gX@000`1VIVH0mj400?NQ00020?NQ00030000003gX@00mj4000h0mj400P2jm`0207Mm01D0
io<01@3[m`040?ooo`80ROP0101UQP020;[g00030826003Wl`00io<001P0io<0203oool206b?0080
^_L01028S`060>_g01H0lll01P3oool5092G0080joL00P2GP@0E0???00@0mm802`3oool509j701H0
mm803@3oool30:F=0080mm800P2UK00J0?>O00X0oooo1@2[L0070?NQ01D0lfl0303oool50;1@01H0
mg00103c?P090?ooo`80]E800`3gL0030;D^01P0lch01@3c3P060?ooo`D0^S00203g?`0D0?<>00`0
oooo1P2n2`0F0?H>00d0oooo00<0`P/00?H>003f3P00103f3P05000003L0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000EP3oool00<P0oooo00<000000?ooo`3oool01P3oool3
02Qb000405Sh000oLP00?g8003mb0080ROP000D0IVIV05Ib001FLP00EW800;[g000306eb00D0i_<0
00<0joL0079;001bB`000`1bB`000`3gX@00IVIV0?NQ00040?NQ00030000003gX@00mj4000h0mj40
0P2jm`0207Mm01T0io<01@3oool208Wh00@0IHH00P2jm`000`20QP00io<00>Oc000H0>Oc00L0oooo
0`1/S`020;[g00@0R8l02P3[m`0B0???00H0oooo1@2@U`020>_g000309N1003cc`00lll001P0lll0
203oool30>_g00D0WXL05P3gdP0=0?ooo`<0YHd00P3gdP020:E/01X0lil02@3oool60:]`00`0mj40
3`3cK`0=0?ooo`D0/5001@3cK`0B0?M`00`0oooo0P2eDP030?M`0080]Bh06P3c?P090?ooo`H0^S00
303g?`0?0?<>00d0oooo1P2n2`0F0?H>00`0oooo0P322`0:0?H>00@00000=@3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo0000001F0?ooo`00b03oool00`000000oooo0?ooo`060?oo
o`<0:78000@0F?P003mb000oLP00?g800P29n0001@1VIVH0EW8005Ib001FLP00^_L000<0KG801P3V
l`05079;00030?NQ001VIVH0mj4000@0mj4000<000000?NQ003gX@003P3gX@020;[g000307Mm003W
l`00io<001P0io<0103oool00`1:QP00ROP008Wh000406F60080^_L06`3Wl`070?ooo`<0K8l00P2j
m`0408R?00h0joL03@3cc`070?ooo`D0T9L00P3[m`000`2GP@00lll00???000H0???00P0oooo0`3[
m`0509j701H0mm80303oool40:F=0080mm8000<0YF`00?>O003cW`00603cW`0:0?ooo`H0Zg00403g
X@0;0?=_00X0oooo0`3gX@040;1@00/0lfl03@3gL00;0?ooo`<0]E800`3gL0000`2e;P00lch00?<n
000H0?<n00T0oooo1`2j<00A0?Lo00X0l`h03@3oool60;h;01H0mPh02`3oool30<8;00/0mPh000<0
00000?H>003f3P001000000b0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo
0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0E03oool006l0
oooo0`000000103oool000000000000000020?ooo`<0000000@0oooo0000003oool0oooo0`000005
0?ooo`<000000P3oool4000000@0oooo0`0000000`3oool000000?ooo`06000000030?ooo`000000
000000<000000`3oool3000000030?ooo`000000oooo0080oooo0`0Xo`0D0?ooo`030000003oool0
oooo00D0oooo100XLP001P1Hn000?g8003mb000oLP00ROP006IVIP<0EW800P2jm`0206eb00L0i_<0
1@1bB`000`1VIVH0mj400?NQ00040?NQ00030000003gX@00mj4000h0mj400P2jm`000`1gO@00io<0
0>Oc000H0>Oc00@0oooo00<0BXH008Wh0029n000101UQP000`2jm`00io<00>Oc000I0>Oc00L0oooo
101/S`020;[g00@0R8l01@3Wl`0=0>_g00T0lll01`3oool5092G0080joL06P3cc`080?ooo`0409NN
003[m`00joL00>_g00D0WXL05P3gdP0<0?ooo`@0YHd00P3gdP0J0?>O00/0oooo1P2[L00E0?NQ00D0
lfl02P3oool0102`L`00mj400?NQ003gX@040;1@00l0lfl02@3gL00:0?ooo`@0]E800`3gL00J0?<n
00/0oooo1P2j<00E0?Lo00D0l`h02P3oool0102n<@00mcl00?Lo003g?`060;h;01H0mPh02`3oool3
0<8;00/0mPh000<000000?H>003f3P00103f3P05000002X0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo0000001F0?ooo`00L03oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool502So0180oooo00<000000?ooo`3oool01P3oool402Qb
000605Sh000oLP00?g8003mb0029n000IVIV0`1FLP020;[g0080KG801`3Vl`05079;000306IVIP3g
X@00mj4000@0mj4000<000000?NQ003gX@003P3gX@020;[g01X0io<0103oool204Z60080ROP0101U
QP050;[g01L0io<01P3oool506b?0080^_L00`28S`0;0>Oc00`0joL0103cc`080?ooo`D0T9L000<0
joL00???003cc`006@3cc`080?ooo`0409NN003[m`00joL00>_g00D0WXL01@3cc`0A0?OB00/0oooo
1@2US@070?OB01@0lil0303oool60:]`00D0lil04@3gX@0=0?ooo`80/7<00`3gX@030;1@01D0lfl0
103gL00:0?ooo`@0]E801`3gL00F0?<n00/0oooo1P2j<0050?<n0140mcl03@3oool20;ha00<0mcl0
1P2n2`050?<>0140mPh02P3oool40<8;00/0mPh000<000000?H>003f3P00203f3P000`3oool00000
00000002000002H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
001F0?ooo`00L03oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000060?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`L0:?l04@3oool00`000000oooo0?ooo`06
0?ooo`@0:78000H0F?P003mb000oLP00?g8006IVIP29n00305Ib0080^_L000<0KG800>Kc003Vl`00
1P3Vl`04079;000306IVIP3gX@00mj4000@0mj4000<000000?NQ003gX@003`3gX@000`2jm`00io<0
0>Oc000I0>Oc00@0oooo0P1:QP0208Wh00@0IHH02@2jm`0B0>Oc00L0oooo1@1/S`020;[g00<0R8l0
3`3Wl`090>_g00T0oooo0P2jm`05092G00D0joL05P3cc`080?ooo`80Uih00`3[m`0409j700X0lll0
3@3gdP0:0?ooo`H0YHd02`3gdP0@0?>O00`0oooo1@2[L00:0?>O00d0mj403@3oool20;1c00<0mj40
0P2`D00J0?=_00T0oooo1@2eDP0;0?M`0140lch0303oool50;X`00X0lch03@3g?`0<0?ooo`<0_S40
0`3g?`050;h;00X0l`h03@3f3P090?ooo`D0`P/05P3f3P050?ooo`@000008P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000005H0oooo001`0?ooo`D000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo0`0000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool4000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`@000000P3oool702So0100oooo00<000000?ooo`3oool01`3oool402Qb000605Sh000o
LP00?g8003mb001VIVH0ROP00`1FLP020;[g000306eb003Vl`00i_<000H0i_<0101bB`000`1VIVH0
mj400?NQ00040?NQ00030000003gX@00mj4000l0mj401P2jm`0E0>Oc00@0oooo0`1:QP0208Wh00@0
IHH03@2jm`0>0>Oc00L0oooo1@1/S`020;[g0080R8l05@3Wl`040>_g00P0oooo00<0LIL00;[g002j
m`001@2@U`090>_g0180lll0203oool209NN00<0joL0102NQ`0?0???00P0mm802P3oool60:F=0100
mm802P3cW`0;0?ooo`80mm80102[L00@0?>O00P0mj40303oool30;1c00<0mj400P2`D00J0?=_00P0
oooo1P2eDP0>0?M`00d0lch03@3oool40;X`0100lch0203g?`0<0?ooo`<0_S400`3g?`040;h;0100
l`h0203f3P080?ooo`H0`P/01@3d3P0A0?H>00T0oooo1000000;0?ooo`030000003oool0oooo0140
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`00001G0?ooo`00L@3oool00`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0:?l0403oool00`000000oooo0?ooo`070?ooo`@0:78000H0F?P003mb000oLP00?g8006IVIP29
n00305Ib0080^_L02@3Vl`03079;000306IVIP3bWP00lYh000<0lYh00P3gX@000`000000mj400?NQ
000?0?NQ00/0^_L0403Wl`040?ooo`<0BXH00P29n00406F60140^_L02@3Wl`080?ooo`D0K8l00P2j
m`0208R?01T0io<0203oool00`1aU`00^_L00;[g0005092G00d0joL03@3cc`080?ooo`<0Uih00`3[
m`0309j701@0lll0103gdP0:0?ooo`H0YHd0503gdP050?>O00/0oooo00<0Zi800?OB003gdP000`2[
L00E0?>O00@0mj402`3oool40;1c00<0mj4000<0/5000?=_003cK`00603cK`0:0?ooo`D0]E804P3g
L0090?<n00X0oooo0`3gL0040;X`01@0lch0103g?`0;0?ooo`@0_S400`3g?`040;h;01@0l`h0103f
3P070?ooo`H0`P/02P3d3P0=0?H>00d0oooo1@0000060?ooo`030000003oool0oooo0800oooo001a
0?ooo`030000003oool000000080oooo0P0000020?ooo`8000000`3oool3000000<0oooo1@000002
0?ooo`030000003oool00000008000000P3oool4000000D0oooo00<000000?ooo`3oool00P3oool3
000000@0oooo100000040?ooo`D0:?l0303oool200000080oooo00<000000?ooo`3oool01P3oool2
02Oh00<0:78000D0F?P003mb000oLP00?g8006IVIP0208Wh00@0000000@0^_L00>Kc003Vl`00i_<0
0`0000030>Kc00<0LT/000<0IVIV0?:N003bWP001@3bWP000`000000lYh00?:N000?0?NQ0100^_L0
2P3Wl`040?ooo`@0BXH00P29n00306F601H0^_L01@3Wl`080?ooo`D0K8l00P2jm`000`28S`00io<0
0>Oc000H0>Oc00L0oooo0P1aU`020;[g00@0T9L04P3[m`090???00P0oooo0`2GWP030>_g00<0WXL0
603cc`0:0?ooo`H0YHd05P3gdP0=0?ooo`80Zi800P3gdP030:]`01T0lil02`3oool40;1c00<0mj40
6P3cK`0;0?ooo`D0]E801@3cK`0A0?M`00@0lch02P3oool0102jE000mg000?M`003gL0030;X`01T0
lch02P3oool50;ha00<0mcl00`2n2`0I0?<>00L0oooo1@322`0@0?@>00P0mPh03@3oool00`352`00
mPh00?H>00020?H>00@000000P3oool00`000000oooo0?ooo`200?ooo`00LP3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool302So00l0oooo
100000070?ooo`809oP00`0XLP001`1Hn000?g8003mb000oLP00IVIV08Wh000000000`1FLP001@2j
m`0000000>Kc003Vl`00000000<0i_<000<000000>Kc003Vl`000`1bB`000`1VIVH0lYh00?:N0005
0?:N00030000003bWP00lYh000D0lYh02P3gX@0E0;[g00D0io<0103oool404Z60080ROP00`1UQP04
0;Oc01@0^_L02@3oool208Wh00D0K8l00P2jm`000`28S`00io<00>Oc000G0>Oc00L0oooo0`1aU`02
0;[g00@0T9L0103Wl`0B0>_g00@0lll0203oool409NN00<0joL00P2NQ`0I0???00X0oooo1P2US@0F
0?OB00`0oooo0`2[TP020?OB0080Zg006P3cW`0:0?ooo`D0/7<0203gX@0D0?=_00`0oooo102eDP0;
0?=_00d0mg00303oool20;YD00<0mg000P2j<00J0?<n00X0oooo1@2n<@030?Lo0080_P/06P3c3P07
0?ooo`@0`P/05@3d3P040?H>00`0oooo0P352`080?H>00@00000P@3oool00700oooo0`00000C0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool09P3oool010000000oooo000000000004
0?ooo`03019b000Wn0009oP000<0:78000D0F?P003mb000oLP00IVIV03mb000208Wh00<0EW8000H0
^_L00000002jm`00^_L00000002jm`020>Kc00030000003Vl`00i_<00080LT/000<0IVIV0?:N003b
WP001P3bWP000`000000lYh00?:N000:0?:N00D0mj40602jm`060?ooo`@0BXH00P29n00306F600P0
]o<0402jm`080?ooo`0304n?0029n000ROP000D0K8l00P2jm`0J0>Oc00L0oooo0`1aU`020;[g00<0
T9L02@3Wl`0?0>_g00/0oooo102GWP030>_g0080WXL0603cc`090?ooo`80joL01P2US@0F0?OB00`0
oooo0`2[TP020?OB00030:]`003cW`00lil001P0lil02P3oool60;1c00`0mj40403cK`0<0?ooo`@0
]E803`3cK`090?M`00/0oooo0`2jE0030?M`0080^S006@3c?P0:0?ooo`H0_S400`3g?`020;h;01T0
l`h0203oool30<8;01X0m0h02`3oool30<D;00X0mPh000<000000?H>000000000`00001m0?ooo`00
VP3oool3000000H0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`060?ooo`03019b
000Wn0009oP000<0:78000D0F?P003mb000oLP00IVIV03mb000208Wh00<0EW8000D0^_L00000002j
m`00^_L0000000030;[g00030000002jm`00^_L00080LT/000<0IVIV0?:N003bWP001P3bWP000`00
0000lYh00?:N000>0?:N000305im002jm`00^_L001H0^_L01P3oool404Z60080ROP00P1UQP0=0;Oc
00`0^_L0203oool00`1?S`00ROP008Wh000506b?00030;[g003Wl`00io<001P0io<01`3oool4076G
0080^_L00`2@U`0=0>Oc00/0joL02`3oool409NN00<0joL000<0WXL00???003cc`005`3cc`080?oo
o`0309fU003[m`00joL000H0YHd0103cc`0B0?OB00/0oooo102[TP020?OB01/0lil02P3oool60;1c
0140mj402P3cK`0:0?ooo`<0mj400`2eDP0E0?=_00@0mg002`3oool30;YD00<0mg0000<0^S000?<n
003c?P005`3c?P0:0?ooo`L0_S400`3g?`000`2n2`00l`h00?<>000G0?<>00T0oooo0P322`0K0?@>
00X0oooo10352`0:0?H>00030000003f3P00mPh000<0mPh01000001i0?ooo`00S`3oool300000380
oooo00<000000?ooo`3oool01P3oool00`0BLP009oP002Oh000302Qb000305Sh000oLP00IVIV0080
?g8000<0ROP005Ib000000000`0000030;[g00050000002jm`00^_L00;[g000000000P2jm`000`1b
B`00IVIV0?:N00080?:N00030000003bWP00lYh000h0lYh000<0GWd00;[g002jm`005P2jm`040?oo
o`80F?P0101:QP0208Wh0080IHH04@2gl`080;[g00L0oooo0P1?S`0208Wh00@0K8l01`2jm`0E0>Oc
00H0oooo1@1aU`020;[g0080T9L04P3Wl`070>_g00/0oooo102GWP030>_g01T0lll02@3oool00`2M
Y@00joL00>_g00050:F=00T0lll03P3gdP0:0?ooo`D0Zi801P3gdP0F0?>O00/0oooo1P2`L`050?>O
0100mj401@3cK`0:0?ooo`040;Ef003gX@00mj400?NQ0080]E806P3cK`0:0?ooo`@0^U@00`3gL00J
0?<n00X0oooo1`2n<@030?<n01T0l`h01`3oool01032<P00mcl00?Lo00322`0K0?@>00/0oooo1035
2`0:0?H>00030000003f3P00mPh000L0mPh01@00001d0?ooo`00TP3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo00H0oooo0P0BLP0202Oh00<0:78000<0F?P003mb001VIVH00P0oLP00
0`29n000EW800000000205Ib00@0^_L000D000000;[g002jm`00^_L0000000020;[g0003079;001V
IVH0lYh000P0lYh000<000000?:N003bWP003P3bWP000`1NO@00^_L00;[g000F0;[g00@0oooo0P1H
n00404Z60080ROP000<0IHH00;Oc002gl`00502gl`040;[g00L0oooo0P1?S`0208Wh00@0K8l01@2g
l`070;[g00l0io<01`3oool5076G0080^_L00P2@U`0F0>Oc00<0joL0203oool30;[g00@0Uih0203[
m`0D0???00P0oooo0P2MY@020>_g00@0YHd03@3cc`0;0?OB00T0oooo1P2[TP0:0?OB0180lil02`3o
ool50;1c00X0lil03@3gX@0=0?ooo`80]GH00`3gX@020;EB01X0lfl02@3oool50;YD00P0mg00503c
?P0;0?ooo`H0_S402@3c?P0D0?<>00H0oooo0P32<P020?Lo01/0m0h02`3oool50<D;00X0mPh000<0
00000?H>003f3P00203f3P040?ooo`@00000L03oool00980oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`060?ooo`804W800P0Wn00302Qb000305Sh000oLP00IVIV0080?g8000<0ROP0
05Ib000000000P1FLP040;[g00050000002jm`00^_L00;[g000000000P2jm`000`1VIVH0lYh00?:N
00080?:N008000003P3bWP000`1NO@00^_L00;[g000G0;[g00<0oooo00<0<8H005Sh001Hn000101:
QP0208Wh000306F6002gl`00]o<001P0]o<01P3oool304n?0080ROP00`1/S`0;0;Oc00H0^_L02`3W
l`070?ooo`D0LIL00P2jm`000`2@U`00io<00>Oc000H0>Oc00P0oooo0`2jm`0409NN00`0joL03`3c
c`080?ooo`<0WJD00P3[m`040:F=0140lll01`3gdP0:0?ooo`D0Zi803P3gdP0=0?>O00X0oooo0P3g
dP040;1c0100lil0203gX@0<0?ooo`<0]GH00`3gX@000`2eDP00lfl00?=_000H0?=_00T0oooo1P2j
E00<0?M`00l0lch0303oool50;ha00h0lch03`3c3P060?ooo`<0`S801`3g?`0E0?@>00/0oooo1P35
2`050?@>0100mPh0203oool4000000`0oooo00<000000?ooo`3oool0G@3oool004P0oooo0`000002
0?ooo`<000000P3oool2000000030?ooo`000000000000<00000103oool3000000<0oooo0`000004
0?ooo`<0000000<0oooo0000003oool01`3oool300000080oooo0P0000000`3oool0000000000003
000000040?ooo`000000000000000080oooo0P0000020?ooo`@000000`3oool3000000040?ooo`00
0000oooo0?ooo`<000000P3oool2000000030?ooo`000000oooo008000000`3oool3003o2Q<0oooo
00<000000?ooo`3oool01P3oool3019b00809oP00`0XLP000`1Hn000IVIV03mb000203mb000308Wh
001FLP0000000080EW80102jm`0020000000^_L00;[g002jm`0000000;[g003bWP00IVIV2P3bWP00
0`000000lYh000000002000000/0lYh000<0GWd00;Oc002gl`000P2gl`0E0;[g00<0oooo00<0<8H0
05Sh001Hn000101:QP0208Wh01/0]o<01P3oool304n?0080ROP00`1/S`0?0;Oc00L0^_L01@3Wl`08
0?ooo`D0LIL00P2jm`000`2@U`00io<00>Oc000H0>Oc00L0oooo00@0Mih00;[g002jm`00^_L0102G
WP0A0>_g00X0lll0203oool309fU0080joL00`2US@0F0???00<0mm802P3oool50:^B0180mm802@3c
W`090?ooo`030;2F003gdP00mm8000@0/7<0503cW`040?NQ00`0oooo0`2eMP030?NQ01X0lfl02P3o
ool60;YD0140mg002P3c?P090?ooo`030;iF003gL000mg0000@0_S404`3c?P0:0?<>00H0oooo1032
<P0;0?Lo0100m0h02`3oool60<D;00X0m0h0303f3P0<0?ooo`@00000203oool00`000000oooo0?oo
o`1M0?ooo`00A`3oool2000000030?ooo`00000000000080oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo1@00o`XB
0?ooo`030000003oool0oooo00H0oooo0`0BLP0202Oh00<0:78000<0F?P006IVIP0oLP000P0oLP00
0`29n000EW8000000004000000<0^_L00`0000020;[g000306IVIP2jm`00^_L00080^_L01`3bWP00
0`000000lYh00?:N00020?:N00800000203bWP0205im00P0]o<04@2jm`020?ooo`80<8H00P1Hn004
04Z60080ROP06P2gl`060?ooo`@0Chl00P29n00206b?01D0]o<01@2jm`0:0?ooo`D0LIL00P2jm`0J
0>Oc00P0oooo00@0Mih00;[g002jm`00^_L0102GWP0E0>_g00D0lll0203oool409fU0080joL00P2U
S@0J0???00X0oooo1@2[TP0F0?OB00@0lil02@3oool20;2F0080mm800`2`L`0I0?>O00/0oooo102e
MP070?NQ01H0lfl02P3oool60;YD00D0lfl0403gL0050?<n00T0oooo0P2nEP020?M`00<0_S40603c
?P050?<>00L0oooo1032<P0@0?Lo00X0m0h0303oool50<D;00l0m0h0203f3P0>0?ooo`030<P<003f
3P00000000<00000103oool00`000000oooo0?ooo`1M0?ooo`00A`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00002P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool000000?oo
o`0000000P3oool7003o2Q40oooo00<000000?ooo`3oool01P3oool3019b00809oP00`0XLP00101V
IVH0?g8003mb000oLP0208Wh00@0EW802P2jm`000`1VIVH0^_L00;[g00060;[g00<0lYh000<00000
0?:N003bWP00303bWP000`1NO@00]o<00;Oc000;0;Oc00d0^_L00P3oool203260080F?P0101:QP00
0`29n000]o<00;Oc000I0;Oc00H0oooo101?S`0208Wh0080K8l06@2gl`090?ooo`80ROP01@1aU`00
0`2jm`00io<00>Oc000I0>Oc00L0oooo0P1gWP030;[g00@0Uih01@3Wl`0B0>_g00X0oooo1@2MY@02
0>_g0080YHd06P3cc`0:0?ooo`D0Zi805P3gdP0=0?ooo`80/9H00P3gdP020;1c01X0lil02P3oool5
0;Ef00/0mj404@3cK`0;0?ooo`D0^U@02P3cK`0=0?M`00`0oooo0`2nEP020?M`0080_S406P3c?P0:
0?ooo`D0`S80503g?`050?@>00d0oooo10352`0D0?@>00@0mPh03@3oool20<P<00D0mPh01@00001O
0?ooo`00A`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool500000080oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`<000001P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000
003oool000000080oooo1`00o`X@0?ooo`030000003oool0oooo00L0oooo0`0BLP0202Oh00<0:780
00@0IVIV03mb000oLP00?g800P29n00405Ib00T0^_L000<0IVIV0;[g002jm`002P2jm`000`000000
lYh00?:N000<0?:N000305im002gl`00]o<000l0]o<02@2jm`00103oool0<8H00326000`QP0205Sh
00@0BXH01P29n00E0;Oc00L0oooo101?S`0208Wh000306b?002gl`00]o<001P0]o<0203oool00`1C
U`00ROP008Wh0005076G00H0^_L05@3Wl`080?ooo`80Mih00`2jm`0309NN00/0io<03@3[m`0:0?oo
o`D0WJD00P3[m`000`2US@00lll00???000H0???00P0oooo0`3[m`050:^B00D0lll04@3gdP0<0?oo
o`<0/9H00P3gdP020;1c01T0lil02P3oool60;Ef00h0mj403@3cK`0<0?ooo`@0^U@0403cK`080?M`
00`0oooo0`2nEP020?M`00030;ha003c?P00lch001P0lch02P3oool60<8b01D0mcl04@3oool30<D;
01T0m0h0303oool30<P<00X0mPh01000001K0?ooo`00A`3oool01@000000oooo0?ooo`3oool00000
0080oooo0P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000X0oooo0P0000070?ooo`030000003oool0oooo0080oooo0P0000020?ooo`040000003o
ool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?oo
o`080000003oool0oooo0000003oool000000?ooo`0000020?ooo`L00?l:403oool00`000000oooo
0?ooo`070?ooo`<04W800P0Wn00202Qb000306IVIP1Hn000?g800080?g800P29n00405Ib00T0^_L0
00<0IVIV0;[g002jm`002P2jm`001@000000^_L002Oh000Wn000;7d000T0lYh000<0GWd00;Oc002g
l`00502gl`050;[g00040?ooo`0`QP00<8H003260080F?P00`1:QP0<08Wh00l0]o<0203oool404n?
0080ROP000<0K8l00;Oc002gl`005`2gl`090?ooo`0305>G0029n000ROP000D0LIL02`2jm`0?0>Oc
00P0oooo0`1gWP030;[g00<0Uih03`3Wl`090>_g00X0oooo1@2MY@020>_g01/0lll01`3oool0102R
Z`00joL00>_g003[m`040:^B00X0lll03@3gdP0;0?ooo`@0/9H00P3gdP000`2`L`00lil00?>O000H
0?>O00X0oooo1P2eMP0B0?NQ00T0lfl02@3oool30?NQ00@0^U@0503cK`040?M`00/0oooo102nEP02
0?M`01X0lch02P3oool70<8b01D0mcl04@3oool20<D;01X0m0h02`3oool40<P<00X0mPh000@00000
0?H>003f3P00mPh01000001G0?ooo`00A`3oool020000000oooo0?ooo`3oool000000?ooo`000000
oooo0`0000030?ooo`<00000103oool5000000<0oooo0`0000040?ooo`@000002P3oool00`000000
oooo000000040?ooo`<000000`3oool00`000000oooo00000002000000@0oooo0`000000103oool0
00000?ooo`3oool4000000<0oooo0`0000020?ooo`<0000000<0oooo0000003oool00`3oool5003o
2Q00oooo00<000000?ooo`3oool01P3oool2003h2@<04W8000H09oP002Qb000XLP00:78006IVIP1H
n00303mb0080ROP00`1FLP0:0;[g000306IVIP2jm`00^_L000X0^_L000@000000;[g000Wn0009oP0
0`0/O@000`1Hn000AGd00?:N00040?:N000305im002gl`00]o<001P0]o<000<0oooo0326000`QP00
0P0`QP0205Sh00<0BXH01@27l`0;08Wh00/0]o<0203oool404n?0080ROP06P2gl`080?ooo`80DiL0
0P29n004076G0100^_L02`3Wl`080?ooo`<0Mih00`2jm`0209NN01D0io<0103[m`0:0?ooo`D0WJD0
1`3[m`0E0???00P0oooo00@0XZ/00>_g003[m`00joL0102[TP0?0???00P0mm802`3oool40;2F0080
mm806P3cW`0;0?ooo`H0]GH05P3gX@040?=_00T0oooo00@0^WT00?NQ003gX@00mj400`2jE00I0?=_
00X0oooo1@2nEP070?M`01@0lch02`3oool70<8b00D0lch0403g?`0>0?ooo`<0mcl000<0a@/00?@>
003d3P00603d3P0<0?ooo`@0b0`02P3f3P000`000000mPh00?H>00050?H>00@00000D`3oool004L0
oooo00D000000?ooo`3oool0oooo0000000A0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0203oool010000000oooo0?ooo`00000L0?ooo`030000003oool0oooo0100oooo0`00o`X=
0?ooo`D000001`3oool00`00LP@00?P9003h2@03019b000402Oh000XLP00:78006IVIP80F?P00`0o
LP0208Wh00<0EW80102flP050;[g000306IVIP2jm`00^_L000/0^_L000@000000;[g000Wn0009oP0
0`0/O@000`1Hn000AGd004Em000304Em000308Wh002gl`00]o<001T0]o<000<0oooo0326000`QP00
0P0`QP0205Sh00<0BXH02P27l`0;08Wh00D0]o<01`3oool205Sh00@0Chl01`29n00D0;Oc00T0oooo
0P1CU`0208Wh00@0LIL01@2gl`0@0;[g00D0io<0203oool407NN00<0^_L000<0Uih00>Oc003Wl`00
603Wl`0:0?ooo`D0WJD0303[m`0?0???00P0oooo0P2RZ`030>_g00<0Zi80503cc`040?OB00X0oooo
1@2`UP070?OB01D0lil02`3oool60;Ef00D0lil04@3gX@0<0?ooo`80^WT00`3gX@020;YD01X0lfl0
2P3oool50;iF00/0mg00403c?P0;0?ooo`H0`S802P3c?P0<0?Lo00d0oooo00@0aC800?Lo003g?`00
mcl06P3d3P0<0?ooo`D0b0`02P3f3P000`000000mPh00?H>00080?H>00030?ooo`000000000000<0
0000CP3oool004H0oooo0`000000103oool0000000000000000@0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool01`3oool3000000030?ooo`000000000001/0oooo00<000000?ooo`3o
ool08`3oool5000000@0oooo00<00784003h2@00n0T00`0BLP00100Wn000:78002Qb001VIVH205Sh
00<0?g800P29n00305Ib00P0]_8000<0^_L006IVIP2jm`00302jm`0010000000^_L002Oh000Wn003
02am000305Sh0015O@00AGd000<0AGd000<0ROP00;Oc002gl`00602gl`020?ooo`@0<8H00P1Hn002
04Z600l0Qo<02P29n0080?ooo`0303>?001Hn000F?P000@0Chl03029n00?0;Oc00P0oooo0`1CU`02
08Wh00@0LIL02P2gl`0=0;[g00/0oooo101gWP030;[g000309NN003Wl`00io<001P0io<0203oool2
0;[g00D0WJD0403[m`0;0???00L0oooo0`2RZ`030>_g00<0Zi80603cc`090?ooo`H0/9H0303gdP0?
0?>O00`0oooo1@2eMP0:0?>O00d0mj402`3oool30;Yi00<0mj400P2jE00I0?=_00X0oooo1P2nEP0@
0?M`00X0lch0303oool50<8b00l0lch0203g?`0<0?ooo`80aC80203g?`0D0?@>00`0oooo1P38300E
0?H>00H0oooo1000001:0?ooo`00E`3oool00`000000oooo0?ooo`0C0?ooo`8000004`3oool00`00
0000oooo0?ooo`0C0?ooo`8000009@3oool00`000000oooo0?ooo`050?ooo`8007840P00n0T2019b
00809oP00P0XLP000`1VIVH0F?P005Sh000303mb0080ROP00P1FLP090;Kb000406IVIP2flP00]_80
0;Kb00/0^_L000@000000;[g000Wn0009oP00`0/O@000`1Hn000AGd004Em000304Em01/0]o<00P3o
ool403260080F?P00P1:QP0D08Oc00D0ROP0203oool00`0cS`00F?P005Sh000404n?0100ROP02P2g
l`090?ooo`<0DiL00P29n003076G00l0]o<02@2jm`0;0?ooo`@0Mih00`2jm`0J0>Oc00P0oooo00<0
O:D00;[g002jm`001@2MY@0E0>_g00D0lll0203oool30::[00<0joL00P2[TP0I0???00X0oooo1@2`
UP0@0?OB00/0lil02@3oool00`2eVP00mm800?OB00040;Ef0100lil0203gX@0;0?ooo`<0^WT00`3g
X@000`2jE000lfl00?=_000G0?=_00X0oooo1`2nEP0D0?M`00D0lch03@3oool40<8b01@0lch0103g
?`0;0?ooo`<0aC80303g?`0?0?@>00`0oooo1`3830050?<>0100mPh02P3oool4000004H0oooo002o
0?ooo`030000003oool0oooo00D0oooo0P00LP@2003h2@804W800P0Wn0000`0XLP00IVIV02Qb0002
05Sh00<0?g800P29n00205Ib00T0]_8000<0IVIV0;Kb002flP001@2flP060;[g00030000002jm`00
^_L000809oP00`0/O@000`1Hn000AGd004Em000304Em00D0ROP05@2gl`000`3oool09oP002Oh0004
03260080F?P000<0BXH008Oc0027l`005`27l`080?ooo`80<hl00P1Hn00404n?01D0ROP01@2gl`08
0?ooo`@0DiL00P29n003076G01@0]o<0102jm`0;0?ooo`@0Mih00P2jm`0K0>Oc00P0oooo00<0O:D0
0;[g002jm`001@2MY@0G0>_g00X0oooo102RZ`030>_g0080Zi80603cc`0;0?ooo`D0/9H05@3gdP05
0?>O00T0oooo0P2eVP020?OB00<0]GH05@3cW`040?NQ00X0oooo102jN@030?NQ01X0lfl02P3oool7
0;iF01D0mg003P3oool30?M`00<0`S806@3c?P0:0?ooo`@0aC80403g?`0:0?@>00`0oooo1`38300:
0?<>00`0mPh03P3oool400000480oooo002n0?ooo`030000003oool0oooo00D0oooo0`00LP@2003h
2@804W800P0Wn0000`0XLP00IVIV02Qb000205Sh00<0?g800P29n0000`1FLP00]_800;Kb00070;Kb
000306IVIP2flP00]_8000X0]_800P2jm`000`000000^_L00;[g000202Oh00<0;7d000<0F?P004Em
0015O@000P15O@0;08Wh0100]o<000<0oooo02Oh000Wn000100`QP0205Sh000304Z60027l`00Qo<0
01L0Qo<0203oool203>?0080F?P0101?S`0G08Wh00/0oooo101CU`0208Wh0080LIL06@2gl`090?oo
o`80ROP0101gWP070;[g01D0io<0203oool207bU0080^_L01@2MY@050>Oc0180joL02@3oool50::[
00<0joL000<0Zi800???003cc`005`3cc`0;0?ooo`D0/9H05P3gdP0=0?ooo`80]IX00P3gdP030;Ef
01T0lil02@3oool50;Yi00P0mj40503cK`0;0?ooo`L0_UH01@3cK`0@0?M`00d0oooo00@0`UP00?M`
003gL000mg000P32<P0J0?<n00T0oooo1@35<P0D0?Lo00D0m0h03P3oool50<P<00l0l`h0203f3P0B
0?ooo`@00000?P3oool00;h0oooo00<000000?ooo`3oool01@3oool3001b10800?P90P0BLP0202Oh
000406IVIP0XLP00:78005Sh00@0?g800P29n0000`1FLP00]_800;Kb00070;Kb000306IVIP2flP00
]_8000`0]_8000@000000;Kb000CO@009oP0100/O@000`1Hn000AGd004Em000204Em00D0Q_<02`29
n00:0;Oc00040?ooo`0EQP009oP002Oh00@0<8H00P1Hn00J08Oc00L0oooo0`0cS`0205Sh00@0Chl0
5`29n00;0?ooo`@0DiL00P29n002076G01T0]o<0203oool00`1HWP00ROP008Wh000407NN00`0^_L0
3`3Wl`080?ooo`<0O:D00P2jm`0409fU00/0io<03@3[m`090?ooo`D0XZ/00`3[m`0I0???00T0oooo
0`3[m`050;2F01H0mm80303oool30;FJ0080mm800P2eMP0J0?>O00P0oooo1P2jN@0<0?NQ00l0lfl0
303oool60;iF00X0lfl0303gL00<0?ooo`80`UP00`3gL0000`32<P00lch00?<n000H0?<n00T0oooo
1P35<P0F0?Lo0140oooo1038300D0?<>00@0mPh05P3oool3000003/0oooo002m0?ooo`030000003o
ool0oooo00D0oooo1000LP@2003h2@804W800P0Wn000101VIVH0:78002Qb001Hn00403mb0080ROP0
2@2flP000`1VIVH0]_800;Kb000=0;Kb00040000002flP004gd002Oh00@0;7d000@0F?P004Em0015
O@00AGd02`26l`0;08Wh00D0]o<000@0oooo01F6000Wn0009oP0100`QP0205Sh01T0Qo<0203oool3
03>?0080F?P0101?S`0508Oc0180ROP02`3oool405>G0080ROP000<0LIL00;Oc002gl`005`2gl`09
0?ooo`0305RN0029n000ROP000@0Mih0402jm`0;0>Oc00P0oooo0`1lY@020;[g00@0WJD03`3Wl`09
0>_g00T0oooo1@2RZ`080>_g01@0lll0203oool0102W/000joL00>_g003[m`050;2F00D0lll04@3g
dP0;0?ooo`@0]IX00P3gdP000`2eMP00lil00?>O000H0?>O00T0oooo1P2jN@0A0?NQ00X0lfl02@3o
ool00`2nO000mj400?NQ00050;iF00l0lfl0203gL00;0?ooo`<0`UP00`3gL00J0?<n00T0oooo1`35
<P0F0?Lo0140oooo1038300H0?<>05@0oooo001l0?ooo`<00000103oool3000000030?ooo`000000
0000008000000P3oool200000080oooo0`000000103oool000000?ooo`3oool3000000040?ooo`00
0000oooo0?ooo`<0000000<0oooo0000003oool00P3oool3003o?1<0oooo00<000000?ooo`3oool0
1@3oool4001b1006003h2@0BLP004W80019b000Wn000IVIV0`0XLP000`1Hn000?g8003mb000203mb
0080ROP02@2flP000`1VIVH0]_800;Kb000=0;Kb00040000000CO@004gd002Oh00@0;7d000@0F?P0
04Em0015O@00AGd03`26l`0:08Wh0080oooo0P0EQP0202Oh00@0<8H000<0F?P008Oc0027l`006027
l`070?ooo`@0<hl00P1Hn00304n?00/0Qo<03@29n00;0?ooo`@0DiL00P29n0000`1aU`00]o<00;Oc
000G0;Oc00P0oooo0P1HWP0208Wh00@0Mih01@2gl`0@0;[g00D0io<0203oool407bU0080^_L00`2M
Y@0E0>Oc00@0joL02@3oool50::[00`0joL03`3cc`080?ooo`80Yk000`3[m`040;2F00X0lll03@3g
dP0;0?ooo`@0]IX00P3gdP0J0?>O00X0oooo1P2jN@050?>O0100mj401@3cK`090?ooo`80_W`00P3g
X@040;iF01@0lfl0103gL00:0?ooo`@0`UP0203gL00D0?<n00/0oooo1P35<P050?<n0140mcl03@3o
ool01038<`00mcl00?Lo003g?`030<P<01T0l`h0E03oool007/0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo1@00oc`A0?ooo`030000003oool0oooo00H0oooo
1000LP@01P00n0T04W80019b000BLP009oP006IVIP<0:78000<0F?P003mb000oLP000P0oLP000`29
n000]_800;Kb00070;Kb000306IVIP2flP00]_8000h0]_8000@0000001=m000CO@009oP0100/O@00
0`1Hn000AGd004Em000E08Kc00D0ROP00P3oool201F600809oP0100`QP0605Sh01@0Qo<0203oool4
03>?0080F?P00`1?S`0?08Oc00T0ROP02@3oool205Sh00@0DiL00P29n00I0;Oc00T0oooo0P1HWP02
08Wh00<0Mih02`2gl`0=0;[g00X0oooo1@1lY@020;[g0080WJD06P3Wl`090?ooo`D0XZ/04@3[m`0:
0???00P0oooo0P2W/0030>_g00@0/9H03`3cc`080?OB00X0oooo1@2eVP070?OB01@0lil02`3oool5
0;Yi00X0lil03@3gX@0<0?ooo`<0_W`00P3gX@030;iF01T0lfl02@3oool50<9H00`0mg00403c?P0;
0?ooo`D0aC802P3c?P0=0?Lo00`0oooo0P38<`030?Lo0080b0`06@3c3P1E0?ooo`00N`3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool7003o?100oooo00<00000
0?ooo`3oool01P3oool4001b1006003h2@0BLP004W80019b001VIVH09oP00`0XLP000`1Hn000?g80
03mb000203mb00H0ROP0102flP000`1VIVH0]_800;Kb000>0;Kb00040000000CO@004gd002Oh00@0
;7d000<0F?P004Em0026l`006@26l`020?ooo`<05HH00P0Wn004032600/0F?P03`27l`080?ooo`@0
<hl00P1Hn00204n?01D0Qo<01029n0080?ooo`0303JG001Hn000F?P000@0DiL01`29n00D0;Oc00P0
oooo0`1HWP0208Wh00<0Mih03`2gl`090;[g00X0oooo1@1lY@020;[g0080WJD06P3Wl`070?ooo`80
^_L01@2RZ`0E0>_g00D0lll0203oool30:N`00<0joL00`2`UP0D0???00@0mm802@3oool60;FJ00/0
mm80403cW`0;0?ooo`@0^WT0403cW`080?NQ00`0oooo0`2nO0020?NQ0080_UH06P3cK`080?ooo`H0
`UP04@3gL00:0?<n00`0oooo1035<P0@0?<n00P0mcl02`3oool30<Pc00<0mcl000<0b0`00?<>003c
3P005`3c3P1F0?ooo`00N`3oool00`000000oooo0?ooo`050?ooo`@000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo100000020?ooo`050000003oool0oooo0?ooo`0000000`3oool40000
0080oooo1`00oc`?0?ooo`030000003oool0oooo00L0oooo1000LP@01P00n0T04W80019b000BLP00
IVIV02Oh00<0:78000<0F?P003mb000oLP000P0oLP0:08Wh000306IVIP2flP00]_8000h0]_8000@0
000001=m000CO@009oP0100/O@000`1Hn000AGd008Kc000I08Kc0080oooo0`0EQP0202Oh00@0<8H0
3`1Hn00:08Oc00T0oooo100cS`0205Sh0080Chl06@27l`080?ooo`0303JG001Hn000F?P000@0DiL0
2`29n00?0;Oc00T0oooo0`1HWP0208Wh0080Mih05@2gl`040;[g00X0oooo1@1lY@020;[g000309fU
003Wl`00io<001P0io<01`3oool00`21Z`00^_L00;[g00050::[01L0joL02P3oool40:N`00<0joL0
0P2`UP0I0???00T0oooo1P2eVP0@0?OB00X0lil02P3oool20?OB00<0^WT05@3cW`040?NQ00/0oooo
102nO0020?NQ00030;iF003cK`00lfl001P0lfl0203oool70<9H01D0mg001@3c?P0=0?ooo`<0aC80
5@3c?P040?Lo00X0oooo1038<`030?Lo01T0l`h0E`3oool007/0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0103oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`00oc`;0?ooo`800000
0P3oool00`000000oooo0?ooo`060?ooo`03003h>`00LP@007840080078400H00?P9019b000BLP00
4W8006IVIP0Wn00302Qb000305Sh000oLP00?g800080?g802@29n0000`1VIVH0ROP008Wh000408Wh
00X0]_8000D04gd00000000CO@004gd002Oh000402am000305Sh0026l`00Q_<001P0Q_<00P3oool4
01F600809oP0100`QP0D05Sh00D0Qo<02@3oool403>?0080F?P000<0Chl008Oc0027l`006027l`07
0?ooo`80=YL00P1Hn00405>G0100ROP02P2gl`080?ooo`@0F9h00P29n00207NN01T0]o<02P3oool5
07bU0080^_L06P3Wl`070?ooo`80PJ/00P2jm`050::[01L0joL02P3oool40:N`00<0joL00P2`UP0I
0???00T0oooo1P2eVP050???00l0mm801@3cW`0:0?ooo`030;ZN003gdP00mm8000<0^WT06@3cW`0:
0?ooo`D0_W`00P3gX@0J0?=_00X0oooo1P32F00F0?M`00d0oooo00@0aEX00?M`003gL000mg000`35
<P0I0?<n00X0oooo1038<`080?Lo01@0l`h0E`3oool007/0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`@000000P3oool00`000000oooo00000002000000<0oooo100000040?ooo`@000000P3o
ool4000000@0oooo1@00oc`>0?ooo`@000001P3oool00`00LQ/00?Pk001b1002001b10800?P90P0B
LP000`1VIVH09oP002Oh000302Qb000305Sh000oLP00?g800080?g802@29n0000`1VIVH0ROP008Wh
000908Wh00D0]_8000D04gd00000000CO@004gd002Oh000302am000305Sh0026l`00Q_<001T0Q_<0
0P3oool401F600809oP0100`QP0G05Sh00T0oooo0P0Wn00403>?0080F?P000<0Chl008Oc0027l`00
5`27l`070?ooo`<0=YL00P1Hn00405>G01@0ROP01@2gl`080?ooo`D0F9h00P29n0000`1gWP00]o<0
0;Oc000H0;Oc00X0oooo1@1lY@070;[g01@0io<01`3oool3086[0080^_L01@2RZ`050>Oc0180joL0
2@3oool50:N`00<0joL000<0/9H00???003cc`005`3cc`0:0?ooo`D0]IX02P3cc`0=0?OB00`0oooo
0P2jWP020?OB0080^WT06P3cW`0:0?ooo`D0_W`01`3gX@0D0?=_00/0oooo1P32F0050?=_0140mg00
303oool20<EJ00<0mg000P35<P0J0?<n00T0oooo1@38<`0<0?Lo00l0l`h0F03oool007/0oooo00D0
00000?ooo`3oool0oooo0000000K0?ooo`030000003oool0oooo00T0oooo0`00oc`@0?ooo`030000
003oool0oooo00800000103oool00`00LQ/00?Pk001b1002001b10800?P90P0BLP000`1VIVH09oP0
02Oh000302Qb000405Sh000oLP00?g8003mb00T0ROP000<0IVIV08Wh0029n0003@29n002003h2@05
01=m000000004gd001=m000Wn0000`0/O@0605Sh01D0Q_<00`3oool401F600809oP0100`QP0G05Sh
00P0oooo00<05Xl002Oh000Wn000100cS`0205Sh01X0Qo<01`3oool303JG0080F?P0101CU`0G08Wh
00X0oooo1@1HWP0208Wh000307NN002gl`00]o<001L0]o<02@3oool208Wh00D0O:D02`2jm`0@0>Oc
00L0oooo0`21Z`020;[g00@0XZ/02`3Wl`0=0>_g00P0oooo1P2W/0030>_g01X0lll02P3oool40;FJ
0100lll0203gdP0;0?ooo`<0^Yh00P3gdP000`2jN@00lil00?>O000H0?>O00X0oooo1P2nO00;0?NQ
0100lfl02`3oool50<9H00X0lfl03@3gL00;0?ooo`<0aEX00`3gL0000`35<P00lch00?<n000H0?<n
00T0oooo1P38<`0@0?Lo00X0l`h0F@3oool007`0oooo0`00000L0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool01@3oool2001b6`04003h>`00LP@00784001b10800?P900<04W8006IV
IP0BLP000P0Wn00202Qb0080F?P00`0oLP0508Kb00@0ROP000<0IVIV08Wh0029n0003@29n002003h
2@0501=m000000004gd001=m000Wn0000`0/O@0;05Sh0100Q_<00`3oool401F600809oP00`0`QP0H
05Sh00P0oooo00<05Xl002Oh000Wn000100cS`000`1Hn000Qo<008Oc000H08Oc00L0oooo100fU`02
05Sh00@0DiL01@27l`0B08Wh00X0oooo1@1HWP0208Wh01X0]o<0203oool00`1KY@00ROP008Wh0005
07bU0100^_L02P3Wl`070?ooo`@0PJ/00P2jm`040::[00l0io<02@3[m`090?ooo`D0Yk00203[m`0D
0???00P0oooo00<0[;D00>_g003[m`00102eVP0D0???00@0mm802`3oool30;ZN0080mm806P3cW`0:
0?ooo`L0_W`0403gX@0:0?=_00`0oooo1032F00@0?=_00P0mg002P3oool40<EJ00<0mg006P3c?P09
0?ooo`L0b3<0503g?`050?<>05X0oooo002J0?ooo`8000007@3oool00`000000oooo0?ooo`060?oo
o`80078K00@00?Pk001b1000LP@007840P00n0T00`0BLP00IVIV019b000202Oh0080:7800P1Hn003
03mb00P0Q_8000<0IVIV08Kb0029n0003P29n002003h2@0501=m000000004gd001=m000Wn0000`0/
O@0@05Sh00X0Q_<00P3oool2003h2@@05HH00P0Wn003032600D0E_<04`1Hn0070?ooo`805Xl00P0W
n00403>?00H0F?P05@27l`060?ooo`D0=YL00P1Hn00305>G00X0Qo<03P29n00:0?ooo`D0F9h000<0
ROP00;Oc002gl`00602gl`090?ooo`0305^U0029n000ROP000D0O:D0502jm`050>Oc00L0oooo1@21
Z`020;[g00<0XZ/05@3Wl`040>_g00T0oooo1@2W/00<0>_g00l0lll0203oool20:be0080joL00`2e
VP0I0???00X0oooo102jWP070?OB01@0lil02`3oool70;il00D0lil03`3gX@050?=_00X0oooo0`3g
X@040<9H01@0lfl0103gL00:0?ooo`@0aEX0203gL00D0?<n00T0oooo2038<`050?<n0100mcl0GP3o
ool00;T0oooo00<000000?ooo`3oool01@3oool3001b6`04003h>`00LP@00784001b10800?P900@0
IVIV019b000BLP009oP00`0XLP0205Sh0080?g802@26lP000`1VIVH0Q_8008Kb000408Kb00X0ROP0
0P00n0T00`0CO@00000001=m000202Oh00<0;7d05@1Hn00508Kc0080oooo0P00n0T401F600809oP0
0`0`QP0:05Kc00h0F?P01`3oool201J?00809oP0100cS`0;05Sh00l0Qo<01`3oool503JG0080F?P0
0`1CU`0?08Oc00T0ROP0203oool205Sh00D0F9h01`29n00C0;Oc00T0oooo0P1KY@0208Wh00D0O:D0
1@2gl`0A0;[g00T0oooo1P21Z`020;[g0080XZ/06P3Wl`090?ooo`D0Yk004@3[m`0:0???00P0oooo
0P2/]@020>_g0080]IX06P3cc`090?ooo`D0^Yh02`3gdP0@0?>O00/0oooo1P2nO00:0?>O00`0mj40
3@3oool01032OP00mj400?NQ003gX@030<9H01T0lfl02@3oool50<EJ00`0mg003`3c?P0;0?ooo`H0
b3<02P3c?P0<0?Lo05h0oooo002h0?ooo`030000003oool0oooo00H0oooo0`00LQ/01000n3/00784
001b1000LP@2003h2@0406IVIP0BLP004W8002Oh00<0:7800P1Hn00203mb00P0Q_8000<0IVIV08Kb
0026lP002P26lP0508Wh00800?P900<04gd00000000CO@000P0Wn00302am01P0F?P00`3oool00`00
QPD00?P9003h2@0401F600809oP00P0`QP0?05Kc00X0F?P01P3oool301J?00809oP0100cS`0?05Sh
00/0Qo<01`3oool503JG0080F?P00P1CU`0D08Oc00D0ROP01`3oool00`0hWP00F?P005Sh000505RN
00d0ROP03@2gl`080?ooo`<0FjD00P29n00407bU00X0]o<03@2jm`0:0?ooo`D0PJ/00P2jm`020::[
01X0io<01P3oool30;[g00D0Yk005@3[m`050???00P0oooo0`2/]@020>_g0080]IX06@3cc`090?oo
o`H0^Yh0403gdP0:0?>O00`0oooo1@2nO00?0?>O00P0mj40303oool20<9n00<0mj400P32F00J0?=_
00P0oooo1P35FP0@0?M`00X0lch0303oool50<Pc00l0lch0203g?`1N0?ooo`00K`3oool500000080
oooo100000040?ooo`<000000`3oool600000080oooo0`0000000`3oool000000000000200000080
oooo0P0000020?ooo`<0000000<0oooo0000003oool00P3oool3003oKa<0oooo00<000000?ooo`3o
ool01@3oool4001b6`06003h>`00LP@00784001b1000n0T0IVIV0P0BLP0202Oh00<0:7800P1Hn000
0`0oLP00Q_8008Kb000708Kb000306IVIP26lP00Q_8000h0Q_8000H007d5003h2@00n0T04gd00000
000CO@0202Oh00<0;7d0601Hn0030?ooo`0300261@00n0T00?P900@05HH00P0Wn002032601@0E_<0
1@1Hn0060?ooo`<05Xl00P0Wn00303>?01D0F?P01@27l`080?ooo`D0=YL00P1Hn0000`1CU`00Qo<0
08Oc000G08Oc00P0oooo00<0>9h005Sh001Hn0001@1HWP0C08Wh00H0]o<02@3oool305^U0080ROP0
101lY@0?0;Oc00P0^_L02P3oool5086[0080^_L000<0XZ/00>Oc003Wl`00603Wl`060?ooo`0408F`
002jm`00^_L00;[g00D0Yk005P3[m`0;0?ooo`@0[;D00P3[m`000`2eVP00lll00???000G0???00X0
oooo1P2jWP0D0?OB00D0lil02P3oool00`2nXP00mm800?OB00040;il01@0lil0103gX@0;0?ooo`<0
`Wh00`3gX@020<9H01T0lfl0203oool70<EJ01@0mg001@3c?P0=0?ooo`@0b3<0503c?P040?Lo05h0
oooo001a0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool5003oKa80oooo00<000000?ooo`3oool01@3oool4001b6`06003h>`00LP@00784001b1000n0T0
IVIV0P0BLP0202Oh00<0:7800P1Hn0000`0oLP00Q_8008Kb000708Kb000306IVIP26lP00Q_8000h0
Q_8000H007d5003h2@00n0T04gd00000000CO@0202Oh00<0;7d0601Hn0020?ooo`8008H50P00n0T4
01F600809oP000<0<8H005Kc001Fl`005`1Fl`060?ooo`@05Xl00P0Wn00303>?00D0E_<04`1Hn00:
0?ooo`D0=YL00P1Hn0000`1CU`00Qo<008Oc000G08Oc00L0oooo0P0hWP0205Sh00D0F9h05P29n00;
0?ooo`@0FjD00P29n00307bU01@0]o<0102jm`0:0?ooo`D0PJ/00P2jm`0J0>Oc00L0oooo00@0QK00
0;[g002jm`00^_L01@2W/0050>Oc0140joL02`3oool40:be0080joL06P3cc`0:0?ooo`H0^Yh05P3g
dP0<0?ooo`80_Z800P3gdP030;il01T0lil02P3oool40<9n00<0mj4000<0`UP00?=_003cK`005`3c
K`090?ooo`L0aEX05@3gL00=0?ooo`040<QK003gL000mg000?M`00@0b3<0603c?P1N0?ooo`00L@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L00?m_403oool00`00
0000oooo0?ooo`060?ooo`@0078K00H00?Pk001b1000LP@00784003h2@1VIVH2019b00809oP00`0X
LP0205Sh00T0Q_8000<0IVIV08Kb0026lP003`26lP000`00O@D00?P9003h2@030000000302Oh000/
O@00;7d00080;7d0601Hn0020?ooo`8008H50P00n0T401F600809oP000<0<8H005Kc001Fl`005`1F
l`060?ooo`@05Xl00P0Wn00303>?00X0E_<03P1Hn0080?ooo`809oP01@0fU`0205Sh01T0Qo<01`3o
ool303RN0080F?P01@1HWP0F08Wh00X0oooo1@1KY@0208Wh0080O:D06@2gl`0:0?ooo`D0PJ/01`2j
m`0D0>Oc00L0oooo0P25/0030;[g00@0Yk002P3Wl`0=0>_g00X0oooo1@2/]@070>_g01@0lll02`3o
ool60;ZN00D0lll04@3gdP0;0?ooo`<0_Z800P3gdP020;il01X0lil02@3oool50<9n00<0mj406@3c
K`0:0?ooo`L0aEX01@3cK`0@0?M`00`0oooo0P38F`030?M`00<0b3<06@3c?P1N0?ooo`00L@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`030000003oool0
oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo1`00ofl@0?ooo`030000003oool0oooo00H0oooo1000LQ/01@00n3/00784
001b1000LP@0IVIV00<04W800P0Wn00302Qb0080F?P02@26lP000`1VIVH0Q_8008Kb000>08Kb0080
07d50P00n0T00`0000004gd001=m0002000000<0;7d0601Hn000103oool008H500261@00QPD2003h
2@@05HH00P0Wn00J05Kc00H0oooo100FS`0202Oh0080<hl03`1Fl`0:05Sh00L0oooo00<069L002Oh
000Wn0001@0fU`000`1Hn000Qo<008Oc000H08Oc00L0oooo0`0hWP0205Sh00@0F9h05`29n00:0?oo
o`D0FjD00P29n00207bU01T0]o<01`3oool308Wh00D0PJ/02`2jm`0@0>Oc00H0oooo0`25/0030;[g
00@0Yk003`3Wl`080>_g00T0oooo1P2/]@0;0>_g00l0lll0303oool50;ZN00X0lll03@3gdP0:0?oo
o`@0_Z800P3gdP000`2nO000lil00?>O000H0?>O00T0oooo1P32OP080?NQ01@0lfl02P3oool60<EJ
00X0lfl0303gL00;0?ooo`<0b5/00`3gL0020<Pc01T0lch0G`3oool00740oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo008000000P3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00L00?m_3`3oool00`000000oooo0?ooo`060?ooo`03003hK000LQ/0
078K0080078K00D00?Pk001b1000LP@0078406IVIP03019b00809oP00`0XLP000`1Hn000Q_8008Kb
000708Kb000306IVIP26lP00Q_8000l0Q_800P00O@D00`00n0T0IVIV0000000201=m000302Oh000/
O@00;7d00080;7d0601Hn000103oool008H500261@00QPD2003h2@@05HH00P0Wn00I05Kc00L0oooo
100FS`0202Oh0080<hl0501Fl`0505Sh00L0oooo00<069L002Oh000Wn0001@0fU`0605Sh01@0Qo<0
1`3oool403RN0080F?P0101HWP0508Oc0180ROP02P3oool505^U0080ROP000<0O:D00;Oc002gl`00
5`2gl`070?ooo`0405j[0029n000ROP008Wh00D0PJ/01@2gl`0;0;[g00X0io<01`3oool308F`00<0
^_L00`2W/00D0>Oc00@0joL02@3oool60:be0100joL02P3cc`090?ooo`030;2j003[m`00joL000@0
^Yh0403cc`080?OB00X0oooo102nXP020?OB01X0lil02@3oool70<9n00`0mj403`3cK`0;0?ooo`D0
aEX03`3cK`080?M`00X0oooo1038F`030?M`00030<Pc003c?P00lch001L0lch0H03oool00740oooo
00<000000?ooo`3oool00P3oool00`000000oooo00000002000000<0oooo0`0000050?ooo`030000
003oool0oooo0080oooo100000020?ooo`030000003oool0000000800000103oool4000000<0oooo
1@00ofl<0?ooo`8000000P3oool00`000000oooo0?ooo`060?ooo`04003hK000LQ/0078K001b6`80
0?Pk0P00LP@00`1VIVH00?P9019b0002019b00809oP00`0XLP0605Sh00@0Q_8000<0IVIV08Kb0026
lP003P26lP03001m1@03003h2@1VIVH0000000804gd000<09oP002am000/O@000P0/O@0H05Sh00@0
08H50P00n0T401F6000302Oh001Fl`00E_<001P0E_<01@3oool2003h2@@05Xl00P0Wn0000`0cS`00
E_<005Kc000G05Kc00L0oooo0P0HU`0202Oh00D0=YL02`1Hn00?08Oc00H0oooo1@0hWP0205Sh00<0
F9h02`27l`0=08Wh00X0oooo1@1KY@0208Wh01X0]o<01`3oool0101NZ`00ROP008Wh0029n004086[
00X0]o<02`2jm`050>Oc00L0oooo1025/0030;[g0080Yk006@3Wl`090?ooo`H0[;D0503[m`050???
00T0oooo0P2`^P020>_g00<0^Yh05@3cc`040?OB00T0oooo1@2nXP070?OB01@0lil02`3oool60<9n
00D0lil02`3gX@0:0?=_00T0oooo00<0aH400?NQ003gX@001035FP0D0?=_00@0mg002P3oool40<QK
00<0mg006@3c?P1Q0?ooo`00L@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool00P3oool3003oK`l0oooo100000060?ooo`03001b<P00n6`0078K0080
078K00H00?Pk001b1000LP@0078406IVIP00n0T3019b00809oP00`0XLP0905Sh000306IVIP1Hn000
Q_8000l0Q_800`00O@D00`1VIVH04gd00000000201=m000302Oh000/O@00;7d00080;7d0601Hn004
00261@800?P9100EQP0602Oh01@0E_<01@3oool00`00S`D00?P9003h2@0401J?00809oP000<0<hl0
05Kc001Fl`005`1Fl`070?ooo`8069L00P0Wn00403JG0100F?P02P27l`070?ooo`D0>9h00P1Hn003
05RN00l0Qo<02@29n0080?ooo`80F?P01@1KY@0708Wh01@0]o<01`3oool205j[00<0ROP01021Z`0?
0;Oc00P0^_L02@3oool508F`00<0^_L00P2W/00I0>Oc00T0oooo1P2/]@0E0>_g00`0oooo0`2`^P02
0>_g00<0^Yh06@3cc`080?ooo`H0_Z802`3gdP0@0?>O00/0oooo1@32OP0:0?>O00/0mj401@3cK`09
0?ooo`80aH400P3gX@030<EJ01T0lfl02@3oool50<QK00P0mg00503c?P1Q0?ooo`00K`3oool50000
0180oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00800000103oool00`00LS800?Q/001b6`02001b6`04003h>`00LP@0078406IVIP800?P90`0BLP02
02Oh00<0:7802@1Hn0000`1VIVH0F?P005Sh000405Sh00X0Q_801000O@D00`1VIVH04gd000000002
01=m000302Oh000/O@00;7d00080;7d0601Hn00400261@800?P9100EQP0;02Oh00l0E_<01@3oool0
0`00S`D00?P9003h2@0401J?00809oP06P1Fl`060?ooo`<069L00P0Wn00403JG00D0E_<0401Hn005
08Oc00L0oooo1@0hWP0205Sh0080F9h05@27l`0408Wh00L0oooo00<0>ZD005Sh001Hn0001@1KY@0;
08Wh00l0]o<01`3oool305j[00<0ROP00`21Z`0D0;Oc00@0^_L02@3oool508F`00<0^_L000<0Yk00
0>Oc003Wl`005`3Wl`070?ooo`0308Re002jm`00^_L000H0[;D05@3[m`0;0?ooo`@0/;X00P3[m`02
0;ZN01X0lll01`3oool70;jR0100mm802P3cW`0<0?ooo`@0`Wh03`3cW`080?NQ00`0oooo0`35P@02
0?NQ0080aEX06P3cK`080?ooo`H0b5/0303gL00?0?<n0680oooo00240?ooo`<000005@3oool20000
01L0oooo00<000000?ooo`3oool01@3oool2001b<P05003hK000LQ/0078K001b6`00n3/00P00LP@0
0`1VIVH00?P9003h2@03019b00809oP00`0XLP0805Sh000306IVIP1Hn000F?P000X0F?P01@26lP03
001m1@0406IVIP00n0T04gd0000000804gd000@09oP002am000/O@00;7d06@1Hn00400261@800?P9
100EQP0?02Oh00X0E_<01@3oool2002?1@800?P9100FS`0202Oh01T0E_<01`3oool301RG00809oP0
100fU`0:05Kc00d0F?P02P3oool503RN0080F?P00P1HWP0I08Oc00L0oooo00<0>ZD005Sh001Hn000
1@1KY@0@08Wh00X0]o<01`3oool305j[00<0ROP00`21Z`0H0;Oc00T0oooo1@25/0030;[g01X0io<0
1P3oool208Re0080^_L01P2/]@0E0>_g00/0oooo102`^P020>_g00030;ZN003cc`00lll001P0lll0
2@3oool60;jR01@0mm801@3cW`0:0?ooo`<0mm800`32OP0D0?>O00@0mj402`3oool40<F10080mj40
00<0aEX00?=_003cK`00603cK`080?ooo`L0b5/0403gL00:0?<n06<0oooo002D0?ooo`8000007P3o
ool00`000000oooo0?ooo`060?ooo`80078b00P00?Q/001b6`00LQ/0078K003h>`00LP@0IVIV001b
10800?P90`0BLP0202Oh0080:7802@1Hn0000`1VIVH0F?P005Sh000=05Sh0003001m7@00n3/007d5
008007d500@0IVIV003h2@0CO@0000000P0CO@00100Wn000;7d002am000/O@0505Kc01@0F?P01000
QPD2003h2@@05HH0500Wn00505Kc00D0oooo0P00S`D2003h2@@05Xl000<09oP005Kc001Fl`00601F
l`060?ooo`@069L00P0Wn00303JG00l0E_<02@1Hn00:0?ooo`D0>9h00P1Hn0000`1HWP00Qo<008Oc
000H08Oc00H0oooo0P0jY@0205Sh00D0FjD05029n0050;Oc00L0oooo101NZ`0308Wh0080PJ/06@2g
l`090?ooo`D0QK00202jm`0D0>Oc00L0oooo0P28]@020;[g00H0[;D01@3Wl`0@0>_g00X0oooo1@2`
^P020>_g01X0lll02P3oool60;jR01D0mm803@3oool01032Y@00mm800?OB003gdP030<9n01P0lil0
2P3oool50<F10080mj406P3cK`090?ooo`L0b5/0503gL0050?<n06@0oooo002F0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool01@3oool3001b<P08003hK000LQ/0078K001b6`00n3/0
078406IVIP00LP@2003h2@<04W800P0Wn00202Qb00P0F?P000<0IVIV05Sh001Hn0003P1Hn0001@00
OAd00?Pk001m1@00O@D0IVIV00800?P900D04gd00000000CO@004gd002Oh000202am00/0E_<03`1H
n00400261@800?P90`0EQP0H02Oh00H0oooo0`00S`D2003h2@@05Xl01P0Wn00D05Kc00L0oooo100H
U`0202Oh00<0=YL0501Fl`0405Sh00P0oooo0P0Wn00503RN0080F?P000<0F9h008Oc0027l`005`27
l`070?ooo`80>ZD00P1Hn00505^U00D0Qo<04@29n0090?ooo`D0GZ/00`29n002086[01P0]o<02P3o
ool508F`00`0^_L03`3Wl`070?ooo`<0R;D00P2jm`050:be00X0io<0303[m`090?ooo`H0/;X01`3[
m`0D0???00/0oooo1P2nXP050???0100mm80303oool20<:U00<0mm800P32OP0I0?>O00T0oooo1P35
P@070?NQ01@0lfl02P3oool70<QK00D0lfl0403gL01X0?ooo`00UP3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo00H0oooo0`00LS802000n6`0078K001b6`00LQ/00?Pk001b101VIVH0
07840P00n0T3019b00809oP00P0XLP0805Sh000306IVIP1Hn000F?P000d0F?P00P00OAd01000n3/0
07d5001m1@1VIVH2003h2@0501=m000000004gd001=m000Wn0000P0/O@0@05Kc00X0F?P01000QPD2
003h2@<05HH01@0Vl`0C02Oh00H0oooo0`00S`D2003h2@@05Xl02`0Wn00?05Kc00L0oooo100HU`02
02Oh0080=YL06@1Fl`070?ooo`0301VN000Wn0009oP000D0>9h00P1Hn00J08Oc00H0oooo0`0jY@02
05Sh00@0FjD02P27l`0=08Wh00T0oooo1@1NZ`0308Wh0003086[002gl`00]o<001H0]o<0203oool0
0`1R/000ROP008Wh000508F`00D0]o<0302jm`0:0>Oc00L0oooo0`28]@020;[g00@0[;D03`3Wl`08
0>_g00P0oooo1`2`^P0;0>_g0100lll02`3oool50;jR00X0lll0303gdP0;0?ooo`<0`ZD00`3gdP00
0`32OP00lil00?>O000G0?>O00T0oooo1`35P@0;0?NQ00l0lfl02`3oool60<QK00X0lfl0303gL01X
0?ooo`00J`3oool3000000@0oooo0`0000030?ooo`@000000P3oool2000000030?ooo`000000oooo
008000000P3oool3000000030?ooo`0000000000008000000P3oool2000000<0oooo00<000000?oo
o`3oool0103oool3003oXQ<0oooo00<000000?ooo`3oool01@3oool4001b<P06003hK000LQ/0078K
001b6`00n3/0IVIV0P00LP@2003h2@<04W800P0Wn00202Qb00P0F?P000<0IVIV05Sh001Hn0003@1H
n002001m7@04003h>`00O@D0IVIV001m1@800?P900H04gd00000000CO@004gd002Oh000/O@0F05Kc
00D0F?P01000QPD2003h2@805HH02`0Vl`0>02Oh00D0oooo1000S`D2003h2@@05Xl03`0Wn00:05Kc
00P0oooo100HU`0202Oh0080=YL06@1Fl`070?ooo`0301VN000Wn0009oP000D0>9h01`1Hn00D08Oc
00L0oooo0`0jY@0205Sh00@0FjD03`27l`0808Wh00T0oooo1@1NZ`0308Wh01P0]o<0203oool206:`
0080ROP01025/00:0;Oc00`0^_L01@3Wl`070?ooo`@0R;D00P2jm`030:be01@0io<0103[m`090?oo
o`H0/;X0403[m`0:0???00T0oooo0`3[m`040;jR00l0lll0203gdP0;0?ooo`<0`ZD00`3gdP0I0?>O
00T0oooo2035P@0?0?NQ00X0lfl0303oool50<QK00l0lfl0203gL01X0?ooo`00JP3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo0`0000040?ooo`D00?nR4@3oool00`000000
oooo0?ooo`060?ooo`@0078b00H00?Q/001b6`00LQ/0078K003h>`1VIVH2001b1003003h2@0BLP00
4W8000804W800P0Wn00202Qb00L0F?P000<0IVIV05Sh001Hn0003P1Hn002001m7@04003h>`00O@D0
IVIV001m1@800?P900H04gd00000000CO@004gd002Oh000/O@0J05Kc0003003h>`00QPD008H50080
08H50P00n0T201F600l09_<02P0Wn0040?ooo`D008l50P00n0T401J?01@09oP01@1Fl`080?ooo`@0
69L00P0Wn0000`0fU`00E_<005Kc000G05Kc00L0oooo0P0IWP0202Oh00D0>9h02`1Hn00?08Oc00L0
oooo100jY@0205Sh00<0FjD05027l`0408Wh00T0oooo1@1NZ`0908Wh0180]o<0203oool206:`0080
ROP01025/00?0;Oc00P0^_L02`3oool408Re0080^_L00`2/]@0H0>Oc00T0oooo1P2`^P0D0>_g00D0
lll02@3oool0102d_P00joL00>_g003[m`030;jR01@0lll0103gdP0:0?ooo`@0`ZD0203gdP0C0?>O
00/0oooo1`35P@050?>O00h0mj401@3cK`0:0?ooo`<0mj401038F`0D0?=_00@0mg00J03oool006X0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool00`3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`L00?nR
403oool00`000000oooo0?ooo`060?ooo`@0078b00D00?Q/001b6`00LQ/0078K06IVIP03001b1003
003h2@0BLP004W8000804W800P0Wn00202Qb00L0F?P000<0IVIV05Sh001Hn0003P1Hn002001m7@04
003h>`1VIVH007d5001m1@800?P900D04gd00000000CO@004gd002Oh000K05Kc0003003h>`00QPD0
08H5008008H50P00n0T00`0EQP009_<002Kc000C02Kc00D09oP0103oool5002?1@800?P9100FS`0F
02Oh00T0oooo0P00n0T401RG00809oP000<0=YL005Kc001Fl`005`1Fl`060?ooo`<06Ih00P0Wn005
03RN0100F?P02P27l`060?ooo`D0>ZD00P1Hn00205^U01T0Qo<01`3oool205Sh00D0GZ/03P29n00<
0;Oc00P0oooo0`1R/00208Wh00<0QK00502gl`040;[g00X0oooo1@28]@020;[g0080[;D06@3Wl`09
0?ooo`H0/;X05@3[m`0<0?ooo`80];h00`3[m`030;jR01P0lll02@3oool50<:U00`0mm803`3cW`0;
0?ooo`H0aH402P3cW`0<0?NQ00`0oooo00@0b8<00?NQ003gX@00mj400`38F`0I0?=_06P0oooo001Z
0?ooo`030000003oool0oooo008000000P3oool5000000<0oooo00<000000?ooo`3oool00`3oool0
1@000000oooo0000003oool0000000<0oooo100000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo1`00oj8@0?ooo`030000003oool0oooo00H0
oooo1000LS801@00n6`0078K001b6`00LQ/0IVIV00<0078400<00?P9019b000BLP000P0BLP00100W
n000:78002Qb000XLP0605Sh000306IVIP1Hn000F?P000l0F?P000@007dM003h>`00n3/0IVIV0P00
O@D2003h2@0501=m000000004gd001=m000Wn0006P1Fl`02003h>`@008H50P00n0T00`0EQP009_<0
02Kc000G02Kc00D0oooo1@00S`D2003h2@@05Xl05P0Wn0080?ooo`03002G1P00n0T00?P900@069L0
0P0Wn00I05Kc00L0oooo0`0IWP0202Oh00D0>9h0501Hn00508Oc00L0oooo1@0jY@0205Sh0080FjD0
6@27l`060?ooo`0303b[001Hn000F?P000D0GZ/04`29n0060;Oc00P0oooo101R/00208Wh0080QK00
6@2gl`090?ooo`H0R;D00P2jm`000`2/]@00io<00>Oc000G0>Oc00L0oooo0`2jm`060;2j01D0joL0
2`3oool30;Bn00<0joL00P2nXP0I0???00P0oooo1P32Y@0@0?OB00X0lil0303oool50<F100l0lil0
203gX@0;0?ooo`80b8<00`3gX@020<QK01X0lfl0J03oool006X0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0000003oool0000000H0oooo00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool01`00oj8?0?ooo`030000003oool0oooo00H0oooo00<00?RM001b
<P00LS800P00LS801@00n6`0078K001b6`1VIVH00?Pk00<0078400@00?P9019b000BLP004W800P0W
n00302Qb00H0F?P000<0IVIV05Sh001Hn0003`1Hn0000`00OAd00?Pk06IVIP03001m1@800?P900@0
4gd00000000CO@004gd06`1Fl`02003h>`@008H50P00n0TJ02Kc00D0oooo1@00S`D2003h2@<05Xl0
5`0Wn0080?ooo`03002G1P00n0T00?P900@069L0200Wn00B05Kc00L0oooo100IWP0202Oh00D0>9h0
1P1Fl`0@05Sh00X0oooo1@0jY@0205Sh000305^U0027l`00Qo<001L0Qo<01`3oool00`0lZ`00F?P0
05Sh000505j[00H0Qo<04029n00;0?ooo`@0H[000P29n00208F`01T0]o<02@3oool608Re0080^_L0
6P3Wl`060?ooo`0408bj002jm`00^_L00;[g00H0/;X05@3[m`0;0?ooo`<0];h00`3[m`000`2nXP00
lll00???000G0???00T0oooo1P32Y@0D0?OB00D0lil02P3oool30?OB00@0aH40503cW`040?NQ00X0
oooo0`38P`030?NQ00030<QK003cK`00lfl001P0lfl0J@3oool006X0oooo00D000000?ooo`3oool0
oooo000000030?ooo`<000000`3oool00`000000oooo00000002000000060?ooo`00000000000000
003oool000000`3oool400000080oooo00<000000?ooo`0000000P0000020?ooo`<0000000@0oooo
00000000000000000P3oool5003oXP`0oooo1@0000070?ooo`03001bB000n9d0078b00<0078b0`00
LQ/00`1VIVH00?Pk001b1002001b1004003h2@0BLP004W80019b00809_800`0XLP0505Sh000306IV
IP1Hn000F?P00100F?P000<007dM003h>`1VIVH00`00O@D2003h2@0401=m000000004gd001=m00D0
9oP05@1Fl`000`00QQl00?Pk003h>`0400261@800?P96@0Vl`050?ooo`03003h>`00S`D008l500<0
08l50P00n0T301J?00D09_<04P0Wn0070?ooo`8009L60P00n0T401RG00d09oP03@1Fl`060?ooo`D0
6Ih00P0Wn00403RN00`0E_<02`1Hn00:0?ooo`D0>ZD00P1Hn00J08Oc00H0oooo0P0lZ`0205Sh00@0
GZ/03027l`0;08Wh00X0oooo1@1R/00208Wh000308F`002gl`00]o<001L0]o<02P3oool608Re00L0
^_L0503Wl`060?ooo`80S;X00`2jm`060;2j00D0io<0403[m`0:0?ooo`@0];h00`3[m`0I0???00X0
oooo1P32Y@0E0?OB00d0oooo00@0aJP00?OB003gdP00mm800`35P@0I0?>O00T0oooo1038P`030?NQ
01X0lfl0JP3oool006X0oooo00D000000?ooo`3oool0oooo0000000^0?ooo`<00?nR403oool50000
00@0oooo00<00798003hW@00LS800P00LS801P00n6`0078K001b6`00LQ/0IVIV003h>`<0078400@0
0?P9019b000BLP004W800P0VlP0302Qb00D0F?P000<0IVIV05Sh001Hn000401Hn0000`00OAd00?Pk
06IVIP03001m1@800?P900@04gd00000000CO@004gd02P0Wn00@05Kc000300267`00n3/00?Pk00@0
08H500<00?P902Kc000Vl`00600Vl`040?ooo`03002?8P00n3/008l500@008l50P00n0T201J?00/0
9_<03@0Wn0060?ooo`<009L60P00n0T401RG01<09oP01P1Fl`070?ooo`D06Ih00P0Wn00403RN0180
E_<01@1Hn0080?ooo`809oP01@0jY@0705Sh01@0Qo<01`3oool203b[0080F?P0101NZ`0B08Oc00D0
ROP02@3oool606:`0080ROP06P2gl`0:0?ooo`H0R;D02`2jm`0?0>Oc00H0oooo0`2<^P030;[g00D0
/;X02P3Wl`0<0>_g00T0oooo1@2d_P080>_g01<0lll02`3oool60<:U00D0lll0403gdP0<0?ooo`80
aJP00`3gdP020<F101X0lil0203oool50<R300P0mj40503cK`1[0?ooo`00J`3oool300000480oooo
00<000000?ooo`3oool01@3oool2001bB005003hW@00LS80078b001b<P00n6`00P00LQ/00`1VIVH0
0?Pk003h>`03001b1003003h2@0BLP004W8000<09_800`0XLP0405Sh000306IVIP1Hn000F?P00140
F?P000<007dM06IVIP00O@D00`00O@D2003h2@0301=m000000004gd001009oP02P1Fl`0200267`80
0?Pk1000QPD6003h2A@09_<01@3oool00`00Sb800?Pk002?1@04002?1@800?P90P0FS`0?02Kc00T0
9oP01P3oool3002G1P800?P9100HU`0F02Oh00X0oooo1@0IWP0202Oh00<0>9h0601Fl`070?ooo`03
01ZU000Wn0009oP000D0>ZD02`1Hn00?08Oc00L0oooo0`0lZ`0205Sh00<0GZ/06027l`090?ooo`H0
H[001`29n00D0;Oc00P0oooo00<0I;D008Wh0029n0001P28]@050;Oc00/0^_L02P3Wl`060?ooo`<0
S;X00`2jm`040;2j00l0io<0203[m`080?ooo`H0];h0303[m`0?0???00/0oooo1@32Y@0:0???00`0
mm802`3oool30<FX00<0mm8000<0aH400?>O003cW`00603cW`080?ooo`H0b8<0303gX@0?0?=_06`0
oooo002?0?ooo`<000007@3oool00`000000oooo0?ooo`060?ooo`80079800D00?RM001b<P00LS80
078b003hK002001b6`0306IVIP00n3/00?Pk00<0078400<00?P9019b000BLP000`0VlP0302Qb00@0
F?P000<0IVIV05Sh001Hn0004@1Hn0000`00OAd0IVIV001m1@03001m1@800?P900<04gd00000000C
O@001@0Vl`0@02Oh00D0E_<00P00QQl2003h>`@008H52`00n0T?02Kc00@0oooo0P00Sb800`00n3/0
08l5002?1@03002?1@800?P900<05Xl002Kc000Vl`004`0Vl`0402Oh00D0oooo1000U`H2003h2@@0
69L05P0Wn00:0?ooo`D06Ih00P0Wn00203RN01T0E_<01`3oool00`0JY@009oP002Oh000503ZU0100
F?P02P27l`070?ooo`<0?:/00P1Hn00205j[01T0Qo<02@3oool606:`00/0ROP03`2gl`080?ooo`80
I;D00P29n00508Re00X0]o<02`2jm`050>Oc00H0oooo102<^P030;[g00<0/;X0503Wl`040>_g00P0
oooo1P2d_P0@0>_g00X0lll02@3oool00`2h`P00joL00>_g00040<:U00l0lll0203gdP0:0?ooo`@0
aJP00`3gdP0J0?>O00P0oooo1`38P`050?>O00/0mj402P3cK`1]0?ooo`00TP3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo00D0oooo0`00LTP02000n9d0078b001b<P00LS800?Q/001b
6`1VIVH0078K0P00n3/2001b10800?P900<04W8002Kb000VlP000P0VlP0302Qb00<0F?P000<0IVIV
05Sh001Hn0004P1Hn0000`1VIVH00?Pk001m1@03001m1@800?P900<0000001=m000Vl`002P0Vl`0>
02Oh0004003hK000QQl008HO00267`800?Pk1000QPD?003h2@X09_<01@3oool2002?8P03003h>`00
S`D008l500<008l50P00n0T00`0FS`009_<002Kc000G02Kc00@0oooo1@00U`H2003h2@@069L01@0V
l`0A02Oh00X0oooo1@0IWP0202Oh0080>9h0601Fl`070?ooo`806ZD00P0Wn00403ZU01D0F?P01@27
l`070?ooo`@0?:/00P1Hn00205j[01P0Qo<02P3oool606:`0100ROP02P2gl`080?ooo`80I;D00P29
n00408Re00l0]o<0202jm`090?ooo`D0S;X00`2jm`030;2j01P0io<0203oool60;Bn01@0joL01@3c
c`090?ooo`80^<800P3[m`030<:U01@0lll0103gdP090?ooo`D0aJP0203gdP0D0?>O00X0oooo1@38
P`0:0?>O00/0mj401@3cK`1^0?ooo`00TP3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo00D0oooo0`00LTP02000n9d0078b001b<P00LS800?Q/001b6`1VIVH0078K0P00n3/2001b1080
0?P900<04W8002Kb000VlP000P0VlP0202Qb00@0F?P000<0IVIV05Sh001Hn0004P1Hn0000`1VIVH0
0?Pk001m1@03001m1@800?P900<0000001=m000Vl`003P0Vl`0:02Oh0004003hK000QQl008HO0026
7`800?Pk1000QPDD003h2@D09_<0103oool3002?8P03003h>`00S`D008l500<008l50P00n0TJ02Kc
00@0oooo1@00U`H2003h2@<069L02P0Vl`0=02Oh00P0oooo0P00n0T501VN00809oP000<0>9h005Kc
001Fl`005`1Fl`060?ooo`<06ZD00P0Wn00403ZU00D0E_<04@1Hn00:0?ooo`D0?:/00P1Hn0000`1N
Z`00Qo<008Oc000G08Oc00P0oooo0P1Hn00606:`01@0ROP01@2gl`080?ooo`<0I;D00P29n00308Re
01@0]o<0102jm`080?ooo`H0S;X00`2jm`020;2j01T0io<0203oool60;Bn01H0joL02`3oool30;S2
0080joL00`32Y@0H0???00P0oooo1P35Z00<0?OB00l0lil02`3oool40<R300l0lil0203gX@1b0?oo
o`00CP3oool6000000<0oooo0`000000103oool000000000000000030?ooo`8000000P3oool30000
0080oooo0P0000000`3oool000000?ooo`03000000040?ooo`0000000000000000@0oooo0`000004
0?ooo`<0000000<0oooo0000003oool0100000040?ooo`@000001@3oool3003oe1<0oooo00<00000
0?ooo`3oool01@3oool4001bB006003hW@00LS80078b001b<P00n6`0IVIV0P00LQ/2003h>`800784
0P00n0T502Kb0080:780101FlP000`1VIVH0F?P005Sh000A05Sh000306IVIP00OAd00?Pk00@007d5
0P00n0T00`0000009_<002Kc000C02Kc00D09oP000@00?Q/00267`00QQl008HO0P00n3/400261AL0
0?P91P3oool3002?8P03003h>`00S`D008l500<008l50P00n0TI02Kc00D0oooo1@00U`H2003h2@<0
69L03`0Vl`0802Oh00L0oooo00<009h6003h2@00n0T01@0IWP0202Oh01T0E_<01`3oool301ZU0080
9oP0100jY@0905Kc00d0F?P02P3oool503b[0080F?P06@27l`080?ooo`0303j`001Hn000F?P000H0
H[005@29n00;0?ooo`@0I;D00P29n00308Re01P0]o<02@3oool508bj00<0^_L000<0/;X00>Oc003W
l`005`3Wl`060?ooo`0308nn002jm`00^_L000H0];h05P3[m`0:0?ooo`@0^<800P3[m`020<:U01T0
lll01`3oool70<FX0100mm802P3cW`0<0?ooo`<0b8<0503cW`040?NQ0780oooo001?0?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0000
003oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool0
1@000000oooo0?ooo`3oool0000000@0oooo1@00om@B0?ooo`030000003oool0oooo00D0oooo1000
LTP01P00n9d0078b001b<P00LS800?Q/06IVIP80078K00@00?Pk001b1000LP@007840P00n0T502Kb
0080:7800`1FlP000`1VIVH0E_8005Kb000405Kb00h0F?P000<0IVIV001m7@00n3/01000O@D2003h
2@030000000Vl`009_<001L09_<00P00n6`300267`800?Pk1000QPDG003h2@D0oooo1000Sb800`00
n3/008l5002?1@03002?1@03003h2@0Vl`009_<001P09_<01@3oool5002G1P800?P90P0HU`0D02Kc
00@09oP01`3oool00`00WPH00?P9003h2@0501VN00L09oP0501Fl`060?ooo`@06ZD00P0Wn00303ZU
00l0E_<0201Hn00:0?ooo`D0?:/0201Hn00B08Oc00T0oooo00<0?[0005Sh001Hn0001P1R/00508Oc
0100ROP02`3oool406Be0080ROP00P28]@0I0;Oc00T0oooo1@2<^P030;[g01T0io<01P3oool208nn
0080^_L01P2d_P060>Oc0100joL02P3oool40;S20080joL000<0`ZD00???003cc`005`3cc`090?oo
o`H0aJP0503gdP050?>O00T0oooo00@0b:/00?OB003gdP00mm800`38P`0H0?>O0780oooo001?0?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000`3oool7003oe100oooo00<000000?ooo`3oool01P3oool4001bB005003hW@00
LS80078b001b<P1VIVH00`00LQ/01@00n3/00784001b1000LP@00?P900H09_8000<0:78005Kb001F
lP000P1FlP000`1VIVH0E_8005Kb000905Kb00P0F?P000@0IVIV05Sh0000OAd00?Pk1000O@D2003h
2@030000000Vl`009_<001L09_<00P00n6`300267`800?Pk0`00QPDH003h2@D0oooo1000Sb800`00
n3/008l5002?1@03002?1@H00?P9500Vl`050?ooo`03003h>`00U`H009L600<009L60P00n0T00`0H
U`009_<002Kc000G02Kc00H0oooo0P00WPH2003h2@D06Ih02`0Wn00?05Kc00H0oooo1@0JY@0202Oh
00<0>ZD04`1Fl`0405Sh00X0oooo1@0lZ`0=05Sh00d0Qo<0203oool203j`0080F?P01@1R/00:08Oc
00`0ROP02P3oool506Be0080ROP000<0R;D00;Oc002gl`005`2gl`0:0?ooo`D0S;X0202jm`0C0>Oc
00H0oooo0`2?_P020;[g00D0];h0303Wl`0;0>_g00T0oooo1@2h`P020>_g01T0lll02P3oool60<FX
01D0mm80303oool20<R[00<0mm800P38P`0I0?>O0780oooo001?0?ooo`030000003oool0oooo00@0
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo1@0000020?oo
o`050000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool7003oe100oooo00<000000?oo
o`3oool01P3oool4001bB0@0078b00D0IVIV001b6`00LQ/0078K003h>`03001b10H00?P900<09_80
02Qb001FlP000P1FlP000`1VIVH0E_8005Kb000?05Kb00<0F?P000@0IVIV05Sh0000OAd00?Pk1000
O@D2003h2@030000000Vl`009_<001H09_<000<008Hj003hK000n6`00`00QQl2003h>`<008H51@00
l`TC003h2@D0oooo1000Sb800`00n3/008l5002?1@03002?1@X00?P93`0Vl`050?ooo`03002G9000
n3/009L600@009L60P00n0T00`0HU`009_<002Kc000G02Kc00H0oooo0P00WPH2003h2@D06Ih0400W
n00:05Kc00H0oooo1@0JY@0202Oh0080>ZD0601Fl`080?ooo`809oP01@0lZ`0C05Sh00H0Qo<0203o
ool303j`0080F?P0101R/00?08Oc00P0ROP02@3oool606Be0080ROP06@2gl`0;0?ooo`D0S;X01@2g
l`070;[g00l0io<01@3oool408nn0080^_L0102d_P0C0>Oc00D0joL0203oool60;S200L0joL04`3c
c`0;0?ooo`H0aJP01P3cc`0?0?OB00/0oooo0`38Z`030?OB00030<R3003cW`00lil001L0lil0L`3o
ool004l0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`000000
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`L00?oD3`3oool00`000000oooo0?ooo`070?ooo`@00798
1000LS801@1VIVH0078K001b6`00LQ/00?Pk00<007841`00n0T01@0XLP00E_8005Kb001FlP00IVIV
01<0E_8000D0IVIV05Kb0000OAd007dM003h>`04001m1@03003h2@0Vl`00000001P09_<000<008Hj
003hK000n6`00`00QQl2003h>`8008H52`00l`T>003h2@D0oooo1000Sb800`00n3/008l5002?1@02
002?1A000?P92P0Vl`050?ooo`03002G9000n3/009L600@009L60P00n0TI02Kc00H0oooo0`00WPH2
003h2@D06Ih01P0Vl`0>02Oh00D0E_<01`3oool501ZU00809oP00P0jY@0H05Kc00L0oooo00<06j/0
02Oh000Wn0001@0lZ`0F05Sh00/0oooo0`0n/00205Sh00<0H[005027l`0408Wh00T0oooo1P1T]@07
08Wh01<0]o<02@3oool308Wh00@0S;X02P2gl`070;[g00X0io<01P3oool408nn0080^_L00`2d_P0I
0>Oc00L0oooo1`2h`P0;0>_g00l0lll02`3oool50<FX00`0lll02P3gdP0:0?ooo`@0b:/00`3gdP0I
0?>O07@0oooo001?0?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`80000000D0oooo0000
0000000000000?ooo`0300000080oooo0`0000020?ooo`<0000000<0oooo0000003oool00P3oool4
000000@0oooo0`0000020?ooo`8000000P3oool200000080oooo00<000000?ooo`0000000P000003
0?ooo`<0000000<0oooo0000003oool00P3oool5003oe0`0oooo0P0000020?ooo`030000003oool0
oooo00H0oooo00<00?S?001bB000LTP00P00LTP3001b<P0306IVIP00n6`0078K0080078K00@00?Pk
001b1000LP@007841`00n0T305Kb000306IVIP1FlP00E_800180E_8000D0IVIV05Kb0000OAd007dM
003h>`04001m1@800?P900@00000003h2@00n0T00?P9500Vl`020026>P800?Q/0`00QQl2003h>`80
08H53`00l`T:003h2@<0oooo0P00n6`4002?8P03003h>`00S`D008l5008008l51P00l`T>003h2@D0
9_<01@3oool2002G9003003h>`00U`H009L600<009L600<00?P902Kc000Vl`00600Vl`050?ooo`@0
09h60P00n0T401VN00`09_<02`0Wn00:0?ooo`D06ZD00P0Wn0000`0jY@00E_<005Kc000F05Kc00P0
oooo00<06j/002Oh000Wn0001@0lZ`0F05Sh00X0oooo100n/00205Sh00<0H[006027l`090?ooo`H0
I;D02`29n00?0;Oc00P0oooo00@0IkX008Wh0029n000ROP0102<^P0?0;Oc00H0^_L01@3Wl`060?oo
o`D0Skh00P2jm`030;Bn01T0io<01`3oool70;S200l0joL02P3cc`090?ooo`030;_5003[m`00joL0
00@0aJP04P3cc`050?OB00X0oooo1038Z`070?OB01@0lil0M@3oool004l0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0S0?ooo`<00?oD3`3oool4000000H0oooo00<0079O003hc`00
LTP00P00LTP01P00n9d0078b001b<P00LS80IVIV003hK0<0078K00@00?Pk001b1000LP@007841`00
n0T305Kb000306IVIP1FlP00E_800140E_8000<0IVIV05Kb001FlP000P00OAd00`00n3/007d5001m
1@02001m1@800?P90P000007003h2@l09_<00P00QSX00`00n6`008HO00267`0200267`800?Pk00<0
08H5003c2@00l`T04`00l`T5003h2@80oooo00<008ln003hK000n6`01000Sb801000n3/008l5002?
1@00S`D<003c2@`00?P91P3oool3002G9003003h>`00U`H009L600<009L61P00n0TD02Kc00H0oooo
1000WPH2003h2@@06Ih04P0Vl`0502Oh00P0oooo0P00n0T501ZU00809oP000<0>ZD005Kc001Fl`00
5P1Fl`070?ooo`806j/00P0Wn00503b[01H0F?P02@3oool503j`0080F?P00P1R/00I08Oc00T0oooo
1P1T]@0?08Wh00X0]o<0203oool206Nj00<0ROP00`2<^P0D0;Oc00@0^_L0203oool608nn0080^_L0
0P2d_P0I0>Oc00P0oooo1`2h`P0C0>_g00D0lll02@3oool20;_50080joL00`35Z00H0???00T0oooo
1@38Z`0;0?OB00l0lil0MP3oool004h0oooo0`00000Q0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool00P0000040?ooo`03001bG`00n<l007980080079800H00?RM001b<P00LS80IVIV
001b<P00n6`3001b6`04003h>`00LP@00784001b10L00?P90P1FlP000`1VIVH0E_8005Kb000B05Kb
000406IVIP1FlP0007dM001m7@800?Pk1000O@D2003h2@0400000000n0T00000000000T00?P92P0V
l`030026>P03003hK000QQl008HO008008HO0P00n3/00`00QPD00?<9003c2@0G003c2@<0oooo00<0
08ln003hK000n6`01000Sb801000n3/008l5002?1@00S`DB003c2@H00?P91P3oool3002G9003003h
>`00U`H009L600<009L62P00n0T?02Kc00L0oooo1000WPH2003h2@<06Ih0600Vl`070?ooo`03002U
1P00n0T00?P900D06ZD00P0Wn00H05Kc00L0oooo0`0KZ`0202Oh00D0?:/01@1Fl`0A05Sh00T0oooo
1@0n/00205Sh000306:`0027l`00Qo<001L0Qo<0203oool205Sh00H0I;D04`29n0050;Oc00P0oooo
0`1W^P0308Wh0080S;X06@2gl`070?ooo`L0Skh00P2jm`000`2d_P00io<00>Oc000G0>Oc00T0oooo
1`2h`P0E0>_g00/0oooo0`2ka@020>_g00<0aJP0603cc`080?ooo`H0b:/03`3gdP0:0?>O07L0oooo
001a0?ooo`800000>03oool00`000000oooo0?ooo`050?ooo`80079O00D00?S?001bB000LTP00798
003hW@02001b<P0306IVIP00LS800?Q/0080078K0P00n3/3001b10H00?P90`1FlP000`1VIVH0E_80
05Kb000B05Kb000406IVIP1FlP0007dM001m7@800?Pk1000O@D2003h2@0300000000n0T00?P900l0
0?P91@0Vl`030026>P03003hK000QQl008HO008008HO0P00n3/J003c2@80oooo0P00Sch2003hK0@0
08lR00<00?Pk002?1@00S`D06000l`T60?ooo`@009LT00<00?Pk002G1P00U`H00P00U`H@003h2@X0
9_<01`3oool4002N1P800?P90P0IWP0I02Kc00L0oooo00<00:D6003h2@00n0T01@0JY@0802Oh0140
E_<0203oool301^[00809oP0100lZ`0:05Kc00d0F?P02@3oool503j`0080F?P06P27l`070?ooo`03
042e001Hn000F?P000H0I;D01@27l`0@08Wh00/0oooo0`1W^P0308Wh0080S;X06@2gl`080?ooo`H0
Skh00P2jm`0I0>Oc00L0oooo00<0TL800;[g002jm`001`2h`P0E0>_g00X0oooo102ka@020>_g0080
aJP0603cc`080?ooo`L0b:/04`3gdP050?>O07P0oooo002Z0?ooo`030000003oool0oooo00H0oooo
0P00LUl02000n<l00798001bB000LTP00?RM001b<P1VIVH0078b0P00n6`2001b6`800?Pk0`00LP@9
003h2@0306IVIP00n0T0E_800140E_8000<0IVIV05Kb0000OAd00P00OAd2003h>`<007d50`00n0T0
0`0000000?P9003h2@0B003h2@03003hW@00QSX008Hj008008Hj00<00?Q/00267`00QQl00P00QQl2
003h>aT00?<90`3oool2002??P800?Q/1000Sb800`00n3/008l5002?1@0H003c2@D0oooo1@00Ub@0
0`00n3/009L6002G1P02002G1PD00?<93`00n0T502Kc00P0oooo1000WPH2003h2@806Ih0600Vl`07
0?ooo`800:D60P00n0T501ZU00d09oP0301Fl`070?ooo`@06j/00P0Wn00403b[00l0E_<0201Hn009
0?ooo`D0?[001`1Hn00D08Oc00L0oooo0P10]@0205Sh00D0I;D02P27l`0<08Wh00X0oooo101W^P03
08Wh000308bj002gl`00]o<001L0]o<02@3oool608nn00P0^_L04P3Wl`070?ooo`80TL800P2jm`07
0;S200D0io<0403[m`090?ooo`D0^lD00P3[m`000`35Z000lll00???000F0???00X0oooo1P38Z`0E
0?OB07/0oooo002Z0?ooo`030000003oool0oooo00D0oooo0`00LUl02@00n<l00798001bB000LTP0
0?RM001b<P1VIVH0078b003hK003001b6`800?Pk0`00LP@8003h2@0306IVIP00n0T00?P900D00?P9
3@1FlP000`1VIVH0E_80001m7@02001m7@800?Pk0`00O@D3003c2@0300000000l`T00?P901800?P9
00<00?RM0026>P00QSX00P00QSX01000n6`008HO00267`00QQl2003h>aX00?<90P3oool3002??P80
0?Q/1000Sb800`00n3/008l5003c2@0G003c2@H0oooo1@00Ub@01000n3/009L6002G1P00U`H:003c
2@h00?P9203oool2003h>`@009h60P00n0T00`0IWP009_<002Kc000G02Kc00H0oooo0`00Y@H2003h
2@D06ZD04P0Wn00605Kc00L0oooo1@0KZ`0202Oh00<0?:/0501Fl`0405Sh00T0oooo1@0n/00;05Sh
00l0Qo<01`3oool3042e0080F?P0101T]@0?08Oc00P0ROP02@3oool506Nj00<0ROP06@2gl`0:0?oo
o`H0Skh03@2jm`0<0>Oc00L0oooo0`2A`P020;[g00H0^<802P3Wl`0<0>_g00P0oooo1P2ka@020>_g
01P0lll02`3oool60<R[00D0lll0403gdP1k0?ooo`00Z@3oool00`000000oooo0?ooo`050?ooo`@0
079O00H00?S?001bB000LTP00798003hW@1VIVH2001b<P04003hK000LQ/0078K001b6`800?Pk0P00
LP@9003h2@0306IVIP00n0T00?P900T00?P9201FlP000`1VIVH0E_80003hK003001m7@800?Pk0P00
O@D4003c2@0300000000l`T00?<900@00?<93P00n0T00`00n9d008Hj0026>P020026>P04003hK000
QQl008HO00267`H00?<j00<00?Pk003c2@00l`T04P00l`T30?ooo`<008ln0P00n6`4002?8P03003h
>`00S`D00?<901L00?<91P3oool5002G9004003h>`00U`H009L6002G1Pl00?<92@00n0T70?ooo`03
002N9@00n3/00?Pk00@009h60P00n0TI02Kc00L0oooo0`00Y@H2003h2@D06ZD01@0Vl`0@02Oh00X0
oooo1@0KZ`0202Oh0080?:/06@1Fl`060?ooo`0301^`000Wn0009oP000D0?[00401Hn00:08Oc00L0
oooo0`10]@0205Sh00<0I;D05027l`0408Wh00P0oooo1P1W^P0808Wh01<0]o<02`3oool608nn0180
^_L01P3Wl`070?ooo`@0TL800P2jm`050;S200l0io<0203[m`070?ooo`L0^lD0203[m`0B0???00/0
oooo1@38Z`0:0???00`0mm80N`3oool00480oooo0`0000020?ooo`040000003oool0oooo0?ooo`<0
0000103oool00`000000oooo0000000;0?ooo`D000000`3oool3000000@0oooo0`0000000`3oool0
00000?ooo`0600000080oooo0`0000000`3oool000000000000200000080oooo0P0000020?ooo`<0
000000<0oooo0000003oool00P3oool3003hoa<0oooo00<000000?ooo`3oool01@3oool4001bG`06
003hc`00LTP00798001bB000n9d0IVIV0P00LS801000n6`0078K001b6`00LQ/2003h>`8007841@00
lPT3003h2@0306IVIP00n0T00?P900h00?P900L007e?05Kb001FlP00E_8006IVIP1FlP000?Q/00<0
07dM0P00n3/2001m1@@00?<900<00000003c2@00l`T02000l`T:003h2@03003hW@00QSX008Hj0080
08Hj00<00?Q/00267`00QQl03000lcX?003c2@<0oooo1000Sch2003hK0<008lR0P00n3/H003c2@L0
oooo1@00Ub@00`00n3/009L6002G1P0D003c2@D00?P91`3oool00`00WRD00?Pk003h>`04002N1PP0
0?P94P0Vl`070?ooo`@00:D60P00n0T401ZU00X09_<0300Wn00:0?ooo`D06j/00P0Wn00203b[01T0
E_<01@3oool201^`00809oP01@0n/00D05Sh00D0Qo<01`3oool4042e0080F?P00`1T]@0H08Oc00T0
oooo1@1W^P0<08Wh00l0]o<0203oool308Wh00H0Skh01P2gl`0?0;[g00X0oooo102A`P020;[g00@0
^<80503Wl`040>_g00H0oooo202ka@0=0>_g00`0lll0303oool40<R[00l0lll0203gdP1k0?ooo`00
@`3oool00`000000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0000000/0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool5003hoa80oooo00<000000?ooo`3oool01@3oool4001b
G`06003hc`00LTP00798001bB000n9d0IVIV0P00LS801000n6`0078K001b6`00LQ/2003h>`800784
2000lPT00`1VIVH00?89003h2@0>003h2@05001mC`00n9d007df06IVIP00OCH00P00n6`3001m7@80
0?Pk00<007d5003c2@00l`T00`00l`T00`0000000?<9003c2@0=003c2@D00?P900<00?RM0026>P00
QSX00P00QSX00`00n6`008HO00267`0A003c>PX00?<90`3oool4002??P800?Q/0`00Sb85003c>P<0
0?Pk4P00l`T50?ooo`800?Q/1@00Ub@00`00n3/009L6002G1P0H003c2@L0oooo0P00WRD2003h>`@0
09h63@00n0T=02Kc00H0oooo1@00Y@H2003h2@@06ZD03P0Vl`0802Oh00X0oooo1@0KZ`0202Oh0003
03b[001Fl`00E_<001L0E_<01P3oool201^`00809oP01@0n/00505Kc0140F?P02@3oool5042e0080
F?P00P1T]@0I08Oc00T0oooo1@1W^P0@08Wh00X0]o<0203oool0101Y_P00ROP008Wh0029n00508nn
00`0]o<02P2jm`090?ooo`D0TL800P2jm`030;S201T0io<01`3oool70;_50180joL01P3cc`090?oo
o`040;k8003[m`00joL00>_g00<0b:/0503cc`040?OB07/0oooo00130?ooo`030000003oool0oooo
008000000P3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000002`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo1`00n?l@
0?ooo`030000003oool0oooo00H0oooo1000LUl4001bB00506IVIP00LS80078b001b<P00n6`00`00
LQ/2003h>`03001b1000lPT00?8900H00?8900<0IVIV003b2@00lPT01@00lPT:003h2@05001mC`00
n9d007df06IVIP00OCH00P00n6`3001m7@800?Pk00<007d5003c2@00l`T00`00l`T00`0000000?<9
003c2@0A003c2@800?RM1000QSX00`00n6`008HO003c>P0E003c>PD00?<9103oool4002??P800?Q/
0P00Sb8:003c>P@00?Pk3000l`T50?ooo`03002G@P00n6`00?Q/00D009LT00<00?Pk002G1P00l`T0
6000l`T60?ooo`<009hU0P00n3/4002N1Q<00?P91P0Vl`070?ooo`D00:D60P00n0T301ZU01<09_<0
100Wn0080?ooo`800?P91@0KZ`0202Oh01T0E_<01P3oool301^`00809oP0100n/00:05Kc00d0F?P0
203oool6042e0080F?P000<0I;D008Oc0027l`005`27l`0:0?ooo`D0IkX05029n0050;Oc00P0oooo
0P1Y_P0308Wh00@0Skh04P2gl`050;[g00P0oooo1P2A`P020;[g0080^<806P3Wl`070?ooo`L0^lD0
503[m`0<0?ooo`80_/P00`3[m`030<R[01P0lll0N`3oool004<0oooo00D000000?ooo`000000oooo
000000020?ooo`D000000P3oool01@000000oooo0000003oool0000000`0oooo00<000000?ooo`3o
ool00P3oool5000000<0oooo100000040?ooo`030000003oool0oooo00<0oooo100000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo1`00n?l@
0?ooo`030000003oool0oooo00H0oooo1000LUl4001bB00506IVIP00LS80078b001b<P00n6`00`00
LQ/2003h>`03001b1000lPT00?8900H00?8900<0IVIV003b2@00lPT02P00lPT5003h2@03001mC`00
n9d0IVIV008007df0P00n6`3001m7@800?Pk1P00l`T00`0000000?<9003c2@0A003c2@800?RM1000
QSX00`00n6`008HO003c>P0H003c>PH0oooo1000Sch2003hK08008lR3`00lcX5003h>`H00?<91@3o
ool00`00Ud800?Q/003hK005002G9003003h>`00U`H00?<901L00?<91`3oool3002N9@800?Pk1000
WPHF003h2@X0oooo1@00Y@H2003h2@806ZD0600Vl`070?ooo`03002[1P00n0T00?P900D06j/0200W
n00C05Kc00D0oooo100K/00202Oh00@0?[003`1Fl`0805Sh00P0oooo1P10]@0205Sh01T0Qo<0203o
ool305Sh00D0IkX05@29n00;0?ooo`<0JKh00`29n00308nn01P0]o<01`3oool709720080^_L000<0
^<800>Oc003Wl`00603Wl`080?ooo`L0^lD0503[m`0;0?ooo`<0_/P00`3[m`020<R[01T0lll0N`3o
ool004<0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo008000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo00L00?So2`3oool200000080oooo00<000000?ooo`3oool01P3oool00`00lOP0079O001bG`02
001bG`<0079800<0IVIV003hW@00LS800P00LS801000n6`0078K001b6`00LQ/2003h>`03001b1000
lPT00?8900D00?8900<0IVIV003b2@00lPT03`00lPT2001mC`04003hW@1VIVH007df001m=P800?Q/
0`00OAd2003h>`H00?<900<00000003c2@00l`T04000l`T00`00QUD00?RM003hW@040026>P03003h
K000lcX00?<j01L00?<j1`3oool4002??P800?Q/00<008lR003c>P00lcX04P00lcX5003h>`H0oooo
0P00Ud82003hK0D009LT00<00?Pk003c2@00l`T05`00l`T60?ooo`@009hU0P00n3/4002N1PD00?<9
4@00n0T:0?ooo`D00:D60P00n0T201ZU01P09_<01`3oool00`00Z`H00?P9003h2@0501^[00d09oP0
3@1Fl`060?ooo`@06k000P0Wn00303j`01@0E_<0101Hn0080?ooo`H0@;D01`1Hn00C08Oc00P0oooo
00@0@[X005Sh001Hn000F?P01@1W^P0E08Wh00/0oooo0`1Y_P0308Wh00<0Skh0602gl`080?ooo`H0
TL800P2jm`0J0>Oc00H0oooo0`2jm`070;_501@0joL02P3oool40;k800<0joL000<0b:/00???003c
c`005`3cc`1l0?ooo`00@`3oool200000080oooo00@000000?ooo`3oool0oooo0`0000020?ooo`<0
000000@0oooo00000000000000002@3oool010000000oooo0?ooo`0000040?ooo`<000000`3oool4
000000D0oooo00<000000?ooo`3oool00P3oool400000080oooo00<000000?ooo`0000000P000004
0?ooo`@000000`3oool5003ho`h0oooo100000060?ooo`03001_LP00lOP0079O0080079O00D00?S?
001bB000LTP0079806IVIP04001b<P04003hK000LQ/0078K001b6`800?Pk2000lPT00`1VIVH00?89
003b2@0?003b2@8007e?00@0IVIV001m=P00OCH007df0P00n6`3001m7@03003h>`00l`T00?<900@0
0?<900<00000003c2@00l`T04@00l`T00`00QUD00?RM003hW@040026>P03003hK000lcX00?<j01L0
0?<j1@3oool2003hW@@008ln0P00n6`00`00Sb800?<j003c>P0F003c>PL0oooo0P00Ud82003hK0@0
09LT1`00n3/C003c2@H0oooo1@00WRD2003h>`<009h62P00l`T=003h2@X0oooo1@00Y@H2003h2@03
01ZU000Vl`009_<001H09_<01`3oool2002[1P800?P91@0KZ`0502Kc00h09oP01P1Fl`060?ooo`D0
6k000P0Wn00203j`01T0E_<0203oool6042e00/0F?P03`27l`070?ooo`80@[X00`1Hn00506Nj00D0
Qo<04029n00:0?ooo`@0JKh00`29n00208nn01P0]o<02@3oool6097200L0^_L0503Wl`060?ooo`04
09C5002jm`00^_L00;[g00L0^lD0103Wl`0@0>_g00T0oooo1@2nb0030>_g01T0lll0O@3oool004<0
oooo0P0000020?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0oooo0000000B0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool3003hoa00oooo00<000000?oo
o`3oool00P0000040?ooo`03001_LP00lOP0079O0080079O00D00?S?001bB000LTP0IVIV001bB004
001b<P04003hK000LQ/0078K001b6`800?Pk1`00lPT00`1VIVH00?89003b2@0?003b2@8007e?00<0
0?RM06IVIP00OCH00P00OCH2003hK0<007dM1P00n3/00`00l`T00000003c2@0A003c2@8008IE0P00
n9d40026>QT00?<j1@3oool00`00Se/00?RM003hW@04002??P800?Q/6@00lcX60?ooo`<009M20P00
n6`4002G90D00?<j1P00n3/?003c2@H0oooo1@00WRD2003h>`<009h63`00l`T8003h2@P0oooo0P00
n3/5002U1P800?P96@0Vl`060?ooo`<00:/60P00n0T401^[00X09_<0300Wn0090?ooo`H06k000P0W
n00203j`01T0E_<0203oool6042e00l0F?P02P27l`070?ooo`<0@[X00`1Hn00406Nj00X0Qo<03029
n0090?ooo`D0JKh00`29n0000`2?_P00]o<00;Oc000F0;Oc00X0oooo1P2A`P0;0;[g00l0io<01P3o
ool209C500<0^_L01P2ka@090>Oc00`0joL0203oool60;k800L0joL0503cc`1n0?ooo`00@P3oool2
00000080oooo0`00000G0?ooo`D000004P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool01@3oool2001_LP05003an000LUl0079O001bG`00n<l00P00
LTP00`1VIVH00798001b<P03001b<P05003hK000LQ/0078K001b6`00n3/02000lPT00`1VIVH00?89
003b2@0?003b2@8007e?00<0IVIV003hW@00OCH00P00OCH2003hK0<007dM1`00n3/0100000000?Pk
003h>`00n3/?003c2@8008IE0P00n9d40026>PH00?Q/4`00lcX50?ooo`03002?F`00n9d00?RM00@0
08ln0P00n6`H003c>PL0oooo0`00Ud82003hK0<009LT2P00lcX7003h>`T00?<91`3oool5002N9@80
0?Pk0P00WPHD003c2@@00?P91`3oool00`00YBL00?Pk003h>`05002U1PL00?P94`0Vl`070?ooo`<0
0:/60P00n0T401^[00h09_<0200Wn00:0?ooo`D06k000P0Wn0000`0n/000E_<005Kc000G05Kc00L0
oooo0P0Wn006042e00H0E_<03@1Hn00508Oc00P0oooo0`12^P0305Sh00@0IkX03P27l`0808Wh00P0
oooo1P1Y_P0308Wh01P0]o<0203oool308Wh00H0TL801@2gl`0:0;[g00X0io<01P3oool309C500<0
^_L01@2ka@0>0>Oc00P0joL01`3oool70;k800/0joL03`3cc`1o0?ooo`00L@3oool3000000040?oo
o`0000000000000001D0oooo0P00000F0?ooo`030000003oool0oooo00H0oooo0P00Kg802@00lOP0
079O001bG`00LUl00?S?001bB01VIVH00798003hW@04001b<P04003hK000LQ/0078K001b6`H00?Pk
0`00lPT00`1VIVH00?89003b2@0>003b2@05003hc`00ODl007e?06IVIP00n9d00`00OCH2003hK0<0
07dM1`00n3/00`0000000?Pk003h>`05003h>`X00?<90`00QUD2003hW@@008Hj3000n6`<003c>PD0
oooo0P00Se/2003hW@@008ln00<00?Q/003c>P00lcX05`00lcX60?ooo`@009M20P00n6`3002G90l0
0?<j1P00n3/5003c2@L0oooo1@00WRD2003h>`8009h66000l`T60?ooo`800:DW0P00n3/5002U1P/0
0?P93P0Vl`070?ooo`@00:/60P00n0T301^[01<09_<0100Wn00:0?ooo`D06k000P0Wn00I05Kc00L0
oooo00<07;D002Oh000Wn0001@10]@0<05Kc00X0F?P02P3oool404:j00<0F?P00`1W^P0C08Oc00@0
ROP02@3oool506Vn00T0ROP04P2gl`070?ooo`0406_20029n000ROP008Wh00D0TL802P2gl`0:0;[g
00D0io<01`3oool309C500<0^_L0102ka@0C0>Oc00@0joL0203oool60;k800l0joL02P3cc`200?oo
o`00M03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00D0oooo0`00Kg802@00lOP0
079O001bG`00LUl00?S?001bB01VIVH00798003hW@04001b<P03003hK000LQ/0078K00T00?Pk00<0
IVIV003h>`00n3/03`00lPT00`00n<l007e?06IVIP02003hW@<007df0P00n6`3001m7@L00?Pk00<0
0000003h>`00n3/02P00n3/5003c2@<008IE0P00n9d40026>Q800?Q/1P00lcX50?ooo`8008mK0P00
n9d4002??PL00?Q/4P00lcX70?ooo`@009M20P00n6`2002G91@00?<j1000n3/90?ooo`03003hK000
WRD009hU00<009hU0P00n3/00`00WPH00?<9003c2@0G003c2@H0oooo0P00YBL2003h>`D00:D63`00
n0T:02Kc00H0oooo1@00Z`H2003h2@806j/0600Vl`0:0?ooo`D06k001`0Wn00C05Kc00L0oooo0P0L
]@0202Oh00@0@;D04P1Fl`0505Sh00T0oooo1@12^P0305Sh0080IkX06027l`090?ooo`D0JKh03P29
n00<0;Oc00L0oooo0P1[`P0308Wh00@0TL803`2gl`080;[g00T0oooo102Da@030;[g00<0^lD0603W
l`080?ooo`H0_/P04`3[m`050???0840oooo001d0?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool01@3oool3001_LP09003an000LUl0079O001bG`00n<l0079806IVIP00LTP00?RM00@0
078b00<00?Q/001b6`00LQ/02@00n3/00`1VIVH00?Pk003h>`04003h>`X00?8900@00?S?001mC`00
ODl0IVIV0P00n9d3001m=P800?Q/0P00OAd8003h>`0300000000n3/00?Pk00d00?Pk00<00?S?0026
E@00QUD00P00QUD2003hW@@008Hj5P00n6`60?ooo`<008mK0P00n9d4002??P`00?Q/3@00lcX70?oo
o`@009M20P00n6`2002G91P00?<j203oool00`00WTD00?Q/002N9@04002N9@800?Pk00<009h6003c
2@00l`T05P00l`T60?ooo`<00:DW0P00n3/5002U1PH00?<93@00n0T502Kc00L0oooo1@00Z`H2003h
2@806j/0600Vl`070?ooo`<00?P91@0K/00;02Oh00l0E_<01`3oool201be00809oP00`10]@0H05Kc
00P0oooo1P12^P0305Sh0080IkX06027l`090?ooo`D0JKh04`29n0060;Oc00L0oooo0`1[`P0308Wh
00<0TL80502gl`040;[g00P0oooo1@2Da@030;[g0080^lD06@3Wl`080?ooo`H0_/P05@3[m`240?oo
o`00FP3oool5000000@0oooo0`0000030?ooo`H000000P3oool400000080oooo1@0000030?ooo`<0
000000L0oooo00000000000000000?ooo`000000oooo00800000103oool30035oa80oooo00<00000
0?ooo`3oool01@3oool4001_LP06003an000LUl0079O001bG`00n<l0IVIV0P00LTP01000n9d0078b
001b<P00LS82003hK080078K2000n3/00`1VIVH00?Pk003h>`0:003h>`D00?8900@00?S?001mC`00
ODl0IVIV0P00n9d3001m=P800?Q/0P00OAd6003c>@800?Pk00<00000003h>`00n3/03@00n3/00`00
n<l008IE0026E@020026E@800?RM0`00QSXG003hK0D0oooo1000Se/2003hW@@008ln4P00n6`6003c
>PP0oooo1000Ud82003hK003002G9000lcX00?<j01L00?<j203oool00`00WTD00?Q/002N9@04002N
9@800?Pk6000l`T60?ooo`@00:DW0P00n3/4002U1P`00?<92P00n0T:0?ooo`D00:/60P00n0T00`0K
Z`009_<002Kc000F02Kc00L0oooo00@00;07003h2@00n0T00?P91@0K/00?02Oh00X0E_<01`3oool3
01be00809oP00`10]@0H05Kc00T0oooo1@12^P0305Sh000306Nj0027l`00Qo<001H0Qo<01`3oool3
05Sh00D0JKh05@29n00;0?ooo`<0Jl800`29n003097201P0]o<01`3oool609C500<0^_L000<0^lD0
0>Oc003Wl`005`3Wl`090?ooo`H0_/P05@3[m`240?ooo`00F`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool000000?ooo`000000103oool50035oa40oooo00<000000?oo
o`3oool01@3oool4001_LP06003an000LUl0079O001bG`00n<l0IVIV0P00LTP01000n9d0078b001b
<P00LS82003hK080078K2000n3/00`1VIVH00?Pk003h>`0=003h>`8007eX00@00?S?001mC`1VIVH0
07e?0P00n9d3001m=P800?Q/0P00OAd8003c>@0400000000lcT00?<i003c>@`00?Pk00<00?S?0026
E@00QUD00P00QUD2003hW@<008Hj1P00lfXA003hK0D0oooo1000Se/2003hW@@008ln5P00n6`80?oo
o`800?RM1000Ud82003hK003002G9000lcX00?<j01H00?<j203oool2002NA@03003hK000WRD009hU
00<009hU2000n3/B003c2@D0oooo1@00YBL2003h>`@00:D64@00l`T5003h2@X0oooo1@00Z`H2003h
2AT09_<01`3oool01000/0L00?P9003h2@00n0T501^`01<09oP01@1Fl`070?ooo`@07;D00P0Wn002
042e01P0E_<02P3oool504:j00<0F?P06027l`070?ooo`0404>n001Hn000F?P005Sh00D0JKh01P27
l`0?08Wh00X0oooo101[`P0308Wh0080TL806@2gl`070?ooo`H0U<D00`2jm`0I0>Oc00H0oooo00@0
UlP00;[g002jm`00^_L01P2nb00E0>_g08@0oooo001K0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool000000?ooo`0000000`3oool70035o`l0oooo00<000000?ooo`3oool01P3oool4
001_LP05003an000LUl0079O001bG`1VIVH00`00LTP01000n9d0078b001b<P00LS82003hK080078K
1`00n3/00`1VIVH00?Pk003h>`0>003h>`8007eX00@00?S?001mC`1VIVH007e?0P00n9d3001m=P80
0?Q/00<007dM003c>@00lcT01`00lcT00`0000000?<i003c>@07003c>@H00?Pk00<00?S?0026E@00
QUD00P00QUD2003hW@8008Hj3000lfX<003hK0D0oooo1000Se/2003hW@<008ln5`00n6`70?ooo`03
002GH000n9d00?RM00@009M20P00n6`I003c>PL0oooo0`00WTD00`00n6`009hU002N9@03002N9@H0
0?<j1`00n3/<003c2@H0oooo1@00YBL2003h>`<00:D65`00l`T80?ooo`800?Pk1@00Z`H7003h2A<0
9_<01`3oool2002`1`<00?P91@0K/00602Kc00l09oP02@3oool501be00809oP000<0@;D005Kc001F
l`005`1Fl`0:0?ooo`D0@[X02@1Hn00B08Oc00H0oooo0P13_P0305Sh00@0JKh03027l`0:08Wh00T0
oooo1@1[`P0308Wh00030972002gl`00]o<001L0]o<0203oool609C500T0^_L04P3Wl`060?ooo`80
UlP00`2jm`060;k800H0io<03`3[m`240?ooo`00F`3oool01@000000oooo0?ooo`3oool000000080
oooo1@0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
00000?ooo`0000000`3oool70035o`l0oooo00<000000?ooo`3oool01P3oool4001_LP@0079O00D0
IVIV001bB000LTP00798003hW@03001b<P04003hK000LQ/0078K001b6`L00?Pk00<0IVIV003h>`00
n3/03P00n3/01000OFP00?S?003hc`1VIVH2001mC`800?RM0`00OCH2003hK003001m7@00lcT00?<i
00L00?<i00<00000003c>@00lcT03000lcT00`00QW000?S?0026E@030026E@800?RM0P00QSXB003c
JPH00?Q/1@3oool4002?F`800?RM0`00Sch5003cJQ800?Q/1`3oool00`00Uf000?RM003hW@04002G
@PP00?Q/4P00lcX80?ooo`<009i500<00?Q/002N9@00WRD00P00WRD<003c>PL00?Pk1P00l`T70?oo
o`D00:DW0P00n3/2002U1QP00?<91`3oool00`00ZbP00?Pk003h>`05002[1P/00?P93P0Vl`070?oo
o`<00;070`00n0T401^`00`09_<02P0Wn0090?ooo`D07;D00P0Wn00I05Kc00P0oooo0`0Wn00504:j
00D0E_<02@1Hn00<08Oc00H0oooo0`13_P0305Sh00@0JKh04@27l`0508Wh00P0oooo1P1[`P0308Wh
01T0]o<02@3oool609C500h0^_L0303Wl`060?ooo`<0UlP00`2jm`050;k800`0io<02P3[m`240?oo
o`00F`3oool4000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000`3oool70035o`h0oooo
00<000000?ooo`3oool01P3oool00`00`?T006mb001_LP02001_LP<0079O00<0IVIV003hc`00LTP0
0P00LTP01@00n9d0078b001b<P00LS800?Q/00<0078K1P00n3/00`1VIVH00?Pk003h>`0?003h>`04
001mJ000n<l00?S?06IVIP8007e?0P00n9d3001m=P800?Q/00<007dM003c>@00lcT01`00lcT00`00
00000?<i003c>@0<003c>@030026L000n<l008IE00<008IE0P00n9d00`00QSX00?=Z003cJP0F003c
JPH0oooo1000Se/2003hW@8008ln2P00lfX>003hK0H0oooo0P00Uf02003hW@@009M23@00n6`=003c
>PL0oooo1000WTD00`00n6`009hU002N9@02002N9A400?<j1P00n3/90?ooo`D00:DW0P00n3/2002U
1QL00?<9203oool00`00ZbP00?Pk003h>`05002[1Pl00?P92P0Vl`070?ooo`<00;070`00n0T301^`
01809_<01@0Wn0090?ooo`D07;D0200Wn00B05Kc00P0oooo00@07KX002Oh000Wn0009oP01012^P0:
05Kc00X0F?P01P27l`070?ooo`<0@kh00`1Hn00306Vn01L0Qo<0203oool606_200P0ROP04`2gl`07
0?ooo`0306g50029n000ROP000H0U<D01P2gl`0=0;[g00H0io<01P3oool409O800<0^_L0102nb00B
0>Oc00D0joL0Q03oool005/0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000001@3oool0
0`000000oooo0?ooo`030?ooo`<0000000<0oooo0000003oool00`0000030?ooo`8000000P3oool2
000000060?ooo`00000000000000003oool000001@3oool50035o``0oooo100000080?ooo`030030
n@00Kg8006mb008006mb0`00LUl00`1VIVH00798001bB002001bB005003hW@00LS80078b001b<P00
n6`00`00LQ/6003h>`0306IVIP00n3/00?Pk00l00?Pk00<007eX003hc`1VIVH00`00ODl00`00n9d0
07df001m=P02001m=P800?Q/2P00lcT00`0000000?<i003c>@0;003c>@8008I`00<00?S?0026E@00
QUD00P00QUD2003hW@030026>P00lfX00?=Z01H00?=Z103oool2003hc`@008mK0P00n9d2002??Pl0
0?=Z2@00n6`60?ooo`8009MP0P00n9d4002G@Q<00?Q/1P00lcX70?ooo`D009i500@00?Q/002N9@00
WRD009hU5`00lcX:0?ooo`D00:DW0P00n3/00`00Y@H00?<9003c2@0F003c2@L0oooo0P00ZbP2003h
>`D00:/64`00n0T502Kc00L0oooo1000/0L3003h2@<06k005`0Vl`090?ooo`D07;D03@0Wn00=05Kc
00L0oooo0P0M^P0302Oh00@0@[X03P1Fl`0805Sh00X0oooo1013_P0305Sh0080JKh06027l`080?oo
o`H0Jl803029n00?0;Oc00H0oooo0P1]a@0208Wh00D0U<D0302gl`0:0;[g00X0oooo102Gb0030;[g
00<0_/P0603Wl`240?ooo`00F`3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?oo
o`3oool08@3oool30035oa00oooo100000040?ooo`03001HLP00`?T006mb008006mb00D00?7h001b
G`00LUl0IVIV003hc`04001bB005003hW@00LS80078b001b<P00n6`00`00LQ/5003h>`0306IVIP00
n3/00?Pk01000?Pk00<007eX003hc`1VIVH00`00ODl00`00n9d007df001m=P02001m=P800?Q/2P00
lcT00`0000000?<i003c>@0;003c>@8008I`00<00?S?0026E@00QUD00P00QUD2003hWAP00?=Z103o
ool00`00SgL00?S?003hc`04002?F`800?RM00<008ln003cJP00lfX04P00lfX5003hK0D0oooo0`00
Uf02003hW@@009M25P00n6`:0?ooo`D009i500<00?Q/002N9@00WRD06000lcX80?ooo`800?Q/1@00
YBL2003h>aP00?<91`3oool3002[:0800?Pk1@00Z`H5003c2A000?P92@3oool5002`1`<00?P90P0K
/00H02Kc00T0oooo1@0L]@0C02Oh00H0E_<01`3oool301fj00<09oP00`12^P0C05Kc00@0F?P02@3o
ool504>n00<0F?P00P1Y_P0G08Oc00T0oooo1P1[`P0@08Wh00X0]o<01P3oool306g50080ROP0102D
a@0B0;Oc00D0^_L02@3oool509O800<0^_L00P2nb00I0>Oc08@0oooo001J0?ooo`H000002`3oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00H0oooo00<005Qb0030n@00Kg800P00Kg80
1@00lOP0079O001bG`1VIVH00?S?00@0079800D00?RM001b<P00LS80078b003hK003001b6`D00?Pk
00<0IVIV003h>`00n3/04000n3/00`00OFP0IVIV003hc`03001mC`03003hW@00OCH007df008007df
00<00?Q/003c>@00lcT02@00lcT00`0000000?<i003c>@0:003c>@<008I`00<00?S?0026E@00QUD0
0P00QUD2003hWAP00?=Z103oool00`00SgL00?S?003hc`04002?F`800?RM00<008ln003cJP00lfX0
5P00lfX60?ooo`<009MP0P00n9d4002G@QH00?Q/2P3oool5002NA@03003hK000WRD009hU01L00?<j
203oool00`00YDP00?Q/003hK005002U9`P00?Pk4@00l`T80?ooo`<00:/X0P00n3/4002[1PX00?<9
3000n0T90?ooo`D00;070`00n0T00`0K/0009_<002Kc000F02Kc00L0oooo00<00;D7003h2@00n0T0
1@0L]@0E02Oh00/0oooo0`0M^P0302Oh0080@[X0601Fl`080?ooo`H0@kh00`1Hn0000`1Y_P00Qo<0
08Oc000E08Oc00X0oooo1P1[`P0508Oc00l0ROP01@2gl`060?ooo`@0KLD00P29n00309C501P0]o<0
203oool609O800<0^_L000<0_/P00>Oc003Wl`005`3Wl`250?ooo`00GP3oool00`000000oooo0?oo
o`080?ooo`<000003@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00H0oooo00<0
05Qb0030n@00Kg800P00Kg801@00lOP0079O001bG`1VIVH00?S?00@007981000LS801000n6`0078K
001b6`00LQ/5003h>`0306IVIP00n3/00?Pk01000?Pk00<007eX06IVIP00n<l00`00ODl00`00n9d0
07df001m=P02001m=PL00?Q/1@00lcT00`0000000?<i003c>@0:003c>@<008I`00<00?S?0026E@00
QUD00P00QUD00`00n9d00?=Z003cJP0F003cJP@0oooo0P00SgL2003hc`@008mK0P00n9dI003cJPD0
oooo1000Uf02003hW@@009M25P00n6`:0?ooo`D009i500<00?Q/002N9@00lcX05`00lcX80?ooo`03
002UB000n6`00?Q/00D00:DW3@00n3/<003c2@L0oooo1000ZbP2003h>`@00:/63P00l`T8003h2@T0
oooo1@00/0L3003h2AT09_<01P3oool2002e1`800?P91@0L]@0E02Oh00X0oooo100M^P0302Oh0080
@[X0601Fl`080?ooo`H0@kh00`1Hn00G08Oc00P0oooo00<0AL8005Sh001Hn0001@1[`P0:08Oc00`0
ROP02P3oool406g50080ROP00`2Da@0H0;Oc00L0oooo1`2Gb0030;[g01T0io<0QP3oool005h0oooo
00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`8005Qb00T00<3i001_LP00Kg80
06mb003an000LUl0IVIV001bG`00n<l01000LTP4001b<P04003hK000LQ/0078K001b6`@00?Pk00<0
IVIV003h>`00n3/04@00n3/00`1VIVH00?S?003hc`03001mC`03003hW@00OCH007df008007df3000
n6`00`0000000?<i003c>@09003c>@@008I`00<00?S?0026E@00QUD00P00QUD7003hWA800?=Z103o
ool2002?M`800?S?1000Se/2003hWAP00?=Z1P3oool4002GH0800?RM1000Ud85003cJQ400?Q/203o
ool2003hW@D009i500<00?Q/003c>P00lcX05P00lcX80?ooo`800:E80P00n6`5002U9`D00?<j3@00
n3/6003c2@L0oooo1@00ZbP2003h>`<00:/64`00l`T4003h2@T0oooo1@00/0L8003h2A<09_<01P3o
ool3002e1`800?P91@0L]@0602Kc00l09oP02@3oool501fj00<09oP000<0@[X005Kc001Fl`005P1F
l`090?ooo`H0@kh0201Hn00B08Oc00L0oooo0P15`P0205Sh00@0Jl803`27l`0808Wh00T0oooo1@1]
a@0208Wh0080U<D0602gl`080?ooo`L0UlP01`2jm`0D0>Oc08L0oooo000U0?ooo`<000000`3oool5
000000<0oooo0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000T0oooo0`00
00020?ooo`8000000P3oool3000000<0oooo100000040?ooo`<0000000@0oooo000000000000oooo
0`0000030?ooo`H0000000<0oooo0000000000000`0000030?ooo`<000001@3oool3002Boa<0oooo
00<000000?ooo`3oool01P3oool2001HLP090030n@00Kg8006mb001_LP00lOP0079O06IVIP00LUl0
0?S?00@007981000LS801000n6`0078K001b6`00LQ/4003h>`0306IVIP00n3/00?Pk01400?Pk00<0
IVIV003hc`00n<l00`00ODl00`00n9d007df001m=P02001m=P`00?Q/00<00000003hK000n6`00`00
n6`6003c>@<008I`0P00n<l40026E@`00?RM3000lfX40?ooo`<008mg0P00n<l4002?F`03003hW@00
lfX00?=Z01L00?=Z1P3oool4002GH0800?RM0`00Ud8:003cJPd00?Q/1`3oool00`00WV@00?RM003h
W@05002NA@L00?Q/4P00lcX80?ooo`800:E80P00n6`4002U9`X00?<j3000n3/:0?ooo`D00:/X0P00
n3/2002[1QP00?<91`3oool2003h>`D00;073000n0T>02Kc00L0oooo0`00]@L2003h2@@07;D0300V
l`0:02Oh00P0oooo1P0M^P0302Oh01T0E_<02@3oool604>n00d0F?P03027l`070?ooo`<0AL800P1H
n00306_201@0Qo<01029n0080?ooo`H0KLD00P29n0000`2Da@00]o<00;Oc000F0;Oc00T0oooo1`2G
b00;0;[g00l0io<0R03oool002@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000002`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo1@00T_lA0?ooo`030000003oool0oooo00H0oooo0`00F7801P00`?T006mb001_
LP00Kg800?7h06IVIP80079O00D00?S?001bB000LTP00798003hW@04001b<P03003hK000LQ/0078K
00@00?Pk00<0IVIV003h>`00n3/04@00n3/0101VIVH007eX003hc`00n<l3001mC`03003hW@00OCH0
07df008007df2`00n6`3000000T00?Q/00@00?7h0026L000QW0008I`0P00n<l40026EA800?RM1P00
lfX30?ooo`@008mg0P00n<l4002?F`L00?RM4P00lfX70?ooo`@009MP0P00n9d3002G@Pl00?=Z2000
n6`70?ooo`03002NI000n9d00?RM00D009i53000n6`<003c>PP0oooo0`00YDP2003hK0@00:DW3P00
lcX8003h>`X0oooo1@00ZbP2003h>`800:/66000l`T60?ooo`03002`:@00n3/00?Pk00D00;074000
n0T:02Kc00H0oooo1000]@L2003h2@@07;D04@0Vl`0502Oh00T0oooo1@0M^P0802Oh01<0E_<0203o
ool202Oh00H0@kh01P1Fl`0<05Sh00H0Qo<01`3oool404G20080F?P00`1[`P0H08Oc00L0oooo1`1]
a@0208Wh01P0]o<02P3oool709O800l0^_L02P3Wl`290?ooo`00903oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`L009;o403o
ool00`000000oooo0?ooo`060?ooo`<005Qb00H00<3i001_LP00Kg8006mb003an01VIVH2001bG`05
003hc`00LTP00798001bB000n9d01000LS800`00n6`0078K001b6`04003b>@0306IVIP00n3/00?Pk
01400?Pk00<0IVIV001mJ000n<l01000ODl01000n9d007df001m=P00OCH<003hK00300000000n6`0
0?Q/008000001`00n6`01000lOP008I`0026L000QW02003hc`@008IE5P00n9d50?ooo`@008mg0P00
n<l4002?F``00?RM3@00lfX50?ooo`800?S?1000Uf02003hW@8009M25000lfX4003hK0H0oooo0P00
WV@2003hW@D009i54P00n6`6003c>PL0oooo1000YDP2003hK0<00:DW4`00lcX4003h>`X0oooo1@00
ZbP2003h>`03002[1P00l`T00?<901H00?<91`3oool00`00/2T00?Pk003h>`05002`1a@00?P91@0V
l`060?ooo`D00;D70P00n0T301be01L09_<02@3oool501fj00`09oP03P1Fl`080?ooo`0301jn000W
n0009oP000D0@kh0301Fl`0:05Sh00T0oooo1@15`P0205Sh0080Jl806@27l`070?ooo`L0KLD02029
n00B0;Oc00L0oooo00<0KlP008Wh0029n0001`2Gb0040;Oc00l0^_L01@3Wl`2:0?ooo`00903oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo1@0000020?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`040000003oool0oooo000000<0oooo
1@0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`L009;o403oool00`000000oooo0?ooo`06
0?ooo`<005Qb00D00<3i001_LP00Kg8006mb06IVIP03001bG`05003hc`00LTP00798001bB000n9d0
1000LS800`00n6`0078K001b6`03003b>@0306IVIP00lST00?8i00@00?8i3@00n3/0101VIVH00?Pk
001mJ000n<l3001mC`800?RM0`00OCH6003cJ@D00?Q/00<0IVIV00000000n6`02P00n6`01000lOP0
08I`0026L000QW02003hc`@008IE5P00n9d50?ooo`@008mg0P00n<l4002?Fa800?RM1P00lfX50?oo
o`03002GOP00n<l00?S?00@009MP0P00n9d2002G@QP00?=Z1P3oool2002NI0800?RM1@00WTDE003h
K0X0oooo1000YDP2003hK0800:DW6000lcX80?ooo`800?Q/1@00ZbP2003h>aP00?<91`3oool2002`
:@800?Pk1@00/0L5003c2A400?P9203oool6002e1`800?P90P0L]@0H02Kc00T0oooo1@0M^P0@02Oh
00X0E_<01`3oool201jn00809oP01013_P0B05Kc00D0F?P0203oool604G20080F?P000<0Jl8008Oc
0027l`005`27l`080?ooo`L0KLD03@29n00<0;Oc00L0oooo0P1_b00208Wh00H0UlP02@2gl`0<0;[g
08h0oooo000T0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3o
ool00`000000oooo0?ooo`090?ooo`@000000`3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool7002Bo`l0oooo00<000000?ooo`3oool01`3o
ool3001HLP050030n@00Kg8006mb001_LP1VIVH00`00LUl01@00n<l00798001bB000LTP00?RM00<0
078b0P00n6`00`00LQ/00?8i003b>@02003b>@0306IVIP00lST00?8i00T00?8i2000n3/0101VIVH0
0?Pk001mJ000n<l3001mC`800?RM0P00OCH<003cJ@0306IVIP0000000?Q/00X00?Q/00@00?7h0026
L000QW0008I`0P00n<l30026EAL00?RM1@3oool4002?M`800?S?0`00Se/G003hW@L0oooo00<009Mn
003hc`00n<l01000Uf02003hW@03002G@P00lfX00?=Z01L00?=Z1@3oool3002NI0800?RM1@00WTDE
003hK0X0oooo1000YDP2003hK0800:DW6000lcX70?ooo`03002[BP00n6`00?Q/00D00:/X2000n3/B
003c2@H0oooo0`00/2T2003h>`@00;072P00l`T=003h2@P0oooo1P00]@L2003h2@807;D05`0Vl`07
0?ooo`03002j1`00n0T00?P900D07KX0500Wn00505Kc00L0oooo0`0N_P0202Oh00<0@kh0601Fl`07
0?ooo`L0AL800P1Hn00I08Oc00T0oooo1`1]a@0508Oc00d0ROP01P2gl`070?ooo`<0KlP00P29n005
09O800h0]o<0202jm`2>0?ooo`00903oool01@000000oooo0?ooo`3oool000000080oooo1@000003
0?ooo`<00000103oool3000000<0oooo00@000000?ooo`0000000000303oool01@000000oooo0?oo
o`3oool0000000<0oooo0`0000020?ooo`030000003oool00000008000000P3oool200000080oooo
0P0000020?ooo`@000001@3oool00`000000oooo0?ooo`020?ooo`<000001@3oool3000000@0oooo
1@00T_l<0?ooo`8000000P3oool00`000000oooo0?ooo`050?ooo`8008oi0`00F7801@00`?T006mb
001_LP00Kg80IVIV00<0079O00D00?S?001bB000LTP00798003hW@03001b<P800?Q/00D0078K003b
>@00lST00?8i06IVIP0A003b>@<00?Pk00@0IVIV003h>`00OFP00?S?0`00ODl2003hW@8007df2`00
lfT00`1VIVH00?=Y00000005003cJ@H00?Q/00@00?7h0026L000QW0008I`0P00n<l30026E@D00?>J
4P00n9d50?ooo`@008mg0P00n<l3002?F`H00?>J4@00n9d60?ooo`8009Mn0P00n<l4002GH0800?RM
00<009M2003cJP00lfX05P00lfX60?ooo`<009iT0P00n9d4002NAAH00?Q/2P3oool4002UB0800?Q/
00<00:DW003c>P00lcX05P00lcX80?ooo`03002[BP00n6`00?Q/00D00:/X3@00n3/<003c2@L0oooo
0`00/2T2003h>`@00;073`00l`T8003h2@P0oooo1P00]@L2003h2@0301be000Vl`009_<001H09_<0
1P3oool2002j1`800?P91@0M^P0E02Oh00X0oooo100N_P0202Oh0080@kh06@1Fl`080?ooo`H0AL80
1`1Hn00C08Oc00L0oooo00<0A/D005Sh001Hn0001P1]a@0;08Oc00X0ROP02P3oool406o80080ROP0
102Gb00C0;Oc00@0^_L0SP3oool002@0oooo00D000000?ooo`3oool0oooo0000000G0?ooo`030000
003oool0oooo00d0oooo00D000000?ooo`3oool0oooo0000000G0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool04P3oool3002Bo`l0oooo100000060?ooo`8008oi0`00F7801@00`?T0
06mb001_LP1VIVH00?7h00<0079O00D00?S?001bB000LTP00798003hW@03001b<P800?Q/00D0078K
003b>@00lST00?8i06IVIP0C003b>@0506IVIP00lST007eX001mJ000n<l00`00ODl2003hW@03001m
=P00lfT00?=Y00X00?=Y00<0IVIV003cJ@0000002P00lfT2003an0<008I`0P00n<l20026E@X00?>J
3P00n9d40?ooo`03003an000SgL008mg008008mg0P00n<l2002?F``00?>J3000n9d60?ooo`8009Mn
0P00n<l4002GH0800?RM6@00lfX50?ooo`@009iT0P00n9d4002NA@H00?=Z4000n6`:0?ooo`@00:E8
0P00n6`I003c>PL0oooo0P00ZdX2003hK0D00:/X4P00n3/6003c2@L0oooo1000/2T2003h>`<00;07
5000l`T4003h2@P0oooo1P00]@L2003h2AP09_<01`3oool2002j1`800?P91@0M^P0E02Oh00T0oooo
1@0N_P0202Oh000304>n001Fl`00E_<001L0E_<02@3oool604G200/0F?P03`27l`060?ooo`80A/D0
0P1Hn00506g50140Qo<01@29n0090?ooo`D0KlP00P29n00309O801P0]o<0SP3oool002D0oooo0`00
000H0?ooo`030000003oool0oooo00`0oooo1@00000H0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`02000000<0oooo00<0049b002?n@00SoT00`00
F7801@00`?T006mb001_LP1VIVH00?7h00<0079O00D00?S?001bB000LTP00798003hW@03001b<P80
0?Q/1000lST00`1VIVH00?8i003b>@0A003b>@0506IVIP00lST007eX001mJ000n<l00`00ODl2003h
W@03001m=P00lfT00?=Y00T00?=Y00@0IVIV003cJ@00lfT000002P00lfT2003an0<008I`0P00n<l2
0026E@l00?>J2@00n9d30?ooo`03002;S`00lOP008mg00<008mg0P00n<l2002?Fa800?>J1P00n9d5
0?ooo`<009Mn0P00n<l4002GH0L00?RM4`00lfX60?ooo`@009iT0P00n9d3002NA@`00?=Z2`00n6`8
0?ooo`800?RM1000YDP7003hK1<00?<j1`3oool3002[BP800?Q/1@00ZbPE003h>`T0oooo1@00/2T2
003h>`800;076@00l`T80?ooo`H00;D72000n0TA02Kc00L0oooo0`00^PL2003h2@D07KX01P0Vl`0?
02Oh00P0oooo1P0N_P0202Oh01T0E_<02P3oool604G200l0F?P02P27l`060?ooo`<0A/D00P1Hn004
06g501L0Qo<0203oool606o80080ROP00P2Gb00I0;Oc08h0oooo000o0?ooo`800000:P3oool20000
00H0oooo0`0000060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool00`00
@W8008oi002?n@02001HLP050030n@00Kg8006mb06IVIP00Kg800`00LUl2003hc`<0079800@00?RM
001b<P00LS80078b0P00n6`3003b>@0306IVIP00lST00?8i01400?8i00@0IVIV003b>@00OFP007eX
0P00n<l3001mC`800?RM3000lfT0101VIVH00?=Y003cJ@000009003cJ@030022QP00lOP00?7h00<0
08I`0P00n<l00`00QUD00?>J003cVP0B003cVPD00?RM0`3oool00`00Rhl00?7h002?M`03002?M`80
0?S?00<008mK003cVP00liX05P00liX60?ooo`<009Mn0P00n<l4002GH0H00?>J1@00n9d>003cJPL0
oooo1000WV@2003hW@<009i54P00lfX5003hK0L0oooo00<00:EX003hW@00n9d01000YDP;003hK0l0
0?<j1`3oool3002[BP800?Q/1@00ZbP5003c>Q000?Pk2@3oool5002`:@800?Pk0P00/0LI003c2@H0
oooo0P00n3/6002e1`d00?P9300Vl`060?ooo`@00;X70P00n0T401fj00`09_<02P0Wn0080?ooo`H0
7[h01`0Wn00C05Kc00P0oooo0`0Wn00604G200@0E_<03`1Hn00508Oc00H0oooo1016a@0205Sh00<0
KLD06027l`070?ooo`L0KlP00P29n0000`2Gb000]o<00;Oc000G0;Oc08l0oooo002L0?ooo`030000
003oool0oooo00D0oooo0P00@W82002?n@8005Qb00D00<3i001_LP00Kg80IVIV003an003001bG`03
003hc`00LTP007980080079800D00?RM001b<P00LS80078b003hK004003b>@0306IVIP00lST00?8i
01400?8i00@0IVIV003b>@00OFP007eX0P00n<l3001mC`800?RM2`00lfT01@1VIVH00?=Y003cJ@00
lfT0000000T00?=Y00<008:6003an000lOP00`00QW02003hc`030026E@00liX00?>J01H00?>J0`3o
ool2002;S`03003an000SgL008mg008008mg0P00n<l00`00Se/00?>J003cVP0F003cVPD0oooo1000
Ugh2003hc`<009MP3000liX4003hW@X00?=Z1`3oool4002NI0800?RM0P00WTDH003cJPH0oooo0P00
YFP2003hW@@00:E84000n6`9003c>PL0oooo1000ZdX2003hK0@00:/X2P00lcX<003h>`T0oooo1@00
/2T2003h>`03002`1`00l`T00?<901L00?<91P3oool00`00]B/00?Pk003h>`06002e1a800?P91P0V
l`070?ooo`@00;X70P00n0T301fj01809_<01@0Wn0080?ooo`H07[h02`0Wn00?05Kc00L0oooo00@0
7/8002Oh000Wn0009oP01@15`P0905Kc00`0F?P02P3oool404K50080F?P00P1]a@0H08Oc00T0oooo
1P1_b00208Wh01T0]o<0T03oool009`0oooo00<000000?ooo`3oool01@3oool20012LP8008oi0P00
F7801@00`?T006mb06IVIP00Kg800?7h00<0079O00<00?S?001bB000LTP00P00LTP01000n9d0078b
001b<P00LS84003hK00306IVIP00n6`00?8i01400?8i00<0IVIV003b>@00OFP00P00OFP2003hc`<0
07e?00<00?RM003cJ@00lfT02P00lfT01@1VIVH00?=Y003cJ@00lfT0000000P00?=Y0P00PXH2003a
n0<008I`0P00n<lI003cVP<0oooo0P00Rhl00`00lOP008mg002?M`02002?M`800?S?6000liX60?oo
o`@009Mn0P00n<l3002GH1800?>J0P00n9d5003cJPH0oooo0P00n<l4002NI0800?RM0P00WTDH003c
JPH0oooo0P00YFP2003hW@@00:E85000n6`5003c>PH0oooo1@00ZdX2003hK0@00:/X3P00lcX8003h
>`T0oooo1@00/2T2003h>aT00?<91P3oool2002e:`800?Pk1P00]@LE003h2@T0oooo1@00^PL2003h
2@<07KX05`0Vl`080?ooo`H07[h03`0Wn00:05Kc00L0oooo0P0N`P0302Oh00@0AL803P1Fl`0805Sh
00T0oooo1@16a@0205Sh000306g50027l`00Qo<001H0Qo<02P3oool606o800P0ROP04P2gl`2A0?oo
o`00D@3oool3000000040?ooo`000000000000000080oooo0`000000103oool000000?ooo`3oool3
000000D0oooo0`0000020?ooo`@000000`3oool5000000<0oooo0`0000000`3oool000000?ooo`02
0?ooo`<0063o4`3oool00`000000oooo0?ooo`050?ooo`<0049b0P00SoT2001HLP050030n@00Kg80
IVIV001_LP00lOP00`00LUl00`00n<l00798001bB002001bB004003hW@00LS80078b001b<P@00?Q/
00<0IVIV003hK000n6`01000n6`=003b>@0306IVIP00lST007eX008007eX0P00n<l3001mC`L00?RM
1@00lfT00`1VIVH00?=Y003cJ@02003cJ@0300000000lfT00?=Y00H00?=Y0P00PXH2003an0<008I`
0P00n<lH003cVP<0oooo0`00Rhl00`00lOP008mg002?M`02002?M`800?S?6000liX60?ooo`@009Mn
0P00n<l2002GH1P00?>J1`3oool00`00WX@00?S?003hc`04002NI0800?RM00<009i5003cJP00lfX0
5P00lfX60?ooo`<00:EX0P00n9d4002UB0H00?=Z4000n6`90?ooo`D00:]:0P00n6`3002[:1<00?<j
1000n3/70?ooo`800?Q/1@00/2T7003h>a<00?<91`3oool2002e:`800?Pk1P00]@L6003c2@l00?P9
203oool6002j1`800?P90P0M^P0H02Kc00P0oooo1P0N_P0C02Oh00D0E_<01`3oool301k200<09oP0
0`15`P0C05Kc00@0F?P0203oool604K50080F?P06027l`0;0?ooo`H0KlP03@29n00<0;Oc0980oooo
001B0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
00030?ooo`D0063o4P3oool00`000000oooo0?ooo`050?ooo`<0049b0P00SoT2001HLP050030n@1V
IVH006mb001_LP00lOP00`00LUl00`00n<l00798001bB002001bB0@0078b0`00n6`00`1VIVH00?Q/
003hK009003hK0P00?8i00<0IVIV003b>@00lOP00`00OFP2003hc`<007e?3000n9d00`1VIVH00?=Y
003cJ@02003cJ@0300000000lfT00?=Y00D00?=Y0`00PXH2003an0<008I`00<00?S?003cVP00liX0
5`00liX20?ooo`@008^?00<00?7h002?M`00SgL00P00SgL00`00n<l00?>J003cVP0F003cVPL0oooo
1000Ugh2003hc`8009MP6000liX70?ooo`03002NQ000n<l00?S?00@009iT0P00n9dI003cJPD0oooo
1000YFP2003hW@<00:E83000lfX;003hK0T0oooo1@00ZdX2003hK0800:/X6000lcX60?ooo`03002`
C@00n6`00?Q/00D00;0Y2`00n3/?003c2@H0oooo0`00]B/2003h>`D00;D73000l`T:003h2@P0oooo
1P00^PL2003h2@0301fj000Vl`009_<001H09_<01`3oool2003h2@H07[h05@0Wn00:0?ooo`<07/80
0`0Wn00304G201L0E_<01`3oool704K500P0F?P04P27l`0;0?ooo`H0KlP04P29n0060;Oc09<0oooo
001B0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000H0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo1`00H?l@0?ooo`030000003oool0
oooo00H0oooo0`00@W82002?n@8005Qb00D00<3i06IVIP00Kg8006mb003an003001bG`03003hc`00
LTP00798008007981000LS83003hK00306IVIP00n6`00?Q/00h00?Q/0`00lST00`1VIVH00?8i003a
n003001mJ0800?S?0`00ODl;003hW@0306IVIP00n9d00?RM00<00?RM00<00000003hW@00lfT01@00
lfT30022QP800?7h0P00QW08003hca800?>J0`3oool4002;S`03003an000SgL008mg008008mg1`00
n<lB003cVPD0oooo0P00lOP4002GOP800?S?00<009MP003cVP00liX05P00liX70?ooo`8009j40P00
n<l4002NI0L00?RM4`00lfX50?ooo`D00:EX0P00n9d3002UB1800?=Z1@00n6`90?ooo`D00:]:0P00
n6`2002[:1P00?<j1@3oool2002`C@800?Q/1@00/2T?003h>`X00?<91P3oool4002e:`800?Pk1000
]@LB003c2@D00?P9203oool6002j1`800?P96@0Vl`060?ooo`03002n1`00n0T00?P900H07[h01@0V
l`0@02Oh00T0oooo100N`P0302Oh0080AL80601Fl`080?ooo`H0A/D03@1Hn00<08Oc00P0oooo00@0
AlP005Sh001Hn000F?P01P1_b00D08Wh09L0oooo001B0?ooo`D000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo0`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`030?ooo`@000000P3oool7001Poa00oooo00<000000?ooo`3oool0
1P3oool30012LP06002?n@00F78005Qb001HLP00`?T0IVIV0P00Kg801@00lOP0079O001bG`00LUl0
0?S?00@007981000LS82003hK00306IVIP00n6`00?Q/01400?Q/00@0IVIV001iO@00NGd00?7h0`00
OFP2003hc`<007e?2`00n9d00`1VIVH00?RM003hW@03003hW@0300000000n9d00?RM00<00?RM0P00
`?T30022QP800?7h0P00QW06003cbPL00?S?3@00liX30?ooo`@008^?00<00?7h002?M`00SgL00P00
SgL<003hc``00?>J1@3oool00`00TiL00?7h003an004002GOP800?S?6@00liX70?ooo`8009j40P00
n<l4002NI0/00?RM3P00lfX60?ooo`D00:EX0P00n9d2002UB1P00?=Z1`3oool2003hW@D00:]:0P00
n6`00`00ZbP00?<j003c>P0F003c>PH0oooo0P00/4d2003hK0D00;0Y4`00n3/5003c2@H0oooo1@00
]B/2003h>`<00;D76000l`T80?ooo`H00;X71`00n0TC02Kc00H0oooo0P00_PL2003h2@D07[h02P0V
l`0<02Oh00P0oooo1@0N`P0302Oh000304G2001Fl`00E_<001H0E_<02@3oool604K50180F?P01P27
l`080?ooo`80AlP00`1Hn00606o800D0Qo<03`29n02G0?ooo`00D`3oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01`00H?l?0?ooo`030000003oool0oooo00L0oooo0`00@W801@00SoT005Qb
001HLP00F780IVIV00<006mb00D00?7h001bG`00LUl0079O003hc`03001bB003003hW@00LS80078b
0080078b0P00n6`00`1VIVH00?Q/003hK00A003hK00406IVIP00NGd007Um003an0<007eX00<00?S?
001mC`00ODl00P00ODl:003hW@0306IVIP00n9d00?RM00@00?RM00<00000003hW@00n9d00`00n9d2
0030n@<008:60P00lOP20026L0`00??:1`00n<l6003cVP@0oooo1000Rhl01000lOP008mg002?M`00
SgLC003hc`H00?>J1@3oool00`00TiL00?7h003an004002GOPL00?S?4`00liX70?ooo`<009j40P00
n<l4002NI0D00?>J2P00n9d:003cJPH0oooo1@00YFP2003hW@800:E86000lfX60?ooo`03002[K000
n9d00?RM00D00:]:0P00n6`H003c>PH0oooo0`00/4d2003hK0D00;0Y1P00lcX?003h>`T0oooo1@00
]B/2003h>`<00;D76000l`T50?ooo`03002j;000n3/00?Pk00H00;X72`00n0T>02Kc00H0oooo0`00
_PL2003h2@@07[h03`0Vl`0802Oh00L0oooo1P0N`P0302Oh01P0E_<02P3oool604K500D0E_<03`1H
n00;0?ooo`<0AlP00`1Hn00506o800/0Qo<02P29n02G0?ooo`00D`3oool00`000000oooo00000002
0?ooo`8000000P3oool2000000<0oooo0`0000030?ooo`D000000P3oool00`000000oooo00000002
00000080oooo0`0000040?ooo`@00000103oool5001Po``0oooo0P0000020?ooo`030000003oool0
oooo00H0oooo00D005gi0012LP00@W80049b002?n@03001HLP0506IVIP00Kg8006mb001_LP00lOP0
0`00LUl01@00n<l00798001bB000LTP00?RM00@0078b00<00?Q/06IVIP00n6`04P00n6`00`1VIVH0
0?Q/001iO@02003an0<007eX00<00?S?001mC`00ODl00P00ODl:003hW@0306IVIP00n9d00?RM00@0
0?RM00<00000003hW@00n9d00`00n9d20030n@<008:60P00lOP00`00QW000??:003cbP0A003cbPH0
0?S?0`3oool20030n@@008^?00@00?7h002?M`00SgL008mg1P00llXA003hc`H0oooo0P00TiL2003a
n0@009Mn2`00n<l>003cVPL0oooo1000WX@2003hc`<009iT2P00liX:003hW@D00?=Z1`3oool5002U
J0800?RM00<00:E8003cJP00lfX05P00lfX70?ooo`03002[K000n9d00?RM00D00:]:2000n6`B003c
>PD0oooo1000/4d2003hK0@00;0Y3000lcX:003h>`T0oooo1@00]B/2003h>`800;D76000l`T50?oo
o`800;X/0P00n3/6002j1`l00?P92P0Vl`050?ooo`@00;h70P00n0T301jn01@09_<0100Wn0080?oo
o`D07/80200Wn00B05Kc00P0oooo00<07lD002Oh000Wn0001@16a@0;05Kc00X0F?P02P3oool404O8
00<0F?P0101_b00A08Oc00D0ROP0U`3oool005@0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0J0?ooo`<0063o3`3oool4000000H0oooo00<002]b001Mn@00@W800P00@W801@00SoT0
05Qb001HLP1VIVH00<3i00<006mb00D00?7h001bG`00LUl0079O003hc`03001bB003003hW@00LS80
078b0080078b00<00?Q/06IVIP00n6`04P00n6`00`1VIVH00?Q/001iO@02003an0<007eX00<00?S?
001mC`00ODl00P00ODl9003hW@0306IVIP00n9d00?RM00D00?RM00<00000003hW@00n9d00`00n9d2
0030n@<008:60P00lOP00`00QW000??:003cbP0F003cbP<0oooo00<006j?0030n@00`?T01000Rhl0
0`00lOP008mg002?M`0<003cbP`00?S?1P3oool2002CU`800?7h1000Ugh?003hc`X00?>J1`3oool4
002NQ0800?S?0`00WV@>003cVPT00?RM1`3oool2003hc`D00:EX0P00n9dI003cJPH0oooo0P00Zf`2
003hW@D00:]:1@00lfX8003hK0`00?<j1@3oool5002`C@800?Q/0`00/2TB003c>PD00?Pk2@3oool5
002e:`800?Pk00<00;D7003c2@00l`T05P00l`T50?ooo`<00;X/0P00n3/6002j1a<00?P91@0Vl`05
0?ooo`D00;h70P00n0T301jn01P09_<0203oool501k200d09oP0301Fl`080?ooo`807lD00P0Wn004
04K50140E_<01@1Hn0090?ooo`D0AlP00`1Hn00306o801L0Qo<0U`3oool00580oooo0`00000C0?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool00P0000040?ooo`03000[LP00GOT0049b
0080049b00D008oi001HLP00F780IVIV0030n@03001_LP05003an000LUl0079O001bG`00n<l00`00
LTP01000n9d0078b001b<P00LS82003hK00306IVIP00n6`00?Q/01400?Q/00<0IVIV003hK000NGd0
0P00lOP3001mJ003003hc`00ODl007e?008007e?2@00n9d00`1VIVH00?RM003hW@05003hW@030000
0000n9d00?RM00<00?RM0P00`?T30022QP800?7h00<008I`003cbP00llX05P00llX30?ooo`03001^
S`00`?T00<3i00@008^?00<00?7h002?M`00SgL04P00llX6003hc`D0oooo0`00TiL2003an0@009Mn
4`00n<l5003cVPP0oooo1000WX@2003hc`8009iT4`00liX5003hW@H0oooo00<00:F9003hc`00n<l0
1@00YFP7003hWA<00?=Z1P3oool3002[K0800?RM1000ZdX:003cJPT00?Q/1P00lcX60?ooo`D00;1=
0P00n6`3002`:AL00?<j1`3oool2003hK0D00;D[0P00n3/H003c2@H0oooo0`00^R`2003h>`H00;X7
1000l`T@003h2@P0oooo1P00_PL2003h2@807[h06@0Vl`080?ooo`D07/804P0Wn00605Kc00P0oooo
0`0Oa@0202Oh00<0A/D05`1Fl`080?ooo`H0AlP00`1Hn00306o801L0Qo<0U`3oool00680oooo0`00
000B0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool01@3oool2000[LP09001Mn@00
@W80049b0012LP00SoT005Qb06IVIP00F7800<3i00<006mb00D00?7h001bG`00LUl0079O003hc`03
001bB006003hW@00LS80078b001b<P00lVT0IVIV1000lVT?003hK00406IVIP00n6`00?Q/001iO@80
0?7h0`00OFP00`00n<l007e?001mC`02001mC`P00?RM00<0IVIV003hW@00n9d01P00n9d00`000000
0?RM003hW@03003hW@800<3i0`00PXH2003an1P00??:0`3oool2001^S`800<3i1000Rhl00`00lOP0
08mg003cbP0G003cbPH0oooo0`00TiL2003an0@009Mn1@00llXA003hc`X0oooo1000WX@2003hc`80
09iT5`00liX70?ooo`03002UR@00n<l00?S?00D00:EX2`00n9d>003cJPL0oooo0`00Zf`2003hW@@0
0:]:3P00lfX8003hK0T0oooo1@00/4d2003hK0800;0Y6000lcX60?ooo`03002eC`00n6`00?Q/00D0
0;D[2000n3/B003c2@D0oooo1000^R`2003h>`D00;X72@00l`T<003h2@T0oooo1@00_PL2003h2@03
01jn000Vl`009_<001L09_<01P3oool3003h2@D07/805@0Wn00:0?ooo`@07lD00P0Wn00304K501L0
E_<01`3oool704O800<0F?P00P1_b00G08Oc09P0oooo001S0?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool01P3oool2000[LP03001Mn@00@W80049b008008oi00@005Qb06IVIP00F780
0<3i0`00Kg801@00lOP0079O001bG`00LUl00?S?00<0079800<00?RM001b<P00LS800P00lVT00`1V
IVH00?9Y003bJ@08003bJ@T00?Q/00@0IVIV003hK000n6`007Um0P00lOP3001mJ004003hc`00ODl0
07e?001mC`T00?RM00<0IVIV003hW@00n9d01@00n9d00`0000000?RM003hW@04003hW@030030n@00
PXH008:6008008:60P00lOPH003cbP<0oooo0P00KXl20030n@@008^?00<00?7h002?M`00llX05`00
llX50?ooo`@009>G0P00lOP3002GOPX00??:3@00n<l:0?ooo`@009j40P00n<l00`00WV@00?>J003c
VP0F003cVPH0oooo0P00YHT2003hc`D00:EX3`00n9d:003cJPH0oooo1000Zf`2003hW@<00:]:4`00
lfX4003hK0T0oooo1@00/4d2003hK003002`:@00lcX00?<j01H00?<j1`3oool00`00]Dl00?Q/003h
K005002e:`d00?Pk3000l`T50?ooo`D00;X/0P00n3/4002j1`h00?<92000n0T90?ooo`D00;h70P00
n0TI02Kc00H0oooo00@00<87003h2@00n0T00?P91@0N`P0602Kc00l09oP02@3oool501o500809oP0
0P16a@0G05Kc00T0oooo1P17b00305Sh000306o80027l`00Qo<001D0Qo<0V@3oool006<0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`050?ooo`<002]b00<005gi0012LP00@W800P00
SoT0101VIVH005Qb001HLP00`?T3001_LP03003an000LUl0079O00800?S?0`00LTP01@00n9d0078b
001b<P00lVT0IVIV01400?9Y0P00n6`01@1VIVH00?Q/003hK000n6`007Um00800?7h0`00OFP01000
n<l007e?001mC`00ODl5003bVP<00?RM00<0IVIV003hW@00n9d01P00n9d00`0000000?RM003hW@04
003hW@030030n@00PXH008:6008008:600<00?7h003cbP00llX05P00llX30?ooo`<006j?0P00`?T4
002;S`03003an000llX00??:01H00??:1P3oool4002CU`800?7h0`00Ugh>003cbPT00?S?203oool2
003an0@009j40P00n<l00`00WV@00?>J003cVP0E003cVPL0oooo0P00YHT2003hc`D00:EX1P00liX=
003hW@D00?=Z1P3oool5002[K0800?RM0P00ZdXH003cJPL0oooo0P00n9d5002`C@800?Q/6@00lcX6
0?ooo`800;E?0P00n6`5002e:`D00?<j3@00n3/6003c2@D0oooo1P00^R`2003h>`<00;X74`00l`T4
003h2@T0oooo1@00_PL8003h2A809_<01P3oool200321`<00?P9100N`P0<02Kc00X09oP0203oool6
01o500809oP000<0A/D005Kc001Fl`005@1Fl`0:0?ooo`H0AlP00`1Hn00G08Oc09X0oooo001L0?oo
o`@000000`3oool4000000@0oooo0`0000000`3oool000000?ooo`05000000040?ooo`0000000000
00000080oooo0P0000030?ooo`<002go4P3oool00`000000oooo0?ooo`050?ooo`@002]b00<005gi
0012LP00@W800P00SoT0101VIVH005Qb001HLP00`?T2001_LP800?7h0P00LUl2003hc`<0079800D0
0?RM001b<P00lVT00?9Y06IVIP0C003bJ@0306IVIP00lVT00?9Y008007Um0P00lOP3001mJ003003h
c`00ODl007e?00T00?:J00<0IVIV003bVP00n9d01P00n9d00`0000000?RM003hW@04003hW@030030
n@00PXH008:6008008:61`00lOPB003cbP<0oooo0`00KXl20030n@@008^?6@00llX60?ooo`@009>G
0P00lOP2002GOQ<00??:1@00n<l70?ooo`03002JWP00lOP00?7h00@009j40P00n<lH003cVPH0oooo
0`00YHT2003hc`@00:EX3000liX:003hW@T0oooo1@00Zf`2003hW@800:]:6000lfX60?ooo`03002`
L000n9d00?RM00D00;1=1`00n6`C003c>PH0oooo0`00]Dl2003hK0@00;D[2P00lcX<003h>`T0oooo
1@00^R`2003h>`<00;X75`00l`T60?ooo`<00?Pk1@00_PL=003h2@`09_<01P3oool300321`<00?P9
0`0N`P0B02Kc00D09oP01`3oool701o500809oP05`1Fl`0;0?ooo`H0AlP0201Hn00B08Oc09X0oooo
001L0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`D002go4@3oool00`000000oooo0?ooo`050?ooo`@002]b00<005gi
0012LP00@W800P00SoT0101VIVH005Qb0030n@00`?T2001_LP05003an000LUl0079O001bG`00n<l0
1000LTP01000n9d0078b003bJ@1VIVHC003bJ@0406IVIP00lVT00?9Y003bJ@8007Um0P00lOP2001m
J0800?S?0P00ODl8003bVP0306IVIP00lYX00?:J00@00?:J0`00n9d00`0000000?RM003hW@04003h
W@030030n@00PXH008:6008008:63000lOP<003cbP<0oooo1000KXl20030n@@008^?1@00lOPC003c
bPL0oooo1000TiL2003an08009Mn5`00llX80?ooo`03002JWP00lOP00?7h00@009j42000n<lA003c
VPL0oooo0`00YHT2003hc`<00:EX4P00liX5003hW@T0oooo1@00Zf`2003hW@03002[BP00lfX00?=Z
01H00?=Z1`3oool00`00/7000?RM003hW@05002`C@/00?Q/3P00lcX70?ooo`<00;E?0P00n6`4002e
:`h00?<j2000n3/90?ooo`D00;X/0P00n3/2002j1aP00?<91@3oool01000_Rd00?Pk003h>`00n3/5
002n1a800?P91P0Vl`070?ooo`<00<870`00n0T301k201L09_<0203oool601o500L09oP04P1Fl`07
0?ooo`0401o8000Wn0009oP002Oh00H0AlP01@1Fl`0805Sh00`0Qo<0V`3oool00600oooo00@00000
0?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo1`00;Ol@0?ooo`03
0000003oool0oooo00D0oooo1000:g801@00GOT0049b0012LP00SoT0IVIV008005Qb0P00`?T2001_
LP05003an000LUl0079O001bG`00n<l01000LTP01000n9d00?9Y003bJ@1VIVHC003bJ@0306IVIP00
lVT00?9Y00<007Um0P00lOP2001mJ0800?S?00<007e?003bVP00lYX01`00lYX00`1VIVH00?:J003b
VP07003bVP0300000000lYX00?RM00@00?RM00<00<3i0022QP00PXH00P00PXHB003an0H00??:0`3o
ool4001^S`800<3i1000Rhl9003an0l00??:1P3oool00`00`?T009>G002CU`02002CU`800?7h00<0
09Mn003cbP00llX05P00llX70?ooo`8009ZN0P00lOP4002NQ0d00?S?3000liX60?ooo`@00:F90P00
n<l3002UJ1L00?>J2@3oool5002[K0800?RM6000lfX70?ooo`800;1`0P00n9d5002`C@H00?=Z2@00
n6`:003c>PH0oooo1000]Dl2003hK0<00;D[4`00lcX4003h>`T0oooo1@00^R`2003h>`03002j1`00
l`T00?<901H00?<91@3oool2002n;@<00?Pk1@00_PLE003h2@T0oooo1000`PL3003h2@807/80600V
l`080?ooo`H07lD0300Wn00<05Kc00L0oooo0P0Ob00302Oh00D0AlP02`1Fl`0805Sh00H0Qo<0W03o
ool005h0oooo0`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool4000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo1`00;Ol?0?ooo`030000
003oool0oooo00H0oooo1000:g801@00GOT0049b0012LP00SoT0IVIV008005Qb00D00<3i001_LP00
Kg8006mb003an003001bG`03003hc`00LTP00798008007980P00lVT00`1VIVH00?9Y003bJ@0A003b
J@0406IVIP00lVT00?9Y003bJ@<007Um0P00lOP2001mJ0800?S?00<007e?003bVP00lYX01P00lYX0
0`1VIVH00?:J003bVP08003bVP0300000000lYX00?:J00<00?:J00<006R60030n@00PXH00`00PXHF
003an0D0oooo1000KXl20030n@@008^?3P00lOP9003cbPH0oooo00<007BG0030n@00TiL00`00TiL2
003an003002GOP00llX00??:01D00??:203oool2002JWP800?7h1000WX@B003hc`H00?>J1`3oool4
002UR@800?S?0P00YFPH003cVPL0oooo0P00n<l5002[K0P00?RM4P00lfX60?ooo`<00;1`0P00n9d4
002`C@`00?=Z2000n6`5003c>PH0oooo1@00]Dl2003hK0800;D[6000lcX90?ooo`D00;X/0P00n3/H
003c2@D0oooo0`00_Rd3003h>`D00;h71@00l`T@003h2@P0oooo1@00`PL3003h2@0301k2000Vl`00
9_<001H09_<02@3oool601o501409oP01P1Fl`070?ooo`<07lP00`0Wn00404O80140E_<01@1Hn02P
0?ooo`00G03oool3000000@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool01`00;Ol?
0?ooo`030000003oool0oooo00D0oooo00<002ci000[LP00:g800P00:g801000GOT0049b0012LP1V
IVH3001HLP050030n@00Kg8006mb001_LP00lOP00`00LUl00`00n<l00798001bB002001bB0800?RM
00<0IVIV003hW@00n9d04@00lVT0101VIVH00?9Y003bJ@00`?T3001iO@04003an000OFP007eX001m
J0800?S?2@00lYX00`1VIVH00?:J003bVP08003bVP0300000000lYX00?:J00<00?:J00<006R60030
n@00PXH00`00PXHF003an0D0oooo1000KXl20030n@@008^?4P00lOP5003cbPH0oooo00<007BG0030
n@00TiL00`00TiL2003an1P00??:1`3oool3002JWP800?7h1000WX@E003hc`X0oooo1000YHT2003h
c`03002UJ000liX00?>J01H00?>J1`3oool00`00Zhh00?S?003hc`05002[K0d00?RM3000lfX70?oo
o`<00;1`0P00n9d3002`CA800?=Z1@00n6`90?ooo`D00;E?0P00n6`2002e:aP00?<j1P3oool3003h
K0D00;X/2000n3/B003c2@D0oooo0`00_Rd3003h>`@00;h72P00l`T<003h2@L0oooo1P00`PL3003h
2AP09_<01P3oool01000a@L00?P9003h2@00n0T601o501@09oP02@3oool401o800<09oP00`17b00G
05Kc0:00oooo001L0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P0000030?oo
o`@000000`3oool3000000<0oooo00<000000?ooo`0000000P0000040?ooo`D002go303oool40000
00P0oooo00<002ci000[LP00:g800P00:g830012LP0506IVIP00F78005Qb001HLP00`?T00`00Kg80
1@00lOP0079O001bG`00LUl00?S?00@0079800<00?RM06IVIP00n9d01`00n9d;003bJ@0506IVIP00
lVT00?9Y003bJ@00`?T00`00NGd01000lOP007eX001mJ000OFP2003hc`T00?:J00<0IVIV003bVP00
lYX02000lYX00`0000000?:J003bVP02003bVP8006R600@00<3i0022QP00PXH008:65`00lOP40?oo
o`03002?n@00KXl006j?008006j?0P00`?T4002;SaD00?7h1`3oool2001dU`030030n@00TiL009>G
008009>G2000lOPA003cbPL0oooo1000VYh2003an0@009j45@00n<l:0?ooo`@00:F90P00n<lI003c
VPL0oooo00<00:^>003hc`00n<l01@00Zf`5003cVPd00?RM1P00lfX70?ooo`@00;1`0P00n9d3002`
CAL00?=Z2@3oool5002eC`800?Q/00<00;D[003c>P00lcX05P00lcX60?ooo`04002jD@00n6`00?Q/
003hK0D00;X/3@00n3/<003c2@D0oooo1000_Rd3003h>`@00;h73P00l`T8003h2@P0oooo1@00`PL7
003h2A<09_<01P3oool200351`<00?P91P0Oa@0D02Oh00T0oooo100Ob00302Oh0080AlP0601Fl`2P
0?ooo`00G03oool01@000000oooo0?ooo`3oool000000200oooo0`00;Ol@0?ooo`D000000`3oool0
0`00578002ci000[LP02000[LP05001Mn@00@W80049b06IVIP00SoT00`00F7801@00`?T006mb001_
LP00Kg800?7h00<0079O00<00?S?001bB000LTP00P00LTP00`00n9d0IVIV003hW@0;003hW@L00?9Y
00D0IVIV003bJ@00lVT0061m0030n@02001iO@800?7h0`00OFP00`00n<l00?:J003bVP07003bVP03
06IVIP00lYX00?:J00T00?:J00<00000003bVP00lYX00P00lYX2001XQP040030n@00PXH008:60022
QPD00>cc4P00lOP30?ooo`03001BS`00SoT006j?00<006j?0P00`?T4002;SaD00?7h1`3oool2001d
U`030030n@00TiL009>G008009>G3@00lOP<003cbPL0oooo1000VYh2003an0@009j45@00n<l80?oo
o`800?7h1000YHT7003hca<00?>J1`3oool2002[SP800?S?1000Zf`:003cVP`00?RM2@3oool5002`
L0800?RM0P00/4dH003cJPT0oooo1@00]Dl2003hK1P00?<j1P3oool2002jD@<00?Q/1@00^R`5003c
>Pd00?Pk1P00l`T50?ooo`D00;h]0`00n3/3002n1a<00?<91000n0T80?ooo`D00<872`00n0T?02Kc
00H0oooo0P00a@L3003h2@H07lD0500Wn0080?ooo`D07lP00`0Wn0000`17b000E_<005Kc000F05Kc
0:40oooo001M0?ooo`@00000<P3oool00`000000oooo0?ooo`060?ooo`03000DLP00;?T002]b0080
02]b00D005gi0012LP00@W80IVIV002?n@03001HLP050030n@00Kg8006mb001_LP00lOP00`00LUl0
1000n<l00798001bB000LTP2003hW@0306IVIP00n9d00?RM00l00?RM00<00?9Y06IVIP00lVT00P00
lVT01000H7d00<3i001iO@00NGd2003/l`<007eX1P00n<l4003bVP0306IVIP00lYX00?:J00T00?:J
0P000002003bVP<006R600<00<3i0022QP00PXH02P00k?<>003an0<0oooo00<005:?002?n@00KXl0
0`00KXl20030n@@008^?5@00lOP60?ooo`<007BG00<00<3i002CU`00TiL00P00TiLB003an0H00??:
203oool4002JWP800?7h1000WX@E003hc`L0oooo00<00:2U003an000lOP01000YHT;003hc`h00?>J
203oool2002[SP800?S?1000Zf`>003cVPP00?RM2@3oool5002`L0800?RM00<00;1=003cJP00lfX0
5P00lfX70?ooo`03002eL`00n9d00?RM00D00;E?2000n6`B003c>PH0oooo0P00^U43003hK0@00;X/
2`00lcX:003h>`P0oooo1P00_Rd3003h>`800;h76000l`T80?ooo`D00<873`00n0T:02Kc00H0oooo
0`00a@L3003h2@H07lD01@0Vl`0?02Oh00L0oooo1P0Ob00302Oh01P0E_<0XP3oool007<0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`03000DLP00;?T002]b008002]b00D0
05gi0012LP1VIVH0049b002?n@03001HLP050030n@00Kg8006mb001_LP00lOP00`00LUl01P00n<l0
0798001bB000LTP00?RM06IVIQ<00?RM00<0IVIV003hW@00n9d00P00H7d00`00`?T007Um001iO@02
003/l`<007eX2@00n<l00`1VIVH00?S?003bVP0:003bVP0400000000lYX00000000000<006R600<0
0<3i0022QP00PXH03`00k?<9003an080oooo0P00DXl00`00SoT006j?001^S`02001^S`800<3i0`00
RhlF003an0D0oooo1000M9L00`00`?T009>G002CU`02002CUaH00?7h2P3oool4002JWP800?7h1000
WX@E003hc`L0oooo00<00:2U003an000lOP01000YHT?003hc`X00?>J1`3oool3002[SP800?S?0`00
Zf`C003cVP@00?RM2@3oool5002`L0800?RM6@00lfX60?ooo`800;Ec0P00n9d5002eC`d00?Q/3000
lcX60?ooo`<00;YA0`00n6`3002j;1400?<j1@00n3/90?ooo`D00;h]0`00n3/2002n1aP00?<91@3o
ool3003h>`D00<874`00n0T502Kc00H0oooo1000a@L3003h2@D07lD02`0Vl`0:02Oh00H0oooo1`0O
b00702Oh01<0E_<0X`3oool009<0oooo00<000000?ooo`3oool01@3oool2000DLP09000/n@00:g80
02]b000[LP00GOT0049b06IVIP00@W8008oi00<005Qb00D00<3i001_LP00Kg8006mb003an003001b
G`06003hc`00LTP00798001bB000n9d0IVIV4P00n9d00`1VIVH00?RM003hW@03001PO@030030n@00
NGd00>cc00800>cc0`00OFP9003hc`0306IVIP00n<l00?S?00<00?S?1`00lYX00`0000000?:J003b
VP04001XQP030030n@00PXH00>cc01<00>cc1@00lOP20?ooo`8005:?00<008oi001^S`00KXl00P00
KXl20030n@<008^?1P00k?<@003an0D0oooo1000M9L00`00`?T009>G002CU`02002CUaH00?7h203o
ool20030n@@009ZN0P00lOP4002NQ0D00??:4000n<l60?ooo`800:2U0P00lOP4002URA<00?S?1@00
liX70?ooo`@00:^>0P00n<l2002[K1P00?>J2@3oool5002`L0L00?RM4`00lfX60?ooo`<00;Ec0P00
n9d5002eCa800?Q/1P00lcX60?ooo`@00;YA0`00n6`3002j;1H00?<j2@3oool5002n;@<00?Pk00<0
0;h7003c2@00l`T05P00l`T50?ooo`040032;P00n3/00?Pk003h>`D00<875@00n0T90?ooo`@00<D7
0`00n0T401o501409_<01@0Wn0070?ooo`H07lP02`0Wn00?05Kc0:<0oooo000O0?ooo`<000000P3o
ool300000080oooo0P0000000`3oool0000000000003000000@0oooo0`0000030?ooo`<00000103o
ool3000000030?ooo`000000oooo00P0oooo100000050?ooo`<000000`3oool3000000030?ooo`00
0000oooo0080oooo0`0000030?ooo`<00000103oool3000000D0oooo0`050?lC0?ooo`030000003o
ool0oooo00H0oooo0P0057802@00;?T002]b000[LP00:g8005gi0012LP1VIVH0049b002?n@03001H
LP050030n@00Kg8006mb001_LP00lOP00`00LUl01@00n<l00798001bB000LTP0IVIV01<00?RM00<0
IVIV003hW@00n9d00`00H7d00`00`?T007Um003/l`02003/l`<007eX2000n<l00`1VIVH00?S?003h
c`09003hc`800?:J00<00000003bVP00lYX01000J8H00`00`?T008:6003/l`0G003/l`80oooo0`00
DXl00`00SoT006j?001^S`02001^S`800<3i0P00Rhl<003/l`/00?7h1@3oool4001dU`030030n@00
TiL009>G008009>G1@00k?<A003an0L0oooo00<007ZN0030n@00`?T01000VYh2003an0<009j42P00
llX<003hc`H0oooo0P00X:D2003an0@00:F95@00n<l:0?ooo`@00:^>0P00n<l2002[K1P00?>J1`3o
ool2003hc`D00;1`2`00n9d>003cJPL0oooo0`00]G<2003hW@D00;E?5@00n6`80?ooo`D00;YA0`00
n6`2002j;1L00?<j2@3oool5002n;@<00?Pk6000l`T50?ooo`800<8^0`00n3/500321`D00?<94000
n0T80?ooo`D00<D70`00n0T301o501L09_<01`3oool601o800l09oP02P1Fl`2T0?ooo`007P3oool2
000000030?ooo`00000000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000000`3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
0?ooo`D01@3o4P3oool00`000000oooo0?ooo`050?ooo`<001Ab00H002ci000[LP00:g8002]b001M
n@1VIVH20012LP05002?n@00F78005Qb001HLP00`?T00`00Kg800`00lOP0079O001bG`02003hc`<0
079800<0IVIV003hW@00n9d04@00n9d00`1VIVH00?RM003hW@03001PO@030030n@00NGd00>cc0080
0>cc0`00OFP8003hc`0306IVIP00n<l00?S?00/00?S?00<00000001=QP00SoT01000J8H00`00`?T0
0>cc003/l`0G003/l`030?ooo`00DXl005:?008005:?00<008oi001^S`00KXl00P00KXl20030n@80
08^?4@00k?<6003an0D0oooo1000M9L01000`?T009>G002CU`00TiL:003/l`d00?7h1`3oool00`00
NYh00<3i0030n@04002JWP800?7h0`00WX@>003cbPP00?S?1@3oool3002PY@800?7h1000YHTE003h
c`X0oooo1000Zhh2003hc`03002[K000liX00?>J01H00?>J1`3oool00`00/9<00?S?003hc`05002`
L0l00?RM2P00lfX60?ooo`@00;Ec0P00n9d5002eC`H00?=Z3`00n6`80?ooo`D00;YA0`00n6`00`00
^R`00?<j003c>P0E003c>PL0oooo0`00n6`5002n;@P00?Pk4P00l`T50?ooo`<00<8^0`00n3/40032
1`X00?<93000n0T70?ooo`H00<D70`00n0T201o501P09_<01`3oool601o801<09oP01@1Fl`2U0?oo
o`007P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000003P3oool01@000000oooo0?ooo`3oool0000000D0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0700D0oa00oooo00<000000?ooo`3oool01P3oool3000DLP06
000/n@00:g8002]b000[LP00GOT0IVIV0P00@W801@00SoT005Qb001HLP00F7800<3i00<006mb00<0
0?7h001bG`00LUl00P00n<l2001bB00306IVIP00n9d00?RM01400?RM00@0IVIV003hW@00n9d00?RM
0P00H7d20030n@@00>cc0`00OFP7003hc`0306IVIP00n<l00?S?00`00?S?00<00000001=QP00SoT0
1000J8H00`00`?T00>cc003/l`0F003/l`80oooo1000DXl00`00SoT006j?001^S`02001^S`800<3i
00<008^?003/l`00k?<05@00k?<40?ooo`8008oi1000M9L01000`?T009>G002CU`00TiL>003/l`T0
0?7h1P3oool2001jWP800<3i1000VYh2003an08009j44`00llX4003hc`@0oooo1000X:D2003an0@0
0:F95@00n<l:0?ooo`@00:^>0P00n<lH003cVPL0oooo0P00/9<2003hc`D00;1`1@00liX>003hW@D0
0?=Z1P3oool5002eL`800?RM1000]Dl<003cJPX00?Q/203oool5002jD@<00?Q/6000lcX60?ooo`04
002nDP00n6`00?Q/003hK0D00;h]3@00n3/<003c2@D0oooo1000`Rh3003h>`@00<873P00l`T8003h
2@L0oooo1P00a@L3003h2@0301o5000Vl`009_<001H09_<01@3oool00`00b0L00?P9003h2@0601o8
01@09oP0Z@3oool001h0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo1@000002
0?ooo`050000003oool0oooo0?ooo`000000303oool3000000<0oooo00<000000?ooo`3oool0103o
ool4000000<0oooo00<000000?ooo`3oool00`3oool5000000<0oooo0`0000030?ooo`L01@3o403o
ool00`000000oooo0?ooo`060?ooo`<001Ab00D002ci000[LP00:g8002]b06IVIP020012LP8008oi
0`00F7800`00`?T006mb001_LP02003an080079O0P00n<l2001bB00306IVIP00n9d00?RM01400?RM
00@0IVIV003hW@00n9d00?RM0P00H7d20030n@@00>cc0`00OFP7003hc`0306IVIP00n<l00?S?00`0
0?S?00<00000001=QP00SoT01000J8HI003/l`80oooo1000DXl00`00SoT006j?001^S`02001^S`80
0<3i00<008^?003/l`00k?<05@00k?<30?ooo`03001GU`00SoT008oi00@007BG00<00<3i002CU`00
TiL04`00k?<5003an0H0oooo0P00NYh20030n@@009ZN0P00lOP00`00WX@00??:003cbP0F003cbP@0
oooo1000X:D2003an0@00:F95@00n<l80?ooo`800?7h1000Zhh8003hca800?>J1`3oool2002`T`80
0?S?1000/70:003cVP`00?RM203oool6002eL`800?RM0`00]DlB003cJPD00?Q/203oool5002jD@L0
0?Q/4`00lcX60?ooo`800;iB0`00n6`5002n;@H00?<j3000n3/6003c2@D0oooo1@00`Rh3003h>`<0
0<874`00l`T4003h2@L0oooo1P00a@L3003h2AP09_<01@3oool200381`800?P91P0Ob00502Kc00l0
9oP0Z@3oool001h0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`<000001@3oool0
0`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`L01@3o3`3oool00`000000
oooo0?ooo`070?ooo`<001Ab00D002ci000[LP00:g8002]b06IVIP020012LP8008oi0`00F7800`00
`?T006mb001_LP02003[lP80079O0P00n<l00`00LTP0IVIV001bB00B003hW@0306IVIP00n9d00?RM
00800?RM0P00H7d00`00`?T00>cc003/l`03003/l`<007eX1P00n<l00`1VIVH00?S?003hc`0=003h
c`0300000000CHH008oi00<006R61`00`?TB003/l`<0oooo1000DXl00`00SoT006j?001^S`02001^
S`800<3i5`00k?<40?ooo`03001GU`00SoT008oi00@007BG00<00<3i002CU`00TiL05`00k?<60?oo
o`<007ZN0P00`?T4002JWP800?7h00<009j4003cbP00llX05P00llX40?ooo`@00:2U0P00lOP4002U
RAD00?S?1`3oool00`00YZ/00?7h003an004002[SPd00?S?3000liX70?ooo`<00;2C0P00n<l4002`
L0h00?>J2000n9d90?ooo`D00;Ec0P00n9d3002eCaL00?=Z1P3oool2003hW@D00;YA2`00n6`>003c
>PL0oooo0P00_U83003hK0@00;h]3000lcX:003h>`L0oooo1P00`Rh3003h>`800<876000l`T70?oo
o`H00<D71`00n0TC02Kc00D0oooo0`00b0L2003h2@D07lP02`0Vl`0:02Oh0:T0oooo000N0?ooo`08
0000003oool0oooo0?ooo`000000oooo0000003oool3000000<0oooo0`0000040?ooo`D000000`3o
ool3000000@0oooo1000000:0?ooo`030000003oool0oooo00@0oooo1@0000020?ooo`@000000`3o
ool5000000<0oooo0`0000040?ooo`<00000103oool500D0o``0oooo0P0000020?ooo`030000003o
ool0oooo00D0oooo0P040?T3000DLP<002]b00@0IVIV001Mn@00@W80049b0P00SoT2001HLP800<3i
0P00Kg82003[lP80079O00D00?S?001bB000LTP0IVIV001bB00B003hW@0306IVIP00n9d00?RM0080
0?RM0P00H7d60030n@8007eX1`00n<l00`1VIVH00?S?003hc`0=003hc`0300000000CHH008oi00<0
06R61P00^o<60030n@d00>cc0`3oool4001BS`03002?n@00KXl006j?008006j?00<00<3i003/l`00
k?<05P00k?<30?ooo`8005NG0P00SoT4001dU`030030n@00TiL00>cc01L00>cc1@3oool4001jWP80
0<3i1000VYh2003an1P00??:1@3oool4002PY@800?7h1000YHT6003cbPl00?S?1P3oool2002VZ`80
0?7h1000ZhhB003hc`H00?>J1`3oool4002`T`800?S?0`00/70C003cVP@00?RM2@3oool5002eL`80
0?RM0P00]DlH003cJPD0oooo00<00;Yf003hW@00n9d01@00^U4?003hK0X00?<j1P3oool3002nDP<0
0?Q/0`00_RdB003c>PD00?Pk203oool50032;P<00?Pk0P00`PLH003c2@@0oooo00<00<D_003h>`00
n3/01P00a@L;003h2@l09_<0103oool400381`800?P9100Ob00A02Kc00D09oP0Z@3oool001h0oooo
00D000000?ooo`3oool0oooo0000000A0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0203oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0C0?ooo`<01@3o3`3oool4000000H0oooo0P040?T2000DLP06000/n@00:g8002]b
000[LP1VIVH005gi0P00@W801000SoT005Qb001HLP00F7820030n@03001_LP00jo800>_b00<0079O
00D00?S?001bB000LTP0IVIV001bB00A003hW@0306IVIP00n9d00?RM00<00?RM0P00H7d60030n@80
07eX1@00l/T00`00n<l0IVIV003hc`0?003hc`0300000000CHH008oi008006R63000^o<70030n@H0
0>cc0P3oool2001Mn@@005:?00@008oi001^S`00KXl006j?1`00`?TB003/l`@0oooo0P00EiL2002?
n@@007BG00<00<3i002CU`00k?<05P00k?<60?ooo`@007ZN0P00`?T4002JWP03003an000llX00??:
01L00??:0`3oool20030n@@00:2U0P00lOP3002UR@`00??:2P00n<l60?ooo`800:J[0P00lOP4002[
SPD00??;4000n<l90?ooo`D00;2C0P00n<l2002`L1P00?>J2@3oool5002eL`800?RM00<00;E?003c
JP00lfX05P00lfX50?ooo`800;Yf0P00n9d5002jDA<00?Q/1@00lcX60?ooo`@00;iB0`00n6`3002n
;AL00?<j203oool50032;P<00?Pk00<00<87003c2@00l`T05P00l`T40?ooo`800<D_0P00n3/60035
1`l00?P92P0Vl`040?ooo`D00<P70P00n0T301o801L09_<0Z@3oool001d0oooo0`000000103oool0
000000000000000@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool40000
00<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
008000000`3oool00`020780103i00@0n@02000DLP06000/n@00:g8002]b06IVIP00:g8005gi0P00
@W801000SoT005Qb001HLP00F7820030n@03001_LP00jo800>_b00<0079O00<00?S?001bB01VIVH0
0P00LTPA003hW@0306IVIP00n9d00?RM00<00?RM0P00H7d60030n@8007eX1P00l/T0101VIVH00?;9
003bb@00l/T<003hc`0400000000n<l008oi002?n@8006R64@00^o<60030n@<0oooo00<003J?001M
n@00GOT01000DXl01000SoT006j?001^S`00KXl6002ll`D00<3i3P00k?<30?ooo`<005NG0P00SoT4
001dU`030030n@00k?<00>cc01H00>cc1P3oool4001jWP800<3i0`00VYh8003an1800??:0`3oool0
0`00OjD00<3i0030n@04002PY@800?7h0`00YHTA003cbPD00?S?1@3oool3002VZ`800?7h0`00Zhh:
003cb``00?S?2@3oool5002`T`800?S?0P00/70H003cVPH0oooo0`00n<l5002eL`800?RM6000lfX5
0?ooo`<00;Yf0P00n9d5002jD@D00?=Z4000n6`80?ooo`D00;iB0`00n6`2002n;AP00?<j203oool5
0032;P<00?Pk6000l`T40?ooo`<00<D_0P00n3/600351a<00?P91@0Vl`040?ooo`H00<P70P00n0T2
01o801P09_<0Z@3oool002h0oooo00<000000?ooo`3oool04`3oool2000002T0oooo0P00000N0?oo
o`030000003oool0oooo00D0oooo00<00P1b00@0n@040?T00P0057801000;?T002]b000[LP1VIVH2
001Mn@80049b00@008oi001HLP00F78005Qb0P00`?T3003[lP<0079O00<00?S?001bB01VIVH00P00
LTP@003hW@0306IVIP00n9d00?RM00@00?RM0P00H7d60030n@03001mJ000l/T00?;900@00?;900<0
IVIV003bb@00l/T01P00l/T8003hc`0500000000n<l008oi002?n@00J8H05`00^o<40?ooo`03000f
S`00GOT005gi00@005:?00<008oi001^S`00KXl03000_?<40030n@T00>cc103oool3001GU`8008oi
1000M9L70030nA400>cc1`3oool4001jWP800<3i0`00VYh6003/l`L00?7h3@00llX30?ooo`03001o
Y@00`?T00<3i00@00:2U0P00lOP2002URAL00??:103oool4002VZ`800?7h0`00Zhh>003cb`P00?S?
2@3oool5002`T`800?S?00<00;1`003cVP00liX05P00liX60?ooo`04002eU`00n<l00?S?003hc`D0
0;Ec1`00n9dB003cJPD0oooo1000^WH2003hW@@00;YA2P00lfX<003hK0P0oooo1@00_U83003hK003
002n;@00lcX00?<j01H00?<j1P3oool3003hK0D00<8^2000n3/B003c2@@0oooo1000aBl2003h>`H0
0<D71@00l`T?003h2@L0oooo1`00b0L2003h2@0301o8000Vl`009_<001H09_<0ZP3oool00740oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`800P1b0P040?T2000DLP04000/
n@00:g8002]b06IVIP8005gi0P00@W801000SoT005Qb001HLP00F7820030n@<00>_b0`00LUl00`00
n<l0IVIV001bB002001bB1000?RM00<0IVIV003hW@00n9d01000n9d2001PO@H00<3i00<007eX003b
b@00l/T01000l/T00`1VIVH00?;9003bb@0;003bb@<00?S?00D00000003hc`00SoT008oi001XQP0G
002kl`<0oooo0P00=Xl2001Mn@<005:?0P00SoT2001^Sa800;cc0P00`?T5003/l`<0oooo1000EiL2
002?n@<007BG3@00`?T<003/l`L0oooo1000NYh20030n@8009ZN3000k?<8003an0H00??:0`3oool2
001oY@800<3i1000X:D2003an0800:F95`00llX30?ooo`D00:J[0P00lOP2002[SQ<00??;1000n<l9
0?ooo`D00;2C0P00n<lH003cVPH0oooo0P00]IL3003hc`D00;Ec1@00liX7003hW@`00?=Z1@3oool5
002jMP800?RM1000^U4>003cJPP00?Q/203oool5002nDP<00?Q/6000lcX60?ooo`040032E000n6`0
0?Q/003hK0D00<8^3@00n3/<003c2@@0oooo1@00aBl2003h>`D00<D72`00l`T:003h2@P0oooo1P00
b0L2003h2AP09_<0Z`3oool00740oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`05
0?ooo`800P1b0P040?T2000DLP04000/n@00:g80IVIV000[LP8005gi0P00@W801@00SoT005Qb001H
LP00F7800<3i00@00>_b0`00LUl00`00n<l0IVIV001bB002001bB0l00?RM00<0IVIV003hW@00n9d0
1@00n9d2001PO@H00<3i00<007eX003bb@00l/T00`00l/T00`1VIVH00?;9003bb@0?003bb@040000
0000CHH008oi002?nAP00;_c0`3oool2000fS`8005gi0`00DXl2002?n@03001^S`00_?<00;cc01H0
0;cc1@3oool4001GU`8008oi0`00M9L6002ll``00<3i1P00k?<60?ooo`8008oi1000NYh20030n@80
09ZN4P00k?<5003an0D0oooo0`00OjD20030n@@00:2U0P00lOP00`00YHT00??:003cbP0E003cbP@0
oooo1@00YZ/2003an0800:^>5`00ll/70?ooo`800?7h1@00/9<8003hca800?>J1P3oool2002eU`<0
0?S?1000]G<;003cVPL00?RM1P00lfX50?ooo`H00;Yf0P00n9d3002jDA<00?=Z1000n6`80?ooo`D0
0;iB1`00n6`C003c>PH0oooo0P00`U@3003hK0D00<8^1@00lcX=003h>`H00?<9103oool60035;`80
0?Pk1000a@LA003c2@D00?P9203oool600381`H00?P94`0Vl`2/0?ooo`00D`3oool5000000@0oooo
0`0000030?ooo`<0000000<0oooo0000003oool01P0000030?ooo`030000003oool0oooo00@0oooo
0`0g0?lB0?ooo`030000003oool0oooo00D0oooo0`02078200@0n@8001Ab00D002ci000[LP1VIVH0
02]b001Mn@030012LP04002?n@00F78005Qb001HLPD00<3i0`00LUl0101VIVH00798001bB000LTP@
003hW@0306IVIP00n9d00?RM00D00?RM0P00H7d60030n@H00?;900<0IVIV003bb@00l/T03`00l/T0
0`00000004f6002?n@0H002kl`<0oooo0`00=Xl2001Mn@<005:?0P00SoT00`00KXl00;cc002ll`0F
002ll`D0oooo1000EiL2002?n@8007BG3000_?<;0030n@L0oooo00<005^N002?n@00SoT01000NYh2
0030n@03002JWP00k?<00>cc01H00>cc1@3oool3001oY@800<3i1000X:D2003an1P00??:103oool5
002VZ`800?7h00<00:^>003cb`00ll/05P00ll/60?ooo`03002[/000lOP00?7h00D00;2C3@00n<l<
003cVPH0oooo0`00]IL3003hc`<00;Ec4@00liX5003hW@T0oooo1@00^WH2003hW@800;YA6000lfX5
0?ooo`03002nN000n9d00?RM00D00;iB2`00n6`?003c>PD0oooo0`00`U@3003hK0@00<8^2`00lcX:
003h>`L0oooo1`00aBl2003h>`<00<D75`00l`T80?ooo`H00<P72P00n0T?02Kc0:`0oooo001E0?oo
o`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`<00000103oool503L0oa40oooo00<0
00000?ooo`3oool01@3oool30080LP80103i0P0057801@00;?T0IVIV000[LP00:g8005gi00<0049b
00@008oi001HLP00F78005Qb1@00`?T3001bG`0406IVIP00LTP00798001bB0H00?:I2@00n9d00`1V
IVH00?RM003hW@06003hW@80061m1P00`?T5003bb@0306IVIP00l/T00?;901000?;900<00000001=
QP00SoT01@00SoTC002kl`80oooo1000=Xl2001Mn@<005:?0P00SoTH002ll`H0oooo1000EiL2002?
n@8007BG4@00_?<60030n@L0oooo00<005^N002?n@00SoT01000NYh20030n@03002JWP00k?<00>cc
01H00>cc103oool4001oY@800<3i1000X:D7003an1800??:1@3oool5002VZ`800?7h00<00:^>003c
b`00ll/05@00ll/70?ooo`03002[/000lOP00?7h00D00;2C1P00ll/<003hc`H00?>J1P3oool4002e
U`<00?S?0`00]G<F003cVPT0oooo1@00^WH2003hW@800;YA6000lfX40?ooo`800;ih0P00n9d5002n
DPl00?Q/2P00lcX50?ooo`@00<9D0`00n6`30032;Q400?<j1@00n3/80?ooo`H00<D_0P00n3/20035
1aP00?<9103oool4003d>PH00<P73P00n0T:02Kc0:d0oooo001E0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000030?ooo`L0=`3o3`3oool00`000000oooo0?ooo`060?oo
o`<00P1b0P040?T2000DLP05000/n@1VIVH002]b000[LP00GOT00`00@W801000SoT005Qb001HLP00
F7850030n@80079O00@0IVIV003hc`00LTP007983@00lYT3003hW@0306IVIP00n9d00?RM00H00?RM
0P00H7d50030n@H00?;900<0IVIV003bb@00l/T04000l/T00`00000004f6002?n@09002?n@l00;_c
0P3oool4000fS`8005gi0`00DXl00`00SoT00;cc002ll`0G002ll`@0oooo0P00GOT4001GU`8008oi
00<007BG002ll`00_?<05@00_?<70?ooo`8005^N0P00SoT4001jWP800<3i6000k?<40?ooo`D007nU
0P00`?T4002PY@H00>cc1@00lOP>003cbPD0oooo1@00YZ/2003an1L00??;1`3oool2002[/0800?7h
1000/9<<003cb`X00?S?203oool5002eU`<00?S?0P00]G<G003cVPT0oooo1@00^WH2003hW@03002j
D@00lfX00?=Z01H00?=Z103oool3002nN0800?RM1@00_U8C003hK0D00?<j1@3oool50032E0<00?Q/
0`00`RhF003c>PP0oooo1P00aBl2003h>`0300351`00l`T00?<901H00?<9103oool5003d>PH00<P7
4P00n0T502Kc0:h0oooo001E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103o
ool4000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
1`0g0?l?0?ooo`030000003oool0oooo00H0oooo0`0207801@040?T001Ab000DLP005780IVIV00<0
02]b00D005gi0012LP00@W80049b002?n@03001HLPD00<3i0P00LUl0101VIVH00?;9001bB000LTP@
003bV@0306IVIP00lYT00?:I00H00?RM0P00H7d:0030n@0306IVIP00l/T00?;901000?;900<004f6
00000000CHH03`00SoT9002kl`<0oooo1000=Xl2001Mn@<005:?1P00SoTC002ll`@0oooo00<003VG
001Mn@00GOT01000EiL2002?n@03001dU`00_?<00;cc01D00;cc1`3oool2001KWP8008oi1000NYh0
0`00`?T00>cc003/l`0F003/l`D0oooo1@00OjD20030n@<00:2U3000k?<4003an0T00??:103oool2
0030n@D00:J[1`00lOPB003cb`L0oooo0P00Zk02003an0<00;2C4P00ll/5003hc`T0oooo1000]IL3
003hc`03002eL`00liX00?>J01D00?>J1`3oool3003hc`D00;Yf0P00n9dH003cJPD0oooo0`00_WP2
003hW@D00;iB5@00n6`70?ooo`H00<9D0`00n6`20032;QL00?<j203oool60035;`800?Pk6000l`T4
0?ooo`H00?@j1P00b0L4003c2A000?P9/@3oool005D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo1`0g0?l;0?ooo`8000000P3oool00`000000oooo0?ooo`05
0?ooo`0503H0n@0207800P1b0080LP040?T00`0057801@1VIVH002]b000[LP00:g8005gi00<0049b
00@008oi001HLP00F78005Qb1@00`?T01@00LUl0IVIV003bb@00l/T0079801000?:I00<0IVIV003b
V@00lYT01P00lYT3001PO@X00<3i00<0IVIV0030n@00`?T00`00`?T=003bb@03001=QP00000004f6
01<008oi1@00^o<30?ooo`@003J?0P00GOT3001BS`X008oi3`00_?<40?ooo`03000iU`00GOT005gi
00@005NG0P00SoTG002ll`L0oooo0`00Fih2002?n@@007ZN1`00`?TB003/l`D0oooo1@00OjD20030
n@800:2U4P00k?<3003an0D00??:0`3oool00`00Q:/00<3i0030n@05002VZ``00?7h3000ll/70?oo
o`<00:^`0P00lOP3002`TaL00??;2@3oool4002eU`<00?S?5`00liX70?ooo`04002jV`00n<l00?S?
003hc`D00;Yf1000liX4003hWA800?=Z103oool4002nN0800?RM1@00_U86003cJPl00?Q/203oool5
0032E0<00?Q/00<00<8^003c>P00lcX05@00lcX60?ooo`030035EP00n6`00?Q/00H00<D_1`00n3/B
003c2@@0oooo1`00m3X500381`T00?<93000n0Va0?ooo`00E@3oool00`000000oooo0?ooo`020?oo
o`D000000P3oool4000000D0oooo00@000000?ooo`3oool0oooo0`000000103oool0000000000000
00020?ooo`D0=`3o3P3oool4000000H0oooo00D0=P3i0080LP0207800P1b00@0n@02000DLP0306IV
IP00;?T002]b008002]b00D005gi0012LP00@W80049b002?n@03001HLPD00<3i00D0079O06IVIP00
l/T00?;9001bB00@003bV@0306IVIP00lYT00?:I00H00?:I0`00H7d90030n@0306IVIP00`?T00<3i
00X00<3i1P00l/T2001=QP0300000000CHH008oi01@008oi1@3oool00`00;?T003J?000fS`02000f
S`03001Mn@00DXl005:?008005:?3`00SoT9002ll`@0oooo0P00>IL2001Mn@@005NG00<008oi002l
l`00_?<05P00_?<60?ooo`@005^N0P00SoT4001jWP`00<3i3000k?<60?ooo`D007nU0P00`?T2002P
YAL00>cc1P3oool00`00Q:/00<3i0030n@05002VZa400?7h1P00ll/80?ooo`<00:^`0P00lOP2002`
TaP00??;2@3oool4002eU`P00?S?4P00liX60?ooo`800;ZK0`00n<l4002jMPT00?>J1@00n9d<003c
JP@0oooo1@00_WP2003hW@@00;iB3000lfX:003hK0P0oooo1@00`U@3003hK1L00?<j1P3oool20035
EP800?Q/1P00aBl<003h>``00?<9103oool8003d>P@00<P73P00l`T8003h2K40oooo001E0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`<0
=`3o403oool00`000000oooo0?ooo`02000000<0oooo00<06@1b03H0n@0207800P0207801@040?T0
01Ab000DLP1VIVH002ci00<002]b00D005gi0012LP00@W80049b002?n@03001HLPD00<3i00@0079O
06IVIP00l/T00?;94000lYT00`1VIVH00?:I003bV@06003bV@@0061m2@00`?T00`1VIVH00<3i0030
n@0:0030n@03000HQP00;?T003:6008003:600D005gi001=QP00CHH00000001=QP0E002?n@@0oooo
00<001V?000/n@00=Xl00`00=Xl00`00GOT005:?001BS`02001BSa<008oi1@00_?<40?ooo`8003VG
0P00GOT4001GU`H008oi4P00_?<70?ooo`@005^N0P00SoT3001jWQ800<3i1P00k?<60?ooo`03002?
n@00OjD007nU00<007nU0P00`?T00`00X:D00>cc003/l`0F003/l`D0oooo0P00Q:/20030n@D00:J[
5000lOP:0?ooo`@00:^`0P00lOP00`00/9<00??;003cb`0F003cb`L0oooo0`00lOP4002eU`d00?S?
3000liX70?ooo`800;ZK0`00n<l4002jMPd00?>J1P00n9d6003cJP@0oooo1P00_WP2003hW@<00;iB
4P00lfX5003hK0P0oooo1@00`U@8003hK1800?<j1@3oool30035EP800?Q/1P00aBl5003c>P`00?Pk
1P00l`T40?ooo`T00?@j0`00b0LC003c2@@00?P9/@3oool005<0oooo1@0000030?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`0301T0LP0f
0?T00P1b00800P1b00D0103i000DLP005780IVIV000/n@03000[LP04001Mn@00@W80049b002?n@@0
05Qb1@00`?T00`1VIVH00?;9003bb@0A003bV@0306IVIP00lYT00?:I00H00?:I0`00H7d90030n@03
06IVIP00`?T00<3i00/00<3i00<001R6000/n@00<XH00P00<XH01@00GOT004f6001=QP00000004f6
01D008oi103oool00`006Hl002ci000fS`03000fS`03001Mn@00DXl005:?008005:?5P00SoT50?oo
o`<003VG0P00GOT4001GU`X008oi3P00_?<70?ooo`@005^N0P00SoT3001jWPD00;cc4@00`?T70?oo
o`03001NY@00SoT007nU00@007nU0P00`?TH003/l`H0oooo0P00Q:/20030n@D00:J[5000lOP:0?oo
o`@00:^`0P00lOPI003cb`H0oooo00@00;2e003an000lOP00?7h1000]ILB003hc`H00?>J1`3oool3
002jV`<00?S?0`00^WHB003cVP@00?RM203oool6002nN0800?RM0`00_U8G003cJPD0oooo0`00n9d5
0032E0d00?Q/3000lcX50?ooo`@00<EF0P00n6`50035;`/00?<j2P00n3/60?ooo`X00?@j0`00b0LG
003c2K40oooo001X0?ooo`<000007`3oool00`000000oooo0?ooo`050?ooo`806@1b00<0=P3i0080
LP0207800P040?T00`005780IVIV000/n@04000[LP04001Mn@00@W80049b002;lP@005Qb1@00`?T0
0`1VIVH00?;9003bb@05003bb@/00?:I00<0IVIV003bV@00lYT01P00lYT00`00SoT0061m00000004
000000<00;_b0`000000101VIVH00<3i0030n@00`?T3000000L00<3i00<001R6000/n@00<XH00P00
<XH01@00GOT004f6001=QP00000004f601D008oi0`3oool2000IS`03000/n@00=Xl003J?008003J?
00<005gi001BS`00DXl00P00DXlF002?n@@0oooo1000>IL2001Mn@@005NG3P00SoT9002ll`P0oooo
1000Fih2002?n@8007ZN2P00_?<=0030n@H0oooo0P00GZD00`00SoT007nU001oY@03001oY@030030
n@00k?<00>cc01H00>cc1P3oool30024Z`800<3i1@00YZ/D003an0X0oooo1000Zk07003an1<00??;
1`3oool01000/;D00?7h003an000lOP4002eUaD00?S?2@3oool4002jV`<00?S?0P00^WHG003cVPP0
oooo1P00_WP2003hW@800;iB6000lfX40?ooo`040032N`00n9d00?RM003hW@D00<9D4P00n6`6003c
>PD0oooo1@00aEH2003hK0@00<D_4@00lcX5003h>`/0oooo1@00m3X200381aL00?<9/P3oool008T0
oooo00<000000?ooo`3oool01P3oool201T0LP0303H0n@0207800P1b0080103i00<001Ab06IVIP00
;?T01000:g801000GOT0049b0012LP00Ro83001HLPD00<3i00<0IVIV003bb@00l/T02`00l/T6003b
V@0306IVIP00lYT00?:I00H00?:I00D008oi001PO@00H7d00;_b00000004002klP0800000000^o80
0;_b002klP0000000;_b0030n@0000030030n@0300000000`?T00<3i00@00<3i00<001R6000/n@00
<XH00P00<XH01@00GOT004f6001=QP00000004f601D008oi0`3oool2000IS`03000/n@00=Xl003J?
008003J?00<005gi001BS`00DXl00P00DXlF002?n@@0oooo1000>IL2001Mn@@005NG4P00SoT5002l
l`H0oooo0P00GOT4001KWP8008oi0P00NYh?002ll`P00<3i1P3oool2001NY@03002?n@00OjD007nU
00<007nU1`00`?TB003/l`D0oooo1000Q:/20030n@D00:J[1@00k?<?003an0X0oooo1000Zk0;003a
n0h00??;1`3oool2002`]@<00?7h1000]IL6003cb`l00?S?203oool5002jV`<00?S?0P00^WHG003c
VPP0oooo1P00_WP2003hW@03002nDP00lfX00?=Z01H00?=Z103oool20032N`<00?RM1@00`U@D003h
K0P0oooo1P00aEH2003hK0<00<D_5`00lcX@0?ooo`0300381`00l`T00?<901D00?<9/`3oool004P0
oooo0`0000030?ooo`@00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000H0
oooo0`1Z0?lB0?ooo`030000003oool0oooo00D0oooo0`0I07800`0f0?T00P1b0080LP0200@0n@03
06IVIP00578002ci00<002]b0P00GOT00`00@W8008_b002;lP03001HLPD00<3i00<0IVIV003bb@00
l/T03`00l/T00`00lYT0IVIV003bV@07003bV@060017O@00SoT0061m001PO@00^o8000001000^o80
1@0000000;_b002klP1VIVH0000000800;_b00D00000002klP00^o800;_b000000060030n@03000H
QP00<XH003:6008003:600D005gi001=QP00CHH00000001=QP0E002?n@80oooo0`006Hl00`00;?T0
03J?000fS`02000fS`03001Mn@00DXl005:?008005:?5P00SoT40?ooo`@003VG0P00GOT4001GUaD0
08oi1`3oool00`00>ih005gi001Mn@04001KWP8008oi00<007ZN002ll`00_?<04P00_?<40030n@D0
oooo0`00GZD00`00SoT007nU001oY@03001oY@`00<3i3000k?<60?ooo`@008B[0P00`?T4002VZ`/0
0>cc2P00lOP80?ooo`800<3i1000Zk0?003an0X00??;1P3oool3002`]@<00?7h0`00]IL<003cb`X0
0?S?203oool5002jV`<00?S?00<00;Yf003cVP00liX05@00liX70?ooo`800?S?1P00_WP2003hWAP0
0?=Z103oool30032N`<00?RM1@00`U@D003hK0L0oooo1`00aEH2003hK0800<D_6000lcX@0?oooaL0
0?<9]03oool004L0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`D0JP3o
4@3oool00`000000oooo0?ooo`050?ooo`<06@1b00<0=P3i0080LP0207800P040?T00`1VIVH001Ab
000/n@03000[LP8005gi00<0049b002;lP00Ro800`00F7840030n@0306IVIP00`?T00<3i00@00<3i
3@00l/T0101VIVH00?;9003bb@00l/T5003bV@030017O@00SoT0061m00800;_b00<00000002klP00
^o800P00^o801@0000000;_b002klP1VIVH0000000800;_b00D00000002klP00^o800;_b00000005
002klP03000HQP00;?T003:600<003:600D005gi001=QP00CHH00000001=QP0E002?n@030?ooo`00
6Hl001V?008001V?00<002ci000fS`00=Xl00P00=Xl00`00GOT005:?001BS`02001BSaH008oi103o
ool4000iU`8005gi1000EiLE002?n@L0oooo00<003^N001Mn@00GOT01000Fih2002?n@03001jWP00
_?<00;cc01H00;cc103oool4001NY@03002?n@00OjD007nU00<007nU4@00`?T6003/l`L0oooo1000
Q:/20030n@<00:J[4@00k?<5003an0L0oooo00<008R`0030n@00`?T01000Zk0C003an0D00??;1`3o
ool3002`]@<00?7h0`00]ILA003cb`D00?S?203oool5002jV`<00?S?5`00liX70?ooo`03002nWP00
n<l00?S?00H00;ih1000liX3003hWA800?=Z103oool40032N`<00?RM1@00`U@5003cJPl00?Q/203o
ool60035EP800?Q/00<00<D_003c>P00lcX05P00lcX50?ooo`030038E`00n6`00?Q/00800?Q/303o
oolA003c2KD0oooo00170?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo1`1Z0?l?0?ooo`030000003oool0oooo00H0oooo0`0I
07801@0f0?T00P1b0080LP040?T0IVIV008001Ab00@002ci000[LP00:g8002]b0P00GOT00`00@W80
08_b002;lP03001HLP@00<3i00<0IVIV0030n@00`?T02P00`?T6003bb@0306IVIP00l/T00?;900<0
0?;900<005gi0017O@00Agd00P00Agd01@00SoT0061m002klP00^o80000000@00;_b00D00000002k
lP1VIVH00;_b00000002002klP0500000000^o800;_b002klP0000001@00^o800`0068H002ci000b
QP03000bQP05001Mn@00CHH004f600000000CHH05@00SoT00`3oool001V?000IS`02000IS`03000/
n@00=Xl003J?008003J?00@005gi001BS`00DXl005:?5`00SoT30?ooo`03000/n@00>IL003VG0080
03VG0P00GOT4001GUaD008oi1P3oool2000kWP8005gi1000Fih2002?nAT00;cc0`3oool5001NY@03
002?n@00OjD007nU00<007nU5@00`?T90?ooo`@008B[0P00`?T3002VZaH00>cc1P3oool20028/080
0<3i1000Zk0E003an0T0oooo1000/;D3003an0800;FG5`00ll/80?ooo`D00;ZK2000n<lB003cVPH0
oooo0P00_Yh2003hc`D00;ih2@00liX4003hW@`00?=Z103oool50032N`<00?RM1000`U@;003cJPX0
0?Q/203oool60035EP800?Q/6000lcX50?ooo`800<QG2@00n6`<0?ooo`/00?<9]P3oool004L0oooo
00<000000?ooo`3oool00P0000030?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`D00000
0P3oool00`000000oooo0?ooo`040?ooo`D000000`3oool706X0o`l0oooo00<000000?ooo`3oool0
1P3oool301T0LP0503H0n@0207800P1b00@0n@1VIVH00P0057801000;?T002]b000[LP00:g82001M
n@<008_b0`00F7830030n@0306IVIP00`?T00<3i01400<3i00<0IVIV003bb@00l/T00`00l/T00`00
GOT004Mm0017O@020017O@05002?n@00^o800;_b002klP0000001000^o801@0000000;_b06IVIP00
^o80000000800;_b00D00000002klP00^o800;_b00000004002klP8001R600<002ci000bQP00<XH0
0P00<XH01@00GOT004f6001=QP00000004f601D008oi00<0oooo000IS`006Hl00P006Hl00`00;?T0
03J?000fS`02000fS`04001Mn@00DXl005:?001BS`H008_c4@00SoT20?ooo`03000JU`00;?T003VG
00<003VG0P00GOT4001GUaD008oi1P3oool2000kWP8005gi1000Fih00`00SoT00;cc002ll`0G002l
l`@0oooo1@00GZD00`00SoT007nU001oY@03001oYAD00<3i1`3oool2002?n@@008B[0P00`?T2002V
ZaL00>cc1P3oool20028/0800<3i1000Zk0E003an0P0oooo1@00/;D3003an0800;FG5`00ll/80?oo
o`D00;ZK3@00n<l<003cVPL0oooo0P00_Yh2003hc`@00;ih3P00liX5003hW@H00?=Z103oool60032
N`<00?RM0`00`U@A003cJPD00?Q/203oool60035EPL00?Q/4P00lcX50?ooo`<00<QG3P00n6`<0?oo
o`D00?<9]`3oool004L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool706X0o`h0oooo
00<000000?ooo`3oool01P3oool01@1W0?T06@1b01T0LP0I0780=P3i00800P1b00D0103i06IVIP00
578001Ab000/n@03000[LP8005gi0`00Ro83001HLP<00<3i00<0IVIV0030n@00`?T04000`?T0101V
IVH001Im000FO@00;?T3000_O@03001Mn@00Agd004Mm008004Mm1000^o800`0000000;_b002klP02
002klP050000001VIVH00;_b002klP0000000P00^o801@0000000;_b002klP00^o80000000@00;_b
0P0068H00`00;?T003:6000bQP02000bQP05001Mn@00CHH0000000000000CHH05@00SoT00`3oool0
01V?000IS`02000IS`03000/n@00=Xl003J?008003J?00<005gi001BS`00DXl03000Ro<<002?n@80
oooo00<001ZG000/n@00>IL00`00>IL2001Mn@@005NG5@00SoT50?ooo`<003^N0P00GOT4001KWPH0
08oi4`00_?<50?ooo`D005jU00<008oi001oY@00OjD00`00OjDE0030n@H0oooo00<006:[002?n@00
SoT01000Q:/20030n@03002VZ`00k?<00>cc01D00>cc1P3oool30028/0800<3i1000Zk0E003an0T0
oooo1000/;D3003an003002eU`00ll/00??;01D00??;1`3oool2003an0D00;ZK1@00ll/=003hc`H0
0?>J1`3oool3002nWP800?S?0`00_WPC003cVP@00?RM203oool50032N`<00?RM0`00`U@F003cJPD0
oooo0`00n9d60035EP`00?Q/3000lcX50?ooo`@00<QG4`00n6c30?ooo`00A`3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`0000000P0000030?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`<000001@3oool506X0o``0oooo100000070?ooo`0302l0LP1W0?T06@1b0080
6@1b0`0207801@1VIVH0103i000DLP00578002ci00<002]b00<005gi002;lP00Ro800P00Ro83001H
LP800<3i00<0IVIV0030n@00`?T04@00`?T0101VIVH001Im000FO@00;?T3000_O@04001Mn@00Agd0
04Mm0017O@<008oi0`0000001P00SoT00;_b002klP00^o80000006IVIP800;_b00@00000002klP00
^o8000000`00^o80100000000;_b002klP00^o83000HQP03000/n@00<XH003:6008003:600@005gi
06IVIP00000004f60`00000C002?n@0300@0n@006Hl001V?008001V?00<002ci000fS`00=Xl00P00
=Xl00`00GOT005:?001BS`0B002;l`H008oi00@0oooo000JU`006YL002ci1000>IL2001Mn@<005NG
5P00SoT40?ooo`@003^N0P00GOT4001KWPX008oi3`00_?<50?ooo`D005jU00<008oi001oY@00OjD0
0`00OjDE0030n@H0oooo00<006:[002?n@00SoT01000Q:/20030nAP00>cc1@3oool40028/0800<3i
1000Zk0E003an0T0oooo1000/;D3003an1L00??;1`3oool00`00];X00?7h003an004002jV`X00??;
3000n<l90?ooo`@00;jN0P00n<l2002nN1P00?>J203oool50032N`<00?RM0P00`U@G003cJP@0oooo
00@00<Em003hW@00n9d00?RM1P00aEHA003hK0H00?<j1@3oool50038Ea<00?Q/``3oool004L0oooo
00D000000?ooo`3oool0oooo0000000X0?ooo`<0JP3o3`3oool00`000000oooo00000002000000@0
oooo00D0;`1b06L0n@0I07806@1b03H0n@030080LP0506IVIP00578001Ab000DLP00;?T00`00:g85
001Mn@<005Qb0P00`?T00`1VIVH00<3i0030n@0@0030n@0406IVIP005Wd001Im000FO@@002mm00@0
05gi0017O@00Agd004Mm1@00Ro800`00000008oi002?n@02002?n@0406IVIP0000000000000000@0
0;_b0`000004002klP<001R600<002ci000bQP00<XH00P00<XH01000GOT0IVIV00000000CHH3002;
l`80000000<008_c002?n@00SoT03P00SoT00`040?T001V?000IS`02000IS`03000/n@00=Xl003J?
008003J?00<005gi001BS`00Ro<05`00Ro<20?ooo`8001ZG00<002ci000iU`00>IL00P00>IL2001M
n@<005NG1P00Ro<@002?n@@0oooo1000>ih2001Mn@@005^N3P00SoT:002ll`D0oooo00<005gi001N
Y@00GZD00`00GZD00`00SoT007nU001oY@02001oYAH00<3i1@3oool2001RZ`8008oi1000Q:/80030
nA400>cc1@3oool50028/0800<3i1000Zk06003/l`l00?7h2@3oool4002`]@P00?7h4P00ll/60?oo
o`800;Bj0P00lOP4002jV`h00??;2000n<l80?ooo`D00;jN0P00n<l00`00_WP00?>J003cVP0G003c
VPP0oooo1@00`W/3003hW@030032E000lfX00?=Z01D00?=Z103oool20035O@<00?RM1P00aEHC003h
K0P0oooo1P00b5LC003hK<<0oooo00120?ooo`<000000`3oool3000003/0oooo00<000000?ooo`3o
ool01@3oool202l0LP0406L0n@0I07806@1b03H0n@800P1b00<0IVIV00@0n@0057800P0057801000
;?T002]b000[LP00:g85001Mn@<005Qb0P00`?T00`1VIVH00<3i0030n@0@0030n@0406IVIP005Wd0
01Im000FO@@002mm00<005gi0017O@00Agd02`00Ro800`1VIVH008oi002?n@05002?n@H00;_b00D0
103i000HQP0068H001R6000/n@04000bQP0306IVIP00CHH0000000`008_c2`00SoT00`040?T001V?
000IS`02000IS`03000/n@00=Xl003J?008003J?00<005gi001BS`00Ro<05`00Ro<01@3oool001ZG
000JU`006YL002ci00@003VG0P00GOT2001GU``008_c2`00SoT40?ooo`@003^N0P00GOT4001KWQ80
08oi1@00_?<50?ooo`03000nY@00GOT005jU00@005jU00<008oi001oY@00OjD00P00OjD6002lla00
0<3i1@3oool2001RZ`8008oi1000Q:/=0030n@`00>cc1@3oool50028/0800<3i0`00Zk0<003/l`X0
0?7h1P3oool00`00S;D00<3i0030n@04002`]@d00?7h3000ll/70?ooo`800;Bj0P00lOP3002jVa<0
0??;1000n<l80?ooo`D00;jN0P00n<lI003cVPH0oooo0`00n<l50032N`<00?RM5`00lfX40?ooo`<0
0<Em0`00n9d60035EPD00?=Z3P00n6`70?ooo`L00<QG4`00n6c30?ooo`00@`3oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo00D0oooo0P0_0780101W0?T06@1b01T0LP0f0?T20080LP03
06IVIP040?T001Ab008001Ab00@002ci000[LP00:g8002]b1@00GOT3001HLP030030n@1VIVH00<3i
01800<3i00@0IVIV000FO@005Wd001Im1000;gd00`00GOT004Mm0017O@0:002;lP0306IVIP00Ro80
08_b00D008_b1P00SoT00`0208H001R6000HQP02000HQP03000/n@00<XH003:6008003:600<0IVIV
001=QP0000004@00Ro<6002?n@0300@0n@006Hl001V?008001V?00<002ci000fS`00=Xl00P00=Xl0
0`00GOT008_c002;l`0F002;l`030?ooo`006YL001ZG008001ZG00<002ci000iU`00>IL00P00>IL2
001Mn@8005NG4@00Ro<6002?n@@0oooo1000>ih2001Mn@@005^N5@00SoT60?ooo`8003jU00<005gi
001NY@00GZD00`00GZD01000SoT007nU001oY@00OjD<002ll`/00<3i103oool3001RZ`8008oi1000
Q:/B0030n@H00>cc1P3oool50028/0800<3i0`00Zk0A003/l`D00?7h1@3oool2002<]@800<3i1000
/;DB003an0H00??;1`3oool3002d^P800?7h0P00^Y/H003cb`P0oooo1@00_Yh6003hca@00?>J1P3o
ool01000`Z400?S?003hc`00n<l50032N`D00?>J0`00n9dB003cJP<0oooo1000aGd3003hW@D00<EF
2`00lfX9003hK0P0oooo1P00b5LC003hK<<0oooo00130?ooo`030000003oool0oooo03l0oooo00<0
00000?ooo`3oool01@3oool302l0LP0806L0n@0I07806@1b03H0n@020780IVIV0080LP040?T3000D
LP04000/n@00:g8002]b000[LP@005gi1000F7800`00`?T0IVIV0030n@0A0030n@0306IVIP00`?T0
01Im008001Im1000;gd00`00GOT004Mm002;lP0:002;lP0306IVIP00Ro8008_b00X008_b0P0208H4
000HQP08000/n@00<XH003:6000bQP1VIVH005gi001=QP00000F002;l`030080S`040?T001V?00<0
01V?00D002ci000fS`00=Xl003J?001Mn@0I002;l`030?ooo`006YL001ZG008001ZG00<002ci000i
U`00>IL00P00>IL2001Kl`03001GU`00Ro<008_c01D008_c0`3oool2000/n@@003^N0P00GOT4001K
WQD008oi1P3oool2000nY@03001Mn@00GZD005jU00<005jU00@008oi001oY@00OjD007nU4@00_?<6
0030n@<0oooo1000HZ/2002?n@@008B[5@00`?T90?ooo`D008R`0P00`?T2002[/1L00>cc1@3oool2
002<]@800<3i1000/;DE003an0T0oooo1000];X2003an0800;ZK6000ll/80?ooo`D00;jN2P00n<l?
003cVPH0oooo0P00`Z43003hc`@00<9k2`00liX3003hW@`00?=Z0`3oool50035O@<00?RM1000aEHA
003cJP@00?Q/203oool60038Ea<00?Q/``3oool000<0oooo100000030?ooo`H000000P3oool30000
00D0oooo00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000000000<0oooo0P000008
0?ooo`<000000P3oool200000080oooo0`0000030?ooo`@00000103oool3000000040?ooo`000000
00000?ooo`<000000`3oool6000000030?ooo`000000000000<000000`3oool3000000D0oooo0`2M
0?lC0?ooo`030000003oool0oooo00@0oooo100_0780201W0?T06@1b01T0LP0f0?T00P1b06IVIP02
0780103i0`0057801000;?T002]b000[LP00:g84001Mn@@005Qb00<0IVIV0030n@00`?T04@00`?T0
0`1VIVH00<3i000FO@02000FO@@002mm00<005gi0017O@00Ro802@00Ro800`1VIVH008_b002;lP0;
002;lP800P26100068H02000;?T003:6000bQP00<XH0IVIV001Kl`00CHH000005P00Ro<00`0208l0
103i000IS`03000IS`04000/n@00=Xl003J?000fS`H005_c00<005gi002;l`00Ro<04000Ro<20?oo
o`@001ZG00@002ci000iU`00>IL003VG0`00Fo<00`00EiL008_c002;l`0E002;l`80oooo00<001bN
000/n@00;?T01000>ih2001Mn@@005^N5@00SoT50?ooo`<003jU00<005gi001NY@00GZD00`00GZD0
0`00SoT007nU001oY@0G002ll`@0oooo1000HZ/2002?n@@008B[5@00`?T70?ooo`8008oi1@00R;02
0030n@800:^`5`00k?<40?ooo`<008be0P00`?T4002`]AD00?7h203oool5002d^P800?7h00<00;ZK
003cb`00ll/05P00ll/60?ooo`03002h_P00lOP00?7h00D00;jN1@00ll/9003hc`X00?>J1`3oool2
0032X@<00?S?0`00`W/A003cVP<00?RM1P00lfX30?ooo`H00<Em0`00n9d30035EQH00?=Z203oool6
0038Ea<00?Q/``3oool000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000002`3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00<0oooo1@2M0?lA0?ooo`030000003oool0oooo00D0oooo100_07801@1W0?T06@1b01T0LP0f0?T0
IVIV00800P1b00<0103i000DLP0057800P00;?T3000[LP@005gi1000F7800`1VIVH00<3i0030n@0@
0030n@0306IVIP00`?T00<3i00<001Im1000;gd00`00GOT008_b002;lP09002;lP0306IVIP00Ro80
08_b00X008_b0P0208H00`040?T001R6000HQP02000HQP04000/n@00<XH003:606IVIP8005_c00<0
08_c00000000Ro<05@00Ro<00`0208l0103i000IS`03000IS`03000/n@00=Xl003J?00`005_c00<0
05gi002;l`00Ro<02`00Ro<20?ooo`@001ZG00@002ci000iU`00>IL003VG0`00Fo<G002;l`<0oooo
00<001bN000/n@00;?T01000>ih2001Mn@<005^N5P00SoT40?ooo`@003jU00<005gi001NY@00GZD0
0`00GZD00`00SoT007nU001oY@0G002ll`@0oooo1000HZ/2002?n@@008B[1P00_?<?0030n@H0oooo
00<006F`002?n@00SoT01@00R;020030n@03002[/000k?<00>cc01D00>cc1@3oool3002<]@800<3i
1000/;DE003an0P0oooo1@00];X2003an1P00??;1P3oool2002h_P800?7h1000_Yh;003cb`P00?S?
1@00liX70?ooo`<00<:Q0`00n<l30032NaH00?>J203oool50035O@<00?RM0P00aEHG003cJPD0oooo
0`00n9d60038Ea<00?Q/``3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0000000<0?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`L0W@3o
403oool00`000000oooo0?ooo`050?ooo`@0;`1b00D0I`3i01T0LP0I0780=P3i06IVIP020080LP03
00@0n@00578001Ab008002ci0P00:g85001Mn@<005Qb00<0IVIV0030n@00`?T04@00`?T00`1VIVH0
0<3i0030n@02000FO@03000/n@00;gd002mm008002mm2`00Ro800`1VIVH008_b002;lP0;002;lP80
0P2600<0103i000HQP0068H00P0068H01@00;?T003:6000bQP1VIVH005_c008008_c00<00000002;
l`00Ro<04`00Ro<20080S`0300@0n@006Hl001V?008001V?00<002ci000fS`00=Xl04@00Fo<2001M
n@H008_c00<0oooo00@0n@040?T010006YL00`00;?T003VG000iU`03001KlaP008_c0P3oool2000L
WP8002ci1000>ih2001Mn@<005^N1P00Ro<@002?n@<0oooo1@00?ZD00`00GOT005jU001NY@03001N
Y@03002?n@00OjD00;cc01H00;cc1@3oool4001RZ`8008oi0`00Q:/<002ll`X00<3i1@3oool2001U
/08008oi1@00R;020030nAL00>cc1@3oool4002<]@800<3i1000/;D6003/l`l00?7h203oool5002d
^PP00?7h4P00ll/50?ooo`<00;Rn0P00lOP3002nWQ400??;1@00n<l90?ooo`@00<:Q0`00n<l20032
NaL00?>J203oool50035O@<00?RM00<00<EF003cJP00lfX05@00lfX50?ooo`040038O`00n9d00?RM
003hW@H00<QG4`00n6c30?ooo`001@3oool3000000@0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`@000000P3o
ool2000000d0oooo00@000000?ooo`3oool000000`3oool500000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo1`2M0?l?0?ooo`030000003oool0oooo00H0oooo100_078301T0LP0303H0n@1VIVH0
0P1b0080103i0P0057801000;?T002]b000[LP00:g85001Mn@<005Qb00<0IVIV0030n@00`?T04000
`?T0101VIVH00<3i0030n@00`?T2000FO@03000/n@00;gd002mm008002mm1@00GOT6002;lP0306IV
IP00Ro8008_b00X008_b0`0208H00`040?T001R6000HQP02000HQP03000/n@00<XH0IVIV00@005_c
00@00000001Kl`00Fo<005_c4P00Ro<20080S`0300@0n@006Hl001V?008001V?00<002ci000fS`00
Fo<05P00Fo<40?ooo`80103i10006YL00`00;?T003VG000iU`09001Kla4008_c0`3oool2000LWP80
02ci1000>ih2001Mn@8005^N3000Ro<;002?n@<0oooo1@00?ZD00`00GOT005jU001NY@03001NY@03
002?n@00_?<00;cc01H00;cc0`3oool2001Mn@@006:[0P00SoT30024Za400;cc1@00`?T50?ooo`80
06F`0P00SoT50028/0L00<3i4P00k?<40?ooo`D008be0P00`?T3002`]@`00>cc2P00lOP80?ooo`D0
0;Bj3@00lOP<003cb`H0oooo0`00^;h2003an0<00;jN5P00ll/80?ooo`D00<:Q0`00n<l00`00`W/0
0?>J003cVP0E003cVPT0oooo1@00aGd3003hWAL00?=Z1@3oool20038O`<00?RM1P00b5LC003hK<<0
oooo00030?ooo`<000001P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00H000000?ooo`3oool000000?ooo`00
000<0?ooo`@000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool709d0o`l0oooo00<000000?ooo`3oool01@3oool00`2I0?T0;`1b02l0
LP0202l0LP<06@1b00<0IVIV0080LP0207800P040?T2000DLP04000/n@00:g8002]b000[LPD005gi
0P00F7800`1VIVH00;_b002klP03002klPh00<3i00@0IVIV0030n@00`?T00<3i0P005Wd01000;?T0
02mm000_O@00;gd:001Mn@03002;lP1VIVH008_b00`008_b0`0208H00`040?T001R6000HQP02000H
QP03000/n@00<XH0IVIV00@005_c00<00000001Kl`00Fo<01P00Fo<<002;l`<00P2?00@0103i000I
S`006Hl001V?0P00;?T00`00=Xl005_c001Kl`0E001Kl`<0oooo00<00`2G00@0n@040?T010006YL0
0`00;?T003VG001Kl`0>001Kl``008_c0P3oool3000LWP8002ci1000>ih2001Mn@8005^N4@00Ro<6
002?n@<0oooo1@00?ZD00`00GOT005jU001NY@03001NY@H008oi4P00_?<30?ooo`030010Z`00GOT0
05gi00@006:[0P00SoT20024ZaL00;cc103oool3001U/08008oi1@00R;0<0030n@`00>cc1@3oool5
002<]@800<3i0`00/;DA003/l`D00?7h1P3oool20030n@D00;Bj4P00lOP6003cb`H0oooo1000^;h2
003an0800;jN5`00ll/80?ooo`D00<:Q0`00n<lG003cVPL0oooo0`00n<l50035O@@00?>J1000n9dB
003cJP@0oooo0`00b7l3003hW@H00<QG4`00n6c30?ooo`000`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00<0oooo0`0000020?ooo`<0000000D0oooo00000000000000000?ooo`04
000000<0oooo00<000000?ooo`3oool00P00000:0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool300000080oooo00<000000?ooo`0000000P0000020?ooo`8000000P3oool200000080oooo1000
00050?ooo`030000003oool0oooo0080oooo0`0000050?ooo`<00000103oool509d0o``0oooo1@00
00070?ooo`0509T0n@0_0780;`1b02l0LP1W0?T00`0I07800`1VIVH00P1b0080LP0200@0n@8001Ab
00@002ci000[LP00:g8002]b1@00GOT2001HLP0306IVIP00^o800;_b00L00;_b2@00`?T00`1VIVH0
0<3i0030n@020030n@8001Im00@002ci000_O@00;gd002mm2`00GOT0101VIVH005gi001Mn@00GOT9
002;lP0503H0n@0208H00P260080QP040?T00`0068H2000/n@0306IVIP00Fo<005_c00<005_c00<0
0000001Kl`00Fo<03000Fo<6002;l`<00P2?00@0103i000IS`006Hl001V?0P00:o<G001Kl`@0oooo
00<00`2G00@0n@040?T010006YL00`00;?T005_c001Kl`0C001Kl`H008_c0P3oool4000LWP8002ci
1000>ih2001Mn@03001KWP00Ro<008_c01D008_c103oool5000nY@03001Mn@00GZD005jU00<005jU
2P00SoT>002ll`80oooo0P00@:/2001Mn@@006:[0P00SoT20024ZaL00;cc0`3oool4001U/08008oi
1@00R;0A0030n@H00>cc1P3oool5002<]@800<3i0P00/;DG003/l`D0oooo00<008nj0030n@00`?T0
1@00];XD003an0T0oooo1@00^;h2003an003002nWP00ll/00??;01D00??;2@3oool50032X@P00?S?
4P00liX60?ooo`040035Y000n<l00?S?003hc`@00<Em2@00liX5003hW@`00?=Z103oool40038O`<0
0?RM1P00b5L5003cJPh00?Q/``3oool000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0303oool01@000000oooo0?ooo`3oool00000
01L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`<0W@3o403oool50000
00<0oooo00<0AP1b09T0n@0_07800P0_07801@1W0?T06@1b01T0LP1VIVH0=P3i00800P1b0P040?T2
000DLP04000/n@00:g8002]b000[LPD005gi00<005Qb06IVIP00^o803P00^o840030n@0306IVIP00
`?T00<3i00800<3i0P005Wd01000;?T002mm000_O@00;gd:001Mn@0306IVIP00GOT005gi00H005gi
1@00Ro801@0f0?T00P260080QP0208H0103i00<001R600<002_c001Kl`1VIVH01@00Fo<00`000000
05_c001Kl`0>001Kl`030?ooo`0f0?T0=P3i00<00P2?0P040?T2000IS`8002_c6000Fo<30?ooo`80
0`2G0P040?T4000JU`H002ci4`00Fo<50?ooo`@001bN0P00;?T4000kWP8005_c00<005^N002;l`00
Ro<05@00Ro<30?ooo`03000/n@00?ZD003jU00<003jU00<005gi001NY@00GZD00`00GZD>002?n@T0
0;cc0`3oool20010Z`8005gi1000HZ/2002?n@030024Z`00_?<00;cc01D00;cc0`3oool5001U/080
08oi1@00R;0D0030n@T0oooo1@00S;D20030n@800;2e5`00k?<40?ooo`8008nj0P00`?T5002d^Q@0
0?7h203oool6002h_P800?7h5`00ll/:0?ooo`D00<:Q3@00n<l<003cVPH0oooo0P00aJ@3003hc`<0
0<Em3P00liX6003hW@H00?=Z103oool50038O`<00?RM1@00b5L;003cJPT00?Q/``3oool000@0oooo
100000040?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02`3oool5000001D0oooo
100000080?ooo`030000003oool0oooo00D0oooo0P00000N0?ooo`030000003oool0oooo00D0oooo
00<0AP1b09T0n@0_07800P0_07801@1W0?T06@1b01T0LP1VIVH0=P3i00800P1b0P040?T2000DLP04
000/n@00:g8002]b000[LPD005gi00<005Qb06IVIP00^o804@00^o800`1VIVH00<3i0030n@030030
n@8001Im00@002ci000_O@00;gd002mm2P00GOT00`1VIVH005gi001Mn@09001Mn@807@2600D0=P3i
0080QP0208H00P2600@0n@02000HQP8002_c00<0IVIV000[l`00:o<00`00:o<00`00Fo<00000001K
l`0?001Kl`0301l0S`0f0?T0=P3i00<00P2?0P040?T2000IS`P002_c4@00Fo<40?ooo`800`2G0P04
0?T4000JU`X002ci3P00Fo<60?ooo`@001bN0P00;?T3000kWP<005_c5`00Ro<30?ooo`03000MY@00
;?T003jU00@003jU00<005gi001NY@00GZD00P00GZDC002?n@D00;cc0P3oool30010Z`8005gi1000
HZ/2002?nAL00;cc103oool5001U/08008oi1@00R;05002ll`l00<3i1`3oool2002?n@D008be0P00
`?T00`00/;D00>cc003/l`0E003/l`@0oooo0`00SkX20030n@D00;Bj5000lOP90?ooo`D00;Rn1`00
lOPB003cb`L0oooo00<00;c2003an000lOP01@00`Z4B003hc`H00?>J1P3oool30035Y0<00?S?0`00
aGdB003cVP@00?RM1`3oool60038O`<00?RM1000b5LA003cJP@00?Q/``3oool000X0oooo0`00000H
0?ooo`800000:@3oool2000000H0oooo0`0000060?ooo`040000003oool0oooo000001`0oooo00<0
00000?ooo`3oool01@3oool204H0LP0909T0n@0_0780;`1b02l0LP1W0?T06@1b06IVIP0I0780=P3i
00800P1b00D0103i000DLP00578001Ab000/n@03000[LPD005gi00<005Qb06IVIP00^o804@00^o80
0`1VIVH00;_b002klP02002klP<001Im00@002ci000_O@00;gd002mm2@00GOT00`1VIVH005gi001M
n@0:001Mn@807@26100208H00`040?T001R6000HQP02000[l`0306IVIP00:o<002_c00@002_c00@0
0000000[l`00:o<002_c3000Fo<0103oool07`2?03H0n@0f0?T30080S`80103i00<001V?000[l`00
:o<03000:o<<001Kl`<0oooo0`0309L200@0n@<001ZG3`00;?T:001Kl`H0oooo100079h2000/n@<0
03^N0P00Fo<H002;l`80oooo0P007JD00`00;?T003jU000nY@03000nY@03001Mn@00GZD005jU0080
05jU1P00Ro<?002?n@@0oooo1000@:/2001Mn@@006:[1`00SoTB002ll`@0oooo1@00IK02002?n@@0
08R`2`00_?<:0030n@H0oooo00<006Re002?n@00SoT01@00S;D20030nAL00>cc103oool4002?^P80
0<3i1@00];XD003an0T0oooo1@00^;h<003an0`00??;1`3oool2002l`P800?7h1@00`Z4D003hc`T0
oooo1000aJ@3003hc`800<Em5`00liX80?ooo`D00<Qo0`00n9d30038EaH00?=Z``3oool00540oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo
0P1607801`2I0?T0;`1b02l0LP0_0780I`3i01T0LP1VIVH00P0f0?T20080LP0500@0n@00578001Ab
000DLP00;?T00`00:g85001Mn@0306IVIP00^o800;_b01000;_b00<0IVIV002klP00^o800`00^o83
000FO@04000/n@00;gd002mm000_O@T005gi00<0IVIV001Mn@00GOT02P00GOT201d0QP@00P2600D0
103i000HQP00:o<002_c06IVIP07000[l`0300000000:o<002_c00L002_c1P00Fo<201l0S`80=P3i
0`0208l200@0n@03000IS`00:o<002_c014002_c1P00Fo<40?ooo`<00`2G0P040?T3000JU`H002_c
3@00;?T5001Kl`H0oooo00<0103i000LWP0079h00P0079h2000/n@8003^N2@00Fo<A002;l`<0oooo
0P007JD00`00;?T003jU000nY@03000nY@04001Mn@00GZD005jU001NY@`008_c2P00SoT30?ooo`D0
042[0P00GOT4001RZ``008oi3000_?<50?ooo`D006F`0P00SoT30028/1400;cc1@00`?T50?ooo`80
06Re0P00SoT5002<]@L00<3i4P00k?<30?ooo`D008nj0P00`?T5002d^Q@00?7h2@3oool5002h_Q40
0?7h1P00ll/70?ooo`<00;c20P00lOP50032X@D00??;3`00n<l80?ooo`D00<FT0`00n<l00`00aGd0
0?>J003cVP0F003cVPP0oooo1@00b7l3003hW@800<QG5`00lf[30?ooo`00=`3oool3000000040?oo
o`000000000000000080oooo0`0000000`3oool000000000000200000080oooo0P0000020?ooo`@0
00000`3oool3000000030?ooo`000000oooo00@000001@3oool00`000000oooo0?ooo`040?ooo`<0
c`3o4P3oool00`000000oooo0?ooo`050?ooo`<0AP1b00P0V@3i02l0LP0_0780;`1b06L0n@1VIVH0
6@1b03H0n@<00P1b00D0103i000DLP00578001Ab000/n@03000[LPD005gi00<0IVIV002klP00^o80
4000^o800`1VIVH00;_b002klP03002klP<001Im00@002ci000_O@00;gd002mm2000GOT00`1VIVH0
05gi001Mn@0;001Mn@807@26100208H01@040?T001R6000[l`00:o<0IVIV00L002_c00<00000000[
l`00:o<02P00:o<30?ooo`807`2?0P0f0?T30080S`80103i5`00:o<70?ooo`<00`2G0P040?T2000J
U``002_c2`00;?T70?ooo`0300<0WP040?T001bN00<001bN0P00;?T2000kWPh005_c3000Ro<20?oo
o`<001fU00<002ci000nY@00?ZD00`00?ZD01000GOT005jU001NY@00GZDA002;l`D008oi0`3oool5
0010Z`8005gi1000HZ/A002?n@H00;cc103oool2001Mn@D006F`0P00SoT30028/1H00;cc103oool3
001X]@8008oi1@00S;D5002ll`L00<3i3000k?<40?ooo`D008nj0P00`?T5002d^PD00>cc3`00lOP6
0?ooo`<00<3i1@00^;hD003an0X0oooo0`00_<82003an0@00<:Q2`00ll/:003hc`L0oooo1P00aJ@3
003hcaP00?>J2@3oool50038O`<00?RM00<00<QG003cJP00lfX05@00lf[40?ooo`00>03oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00@0oooo0`0000040?ooo`D0c`3o4@3oool00`00
0000oooo0?ooo`050?ooo`<0AP1b00P0V@3i02l0LP0_0780;`1b06L0n@1VIVH06@1b03H0n@<00P1b
00D0103i000DLP00578001Ab000/n@03000[LP@005gi00<0IVIV002klP00^o804000^o800`1VIVH0
0;_b002klP03002klP0400@0n@005Wd001Im000FO@@002mm2000GOT00`1VIVH005gi001Mn@0;001M
n@807@26100208H010040?T002_c000[l`1VIVH8000[l`0300000000:o<002_c00X002_c0P3oool3
01l0S`80=P3i0`0208l00`040?T002_c000[l`0F000[l`L0oooo0`0309L200@0n@8001ZG4@00:o<6
000/n@L0oooo00<00`2N00@0n@0079h00`0079h2000/n@03000kWP00Fo<005_c018005_c1P00Ro<2
0?ooo`@001fU00<002ci000nY@00?ZD00`00?ZD00`00GOT005jU001NY@0G002;l`<0oooo1@00@:/2
001Mn@@006:[5000SoT60?ooo`030012/000GOT005gi00D006F`0P00SoT20028/1L00;cc0`3oool4
001X]@8008oi1000S;D;002ll`L00<3i1P00k?<50?ooo`D008nj0P00`?T4002d^P/00>cc2P00lOP5
0?ooo`04002B_P00`?T00<3i0030n@D00;Rn5000lOP90?ooo`@00;c20P00lOP30032XA400??;1@00
n<l80?ooo`D00<FT1`00n<lC003cVPL0oooo0`00n<l50038O`<00?>J5`00lf[50?ooo`00>03oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool7
0<l0oa00oooo00<000000?ooo`3oool01@3oool304H0LP0809T0n@0_0780;`1b02l0LP1W0?T0IVIV
01T0LP0f0?T30080LP0500@0n@00578001Ab000DLP00;?T00`00:g84001Mn@0306IVIP00GOT005gi
00<005gi3@00^o800`1VIVH00;_b002klP03002klP0400@0n@005Wd001Im000FO@@002mm1`00GOT0
0`1VIVH005gi001Mn@0<001Mn@807@26100208H3000[l`0306IVIP00:o<002_c00D002_c00<00000
000[l`00:o<02P00:o<30?ooo`<07`2?0P0f0?T30080S`L0103i4@00:o<60?ooo`80=P3i0`0309L2
00@0n@03000JU`00:o<002_c01D002_c1`3oool200<0WP0300@0n@0079h001bN008001bN0P00;?TG
001Kl`D0oooo1@007JD00`00;?T003jU000nY@02000nY@8005gi0P00GZDG002;l`<0oooo1@00@:/2
001Mn@@006:[1@00S?<?002?n@D0oooo0P00@[02001Mn@D006F`0P00SoT00`00R;000;cc002ll`0E
002ll`<0oooo1@00J;D2002?n@<008be4@00_?<50030n@P0oooo1@00SkX20030n@<00;Bj4@00k?<5
003an0@0oooo0P00T[h30030n@D00;Rn5000lOP80?ooo`D00;c20P00lOP30032XAH00??;203oool5
0035Y0/00?S?3P00liX70?ooo`040038Y`00n<l00?S?003hc`@00<Qo2@00liXB003cJ/D0oooo000h
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool40000
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo1`3?0?l?
0?ooo`030000003oool0oooo00H0oooo0`1607801@2I0?T0;`1b02l0LP0_0780IVIV00806@1b00D0
=P3i0080LP0207800P1b00@0n@02000DLP8002ci0`00:g83001Mn@0306IVIP00GOT005gi00X005gi
1`00^o800`1VIVH00;_b002klP02002klP80103i0`005Wd4000_O@L005gi00<0IVIV001Mn@00GOT0
3000GOT201d0QP@00P260P040?T0101VIVH0103i00@0n@040?T5000[l`0300000000:o<002_c00X0
02_c0`3oool301l0S`80=P3i0`0208l<00@0n@`002_c1@3oool00`0Q09L0=P3i03H0n@0300<0U`80
103i00<001ZG000[l`00:o<05@00:o<70?ooo`800`2N00<0103i000LWP0079h00P0079h7000/nA40
05_c1P3oool5000MY@03000/n@00?ZD003jU008003jU0P00Fo<00`00GZD008_c002;l`0E002;l`80
oooo0P00;?T50010Z`8005gi0`00HZ/;002<l`X008oi1@3oool20012/08005gi1@00IK02002?nAL0
0;cc103oool5001X]@8008oi0`00S;DF002ll`H0oooo0P00SoT5002?^P800<3i0`00];XF003/l`@0
oooo0P00T[h30030n@D00;Rn5000lOP70?ooo`H00;c20P00lOP20032XAL00??;203oool50035Y0l0
0?S?2@00liX70?ooo`800<RW0`00n<l30038O`l00?>J3000lf[60?ooo`00>03oool500000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0
oooo0?ooo`0000000P3oool70<l0o`/0oooo0P0000020?ooo`030000003oool0oooo00D0oooo00@0
bP3i04H0LP160780AP1b100_0780101VIVH06@1b01T0LP0f0?T30080LP0300@0n@00578001Ab0080
02ci0`00:g83001Mn@0306IVIP00GOT005gi00l005gi00<06`1m06IVIP00^o801000^o8200@0n@<0
01Im1000;gd6001Mn@0306IVIP00GOT005gi00d005gi00<07@2603H0n@0208H00`0208H200@0n@03
06IVIP040?T0103i00H0103i00<00000000[l`00:o<02@00:o<40?ooo`<07`2?0P0f0?T30080Sa40
103i1P00:o<60?ooo`030240U`0f0?T0=P3i00<00`2G0P040?TG000[l`L0oooo0`0309h00`040?T0
01bN000LWP02000LWP`002ci3000Fo<60?ooo`D001fU00@002ci000nY@00?ZD003jU0`00Fo<H002;
l`040?ooo`007Z/002ci000/n@D0042[0P00GOT2001RZa4008cc1@00SoT40?ooo`<004:`0P00GOT5
001U/0L008oi4P00_?<40?ooo`D006Re0P00SoT2002<]AL00;cc1@3oool00`00JkX008oi002?n@05
002?^P800<3i0P00];XG003/l`<0oooo0`00T[h30030n@D00;Rn5000lOP80?ooo`D00;c20P00lOP0
0`00`Z400??;003cb`0E003cb`H0oooo0`00k?@50035Y1<00?S?1000liX70?ooo`<00<RW0`00n<l3
0038Oa@00?>J1P00lf[70?ooo`00>03oool01P000000oooo0?ooo`3oool000000?ooo`8000000P3o
ool2000000030?ooo`000000oooo00<00000103oool3000000030?ooo`000000oooo00@000000`3o
ool00`000000oooo00000002000000050?ooo`00000000000000003oool00`0000020?ooo`D0c`3o
3P3oool4000000H0oooo00@0bP3i04H0LP160780AP1b0`0_07801@1VIVH0I`3i01T0LP0I0780=P3i
00<00P1b00<0103i000DLP0057800P00;?T2000[LP<005gi00<0IVIV001Mn@00GOT04000GOT00`0K
07d0IVIV01/0O@0203H0n@800P1m0P040?T3000FO@@002mm1P00GOT00`1VIVH005gi001Mn@0=001M
n@0301d0QP0f0?T00P2600800P260P040?T00`1VIVH0103i00@0n@0700@0n@03000000040?T0103i
00<0103i1P00:o<20?ooo`80I`3i0`0O08l203H0n@<00P2?5@040?T70?ooo`808@2G0P0f0?T300<0
U`0300@0n@00:o<002_c01H002_c1P3oool400<0WP0300@0n@0079h001bN008001bN1P00:o<;000/
n@H005_c1`3oool5000MY@04000/n@00?ZD003jU000nY@T005_c4@00Ro<00`3oool001j[000NZ`02
000/n@D0042[0P00GOT2001RZaH008cc0`3oool40012/08005gi1@00IK0<002?n@`00;cc1@3oool5
001X]@8008oi00<008be002ll`00_?<05@00_?<50?ooo`8006^j0P00SoT5002?^P800<3i00<00;Bj
003/l`00k?<05@00k?<30?ooo`@009:n0`00`?T5002h_Q@00?7h203oool5002l`P800?7h5`00ll/6
0?ooo`@00>cd1@00aJ@5003cb`l00?S?2@3oool40038Y`<00?S?0P00b7lG003cV//0oooo000h0?oo
o`050000003oool0oooo0?ooo`000000;P3oool30<l0oa00oooo00<000000?ooo`3oool00P000003
0?ooo`0505d0LP3:0?T0AP1b04H0LP2I0?T00`0_07801@1VIVH06@1b01T0LP0I0780=P3i00<00P1b
00<0103i000DLP0057800P00;?T2000[LP<005gi00<0IVIV001Mn@00GOT04000GOT00`1VIVH06`1m
01/0O@0203H0n@800P1m00<0103i000FO@005Wd00P005Wd4000_O@H005gi00<0IVIV001Mn@00GOT0
3@00GOT00`0M08H0=P3i0080QP020080QP80103c00<0IVIV00@0l`040?<01`040?T00`000000103i
00@0n@0700@0n@@0oooo0P1W0?T301l0S`80=P3i0`0208lE00@0n@L0oooo0P0Q09L203H0n@<00`2G
1`040?TA000[l`L0oooo100309h010040?T001bN000LWP0079h<000[l`X002ci203oool00`040?T0
01fU000MY@03000MY@03000/n@00?ZD003jU00l005_c3000Ro<00`3oool001j[000NZ`02000/n@D0
042[0P00GOT00`00HZ/008cc002<l`0E002<l`<0oooo1000@[02001Mn@D006F`4@00SoT6002ll`@0
oooo0P00GOT5001X]@8008oi5`00_?<60?ooo`8006^j0P00SoT5002?^P800;cc5`00k?<30?ooo`D0
09:n0`00`?T5002h_PD00>cc3`00lOP80?ooo`D00;c21`00lOPB003cb`D0oooo1@00k?@40035Y0/0
0??;2P00n<l80?ooo`D00<RW0`00n<l00`00b7l00?>J003cVP0E003cV/`0oooo000g0?ooo`<00000
00@0oooo0000000000000000?`3oool00`000000oooo0?ooo`060?ooo`0505d0LP3:0?T0AP1b04H0
LP2I0?T00P0_07800`1VIVH0I`3i01T0LP0201T0LP0503H0n@0207800P1b0080LP040?T00P005780
1000;?T002]b000[LP00:g83001Mn@0306IVIP00GOT005gi010005gi00@0IVIV01/0O@0K07d0=P3i
0`0207d00`040?T001Im000FO@02000FO@@002mm1@00GOT00`1VIVH005gi001Mn@0>001Mn@0401d0
QP0f0?T00P260080QP80103c00<0IVIV00@0l`040?<01@040?<300@0n@03000000040?T0103i00L0
103i0`3oool00`0k08l0I`3i06L0n@0301l0S`80=P3i0`0208lE00@0n@H0oooo0`0Q09L203H0n@<0
0`2G30040?T<000[l`L0oooo100309h010040?T001bN000LWP0079hA000[l`D002ci1`3oool00`03
0:D0103i000MY@04000MY@03000/n@00?ZD003jU01@005_c1P00Ro<0103oool001j[000NZ`007Z/2
000/n@D0042[0P00Fo<G002<l`@0oooo1000@[02001Mn@D006F`1000S?<@002?n@H0oooo00<004Be
001Mn@00GOT01@00J;D7002?nA800;cc1@3oool3001[^P8008oi1000SkX8002lla800>cc0`3oool5
002B_P<00<3i1000^;h;003/l`X00?7h1@3oool30030n@D00;c23000lOP<003cb`H0oooo1@00k?@3
0035Y1400??;1@00n<l70?ooo`H00<RW0`00n<lG003cV/d0oooo001m0?ooo`030000003oool0oooo
00D0oooo0P1M0780103:0?T0AP1b04H0LP2I0?T202l0LP0306IVIP1W0?T06@1b00806@1b00<0=P3i
0080LP0207800P040?T2000DLP04000/n@00:g8002]b000[LP8005gi00<0IVIV001Mn@00GOT04000
GOT01@1VIVH06`1m01/0O@0K07d0=P3i00<00P1m00D0103i000FO@005Wd001Im000/n@04000_O@D0
05gi00<0IVIV001Mn@00GOT03P00GOT0100M08H0=P3i0080QP0208H200@0l`0306IVIP040?<0103c
00P0103c00<0000000@0n@040?T01`040?T30?ooo`0303/0S`1W0?T0I`3i00<07`2?0P0f0?T20080
SaH0103i1@3oool40240U`80=P3i0`0309LA00@0n@H002_c203oool400<0WP0300@0n@0079h001bN
01L002_c1P3oool200<0Y@0300@0n@007JD001fU00<001fU00<002ci000nY@00Fo<05P00Fo<40?oo
o`@001j[0P00;?T40010Z`8005_c6000S?<40?ooo`@004:`0P00GOT4001U/0T008cc3000SoT50?oo
o`8004Be0P00GOT5001X]@`008oi3000_?<50?ooo`@006^j0P00SoT3002?^Ph00;cc3000k?<40?oo
o`D009:n0`00`?T3002h_Q400>cc1@00lOP40?ooo`04002F`P00`?T00<3i0030n@D00;c24@00lOP6
003cb`H0oooo1P00k?@30035Y1H00??;203oool50038Y`P00?S?4@00li[>0?ooo`00@@3oool30000
0080oooo0P0000020?ooo`<000000`3oool4000000@0oooo0`0000040?ooo`<0000000<0oooo0000
003oool00P3oool30?l0oA<0oooo00<000000?ooo`3oool01@3oool205d0LP080<X0n@160780AP1b
09T0n@0_0780IVIV02l0LP1W0?T301T0LP0303H0n@0207800P1b0080103i0P0057801000;?T002]b
000[LP00:g82001Mn@0306IVIP00GOT005gi010005gi00D0IVIV01/0O@0K07d06`1m03H0n@030080
O@0500@0n@005Wd001Im000FO@00;?T00`00;gd5001Mn@0306IVIP00GOT005gi00l005gi00<07@26
03H0n@0208H00P040?<00`1VIVH0103c00@0l`0900@0l`03000000040?<0103c0080103c1@040?T2
0?ooo`80>`2?0P1W0?T301l0S`80=P3i0P0208l600@0la00103i1@3oool40240U`80=P3i0`0309LE
00@0n@P0oooo0P0f0?T400<0WP0300@0n@0079h001bN01L002_c1P3oool200<0Y@0300@0n@007JD0
01fU00<001fU00<002ci001Kl`00Fo<05P00Fo<40?ooo`@001j[0P00;?T30010Z`T005_c4@00S?<3
0?ooo`8002ci1000@[02001Mn@<006F`3P00S?<8002?n@D0oooo0P00A;D2001Mn@D006Re4@00SoT6
002ll`D0oooo1@00JkX2002?n@<008nj4`00_?<6003/l`D0oooo1@00T[h30030n@<00;Rn5P00k?<3
0?ooo`8009K20`00`?T5002l`P@00>cc4000lOP80?ooo`L00>cd0P00aJ@G003cb`P0oooo1@00b:L=
003hc`/00?>Jc`3oool00480oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo1@3o0?dA0?ooo`030000003oool0oooo00D0
oooo0`1M0780203:0?T0AP1b04H0LP2I0?T0;`1b06IVIP0_0780I`3i0`0I07800`0f0?T00P1b0080
LP0200@0n@8001Ab00H002ci000[LP00:g8002]b001Mn@1VIVHB001Mn@0306IVIP00GOT06`1m0080
6`1m00D0=P3i0080O@0207d00P1m00@0n@03000FO@04000/n@00;gd002mm000_O@D005_b00<0IVIV
001Mn@00GOT03`00GOT00`0M08H0=P3i0080QP0200@0l`0306IVIP040?<0103c00T0103c00<00000
00@0l`040?<01P040?<30?ooo`80>`2?0P1W0?T301l0S`80=P3i0P0208l;00@0l`/0103i1@3oool4
0240U`80=P3i0`0309LE00@0n@L0oooo00<08P2N03H0n@0f0?T0100309h00`040?T001bN000[l`0F
000[l`H0oooo0`030:D00`040?T001fU000MY@03000MY@L002ci4@00Fo<50?ooo`@001j[0P00;?T3
0010Z`h005_c3000S?<20?ooo`03000O/000;?T002ci00@004:`0P00GOT3001U/18008cc1000SoT4
0?ooo`<004Be0P00GOT5001X]A@008oi203oool5001[^P8008oi0P00SkXG002ll`H0oooo0P00SoT5
002B_P<00<3i0P00^;hG003/l`<0oooo0P00U/830030n@@00;c22@00k?<<003an0L0oooo2000k?@0
0`00aJ@00??;003cb`0E003cb`T0oooo1@00b:LB003hc`D00?>Jd03oool00480oooo00@000000?oo
o`3oool000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0oA00oooo
00<000000?ooo`3oool01@3oool305d0LP080<X0n@160780AP1b09T0n@0_0780IVIV02l0LP1W0?T2
01T0LP80=P3i0P0207801@040?T001Ab000DLP00578002ci00<002]b00<005gi06IVIP00GOT04@00
GOT00`1VIVH005gi01/0O@0201/0O@0503H0n@0207d00P1m0080O@040?T00`005Wd00`00;?T002mm
000_O@05001KlP0306IVIP00Fo8005_b00@005_b3000GOT01@0M08H0=P3i00@0l`040?<0IVIV00`0
103c00<0000000@0l`040?<01P040?<20?ooo`<0>`2?0P1W0?T301l0S`80=P3i00<00P2?00@0l`04
0?<03`040?<600@0n@D0oooo100Q09L203H0n@<00`2G5@040?T60?ooo`808P2N0P0f0?T400<0WP03
00@0n@00:o<002_c01D002_c1P3oool400<0Y@0300@0n@007JD001fU008001fU3@00;?T<001Kl`D0
oooo10007Z/2000/n@80042[5000Fo<6002<l`<0oooo00<001n`000/n@00;?T01000@[02001Mn@80
06F`5`00S?<30?ooo`@004Be0P00GOT5001X]A@008oi203oool5001[^P8008oi00<008nj002ll`00
_?<05@00_?<60?ooo`03001]_P00SoT008oi00D009:n0`00`?T00`00^;h00>cc003/l`0E003/l`<0
oooo0`00U/830030n@<00;c23P00k?<8003an0`0oooo0`00k?@G003cb`L0oooo0`00k?@50038Ya@0
0?S?d`3oool00480oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`D000000`3oool400000080oooo1`3o0?d?0?ooo`030000003oool0oooo00H0
oooo0`1M07801@3:0?T0AP1b04H0LP2I0?T0IVIV0080;`1b00<0I`3i01T0LP0I07800P0f0?T20080
LP0500@0n@00578001Ab000DLP00;?T00`00:g800`1VIVH005gi001Mn@0@001Mn@0306IVIP00GOT0
05gi00<06`1m00D0=P3i0080O@0207d00P1m00@0n@03000FO@03000/n@00;gd002mm00D005_b00<0
IVIV001KlP00Fo802P00Fo86001Mn@0501d0QP040?<0103c00@0l`1VIVH030040?<00`000000103c
00@0l`0600@0l`80oooo0`0k08l206L0n@<07`2?0P0f0?T00`0208l0103c00@0l`0D00@0l`D0oooo
00<0I`3i0240U`0Q09L00P0Q09L203H0n@<00`2G5@040?T60?ooo`808P2N0P0f0?T400<0WPH0103i
4P00:o<60?ooo`@00`2U00<0103i000MY@007JD00P007JD6000[l``002ci1P00Fo<40?ooo`80103i
10007Z/2000/n@030010Z`00Fo<005_c01D005_c1P3oool2000O/08002ci1000@[02001Mn@03001U
/000S?<008cc01H008cc0P3oool50014]@8005gi1@00J;DD002?n@P0oooo1@00JkX2002?nAL00;cc
1P3oool2001]_P8008oi1@00T[h30030nAL00>cc0`3oool4002F`P<00<3i0`00_<8B003/l`@00?7h
4@3oool3003/m1800??;1P3oool4003/m0D00<RW5000n<oC0?ooo`00@P3oool2000000D0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo00L0o`3m3`3oool00`000000oooo0?ooo`060?ooo`<0
G@1b0`1607801@2I0?T0IVIV02l0LP0_0780I`3i00806@1b0P0f0?T20080LP0500@0n@00578001Ab
000DLP00;?T00`00:g800`1VIVH005gi001Mn@0@001Mn@0306IVIP00GOT005gi00<06`1m00D0=P3i
0080O@0207d00P1m00@0n@03000FO@03000/n@00;gd005_b00@005_b00<0IVIV001KlP00Fo804000
Fo8201d0QP80=P3i00<0IVIV03H0n@0f0?T02`040?<2000000H0103c0`3oool303/0S`80I`3i0`0O
08l203H0nAL0103c103oool00`0n09L0I`3i0240U`030240U`80=P3i0`0309L500@0la00103i1@3o
ool30280WP80=P3i100309h;00@0n@`002_c1`3oool400<0Y@0400@0n@007JD001fU000MY@`002_c
2P00;?T60?ooo`0300<0Z`040?T0103i00@001j[0P00;?TG001Kl`L0oooo0P007k02000/n@@004:`
0P00GOTH002<l`<0oooo1@00A;D2001Mn@D006Re5000SoT60?ooo`8005gi1@00JkX7002?nA800;cc
1P3oool2001]_P8008oi1@00T[h80030nA800>cc0P3oool5002F`P<00<3i0P00_<8G003/laH0oooo
0`00k?@<003cb`H0oooo1@00k?@50038Y`D00??;3`00n<oC0?ooo`00@P3oool00`000000oooo0000
00050?ooo`<000000`3oool00`000000oooo00000002000000<0oooo0`0000030?ooo`@00000103o
ool50?l0o@`0oooo100000080?ooo`040?@0l@1M0780G@1b05d0LP<0AP1b00D0IVIV02l0LP0_0780
;`1b06L0n@0201T0LP80=P3i0P0207801@040?T001Ab000DLP00578002ci008002]b00<0IVIV001M
n@00GOT04000GOT0101VIVH005gi001Mn@00GOT201/0O@80=P3i0`0207d01P040?T001Im000FO@00
5Wd002ci000_O@D005_b00<0IVIV001KlP00Fo804000Fo8201d0QP80=P3i00<0IVIV03H0n@0f0?T0
100f0?T700@0l`04000000040?<00000000000@0103c00<0oooo09T0n@2I0?T00`0k08l206L0n@<0
7`2?0P0f0?TG00@0l`<0oooo0P0n09L00`1W0?T08@2G0240U`020240U`80=P3i0P0309L;00@0l`/0
103i103oool40280WP80=P3i100309h@00@0n@H002_c203oool400<0Y@0300@0n@007JD001fU0180
02_c1@00;?T60?ooo`0300<0Z`040?T0103i00@001j[1`00;?TB001Kl`H0oooo0`007k02000/n@@0
04:`1P00Fo<2001MnA4008cc103oool50014]@8005gi1@00J;D5002<l`l008oi1@3oool00`00A[X0
05gi001Mn@05001[^P`008oi3000_?<60?ooo`<006fn0P00SoT5002B_PD00;cc2000`?T<003/l`<0
oooo1@00U/830030n@03002l`P00k?<00>cc01D00>cc1@3oool00`00V<D00<3i0030n@020030nAD0
oooo1P00ll/60?ooo`H00>cd1000b:L;003cb`X00?S?d`3oool00480oooo00@000000?ooo`3oool0
00008@3oool30?l0oA00oooo1@0000030?ooo`80m03a0`1M078304H0LP0506IVIP0_0780;`1b02l0
LP1W0?T00P0I07801@0f0?T00P1b0080LP020780103i00<001Ab00@002ci000[LP00:g80IVIV4P00
GOT0101VIVH005gi001Mn@00GOT201/0O@80=P3i0P0207d200@0n@<001Im00<002ci001KlP00Fo80
0`00Fo800`1VIVH005_b001KlP0@001KlP<07@2600<0=P3i06IVIP0f0?T02`0f0?T200@0l`030000
00040?<0103c00@0103c0P3oool209T0n@<0>`2?0P1W0?T301l0S`0303H0n@040?<0103c01D0103c
103oool203h0U`0306L0n@0Q09L08@2G00808@2G0P0f0?T00`0309L0103c00@0l`0?00@0l`H0103i
103oool40280WP80=P3i100309hD00@0n@P0oooo0P0f0?T400<0Y@0300@0n@007JD001fU01L002_c
1@3oool200<0Z`80103i10007Z/<000/n@`005_c1P3oool4000O/08002ci0`00@[0<001Kl`8005gi
3000S?<40?ooo`D004Be0P00GOT4001X]@/008cc2P00SoT40?ooo`8004Jj0P00GOT5001[^Q4008oi
1P00_?<60?ooo`@006fn0P00SoT4002B_P/00;cc2000`?T6003/l`@0oooo1@00U/830030nAL00>cc
1@3oool2002Ha@T00<3i6`3oool7003/m0<00<RW4@00ll/5003hcm<0oooo00110?ooo`<0000000<0
oooo0000000000001@3oool3000002/0oooo00<000000?ooo`3oool01@3oool20?@0l@80G@1b00D0
bP3i04H0LP160780IVIV09T0n@0302l0LP0406L0n@0I07806@1b03H0n@<00P1b00<0103i000DLP00
57800P00;?T00`00:g80IVIV000[LP0B001Mn@0406IVIP00GOT005gi001Mn@806`1m0P0f0?T20080
O@80103b0`005Wd6001KlP0306IVIP00Fo8005_b010005_b0`0M08H00`0f0?T0IVIV03H0n@0=03H0
n@030000000f0?T0103c00@0103c00@0oooo05P0S`2I0?T0V@3i0`0k08l206L0n@<07`2?1`0f0?TA
00@0l`<0oooo0`0n09L00`1W0?T08@2G0240U`020240U`80=P3i00<00`2G00@0l`040?<050040?<5
0?ooo`@08P2N0P0f0?T400<0WQ@0103i1`3oool00`0T0:D0=P3i03H0n@0400<0Y@0300@0n@007JD0
02_c01L002_c1@3oool200<0Z`80103i10007Z/A000/n@H005_c1`3oool4000O/08002ci0P00@[0B
001Kl`8005gi1P00S?<30?ooo`8002ci1@00A;D2001Mn@<006Re4@00S?<5002?n@@0oooo0P00A[X2
001Mn@D006^j5000SoT80?ooo`D006fn0P00SoT3002B_Q400;cc1@00`?T80?ooo`D009K22000`?TA
003/l`D0oooo0`00V<D>0030nAD0oooo2000k?@20038YaL00??;d`3oool004l0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`050?ooo`<0m03a0P1M0780103:0?T0AP1b04H0LP1VIVH4
02l0LP0406L0n@0I07806@1b03H0n@<00P1b00<0103i000DLP0057800P00;?T00`00:g80IVIV001M
n@0A001Mn@0306IVIP00GOT005gi008005gi0P0K07d203H0n@800P1m0P040?83000FO@D002ci00<0
IVIV001KlP00Fo804000Fo8401d0QP0306IVIP0f0?T0=P3i00d0=P3i00<0000003H0n@0f0?T00P0f
0?T30?ooo`0305P0S`2I0?T0V@3i00<0>`2?0P1W0?T201l0S`d0=P3i2`040?<30?ooo`@0?P2G00<0
I`3i0240U`0Q09L00P0Q09L203H0nAL0103c1@3oool40280WP80=P3i100309hD00@0n@L0oooo00<0
902U03H0n@0f0?T010030:D00`040?T002_c000[l`0F000[l`D0oooo0`030:/200@0n@@001j[5@00
;?T90?ooo`@001n`0P00;?T20012/1L005_c1@3oool00`008;D002ci000/n@050014]@8005gi0`00
J;DF002<l`<0oooo0`00A[X2001Mn@D006^j1@00S?<?002?n@P0oooo1@00KKh2002?n@<009:n5P00
_?<60?ooo`8008oi1@00U/8=0030n@/00>cc1P3oool3002HaA<00<3i3`3oool9003/m0030038Y`00
ll/00??;01D00??;e03oool004l0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`05
0?ooo`<0m03a0P1M0780103:0?T0AP1b06IVIP16078302l0LP0506L0n@0I07806@1b01T0LP0f0?T0
0`0207800`040?T001Ab000DLP02000/n@03000[LP1VIVH005gi014005gi00<0IVIV001Mn@00GOT0
0P00GOT201/0O@80=P3i00@00P1m00@0lP040?80103b0`005Wd5000/n@0306IVIP00;?T002ci00<0
02ci3@00Fo8401d0QP0306IVIP0f0?T0=P3i00d0=P3i00<0000003H0n@0f0?T00P0f0?T20?ooo`80
F02?0P2I0?T303/0S`80I`3i0P0O08l503@0l`d0=P3i1P040?<30?ooo`@0?P2G00<0I`3i0240U`0Q
09L00P0Q09L00`0f0?T0103c00@0l`0E00@0l`D0oooo00<0I`3i0280WP0R09h00P0R09h203H0n@<0
0`2N5@040?T60?ooo`80902U0P0f0?T400<0Y@D0103i4`00:o<50?ooo`@00`2[0P040?T4000NZ`H0
02_c3`00;?T90?ooo`@001n`0P00;?T00`00@[0005_c001Kl`0F001Kl`D0oooo00<0022e000/n@00
;?T01@00A;D2001Kl`8006Re5`00S?<20?ooo`@004Jj0P00GOT4001[^P/008cc2P00SoT80?ooo`D0
06fn0P00SoT2002B_QL00;cc1@3oool00`00Kl8008oi002?n@05002F`Q800<3i1@00k?<60?ooo`@0
09S54`00`?TD0?ooo`@00>cd5`00ll_E0?ooo`009`3oool4000000D0oooo0`0000030?ooo`@00000
1@3oool3000000<0oooo0`000000103oool000000?ooo`3oool4000000<0oooo0`0000000`3oool0
00000?ooo`06000000@0oooo0`3o0<XB0?ooo`030000003oool0oooo00D0oooo103d0?4205d0LP04
0<X0n@160780IVIV09T0n@<0;`1b00D0I`3i01T0LP0I07806@1b03H0n@030080LP0300@0n@005780
01Ab008002ci00<0IVIV000[LP00GOT04000GOT00`1VIVH005gi001Mn@02001Mn@0306L0n@0K07d0
6`1m0080=P3i00<00P1m00@0lP040?8010005Wd4000/n@0306IVIP00;?T002ci00X002ci1P00Fo80
1@1W0?T07@2601d0QP0M08H0IVIV0100=P3i00<0000003H0n@0f0?T00P0f0?T20?ooo`80F02?0P2I
0?T303/0S`80I`3i0P0O08l903@0l`d0=P3i1@3oool403h0U`0406L0n@0Q09L08@2G0240U`L0=P3i
4@040?<50?ooo`030480WP1W0?T08P2N00<08P2N0P0f0?T300<0WPH0103c3`040?T60?ooo`80902U
0P0f0?T400<0Y@T0103i3`00:o<50?ooo`@00`2[0P040?T3000NZ``002_c2P00;?T70?ooo`80103i
10007k02000/nAP005_c1@3oool2000P]@8002ci1000A;D3001Kl`03001X]@00S?<008cc01D008cc
0P3oool50016^P8005gi0`00JkXA002<l`D008oi203oool5001]_P8008oi00<009:n002ll`00_?<0
5@00_?<50?ooo`8006o20P00SoT5002F`Q@00<3i203oool5002HaA<00<3i6@3oool4003/m1400??;
eP3oool002P0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool0103oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`040?ooo`D0o`3:4@3oool00`000000oooo0?ooo`090?ooo`80G@1b00@0
bP3i04H0LP1VIVH0V@3i0`0_07801@1W0?T06@1b01T0LP0I0780=P3i00<00P1b00<0103i000DLP00
57800P00;?T00`1VIVH002]b001Mn@0@001Mn@0306IVIP00GOT005gi008005gi00<0I`3i01/0O@0K
07d00P0f0?T300@0lP@001Im1000;?T00`1VIVH002ci000/n@0>000/n@80>02600D0I`3i01d0QP0M
08H07@2606IVIP0@03H0n@030000000f0?T0=P3i0080=P3i00@0oooo05P0S`1H08l0F02?0P2I0?T3
03/0S`80I`3i00<07`2?03@0l`0d0?<0300d0?<903H0n@D0oooo100n09L0101W0?T08@2G0240U`0Q
09L603D0l`H0=P3i30040?<50?ooo`030480WP1W0?T08P2N00<08P2N0P0f0?T200<0WP`0103c2P04
0?T50?ooo`<0902U0P0f0?T400<0Y@d0103i2P00:o<60?ooo`@00`2[0P040?T2000NZa8002_c1@00
;?T60?ooo`0300<0/0040?T0103i00@001n`1`00;?TB001Kl`H0oooo0P008;D2000/n@<004Be1000
Fo<G002<l`<0oooo1@00A[X2001Mn@<006^j5P00S?<60?ooo`8005gi1@00KKh2002?nAL00;cc1@3o
ool3001_`P8008oi1@00U/85002ll`l00<3i1`3oool6002HaA<00<3i7P3oool4003/m0/00??;e`3o
ool002P0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00<0oooo1`3o0<X?0?ooo`030000003oool0oooo00X0oooo0P1M0780103:
0?T0IVIV04H0LP2I0?T302l0LP0506L0n@0I07806@1b01T0LP0f0?T00`0207801@040?T001Ab000D
LP00;?T0IVIV008002]b4000GOT00`1VIVH005gi001Mn@03001Mn@<06`1m0P0f0?T300@0lP@001Im
0`00;?T00`1VIVH002ci000/n@0?000/n@80>02600@0I`3i01d0QP0M08H0IVIV1P0d0?<:03H0n@03
0000000f0?T0=P3i00<0=P3i00@0oooo05P0S`1H08l0F02?0P2I0?T303/0S`80I`3i00<07`2?03@0
l`0d0?<0400d0?<503H0n@<0oooo0P2I0?T403h0U`0306L0n@0Q09L08@2G00`0=@3c1P0f0?T600@0
l`D0oooo0P1209h00`1W0?T08P2N0280WP020280WP80=P3i00<00`2N00@0l`040?<040040?<500@0
n@@0oooo100T0:D203H0n@@00`2U4@040?T5000[l`L0oooo10030:/200@0n@8001j[5`00:o<50?oo
o`800`2`0P040?T4000O/0`002ci3000Fo<60?ooo`<0022e0P00;?T30014]@T005_c4P00S?<30?oo
o`D004Jj0P00GOT2001[^QL008cc1@3oool00`00Akh005gi001Mn@05001]_PL008oi4P00_?<40?oo
o`@006o20P00SoT4002F`P/00;cc2P00`?T80?ooo`D009S54`00`?T<0?ooo`03002Kb000`?T00<3i
00<00<3i5@3oool5003cbmP0oooo000X0?ooo`@000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo100000040?ooo`030000003o
ool0oooo00<0oooo1`3o0<X?0?ooo`030000003oool0oooo00T0oooo0`1M0780103:0?T0IVIV04H0
LP2I0?T302l0LP0506L0n@0I07806@1b01T0LP0f0?T00P02078200@0n@8001Ab00@002ci06IVIP00
:g8002]b4000GOT00`1VIVH005gi001Mn@03001Mn@<06`1m00<0=P3i00@0lP040?800P040?84000F
O@<002ci00<0IVIV000/n@00;?T03`00;?T203P0QP0406L0n@0M08H07@2606IVIP/0=03c1@0f0?T0
0`000000=P3i03H0n@0303H0n@040?ooo`1H08l0F02?05P0S`80V@3i0`0k08l206L0nAL0=03c103o
ool209T0n@@0?P2G00<0I`3i0240U`0Q09L04@0e0?<503H0n@L0oooo0P1209h00`1W0?T08P2N0280
WP020280WP80=P3i00<00`2N00@0l`040?<05@040?<40?ooo`@0902U0P0f0?T400<0YA@0103i1`3o
ool203H0n@@00`2[0P040?T00`007Z/002_c000[l`0F000[l`D0oooo0P030;0200@0n@@001n`4@00
;?T6001Kl`H0oooo10008;D2000/n@8004Be3`00Fo<<002<l`@0oooo1@00A[X2001Mn@03001[^P00
S?<008cc01D008cc1@3oool20017_P8005gi1@00KKh<002?n@`00;cc103oool5001_`P8008oi0`00
U/8A002ll`D00<3i203oool5002HaA<00<3i2`3oool2002Kb0X00<3ik@3oool002P0oooo00<00000
0?ooo`3oool00P0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo1`3o0<X?0?ooo`030000003oool0oooo00D0oooo103i0<D305d0LP0406IVIP160780AP1b09T0
n@<0;`1b00D0I`3i01T0LP0I07806@1b03H0n@020080LP80103b0P005780101VIVH002]b000[LP00
:g8?001Mn@0306IVIP00GOT005gi00@005gi0`0K07d503H0n@@001Im0P00;?T00`1VIVH002ci000/
n@0@000/n@80>02600<0I`3i01d0QP1VIVH04@0d0?<00`000000=P3i03H0n@0303H0n@040?ooo`1H
08l0F02?05P0S`80V@3i0`0k08l206L0nAL0=03c0`3oool00`1M09L0V@3i09T0n@0403h0U`0306L0
n@0Q09L0=@3c01H0=@3c1P3oool30480WP0306L0n@0R09h08P2N00808P2N0P0f0?TH00@0l`@0oooo
100T0:D203H0n@@00`2U50040?T60?ooo`0302D0Z`0f0?T0=P3i00@00`2[0P040?TH000[l`D0oooo
0`030;0200@0n@@001n`1@00:o<?000/n@T0oooo10008;D2000/n@030014]@00Fo<005_c01<005_c
1P00S?<30?ooo`8002ci1@00A[X2001MnAL008cc1@3oool30017_P8005gi1@00KKh5002<l``008oi
1P00_?<40?ooo`H006o20P00SoT2002F`QL00;cc203oool5002HaA<00<3i2P3oool3002Kb0l00<3i
j03oool002P0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool00`000000oooo
0000000200000080oooo1@0000000`3oool00000000000020?ooo`8000000`3oool3000000030?oo
o`000000oooo00@000001@3oool00`000000oooo0?ooo`040?ooo`D0o`3:303oool4000000P0oooo
103i0<D305d0LP0406IVIP160780AP1b09T0n@<0;`1b00<0I`3i01T0LP0I07800P0f0?T20080LP05
00@0lP00578001Ab000DLP1VIVH00`00:g8?001Mn@0306IVIP00GOT005gi00@005gi0`0K07d503H0
n@<001Im0`00;?T00`1VIVH002ci000/n@0@000/n@0503P0QP1W0?T0I`3i01d0QP1VIVH04@0d0?<0
0`000000=03c03@0l`0203@0l`80bP3i0`1H08l209T0n@<0>`2?00<0I`3i03@0l`0d0?<05@0d0?<4
0?ooo`0305d0U`2I0?T0V@3i00@0?P2G00<0I`3i0240U`0e0?<05P0e0?<50?ooo`@0@P2N00<0I`3i
0280WP0R09h00P0R09h00`0f0?T0103c00@0l`0F00@0l`D0oooo100T0:D203H0n@<00`2U5@040?T6
0?ooo`0302D0Z`0f0?T0=P3i00@00`2[1`040?TB000[l`D0oooo10030;0200@0n@<001n`2`00:o<:
000/n@T0oooo10008;D2000/nAL005_c1`3oool00`008KX002ci000/n@050016^PD005_c0P00GOTB
002<l`@0oooo1000Akh2001Mn@@006fn2`00S?<:002?n@P0oooo1@00Kl82002?n@03002F`P00_?<0
0;cc01H00;cc1@3oool3002?n@D009S54`00`?T90?ooo`@009_84`00`?WT0?ooo`00:03oool00`00
0000oooo0?ooo`0200000140oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?oo
o`<0o`3:403oool5000000<0oooo00<0LP1K0?T0a@3i0<D00P3i0<D205d0LP0506IVIP3:0?T0AP1b
04H0LP2I0?T00`0_07800`1W0?T06@1b01T0LP0203H0n@030080LP040?80103b008001Ab00<0IVIV
000/n@00:g800P00:g8>001Mn@0306IVIP00GOT005gi00D005gi0`0K07d503H0n@<001Im0P00:o80
101VIVH002_b000[lP00:o8@000/n@0403P0QP1W0?T0I`3i06IVIQ80=03c00<0000003@0l`0d0?<0
0P0d0?<20<X0n@<0F02?0P2I0?T303/0S`H0I`3i4@0d0?<40?ooo`80G@2G0P2I0?T403h0U`0306L0
n@0e0?<0=@3c01D0=@3c1P3oool40480WP0306L0n@0R09h08P2N00808P2N1P0f0?TC00@0l`<0oooo
0P1W0?T402@0Y@80=P3i0`030:D600@0l`l0103i1@3oool202D0Z`80=P3i10030:/<00@0n@`002_c
1@3oool500<0/080103i0P007k0A000[l`D002ci2@3oool4000P]@L002ci4P00Fo<60?ooo`80026j
0P00;?T40016^P/005_c0P00GOT<002<l`@0oooo1@00Akh2001Mn@<006fn4@00S?<5002?n@P0oooo
1@00Kl82002?nAP00;cc1@3oool01000LLD008oi002?n@00SoT5002Ha@D00;cc3P00`?T80?ooo`D0
09_84`00`?WT0?ooo`009`3oool500000180oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo00H0oooo00<0LP1K0?T0a@3i0<D00P3i0<D205d0LP0506IV
IP160780AP1b04H0LP2I0?T00`0_07800`1W0?T06@1b01T0LP0203H0n@030080LP040?80103b0080
01Ab00<0IVIV000/n@00:g800P00:g8>001Mn@0306IVIP00GOT005gi00D005gi0`0K07d503H0n@80
01Im0`00:o800`1VIVH002_b000[lP06000[lP/002ci00@0>02606L0n@1W0?T0IVIV4P0d0?<01@00
0000=03c03@0l`0d0?<0M02?0080bP3i0`1H08l209T0n@<0>`2?2`1W0?T<03@0l`@0oooo0P1M09L2
09T0n@@0?P2G600e0?<60?ooo`@0@P2N00@0I`3i0280WP0R09h08P2N2`0f0?T>00@0l`<0oooo00<0
A02U06L0n@1W0?T0100T0:D203H0n@800`2U30040?<:00@0n@D0oooo0P0U0:/203H0n@@00`2[4@04
0?T6000[l`H0oooo1@030;0200@0n@8001n`5P00:o<70?ooo`80103i10008;D<000/n@`005_c1P3o
ool3000Q^P8002ci0`00A[XA001Kl`8005gi1P00S?<50?ooo`D004Nn0P00GOT3001]_QH008cc1@3o
ool00`00B<8005gi001Mn@05001_`PL008oi4P00_?<50?ooo`8007750`00SoT4002Ha@/00;cc2@00
`?T70?ooo`H009_84`00`?WT0?ooo`00F@3oool3000001T0oooo00<000000?ooo`3oool01@3oool2
0780F`@0n@350P1M07801@1VIVH0AP1b04H0LP160780V@3i00<0;`1b00<0I`3i01T0LP0I07800P0f
0?T300@0lP04000DLP1VIVH001Ab000/n@<002]b3@00GOT00`1VIVH005gi001Mn@06001Mn@<06`1m
1@0f0?T2000FO@8002_b00<0IVIV000[lP00:o803000:o86000/n@0303P0QP1W0?T0IVIV01<0=03c
00D0000003@0l`0d0?<0=03c07@0S`020<X0n@<0F02?00<0V@3i03/0S`0k08l00P0k08l@06L0n@H0
=03c103oool305d0U`80V@3i100n09L606L0nA40=@3c1`3oool40480WP0406L0n@0R09h08P2N0280
WPH0=@3c2@0f0?T:00@0l`80oooo0P140:D206L0n@@0902U0P0f0?T00`030:D0103c00@0l`0@00@0
l`D0103i103oool302D0Z`80=P3i10030:/D00@0n@T0oooo1@030;0200@0n@03000O/000:o<002_c
01D002_c1P3oool00`030;D0103i00@0n@04000P]A4002ci1P00Fo<60?ooo`@0026j0P00;?T30016
^QH005_c203oool50017_P8005gi0P00KKhG002<l`@0oooo0P00B<82001Mn@D006o23000SoT<002l
l`D0oooo0`00LLD3002?n@<009S54@00_?<40030n@P0oooo1@00VlPC0030nN@0oooo001d0?ooo`03
0000003oool0oooo00H0oooo0P1b05/40?T0a@0305d0LP1VIVH0bP3i00<0AP1b00D0V@3i02l0LP0_
0780;`1b06L0n@0201T0LP80=P3i0`040?8010005780IVIV000DLP00;?T3000[LPd005gi00<0IVIV
001Mn@00GOT01P00GOT301/0O@D0=P3i00D001Im000[lP00:o8002_b06IVIP0C000[lP80>02600<0
I`3i06IVIP1W0?T0101W0?T>03@0l`030000000d0?<0=03c0080M02?0P3:0?T305P0S`0309T0n@0k
08l0>`2?0080>`2?5@1W0?T50?ooo`<0G@2G0P2I0?T403h0U`/0I`3i300e0?<50?ooo`80V@3i1012
09h00`1W0?T08P2N0280WP0<03D0l`P0=P3i1@040?<30?ooo`80A02U0P1W0?T402@0Y@80=P3i00<0
0`2U00@0l`040?<05@040?<30?ooo`@09@2[0P0f0?T400<0Za@0103i2@3oool500<0/080103i5`00
:o<60?ooo`800`2e0P040?T4000P]@D002_c3`00;?T80?ooo`D0026j0P00;?T20016^QL005_c203o
ool50017_P8005gi00<006fn002<l`00S?<05@00S?<40?ooo`<004S20P00GOT5001_`PD008cc3000
SoT6002ll`D0oooo1000LLD3002?n@8009S55P00_?<80?ooo`D009_84`00`?WT0?ooo`00<P3oool4
000000D0oooo0`0000030?ooo`H000000P3oool3000000030?ooo`0000000000008000000P3oool2
00000080oooo0`0000000`3oool000000?ooo`020?ooo`<0o`2H4P3oool00`000000oooo0?ooo`05
0?ooo`<0LP1K103i0<D00`1M0780IVIV0<X0n@0304H0LP0309T0n@0_0780;`1b0080I`3i0P0I0780
0`0f0?T0103b00@0lP0200@0lP04000DLP1VIVH002ci000/n@8002]b3@00GOT00`1VIVH005gi001M
n@07001Mn@<06`1m1@0f0?T010005Wd002_b000[lP1VIVHD000[lP80>02600<0IVIV06L0n@1W0?T0
2@1W0?T903@0l`030000000d0?<0=03c0080M02?0P3:0?T305P0S`0309T0n@0k08l0>`2?0080>`2?
5@1W0?T50?ooo`<0G@2G0P2I0?T403h0Ua00I`3i1P0e0?<50?ooo`030640WP2I0?T0V@3i00@0@P2N
00<0I`3i0280WP0R09h04@0e0?<503H0n@D0oooo0`140:D206L0n@@0902U0P0f0?TH00@0l`<0oooo
100U0:/203H0n@@00`2[50040?T70?ooo`80=P3i1@030;0700@0nA4002_c1P3oool300<0]@80103i
0`008;D;000[l`X002ci2@3oool4000Q^P8002ci00<004Jj001Kl`00Fo<05@00Fo<70?ooo`8002ci
1@00Akh2001MnAL008cc1@3oool30018`P8005gi1000Kl8;002<l`T008oi203oool5001aa@<008oi
00<009S5002ll`00_?<05@00_?<80?ooo`D009_84`00`?WT0?ooo`00<`3oool00`000000oooo0?oo
o`040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`D0o`2H403oool00`000000oooo0?ooo`060?ooo`<0LP1K103i0<D0
0`1VIVH0G@1b0<X0n@0304H0LP<0;`1b0P1W0?T201T0LPD0=P3i00@0IVIV000DLP00;?T002ci0P00
:g86001Jl@L005gi00<0IVIV001Mn@00GOT01`00GOT301/0O@D0=P3i0`00:o800`1VIVH002_b000[
lP0B000[lP80>02600<0IVIV06L0n@1W0?T03P1W0?T403@0l`030000000d0?<0M02?0080M02?0P3:
0?T305P0S`0309T0n@0k08l0>`2?0080>`2?5@1W0?T50?ooo`<0G@2G0P2I0?T403h0Ua@0I`3i1P3o
ool20640WP80V@3i101209h00`1W0?T08P2N03D0l`0F03D0l`@0oooo10140:D206L0n@@0902U00<0
=P3i00@0l`040?<05P040?<40?ooo`@09@2[0P0f0?T400<0Za@0103i1P3oool00`0V0;00=P3i03H0
n@0500<0/0`0103i2`00:o<60?ooo`@00`2e0P040?T3000P]A0002_c1@00;?T90?ooo`@0026j0P00
;?TG001Kl`L0oooo00<0026n000/n@00;?T01@00Akh5001Kl`8005gi4P00S?<40?ooo`@004S20P00
GOT3001_`Q4008cc1000SoT80?ooo`D007750`00SoTG002ll`H0oooo0`00SoT5002Kb1<00<3ii03o
ool003<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0V0l0oooo00<000000?oo
o`3oool01P3oool30780F`@0n@3500<0IVIV05d0LP3:0?T00`16078302l0LP0406L0n@0I07806@1b
01T0LPD0=P3i00@0IVIV000DLP00;?T002ci0P00:g8;001Jl@8005gi00<0IVIV001Mn@00GOT01`00
GOT201/0O@D0=P3i1000:o800`1VIVH002_b000[lP0A000[lP80>02600<0IVIV06L0n@1W0?T04`1W
0?T00`000000oooo07@0S`0207@0S`80bP3i0`1H08l00`2I0?T0>`2?03/0S`0203/0SaD0I`3i0`3o
ool20<X0n@<0G@2G0P2I0?T403h0Ua@0I`3i1P3oool20640WP80V@3i101209h00`1W0?T08P2N03D0
l`0F03D0l`@0oooo10140:D206L0n@@0902U1P0f0?TB00@0l`<0oooo0P1W0?T402D0Z`80=P3i1003
0:/500@0l`l0103i1@3oool202H0/080=P3i1@030;0A00@0n@D002_c1P3oool500<0]@80103i0P00
8;DF000[l`T0oooo10008KX7000/nA8005_c1P3oool2000Q_P8002ci1000Akh;001Kl`8005gi3000
S?<40?ooo`D004S20P00GOT3001_`QD008cc203oool5001aa@P008oi4@00_?<60?ooo`04001cb000
SoT008oi002?n@D009_84`00`?WT0?ooo`00<`3oool4000000<0oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo1`3o09P?0?ooo`030000003oool0oooo
00H0oooo0`1b05/30?T0a@0406IVIP1M0780G@1b0<X0n@80AP1b00D0V@3i02l0LP0_0780;`1b06L0
n@0301T0LP@0=P3i00<0IVIV000DLP0057800P00;?T00`00:g8005[a001Jl@0;001Jl@0306IVIP00
F_4005[a008005[a1P00GOT201/0O@P0=P3i00<0IVIV03H0n@0f0?T04P00:o8203P0QP0306IVIP1W
0?T0I`3i01<0I`3i00<000000?ooo`1d08l00P1d08l20<X0n@80F02?0P2I0?T403/0SaD0I`3i0P3o
ool00`1k09L0bP3i0<X0n@0305d0U`80V@3i0`0n09LE06L0n@D0oooo0`1Q09h209T0n@@0@P2N00<0
I`3i03D0l`0e0?<05@0e0?<50?ooo`@0A02U0P1W0?T302@0Y@`0=P3i30040?<30?ooo`0304L0Z`1W
0?T0I`3i00@09@2[0P0f0?T300<0Z`/0103c2P040?T50?ooo`809P2`0P0f0?T500<0/1@0103i203o
ool500<0]@80103i0P008;DF000[l`H0oooo00<00`2j00@0n@040?T010008KX<000/n@`005_c1`3o
ool2000Q_P8002ci0`00AkhA001Kl`8005gi1P00S?<40?ooo`H004S20P00GOT2001_`QH008cc203o
ool5001aa@d008oi2`00_?<60?ooo`8007?80`00SoT5002Kb0D00;cc3P00`?WT0?ooo`00<`3oool0
0`000000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool01`3o09P;0?ooo`@000001`3oool20?T0U0<0LP1K0`3i0<D0101VIVH0G@1b
05d0LP3:0?T204H0LP0509T0n@0_0780;`1b02l0LP1W0?T00`0I078403H0n@0306IVIP00578001Ab
008002ci00<002]b001Jl@00F_402`00F_400`1VIVH005[a001Jl@07001Jl@0306L0n@0K07d06`1m
00P0=P3i00<0IVIV03H0n@0f0?T01@0f0?T<000[lP0409T0n@0h08H0IVIV03P0QQD0I`3i00<00000
0?T0m`1d08l00P1d08l20<X0n@80F02?0P2I0?T403/0SaD0I`3i0P3oool00`1k09L0bP3i0<X0n@03
05d0U`80V@3i0`0n09L506D0la00I`3i103oool40640WP80V@3i101209h606L0nA40=@3c1P3oool4
04@0Y@80I`3i0`0T0:D603D0l`/0=P3i1P040?<40?ooo`0304L0Z`1W0?T0I`3i00@09@2[0P0f0?T3
00<0Za00103c1@040?T40?ooo`<09P2`0P0f0?T500<0/1@0103i203oool500<0]@80103i00<0022e
000[l`00:o<05000:o<60?ooo`800`2j0P040?T4000Q^Q4002ci1P00Fo<70?ooo`<0026n0P00;?T3
0017_QH005_c1`3oool60018`P8005gi00<006o2002<l`00S?<05000S?<60?ooo`03001:a@00GOT0
05gi00D007754P00SoT5002ll`H0oooo0`00LlP3002?n@@009_82`00_?<90030nN@0oooo000c0?oo
o`050000003oool0oooo0?ooo`0000000`3oool3000000D0oooo00<000000?ooo`3oool00P3oool4
00000080oooo00<000000?ooo`0000000P0000040?ooo`@000000`3oool50?l0V0l0oooo1@000003
0?ooo`80n@2D0P1b05/30?T0a@0506IVIP1M0780G@1b05d0LP3:0?T00P1607801@2I0?T0;`1b02l0
LP0_0780I`3i00<06@1b0`0f0?T0101VIVH0=P3i000DLP005782000/n@d005[a00<0IVIV001Jl@00
F_402000F_400`1W0?T06`1m01/0O@0703H0n@0306IVIP0f0?T0=P3i00`0=P3i1P00:o80102I0?T0
>02606IVIP0h08HE06L0n@030000003i0?L0M02?0080M02?0P3:0?T205P0S`80V@3i100k08lE06L0
n@030?ooo`1k09L0N`2G0080bP3i0`1M09L209T0n@80?P2G2`1U0?<;06L0n@@0oooo101Q09h209T0
n@@0@P2N2`1W0?T<03D0l`@0oooo0P2I0?T404@0Y@80I`3i0P0T0:D<03D0l`X0=P3i1@3oool204L0
Z`80I`3i100U0:/203H0n@800`2[5P040?<30?ooo`@09P2`0P0f0?T500<0/1@0103i203oool500<0
]@80103i5P00:o<70?ooo`800`2j0P040?T4000Q^Q@002ci2@3oool4000Q_P8002ci0P00AkhG001K
l`L0oooo1P00B<82001MnAH008cc1P3oool2001:a@8005gi1@00LLD5002<l`l008oi203oool4001c
b0<008oi0`00VlPA002ll`@00<3ii03oool003<0oooo00<000000?ooo`3oool00P00000;0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool30?l0V0l0oooo00<000000?ooo`3o
ool01@3oool00`1b04@0n@2D0?T0U0020780F`<0n@3500D0IVIV05d0LP1M0780G@1b0<X0n@0204H0
LP0509T0n@0_0780;`1b02l0LP1W0?T00`0I078303H0n@0406IVIP0f0?T001Ab000DLP8002ci3@00
F_400`1VIVH005[a001Jl@08001Jl@0306L0n@0K07d06`1m00L0=P3i00<0IVIV03H0n@0f0?T0300f
0?T00`1]08H0bP3i0<X0n@030580QP0409T0n@1VIVH0>02603P0QQD0I`3i00<000000?T0m`1d08l0
0P1d08l20<X0n@80F02?0P2I0?T303/0SaH0I`3i00<0oooo07/0U`1k09L00P3:0?T305d0U`80V@3i
0P0n09L@06D0l`H0I`3i103oool40640WP80V@3i101209h@06L0n@H0=@3c1@3oool209T0n@@0A02U
0P1W0?T00`0T0:D0=@3c03D0l`0@03D0l`D0=P3i1@3oool204L0Z`80I`3i100U0:/203H0n@800`2[
5P040?<30?ooo`@09P2`0P0f0?T500<0/1@0103i1P3oool203H0n@D00`2e1`040?TA000[l`H0oooo
0`030;X200@0n@@0026j1@00:o<?000/n@P0oooo1@008Kh2000/n@030017_P00Fo<005_c01D005_c
203oool60018`PL005gi4@00S?<50?ooo`<004[50P00GOT4001aa@/008cc2P00SoT70?ooo`D007?8
0`00SoT3002Kb1D00;cci03oool00380oooo1@00000<0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`050?ooo`030780A03i09@0n@2D0080LP1K0`3i
0<D01@1VIVH0G@1b05d0LP1M0780bP3i0080AP1b00D0V@3i02l0LP0_0780;`1b06L0n@0301T0LP80
=P3i00<0IVIV03H0n@0057800P0057800`00;?T005[a001Jl@0;001Jl@0306IVIP00F_4005[a00P0
05[a0P1W0?T201/0O@H0=P3i00<0IVIV03H0n@0f0?T03@0f0?T00`1]08H0bP3i0<X0n@030580QP04
09T0n@1VIVH0>02603P0QQD0I`3i00<000000?T0m`1d08l00P1d08l20<X0n@80F02?0P2I0?T303/0
S`H0I@3c401W0?T307/0U`80bP3i0`1M09L209T0n@0303h0U`1U0?<0I@3c01@0I@3c1@3oool40640
WP80V@3i101209hD06L0n@H0oooo00<0I@2U09T0n@2I0?T010140:D206L0n@0302@0Y@0e0?<0=@3c
01D0=@3c103oool304L0Z`80I`3i100U0:/203H0n@0300<0Z`040?<0103c01@0103c103oool402H0
/080=P3i1@030;0D00@0n@D0oooo00<09`2e03H0n@0f0?T01@030;D<00@0n@/002_c1`3oool300<0
^P80103i0`008KX;000[l`X002ci203oool5000Q_P8002ci5`00Fo<70?ooo`8002ci1P00B<8<001M
n@/008cc1P3oool3001:a@8005gi0`00LLDA002<l`D008oi1P3oool6001cb0<008oi0P00VlPF002l
ln@0oooo00110?ooo`<000005@3oool2000001D0oooo00<000000?ooo`3oool01P3oool00`1b04@0
n@2D0?T0U0020780F`80n@3500<0IVIV0?T0a@1M07800P1M0780103:0?T0AP1b04H0LP2I0?T302l0
LP0306L0n@0I07806@1b00<0=P3i00<0IVIV03H0n@0057800P005786000/n@P005[a00<0IVIV001J
l@00F_402000F_4206L0n@806`1m1P0f0?T00`1VIVH0=P3i03H0n@0=03H0n@0306d0QP3:0?T0bP3i
00<0DP2600<0IVIV03P0QP0h08H05P1W0?T00`000000n@3g07@0S`0207@0S`80bP3i0P1H08l209T0
n@80>`2?301U0?<;06L0n@<0N`2G0P3:0?T305d0U`80V@3i00<0?P2G06D0l`1U0?<0501U0?<40?oo
o`030<X0n@1Q09h0H@2N0080H@2N0P2I0?T30480WQD0I`3i1P3oool00`1U0:D0V@3i09T0n@0404@0
Y@80I`3i600e0?<30?ooo`@0A`2[0P1W0?T402D0Z`80=P3i5`040?<40?ooo`@09P2`0P0f0?T500<0
/0D0103c3`040?T50?ooo`0302L0]@0f0?T0=P3i00D00`2e4@040?T5000[l`L0oooo10030;X200@0
n@80026j4@00:o<5000/n@P0oooo1@008Kh7000/nA8005_c1P3oool00`008/8002ci000/n@060018
`PD005_c3000GOT5002<l`H0oooo1000B/D2001Mn@8007755`00S?<70?ooo`D007?80`00SoT00`00
VlP00;cc002ll`0D002llnD0oooo000^0?ooo`<0000000@0oooo00000000000000000P3oool30000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000`0000030?ooo`<00000103oool30000
00D0oooo0`3o06DB0?ooo`030000003oool0oooo00D0oooo0P1b04@20?T0U080LP1K0P3i0<D00`1V
IVH0n@3505d0LP0205d0LP040<X0n@160780AP1b09T0n@<0;`1b00<0I`3i01T0LP0I07800`0f0?T0
0`1VIVH0=P3i000DLP02000DLPX002ci0`00F_400`1VIVH005[a001Jl@09001Jl@0406L0n@0K07d0
6`1m01/0O@D0=P3i00<0IVIV03H0n@0f0?T03P0f0?T00`1]08H0bP3i0<X0n@030580QP0306IVIP0h
08H0>02600H0I@3c401W0?T00`000000n@3g07@0S`0207@0S`040<X0n@1H08l0F02?05P0S`80V@3i
0P0k08lA06D0l`H0I`3i0`1k09L20<X0n@<0G@2G0P2I0?TF06D0l`@0oooo00<0P@2N0<X0n@1Q09h0
0`1Q09h209T0n@<0@P2N1@1U0?<@06L0n@D0oooo0P1U0:D209T0n@@0A02U00<0I`3i03D0l`0e0?<0
5P0e0?<40?ooo`@0A`2[0P1W0?T402D0Z`D0=@3c0P0f0?TA00@0l`<0oooo0P1W0?T402H0/080=P3i
10030;0;00@0l`X0103i103oool202L0]@80=P3i1@030;DD00@0n@P0oooo1@030;X200@0n@80026j
5P00:o<80?ooo`D0026n3000;?T<001Kl`H0oooo0P008/82000/n@D004S22`00Fo<9001Mn@P0oooo
1@00B/D2001Mn@03001aa@00S?<008cc01D008cc203oool5001cb0<008oi5P00_??V0?ooo`00;`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo1@3o06DA0?ooo`030000003o
ool0oooo00D0oooo0P1b04@20?T0U080LP1K00@0n@3506IVIP3i0<D0n@350`1M078304H0LP0509T0
n@0_0780;`1b02l0LP1W0?T00P0I078203H0n@0306IVIP0f0?T0=P3i00<001Ab3@00;?T00`1VIVH0
02ci001Jl@08001Jl@0303@0O@1W0?T06`1m00806`1m1@0f0?T00`1VIVH0=P3i03H0n@0=03H0n@80
K@260P3:0?T20580QP0406IVIP2I0?T0>02603P0QP/0I@3c2P1W0?T00`000000S`2>0?T0m`0307@0
S`040<X0n@1H08l0F02?05P0S`80V@3i00<0>`2?06D0l`1U0?<05@1U0?<0103oool0N`2G07/0U`1k
09L20<X0n@<0G@2G00<0V@3i06D0l`1U0?<05@1U0?<40?ooo`030840WP3:0?T0H@2N00<0H@2N0P2I
0?T20480WP/0I@3c2`1W0?T50?ooo`80I@2U0P2I0?T404@0Y@L0I`3i4@0e0?<50?ooo`@0A`2[0P1W
0?T302D0Z`/0=@3c0P0f0?T<00@0l`80oooo00<0B@2`06L0n@1W0?T0100V0;0203H0n@<00`2`4@04
0?<500@0n@@0oooo0P0W0;D203H0n@D00`2e50040?T80?ooo`D00`2j0P040?T00`008KX002_c000[
l`0E000[l`H0oooo0P040?T5000Q_Q4002ci1P00Fo<60?ooo`<002;20P00;?T40018`Q4005_c1000
GOT70?ooo`H004[50P00GOTG002<l`H0oooo00<004_8001Mn@00GOT01@00LlP5002<l`<008oi4@00
_??V0?ooo`00;`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool000000080oooo1`3o06D?0?ooo`030000003oool0oooo00H0oooo
0P1b04@20?T0U080LP1K00@0n@3506IVIP3i0<D0n@350P1M07801@3:0?T0AP1b04H0LP160780V@3i
00<0;`1b00<0I`3i01T0LP0I07800P0f0?T00`1VIVH0=P3i03H0n@03000DLP`002ci00<0IVIV000/
n@00;?T01000;?T5001Jl@0303@0O@1W0?T06`1m00806`1m100f0?T00`1VIVH0=P3i03H0n@0>03H0
n@80K@260P3:0?T20580QP0306IVIP2I0?T0>0260140I@3c1@1W0?T00`000000S`2>0?T0m`0307@0
S`040<X0n@1H08l0F02?05P0S`80V@3i00<0>`2?06D0l`1U0?<05@1U0?<0103d0?40N`2G07/0U`1k
09L20<X0n@<0G@2G1P2I0?TA06D0l`@0oooo0P2109h00`3:0?T0H@2N0640WP020640WP80V@3i0P12
09h@06D0l`H0I`3i103oool306D0Y@80V@3i10140:D<06L0n@`0=@3c1@3oool404L0Z`80I`3i0P0U
0:/A03D0l`80=P3i1P040?<20?ooo`80B@2`0P1W0?T402H0/080=P3i0P030;0G00@0l`<0oooo0`0W
0;D203H0n@D00`2e50040?T80?ooo`D00`2j0P040?TG000[l`H0oooo00<00`2n00@0n@040?T01@00
8Kh5000[l`h002ci2@3oool4000R`P8002ci0`00B<8F001Kl`P0oooo1@00B/D7001MnA4008cc1P3o
ool2001;b08005gi1000LlP;002<l`<008oi2`00_??W0?ooo`00;`3oool01@000000oooo0000003o
ool000000080oooo1@0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool70?l0I@l0oooo
00<000000?ooo`3oool01P3oool20780A0050?T0U01b05/0LP1K0780F`1VIVH00`3i0<D205d0LP05
0<X0n@160780AP1b04H0LP2I0?T00P0_078206L0n@806@1b00<0=P3i06IVIP0f0?T00P0f0?T3000D
LP`002ci00<0IVIV000/n@00;?T02000;?T203@0O@0406L0n@0K07d06`1m01/0O@@0=P3i00<0IVIV
03H0n@0f0?T03P0f0?T206d0QP80bP3i00D0DP2606IVIP2I0?T0V@3i03P0QP0F06D0l`030000002?
08h0n@3g00<0M02?00@0bP3i05P0S`1H08l0F02?0P2I0?TG06D0l`80m03a0`1k09L20<X0n@<0G@2G
2`2I0?T<06D0l`@0oooo0P2109h00`3:0?T0H@2N0640WP020640WP80V@3i00<0@P2N06D0l`1U0?<0
501U0?<50?ooo`<0I@2U0P2I0?T404@0YA40I`3i1P0e0?<50?ooo`0309T0n@170:/0A`2[0080A`2[
0P1W0?T202D0ZaH0=@3c1@3oool204T0/080I`3i100V0;0203H0n@0300<0/0040?<0103c01H0103c
0P3oool402L0]@80=P3i1@030;DD00@0n@P0oooo1@030;X700@0nA4002_c1P3oool200<0_P80103i
10008Kh;000[l`T002ci203oool5000R`P8002ci0P00B<8G001Kl`P0oooo1@00B/D<001Mn@/008cc
1P3oool3001;b08005gi0`00LlPA002<l`<008oi1@00_??X0?ooo`00;`3oool01@000000oooo0000
003oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`L0o`1U2`3oool2000000030?ooo`000000oooo00H0oooo0P3d0602
0780A0050?T0U01b05/0LP1K0780F`1VIVH00`3i0<D205d0LP050<X0n@160780AP1b04H0LP2I0?T0
0P0_078206L0n@806@1b00<0=P3i06IVIP0f0?T00P0f0?T2000DLP`002ci00<0IVIV000/n@00;?T0
2@00;?T203@0O@0406L0n@0K07d06`1m01/0O@<0=P3i00<0IVIV03H0n@0f0?T03`0f0?T206d0QP80
bP3i00@0DP2606IVIP2I0?T0V@3i5`1U0?<3000000<0M02?00D0bP3i05P0S`1H08l0F02?09T0n@0H
06D0l`80m03a0`1k09L20<X0n@<0G@2G402I0?T606D0l`@0oooo0`2109h00`3:0?T0H@2N0640WP02
0640WP80V@3i00<0@P2N06D0l`1U0?<0501U0?<50?ooo`<0I@2U0P2I0?T404@0YA@0I`3i1`3oool0
0`1Y0:/0V@3i04L0Z`0304L0Z`80I`3i00<09@2[03D0l`0e0?<05@0e0?<40?ooo`<0B@2`0P1W0?T4
02H0/080=P3i60040?<30?ooo`@09`2e0P0f0?T500<0]@D0103c3`040?T60?ooo`80=P3i1@030;X<
00@0n@/002_c1P3oool300<0_P80103i0`008KhA000[l`@002ci203oool5000R`P8002ci00<004S2
001Kl`00Fo<05@00Fo<60?ooo`<002ci1@00B/DA001Mn@D008cc1`3oool3001;b08005gi0`00LlPE
002<ln`0oooo000_0?ooo`80000000<0oooo0000000000000`3oool300000080oooo0`0000001@3o
ool00000000000000000oooo00<000001@3oool3000000@0oooo0`0000040?ooo`D0o`1U3P3oool4
000000D0oooo0P3d06020780A0040?T0U01b05/0LP1K06IVIP@0n@350P1M0780103:0?T0AP1b04H0
LP16078302l0LP80I`3i0P0I07800`1VIVH0=P3i03H0n@0203H0n@8001Ab3000;?T00`1VIVH002ci
000/n@09000/n@80=01m00@0I`3i01/0O@0K07d06`1m0`0f0?T00`1VIVH0=P3i03H0n@0?03H0n@80
K@260P3:0?T0101VIVH0DP2609T0n@2I0?TF06D0l`0406IVIP000000S`2>0?T0m`80000000<0M02?
0<X0n@1H08l00P1H08l709T0nA40I@3c0`3d0?4307/0U`80bP3i0`1M09LE09T0n@@0oooo102109h0
0`3:0?T0H@2N0640WP020640WP80V@3i5P1U0?<60?ooo`<0I@2U0P2I0?T404@0Y@D0I@3c3`1W0?T6
0?ooo`80J@2[00<0V@3i04L0Z`170:/00P170:/206L0nAL0=@3c103oool404T0/080I`3i100V0;05
03D0l`80=P3i4P040?<40?ooo`@09`2e0P0f0?T400<0]@/0103c2P040?T50?ooo`0302P0^P0f0?T0
=P3i00D00`2j4@040?T5000[l`H0oooo10030;h200@0n@<0026n5@00:o<80?ooo`D002;20P00;?TG
001Kl`H0oooo00@002?5000/n@00;?T002ci1@00B/D5001Kl`h005gi2@3oool4001;b08005gi0P00
LlPF002<ln`0oooo000_0?ooo`80000000<0oooo0000000000006P3oool2000000/0oooo0`3o06D?
0?ooo`040000003oool0oooo0?ooo`8000000P3oool30?@0H080LP1400@0n@2D0780F`1b05/0IVIV
103i0<D205d0LP040<X0n@160780AP1b04H0LP<0;`1b00D0I`3i01T0LP0I07806@1b06IVIP0403H0
n@8001Ab2`00;?T00`1VIVH002ci000/n@09000/n@80=01m0P1W0?T301/0O@80=P3i00<0IVIV03H0
n@0f0?T0400f0?T206d0QP80bP3i00<0IVIV0580QP2I0?T05`1U0?<0101VIVH0000008l0SP3i0?L3
07@0S`040<X0n@1H08l0F02?05P0S``0V@3i301U0?<30?@0l@<0N`2G0P3:0?T305d0UaD0V@3i103o
ool40840WP030<X0n@1Q09h0H@2N0080H@2N00<0V@3i06D0l`1U0?<05@1U0?<40?ooo`80bP3i0`1U
0:D209T0n@<0A02U2`1U0?<:06L0n@D0oooo0`1Y0:/00`2I0?T0A`2[04L0Z`0204L0Z`L0I`3i4@0e
0?<50?ooo`@0B@2`0P1W0?T302H0/0/0=@3c0P0f0?T<00@0l`<0oooo0P1W0?T402L0]@80=P3i0`03
0;DA00@0l`D0103i103oool202P0^P80=P3i1@030;XC00@0n@P0oooo1@030;h200@0n@80026n5P00
:o<80?ooo`D002;21`00;?TB001Kl`D0oooo0P008lD3000/n@@004[52`00Fo<9001Mn@P0oooo1@00
BlP2001Mn@03001cb000S?<008cc01@008cck@3oool002h0oooo0P0000030?ooo`8000006`3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo0`3d06000`1b04@0n@2D0?T0U002
0780F`0306IVIP3i0<D0n@350080n@350P1M0780103:0?T0AP1b04H0LP2I0?T302l0LP0406L0n@0I
07806@1b06IVIPD0=P3i0P00578;000/n@0306IVIP00;?T002ci00T002ci0P0d07d206L0n@<06`1m
0P0f0?T00`1VIVH0=P3i03H0n@0@03H0n@80K@2600@0bP3i06IVIP1B08H0DP261`2I0?T@06D0l`05
06IVIP2?08h0000008l0SP3i0?L00`1d08l0103:0?T0F02?05P0S`1H08lA09T0n@H0I@3c103d0?43
07/0U`80bP3i0`1M09LE09T0n@@0oooo102109h00`3:0?T0H@2N0640WP020640WPH0V@3i4@1U0?<4
0?ooo`0308H0Y@3:0?T0bP3i00<0I@2U0P2I0?T304@0YA00I@3c1@1W0?T40?ooo`@0J@2[00<0V@3i
04L0Z`170:/00P170:/<06L0n@`0=@3c1@3oool404T0/080I`3i0`0V0;0@03D0l`80=P3i1P040?<3
0?ooo`0304/0]@1W0?T0I`3i00@09`2e0P0f0?T300<0]AH0103c0`3oool302P0^P80=P3i1@030;XC
00@0n@P0oooo1@030;h200@0n@03000Q_P00:o<002_c01@002_c1`3oool200@0n@D002;23000;?T<
001Kl`H0oooo0P008lD3000/n@<004[54@00Fo<4001Mn@L0oooo1P00BlP2001MnAH008cckP3oool0
04H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00D0oooo0`3d06001@1b04@0n@2D0?T0U01b05/0IVIV00@0n@350`1M0780103:0?T0AP1b04H0LP2I
0?T302l0LP0406L0n@0I07806@1b06IVIPD0=P3i0P00578;000/n@0306IVIP00;?T002ci00T002ci
0P0d07d206L0n@<06`1m00<0=P3i06IVIP0f0?T04P0f0?T206d0QP040<X0n@1VIVH0DP260580QP`0
V@3i2`1U0?<01@1VIVH0S`2>0000002?08h0n@3g0080M02?0P3:0?T305P0SaD0V@3i1P3oool307/0
U`80bP3i0`1M09LE09T0n@80oooo0P3i0?L40840WP030<X0n@1Q09h0H@2N0080H@2N2`2I0?T<06D0
l`<0oooo0P260:D20<X0n@<0I@2U0P2I0?T204@0YAH0I@3c0`3oool506T0Z`0309T0n@170:/0A`2[
0080A`2[4@1W0?T603D0l`H0oooo10190;0206L0n@809P2`5P0e0?<60?ooo`0304/0]@1W0?T0I`3i
00@09`2e0P0f0?T200<0]AL0103c0P3oool402P0^P80=P3i1@030;XC00@0n@P0oooo1@030;h200@0
nAH002_c1`3oool00`030<80103i00@0n@05000R`Q4002ci1P00Fo<60?ooo`<002?50`00;?T2001:
aAH005_c1`3oool6001;b0T005gi3P00S??_0?ooo`00:`3oool5000000<0oooo0`0000000`3oool0
00000?ooo`0400000080oooo0P0000030?ooo`8000000P3oool3000000D0oooo00<000000?ooo`3o
ool0103oool30?l0<Q80oooo00<000000?ooo`3oool01@3oool40?@0H0050780A03i09@0n@2D0780
F`1VIVH0103i0<D305d0LP040<X0n@160780AP1b09T0n@<0;`1b00@0I`3i01T0LP1VIVH06@1b1@0f
0?T2000DLPX002ci00<0IVIV000/n@00;?T02P00;?T203@0O@80I`3i0`0K07d00`0f0?T0IVIV03H0
n@0B03H0n@80K@2600@0IVIV0580QP1B08H0DP264@2I0?T506D0l`0406IVIP2?08h0S`2>00000080
n@3g0P1d08l20<X0n@<0F02?5@2I0?T60?ooo`<0N`2G0P3:0?T205d0UaH0V@3i0P3oool20?T0m`@0
P@2N00<0bP3i0640WP1Q09h00P1Q09h@09T0n@H0I@3c103oool208H0Y@80bP3i0`1U0:D209T0n@80
A02U5P1U0?<30?ooo`D0J@2[00<0V@3i04L0Z`170:/00P170:/D06L0n@L0oooo0P2I0?T404T0/080
I`3i0P0V0;0F03D0l`D0oooo0P1;0;D206L0n@@09`2e0P0f0?T00`030;D0103c00@0l`0E00@0l`80
oooo1@0X0;X203H0n@D00`2j4`040?T80?ooo`D00`2n1`040?TA000[l`H0oooo0P030<8200@0n@D0
02;21`00:o<=000/n@P0oooo10008lD3000/n@03001:a@00Fo<005_c01D005_c1`3oool6001;b0l0
05gi1`00S??`0?ooo`00;@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`<00000103oool50?l0<Q40oooo00<000000?ooo`3oool02@3oool0
1@1b04@0n@2D0?T0U01VIVH0LP1K00@0n@350`1M0780103:0?T0AP1b04H0LP2I0?T302l0LP0406L0
n@0I0780IVIV01T0LPD0=P3i0P00578:000/n@0306IVIP00;?T002ci00X002ci0P0d07d206L0n@80
6`1m00<0=P3i06IVIP0f0?T04`0f0?T206d0QP0406IVIP1B08H0DP260580QQD0V@3i00D0S`1a06IV
IP2?08h0S`2>000000020?T0m`80M02?0P3:0?T305P0SaD0V@3i1P3oool307/0U`80bP3i0P1M09L6
09D0la00V@3i00@0oooo09h0W@3i0?L0n@3g102109h00`3:0?T0H@2N0640WP020640WQ@0V@3i1@3o
ool308H0Y@80bP3i0`1U0:D209T0n@0304@0Y@1U0?<0I@3c01@0I@3c103oool506T0Z`0309T0n@17
0:/0A`2[0080A`2[501W0?T60?ooo`0306`0/02I0?T0V@3i00@0B@2`0P1W0?T00`0V0;00=@3c03D0
l`0D03D0l`H0oooo0P1;0;D206L0n@@09`2e0P0f0?TG00@0l`<0oooo1@0X0;X203H0n@D00`2j1@04
0?<>00@0n@H0oooo0P0f0?T500<0_P`0103i2`00:o<70?ooo`800`320P040?T4000R`Pl002_c1P00
;?T70?ooo`D002?50`00;?TG001Kl`P0oooo1P00BlPC001MnO<0oooo000]0?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`050?ooo`030000003oool0000000<0oooo1`3o
038?0?ooo`030000003oool0oooo00X0oooo00D0LP140?T0U03i09@0IVIV0780F`040?T0a@<0G@1b
00@0bP3i04H0LP160780V@3i0`0_07800`1W0?T06@1b06IVIP0503H0n@<001Ab2@00;?T00`1VIVH0
02ci000/n@0;000/n@80=01m0P1W0?T201/0O@0303@0lP1VIVH0=03b00<0=03b400f0?T00`1]08H0
IVIV0<X0n@030580QQD0V@3i00D0IVIV0?T0a@2?08h0S`2>000000020?T0m`80M02?0P3:0?T305P0
SaD0V@3i103i0<D20?ooo`<0N`2G0P3:0?T00`1M09L0U@3c09D0l`0:09D0l`/0V@3i00@0oooo09h0
W@3i0?L0n@3g102109h00`3:0?T0H@2N0640WP020640WQ@0V@3i103oool408H0Y@80bP3i0`1U0:D2
09T0nAL0I@3c103oool506T0Z`0309T0n@170:/0A`2[0080A`2[501W0?T60?ooo`0306`0/02I0?T0
V@3i00@0B@2`0P1W0?TF03D0l`H0oooo0`1;0;D206L0n@@09`2e1@0e0?<203H0nA80103c0`3oool5
02P0^P80=P3i10030;X;00@0l`T0103i1@3oool00`0Y0;h0=P3i03H0n@0500<0_Q40103i1@00:o<7
0?ooo`<00`320P040?T3000R`QH002_c1`3oool5000Sa@P002ci4@00Fo<60?ooo`03000Sb000;?T0
02ci00H004_84`00GOWc0?ooo`00;@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`8000001@3oool500000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`L0o`0b3`3oool00`000000oooo0?ooo`090?ooo`80LP1400@0
n@2D06IVIP1b05/0LP1K103i0<D305d0LP040<X0n@160780AP1b09T0n@<0;`1b00<0I`3i06IVIP0I
07801@0f0?T3000DLPT002ci00<0IVIV000/n@00;?T02`00;?T203@0O@80I`3i00<06`1m03@0lP1V
IVH02P0d0?8;03H0n@0306d0QP1VIVH0bP3i00<0DP265@2I0?T01@1VIVH0n@3508l0SP2?08h00000
0080n@3g0P1d08l20<X0n@80F02?5P2I0?T60?T0a@<0N`2G0P3:0?T00`1M09L0U@3c09D0l`0?09D0
l`H0V@3i0P2N09d20?T0m`@0P@2N00<0bP3i0640WP1Q09h00P1Q09hD09T0n@@0oooo10260:D20<X0
n@<0I@2U1`2I0?TA06D0l`@0oooo00<0bP3i06T0Z`1Y0:/00`1Y0:/00`2I0?T0A`2[04L0Z`0204L0
Z`D0I@3c3`1W0?T50?ooo`80K02`0P2I0?T404T0/0T0I`3i3`0e0?<50?ooo`@0B`2e0P1W0?T302L0
]@/0=@3c0P0f0?T<00@0l`@0oooo1@0X0;X203H0n@<00`2j4@040?<400@0n@@0oooo0P0Y0;h203H0
n@D00`2n50040?T80?ooo`@00`320P040?T2000R`QL002_c1`3oool5000Sa@d002ci2`00Fo<60?oo
o`8002?80P00;?T5001;b0H005_c3P00GOWc0?ooo`00;@3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool70?l0<Ph0oooo00<000000?ooo`3oool01@3oool50?X0<@80LP1400@0n@2D06IVIP1b05/0LP1K
103i0<D305d0LP040<X0n@160780AP1b09T0n@<0;`1b00<0I`3i06IVIP0I07801@0f0?T3000DLPP0
02ci00<0IVIV000/n@00;?T03000;?T203@0O@80I`3i00<06`1m03@0lP1VIVH03`0d0?8603H0n@03
06IVIP3:0?T0bP3i00<0DP26502I0?T00`1VIVH0S`1a0?T0a@0208l0SP030000003i0?L0n@3g0080
M02?0P3:0?T205P0S`H0U@3c402I0?T60?T0a@<0N`2G0P3:0?TG09D0l`030?ooo`2N09d0WP2M0080
n@3g102109h00`3:0?T0H@2N0640WP020640WQ@0V@3i103oool408H0Y@80bP3i0`1U0:D<09T0n@`0
I@3c0`3oool00`2;0:/0bP3i06T0Z`0406T0Z`0409T0n@170:/0A`2[04L0Z`/0I@3c2P1W0?T50?oo
o`80K02`0P2I0?T404T0/100I`3i1`0e0?<60?ooo`@0B`2e0P1W0?T202L0]A40=@3c0P0f0?T600@0
l`<0oooo0P1W0?T502P0^P80=P3i0`030;XE00@0l`<0oooo0`0Y0;h203H0n@D00`2n50040?T70?oo
o`D00`320P040?T00`008/8002_c000[l`0E000[l`H0oooo0P040?T5000SaA8002ci1@00Fo<60?oo
o`<002?80P00;?T4001;b0`005_c2@00GOWc0?ooo`00:P3oool010000000oooo0?ooo`0000020?oo
o`<000000P3oool200000080oooo00<000000?ooo`0000000P0000020?ooo`030000003oool0oooo
008000000`3oool300000080oooo0`000000103oool000000000000000020?ooo`D0o`0b303oool3
0000000306IVIP3oool0oooo00D0oooo1@3j03420780A00406IVIP3i09@0LP1K0780F`@0n@350P1M
07801@3:0?T0AP1b04H0LP160780V@3i0080;`1b00@0I`3i06IVIP0I07806@1b1@0f0?T3000DLPP0
02ci00<0IVIV000/n@00;?T03000;?T203@0O@80I`3i00<0=03b06IVIP0d0?80500d0?80101]08H0
IVIV0<X0n@3:0?T30580QQ@0V@3i00<0IVIV08l0L@3i0<D00P2?08h00`000000n@3g0?T0m`0207@0
S`80bP3i00<0F02?09D0l`2E0?<02P2E0?<;09T0n@H0n@350`1k09L20<X0nAL0U@3c0`2N09d20?T0
m`@0P@2N00<0bP3i0640WP1Q09h00P1Q09hD09T0n@@0oooo10260:D20<X0n@<0I@2U4@2I0?T606D0
l`<0oooo0P2;0:/00`3:0?T0J@2[06T0Z`0306T0Z`0409T0n@170:/0A`2[04L0Za00I@3c1@1W0?T4
0?ooo`<0K02`0P2I0?T404T0/1@0I`3i2@3oool404/0]@80I`3i0P0W0;DF03D0l`D0oooo00<0C@2j
06L0n@1W0?T01@0X0;X203H0n@800`2j5P040?<20?ooo`@0:@2n0P0f0?T500<0_Q@0103i1`3oool5
00<0`P80103i5`00:o<60?ooo`0300<0a@040?T0103i00D002?51@00:o<>000/n@T0oooo10008lP2
000/n@<004_84P00Fo<4001MnO<0oooo000Z0?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0D0?ooo`<0o`0b403oool00`1VIVH0000000000002
00000080oooo00<0LP0F0?X0<@3j03400`3j03420780A00406IVIP1b05/0LP1K0780F`@0n@350P1M
07801@3:0?T0AP1b04H0LP160780V@3i0080;`1b00@0I`3i06IVIP0I07806@1b1@0f0?T3000DLPL0
02ci00<0IVIV000/n@00;?T03@00;?T203@0O@80I`3i00<0=03b06IVIP0d0?80500d0?80101VIVH0
K@260<X0n@3:0?T30580QQ<0V@3i00@0IVIV09T0n@2?0740n@350P2?08h00`000000n@3g07@0S`02
07@0S`80bP3i00<0F02?09D0l`2E0?<03`2E0?<609T0n@D0n@35101k09L00`3:0?T0U@3c09D0l`0E
09D0l`040?ooo`2N09d0WP2M09h0W@80n@3g102109h00`3:0?T0H@2N0640WP020640WQ@0V@3i0P3o
ool20?@0l@@0QP2U0P3:0?T306D0YA@0V@3i1P3oool208/0Z`030<X0n@1Y0:/0J@2[00<0J@2[00<0
V@3i04L0Z`170:/05P1U0?<30?ooo`@0K02`0P2I0?T404T0/1@0I`3i2@3oool404/0]@80I`3i00<0
9`2e03D0l`0e0?<05@0e0?<40?ooo`80C@2j0P1W0?T502P0^P80=P3i00<00`2j00@0l`040?<05004
0?<20?ooo`D0:@2n0P0f0?T500<0_Q@0103i1`3oool500<0`PL0103i4P00:o<50?ooo`800`350P04
0?T4000Sa@/002_c2@00;?T80?ooo`D002?80P00;?T2001;b1L005_cl`3oool002X0oooo1`00000?
0?ooo`030000003oool0oooo02L0oooo00<0IVIV0?ooo`3oool0103oool00`1b01H0nP0a0?X0<@03
0?X0<@80LP1400@0IVIV0780F`1b05/0LP1K103i0<D205d0LP050<X0n@160780AP1b04H0LP2I0?T0
0P0_0780101VIVH0I`3i01T0LP0I078503H0n@8001Ab2000;?T00`1VIVH002ci000/n@0=000/n@80
=01m00<0I`3i03@0lP1VIVH05@0d0?800`3i0<D0IVIV06d0QP020<X0n@80DP26502I0?T0101VIVH0
V@3i08l0L@3i0<D208l0SP030000003i0?L0M02?0080M02?0P3:0?TG09D0l`H0n@35101k09L60<X0
nA40U@3c0P3oool309h0W@80n@3g0`2109h20<X0n@@0H@2N502I0?T0103oool0m03a0?@0l@3d0?44
08H0Y@80bP3i0`1U0:DD09T0n@D0oooo0`2;0:/00`3:0?T0J@2[06T0Z`0306T0Z`0309T0n@170:/0
A`2[01H0I@3c0`3oool406`0/080V@3i10190;0D06L0n@L0oooo0P2I0?T404/0]@80I`3i5`0e0?<5
0?ooo`80C@2j0P1W0?T502P0^P80=P3i5P040?<40?ooo`@0:@2n0P0f0?T500<0_PD0103c3`040?T5
0?ooo`80=P3i1@030<8<00@0n@`002_c1P3oool200<0a@80103i0`008lDA000[l`@002ci1`3oool6
000Sb08002ci00<004_8001Kl`00Fo<05@00Fo?d0?ooo`00?`3oool2000002T0oooo00<0IVIV0?oo
o`3oool0103oool00`1b01H0nP0a0?X0<@030?X0<@030780A01VIVH0n@2D00<0LP1K103i0<D205d0
LP050<X0n@160780AP1b04H0LP2I0?T00P0_0780101VIVH0I`3i01T0LP0I078503H0n@8001Ab1P00
:o400`00;?T0IVIV000/n@0?000/n@80=01m0P1W0?T00`1VIVH0I`3i06L0n@0206L0nA40=03b00<0
IVIV06d0QP1]08H00P3:0?T20580QPH0U@3b3@2I0?T01@1VIVH0V@3i09T0n@2?0740n@350080S`2>
00<000000?T0m`1d08l00P1d08l20<X0nAL0U@3c1P3i0<D407/0U`/0bP3i302E0?<20?ooo`<0WP2M
0P3i0?L30840WP80bP3i101Q09hD09T0n@040?ooo`3d0?40m03a0?@0l@@0QP2U0P3:0?T306D0YA@0
V@3i103oool408/0Z`030<X0n@1Y0:/0J@2[00<0J@2[00<0V@3i04L0Z`1U0?<05@1U0?<40?ooo`@0
K02`0P2I0?T404T0/0D0I@3c3`1W0?T60?ooo`0306l0]@2I0?T0V@3i00@0B`2e1`1W0?TA03D0l`D0
oooo0`1=0;X206L0n@D0:02j1@0e0?<203H0nA40103c103oool402T0_P80=P3i10030;h;00@0l`X0
103i103oool00`0Z0<80=P3i03H0n@0500<0`Q40103i1P00:o<60?ooo`<00`350P040?T3000SaAD0
02_c203oool5000Sb08002ci5`00Fo?e0?ooo`00JP3oool00`1VIVH0oooo0?ooo`040?ooo`030780
5P3j0340nP0a00<0nP0a00<0LP1406IVIP3i09@00`1b05/40?T0a@80G@1b00@0bP3i04H0LP160780
AP1b0P0_07800`1VIVH0I`3i01T0LP0201T0LPD0=P3i0P005787000[l@0306IVIP00:o4002_a0080
02_a3000;?T203@0O@80I`3i00<0IVIV06L0n@1W0?T01`1W0?T;03@0lP040?T0a@1VIVH0K@2606d0
QP80bP3i00<0DP2609D0lP2E0?802P2E0?8809T0n@0506IVIP2I0?T0V@3i08l0L@3i0<D00P2?08h0
0`000000n@3g07@0S`0207@0S`030<X0n@2E0?<0U@3c01D0U@3c00<0U`1h0?T0a@3i0<D0103i0<D4
07/0Ua00bP3i1P2E0?<00`3oool0n@350?T0a@0309h0W@80n@3g0`2109h20<X0n@<0H@2N5@2I0?T4
0?@0l@@0QP2U0P3:0?T306D0YA@0V@3i103oool408/0Z`030<X0n@1Y0:/0J@2[00<0J@2[00<0V@3i
06D0l`1U0?<0501U0?<30?ooo`80bP3i101/0;0209T0n@<0B@2`2`1U0?<:06L0n@D0oooo0P1_0;D2
09T0n@@0B`2e301W0?T;03D0l`D0oooo101=0;X206L0n@@0:02j2`0e0?<203H0n@/0103c1@3oool4
02T0_P80=P3i0`030;hA00@0l`D0103i0`3oool202X0`P80=P3i1@030<8D00@0n@P0oooo10030<D2
00@0n@8002?55P00:o<80?ooo`D002?81`00;?TA001KloH0oooo001Z0?ooo`0306IVIP3oool0oooo
00@0oooo00<0LP0F0?X0<@3j03400`3j03400`1VIVH0n@2D0?T0U0030780F`@0n@350P1M0780103:
0?T0AP1b04H0LP16078202l0LP0306IVIP1W0?T06@1b00806@1b1@0f0?T00`00578002_a000[l@05
000[l@0306IVIP00:o4002_a00T002_a1P00;?T0100d07d0I`3i06L0n@1VIVH?06L0n@H0=03b00@0
IVIV0?T0a@1]08H0K@260P3:0?T00`1B08H0U@3b09D0lP0?09D0lP80V@3i00X0IVIV09T0n@2I0?T0
V@3i08l0L@3i0<D0S`2>0000002?08h0n@3g0`1d08l70<X0nA40U@3c00<0U`1h0?T0a@3i0<D0103i
0<D407/0Ua@0bP3i0P3oool00`2N07d0n@350?T0a@0309h0W@80n@3g0`2109h20<X0n@<0H@2N1@2E
0?<@09T0n@@0m03a10260:D20<X0n@<0I@2U502I0?T40?ooo`@0R`2[00<0bP3i06T0Z`1Y0:/00`1Y
0:/809T0n@l0I@3c0P3oool00`2?0;00bP3i0<X0n@0406`0/080V@3i0`190;0@06D0l`D0I`3i103o
ool306l0]@80V@3i101;0;DA06L0n@D0=@3c1P3oool404d0^P80I`3i0`0X0;XA03D0l`80=P3i1@04
0?<30?ooo`0304l0_P1W0?T0I`3i00@0:@2n0P0f0?T300<0_QH0103c0`3oool202X0`P80=P3i1@03
0<8D00@0n@L0oooo1@030<D200@0n@03000Sa@00:o<002_c01@002_c2@3oool5000Sb0`002ci2`00
Fo?g0?ooo`00J@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00<0nP0a00<0IVIV
0?T0U03i09@00P1b05/40?T0a@<0G@1b00P0bP3i04H0LP160780V@3i02l0LP1VIVH0;`1b06L0n@<0
6@1b1@0f0?T00`00578002_a000[l@05000[l@0306IVIP00:o4002_a00h002_a0P0d07d206@0lP04
06IVIP1T0?80I03b06@0lQ40I`3i00<0n@3506IVIP1]08H00P1]08H20<X0nA@0U@3b00<0IVIV09D0
lP2E0?800P2?07401@3i0<D0S`2>0000002?08h0n@3g00<0M02?303:0?T;09D0l`80U`1h1P3i0<D4
07/0Ua@0bP3i0P3oool00`2N07d0n@350?T0a@0309h0W@80n@3g0`2109h20<X0n@80H@2N2`2E0?<;
09T0n@@0m03a10260:D20<X0n@<0I@2U502I0?T40?ooo`@0R`2[00<0bP3i06T0Z`1Y0:/00`1Y0:/?
09T0n@L0I@3c0`3oool00`2?0;00bP3i0<X0n@0406`0/080V@3i0P190;0F06D0l`<0oooo101_0;D2
09T0n@@0B`2e4`1W0?T90?ooo`@0C@2j0P1W0?T202P0^QH0=@3c1@3oool204l0_P80I`3i100Y0;h2
03H0n@800`2n5`040?<20?ooo`<0:P320P0f0?T500<0`Q@0103i1`3oool500<0a@80103i5P00:o<7
0?ooo`<0103d1@008lPA000/n@D005_cn03oool006T0oooo00<0IVIV0?ooo`3oool01@3oool00`1b
01H0nP0a0?X0<@020?X0<@0406IVIP1b04@0n@2D0?T0U080LP1K103i0<D305d0LP080<X0n@160780
AP1b09@0lP0_0780IVIV02l0LP1W0?T301T0LPD0=P3i2000:o400`1VIVH002_a000[l@0>000[l@80
=01m00<0I03b06IVIP1T0?80201T0?8<06L0n@0306IVIP3i0<D0K@260080K@260P3:0?TC09D0lP04
06IVIP2E0?80U@3b09D0lP80S`1a00D0n@3508l0SP000000S`2>0?T0m`0307@0Sa40bP3i1P2E0?<2
09L0N0H0n@35101k09LD0<X0n@030?ooo`2N07d0WP1m0080n@350`2N09d20?T0m`<0P@2N0P3:0?T0
0`1Q09h0U@3c09D0l`0?09D0l`H0V@3i103oool408H0Y@80bP3i0`1U0:DD09T0n@80oooo0P3i0?L4
08/0Z`030<X0n@1Y0:/0J@2[00<0J@2[4`2I0?T50?ooo`80S`2`0P3:0?T406`0/080V@3i0P190;0F
06D0l`80oooo1@1_0;D209T0n@@0B`2e4`1W0?T90?ooo`@0C@2j0P1W0?T00`0X0;X0=@3c03D0l`0E
03D0l`@0oooo0`1?0;h206L0n@@0:@2n0P0f0?T00`030;h0103c00@0l`0E00@0l`80oooo100Z0<82
03H0n@D00`3250040?T70?ooo`D00`352@040?T>000[l`L0oooo10040?@5000Sb0L002_c3000;?Wk
0?ooo`00J@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a0080nP0a00@0IVIV0780
A03i09@0n@2D0P1b05/40?T0a@<0G@1b00P0bP3i04H0LP160780U03b02l0LP1VIVH0;`1b06L0n@<0
6@1b1@0f0?T7000[l@0306IVIP00:o4002_a00h002_a00D0U03b03@0O@1T0?80I03b06IVIP0?06@0
lPH0I`3i00<0IVIV0?T0a@1]08H00P1]08H00`3:0?T0U@3b09D0lP0B09D0lP0306IVIP2E0?80U@3b
00<0S`1a00D0n@3508l0SP000000S`2>0?T0m`0307@0SaD0bP3i00@0n@2D09L0N02G07P0U`1h1P3i
0<D407/0Ua@0bP3i00<0oooo09h0O@2N07d00P3i0<D309h0W@80n@3g0`2109h20<X0n@030640WP2E
0?<0U@3c01@0U@3c1@3oool408H0Y@80bP3i0`1U0:DD09T0n@040?ooo`2[0:T0n@3g0?T0m`@0R`2[
00<0bP3i06T0Z`1Y0:/00`1Y0:/C09T0n@D0oooo0P2?0;020<X0n@@0K02`0P2I0?T00`190;00I@3c
06D0l`0D06D0l`<0oooo1@1_0;D209T0n@@0B`2e4`1W0?T70?ooo`80V@3i101=0;X206L0nAL0=@3c
1@3oool304l0_P80I`3i100Y0;h203D0laL0103c0P3oool502X0`P80=P3i1@030<8D00@0n@L0oooo
1@030<D?00@0n@L002_c1`3oool500@0m0@002?83P00:o<6000/nO/0oooo001Y0?ooo`0306IVIP3o
ool0oooo00D0oooo00D0LP0F0?X0<@3j0340nP0a06IVIP020780A080n@2D0P1b05/40?T0a@<0G@1b
00D0bP3i04H0LP2D0?80U03b06IVIP0202l0LP0406L0n@0I07806@1b01T0LP@0=P3i2000:o400`1V
IVH002_a000[l@0>000[l@0409@0lP0d07d0I03b06IVIQD0I03b00<0IVIV0?T0a@3i0<D00`1]08H7
0<X0n@d0U@3b00@0IVIV09D0lP2E0?80U@3b0`2?07400`3i0<D0S`2>000000020?T0m`<0M02?5@3:
0?T0103i09@0U`1h09L0N02G07P60?T0a@@0N`2G503:0?T309h0O@80n@350`2N09d20?T0m`<0P@2N
0P3:0?TG09D0l`D0oooo10260:D20<X0n@<0I@2U502I0?T20:/0Z@80n@3g102;0:/00`3:0?T0J@2[
06T0Z`0306T0Za<0V@3i103oool308l0/080bP3i101/0;0209T0nAH0I@3c103oool506l0]@80V@3i
101;0;DC06L0n@H0oooo00<0LP2j09T0n@2I0?T0101=0;X706L0nA40=@3c1@3oool404l0_P80I`3i
0`0Y0;h803D0la80103c0P3oool502X0`P80=P3i1@030<8500@0l`l0103i103oool00`0[0<D0=P3i
03H0n@0500<0aA<0103i2@3oool600@0m0<002?85@00:o?k0?ooo`00J@3oool00`1VIVH0oooo0?oo
o`050?ooo`0507805P3j0340nP0a0?X0<@1VIVH00P1b04@20?T0U080LP1K103i0<D305d0LP050<X0
n@160780U03b09@0lP1VIVH00P0_07800`1W0?T06@1b01T0LP0;03H0n@03000[l@1VIVH002_a00l0
02_a0P2D0?8206@0lP0306IVIP1T0?80I03b01<0I03b00<0IVIV0?T0a@3i0<D00`1]08H<0<X0n@P0
U@3b00<0IVIV09D0lP2E0?800`2?07420?T0a@0408l0SP000000l`3a0?<0l@<0M02?5@3:0?T0103i
09@0U`1h09L0N02G07P60?T0a@<0N`2G5@3:0?T309h0O@80n@350`2N09d20?T0m`<0P@2N00<0bP3i
09D0l`2E0?<05@2E0?<40?T0a@80oooo10260:D20<X0n@<0I@2U1@2E0?<?09T0n@80Z`2Y0P3i0?L4
08/0Z`030<X0n@1Y0:/0J@2[00<0J@2[4`2I0?T30?ooo`@0S`2`0P3:0?T406`0/0T0V@3i3`1U0?<4
0?ooo`D0K`2e0P2I0?T404/0]@D0I@3c3P1W0?T50?ooo`80LP2j0P2I0?T404d0^P`0I`3i300e0?<4
0?ooo`D0C`2n0P1W0?T202T0_Ph0=@3c30040?<30?ooo`D0:P320P0f0?T400<0`P/0103c2P040?T3
0?ooo`80:`350P0f0?T500<0aA<0103i203oool700@0m08002?85P00:o?k0?ooo`00J@3oool00`1V
IVH0oooo0?ooo`050?ooo`@0nP0a00<0IVIV0780A01b04@00P3i09@20780F`@0n@350`1M0780103:
0?T0U03b09@0lP1VIVH302l0LP0306L0n@0I07806@1b00`0=P3i00@0IVIV03H0n@0f0?T0=P3i3@00
:o4209@0lP0306@0lP1VIVH0I03b01@0I03b00@0IVIV0?T0a@3i0<D0n@350`1]08HA0<X0n@80U@3b
00@0IVIV09D0lP2E0?80U@3b0`2?07420?T0a@0408l0SP000000l`3a0?<0l@<0M02?5@3:0?T0103i
09@0U`1h09L0N02G07P60?T0a@<0N`2G1@350?<@0<X0n@<0WP1m0P3i0<D309h0W@80n@3g0`2109h6
0<X0nA40U@3c1`3i0<D408H0Y@80bP3i0P1U0:D;09D0l`X0V@3i0P2[0:T20?T0m`@0R`2[00<0bP3i
06T0Z`1Y0:/00P1Y0:/D09T0n@<0oooo102?0;020<X0n@@0K02`402I0?T706D0l`@0oooo00<0bP3i
06l0]@1_0;D00`1_0;D209T0n@<0B`2e2`1U0?<906L0n@@0oooo0`1b0;X209T0n@@0C@2j4@1W0?T6
03D0l`D0oooo1@1?0;h206L0n@80:@2n4`0e0?<600@0l`80oooo0P1W0?T502X0`P80=P3i0`030<8A
00@0l`D0103i0P3oool302/0a@80=P3i1@030<DC00@0n@L0oooo20040?@00`008lP002_c000[l`0D
000[lo`0oooo001Y0?ooo`0306IVIP3oool0oooo00D0oooo0`3j0340101VIVH0nP0a0780A01b04@2
0?T0U080LP1K103i0<D205d0LP80bP3i0P2D0?800`1VIVH0;`1b02l0LP0206L0n@806@1b2`0f0?T0
0`1VIVH0=P3i03H0n@0803H0n@H002_a0P2D0?8206@0lP0306IVIP1T0?80I03b01<0I03b00@0IVIV
0?T0a@3i0<D0n@350`1]08HC0<X0n@0406IVIP3:0?T0S`1E0?T0U0<0S`1a0P3i0<D0102?08h00000
0?<0l@3c0?4307@0SaD0bP3i00@0n@2D09L0N02G07P0U`1h1P3i0<D207/0U`/0a@3c2`3:0?T309h0
O@80n@350`2N09d20?T0m`<0P@2N2`3:0?T<09D0l`L0n@3510260:D20<X0n@0306D0Y@2E0?<0U@3c
00l0U@3c1@2I0?T20:/0Z@80n@3g102;0:/00`3:0?T0J@2[06T0Z`0206T0Z`D0U@3c3`2I0?T30?oo
o`@0S`2`0P3:0?T406`0/1@0V@3i1P3oool00`2C0;D0bP3i06l0]@0406l0]@80V@3i0P1;0;DA06D0
l`@0I`3i0`3oool40780^P80V@3i101=0;XD06L0n@P0oooo1@1?0;h206L0n@0302T0_P0e0?<0=@3c
01@0=@3c1@3oool00`1@0<80I`3i06L0n@0502X0`P80=P3i0P030<8G00@0l`80oooo0`0[0<D203H0
n@D00`354`040?T<0?ooo`<0103d5P00:o?m0?ooo`00J@3oool00`1VIVH0oooo0?ooo`050?ooo`<0
nP0a00D0IVIV0?X0<@1b04@0LP140?T0U0030780F`@0n@350P1M07801@3:0?T0U03b09@0lP1VIVH0
U03b0080;`1b0P1W0?T201T0LP/0=P3i00<0IVIV03H0n@0f0?T0200f0?T0103i0?L0I@1m06D0O@3:
0?T509@0lP0306IVIP2D0?80U03b0080U03b4@1T0?800`1VIVH0n@350?T0a@020?T0a@<0K@264P3:
0?T01@1VIVH0bP3i0<X0n@2?05D0n@2D00<0S`1a0P3i0<D0102?08h000000?<0l@3c0?4307@0SaD0
bP3i00@0n@2D09L0N02G07P0U`1h1P3i0<D207/0Ua00a@3c1P3:0?T309h0O@80n@350`2N09d20?T0
m`<0P@2N403:0?T609D0l`030:D0P`3i0<D0n@3500D0n@3510260:D20<X0n@0306D0Y@2E0?<0U@3c
01@0U@3c0P2[0:T20?T0m`@0R`2[00@0bP3i06T0Z`1Y0:/0J@2[2`2E0?<:09T0n@030?ooo`3d0?40
m03a00@0S`2`0P3:0?T406`0/1@0V@3i1@3oool209<0]@030<X0n@1_0;D0K`2e00<0K`2e0P2I0?T2
04/0]AD0I@3c0P3oool50780^P80V@3i101=0;XD06L0n@P0oooo1@1?0;h206L0nAH0=@3c1@3oool2
0500`P80I`3i1@0Z0<8203H0n@0300<0`P040?<0103c01H0103c00<0oooo02/0a@0[0<D00P0[0<D2
03H0n@D00`354`040?TA0?ooo`<0103d4@00:o?m0?ooo`00J@3oool00`1VIVH0oooo0?ooo`040?oo
o`0407805P3j0340nP0a06IVIP80nP0a0P1b04@0103i09@0LP1K0780F`1b05/40?T0a@80G@1b0`3:
0?T0101VIVH0bP3i02l0LP0_078206L0n@806@1b2P0f0?T00`1VIVH0=P3i03H0n@0903H0n@030?T0
m`1U07d0I@1m00H0bP3i00<0IVIV09@0lP2D0?801`2D0?8<06@0lP0306IVIP3i0<D0n@350080n@35
0`1]08HB0<X0n@0506IVIP3:0?T0bP3i08l0E@3i09@00`2?07420?T0a@040?<0l@000000l`3a0?<0
l@<0M02?5@3:0?T0103i09@0U`1h09L0N02G07P60?T0a@0307/0U`350?<0a@3c01@0a@3c00@0n@2D
09h0O@2N07d0WP1m0P3i0<D309h0W@80n@3g0`2109hE0<X0n@80Y@231`3i0<D408H0Y@80bP3i5`2E
0?<20:/0Z@80n@3g102;0:/00`3:0?T0J@2[06T0Z`0A09D0l`D0V@3i0`3d0?4408l0/080bP3i101/
0;0D09T0n@@0oooo0`2C0;D00`3:0?T0K`2e06l0]@0306l0]@80V@3i00<0B`2e06D0l`1U0?<0501U
0?<30?ooo`@0LP2j0P2I0?T404d0^PD0I@3c3`1W0?T60?ooo`80V@3i1@1?0;h706L0nA00=@3c1P3o
ool20500`P80I`3i1@0Z0<8203D0laP0103c00<0oooo02/0a@0[0<D00`0[0<D203H0n@D00`354`04
0?TF0?ooo`<0103d2`00:o?n0?ooo`00J@3oool00`1VIVH0oooo0?ooo`040?ooo`0407805P3j0340
nP0a06IVIP80nP0a0P1b04@0103i09@0LP1K0780F`1b05/40?T0a@80G@1b0P3:0?T00`1VIVH0bP3i
0<X0n@0202l0LP80I`3i0P0I078:03H0n@0306IVIP0f0?T0=P3i00T0=P3i00<0n@3g06D0O@1U07d0
1@3:0?T00`1VIVH0bP3i0<X0n@040<X0n@T0U03b1P1T0?800`1VIVH0n@350?T0a@030?T0a@<0K@26
4@3:0?T0101VIVH0bP3i0<X0n@3:0?T20?T0U0<0S`1a0P3i0<D0103c0?4000000?<0l@3c0?4307@0
SaD0bP3i102G07P60?T0a@0307/0U`350?<0a@3c01@0a@3c00@0n@2D09h0O@2N07d0WP1m0P3i0<D3
09h0W@80n@3g0`2109hE0<X0n@80Y@231`3i0<D408H0Y@030<X0n@2E0?<0U@3c01D0U@3c0`2[0:T2
0?T0m`@0R`2[00<0bP3i06T0Z`1Y0:/05P2E0?<30?@0l@@0S`2`0P3:0?T406`0/1@0V@3i0`3oool4
09<0]@030<X0n@1_0;D0K`2e00<0K`2e0P2I0?TF06D0l`@0oooo101b0;X209T0n@<0C@2j2`1U0?<:
06L0n@D0oooo00<0M02n09T0n@2I0?T01@1?0;h<06L0n@/0=@3c1@3oool30500`P80I`3i100Z0<88
03D0la80103c0P3oool502/0a@80=P3i1@030<D500@0l`h0103i1@3oool603H0nA<0oooo1@00:o?o
0?ooo`00J@3oool00`1VIVH0oooo0?ooo`040?ooo`0307805P3j0340IVIV00<0nP0a0P1b04@0103i
09@0LP1K0780F`1b05/40?T0a@80G@1b0P3:0?T00`1VIVH0bP3i0<X0n@0202l0LP80I`3i0P0I0789
03H0n@0306IVIP0f0?T0=P3i00X0=P3i00<0n@3g06D0O@1U07d01@3:0?T00`1VIVH0bP3i0<X0n@09
0<X0n@H0U03b0P3i09@208H0J`0306IVIP3i0<D0n@3500<0n@350P1]08HB0<X0n@0506IVIP3:0?T0
bP3i0<X0n@3i09@0102?0740103i0<D0l`3a0?<0l@0000020?<0l@80M02?5P3:0?T409L0N0H0n@35
5P350?<20?T0U0<0WP1m0P3i0<D309h0W@80l`3a0`2109hE0<X0n@80Y@231`3i0<D408H0Y@H0bP3i
4@2E0?<40:/0Z@80n@3g102;0:/00`3:0?T0J@2[09D0l`0F09D0l`<0m03a102?0;020<X0n@@0K02`
502I0?T20?ooo`D0T`2e00<0bP3i06l0]@1_0;D00`1_0;D709T0nA00I@3c1@3oool40780^P80V@3i
0`1=0;X@06D0l`D0I`3i103oool207@0_P80V@3i1@1?0;hA06L0n@D0=@3c1@3oool40500`P80I`3i
0`0Z0<8>03D0l``0103c0`3oool502/0a@80=P3i10030<D;00@0l`T0103i103oool00`0[0<P0=P3i
03H0n@0:03H0nOl0oooo4P3oool006T0oooo00<0IVIV0?ooo`3oool0103oool00`1b01H0nP0a06IV
IP030?X0<@030780A03i09@0n@2D00<0LP1K103i0<D205d0LP80bP3i00<0IVIV0<X0n@0_07800P0_
0780101W0?T06@1b01T0LP0I078903H0n@0306IVIP0f0?T0=P3i00X0=P3i00<0n@3g06D0O@1U07d0
103:0?T00`1VIVH0bP3i0<X0n@0>0<X0n@80QP1@00D0n@2D08H0J`2606/0IVIV08H0J`050?T0a@80
K@261P350?8;0<X0n@0306IVIP3:0?T0bP3i0080bP3i00<0n@2D08l0L@2?07400P2?07430?T0a@03
0000003i0<D0n@350080M02?1P350?8@0<X0n@@0U`1h1@3i0<DG0<D0l`80n@2D0`2N07d20?T0a@80
WP2M0`3c0?430840WQD0bP3i0P2U08<70?T0a@@0QP2U2`3:0?T<09D0l`@0Z`2Y0P3i0?L408/0Z`03
0<X0n@2E0?<0U@3c01D0U@3c103d0?4408l0/080bP3i101/0;0D09T0n@80oooo1@2C0;D00`3:0?T0
K`2e06l0]@0306l0]@`0V@3i2`1U0?<20?ooo`0309L0^P3:0?T0bP3i00@0LP2j0P2I0?T204d0^QH0
I@3c0`3oool307@0_P80V@3i1@1?0;hC06L0n@L0oooo1@1@0<8206L0n@80:P32500e0?<600@0l`04
0?ooo`1B0<D0I`3i06L0n@D0:`350P0f0?T300<0aA40103c10040?T30?ooo`80:`384P0f0?Wo0?oo
o``0oooo001X0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j03400`3j03400`1b04@0
n@2D0?T0U0020780F`@0n@350`1M0780103:0?T0IVIV0<X0n@3:0?T302l0LP0406L0n@0I07806@1b
01T0LPP0=P3i00<0IVIV03H0n@0f0?T02`0f0?T306D0O@@0bP3i00<0IVIV0<X0n@3:0?T03P3:0?T2
08H0D0050?T0U02606/0QP1[06IVIP2606/01@3i0<D206d0QP/0a@3b1@3:0?T00`1VIVH0bP3i0<X0
n@030<X0n@030?T0U02?0740S`1a0080S`1a0`3i0<D00`000000n@350?T0a@0207@0S`/0a@3b2`3:
0?T409L0N0X0n@354@350?<00`2N05h0n@2D0?T0U00309h0O@80n@350P2N09d30?<0l@<0P@2N5@3:
0?T20:D0P`L0n@3510260:D@0<X0n@H0U@3c00<0n@350:/0Z@2[0:T00P2[0:T20?T0m`@0R`2[1P3:
0?TA09D0l`D0m03a102?0;020<X0n@@0K02`502I0?T20?ooo`D0T`2e00<0bP3i06l0]@1_0;D00`1_
0;DA09T0n@D0I@3c0P3oool209L0^P80bP3i101b0;X209T0n@80C@2j5P1U0?<20?ooo`@0M02n0P2I
0?T504l0_Q<0I`3i203oool40500`P80I`3i00<0:P3203D0l`0e0?<05@0e0?<40?ooo`80DP350P1W
0?T502/0a@80=P3i0P030<DF00@0l`80oooo0`0[0<PC03H0nOl0oooo2`3oool006P0oooo00<0IVIV
0?ooo`3oool01@3oool00`1b01H0IVIV0?X0<@030?X0<@030780A03i09@0n@2D0080LP1K103i0<D3
05d0LP040<X0n@1VIVH0bP3i0<X0n@<0;`1b00@0I`3i01T0LP0I07806@1b200f0?T00`1VIVH0=P3i
03H0n@0;03H0n@<0I@1m0`3:0?T00`1VIVH0bP3i0<X0n@0?0<X0n@80QP1@00@0n@2D08H0J`1VIVH0
QP1[1P3i0<D00`1]08H0a@3b0<D0lP0?0<D0lP0306IVIP3:0?T0bP3i00<0bP3i00<0n@2D08l0L@2?
07400P2?07430?T0a@040000003i0<D0n@3507@0Sa40a@3b1P3:0?T409L0N0l0n@3530350?<00`2N
05h0n@2D0?T0U00309h0O@80n@3500<0WP2M0?<0l@3c0?400P3c0?420840WQH0bP3i0P2U08<70?T0
a@@0QP2U503:0?T00`2[08L0n@350?T0a@040:/0Z@80n@3g102;0:/;0<X0n@`0U@3c1@3d0?4408l0
/080bP3i101/0;0D09T0n@80m03a1@2C0;D00`3:0?T0K`2e06l0]@0306l0]A<0V@3i103oool309L0
^P80bP3i101b0;X209T0n@0304d0^P1U0?<0I@3c01@0I@3c0P3oool507@0_P80V@3i1@1?0;h506D0
l`h0I`3i203oool40500`P80I`3i5`0e0?<50?ooo`80DP350P1W0?T502/0a@80=P3i00<00`3500@0
l`040?<05@040?<00`3oool0:`3802/0b00202/0b1<0=P3io`3oool;0?ooo`00J03oool00`1VIVH0
oooo0?ooo`050?ooo`0307805P1VIVH0nP0a0080nP0a0P1b04@20?T0U080LP1K103i0<D305d0LP04
06IVIP3:0?T0bP3i0<X0n@<0;`1b00@0I`3i01T0LP0I07806@1b1`0f0?T00`1VIVH0=P3i03H0n@0<
03H0n@<0I@1m0`3:0?T00`1VIVH0bP3i0<X0n@0?0<X0n@80QP1@00@0n@2D08H0J`1VIVH0QP1[1P3i
0<D00`1]08H0a@3b0<D0lP0>0<D0lP0306IVIP350?80a@3b00<0a@3b00<0S`1E0?T0U02?07400`2?
07420?T0a@<0000000<0n@3507@0S`350?805@350?80103i09@0U`1h09L0N02G07PE0?T0a@H0a@3c
0P2N05h20?T0U0<0WP1m0P3i0<D00`2N09d0l`3a0?<0l@020?<0l@80P@2N1`350?<?0<X0n@80Y@23
1`3i0<D408H0YA@0bP3i00<0Z`270?T0a@3i0<D0102[0:T20?T0m`@0R`2[403:0?T609D0l`H0oooo
102?0;020<X0n@@0K02`1`2E0?<=09T0n@80m03a1@2C0;D00`3:0?T0K`2e06l0]@0306l0]A<0V@3i
103oool309L0^P80bP3i101b0;X209T0nAH0I@3c0`3oool507@0_P80V@3i101?0;h;06D0l`T0I`3i
1@3oool00`1g0<80V@3i09T0n@040500`PL0I`3i4@0e0?<50?ooo`<0DP350P1W0?T502/0a@80=@3c
5`040?<00`3oool0:`3802/0b00302/0b1<0=P3io`3oool;0?ooo`00J03oool00`1VIVH0oooo0?oo
o`050?ooo`0306IVIP3j0340nP0a0080nP0a0P1b04@20?T0U080LP1K103i0<D305d0LP0406IVIP3:
0?T0bP3i0<X0n@<0;`1b00@0I`3i01T0LP0I07806@1b1`0f0?T00`1VIVH0=P3i03H0n@0<03H0n@<0
I@1m0P3:0?T00`1VIVH0bP3i0<X0n@0@0<X0n@80QP1@00@0n@2D06IVIP2606/0QP1[1P3i0<DA0<D0
lP0306IVIP350?80a@3b00<0a@3b00<0S`1E0?T0U02?07400`2?07430?T0a@040000003i0<D00000
000001H0a@3b00@0n@2D09L0N02G07P0U`1h1@3c0<4@0?T0a@<0oooo00<0nP1S09h0GP2N05h00P2N
05h20?T0U0<0WP1m0P3i0<D50?<0l@030840WP350?<0a@3c00d0a@3c203:0?T20:D0P`L0n@351026
0:DD0<X0n@030:/0Q`3i0<D0n@3500@0Z`2Y0P3i0?L408/0Za<0bP3i2@3oool408l0/080bP3i0`1/
0;0?09D0l`H0V@3i0P3d0?4509<0]@030<X0n@1_0;D0K`2e00<0K`2e4`2I0?T30?ooo`@0U`2j0P3:
0?T40780^PT0V@3i3P1U0?<40?ooo`D0M02n0P2I0?T304l0_Q40I@3c101W0?T40?ooo`80M`320P2I
0?T40500`P`0I`3i2`0e0?<60?ooo`<0DP350P1W0?T402/0a@P0=@3c4@040?<20?ooo`D0:`384`0f
0?Wo0?ooo`/0oooo001X0?ooo`0306IVIP3oool0oooo00D0oooo00<0IVIV0?X0<@3j03400P3j0342
0780A080n@2D0P1b05/40?T0a@80G@1b00<0IVIV0<X0n@3:0?T00P3:0?T302l0LP0306L0n@0I0780
6@1b00P0=P3i00<0IVIV03H0n@0f0?T0300f0?T306D0O@80bP3i00<0IVIV0<X0n@3:0?T0403:0?T2
08H0D0040?T0U01VIVH0QP1[08H0J`H0n@3540350?800`1VIVH0a@3b0<D0lP030<D0lP80S`1E00<0
n@2D08l0L@2?07400P2?07430?T0a@030000003i0<D0n@3501H0a@3b00@0U`1J0?T0U02G07P0U`1h
2`3c0<4;0?T0a@80oooo00<0WP0n0?X0H`2N05h00`2N05h20?T0U0<0WP1m00<0n@350?<0l@3c0?40
103c0?400`2109h0a@3c0<D0l`0D0<D0l`<0Y@231`3i0<D308H0YAD0bP3i00<0Z`270?T0a@3i0<D0
102[0:T20?T0m`@0R`2[4`3:0?T20?ooo`D0n@350P3oool408l0/080bP3i0P1/0;0F09D0l`80m03a
1@2C0;D00`3:0?T0K`2e06l0]@0306l0]A<0V@3i0P3oool509L0^P80bP3i101b0;X?09T0n@L0I@3c
1@3oool507@0_P80V@3i0P1?0;hF06D0l`<0oooo0`1g0<8209T0n@@0D0324@1W0?T503D0l`H0oooo
101B0<D206L0n@<0:`353P0e0?<;00@0l`<0oooo1@0[0<PC03H0nOl0oooo2`3oool006P0oooo00<0
IVIV0?ooo`3oool0103oool00`1VIVH0nP0a0?X0<@030?X0<@80LP140P3i09@20780F`@0n@350P1M
07800`1VIVH0bP3i0<X0n@020<X0n@80;`1b0P1W0?T201T0LPH0=03a00<0=P3i06IVIP0f0?T03P0f
0?T306D0O@030<X0n@1VIVH0bP3i0180bP3i0P260500101VIVH0QP1[08H0J`2606/50?T0aA40a@3b
00<0IVIV0<D0lP350?800`350?8208l0E@030?T0U02?0740S`1a0080S`1a0P3i0<D00`000000n@35
0?T0a@0G0<D0lP0409L0FP3i09@0U`1h09L0N100l`311P3i0<D20?ooo`0309h0?P3j06<0WP1N00<0
WP1N0P3i09@309h0O@L0n@355`350?<30:D0P`L0n@350`260:D70<D0l`h0bP3i00<0Z`270?T0a@3i
0<D0102[0:T20?T0m`@0R`2[4`3:0?T00`3oool0/02<0?T0a@060?T0a@@0S`2`0P3:0?T206`0/1H0
U@3c0P3d0?4509<0]@030<X0n@1_0;D0K`2e00<0K`2e4`2I0?T20?ooo`D0U`2j0P3:0?T40780^Q<0
V@3i1P3oool20<X0n@D0M02n0P2I0?T00`1?0;h0I@3c06D0l`0E06D0l`80oooo101g0<8209T0n@@0
D0324`1W0?T80?ooo`D0DP350P1W0?T202/0aA@0=@3c1@040?<40?ooo`D0:`384`0f0?Wo0?ooo`/0
oooo001X0?ooo`0306IVIP3oool0oooo00@0oooo00<0IVIV0?X0<@3j03400`3j03420780A080n@2D
0P1b05/40?T0a@0305d0LP1VIVH0bP3i00@0bP3i0P0_078206@0l@806@1b1`0d0?40101VIVH0=03a
03@0l@0d0?4<03H0n@<0I@1m00<0bP3i06IVIP3:0?T04P3:0?T208H0D00406IVIP2606/0QP1[08H0
J`X0n@352`350?800`1VIVH0a@3b0<D0lP030<D0lP<0S`1E00<0n@2D08l0L@2?07400P2?07420?T0
a@030000003i0<D0n@3500D0n@354@350?8209L0FP030?T0U02G07P0l`3101D0l`310P3oool209h0
?P030?X0H`2N05h0WP1N0080WP1N0P3i09@309h0O@L0n@355P350?<40:D0P`L0n@350P260:D?0<D0
l`L0bP3i00<0Z`270?T0a@3i0<D0102[0:T20?T0m`<0R`2[503:0?T20;00S0L0n@35102?0;020<X0
n@0306`0/02E0?<0U@3c01@0U@3c0`3d0?4509<0]@030<X0n@1_0;D0K`2e00<0K`2e4`2I0?T20?oo
o`D0U`2j0P3:0?T40780^Q<0V@3i1@3oool00`2J0;h0bP3i0<X0n@0507@0_P80V@3i5`1U0?<20?oo
o`D0M`320P2I0?T40500`Q<0I`3i203oool50580a@80I`3i00<0:`3503D0l`0e0?<0500e0?<50?oo
o`0305<0b01W0?T0I`3i00D0:`384`0f0?Wo0?ooo`/0oooo001X0?ooo`0306IVIP3oool0oooo00<0
oooo00<0IVIV0?ooo`3j0340103j03420780A0040?T0U01b05/0LP1K0780F`@0n@3500<0G@1b06IV
IP3:0?T0103:0?T202l0LP80I03a00<06@1b03@0l@0d0?401@0d0?400`1VIVH0=03a03@0l@0803@0
l@H0=P3i0`1U07d00`1VIVH0bP3i0<X0n@0B0<X0n@0308H0D01VIVH0n@2D00<0QP1[3`3i0<D60<D0
lP0306IVIP350?80a@3b00<0a@3b0`2?05D00`3i09@0S`1a08l0L@0208l0L@80n@3500<000000?T0
a@3i0<D02P3i0<D<0<D0lP80U`1J00<0n@2D09L0N03c0<405@3c0<420?ooo`80WP0n00<0nP1S09h0
GP2N05h00P2N05h20?T0U0<0WP1m1P3i0<DG0<D0l`@0Y@231`3i0<D00`260:D0a@3c0<D0l`0D0<D0
l`80Z`270P3i0<D40:/0Z@80n@3g0`2;0:/50<D0l`l0bP3i0P2`08`70?T0a@@0S`2`0P3:0?TF09D0
l`@0m03a1@2C0;D00`3:0?T0K`2e06l0]@0306l0]@D0U@3c3P2I0?T20?ooo`D0U`2j0P3:0?T40780
^Q<0V@3i103oool209X0_P80bP3i1@1d0;h709T0nA40I@3c0P3oool607L0`P80V@3i101@0<8C06L0
n@P0oooo1@1B0<D206L0nAH0=@3c1@3oool205<0b080I`3i1@0[0<PC03H0nOl0oooo2`3oool006P0
oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0LP0F0?X0<@040?X0<@80LP1400@0n@2D0780F`1b
05/0LP1K103i0<D00`1VIVH0G@1b0<X0n@040<X0n@0502l0LP1T0?40I03a06@0l@0I07801`0d0?40
0`1VIVH0=03a03@0l@0=03@0l@050?T0m`1U07d0I@1m0<X0n@1VIVH0503:0?T00`260500IVIV0?T0
U00308H0Ja@0n@3500<0IVIV0<D0lP350?800`350?801@3j06<0S`1E08l0E@2?05D0n@2D00@0S`1a
0P3i0<D00`000000n@350?T0a@0?0?T0a@H0a@3b0P2G05X20?T0U1H0l`310P3oool309h0?P030?X0
H`2N05h0WP1N0080WP1N0P3i09@209h0O@`0n@354@350?<00`3i09@0Y@230:D0P`020:D0P`L0n@35
00<0QP2U0<D0l`350?<050350?<20:/0Q`80n@35102[0:T20?T0m`80R`2[2`350?<:0<X0n@80/02<
1`3i0<D408l0/0L0bP3i4@2E0?<40?ooo`D0T`2e00<0bP3i06l0]@1_0;D00P1_0;D;09D0l`T0V@3i
0P3i0?L509L0^P80bP3i101b0;XC09T0n@@0oooo0P2J0;h20<X0n@D0M02n302I0?T;06D0l`@0oooo
1@1g0<8209T0n@@0D0321`1U0?<<06L0n@D0oooo00<0N@3509T0n@2I0?T01@1B0<D706L0nA40=@3c
103oool305<0b080I`3i1@0[0<P703D0l``0=P3io`3oool;0?ooo`00J03oool00`1VIVH0oooo0?oo
o`030?ooo`0306IVIP1b01H0nP0a00@0nP0a0P1b04@0103i09@0LP1K0780F`1b05/40?T0a@0306IV
IP1M0780bP3i00@0bP3i00@0;`1b06@0l@1T0?40I03a1`0d0?400`1VIVH0=03a03@0l@0>03@0l@04
0?T0m`1U07d0I@1m06IVIQ@0bP3i00@0QP1@06IVIP260500n@2D0`2606/D0?T0a@0306IVIP2?01`0
nP0a0080S`0h0P3j06<308l0E@030?T0U02?0740S`1a0080S`1a0P3i0<D00`000000n@350?T0a@0?
0?T0a@040?X0<@2G03`0U`0l09L0?080nP1S0P2G05X00`3i09@0l`310?<0`@0D0?<0`@80oooo102N
03h00`3j06<0WP1N09h0GP0209h0GP80n@2D0P2N07d50?<0`@`0n@3530350?<00`3i09@0Y@230:D0
P`020:D0P`L0n@355P350?<30:/0Q`80n@35102[0:T20?T0m`80R`2[40350?<50<X0n@80/02<1`3i
0<D408l0/0`0bP3i2`2E0?<50?ooo`D0T`2e00@0bP3i06l0]@1_0;D0K`2e4@2E0?<409T0n@80n@3g
1@2G0;X20<X0n@@0LP2j4`2I0?T30?ooo`<0VP2n0P3:0?T507@0_Q40V@3i1@1U0?<50?ooo`D0M`32
0P2I0?T30500`Ph0I@3c1P1W0?T40?ooo`80N@350P2I0?T50580a@`0I`3i2`0e0?<40?ooo`@0D`38
0P1W0?T402/0b0h0=@3c1P0f0?Wo0?ooo`/0oooo001X0?ooo`0306IVIP3oool0oooo0080oooo00<0
IVIV0?ooo`1b01H01@3j03420780A0040?T0U01b05/0LP1K0780F`@0n@3500<0IVIV05d0LP3:0?T0
103:0?T406@0l@L0=03a00<0IVIV03@0l@0d0?403P0d0?40103i0?L0I@1m06D0O@1VIVHD0<X0n@04
08H0D01VIVH0QP1@0?T0U0<0QP1[4`3i0<D0101VIVH0S`0L08l0703j034208l0>080nP1S0`2?05D0
0`3i09@0S`1a08l0L@0208l0L@80n@3500<000000?T0a@3i0<D03`3i0<D0103j0340U`0l09L0?02G
03`20?X0H`80U`1J203i09@?0?<0`@80oooo102N03h00`3j06<0WP1N09h0GP0209h0GP80n@2D00<0
WP1m0?<0`@3c0<402@3c0<4;0?T0a@030?ooo`350?<0a@3c00@0a@3c00<0Y@1R0?T0U02U08<00`2U
08<60?T0aAL0a@3c0`2[08L20?T0a@@0Z`2Y0P3i0?L00`2;0:/0a@3c0<D0l`0D0<D0l`80/02<1`3i
0<D408l0/140bP3i1@2E0?<30?T0a@<0oooo1@2C0;D0103:0?T0K`2e06l0]@1_0;DE09D0l`80n@3g
1@2G0;X20<X0n@@0LP2j4`2I0?T20?ooo`@0VP2n0P3:0?T507@0_Q<0V@3i203oool507L0`P80V@3i
0P1@0<8E06D0l`<0oooo0`1i0<D209T0n@D0DP354@1W0?T503D0l`@0oooo1@1C0<P206L0n@<0:`38
5@0e0??o0?ooo`/0oooo001W0?ooo`0306IVIP3oool0oooo00<0oooo00<0IVIV0?ooo`1b01H01@3j
03420780A0040?T0U01b05/0LP1K0780F`<0n@3500<0IVIV05d0LP1M07801@3:0?T306@0l@L0=03a
00<0IVIV03@0l@0d0?403P0d0?420?T0m`80I@1m00<0IVIV0<X0n@3:0?T04P3:0?T0101VIVH0QP1@
08H0D03i09@308H0Ja<0n@3500@0IVIV08l0702?01`0nP0a0P2?03P20?X0H`<0S`1E00@0n@2D08l0
L@2?0740S`1a0`3i0<D00`000000n@350?T0a@0?0?T0a@040?X0<@2G03`0U`0l09L0?080nP1S0P2G
05X?0?T0U0L0l`310`3oool409h0?P030?X0H`2N05h0WP1N0080WP1N0P3i09@00`2N07d0l`310?<0
`@0>0?<0`@H0n@3500@0oooo0:D0@@3j06<0nP1S102U0680103i09@0Y@230:D0P`2U08<<0?T0aA40
a@3c00@0n@2D0:/0Q`2[08L0Z`270P3i0<D40:/0Z@80l`3a00<0R`2[0<D0l`350?<050350?<20;00
S0L0n@35102?0;050<D0l`l0bP3i203i0<D509<0]@030<X0n@1_0;D0K`2e01H0U@3c0P3i0?L509L0
^P80bP3i101b0;XC09T0n@80oooo102J0;h20<X0n@D0M02n4`2I0?T50?ooo`0309d0`P3:0?T0bP3i
00D0M`320P2I0?T20500`QD0I@3c0`3oool307T0a@80V@3i1@1B0<DC06L0n@H0oooo1P1C0<P206L0
n@80:`385P0e0??o0?ooo`/0oooo001W0?ooo`0306IVIP3oool0oooo0080oooo00@0IVIV0?ooo`3o
ool0LP0F1@3j03400`1b04@0n@2D0?T0U0020780F`@0n@3500<0IVIV05d0LP1M0780103:0?T:06@0
l@0303@0l@1VIVH0=03a00l0=03a0P3i0?L00`1U07d0IVIV0<X0n@0D0<X0n@0406IVIP260500QP1@
0?T0U0<0QP1[4P3i0<D01@1VIVH0n@3508l0702?01`0nP0a0080S`0h0P3j06<308l0E@040?T0U02?
0740S`1a08l0L@<0l`3000<000000?<0`03i0<D03`3i0<D0103j0340U`0l09L0?02G03`20?X0H`80
U`1J503i09@40?ooo`030?X0<@2N03h0WP0n0080WP0n00<0nP1S09h0GP2N05h00P2N05h20?T0U1H0
l`310P3oool00`2U0440nP1S0?X0H`040:D0HP040?T0U02U08<0Y@230:D0P`D0l`31303i0<D<0<D0
l`040?T0U02[08L0Z`270:/0Q`80n@350`2[0:T30?<0lAH0a@3c0`2`08`70?T0a@<0S`2`2`350?<:
0<X0n@P0n@351@2C0;D00`3:0?T0K`2e09D0l`0E09D0l`030;X0^03i0?L0n@3g00D0U`2j0P3:0?T4
0780^PD0U@3c3P2I0?T20?ooo`@0VP2n0P3:0?T507@0_Q<0V@3i103oool209d0`P80bP3i1@1g0<82
09T0n@030500`P1U0?<0I@3c01<0I@3c0`3oool407T0a@80V@3i1@1B0<DC06L0n@L0oooo1@1C0<P2
06L0n@0302/0b00e0?<0=@3c01@0=@3co`3oool<0?ooo`00I`3oool00`1VIVH0oooo0?ooo`020?oo
o`0406IVIP3oool0oooo07805PD0nP0a00<0LP140?T0U03i09@00P1b05/30?T0a@0406IVIP1M0780
G@1b05d0LPX0bP3i101T0?400`1VIVH0I03a06@0l@0206@0l@`0=03a00D0O@1l0?T0m`3i0?L0I@1m
06IVIP0D0<X0n@0406IVIP260500QP1@0?T0U0@0QP1[4P3i0<D01@1VIVH0n@3508l0702?01`0nP0a
0080S`0h0P3j06<208l0E@80n@2D0P2?07440?<0`0030000003c0<00l`3000@0l`302`3i0<D0103j
0340U`0l09L0?02G03`20?X0H`80U`1J503i09@30?ooo`0309h07`3j0340WP0n00<0WP0n00<0nP1S
09h0GP2N05h00P2N05h20?T0U1H0l`3100<0oooo0:D0@@2U04400P3j06<40:D0HP030?T0U02U08<0
Y@2300/0l`312P3i0<D20?ooo`H0a@3c0P3i09@30:/0Q`80n@350P2[0:T30?<0lAH0a@3c102`08`7
0?T0a@<0S`2`40350?<50<X0n@P0n@351@2C0;D00`3:0?T0U@3c09D0l`0D09D0l`80^P2h0P3i0?L5
09L0^P80bP3i0`1b0;X;09D0l`T0V@3i0P3oool409X0_P80bP3i1@1d0;hC09T0n@<0oooo0`2M0<82
0<X0n@D0M`320P2I0?TE06D0l`<0oooo1@1i0<D209T0n@D0DP351@1U0?<>06L0n@L0oooo1@1C0<P2
06L0nAH0=@3co`3oool=0?ooo`00I`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00<0LP0F
0?X0<@3j03400P3j03420780A080n@2D0P1b05/30?T0a@0406IVIP1M0780G@1b05d0LPh0bP3i00<0
IVIV06@0l@1T0?40201T0?4603@0l@0507d0O03i0?L0I@1m06IVIP1U07d0503:0?T0101VIVH0QP1@
08H0D03i09@408H0Ja40n@3500<0IVIV0?T0a@3i0<D00P2?01`308l0>080nP1S0P2?05D20?T0U003
08l0L@3c0<00l`3000<0l`3000<000000?<0`03c0<002@3c0<060?T0a@040?X0<@2G03`0U`0l09L0
?080nP1S0P2G05XD0?T0U080oooo0P2N01l00`3j0340WP0n09h0?P0209h0?P040?X0H`2N05h0WP1N
09h0GP80n@2D5P3c0<420?ooo`80Y@110P3j06<40:D0HP030?T0U02U08<0Y@230100l`311@3i0<D4
0?ooo`@0Z`1U0P3i09@30:/0Q`80n@350P2[0:T:0?<0l@l0a@3c102`08`70?T0a@80S`2`5P350?<8
0?T0a@D0T`2e203:0?T?09D0l`80^P2h0P3i0?L509L0^P80bP3i0P1b0;XA09D0l`@0V@3i0P3d0?44
09X0_P80bP3i1@1d0;hC09T0n@<0oooo0`2M0<820<X0n@D0M`321`2I0?T@06D0l`<0oooo1@1i0<D2
09T0n@@0DP352`1U0?<906L0n@@0oooo00<0N`3809T0n@2I0?T01@1C0<P706L0nA40=@3co`3oool=
0?ooo`00I`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00<0LP0F0?X0<@3j03400P3j0342
0780A080n@2D0P1b05/20?T0a@0306IVIP3i0<D0G@1b0080G@1b3@3:0?T00`1VIVH0bP3i0<X0n@05
0<X0n@H0I03a00<0O@1S0?T0a@1m07`00P1m07`0103i0?L0I@1m06IVIP1U07dC0<X0n@0506IVIP3:
0?T0QP1@08H0D03i09@0102606/A0?T0a@0306IVIP3i0<D0n@350080S`0L0`2?03P20?X0H`80S`1E
0P3i09@00`2?0740l`300?<0`0030?<0`0030000003c0<00l`3000h0l`300P3j034309L0?0040?X0
H`2G05X0U`1J09L0FQ@0n@2D0P3oool209h07`030?X0<@2N03h0WP0n0080WP0n00@0nP1S09h0GP2N
05h0WP1N1`3i09@@0?<0`@80oooo0`2U04420?X0H`@0Y@1R00<0n@2D0:D0P`3c0<405@3c0<440?oo
o`@0Z`1U0P3i09@30:/0Q`80n@3500<0Z`2Y0?<0l@3c0?40403c0?470<D0l`030?T0U02`08`0/02<
0080/02<1`3i0<D208l0/1H0a@3c203i0<D409<0]A00bP3i1`2E0?<30;X0^080n@3g1@2G0;X20<X0
n@80LP2j5@2E0?<20?@0l@@0VP2n0P3:0?T507@0_PD0U@3c3P2I0?T20?ooo`@0W@320P3:0?T507L0
`P/0V@3i2`1U0?<40?ooo`D0N@350P2I0?T30580aA40I@3c101W0?T30?ooo`80N`380P2I0?T505<0
b0`0I`3i2`0e0??o0?ooo`h0oooo001W0?ooo`0406IVIP3oool0oooo06IVIP@0oooo00<0LP0F0?X0
<@3j03400P3j03420780A080n@2D0P1b05/20?T0a@0306IVIP3i0<D0G@1b0080G@1b3@3:0?T00`1V
IVH0bP3i0<X0n@060<X0n@<0O@1:00@0n@2D07d0H`1m06<0n@350`1m07`0103i0?L0IVIV06D0O@1U
07dC0<X0n@0506IVIP3:0?T0QP1@08H0D03i09@0102606/@0?T0a@0606IVIP3i0<D0n@350?T0a@2?
01`0nP0a0`2?03P20?X0H`80S`1E0P3i09@60?<0`0030000003c0<00l`3000h0l`300P3j034309L0
?0040?X0H`2G05X0U`1J09L0FQ@0n@2D0P3oool209h07`030?X0<@2N03h0WP0n0080WP0n00@0nP1S
09h0GP2N05h0WP1N303i09@;0?<0`@80oooo0`2U04420?X0H`@0Y@1R00<0n@2D0:D0P`3c0<405@3c
0<420?ooo`80nP1S102[06D20?T0U0<0Z`270P3i0<DE0?<0l@80oooo0P2`06P20?T0U0@0/02<1`3i
0<D00`2?0;00a@3c0<D0l`0D0<D0l`030;D0S`3i0<D0n@3500H0n@35102C0;D70<D0l`d0bP3i0P3i
0<D40;X0^080n@3g1@2G0;X20<X0n@030780^P2E0?<0U@3c01@0U@3c0P3d0?4409X0_P80bP3i101d
0;h;09D0l`T0V@3i00<0oooo09d0`P2M0<800`2M0<820<X0n@D0M`32402I0?T506D0l`D0oooo1@1i
0<D209T0n@80DP355P1U0?<20?ooo`<0N`380P2I0?T505<0b140I`3i1@0e0??o0?ooo`l0oooo001W
0?ooo`0406IVIP3oool0oooo06IVIP@0oooo1@3j03420780A080n@2D0P1b05/0103i0<D0IVIV0?T0
a@3i0<D305d0LP`0bP3i00<0IVIV0<X0n@3:0?T01`3:0?T307d0BP040?T0U01m06<0O@1S0?T0a@<0
O@1l00@0n@3g06IVIP1U07d0I@1m4P3:0?T00`1VIVH0bP3i0<X0n@0208H0D0030?T0U02606/0QP1[
0080QP1[403i0<D01P1VIVH0n@350?T0a@3i0<D0S`0L0?X0<@<0S`0h0P3j06<208l0E@030?T0U03c
0<00l`3000D0l`3000<000000?<0`03c0<003@3c0<000`2G01d0nP0a0?X0<@0209L0?080nP1S0`2G
05XD0?T0U080oooo0P2N01l00`3j0340WP0n09h0?P0209h0?P040?X0H`2N05h0WP1N09h0GQ40n@2D
1@3c0<430?ooo`<0Y@110P3j06<40:D0HP030?T0U03c0<40l`3101@0l`310P3oool00`2[04<0nP1S
0?X0H`040:/0I@80n@2D0`2[08L70?<0`@80n@353P3c0?40103oool0/01X0;00J02`06P20?T0U0@0
/02<1`3i0<DF0<D0l`80]@2?203i0<D309<0]@l0a@3c1P3:0?T20?T0a@@0^P2h0P3i0?L509L0^P80
bP3i5P2E0?<30?@0l@@0VP2n0P3:0?T307@0_Q40U@3c102I0?T00`3oool0W@3209d0`P0309d0`P80
bP3i1@1g0<8B09T0n@H0oooo0P3:0?T507T0a@80V@3i00<0DP3506D0l`1U0?<05@1U0?<00`3oool0
N`3807/0b00207/0b080V@3i1@1C0<PC06L0nOl0oooo4P3oool006L0oooo00@0IVIV0?ooo`3oool0
IVIV103oool50?X0<@80LP140P3i09@20780F`040?T0a@1VIVH0n@350?T0a@80G@1b3@3:0?T00`1V
IVH0bP3i0<X0n@060<X0n@050?X0H`1m04X0O@1:07d0BP3i09@00P1m06<01@3i0<D0O@1l07d0O01m
07`0IVIV00<0I@1m4P3:0?T00`1VIVH0bP3i0<X0n@0208H0D0030?T0U02606/0QP1[0080QP1[3`3i
0<D00`1VIVH0n@350?T0a@020?T0a@0308l0703j0340S`0h0080S`0h0P3j06<208l0E@H0n@2D0P3c
0<000`000000l`300?<0`00<0?<0`0040?ooo`2G01d0nP0a0?X0<@80U`0l0P3j06<309L0FQ@0n@2D
0P3oool209h07`030?X0<@2N03h0WP0n0080WP0n00@0nP1S09h0GP2N05h0WP1N503i09@30?ooo`80
nP0a0`2U04420?X0H`@0Y@1R1P3i09@@0?<0`@<0oooo00<0Z`130?X0H`3j06<0102[06D20?T0U080
Z`273P3c0<420?T0a@L0l`3a00<0oooo0;00J02`06P00P2`06P20?T0U0@0/02<3P3i0<D>0<D0l`<0
]@2?203i0<D209<0]AH0a@3c0P3i0<D40;X0^080n@3g1@2G0;X70<X0nA00U@3c103d0?4409X0_P80
bP3i0P1d0;hF09D0l`030?ooo`2M0<80W@3200<0W@320P3:0?T507L0`Q80V@3i1@3oool00`2P0<D0
bP3i0<X0n@0507T0a@80V@3i5`1U0?<00`3oool0N`3807/0b00307/0b080V@3i1@1C0<PC06L0nOl0
oooo4P3oool006L0oooo00<0IVIV0?ooo`1VIVH01@3oool50?X0<@80LP1400D0n@2D0780F`1b05/0
LP1K06IVIP030?T0a@80G@1b3@3:0?T00`1VIVH0bP3i0<X0n@060<X0n@050?X0H`1m04X0O@1:07d0
BP3i09@00P1m06<01@3i0<D0O@1l07d0O01m07`0IVIV00<0I@1m4@3:0?T0101VIVH0bP3i0<X0n@3:
0?T208H0D0040?T0U02606/0QP1[08H0Ja00n@3500<0IVIV0?T0a@3i0<D00P3i0<D00`2?01`0nP0a
08l0>00208l0>0040?X0H`2?05D0S`1E08l0E@P0n@2D00<000000?T0U03i09@0303c0<00103oool0
U`0M0?X0<@3j034209L0?080nP1S0`2G05XD0?T0U080oooo0P2N01l00`3j0340WP0n09h0?P0209h0
?P040?X0H`2N05h0WP1N09h0GQ@0n@2D0P3oool00`2U0200nP0a0?X0<@030:D0@@80nP1S0`2U068<
0?T0U0/0l`310P3oool20:/0@`80nP1S102[06D20?T0U0030:/0Q`3c0<40l`3101<0l`31103oool4
0;00J080n@2D102`08`C0?T0a@030?ooo`350?<0a@3c00D0a@3c102e08l80?T0a@80T`2e5P350?<2
0?T0a@@0^P2h0P3i0?L509L0^P`0bP3i2`2E0?<40?@0l@@0VP2n0P3:0?T00`1d0;h0U@3c09D0l`0E
09D0l`030?ooo`2M0<80W@3200<0W@320P3:0?T507L0`Q80V@3i103oool20:00a@80bP3i1@1i0<D7
09T0nA40I@3c00<0oooo07/0b01k0<P0101k0<P209T0n@D0D`381`1U0?<<06L0nOl0oooo4P3oool0
06L0oooo00<0IVIV0?ooo`1VIVH0103oool00`1b01H0nP0a0?X0<@030?X0<@80LP1400D0n@2D0780
F`1b05/0LP1K06IVIP030?T0a@80G@1b303:0?T00`1VIVH0bP3i0<X0n@070<X0n@050?X0H`1m04X0
O@1:07d0BP3i09@00P1m06<01@3i0<D0O@1l07d0O01VIVH0n@3g00<0I@1m4@3:0?T0101VIVH0bP3i
0<X0n@3:0?T208H0D0040?T0U02606/0QP1[08H0J`D0lP302P3i0<D00`1VIVH0n@350?T0a@030?T0
a@0308l0703j0340S`0h0080S`0h00@0nP1S08l0E@2?05D0S`1E203i09@00`000000n@2D0?T0U005
0?T0U0H0l`300P3oool00`2G01d0nP0a0?X0<@0209L0?080nP1S0`2G05XD0?T0U080oooo0P2N01l0
0`3j0340WP0n09h0?P0209h0?P040?X0H`2N05h0WP1N09h0GQ@0n@2D00<0oooo0:D0802U02000P3j
03430:D0@@80nP1S0`2U068A0?T0U0D0l`310`3oool20:/0@`80nP1S102[06D20?T0U0030:/0Q`3c
0<40l`3101<0l`31103oool40;00J080n@2D102`08`C0?T0a@H0oooo00<0]@1/0?T0U02e08l00`2e
08l80?T0a@0309<0]@350?<0a@3c01@0a@3c00<0^P2C0?T0a@3i0<D0102j0;P20?T0m`D0U`2j4@3:
0?T509D0l`D0oooo102J0;h20<X0nAL0U@3c0P3d0?4509d0`P80bP3i1@1g0<8B09T0n@<0oooo0`2P
0<D20<X0n@D0N@35302I0?T;06D0l`<0oooo1@1k0<P209T0n@@0D`383P1U0?<606L0nOl0oooo4P3o
ool006L0oooo0P1VIVH50?ooo`0307805P3j0340nP0a00<0nP0a0P1b04@01@3i09@0LP1K0780F`1b
05/0IVIV00<0n@350P1M078<0<X0n@0306IVIP3:0?T0bP3i00L0bP3i00@0nP1S07d0BP1m04X0O@1:
0`1m06<01@3i0<D0O@1l07d0O01VIVH0n@3g0080I@1m4@3:0?T00`1VIVH0bP3i0<X0n@020<X0n@80
QP1@00<0n@2D08H0J`2606/02`3b0<050?T0a@0306IVIP3i0<D0n@3500<0n@3500<0S`0L0?X0<@2?
03P00P2?03P0103j06<0S`1E08l0E@2?05D80?T0U0030000003i09@0n@2D00T0n@2D103oool00`2G
01d0nP0a0?X0<@0209L0?080nP1S0`2G05XD0?T0U080oooo0P2N01l00`3j0340WP0n09h0?P0209h0
?P040?X0H`2N05h0WP1N09h0GQ@0n@2D00<0oooo0:D0802U02000P3j03430:D0@@80nP1S0`2U068D
0?T0U0@0oooo0`2[04<20?X0H`@0Z`1U0P3i09@E0?<0`@D0oooo102`06P20?T0U0<0/02<503i0<D5
0?ooo`80]@1/00<0n@2D0;D0S`2e08l00P2e08l80?T0aAH0a@3c0P2j09<20?T0a@@0^P2h0P3i0?L5
09L0^Q<0bP3i203oool409X0_PL0bP3i4@2E0?<30?@0l@D0W@320P3:0?T507L0`PD0U@3c3@2I0?T2
0?ooo`@0X0350P3:0?T507T0aA40V@3i1@1U0?<40?ooo`D0N`380P2I0?T305<0b1D0I@3co`3ooolB
0?ooo`00I`3oool206IVIPD0oooo00<0LP0F0?X0<@3j03400`3j03420780A0040?T0U01b05/0LP1K
06IVIP@0n@350P1M078;0<X0n@0306IVIP3:0?T0bP3i00P0bP3i00@0nP1S07d0BP1m04X0O@1:0`1m
06<00`3i0<D0O@1l06IVIP020?T0m`80I@1m1P340?4;0<X0n@0306IVIP3:0?T0bP3i0080bP3i0P26
05000`3i09@0QP1[08H0J`0?0?80`00306IVIP3i0<D0n@3500@0n@3500<0S`0L0?X0<@2?03P00P2?
03P0103j06<0S`1E08l0E@2?05D80?T0U0030000003i09@0n@2D00T0n@2D103oool00`2G01d0nP0a
0?X0<@0209L0?080nP1S0`2G05XD0?T0U080oooo0P2N01l00`3j0340WP0n09h0?P0209h0?P040?X0
H`2N05h0WP1N09h0GQ@0n@2D00<0oooo0:D0802U02000P3j03430:D0@@80nP1S0`2U068D0?T0U0@0
oooo0`2[04<20?X0H`@0Z`1U00<0n@2D0?<0`@3c0<40503c0<430?ooo`80nP1S102`06P20?T0U0<0
/02<1`3c0<4=0?T0a@@0oooo0`2e06`00`3i09@0]@2?0;D0S`020;D0S`d0n@354@350?<20;X0T`80
n@35102j0;P20?T0m`D0U`2j1@350?<>0<X0n@@0n@35103oool409X0_P`0bP3i2`2E0?<40?@0l@D0
W@320P3:0?T407L0`PX0U@3c2@2I0?T00`3oool0X0350:00a@030:00a@80bP3i1@1i0<DC09T0n@L0
oooo1@1k0<P209T0n@80D`385P1U0??o0?oooa80oooo001V0?ooo`80IVIV1P3oool00`1b01H0nP0a
0?X0<@030?X0<@80LP1400@0n@2D0780F`1b05/0IVIV103i0<D205d0LP/0bP3i00<0IVIV0<X0n@3:
0?T0203:0?T0103j06<0O@1:07d0BP3i09@307d0H`030?T0a@1m07`0IVIV0080n@3g00<0I@1m0<@0
l@340?402P340?450<X0n@0306IVIP3:0?T0bP3i00<0bP3i0P2605000`3i09@0QP1[0?80`00?0?80
`00306IVIP3b0<00lP3000<0lP300P2?01`01@3j0340S`0h08l0>02?03P0nP1S00<0S`1E203i09@0
0`000000n@2D0?T0U0090?T0U0@0oooo00<0U`0M0?X0<@2G03`00P2G03`20?X0H`<0U`1J503i09@2
0?ooo`80WP0O00<0nP0a09h0?P2N03h00P2N03h0103j06<0WP1N09h0GP2N05hD0?T0U0030?ooo`2U
0200Y@0P0080nP0a0`2U04420?X0H`<0Y@1R503i09@40?ooo`<0Z`130P3j06<40:/0I@H0n@2D403c
0<430?ooo`030;00AP3j06<0nP1S00@0/01X0P3i09@20;00S0l0l`311P3i0<D30?ooo`@0]@1/00<0
n@2D0;D0S`2e08l00P2e08lB0?T0a@/0a@3c0`2j09<20?T0a@@0^P2h0P3i0?L409L0^P/0a@3c2@3:
0?T80?T0a@@0VP2n4@3:0?T509D0l`D0m03a1@2M0<820<X0n@<0M`32402E0?<409T0n@030?ooo`2P
0<D0X03500<0X0350P3:0?T507T0aA<0V@3i103oool00`2S0<P0bP3i0<X0n@0507/0b080V@3i00<0
D`3806D0l`1U0?<0501U0??o0?oooa<0oooo001V0?ooo`80IVIV1P3oool00`1b01H0nP0a0?X0<@03
0?X0<@050780A03i09@0n@2D0780F`1VIVH0103i0<D305d0LPX0bP3i00<0IVIV0<X0n@3:0?T02@3:
0?T0103j06<0O@1:07d0BP3i09@307d0H`030?T0a@1VIVH0O@1l0080n@3g00<0I@1m0<@0l@340?40
3`340?400`1VIVH0bP3i0<X0n@030<X0n@80QP1@00<0n@2D08H0J`3b0<003P3b0<000`1VIVH0lP30
0?80`0040?80`080S`0L00D0nP0a08l0>02?03P0S`0h0?X0H`0308l0E@L0n@2D00<000000?T0U03i
09@02P3i09@40?ooo`0309L07@3j0340U`0l0080U`0l0P3j06<309L0FQ@0n@2D0P3oool209h07`03
0?X0<@2N03h0WP0n0080WP0n00@0nP1S09h0GP2N05h0WP1N503i09@00`3oool0Y@0P0:D080020?X0
<@<0Y@110P3j06<30:D0HQ@0n@2D0P3oool20?X0<@<0Z`130P3j06<40:/0I@/0n@2D2`3c0<420?oo
o`80/0160P3j06<40;00J080n@2D00<0/02<0?<0`@3c0<40503c0<420?ooo`D0]@1/00<0n@2D0;D0
S`2e08l00P2e08lC0?T0a@@0oooo1@350?<40;X0T`80n@35102j0;P20?<0l@<0U`2j4@350?<40<X0
n@P0n@35102J0;hC0<X0n@80oooo1P3d0?4509d0`P80bP3i0P1g0<8E09D0l`030?ooo`2P0<D0X035
00<0X0350P3:0?T507T0aA<0V@3i0`3oool20:<0b080bP3i1@1k0<P209T0nAH0I@3co`3ooolD0?oo
o`00IP3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a0080nP0a0P1b04@20?T0U003
0780F`1VIVH0n@3500<0n@350`1M078:0<X0n@0306IVIP3:0?T0bP3i00T0bP3i00@0nP1S07d0BP1m
04X0n@2D0`1m06<00`3i0<D0IVIV07d0O0020?T0ma40a03a00<0IVIV0<@0l@340?400`340?4308H0
D0030?T0U03b0<00lP3000d0lP3000<0IVIV0?80`03b0<00103b0<00103oool0S`0L08l0703j0343
08l0>0040?X0H`2?05D0S`1E08l0E@L0n@2D00<000000?T0U03i09@02P3i09@40?ooo`0309L07@3j
0340U`0l0080U`0l0P3j06<309L0FQ@0n@2D0P3oool209h07`030?X0<@2N03h0WP0n0080WP0n00@0
nP1S09h0GP2N05h0WP1N503i09@00`3oool0Y@0P0:D080020?X0<@<0Y@110P3j06<30:D0HQ@0n@2D
00@0oooo0:/08P3j0340nP0a0`2[04<20?X0H`@0Z`1U403i09@50?<0`@<0oooo0P2`04H20?X0H`@0
/01X0P3i09@00`2`08`0l`310?<0`@0D0?<0`@80oooo1@2e06`00`3i09@0]@2?0;D0S`020;D0Sa<0
n@351`3oool20?T0U0@0^P2C0P3i0<D30;X0^0<0l`3a0P2G0;XF0<D0l`P0n@35102J0;hC0<X0n@03
0?ooo`3d0?40m03a00D0m03a1@2M0<820<X0n@0307L0`P2E0?<0U@3c01@0U@3c00<0oooo0:00a@2P
0<D00`2P0<D20<X0n@D0N@354`2I0?T20?ooo`<0X`380P3:0?T507/0b0T0V@3i3P1U0??o0?oooaD0
oooo001V0?ooo`<0IVIV1@3oool00`1b01H0nP0a0?X0<@020?X0<@80LP140P3i09@00`1VIVH0LP1K
0?T0a@030?T0a@<0G@1b2@3:0?T00`1VIVH0bP3i0<X0n@0:0<X0n@040?X0H`1m04X0O@1:0?T0U0<0
O@1S00<0IVIV07d0O01m07`00P3i0?LA0<@0l@0306IVIP340?40a03a00<0a03a0`26050@0?80`003
06IVIP3b0<00lP3000@0lP3000@0oooo08l0702?01`0nP0a0P2?03P20?X0H`<0S`1E1`3i09@00`00
0000n@2D0?T0U00:0?T0U0@0oooo00<0U`0M0?X0<@2G03`00P2G03`20?X0H`<0U`1J503i09@20?oo
o`80WP0O00<0nP0a09h0?P2N03h00P2N03h0103j06<0WP1N09h0GP2N05hD0?T0U0030?ooo`2U0200
Y@0P0080nP0a0`2U04420?X0H`<0Y@1R503i09@20:/08P80nP0a0`2[04<20?X0H`@0Z`1U4`3i09@4
0?ooo`<0/0160P3j06<40;00J080n@2D5P3c0<430?ooo`D0]@1/00<0n@2D0;D0S`2e08l00P2e08l5
0?<0`@h0n@351P3oool00`2j06h0n@2D0?T0U0040;X0T`80n@350P2j0;P40?<0l@0309L0^P350?<0
a@3c01D0a@3c203i0<D409X0_PD0a@3c3P3:0?T80?ooo`D0W@320P3:0?TF09D0l`80m03a1@2P0<D2
0<X0n@D0N@351@2E0?<>09T0n@030?ooo`2S0<P0X`380080X`380P3:0?T507/0b0l0V@3i1`1U0??o
0?oooaH0oooo001V0?ooo`0306IVIP3oool0oooo00D0IVIV00<0LP0F0?X0<@3j03400P3j03420780
A080n@2D00<0IVIV0780F`3i0<D00`3i0<D305d0LPT0bP3i00<0IVIV0<X0n@3:0?T02P3:0?T0103j
06<0O@1:07d0BP3i09@307d0H`0406IVIP1m07`0O@1l0?T0ma40a03a00<0IVIV0<@0l@340?400`34
0?40103j06<0QP1@08H0D02605070?T0U0P0lP3000<0IVIV0?80`03b0<00103b0<020?ooo`80S`0L
00<0nP0a08l0>02?03P00P3j06<308l0E@L0n@2D00<000000?T0U03i09@02P3i09@40?ooo`80nP0a
0`2G03`20?X0H`<0U`1J503i09@20?ooo`80WP0O00@0nP0a09h0?P2N03h0WP0n0P3j06<309h0GQ@0
n@2D00<0oooo0:D0802U02000P3j03430:D0@@80nP1S0`2U068D0?T0U080Z`0R0P3j03430:/0@`80
nP1S102[06DC0?T0U0<0oooo102`04H20?X0H`@0/01X00<0n@2D0?<0`@3c0<40503c0<430?ooo`03
0?X0H`2e06`0]@1/00<0]@1/00@0n@2D0;D0S`2e08l0]@2?2`3c0<490?T0a@D0oooo0P2j06h20?T0
U0@0^P2C0P3i0<D20;X0^0@0l`3a5`350?<90?T0a@<0VP2n2`350?<90<X0n@P0oooo1@2M0<870<X0
nA00U@3c0`3d0?450:00a@80bP3i101i0<D;09D0l`T0V@3i1@2S0<P20<X0n@D0N`384`2I0?Wo0?oo
oaT0oooo001V0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j03420780A004
0?T0U01VIVH0LP1K0780F`@0n@350`1M07880<X0n@0306IVIP3:0?T0bP3i00/0bP3i00@0nP1S07d0
BP1m04X0n@2D0P1m06<0101VIVH0n@3507d0O01m07`70?T0m`/0a03a00<0IVIV0<@0l@340?400`34
0?40103j06<0QP1@08H0D026050>0?T0U0030?80`01VIVH0lP3000D0lP300P3oool208l070030?X0
<@2?03P0S`0h0080nP1S0`2?05D70?T0U0030000003i09@0n@2D00X0n@2D103oool20?X0<@<0U`0l
0P3j06<309L0FQ@0n@2D0P3oool209h07`040?X0<@2N03h0WP0n09h0?P80nP1S0`2N05hD0?T0U003
0?ooo`2U0200Y@0P0080nP0a0`2U04420?X0H`<0Y@1R503i09@20:/08P80nP0a0`2[04<20?X0H`@0
Z`1U4`3i09@30?ooo`@0/0160P3j06<40;00J0P0n@2D3P3c0<430?ooo`030;D0A`3j06<0]@1/00@0
]@1/00<0n@2D0;D0S`2e08l04@3c0<440?T0a@D0oooo0P2j06h20?T0U0@0^P2C0P3i0<D00`2j0;P0
l`3a0?<0l@080?<0lA40a@3c00<0_P2F0?T0a@3i0<D01`3i0<D209X0_Q40a@3c103:0?T40?T0a@@0
oooo1@2M0<8<0<X0n@/0U@3c0`3d0?450:00a@80bP3i0`1i0<DA09D0l`@0V@3i1@2S0<P20<X0n@D0
N`384`2I0?Wo0?oooaT0oooo001V0?ooo`0306IVIP3oool0oooo00D0oooo1@3j03420780A0040?T0
U01VIVH0LP1K0780F`@0n@350`1M07880<X0n@0306IVIP3:0?T0bP3i00/0bP3i0`1m04X0103i09@0
O@1S07d0H`1VIVH307d0O0`0n@3g1@340?400`1VIVH0a03a0<@0l@030<@0l@80nP1S0`26050>0?T0
U00306IVIP3i09@0n@2D00<0n@2D103oool208l070030?X0<@2?03P0S`0h0080nP1S0P2?05D80?T0
U0030000003i09@0n@2D00X0n@2D0`3oool00`2G01d0nP0a0?X0<@0309L0?080nP1S0P2G05XE0?T0
U080oooo0P2N01l0103j0340WP0n09h0?P2N03h20?X0H`<0WP1N503i09@00`3oool0Y@0P0:D08002
0?X0<@<0Y@110P3j06<30:D0HQ@0n@2D0P2[02820?X0<@<0Z`130P3j06<40:/0IA<0n@2D0`3oool4
0;00AP80nP1S102`06P>0?T0U0L0l`310`3oool20;D0A`030?X0H`2e06`0]@1/00<0]@1/00<0n@2D
0;D0S`2e08l05@3c0<440?ooo`<0^P1^0P3i09@40;X0T`80n@35403c0?4;0<D0l`80_P2F2@3i0<D2
09X0_QD0a@3c203i0<D509d0`Q40bP3i1@2E0?<40?@0l@D0X0350P3:0?T207T0aAH0U@3c1@2S0<P2
0<X0n@D0N`384`2I0?Wo0?oooaT0oooo001V0?ooo`0306IVIP3oool0oooo00D0oooo1@3j03420780
A0040?T0U01VIVH0LP1K0780F`@0n@350P1M07880<X0n@0306IVIP3:0?T0bP3i00`0bP3i0`1m04X0
103i09@0O@1S06IVIP3i0<D307d0O140n@3g00<0IVIV0<@0l@340?400`340?420?X0H`<0QP1@3P3i
09@00`1VIVH0n@2D0?T0U0030?T0U0@0oooo0P2?01`00`3j0340S`0h08l0>0020?X0H`80S`1E1@3b
09030?T0U0030000003i09@0n@2D00X0n@2D0`3oool00`2G01d0nP0a0?X0<@0309L0?080nP1S0P2G
05X50?<0T100n@2D0P3oool209h07`040?X0<@2N03h0WP0n09h0?P80nP1S0`2N05hD0?T0U0030?oo
o`2U0200Y@0P0080nP0a0`2U04420?X0H`<0Y@1R503i09@20:/08P80nP0a0`2[04<20?X0H`@0Z`1U
4`3i09@20?ooo`030?X0<@2`04H0/0160080/0160P3j06<40;00J1<0n@2D1@3oool20;D0A`030?X0
H`2e06`0]@1/00<0]@1/00<0n@2D0;D0S`3c0<405@3c0<430?ooo`@0^P1^0P3i09@40;X0T`L0n@35
403c0?450<D0l`<0_P2F2@3i0<D00`2J0;h0a@3c0<D0l`0D0<D0l`P0n@351@2M0<8C0<X0n@030?oo
o`3d0?40m03a00@0m03a1@2P0<D20<X0n@0307T0a@2E0?<0U@3c01D0U@3c1@2S0<P20<X0n@D0N`38
4`2I0?Wo0?oooaT0oooo001V0?ooo`0306IVIP3oool0oooo00D0oooo1@3j03420780A00406IVIP1b
05/0LP1K0780F`@0n@350P1M07880<X0n@0306IVIP3:0?T0bP3i00`0bP3i0`1m04X0103i09@0O@1S
06IVIP3i0<D307d0O100n@3g00<0IVIV0?T0m`3i0?L00P3i0?L208H0=@80nP1S0P26050>0?T0U003
06IVIP3i09@0n@2D00@0n@2D103oool208l070030?X0<@2?03P0S`0h0080nP1S00<0S`1E0?80T03b
09001`3b09000`000000lP2@0?T0U00:0?T0U0<0oooo00<0U`0M0?X0<@3j03400`2G03`20?X0H`80
U`1J2P3c090;0?T0U080oooo0P2N01l0103j0340WP0n09h0?P2N03h20?X0H`<0WP1N503i09@00`3o
ool0Y@0P0:D080020?X0<@<0Y@110P3j06<30:D0HQ@0n@2D0P2[02820?X0<@<0Z`130P3j06<40:/0
IA<0n@2D00<0oooo0;008`3j0340102`04H20?X0H`@0/01X4`3i09@40?ooo`<0]@1700<0nP1S0;D0
K02e06`00`2e06`00`3i09@0l`310?<0`@0D0?<0`@@0oooo102j06h20?T0U0@0^P2C1@3c0<470?T0
a@/0l`3a0P3oool20?T0U0@0_P2F2@3i0<DF0<D0l`030<80V@3i0<D0n@3500H0n@351@2M0<8C0<X0
n@L0m03a1@2P0<D20<X0nAL0U@3c00<0oooo0:<0b02S0<P00`2S0<P20<X0n@D0N`384`2I0?Wo0?oo
oaT0oooo001V0?ooo`0306IVIP3oool0oooo00@0oooo00<0LP0F0?X0<@3j03400`3j03420780A004
06IVIP1b05/0LP1K0780F`@0n@350P1M07880<X0n@0306IVIP3:0?T0bP3i00/0bP3i00P0nP1S07d0
BP1m04X0O@1:0?T0U01VIVH0O@1S0?T0a@<0O@1l403i0?L00`1VIVH0n@3g0?T0m`020?T0m`80QP0e
0P3j06<208H0D0D0lP2@2@3i09@00`1VIVH0n@2D0?T0U0040?T0U0@0oooo0P2?01`308l0>080nP1S
00<0S`1E0?80T03b09001`3b0902000000D0lP2@1P3i09@30?ooo`0309L07@3j0340nP0a00<0U`0l
0P3j06<00`2G05X0l`2@0?<0T00>0?<0T0H0n@2D0P3oool209h07`040?X0<@2N03h0WP0n09h0?P80
nP1S0`2N05hD0?T0U0030?ooo`2U0200Y@0P0080nP0a0`2U04420?X0H`<0Y@1R503i09@20:/08P80
nP0a0`2[04<20?X0H`@0Z`1U4`3i09@20;008`030?X0<@2`04H0/0160080/0160P3j06<40;00J1<0
n@2D0`3oool40;D0A`030?X0H`2e06`0]@1/00<0]@1/1P3i09@@0?<0`@D0oooo102j06h20?T0U0<0
^P2C2`3c0<470?T0a@D0l`3a0P3oool00`2n0740n@2D0?T0U0040;h0UPh0n@3540350?<20<80V@P0
n@351@2M0<870<D0l``0bP3i1P3oool00`3d0?40X0350:00a@030:00a@L0bP3i4@2E0?<20?@0l@D0
X`380P3:0?T507/0b1<0V@3io`3ooolI0?ooo`00IP3oool00`1VIVH0oooo0?ooo`040?ooo`030780
5P3j0340nP0a00<0nP0a00<0LP1406IVIP3i09@00`1b05/40?T0a@80G@1b1`3:0?T00`1VIVH0bP3i
0<X0n@0<0<X0n@080?X0H`1m04X0O@1:07d0BP3i09@0IVIV07d0H`3i0<D307d0O0l0n@3g00<0IVIV
0?T0m`3i0?L00`3i0?L208H0=@80nP1S00<0QP1@0?80T03b09002@3b09030?T0U00306IVIP3i09@0
n@2D00D0n@2D103oool00`2?01`0nP0a08l0>00208l0>080nP1S2@3b09000`1VIVH000000?80T002
000000P0lP2@103oool00`2G01d0nP0a0?X0<@0309L0?080nP1S00<0U`1J0?<0T03c09004`3c0903
0?ooo`80WP0O00@0nP0a09h0?P2N03h0WP0n0P3j06<209h0GQD0n@2D00<0oooo0:D0802U02000P3j
03430:D0@@80nP1S0`2U068D0?T0U080Z`0R0P3j03430:/0@`80nP1S102[06DC0?T0U080/00S00<0
nP0a0;00AP2`04H00P2`04H20?X0H`@0/01X4`3i09@30?ooo`@0]@1700<0nP1S0;D0K02e06`00`2e
06`;0?T0U0/0l`310`3oool20?X0H`@0^P1^0P3i09@20;X0Ta40l`31103i0<D40?ooo`80_P1a0P3i
09@40;h0UQ<0n@352`350?<20<80V@P0n@35102M0<8>0<D0l`H0bP3i1`3oool50:00a@`0bP3i2`2E
0?<30?@0l@D0X`380P3:0?T507/0b0L0U@3c302I0?Wo0?oooaT0oooo001V0?ooo`0306IVIP3oool0
oooo00@0oooo00<0LP0F0?X0<@3j03400`3j03400`1b04@0IVIV0?T0U0030780F`@0n@350P1M0787
0<X0n@0306IVIP3:0?T0bP3i00`0bP3i00D0nP1S07d0BP1m04X0O@1:06IVIP0207d0H`040?T0a@1m
07`0O@1l07d0O0l0n@3g00<0IVIV0?T0m`3i0?L00`3i0?L208H0=@80nP1S00<0QP1@0?80T03b0900
303b09000`1VIVH0lP2@0?T0U0050?T0U0@0oooo00<0S`0L0?X0<@2?03P00P2?03P20?X0H`T0lP2@
00<0IVIV0000003b09002P3b09040?ooo`0309L07@3j0340nP0a00<0U`0l0P3j06<F0?<0T0<0oooo
0P2N01l409h0?P80nP1S0P2N05h50?<0T100n@2D00<0oooo0:D0802U02000P3j03430:D0@@80nP1S
0`2U068D0?T0U080Z`0R0P3j03430:/0@`80nP1S102[06DC0?T0U080/00S00<0nP0a0;00AP2`04H0
0P2`04H20?X0H`@0/01X4`3i09@30?ooo`@0]@1700<0nP1S0;D0K02e06`00`2e06`@0?T0U0D0l`31
0`3oool00`2j04T0nP1S0?X0H`040;X0KP80n@2D0P2j09<E0?<0`@@0oooo0P2n07420?T0U0@0_P2F
4`3i0<D50?ooo`D0a@3c0`3209T80?T0a@<0W@325@350?<30?T0a@@0oooo1@2P0<DA0<X0n@D0U@3c
103d0?450:<0b080bP3i101k0<P>09D0l`H0V@3io`3ooolI0?ooo`00I@3oool00`1VIVH0oooo0?oo
o`050?ooo`0307805P3j0340nP0a00<0nP0a00<0IVIV0780A03i09@00`1b05/40?T0a@80G@1b1P3:
0?T00`1VIVH0bP3i0<X0n@0=0<X0n@050?X0H`1m04X0O@1:07d0BP1VIVH00P1m06<0103i0<D0O@1l
07d0O01m07`>0?T0m`0306IVIP3i0?L0n@3g00@0n@3g0P2603D20?X0H`h0lP2@00<0IVIV0?80T03b
09001@3b09040?ooo`80S`0L00D0nP0a08l0>02?03P0S`0h0?X0H`090?80T00306IVIP3b09000000
00X0lP2@1@3oool00`2G01d0nP0a0?X0<@0309L0?080nP1S5@3c09040?ooo`0309h07`3j0340WP0n
00<0WP0n0P3j06<00`2N05h0l`2@0?<0T0090?<0T0/0n@2D00<0oooo0:D0802U02000P3j03430:D0
@@80nP1S0`2U068D0?T0U080Z`0R0P3j03430:/0@`80nP1S102[06DC0?T0U080/00S00<0nP0a0;00
AP2`04H00P2`04H20?X0H`@0/01X4`3i09@30?ooo`@0]@1700<0nP1S0;D0K02e06`00`2e06`B0?T0
U0D0oooo0P2j04T20?X0H`@0^P1^0P3i09@00`2j09<0l`310?<0`@0D0?<0`@<0oooo0`2n07420?T0
U0@0_P2F4`3i0<D80?ooo`D0`P2I203i0<D209d0`QH0a@3c1`3i0<D50:00a@D0a@3c3P3:0?T70?@0
l@D0X`380P3:0?T307/0b1D0U@3co`3ooolI0?ooo`00I@3oool00`1VIVH0oooo0?ooo`050?ooo`03
07805P3j0340nP0a0080nP0a00@0LP1406IVIP3i09@0n@2D0P1b05/40?T0a@<0G@1b1P3:0?T00`1V
IVH0bP3i0<X0n@0=0<X0n@040?X0H`1m04X0O@1:06IVIP<0O@1S00@0n@3507d0O01m07`0O@1l3P3i
0?L00`1VIVH0n@3g0?T0m`040?T0m`80QP0e0P3j06<>0?80T00306IVIP3b0900lP2@00D0lP2@103o
ool208l070040?X0<@2?03P0S`0h08l0>0H0nP1S103b09000`1VIVH0lP2@0000000:0?80T0D0oooo
00<0U`0M0?X0<@3j03400`2G03`00`3j06<0l`2@0?<0T00D0?<0T0@0oooo00<0WP0O0?X0<@2N03h0
0`2N03h20?X0H`0309h0GP3c0900l`2@00h0l`2@1P3i09@00`3oool0Y@0P0:D080020?X0<@<0Y@11
0P3j06<30:D0HQ@0n@2D0P2[02820?X0<@<0Z`130P3j06<40:/0IA<0n@2D0P2`02<00`3j0340/016
0;00AP020;00AP80nP1S102`06PC0?T0U0030?ooo`3j0340nP0a00@0]@1700<0nP1S0;D0K02e06`0
0`2e06`B0?T0U0D0oooo0P2j04T20?X0H`@0^P1^0P3i09@F0?<0`@<0oooo102n07420?T0U0@0_P2F
1`3c0<4<0?T0a@P0oooo1@3209T80?T0a@0309d0`P350?<0a@3c01@0a@3c203i0<D40:00a@/0a@3c
2@3:0?T70?@0l@D0X`380P3:0?T207/0b1H0U@3co`3ooolI0?ooo`00I@3oool00`1VIVH0oooo0?oo
o`050?ooo`0307805P3j0340nP0a0080nP0a00@0IVIV0780A03i09@0n@2D0P1b05/40?T0a@<0G@1b
1@3:0?T00`1VIVH0bP3i0<X0n@0>0<X0n@040?X0H`1m04X0O@1:06IVIP<0O@1S00<0n@3507d0O01m
07`03P3i0?L00`1VIVH0n@3g0?T0m`050?T0m`80QP0e00<0nP1S0?80T03b0900303b09000`1VIVH0
lP2@0?80T0050?80T0D0oooo0P2?01`0103j0340S`0h08l0>02?03P90?X0H`0406IVIP3j06<0lP2@
000000T0lP2@1P3oool00`2G01d0nP0a0?X0<@0209L0?0T0nP1S3P3c09050?ooo`0309h07`3j0340
WP0n00<0WP0n0P3j06<F0?<0T080oooo0P2U02020?X0<@<0Y@110P3j06<20:D0HQD0n@2D0P2[0282
0?X0<@<0Z`130P3j06<40:/0IA<0n@2D0P2`02<00`3j0340/0160;00AP020;00AP80nP1S102`06PC
0?T0U0030;D0903j0340nP0a00@0]@1700<0nP1S0;D0K02e06`00`2e06`B0?T0U0@0oooo0`2j04T2
0?X0H`@0^P1^1`3i09@@0?<0`@@0oooo102n07420?T0U0<0_P2F3P3c0<460?T0a@D0oooo00<0`P1c
0?T0U03i09@01@3209T80?T0aAH0a@3c2@3i0<D30:00aA40a@3c103:0?T40?ooo`<0m03a1@2S0<P2
0<X0n@0307/0b02E0?<0U@3c01@0U@3co`3ooolJ0?ooo`00I@3oool00`1VIVH0oooo0?ooo`050?oo
o`0307805P3j0340nP0a0080nP0a00@0IVIV0780A03i09@0n@2D0P1b05/40?T0a@<0G@1b1@3:0?T0
0`1VIVH0bP3i0<X0n@0>0<X0n@040?X0H`1m04X0O@1:06IVIP<0O@1S00<0n@3507d0O01m07`03P3i
0?L00`1VIVH0n@3g0?T0m`050?T0m`80QP0e1P3j06<90?80T00306IVIP3b0900lP2@00D0lP2@1@3o
ool208l070040?X0<@2?03P0S`0h08l0>0T0nP1S00@0IVIV0?X0H`3j06<000000`3j06<60?80T0H0
oooo00<0U`0M0?X0<@3j03400P2G03`@0?X0H`L0l`2@1@3oool00`2N01l0nP0a09h0?P0309h0?P80
nP1S5P3c09020?ooo`80Y@0P0P3j03430:D0@@80nP1S0P2U06850?<0T100n@2D0P2[02820?X0<@<0
Z`130P3j06<40:/0IA<0n@2D0P2`02<00`3j0340/0160;00AP020;00AP80nP1S102`06PC0?T0U003
0;D0903j0340nP0a00@0]@1700<0nP1S0;D0K02e06`00`2e06`B0?T0U0<0oooo102j04T20?X0H`@0
^P1^303i09@;0?<0`@@0oooo102n07420?T0U080_P2F5@3c0<440?ooo`80`P1c0P3i09@50<80V@l0
n@353P350?<00`3509`0n@350?T0a@070?T0a@80X0355P350?<70?ooo`D0X`380P3:0?TF09D0lol0
oooo6`3oool006D0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0<@3j0340IVIV0080
LP140P3i09@20780F`@0n@350`1M07840<X0n@0306IVIP3:0?T0bP3i00l0bP3i00@0nP1S07d0BP1V
IVH0n@2D0`1m06<00`3i0<D0O@1l07d0O00=0?T0m`0306IVIP3i0?L0n@3g00H0n@3g0P2603D;0?X0
H`<0lP2@00<0IVIV0?80T03b09001@3b09060?ooo`80S`0L00@0nP0a08l0>02?03P0S`0h203j06<0
1@1VIVH0nP1S0?X0H`3j06<0000000L0nP1S203oool00`2G01d0nP0a0?X0<@0209L0?1D0nP1S1`3o
ool00`2N01l0nP0a09h0?P0309h0?P030?X0H`3c0900l`2@01@0l`2@0`3oool20:D080030?X0<@2U
0440Y@110080Y@110P3j06<00`2U0680l`2@0?<0T0090?<0T0/0n@2D0P2[02820?X0<@<0Z`130P3j
06<40:/0IA<0n@2D0P2`02<00`3j0340/0160;00AP020;00AP80nP1S102`06PC0?T0U0030;D0903j
0340nP0a00@0]@1700<0nP1S0;D0K02e06`00`2e06`B0?T0U0<0oooo102j04T20?X0H`@0^P1^4@3i
09@50?<0`@<0oooo0P3j06<40;h0L@80n@2D0P2n09HE0?<0`@<0oooo0`3207<20?T0U0D0`P2I4P3i
0<D30?ooo`L0a@3c0P3509`90?T0a@030:00a@350?<0a@3c01@0a@3c203oool50:<0b0T0bP3i3P2E
0??o0?oooa`0oooo001U0?ooo`0306IVIP3oool0oooo00D0oooo00D0LP0F0?X0<@3j0340nP0a06IV
IP020780A080n@2D0P1b05/40?T0a@<0G@1b103:0?T00`1VIVH0bP3i0<X0n@0?0<X0n@040?X0H`1m
04X0IVIV0?T0U0<0O@1S00<0n@3507d0O01m07`03@3i0?L00`1VIVH0n@3g0?T0m`060?T0m`80QP0e
3P3j06<00`1VIVH0nP1S0?80T0050?80T0H0oooo0P2?01`0103j0340S`0h08l0>02?03P80?X0H`05
06IVIP3j06<0nP1S0?X0H`0000001`3j06<80?ooo`0309L07@3j0340nP0a0080U`0l503j06<80?oo
o`0309h07`3j0340WP0n00<0WP0n1P3j06<A0?<0T0<0oooo0P2U02000`3j0340Y@110:D0@@020:D0
@@80nP1S00<0Y@1R0?<0T03c09003P3c09060?T0U080Z`0R0P3j03430:/0@`80nP1S102[06DC0?T0
U080/00S00<0nP0a0;00AP2`04H00P2`04H20?X0H`@0/01X4`3i09@00`2e02@0nP0a0?X0<@040;D0
A`030?X0H`2e06`0]@1/00<0]@1/4P3i09@30?ooo`@0^P190P3j06<40;X0KQ<0n@2D1@3oool00`2n
04/0nP1S0?X0H`040;h0L@80n@2D00<0_P2F0?<0`@3c0<404`3c0<430?ooo`@0`P1c0P3i09@50<80
VA80n@35203oool40<D0W0T0n@355P350?<60?T0a@<0oooo1@2S0<P?0<X0n@L0U@3co`3ooolM0?oo
o`00I@3oool00`1VIVH0oooo0?ooo`050?ooo`@0nP0a00<0IVIV0780A01b04@00P3i09@20780F`@0
n@350`1M07830<X0n@0306IVIP3:0?T0bP3i0100bP3i00@0nP1S06IVIP1m04X0n@2D0`1m06<00`3i
0<D0O@1l07d0O00<0?T0m`0306IVIP3i0?L0n@3g00H0n@3g0`2603D=0?X0H`0306IVIP3j06<0nP1S
00@0nP1S203oool208l070040?X0<@2?03P0S`0h08l0>0L0nP1S00<0IVIV0?X0H`3j06<00P3j06<0
0`000000nP1S0?X0H`050?X0H`P0oooo00<0U`0M0?X0<@3j03400P2G03`D0?X0H`P0oooo00<0WP0O
0?X0<@2N03h00`2N03h;0?X0H`/0l`2@103oool20:D080030?X0<@2U0440Y@110080Y@110P3j06<F
0?<0T0030?ooo`2[0280Z`0R0080nP0a0`2[04<20?X0H`<0Z`1U503i09@20;008`030?X0<@2`04H0
/0160080/0160P3j06<40;00J1<0n@2D00<0]@0T0?X0<@3j0340102e04L00`3j06<0]@1/0;D0K003
0;D0K180n@2D0`3oool40;X0B@80nP1S102j06hC0?T0U0@0oooo0P2n04/20?X0H`@0_P1a0P3i09@E
0?<0`@<0oooo1@3207<20?T0U0D0`P2I1P3c0<4<0?T0a@P0oooo103509`@0?T0a@h0a@3c00<0b02N
0?T0a@3i0<D01`3i0<D50:<0b180bP3io`3ooolQ0?ooo`00I@3oool00`1VIVH0oooo0?ooo`050?oo
o`<0nP0a00@0IVIV0?X0<@1b04@0LP140P3i09@20780F`@0n@350P1M07840<X0n@0306IVIP3:0?T0
bP3i0100bP3i00@0nP1S06IVIP1m04X0n@2D0`1m06<00`3i0<D0O@1l07d0O00<0?T0m`0306IVIP3i
0?L0n@3g00H0n@3g0`2603D=0?X0H`0306IVIP3j06<0nP1S00@0nP1S203oool208l070040?X0<@2?
03P0S`0h08l0>0L0nP1S00D0IVIV0?X0H`3j06<0nP1S000000080?X0H`P0oooo00<0U`0M0?X0<@3j
03400P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03h@0?X0H`H0l`2@103oool20:D08003
0?X0<@2U0440Y@110080Y@110P3j06<F0?<0T0030?ooo`2[0280Z`0R0080nP0a0`2[04<20?X0H`<0
Z`1U1`3c090=0?T0U080/00S00<0nP0a0;00AP2`04H00P2`04H20?X0H`@0/01X4`3i09@00`2e02@0
nP0a0?X0<@040;D0A`030?X0H`2e06`0]@1/00<0]@1/4P3i09@00`3oool0nP0a0?X0<@040;X0B@80
nP1S102j06hC0?T0U0@0oooo0P2n04/20?X0H`@0_P1a2@3i09@>0?<0`@@0oooo103207<20?T0U0@0
`P2I3@3c0<460?T0a@D0oooo00<0a@1e0?T0U03i09@0103509`C0?T0a@<0oooo1`350?<20<P0WPT0
n@351@2S0<PB0<X0nOl0oooo8@3oool006D0oooo00<0IVIV0?ooo`3oool01@3oool30?X0<@0506IV
IP3j0340LP140780A03i09@00`1b05/40?T0a@80G@1b0`330?400`1VIVH0``3a0<<0l@020<<0l@l0
bP3i00@0IVIV07d0BP1m04X0n@2D0P1m06<0103i0<D0O@1l07d0O01m07`;0?T0m`0306IVIP3i0?L0
n@3g00L0n@3g0P2603D=0?X0H`0306IVIP3j06<0nP1S00D0nP1S203oool208l070030?X0<@2?03P0
S`0h00L0nP1S00<0IVIV0?X0H`3j06<00P3j06<00`000000nP1S0?X0H`060?X0H`P0oooo00<0U`0M
0?X0<@2G03`00P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hC0?X0H`L0oooo0P2U0200
0`3j0340Y@110:D0@@020:D0@@030?X0H`3c0900l`2@01@0l`2@0P3oool20:/08P80nP0a0`2[04<2
0?X0H`80Z`1U3P3c09070?T0U080/00S00<0nP0a0;00AP2`04H00P2`04H20?X0H`@0/01X4`3i09@0
0`2e02@0nP0a0?X0<@040;D0A`030?X0H`2e06`0]@1/00<0]@1/4P3i09@00`2j02@0nP0a0?X0<@04
0;X0B@80nP1S102j06hC0?T0U0<0oooo0`2n04/20?X0H`@0_P1a3`3i09@70?<0`@D0oooo103207<2
0?T0U0<0`P2I503c0<440?ooo`80a@1e0P3i09@40<D0W1<0n@352@3oool30<P0WPT0n@351@2S0<P6
0<D0l``0bP3io`3ooolQ0?ooo`00I@3oool00`1VIVH0oooo0?ooo`040?ooo`0407805P3j0340nP0a
06IVIP80nP0a0P1b04@0103i09@0LP1K0780F`1b05/40?T0a@0305d0LP330?40``3a0080``3a00<0
IVIV0<<0l@330?402@330?480<X0n@0406IVIP1m04X0O@1:0?T0U080O@1S00@0n@3507d0O01m07`0
O@1l2`3i0?L00`1VIVH0n@3g0?T0m`070?T0m`80QP0e3@3j06<00`1VIVH0nP1S0?X0H`050?X0H`80
IVIV1P3oool208l070030?X0<@2?03P0S`0h00L0nP1S00<0IVIV0?X0H`3j06<00P3j06<00`000000
nP1S0?X0H`060?X0H`P0oooo00<0U`0M0?X0<@2G03`00P2G03`D0?X0H`L0oooo0P2N01l00`3j0340
WP0n09h0?P0209h0?Q<0nP1S1`3oool20:D080030?X0<@2U0440Y@110080Y@111P3j06<@0?<0T0<0
oooo0P2[02820?X0<@<0Z`130P3j06<00`2[06D0l`2@0?<0T00C0?<0T0040?ooo`2`02<0/00S0?X0
<@@0/0160P3j06<30;00J1@0n@2D00<0]@0T0?X0<@3j0340102e04L00`3j06<0]@1/0;D0K0030;D0
K180n@2D00<0^P0T0?X0<@3j0340102j04T20?X0H`@0^P1^4`3i09@20?ooo`@0_P1;0P3j06<40;h0
LA<0n@2D203oool40<80L`80n@2D0P3209TE0?<0`@<0oooo0`3507D20?T0U0@0a@2L4`3i0<D80?oo
o`@0b02N2@3i0<D40:<0b0d0a@3c1P3:0?Wo0?ooob40oooo001U0?ooo`0306IVIP3oool0oooo00@0
oooo00@0LP0F0?X0<@3j0340IVIV0P3j03420780A0040?T0U01b05/0LP1K0780F`@0n@3500D0G@1b
0<<0l@330?40``3a06IVIP0C0<<0l@0506IVIP1m04X0O@1:07d0BP3i09@00P1m06<0103i0<D0O@1l
07d0O01m07`:0?T0m`0306IVIP3i0?L0n@3g00P0n@3g0P2603D<0?X0H`0306IVIP3j06<0nP1S00H0
nP1S0P3oool606IVIP80S`0L00<0nP0a08l0>02?03P01P3j06<00`1VIVH0nP1S0?X0H`030?X0H`03
0000003j06<0nP1S00H0nP1S203oool00`2G01d0nP0a09L0?00209L0?1@0nP1S1`3oool209h07`03
0?X0<@2N03h0WP0n0080WP0n4`3j06<70?ooo`80Y@0P00@0nP0a0:D0@@2U0440Y@11303j06<;0?<0
T0<0oooo0P2[02820?X0<@<0Z`130P3j06<00`2[06D0l`2@0?<0T00C0?<0T0040?ooo`2`02<0/00S
0?X0<@@0/0160P3j06<30;00J0D0l`2@3`3i09@00`2e02@0nP0a0?X0<@040;D0A`030?X0H`2e06`0
]@1/00<0]@1/4P3i09@00`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06hC0?T0U080oooo102n04/2
0?X0H`@0_P1a4`3i09@50?ooo`030<80C03j06<0nP1S00@0`P1c0P3i09@00`3209T0l`310?<0`@0C
0?<0`@@0oooo0`3507D20?T0U0@0a@2L4`3i0<D70?ooo`D0b02N2@3i0<D30:<0b1@0a@3co`3ooolQ
0?ooo`00I03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340IVIV00<0nP0a0P1b04@0103i
09@0LP1K0780F`1b05/40?T0a@@0``3a00<0IVIV0<<0l@330?404@330?401@1VIVH0O@1:07d0BP1m
04X0n@2D0080O@1S00@0n@3507d0O01m07`0O@1l2P3i0?L00`1VIVH0n@3g0?T0m`080?T0m`80QP0e
303j06<00`1VIVH0nP1S0?X0H`060?X0H`P0oooo0P2?01`00`3j0340S`0h08l0>0050?X0H`0306IV
IP3j06<0nP1S00@0nP1S00<000000?X0H`3j06<01P3j06<80?ooo`0309L07@3j0340U`0l0080U`0l
503j06<70?ooo`80WP0O00<0nP0a09h0?P2N03h00P2N03hC0?X0H`L0oooo00<0Y@0P0?X0<@3j0340
0`2U044A0?X0H`D0l`2@103oool20:/08P80nP0a0`2[04<20?X0HaD0l`2@0P3oool20;008`030?X0
<@2`04H0/0160080/0160P3j06<20;00J0/0l`2@2P3i09@00`2e02@0nP0a0?X0<@040;D0A`030?X0
H`2e06`0]@1/00<0]@1/4P3i09@00`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06hC0?T0U080oooo
102n04/20?X0H`@0_P1a4`3i09@40?ooo`80`P1<0P3j06<40<80L`80n@2D5@3c0<440?ooo`@0a@1e
0P3i09@40<D0W0L0l`31303i0<D70?ooo`D0b02N2@3i0<D20:<0b1D0a@3co`3ooolQ0?ooo`00I03o
ool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340IVIV0080nP0a0`1b04@00`3i09@0LP1K0780
F`050?T0a@@0``3a00<0IVIV0<<0l@330?4040330?400`1VIVH0nP1S07d0BP0207d0BP040?T0U01m
06<0O@1S0?T0a@<0O@1l2@3i0?L00`1VIVH0n@3g0?T0m`090?T0m`80QP0e2`3j06<00`1VIVH0nP1S
0?X0H`070?X0H`P0oooo0P2?01`00`3j0340S`0h08l0>0050?X0H`0306IVIP3j06<0nP1S00@0nP1S
00<000000?X0H`3j06<01P3j06<80?ooo`0309L07@3j0340U`0l0080U`0l503j06<70?ooo`80WP0O
00<0nP0a09h0?P2N03h00P2N03hC0?X0H`L0oooo00<0Y@0P0?X0<@3j03400`2U044E0?X0H`D0oooo
0P2[02820?X0<@<0Z`1300<0nP1S0?<0T03c0900503c09020?ooo`80/00S00<0nP0a0;00AP2`04H0
0P2`04H20?X0H`030;00J03c0900l`2@00l0l`2@1@3i09@00`2e02@0nP0a0?X0<@040;D0A`030?X0
H`2e06`0]@1/0080]@1/4`3i09@00`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06hC0?T0U080oooo
102n04/20?X0H`@0_P1a4`3i09@30?ooo`<0`P1<0P3j06<40<80L`P0n@2D3P3c0<440?ooo`D0a@1e
0P3i09@30<D0W0h0l`311P3i0<D70?ooo`D0b02N2@3i0<D00`2S0<P0a@3c0<D0l`0C0<D0lol0oooo
8P3oool006@0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0IVIV0?X0<@020?X0<@<0LP1400<0
n@2D0780F`1b05/0103i0<D40<<0l@0306IVIP330?40``3a0140``3a00<0IVIV0?X0H`1m04X00P1m
04X0103i09@0O@1S07d0H`3i0<D307d0O0T0n@3g00<0IVIV0?T0m`3i0?L02@3i0?L208H0=@/0nP1S
00<0IVIV0?X0H`3j06<01`3j06<80?ooo`80S`0L00<0nP0a08l0>02?03P0103j06<00`1VIVH0nP1S
0?X0H`050?X0H`030000003j06<0nP1S00H0nP1S203oool20?X0<@<0U`0l503j06<70?ooo`80WP0O
00<0nP0a09h0?P2N03h00P2N03hC0?X0H`H0oooo0P2U02020?X0<@<0Y@11503j06<60?ooo`80Z`0R
0P3j03430:/0@`P0nP1S3P3c09030?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04H20?X0H`030;00
J03c0900l`2@01@0l`2@00<0]@0T0?X0<@3j0340102e04L00`3j06<0]@1/0;D0K0020;D0K0D0l`2@
3P3i09@00`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06hC0?T0U080nP0a102n04/20?X0H`@0_P1a
4`3i09@30?ooo`<0`P1<0P3j06<40<80L`h0n@2D1`3c0<450?ooo`D0a@1e0P3i09@20<D0W1D0l`31
1@3oool20?T0U0D0b02N2@3i0<DE0<D0lol0oooo8`3oool006@0oooo00<0IVIV0?ooo`3oool01@3o
ool00`1b01H0IVIV0?X0<@020?X0<@80LP140P3i09@20780F`P0n@3500<0IVIV0?T0a@330?404033
0?400`1VIVH0nP1S0?X0H`0307d0BP<0O@1S00@0n@3507d0O01m07`0O@1l203i0?L00`1VIVH0n@3g
0?T0m`0:0?T0m`80QP0e2P3j06<00`1VIVH0nP1S0?X0H`080?X0H`P0oooo00<0S`0L0?X0<@2?03P0
0P2?03P40?X0H`0306IVIP3j06<0nP1S00D0nP1S00<000000?X0H`3j06<01P3j06<80?ooo`80nP0a
0`2G03`D0?X0H`L0oooo0P2N01l00`3j0340WP0n09h0?P0209h0?Q<0nP1S1P3oool20:D08080nP0a
0`2U044D0?X0H`H0oooo0P2[02820?X0<@<0Z`133`3j06<70?<0T0<0oooo0P2`02<00`3j0340/016
0;00AP020;00AP80nP1S5`3c09000`2e02@0nP0a0?X0<@040;D0A`040?X0H`2e06`0]@1/0;D0K0/0
l`2@2@3i09@00`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06hC0?T0U080nP0a102n04/20?X0H`@0
_P1a4`3i09@20?ooo`@0`P1<0P3j06<40<80La<0n@2D1`3oool50<D0M@80n@2D0P3509`E0?<0`@@0
oooo00<0b01g0?T0U03i09@01@3809h?0?T0a@h0a@3co`3ooolT0?ooo`00I03oool00`1VIVH0oooo
0?ooo`050?ooo`0306IVIP3j0340nP0a0080nP0a0P1b04@20?T0U080LP1K1`3i0<D00`1VIVH0n@35
0?T0a@050?T0a@`0``3a00<0IVIV0?X0H`3j06<00P1m04X01@3i09@0O@1S07d0H`1m06<0n@3500<0
O@1l203i0?L00`1VIVH0n@3g0?T0m`0:0?T0m`80QP0e2P3j06<00`1VIVH0nP1S0?X0H`080?X0H`P0
oooo00<0S`0L0?X0<@2?03P00P2?03P30?X0H`0306IVIP3j06<0nP1S00H0nP1S00<000000?X0H`3j
06<01P3j06<206IVIPD0oooo00<0U`0M0?X0<@3j03400`2G03`D0?X0H`L0oooo0P2N01l00`3j0340
WP0n09h0?P0209h0?Q<0nP1S1P3oool20:D08080nP0a0`2U044D0?X0H`H0oooo0P2[02820?X0<@<0
Z`13503j06<50?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04H00`3j06<0l`2@0?<0T00E0?<0T080
]@0T0P3j03440;D0A`030?X0H`2e06`0]@1/0140l`2@103i09@00`2j02@0nP0a0?X0<@040;X0B@80
nP1S102j06hC0?T0U080nP0a102n04/20?X0H`@0_P1a4`3i09@00`3oool0`P1<0<80C0030<80C080
nP1S103207<C0?T0U0L0oooo1@3507D20?T0U0030<D0W03c0<40l`3101<0l`31103oool20<P0M`80
n@2D1@3809hB0?T0a@<0oooo1`350??o0?ooobD0oooo001T0?ooo`0306IVIP3oool0oooo00D0oooo
00<0IVIV0?X0<@3j03400P3j03420780A080n@2D0P1b05/70?T0a@0306IVIP3i0<D0n@3500/0n@35
1@330?40101VIVH0O@0a0?X0H`3j06<207d0BP050?40S`1m06<0O@1S07d0H`3i0<D00P1m07`80?T0
m`0306IVIP3i0?L0n@3g00/0n@3g0P2603D90?X0H`0306IVIP3j06<0nP1S00T0nP1S1`3oool208l0
70040?X0<@2?03P0S`0h08l0>0<0nP1S00<0IVIV0?X0H`3j06<01P3j06<00`000000nP1S0?X0H`06
0?X0H`80oooo1@1VIVH00`2G01d0nP0a0?X0<@0309L0?1@0nP1S1`3oool209h07`030?X0<@2N03h0
WP0n0080WP0n4`3j06<60?ooo`80Y@0P0P3j03430:D0@A@0nP1S1P3oool20:/08P80nP0a0`2[04<D
0?X0H`D0oooo0P2`02<00`3j0340/0160;00AP020;00APH0nP1S4@3c09000`3oool0]@0T0;D09002
0?X0<@@0]@1700<0nP1S0;D0K02e06`05@3c09000`2j02@0nP0a0?X0<@040;X0B@80nP1S102j06h7
0?<0T0`0n@2D0P3j03440;h0B`80nP1S102n074C0?T0U080oooo103204`20?X0H`@0`P1c4`3i09@4
0?ooo`80a@1>00<0nP1S0<D0M@3507D00`3507D20?T0U1D0l`31103oool30<P0M`80n@2D1@3809hB
0?T0aOl0oooo;`3oool006@0oooo00<0IVIV0?ooo`3oool01@3oool00`1VIVH0nP0a0?X0<@020?X0
<@80LP140P3i09@20780F`H0n@3500<0IVIV0?T0a@3i0<D0303i0<D30?ooo`0407d0603j0340IVIV
07d0<@80nP1S00<0O@1:0?40S`3a08l00`1m06<00`3i0<D0O@1l07d0O0060?40kP80n@3g00<0IVIV
0?T0m`3i0?L02`3i0?L208H0=@P0nP1S00<0IVIV0?X0H`3j06<02P3j06<70?ooo`80S`0L00@0nP0a
08l0>02?03P0S`0h0P3j06<00`1VIVH0nP1S0?X0H`070?X0H`030000003j06<0nP1S00H0nP1S1`3o
ool00`2G01d0nP0a0?X0<@0309L0?1@0nP1S1`3oool209h07`040?X0<@2N03h0WP0n09h0?Q@0nP1S
1P3oool20:D08080nP0a0`2U044D0?X0H`H0oooo0P2[02820?X0<@<0Z`13503j06<50?ooo`80/00S
00<0nP0a0;00AP2`04H00P2`04H;0?X0H`/0l`2@0P3oool20;D09080nP0a102e04L00`3j06<0]@1/
0?<0T00E0?<0T0030;X0903j0340nP0a00@0^P190P3j06<30;X0KPh0l`2@1P3i09@20?X0<@@0_P1;
0P3j06<40;h0L@D0l`2@3P3i09@20?ooo`@0`P1<0P3j06<40<80La<0n@2D0`3oool30<D0CP030?X0
H`3507D0a@1e00<0a@1e203i09@>0?<0`@@0oooo103807L20?T0U0@0b02N1`3c0<4<0?T0aOl0oooo
;`3oool006@0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0nP0a0?X0<@030?X0<@80LP140P3i
09@20780F`H0n@3500<0IVIV0?T0a@3i0<D0303i0<D20?ooo`0307d0603j0340IVIV0080O@0a0P3j
06<00`1m04X0l@2?0?40S`0307d0H`030?T0a@1m07`0l@3^00L0l@3^00@0IVIV0?40kP3a0>h0l@3^
2`3i0?L208H0=@P0nP1S00<0IVIV0?X0H`3j06<02P3j06<70?ooo`80S`0L00@0nP0a08l0>02?03P0
S`0h0P3j06<00`1VIVH0nP1S0?X0H`070?X0H`030000003j06<0nP1S00H0nP1S1`3oool00`2G01d0
nP0a0?X0<@0309L0?1@0nP1S1`3oool209h07`040?X0<@2N03h0WP0n09h0?Q@0nP1S1P3oool20:D0
8080nP0a0`2U044D0?X0H`H0oooo0P2[02820?X0<@<0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00
AP2`04H00P2`04H@0?X0H`D0l`2@0`3oool20;D09080nP0a102e04L00`3j06<0l`2@0?<0T00D0?<0
T080^P0T0P3j03440;X0B@80nP1S0P2j06hE0?<0T080nP0a102n04/20?X0H`<0_P1a2`3c09090?T0
U080nP0a103204`20?X0H`@0`P1c4`3i09@20?ooo`@0a@1>00<0nP1S0<D0M@3507D00`3507D>0?T0
U0L0l`31103oool50<P0M`80n@2D0`3809h>0?<0`@H0n@35o`3oool_0?ooo`00I03oool00`1VIVH0
oooo0?ooo`040?ooo`0306IVIP3j0340nP0a00<0nP0a0P1b04@0103i09@0LP1K0780F`1b05/50?T0
a@0306IVIP3i0<D0n@3500d0n@350P3oool00`1m01P0nP0a06IVIP0207d0<@80nP1S0`3a08l307d0
H`030?T0a@1m07`0l@3^00L0l@3^00<0IVIV0?40kP3a0>h01P3a0>h60?T0m`80QP0e1`3j06<00`1V
IVH0nP1S0?X0H`0;0?X0H`L0oooo0P2?01`01P3j0340S`0h08l0>02?03P0nP1S06IVIPX0nP1S00<0
00000?X0H`3j06<01P3j06<70?ooo`0309L07@3j0340nP0a00<0U`0l503j06<70?ooo`80WP0O00@0
nP0a09h0?P2N03h0WP0n503j06<60?ooo`80Y@0P0P3j03430:D0@A@0nP1S1P3oool20:/08P80nP0a
0`2[04<C0?X0H`H0oooo0P2`02<00`3j0340/0160;00AP020;00AQ<0nP1S1@3oool20;D09080nP0a
102e04L60?X0Ha00l`2@00<0oooo0;X0902j02@00P3j03440;X0B@80nP1S0P2j06hE0?<0T080nP0a
102n04/20?X0H`80_P1a4@3c09040?T0U080nP0a103204`20?X0H`@0`P1c4`3i09@00`3oool0a@1>
0<D0CP030<D0CP030?X0H`3507D0a@1e00<0a@1e4P3i09@70?ooo`D0b01g0P3i09@20<P0WQD0l`31
o`3oool_0?ooo`00I03oool00`1VIVH0oooo0?ooo`030?ooo`0306IVIP3oool0nP0a00@0nP0a0P1b
04@0103i09@0LP1K0780F`1b05/50?T0a@0306IVIP3i0<D0n@3500d0n@350P3oool00`1m01P0IVIV
07d0<@0207d0<@80nP1S0`3a08l307d0H`030?T0a@3a0>h0l@3^00H0l@3^00<0IVIV0?40kP3a0>h0
303a0>h308H0=@L0nP1S00<0IVIV0?X0H`3j06<02`3j06<70?ooo`80S`0L00H0nP0a08l0>02?03P0
S`0h0?X0H`1VIVH:0?X0H`030000003j06<0nP1S00H0nP1S1`3oool00`2G01d0nP0a0?X0<@0309L0
?1@0nP1S1`3oool209h07`040?X0<@2N03h0WP0n09h0?Q@0nP1S1P3oool20:D08080nP0a0`2U044D
0?X0H`H0oooo0P2[02820?X0<@<0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC
0?X0H`D0oooo0P2e02@20?X0<@@0]@172`3j06<;0?<0T0030?ooo`2j02@0^P0T0080nP0a102j04T2
0?X0H`030;X0KP3c0900l`2@01<0l`2@00<0_P0U0?X0<@3j0340102n04/20?X0H`80_P1a5@3c0902
0?X0<@@0`P1<0P3j06<40<80La<0n@2D1P3504h00`3j06<0a@1e0<D0M@030<D0MA80n@2D1`3oool5
0<P0M`80n@2D00<0b02N0?<0`@3c0<40503c0<7o0?ooobl0oooo001T0?ooo`0306IVIP3oool0oooo
00<0oooo00<0IVIV07805P3j0340103j03420780A0040?T0U01b05/0LP1K0780F`@0n@3500<0IVIV
0?T0a@3i0<D03P3i0<D20?ooo`0307d0601VIVH0O@0a0080O@0a00<0nP1S0?40S`3a08l00P3a08l3
07d0H`030?T0a@3a0>h0l@3^00H0l@3^00<0IVIV0?40kP3a0>h0303a0>h308H0=@H0nP1S00<0IVIV
0?X0H`3j06<02`3j06<80?ooo`80S`0L00D0nP0a08l0>02?03P0S`0h06IVIP0;0?X0H`030000003j
06<0nP1S00H0nP1S1`3oool00`2G01d0nP0a0?X0<@0309L0?1@0nP1S0P1VIVH50?ooo`80WP0O00@0
nP0a09h0?P2N03h0WP0n503j06<60?ooo`80Y@0P0P3j03430:D0@A@0nP1S1P3oool20:/08P030?X0
<@2[04<0Z`130080Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo
0P2e02@20?X0<@@0]@17403j06<50?<0T080oooo0P2j02@20?X0<@@0^P190P3j06<E0?<0T080_P0U
0P3j03440;h0B`80nP1S00<0_P1a0?<0T03c0900503c09020?X0<@@0`P1<0P3j06<40<80La<0n@2D
00<0oooo0<D0CP3504h00`3504h00`3j06<0a@1e0<D0M@030<D0MA80n@2D1@3oool00`3804l0nP1S
0<P0M`040<P0M`80n@2D5P3c0<7o0?oooc00oooo001T0?ooo`0306IVIP3oool0oooo0080oooo00<0
IVIV0?ooo`1b01H01@3j03420780A0040?T0U01b05/0LP1K0780F`@0n@3500<0IVIV0?T0a@3i0<D0
3P3i0<D20?ooo`0306IVIP3j0340O@0a0080O@0a1@3j06<207d0H`030?T0a@3a0>h0l@3^00H0l@3^
00<0IVIV0?40kP3a0>h0303a0>h0103j0340QP0e08H0=@2603D60?X0H`0306IVIP3j06<0nP1S00@0
nP1S1@0000020?X0H`@00000103oool300000080S`0h00<0IVIV0?X0H`3j06<02P3j06<00`000000
nP1S0?X0H`060?X0H`L0oooo00<0U`0M0?X0<@3j03400P2G03`E0?X0H`80oooo1@1VIVH209h07`04
0?X0<@2N03h0WP0n09h0?Q@0nP1S1P3oool20:D08080nP0a0`2U044D0?X0H`H0oooo0P2[02800`3j
0340Z`130:/0@`020:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0/0160080/0164`3j06<50?oo
o`80]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04T80?X0H`h0l`2@00<0oooo0;h0
9@2n02D00P3j03440;h0B`80nP1S5P3c09000`3202H0nP0a0?X0<@040<80C080nP1S103207<70?<0
T0`0n@2D00<0oooo0<D0CP3504h00`3504h00`3j06<0a@1e0<D0M@030<D0MA80n@2D103oool20<P0
C`030?X0H`3807L0b01g00<0b01g1`3i09@@0?<0`Ol0oooo<@3oool006<0oooo00<0IVIV0?ooo`3o
ool00`3oool00`1VIVH0oooo07805P050?X0<@80LP1400@0n@2D0780F`1b05/0LP1K0`3i0<D00`1V
IVH0n@350?T0a@0?0?T0a@80oooo00<0IVIV0?X0<@1m03400P1m03450?X0H`80O@1S1`3i0<D20?40
kP0306IVIP3a0>h0l@3^00`0l@3^00<0nP0a08H0=@2603D01P3j06<00`1VIVH0nP1S0?X0H`070?X0
H`050000003j06<0nP1S0?X0H`000000103oool010000000oooo0?ooo`00000208l070040?X0<@00
0000S`0h06IVIP`0nP1S00<000000?X0H`3j06<01P3j06<70?ooo`0309L07@3j0340nP0a0080U`0l
5@3j06<70?ooo`80WP0O00@0nP0a09h0?P2N03h0WP0n503j06<60?ooo`80Y@0P0P3j03430:D0@A@0
nP1S1P3oool20:/08P030?X0<@2[04<0Z`130080Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`
04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0B@h0
nP1S1`3c09020?ooo`80_P0U0P3j03440;h0B`L0nP1S403c09020<809P80nP0a103204`20?X0H`<0
`P1c3P3c09060?T0U0030?ooo`3504h0a@1>00<0a@1>00<0nP1S0<D0M@3507D00`3507DB0?T0U0<0
oooo0`3804l00`3j06<0b01g0<P0M`030<P0M`/0n@2D2`3c0<7o0?oooc80oooo001S0?ooo`0306IV
IP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0LP0F103j03430780A0030?T0U01b05/0LP1K00@0
n@3500<0IVIV0?T0a@3i0<D03`3i0<D0103oool0IVIV07d0603j034307d0<@D0nP1S0P1m06<80?T0
a@0406IVIP3i0<D0n@350?T0a@/0l@3^00@0QP0J0?X0<@2603D0QP0e1P3j06<00`1VIVH0nP1S0?X0
H`070?X0H`030000003j06<0nP1S0080nP1S103oool010000000oooo0?ooo`00000208l070040?X0
<@000000IVIV08l0>0`0nP1S00<000000?X0H`3j06<01P3j06<70?ooo`0309L07@3j0340nP0a0080
U`0l5@3j06<70?ooo`0309h07`3j0340WP0n00<0WP0n503j06<60?ooo`80Y@0P0P3j03430:D0@A@0
nP1S1P3oool20:/08P030?X0<@2[04<0Z`130080Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`
04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0
nP1S103oool20;h09@80nP0a102n04/;0?X0H`/0l`2@00<0oooo0<809P3202H00P3j03440<80C080
nP1S0P3207<E0?<0T0030?X0<@3504h0a@1>00<0a@1>00<0nP1S0<D0M@3507D00`3507DB0?T0U080
oooo103804l00`3j06<0b01g0<P0M`030<P0Ma00n@2D1@3c0<7o0?oooc<0oooo001S0?ooo`0306IV
IP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0LP0F103j03430780A0030?T0U01b05/0LP1K00@0
n@3500<0IVIV0?T0a@3i0<D03`3i0<D0103oool0IVIV07d0603j034307d0<@D0nP1S0P1m06<80?T0
a@0306IVIP3i0<D0n@3500H0n@351P3a0>h0102601X0nP0a08H0=@2603D50?X0H`0306IVIP3j06<0
nP1S00P0nP1S00<000000?X0H`3j06<00P3j06<40?ooo`040000003oool0oooo00000080S`0L00@0
nP0a0000001VIVH0S`0h2`3j06<00`000000nP1S0?X0H`060?X0H`P0oooo00<0U`0M0?X0<@3j0340
0P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hD0?X0H`H0oooo0P2U02020?X0<@<0Y@11
503j06<60?ooo`80Z`0R00<0nP0a0:/0@`2[04<00P2[04<C0?X0H`H0oooo0P2`02<00`3j0340/016
0;00AP020;00AQ<0nP1S1@3oool20;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P19
4`3j06<40?ooo`80_P0U0P3j03440;h0Ba00nP1S1@3c09020?ooo`80`P0V0P3j03440<80C080nP1S
0P3207<E0?<0T0030?X0<@3504h0a@1>00<0a@1>00<0nP1S0<D0M@3507D00`3507DB0?T0U0030?oo
o`3804l0b01?00<0b01?00<0nP1S0<P0M`3807L00`3807LB0?T0U?l0oooo=P3oool006<0oooo00<0
IVIV0?ooo`3oool00P3oool0101VIVH0oooo0?ooo`1b01H40?X0<@80LP140P3i09@20780F`<0n@35
00<0IVIV0?T0a@3i0<D0403i0<D0101VIVH0oooo07d0603j034207d0<@H0nP1S0P1m06<70?T0a@03
06IVIP3i0<D0n@3500/0n@3500@0oooo08H06P2601X0nP0a0P2603D50?X0H`0306IVIP3j06<0nP1S
00P0nP1S00<000000?X0H`3j06<00P3j06<4000000<0oooo00H0000008l0702?01`0nP0a0000002?
03P<0?X0H`030000003j06<0nP1S00H0nP1S203oool00`2G01d0nP0a0?X0<@0209L0?1@0nP1S203o
ool00`2N01l0nP0a09h0?P0309h0?Q@0nP1S1P3oool20:D08080nP0a0`2U044D0?X0H`H0oooo0P2[
02800`3j0340Z`130:/0@`020:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0/0160080/0164`3j
06<50?ooo`80]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n
02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C080nP1S00<0`P1c0?<0T03c09004`3c
09020?X0<@D0a@1>00<0nP1S0<D0M@3507D00`3507D50?<0T0d0n@2D1P3804l00`3j06<0b01g0<P0
M`030<P0Ma80n@2Do`3ooolf0?ooo`00H`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00<0
LP0F0?X0<@3j03400P3j03420780A080n@2D0P1b05/30?T0a@0306IVIP3i0<D0n@350100n@3500@0
IVIV0?ooo`1m01P0nP0a0P1m03460?X0H`80O@1S1`3i0<D00`1VIVH0n@350?T0a@0;0?T0a@040?oo
o`2601X0QP0J0?X0<@80QP0e103j06<00`1VIVH0nP1S0?X0H`090?X0H`030000003j06<0nP1S0080
nP1S00<000000?ooo`3oool0103oool01P000000S`0L08l0703j0340000008l0>0`0nP1S00<00000
0?X0H`3j06<01P3j06<80?ooo`0309L07@3j0340nP0a0080U`0l503j06<80?ooo`0309h07`3j0340
WP0n00<0WP0n503j06<306IVIP<0oooo0P2U02020?X0<@<0Y@11503j06<60?ooo`030:/08P3j0340
nP0a00@0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@2
0?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C
0?X0H`@0oooo0P3202H20?X0<@@0`P1<0P3j06<E0?<0T0030<D09`3j0340nP0a00D0a@1>00<0nP1S
0<D0M@3507D00P3507D:0?<0T0T0n@2D00<0oooo0<P0C`3804l00`3804l00`3j06<0b01g0<P0M`03
0<P0Ma80n@2Do`3ooolf0?ooo`00H`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00<0LP0F
0?X0<@3j03400P3j03420780A080n@2D0P1b05/20?T0a@0306IVIP3i0<D0n@350140n@3500@0IVIV
0?ooo`1m01P0nP0a0P1m03450?X0H`<0O@1S1P3i0<D00`1VIVH0n@350?T0a@0<0?T0a@040?ooo`26
01X0QP0J0?X0<@80QP0e103j06<00`1VIVH0nP1S0?X0H`090?X0H`030000003j06<0nP1S0080nP1S
00<000000?ooo`3oool0103oool01P000000S`0L08l0701VIVH0000008l0>0`0nP1S100000050?X0
H`P0oooo00<0U`0M0?X0<@2G03`00P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hD0?X0
H`<0oooo0`1VIVH20:D080030?X0<@2U0440Y@110080Y@11503j06<60?ooo`030:/08P3j0340nP0a
00@0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0
<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0
H`@0oooo0P3202H20?X0<@@0`P1<203j06<>0?<0T080a@0W0P3j03450<D0CP040?X0H`3507D0a@1e
0<D0MA00l`2@103i09@00`3oool0b01?0<P0C`030<P0C`030?X0H`3807L0b01g00<0b01g4P3i09Co
0?ooocH0oooo001S0?ooo`0406IVIP3oool0oooo06IVIP@0oooo00<0LP0F0?X0<@3j03400P3j0342
0780A080n@2D0P1b05/20?T0a@0306IVIP3i0<D0n@350100n@3500D0IVIV0?ooo`3oool0O@0H0?X0
<@0207d0<@D0nP1S0`1m06<60?T0a@0306IVIP3i0<D0n@3500`0n@3500<0oooo08H06P2601X00`26
03D30?X0H`0306IVIP3j06<0nP1S00P0nP1S0`0000040?X0H`030000003oool0oooo00@0oooo00H0
000008l0702?01`0IVIV0000002?03P<0?X0H`040000003j06<0nP1S0?X0H`<000000P3j06<80?oo
o`0309L07@3j0340U`0l0080U`0l503j06<80?ooo`0309h07`3j0340WP0n00<0WP0n503j06<60?oo
o`80Y@0P00<0nP0a0:D0@@2U04400P2U044D0?X0H`H0oooo00<0Z`0R0?X0<@3j0340102[04<C0?X0
H`H0oooo0P2`02<00`3j0340/0160;00AP020;00AQ<0nP1S1@3oool20;D09080nP0a102e04LB0?X0
H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?ooo`80_P0U0P3j03440;h0Ba<0nP1S103oool20<80
9P80nP0a103204`>0?X0H`L0l`2@00<0oooo0<D09`3502L00P3j03450<D0CP030?X0H`3507D0a@1e
01D0l`2@00<0nP0a0<P0C`3804l00`3804l00`3j06<0b01g0<P0M`030<P0Ma80n@2Do`3ooolf0?oo
o`00H`3oool0101VIVH0oooo0?ooo`1VIVH40?ooo`D0nP0a0P1b04@20?T0U080LP1K00<0n@3506IV
IP3i0<D04P3i0<D01@1VIVH0oooo0?ooo`1m01P0nP0a0080O@0a1@3j06<307d0H`D0n@3500<0IVIV
0?T0a@3i0<D03@3i0<D00`3oool0QP0J0?X0<@0308H0=@<0nP1S00<0IVIV0?X0H`3j06<02P3j06<0
0`000000nP1S0?X0H`020?X0H`D000000`3oool300000080S`0h303j06<00`000000nP1S0?X0H`06
0?X0H`P0oooo00<0U`0M0?X0<@2G03`00P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hD
0?X0H`H0oooo0P2U02000`3j0340Y@110:D0@@020:D0@A@0nP1S1P3oool00`2[0280nP0a0?X0<@04
0:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0/0160080/0164`3j06<50?ooo`80]@0T0P3j0344
0;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<4
0?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504h00`3j06<0a@1e0?<0T00D
0?<0T080nP0a1@3804l00`3j06<0b01g0<P0M`030<P0M`D0l`2@3@3i09Co0?ooocH0oooo001S0?oo
o`0306IVIP3oool0IVIV00D0oooo1@3j03420780A0060?T0U01b05/0LP1K0780F`3i0<D0IVIV4P3i
0<D0101VIVH0oooo0?ooo`1m01P20?X0<@80O@0a1@3j06<307d0H`D0n@3500<0IVIV0?T0a@3i0<D0
3@3i0<D00`3oool0QP0J0?X0<@0308H0=@80nP1S00<0IVIV0?X0H`3j06<0403j06<80?ooo`0308l0
701VIVH0nP0a0080S`0h303j06<00`000000nP1S0?X0H`060?X0H`P0oooo00<0U`0M0?X0<@2G03`0
0P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hD0?X0H`H0oooo0P2U02000`3j0340Y@11
0:D0@@020:D0@A@0nP1S1P3oool00`2[0280nP0a0?X0<@040:/0@a<0nP1S1P3oool20;008`030?X0
<@2`04H0/0160080/0164`3j06<50?ooo`80]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a
102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S
0`3oool20<D09`80nP0a1@3504h00`3j06<0l`2@0?<0T00C0?<0T0030<P09`3j0340nP0a00D0b01?
00<0nP1S0<P0M`3807L00P3807L:0?<0T0T0n@2Do`3ooolf0?ooo`00H`3oool00`1VIVH0oooo06IV
IP050?ooo`D0nP0a0P1b04@01@3i09@0LP1K0780F`1b05/0IVIV01<0n@3500D0IVIV0?ooo`3oool0
O@0H0?X0<@0307d0<@D0nP1S0`1m06<40?T0a@0306IVIP3i0<D0n@3500h0n@3500<0oooo08H06P3j
03400`2603D20?X0H`0306IVIP3j06<0nP1S0100nP1S1`3oool00`2?01`0IVIV0?X0<@0308l0>0`0
nP1S00<000000?X0H`3j06<01P3j06<80?ooo`0309L07@3j0340U`0l0080U`0l503j06<80?ooo`03
09h07`3j0340WP0n00<0WP0n503j06<60?ooo`80Y@0P00<0nP0a0:D0@@2U04400P2U044D0?X0H`H0
oooo00<0Z`0R0?X0<@3j0340102[04<C0?X0H`H0oooo0P2`02<00`3j0340/0160;00AP020;00AQ<0
nP1S1@3oool20;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?ooo`80
_P0U0P3j03440;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0<@D0
a@1>1`3j06<>0?<0T080b00W0P3j03450<P0C`040?X0H`3807L0b01g0<P0Ma00l`2@103i09Co0?oo
ocH0oooo001S0?ooo`80IVIV1@3oool00`1b01H0nP0a0?X0<@030?X0<@80LP1400D0n@2D0780F`1b
05/0LP1K06IVIP0B0?T0a@0606IVIP3i0<D0oooo0?ooo`1m01P0nP0a0`1m03450?X0H`<0O@1S103i
0<D00`1VIVH0n@350?T0a@0>0?T0a@030?ooo`2601X0nP0a00<0QP0e00<0nP1S06IVIP3j06<04P3j
06<70?ooo`0308l0701VIVH0nP0a00<0S`0h303j06<00`000000nP1S0?X0H`060?X0H`P0oooo00<0
U`0M0?X0<@2G03`00P2G03`D0?X0H`P0oooo00<0WP0O0?X0<@2N03h00`2N03hD0?X0H`H0oooo0P2U
02000`3j0340Y@110:D0@@020:D0@A@0nP1S0`1VIVH30?ooo`030:/08P3j0340nP0a00@0Z`134`3j
06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j
06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0H`@0oooo0P32
02H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0CPd0nP1S1`3c09000`3oool0b00W0<P0
9`020?X0<@D0b01?00<0nP1S0<P0M`3807L05@3c093o0?ooocH0oooo001R0?ooo`0306IVIP3oool0
IVIV00D0oooo00<0LP0F0?X0<@3j03400`3j03420780A0040?T0U01b05/0LP1K06IVIQ<0n@3500H0
IVIV0?T0a@3oool0oooo07d0603j034307d0<@D0nP1S0`1m06<30?T0a@0306IVIP3i0<D0n@3500l0
n@350P2601X01P3j0340QP0e08H0=@2603D0nP1S06IVIQ<0nP1S1`3oool00`1VIVH0S`0L0?X0<@03
08l0>0`0nP1S00<000000?X0H`3j06<01P3j06<80?ooo`80nP0a0`2G03`D0?X0H`P0oooo00<0WP0O
0?X0<@2N03h00`2N03hD0?X0H`H0oooo0P2U02000`3j0340Y@110:D0@@020:D0@A@0nP1S0`3oool3
06IVIP030:/08P3j0340nP0a00@0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC
0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool2
0;h09@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j0345
0<D0CQ80nP1S0`3oool20<P09`80nP0a1@3804l00`3j06<0b01g0?<0T00D0?<0T?l0oooo=`3oool0
0680oooo0P1VIVH60?ooo`0307805P3j0340nP0a0080nP0a0`1b04@0103i09@0LP1K0780F`1VIVHB
0?T0a@0306IVIP3i0<D0n@350080oooo00<0O@0H0?X0<@1m03400P1m03450?X0H`<0O@1S0`3i0<D0
0`1VIVH0n@350?T0a@0?0?T0a@80QP0J00D0nP0a08H0=@2603D0QP0e06IVIP0D0?X0H`H0oooo00@0
IVIV08l0702?01`0nP0a0`2?03P<0?X0H`030000003j06<0nP1S00H0nP1S1`3oool00`2G01d0nP0a
0?X0<@0309L0?1@0nP1S203oool00`2N01l0nP0a09h0?P0309h0?Q@0nP1S1P3oool20:D080030?X0
<@2U0440Y@110080Y@11503j06<60?ooo`030:/08P3j0340nP0a00@0Z`134`3j06<60?ooo`80/00S
00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T
0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0<@@0`P1<
4`3j06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool20<P09`80nP0a1@3804l00`3j06<0l`2@
0?<0T00C0?<0T?l0oooo>03oool00680oooo101VIVH40?ooo`0307805P3j0340nP0a0080nP0a0`1b
04@00`3i09@0LP1K06IVIP0C0?T0a@0306IVIP3i0<D0n@350080oooo00<0O@0H0?X0<@1m03400P1m
03450?X0H`80O@1S0`3i0<D00`1VIVH0n@350?T0a@0@0?T0a@80QP0J00D0nP0a08H0=@2603D0QP0e
06IVIP0D0?X0H`H0oooo00@0IVIV08l0702?01`0nP0a0`2?03P<0?X0H`030000003j06<0nP1S00H0
nP1S1`3oool00`2G01d0nP0a0?X0<@0309L0?1@0nP1S203oool00`2N01l0nP0a09h0?P0309h0?Q@0
nP1S1P3oool20:D080030?X0<@2U0440Y@110080Y@11503j06<60?ooo`030:/08P3j0340nP0a00@0
Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0
]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0H`@0
oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool20<P09`80
nP0a1@3804l70?X0H`h0l`2@o`3oooli0?ooo`00HP3oool0101VIVH0oooo0?ooo`3oool406IVIP03
07805P3j0340nP0a0080nP0a0`1b04@00`3i09@0LP1K06IVIP0B0?T0a@0406IVIP3i0<D0n@350?T0
a@80oooo00<0O@0H0?X0<@1m03400P1m03450?X0H`80O@1S0`3i0<D00`1VIVH0n@350?T0a@0@0?T0
a@80QP0J00@0nP0a08H0=@2603D0IVIV5@3j06<50?ooo`0506IVIP3oool0S`0L08l0703j03400`2?
03P<0?X0H`030000003j06<0nP1S00H0nP1S1`3oool00`2G01d0nP0a0?X0<@0309L0?1@0nP1S203o
ool00`2N01l0nP0a09h0?P0309h0?Q@0nP1S1P3oool20:D080030?X0<@2U0440Y@110080Y@11503j
06<60?ooo`030:/08P3j0340nP0a00@0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`
04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103o
ool20;h09@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j
03450<D0CQ80nP1S0`3oool20<P09`80nP0a1@3804l=0?X0H`L0l`2@o`3ooolj0?ooo`00HP3oool0
0`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a0080nP0a0P1b04@20?T0U00306IVIP1b05/0
n@350140n@3500@0IVIV0?T0a@3i0<D0n@350P3oool00`1m01P0nP0a07d0<@0207d0<@D0nP1S0P1m
06<20?T0a@0306IVIP3i0<D0n@350100n@3500@0oooo08H06P2601X0nP0a0P2603D00`1VIVH0nP1S
0?X0H`0B0?X0H`H0oooo00D0IVIV0?ooo`2?01`0S`0L0?X0<@0308l0>0`0nP1S00<000000?X0H`3j
06<01P3j06<70?ooo`0309L07@3j0340nP0a00<0U`0l503j06<70?ooo`80WP0O00<0nP0a09h0?P2N
03h00P2N03hD0?X0H`H0oooo0P2U02000`3j0340Y@110:D0@@020:D0@A@0nP1S1P3oool00`2[0280
nP0a0?X0<@040:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0/0160080/0164`3j06<50?ooo`80
]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0
_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0
oooo0P3802L20?X0<@D0b01?4P3j06?o0?oooc`0oooo001R0?ooo`0306IVIP3oool0oooo00D0oooo
00<0LP0F0?X0<@3j03400P3j03420780A080n@2D00<0IVIV0780F`3i0<D0403i0<D00`1VIVH0n@35
0?T0a@020?T0a@80oooo00@0O@0H0?X0<@1m0340O@0a1P3j06<207d0H`80n@3500<0IVIV0?T0a@3i
0<D0403i0<D01P3oool0QP0J08H06P3j0340QP0e06IVIQD0nP1S1@3oool00`1VIVH0oooo0?ooo`02
08l070040?X0<@2?03P0S`0h08l0>0`0nP1S00<000000?X0H`3j06<01P3j06<70?ooo`0309L07@3j
0340nP0a00<0U`0l503j06<70?ooo`80WP0O00<0nP0a09h0?P2N03h00P2N03hD0?X0H`H0oooo00<0
Y@0P0?X0<@3j0340102U044D0?X0H`H0oooo00<0Z`0R0?X0<@3j0340102[04<C0?X0H`@0IVIV0P3o
ool20;008`030?X0<@2`04H0/0160080/0164`3j06<50?ooo`80]@0T0P3j03440;D0Aa80nP1S1@3o
ool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j
03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0<@D0b01?4P3j
06?o0?oooc`0oooo001R0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j0342
0780A080n@2D00<0IVIV0780F`3i0<D0403i0<D00`1VIVH0n@350?T0a@020?T0a@80oooo00@0O@0H
0?X0<@1m0340O@0a1P3j06<207d0H`030?T0a@1VIVH0n@350180n@3500H0oooo08H06P2601X0nP0a
08H0=@1VIVHE0?X0H`D0oooo00<0IVIV0?ooo`3oool00P2?01`0103j0340S`0h08l0>02?03P<0?X0
H`030000003j06<0nP1S00H0nP1S1`3oool00`2G01d0nP0a0?X0<@0309L0?1@0nP1S1`3oool209h0
7`030?X0<@2N03h0WP0n0080WP0n503j06<60?ooo`030:D0803j0340nP0a00@0Y@11503j06<60?oo
o`030:/08P3j0340nP0a00@0Z`134`3j06<40?ooo`80IVIV0P2`02<00`3j0340/0160;00AP020;00
AQ<0nP1S1@3oool20;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?oo
o`80_P0U0P3j03440;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0
<@D0a@1>4P3j06<30?ooo`80b00W0P3j03450<P0Ca80nP1So`3oooll0?ooo`00HP3oool00`1VIVH0
oooo0?ooo`050?ooo`0307805P3j0340nP0a0080nP0a0P1b04@0103i09@0IVIV0780F`1b05/@0?T0
a@0306IVIP3i0<D0n@3500<0n@350P3oool0101m01P0nP0a07d0<@1m03460?X0H`80O@1S00<0n@35
06IVIP3i0<D04P3i0<D01P3oool0QP0J08H06P3j0340IVIV08H0=AD0nP1S103oool0101VIVH0oooo
0?ooo`3oool208l070040?X0<@2?03P0S`0h08l0>0`0nP1S00<000000?X0H`3j06<01P3j06<70?oo
o`0309L07@3j0340nP0a00<0U`0l503j06<70?ooo`80WP0O00<0nP0a09h0?P2N03h00P2N03hD0?X0
H`D0oooo0P2U02020?X0<@@0Y@11503j06<60?ooo`030:/08P3j0340nP0a00@0Z`134`3j06<60?oo
o`80/00S00<0nP0a0;00AP2`04H00P2`04HC0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?oo
o`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0
<@@0`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool20<P09`80nP0a1@3804lB0?X0
Hol0oooo?03oool00680oooo00<0IVIV0?ooo`3oool01@3oool50?X0<@80LP1400@0n@2D06IVIP1b
05/0LP1K403i0<D00`1VIVH0n@350?T0a@030?T0a@80oooo00@0O@0H0?X0<@1m0340O@0a1@3j06<3
07d0H`0306IVIP3i0<D0n@350180n@3500H0oooo08H06P2601X0nP0a06IVIP2603DE0?X0H`@0oooo
00@0IVIV0?ooo`3oool0oooo0P2?01`0103j0340S`0h08l0>02?03P<0?X0H`030000003j06<0nP1S
00H0nP1S1`3oool00`2G01d0nP0a0?X0<@0209L0?1D0nP1S1`3oool209h07`040?X0<@2N03h0WP0n
09h0?QD0nP1S1@3oool20:D08080nP0a102U044D0?X0H`H0oooo00<0Z`0R0?X0<@3j0340102[04<C
0?X0H`H0oooo0P2`02<00`3j0340/0160;00AP020;00AQ<0nP1S1@3oool20;D09080nP0a102e04LB
0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?ooo`80_P0U0P3j03440;h0Ba<0nP1S103oool2
0<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0<@D0a@1>4P3j06<30?ooo`80b00W0P3j0345
0<P0Ca80nP1So`3oooll0?ooo`00HP3oool00`1VIVH0oooo0?ooo`050?ooo`D0nP0a0P1b04@0101V
IVH0LP1K0780F`1b05/?0?T0a@0306IVIP3i0<D0n@3500@0n@3500@0IVIV07d0601m01P0nP0a0P1m
03450?X0H`<0O@1S00<0IVIV0?T0a@3i0<D04P3i0<D0103oool0QP0J08H06P1VIVH208H0=AD0nP1S
0`3oool00`1VIVH0oooo0?ooo`020?ooo`80S`0L00<0nP0a08l0>02?03P03@3j06<00`000000nP1S
0?X0H`060?X0H`L0oooo00<0U`0M0?X0<@3j03400P2G03`70?40G`h0nP1S1`3oool209h07`040?X0
<@2N03h0WP0n09h0?PL0lP1O3P3j06<50?ooo`80Y@0P0P3j03440:D0@A@0nP1S1P3oool00`2[0280
nP0a0?X0<@040:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0/0160080/0164`3j06<50?ooo`80
]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0
_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0
oooo0P3802L20?X0<@D0b01?4P3j06?o0?oooc`0oooo001R0?ooo`0306IVIP3oool0oooo00D0oooo
1@3j03420780A00406IVIP1b05/0LP1K0780F`l0n@3500<0IVIV0?T0a@3i0<D0103i0<D0103oool0
O@0H0?X0<@3j034207d0<@D0nP1S0P1m06<00`1VIVH0n@350?T0a@0C0?T0a@030?ooo`2601X0IVIV
00<0QP0e5@3j06<30?ooo`0306IVIP3oool0oooo0080oooo0P2?01`00`3j0340S`0h08l0>0070?40
G`D0nP1S00<000000?X0H`3j06<01`3j06<70?ooo`0409L07@3j0340nP0a09L0?0l0l@1O1`3j06<7
0?ooo`80WP0O00<0nP0a09h0?P2N03h03`3b05l70?X0H`D0oooo0P2U02020?X0<@@0Y@11503j06<6
0?ooo`030:/08P3j0340nP0a00@0Z`134`3j06<60?ooo`80/00S00<0nP0a0;00AP2`04H00P2`04HC
0?X0H`D0oooo0P2e02@20?X0<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool2
0;h09@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j0345
0<D0CQ80nP1S0`3oool20<P09`80nP0a1@3804lB0?X0Hol0oooo?03oool00680oooo00<0IVIV0?oo
o`3oool0103oool00`1b01H0nP0a0?X0<@030?X0<@030780A01VIVH0n@2D00<0LP1K3P3i0<D00`1V
IVH0n@350?T0a@040?T0a@80oooo00<0O@0H0?X0<@3j03400P1m03450?X0H`80O@1S00<0IVIV0?T0
a@3i0<D04`3i0<D00`3oool0QP0J06IVIP0308H0=AD0nP1S0P3oool00`1VIVH0oooo0?ooo`030?oo
o`80S`0L00<0nP0a08l0>03a05l0303a05l00`000000l@1O0?X0H`070?X0H`L0oooo00@0U`0M0?X0
<@3j0340U`0l5@3a05l80?ooo`80WP0O00<0nP0a09h0?P3b05l05@3b05l60?ooo`80Y@0P0P3j0344
0:D0@A@0nP1S1P3oool00`2[0280nP0a0?X0<@040:/0@a<0nP1S1P3oool20;008`030?X0<@2`04H0
/0160080/0164`3j06<506IVIP80]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC
0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool2
0<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0<@D0b01?4P3j06?o0?oooc`0oooo001Q0?oo
o`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j03420780A00306IVIP3i09@0LP1K
0080LP1K3P3i0<D00`1VIVH0n@350?T0a@040?T0a@80oooo00<0O@0H0?X0<@1m03400P1m03450?X0
H`0307d0H`1VIVH0O@1S01D0n@3500<0oooo06IVIP3j03400`2603DE0?X0H`030?ooo`1VIVH0oooo
00D0oooo0P2?01`00`3j0340S`0h0?40G`0<0?40G`030000003a05l0l@1O00H0l@1O203oool00`2G
01d0nP0a0?X0<@0F0?40G`P0oooo0P2N01l00`3j0340WP0n0?80G`0E0?80G`H0oooo0P2U02020?X0
<@<0Y@115@3j06<60?ooo`030:/08P3j0340nP0a00@0Z`134`3j06<60?ooo`030;008`3j0340nP0a
00@0/0164`3j06<50?ooo`80]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0
H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D0
9`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0<@D0b01?4P3j06?o0?oooc`0oooo001Q0?ooo`03
06IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j0340101b04@0IVIV0780A03i09@30780
F`d0n@3500<0IVIV0?T0a@3i0<D01@3i0<D20?ooo`0307d0603j0340O@0a0080O@0a1@3j06<00`1m
06<0IVIV07d0H`0E0?T0a@030?ooo`1VIVH0nP0a00<0QP0e5@3j06<00`3oool0IVIV0?ooo`050?oo
o`0308l0703j0340nP0a00h0l@1O00<000000?40G`3a05l01P3a05l80?ooo`0309L07@3j0340nP0a
01D0l@1O2@3oool209h07`030?X0<@3b05l0lP1O01@0lP1O1`3oool20:D08080nP0a0`2U04470?80
G`h0nP1S1P3oool00`2[0280nP0a0?X0<@040:/0@a<0nP1S1P3oool00`2`02<0nP0a0?X0<@040;00
AQ<0nP1S1@3oool20;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?oo
o`80_P0U0P3j03440;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0
<@D0a@1>4P3j06<30?ooo`80b00W0P3j03450<P0Ca80nP1So`3oooll0?ooo`00H@3oool00`1VIVH0
oooo0?ooo`050?ooo`0307805P3j0340nP0a0080nP0a00@0LP1406IVIP1b04@0n@2D0P1b05/>0?T0
a@0306IVIP3i0<D0n@3500D0n@350P3oool00`1m01P0nP0a07d0<@0207d0<@D0nP1S00<0IVIV07d0
H`1m06<05@3i0<D00`1VIVH0QP0J0?X0<@0308H0=AD0nP1S00<0IVIV0?ooo`3oool0103oool208l0
7080nP0a3P3a05l00`000000l@1O0?40G`050?40G`T0oooo00<0U`0M0?X0<@3a05l05@3a05l90?oo
o`0309h07`3j0340lP1O01D0lP1O203oool20:D08080nP0a0P2U044?0?80G`L0nP1S1@3oool20:/0
8P80nP0a102[04<C0?X0H`D0oooo0P2`02<20?X0<@@0/0164`3j06<50?ooo`80]@0T0P3j03440;D0
Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?oo
o`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0
<@D0b01?4P3j06?o0?oooc`0oooo001Q0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j
03400P3j0340101VIVH0LP140780A03i09@20780F`d0n@3500<0IVIV0?T0a@3i0<D01P3i0<D20?oo
o`0307d0603j0340O@0a0080O@0a1@3j06<00`1VIVH0O@1S0?T0a@0E0?T0a@0306IVIP2601X0nP0a
00<0QP0e5@3j06<00`1VIVH0oooo0?ooo`040?ooo`80S`0L00<0nP0a0?40G`3a05l03@3a05l00`00
0000l@1O0?40G`040?40G`X0oooo00<0U`0M0?X0<@3j03401P3j034>0?40G`X0oooo00<0WP0O0?X0
<@3j03401P3j034?0?80G`P0oooo0P2U02020?X0<@030:D0@@3b05l0lP1O01@0lP1O1P3oool20:/0
8P80nP0a102[04<C0?X0H`D0oooo0P2`02<20?X0<@@0/0164`3j06<50?ooo`80]@0T0P3j03440;D0
Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?oo
o`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0
<@D0b01?4P3j06?o0?oooc`0oooo001Q0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j
03400P3j0340101VIVH0LP140?T0U03i09@20780F`d0n@3500<0IVIV0?T0a@3i0<D01P3i0<D20?oo
o`0307d0603j0340O@0a0080O@0a103j06<00`1VIVH0O@1S07d0H`060?00_Pl0n@3500@0IVIV08H0
6P2601X0nP0a0`2603DD0?X0H`0306IVIP3oool0oooo00D0oooo0P2?01`80?X0<@P0l@1O00<00000
0?40G`3a05l0103a05l:0?ooo`0309L07@3j0340nP0a00d0nP0a1`3a05l:0?ooo`0309h07`3j0340
nP0a00d0nP0a1`3b05l90?ooo`80Y@0P0P3j03400`2U0440lP1O0?80G`0D0?80G`H0oooo0P2[0282
0?X0<@<0Z`13503j06<50?ooo`80/00S0P3j03440;00AQ<0nP1S1@3oool20;D09080nP0a102e04LB
0?X0H`80IVIV0`3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<4
0?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L2
0?X0<@D0b01?4P3j06?o0?oooc`0oooo001Q0?ooo`0306IVIP3oool0oooo00D0oooo00D0LP0F0?X0
<@3j0340nP0a06IVIP020780A080l02>0P1b05/<0?T0a@0306IVIP3i0<D0n@3500L0n@350P3oool0
0`1m01P0nP0a07d0<@0207d0<@@0nP1S00<0IVIV07d0H`1m06<02`3`0;h:0?T0a@0406IVIP2601X0
QP0J0?X0<@<0QP0e503j06<00`1VIVH0oooo0?ooo`050?ooo`80S`0L3`3j03400`3a05l000000?40
G`040?40G`/0oooo00<0U`0M0?X0<@3j03404P3j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3o
ool20:D08080nP0a5P3b05l70?ooo`80Z`0R0P3j03430:/0@`L0lP1O3@3j06<50?ooo`80/00S0P3j
03440;00AQ<0nP1S103oool30;D09080nP0a102e04LB0?X0H`80oooo0`1VIVH20;X09080nP0a102j
04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3o
ool20<D09`80nP0a1@3504hB0?X0H`<0oooo0P3802L20?X0<@D0b01?4`3j06?o0?oooc/0oooo001Q
0?ooo`0306IVIP3oool0oooo00D0oooo00D0LP0F0?X0<@3j0340nP0a06IVIP020780A080l02>0P1b
05/<0?T0a@0306IVIP3i0<D0n@3500L0n@350P3oool00`1m01P0nP0a07d0<@0207d0<@<0nP1S00<0
IVIV0?X0H`1m06<04@3`0;h40?T0a@0506IVIP3i0<D0QP0J08H06P3j03400`2603DC0?X0H`0306IV
IP3j06<0oooo00H0oooo0P2?01`@0?X0<@040000003j0340nP0a0?X0<@`0oooo0P2G01dD0?X0<@`0
oooo00<0WP0O0?X0<@3j03404P3j034;0?ooo`80Y@0P00<0nP0a0?80G`3b05l0503b05l80?ooo`80
Z`0R0P3j03420:/0@`h0lP1O1`3j06<50?ooo`80/00S0P3j03440;00AQ<0nP1S103oool30;D09080
nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?ooo`80_P0U0P3j03440;h0Ba<0
nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0<@D0a@1>4P3j06<30?ooo`80
b00W0P3j03450<P0Ca<0nP1So`3ooolk0?ooo`00H@3oool00`1VIVH0oooo0?ooo`050?ooo`060780
5P3j0340nP0a06IVIP3j0340LP140`3`08h20780F``0n@3500<0IVIV0?T0a@3i0<D01`3i0<D20?oo
o`0407d0603j0340O@0a07d0<@@0nP1S00<0IVIV0?X0H`1m06<05@3`0;h01@1VIVH0oooo08H06P26
01X0nP0a0080QP0e503j06<00`1VIVH0nP1S0?ooo`060?ooo`80S`0L403j034010000000nP0a0?X0
<@3j034<0?ooo`80U`0M503j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3oool20:D080P0nP0a
3`3b05l80?ooo`80Z`0R0P3j03400`2[04<0lP1O0?80G`0C0?80G`H0oooo0P2`02<20?X0<@<0/016
503j06<40?ooo`<0]@0T0P3j03440;D0Aa80nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo
0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a
1@3504hB0?X0H`<0oooo0P3802L30?X0<@@0b01?4`3j06?o0?oooc/0oooo001Q0?ooo`0306IVIP3o
ool0oooo00D0oooo0`3j03400`1VIVH0nP0a0780A0030?00SP80LP1K2`3i0<D00`1VIVH0n@350?T0
a@080?T0a@80oooo00@0O@0H0?X0<@1m0340O@0a0`3j06<00`1VIVH0nP1S0?X0H`0E0?00_P0306IV
IP3`0;h0oooo0080QP0J00<0nP0a08H0=@2603D04`3j06<00`1VIVH0nP1S0?X0H`0506IVIP80oooo
0P2?01`@0?X0<@040000003j0340nP0a0?X0<@`0oooo0P2G01dD0?X0<@`0oooo00<0WP0O0?X0<@3j
03404P3j034;0?ooo`80Y@0P3`3j03470?80G`T0oooo0P2[02820?X0<AH0lP1O1P3oool20;008`80
nP0a0`2`04H50?80G`l0nP1S103oool30;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0
^P194`3j06<40?ooo`80_P0U0P3j03440;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0
oooo0P3502L20?X0<@D0a@1>4P3j06<30?ooo`80b00W0`3j03440<P0Ca<0nP1So`3ooolk0?ooo`00
H@3oool00`1VIVH0oooo0?ooo`050?ooo`<0nP0a00<0IVIV0?X0<@3`08h00P3`08h30780F`/0n@35
00<0IVIV0?T0a@3i0<D0203i0<D20?ooo`0407d0603j0340O@0a07d0<@<0nP1S00<0IVIV0?X0H`3j
06<05@3`0;h00`1VIVH0oooo0?ooo`0208H06P030?X0<@2603D0QP0e01<0nP1S00<0IVIV0?X0H`3o
ool01@3oool206IVIP80S`0L403j034010000000nP0a0?X0<@3j034<0?ooo`0309L07@3j0340nP0a
01<0nP0a303oool00`2N01l0nP0a0?X0<@0B0?X0<@/0oooo0P2U020D0?X0<@/0oooo0P2[02800`3j
0340lP1O0?80G`0D0?80G`L0oooo0P2`02<20?X0<@80/0162`3b05l:0?X0H`@0oooo0`2e02@20?X0
<@@0]@174P3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h09@80nP0a102n04/C0?X0
H`@0oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool20<P0
9`<0nP0a103804lC0?X0Hol0oooo>`3oool00640oooo00<0IVIV0?ooo`3oool01@3oool20?X0<@03
06IVIP3j0340nP0a00<0l02>0`1b05/:0?T0a@0306IVIP3i0<D0n@3500T0n@3500@0oooo07d0601m
01P0nP0a0P1m03420?X0H`0306IVIP3j06<0nP1S01D0l02n00@0IVIV0?00_P3oool0oooo0P2601X0
0`3j0340QP0e08H0=@0B0?X0H`0306IVIP3j06<0nP1S00P0oooo0P2?01`@0?X0<@040000003j0340
nP0a0?X0<@`0oooo00<0U`0M0?X0<@3j03404`3j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3o
ool20:D081@0nP0a2`3oool20:/08PH0nP0a403b05l80?ooo`80/00S0P3j03400`2`04H0lP1O0?80
G`0?0?80G`D0nP1S103oool30;D09080nP0a102e04LB0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j
06<406IVIP80_P0U0P3j03440;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P35
02L20?X0<@D0a@1>4P3j06<30?ooo`80b00W0`3j03440<P0Ca<0nP1So`3ooolk0?ooo`00H@3oool0
0`1VIVH0oooo0?ooo`040?ooo`0507805P3j0340nP0a06IVIP3j0340103`08h30780F`X0n@3500<0
IVIV0?T0a@3i0<D02@3i0<D0103oool0O@0H0?X0<@3j034207d0<@80nP1S00<0IVIV0?X0H`3j06<0
1`3j06<>0?00_P0406IVIP3oool0oooo0?ooo`80QP0J00<0nP0a08H0=@2603D04P3j06<00`1VIVH0
nP1S0?X0H`080?ooo`80S`0L403j034010000000nP0a0?X0<@3j034<0?ooo`0309L07@3j0340nP0a
01<0nP0a303oool00`2N01l0nP0a0?X0<@0B0?X0<@/0oooo0P2U020D0?X0<@/0oooo0P2[028;0?X0
<@/0lP1O203oool20;008`80nP0a00<0/0160?80G`3b05l04`3b05l50?ooo`<0]@0T0P3j03430;D0
Aa<0nP1S1@3oool20;X09080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?oo
o`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0`3802L20?X0
<@@0b01?4`3j06?o0?oooc/0oooo001P0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@1V
IVH01P3j03430780F`T0n@3500<0IVIV0?T0a@3i0<D02@3i0<D20?ooo`0307d0603j0340nP0a0080
O@0a00<0nP1S06IVIP3j06<0403j06<60?00_P0306IVIP3`0;h0oooo0080oooo00<0QP0J0?X0<@3j
03400P2603DA0?X0H`0406IVIP3j06<0nP1S0?X0H`P0oooo0P2?01`@0?X0<@040000003j0340nP0a
0?X0<@`0oooo00<0U`0M0?X0<@3j03404`3j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3oool2
0:D081@0nP0a2`3oool20:/08Q00nP0a1@3b05l90?ooo`80/00S0P3j034F0?80G`D0oooo0`2e02@2
0?X0<@<0]@171@3b05l>0?X0H`D0oooo0P2j02@20?X0<@@0^P194`3j06<40?ooo`80_P0U0P3j0344
0;h0Ba<0nP1S103oool20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0<@D0a@1>4P3j06<3
0?ooo`<0b00W0P3j03440<P0Ca<0nP1So`3ooolk0?ooo`00H03oool00`1VIVH0oooo0?ooo`050?oo
o`0307805P3j0340IVIV00H0nP0a0`1b05/90?T0a@0306IVIP3i0<D0n@3500T0n@350P3oool00`1m
01P0nP0a0?X0<@0207d0<@030?X0H`1VIVH0nP1S0180nP1S103oool00`1VIVH0oooo0?ooo`020?oo
o`0308H06P3j0340QP0e0080QP0e403j06<00`1VIVH0nP1S0?X0H`020?X0H`P0oooo0P2?01`?0?X0
<@<000000P3j034406IVIPP0oooo00<0U`0M0?X0<@3j03404P3j034<0?ooo`80WP0O503j034;0?oo
o`80Y@0P503j034;0?ooo`80Z`0R4`3j034;0?ooo`80/00S00<0nP0a0?80G`3b05l0503b05l60?oo
o`<0]@0T0P3j03420;D0A`/0lP1O2@3j06<50?ooo`80^P0T0P3j03440;X0BA<0nP1S103oool20;h0
9@80nP0a102n04/C0?X0H`@0oooo0P3202H20?X0<@@0`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0
CQ80nP1S0`3oool30<P09`80nP0a103804lC0?X0Hol0oooo>`3oool00600oooo00<0IVIV0?ooo`3o
ool01@3oool00`1b01H0IVIV0?X0<@060?X0<@80LP1K2@3i0<D00`1VIVH0n@350?T0a@0:0?T0a@80
oooo00<0O@0H0?X0<@1m03400P1m03400`1VIVH0nP1S0?X0H`0B0?X0H`<0oooo00<0IVIV0?ooo`3o
ool00`3oool00`2601X0nP0a08H0=@0208H0=A00nP1S00<0IVIV0?X0H`3j06<00P3j06<80?ooo`80
S`0L3P3j0340101VIVH0nP0a0000003j0342000000@0oooo1P1VIVH20?ooo`0309L07@3j0340nP0a
0180nP0a303oool209h07a@0nP0a2`3oool20:D081@0nP0a2`3oool20:/08Q<0nP0a2`3oool20;00
8`H0nP0a403b05l70?ooo`<0]@0T0P3j03400`2e04L0lP1O0?80G`0?0?80G`@0nP1S1@3oool20;X0
9080nP0a102j04TC0?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<40?ooo`80`P0V0P3j03440<80
C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0`3802L20?X0<@@0b01?4`3j06?o0?oo
oc/0oooo001P0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j03401P3j03420780F`T0
n@3500<0IVIV0?T0a@3i0<D02P3i0<D20?ooo`0307d0603j0340O@0a0080O@0a00<0IVIV0?X0H`3j
06<04P3j06<30?ooo`0306IVIP3oool0oooo00<0oooo00<0QP0J0?X0<@2603D00P2603D?0?X0H`03
06IVIP3j06<0nP1S00<0nP1S203oool208l070h0nP0a00<0IVIV0?X0<@0000000`3j034:0?ooo`80
IVIV00<0U`0M0?X0<@3j03404P3j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80
Z`0R4`3j034;0?ooo`80/00S2`3j034;0?80G`L0oooo0`2e02@20?X0<@030;D0A`3b05l0lP1O01<0
lP1O1@3oool20;X09080nP0a102j04T50?80G`h0nP1S103oool20;h09@80nP0a102n04/C0?X0H`04
06IVIP3oool0oooo0?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0
H`<0oooo0`3802L20?X0<@@0b01?4`3j06?o0?oooc/0oooo001P0?ooo`0306IVIP3oool0oooo00D0
oooo00<0IVIV0?X0<@3j03401P3j03420780F`P0n@3500<0IVIV0?T0a@3i0<D02`3i0<D20?ooo`05
07d0603j0340O@0a07d0<@1VIVH05@3j06<20?ooo`0306IVIP3oool0oooo00@0oooo00<0QP0J0?X0
<@2603D00P2603D?0?X0H`0306IVIP3j06<0nP1S00<0nP1S203oool208l070d0nP0a00<0IVIV0?X0
<@000000103j034<0?ooo`0309L07@3j0340nP0a0180nP0a303oool209h07a@0nP0a2`3oool20:D0
81<0nP0a303oool20:/08Q<0nP0a2`3oool20;008a00nP0a1@3b05l80?ooo`<0]@0T0P3j034F0?80
G`D0oooo0P2j02@20?X0<@<0^P192`3b05l90?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j06<0103o
ool0IVIV06IVIP1VIVH20<809P80nP0a103204`C0?X0H`<0oooo0P3502L20?X0<@D0a@1>4P3j06<3
0?ooo`<0b00W0P3j03440<P0Ca<0nP1So`3ooolk0?ooo`00H03oool00`1VIVH0oooo0?ooo`050?oo
o`0306IVIP3j0340nP0a00H0nP0a0P1b05/80?T0a@0306IVIP3i0<D0n@3500/0n@350P3oool01@1m
01P0nP0a07d0<@1m0340IVIV01D0nP1S0P3oool00`1VIVH0oooo0?ooo`030?ooo`80QP0J00@0nP0a
08H0=@2603D0QP0e3P3j06<00`1VIVH0nP1S0?X0H`040?X0H`P0oooo0P2?01`=0?X0<@0306IVIP3j
0340000000@0nP0a303oool00`2G01d0nP0a0?X0<@0B0?X0<@`0oooo0P2N01lD0?X0<@/0oooo0P2U
020C0?X0<@`0oooo0P2[028C0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@00`3j0340lP1O0?80
G`0D0?80G`H0oooo0P2j02@20?X0<@80^P194@3b05l40?X0H`@0oooo0P2n02D20?X0<@@0_P1;4`3j
06<40?ooo`80`P0V0P3j03440<80C1<0nP1S0`3oool20<D09`80nP0a1@3504hB0?X0H`<0oooo0`38
02L20?X0<@@0b01?4`3j06?o0?oooc/0oooo001P0?ooo`0306IVIP3oool0oooo00@0oooo00<0IVIV
07805P3j03401`3j03420780F`L0n@3500<0IVIV0?T0a@3i0<D0303i0<D20?ooo`0507d0603j0340
O@0a06IVIP1m03405@3j06<00`3oool0IVIV0?ooo`050?ooo`80QP0J00@0nP0a08H0=@2603D0QP0e
3P3j06<00`1VIVH0nP1S0?X0H`040?X0H`L0oooo0P2?01`=0?X0<@0406IVIP3j0340nP0a000000@0
nP0a303oool00`2G01d0nP0a0?X0<@0B0?X0<@`0oooo0P2N01lD0?X0<@/0oooo0P2U020C0?X0<@`0
oooo0P2[028C0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@80?X0<@h0lP1O1`3oool20;X09080
nP0a0P2j04TE0?80G`@0oooo0P2n02D20?X0<@@0_P1;1@3b05l>0?X0H`@0oooo0P3202H20?X0<@@0
`P1<4`3j06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool30<P09`80nP0a103804lC0?X0Hol0
oooo>`3oool00600oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0LP0F0?X0<@070?X0<@80LP1K
1`3i0<D00`1VIVH0n@350?T0a@0<0?T0a@80oooo00D0O@0H0?X0<@1m0340IVIV07d0<@0E0?X0H`03
0?ooo`1VIVH0oooo00D0oooo0P2601X0103j0340QP0e08H0=@2603D=0?X0H`0306IVIP3j06<0nP1S
00D0nP1S1`3oool208l070d0nP0a00@0IVIV0?X0<@3j03400000103j034<0?ooo`0309L07@3j0340
nP0a0180nP0a1P1VIVH60?ooo`80WP0O503j034;0?ooo`80Y@0P4`3j034<0?ooo`80Z`0R4`3j034;
0?ooo`80/00S4`3j034:0?ooo`<0]@0T3P3j03470?80G`P0oooo0P2j02@20?X0<@030;X0B@3b05l0
lP1O01<0lP1O1@3oool20;h09@80nP0a0`2n04/;0?80G`T0nP1S103oool20<809P80nP0a103204`C
0?X0H`<0oooo0P3502L20?X0<@D0a@1>4P3j06<30?ooo`<0b00W0P3j03440<P0Ca<0nP1So`3ooolk
0?ooo`00H03oool00`1VIVH0oooo0?ooo`030?ooo`0306IVIP3oool0nP0a00P0nP0a0P1b05/60?T0
a@0306IVIP3i0<D0n@3500d0n@350P3oool00`1m01P0nP0a06IVIP0207d0<AD0nP1S00<0IVIV0?oo
o`3oool01@3oool208H06P040?X0<@2603D0QP0e08H0=@d0nP1S00<0IVIV0?X0H`3j06<01@3j06<7
0?ooo`80S`0L303j03401@1VIVH0nP0a0?X0<@3j0340000000@0nP0a303oool00`2G01d0nP0a0?X0
<@0B0?X0<@H0oooo1@1VIVH00`3oool0WP0O09h07`0D0?X0<@/0oooo0P2U020C0?X0<@`0oooo00<0
Z`0R0?X0<@3j03404P3j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T0P3j
034E0?80G`H0oooo0P2n02D20?X0<@80_P1;4@3b05l40?X0H`@0oooo0P3202H20?X0<@@0`P1<4`3j
06<30?ooo`80a@0W0P3j03450<D0CQ80nP1S0`3oool30<P09`80nP0a103804lC0?X0Hol0oooo>`3o
ool00600oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0oooo0?X0<@070?X0<@<0LP1K1P3i0<D0
0`1VIVH0n@350?T0a@0=0?T0a@80oooo00@0O@0H0?X0<@1VIVH0O@0a5P3j06<00`1VIVH0oooo0?oo
o`050?ooo`80QP0J00<0nP0a08H0=@2603D03@3j06<00`1VIVH0nP1S0?X0H`060?X0H`L0oooo0P2?
01`;0?X0<@0306IVIP3j0340nP0a0080nP0a00@000000?X0<@3j0340nP0a3@3oool00`2G01d0nP0a
0?X0<@0B0?X0<@/0oooo00<0IVIV09h07`2N01l0503j034;0?ooo`80Y@0P4`3j034<0?ooo`030:/0
8P3j0340nP0a0180nP0a2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X090P0nP0a
3P3b05l70?ooo`80_P0U0P3j03420;h0BaD0lP1O103oool20<809P80nP0a103204`50?80G`h0nP1S
0`1VIVH30<D09`030?X0<@3504h0a@1>00<0a@1>4P3j06<30?ooo`<0b00W0P3j03440<P0Ca<0nP1S
o`3ooolk0?ooo`00H03oool00`1VIVH0oooo0?ooo`030?ooo`0306IVIP3oool0nP0a00L0nP0a0`1b
05/50?T0a@0306IVIP3i0<D0n@3500h0n@3500@0oooo07d0601m01P0IVIV0P1m034E0?X0H`0306IV
IP3oool0oooo00H0oooo0P2601X00`3j0340QP0e08H0=@060?00G`L0nP1S00<0IVIV0?X0H`3j06<0
1P3j06<70?ooo`80S`0L2`3j03400`1VIVH0nP0a0?X0<@020?X0<@040000003j0340nP0a0?X0<@`0
oooo0P2G01dD0?X0<@`0oooo0P2N01lD0?X0<@/0oooo00<0Y@0P0?X0<@3j03404P3j034<0?ooo`03
0:/08P3j0340nP0a0180nP0a2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X090h0
nP0a1`3b05l80?ooo`80_P0U0P3j03400`2n04/0lP1O0?80G`0C0?80G`D0oooo0P3202H20?X0<@<0
`P1<2`3b05l90?X0H`<0oooo0`3502L00`3j0340a@1>0<D0CP030<D0CQ80nP1S0`3oool30<P09`80
nP0a103804lC0?X0Hol0oooo>`3oool005l0oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0oooo
07805P080?X0<@<0LP1K1@3i0<D00`1VIVH0n@350?T0a@0>0?T0a@040?ooo`1m01P0O@0H06IVIP80
O@0a503j06<00`1VIVH0nP1S0?ooo`070?ooo`80QP0J00<0nP0a08H0=@3`05l02`3`05l00`3j06<0
IVIV0?X0H`080?X0H`L0oooo0P2?01`:0?X0<@0306IVIP3j0340nP0a00<0nP0a00@000000?X0<@3j
0340nP0a303oool209L07A@0nP0a303oool209h07a@0nP0a2`3oool00`2U0200nP0a0?X0<@0B0?X0
<@`0oooo00<0Z`0R0?X0<@3j03404P3j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?oo
o`80^P0T4`3j034:0?ooo`80_P0U0P3j034E0?80G`H0oooo0P3202H20?X0<@80`P1<4@3b05l40?X0
H`@0oooo0P3502L00`3j0340a@1>0<D0CP030<D0CQ80nP1S0`3oool30<P09`80nP0a103804lC0?X0
Hol0oooo>`3oool005l0oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0oooo07805P080?X0<@<0
LP1K103i0<D00`1VIVH0n@350?T0a@0?0?T0a@040?ooo`1m01P0IVIV0?X0<@80O@0a503j06<00`1V
IVH0oooo0?ooo`070?ooo`80QP0J00<0nP0a08H0=@3`05l02`3`05l00`1VIVH0l01O0?00G`020?00
G`H0nP1S1`3oool208l070X0nP0a00<0IVIV0?X0<@3j03400`3j034010000000nP0a0?X0<@3j034<
0?ooo`80U`0M503j034<0?ooo`80WP0O4`3j03400`1VIVH0oooo0?ooo`080?ooo`80Y@0P503j034<
0?ooo`030:/08P3j0340nP0a0180nP0a2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool2
0;X091<0nP0a2P3oool20;h09@P0nP0a3P3b05l70?ooo`80`P0V0P3j03420<80C1D0lP1O103oool2
0<D09`030?X0<@3504h0a@1>00<0a@1>4P3j06<30?ooo`<0b00W0P3j03440<P0Ca<0nP1So`3ooolk
0?ooo`00G`3oool00`1VIVH0oooo0?ooo`020?ooo`0406IVIP3oool0oooo07805PP0nP0a0`1b05/4
0?T0a@0306IVIP3i0<D0n@3500l0n@3500@0oooo07d0601VIVH0nP0a0P1m034C0?X0H`0306IVIP3j
06<0oooo00P0oooo0P2601X00`3j0340l01O0?00G`0;0?00G`0306IVIP3`05l0l01O00L0l01O203o
ool208l070T0nP0a00<0IVIV0?X0<@3j0340103j034010000000nP0a0?X0<@3j034<0?ooo`80U`0M
503j034<0?ooo`80WP0O4`3j03400`3oool0IVIV06IVIP0406IVIP@0oooo0P2U020D0?X0<@`0oooo
00<0Z`0R0?X0<@3j03404P3j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T
4`3j034:0?ooo`80_P0U3P3j03470?80G`P0oooo0P3202H20?X0<@030<80C03b05l0lP1O01<0lP1O
1@3oool20<D09`030?X0<@3504h0a@1>0080a@1>1`3b05l<0?X0H`<0oooo0`3802L20?X0<@@0b01?
4`3j06?o0?oooc/0oooo001O0?ooo`0306IVIP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0LP0F
203j03420780F`@0n@3500<0IVIV0?T0a@3i0<D03`3i0<D20?ooo`0306IVIP3j0340nP0a0080O@0a
4`3j06<00`1VIVH0nP1S0?ooo`080?ooo`0308H06P3j0340nP0a00`0l01O00<0IVIV0?00G`3`05l0
203`05l80?ooo`80S`0L2@3j03400`1VIVH0nP0a0?X0<@040?X0<@040000003j0340nP0a0?X0<@`0
oooo0P2G01dD0?X0<@`0oooo00<0WP0O0?X0<@3j03404P3j03470?ooo`@0IVIV0P2U020D0?X0<@`0
oooo00<0Z`0R0?X0<@3j03404P3j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80
^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V0P3j034E0?80G`H0oooo0P3502L0103j0340
a@1>0<D0CP3504h>0?80G`H0nP1S00<0IVIV0?ooo`3oool00`3802L20?X0<@@0b01?4`3j06?o0?oo
oc/0oooo001O0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH00`3oool00`1b01H0nP0a0?X0<@060?X0
<@80LP1K103i0<D00`1VIVH0n@350?T0a@0?0?T0a@80oooo00<0IVIV0?X0<@1m03400P1m034B0?X0
H`0306IVIP3j06<0nP1S00T0oooo00<0QP0J0?X0<@3`05l0303`05l00`1VIVH0l01O0?00G`070?00
G`T0oooo0P2?01`80?X0<@0306IVIP3j0340nP0a00D0nP0a00@000000?X0<@3j0340nP0a303oool2
09L07A@0nP0a303oool00`2N01l0nP0a0?X0<@0B0?X0<@/0oooo0P2U020D0?X0<@`0oooo00<0Z`0R
0?X0<@3j03404P3j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:
0?ooo`80_P0U4`3j034:0?ooo`80`P0V203j034>0?80G`L0oooo0P3502L00`3j0340a@1>0<D0CP0E
0?80G`030?ooo`1VIVH0IVIV00<0b00W0P3j03440<P0Ca<0nP1So`3ooolk0?ooo`00G`3oool01@1V
IVH0oooo0?ooo`3oool0IVIV00<0oooo00<0LP0F0?X0<@3j03401P3j03420780F`<0n@3500<0IVIV
0?T0a@3i0<D0403i0<D0103oool0IVIV07d0603j034307d0<A80nP1S00<0IVIV0?X0H`3j06<02@3o
ool00`2601X0nP0a0?X0<@060?X0<@D0l01O00<0IVIV0?00G`3`05l0203`05l90?ooo`80S`0L1`3j
03400`1VIVH0nP0a0?X0<@060?X0<@040000003j0340nP0a0?X0<@`0oooo0P2G01dD0?X0<@`0oooo
00<0WP0O0?X0<@3j03404P3j034;0?ooo`80Y@0P503j034<0?ooo`030:/08P3j0340nP0a0180nP0a
2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X091<0nP0a2P3oool20;h09A<0nP0a
2P3oool20<809Ph0nP0a1`3b05l80?ooo`80a@0W00<0nP0a0<D0CP3b05l05@3b05l40?ooo`80b00W
0P3j03440<P0C`L0lP1P303j06?o0?oooc/0oooo001O0?ooo`0406IVIP3oool0oooo06IVIP@0oooo
00<0LP0F0?X0<@3j03401P3j03420780F`<0n@3500<0IVIV0?T0a@3i0<D0403i0<D0103oool0IVIV
07d0603j034307d0<A40nP1S00@0IVIV0?X0H`3j06<0nP1S2@3oool00`2601X0nP0a0?X0<@0;0?X0
<@0306IVIP3j0340l01O00L0l01O2P3oool208l070L0nP0a00<0IVIV0?X0<@3j03401P3j03401000
0000nP0a0?X0<@3j034<0?ooo`80U`0M503j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3oool2
0:D081@0nP0a303oool00`2[0280nP0a0?X0<@0B0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@C
0?X0<@X0oooo0P2j02@C0?X0<@X0oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P3502L0
0`3j0340lP1O0?80G`0D0?80G`D0oooo0P3802L20?X0<@<0b01?3P3b06060?X0Hol0oooo>`3oool0
05l0oooo00@0IVIV0?ooo`3oool0IVIV103oool00`1b01H0nP0a0?X0<@060?X0<@80LP1K0P3i0<D0
0`1VIVH0n@350?T0a@0A0?T0a@0406IVIP3oool0O@0H0?X0<@<0O@0a4@3j06<0101VIVH0nP1S0?X0
H`3j06<90?ooo`0308H06P3j0340nP0a00X0nP0a00<0IVIV0?X0<@3j03401P3j034<0?ooo`80S`0L
1P3j03400`1VIVH0nP0a0?X0<@070?X0<@040000003j0340nP0a0?X0<@`0oooo00<0U`0M0?X0<@3j
03404`3j034<0?ooo`0309h07`3j0340nP0a0180nP0a2`3oool20:D081@0nP0a0`1VIVH90?ooo`03
0:/08P3j0340nP0a0180nP0a2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X091<0
nP0a2P3oool20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3oool20<D09`P0nP0a3P3b05l60?ooo`80
b00W0P3j03420<P0CaD0lP1Po`3ooolk0?ooo`00G`3oool00`1VIVH0oooo06IVIP050?ooo`030780
5P3j0340nP0a00H0nP0a0P1b05/20?T0a@0306IVIP3i0<D0n@350140n@3500@0IVIV0?ooo`1m01P0
nP0a0`1m034@0?X0H`0306IVIP3j06<0nP1S0080nP1S2@3oool00`2601X0nP0a0?X0<@0:0?X0<@03
06IVIP3j0340nP0a00H0nP0a303oool208l070H0nP0a00<0IVIV0?X0<@3j03401`3j034010000000
nP0a0?X0<@3j034<0?ooo`0309L07@3j0340nP0a01<0nP0a303oool00`2N01l0nP0a0?X0<@0B0?X0
<@/0oooo0P2U020D0?X0<@<0oooo1P1VIVH30?ooo`030:/08P3j0340nP0a0180nP0a2`3oool20;00
8a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X091<0nP0a2P3oool20;h09A<0nP0a2P3oool20<80
9Q<0nP0a2P3oool20<D09`h0nP0a1`3b05l70?ooo`80b00W0P3j03400`3804l0lP1P0?80H00D0?80
H?l0oooo>`3oool005l0oooo00<0IVIV0?ooo`1VIVH01@3oool90?X0<@80LP1K0P3i0<D00`1VIVH0
n@350?T0a@0@0?T0a@0506IVIP3oool0oooo07d0603j03400`1m034@0?X0H`0306IVIP3j06<0nP1S
0080nP1S203oool208H06P/0nP0a00<0IVIV0?X0<@3j03401`3j034<0?ooo`80S`0L1@3j03400`1V
IVH0nP0a0?X0<@080?X0<@040000003j0340nP0a0?X0<@`0oooo00<0U`0M0?X0<@3j03404`3j034<
0?ooo`0309h07`3j0340nP0a0180nP0a2`3oool20:D081@0nP0a2@3oool206IVIP80Z`0R503j034;
0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:
0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`80b00W0P3j034F0?80H0@0IVIVo`3ooolh
0?ooo`00G`3oool206IVIPH0oooo203j03430780F`030?T0a@1VIVH0n@350180n@3500D0IVIV0?oo
o`3oool0O@0H0?X0<@0307d0<@l0nP1S00<0IVIV0?X0H`3j06<00`3j06<80?ooo`80QP0J2`3j0340
0`1VIVH0nP0a0?X0<@070?X0<@`0oooo0P2?01`50?X0<@0306IVIP3j0340nP0a00P0nP0a00@00000
0?X0<@3j0340nP0a303oool00`2G01d0nP0a0?X0<@0C0?X0<@/0oooo0P2N01lD0?X0<@/0oooo0P2U
020D0?X0<@/0oooo0P2[028D0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@C0?X0<@X0oooo0P2j
02@C0?X0<@X0oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P3502LB0?X0<@X0oooo0P38
02L70?X0<A00lP1P1@3oool606IVI_l0oooo<P3oool005l0oooo0P1VIVH60?ooo`P0nP0a0`1b05/0
0`3i0<D0IVIV0?T0a@0A0?T0a@0606IVIP3i0<D0oooo0?ooo`1m01P0nP0a0`1m034?0?X0H`0306IV
IP3j06<0nP1S00<0nP1S203oool208H06PX0nP0a00<0IVIV0?X0<@3j0340203j034<0?ooo`80S`0L
103j03400`1VIVH0nP0a0?X0<@080?X0<@030000003j0340nP0a0080nP0a303oool00`2G01d0nP0a
0?X0<@0B0?X0<@`0oooo0P2N01lD0?X0<@/0oooo0P2U020D0?X0<@/0oooo0P2[028D0?X0<@/0oooo
0P2`02<C0?X0<@X0oooo0`2e02@C0?X0<@X0oooo0P2j02@C0?X0<@X0oooo0P2n02DC0?X0<@X0oooo
0P3202HC0?X0<@X0oooo0P3502LB0?X0<@X0oooo0P3802L;0?X0<@/0lP1P303oool306IVI_l0oooo
;`3oool005h0oooo0P1VIVH60?ooo`0307805P3j0340nP0a00H0nP0a0`1b05/00`1VIVH0n@350?T0
a@0A0?T0a@0306IVIP3i0<D0oooo0080O@0H00<0nP0a07d0<@1m03403`3j06<00`1VIVH0nP1S0?X0
H`040?X0H`P0oooo0P2601X:0?X0<@0306IVIP3j0340nP0a00L0nP0a303oool208l070D0nP0a00<0
IVIV0?X0<@3j0340203j03400`000000nP0a0?X0<@020?X0<@`0oooo00<0U`0M0?X0<@3j03404P3j
034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80/00S4`3j
034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V4`3j
034:0?ooo`80a@0W4P3j034:0?ooo`80b00W403j03450?80H?l0oooo?`3oool005h0oooo1@1VIVH3
0?ooo`0307805P3j0340nP0a00H0nP0a0`1b05/00`1VIVH0n@350?T0a@0@0?T0a@0406IVIP3i0<D0
n@350?ooo`80O@0H00<0nP0a07d0<@1m03403`3j06<00`1VIVH0nP1S0?X0H`040?X0H`P0oooo0P26
01X90?X0<@0306IVIP3j0340nP0a00P0nP0a303oool208l070@0nP0a00<0IVIV0?X0<@3j03402@3j
03400`000000nP0a0?X0<@020?X0<@`0oooo00<0U`0M0?X0<@3j03404P3j034<0?ooo`80WP0O503j
034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034406IVIPL0oooo0P2`02<C0?X0<@X0oooo0`2e
02@C0?X0<@X0oooo0P2j02@C0?X0<@X0oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P35
02LB0?X0<@X0oooo0P3802LB0?X0<Ol0oooo@P3oool005h0oooo00<0IVIV0?ooo`3oool00P3oool3
06IVIP0307805P3j0340nP0a00H0nP0a0P1b05/00`1VIVH0n@350?T0a@0A0?T0a@0506IVIP3i0<D0
n@350?ooo`1m01P00P3j034207d0<@h0nP1S00<0IVIV0?X0H`3j06<01@3j06<80?ooo`80QP0J203j
03400`1VIVH0nP0a0?X0<@090?X0<@`0oooo0P2?01`30?X0<@0306IVIP3j0340nP0a00X0nP0a00<0
00000?X0<@3j03400P3j034<0?ooo`0309L07@3j0340nP0a0180nP0a303oool209h07a@0nP0a2`3o
ool20:D081@0nP0a2`3oool20:/08Q@0nP0a103oool606IVIP030?ooo`2`02<0/00S01<0nP0a2P3o
ool30;D091<0nP0a2P3oool20;X091<0nP0a2P3oool20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3o
ool20<D09a80nP0a2P3oool20<P09a80nP0ao`3ooom20?ooo`00GP3oool00`1VIVH0oooo0?ooo`05
0?ooo`0307805P3j0340nP0a00H0nP0a0P1b05/00`1VIVH0n@350?T0a@0@0?T0a@0606IVIP3i0<D0
n@350?T0a@3oool0O@0H0P3j034207d0<@h0nP1S00<0IVIV0?X0H`3j06<0103j06<90?ooo`80QP0J
203j03400`1VIVH0nP0a0?X0<@090?X0<@`0oooo0P2?01`30?X0<@0306IVIP3j0340nP0a00X0nP0a
00<000000?X0<@3j03400P3j034;0?ooo`80U`0M503j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P
503j034;0?ooo`80Z`0R503j034:0?ooo`0306IVIP2`02<0/00S01<0nP0a2P3oool30;D091<0nP0a
2P3oool20;X091<0nP0a2P3oool20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80nP0a
2P3oool20<P09a80nP0ao`3ooom20?ooo`00GP3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j
0340nP0a00H0nP0a00<0LP1K06IVIP3i0<D04P3i0<D01P1VIVH0n@350?T0a@3i0<D0oooo07d06080
nP0a0P1m034=0?X0H`0306IVIP3j06<0nP1S00D0nP1S2@3oool208H06PL0nP0a00<0IVIV0?X0<@3j
03402P3j034<0?ooo`80S`0L0P3j03400`1VIVH0nP0a0?X0<@0;0?X0<@030000003j0340nP0a0080
nP0a2`3oool209L07A@0nP0a303oool209h07a@0nP0a2`3oool20:D081@0nP0a2`3oool20:/08Q@0
nP0a2`3oool20;008a<0nP0a2P3oool30;D091<0nP0a2P3oool20;X091<0nP0a2P3oool20;h09A<0
nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80nP0a2P3oool30<P09a40nP0ao`3ooom20?ooo`00
GP3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00H0nP0a00<0LP1K06IVIP3i0<D0
4@3i0<D0101VIVH0n@350?T0a@3i0<D20?ooo`0307d0603j0340nP0a0080O@0a3@3j06<00`1VIVH0
nP1S0?X0H`050?X0H`T0oooo00<0QP0J0?X0<@3j03401P3j03400`1VIVH0nP0a0?X0<@0:0?X0<@`0
oooo0P2?01`20?X0<@0306IVIP3j0340nP0a00/0nP0a00<000000?X0<@3j03400P3j034;0?ooo`80
U`0M503j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80
/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80
`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4@3j037o0?oood80oooo001N0?ooo`0306IV
IP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03401P3j03400`1VIVH0LP1K0?T0a@0A0?T0a@0406IV
IP3i0<D0n@350?T0a@80oooo00<0O@0H0?X0<@1m03400P1m034<0?X0H`0306IVIP3j06<0nP1S00H0
nP1S2@3oool00`2601X0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a00/0nP0a303oool208l07003
0?X0<@1VIVH0nP0a00d0nP0a00@000000?X0<@3j0340nP0a303oool209L07A@0nP0a303oool209h0
7a@0nP0a2`3oool20:D081@0nP0a2`3oool20:/08Q@0nP0a2`3oool20;008a<0nP0a00<0IVIV0?oo
o`3oool01`3oool30;D091<0nP0a2P3oool20;X091<0nP0a2P3oool20;h09A<0nP0a2P3oool20<80
9Q<0nP0a2P3oool20<D09a80nP0a2P3oool30<P09a40nP0ao`3ooom20?ooo`00GP3oool00`1VIVH0
oooo0?ooo`050?ooo`0307805P3j0340nP0a00H0nP0a00<0IVIV0780F`3i0<D0403i0<D00`1VIVH0
n@350?T0a@020?T0a@80oooo00<0O@0H0?X0<@1m03400P1m034<0?X0H`0306IVIP3j06<0nP1S00H0
nP1S2@3oool00`2601X0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a00/0nP0a303oool208l07003
0?X0<@1VIVH0nP0a00d0nP0a00@000000?X0<@3j0340nP0a303oool209L07A@0nP0a303oool209h0
7a@0nP0a2`3oool20:D081@0nP0a2`3oool20:/08Q@0nP0a2`3oool20;008a<0nP0a00<0oooo06IV
IP1VIVH0101VIVH30?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?oo
o`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4@3j037o0?oood80oooo001N0?ooo`03
06IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03401@3j03400`1VIVH0LP1K0780F`0A0?T0a@03
06IVIP3i0<D0n@350080n@350P1VIVH00`1m01P0nP0a07d0<@0207d0<@/0nP1S00<0IVIV0?X0H`3j
06<01`3j06<90?ooo`0308H06P3j0340nP0a00@0nP0a00<0IVIV0?X0<@3j0340303j034<0?ooo`80
S`0L00<0IVIV0?X0<@3j03403@3j034010000000nP0a0?X0<@3j034<0?ooo`80U`0M503j034<0?oo
o`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80/00S4`3j03470?oo
o`<0IVIV0`2e02@C0?X0<@X0oooo0P2j02@C0?X0<@X0oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0
<@X0oooo0P3502LB0?X0<@X0oooo0`3802LB0?X0<Ol0oooo@@3oool005h0oooo00<0IVIV0?ooo`3o
ool01@3oool80?X0<@0306IVIP1b05/0LP1K0100n@3500<0IVIV0?T0a@3i0<D00`3i0<D20?ooo`03
07d0603j0340O@0a0080O@0a2`3j06<00`1VIVH0nP1S0?X0H`070?X0H`T0oooo00<0QP0J0?X0<@3j
0340103j03400`1VIVH0nP0a0?X0<@0<0?X0<@`0oooo00<0S`0L06IVIP3j03403`3j034010000000
nP0a0?X0<@3j034<0?ooo`80U`0M503j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?oo
o`80Z`0R503j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?oo
o`80_P0U4`3j034:0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oo
od40oooo001N0?ooo`0306IVIP3oool0oooo00D0oooo1`3j0340101VIVH0LP1K0780F`1b05/@0?T0
a@0306IVIP3i0<D0n@3500<0n@350P3oool00`1m01P0nP0a07d0<@0207d0<@X0nP1S00<0IVIV0?X0
H`3j06<0203j06<90?ooo`0308H06P3j0340nP0a00<0nP0a00<0IVIV0?X0<@3j03403@3j034<0?oo
o`0308l0701VIVH0nP0a00l0nP0a1000000<0?ooo`80U`0M503j034<0?ooo`80WP0O503j034;0?oo
o`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j034:0?oo
o`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?oo
o`<0b00W4P3j037o0?oood40oooo001M0?ooo`0306IVIP3oool0oooo00H0oooo1`3j0340101VIVH0
LP1K0780F`1b05/?0?T0a@0306IVIP3i0<D0n@3500@0n@350P3oool00`1m01P0nP0a07d0<@0207d0
<@X0nP1S00<0IVIV0?X0H`3j06<0203j06<80?ooo`80QP0J1@3j03400`1VIVH0nP0a0?X0<@0=0?X0
<@`0oooo00<0IVIV08l0703j03403`3j034010000000nP0a0?X0<@3j034<0?ooo`80U`0M503j034<
0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80/00S4`3j034:
0?ooo`<0]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V4`3j034:
0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40oooo001M0?ooo`0306IVIP3oool0oooo
00D0oooo00<0LP0F0?X0<@3j0340103j03400`1VIVH0nP0a0780F`020780F`l0n@3500<0IVIV0?T0
a@3i0<D0103i0<D0103oool0O@0H07d0603j034307d0<@T0nP1S00<0IVIV0?X0H`3j06<02@3j06<2
06IVIPH0oooo0P2601X40?X0<@0306IVIP3j0340nP0a00h0nP0a303oool00`1VIVH0S`0L0?X0<@0?
0?X0<@040000003j0340nP0a0?X0<@`0oooo0P2G01dD0?X0<@`0oooo0P2N01lD0?X0<@/0oooo0P2U
020D0?X0<@/0oooo0P2[028D0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@C0?X0<@<0IVIV1`3o
ool20;X091<0nP0a2P3oool20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80nP0a2P3o
ool30<P09a80nP0ao`3ooom10?ooo`00G@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340
nP0a00@0nP0a00<0IVIV0?X0<@1b05/00P1b05/>0?T0a@0306IVIP3i0<D0n@3500D0n@3500@0oooo
07d0601m01P0nP0a0`1m03490?X0H`0306IVIP3j06<0nP1S00T0nP1S0P3oool606IVIP80QP0J103j
03400`1VIVH0nP0a0?X0<@0>0?X0<@/0oooo00<0IVIV08l0702?01`0403j034010000000nP0a0?X0
<@3j034<0?ooo`80U`0M503j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R
503j034;0?ooo`80/00S4`3j034:0?ooo`<0]@0T4`3j03430?ooo`H0IVIV00<0oooo0;X0902j02@0
4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W
4P3j037o0?oood40oooo001M0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400`3j
03400`1VIVH0nP0a0?X0<@020780F`l0n@3500<0IVIV0?T0a@3i0<D01@3i0<D0103oool0O@0H07d0
603j034207d0<@T0nP1S00<0IVIV0?X0H`3j06<02P3j06<80?ooo`80QP0J0`3j03400`1VIVH0nP0a
0?X0<@0?0?X0<@/0oooo00<0IVIV08l0702?01`0403j034010000000nP0a0?X0<@3j034<0?ooo`80
U`0M503j034<0?ooo`80WP0O503j034;0?ooo`80Y@0P503j034;0?ooo`80Z`0R503j034;0?ooo`80
/00S4`3j034:0?ooo`<0]@0T4`3j03490?ooo`0306IVIP2j02@0^P0T01<0nP0a2P3oool20;h09A<0
nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80nP0a2P3oool30<P09a80nP0ao`3ooom10?ooo`00
G@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00<0nP0a00<0IVIV0?X0<@3j0340
0P1b05/60>h0_0P0n@3500<0IVIV0?T0a@3i0<D01P3i0<D0103oool0O@0H0?X0<@3j034207d0<@P0
nP1S00<0IVIV0?X0H`3j06<02`3j06<80?ooo`80QP0J0P3j03400`1VIVH0nP0a0?X0<@0@0?X0<@X0
oooo00@0IVIV0?ooo`2?01`0S`0L403j034010000000nP0a0?X0<@3j034<0?ooo`80U`0M503j034<
0?ooo`0309h07`3j0340nP0a01<0nP0a2`3oool00`2U0200nP0a0?X0<@0C0?X0<@/0oooo0P2[028D
0?X0<@/0oooo0P2`02<C0?X0<@X0oooo0`2e02@C0?X0<@X0oooo0P2j02@C0?X0<@X0oooo0P2n02DC
0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P3502LB0?X0<@X0oooo0`3802LB0?X0<Ol0oooo@@3oool0
05d0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@020?X0<@0406IVIP3j0340nP0a
0?X0<@80LP1K2`3^0;`30?T0a@0306IVIP3i0<D0n@3500H0n@3500@0oooo07d0603j0340nP0a0P1m
03480?X0H`0306IVIP3j06<0nP1S00/0nP1S203oool208H06P80nP0a00<0IVIV0?X0<@3j03403`3j
034:0?ooo`0406IVIP3oool0oooo08l07140nP0a00@000000?X0<@3j0340nP0a303oool00`2G01d0
nP0a0?X0<@0C0?X0<@`0oooo00<0WP0O0?00;`3`02l00`3`02l@0?X0<@/0oooo00<0Y@0P0?00;`3`
02l01@3`02l>0?X0<@/0oooo0P2[028D0?X0<@/0oooo00<0/00S0?X0<@3j03404P3j034:0?ooo`<0
]@0T4`3j034:0?ooo`80^P0T4`3j034:0?ooo`80_P0U4`3j034:0?ooo`80`P0V4`3j034:0?ooo`80
a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40oooo001M0?ooo`0306IVIP3oool0oooo00D0oooo
00<0LP0F0?X0<@3j03400P3j03401@1VIVH0nP0a0?X0<@3j0340LP1K00h0kP2l00@0IVIV0>h0_03^
0;`0kP2l1P3i0<D0103oool0O@0H0?X0<@3j034207d0<@L0nP1S00<0IVIV0?X0H`3j06<02`3j06<9
0?ooo`80QP0J00<0nP0a06IVIP3j03404@3j034206IVIPP0oooo00@0IVIV0?ooo`2?01`0S`0L4@3j
034010000000nP0a0?X0<@3j034<0?ooo`0309L07@3`02l0l00_00<0l00_403j034<0?ooo`/0l00_
2`3j034;0?ooo`l0l00_1`3j034;0?ooo`80Z`0R503j034;0?ooo`030;008`3a02l0l@0_00D0l@0_
3@3j034:0?ooo`80]@0T503j034:0?ooo`80^P0T4`3j03400`1VIVH0oooo0?ooo`070?ooo`80_P0U
4`3j034:0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40oooo
001M0?ooo`0306IVIP3oool0oooo00D0oooo00D0LP0F0?X0<@3j0340nP0a06IVIP040?X0<@030780
F`3^0;`0kP2l00`0kP2l00<0IVIV0>h0_03^0;`01P3^0;`20?ooo`0307d0603j0340nP0a0080O@0a
1`3j06<00`1VIVH0nP1S0?X0H`0;0?X0H`T0oooo0P2601X00`3j0340IVIV0?X0<@0A0?X0<@80oooo
1P1VIVH0103oool0IVIV0?ooo`3oool208l07100nP0a00<000000?X0<@3j03400P3j034<0?ooo`/0
l00_2`3j034;0?oooa40l00_1P3j034:0?oooaH0l00_303oool20:/08Q@0nP0a2`3oool>0?40;`L0
nP0a2P3oool20;D090D0l@0_3`3j034:0?ooo`80^P0T4`3j03400`3oool0IVIV06IVIP0406IVIP<0
oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P3502LB0?X0<@X0oooo0`3802LB0?X0<Ol0
oooo@@3oool005d0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0<@3j0340IVIV00@0
nP0a3P3^0;`00`1VIVH0kP2l0>h0_0070>h0_080oooo00<0O@0H0?X0<@3j03400P1m03460?X0H`03
06IVIP3j06<0nP1S00`0nP1S2@3oool208H06P0306IVIP3j0340nP0a0140nP0a203oool406IVIP80
S`0L403j03400`000000nP0a0?X0<@020?X0<@/0oooo4@3`02l60?X0<A00oooo4@3`02lE0?ooo``0
l00_303oool20:/08Q@0nP0a2P3ooolE0?40;`/0oooo00<0]@0T0?40;`3a02l02@3a02l:0?X0<@X0
oooo0P2j02@C0?X0<@L0oooo0`1VIVH20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80
nP0a2P3oool30<P09a80nP0ao`3ooom10?ooo`00G@3oool00`1VIVH0oooo0?ooo`050?ooo`040780
5P3j0340nP0a06IVIPD0nP0a3P3^0;`00`1VIVH0kP2l0>h0_0060>h0_0<0oooo00<0O@0H0?X0<@1m
03400P1m03460?X0H`0306IVIP3j06<0nP1S00`0nP1S2@3oool00`2601X0nP0a06IVIP0C0?X0<@P0
oooo00@0IVIV0?ooo`3oool0oooo0P2?01`@0?X0<@030000003j0340nP0a0080nP0a403ooolA0?00
;aH0oooo303`02lJ0?ooo`H0l00_3@3oool20:/08Q@0nP0a4`3oool<0?40;`/0oooo4@3a02l50?X0
<@X0oooo0P2j02@50?40;`h0nP0a2P3oool20;h09A<0nP0a2P3oool20<809Q<0nP0a2P3oool20<D0
9a80nP0a2P3oool30<P09a80nP0ao`3ooom10?ooo`00G@3oool00`1VIVH0oooo0?ooo`050?ooo`04
07805P3j0340nP0a06IVIP@0nP0a3P3^0;`00`1VIVH0kP2l0>h0_0070>h0_0<0oooo00<0O@0H0?X0
<@1m03400P1m03450?X0H`0306IVIP3j06<0nP1S00d0nP1S2@3oool00`2601X0IVIV0?X0<@0C0?X0
<@P0oooo00@0IVIV0?ooo`3oool0oooo0P2?01`@0?X0<@030000003j0340nP0a0080nP0a5@3oool<
0?00;a/0oooo1P3`02l^0?ooo`80Z`0R503j034H0?ooo`H0l@0_4@3oool@0?40;`/0oooo00<0^P0T
0?40;`3a02l02@3a02l90?X0<@X0oooo0P2n02DC0?X0<@X0oooo0P3202HC0?X0<@X0oooo0P3502LB
0?X0<@X0oooo0`3802LB0?X0<Ol0oooo@@3oool005d0oooo00<0IVIV0?ooo`3oool01@3oool20?X0
<@0306IVIP3j0340nP0a00/0nP0a1P3^0;`00`1VIVH0kP2l0>h0_0060>h0_0@0oooo00<0O@0H0?X0
<@1m03400P1m03450?X0H`0306IVIP3j06<0nP1S00d0nP1S2@3oool00`2601X0IVIV0?X0<@0C0?X0
<@L0oooo00<0IVIV0?ooo`3oool00P3oool208l07100nP0a00<000000?X0<@3j03400P3j034J0?oo
o`H0l00_D03oool20:/08Q@0nP0a<`3oool<0?40;`/0oooo4@3a02l40?X0<@X0oooo0P2n02D50?40
;`h0nP0a2P3oool20<809Q<0nP0a2P3oool20<D09a80nP0a2P3oool30<P09a80nP0ao`3ooom10?oo
o`00G03oool00`1VIVH0oooo0?ooo`060?ooo`80nP0a00<0IVIV0?X0<@3j0340403j03400`1VIVH0
oooo0>h0_0070>h0_0@0oooo00<0O@0H0?X0<@1m03400P1m03440?X0H`0306IVIP3j06<0nP1S00h0
nP1S2@3oool00`1VIVH0nP0a0?X0<@0C0?X0<@H0oooo00<0IVIV0?ooo`3oool00`3oool208l07100
nP0a00<000000?X0<@3j03400P3j034306IVIVd0oooo00<0Z`0R0?X0<@3j03404`3j034h0?ooo`H0
l@0_4@3oool@0?40;`X0oooo00<0_P0U0?40;`3a02l02@3a02l90?X0<@@0IVIV1P3oool20<809Q<0
nP0a2P3oool20<D09a80nP0a2P3oool30<P09a80nP0ao`3ooom10?ooo`00G03oool00`1VIVH0oooo
0?ooo`050?ooo`0407805P3j0340nP0a06IVIQ80nP0a00<0IVIV0?ooo`3oool02`3oool00`1m01P0
nP0a07d0<@0207d0<@@0nP1S00<0IVIV0?X0H`3j06<03P3j06<90?ooo`0306IVIP3j0340nP0a01<0
nP0a1P3oool00`1VIVH0oooo0?ooo`030?ooo`80S`0L403j03400`000000nP0a0?X0<@020?X0<@<0
oooo1P1VIVIW0?ooo`030:/08P3`02l0l00_00D0l00_3P3j035C0?ooo`/0l@0_2`3ooolA0?40;`@0
nP0a103oool606IVIP80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40
oooo001L0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@1VIVH04P3j03400`1VIVH0nP0a
0?ooo`0;0?ooo`80O@0H00@0nP0a07d0<@1m0340O@0a0`3j06<00`1VIVH0nP1S0?X0H`0?0?X0H`P0
oooo00<0IVIV08H06P3j0340503j03450?ooo`0306IVIP3oool0oooo00@0oooo0P2?01`@0?X0<@03
0000003j0340nP0a0080nP0a2@3oool606IVIV40oooo3`3`02l70?X0<Fh0oooo403a02l:0?ooo`80
`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40oooo001L0?ooo`0306IV
IP3oool0oooo00D0oooo00<0LP0F0?X0<@1VIVH04P3j03400`1VIVH0nP0a0?ooo`0;0?ooo`80O@0H
00@0nP0a07d0<@1m0340O@0a0`3j06<00`1VIVH0nP1S0?X0H`0?0?X0H`L0oooo00<0IVIV0?ooo`26
01X05@3j03450?ooo`0306IVIP3oool0oooo00@0oooo0P2?01`@0?X0<@040000003j0340nP0a0?X0
<A00oooo1P1VIVIJ0?oooaH0l00_L`3oool;0?40;`/0oooo0P3202HC0?X0<@X0oooo0P3502LB0?X0
<@X0oooo0`3802LB0?X0<Ol0oooo@@3oool005`0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0
IVIV0?X0<@0A0?X0<@0306IVIP3j0340nP0a00`0oooo0P1m01P0103j0340O@0a07d0<@1m03420?X0
H`0306IVIP3j06<0nP1S0100nP1S1`3oool00`1VIVH0QP0J08H06P0E0?X0<@@0oooo00<0IVIV0?oo
o`3oool01@3oool208l07100nP0a00@000000?X0<@3j0340nP0a5P3oool606IVIUh0oooo303`02n9
0?ooo`80`P0V4`3j034:0?ooo`80a@0W4P3j034:0?ooo`<0b00W4P3j037o0?oood40oooo001L0?oo
o`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j03404@3j03400`1VIVH0nP0a0?X0<@0<0?oo
o`0307d0603j0340nP0a0080O@0a0`3j06<00`1VIVH0nP1S0?X0H`0@0?X0H`H0oooo00@0IVIV0?oo
o`2601X0QP0J5@3j03440?ooo`0306IVIP3oool0oooo00D0oooo0P2?01`@0?X0<@040000003j0340
nP0a0?X0<A`0oooo1P1VIVIM0?ooo`H0l00_RP3oool20<809PD0l@0_3P3j034206IVIPP0oooo0P35
02LB0?X0<@X0oooo0`3802LB0?X0<Ol0oooo@@3oool005`0oooo00<0IVIV0?ooo`3oool01@3oool0
0`1VIVH0nP0a0?X0<@0@0?X0<@0306IVIP3j0340nP0a00d0oooo00<0O@0H0?X0<@3j03400P1m0342
0?X0H`0306IVIP3j06<0nP1S0140nP1S1P3oool0101VIVH0oooo08H06P2601XE0?X0<@<0oooo00<0
IVIV0?ooo`3oool01P3oool208l07100nP0a00@000000?X0<@3j0340nP0a8P3oool606IVI^L0oooo
00<0`P0V0?40;`3a02l02@3a02l90?X0<@80oooo1P1VIVH20?ooo`030<D09`3a02l0l@0_00D0l@0_
303j034:0?ooo`<0b00W4P3j037o0?oood40oooo001L0?ooo`0306IVIP3oool0oooo00D0oooo00<0
IVIV0?X0<@3j0340403j03400`1VIVH0nP0a0?X0<@0=0?ooo`0307d0603j0340nP0a0080O@0a0P3j
06<00`1VIVH0nP1S0?X0H`0A0?X0H`D0oooo00<0IVIV0?ooo`3oool00P2601XE0?X0<@<0oooo00<0
IVIV0?ooo`3oool01P3oool208l07100nP0a00@000000?X0<@3j0340nP0a:03oool606IVI^40oooo
4@3a02l40?X0<@P0oooo0P1VIVH>0?40;`H0nP0a2P3oool30<P09a80nP0ao`3ooom10?ooo`00G03o
ool00`1VIVH0oooo0?ooo`040?ooo`0306IVIP1b01H0nP0a0100nP0a00@0IVIV0?X0<@3j0340nP0a
3@3oool00`1m01P0nP0a0?X0<@0207d0<@030?X0H`1VIVH0nP1S0180nP1S1P3oool00`1VIVH0oooo
0?ooo`0208H06QD0nP0a0P3oool00`1VIVH0oooo0?ooo`070?ooo`80S`0L403j034010000000nP0a
0?X0<@3j034^0?ooo`H0IVIVh03oool@0?40;`h0oooo00<0IVIV0?40;`3a02l03@3a02l:0?ooo`<0
b00W4P3j037o0?oood40oooo001L0?ooo`0306IVIP3oool0oooo00@0oooo00<0IVIV07805P3j0340
403j0340101VIVH0nP0a0?X0<@3j034=0?ooo`0307d0603j0340nP0a0080O@0a00<0nP1S06IVIP3j
06<04P3j06<50?ooo`0406IVIP3oool0oooo0?ooo`80QP0J5@3j03400`3oool0IVIV0?ooo`090?oo
o`80S`0L403j034010000000nP0a0?X0<@3j034d0?ooo`H0IVIVgP3oool;0?40;a@0oooo2P3a02l;
0?ooo`<0b00W4P3j037o0?oood40oooo001L0?ooo`0306IVIP3oool0oooo00<0oooo00<0IVIV0?oo
o`1b01H0403j03400`1VIVH0nP0a0?X0<@020?X0<@d0oooo00<0O@0H0?X0<@3j03400P1m03400`1V
IVH0nP1S0?X0H`0B0?X0H`D0oooo00@0IVIV0?ooo`3oool0oooo0P2601XD0?X0<@80oooo00<0IVIV
0?ooo`3oool0203oool00`2?01`0nP0a0?X0<@0?0?X0<@040000003j0340nP0a0?X0<CX0oooo1P1V
IVKm0?ooo`H0IVIV2@3oool20<P09`L0l@0_303j037o0?oood40oooo001L0?ooo`0306IVIP3oool0
oooo00<0oooo00<0IVIV0?ooo`3j0340403j03400`1VIVH0nP0a0?X0<@020?X0<@d0oooo00<0O@0H
0?X0<@1m03400P1m03400`1VIVH0nP1S0?X0H`0B0?X0H`@0oooo00<0IVIV0?ooo`3oool00P3oool0
0`2601X0nP0a0?X0<@0C0?X0<@030?ooo`1VIVH0oooo00T0oooo0P2?01`A0?X0<@040000003j0340
nP0a0?X0<D00oooo1P1VIVKm0?ooo`D0IVIV103oool?0?40;`H0nP0ao`3ooom10?ooo`00F`3oool0
0`1VIVH0oooo0?ooo`030?ooo`0306IVIP3oool0oooo0100nP0a00<0IVIV0?X0<@3j03400`3j034=
0?ooo`0507d0603j0340O@0a07d0<@1VIVH05@3j06<40?ooo`0306IVIP3oool0oooo0080oooo00<0
QP0J0?X0<@3j03404`3j03400`3oool0IVIV0?ooo`090?ooo`80S`0L4@3j034010000000nP0a0?X0
<@3j03560?ooo`H0IVIVo03oool606IVIP<0oooo403a02oo0?oood40oooo001K0?ooo`0306IVIP3o
ool0oooo00<0oooo00<0IVIV0?ooo`1b01H0403j03400`1VIVH0nP0a0?X0<@030?X0<@d0oooo00D0
O@0H0?X0<@1m0340O@0a06IVIP0E0?X0H`<0oooo00<0IVIV0?ooo`3oool00`3oool00`2601X0nP0a
0?X0<@0C0?X0<@0306IVIP3oool0oooo00T0oooo0P2?01`@0?X0<@030000003j0340nP0a0080nP0a
C03oool606IVI_`0oooo1P1VIVH00`3oool0l@0_0?40;`090?40;ol0oooo@P3oool005/0oooo00<0
IVIV0?ooo`3oool00P3oool0101VIVH0oooo0?ooo`1b01H?0?X0<@0306IVIP3j0340nP0a00@0nP0a
303oool207d060040?X0<@1m0340IVIV07d0<AD0nP1S0`3oool00`1VIVH0oooo0?ooo`030?ooo`03
08H06P3j0340nP0a01<0nP0a00<0IVIV0?ooo`3oool02@3oool208l07100nP0a00<000000?X0<@3j
03400P3j035B0?ooo`H0IVIVo03oool606IVI_l0ooooB03oool005/0oooo00<0IVIV0?ooo`3oool0
0P3oool0101VIVH0oooo0?ooo`1b01H?0?X0<@0306IVIP3j0340nP0a00@0nP0a303oool207d06004
0?X0<@1m0340IVIV07d0<AD0nP1S0P3oool00`1VIVH0oooo0?ooo`040?ooo`0308H06P3j0340nP0a
0180nP0a00<0IVIV0?ooo`3oool02P3oool208l07100nP0a00<000000?X0<@3j03400P3j035H0?oo
o`H0IVIVo03oool506IVI_l0oooo@`3oool005/0oooo00D0IVIV0?ooo`3oool0oooo06IVIP030?oo
o`0307805P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j03401@3j034<0?ooo`80O@0H00@0nP0a06IV
IP1m0340O@0a5@3j06<00`3oool0IVIV0?ooo`060?ooo`0308H06P3j0340nP0a0140nP0a00<0IVIV
0?X0<@3oool02`3oool208l07100nP0a00<000000?X0<@3j03400P3j035N0?ooo`H0IVIVn`3oool6
06IVI_l0oooo?@3oool005/0oooo00D0IVIV0?ooo`3oool0oooo06IVIP030?ooo`0307805P3j0340
nP0a00`0nP0a00<0IVIV0?X0<@3j03401@3j034<0?ooo`80O@0H00@0IVIV07d0<@1m0340O@0a5@3j
06<00`3oool0IVIV0?ooo`060?ooo`0308H06P3j0340nP0a0140nP0a00<0IVIV0?X0<@3oool02`3o
ool208l07100nP0a00<000000?X0<@3j03400P3j035T0?ooo`H0IVIVn`3oool606IVI_l0oooo=`3o
ool005/0oooo00@0IVIV0?ooo`3oool0IVIV103oool00`1b01H0nP0a0?X0<@0;0?X0<@0306IVIP3j
0340nP0a00H0nP0a303oool00`1m01P0nP0a06IVIP0207d0<AH0nP1S00<0IVIV0?ooo`3oool01P3o
ool00`2601X0nP0a0?X0<@0@0?X0<@0306IVIP3j0340nP0a00`0oooo0P2?01`@0?X0<@030000003j
0340nP0a0080nP0aJP3oool606IVI_/0oooo1P1VIVKo0?oooc40oooo001K0?ooo`0406IVIP3oool0
oooo06IVIP@0oooo00<0LP0F0?X0<@3j03402`3j03400`1VIVH0nP0a0?X0<@050?X0<@d0oooo00<0
O@0H06IVIP3j03400P1m03470>h0GPl0nP1S00<0IVIV0?ooo`3oool01@3oool208H06Q80nP0a00<0
IVIV0?X0<@3j0340303oool208l07100nP0a100000000`3j0340oooo0?ooo`1^0?ooo`H0IVIVn`3o
ool306IVI_l0oooo;P3oool005/0oooo00<0IVIV0?ooo`1VIVH01@3oool00`1b01H0nP0a0?X0<@0:
0?X0<@0306IVIP3j0340nP0a00H0nP0a3@3oool0101m01P0IVIV0?X0<@1m034?0>h0GPL0nP1S00<0
IVIV0?ooo`3oool01P3oool208H06Q40nP0a00@0IVIV0?X0<@3j0340nP0a303oool208l070l0nP0a
00<0IVIV0000003j03400`3j035f0?ooo`H0IVIVo`3ooooo0?ooobL0oooo001K0?ooo`0306IVIP3o
ool0IVIV00D0oooo00<0LP0F0?X0<@3j03402P3j03400`1VIVH0nP0a0?X0<@060?X0<@d0oooo00@0
IVIV0?X0<@3j0340O@0a5P3^05h00`1VIVH0oooo0?ooo`060?ooo`80QP0J4@3j0340101VIVH0nP0a
0?X0<@3j034<0?ooo`80S`0L3`3j03400`1VIVH000000?X0<@030?X0<G`0oooo1P1VIVKo0?ooool0
oooo8@3oool005/0oooo0P1VIVH60?ooo`0307805P3j0340nP0a00T0nP0a00<0IVIV0?X0<@3j0340
1`3j034=0?ooo`0306IVIP3j0340nP0a01H0kP1N00<0IVIV0?ooo`3oool01`3oool208H06Q00nP0a
00<0IVIV0?X0<@3j03400P3j034<0?ooo`80S`0L3P3j03400`1VIVH0nP0a000000040?X0<H80oooo
1P1VIVKo0?ooool0oooo6`3oool005X0oooo00<0IVIV0?ooo`1VIVH01P3oool<0?X0<@0306IVIP3j
0340nP0a00L0nP0a303oool0101VIVH0O@0H0?X0<@3j034F0>h0GP0306IVIP3oool0oooo00L0oooo
0P2601X?0?X0<@0306IVIP3j0340nP0a00<0nP0a303oool208l070h0nP0a00<0IVIV0?X0<@000000
0`3j03690?ooo`H0IVIVo`3ooooo0?oooaD0oooo001J0?ooo`80IVIV1`3oool;0?X0<@0306IVIP3j
0340nP0a00P0nP0a303oool00`1VIVH0O@0H0?X0<@0F0>h0GP0306IVIP3oool0oooo00P0oooo0P26
01X?0?X0<@0306IVIP3j0340nP0a00<0nP0a303oool208l070d0nP0a00@0IVIV0?X0<@3j03400000
0`3j036?0?ooo`H0IVIVo`3ooooo0?ooo`l0oooo001J0?ooo`D0IVIV0`3oool00`1b01H0nP0a0?X0
<@090?X0<@0306IVIP3j0340nP0a00P0nP0a2`3oool00`1VIVH0oooo07d060080?X0<@l0kP1N00<0
IVIV0?ooo`3oool0203oool00`2601X0nP0a0?X0<@0=0?X0<@0306IVIP3j0340nP0a00@0nP0a303o
ool208l070`0nP0a00D0IVIV0?X0<@3j0340nP0a000000030?X0<ID0oooo1P1VIVKo0?ooool0oooo
2@3oool005X0oooo00<0IVIV0?ooo`3oool00P3oool306IVIP0307805P3j0340nP0a00P0nP0a00<0
IVIV0?X0<@3j03402@3j034;0?ooo`0306IVIP3oool0O@0H00l0nP0a1`3^05h00`1VIVH0oooo0?oo
o`090?ooo`0308H06P3j0340nP0a00d0nP0a00<0IVIV0?X0<@3j0340103j034<0?ooo`0308l0703j
0340nP0a00/0nP0a00D0IVIV0?X0<@3j0340nP0a000000030?X0<I/0oooo1P1VIVKo0?ooool0oooo
0`3oool005X0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@080?X0<@0306IVIP3j
0340nP0a00T0nP0a2P3oool0101VIVH0oooo0?ooo`1m01PE0?X0<@0306IVIP3oool0oooo00X0oooo
00<0QP0J0?X0<@3j0340303j03400`1VIVH0nP0a0?X0<@040?X0<@d0oooo00<0S`0L0?X0<@3j0340
2P3j03400`1VIVH0nP0a0?X0<@020?X0<@040000003j0340nP0a0?X0<J40oooo1P1VIVKo0?oooo`0
oooo001J0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03401`3j03400`1VIVH0nP0a
0?X0<@0:0?X0<@X0oooo00@0IVIV0?ooo`1m01P0O@0H5@3j03400`1VIVH0oooo0?ooo`0:0?ooo`03
08H06P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j0340103j034<0?ooo`80S`0L303j03400`1VIVH0
nP0a0?X0<@020?X0<@040000003j0340nP0a0?X0<JL0oooo1P1VIVKo0?ooooH0oooo001J0?ooo`03
06IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0<@T0
oooo00<0IVIV0?ooo`3oool00P1m01PD0?X0<@0306IVIP3oool0oooo00/0oooo00<0QP0J0?X0<@3j
03402`3j03400`1VIVH0nP0a0?X0<@050?X0<@`0oooo0P2?01`;0?X0<@0306IVIP3j0340nP0a00<0
nP0a00@000000?X0<@3j0340nP0a[@3oool606IVI_l0ooool03oool005X0oooo00<0IVIV0?ooo`3o
ool01@3oool00`1b01H0nP0a0?X0<@060?X0<@0306IVIP3j0340nP0a00/0nP0a1@1VIVH40?ooo`03
06IVIP3oool0oooo0080O@0H503j03400`1VIVH0oooo0?ooo`0;0?ooo`0308H06P3j0340nP0a00X0
nP0a00<0IVIV0?X0<@3j03401P3j034<0?ooo`80S`0L2P3j03400`1VIVH0nP0a0?X0<@040?X0<@04
0000003j0340nP0a0?X0<K<0oooo1P1VIVKo0?ooonX0oooo001J0?ooo`0306IVIP3oool0oooo00D0
oooo00<0LP0F0?X0<@3j03401P3j03400`1VIVH0nP0a0?X0<@0:0?X0<@H0oooo1P1VIVH00`3oool0
O@0H07d0600C0?X0<@0306IVIP3j0340oooo00`0oooo00<0QP0J0?X0<@3j03402P3j03400`1VIVH0
nP0a0?X0<@060?X0<@`0oooo0P2?01`:0?X0<@0306IVIP3j0340nP0a00<0nP0a00<000000?X0<@3j
03400P3j036i0?ooo`H0IVIVo`3ooooT0?ooo`00FP3oool00`1VIVH0oooo0?ooo`050?ooo`030780
5P3j0340nP0a00D0nP0a00<0IVIV0?X0<@3j03402`3j03490?ooo`0506IVIP3oool0oooo06IVIP1m
01P0503j03400`1VIVH0nP0a0?ooo`0<0?ooo`0308H06P3j0340nP0a00T0nP0a00<0IVIV0?X0<@3j
03401`3j034<0?ooo`80S`0L2@3j03400`1VIVH0nP0a0?X0<@040?X0<@030000003j0340nP0a0080
nP0a_`3oool606IVI_l0oooogP3oool005X0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a
0?X0<@050?X0<@0306IVIP3j0340nP0a00/0nP0a203oool00`1VIVH0oooo0?ooo`020?ooo`0307d0
603j0340nP0a0140nP0a00<0IVIV0?X0<@3j03403@3oool00`2601X0nP0a0?X0<@090?X0<@0306IV
IP3j0340nP0a00L0nP0a303oool208l070T0nP0a00<0IVIV0?X0<@3j0340103j03400`000000nP0a
0?X0<@020?X0<LD0oooo1P1VIVKo0?ooomP0oooo001J0?ooo`0306IVIP3oool0oooo00D0oooo00<0
LP0F0?X0<@3j0340103j03400`1VIVH0nP0a0?X0<@0<0?X0<@P0oooo00<0IVIV0?ooo`3oool00P3o
ool00`1m01P0nP0a0?X0<@0A0?X0<@0306IVIP3j0340nP0a00d0oooo00<0QP0J0?X0<@3j0340203j
03400`1VIVH0nP0a0?X0<@080?X0<@`0oooo0P2?01`80?X0<@0306IVIP3j0340nP0a00D0nP0a00<0
00000?X0<@3j03400P3j037;0?ooo`H0IVIVo`3ooooB0?ooo`00F@3oool00`1VIVH0oooo0?ooo`06
0?ooo`L0nP0a00<0IVIV0?X0<@3j0340303j03470?ooo`0306IVIP3oool0oooo00<0oooo00<0O@0H
0?X0<@3j0340403j03401@1VIVH0nP0a0?X0<@3j0340IVIV00/0oooo0P2601X:0?X0<@0306IVIP3j
0340nP0a00P0nP0a303oool208l070L0nP0a00<0IVIV0?X0<@3j03401P3j03400`000000nP0a0?X0
<@020?X0<M40oooo1P1VIVKo0?oool`0oooo001I0?ooo`0306IVIP3oool0oooo00H0oooo1P3j0340
0`1VIVH0nP0a0?X0<@0=0?X0<@L0oooo00<0IVIV0?ooo`3oool00`3oool00`1m01P0nP0a0?X0<@0@
0?X0<@0306IVIP3j0340nP0a0080oooo1P1VIVH50?ooo`80QP0J2@3j03400`1VIVH0nP0a0?X0<@09
0?X0<@`0oooo0P2?01`70?X0<@0306IVIP3j0340nP0a00H0nP0a00<000000?X0<@3j03400P3j037G
0?ooo`H0IVIVo`3oooo60?ooo`00F@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a
00@0nP0a00<0IVIV0?X0<@3j03403@3j03460?ooo`0306IVIP3oool0oooo00@0oooo00<0O@0H0?X0
<@3j03403`3j0340101VIVH0nP0a0?X0<@3j03480?ooo`D0IVIV0P2601X80?X0<@0306IVIP3j0340
nP0a00X0nP0a303oool208l070H0nP0a00<0IVIV0?X0<@3j03401`3j03400`000000nP0a0?X0<@02
0?X0<Md0oooo1P1VIVKo0?oool00oooo001I0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0
<@3j03400`3j03400`1VIVH0nP0a0?X0<@0>0?X0<@H0oooo00<0IVIV0?ooo`3oool0103oool00`1m
01P0nP0a0?X0<@0?0?X0<@0406IVIP3j0340nP0a0?X0<@d0oooo0P2601X80?X0<@0306IVIP3j0340
nP0a00X0nP0a303oool208l070H0nP0a00<0IVIV0?X0<@3j03401`3j03400`000000nP0a0?X0<@02
0?X0<N<0oooo1P1VIVKo0?oookX0oooo001I0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0
<@3j03400`3j03400`1VIVH0nP0a0?X0<@0>0?X0<@D0oooo00<0IVIV0?ooo`3oool01@3oool00`1m
01P0nP0a0?X0<@0>0?X0<@0306IVIP3j0340nP0a0080nP0a3@3oool00`2601X0nP0a0?X0<@060?X0
<@0306IVIP3j0340nP0a00/0nP0a303oool208l070D0nP0a00<0IVIV0?X0<@3j0340203j03400`00
0000nP0a0?X0<@020?X0<NT0oooo1P1VIVKo0?oook@0oooo001I0?ooo`0306IVIP3oool0oooo00D0
oooo00<0LP0F0?X0<@3j03400P3j03400`1VIVH0nP0a0?X0<@0?0?X0<@D0oooo00<0IVIV0?ooo`3o
ool01@3oool00`1m01P0nP0a0?X0<@0=0?X0<@0306IVIP3j0340nP0a00<0nP0a3@3oool00`2601X0
nP0a0?X0<@060?X0<@0306IVIP3j0340nP0a00/0nP0a303oool208l070@0nP0a00<0IVIV0?X0<@3j
03402@3j03400`000000nP0a0?X0<@020?X0<Nl0oooo1P1VIVKo0?ooojh0oooo001I0?ooo`0306IV
IP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j03400`1VIVH0nP0a0?X0<@0?0?X0<@@0oooo
00<0IVIV0?ooo`3oool01P3oool00`1m01P0nP0a0?X0<@0=0?X0<@0306IVIP3j0340nP0a00<0nP0a
3@3oool00`2601X0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a00`0nP0a0`1VIVH90?ooo`80S`0L
103j03400`1VIVH0nP0a0?X0<@090?X0<@030000003j0340nP0a0080nP0am@3oool606IVI_l0oooo
Z03oool005T0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0<@3j0340IVIV0180nP0a
103oool00`1VIVH0oooo0?ooo`050?ooo`80O@0H3P3j03400`1VIVH0nP0a0?X0<@040?X0<@d0oooo
00<0QP0J0?X0<@3j03401@3j03400`1VIVH0nP0a0?X0<@0<0?X0<@<0oooo1`1VIVH20?ooo`80S`0L
0`3j03400`1VIVH0nP0a0?X0<@0:0?X0<@030000003j0340nP0a0080nP0an`3oool606IVI_l0oooo
XP3oool005T0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0<@3j0340IVIV0180nP0a
0`3oool00`1VIVH0oooo0?ooo`060?ooo`80O@0H3P3j03400`1VIVH0nP0a0?X0<@040?X0<@d0oooo
00<0QP0J0?X0<@3j0340103j03400`1VIVH0nP0a0?X0<@0=0?X0<@X0oooo0P1VIVH00`2?01`0nP0a
0?X0<@020?X0<@0306IVIP3j0340nP0a00X0nP0a00@000000?X0<@3j0340nP0ao`3oool30?ooo`H0
IVIVo`3ooonL0?ooo`00F@3oool00`1VIVH0oooo0?ooo`050?ooo`0407805P3j0340nP0a06IVIQ80
nP0a0`3oool00`1VIVH0oooo0?ooo`070?ooo`80O@0H3@3j03400`1VIVH0nP0a0?X0<@050?X0<@d0
oooo00<0QP0J0?X0<@3j0340103j03400`1VIVH0nP0a0?X0<@0<0?X0<@d0oooo00D0S`0L0?X0<@3j
0340nP0a06IVIP0=0?X0<@040000003j0340nP0a0?X0<Ol0oooo2@3oool606IVI_l0ooooUP3oool0
05T0oooo00<0IVIV0?ooo`3oool01@3oool0101b01H0nP0a0?X0<@1VIVHB0?X0<@<0oooo00<0IVIV
0?ooo`3oool01`3oool00`1m01P0nP0a0?X0<@0<0?X0<@0306IVIP3j0340nP0a00D0nP0a3@3oool0
0`2601X0nP0a0?X0<@030?X0<@0306IVIP3j0340nP0a00d0nP0a303oool208l070<0nP0a00<0IVIV
0?X0<@3j03402`3j034010000000nP0a0?X0<@3j037o0?ooo`l0oooo1P1VIVKo0?oooi00oooo001H
0?ooo`0306IVIP3oool0oooo00H0oooo00<0LP0F0?X0<@1VIVH04`3j03420?ooo`0306IVIP3oool0
oooo00P0oooo00<0O@0H0?X0<@3j03402`3j03400`1VIVH0nP0a0?X0<@060?X0<@d0oooo00<0QP0J
0?X0<@3j03400P3j03400`1VIVH0nP0a0?X0<@0>0?X0<@`0oooo0P2?01`20?X0<@0306IVIP3j0340
nP0a00`0nP0a00@000000?X0<@3j0340nP0ao`3ooolE0?ooo`H0IVIVo`3ooon:0?ooo`00F03oool0
0`1VIVH0oooo0?ooo`060?ooo`80nP0a00<0IVIV0?X0<@3j03404@3j03420?ooo`0306IVIP3oool0
oooo00P0oooo00<0O@0H0?X0<@3j03402`3j03400`1VIVH0nP0a0?X0<@060?X0<@d0oooo00<0QP0J
0?X0<@3j03400P3j03400`1VIVH0nP0a0?X0<@0>0?X0<@`0oooo0P2?01`00`3j0340IVIV0?X0<@0>
0?X0<@040000003j0340nP0a0?X0<@L0IVIVo`3ooolD0?ooo`H0IVIVo`3ooon40?ooo`00F03oool0
0`1VIVH0oooo0?ooo`060?ooo`030?X0<@1VIVH0nP0a01<0nP0a00<0oooo06IVIP3oool02P3oool0
0`1m01P0nP0a0?X0<@0:0?X0<@0306IVIP3j0340nP0a00L0nP0a3@3oool01@2601X0nP0a0?X0<@3j
0340IVIV0140nP0a303oool208l070030?X0<@1VIVH0nP0a00h0nP0a00@000000?X0<@3j0340nP0a
1`3oool606IVI_l0oooo503oool606IVI_l0ooooOP3oool005P0oooo00<0IVIV0?ooo`3oool01@3o
ool00`1b01H0nP0a06IVIP0D0?X0<@030?ooo`1VIVH0oooo00X0oooo00<0O@0H0?X0<@3j03402P3j
03400`1VIVH0nP0a0?X0<@070?X0<@d0oooo00D0QP0J0?X0<@3j0340nP0a06IVIP0A0?X0<@`0oooo
0P2?01`00`1VIVH0nP0a0?X0<@0=0?X0<@030000003j0340nP0a0080nP0a3@3oool606IVI_l0oooo
503oool606IVI_l0ooooN03oool005P0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0IVIV0?X0
<@0D0?X0<@0306IVIP3oool0oooo00X0oooo00<0O@0H0?X0<@3j03402@3j03400`1VIVH0nP0a0?X0
<@070?X0<@d0oooo0P2601X20?X0<@0306IVIP3j0340nP0a0100nP0a303oool208l0700306IVIP3j
0340nP0a00d0nP0a00<000000?X0<@3j03400P3j034C0?ooo`H0IVIVo`3ooolD0?ooo`H0IVIVo`3o
oomb0?ooo`00F03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P1VIVH0nP0a01@0nP0a00<0IVIV
0?ooo`3oool02P3oool00`1m01P0nP0a0?X0<@080?X0<@0306IVIP3j0340nP0a00P0nP0a3@3oool2
08H06P80nP0a00<0IVIV0?X0<@3j0340403j034<0?ooo`0308l0701VIVH0nP0a00l0nP0a0`000002
0?X0<AT0oooo1`1VIVKo0?oooa<0oooo1P1VIVKo0?ooof`0oooo001H0?ooo`0306IVIP3oool0oooo
00D0oooo00<0IVIV0?X0<@3j03404`3j03400`1VIVH0oooo0?ooo`0;0?ooo`0307d0603j0340nP0a
00P0nP0a00<0IVIV0?X0<@3j0340203j034=0?ooo`80QP0J00<0nP0a06IVIP3j03404P3j034<0?oo
o`0306IVIP2?01`0nP0a00l0nP0a00<000000?X0<@3j03400P00000P0?ooo`H0IVIVo`3ooolC0?oo
o`H0IVIVo`3ooomV0?ooo`00F03oool00`1VIVH0oooo0?ooo`050?ooo`0306IVIP3j0340nP0a01<0
nP0a00<0IVIV0?ooo`3oool02`3oool00`1m01P0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a00T0
nP0a3@3oool00`2601X0nP0a06IVIP0D0?X0<@`0oooo00<0IVIV08l0703j03403`3j03400`000000
nP0a0?X0<@020?X0<BH0oooo1P1VIVKo0?oooa<0oooo1P1VIVKo0?ooof00oooo001H0?ooo`0306IV
IP3oool0oooo00@0oooo00<0IVIV07805P3j03404`3j03400`1VIVH0nP0a0?ooo`0<0?ooo`0307d0
603j0340nP0a00L0nP0a00<0IVIV0?X0<@3j03402@3j034=0?ooo`0308H06P3j0340IVIV01@0nP0a
2`3oool00`1VIVH0S`0L08l0700@0?X0<@030000003j0340nP0a0080nP0a;03oool606IVI_l0oooo
4`3oool606IVI_l0ooooFP3oool005P0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0LP0F0?X0
<@0C0?X0<@0306IVIP3j0340oooo00/0oooo0P1m01P80?X0<@0306IVIP3j0340nP0a00X0nP0a3@3o
ool00`2601X0IVIV0?X0<@0D0?X0<@/0oooo00<0IVIV08l0702?01`0403j03400`000000nP0a0?X0
<@020?X0<C80oooo1`1VIVKo0?oooa80oooo1P1VIVKo0?oooe@0oooo001H0?ooo`0306IVIP3oool0
oooo00<0oooo00<0IVIV0?ooo`1b01H04`3j03400`1VIVH0nP0a0?ooo`0<0?ooo`80O@0H203j0340
0`1VIVH0nP0a0?X0<@0:0?X0<@d0oooo00<0QP0J06IVIP3j0340503j034:0?ooo`0406IVIP3oool0
S`0L08l07100nP0a00<000000?X0<@3j03400P3j034i0?ooo`H0IVIVo`3ooolB0?ooo`H0IVIVo`3o
oom>0?ooo`00F03oool00`1VIVH0oooo0?ooo`030?ooo`0306IVIP3oool0LP0F01<0nP0a00<0IVIV
0?X0<@3oool0303oool207d060L0nP0a00<0IVIV0?X0<@3j03402`3j034=0?ooo`0306IVIP3j0340
nP0a01@0nP0a2@3oool00`1VIVH0oooo0?ooo`0208l07100nP0a00<000000?X0<@3j03400P3j034o
0?ooo`H0IVIVo`3ooolB0?ooo`H0IVIVo`3ooom80?ooo`00E`3oool00`1VIVH0oooo0?ooo`030?oo
o`0406IVIP3oool0oooo07805Q80nP0a00<0IVIV0?X0<@3j03403@3oool00`1m01P0nP0a0?X0<@06
0?X0<@0306IVIP3j0340nP0a00/0nP0a3@3oool00`1VIVH0nP0a0?X0<@0D0?X0<@T0oooo00<0IVIV
0?ooo`3oool00P2?01`@0?X0<@030000003j0340nP0a0080nP0aA@3oool606IVI_l0oooo4P3oool6
06IVI_l0oooo@P3oool005L0oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0oooo0?ooo`0C0?X0
<@0306IVIP3j0340nP0a00d0oooo00<0O@0H0?X0<@3j03401@3j03400`1VIVH0nP0a0?X0<@0<0?X0
<@`0oooo00<0IVIV08H06P3j03405@3j03480?ooo`0506IVIP3oool0oooo0?ooo`2?01`04@3j0340
0`000000nP0a0?X0<@020?X0<D/0oooo1P1VIVKo0?oooa80oooo1P1VIVKo0?oooc`0oooo001G0?oo
o`0306IVIP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0LP0F4P3j0340101VIVH0nP0a0?X0<@3j
034=0?ooo`0307d0603j0340nP0a00D0nP0a00<0IVIV0?X0<@3j0340303j034;0?ooo`0306IVIP3o
ool0QP0J01H0nP0a203oool0101VIVH0oooo0?ooo`3oool80>d0;`X0nP0a00<000000?X0<@3j0340
0P3j035A0?ooo`L0IVIVo`3ooolA0?ooo`H0IVIVo`3ooolf0?ooo`00E`3oool00`1VIVH0oooo0?oo
o`020?ooo`0406IVIP3oool0oooo07805Q80nP0a00@0IVIV0?X0<@3j0340nP0a3@3oool00`1m01P0
nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0a2`3oool00`1VIVH0oooo08H06P0E0?X0<@P0
oooo00@0IVIV0?ooo`3oool0oooo403]02l30?X0<@030000003j0340nP0a0080nP0aF03oool606IV
I_l0oooo4@3oool606IVI_l0oooo<03oool005L0oooo00D0IVIV0?ooo`3oool0oooo06IVIP030?oo
o`0307805P3j0340nP0a00l0nP0a00<0IVIV0?X0<@3j03400P3j034=0?ooo`0307d0603j0340nP0a
00@0nP0a00<0IVIV0?X0<@3j03403@3j034:0?ooo`0406IVIP3oool0oooo08H06QD0nP0a1`3oool0
0`1VIVH0oooo0?ooo`080?ooo`d0k@0_00@000000>d0;`3]02l0k@0_G`3oool606IVI_l0oooo4@3o
ool406IVI_l0oooo;03oool005L0oooo00D0IVIV0?ooo`3oool0oooo06IVIP030?ooo`0307805P3j
0340nP0a00l0nP0a00<0IVIV0?X0<@3j03400P3j034=0?ooo`0307d0603j0340nP0a00<0nP0a00<0
IVIV0?X0<@3j03403P3j034:0?ooo`0406IVIP3oool0oooo08H06QD0nP0a1`3oool00`1VIVH0oooo
0?ooo`0=0?ooo`P0k@0_00@000000>d0;`3]02l0k@0_I@3oool606IVI_l0ooooo`3ooolk0?ooo`00
E`3oool0101VIVH0oooo0?ooo`1VIVH40?ooo`0307805P3j0340nP0a00h0nP0a00<0IVIV0?X0<@3j
03400`3j034=0?ooo`0307d0603j0340nP0a0080nP0a00<0IVIV0?X0<@3j03403P3j034:0?ooo`05
06IVIP3oool0oooo0?ooo`2601X05@3j03460?ooo`0306IVIP3oool0oooo01<0oooo0`3]02l00`00
0000k@0_0>d0;`1/0?ooo`L0IVIVo`3ooooo0?oooc@0oooo001G0?ooo`0406IVIP3oool0oooo06IV
IP@0oooo00<0LP0F0?X0<@3j03403P3j03400`1VIVH0nP0a0?X0<@030?X0<@d0oooo00<0O@0H0?X0
<@3j03400P3j03400`1VIVH0nP0a0?X0<@0>0?X0<@X0oooo00D0IVIV0?ooo`3oool0oooo08H06P0E
0?X0<@H0oooo00<0IVIV0?ooo`3oool05P3oool00`000000oooo0?ooo`1c0?ooo`H0IVIVo`3ooooo
0?ooobh0oooo001G0?ooo`0306IVIP3oool0IVIV00D0oooo00<0LP0F0?X0<@3j03403@3j03400`1V
IVH0nP0a0?X0<@040?X0<@d0oooo00D0O@0H0?X0<@3j0340nP0a06IVIP0A0?X0<@T0oooo00@0IVIV
0?ooo`3oool0oooo0P2601XE0?X0<@D0oooo00<0IVIV0?ooo`3oool05`3oool00`000000oooo0?oo
o`1i0?ooo`H0IVIVo`3ooooo0?ooobP0oooo001G0?ooo`0306IVIP3oool0IVIV00D0oooo00<0LP0F
0?X0<@3j03403@3j03400`1VIVH0nP0a0?X0<@040?X0<@d0oooo00D0O@0H0?X0<@3j0340nP0a06IV
IP0A0?X0<@P0oooo00<0IVIV0?ooo`3oool00P3oool208H06QD0nP0a103oool00`1VIVH0oooo0?oo
o`0H0?ooo`030000003oool0oooo07l0oooo1P1VIVKo0?ooool0oooo8P3oool005L0oooo0P1VIVH6
0?ooo`0307805P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j0340103j034>0?ooo`0407d0603j0340
nP0a06IVIQ80nP0a203oool00`1VIVH0oooo0?ooo`020?ooo`0308H06P3j0340nP0a01@0nP0a103o
ool00`1VIVH0oooo0?ooo`0G0?ooo`030000003oool0oooo08H0oooo1`1VIVKo0?ooool0oooo6`3o
ool005L0oooo0P1VIVH60?ooo`0307805P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j0340103j034=
0?ooo`80O@0H0P3j03400`1VIVH0nP0a0?X0<@0@0?X0<@L0oooo00<0IVIV0?ooo`3oool00`3oool0
0`2601X0nP0a0?X0<@0D0?X0<@<0oooo00<0IVIV0?ooo`3oool0603oool00`000000oooo0?ooo`2=
0?ooo`H0IVIVo`3ooooo0?oooaD0oooo001F0?ooo`80IVIV1`3oool00`1b01H0nP0a0?X0<@0;0?X0
<@0306IVIP3j0340nP0a00D0nP0a3@3oool207d060030?X0<@1VIVH0nP0a0180nP0a1`3oool00`1V
IVH0oooo0?ooo`030?ooo`0308H06P3j0340nP0a01@0nP0a0`3oool00`1VIVH0oooo0?ooo`0H0?oo
o`030000003oool0oooo09<0oooo1P1VIVKo0?ooool0oooo3`3oool005H0oooo0P1VIVH70?ooo`d0
nP0a00<0IVIV0?X0<@3j03401P3j034=0?ooo`0407d0603j0340nP0a06IVIQ<0nP0a1P3oool00`1V
IVH0oooo0?ooo`040?ooo`0308H06P3j0340nP0a01@0nP0a0P3oool00`1VIVH0oooo0?ooo`0I0?oo
o`030000003oool0oooo09T0oooo1P1VIVKo0?ooool0oooo2@3oool005H0oooo101VIVH40?ooo`03
07805P3j0340nP0a00/0nP0a00<0IVIV0?X0<@3j03401P3j034=0?ooo`0307d0603j0340IVIV01@0
nP0a1P3oool00`1VIVH0oooo0?ooo`040?ooo`0308H06P3j0340nP0a01@0nP0a00<0oooo06IVIP3o
ool06`3oool00`000000oooo0?ooo`2O0?ooo`L0IVIVo`3ooooo0?ooo`80oooo001F0?ooo`0406IV
IP3oool0oooo0?ooo`@0IVIV00<0LP0F0?X0<@3j03402P3j03400`1VIVH0nP0a0?X0<@070?X0<@d0
oooo00<0O@0H0?X0<@1VIVH0503j03450?ooo`0306IVIP3oool0oooo00D0oooo00<0QP0J0?X0<@3j
0340503j03400`3oool0IVIV0?ooo`0K0?ooo`030000003oool0oooo0:H0oooo1P1VIVKo0?oooo/0
oooo001F0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03402P3j03400`1VIVH0nP0a
0?X0<@070?X0<@d0oooo00<0O@0H06IVIP3j0340503j03450?ooo`0306IVIP3oool0oooo00D0oooo
00<0QP0J0?X0<@3j0340503j03400`1VIVH0oooo0?ooo`0K0?ooo`030000003oool0oooo0:`0oooo
1P1VIVKo0?ooooD0oooo001F0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03402@3j
03400`1VIVH0nP0a0?X0<@080?X0<@d0oooo00<0IVIV0?X0<@3j0340503j03440?ooo`0306IVIP3o
ool0oooo00H0oooo00<0QP0J0?X0<@3j0340503j03400`1VIVH0oooo0?ooo`0K0?ooo`030000003o
ool0oooo0;80oooo1P1VIVKo0?ooonl0oooo001F0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F
0?X0<@3j03402@3j03400`1VIVH0nP0a0?X0<@080?X0<@d0oooo00<0IVIV0?X0<@3j0340503j0343
0?ooo`0306IVIP3oool0oooo00L0oooo00<0QP0J0?X0<@3j03404`3j03400`1VIVH0oooo0?ooo`0L
0?ooo`030000003oool0oooo0;P0oooo1P1VIVKo0?ooonT0oooo001F0?ooo`0306IVIP3oool0oooo
00D0oooo00<0LP0F0?X0<@3j0340203j03400`1VIVH0nP0a0?X0<@090?X0<@D0IVIV1`3oool00`1V
IVH0O@0H0?X0<@0E0?X0<@<0oooo00<0IVIV0?ooo`3oool01`3oool00`2601X0nP0a0?X0<@0B0?X0
<@0306IVIP3j0340oooo01d0oooo00<000000?ooo`3oool0_P3oool706IVI_l0oooohP3oool005H0
oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@080?X0<@0306IVIP3j0340nP0a00T0
nP0a1@3oool806IVIP0307d0603j0340nP0a01<0nP0a0`3oool00`1VIVH0oooo0?ooo`080?ooo`03
08H06P3j0340nP0a0180nP0a00<0IVIV0?ooo`3oool07@3oool00`000000oooo0?ooo`350?ooo`H0
IVIVo`3ooooL0?ooo`00EP3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00L0nP0a
00<0IVIV0?X0<@3j03402P3j034;0?ooo`80IVIV00<0O@0H0?X0<@3j03404`3j03430?ooo`0306IV
IP3oool0oooo00P0oooo00<0QP0J0?X0<@3j03404@3j0345000000<0oooo0`0000040?ooo`<00000
3`3oool00`000000oooo0?ooo`3;0?ooo`H0IVIVo`3ooooF0?ooo`00EP3oool00`1VIVH0oooo0?oo
o`050?ooo`0307805P3j0340nP0a00L0nP0a00<0IVIV0?X0<@3j03402P3j034;0?ooo`0306IVIP3o
ool0O@0H01D0nP0a0P3oool00`1VIVH0oooo0?ooo`090?ooo`0308H06P3j0340nP0a0140nP0a00D0
00000?X0<@3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0d@3oool606IVI_l0ooood03oool005D0
oooo00<0IVIV0?ooo`3oool01P3oool00`1b01H0nP0a0?X0<@060?X0<@0306IVIP3j0340nP0a00X0
nP0a2`3oool0101VIVH0oooo0?ooo`1m01PE0?X0<@80oooo00<0IVIV0?ooo`3oool0203oool208H0
6Q80nP0a00<0IVIV0?X0<@0000001@3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo0=L0oooo1`1VIVKo0?ooolT0oooo001E
0?ooo`0306IVIP3oool0oooo00H0oooo00<0LP0F0?X0<@3j03401P3j03400`1VIVH0nP0a0?X0<@0:
0?X0<@/0oooo00@0IVIV0?ooo`3oool0O@0H5@3j034206IVIP/0oooo00<0QP0J0?X0<@3j0340403j
03401@1VIVH0nP0a0?X0<@3j0340000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`3N0?ooo`H0IVIVo`3oooo30?oo
o`00E@3oool00`1VIVH0oooo0?ooo`060?ooo`P0nP0a00<0IVIV0?X0<@3j03402`3j034:0?ooo`03
06IVIP3oool0oooo0080O@0H5@3j03400`1VIVH0oooo06IVIP0606IVIP@0oooo00<0QP0J0?X0<@3j
0340403j03401P1VIVH0nP0a0?X0<@3j0340oooo000000<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`3T0?ooo`H0IVIV
o`3ooonm0?ooo`00E@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00H0nP0a00<0
IVIV0?X0<@3j03402`3j034:0?ooo`0406IVIP3oool0oooo07d061H0nP0a00<0IVIV0?ooo`3oool0
1P3oool406IVIP0308H06P3j0340nP0a00l0nP0a00D0IVIV0?X0<@3j034000000?X0<@020?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0;
0?ooo`@00000jP3oool606IVI_l0oooo]`3oool005D0oooo00<0IVIV0?ooo`3oool01@3oool00`1b
01H0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a00`0nP0a2@3oool01@1VIVH0oooo0?ooo`3oool0
O@0H01D0nP0a00<0IVIV0?ooo`3oool02`3oool00`2601X0nP0a0?X0<@0?0?X0<@0506IVIP3j0340
nP0a0000003j03400P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0300000>d0oooo1`1VIVKo0?oook00
oooo001E0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03401@3j03400`1VIVH0nP0a
0?X0<@0<0?X0<@T0oooo00D0IVIV0?ooo`3oool0oooo07d0600E0?X0<@0306IVIP3oool0oooo00/0
oooo00<0QP0J0?X0<@3j03403P3j03401P1VIVH0nP0a0?X0<@3j034000000?X0<@80oooo00@00000
0?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0n03oool606IVI_l0ooooZP3oool005D0oooo00<0IVIV0?ooo`3oool01@3o
ool00`1b01H0nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0a203oool00`1VIVH0oooo0?oo
o`020?ooo`0307d0603j0340nP0a0180nP0a00<0IVIV0?X0<@3oool0303oool00`2601X0nP0a0?X0
<@0>0?X0<@0306IVIP3j0340nP0a0080nP0a0`0000040?ooo`<00000103oool3000000h0oooo00<0
00000?ooo`3oool0oP3oool606IVI_l0ooooY03oool005D0oooo00<0IVIV0?ooo`3oool01@3oool0
0`1b01H0nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0a1`3oool00`1VIVH0oooo0?ooo`03
0?ooo`0307d0603j0340nP0a0180nP0a00<0IVIV0?X0<@3oool0303oool00`2601X0nP0a0?X0<@0=
0?X0<@0306IVIP3j0340nP0a00@0nP0a1@1VIVHI0?ooo`030000003oool0oooo0?l0oooo1@3oool6
06IVI_l0ooooWP3oool005D0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@030?X0
<@0306IVIP3j0340nP0a00h0nP0a1`3oool00`1VIVH0oooo0?ooo`030?ooo`0307d0603j0340nP0a
0140nP0a00<0IVIV0?X0<@3j03403@3oool00`2601X0nP0a0?X0<@0<0?X0<@0306IVIP3j0340nP0a
00D0nP0a1@3oool706IVIQ80oooo00<000000?ooo`3oool0o`3oool;0?ooo`H0IVIVo`3ooonH0?oo
o`00E@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00<0nP0a00<0IVIV0?X0<@3j
03403P3j03460?ooo`0306IVIP3oool0oooo00@0oooo00<0O@0H0?X0<@3j0340403j0340101VIVH0
nP0a0?X0<@3j034=0?ooo`0308H06P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j03401@3j034<0?oo
o`H0IVIV303oool00`000000oooo0?ooo`3o0?oooa40oooo1`1VIVKo0?oooi40oooo001E0?ooo`03
06IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j03400P3j03400`1VIVH0nP0a0?X0<@0?0?X0<@H0
oooo00<0IVIV0?ooo`3oool0103oool00`1m01P0nP0a0?X0<@0@0?X0<@0406IVIP3j0340nP0a0?X0
<@d0oooo00<0QP0J0?X0<@3j03402`3j03400`1VIVH0nP0a0?X0<@060?X0<A80oooo1`1VIVH50?oo
o`030000003oool0oooo0?l0oooo603oool606IVI_l0ooooR`3oool005D0oooo00<0IVIV0?ooo`3o
ool01@3oool00`1b01H0nP0a0?X0<@020?X0<@0306IVIP3j0340nP0a00l0nP0a1@3oool00`1VIVH0
oooo0?ooo`050?ooo`0307d0603j0340nP0a00l0nP0a00@0IVIV0?X0<@3j0340nP0a3P3oool00`26
01X0nP0a0?X0<@0;0?X0<@0306IVIP3j0340nP0a00H0nP0a6@3oool506IVIP030000003oool0oooo
0?l0oooo7P3oool606IVI_l0ooooQ@3oool005@0oooo00<0IVIV0?ooo`3oool01P3oool01@1b01H0
nP0a0?X0<@3j0340IVIV0140nP0a1P3oool00`1VIVH0oooo0?ooo`050?ooo`0307d0603j0340nP0a
00l0nP0a00@0IVIV0?X0<@3j0340nP0a3P3oool00`2601X0nP0a0?X0<@0:0?X0<@0306IVIP3j0340
nP0a00L0nP0a7P3oool00`000000IVIV06IVIP0406IVI_l0oooo803oool606IVI_l0ooooO`3oool0
05@0oooo00<0IVIV0?ooo`3oool01P3oool01@1b01H0nP0a0?X0<@3j0340IVIV0140nP0a1@3oool0
0`1VIVH0oooo0?ooo`060?ooo`0307d0603j0340nP0a00h0nP0a00<0IVIV0?X0<@3j03400P3j034>
0?ooo`0308H06P3j0340nP0a00T0nP0a00<0IVIV0?X0<@3j0340203j034N0?ooo`030000003oool0
oooo00@0oooo1`1VIVKo0?oooal0oooo1`1VIVKo0?ooogP0oooo001D0?ooo`0306IVIP3oool0oooo
00D0oooo00D0LP0F0?X0<@3j0340nP0a06IVIP0B0?X0<@D0oooo00<0IVIV0?ooo`3oool01P3oool0
0`1m01P0nP0a0?X0<@0>0?X0<@0306IVIP3j0340nP0a0080nP0a3P3oool00`2601X0nP0a0?X0<@09
0?X0<@0306IVIP3j0340nP0a00L0nP0a7`3oool00`000000oooo0?ooo`0;0?ooo`H0IVIVo`3ooolP
0?ooo`H0IVIVo`3ooomb0?ooo`00E03oool00`1VIVH0oooo0?ooo`050?ooo`0407805P3j0340nP0a
06IVIQ<0nP0a103oool00`1VIVH0oooo0?ooo`060?ooo`80O@0H3`3j03400`1VIVH0nP0a0?X0<@03
0?X0<@h0oooo2`3j03400`1VIVH0nP0a0?X0<@080?X0<Al0oooo00<000000?ooo`3oool04@3oool7
06IVI_l0oooo7`3oool606IVI_l0ooooK03oool005@0oooo00<0IVIV0?ooo`3oool01@3oool0101b
01H0nP0a0?X0<@1VIVHC0?X0<@@0oooo00<0IVIV0?ooo`3oool01P3oool00`1m01P0nP0a0?X0<@0=
0?X0<@0306IVIP3j0340nP0a00@0nP0a3@3oool00`2601X0nP0a0?X0<@090?X0<@0306IVIP3j0340
nP0a00P0nP0a7`3oool00`000000oooo0?ooo`0H0?ooo`H0IVIVo`3ooolO0?ooo`H0IVIVo`3ooomV
0?ooo`00E03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340IVIV01@0nP0a0`3oool00`1V
IVH0oooo0?ooo`070?ooo`0307d0603j0340nP0a00d0nP0a00<0IVIV0?X0<@3j0340103j034=0?oo
o`0308H06P3j0340nP0a00P0nP0a00<0IVIV0?X0<@3j03402@3j034O0?ooo`030000003oool0oooo
01h0oooo1`1VIVKo0?oooah0oooo1`1VIVKo0?oooel0oooo001D0?ooo`0306IVIP3oool0oooo00D0
oooo00<0LP0F0?X0<@1VIVH0503j03430?ooo`0306IVIP3oool0oooo00L0oooo00<0O@0H0?X0<@3j
0340303j03400`1VIVH0nP0a0?X0<@050?X0<@d0oooo00<0QP0J0?X0<@3j03401`3j03400`1VIVH0
nP0a0?X0<@0:0?X0<Al0oooo00<000000?ooo`3oool09@3oool606IVI_l0oooo7`3oool606IVI_l0
ooooF@3oool005@0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0IVIV0?X0<@0D0?X0<@80oooo
00<0IVIV0?ooo`3oool0203oool00`1m01P0nP0a0?X0<@0<0?X0<@0306IVIP3j0340nP0a00D0nP0a
3@3oool00`2601X0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a00X0nP0a7`3oool00`000000oooo
0?ooo`0[0?ooo`L0IVIVo`3ooolN0?ooo`H0IVIVo`3ooomC0?ooo`00E03oool00`1VIVH0oooo0?oo
o`050?ooo`0307805P1VIVH0nP0a01@0nP0a00<0oooo06IVIP3oool02P3oool00`1m01P0nP0a0?X0
<@0;0?X0<@0306IVIP3j0340nP0a00H0nP0a3@3oool00`2601X0nP0a0?X0<@060?X0<@0306IVIP3j
0340nP0a00/0nP0a7`3oool00`000000oooo0?ooo`0b0?ooo`H0IVIVo`3ooolN0?ooo`H0IVIVo`3o
oom=0?ooo`00E03oool00`1VIVH0oooo0?ooo`050?ooo`0306IVIP3j0340nP0a01@0nP0a00<0oooo
06IVIP3oool02P3oool00`1m01P0nP0a0?X0<@0;0?X0<@0306IVIP3j0340nP0a00H0nP0a3@3oool0
0`2601X0nP0a0?X0<@060?X0<@0306IVIP3j0340nP0a00/0nP0a7`3oool00`000000oooo0?ooo`0h
0?ooo`L0IVIVo`3ooolM0?ooo`H0IVIVo`3ooom70?ooo`00E03oool00`1VIVH0oooo0?ooo`050?oo
o`0306IVIP3j0340nP0a01@0nP0a00<0IVIV0?ooo`3oool02P3oool00`1m01P0nP0a0?X0<@0:0?X0
<@0306IVIP3j0340nP0a00L0nP0a3@3oool00`2601X0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a
00`0nP0a7`3oool00`000000oooo0?ooo`0o0?ooo`H0IVIVo`3ooolM0?ooo`L0IVIVo`3ooom00?oo
o`00D`3oool00`1VIVH0oooo0?ooo`050?ooo`0306IVIP1b01H0nP0a01D0nP0a00<0IVIV0?ooo`3o
ool02P3oool00`1m01P0nP0a0?X0<@090?X0<@0306IVIP3j0340nP0a00P0nP0a3@3oool00`2601X0
nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0a7P3oool00`000000oooo0?ooo`160?ooo`L0
IVIVo`3ooolM0?ooo`H0IVIVo`3ooolj0?ooo`00D`3oool00`1VIVH0oooo0?ooo`050?ooo`0306IV
IP1b01H0nP0a01@0nP0a00<0IVIV0?ooo`3oool02`3oool00`1m01P0nP0a0?X0<@090?X0<@0306IV
IP3j0340nP0a00P0nP0a3@3oool00`2601X0nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0a
7P3oool00`000000oooo0?ooo`1=0?ooo`H0IVIVo`3ooolM0?ooo`H0IVIVo`3ooold0?ooo`00D`3o
ool00`1VIVH0oooo0?ooo`040?ooo`0306IVIP3oool0LP0F01D0nP0a00<0IVIV0?ooo`3oool02`3o
ool00`1m01P0nP0a0?X0<@080?X0<@0306IVIP3j0340nP0a00P0nP0a3P3oool00`2601X0nP0a0?X0
<@030?X0<@0306IVIP3j0340nP0a00h0nP0a7P3oool00`000000oooo0?ooo`1C0?ooo`H0IVIVo`3o
oolM0?ooo`H0IVIVo`3oool^0?ooo`00D`3oool00`1VIVH0oooo0?ooo`040?ooo`0306IVIP1b01H0
nP0a01@0nP0a00<0IVIV0?ooo`3oool0303oool00`1m01P0nP0a0?X0<@080?X0<@0306IVIP3j0340
nP0a00P0nP0a3P3oool00`2601X0nP0a0?X0<@030?X0<@0306IVIP3j0340nP0a00h0nP0a7P3oool0
0`000000oooo0?ooo`1I0?ooo`L0IVIVo`3ooolL0?ooo`@0IVIVo`3ooolZ0?ooo`00D`3oool00`1V
IVH0oooo0?ooo`030?ooo`0306IVIP3oool0LP0F01D0nP0a00<0IVIV0?ooo`3oool0303oool00`1m
01P0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a00T0nP0a3P3oool00`2601X0nP0a0?X0<@020?X0
<@0306IVIP3j0340nP0a00l0nP0a7P3oool00`000000oooo0?ooo`1P0?ooo`H0IVIVo`3ooooo0?oo
od@0oooo001C0?ooo`0306IVIP3oool0oooo00<0oooo00<0IVIV0?ooo`1b01H0503j03400`1VIVH0
nP0a0?ooo`0=0?ooo`0307d0603j0340nP0a00L0nP0a00<0IVIV0?X0<@3j03402@3j034>0?ooo`05
08H06P3j0340nP0a0?X0<@1VIVH04P3j034N0?ooo`030000003oool0oooo06H0oooo1`1VIVKo0?oo
ool0oooo?@3oool005<0oooo00<0IVIV0?ooo`3oool00P3oool0101VIVH0oooo0?ooo`1b01HD0?X0
<@0306IVIP3j0340oooo00`0oooo00<0O@0H0?X0<@3j03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0
<@h0oooo103j03400`1VIVH0nP0a0?X0<@0@0?X0<Ah0oooo00<000000?ooo`3oool0K@3oool606IV
I_l0ooooo`3ooolg0?ooo`00D`3oool00`1VIVH0oooo0?ooo`020?ooo`0406IVIP3oool0oooo0780
5Q<0nP0a00<0IVIV0?X0<@3j03403@3oool00`1m01P0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a
00X0nP0a3P3oool30?X0<@0306IVIP3j0340nP0a0140nP0a7P3oool00`000000oooo0?ooo`1c0?oo
o`L0IVIVo`3ooooo0?oooc00oooo001C0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH00`3oool00`1b
01H0nP0a0?X0<@0@0?X0<@0406IVIP3j0340nP0a0?X0<@d0oooo00<0O@0H0?X0<@3j03401P3j0340
0`1VIVH0nP0a0?X0<@0;0?X0<@d0oooo00D0QP0J0?X0<@3j0340nP0a06IVIP0B0?X0<Al0oooo00<0
00000?ooo`3oool0NP3oool606IVI_l0ooooo`3ooolZ0?ooo`00D`3oool01@1VIVH0oooo0?ooo`3o
ool0IVIV00<0oooo00<0LP0F0?X0<@3j0340403j0340101VIVH0nP0a0?X0<@3j034=0?ooo`0307d0
603j0340nP0a00D0nP0a00<0IVIV0?X0<@3j0340303j034=0?ooo`0408H06P3j0340nP0a06IVIQ<0
nP0a7`3oool00`000000oooo0?ooo`200?ooo`L0IVIVo`3ooooo0?ooob<0oooo001C0?ooo`0406IV
IP3oool0oooo06IVIP@0oooo00<0LP0F0?X0<@3j03403`3j03400`1VIVH0nP0a0?X0<@020?X0<@d0
oooo00<0O@0H0?X0<@3j03401@3j03400`1VIVH0nP0a0?X0<@0<0?X0<@d0oooo00<0QP0J0?X0<@1V
IVH0503j036Y0?ooo`H0IVIVo`3ooooo0?oooad0oooo001C0?ooo`0406IVIP3oool0oooo06IVIP@0
oooo00<0LP0F0?X0<@3j03403`3j03400`1VIVH0nP0a0?X0<@020?X0<@d0oooo00<0O@0H0?X0<@3j
0340103j03400`1VIVH0nP0a0?X0<@0=0?X0<@d0oooo00<0QP0J0?X0<@1VIVH0503j036_0?ooo`L0
IVIVo`3ooooo0?oooaH0oooo001B0?ooo`0406IVIP3oool0oooo06IVIPD0oooo00<0LP0F0?X0<@3j
03403P3j03400`1VIVH0nP0a0?X0<@030?X0<@d0oooo00<0O@0H0?X0<@3j0340103j03400`1VIVH0
nP0a0?X0<@0=0?X0<@d0oooo00<0QP0J06IVIP3j0340503j036f0?ooo`H0IVIVo`3ooooo0?oooa00
oooo001B0?ooo`0406IVIP3oool0oooo06IVIPD0oooo00<0LP0F0?X0<@3j03403P3j03400`1VIVH0
nP0a0?X0<@030?X0<@d0oooo00<0O@0H0?X0<@3j03400`3j03400`1VIVH0nP0a0?X0<@0>0?X0<@d0
oooo00<0QP0J06IVIP3j0340503j036l0?ooo`L0IVIVo`3ooooo0?ooo`T0oooo001B0?ooo`0306IV
IP3oool0IVIV00D0oooo0P1b01H?0?X0<@0306IVIP3j0340nP0a00<0nP0a3P3oool00`1m01P0nP0a
0?X0<@030?X0<@0306IVIP3j0340nP0a00h0nP0a3@3oool00`1VIVH0nP0a0?X0<@0D0?X0<L<0oooo
1P1VIVKo0?ooool0oooo0`3oool00580oooo00<0IVIV0?ooo`1VIVH01@3oool00`1b01H0nP0a0?X0
<@0>0?X0<@0306IVIP3j0340nP0a00<0nP0a3P3oool00`1m01P0nP0a0?X0<@020?X0<@0306IVIP3j
0340nP0a00l0nP0a303oool00`1VIVH0QP0J0?X0<@0E0?X0<LT0oooo1P1VIVKo0?oooo`0oooo001B
0?ooo`80IVIV1P3oool00`1b01H0nP0a0?X0<@0=0?X0<@0306IVIP3j0340nP0a00@0nP0a3P3oool0
1@1m01P0nP0a0?X0<@3j0340IVIV0180nP0a303oool00`1VIVH0QP0J0?X0<@0E0?X0<Ll0oooo1`1V
IVKo0?ooooD0oooo001B0?ooo`80IVIV1P3oool00`1b01H0nP0a0?X0<@0=0?X0<@0306IVIP3j0340
nP0a00@0nP0a3P3oool01@1m01P0nP0a0?X0<@3j0340IVIV0140nP0a303oool00`1VIVH0oooo08H0
6P0F0?X0<MH0oooo1P1VIVKo0?ooonl0oooo001B0?ooo`@0IVIV103oool00`1b01H0nP0a0?X0<@0<
0?X0<@0306IVIP3j0340nP0a00D0nP0a3P3oool0101m01P0nP0a0?X0<@1VIVHB0?X0<@`0oooo00<0
IVIV0?ooo`2601X05P3j037L0?ooo`L0IVIVo`3ooooX0?ooo`00DP3oool0101VIVH0oooo0?ooo`3o
ool406IVIP0307805P3j0340nP0a00`0nP0a00<0IVIV0?X0<@3j03401@3j034=0?ooo`0507d0603j
0340nP0a0?X0<@1VIVH04P3j034;0?ooo`0406IVIP3oool0oooo08H06QH0nP0ah`3oool606IVI_l0
oooohP3oool00580oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@0;0?X0<@0306IV
IP3j0340nP0a00H0nP0a3@3oool0101m01P0nP0a0?X0<@1VIVHC0?X0<@X0oooo00@0IVIV0?ooo`3o
ool0oooo5`3j037Y0?ooo`L0IVIVo`3ooooK0?ooo`00DP3oool00`1VIVH0oooo0?ooo`050?ooo`03
07805P3j0340nP0a00X0nP0a00<0IVIV0?X0<@3j03401`3j034=0?ooo`0407d0603j0340nP0a06IV
IQ<0nP0a2P3oool0101VIVH0oooo0?ooo`3oool60>X0;Q40nP0al03oool606IVI_l0ooooe@3oool0
0580oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@0:0?X0<@0306IVIP3j0340nP0a
00L0nP0a3@3oool00`1m01P0nP0a06IVIP0D0?X0<@T0oooo00<0IVIV0?ooo`3oool00P3oool;0>X0
;P`0nP0amP3oool706IVI_l0oooocP3oool00540oooo00<0IVIV0?ooo`3oool01P3oool00`1b01H0
nP0a0?X0<@090?X0<@0306IVIP3j0340nP0a00P0nP0a1`1VIVH60?ooo`0307d0601VIVH0nP0a01@0
nP0a2@3oool0101VIVH0oooo0?ooo`3ooolB0>X0;PH0nP0ao@3oool606IVI_l0oooob03oool00540
oooo00<0IVIV0?ooo`3oool01P3oool00`1b01H0nP0a0?X0<@090?X0<@0306IVIP3j0340nP0a00P0
nP0a1`3oool606IVIP0307d0601VIVH0nP0a01@0nP0a203oool00`1VIVH0oooo0?ooo`070?oooa80
jP0^o`3oool50?ooo`L0IVIVo`3oooo10?ooo`00D@3oool00`1VIVH0oooo0?ooo`060?ooo`030780
5P3j0340nP0a00P0nP0a00<0IVIV0?X0<@3j03402@3j034=0?ooo`0306IVIP3j0340nP0a01@0nP0a
203oool00`1VIVH0oooo0?ooo`0<0?ooo``0jP0^o`3oool=0?ooo`H0IVIVo`3ooonk0?ooo`00D@3o
ool00`1VIVH0oooo0?ooo`050?ooo`80LP0F2P3j03400`1VIVH0nP0a0?X0<@080?X0<@h0oooo00<0
IVIV0?X0<@3j0340503j03470?ooo`0306IVIP3oool0oooo0?l0oooo;03oool706IVI_l0oooo]03o
ool00540oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@080?X0<@0306IVIP3j0340
nP0a00T0nP0a3@3oool00`1VIVH0O@0H0?X0<@0E0?X0<@H0oooo00<0IVIV0?ooo`3oool0o`3ooold
0?ooo`H0IVIVo`3ooon^0?ooo`00D@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a
00P0nP0a00<0IVIV0?X0<@3j03402@3j034=0?ooo`0306IVIP1m01P0nP0a01D0nP0a1`1VIVKo0?oo
oc`0oooo1P1VIVKo0?ooojP0oooo001A0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j
03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0<@`0oooo00<0IVIV0?ooo`1m01P05P3j03450?ooo`P0
IVIVo`3oooll0?ooo`L0IVIVo`3ooonQ0?ooo`00D@3oool00`1VIVH0oooo0?ooo`050?ooo`030780
5P3j0340nP0a00L0nP0a00<0IVIV0?X0<@3j03402P3j034;0?ooo`0406IVIP3oool0oooo07d061H0
nP0a1@3oool00`1VIVH0oooo0?ooo`050?ooo`L0IVIVo`3oooll0?ooo`H0IVIVo`3ooonK0?ooo`00
D@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00H0nP0a00<0IVIV0?X0<@3j0340
2`3j034;0?ooo`0406IVIP3oool0oooo07d061D0nP0a1@3oool00`1VIVH0oooo0?ooo`0=0?ooo`H0
IVIVo`3oooll0?ooo`L0IVIVo`3ooonD0?ooo`00D@3oool00`1VIVH0oooo0?ooo`050?ooo`030780
5P3j0340nP0a00D0nP0a00<0IVIV0?X0<@3j0340303j034:0?ooo`0406IVIP3oool0oooo0?oooaH0
nP0a103oool00`1VIVH0oooo0?ooo`0D0?ooo`L0IVIVo`3oooll0?ooo`H0IVIVo`3ooon>0?ooo`00
D@3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00D0nP0a00<0IVIV0?X0<@3j0340
303j034:0?ooo`0406IVIP3oool0oooo07d061H0nP0a103oool00`1VIVH0oooo0?ooo`0K0?ooo`L0
IVIVo`3ooolk0?ooo`L0IVIVo`3ooon70?ooo`00D@3oool00`1VIVH0oooo0?ooo`050?ooo`030780
5P3j0340nP0a00@0nP0a00<0IVIV0?X0<@3j03403@3j03490?ooo`0506IVIP3oool0oooo0?ooo`1m
01P05P3j03430?ooo`0306IVIP3oool0oooo02<0oooo1`1VIVKo0?oooc/0oooo1P1VIVKo0?oooh40
oooo001@0?ooo`0306IVIP3oool0oooo00H0oooo00<0LP0F0?X0<@3j0340103j03400`1VIVH0nP0a
0?X0<@0=0?X0<@T0oooo00D0IVIV0?ooo`3oool0oooo07d0600F0?X0<@<0oooo00<0IVIV0?ooo`3o
ool0:P3oool706IVI_l0oooo>P3oool706IVI_l0ooooNP3oool00500oooo00<0IVIV0?ooo`3oool0
1P3oool00`1b01H0nP0a0?X0<@030?X0<@0306IVIP3j0340nP0a00h0nP0a203oool00`1VIVH0oooo
0?ooo`020?ooo`0307d0603j0340nP0a01@0nP0a0P3oool00`1VIVH0oooo0?ooo`0b0?ooo`L0IVIV
o`3ooolj0?ooo`H0IVIVo`3ooomd0?ooo`00D03oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F1@3j
03400`1VIVH0nP0a0?X0<@0>0?X0<@P0oooo00<0IVIV0?ooo`3oool00P3oool00`1m01P0nP0a0?X0
<@0D0?X0<@030?ooo`1VIVH0oooo03/0oooo1`1VIVKo0?ooocT0oooo1`1VIVKo0?ooofd0oooo001@
0?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H40?X0<@0306IVIP3j0340nP0a00l0nP0a1`3oool0
0`1VIVH0oooo0?ooo`030?ooo`0307d0603j0340nP0a01@0nP0a00<0oooo06IVIP3oool0@P3oool7
06IVI_l0oooo>@3oool606IVI_l0ooooI`3oool00500oooo00<0IVIV0?ooo`3oool01@3oool00`1b
01H0nP0a0?X0<@030?X0<@0306IVIP3j0340nP0a00h0nP0a1`3oool00`1VIVH0oooo0?ooo`040?oo
o`0307d0603j0340nP0a01@0nP0a00<0IVIV0?ooo`3oool0B@3oool606IVI_l0oooo>@3oool706IV
I_l0ooooH03oool00500oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@020?X0<@03
06IVIP3j0340nP0a00l0nP0a1`3oool00`1VIVH0oooo0?ooo`040?ooo`0307d0603j0340nP0a01@0
nP0a00<0IVIV0?ooo`3oool0C`3oool706IVI_l0oooo>@3oool606IVI_l0ooooFP3oool00500oooo
00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@020?X0<@0306IVIP3j0340nP0a00l0nP0a
1P3oool00`1VIVH0oooo0?ooo`050?ooo`0307d0603j0340nP0a01<0nP0a00<0IVIV0?ooo`3oool0
E`3oool706IVI_l0oooo>03oool606IVI_l0ooooE03oool00500oooo00<0IVIV0?ooo`3oool01@3o
ool01@1b01H0nP0a0?X0<@3j0340IVIV0180nP0a1P3oool00`1VIVH0oooo0?ooo`050?ooo`0307d0
603j0340nP0a0180nP0a00<0IVIV0?X0<@3oool0G`3oool706IVI_l0oooo=`3oool706IVI_l0oooo
C@3oool00500oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0<@3j0340IVIV0180nP0a
1@3oool00`1VIVH0oooo0?ooo`060?ooo`0307d0603j0340nP0a0180nP0a00<0IVIV0?X0<@3oool0
IP3oool706IVI_l0oooo=`3oool606IVI_l0ooooA`3oool00500oooo00<0IVIV0?ooo`3oool01@3o
ool0101b01H0nP0a0?X0<@1VIVHC0?X0<@D0oooo00<0IVIV0?ooo`3oool01P3oool00`1m01P0nP0a
0?X0<@0A0?X0<@0306IVIP3j0340nP0a06h0oooo1`1VIVKo0?ooocH0oooo1`1VIVKo0?oood00oooo
001@0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@1VIVH0503j03440?ooo`0306IVIP3o
ool0oooo00L0oooo503j03400`1VIVH0nP0a0?ooo`1e0?ooo`L0IVIVo`3ooolf0?ooo`H0IVIVo`3o
oolj0?ooo`00D03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340IVIV01@0nP0a0`3oool0
0`1VIVH0oooo0?ooo`080?oooa<0nP0a00<0IVIV0?X0<@3j0340O@3oool706IVI_l0oooo=@3oool7
06IVI_l0oooo<`3oool004l0oooo00<0IVIV0?ooo`3oool01P3oool00`1b01H0IVIV0?X0<@0D0?X0
<@<0oooo00<0IVIV0?ooo`3oool01`3oool00`1m01P0nP0a0?X0<@0@0?X0<@0406IVIP3j0340nP0a
0?X0<H@0oooo1`1VIVKo0?ooocD0oooo1P1VIVKo0?ooobd0oooo001?0?ooo`0306IVIP3oool0oooo
00H0oooo00<0LP0F06IVIP3j0340503j03420?ooo`0306IVIP3oool0oooo00P0oooo00<0O@0H0?X0
<@3j0340403j0340101VIVH0nP0a0?X0<@3j036;0?ooo`H0IVIVo`3ooole0?ooo`@0IVIVo`3ooolY
0?ooo`00C`3oool00`1VIVH0oooo0?ooo`050?ooo`0307805P1VIVH0nP0a01D0nP0a0P3oool00`1V
IVH0oooo0?ooo`080?ooo`0307d0603j0340nP0a00l0nP0a00<0IVIV0?X0<@3j03400P3j036A0?oo
o`L0IVIVo`3ooooo0?oooe/0oooo001?0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j
03405@3j03400`3oool0IVIV0?ooo`0:0?ooo`0307d0603j0340nP0a00l0nP0a00<0IVIV0?X0<@3j
03400P3j036H0?ooo`L0IVIVo`3ooooo0?oooe@0oooo001?0?ooo`0306IVIP3oool0oooo00D0oooo
00<0IVIV07805P3j0340503j03420?ooo`0306IVIP3oool0oooo00T0oooo00<0O@0H0?X0<@3j0340
3P3j03400`1VIVH0nP0a0?X0<@030?X0<Il0oooo1`1VIVKo0?ooool0ooooC@3oool004l0oooo00<0
IVIV0?ooo`3oool01@3oool00`1VIVH0nP0a0?X0<@0D0?X0<@030?ooo`1VIVH0oooo00/0oooo00<0
O@0H0?X0<@3j03403@3j03400`1VIVH0nP0a0?X0<@040?X0<JH0oooo1`1VIVKo0?ooool0ooooAP3o
ool004l0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0LP0F0?X0<@0E0?X0<@0306IVIP3oool0
oooo00/0oooo00<0O@0H0?X0<@3j03403@3j03400`1VIVH0nP0a0?X0<@040?X0<Jd0oooo1`1VIVKo
0?ooool0oooo?`3oool004l0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0LP0F0?X0<@0E0?X0
<@0306IVIP3oool0oooo00/0oooo00<0O@0H0?X0<@3j0340303j03400`1VIVH0nP0a0?X0<@050?X0
<K@0oooo1`1VIVKo0?ooool0oooo>03oool004l0oooo00<0IVIV0?ooo`3oool00`3oool00`1VIVH0
oooo07805P0E0?X0<@0306IVIP3oool0oooo00`0oooo00<0O@0H0?X0<@3j0340303j03400`1VIVH0
nP0a0?X0<@050?X0<K/0oooo1`1VIVKo0?ooool0oooo<@3oool004l0oooo00<0IVIV0?ooo`3oool0
0P3oool0101VIVH0oooo0?ooo`1b01HE0?X0<@0306IVIP3oool0oooo00`0oooo00<0O@0H0?X0<@3j
03402`3j03400`1VIVH0nP0a0?X0<@060?X0<L80oooo1P1VIVKo0?ooool0oooo:`3oool004l0oooo
00<0IVIV0?ooo`3oool00P3oool0101VIVH0oooo0?ooo`1b01HD0?X0<@0306IVIP3j0340oooo00d0
oooo00<0O@0H0?X0<@3j03402P3j03400`1VIVH0nP0a0?X0<@070?X0<LP0oooo1`1VIVKo0?ooool0
oooo903oool004h0oooo00<0IVIV0?ooo`3oool00P3oool01@1VIVH0oooo0?ooo`3oool0LP0F01@0
nP0a00<0IVIV0?X0<@3oool03@3oool=0?X0<@0306IVIP3j0340nP0a00L0nP0ac`3oool706IVI_l0
ooooo`3ooolM0?ooo`00CP3oool00`1VIVH0oooo0?ooo`020?ooo`0506IVIP3oool0oooo0?ooo`1b
01H04`3j03400`1VIVH0nP0a0?X0<@0>0?ooo``0nP0a00<0IVIV0?X0<@3j03401`3j037G0?ooo`L0
IVIVo`3ooooo0?oooaH0oooo001>0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH00`3oool207805Q80
nP0a00@0IVIV0?X0<@3j0340nP0a3@3oool00`1m01P0nP0a0?X0<@0:0?X0<@0306IVIP3j0340nP0a
00L0nP0agP3oool706IVI_l0ooooo`3oool?0?ooo`00CP3oool01@1VIVH0oooo0?ooo`3oool0IVIV
00<0oooo0P1b01HB0?X0<@0406IVIP3j0340nP0a0?X0<@d0oooo00<0O@0H0?X0<@3j03402@3j0340
0`1VIVH0nP0a0?X0<@080?X0<ND0oooo1`1VIVKo0?ooool0oooo203oool004h0oooo00@0IVIV0?oo
o`3oool0IVIV103oool207805Q40nP0a00<0IVIV0?X0<@3j03400P3j034=0?ooo`0307d0603j0340
nP0a00P0nP0a00<0IVIV0?X0<@3j03402@3j037/0?ooo`L0IVIVo`3ooooo0?ooo`40oooo001>0?oo
o`0406IVIP3oool0oooo06IVIP@0oooo0P1b01HA0?X0<@0406IVIP3j0340nP0a0?X0<@h0oooo00<0
O@0H0?X0<@3j0340203j03400`1VIVH0nP0a0?X0<@090?X0<O<0oooo1`1VIVKo0?ooooT0oooo001>
0?ooo`0306IVIP3oool0IVIV00D0oooo00<0LP0F0?X0<@3j03403`3j03400`1VIVH0nP0a0?X0<@02
0?X0<@h0oooo00<0O@0H0?X0<@3j03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0<OX0oooo1P1VIVKo
0?oooo<0oooo001>0?ooo`0306IVIP3oool0IVIV00D0oooo00<0LP0F0?X0<@3j03403`3j03400`1V
IVH0nP0a0?X0<@020?X0<@h0oooo00<0O@0H0?X0<@3j03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0
<Ol0oooo0@3oool706IVI_l0ooook03oool004h0oooo0P1VIVH60?ooo`0307805P3j0340nP0a00h0
nP0a00<0IVIV0?X0<@3j03400`3j034>0?ooo`0307d0603j0340nP0a00H0nP0a00<0IVIV0?X0<@3j
03402`3j037o0?ooo`P0oooo1`1VIVKo0?ooonD0oooo001>0?ooo`80IVIV1P3oool00`1b01H0nP0a
0?X0<@0=0?X0<@0306IVIP3j0340nP0a00@0nP0a3P3oool00`1m01P0nP0a0?X0<@060?X0<@0306IV
IP3j0340nP0a00/0nP0ao`3oool?0?ooo`L0IVIVo`3ooooN0?ooo`00CP3oool406IVIP@0oooo00<0
LP0F0?X0<@3j03403@3j03400`1VIVH0nP0a0?X0<@040?X0<@h0oooo00<0O@0H0?X0<@3j03401@3j
03400`1VIVH0nP0a0?X0<@0<0?X0<Ol0oooo5P3oool706IVI_l0ooooe`3oool004h0oooo00@0IVIV
0?ooo`3oool0oooo101VIVH00`1b01H0nP0a0?X0<@0<0?X0<@0306IVIP3j0340nP0a00D0nP0a3P3o
ool00`1m01P0nP0a0?X0<@040?X0<@0306IVIP3j0340nP0a00d0nP0ao`3ooolM0?ooo`L0IVIVo`3o
ooo@0?ooo`00C@3oool00`1VIVH0oooo0?ooo`060?ooo`0307805P3j0340nP0a00`0nP0a00<0IVIV
0?X0<@3j03401@3j034>0?ooo`0307d0603j0340nP0a00@0nP0a00<0IVIV0?X0<@3j03403@3j037o
0?ooob@0oooo1`1VIVKo0?ooolT0oooo001=0?ooo`0306IVIP3oool0oooo00H0oooo00<0LP0F0?X0
<@3j03402`3j03400`1VIVH0nP0a0?X0<@060?X0<@h0oooo1P3j03400`1VIVH0nP0a0?X0<@0>0?X0
<Ol0oooo:`3oool706IVI_l0oooo`P3oool004d0oooo00<0IVIV0?ooo`3oool01@3oool207805Pd0
nP0a00<0IVIV0?X0<@3j03401P3j034206IVIP`0oooo1P3j03400`1VIVH0nP0a0?X0<@0>0?X0<Ol0
oooo<P3oool706IVI_l0oooo^`3oool004d0oooo00<0IVIV0?ooo`3oool01@3oool207805P`0nP0a
00<0IVIV0?X0<@3j03401`3j03420?ooo`L0IVIV1@3oool50?X0<@0306IVIP3j0340nP0a00h0nP0a
o`3ooolj0?ooo`H0IVIVo`3ooone0?ooo`00C@3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F303j
03400`1VIVH0nP0a0?X0<@070?X0<@T0oooo101VIVH00`1m01P0nP0a0?X0<@020?X0<@0306IVIP3j
0340nP0a00l0nP0ao`3ooom00?ooo`L0IVIVo`3ooon^0?ooo`00C@3oool00`1VIVH0oooo0?ooo`05
0?ooo`80LP0F2`3j03400`1VIVH0nP0a0?X0<@080?X0<@d0oooo00<0O@0H0?X0<@3j03400P3j0340
0`1VIVH0nP0a0?X0<@0?0?X0<Ol0ooooA`3oool706IVI_l0ooooY`3oool004d0oooo00<0IVIV0?oo
o`3oool01@3oool00`1b01H0nP0a0?X0<@090?X0<@0306IVIP3j0340nP0a00P0nP0a3P3oool01@1m
01P0nP0a0?X0<@3j0340IVIV0180nP0ao`3ooom>0?ooo`L0IVIVo`3ooonP0?ooo`00C@3oool00`1V
IVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00T0nP0a00<0IVIV0?X0<@3j0340203j034>0?oo
o`0507d0603j0340nP0a0?X0<@1VIVH04P3j03400`1VIVH0oooo0?ooo`3o0?oooe80oooo1`1VIVKo
0?oooiT0oooo001=0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j0340203j03400`1V
IVH0nP0a0?X0<@090?X0<@h0oooo00@0O@0H0?X0<@3j0340IVIV4`3j03400`3oool0IVIV06IVIP06
06IVI_l0ooooD`3oool706IVI_l0ooooTP3oool004d0oooo00<0IVIV0?ooo`3oool01@3oool00`1b
01H0nP0a0?X0<@080?X0<@0306IVIP3j0340nP0a00T0nP0a3P3oool00`1m01P0nP0a06IVIP0D0?X0
<@T0oooo1`1VIVKo0?oooe<0oooo1`1VIVKo0?oooh/0oooo001=0?ooo`0306IVIP3oool0oooo00D0
oooo00<0LP0F0?X0<@3j03401`3j03400`1VIVH0nP0a0?X0<@0:0?X0<@h0oooo00<0O@0H0?X0<@1V
IVH0503j034@0?ooo`L0IVIVo`3ooomC0?ooo`L0IVIVo`3ooon40?ooo`00C03oool00`1VIVH0oooo
0?ooo`060?ooo`0307805P3j0340nP0a00L0nP0a00<0IVIV0?X0<@3j03402P3j034>0?ooo`0307d0
601VIVH0nP0a01@0nP0a5`3oool706IVI_l0ooooD`3oool606IVI_l0ooooOP3oool004`0oooo00<0
IVIV0?ooo`3oool01P3oool00`1b01H0nP0a0?X0<@060?X0<@0306IVIP3j0340nP0a00/0nP0a3P3o
ool00`1m01P0IVIV0?X0<@0D0?X0<Ah0oooo1`1VIVKo0?oooe80oooo1`1VIVKo0?ooogL0oooo001<
0?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H70?X0<@0306IVIP3j0340nP0a00`0nP0a3P3oool0
0`1VIVH0nP0a0?X0<@0D0?X0<BD0oooo1`1VIVKo0?oooe80oooo1`1VIVKo0?ooog00oooo001<0?oo
o`0306IVIP3oool0oooo00D0oooo0P1b01H70?X0<@0306IVIP3j0340nP0a00`0nP0a3@3oool00`1V
IVH0nP0a0?X0<@0E0?X0<B`0oooo1`1VIVKo0?oooe80oooo1`1VIVKo0?ooofT0oooo001<0?ooo`03
06IVIP3oool0oooo00D0oooo0P1b01H60?X0<@0306IVIP3j0340nP0a00d0nP0a3@3oool00`1VIVH0
iP0]0>H0;@060>H0;@l0nP0a<`3oool806IVI_l0ooooD@3oool706IVI_l0ooooHP3oool004`0oooo
00<0IVIV0?ooo`3oool01@3oool207805PH0nP0a00<0IVIV0?X0<@3j03403@3j034<0?ooo`0306IV
IP3oool0iP0]00h0iP0]203j034k0?ooo`L0IVIVo`3ooomA0?ooo`L0IVIVo`3ooomK0?ooo`00C03o
ool00`1VIVH0oooo0?ooo`050?ooo`80LP0F1@3j03400`1VIVH0nP0a0?X0<@0>0?X0<@`0oooo00<0
IVIV0>H0;@3V02d05@3V02e30?ooo`L0IVIVo`3ooomA0?ooo`L0IVIVo`3ooomD0?ooo`00C03oool0
0`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00@0nP0a00<0IVIV0?X0<@3j03403@3j034<
0?ooo`0306IVIP3oool0oooo00X0oooo303V02e:0?ooo`L0IVIVo`3ooomA0?ooo`L0IVIVo`3ooom=
0?ooo`00C03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a00<0nP0a00<0IVIV0?X0
<@3j03403P3j034;0?ooo`0306IVIP3oool0oooo0140oooo1P3V02eA0?ooo`L0IVIVo`3ooomA0?oo
o`L0IVIVo`3ooom60?ooo`00C03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a0080
nP0a00<0IVIV0?X0<@3j03403`3j034;0?ooo`0306IVIP3oool0oooo06l0oooo1`1VIVKo0?oooe40
oooo1P1VIVKo0?oood00oooo001<0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j0340
0P3j03400`1VIVH0nP0a0?X0<@0?0?X0<@X0oooo00<0IVIV0?ooo`3oool0M`3oool706IVI_l0oooo
D03oool706IVI_l0oooo>@3oool004`0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0
<@3j0340IVIV0180nP0a2P3oool00`1VIVH0oooo0?ooo`1n0?ooo`P0IVIVo`3ooom?0?ooo`L0IVIV
o`3ooolb0?ooo`00B`3oool00`1VIVH0oooo0?ooo`060?ooo`0507805P3j0340nP0a0?X0<@1VIVH0
4P3j03490?ooo`0306IVIP3oool0oooo08L0oooo1`1VIVKo0?ooodl0oooo1`1VIVKo0?ooob/0oooo
001;0?ooo`0306IVIP3oool0oooo00H0oooo00@0LP0F0?X0<@3j0340IVIV4`3j03480?ooo`0306IV
IP3oool0oooo08l0oooo1`1VIVKo0?ooodl0oooo101VIVKo0?ooobL0oooo001;0?ooo`0306IVIP3o
ool0oooo00D0oooo0P1b01H20?X0<@0306IVIP3j0340nP0a0140nP0a203oool00`1VIVH0oooo0?oo
o`2F0?ooo`L0IVIVo`3ooooo0?ooog<0oooo001;0?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H0
0`3j0340IVIV0?X0<@0C0?X0<@L0oooo00<0IVIV0?ooo`3oool0WP3oool706IVI_l0ooooo`3ooom/
0?ooo`00B`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F00<0IVIV0?X0<@3j03404`3j03470?oo
o`0306IVIP3oool0oooo0:D0oooo1`1VIVKo0?ooool0ooooI@3oool004/0oooo00<0IVIV0?ooo`3o
ool01@3oool207805P0306IVIP3j0340nP0a01<0nP0a1P3oool00`1VIVH0oooo0?ooo`2]0?ooo`P0
IVIVo`3ooooo0?oooed0oooo001;0?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j0340
5@3j03450?ooo`0306IVIP3oool0oooo0;H0oooo1`1VIVKo0?ooool0ooooEP3oool004/0oooo00<0
IVIV0?ooo`3oool01@3oool00`1b01H0IVIV0?X0<@0D0?X0<@H0oooo00<0IVIV0?ooo`3oool0_@3o
ool706IVI_l0ooooo`3ooom?0?ooo`00B`3oool00`1VIVH0oooo0?ooo`050?ooo`0306IVIP3j0340
nP0a01@0nP0a1@3oool00`1VIVH0oooo0?ooo`350?ooo`L0IVIVo`3ooooo0?ooodP0oooo001;0?oo
o`0306IVIP3oool0oooo00D0oooo00<0IVIV0?X0<@3j0340503j03450?ooo`0306IVIP3oool0oooo
0<`0oooo1`1VIVKo0?ooool0oooo@@3oool004/0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0
LP0F0?X0<@0E0?X0<@@0oooo00<0IVIV0?ooo`3oool0e03oool706IVI_l0ooooo`3ooolj0?ooo`00
B`3oool00`1VIVH0oooo0?ooo`040?ooo`0306IVIP1b01H0nP0a01D0nP0a0`3oool00`1VIVH0oooo
0?ooo`3L0?ooo`L0IVIVo`3ooooo0?oooc<0oooo001:0?ooo`0306IVIP3oool0oooo00@0oooo00<0
IVIV0?ooo`1b01H05P3j03430?ooo`0306IVIP3oool0oooo0><0oooo201VIVKo0?ooool0oooo:`3o
ool004X0oooo00<0IVIV0?ooo`3oool00`3oool0101VIVH0oooo07805P1b01HF0?X0<@80oooo00<0
IVIV0?ooo`3oool0k03oool706IVI_l0ooooo`3ooolT0?ooo`00BP3oool00`1VIVH0oooo0?ooo`03
0?ooo`0406IVIP3oool0LP0F07805QH0nP0a0P3oool00`1VIVH0oooo0?ooo`3c0?ooo`L0IVIVo`3o
oooo0?oooad0oooo001:0?ooo`0306IVIP3oool0oooo0080oooo00<0IVIV0?ooo`3oool00P1b01HF
0?X0<@030?ooo`1VIVH0oooo0?`0oooo1`1VIVKo0?ooool0oooo5P3oool004X0oooo00<0IVIV0?oo
o`3oool00P3oool00`1VIVH0oooo0?ooo`0207805QH0nP0a00<0oooo06IVIP3oool0o`3oool40?oo
o`L0IVIVo`3ooooo0?ooo`l0oooo001:0?ooo`0506IVIP3oool0oooo0?ooo`1VIVH00`3oool20780
5QH0nP0a00<0IVIV0?ooo`3oool0o`3oool;0?ooo`L0IVIVo`3ooooo0?ooo`P0oooo001:0?ooo`05
06IVIP3oool0oooo0?ooo`1VIVH00`3oool207805QD0nP0a00<0IVIV0?ooo`3oool0o`3ooolC0?oo
o`L0IVIVo`3ooooo0?ooo`40oooo001:0?ooo`0406IVIP3oool0oooo06IVIP@0oooo00<0LP0F0?X0
<@3j0340503j03400`1VIVH0oooo0?ooo`3o0?oooaX0oooo201VIVKo0?ooooP0oooo001:0?ooo`03
06IVIP3oool0IVIV00D0oooo00<0LP0F0?X0<@3j03404`3j03400`1VIVH0oooo0?ooo`3o0?ooob<0
oooo1`1VIVKo0?oooo40oooo001:0?ooo`0306IVIP3oool0IVIV00D0oooo00<0LP0F0?X0<@3j0340
4`3j03400`1VIVH0oooo0?ooo`3o0?ooobX0oooo1`1VIVKo0?ooonX0oooo001:0?ooo`80IVIV1P3o
ool00`1b01H0nP0a0?X0<@0B0?X0<@0306IVIP3j0340oooo0?l0oooo<P3oool706IVI_l0ooooh`3o
ool004T0oooo00<0IVIV0?ooo`1VIVH01P3oool00`1b01H0nP0a0?X0<@0A0?X0<@0306IVIP3j0340
nP0a0?l0oooo>P3oool706IVI_l0oooog03oool004T0oooo0P1VIVH70?ooo`0307805P3j0340nP0a
0140nP0a00<0IVIV0?X0<@3j0340o`3ooom10?ooo`L0IVIVo`3ooooE0?ooo`00B@3oool206IVIPH0
oooo0P1b01HB0?X0<@0406IVIP3j0340nP0a0?X0<Ol0ooooB03oool806IVI_l0ooooc@3oool004T0
oooo101VIVH40?ooo`80LP0F4P3j0340101VIVH0nP0a0?X0<@3j037o0?oooe00oooo1`1VIVKo0?oo
olH0oooo00190?ooo`0406IVIP3oool0oooo0?ooo`@0IVIV0P1b01HA0?X0<@0306IVIP3j0340nP0a
0080nP0ao`3ooomG0?ooo`L0IVIVo`3ooono0?ooo`00B@3oool00`1VIVH0oooo0?ooo`050?ooo`80
LP0F403j03400`1VIVH0nP0a0?X0<@030?X0<Ol0ooooGP3oool706IVI_l0oooo^03oool004T0oooo
00<0IVIV0?ooo`3oool01@3oool207805Q00nP0a00<0IVIV0?X0<@3j03400`3j037o0?ooofD0oooo
1`1VIVKo0?oook40oooo00190?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H?0?X0<@0306IVIP3j
0340nP0a00@0nP0a0P1VIVKo0?ooofX0oooo1`1VIVKo0?ooojX0oooo00190?ooo`0306IVIP3oool0
oooo00D0oooo00<0LP0F0?X0<@3j03403P3j03400`1VIVH0nP0a0?X0<@040?X0<@80oooo201VIVKo
0?ooofT0oooo1`1VIVKo0?oooj<0oooo00190?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0
<@3j03403@3j03400`1VIVH0nP0a0?X0<@040?X0<@/0oooo1`1VIVKo0?ooofT0oooo201VIVKo0?oo
oi/0oooo00190?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F0?X0<@3j0340303j03400`1VIVH0
nP0a0?X0<@050?X0<A80oooo201VIVKo0?ooofT0oooo1`1VIVKo0?oooi@0oooo00190?ooo`0306IV
IP3oool0oooo00D0oooo00<0LP0F0?X0<@3j0340303j03400`1VIVH0nP0a0?X0<@050?X0<AX0oooo
201VIVKo0?ooofP0oooo1`1VIVKo0?ooohd0oooo00180?ooo`0306IVIP3oool0oooo00H0oooo00<0
LP0F0?X0<@3j03402`3j03400`1VIVH0nP0a0?X0<@060?X0<B80oooo1`1VIVKo0?ooofP0oooo1`1V
IVKo0?ooohH0oooo00180?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H=0?X0<@0306IVIP3j0340
nP0a00H0nP0a:@3oool806IVI_l0ooooI`3oool706IVI_l0ooooO`3oool004P0oooo00<0IVIV0?oo
o`3oool01@3oool207805P`0nP0a00<0IVIV0?X0<@3j03401`3j034a0?ooo`L0IVIVo`3ooomW0?oo
o`L0IVIVo`3ooomh0?ooo`00B03oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F2`3j03400`1VIVH0
nP0a0?X0<@080?X0<CP0oooo201VIVKo0?ooofH0oooo1`1VIVKo0?ooog40oooo00180?ooo`0306IV
IP3oool0oooo00D0oooo0P1b01H;0?X0<@0306IVIP3j0340nP0a00P0nP0a@03oool706IVI_l0oooo
IP3oool806IVI_l0ooooJ@3oool004P0oooo00<0IVIV0?ooo`3oool01@3oool207805PX0nP0a00<0
IVIV0?X0<@3j03402@3j03570?ooo`P0IVIVo`3ooomV0?ooo`L0IVIVo`3ooomR0?ooo`00B03oool0
0`1VIVH0oooo0?ooo`050?ooo`80LP0F2P3j03400`1VIVH0nP0a0?X0<@090?X0<Dl0oooo1`1VIVKo
0?ooofH0oooo1`1VIVKo0?oooe/0oooo00180?ooo`0306IVIP3oool0oooo00D0oooo0P1b01H90?X0
<@0306IVIP3j0340nP0a00X0nP0aEP3oool806IVI_l0ooooI@3oool706IVI_l0ooooE03oool004P0
oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a00/0
nP0aGP3oool706IVI_l0ooooI@3oool706IVI_l0ooooC@3oool004P0oooo00<0IVIV0?ooo`3oool0
1@3oool00`1b01H0nP0a0?X0<@070?X0<@0306IVIP3j0340nP0a00/0nP0aI@3oool806IVI_l0oooo
I03oool706IVI_l0ooooAP3oool004P0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0
<@060?X0<@0306IVIP3j0340nP0a00/0nP0aKP3oool706IVI_l0ooooI03oool706IVI_l0oooo?`3o
ool004L0oooo00<0IVIV0?ooo`3oool01P3oool00`1b01H0nP0a0?X0<@060?X0<@0306IVIP3j0340
nP0a00/0nP0aM@3oool806IVI_l0ooooH`3oool806IVI_l0oooo=`3oool004L0oooo00<0IVIV0?oo
o`3oool01P3oool00`1b01H0nP0a0?X0<@050?X0<@0306IVIP3j0340nP0a00`0nP0aO@3oool806IV
I_l0ooooH`3oool706IVI_l0oooo<03oool004L0oooo00<0IVIV0?ooo`3oool01@3oool207805PH0
nP0a00<0IVIV0?X0<@3j03403@3j03650?ooo`L0IVIVo`3ooomS0?ooo`L0IVIVo`3ooolY0?ooo`00
A`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F1P3j03400`1VIVH0nP0a0?X0<@0=0?X0<H`0oooo
201VIVKo0?ooof80oooo101VIVKo0?ooobD0oooo00170?ooo`0306IVIP3oool0oooo00D0oooo0P1b
01H50?X0<@0306IVIP3j0340nP0a00h0nP0aU03oool706IVI_l0ooooo`3ooon40?ooo`00A`3oool0
0`1VIVH0oooo0?ooo`050?ooo`80LP0F1@3j03400`1VIVH0nP0a0?X0<@0>0?X0<I/0oooo201VIVKo
0?ooool0ooooO03oool004L0oooo00<0IVIV0?ooo`3oool01@3oool207805P@0nP0a00<0IVIV0?X0
<@3j03403`3j036S0?ooo`L0IVIVo`3ooooo0?ooogD0oooo00170?ooo`0306IVIP3oool0oooo00D0
oooo0P1b01H30?X0<@0306IVIP3j0340nP0a0100nP0aZP3oool806IVI_l0ooooo`3ooom]0?ooo`00
A`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F0`3j03400`1VIVH0nP0a0?X0<@0@0?X0<K80oooo
1`1VIVKo0?ooool0ooooIP3oool004L0oooo00<0IVIV0?ooo`3oool01@3oool01@1b01H0nP0a0?X0
<@3j0340IVIV01<0nP0a^@3oool806IVI_l0ooooo`3ooomN0?ooo`00A`3oool00`1VIVH0oooo0?oo
o`050?ooo`0507805P3j0340nP0a0?X0<@1VIVH04`3j03710?ooo`L0IVIVo`3ooooo0?oooeL0oooo
00170?ooo`0306IVIP3oool0oooo00D0oooo00@0LP0F0?X0<@3j0340IVIV4`3j03790?ooo`P0IVIV
o`3ooooo0?ooodl0oooo00160?ooo`0306IVIP3oool0oooo00H0oooo00@0LP0F0?X0<@3j0340IVIV
4`3j037A0?ooo`L0IVIVo`3ooooo0?ooodP0oooo00160?ooo`0306IVIP3oool0oooo00D0oooo0P1b
01H00`3j0340IVIV0?X0<@0C0?X0<MP0oooo201VIVKo0?ooool0oooo@03oool004H0oooo00<0IVIV
0?ooo`3oool01@3oool207805P0306IVIP3j0340nP0a01<0nP0ah03oool706IVI_l0ooooo`3oooli
0?ooo`00AP3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F00<0IVIV0?X0<@3j03404`3j037W0?oo
o`P0IVIVo`3ooooo0?oooc40oooo00160?ooo`0306IVIP3oool0oooo00D0oooo00<0LP0F06IVIP3j
03405@3j037_0?ooo`P0IVIVo`3ooooo0?ooobT0oooo00160?ooo`0306IVIP3oool0oooo00D0oooo
00<0LP0F06IVIP3j03405@3j037g0?ooo`L0IVIVo`3ooooo0?ooob80oooo00160?ooo`0306IVIP3o
ool0oooo00D0oooo00<0IVIV07805P3j03405@3j037n0?ooo`P0IVIVo`3ooooo0?oooaX0oooo0016
0?ooo`0306IVIP3oool0oooo00@0oooo00<0IVIV07805P1b01H05P3j037o0?ooo`L0oooo1`1VIVKo
0?ooool0oooo4`3oool004H0oooo00<0IVIV0?ooo`3oool0103oool00`1VIVH0LP0F07805P0F0?X0
<Ol0oooo3P3oool806IVI_l0ooooo`3oool;0?ooo`00AP3oool00`1VIVH0oooo0?ooo`030?ooo`03
06IVIP3oool0LP0F01L0nP0ao`3ooolF0?ooo`L0IVIVo`3ooooo0?ooo`@0oooo00160?ooo`0306IV
IP3oool0oooo00<0oooo00<0IVIV0?ooo`1b01H05`3j037o0?oooad0oooo201VIVKo0?oooo/0oooo
00160?ooo`0306IVIP3oool0oooo0080oooo00@0IVIV0?ooo`3oool0LP0F5P3j037o0?ooobH0oooo
1`1VIVKo0?oooo@0oooo00150?ooo`0306IVIP3oool0oooo0080oooo00D0IVIV0?ooo`3oool0oooo
07805P0F0?X0<Ol0oooo;@3oool806IVI_l0ooook03oool004D0oooo00<0IVIV0?ooo`3oool00P3o
ool00`1VIVH0oooo0?ooo`0207805QH0nP0ao`3ooole0?ooo`L0IVIVo`3ooooU0?ooo`00A@3oool0
1@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo0P1b01HF0?X0<Ol0oooo?03oool806IVI_l0oooog@3o
ool004D0oooo00D0IVIV0?ooo`3oool0oooo06IVIP030?ooo`80LP0F5P3j037o0?oood@0oooo1`1V
IVKo0?ooomH0oooo00150?ooo`0406IVIP3oool0oooo06IVIP@0oooo0P1b01HF0?X0<Ol0ooooB`3o
ool806IVI_l0oooocP3oool004D0oooo00<0IVIV0?ooo`1VIVH01@3oool207805QH0nP0ao`3ooomC
0?ooo`L0IVIVo`3oooo70?ooo`00A@3oool00`1VIVH0oooo06IVIP050?ooo`80LP0F5P3j037o0?oo
oeX0oooo201VIVKo0?oookl0oooo00150?ooo`80IVIV1P3oool207805QH0nP0ao`3ooomR0?ooo`P0
IVIVo`3ooong0?ooo`00A@3oool206IVIPH0oooo0P1b01HF0?X0<Ol0ooooJP3oool706IVI_l0oooo
/03oool004D0oooo101VIVH40?ooo`0307805P3j0340nP0a01D0nP0ao`3oooma0?ooo`P0IVIVo`3o
oonX0?ooo`00A@3oool0101VIVH0oooo0?ooo`3oool406IVIP0307805P3j0340nP0a01D0nP0ao`3o
oomi0?ooo`L0IVIVo`3ooonQ0?ooo`00A03oool00`1VIVH0oooo0?ooo`060?ooo`0307805P3j0340
nP0a01D0nP0ao`3ooon00?ooo`P0IVIVo`3ooonI0?ooo`00A03oool00`1VIVH0oooo0?ooo`050?oo
o`80LP0F5P3j037o0?ooohT0oooo1`1VIVKo0?oooi80oooo00140?ooo`0306IVIP3oool0oooo00D0
oooo0P1b01HF0?X0<@D0IVIVo`3ooon;0?ooo`P0IVIVo`3ooon:0?ooo`00A03oool00`1VIVH0oooo
0?ooo`050?ooo`80LP0F5P3j03450?ooo`P0IVIVo`3ooon;0?ooo`L0IVIVo`3ooon30?ooo`00A03o
ool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j034=0?ooo`P0IVIVo`3ooon:0?ooo`P0IVIVo`3o
oomk0?ooo`00A03oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j034E0?ooo`P0IVIVo`3ooon:
0?ooo`L0IVIVo`3ooomd0?ooo`00A03oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j034M0?oo
o`P0IVIVo`3ooon90?ooo`P0IVIVo`3ooom/0?ooo`00A03oool00`1VIVH0oooo0?ooo`050?ooo`80
LP0F5P3j034U0?ooo`P0IVIVo`3ooon90?ooo`L0IVIVo`3ooomU0?ooo`00A03oool00`1VIVH0oooo
0?ooo`050?ooo`80LP0F5P3j034]0?ooo`P0IVIVo`3ooon80?ooo`P0IVIVo`3ooomM0?ooo`00A03o
ool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j034e0?ooo`P0IVIVo`3ooon80?ooo`P0IVIVo`3o
oomE0?ooo`00A03oool00`1VIVH0oooo0?ooo`050?ooo`0307805P3j0340nP0a01D0nP0a?@3oool8
06IVI_l0ooooR03oool706IVI_l0ooooCP3oool004@0oooo00<0IVIV0?ooo`3oool01@3oool00`1b
01H0nP0a0?X0<@0E0?X0<DD0oooo201VIVKo0?ooohL0oooo201VIVKo0?ooodH0oooo00130?ooo`03
06IVIP3oool0oooo00H0oooo00<0LP0F0?X0<@3j03405@3j035=0?ooo`P0IVIVo`3ooon70?ooo`L0
IVIVo`3ooolo0?ooo`00@`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j035F0?ooo`P0IVIV
o`3ooon60?ooo`P0IVIVo`3ooolg0?ooo`00@`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j
035N0?ooo`P0IVIVo`3ooon60?ooo`L0IVIVo`3oool`0?ooo`00@`3oool00`1VIVH0oooo0?ooo`05
0?ooo`80LP0F5P3j035V0?ooo`P0IVIVo`3ooon50?ooo`P0IVIVo`3ooolX0?ooo`00@`3oool00`1V
IVH0oooo0?ooo`050?ooo`80LP0F5P3j035^0?ooo`P0IVIVo`3ooon50?ooo`@0IVIVo`3ooolT0?oo
o`00@`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j035f0?ooo`P0IVIVo`3ooooo0?ooojD0
oooo00130?ooo`0306IVIP3oool0oooo00D0oooo0P1b01HF0?X0<Gh0oooo201VIVKo0?ooool0oooo
W@3oool004<0oooo00<0IVIV0?ooo`3oool01@3oool207805QH0nP0aQP3oool806IVI_l0ooooo`3o
oonE0?ooo`00@`3oool00`1VIVH0oooo0?ooo`050?ooo`80LP0F5P3j036>0?ooo`P0IVIVo`3ooooo
0?ooohd0oooo00130?ooo`0306IVIP3oool0oooo00D0oooo0P1b01HF0?X0<IH0oooo1`1VIVKo0?oo
ool0ooooQP3oool004<0oooo00<0IVIV0?ooo`3oool01@3oool00`1b01H0nP0a0?X0<@0E0?X0<Id0
oooo201VIVKo0?ooool0ooooOP3oool00480oooo00<0IVIV0?ooo`3oool01P3oool90=h0;0l0nP0a
Y@3oool806IVI_l0ooooo`3ooomf0?ooo`00@P3oool00`1VIVH0oooo0?ooo`050?oooa40gP0/203j
036]0?ooo`P0IVIVo`3ooooo0?ooofh0oooo00120?ooo`0306IVIP3oool0oooo00/0oooo4P3N02bf
0?ooo`P0IVIVo`3ooooo0?ooofH0oooo00120?ooo`0306IVIP3oool0oooo0140oooo303N02bn0?oo
o`P0IVIVo`3ooooo0?oooeh0oooo00120?ooo`0306IVIP3oool0oooo0><0oooo201VIVKo0?ooool0
ooooEP3oool00480oooo00<0IVIV0?ooo`3oool0j`3oool806IVI_l0ooooo`3ooom>0?ooo`00@P3o
ool00`1VIVH0oooo0?ooo`3c0?ooo`P0IVIVo`3ooooo0?ooodH0oooo00120?ooo`0306IVIP3oool0
oooo0?/0oooo201VIVKo0?ooool0oooo?P3oool00480oooo00<0IVIV0?ooo`3oool0o`3oool40?oo
o`P0IVIVo`3ooooo0?ooocH0oooo00120?ooo`0306IVIP3oool0oooo0?l0oooo303oool806IVI_l0
ooooo`3oool^0?ooo`00@P3oool00`1VIVH0oooo0?ooo`3o0?oooa@0oooo201VIVKo0?ooool0oooo
9P3oool00480oooo00<0IVIV0?ooo`3oool0o`3ooolL0?ooo`P0IVIVo`3ooooo0?oooah0oooo0011
0?ooo`0306IVIP3oool0oooo0?l0oooo9@3oool806IVI_l0ooooo`3ooolF0?ooo`00@@3oool00`1V
IVH0oooo0?ooo`3o0?ooobd0oooo201VIVKo0?ooool0oooo3P3oool00440oooo00<0IVIV0?ooo`3o
ool0o`3ooole0?ooo`P0IVIVo`3ooooo0?ooo`H0oooo00110?ooo`0306IVIP3oool0oooo0?l0oooo
?@3oool806IVI_l0ooooo@3oool00440oooo00<0IVIV0?ooo`3oool0o`3ooom50?ooo`P0IVIVo`3o
oooe0?ooo`00@@3oool00`1VIVH0oooo0?ooo`3o0?ooodd0oooo201VIVKo0?ooond0oooo00110?oo
o`0306IVIP3oool0oooo0?l0ooooE@3oool806IVI_l0ooooi@3oool00440oooo00<0IVIV0?ooo`3o
ool0o`3ooomM0?ooo`P0IVIVo`3ooooM0?ooo`00@@3oool00`1VIVH0oooo0?ooo`3o0?ooofD0oooo
1`1VIVKo0?ooomH0oooo00110?ooo`0306IVIP3oool0oooo0?l0ooooK03oool806IVI_l0oooocP3o
ool00440oooo00<0IVIV0?ooo`3oool0o`3ooomd0?ooo`P0IVIVo`3oooo60?ooo`00@@3oool00`1V
IVH0oooo0?ooo`3o0?ooog`0oooo201VIVKo0?oookh0oooo00100?ooo`0306IVIP3oool0oooo0?l0
ooooQ@3oool806IVI_l0oooo]P3oool00400oooo00<0IVIV0?ooo`3oool0o`3ooon=0?ooo`P0IVIV
o`3ooon^0?ooo`00@03oool00`1VIVH0oooo0?ooo`3o0?oooiD0oooo201VIVKo0?ooojH0oooo0010
0?ooo`0306IVIP3oool0oooo0?l0ooooW@3oool806IVI_l0ooooWP3oool00400oooo00<0IVIV0?oo
o`3oool0o`3ooonU0?ooo`P0IVIVo`3ooonF0?ooo`00@03oool00`1VIVH0oooo0?ooo`3o0?ooojd0
oooo201VIVKo0?ooohh0oooo00100?ooo`0306IVIP3oool0oooo0?l0oooo]@3oool806IVI_l0oooo
QP3oool00400oooo00<0IVIV0?ooo`3oool0o`3ooonm0?ooo`P0IVIVo`3ooomn0?ooo`00@03oool0
0`1VIVH0oooo0?ooo`3o0?ooolD0oooo201VIVKo0?ooogH0oooo00100?ooo`0306IVIP3oool0oooo
0?l0ooooc@3oool806IVI_l0ooooKP3oool00400oooo00<0IVIV0?ooo`3oool0o`3ooooE0?ooo`P0
IVIVo`3ooomV0?ooo`00?`3oool00`1VIVH0oooo0?ooo`3o0?ooomh0oooo201VIVKo0?oooeh0oooo
000o0?ooo`0306IVIP3oool0oooo0?l0ooooiP3oool806IVI_l0ooooEP3oool003l0oooo00<0IVIV
0?ooo`3oool0o`3oooo^0?ooo`P0IVIVo`3ooom>0?ooo`00?`3oool00`1VIVH0oooo0?ooo`3o0?oo
ooH0oooo201VIVKo0?ooodH0oooo000o0?ooo`0306IVIP3oool0oooo0?l0oooooP3oool806IVI_l0
oooo?P3oool003l0oooo00<0IVIV0?ooo`3oool0o`3ooooo0?ooo`L0oooo201VIVKo0?ooocH0oooo
000o0?ooo`0306IVIP3oool0oooo0?l0ooooo`3oool?0?ooo`P0IVIVo`3oool^0?ooo`00?`3oool0
0`1VIVH0oooo0?ooo`3o0?ooool0oooo5`3oool806IVI_l0oooo9P3oool003l0oooo00<0IVIV0?oo
o`3oool0o`3ooooo0?oooal0oooo101VIVKo0?ooob80oooo000o0?ooo`0306IVIP3oool0oooo0?l0
ooooo`3ooooo0?ooodD0oooo000o0?ooo`0306IVIP3oool0oooo0?l0ooooo`3ooooo0?ooodD0oooo
000o0?ooo`0306IVIP3oool0oooo0?l0ooooo`3ooooo0?ooodD0oooo000n0?ooo`0306IVIP3oool0
oooo0?l0ooooo`3ooooo0?ooodH0oooo000n0?ooo`0306IVIP3oool0oooo0?l0ooooo`3ooooo0?oo
odH0oooo000n0?ooo`0306IVIP3oool0oooo0?l0ooooo`3ooooo0?ooodH0oooo000n0?ooo`0306IV
IP3oool0oooo0?l0ooooo`3ooooo0?ooodH0oooo000n0?ooo`0306IVIP3oool0oooo0?l0ooooo`3o
oooo0?ooodH0oooo000n0?ooo`0306IVIP3oool0oooo0?l0ooooo`3ooooo0?ooodH0oooo003o0?oo
ool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo
003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?oo
ohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3o
oooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0
ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3o
ool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0
ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo
0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00
o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon7
0?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0oooo
o`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?oo
ool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo
003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?oo
ohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3o
oooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0
ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3o
ool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0
ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo
0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00
o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon7
0?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0oooo
o`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?oo
ool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo
003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?oo
ohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0ooooo`3o
oooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3oool00?l0
ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0ooooQ`3o
ool00?l0oooo[03oool3000004H0oooo0P00003o0?ooohl0oooo003o0?ooojd0oooo0P0000160?oo
o`800000o`3ooon?0?ooo`00o`3ooon^0?ooo`800000A@3oool200000?l0ooooS`3oool00?l0oooo
C@3oool200000080oooo0P0000030?ooo`8000000P3oool2000000<0oooo0`000000103oool00000
0000003oool2000000<0oooo0P0000030?ooo`8000001@3oool200000080oooo0P0000020?ooo`80
0000103oool3000000@0oooo0P0000050?ooo`8000000`3oool3000000040?ooo`00000000000?oo
o`8000000P3oool2000000<0oooo0P0000040?ooo`8000004`3oool6000000H0oooo100000040?oo
o`<0000000<0oooo0000000000000P3oool200000080oooo0P0000030?ooo`8000000`3oool40000
00@0oooo1@0000050?ooo`@000000`3oool2000000T0oooo0P0000090?ooo`<000001@3oool30000
00D0oooo0`0000070?ooo`8000000P3oool2000000@0oooo0P0000050?ooo`@000001P3oool20000
00030?ooo`000000000000@0oooo0P0000020?ooo`8000001@3oool200000080oooo0P0000030?oo
o`8000000`3oool400000?l0oooo3`3oool00?l0ooooC@3oool200000080oooo0P0000030?ooo`80
00000P3oool200000080oooo1P0000020?ooo`8000000`3oool200000080oooo0P0000000`3oool0
00000?ooo`030?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000@0oooo0P0000000`3oool000000?ooo`0600000080oooo0P0000020?ooo`80
00000P3oool2000000030?ooo`000000oooo0080oooo0P00000C0?ooo`8000000`3oool3000000<0
oooo0`0000000`3oool00000000000020?ooo`H000000P3oool2000000030?ooo`000000oooo0080
00000`3oool200000080oooo0`0000000`3oool00000000000030?ooo`<0000000<0oooo00000000
00000`3oool3000000030?ooo`00000000000080oooo0P0000090?ooo`800000203oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00001P3oool200000080oooo0P0000040?ooo`800000103oool3000000030?ooo`000000000000D0
oooo0`0000000`3oool00000000000030?ooo`8000000P3oool2000000@0oooo0P0000000`3oool0
00000?ooo`02000000<0oooo0P0000020?ooo`<0000000<0oooo000000000000o`3oool>0?ooo`00
o`3ooom=0?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000000`3oool200000080oooo0P0000060?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000000`3oool200000080oooo0P0000040?ooo`8000000`3oool200000080oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`@000004P3oool2000000@0oooo
0P0000030?ooo`8000001P3oool200000080oooo0P0000020?ooo`8000000`3oool2000000<0oooo
0P0000060?ooo`8000000`3oool2000000<0oooo0P0000020?ooo`8000001P3oool2000000T0oooo
0P0000070?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000
000000030?ooo`8000001@3oool200000080oooo0P0000030?ooo`@000000`3oool2000000T0oooo
0P0000030?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000000`3oool2000000<0oooo
0P0000060?ooo`800000o`3oool>0?ooo`00o`3ooom=0?ooo`8000000P3oool2000000<0oooo0P00
00020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool200000080oooo0P00
00060?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool200000080oooo0P00
00040?ooo`8000000`3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00040?ooo`040000003oool0oooo000000D0oooo200000050?ooo`8000001@3oool200000080oooo
0P0000060?ooo`8000000P3oool200000080oooo0P0000030?ooo`8000000`3oool2000000D0oooo
0`0000030?ooo`8000000`3oool200000080oooo0P0000060?ooo`8000002@3oool2000000L0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo
0P0000050?ooo`8000000P3oool2000000<0oooo00@000000?ooo`3oool000000`3oool2000000T0
oooo0P0000030?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000000`3oool2000000<0
oooo0P0000050?ooo`<00000o`3oool>0?ooo`00o`3ooom=0?ooo`8000000P3oool2000000<0oooo
0P0000020?ooo`8000000`3oool500000080oooo0P0000030?ooo`8000000P3oool2000000H0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`8000000P3oool2000000@0oooo
0P0000040?ooo`D000000P3oool200000080oooo0P0000020?ooo`8000000`3oool200000080oooo
0P00000A0?ooo`8000001@3oool200000080oooo1P0000030?ooo`D000000P3oool2000000<0oooo
0P0000030?ooo`8000000`3oool4000000@0oooo0P0000030?ooo`8000000P3oool600000080oooo
0P0000090?ooo`8000001`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000`3oool2000000D0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000020?ooo`H000001@3oool2000000<0oooo0P0000020?ooo`8000000P3oool2000000@0oooo
0P0000030?ooo`8000000`3oool2000000<0oooo1000003o0?ooo`l0oooo003o0?ooodd0oooo0P00
00020?ooo`8000000`3oool200000080oooo0P0000060?ooo`8000000P3oool2000000<0oooo0P00
00020?ooo`8000001P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00020?ooo`800000103oool2000000L0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00030?ooo`8000000P3oool200000140oooo0P0000050?ooo`8000000P3oool200000080oooo0P00
00060?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`8000000P3oool2000000L0oooo0P00
00030?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000002@3oool2000000L0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00
00050?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00050?ooo`8000000`3oool200000080oooo0P0000020?ooo`800000103oool2000000<0oooo0P00
00030?ooo`8000000P3oool200000?l0oooo4P3oool00?l0ooooC@3oool200000080oooo0`000000
103oool000000000000000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`<0000000@0
oooo00000000000000000P3oool2000000H0oooo0`0000001@3oool00000000000000000oooo0080
00000`3oool2000000030?ooo`000000000000<0oooo1@0000000`3oool00000000000030?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`80
0000403oool2000000D0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
00000P3oool2000000<0oooo0`000000103oool000000000000000020?ooo`<0000000<0oooo0000
000000000`3oool3000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool50000
00H0oooo0P0000070?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000001@3oool200000080oooo0P0000000`3oool00000000000040?oo
o`80000000<0oooo0000000000000P3oool2000000D0oooo0`0000000`3oool00000000000030?oo
o`8000000P3oool5000000030?ooo`000000000000<0oooo0`000000103oool00000000000000002
0?ooo`<0000000<0oooo000000000000o`3oool>0?ooo`00o`3ooom=0?ooo`8000000P3oool20000
00040?ooo`000000000000000080oooo100000020?ooo`@000000`3oool2000000040?ooo`000000
000000000080oooo1@0000040?ooo`80000000@0oooo000000000000oooo0`0000050?ooo`<00000
103oool2000000030?ooo`000000000000D000000P3oool4000000<0oooo0P0000020?ooo`800000
00<0oooo0000000000001@0000040?ooo`800000403oool2000000D0oooo0P0000030?ooo`@00000
103oool400000080oooo1@000000103oool000000000003oool3000000@0oooo100000040?ooo`80
000000<0oooo0000000000001@3oool4000000<0oooo0P0000000`3oool00000000000060?ooo`80
00001`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000D0oooo0P0000020?ooo`80000000<0oooo000000000000103oool200000080
oooo100000060?ooo`D00000103oool200000080oooo0P0000000`3oool000000000000500000004
0?ooo`00000000000?ooo`<00000103oool400000?l0oooo3`3oool00?l0ooooC@3oool2000000/0
oooo0P00000C0?ooo`8000008@3oool2000000/0oooo0P0000060?ooo`8000006P3oool2000000@0
oooo0P00000C0?ooo`8000000`3oool2000002X0oooo100000080?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000060?ooo`80
00006@3oool200000140oooo0P0000030?ooo`800000o`3ooolK0?ooo`00o`3ooom=0?ooo`800000
2`3oool2000001<0oooo0P00000Q0?ooo`8000002`3oool200000080oooo0P0000020?ooo`800000
6P3oool2000000<0oooo0`00000C0?ooo`8000000`3oool2000002`0oooo0P0000090?ooo`<00000
1@3oool3000000D0oooo0`0000070?ooo`8000000P3oool2000001D0oooo0P0000070?ooo`800000
203oool2000000<0oooo0P00003o0?oooa/0oooo003o0?ooodd0oooo0P00000<0?ooo`<00000@@3o
ool200000080oooo0P00000N0?ooo`H000006P3oool200000540oooo0P0000020?ooo`8000005@3o
ool2000000L0oooo0P00000=0?ooo`800000o`3ooolK0?ooo`00o`3ooooo0?ooool0ooooQ`3oool0
0?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?ooool0oooo
Q`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3ooooo0?oo
ool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?ooo`00o`3o
oooo0?ooool0ooooQ`3oool00?l0ooooo`3ooooo0?ooohL0oooo003o0?ooool0ooooo`3ooon70?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 899}, {975.625, 0}} -> {0.0473264, -0.0309881, \
0.00100945, 0.00100945}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[XLSBar3D, SortXLS]\)], "Input",
  CellLabel->"In[123]:="],

Cell[BoxData[
    \({SortXLS \[Rule] Mean}\)], "Output",
  CellLabel->"Out[123]="]
}, Open  ]],

Cell[TextData[{
  "By default ",
  StyleBox["XLSBar3D", "DisplayMath"],
  " sorts its rows according the the numerical mean. This can be switched off \
by ",
  StyleBox["SortXLS", "DisplayMath"],
  " -> ",
  StyleBox["False", "DisplayMath"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(XLSBar3D[Take[r, 16], SortXLS \[Rule] False]\)], "Input",
  CellLabel->"In[124]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0852 
%%ImageSize: 900 976.677 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12  scalefont  setfont
% Scaling calculations
-0.131077 1.1846 -1.54499e-17 1.1846 [
[.5 1.0977 -151.125 0 ]
[.5 1.0977 151.125 15.0625 ]
[.24964 -0.00888 -15.5743 -11.375 ]
[.24964 -0.00888 17.1757 0 ]
[.29861 .00282 -15.7612 -11.375 ]
[.29861 .00282 16.9888 0 ]
[.34699 .01439 -15.945 -11.375 ]
[.34699 .01439 16.805 0 ]
[.39481 .02582 -16.1257 -11.375 ]
[.39481 .02582 16.6243 0 ]
[.44208 .03713 -16.3033 -11.375 ]
[.44208 .03713 16.4467 0 ]
[.4888 .0483 -16.478 -11.375 ]
[.4888 .0483 16.272 0 ]
[.53499 .05935 -16.6498 -11.375 ]
[.53499 .05935 16.1002 0 ]
[.58065 .07028 -16.8188 -11.375 ]
[.58065 .07028 15.9312 0 ]
[.62579 .08108 -16.9851 -11.375 ]
[.62579 .08108 15.7649 0 ]
[.67043 .09176 -17.1487 -11.375 ]
[.67043 .09176 15.6013 0 ]
[.71456 .10232 -17.3097 -11.375 ]
[.71456 .10232 15.4403 0 ]
[.7582 .11277 -17.4682 -11.375 ]
[.7582 .11277 15.2818 0 ]
[.80136 .1231 -17.6241 -11.375 ]
[.80136 .1231 15.1259 0 ]
[.84404 .13332 -17.7777 -11.375 ]
[.84404 .13332 14.9723 0 ]
[.88626 .14342 -17.9289 -11.375 ]
[.88626 .14342 14.8211 0 ]
[.20368 .01069 -75.875 -7.26449 ]
[.20368 .01069 0 4.48551 ]
[.18686 .04996 -61.5 -7.23415 ]
[.18686 .04996 0 4.51585 ]
[.1707 .08769 -61.5 -7.2051 ]
[.1707 .08769 0 4.5449 ]
[.15516 .12399 -54.3125 -6.94821 ]
[.15516 .12399 0 4.42679 ]
[.14019 .15892 -111.812 -7.15059 ]
[.14019 .15892 0 4.59941 ]
[.12578 .19257 -61.5 -6.89758 ]
[.12578 .19257 0 4.47742 ]
[.11189 .22501 -61.5 -7.10036 ]
[.11189 .22501 0 4.64964 ]
[.0985 .25629 -54.3125 -6.85085 ]
[.0985 .25629 0 4.52415 ]
[.08557 .28648 -61.5 -6.82882 ]
[.08557 .28648 0 4.54618 ]
[.07308 .31563 -54.3125 -6.8076 ]
[.07308 .31563 0 4.5674 ]
[.06102 .34381 -61.5 -6.78716 ]
[.06102 .34381 0 4.58784 ]
[.04935 .37104 -61.5 -6.76745 ]
[.04935 .37104 0 4.60755 ]
[.03807 .39739 -61.5 -6.74844 ]
[.03807 .39739 0 4.62656 ]
[.20973 -0.00343 -7.2 -6.6872 ]
[.20973 -0.00343 0 4.1128 ]
[.19596 .24723 -14.4 -6.52326 ]
[.19596 .24723 0 4.27674 ]
[.1805 .52861 -14.4 -6.33988 ]
[.1805 .52861 0 4.46012 ]
[ 0 0 0 0 ]
[ 1 1.0852 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.0977 -212.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.0625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Infant) show
104.750 15.125 moveto
(mortality) show
167.500 15.125 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
180.812 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Deaths) show
231.125 15.125 moveto
(per) show
256.688 15.125 moveto
(1) show
268.312 15.125 moveto
(000) show
295.438 15.125 moveto
(live) show
322.562 15.125 moveto
(births) show
361.250 15.125 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
[ ] 0 setdash
.22414 0 m
.92954 .16815 L
s
.24912 .00177 m
.24872 .01005 L
s
gsave
.24964 -0.00888 -76.5743 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1960) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.29821 .01348 m
.2979 .02176 L
s
gsave
.29861 .00282 -76.7612 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1970) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34671 .02505 m
.34649 .03334 L
s
gsave
.34699 .01439 -76.945 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1980) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.39465 .03649 m
.39453 .04478 L
s
gsave
.39481 .02582 -77.1257 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1985) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.44203 .04779 m
.442 .05608 L
s
gsave
.44208 .03713 -77.3033 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1990) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.48887 .05896 m
.48892 .06726 L
s
gsave
.4888 .0483 -77.478 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1991) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53517 .07001 m
.53531 .0783 L
s
gsave
.53499 .05935 -77.6498 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1992) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58094 .08093 m
.58116 .08922 L
s
gsave
.58065 .07028 -77.8188 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1993) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.62619 .09173 m
.6265 .10002 L
s
gsave
.62579 .08108 -77.9851 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1994) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.67093 .10241 m
.67132 .11069 L
s
gsave
.67043 .09176 -78.1487 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1995) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.71517 .11296 m
.71564 .12124 L
s
gsave
.71456 .10232 -78.3097 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1996) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75891 .1234 m
.75946 .13168 L
s
gsave
.7582 .11277 -78.4682 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1997) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.80217 .13373 m
.8028 .142 L
s
gsave
.80136 .1231 -78.6241 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1998) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84495 .14394 m
.84566 .1522 L
s
gsave
.84404 .13332 -78.7777 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1999) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88727 .15404 m
.88805 .16229 L
s
gsave
.88626 .14342 -78.9288 -15.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2000) show
91.750 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22414 0 m
.05262 .40011 L
s
.21406 .01314 m
.22213 .01505 L
s
gsave
.20368 .01069 -136.875 -11.2645 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Australia) show
127.688 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.060 0.000 setrgbcolor
(\\346) show
134.875 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.19725 .05236 m
.20533 .05423 L
s
gsave
.18686 .04996 -122.5 -11.2341 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Austria) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.517 0.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1811 .09005 m
.18919 .09188 L
s
gsave
.1707 .08769 -122.5 -11.2051 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Belgium) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.974 0.000 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.16556 .1263 m
.17366 .12809 L
s
gsave
.15516 .12399 -115.312 -10.9482 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Canada) show
106.125 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.569 1.000 0.000 setrgbcolor
(\\346) show
113.312 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15061 .16119 m
.15872 .16295 L
s
gsave
.14019 .15892 -172.812 -11.1506 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Czech) show
106.125 12.875 moveto
(Republic) show
163.625 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.112 1.000 0.000 setrgbcolor
(\\346) show
170.812 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13621 .19479 m
.14432 .19652 L
s
gsave
.12578 .19257 -122.5 -10.8976 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Denmark) show
113.312 12.500 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.345 setrgbcolor
(\\346) show
120.500 12.500 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.12233 .22718 m
.13045 .22888 L
s
gsave
.11189 .22501 -122.5 -11.1004 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.875 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Finland) show
113.312 12.875 moveto
%%IncludeResource: font Mathematica3Mono
%%IncludeFont: Mathematica3Mono
/Mathematica3Mono findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 1.000 0.802 setrgbcolor
(\\346) show
120.500 12.875 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10894 .25842 m
.11706 .26009 L
s
gsave
.0985 .25629 -115.312 -10.8508 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResou