(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    369200,      10254]*)
(*NotebookOutlinePosition[    375980,      10431]*)
(*  CellTagsIndexPosition[    374338,      10390]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["MathXLS",
    FontSlant->"Italic"],
  " User Guide"
}], "Title",
  TextAlignment->Center,
  CellTags->"jlug:0.0.0.0"],

Cell[CellGroupData[{

Cell["Version 2.0.0", "Section",
  TextAlignment->Center,
  TextJustification->0],

Cell[TextData[{
  StyleBox["\nRolf Mertig, ", "SB"],
  ButtonBox["Mertig Consulting",
    ButtonData:>{
      URL[ "http://www.mertig.com"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n\nJuly 9th 2003", "SB"]
}],
  TextAlignment->Center],

Cell[TextData[{
  "Copyright \[Copyright] 2003 Mertig Consulting All rights reserved.\n",
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  StyleBox[" ", "TI",
    FontSlant->"Plain"],
  "and ",
  StyleBox["MathLink", "TI"],
  " are trademarks of Wolfram Research, Inc.\nJava is a trademark of Sun \
Microsystems, Inc."
}], "Text"],

Cell[TextData[{
  "This user guide is under constant development and will be expanded. \nSend \
suggestions, question, etc. to ",
  ButtonBox["rolf@mertig.com",
    ButtonData:>{
      URL[ "mailto:rolf@mertig.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell["All timings are done on a Linux 1GHz computer.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Subtitle"],

Cell["The following line loads the MathXLS package.", "Text"],

Cell[BoxData[
    \(Needs["\<MathXLS`\>"]\)], "Input",
  CellLabel->"In[8]:=",
  InitializationCell->True],

Cell[TextData[{
  "MathXLS is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (4.0, 4.1, 4.2 or 5.0) package for importing and exporting native \
Excel-type .xls files."
}], "Text"],

Cell["Typical uses of MathXLS:", "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          StyleBox[GridBox[{
                {
                  RowBox[{
                    RowBox[{
                    "\[FilledSmallSquare]", "  ", "Import", " ", "and", " ", 
                      "convert", " ", "data", " ", "from", " ", "binary", " ",
                       "Excel", " ", "files", " ", "into", " ", "Mathematica",
                       " ", "using", " ", "ImportXLS"}], ",", " ", 
                    RowBox[{"GetXLS", " ", "and", " ", "ReadXLS"}]}]},
                {
                  RowBox[{
                    RowBox[{
                    "\[FilledSmallSquare]", "  ", "Export", " ", "data", " ", 
                      "from", " ", "Mathematica", " ", "to", " ", "native", 
                      " ", "Excel", " ", "files", " ", "on", " ", "all", " ", 
                      "operating", " ", "systems", " ", "running", " ", 
                      "Mathematica", " ", "and", " ", "JLink"}], ",", " ", 
                    RowBox[{"like", " ", "MacOS", " ", 
                      StyleBox["X",
                        FontSlant->"Plain"]}], ",", " ", "Linux", ",", " ", 
                    RowBox[{"HP", "-", "UX"}], ",", " ", "Solaris", ",", " ", 
                    "Windows"}]},
                {
                  RowBox[{
                  "\[FilledSmallSquare]", "  ", "Import", " ", "and", " ", 
                    "Export", " ", "native", " ", "Excel", " ", "files", " ", 
                    "in", " ", 
                    FormBox[
                      RowBox[{"web", 
                        StyleBox[
                          AdjustmentBox["Mathematica",
                            BoxMargins->{{-0.175, 0}, {0, 0}}],
                          FontSlant->"Italic"]}],
                      "TextForm"], " ", "or", " ", "in", " ", 
                    StyleBox["a",
                      FontSlant->"Plain"], " ", "standalone", " ", 
                    RowBox[{"kernel", "."}]}]},
                {
                  RowBox[{
                  "\[FilledSmallSquare]", "  ", "Replace", " ", "Excel", " ", 
                    "Macros", " ", "by", " ", "Mathematica", " ", 
                    "programs"}]},
                {
                  RowBox[{
                    RowBox[{
                    "\[FilledSmallSquare]", " ", "Use", " ", "ExcelForm"}], 
                    ",", " ", 
                    RowBox[{
                    "XLSForm", " ", "and", " ", "XLSBar3D", " ", "functions", 
                      " ", "to", " ", "visualize", " ", "spreadsheet", " ", 
                      "data", " ", "in", " ", "Mathematica"}]}]}
                },
              ColumnAlignments->{Left}],
            GridBoxOptions->{RowLines->False}]],
        "1ColumnBox"], TraditionalForm]], "Text",
  PageWidth->PaperWidth,
  CellMargins->{{Inherited, Inherited}, {2, Inherited}},
  CellFrameMargins->8,
  FormatType->StandardForm,
  CellTags->"jlug:1.0.0.0"],

Cell[TextData[{
  "Some uses for ",
  StyleBox["MathXLS",
    FontWeight->"Bold"],
  "."
}], "MathCaption"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Requirements", "Subtitle"],

Cell[TextData[{
  "MathXLS needs Matheamtica 4.0, 4.1 or 4.2. For ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions 4.0 and 4.1 JLink and a Java run-time environment needs to be \
present. JLink is available from \
http://www.wolfram.com/solutions/mathlink/jlink."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation and updates", "Subtitle"],

Cell[CellGroupData[{

Cell["Instructions", "Section"],

Cell[TextData[{
  "Click the button \"Install MathXLS\" in the InstallMathXLS.nb notebook \
(located in the Installation directory in the MathXLS directory, or at \
http://www.mathxls.com/InstallMathXLS.nb) once. This downloads mathxls.zip \
from http://www.mathxls.com/download/ and installs it in the Applications \
directory in the $UserAddOnsDirectory for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and in $TopDirectory for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and 4.1. All files are put into a MathXLS directory. If you have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 or 4.1 you have to first install JLink, see \
http://www.wolfram.com/solutions/mathlink/jlink for further information. You \
may change the installation directory by setting $installdir=mydir before \
clicking. Make sure that this directory one of the values of $Path. You may \
also move the whole MathXLS directory after installation anywhere else on \
$Path."
}], "Text"],

Cell["\<\
You can enter your password into the dialog box during installation \
or use:  EnterPassword[ mypassword007 ].\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 1: Import .xls files", "Subtitle"],

Cell["Example notebooks:", "Text"],

Cell["\<\
Evaluating the next line gives a list of example notebooks from the \
Examples directory. All of those notebooks \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ExampleNotebooks\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({"cernlhc.nb", "OECDInfantMortality.nb", "OECDLifeExpectancy.nb", 
      "OECDPopulationAge.nb", "ukreal0002.nb", "UKRoadAccidents.nb", 
      "WorldMarriagePatterns.nb"}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
These are the example native Excel files, which are also in the \
Examples directory of the main MathXLS directory. ImportXLS and GetXLS have \
an option Path which is by default set to the normal $Path extended by the \
example directory.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ExampleFiles\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({"D4477.xls", "LHCB1IR3.xls", "LPX_Results.xls", "M00031357.xls", 
      "M00031359.xls", "ukreal0002.xls", 
      "WorldMarriagePatterns2000Table.xls"}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
open=NotebookOpen[ToFileName[{$MathXLSDir,\"Examples\"},$\
ExampleNotebooks[[#]]]]&;\
\>", "Input",
  CellLabel->"In[11]:="],

Cell["Calling  open[1]  opens the first example notebook.", "Text"],

Cell["open[1];", "Input",
  CellLabel->"In[12]:="],

Cell[CellGroupData[{

Cell["ImportXLS", "SubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ExampleFiles\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \({"D4477.xls", "LHCB1IR3.xls", "LPX_Results.xls", "M00031357.xls", 
      "M00031359.xls", "ukreal0002.xls", 
      "WorldMarriagePatterns2000Table.xls"}\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportXLS["\<D4477.xls\>"] // InputForm\)], "Input",
  CellLabel->"In[14]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{\"6.17 Death rates from road accidents: by gender\", \
Null, Null}, {Null, Null, Null}, 
  {\"Great Britain\", Null, \"Rates per 100,000 population\"}, {Null, Null, \
Null}, {Null, \"Men\", \"Women\"}, {1979, 22.9, 7.9}, 
  {1980, 20.8, 7.8}, {1981, 20.5, 7.5}, {1982, 20.4, 7.8}, {1983, 18.7, 7.}, \
{1984, 19.1, 7.1}, {1985, 17.3, 6.7}, 
  {1986, 17.9, 6.9}, {1987, 17.1, 6.5}, {1988, 16.8, 6.3}, {1989, 17.8, 6.7}, \
{1990, 17.1, 6.6}, {1991, 14.9, 5.8}, 
  {1992, 13.7, 5.4}, {1993, 12.2, 5.}, {1994, 11.7, 4.7}, {1995, 11.6, 4.6}, \
{1996, 11.8, 4.3}, {1997, 11.8, 4.2}, 
  {1998, 10.9, 4.2}, {1999, 11.1, 3.9}, {Null, Null, Null}, 
  {\"Source: Department of the Environment, Transport and the Regions\", \
Null, Null}]]\
\>", "Output",
  CellLabel->"Out[14]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ImportXLS\)\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \("ImportXLS[\"file.xls\"] imports all non-hidden sheets of the  workbook \
file.xls. Automatic type conversion is enabled by default.\n \
ImportXLS[\"file.xls\", \"a1:d4\"] imports the rows and cells as specified.\n \
ImportXLS[\"file.xls\", \"a1:d4\", \"a10:d15\"] imports the rows and cells as \
specified if the number of columns are equal.\n ImportXLS[\"file\",  \
\"sheetname\"] imports all rows and all columns of the sheet named sheetname. \
If the sheetname contains a \":\" character use:\n ImportXLS[\"file\",  \
SheetName[\"sheetname\"] ].\n ImportXLS[\"file\",  2] imports all rows and \
all columns of the second sheet. \n ImportXLS[\"file\", Conversion -> False] \
imports all cell elements as strings.\n ImportXLS[\"file\", RoundNumber -> \
False] imports the underlying numbers as saved internally in the Excel file. \
I.e., the default setting (RoundNumber->True) will return the number as \
displayed (formatted) in Excel. This may or may not be what is needed.\n \
ImportXLS[\"file\", XLSFormat -> True] gives formatting information like \
point size, bold, etc. \n ImportXLS[\"file\", XLSCellEvaluate -> False] gives \
the full XLSCell[ ... ] information."\)], "Print",
  CellTags->"Info3266768275-8756129"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[ImportXLS]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"BlankCellSubstitution", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$EmptyCell",
                  HoldForm]},
              {"Conversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"DateCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "1"},
              {"DateConversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "ToDateList"},
              {"DiscardEmptyColumns", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Right}\)},
              {"DiscardEmptyRows", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Bottom}\)},
              {"DiscardEmptySheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"GeneralCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "1"},
              {"GeneralToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"IncludeHiddenSheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"NormalizeWhiteSpace", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"NumberCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "4"},
              {"Path", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\(Prepend[$Path, $MathXLSDir <> "\<Examples\>"]\),
                  HoldForm]},
              {"PercentToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"Replacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({XLSCell[_, _, 
                      K_ /; MatchQ[
                          K, "\<\>" | "\< \>" | "\<  \>" | "\<   \>"], ___] \
\[RuleDelayed] $EmptyCell}\)},
              {"StringReplacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"ToList", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToMatrix", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToVector", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSFormat", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSToData", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[16]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportXLS["\<D4477.xls\>", Conversion \[Rule] False] // 
      InputForm\)], "Input",
  CellLabel->"In[17]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{\"6.17 Death rates from road accidents: by gender\", \
Null, Null}, {Null, Null, Null}, 
  {\"Great Britain\", Null, \"Rates per 100,000 population\"}, {Null, Null, \
Null}, {Null, \"Men\", \"Women\"}, 
  {\"1979\", \"22.9\", \"7.9\"}, {\"1980\", \"20.8\", \"7.8\"}, {\"1981\", \
\"20.5\", \"7.5\"}, {\"1982\", \"20.4\", \"7.8\"}, 
  {\"1983\", \"18.7\", \"7.0\"}, {\"1984\", \"19.1\", \"7.1\"}, {\"1985\", \
\"17.3\", \"6.7\"}, {\"1986\", \"17.9\", \"6.9\"}, 
  {\"1987\", \"17.1\", \"6.5\"}, {\"1988\", \"16.8\", \"6.3\"}, {\"1989\", \
\"17.8\", \"6.7\"}, {\"1990\", \"17.1\", \"6.6\"}, 
  {\"1991\", \"14.9\", \"5.8\"}, {\"1992\", \"13.7\", \"5.4\"}, {\"1993\", \
\"12.2\", \"5.0\"}, {\"1994\", \"11.7\", \"4.7\"}, 
  {\"1995\", \"11.6\", \"4.6\"}, {\"1996\", \"11.8\", \"4.3\"}, {\"1997\", \
\"11.8\", \"4.2\"}, {\"1998\", \"10.9\", \"4.2\"}, 
  {\"1999\", \"11.1\", \"3.9\"}, {Null, Null, Null}, {\"Source: Department of \
the Environment, Transport and the Regions\", Null, 
   Null}]]\
\>", "Output",
  CellLabel->"Out[17]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?NumberCellMethod\)\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \("NumberCellMethod is an option of ImportXLS. If set to 0: return the \
Excel formatted value as string.  If set to 1: return also the formatting \
information. If set to 2: return the number as saved by Excel internally. If \
set to 4: return the Excel formatted value directly as string (this might not \
always work, depending on the number format, however, it is rather fast in \
normal situations)."\)], "Print",
  CellTags->"Info3266768276-3138273"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportXLS["\<D4477.xls\>", XLSToData \[Rule] False, 
        NumberCellMethod \[Rule] 0] // InputForm\)], "Input",
  CellLabel->"In[19]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{XLSCell[\"GENERAL\", \"\", \"6.17 Death rates from road \
accidents: by gender\"], Null, Null}, 
  {Null, Null, Null}, {XLSCell[\"GENERAL\", \"\", \"Great Britain\"], Null, 
   XLSCell[\"GENERAL\", \"\", \"Rates per 100,000 population\"]}, {Null, \
Null, Null}, 
  {Null, XLSCell[\"GENERAL\", \"\", \"Men\"], XLSCell[\"GENERAL\", \"\", \
\"Women\"]}, {\"1979\", \"22.9\", \"7.9\"}, {\"1980\", \"20.8\", \"7.8\"}, 
  {\"1981\", \"20.5\", \"7.5\"}, {\"1982\", \"20.4\", \"7.8\"}, {\"1983\", \
\"18.7\", \"7.0\"}, {\"1984\", \"19.1\", \"7.1\"}, 
  {\"1985\", \"17.3\", \"6.7\"}, {\"1986\", \"17.9\", \"6.9\"}, {\"1987\", \
\"17.1\", \"6.5\"}, {\"1988\", \"16.8\", \"6.3\"}, 
  {\"1989\", \"17.8\", \"6.7\"}, {\"1990\", \"17.1\", \"6.6\"}, {\"1991\", \
\"14.9\", \"5.8\"}, {\"1992\", \"13.7\", \"5.4\"}, 
  {\"1993\", \"12.2\", \"5.0\"}, {\"1994\", \"11.7\", \"4.7\"}, {\"1995\", \
\"11.6\", \"4.6\"}, {\"1996\", \"11.8\", \"4.3\"}, 
  {\"1997\", \"11.8\", \"4.2\"}, {\"1998\", \"10.9\", \"4.2\"}, {\"1999\", \
\"11.1\", \"3.9\"}, {Null, Null, Null}, 
  {XLSCell[\"GENERAL\", \"\", \"Source: Department of the Environment, \
Transport and the Regions\"], Null, Null}]]\
\>", "Output",
  CellLabel->"Out[19]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportXLS["\<D4477.xls\>", XLSToData \[Rule] False, 
        NumberCellMethod \[Rule] 0] // InputForm\)], "Input",
  CellLabel->"In[20]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{XLSCell[\"GENERAL\", \"\", \"6.17 Death rates from road \
accidents: by gender\"], Null, Null}, 
  {Null, Null, Null}, {XLSCell[\"GENERAL\", \"\", \"Great Britain\"], Null, 
   XLSCell[\"GENERAL\", \"\", \"Rates per 100,000 population\"]}, {Null, \
Null, Null}, 
  {Null, XLSCell[\"GENERAL\", \"\", \"Men\"], XLSCell[\"GENERAL\", \"\", \
\"Women\"]}, {\"1979\", \"22.9\", \"7.9\"}, {\"1980\", \"20.8\", \"7.8\"}, 
  {\"1981\", \"20.5\", \"7.5\"}, {\"1982\", \"20.4\", \"7.8\"}, {\"1983\", \
\"18.7\", \"7.0\"}, {\"1984\", \"19.1\", \"7.1\"}, 
  {\"1985\", \"17.3\", \"6.7\"}, {\"1986\", \"17.9\", \"6.9\"}, {\"1987\", \
\"17.1\", \"6.5\"}, {\"1988\", \"16.8\", \"6.3\"}, 
  {\"1989\", \"17.8\", \"6.7\"}, {\"1990\", \"17.1\", \"6.6\"}, {\"1991\", \
\"14.9\", \"5.8\"}, {\"1992\", \"13.7\", \"5.4\"}, 
  {\"1993\", \"12.2\", \"5.0\"}, {\"1994\", \"11.7\", \"4.7\"}, {\"1995\", \
\"11.6\", \"4.6\"}, {\"1996\", \"11.8\", \"4.3\"}, 
  {\"1997\", \"11.8\", \"4.2\"}, {\"1998\", \"10.9\", \"4.2\"}, {\"1999\", \
\"11.1\", \"3.9\"}, {Null, Null, Null}, 
  {XLSCell[\"GENERAL\", \"\", \"Source: Department of the Environment, \
Transport and the Regions\"], Null, Null}]]\
\>", "Output",
  CellLabel->"Out[20]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(ImportXLS["\<D4477.xls\>", XLSToData \[Rule] False, 
                GeneralToNumber \[Rule] False] /. 
              XLSCell["\<NUMBER\>", "\<\>", {s_, _}] \[RuleDelayed] 
                s\)\  /. \ XLSCell["\<NUMBER\>", "\<0.0\>", {_, 
                  n_}] \[RuleDelayed] n\) /. 
          XLSCell["\<GENERAL\>", "\<\>", s_] \[RuleDelayed] s // ToMatrix\) // 
      InputForm\)], "Input",
  CellLabel->"In[21]:="],

Cell["\<\
{{\"6.17 Death rates from road accidents: by gender\", Null, Null}, \
{Null, Null, Null}, 
 {\"Great Britain\", Null, \"Rates per 100,000 population\"}, {Null, Null, \
Null}, {Null, \"Men\", \"Women\"}, {1979, 22.9, 7.9}, 
 {1980, 20.8, 7.8}, {1981, 20.5, 7.5}, {1982, 20.4, 7.8}, {1983, 18.7, 7.}, \
{1984, 19.1, 7.1}, {1985, 17.3, 6.7}, 
 {1986, 17.9, 6.9}, {1987, 17.1, 6.5}, {1988, 16.8, 6.3}, {1989, 17.8, 6.7}, \
{1990, 17.1, 6.6}, {1991, 14.9, 5.8}, 
 {1992, 13.7, 5.4}, {1993, 12.2, 5.}, {1994, 11.7, 4.7}, {1995, 11.6, 4.6}, \
{1996, 11.8, 4.3}, {1997, 11.8, 4.2}, 
 {1998, 10.9, 4.2}, {1999, 11.1, 3.9}, {Null, Null, Null}, 
 {\"Source: Department of the Environment, Transport and the Regions\", Null, \
Null}}\
\>", "Output",
  CellLabel->"Out[21]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[%]\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"6.17 Death rates from road accidents: by gender\"\
\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Great Britain\"\>", "\<\"\"\>", "\<\"Rates per \
100,000 population\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["5",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"Men\"\>", "\<\"Women\"\>"},
        {
          StyleBox["6",
            FontWeight->"Bold"], 
          StyleBox["1979",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["7",
            FontWeight->"Bold"], 
          StyleBox["1980",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["8",
            FontWeight->"Bold"], 
          StyleBox["1981",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["9",
            FontWeight->"Bold"], 
          StyleBox["1982",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.4",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["10",
            FontWeight->"Bold"], 
          StyleBox["1983",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["11",
            FontWeight->"Bold"], 
          StyleBox["1984",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.1",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["12",
            FontWeight->"Bold"], 
          StyleBox["1985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["13",
            FontWeight->"Bold"], 
          StyleBox["1986",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["14",
            FontWeight->"Bold"], 
          StyleBox["1987",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["15",
            FontWeight->"Bold"], 
          StyleBox["1988",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["16",
            FontWeight->"Bold"], 
          StyleBox["1989",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["17",
            FontWeight->"Bold"], 
          StyleBox["1990",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["18",
            FontWeight->"Bold"], 
          StyleBox["1991",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.8",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["19",
            FontWeight->"Bold"], 
          StyleBox["1992",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.4",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["20",
            FontWeight->"Bold"], 
          StyleBox["1993",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["21",
            FontWeight->"Bold"], 
          StyleBox["1994",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.7",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["22",
            FontWeight->"Bold"], 
          StyleBox["1995",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.6",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["23",
            FontWeight->"Bold"], 
          StyleBox["1996",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.3",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["24",
            FontWeight->"Bold"], 
          StyleBox["1997",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["25",
            FontWeight->"Bold"], 
          StyleBox["1998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.2",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["26",
            FontWeight->"Bold"], 
          StyleBox["1999",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.9",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["27",
            FontWeight->"Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["28",
            
            FontWeight->
              "Bold"], "\<\"Source: Department of the Environment, Transport \
and the Regions\"\>", "\<\"\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetXLS", "SubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?GetXLS\)\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \("GetXLS is like ImportXLS but with the option NumberCellMethod -> 2 \
(get the the numbers without rounding) and GeneralCellMethod -> 2 and \
DateCellMethod -> 0 settings."\)], "Print",
  CellTags->"Info3266768277-6105909"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetXLS["\<D4477.xls\>"] // InputForm\)], "Input",
  CellLabel->"In[24]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{\"6.17 Death rates from road accidents: by gender\", \
Null, Null}, {Null, Null, Null}, 
  {\"Great Britain\", Null, \"Rates per 100,000 population\"}, {Null, Null, \
Null}, {Null, \"Men\", \"Women\"}, {1979., 22.9, 7.9}, 
  {1980., 20.8, 7.8}, {1981., 20.5, 7.5}, {1982., 20.4, 7.8}, {1983., 18.7, \
7.}, {1984., 19.1, 7.1}, {1985., 17.3, 6.7}, 
  {1986., 17.9, 6.9}, {1987., 17.1, 6.5}, {1988., 16.8, 6.3}, {1989., 17.8, \
6.7}, {1990., 17.1, 6.6}, {1991., 14.9, 5.8}, 
  {1992., 13.7, 5.4}, {1993., 12.2, 5.}, {1994., 11.7, 4.7}, {1995., 11.6, \
4.6}, {1996., 11.8, 4.3}, {1997., 11.8, 4.2}, 
  {1998., 10.9, 4.2}, {1999., 11.1, 3.9}, {Null, Null, Null}, 
  {\"Source: Department of the Environment, Transport and the Regions\", \
Null, Null}]]\
\>", "Output",
  CellLabel->"Out[24]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?OptionSettings\)\)], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \("OptionSettings[symbol] shows the default option settings of \
symbol."\)], "Print",
  CellTags->"Info3266768277-6042653"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?NumberCellMethod\)\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \("NumberCellMethod is an option of ImportXLS. If set to 0: return the \
Excel formatted value as string.  If set to 1: return also the formatting \
information. If set to 2: return the number as saved by Excel internally. If \
set to 4: return the Excel formatted value directly as string (this might not \
always work, depending on the number format, however, it is rather fast in \
normal situations)."\)], "Print",
  CellTags->"Info3266768277-1698582"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[GetXLS]\)], "Input",
  CellLabel->"In[27]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"BlankCellSubstitution", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$EmptyCell",
                  HoldForm]},
              {"Conversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"DateCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "0"},
              {"DateConversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "ToDateList"},
              {"DiscardEmptyColumns", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Right}\)},
              {"DiscardEmptyRows", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({Bottom}\)},
              {"DiscardEmptySheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"GeneralCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "0"},
              {"GeneralToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"IncludeHiddenSheets", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"NormalizeWhiteSpace", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"NumberCellMethod", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "0"},
              {"Path", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\(Prepend[$Path, $MathXLSDir <> "\<Examples\>"]\),
                  HoldForm]},
              {"PercentToNumber", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"Replacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({XLSCell[_, _, 
                      K_ /; MatchQ[
                          K, "\<\>" | "\< \>" | "\<  \>" | "\<   \>"], ___] \
\[RuleDelayed] $EmptyCell}\)},
              {"StringReplacements", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"ToList", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToMatrix", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"ToVector", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSFormat", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSToData", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[27]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetXLS["\<D4477.xls\>"] // InputForm\)], "Input",
  CellLabel->"In[28]:="],

Cell["\<\
Workbook[\"/home/rolf/.Mathematica/Applications/MathXLS/Examples/\
D4477.xls\"][
 Sheet[1, \"data \"][{\"6.17 Death rates from road accidents: by gender\", \
Null, Null}, {Null, Null, Null}, 
  {\"Great Britain\", Null, \"Rates per 100,000 population\"}, {Null, Null, \
Null}, {Null, \"Men\", \"Women\"}, {1979., 22.9, 7.9}, 
  {1980., 20.8, 7.8}, {1981., 20.5, 7.5}, {1982., 20.4, 7.8}, {1983., 18.7, \
7.}, {1984., 19.1, 7.1}, {1985., 17.3, 6.7}, 
  {1986., 17.9, 6.9}, {1987., 17.1, 6.5}, {1988., 16.8, 6.3}, {1989., 17.8, \
6.7}, {1990., 17.1, 6.6}, {1991., 14.9, 5.8}, 
  {1992., 13.7, 5.4}, {1993., 12.2, 5.}, {1994., 11.7, 4.7}, {1995., 11.6, \
4.6}, {1996., 11.8, 4.3}, {1997., 11.8, 4.2}, 
  {1998., 10.9, 4.2}, {1999., 11.1, 3.9}, {Null, Null, Null}, 
  {\"Source: Department of the Environment, Transport and the Regions\", \
Null, Null}]]\
\>", "Output",
  CellLabel->"Out[28]//InputForm="]
}, Open  ]],

Cell["ukreal0002.xls is a somewhat bigger Excel file:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileByteCount[
      ToFileName[{$MathXLSDir, "\<Examples\>"}, "\<ukreal0002.xls\>"]]\)], \
"Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    \(2348544\)], "Output",
  CellLabel->"Out[29]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TotalTiming[\(g = GetXLS["\<ukreal0002.xls\>"];\)]\)], "Input",
  CellLabel->"In[30]:="],

Cell[BoxData[
    \({"13 seconds", Null}\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(info = XLSInfo["\<ukreal0002.xls\>"]\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \({"FAME Persistence2", "info", "1. real fwds, short end", 
      "2.  real fwd curve", "3. real spot, short end", 
      "4.  real spot curve"}\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(info // Length\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[32]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[ImportXLS]\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \({BlankCellSubstitution \[RuleDelayed] $EmptyCell, 
      Conversion \[Rule] Automatic, DateCellMethod \[Rule] 1, 
      DateConversion \[Rule] ToDateList, DiscardEmptyColumns \[Rule] {Right}, 
      DiscardEmptyRows \[Rule] {Bottom}, DiscardEmptySheets \[Rule] True, 
      GeneralCellMethod \[Rule] 1, GeneralToNumber \[Rule] False, 
      IncludeHiddenSheets \[Rule] False, NormalizeWhiteSpace \[Rule] True, 
      NumberCellMethod \[Rule] 4, 
      Path \[RuleDelayed] Prepend[$Path, $MathXLSDir <> "Examples"], 
      PercentToNumber \[Rule] False, 
      Replacements \[Rule] {XLSCell[_, _, 
              K_ /; MatchQ[
                  K, \*"\<\"\"\>" | " " | "  " | 
                    "   "], ___] \[RuleDelayed] $EmptyCell}, 
      StringReplacements \[Rule] {}, ToList \[Rule] False, 
      ToMatrix \[Rule] False, ToVector \[Rule] False, 
      XLSFormat \[Rule] False, XLSToData \[Rule] True}\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]],

Cell[BoxData[
    \(\(test = 
        Import["\<ukreal0002.xls\>", 1, 
          IncludeHiddenSheets \[Rule] True];\)\)], "Input",
  CellLabel->"In[34]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[test]\)], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    TagBox[\(\(Workbook[
          "/home/rolf/.Mathematica/Applications/MathXLS/Examples/ukreal0002.\
xls"]\)[\(Sheet[1, "FAME Persistence2", 
            Hidden]\)[\[LeftSkeleton]1\[RightSkeleton]]]\),
      Short]], "Output",
  CellLabel->"Out[35]//Short="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Length[g]", "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[36]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShortXLS[g[[3]]]", "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[GridBox[{
        {"#3", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["X",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Y",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Z",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AA",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AB",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AC",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AD",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AE",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AF",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AG",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AH",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AI",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AJ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AK",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AL",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AM",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AN",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AO",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AP",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AQ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AR",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AS",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AT",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AU",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"UK instantaneous real forward curve\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Maturity\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"years:\"\>", 
          StyleBox["2.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"03 Jan 00\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"04 Jan 00\"\>", 
          StyleBox["1.7228438080136368",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3094669575797788",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0891920244937485",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0113224516506092",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0248792337821278",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.097272493945041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2069630631851465",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.332582863898256",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4579058969010341",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5786293008217367",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6921357010658735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.795807723038955",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8870279921464899",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9632619096474062",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0237504870560032",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.069441898119543",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1013533962018474",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1205022346641544",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1279037672360572",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1245659948359465",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1114951396351875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0896974237987136",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.060138689103884",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.023625889127713",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9809269030358547",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9328096099939636",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8800418891676904",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.823391256160087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.763517181539343",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.700820725573894",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6356651270193485",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5684136246313134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4994294571653985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4290758633772103",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3577160820223562",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2856988240799596",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2132050296749413",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1403079265617857",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0670789708129669",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9935896185009597",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9199113256982389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8461155484772789",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7722737429105533",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"05 Jan 00\"\>", 
          StyleBox["1.7044597886552901",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2964960158715135",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0824101626223297",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0108164627076464",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0302360729268538",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1079491875558658",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2223437935133357",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3519752550726718",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4806412274545169",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6041087131583789",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.719807435269087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8251671168714692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9176174810503548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9946734227132688",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.055631973960655",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1014792797289585",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1332680351423288",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.152050935310735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1588773195460265",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1547837496743356",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.140803746883306",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.117970832306431",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0872760302357922",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.049545874570882",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.005567106697664",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.956126468002093",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9020106998701318",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8440061280164788",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.782784983095871",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.718750814596825",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6522685235816952",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.583703011112839",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.513419178252613",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4417819260633735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.369156155607475",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2958916568298087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2221671300850505",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1480530305861607",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0736181030105403",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9989310920355894",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9240607423387087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8490757985972992",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7740450054887608",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"06 Jan 00\"\>", 
          StyleBox["1.694859303507433",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.291572616528054",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0814979223287682",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.013068980687576",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0348154543372476",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1141947136735164",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.229707257748664",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3600157075961925",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.489073382217253",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6127289079190699",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.728454632122867",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8337229022498673",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9260060657212943",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.002863617544403",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.063634196029634",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1093187709548418",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1409820635359322",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1596887949400796",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.166498733338846",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16245309504203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14858875362559",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1259425824788307",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0955073462132705",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.058107861527862",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0145289788172818",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9655555484762042",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.911972420899305",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8545639886648284",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7939982726477395",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7306734581159242",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6649495856512",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5971866958353824",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5277448292502858",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4569840264777265",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3852643280995203",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3129303845608447",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2401559893352694",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1670084129321738",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.093553309847205",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0198563345760099",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9459831416142351",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8719993854575274",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7979707206015328",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"07 Jan 00\"\>", 
          StyleBox["1.6522994944855915",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2435606452113475",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0327940832629792",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9665088236785038",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9916660695946551",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0752021342533045",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1951999473319874",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3298948854510235",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4631228534912815",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5907458754742871",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.71018284031689",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8188526369359421",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9141741542482942",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9936636916268304",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0566873247525845",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.104266834142998",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.137482446938005",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1574143901951572",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1651412586576533",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.161735826420182",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.148269570711353",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1258139671890692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09539178813539",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0578492685187855",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.013992656645441",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9646282008215525",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9105621493533071",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8526001414677724",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.791423086385072",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7274357320855485",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.661005787697193",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5925009623479969",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5222889651659506",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.450737505279044",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3782142918152724",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3050701347978473",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2314788530379237",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1575086866746729",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0832264654825987",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0086990192362069",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9339931777100016",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8591757706784879",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7843136279161694",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>"},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"18 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"19 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"20 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"23 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"24 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"25 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"26 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"27 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"30 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"31 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"2.  real fwd curve"]
}, Open  ]],

Cell["\<\
Since hidden sheets are there, they are also counted. I.e., to get \
the third visible sheet (similar to g[[3]]), one has to ask for the 4th \
one:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TotalTiming[\(i = ImportXLS["\<ukreal0002.xls\>", 4];\)]\)], "Input",
  CellLabel->"In[38]:="],

Cell[BoxData[
    \({"5 seconds", Null}\)], "Output",
  CellLabel->"Out[38]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShortXLS[i]\)], "Input",
  CellLabel->"In[39]:="],

Cell[BoxData[GridBox[{
        {"#4", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["X",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Y",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Z",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AA",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AB",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AC",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AD",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AE",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AF",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AG",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AH",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AI",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AJ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AK",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AL",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AM",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AN",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AO",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AP",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AQ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AR",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AS",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AT",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AU",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"UK instantaneous real forward curve\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Maturity\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"years:\"\>", 
          StyleBox["2.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"03-Jan-2000\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"04-Jan-2000\"\>", 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.33",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.58",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.89",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.88",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.76",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.64",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.57",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.43",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.77",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"05-Jan-2000\"\>", 
          StyleBox["1.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.35",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.48",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.83",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.78",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.58",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.51",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.44",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.37",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.77",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"06-Jan-2000\"\>", 
          StyleBox["1.69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.23",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.61",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.83",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.66",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.53",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.39",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.95",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.87",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"07-Jan-2000\"\>", 
          StyleBox["1.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.33",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.66",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.45",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.38",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.23",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.86",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.78",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            
            FontWeight->
              
              "Bold"], "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>"},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"18-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"19-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"20-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"23-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"24-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"25-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"26-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"27-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"30-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"31-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"2.  real fwd curve"],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[39]="]
}, Open  ]],

Cell["\<\
It is also possible to use the sheet name as second argument to \
ImportXLS:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nam = info[\([4]\)]\)], "Input",
  CellLabel->"In[40]:="],

Cell[BoxData[
    \("2.  real fwd curve"\)], "Output",
  CellLabel->"Out[40]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TotalTiming[\(w = ImportXLS["\<ukreal0002.xls\>", nam];\)]\)], "Input",
  CellLabel->"In[41]:="],

Cell[BoxData[
    \({"7 seconds", Null}\)], "Output",
  CellLabel->"Out[41]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShortXLS[w]", "Input",
  CellLabel->"In[42]:="],

Cell[BoxData[GridBox[{
        {"#4", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["X",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Y",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Z",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AA",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AB",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AC",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AD",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AE",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AF",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AG",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AH",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AI",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AJ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AK",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AL",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AM",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AN",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AO",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AP",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AQ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AR",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AS",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AT",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AU",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"UK instantaneous real forward curve\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Maturity\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"years:\"\>", 
          StyleBox["2.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"03-Jan-2000\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"04-Jan-2000\"\>", 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.33",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.58",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.89",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.98",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.88",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.76",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.64",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.57",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.43",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.21",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.77",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"05-Jan-2000\"\>", 
          StyleBox["1.7",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.35",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.48",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.83",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.12",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.05",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.84",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.78",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.72",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.58",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.51",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.44",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.37",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.22",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.07",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.92",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.77",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            FontWeight->"Bold"], "\<\"06-Jan-2000\"\>", 
          StyleBox["1.69",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.29",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.23",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.36",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.49",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.61",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.83",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.66",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.53",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.39",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.09",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.02",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.95",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.87",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["10",
            FontWeight->"Bold"], "\<\"07-Jan-2000\"\>", 
          StyleBox["1.65",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.24",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.03",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.97",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.33",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.46",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.71",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.82",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.99",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.14",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.17",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.15",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.13",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.06",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.96",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.91",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.85",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.79",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.73",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.66",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.59",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.52",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.45",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.38",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.31",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.23",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.16",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.08",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.01",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.93",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.86",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.78",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            
            FontWeight->
              
              "Bold"], "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", \
"\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\<\"<<767>>\"\>", "\
\<\"<<767>>\"\>"},
        {
          StyleBox["12",
            
            FontWeight->
              "Bold"], "\<\"18-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["13",
            
            FontWeight->
              "Bold"], "\<\"19-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["14",
            
            FontWeight->
              "Bold"], "\<\"20-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["15",
            
            FontWeight->
              "Bold"], "\<\"23-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["16",
            
            FontWeight->
              "Bold"], "\<\"24-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["17",
            
            FontWeight->
              "Bold"], "\<\"25-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["18",
            
            FontWeight->
              "Bold"], "\<\"26-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["19",
            
            FontWeight->
              "Bold"], "\<\"27-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["20",
            
            FontWeight->
              "Bold"], "\<\"30-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
        {
          StyleBox["21",
            
            FontWeight->
              "Bold"], "\<\"31-Dec-2002\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  ShowCellTags->True,
  InputAutoReplacements->{},
  CellTags->"2.  real fwd curve"],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[42]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReadXLS", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["?ReadXLS", "Input",
  CellLabel->"In[43]:="],

Cell[BoxData[
    \("ReadXLS is like GetXLS but with the option ToMatrix -> True."\)], \
"Print",
  CellTags->"Info3266768305-9162676"]
}, Open  ]],

Cell["This reads in the fourth sheet in as a matrix.", "Text"],

Cell["test=ReadXLS[\"ukreal0002.xls\",4];", "Input",
  CellLabel->"In[44]:="],

Cell[CellGroupData[{

Cell["Head[test]", "Input",
  CellLabel->"In[45]:="],

Cell[BoxData[
    \(List\)], "Output",
  CellLabel->"Out[45]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dimensions[test]", "Input",
  CellLabel->"In[46]:="],

Cell[BoxData[
    \({787, 47}\)], "Output",
  CellLabel->"Out[46]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShortXLS[test,{8,2}]", "Input",
  CellLabel->"In[47]:="],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["D",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["E",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["G",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["H",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["I",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["J",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["K",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["L",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["M",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["O",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["P",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Q",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["R",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["S",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["U",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["V",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["W",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["X",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Y",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["Z",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AA",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AB",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AC",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AD",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AE",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AF",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AG",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AH",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AI",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AJ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AK",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AL",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AM",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AN",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AO",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AP",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AQ",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AR",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AS",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AT",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["AU",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"UK instantaneous real forward curve\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["2",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["3",
            
            FontWeight->
              "Bold"], "\<\"Maturity\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["4",
            FontWeight->"Bold"], "\<\"years:\"\>", 
          StyleBox["2.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["3.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["4.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["6.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["7.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["8.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["9.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["10.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["11.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["13.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["14.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["15.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["16.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["17.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["18.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["19.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["20.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["21.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["22.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["23.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["24.5",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["25.",
            FontColor->RGBColor[0, 0, 1]]},
        {
          StyleBox["5",
            
            FontWeight->
              "Bold"], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
        {
          StyleBox["6",
            
            FontWeight->
              "Bold"], "\<\"03 Jan 00\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["7",
            FontWeight->"Bold"], "\<\"04 Jan 00\"\>", 
          StyleBox["1.7228438080136368",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3094669575797788",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0891920244937485",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0113224516506092",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0248792337821278",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.097272493945041",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2069630631851465",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.332582863898256",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4579058969010341",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5786293008217367",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6921357010658735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.795807723038955",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8870279921464899",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9632619096474062",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0237504870560032",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.069441898119543",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1013533962018474",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1205022346641544",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1279037672360572",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1245659948359465",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1114951396351875",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0896974237987136",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.060138689103884",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.023625889127713",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9809269030358547",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9328096099939636",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8800418891676904",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.823391256160087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.763517181539343",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.700820725573894",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6356651270193485",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.5684136246313134",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4994294571653985",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4290758633772103",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3577160820223562",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2856988240799596",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2132050296749413",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1403079265617857",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0670789708129669",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9935896185009597",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9199113256982389",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8461155484772789",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7722737429105533",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["8",
            FontWeight->"Bold"], "\<\"05 Jan 00\"\>", 
          StyleBox["1.7044597886552901",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2964960158715135",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0824101626223297",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0108164627076464",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0302360729268538",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1079491875558658",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2223437935133357",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.3519752550726718",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4806412274545169",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6041087131583789",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.719807435269087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8251671168714692",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9176174810503548",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9946734227132688",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.055631973960655",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1014792797289585",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1332680351423288",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.152050935310735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1588773195460265",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.1547837496743356",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.140803746883306",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.117970832306431",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.0872760302357922",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.049545874570882",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["2.005567106697664",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.956126468002093",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.9020106998701318",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.8440061280164788",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.782784983095871",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.718750814596825",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.6522685235816952",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.583703011112839",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.513419178252613",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.4417819260633735",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.369156155607475",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2958916568298087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.2221671300850505",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.1480530305861607",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["1.0736181030105403",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9989310920355894",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.9240607423387087",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.8490757985972992",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["0.7740450054887608",
            FontColor->RGBColor[0, 0, 
            1]], "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
        {
          StyleBox["9",
            
            FontWeight->
              "Bold"], "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", \
"\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\<\"<<777>>\"\>", "\
\<\"<<777>>\"\>"},
        {
          StyleBox["10",
            
            FontWeight->
              "Bold"], "\<\"30 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
        {
          StyleBox["11",
            
            FontWeight->
              "Bold"], "\<\"31 Dec 02\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"}
        },
      ColumnAlignments->{Center, Left, Right},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 2: Export .xls files", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ExportXLS\)\)], "Input",
  CellLabel->"In[48]:="],

Cell[BoxData[
    \("ExportXLS[file.xls, matrix] export the matrix into the Excel .xls \
format."\)], "Print",
  CellTags->"Info3266768310-8377918"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[ExportXLS]\)], "Input",
  CellLabel->"In[49]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"DefaultSheetNamePrefix", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<Sheet \>\""},
              {"ExportAsRaster", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({False, 
                  5, 1}\)},
              {"ExportDirectory", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\(Directory[]\),
                  HoldForm]},
              {"OverWrite", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"PageOrientation", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<PORTRAIT\>\""},
              {"PaperSize", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<A4\>\""},
              {"PrintMargins", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({1, 
                  1}\)},
              {"SetLocale", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({"\<en\>", "\<US\>"}\)},
              {"SetProtected", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"SetScaleFactor", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "50"},
              {"SetSelected", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "1"},
              {"XLSAlignment", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<GENERAL\>\""},
              {"XLSBackgroundColor", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<WHITE\>\""},
              {"XLSBold", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSBorder", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<ALL\>\""},
              {"XLSBorderLineStyle", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<NONE\>\""},
              {"XLSColor", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<BLACK\>\""},
              {"XLSColumnWidth", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "9"},
              {"XLSFontName", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<Arial\>\""},
              {"XLSItalic", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"XLSPointSize", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "10"},
              {"XLSRowCollapse", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({False}\)},
              {"XLSRowHeight", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "12"},
              {"XLSUnderline", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[49]//StyleForm="]
}, Open  ]],

Cell["m = Table[ Random[], {i, 500}, {j, 100} ];", "Input",
  CellLabel->"In[50]:="],

Cell["xlsfile = ToFileName[Directory[],\"randomreals.xls\"];", "Input",
  CellLabel->"In[51]:="],

Cell["\<\
ExportXLS[xlsfile, m, 
\tXLSColumnWidth -> 5, XLSBackgroundColor -> \"BLUE\"];\
\>", "Input",
  CellLabel->"In[52]:="],

Cell["This checks that the data are exported correctly. ", "Text"],

Cell[CellGroupData[{

Cell["Print[\"check: \", m === (r=ReadXLS[xlsfile])];", "Input",
  CellLabel->"In[53]:="],

Cell[BoxData[
    InterpretationBox[\("check: "\[InvisibleSpace]True\),
      SequenceForm[ "check: ", True],
      Editable->False]], "Print",
  CellLabel->"From In[53]:="]
}, Open  ]],

Cell["DeleteFile[xlsfile]", "Input",
  CellLabel->"In[54]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 3: Manipulate and visualize tables", "Subtitle"],

Cell[CellGroupData[{

Cell["ExcelForm", "SubsectionIcon"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has TableForm which is fine for simple tasks. A few extensions are \
explained below."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ExcelForm\)\)], "Input",
  CellLabel->"In[55]:="],

Cell[BoxData[
    \("ExcelForm[expr] displays expr in a Excel-like matrix form where expr \
can have head  Workbook[] or List.  ExcelForm[expr, i] displays only the \
first sheet. By default any Null element is displayed as an empty string. \
ExcelForm calls XLSForm when no FrontEnd is present."\)], "Print",
  CellTags->"Info3266768319-6255447"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[{\ {11, 12, "\<test\>"}, {21, Null, 
          DateList[Date[]]}}]\)], "Input",
  CellLabel->"In[56]:="],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            FontWeight->"Bold"], 
          StyleBox["11",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["12",
            FontColor->RGBColor[0, 0, 1]], "\<\"test\"\>"},
        {
          StyleBox["2",
            FontWeight->"Bold"], 
          StyleBox["21",
            FontColor->RGBColor[0, 0, 1]], "\<\"\"\>", "\<\"09-Jul-2003\"\>"}
        },
      ColumnAlignments->{Center, Right, Right, Left},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[ExcelForm]\)], "Input",
  CellLabel->"In[57]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"ButtonBackground", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(GrayLevel[0.9`]\)},
              {"CellMargins", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({{Inherited, Inherited}, {Inherited, 
                    Inherited}}\)},
              {"ColumnLetterHeading", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"CornerFill", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"ExcelFormRules", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({DateList[
                      C_List] \[RuleDelayed] \
\(DateToString["\<DD-MMM-YYYY\>", "\<English\>"]\)[C]}\)},
              {"HideColumns", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"HideRows", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"NullReplacement", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(Null \[RuleDelayed] "\<\>"\)},
              {"NumberColor", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> False]&)], \(RGBColor[
                  0, 0, 1]\)},
              {"ShowSheetName", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Automatic"},
              {"StringCutOff", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "66"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[57]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExcelForm[{\ {11, 12, "\<test123456789\>"}, {21, Null, 
          DateList[Date[]]}}, StringCutOff \[Rule] 6, 
      NumberColor \[Rule] GrayLevel[0]]\)], "Input",
  CellLabel->"In[58]:="],

Cell[BoxData[GridBox[{
        {"#", 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["A",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True], 
          StyleBox[
            RowBox[{
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["C",
                FontWeight->"Bold"], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]], 
              StyleBox["_",
                FontColor->GrayLevel[1]]}],
            ZeroWidthTimes->True]},
        {
          StyleBox["1",
            FontWeight->"Bold"], 
          StyleBox["11",
            FontColor->GrayLevel[0]], 
          StyleBox["12",
            FontColor->GrayLevel[0]], 
          InterpretationBox[
            ButtonBox[Cell["test12", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"test123456789\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"test123456789\""],
            "\"test123456789\""]},
        {
          StyleBox["2",
            FontWeight->"Bold"], 
          StyleBox["21",
            FontColor->GrayLevel[0]], "\<\"\"\>", 
          InterpretationBox[
            ButtonBox[Cell["09-Jul", "Text",
                CellMargins->{{0, 0}, {0, 0}},
                Background->GrayLevel[0.900008]],
              ButtonFunction:>NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      TextData[ {"\"09-Jul-2003\""}], "Text"]}]],
              Active->True,
              ButtonMargins->0,
              ButtonFrame->"None",
              ButtonNote->"\"09-Jul-2003\""],
            "\"09-Jul-2003\""]}
        },
      ColumnAlignments->{Center, Right, Right, Left},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Output",
  CellHorizontalScrolling->True,
  InputAutoReplacements->{}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["XLSForm", "SubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[XLSForm]\)], "Input",
  CellLabel->"In[59]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"CharacterEncoding", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$CharacterEncoding",
                  HoldForm]},
              {"FrontEndPrintFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(CellPrint[
                    Cell[#1, "\<Output\>", 
                      PageWidth \[Rule] \[Infinity]]] &\)},
              {"KernelPrintFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "Print"},
              {"Replace", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                
                TagBox[\({Null \[RuleDelayed] "\<\>", 
                    DateList[
                        C_List] \[RuleDelayed] \
\(DateToString["\<DD-MMM-YYYY\>", "\<English\>"]\)[C]}\),
                  HoldForm]},
              {"XLSFormSheetInformation", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[59]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLSForm\)\)], "Input",
  CellLabel->"In[60]:="],

Cell[BoxData[
    \("XLSForm[Worbook[][Sheet[][{...}, {...}, ...] displays a all sheets \
aligned  vertically in a tabular format."\)], "Print",
  CellTags->"Info3266768319-3032578"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SortXLS\)\)], "Input",
  CellLabel->"In[61]:="],

Cell[BoxData[
    \("SortXLS[matrix, function] sorts the rows of matrix according to the \
value of applying function to each row. SortXLS[matrix] is equivalent to \
SortXLS[matrix, Mean[Select[#, NumberQ]]&]. \nSortXLS[matrix, 1] sorts with \
respect to the first column in ascending order. SortXLS[matrix, -1] sorts \
with respect to the first column in descending order, where order is defined \
as OrderedQ[{ ... , ...}]."\)], "Print",
  CellTags->"Info3266768319-2269429"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLSBar3D\)\)], "Input",
  CellLabel->"In[62]:="],

Cell[BoxData[
    \("XLSBar3D creates a 3-D bar chart for certain OECD-like Excel \
sheets."\)], "Print",
  CellTags->"Info3266768319-4901111"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SubMatrix\)\)], "Input",
  CellLabel->"In[63]:="],

Cell[BoxData[
    \("SubMatrix[expr, a1:b4] extracts from the matrix (or Workbook with on \
sheet) expr the sub-matrix specified by the range. SubMatrix[expre, range1, \
range2, ...] can be used to select non-rectangular areas; if needed emtpy \
cells are padded."\)], "Print",
  CellTags->"Info3266768319-4032595"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SubVector\)\)], "Input",
  CellLabel->"In[64]:="],

Cell[BoxData[
    \("SubVector[expr, a1:b4] extracts from the matrix (or Workbook) expr the \
submatrix specified by the range and flattens it to a vector."\)], "Print",
  CellTags->"Info3266768319-9455315"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SubElement\)\)], "Input",
  CellLabel->"In[65]:="],

Cell[BoxData[
    \("SubElement[expr, a1] extracts from the matrix (or Workbook) expr the \
element specified."\)], "Print",
  CellTags->"Info3266768319-2616931"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["XLSListPlot", "SubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLSListPlot\)\)], "Input",
  CellLabel->"In[66]:="],

Cell[BoxData[
    \("Like ListPlot, but with a different automatic x-axis \
tick-function."\)], "Print",
  CellTags->"Info3266768319-9156967"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[XLSListPlot]\)], "Input",
  CellLabel->"In[67]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"HorizontalTickStart", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "0.15`"},
              {"NumberOfHorizontalTicks", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "4"},
              {"Replace", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({DateList[
                      C_List] \[RuleDelayed] \(DateToString["\<DD-MMM-YY\>", \
"\<English\>"]\)[C]}\)},
              {"TickStringFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "Identity"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[67]//StyleForm="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 4: Miscellaneous functions", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?PlotData2D\)\)], "Input",
  CellLabel->"In[68]:="],

Cell[BoxData[
    \("PlotData2D plots a list."\)], "Print",
  CellTags->"Info3266768319-3911076"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[PlotData2D]\)], "Input",
  CellLabel->"In[69]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"AxesLabel", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({"\<\>", "\<\>"}\)},
              {"AxesOrigin", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\({1, Min[{#1}]} &\),
                  HoldForm]},
              {"ImageSize", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$PlotDataImageSize",
                  HoldForm]},
              {"PlotJoined", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"},
              {"PlotLabel", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<\>\""},
              {"PlotLegend", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                
                TagBox[\(If[
                      MatchQ[#1\[LeftDoubleBracket]1\[RightDoubleBracket], \
{__String}], If[MatchQ[#1\[LeftDoubleBracket]All, 
                            1\[RightDoubleBracket], {__String}], 
                        Rest[#1\[LeftDoubleBracket]1\[RightDoubleBracket]], \
#1\[LeftDoubleBracket]1\[RightDoubleBracket]], 
                      Take[MathXLS`Private`$ExcelColumnLabels, \
\(Dimensions[#1]\)\[LeftDoubleBracket]2\[RightDoubleBracket]]] &\),
                  HoldForm]},
              {"PlotRange", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "All"},
              {"Ticks", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                
                TagBox[\(If[
                      MatchQ[#1\[LeftDoubleBracket]All, 
                          1\[RightDoubleBracket], {__String}], 
                      If[MatchQ[#1\[LeftDoubleBracket]1\[RightDoubleBracket], \
{__String}], {Transpose[{Range[\(Dimensions[#1]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket] - 1], Rest[#1\[LeftDoubleBracket]All, 
                                  1\[RightDoubleBracket]]}], 
                          Automatic}, {Transpose[{Range[\(Dimensions[#1]\)\
\[LeftDoubleBracket]1\[RightDoubleBracket]], #1\[LeftDoubleBracket]All, 
                                1\[RightDoubleBracket]}], Automatic}], 
                      Automatic] &\),
                  HoldForm]}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[69]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?PlotData3D\)\)], "Input",
  CellLabel->"In[70]:="],

Cell[BoxData[
    \("PlotData3D plots a matrix."\)], "Print",
  CellTags->"Info3266768320-8924515"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings[PlotData3D]\)], "Input",
  CellLabel->"In[71]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"BarColorTable", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["Automatic",
                  HoldForm]},
              {"ColorFun", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(Function[{MathXLS`Private`i, 
                    MathXLS`Private`j, 
                    MathXLS`Private`n}, {MathXLS`Private`n, 
                    SurfaceColor[
                      MathXLS`Private`$BarColorTable\[LeftDoubleBracket]
                        MathXLS`Private`i\[RightDoubleBracket]]}]\)},
              {"ColorTickCharacter", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<\[FilledCircle]\>\""},
              {"Epilog", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"FaceGridFraction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "0.1`"},
              {"ImageSize", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$PlotDataImageSize",
                  HoldForm]},
              {"LegendText", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], \({}\)},
              {"PlotLabel", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<\>\""},
              {"PlotLabelFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                RowBox[{
                  TagBox[
                    
                    StyleBox[\(StringReplace[
                        ToString[#1], "\<\"\>" \[Rule] "\<\>"]\),
                      "Section",
                      FontWeight->"Bold"],
                    (StyleForm[ #, $PlotLabelStyle, FontWeight -> "Bold"]&)], 
                  "&"}]},
              {"ViewPoint", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \({0, \(-8\), 0}\)}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[71]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLSBar3D\)\)], "Input",
  CellLabel->"In[72]:="],

Cell[BoxData[
    \("XLSBar3D creates a 3-D bar chart for certain OECD-like Excel \
sheets."\)], "Print",
  CellTags->"Info3266768320-2852013"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?StringToNumber\)\)], "Input",
  CellLabel->"In[73]:="],

Cell[BoxData[
    \("StringToNumber is a function and an option. \n StringToNumber[string] \
converts the string to a number. As otpion possible settings are True, \
Percent or PercentToNumber."\)], "Print",
  CellTags->"Info3266768320-3791477"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ToVector\)\)], "Input",
  CellLabel->"In[74]:="],

Cell[BoxData[
    \("ToVector is an option to ImportXLS. If set to True the result is \
returned as a vector, i.e., a simple list."\)], "Print",
  CellTags->"Info3266768320-3335663"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ToMatrix\)\)], "Input",
  CellLabel->"In[75]:="],

Cell[BoxData[
    \("ToMatrix[Workbook[][Sheet[][...]]] returns a matrix. One Sheet is \
returned as a matrix,  if more sheets are present they are joined. ToMatrix \
is also an option to ImportXLS."\)], "Print",
  CellTags->"Info3266768320-5677351"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ToList\)\)], "Input",
  CellLabel->"In[76]:="],

Cell[BoxData[
    \("ToList[Workbook[][Sheet[][...]]] returns a list of matrices. ToList is \
also an option to ImportXLS."\)], "Print",
  CellTags->"Info3266768320-1426080"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?TotalTiming\)\)], "Input",
  CellLabel->"In[77]:="],

Cell[BoxData[
    \("TotalTiming[expr] measures the wall clock time in seconds needed to \
evaluate expr."\)], "Print",
  CellTags->"Info3266768320-3035838"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLSInfo\)\)], "Input",
  CellLabel->"In[78]:="],

Cell[BoxData[
    \("XLSInfo[xlsfile] gives information about the number of sheets and ther \
names."\)], "Print",
  CellTags->"Info3266768320-4938912"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \($ExampleFiles\)], "Input",
  CellLabel->"In[79]:="],

Cell[BoxData[
    \({"D4477.xls", "LHCB1IR3.xls", "LPX_Results.xls", "M00031357.xls", 
      "M00031359.xls", "ukreal0002.xls", 
      "WorldMarriagePatterns2000Table.xls"}\)], "Output",
  CellLabel->"Out[79]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XLS2HTML\)\)], "Input",
  CellLabel->"In[80]:="],

Cell[BoxData[
    \("XLS2HTML[htmlfile, Workbook[][...]] saves the workbook to an htmlfile.\
\n XLS2HTML[htmlfile, {xlsfile, moreImportXLSargs}] imports xlsfile with \
ImportXLS, converts it to plain ASCII  and saves the resulting (simple) HTML \
file to htmlfile."\)], "Print",
  CellTags->"Info3266768320-7042209"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OptionSettings@XLS2HTML\)], "Input",
  CellLabel->"In[81]:="],

Cell[BoxData[
    TagBox[
      StyleBox[
        TagBox[GridBox[{
              {"CharacterEncoding", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox["$CharacterEncoding",
                  HoldForm]},
              {"Conversion", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "False"},
              {"Epilog", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<</PRE> </BODY> </HTML>\>\""},
              {"FrontEndPrintFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (
                  StyleForm[ #, ShowStringCharacters -> 
                    False]&)], \(CellPrint[
                    Cell[#1, "\<Output\>", 
                      PageWidth \[Rule] \[Infinity]]] &\)},
              {"KernelPrintFunction", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "Print"},
              {"Prolog", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                "\"\<<HTML> <BODY> <STYLE> \\n PRE {font-family: \
\\\"Courier\\\", monospace} \\n</Style> \\n<PRE>\\n\>\""},
              {"Replace", 
                TagBox[
                  StyleBox["\<\":>\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], 
                TagBox[\({Null \[RuleDelayed] "\<\>", 
                    DateList[
                        C_List] \[RuleDelayed] \
\(DateToString["\<DD-MMM-YYYY\>", "\<English\>"]\)[C]}\),
                  HoldForm]},
              {"XLSFormSheetInformation", 
                TagBox[
                  StyleBox["\<\"->\"\>",
                    ShowStringCharacters->False],
                  (StyleForm[ #, ShowStringCharacters -> False]&)], "True"}
              },
            ColumnSpacings->3,
            ColumnAlignments->{Left},
            GridFrame->True,
            RowLines->True],
          Grid],
        "Output",
        ShowStringCharacters->True],
      (StyleForm[ #, "Output", ShowStringCharacters -> True]&)]], "Output",
  CellLabel->"Out[81]//StyleForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Chomp\)\)], "Input",
  CellLabel->"In[82]:="],

Cell[BoxData[
    \("Chomp[string] chops initial and final white space of string."\)], \
"Print",
  CellTags->"Info3266768320-7278372"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?CasesH\)\)], "Input",
  CellLabel->"In[83]:="],

Cell[BoxData[
    \("CasesH[expr, f] is equivalent to Cases[{expr}, HoldPattern[f[___]], \
Infinity]//Union. CasesH[expr, f1, f2, ...] or CasesH[expr, {f1, f2, ...}] is \
equivalent to Cases[{expr}, f1[___] | f2[___] ..., Infinity]//Union."\)], \
"Print",
  CellTags->"Info3266768320-9042538"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?CopyRemote\)\)], "Input",
  CellLabel->"In[84]:="],

Cell[BoxData[
    \("CopyRemote[\"http://...\", localfile] copies the remote file located \
at a URL to localfile. CopyRemote does work on Linux/Unix for .xls files, but \
on Windows it does not (yes, it is something with encoding, but I did not get \
it to work ...)."\)], "Print",
  CellTags->"Info3266768320-6765362"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?JoinWorkbook\)\)], "Input",
  CellLabel->"In[85]:="],

Cell[BoxData[
    \("JoinWorkbook[Workbook[wbinfo1][...], Workbook[wbinfo2][...], ...] \
concatenates   workbooks together. The resulting workbook gets the the \
information of the first Workbook, i.e., wbinfo2 etc. is discarded."\)], \
"Print",
  CellTags->"Info3266768320-9822919"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?OKBox\)\)], "Input",
  CellLabel->"In[86]:="],

Cell[BoxData[
    \("OKBox[text] or OKBox[text, moretext] is like an interrup function \
starting a Java \"OK/Cancel window\". Clicking on OK returns True, Cancel \
gives False."\)], "Print",
  CellTags->"Info3266768320-9772715"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reference Guide", "Subtitle"],

Cell["This is still in works ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Names["\<MathXLS`*\>"]]\)], "Input",
  CellLabel->"In[87]:="],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"BarColorTable\"\>"},
          {"\<\"BarSheet3D\"\>"},
          {"\<\"BlankCellSubstitution\"\>"},
          {"\<\"ButtonBackground\"\>"},
          {"\<\"CasesH\"\>"},
          {"\<\"Chomp\"\>"},
          {"\<\"ColorFun\"\>"},
          {"\<\"ColorTickCharacter\"\>"},
          {"\<\"ColumnLetterHeading\"\>"},
          {"\<\"Conversion\"\>"},
          {"\<\"ConvertByExcelFormatRules\"\>"},
          {"\<\"CopyRemote\"\>"},
          {"\<\"CornerFill\"\>"},
          {"\<\"Currency\"\>"},
          {"\<\"CurrencyObject\"\>"},
          {"\<\"DateCellMethod\"\>"},
          {"\<\"DateConversion\"\>"},
          {"\<\"DateList\"\>"},
          {"\<\"DateToString\"\>"},
          {"\<\"DB\"\>"},
          {"\<\"DebugPrint\"\>"},
          {"\<\"DefaultSheetNamePrefix\"\>"},
          {"\<\"DiscardEmptyColumns\"\>"},
          {"\<\"DiscardEmptyRows\"\>"},
          {"\<\"DiscardEmptySheets\"\>"},
          {"\<\"EnterPassword\"\>"},
          {"\<\"ExcelDateToMathematicaDate\"\>"},
          {"\<\"ExcelForm\"\>"},
          {"\<\"ExcelFormRules\"\>"},
          {"\<\"ExportAsRaster\"\>"},
          {"\<\"ExportDirectory\"\>"},
          {"\<\"ExportXLS\"\>"},
          {"\<\"FaceGridFraction\"\>"},
          {"\<\"FrontEndPrintFunction\"\>"},
          {"\<\"GeneralBarChart3D\"\>"},
          {"\<\"GeneralCellMethod\"\>"},
          {"\<\"GeneralToNumber\"\>"},
          {"\<\"GetXLS\"\>"},
          {"\<\"Help\"\>"},
          {"\<\"HideColumns\"\>"},
          {"\<\"HideRows\"\>"},
          {"\<\"HorizontalTickStart\"\>"},
          {"\<\"IgnoreRows\"\>"},
          {"\<\"ImportedWorkbook\"\>"},
          {"\<\"ImportXLS\"\>"},
          {"\<\"IncludeHiddenSheets\"\>"},
          {"\<\"JoinWorkbook\"\>"},
          {"\<\"KernelPrintFunction\"\>"},
          {"\<\"Legend2\"\>"},
          {"\<\"LegendText\"\>"},
          {"\<\"NormalizeWhiteSpace\"\>"},
          {"\<\"NullReplacement\"\>"},
          {"\<\"NumberCellMethod\"\>"},
          {"\<\"NumberColor\"\>"},
          {"\<\"NumberOfHorizontalTicks\"\>"},
          {"\<\"OKBox\"\>"},
          {"\<\"OptionSettings\"\>"},
          {"\<\"OverWrite\"\>"},
          {"\<\"PageOrientation\"\>"},
          {"\<\"PaperSize\"\>"},
          {"\<\"Percent\"\>"},
          {"\<\"PercentString\"\>"},
          {"\<\"PercentToNumber\"\>"},
          {"\<\"PlotData2D\"\>"},
          {"\<\"PlotData3D\"\>"},
          {"\<\"PlotLabelFunction\"\>"},
          {"\<\"PrintMargins\"\>"},
          {"\<\"ProxyHost\"\>"},
          {"\<\"ProxyPort\"\>"},
          {"\<\"ReadXLS\"\>"},
          {"\<\"Replacements\"\>"},
          {"\<\"SetLocale\"\>"},
          {"\<\"SetProtected\"\>"},
          {"\<\"SetScaleFactor\"\>"},
          {"\<\"SetSelected\"\>"},
          {"\<\"Sheet\"\>"},
          {"\<\"SheetName\"\>"},
          {"\<\"ShortXLS\"\>"},
          {"\<\"ShowSheetName\"\>"},
          {"\<\"SortXLS\"\>"},
          {"\<\"StringCutOff\"\>"},
          {"\<\"StringReplacements\"\>"},
          {"\<\"StringToNumber\"\>"},
          {"\<\"SubElement\"\>"},
          {"\<\"SubMatrix\"\>"},
          {"\<\"SubVector\"\>"},
          {"\<\"TickStringFunction\"\>"},
          {"\<\"ToData\"\>"},
          {"\<\"ToDateList\"\>"},
          {"\<\"ToList\"\>"},
          {"\<\"ToMatrix\"\>"},
          {"\<\"ToSeconds\"\>"},
          {"\<\"TotalTiming\"\>"},
          {"\<\"ToVector\"\>"},
          {"\<\"Workbook\"\>"},
          {"\<\"XLS2HTML\"\>"},
          {"\<\"XLSAlignment\"\>"},
          {"\<\"XLSBackgroundColor\"\>"},
          {"\<\"XLSBar3D\"\>"},
          {"\<\"XLSBold\"\>"},
          {"\<\"XLSBorder\"\>"},
          {"\<\"XLSBorderLineStyle\"\>"},
          {"\<\"XLSCell\"\>"},
          {"\<\"XLSCellEvaluate\"\>"},
          {"\<\"XLSColor\"\>"},
          {"\<\"XLSColumnWidth\"\>"},
          {"\<\"XLSFontName\"\>"},
          {"\<\"XLSForm\"\>"},
          {"\<\"XLSFormat\"\>"},
          {"\<\"XLSFormSheetInformation\"\>"},
          {"\<\"XLSInfo\"\>"},
          {"\<\"XLSItalic\"\>"},
          {"\<\"XLSListPlot\"\>"},
          {"\<\"XLSMean\"\>"},
          {"\<\"XLSPointSize\"\>"},
          {"\<\"XLSRowCollapse\"\>"},
          {"\<\"XLSRowHeight\"\>"},
          {"\<\"XLSSort\"\>"},
          {"\<\"XLSToData\"\>"},
          {"\<\"XLSUnderline\"\>"},
          {"\<\"$Debug\"\>"},
          {"\<\"$EmptyCell\"\>"},
          {"\<\"$ExampleFiles\"\>"},
          {"\<\"$ExampleNotebooks\"\>"},
          {"\<\"$ExcelColumnLabels\"\>"},
          {"\<\"$ExtraJavaArguments\"\>"},
          {"\<\"$InstalledDir\"\>"},
          {"\<\"$MathXLSDir\"\>"},
          {"\<\"$MathXLSPassword\"\>"},
          {"\<\"$MathXLSVersion\"\>"},
          {"\<\"$PlotDataImageSize\"\>"},
          {"\<\"$PlotLabelStyle\"\>"},
          {"\<\"$XLSColors\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"BarColorTable", "BarSheet3D", "BlankCellSubstitution", 
        "ButtonBackground", "CasesH", "Chomp", "ColorFun", 
        "ColorTickCharacter", "ColumnLetterHeading", "Conversion", 
        "ConvertByExcelFormatRules", "CopyRemote", "CornerFill", "Currency", 
        "CurrencyObject", "DateCellMethod", "DateConversion", "DateList", 
        "DateToString", "DB", "DebugPrint", "DefaultSheetNamePrefix", 
        "DiscardEmptyColumns", "DiscardEmptyRows", "DiscardEmptySheets", 
        "EnterPassword", "ExcelDateToMathematicaDate", "ExcelForm", 
        "ExcelFormRules", "ExportAsRaster", "ExportDirectory", "ExportXLS", 
        "FaceGridFraction", "FrontEndPrintFunction", "GeneralBarChart3D", 
        "GeneralCellMethod", "GeneralToNumber", "GetXLS", "Help", 
        "HideColumns", "HideRows", "HorizontalTickStart", "IgnoreRows", 
        "ImportedWorkbook", "ImportXLS", "IncludeHiddenSheets", 
        "JoinWorkbook", "KernelPrintFunction", "Legend2", "LegendText", 
        "NormalizeWhiteSpace", "NullReplacement", "NumberCellMethod", 
        "NumberColor", "NumberOfHorizontalTicks", "OKBox", "OptionSettings", 
        "OverWrite", "PageOrientation", "PaperSize", "Percent", 
        "PercentString", "PercentToNumber", "PlotData2D", "PlotData3D", 
        "PlotLabelFunction", "PrintMargins", "ProxyHost", "ProxyPort", 
        "ReadXLS", "Replacements", "SetLocale", "SetProtected", 
        "SetScaleFactor", "SetSelected", "Sheet", "SheetName", "ShortXLS", 
        "ShowSheetName", "SortXLS", "StringCutOff", "StringReplacements", 
        "StringToNumber", "SubElement", "SubMatrix", "SubVector", 
        "TickStringFunction", "ToData", "ToDateList", "ToList", "ToMatrix", 
        "ToSeconds", "TotalTiming", "ToVector", "Workbook", "XLS2HTML", 
        "XLSAlignment", "XLSBackgroundColor", "XLSBar3D", "XLSBold", 
        "XLSBorder", "XLSBorderLineStyle", "XLSCell", "XLSCellEvaluate", 
        "XLSColor", "XLSColumnWidth", "XLSFontName", "XLSForm", "XLSFormat", 
        "XLSFormSheetInformation", "XLSInfo", "XLSItalic", "XLSListPlot", 
        "XLSMean", "XLSPointSize", "XLSRowCollapse", "XLSRowHeight", 
        "XLSSort", "XLSToData", "XLSUnderline", "$Debug", "$EmptyCell", 
        "$ExampleFiles", "$ExampleNotebooks", "$ExcelColumnLabels", 
        "$ExtraJavaArguments", "$InstalledDir", "$MathXLSDir", 
        "$MathXLSPassword", "$MathXLSVersion", "$PlotDataImageSize", 
        "$PlotLabelStyle", "$XLSColors"}]]], "Output",
  CellLabel->"Out[87]//TableForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?$XLSColors\)\)], "Input",
  CellLabel->"In[88]:="],

Cell[BoxData[
    \("global list of possible colors."\)], "Print",
  CellTags->"Info3266768320-5921893"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?NumberCellMethod\)\)], "Input",
  CellLabel->"In[89]:="],

Cell[BoxData[
    \("NumberCellMethod is an option of ImportXLS. If set to 0: return the \
Excel formatted value as string.  If set to 1: return also the formatting \
information. If set to 2: return the number as saved by Excel internally. If \
set to 4: return the Excel formatted value directly as string (this might not \
always work, depending on the number format, however, it is rather fast in \
normal situations)."\)], "Print",
  CellTags->"Info3266768320-7406151"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?DateCellMethod\)\)], "Input",
  CellLabel->"In[90]:="],

Cell[BoxData[
    \("if set to 0: return the Excel (rounded) value as displayed. if set to \
1: return both. If set to 2: return just the underlying number as saved by \
Excel internally."\)], "Print",
  CellTags->"Info3266768320-6620335"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
WindowToolbars->"EditBar",
WindowSize->{996, 814},
WindowMargins->{{59, Automatic}, {Automatic, 144}},
"InsufficientVersionWarning" -> False,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "jlug:0.0.0.0"->{
    Cell[1776, 53, 145, 6, 110, "Title",
      CellTags->"jlug:0.0.0.0"]},
  "jlug:1.0.0.0"->{
    Cell[3437, 122, 2971, 63, 111, "Text",
      CellTags->"jlug:1.0.0.0"]},
  "Info3266768275-8756129"->{
    Cell[11145, 350, 1246, 17, 229, "Print",
      CellTags->"Info3266768275-8756129"]},
  "Info3266768276-3138273"->{
    Cell[19574, 549, 474, 7, 69, "Print",
      CellTags->"Info3266768276-3138273"]},
  "Info3266768277-6105909"->{
    Cell[39013, 1109, 243, 4, 37, "Print",
      CellTags->"Info3266768277-6105909"]},
  "Info3266768277-6042653"->{
    Cell[40419, 1148, 142, 3, 21, "Print",
      CellTags->"Info3266768277-6042653"]},
  "Info3266768277-1698582"->{
    Cell[40680, 1160, 474, 7, 69, "Print",
      CellTags->"Info3266768277-1698582"]},
  "2.  real fwd curve"->{
    Cell[50857, 1450, 89506, 2396, 440, "Output",
      CellTags->"2.  real fwd curve"],
    Cell[140878, 3872, 51533, 1393, 440, "Output",
      CellTags->"2.  real fwd curve"],
    Cell[193105, 5304, 51533, 1393, 440, "Output",
      CellTags->"2.  real fwd curve"]},
  "Info3266768305-9162676"->{
    Cell[244866, 6714, 135, 3, 21, "Print",
      CellTags->"Info3266768305-9162676"]},
  "Info3266768310-8377918"->{
    Cell[321753, 8863, 148, 3, 21, "Print",
      CellTags->"Info3266768310-8377918"]},
  "Info3266768319-6255447"->{
    Cell[329421, 9078, 347, 5, 53, "Print",
      CellTags->"Info3266768319-6255447"]},
  "Info3266768319-3032578"->{
    Cell[340757, 9413, 182, 3, 21, "Print",
      CellTags->"Info3266768319-3032578"]},
  "Info3266768319-2269429"->{
    Cell[341049, 9425, 477, 7, 69, "Print",
      CellTags->"Info3266768319-2269429"]},
  "Info3266768319-4901111"->{
    Cell[341637, 9441, 143, 3, 21, "Print",
      CellTags->"Info3266768319-4901111"]},
  "Info3266768319-4032595"->{
    Cell[341892, 9453, 315, 5, 37, "Print",
      CellTags->"Info3266768319-4032595"]},
  "Info3266768319-9455315"->{
    Cell[342319, 9467, 207, 3, 37, "Print",
      CellTags->"Info3266768319-9455315"]},
  "Info3266768319-2616931"->{
    Cell[342639, 9479, 162, 3, 21, "Print",
      CellTags->"Info3266768319-2616931"]},
  "Info3266768319-9156967"->{
    Cell[342989, 9496, 142, 3, 21, "Print",
      CellTags->"Info3266768319-9156967"]},
  "Info3266768319-3911076"->{
    Cell[344944, 9561, 97, 2, 21, "Print",
      CellTags->"Info3266768319-3911076"]},
  "Info3266768320-8924515"->{
    Cell[348890, 9664, 99, 2, 21, "Print",
      CellTags->"Info3266768320-8924515"]},
  "Info3266768320-2852013"->{
    Cell[352784, 9771, 143, 3, 21, "Print",
      CellTags->"Info3266768320-2852013"]},
  "Info3266768320-3791477"->{
    Cell[353044, 9783, 245, 4, 37, "Print",
      CellTags->"Info3266768320-3791477"]},
  "Info3266768320-3335663"->{
    Cell[353400, 9796, 182, 3, 21, "Print",
      CellTags->"Info3266768320-3335663"]},
  "Info3266768320-5677351"->{
    Cell[353693, 9808, 250, 4, 37, "Print",
      CellTags->"Info3266768320-5677351"]},
  "Info3266768320-1426080"->{
    Cell[354052, 9821, 174, 3, 21, "Print",
      CellTags->"Info3266768320-1426080"]},
  "Info3266768320-3035838"->{
    Cell[354340, 9833, 157, 3, 21, "Print",
      CellTags->"Info3266768320-3035838"]},
  "Info3266768320-4938912"->{
    Cell[354607, 9845, 152, 3, 21, "Print",
      CellTags->"Info3266768320-4938912"]},
  "Info3266768320-7042209"->{
    Cell[355192, 9870, 316, 5, 53, "Print",
      CellTags->"Info3266768320-7042209"]},
  "Info3266768320-7278372"->{
    Cell[358527, 9960, 135, 3, 21, "Print",
      CellTags->"Info3266768320-7278372"]},
  "Info3266768320-9042538"->{
    Cell[358771, 9972, 293, 5, 37, "Print",
      CellTags->"Info3266768320-9042538"]},
  "Info3266768320-6765362"->{
    Cell[359177, 9986, 320, 5, 37, "Print",
      CellTags->"Info3266768320-6765362"]},
  "Info3266768320-9822919"->{
    Cell[359612, 10000, 283, 5, 37, "Print",
      CellTags->"Info3266768320-9822919"]},
  "Info3266768320-9772715"->{
    Cell[360003, 10014, 229, 4, 37, "Print",
      CellTags->"Info3266768320-9772715"]},
  "Info3266768320-5921893"->{
    Cell[368107, 10218, 104, 2, 21, "Print",
      CellTags->"Info3266768320-5921893"]},
  "Info3266768320-7406151"->{
    Cell[368330, 10229, 474, 7, 69, "Print",
      CellTags->"Info3266768320-7406151"]},
  "Info3266768320-6620335"->{
    Cell[368921, 10245, 239, 4, 37, "Print",
      CellTags->"Info3266768320-6620335"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"jlug:0.0.0.0", 369952, 10274},
  {"jlug:1.0.0.0", 370047, 10277},
  {"Info3266768275-8756129", 370154, 10280},
  {"Info3266768276-3138273", 370273, 10283},
  {"Info3266768277-6105909", 370389, 10286},
  {"Info3266768277-6042653", 370506, 10289},
  {"Info3266768277-1698582", 370623, 10292},
  {"2.  real fwd curve", 370736, 10295},
  {"Info3266768305-9162676", 371036, 10302},
  {"Info3266768310-8377918", 371154, 10305},
  {"Info3266768319-6255447", 371272, 10308},
  {"Info3266768319-3032578", 371390, 10311},
  {"Info3266768319-2269429", 371508, 10314},
  {"Info3266768319-4901111", 371626, 10317},
  {"Info3266768319-4032595", 371744, 10320},
  {"Info3266768319-9455315", 371862, 10323},
  {"Info3266768319-2616931", 371980, 10326},
  {"Info3266768319-9156967", 372098, 10329},
  {"Info3266768319-3911076", 372216, 10332},
  {"Info3266768320-8924515", 372333, 10335},
  {"Info3266768320-2852013", 372450, 10338},
  {"Info3266768320-3791477", 372568, 10341},
  {"Info3266768320-3335663", 372686, 10344},
  {"Info3266768320-5677351", 372804, 10347},
  {"Info3266768320-1426080", 372922, 10350},
  {"Info3266768320-3035838", 373040, 10353},
  {"Info3266768320-4938912", 373158, 10356},
  {"Info3266768320-7042209", 373276, 10359},
  {"Info3266768320-7278372", 373394, 10362},
  {"Info3266768320-9042538", 373512, 10365},
  {"Info3266768320-6765362", 373630, 10368},
  {"Info3266768320-9822919", 373748, 10371},
  {"Info3266768320-9772715", 373867, 10374},
  {"Info3266768320-5921893", 373986, 10377},
  {"Info3266768320-7406151", 374105, 10380},
  {"Info3266768320-6620335", 374224, 10383}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 145, 6, 110, "Title",
  CellTags->"jlug:0.0.0.0"],

Cell[CellGroupData[{
Cell[1946, 63, 81, 2, 58, "Section"],
Cell[2030, 67, 245, 8, 72, InheritFromParent],
Cell[2278, 77, 341, 10, 72, "Text"],
Cell[2622, 89, 265, 7, 48, "Text"],
Cell[2890, 98, 62, 0, 24, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2989, 103, 32, 0, 64, "Subtitle"],
Cell[3024, 105, 61, 0, 24, "Text"],
Cell[3088, 107, 106, 3, 26, "Input",
  InitializationCell->True],
Cell[3197, 112, 194, 6, 24, "Text"],
Cell[3394, 120, 40, 0, 24, "Text"],
Cell[3437, 122, 2971, 63, 111, "Text",
  CellTags->"jlug:1.0.0.0"],
Cell[6411, 187, 107, 5, 30, "MathCaption"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6555, 197, 32, 0, 64, "Subtitle"],
Cell[6590, 199, 294, 7, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6921, 211, 44, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[6990, 215, 31, 0, 58, "Section"],
Cell[7024, 217, 1013, 20, 88, "Text"],
Cell[8040, 239, 134, 3, 24, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8223, 248, 45, 0, 64, "Subtitle"],
Cell[8271, 250, 34, 0, 24, "Text"],
Cell[8308, 252, 137, 3, 24, "Text"],

Cell[CellGroupData[{
Cell[8470, 259, 74, 2, 26, "Input"],
Cell[8547, 263, 228, 4, 37, "Output"]
}, Open  ]],
Cell[8790, 270, 263, 5, 40, "Text"],

Cell[CellGroupData[{
Cell[9078, 279, 71, 2, 26, "Input"],
Cell[9152, 283, 211, 4, 21, "Output"]
}, Open  ]],
Cell[9378, 290, 134, 4, 28, "Input"],
Cell[9515, 296, 67, 0, 24, "Text"],
Cell[9585, 298, 50, 1, 28, "Input"],

Cell[CellGroupData[{
Cell[9660, 303, 35, 0, 41, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[9720, 307, 71, 2, 26, "Input"],
Cell[9794, 311, 211, 4, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10042, 320, 97, 2, 26, "Input"],
Cell[10142, 324, 891, 17, 155, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11070, 346, 72, 2, 26, "Input"],
Cell[11145, 350, 1246, 17, 229, "Print",
  CellTags->"Info3266768275-8756129"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12428, 372, 83, 2, 26, "Input"],
Cell[12514, 376, 5615, 133, 422, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18166, 514, 130, 3, 26, "Input"],
Cell[18299, 519, 1156, 21, 189, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19492, 545, 79, 2, 26, "Input"],
Cell[19574, 549, 474, 7, 69, "Print",
  CellTags->"Info3266768276-3138273"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20085, 561, 159, 3, 26, "Input"],
Cell[20247, 566, 1329, 23, 206, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21613, 594, 159, 3, 26, "Input"],
Cell[21775, 599, 1329, 23, 206, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23141, 627, 443, 8, 42, "Input"],
Cell[23587, 637, 783, 15, 138, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24407, 657, 70, 2, 26, "Input"],
Cell[24480, 661, 14355, 434, 561, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38884, 1101, 32, 0, 41, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[38941, 1105, 69, 2, 26, "Input"],
Cell[39013, 1109, 243, 4, 37, "Print",
  CellTags->"Info3266768277-6105909"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39293, 1118, 94, 2, 26, "Input"],
Cell[39390, 1122, 912, 17, 155, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40339, 1144, 77, 2, 26, "Input"],
Cell[40419, 1148, 142, 3, 21, "Print",
  CellTags->"Info3266768277-6042653"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40598, 1156, 79, 2, 26, "Input"],
Cell[40680, 1160, 474, 7, 69, "Print",
  CellTags->"Info3266768277-1698582"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41191, 1172, 80, 2, 26, "Input"],
Cell[41274, 1176, 5615, 133, 422, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46926, 1314, 94, 2, 26, "Input"],
Cell[47023, 1318, 912, 17, 155, "Output"]
}, Open  ]],
Cell[47950, 1338, 63, 0, 24, "Text"],

Cell[CellGroupData[{
Cell[48038, 1342, 145, 4, 26, "Input"],
Cell[48186, 1348, 66, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48289, 1355, 108, 2, 26, "Input"],
Cell[48400, 1359, 79, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48516, 1366, 94, 2, 26, "Input"],
Cell[48613, 1370, 201, 4, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48851, 1379, 72, 2, 26, "Input"],
Cell[48926, 1383, 60, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49023, 1390, 76, 2, 26, "Input"],
Cell[49102, 1394, 965, 17, 101, "Output"]
}, Open  ]],
Cell[50082, 1414, 155, 4, 26, "Input"],

Cell[CellGroupData[{
Cell[50262, 1422, 69, 2, 26, "Input"],
Cell[50334, 1426, 274, 6, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50645, 1437, 51, 1, 28, "Input"],
Cell[50699, 1440, 60, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50796, 1447, 58, 1, 28, "Input"],
Cell[50857, 1450, 89506, 2396, 440, "Output",
  CellTags->"2.  real fwd curve"]
}, Open  ]],
Cell[140378, 3849, 171, 4, 24, "Text"],

Cell[CellGroupData[{
Cell[140574, 3857, 114, 2, 26, "Input"],
Cell[140691, 3861, 78, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[140806, 3868, 69, 2, 26, "Input"],
Cell[140878, 3872, 51533, 1393, 440, "Output",
  CellTags->"2.  real fwd curve"],
Cell[192414, 5267, 65, 2, 21, "Output"]
}, Open  ]],
Cell[192494, 5272, 100, 3, 24, "Text"],

Cell[CellGroupData[{
Cell[192619, 5279, 77, 2, 26, "Input"],
Cell[192699, 5283, 79, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[192815, 5290, 116, 2, 26, "Input"],
Cell[192934, 5294, 78, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[193049, 5301, 53, 1, 28, "Input"],
Cell[193105, 5304, 51533, 1393, 440, "Output",
  CellTags->"2.  real fwd curve"],
Cell[244641, 6699, 65, 2, 21, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[244755, 6707, 33, 0, 41, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[244813, 6711, 50, 1, 28, "Input"],
Cell[244866, 6714, 135, 3, 21, "Print",
  CellTags->"Info3266768305-9162676"]
}, Open  ]],
Cell[245016, 6720, 62, 0, 24, "Text"],
Cell[245081, 6722, 77, 1, 28, "Input"],

Cell[CellGroupData[{
Cell[245183, 6727, 52, 1, 28, "Input"],
Cell[245238, 6730, 63, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[245338, 6737, 58, 1, 28, "Input"],
Cell[245399, 6740, 68, 2, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[245504, 6747, 62, 1, 28, "Input"],
Cell[245569, 6750, 75978, 2098, 237, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[321608, 8855, 45, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[321678, 8859, 72, 2, 26, "Input"],
Cell[321753, 8863, 148, 3, 21, "Print",
  CellTags->"Info3266768310-8377918"]
}, Open  ]],

Cell[CellGroupData[{
Cell[321938, 8871, 83, 2, 26, "Input"],
Cell[322024, 8875, 6204, 149, 478, "Output"]
}, Open  ]],
Cell[328243, 9027, 84, 1, 28, "Input"],
Cell[328330, 9030, 96, 1, 28, "Input"],
Cell[328429, 9033, 128, 4, 45, "Input"],
Cell[328560, 9039, 66, 0, 24, "Text"],

Cell[CellGroupData[{
Cell[328651, 9043, 89, 1, 28, "Input"],
Cell[328743, 9046, 173, 4, 21, "Print"]
}, Open  ]],
Cell[328931, 9053, 61, 1, 28, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[329029, 9059, 59, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[329113, 9063, 35, 0, 41, "SubsectionIcon"],
Cell[329151, 9065, 170, 5, 24, "Text"],

Cell[CellGroupData[{
Cell[329346, 9074, 72, 2, 26, "Input"],
Cell[329421, 9078, 347, 5, 53, "Print",
  CellTags->"Info3266768319-6255447"]
}, Open  ]],

Cell[CellGroupData[{
Cell[329805, 9088, 134, 3, 26, "Input"],
Cell[329942, 9093, 2065, 63, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[332044, 9161, 83, 2, 26, "Input"],
Cell[332130, 9165, 3334, 83, 232, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[335501, 9253, 208, 4, 26, "Input"],
Cell[335712, 9259, 2757, 81, 77, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[338518, 9346, 33, 0, 41, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[338576, 9350, 81, 2, 26, "Input"],
Cell[338660, 9354, 1987, 50, 118, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[340684, 9409, 70, 2, 26, "Input"],
Cell[340757, 9413, 182, 3, 21, "Print",
  CellTags->"Info3266768319-3032578"]
}, Open  ]],

Cell[CellGroupData[{
Cell[340976, 9421, 70, 2, 26, "Input"],
Cell[341049, 9425, 477, 7, 69, "Print",
  CellTags->"Info3266768319-2269429"]
}, Open  ]],

Cell[CellGroupData[{
Cell[341563, 9437, 71, 2, 26, "Input"],
Cell[341637, 9441, 143, 3, 21, "Print",
  CellTags->"Info3266768319-4901111"]
}, Open  ]],

Cell[CellGroupData[{
Cell[341817, 9449, 72, 2, 26, "Input"],
Cell[341892, 9453, 315, 5, 37, "Print",
  CellTags->"Info3266768319-4032595"]
}, Open  ]],

Cell[CellGroupData[{
Cell[342244, 9463, 72, 2, 26, "Input"],
Cell[342319, 9467, 207, 3, 37, "Print",
  CellTags->"Info3266768319-9455315"]
}, Open  ]],

Cell[CellGroupData[{
Cell[342563, 9475, 73, 2, 26, "Input"],
Cell[342639, 9479, 162, 3, 21, "Print",
  CellTags->"Info3266768319-2616931"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[342850, 9488, 37, 0, 41, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[342912, 9492, 74, 2, 26, "Input"],
Cell[342989, 9496, 142, 3, 21, "Print",
  CellTags->"Info3266768319-9156967"]
}, Open  ]],

Cell[CellGroupData[{
Cell[343168, 9504, 85, 2, 26, "Input"],
Cell[343256, 9508, 1475, 38, 98, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[344792, 9553, 51, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[344868, 9557, 73, 2, 26, "Input"],
Cell[344944, 9561, 97, 2, 21, "Print",
  CellTags->"Info3266768319-3911076"]
}, Open  ]],

Cell[CellGroupData[{
Cell[345078, 9568, 84, 2, 26, "Input"],
Cell[345165, 9572, 3612, 83, 174, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[348814, 9660, 73, 2, 26, "Input"],
Cell[348890, 9664, 99, 2, 21, "Print",
  CellTags->"Info3266768320-8924515"]
}, Open  ]],

Cell[CellGroupData[{
Cell[349026, 9671, 84, 2, 26, "Input"],
Cell[349113, 9675, 3560, 87, 222, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[352710, 9767, 71, 2, 26, "Input"],
Cell[352784, 9771, 143, 3, 21, "Print",
  CellTags->"Info3266768320-2852013"]
}, Open  ]],

Cell[CellGroupData[{
Cell[352964, 9779, 77, 2, 26, "Input"],
Cell[353044, 9783, 245, 4, 37, "Print",
  CellTags->"Info3266768320-3791477"]
}, Open  ]],

Cell[CellGroupData[{
Cell[353326, 9792, 71, 2, 26, "Input"],
Cell[353400, 9796, 182, 3, 21, "Print",
  CellTags->"Info3266768320-3335663"]
}, Open  ]],

Cell[CellGroupData[{
Cell[353619, 9804, 71, 2, 26, "Input"],
Cell[353693, 9808, 250, 4, 37, "Print",
  CellTags->"Info3266768320-5677351"]
}, Open  ]],

Cell[CellGroupData[{
Cell[353980, 9817, 69, 2, 26, "Input"],
Cell[354052, 9821, 174, 3, 21, "Print",
  CellTags->"Info3266768320-1426080"]
}, Open  ]],

Cell[CellGroupData[{
Cell[354263, 9829, 74, 2, 26, "Input"],
Cell[354340, 9833, 157, 3, 21, "Print",
  CellTags->"Info3266768320-3035838"]
}, Open  ]],

Cell[CellGroupData[{
Cell[354534, 9841, 70, 2, 26, "Input"],
Cell[354607, 9845, 152, 3, 21, "Print",
  CellTags->"Info3266768320-4938912"]
}, Open  ]],

Cell[CellGroupData[{
Cell[354796, 9853, 71, 2, 26, "Input"],
Cell[354870, 9857, 211, 4, 21, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[355118, 9866, 71, 2, 26, "Input"],
Cell[355192, 9870, 316, 5, 53, "Print",
  CellTags->"Info3266768320-7042209"]
}, Open  ]],

Cell[CellGroupData[{
Cell[355545, 9880, 81, 2, 26, "Input"],
Cell[355629, 9884, 2790, 67, 174, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[358456, 9956, 68, 2, 26, "Input"],
Cell[358527, 9960, 135, 3, 21, "Print",
  CellTags->"Info3266768320-7278372"]
}, Open  ]],

Cell[CellGroupData[{
Cell[358699, 9968, 69, 2, 26, "Input"],
Cell[358771, 9972, 293, 5, 37, "Print",
  CellTags->"Info3266768320-9042538"]
}, Open  ]],

Cell[CellGroupData[{
Cell[359101, 9982, 73, 2, 26, "Input"],
Cell[359177, 9986, 320, 5, 37, "Print",
  CellTags->"Info3266768320-6765362"]
}, Open  ]],

Cell[CellGroupData[{
Cell[359534, 9996, 75, 2, 26, "Input"],
Cell[359612, 10000, 283, 5, 37, "Print",
  CellTags->"Info3266768320-9822919"]
}, Open  ]],

Cell[CellGroupData[{
Cell[359932, 10010, 68, 2, 26, "Input"],
Cell[360003, 10014, 229, 4, 37, "Print",
  CellTags->"Info3266768320-9772715"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[360281, 10024, 35, 0, 64, "Subtitle"],
Cell[360319, 10026, 42, 0, 24, "Text"],

Cell[CellGroupData[{
Cell[360386, 10030, 91, 2, 26, "Input"],
Cell[360480, 10034, 7514, 175, 2410, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368031, 10214, 73, 2, 26, "Input"],
Cell[368107, 10218, 104, 2, 21, "Print",
  CellTags->"Info3266768320-5921893"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368248, 10225, 79, 2, 26, "Input"],
Cell[368330, 10229, 474, 7, 69, "Print",
  CellTags->"Info3266768320-7406151"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368841, 10241, 77, 2, 26, "Input"],
Cell[368921, 10245, 239, 4, 37, "Print",
  CellTags->"Info3266768320-6620335"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

