/*
 * Decompiled with CFR 0.152.
 */
package mxls.write;

import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class M2XLS {
    public static void WriteIntegerMatrix(WritableSheet s, int[][] mat, CellFormat cellf, int rowdim, int coldim, int rowstart, int colstart, int[] columnwidth, int[] rowheight) throws RowsExceededException, WriteException {
        int i = 0;
        while (i < rowdim) {
            s.setRowView(i + rowstart - 1, rowheight[i]);
            int j = 0;
            while (j < coldim) {
                s.setColumnView(j, columnwidth[j]);
                Number n = new Number(j + colstart - 1, i + rowstart - 1, (double)mat[i][j], cellf);
                s.addCell(n);
                ++j;
            }
            ++i;
        }
    }

    public static void WriteRealMatrix(WritableSheet s, double[][] mat, CellFormat cellf, int rowdim, int coldim, int rowstart, int colstart, int[] columnwidth, int[] rowheight) throws RowsExceededException, WriteException {
        int i = 0;
        while (i < rowdim) {
            s.setRowView(i + rowstart - 1, rowheight[i]);
            int j = 0;
            while (j < coldim) {
                s.setColumnView(j, columnwidth[j]);
                Number n = new Number(j + colstart - 1, i + rowstart - 1, mat[i][j], cellf);
                s.addCell(n);
                ++j;
            }
            ++i;
        }
    }

    public static void WriteStringMatrix(WritableSheet s, String[][] mat, CellFormat cellf, int rowdim, int coldim, int rowstart, int colstart, int[] columnwidth, int[] rowheight) throws RowsExceededException, WriteException {
        int i = 0;
        while (i < rowdim) {
            s.setRowView(i + rowstart - 1, rowheight[i]);
            int j = 0;
            while (j < coldim) {
                s.setColumnView(j + colstart - 1, columnwidth[j]);
                Label n = new Label(j + colstart - 1, i + rowstart - 1, mat[i][j], cellf);
                s.addCell(n);
                ++j;
            }
            ++i;
        }
    }

    public static void WriteCellularMatrix(WritableSheet s, int[][] mat, CellFormat cellf, CellFormat bg, int rowdim, int coldim, int rowstart, int colstart, int[] columnwidth, int[] rowheight) throws RowsExceededException, WriteException {
        int i = 0;
        while (i < rowdim) {
            s.setRowView(i + rowstart - 1, rowheight[i]);
            int j = 0;
            while (j < coldim) {
                s.setColumnView(j + colstart - 1, columnwidth[j]);
                Label n = mat[i][j] == 0 ? new Label(j + colstart - 1, i + rowstart - 1, "", cellf) : new Label(j + colstart - 1, i + rowstart - 1, "", bg);
                s.addCell(n);
                ++j;
            }
            ++i;
        }
    }
}

