/*
 * Decompiled with CFR 0.152.
 */
package mxls.read;

import java.util.ArrayList;
import java.util.Date;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.FormulaCell;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;

public class XLS2M {
    public static String[] ReadWorkbook(Workbook w, boolean includehiddensheets, int numbermethod, int generalmethod, int datemethod, int stringformulamethod, int numberformulamethod, int cellformatmethod) throws FormulaException {
        double celldouble = 0.0;
        Object format = null;
        Sheet[] shs = w.getSheets();
        int numofs = w.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>();
        int[] all = new int[]{0, 0};
        int sheet = 0;
        while (sheet < w.getNumberOfSheets()) {
            Sheet s = shs[sheet];
            boolean hidden = s.isHidden();
            if (includehiddensheets || !hidden) {
                result.add(XLS2M.ReadSheet(s, all, all, numbermethod, generalmethod, datemethod, stringformulamethod, numberformulamethod, cellformatmethod));
            }
            ++sheet;
        }
        return result.toArray(new String[0]);
    }

    public static String ReadSheet(Sheet sh, int[] rowlimits, int[] columnlimits, int numbermethod, int generalmethod, int datemethod, int stringformulamethod, int numberformulamethod, int cellformatmethod) throws FormulaException {
        boolean hid = sh.isHidden();
        double celldouble = 0.0;
        boolean comments = false;
        StringBuffer buf = new StringBuffer(40000);
        buf.append("Sheet[" + XLS2M.quote(sh.getName()));
        if (hid) {
            buf.append(", Hidden");
        }
        buf.append("][\n");
        Cell[] row = null;
        int numofrows = sh.getRows();
        int numofcols = sh.getColumns();
        int rowstart = rowlimits[1] > numofrows || rowlimits[0] < 1 ? 0 : rowlimits[0] - 1;
        int rowend = rowlimits[1] > numofrows || rowlimits[1] < 1 ? numofrows - 1 : rowlimits[1] - 1;
        int columnstart = columnlimits[0] < 1 ? 0 : columnlimits[0] - 1;
        int columnend = columnlimits[1] > numofcols || columnlimits[1] < 1 ? numofcols - 1 : columnlimits[1] - 1;
        int i = rowstart;
        while (i <= rowend) {
            buf.append("{");
            row = sh.getRow(i);
            int coli = row.length;
            int j = columnstart;
            while (j <= columnend) {
                if (j >= coli) {
                    buf.append("$EmptyCell");
                } else {
                    NumberCell nc;
                    CellType celltype;
                    CellFormat format = row[j].getCellFormat();
                    if (comments) {
                        buf.append("(* " + (i + 1) + " " + (j + 1) + " *) ");
                    }
                    if ((celltype = row[j].getType()) == CellType.EMPTY) {
                        buf.append("$EmptyCell");
                    } else if (celltype == CellType.NUMBER) {
                        if (numbermethod == 0) {
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())));
                        } else if (numbermethod == 1) {
                            nc = (NumberCell)row[j];
                            celldouble = nc.getValue();
                            buf.append("XLSCell[\"NUMBER\", ");
                            buf.append(XLS2M.quote(format.getFormat().getFormatString()));
                            buf.append(", {");
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())));
                            buf.append(" , ");
                            buf.append(XLS2M.meform(String.valueOf(celldouble)));
                            buf.append("}");
                            if (cellformatmethod > 0) {
                                buf.append(XLS2M.getcellformatinfo(row[j].getCellFormat()));
                            }
                            buf.append("]");
                        } else if (numbermethod == 2) {
                            nc = (NumberCell)row[j];
                            celldouble = nc.getValue();
                            buf.append(XLS2M.meform(String.valueOf(celldouble)));
                        } else if (numbermethod == 3) {
                            buf.append("XLSCell[\"NUMBER\", " + XLS2M.quote(format.getFormat().getFormatString()) + ", ");
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())) + "]");
                        } else if (numbermethod == 4) {
                            buf.append(XLS2M.mmanumform(row[j].getContents()));
                        }
                    } else if (celltype == CellType.DATE) {
                        boolean istime;
                        Date cellvalue;
                        DateCell dc;
                        if (datemethod == 0) {
                            buf.append(XLS2M.quote(row[j].getContents()));
                        } else if (datemethod == 1) {
                            dc = (DateCell)row[j];
                            cellvalue = dc.getDate();
                            istime = dc.isTime();
                            buf.append("XLSCell[\"DATE\",  \"" + format.getFormat().getFormatString() + "\", ");
                            buf.append(XLS2M.quote(String.valueOf(cellvalue.getTime() / 1000L)) + ", ");
                            if (istime) {
                                buf.append("True, ");
                            } else {
                                buf.append("False, ");
                            }
                            buf.append(XLS2M.quote(row[j].getContents()) + "]");
                        } else if (datemethod == 2) {
                            dc = (DateCell)row[j];
                            cellvalue = dc.getDate();
                            istime = dc.isTime();
                            buf.append(XLS2M.quote(String.valueOf(cellvalue.getTime() / 1000L)));
                        }
                    } else if (celltype == CellType.LABEL) {
                        if (generalmethod == 0) {
                            buf.append(XLS2M.quote(row[j].getContents()));
                        } else if (generalmethod == 2) {
                            buf.append(XLS2M.quote(row[j].getContents()));
                        } else {
                            buf.append("XLSCell[\"GENERAL\",  \"" + format.getFormat().getFormatString() + "\", ");
                            buf.append(XLS2M.quote(row[j].getContents()));
                            if (cellformatmethod > 0) {
                                buf.append(XLS2M.getcellformatinfo(row[j].getCellFormat()));
                            }
                            buf.append("]");
                        }
                    } else if (celltype == CellType.BOOLEAN) {
                        if (row[j].getContents() == "true") {
                            buf.append("True");
                        } else if (row[j].getContents() == "false") {
                            buf.append("False");
                        } else {
                            buf.append(row[j].getContents());
                        }
                    } else if (celltype == CellType.STRING_FORMULA) {
                        if (stringformulamethod == 0) {
                            buf.append(XLS2M.quote(row[j].getContents()));
                        } else if (stringformulamethod == 1) {
                            buf.append("XLSCell[\"GENERAL\",  \"" + format.getFormat().getFormatString() + "\", ");
                            buf.append(XLS2M.quote(row[j].getContents()) + "]");
                        } else {
                            FormulaCell fcell = (FormulaCell)row[j];
                            buf.append("XLSCell[\"STRING_FORMULA\",  \"" + fcell.getFormula() + "\", ");
                            buf.append(XLS2M.quote(row[j].getContents()) + "]");
                        }
                    } else if (celltype == CellType.NUMBER_FORMULA) {
                        if (numbermethod == 0) {
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())));
                        } else if (numbermethod == 1) {
                            nc = (NumberFormulaCell)row[j];
                            celldouble = nc.getValue();
                            buf.append("XLSCell[\"NUMBER_FORMULA\", ");
                            buf.append(XLS2M.quote(format.getFormat().getFormatString()));
                            buf.append(", {");
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())));
                            buf.append(" , ");
                            buf.append(XLS2M.meform(String.valueOf(celldouble)));
                            buf.append("}");
                            if (cellformatmethod > 0) {
                                buf.append(XLS2M.getcellformatinfo(row[j].getCellFormat()));
                            }
                            buf.append("]");
                        } else if (numbermethod == 2) {
                            nc = (NumberFormulaCell)row[j];
                            celldouble = nc.getValue();
                            buf.append(XLS2M.meform(String.valueOf(celldouble)));
                        } else {
                            buf.append("XLSCell[\"NUMBER_FORMULA\", " + XLS2M.quote(format.getFormat().getFormatString()) + ", ");
                            buf.append(XLS2M.quote(XLS2M.meform(row[j].getContents())) + "]");
                        }
                    }
                }
                if (j < columnend) {
                    buf.append(", \n");
                }
                ++j;
            }
            buf.append("}");
            if (i < rowend) {
                buf.append(",\n");
            }
            ++i;
        }
        buf.append("] (* </sheet> *)");
        buf.append("\n");
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\t', '\"'};
        String[] charsReplace = new String[]{"\\\\", "\\t", "\\\""};
        int i = 0;
        while (i < charsFind.length) {
            if (string.indexOf(charsFind[i]) != -1) {
                int index;
                StringBuffer newStringBuffer = new StringBuffer();
                while ((index = string.indexOf(charsFind[i])) != -1) {
                    void var1_4;
                    if (var1_4 > 0) {
                        newStringBuffer.append(string.substring(0, (int)var1_4));
                    }
                    newStringBuffer.append(charsReplace[i]);
                    string = var1_4 + true < string.length() ? string.substring((int)(var1_4 + true)) : "";
                }
                newStringBuffer.append(string);
                string = newStringBuffer.toString();
            }
            ++i;
        }
        return XLS2M.convertNewLines(string);
    }

    public static String getcellformatinfo(CellFormat cellfo) {
        String scriptstyle;
        String fontname;
        int pointsize;
        boolean ital;
        int bold;
        String color;
        String backcolor;
        StringBuffer cfstring = new StringBuffer();
        String alignment = cellfo.getAlignment().getDescription();
        if (alignment != "general") {
            cfstring.append(", XLSAlignment->{" + cellfo.getAlignment().getDescription() + "," + cellfo.getAlignment().getValue() + "} ");
        }
        if ((backcolor = cellfo.getBackgroundColour().getDescription()) != "default background") {
            cfstring.append(", XLSBackgroundColor->{\"" + cellfo.getBackgroundColour().getDescription() + "\"," + cellfo.getBackgroundColour().getValue() + "} ");
        }
        if ((color = cellfo.getFont().getColour().getDescription()) != "black") {
            cfstring.append(", XLSColor->\"" + color + "\"");
        }
        if ((bold = cellfo.getFont().getBoldWeight()) != 400) {
            cfstring.append(", XLSBold->\"True\"");
        }
        if (ital = cellfo.getFont().isItalic()) {
            cfstring.append(",XLSItalic->\"True\"");
        }
        if ((pointsize = cellfo.getFont().getPointSize()) != 10) {
            cfstring.append(",XLSPointSize->" + pointsize);
        }
        if ((fontname = cellfo.getFont().getName()).intern() != "Arial") {
            cfstring.append(",XLSFontName->\"" + fontname + "\"");
        }
        if ((scriptstyle = cellfo.getFont().getScriptStyle().getDescription()) != "normal") {
            int scriptval = cellfo.getFont().getScriptStyle().getValue();
            cfstring.append(",XLSScriptStyle->{\"" + scriptstyle + "\", " + scriptval + "}");
        }
        return cfstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            void var1_2;
            if (var1_2 > 0) {
                newStringBuffer.append(string.substring(0, (int)var1_2));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            string = var1_2 + true < string.length() ? string.substring((int)(var1_2 + true)) : "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            string = index + 1 < string.length() ? string.substring(index + 1) : "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String quote(String string) {
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1) {
            string = XLS2M.backQuoteChars(string);
        }
        string = "\"".concat(string).concat("\"");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String meform(String string) {
        String vers = System.getProperty("java.specification.version");
        if (vers.equals("1.3")) {
            char[] charsFind = new char[]{'E'};
            String[] charsReplace = new String[]{"*^"};
            int i = 0;
            while (i < charsFind.length) {
                if (string.indexOf(charsFind[i]) != -1) {
                    int index;
                    StringBuffer newStringBuffer = new StringBuffer();
                    while ((index = string.indexOf(charsFind[i])) != -1) {
                        void var2_5;
                        if (var2_5 > 0) {
                            newStringBuffer.append(string.substring(0, (int)var2_5));
                        }
                        newStringBuffer.append(charsReplace[i]);
                        string = var2_5 + true < string.length() ? string.substring((int)(var2_5 + true)) : "";
                    }
                    newStringBuffer.append(string);
                    string = newStringBuffer.toString();
                }
                ++i;
            }
        } else {
            string = string.replaceFirst("E", "*^");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String mmanumform(String string) {
        String vers = System.getProperty("java.specification.version");
        if (vers.equals("1.3")) {
            char[] charsFind = new char[]{'E', ',', ' ', '%'};
            String[] charsReplace = new String[]{"*^", "", "", "Percent"};
            int i = 0;
            while (i < charsFind.length) {
                if (string.indexOf(charsFind[i]) != -1) {
                    int index;
                    StringBuffer newStringBuffer = new StringBuffer();
                    while ((index = string.indexOf(charsFind[i])) != -1) {
                        void var2_5;
                        if (var2_5 > 0) {
                            newStringBuffer.append(string.substring(0, (int)var2_5));
                        }
                        newStringBuffer.append(charsReplace[i]);
                        string = var2_5 + true < string.length() ? string.substring((int)(var2_5 + true)) : "";
                    }
                    newStringBuffer.append(string);
                    string = newStringBuffer.toString();
                }
                ++i;
            }
        } else {
            string = string.replaceAll("E", "*^");
            string = string.replaceAll(",", "");
            string = string.replaceAll(" ", "");
            string = string.replaceAll("%", "Percent");
        }
        return string;
    }
}

