/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.CellType;
import jxl.biff.FormulaData;
import jxl.biff.Type;
import jxl.biff.formula.FormulaException;
import jxl.write.biff.CellValue;

class ReadFormulaRecord
extends CellValue
implements FormulaData {
    private FormulaData formula;

    public ReadFormulaRecord(FormulaData f) {
        super(Type.FORMULA, f);
        this.formula = f;
    }

    public byte[] getData() {
        try {
            byte[] celldata = super.getData();
            byte[] formuladata = this.formula.getFormulaData();
            formuladata[8] = (byte)(formuladata[8] | 2);
            byte[] data = new byte[celldata.length + formuladata.length];
            System.arraycopy(celldata, 0, data, 0, celldata.length);
            System.arraycopy(formuladata, 0, data, celldata.length, formuladata.length);
            return data;
        }
        catch (FormulaException e) {
            Assert.verify(false);
            return new byte[0];
        }
    }

    public CellType getType() {
        return this.formula.getType();
    }

    public String getContents() {
        return this.formula.getContents();
    }

    public byte[] getFormulaData() throws FormulaException {
        byte[] d = this.formula.getFormulaData();
        byte[] data = new byte[d.length - 6];
        System.arraycopy(d, 6, data, 0, d.length - 6);
        data[8] = (byte)(data[8] | 2);
        return data;
    }
}

