/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.biff.IntegerHelper;
import jxl.biff.SheetRangeImpl;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;

public class MergedCellsRecord
extends WritableRecordData {
    private ArrayList ranges = new ArrayList();
    private WritableSheet sheet;

    protected MergedCellsRecord(jxl.read.biff.MergedCellsRecord mc, WritableSheet ws) {
        super(Type.MERGEDCELLS);
        Range[] rgs = mc.getRanges();
        for (int i = 0; i < rgs.length; ++i) {
            this.ranges.add(rgs[i]);
        }
    }

    protected MergedCellsRecord(WritableSheet ws) {
        super(Type.MERGEDCELLS);
        this.sheet = ws;
    }

    void add(Range r) {
        Iterator i = this.ranges.iterator();
        SheetRangeImpl r1 = (SheetRangeImpl)r;
        SheetRangeImpl range = null;
        boolean intersects = false;
        while (i.hasNext() && !intersects) {
            range = (SheetRangeImpl)i.next();
            if (!range.intersects(r1)) continue;
            System.err.println("Warning:  could not merge cells " + r + " as they clash with an existing set of merged " + " cells");
            intersects = true;
        }
        if (!intersects) {
            this.ranges.add(r);
        }
    }

    public byte[] getData() {
        this.checkRanges();
        byte[] data = new byte[this.ranges.size() * 8 + 2];
        IntegerHelper.getTwoBytes(this.ranges.size(), data, 0);
        int pos = 2;
        Range range = null;
        for (int i = 0; i < this.ranges.size(); ++i) {
            range = (Range)this.ranges.get(i);
            Cell tl = range.getTopLeft();
            Cell br = range.getBottomRight();
            IntegerHelper.getTwoBytes(tl.getRow(), data, pos);
            IntegerHelper.getTwoBytes(br.getRow(), data, pos + 2);
            IntegerHelper.getTwoBytes(tl.getColumn(), data, pos + 4);
            IntegerHelper.getTwoBytes(br.getColumn(), data, pos + 6);
            pos += 8;
        }
        return data;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl range = null;
            for (int i = 0; i < this.ranges.size(); ++i) {
                range = (SheetRangeImpl)this.ranges.get(i);
                Cell tl = range.getTopLeft();
                Cell br = range.getBottomRight();
                boolean found = false;
                for (int c = tl.getColumn(); c <= br.getColumn(); ++c) {
                    for (int r = tl.getRow(); r <= br.getRow(); ++r) {
                        Cell cell = this.sheet.getCell(c, r);
                        if (cell.getType() == CellType.EMPTY) continue;
                        if (!found) {
                            found = true;
                            continue;
                        }
                        System.err.println("Warning:  range " + range + " contains more than one data cell.  " + "Setting the other cells to blank");
                        Blank b = new Blank(c, r);
                        this.sheet.addCell(b);
                    }
                }
            }
        }
        catch (WriteException e) {
            Assert.verify(false);
        }
    }
}

