/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.File;
import java.io.FileInputStream;
import jxl.JXLException;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableCompoundRecordData;
import jxl.biff.WritableRecordData;
import jxl.write.biff.ImDataRecord;
import jxl.write.biff.ObjRecord;
import jxl.write.biff.WritableSheetImpl;

public class ImageCompoundRecord
extends WritableCompoundRecordData {
    private ImDataRecord imgRec = null;
    private ObjRecord objRec = null;
    private int col;
    private int row;
    private int x;
    private int y;
    private int colEnd;
    private int rowEnd;
    private double xScale;
    private double yScale;
    private int width;
    private int height;
    private int size;
    private File imgFile;
    WritableSheetImpl sheet = null;
    boolean referenced = false;

    protected WritableRecordData getPart1() {
        this.positionImage();
        return this.objRec;
    }

    protected WritableRecordData getPart2() {
        this.referenced = false;
        this.sheet = null;
        return this.imgRec;
    }

    public void setSheet(WritableSheetImpl s) {
        if (!this.referenced) {
            this.sheet = s;
        }
        this.referenced = true;
    }

    public boolean isReferenced() {
        return this.referenced;
    }

    public ImageCompoundRecord(int col, int row, int x, int y, double xScale, double yScale, File img) throws JXLException {
        this.col = col;
        this.row = row;
        this.x = x;
        this.y = y;
        this.xScale = xScale;
        this.yScale = yScale;
        this.imgFile = img;
        this.processBitmap();
        this.width = (int)((double)this.width * xScale);
        this.height = (int)((double)this.height * yScale);
        this.positionImage();
    }

    private void processBitmap() {
        byte[] imData = null;
        byte[] fh = new byte[54];
        try {
            FileInputStream fis = new FileInputStream(this.imgFile);
            int br = fis.read(fh, 0, 54);
            if (br < 54) {
                throw new Exception("File is too small to be a bitmap file (" + br + ")");
            }
            if (!new String(fh, 0, 2).equals("BM")) {
                throw new Exception("File is not a bitmap.");
            }
            this.size = IntegerHelper.getInt(fh[2], fh[3], fh[4], fh[5]);
            this.size -= 54;
            this.size += 12;
            this.width = IntegerHelper.getInt(fh[18], fh[19], fh[20], fh[21]);
            this.height = IntegerHelper.getInt(fh[22], fh[23], fh[24], fh[25]);
            if (this.width > 65535 || this.height > 65535) {
                throw new Exception("Image dimensions are too large.");
            }
            if (IntegerHelper.getInt(fh[26], fh[27]) != 1) {
                throw new Exception("Only images with 1 plane are supported");
            }
            if (IntegerHelper.getInt(fh[28], fh[29]) != 24) {
                throw new Exception("Only images with 24 bits are supported");
            }
            if (IntegerHelper.getInt(fh[30], fh[31], fh[32], fh[33]) != 0) {
                throw new Exception("Compressed images are not supported.");
            }
            imData = new byte[this.size];
            br = fis.read(imData, 12, this.size - 12);
            if (br != this.size - 12) {
                throw new Exception("Only read " + br + " bytes.  Needed " + (this.size - 12));
            }
            fis.close();
            IntegerHelper.getFourBytes(12, imData, 0);
            IntegerHelper.getTwoBytes(this.width, imData, 4);
            IntegerHelper.getTwoBytes(this.height, imData, 6);
            IntegerHelper.getTwoBytes(1, imData, 8);
            IntegerHelper.getTwoBytes(24, imData, 10);
            this.imgRec = new ImDataRecord(Type.IMDATA, imData);
        }
        catch (Exception e) {
            throw new RuntimeException("Processing Bitmap File caused exception: " + e);
        }
    }

    private void positionImage() {
        if (this.sheet == null) {
            return;
        }
        int w = this.width;
        int h = this.height;
        this.colEnd = this.col;
        this.rowEnd = this.row;
        int x1 = this.x;
        int y1 = this.y;
        if (x1 > this.sizeCol(x1)) {
            x1 = 0;
        }
        if (y1 > this.sizeRow(y1)) {
            y1 = 0;
        }
        w += x1 - 1;
        h += y1 - 1;
        if (this.sizeCol(x1) == 0 || this.sizeRow(y1) == 0) {
            throw new RuntimeException("Image can not start in a hidden cell.");
        }
        x1 = x1 * 1024 / this.sizeCol(x1);
        y1 = y1 * 256 / this.sizeRow(y1);
        while (w > this.sizeCol(this.colEnd)) {
            w -= this.sizeCol(this.colEnd++);
        }
        while (h > this.sizeRow(this.rowEnd)) {
            h -= this.sizeRow(this.rowEnd++);
        }
        if (this.sizeCol(this.colEnd) == 0 || this.sizeRow(this.rowEnd) == 0) {
            throw new RuntimeException("Image can not end in a hidden cell (" + this.colEnd + "," + this.rowEnd + ")");
        }
        int x2 = w * 1024 / this.sizeCol(this.colEnd);
        int y2 = h * 256 / this.sizeRow(this.rowEnd);
        this.objRec = new ObjRecord(Type.OBJ, 8, this.col, this.row, this.colEnd, this.rowEnd, x1, x2, y1, y2);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    public int getLastRow() {
        return this.rowEnd;
    }

    public int getLastColumn() {
        return this.colEnd;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private int sizeCol(int col) {
        return this.sheet.getColumnWidth(col) / 32;
    }

    private int sizeRow(int row) {
        return this.sheet.getRowHeight(row) / 15;
    }

    public void insertRow(int r) {
        if (r <= this.row) {
            ++this.row;
        }
        this.positionImage();
    }

    public void insertCol(int c) {
        if (c <= this.col) {
            ++this.col;
        }
        this.positionImage();
    }

    public void removeRow(int r) {
        if (r <= this.row) {
            --this.row;
        }
        this.positionImage();
    }

    public void removeColumn(int c) {
        if (c <= this.col) {
            --this.col;
        }
        this.positionImage();
    }
}

