/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.CellType;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;

public class FormulaRecord
extends CellValue
implements FormulaData {
    private String formulaToParse;
    private FormulaParser parser;
    private String formulaString;
    private byte[] formulaBytes;

    public FormulaRecord(int c, int r, String f) {
        super(Type.FORMULA, c, r);
        this.formulaToParse = f;
    }

    public FormulaRecord(int c, int r, String f, CellFormat st) {
        super(Type.FORMULA, c, r, st);
        this.formulaToParse = f;
    }

    private void initialize(WorkbookSettings ws, ExternalSheet es) {
        this.parser = new FormulaParser(this.formulaToParse, es, ws);
        try {
            this.parser.parse();
            this.formulaString = this.parser.getFormula();
            this.formulaBytes = this.parser.getBytes();
        }
        catch (FormulaException e) {
            if (!ws.getSuppressWarnings()) {
                System.err.println("Warning:  " + e.getMessage() + " when parsing formula " + this.formulaToParse);
            }
            try {
                this.formulaToParse = "ERROR(1)";
                this.parser = new FormulaParser(this.formulaToParse, es, ws);
                this.parser.parse();
                this.formulaString = this.parser.getFormula();
                this.formulaBytes = this.parser.getBytes();
            }
            catch (FormulaException e2) {
                e2.printStackTrace();
            }
        }
    }

    void setCellDetails(FormattingRecords fr, SharedStrings ss, WritableSheetImpl s) {
        super.setCellDetails(fr, ss, s);
        this.initialize(s.getWorkbookSettings(), s.getWorkbook());
    }

    public byte[] getData() {
        byte[] celldata = super.getData();
        byte[] data = new byte[celldata.length + this.formulaBytes.length + 16];
        System.arraycopy(celldata, 0, data, 0, celldata.length);
        System.arraycopy(this.formulaBytes, 0, data, 22, this.formulaBytes.length);
        data[14] = (byte)(data[14] | 2);
        IntegerHelper.getTwoBytes(this.formulaBytes.length, data, 20);
        return data;
    }

    public CellType getType() {
        return CellType.ERROR;
    }

    public String getContents() {
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        return this.formulaBytes;
    }
}

