/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;

class ColumnInfoRecord
extends WritableRecordData {
    private byte[] data;
    private int column;
    private XFRecord style;
    private int xfIndex;
    private int width;
    private boolean hidden;

    public ColumnInfoRecord(int col, int w, XFRecord xf) {
        super(Type.COLINFO);
        this.column = col;
        this.width = w * 256;
        this.style = xf;
        this.xfIndex = this.style.getXFIndex();
        this.hidden = false;
    }

    public ColumnInfoRecord(jxl.read.biff.ColumnInfoRecord cir, int col, FormattingRecords fr) {
        super(Type.COLINFO);
        this.column = col;
        this.width = cir.getWidth() * 256;
        this.xfIndex = cir.getXFIndex();
        this.style = fr.getXFRecord(this.xfIndex);
    }

    public int getColumn() {
        return this.column;
    }

    public void incrementColumn() {
        ++this.column;
    }

    public void decrementColumn() {
        --this.column;
    }

    int getWidth() {
        return this.width;
    }

    public byte[] getData() {
        this.data = new byte[12];
        IntegerHelper.getTwoBytes(this.column, this.data, 0);
        IntegerHelper.getTwoBytes(this.column, this.data, 2);
        IntegerHelper.getTwoBytes(this.width, this.data, 4);
        IntegerHelper.getTwoBytes(this.xfIndex, this.data, 6);
        int options = 2;
        if (this.hidden) {
            options |= 1;
        }
        IntegerHelper.getTwoBytes(options, this.data, 8);
        IntegerHelper.getTwoBytes(2, this.data, 10);
        return this.data;
    }

    public XFRecord getCellFormat() {
        return this.style;
    }

    void rationalize(IndexMapping xfmapping) {
        this.xfIndex = xfmapping.getNewIndex(this.xfIndex);
    }

    void setHidden(boolean h) {
        this.hidden = h;
    }
}

