/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Hyperlink;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.chart.Chart;
import jxl.format.CellFormat;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.File;
import jxl.read.biff.FooterRecord;
import jxl.read.biff.HeaderRecord;
import jxl.read.biff.MergedCellsRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetReader;
import jxl.read.biff.WorkbookParser;
import jxl.read.biff.ZoomRecord;

public class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private ZoomRecord zoom;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private String name;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private RowRecord[] rowRecords;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private ArrayList charts;
    private MergedCellsRecord mergedCells;
    private boolean columnInfosInitialized;
    private boolean rowRecordsInitialized;
    private boolean nineteenFour;
    private HeaderRecord header;
    private FooterRecord footer;
    private WorkspaceInformationRecord workspaceOptions;
    private boolean hidden;
    private SheetSettings settings;
    private int[] rowBreaks;
    private WorkbookParser workbook;
    private WorkbookSettings workbookSettings;

    SheetImpl(File f, SSTRecord sst, FormattingRecords fr, BOFRecord sb, BOFRecord wb, boolean nf, WorkbookParser wp) throws BiffException {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.sheetBof = sb;
        this.workbookBof = wb;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.columnInfosInitialized = false;
        this.rowRecordsInitialized = false;
        this.nineteenFour = nf;
        this.workbook = wp;
        this.workbookSettings = this.workbook.getSettings();
        this.startPosition = f.getPos();
        Record r = null;
        int bofs = 1;
        while (bofs >= 1) {
            r = f.next();
            if (r.getCode() == Type.EOF.value) {
                --bofs;
            }
            if (r.getCode() != Type.BOF.value) continue;
            ++bofs;
        }
    }

    public Cell getCell(int column, int row) {
        Cell c;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((c = this.cells[row][column]) == null) {
            this.cells[row][column] = c = new EmptyCell(column, row);
        }
        return c;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public Cell[] getRow(int row) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int col = this.numCols - 1;
        while (col >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        for (int i = 0; i <= col; ++i) {
            cells[i] = this.getCell(i, row);
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        for (int i = 0; i <= row; ++i) {
            cells[i] = this.getCell(col, i);
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    final void setName(String s) {
        this.name = s;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnInfoRecord getColumnInfo(int col) {
        if (!this.columnInfosInitialized) {
            Iterator i = this.columnInfosArray.iterator();
            ColumnInfoRecord cir = null;
            while (i.hasNext()) {
                cir = (ColumnInfoRecord)i.next();
                int startcol = Math.max(0, cir.getStartColumn());
                int endcol = Math.min(this.columnInfos.length - 1, cir.getEndColumn());
                for (int c = startcol; c <= endcol; ++c) {
                    this.columnInfos[c] = cir;
                }
                if (endcol >= startcol) continue;
                this.columnInfos[startcol] = cir;
            }
            this.columnInfosInitialized = true;
        }
        return col < this.columnInfos.length ? this.columnInfos[col] : null;
    }

    public ColumnInfoRecord[] getColumnInfos() {
        ColumnInfoRecord[] infos = new ColumnInfoRecord[this.columnInfosArray.size()];
        for (int i = 0; i < this.columnInfosArray.size(); ++i) {
            infos[i] = (ColumnInfoRecord)this.columnInfosArray.get(i);
        }
        return infos;
    }

    final void setHidden(boolean h) {
        this.hidden = h;
    }

    final void clear() {
        this.cells = null;
        this.mergedCells = null;
        this.columnInfosArray.clear();
        this.sharedFormulas.clear();
        this.hyperlinks.clear();
        this.columnInfosInitialized = false;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    final void readSheet() {
        if (!this.sheetBof.isWorksheet()) {
            this.numRows = 0;
            this.numCols = 0;
            this.cells = new Cell[0][0];
            return;
        }
        SheetReader reader = new SheetReader(this.excelFile, this.sharedStrings, this.formattingRecords, this.workbookBof, this.nineteenFour, this.workbook, this.startPosition, this);
        reader.read();
        this.numRows = reader.getNumRows();
        this.numCols = reader.getNumCols();
        this.cells = reader.getCells();
        this.rowProperties = reader.getRowProperties();
        this.columnInfosArray = reader.getColumnInfosArray();
        this.hyperlinks = reader.getHyperlinks();
        this.charts = reader.getCharts();
        this.mergedCells = reader.getMergedCells();
        this.header = reader.getHeader();
        this.footer = reader.getFooter();
        this.settings = reader.getSettings();
        this.settings.setHidden(this.hidden);
        this.rowBreaks = reader.getRowBreaks();
        this.workspaceOptions = reader.getWorkspaceOptions();
        this.zoom = reader.getZoomRecord();
        reader = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
        if (this.columnInfosArray.size() > 0) {
            ColumnInfoRecord cir = (ColumnInfoRecord)this.columnInfosArray.get(this.columnInfosArray.size() - 1);
            this.columnInfos = new ColumnInfoRecord[cir.getEndColumn() + 1];
        } else {
            this.columnInfos = new ColumnInfoRecord[0];
        }
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            hl[i] = (Hyperlink)this.hyperlinks.get(i);
        }
        return hl;
    }

    public Range[] getMergedCells() {
        if (this.mergedCells == null) {
            return new Range[0];
        }
        return this.mergedCells.getRanges();
    }

    public RowRecord[] getRowProperties() {
        RowRecord[] rp = new RowRecord[this.rowProperties.size()];
        for (int i = 0; i < rp.length; ++i) {
            rp[i] = (RowRecord)this.rowProperties.get(i);
        }
        return rp;
    }

    RowRecord getRowInfo(int r) {
        if (!this.rowRecordsInitialized) {
            this.rowRecords = new RowRecord[this.getRows()];
            Iterator i = this.rowProperties.iterator();
            RowRecord rr = null;
            while (i.hasNext()) {
                this.rowRecords[rr.getRowNumber()] = rr = (RowRecord)i.next();
            }
        }
        return this.rowRecords[r];
    }

    public final HeaderRecord getHeader() {
        return this.header;
    }

    public final FooterRecord getFooter() {
        return this.footer;
    }

    public final int[] getRowPageBreaks() {
        return this.rowBreaks;
    }

    public final Chart[] getCharts() {
        Chart[] ch = new Chart[this.charts.size()];
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = (Chart)this.charts.get(i);
        }
        return ch;
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookParser getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        if (cir == null) {
            return null;
        }
        return this.formattingRecords.getXFRecord(cir.getXFIndex());
    }

    public int getColumnWidth(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        return cir != null ? cir.getWidth() : this.settings.getDefaultColumnWidth();
    }

    public int getRowHeight(int row) {
        RowRecord rr = this.getRowInfo(row);
        return rr != null ? rr.getRowHeight() : this.settings.getDefaultRowHeight();
    }

    public int getZoomFactor() {
        if (this.zoom == null) {
            return 100;
        }
        return this.zoom.getZoomFactor();
    }
}

