/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jxl.Hyperlink;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.SheetRangeImpl;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class HyperlinkRecord
extends RecordData
implements Hyperlink {
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private URL url;
    private File file;
    private String location;
    private SheetRangeImpl range;
    private LinkType linkType = unknown;
    private static final LinkType urlLink = new LinkType();
    private static final LinkType fileLink = new LinkType();
    private static final LinkType workbookLink = new LinkType();
    private static final LinkType unknown = new LinkType();

    HyperlinkRecord(Record t, Sheet s, WorkbookSettings ws) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.firstRow = IntegerHelper.getInt(data[0], data[1]);
        this.lastRow = IntegerHelper.getInt(data[2], data[3]);
        this.firstColumn = IntegerHelper.getInt(data[4], data[5]);
        this.lastColumn = IntegerHelper.getInt(data[6], data[7]);
        this.range = new SheetRangeImpl(s, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        if (data[28] == 3) {
            this.linkType = urlLink;
            int bytes = IntegerHelper.getInt(data[48], data[49], data[50], data[51]);
            String urlString = StringHelper.getUnicodeString(data, bytes / 2 - 1, 52);
            try {
                this.url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                System.err.println("Warning:  url " + urlString + " is malformed.  Ignoring");
                try {
                    this.url = new URL("http://www.andykhan.com/jexcelapi/index.html");
                }
                catch (MalformedURLException e2) {}
            }
        } else if (data[28] == 1) {
            this.linkType = fileLink;
            int upLevelCount = IntegerHelper.getInt(data[48], data[49]);
            int chars = IntegerHelper.getInt(data[50], data[51], data[52], data[53]);
            String fileName = StringHelper.getString(data, chars - 1, 54, ws);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < upLevelCount; ++i) {
                sb.append("..\\");
            }
            sb.append(fileName);
            this.file = new File(sb.toString());
        } else if (data[28] == 8) {
            this.linkType = workbookLink;
            int chars = IntegerHelper.getInt(data[32], data[33], data[34], data[35]);
            this.location = StringHelper.getUnicodeString(data, chars - 1, 36);
        } else {
            return;
        }
    }

    public boolean isFile() {
        return this.linkType == fileLink;
    }

    public boolean isURL() {
        return this.linkType == urlLink;
    }

    public boolean isLocation() {
        return this.linkType == workbookLink;
    }

    public int getRow() {
        return this.firstRow;
    }

    public int getColumn() {
        return this.firstColumn;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Record getRecord() {
        return super.getRecord();
    }

    public Range getRange() {
        return this.range;
    }

    public String getLocation() {
        return this.location;
    }

    private static class LinkType {
        private LinkType() {
        }
    }
}

