/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.chart;

import common.Assert;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.File;
import jxl.read.biff.MsoDrawingRecord;
import jxl.read.biff.ObjRecord;

public class Chart
implements ByteData {
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private int startpos;
    private int endpos;
    private File file;
    private byte[] data;
    private boolean initialized;
    private WorkbookSettings workbookSettings;

    public Chart(MsoDrawingRecord mso, ObjRecord obj, int sp, int ep, File f, WorkbookSettings ws) {
        this.msoDrawingRecord = mso;
        this.objRecord = obj;
        this.startpos = sp;
        this.endpos = ep;
        this.file = f;
        this.workbookSettings = ws;
        this.initialized = false;
        Assert.verify(this.msoDrawingRecord != null);
        Assert.verify(this.objRecord != null);
    }

    public byte[] getBytes() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.data;
    }

    private void initialize() {
        byte[] msodata = this.msoDrawingRecord.getRecord().getData();
        byte[] objdata = this.objRecord.getRecord().getData();
        byte[] chartdata = this.file.read(this.startpos, this.endpos - this.startpos);
        this.data = new byte[msodata.length + 4 + objdata.length + 4 + chartdata.length];
        int pos = 0;
        IntegerHelper.getTwoBytes(this.msoDrawingRecord.getRecord().getCode(), this.data, pos);
        IntegerHelper.getTwoBytes(this.msoDrawingRecord.getRecord().getLength(), this.data, pos + 2);
        System.arraycopy(msodata, 0, this.data, pos + 4, msodata.length);
        IntegerHelper.getTwoBytes(this.objRecord.getRecord().getCode(), this.data, pos += msodata.length + 4);
        IntegerHelper.getTwoBytes(this.objRecord.getRecord().getLength(), this.data, pos + 2);
        System.arraycopy(objdata, 0, this.data, pos + 4, objdata.length);
        System.arraycopy(chartdata, 0, this.data, pos += objdata.length + 4, chartdata.length);
        chartdata = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
        this.initialized = true;
    }

    public void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        if (!this.initialized) {
            this.initialize();
        }
        int code = 0;
        int length = 0;
        Type type = null;
        for (int pos = 0; pos < this.data.length; pos += length + 4) {
            int fontind;
            code = IntegerHelper.getInt(this.data[pos], this.data[pos + 1]);
            length = IntegerHelper.getInt(this.data[pos + 2], this.data[pos + 3]);
            type = Type.getType(code);
            if (type == Type.FONTX) {
                fontind = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
                IntegerHelper.getTwoBytes(fontMapping.getNewIndex(fontind), this.data, pos + 4);
                continue;
            }
            if (type == Type.FBI) {
                fontind = IntegerHelper.getInt(this.data[pos + 12], this.data[pos + 13]);
                IntegerHelper.getTwoBytes(fontMapping.getNewIndex(fontind), this.data, pos + 12);
                continue;
            }
            if (type != Type.IFMT) continue;
            int formind = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
            IntegerHelper.getTwoBytes(formatMapping.getNewIndex(formind), this.data, pos + 4);
        }
    }
}

