/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jxl.biff.ByteData;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.read.biff.Record;

public abstract class WritableRecordData
extends RecordData
implements ByteData {
    private final int CHUNKSIZE = 8224;

    protected WritableRecordData(Type t) {
        super(t);
    }

    protected WritableRecordData(Record t) {
        super(t);
    }

    public final byte[] getBytes() {
        byte[] bytes = null;
        byte[] data = this.getData();
        if (data.length > 8224) {
            try {
                int chunk;
                ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length + 4 * (1 + data.length / 8224));
                for (int pos = 0; pos < data.length; pos += chunk) {
                    baos.write(IntegerHelper.getTwoBytes(pos == 0 ? this.getCode() : Type.CONTINUE.value));
                    chunk = data.length - pos;
                    if (chunk > 8224) {
                        chunk = 8224;
                    }
                    baos.write(IntegerHelper.getTwoBytes(chunk));
                    baos.write(data, pos, chunk);
                }
                bytes = baos.toByteArray();
            }
            catch (IOException ioe) {
                bytes = null;
            }
        } else {
            bytes = new byte[data.length + 4];
            System.arraycopy(data, 0, bytes, 4, data.length);
            IntegerHelper.getTwoBytes(this.getCode(), bytes, 0);
            IntegerHelper.getTwoBytes(data.length, bytes, 2);
        }
        return bytes;
    }

    protected abstract byte[] getData();
}

