/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.util.HashMap;
import java.util.Locale;
import jxl.biff.formula.FunctionNames;

public final class WorkbookSettings {
    private int initialFileSize = 0x500000;
    private int arrayGrowSize = 0x100000;
    private boolean chartsDisabled;
    private boolean namesDisabled;
    private boolean gcDisabled;
    private boolean rationalizationDisabled;
    private boolean suppressWarnings;
    private Locale locale;
    private FunctionNames functionNames;
    private String encoding;
    private static HashMap localeFunctionNames;
    private static final int defaultInitialFileSize = 0x500000;
    private static final int defaultArrayGrowSize = 0x100000;

    public WorkbookSettings() {
        localeFunctionNames = new HashMap();
        try {
            this.chartsDisabled = Boolean.getBoolean("jxl.nocharts");
            this.namesDisabled = Boolean.getBoolean("jxl.nonames");
            this.gcDisabled = Boolean.getBoolean("jxl.nogc");
            this.rationalizationDisabled = Boolean.getBoolean("jxl.norat");
            this.suppressWarnings = Boolean.getBoolean("jxl.nowarnings");
            this.encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e) {
            System.err.println("Warning:  error accessing system properties");
        }
        try {
            this.locale = System.getProperty("jxl.lang") == null || System.getProperty("jxl.country") == null ? Locale.getDefault() : new Locale(System.getProperty("jxl.lang"), System.getProperty("jxl.country"));
            if (System.getProperty("jxl.encoding") != null) {
                this.encoding = System.getProperty("jxl.encoding");
            }
        }
        catch (SecurityException e) {
            System.err.println("Warning:  error accessing system properties");
            this.locale = Locale.getDefault();
        }
    }

    public void setArrayGrowSize(int sz) {
        this.arrayGrowSize = sz;
    }

    public int getArrayGrowSize() {
        return this.arrayGrowSize;
    }

    public void setInitialFileSize(int sz) {
        this.initialFileSize = sz;
    }

    public int getInitialFileSize() {
        return this.initialFileSize;
    }

    public boolean getChartsDisabled() {
        return this.chartsDisabled;
    }

    public boolean getGCDisabled() {
        return this.gcDisabled;
    }

    public boolean getNamesDisabled() {
        return this.namesDisabled;
    }

    public void setRationalization(boolean r) {
        this.rationalizationDisabled = !r;
    }

    public boolean getRationalizationDisabled() {
        return this.rationalizationDisabled;
    }

    public void setSuppressWarnings(boolean w) {
        this.suppressWarnings = w;
    }

    public boolean getSuppressWarnings() {
        return this.suppressWarnings;
    }

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public FunctionNames getFunctionNames() {
        if (this.functionNames == null) {
            this.functionNames = (FunctionNames)localeFunctionNames.get(this.locale);
            if (this.functionNames == null) {
                this.functionNames = new FunctionNames(this.locale);
                localeFunctionNames.put(this.locale, this.functionNames);
            }
        }
        return this.functionNames;
    }
}

