(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2320835,      73932]*)
(*NotebookOutlinePosition[   2349430,      74797]*)
(*  CellTagsIndexPosition[   2342275,      74584]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["FeynCalc 3.0 Manual", "Title",
  TextAlignment->Center],

Cell["Tools for Feynman diagram calculations", "Subtitle",
  TextAlignment->Center],

Cell["Rolf Mertig", "Subsubtitle",
  TextAlignment->Center],

Cell["August 26, 1998 ", "Subsubtitle",
  TextAlignment->Center],

Cell[TextData[{
  "Copyright \[Copyright]1998 \nMertig Research & Consulting\nOosterpark 77\n\
NL-1092 AT Amsterdam\n",
  ButtonBox["http://www.mertig.com",
    ButtonData:>{
      URL[ "http://www.mertig.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Subsubtitle",
  TextAlignment->Center],

Cell[TextData[StyleBox[
"This notebook describes features of FeynCalc 3.0.5.1",
  FontWeight->"Bold"]], "Subsubtitle",
  PageBreakBelow->True,
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Table of Contents", "Section"],

Cell["\<\
You can select the Cell bracket of this \"Table of Contents\" \
section and copy it to a new notebook which should be saved in the same \
directory as this one.
One possibility to jump back from a hyperlink is to use the \"<<Back\" button \
from the Help Browser.\
\>", "Text"],

Cell[TextData[ButtonBox["Short Overview",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Short Overview"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Load FeynCalc",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Load FeynCalc"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["A0",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "A0"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Amplitudes",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Amplitudes"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["AnomalousDimension",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "AnomalousDimension"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Anti5",
  ButtonData:>{
    FrontEnd`FileName[ 
    {}, "FeynCalcManual.nb", CharacterEncoding -> "ISO8859-1"], "Anti5"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["AntiCommutator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "AntiCommutator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["AntiQuarkField",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "AntiQuarkField"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Apart1",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Apart1"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Apart2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Apart2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Apart3",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Apart3"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["B00",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "B00"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["B0",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "B0"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["B11",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "B11"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["B1",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "B1"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["BackgroundGluonVertex",
  ButtonData:>{
    FrontEnd`FileName[ 
    {}, "FeynCalcManual.nb", CharacterEncoding -> "ISO8859-1"], 
    "BackgroundGluonVertex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["C0",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "C0"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Calc",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Calc"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["CA",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "CA"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Cases2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Cases2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["CF",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "CF"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ChangeDimension",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ChangeDimension"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ChargeConjugationMatrixInv",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ChargeConjugationMatrixInv"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ChargeConjugationMatrix",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ChargeConjugationMatrix"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ChiralityProjector",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ChiralityProjector"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Chisholm",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Chisholm"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Collect2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Collect2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Combine",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Combine"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["CommutatorExplicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "CommutatorExplicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Commutator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Commutator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ComplexConjugate",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ComplexConjugate"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ComplexIndex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ComplexIndex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Contract",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Contract"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Convolute",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Convolute"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["CovariantD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "CovariantD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["D0",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "D0"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DataType",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DataType"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DeclareNonCommutative",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DeclareNonCommutative"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DeltaFunction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DeltaFunction"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DeltaFunctionPrime",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DeltaFunctionPrime"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Dimension",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Dimension"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracGammaCombine",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracGammaCombine"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracGammaExpand",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracGammaExpand"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracGamma",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracGamma"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracGammaT",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracGammaT"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracMatrix",
  ButtonData:>{
    FrontEnd`FileName[ 
    {}, "FeynCalcManual.nb", CharacterEncoding -> "ISO8859-1"], "DiracMatrix"}
    ,
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracOrder",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracOrder"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracReduce",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracReduce"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracSigmaExplicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracSigmaExplicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracSigma",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracSigma"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracSimplify2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracSimplify2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracSlash",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracSlash"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracTrace",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracTrace"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DiracTrick",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DiracTrick"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["DotSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "DotSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["EpsChisholm",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "EpsChisholm"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["EpsEvaluate",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "EpsEvaluate"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Epsilon",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Epsilon"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Eps",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Eps"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ExpandPartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ExpandPartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ExpandScalarProduct",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ExpandScalarProduct"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Explicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Explicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ExplicitPartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ExplicitPartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Factor2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Factor2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FAD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FAD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FCE",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FCE"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FCI",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FCI"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FermionSpinSum",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FermionSpinSum"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynAmpDenominatorCombine",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynAmpDenominatorCombine"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynAmpDenominator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynAmpDenominator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynAmpDenominatorSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynAmpDenominatorSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynAmpDenominatorSplit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynAmpDenominatorSplit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynAmp",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynAmp"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynCalc2FORM",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynCalc2FORM"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynCalcExternal",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynCalcExternal"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynCalcInternal",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynCalcInternal"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FeynRule",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FeynRule"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FieldStrength",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FieldStrength"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FORM2FeynCalc",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FORM2FeynCalc"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FourDivergence",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FourDivergence"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FourLaplacian",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FourLaplacian"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FourVector",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FourVector"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FreeQ2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FreeQ2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FromTFi",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FromTFi"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FRH",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FRH"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FunctionalD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FunctionalD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FVD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FVD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["FV",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "FV"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GAD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GAD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GammaEpsilon",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GammaEpsilon"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GammaExpand",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GammaExpand"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GA",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GA"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GhostPropagator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GhostPropagator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GHP",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GHP"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GaugeField",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GluonField"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GluonGhostVertex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GluonGhostVertex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GluonPropagator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GluonPropagator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GluonVertex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GluonVertex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GSD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GSD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["GS",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "GS"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Hill",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Hill"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["HypergeometricAC",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "HypergeometricAC"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["HypergeometricIR",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "HypergeometricIR"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["HypergeometricSE",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "HypergeometricSE"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["HypExplicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "HypExplicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Integrate2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Integrate2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Integrate3",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Integrate3"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["IntegrateByParts",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "IntegrateByParts"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["InverseMellin",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "InverseMellin"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Isolate",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Isolate"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Kummer",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Kummer"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Lagrangian",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Lagrangian"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LCD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LCD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LC",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LC"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LeftPartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LeftPartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LeftRightPartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LeftRightPartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LeftRightPartialD2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LeftRightPartialD2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LeviCivita",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LeviCivita"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["LorentzIndex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "LorentzIndex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Map2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Map2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["MetricTensor",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "MetricTensor"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["MomentumCombine",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "MomentumCombine"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["MomentumExpand",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "MomentumExpand"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Momentum",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Momentum"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["MTD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "MTD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["MT",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "MT"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Nielsen",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Nielsen"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["NTerms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "NTerms"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OneLoop",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OneLoop"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OneLoopSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OneLoopSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OPEDelta",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OPEDelta"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OPEi, OPEj, OPEk, OPEl, OPEm, OPEn, OPEo",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OPEi"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OPESumExplicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OPESumExplicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OPESum",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OPESum"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["OPESumSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "OPESumSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Pair",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Pair"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PaVe",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PaVe"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PaVeOrder",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PaVeOrder"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PaVeReduce",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PaVeReduce"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PlusDistribution",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PlusDistribution"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Polarization",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Polarization"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PolarizationSum",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PolarizationSum"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PolarizationVector",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PolarizationVector"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PowerSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PowerSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PropagatorDenominatorExplicit",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PropagatorDenominatorExplicit"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["PropagatorDenominator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "PropagatorDenominator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["QuantumField",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "QuantumField"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["QuarkField",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "QuarkField"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["QuarkGluonVertex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "QuarkGluonVertex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["QuarkPropagator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "QuarkPropagator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["RightPartialD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "RightPartialD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["RussianTrick",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "RussianTrick"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ScalarProduct",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ScalarProduct"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ScalarProductCancel",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ScalarProductCancel"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SelectFree",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SelectFree"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SelectNotFree",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SelectNotFree"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Series2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Series2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SimplifyDeltaFunction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SimplifyDeltaFunction"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SimplifyPolyLog",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SimplifyPolyLog"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SOD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SOD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Solve2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Solve2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SO",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SO"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SPD",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SPD"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Spinor",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Spinor"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SpinorUBar",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SpinorUBar"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SpinorU",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SpinorU"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SpinorVBar",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SpinorVBar"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SpinorV",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SpinorV"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SplittingFunction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SplittingFunction"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SP",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SP"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SumP",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SumP"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SumS",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SumS"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SumT",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SumT"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNDelta",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNDelta"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUND",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUND"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNF",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNF"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNIndex",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNIndex"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNSimplify",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNSimplify"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNT",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNT"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["SUNTrace",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "SUNTrace"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Symmetrize",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Symmetrize"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Tdec",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Tdec"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Tensorfunction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Tensorfunction"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["TFi",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "TFi"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["TIDL",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "TIDL"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["TID",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "TID"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ToDistribution",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ToDistribution"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ToHypergeometric",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ToHypergeometric"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ToLarin",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ToLarin"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["ToTFi",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "ToTFi"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["TrickMandelstam",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "TrickMandelstam"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Trick",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Trick"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Tr",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Tr"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Twist2GluonOperator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Twist2GluonOperator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Twist2QuarkOperator",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Twist2QuarkOperator"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Uncontract",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Uncontract"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["UnDeclareNonCommutative",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "UnDeclareNonCommutative"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Write2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Write2"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}],

Cell[TextData[ButtonBox["Evaluation time and memory usage",
  ButtonData:>{
    FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
      "ISO8859-1"], "Evaluation time and memory usage"},
  ButtonStyle->"Hyperlink"]], "Text",
  CellMargins->{{21, 4}, {0, 0}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Short Overview", "Section",
  PageBreakAbove->True,
  CellTags->"Short Overview"],

Cell[TextData[{
  "FeynCalc 3.0 is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 package for algebraic calculations in high energy physics. Tools are \
provided for Lorentz index contraction, Dirac algebra manipulation, color \
factor calculation, automatic Feynman rule derivation, general noncommutative \
algebra as well as various look-up tables for Feynman parameter integrals, \
convolutions and Feynman rules. Furthermore special translation facilities \
are provided to change the FeynCalc syntax to and from FORM syntax. Optimized \
FORTRAN generation is possible by using ",
  ButtonBox["Isolate",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Isolate"},
    ButtonStyle->"Hyperlink"],
  "  and ",
  ButtonBox["Write2",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Write2"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "The more important functions for input of objects like ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["p", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Nu]"], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", " ", "\[Nu]"}]], ",", " ", 
          SuperscriptBox["\[CurlyEpsilon]", 
            RowBox[{"\[Mu]", " ", "\[Nu]", " ", "\[Rho]", " ", "\[Sigma]"}]], 
          ",", " ", 
          RowBox[{"etc", "."}]}], TraditionalForm]]],
  " (abbreviations in parentheses) are:\n",
  ButtonBox["DiracMatrix",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "DiracMatrix"},
    ButtonStyle->"Hyperlink"],
  " (",
  ButtonBox["GA",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "GA"},
    ButtonStyle->"Hyperlink"],
  "), ",
  ButtonBox["DiracSlash",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "DiracSlash"},
    ButtonStyle->"Hyperlink"],
  " (",
  ButtonBox["GS",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "GS"},
    ButtonStyle->"Hyperlink"],
  "), ",
  ButtonBox["FourVector",
    ButtonData:>"FourVector",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FourVector"],
  " (",
  ButtonBox["FV",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "FV"},
    ButtonStyle->"Hyperlink"],
  "), ",
  ButtonBox["LeviCivita",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "LeviCivita"},
    ButtonStyle->"Hyperlink"],
  " (",
  ButtonBox["LC",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "LC"},
    ButtonStyle->"Hyperlink"],
  "), ",
  ButtonBox["MetricTensor",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "MetricTensor"},
    ButtonStyle->"Hyperlink"],
  " (",
  ButtonBox["MT",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "MT"},
    ButtonStyle->"Hyperlink"],
  "),  ",
  ButtonBox["Spinor",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Spinor"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["SUNDelta",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "a:0.0.176.0"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["SUNF",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "a:0.0.178.0"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["ScalarProduct",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "ScalarProduct"},
    ButtonStyle->"Hyperlink"],
  " (",
  ButtonBox["SP",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "SP"},
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text"],

Cell["The more important functions for manipulations are:", "Text"],

Cell[TextData[{
  ButtonBox["Contract",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Contract"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Tr",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Tr"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  ", ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  ", ",
  ButtonBox["Convolute",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Convolute"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["FeynRule",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "FeynRule"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["Integrate2",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Integrate2"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["FeynCalc2FORM",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "FeynCalc2FORM"},
    ButtonStyle->"Hyperlink"],
  " ,",
  ButtonBox["PaVeReduce",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "PaVeReduce"},
    ButtonStyle->"Hyperlink"],
  " ,",
  ButtonBox["SimplifyPolyLog",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "SimplifyPolyLog"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["SUNSimplify",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "SUNSimplify"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["Isolate",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Isolate"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["Collect2",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "Collect2"},
    ButtonStyle->"Hyperlink"],
  " , ",
  ButtonBox["OneLoopSimplify",
    ButtonData:>"OneLoopSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"OneLoopSimplify"],
  " , ",
  ButtonBox["Series2",
    ButtonData:>"Series2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Series2"],
  " , ",
  ButtonBox["ScalarProductCancel",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "ScalarProductCancel"},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[TextData[{
  "FeynCalc 3.0 is still compatible with FeynArts 2.2 if the FeynArts \
function ToFA1Convention is used on the generated amplitudes. The functions \
OneLoop and OneLoopSum for calculation of Standard Model (like) 1-loop \
diagrams still work in FeynCalc 3.0 but they have not been developed much \
further compared to the FeynCalc 1.0 version. While ",
  ButtonBox["OneLoop",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "OneLoop"},
    ButtonStyle->"Hyperlink"],
  " and OneLoopSum still work fine for selfenergy, triangle and box diagrams \
not too complicated the reader should be aware of the package FORMCalc which \
is more effective for the adventurous researcher calculating thousands of \
diagrams involving four external gauge bosons. Notice however that FORMCalc \
does not reduce the Passarino-Veltman integrals to scalar integrals. Also \
FORMCalc is limited to the 't Hooft Feynman gauge. FeynCalc 3.0 provides the \
possibility to reduce Passarino-Veltman integrals to scalar integrals \
algebraically by the function ",
  ButtonBox["PaVeReduce",
    ButtonData:>"PaVeReduce",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVeReduce"],
  " ."
}], "Text"],

Cell[TextData[{
  "On a Pentium II 300 Mhz computer with 64 MB of RAM running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 for Linux this noteboook needs about 11 minutes to evaluate and less \
than 16 MB of memory."
}], "Text"],

Cell[TextData[{
  "FeynCalc automatically loads any tarcer*.mx file from the  \
HighEnergyPhysics directory. \nFor a description of TARCER see ",
  ButtonBox["hep-ph/9801383",
    ButtonData:>{
      URL[ "http://xxx.lanl.gov/abs/hep-ph/9801383"], None},
    ButtonStyle->"Hyperlink"],
  " or the published version in Computer Physics Communications 111 (1998) \
265-273."
}], "Text"],

Cell["\<\
For more detailed information concerning FeynCalc functions you can \
investigate most of the source code in the FeynCalc directory in the \
HighEnergyPhysics directory. The location of the HighEnergyPhysics directory \
is stored upon installation in the fc.m file and you can get its value from \
the global variable $FeynCalcDirectory. A complete list of FeynCalc objects \
is stored in the variable $FeynCalcStuff. Not all functions are documented in \
this notebook. Some are either very special ones (e.g. for tools for 2-loop \
QCD diagrams originating in twist-2 OPE) or still experimental.\
\>", "Text"],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  "scheme used in OneLoop is the naive one, i.e., ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "5"], ",", 
              SuperscriptBox["\[Gamma]", "\[Mu]"]}], ")"}], "=", "0"}], 
        TraditionalForm]]],
  " in 4 and D dimensions. See also ",
  ButtonBox["ToLarin",
    ButtonData:>{
      FrontEnd`FileName[ {}, "FeynCalcManual.nb", CharacterEncoding -> 
        "ISO8859-1"], "ToLarin"},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell["The metric used is the one from Bjorken and Drell (+---).", "Text"],

Cell[TextData[{
  "For suggestions please email the author: ",
  ButtonBox["Rolf@Mertig.com",
    ButtonData:>{
      URL[ "mailto:Rolf@Mertig.com"], None},
    ButtonStyle->"Hyperlink"],
  ".\nNotice that usually no support is given. However, especially if you \
find bugs, send a repeatable clear example to the above email address."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load FeynCalc", "Section",
  CellTags->"Load FeynCalc"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"absolutestarttime", "=", 
      RowBox[{"AbsoluteTime", "[", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox["3.113150656`15.5138*^9", TraditionalForm]], "Output"]
}, Open  ]],

Cell["This defines typesetting rules for q1 and q2:", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"q1", "/:", 
        RowBox[{"MakeBoxes", "[", 
          RowBox[{"q1", ",", "fmt_"}], "]"}], ":=", 
        RowBox[{"SubscriptBox", "[", 
          RowBox[{"\"\<q\>\"", ",", "\"\<1\>\""}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"q2", "/:", 
        RowBox[{"MakeBoxes", "[", 
          RowBox[{"q2", ",", "fmt_"}], "]"}], ":=", 
        RowBox[{"SubscriptBox", "[", 
          RowBox[{"\"\<q\>\"", ",", "\"\<2\>\""}], "]"}]}], ";"}]], "Input"],

Cell["Load FeynCalc:", "Text"],

Cell[BoxData[
    RowBox[{"<<", "HighEnergyPhysics`fc`"}]], "Input"],

Cell["loading TARCER tarcer23.mx", "Text",
  GeneratedCell->True,
  CellAutoOverwrite->True],

Cell[TextData[{
  StyleBox["FeynCalc",
    FontSlant->"Italic"],
  " ",
  "3.0.5.1",
  ". ",
  "Type ?FeynCalc for help or visit ",
  ButtonBox["www.mertig.com",
    ButtonData:>{
      URL[ "http://www.mertig.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  GeneratedCell->True,
  CellAutoOverwrite->True],

Cell["loading TARCER tarcer23.mx", "Text",
  GeneratedCell->True,
  CellAutoOverwrite->True],

Cell[TextData[{
  StyleBox["FeynCalc",
    FontSlant->"Italic"],
  " ",
  "3.0.5.0",
  ". ",
  "Type ?FeynCalc for help or visit ",
  ButtonBox["www.mertig.com",
    ButtonData:>{
      URL[ "http://www.mertig.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  GeneratedCell->True,
  CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["A0", "Section",
  PageBreakAbove->True,
  CellTags->"A0"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"A0", "[", 
            RowBox[{"m", "^", "2"}], "]"}], " ", "is", "the", "Passarino"}], 
        "-", 
        RowBox[{"Veltman", "one"}], "-", 
        RowBox[{"point", " ", " ", "integral", " ", " ", 
          SubscriptBox["A", "0."]}]}], TraditionalForm]]]], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "A0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"A0ToB0", "\[Rule]", "True"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["C0",
    ButtonData:>"C0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"C0"],
  ", ",
  ButtonBox["D0",
    ButtonData:>"D0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"D0"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "By default any ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["A", "0"], TraditionalForm]]],
  " is expressed in terms of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["B", "0"], TraditionalForm]]],
  "'s."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"A0", "[", 
      RowBox[{"m", "^", "2"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox["B", "0"], "(", "0", ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["m", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        SuperscriptBox["m", "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"A0", "[", 
      RowBox[{
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"A0ToB0", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox["B", "0"], "(", "0", ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["m", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        SuperscriptBox["m", "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "According to the rules of dimensional regularization ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["A", "0"], "(", "0", ")"}], TraditionalForm]]],
  " is set to 0."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"A0", "[", "0", "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"A0", "[", 
      RowBox[{"SmallVariable", "[", 
        RowBox[{"M", "^", "2"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Amplitudes", "Section",
  CellTags->"Amplitudes"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"Amplitudes[name] is a database of Feynman amplitudes.\nGauge \[Rule] 1 means \
  `t Hooft Feynman gauge; Polarization \[Rule] 0 gives\nunpolarized OPE-type  \
 amplitudes, Polarization \[Rule] 1 the polarized ones."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Amplitudes", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
          RowBox[{"Gauge", "\[Rule]", "1"}], ",", 
          RowBox[{"QuarkMass", "\[Rule]", "0"}], ",", 
          RowBox[{"Polarization", "\[Rule]", "1"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynAmp",
    ButtonData:>"FeynAmp",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmp"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["This is the amplitude of a gluon selfenergy diagram.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Amplitudes", "[", "\"\<se1g1\>\"", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        FractionBox[
          RowBox[{
            SubsuperscriptBox["g", "s", "2"], " ", 
            RowBox[{
              SuperscriptBox["V", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], "(", 
              RowBox[{
                FormBox[
                  RowBox[{"-", "p"}],
                  "TraditionalForm"], 
                RowBox[{",", " "}], 
                FormBox[
                  RowBox[{"p", "-", "q"}],
                  "TraditionalForm"], 
                RowBox[{",", " "}], 
                FormBox["q",
                  "TraditionalForm"]}], ")"}], " ", 
            RowBox[{
              SuperscriptBox["V", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Alpha]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Beta]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], "(", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], 
                RowBox[{",", " "}], 
                FormBox[
                  RowBox[{"q", "-", "p"}],
                  "TraditionalForm"], 
                RowBox[{",", " "}], 
                FormBox[
                  RowBox[{"-", "q"}],
                  "TraditionalForm"]}], ")"}], " ", 
            SuperscriptBox["g", 
              RowBox[{
                FormBox[
                  FormBox["\[Alpha]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SuperscriptBox["g", 
              RowBox[{
                FormBox[
                  FormBox["\[Beta]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SubscriptBox["\[Delta]", 
              RowBox[{
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SubscriptBox["\[Delta]", 
              RowBox[{
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SubscriptBox["f", 
              RowBox[{
                FormBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "TraditionalForm"], "\[NoBreak]", 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"], "\[NoBreak]", 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SubscriptBox["f", 
              RowBox[{
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"], "\[NoBreak]", 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"], "\[NoBreak]", 
                FormBox[
                  FormBox["f",
                    "TraditionalForm"],
                  "TraditionalForm"]}]]}], 
          RowBox[{
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], "2"], " ", 
            SuperscriptBox["q", "2"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit[%]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{
          FractionBox["1", 
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"p", "-", "q"}], ")"}], "2"], " ", 
              SuperscriptBox["q", "2"]}]], 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["g", "s", "2"], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Alpha]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Beta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"-", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Beta]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Alpha]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Beta]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "+", 
                  RowBox[{"2", " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Beta]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Beta]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Beta]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "+", 
                  RowBox[{"2", " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Beta]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{"2", " ", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "+", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Rho]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "+", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Rho]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "-", 
                  RowBox[{"2", " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Sigma]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "+", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Sigma]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}]}], ")"}], " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{
                  FormBox[
                    FormBox["e",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["f",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["e",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["f",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "This is the amplitude for graph 6.2 from the paper Z.Phys C ",
  StyleBox["70:",
    FontWeight->"Bold"],
  "637-654, 1996",
  StyleBox[".",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmp", "[", 
      RowBox[{"q1", ",", "q2", ",", "\t", 
        RowBox[{"EpsEvaluate", "[", 
          RowBox[{"Trick", "[", 
            RowBox[{"Explicit", "[", 
              RowBox[{"Amplitudes", "[", "\"\<gg2\>\"", "]"}], "]"}], "]"}], 
          "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Integral]", 
        RowBox[{
          FractionBox[
            RowBox[{
              SuperscriptBox["\[DifferentialD]", "D"], 
              FormBox[
                SubscriptBox["q", "1"],
                "TraditionalForm"]}], 
            SuperscriptBox[
              RowBox[{"(", "2", "\[Pi]", ")"}], "D"]], "\[Integral]", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[DifferentialD]", "D"], 
              FormBox[
                SubscriptBox["q", "2"],
                "TraditionalForm"]}], 
            SuperscriptBox[
              RowBox[{"(", "2", "\[Pi]", ")"}], "D"]]}], "(", 
        FormBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                SubsuperscriptBox["g", "s", "4"], " ", 
                SuperscriptBox["\[Epsilon]", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Lambda]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Lambda]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], 
                    FormBox[
                      SubscriptBox["q", "2"],
                      "TraditionalForm"]}]], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "+", 
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "+", 
                    RowBox[{"2", " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "7"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "7"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "10"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "10"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}]}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "1"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "-", 
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "1"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "-", 
                    RowBox[{"2", " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "1"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "1"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "1"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "11"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "1"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "11"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}]}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", "2"}], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "5"],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "+", 
                    RowBox[{
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "5"],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "5"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "7"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{"2", " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "5"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "7"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "5"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "12"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "5"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "7"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "12"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}]}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"]]}], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "-", 
                    RowBox[{
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "10"],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "+", 
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "10"],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "11"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{"2", " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "11"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "12"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "11"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "+", 
                    RowBox[{"2", " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "12"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "1"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "12"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}], "-", 
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "10"],
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              SubscriptBox["\[Lambda]", "11"],
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox[
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            SubscriptBox["\[Lambda]", "12"],
                            "TraditionalForm"],
                          "TraditionalForm"]]}]}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{"1", "-", 
                    FormBox[
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{"-", "1"}], ")"}], "m"],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox[
                          SubscriptBox["q", "2"],
                          "TraditionalForm"]}], ")"}], 
                    RowBox[{"m", "-", "1"}]],
                  "TraditionalForm"], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "11"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox["b",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "7"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "10"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "7"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "12"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "10"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "11"],
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox[
                        SubscriptBox["\<\"c\"\>", "12"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{
                SubsuperscriptBox["q", "1", "2"], " ", 
                SubsuperscriptBox["q", "2", "2"], " ", 
                SubsuperscriptBox["q", "2", "2"], " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox["q", "2"], "-", "p"}], ")"}], "2"], " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox["q", "1"], "-", 
                      SubscriptBox["q", "2"]}], ")"}], "2"], " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox["q", "1"], "-", "p"}], ")"}], "2"]}], 
              ")"}]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AnomalousDimension", "Section",
  CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
AnomalousDimension[name] is a database of anomalous dimensions of \
twist-2 
operators.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Options[AnomalousDimension]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
          RowBox[{"Simplify", "\[Rule]", "FullSimplify"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["SplittingFunction",
    ButtonData:>"SplittingFunction",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SplittingFunction"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell["Polarized case", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SetOptions", "[", " ", 
      RowBox[{"AnomalousDimension", ",", 
        RowBox[{"Polarization", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
          RowBox[{"Simplify", "\[Rule]", "FullSimplify"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"NS", ",", "qq", " "}], 
          RowBox[{"(", "0", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gnsqq0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["C", "F"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"8", " ", 
              RowBox[{
                SubscriptBox["S", "1"], "(", 
                FormBox[
                  RowBox[{"m", "-", "1"}],
                  "TraditionalForm"], ")"}]}], "+", 
            FractionBox["4", "m"], "+", 
            FractionBox["4", 
              RowBox[{"m", "+", "1"}]], "-", "6"}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "qg", " "}], 
          RowBox[{"(", "0", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsqg0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            FractionBox["8", "m"], "-", 
            FractionBox["16", 
              RowBox[{"m", "+", "1"}]]}], ")"}], " ", 
        SubscriptBox["T", "f"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "gq", " "}], 
          RowBox[{"(", "0", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsgq0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["C", "F"], " ", 
        RowBox[{"(", 
          RowBox[{
            FractionBox["4", 
              RowBox[{"m", "+", "1"}]], "-", 
            FractionBox["8", "m"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "gg", " "}], 
          RowBox[{"(", "0", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsgg0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"8", " ", 
            SubscriptBox["T", "f"]}], "3"], "+", 
        RowBox[{
          SubscriptBox["C", "A"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"8", " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              FractionBox["8", "m"], "+", 
              FractionBox["16", 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["22", "3"]}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"PS", ",", "qq", " "}], 
          RowBox[{"(", "0", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gpsqq1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"16", " ", 
        SubscriptBox["C", "F"], " ", 
        RowBox[{"(", 
          RowBox[{
            FractionBox["1", 
              RowBox[{"m", "+", "1"}]], "+", 
            FractionBox["3", 
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
            FractionBox["2", 
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "3"]], "-", 
            FractionBox["1", "m"], "-", 
            FractionBox["1", 
              SuperscriptBox["m", "2"]], "+", 
            FractionBox["2", 
              SuperscriptBox["m", "3"]]}], ")"}], " ", 
        SubscriptBox["T", "f"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"NS", ",", "qq", " "}], 
          RowBox[{"(", "1", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gnsqq1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              RowBox[{
                FractionBox[
                  RowBox[{"16", " ", 
                    RowBox[{
                      SubscriptBox["S", "1"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], 
                  SuperscriptBox["m", "2"]], "+", 
                FractionBox[
                  RowBox[{"16", " ", 
                    RowBox[{
                      SubscriptBox["S", "1"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
                FractionBox[
                  RowBox[{"16", " ", 
                    RowBox[{
                      SubscriptBox["S", "2"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], "m"], "+", 
                FractionBox[
                  RowBox[{"16", " ", 
                    RowBox[{
                      SubscriptBox["S", "2"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], 
                  RowBox[{"m", "+", "1"}]], "-", 
                RowBox[{"24", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "+", 
                RowBox[{"32", " ", 
                  RowBox[{
                    SubscriptBox["S", "12"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "+", 
                RowBox[{"32", " ", 
                  RowBox[{
                    SubscriptBox["S", "21"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "+", 
                FractionBox[
                  RowBox[{"32", " ", 
                    RowBox[{
                      SubscriptBox[
                        OverscriptBox["S", "~"], "2"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], "m"], "+", 
                FractionBox[
                  RowBox[{"32", " ", 
                    RowBox[{
                      SubscriptBox[
                        OverscriptBox["S", "~"], "2"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], 
                  RowBox[{"m", "+", "1"}]], "-", 
                RowBox[{"32", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "3"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "+", 
                RowBox[{"64", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "12"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "-", 
                FractionBox["40", "m"], "+", 
                FractionBox["40", 
                  RowBox[{"m", "+", "1"}]], "+", 
                FractionBox["16", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
                FractionBox["8", 
                  SuperscriptBox["m", "3"]], "+", 
                FractionBox["40", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", "3"}], 
              ")"}]}], " ", 
          SubsuperscriptBox["C", "F", "2"]}], "-", 
        RowBox[{
          SubscriptBox["N", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FractionBox["80", "9"], " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{
                FractionBox["16", "3"], " ", 
                RowBox[{
                  SubscriptBox["S", "2"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              FractionBox["8", 
                RowBox[{"9", " ", "m"}]], "+", 
              FractionBox["88", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
              FractionBox["8", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "-", 
              FractionBox["8", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              FractionBox["2", "3"]}], ")"}], " ", 
          SubscriptBox["C", "F"]}], "-", 
        RowBox[{
          SubscriptBox["C", "A"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  FractionBox["536", "9"]}], " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "+", 
              RowBox[{
                FractionBox["88", "3"], " ", 
                RowBox[{
                  SubscriptBox["S", "2"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{"16", " ", 
                RowBox[{
                  SubscriptBox["S", "3"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              RowBox[{"16", " ", 
                RowBox[{
                  SubscriptBox[
                    OverscriptBox["S", "~"], "3"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{"32", " ", 
                RowBox[{
                  SubscriptBox[
                    OverscriptBox["S", "~"], "12"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "+", 
              FractionBox["212", 
                RowBox[{"9", " ", "m"}]], "-", 
              FractionBox["748", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
              FractionBox["44", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "-", 
              FractionBox["4", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              FractionBox["16", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", 
              FractionBox["17", "3"]}], ")"}], " ", 
          SubscriptBox["C", "F"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "qg", " "}], 
          RowBox[{"(", "1", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsqg1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"8", " ", 
          SubscriptBox["C", "F"], " ", 
          SubscriptBox["T", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "+", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              FractionBox["14", "m"], "-", 
              FractionBox["19", 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["1", 
                SuperscriptBox["m", "2"]], "-", 
              FractionBox["8", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "-", 
              FractionBox["2", 
                SuperscriptBox["m", "3"]], "+", 
              FractionBox["4", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}]}], "+", 
        RowBox[{"16", " ", 
          SubscriptBox["C", "A"], " ", 
          SubscriptBox["T", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}], "m"]}], "+", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox["m", "2"]], "+", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "-", 
              FractionBox[
                RowBox[{
                  SubscriptBox["S", "2"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}], "m"], "+", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "+", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["4", "m"], "+", 
              FractionBox["3", 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["3", 
                SuperscriptBox["m", "2"]], "+", 
              FractionBox["8", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
              FractionBox["2", 
                SuperscriptBox["m", "3"]], "+", 
              FractionBox["12", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "gq", " "}], 
          RowBox[{"(", "1", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsgq1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "1", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "+", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox["m", "2"]], "-", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              FractionBox["15", "m"], "-", 
              FractionBox["6", 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["12", 
                SuperscriptBox["m", "2"]], "+", 
              FractionBox["3", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
              FractionBox["4", 
                SuperscriptBox["m", "3"]], "-", 
              FractionBox["2", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}], " ", 
          SubsuperscriptBox["C", "F", "2"]}], "+", 
        RowBox[{"32", " ", 
          SubscriptBox["T", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{"2", " ", 
                    RowBox[{
                      SubscriptBox["S", "1"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], 
                  RowBox[{"3", " ", "m"}]]}], "+", 
              FractionBox[
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}], 
                RowBox[{"3", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
              FractionBox["7", 
                RowBox[{"9", " ", "m"}]], "-", 
              FractionBox["2", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
              FractionBox["2", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "+", 
              FractionBox["1", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}], ")"}], " ", 
          SubscriptBox["C", "F"]}], "+", 
        RowBox[{"8", " ", 
          SubscriptBox["C", "A"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{"2", " ", 
                    RowBox[{
                      SubsuperscriptBox["S", "1", "2"], "(", 
                      FormBox[
                        RowBox[{"m", "-", "1"}],
                        "TraditionalForm"], ")"}]}], "m"]}], "+", 
              FractionBox[
                RowBox[{
                  SubsuperscriptBox["S", "1", "2"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}], 
                RowBox[{"m", "+", "1"}]], "+", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"3", " ", "m"}]], "-", 
              FractionBox[
                RowBox[{"5", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"3", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{
                  SubscriptBox["S", "2"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}], 
                RowBox[{"m", "+", "1"}]], "+", 
              FractionBox[
                RowBox[{"4", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "-", 
              FractionBox["56", 
                RowBox[{"9", " ", "m"}]], "-", 
              FractionBox["20", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
              FractionBox["28", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "-", 
              FractionBox["38", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              FractionBox["4", 
                SuperscriptBox["m", "3"]], "-", 
              FractionBox["6", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}], " ", 
          SubscriptBox["C", "F"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "gg", " "}], 
          RowBox[{"(", "1", ")", " "}]], TraditionalForm]]],
  "polarized"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "gsgg1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox["m", "2"]], "-", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
              RowBox[{
                FractionBox["134", "9"], " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "+", 
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox["S", "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              RowBox[{"4", " ", 
                RowBox[{
                  SubscriptBox["S", "3"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{"8", " ", 
                RowBox[{
                  SubscriptBox["S", "12"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{"8", " ", 
                RowBox[{
                  SubscriptBox["S", "21"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "+", 
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], "m"], "-", 
              FractionBox[
                RowBox[{"16", " ", 
                  RowBox[{
                    SubscriptBox[
                      OverscriptBox["S", "~"], "2"], "(", 
                    FormBox[
                      RowBox[{"m", "-", "1"}],
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"m", "+", "1"}]], "+", 
              RowBox[{"4", " ", 
                RowBox[{
                  SubscriptBox[
                    OverscriptBox["S", "~"], "3"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              RowBox[{"8", " ", 
                RowBox[{
                  SubscriptBox[
                    OverscriptBox["S", "~"], "12"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "-", 
              FractionBox["107", 
                RowBox[{"9", " ", "m"}]], "+", 
              FractionBox["241", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
              FractionBox["58", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "-", 
              FractionBox["86", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              FractionBox["8", 
                SuperscriptBox["m", "3"]], "-", 
              FractionBox["48", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]], "-", 
              FractionBox["16", "3"]}], ")"}], " ", 
          SubsuperscriptBox["C", "A", "2"]}], "+", 
        RowBox[{"32", " ", 
          SubscriptBox["T", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  FractionBox["5", "9"]}], " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox[
                    RowBox[{"m", "-", "1"}],
                    "TraditionalForm"], ")"}]}], "+", 
              FractionBox["14", 
                RowBox[{"9", " ", "m"}]], "-", 
              FractionBox["19", 
                RowBox[{"9", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
              FractionBox["1", 
                RowBox[{"3", " ", 
                  SuperscriptBox["m", "2"]}]], "-", 
              FractionBox["1", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "+", 
              FractionBox["1", "3"]}], ")"}], " ", 
          SubscriptBox["C", "A"]}], "+", 
        RowBox[{"8", " ", 
          SubscriptBox["C", "F"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox["10", 
                  RowBox[{"m", "+", "1"}]]}], "+", 
              FractionBox["2", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
              FractionBox["4", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", "1", "+", 
              FractionBox["10", "m"], "-", 
              FractionBox["10", 
                SuperscriptBox["m", "2"]], "+", 
              FractionBox["4", 
                SuperscriptBox["m", "3"]]}], ")"}], " ", 
          SubscriptBox["T", "f"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Gamma]", 
          RowBox[{"S", ",", "gg", " "}], 
          RowBox[{"(", "1", ")", " "}]], TraditionalForm]]],
  "polarized (different representation)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AnomalousDimension", "[", "GSGG1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{
                    RowBox[{"m", " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{"m", " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{"m", " ", 
                                  RowBox[{"(", 
                                    RowBox[{
                                      RowBox[{"m", " ", 
                                        RowBox[{"(", 
                                        RowBox[{
                                        RowBox[{"48", " ", "m", " ", 
                                        RowBox[{"(", 
                                        RowBox[{"m", "+", "3"}], ")"}]}], 
                                        "+", "469"}], ")"}]}], "+", "698"}], 
                                    ")"}]}], "+", "7"}], ")"}]}], "+", 
                          "258"}], ")"}]}], "+", "144"}], 
                  RowBox[{"9", " ", 
                    SuperscriptBox["m", "3"], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{"m", "+", "1"}], ")"}], "3"]}]]}], "+", 
              FractionBox[
                RowBox[{"8", " ", 
                  RowBox[{
                    SubsuperscriptBox["S", "2", "'"], "\[NoBreak]", "(", 
                    "\[NoBreak]", 
                    FormBox[
                      FractionBox["m", "2"],
                      "TraditionalForm"], "\[NoBreak]", ")"}]}], 
                RowBox[{"m", " ", 
                  RowBox[{"(", 
                    RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
              RowBox[{
                SubsuperscriptBox["S", "3", "'"], "\[NoBreak]", "(", 
                "\[NoBreak]", 
                FormBox[
                  FractionBox["m", "2"],
                  "TraditionalForm"], "\[NoBreak]", ")"}], "+", 
              FractionBox[
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"m", " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"67", " ", "m", " ", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{"m", "+", "1"}], ")"}], "2"]}], 
                            "+", "144"}], ")"}]}], "+", "72"}], ")"}], " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox["m",
                      "TraditionalForm"], ")"}]}], 
                RowBox[{"9", " ", 
                  SuperscriptBox["m", "2"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              RowBox[{"4", " ", 
                RowBox[{
                  SubsuperscriptBox["S", "2", "'"], "\[NoBreak]", "(", 
                  "\[NoBreak]", 
                  FormBox[
                    FractionBox["m", "2"],
                    "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
                RowBox[{
                  SubscriptBox["S", "1"], "(", 
                  FormBox["m",
                    "TraditionalForm"], ")"}]}], "+", 
              RowBox[{"8", " ", 
                RowBox[{
                  OverscriptBox["S", "~"], "(", 
                  FormBox["m",
                    "TraditionalForm"], ")"}]}]}], ")"}], " ", 
          SubsuperscriptBox["C", "A", "2"]}], "+", 
        RowBox[{"32", " ", 
          SubscriptBox["T", "f"], " ", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{
                  RowBox[{"m", " ", 
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"3", " ", "m", " ", 
                          RowBox[{"(", 
                            RowBox[{"m", "+", "1"}], ")"}]}], "+", "13"}], 
                      ")"}]}], "-", "3"}], 
                RowBox[{"9", " ", 
                  SuperscriptBox["m", "2"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
              FractionBox[
                RowBox[{"5", " ", 
                  RowBox[{
                    SubscriptBox["S", "1"], "(", 
                    FormBox["m",
                      "TraditionalForm"], ")"}]}], "9"]}], ")"}], " ", 
          SubscriptBox["C", "A"]}], "+", 
        FractionBox[
          RowBox[{"8", " ", 
            SubscriptBox["C", "F"], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"m", " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"m", " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"m", " ", 
                              RowBox[{"(", 
                                RowBox[{
                                  RowBox[{"m", " ", 
                                    RowBox[{"(", 
                                      RowBox[{
                                        RowBox[{"m", " ", 
                                        RowBox[{"(", 
                                        RowBox[{"m", "+", "3"}], ")"}]}], 
                                        "+", "5"}], ")"}]}], "+", "1"}], 
                                ")"}]}], "-", "8"}], ")"}]}], "+", "2"}], 
                    ")"}]}], "+", "4"}], ")"}], " ", 
            SubscriptBox["T", "f"]}], 
          RowBox[{
            SuperscriptBox["m", "3"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}], "3"]}]]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Check that all odd moments give the same for the two representations of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Gamma]", 
            RowBox[{"S", ",", "gg", " "}], 
            RowBox[{"(", "1", ")", " "}]], "."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell["Table[(%-%%)/.OPEm->ij, {ij,1,17,2}]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
          "0", ",", "0"}], "}"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Anti5", "Section",
  CellTags->"Anti5"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "Anti5[exp] anticommutes all ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  "in exp to the right. Anti5[exp, n] anticommutes all ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", 
          RowBox[{"5", " "}]], TraditionalForm]]],
  "n times to the right.\nAnti5[exp, -n] anticommutes all ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  " n times to the left."
}], "Text"],

Cell[TextData[{
  "The naive ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  "scheme is used."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracOrder",
    ButtonData:>"DiracOrder",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracOrder"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracMatrix", "[", 
        RowBox[{"5", ",", "\[Mu]"}], "]"}], "  "}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", 
      RowBox[{"%", ",", 
        RowBox[{"-", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracMatrix", "[", 
      RowBox[{
      "5", ",", "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", 
        "\[Delta]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], 
        SuperscriptBox["\[Gamma]", "\[Alpha]"], 
        SuperscriptBox["\[Gamma]", "\[Beta]"], 
        SuperscriptBox["\[Gamma]", "\[Gamma]"], 
        SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", 
      RowBox[{"%", ",", "2"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Gamma]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", 
      RowBox[{"%%", ",", "Infinity"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Gamma]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Delta]"], " ", 
        SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", 
      RowBox[{"%", ",", 
        RowBox[{"-", "Infinity"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Gamma]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the naive ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", "5"}], "-"}], TraditionalForm]]],
  "scheme D-dimensional \[Gamma]-matrices anticommute with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", "^", "5"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "[", 
      RowBox[{"5", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell["\<\
Setting the global variable $FCT to False restores the default \
typesetting 
rules for the noncommutative multiplication operator Dot[].\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"$FCT", " ", "=", " ", "False"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "[", 
      RowBox[{"5", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], ".", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Anti5", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
          SuperscriptBox["\[Gamma]", "5"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"$FCT", " ", "=", " ", "True"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AntiCommutator", "Section",
  CellTags->"AntiCommutator"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
AntiCommutator[x, y] = c  defines the anti-commutator of the non \
commuting 
objects x and y.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Commutator",
    ButtonData:>"Commutator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Commutator"],
  ", ",
  ButtonBox["CommutatorExplicit",
    ButtonData:>"CommutatorExplicit",
    ButtonStyle->"Hyperlink",
    ButtonNote->"CommutatorExplicit"],
  ", ",
  ButtonBox["DeclareNonCommutative",
    ButtonData:>"DeclareNonCommutative",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DeclareNonCommutative"],
  ", ",
  ButtonBox["DotSimplify",
    ButtonData:>"DotSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DotSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "This declares ",
  StyleBox["a",
    FontFamily->"Courier"],
  " and ",
  StyleBox["b",
    FontFamily->"Courier"],
  " as  noncommutative variables."
}], "Text"],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AntiCommutator", "[", 
      RowBox[{"a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", "a", ",", "\[MediumSpace]", "b", "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b"}], "+", 
        RowBox[{"b", " ", "a"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CommutatorExplicit", "[", 
      RowBox[{"AntiCommutator", "[", 
        RowBox[{
          RowBox[{"a", "+", "b"}], ",", 
          RowBox[{
            RowBox[{"a", "-", 
              RowBox[{"2", "b"}]}], " "}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "-", 
              RowBox[{"2", " ", "b"}]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{"a", "-", 
              RowBox[{"2", " ", "b"}]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", 
      RowBox[{"AntiCommutator", "[", 
        RowBox[{
          RowBox[{"a", "+", "b"}], ",", 
          RowBox[{
            RowBox[{"a", "-", 
              RowBox[{"2", "b"}]}], " "}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"b", " ", "a"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"c", ",", "d", ",", 
        OverscriptBox["c", "~"], ",", 
        OverscriptBox["d", "~"]}], "]"}]], "Input"],

Cell["Defining {c,d} = z results in replacements of c.d by z-d.c.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{"c", ",", "d"}], "]"}], " ", "=", " ", "z"}]], "Input"],

Cell[BoxData[
    FormBox["z", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", " ", 
      RowBox[{"d", " ", ".", " ", "c", " ", ".", "  ", "d"}], " ", "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"d", " ", "z"}], "-", 
        RowBox[{
          SuperscriptBox["d", "2"], " ", "c"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{
          OverscriptBox["d", "~"], ",", 
          OverscriptBox["c", "~"]}], "]"}], " ", "=", " ", 
      OverscriptBox["z", "~"]}]], "Input"],

Cell[BoxData[
    FormBox[
      OverscriptBox["z", "~"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", " ", 
      RowBox[{
        OverscriptBox["d", "~"], " ", ".", " ", 
        OverscriptBox["c", "~"], " ", ".", "  ", 
        OverscriptBox["d", "~"]}], " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          OverscriptBox["d", "~"], " ", 
          OverscriptBox["z", "~"]}], "-", 
        RowBox[{
          OverscriptBox["c", "~"], " ", 
          SuperscriptBox[
            OverscriptBox["d", "~"], "2"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", 
        OverscriptBox["c", "~"], ",", 
        OverscriptBox["d", "~"]}], "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{"c", ",", "d"}], "]"}], "=", "."}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{
          OverscriptBox["d", "~"], ",", 
          OverscriptBox["c", "~"]}], "]"}], "=", "."}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AntiQuarkField", "Section",
  CellTags->"AntiQuarkField"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
AntiQuarkField is the name of a fermionic field. AntiQuarkField is \
just a 
name with no functional properties. Only typeset rules are attached.\
\>", 
  "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["QuantumField",
    ButtonData:>"QuantumField",
    ButtonStyle->"Hyperlink",
    ButtonNote->"QuantumField"],
  ", ",
  ButtonBox["QuarkField",
    ButtonData:>"QuarkField",
    ButtonStyle->"Hyperlink",
    ButtonNote->"QuarkField"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData["AntiQuarkField"], "Input"],

Cell[BoxData[
    FormBox[
      OverscriptBox["\[Psi]", "_"], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apart1", "Section",
  CellTags->"Apart1"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Apart1[expr, x] is equivalent to Apart[expr, x], but it is faster \
than Apart 
if explicit complex numbers (I's) are in exp.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Apart2",
    ButtonData:>"Apart2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Apart2"],
  ", ",
  ButtonBox["Apart3",
    ButtonData:>"Apart3",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Apart3"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["\<\

t = 1/4*(1 - x)^4*x*(21 + 13*x + 3*x^2) - 
1/24*11*I*Pi*(1 - x)^4*x*(21 + 13*x + 3*x^2) + 
((1 - x)^4*x^2*(21 + 13*x + 3*x^2))/(36*(-1 + x)^4) - 
(I*Pi*(1 - x)^4*x^2*(21 + 13*x + 3*x^2))/
(12*(-1 + x)^4) - (7*(1 - x)^4*x^3*(21 + 13*x + 3*x^2))/ (48*(-1 + x)^4) + \
(3*I*Pi*(1 - x)^4*x^3*
(21 + 13*x + 3*x^2))/(8*(-1 + x)^4) + 
(11*(1 - x)^4*x^4*(21 + 13*x + 3*x^2))/(24*(-1 + x)^4) - 
(3*I*Pi*(1 - x)^4*x^4*(21 + 13*x + 3*x^2))/
(4*(-1 + x)^4) - (49*(1 - x)^4*x^5*(21 + 13*x + 3*x^2))/
(144*(-1 + x)^4) + (11*I*Pi*(1 - x)^4*x^5*
(21 + 13*x + 3*x^2))/(24*(-1 + x)^4) + 
1/4*(1 - x)^4*x*(21 + 13*x + 3*x^2)*Zeta2 + 
11/24*(1 - x)^4*x*(21 + 13*x + 3*x^2)*Log[x] + 
1/4*I*Pi*(1 - x)^4*x*(21 + 13*x + 3*x^2)*Log[x] + 
((1 - x)^4*x^2*(21 + 13*x + 3*x^2)*Log[x])/
(12*(-1 + x)^4) - (3*(1 - x)^4*x^3*(21 + 13*x + 3*x^2)*
Log[x])/(8*(-1 + x)^4) + 
(3*(1 - x)^4*x^4*(21 + 13*x + 3*x^2)*Log[x])/
(4*(-1 + x)^4); 
\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Timing", "[", 
      RowBox[{
        RowBox[{"a1", "=", 
          RowBox[{"Apart1", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"0.719999999999998863`", " ", "Second"}], ",", "Null"}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Timing", "[", 
      RowBox[{
        RowBox[{"a2", "=", 
          RowBox[{"Apart", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"3.53000000000000113`", " ", "Second"}], ",", "Null"}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a1", "-", "a2"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t", ",", "a1", ",", "a2"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apart2", "Section",
  CellTags->"Apart2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Apart2[expr] partial fractions FeynAmpDenominators (and \
FAD's).\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FAD",
    ButtonData:>"FAD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FAD"],
  ", ",
  ButtonBox["FeynAmpDenominator",
    ButtonData:>"FeynAmpDenominator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominator"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FAD", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"q", ",", "m"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "M"}], "}"}], ",", 
        RowBox[{"q", "-", "p"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"q", "-", "p"}], ")"}], "2"], 
                "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ 
                  Plus[ 
                    Times[ -1, p], q], 2], "]"],
              Editable->False], ")"}], " ", 
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"-\"\>", 
                "\[InvisibleSpace]", 
                SuperscriptBox["m", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ q, 2], "-", 
                Power[ m, 2], "]"],
              Editable->False], ")"}], " ", 
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"-\"\>", 
                "\[InvisibleSpace]", 
                SuperscriptBox["M", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ q, 2], "-", 
                Power[ M, 2], "]"],
              Editable->False], ")"}]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Apart2", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox["m", "2"], "-", 
                SuperscriptBox["M", "2"]}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["m", "2"]}], ")"}], " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"q", "-", "p"}], ")"}], "2"]}], ")"}]}]], "-", 
        FractionBox["1", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox["m", "2"], "-", 
                SuperscriptBox["M", "2"]}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["M", "2"]}], ")"}], " ", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"q", "-", "p"}], ")"}], "2"]}], ")"}]}]]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FCE", "[", "%", "]"}], "]"}]], "Input"],

Cell["\<\
FAD[{q, m}, -p + q]/(m^2 - M^2) - 
  FAD[{q, M}, -p + q]/(m^2 - M^2)\
\>", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Apart3", "Section",
  CellTags->"Apart3"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Apart3[expr, x] is equivalent to Map2[Factor2, \
Collect2[Apart1[expr,x],x]].\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Apart1",
    ButtonData:>"Apart1",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Apart1"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[BoxData[
    RowBox[{
      RowBox[{"t", "=", 
        RowBox[{
          RowBox[{
            RowBox[{"1", "/", "4"}], " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", "x", " ", 
            RowBox[{"(", 
              RowBox[{"21", "+", 
                RowBox[{"13", " ", "x"}], "+", 
                RowBox[{"3", " ", 
                  RowBox[{"x", "^", "2"}]}]}], ")"}]}], "-", 
          RowBox[{
            RowBox[{"11", "/", "24"}], " ", "I", " ", "\[Pi]", " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", "x", " ", 
            RowBox[{"(", 
              RowBox[{"21", "+", 
                RowBox[{"13", " ", "x"}], "+", 
                RowBox[{"3", " ", 
                  RowBox[{"x", "^", "2"}]}]}], ")"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "2"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"36", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "-", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"I", " ", "\[Pi]", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "2"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"12", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "-", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"7", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "3"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"48", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"3", " ", "I", " ", "\[Pi]", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "3"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"8", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"11", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "4"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"24", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "-", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"3", " ", "I", " ", "\[Pi]", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "4"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"4", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "-", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"49", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "5"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"144", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"11", " ", "I", " ", "\[Pi]", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "5"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"24", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "+", 
          RowBox[{
            RowBox[{"1", "/", "4"}], " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", "x", " ", 
            RowBox[{"(", 
              RowBox[{"21", "+", 
                RowBox[{"13", " ", "x"}], "+", 
                RowBox[{"3", " ", 
                  RowBox[{"x", "^", "2"}]}]}], ")"}], " ", "Zeta2"}], "+", 
          RowBox[{
            RowBox[{"11", "/", "24"}], " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", "x", " ", 
            RowBox[{"(", 
              RowBox[{"21", "+", 
                RowBox[{"13", " ", "x"}], "+", 
                RowBox[{"3", " ", 
                  RowBox[{"x", "^", "2"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", "x", "]"}]}], "+", 
          RowBox[{
            RowBox[{"1", "/", "4"}], " ", "I", " ", "\[Pi]", " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", "x", " ", 
            RowBox[{"(", 
              RowBox[{"21", "+", 
                RowBox[{"13", " ", "x"}], "+", 
                RowBox[{"3", " ", 
                  RowBox[{"x", "^", "2"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", "x", "]"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "2"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}], " ", 
                RowBox[{"Log", "[", "x", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"12", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "-", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"3", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "3"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}], " ", 
                RowBox[{"Log", "[", "x", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"8", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}], "+", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"3", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"1", "-", "x"}], ")"}], "^", "4"}], " ", 
                RowBox[{"x", "^", "4"}], " ", 
                RowBox[{"(", 
                  RowBox[{"21", "+", 
                    RowBox[{"13", " ", "x"}], "+", 
                    RowBox[{"3", " ", 
                      RowBox[{"x", "^", "2"}]}]}], ")"}], " ", 
                RowBox[{"Log", "[", "x", "]"}]}], ")"}], "/", 
            RowBox[{"(", 
              RowBox[{"4", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", "1"}], "+", "x"}], ")"}], "^", "4"}]}], 
              ")"}]}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Timing", "[", 
      RowBox[{
        RowBox[{"a1", "=", 
          RowBox[{"Apart3", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"1.05000000000000071`", " ", "Second"}], ",", "Null"}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Timing", "[", 
      RowBox[{
        RowBox[{"a2", "=", 
          RowBox[{"Apart", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"3.51999999999999957`", " ", "Second"}], ",", "Null"}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a1", "-", "a2"}], "//", "Expand"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t", ",", "a1", ",", "a2"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["B00", "Section",
  CellTags->"B00"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"B00", "[", 
          RowBox[{"pp", ",", 
            SubsuperscriptBox["m", "1", "2"], ",", 
            SubsuperscriptBox["m", "2", "2"]}], "]"}], TraditionalForm]]],
  " is the Passarino - Veltman ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["B", "00"], TraditionalForm]]],
  "-function, i.e., the coefficient function of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"g", "^", 
          RowBox[{"(", 
            RowBox[{"\[Mu]", "\[Nu]"}], ")"}]}], TraditionalForm]]],
  ". All arguments are scalars and have dimension  mass",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Null]", "2"], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "B00", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["B1",
    ButtonData:>"B1",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B1"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "Remember that SP[p] is a short hand input for ScalarProduct[p,p], i.e. ",
  Cell[BoxData[
      FormBox[
        RowBox[{"p", "^", "2."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SP", "[", "p", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], "2"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B00", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["M", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        RowBox[{
          FractionBox["1", "18"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"3", " ", 
                SuperscriptBox["m", "2"]}], "+", 
              RowBox[{"3", " ", 
                SuperscriptBox["M", "2"]}], "-", 
              FormBox[
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "2"],
                "TraditionalForm"]}], ")"}]}], "+", 
        RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["M", "2"], ",", 
                  SuperscriptBox["M", "2"], ")"}], " ", 
                SuperscriptBox["M", "2"]}], "+", 
              SuperscriptBox["M", "2"], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    FractionBox[
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            SuperscriptBox["M", "2"], "-", 
                            SuperscriptBox["m", "2"]}], ")"}], " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              SubscriptBox["B", "0"], "(", 
                              FormBox[
                                SuperscriptBox[
                                  FormBox["p",
                                    "TraditionalForm"], "2"],
                                "TraditionalForm"], ",", 
                              SuperscriptBox["m", "2"], ",", 
                              SuperscriptBox["M", "2"], ")"}], "-", 
                            RowBox[{
                              SubscriptBox["B", "0"], "(", "0", ",", 
                              SuperscriptBox["m", "2"], ",", 
                              SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
                      RowBox[{"2", " ", 
                        FormBox[
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], "2"],
                          "TraditionalForm"]}]], "-", 
                    RowBox[{
                      FractionBox["1", "2"], " ", 
                      RowBox[{
                        SubscriptBox["B", "0"], "(", 
                        FormBox[
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], "2"],
                          "TraditionalForm"], ",", 
                        SuperscriptBox["m", "2"], ",", 
                        SuperscriptBox["M", "2"], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["m", "2"], "-", 
                    SuperscriptBox["M", "2"], "+", 
                    FormBox[
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"],
                      "TraditionalForm"]}], ")"}]}]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B00", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["m", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        RowBox[{
          FractionBox["1", "18"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"6", " ", 
                SuperscriptBox["m", "2"]}], "-", 
              FormBox[
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "2"],
                "TraditionalForm"]}], ")"}]}], "+", 
        RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}], " ", 
                SuperscriptBox["m", "2"]}], "+", 
              SuperscriptBox["m", "2"], "-", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B00", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}], ",", 
        RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"B\"\>", "\<\"00\"\>"],
          "TraditionalForm"], "(", 
        FormBox[
          FormBox[
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"],
            "TraditionalForm"],
          "TraditionalForm"], 
        RowBox[{",", " "}], 
        FormBox[
          SuperscriptBox["m", "2"],
          "TraditionalForm"], 
        RowBox[{",", " "}], 
        FormBox[
          SuperscriptBox["M", "2"],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B00", "[", 
      RowBox[{"0", ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", "0", ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["m", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        FractionBox[
          SuperscriptBox["m", "2"], "3"], "+", 
        RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}], " ", 
                SuperscriptBox["m", "2"]}], "+", 
              SuperscriptBox["m", "2"]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B00", "[", 
      RowBox[{
        RowBox[{"SmallVariable", "[", 
          RowBox[{"M", "^", "2"}], "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", 
            SuperscriptBox["M", "2"], ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["m", "2"], ")"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
        FractionBox[
          SuperscriptBox["m", "2"], "3"], "+", 
        RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}], " ", 
                SuperscriptBox["m", "2"]}], "+", 
              SuperscriptBox["m", "2"]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["B0", "Section",
  CellTags->"B0"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{"B0", 
              RowBox[{"[", 
                RowBox[{
                  RowBox[{"p", "^", "2"}], ",", 
                  SubsuperscriptBox["m", "1", "2"]}]}]}],
            "TraditionalForm"], ",", 
          SubsuperscriptBox["m", "2", "2"]}], TraditionalForm]]],
  "] is the Passarino - Veltman two-point integral ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["B", "0"], TraditionalForm]]],
  ". All arguments are scalars and have dimension mass^2.\nIf the option   \
BReduce is set to True certain B0's are reduced to A0's.\nSetting the option  \
 B0Unique to True simplifies B0[a,0,a] and B0[0,0,a]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "B0", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"BReduce", "\[Rule]", "False"}], ",", 
          RowBox[{"B0Unique", "\[Rule]", "False"}], ",", 
          RowBox[{"B0Real", "\[Rule]", "False"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B1",
    ButtonData:>"B1",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B1"],
  ", ",
  ButtonBox["B00",
    ButtonData:>"B00",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B00"],
  ", ",
  ButtonBox["B11",
    ButtonData:>"B11",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B11"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B0", "[", 
      RowBox[{
        RowBox[{"SP", "[", 
          RowBox[{"p", ",", "p"}], "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["B", "0"], "(", 
        FormBox[
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"],
          "TraditionalForm"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"B0", ",", 
          RowBox[{"B0Unique", "\[Rule]", "True"}], ",", 
          RowBox[{"B0Real", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B0", "[", 
      RowBox[{"0", ",", "0", ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["B", "0"], "(", "0", ",", 
          SuperscriptBox["m", "2"], ",", 
          SuperscriptBox["m", "2"], ")"}], "+", "1"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B0", "[", 
      RowBox[{
        RowBox[{"m", "^", "2"}], ",", "0", ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["B", "0"], "(", "0", ",", 
          SuperscriptBox["m", "2"], ",", 
          SuperscriptBox["m", "2"], ")"}], "+", "2"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B0", "[", 
      RowBox[{"0", ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["B11", "Section",
  CellTags->"B11"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"B11", "[", 
          RowBox[{"pp", ",", 
            SubsuperscriptBox["m", "1", "2"], ",", 
            SubsuperscriptBox["m", "2", "2"]}], "]"}], TraditionalForm]]],
  " is the Passarino - Veltman ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["B", "11"], TraditionalForm]]],
  "-function, i.e., the coefficient function of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"p", "^", "\[Mu]"}], 
          RowBox[{"p", "^", "\[Nu]"}]}], TraditionalForm]]],
  ". All arguments are scalars and have dimension  mass",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Null]", "2"], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "B11", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["B00",
    ButtonData:>"B00",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B00"],
  ", ",
  ButtonBox["B1",
    ButtonData:>"B1",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B1"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "Remember that SP[p] is a short hand input for ScalarProduct[p,p], i.e. ",
  Cell[BoxData[
      FormBox[
        RowBox[{"p", "^", "2."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SP", "[", "p", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], "2"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B11", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", 
          RowBox[{"3", " ", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"]}]], 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["M", "2"], ")"}]}], " ", 
              SuperscriptBox["m", "2"]}], "+", 
            SuperscriptBox["M", "2"], "+", 
            RowBox[{
              SuperscriptBox["M", "2"], " ", 
              RowBox[{
                SubscriptBox["B", "0"], "(", "0", ",", 
                SuperscriptBox["M", "2"], ",", 
                SuperscriptBox["M", "2"], ")"}]}], "+", 
            RowBox[{
              FractionBox["1", "6"], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["m", "2"]}], "-", 
                  RowBox[{"3", " ", 
                    SuperscriptBox["M", "2"]}], "+", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
              RowBox[{"(", 
                RowBox[{
                  FractionBox[
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox["M", "2"], "-", 
                          SuperscriptBox["m", "2"]}], ")"}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            SubscriptBox["B", "0"], "(", 
                            FormBox[
                              SuperscriptBox[
                                FormBox["p",
                                  "TraditionalForm"], "2"],
                              "TraditionalForm"], ",", 
                            SuperscriptBox["m", "2"], ",", 
                            SuperscriptBox["M", "2"], ")"}], "-", 
                          RowBox[{
                            SubscriptBox["B", "0"], "(", "0", ",", 
                            SuperscriptBox["m", "2"], ",", 
                            SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
                    RowBox[{"2", " ", 
                      FormBox[
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], "2"],
                        "TraditionalForm"]}]], "-", 
                  RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{
                      SubscriptBox["B", "0"], "(", 
                      FormBox[
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], "2"],
                        "TraditionalForm"], ",", 
                      SuperscriptBox["m", "2"], ",", 
                      SuperscriptBox["M", "2"], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["m", "2"], "-", 
                  SuperscriptBox["M", "2"], "+", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}], ")"}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B11", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{
            RowBox[{
              SubscriptBox["B", "0"], "(", "0", ",", 
              SuperscriptBox["m", "2"], ",", 
              SuperscriptBox["m", "2"], ")"}], " ", 
            SuperscriptBox["m", "2"]}], "+", 
          SuperscriptBox["m", "2"], "+", 
          RowBox[{
            FractionBox["1", "6"], " ", 
            RowBox[{"(", 
              RowBox[{
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"], "-", 
                RowBox[{"6", " ", 
                  SuperscriptBox["m", "2"]}]}], ")"}]}], "+", 
          RowBox[{
            RowBox[{
              SubscriptBox["B", "0"], "(", 
              FormBox[
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "2"],
                "TraditionalForm"], ",", 
              SuperscriptBox["m", "2"], ",", 
              SuperscriptBox["m", "2"], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"], "-", 
                SuperscriptBox["m", "2"]}], ")"}]}]}], 
        RowBox[{"3", " ", 
          FormBox[
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SetOptions", "[", 
      RowBox[{"B11", ",", 
        RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"BReduce", "\[Rule]", "False"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B11", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"B\"\>", "\<\"11\"\>"],
          "TraditionalForm"], "(", 
        FormBox[
          FormBox[
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"],
            "TraditionalForm"],
          "TraditionalForm"], 
        RowBox[{",", " "}], 
        FormBox[
          SuperscriptBox["m", "2"],
          "TraditionalForm"], 
        RowBox[{",", " "}], 
        FormBox[
          SuperscriptBox["M", "2"],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SetOptions", "[", 
      RowBox[{"B11", ",", 
        RowBox[{"BReduce", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B11", "[", 
      RowBox[{"0", ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{
          SubscriptBox["B", "0"], "(", "0", ",", 
          SuperscriptBox["m", "2"], ",", 
          SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B11", "[", 
      RowBox[{
        RowBox[{"SmallVariable", "[", 
          RowBox[{"M", "^", "2"}], "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{
          SubscriptBox["B", "0"], "(", 
          SuperscriptBox["M", "2"], ",", 
          SuperscriptBox["m", "2"], ",", 
          SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["B1", "Section",
  CellTags->"B1"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"B1", 
          RowBox[{"[", 
            RowBox[{
              RowBox[{"p", "^", "2"}], ",", 
              SubsuperscriptBox["m", "1", "2"], ",", 
              SubsuperscriptBox["m", "2", "2"]}]}]}], TraditionalForm]]],
  "] is the Passarino - Veltman ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["B", "1"], TraditionalForm]]],
  "-function. All arguments are scalars and have dimension ",
  Cell[BoxData[
      FormBox[
        RowBox[{"mass", "^", "2."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "B1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["B00",
    ButtonData:>"B00",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B00"],
  ", ",
  ButtonBox["B11",
    ButtonData:>"B11",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B11"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  ", ",
  ButtonBox["PaVeReduce",
    ButtonData:>"PaVeReduce",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVeReduce"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox["M", "2"], "-", 
                SuperscriptBox["m", "2"]}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["M", "2"], ")"}], "-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
          RowBox[{"2", " ", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"]}]], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["M", "2"], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"M", "^", "2"}], ",", 
        RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["B", "1"], "(", 
        FormBox[
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"],
          "TraditionalForm"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"B1", ",", 
          RowBox[{"BReduce", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{
        RowBox[{"SP", "[", "p", "]"}], ",", 
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
        RowBox[{
          SubscriptBox["B", "0"], "(", 
          FormBox[
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"],
            "TraditionalForm"], ",", 
          SuperscriptBox["m", "2"], ",", 
          SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{
        RowBox[{"m", "^", "2"}], ",", 
        RowBox[{"m", "^", "2"}], ",", "0"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}]}], "-", "2"}], ")"}]}], 
        "-", 
        FractionBox["1", "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{"0", ",", "0", ",", 
        RowBox[{"m", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SuperscriptBox["m", "2"], ",", 
                  SuperscriptBox["m", "2"], ")"}]}], "-", "1"}], ")"}]}], 
        "+", 
        FractionBox["1", "4"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{"pp", ",", 
        RowBox[{"SmallVariable", "[", 
          SubsuperscriptBox["m", "e", "2"], "]"}], ",", 
        SubsuperscriptBox["m", "2", "2"]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["B", "0"], "(", "pp", ",", 
                  SubsuperscriptBox["m", "e", "2"], ",", 
                  SubsuperscriptBox["m", "2", "2"], ")"}], "-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SubsuperscriptBox["m", "e", "2"], ",", 
                  SubsuperscriptBox["m", "2", "2"], ")"}]}], ")"}], " ", 
            SubsuperscriptBox["m", "2", "2"]}], 
          RowBox[{"2", " ", "pp"}]], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
            SubscriptBox["B", "0"], "(", "pp", ",", 
            SubsuperscriptBox["m", "e", "2"], ",", 
            SubsuperscriptBox["m", "2", "2"], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"B1", "[", 
      RowBox[{
        RowBox[{"SmallVariable", "[", 
          SubsuperscriptBox["m", "e", "2"], "]"}], ",", 
        RowBox[{"SmallVariable", "[", 
          SubsuperscriptBox["m", "e", "2"], "]"}], ",", "0"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  SubscriptBox["B", "0"], "(", "0", ",", 
                  SubsuperscriptBox["m", "e", "2"], ",", 
                  SubsuperscriptBox["m", "e", "2"], ")"}]}], "-", "2"}], 
            ")"}]}], "-", 
        FractionBox["1", "2"]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BackgroundGluonVertex", "Section",
  CellTags->"BackgroundGluonVertex"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "BackgroundGluonVertex[{p,\[Mu],a}, {q,\[Nu],b}, {k,\[Lambda],c}] or \n\
BackgroundGluonVertex[ p,\[Mu],a ,  q,\[Nu],b ,  k,\[Lambda],c ] yields the   \
3-gluon vertex in the background field gauge, where the first set of   \
arguments corresponds to the external background field. \n\
BackgroundGluonVertex[{p,\[Mu],a}, {q,\[Nu],b}, {k,\[Lambda],c},   \
{s,\[Sigma],d}]  or\nBackgroundGluonVertex[{\[Mu],a}, {\[Nu],b},   \
{\[Lambda],c}, {\[Sigma],d}] or  \nBackgroundGluonVertex[p,\[Mu],a ,    q,\
\[Nu],b ,  k,\[Lambda],c ,  s,\[Sigma],d] or  \nBackgroundGluonVertex[   \
\[Mu],a ,  \[Nu],b ,  \[Lambda],c ,  \[Sigma],d ] yields the  4-gluon vertex, \
  with {p,\[Mu],a} and {k,\[Lambda],c} denoting the external background  \
fields. \nThe gauge, dimension  and the name of the coupling constant are  \
determined  by the options Gauge, Dimension and CouplingConstant.\nThe  \
Feynman rules are  taken from L.Abbot ",
  StyleBox["NPB ",
    FontWeight->"Bold"],
  "185 (1981), 189-203;  except that all momenta are incoming. Note that   \
Abbots coupling constant convention is consistent with the default setting of \
  GluonVertex."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "BackgroundGluonVertex", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
          RowBox[{"CouplingConstant", "\[Rule]", 
            SubscriptBox["g", "s"]}], ",", 
          RowBox[{"Gauge", "\[Rule]", "1"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["GluonVertex",
    ButtonData:>"GluonVertex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GluonVertex"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"BackgroundGluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{
                        RowBox[{"-", "k"}], "+", "p", "-", "q"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"q", "-", "k"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"k", "-", "p", "+", "q"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"BackgroundGluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "+", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"BackgroundGluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
        RowBox[{"Gauge", "\[Rule]", "\[Alpha]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{"p", "-", "q"}], ")"}], "-", 
                        FractionBox["k", "\[Alpha]"]}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"q", "-", "k"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Lambda]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{"k", "-", "p"}], ")"}], "+", 
                        FractionBox["q", "\[Alpha]"]}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"BackgroundGluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}], ",", 
        RowBox[{"Gauge", "\[Rule]", "\[Alpha]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Lambda]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Sigma]",
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "\[Alpha]"], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  FractionBox[
                    RowBox[{
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Lambda]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Sigma]",
                              "TraditionalForm"],
                            "TraditionalForm"]}]], " ", 
                      SuperscriptBox["g", 
                        RowBox[{
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]}]]}], "\[Alpha]"], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "+", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Lambda]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u7",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["C0", "Section",
  CellTags->"C0"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "C0[p10, p12, p20, m1^2, m2^2, m3^2] is the scalar Passarino - Veltman ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["C", "0"], TraditionalForm]]],
  "function.  The convention for the arguments is that if the denominator of  \
the integrand has the form ([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2]), the  \
first three arguments of C0 are the scalar products p10 = p1^2, p12 =  \
(p1-p2).(p1-p2), p20 = p2^2."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["D0",
    ButtonData:>"D0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"D0"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  ", ",
  ButtonBox["PaVeOrder",
    ButtonData:>"PaVeOrder",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVeOrder"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"C0", "[", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", " ", "m12", ",", "m22", ",", "m32"}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "a", ",", "b", ",", "c", ",", "m12", ",", 
        "m22", ",", "m32", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"C0", "[", 
        RowBox[{
        "b", ",", "a", ",", "c", ",", "m32", ",", "m22", ",", "m12"}], "]"}], 
      "//", "PaVeOrder"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "a", ",", "b", ",", "c", ",", "m12", ",", 
        "m22", ",", "m32", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PaVeOrder", "[", 
      RowBox[{
        RowBox[{"C0", "[", 
          RowBox[{
          "b", ",", "a", ",", "c", ",", "m32", ",", "m22", ",", "m12"}], 
          "]"}], ",", 
        RowBox[{"PaVeOrderList", "->", 
          RowBox[{"{", 
            RowBox[{"c", ",", "a"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "b", ",", "c", ",", "a", ",", "m22", ",", 
        "m32", ",", "m12", ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calc", "Section",
  CellTags->"Calc"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Calc[exp] performs several basic simplifications. 
Calc[exp] is the same as 
DotSimplify[DiracSimplify[Contract[DiracSimplify[Explicit[ 
SUNSimplify[Trick[exp],  Explicit->False] ]]]]]\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  ", ",
  ButtonBox["Trick",
    ButtonData:>"Trick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Trick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsection"],

Cell[TextData[{
  "This calculates ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", "\[Mu]"}], 
          SubscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]]],
  " in 4 dimensions and ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["g", "\[Nu]", "\[Nu]"], TraditionalForm]]],
  " in D dimensions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"GA", "[", 
            RowBox[{"\[Mu]", ",", "\[Mu]"}], "]"}], ",", " ", 
          RowBox[{"MTD", "[", 
            RowBox[{"\[Nu]", ",", "\[Nu]"}], "]"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"4", ",", "D"}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This simplifies ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["f", "abc"], " ", 
          RowBox[{
            SubscriptBox["f", "abe"], "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{
        RowBox[{"SUNF", "[", 
          RowBox[{"a", ",", "b", ",", "c"}], "]"}], " ", 
        RowBox[{"SUNF", "[", 
          RowBox[{"a", ",", "b", ",", "e"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["C", "A"], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FV", "[", 
        RowBox[{
          RowBox[{"p", "+", "r"}], ",", "\[Mu]"}], "]"}], " ", 
      RowBox[{"MT", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
      RowBox[{"FV", "[", 
        RowBox[{
          RowBox[{"q", "-", "p"}], ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{"q", "-", "p"}],
                "TraditionalForm"], ")"}], "\[Nu]"], ")"}], " ", 
        RowBox[{"(", 
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{"p", "+", "r"}],
                "TraditionalForm"], ")"}], "\[Mu]"], ")"}], " ", 
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          FormBox["p",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], "-", 
        RowBox[{
          FormBox["p",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["r",
            "TraditionalForm"]}], "+", 
        RowBox[{
          FormBox["q",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["r",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GluonVertex", "[", 
      RowBox[{"p", ",", "1", ",", "q", ",", "2", ",", 
        RowBox[{
          RowBox[{"-", "p"}], "-", "q"}], ",", "3"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{
          SuperscriptBox["V", 
            RowBox[{
              FormBox[
                FormBox["li1",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["li2",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["li3",
                  "TraditionalForm"],
                "TraditionalForm"]}]], "(", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], 
            RowBox[{",", " "}], 
            FormBox["q",
              "TraditionalForm"], 
            RowBox[{",", " "}], 
            FormBox[
              RowBox[{
                RowBox[{"-", "p"}], "-", "q"}],
              "TraditionalForm"]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["ci1",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["ci2",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["ci3",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{
        RowBox[{"%", " ", 
          RowBox[{"FVD", "[", 
            RowBox[{"p", ",", "li1"}], "]"}]}], " ", 
        RowBox[{"FVD", "[", 
          RowBox[{"q", ",", "li2"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"-", "p"}], "-", "q"}], ",", "li3"}], "]"}]}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CA", "Section",
  CellTags->"CA"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["CA is one of the Casimir operators of SU(N) (CA = N).", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["CF",
    ButtonData:>"CF",
    ButtonStyle->"Hyperlink",
    ButtonNote->"CF"],
  ", ",
  ButtonBox["SUNSimplify",
    ButtonData:>"SUNSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SUNSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData["CA"], "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["C", "A"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SUNSimplify", "[", 
      RowBox[{"CA", ",", 
        RowBox[{"SUNNToCACF", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["N", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["SUNN"], "Input"],

Cell[BoxData[
    FormBox["N", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cases2", "Section",
  CellTags->"Cases2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Cases2[expr, f] returns a list of all objects in expr with head f.
Cases2[expr,f] is equivalent to Cases2[{expr},f[___],Infinity]//Union.
Cases2[expr, f, g, ...] or Cases2[expr, {f,g, ...}] is equivalent to 
Cases[{expr},f[___] | g[___] ...] .\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Cases2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"f", "[", "a", "]"}], "+", 
          RowBox[{
            RowBox[{"f", "[", "b", "]"}], "^", "2"}], "+", 
          RowBox[{"f", "[", 
            RowBox[{"c", ",", "d"}], "]"}]}], ",", "f"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"f", "(", "a", ")"}], ",", 
          RowBox[{"f", "(", "b", ")"}], ",", 
          RowBox[{"f", "(", 
            RowBox[{"c", ",", "d"}], ")"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Cases2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], " ", 
            RowBox[{"Sin", "[", 
              RowBox[{"y", "-", "z"}], "]"}]}], "+", 
          RowBox[{"g", "[", "y", "]"}]}], ",", "Sin", ",", "g"}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"g", "(", "y", ")"}], ",", 
          RowBox[{"sin", "(", "x", ")"}], ",", 
          RowBox[{"sin", "(", 
            RowBox[{"y", "-", "z"}], ")"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Cases2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], " ", 
            RowBox[{"Sin", "[", 
              RowBox[{"y", "-", "z"}], "]"}]}], "+", 
          RowBox[{"g", "[", "x", "]"}], "+", 
          RowBox[{"g", "[", 
            RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"Sin", ",", "g"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"g", "(", "x", ")"}], ",", 
          RowBox[{"g", "(", 
            RowBox[{"a", ",", "b", ",", "c"}], ")"}], ",", 
          RowBox[{"sin", "(", "x", ")"}], ",", 
          RowBox[{"sin", "(", 
            RowBox[{"y", "-", "z"}], ")"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Cases2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
            RowBox[{"DiracSlash", "[", "q", "]"}]}], "+", 
          RowBox[{"ScalarProduct", "[", 
            RowBox[{"p", ",", "p"}], "]"}]}], ",", "Dot"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CF", "Section",
  CellTags->"CF"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
CF is one of the Casimir operators of SU(N) (CF = (N^2-1)/(2 N)).\
\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["CA",
    ButtonData:>"CA",
    ButtonStyle->"Hyperlink",
    ButtonNote->"CA"],
  ", ",
  ButtonBox["SUNSimplify",
    ButtonData:>"SUNSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SUNSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData["CF"], "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["C", "F"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SUNSimplify", "[", 
      RowBox[{"CF", ",", " ", 
        RowBox[{"SUNNToCACF", " ", "->", " ", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          SuperscriptBox["N", "2"], "-", "1"}], 
        RowBox[{"2", " ", "N"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["SUNN"], "Input"],

Cell[BoxData[
    FormBox["N", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SUNSimplify", "[", 
      RowBox[{"CF", ",", " ", 
        RowBox[{"SUNNToCACF", " ", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["C", "F"], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ChangeDimension", "Section",
  CellTags->"ChangeDimension"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ChangeDimension[exp, dim] changes all LorentzIndex and Momenta in \
exp to 
dimension dim (and also Levi-Civita-tensors, Dirac slashes and Dirac 
matrices).\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["LorentzIndex",
    ButtonData:>"LorentzIndex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LorentzIndex"],
  ", ",
  ButtonBox["Momentum",
    ButtonData:>"Momentum",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Momentum"],
  ", ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["Eps",
    ButtonData:>"Eps",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Eps"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[
"Remember that LorentzIndex[\[Mu], 4]  is simplified to LorentzIndex[\[Mu]]   \
and Momentum[p, 4] to Momentum[p]. Thus the fullowing objects are defined in  \
 four dimensions."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", " ", 
        RowBox[{"Momentum", "[", "p", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          FormBox["\[Mu]",
            "TraditionalForm"], ",", "p"}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChangeDimension", "[", 
      RowBox[{"%", ",", " ", "D"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          FormBox["\[Mu]",
            "TraditionalForm"], ",", "p"}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData["{LorentzIndex[\[Mu], D], Momentum[p, D]}"], "Output"]
}, Open  ]],

Cell["\<\
This changes all non-4-dimensional objects to 4-dimensional ones.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"ChangeDimension", "[", 
        RowBox[{"%%", ",", " ", "4"}], "]"}], " ", "//", " ", "InputForm"}]], 
  "Input"],

Cell[TextData["{LorentzIndex[\[Mu]], Momentum[p]}"], "Output"]
}, Open  ]],

Cell["Consider the following list of 4- and D-dimensional object.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"GA", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
          RowBox[{"MT", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], ",", " ", 
        RowBox[{
          RowBox[{"GAD", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
          RowBox[{"MTD", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
          RowBox[{"f", "[", "D", "]"}]}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
                SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}], " ", 
            SuperscriptBox["g", 
              RowBox[{"\[Mu]", "\[Nu]"}]]}], ",", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
                SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}], " ", 
            RowBox[{"f", "(", "D", ")"}], " ", 
            SuperscriptBox["g", 
              RowBox[{"\[Mu]", "\[Nu]"}]]}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", 
      RowBox[{"Contract", "[", "%", "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"4", ",", 
          RowBox[{"D", " ", 
            RowBox[{"f", "(", "D", ")"}]}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", 
      RowBox[{"Contract", "[", 
        RowBox[{"ChangeDimension", "[", 
          RowBox[{"%%", ",", "n"}], "]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"n", ",", 
          RowBox[{"n", " ", 
            RowBox[{"f", "(", "D", ")"}]}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell["\<\
Any explicit occurence of D (like in f(D)) is not replaced by 
ChangeDimension.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"LeviCivita", ",", 
          RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input"],

Cell["\<\
The option Dimension of Eps must be changed too, since with the \
default 
setting Dimension->4 the arguments of Eps are automatically changed to 4 
dimensions.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a1", " ", "=", " ", 
      RowBox[{"LeviCivita", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
        "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a2", " ", "=", " ", 
      RowBox[{"ChangeDimension", "[", 
        RowBox[{"a1", ",", "4"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Contract", "[", 
        RowBox[{"a1", "^", "2"}], "]"}], "  ", "//", " ", "Factor2"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"1", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"2", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"3", "-", "D"}], ")"}], " ", "D"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contract[a2^2]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "24"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        RowBox[{"a1", ",", "a2"}], "]"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ChargeConjugationMatrixInv", "Section",
  CellTags->"ChargeConjugationMatrixInv"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ChargeConjugationMatrixInv is the inverse of  \
ChargeConjugationMatrix.
It is substituted immediately by -ChargeConjugationMatrix.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["ChargeConjugationMatrix",
    ButtonData:>"ChargeConjugationMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ChargeConjugationMatrix"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", ".", 
      RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
      "ChargeConjugationMatrixInv"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"C", " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        RowBox[{"(", 
          RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        SubsuperscriptBox["\[Gamma]", 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], "T"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", ".", 
      RowBox[{"DiracGamma", "[", "5", "]"}], ".", 
      "ChargeConjugationMatrixInv"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"C", " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        RowBox[{"(", 
          RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"DiracGammaT", "(", "5", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", ".", "ChargeConjugationMatrixInv"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"C", " ", 
        RowBox[{"(", 
          RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "Calc"}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrixInv", "^", "2"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "1"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ChargeConjugationMatrix", "Section",
  CellTags->"ChargeConjugationMatrix"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "ChargeConjugationMatrix denotes the charge conjugation matrix ",
  StyleBox["C",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["ChargeConjugationMatrixInv",
    ButtonData:>"ChargeConjugationMatrixInv",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ChargeConjugationMatrixInv"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", ".", 
      RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
      "ChargeConjugationMatrixInv"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"C", " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        RowBox[{"(", 
          RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        SubsuperscriptBox["\[Gamma]", 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], "T"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", ".", 
      RowBox[{"DiracGamma", "[", "5", "]"}], ".", 
      "ChargeConjugationMatrixInv"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"C", " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        RowBox[{"(", 
          RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"DiracGammaT", "(", "5", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ChargeConjugationMatrix", "^", "2"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "1"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ChiralityProjector", "Section",
  CellTags->"ChiralityProjector"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "ChiralityProjector[+1] denotes ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"1", "/", "2"}], 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]]],
  ".\nChiralityProjector[-1] denotes ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"1", "/", "2"}], 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["DiracMatrix",
    ButtonData:>"DiracMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracMatrix"],
  ", ",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"ChiralityProjector", "[", 
          RowBox[{"+", "1"}], "]"}], ",", 
        RowBox[{"ChiralityProjector", "[", 
          RowBox[{"-", "1"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "6"], ",", 
          SuperscriptBox["\[Gamma]", "7"]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FCI", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "6"], ",", 
          SuperscriptBox["\[Gamma]", "7"]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", 
      RowBox[{"%", ",", 
        RowBox[{"DiracSubstitute67", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FractionBox[
              SuperscriptBox["\[Gamma]", "5"], "2"], "+", 
            FractionBox["1", "2"]}], ",", 
          RowBox[{
            FractionBox["1", "2"], "-", 
            FractionBox[
              SuperscriptBox["\[Gamma]", "5"], "2"]}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chisholm", "Section",
  CellTags->"Chisholm"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Chisholm[x] substitutes products of three Dirac matrices or slashes \
by the 
Chisholm identity.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["EpsChisholm",
    ButtonData:>"EpsChisholm",
    ButtonStyle->"Hyperlink",
    ButtonNote->"EpsChisholm"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Chisholm", "[", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Nu]"}], 
        "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$505"], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Alpha]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Beta]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$505",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Mu]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Beta]", "\[Mu]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{"DiracMatrix", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], 
        SuperscriptBox["\[Gamma]", "\[Nu]"], 
        SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", " ", "=", 
      RowBox[{"Chisholm", "[", "t1", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$506"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$506",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["The $MU$ variables are unique indices.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"t1", ".", "t1"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["16", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", " ", "=", 
      RowBox[{"Chisholm", "[", "t1", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$507"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$507",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"t2", ".", "t3"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["16", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{"DiracSlash", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["a",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["b",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["c",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Chisholm", "[", "t4", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$508"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["$MU$508",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox["a",
                "TraditionalForm"], 
              FormBox["b",
                "TraditionalForm"], 
              FormBox["c",
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["c",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["a",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["b",
              "TraditionalForm"]}]}], "-", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["b",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["a",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["c",
              "TraditionalForm"]}]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["a",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["b",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["c",
              "TraditionalForm"]}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a1", "=", 
      RowBox[{"GA", "[", 
        RowBox[{
        "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", "\[Tau]", 
          ",", "\[Kappa]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Kappa]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a2", " ", "=", 
      RowBox[{"Chisholm", "[", "a1", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$511"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$511",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$512"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$512",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$513"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$513",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$509"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$509",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a3", " ", "=", 
      RowBox[{"Chisholm", "[", "a1", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$516"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$516",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$517"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$517",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$518"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Tau]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$518",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Tau]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Tau]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$514"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$514",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Kappa]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["Check that both a1.a1 and a2.a3 give the same.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"a1", ".", "a1"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "2048"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"a2", ".", "a3"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "2048"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{
      "t1", ",", "t2", ",", "t3", ",", "t4", ",", "a1", ",", "a2", ",", 
        "a3"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Collect2", "Section",
  CellTags->"Collect2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Collect2[expr, x] collects together terms which are not free of any \

occurrence of x. 
Collect2[expr, {x1, x2, ...}]  (or also Collect2[expr, x1, x2,  ...]) 
collects together terms which are not free of any occurrence  of x1, x2, .... \

The coefficients are put over a common denominator.  If expr is expanded 
before collecting depends on the option  Factoring, which may be set to 
Factor, Factor2, or any other function, which is applied to the coefficients. \

If expr is already expanded with respect to x (x1,x2, ...), the  option 
Expanding can be set to False.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Collect2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Denominator", "\[Rule]", "False"}], ",", 
          RowBox[{"Dot", "\[Rule]", "False"}], ",", 
          RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
          RowBox[{"Factoring", "\[Rule]", "Factor2"}], ",", 
          RowBox[{"IsolateNames", "\[Rule]", "False"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Isolate",
    ButtonData:>"Isolate",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Isolate"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", " ", 
      RowBox[{
        RowBox[{"t1", "=", 
          RowBox[{"a", "+", 
            RowBox[{"r", "a"}], "+", 
            RowBox[{
              RowBox[{"k", "^", "2"}], " ", 
              RowBox[{"f", "[", "a", "]"}]}], "-", 
            RowBox[{"k", " ", 
              RowBox[{"f", "[", "a", "]"}]}], "+", 
            RowBox[{"x", "/", "2"}], "-", 
            RowBox[{"y", "/", "w"}]}]}], ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", 
          RowBox[{"(", 
            RowBox[{"r", "+", "1"}], ")"}]}], "+", 
        FractionBox[
          RowBox[{
            RowBox[{"w", " ", "x"}], "-", 
            RowBox[{"2", " ", "y"}]}], 
          RowBox[{"2", " ", "w"}]], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", "k"}], ")"}], " ", "k", " ", 
          RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", 
      RowBox[{"t1", ",", "a", ",", 
        RowBox[{"Factoring", "->", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", 
          RowBox[{"(", 
            RowBox[{"r", "+", "1"}], ")"}]}], "+", 
        FractionBox["x", "2"], "-", 
        FractionBox["y", "w"], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["k", "2"], "-", "k"}], ")"}], " ", 
          RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", 
      RowBox[{"t1", ",", "a", ",", 
        RowBox[{"Factoring", "->", "Factor"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", 
          RowBox[{"(", 
            RowBox[{"r", "+", "1"}], ")"}]}], "+", 
        FractionBox[
          RowBox[{
            RowBox[{"w", " ", "x"}], "-", 
            RowBox[{"2", " ", "y"}]}], 
          RowBox[{"2", " ", "w"}]], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"k", "-", "1"}], ")"}], " ", "k", " ", 
          RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"2", "a", " ", 
            RowBox[{"(", 
              RowBox[{"b", "-", "a"}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{"h", "-", "1"}], ")"}]}], " ", "-", " ", 
          RowBox[{
            RowBox[{"b", "^", "2"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"e", "a"}], " ", "-", " ", "c"}], ")"}]}], " ", "+", 
          RowBox[{"b", "^", "2"}]}], ",", " ", 
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{"(", 
            RowBox[{"1", "-", "h"}], ")"}], " ", 
          SuperscriptBox["a", "2"]}], "-", 
        RowBox[{
          SuperscriptBox["b", "2"], " ", "e", " ", "a"}], "-", 
        RowBox[{"2", " ", "b", " ", 
          RowBox[{"(", 
            RowBox[{"1", "-", "h"}], ")"}], " ", "a"}], "+", 
        RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
            RowBox[{"c", "+", "1"}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", 
      RowBox[{
        RowBox[{"Expand", "[", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"a", "-", "b", "-", "c", "-", "d"}], ")"}], "^", "5"}], 
          "]"}], ",", "a", ",", 
        RowBox[{"IsolateNames", "\[Rule]", "L"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["a", "5"], "-", 
        RowBox[{"5", " ", 
          TagBox[
            RowBox[{"L", "(", "1", ")"}],
            HoldForm], " ", 
          SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"10", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              TagBox[
                RowBox[{"L", "(", "1", ")"}],
                HoldForm], ")"}], "2"], " ", 
          SuperscriptBox["a", "3"]}], "-", 
        RowBox[{"10", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              TagBox[
                RowBox[{"L", "(", "1", ")"}],
                HoldForm], ")"}], "3"], " ", 
          SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"5", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              TagBox[
                RowBox[{"L", "(", "1", ")"}],
                HoldForm], ")"}], "4"], " ", "a"}], "-", 
        SuperscriptBox[
          RowBox[{"(", 
            TagBox[
              RowBox[{"L", "(", "1", ")"}],
              HoldForm], ")"}], "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["a", "5"], "-", 
        RowBox[{"5", " ", 
          RowBox[{"(", 
            RowBox[{"b", "+", "c", "+", "d"}], ")"}], " ", 
          SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"10", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"b", "+", "c", "+", "d"}], ")"}], "2"], " ", 
          SuperscriptBox["a", "3"]}], "-", 
        RowBox[{"10", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"b", "+", "c", "+", "d"}], ")"}], "3"], " ", 
          SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"5", " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"b", "+", "c", "+", "d"}], ")"}], "4"], " ", "a"}], 
        "-", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"b", "+", "c", "+", "d"}], ")"}], "5"]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "L"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect2", "[", 
      RowBox[{
        RowBox[{"Expand", "[", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"a", "-", "b", "-", "c"}], ")"}], "^", "3"}], "]"}], 
        ",", "a", ",", 
        RowBox[{"Factoring", "->", "fun"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"fun", "(", "1", ")"}], " ", 
          SuperscriptBox["a", "3"]}], "+", 
        RowBox[{
          RowBox[{"fun", "(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", "3"}], " ", "b"}], "-", 
              RowBox[{"3", " ", "c"}]}], ")"}], " ", 
          SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
          RowBox[{"fun", "(", 
            RowBox[{
              RowBox[{"3", " ", 
                SuperscriptBox["b", "2"]}], "+", 
              RowBox[{"6", " ", "c", " ", "b"}], "+", 
              RowBox[{"3", " ", 
                SuperscriptBox["c", "2"]}]}], ")"}], " ", "a"}], "+", 
        RowBox[{"fun", "(", 
          RowBox[{
            RowBox[{"-", 
              SuperscriptBox["b", "3"]}], "-", 
            RowBox[{"3", " ", "c", " ", 
              SuperscriptBox["b", "2"]}], "-", 
            RowBox[{"3", " ", 
              SuperscriptBox["c", "2"], " ", "b"}], "-", 
            SuperscriptBox["c", "3"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", " ", "/.", " ", 
      RowBox[{"fun", "->", "FactorTerms"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{"3", " ", 
          RowBox[{"(", 
            RowBox[{"b", "+", "c"}], ")"}], " ", 
          SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"3", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", "c", " ", "b"}], "+", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "a"}], "-", 
        SuperscriptBox["b", "3"], "-", 
        SuperscriptBox["c", "3"], "-", 
        RowBox[{"3", " ", "b", " ", 
          SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "c"}]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combine", "Section",
  CellTags->"Combine"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Combine[expr]puts terms in a sum over a common denominator,and \
cancels 
factors in the result. Combine is similar to Together, but accepts the option \

Expanding and works usually better than Together for polynomials involving 
rationals with sums in the denominator.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Combine", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"Expanding", "\[Rule]", "False"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Factor2",
    ButtonData:>"Factor2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Factor2"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Combine", "[", " ", 
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "-", "b"}], ")"}], " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"c", "-", "d"}], ")"}], "/", "e"}]}], " ", "+", " ", 
        "g"}], " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{"a", "-", "b"}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{"c", "-", "d"}], ")"}]}], "+", 
          RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\

Here the result from Together where the numerator is automatically 
expanded.
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Together", "[", " ", 
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "-", "b"}], ")"}], " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"c", "-", "d"}], ")"}], "/", "e"}]}], " ", "+", " ", 
        "g"}], " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{"a", " ", "c"}], "-", 
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}], "+", 
          RowBox[{"b", " ", "d"}], "+", 
          RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
If the option Expanding  is set to True, the result of Combine is \
the same as 
Together, but uses a slightly different algorithm.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Combine", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"a", "-", "b"}], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{"c", "-", "d"}], ")"}]}], ")"}], "/", "e"}], "+", 
          "g"}], ",", 
        RowBox[{"Expanding", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{"a", " ", "c"}], "-", 
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}], "+", 
          RowBox[{"b", " ", "d"}], "+", 
          RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CommutatorExplicit", "Section",
  CellTags->"CommutatorExplicit"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
CommutatorExplicit[exp] substitutes any Commutator and \
AntiCommutator  in exp by their definitions.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  ", ",
  ButtonBox["DotSimplify",
    ButtonData:>"DotSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DotSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Commutator", "[", 
      RowBox[{"a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
      "[", "\[NoBreak]", "a", "\[NoBreak]", ",", "b", "\[NoBreak]", "]"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"b", " ", "a"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AntiCommutator", "[", 
      RowBox[{
        RowBox[{"a", "-", "c"}], ",", 
        RowBox[{"b", "-", "d"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        FormBox[
          RowBox[{"a", "-", "c"}],
          "TraditionalForm"], ",", "\[MediumSpace]", 
        FormBox[
          RowBox[{"b", "-", "d"}],
          "TraditionalForm"], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "-", "c"}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{"b", "-", "d"}], ")"}]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"b", "-", "d"}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{"a", "-", "c"}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"CommutatorExplicit", "[", "%%", "]"}], "//", "DotSimplify"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"a", " ", "d"}], "+", 
        RowBox[{"b", " ", "a"}], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"c", " ", "b"}], "+", 
        RowBox[{"c", " ", "d"}], "-", 
        RowBox[{"d", " ", "a"}], "+", 
        RowBox[{"d", " ", "c"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Commutator", "Section",
  CellTags->"Commutator"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Commutator[x, y] = c  defines the commutator between the \
non-commuting 
objects x and y. \
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["AntiCommutator",
    ButtonData:>"AntiCommutator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"AntiCommutator"],
  ", ",
  ButtonBox["CommutatorExplicit",
    ButtonData:>"CommutatorExplicit",
    ButtonStyle->"Hyperlink",
    ButtonNote->"CommutatorExplicit"],
  ", ",
  ButtonBox["DeclareNonCommutative",
    ButtonData:>"DeclareNonCommutative",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DeclareNonCommutative"],
  ", ",
  ButtonBox["DotSimplify",
    ButtonData:>"DotSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DotSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Commutator", "[", 
      RowBox[{"a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
      "[", "\[NoBreak]", "a", "\[NoBreak]", ",", "b", "\[NoBreak]", "]"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b"}], "-", 
        RowBox[{"b", " ", "a"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DotSimplify", "[", 
        RowBox[{"Commutator", "[", 
          RowBox[{
            RowBox[{"a", "+", "b"}], ",", 
            RowBox[{"c", "+", "d"}]}], "]"}], "]"}], " "}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        RowBox[{"b", " ", "d"}], "-", 
        RowBox[{"c", " ", "a"}], "-", 
        RowBox[{"c", " ", "b"}], "-", 
        RowBox[{"d", " ", "a"}], "-", 
        RowBox[{"d", " ", "b"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input"],

Cell["Verify the Jacobi identity.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[Chi]", "=", "Commutator"}], ";", "  ", 
      RowBox[{"DeclareNonCommutative", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"\[Chi]", "[", 
        RowBox[{"x", ",", 
          RowBox[{"\[Chi]", "[", 
            RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "+", 
      RowBox[{"\[Chi]", "[", 
        RowBox[{"y", ",", 
          RowBox[{"\[Chi]", "[", 
            RowBox[{"z", ",", "x"}], "]"}]}], "]"}], "+", 
      RowBox[{"\[Chi]", "[", 
        RowBox[{"z", ",", 
          RowBox[{"\[Chi]", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"[", "\[NoBreak]", "x", "\[NoBreak]", ",", 
          FormBox[
            RowBox[{
            "[", "\[NoBreak]", "y", "\[NoBreak]", ",", "z", "\[NoBreak]", 
              "]"}],
            "TraditionalForm"], "\[NoBreak]", "]"}], "+", 
        RowBox[{"[", "\[NoBreak]", "y", "\[NoBreak]", ",", 
          FormBox[
            RowBox[{
            "[", "\[NoBreak]", "z", "\[NoBreak]", ",", "x", "\[NoBreak]", 
              "]"}],
            "TraditionalForm"], "\[NoBreak]", "]"}], "+", 
        RowBox[{"[", "\[NoBreak]", "z", "\[NoBreak]", ",", 
          FormBox[
            RowBox[{
            "[", "\[NoBreak]", "x", "\[NoBreak]", ",", "y", "\[NoBreak]", 
              "]"}],
            "TraditionalForm"], "\[NoBreak]", "]"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", "\[Chi]", "]"}]], "Input"],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexConjugate", "Section",
  CellTags->"ComplexConjugate"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ComplexConjugate[expr] complex conjugates expr. 
It operates on fermion lines, i.e., products of Spinor[..] .DiracMatrix[..] . \
Spinor[..], and changes all 
occuring LorentzIndex[mu] into LorentzIndex[ComplexIndex[mu]].
For taking the spin sum (i.e. constructing the traces) use 
FermionSpinSum. 
WARNING: In expr should be NO explicit I's in denominators!\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["ComplexIndex",
    ButtonData:>"ComplexIndex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ComplexIndex"],
  ", ",
  ButtonBox["FermionSpinSum",
    ButtonData:>"FermionSpinSum",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FermionSpinSum"],
  ", ",
  ButtonBox["LorentzIndex",
    ButtonData:>"LorentzIndex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LorentzIndex"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[TextData["ComplexConjugate[MetricTensor[\[Mu],\[Nu]]]"], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["g", 
        RowBox[{
          FormBox[
            SuperscriptBox["\[Mu]", "*"],
            "TraditionalForm"], 
          FormBox[
            SuperscriptBox["\[Nu]", "*"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input"],

Cell[TextData[
"Pair[LorentzIndex[ComplexIndex[\[Mu]]], \n  \
LorentzIndex[ComplexIndex[\[Nu]]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["GA[\[Mu],\[Nu],5]"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexConjugate[%]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Gamma]", "5"], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Nu]", "*"],
                "TraditionalForm"]], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Mu]", "*"],
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SUNTrace[SUNT[a,b,c]]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            SubscriptBox["T", 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexConjugate[%]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            SubscriptBox["T", 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexConjugate[SUNF[a,b,c]]", "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["f", 
        RowBox[{
          FormBox[
            FormBox["a",
              "TraditionalForm"],
            "TraditionalForm"], "\[NoBreak]", 
          FormBox[
            FormBox["b",
              "TraditionalForm"],
            "TraditionalForm"], "\[NoBreak]", 
          FormBox[
            FormBox["c",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"ComplexConjugate[MetricTensor[\[Mu],\[Nu]]]//FCE//InputForm"], "Input"],

Cell[TextData["MT[ComplexIndex[\[Mu]], ComplexIndex[\[Nu]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SpinorUBar", "[", 
        RowBox[{"k1", ",", "m"}], "]"}], ".", 
      RowBox[{"GA", "[", "\[Lambda]", "]"}], ".", 
      RowBox[{"SpinorU", "[", 
        RowBox[{"p1", ",", "m"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            OverscriptBox["\<\"u\"\>", "_"],
            "TraditionalForm"], "(", "k1", ",", "m", ")"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Lambda]"], " ", 
        RowBox[{"u", "(", "p1", ",", "m", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CurlyPhi]", "(", 
          FormBox["p1",
            "TraditionalForm"], ",", "m", ")"}], " ", 
        SuperscriptBox["\[Gamma]", 
          FormBox[
            SuperscriptBox["\[Lambda]", "*"],
            "TraditionalForm"]], " ", 
        RowBox[{"\[CurlyPhi]", "(", 
          FormBox["k1",
            "TraditionalForm"], ",", "m", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[
"Notice that SpinorUBar and SpinorU are only input functions. Internally they \
  are converted to Spinor objects (which display as \[CurlyPhi]\[NoBreak])."],
   "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexIndex", "Section",
  CellTags->"ComplexIndex"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ComplexIndex is the head of a \"complex conjugate index\", which is \

understood as just another index.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["LorentzIndex",
    ButtonData:>"LorentzIndex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LorentzIndex"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]], "Input"],

Cell[BoxData[
    FormBox["\[Mu]", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Mu]", "*"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData["LorentzIndex[ComplexIndex[\[Mu]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourVector", "[", 
      RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox[
            SuperscriptBox["\[Mu]", "*"],
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"Pair[LorentzIndex[ComplexIndex[\[Mu]]], Momentum[p]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contract", "Section",
  CellTags->"Contract"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Contract[expr] contracts pairs of Lorentz indices of metric \
tensors, 
four-vectors and (depending on the optionEpsContract) of Levi-Civita tensors 
in expr. For the contraction of Dirac matrices with each other use 
DiracSimplify.  Contract[exp1, exp2] contracts (exp1*exp2), where exp1 and 
exp2 may be larger products of sums of  metric tensors and 4-vectors. \
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Contract", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Collecting", "\[Rule]", "True"}], ",", 
          RowBox[{"EpsContract", "\[Rule]", "True"}], ",", 
          RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
          RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
          RowBox[{"FeynCalcInternal", "\[Rule]", "False"}], ",", 
          RowBox[{"MomentumCombine", "\[Rule]", "False"}], ",", 
          RowBox[{"Rename", "\[Rule]", "False"}], ",", 
          RowBox[{"Schouten", "\[Rule]", "0"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Pair",
    ButtonData:>"Pair",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Pair"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["MomentumCombine",
    ButtonData:>"MomentumCombine",
    ButtonStyle->"Hyperlink",
    ButtonNote->"MomentumCombine"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"MetricTensor", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox["\[Nu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Mu]"}], "]"}], 
      RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["p",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"MetricTensor", "[", 
      RowBox[{"\[Mu]", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Mu]"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell["The default dimension for MetricTensor is 4.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox["4", TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
A short way to enter D-dimensional metric tensors is given by MTD.  \
The \".\" as multiplication operator  is not necessary  but just convenient  \
for typesetting.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"MTD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", ".", " ", 
      RowBox[{"MTD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox["D", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"MTD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", ".", " ", 
      RowBox[{"MTD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Mu]"}], "]"}], " ", 
      RowBox[{"FourVector", "[", 
        RowBox[{"q", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["p",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FourVector", "[", 
        RowBox[{
          RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], " ", 
      RowBox[{"FourVector", "[", 
        RowBox[{
          RowBox[{"a", "-", "b"}], ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{"a", "-", "b"}],
                "TraditionalForm"], ")"}], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ")"}], " ", 
        RowBox[{"(", 
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{"p", "-", "q"}],
                "TraditionalForm"], ")"}], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["a",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}], "-", 
        RowBox[{
          FormBox["a",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], "-", 
        RowBox[{
          FormBox["b",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}], "+", 
        RowBox[{
          FormBox["b",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"LeviCivita", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], 
        "]"}], " ", 
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Sigma]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Alpha]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]], " ", 
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Alpha]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox["p",
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"LeviCivita", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], 
          "]"}], " ", 
        RowBox[{"LeviCivita", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], 
          "]"}]}], " "}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Alpha]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Beta]",
                "TraditionalForm"],
              "TraditionalForm"]}]], " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Alpha]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "6"}], " ", 
        SuperscriptBox["g", 
          RowBox[{"\[Beta]", "\[Sigma]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";", 
      RowBox[{
        RowBox[{"LCD", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], 
          "]"}], " ", 
        RowBox[{"LCD", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], 
          "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Epsilon]", 
          RowBox[{"\[Mu]", "\[Nu]", "\[Alpha]", "\[Beta]"}]], " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{"\[Mu]", "\[Nu]", "\[Alpha]", "\[Sigma]"}]]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Contract", "[", "%", "]"}], "//", "Factor2"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"1", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"2", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"3", "-", "D"}], ")"}], " ", 
        SuperscriptBox["g", 
          RowBox[{
            FormBox[
              FormBox["\[Beta]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convolute", "Section",
  CellTags->"Convolute"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection"],

Cell[TextData[{
  "Convolute[f, g, x] convolutes f(x) and g(x), i.e., \n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", "0", "1"], 
          RowBox[{
            SubscriptBox["dx", "1"], " ", 
            RowBox[{
              SubsuperscriptBox["\[Integral]", "0", "1"], 
              RowBox[{
                SubscriptBox["dx", "2"], " ", 
                RowBox[{"\[Delta]", "(", 
                  RowBox[{"x", " ", "-", " ", 
                    RowBox[{
                      SubscriptBox["x", "1"], " ", 
                      SubscriptBox["x", "2"]}]}], ")"}], " ", 
                RowBox[{"f", "(", 
                  SubscriptBox["x", "1"], ")"}], " ", 
                RowBox[{
                  RowBox[{"g", "(", 
                    SubscriptBox["x", "2"], ")"}], " ", "."}]}]}]}]}], 
        TraditionalForm]]],
  "\nConvolute[f, g] is equivalent to Convolute[f, g, x].\nConvolute[exp,   \
{x1, x2}] assumes that exp is polynomial in x1 and x2.\nConvolute uses   \
table-look-up and does not do any integral calculations, only linear   \
algebra."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Convolute", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Bracket", "\[Rule]", 
            RowBox[{"{", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "}"}]}], ",", 
          RowBox[{"FinalSubstitutions", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{"PlusDistribution", "\[Rule]", "Identity"}], "}"}]}]}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["PlusDistribution",
    ButtonData:>"PlusDistribution",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PlusDistribution"],
  "."
}], "Subsubsection"],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", "1"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"x", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "x"}], " ", 
        RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"1", "-", "x"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"log", "(", 
          RowBox[{"1", "-", "x"}], ")"}], "-", 
        RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"PlusDistribution", "[", 
          RowBox[{"1", "/", 
            RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"log", "(", 
          RowBox[{"1", "-", "x"}], ")"}], "-", 
        RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", "x"}], "-", 
        RowBox[{
          RowBox[{"log", "(", "x", ")"}], " ", "x"}], "-", "x", "+", "1"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"\[Zeta]", "(", "2", ")"}]}], " ", 
          RowBox[{"\[Delta]", "(", 
            FormBox[
              RowBox[{"1", "-", "x"}],
              "TraditionalForm"], ")"}]}], "+", 
        FractionBox[
          RowBox[{"2", " ", 
            RowBox[{"log", "(", 
              RowBox[{"1", "-", "x"}], ")"}]}], 
          RowBox[{"1", "-", "x"}]], "-", 
        FractionBox[
          RowBox[{"log", "(", "x", ")"}], 
          RowBox[{"1", "-", "x"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"Log", "[", 
          RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"log", "(", 
              RowBox[{"1", "-", "x"}], ")"}]}], " ", 
          RowBox[{"log", "(", "x", ")"}]}], "-", 
        RowBox[{
          SubscriptBox["Li", "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", 
            RowBox[{"1", "-", "x"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"x", "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "-", "1"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{"Log", "[", 
          RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["log", "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}], "-", 
        RowBox[{
          RowBox[{"log", "(", "x", ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "-", 
        RowBox[{"\[Zeta]", "(", "2", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", 
            RowBox[{"1", "-", "x"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"x", " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "-", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", "x", ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", "x", "-", 
        RowBox[{"x", " ", 
          RowBox[{"\[Zeta]", "(", "2", ")"}]}], "-", "1"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"Log", "[", 
            RowBox[{"1", "-", "x"}], "]"}], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", "x", " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "-", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", "x", ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", "x", ")"}]}], "-", 
        RowBox[{"x", " ", 
          RowBox[{
            SubscriptBox["Li", "2"], "(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"log", "(", "x", ")"}]}], " ", "x"}], "+", "x", "-", 
        "1"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"Log", "[", 
          RowBox[{"1", "-", "x"}], "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", "x", ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{
          RowBox[{"Log", "[", "x", "]"}], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            RowBox[{"log", "(", 
              RowBox[{"1", "-", "x"}], ")"}], " ", 
            RowBox[{"log", "(", "x", ")"}]}], 
          RowBox[{"1", "-", "x"}]], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["log", "2"], "(", "x", ")"}], 
          RowBox[{"2", " ", 
            RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
        RowBox[{
          SuperscriptBox["log", "2"], "(", "x", ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"x", ",", " ", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "2"]}], " ", "x", " ", 
        RowBox[{
          SuperscriptBox["log", "2"], "(", "x", ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            FractionBox["1", "2"]}], " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", "x", ")"}]}], "+", 
        RowBox[{
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", "x", ")"}]}], "+", 
        RowBox[{
          SubscriptBox["Li", "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{
          RowBox[{"Log", "[", "x", "]"}], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            FractionBox["1", "2"]}], " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", "x", ")"}]}], "-", 
        RowBox[{
          SubscriptBox["Li", "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            FractionBox["1", "2"]}], " ", "x", " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", "x", ")"}]}], "-", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", "x", ")"}]}], "+", 
        RowBox[{"x", " ", 
          RowBox[{"log", "(", 
            RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{"log", "(", "x", ")"}]}], "+", "x", "+", 
        RowBox[{"x", " ", 
          RowBox[{
            SubscriptBox["Li", "2"], "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "-", "1"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"Log", "[", "x", "]"}], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            FractionBox["1", "2"]}], " ", "x", " ", 
          RowBox[{
            SuperscriptBox["log", "2"], "(", "x", ")"}]}], "+", 
        RowBox[{"log", "(", "x", ")"}], "-", "x", "-", 
        RowBox[{"x", " ", 
          RowBox[{
            SubscriptBox["Li", "2"], "(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "+", "1"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{"1", ",", 
        RowBox[{"x", " ", 
          RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"log", "(", "x", ")"}]}], " ", "x"}], "+", "x", "-", 
        "1"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"Log", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "x"}], "+", 
        RowBox[{"log", "(", "x", ")"}], "+", "1"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], ",", 
        RowBox[{
          RowBox[{"Log", "[", 
            RowBox[{"1", "-", "x"}], "]"}], "/", 
          RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"3", " ", 
            RowBox[{
              SuperscriptBox["log", "2"], "(", 
              RowBox[{"1", "-", "x"}], ")"}]}], 
          RowBox[{"2", " ", 
            RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}]}]], "-", 
        FractionBox[
          RowBox[{
            RowBox[{"log", "(", "x", ")"}], " ", 
            RowBox[{"log", "(", 
              RowBox[{"1", "-", "x"}], ")"}]}], 
          RowBox[{"1", "-", "x"}]], "-", 
        FractionBox[
          RowBox[{"\[Zeta]", "(", "2", ")"}], 
          RowBox[{"1", "-", "x"}]], "+", 
        RowBox[{
          RowBox[{"\[Delta]", "(", 
            FormBox[
              RowBox[{"1", "-", "x"}],
              "TraditionalForm"], ")"}], " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                (Editable -> True)], ")"}],
            InterpretTemplate[ Zeta[ #]&]]}]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CovariantD", "Section",
  CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"CovariantD[\[Mu], a, b] is the covariant derivative for a bosonic field.\n\
CovariantD[\[Mu]] is the covariant derivative for a fermionic field.\n\
CovariantD[OPEDelta, a, b]  is a short form for\n\
CovariantD[mu,a,b]*FourVector[OPEDelta, mu].\nCovariantD[{OPEDelta, a, b},   \
{n}] yields the product of m operators., where n is an integer.\n\
CovariantD[OPEDelta, a, b, {m, n}] gives the expanded form of\n\
CovariantD[OPEDelta, a, b]^m up to order\ng^n for the gluon, where n is an   \
integer and g the couplingconstant indicated by the setting of the option   \
CouplingConstant.\nCovariantD[OPEDelta, {m, n}] gives the expanded form of\n\
CovariantD[OPEDelta]^m up to order g^n of the fermionic field."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "CovariantD", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"CouplingConstant", "\[Rule]", 
            SubscriptBox["g", "s"]}], ",", 
          RowBox[{"DummyIndex", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"Explicit", "\[Rule]", "False"}], ",", 
          RowBox[{"PartialD", "\[Rule]", "RightPartialD"}], ",", 
          RowBox[{"QuantumField", "\[Rule]", "A"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\

Possible settings of PartialD are: 
LeftPartialD, LeftRigthPartialD, RightPartialD.
The default setting of QuantumField is GaugeField.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["LeftPartialD",
    ButtonData:>"LeftPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftPartialD"],
  ", ",
  ButtonBox["LeftRightPartialD",
    ButtonData:>"LeftRightPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftRightPartialD"],
  ", ",
  ButtonBox["RightPartialD",
    ButtonData:>"RightPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"RightPartialD"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", "\[Mu]", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["D", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"\[Mu]", ",", "a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["D", "\[Mu]", 
        RowBox[{"a", "b"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"\[Mu]", ",", 
        RowBox[{"Explicit", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SubscriptBox["g", "s"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["T", 
                FormBox[
                  FormBox[
                    InterpretationBox[
                      SubscriptBox["c", "1"],
                      Subscripted[ 
                        c[ 1]],
                      Editable->False],
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox[
                    InterpretationBox[
                      SubscriptBox["c", "1"],
                      Subscripted[ 
                        c[ 1]],
                      Editable->False],
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell["\<\
The first argument of CovariantD is intepreted as type \
LorentzIndex, except for OPEDelta, which is type Momentum.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", "OPEDelta", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubscriptBox["D", 
        FormBox["\[CapitalDelta]",
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["D", 
        FormBox["\[CapitalDelta]",
          "TraditionalForm"], 
        RowBox[{"a", "b"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
        RowBox[{"Explicit", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"]], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{"a", "b"}]]}], "-", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox[
              FormBox[
                InterpretationBox[
                  SubscriptBox["c", "2"],
                  Subscripted[ 
                    c[ 2]],
                  Editable->False],
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "b", "\[NoBreak]", 
              FormBox[
                InterpretationBox[
                  SubscriptBox["c", "2"],
                  Subscripted[ 
                    c[ 2]],
                  Editable->False],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", 
        RowBox[{"Explicit", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SubscriptBox["g", "s"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["T", 
                FormBox[
                  FormBox[
                    InterpretationBox[
                      SubscriptBox["c", "3"],
                      Subscripted[ 
                        c[ 3]],
                      Editable->False],
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], 
                FormBox[
                  FormBox[
                    InterpretationBox[
                      SubscriptBox["c", "3"],
                      Subscripted[ 
                        c[ 3]],
                      Editable->False],
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SubscriptBox[
                OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{"a", "c8"}]]}], "-", 
            RowBox[{
              SubscriptBox["g", "s"], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e1",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubscriptBox["f", 
                RowBox[{"a", "\[NoBreak]", "c8", "\[NoBreak]", "e1"}]]}]}], 
          ")"}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SubscriptBox[
                OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{"b", "c8"}]]}], "-", 
            RowBox[{
              SubscriptBox["g", "s"], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e2",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubscriptBox["f", 
                RowBox[{"c8", "\[NoBreak]", "b", "\[NoBreak]", "e2"}]]}]}], 
          ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This gives",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"m", " ", "times", " ", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              "\[CapitalDelta]"]}], ",", " "}], TraditionalForm]]],
  "the partial derivative ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          RowBox[{"\[Mu]", " "}]], TraditionalForm]]],
  "contracted with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["\[CapitalDelta]", "\[Mu]"], "."}], 
        TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
        RowBox[{"{", 
          RowBox[{"OPEm", ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          RowBox[{"(", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], ")"}], "m"], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The expansion up to first order in the coupling constant  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{"the", "sum", "is", "the", "FeynCalc", "OPESum"}], 
              ")"}], "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
        RowBox[{"{", 
          RowBox[{"OPEm", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], ")"}], "m"], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "1"}]], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          SubscriptBox[
                            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"]], ")"}], "i"], " ", 
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            InterpretationBox[
                              SubscriptBox["c", "1"],
                              Subscripted[ 
                                c[ 1]],
                              Editable->False],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        RowBox[{"(", 
                          SubscriptBox[
                            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"]], ")"}], 
                        RowBox[{
                          RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}], ")"}], 
                  " ", 
                  SubscriptBox["f", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], "\[NoBreak]", 
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], "\[NoBreak]", 
                      FormBox[
                        FormBox[
                          InterpretationBox[
                            SubscriptBox["c", "1"],
                            Subscripted[ 
                              c[ 1]],
                            Editable->False],
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}]}],
              HoldForm],
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The expansion up to second order in the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", "s"], "."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
        RowBox[{"{", 
          RowBox[{"OPEm", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              SubscriptBox[
                OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], ")"}], "m"]}], "-", 
        RowBox[{
          SubsuperscriptBox["g", "s", "2"], " ", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"j", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                FormBox[
                  TagBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{"i", "=", "0"}], "j"], 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            SuperscriptBox[
                              RowBox[{"(", 
                                SubscriptBox[
                                  
                                  OverscriptBox["\[PartialD]", 
                                    "\[RightArrow]"], 
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"]], ")"}], "i"], " ", 
                            SubsuperscriptBox[
                              FormBox["A",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"], 
                              FormBox[
                                FormBox[
                                  InterpretationBox[
                                    SubscriptBox["c", "1"],
                                    Subscripted[ 
                                      c[ 1]],
                                    Editable->False],
                                  "TraditionalForm"],
                                "TraditionalForm"]], " ", 
                            SuperscriptBox[
                              RowBox[{"(", 
                                SubscriptBox[
                                  
                                  OverscriptBox["\[PartialD]", 
                                    "\[RightArrow]"], 
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"]], ")"}], 
                              RowBox[{"j", "-", "i"}]], " ", 
                            SubsuperscriptBox[
                              FormBox["A",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"], 
                              FormBox[
                                FormBox[
                                  InterpretationBox[
                                    SubscriptBox["c", "2"],
                                    Subscripted[ 
                                      c[ 2]],
                                    Editable->False],
                                  "TraditionalForm"],
                                "TraditionalForm"]], " ", 
                            SuperscriptBox[
                              RowBox[{"(", 
                                SubscriptBox[
                                  
                                  OverscriptBox["\[PartialD]", 
                                    "\[RightArrow]"], 
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"]], ")"}], 
                              RowBox[{
                                RowBox[{"-", "j"}], "+", "m", "-", "2"}]]}], 
                          ")"}], " ", 
                        SubscriptBox["f", 
                          RowBox[{
                            FormBox[
                              FormBox["a",
                                "TraditionalForm"],
                              "TraditionalForm"], "\[NoBreak]", 
                            FormBox[
                              FormBox[
                                InterpretationBox[
                                  SubscriptBox["c", "1"],
                                  Subscripted[ 
                                    c[ 1]],
                                  Editable->False],
                                "TraditionalForm"],
                              "TraditionalForm"], "\[NoBreak]", 
                            FormBox[
                              FormBox[
                                InterpretationBox[
                                  SubscriptBox["e", "1"],
                                  Subscripted[ 
                                    e[ 1]],
                                  Editable->False],
                                "TraditionalForm"],
                              "TraditionalForm"]}]], " ", 
                        SubscriptBox["f", 
                          RowBox[{
                            FormBox[
                              FormBox["b",
                                "TraditionalForm"],
                              "TraditionalForm"], "\[NoBreak]", 
                            FormBox[
                              FormBox[
                                InterpretationBox[
                                  SubscriptBox["c", "2"],
                                  Subscripted[ 
                                    c[ 2]],
                                  Editable->False],
                                "TraditionalForm"],
                              "TraditionalForm"], "\[NoBreak]", 
                            FormBox[
                              FormBox[
                                InterpretationBox[
                                  SubscriptBox["e", "1"],
                                  Subscripted[ 
                                    e[ 1]],
                                  Editable->False],
                                "TraditionalForm"],
                              "TraditionalForm"]}]]}]}],
                    HoldForm],
                  "TraditionalForm"]}],
              HoldForm],
            "TraditionalForm"]}], "-", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "1"}]], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          SubscriptBox[
                            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"]], ")"}], "i"], " ", 
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox[
                            InterpretationBox[
                              SubscriptBox["c", "1"],
                              Subscripted[ 
                                c[ 1]],
                              Editable->False],
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        RowBox[{"(", 
                          SubscriptBox[
                            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"]], ")"}], 
                        RowBox[{
                          RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}], ")"}], 
                  " ", 
                  SubscriptBox["f", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], "\[NoBreak]", 
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], "\[NoBreak]", 
                      FormBox[
                        FormBox[
                          InterpretationBox[
                            SubscriptBox["c", "1"],
                            Subscripted[ 
                              c[ 1]],
                            Editable->False],
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}]}],
              HoldForm],
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"CovariantD", "[", 
        RowBox[{"OPEDelta", ",", "a", ",", "b"}], "]"}], "^", "OPEm"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", 
          SubsuperscriptBox["D", 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            RowBox[{"a", "b"}]], ")"}], "m"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CovariantD", "[", 
      RowBox[{"OPEDelta", ",", 
        RowBox[{"{", 
          RowBox[{"OPEm", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          RowBox[{"(", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], ")"}], "m"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SubscriptBox["g", "s"], " ", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "1"}]], 
                RowBox[{
                  SubscriptBox["T", 
                    FormBox[
                      FormBox[
                        InterpretationBox[
                          SubscriptBox["c", "1"],
                          Subscripted[ 
                            c[ 1]],
                          Editable->False],
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      SubscriptBox[
                        OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"]], ")"}], "i"], " ", 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        InterpretationBox[
                          SubscriptBox["c", "1"],
                          Subscripted[ 
                            c[ 1]],
                          Editable->False],
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      SubscriptBox[
                        OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"]], ")"}], 
                    RowBox[{
                      RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}]}],
              HoldForm],
            "TraditionalForm"]}], "-", 
        RowBox[{
          SubsuperscriptBox["g", "s", "2"], " ", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"j", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                FormBox[
                  TagBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{"i", "=", "0"}], "j"], 
                      RowBox[{
                        SubscriptBox["T", 
                          FormBox[
                            FormBox[
                              InterpretationBox[
                                SubscriptBox["c", "1"],
                                Subscripted[ 
                                  c[ 1]],
                                Editable->False],
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SubscriptBox["T", 
                          FormBox[
                            FormBox[
                              InterpretationBox[
                                SubscriptBox["c", "2"],
                                Subscripted[ 
                                  c[ 2]],
                                Editable->False],
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            SubscriptBox[
                              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]], ")"}], "i"], " ", 
                        SubsuperscriptBox[
                          FormBox["A",
                            "TraditionalForm"], 
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              InterpretationBox[
                                SubscriptBox["c", "1"],
                                Subscripted[ 
                                  c[ 1]],
                                Editable->False],
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            SubscriptBox[
                              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]], ")"}], 
                          RowBox[{"j", "-", "i"}]], " ", 
                        SubsuperscriptBox[
                          FormBox["A",
                            "TraditionalForm"], 
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox[
                              InterpretationBox[
                                SubscriptBox["c", "2"],
                                Subscripted[ 
                                  c[ 2]],
                                Editable->False],
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            SubscriptBox[
                              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]], ")"}], 
                          RowBox[{
                            RowBox[{"-", "j"}], "+", "m", "-", "2"}]]}]}],
                    HoldForm],
                  "TraditionalForm"]}],
              HoldForm],
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"CovariantD", "[", 
        RowBox[{"OPEDelta", ",", 
          RowBox[{"Explicit", "->", "True"}]}], "]"}], "//", "InputForm"}]], 
  "Input"],

Cell["\<\
-I*Gstrong*SUNT[SUNIndex[Subscripted[c[4]]]] . 
    QuantumField[GaugeField, Momentum[OPEDelta], 
     SUNIndex[Subscripted[c[4]]]] + 
  RightPartialD[Momentum[OPEDelta]]\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"CovariantD", "[", 
        RowBox[{"\[Mu]", ",", "a", ",", "b", ",", 
          RowBox[{"Explicit", "->", "True"}]}], "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData[
"RightPartialD[LorentzIndex[\[Mu]]]*SUNDelta[a, b] - \n  \
Gstrong*QuantumField[GaugeField, LorentzIndex[\[Mu]], \n    \
SUNIndex[Subscripted[c[5]]]]*\n   SUNF[a, b, Subscripted[c[5]]]"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["D0", "Section",
  CellTags->"D0"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "D0[ p10, p12, p23, p30, p20, p13,  m1^2, m2^2, m3^2, m4^2 ] is the \n\
Passarino-Veltman ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["D", "0"], TraditionalForm]]],
  " function. The convention for the arguments is that if the denominator of  \
the integrand has the form ([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2]  \
[(q+p3)^2-m4^2] ), the first six arguments of D0 are the \nscalar products  \
p10 = p1^2, p12 = (p1-p2)^2, p23 = (p2-p3)^2, p30 = p3^2, p20 = p2^2, p13 =  \
(p1-p3)^2."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["B0",
    ButtonData:>"B0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"B0"],
  ", ",
  ButtonBox["C0",
    ButtonData:>"C0",
    ButtonStyle->"Hyperlink",
    ButtonNote->"C0"],
  ", ",
  ButtonBox["PaVe",
    ButtonData:>"PaVe",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVe"],
  ", ",
  ButtonBox["PaVeOrder",
    ButtonData:>"PaVeOrder",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PaVeOrder"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"D0", "[", 
      RowBox[{
      "p10", ",", "p12", ",", "p23", ",", "p30", ",", "p20", ",", "p13", 
        ",", 
        RowBox[{"m1", "^", "2"}], ",", 
        RowBox[{"m2", "^", "2"}], ",", 
        RowBox[{"m3", "^", "2"}], ",", 
        RowBox[{"m4", "^", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "p10", ",", "p12", ",", "p23", ",", "p30", 
        ",", "p20", ",", "p13", ",", 
        FormBox[
          SuperscriptBox["m1", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m2", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m3", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m4", "2"],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PaVeOrder", "[", 
      RowBox[{
        RowBox[{"D0", "[", 
          RowBox[{
          "p10", ",", "p12", ",", "p23", ",", "p30", ",", "p20", ",", "p13", 
            ",", 
            RowBox[{"m1", "^", "2"}], ",", 
            RowBox[{"m2", "^", "2"}], ",", 
            RowBox[{"m3", "^", "2"}], ",", 
            RowBox[{"m4", "^", "2"}]}], "]"}], ",", 
        RowBox[{"PaVeOrderList", "->", 
          RowBox[{"{", 
            RowBox[{"p13", ",", "p20"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "p10", ",", "p30", ",", "p23", ",", "p12", 
        ",", "p13", ",", "p20", ",", 
        FormBox[
          SuperscriptBox["m2", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m1", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m4", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m3", "2"],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PaVeOrder", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
          "TraditionalForm"], "(", "p10", ",", "p12", ",", "p23", ",", "p30", 
        ",", "p20", ",", "p13", ",", 
        FormBox[
          SuperscriptBox["m1", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m2", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m3", "2"],
          "TraditionalForm"], ",", 
        FormBox[
          SuperscriptBox["m4", "2"],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DataType", "Section",
  CellTags->"DataType"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DataType[exp, type] = True   defines the object exp to have \
data-type type.
DataType[exp1, exp2, ..., type] defines the objects exp1, exp2, ...to have 
data-type type. The default setting is DataType[__, _] := False. To assign a 
certain data-type, do, e.g., DataType[x, PositiveInteger] = True.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DeclareNonCommutative",
    ButtonData:>"DeclareNonCommutative",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DeclareNonCommutative"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["NonCommutative is just a data-type.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"DataType", "[", 
          RowBox[{"f", ",", "g", ",", " ", "NonCommutative"}], "]"}], " ", 
        "=", " ", "True"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{
        RowBox[{"f", ".", "g"}], "-", 
        RowBox[{"g", ".", 
          RowBox[{"(", 
            RowBox[{"2", "a"}], ")"}], ".", "f"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"f", " ", "g"}], "-", 
        RowBox[{"g", " ", 
          RowBox[{"(", 
            RowBox[{"2", " ", "a"}], ")"}], " ", "f"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell["\<\
Since \"f \"and \"g\" have DataType NonCommutative the function \
DotSimplify 
extracts only \"a\" out of the noncommutative product.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"f", " ", "g"}], "-", 
        RowBox[{"2", " ", "a", " ", 
          RowBox[{"(", 
            RowBox[{"g", " ", "f"}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"DataType", "[", 
          RowBox[{"m", ",", "odd"}], "]"}], "=", 
        RowBox[{
          RowBox[{"DataType", "[", 
            RowBox[{"a", ",", "even"}], "]"}], "=", "True"}]}], ";"}]], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"ptest1", "[", "x_", "]"}], ":=", 
        RowBox[{"x", "/.", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "n_"], "/;", 
              RowBox[{"DataType", "[", 
                RowBox[{"n", ",", "odd"}], "]"}]}], "\[RuleDelayed]", 
            RowBox[{"-", "1"}]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"ptest2", "[", "x_", "]"}], ":=", 
        RowBox[{"x", "/.", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "n_"], "/;", 
              RowBox[{"DataType", "[", 
                RowBox[{"n", ",", "even"}], "]"}]}], "\[RuleDelayed]", 
            "1"}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "m"}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "a"}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "z"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "a"], "+", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "m"], "+", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "z"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ptest1", "[", "t", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "a"], "+", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "z"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ptest2", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "z"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        RowBox[{"ptest1", ",", "ptest2", ",", "t", ",", "a", ",", "m"}], 
        "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"DataType", "[", 
          RowBox[{"m", ",", "ganzeZahl"}], "]"}], "=", "True"}], ";"}]], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"f", "[", "x_", "]"}], ":=", 
        RowBox[{"x", "/.", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "p_"}], "/;", 
                RowBox[{"DataType", "[", 
                  RowBox[{"p", ",", "ganzeZahl"}], "]"}]}], ":>", "1"}], 
            "}"}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"test", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "m"}], "+", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", "x"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"], " ", "x"}], "+", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "m"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"f", "[", "test", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"], " ", "x"}], "+", "1"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        RowBox[{"f", ",", "test"}], "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"DataType", "[", 
          RowBox[{"f", ",", "g", ",", " ", "NonCommutative"}], "]"}], " ", 
        "=", " ", "False"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"DataType", "[", 
          RowBox[{"m", ",", "odd"}], "]"}], "=", 
        RowBox[{
          RowBox[{"DataType", "[", 
            RowBox[{"a", ",", "even"}], "]"}], "=", "False"}]}], ";"}]], 
  "Input"],

Cell["\<\
Certain FeynCalc objects have DataType PositiveInteger set to True.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DataType", "[", 
      RowBox[{"OPEm", ",", "PositiveInteger"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["True", TraditionalForm]], "Output"]
}, Open  ]],

Cell["PowerSimplify uses the DataType information.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PowerSimplify", "[", " ", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"(", 
          RowBox[{"2", "OPEm"}], ")"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PowerSimplify", "[", " ", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{"-", " ", 
            RowBox[{"SO", "[", "q", "]"}]}], ")"}], "^", "OPEm"}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "m"], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              FormBox["\<\"\[CapitalDelta]\"\>",
                "TraditionalForm"], 
              FormBox["\<\"\[CenterDot]\"\>",
                "TraditionalForm"], 
              FormBox["q",
                "TraditionalForm"]}], ")"}], "m"]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeclareNonCommutative", "Section",
  CellTags->"DeclareNonCommutative"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DeclareNonCommutative[a, b, ...] declares a,b, ... to be  \
non-commutative, 
i.e., DataType[a,b, ..., NonCommutative] is set to  True.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DataType",
    ButtonData:>"DataType",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DataType"],
  ", ",
  ButtonBox["UnDeclareNonCommutative",
    ButtonData:>"UnDeclareNonCommutative",
    ButtonStyle->"Hyperlink",
    ButtonNote->"UnDeclareNonCommutative"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", "x", "]"}]], "Input"],

Cell["\<\
As a side effect of DeclareNonCommutative x is declared to be of \
data type NonCommutative.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DataType", "[", 
      RowBox[{"x", ",", "NonCommutative"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["True", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"y", ",", "z"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DataType", "[", 
      RowBox[{"a", ",", "x", ",", "y", ",", "z", ",", "NonCommutative"}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"False", ",", "True", ",", "True", ",", "True"}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DataType", "[", 
      RowBox[{"a", ",", "x", ",", "y", ",", "z", ",", "NonCommutative"}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeltaFunction", "Section",
  CellTags->"DeltaFunction"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
" DeltaFunction[x] is the Dirac delta-function \[Delta](x)."], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Convolute",
    ButtonData:>"Convolute",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Convolute"],
  ", ",
  ButtonBox["DeltaFunctionPrime",
    ButtonData:>"DeltaFunctionPrime",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DeltaFunctionPrime"],
  ", ",
  ButtonBox["Integrate2",
    ButtonData:>"Integrate2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Integrate2"],
  ", ",
  ButtonBox["SimplifyDeltaFunction",
    ButtonData:>"SimplifyDeltaFunction",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SimplifyDeltaFunction"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DeltaFunction", "[", 
      RowBox[{"1", "-", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Delta]", "(", 
        FormBox[
          RowBox[{"1", "-", "x"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Integrate2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"DeltaFunction", "[", 
            RowBox[{"1", "-", "x"}], "]"}], " ", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"f", "(", "1", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Integrate2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"DeltaFunction", "[", "x", "]"}], " ", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"f", "(", "0", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Integrate2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"DeltaFunction", "[", 
            RowBox[{"1", "-", "x"}], "]"}], " ", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"f", "(", "1", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Convolute", "[", 
      RowBox[{
        RowBox[{"DeltaFunction", "[", 
          RowBox[{"1", "-", "x"}], "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["x", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeltaFunctionPrime", "Section",
  CellTags->"DeltaFunctionPrime"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
" DeltaFunctionPrime[1-x] is the derivative of the Dirac \[Delta]-function."],
   "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Convolute",
    ButtonData:>"Convolute",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Convolute"],
  ", ",
  ButtonBox["DeltaFunction",
    ButtonData:>"DeltaFunction",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DeltaFunction"],
  ", ",
  ButtonBox["Integrate2",
    ButtonData:>"Integrate2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Integrate2"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DeltaFunctionPrime", "[", 
      RowBox[{"1", "-", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Delta]", "\[Prime]"], "(", 
        FormBox[
          RowBox[{"1", "-", "x"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Integrate2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"DeltaFunctionPrime", "[", 
            RowBox[{"1", "-", "x"}], "]"}], " ", 
          RowBox[{"f", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "(", "1", ")"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Integrate2", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"DeltaFunctionPrime", "[", 
            RowBox[{"1", "-", "x"}], "]"}], " ", 
          RowBox[{"x", "^", "2"}]}], ",", 
        RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["2", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dimension", "Section",
  CellTags->"Dimension"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Dimension is an option of several functions and denotes the \
space-time 
dimension. Possible settings are:  4, n, d, D, ...  (the variable does not 
matter, but it should have head Symbol).\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracGammaCombine", "Section",
  CellTags->"DiracGammaCombine"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracGammaCombine[exp] is (nearly) the inverse operation to \
DiracGammaExpand.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracMatrix",
    ButtonData:>"DiracMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracMatrix"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracSlash",
    ButtonData:>"DiracSlash",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSlash"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGammaCombine", "[", 
      RowBox[{
        RowBox[{"GS", "[", "p", "]"}], " ", "+", " ", 
        RowBox[{"GS", "[", "q", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", "(", 
        FormBox[
          RowBox[{"p", "+", "q"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", "%", "]"}]], "Input"],

Cell["DiracGamma[Momentum[p + q]]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGammaCombine", "[", 
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{"GS", "[", "p", "]"}]}], " ", "-", " ", 
        RowBox[{"2", "  ", 
          RowBox[{"GS", "[", "q", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", "(", 
        FormBox[
          RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", "%", "]"}]], "Input"],

Cell["DiracGamma[Momentum[2*p - 2*q]]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGammaExpand", "[", "%%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}]}], "-", 
        RowBox[{"2", " ", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}]}]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracGammaExpand", "Section",
  CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracGammaExpand[exp] expands all DiracGamma[Momentum[a+b+..]] in \
exp into (DiracGamma[Momentum[a]] + DiracGamma[Momentum[b]] + ...).\
\>", 
  "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["DiracGammaCombine",
    ButtonData:>"DiracGammaCombine",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaCombine"],
  ", ",
  ButtonBox["DiracMatrix",
    ButtonData:>"DiracMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracMatrix"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracSlash",
    ButtonData:>"DiracSlash",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSlash"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{
        RowBox[{"DiracGamma", "[", 
          RowBox[{"Momentum", "[", "q", "]"}], "]"}], " ", ".", " ", 
        RowBox[{"DiracGamma", "[", 
          RowBox[{"Momentum", "[", 
            RowBox[{"p", "-", "q"}], "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Momentum is the head of p-q, i.e., it is treated as one \
four-momentum.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", "t", "]"}]], "Input"],

Cell["DiracGamma[Momentum[q]] . DiracGamma[Momentum[p - q]]", "Output"]
}, Open  ]],

Cell["With DiracGammaExpand the Momentum[p-q] gets expanded.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGammaExpand", "[", "t", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], "-", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["The inverse operation is DiracGammaCombine.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"DiracGammaCombine", "[", 
        RowBox[{"DiracGammaExpand", "[", "t", "]"}], "]"}], "]"}]], "Input"],

Cell["DiracGamma[Momentum[q]] . DiracGamma[Momentum[p - q]]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"DiracGammaExpand", "[", "t", "]"}], "]"}]], "Input"],

Cell["\<\
DiracGamma[Momentum[q]] . 
  (DiracGamma[Momentum[p]] - DiracGamma[Momentum[q]])\
\>", "Output"]
}, Open  ]],

Cell["In order to do non-commutative expansion use DiracSimplify.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}]}], "-", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", "t", "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracGamma", "Section",
  CellTags->"DiracGamma"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      FormBox["DiracGamma", TraditionalForm]]],
  "[x, dim] is the head of all Dirac matrices and slashes (in the internal   \
representation). Use DiracMatrix (or GA, GAD) and DiracSlash (or GS, GSD) for \
  manual (short) input. \nDiracGamma[x, 4] simplifies to DiracGamma[x].\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"DiracGamma", "[", "5", "]"}], " ", "is", 
          RowBox[{"\[Gamma]", "^", "5"}]}], TraditionalForm]]],
  ". \nDiracGamma[6] is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "+", 
              RowBox[{"\[Gamma]", "^", "5"}]}], ")"}], "/", "2."}], 
        TraditionalForm]]],
  "\nDiracGamma[7] is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{"1", "-", 
              RowBox[{"\[Gamma]", "^", "5"}]}], ")"}], "/", "2."}], 
        TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracMatrix",
    ButtonData:>"DiracMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracMatrix"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracSlash",
    ButtonData:>"DiracSlash",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSlash"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGamma", "[", "5", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "5"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGamma", "[", 
      RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "\[Alpha]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "\[Gamma]\[NoBreak]\[CenterDot]",
  StyleBox["\[NoBreak]q",
    FontSlant->"Italic"],
  " denotes q\[NegativeMediumSpace]\[NegativeThinSpace]/ (= ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"\[Gamma]", "^", "\[Mu]"}], 
              SubscriptBox["q", "\[Mu]"]}], ")"}], "."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracGamma", "[", 
        RowBox[{"Momentum", "[", "q", "]"}], "]"}], " "}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracGamma", "[", 
        RowBox[{"Momentum", "[", "q", "]"}], "]"}], " ", ".", " ", 
      RowBox[{"DiracGamma", "[", 
        RowBox[{"Momentum", "[", 
          RowBox[{"p", "-", "q"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracGamma", "[", 
        RowBox[{
          RowBox[{"Momentum", "[", 
            RowBox[{"q", ",", "D"}], "]"}], ",", "D"}], "]"}], " "}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a1", "=", 
      RowBox[{
        RowBox[{"GS", "[", 
          RowBox[{"p", "-", "q"}], "]"}], ".", 
        RowBox[{"GS", "[", "p", "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a2", "=", 
      RowBox[{"DiracGammaExpand", "[", "a1", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], "-", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], ")"}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a3", "=", 
      RowBox[{
        RowBox[{"GAD", "[", "\[Mu]", "]"}], ".", 
        RowBox[{"GSD", "[", 
          RowBox[{"p", "-", "q"}], "]"}], ".", 
        RowBox[{"GSD", "[", "q", "]"}], ".", 
        RowBox[{"GAD", "[", "\[Mu]", "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a4", "=", 
      RowBox[{"DiracTrick", "[", "a3", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"D", "-", "4"}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", "(", 
                FormBox[
                  RowBox[{"p", "-", "q"}],
                  "TraditionalForm"], ")"}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            FormBox[
              RowBox[{"p", "-", "q"}],
              "TraditionalForm"], ")", "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a5", "=", 
      RowBox[{"DiracSimplify", "[", "a4", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"D", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}]}], "-", 
        RowBox[{"D", " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], "2"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5"}], "]"}]], 
  "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracGammaT", "Section",
  CellTags->"DiracGammaT"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracGammaT[x] denotes the transpose of DiracGamma[x].  
Transpose[DiracGammaT[x]] gives DiracGamma[x]. Note that x must have Head \
LorentzIndex or Momentum.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracGammaT", "[", 
      RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["\[Gamma]", 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"], "T"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transpose", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"GS", "[", "p", "]"}], "//", "FCI"}], "//", "Transpose"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", "\[Gamma]", "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"], ")"}], "T"], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracMatrix", "Section",
  CellTags->"DiracMatrix"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "DiracMatrix[\[Mu]] denotes a Dirac \[Gamma] matrix with Lorentz index  \
\[Mu].\nDiracMatrix[\[Mu],\[Nu] ..] is a product of \[Gamma] matrices with  \
Lorentz indices \[Mu], \[Nu], etc.\nDiracMatrix[5] is ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  ".\nDiracMatrix[6] is ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", "2"}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"+", "  ", 
              SuperscriptBox["\[Gamma]", "5"]}], "/", "2"}]}], TraditionalForm
        ]]],
  ".\nDiracMatrix[7] is",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", "1", "/", "2"}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"-", "  ", 
              SuperscriptBox["\[Gamma]", "5"]}], "/", "2"}]}], TraditionalForm
        ]]],
  "."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracSlash",
    ButtonData:>"DiracSlash",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSlash"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  ", ",
  ButtonBox["GA",
    ButtonData:>"GA",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GA"],
  ", ",
  ButtonBox["GAD",
    ButtonData:>"GAD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GAD"],
  ", ",
  ButtonBox["GS",
    ButtonData:>"GS",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GS"],
  ", ",
  ButtonBox["GSD",
    ButtonData:>"GSD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GSD"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
      RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracMatrix", "[", "\[Alpha]", "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData["DiracGamma[LorentzIndex[\[Alpha]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], "//", "FCE"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData["GA[\[Mu]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "[", "\[Mu]", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"%", "//", "FCI"}], "//", "InputForm"}]], "Input"],

Cell[TextData["DiracGamma[LorentzIndex[\[Mu], D], D]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GA", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracOrder", "Section",
  CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracOrder[expr] orders the Dirac matrices in expr alphabetically. 
DiracOrder[expr,orderlist] orders the Dirac matrices in expr according to 
orderlist.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", " ", "=", " ", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Beta]", ",", "\[Alpha]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
          SuperscriptBox["\[Gamma]", "\[Beta]"]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{"GAD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
          SuperscriptBox["\[Gamma]", "\[Beta]"]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "By default ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", "5"}], " ", "is", "moved", "to", "the", 
          " ", 
          RowBox[{"right", "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "6"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", "t4", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t5", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Delta]"}], "]"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This orders the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", 
            FormBox["\[Alpha]",
              "TraditionalForm"]}], 
          RowBox[{"\[Gamma]", "^", 
            FormBox["\[Beta]",
              "TraditionalForm"]}], 
          RowBox[{"\[Gamma]", "^", 
            FormBox["\[Delta]",
              "TraditionalForm"]}]}], TraditionalForm]]],
  " in reverse order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", 
      RowBox[{"t5", ",", 
        RowBox[{"{", 
          RowBox[{"\[Delta]", ",", "\[Beta]", ",", "\[Alpha]"}], "}"}]}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Delta]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Alpha]"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
          SuperscriptBox["\[Gamma]", "\[Delta]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
        RowBox[{"2", " ", 
          SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Delta]"}]]}], "+", 
        RowBox[{"2", " ", 
          SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Beta]", "\[Delta]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracOrder", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5"}], "]"}]], 
  "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracReduce", "Section",
  CellTags->"DiracReduce"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracReduce[exp] reduces all four-dimensional Dirac matrices in exp \
to the 
standard basis (S,P,V,A,T) using the Chisholm identity (see Chisholm). In the \

result the basic Dirac structures are wrapped with a head  DiracBasis. I.e.,
S corresponds to DiracBasis[1],  
P : DiracBasis[DiracMatrix[5]],
V: DiracBasis[DiracMatrix[mu]], 
A: DiracBasis[DiracMatrix[mu, 5]], 
T: DiracBasis[DiracSigma[DiracMatrix[mu, nu]]]. 
By default DiracBasis is substituted to Identity. Notice that the result of 
DiracReduce is given in the FeynCalcExternal - way, i.e.,evtl. you may have \
to use FeynCalcInternal on the result.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DiracReduce", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
          RowBox[{"FinalSubstitutions", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{"DiracBasis", "\[Rule]", "Identity"}], "}"}]}]}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", " ", "=", " ", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracReduce", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["t2 = DiracMatrix[\[Mu],\[Nu],\[Rho]]"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], 
        SuperscriptBox["\[Gamma]", "\[Nu]"], 
        SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracReduce[t2]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                RowBox[{"$MU", "(", "1", ")"}]], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", 
              FormBox[
                RowBox[{"$MU", "(", "1", ")"}],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["t3 = DiracMatrix[\[Mu],\[Nu],\[Rho],\[Sigma]]"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], 
        SuperscriptBox["\[Gamma]", "\[Nu]"], 
        SuperscriptBox["\[Gamma]", "\[Rho]"], 
        SuperscriptBox["\[Gamma]", "\[Sigma]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t4 = DiracReduce[t3]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["\[Gamma]", "5"], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Rho]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[Sigma]", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t5", " ", "=", 
      RowBox[{"Calc", "[", 
        RowBox[{"DiracSimplify", "[", 
          RowBox[{"DiracSigmaExplicit", "[", 
            RowBox[{"t4", ".", "t4"}], "]"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "128"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"t4", ".", "t4"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "128"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSigmaExplicit", "Section",
  CellTags->"DiracSigmaExplicit"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracSigmaExplicit[exp] inserts in exp for all  DiracSigma its \
definition. 
DiracSigmaExplict is also an option of DiracSimplify.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSigma",
    ButtonData:>"DiracSigma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSigma"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSigma", "[", 
      RowBox[{
        RowBox[{"GA", "[", "\[Alpha]", "]"}], ",", 
        RowBox[{"GA", "[", "\[Beta]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Sigma]", 
        RowBox[{"\[Alpha]", "\[Beta]"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSigmaExplicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Beta]"]}], "-", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Alpha]"]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSigma", "Section",
  CellTags->"DiracSigma"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracSigma[a, b] stands for i/2*(a . b - b . a) in 4 dimensions.  a \
and b must have Head DiracGamma, DiracMatrix or DiracSlash. Only antisymmetry \
is implemented.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSigmaExplicit",
    ButtonData:>"DiracSigmaExplicit",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSigmaExplicit"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[TextData["t1 = DiracSigma[GA[\[Alpha]],GA[\[Beta]]]"], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Sigma]", 
        RowBox[{"\[Alpha]", "\[Beta]"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSigmaExplicit[t1]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Beta]"]}], "-", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Alpha]"]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["t2 = DiracSigma[GA[\[Beta]],GA[\[Alpha]]]"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        SuperscriptBox["\[Sigma]", 
          RowBox[{"\[Alpha]", "\[Beta]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t3 = DiracSigma[GS[p],GS[q]]", "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Sigma]", 
        RowBox[{"p", "q"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSigmaExplicit", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], "-", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "t2", ",", "t3"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSimplify", "Section",
  CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracSimplify[expr]   simplifies products of Dirac matrices in expr \
and 
expands non-commutative products. Double Lorentz indices and four vectors are \
contracted. The Dirac equation is applied.
All DiracMatrix[5], DiracMatrix[6] and DiracMatrix[7] are moved to the right. \
The order of the other Dirac matrices is not changed.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DiracSimplify", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"DiracCanonical", "\[Rule]", "False"}], ",", 
          RowBox[{"DiracSigmaExplicit", "\[Rule]", "True"}], ",", 
          RowBox[{"DiracSimpCombine", "\[Rule]", "False"}], ",", 
          RowBox[{"DiracSubstitute67", "\[Rule]", "False"}], ",", 
          RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
          RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
          RowBox[{"FeynCalcInternal", "\[Rule]", "False"}], ",", 
          RowBox[{"InsideDiracTrace", "\[Rule]", "False"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  ", ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["This is a string of Dirac matrices in four dimensions. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{"GAD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "By default ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", "5"}], " ", "is", "moved", "to", "the", 
          " ", 
          RowBox[{"right", "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "6"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t4", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t5", "=", 
      RowBox[{
        RowBox[{"GS", "[", 
          RowBox[{"a", "+", "b"}], "]"}], " ", ".", " ", 
        RowBox[{"GS", "[", "p", "]"}], ".", 
        RowBox[{"GS", "[", "p", "]"}], ".", 
        RowBox[{"GS", "[", 
          RowBox[{"c", "+", "d"}], "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"a", "+", "b"}],
            "TraditionalForm"], ")"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"c", "+", "d"}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Contrary to DiracTrick DiracSimplify does non-commutative \
expansion.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t5", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["a",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["c",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["a",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["d",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["b",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["c",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["b",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["d",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t5", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", "(", 
              FormBox[
                RowBox[{"a", "+", "b"}],
                "TraditionalForm"], ")"}], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", "(", 
              FormBox[
                RowBox[{"c", "+", "d"}],
                "TraditionalForm"], ")"}]}], ")"}], " ", 
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t6", " ", "=", " ", 
      RowBox[{
        RowBox[{"SpinorVBar", "[", "p", "]"}], " ", ".", " ", 
        RowBox[{"GS", "[", "p", "]"}], " ", ".", " ", 
        RowBox[{"SpinorUBar", "[", "q", "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            OverscriptBox["\<\"v\"\>", "_"],
            "TraditionalForm"], "(", "p", ")"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
        RowBox[{
          FormBox[
            OverscriptBox["\<\"u\"\>", "_"],
            "TraditionalForm"], "(", "q", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "t6", "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "@@", 
      RowBox[{"Join", "[", 
        RowBox[{
          RowBox[{"{", "\[Mu]", "}"}], ",", 
          RowBox[{"Table", "[", 
            RowBox[{
              SubscriptBox["\[Nu]", "i"], ",", 
              RowBox[{"{", 
                RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", "\[Mu]", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "1"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "2"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "3"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "4"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "5"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "6"]], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"D", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}]}], "-", 
        RowBox[{"12", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "1"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "2"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "1"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "3"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "1"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "4"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "1"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "5"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "1"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "6"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "2"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "3"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "2"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "4"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "2"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "5"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "2"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "6"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "3"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "4"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "3"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "5"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "3"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "6"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "4"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "5"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "4"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "6"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "5"],
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  SubscriptBox["\[Nu]", "6"],
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
 With the option DiracCanonical an alphabetic ordering is \
done.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{"\[Nu]", ",", "\[Mu]"}], "]"}], ",", 
        RowBox[{"DiracCanonical", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
          SuperscriptBox["\[Gamma]", "\[Nu]"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[
"Setting InsideDiracTrace\[Rule]True assumes that a trace is still to be   \
taken (later)."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
          "]"}], ",", 
        RowBox[{"InsideDiracTrace", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}], ",", 
        RowBox[{"InsideDiracTrace", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5", ",", "t6"}], 
      "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSimplify2", "Section",
  CellTags->"DiracSimplify2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "DiracSimplify2[exp] simplifies the Dirac structure but leaves any ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
  " untouched."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "[", 
      RowBox[{
      "\[Mu]", ",", "\[Nu]", ",", "\[Mu]", ",", "5", ",", "\[Alpha]", ",", 
        "\[Beta]", ",", "\[Alpha]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSimplify2", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Beta]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracSlash", "Section",
  CellTags->"DiracSlash"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "DiracSlash[p] is the contraction ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"p", "^", "\[Mu]"}], 
          SubscriptBox["\[Gamma]", "\[Mu]"], " "}], TraditionalForm]]],
  "(FourVector[p, \[Mu]] DiracMatrix[\[Mu]]).  Products of those can be   \
entered in the form DiracSlash[p1, p2, ...]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DiracSlash", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Dimension", "\[Rule]", "4"}], ",", 
          RowBox[{"FeynCalcInternal", "\[Rule]", "True"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracGamma",
    ButtonData:>"DiracGamma",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGamma"],
  ", ",
  ButtonBox["DiracMatrix",
    ButtonData:>"DiracMatrix",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracMatrix"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  ", ",
  ButtonBox["DiracTrick",
    ButtonData:>"DiracTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrick"],
  ", ",
  ButtonBox["GS",
    ButtonData:>"GS",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GS"],
  ", ",
  ButtonBox["GSD",
    ButtonData:>"GSD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GSD"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "This is q\[NegativeMediumSpace]\[NegativeThinSpace]/  (= ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"\[Gamma]", "^", "\[Mu]"}], 
              SubscriptBox["q", "\[Mu]"]}], ")"}], "."}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSlash", "[", "q", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
      RowBox[{"DiracSlash", "[", "q", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracSlash", "[", 
      RowBox[{"p", ",", "q"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GS", "[", "p", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracSlash", "[", "q", "]"}], "//", "InputForm"}]], "Input"],

Cell["DiracGamma[Momentum[q]]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracSlash", "[", 
        RowBox[{"q", ",", 
          RowBox[{"Dimension", "->", "n"}]}], "]"}], "//", "InputForm"}]], 
  "Input"],

Cell["DiracGamma[Momentum[q, n], n]", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracTrace", "Section",
  CellTags->"DiracTrace"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DiracTrace[expr] is the head of Dirac Traces. Whether the trace is  \
evaluated depends on the option DiracTraceEvaluate. Direct trace evaluation \
is 
performed by Tr. The argument expr may be a product of Dirac matrices or 
slashes separated by the Mathematica Dot \".\".\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DiracTrace", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"EpsContract", "\[Rule]", "False"}], ",", 
          RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
          RowBox[{"FeynCalcExternal", "\[Rule]", "False"}], ",", 
          RowBox[{"Mandelstam", "\[Rule]", 
            RowBox[{"{", "}"}]}], ",", 
          RowBox[{"PairCollect", "\[Rule]", "True"}], ",", 
          RowBox[{"DiracTraceEvaluate", "\[Rule]", "False"}], ",", 
          RowBox[{"Schouten", "\[Rule]", "0"}], ",", 
          RowBox[{"LeviCivitaSign", "\[Rule]", 
            RowBox[{"-", "1"}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "For comments regarding ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", "^", "5"}], TraditionalForm]]],
  "schemes see the notes for Tr."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Tr",
    ButtonData:>"Tr",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Tr"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Nu]"]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
        "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Sigma]"]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", " ", "/.", " ", 
      RowBox[{"DiracTrace", "\[Rule]", "Tr"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{
          "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", "5"}], 
          "]"}], ",", 
        RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{
          "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", 
            "\[Delta]", ",", "\[Tau]", ",", "5"}], "]"}], ",", 
        RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Delta]", "\[Mu]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Delta]", "\[Nu]"}]]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Delta]", "\[Rho]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Delta]", "\[Sigma]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Delta]", "\[Tau]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Sigma]"}]]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Tau]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Tau]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["\[Delta]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{"GS", "[", 
        RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
            RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], " ", 
            RowBox[{"\[Gamma]", "\[CenterDot]", "r"}], " ", 
            RowBox[{"\[Gamma]", "\[CenterDot]", "s"}]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{
        RowBox[{"GA", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], ",", 
        RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}], ",", 
        RowBox[{"FCE", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData["4*MT[\[Mu], \[Nu]]"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiracTrick", "Section",
  CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"DiracTrick[exp] contracts  \[Gamma]-matrices with each other and performs   \
several simplifications (no expansion, use Calc or DiracSimplify for this)."],
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DiracTrick", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"Expanding", "\[Rule]", "False"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  ", ",
  ButtonBox["DiracGammaExpand",
    ButtonData:>"DiracGammaExpand",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracGammaExpand"],
  ", ",
  ButtonBox["DiracSimplify",
    ButtonData:>"DiracSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["This is a string of Dirac matrices in four dimensions. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{"GAD", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"2", "-", "D"}], ")"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "5"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "By default ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "^", "5"}], " ", "is", "moved", "to", "the", 
          " ", 
          RowBox[{"right", "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{"GA", "[", 
        RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "6"], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t4", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t5", "=", 
      RowBox[{
        RowBox[{"GS", "[", 
          RowBox[{"a", "+", "b"}], "]"}], " ", ".", " ", 
        RowBox[{"GS", "[", "p", "]"}], ".", 
        RowBox[{"GS", "[", "p", "]"}], ".", 
        RowBox[{"GS", "[", 
          RowBox[{"c", "+", "d"}], "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"a", "+", "b"}],
            "TraditionalForm"], ")"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
        RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
          FormBox[
            RowBox[{"c", "+", "d"}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "t5", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", "(", 
              FormBox[
                RowBox[{"a", "+", "b"}],
                "TraditionalForm"], ")"}], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", "(", 
              FormBox[
                RowBox[{"c", "+", "d"}],
                "TraditionalForm"], ")"}]}], ")"}], " ", 
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", "t5", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["a",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["c",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["a",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["d",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["b",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["c",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["b",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["d",
                  "TraditionalForm"]}]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], "2"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GAD", "@@", 
      RowBox[{"Join", "[", 
        RowBox[{
          RowBox[{"{", "\[Mu]", "}"}], ",", 
          RowBox[{"Table", "[", 
            RowBox[{
              SubscriptBox["\[Nu]", "i"], ",", 
              RowBox[{"{", 
                RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", "\[Mu]", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "1"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "2"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "3"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "4"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "5"]], " ", 
        SuperscriptBox["\[Gamma]", 
          SubscriptBox["\[Nu]", "6"]], " ", 
        SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrick", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{"D", "-", "12"}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "1"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "2"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "3"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "4"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "5"]], " ", 
              SuperscriptBox["\[Gamma]", 
                SubscriptBox["\[Nu]", "6"]]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox["\[Gamma]", 
                        SubscriptBox["\[Nu]", "3"]], " ", 
                      SuperscriptBox["\[Gamma]", 
                        SubscriptBox["\[Nu]", "4"]], " ", 
                      SuperscriptBox["\[Gamma]", 
                        SubscriptBox["\[Nu]", "5"]], " ", 
                      SuperscriptBox["\[Gamma]", 
                        SubscriptBox["\[Nu]", "6"]]}], ")"}]}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "2"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "3"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "4"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "1"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "6"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "2"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "3"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "2"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "4"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "2"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "2"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "6"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "3"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "4"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "3"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "3"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "6"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "6"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "4"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "5"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "4"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "6"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], "-", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "1"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "2"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "3"]], " ", 
                    SuperscriptBox["\[Gamma]", 
                      SubscriptBox["\[Nu]", "4"]]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "5"],
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox[
                        SubscriptBox["\[Nu]", "6"],
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DotSimplify", "Section",
  CellTags->"DotSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
DotSimplify[expr] expands and reorders noncommutative terms in \
expr.  
Simplifying relations may be specified by the option DotSimplifyRelations or \
by Commutator and AntiCommutator definitions. 
Whether expr is expanded noncommutatively depends on the option \
Expanding.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "DotSimplify", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
          RowBox[{"DotSimplifyRelations", "\[Rule]", 
            RowBox[{"{", "}"}]}], ",", 
          RowBox[{"DotPower", "\[Rule]", "True"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["AntiCommutator",
    ButtonData:>"AntiCommutator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"AntiCommutator"],
  ", ",
  ButtonBox["Commutator",
    ButtonData:>"Commutator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Commutator"],
  ", ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{
        RowBox[{"GA", "[", "\[Mu]", "]"}], ".", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{"GS", "[", "p", "]"}]}], "-", 
            RowBox[{"GS", "[", "q", "]"}]}], ")"}], ".", 
        RowBox[{"GA", "[", "\[Nu]", "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], "-", 
            RowBox[{"\[Gamma]", "\[CenterDot]", "q"}]}], ")"}], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t1", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"]}], ")"}]}], "-", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], " ", 
          SuperscriptBox["\[Gamma]", "\[Nu]"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{"a", ".", 
        RowBox[{"(", 
          RowBox[{"b", "-", 
            RowBox[{"z", " ", "c"}]}], ")"}], ".", "a"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"a", " ", 
        RowBox[{"(", 
          RowBox[{"b", "-", 
            RowBox[{"c", " ", "z"}]}], ")"}], " ", "a"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b", " ", "a"}], "-", 
        RowBox[{"z", " ", 
          RowBox[{"(", 
            RowBox[{"a", " ", "c", " ", "a"}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Commutator", "[", 
        RowBox[{"a", ",", "c"}], "]"}], "=", "1"}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b", " ", "a"}], "-", 
        RowBox[{"z", " ", 
          RowBox[{"(", 
            RowBox[{"a", "+", 
              RowBox[{"c", " ", 
                SuperscriptBox["a", "2"]}]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"Commutator", "[", 
        RowBox[{"a", ",", "c"}], "]"}], "=", "."}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b", " ", "a"}], "-", 
        RowBox[{"z", " ", 
          RowBox[{"(", 
            RowBox[{"a", " ", "c", " ", "a"}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{"b", ",", "a"}], "]"}], "=", "c"}]], "Input"],

Cell[BoxData[
    FormBox["c", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "c"}], "-", 
        RowBox[{
          SuperscriptBox["a", "2"], " ", "b"}], "-", 
        RowBox[{"z", " ", 
          RowBox[{"(", 
            RowBox[{"a", " ", "c", " ", "a"}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"AntiCommutator", "[", 
        RowBox[{"b", ",", "a"}], "]"}], "=", "."}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", 
      RowBox[{"t2", ",", 
        RowBox[{"DotSimplifyRelations", "\[Rule]", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"a", ".", "c"}], "\[Rule]", 
              RowBox[{"1", "/", "z"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"a", " ", "b", " ", "a"}], "-", "a"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"DeclareNonCommutative", "[", "x", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", 
      RowBox[{"x", ".", "x", ".", "x"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["x", "3"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DotSimplify", "[", 
      RowBox[{
        RowBox[{"x", ".", "x", ".", "x"}], ",", 
        RowBox[{"DotPower", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"x", " ", "x", " ", "x"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"UnDeclareNonCommutative", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EpsChisholm", "Section",
  CellTags->"EpsChisholm"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
EpsChisholm[expr] substitutes for a gamma matrix contracted with a \
Levi 
Civita tensor (Eps) the Chisholm identity.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Chisholm",
    ButtonData:>"Chisholm",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Chisholm"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Chisholm", "[", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
        "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "$MU$667"], " ", 
              SuperscriptBox["\[Gamma]", "\[Sigma]"], " ", 
              SuperscriptBox["\[Gamma]", "5"]}], ")"}], " ", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["$MU$667",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Sigma]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Sigma]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Sigma]"]}], ")"}], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"EpsChisholm", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
        SuperscriptBox["\[Gamma]", "\[Sigma]"]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EpsEvaluate", "Section",
  CellTags->"EpsEvaluate"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
EpsEvaluate[expr] applies total antisymmetry and linearity (w.r.t. 
Momentum's)  to all Levi-Civita tensors (Eps') in expr.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Contract",
    ButtonData:>"Contract",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Contract"],
  ", ",
  ButtonBox["Eps",
    ButtonData:>"Eps",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Eps"],
  ", ",
  ButtonBox["LeviCivita",
    ButtonData:>"LeviCivita",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeviCivita"],
  ", ",
  ButtonBox["Trick",
    ButtonData:>"Trick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Trick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Trick", "[", 
      RowBox[{
        RowBox[{"LeviCivita", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
          "]"}], " ", 
        RowBox[{"FourVector", "[", 
          RowBox[{
            RowBox[{"p", "+", "q"}], ",", "\[Sigma]"}], "]"}]}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            RowBox[{"p", "+", "q"}],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"EpsEvaluate", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox["p",
              "TraditionalForm"]}]], "+", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox["q",
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", "%", "]"}]], "Input"],

Cell[TextData[
"Eps[LorentzIndex[\[Mu]], LorentzIndex[\[Nu]], \n   LorentzIndex[\[Rho]], \
Momentum[p]] + \n  Eps[LorentzIndex[\[Mu]], LorentzIndex[\[Nu]], \n   \
LorentzIndex[\[Rho]], Momentum[q]]"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Epsilon", "Section",
  CellTags->"Epsilon"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "Epsilon is (",
  StyleBox["n",
    FontSlant->"Italic"],
  "-4), where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the space-time dimension. Epsilon stands for a small positive number."
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Series2",
    ButtonData:>"Series2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Series2"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData["Epsilon"], "Input"],

Cell[BoxData[
    FormBox[
      TagBox["\[CurlyEpsilon]",
        TraditionalForm], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Epsilon has no functional properties, but some upvalues are \
changed:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
          RowBox[{"-", "4"}]}], ",", 
        RowBox[{
          RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
          RowBox[{"-", "3"}]}], ",", 
        RowBox[{
          RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
          RowBox[{"-", "2"}]}], ",", 
        RowBox[{
          RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
          RowBox[{"-", "1"}]}], ",", 
        RowBox[{
          RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", "0"}]}], 
      "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eps", "Section",
  CellTags->"Eps"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"Eps[a, b, c, d] is the head of the totally antisymmetric \[Epsilon] -   \
(Levi-Civita) tensor. The a,b, ... may have head LorentzIndex, Momentum or   \
Integer. In case of integers the Levi-Civita tensor is evaluated immediately. \
  "], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Eps", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"Dimension", "\[Rule]", "4"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["EpsEvaluate",
    ButtonData:>"EpsEvaluate",
    ButtonStyle->"Hyperlink",
    ButtonNote->"EpsEvaluate"],
  ", ",
  ButtonBox["LC",
    ButtonData:>"LC",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LC"],
  ", ",
  ButtonBox["LCD",
    ButtonData:>"LCD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LCD"],
  ", ",
  ButtonBox["LeviCivita",
    ButtonData:>"LeviCivita",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeviCivita"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Eps", "[", 
      RowBox[{
        RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Sigma]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Eps", "[", 
      RowBox[{
        RowBox[{"Momentum", "[", "p", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"LorentzIndex", "[", "\[Sigma]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Eps", "[", 
        RowBox[{"b", ",", "a", ",", "c", ",", "d"}], "]"}], "//", 
      "InputForm"}]], "Input"],

Cell["-Eps[a, b, c, d]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Eps", "[", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Eps", "[", 
      RowBox[{"1", ",", "0", ",", "2", ",", "3"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "1"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a1", " ", "=", 
      RowBox[{"Eps", "[", 
        RowBox[{
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Sigma]", ",", "D"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Contract", "[", 
      RowBox[{"a1", "a1"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", "24"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetOptions", "[", 
        RowBox[{"Eps", ",", 
          RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a2", " ", "=", 
      RowBox[{"Eps", "[", 
        RowBox[{
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
          RowBox[{"LorentzIndex", "[", 
            RowBox[{"\[Sigma]", ",", "D"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Rho]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Contract", "[", 
        RowBox[{"a2", "a2"}], "]"}], "//", "Factor2"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"1", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"2", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"3", "-", "D"}], ")"}], " ", "D"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"g5 = -I/24 LCD[\[Mu],\[Nu],\[Rho],\[Alpha]] .  GAD[\[Mu],\[Nu],\[Rho], \
\[Alpha]]//FCI"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Epsilon]", 
              RowBox[{
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Alpha]",
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Alpha]"]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"g5p = -I/24 LCD[\[Mu]',\[Nu]',\[Rho]',\[Alpha]'] . \n GAD[\[Mu]',\[Nu]', \
\[Rho]',\[Alpha]']//FCI"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Epsilon]", 
              RowBox[{
                FormBox[
                  FormBox[
                    SuperscriptBox["\[Mu]", "\[Prime]",
                      MultilineFunction->None],
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox[
                    SuperscriptBox["\[Nu]", "\[Prime]",
                      MultilineFunction->None],
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox[
                    SuperscriptBox["\[Rho]", "\[Prime]",
                      MultilineFunction->None],
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox[
                    SuperscriptBox["\[Alpha]", "\[Prime]",
                      MultilineFunction->None],
                    "TraditionalForm"],
                  "TraditionalForm"]}]], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Mu]", "\[Prime]",
                  MultilineFunction->None],
                "TraditionalForm"]], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Nu]", "\[Prime]",
                  MultilineFunction->None],
                "TraditionalForm"]], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Rho]", "\[Prime]",
                  MultilineFunction->None],
                "TraditionalForm"]], " ", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                SuperscriptBox["\[Alpha]", "\[Prime]",
                  MultilineFunction->None],
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["g52 = Calc[g5 . g5p]//Factor2", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "24"]}], " ", 
        RowBox[{"(", 
          RowBox[{"1", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"2", "-", "D"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"3", "-", "D"}], ")"}], " ", "D"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"g52", "/.", 
      RowBox[{"D", "\[Rule]", "4"}]}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"a1", ",", "a2", ",", "g5", ",", "g5p"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExpandPartialD", "Section",
  CellTags->"ExpandPartialD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ExpandPartialD[exp] expands all products of QuantumField's and \
partial differentiation operators in exp and applies Leibniz rule.\
\>", 
  "Text"],

Cell[TextData[{
  "See also:  ",
  ButtonBox["ExplicitPartialD",
    ButtonData:>"ExplicitPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ExplicitPartialD"],
  ", ",
  ButtonBox["LeftPartialD",
    ButtonData:>"LeftPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftPartialD"],
  ", ",
  ButtonBox["LeftRightPartialD",
    ButtonData:>"LeftRightPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftRightPartialD"],
  ", ",
  ButtonBox["RightPartialD",
    ButtonData:>"RightPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"RightPartialD"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"RightPartialD", "[", "\[Mu]", "]"}], ".", 
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["A", "\[Mu]"], " ", 
        SubscriptBox["A", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["A", "\[Mu]"], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], "\[Null]"]}]}], "+", 
        RowBox[{
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], "\[Null]"]}], " ", 
          SubscriptBox["A", "\[Nu]"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"QuantumField[A, LorentzIndex[\[Mu]]] . \n   \
QuantumField[PartialD[LorentzIndex[\[Mu]]], A, \n    LorentzIndex[\[Nu]]] + \n\
  QuantumField[PartialD[LorentzIndex[\[Mu]]], A, \n    LorentzIndex[\[Mu]]] . \
\n   QuantumField[A, LorentzIndex[\[Nu]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"LeftRightPartialD", "[", "\[Mu]", "]"}], ".", 
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["A", "\[Nu]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], "\[Null]"]}], "2"], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["A", "\[Nu]"]}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "2"}], 
        ")"}], ".", 
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["A", "\[Mu]"], " ", 
        SubsuperscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], "2"], " ", 
        SubscriptBox["A", "\[Rho]"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["A", "\[Mu]"], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    SuperscriptBox["\[CapitalDelta]", "2"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Null]"]}]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Null]"]}], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Null]"]}]}], ")"}]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    SuperscriptBox["\[CapitalDelta]", "2"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[Null]"]}], " ", 
              SubscriptBox["A", "\[Rho]"]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"8", "  ", 
      RowBox[{
        RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "3"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"8", " ", 
        SubsuperscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], "3"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExplicitPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], "-", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]]}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], "-", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]]}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], "-", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "3"}], " ", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], " ", 
            SubsuperscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              RowBox[{" ", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], 
              FormBox["2",
                "TraditionalForm"]]}]}], "+", 
        RowBox[{"3", " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox[
                OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
                RowBox[{" ", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"]}], 
                FormBox["2",
                  "TraditionalForm"]], " ", 
              SubscriptBox[
                OverscriptBox["\[PartialD]", "\[RightArrow]"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]]}], ")"}]}], "-", 
        SubsuperscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
          RowBox[{" ", 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"]}], 
          FormBox["3",
            "TraditionalForm"]], "+", 
        SubsuperscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          RowBox[{" ", 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"]}], 
          FormBox["3",
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"LeviCivita", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Tau]"}], "]"}], 
      " ", 
      RowBox[{"RightPartialD", "[", 
        RowBox[{"\[Alpha]", ",", "\[Mu]", ",", "\[Beta]", ",", "\[Nu]"}], 
        "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox[
                FormBox["\[Alpha]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox[
                FormBox["\[Beta]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}], " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Tau]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExpandScalarProduct", "Section",
  CellTags->"ExpandScalarProduct"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ExpandScalarProduct[expr]  expands scalar products of sums of \
momenta in expr.  ExpandScalarProduct does not use Expand on expr.\
\>", 
  "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Calc",
    ButtonData:>"Calc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Calc"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SP", "[", 
      RowBox[{"p", ",", 
        RowBox[{"p", "-", "q"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["p",
          "TraditionalForm"], "\[CenterDot]", "(", 
        FormBox[
          RowBox[{"p", "-", "q"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandScalarProduct", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], "2"], "-", 
        RowBox[{
          FormBox["p",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FV", "[", 
      RowBox[{
        RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}], "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandScalarProduct", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], "-", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SP", "[", 
        RowBox[{
          RowBox[{"p", "-", "q"}], ",", 
          RowBox[{"q", "-", "r"}]}], "]"}], "//", "FCI"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", 
        FormBox[
          RowBox[{"p", "-", "q"}],
          "TraditionalForm"], ")", "\[CenterDot]", "(", 
        FormBox[
          RowBox[{"q", "-", "r"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "/.", 
      RowBox[{"Pair", "\[Rule]", "ExpandScalarProduct"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["p",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["q",
            "TraditionalForm"]}], "-", 
        RowBox[{
          FormBox["p",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["r",
            "TraditionalForm"]}], "-", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], "2"], "+", 
        RowBox[{
          FormBox["q",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["r",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit", "Section",
  CellTags->"Explicit"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Explicit is an option for FieldStrength, GluonVertex, SUNF, and 
Twist2GluonOperator. 
If set to True the full form of the operator is inserted. Explicit[exp] 
inserts explicit expressions of GluonVertex and Twist2GluonOperator in exp. \
SUNF's are replaced by SUNTrace objects.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["GluonVertex",
    ButtonData:>"GluonVertex",
    ButtonStyle->"Hyperlink",
    ButtonNote->"GluonVertex"],
  ", ",
  ButtonBox["Twist2GluonOperator",
    ButtonData:>"Twist2GluonOperator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Twist2GluonOperator"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GluonVertex", "[", 
      RowBox[{
      "p", ",", "\[Mu]", ",", "a", ",", " ", "q", ",", "\[Nu]", ",", "b", 
        ",", "r", ",", "\[Rho]", ",", "c"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{
          SuperscriptBox["V", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"]}]], "(", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], 
            RowBox[{",", " "}], 
            FormBox["q",
              "TraditionalForm"], 
            RowBox[{",", " "}], 
            FormBox["r",
              "TraditionalForm"]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Explicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["r",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["r",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Twist2GluonOperator", "[", 
      RowBox[{"p", ",", "\[Mu]", ",", "a", ",", "\[Nu]", ",", "b"}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "m"],
              "TraditionalForm"], "+", "1"}], ")"}], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]}]], " ", 
        RowBox[{"(", 
          RowBox[{
            SubsuperscriptBox["O", 
              RowBox[{
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], "\[VeryThinSpace]", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]}], "G2"], "(", 
            FormBox["p",
              "TraditionalForm"], ")"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Explicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], "\[CenterDot]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"]}], "-", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox[
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "+", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}]}], ")"}], " ", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "m"],
              "TraditionalForm"], "+", "1"}], ")"}], " ", 
        FormBox[
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], ")"}], 
            RowBox[{"m", "-", "2"}]],
          "TraditionalForm"], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["F", 
        RowBox[{"\[Mu]", "\[Nu]"}], "a"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Explicit", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b1",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c10",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "b1", "\[NoBreak]", "c10"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExplicitPartialD", "Section",
  CellTags->"ExplicitPartialD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
ExplicitPartialD[exp] inserts in exp the definition for \
LeftRightPartialD[z] 
(and LeftRightPartialD2[z]).\
\>", "Text"],

Cell[TextData[{
  "See also:  ",
  ButtonBox["ExpandPartialD",
    ButtonData:>"ExpandPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ExpandPartialD"],
  ", ",
  ButtonBox["LeftRightPartialD",
    ButtonData:>"LeftRightPartialD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftRightPartialD"],
  ", ",
  ButtonBox["LeftRightPartialD2",
    ButtonData:>"LeftRightPartialD2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"LeftRightPartialD2"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExplicitPartialD", "[", " ", 
      RowBox[{"LeftRightPartialD", "[", "\[Mu]", "]"}], " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], "-", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExplicitPartialD", "[", " ", 
      RowBox[{"LeftRightPartialD2", "[", "\[Mu]", "]"}], " ", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], "+", 
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExplicitPartialD", "[", " ", 
      RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], " ", "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]], "-", 
            SubscriptBox[
              OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"16", " ", 
      RowBox[{
        RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "4"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"16", " ", 
        SubsuperscriptBox[
          OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], "4"]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Factor2", "Section",
  CellTags->"Factor2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
Factor2[poly] factors a polynomial in a standard way. Factor2 works \

(sometimes) better than Factor on polynomials  involving rationals with sums \
in the denominator. Factor2 uses Factor internally and is in general slower 
than Factor. There are four possible settings of the option Method (0,1,2,3). \

In general Factor will work faster than Factor2.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "Factor2", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"FactorFull", "\[Rule]", "False"}], ",", 
          RowBox[{"Method", "\[Rule]", "3"}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Collect2",
    ButtonData:>"Collect2",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Collect2"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{"a", "-", "x"}], ")"}], 
        RowBox[{"(", 
          RowBox[{"b", "-", "x"}], ")"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"a", "-", "x"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"b", "-", "x"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Factor2", "[", "t1", "]"}], ",", " ", 
          RowBox[{"Factor", "[", "t1", "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{"a", "-", "x"}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{"b", "-", "x"}], ")"}]}], ",", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                RowBox[{"a", "-", "x"}], ")"}]}], " ", 
            RowBox[{"(", 
              RowBox[{"x", "-", "b"}], ")"}]}]}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", "=", 
      RowBox[{"Expand", "[", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"a", "-", "b"}], ")"}], 
          RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Factor", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Factor2", "[", "t3", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Factor2", "[", 
      RowBox[{"t3", ",", 
        RowBox[{"FactorFull", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t1", ",", "t2", ",", "t3"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FAD", "Section",
  CellTags->"FAD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FAD  is the FeynCalc external form of FeynAmpDenominator and \
denotes an inverse propagator.
FAD[q, q-p, ...] is 1/(q^2 (q-p)^2 ...). 
FAD[{q1,m}, {q1-p,m}, q2, ...]  is  1/( (q1^2 - m^2) ( (q1-p)^2 - m^2 ) q2^2 
... ).  
Translation into FeynCalc internal form is performed by \
FeynCalcInternal.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FAD",
    ButtonData:>"FAD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FAD"],
  ", ",
  ButtonBox["FCE",
    ButtonData:>"FCE",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCE"],
  ", ",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  ", ",
  ButtonBox["FeynAmpDenominator",
    ButtonData:>"FeynAmpDenominator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominator"],
  ", ",
  ButtonBox["FeynAmpDenominatorSimplify",
    ButtonData:>"FeynAmpDenominatorSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominatorSimplify"],
  ", ",
  ButtonBox["PropagatorDenominator",
    ButtonData:>"PropagatorDenominator",
    ButtonStyle->"Hyperlink",
    ButtonNote->"PropagatorDenominator"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FAD", "[", 
      RowBox[{"q", ",", 
        RowBox[{"p", "-", "q"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"p", "-", "q"}], ")"}], "2"], 
                "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ 
                  Plus[ p, 
                    Times[ -1, q]], 2], "]"],
              Editable->False], ")"}], " ", 
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ q, 2], "]"],
              Editable->False], ")"}]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FAD", "[", 
      RowBox[{"p", ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"p", "-", "q"}], ",", "m"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["p", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ p, 2], "]"],
              Editable->False], ")"}], " ", 
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"p", "-", "q"}], ")"}], "2"], 
                "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["m", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ 
                  Plus[ p, 
                    Times[ -1, q]], 2], "-", 
                Power[ m, 2], "]"],
              Editable->False], ")"}]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"FAD", "[", 
            RowBox[{"q", ",", 
              RowBox[{"p", "-", "q"}]}], "]"}], "//", "FCI"}], "//", "FCE"}], 
      "//", "InputForm"}]], "Input"],

Cell["FAD[q, p - q]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"FAD", "[", 
          RowBox[{"q", ",", 
            RowBox[{"p", "-", "q"}]}], "]"}], "//", "FCI"}], "//", 
      "InputForm"}]], "Input"],

Cell["\<\
FeynAmpDenominator[PropagatorDenominator[Momentum[q, D], 0], 
  PropagatorDenominator[Momentum[p, D] - Momentum[q, D], 0]]\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"FAD", "[", "p", "]"}], " ", 
          RowBox[{"FAD", "[", 
            RowBox[{"p", "-", "q"}], "]"}]}], " ", "//", " ", 
        "FeynAmpDenominatorCombine"}], "//", "InputForm"}]], "Input"],

Cell["\<\
FeynAmpDenominator[PropagatorDenominator[Momentum[p, D], 0], 
  PropagatorDenominator[Momentum[p, D] - Momentum[q, D], 0]]\
\>", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FCE", "Section",
  CellTags->"FCE"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FCE[exp] translates exp from the internal FeynCalc representation \
to a short form.\
\>", "Text"],

Cell["FCE is equivalent to FeynCalcExternal.", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynCalcExternal",
    ButtonData:>"FeynCalcExternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcExternal"],
  ", ",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  ", ",
  ButtonBox["FeynCalcInternal",
    ButtonData:>"FeynCalcInternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcInternal"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FCE", "[", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"DiracGamma", "[", "5", "]"}], ",", 
          RowBox[{"DiracGamma", "[", 
            RowBox[{"Momentum", "[", "p", "]"}], "]"}]}], "}"}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "5"], ",", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell["{GA[5], GS[p]}", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
        RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"GS", "[", "p", "]"}], ",", 
        RowBox[{"SP", "[", 
          RowBox[{"p", ",", "q"}], "]"}], ",", 
        RowBox[{"MT", "[", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
        RowBox[{"FV", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
          FormBox[
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}],
            "TraditionalForm"], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "FCI"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{DiracGamma[LorentzIndex[\[Mu]]], \n  DiracGamma[LorentzIndex[\[Rho], D], \
D], \n  DiracGamma[Momentum[p]], Pair[Momentum[p], Momentum[q]], \n  \
Pair[LorentzIndex[\[Alpha]], LorentzIndex[\[Beta]]], \n  Pair[LorentzIndex[\
\[Mu]], Momentum[p]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FCE", "[", "%", "]"}], "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FCI", "Section",
  CellTags->"FCI"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FCI[exp] translates exp into the internal FeynCalc \
(datatype-)representation. \
\>", "Text"],

Cell["FCI is equivalent to FeynCalcInternal.", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynCalcExternal",
    ButtonData:>"FeynCalcExternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcExternal"],
  ", ",
  ButtonBox["FeynCalcInternal",
    ButtonData:>"FeynCalcInternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcInternal"],
  ", ",
  ButtonBox["FCE",
    ButtonData:>"FCE",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCE"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
        RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"GS", "[", "p", "]"}], ",", 
        RowBox[{"SP", "[", 
          RowBox[{"p", ",", "q"}], "]"}], ",", 
        RowBox[{"MT", "[", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
        RowBox[{"FV", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
          FormBox[
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}],
            "TraditionalForm"], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "FCI"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{DiracGamma[LorentzIndex[\[Mu]]], \n  DiracGamma[LorentzIndex[\[Rho], D], \
D], \n  DiracGamma[Momentum[p]], Pair[Momentum[p], Momentum[q]], \n  \
Pair[LorentzIndex[\[Alpha]], LorentzIndex[\[Beta]]], \n  Pair[LorentzIndex[\
\[Mu]], Momentum[p]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FCE", "[", "%", "]"}], "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FermionSpinSum", "Section",
  CellTags->"FermionSpinSum"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FermionSpinSum[x] constructs the Traces out of squared ampliudes.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "FermionSpinSum", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"SpinPolarizationSum", "\[Rule]", "Identity"}], ",", 
          RowBox[{"SpinorCollect", "\[Rule]", "False"}], ",", 
          RowBox[{"ExtraFactor", "\[Rule]", "1"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["ComplexConjugate",
    ButtonData:>"ComplexConjugate",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ComplexConjugate"],
  ", ",
  ButtonBox["DiracTrace",
    ButtonData:>"DiracTrace",
    ButtonStyle->"Hyperlink",
    ButtonNote->"DiracTrace"],
  ", ",
  ButtonBox["Tr",
    ButtonData:>"Tr",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Tr"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{
        RowBox[{"Spinor", "[", 
          RowBox[{"k1", ",", "m"}], "]"}], ".", 
        RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
        RowBox[{"GA", "[", "5", "]"}], ".", 
        RowBox[{"Spinor", "[", 
          RowBox[{"p1", ",", "m"}], "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CurlyPhi]", "(", 
          FormBox["k1",
            "TraditionalForm"], ",", "m", ")"}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["p",
            "TraditionalForm"]}], " ", 
        SuperscriptBox["\[Gamma]", "5"], " ", 
        RowBox[{"\[CurlyPhi]", "(", 
          FormBox["p1",
            "TraditionalForm"], ",", "m", ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[
"Notice that SpinorUBar and SpinorU are only input functions. Internally they \
  are converted to Spinor objects (which display as \[CurlyPhi]\[NoBreak])."],
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ct", "=", 
      RowBox[{"ComplexConjugate", "[", "t", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"\[CurlyPhi]", "(", 
              FormBox["p1",
                "TraditionalForm"], ",", "m", ")"}], " ", 
            SuperscriptBox["\[Gamma]", "5"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], " ", 
            RowBox[{"\[CurlyPhi]", "(", 
              FormBox["k1",
                "TraditionalForm"], ",", "m", ")"}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FermionSpinSum", "[", 
      RowBox[{"t", " ", "ct"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"tr", "(", 
          FormBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{"m", "+", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["k1",
                      "TraditionalForm"]}]}], ")"}], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox["\[Gamma]", "5"], " ", 
              RowBox[{"(", 
                RowBox[{"m", "+", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["p1",
                      "TraditionalForm"]}]}], ")"}], " ", 
              SuperscriptBox["\[Gamma]", "5"], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}]}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", " ", "/.", 
      RowBox[{"DiracTrace", "->", "Tr"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"], " ", 
              SuperscriptBox["m", "2"]}], "+", 
            RowBox[{
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p1",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}], "-", 
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p1",
                  "TraditionalForm"]}]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynAmpDenominatorCombine", "Section",
  CellTags->"FeynAmpDenominatorCombine"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynAmpDenominatorCombine[expr] expands expr with respect to 
FeynAmpDenominator and combines products of FeynAmpDenominator in expr into \
one FeynAmpDenominator.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynAmpDenominatorSplit",
    ButtonData:>"FeynAmpDenominatorSplit",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominatorSplit"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", " ", "=", " ", 
      RowBox[{
        RowBox[{"FAD", "[", "q", "]"}], " ", 
        RowBox[{"FAD", "[", 
          RowBox[{"q", "-", "p"}], "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          FractionBox["1", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ q, 2], "]"],
              Editable->False]],
          "TraditionalForm"], " ", 
        FormBox[
          FractionBox["1", 
            InterpretationBox[
              RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"q", "-", "p"}], ")"}], "2"], 
                "\[InvisibleSpace]", "\<\"]\"\>"}],
              SequenceForm[ "[", 
                Power[ 
                  Plus[ 
                    Times[ -1, p], q], 2], "]"],
              Editable->False]],
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"FeynAmpDenominatorCombine", "[", "%", "]"}], "//", "FCE"}], 
      "//", "InputForm"}]], "Input"],

Cell["FAD[q, -p + q]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"FeynAmpDenominatorSplit", "[", "%", "]"}], "//", "FCE"}], 
      "//", "InputForm"}]], "Input"],

Cell["FAD[q]*FAD[-p + q]", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynAmpDenominator", "Section",
  CellTags->"FeynAmpDenominator"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynAmpDenominator[ PropagatorDenominator[ ... ], \
PropagatorDenominator[ ... ], ...] is the head of the denominators of the \
propagators, i.e., FeynAmpDenominator[x] is the representation of 1/x .\
\>", 
  "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FAD",
    ButtonData:>"FAD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FAD"],
  ", ",
  ButtonBox["FeynAmpDenominatorSimplify",
    ButtonData:>"FeynAmpDenominatorSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominatorSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmpDenominator", "[", 
      RowBox[{"PropagatorDenominator", "[", 
        RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["m", "2"]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmpDenominator", "[", 
      RowBox[{
        RowBox[{"PropagatorDenominator", "[", 
          RowBox[{"p", ",", "m"}], "]"}], ",", "\t", 
        RowBox[{"PropagatorDenominator", "[", 
          RowBox[{
            RowBox[{"p", "-", "q"}], ",", "m"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["p", "2"], "-", 
              SuperscriptBox["m", "2"]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"p", "-", "q"}], ")"}], "2"], "-", 
              SuperscriptBox["m", "2"]}], ")"}]}]], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"t", "=", 
        RowBox[{"FeynAmpDenominator", "[", 
          RowBox[{"PropagatorDenominator", "[", 
            RowBox[{"p", ",", "m"}], "]"}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"t", "//", "FCI"}], "]"}]], "Input"],

Cell["FeynAmpDenominator[PropagatorDenominator[Momentum[p, D], m]]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"t", "//", "FCE"}], "]"}]], "Input"],

Cell["FAD[{p, m}]", "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", "t", "]"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynAmpDenominatorSimplify", "Section",
  CellTags->"FeynAmpDenominatorSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynAmpDenominatorSimplify[exp]  tries to simplify each \
PropagatorDenominator in a canonical way. FeynAmpDenominatorSimplify[exp, q1] \
simplifies all FeynAmpDenominator's in exp in a canonical way,  including \
some translation of momenta. FeynAmpDenominatorSimplify[exp, q1, q2] \
additionally removes integrals with no mass scale.\
\>", "Text"],

Cell["FDS can be used as an alias.", "Text"],

Cell[CellGroupData[{

Cell[BoxData["FDS"], "Input"],

Cell[BoxData[
    FormBox["FeynAmpDenominatorSimplify", TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["OneLoopSimplify",
    ButtonData:>"OneLoopSimplify",
    ButtonStyle->"Hyperlink",
    ButtonNote->"OneLoopSimplify"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "The cornerstone of dimensional regularization is that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Integral]", 
            RowBox[{
              RowBox[{"d", "^", "n"}], "k", " ", 
              RowBox[{
                RowBox[{"f", "(", "k", ")"}], "/", 
                RowBox[{"k", "^", 
                  RowBox[{"(", 
                    RowBox[{"2", "m"}], ")"}]}]}]}]}], " ", "=", " ", 
          RowBox[{"0", " ", "."}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmpDenominatorSimplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"f", "[", "k", "]"}], " ", 
          RowBox[{"FAD", "[", 
            RowBox[{"k", ",", "k"}], "]"}]}], ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This brings ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"k", "-", 
                    SubscriptBox["p", "1"]}], ")"}], "^", "2"}], " ", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"k", "-", 
                    SubscriptBox["p", "2"]}], ")"}], "^", "2"}]}], ")"}]}], 
        TraditionalForm]]],
  " into a standard form."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmpDenominatorSimplify", "[", 
      RowBox[{
        RowBox[{"FAD", "[", 
          RowBox[{
            RowBox[{"k", "-", 
              SubscriptBox["p", "1"]}], ",", 
            RowBox[{"k", "-", 
              SubscriptBox["p", "2"]}]}], "]"}], ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          SuperscriptBox["k", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"k", "-", 
                SubscriptBox["p", "1"], "+", 
                SubscriptBox["p", "2"]}], ")"}], "2"]}]], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{"FeynAmpDenominatorSimplify", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"FAD", "[", 
              RowBox[{
                RowBox[{"k", "-", 
                  SubscriptBox["p", "1"]}], ",", 
                RowBox[{"k", "-", 
                  SubscriptBox["p", "2"]}]}], "]"}], " ", 
            RowBox[{"SPD", "[", 
              RowBox[{"k", ",", "k"}], "]"}]}], ",", "k"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          SuperscriptBox[
            FormBox["k",
              "TraditionalForm"], "2"], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", 
                  SubscriptBox["p", "1"], "+", 
                  SubscriptBox["p", "2"]}], ")"}], "2"]}]], "+", 
        FractionBox[
          RowBox[{"2", " ", 
            RowBox[{
              FormBox["k",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox[
                SubscriptBox["p", "2"],
                "TraditionalForm"]}]}], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", 
                  SubscriptBox["p", "1"], "+", 
                  SubscriptBox["p", "2"]}], ")"}], "2"]}]], "+", 
        FractionBox[
          SuperscriptBox[
            FormBox[
              SubscriptBox["p", "2"],
              "TraditionalForm"], "2"], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", 
                  SubscriptBox["p", "1"], "+", 
                  SubscriptBox["p", "2"]}], ")"}], "2"]}]]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"r", "=", 
      RowBox[{"SPC", "[", 
        RowBox[{"t", ",", "k", ",", 
          RowBox[{"FDS", "\[Rule]", "True"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          SuperscriptBox[
            FormBox[
              SubscriptBox["p", "2"],
              "TraditionalForm"], "2"], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", 
                  SubscriptBox["p", "1"], "+", 
                  SubscriptBox["p", "2"]}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"2", " ", 
            RowBox[{
              FormBox["k",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox[
                SubscriptBox["p", "2"],
                "TraditionalForm"]}]}], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "+", 
                  SubscriptBox["p", "1"], "-", 
                  SubscriptBox["p", "2"]}], ")"}], "2"]}]]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"OneLoopSimplify", "[", 
      RowBox[{"r", ",", "k"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          FormBox[
            SubscriptBox["p", "1"],
            "TraditionalForm"], "\[CenterDot]", 
          FormBox[
            SubscriptBox["p", "2"],
            "TraditionalForm"]}], 
        RowBox[{
          SuperscriptBox["k", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"k", "-", 
                SubscriptBox["p", "1"], "+", 
                SubscriptBox["p", "2"]}], ")"}], "2"]}]], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FDS", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"FAD", "[", 
            RowBox[{
              RowBox[{"k", "-", "p1"}], ",", 
              RowBox[{"k", "-", "p2"}]}], "]"}], 
          RowBox[{
            RowBox[{"SPD", "[", 
              RowBox[{"k", ",", "OPEDelta"}], "]"}], "^", "2"}]}], ",", 
        "k"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{
                  FormBox["k",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"]}],
                "TraditionalForm"], ")"}], "2"], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]], "+", 
        FractionBox[
          RowBox[{"2", " ", 
            RowBox[{
              FormBox["k",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p2",
                "TraditionalForm"]}]}], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]], "+", 
        FractionBox[
          SuperscriptBox[
            RowBox[{"(", 
              FormBox[
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["p2",
                    "TraditionalForm"]}],
                "TraditionalForm"], ")"}], "2"], 
          RowBox[{
            SuperscriptBox["k", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{"t", ",", "r"}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynAmpDenominatorSplit", "Section",
  CellTags->"FeynAmpDenominatorSplit"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynAmpDenominatorSplit[expr] splits all FeynAmpDenominator[a,b, \
...] in expr into FeynAmpDenominator[a]*FeynAmpDenominator[b] ... .
FeynAmpDenominatorSplit[expr, q1] splits all FeynAmpDenominator in expr into \
a product of two, one containing q1 and other momenta, the second without q1.\
\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynAmpDenominatorCombine",
    ButtonData:>"FeynAmpDenominatorCombine",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynAmpDenominatorCombine"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{
        RowBox[{"FAD", "[", 
          RowBox[{"q1", ",", 
            RowBox[{"q1", "-", "p"}], ",", 
            RowBox[{"q1", "-", "q2"}], ",", "q2", ",", 
            RowBox[{"q2", "-", "p"}]}], "]"}], "//", "FCI"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          SubsuperscriptBox["q", "1", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", "p"}], ")"}], "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", 
                SubscriptBox["q", "2"]}], ")"}], "2"], " ", 
          SubsuperscriptBox["q", "2", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "2"], "-", "p"}], ")"}], "2"]}]], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "//", "Head"}]], "Input"],

Cell[BoxData[
    FormBox["FeynAmpDenominator", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmpDenominatorSplit", "[", "t", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          SubsuperscriptBox["q", "1", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", "p"}], ")"}], "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", 
                SubscriptBox["q", "2"]}], ")"}], "2"], " ", 
          SubsuperscriptBox["q", "2", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "2"], "-", "p"}], ")"}], "2"]}]], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"%", "//", "FCE"}], "//", "InputForm"}]], "Input"],

Cell["FAD[q1]*FAD[-p + q1]*FAD[q1 - q2]*FAD[q2]*FAD[-p + q2]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"FeynAmpDenominatorSplit", "[", 
          RowBox[{"t", ",", "q1"}], "]"}], "//", "FCE"}], "//", 
      "InputForm"}]], "Input"],

Cell["FAD[q2, -p + q2]*FAD[q1, -p + q1, q1 - q2]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"FeynAmpDenominatorCombine", "[", "%", "]"}], "//", "FCE"}], 
      "//", "InputForm"}]], "Input"],

Cell["FAD[q1, q2, q1 - q2, -p + q1, -p + q2]", "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", "t", "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynAmp", "Section",
  CellTags->"FeynAmp"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynAmp[q, amp] is the head of a Feynman amplitude. amp denotes the \

analytical expression for the amplitude and q is the integration variable. 
FeynAmp[q1, q2, amp] denotes a two-loop amplitude.\
\>", "Text"],

Cell["\<\
FeynAmp has no functional properties and serves just as a head. \
There are 
however special typesetting rules attached.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Amplitudes",
    ButtonData:>"Amplitudes",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Amplitudes"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[RawData["\<\
Cell[\"This is a 1-loop gluon selfenergy amplitude.\", 
  \"Text\"]\
\>"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmp", "[", 
      RowBox[{"q", ",", 
        RowBox[{
          RowBox[{"GV", "[", 
            RowBox[{"p", ",", "\[Mu]", ",", "a", ",", " ", 
              RowBox[{"q", "-", "p"}], ",", "\[Alpha]", ",", "c", ",", " ", 
              RowBox[{"-", "q"}], ",", "\[Beta]", ",", "e"}], "]"}], " ", 
          RowBox[{"GP", "[", 
            RowBox[{
              RowBox[{"p", "-", "q"}], ",", " ", "\[Alpha]", ",", "c", ",", 
              " ", "\[Rho]", ",", "d"}], "]"}], 
          RowBox[{"GV", "[", 
            RowBox[{
              RowBox[{"-", "p"}], ",", "\[Nu]", ",", "b", ",", " ", 
              RowBox[{"p", "-", "q"}], ",", "\[Rho]", ",", "d", ",", " ", 
              "q", ",", "\[Sigma]", ",", "f"}], "]"}], "  ", 
          RowBox[{"GP", "[", 
            RowBox[{
            "q", ",", " ", "\[Beta]", ",", "e", ",", " ", "\[Sigma]", ",", 
              "f"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Integral]", 
        FractionBox[
          RowBox[{
            SuperscriptBox["\[DifferentialD]", "D"], "q"}], 
          SuperscriptBox[
            RowBox[{"(", "2", "\[Pi]", ")"}], "D"]], "(", 
        FormBox[
          RowBox[{"-", 
            FractionBox[
              RowBox[{
                SubsuperscriptBox["g", "s", "2"], " ", 
                RowBox[{
                  SuperscriptBox["V", 
                    RowBox[{
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Rho]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Sigma]",
                          "TraditionalForm"],
                        "TraditionalForm"]}]], "(", 
                  RowBox[{
                    FormBox[
                      RowBox[{"-", "p"}],
                      "TraditionalForm"], 
                    RowBox[{",", " "}], 
                    FormBox[
                      RowBox[{"p", "-", "q"}],
                      "TraditionalForm"], 
                    RowBox[{",", " "}], 
                    FormBox["q",
                      "TraditionalForm"]}], ")"}], " ", 
                RowBox[{
                  SuperscriptBox["V", 
                    RowBox[{
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Alpha]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Beta]",
                          "TraditionalForm"],
                        "TraditionalForm"]}]], "(", 
                  RowBox[{
                    FormBox["p",
                      "TraditionalForm"], 
                    RowBox[{",", " "}], 
                    FormBox[
                      RowBox[{"q", "-", "p"}],
                      "TraditionalForm"], 
                    RowBox[{",", " "}], 
                    FormBox[
                      RowBox[{"-", "q"}],
                      "TraditionalForm"]}], ")"}], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox["\[Alpha]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Rho]",
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{
                    FormBox[
                      FormBox["\[Beta]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Sigma]",
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["\[Delta]", 
                  RowBox[{
                    FormBox[
                      FormBox["c",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["d",
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["\[Delta]", 
                  RowBox[{
                    FormBox[
                      FormBox["e",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["f",
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox["c",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox["e",
                        "TraditionalForm"],
                      "TraditionalForm"]}]], " ", 
                SubscriptBox["f", 
                  RowBox[{
                    FormBox[
                      FormBox["b",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox["d",
                        "TraditionalForm"],
                      "TraditionalForm"], "\[NoBreak]", 
                    FormBox[
                      FormBox["f",
                        "TraditionalForm"],
                      "TraditionalForm"]}]]}], 
              RowBox[{
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"p", "-", "q"}], ")"}], "2"], " ", 
                SuperscriptBox["q", "2"]}]]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["This is a generic 2-loop amplitude.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynAmp", "[", 
      RowBox[{
        SubscriptBox["q", "1"], ",", 
        SubscriptBox["q", "2"], ",", 
        RowBox[{"anything", " ", "goes"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Integral]", 
        RowBox[{
          FractionBox[
            RowBox[{
              SuperscriptBox["\[DifferentialD]", "D"], 
              SubscriptBox["q", "1"]}], 
            SuperscriptBox[
              RowBox[{"(", "2", "\[Pi]", ")"}], "D"]], "\[Integral]", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[DifferentialD]", "D"], 
              SubscriptBox["q", "2"]}], 
            SuperscriptBox[
              RowBox[{"(", "2", "\[Pi]", ")"}], "D"]]}], "(", 
        FormBox[
          RowBox[{"anything", " ", "goes"}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynCalc2FORM", "Section",
  CellTags->"FeynCalc2FORM"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynCalc2FORM[expr] displays expr in FORM syntax. 
FeynCalc2FORM[file, x] writes x in FORM syntax to a file.
FeynCalc2FORM[file, x==y] writes x=y to a file in FORM syntax.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FORM2FeynCalc",
    ButtonData:>"FORM2FeynCalc",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FORM2FeynCalc"],
  "."
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "FeynCalc2FORM", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"EpsDiscard", "\[Rule]", "False"}], ",", 
          RowBox[{"FORMEpilog", "\[Rule]", "\<\"\"\>"}], ",", 
          RowBox[{"FORMProlog", "\[Rule]", "\<\"write statistics;\"\>"}], 
          ",", 
          RowBox[{"Replace", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"\<\"\[Alpha]\"\>", "\[Rule]", "\<\"al\"\>"}], ",", 
                RowBox[{"\<\"\[Beta]\"\>", "\[Rule]", "\<\"be\"\>"}], ",", 
                RowBox[{"\<\"\[Gamma]\"\>", "\[Rule]", "\<\"ga\"\>"}], ",", 
                RowBox[{"\<\"\[Delta]\"\>", "\[Rule]", "\<\"de\"\>"}], ",", 
                RowBox[{"\<\"\[Mu]\"\>", "\[Rule]", "\<\"mu\"\>"}], ",", 
                RowBox[{"\<\"\[Nu]\"\>", "\[Rule]", "\<\"nu\"\>"}], ",", 
                RowBox[{"\<\"\[Rho]\"\>", "\[Rule]", "\<\"ro\"\>"}], ",", 
                RowBox[{"\<\"\[Sigma]\"\>", "\[Rule]", "\<\"si\"\>"}]}], 
              "}"}]}], ",", 
          RowBox[{"TraceDimension", "\[Rule]", "4"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"MT", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], 
      RowBox[{"FV", "[", 
        RowBox[{"p", ",", "\[Rho]"}], "]"}], "  ", 
      RowBox[{
        RowBox[{"y", "^", "2"}], "/", "d"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["p", "\[Rho]"], " ", 
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]]}], "d"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input"],

Cell[BoxData[
    FormBox["\<\"(y^2*d_(mu,nu)*p(ro))/d\"\>", TraditionalForm]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{" ", 
      RowBox[{"LC", "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Delta]", ",", "\[Rho]"}], 
        "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Epsilon]", 
        RowBox[{"\[Alpha]", "\[Beta]", "\[Delta]", "\[Rho]"}]], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input"],

Cell[BoxData[
    FormBox["\<\"-i_*e_(al,be,de,ro)\"\>", TraditionalForm]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DiracTrace", "[", 
      RowBox[{"GA", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
        "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        FormBox[
          RowBox[{
            SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
            SuperscriptBox["\[Gamma]", "\[Sigma]"]}],
          "TraditionalForm"], ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input"],

Cell[BoxData[
    FormBox["\<\"g_(1,mu)*g_(1,nu)*g_(1,ro)*g_(1,si)\"\>", TraditionalForm]], 
  "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"DiracTrace", "[", 
        RowBox[{"GA", "[", 
          RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}], 
      RowBox[{"DiracTrace", "[", 
        RowBox[{"GA", "[", 
          RowBox[{"\[Mu]", ",", "\[Rho]"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"tr", "(", 
          FormBox[
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Nu]"]}],
            "TraditionalForm"], ")"}], " ", 
        RowBox[{"tr", "(", 
          FormBox[
            RowBox[{
              SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
              SuperscriptBox["\[Gamma]", "\[Rho]"]}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input"],

Cell[BoxData[
    FormBox["\<\"g_(1,mu)*g_(1,nu)*g_(2,mu)*g_(2,ro)\"\>", TraditionalForm]], 
  "Print"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", 
        RowBox[{"\"\<fc2ftest.f\>\"", ",", 
          RowBox[{
            RowBox[{"MT", "[", 
              RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], 
            RowBox[{"FV", "[", 
              RowBox[{"p", ",", "\[Mu]"}], "]"}]}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell["TableForm[ReadList[\"fc2ftest.f\",String]]", "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {"\<\"d_(mu,nu)*p(mu)\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {"d_(mu,nu)*p(mu)"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{"Tr", "[", 
        RowBox[{
          RowBox[{"GA", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
            "]"}], ".", 
          RowBox[{"GS", "[", 
            RowBox[{"p", ",", "q"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalc2FORM", "[", 
        RowBox[{"\"\<fc2ftest.f\>\"", ",", 
          RowBox[{"L", " ", "==", "t"}]}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"TableForm", "[", 
      RowBox[{"ReadList", "[", 
        RowBox[{"\"\<fc2ftest.f\>\"", ",", "String"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {"\<\"Indices mu,nu,ro,si;\"\>"},
            {"\<\"Vectors p,q;\"\>"},
            {"\<\"\"\>"},
            {"\<\"write statistics;\"\>"},
            {"\<\"\"\>"},
            {"\<\"Local L = ( \"\>"},
            {
              "\<\"4*(d_(mu,si)*d_(nu,ro)*q.p-d_(mu,ro)*d_(nu,si)*q.p+d_(mu,\
nu)*d_(ro,si)*q.p+\"\>"},
            {
              "\<\"d_(ro,si)*p(nu)*q(mu)-d_(nu,si)*p(ro)*q(mu)+d_(nu,ro)*p(si)\
*q(mu)-\"\>"},
            {
              "\<\"d_(ro,si)*p(mu)*q(nu)+d_(mu,si)*p(ro)*q(nu)-d_(mu,ro)*p(si)\
*q(nu)+\"\>"},
            {
              "\<\"d_(nu,si)*p(mu)*q(ro)-d_(mu,si)*p(nu)*q(ro)+d_(mu,nu)*p(si)\
*q(ro)-\"\>"},
            {
              "\<\"d_(nu,ro)*p(mu)*q(si)+d_(mu,ro)*p(nu)*q(si)-d_(mu,nu)*p(ro)\
*q(si)) ); \"\>"},
            {"\<\"   \"\>"},
            {"\<\"Print; \"\>"},
            {"\<\".end\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {"Indices mu,nu,ro,si;", "Vectors p,q;", "", 
          "write statistics;", "", "Local L = ( ", 
          "4*(d_(mu,si)*d_(nu,ro)*q.p-d_(mu,ro)*d_(nu,si)*q.p+d_(mu,nu)*d_(ro,\
si)*q.p+", 
          "d_(ro,si)*p(nu)*q(mu)-d_(nu,si)*p(ro)*q(mu)+d_(nu,ro)*p(si)*q(mu)-\
", "d_(ro,si)*p(mu)*q(nu)+d_(mu,si)*p(ro)*q(nu)-d_(mu,ro)*p(si)*q(nu)+", 
          "d_(nu,si)*p(mu)*q(ro)-d_(mu,si)*p(nu)*q(ro)+d_(mu,nu)*p(si)*q(ro)-\
", "d_(nu,ro)*p(mu)*q(si)+d_(mu,ro)*p(nu)*q(si)-d_(mu,nu)*p(ro)*q(si)) ); ", 
          "   ", "Print; ", ".end"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"If", "[", 
        RowBox[{
          RowBox[{"FileNames", "[", "\"\<fc2ftest.f\>\"", "]"}], ",", 
          RowBox[{"DeleteFile", "[", "\"\<fc2ftest.f\>\"", "]"}]}], "]"}], 
      ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynCalcExternal", "Section",
  CellTags->"FeynCalcExternal"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynCalcExternal[exp] translates exp from the internal FeynCalc 
representation to a shorthand form.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynCalcInternal",
    ButtonData:>"FeynCalcInternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcInternal"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynCalcExternal", "[", 
      RowBox[{"DiracGamma", "[", "5", "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["\[Gamma]", "5"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell["GA[5]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
        RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"GS", "[", "p", "]"}], ",", 
        RowBox[{"SP", "[", 
          RowBox[{"p", ",", "q"}], "]"}], ",", 
        RowBox[{"MT", "[", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
        RowBox[{"FV", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
          FormBox[
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}],
            "TraditionalForm"], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "FeynCalcInternal"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{DiracGamma[LorentzIndex[\[Mu]]], \n  DiracGamma[LorentzIndex[\[Rho], D], \
D], \n  DiracGamma[Momentum[p]], Pair[Momentum[p], Momentum[q]], \n  \
Pair[LorentzIndex[\[Alpha]], LorentzIndex[\[Beta]]], \n  Pair[LorentzIndex[\
\[Mu]], Momentum[p]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalcExternal", "[", "%", "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynCalcInternal", "Section",
  CellTags->"FeynCalcInternal"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynCalcInternal[exp] translates exp into the internal FeynCalc  \
(abstract 
data-type) representation.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynCalcExternal",
    ButtonData:>"FeynCalcExternal",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalcExternal"],
  ", ",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  ", ",
  ButtonBox["FCE",
    ButtonData:>"FCE",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCE"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
        RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
        RowBox[{"GS", "[", "p", "]"}], ",", 
        RowBox[{"SP", "[", 
          RowBox[{"p", ",", "q"}], "]"}], ",", 
        RowBox[{"MT", "[", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
        RowBox[{"FV", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
          FormBox[
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}],
            "TraditionalForm"], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "FeynCalcInternal"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
          SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["p",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}], ",", 
          SuperscriptBox["g", 
            RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{DiracGamma[LorentzIndex[\[Mu]]], \n  DiracGamma[LorentzIndex[\[Rho], D], \
D], \n  DiracGamma[Momentum[p]], Pair[Momentum[p], Momentum[q]], \n  \
Pair[LorentzIndex[\[Alpha]], LorentzIndex[\[Beta]]], \n  Pair[LorentzIndex[\
\[Mu]], Momentum[p]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FeynCalcExternal", "[", "%", "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData[
"{GA[\[Mu]], GAD[\[Rho]], GS[p], SP[p, q], \n  MT[\[Alpha], \[Beta]], FV[p, \
\[Mu]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FCI", "[", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"SD", "[", 
            RowBox[{"a", ",", "b"}], "]"}], ",", 
          RowBox[{"SUND", "[", 
            RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
          RowBox[{"SUNF", "[", 
            RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
          RowBox[{"FAD", "[", "q", "]"}], ",", 
          RowBox[{"LC", "[", 
            RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
            "]"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]}]], ",", 
          SubscriptBox["d", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]}]], ",", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]}]], ",", 
          FractionBox["1", 
            SuperscriptBox["q", "2"]], ",", 
          SuperscriptBox["\[Epsilon]", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell[TextData[
"{SUNDelta[SUNIndex[a], SUNIndex[b]], \n  SUND[SUNIndex[a], SUNIndex[b], \
SUNIndex[c]], \n  SUNF[SUNIndex[a], SUNIndex[b], SUNIndex[c]], \n  \
FeynAmpDenominator[PropagatorDenominator[Momentum[q, D], \n    0]], \
Eps[LorentzIndex[\[Mu]], LorentzIndex[\[Nu]], \n   LorentzIndex[\[Rho]], \
LorentzIndex[\[Sigma]]]}"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynRule", "Section",
  CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FeynRule[lag, {fields}] derives the Feynman rule corresponding to \
the field 
configuration fields of the lagrangian lag.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Options[FeynRule]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Anti5", "\[Rule]", 
            InterpretationBox[
              RowBox[{"-", "\[Infinity]"}],
              DirectedInfinity[ -1]]}], ",", 
          RowBox[{"Contract", "\[Rule]", "False"}], ",", 
          RowBox[{"Factor1", "\[Rule]", "False"}], ",", 
          RowBox[{"FinalSubstitutions", "\[Rule]", 
            RowBox[{"{", "}"}]}], ",", 
          RowBox[{"PartialD", "\[Rule]", "RightPartialD"}], ",", 
          RowBox[{"Schouten", "\[Rule]", "False"}], ",", 
          RowBox[{"ZeroMomentumInsertion", "\[Rule]", "True"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["FeynRule does  not calculate propagator Feynman rules.", "Text"],

Cell["\<\
The option ZeroMomentumInsertion can be used for twist-2 and higher \
twist operators.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Lagrangian",
    ButtonData:>"Lagrangian",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Lagrangian"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell["gou = Lagrangian[\"ogu\"]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ImaginaryI]", 
          RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"(", 
          RowBox[{
            SubsuperscriptBox["F", 
              RowBox[{"\[Alpha]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], "a"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                SubsuperscriptBox["D", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], 
                  RowBox[{"a", "b"}]], ")"}], 
              RowBox[{"m", "-", "2"}]], " ", 
            SubsuperscriptBox["F", 
              RowBox[{"\[Alpha]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], "b"]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gop = Lagrangian[\"ogp\"]", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Epsilon]", 
              RowBox[{
                FormBox[
                  FormBox["\[Alpha]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Beta]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Gamma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}]], " ", 
            SubsuperscriptBox["F", 
              RowBox[{"\[Beta]", "\[Gamma]"}], "a"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                SubsuperscriptBox["D", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], 
                  RowBox[{"a", "b"}]], ")"}], 
              RowBox[{"m", "-", "2"}]], " ", 
            SubsuperscriptBox["F", 
              RowBox[{"\[Alpha]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], "b"]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Explicit", "[", "gop", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["\[Epsilon]", 
              RowBox[{
                FormBox[
                  FormBox["\[Alpha]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Beta]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Gamma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}]], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Beta]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Gamma]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Gamma]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Beta]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  SubscriptBox["g", "s"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Beta]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["b2",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Gamma]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["c11",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{
                    "a", "\[NoBreak]", "b2", "\[NoBreak]", "c11"}]]}]}], 
              ")"}], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                SubsuperscriptBox["D", 
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], 
                  RowBox[{"a", "b"}]], ")"}], 
              RowBox[{"m", "-", "2"}]], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  FormBox[
                    SubscriptBox["\[PartialD]", 
                      FormBox[
                        FormBox["\[Alpha]",
                          "TraditionalForm"],
                        "TraditionalForm"]],
                    "TraditionalForm"], 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["b",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"]], 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Alpha]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["b",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  SubscriptBox["g", "s"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Alpha]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["b3",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox[
                        FormBox["A",
                          "TraditionalForm"], 
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["c12",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{
                    "b", "\[NoBreak]", "b3", "\[NoBreak]", "c12"}]]}]}], 
              ")"}]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Cases2", "[", 
        RowBox[{"%", ",", "QuantumField"}], "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData[
"{QuantumField[GaugeField, LorentzIndex[\[Alpha]], \n   SUNIndex[b3]], \
QuantumField[GaugeField, \n   LorentzIndex[\[Beta]], SUNIndex[b2]], \n  \
QuantumField[GaugeField, LorentzIndex[\[Gamma]], \n   SUNIndex[c11]], \
QuantumField[GaugeField, \n   Momentum[OPEDelta], SUNIndex[c12]], \n  \
QuantumField[PartialD[LorentzIndex[\[Alpha]]], \n   GaugeField, \
Momentum[OPEDelta], SUNIndex[b]], \n  QuantumField[PartialD[LorentzIndex[\
\[Beta]]], GaugeField, \n   LorentzIndex[\[Gamma]], SUNIndex[a]], \n  \
QuantumField[PartialD[LorentzIndex[\[Gamma]]], \n   GaugeField, LorentzIndex[\
\[Beta]], SUNIndex[a]], \n  QuantumField[PartialD[Momentum[OPEDelta]], \
GaugeField, \n   LorentzIndex[\[Alpha]], SUNIndex[b]]}"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2-gluon Feynman rules (unpolarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[TextData[
"fi = {QuantumField[GaugeField,{\[Mu]},{a}][p],\n        \
QuantumField[GaugeField,{\[Nu]},{b}][q]}"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "p", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "q", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"f2u", "=", 
      RowBox[{"FullSimplify", " ", "/@", " ", 
        RowBox[{"Factor2", "[", 
          RowBox[{"FeynRule", "[", 
            RowBox[{"gou", ",", "fi", ",", 
              RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}]}], "]"}], 
          "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", 
          RowBox[{"2", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["p",
                      "TraditionalForm"]}],
                  "TraditionalForm"], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["q",
                      "TraditionalForm"]}],
                  "TraditionalForm"], ")"}], "2"]}]], 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["p",
                          "TraditionalForm"]}], ")"}], "m"]}], "+", 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], ")"}], "m"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  RowBox[{
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["p",
                      "TraditionalForm"]}]}], "-", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
                  RowBox[{
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["q",
                      "TraditionalForm"]}], " ", 
                  RowBox[{
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["p",
                      "TraditionalForm"]}]}], "+", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["\[CapitalDelta]",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}]}], "-", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        RowBox[{
                          FormBox["p",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}]}]}], ")"}]}]}], ")"}], " ", 
            SubscriptBox["\[Delta]", 
              RowBox[{
                FormBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]}]]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2-gluon Feynman rules (polarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"fi", "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Mu]", "}"}], ",", 
                RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Nu]", "}"}], ",", 
                RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}]}], 
        "}"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "p", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "q", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"f2p", "=", 
      RowBox[{"FullSimplify", "/@", 
        RowBox[{"Factor2", "[", 
          RowBox[{"FeynRule", "[", 
            RowBox[{"gop", ",", "fi", ",", 
              RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}]}], "]"}], 
          "]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{
          FractionBox["1", 
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], "\[CenterDot]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], "\[CenterDot]", 
                      FormBox["q",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"]}]], 
          RowBox[{"(", 
            RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], ")"}], "m"], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["\[Epsilon]", 
                            RowBox[{
                              FormBox[
                                FormBox["\[Nu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox["p",
                                "TraditionalForm"], 
                              FormBox["q",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]}]], " ", 
                          SuperscriptBox[
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["\[Mu]",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], "+", 
                        RowBox[{
                          SuperscriptBox["\[Epsilon]", 
                            RowBox[{
                              FormBox[
                                FormBox["\[Mu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox[
                                FormBox["\[Nu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox["q",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]}]], " ", 
                          RowBox[{
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], "\[CenterDot]", 
                            FormBox["p",
                              "TraditionalForm"]}]}]}], ")"}], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], "\[CenterDot]", 
                            FormBox["q",
                              "TraditionalForm"]}],
                          "TraditionalForm"], ")"}], "2"]}], "-", 
                  RowBox[{
                    SuperscriptBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], "\[CenterDot]", 
                            FormBox["p",
                              "TraditionalForm"]}],
                          "TraditionalForm"], ")"}], "2"], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], ")"}], "m"], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["\[Epsilon]", 
                            RowBox[{
                              FormBox[
                                FormBox["\[Mu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox["p",
                                "TraditionalForm"], 
                              FormBox["q",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]}]], " ", 
                          SuperscriptBox[
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["\[Nu]",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], "+", 
                        RowBox[{
                          SuperscriptBox["\[Epsilon]", 
                            RowBox[{
                              FormBox[
                                FormBox["\[Mu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox[
                                FormBox["\[Nu]",
                                  "TraditionalForm"],
                                "TraditionalForm"], 
                              FormBox["p",
                                "TraditionalForm"], 
                              FormBox["\[CapitalDelta]",
                                "TraditionalForm"]}]], " ", 
                          RowBox[{
                            FormBox["\[CapitalDelta]",
                              "TraditionalForm"], "\[CenterDot]", 
                            FormBox["q",
                              "TraditionalForm"]}]}]}], ")"}]}]}], ")"}], 
              " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], ")"}]}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Factor2", "[", 
      RowBox[{"Calc", "[", 
        RowBox[{"f2p", "/.", 
          RowBox[{"p", "\[Rule]", 
            RowBox[{"-", "q"}]}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"(", 
          RowBox[{"1", "-", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "m"]}], ")"}], " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox["q",
              "TraditionalForm"], 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"]}]], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}], ")"}], 
          RowBox[{"m", "-", "1"}]], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Compare with the Feynman rule tabulated in \
Twist2GluonOperator.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Twist2GluonOperator", "[", 
      RowBox[{"q", ",", 
        RowBox[{"{", 
          RowBox[{"\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"\[Nu]", ",", "b"}], "}"}], ",", "\t", 
        RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
        RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox["q",
              "TraditionalForm"]}]], " ", 
        RowBox[{"(", 
          RowBox[{"1", "-", 
            FormBox[
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "m"],
              "TraditionalForm"]}], ")"}], " ", 
        FormBox[
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}], ")"}], 
            RowBox[{"m", "-", "1"}]],
          "TraditionalForm"], " ", 
        SubscriptBox["\[Delta]", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["quark-quark Feynman rule (unpolarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"qo", " ", "=", 
      RowBox[{"Lagrangian", "[", "\"\<oqu\>\"", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              SubscriptBox["D", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], 
              RowBox[{"m", "-", "1"}]], " ", 
            FormBox["\[Psi]",
              "TraditionalForm"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This is the list of the fermionic fields, with ",
  StyleBox["p",
    FontSlant->"Italic"],
  " and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " are flowing into the vertex."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
qf = {QuantumField[QuarkField][p],
      QuantumField[AntiQuarkField][q]}\
\>", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\[Psi]",
              "TraditionalForm"], "(", "p", ")"}], ",", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], "(", "q", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
For non-zero momentum insertion it is essential to let the partial \
derivative 
operator act on both sides. This can be achieved by setting the option 
PartialD to LeftRightPartialD. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"n2", " ", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{"qo", ",", "qf", ",", 
          RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}], ",", 
          RowBox[{"PartialD", "\[Rule]", "LeftRightPartialD"}]}], "]"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["2", 
          RowBox[{"1", "-", "m"}]], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]}], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], "-", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], ")"}], 
          RowBox[{"m", "-", "1"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"PowerSimplify", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["2", 
          RowBox[{"1", "-", "m"}]], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]}], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["p",
                  "TraditionalForm"]}], "-", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], ")"}], 
          RowBox[{"m", "-", "1"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
For q  =-p this reduces to the zero-momentum insertion Feynman \
rule.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"n2", "/.", 
        RowBox[{"q", "\[Rule]", 
          RowBox[{"-", "p"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]}], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], ")"}], 
          RowBox[{"m", "-", "1"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["This can also be derived directly.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FeynRule", "[", 
      RowBox[{"qo", ",", 
        RowBox[{"Reverse", "[", "qf", "]"}], ",", 
        RowBox[{"ZeroMomentumInsertion", "\[Rule]", "True"}]}], "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]}], " ", 
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], ")"}], 
          RowBox[{"m", "-", "1"}]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["quark-quark -gluon Feynman rule (unpolarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"qo", "=", 
      RowBox[{"Lagrangian", "[", "\"\<oqu\>\"", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              SubscriptBox["D", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], 
              RowBox[{"m", "-", "1"}]], " ", 
            FormBox["\[Psi]",
              "TraditionalForm"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"qgf = {QuantumField[QuarkField][p],\n       QuantumField[AntiQuarkField][q], \
 \n       QuantumField[GaugeField,{\[Mu]},{a}][r]}"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\[Psi]",
              "TraditionalForm"], "(", "p", ")"}], ",", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], "(", "q", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "r", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"n3", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{"qo", ",", "qgf", ",", 
          RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}], ",", 
          RowBox[{"PartialD", "\[Rule]", "LeftRightPartialD"}]}], "]"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["2", 
          RowBox[{"2", "-", "m"}]], " ", 
        SubscriptBox["g", "s"], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox["\[CapitalDelta]",
            "TraditionalForm"]}], " ", 
        RowBox[{"(", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["r",
                            "TraditionalForm"]}]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], "+", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["r",
                            "TraditionalForm"]}]}], ")"}], "i"]}]}],
              HoldForm],
            "TraditionalForm"], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["T", 
          FormBox[
            FormBox["a",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Trick", "[", 
      RowBox[{"OPESumSimplify", "[", 
        RowBox[{"Trick", "[", 
          RowBox[{"Calc", "[", 
            RowBox[{"n3", "/.", 
              RowBox[{"r", "\[Rule]", 
                RowBox[{
                  RowBox[{"-", "p"}], "-", "q"}]}]}], "]"}], "]"}], "]"}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            FormBox[
              TagBox[
                RowBox[{
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{"i", "=", "0"}], 
                    RowBox[{"m", "-", "2"}]], 
                  RowBox[{
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{"-", "1"}], ")"}], "i"], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], ")"}], 
                      RowBox[{
                        RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], ")"}], "i"]}]}],
                HoldForm],
              "TraditionalForm"]}], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["T", 
          FormBox[
            FormBox["a",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Twist2QuarkOperator", "[", 
      RowBox[{
        RowBox[{"{", "p", "}"}], ",", 
        RowBox[{"{", "q", "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"r", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"Polarization", "\[Rule]", "0"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}], " ", 
        RowBox[{"(", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"-", "1"}], ")"}], "i"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["p",
                          "TraditionalForm"]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], ")"}], "i"]}]}],
              HoldForm],
            "TraditionalForm"], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["quark-quark -gluon Feynman rule (polarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"qp", "=", 
      RowBox[{"Lagrangian", "[", "\"\<oqp\>\"", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], " ", 
            SuperscriptBox["\[Gamma]", "5"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              SubscriptBox["D", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], 
              RowBox[{"m", "-", "1"}]], " ", 
            FormBox["\[Psi]",
              "TraditionalForm"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"qgf = {QuantumField[QuarkField][p],\n       QuantumField[AntiQuarkField][q], \
 \n       QuantumField[GaugeField,{\[Mu]},{a}][r]}"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\[Psi]",
              "TraditionalForm"], "(", "p", ")"}], ",", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], "(", "q", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "r", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"n3", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{"qp", ",", "qgf", ",", 
          RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}], ",", 
          RowBox[{"PartialD", "\[Rule]", "LeftRightPartialD"}]}], "]"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["2", 
          RowBox[{"2", "-", "m"}]], " ", 
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox["T", 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox["\[Gamma]", "5"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}]}], ")"}], " ", 
        RowBox[{"(", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["r",
                            "TraditionalForm"]}]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], "-", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], "+", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["r",
                            "TraditionalForm"]}]}], ")"}], "i"]}]}],
              HoldForm],
            "TraditionalForm"], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Trick", "[", 
      RowBox[{"OPESumSimplify", "[", 
        RowBox[{"Trick", "[", 
          RowBox[{"Calc", "[", 
            RowBox[{"n3", "/.", 
              RowBox[{"r", "\[Rule]", 
                RowBox[{
                  RowBox[{"-", "p"}], "-", "q"}]}]}], "]"}], "]"}], "]"}], 
      "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          SubscriptBox["g", "s"]}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox["\[Gamma]", "5"], " ", 
            FormBox[
              TagBox[
                RowBox[{
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{"i", "=", "0"}], 
                    RowBox[{"m", "-", "2"}]], 
                  RowBox[{
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{"-", "1"}], ")"}], "i"], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], ")"}], 
                      RowBox[{
                        RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], ")"}], "i"]}]}],
                HoldForm],
              "TraditionalForm"]}], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["T", 
          FormBox[
            FormBox["a",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Twist2QuarkOperator", "[", 
      RowBox[{
        RowBox[{"{", "p", "}"}], ",", 
        RowBox[{"{", "q", "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"r", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"Polarization", "\[Rule]", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          SubscriptBox["g", "s"]}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox["\[Gamma]", "5"], " ", 
            SubscriptBox["T", 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}], " ", 
        RowBox[{"(", 
          FormBox[
            TagBox[
              RowBox[{
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{"i", "=", "0"}], 
                  RowBox[{"m", "-", "2"}]], 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"-", "1"}], ")"}], "i"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["p",
                          "TraditionalForm"]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "i"}], "+", "m", "-", "2"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], ")"}], "i"]}]}],
              HoldForm],
            "TraditionalForm"], ")"}], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["quark-quark -gluon-gluon Feynman rule (unpolarized)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"qo", "=", 
      RowBox[{"Lagrangian", "[", "\"\<oqu\>\"", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox["\[ImaginaryI]", "m"], " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], " ", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              SubscriptBox["D", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]], 
              RowBox[{"m", "-", "1"}]], " ", 
            FormBox["\[Psi]",
              "TraditionalForm"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"qggf = {QuantumField[QuarkField][p],\n        \
QuantumField[AntiQuarkField][q], \n        \
QuantumField[GaugeField,{\[Mu]},{a}][r],\n        QuantumField[GaugeField,{ \
\[Nu]},{b}][s]}"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\[Psi]",
              "TraditionalForm"], "(", "p", ")"}], ",", 
          RowBox[{
            FormBox[
              OverscriptBox["\[Psi]", "_"],
              "TraditionalForm"], "(", "q", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "r", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "s", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"n4", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{"qo", ",", "qggf", ",", 
          RowBox[{"ZeroMomentumInsertion", "\[Rule]", "True"}]}], "]"}]}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubsuperscriptBox["g", "s", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["T", 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], " ", 
              SubscriptBox["T", 
                FormBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              FormBox[
                TagBox[
                  RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                      RowBox[{"j", "=", "0"}], 
                      RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
                  HoldForm],
                "TraditionalForm"], 
              FormBox[
                RowBox[{
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{"i", "=", "0"}], "j"], "\<\"\"\>"}],
                "TraditionalForm"], 
              FormBox[
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"-", "1"}], ")"}], "j"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["p",
                          "TraditionalForm"]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "j"}], "+", "m", "-", "3"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], ")"}], "i"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}], "+", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["s",
                            "TraditionalForm"]}]}], ")"}], 
                    RowBox[{"j", "-", "i"}]]}],
                "TraditionalForm"]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "m"], " ", 
          SubsuperscriptBox["g", "s", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["T", 
                FormBox[
                  FormBox["a",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], " ", 
              SubscriptBox["T", 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              FormBox[
                TagBox[
                  RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                      RowBox[{"j", "=", "0"}], 
                      RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
                  HoldForm],
                "TraditionalForm"], 
              FormBox[
                RowBox[{
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{"i", "=", "0"}], "j"], "\<\"\"\>"}],
                "TraditionalForm"], 
              FormBox[
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"-", "1"}], ")"}], "j"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["p",
                          "TraditionalForm"]}], ")"}], "i"], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        FormBox["\[CapitalDelta]",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], ")"}], 
                    RowBox[{
                      RowBox[{"-", "j"}], "+", "m", "-", "3"}]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p",
                            "TraditionalForm"]}], "+", 
                        RowBox[{
                          FormBox["\[CapitalDelta]",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["s",
                            "TraditionalForm"]}]}], ")"}], 
                    RowBox[{"j", "-", "i"}]]}],
                "TraditionalForm"]}], ")"}], " ", 
          SuperscriptBox[
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["\[CapitalDelta]",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{"Twist2QuarkOperator", "[", 
        RowBox[{
          RowBox[{"{", "p", "}"}], ",", 
          RowBox[{"{", "q", "}"}], ",", 
          RowBox[{"{", 
            RowBox[{"r", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
          RowBox[{"{", 
            RowBox[{"s", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
          RowBox[{"Polarization", "\[Rule]", "0"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "m"]}], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["\[CapitalDelta]",
                "TraditionalForm"]}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox["T", 
                        FormBox[
                          FormBox["a",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubscriptBox["T", 
                        FormBox[
                          FormBox["b",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox[
                        TagBox[
                          RowBox[{
                            UnderoverscriptBox["\[Sum]", 
                              RowBox[{"i", "=", "0"}], 
                              RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
                          HoldForm],
                        "TraditionalForm"], 
                      FormBox[
                        RowBox[{
                          UnderoverscriptBox["\[Sum]", 
                            RowBox[{"j", "=", "0"}], "i"], "\<\"\"\>"}],
                        "TraditionalForm"], 
                      FormBox[
                        RowBox[{
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox["\[CapitalDelta]",
                                      "TraditionalForm"], "\[CenterDot]", 
                                    FormBox["p",
                                      "TraditionalForm"]}], ")"}]}], ")"}], 
                            RowBox[{
                              RowBox[{"-", "i"}], "+", "m", "-", "3"}]], 
                          " ", 
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{
                                FormBox["\[CapitalDelta]",
                                  "TraditionalForm"], "\[CenterDot]", 
                                FormBox["q",
                                  "TraditionalForm"]}], ")"}], "j"], " ", 
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"], "\[CenterDot]", 
                                  FormBox["q",
                                    "TraditionalForm"]}], "+", 
                                RowBox[{
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"], "\[CenterDot]", 
                                  FormBox["r",
                                    "TraditionalForm"]}]}], ")"}], 
                            RowBox[{"i", "-", "j"}]]}],
                        "TraditionalForm"]}], ")"}]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox["T", 
                        FormBox[
                          FormBox["b",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubscriptBox["T", 
                        FormBox[
                          FormBox["a",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox[
                        TagBox[
                          RowBox[{
                            UnderoverscriptBox["\[Sum]", 
                              RowBox[{"i", "=", "0"}], 
                              RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
                          HoldForm],
                        "TraditionalForm"], 
                      FormBox[
                        RowBox[{
                          UnderoverscriptBox["\[Sum]", 
                            RowBox[{"j", "=", "0"}], "i"], "\<\"\"\>"}],
                        "TraditionalForm"], 
                      FormBox[
                        RowBox[{
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox["\[CapitalDelta]",
                                      "TraditionalForm"], "\[CenterDot]", 
                                    FormBox["p",
                                      "TraditionalForm"]}], ")"}]}], ")"}], 
                            RowBox[{
                              RowBox[{"-", "i"}], "+", "m", "-", "3"}]], 
                          " ", 
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{
                                FormBox["\[CapitalDelta]",
                                  "TraditionalForm"], "\[CenterDot]", 
                                FormBox["q",
                                  "TraditionalForm"]}], ")"}], "j"], " ", 
                          SuperscriptBox[
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"], "\[CenterDot]", 
                                  FormBox["q",
                                    "TraditionalForm"]}], "+", 
                                RowBox[{
                                  FormBox["\[CapitalDelta]",
                                    "TraditionalForm"], "\[CenterDot]", 
                                  FormBox["s",
                                    "TraditionalForm"]}]}], ")"}], 
                            RowBox[{"i", "-", "j"}]]}],
                        "TraditionalForm"]}], ")"}]}]}], ")"}]}], ")"}], 
        " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SuperscriptBox[
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{"n4", "-", "t4"}], ")"}], "/.", 
            RowBox[{"OPEm", "\[Rule]", "5"}]}], "/.", 
          RowBox[{"s", "\[Rule]", 
            RowBox[{
              RowBox[{"-", "p"}], "-", "q", "-", "r"}]}]}], "/.", 
        RowBox[{"D", "\[Rule]", "4"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[
" In general equality can be shown by Timing[Factor2[\n \
FCE[Calc[ChangeDimension[FCE[OPESumExplicit[n4-t4]],4]/.s\[Rule]-p-q-r]]]]\n \
but it is a little bit slow ..."], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["QCD vertices", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"fii", "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Mu]", "}"}], ",", 
                RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
          "     ", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Nu]", "}"}], ",", 
                RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", 
          "     ", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Rho]", "}"}], ",", 
                RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}]}], 
        "}"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "p", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "q", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "r", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"g3", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{
          RowBox[{"Lagrangian", "[", "\"\<QCD\>\"", "]"}], ",", "fii"}], 
        "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], "-", 
                  SuperscriptBox[
                    FormBox["r",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], "-", 
                  SuperscriptBox[
                    FormBox["r",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Rho]",
                        "TraditionalForm"],
                      "TraditionalForm"]], "-", 
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Rho]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"r", ",", "\[Rho]", ",", "c"}], "}"}], ",", 
        RowBox[{"Explicit", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"q", "-", "r"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"r", "-", "p"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                SuperscriptBox[
                  RowBox[{"(", 
                    FormBox[
                      RowBox[{"p", "-", "q"}],
                      "TraditionalForm"], ")"}], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ")"}]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"g3", "-", 
        RowBox[{"ChangeDimension", "[", 
          RowBox[{"%", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"fi4", " ", "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Mu]", "}"}], ",", 
                RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
          "       ", "        ", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Nu]", "}"}], ",", 
                RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", "  ", 
          "             ", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Rho]", "}"}], ",", 
                RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}], ",", 
          "    ", "\t     ", " ", 
          RowBox[{
            RowBox[{"QuantumField", "[", 
              RowBox[{"GaugeField", ",", 
                RowBox[{"{", "\[Sigma]", "}"}], ",", 
                RowBox[{"{", "d", "}"}]}], "]"}], "[", "s", "]"}]}], 
        "}"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "p", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "q", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Rho]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "r", ")"}], ",", 
          RowBox[{
            SubsuperscriptBox[
              FormBox["A",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"]], "(", "s", ")"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"g4", " ", "=", 
      RowBox[{"FeynRule", "[", 
        RowBox[{
          RowBox[{"Lagrangian", "[", "\"\<QCD\>\"", "]"}], ",", "fi4"}], 
        "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubsuperscriptBox["g", "s", "2"]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubsuperscriptBox["g", "s", "2"]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
              RowBox[{
                SuperscriptBox["g", 
                  RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
                SuperscriptBox["g", 
                  RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["si1",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubsuperscriptBox["g", "s", "2"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"GluonVertex", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"r", ",", "\[Rho]", ",", "c"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}], ",", 
        RowBox[{"Explicit", "->", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}], "-", 
                  RowBox[{
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Sigma]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]], " ", 
                    SuperscriptBox["g", 
                      RowBox[{
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Rho]",
                            "TraditionalForm"],
                          "TraditionalForm"]}]]}]}], ")"}], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SubscriptBox["f", 
                RowBox[{
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["u8",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}]}], ")"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Calc", "[", 
      RowBox[{"g4", "-", 
        RowBox[{"ChangeDimension", "[", 
          RowBox[{"%", ",", "4"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      RowBox[{
      "f2p", ",", "f2u", ",", "f3", ",", "f32", ",", "fi", ",", "fi4", ",", 
        "fii", ",", "g3", ",", "g4", ",", "gop", ",", "gou", ",", "n3", ",", 
        "nf3", ",", "np2", ",", "npf3", ",", "p33", ",", "pf3", ",", "pn3", 
        ",", "pqo", ",", "qf", ",", "qgf", ",", "qo", ",", "t4"}], "]"}]], 
  "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FieldStrength", "Section",
  CellTags->"FieldStrength"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "FieldStrength[\[Mu], \[Nu], a] is the field strength tensor \n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[PartialD]", "\[Mu]"], 
            SubsuperscriptBox["A", "\[Nu]", "a"]}], "-", 
          RowBox[{
            SubscriptBox["\[PartialD]", "\[Nu]"], 
            SubsuperscriptBox["A", "\[Mu]", "a"]}], "+", 
          RowBox[{
            SubscriptBox["g", "s"], " ", 
            SubsuperscriptBox["A", "\[Mu]", "b1"], 
            SubsuperscriptBox["A", "\[Nu]", "c1"]}]}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", "f", "^", 
          RowBox[{"(", 
            RowBox[{"a", "b1", "c1"}], ")"}]}], TraditionalForm]]],
  ". \nFieldStrength[\[Mu], \[Nu]]   is the field strength tensor ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[PartialD]", "\[Mu]"], 
            SubsuperscriptBox["A", "\[Nu]", "\[Null]"]}], "-", 
          RowBox[{
            RowBox[{
              SubscriptBox["\[PartialD]", "\[Nu]"], 
              SubsuperscriptBox["A", "\[Mu]", "\[Null]"]}], "."}]}], 
        TraditionalForm]]],
  "\nThe name of the field (A) and the coupling constant (g)  can be set   \
through the options or by additional arguments.\nThe first two indices are   \
interpreted as type LorentzIndex, except OPEDelta, which is converted to   \
Momentum[OPEDelta]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "FieldStrength", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"CouplingConstant", "\[Rule]", 
            SubscriptBox["g", "s"]}], ",", 
          RowBox[{"Explicit", "\[Rule]", "False"}], ",", 
          RowBox[{"IndexPosition", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"Symbol", "\[Rule]", "\<\"F\"\>"}], ",", 
          RowBox[{"QuantumField", "\[Rule]", "A"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["QuantumField",
    ButtonData:>"QuantumField",
    ButtonStyle->"Hyperlink",
    ButtonNote->"QuantumField"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["F", 
        RowBox[{"\[Mu]", "\[Nu]"}], "\[Null]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["F", 
        RowBox[{"\[Mu]", "\[Nu]"}], "a"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", 
        RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[Null]"]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[Null]"]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
        RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b12",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c55",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "b12", "\[NoBreak]", "c55"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FieldStrength", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", 
          RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input"],

Cell[TextData[
"QuantumField[PartialD[LorentzIndex[\[Mu]]], GaugeField, \n   LorentzIndex[\
\[Nu]]] - \n  QuantumField[PartialD[LorentzIndex[\[Nu]]], GaugeField, \n   \
LorentzIndex[\[Mu]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FieldStrength", "[", 
        RowBox[{"\[Mu]", ",", "OPEDelta", ",", 
          RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input"],

Cell[TextData[
"QuantumField[PartialD[LorentzIndex[\[Mu]]], GaugeField, \n   \
Momentum[OPEDelta]] - \n  QuantumField[PartialD[Momentum[OPEDelta]], \
GaugeField, \n   LorentzIndex[\[Mu]]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FieldStrength", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
        RowBox[{"CouplingConstant", "\[Rule]", 
          RowBox[{"-", "Gstrong"}]}], ",", 
        RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox[
            FormBox["A",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["g", "s"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b13",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c56",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "b13", "\[NoBreak]", "c56"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FORM2FeynCalc", "Section",
  CellTags->"FORM2FeynCalc"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FORM2FeynCalc[expr] translates the FORM expr into FeynCalc \
notation. 
FORM2FeynCalc[file]  translates the FORM expresssions in file into \
FeynCalcnotation. FORM2FeynCalc[file, x1, x2, ...] reads in a file in  \
FORM-format and translates the assignments for the variables a, b, ... into \
FeynCalc syntax. If the option Set is True,  the variables x1, x2 are \
assigned to the  right hand sides defined in the FORM - file.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynCalc2FORM",
    ButtonData:>"FeynCalc2FORM",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynCalc2FORM"],
  "."
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "FORM2FeynCalc", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"Dimension", "\[Rule]", "4"}], ",", 
          RowBox[{"FinalSubstitutions", "\[Rule]", 
            RowBox[{"{", "}"}]}], ",", 
          RowBox[{"Dot", "\[Rule]", "Dot"}], ",", 
          RowBox[{"HoldForm", "\[Rule]", "True"}], ",", 
          RowBox[{"LorentzIndex", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{"mu", ",", "nu", ",", "al", ",", "be"}], "}"}]}], ",", 
          RowBox[{"Set", "\[Rule]", "False"}], ",", 
          RowBox[{"Replace", "\[Rule]", 
            RowBox[{"{", "}"}]}], ",", 
          RowBox[{"Vectors", "\[Rule]", "Automatic"}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FORM2FeynCalc", "[", "\"\<p.q + 2*x m^2\>\"", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{"(", 
            RowBox[{"x", " ", 
              SuperscriptBox["m", "2"]}], ")"}]}], "+", 
        FormBox[
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["q",
              "TraditionalForm"]}],
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell["2*x . m^2 + SP[p, q]", "Output"]
}, Open  ]],

Cell["\<\
Functions are automatically converted right, but bracketed \
expressions need to be substituted explicitly.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FORM2FeynCalc", "[", 
      RowBox[{"\"\<x +f(z)+ log(x)^2+[li2(1-x)]\>\"", ",", 
        RowBox[{"Replace", "\[Rule]", 
          RowBox[{"{", 
            RowBox[{"\"\<[li2(1-x)]\>\"", "->", "\"\<PolyLog[2,1-x]\>\""}], 
            "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["log", "2"], "(", "x", ")"}], "+", "x", "+", 
        RowBox[{"f", "(", "z", ")"}], "+", 
        RowBox[{
          SubscriptBox["Li", "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell["x + f[z] + Log[x]^2 + PolyLog[2, 1 - x]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FORM2FeynCalc", "[", "\"\<x + [(1)]*y \>\"", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"x", "+", 
        RowBox[{
          RowBox[{"Hold", "(", "1", ")"}], " ", "y"}]}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FORM2FeynCalc", "[", "\"\<p(mu)*q(nu)+d_(mu,nu)\>\"", "]"}]], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"p", " ", "mu", " ", 
          SuperscriptBox["q", "nu"]}], "+", 
        SuperscriptBox["g", 
          RowBox[{"mu", "nu"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "//", "InputForm"}]], "Input"],

Cell["p . mu . FV[q, nu] + MT[mu, nu]", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FORM2FeynCalc", "[", 
      RowBox[{"\"\<p(mu)*q(nu)+d_(mu,nu)\>\"", ",", 
        RowBox[{"Replace", "->", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"mu", "->", "\[Mu]"}], ",", 
              RowBox[{"nu", "->", "\[Nu]"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"p", " ", "\[Mu]", " ", 
          SuperscriptBox["q", "\[Nu]"]}], "+", 
        SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
    "FORM2FeynCalc", "[", 
      "\"\<i_*az*bz*aM^2*D1*[(1)]*b_G1 * ( 4*eperp(mu,nu)*avec.bvec*blam \
\\n\\n)\>\"", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "az", " ", "bz", " ", 
        SuperscriptBox["aM", "2"], " ", "D1", " ", 
        RowBox[{"Hold", "(", "1", ")"}], " ", "b$G1", " ", 
        RowBox[{"eperp", "(", 
          RowBox[{"mu", ",", "nu"}], ")"}], " ", 
        FormBox[
          RowBox[{
            FormBox["avec",
              "TraditionalForm"], "\[CenterDot]", 
            FormBox["bvec",
              "TraditionalForm"]}],
          "TraditionalForm"], " ", "blam"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FourDivergence", "Section",
  CellTags->"FourDivergence"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FourDivergence[exp, FourVector[p, mu]] calculates the partial \
derivative of exp w.r.t. p(mu). FourDivergence[exp, FourVector[p, mu], \
FourVector[p,nu],  ...]gives the multiple derivative.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["RussianTrick",
    ButtonData:>"RussianTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"RussianTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{"ScalarProduct", "[", 
        RowBox[{"p", ",", "q"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox["p",
          "TraditionalForm"], "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourDivergence", "[", 
      RowBox[{"t", ",", 
        RowBox[{"FourVector", "[", 
          RowBox[{"q", ",", "\[Mu]"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t", "=", 
      RowBox[{"ScalarProduct", "[", 
        RowBox[{
          RowBox[{"p", "-", "k"}], ",", "q"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", 
        FormBox[
          RowBox[{"p", "-", "k"}],
          "TraditionalForm"], ")", "\[CenterDot]", 
        FormBox["q",
          "TraditionalForm"]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourDivergence", "[", 
      RowBox[{"t", ",", 
        RowBox[{"FourVector", "[", 
          RowBox[{
            RowBox[{"k", "-", "p"}], ",", "\[Mu]"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"Clear", "[", "t", "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FourLaplacian", "Section",
  CellTags->"FourLaplacian"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "FourLaplacian[exp, p, q] is ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[PartialD]", 
          RowBox[{"/", 
            RowBox[{"\[PartialD]", 
              SubscriptBox["p", "\[Mu]"]}]}], " "}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[PartialD]", 
          RowBox[{"/", 
            RowBox[{"\[PartialD]", 
              SubscriptBox["q", "\[Mu]"]}]}], " "}], TraditionalForm]]],
  "exp."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Options", "[", "FourLaplacian", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{"Dimension", "\[Rule]", "D"}], "}"}], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FourDivergence",
    ButtonData:>"FourDivergence",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FourDivergence"],
  ", ",
  ButtonBox["RussianTrick",
    ButtonData:>"RussianTrick",
    ButtonStyle->"Hyperlink",
    ButtonNote->"RussianTrick"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SP", "[", 
      RowBox[{"q", ",", "q"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["q",
          "TraditionalForm"], "2"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourLaplacian", "[", 
      RowBox[{"%", ",", "q", ",", "q"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"2", " ", "D"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"SOD", "[", "q", "]"}], "^", "OPEm"}], 
        RowBox[{"FAD", "[", 
          RowBox[{"q", ",", 
            RowBox[{"q", "-", "p"}]}], "]"}]}], "//", "FCI"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}], ")"}], "m"], 
        RowBox[{
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"q", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourLaplacian", "[", 
      RowBox[{"%", ",", "q", ",", " ", "q"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"4", " ", "m", " ", 
            RowBox[{
              FormBox["\[CapitalDelta]",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["p",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], 
              RowBox[{"m", "-", "1"}]]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"2", " ", "D", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"4", " ", "m", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "+", 
        FractionBox[
          RowBox[{"12", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"2", " ", "D", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"4", " ", "m", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "+", 
        FractionBox[
          RowBox[{"12", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
        FractionBox[
          RowBox[{"4", " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  FormBox["\[CapitalDelta]",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}], ")"}], "m"], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}], 
          RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"], " ", 
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"q", "-", "p"}], ")"}], "2"]}]]}], TraditionalForm]], 
  "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FourVector", "Section",
  CellTags->"FourVector"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"FourVector[p, \[Mu]] is the four-dimensional vector p with Lorentz index  \
\[Mu]. \nA vector with space-time Dimension D is obtained by supplying the \
option Dimension \[Rule] D."], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FV",
    ButtonData:>"FV",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FV"],
  ", ",
  ButtonBox["FVD",
    ButtonData:>"FVD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FVD"],
  ", ",
  ButtonBox["Pair",
    ButtonData:>"Pair",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Pair"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourVector", "[", 
      RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        FormBox["p",
          "TraditionalForm"], 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FourVector", "[", 
      RowBox[{
        RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}], 
        FormBox[
          FormBox["\[Mu]",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}]], "Input"],

Cell[TextData["Pair[LorentzIndex[\[Mu]], Momentum[p]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FourVector", "[", 
        RowBox[{"p", ",", "\[Mu]", ",", 
          RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "]"}]], "Input"],

Cell[TextData["Pair[LorentzIndex[\[Mu], D], Momentum[p, D]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", 
      RowBox[{"FCE", "[", 
        RowBox[{"FourVector", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}], "]"}]], "Input"],

Cell[TextData["FV[p, \[Mu]]"], "Output"]
}, Open  ]],

Cell["\<\
There is no special function to expand momenta in FourVector. 
Since FourVector is turned into Pair internally ExpandScalarProduct may be \
used.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandScalarProduct", "[", 
      RowBox[{"FourVector", "[", 
        RowBox[{
          RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], "-", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FreeQ2", "Section",
  CellTags->"FreeQ2"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FreeQ2[expr, {form1, form2, ...}] yields True if expr does not \
contain any occurence of form1, form2, ... and False otherwise. 
FreeQ2[expr, form] is the same as FreeQ[expr, form].\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["SelectFree",
    ButtonData:>"SelectFree",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SelectFree"],
  ", ",
  ButtonBox["SelectNotFree",
    ButtonData:>"SelectNotFree",
    ButtonStyle->"Hyperlink",
    ButtonNote->"SelectNotFree"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FreeQ2", "[", 
      RowBox[{
        RowBox[{"x", "+", 
          RowBox[{"f", "[", "x", "]"}], "+", "y"}], ",", " ", 
        RowBox[{"{", 
          RowBox[{"a", ",", "x"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["False", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FreeQ2", "[", 
      RowBox[{
        RowBox[{"x", "+", 
          RowBox[{"f", "[", "x", "]"}], "+", "y"}], ",", 
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["True", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FreeQ2", "[", 
      RowBox[{"x", ",", " ", "y"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["True", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FreeQ2", "[", 
      RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", " ", "f"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["False", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FromTFi", "Section",
  CellTags->"FromTFi"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FromTFi[expr, q1, q2, p] translates the TFi notatation from the \
TARCER package to the usual FeynCalc notation.  See TFi for details on the \
conventions.\
\>", "Text"],

Cell[TextData[{
  "See also:  ",
  ButtonBox["TFi",
    ButtonData:>"TFi",
    ButtonStyle->"Hyperlink",
    ButtonNote->"TFi"],
  ", ",
  ButtonBox["ToTFi",
    ButtonData:>"ToTFi",
    ButtonStyle->"Hyperlink",
    ButtonNote->"ToTFi"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FAD", "[", 
        RowBox[{"q1", ",", 
          RowBox[{"q1", "-", "p"}], ",", 
          RowBox[{"{", 
            RowBox[{"q2", ",", "M"}], "}"}], ",", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"q2", "-", "p"}], ",", "m"}], "}"}], ",", 
          RowBox[{"q1", "-", "q2"}]}], "]"}], "//", "ToTFi"}]], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        SubsuperscriptBox[
          StyleBox["F",
            SingleLetterItalics->False,
            FontWeight->"Bold"], 
          RowBox[{
            FormBox[
              RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}],
              "TraditionalForm"], 
            FormBox[
              RowBox[{"{", 
                RowBox[{"1", ",", "M"}], "}"}],
              "TraditionalForm"], 
            FormBox[
              RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}],
              "TraditionalForm"], 
            FormBox[
              RowBox[{"{", 
                RowBox[{"1", ",", "m"}], "}"}],
              "TraditionalForm"], 
            FormBox[
              RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}],
              "TraditionalForm"]}], 
          RowBox[{"(", 
            FormBox["D",
              "TraditionalForm"], ")"}]],
        TFi[ D, 
          SPD[ p, p], {{1, 0}, {1, M}, {1, 0}, {1, m}, {1, 0}}],
        Editable->True], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FromTFi", "[", 
      RowBox[{
        RowBox[{"TFi", "[", 
          RowBox[{"D", ",", 
            RowBox[{"SPD", "[", 
              RowBox[{"p", ",", "p"}], "]"}], ",", 
            RowBox[{"SOD", "[", "p", "]"}], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "M"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "m"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
        "q1", ",", "q2", ",", "p"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox["1", 
        RowBox[{
          SubsuperscriptBox["q", "2", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox["q", "1"], "-", "p"}], ")"}], "2"], "-", 
              SuperscriptBox["M", "2"]}], ")"}], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "2"], "-", "p"}], ")"}], "2"], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", 
                SubscriptBox["q", "2"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["q", "1", "2"], "-", 
              SuperscriptBox["m", "2"]}], ")"}]}]], TraditionalForm]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FromTFi", "[", 
      RowBox[{
        RowBox[{"TFi", "[", 
          RowBox[{"D", ",", 
            RowBox[{"SPD", "[", 
              RowBox[{"p", ",", "p"}], "]"}], ",", 
            RowBox[{"SOD", "[", "p", "]"}], ",", 
            RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "m"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "M"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "m"}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
        "q1", ",", "q2", ",", "p"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          FormBox["\[CapitalDelta]",
            "TraditionalForm"], "\[CenterDot]", 
          FormBox[
            SubscriptBox["q", "2"],
            "TraditionalForm"]}], 
        RowBox[{
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", 
                SubscriptBox["q", "2"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["q", "2", "2"], "-", 
              SuperscriptBox["M", "2"]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox["q", "2"], "-", "p"}], ")"}], "2"], "-", 
              SuperscriptBox["m", "2"]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["q", "1", "2"], "-", 
              SuperscriptBox["m", "2"]}], ")"}], " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["q", "1"], "-", "p"}], ")"}], "2"]}]], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FRH", "Section",
  CellTags->"FRH"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
FRH[exp_] := FixedPoint[ReleaseHold, exp], i.e., FRH removes all \
HoldForm and Hold in exp.\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["Isolate",
    ButtonData:>"Isolate",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Isolate"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Hold", "[", 
      RowBox[{"1", "-", "1", " ", "-", " ", 
        RowBox[{"Hold", "[", 
          RowBox[{"2", "-", "2"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"Hold", "(", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{"Hold", "(", 
              RowBox[{"2", "-", "2"}], ")"}]}], "+", "1", "-", "1"}], ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FRH", "[", "%", "]"}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Isolate", "[", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"x", "^", "3"}], "-", "x", "-", "1"}], "==", "0"}], 
          "]"}], ",", "x", ",", 
        RowBox[{"IsolateNames", "->", "H"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{"x", "\[Rule]", 
              TagBox[
                RowBox[{"H", "(", "3", ")"}],
                HoldForm]}], "}"}], ",", 
          RowBox[{"{", 
            RowBox[{"x", "\[Rule]", 
              TagBox[
                RowBox[{"H", "(", "6", ")"}],
                HoldForm]}], "}"}], ",", 
          RowBox[{"{", 
            RowBox[{"x", "\[Rule]", 
              TagBox[
                RowBox[{"H", "(", "7", ")"}],
                HoldForm]}], "}"}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FRH", "[", 
      RowBox[{"H", "[", "3", "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "3"], " ", 
          RadicalBox[
            RowBox[{
              FractionBox["27", "2"], "-", 
              FractionBox[
                RowBox[{"3", " ", 
                  SqrtBox["69"]}], "2"]}], "3"]}], "+", 
        FractionBox[
          RadicalBox[
            RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
                RowBox[{"9", "+", 
                  SqrtBox["69"]}], ")"}]}], "3"], 
          SuperscriptBox["3", 
            RowBox[{"2", "/", "3"}]]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FunctionalD", "Section",
  CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"FunctionalD[expr, {QuantumField[name, {\[Mu]}, {a}][p], ...}] calculates the \
functional derivative of expr with respect to the field list (with  incoming \
momenta p, etc.) and does the fourier transform.\nFunctionalD[expr, \
{QuantumField[name, {\[Mu]},{a}], ...}] calculates the  functional derivate \
and does partial integration but omits the x-space delta  functions."], "Text"],

Cell["FunctionalD is a low level function used in FeynRule.", "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FeynRule",
    ButtonData:>"FeynRule",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FeynRule"],
  ", ",
  ButtonBox["QuantumField",
    ButtonData:>"QuantumField",
    ButtonStyle->"Hyperlink",
    ButtonNote->"QuantumField"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "Instead of the usual ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"\[Delta]\[Phi]", "(", "x", ")"}], "/", 
            RowBox[{"\[Delta]\[Phi]", "(", "y", ")"}]}], "=", 
          RowBox[{
            RowBox[{"\[Delta]", "^", 
              RowBox[{"(", "D", ")"}]}], 
            RowBox[{"(", 
              RowBox[{"x", "-", "y"}], ")"}]}]}], TraditionalForm]]],
  " the arguments and the \[Delta] function are omitted, i.e., for the  \
program for simplicity: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Delta]\[Phi]", "/", "\[Delta]\[Phi]"}], "=", "1"}], 
        TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FunctionalD", "[", 
      RowBox[{
        RowBox[{"QuantumField", "[", "\[Phi]", "]"}], ",", 
        RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox["1", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FunctionalD", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"QuantumField", "[", "\[Phi]", "]"}], "^", "2"}], ",", 
        RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"2", " ", "\[Phi]"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Instead of the usual ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{"\[Delta]", " ", 
                RowBox[{
                  SubscriptBox["\[PartialD]", "\[Mu]"], 
                  RowBox[{"\[Phi]", "(", "x", ")"}]}]}], ")"}], "/", 
            RowBox[{"\[Delta]\[Phi]", "(", "y", ")"}]}], "=", 
          RowBox[{
            SubscriptBox["\[PartialD]", "\[Mu]"], 
            RowBox[{
              RowBox[{"\[Delta]", "^", 
                RowBox[{"(", "D", ")"}]}], 
              RowBox[{"(", 
                RowBox[{"x", "-", "y"}], ")"}]}]}]}], TraditionalForm]]],
  " the arguments are omitted, and the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[PartialD]", "\[Mu]"], TraditionalForm]]],
  "operator is specified by default to be an integration by parts operator,  \
i.e., the right hand side will be just ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"-", 
            FormBox[
              SubscriptBox["\[PartialD]", "\[Mu]"],
              "TraditionalForm"]}], ","}], TraditionalForm]]],
  " or, more precisely (by default) ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], TraditionalForm]]],
  "."
}], "Text",
  ZeroWidthTimes->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FunctionalD", "[", 
      RowBox[{
        RowBox[{"QuantumField", "[", 
          RowBox[{
            RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], "]"}], 
        ",", 
        RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        SubscriptBox[
          OverscriptBox["\[PartialD]", "\[RightArrow]"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"S", "[", "\[Phi]", "]"}], " ", "=", 
        RowBox[{
          RowBox[{"1", "/", "2"}], 
          RowBox[{"\[Integral]", " ", 
            RowBox[{
              RowBox[{"d", "^", "D"}], 
              RowBox[{"x", " ", "[", " ", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SubscriptBox["\[PartialD]", "\[Mu]"], 
                      RowBox[{"\[Phi]", "(", "x", ")"}]}], "  ", 
                    RowBox[{
                      RowBox[{"\[PartialD]", 
                        RowBox[{"^", "\[Mu]"}]}], 
                      RowBox[{"\[Phi]", "(", "x", ")"}]}]}], "-", 
                  RowBox[{
                    RowBox[{"m", "^", "2"}], 
                    RowBox[{"\[Phi]", "(", "x", ")"}], "  ", 
                    RowBox[{"\[Phi]", "(", "y", ")"}]}]}], "]"}]}]}]}]}], 
      TraditionalForm]]]], "Subsubsection",
  ZeroWidthTimes->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"s", "[", "\[Phi]", "]"}], "=", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{
                  RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], 
                "]"}], ".", 
              RowBox[{"QuantumField", "[", 
                RowBox[{
                  RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], 
                "]"}]}], "-", 
            RowBox[{
              RowBox[{"m", "^", "2"}], " ", 
              RowBox[{
                RowBox[{"QuantumField", "[", "\[Phi]", "]"}], ".", 
                RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}]}]}], ")"}], 
        "/", "2"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}]}], "-", 
            RowBox[{
              SuperscriptBox["m", "2"], " ", 
              RowBox[{"(", 
                RowBox[{"\[Phi]", " ", "\[Phi]"}], ")"}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FunctionalD", "[", 
      RowBox[{
        RowBox[{"s", "[", "\[Phi]", "]"}], ",", 
        RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", "\[Phi]"}], " ", 
          SuperscriptBox["m", "2"]}], "-", 
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"S", "[", "A", "]"}], " ", "=", " ", 
        RowBox[{"-", 
          RowBox[{"\[Integral]", " ", 
            RowBox[{
              RowBox[{"d", "^", "D"}], "x", "  ", 
              RowBox[{"1", "/", "4"}], "  ", 
              RowBox[{
                SubsuperscriptBox["F", "a", "\[Mu]\[Nu]"], "(", "x", ")"}], 
              "  ", 
              RowBox[{
                SubscriptBox["F", "\[Mu]\[Nu]a"], "(", "x", ")"}]}]}]}]}], 
      TraditionalForm]]]], "Subsubsection",
  ZeroWidthTimes->True],

Cell[TextData[StyleBox["First approach",
  FontWeight->"Bold"]], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"F1", "=", 
      RowBox[{"FieldStrength", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
          RowBox[{"{", 
            RowBox[{"A", ",", "b", ",", "c"}], "}"}], ",", "1", ",", 
          RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "b", "\[NoBreak]", "c"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"F2", "=", 
      RowBox[{"FieldStrength", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
          RowBox[{"{", 
            RowBox[{"A", ",", "d", ",", "e"}], "}"}], ",", "1", ",", 
          RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"a", "\[NoBreak]", "d", "\[NoBreak]", "e"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"S", "[", "A", "]"}], "=", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"1", "/", "4"}]}], 
        RowBox[{"F1", ".", "F2"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["b",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["c",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{"a", "\[NoBreak]", "b", "\[NoBreak]", "c"}]]}]}], 
              ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["d",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["e",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{"a", "\[NoBreak]", "d", "\[NoBreak]", "e"}]]}]}], 
              ")"}]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In order to derive the equation of motion the functional derivative of ",
  Cell[BoxData[
      FormBox["S", TraditionalForm]]],
  " with respect to ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["A", "\[Sigma]", "g"], TraditionalForm]]],
  "has to be set to zero. Bearing in mind that for FeynCalc we have to be  \
precise as to where which operators (coming from the substitution of the  \
derivative of the \[Delta] function) act:,  act with the functional  \
derivative operator on the first field strength:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[
                  RowBox[{
                    FormBox[
                      RowBox[{"0", " ", "=", " ", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{"\[Delta]", "S"}], ")"}], "/", 
                              RowBox[{"(", 
                                RowBox[{"\[Delta]", 
                                  RowBox[{
                                    SubsuperscriptBox["A", "\[Sigma]", "g"], 
                                    "(", "y", ")"}]}], ")"}]}],
                            "TraditionalForm"], "=", 
                          RowBox[{"-", 
                            RowBox[{"2", "/", "4"}]}]}]}],
                      "TraditionalForm"], 
                    RowBox[{"\[Integral]", 
                      RowBox[{
                        RowBox[{"d", "^", "D"}], "x"}]}]}],
                  "TraditionalForm"], "  ", 
                RowBox[{"(", 
                  RowBox[{"\[Delta]", "/", 
                    RowBox[{"(", 
                      RowBox[{"\[Delta]", 
                        RowBox[{
                          SubsuperscriptBox["A", "\[Sigma]", "g"], "(", "y", 
                          ")"}]}], ")"}]}]}]}],
              "TraditionalForm"], " ", 
            RowBox[{
              SubscriptBox["F", "\[Mu]\[Nu]a"], "(", "x", ")"}]}], ")"}], 
        TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{" ", 
              SubsuperscriptBox["F", "a", 
                RowBox[{",", "\[Mu]\[Nu]"}]]}],
            "TraditionalForm"], "(", "x", ")"}], TraditionalForm]]]
}], "Text",
  ZeroWidthTimes->True],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{"See", " ", "what", " ", "happens", " ", "with", " ", "just", 
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{"\[Delta]", 
                  RowBox[{"S", "[", "A", "]"}]}], ")"}], "/", 
              RowBox[{"(", 
                RowBox[{"\[Delta]", 
                  SubsuperscriptBox["A", "\[Sigma]", "g"]}], ")"}]}],
            "TraditionalForm"], "."}]}], TraditionalForm]]]], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Ag", "=", 
      RowBox[{"QuantumField", "[", 
        RowBox[{"A", ",", 
          RowBox[{"{", "\[Sigma]", "}"}], ",", 
          RowBox[{"{", "g", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["A", 
        FormBox[
          FormBox["\[Sigma]",
            "TraditionalForm"],
          "TraditionalForm"], 
        FormBox[
          FormBox["g",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", "=", 
      RowBox[{"FunctionalD", "[", 
        RowBox[{"F1", ",", "Ag"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            SuperscriptBox["g", 
              RowBox[{"\[Nu]", "\[Sigma]"}]]}], " ", 
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[
"In order to minimize the number of dummy indices, replace b \[Rule] c."], 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t1", " ", "=", " ", 
      RowBox[{"t1", " ", "/.", " ", 
        RowBox[{"b", "\[Rule]", "c"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            SuperscriptBox["g", 
              RowBox[{"\[Nu]", "\[Sigma]"}]]}], " ", 
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["\[Delta]", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Instead of inserting the definition for the second ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["F", "a", "\[Mu]\[Nu]"], TraditionalForm]]],
  ", introduce a QuantumField object with antisymmetry built into the Lorentz \
 indices:"
}], "Text"],

Cell[BoxData[
    RowBox[{"F", "/:", " ", 
      RowBox[{"QuantumField", "[", 
        RowBox[{
        "pard___", ",", "F", ",", "\[Beta]_", ",", "\[Alpha]_", ",", "s_"}], 
        "]"}], ":=", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"QuantumField", "[", 
            RowBox[{
            "pard", ",", "F", ",", "\[Alpha]", ",", "\[Beta]", ",", "s"}], 
            "]"}]}], "/;", 
        RowBox[{"!", 
          RowBox[{"OrderedQ", "[", 
            RowBox[{"{", 
              RowBox[{"\[Beta]", ",", "\[Alpha]"}], "}"}], "]"}]}]}]}]], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"QuantumField", "[", 
      RowBox[{"F", ",", 
        RowBox[{"{", 
          RowBox[{"\[Mu]", ",", "\[Nu]"}], "}"}], ",", 
        RowBox[{"{", "a", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SubsuperscriptBox["F", 
        RowBox[{
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Nu]",
              "TraditionalForm"],
            "TraditionalForm"]}], 
        FormBox[
          FormBox["a",
            "TraditionalForm"],
          "TraditionalForm"]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "/.", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"\[Mu]", "\[RuleDelayed]", "\[Nu]"}], ",", 
          RowBox[{"\[Nu]", "\[RuleDelayed]", "\[Mu]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        SubsuperscriptBox["F", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]}], 
          FormBox[
            FormBox["a",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t2", "=", 
      RowBox[{
        RowBox[{"Contract", "[", 
          RowBox[{"ExpandPartialD", "[", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{"1", "/", "2"}]}], " ", 
              RowBox[{"t1", ".", 
                RowBox[{"QuantumField", "[", 
                  RowBox[{"F", ",", 
                    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
                    RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
                    RowBox[{"SUNIndex", "[", "a", "]"}]}], "]"}]}]}], "]"}], 
          "]"}], "/.", 
        RowBox[{"Dot", "\[Rule]", "Times"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["F", 
              RowBox[{
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]}], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]]}]}], "+", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["F", 
              RowBox[{
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]}], 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]]}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t3", " ", "=", " ", 
      RowBox[{"t2", " ", "/.", " ", 
        RowBox[{"\[Nu]", "\[Rule]", "\[Mu]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"t4", "=", 
      RowBox[{
        RowBox[{"FCE", "[", "t3", "]"}], "/.", " ", 
        RowBox[{
          RowBox[{"SUNF", "[", 
            RowBox[{"a", ",", "c", ",", "g"}], "]"}], "\[Rule]", 
          RowBox[{"-", 
            RowBox[{"SUNF", "[", 
              RowBox[{"g", ",", "c", ",", "a"}], "]"}]}]}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{"g", "\[NoBreak]", "c", "\[NoBreak]", "a"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Since the variational derivative vanishes t4 implies that  0 =  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["D", "\[Mu]"], 
          SubsuperscriptBox["F", "g", "\[Mu]\[Sigma]"]}], TraditionalForm]]],
  " ."
}], "Text"],

Cell[TextData[StyleBox["Second approach",
  FontWeight->"Bold"]], "Text"],

Cell["\<\
It is of course also possible to do the functional deriviate on the \
S[A] with both field strength tensors inserted.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"S", "[", "A", "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["b",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["c",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{"a", "\[NoBreak]", "b", "\[NoBreak]", "c"}]]}]}], 
              ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox["A", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["a",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["d",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SubsuperscriptBox["A", 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["e",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], ")"}], " ", 
                  SubscriptBox["f", 
                    RowBox[{"a", "\[NoBreak]", "d", "\[NoBreak]", "e"}]]}]}], 
              ")"}]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"r1", "=", 
      RowBox[{
        RowBox[{"\[IndentingNewLine]", "FunctionalD"}], "[", 
        RowBox[{
          RowBox[{"S", "[", "A", "]"}], ",", "Ag"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Sigma]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "+", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Sigma]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["b",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["c",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["b",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["c",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["e",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["e",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], " ", 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["e",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
This is just funcional derivatves and partial integration and \
simple contraction of indices. No attempt is made to rename dummy indices \
(since this is difficult in general ...).\
\>", "Text"],

Cell["\<\
With a general replacement rule only valid for commuting fields the \
color indices can be canonicalized a bit more. The idea is to use the \
commutative properties of the vector fields, and canonicalize the color \
indices by a trick. This function will work on any commuting product of \
fields.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", "symfun", "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"symfun", "[", 
        RowBox[{"z_", ",", "fieldname_Symbol"}], "]"}], ":=", 
      RowBox[{"Expand", "[", 
        RowBox[{"SUNSimplify", "[", 
          RowBox[{"FixedPoint", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"Collect2", "[", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{"DotSimplify", "[", 
                          RowBox[{"#1", "/.", 
                            RowBox[{"Times", "\[Rule]", "Dot"}]}], "]"}], 
                        "/.", 
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{
                                  RowBox[{"(", "qi___", ")"}], ".", 
                                  RowBox[{"QuantumField", "[", 
                                    RowBox[{
                                    "par1___", ",", "fieldname", ",", "li1_", 
                                      ",", "sui1_"}], "]"}], ".", 
                                  RowBox[{"QuantumField", "[", 
                                    RowBox[{
                                    "par2___", ",", "fieldname", ",", "li2_", 
                                      ",", "sui2_"}], "]"}], ".", "qf___"}], 
                                " ", ")"}], "any_"}], ")"}], 
                          "\[RuleDelayed]", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{"(", 
                                  RowBox[{"qi", ".", 
                                    RowBox[{"QuantumField", "[", 
                                      RowBox[{
                                      "par1", ",", "A", ",", "li1", ",", 
                                        "sui2"}], "]"}], ".", 
                                    RowBox[{"QuantumField", "[", 
                                      RowBox[{
                                      "par2", ",", "fieldname", ",", "li2", 
                                        ",", "sui1"}], "]"}], ".", "qf"}], 
                                  " ", ")"}], 
                                RowBox[{"(", 
                                  RowBox[{"any", "/.", 
                                    RowBox[{"{", 
                                      RowBox[{
                                        RowBox[{
                                        "sui1", "\[RuleDelayed]", "sui2"}], 
                                        ",", 
                                        RowBox[{
                                        "sui2", "\[RuleDelayed]", "sui1"}]}], 
                                      "}"}]}], ")"}]}], ")"}], "/;", 
                            RowBox[{
                              RowBox[{"(", "\[InvisibleSpace]", 
                                RowBox[{"!", 
                                  RowBox[{"(", 
                                    RowBox[{"FreeQ2", "[", 
                                      RowBox[{"any", ",", 
                                        RowBox[{"{", 
                                        RowBox[{"sui1", ",", "su2"}], 
                                        "}"}]}], "]"}], ")"}]}], ")"}], "&&", 
                              "\[InvisibleSpace]", 
                              RowBox[{"!", 
                                RowBox[{"(", 
                                  RowBox[{"OrderedQ", "[", 
                                    RowBox[{"{", 
                                      RowBox[{"sui1", ",", "sui2"}], "}"}], 
                                    "]"}], ")"}]}]}]}]}]}], "/.", 
                      RowBox[{"Dot", "\[Rule]", "Times"}]}], ",", 
                    "QuantumField"}], "]"}], "&"}], ",", "z", ",", "42"}], 
            "]"}], "]"}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"r2", " ", "=", " ", 
      RowBox[{"symfun", "[", 
        RowBox[{"r1", ",", "A"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Sigma]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "+", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["\[Sigma]",
                        "TraditionalForm"],
                      "TraditionalForm"]],
                  "TraditionalForm"]}], 
              SubsuperscriptBox["A", 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], ")"}]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "2"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"r3", "=", 
      RowBox[{"r2", "/.", 
        RowBox[{"\[Nu]", "\[Rule]", "\[Mu]"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"2", " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["3", "4"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inspection reveals that still terms are the same. Gather the terms with  \
two ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", " "}], TraditionalForm]]],
  "'s:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"twof", "=", 
      RowBox[{"Select", "[", 
        RowBox[{"r3", ",", 
          RowBox[{
            RowBox[{
              RowBox[{"Count", "[", 
                RowBox[{"#", ",", 
                  RowBox[{"SUNF", "[", "__", "]"}]}], "]"}], "===", "2"}], 
            "&"}]}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            FractionBox["3", "4"]}], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          FractionBox["1", "4"], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"twofnew", "=", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
            "twof", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "+", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"twof", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/.", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"b", "\[RuleDelayed]", "c"}], ",", 
                    RowBox[{"c", "\[RuleDelayed]", "b"}]}], "}"}]}], ")"}]}], 
          ")"}], "/.", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"a", "\[RuleDelayed]", "c"}], ",", 
            RowBox[{"c", "\[RuleDelayed]", "a"}]}], "}"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]]}], " ", 
        SubsuperscriptBox["A", 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["b",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubsuperscriptBox["A", 
          FormBox[
            FormBox["\[Sigma]",
              "TraditionalForm"],
            "TraditionalForm"], 
          FormBox[
            FormBox["e",
              "TraditionalForm"],
            "TraditionalForm"]], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]}]], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"r4", " ", "=", " ", 
      RowBox[{"r3", "-", "twof", "+", "twofnew"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{"2", " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\

Check that this is now indeed the same as the t4 result from the first \
attempt.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData["t4"], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[PartialD]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]}], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{"g", "\[NoBreak]", "c", "\[NoBreak]", "a"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"w0", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"RightPartialD", "[", "\[Mu]", "]"}], ".", 
          RowBox[{"FieldStrength", "[", 
            RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "g", ",", 
              RowBox[{"{", 
                RowBox[{"A", ",", "a", ",", "b"}], "}"}], ",", "1"}], 
            "]"}]}], "+", 
        RowBox[{
          RowBox[{"QuantumField", "[", 
            RowBox[{"A", ",", 
              RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
              RowBox[{"SUNIndex", "[", "c", "]"}]}], "]"}], 
          RowBox[{"FieldStrength", "[", 
            RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "a", ",", 
              RowBox[{"{", 
                RowBox[{"A", ",", "b", ",", "d"}], "}"}], ",", "1"}], "]"}], 
          RowBox[{"SUNF", "[", 
            RowBox[{"g", ",", "c", ",", "a"}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["F", 
            RowBox[{"\[Mu]", "\[Sigma]"}], 
            RowBox[{"g", 
              FormBox[
                RowBox[{"{", 
                  RowBox[{"A", ",", "a", ",", "b"}], "}"}],
                "TraditionalForm"], 
              FormBox["1",
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["F", 
            RowBox[{"\[Mu]", "\[Sigma]"}], 
            RowBox[{"a", 
              FormBox[
                RowBox[{"{", 
                  RowBox[{"A", ",", "b", ",", "d"}], "}"}],
                "TraditionalForm"], 
              FormBox["1",
                "TraditionalForm"]}]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{"g", "\[NoBreak]", "c", "\[NoBreak]", "a"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"w1", "=", 
      RowBox[{"Explicit", "[", "w0", "]"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["g",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "-", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["g",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubsuperscriptBox["A", 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SubsuperscriptBox["A", 
                      FormBox[
                        FormBox["\[Sigma]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], ")"}], " ", 
                SubscriptBox["f", 
                  RowBox[{"g", "\[NoBreak]", "a", "\[NoBreak]", "b"}]]}]}], 
            ")"}]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "-", 
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  FormBox[
                    FormBox["\[Sigma]",
                      "TraditionalForm"],
                    "TraditionalForm"]], 
                SubsuperscriptBox["A", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["a",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "+", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubsuperscriptBox["A", 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SubsuperscriptBox["A", 
                      FormBox[
                        FormBox["\[Sigma]",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["d",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], ")"}], " ", 
                SubscriptBox["f", 
                  RowBox[{"a", "\[NoBreak]", "b", "\[NoBreak]", "d"}]]}]}], 
            ")"}], " ", 
          SubscriptBox["f", 
            RowBox[{"g", "\[NoBreak]", "c", "\[NoBreak]", "a"}]]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"w2", "=", 
      RowBox[{
        RowBox[{"ExpandPartialD", "[", "w1", "]"}], "/.", 
        RowBox[{"Dot", "\[Rule]", "Times"}]}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "-", 
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"], 
            FormBox[
              SubscriptBox["\[PartialD]", 
                FormBox[
                  FormBox["\[Sigma]",
                    "TraditionalForm"],
                  "TraditionalForm"]],
              "TraditionalForm"]}], 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["g",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["d",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"dif1", " ", "=", " ", 
      RowBox[{"w2", "-", "r4"}]}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          RowBox[{
            SubscriptBox["\[PartialD]", 
              FormBox[
                FormBox["\[Sigma]",
                  "TraditionalForm"],
                "TraditionalForm"]], 
            SubsuperscriptBox["A", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"], 
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"]]}], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "-", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["d",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["d",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}], "+", 
        RowBox[{
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubsuperscriptBox["A", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"], 
            FormBox[
              FormBox["e",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["a",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["e",
                  "TraditionalForm"],
                "TraditionalForm"]}]], " ", 
          SubscriptBox["f", 
            RowBox[{
              FormBox[
                FormBox["b",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["c",
                  "TraditionalForm"],
                "TraditionalForm"], "\[NoBreak]", 
              FormBox[
                FormBox["g",
                  "TraditionalForm"],
                "TraditionalForm"]}]]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"dif2", "=", 
      RowBox[{"symfun", "[", 
        RowBox[{"dif1", ",", "A"}], "]"}]}]], "Input"],

Cell[BoxData[
    FormBox["0", TraditionalForm]], "Output"]
}, Open  ]],

Cell["quod erat demonstrandum", "Text"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"Unset", "[", 
        RowBox[{"s", "[", "\[Phi]", "]"}], "]"}], ";", 
      RowBox[{
        RowBox[{
          RowBox[{"Unset", "[", 
            RowBox[{"S", "[", "A", "]"}], "]"}], ";"}], 
        "\[IndentingNewLine]"}]}], 
    RowBox[{"Clear", "[", 
      RowBox[{
      "Ag", ",", "F1", ",", "F2", ",", "t1", ",", "t2", ",", "t3", ",", "t4", 
        ",", "F", ",", "r1", ",", "r2", ",", "r3", ",", "symfun", ",", 
        "twof", ",", "twofnew", ",", "w0", ",", "w1", ",", "w2", ",", "dif1", 
        ",", "dif2", ",", "dif3"}], "]"}]}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples of funcional differentiation as used in FeynRule", "Subsection"],

Cell["This is a part of the QCD Lagrangian.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"(", 
        RowBox[{"Gstrong", "*", 
          RowBox[{
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{"GaugeField", ",", " ", 
                  RowBox[{"LorentzIndex", "[", "li1", "]"}], ",", " ", 
                  "        ", 
                  RowBox[{"SUNIndex", "[", "si2", "]"}]}], "]"}], "[", "]"}], 
            " ", ".", " ", "      ", 
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{"GaugeField", ",", " ", 
                  RowBox[{"LorentzIndex", "[", "li2", "]"}], ",", " ", 
                  "       ", " ", 
                  RowBox[{"SUNIndex", "[", "si4", "]"}]}], "]"}], "[", "]"}], 
            " ", ".", " ", "      ", 
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{
                  RowBox[{"PartialD", "[", 
                    RowBox[{"LorentzIndex", "[", "li1", "]"}], "]"}], ",", 
                  " ", "GaugeField", ",", " ", "  ", "      ", 
                  RowBox[{"LorentzIndex", "[", "li2", "]"}], ",", " ", 
                  RowBox[{"SUNIndex", "[", "si1", "]"}]}], "]"}], "[", 
              "]"}]}], "*", "    ", " ", 
          RowBox[{"SUNF", "[", 
            RowBox[{
              RowBox[{"SUNIndex", "[", "si1", "]"}], ",", " ", 
              RowBox[{"SUNIndex", "[", "si2", "]"}], ",", " ", 
              RowBox[{"SUNIndex", "[", "si4", "]"}]}], "]"}]}], ")"}], "/", 
      "4"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "4"], " ", 
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["li1",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["si2",
                    "TraditionalForm"],
                  "TraditionalForm"]], "(", ")"}], " ", 
            RowBox[{
              SubsuperscriptBox[
                FormBox["A",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["li2",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["si4",
                    "TraditionalForm"],
                  "TraditionalForm"]], "(", ")"}], " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox["\[PartialD]", 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], 
                  SubsuperscriptBox[
                    FormBox["A",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li2",
                        "TraditionalForm"],
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["si1",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], "(", ")"}]}], ")"}], 
        " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["si1",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["si2",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["si4",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FunctionalD", "[", 
      RowBox[{"%", ",", " ", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{"GaugeField", ",", 
                  RowBox[{"{", "\[Mu]", "}"}], ",", 
                  RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
            "     ", 
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{"GaugeField", ",", 
                  RowBox[{"{", "\[Nu]", "}"}], ",", 
                  RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", 
            "     ", 
            RowBox[{
              RowBox[{"QuantumField", "[", 
                RowBox[{"GaugeField", ",", 
                  RowBox[{"{", "\[Rho]", "}"}], ",", 
                  RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}]}], 
          "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "4"], " ", 
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["r",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["r",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li1", "\[Rho]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["c",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si2",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Nu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["b",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si4",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["li1",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox["g", 
                    RowBox[{"li2", "\[Mu]"}]], " ", 
                  SubscriptBox["\[Delta]", 
                    RowBox[{
                      FormBox[
                        FormBox["a",
                          "TraditionalForm"],
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["si1",
                          "TraditionalForm"],
                        "TraditionalForm"]}]]}], ")"}]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["si1",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["si2",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["si4",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Calc", "[", 
        RowBox[{"%", "//", "Calc"}], "]"}], "//", "Factor"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
        SubscriptBox["g", "s"], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["r",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
              SuperscriptBox[
                FormBox["r",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}]}], ")"}], " ", 
        SubscriptBox["f", 
          RowBox[{
            FormBox[
              FormBox["a",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["b",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["c",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FVD", "Section",
  CellTags->"FVD"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[
"FVD[p, \[Mu]] is the D-dimensional vector p with Lorentz index \[Mu]."], 
  "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FCE",
    ButtonData:>"FCE",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCE"],
  ", ",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  ", ",
  ButtonBox["FV",
    ButtonData:>"FV",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FV"],
  ", ",
  ButtonBox["FourVector",
    ButtonData:>"FourVector",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FourVector"],
  ", ",
  ButtonBox["Pair",
    ButtonData:>"Pair",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Pair"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FVD", "[", 
      RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["p", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FVD", "[", 
      RowBox[{
        RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox[
        RowBox[{"(", 
          FormBox[
            RowBox[{"p", "-", "q"}],
            "TraditionalForm"], ")"}], "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FVD", "[", 
        RowBox[{"p", ",", "\[Mu]"}], "]"}], "//", "InputForm"}]], "Input"],

Cell[TextData["FVD[p, \[Mu]]"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"FCI", "[", 
        RowBox[{"FVD", "[", 
          RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}], "//", "InputForm"}]], 
  "Input"],

Cell[TextData["Pair[LorentzIndex[\[Mu], D], Momentum[p, D]]"], "Output"]
}, Open  ]],

Cell["There is no special function to expand momenta in FVD.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandScalarProduct", "[", 
      RowBox[{"FVD", "[", 
        RowBox[{
          RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SuperscriptBox[
          FormBox["p",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]], "-", 
        SuperscriptBox[
          FormBox["q",
            "TraditionalForm"], 
          FormBox[
            FormBox["\[Mu]",
              "TraditionalForm"],
            "TraditionalForm"]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"InputForm", "[", "%", "]"}]], "Input"],

Cell[TextData[
"Pair[LorentzIndex[\[Mu], D], Momentum[p, D]] - \n  Pair[LorentzIndex[\[Mu], \
D], Momentum[q, D]]"], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FV", "Section",
  CellTags->"FV"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell[TextData[{
  "FV[p, \[Mu]] is the four-dimensional vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{"p", "^", "\[Mu]"}], TraditionalForm]]],
  ". "
}], "Text"],

Cell[TextData[{
  "See also: ",
  " ",
  ButtonBox["FCE",
    ButtonData:>"FCE",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCE"],
  ",",
  ButtonBox["FCI",
    ButtonData:>"FCI",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FCI"],
  ", ",
  ButtonBox["FVD",
    ButtonData:>"FVD",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FVD"],
  ", ",
  ButtonBox["FourVector",
    ButtonData:>"FourVector",
    ButtonStyle->"Hyperlink",
    ButtonNote->"FourVector"],
  ", ",
  ButtonBox["Pair",
    ButtonData:>"Pair",
    ButtonStyle->"Hyperlink",
    ButtonNote->"Pair"],
  "."
}], "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FV", "[", 
      RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input"],

Cell[BoxData[
    FormBox[
      SuperscriptBox["p", "\[Mu]"], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FV", "[", 
      RowBox[{
        RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "